//$Id: SolidItem.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
// GGE (Geant4 Geometry Editor)
// Toshiaki Kodama
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import java.io.Serializable;

abstract class SolidItem extends Object implements Serializable {
  boolean isEmpty;
  protected int solidType;
  SolidItem(int solidType){
    this.solidType = solidType;
  }
  int getSolidType(){
    return solidType;
  }
 abstract String getCPP(String name);
 abstract String getXML(String name, int i);
 abstract String getDefine(String name, int i);
}
