//$Id: ElementItem.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
// GGE (Geant4 Geometry Editor)
// Element Item
// Toshiaki Kodama
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

//MOMO
public class ElementItem extends GGEItem {
//Object {
  String name, symbol;
  int atomNum;  double massNum;
  boolean isMetal;

//MOMO
public  ElementItem(String name, String symbol, int atomNum, double massNum, boolean isMetal){
    this.name = name;
    this.symbol = symbol;
    this.atomNum = atomNum;  this.massNum = massNum;
    this.isMetal = isMetal;
  }
  String getCPP(){
    return new String("G4Element* element" +symbol+ " = new G4Element( \"" + name + "\", \"" + symbol + "\", " + atomNum + ". , " + massNum + "*g/mole );\n");
  }

  String getXML(){
    return new String("     <element name=\"" +name + "\""
			     +" formula=\"" + symbol + "\""
			     +" Z=\"" + atomNum + "\">\n"
		+"      <atom value=\"" + massNum + "\"/>\n"
		+"     </element>\n");
  }

  public String toString(){
    return symbol;
  }
}


