// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef HEPREP_HEPREPATTRIBUTE_H
#define HEPREP_HEPREPATTRIBUTE_H 1

// Copyright 2000-2005, FreeHEP.

#include <set>
#include <string>
#include <vector>

#include "HEPREP/Types.h"

#include "HEPREP/HepRepConstants.h"

namespace HEPREP {

class HepRepAttValue;

/**
 * HepRepAttribute interface.
 *
 * @author Mark Donszelmann
 */
class HepRepAttribute {

public: 
    /// Destructor.
    virtual ~HepRepAttribute() { /* nop */; }

    /**
     * Adds an attValue.
     *
     * @param attValue to be added.
     */
    virtual void addAttValue(HepRepAttValue * attValue) = 0;


    /**
     * Adds a char* attValue as a String.
     * This call should be mapped to addAttValue(std::string, std::string, int); and necessary
     * because C++ converts char* into bool and would thus call addAttValue(std::string, bool, int)
     * for a call such as addAttValue("drawAs", "Cylinder", 0);
     *
     * @param key name of attValue
     * @param value value of attValue
     * @param showLabel show this as label
     */
    virtual void addAttValue(std::string key, char* value, int showLabel = HepRepConstants::SHOW_NONE) = 0;
    /**
     * Adds an attValue.
     *
     * @param key name of attValue
     * @param value value of attValue
     * @param showLabel show this as label
     */
    virtual void addAttValue(std::string key, std::string value, int showLabel = HepRepConstants::SHOW_NONE) = 0;

    /**
     * Adds an attValue.
     *
     * @param key name of attValue
     * @param value value of attValue
     * @param showLabel show this as label
     */
    virtual void addAttValue(std::string key, int64 value, int showLabel = HepRepConstants::SHOW_NONE) = 0;

    /**
     * Adds an attValue.
     *
     * @param key name of attValue
     * @param value value of attValue
     * @param showLabel show this as label
     */
    virtual void addAttValue(std::string key, int value, int showLabel = HepRepConstants::SHOW_NONE) = 0;

    /**
     * Adds an attValue.
     *
     * @param key name of attValue
     * @param value value of attValue
     * @param showLabel show this as label
     */
    virtual void addAttValue(std::string key, double value, int showLabel = HepRepConstants::SHOW_NONE) = 0;

    /**
     * Adds an attValue.
     *
     * @param key name of attValue
     * @param value value of attValue
     * @param showLabel show this as label
     */
    virtual void addAttValue(std::string key, bool value, int showLabel = HepRepConstants::SHOW_NONE) = 0;

    /**
     * Adds a Color attValue.
     *
     * @param key name of attValue
     * @param value value of attValue
     * @param showLabel show this as label
     */
    virtual void addAttValue(std::string key, std::vector<double> value, int showLabel = HepRepConstants::SHOW_NONE) = 0;

    /**
     * Adds a Color attValue.
     *
     * @param key name of attValue
     * @param red color
     * @param green color
     * @param blue color
     * @param alpha value
     * @param showLabel show this as label
     */
    virtual void addAttValue(std::string key, double red, double green, double blue, double alpha = 1.0, int showLabel = HepRepConstants::SHOW_NONE) = 0;

    /**
     * Remove the attvalue named by key.
     *
     * @param key name of the attValue to be removed.
     * @return removed HepRepAttValue, or null if not removed.
     */
    virtual HepRepAttValue * removeAttValue(std::string key) = 0;

    /**
     * Returns the attValue specified by name. This attValue is normally searched
     * on the node itself and then on its type, moving up the typetree.
     *
     * @param name of attribute value.
     * @return attribute value.
     */
    virtual HepRepAttValue * getAttValue(std::string name) = 0;

    /**
     * Returns a collection of all attribute values from this node.
     *
     * @return collection of HepRepAttValues.
     */
    virtual std::set<HepRepAttValue *>  getAttValuesFromNode() = 0;

    /**
     * Returns a named attribute value from this node.
     *
     * @param lowerCaseName name in all lowercase.
     * @return corresponding HepRepAttValue.
     */
    virtual HepRepAttValue * getAttValueFromNode(std::string lowerCaseName) = 0;
}; // class
} // namespace HEPREP
#endif /* ifndef HEPREP_HEPREPATTRIBUTE_H */
