//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// neutron_hp -- source file
// J.P. Wellisch, Nov-1996
// A prototype of the low energy neutron transport model.
#include "G4NeutronHPFastLegendre.hh"

  const G4double G4NeutronHPFastLegendre::l30[6201] = {1, 0.855521, 0.721722,
  0.598075, 0.484073, 0.379227, 0.283065, 0.195135, 0.115001,
  0.0422439, -0.0235386, -0.0827337, -0.135713, -0.182834, -0.224438,
  -0.260855, -0.292399, -0.319373, -0.342067, -0.360756, -0.375708,
  -0.387176, -0.395402, -0.400619, -0.403049, -0.402903, -0.400384,
  -0.395683, -0.388986, -0.380465, -0.370289, -0.358615, -0.345594,
  -0.331367, -0.316072, -0.299835, -0.282779, -0.265019, -0.246663,
  -0.227814, -0.208568, -0.189016, -0.169245, -0.149335, -0.12936,
  -0.109391, -0.0894952, -0.0697328, -0.0501611, -0.0308334,
  -0.0117988, 0.00689751, 0.0252136, 0.0431113, 0.0605555, 0.0775144,
  0.0939593, 0.109864, 0.125206, 0.139964, 0.15412, 0.167658,
  0.180566, 0.192832, 0.204446, 0.215402, 0.225694, 0.235319,
  0.244274, 0.252558, 0.260174, 0.267123, 0.27341, 0.279038, 0.284014,
  0.288346, 0.292041, 0.295109, 0.297559, 0.299403, 0.300652,
  0.301318, 0.301414, 0.300953, 0.29995, 0.298419, 0.296375, 0.293833,
  0.290809, 0.287318, 0.283377, 0.279003, 0.274211, 0.26902, 0.263444,
  0.257502, 0.251211, 0.244587, 0.237648, 0.230411, 0.222892,
  0.215108, 0.207077, 0.198815, 0.190338, 0.181663, 0.172806,
  0.163783, 0.15461, 0.145302, 0.135876, 0.126345, 0.116725, 0.107031,
  0.0972765, 0.0874757, 0.0776424, 0.0677899, 0.0579315, 0.0480799,
  0.0382476, 0.0284468, 0.0186891, 0.00898619, -0.000650915,
  -0.0102114, -0.0196848, -0.0290611, -0.0383305, -0.0474836,
  -0.0565113, -0.065405, -0.0741563, -0.0827573, -0.0912002,
  -0.0994778, -0.107583, -0.115509, -0.123251, -0.130801, -0.138154,
  -0.145305, -0.152249, -0.158982, -0.165499, -0.171796, -0.177869,
  -0.183715, -0.189332, -0.194715, -0.199863, -0.204774, -0.209445,
  -0.213875, -0.218063, -0.222007, -0.225707, -0.229162, -0.232372,
  -0.235336, -0.238055, -0.240529, -0.242759, -0.244746, -0.24649,
  -0.247993, -0.249256, -0.250281, -0.251069, -0.251624, -0.251946,
  -0.252039, -0.251904, -0.251545, -0.250964, -0.250164, -0.249149,
  -0.247921, -0.246485, -0.244843, -0.242999, -0.240957, -0.238721,
  -0.236295, -0.233682, -0.230888, -0.227915, -0.224769, -0.221454,
  -0.217974, -0.214334, -0.210538, -0.206592, -0.202499, -0.198264,
  -0.193893, -0.18939, -0.184759, -0.180007, -0.175137, -0.170154,
  -0.165065, -0.159872, -0.154582, -0.149199, -0.143728, -0.138175,
  -0.132544, -0.12684, -0.121067, -0.115232, -0.109339, -0.103392,
  -0.0973962, -0.0913569, -0.0852786, -0.079166, -0.0730237,
  -0.0668565, -0.060669, -0.0544655, -0.0482508, -0.0420292,
  -0.0358052, -0.029583, -0.023367, -0.0171614, -0.0109704,
  -0.00479798, 0.00135168, 0.00747465, 0.013567, 0.019625, 0.0256448,
  0.0316226, 0.037555, 0.0434383, 0.049269, 0.0550439, 0.0607594,
  0.0664125, 0.072, 0.0775187, 0.0829657, 0.088338, 0.0936329,
  0.0988474, 0.103979, 0.109025, 0.113983, 0.118851, 0.123626,
  0.128306, 0.132889, 0.137372, 0.141754, 0.146033, 0.150207,
  0.154274, 0.158233, 0.162081, 0.165818, 0.169442, 0.172952,
  0.176346, 0.179624, 0.182784, 0.185824, 0.188746, 0.191546,
  0.194225, 0.196782, 0.199217, 0.201528, 0.203715, 0.205779,
  0.207718, 0.209532, 0.211222, 0.212787, 0.214226, 0.215541,
  0.216732, 0.217797, 0.218738, 0.219556, 0.220249, 0.22082, 0.221267,
  0.221593, 0.221797, 0.22188, 0.221844, 0.221687, 0.221413, 0.221021,
  0.220512, 0.219888, 0.21915, 0.218298, 0.217334, 0.216259, 0.215074,
  0.213781, 0.212381, 0.210875, 0.209265, 0.207552, 0.205738,
  0.203824, 0.201812, 0.199704, 0.197501, 0.195205, 0.192817,
  0.190339, 0.187774, 0.185122, 0.182387, 0.179568, 0.17667, 0.173692,
  0.170638, 0.16751, 0.164308, 0.161035, 0.157694, 0.154286, 0.150813,
  0.147278, 0.143681, 0.140027, 0.136315, 0.132549, 0.128731,
  0.124863, 0.120946, 0.116983, 0.112977, 0.108928, 0.10484, 0.100715,
  0.0965538, 0.0923594, 0.0881339, 0.0838792, 0.0795976, 0.0752912,
  0.0709619, 0.066612, 0.0622435, 0.0578584, 0.053459, 0.0490471,
  0.0446249, 0.0401944, 0.0357576, 0.0313165, 0.0268731, 0.0224295,
  0.0179875, 0.0135491, 0.00911629, 0.00469093, 0.000274936,
  -0.00412982, -0.00852148, -0.0128982, -0.0172582, -0.0215996,
  -0.0259207, -0.0302197, -0.0344948, -0.0387445, -0.042967,
  -0.0471605, -0.0513236, -0.0554546, -0.0595519, -0.0636139,
  -0.0676391, -0.0716261, -0.0755732, -0.0794792, -0.0833424,
  -0.0871617, -0.0909355, -0.0946626, -0.0983416, -0.101971, -0.10555,
  -0.109078, -0.112552, -0.115972, -0.119337, -0.122645, -0.125896,
  -0.129088, -0.132221, -0.135293, -0.138304, -0.141253, -0.144138,
  -0.146959, -0.149715, -0.152406, -0.15503, -0.157586, -0.160075,
  -0.162495, -0.164846, -0.167127, -0.169338, -0.171478, -0.173546,
  -0.175543, -0.177467, -0.179318, -0.181096, -0.182801, -0.184431,
  -0.185988, -0.18747, -0.188877, -0.19021, -0.191467, -0.192649,
  -0.193756, -0.194788, -0.195744, -0.196624, -0.197429, -0.198159,
  -0.198813, -0.199392, -0.199895, -0.200323, -0.200677, -0.200955,
  -0.201159, -0.201289, -0.201345, -0.201327, -0.201235, -0.20107,
  -0.200833, -0.200523, -0.200141, -0.199688, -0.199164, -0.198569,
  -0.197904, -0.19717, -0.196366, -0.195494, -0.194554, -0.193547,
  -0.192473, -0.191334, -0.190129, -0.188859, -0.187526, -0.186129,
  -0.18467, -0.183149, -0.181567, -0.179925, -0.178224, -0.176464,
  -0.174647, -0.172773, -0.170843, -0.168858, -0.166818, -0.164725,
  -0.16258, -0.160384, -0.158137, -0.155841, -0.153496, -0.151103,
  -0.148664, -0.14618, -0.143651, -0.141078, -0.138463, -0.135806,
  -0.133109, -0.130372, -0.127597, -0.124785, -0.121937, -0.119053,
  -0.116136, -0.113185, -0.110203, -0.10719, -0.104147, -0.101076,
  -0.0979773, -0.0948523, -0.091702, -0.0885275, -0.0853301,
  -0.0821108, -0.0788708, -0.0756111, -0.0723329, -0.0690373,
  -0.0657254, -0.0623984, -0.0590573, -0.0557033, -0.0523374,
  -0.0489609, -0.0455747, -0.0421801, -0.0387781, -0.0353698,
  -0.0319563, -0.0285387, -0.0251181, -0.0216955, -0.0182721,
  -0.014849, -0.0114271, -0.00800753, -0.00459138, -0.00117969,
  0.00222652, 0.0056262, 0.00901834, 0.0124019, 0.0157759, 0.0191393,
  0.0224911, 0.0258304, 0.0291561, 0.0324673, 0.0357631, 0.0390424,
  0.0423044, 0.045548, 0.0487725, 0.0519769, 0.0551602, 0.0583216,
  0.0614603, 0.0645753, 0.0676658, 0.070731, 0.0737699, 0.0767819,
  0.0797661, 0.0827217, 0.0856479, 0.0885439, 0.0914091, 0.0942426,
  0.0970437, 0.0998116, 0.102546, 0.105245, 0.10791, 0.110539,
  0.113131, 0.115686, 0.118203, 0.120682, 0.123122, 0.125522,
  0.127882, 0.130202, 0.13248, 0.134716, 0.136911, 0.139062, 0.14117,
  0.143235, 0.145255, 0.147231, 0.149162, 0.151047, 0.152887, 0.15468,
  0.156427, 0.158126, 0.159779, 0.161384, 0.162941, 0.16445, 0.16591,
  0.167322, 0.168685, 0.169998, 0.171262, 0.172477, 0.173641,
  0.174756, 0.175821, 0.176835, 0.177799, 0.178712, 0.179575,
  0.180387, 0.181148, 0.181858, 0.182518, 0.183126, 0.183684, 0.18419,
  0.184646, 0.185051, 0.185405, 0.185708, 0.18596, 0.186162, 0.186313,
  0.186413, 0.186463, 0.186463, 0.186413, 0.186313, 0.186163,
  0.185964, 0.185715, 0.185417, 0.18507, 0.184675, 0.184231, 0.183738,
  0.183198, 0.18261, 0.181974, 0.181292, 0.180563, 0.179787, 0.178965,
  0.178097, 0.177184, 0.176226, 0.175223, 0.174176, 0.173084, 0.17195,
  0.170772, 0.169551, 0.168289, 0.166984, 0.165638, 0.164251,
  0.162824, 0.161357, 0.15985, 0.158305, 0.156721, 0.155099, 0.153439,
  0.151743, 0.15001, 0.148241, 0.146437, 0.144598, 0.142725, 0.140819,
  0.138879, 0.136907, 0.134902, 0.132867, 0.130801, 0.128704,
  0.126578, 0.124423, 0.12224, 0.120029, 0.117792, 0.115527, 0.113237,
  0.110922, 0.108582, 0.106218, 0.103831, 0.101421, 0.0989895,
  0.0965366, 0.0940631, 0.0915695, 0.0890567, 0.0865252, 0.0839757,
  0.0814089, 0.0788254, 0.076226, 0.0736112, 0.0709819, 0.0683385,
  0.0656819, 0.0630127, 0.0603316, 0.0576392, 0.0549362, 0.0522234,
  0.0495013, 0.0467707, 0.0440322, 0.0412865, 0.0385344, 0.0357764,
  0.0330132, 0.0302455, 0.027474, 0.0246994, 0.0219222, 0.0191433,
  0.0163632, 0.0135826, 0.0108021, 0.00802247, 0.0052443, 0.00246826,
  -0.000305014, -0.00307487, -0.00584067, -0.00860177, -0.0113575,
  -0.0141074, -0.0168506, -0.0195866, -0.0223147, -0.0250344,
  -0.0277451, -0.0304461, -0.0331368, -0.0358166, -0.0384849,
  -0.0411412, -0.0437848, -0.0464153, -0.0490319, -0.0516341,
  -0.0542214, -0.0567933, -0.059349, -0.0618882, -0.0644102,
  -0.0669146, -0.0694008, -0.0718682, -0.0743164, -0.0767448,
  -0.079153, -0.0815403, -0.0839065, -0.0862509, -0.088573,
  -0.0908725, -0.0931488, -0.0954014, -0.09763, -0.0998341, -0.102013,
  -0.104167, -0.106295, -0.108396, -0.110471, -0.112519, -0.11454,
  -0.116532, -0.118497, -0.120433, -0.122339, -0.124217, -0.126065,
  -0.127883, -0.12967, -0.131427, -0.133153, -0.134847, -0.13651,
  -0.138141, -0.13974, -0.141306, -0.14284, -0.14434, -0.145808,
  -0.147241, -0.148641, -0.150007, -0.151339, -0.152637, -0.153899,
  -0.155127, -0.15632, -0.157478, -0.1586, -0.159687, -0.160738,
  -0.161753, -0.162732, -0.163675, -0.164582, -0.165453, -0.166286,
  -0.167084, -0.167844, -0.168568, -0.169255, -0.169906, -0.170519,
  -0.171095, -0.171634, -0.172136, -0.172601, -0.173028, -0.173419,
  -0.173772, -0.174089, -0.174368, -0.174609, -0.174814, -0.174982,
  -0.175112, -0.175206, -0.175263, -0.175283, -0.175266, -0.175212,
  -0.175122, -0.174995, -0.174831, -0.174632, -0.174396, -0.174124,
  -0.173816, -0.173472, -0.173093, -0.172678, -0.172228, -0.171742,
  -0.171222, -0.170666, -0.170076, -0.169451, -0.168793, -0.1681,
  -0.167373, -0.166612, -0.165818, -0.164991, -0.164131, -0.163238,
  -0.162313, -0.161355, -0.160366, -0.159345, -0.158292, -0.157208,
  -0.156093, -0.154948, -0.153772, -0.152567, -0.151331, -0.150067,
  -0.148773, -0.14745, -0.146099, -0.14472, -0.143313, -0.141879,
  -0.140417, -0.138929, -0.137414, -0.135874, -0.134307, -0.132715,
  -0.131098, -0.129457, -0.127791, -0.126102, -0.124389, -0.122653,
  -0.120894, -0.119113, -0.11731, -0.115485, -0.11364, -0.111773,
  -0.109887, -0.10798, -0.106054, -0.104109, -0.102145, -0.100163,
  -0.0981631, -0.0961458, -0.0941115, -0.0920608, -0.0899939,
  -0.0879113, -0.0858135, -0.0837009, -0.081574, -0.0794331,
  -0.0772787, -0.0751113, -0.0729313, -0.0707391, -0.0685353,
  -0.0663202, -0.0640942, -0.061858, -0.0596118, -0.0573561,
  -0.0550914, -0.0528182, -0.0505369, -0.0482479, -0.0459517,
  -0.0436487, -0.0413395, -0.0390244, -0.036704, -0.0343786,
  -0.0320487, -0.0297147, -0.0273772, -0.0250366, -0.0226932,
  -0.0203477, -0.0180003, -0.0156517, -0.0133021, -0.0109521,
  -0.00860205, -0.00625248, -0.0039038, -0.00155644, 0.000789146,
  0.00313253, 0.00547327, 0.00781093, 0.0101451, 0.0124753, 0.0148011,
  0.0171222, 0.019438, 0.0217482, 0.0240523, 0.0263499, 0.0286406,
  0.030924, 0.0331997, 0.0354672, 0.0377261, 0.0399762, 0.0422168,
  0.0444477, 0.0466685, 0.0488787, 0.051078, 0.053266, 0.0554422,
  0.0576064, 0.0597581, 0.061897, 0.0640227, 0.0661348, 0.0682329,
  0.0703168, 0.072386, 0.0744401, 0.0764789, 0.078502, 0.0805091,
  0.0824997, 0.0844737, 0.0864305, 0.08837, 0.0902917, 0.0921955,
  0.0940809, 0.0959476, 0.0977953, 0.0996238, 0.101433, 0.103222,
  0.104991, 0.106739, 0.108467, 0.110174, 0.111859, 0.113523,
  0.115165, 0.116785, 0.118383, 0.119958, 0.121511, 0.12304, 0.124546,
  0.126029, 0.127487, 0.128922, 0.130333, 0.131719, 0.133081,
  0.134417, 0.135729, 0.137016, 0.138277, 0.139513, 0.140723,
  0.141907, 0.143064, 0.144196, 0.145301, 0.14638, 0.147432, 0.148457,
  0.149455, 0.150426, 0.15137, 0.152286, 0.153175, 0.154036, 0.15487,
  0.155676, 0.156453, 0.157203, 0.157925, 0.158618, 0.159284,
  0.159921, 0.160529, 0.161109, 0.161661, 0.162184, 0.162679,
  0.163144, 0.163581, 0.16399, 0.164369, 0.16472, 0.165042, 0.165336,
  0.1656, 0.165836, 0.166043, 0.166221, 0.16637, 0.166491, 0.166583,
  0.166646, 0.16668, 0.166686, 0.166663, 0.166612, 0.166532, 0.166424,
  0.166287, 0.166122, 0.165929, 0.165708, 0.165458, 0.165181,
  0.164876, 0.164543, 0.164182, 0.163793, 0.163377, 0.162934,
  0.162463, 0.161965, 0.16144, 0.160888, 0.16031, 0.159704, 0.159072,
  0.158414, 0.15773, 0.15702, 0.156283, 0.155521, 0.154734, 0.153921,
  0.153082, 0.152219, 0.151331, 0.150418, 0.149481, 0.148519,
  0.147533, 0.146524, 0.14549, 0.144433, 0.143353, 0.14225, 0.141124,
  0.139975, 0.138804, 0.13761, 0.136395, 0.135158, 0.133899, 0.132619,
  0.131318, 0.129997, 0.128654, 0.127292, 0.125909, 0.124507,
  0.123085, 0.121644, 0.120184, 0.118706, 0.117208, 0.115693, 0.11416,
  0.112609, 0.11104, 0.109455, 0.107853, 0.106234, 0.104599, 0.102948,
  0.101282, 0.0996002, 0.0979033, 0.0961917, 0.0944656, 0.0927254,
  0.0909712, 0.0892036, 0.0874227, 0.0856288, 0.0838223, 0.0820035,
  0.0801726, 0.0783301, 0.0764761, 0.0746111, 0.0727353, 0.070849,
  0.0689527, 0.0670465, 0.0651308, 0.063206, 0.0612722, 0.05933,
  0.0573796, 0.0554212, 0.0534554, 0.0514822, 0.0495022, 0.0475156,
  0.0455227, 0.0435238, 0.0415194, 0.0395097, 0.037495, 0.0354757,
  0.0334521, 0.0314245, 0.0293933, 0.0273587, 0.0253211, 0.0232809,
  0.0212383, 0.0191937, 0.0171474, 0.0150998, 0.0130511, 0.0110017,
  0.00895187, 0.00690199, 0.00485236, 0.0028033, 0.00075514,
  -0.00129181, -0.00333722, -0.00538078, -0.00742217, -0.00946107,
  -0.0114972, -0.0135302, -0.0155597, -0.0175855, -0.0196072,
  -0.0216246, -0.0236373, -0.0256451, -0.0276475, -0.0296443,
  -0.0316353, -0.03362, -0.0355983, -0.0375697, -0.039534, -0.041491,
  -0.0434403, -0.0453816, -0.0473146, -0.0492391, -0.0511547,
  -0.0530612, -0.0549583, -0.0568457, -0.0587232, -0.0605904,
  -0.062447, -0.0642929, -0.0661278, -0.0679512, -0.0697631,
  -0.0715632, -0.0733511, -0.0751266, -0.0768895, -0.0786395,
  -0.0803764, -0.0820999, -0.0838097, -0.0855056, -0.0871875,
  -0.0888549, -0.0905078, -0.0921458, -0.0937688, -0.0953765,
  -0.0969686, -0.098545, -0.100105, -0.10165, -0.103178, -0.104689,
  -0.106183, -0.107661, -0.109121, -0.110564, -0.111989, -0.113396,
  -0.114786, -0.116157, -0.11751, -0.118844, -0.120159, -0.121456,
  -0.122734, -0.123992, -0.125231, -0.12645, -0.127649, -0.128829,
  -0.129989, -0.131128, -0.132247, -0.133346, -0.134423, -0.135481,
  -0.136517, -0.137532, -0.138526, -0.139499, -0.14045, -0.14138,
  -0.142288, -0.143175, -0.144039, -0.144882, -0.145703, -0.146501,
  -0.147278, -0.148032, -0.148763, -0.149472, -0.150159, -0.150822,
  -0.151464, -0.152082, -0.152677, -0.15325, -0.1538, -0.154326,
  -0.15483, -0.15531, -0.155767, -0.156201, -0.156612, -0.157,
  -0.157364, -0.157705, -0.158022, -0.158316, -0.158587, -0.158835,
  -0.159058, -0.159259, -0.159436, -0.15959, -0.15972, -0.159827,
  -0.15991, -0.15997, -0.160007, -0.16002, -0.16001, -0.159977,
  -0.15992, -0.15984, -0.159737, -0.159611, -0.159462, -0.15929,
  -0.159094, -0.158876, -0.158635, -0.158371, -0.158084, -0.157775,
  -0.157442, -0.157088, -0.156711, -0.156311, -0.155889, -0.155445,
  -0.154979, -0.15449, -0.15398, -0.153448, -0.152894, -0.152318,
  -0.151721, -0.151102, -0.150462, -0.149801, -0.149118, -0.148415,
  -0.147691, -0.146946, -0.14618, -0.145394, -0.144588, -0.143761,
  -0.142915, -0.142048, -0.141162, -0.140256, -0.13933, -0.138386,
  -0.137422, -0.136439, -0.135437, -0.134416, -0.133377, -0.13232,
  -0.131244, -0.13015, -0.129039, -0.12791, -0.126763, -0.125599,
  -0.124418, -0.12322, -0.122005, -0.120773, -0.119526, -0.118262,
  -0.116982, -0.115686, -0.114375, -0.113048, -0.111706, -0.110349,
  -0.108977, -0.107591, -0.10619, -0.104775, -0.103346, -0.101904,
  -0.100448, -0.0989782, -0.0974957, -0.0960004, -0.0944924,
  -0.0929721, -0.0914395, -0.0898949, -0.0883387, -0.0867709,
  -0.0851918, -0.0836017, -0.0820008, -0.0803892, -0.0787674,
  -0.0771354, -0.0754935, -0.073842, -0.0721811, -0.0705111,
  -0.0688321, -0.0671444, -0.0654483, -0.063744, -0.0620317,
  -0.0603117, -0.0585843, -0.0568496, -0.055108, -0.0533596,
  -0.0516048, -0.0498437, -0.0480767, -0.0463039, -0.0445256,
  -0.0427421, -0.0409536, -0.0391604, -0.0373627, -0.0355607,
  -0.0337548, -0.0319451, -0.030132, -0.0283156, -0.0264963,
  -0.0246742, -0.0228496, -0.0210228, -0.0191941, -0.0173636,
  -0.0155317, -0.0136985, -0.0118643, -0.0100295, -0.00819416,
  -0.00635861, -0.0045231, -0.00268786, -0.000853149, 0.000980785,
  0.00281369, 0.00464533, 0.00647545, 0.00830381, 0.0101302,
  0.0119542, 0.0137758, 0.0155947, 0.0174105, 0.0192232, 0.0210323,
  0.0228378, 0.0246393, 0.0264366, 0.0282295, 0.0300177, 0.031801,
  0.0335792, 0.035352, 0.0371192, 0.0388806, 0.0406359, 0.042385,
  0.0441275, 0.0458632, 0.047592, 0.0493135, 0.0510277, 0.0527342,
  0.0544328, 0.0561233, 0.0578056, 0.0594793, 0.0611443, 0.0628003,
  0.0644471, 0.0660846, 0.0677125, 0.0693306, 0.0709387, 0.0725366,
  0.0741241, 0.075701, 0.0772671, 0.0788222, 0.0803661, 0.0818985,
  0.0834194, 0.0849285, 0.0864257, 0.0879107, 0.0893833, 0.0908435,
  0.0922909, 0.0937254, 0.0951469, 0.0965551, 0.09795, 0.0993312,
  0.100699, 0.102052, 0.103392, 0.104717, 0.106028, 0.107324,
  0.108606, 0.109872, 0.111124, 0.11236, 0.113581, 0.114787, 0.115977,
  0.117151, 0.118309, 0.119452, 0.120578, 0.121687, 0.122781,
  0.123857, 0.124917, 0.125961, 0.126987, 0.127996, 0.128988,
  0.129963, 0.13092, 0.13186, 0.132782, 0.133687, 0.134573, 0.135442,
  0.136293, 0.137125, 0.13794, 0.138736, 0.139514, 0.140273, 0.141013,
  0.141736, 0.142439, 0.143123, 0.143789, 0.144436, 0.145064,
  0.145672, 0.146262, 0.146832, 0.147383, 0.147915, 0.148428,
  0.148921, 0.149395, 0.149849, 0.150283, 0.150699, 0.151094, 0.15147,
  0.151826, 0.152163, 0.152479, 0.152777, 0.153054, 0.153311,
  0.153549, 0.153767, 0.153965, 0.154143, 0.154301, 0.15444, 0.154559,
  0.154657, 0.154736, 0.154796, 0.154835, 0.154854, 0.154854,
  0.154834, 0.154794, 0.154735, 0.154655, 0.154556, 0.154438,
  0.154299, 0.154142, 0.153964, 0.153767, 0.153551, 0.153315, 0.15306,
  0.152785, 0.152491, 0.152178, 0.151846, 0.151494, 0.151124,
  0.150734, 0.150326, 0.149899, 0.149452, 0.148988, 0.148504,
  0.148002, 0.147481, 0.146942, 0.146385, 0.14581, 0.145216, 0.144604,
  0.143974, 0.143326, 0.142661, 0.141978, 0.141277, 0.140559,
  0.139823, 0.13907, 0.1383, 0.137513, 0.136709, 0.135888, 0.13505,
  0.134196, 0.133325, 0.132438, 0.131534, 0.130615, 0.129679,
  0.128728, 0.127761, 0.126778, 0.12578, 0.124767, 0.123738, 0.122695,
  0.121636, 0.120563, 0.119475, 0.118373, 0.117256, 0.116125, 0.11498,
  0.113822, 0.112649, 0.111463, 0.110264, 0.109051, 0.107826,
  0.106587, 0.105336, 0.104072, 0.102796, 0.101507, 0.100207,
  0.0988942, 0.0975699, 0.0962341, 0.0948868, 0.0935284, 0.0921589,
  0.0907786, 0.0893876, 0.0879861, 0.0865742, 0.0851522, 0.0837203,
  0.0822786, 0.0808272, 0.0793665, 0.0778966, 0.0764176, 0.0749298,
  0.0734334, 0.0719284, 0.0704152, 0.068894, 0.0673648, 0.0658279,
  0.0642836, 0.0627319, 0.0611731, 0.0596074, 0.058035, 0.0564561,
  0.0548709, 0.0532795, 0.0516822, 0.0500792, 0.0484706, 0.0468567,
  0.0452377, 0.0436138, 0.0419852, 0.040352, 0.0387145, 0.0370729,
  0.0354274, 0.0337782, 0.0321254, 0.0304694, 0.0288103, 0.0271482,
  0.0254835, 0.0238163, 0.0221468, 0.0204752, 0.0188017, 0.0171266,
  0.01545, 0.0137722, 0.0120932, 0.0104135, 0.00873302, 0.00705214,
  0.00537101, 0.00368985, 0.00200884, 0.000328194, -0.00135188,
  -0.00303119, -0.00470953, -0.0063867, -0.00806249, -0.00973672,
  -0.0114092, -0.0130796, -0.0147479, -0.0164139, -0.0180772,
  -0.0197378, -0.0213954, -0.0230499, -0.0247009, -0.0263485,
  -0.0279923, -0.0296321, -0.0312678, -0.0328991, -0.034526,
  -0.0361481, -0.0377653, -0.0393774, -0.0409843, -0.0425856,
  -0.0441813, -0.0457711, -0.0473549, -0.0489325, -0.0505037,
  -0.0520683, -0.0536261, -0.0551769, -0.0567207, -0.0582571,
  -0.059786, -0.0613073, -0.0628207, -0.0643261, -0.0658233,
  -0.0673122, -0.0687925, -0.0702641, -0.0717269, -0.0731806,
  -0.0746251, -0.0760602, -0.0774858, -0.0789017, -0.0803078,
  -0.0817038, -0.0830896, -0.0844651, -0.0858302, -0.0871845,
  -0.0885281, -0.0898607, -0.0911823, -0.0924925, -0.0937914,
  -0.0950787, -0.0963544, -0.0976182, -0.0988701, -0.10011, -0.101337,
  -0.102552, -0.103755, -0.104945, -0.106122, -0.107286, -0.108438,
  -0.109576, -0.1107, -0.111812, -0.112909, -0.113994, -0.115064,
  -0.11612, -0.117163, -0.118191, -0.119205, -0.120205, -0.12119,
  -0.122161, -0.123117, -0.124058, -0.124985, -0.125896, -0.126793,
  -0.127674, -0.12854, -0.129391, -0.130226, -0.131046, -0.13185,
  -0.132638, -0.133411, -0.134168, -0.134909, -0.135634, -0.136343,
  -0.137035, -0.137712, -0.138372, -0.139016, -0.139643, -0.140254,
  -0.140849, -0.141426, -0.141988, -0.142532, -0.14306, -0.143571,
  -0.144065, -0.144542, -0.145002, -0.145445, -0.145871, -0.14628,
  -0.146672, -0.147047, -0.147404, -0.147745, -0.148068, -0.148374,
  -0.148663, -0.148934, -0.149188, -0.149424, -0.149644, -0.149846,
  -0.15003, -0.150197, -0.150347, -0.150479, -0.150594, -0.150691,
  -0.150771, -0.150834, -0.150879, -0.150907, -0.150917, -0.15091,
  -0.150885, -0.150844, -0.150784, -0.150708, -0.150614, -0.150503,
  -0.150374, -0.150229, -0.150066, -0.149886, -0.149688, -0.149474,
  -0.149242, -0.148994, -0.148728, -0.148446, -0.148146, -0.14783,
  -0.147497, -0.147147, -0.14678, -0.146396, -0.145996, -0.14558,
  -0.145146, -0.144697, -0.144231, -0.143748, -0.143249, -0.142735,
  -0.142203, -0.141656, -0.141093, -0.140514, -0.139919, -0.139308,
  -0.138682, -0.13804, -0.137382, -0.136709, -0.136021, -0.135317,
  -0.134599, -0.133865, -0.133116, -0.132352, -0.131573, -0.13078,
  -0.129972, -0.129149, -0.128312, -0.127461, -0.126595, -0.125716,
  -0.124822, -0.123915, -0.122993, -0.122058, -0.12111, -0.120148,
  -0.119173, -0.118184, -0.117183, -0.116168, -0.115141, -0.114101,
  -0.113048, -0.111983, -0.110905, -0.109816, -0.108714, -0.1076,
  -0.106474, -0.105337, -0.104188, -0.103028, -0.101857, -0.100674,
  -0.0994803, -0.0982758, -0.0970605, -0.0958347, -0.0945985,
  -0.0933519, -0.0920952, -0.0908285, -0.089552, -0.0882657,
  -0.0869699, -0.0856647, -0.0843503, -0.0830267, -0.0816942,
  -0.0803529, -0.079003, -0.0776446, -0.0762778, -0.0749029, -0.07352,
  -0.0721293, -0.0707308, -0.0693248, -0.0679115, -0.0664909,
  -0.0650633, -0.0636288, -0.0621876, -0.0607398, -0.0592857,
  -0.0578253, -0.0563589, -0.0548865, -0.0534085, -0.0519249,
  -0.0504359, -0.0489417, -0.0474424, -0.0459382, -0.0444294,
  -0.042916, -0.0413982, -0.0398762, -0.0383502, -0.0368204,
  -0.0352868, -0.0337498, -0.0322094, -0.0306658, -0.0291192,
  -0.0275698, -0.0260178, -0.0244633, -0.0229065, -0.0213475,
  -0.0197866, -0.0182239, -0.0166596, -0.0150939, -0.0135269,
  -0.0119588, -0.0103898, -0.00882012, -0.00724983, -0.00567914,
  -0.00410824, -0.00253729, -0.000966467, 0.000604052, 0.0021741,
  0.00374349, 0.00531207, 0.00687965, 0.00844607, 0.0100112,
  0.0115747, 0.0131366, 0.0146967, 0.0162547, 0.0178105, 0.019364,
  0.0209149, 0.0224632, 0.0240086, 0.0255509, 0.02709, 0.0286258,
  0.030158, 0.0316865, 0.0332112, 0.0347318, 0.0362482, 0.0377602,
  0.0392677, 0.0407705, 0.0422685, 0.0437615, 0.0452492, 0.0467317,
  0.0482086, 0.0496799, 0.0511454, 0.0526049, 0.0540583, 0.0555054,
  0.056946, 0.0583801, 0.0598074, 0.0612278, 0.0626412, 0.0640474,
  0.0654462, 0.0668375, 0.0682212, 0.0695971, 0.070965, 0.0723249,
  0.0736765, 0.0750198, 0.0763545, 0.0776806, 0.0789979, 0.0803063,
  0.0816056, 0.0828957, 0.0841764, 0.0854476, 0.0867093, 0.0879612,
  0.0892032, 0.0904352, 0.0916571, 0.0928687, 0.0940699, 0.0952606,
  0.0964407, 0.09761, 0.0987684, 0.0999158, 0.101052, 0.102177,
  0.103291, 0.104393, 0.105484, 0.106563, 0.10763, 0.108685, 0.109728,
  0.110759, 0.111778, 0.112784, 0.113778, 0.11476, 0.115729, 0.116685,
  0.117628, 0.118558, 0.119475, 0.120379, 0.12127, 0.122148, 0.123012,
  0.123863, 0.1247, 0.125523, 0.126333, 0.127129, 0.127911, 0.128679,
  0.129433, 0.130173, 0.130898, 0.13161, 0.132307, 0.132989, 0.133657,
  0.134311, 0.13495, 0.135574, 0.136184, 0.136779, 0.137359, 0.137924,
  0.138474, 0.139009, 0.139529, 0.140034, 0.140524, 0.140999,
  0.141458, 0.141902, 0.142331, 0.142744, 0.143142, 0.143525,
  0.143892, 0.144243, 0.14458, 0.1449, 0.145205, 0.145494, 0.145768,
  0.146026, 0.146268, 0.146495, 0.146706, 0.146901, 0.14708, 0.147244,
  0.147392, 0.147524, 0.14764, 0.147741, 0.147825, 0.147894, 0.147947,
  0.147985, 0.148006, 0.148012, 0.148002, 0.147976, 0.147935,
  0.147877, 0.147804, 0.147715, 0.147611, 0.147491, 0.147355,
  0.147203, 0.147036, 0.146853, 0.146655, 0.146441, 0.146212,
  0.145967, 0.145706, 0.145431, 0.145139, 0.144833, 0.144511,
  0.144174, 0.143821, 0.143454, 0.143071, 0.142673, 0.142261,
  0.141833, 0.14139, 0.140932, 0.14046, 0.139973, 0.139471, 0.138954,
  0.138423, 0.137877, 0.137317, 0.136742, 0.136153, 0.135549,
  0.134932, 0.1343, 0.133654, 0.132995, 0.132321, 0.131634, 0.130932,
  0.130217, 0.129489, 0.128747, 0.127991, 0.127223, 0.12644, 0.125645,
  0.124837, 0.124015, 0.123181, 0.122334, 0.121474, 0.120602,
  0.119717, 0.11882, 0.11791, 0.116988, 0.116054, 0.115108, 0.11415,
  0.11318, 0.112199, 0.111205, 0.110201, 0.109185, 0.108158, 0.107119,
  0.10607, 0.105009, 0.103938, 0.102856, 0.101764, 0.100661,
  0.0995474, 0.0984239, 0.0972903, 0.0961467, 0.0949932, 0.09383,
  0.0926572, 0.0914749, 0.0902833, 0.0890824, 0.0878725, 0.0866536,
  0.0854258, 0.0841894, 0.0829443, 0.0816909, 0.0804291, 0.0791592,
  0.0778812, 0.0765953, 0.0753017, 0.0740005, 0.0726917, 0.0713756,
  0.0700524, 0.068722, 0.0673848, 0.0660407, 0.06469, 0.0633328,
  0.0619693, 0.0605996, 0.0592237, 0.057842, 0.0564545, 0.0550614,
  0.0536628, 0.0522589, 0.0508498, 0.0494356, 0.0480166, 0.0465928,
  0.0451645, 0.0437317, 0.0422946, 0.0408534, 0.0394082, 0.0379592,
  0.0365064, 0.0350502, 0.0335906, 0.0321277, 0.0306618, 0.029193,
  0.0277214, 0.0262472, 0.0247705, 0.0232915, 0.0218104, 0.0203272,
  0.0188423, 0.0173556, 0.0158674, 0.0143778, 0.012887, 0.0113952,
  0.00990239, 0.00840885, 0.00691469, 0.00542009, 0.00392519,
  0.00243014, 0.000935111, -0.000559755, -0.0020543, -0.00354837,
  -0.00504182, -0.00653448, -0.0080262, -0.00951683, -0.0110062,
  -0.0124942, -0.0139807, -0.0154654, -0.0169483, -0.0184292,
  -0.0199079, -0.0213843, -0.0228583, -0.0243296, -0.0257982,
  -0.0272639, -0.0287265, -0.0301859, -0.0316419, -0.0330944,
  -0.0345433, -0.0359883, -0.0374294, -0.0388664, -0.0402992,
  -0.0417276, -0.0431514, -0.0445705, -0.0459848, -0.0473942,
  -0.0487984, -0.0501974, -0.051591, -0.052979, -0.0543614,
  -0.0557379, -0.0571085, -0.058473, -0.0598313, -0.0611832,
  -0.0625285, -0.0638673, -0.0651992, -0.0665243, -0.0678423,
  -0.0691531, -0.0704566, -0.0717526, -0.0730411, -0.0743219,
  -0.0755948, -0.0768598, -0.0781167, -0.0793654, -0.0806058,
  -0.0818377, -0.083061, -0.0842756, -0.0854814, -0.0866782,
  -0.087866, -0.0890446, -0.0902139, -0.0913737, -0.0925241,
  -0.0936647, -0.0947956, -0.0959167, -0.0970277, -0.0981287,
  -0.0992194, -0.1003, -0.10137, -0.102429, -0.103478, -0.104516,
  -0.105544, -0.10656, -0.107565, -0.108559, -0.109542, -0.110514,
  -0.111474, -0.112423, -0.11336, -0.114285, -0.115199, -0.1161,
  -0.11699, -0.117868, -0.118733, -0.119586, -0.120427, -0.121256,
  -0.122072, -0.122875, -0.123666, -0.124444, -0.12521, -0.125962,
  -0.126702, -0.127428, -0.128142, -0.128842, -0.129529, -0.130203,
  -0.130864, -0.131511, -0.132145, -0.132765, -0.133371, -0.133964,
  -0.134543, -0.135109, -0.135661, -0.136198, -0.136722, -0.137232,
  -0.137728, -0.13821, -0.138678, -0.139132, -0.139571, -0.139996,
  -0.140407, -0.140804, -0.141186, -0.141555, -0.141908, -0.142247,
  -0.142572, -0.142882, -0.143178, -0.143459, -0.143726, -0.143978,
  -0.144215, -0.144438, -0.144646, -0.14484, -0.145019, -0.145183,
  -0.145332, -0.145467, -0.145587, -0.145692, -0.145782, -0.145858,
  -0.145919, -0.145965, -0.145997, -0.146013, -0.146015, -0.146003,
  -0.145975, -0.145933, -0.145876, -0.145804, -0.145718, -0.145617,
  -0.145501, -0.14537, -0.145225, -0.145066, -0.144891, -0.144702,
  -0.144499, -0.144281, -0.144048, -0.143801, -0.14354, -0.143264,
  -0.142974, -0.142669, -0.14235, -0.142017, -0.141669, -0.141308,
  -0.140932, -0.140542, -0.140138, -0.139719, -0.139287, -0.138841,
  -0.138381, -0.137907, -0.13742, -0.136918, -0.136403, -0.135874,
  -0.135332, -0.134776, -0.134206, -0.133624, -0.133028, -0.132418,
  -0.131796, -0.13116, -0.130511, -0.129849, -0.129174, -0.128486,
  -0.127786, -0.127073, -0.126347, -0.125608, -0.124857, -0.124094,
  -0.123318, -0.12253, -0.12173, -0.120918, -0.120093, -0.119257,
  -0.118409, -0.117549, -0.116677, -0.115794, -0.1149, -0.113994,
  -0.113076, -0.112148, -0.111208, -0.110258, -0.109296, -0.108324,
  -0.107341, -0.106347, -0.105343, -0.104328, -0.103303, -0.102268,
  -0.101223, -0.100167, -0.0991021, -0.0980272, -0.0969426,
  -0.0958485, -0.0947449, -0.0936319, -0.0925098, -0.0913785,
  -0.0902383, -0.0890891, -0.0879313, -0.0867647, -0.0855897,
  -0.0844062, -0.0832145, -0.0820146, -0.0808066, -0.0795907,
  -0.0783671, -0.0771357, -0.0758968, -0.0746505, -0.0733969,
  -0.0721361, -0.0708682, -0.0695935, -0.0683119, -0.0670237,
  -0.0657289, -0.0644278, -0.0631204, -0.0618068, -0.0604872,
  -0.0591618, -0.0578306, -0.0564938, -0.0551515, -0.0538039,
  -0.0524511, -0.0510932, -0.0497304, -0.0483627, -0.0469904,
  -0.0456136, -0.0442324, -0.042847, -0.0414574, -0.0400639,
  -0.0386666, -0.0372655, -0.0358609, -0.0344529, -0.0330416,
  -0.0316272, -0.0302098, -0.0287895, -0.0273665, -0.025941,
  -0.024513, -0.0230828, -0.0216504, -0.020216, -0.0187798,
  -0.0173418, -0.0159023, -0.0144613, -0.0130191, -0.0115757,
  -0.0101313, -0.0086861, -0.00724015, -0.00579363, -0.00434669,
  -0.00289946, -0.00145209, -4.72955e-06, 0.00144249, 0.00288941,
  0.00433591, 0.00578183, 0.00722703, 0.00867137, 0.0101147,
  0.0115569, 0.0129978, 0.0144373, 0.0158752, 0.0173113, 0.0187457,
  0.020178, 0.0216082, 0.0230361, 0.0244616, 0.0258845, 0.0273048,
  0.0287221, 0.0301366, 0.0315479, 0.0329559, 0.0343605, 0.0357616,
  0.0371591, 0.0385527, 0.0399424, 0.041328, 0.0427094, 0.0440865,
  0.045459, 0.0468269, 0.0481901, 0.0495484, 0.0509017, 0.0522498,
  0.0535926, 0.05493, 0.0562619, 0.0575881, 0.0589084, 0.0602229,
  0.0615312, 0.0628334, 0.0641293, 0.0654187, 0.0667015, 0.0679777,
  0.069247, 0.0705094, 0.0717647, 0.0730128, 0.0742536, 0.075487,
  0.0767128, 0.0779309, 0.0791413, 0.0803437, 0.0815381, 0.0827244,
  0.0839024, 0.0850721, 0.0862332, 0.0873858, 0.0885297, 0.0896647,
  0.0907908, 0.0919079, 0.0930158, 0.0941145, 0.0952038, 0.0962836,
  0.0973539, 0.0984145, 0.0994653, 0.100506, 0.101537, 0.102558,
  0.103569, 0.104569, 0.105559, 0.106539, 0.107508, 0.108466,
  0.109414, 0.110351, 0.111277, 0.112192, 0.113095, 0.113988,
  0.114869, 0.115739, 0.116598, 0.117444, 0.11828, 0.119103, 0.119915,
  0.120715, 0.121504, 0.12228, 0.123044, 0.123796, 0.124535, 0.125263,
  0.125978, 0.12668, 0.12737, 0.128048, 0.128713, 0.129365, 0.130005,
  0.130632, 0.131245, 0.131846, 0.132434, 0.133009, 0.133571, 0.13412,
  0.134655, 0.135177, 0.135686, 0.136182, 0.136664, 0.137133,
  0.137588, 0.13803, 0.138458, 0.138873, 0.139274, 0.139661, 0.140035,
  0.140394, 0.14074, 0.141073, 0.141391, 0.141696, 0.141986, 0.142263,
  0.142526, 0.142774, 0.143009, 0.14323, 0.143437, 0.143629, 0.143808,
  0.143972, 0.144123, 0.144259, 0.144381, 0.144489, 0.144583,
  0.144663, 0.144728, 0.14478, 0.144817, 0.14484, 0.144849, 0.144843,
  0.144824, 0.14479, 0.144743, 0.144681, 0.144605, 0.144514, 0.14441,
  0.144292, 0.144159, 0.144012, 0.143852, 0.143677, 0.143488,
  0.143286, 0.143069, 0.142838, 0.142593, 0.142335, 0.142062,
  0.141776, 0.141476, 0.141162, 0.140834, 0.140493, 0.140138,
  0.139769, 0.139386, 0.13899, 0.138581, 0.138158, 0.137721, 0.137271,
  0.136808, 0.136331, 0.135842, 0.135338, 0.134822, 0.134293, 0.13375,
  0.133195, 0.132626, 0.132045, 0.131451, 0.130844, 0.130224,
  0.129591, 0.128946, 0.128289, 0.127619, 0.126936, 0.126242,
  0.125535, 0.124815, 0.124084, 0.12334, 0.122585, 0.121818, 0.121039,
  0.120248, 0.119445, 0.118631, 0.117805, 0.116968, 0.11612, 0.11526,
  0.114389, 0.113507, 0.112614, 0.11171, 0.110795, 0.10987, 0.108934,
  0.107987, 0.10703, 0.106062, 0.105084, 0.104096, 0.103098, 0.10209,
  0.101072, 0.100044, 0.0990068, 0.0979597, 0.0969032, 0.0958373,
  0.0947621, 0.0936777, 0.0925843, 0.0914819, 0.0903707, 0.0892507,
  0.0881221, 0.086985, 0.0858395, 0.0846856, 0.0835236, 0.0823535,
  0.0811755, 0.0799896, 0.078796, 0.0775948, 0.0763861, 0.07517,
  0.0739467, 0.0727162, 0.0714788, 0.0702344, 0.0689832, 0.0677254,
  0.0664611, 0.0651904, 0.0639133, 0.0626302, 0.061341, 0.0600458,
  0.0587449, 0.0574384, 0.0561263, 0.0548088, 0.0534861, 0.0521582,
  0.0508253, 0.0494875, 0.048145, 0.0467978, 0.0454462, 0.0440902,
  0.0427299, 0.0413656, 0.0399973, 0.0386251, 0.0372493, 0.0358699,
  0.0344871, 0.0331009, 0.0317117, 0.0303193, 0.0289241, 0.0275262,
  0.0261256, 0.0247225, 0.0233171, 0.0219095, 0.0204998, 0.0190882,
  0.0176747, 0.0162596, 0.014843, 0.0134249, 0.0120057, 0.0105853,
  0.00916391, 0.00774169, 0.00631878, 0.0048953, 0.0034714,
  0.00204721, 0.000622861, -0.000801496, -0.00222573, -0.0036497,
  -0.00507327, -0.0064963, -0.00791865, -0.00934019, -0.0107608,
  -0.0121803, -0.0135985, -0.0150155, -0.0164309, -0.0178446,
  -0.0192566, -0.0206667, -0.0220748, -0.0234806, -0.0248842,
  -0.0262852, -0.0276837, -0.0290795, -0.0304724, -0.0318623,
  -0.0332491, -0.0346326, -0.0360128, -0.0373893, -0.0387623,
  -0.0401314, -0.0414966, -0.0428578, -0.0442147, -0.0455674,
  -0.0469155, -0.0482591, -0.049598, -0.0509321, -0.0522611,
  -0.0535851, -0.0549039, -0.0562172, -0.0575252, -0.0588275,
  -0.060124, -0.0614147, -0.0626995, -0.0639781, -0.0652505,
  -0.0665165, -0.0677761, -0.0690291, -0.0702753, -0.0715148,
  -0.0727472, -0.0739726, -0.0751908, -0.0764017, -0.0776051,
  -0.078801, -0.0799893, -0.0811698, -0.0823424, -0.083507,
  -0.0846634, -0.0858117, -0.0869516, -0.0880831, -0.089206,
  -0.0903203, -0.0914257, -0.0925224, -0.09361, -0.0946885,
  -0.0957579, -0.096818, -0.0978686, -0.0989098, -0.0999414,
  -0.100963, -0.101975, -0.102978, -0.10397, -0.104952, -0.105924,
  -0.106885, -0.107837, -0.108778, -0.109708, -0.110628, -0.111537,
  -0.112435, -0.113322, -0.114198, -0.115063, -0.115917, -0.11676,
  -0.117592, -0.118412, -0.11922, -0.120017, -0.120803, -0.121576,
  -0.122338, -0.123089, -0.123827, -0.124553, -0.125267, -0.125969,
  -0.126659, -0.127336, -0.128001, -0.128654, -0.129294, -0.129922,
  -0.130537, -0.13114, -0.13173, -0.132307, -0.132871, -0.133423,
  -0.133961, -0.134487, -0.134999, -0.135499, -0.135985, -0.136458,
  -0.136918, -0.137365, -0.137798, -0.138218, -0.138625, -0.139018,
  -0.139398, -0.139765, -0.140117, -0.140457, -0.140782, -0.141094,
  -0.141393, -0.141677, -0.141948, -0.142205, -0.142449, -0.142679,
  -0.142894, -0.143097, -0.143285, -0.143459, -0.143619, -0.143766,
  -0.143899, -0.144017, -0.144122, -0.144213, -0.14429, -0.144353,
  -0.144402, -0.144436, -0.144457, -0.144464, -0.144457, -0.144436,
  -0.144402, -0.144353, -0.14429, -0.144213, -0.144122, -0.144017,
  -0.143899, -0.143766, -0.143619, -0.143459, -0.143285, -0.143097,
  -0.142894, -0.142679, -0.142449, -0.142205, -0.141948, -0.141677,
  -0.141393, -0.141094, -0.140782, -0.140457, -0.140117, -0.139765,
  -0.139398, -0.139018, -0.138625, -0.138218, -0.137798, -0.137365,
  -0.136918, -0.136458, -0.135985, -0.135499, -0.134999, -0.134487,
  -0.133961, -0.133423, -0.132871, -0.132307, -0.13173, -0.13114,
  -0.130537, -0.129922, -0.129294, -0.128654, -0.128001, -0.127336,
  -0.126659, -0.125969, -0.125267, -0.124553, -0.123827, -0.123089,
  -0.122338, -0.121576, -0.120803, -0.120017, -0.11922, -0.118412,
  -0.117592, -0.11676, -0.115917, -0.115063, -0.114198, -0.113322,
  -0.112435, -0.111537, -0.110628, -0.109708, -0.108778, -0.107837,
  -0.106885, -0.105924, -0.104952, -0.10397, -0.102978, -0.101975,
  -0.100963, -0.0999414, -0.0989098, -0.0978686, -0.096818,
  -0.0957579, -0.0946885, -0.09361, -0.0925224, -0.0914257,
  -0.0903203, -0.089206, -0.0880831, -0.0869516, -0.0858117,
  -0.0846634, -0.083507, -0.0823424, -0.0811698, -0.0799893,
  -0.078801, -0.0776051, -0.0764017, -0.0751908, -0.0739726,
  -0.0727472, -0.0715148, -0.0702753, -0.0690291, -0.0677761,
  -0.0665165, -0.0652505, -0.0639781, -0.0626995, -0.0614147,
  -0.060124, -0.0588275, -0.0575252, -0.0562172, -0.0549039,
  -0.0535851, -0.0522611, -0.0509321, -0.049598, -0.0482591,
  -0.0469155, -0.0455674, -0.0442147, -0.0428578, -0.0414966,
  -0.0401314, -0.0387623, -0.0373893, -0.0360128, -0.0346326,
  -0.0332491, -0.0318623, -0.0304724, -0.0290795, -0.0276837,
  -0.0262852, -0.0248842, -0.0234806, -0.0220748, -0.0206667,
  -0.0192566, -0.0178446, -0.0164309, -0.0150155, -0.0135985,
  -0.0121803, -0.0107608, -0.00934019, -0.00791865, -0.0064963,
  -0.00507327, -0.0036497, -0.00222573, -0.000801496, 0.000622861,
  0.00204721, 0.0034714, 0.0048953, 0.00631878, 0.00774169,
  0.00916391, 0.0105853, 0.0120057, 0.0134249, 0.014843, 0.0162596,
  0.0176747, 0.0190882, 0.0204998, 0.0219095, 0.0233171, 0.0247225,
  0.0261256, 0.0275262, 0.0289241, 0.0303193, 0.0317117, 0.0331009,
  0.0344871, 0.0358699, 0.0372493, 0.0386251, 0.0399973, 0.0413656,
  0.0427299, 0.0440902, 0.0454462, 0.0467978, 0.048145, 0.0494875,
  0.0508253, 0.0521582, 0.0534861, 0.0548088, 0.0561263, 0.0574384,
  0.0587449, 0.0600458, 0.061341, 0.0626302, 0.0639133, 0.0651904,
  0.0664611, 0.0677254, 0.0689832, 0.0702344, 0.0714788, 0.0727162,
  0.0739467, 0.07517, 0.0763861, 0.0775948, 0.078796, 0.0799896,
  0.0811755, 0.0823535, 0.0835236, 0.0846856, 0.0858395, 0.086985,
  0.0881221, 0.0892507, 0.0903707, 0.0914819, 0.0925843, 0.0936777,
  0.0947621, 0.0958373, 0.0969032, 0.0979597, 0.0990068, 0.100044,
  0.101072, 0.10209, 0.103098, 0.104096, 0.105084, 0.106062, 0.10703,
  0.107987, 0.108934, 0.10987, 0.110795, 0.11171, 0.112614, 0.113507,
  0.114389, 0.11526, 0.11612, 0.116968, 0.117805, 0.118631, 0.119445,
  0.120248, 0.121039, 0.121818, 0.122585, 0.12334, 0.124084, 0.124815,
  0.125535, 0.126242, 0.126936, 0.127619, 0.128289, 0.128946,
  0.129591, 0.130224, 0.130844, 0.131451, 0.132045, 0.132626,
  0.133195, 0.13375, 0.134293, 0.134822, 0.135338, 0.135842, 0.136331,
  0.136808, 0.137271, 0.137721, 0.138158, 0.138581, 0.13899, 0.139386,
  0.139769, 0.140138, 0.140493, 0.140834, 0.141162, 0.141476,
  0.141776, 0.142062, 0.142335, 0.142593, 0.142838, 0.143069,
  0.143286, 0.143488, 0.143677, 0.143852, 0.144012, 0.144159,
  0.144292, 0.14441, 0.144514, 0.144605, 0.144681, 0.144743, 0.14479,
  0.144824, 0.144843, 0.144849, 0.14484, 0.144817, 0.14478, 0.144728,
  0.144663, 0.144583, 0.144489, 0.144381, 0.144259, 0.144123,
  0.143972, 0.143808, 0.143629, 0.143437, 0.14323, 0.143009, 0.142774,
  0.142526, 0.142263, 0.141986, 0.141696, 0.141391, 0.141073, 0.14074,
  0.140394, 0.140035, 0.139661, 0.139274, 0.138873, 0.138458, 0.13803,
  0.137588, 0.137133, 0.136664, 0.136182, 0.135686, 0.135177,
  0.134655, 0.13412, 0.133571, 0.133009, 0.132434, 0.131846, 0.131245,
  0.130632, 0.130005, 0.129365, 0.128713, 0.128048, 0.12737, 0.12668,
  0.125978, 0.125263, 0.124535, 0.123796, 0.123044, 0.12228, 0.121504,
  0.120715, 0.119915, 0.119103, 0.11828, 0.117444, 0.116598, 0.115739,
  0.114869, 0.113988, 0.113095, 0.112192, 0.111277, 0.110351,
  0.109414, 0.108466, 0.107508, 0.106539, 0.105559, 0.104569,
  0.103569, 0.102558, 0.101537, 0.100506, 0.0994653, 0.0984145,
  0.0973539, 0.0962836, 0.0952038, 0.0941145, 0.0930158, 0.0919079,
  0.0907908, 0.0896647, 0.0885297, 0.0873858, 0.0862332, 0.0850721,
  0.0839024, 0.0827244, 0.0815381, 0.0803437, 0.0791413, 0.0779309,
  0.0767128, 0.075487, 0.0742536, 0.0730128, 0.0717647, 0.0705094,
  0.069247, 0.0679777, 0.0667015, 0.0654187, 0.0641293, 0.0628334,
  0.0615312, 0.0602229, 0.0589084, 0.0575881, 0.0562619, 0.05493,
  0.0535926, 0.0522498, 0.0509017, 0.0495484, 0.0481901, 0.0468269,
  0.045459, 0.0440865, 0.0427094, 0.041328, 0.0399424, 0.0385527,
  0.0371591, 0.0357616, 0.0343605, 0.0329559, 0.0315479, 0.0301366,
  0.0287221, 0.0273048, 0.0258845, 0.0244616, 0.0230361, 0.0216082,
  0.020178, 0.0187457, 0.0173113, 0.0158752, 0.0144373, 0.0129978,
  0.0115569, 0.0101147, 0.00867137, 0.00722703, 0.00578183,
  0.00433591, 0.00288941, 0.00144249, -4.72955e-06, -0.00145209,
  -0.00289946, -0.00434669, -0.00579363, -0.00724015, -0.0086861,
  -0.0101313, -0.0115757, -0.0130191, -0.0144613, -0.0159023,
  -0.0173418, -0.0187798, -0.020216, -0.0216504, -0.0230828,
  -0.024513, -0.025941, -0.0273665, -0.0287895, -0.0302098,
  -0.0316272, -0.0330416, -0.0344529, -0.0358609, -0.0372655,
  -0.0386666, -0.0400639, -0.0414574, -0.042847, -0.0442324,
  -0.0456136, -0.0469904, -0.0483627, -0.0497304, -0.0510932,
  -0.0524511, -0.0538039, -0.0551515, -0.0564938, -0.0578306,
  -0.0591618, -0.0604872, -0.0618068, -0.0631204, -0.0644278,
  -0.0657289, -0.0670237, -0.0683119, -0.0695935, -0.0708682,
  -0.0721361, -0.0733969, -0.0746505, -0.0758968, -0.0771357,
  -0.0783671, -0.0795907, -0.0808066, -0.0820146, -0.0832145,
  -0.0844062, -0.0855897, -0.0867647, -0.0879313, -0.0890891,
  -0.0902383, -0.0913785, -0.0925098, -0.0936319, -0.0947449,
  -0.0958485, -0.0969426, -0.0980272, -0.0991021, -0.100167,
  -0.101223, -0.102268, -0.103303, -0.104328, -0.105343, -0.106347,
  -0.107341, -0.108324, -0.109296, -0.110258, -0.111208, -0.112148,
  -0.113076, -0.113994, -0.1149, -0.115794, -0.116677, -0.117549,
  -0.118409, -0.119257, -0.120093, -0.120918, -0.12173, -0.12253,
  -0.123318, -0.124094, -0.124857, -0.125608, -0.126347, -0.127073,
  -0.127786, -0.128486, -0.129174, -0.129849, -0.130511, -0.13116,
  -0.131796, -0.132418, -0.133028, -0.133624, -0.134206, -0.134776,
  -0.135332, -0.135874, -0.136403, -0.136918, -0.13742, -0.137907,
  -0.138381, -0.138841, -0.139287, -0.139719, -0.140138, -0.140542,
  -0.140932, -0.141308, -0.141669, -0.142017, -0.14235, -0.142669,
  -0.142974, -0.143264, -0.14354, -0.143801, -0.144048, -0.144281,
  -0.144499, -0.144702, -0.144891, -0.145066, -0.145225, -0.14537,
  -0.145501, -0.145617, -0.145718, -0.145804, -0.145876, -0.145933,
  -0.145975, -0.146003, -0.146015, -0.146013, -0.145997, -0.145965,
  -0.145919, -0.145858, -0.145782, -0.145692, -0.145587, -0.145467,
  -0.145332, -0.145183, -0.145019, -0.14484, -0.144646, -0.144438,
  -0.144215, -0.143978, -0.143726, -0.143459, -0.143178, -0.142882,
  -0.142572, -0.142247, -0.141908, -0.141555, -0.141186, -0.140804,
  -0.140407, -0.139996, -0.139571, -0.139132, -0.138678, -0.13821,
  -0.137728, -0.137232, -0.136722, -0.136198, -0.135661, -0.135109,
  -0.134543, -0.133964, -0.133371, -0.132765, -0.132145, -0.131511,
  -0.130864, -0.130203, -0.129529, -0.128842, -0.128142, -0.127428,
  -0.126702, -0.125962, -0.12521, -0.124444, -0.123666, -0.122875,
  -0.122072, -0.121256, -0.120427, -0.119586, -0.118733, -0.117868,
  -0.11699, -0.1161, -0.115199, -0.114285, -0.11336, -0.112423,
  -0.111474, -0.110514, -0.109542, -0.108559, -0.107565, -0.10656,
  -0.105544, -0.104516, -0.103478, -0.102429, -0.10137, -0.1003,
  -0.0992194, -0.0981287, -0.0970277, -0.0959167, -0.0947956,
  -0.0936647, -0.0925241, -0.0913737, -0.0902139, -0.0890446,
  -0.087866, -0.0866782, -0.0854814, -0.0842756, -0.083061,
  -0.0818377, -0.0806058, -0.0793654, -0.0781167, -0.0768598,
  -0.0755948, -0.0743219, -0.0730411, -0.0717526, -0.0704566,
  -0.0691531, -0.0678423, -0.0665243, -0.0651992, -0.0638673,
  -0.0625285, -0.0611832, -0.0598313, -0.058473, -0.0571085,
  -0.0557379, -0.0543614, -0.052979, -0.051591, -0.0501974,
  -0.0487984, -0.0473942, -0.0459848, -0.0445705, -0.0431514,
  -0.0417276, -0.0402992, -0.0388664, -0.0374294, -0.0359883,
  -0.0345433, -0.0330944, -0.0316419, -0.0301859, -0.0287265,
  -0.0272639, -0.0257982, -0.0243296, -0.0228583, -0.0213843,
  -0.0199079, -0.0184292, -0.0169483, -0.0154654, -0.0139807,
  -0.0124942, -0.0110062, -0.00951683, -0.0080262, -0.00653448,
  -0.00504182, -0.00354837, -0.0020543, -0.000559755, 0.000935111,
  0.00243014, 0.00392519, 0.00542009, 0.00691469, 0.00840885,
  0.00990239, 0.0113952, 0.012887, 0.0143778, 0.0158674, 0.0173556,
  0.0188423, 0.0203272, 0.0218104, 0.0232915, 0.0247705, 0.0262472,
  0.0277214, 0.029193, 0.0306618, 0.0321277, 0.0335906, 0.0350502,
  0.0365064, 0.0379592, 0.0394082, 0.0408534, 0.0422946, 0.0437317,
  0.0451645, 0.0465928, 0.0480166, 0.0494356, 0.0508498, 0.0522589,
  0.0536628, 0.0550614, 0.0564545, 0.057842, 0.0592237, 0.0605996,
  0.0619693, 0.0633328, 0.06469, 0.0660407, 0.0673848, 0.068722,
  0.0700524, 0.0713756, 0.0726917, 0.0740005, 0.0753017, 0.0765953,
  0.0778812, 0.0791592, 0.0804291, 0.0816909, 0.0829443, 0.0841894,
  0.0854258, 0.0866536, 0.0878725, 0.0890824, 0.0902833, 0.0914749,
  0.0926572, 0.09383, 0.0949932, 0.0961467, 0.0972903, 0.0984239,
  0.0995474, 0.100661, 0.101764, 0.102856, 0.103938, 0.105009,
  0.10607, 0.107119, 0.108158, 0.109185, 0.110201, 0.111205, 0.112199,
  0.11318, 0.11415, 0.115108, 0.116054, 0.116988, 0.11791, 0.11882,
  0.119717, 0.120602, 0.121474, 0.122334, 0.123181, 0.124015,
  0.124837, 0.125645, 0.12644, 0.127223, 0.127991, 0.128747, 0.129489,
  0.130217, 0.130932, 0.131634, 0.132321, 0.132995, 0.133654, 0.1343,
  0.134932, 0.135549, 0.136153, 0.136742, 0.137317, 0.137877,
  0.138423, 0.138954, 0.139471, 0.139973, 0.14046, 0.140932, 0.14139,
  0.141833, 0.142261, 0.142673, 0.143071, 0.143454, 0.143821,
  0.144174, 0.144511, 0.144833, 0.145139, 0.145431, 0.145706,
  0.145967, 0.146212, 0.146441, 0.146655, 0.146853, 0.147036,
  0.147203, 0.147355, 0.147491, 0.147611, 0.147715, 0.147804,
  0.147877, 0.147935, 0.147976, 0.148002, 0.148012, 0.148006,
  0.147985, 0.147947, 0.147894, 0.147825, 0.147741, 0.14764, 0.147524,
  0.147392, 0.147244, 0.14708, 0.146901, 0.146706, 0.146495, 0.146268,
  0.146026, 0.145768, 0.145494, 0.145205, 0.1449, 0.14458, 0.144243,
  0.143892, 0.143525, 0.143142, 0.142744, 0.142331, 0.141902,
  0.141458, 0.140999, 0.140524, 0.140034, 0.139529, 0.139009,
  0.138474, 0.137924, 0.137359, 0.136779, 0.136184, 0.135574, 0.13495,
  0.134311, 0.133657, 0.132989, 0.132307, 0.13161, 0.130898, 0.130173,
  0.129433, 0.128679, 0.127911, 0.127129, 0.126333, 0.125523, 0.1247,
  0.123863, 0.123012, 0.122148, 0.12127, 0.120379, 0.119475, 0.118558,
  0.117628, 0.116685, 0.115729, 0.11476, 0.113778, 0.112784, 0.111778,
  0.110759, 0.109728, 0.108685, 0.10763, 0.106563, 0.105484, 0.104393,
  0.103291, 0.102177, 0.101052, 0.0999158, 0.0987684, 0.09761,
  0.0964407, 0.0952606, 0.0940699, 0.0928687, 0.0916571, 0.0904352,
  0.0892032, 0.0879612, 0.0867093, 0.0854476, 0.0841764, 0.0828957,
  0.0816056, 0.0803063, 0.0789979, 0.0776806, 0.0763545, 0.0750198,
  0.0736765, 0.0723249, 0.070965, 0.0695971, 0.0682212, 0.0668375,
  0.0654462, 0.0640474, 0.0626412, 0.0612278, 0.0598074, 0.0583801,
  0.056946, 0.0555054, 0.0540583, 0.0526049, 0.0511454, 0.0496799,
  0.0482086, 0.0467317, 0.0452492, 0.0437615, 0.0422685, 0.0407705,
  0.0392677, 0.0377602, 0.0362482, 0.0347318, 0.0332112, 0.0316865,
  0.030158, 0.0286258, 0.02709, 0.0255509, 0.0240086, 0.0224632,
  0.0209149, 0.019364, 0.0178105, 0.0162547, 0.0146967, 0.0131366,
  0.0115747, 0.0100112, 0.00844607, 0.00687965, 0.00531207,
  0.00374349, 0.0021741, 0.000604052, -0.000966467, -0.00253729,
  -0.00410824, -0.00567914, -0.00724983, -0.00882012, -0.0103898,
  -0.0119588, -0.0135269, -0.0150939, -0.0166596, -0.0182239,
  -0.0197866, -0.0213475, -0.0229065, -0.0244633, -0.0260178,
  -0.0275698, -0.0291192, -0.0306658, -0.0322094, -0.0337498,
  -0.0352868, -0.0368204, -0.0383502, -0.0398762, -0.0413982,
  -0.042916, -0.0444294, -0.0459382, -0.0474424, -0.0489417,
  -0.0504359, -0.0519249, -0.0534085, -0.0548865, -0.0563589,
  -0.0578253, -0.0592857, -0.0607398, -0.0621876, -0.0636288,
  -0.0650633, -0.0664909, -0.0679115, -0.0693248, -0.0707308,
  -0.0721293, -0.07352, -0.0749029, -0.0762778, -0.0776446, -0.079003,
  -0.0803529, -0.0816942, -0.0830267, -0.0843503, -0.0856647,
  -0.0869699, -0.0882657, -0.089552, -0.0908285, -0.0920952,
  -0.0933519, -0.0945985, -0.0958347, -0.0970605, -0.0982758,
  -0.0994803, -0.100674, -0.101857, -0.103028, -0.104188, -0.105337,
  -0.106474, -0.1076, -0.108714, -0.109816, -0.110905, -0.111983,
  -0.113048, -0.114101, -0.115141, -0.116168, -0.117183, -0.118184,
  -0.119173, -0.120148, -0.12111, -0.122058, -0.122993, -0.123915,
  -0.124822, -0.125716, -0.126595, -0.127461, -0.128312, -0.129149,
  -0.129972, -0.13078, -0.131573, -0.132352, -0.133116, -0.133865,
  -0.134599, -0.135317, -0.136021, -0.136709, -0.137382, -0.13804,
  -0.138682, -0.139308, -0.139919, -0.140514, -0.141093, -0.141656,
  -0.142203, -0.142735, -0.143249, -0.143748, -0.144231, -0.144697,
  -0.145146, -0.14558, -0.145996, -0.146396, -0.14678, -0.147147,
  -0.147497, -0.14783, -0.148146, -0.148446, -0.148728, -0.148994,
  -0.149242, -0.149474, -0.149688, -0.149886, -0.150066, -0.150229,
  -0.150374, -0.150503, -0.150614, -0.150708, -0.150784, -0.150844,
  -0.150885, -0.15091, -0.150917, -0.150907, -0.150879, -0.150834,
  -0.150771, -0.150691, -0.150594, -0.150479, -0.150347, -0.150197,
  -0.15003, -0.149846, -0.149644, -0.149424, -0.149188, -0.148934,
  -0.148663, -0.148374, -0.148068, -0.147745, -0.147404, -0.147047,
  -0.146672, -0.14628, -0.145871, -0.145445, -0.145002, -0.144542,
  -0.144065, -0.143571, -0.14306, -0.142532, -0.141988, -0.141426,
  -0.140849, -0.140254, -0.139643, -0.139016, -0.138372, -0.137712,
  -0.137035, -0.136343, -0.135634, -0.134909, -0.134168, -0.133411,
  -0.132638, -0.13185, -0.131046, -0.130226, -0.129391, -0.12854,
  -0.127674, -0.126793, -0.125896, -0.124985, -0.124058, -0.123117,
  -0.122161, -0.12119, -0.120205, -0.119205, -0.118191, -0.117163,
  -0.11612, -0.115064, -0.113994, -0.112909, -0.111812, -0.1107,
  -0.109576, -0.108438, -0.107286, -0.106122, -0.104945, -0.103755,
  -0.102552, -0.101337, -0.10011, -0.0988701, -0.0976182, -0.0963544,
  -0.0950787, -0.0937914, -0.0924925, -0.0911823, -0.0898607,
  -0.0885281, -0.0871845, -0.0858302, -0.0844651, -0.0830896,
  -0.0817038, -0.0803078, -0.0789017, -0.0774858, -0.0760602,
  -0.0746251, -0.0731806, -0.0717269, -0.0702641, -0.0687925,
  -0.0673122, -0.0658233, -0.0643261, -0.0628207, -0.0613073,
  -0.059786, -0.0582571, -0.0567207, -0.0551769, -0.0536261,
  -0.0520683, -0.0505037, -0.0489325, -0.0473549, -0.0457711,
  -0.0441813, -0.0425856, -0.0409843, -0.0393774, -0.0377653,
  -0.0361481, -0.034526, -0.0328991, -0.0312678, -0.0296321,
  -0.0279923, -0.0263485, -0.0247009, -0.0230499, -0.0213954,
  -0.0197378, -0.0180772, -0.0164139, -0.0147479, -0.0130796,
  -0.0114092, -0.00973672, -0.00806249, -0.0063867, -0.00470953,
  -0.00303119, -0.00135188, 0.000328194, 0.00200884, 0.00368985,
  0.00537101, 0.00705214, 0.00873302, 0.0104135, 0.0120932, 0.0137722,
  0.01545, 0.0171266, 0.0188017, 0.0204752, 0.0221468, 0.0238163,
  0.0254835, 0.0271482, 0.0288103, 0.0304694, 0.0321254, 0.0337782,
  0.0354274, 0.0370729, 0.0387145, 0.040352, 0.0419852, 0.0436138,
  0.0452377, 0.0468567, 0.0484706, 0.0500792, 0.0516822, 0.0532795,
  0.0548709, 0.0564561, 0.058035, 0.0596074, 0.0611731, 0.0627319,
  0.0642836, 0.0658279, 0.0673648, 0.068894, 0.0704152, 0.0719284,
  0.0734334, 0.0749298, 0.0764176, 0.0778966, 0.0793665, 0.0808272,
  0.0822786, 0.0837203, 0.0851522, 0.0865742, 0.0879861, 0.0893876,
  0.0907786, 0.0921589, 0.0935284, 0.0948868, 0.0962341, 0.0975699,
  0.0988942, 0.100207, 0.101507, 0.102796, 0.104072, 0.105336,
  0.106587, 0.107826, 0.109051, 0.110264, 0.111463, 0.112649,
  0.113822, 0.11498, 0.116125, 0.117256, 0.118373, 0.119475, 0.120563,
  0.121636, 0.122695, 0.123738, 0.124767, 0.12578, 0.126778, 0.127761,
  0.128728, 0.129679, 0.130615, 0.131534, 0.132438, 0.133325,
  0.134196, 0.13505, 0.135888, 0.136709, 0.137513, 0.1383, 0.13907,
  0.139823, 0.140559, 0.141277, 0.141978, 0.142661, 0.143326,
  0.143974, 0.144604, 0.145216, 0.14581, 0.146385, 0.146942, 0.147481,
  0.148002, 0.148504, 0.148988, 0.149452, 0.149899, 0.150326,
  0.150734, 0.151124, 0.151494, 0.151846, 0.152178, 0.152491,
  0.152785, 0.15306, 0.153315, 0.153551, 0.153767, 0.153964, 0.154142,
  0.154299, 0.154438, 0.154556, 0.154655, 0.154735, 0.154794,
  0.154834, 0.154854, 0.154854, 0.154835, 0.154796, 0.154736,
  0.154657, 0.154559, 0.15444, 0.154301, 0.154143, 0.153965, 0.153767,
  0.153549, 0.153311, 0.153054, 0.152777, 0.152479, 0.152163,
  0.151826, 0.15147, 0.151094, 0.150699, 0.150283, 0.149849, 0.149395,
  0.148921, 0.148428, 0.147915, 0.147383, 0.146832, 0.146262,
  0.145672, 0.145064, 0.144436, 0.143789, 0.143123, 0.142439,
  0.141736, 0.141013, 0.140273, 0.139514, 0.138736, 0.13794, 0.137125,
  0.136293, 0.135442, 0.134573, 0.133687, 0.132782, 0.13186, 0.13092,
  0.129963, 0.128988, 0.127996, 0.126987, 0.125961, 0.124917,
  0.123857, 0.122781, 0.121687, 0.120578, 0.119452, 0.118309,
  0.117151, 0.115977, 0.114787, 0.113581, 0.11236, 0.111124, 0.109872,
  0.108606, 0.107324, 0.106028, 0.104717, 0.103392, 0.102052,
  0.100699, 0.0993312, 0.09795, 0.0965551, 0.0951469, 0.0937254,
  0.0922909, 0.0908435, 0.0893833, 0.0879107, 0.0864257, 0.0849285,
  0.0834194, 0.0818985, 0.0803661, 0.0788222, 0.0772671, 0.075701,
  0.0741241, 0.0725366, 0.0709387, 0.0693306, 0.0677125, 0.0660846,
  0.0644471, 0.0628003, 0.0611443, 0.0594793, 0.0578056, 0.0561233,
  0.0544328, 0.0527342, 0.0510277, 0.0493135, 0.047592, 0.0458632,
  0.0441275, 0.042385, 0.0406359, 0.0388806, 0.0371192, 0.035352,
  0.0335792, 0.031801, 0.0300177, 0.0282295, 0.0264366, 0.0246393,
  0.0228378, 0.0210323, 0.0192232, 0.0174105, 0.0155947, 0.0137758,
  0.0119542, 0.0101302, 0.00830381, 0.00647545, 0.00464533,
  0.00281369, 0.000980785, -0.000853149, -0.00268786, -0.0045231,
  -0.00635861, -0.00819416, -0.0100295, -0.0118643, -0.0136985,
  -0.0155317, -0.0173636, -0.0191941, -0.0210228, -0.0228496,
  -0.0246742, -0.0264963, -0.0283156, -0.030132, -0.0319451,
  -0.0337548, -0.0355607, -0.0373627, -0.0391604, -0.0409536,
  -0.0427421, -0.0445256, -0.0463039, -0.0480767, -0.0498437,
  -0.0516048, -0.0533596, -0.055108, -0.0568496, -0.0585843,
  -0.0603117, -0.0620317, -0.063744, -0.0654483, -0.0671444,
  -0.0688321, -0.0705111, -0.0721811, -0.073842, -0.0754935,
  -0.0771354, -0.0787674, -0.0803892, -0.0820008, -0.0836017,
  -0.0851918, -0.0867709, -0.0883387, -0.0898949, -0.0914395,
  -0.0929721, -0.0944924, -0.0960004, -0.0974957, -0.0989782,
  -0.100448, -0.101904, -0.103346, -0.104775, -0.10619, -0.107591,
  -0.108977, -0.110349, -0.111706, -0.113048, -0.114375, -0.115686,
  -0.116982, -0.118262, -0.119526, -0.120773, -0.122005, -0.12322,
  -0.124418, -0.125599, -0.126763, -0.12791, -0.129039, -0.13015,
  -0.131244, -0.13232, -0.133377, -0.134416, -0.135437, -0.136439,
  -0.137422, -0.138386, -0.13933, -0.140256, -0.141162, -0.142048,
  -0.142915, -0.143761, -0.144588, -0.145394, -0.14618, -0.146946,
  -0.147691, -0.148415, -0.149118, -0.149801, -0.150462, -0.151102,
  -0.151721, -0.152318, -0.152894, -0.153448, -0.15398, -0.15449,
  -0.154979, -0.155445, -0.155889, -0.156311, -0.156711, -0.157088,
  -0.157442, -0.157775, -0.158084, -0.158371, -0.158635, -0.158876,
  -0.159094, -0.15929, -0.159462, -0.159611, -0.159737, -0.15984,
  -0.15992, -0.159977, -0.16001, -0.16002, -0.160007, -0.15997,
  -0.15991, -0.159827, -0.15972, -0.15959, -0.159436, -0.159259,
  -0.159058, -0.158835, -0.158587, -0.158316, -0.158022, -0.157705,
  -0.157364, -0.157, -0.156612, -0.156201, -0.155767, -0.15531,
  -0.15483, -0.154326, -0.1538, -0.15325, -0.152677, -0.152082,
  -0.151464, -0.150822, -0.150159, -0.149472, -0.148763, -0.148032,
  -0.147278, -0.146501, -0.145703, -0.144882, -0.144039, -0.143175,
  -0.142288, -0.14138, -0.14045, -0.139499, -0.138526, -0.137532,
  -0.136517, -0.135481, -0.134423, -0.133346, -0.132247, -0.131128,
  -0.129989, -0.128829, -0.127649, -0.12645, -0.125231, -0.123992,
  -0.122734, -0.121456, -0.120159, -0.118844, -0.11751, -0.116157,
  -0.114786, -0.113396, -0.111989, -0.110564, -0.109121, -0.107661,
  -0.106183, -0.104689, -0.103178, -0.10165, -0.100105, -0.098545,
  -0.0969686, -0.0953765, -0.0937688, -0.0921458, -0.0905078,
  -0.0888549, -0.0871875, -0.0855056, -0.0838097, -0.0820999,
  -0.0803764, -0.0786395, -0.0768895, -0.0751266, -0.0733511,
  -0.0715632, -0.0697631, -0.0679512, -0.0661278, -0.0642929,
  -0.062447, -0.0605904, -0.0587232, -0.0568457, -0.0549583,
  -0.0530612, -0.0511547, -0.0492391, -0.0473146, -0.0453816,
  -0.0434403, -0.041491, -0.039534, -0.0375697, -0.0355983, -0.03362,
  -0.0316353, -0.0296443, -0.0276475, -0.0256451, -0.0236373,
  -0.0216246, -0.0196072, -0.0175855, -0.0155597, -0.0135302,
  -0.0114972, -0.00946107, -0.00742217, -0.00538078, -0.00333722,
  -0.00129181, 0.00075514, 0.0028033, 0.00485236, 0.00690199,
  0.00895187, 0.0110017, 0.0130511, 0.0150998, 0.0171474, 0.0191937,
  0.0212383, 0.0232809, 0.0253211, 0.0273587, 0.0293933, 0.0314245,
  0.0334521, 0.0354757, 0.037495, 0.0395097, 0.0415194, 0.0435238,
  0.0455227, 0.0475156, 0.0495022, 0.0514822, 0.0534554, 0.0554212,
  0.0573796, 0.05933, 0.0612722, 0.063206, 0.0651308, 0.0670465,
  0.0689527, 0.070849, 0.0727353, 0.0746111, 0.0764761, 0.0783301,
  0.0801726, 0.0820035, 0.0838223, 0.0856288, 0.0874227, 0.0892036,
  0.0909712, 0.0927254, 0.0944656, 0.0961917, 0.0979033, 0.0996002,
  0.101282, 0.102948, 0.104599, 0.106234, 0.107853, 0.109455, 0.11104,
  0.112609, 0.11416, 0.115693, 0.117208, 0.118706, 0.120184, 0.121644,
  0.123085, 0.124507, 0.125909, 0.127292, 0.128654, 0.129997,
  0.131318, 0.132619, 0.133899, 0.135158, 0.136395, 0.13761, 0.138804,
  0.139975, 0.141124, 0.14225, 0.143353, 0.144433, 0.14549, 0.146524,
  0.147533, 0.148519, 0.149481, 0.150418, 0.151331, 0.152219,
  0.153082, 0.153921, 0.154734, 0.155521, 0.156283, 0.15702, 0.15773,
  0.158414, 0.159072, 0.159704, 0.16031, 0.160888, 0.16144, 0.161965,
  0.162463, 0.162934, 0.163377, 0.163793, 0.164182, 0.164543,
  0.164876, 0.165181, 0.165458, 0.165708, 0.165929, 0.166122,
  0.166287, 0.166424, 0.166532, 0.166612, 0.166663, 0.166686, 0.16668,
  0.166646, 0.166583, 0.166491, 0.16637, 0.166221, 0.166043, 0.165836,
  0.1656, 0.165336, 0.165042, 0.16472, 0.164369, 0.16399, 0.163581,
  0.163144, 0.162679, 0.162184, 0.161661, 0.161109, 0.160529,
  0.159921, 0.159284, 0.158618, 0.157925, 0.157203, 0.156453,
  0.155676, 0.15487, 0.154036, 0.153175, 0.152286, 0.15137, 0.150426,
  0.149455, 0.148457, 0.147432, 0.14638, 0.145301, 0.144196, 0.143064,
  0.141907, 0.140723, 0.139513, 0.138277, 0.137016, 0.135729,
  0.134417, 0.133081, 0.131719, 0.130333, 0.128922, 0.127487,
  0.126029, 0.124546, 0.12304, 0.121511, 0.119958, 0.118383, 0.116785,
  0.115165, 0.113523, 0.111859, 0.110174, 0.108467, 0.106739,
  0.104991, 0.103222, 0.101433, 0.0996238, 0.0977953, 0.0959476,
  0.0940809, 0.0921955, 0.0902917, 0.08837, 0.0864305, 0.0844737,
  0.0824997, 0.0805091, 0.078502, 0.0764789, 0.0744401, 0.072386,
  0.0703168, 0.0682329, 0.0661348, 0.0640227, 0.061897, 0.0597581,
  0.0576064, 0.0554422, 0.053266, 0.051078, 0.0488787, 0.0466685,
  0.0444477, 0.0422168, 0.0399762, 0.0377261, 0.0354672, 0.0331997,
  0.030924, 0.0286406, 0.0263499, 0.0240523, 0.0217482, 0.019438,
  0.0171222, 0.0148011, 0.0124753, 0.0101451, 0.00781093, 0.00547327,
  0.00313253, 0.000789146, -0.00155644, -0.0039038, -0.00625248,
  -0.00860205, -0.0109521, -0.0133021, -0.0156517, -0.0180003,
  -0.0203477, -0.0226932, -0.0250366, -0.0273772, -0.0297147,
  -0.0320487, -0.0343786, -0.036704, -0.0390244, -0.0413395,
  -0.0436487, -0.0459517, -0.0482479, -0.0505369, -0.0528182,
  -0.0550914, -0.0573561, -0.0596118, -0.061858, -0.0640942,
  -0.0663202, -0.0685353, -0.0707391, -0.0729313, -0.0751113,
  -0.0772787, -0.0794331, -0.081574, -0.0837009, -0.0858135,
  -0.0879113, -0.0899939, -0.0920608, -0.0941115, -0.0961458,
  -0.0981631, -0.100163, -0.102145, -0.104109, -0.106054, -0.10798,
  -0.109887, -0.111773, -0.11364, -0.115485, -0.11731, -0.119113,
  -0.120894, -0.122653, -0.124389, -0.126102, -0.127791, -0.129457,
  -0.131098, -0.132715, -0.134307, -0.135874, -0.137414, -0.138929,
  -0.140417, -0.141879, -0.143313, -0.14472, -0.146099, -0.14745,
  -0.148773, -0.150067, -0.151331, -0.152567, -0.153772, -0.154948,
  -0.156093, -0.157208, -0.158292, -0.159345, -0.160366, -0.161355,
  -0.162313, -0.163238, -0.164131, -0.164991, -0.165818, -0.166612,
  -0.167373, -0.1681, -0.168793, -0.169451, -0.170076, -0.170666,
  -0.171222, -0.171742, -0.172228, -0.172678, -0.173093, -0.173472,
  -0.173816, -0.174124, -0.174396, -0.174632, -0.174831, -0.174995,
  -0.175122, -0.175212, -0.175266, -0.175283, -0.175263, -0.175206,
  -0.175112, -0.174982, -0.174814, -0.174609, -0.174368, -0.174089,
  -0.173772, -0.173419, -0.173028, -0.172601, -0.172136, -0.171634,
  -0.171095, -0.170519, -0.169906, -0.169255, -0.168568, -0.167844,
  -0.167084, -0.166286, -0.165453, -0.164582, -0.163675, -0.162732,
  -0.161753, -0.160738, -0.159687, -0.1586, -0.157478, -0.15632,
  -0.155127, -0.153899, -0.152637, -0.151339, -0.150007, -0.148641,
  -0.147241, -0.145808, -0.14434, -0.14284, -0.141306, -0.13974,
  -0.138141, -0.13651, -0.134847, -0.133153, -0.131427, -0.12967,
  -0.127883, -0.126065, -0.124217, -0.122339, -0.120433, -0.118497,
  -0.116532, -0.11454, -0.112519, -0.110471, -0.108396, -0.106295,
  -0.104167, -0.102013, -0.0998341, -0.09763, -0.0954014, -0.0931488,
  -0.0908725, -0.088573, -0.0862509, -0.0839065, -0.0815403,
  -0.079153, -0.0767448, -0.0743164, -0.0718682, -0.0694008,
  -0.0669146, -0.0644102, -0.0618882, -0.059349, -0.0567933,
  -0.0542214, -0.0516341, -0.0490319, -0.0464153, -0.0437848,
  -0.0411412, -0.0384849, -0.0358166, -0.0331368, -0.0304461,
  -0.0277451, -0.0250344, -0.0223147, -0.0195866, -0.0168506,
  -0.0141074, -0.0113575, -0.00860177, -0.00584067, -0.00307487,
  -0.000305014, 0.00246826, 0.0052443, 0.00802247, 0.0108021,
  0.0135826, 0.0163632, 0.0191433, 0.0219222, 0.0246994, 0.027474,
  0.0302455, 0.0330132, 0.0357764, 0.0385344, 0.0412865, 0.0440322,
  0.0467707, 0.0495013, 0.0522234, 0.0549362, 0.0576392, 0.0603316,
  0.0630127, 0.0656819, 0.0683385, 0.0709819, 0.0736112, 0.076226,
  0.0788254, 0.0814089, 0.0839757, 0.0865252, 0.0890567, 0.0915695,
  0.0940631, 0.0965366, 0.0989895, 0.101421, 0.103831, 0.106218,
  0.108582, 0.110922, 0.113237, 0.115527, 0.117792, 0.120029, 0.12224,
  0.124423, 0.126578, 0.128704, 0.130801, 0.132867, 0.134902,
  0.136907, 0.138879, 0.140819, 0.142725, 0.144598, 0.146437,
  0.148241, 0.15001, 0.151743, 0.153439, 0.155099, 0.156721, 0.158305,
  0.15985, 0.161357, 0.162824, 0.164251, 0.165638, 0.166984, 0.168289,
  0.169551, 0.170772, 0.17195, 0.173084, 0.174176, 0.175223, 0.176226,
  0.177184, 0.178097, 0.178965, 0.179787, 0.180563, 0.181292,
  0.181974, 0.18261, 0.183198, 0.183738, 0.184231, 0.184675, 0.18507,
  0.185417, 0.185715, 0.185964, 0.186163, 0.186313, 0.186413,
  0.186463, 0.186463, 0.186413, 0.186313, 0.186162, 0.18596, 0.185708,
  0.185405, 0.185051, 0.184646, 0.18419, 0.183684, 0.183126, 0.182518,
  0.181858, 0.181148, 0.180387, 0.179575, 0.178712, 0.177799,
  0.176835, 0.175821, 0.174756, 0.173641, 0.172477, 0.171262,
  0.169998, 0.168685, 0.167322, 0.16591, 0.16445, 0.162941, 0.161384,
  0.159779, 0.158126, 0.156427, 0.15468, 0.152887, 0.151047, 0.149162,
  0.147231, 0.145255, 0.143235, 0.14117, 0.139062, 0.136911, 0.134716,
  0.13248, 0.130202, 0.127882, 0.125522, 0.123122, 0.120682, 0.118203,
  0.115686, 0.113131, 0.110539, 0.10791, 0.105245, 0.102546,
  0.0998116, 0.0970437, 0.0942426, 0.0914091, 0.0885439, 0.0856479,
  0.0827217, 0.0797661, 0.0767819, 0.0737699, 0.070731, 0.0676658,
  0.0645753, 0.0614603, 0.0583216, 0.0551602, 0.0519769, 0.0487725,
  0.045548, 0.0423044, 0.0390424, 0.0357631, 0.0324673, 0.0291561,
  0.0258304, 0.0224911, 0.0191393, 0.0157759, 0.0124019, 0.00901834,
  0.0056262, 0.00222652, -0.00117969, -0.00459138, -0.00800753,
  -0.0114271, -0.014849, -0.0182721, -0.0216955, -0.0251181,
  -0.0285387, -0.0319563, -0.0353698, -0.0387781, -0.0421801,
  -0.0455747, -0.0489609, -0.0523374, -0.0557033, -0.0590573,
  -0.0623984, -0.0657254, -0.0690373, -0.0723329, -0.0756111,
  -0.0788708, -0.0821108, -0.0853301, -0.0885275, -0.091702,
  -0.0948523, -0.0979773, -0.101076, -0.104147, -0.10719, -0.110203,
  -0.113185, -0.116136, -0.119053, -0.121937, -0.124785, -0.127597,
  -0.130372, -0.133109, -0.135806, -0.138463, -0.141078, -0.143651,
  -0.14618, -0.148664, -0.151103, -0.153496, -0.155841, -0.158137,
  -0.160384, -0.16258, -0.164725, -0.166818, -0.168858, -0.170843,
  -0.172773, -0.174647, -0.176464, -0.178224, -0.179925, -0.181567,
  -0.183149, -0.18467, -0.186129, -0.187526, -0.188859, -0.190129,
  -0.191334, -0.192473, -0.193547, -0.194554, -0.195494, -0.196366,
  -0.19717, -0.197904, -0.198569, -0.199164, -0.199688, -0.200141,
  -0.200523, -0.200833, -0.20107, -0.201235, -0.201327, -0.201345,
  -0.201289, -0.201159, -0.200955, -0.200677, -0.200323, -0.199895,
  -0.199392, -0.198813, -0.198159, -0.197429, -0.196624, -0.195744,
  -0.194788, -0.193756, -0.192649, -0.191467, -0.19021, -0.188877,
  -0.18747, -0.185988, -0.184431, -0.182801, -0.181096, -0.179318,
  -0.177467, -0.175543, -0.173546, -0.171478, -0.169338, -0.167127,
  -0.164846, -0.162495, -0.160075, -0.157586, -0.15503, -0.152406,
  -0.149715, -0.146959, -0.144138, -0.141253, -0.138304, -0.135293,
  -0.132221, -0.129088, -0.125896, -0.122645, -0.119337, -0.115972,
  -0.112552, -0.109078, -0.10555, -0.101971, -0.0983416, -0.0946626,
  -0.0909355, -0.0871617, -0.0833424, -0.0794792, -0.0755732,
  -0.0716261, -0.0676391, -0.0636139, -0.0595519, -0.0554546,
  -0.0513236, -0.0471605, -0.042967, -0.0387445, -0.0344948,
  -0.0302197, -0.0259207, -0.0215996, -0.0172582, -0.0128982,
  -0.00852148, -0.00412982, 0.000274936, 0.00469093, 0.00911629,
  0.0135491, 0.0179875, 0.0224295, 0.0268731, 0.0313165, 0.0357576,
  0.0401944, 0.0446249, 0.0490471, 0.053459, 0.0578584, 0.0622435,
  0.066612, 0.0709619, 0.0752912, 0.0795976, 0.0838792, 0.0881339,
  0.0923594, 0.0965538, 0.100715, 0.10484, 0.108928, 0.112977,
  0.116983, 0.120946, 0.124863, 0.128731, 0.132549, 0.136315,
  0.140027, 0.143681, 0.147278, 0.150813, 0.154286, 0.157694,
  0.161035, 0.164308, 0.16751, 0.170638, 0.173692, 0.17667, 0.179568,
  0.182387, 0.185122, 0.187774, 0.190339, 0.192817, 0.195205,
  0.197501, 0.199704, 0.201812, 0.203824, 0.205738, 0.207552,
  0.209265, 0.210875, 0.212381, 0.213781, 0.215074, 0.216259,
  0.217334, 0.218298, 0.21915, 0.219888, 0.220512, 0.221021, 0.221413,
  0.221687, 0.221844, 0.22188, 0.221797, 0.221593, 0.221267, 0.22082,
  0.220249, 0.219556, 0.218738, 0.217797, 0.216732, 0.215541,
  0.214226, 0.212787, 0.211222, 0.209532, 0.207718, 0.205779,
  0.203715, 0.201528, 0.199217, 0.196782, 0.194225, 0.191546,
  0.188746, 0.185824, 0.182784, 0.179624, 0.176346, 0.172952,
  0.169442, 0.165818, 0.162081, 0.158233, 0.154274, 0.150207,
  0.146033, 0.141754, 0.137372, 0.132889, 0.128306, 0.123626,
  0.118851, 0.113983, 0.109025, 0.103979, 0.0988474, 0.0936329,
  0.088338, 0.0829657, 0.0775187, 0.072, 0.0664125, 0.0607594,
  0.0550439, 0.049269, 0.0434383, 0.037555, 0.0316226, 0.0256448,
  0.019625, 0.013567, 0.00747465, 0.00135168, -0.00479798, -0.0109704,
  -0.0171614, -0.023367, -0.029583, -0.0358052, -0.0420292,
  -0.0482508, -0.0544655, -0.060669, -0.0668565, -0.0730237,
  -0.079166, -0.0852786, -0.0913569, -0.0973962, -0.103392, -0.109339,
  -0.115232, -0.121067, -0.12684, -0.132544, -0.138175, -0.143728,
  -0.149199, -0.154582, -0.159872, -0.165065, -0.170154, -0.175137,
  -0.180007, -0.184759, -0.18939, -0.193893, -0.198264, -0.202499,
  -0.206592, -0.210538, -0.214334, -0.217974, -0.221454, -0.224769,
  -0.227915, -0.230888, -0.233682, -0.236295, -0.238721, -0.240957,
  -0.242999, -0.244843, -0.246485, -0.247921, -0.249149, -0.250164,
  -0.250964, -0.251545, -0.251904, -0.252039, -0.251946, -0.251624,
  -0.251069, -0.250281, -0.249256, -0.247993, -0.24649, -0.244746,
  -0.242759, -0.240529, -0.238055, -0.235336, -0.232372, -0.229162,
  -0.225707, -0.222007, -0.218063, -0.213875, -0.209445, -0.204774,
  -0.199863, -0.194715, -0.189332, -0.183715, -0.177869, -0.171796,
  -0.165499, -0.158982, -0.152249, -0.145305, -0.138154, -0.130801,
  -0.123251, -0.115509, -0.107583, -0.0994778, -0.0912002, -0.0827573,
  -0.0741563, -0.065405, -0.0565113, -0.0474836, -0.0383305,
  -0.0290611, -0.0196848, -0.0102114, -0.000650915, 0.00898619,
  0.0186891, 0.0284468, 0.0382476, 0.0480799, 0.0579315, 0.0677899,
  0.0776424, 0.0874757, 0.0972765, 0.107031, 0.116725, 0.126345,
  0.135876, 0.145302, 0.15461, 0.163783, 0.172806, 0.181663, 0.190338,
  0.198815, 0.207077, 0.215108, 0.222892, 0.230411, 0.237648,
  0.244587, 0.251211, 0.257502, 0.263444, 0.26902, 0.274211, 0.279003,
  0.283377, 0.287318, 0.290809, 0.293833, 0.296375, 0.298419, 0.29995,
  0.300953, 0.301414, 0.301318, 0.300652, 0.299403, 0.297559,
  0.295109, 0.292041, 0.288346, 0.284014, 0.279038, 0.27341, 0.267123,
  0.260174, 0.252558, 0.244274, 0.235319, 0.225694, 0.215402,
  0.204446, 0.192832, 0.180566, 0.167658, 0.15412, 0.139964, 0.125206,
  0.109864, 0.0939593, 0.0775144, 0.0605555, 0.0431113, 0.0252136,
  0.00689751, -0.0117988, -0.0308334, -0.0501611, -0.0697328,
  -0.0894952, -0.109391, -0.12936, -0.149335, -0.169245, -0.189016,
  -0.208568, -0.227814, -0.246663, -0.265019, -0.282779, -0.299835,
  -0.316072, -0.331367, -0.345594, -0.358615, -0.370289, -0.380465,
  -0.388986, -0.395683, -0.400384, -0.402903, -0.403049, -0.400619,
  -0.395402, -0.387176, -0.375708, -0.360756, -0.342067, -0.319373,
  -0.292399, -0.260855, -0.224438, -0.182834, -0.135713, -0.0827337,
  -0.0235386, 0.0422439, 0.115001, 0.195135, 0.283065, 0.379227,
  0.484073, 0.598075, 0.721722, 0.855521, 1}; const G4double
  G4NeutronHPFastLegendre::i30[6201] = {0, 0.000298974, 0.000553079,
  0.000765675, 0.000939955, 0.00107895, 0.00118554, 0.00126244,
  0.00131225, 0.00133742, 0.00134025, 0.00132293, 0.00128753,
  0.00123599, 0.00117016, 0.00109174, 0.00100238, 0.000903582,
  0.000796783, 0.000683317, 0.000564433, 0.000441294, 0.000314985,
  0.000186514, 5.68163e-05, -7.32445e-05, -0.00020287, -0.000331326,
  -0.000457938, -0.000582091, -0.000703224, -0.000820829,
  -0.000934446, -0.00104367, -0.00114812, -0.00124748, -0.00134147,
  -0.00142985, -0.00151239, -0.00158893, -0.00165933, -0.00172346,
  -0.00178125, -0.00183263, -0.00187759, -0.00191609, -0.00194817,
  -0.00197385, -0.00199318, -0.00200623, -0.0020131, -0.00201388,
  -0.00200869, -0.00199766, -0.00198093, -0.00195864, -0.00193097,
  -0.00189808, -0.00186015, -0.00181737, -0.00176992, -0.001718,
  -0.00166182, -0.00160157, -0.00153748, -0.00146974, -0.00139858,
  -0.0013242, -0.00124683, -0.00116668, -0.00108396, -0.000998893,
  -0.000911692, -0.00082257, -0.000731737, -0.000639403, -0.000545775,
  -0.000451056, -0.000355447, -0.000259146, -0.000162347,
  -6.52388e-05, 3.19916e-05, 0.000129163, 0.000226098, 0.000322623,
  0.000418572, 0.00051378, 0.00060809, 0.000701349, 0.000793409,
  0.000884127, 0.000973367, 0.001061, 0.00114689, 0.00123092,
  0.00131298, 0.00139296, 0.00147075, 0.00154625, 0.00161937,
  0.00169002, 0.00175812, 0.00182359, 0.00188637, 0.00194637,
  0.00200355, 0.00205784, 0.0021092, 0.00215758, 0.00220293,
  0.00224523, 0.00228443, 0.00232053, 0.00235348, 0.00238328,
  0.00240991, 0.00243337, 0.00245365, 0.00247074, 0.00248467,
  0.00249542, 0.00250303, 0.00250749, 0.00250883, 0.00250708,
  0.00250225, 0.00249439, 0.00248351, 0.00246967, 0.00245289,
  0.00243322, 0.00241071, 0.0023854, 0.00235734, 0.00232658,
  0.00229317, 0.00225719, 0.00221867, 0.00217769, 0.0021343,
  0.00208858, 0.00204058, 0.00199038, 0.00193804, 0.00188363,
  0.00182722, 0.0017689, 0.00170872, 0.00164677, 0.00158312,
  0.00151785, 0.00145104, 0.00138275, 0.00131308, 0.00124209,
  0.00116987, 0.0010965, 0.00102205, 0.00094661, 0.00087025,
  0.000793052, 0.000715095, 0.000636459, 0.00055722, 0.000477459,
  0.000397251, 0.000316674, 0.000235804, 0.000154718, 7.34909e-05,
  -7.80328e-06, -8.90906e-05, -0.000170298, -0.000251354,
  -0.000332187, -0.000412728, -0.000492906, -0.000572655,
  -0.000651907, -0.000730597, -0.00080866, -0.000886032, -0.000962653,
  -0.00103846, -0.0011134, -0.0011874, -0.00126042, -0.0013324,
  -0.00140328, -0.00147301, -0.00154154, -0.00160882, -0.00167481,
  -0.00173945, -0.00180271, -0.00186453, -0.00192488, -0.00198372,
  -0.002041, -0.0020967, -0.00215077, -0.00220318, -0.0022539,
  -0.0023029, -0.00235015, -0.00239562, -0.00243929, -0.00248112,
  -0.00252111, -0.00255923, -0.00259545, -0.00262976, -0.00266215,
  -0.00269259, -0.00272108, -0.00274761, -0.00277215, -0.00279472,
  -0.00281529, -0.00283386, -0.00285042, -0.00286498, -0.00287754,
  -0.00288809, -0.00289663, -0.00290316, -0.0029077, -0.00291024,
  -0.0029108, -0.00290937, -0.00290598, -0.00290062, -0.00289332,
  -0.00288408, -0.00287292, -0.00285986, -0.0028449, -0.00282808,
  -0.0028094, -0.00278888, -0.00276656, -0.00274244, -0.00271655,
  -0.00268892, -0.00265957, -0.00262852, -0.00259581, -0.00256145,
  -0.00252548, -0.00248792, -0.00244881, -0.00240817, -0.00236604,
  -0.00232245, -0.00227742, -0.002231, -0.00218322, -0.00213411,
  -0.0020837, -0.00203203, -0.00197914, -0.00192507, -0.00186984,
  -0.0018135, -0.00175608, -0.00169762, -0.00163817, -0.00157775,
  -0.00151641, -0.00145418, -0.00139111, -0.00132724, -0.0012626,
  -0.00119723, -0.00113118, -0.00106449, -0.000997185, -0.000929318,
  -0.000860926, -0.000792049, -0.000722728, -0.000653003,
  -0.000582915, -0.000512502, -0.000441806, -0.000370867,
  -0.000299723, -0.000228415, -0.000156983, -8.54648e-05,
  -1.39006e-05, 5.76711e-05, 0.000129212, 0.000200683, 0.000272046,
  0.000343264, 0.0004143, 0.000485116, 0.000555675, 0.000625941,
  0.000695879, 0.000765451, 0.000834625, 0.000903363, 0.000971633,
  0.0010394, 0.00110663, 0.00117329, 0.00123936, 0.00130478,
  0.00136955, 0.00143361, 0.00149696, 0.00155954, 0.00162135,
  0.00168233, 0.00174248, 0.00180176, 0.00186014, 0.0019176,
  0.00197411, 0.00202965, 0.00208419, 0.00213772, 0.00219019,
  0.0022416, 0.00229192, 0.00234113, 0.00238922, 0.00243615,
  0.00248191, 0.00252648, 0.00256985, 0.00261199, 0.00265289,
  0.00269254, 0.00273092, 0.00276801, 0.0028038, 0.00283828,
  0.00287144, 0.00290326, 0.00293373, 0.00296284, 0.00299058,
  0.00301695, 0.00304193, 0.00306552, 0.00308771, 0.0031085,
  0.00312787, 0.00314582, 0.00316236, 0.00317747, 0.00319115,
  0.0032034, 0.00321422, 0.0032236, 0.00323155, 0.00323807,
  0.00324316, 0.00324681, 0.00324904, 0.00324984, 0.00324922,
  0.00324718, 0.00324372, 0.00323886, 0.00323259, 0.00322493,
  0.00321587, 0.00320543, 0.00319362, 0.00318044, 0.0031659,
  0.00315002, 0.00313279, 0.00311424, 0.00309438, 0.0030732,
  0.00305074, 0.003027, 0.00300199, 0.00297573, 0.00294822, 0.0029195,
  0.00288956, 0.00285843, 0.00282612, 0.00279265, 0.00275803,
  0.00272228, 0.00268542, 0.00264747, 0.00260843, 0.00256835,
  0.00252722, 0.00248507, 0.00244192, 0.00239779, 0.0023527,
  0.00230667, 0.00225971, 0.00221186, 0.00216313, 0.00211354,
  0.00206312, 0.00201188, 0.00195985, 0.00190705, 0.00185351,
  0.00179923, 0.00174426, 0.00168861, 0.0016323, 0.00157537,
  0.00151782, 0.00145968, 0.00140099, 0.00134176, 0.00128201,
  0.00122177, 0.00116107, 0.00109992, 0.00103836, 0.000976404,
  0.000914078, 0.000851408, 0.000788417, 0.000725129, 0.00066157,
  0.000597763, 0.000533734, 0.000469505, 0.000405102, 0.000340549,
  0.000275869, 0.000211088, 0.000146228, 8.13153e-05, 1.63724e-05,
  -4.85767e-05, -0.000113508, -0.000178398, -0.000243223, -0.00030796,
  -0.000372585, -0.000437076, -0.000501409, -0.000565561, -0.00062951,
  -0.000693234, -0.000756709, -0.000819914, -0.000882827,
  -0.000945426, -0.00100769, -0.0010696, -0.00113112, -0.00119225,
  -0.00125296, -0.00131323, -0.00137304, -0.00143237, -0.00149119,
  -0.0015495, -0.00160727, -0.00166448, -0.00172111, -0.00177715,
  -0.00183257, -0.00188736, -0.0019415, -0.00199498, -0.00204777,
  -0.00209987, -0.00215124, -0.00220188, -0.00225178, -0.00230091,
  -0.00234926, -0.00239682, -0.00244356, -0.00248949, -0.00253458,
  -0.00257882, -0.00262219, -0.00266469, -0.0027063, -0.00274701,
  -0.0027868, -0.00282567, -0.00286361, -0.00290059, -0.00293663,
  -0.00297169, -0.00300578, -0.00303888, -0.00307098, -0.00310209,
  -0.00313218, -0.00316125, -0.00318929, -0.0032163, -0.00324226,
  -0.00326718, -0.00329104, -0.00331384, -0.00333558, -0.00335624,
  -0.00337583, -0.00339434, -0.00341177, -0.00342811, -0.00344336,
  -0.00345751, -0.00347057, -0.00348253, -0.00349339, -0.00350315,
  -0.0035118, -0.00351935, -0.0035258, -0.00353114, -0.00353538,
  -0.00353851, -0.00354054, -0.00354147, -0.00354131, -0.00354004,
  -0.00353768, -0.00353422, -0.00352968, -0.00352404, -0.00351733,
  -0.00350954, -0.00350067, -0.00349073, -0.00347972, -0.00346766,
  -0.00345453, -0.00344036, -0.00342515, -0.0034089, -0.00339162,
  -0.00337332, -0.003354, -0.00333367, -0.00331234, -0.00329001,
  -0.00326671, -0.00324242, -0.00321717, -0.00319096, -0.00316381,
  -0.00313571, -0.00310668, -0.00307674, -0.00304589, -0.00301413,
  -0.0029815, -0.00294798, -0.0029136, -0.00287836, -0.00284229,
  -0.00280538, -0.00276766, -0.00272912, -0.0026898, -0.0026497,
  -0.00260882, -0.0025672, -0.00252483, -0.00248173, -0.00243792,
  -0.0023934, -0.0023482, -0.00230233, -0.0022558, -0.00220862,
  -0.00216082, -0.00211239, -0.00206337, -0.00201376, -0.00196358,
  -0.00191285, -0.00186157, -0.00180977, -0.00175746, -0.00170465,
  -0.00165137, -0.00159762, -0.00154342, -0.00148879, -0.00143375,
  -0.00137831, -0.00132248, -0.00126629, -0.00120974, -0.00115286,
  -0.00109566, -0.00103816, -0.000980366, -0.000922306, -0.000863993,
  -0.000805442, -0.00074667, -0.000687694, -0.00062853, -0.000569194,
  -0.000509703, -0.000450073, -0.00039032, -0.000330462, -0.000270514,
  -0.000210493, -0.000150416, -9.02971e-05, -3.01543e-05, 2.99966e-05,
  9.01393e-05, 0.000150258, 0.000210336, 0.000270358, 0.000330308,
  0.000390169, 0.000449926, 0.000509564, 0.000569066, 0.000628417,
  0.000687602, 0.000746604, 0.00080541, 0.000864002, 0.000922367,
  0.000980489, 0.00103835, 0.00109595, 0.00115325, 0.00121025,
  0.00126694, 0.0013233, 0.00137931, 0.00143496, 0.00149024,
  0.00154513, 0.00159962, 0.0016537, 0.00170735, 0.00176056,
  0.00181331, 0.0018656, 0.00191741, 0.00196873, 0.00201954,
  0.00206983, 0.0021196, 0.00216882, 0.00221749, 0.0022656,
  0.00231313, 0.00236007, 0.00240641, 0.00245215, 0.00249726,
  0.00254174, 0.00258558, 0.00262877, 0.0026713, 0.00271316,
  0.00275433, 0.00279482, 0.0028346, 0.00287368, 0.00291204,
  0.00294967, 0.00298657, 0.00302272, 0.00305813, 0.00309277,
  0.00312665, 0.00315976, 0.00319208, 0.00322362, 0.00325436,
  0.00328431, 0.00331344, 0.00334176, 0.00336926, 0.00339594,
  0.00342178, 0.00344679, 0.00347096, 0.00349428, 0.00351675,
  0.00353837, 0.00355912, 0.00357902, 0.00359805, 0.0036162,
  0.00363349, 0.0036499, 0.00366542, 0.00368007, 0.00369383,
  0.00370671, 0.00371869, 0.00372979, 0.00373999, 0.0037493,
  0.00375771, 0.00376523, 0.00377186, 0.00377758, 0.00378241,
  0.00378635, 0.00378938, 0.00379152, 0.00379277, 0.00379312,
  0.00379257, 0.00379113, 0.0037888, 0.00378558, 0.00378148,
  0.00377648, 0.00377061, 0.00376385, 0.00375621, 0.0037477,
  0.00373831, 0.00372806, 0.00371693, 0.00370495, 0.00369211,
  0.00367841, 0.00366386, 0.00364846, 0.00363223, 0.00361515,
  0.00359725, 0.00357851, 0.00355896, 0.00353859, 0.00351741,
  0.00349542, 0.00347263, 0.00344905, 0.00342469, 0.00339954,
  0.00337362, 0.00334694, 0.00331949, 0.0032913, 0.00326235,
  0.00323267, 0.00320226, 0.00317112, 0.00313927, 0.00310672,
  0.00307346, 0.00303952, 0.00300489, 0.00296959, 0.00293362,
  0.002897, 0.00285973, 0.00282182, 0.00278328, 0.00274412,
  0.00270435, 0.00266398, 0.00262302, 0.00258148, 0.00253937,
  0.00249669, 0.00245347, 0.0024097, 0.0023654, 0.00232058,
  0.00227525, 0.00222942, 0.0021831, 0.0021363, 0.00208903,
  0.00204131, 0.00199314, 0.00194453, 0.0018955, 0.00184606,
  0.00179622, 0.00174598, 0.00169537, 0.00164439, 0.00159305,
  0.00154137, 0.00148935, 0.00143701, 0.00138437, 0.00133142,
  0.00127819, 0.00122468, 0.00117091, 0.00111689, 0.00106263,
  0.00100814, 0.000953435, 0.000898527, 0.000843427, 0.000788147,
  0.000732699, 0.000677096, 0.000621348, 0.000565468, 0.000509469,
  0.000453361, 0.000397157, 0.00034087, 0.00028451, 0.00022809,
  0.000171622, 0.000115118, 5.85902e-05, 2.04962e-06, -5.44914e-05,
  -0.000111021, -0.000167528, -0.000223999, -0.000280423, -0.00033679,
  -0.000393085, -0.000449299, -0.00050542, -0.000561435, -0.000617333,
  -0.000673104, -0.000728735, -0.000784215, -0.000839532,
  -0.000894677, -0.000949636, -0.0010044, -0.00105896, -0.00111329,
  -0.0011674, -0.00122127, -0.00127489, -0.00132825, -0.00138133,
  -0.00143414, -0.00148665, -0.00153885, -0.00159074, -0.00164231,
  -0.00169354, -0.00174443, -0.00179496, -0.00184513, -0.00189493,
  -0.00194434, -0.00199335, -0.00204197, -0.00209017, -0.00213795,
  -0.00218529, -0.0022322, -0.00227866, -0.00232466, -0.00237019,
  -0.00241525, -0.00245982, -0.0025039, -0.00254748, -0.00259055,
  -0.0026331, -0.00267512, -0.00271662, -0.00275757, -0.00279797,
  -0.00283782, -0.0028771, -0.00291581, -0.00295394, -0.00299149,
  -0.00302845, -0.0030648, -0.00310056, -0.0031357, -0.00317022,
  -0.00320412, -0.00323738, -0.00327001, -0.003302, -0.00333334,
  -0.00336403, -0.00339406, -0.00342342, -0.00345212, -0.00348014,
  -0.00350748, -0.00353414, -0.00356011, -0.00358538, -0.00360996,
  -0.00363384, -0.00365701, -0.00367948, -0.00370123, -0.00372226,
  -0.00374258, -0.00376217, -0.00378104, -0.00379917, -0.00381658,
  -0.00383325, -0.00384918, -0.00386438, -0.00387883, -0.00389254,
  -0.0039055, -0.00391771, -0.00392918, -0.00393989, -0.00394985,
  -0.00395906, -0.00396752, -0.00397522, -0.00398216, -0.00398834,
  -0.00399377, -0.00399844, -0.00400235, -0.00400551, -0.0040079,
  -0.00400954, -0.00401042, -0.00401054, -0.00400991, -0.00400852,
  -0.00400638, -0.00400348, -0.00399984, -0.00399544, -0.00399029,
  -0.00398439, -0.00397775, -0.00397036, -0.00396223, -0.00395336,
  -0.00394375, -0.00393341, -0.00392234, -0.00391053, -0.003898,
  -0.00388474, -0.00387076, -0.00385606, -0.00384065, -0.00382453,
  -0.0038077, -0.00379017, -0.00377193, -0.003753, -0.00373338,
  -0.00371307, -0.00369208, -0.0036704, -0.00364806, -0.00362504,
  -0.00360136, -0.00357702, -0.00355202, -0.00352637, -0.00350008,
  -0.00347315, -0.00344558, -0.00341739, -0.00338857, -0.00335914,
  -0.00332909, -0.00329844, -0.00326719, -0.00323535, -0.00320292,
  -0.00316991, -0.00313633, -0.00310218, -0.00306747, -0.0030322,
  -0.00299639, -0.00296004, -0.00292315, -0.00288574, -0.00284781,
  -0.00280937, -0.00277042, -0.00273097, -0.00269104, -0.00265062,
  -0.00260973, -0.00256838, -0.00252656, -0.00248429, -0.00244158,
  -0.00239844, -0.00235486, -0.00231087, -0.00226647, -0.00222166,
  -0.00217646, -0.00213088, -0.00208491, -0.00203858, -0.00199189,
  -0.00194484, -0.00189745, -0.00184973, -0.00180168, -0.00175331,
  -0.00170463, -0.00165565, -0.00160638, -0.00155683, -0.00150701,
  -0.00145692, -0.00140658, -0.00135598, -0.00130516, -0.0012541,
  -0.00120283, -0.00115134, -0.00109965, -0.00104778, -0.000995715,
  -0.000943481, -0.000891083, -0.000838531, -0.000785832,
  -0.000732997, -0.000680035, -0.000626955, -0.000573767,
  -0.000520479, -0.000467102, -0.000413644, -0.000360114,
  -0.000306522, -0.000252878, -0.000199189, -0.000145467,
  -9.17198e-05, -3.79567e-05, 1.58129e-05, 6.95798e-05, 0.000123335,
  0.000177068, 0.000230772, 0.000284436, 0.000338051, 0.000391609,
  0.000445099, 0.000498514, 0.000551844, 0.000605079, 0.000658212,
  0.000711233, 0.000764133, 0.000816903, 0.000869535, 0.000922019,
  0.000974346, 0.00102651, 0.0010785, 0.00113031, 0.00118192,
  0.00123334, 0.00128455, 0.00133554, 0.0013863, 0.00143684,
  0.00148713, 0.00153717, 0.00158696, 0.00163647, 0.00168572,
  0.00173468, 0.00178335, 0.00183172, 0.00187978, 0.00192753,
  0.00197496, 0.00202206, 0.00206882, 0.00211524, 0.00216131,
  0.00220701, 0.00225235, 0.00229732, 0.0023419, 0.0023861, 0.0024299,
  0.00247329, 0.00251628, 0.00255885, 0.002601, 0.00264272, 0.002684,
  0.00272484, 0.00276523, 0.00280516, 0.00284464, 0.00288364,
  0.00292217, 0.00296023, 0.00299779, 0.00303486, 0.00307144,
  0.00310751, 0.00314308, 0.00317813, 0.00321266, 0.00324666,
  0.00328014, 0.00331308, 0.00334548, 0.00337734, 0.00340864,
  0.00343939, 0.00346959, 0.00349922, 0.00352828, 0.00355677,
  0.00358468, 0.00361201, 0.00363875, 0.00366491, 0.00369048,
  0.00371545, 0.00373982, 0.00376358, 0.00378674, 0.00380929,
  0.00383123, 0.00385254, 0.00387324, 0.00389332, 0.00391277,
  0.0039316, 0.00394979, 0.00396735, 0.00398428, 0.00400057,
  0.00401622, 0.00403122, 0.00404558, 0.0040593, 0.00407237,
  0.00408479, 0.00409656, 0.00410768, 0.00411814, 0.00412795,
  0.0041371, 0.0041456, 0.00415344, 0.00416062, 0.00416714, 0.004173,
  0.00417821, 0.00418275, 0.00418663, 0.00418984, 0.0041924,
  0.0041943, 0.00419553, 0.00419611, 0.00419602, 0.00419527,
  0.00419387, 0.0041918, 0.00418908, 0.0041857, 0.00418166,
  0.00417697, 0.00417162, 0.00416562, 0.00415897, 0.00415167,
  0.00414372, 0.00413513, 0.00412589, 0.004116, 0.00410548,
  0.00409431, 0.00408251, 0.00407008, 0.00405701, 0.00404331,
  0.00402898, 0.00401403, 0.00399846, 0.00398226, 0.00396545,
  0.00394803, 0.00393, 0.00391136, 0.00389211, 0.00387227, 0.00385183,
  0.00383079, 0.00380916, 0.00378695, 0.00376416, 0.00374078,
  0.00371684, 0.00369232, 0.00366723, 0.00364158, 0.00361538,
  0.00358862, 0.00356131, 0.00353345, 0.00350506, 0.00347613,
  0.00344667, 0.00341668, 0.00338617, 0.00335515, 0.00332362,
  0.00329157, 0.00325903, 0.003226, 0.00319247, 0.00315846,
  0.00312396, 0.003089, 0.00305357, 0.00301767, 0.00298132,
  0.00294451, 0.00290726, 0.00286957, 0.00283145, 0.0027929,
  0.00275393, 0.00271455, 0.00267475, 0.00263455, 0.00259396,
  0.00255298, 0.00251161, 0.00246986, 0.00242775, 0.00238527,
  0.00234243, 0.00229924, 0.0022557, 0.00221183, 0.00216763,
  0.00212311, 0.00207826, 0.00203311, 0.00198765, 0.0019419,
  0.00189585, 0.00184953, 0.00180293, 0.00175606, 0.00170893,
  0.00166154, 0.00161391, 0.00156604, 0.00151794, 0.00146961,
  0.00142107, 0.00137231, 0.00132335, 0.00127419, 0.00122485,
  0.00117533, 0.00112563, 0.00107576, 0.00102574, 0.000975565,
  0.000925247, 0.000874792, 0.000824209, 0.000773505, 0.000722687,
  0.000671762, 0.000620739, 0.000569625, 0.000518427, 0.000467154,
  0.000415811, 0.000364408, 0.000312952, 0.00026145, 0.000209909,
  0.000158338, 0.000106744, 5.51343e-05, 3.5164e-06, -4.8102e-05,
  -9.97134e-05, -0.00015131, -0.000202885, -0.000254431, -0.000305939,
  -0.000357403, -0.000408816, -0.000460168, -0.000511455,
  -0.000562667, -0.000613797, -0.000664839, -0.000715785,
  -0.000766627, -0.000817358, -0.000867971, -0.000918459,
  -0.000968815, -0.00101903, -0.0010691, -0.00111901, -0.00116877,
  -0.00121835, -0.00126776, -0.00131699, -0.00136603, -0.00141487,
  -0.00146351, -0.00151194, -0.00156016, -0.00160815, -0.00165591,
  -0.00170343, -0.00175071, -0.00179774, -0.00184451, -0.00189102,
  -0.00193726, -0.00198322, -0.0020289, -0.00207429, -0.00211938,
  -0.00216418, -0.00220866, -0.00225283, -0.00229669, -0.00234021,
  -0.0023834, -0.00242626, -0.00246877, -0.00251093, -0.00255274,
  -0.00259418, -0.00263526, -0.00267596, -0.00271629, -0.00275623,
  -0.00279578, -0.00283494, -0.0028737, -0.00291205, -0.00294999,
  -0.00298752, -0.00302463, -0.00306131, -0.00309756, -0.00313338,
  -0.00316875, -0.00320368, -0.00323816, -0.00327219, -0.00330576,
  -0.00333886, -0.0033715, -0.00340367, -0.00343536, -0.00346657,
  -0.00349729, -0.00352753, -0.00355727, -0.00358652, -0.00361527,
  -0.00364351, -0.00367125, -0.00369847, -0.00372518, -0.00375138,
  -0.00377705, -0.00380219, -0.00382681, -0.0038509, -0.00387445,
  -0.00389746, -0.00391994, -0.00394187, -0.00396326, -0.00398409,
  -0.00400438, -0.00402411, -0.00404329, -0.00406191, -0.00407997,
  -0.00409746, -0.00411439, -0.00413076, -0.00414655, -0.00416177,
  -0.00417642, -0.0041905, -0.004204, -0.00421692, -0.00422926,
  -0.00424102, -0.0042522, -0.0042628, -0.00427281, -0.00428224,
  -0.00429108, -0.00429933, -0.004307, -0.00431408, -0.00432056,
  -0.00432646, -0.00433176, -0.00433648, -0.0043406, -0.00434413,
  -0.00434707, -0.00434942, -0.00435117, -0.00435234, -0.00435291,
  -0.00435289, -0.00435228, -0.00435107, -0.00434928, -0.0043469,
  -0.00434392, -0.00434036, -0.00433621, -0.00433147, -0.00432615,
  -0.00432024, -0.00431375, -0.00430667, -0.00429901, -0.00429078,
  -0.00428196, -0.00427256, -0.00426259, -0.00425205, -0.00424093,
  -0.00422924, -0.00421698, -0.00420416, -0.00419077, -0.00417681,
  -0.0041623, -0.00414722, -0.00413159, -0.00411541, -0.00409867,
  -0.00408139, -0.00406356, -0.00404518, -0.00402626, -0.00400681,
  -0.00398682, -0.00396629, -0.00394524, -0.00392366, -0.00390155,
  -0.00387893, -0.00385579, -0.00383213, -0.00380797, -0.00378329,
  -0.00375812, -0.00373244, -0.00370627, -0.00367961, -0.00365245,
  -0.00362482, -0.0035967, -0.0035681, -0.00353903, -0.00350949,
  -0.00347949, -0.00344903, -0.00341811, -0.00338673, -0.00335491,
  -0.00332265, -0.00328995, -0.00325681, -0.00322325, -0.00318925,
  -0.00315484, -0.00312001, -0.00308478, -0.00304913, -0.00301308,
  -0.00297664, -0.00293981, -0.00290259, -0.00286499, -0.00282701,
  -0.00278866, -0.00274994, -0.00271087, -0.00267144, -0.00263166,
  -0.00259153, -0.00255107, -0.00251027, -0.00246914, -0.00242769,
  -0.00238593, -0.00234385, -0.00230146, -0.00225878, -0.0022158,
  -0.00217253, -0.00212898, -0.00208515, -0.00204105, -0.00199668,
  -0.00195206, -0.00190718, -0.00186205, -0.00181668, -0.00177108,
  -0.00172524, -0.00167918, -0.00163291, -0.00158642, -0.00153972,
  -0.00149283, -0.00144574, -0.00139847, -0.00135102, -0.00130339,
  -0.00125559, -0.00120763, -0.00115951, -0.00111125, -0.00106284,
  -0.00101429, -0.000965615, -0.000916813, -0.000867894, -0.000818863,
  -0.000769727, -0.000720491, -0.000671163, -0.000621749,
  -0.000572255, -0.000522687, -0.000473053, -0.000423357,
  -0.000373607, -0.00032381, -0.000273971, -0.000224097, -0.000174194,
  -0.000124269, -7.43279e-05, -2.43775e-05, 2.5576e-05, 7.55263e-05,
  0.000125467, 0.000175391, 0.000225294, 0.000275167, 0.000325005,
  0.000374802, 0.000424551, 0.000474246, 0.000523881, 0.000573449,
  0.000622944, 0.00067236, 0.00072169, 0.000770929, 0.000820069,
  0.000869106, 0.000918032, 0.000966842, 0.00101553, 0.00106409,
  0.00111251, 0.00116079, 0.00120893, 0.00125691, 0.00130474,
  0.0013524, 0.00139989, 0.0014472, 0.00149433, 0.00154127,
  0.00158801, 0.00163456, 0.0016809, 0.00172702, 0.00177293,
  0.00181862, 0.00186408, 0.0019093, 0.00195428, 0.00199902,
  0.00204351, 0.00208774, 0.00213171, 0.00217541, 0.00221883,
  0.00226198, 0.00230485, 0.00234742, 0.00238971, 0.00243169,
  0.00247337, 0.00251474, 0.00255579, 0.00259653, 0.00263694,
  0.00267702, 0.00271677, 0.00275618, 0.00279524, 0.00283396,
  0.00287232, 0.00291033, 0.00294797, 0.00298525, 0.00302215,
  0.00305868, 0.00309483, 0.00313059, 0.00316596, 0.00320094,
  0.00323553, 0.00326971, 0.00330348, 0.00333685, 0.0033698,
  0.00340234, 0.00343445, 0.00346614, 0.0034974, 0.00352822,
  0.00355861, 0.00358856, 0.00361807, 0.00364713, 0.00367574,
  0.00370389, 0.00373159, 0.00375883, 0.0037856, 0.00381191,
  0.00383775, 0.00386311, 0.003888, 0.00391242, 0.00393635,
  0.00395979, 0.00398275, 0.00400522, 0.0040272, 0.00404868,
  0.00406967, 0.00409015, 0.00411014, 0.00412962, 0.00414859,
  0.00416706, 0.00418502, 0.00420246, 0.00421939, 0.0042358,
  0.0042517, 0.00426707, 0.00428193, 0.00429626, 0.00431006,
  0.00432334, 0.0043361, 0.00434832, 0.00436001, 0.00437118,
  0.00438181, 0.0043919, 0.00440146, 0.00441049, 0.00441898,
  0.00442693, 0.00443434, 0.00444122, 0.00444755, 0.00445335,
  0.0044586, 0.00446332, 0.00446749, 0.00447112, 0.00447421,
  0.00447675, 0.00447876, 0.00448022, 0.00448114, 0.00448151,
  0.00448135, 0.00448064, 0.00447939, 0.0044776, 0.00447527,
  0.0044724, 0.00446899, 0.00446504, 0.00446055, 0.00445553,
  0.00444996, 0.00444386, 0.00443723, 0.00443006, 0.00442236,
  0.00441413, 0.00440536, 0.00439607, 0.00438624, 0.00437589,
  0.00436502, 0.00435362, 0.0043417, 0.00432926, 0.00431629,
  0.00430281, 0.00428882, 0.00427431, 0.00425929, 0.00424376,
  0.00422772, 0.00421118, 0.00419413, 0.00417658, 0.00415853,
  0.00413999, 0.00412095, 0.00410142, 0.0040814, 0.00406089,
  0.0040399, 0.00401842, 0.00399647, 0.00397404, 0.00395114,
  0.00392777, 0.00390393, 0.00387962, 0.00385486, 0.00382963,
  0.00380395, 0.00377782, 0.00375124, 0.00372422, 0.00369675,
  0.00366884, 0.0036405, 0.00361173, 0.00358253, 0.0035529,
  0.00352286, 0.00349239, 0.00346152, 0.00343023, 0.00339854,
  0.00336645, 0.00333395, 0.00330107, 0.00326779, 0.00323413,
  0.00320009, 0.00316567, 0.00313087, 0.00309571, 0.00306018,
  0.00302429, 0.00298804, 0.00295145, 0.0029145, 0.00287721,
  0.00283959, 0.00280163, 0.00276334, 0.00272472, 0.00268579,
  0.00264654, 0.00260697, 0.00256711, 0.00252694, 0.00248647,
  0.00244572, 0.00240467, 0.00236335, 0.00232174, 0.00227987,
  0.00223773, 0.00219533, 0.00215267, 0.00210976, 0.0020666,
  0.0020232, 0.00197956, 0.00193569, 0.0018916, 0.00184728,
  0.00180275, 0.00175801, 0.00171307, 0.00166792, 0.00162258,
  0.00157706, 0.00153134, 0.00148545, 0.00143939, 0.00139316,
  0.00134676, 0.00130021, 0.00125351, 0.00120667, 0.00115968,
  0.00111256, 0.00106531, 0.00101793, 0.00097044, 0.000922835,
  0.000875123, 0.000827309, 0.0007794, 0.0007314, 0.000683315,
  0.000635151, 0.000586914, 0.000538609, 0.000490242, 0.000441817,
  0.000393342, 0.000344821, 0.000296261, 0.000247666, 0.000199042,
  0.000150396, 0.000101732, 5.30565e-05, 4.37479e-06, -4.43074e-05,
  -9.29845e-05, -0.000141651, -0.000190301, -0.000238929, -0.00028753,
  -0.000336098, -0.000384627, -0.000433112, -0.000481547,
  -0.000529926, -0.000578245, -0.000626498, -0.000674678,
  -0.000722781, -0.000770801, -0.000818733, -0.000866571, -0.00091431,
  -0.000961943, -0.00100947, -0.00105687, -0.00110416, -0.00115132,
  -0.00119835, -0.00124524, -0.00129199, -0.00133859, -0.00138504,
  -0.00143133, -0.00147746, -0.00152342, -0.0015692, -0.00161481,
  -0.00166023, -0.00170546, -0.0017505, -0.00179533, -0.00183997,
  -0.00188439, -0.0019286, -0.00197259, -0.00201635, -0.00205989,
  -0.00210319, -0.00214625, -0.00218907, -0.00223164, -0.00227395,
  -0.00231601, -0.0023578, -0.00239933, -0.00244059, -0.00248156,
  -0.00252226, -0.00256267, -0.00260279, -0.00264261, -0.00268214,
  -0.00272136, -0.00276027, -0.00279887, -0.00283715, -0.00287512,
  -0.00291275, -0.00295006, -0.00298704, -0.00302367, -0.00305997,
  -0.00309592, -0.00313152, -0.00316677, -0.00320166, -0.00323619,
  -0.00327035, -0.00330414, -0.00333757, -0.00337061, -0.00340328,
  -0.00343556, -0.00346746, -0.00349896, -0.00353008, -0.00356079,
  -0.00359111, -0.00362102, -0.00365052, -0.00367962, -0.0037083,
  -0.00373656, -0.00376441, -0.00379183, -0.00381882, -0.00384539,
  -0.00387153, -0.00389723, -0.0039225, -0.00394732, -0.00397171,
  -0.00399565, -0.00401914, -0.00404218, -0.00406477, -0.00408691,
  -0.00410859, -0.0041298, -0.00415056, -0.00417085, -0.00419068,
  -0.00421004, -0.00422893, -0.00424735, -0.00426529, -0.00428276,
  -0.00429975, -0.00431626, -0.00433228, -0.00434783, -0.00436289,
  -0.00437747, -0.00439156, -0.00440515, -0.00441826, -0.00443088,
  -0.00444301, -0.00445464, -0.00446577, -0.00447641, -0.00448655,
  -0.00449619, -0.00450534, -0.00451398, -0.00452212, -0.00452976,
  -0.0045369, -0.00454354, -0.00454967, -0.00455529, -0.00456041,
  -0.00456503, -0.00456914, -0.00457275, -0.00457584, -0.00457844,
  -0.00458052, -0.0045821, -0.00458317, -0.00458374, -0.0045838,
  -0.00458335, -0.00458239, -0.00458093, -0.00457897, -0.00457649,
  -0.00457352, -0.00457003, -0.00456605, -0.00456156, -0.00455657,
  -0.00455107, -0.00454508, -0.00453858, -0.00453158, -0.00452409,
  -0.00451609, -0.0045076, -0.00449862, -0.00448914, -0.00447916,
  -0.00446869, -0.00445774, -0.00444629, -0.00443435, -0.00442193,
  -0.00440902, -0.00439562, -0.00438175, -0.00436739, -0.00435255,
  -0.00433724, -0.00432145, -0.00430519, -0.00428846, -0.00427125,
  -0.00425358, -0.00423544, -0.00421684, -0.00419778, -0.00417826,
  -0.00415828, -0.00413784, -0.00411696, -0.00409562, -0.00407384,
  -0.00405161, -0.00402894, -0.00400583, -0.00398228, -0.00395829,
  -0.00393388, -0.00390903, -0.00388376, -0.00385807, -0.00383195,
  -0.00380542, -0.00377847, -0.00375111, -0.00372335, -0.00369517,
  -0.0036666, -0.00363762, -0.00360825, -0.00357849, -0.00354834,
  -0.0035178, -0.00348688, -0.00345558, -0.00342391, -0.00339186,
  -0.00335945, -0.00332667, -0.00329353, -0.00326003, -0.00322618,
  -0.00319198, -0.00315743, -0.00312254, -0.00308731, -0.00305175,
  -0.00301586, -0.00297964, -0.00294309, -0.00290623, -0.00286906,
  -0.00283157, -0.00279378, -0.00275568, -0.00271729, -0.0026786,
  -0.00263963, -0.00260037, -0.00256082, -0.00252101, -0.00248091,
  -0.00244056, -0.00239993, -0.00235905, -0.00231792, -0.00227653,
  -0.0022349, -0.00219303, -0.00215092, -0.00210858, -0.00206601,
  -0.00202322, -0.00198021, -0.00193699, -0.00189356, -0.00184993,
  -0.00180609, -0.00176207, -0.00171785, -0.00167345, -0.00162887,
  -0.00158411, -0.00153919, -0.0014941, -0.00144885, -0.00140344,
  -0.00135788, -0.00131218, -0.00126633, -0.00122035, -0.00117424,
  -0.001128, -0.00108165, -0.00103517, -0.000988587, -0.000941897,
  -0.000895105, -0.000848218, -0.00080124, -0.000754176, -0.000707031,
  -0.000659811, -0.00061252, -0.000565164, -0.000517747, -0.000470275,
  -0.000422753, -0.000375185, -0.000327578, -0.000279935,
  -0.000232263, -0.000184565, -0.000136849, -8.91171e-05,
  -4.13762e-05, 6.3692e-06, 5.41139e-05, 0.000101853, 0.000149581,
  0.000197293, 0.000244984, 0.000292649, 0.000340282, 0.00038788,
  0.000435436, 0.000482946, 0.000530404, 0.000577806, 0.000625147,
  0.000672421, 0.000719623, 0.000766749, 0.000813794, 0.000860752,
  0.000907618, 0.000954388, 0.00100106, 0.00104762, 0.00109407,
  0.00114041, 0.00118662, 0.00123271, 0.00127867, 0.00132449,
  0.00137017, 0.00141571, 0.00146109, 0.00150632, 0.0015514,
  0.0015963, 0.00164104, 0.00168561, 0.00172999, 0.0017742,
  0.00181821, 0.00186204, 0.00190566, 0.00194909, 0.00199231,
  0.00203531, 0.00207811, 0.00212068, 0.00216303, 0.00220515,
  0.00224704, 0.00228869, 0.0023301, 0.00237127, 0.00241218,
  0.00245284, 0.00249324, 0.00253338, 0.00257325, 0.00261285,
  0.00265217, 0.00269122, 0.00272998, 0.00276845, 0.00280663,
  0.00284452, 0.00288211, 0.00291939, 0.00295637, 0.00299304,
  0.00302939, 0.00306542, 0.00310113, 0.00313652, 0.00317157,
  0.0032063, 0.00324068, 0.00327473, 0.00330843, 0.00334178,
  0.00337479, 0.00340744, 0.00343973, 0.00347166, 0.00350323,
  0.00353443, 0.00356526, 0.00359571, 0.00362579, 0.00365549,
  0.0036848, 0.00371373, 0.00374228, 0.00377043, 0.00379818,
  0.00382554, 0.0038525, 0.00387905, 0.0039052, 0.00393094,
  0.00395627, 0.00398118, 0.00400568, 0.00402976, 0.00405343,
  0.00407666, 0.00409947, 0.00412186, 0.00414381, 0.00416533,
  0.00418642, 0.00420706, 0.00422727, 0.00424704, 0.00426637,
  0.00428525, 0.00430369, 0.00432167, 0.00433921, 0.00435629,
  0.00437293, 0.0043891, 0.00440482, 0.00442008, 0.00443488,
  0.00444922, 0.00446309, 0.0044765, 0.00448945, 0.00450193,
  0.00451394, 0.00452548, 0.00453655, 0.00454715, 0.00455728,
  0.00456693, 0.00457611, 0.00458482, 0.00459304, 0.0046008,
  0.00460807, 0.00461487, 0.00462119, 0.00462702, 0.00463238,
  0.00463726, 0.00464166, 0.00464557, 0.00464901, 0.00465196,
  0.00465443, 0.00465642, 0.00465793, 0.00465896, 0.0046595,
  0.00465956, 0.00465914, 0.00465823, 0.00465685, 0.00465498,
  0.00465263, 0.0046498, 0.00464649, 0.0046427, 0.00463843,
  0.00463368, 0.00462846, 0.00462275, 0.00461657, 0.00460991,
  0.00460277, 0.00459516, 0.00458707, 0.00457852, 0.00456948,
  0.00455998, 0.00455001, 0.00453957, 0.00452866, 0.00451728,
  0.00450544, 0.00449314, 0.00448037, 0.00446714, 0.00445345,
  0.0044393, 0.00442469, 0.00440963, 0.00439412, 0.00437815,
  0.00436173, 0.00434486, 0.00432755, 0.00430979, 0.00429159,
  0.00427295, 0.00425387, 0.00423435, 0.0042144, 0.00419401,
  0.00417319, 0.00415195, 0.00413027, 0.00410818, 0.00408566,
  0.00406272, 0.00403937, 0.0040156, 0.00399142, 0.00396683,
  0.00394183, 0.00391643, 0.00389063, 0.00386443, 0.00383783,
  0.00381084, 0.00378346, 0.00375569, 0.00372754, 0.00369901,
  0.00367009, 0.00364081, 0.00361114, 0.00358111, 0.00355072,
  0.00351996, 0.00348884, 0.00345736, 0.00342553, 0.00339335,
  0.00336082, 0.00332795, 0.00329474, 0.00326119, 0.00322731,
  0.0031931, 0.00315856, 0.0031237, 0.00308852, 0.00305303,
  0.00301723, 0.00298111, 0.0029447, 0.00290798, 0.00287097,
  0.00283366, 0.00279606, 0.00275818, 0.00272002, 0.00268158,
  0.00264287, 0.00260389, 0.00256464, 0.00252513, 0.00248537,
  0.00244535, 0.00240508, 0.00236457, 0.00232382, 0.00228283,
  0.00224161, 0.00220016, 0.00215849, 0.00211659, 0.00207449,
  0.00203217, 0.00198964, 0.00194691, 0.00190399, 0.00186087,
  0.00181756, 0.00177407, 0.0017304, 0.00168655, 0.00164253,
  0.00159834, 0.00155399, 0.00150948, 0.00146483, 0.00142002,
  0.00137506, 0.00132997, 0.00128475, 0.00123939, 0.00119391,
  0.0011483, 0.00110258, 0.00105675, 0.00101081, 0.000964769,
  0.00091863, 0.000872398, 0.000826077, 0.000779673, 0.00073319,
  0.000686633, 0.000640006, 0.000593314, 0.000546562, 0.000499755,
  0.000452897, 0.000405994, 0.00035905, 0.000312069, 0.000265056,
  0.000218017, 0.000170956, 0.000123877, 7.67863e-05, 2.96875e-05,
  -1.74143e-05, -6.45144e-05, -0.000111608, -0.00015869, -0.000205757,
  -0.000252802, -0.000299822, -0.000346812, -0.000393767,
  -0.000440682, -0.000487553, -0.000534374, -0.000581142,
  -0.000627851, -0.000674497, -0.000721075, -0.00076758, -0.000814008,
  -0.000860353, -0.000906612, -0.00095278, -0.000998852, -0.00104482,
  -0.00109069, -0.00113645, -0.00118209, -0.00122761, -0.00127301,
  -0.00131828, -0.00136342, -0.00140842, -0.00145328, -0.00149799,
  -0.00154256, -0.00158697, -0.00163121, -0.0016753, -0.00171921,
  -0.00176296, -0.00180652, -0.00184991, -0.00189311, -0.00193612,
  -0.00197893, -0.00202155, -0.00206396, -0.00210616, -0.00214816,
  -0.00218994, -0.00223149, -0.00227283, -0.00231394, -0.00235481,
  -0.00239545, -0.00243585, -0.002476, -0.0025159, -0.00255556,
  -0.00259496, -0.00263409, -0.00267297, -0.00271157, -0.0027499,
  -0.00278796, -0.00282574, -0.00286324, -0.00290045, -0.00293736,
  -0.00297399, -0.00301032, -0.00304634, -0.00308206, -0.00311747,
  -0.00315257, -0.00318736, -0.00322182, -0.00325597, -0.00328979,
  -0.00332328, -0.00335643, -0.00338925, -0.00342174, -0.00345388,
  -0.00348567, -0.00351712, -0.00354821, -0.00357896, -0.00360934,
  -0.00363936, -0.00366902, -0.00369832, -0.00372724, -0.00375579,
  -0.00378397, -0.00381177, -0.00383919, -0.00386622, -0.00389287,
  -0.00391913, -0.00394501, -0.00397048, -0.00399556, -0.00402025,
  -0.00404453, -0.00406841, -0.00409188, -0.00411495, -0.0041376,
  -0.00415984, -0.00418167, -0.00420308, -0.00422408, -0.00424465,
  -0.0042648, -0.00428453, -0.00430382, -0.00432269, -0.00434113,
  -0.00435914, -0.00437671, -0.00439385, -0.00441055, -0.00442681,
  -0.00444264, -0.00445802, -0.00447295, -0.00448744, -0.00450149,
  -0.00451509, -0.00452824, -0.00454093, -0.00455318, -0.00456498,
  -0.00457632, -0.0045872, -0.00459763, -0.00460761, -0.00461712,
  -0.00462618, -0.00463478, -0.00464292, -0.00465059, -0.00465781,
  -0.00466456, -0.00467085, -0.00467668, -0.00468204, -0.00468694,
  -0.00469137, -0.00469534, -0.00469884, -0.00470187, -0.00470444,
  -0.00470654, -0.00470818, -0.00470935, -0.00471005, -0.00471028,
  -0.00471005, -0.00470935, -0.00470819, -0.00470656, -0.00470446,
  -0.00470189, -0.00469886, -0.00469537, -0.00469141, -0.00468698,
  -0.00468209, -0.00467674, -0.00467093, -0.00466465, -0.00465791,
  -0.00465071, -0.00464305, -0.00463493, -0.00462635, -0.00461731,
  -0.00460782, -0.00459787, -0.00458746, -0.00457661, -0.0045653,
  -0.00455353, -0.00454132, -0.00452866, -0.00451555, -0.004502,
  -0.004488, -0.00447356, -0.00445867, -0.00444335, -0.00442758,
  -0.00441138, -0.00439474, -0.00437767, -0.00436017, -0.00434223,
  -0.00432387, -0.00430508, -0.00428586, -0.00426623, -0.00424617,
  -0.00422569, -0.00420479, -0.00418349, -0.00416176, -0.00413963,
  -0.00411709, -0.00409414, -0.00407079, -0.00404704, -0.00402288,
  -0.00399834, -0.00397339, -0.00394806, -0.00392233, -0.00389622,
  -0.00386973, -0.00384285, -0.0038156, -0.00378797, -0.00375997,
  -0.00373159, -0.00370285, -0.00367375, -0.00364428, -0.00361445,
  -0.00358427, -0.00355373, -0.00352285, -0.00349162, -0.00346004,
  -0.00342812, -0.00339587, -0.00336328, -0.00333036, -0.00329712,
  -0.00326355, -0.00322965, -0.00319544, -0.00316092, -0.00312609,
  -0.00309094, -0.0030555, -0.00301975, -0.00298371, -0.00294737,
  -0.00291074, -0.00287383, -0.00283663, -0.00279916, -0.00276141,
  -0.00272339, -0.0026851, -0.00264655, -0.00260774, -0.00256867,
  -0.00252935, -0.00248978, -0.00244997, -0.00240992, -0.00236963,
  -0.0023291, -0.00228835, -0.00224738, -0.00220618, -0.00216477,
  -0.00212314, -0.0020813, -0.00203927, -0.00199703, -0.00195459,
  -0.00191197, -0.00186915, -0.00182616, -0.00178298, -0.00173963,
  -0.00169611, -0.00165242, -0.00160857, -0.00156456, -0.0015204,
  -0.00147609, -0.00143163, -0.00138704, -0.00134231, -0.00129745,
  -0.00125246, -0.00120734, -0.00116211, -0.00111677, -0.00107131,
  -0.00102575, -0.000980095, -0.000934339, -0.000888492, -0.000842558,
  -0.000796542, -0.000750447, -0.000704279, -0.000658042,
  -0.000611741, -0.00056538, -0.000518963, -0.000472496, -0.000425982,
  -0.000379427, -0.000332835, -0.00028621, -0.000239557, -0.000192881,
  -0.000146186, -9.94761e-05, -5.27569e-05, -6.03251e-06, 4.06924e-05,
  8.74133e-05, 0.000134126, 0.000180825, 0.000227507, 0.000274166,
  0.000320798, 0.000367399, 0.000413965, 0.000460489, 0.000506969,
  0.000553399, 0.000599775, 0.000646092, 0.000692347, 0.000738533,
  0.000784648, 0.000830685, 0.000876642, 0.000922513, 0.000968294,
  0.00101398, 0.00105957, 0.00110505, 0.00115043, 0.00119569,
  0.00124084, 0.00128586, 0.00133076, 0.00137553, 0.00142017,
  0.00146466, 0.00150902, 0.00155323, 0.00159728, 0.00164118,
  0.00168492, 0.00172849, 0.0017719, 0.00181513, 0.00185819,
  0.00190106, 0.00194375, 0.00198625, 0.00202856, 0.00207067,
  0.00211257, 0.00215427, 0.00219576, 0.00223704, 0.00227809,
  0.00231893, 0.00235954, 0.00239992, 0.00244006, 0.00247997,
  0.00251964, 0.00255906, 0.00259823, 0.00263715, 0.00267581,
  0.00271421, 0.00275234, 0.00279021, 0.0028278, 0.00286512,
  0.00290216, 0.00293892, 0.00297539, 0.00301157, 0.00304746,
  0.00308305, 0.00311835, 0.00315333, 0.00318801, 0.00322238,
  0.00325644, 0.00329018, 0.0033236, 0.00335669, 0.00338946,
  0.0034219, 0.003454, 0.00348577, 0.0035172, 0.00354829, 0.00357903,
  0.00360943, 0.00363947, 0.00366916, 0.00369849, 0.00372746,
  0.00375607, 0.00378431, 0.00381219, 0.00383969, 0.00386682,
  0.00389358, 0.00391995, 0.00394595, 0.00397156, 0.00399678,
  0.00402162, 0.00404606, 0.00407011, 0.00409377, 0.00411703,
  0.00413988, 0.00416234, 0.00418439, 0.00420603, 0.00422727,
  0.00424809, 0.0042685, 0.0042885, 0.00430807, 0.00432723,
  0.00434597, 0.00436429, 0.00438218, 0.00439965, 0.00441669,
  0.0044333, 0.00444948, 0.00446523, 0.00448054, 0.00449542,
  0.00450986, 0.00452386, 0.00453743, 0.00455055, 0.00456323,
  0.00457547, 0.00458726, 0.00459861, 0.00460951, 0.00461997,
  0.00462997, 0.00463953, 0.00464863, 0.00465729, 0.00466549,
  0.00467324, 0.00468053, 0.00468737, 0.00469376, 0.00469969,
  0.00470516, 0.00471018, 0.00471473, 0.00471884, 0.00472248,
  0.00472567, 0.00472839, 0.00473066, 0.00473247, 0.00473382,
  0.00473471, 0.00473514, 0.00473511, 0.00473462, 0.00473367,
  0.00473227, 0.0047304, 0.00472808, 0.00472529, 0.00472205,
  0.00471835, 0.00471419, 0.00470958, 0.00470451, 0.00469898,
  0.00469299, 0.00468655, 0.00467966, 0.00467231, 0.00466451,
  0.00465626, 0.00464755, 0.0046384, 0.00462879, 0.00461874,
  0.00460824, 0.00459729, 0.00458589, 0.00457405, 0.00456177,
  0.00454905, 0.00453588, 0.00452228, 0.00450823, 0.00449375,
  0.00447883, 0.00446348, 0.0044477, 0.00443148, 0.00441484,
  0.00439777, 0.00438027, 0.00436235, 0.004344, 0.00432523,
  0.00430605, 0.00428644, 0.00426643, 0.00424599, 0.00422515,
  0.0042039, 0.00418224, 0.00416017, 0.0041377, 0.00411483,
  0.00409157, 0.0040679, 0.00404384, 0.00401939, 0.00399455,
  0.00396932, 0.00394371, 0.00391772, 0.00389135, 0.0038646,
  0.00383747, 0.00380998, 0.00378211, 0.00375388, 0.00372528,
  0.00369633, 0.00366701, 0.00363734, 0.00360732, 0.00357695,
  0.00354623, 0.00351517, 0.00348377, 0.00345203, 0.00341996,
  0.00338756, 0.00335482, 0.00332177, 0.00328839, 0.00325469,
  0.00322068, 0.00318635, 0.00315172, 0.00311678, 0.00308154,
  0.003046, 0.00301017, 0.00297405, 0.00293763, 0.00290094,
  0.00286396, 0.0028267, 0.00278917, 0.00275137, 0.00271331,
  0.00267498, 0.00263639, 0.00259755, 0.00255846, 0.00251912,
  0.00247953, 0.00243971, 0.00239964, 0.00235935, 0.00231883,
  0.00227808, 0.00223711, 0.00219593, 0.00215453, 0.00211293,
  0.00207112, 0.00202911, 0.0019869, 0.0019445, 0.00190192,
  0.00185915, 0.0018162, 0.00177307, 0.00172977, 0.0016863,
  0.00164268, 0.00159889, 0.00155494, 0.00151085, 0.00146661,
  0.00142223, 0.00137771, 0.00133306, 0.00128828, 0.00124337,
  0.00119834, 0.0011532, 0.00110795, 0.00106259, 0.00101712,
  0.000971558, 0.000925901, 0.000880155, 0.000834323, 0.000788411,
  0.000742422, 0.000696362, 0.000650234, 0.000604043, 0.000557793,
  0.00051149, 0.000465137, 0.000418739, 0.000372301, 0.000325826,
  0.00027932, 0.000232787, 0.000186232, 0.000139658, 9.30709e-05,
  4.64747e-05, -1.26007e-07, -4.67267e-05, -9.33229e-05, -0.00013991,
  -0.000186484, -0.000233039, -0.000279572, -0.000326078,
  -0.000372553, -0.000418991, -0.000465389, -0.000511742,
  -0.000558045, -0.000604295, -0.000650486, -0.000696614,
  -0.000742674, -0.000788663, -0.000834575, -0.000880407,
  -0.000926153, -0.00097181, -0.00101737, -0.00106284, -0.0011082,
  -0.00115345, -0.0011986, -0.00124362, -0.00128853, -0.00133331,
  -0.00137796, -0.00142248, -0.00146686, -0.0015111, -0.0015552,
  -0.00159914, -0.00164293, -0.00168656, -0.00173002, -0.00177332,
  -0.00181645, -0.0018594, -0.00190217, -0.00194476, -0.00198716,
  -0.00202936, -0.00207137, -0.00211318, -0.00215479, -0.00219618,
  -0.00223737, -0.00227833, -0.00231908, -0.0023596, -0.0023999,
  -0.00243996, -0.00247978, -0.00251937, -0.00255871, -0.0025978,
  -0.00263665, -0.00267523, -0.00271356, -0.00275163, -0.00278943,
  -0.00282695, -0.00286421, -0.00290119, -0.00293789, -0.0029743,
  -0.00301042, -0.00304626, -0.00308179, -0.00311703, -0.00315197,
  -0.0031866, -0.00322093, -0.00325494, -0.00328864, -0.00332202,
  -0.00335508, -0.00338781, -0.00342021, -0.00345228, -0.00348402,
  -0.00351542, -0.00354649, -0.0035772, -0.00360757, -0.0036376,
  -0.00366727, -0.00369658, -0.00372554, -0.00375413, -0.00378236,
  -0.00381023, -0.00383772, -0.00386485, -0.0038916, -0.00391797,
  -0.00394396, -0.00396958, -0.0039948, -0.00401964, -0.00404409,
  -0.00406815, -0.00409182, -0.00411509, -0.00413796, -0.00416042,
  -0.00418249, -0.00420415, -0.0042254, -0.00424625, -0.00426668,
  -0.0042867, -0.0043063, -0.00432549, -0.00434425, -0.0043626,
  -0.00438052, -0.00439802, -0.00441509, -0.00443174, -0.00444795,
  -0.00446373, -0.00447909, -0.004494, -0.00450848, -0.00452253,
  -0.00453613, -0.0045493, -0.00456202, -0.00457431, -0.00458615,
  -0.00459754, -0.00460849, -0.00461899, -0.00462904, -0.00463865,
  -0.00464781, -0.00465651, -0.00466476, -0.00467256, -0.00467991,
  -0.00468681, -0.00469324, -0.00469923, -0.00470476, -0.00470983,
  -0.00471444, -0.0047186, -0.0047223, -0.00472554, -0.00472833,
  -0.00473065, -0.00473252, -0.00473393, -0.00473487, -0.00473536,
  -0.00473539, -0.00473496, -0.00473407, -0.00473272, -0.00473091,
  -0.00472864, -0.00472592, -0.00472273, -0.00471909, -0.00471499,
  -0.00471043, -0.00470541, -0.00469994, -0.00469401, -0.00468762,
  -0.00468078, -0.00467349, -0.00466574, -0.00465754, -0.00464888,
  -0.00463978, -0.00463022, -0.00462022, -0.00460977, -0.00459886,
  -0.00458752, -0.00457572, -0.00456348, -0.0045508, -0.00453768,
  -0.00452412, -0.00451011, -0.00449567, -0.00448079, -0.00446548,
  -0.00444973, -0.00443355, -0.00441694, -0.0043999, -0.00438244,
  -0.00436454, -0.00434623, -0.00432749, -0.00430833, -0.00428875,
  -0.00426875, -0.00424834, -0.00422752, -0.00420628, -0.00418464,
  -0.00416259, -0.00414014, -0.00411728, -0.00409402, -0.00407037,
  -0.00404632, -0.00402187, -0.00399703, -0.00397181, -0.0039462,
  -0.0039202, -0.00389383, -0.00386707, -0.00383994, -0.00381244,
  -0.00378456, -0.00375632, -0.00372771, -0.00369874, -0.00366941,
  -0.00363972, -0.00360968, -0.00357928, -0.00354854, -0.00351746,
  -0.00348603, -0.00345426, -0.00342215, -0.00338971, -0.00335694,
  -0.00332385, -0.00329043, -0.00325669, -0.00322264, -0.00318827,
  -0.00315358, -0.0031186, -0.00308331, -0.00304771, -0.00301183,
  -0.00297564, -0.00293917, -0.00290242, -0.00286538, -0.00282806,
  -0.00279046, -0.00275259, -0.00271446, -0.00267606, -0.0026374,
  -0.00259848, -0.00255931, -0.00251989, -0.00248022, -0.00244032,
  -0.00240017, -0.00235979, -0.00231918, -0.00227835, -0.00223729,
  -0.00219601, -0.00215452, -0.00211282, -0.00207092, -0.00202881,
  -0.0019865, -0.001944, -0.00190131, -0.00185844, -0.00181538,
  -0.00177215, -0.00172875, -0.00168517, -0.00164143, -0.00159753,
  -0.00155348, -0.00150927, -0.00146492, -0.00142042, -0.00137578,
  -0.00133101, -0.00128611, -0.00124109, -0.00119594, -0.00115068,
  -0.0011053, -0.00105982, -0.00101423, -0.000968546, -0.000922765,
  -0.000876894, -0.000830937, -0.0007849, -0.000738785, -0.000692599,
  -0.000646344, -0.000600027, -0.000553651, -0.000507221,
  -0.000460741, -0.000414217, -0.000367651, -0.00032105, -0.000274418,
  -0.000227759, -0.000181077, -0.000134378, -8.76654e-05,
  -4.09444e-05, 5.7805e-06, 5.25048e-05, 9.92241e-05, 0.000145934,
  0.000192629, 0.000239305, 0.000285958, 0.000332583, 0.000379175,
  0.00042573, 0.000472244, 0.000518711, 0.000565128, 0.000611489,
  0.00065779, 0.000704027, 0.000750195, 0.00079629, 0.000842306,
  0.00088824, 0.000934087, 0.000979843, 0.0010255, 0.00107106,
  0.00111652, 0.00116186, 0.00120709, 0.0012522, 0.00129719,
  0.00134206, 0.00138679, 0.00143138, 0.00147584, 0.00152015,
  0.00156431, 0.00160832, 0.00165217, 0.00169585, 0.00173938,
  0.00178273, 0.0018259, 0.0018689, 0.00191172, 0.00195434,
  0.00199678, 0.00203901, 0.00208105, 0.00212289, 0.00216451,
  0.00220593, 0.00224712, 0.0022881, 0.00232885, 0.00236937,
  0.00240966, 0.00244972, 0.00248953, 0.0025291, 0.00256842,
  0.00260749, 0.0026463, 0.00268485, 0.00272314, 0.00276116,
  0.00279891, 0.00283638, 0.00287358, 0.00291049, 0.00294712,
  0.00298345, 0.0030195, 0.00305524, 0.00309069, 0.00312583,
  0.00316067, 0.00319519, 0.0032294, 0.00326329, 0.00329686,
  0.00333011, 0.00336303, 0.00339562, 0.00342787, 0.00345979,
  0.00349136, 0.0035226, 0.00355348, 0.00358402, 0.0036142,
  0.00364403, 0.00367349, 0.0037026, 0.00373134, 0.00375971,
  0.00378772, 0.00381535, 0.0038426, 0.00386948, 0.00389597,
  0.00392208, 0.00394781, 0.00397314, 0.00399808, 0.00402263,
  0.00404678, 0.00407054, 0.00409389, 0.00411684, 0.00413938,
  0.00416151, 0.00418323, 0.00420454, 0.00422544, 0.00424592,
  0.00426597, 0.00428561, 0.00430483, 0.00432362, 0.00434198,
  0.00435992, 0.00437742, 0.00439449, 0.00441113, 0.00442733,
  0.00444309, 0.00445842, 0.0044733, 0.00448775, 0.00450175,
  0.0045153, 0.00452841, 0.00454107, 0.00455328, 0.00456504,
  0.00457635, 0.00458721, 0.00459762, 0.00460756, 0.00461706,
  0.00462609, 0.00463467, 0.00464279, 0.00465045, 0.00465766,
  0.0046644, 0.00467067, 0.00467649, 0.00468184, 0.00468673,
  0.00469116, 0.00469512, 0.00469861, 0.00470164, 0.00470421,
  0.0047063, 0.00470794, 0.0047091, 0.0047098, 0.00471003, 0.0047098,
  0.0047091, 0.00470793, 0.00470629, 0.00470419, 0.00470162,
  0.00469859, 0.00469508, 0.00469112, 0.00468668, 0.00468179,
  0.00467643, 0.0046706, 0.00466431, 0.00465756, 0.00465034,
  0.00464266, 0.00463453, 0.00462593, 0.00461687, 0.00460736,
  0.00459738, 0.00458695, 0.00457606, 0.00456472, 0.00455293,
  0.00454068, 0.00452798, 0.00451483, 0.00450124, 0.00448719,
  0.0044727, 0.00445776, 0.00444238, 0.00442656, 0.0044103, 0.0043936,
  0.00437646, 0.00435889, 0.00434088, 0.00432244, 0.00430357,
  0.00428427, 0.00426455, 0.0042444, 0.00422383, 0.00420283,
  0.00418142, 0.00415959, 0.00413735, 0.00411469, 0.00409163,
  0.00406816, 0.00404428, 0.00401999, 0.00399531, 0.00397023,
  0.00394475, 0.00391888, 0.00389262, 0.00386597, 0.00383893,
  0.00381152, 0.00378372, 0.00375554, 0.00372699, 0.00369806,
  0.00366877, 0.00363911, 0.00360909, 0.0035787, 0.00354796,
  0.00351687, 0.00348542, 0.00345362, 0.00342148, 0.003389,
  0.00335618, 0.00332302, 0.00328953, 0.00325572, 0.00322157,
  0.00318711, 0.00315232, 0.00311722, 0.00308181, 0.00304609,
  0.00301006, 0.00297374, 0.00293711, 0.00290019, 0.00286298,
  0.00282549, 0.00278771, 0.00274965, 0.00271132, 0.00267271,
  0.00263384, 0.0025947, 0.00255531, 0.00251565, 0.00247575,
  0.00243559, 0.0023952, 0.00235456, 0.00231368, 0.00227258,
  0.00223124, 0.00218968, 0.00214791, 0.00210591, 0.00206371,
  0.00202129, 0.00197868, 0.00193586, 0.00189285, 0.00184966,
  0.00180627, 0.00176271, 0.00171896, 0.00167505, 0.00163096,
  0.00158671, 0.00154231, 0.00149774, 0.00145303, 0.00140817,
  0.00136317, 0.00131803, 0.00127276, 0.00122736, 0.00118184,
  0.00113619, 0.00109044, 0.00104457, 0.0009986, 0.000952528,
  0.00090636, 0.000860101, 0.000813756, 0.000767328, 0.000720823,
  0.000674245, 0.000627599, 0.00058089, 0.000534122, 0.000487301,
  0.00044043, 0.000393515, 0.00034656, 0.00029957, 0.00025255,
  0.000205505, 0.000158438, 0.000111356, 6.42624e-05, 1.71623e-05,
  -2.99395e-05, -7.70383e-05, -0.000124129, -0.000171208,
  -0.000218269, -0.000265308, -0.000312321, -0.000359302,
  -0.000406246, -0.00045315, -0.000500007, -0.000546814, -0.000593566,
  -0.000640258, -0.000686885, -0.000733442, -0.000779925,
  -0.000826329, -0.00087265, -0.000918882, -0.000965021, -0.00101106,
  -0.001057, -0.00110283, -0.00114855, -0.00119416, -0.00123964,
  -0.001285, -0.00133022, -0.00137532, -0.00142027, -0.00146508,
  -0.00150974, -0.00155424, -0.00159859, -0.00164278, -0.0016868,
  -0.00173065, -0.00177432, -0.00181781, -0.00186112, -0.00190424,
  -0.00194717, -0.00198989, -0.00203242, -0.00207474, -0.00211685,
  -0.00215874, -0.00220041, -0.00224186, -0.00228308, -0.00232407,
  -0.00236482, -0.00240534, -0.0024456, -0.00248562, -0.00252539,
  -0.00256489, -0.00260414, -0.00264312, -0.00268183, -0.00272027,
  -0.00275844, -0.00279632, -0.00283391, -0.00287122, -0.00290823,
  -0.00294495, -0.00298137, -0.00301748, -0.00305328, -0.00308878,
  -0.00312395, -0.00315881, -0.00319335, -0.00322756, -0.00326144,
  -0.00329499, -0.0033282, -0.00336107, -0.0033936, -0.00342578,
  -0.00345761, -0.00348909, -0.00352021, -0.00355097, -0.00358137,
  -0.0036114, -0.00364106, -0.00367035, -0.00369926, -0.00372779,
  -0.00375595, -0.00378371, -0.00381109, -0.00383808, -0.00386468,
  -0.00389088, -0.00391668, -0.00394209, -0.00396708, -0.00399167,
  -0.00401585, -0.00403962, -0.00406297, -0.00408591, -0.00410843,
  -0.00413053, -0.0041522, -0.00417344, -0.00419426, -0.00421465,
  -0.0042346, -0.00425412, -0.0042732, -0.00429184, -0.00431004,
  -0.0043278, -0.00434512, -0.00436198, -0.0043784, -0.00439437,
  -0.00440988, -0.00442494, -0.00443955, -0.0044537, -0.00446739,
  -0.00448062, -0.00449339, -0.00450569, -0.00451754, -0.00452891,
  -0.00453982, -0.00455026, -0.00456023, -0.00456974, -0.00457877,
  -0.00458733, -0.00459541, -0.00460302, -0.00461016, -0.00461682,
  -0.004623, -0.00462871, -0.00463394, -0.00463869, -0.00464296,
  -0.00464675, -0.00465006, -0.00465289, -0.00465523, -0.0046571,
  -0.00465849, -0.00465939, -0.00465981, -0.00465975, -0.00465921,
  -0.00465818, -0.00465668, -0.00465469, -0.00465222, -0.00464926,
  -0.00464583, -0.00464191, -0.00463751, -0.00463263, -0.00462728,
  -0.00462144, -0.00461512, -0.00460832, -0.00460105, -0.0045933,
  -0.00458507, -0.00457636, -0.00456718, -0.00455753, -0.0045474,
  -0.0045368, -0.00452573, -0.00451419, -0.00450218, -0.0044897,
  -0.00447675, -0.00446334, -0.00444947, -0.00443513, -0.00442033,
  -0.00440507, -0.00438935, -0.00437318, -0.00435655, -0.00433946,
  -0.00432193, -0.00430394, -0.0042855, -0.00426662, -0.0042473,
  -0.00422753, -0.00420732, -0.00418667, -0.00416558, -0.00414406,
  -0.00412211, -0.00409973, -0.00407691, -0.00405368, -0.00403002,
  -0.00400594, -0.00398144, -0.00395652, -0.00393119, -0.00390545,
  -0.0038793, -0.00385275, -0.00382579, -0.00379843, -0.00377068,
  -0.00374253, -0.00371399, -0.00368506, -0.00365574, -0.00362604,
  -0.00359596, -0.00356551, -0.00353468, -0.00350348, -0.00347191,
  -0.00343998, -0.00340769, -0.00337504, -0.00334204, -0.00330868,
  -0.00327498, -0.00324093, -0.00320655, -0.00317183, -0.00313677,
  -0.00310139, -0.00306567, -0.00302964, -0.00299329, -0.00295662,
  -0.00291965, -0.00288236, -0.00284477, -0.00280689, -0.0027687,
  -0.00273023, -0.00269147, -0.00265242, -0.0026131, -0.0025735,
  -0.00253363, -0.00249349, -0.00245309, -0.00241243, -0.00237152,
  -0.00233035, -0.00228894, -0.00224729, -0.0022054, -0.00216328,
  -0.00212093, -0.00207836, -0.00203557, -0.00199256, -0.00194934,
  -0.00190591, -0.00186229, -0.00181846, -0.00177445, -0.00173024,
  -0.00168586, -0.00164129, -0.00159655, -0.00155165, -0.00150658,
  -0.00146134, -0.00141596, -0.00137042, -0.00132474, -0.00127892,
  -0.00123296, -0.00118687, -0.00114066, -0.00109432, -0.00104787,
  -0.00100131, -0.00095464, -0.00090787, -0.000861004, -0.000814046,
  -0.000767001, -0.000719875, -0.000672673, -0.000625399,
  -0.000578058, -0.000530656, -0.000483198, -0.000435688,
  -0.000388132, -0.000340534, -0.000292901, -0.000245236,
  -0.000197545, -0.000149833, -0.000102105, -5.43659e-05,
  -6.62121e-06, 4.11241e-05, 8.88651e-05, 0.000136597, 0.000184313,
  0.000232011, 0.000279683, 0.000327325, 0.000374933, 0.000422501,
  0.000470023, 0.000517495, 0.000564912, 0.000612268, 0.000659559,
  0.000706779, 0.000753924, 0.000800988, 0.000847966, 0.000894853,
  0.000941645, 0.000988335, 0.00103492, 0.00108139, 0.00112775,
  0.00117399, 0.0012201, 0.00126608, 0.00131192, 0.00135763,
  0.00140319, 0.00144859, 0.00149385, 0.00153894, 0.00158386,
  0.00162862, 0.0016732, 0.0017176, 0.00176182, 0.00180584,
  0.00184968, 0.00189331, 0.00193674, 0.00197996, 0.00202297,
  0.00206576, 0.00210833, 0.00215067, 0.00219277, 0.00223465,
  0.00227628, 0.00231766, 0.0023588, 0.00239968, 0.0024403,
  0.00248066, 0.00252075, 0.00256057, 0.00260011, 0.00263938,
  0.00267835, 0.00271704, 0.00275543, 0.00279353, 0.00283132,
  0.00286881, 0.00290598, 0.00294284, 0.00297939, 0.00301561,
  0.0030515, 0.00308706, 0.00312229, 0.00315718, 0.00319173,
  0.00322593, 0.00325978, 0.00329328, 0.00332642, 0.0033592,
  0.00339161, 0.00342366, 0.00345533, 0.00348663, 0.00351755,
  0.00354809, 0.00357824, 0.003608, 0.00363737, 0.00366635,
  0.00369492, 0.00372309, 0.00375086, 0.00377822, 0.00380517,
  0.0038317, 0.00385782, 0.00388351, 0.00390878, 0.00393363,
  0.00395804, 0.00398203, 0.00400557, 0.00402869, 0.00405136,
  0.00407359, 0.00409537, 0.00411671, 0.00413759, 0.00415803,
  0.00417801, 0.00419753, 0.00421659, 0.00423519, 0.00425333,
  0.004271, 0.0042882, 0.00430494, 0.0043212, 0.00433699, 0.0043523,
  0.00436714, 0.00438149, 0.00439537, 0.00440876, 0.00442167,
  0.0044341, 0.00444603, 0.00445748, 0.00446844, 0.00447891,
  0.00448888, 0.00449837, 0.00450735, 0.00451584, 0.00452384,
  0.00453133, 0.00453833, 0.00454483, 0.00455082, 0.00455632,
  0.00456131, 0.0045658, 0.00456978, 0.00457326, 0.00457624,
  0.00457871, 0.00458068, 0.00458214, 0.0045831, 0.00458354,
  0.00458348, 0.00458292, 0.00458185, 0.00458027, 0.00457818,
  0.00457559, 0.00457249, 0.00456889, 0.00456478, 0.00456016,
  0.00455504, 0.00454941, 0.00454328, 0.00453665, 0.00452951,
  0.00452187, 0.00451373, 0.00450508, 0.00449594, 0.0044863,
  0.00447616, 0.00446552, 0.00445438, 0.00444275, 0.00443063,
  0.00441801, 0.0044049, 0.0043913, 0.00437722, 0.00436264,
  0.00434758, 0.00433203, 0.004316, 0.00429949, 0.0042825, 0.00426504,
  0.00424709, 0.00422868, 0.00420979, 0.00419043, 0.0041706,
  0.00415031, 0.00412955, 0.00410833, 0.00408666, 0.00406452,
  0.00404193, 0.00401889, 0.0039954, 0.00397146, 0.00394707,
  0.00392225, 0.00389698, 0.00387128, 0.00384514, 0.00381857,
  0.00379158, 0.00376415, 0.00373631, 0.00370805, 0.00367936,
  0.00365027, 0.00362077, 0.00359086, 0.00356054, 0.00352983,
  0.00349871, 0.00346721, 0.00343531, 0.00340303, 0.00337036,
  0.00333731, 0.00330389, 0.0032701, 0.00323593, 0.00320141,
  0.00316652, 0.00313127, 0.00309567, 0.00305972, 0.00302342,
  0.00298679, 0.00294981, 0.0029125, 0.00287486, 0.0028369,
  0.00279862, 0.00276002, 0.00272111, 0.00268188, 0.00264236,
  0.00260254, 0.00256242, 0.00252201, 0.00248131, 0.00244033,
  0.00239908, 0.00235755, 0.00231576, 0.0022737, 0.00223139,
  0.00218882, 0.002146, 0.00210294, 0.00205964, 0.0020161, 0.00197234,
  0.00192835, 0.00188414, 0.00183972, 0.00179508, 0.00175025,
  0.00170521, 0.00165998, 0.00161456, 0.00156895, 0.00152317,
  0.00147721, 0.00143108, 0.00138479, 0.00133834, 0.00129174,
  0.00124499, 0.0011981, 0.00115107, 0.00110391, 0.00105662,
  0.00100921, 0.000961691, 0.000914058, 0.000866319, 0.000818481,
  0.000770549, 0.000722529, 0.000674426, 0.000626246, 0.000577993,
  0.000529674, 0.000481295, 0.00043286, 0.000384375, 0.000335846,
  0.000287278, 0.000238677, 0.000190049, 0.000141399, 9.27325e-05,
  4.40554e-05, -4.62681e-06, -5.33085e-05, -0.000101984, -0.000150648,
  -0.000199294, -0.000247918, -0.000296513, -0.000345073,
  -0.000393594, -0.000442069, -0.000490494, -0.000538861,
  -0.000587166, -0.000635403, -0.000683567, -0.000731652,
  -0.000779652, -0.000827561, -0.000875375, -0.000923087,
  -0.000970692, -0.00101819, -0.00106556, -0.00111281, -0.00115993,
  -0.00120692, -0.00125377, -0.00130047, -0.00134702, -0.00139341,
  -0.00143964, -0.0014857, -0.0015316, -0.00157731, -0.00162284,
  -0.00166818, -0.00171332, -0.00175827, -0.00180301, -0.00184754,
  -0.00189185, -0.00193595, -0.00197981, -0.00202345, -0.00206685,
  -0.00211001, -0.00215292, -0.00219558, -0.00223798, -0.00228012,
  -0.002322, -0.0023636, -0.00240492, -0.00244597, -0.00248672,
  -0.00252719, -0.00256736, -0.00260723, -0.00264679, -0.00268604,
  -0.00272497, -0.00276359, -0.00280188, -0.00283984, -0.00287747,
  -0.00291475, -0.0029517, -0.0029883, -0.00302454, -0.00306043,
  -0.00309596, -0.00313112, -0.00316592, -0.00320034, -0.00323438,
  -0.00326804, -0.00330132, -0.00333421, -0.0033667, -0.00339879,
  -0.00343048, -0.00346177, -0.00349265, -0.00352311, -0.00355316,
  -0.00358278, -0.00361198, -0.00364076, -0.0036691, -0.003697,
  -0.00372447, -0.00375149, -0.00377807, -0.00380421, -0.00382988,
  -0.00385511, -0.00387987, -0.00390418, -0.00392802, -0.00395139,
  -0.00397429, -0.00399672, -0.00401867, -0.00404015, -0.00406114,
  -0.00408165, -0.00410167, -0.0041212, -0.00414024, -0.00415878,
  -0.00417683, -0.00419438, -0.00421143, -0.00422797, -0.00424401,
  -0.00425954, -0.00427456, -0.00428907, -0.00430307, -0.00431655,
  -0.00432951, -0.00434195, -0.00435387, -0.00436527, -0.00437615,
  -0.0043865, -0.00439632, -0.00440561, -0.00441438, -0.00442261,
  -0.00443031, -0.00443748, -0.00444412, -0.00445022, -0.00445578,
  -0.0044608, -0.00446529, -0.00446924, -0.00447265, -0.00447552,
  -0.00447786, -0.00447964, -0.00448089, -0.0044816, -0.00448177,
  -0.00448139, -0.00448047, -0.00447901, -0.004477, -0.00447446,
  -0.00447137, -0.00446774, -0.00446357, -0.00445885, -0.0044536,
  -0.00444781, -0.00444147, -0.0044346, -0.00442718, -0.00441923,
  -0.00441074, -0.00440172, -0.00439215, -0.00438206, -0.00437143,
  -0.00436027, -0.00434857, -0.00433635, -0.0043236, -0.00431032,
  -0.00429651, -0.00428218, -0.00426732, -0.00425195, -0.00423605,
  -0.00421964, -0.00420271, -0.00418527, -0.00416731, -0.00414884,
  -0.00412987, -0.00411039, -0.0040904, -0.00406992, -0.00404893,
  -0.00402745, -0.00400547, -0.003983, -0.00396004, -0.0039366,
  -0.00391267, -0.00388826, -0.00386337, -0.003838, -0.00381216,
  -0.00378586, -0.00375908, -0.00373184, -0.00370415, -0.00367599,
  -0.00364738, -0.00361832, -0.00358882, -0.00355887, -0.00352848,
  -0.00349765, -0.00346639, -0.0034347, -0.00340259, -0.00337005,
  -0.0033371, -0.00330374, -0.00326996, -0.00323578, -0.0032012,
  -0.00316621, -0.00313084, -0.00309508, -0.00305893, -0.0030224,
  -0.0029855, -0.00294822, -0.00291058, -0.00287258, -0.00283421,
  -0.0027955, -0.00275643, -0.00271702, -0.00267728, -0.00263719,
  -0.00259678, -0.00255605, -0.00251499, -0.00247362, -0.00243194,
  -0.00238996, -0.00234768, -0.0023051, -0.00226223, -0.00221909,
  -0.00217566, -0.00213196, -0.00208799, -0.00204376, -0.00199927,
  -0.00195454, -0.00190955, -0.00186433, -0.00181887, -0.00177319,
  -0.00172728, -0.00168115, -0.00163481, -0.00158826, -0.00154152,
  -0.00149458, -0.00144745, -0.00140014, -0.00135265, -0.00130499,
  -0.00125717, -0.00120918, -0.00116105, -0.00111276, -0.00106434,
  -0.00101578, -0.000967094, -0.000918284, -0.000869358, -0.000820321,
  -0.000771181, -0.000721942, -0.000672612, -0.000623196,
  -0.000573701, -0.000524133, -0.000474498, -0.000424803,
  -0.000375054, -0.000325257, -0.000275419, -0.000225546,
  -0.000175643, -0.000125719, -7.57783e-05, -2.58281e-05, 2.41255e-05,
  7.40759e-05, 0.000124017, 0.000173942, 0.000223845, 0.000273719,
  0.000323558, 0.000373355, 0.000423105, 0.000472801, 0.000522435,
  0.000572003, 0.000621497, 0.000670911, 0.000720239, 0.000769475,
  0.000818611, 0.000867642, 0.000916561, 0.000965363, 0.00101404,
  0.00106259, 0.00111099, 0.00115926, 0.00120738, 0.00125534,
  0.00130313, 0.00135076, 0.00139822, 0.00144549, 0.00149258,
  0.00153947, 0.00158617, 0.00163265, 0.00167893, 0.00172499,
  0.00177082, 0.00181643, 0.0018618, 0.00190693, 0.00195181,
  0.00199643, 0.0020408, 0.0020849, 0.00212873, 0.00217228,
  0.00221555, 0.00225853, 0.00230121, 0.00234359, 0.00238567,
  0.00242744, 0.00246889, 0.00251002, 0.00255081, 0.00259128,
  0.0026314, 0.00267119, 0.00271062, 0.00274969, 0.00278841,
  0.00282676, 0.00286473, 0.00290234, 0.00293956, 0.00297639,
  0.00301283, 0.00304888, 0.00308452, 0.00311976, 0.00315459,
  0.003189, 0.00322299, 0.00325656, 0.0032897, 0.0033224, 0.00335466,
  0.00338648, 0.00341785, 0.00344877, 0.00347924, 0.00350924,
  0.00353878, 0.00356785, 0.00359644, 0.00362456, 0.0036522,
  0.00367935, 0.00370602, 0.00373219, 0.00375787, 0.00378304,
  0.00380772, 0.00383188, 0.00385554, 0.00387868, 0.0039013,
  0.00392341, 0.00394499, 0.00396604, 0.00398656, 0.00400656,
  0.00402601, 0.00404493, 0.0040633, 0.00408114, 0.00409842,
  0.00411516, 0.00413134, 0.00414697, 0.00416205, 0.00417656,
  0.00419051, 0.0042039, 0.00421673, 0.00422899, 0.00424068,
  0.0042518, 0.00426234, 0.00427231, 0.00428171, 0.00429052,
  0.00429876, 0.00430642, 0.0043135, 0.00431999, 0.0043259,
  0.00433122, 0.00433596, 0.00434011, 0.00434367, 0.00434664,
  0.00434903, 0.00435082, 0.00435202, 0.00435264, 0.00435266,
  0.00435209, 0.00435092, 0.00434917, 0.00434682, 0.00434388,
  0.00434035, 0.00433623, 0.00433151, 0.00432621, 0.00432031,
  0.00431382, 0.00430675, 0.00429908, 0.00429083, 0.00428199,
  0.00427256, 0.00426255, 0.00425195, 0.00424077, 0.00422901,
  0.00421667, 0.00420374, 0.00419025, 0.00417617, 0.00416152,
  0.0041463, 0.0041305, 0.00411414, 0.00409721, 0.00407972,
  0.00406166, 0.00404304, 0.00402386, 0.00400413, 0.00398384,
  0.003963, 0.00394162, 0.00391969, 0.00389721, 0.0038742, 0.00385064,
  0.00382656, 0.00380194, 0.00377679, 0.00375112, 0.00372493,
  0.00369822, 0.003671, 0.00364326, 0.00361502, 0.00358627,
  0.00355702, 0.00352728, 0.00349704, 0.00346631, 0.0034351,
  0.00340342, 0.00337125, 0.00333861, 0.00330551, 0.00327194,
  0.00323791, 0.00320343, 0.0031685, 0.00313312, 0.00309731,
  0.00306106, 0.00302438, 0.00298727, 0.00294974, 0.0029118,
  0.00287345, 0.00283469, 0.00279553, 0.00275598, 0.00271603,
  0.00267571, 0.002635, 0.00259393, 0.00255248, 0.00251068,
  0.00246852, 0.00242601, 0.00238315, 0.00233996, 0.00229643,
  0.00225258, 0.00220841, 0.00216393, 0.00211913, 0.00207404,
  0.00202865, 0.00198297, 0.001937, 0.00189077, 0.00184426,
  0.00179749, 0.00175046, 0.00170318, 0.00165566, 0.0016079,
  0.00155991, 0.00151169, 0.00146326, 0.00141462, 0.00136578,
  0.00131674, 0.00126751, 0.0012181, 0.00116852, 0.00111876,
  0.00106885, 0.00101878, 0.000968563, 0.000918207, 0.000867719,
  0.000817106, 0.000766375, 0.000715533, 0.000664587, 0.000613545,
  0.000562415, 0.000511203, 0.000459916, 0.000408564, 0.000357151,
  0.000305687, 0.000254179, 0.000202633, 0.000151058, 9.94614e-05,
  4.785e-05, -3.76841e-06, -5.53863e-05, -0.000106996, -0.00015859,
  -0.000210161, -0.000261702, -0.000313204, -0.00036466, -0.000416063,
  -0.000467406, -0.000518679, -0.000569877, -0.000620991,
  -0.000672014, -0.000722939, -0.000773757, -0.000824461,
  -0.000875044, -0.000925499, -0.000975817, -0.00102599, -0.00107601,
  -0.00112588, -0.00117558, -0.0012251, -0.00127445, -0.0013236,
  -0.00137256, -0.00142132, -0.00146986, -0.00151819, -0.00156629,
  -0.00161417, -0.0016618, -0.00170918, -0.00175631, -0.00180318,
  -0.00184978, -0.00189611, -0.00194215, -0.0019879, -0.00203336,
  -0.00207851, -0.00212336, -0.00216788, -0.00221209, -0.00225596,
  -0.00229949, -0.00234268, -0.00238552, -0.002428, -0.00247011,
  -0.00251186, -0.00255323, -0.00259421, -0.00263481, -0.002675,
  -0.0027148, -0.00275418, -0.00279316, -0.0028317, -0.00286983,
  -0.00290752, -0.00294476, -0.00298157, -0.00301792, -0.00305382,
  -0.00308925, -0.00312422, -0.00315871, -0.00319272, -0.00322625,
  -0.00325928, -0.00329183, -0.00332387, -0.0033554, -0.00338643,
  -0.00341693, -0.00344692, -0.00347638, -0.00350531, -0.00353371,
  -0.00356156, -0.00358887, -0.00361563, -0.00364183, -0.00366748,
  -0.00369257, -0.00371709, -0.00374104, -0.00376441, -0.0037872,
  -0.00380942, -0.00383104, -0.00385208, -0.00387252, -0.00389237,
  -0.00391161, -0.00393025, -0.00394828, -0.00396571, -0.00398252,
  -0.00399871, -0.00401428, -0.00402923, -0.00404356, -0.00405726,
  -0.00407033, -0.00408276, -0.00409457, -0.00410573, -0.00411625,
  -0.00412614, -0.00413538, -0.00414398, -0.00415192, -0.00415922,
  -0.00416588, -0.00417187, -0.00417722, -0.00418191, -0.00418595,
  -0.00418933, -0.00419205, -0.00419412, -0.00419552, -0.00419627,
  -0.00419636, -0.00419578, -0.00419455, -0.00419265, -0.0041901,
  -0.00418688, -0.004183, -0.00417846, -0.00417326, -0.00416739,
  -0.00416087, -0.00415369, -0.00414585, -0.00413736, -0.0041282,
  -0.00411839, -0.00410793, -0.00409681, -0.00408504, -0.00407262,
  -0.00405955, -0.00404584, -0.00403147, -0.00401647, -0.00400082,
  -0.00398453, -0.00396761, -0.00395004, -0.00393185, -0.00391303,
  -0.00389357, -0.0038735, -0.0038528, -0.00383148, -0.00380954,
  -0.00378699, -0.00376383, -0.00374007, -0.0037157, -0.00369073,
  -0.00366516, -0.00363901, -0.00361226, -0.00358493, -0.00355702,
  -0.00352853, -0.00349947, -0.00346984, -0.00343965, -0.0034089,
  -0.00337759, -0.00334573, -0.00331333, -0.00328039, -0.00324692,
  -0.00321291, -0.00317838, -0.00314333, -0.00310777, -0.00307169,
  -0.00303512, -0.00299804, -0.00296048, -0.00292243, -0.0028839,
  -0.00284489, -0.00280542, -0.00276548, -0.00272509, -0.00268425,
  -0.00264297, -0.00260125, -0.0025591, -0.00251653, -0.00247354,
  -0.00243015, -0.00238635, -0.00234215, -0.00229757, -0.00225261,
  -0.00220727, -0.00216156, -0.00211549, -0.00206908, -0.00202231,
  -0.00197521, -0.00192779, -0.00188003, -0.00183197, -0.0017836,
  -0.00173493, -0.00168597, -0.00163672, -0.00158721, -0.00153742,
  -0.00148738, -0.00143709, -0.00138656, -0.00133579, -0.0012848,
  -0.00123359, -0.00118217, -0.00113056, -0.00107875, -0.00102676,
  -0.000974598, -0.000922271, -0.000869787, -0.000817155,
  -0.000764385, -0.000711485, -0.000658464, -0.000605331,
  -0.000552096, -0.000498766, -0.000445351, -0.000391861,
  -0.000338303, -0.000284688, -0.000231024, -0.000177321,
  -0.000123587, -6.98318e-05, -1.6065e-05, 3.77046e-05, 9.14677e-05,
  0.000145215, 0.000198937, 0.000252626, 0.00030627, 0.000359862,
  0.000413392, 0.00046685, 0.000520227, 0.000573515, 0.000626703,
  0.000679783, 0.000732745, 0.00078558, 0.000838278, 0.000890831,
  0.000943229, 0.000995463, 0.00104752, 0.0010994, 0.00115109,
  0.00120257, 0.00125385, 0.0013049, 0.00135573, 0.00140632,
  0.00145667, 0.00150676, 0.00155658, 0.00160613, 0.0016554,
  0.00170438, 0.00175306, 0.00180142, 0.00184948, 0.0018972,
  0.00194459, 0.00199164, 0.00203833, 0.00208466, 0.00213063,
  0.00217621, 0.00222141, 0.00226622, 0.00231062, 0.00235461,
  0.00239819, 0.00244133, 0.00248404, 0.00252631, 0.00256812,
  0.00260948, 0.00265037, 0.00269079, 0.00273072, 0.00277017,
  0.00280911, 0.00284756, 0.00288549, 0.0029229, 0.00295978,
  0.00299614, 0.00303195, 0.00306721, 0.00310193, 0.00313608,
  0.00316966, 0.00320267, 0.0032351, 0.00326694, 0.00329819,
  0.00332884, 0.00335889, 0.00338832, 0.00341714, 0.00344533,
  0.0034729, 0.00349983, 0.00352612, 0.00355177, 0.00357676,
  0.00360111, 0.00362479, 0.00364781, 0.00367015, 0.00369183,
  0.00371282, 0.00373313, 0.00375275, 0.00377168, 0.00378992,
  0.00380745, 0.00382428, 0.0038404, 0.00385581, 0.00387051,
  0.00388449, 0.00389774, 0.00391028, 0.00392208, 0.00393316,
  0.0039435, 0.00395311, 0.00396198, 0.00397011, 0.0039775,
  0.00398414, 0.00399004, 0.00399518, 0.00399958, 0.00400323,
  0.00400613, 0.00400827, 0.00400966, 0.00401029, 0.00401017,
  0.00400929, 0.00400765, 0.00400525, 0.0040021, 0.00399819,
  0.00399352, 0.00398809, 0.00398191, 0.00397496, 0.00396726,
  0.00395881, 0.0039496, 0.00393964, 0.00392893, 0.00391746,
  0.00390525, 0.00389228, 0.00387858, 0.00386412, 0.00384893,
  0.003833, 0.00381633, 0.00379892, 0.00378079, 0.00376192,
  0.00374233, 0.00372201, 0.00370098, 0.00367923, 0.00365676,
  0.00363359, 0.00360971, 0.00358513, 0.00355986, 0.00353389,
  0.00350723, 0.00347989, 0.00345187, 0.00342317, 0.00339381,
  0.00336378, 0.00333309, 0.00330175, 0.00326976, 0.00323713,
  0.00320386, 0.00316997, 0.00313544, 0.0031003, 0.00306455,
  0.00302819, 0.00299124, 0.00295369, 0.00291556, 0.00287685,
  0.00283756, 0.00279772, 0.00275731, 0.00271636, 0.00267487,
  0.00263285, 0.00259029, 0.00254723, 0.00250365, 0.00245957,
  0.002415, 0.00236994, 0.00232441, 0.00227841, 0.00223195,
  0.00218504, 0.00213769, 0.00208992, 0.00204172, 0.0019931,
  0.00194408, 0.00189467, 0.00184488, 0.00179471, 0.00174418,
  0.00169329, 0.00164206, 0.00159049, 0.0015386, 0.00148639,
  0.00143388, 0.00138108, 0.001328, 0.00127464, 0.00122102,
  0.00116715, 0.00111304, 0.0010587, 0.00100415, 0.000949384,
  0.000894425, 0.00083928, 0.000783963, 0.000728483, 0.000672852,
  0.000617081, 0.000561183, 0.000505168, 0.000449047, 0.000392833,
  0.000336538, 0.000280171, 0.000223747, 0.000167275, 0.000110769,
  5.42394e-05, -2.30163e-06, -5.88422e-05, -0.00011537, -0.000171874,
  -0.000228342, -0.000284762, -0.000341122, -0.000397409,
  -0.000453613, -0.000509721, -0.00056572, -0.0006216, -0.000677348,
  -0.000732951, -0.000788399, -0.000843679, -0.000898779,
  -0.000953687, -0.00100839, -0.00106288, -0.00111714, -0.00117116,
  -0.00122493, -0.00127844, -0.00133167, -0.00138462, -0.00143727,
  -0.0014896, -0.00154162, -0.0015933, -0.00164464, -0.00169562,
  -0.00174623, -0.00179647, -0.00184631, -0.00189575, -0.00194478,
  -0.00199339, -0.00204156, -0.00208928, -0.00213655, -0.00218335,
  -0.00222967, -0.0022755, -0.00232083, -0.00236565, -0.00240995,
  -0.00245372, -0.00249695, -0.00253962, -0.00258173, -0.00262328,
  -0.00266424, -0.00270461, -0.00274437, -0.00278353, -0.00282207,
  -0.00285998, -0.00289725, -0.00293387, -0.00296984, -0.00300514,
  -0.00303977, -0.00307371, -0.00310697, -0.00313953, -0.00317138,
  -0.00320251, -0.00323292, -0.0032626, -0.00329155, -0.00331975,
  -0.00334719, -0.00337388, -0.0033998, -0.00342494, -0.00344931,
  -0.00347289, -0.00349567, -0.00351766, -0.00353884, -0.00355921,
  -0.00357877, -0.0035975, -0.0036154, -0.00363248, -0.00364872,
  -0.00366411, -0.00367866, -0.00369236, -0.0037052, -0.00371719,
  -0.00372831, -0.00373856, -0.00374795, -0.00375646, -0.0037641,
  -0.00377086, -0.00377673, -0.00378173, -0.00378584, -0.00378905,
  -0.00379138, -0.00379282, -0.00379337, -0.00379302, -0.00379178,
  -0.00378964, -0.0037866, -0.00378267, -0.00377784, -0.00377211,
  -0.00376549, -0.00375797, -0.00374955, -0.00374024, -0.00373004,
  -0.00371894, -0.00370696, -0.00369408, -0.00368032, -0.00366568,
  -0.00365015, -0.00363374, -0.00361646, -0.0035983, -0.00357927,
  -0.00355938, -0.00353862, -0.003517, -0.00349453, -0.00347121,
  -0.00344704, -0.00342203, -0.00339619, -0.00336951, -0.00334201,
  -0.00331369, -0.00328456, -0.00325462, -0.00322387, -0.00319234,
  -0.00316001, -0.00312691, -0.00309303, -0.00305838, -0.00302298,
  -0.00298682, -0.00294992, -0.00291229, -0.00287393, -0.00283485,
  -0.00279507, -0.00275458, -0.00271341, -0.00267155, -0.00262903,
  -0.00258584, -0.00254199, -0.00249751, -0.0024524, -0.00240667,
  -0.00236032, -0.00231338, -0.00226585, -0.00221774, -0.00216907,
  -0.00211985, -0.00207008, -0.00201979, -0.00196898, -0.00191766,
  -0.00186585, -0.00181356, -0.00176081, -0.0017076, -0.00165395,
  -0.00159987, -0.00154538, -0.00149049, -0.00143521, -0.00137956,
  -0.00132355, -0.00126719, -0.00121051, -0.0011535, -0.0010962,
  -0.00103861, -0.000980741, -0.000922619, -0.000864254, -0.000805662,
  -0.000746856, -0.000687854, -0.000628669, -0.000569318,
  -0.000509816, -0.000450178, -0.000390421, -0.00033056, -0.00027061,
  -0.000210588, -0.00015051, -9.03914e-05, -3.02486e-05, 2.99023e-05,
  9.0045e-05, 0.000150164, 0.000210241, 0.000270262, 0.00033021,
  0.000390068, 0.000449821, 0.000509451, 0.000568942, 0.000628278,
  0.000687442, 0.000746418, 0.00080519, 0.000863741, 0.000922054,
  0.000980114, 0.0010379, 0.00109541, 0.00115261, 0.00120949,
  0.00126603, 0.00132223, 0.00137806, 0.0014335, 0.00148854,
  0.00154317, 0.00159737, 0.00165111, 0.0017044, 0.00175721,
  0.00180952, 0.00186132, 0.0019126, 0.00196333, 0.00201351,
  0.00206312, 0.00211214, 0.00216056, 0.00220837, 0.00225555,
  0.00230208, 0.00234795, 0.00239315, 0.00243766, 0.00248148,
  0.00252457, 0.00256694, 0.00260857, 0.00264944, 0.00268955,
  0.00272887, 0.0027674, 0.00280513, 0.00284204, 0.00287811,
  0.00291335, 0.00294773, 0.00298124, 0.00301388, 0.00304563,
  0.00307649, 0.00310643, 0.00313546, 0.00316355, 0.00319071,
  0.00321692, 0.00324217, 0.00326645, 0.00328976, 0.00331208,
  0.00333341, 0.00335374, 0.00337306, 0.00339137, 0.00340865,
  0.0034249, 0.00344011, 0.00345428, 0.0034674, 0.00347947,
  0.00349047, 0.00350041, 0.00350928, 0.00351708, 0.00352379,
  0.00352942, 0.00353397, 0.00353742, 0.00353979, 0.00354105,
  0.00354122, 0.00354029, 0.00353826, 0.00353513, 0.00353089,
  0.00352555, 0.0035191, 0.00351155, 0.00350289, 0.00349314,
  0.00348228, 0.00347032, 0.00345726, 0.00344311, 0.00342786,
  0.00341152, 0.00339409, 0.00337558, 0.00335599, 0.00333533,
  0.00331359, 0.00329079, 0.00326693, 0.00324201, 0.00321604,
  0.00318904, 0.00316099, 0.00313192, 0.00310183, 0.00307073,
  0.00303863, 0.00300552, 0.00297144, 0.00293637, 0.00290034,
  0.00286335, 0.00282542, 0.00278655, 0.00274675, 0.00270605,
  0.00266444, 0.00262194, 0.00257856, 0.00253433, 0.00248924,
  0.00244331, 0.00239656, 0.00234901, 0.00230066, 0.00225153,
  0.00220163, 0.00215099, 0.00209961, 0.00204752, 0.00199473,
  0.00194125, 0.00188711, 0.00183232, 0.00177689, 0.00172086,
  0.00166422, 0.00160702, 0.00154925, 0.00149094, 0.00143211,
  0.00137279, 0.00131298, 0.00125271, 0.001192, 0.00113087,
  0.00106934, 0.00100744, 0.000945174, 0.000882575, 0.000819662,
  0.000756457, 0.000692982, 0.000629258, 0.000565309, 0.000501157,
  0.000436824, 0.000372333, 0.000307708, 0.000242971, 0.000178146,
  0.000113256, 4.83246e-05, -1.66244e-05, -8.15673e-05, -0.00014648,
  -0.00021134, -0.000276121, -0.000340801, -0.000405354, -0.000469757,
  -0.000533986, -0.000598016, -0.000661822, -0.000725381,
  -0.000788669, -0.00085166, -0.00091433, -0.000976656, -0.00103861,
  -0.00110018, -0.00116132, -0.00122202, -0.00128226, -0.00134201,
  -0.00140124, -0.00145994, -0.00151807, -0.00157562, -0.00163256,
  -0.00168886, -0.00174451, -0.00179949, -0.00185376, -0.0019073,
  -0.0019601, -0.00201213, -0.00206337, -0.00211379, -0.00216338,
  -0.00221211, -0.00225996, -0.00230692, -0.00235295, -0.00239804,
  -0.00244217, -0.00248532, -0.00252747, -0.0025686, -0.00260869,
  -0.00264772, -0.00268567, -0.00272253, -0.00275828, -0.0027929,
  -0.00282637, -0.00285868, -0.00288981, -0.00291975, -0.00294848,
  -0.00297598, -0.00300224, -0.00302725, -0.00305099, -0.00307346,
  -0.00309463, -0.00311449, -0.00313304, -0.00315027, -0.00316615,
  -0.00318069, -0.00319387, -0.00320568, -0.00321612, -0.00322518,
  -0.00323284, -0.00323911, -0.00324398, -0.00324743, -0.00324947,
  -0.00325009, -0.00324929, -0.00324707, -0.00324341, -0.00323832,
  -0.00323181, -0.00322385, -0.00321447, -0.00320365, -0.0031914,
  -0.00317772, -0.00316261, -0.00314608, -0.00312812, -0.00310875,
  -0.00308797, -0.00306578, -0.00304219, -0.0030172, -0.00299084,
  -0.00296309, -0.00293398, -0.00290351, -0.00287169, -0.00283853,
  -0.00280405, -0.00276826, -0.00273117, -0.00269279, -0.00265315,
  -0.00261224, -0.0025701, -0.00252673, -0.00248216, -0.0024364,
  -0.00238947, -0.00234139, -0.00229218, -0.00224185, -0.00219044,
  -0.00213797, -0.00208445, -0.0020299, -0.00197436, -0.00191785,
  -0.00186039, -0.00180201, -0.00174273, -0.00168259, -0.0016216,
  -0.0015598, -0.00149721, -0.00143387, -0.0013698, -0.00130504,
  -0.00123961, -0.00117355, -0.00110688, -0.00103965, -0.000971885,
  -0.000903615, -0.000834877, -0.000765703, -0.000696131,
  -0.000626193, -0.000555927, -0.000485368, -0.000414552,
  -0.000343516, -0.000272298, -0.000200935, -0.000129464,
  -5.79231e-05, 1.36486e-05, 8.52128e-05, 0.000156731, 0.000228163,
  0.000299471, 0.000370615, 0.000441554, 0.00051225, 0.000582663,
  0.000652751, 0.000722476, 0.000791797, 0.000860674, 0.000929066,
  0.000996933, 0.00106423, 0.00113093, 0.00119698, 0.00126235,
  0.00132699, 0.00139086, 0.00145393, 0.00151615, 0.0015775,
  0.00163791, 0.00169737, 0.00175583, 0.00181324, 0.00186959,
  0.00192481, 0.00197889, 0.00203178, 0.00208345, 0.00213386,
  0.00218297, 0.00223075, 0.00227717, 0.0023222, 0.00236579,
  0.00240792, 0.00244856, 0.00248767, 0.00252522, 0.0025612,
  0.00259555, 0.00262827, 0.00265932, 0.00268867, 0.0027163,
  0.00274219, 0.00276631, 0.00278863, 0.00280915, 0.00282783,
  0.00284465, 0.00285961, 0.00287267, 0.00288383, 0.00289307,
  0.00290037, 0.00290573, 0.00290912, 0.00291054, 0.00290999,
  0.00290745, 0.00290291, 0.00289637, 0.00288783, 0.00287729,
  0.00286473, 0.00285017, 0.0028336, 0.00281503, 0.00279446,
  0.0027719, 0.00274735, 0.00272083, 0.00269234, 0.00266189,
  0.00262951, 0.0025952, 0.00255897, 0.00252086, 0.00248087,
  0.00243903, 0.00239537, 0.0023499, 0.00230265, 0.00225365,
  0.00220293, 0.00215052, 0.00209645, 0.00204075, 0.00198347,
  0.00192463, 0.00186428, 0.00180246, 0.0017392, 0.00167456,
  0.00160857, 0.00154129, 0.00147276, 0.00140302, 0.00133214,
  0.00126017, 0.00118715, 0.00111314, 0.00103821, 0.000962401,
  0.00088578, 0.000808408, 0.000730345, 0.000651655, 0.000572403,
  0.000492654, 0.000412476, 0.000331935, 0.000251102, 0.000170046,
  8.88386e-05, 7.55126e-06, -7.37429e-05, -0.00015497, -0.000236056,
  -0.000316926, -0.000397503, -0.000477711, -0.000557472,
  -0.000636711, -0.000715347, -0.000793304, -0.000870502,
  -0.000946862, -0.00102231, -0.00109675, -0.00117013, -0.00124234,
  -0.00131333, -0.001383, -0.00145129, -0.00151811, -0.00158338,
  -0.00164702, -0.00170897, -0.00176915, -0.00182748, -0.00188388,
  -0.00193829, -0.00199063, -0.00204083, -0.00208883, -0.00213456,
  -0.00217794, -0.00221892, -0.00225744, -0.00229343, -0.00232683,
  -0.00235759, -0.00238565, -0.00241096, -0.00243348, -0.00245314,
  -0.00246992, -0.00248377, -0.00249464, -0.0025025, -0.00250733,
  -0.00250908, -0.00250774, -0.00250328, -0.00249568, -0.00248492,
  -0.002471, -0.0024539, -0.00243362, -0.00241016, -0.00238353,
  -0.00235373, -0.00232078, -0.00228469, -0.00224548, -0.00220318,
  -0.00215783, -0.00210945, -0.00205809, -0.0020038, -0.00194662,
  -0.00188662, -0.00182385, -0.00175837, -0.00169027, -0.00161962,
  -0.0015465, -0.001471, -0.00139321, -0.00131323, -0.00123117,
  -0.00114714, -0.00106125, -0.000973619, -0.000884379, -0.000793661,
  -0.000701601, -0.000608342, -0.000514032, -0.000418824,
  -0.000322875, -0.00022635, -0.000129415, -3.22436e-05, 6.49868e-05,
  0.000162095, 0.000258894, 0.000355195, 0.000450804, 0.000545523,
  0.000639151, 0.000731485, 0.000822318, 0.00091144, 0.000998641,
  0.00108371, 0.00116643, 0.00124658, 0.00132395, 0.00139833,
  0.00146949, 0.00153722, 0.00160132, 0.00166156, 0.00171775,
  0.00176966, 0.00181711, 0.0018599, 0.00189783, 0.00193072,
  0.00195839, 0.00198067, 0.00199741, 0.00200844, 0.00201363,
  0.00201285, 0.00200598, 0.00199293, 0.00197359, 0.00194792,
  0.00191584, 0.00187733, 0.00183238, 0.001781, 0.00172321,
  0.00165907, 0.00158868, 0.00151214, 0.00142959, 0.00134122,
  0.00124723, 0.00114787, 0.00104341, 0.000934194, 0.000820577,
  0.000702972, 0.000581839, 0.000457686, 0.000331074, 0.000202618,
  7.29925e-05, -5.70683e-05, -0.000186766, -0.000315237, -0.000441546,
  -0.000564685, -0.000683569, -0.000797035, -0.000903834, -0.00100263,
  -0.00109199, -0.00117041, -0.00123624, -0.00128778, -0.00132318,
  -0.0013405, -0.00133767, -0.00131251, -0.0012627, -0.00118579,
  -0.0010792, -0.000940207, -0.000765927, -0.000553331, -0.000299226,
  -2.52014e-07};
