//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// neutron_hp -- source file
// J.P. Wellisch, Nov-1996
// A prototype of the low energy neutron transport model.
#include "G4NeutronHPFastLegendre.hh"

const G4double
  G4NeutronHPFastLegendre::l18[3801] = {1, 0.911993, 0.827896,
  0.747593, 0.670972, 0.597923, 0.528338, 0.462112, 0.399144,
  0.339331, 0.282575, 0.228782, 0.177856, 0.129705, 0.0842414,
  0.041376, 0.00102344, -0.0368998, -0.0724754, -0.105783, -0.136901,
  -0.165905, -0.192869, -0.217866, -0.240966, -0.262239, -0.281751,
  -0.299569, -0.315756, -0.330375, -0.343486, -0.35515, -0.365423,
  -0.374362, -0.382022, -0.388456, -0.393717, -0.397855, -0.400919,
  -0.402958, -0.404018, -0.404145, -0.403383, -0.401774, -0.399362,
  -0.396186, -0.392285, -0.387699, -0.382464, -0.376617, -0.370193,
  -0.363226, -0.355749, -0.347794, -0.339392, -0.330573, -0.321367,
  -0.311802, -0.301906, -0.291704, -0.281222, -0.270486, -0.25952,
  -0.248346, -0.236987, -0.225464, -0.2138, -0.202013, -0.190123,
  -0.17815, -0.166111, -0.154023, -0.141903, -0.129768, -0.117632,
  -0.105512, -0.09342, -0.0813709, -0.0693777, -0.0574528, -0.0456083,
  -0.0338557, -0.0222059, -0.0106695, 0.000743643, 0.0120239,
  0.0231624, 0.0341504, 0.0449798, 0.0556429, 0.0661325, 0.0764415,
  0.0865637, 0.0964928, 0.106223, 0.115749, 0.125067, 0.13417,
  0.143056, 0.151719, 0.160157, 0.168366, 0.176342, 0.184084,
  0.191589, 0.198854, 0.205878, 0.212659, 0.219195, 0.225486, 0.23153,
  0.237327, 0.242876, 0.248177, 0.25323, 0.258035, 0.262592, 0.266902,
  0.270966, 0.274784, 0.278357, 0.281687, 0.284775, 0.287623,
  0.290231, 0.292603, 0.294739, 0.296642, 0.298314, 0.299757,
  0.300974, 0.301967, 0.302738, 0.303291, 0.303628, 0.303751,
  0.303665, 0.303372, 0.302874, 0.302176, 0.301281, 0.300191, 0.29891,
  0.297442, 0.295789, 0.293957, 0.291947, 0.289764, 0.287411,
  0.284892, 0.282211, 0.279371, 0.276376, 0.27323, 0.269937, 0.2665,
  0.262924, 0.259211, 0.255367, 0.251395, 0.247299, 0.243082,
  0.238748, 0.234302, 0.229747, 0.225088, 0.220327, 0.215469,
  0.210517, 0.205476, 0.200349, 0.19514, 0.189852, 0.184491, 0.179058,
  0.173558, 0.167994, 0.162371, 0.156692, 0.15096, 0.145178, 0.139352,
  0.133483, 0.127575, 0.121633, 0.115658, 0.109656, 0.103628,
  0.097578, 0.0915096, 0.0854259, 0.0793299, 0.0732248, 0.0671137,
  0.0609996, 0.0548855, 0.0487743, 0.042669, 0.0365724, 0.0304874,
  0.0244166, 0.0183629, 0.0123288, 0.00631714, 0.000330371,
  -0.00562893, -0.0115583, -0.0174552, -0.0233174, -0.0291424,
  -0.034928, -0.0406719, -0.0463719, -0.0520259, -0.0576317,
  -0.0631873, -0.0686907, -0.07414, -0.0795331, -0.0848683,
  -0.0901438, -0.0953577, -0.100508, -0.105594, -0.110614, -0.115565,
  -0.120446, -0.125257, -0.129995, -0.134659, -0.139248, -0.14376,
  -0.148195, -0.152551, -0.156826, -0.161021, -0.165133, -0.169162,
  -0.173107, -0.176967, -0.18074, -0.184427, -0.188026, -0.191537,
  -0.194959, -0.198291, -0.201532, -0.204683, -0.207742, -0.210709,
  -0.213584, -0.216366, -0.219055, -0.221651, -0.224152, -0.22656,
  -0.228873, -0.231091, -0.233215, -0.235245, -0.237179, -0.239019,
  -0.240764, -0.242414, -0.243969, -0.245429, -0.246795, -0.248067,
  -0.249244, -0.250328, -0.251318, -0.252214, -0.253017, -0.253728,
  -0.254346, -0.254872, -0.255307, -0.255651, -0.255904, -0.256067,
  -0.25614, -0.256125, -0.256021, -0.255829, -0.25555, -0.255185,
  -0.254734, -0.254198, -0.253577, -0.252873, -0.252086, -0.251217,
  -0.250266, -0.249236, -0.248125, -0.246936, -0.245669, -0.244325,
  -0.242905, -0.24141, -0.23984, -0.238198, -0.236483, -0.234697,
  -0.23284, -0.230915, -0.228921, -0.22686, -0.224733, -0.22254,
  -0.220284, -0.217965, -0.215584, -0.213143, -0.210641, -0.208082,
  -0.205464, -0.202791, -0.200063, -0.197281, -0.194446, -0.191559,
  -0.188622, -0.185636, -0.182601, -0.17952, -0.176393, -0.173221,
  -0.170007, -0.16675, -0.163452, -0.160114, -0.156738, -0.153325,
  -0.149875, -0.146391, -0.142873, -0.139322, -0.13574, -0.132128,
  -0.128488, -0.124819, -0.121124, -0.117404, -0.11366, -0.109893,
  -0.106104, -0.102295, -0.0984663, -0.0946196, -0.090756, -0.0868767,
  -0.0829827, -0.0790753, -0.0751556, -0.0712249, -0.0672841,
  -0.0633345, -0.0593772, -0.0554134, -0.0514441, -0.0474704,
  -0.0434936, -0.0395146, -0.0355346, -0.0315547, -0.0275759,
  -0.0235993, -0.0196259, -0.0156569, -0.0116933, -0.00773601,
  -0.00378618, 0.000155205, 0.00408715, 0.00800865, 0.0119187,
  0.0158164, 0.0197007, 0.0235706, 0.0274253, 0.0312637, 0.0350851,
  0.0388883, 0.0426726, 0.0464371, 0.0501808, 0.053903, 0.0576026,
  0.061279, 0.0649312, 0.0685585, 0.07216, 0.0757349, 0.0792825,
  0.0828019, 0.0862924, 0.0897533, 0.0931838, 0.0965831, 0.0999507,
  0.103286, 0.106588, 0.109855, 0.113089, 0.116287, 0.119449,
  0.122575, 0.125664, 0.128715, 0.131728, 0.134702, 0.137637,
  0.140531, 0.143386, 0.146199, 0.148971, 0.1517, 0.154388, 0.157032,
  0.159633, 0.16219, 0.164703, 0.167171, 0.169594, 0.171972, 0.174304,
  0.176589, 0.178828, 0.18102, 0.183165, 0.185263, 0.187312, 0.189314,
  0.191267, 0.193171, 0.195027, 0.196833, 0.19859, 0.200297, 0.201955,
  0.203563, 0.20512, 0.206628, 0.208085, 0.209491, 0.210847, 0.212152,
  0.213406, 0.214609, 0.215761, 0.216862, 0.217911, 0.21891, 0.219857,
  0.220753, 0.221598, 0.222392, 0.223134, 0.223825, 0.224465,
  0.225054, 0.225591, 0.226078, 0.226514, 0.226899, 0.227233,
  0.227517, 0.227751, 0.227933, 0.228066, 0.228149, 0.228182,
  0.228165, 0.228099, 0.227983, 0.227818, 0.227605, 0.227342,
  0.227032, 0.226673, 0.226266, 0.225811, 0.225309, 0.22476, 0.224163,
  0.223521, 0.222832, 0.222097, 0.221316, 0.22049, 0.219619, 0.218703,
  0.217743, 0.216739, 0.215691, 0.2146, 0.213466, 0.21229, 0.211072,
  0.209812, 0.20851, 0.207168, 0.205785, 0.204362, 0.202899, 0.201398,
  0.199857, 0.198278, 0.196661, 0.195007, 0.193316, 0.191588,
  0.189825, 0.188025, 0.186191, 0.184322, 0.182419, 0.180482,
  0.178512, 0.176509, 0.174475, 0.172409, 0.170311, 0.168183,
  0.166025, 0.163838, 0.161621, 0.159376, 0.157103, 0.154802,
  0.152475, 0.150121, 0.147742, 0.145337, 0.142907, 0.140454,
  0.137976, 0.135476, 0.132953, 0.130408, 0.127842, 0.125255,
  0.122648, 0.120021, 0.117375, 0.11471, 0.112028, 0.109328, 0.106611,
  0.103877, 0.101128, 0.098364, 0.0955852, 0.0927924, 0.0899861,
  0.087167, 0.0843355, 0.0814923, 0.0786379, 0.0757729, 0.0728978,
  0.0700133, 0.0671199, 0.0642181, 0.0613085, 0.0583917, 0.0554683,
  0.0525388, 0.0496037, 0.0466637, 0.0437192, 0.0407709, 0.0378193,
  0.0348649, 0.0319083, 0.0289501, 0.0259907, 0.0230308, 0.0200709,
  0.0171114, 0.014153, 0.0111962, 0.00824154, 0.00528949, 0.00234062,
  -0.000604559, -0.00354552, -0.00648175, -0.00941273, -0.0123379,
  -0.0152569, -0.0181691, -0.021074, -0.0239711, -0.0268599, -0.02974,
  -0.0326108, -0.0354719, -0.0383228, -0.0411629, -0.0439919,
  -0.0468093, -0.0496146, -0.0524072, -0.0551869, -0.0579531,
  -0.0607053, -0.0634432, -0.0661663, -0.0688741, -0.0715662,
  -0.0742422, -0.0769017, -0.0795442, -0.0821694, -0.0847768,
  -0.087366, -0.0899366, -0.0924882, -0.0950204, -0.0975329,
  -0.100025, -0.102497, -0.104948, -0.107378, -0.109786, -0.112172,
  -0.114536, -0.116877, -0.119195, -0.12149, -0.123761, -0.126008,
  -0.128231, -0.130429, -0.132602, -0.13475, -0.136872, -0.138969,
  -0.141039, -0.143083, -0.145101, -0.147091, -0.149054, -0.15099,
  -0.152898, -0.154778, -0.156629, -0.158453, -0.160247, -0.162013,
  -0.163749, -0.165456, -0.167133, -0.168781, -0.170398, -0.171986,
  -0.173543, -0.175069, -0.176565, -0.17803, -0.179464, -0.180866,
  -0.182237, -0.183577, -0.184885, -0.186161, -0.187405, -0.188617,
  -0.189797, -0.190945, -0.19206, -0.193142, -0.194192, -0.195209,
  -0.196194, -0.197145, -0.198064, -0.198949, -0.199802, -0.200621,
  -0.201407, -0.20216, -0.202879, -0.203565, -0.204218, -0.204837,
  -0.205423, -0.205975, -0.206494, -0.20698, -0.207432, -0.20785,
  -0.208235, -0.208587, -0.208905, -0.209189, -0.209441, -0.209659,
  -0.209843, -0.209995, -0.210113, -0.210198, -0.21025, -0.210269,
  -0.210255, -0.210208, -0.210129, -0.210016, -0.209871, -0.209693,
  -0.209483, -0.209241, -0.208966, -0.20866, -0.208321, -0.20795,
  -0.207548, -0.207114, -0.206648, -0.206152, -0.205623, -0.205064,
  -0.204474, -0.203853, -0.203202, -0.20252, -0.201808, -0.201066,
  -0.200294, -0.199492, -0.19866, -0.197799, -0.196909, -0.19599,
  -0.195043, -0.194066, -0.193061, -0.192029, -0.190968, -0.189879,
  -0.188763, -0.187619, -0.186449, -0.185252, -0.184028, -0.182777,
  -0.181501, -0.180198, -0.17887, -0.177517, -0.176139, -0.174735,
  -0.173307, -0.171855, -0.170378, -0.168878, -0.167354, -0.165807,
  -0.164236, -0.162643, -0.161028, -0.15939, -0.15773, -0.156049,
  -0.154347, -0.152623, -0.150879, -0.149114, -0.147329, -0.145524,
  -0.1437, -0.141856, -0.139994, -0.138113, -0.136213, -0.134296,
  -0.13236, -0.130408, -0.128438, -0.126451, -0.124448, -0.122429,
  -0.120394, -0.118344, -0.116278, -0.114198, -0.112103, -0.109994,
  -0.107871, -0.105735, -0.103585, -0.101423, -0.0992475, -0.0970603,
  -0.0948612, -0.0926505, -0.0904287, -0.088196, -0.0859527,
  -0.0836993, -0.0814361, -0.0791633, -0.0768813, -0.0745906,
  -0.0722913, -0.0699838, -0.0676686, -0.0653459, -0.063016,
  -0.0606793, -0.0583362, -0.055987, -0.0536319, -0.0512715,
  -0.0489059, -0.0465356, -0.0441608, -0.041782, -0.0393994,
  -0.0370134, -0.0346244, -0.0322326, -0.0298384, -0.0274422,
  -0.0250442, -0.0226449, -0.0202445, -0.0178434, -0.0154418,
  -0.0130403, -0.010639, -0.00823827, -0.00583851, -0.00344001,
  -0.00104309, 0.00135191, 0.00374468, 0.00613488, 0.0085222,
  0.0109063, 0.0132869, 0.0156636, 0.0180362, 0.0204043, 0.0227676,
  0.0251258, 0.0274786, 0.0298256, 0.0321666, 0.0345013, 0.0368293,
  0.0391504, 0.0414642, 0.0437704, 0.0460688, 0.0483591, 0.0506409,
  0.0529139, 0.0551779, 0.0574326, 0.0596777, 0.0619129, 0.0641379,
  0.0663524, 0.0685563, 0.070749, 0.0729306, 0.0751005, 0.0772586,
  0.0794046, 0.0815382, 0.0836592, 0.0857673, 0.0878622, 0.0899438,
  0.0920116, 0.0940656, 0.0961053, 0.0981307, 0.100141, 0.102137,
  0.104118, 0.106083, 0.108033, 0.109966, 0.111884, 0.113786, 0.11567,
  0.117539, 0.11939, 0.121224, 0.12304, 0.124839, 0.12662, 0.128383,
  0.130128, 0.131855, 0.133563, 0.135252, 0.136922, 0.138572,
  0.140204, 0.141816, 0.143408, 0.14498, 0.146532, 0.148064, 0.149575,
  0.151066, 0.152536, 0.153985, 0.155413, 0.15682, 0.158205, 0.159569,
  0.160912, 0.162232, 0.163531, 0.164807, 0.166061, 0.167293,
  0.168502, 0.169689, 0.170853, 0.171995, 0.173113, 0.174208,
  0.175281, 0.17633, 0.177355, 0.178357, 0.179336, 0.180291, 0.181222,
  0.18213, 0.183013, 0.183873, 0.184709, 0.18552, 0.186308, 0.187071,
  0.187809, 0.188524, 0.189214, 0.18988, 0.190521, 0.191137, 0.191729,
  0.192296, 0.192839, 0.193357, 0.19385, 0.194318, 0.194762, 0.19518,
  0.195574, 0.195943, 0.196288, 0.196607, 0.196901, 0.197171,
  0.197416, 0.197636, 0.19783, 0.198001, 0.198146, 0.198266, 0.198362,
  0.198433, 0.198479, 0.1985, 0.198497, 0.198469, 0.198416, 0.198339,
  0.198237, 0.198111, 0.19796, 0.197785, 0.197585, 0.197362, 0.197114,
  0.196841, 0.196545, 0.196225, 0.19588, 0.195512, 0.19512, 0.194704,
  0.194265, 0.193802, 0.193315, 0.192806, 0.192272, 0.191716,
  0.191137, 0.190534, 0.189909, 0.18926, 0.188589, 0.187896, 0.18718,
  0.186442, 0.185681, 0.184898, 0.184094, 0.183267, 0.182419,
  0.181549, 0.180658, 0.179745, 0.178811, 0.177856, 0.17688, 0.175884,
  0.174866, 0.173829, 0.17277, 0.171692, 0.170594, 0.169476, 0.168338,
  0.16718, 0.166003, 0.164807, 0.163592, 0.162358, 0.161105, 0.159834,
  0.158544, 0.157236, 0.15591, 0.154566, 0.153205, 0.151826, 0.150429,
  0.149016, 0.147586, 0.146139, 0.144675, 0.143195, 0.141699,
  0.140187, 0.138659, 0.137116, 0.135557, 0.133984, 0.132395,
  0.130791, 0.129173, 0.127541, 0.125894, 0.124234, 0.12256, 0.120872,
  0.119171, 0.117457, 0.11573, 0.113991, 0.112239, 0.110475, 0.108699,
  0.106911, 0.105111, 0.103301, 0.101479, 0.0996464, 0.0978032,
  0.0959496, 0.0940858, 0.092212, 0.0903285, 0.0884356, 0.0865333,
  0.0846221, 0.082702, 0.0807734, 0.0788365, 0.0768914, 0.0749385,
  0.072978, 0.07101, 0.0690349, 0.0670529, 0.0650642, 0.0630691,
  0.0610677, 0.0590604, 0.0570473, 0.0550287, 0.0530049, 0.050976,
  0.0489424, 0.0469042, 0.0448617, 0.0428152, 0.0407648, 0.0387108,
  0.0366535, 0.034593, 0.0325297, 0.0304638, 0.0283954, 0.0263249,
  0.0242525, 0.0221784, 0.0201029, 0.0180261, 0.0159484, 0.01387,
  0.0117911, 0.00971193, 0.00763274, 0.00555377, 0.00347526,
  0.00139744, -0.000679458, -0.00275519, -0.00482953, -0.00690224,
  -0.0089731, -0.0110419, -0.0131083, -0.0151722, -0.0172333,
  -0.0192913, -0.0213462, -0.0233975, -0.0254452, -0.0274889,
  -0.0295285, -0.0315637, -0.0335942, -0.03562, -0.0376407,
  -0.0396561, -0.0416661, -0.0436703, -0.0456686, -0.0476607,
  -0.0496465, -0.0516257, -0.0535981, -0.0555635, -0.0575217,
  -0.0594724, -0.0614154, -0.0633507, -0.0652778, -0.0671967,
  -0.0691071, -0.0710088, -0.0729016, -0.0747854, -0.0766598,
  -0.0785248, -0.0803801, -0.0822255, -0.0840608, -0.0858859,
  -0.0877004, -0.0895044, -0.0912975, -0.0930795, -0.0948503,
  -0.0966098, -0.0983576, -0.100094, -0.101818, -0.10353, -0.105229,
  -0.106917, -0.108591, -0.110253, -0.111902, -0.113537, -0.115159,
  -0.116768, -0.118363, -0.119944, -0.121511, -0.123064, -0.124603,
  -0.126127, -0.127637, -0.129132, -0.130612, -0.132076, -0.133526,
  -0.13496, -0.136379, -0.137782, -0.13917, -0.140541, -0.141896,
  -0.143236, -0.144558, -0.145865, -0.147155, -0.148428, -0.149684,
  -0.150923, -0.152146, -0.153351, -0.154538, -0.155709, -0.156862,
  -0.157997, -0.159114, -0.160214, -0.161296, -0.162359, -0.163404,
  -0.164432, -0.16544, -0.166431, -0.167403, -0.168356, -0.16929,
  -0.170206, -0.171103, -0.171981, -0.17284, -0.173679, -0.1745,
  -0.175301, -0.176083, -0.176846, -0.177589, -0.178313, -0.179017,
  -0.179701, -0.180366, -0.18101, -0.181636, -0.182241, -0.182826,
  -0.183391, -0.183937, -0.184462, -0.184967, -0.185453, -0.185918,
  -0.186362, -0.186787, -0.187191, -0.187575, -0.187939, -0.188283,
  -0.188606, -0.188908, -0.189191, -0.189453, -0.189694, -0.189916,
  -0.190116, -0.190297, -0.190457, -0.190596, -0.190715, -0.190814,
  -0.190893, -0.19095, -0.190988, -0.191005, -0.191002, -0.190978,
  -0.190934, -0.19087, -0.190786, -0.190681, -0.190556, -0.190411,
  -0.190245, -0.19006, -0.189854, -0.189628, -0.189382, -0.189117,
  -0.188831, -0.188526, -0.1882, -0.187855, -0.18749, -0.187105,
  -0.186701, -0.186277, -0.185834, -0.185371, -0.184888, -0.184387,
  -0.183866, -0.183326, -0.182766, -0.182188, -0.181591, -0.180975,
  -0.18034, -0.179686, -0.179014, -0.178323, -0.177613, -0.176885,
  -0.176139, -0.175375, -0.174592, -0.173791, -0.172973, -0.172136,
  -0.171282, -0.170411, -0.169521, -0.168615, -0.16769, -0.166749,
  -0.165791, -0.164815, -0.163823, -0.162814, -0.161789, -0.160746,
  -0.159688, -0.158613, -0.157522, -0.156415, -0.155292, -0.154153,
  -0.152998, -0.151828, -0.150643, -0.149442, -0.148226, -0.146996,
  -0.14575, -0.14449, -0.143215, -0.141925, -0.140622, -0.139304,
  -0.137972, -0.136626, -0.135267, -0.133894, -0.132508, -0.131108,
  -0.129695, -0.12827, -0.126831, -0.12538, -0.123917, -0.122441,
  -0.120953, -0.119453, -0.117941, -0.116417, -0.114882, -0.113336,
  -0.111778, -0.11021, -0.10863, -0.10704, -0.105439, -0.103828,
  -0.102207, -0.100576, -0.0989351, -0.0972845, -0.0956244, -0.093955,
  -0.0922765, -0.0905891, -0.0888929, -0.0871881, -0.0854749,
  -0.0837535, -0.0820241, -0.0802867, -0.0785417, -0.0767892,
  -0.0750294, -0.0732624, -0.0714885, -0.0697079, -0.0679206,
  -0.066127, -0.0643271, -0.0625213, -0.0607096, -0.0588922,
  -0.0570694, -0.0552413, -0.0534082, -0.0515701, -0.0497274,
  -0.0478801, -0.0460285, -0.0441728, -0.0423131, -0.0404497,
  -0.0385827, -0.0367123, -0.0348388, -0.0329623, -0.031083,
  -0.029201, -0.0273167, -0.0254301, -0.0235415, -0.0216511,
  -0.019759, -0.0178655, -0.0159707, -0.0140748, -0.0121781,
  -0.0102806, -0.00838268, -0.00648444, -0.00458608, -0.00268779,
  -0.000789776, 0.00110778, 0.00300469, 0.00490076, 0.00679581,
  0.00868963, 0.010582, 0.0124729, 0.0143619, 0.016249, 0.0181339,
  0.0200164, 0.0218964, 0.0237737, 0.0256481, 0.0275193, 0.0293873,
  0.0312518, 0.0331127, 0.0349697, 0.0368227, 0.0386715, 0.040516,
  0.0423558, 0.0441909, 0.0460211, 0.0478461, 0.0496659, 0.0514802,
  0.0532888, 0.0550916, 0.0568885, 0.0586791, 0.0604634, 0.0622412,
  0.0640122, 0.0657764, 0.0675335, 0.0692834, 0.071026, 0.072761,
  0.0744882, 0.0762075, 0.0779188, 0.0796219, 0.0813166, 0.0830027,
  0.0846801, 0.0863486, 0.0880081, 0.0896583, 0.0912992, 0.0929306,
  0.0945523, 0.0961642, 0.0977661, 0.0993578, 0.100939, 0.10251,
  0.104071, 0.10562, 0.107159, 0.108687, 0.110203, 0.111709, 0.113202,
  0.114684, 0.116155, 0.117613, 0.11906, 0.120494, 0.121916, 0.123325,
  0.124722, 0.126106, 0.127478, 0.128836, 0.130182, 0.131514,
  0.132832, 0.134138, 0.135429, 0.136707, 0.137971, 0.139221,
  0.140458, 0.141679, 0.142887, 0.14408, 0.145259, 0.146423, 0.147572,
  0.148707, 0.149826, 0.150931, 0.15202, 0.153094, 0.154153, 0.155196,
  0.156224, 0.157236, 0.158232, 0.159213, 0.160177, 0.161126,
  0.162058, 0.162975, 0.163875, 0.164759, 0.165626, 0.166477,
  0.167311, 0.168129, 0.16893, 0.169714, 0.170481, 0.171231, 0.171965,
  0.172681, 0.17338, 0.174062, 0.174727, 0.175374, 0.176004, 0.176617,
  0.177212, 0.17779, 0.17835, 0.178893, 0.179418, 0.179925, 0.180414,
  0.180886, 0.18134, 0.181776, 0.182194, 0.182594, 0.182976, 0.183341,
  0.183687, 0.184015, 0.184325, 0.184617, 0.184891, 0.185147,
  0.185385, 0.185604, 0.185805, 0.185988, 0.186153, 0.1863, 0.186428,
  0.186539, 0.186631, 0.186704, 0.18676, 0.186797, 0.186816, 0.186817,
  0.1868, 0.186764, 0.18671, 0.186639, 0.186548, 0.18644, 0.186314,
  0.186169, 0.186006, 0.185826, 0.185627, 0.18541, 0.185175, 0.184922,
  0.184652, 0.184363, 0.184057, 0.183732, 0.18339, 0.18303, 0.182652,
  0.182257, 0.181844, 0.181414, 0.180965, 0.1805, 0.180017, 0.179516,
  0.178999, 0.178464, 0.177911, 0.177342, 0.176755, 0.176152,
  0.175531, 0.174894, 0.174239, 0.173568, 0.17288, 0.172176, 0.171455,
  0.170718, 0.169964, 0.169193, 0.168407, 0.167604, 0.166785,
  0.165951, 0.1651, 0.164233, 0.163351, 0.162453, 0.16154, 0.160611,
  0.159666, 0.158707, 0.157732, 0.156742, 0.155737, 0.154717,
  0.153683, 0.152634, 0.15157, 0.150491, 0.149399, 0.148292, 0.147171,
  0.146036, 0.144886, 0.143724, 0.142547, 0.141357, 0.140153,
  0.138936, 0.137706, 0.136463, 0.135207, 0.133938, 0.132656,
  0.131362, 0.130055, 0.128736, 0.127404, 0.126061, 0.124705,
  0.123338, 0.121959, 0.120569, 0.119167, 0.117753, 0.116329,
  0.114894, 0.113448, 0.111991, 0.110523, 0.109045, 0.107557,
  0.106059, 0.10455, 0.103032, 0.101504, 0.0999668, 0.09842,
  0.0968638, 0.0952986, 0.0937244, 0.0921414, 0.0905498, 0.0889496,
  0.0873411, 0.0857244, 0.0840997, 0.0824672, 0.0808269, 0.079179,
  0.0775238, 0.0758613, 0.0741917, 0.0725152, 0.0708319, 0.0691421,
  0.0674458, 0.0657432, 0.0640346, 0.06232, 0.0605996, 0.0588736,
  0.0571422, 0.0554054, 0.0536636, 0.0519168, 0.0501652, 0.048409,
  0.0466484, 0.0448835, 0.0431144, 0.0413415, 0.0395647, 0.0377844,
  0.0360006, 0.0342136, 0.0324235, 0.0306304, 0.0288347, 0.0270363,
  0.0252355, 0.0234325, 0.0216274, 0.0198205, 0.0180118, 0.0162016,
  0.01439, 0.0125771, 0.0107633, 0.0089486, 0.00713322, 0.00531732,
  0.00350108, 0.00168467, -0.000131731, -0.00194796, -0.00376384,
  -0.0055792, -0.00739387, -0.00920767, -0.0110204, -0.012832,
  -0.0146422, -0.0164508, -0.0182577, -0.0200627, -0.0218657,
  -0.0236664, -0.0254647, -0.0272605, -0.0290535, -0.0308435,
  -0.0326306, -0.0344143, -0.0361946, -0.0379714, -0.0397444,
  -0.0415134, -0.0432784, -0.0450391, -0.0467954, -0.0485471,
  -0.0502941, -0.0520361, -0.0537731, -0.0555048, -0.0572311,
  -0.0589518, -0.0606668, -0.0623759, -0.064079, -0.0657758,
  -0.0674663, -0.0691502, -0.0708275, -0.0724979, -0.0741612,
  -0.0758174, -0.0774663, -0.0791078, -0.0807416, -0.0823676,
  -0.0839857, -0.0855957, -0.0871974, -0.0887908, -0.0903756,
  -0.0919518, -0.0935191, -0.0950774, -0.0966266, -0.0981665,
  -0.0996971, -0.101218, -0.102729, -0.104231, -0.105722, -0.107203,
  -0.108674, -0.110135, -0.111585, -0.113025, -0.114453, -0.115871,
  -0.117277, -0.118673, -0.120057, -0.121429, -0.12279, -0.12414,
  -0.125477, -0.126803, -0.128116, -0.129417, -0.130706, -0.131982,
  -0.133246, -0.134497, -0.135735, -0.13696, -0.138173, -0.139372,
  -0.140558, -0.14173, -0.142889, -0.144034, -0.145166, -0.146284,
  -0.147388, -0.148478, -0.149553, -0.150615, -0.151662, -0.152695,
  -0.153713, -0.154717, -0.155706, -0.15668, -0.157639, -0.158583,
  -0.159513, -0.160427, -0.161325, -0.162209, -0.163077, -0.16393,
  -0.164767, -0.165588, -0.166394, -0.167184, -0.167958, -0.168716,
  -0.169458, -0.170184, -0.170894, -0.171587, -0.172265, -0.172926,
  -0.17357, -0.174199, -0.17481, -0.175405, -0.175984, -0.176546,
  -0.177091, -0.177619, -0.17813, -0.178625, -0.179102, -0.179563,
  -0.180006, -0.180433, -0.180842, -0.181234, -0.181609, -0.181967,
  -0.182308, -0.182631, -0.182937, -0.183226, -0.183497, -0.183751,
  -0.183988, -0.184207, -0.184409, -0.184593, -0.184759, -0.184909,
  -0.18504, -0.185154, -0.185251, -0.18533, -0.185392, -0.185435,
  -0.185462, -0.185471, -0.185462, -0.185435, -0.185392, -0.18533,
  -0.185251, -0.185154, -0.18504, -0.184909, -0.184759, -0.184593,
  -0.184409, -0.184207, -0.183988, -0.183751, -0.183497, -0.183226,
  -0.182937, -0.182631, -0.182308, -0.181967, -0.181609, -0.181234,
  -0.180842, -0.180433, -0.180006, -0.179563, -0.179102, -0.178625,
  -0.17813, -0.177619, -0.177091, -0.176546, -0.175984, -0.175405,
  -0.17481, -0.174199, -0.17357, -0.172926, -0.172265, -0.171587,
  -0.170894, -0.170184, -0.169458, -0.168716, -0.167958, -0.167184,
  -0.166394, -0.165588, -0.164767, -0.16393, -0.163077, -0.162209,
  -0.161325, -0.160427, -0.159513, -0.158583, -0.157639, -0.15668,
  -0.155706, -0.154717, -0.153713, -0.152695, -0.151662, -0.150615,
  -0.149553, -0.148478, -0.147388, -0.146284, -0.145166, -0.144034,
  -0.142889, -0.14173, -0.140558, -0.139372, -0.138173, -0.13696,
  -0.135735, -0.134497, -0.133246, -0.131982, -0.130706, -0.129417,
  -0.128116, -0.126803, -0.125477, -0.12414, -0.12279, -0.121429,
  -0.120057, -0.118673, -0.117277, -0.115871, -0.114453, -0.113025,
  -0.111585, -0.110135, -0.108674, -0.107203, -0.105722, -0.104231,
  -0.102729, -0.101218, -0.0996971, -0.0981665, -0.0966266,
  -0.0950774, -0.0935191, -0.0919518, -0.0903756, -0.0887908,
  -0.0871974, -0.0855957, -0.0839857, -0.0823676, -0.0807416,
  -0.0791078, -0.0774663, -0.0758174, -0.0741612, -0.0724979,
  -0.0708275, -0.0691502, -0.0674663, -0.0657758, -0.064079,
  -0.0623759, -0.0606668, -0.0589518, -0.0572311, -0.0555048,
  -0.0537731, -0.0520361, -0.0502941, -0.0485471, -0.0467954,
  -0.0450391, -0.0432784, -0.0415134, -0.0397444, -0.0379714,
  -0.0361946, -0.0344143, -0.0326306, -0.0308435, -0.0290535,
  -0.0272605, -0.0254647, -0.0236664, -0.0218657, -0.0200627,
  -0.0182577, -0.0164508, -0.0146422, -0.012832, -0.0110204,
  -0.00920767, -0.00739387, -0.0055792, -0.00376384, -0.00194796,
  -0.000131731, 0.00168467, 0.00350108, 0.00531732, 0.00713322,
  0.0089486, 0.0107633, 0.0125771, 0.01439, 0.0162016, 0.0180118,
  0.0198205, 0.0216274, 0.0234325, 0.0252355, 0.0270363, 0.0288347,
  0.0306304, 0.0324235, 0.0342136, 0.0360006, 0.0377844, 0.0395647,
  0.0413415, 0.0431144, 0.0448835, 0.0466484, 0.048409, 0.0501652,
  0.0519168, 0.0536636, 0.0554054, 0.0571422, 0.0588736, 0.0605996,
  0.06232, 0.0640346, 0.0657432, 0.0674458, 0.0691421, 0.0708319,
  0.0725152, 0.0741917, 0.0758613, 0.0775238, 0.079179, 0.0808269,
  0.0824672, 0.0840997, 0.0857244, 0.0873411, 0.0889496, 0.0905498,
  0.0921414, 0.0937244, 0.0952986, 0.0968638, 0.09842, 0.0999668,
  0.101504, 0.103032, 0.10455, 0.106059, 0.107557, 0.109045, 0.110523,
  0.111991, 0.113448, 0.114894, 0.116329, 0.117753, 0.119167,
  0.120569, 0.121959, 0.123338, 0.124705, 0.126061, 0.127404,
  0.128736, 0.130055, 0.131362, 0.132656, 0.133938, 0.135207,
  0.136463, 0.137706, 0.138936, 0.140153, 0.141357, 0.142547,
  0.143724, 0.144886, 0.146036, 0.147171, 0.148292, 0.149399,
  0.150491, 0.15157, 0.152634, 0.153683, 0.154717, 0.155737, 0.156742,
  0.157732, 0.158707, 0.159666, 0.160611, 0.16154, 0.162453, 0.163351,
  0.164233, 0.1651, 0.165951, 0.166785, 0.167604, 0.168407, 0.169193,
  0.169964, 0.170718, 0.171455, 0.172176, 0.17288, 0.173568, 0.174239,
  0.174894, 0.175531, 0.176152, 0.176755, 0.177342, 0.177911,
  0.178464, 0.178999, 0.179516, 0.180017, 0.1805, 0.180965, 0.181414,
  0.181844, 0.182257, 0.182652, 0.18303, 0.18339, 0.183732, 0.184057,
  0.184363, 0.184652, 0.184922, 0.185175, 0.18541, 0.185627, 0.185826,
  0.186006, 0.186169, 0.186314, 0.18644, 0.186548, 0.186639, 0.18671,
  0.186764, 0.1868, 0.186817, 0.186816, 0.186797, 0.18676, 0.186704,
  0.186631, 0.186539, 0.186428, 0.1863, 0.186153, 0.185988, 0.185805,
  0.185604, 0.185385, 0.185147, 0.184891, 0.184617, 0.184325,
  0.184015, 0.183687, 0.183341, 0.182976, 0.182594, 0.182194,
  0.181776, 0.18134, 0.180886, 0.180414, 0.179925, 0.179418, 0.178893,
  0.17835, 0.17779, 0.177212, 0.176617, 0.176004, 0.175374, 0.174727,
  0.174062, 0.17338, 0.172681, 0.171965, 0.171231, 0.170481, 0.169714,
  0.16893, 0.168129, 0.167311, 0.166477, 0.165626, 0.164759, 0.163875,
  0.162975, 0.162058, 0.161126, 0.160177, 0.159213, 0.158232,
  0.157236, 0.156224, 0.155196, 0.154153, 0.153094, 0.15202, 0.150931,
  0.149826, 0.148707, 0.147572, 0.146423, 0.145259, 0.14408, 0.142887,
  0.141679, 0.140458, 0.139221, 0.137971, 0.136707, 0.135429,
  0.134138, 0.132832, 0.131514, 0.130182, 0.128836, 0.127478,
  0.126106, 0.124722, 0.123325, 0.121916, 0.120494, 0.11906, 0.117613,
  0.116155, 0.114684, 0.113202, 0.111709, 0.110203, 0.108687,
  0.107159, 0.10562, 0.104071, 0.10251, 0.100939, 0.0993578,
  0.0977661, 0.0961642, 0.0945523, 0.0929306, 0.0912992, 0.0896583,
  0.0880081, 0.0863486, 0.0846801, 0.0830027, 0.0813166, 0.0796219,
  0.0779188, 0.0762075, 0.0744882, 0.072761, 0.071026, 0.0692834,
  0.0675335, 0.0657764, 0.0640122, 0.0622412, 0.0604634, 0.0586791,
  0.0568885, 0.0550916, 0.0532888, 0.0514802, 0.0496659, 0.0478461,
  0.0460211, 0.0441909, 0.0423558, 0.040516, 0.0386715, 0.0368227,
  0.0349697, 0.0331127, 0.0312518, 0.0293873, 0.0275193, 0.0256481,
  0.0237737, 0.0218964, 0.0200164, 0.0181339, 0.016249, 0.0143619,
  0.0124729, 0.010582, 0.00868963, 0.00679581, 0.00490076, 0.00300469,
  0.00110778, -0.000789776, -0.00268779, -0.00458608, -0.00648444,
  -0.00838268, -0.0102806, -0.0121781, -0.0140748, -0.0159707,
  -0.0178655, -0.019759, -0.0216511, -0.0235415, -0.0254301,
  -0.0273167, -0.029201, -0.031083, -0.0329623, -0.0348388,
  -0.0367123, -0.0385827, -0.0404497, -0.0423131, -0.0441728,
  -0.0460285, -0.0478801, -0.0497274, -0.0515701, -0.0534082,
  -0.0552413, -0.0570694, -0.0588922, -0.0607096, -0.0625213,
  -0.0643271, -0.066127, -0.0679206, -0.0697079, -0.0714885,
  -0.0732624, -0.0750294, -0.0767892, -0.0785417, -0.0802867,
  -0.0820241, -0.0837535, -0.0854749, -0.0871881, -0.0888929,
  -0.0905891, -0.0922765, -0.093955, -0.0956244, -0.0972845,
  -0.0989351, -0.100576, -0.102207, -0.103828, -0.105439, -0.10704,
  -0.10863, -0.11021, -0.111778, -0.113336, -0.114882, -0.116417,
  -0.117941, -0.119453, -0.120953, -0.122441, -0.123917, -0.12538,
  -0.126831, -0.12827, -0.129695, -0.131108, -0.132508, -0.133894,
  -0.135267, -0.136626, -0.137972, -0.139304, -0.140622, -0.141925,
  -0.143215, -0.14449, -0.14575, -0.146996, -0.148226, -0.149442,
  -0.150643, -0.151828, -0.152998, -0.154153, -0.155292, -0.156415,
  -0.157522, -0.158613, -0.159688, -0.160746, -0.161789, -0.162814,
  -0.163823, -0.164815, -0.165791, -0.166749, -0.16769, -0.168615,
  -0.169521, -0.170411, -0.171282, -0.172136, -0.172973, -0.173791,
  -0.174592, -0.175375, -0.176139, -0.176885, -0.177613, -0.178323,
  -0.179014, -0.179686, -0.18034, -0.180975, -0.181591, -0.182188,
  -0.182766, -0.183326, -0.183866, -0.184387, -0.184888, -0.185371,
  -0.185834, -0.186277, -0.186701, -0.187105, -0.18749, -0.187855,
  -0.1882, -0.188526, -0.188831, -0.189117, -0.189382, -0.189628,
  -0.189854, -0.19006, -0.190245, -0.190411, -0.190556, -0.190681,
  -0.190786, -0.19087, -0.190934, -0.190978, -0.191002, -0.191005,
  -0.190988, -0.19095, -0.190893, -0.190814, -0.190715, -0.190596,
  -0.190457, -0.190297, -0.190116, -0.189916, -0.189694, -0.189453,
  -0.189191, -0.188908, -0.188606, -0.188283, -0.187939, -0.187575,
  -0.187191, -0.186787, -0.186362, -0.185918, -0.185453, -0.184967,
  -0.184462, -0.183937, -0.183391, -0.182826, -0.182241, -0.181636,
  -0.18101, -0.180366, -0.179701, -0.179017, -0.178313, -0.177589,
  -0.176846, -0.176083, -0.175301, -0.1745, -0.173679, -0.17284,
  -0.171981, -0.171103, -0.170206, -0.16929, -0.168356, -0.167403,
  -0.166431, -0.16544, -0.164432, -0.163404, -0.162359, -0.161296,
  -0.160214, -0.159114, -0.157997, -0.156862, -0.155709, -0.154538,
  -0.153351, -0.152146, -0.150923, -0.149684, -0.148428, -0.147155,
  -0.145865, -0.144558, -0.143236, -0.141896, -0.140541, -0.13917,
  -0.137782, -0.136379, -0.13496, -0.133526, -0.132076, -0.130612,
  -0.129132, -0.127637, -0.126127, -0.124603, -0.123064, -0.121511,
  -0.119944, -0.118363, -0.116768, -0.115159, -0.113537, -0.111902,
  -0.110253, -0.108591, -0.106917, -0.105229, -0.10353, -0.101818,
  -0.100094, -0.0983576, -0.0966098, -0.0948503, -0.0930795,
  -0.0912975, -0.0895044, -0.0877004, -0.0858859, -0.0840608,
  -0.0822255, -0.0803801, -0.0785248, -0.0766598, -0.0747854,
  -0.0729016, -0.0710088, -0.0691071, -0.0671967, -0.0652778,
  -0.0633507, -0.0614154, -0.0594724, -0.0575217, -0.0555635,
  -0.0535981, -0.0516257, -0.0496465, -0.0476607, -0.0456686,
  -0.0436703, -0.0416661, -0.0396561, -0.0376407, -0.03562,
  -0.0335942, -0.0315637, -0.0295285, -0.0274889, -0.0254452,
  -0.0233975, -0.0213462, -0.0192913, -0.0172333, -0.0151722,
  -0.0131083, -0.0110419, -0.0089731, -0.00690224, -0.00482953,
  -0.00275519, -0.000679458, 0.00139744, 0.00347526, 0.00555377,
  0.00763274, 0.00971193, 0.0117911, 0.01387, 0.0159484, 0.0180261,
  0.0201029, 0.0221784, 0.0242525, 0.0263249, 0.0283954, 0.0304638,
  0.0325297, 0.034593, 0.0366535, 0.0387108, 0.0407648, 0.0428152,
  0.0448617, 0.0469042, 0.0489424, 0.050976, 0.0530049, 0.0550287,
  0.0570473, 0.0590604, 0.0610677, 0.0630691, 0.0650642, 0.0670529,
  0.0690349, 0.07101, 0.072978, 0.0749385, 0.0768914, 0.0788365,
  0.0807734, 0.082702, 0.0846221, 0.0865333, 0.0884356, 0.0903285,
  0.092212, 0.0940858, 0.0959496, 0.0978032, 0.0996464, 0.101479,
  0.103301, 0.105111, 0.106911, 0.108699, 0.110475, 0.112239,
  0.113991, 0.11573, 0.117457, 0.119171, 0.120872, 0.12256, 0.124234,
  0.125894, 0.127541, 0.129173, 0.130791, 0.132395, 0.133984,
  0.135557, 0.137116, 0.138659, 0.140187, 0.141699, 0.143195,
  0.144675, 0.146139, 0.147586, 0.149016, 0.150429, 0.151826,
  0.153205, 0.154566, 0.15591, 0.157236, 0.158544, 0.159834, 0.161105,
  0.162358, 0.163592, 0.164807, 0.166003, 0.16718, 0.168338, 0.169476,
  0.170594, 0.171692, 0.17277, 0.173829, 0.174866, 0.175884, 0.17688,
  0.177856, 0.178811, 0.179745, 0.180658, 0.181549, 0.182419,
  0.183267, 0.184094, 0.184898, 0.185681, 0.186442, 0.18718, 0.187896,
  0.188589, 0.18926, 0.189909, 0.190534, 0.191137, 0.191716, 0.192272,
  0.192806, 0.193315, 0.193802, 0.194265, 0.194704, 0.19512, 0.195512,
  0.19588, 0.196225, 0.196545, 0.196841, 0.197114, 0.197362, 0.197585,
  0.197785, 0.19796, 0.198111, 0.198237, 0.198339, 0.198416, 0.198469,
  0.198497, 0.1985, 0.198479, 0.198433, 0.198362, 0.198266, 0.198146,
  0.198001, 0.19783, 0.197636, 0.197416, 0.197171, 0.196901, 0.196607,
  0.196288, 0.195943, 0.195574, 0.19518, 0.194762, 0.194318, 0.19385,
  0.193357, 0.192839, 0.192296, 0.191729, 0.191137, 0.190521, 0.18988,
  0.189214, 0.188524, 0.187809, 0.187071, 0.186308, 0.18552, 0.184709,
  0.183873, 0.183013, 0.18213, 0.181222, 0.180291, 0.179336, 0.178357,
  0.177355, 0.17633, 0.175281, 0.174208, 0.173113, 0.171995, 0.170853,
  0.169689, 0.168502, 0.167293, 0.166061, 0.164807, 0.163531,
  0.162232, 0.160912, 0.159569, 0.158205, 0.15682, 0.155413, 0.153985,
  0.152536, 0.151066, 0.149575, 0.148064, 0.146532, 0.14498, 0.143408,
  0.141816, 0.140204, 0.138572, 0.136922, 0.135252, 0.133563,
  0.131855, 0.130128, 0.128383, 0.12662, 0.124839, 0.12304, 0.121224,
  0.11939, 0.117539, 0.11567, 0.113786, 0.111884, 0.109966, 0.108033,
  0.106083, 0.104118, 0.102137, 0.100141, 0.0981307, 0.0961053,
  0.0940656, 0.0920116, 0.0899438, 0.0878622, 0.0857673, 0.0836592,
  0.0815382, 0.0794046, 0.0772586, 0.0751005, 0.0729306, 0.070749,
  0.0685563, 0.0663524, 0.0641379, 0.0619129, 0.0596777, 0.0574326,
  0.0551779, 0.0529139, 0.0506409, 0.0483591, 0.0460688, 0.0437704,
  0.0414642, 0.0391504, 0.0368293, 0.0345013, 0.0321666, 0.0298256,
  0.0274786, 0.0251258, 0.0227676, 0.0204043, 0.0180362, 0.0156636,
  0.0132869, 0.0109063, 0.0085222, 0.00613488, 0.00374468, 0.00135191,
  -0.00104309, -0.00344001, -0.00583851, -0.00823827, -0.010639,
  -0.0130403, -0.0154418, -0.0178434, -0.0202445, -0.0226449,
  -0.0250442, -0.0274422, -0.0298384, -0.0322326, -0.0346244,
  -0.0370134, -0.0393994, -0.041782, -0.0441608, -0.0465356,
  -0.0489059, -0.0512715, -0.0536319, -0.055987, -0.0583362,
  -0.0606793, -0.063016, -0.0653459, -0.0676686, -0.0699838,
  -0.0722913, -0.0745906, -0.0768813, -0.0791633, -0.0814361,
  -0.0836993, -0.0859527, -0.088196, -0.0904287, -0.0926505,
  -0.0948612, -0.0970603, -0.0992475, -0.101423, -0.103585, -0.105735,
  -0.107871, -0.109994, -0.112103, -0.114198, -0.116278, -0.118344,
  -0.120394, -0.122429, -0.124448, -0.126451, -0.128438, -0.130408,
  -0.13236, -0.134296, -0.136213, -0.138113, -0.139994, -0.141856,
  -0.1437, -0.145524, -0.147329, -0.149114, -0.150879, -0.152623,
  -0.154347, -0.156049, -0.15773, -0.15939, -0.161028, -0.162643,
  -0.164236, -0.165807, -0.167354, -0.168878, -0.170378, -0.171855,
  -0.173307, -0.174735, -0.176139, -0.177517, -0.17887, -0.180198,
  -0.181501, -0.182777, -0.184028, -0.185252, -0.186449, -0.187619,
  -0.188763, -0.189879, -0.190968, -0.192029, -0.193061, -0.194066,
  -0.195043, -0.19599, -0.196909, -0.197799, -0.19866, -0.199492,
  -0.200294, -0.201066, -0.201808, -0.20252, -0.203202, -0.203853,
  -0.204474, -0.205064, -0.205623, -0.206152, -0.206648, -0.207114,
  -0.207548, -0.20795, -0.208321, -0.20866, -0.208966, -0.209241,
  -0.209483, -0.209693, -0.209871, -0.210016, -0.210129, -0.210208,
  -0.210255, -0.210269, -0.21025, -0.210198, -0.210113, -0.209995,
  -0.209843, -0.209659, -0.209441, -0.209189, -0.208905, -0.208587,
  -0.208235, -0.20785, -0.207432, -0.20698, -0.206494, -0.205975,
  -0.205423, -0.204837, -0.204218, -0.203565, -0.202879, -0.20216,
  -0.201407, -0.200621, -0.199802, -0.198949, -0.198064, -0.197145,
  -0.196194, -0.195209, -0.194192, -0.193142, -0.19206, -0.190945,
  -0.189797, -0.188617, -0.187405, -0.186161, -0.184885, -0.183577,
  -0.182237, -0.180866, -0.179464, -0.17803, -0.176565, -0.175069,
  -0.173543, -0.171986, -0.170398, -0.168781, -0.167133, -0.165456,
  -0.163749, -0.162013, -0.160247, -0.158453, -0.156629, -0.154778,
  -0.152898, -0.15099, -0.149054, -0.147091, -0.145101, -0.143083,
  -0.141039, -0.138969, -0.136872, -0.13475, -0.132602, -0.130429,
  -0.128231, -0.126008, -0.123761, -0.12149, -0.119195, -0.116877,
  -0.114536, -0.112172, -0.109786, -0.107378, -0.104948, -0.102497,
  -0.100025, -0.0975329, -0.0950204, -0.0924882, -0.0899366,
  -0.087366, -0.0847768, -0.0821694, -0.0795442, -0.0769017,
  -0.0742422, -0.0715662, -0.0688741, -0.0661663, -0.0634432,
  -0.0607053, -0.0579531, -0.0551869, -0.0524072, -0.0496146,
  -0.0468093, -0.0439919, -0.0411629, -0.0383228, -0.0354719,
  -0.0326108, -0.02974, -0.0268599, -0.0239711, -0.021074, -0.0181691,
  -0.0152569, -0.0123379, -0.00941273, -0.00648175, -0.00354552,
  -0.000604559, 0.00234062, 0.00528949, 0.00824154, 0.0111962,
  0.014153, 0.0171114, 0.0200709, 0.0230308, 0.0259907, 0.0289501,
  0.0319083, 0.0348649, 0.0378193, 0.0407709, 0.0437192, 0.0466637,
  0.0496037, 0.0525388, 0.0554683, 0.0583917, 0.0613085, 0.0642181,
  0.0671199, 0.0700133, 0.0728978, 0.0757729, 0.0786379, 0.0814923,
  0.0843355, 0.087167, 0.0899861, 0.0927924, 0.0955852, 0.098364,
  0.101128, 0.103877, 0.106611, 0.109328, 0.112028, 0.11471, 0.117375,
  0.120021, 0.122648, 0.125255, 0.127842, 0.130408, 0.132953,
  0.135476, 0.137976, 0.140454, 0.142907, 0.145337, 0.147742,
  0.150121, 0.152475, 0.154802, 0.157103, 0.159376, 0.161621,
  0.163838, 0.166025, 0.168183, 0.170311, 0.172409, 0.174475,
  0.176509, 0.178512, 0.180482, 0.182419, 0.184322, 0.186191,
  0.188025, 0.189825, 0.191588, 0.193316, 0.195007, 0.196661,
  0.198278, 0.199857, 0.201398, 0.202899, 0.204362, 0.205785,
  0.207168, 0.20851, 0.209812, 0.211072, 0.21229, 0.213466, 0.2146,
  0.215691, 0.216739, 0.217743, 0.218703, 0.219619, 0.22049, 0.221316,
  0.222097, 0.222832, 0.223521, 0.224163, 0.22476, 0.225309, 0.225811,
  0.226266, 0.226673, 0.227032, 0.227342, 0.227605, 0.227818,
  0.227983, 0.228099, 0.228165, 0.228182, 0.228149, 0.228066,
  0.227933, 0.227751, 0.227517, 0.227233, 0.226899, 0.226514,
  0.226078, 0.225591, 0.225054, 0.224465, 0.223825, 0.223134,
  0.222392, 0.221598, 0.220753, 0.219857, 0.21891, 0.217911, 0.216862,
  0.215761, 0.214609, 0.213406, 0.212152, 0.210847, 0.209491,
  0.208085, 0.206628, 0.20512, 0.203563, 0.201955, 0.200297, 0.19859,
  0.196833, 0.195027, 0.193171, 0.191267, 0.189314, 0.187312,
  0.185263, 0.183165, 0.18102, 0.178828, 0.176589, 0.174304, 0.171972,
  0.169594, 0.167171, 0.164703, 0.16219, 0.159633, 0.157032, 0.154388,
  0.1517, 0.148971, 0.146199, 0.143386, 0.140531, 0.137637, 0.134702,
  0.131728, 0.128715, 0.125664, 0.122575, 0.119449, 0.116287,
  0.113089, 0.109855, 0.106588, 0.103286, 0.0999507, 0.0965831,
  0.0931838, 0.0897533, 0.0862924, 0.0828019, 0.0792825, 0.0757349,
  0.07216, 0.0685585, 0.0649312, 0.061279, 0.0576026, 0.053903,
  0.0501808, 0.0464371, 0.0426726, 0.0388883, 0.0350851, 0.0312637,
  0.0274253, 0.0235706, 0.0197007, 0.0158164, 0.0119187, 0.00800865,
  0.00408715, 0.000155205, -0.00378618, -0.00773601, -0.0116933,
  -0.0156569, -0.0196259, -0.0235993, -0.0275759, -0.0315547,
  -0.0355346, -0.0395146, -0.0434936, -0.0474704, -0.0514441,
  -0.0554134, -0.0593772, -0.0633345, -0.0672841, -0.0712249,
  -0.0751556, -0.0790753, -0.0829827, -0.0868767, -0.090756,
  -0.0946196, -0.0984663, -0.102295, -0.106104, -0.109893, -0.11366,
  -0.117404, -0.121124, -0.124819, -0.128488, -0.132128, -0.13574,
  -0.139322, -0.142873, -0.146391, -0.149875, -0.153325, -0.156738,
  -0.160114, -0.163452, -0.16675, -0.170007, -0.173221, -0.176393,
  -0.17952, -0.182601, -0.185636, -0.188622, -0.191559, -0.194446,
  -0.197281, -0.200063, -0.202791, -0.205464, -0.208082, -0.210641,
  -0.213143, -0.215584, -0.217965, -0.220284, -0.22254, -0.224733,
  -0.22686, -0.228921, -0.230915, -0.23284, -0.234697, -0.236483,
  -0.238198, -0.23984, -0.24141, -0.242905, -0.244325, -0.245669,
  -0.246936, -0.248125, -0.249236, -0.250266, -0.251217, -0.252086,
  -0.252873, -0.253577, -0.254198, -0.254734, -0.255185, -0.25555,
  -0.255829, -0.256021, -0.256125, -0.25614, -0.256067, -0.255904,
  -0.255651, -0.255307, -0.254872, -0.254346, -0.253728, -0.253017,
  -0.252214, -0.251318, -0.250328, -0.249244, -0.248067, -0.246795,
  -0.245429, -0.243969, -0.242414, -0.240764, -0.239019, -0.237179,
  -0.235245, -0.233215, -0.231091, -0.228873, -0.22656, -0.224152,
  -0.221651, -0.219055, -0.216366, -0.213584, -0.210709, -0.207742,
  -0.204683, -0.201532, -0.198291, -0.194959, -0.191537, -0.188026,
  -0.184427, -0.18074, -0.176967, -0.173107, -0.169162, -0.165133,
  -0.161021, -0.156826, -0.152551, -0.148195, -0.14376, -0.139248,
  -0.134659, -0.129995, -0.125257, -0.120446, -0.115565, -0.110614,
  -0.105594, -0.100508, -0.0953577, -0.0901438, -0.0848683,
  -0.0795331, -0.07414, -0.0686907, -0.0631873, -0.0576317,
  -0.0520259, -0.0463719, -0.0406719, -0.034928, -0.0291424,
  -0.0233174, -0.0174552, -0.0115583, -0.00562893, 0.000330371,
  0.00631714, 0.0123288, 0.0183629, 0.0244166, 0.0304874, 0.0365724,
  0.042669, 0.0487743, 0.0548855, 0.0609996, 0.0671137, 0.0732248,
  0.0793299, 0.0854259, 0.0915096, 0.097578, 0.103628, 0.109656,
  0.115658, 0.121633, 0.127575, 0.133483, 0.139352, 0.145178, 0.15096,
  0.156692, 0.162371, 0.167994, 0.173558, 0.179058, 0.184491,
  0.189852, 0.19514, 0.200349, 0.205476, 0.210517, 0.215469, 0.220327,
  0.225088, 0.229747, 0.234302, 0.238748, 0.243082, 0.247299,
  0.251395, 0.255367, 0.259211, 0.262924, 0.2665, 0.269937, 0.27323,
  0.276376, 0.279371, 0.282211, 0.284892, 0.287411, 0.289764,
  0.291947, 0.293957, 0.295789, 0.297442, 0.29891, 0.300191, 0.301281,
  0.302176, 0.302874, 0.303372, 0.303665, 0.303751, 0.303628,
  0.303291, 0.302738, 0.301967, 0.300974, 0.299757, 0.298314,
  0.296642, 0.294739, 0.292603, 0.290231, 0.287623, 0.284775,
  0.281687, 0.278357, 0.274784, 0.270966, 0.266902, 0.262592,
  0.258035, 0.25323, 0.248177, 0.242876, 0.237327, 0.23153, 0.225486,
  0.219195, 0.212659, 0.205878, 0.198854, 0.191589, 0.184084,
  0.176342, 0.168366, 0.160157, 0.151719, 0.143056, 0.13417, 0.125067,
  0.115749, 0.106223, 0.0964928, 0.0865637, 0.0764415, 0.0661325,
  0.0556429, 0.0449798, 0.0341504, 0.0231624, 0.0120239, 0.000743643,
  -0.0106695, -0.0222059, -0.0338557, -0.0456083, -0.0574528,
  -0.0693777, -0.0813709, -0.09342, -0.105512, -0.117632, -0.129768,
  -0.141903, -0.154023, -0.166111, -0.17815, -0.190123, -0.202013,
  -0.2138, -0.225464, -0.236987, -0.248346, -0.25952, -0.270486,
  -0.281222, -0.291704, -0.301906, -0.311802, -0.321367, -0.330573,
  -0.339392, -0.347794, -0.355749, -0.363226, -0.370193, -0.376617,
  -0.382464, -0.387699, -0.392285, -0.396186, -0.399362, -0.401774,
  -0.403383, -0.404145, -0.404018, -0.402958, -0.400919, -0.397855,
  -0.393717, -0.388456, -0.382022, -0.374362, -0.365423, -0.35515,
  -0.343486, -0.330375, -0.315756, -0.299569, -0.281751, -0.262239,
  -0.240966, -0.217866, -0.192869, -0.165905, -0.136901, -0.105783,
  -0.0724754, -0.0368998, 0.00102344, 0.041376, 0.0842414, 0.129705,
  0.177856, 0.228782, 0.282575, 0.339331, 0.399144, 0.462112,
  0.528338, 0.597923, 0.670972, 0.747593, 0.827896, 0.911993, 1};
  const G4double G4NeutronHPFastLegendre::i18[3801] = {0, 0.000502977,
  0.000960668, 0.0013751, 0.00174824, 0.002082, 0.00237823,
  0.00263873, 0.00286523, 0.00305943, 0.00322295, 0.00335739,
  0.00346427, 0.00354508, 0.00360126, 0.0036342, 0.00364525,
  0.0036357, 0.00360681, 0.0035598, 0.00349584, 0.00341606,
  0.00332156, 0.00321338, 0.00309255, 0.00296005, 0.00281682,
  0.00266376, 0.00250176, 0.00233166, 0.00215426, 0.00197034,
  0.00178066, 0.00158592, 0.00138681, 0.001184, 0.000978115,
  0.000769757, 0.000559506, 0.000347914, 0.000135508, -7.72072e-05,
  -0.000289754, -0.000501675, -0.000712535, -0.000921923, -0.00112945,
  -0.00133474, -0.00153744, -0.00173723, -0.00193378, -0.00212681,
  -0.00231603, -0.0025012, -0.00268206, -0.00285838, -0.00302996,
  -0.0031966, -0.00335812, -0.00351434, -0.00366513, -0.00381032,
  -0.00394981, -0.00408347, -0.00421119, -0.0043329, -0.0044485,
  -0.00455793, -0.00466113, -0.00475804, -0.00484864, -0.00493289,
  -0.00501076, -0.00508226, -0.00514736, -0.00520608, -0.00525843,
  -0.00530443, -0.0053441, -0.00537747, -0.00540459, -0.00542549,
  -0.00544024, -0.00544889, -0.00545149, -0.00544813, -0.00543886,
  -0.00542377, -0.00540294, -0.00537645, -0.0053444, -0.00530687,
  -0.00526397, -0.00521579, -0.00516243, -0.00510401, -0.00504062,
  -0.00497239, -0.00489943, -0.00482185, -0.00473977, -0.0046533,
  -0.00456258, -0.00446772, -0.00436885, -0.00426609, -0.00415957,
  -0.00404942, -0.00393576, -0.00381873, -0.00369845, -0.00357505,
  -0.00344867, -0.00331944, -0.00318748, -0.00305292, -0.0029159,
  -0.00277655, -0.002635, -0.00249137, -0.00234579, -0.0021984,
  -0.00204932, -0.00189868, -0.0017466, -0.00159321, -0.00143864,
  -0.001283, -0.00112643, -0.000969028, -0.000810931, -0.000652252,
  -0.00049311, -0.000333619, -0.000173894, -1.40474e-05, 0.000145808,
  0.000305564, 0.000465112, 0.000624345, 0.000783158, 0.000941449,
  0.00109912, 0.00125606, 0.00141218, 0.00156738, 0.00172158,
  0.00187467, 0.00202656, 0.00217718, 0.00232642, 0.00247421,
  0.00262047, 0.00276511, 0.00290805, 0.00304923, 0.00318856,
  0.00332597, 0.00346139, 0.00359475, 0.00372599, 0.00385504,
  0.00398185, 0.00410634, 0.00422846, 0.00434816, 0.00446538,
  0.00458007, 0.00469217, 0.00480165, 0.00490845, 0.00501253,
  0.00511384, 0.00521236, 0.00530803, 0.00540083, 0.00549071,
  0.00557766, 0.00566162, 0.00574259, 0.00582052, 0.0058954,
  0.0059672, 0.0060359, 0.00610148, 0.00616393, 0.00622322,
  0.00627935, 0.0063323, 0.00638206, 0.00642862, 0.00647198,
  0.00651213, 0.00654906, 0.00658277, 0.00661327, 0.00664055,
  0.00666461, 0.00668546, 0.00670311, 0.00671756, 0.00672881,
  0.00673689, 0.0067418, 0.00674354, 0.00674215, 0.00673762,
  0.00672999, 0.00671926, 0.00670545, 0.00668859, 0.00666869,
  0.00664578, 0.00661989, 0.00659103, 0.00655923, 0.00652452,
  0.00648693, 0.00644649, 0.00640322, 0.00635717, 0.00630835,
  0.0062568, 0.00620256, 0.00614566, 0.00608614, 0.00602402,
  0.00595936, 0.00589219, 0.00582254, 0.00575045, 0.00567597,
  0.00559914, 0.00551999, 0.00543857, 0.00535493, 0.00526909,
  0.00518112, 0.00509104, 0.00499891, 0.00490478, 0.00480868,
  0.00471066, 0.00461077, 0.00450906, 0.00440556, 0.00430034,
  0.00419344, 0.0040849, 0.00397478, 0.00386312, 0.00374997,
  0.00363538, 0.0035194, 0.00340208, 0.00328347, 0.00316361,
  0.00304257, 0.00292038, 0.00279709, 0.00267277, 0.00254745,
  0.00242118, 0.00229403, 0.00216603, 0.00203724, 0.0019077,
  0.00177747, 0.00164659, 0.00151512, 0.00138311, 0.00125059,
  0.00111763, 0.000984275, 0.000850567, 0.000716558, 0.000582296,
  0.00044783, 0.000313206, 0.000178473, 4.36775e-05, -9.11331e-05,
  -0.000225912, -0.000360613, -0.000495191, -0.000629599,
  -0.000763792, -0.000897725, -0.00103135, -0.00116463, -0.00129752,
  -0.00142997, -0.00156195, -0.0016934, -0.00182429, -0.00195457,
  -0.0020842, -0.00221315, -0.00234138, -0.00246883, -0.00259548,
  -0.00272128, -0.0028462, -0.0029702, -0.00309324, -0.00321528,
  -0.00333629, -0.00345624, -0.00357508, -0.00369279, -0.00380932,
  -0.00392466, -0.00403875, -0.00415158, -0.0042631, -0.00437329,
  -0.00448212, -0.00458956, -0.00469558, -0.00480015, -0.00490323,
  -0.00500482, -0.00510487, -0.00520336, -0.00530026, -0.00539556,
  -0.00548922, -0.00558123, -0.00567155, -0.00576018, -0.00584707,
  -0.00593222, -0.00601561, -0.0060972, -0.006177, -0.00625496,
  -0.00633109, -0.00640535, -0.00647774, -0.00654823, -0.00661681,
  -0.00668347, -0.0067482, -0.00681097, -0.00687178, -0.00693061,
  -0.00698745, -0.00704229, -0.00709512, -0.00714594, -0.00719472,
  -0.00724147, -0.00728617, -0.00732882, -0.0073694, -0.00740792,
  -0.00744437, -0.00747875, -0.00751104, -0.00754125, -0.00756937,
  -0.0075954, -0.00761934, -0.00764118, -0.00766093, -0.00767859,
  -0.00769415, -0.00770762, -0.00771899, -0.00772827, -0.00773547,
  -0.00774058, -0.00774362, -0.00774457, -0.00774345, -0.00774027,
  -0.00773503, -0.00772773, -0.00771838, -0.00770699, -0.00769357,
  -0.00767813, -0.00766067, -0.0076412, -0.00761973, -0.00759628,
  -0.00757086, -0.00754346, -0.00751412, -0.00748283, -0.00744962,
  -0.00741449, -0.00737746, -0.00733854, -0.00729774, -0.00725509,
  -0.00721059, -0.00716426, -0.00711611, -0.00706617, -0.00701445,
  -0.00696097, -0.00690574, -0.00684878, -0.00679011, -0.00672974,
  -0.0066677, -0.00660401, -0.00653868, -0.00647174, -0.0064032,
  -0.00633309, -0.00626142, -0.00618821, -0.0061135, -0.00603729,
  -0.00595961, -0.00588048, -0.00579993, -0.00571798, -0.00563464,
  -0.00554995, -0.00546392, -0.00537659, -0.00528796, -0.00519808,
  -0.00510695, -0.00501461, -0.00492107, -0.00482637, -0.00473053,
  -0.00463358, -0.00453553, -0.00443641, -0.00433626, -0.00423509,
  -0.00413293, -0.00402981, -0.00392575, -0.00382077, -0.00371492,
  -0.0036082, -0.00350065, -0.00339229, -0.00328315, -0.00317326,
  -0.00306264, -0.00295133, -0.00283934, -0.0027267, -0.00261344,
  -0.00249959, -0.00238517, -0.00227022, -0.00215475, -0.0020388,
  -0.00192239, -0.00180555, -0.0016883, -0.00157068, -0.0014527,
  -0.00133441, -0.00121581, -0.00109695, -0.000977846, -0.000858524,
  -0.000739013, -0.00061934, -0.00049953, -0.000379611, -0.000259609,
  -0.00013955, -1.94606e-05, 0.000100633, 0.000220705, 0.000340728,
  0.000460678, 0.000580529, 0.000700254, 0.000819828, 0.000939226,
  0.00105842, 0.00117739, 0.00129611, 0.00141455, 0.00153269,
  0.0016505, 0.00176797, 0.00188506, 0.00200175, 0.00211801,
  0.00223383, 0.00234918, 0.00246404, 0.00257838, 0.00269218,
  0.00280541, 0.00291806, 0.00303011, 0.00314152, 0.00325228,
  0.00336237, 0.00347176, 0.00358043, 0.00368837, 0.00379554,
  0.00390194, 0.00400753, 0.00411231, 0.00421624, 0.00431931,
  0.00442151, 0.0045228, 0.00462317, 0.00472261, 0.00482109,
  0.00491859, 0.0050151, 0.00511061, 0.00520508, 0.00529851,
  0.00539087, 0.00548216, 0.00557235, 0.00566143, 0.00574938,
  0.00583619, 0.00592184, 0.00600631, 0.00608959, 0.00617168,
  0.00625254, 0.00633217, 0.00641056, 0.00648769, 0.00656354,
  0.00663811, 0.00671138, 0.00678334, 0.00685398, 0.00692329,
  0.00699125, 0.00705786, 0.0071231, 0.00718696, 0.00724943,
  0.00731051, 0.00737018, 0.00742843, 0.00748525, 0.00754065,
  0.0075946, 0.0076471, 0.00769814, 0.00774771, 0.00779581,
  0.00784243, 0.00788756, 0.0079312, 0.00797334, 0.00801398,
  0.0080531, 0.00809071, 0.0081268, 0.00816136, 0.00819439,
  0.00822589, 0.00825586, 0.00828428, 0.00831116, 0.00833649,
  0.00836028, 0.00838251, 0.0084032, 0.00842232, 0.0084399,
  0.00845591, 0.00847037, 0.00848327, 0.00849461, 0.0085044,
  0.00851262, 0.00851929, 0.00852441, 0.00852797, 0.00852998,
  0.00853043, 0.00852934, 0.0085267, 0.00852252, 0.0085168,
  0.00850953, 0.00850074, 0.00849041, 0.00847856, 0.00846518,
  0.00845028, 0.00843388, 0.00841596, 0.00839654, 0.00837562,
  0.00835321, 0.00832932, 0.00830394, 0.00827709, 0.00824878,
  0.008219, 0.00818778, 0.0081551, 0.008121, 0.00808546, 0.0080485,
  0.00801013, 0.00797035, 0.00792918, 0.00788662, 0.00784269,
  0.00779739, 0.00775073, 0.00770272, 0.00765338, 0.0076027,
  0.00755071, 0.00749742, 0.00744283, 0.00738695, 0.0073298,
  0.00727139, 0.00721173, 0.00715083, 0.0070887, 0.00702537,
  0.00696082, 0.00689509, 0.00682819, 0.00676012, 0.0066909,
  0.00662054, 0.00654906, 0.00647647, 0.00640278, 0.00632801,
  0.00625217, 0.00617528, 0.00609735, 0.00601839, 0.00593841,
  0.00585744, 0.00577549, 0.00569258, 0.00560871, 0.0055239,
  0.00543817, 0.00535154, 0.00526401, 0.00517561, 0.00508635,
  0.00499625, 0.00490532, 0.00481358, 0.00472104, 0.00462773,
  0.00453365, 0.00443882, 0.00434327, 0.004247, 0.00415004,
  0.00405239, 0.00395408, 0.00385513, 0.00375554, 0.00365535,
  0.00355455, 0.00345318, 0.00335125, 0.00324878, 0.00314577,
  0.00304226, 0.00293826, 0.00283378, 0.00272884, 0.00262347,
  0.00251767, 0.00241147, 0.00230488, 0.00219791, 0.0020906,
  0.00198295, 0.00187499, 0.00176673, 0.00165818, 0.00154937,
  0.00144031, 0.00133103, 0.00122153, 0.00111184, 0.00100197,
  0.000891942, 0.000781775, 0.000671484, 0.000561087, 0.000450602,
  0.000340046, 0.000229436, 0.00011879, 8.12575e-06, -0.00010254,
  -0.00021319, -0.000323806, -0.000434372, -0.00054487, -0.000655283,
  -0.000765594, -0.000875787, -0.000985843, -0.00109575, -0.00120548,
  -0.00131503, -0.00142437, -0.00153349, -0.00164238, -0.00175101,
  -0.00185937, -0.00196745, -0.00207523, -0.00218268, -0.0022898,
  -0.00239657, -0.00250298, -0.002609, -0.00271462, -0.00281983,
  -0.00292461, -0.00302894, -0.00313281, -0.00323621, -0.00333911,
  -0.00344151, -0.00354339, -0.00364473, -0.00374552, -0.00384574,
  -0.00394538, -0.00404443, -0.00414287, -0.00424069, -0.00433787,
  -0.0044344, -0.00453026, -0.00462545, -0.00471994, -0.00481373,
  -0.0049068, -0.00499913, -0.00509073, -0.00518156, -0.00527162,
  -0.0053609, -0.00544938, -0.00553706, -0.00562391, -0.00570993,
  -0.00579511, -0.00587943, -0.00596289, -0.00604546, -0.00612715,
  -0.00620793, -0.0062878, -0.00636674, -0.00644476, -0.00652182,
  -0.00659794, -0.00667308, -0.00674726, -0.00682044, -0.00689263,
  -0.00696382, -0.00703399, -0.00710314, -0.00717126, -0.00723834,
  -0.00730437, -0.00736934, -0.00743324, -0.00749606, -0.00755781,
  -0.00761846, -0.00767801, -0.00773646, -0.00779379, -0.00785001,
  -0.00790509, -0.00795904, -0.00801185, -0.00806351, -0.00811402,
  -0.00816336, -0.00821154, -0.00825855, -0.00830438, -0.00834902,
  -0.00839248, -0.00843474, -0.00847581, -0.00851567, -0.00855432,
  -0.00859176, -0.00862799, -0.00866299, -0.00869677, -0.00872932,
  -0.00876064, -0.00879073, -0.00881958, -0.00884718, -0.00887355,
  -0.00889866, -0.00892253, -0.00894515, -0.00896651, -0.00898662,
  -0.00900547, -0.00902307, -0.0090394, -0.00905447, -0.00906829,
  -0.00908084, -0.00909212, -0.00910215, -0.00911091, -0.0091184,
  -0.00912463, -0.0091296, -0.0091333, -0.00913575, -0.00913693,
  -0.00913684, -0.0091355, -0.0091329, -0.00912905, -0.00912393,
  -0.00911757, -0.00910995, -0.00910108, -0.00909096, -0.0090796,
  -0.009067, -0.00905315, -0.00903807, -0.00902176, -0.00900422,
  -0.00898544, -0.00896545, -0.00894423, -0.0089218, -0.00889816,
  -0.00887331, -0.00884726, -0.00882001, -0.00879156, -0.00876193,
  -0.00873111, -0.00869911, -0.00866594, -0.0086316, -0.0085961,
  -0.00855944, -0.00852162, -0.00848267, -0.00844257, -0.00840135,
  -0.00835899, -0.00831552, -0.00827093, -0.00822524, -0.00817845,
  -0.00813056, -0.0080816, -0.00803155, -0.00798043, -0.00792826,
  -0.00787502, -0.00782075, -0.00776543, -0.00770908, -0.00765171,
  -0.00759333, -0.00753394, -0.00747356, -0.00741219, -0.00734984,
  -0.00728652, -0.00722224, -0.00715701, -0.00709083, -0.00702372,
  -0.00695569, -0.00688675, -0.0068169, -0.00674616, -0.00667454,
  -0.00660204, -0.00652867, -0.00645446, -0.0063794, -0.0063035,
  -0.00622679, -0.00614926, -0.00607094, -0.00599182, -0.00591192,
  -0.00583126, -0.00574984, -0.00566767, -0.00558477, -0.00550114,
  -0.0054168, -0.00533177, -0.00524604, -0.00515963, -0.00507256,
  -0.00498483, -0.00489647, -0.00480747, -0.00471785, -0.00462763,
  -0.00453681, -0.00444541, -0.00435343, -0.0042609, -0.00416783,
  -0.00407422, -0.00398009, -0.00388545, -0.00379031, -0.00369469,
  -0.0035986, -0.00350205, -0.00340505, -0.00330762, -0.00320977,
  -0.00311151, -0.00301286, -0.00291382, -0.00281442, -0.00271466,
  -0.00261455, -0.00251411, -0.00241336, -0.0023123, -0.00221094,
  -0.00210931, -0.00200741, -0.00190526, -0.00180287, -0.00170026,
  -0.00159742, -0.00149439, -0.00139117, -0.00128778, -0.00118422,
  -0.00108052, -0.000976679, -0.000872717, -0.000768645, -0.000664478,
  -0.000560228, -0.000455908, -0.000351531, -0.00024711, -0.000142659,
  -3.81894e-05, 6.62847e-05, 0.00017075, 0.000275195, 0.000379605,
  0.000483969, 0.000588272, 0.000692502, 0.000796647, 0.000900693,
  0.00100463, 0.00110844, 0.00121211, 0.00131563, 0.001419,
  0.00152218, 0.00162518, 0.00172798, 0.00183057, 0.00193293,
  0.00203505, 0.00213693, 0.00223854, 0.00233988, 0.00244093,
  0.00254168, 0.00264212, 0.00274224, 0.00284202, 0.00294145,
  0.00304053, 0.00313924, 0.00323756, 0.00333549, 0.00343301,
  0.00353011, 0.00362679, 0.00372302, 0.0038188, 0.00391412,
  0.00400897, 0.00410332, 0.00419719, 0.00429054, 0.00438337,
  0.00447568, 0.00456744, 0.00465865, 0.0047493, 0.00483937,
  0.00492887, 0.00501777, 0.00510606, 0.00519374, 0.0052808,
  0.00536722, 0.005453, 0.00553812, 0.00562258, 0.00570636,
  0.00578946, 0.00587187, 0.00595358, 0.00603457, 0.00611484,
  0.00619438, 0.00627318, 0.00635124, 0.00642853, 0.00650507,
  0.00658082, 0.00665579, 0.00672998, 0.00680336, 0.00687593,
  0.00694769, 0.00701862, 0.00708872, 0.00715798, 0.00722639,
  0.00729395, 0.00736064, 0.00742647, 0.00749141, 0.00755548,
  0.00761865, 0.00768092, 0.00774228, 0.00780274, 0.00786227,
  0.00792088, 0.00797856, 0.0080353, 0.00809109, 0.00814594,
  0.00819983, 0.00825276, 0.00830472, 0.00835571, 0.00840572,
  0.00845474, 0.00850278, 0.00854982, 0.00859587, 0.00864091,
  0.00868494, 0.00872796, 0.00876996, 0.00881095, 0.0088509,
  0.00888983, 0.00892772, 0.00896457, 0.00900039, 0.00903515,
  0.00906887, 0.00910154, 0.00913316, 0.00916371, 0.0091932,
  0.00922163, 0.009249, 0.00927529, 0.00930052, 0.00932466,
  0.00934774, 0.00936973, 0.00939065, 0.00941048, 0.00942923,
  0.00944689, 0.00946347, 0.00947896, 0.00949336, 0.00950667,
  0.00951889, 0.00953002, 0.00954005, 0.00954899, 0.00955684,
  0.00956359, 0.00956925, 0.00957381, 0.00957728, 0.00957966,
  0.00958094, 0.00958113, 0.00958023, 0.00957823, 0.00957514,
  0.00957097, 0.0095657, 0.00955934, 0.0095519, 0.00954337,
  0.00953376, 0.00952307, 0.00951129, 0.00949844, 0.00948451,
  0.0094695, 0.00945343, 0.00943628, 0.00941806, 0.00939879,
  0.00937844, 0.00935704, 0.00933459, 0.00931107, 0.00928651,
  0.00926091, 0.00923426, 0.00920657, 0.00917784, 0.00914808,
  0.00911729, 0.00908548, 0.00905264, 0.00901879, 0.00898393,
  0.00894806, 0.00891119, 0.00887332, 0.00883445, 0.0087946,
  0.00875376, 0.00871194, 0.00866915, 0.00862539, 0.00858067,
  0.00853499, 0.00848835, 0.00844077, 0.00839225, 0.0083428,
  0.00829241, 0.0082411, 0.00818888, 0.00813574, 0.0080817,
  0.00802677, 0.00797094, 0.00791423, 0.00785663, 0.00779817,
  0.00773885, 0.00767866, 0.00761763, 0.00755575, 0.00749304,
  0.0074295, 0.00736513, 0.00729996, 0.00723398, 0.00716719,
  0.00709962, 0.00703127, 0.00696214, 0.00689224, 0.00682159,
  0.00675018, 0.00667803, 0.00660515, 0.00653154, 0.00645722,
  0.00638218, 0.00630645, 0.00623002, 0.00615291, 0.00607512,
  0.00599667, 0.00591756, 0.00583781, 0.00575741, 0.00567639,
  0.00559474, 0.00551249, 0.00542963, 0.00534618, 0.00526214,
  0.00517753, 0.00509236, 0.00500663, 0.00492036, 0.00483355,
  0.00474621, 0.00465836, 0.00457, 0.00448115, 0.00439181, 0.00430199,
  0.0042117, 0.00412096, 0.00402977, 0.00393814, 0.00384609,
  0.00375362, 0.00366074, 0.00356747, 0.00347381, 0.00337977,
  0.00328537, 0.00319062, 0.00309552, 0.00300008, 0.00290433,
  0.00280825, 0.00271188, 0.00261521, 0.00251827, 0.00242105,
  0.00232357, 0.00222584, 0.00212787, 0.00202967, 0.00193125,
  0.00183263, 0.00173381, 0.0016348, 0.00153562, 0.00143627,
  0.00133677, 0.00123713, 0.00113735, 0.00103745, 0.000937445,
  0.000837335, 0.000737136, 0.000636858, 0.000536512, 0.000436108,
  0.000335658, 0.000235172, 0.000134661, 3.4136e-05, -6.63931e-05,
  -0.000166915, -0.000267419, -0.000367895, -0.000468332,
  -0.000568718, -0.000669045, -0.0007693, -0.000869473, -0.000969554,
  -0.00106953, -0.0011694, -0.00126914, -0.00136874, -0.0014682,
  -0.00156751, -0.00166665, -0.00176561, -0.00186439, -0.00196297,
  -0.00206134, -0.00215949, -0.00225741, -0.0023551, -0.00245254,
  -0.00254972, -0.00264663, -0.00274326, -0.0028396, -0.00293564,
  -0.00303137, -0.00312678, -0.00322187, -0.00331661, -0.00341101,
  -0.00350504, -0.00359871, -0.003692, -0.0037849, -0.00387741,
  -0.00396951, -0.00406119, -0.00415244, -0.00424326, -0.00433363,
  -0.00442355, -0.00451301, -0.00460199, -0.0046905, -0.00477851,
  -0.00486602, -0.00495302, -0.00503951, -0.00512546, -0.00521089,
  -0.00529577, -0.00538009, -0.00546385, -0.00554705, -0.00562966,
  -0.00571169, -0.00579313, -0.00587396, -0.00595417, -0.00603377,
  -0.00611274, -0.00619108, -0.00626877, -0.00634581, -0.00642219,
  -0.0064979, -0.00657294, -0.00664729, -0.00672096, -0.00679393,
  -0.00686619, -0.00693774, -0.00700857, -0.00707868, -0.00714805,
  -0.00721669, -0.00728457, -0.0073517, -0.00741808, -0.00748368,
  -0.00754851, -0.00761256, -0.00767583, -0.0077383, -0.00779998,
  -0.00786084, -0.0079209, -0.00798014, -0.00803856, -0.00809615,
  -0.00815291, -0.00820882, -0.00826389, -0.00831811, -0.00837148,
  -0.00842398, -0.00847562, -0.00852638, -0.00857627, -0.00862528,
  -0.00867341, -0.00872064, -0.00876698, -0.00881241, -0.00885695,
  -0.00890057, -0.00894329, -0.00898509, -0.00902596, -0.00906591,
  -0.00910494, -0.00914303, -0.00918019, -0.00921641, -0.00925168,
  -0.00928601, -0.0093194, -0.00935182, -0.0093833, -0.00941382,
  -0.00944337, -0.00947196, -0.00949959, -0.00952625, -0.00955193,
  -0.00957665, -0.00960038, -0.00962314, -0.00964492, -0.00966572,
  -0.00968554, -0.00970437, -0.00972221, -0.00973906, -0.00975493,
  -0.0097698, -0.00978368, -0.00979657, -0.00980846, -0.00981936,
  -0.00982926, -0.00983816, -0.00984607, -0.00985298, -0.00985889,
  -0.0098638, -0.00986771, -0.00987063, -0.00987254, -0.00987346,
  -0.00987337, -0.00987229, -0.00987021, -0.00986713, -0.00986306,
  -0.00985798, -0.00985192, -0.00984486, -0.0098368, -0.00982775,
  -0.00981771, -0.00980668, -0.00979466, -0.00978166, -0.00976767,
  -0.00975269, -0.00973673, -0.00971979, -0.00970188, -0.00968299,
  -0.00966312, -0.00964228, -0.00962047, -0.00959769, -0.00957395,
  -0.00954925, -0.00952359, -0.00949697, -0.0094694, -0.00944088,
  -0.00941141, -0.009381, -0.00934965, -0.00931735, -0.00928413,
  -0.00924997, -0.00921489, -0.00917889, -0.00914196, -0.00910413,
  -0.00906538, -0.00902572, -0.00898516, -0.0089437, -0.00890135,
  -0.0088581, -0.00881398, -0.00876897, -0.00872309, -0.00867633,
  -0.00862871, -0.00858023, -0.00853089, -0.0084807, -0.00842967,
  -0.00837779, -0.00832508, -0.00827154, -0.00821718, -0.00816199,
  -0.008106, -0.0080492, -0.00799159, -0.0079332, -0.00787401,
  -0.00781404, -0.00775329, -0.00769177, -0.00762949, -0.00756645,
  -0.00750266, -0.00743812, -0.00737284, -0.00730683, -0.0072401,
  -0.00717265, -0.00710449, -0.00703562, -0.00696605, -0.0068958,
  -0.00682486, -0.00675324, -0.00668096, -0.00660801, -0.00653441,
  -0.00646016, -0.00638528, -0.00630976, -0.00623362, -0.00615686,
  -0.00607949, -0.00600152, -0.00592296, -0.00584381, -0.00576409,
  -0.00568379, -0.00560294, -0.00552153, -0.00543958, -0.00535709,
  -0.00527407, -0.00519053, -0.00510648, -0.00502192, -0.00493687,
  -0.00485134, -0.00476532, -0.00467884, -0.0045919, -0.0045045,
  -0.00441666, -0.00432839, -0.00423969, -0.00415057, -0.00406104,
  -0.00397112, -0.0038808, -0.00379011, -0.00369904, -0.0036076,
  -0.00351582, -0.00342368, -0.00333121, -0.00323842, -0.00314531,
  -0.00305188, -0.00295816, -0.00286415, -0.00276986, -0.00267529,
  -0.00258046, -0.00248538, -0.00239006, -0.0022945, -0.00219872,
  -0.00210272, -0.00200652, -0.00191012, -0.00181353, -0.00171677,
  -0.00161984, -0.00152274, -0.0014255, -0.00132813, -0.00123062,
  -0.00113299, -0.00103525, -0.000937405, -0.000839473, -0.000741458,
  -0.00064337, -0.00054522, -0.000447017, -0.00034877, -0.000250489,
  -0.000152184, -5.38636e-05, 4.44618e-05, 0.000142783, 0.00024109,
  0.000339374, 0.000437624, 0.000535832, 0.000633988, 0.000732082,
  0.000830104, 0.000928046, 0.0010259, 0.00112365, 0.00122129,
  0.00131881, 0.00141621, 0.00151347, 0.00161058, 0.00170753,
  0.00180432, 0.00190093, 0.00199736, 0.00209359, 0.00218962,
  0.00228544, 0.00238103, 0.00247639, 0.00257152, 0.00266639,
  0.00276101, 0.00285535, 0.00294942, 0.00304321, 0.00313669,
  0.00322988, 0.00332275, 0.0034153, 0.00350752, 0.00359939,
  0.00369092, 0.00378209, 0.0038729, 0.00396333, 0.00405338,
  0.00414303, 0.00423228, 0.00432113, 0.00440955, 0.00449755,
  0.00458511, 0.00467223, 0.0047589, 0.0048451, 0.00493084,
  0.00501611, 0.00510088, 0.00518517, 0.00526895, 0.00535222,
  0.00543498, 0.00551721, 0.00559891, 0.00568007, 0.00576068,
  0.00584074, 0.00592023, 0.00599915, 0.00607749, 0.00615524,
  0.0062324, 0.00630896, 0.00638491, 0.00646024, 0.00653496,
  0.00660904, 0.00668248, 0.00675529, 0.00682744, 0.00689893,
  0.00696976, 0.00703991, 0.00710939, 0.00717819, 0.00724629,
  0.0073137, 0.0073804, 0.00744639, 0.00751166, 0.00757622,
  0.00764004, 0.00770313, 0.00776548, 0.00782708, 0.00788793,
  0.00794802, 0.00800734, 0.0080659, 0.00812368, 0.00818068,
  0.0082369, 0.00829232, 0.00834695, 0.00840077, 0.00845379, 0.008506,
  0.00855739, 0.00860796, 0.00865771, 0.00870662, 0.00875469,
  0.00880193, 0.00884832, 0.00889387, 0.00893856, 0.00898239,
  0.00902537, 0.00906747, 0.00910871, 0.00914908, 0.00918856,
  0.00922717, 0.00926489, 0.00930173, 0.00933767, 0.00937272,
  0.00940688, 0.00944013, 0.00947248, 0.00950392, 0.00953445,
  0.00956406, 0.00959277, 0.00962055, 0.00964742, 0.00967336,
  0.00969837, 0.00972246, 0.00974562, 0.00976784, 0.00978913,
  0.00980949, 0.00982891, 0.00984738, 0.00986492, 0.00988151,
  0.00989716, 0.00991186, 0.00992562, 0.00993843, 0.00995029,
  0.00996119, 0.00997115, 0.00998015, 0.0099882, 0.0099953, 0.0100014,
  0.0100066, 0.0100109, 0.0100141, 0.0100165, 0.0100178, 0.0100182,
  0.0100177, 0.0100162, 0.0100137, 0.0100103, 0.0100059, 0.0100006,
  0.00999434, 0.00998711, 0.00997893, 0.00996979, 0.00995971,
  0.00994868, 0.00993669, 0.00992376, 0.00990989, 0.00989507,
  0.00987931, 0.0098626, 0.00984496, 0.00982638, 0.00980686,
  0.00978641, 0.00976502, 0.00974271, 0.00971947, 0.0096953,
  0.00967021, 0.0096442, 0.00961727, 0.00958943, 0.00956067, 0.009531,
  0.00950043, 0.00946895, 0.00943657, 0.00940329, 0.00936912,
  0.00933405, 0.0092981, 0.00926126, 0.00922355, 0.00918495,
  0.00914548, 0.00910515, 0.00906394, 0.00902188, 0.00897895,
  0.00893517, 0.00889055, 0.00884507, 0.00879876, 0.00875161,
  0.00870363, 0.00865482, 0.00860519, 0.00855474, 0.00850348,
  0.00845141, 0.00839854, 0.00834487, 0.0082904, 0.00823515,
  0.00817912, 0.00812231, 0.00806473, 0.00800638, 0.00794727,
  0.00788741, 0.0078268, 0.00776544, 0.00770335, 0.00764052,
  0.00757697, 0.0075127, 0.00744772, 0.00738203, 0.00731564,
  0.00724856, 0.00718079, 0.00711233, 0.0070432, 0.00697341,
  0.00690295, 0.00683183, 0.00676007, 0.00668767, 0.00661463,
  0.00654096, 0.00646667, 0.00639177, 0.00631627, 0.00624016,
  0.00616346, 0.00608618, 0.00600832, 0.00592989, 0.0058509,
  0.00577135, 0.00569126, 0.00561062, 0.00552946, 0.00544777,
  0.00536556, 0.00528284, 0.00519963, 0.00511592, 0.00503172,
  0.00494705, 0.00486191, 0.0047763, 0.00469025, 0.00460375,
  0.00451681, 0.00442945, 0.00434166, 0.00425347, 0.00416487,
  0.00407588, 0.0039865, 0.00389674, 0.00380661, 0.00371612,
  0.00362528, 0.0035341, 0.00344258, 0.00335073, 0.00325857,
  0.0031661, 0.00307333, 0.00298026, 0.00288692, 0.0027933,
  0.00269942, 0.00260528, 0.00251089, 0.00241627, 0.00232141,
  0.00222634, 0.00213106, 0.00203557, 0.00193989, 0.00184403,
  0.00174799, 0.00165179, 0.00155543, 0.00145892, 0.00136228,
  0.0012655, 0.00116861, 0.0010716, 0.000974497, 0.000877299,
  0.000780017, 0.000682661, 0.00058524, 0.000487765, 0.000390242,
  0.000292683, 0.000195097, 9.74912e-05, -1.23355e-07, -9.77379e-05,
  -0.000195343, -0.00029293, -0.000390489, -0.000488011, -0.000585487,
  -0.000682908, -0.000780263, -0.000877545, -0.000974744, -0.00107185,
  -0.00116886, -0.00126575, -0.00136252, -0.00145917, -0.00155568,
  -0.00165204, -0.00174824, -0.00184428, -0.00194014, -0.00203582,
  -0.0021313, -0.00222659, -0.00232166, -0.00241651, -0.00251114,
  -0.00260552, -0.00269966, -0.00279355, -0.00288717, -0.00298051,
  -0.00307357, -0.00316635, -0.00325882, -0.00335098, -0.00344282,
  -0.00353434, -0.00362553, -0.00371637, -0.00380686, -0.00389698,
  -0.00398674, -0.00407612, -0.00416512, -0.00425372, -0.00434191,
  -0.0044297, -0.00451706, -0.004604, -0.0046905, -0.00477655,
  -0.00486215, -0.00494729, -0.00503197, -0.00511616, -0.00519987,
  -0.00528309, -0.00536581, -0.00544801, -0.0055297, -0.00561087,
  -0.0056915, -0.0057716, -0.00585115, -0.00593014, -0.00600857,
  -0.00608643, -0.00616371, -0.00624041, -0.00631651, -0.00639202,
  -0.00646692, -0.00654121, -0.00661487, -0.00668791, -0.00676032,
  -0.00683208, -0.00690319, -0.00697365, -0.00704345, -0.00711258,
  -0.00718103, -0.00724881, -0.00731589, -0.00738228, -0.00744797,
  -0.00751295, -0.00757722, -0.00764077, -0.00770359, -0.00776569,
  -0.00782704, -0.00788765, -0.00794752, -0.00800663, -0.00806497,
  -0.00812256, -0.00817937, -0.0082354, -0.00829065, -0.00834511,
  -0.00839879, -0.00845166, -0.00850373, -0.00855499, -0.00860544,
  -0.00865507, -0.00870388, -0.00875186, -0.00879901, -0.00884532,
  -0.00889079, -0.00893542, -0.0089792, -0.00902212, -0.00906419,
  -0.00910539, -0.00914573, -0.0091852, -0.00922379, -0.00926151,
  -0.00929835, -0.0093343, -0.00936936, -0.00940354, -0.00943681,
  -0.00946919, -0.00950067, -0.00953125, -0.00956092, -0.00958967,
  -0.00961752, -0.00964445, -0.00967046, -0.00969555, -0.00971972,
  -0.00974296, -0.00976527, -0.00978665, -0.00980711, -0.00982662,
  -0.00984521, -0.00986285, -0.00987955, -0.00989532, -0.00991014,
  -0.00992401, -0.00993694, -0.00994892, -0.00995996, -0.00997004,
  -0.00997917, -0.00998736, -0.00999459, -0.0100009, -0.0100062,
  -0.0100106, -0.010014, -0.0100164, -0.0100179, -0.0100185,
  -0.0100181, -0.0100167, -0.0100144, -0.0100111, -0.0100069,
  -0.0100017, -0.00999555, -0.00998845, -0.0099804, -0.0099714,
  -0.00996144, -0.00995053, -0.00993867, -0.00992587, -0.00991211,
  -0.00989741, -0.00988176, -0.00986517, -0.00984763, -0.00982915,
  -0.00980974, -0.00978938, -0.00976809, -0.00974586, -0.00972271,
  -0.00969862, -0.0096736, -0.00964766, -0.0096208, -0.00959301,
  -0.00956431, -0.00953469, -0.00950416, -0.00947272, -0.00944037,
  -0.00940712, -0.00937297, -0.00933792, -0.00930198, -0.00926514,
  -0.00922742, -0.00918881, -0.00914932, -0.00910896, -0.00906772,
  -0.00902561, -0.00898264, -0.00893881, -0.00889411, -0.00884857,
  -0.00880218, -0.00875494, -0.00870686, -0.00865795, -0.00860821,
  -0.00855764, -0.00850625, -0.00845404, -0.00840102, -0.0083472,
  -0.00829257, -0.00823714, -0.00818093, -0.00812393, -0.00806615,
  -0.00800759, -0.00794826, -0.00788817, -0.00782732, -0.00776572,
  -0.00770338, -0.00764029, -0.00757646, -0.00751191, -0.00744664,
  -0.00738064, -0.00731394, -0.00724654, -0.00717843, -0.00710964,
  -0.00704016, -0.00697, -0.00689917, -0.00682768, -0.00675553,
  -0.00668273, -0.00660929, -0.0065352, -0.00646049, -0.00638516,
  -0.00630921, -0.00623265, -0.00615549, -0.00607773, -0.00599939,
  -0.00592047, -0.00584098, -0.00576093, -0.00568032, -0.00559916,
  -0.00551746, -0.00543523, -0.00535247, -0.0052692, -0.00518541,
  -0.00510113, -0.00501635, -0.00493109, -0.00484535, -0.00475914,
  -0.00467248, -0.00458536, -0.00449779, -0.0044098, -0.00432137,
  -0.00423253, -0.00414328, -0.00405362, -0.00396358, -0.00387315,
  -0.00378234, -0.00369117, -0.00359964, -0.00350776, -0.00341555,
  -0.003323, -0.00323013, -0.00313694, -0.00304345, -0.00294967,
  -0.0028556, -0.00276125, -0.00266664, -0.00257176, -0.00247664,
  -0.00238128, -0.00228568, -0.00218987, -0.00209384, -0.0019976,
  -0.00190118, -0.00180456, -0.00170778, -0.00161082, -0.00151371,
  -0.00141646, -0.00131906, -0.00122154, -0.0011239, -0.00102614,
  -0.000928293, -0.000830351, -0.000732328, -0.000634235,
  -0.000536079, -0.000437871, -0.00033962, -0.000241337, -0.00014303,
  -4.47085e-05, 5.36169e-05, 0.000151937, 0.000250242, 0.000348523,
  0.00044677, 0.000544974, 0.000643124, 0.000741211, 0.000839226,
  0.000937159, 0.001035, 0.00113274, 0.00123037, 0.00132788,
  0.00142526, 0.0015225, 0.00161959, 0.00171652, 0.00181329,
  0.00190987, 0.00200627, 0.00210248, 0.00219847, 0.00229426,
  0.00238981, 0.00248514, 0.00258022, 0.00267504, 0.00276961,
  0.0028639, 0.00295791, 0.00305164, 0.00314506, 0.00323817,
  0.00333097, 0.00342344, 0.00351557, 0.00360736, 0.00369879,
  0.00378986, 0.00388056, 0.00397087, 0.0040608, 0.00415032,
  0.00423944, 0.00432814, 0.00441641, 0.00450425, 0.00459165,
  0.00467859, 0.00476508, 0.00485109, 0.00493663, 0.00502168,
  0.00510623, 0.00519028, 0.00527382, 0.00535684, 0.00543933,
  0.00552128, 0.00560269, 0.00568355, 0.00576384, 0.00584356,
  0.00592271, 0.00600127, 0.00607924, 0.00615661, 0.00623337,
  0.00630951, 0.00638503, 0.00645992, 0.00653416, 0.00660776,
  0.00668071, 0.00675299, 0.00682461, 0.00689555, 0.00696581,
  0.00703537, 0.00710424, 0.0071724, 0.00723985, 0.00730659,
  0.00737259, 0.00743787, 0.00750241, 0.0075662, 0.00762924,
  0.00769152, 0.00775304, 0.00781379, 0.00787376, 0.00793295,
  0.00799135, 0.00804895, 0.00810575, 0.00816175, 0.00821693,
  0.00827129, 0.00832483, 0.00837754, 0.00842942, 0.00848045,
  0.00853064, 0.00857998, 0.00862846, 0.00867608, 0.00872284,
  0.00876872, 0.00881373, 0.00885786, 0.0089011, 0.00894345,
  0.00898491, 0.00902547, 0.00906513, 0.00910388, 0.00914172,
  0.00917864, 0.00921465, 0.00924973, 0.00928388, 0.00931711,
  0.0093494, 0.00938075, 0.00941117, 0.00944063, 0.00946916,
  0.00949673, 0.00952334, 0.00954901, 0.00957371, 0.00959745,
  0.00962022, 0.00964203, 0.00966287, 0.00968274, 0.00970163,
  0.00971955, 0.00973649, 0.00975244, 0.00976742, 0.00978141,
  0.00979442, 0.00980644, 0.00981747, 0.0098275, 0.00983655,
  0.00984461, 0.00985167, 0.00985774, 0.00986281, 0.00986688,
  0.00986996, 0.00987204, 0.00987313, 0.00987321, 0.00987229,
  0.00987038, 0.00986747, 0.00986355, 0.00985864, 0.00985273,
  0.00984582, 0.00983792, 0.00982901, 0.00981911, 0.00980821,
  0.00979632, 0.00978343, 0.00976955, 0.00975468, 0.00973882,
  0.00972196, 0.00970412, 0.00968529, 0.00966547, 0.00964468,
  0.0096229, 0.00960014, 0.0095764, 0.00955169, 0.009526, 0.00949934,
  0.00947172, 0.00944312, 0.00941357, 0.00938305, 0.00935158,
  0.00931915, 0.00928577, 0.00925144, 0.00921616, 0.00917994,
  0.00914279, 0.00910469, 0.00906567, 0.00902572, 0.00898484,
  0.00894304, 0.00890033, 0.0088567, 0.00881217, 0.00876673,
  0.00872039, 0.00867316, 0.00862504, 0.00857603, 0.00852614,
  0.00847537, 0.00842373, 0.00837123, 0.00831787, 0.00826365,
  0.00820858, 0.00815266, 0.0080959, 0.00803831, 0.0079799,
  0.00792065, 0.0078606, 0.00779973, 0.00773805, 0.00767558,
  0.00761232, 0.00754827, 0.00748343, 0.00741783, 0.00735146,
  0.00728432, 0.00721644, 0.00714781, 0.00707843, 0.00700833,
  0.00693749, 0.00686594, 0.00679368, 0.00672071, 0.00664705,
  0.00657269, 0.00649765, 0.00642194, 0.00634556, 0.00626852,
  0.00619083, 0.0061125, 0.00603353, 0.00595393, 0.00587371,
  0.00579288, 0.00571145, 0.00562942, 0.0055468, 0.00546361,
  0.00537984, 0.00529552, 0.00521064, 0.00512522, 0.00503926,
  0.00495277, 0.00486577, 0.00477826, 0.00469025, 0.00460175,
  0.00451276, 0.00442331, 0.00433339, 0.00424301, 0.00415219,
  0.00406094, 0.00396926, 0.00387716, 0.00378466, 0.00369176,
  0.00359847, 0.0035048, 0.00341076, 0.00331637, 0.00322162,
  0.00312654, 0.00303112, 0.00293539, 0.00283935, 0.00274301,
  0.00264638, 0.00254947, 0.00245229, 0.00235485, 0.00225717,
  0.00215924, 0.00206109, 0.00196272, 0.00186414, 0.00176537,
  0.0016664, 0.00156726, 0.00146796, 0.0013685, 0.00126889,
  0.00116915, 0.00106929, 0.000969308, 0.000869227, 0.000769053,
  0.000668798, 0.000568472, 0.000468085, 0.000367648, 0.000267173,
  0.000166668, 6.61463e-05, -3.43827e-05, -0.000134908, -0.000235419,
  -0.000335905, -0.000436355, -0.000536758, -0.000637105,
  -0.000737383, -0.000837582, -0.000937692, -0.0010377, -0.0011376,
  -0.00123738, -0.00133702, -0.00143652, -0.00153587, -0.00163505,
  -0.00173406, -0.00183288, -0.0019315, -0.00202992, -0.00212811,
  -0.00222608, -0.00232381, -0.00242129, -0.00251851, -0.00261546,
  -0.00271213, -0.0028085, -0.00290457, -0.00300033, -0.00309576,
  -0.00319086, -0.00328562, -0.00338002, -0.00347405, -0.00356771,
  -0.00366099, -0.00375386, -0.00384633, -0.00393839, -0.00403001,
  -0.0041212, -0.00421195, -0.00430223, -0.00439205, -0.0044814,
  -0.00457025, -0.00465861, -0.00474646, -0.0048338, -0.00492061,
  -0.00500688, -0.00509261, -0.00517778, -0.00526239, -0.00534642,
  -0.00542987, -0.00551273, -0.00559499, -0.00567663, -0.00575766,
  -0.00583805, -0.00591781, -0.00599692, -0.00607537, -0.00615315,
  -0.00623026, -0.00630669, -0.00638243, -0.00645746, -0.00653179,
  -0.0066054, -0.00667828, -0.00675043, -0.00682184, -0.00689249,
  -0.00696239, -0.00703152, -0.00709987, -0.00716744, -0.00723422,
  -0.0073002, -0.00736538, -0.00742974, -0.00749328, -0.007556,
  -0.00761787, -0.00767891, -0.00773909, -0.00779842, -0.00785688,
  -0.00791447, -0.00797119, -0.00802701, -0.00808195, -0.00813599,
  -0.00818913, -0.00824135, -0.00829266, -0.00834304, -0.0083925,
  -0.00844102, -0.0084886, -0.00853523, -0.00858091, -0.00862564,
  -0.0086694, -0.00871219, -0.00875401, -0.00879484, -0.0088347,
  -0.00887356, -0.00891144, -0.00894831, -0.00898418, -0.00901904,
  -0.00905289, -0.00908572, -0.00911754, -0.00914833, -0.00917808,
  -0.00920681, -0.0092345, -0.00926115, -0.00928676, -0.00931132,
  -0.00933483, -0.00935729, -0.00937869, -0.00939903, -0.00941831,
  -0.00943653, -0.00945367, -0.00946975, -0.00948475, -0.00949868,
  -0.00951154, -0.00952331, -0.00953401, -0.00954362, -0.00955215,
  -0.00955959, -0.00956594, -0.00957121, -0.00957539, -0.00957848,
  -0.00958047, -0.00958138, -0.00958119, -0.00957991, -0.00957753,
  -0.00957406, -0.0095695, -0.00956384, -0.00955708, -0.00954924,
  -0.0095403, -0.00953026, -0.00951914, -0.00950692, -0.00949361,
  -0.00947921, -0.00946372, -0.00944714, -0.00942948, -0.00941073,
  -0.00939089, -0.00936998, -0.00934798, -0.00932491, -0.00930076,
  -0.00927554, -0.00924924, -0.00922188, -0.00919345, -0.00916396,
  -0.0091334, -0.00910179, -0.00906912, -0.0090354, -0.00900063,
  -0.00896482, -0.00892797, -0.00889007, -0.00885115, -0.00881119,
  -0.00877021, -0.00872821, -0.00868519, -0.00864116, -0.00859611,
  -0.00855007, -0.00850303, -0.00845499, -0.00840596, -0.00835595,
  -0.00830496, -0.008253, -0.00820008, -0.00814619, -0.00809134,
  -0.00803554, -0.0079788, -0.00792113, -0.00786252, -0.00780298,
  -0.00774253, -0.00768116, -0.00761889, -0.00755572, -0.00749166,
  -0.00742671, -0.00736089, -0.0072942, -0.00722664, -0.00715823,
  -0.00708897, -0.00701887, -0.00694793, -0.00687618, -0.0068036,
  -0.00673022, -0.00665604, -0.00658107, -0.00650531, -0.00642878,
  -0.00635148, -0.00627343, -0.00619463, -0.00611509, -0.00603482,
  -0.00595382, -0.00587212, -0.00578971, -0.00570661, -0.00562282,
  -0.00553837, -0.00545324, -0.00536747, -0.00528104, -0.00519399,
  -0.00510631, -0.00501801, -0.00492911, -0.00483962, -0.00474954,
  -0.0046589, -0.00456768, -0.00447592, -0.00438362, -0.00429078,
  -0.00419743, -0.00410357, -0.00400921, -0.00391437, -0.00381905,
  -0.00372327, -0.00362703, -0.00353036, -0.00343326, -0.00333573,
  -0.00323781, -0.00313948, -0.00304078, -0.0029417, -0.00284227,
  -0.00274248, -0.00264237, -0.00254193, -0.00244117, -0.00234012,
  -0.00223879, -0.00213717, -0.0020353, -0.00193318, -0.00183081,
  -0.00172823, -0.00162543, -0.00152243, -0.00141924, -0.00131588,
  -0.00121236, -0.00110868, -0.00100487, -0.000900939, -0.000796893,
  -0.000692749, -0.000588519, -0.000484215, -0.000379852,
  -0.000275442, -0.000170997, -6.65314e-05, 3.79427e-05, 0.000142412,
  0.000246864, 0.000351284, 0.000455661, 0.000559981, 0.000664232,
  0.000768399, 0.00087247, 0.000976432, 0.00108027, 0.00118398,
  0.00128753, 0.00139093, 0.00149415, 0.00159718, 0.00170001,
  0.00180263, 0.00190502, 0.00200717, 0.00210907, 0.0022107,
  0.00231205, 0.00241311, 0.00251387, 0.0026143, 0.00271441,
  0.00281417, 0.00291358, 0.00301261, 0.00311127, 0.00320953,
  0.00330738, 0.00340481, 0.0035018, 0.00359835, 0.00369444,
  0.00379006, 0.0038852, 0.00397984, 0.00407397, 0.00416758,
  0.00426066, 0.00435319, 0.00444516, 0.00453656, 0.00462738,
  0.0047176, 0.00480722, 0.00489622, 0.00498459, 0.00507231,
  0.00515939, 0.00524579, 0.00533152, 0.00541656, 0.0055009,
  0.00558452, 0.00566742, 0.00574959, 0.00583101, 0.00591168,
  0.00599157, 0.00607069, 0.00614902, 0.00622654, 0.00630326,
  0.00637915, 0.00645421, 0.00652843, 0.00660179, 0.00667429,
  0.00674591, 0.00681666, 0.0068865, 0.00695545, 0.00702348,
  0.00709058, 0.00715676, 0.00722199, 0.00728627, 0.00734959,
  0.00741194, 0.00747331, 0.0075337, 0.00759308, 0.00765147,
  0.00770884, 0.00776518, 0.0078205, 0.00787478, 0.00792801,
  0.00798019, 0.0080313, 0.00808135, 0.00813032, 0.0081782,
  0.00822499, 0.00827068, 0.00831527, 0.00835874, 0.0084011,
  0.00844233, 0.00848242, 0.00852138, 0.00855919, 0.00859585,
  0.00863135, 0.00866569, 0.00869886, 0.00873086, 0.00876168,
  0.00879131, 0.00881976, 0.00884701, 0.00887306, 0.00889791,
  0.00892156, 0.00894399, 0.0089652, 0.0089852, 0.00900397,
  0.00902151, 0.00903783, 0.00905291, 0.00906675, 0.00907935,
  0.00909072, 0.00910083, 0.0091097, 0.00911732, 0.00912369,
  0.0091288, 0.00913266, 0.00913526, 0.0091366, 0.00913668, 0.0091355,
  0.00913306, 0.00912935, 0.00912439, 0.00911815, 0.00911066,
  0.0091019, 0.00909188, 0.00908059, 0.00906804, 0.00905423,
  0.00903915, 0.00902282, 0.00900523, 0.00898637, 0.00896626,
  0.0089449, 0.00892228, 0.00889842, 0.0088733, 0.00884694,
  0.00881933, 0.00879048, 0.0087604, 0.00872908, 0.00869653,
  0.00866275, 0.00862774, 0.00859152, 0.00855408, 0.00851542,
  0.00847556, 0.0084345, 0.00839223, 0.00834878, 0.00830413,
  0.0082583, 0.00821129, 0.00816312, 0.00811377, 0.00806326,
  0.0080116, 0.00795879, 0.00790484, 0.00784976, 0.00779355,
  0.00773621, 0.00767777, 0.00761821, 0.00755756, 0.00749582,
  0.00743299, 0.00736909, 0.00730412, 0.00723809, 0.00717102,
  0.0071029, 0.00703375, 0.00696357, 0.00689239, 0.0068202,
  0.00674701, 0.00667284, 0.00659769, 0.00652158, 0.00644451,
  0.0063665, 0.00628755, 0.00620768, 0.0061269, 0.00604521,
  0.00596264, 0.00587919, 0.00579486, 0.00570969, 0.00562367,
  0.00553681, 0.00544914, 0.00536065, 0.00527137, 0.00518131,
  0.00509048, 0.00499889, 0.00490655, 0.00481348, 0.0047197,
  0.0046252, 0.00453002, 0.00443415, 0.00433762, 0.00424044,
  0.00414263, 0.00404419, 0.00394514, 0.00384549, 0.00374527,
  0.00364448, 0.00354314, 0.00344126, 0.00333886, 0.00323596,
  0.00313256, 0.00302869, 0.00292436, 0.00281958, 0.00271437,
  0.00260875, 0.00250273, 0.00239633, 0.00228956, 0.00218243,
  0.00207498, 0.0019672, 0.00185913, 0.00175076, 0.00164213,
  0.00153324, 0.00142412, 0.00131478, 0.00120523, 0.0010955,
  0.000985596, 0.00087554, 0.000765348, 0.000655037, 0.000544623,
  0.000434125, 0.000323559, 0.000212943, 0.000102293, -8.37246e-06,
  -0.000119037, -0.000229683, -0.000340293, -0.000450849,
  -0.000561334, -0.000671731, -0.000782022, -0.000892189, -0.00100222,
  -0.00111208, -0.00122177, -0.00133127, -0.00144056, -0.00154962,
  -0.00165843, -0.00176697, -0.00187524, -0.0019832, -0.00209085,
  -0.00219816, -0.00230512, -0.00241171, -0.00251792, -0.00262371,
  -0.00272909, -0.00283403, -0.00293851, -0.00304251, -0.00314602,
  -0.00324902, -0.0033515, -0.00345343, -0.0035548, -0.00365559,
  -0.00375579, -0.00385537, -0.00395433, -0.00405264, -0.00415028,
  -0.00424725, -0.00434352, -0.00443907, -0.0045339, -0.00462797,
  -0.00472129, -0.00481383, -0.00490557, -0.0049965, -0.0050866,
  -0.00517586, -0.00526426, -0.00535179, -0.00543842, -0.00552415,
  -0.00560895, -0.00569282, -0.00577574, -0.00585769, -0.00593866,
  -0.00601863, -0.00609759, -0.00617553, -0.00625242, -0.00632826,
  -0.00640303, -0.00647672, -0.00654931, -0.00662079, -0.00669115,
  -0.00676037, -0.00682844, -0.00689534, -0.00696107, -0.00702561,
  -0.00708895, -0.00715108, -0.00721198, -0.00727164, -0.00733005,
  -0.0073872, -0.00744307, -0.00749766, -0.00755096, -0.00760295,
  -0.00765362, -0.00770297, -0.00775098, -0.00779764, -0.00784294,
  -0.00788687, -0.00792943, -0.0079706, -0.00801037, -0.00804875,
  -0.0080857, -0.00812124, -0.00815535, -0.00818802, -0.00821925,
  -0.00824902, -0.00827734, -0.00830419, -0.00832956, -0.00835346,
  -0.00837587, -0.00839678, -0.00841621, -0.00843412, -0.00845053,
  -0.00846543, -0.0084788, -0.00849066, -0.00850098, -0.00850978,
  -0.00851704, -0.00852277, -0.00852695, -0.00852959, -0.00853068,
  -0.00853022, -0.00852822, -0.00852466, -0.00851954, -0.00851287,
  -0.00850464, -0.00849486, -0.00848352, -0.00847062, -0.00845616,
  -0.00844014, -0.00842257, -0.00840344, -0.00838276, -0.00836053,
  -0.00833674, -0.00831141, -0.00828453, -0.0082561, -0.00822614,
  -0.00819464, -0.00816161, -0.00812704, -0.00809096, -0.00805335,
  -0.00801422, -0.00797359, -0.00793145, -0.00788781, -0.00784268,
  -0.00779606, -0.00774796, -0.00769838, -0.00764734, -0.00759484,
  -0.00754089, -0.0074855, -0.00742868, -0.00737042, -0.00731075,
  -0.00724968, -0.0071872, -0.00712334, -0.00705811, -0.0069915,
  -0.00692354, -0.00685423, -0.00678359, -0.00671163, -0.00663836,
  -0.00656379, -0.00648793, -0.0064108, -0.00633242, -0.00625279,
  -0.00617192, -0.00608984, -0.00600656, -0.00592208, -0.00583643,
  -0.00574963, -0.00566168, -0.0055726, -0.00548241, -0.00539112,
  -0.00529875, -0.00520533, -0.00511085, -0.00501535, -0.00491884,
  -0.00482133, -0.00472285, -0.00462342, -0.00452304, -0.00442175,
  -0.00431956, -0.00421649, -0.00411256, -0.00400778, -0.00390219,
  -0.00379579, -0.00368861, -0.00358068, -0.00347201, -0.00336261,
  -0.00325253, -0.00314177, -0.00303035, -0.00291831, -0.00280566,
  -0.00269242, -0.00257862, -0.00246429, -0.00234943, -0.00223408,
  -0.00211826, -0.00200199, -0.0018853, -0.00176821, -0.00165075,
  -0.00153294, -0.0014148, -0.00129636, -0.00117764, -0.00105867,
  -0.000939473, -0.000820075, -0.0007005, -0.000580775, -0.000460925,
  -0.000340975, -0.000220951, -0.00010088, 1.92139e-05, 0.000139303,
  0.000259362, 0.000379364, 0.000499284, 0.000619093, 0.000738767,
  0.000858277, 0.000977599, 0.0010967, 0.00121557, 0.00133416,
  0.00145246, 0.00157043, 0.00168805, 0.0018053, 0.00192214,
  0.00203855, 0.0021545, 0.00226997, 0.00238493, 0.00249934,
  0.00261319, 0.00272645, 0.00283909, 0.00295108, 0.0030624,
  0.00317302, 0.00328291, 0.00339204, 0.0035004, 0.00360795,
  0.00371467, 0.00382053, 0.0039255, 0.00402956, 0.00413268,
  0.00423484, 0.00433601, 0.00443617, 0.00453528, 0.00463333,
  0.00473029, 0.00482613, 0.00492083, 0.00501436, 0.0051067,
  0.00519783, 0.00528772, 0.00537634, 0.00546368, 0.0055497,
  0.0056344, 0.00571773, 0.00579969, 0.00588024, 0.00595936,
  0.00603704, 0.00611325, 0.00618797, 0.00626117, 0.00633284,
  0.00640295, 0.00647149, 0.00653844, 0.00660377, 0.00666746,
  0.0067295, 0.00678986, 0.00684853, 0.00690549, 0.00696072,
  0.00701421, 0.00706593, 0.00711587, 0.00716401, 0.00721034,
  0.00725484, 0.00729749, 0.00733829, 0.00737721, 0.00741424,
  0.00744937, 0.00748259, 0.00751387, 0.00754322, 0.00757061,
  0.00759604, 0.00761949, 0.00764095, 0.00766042, 0.00767788,
  0.00769332, 0.00770675, 0.00771813, 0.00772748, 0.00773478,
  0.00774002, 0.00774321, 0.00774432, 0.00774337, 0.00774034,
  0.00773523, 0.00772803, 0.00771874, 0.00770737, 0.0076939,
  0.00767834, 0.00766069, 0.00764094, 0.00761909, 0.00759515,
  0.00756912, 0.007541, 0.00751079, 0.0074785, 0.00744413, 0.00740768,
  0.00736916, 0.00732857, 0.00728592, 0.00724122, 0.00719447,
  0.00714569, 0.00709488, 0.00704204, 0.0069872, 0.00693036,
  0.00687153, 0.00681072, 0.00674795, 0.00668323, 0.00661657,
  0.00654798, 0.00647749, 0.0064051, 0.00633084, 0.00625472,
  0.00617675, 0.00609696, 0.00601536, 0.00593198, 0.00584683,
  0.00575993, 0.00567131, 0.00558098, 0.00548898, 0.00539531,
  0.00530002, 0.00520311, 0.00510462, 0.00500457, 0.00490299,
  0.0047999, 0.00469533, 0.00458932, 0.00448188, 0.00437305,
  0.00426285, 0.00415133, 0.0040385, 0.00392441, 0.00380908,
  0.00369254, 0.00357484, 0.00345599, 0.00333605, 0.00321503,
  0.00309299, 0.00296995, 0.00284595, 0.00272103, 0.00259523,
  0.00246858, 0.00234113, 0.00221291, 0.00208396, 0.00195432,
  0.00182404, 0.00169315, 0.0015617, 0.00142973, 0.00129728,
  0.00116439, 0.00103111, 0.000897478, 0.000763545, 0.000629352,
  0.000494944, 0.000360367, 0.000225665, 9.08864e-05, -4.39242e-05,
  -0.00017872, -0.000313453, -0.000448076, -0.000582543, -0.000716805,
  -0.000850814, -0.000984522, -0.00111788, -0.00125084, -0.00138335,
  -0.00151537, -0.00164684, -0.00177771, -0.00190795, -0.00203748,
  -0.00216628, -0.00229428, -0.00242143, -0.00254769, -0.00267301,
  -0.00279734, -0.00292062, -0.00304281, -0.00316386, -0.00328372,
  -0.00340233, -0.00351965, -0.00363563, -0.00375022, -0.00386337,
  -0.00397503, -0.00408515, -0.00419369, -0.00430059, -0.00440581,
  -0.0045093, -0.00461102, -0.0047109, -0.00480892, -0.00490502,
  -0.00499916, -0.00509129, -0.00518136, -0.00526934, -0.00535517,
  -0.00543882, -0.00552024, -0.00559939, -0.00567622, -0.0057507,
  -0.00582278, -0.00589243, -0.00595961, -0.00602427, -0.00608638,
  -0.00614591, -0.00620281, -0.00625705, -0.00630859, -0.00635741,
  -0.00640347, -0.00644674, -0.00648718, -0.00652477, -0.00655948,
  -0.00659127, -0.00662013, -0.00664603, -0.00666894, -0.00668883,
  -0.0067057, -0.0067195, -0.00673023, -0.00673787, -0.0067424,
  -0.00674379, -0.00674204, -0.00673714, -0.00672906, -0.0067178,
  -0.00670336, -0.00668571, -0.00666486, -0.00664079, -0.00661352,
  -0.00658302, -0.0065493, -0.00651237, -0.00647223, -0.00642887,
  -0.00638231, -0.00633255, -0.0062796, -0.00622347, -0.00616417,
  -0.00610173, -0.00603615, -0.00596744, -0.00589564, -0.00582077,
  -0.00574283, -0.00566187, -0.0055779, -0.00549096, -0.00540108,
  -0.00530828, -0.00521261, -0.00511409, -0.00501277, -0.00490869,
  -0.00480189, -0.00469242, -0.00458031, -0.00446563, -0.00434841,
  -0.00422871, -0.00410659, -0.00398209, -0.00385529, -0.00372624,
  -0.003595, -0.00346163, -0.00332621, -0.0031888, -0.00304947,
  -0.0029083, -0.00276536, -0.00262072, -0.00247446, -0.00232667,
  -0.00217742, -0.00202681, -0.00187491, -0.00172182, -0.00156763,
  -0.00141243, -0.00125631, -0.00109936, -0.000941696, -0.000783405,
  -0.000624592, -0.000465359, -0.000305811, -0.000146055, 1.38007e-05,
  0.000173647, 0.000333372, 0.000492863, 0.000652006, 0.000810684,
  0.000968781, 0.00112618, 0.00128276, 0.00143839, 0.00159297,
  0.00174636, 0.00189843, 0.00204908, 0.00219816, 0.00234555,
  0.00249112, 0.00263475, 0.00277631, 0.00291566, 0.00305268,
  0.00318723, 0.00331919, 0.00344843, 0.00357481, 0.0036982,
  0.00381848, 0.00393551, 0.00404917, 0.00415932, 0.00426584,
  0.0043686, 0.00446747, 0.00456233, 0.00465305, 0.00473952,
  0.0048216, 0.00489918, 0.00497215, 0.00504038, 0.00510376,
  0.00516218, 0.00521554, 0.00526372, 0.00530662, 0.00534415,
  0.00537621, 0.00540269, 0.00542353, 0.00543861, 0.00544788,
  0.00545125, 0.00544864, 0.00543999, 0.00542525, 0.00540434,
  0.00537722, 0.00534385, 0.00530418, 0.00525819, 0.00520584,
  0.00514712, 0.00508201, 0.00501052, 0.00493264, 0.00484839,
  0.0047578, 0.00466088, 0.00455768, 0.00444825, 0.00433265,
  0.00421095, 0.00408322, 0.00394956, 0.00381008, 0.00366488,
  0.0035141, 0.00335787, 0.00319635, 0.00302971, 0.00285813,
  0.00268181, 0.00250095, 0.00231579, 0.00212656, 0.00193353,
  0.00173698, 0.00153719, 0.00133449, 0.0011292, 0.000921677,
  0.000712289, 0.000501428, 0.000289507, 7.69605e-05, -0.000135755,
  -0.000348161, -0.000559753, -0.000770004, -0.000978362, -0.00118425,
  -0.00138706, -0.00158616, -0.0017809, -0.00197059, -0.00215451,
  -0.0023319, -0.00250201, -0.00266401, -0.00281706, -0.0029603,
  -0.0030928, -0.00321363, -0.0033218, -0.00341631, -0.00349609,
  -0.00356005, -0.00360706, -0.00363595, -0.0036455, -0.00363445,
  -0.00360151, -0.00354533, -0.00346451, -0.00335763, -0.0032232,
  -0.00305967, -0.00286548, -0.00263898, -0.00237848, -0.00208225,
  -0.00174849, -0.00137535, -0.000960915, -0.000503223, -2.4671e-07};
  const G4double G4NeutronHPFastLegendre::l19[4001] = {-1, -0.907221,
  -0.818793, -0.734581, -0.654452, -0.578277, -0.505931, -0.437291,
  -0.372236, -0.310648, -0.252415, -0.197422, -0.145562, -0.0967284,
  -0.0508163, -0.00772479, 0.0326452, 0.07039, 0.105604, 0.138378,
  0.168803, 0.196965, 0.22295, 0.246839, 0.268715, 0.288655, 0.306735,
  0.323032, 0.337616, 0.350559, 0.361929, 0.371793, 0.380217,
  0.387263, 0.392993, 0.397467, 0.400743, 0.402878, 0.403926,
  0.403941, 0.402974, 0.401076, 0.398296, 0.394681, 0.390276,
  0.385127, 0.379277, 0.372766, 0.365637, 0.357929, 0.349678,
  0.340923, 0.331698, 0.322039, 0.311978, 0.301548, 0.290779,
  0.279703, 0.268348, 0.256742, 0.244912, 0.232884, 0.220683,
  0.208334, 0.195859, 0.183281, 0.170622, 0.157902, 0.145142, 0.13236,
  0.119574, 0.106802, 0.0940615, 0.0813678, 0.0687364, 0.0561821,
  0.0437188, 0.0313599, 0.0191182, 0.00700568, -0.00496608,
  -0.0167862, -0.0284443, -0.0399306, -0.0512359, -0.0623514,
  -0.073269, -0.0839809, -0.0944799, -0.104759, -0.114813, -0.124634,
  -0.134218, -0.14356, -0.152655, -0.161499, -0.170088, -0.178419,
  -0.186488, -0.194293, -0.201832, -0.209101, -0.2161, -0.222827,
  -0.229281, -0.23546, -0.241365, -0.246995, -0.252349, -0.257429,
  -0.262233, -0.266764, -0.271021, -0.275006, -0.278721, -0.282165,
  -0.285342, -0.288252, -0.290899, -0.293283, -0.295408, -0.297276,
  -0.298889, -0.30025, -0.301362, -0.302229, -0.302852, -0.303236,
  -0.303383, -0.303298, -0.302983, -0.302443, -0.301681, -0.3007,
  -0.299505, -0.298101, -0.296489, -0.294676, -0.292664, -0.290458,
  -0.288063, -0.285483, -0.282721, -0.279782, -0.276671, -0.273392,
  -0.26995, -0.266348, -0.262592, -0.258686, -0.254634, -0.250441,
  -0.246111, -0.241649, -0.23706, -0.232347, -0.227516, -0.222571,
  -0.217516, -0.212356, -0.207095, -0.201738, -0.196289, -0.190753,
  -0.185133, -0.179435, -0.173662, -0.167819, -0.16191, -0.155939,
  -0.149911, -0.143829, -0.137698, -0.131522, -0.125304, -0.119049,
  -0.11276, -0.106442, -0.100099, -0.0937333, -0.0873497, -0.0809516,
  -0.0745427, -0.0681267, -0.0617069, -0.055287, -0.0488703,
  -0.0424602, -0.0360601, -0.0296731, -0.0233026, -0.0169517,
  -0.0106234, -0.00432088, 0.00195298, 0.00819522, 0.014403,
  0.0205735, 0.0267039, 0.0327916, 0.038834, 0.0448284, 0.0507724,
  0.0566635, 0.0624994, 0.0682777, 0.073996, 0.0796523, 0.0852444,
  0.0907701, 0.0962275, 0.101615, 0.106929, 0.11217, 0.117335,
  0.122422, 0.12743, 0.132357, 0.137201, 0.141962, 0.146637, 0.151225,
  0.155725, 0.160136, 0.164456, 0.168684, 0.172819, 0.17686, 0.180806,
  0.184657, 0.18841, 0.192066, 0.195623, 0.199081, 0.202439, 0.205696,
  0.208853, 0.211908, 0.21486, 0.21771, 0.220457, 0.223101, 0.225641,
  0.228077, 0.230409, 0.232636, 0.23476, 0.236779, 0.238693, 0.240503,
  0.242208, 0.243809, 0.245306, 0.246699, 0.247988, 0.249173,
  0.250256, 0.251235, 0.252111, 0.252886, 0.253558, 0.254129, 0.2546,
  0.25497, 0.255241, 0.255412, 0.255485, 0.25546, 0.255338, 0.255119,
  0.254805, 0.254396, 0.253893, 0.253296, 0.252608, 0.251827,
  0.250956, 0.249995, 0.248946, 0.247809, 0.246585, 0.245275, 0.24388,
  0.242402, 0.240841, 0.239199, 0.237476, 0.235674, 0.233794,
  0.231837, 0.229804, 0.227696, 0.225516, 0.223263, 0.220939,
  0.218545, 0.216083, 0.213554, 0.210959, 0.208299, 0.205577,
  0.202792, 0.199947, 0.197042, 0.194079, 0.19106, 0.187986, 0.184857,
  0.181677, 0.178445, 0.175163, 0.171832, 0.168455, 0.165032,
  0.161565, 0.158055, 0.154503, 0.150912, 0.147281, 0.143613, 0.13991,
  0.136172, 0.1324, 0.128597, 0.124764, 0.120901, 0.117011, 0.113095,
  0.109154, 0.10519, 0.101203, 0.0971958, 0.0931691, 0.0891244,
  0.085063, 0.0809863, 0.0768956, 0.0727922, 0.0686775, 0.0645528,
  0.0604194, 0.0562785, 0.0521316, 0.0479798, 0.0438244, 0.0396667,
  0.035508, 0.0313496, 0.0271925, 0.0230381, 0.0188877, 0.0147423,
  0.0106032, 0.00647157, 0.0023486, -0.00176456, -0.00586675,
  -0.00995684, -0.0140337, -0.0180962, -0.0221433, -0.0261739,
  -0.0301868, -0.0341811, -0.0381557, -0.0421095, -0.0460415,
  -0.0499508, -0.0538362, -0.0576969, -0.0615319, -0.0653402,
  -0.0691208, -0.072873, -0.0765956, -0.0802879, -0.083949, -0.087578,
  -0.091174, -0.0947362, -0.0982638, -0.101756, -0.105212, -0.108631,
  -0.112012, -0.115355, -0.118659, -0.121923, -0.125146, -0.128327,
  -0.131467, -0.134564, -0.137618, -0.140629, -0.143594, -0.146515,
  -0.14939, -0.152218, -0.155, -0.157735, -0.160422, -0.163061,
  -0.165651, -0.168192, -0.170683, -0.173124, -0.175515, -0.177855,
  -0.180143, -0.18238, -0.184565, -0.186698, -0.188778, -0.190805,
  -0.192779, -0.194699, -0.196566, -0.198378, -0.200136, -0.20184,
  -0.20349, -0.205084, -0.206623, -0.208108, -0.209536, -0.21091,
  -0.212228, -0.21349, -0.214697, -0.215848, -0.216943, -0.217982,
  -0.218965, -0.219892, -0.220764, -0.221579, -0.222338, -0.223042,
  -0.22369, -0.224282, -0.224819, -0.2253, -0.225725, -0.226096,
  -0.226411, -0.226671, -0.226876, -0.227026, -0.227122, -0.227163,
  -0.22715, -0.227083, -0.226963, -0.226789, -0.226562, -0.226282,
  -0.225949, -0.225563, -0.225126, -0.224636, -0.224096, -0.223503,
  -0.22286, -0.222167, -0.221423, -0.220629, -0.219786, -0.218894,
  -0.217953, -0.216964, -0.215927, -0.214842, -0.213711, -0.212532,
  -0.211308, -0.210037, -0.208722, -0.207361, -0.205956, -0.204508,
  -0.203015, -0.20148, -0.199903, -0.198283, -0.196622, -0.19492,
  -0.193178, -0.191396, -0.189574, -0.187714, -0.185816, -0.18388,
  -0.181906, -0.179897, -0.177851, -0.17577, -0.173653, -0.171503,
  -0.169319, -0.167102, -0.164852, -0.16257, -0.160257, -0.157914,
  -0.15554, -0.153137, -0.150705, -0.148244, -0.145756, -0.143241,
  -0.1407, -0.138133, -0.135541, -0.132924, -0.130283, -0.127619,
  -0.124933, -0.122224, -0.119495, -0.116744, -0.113974, -0.111184,
  -0.108375, -0.105549, -0.102705, -0.0998436, -0.0969666, -0.094074,
  -0.0911665, -0.0882448, -0.0853096, -0.0823614, -0.079401,
  -0.0764289, -0.0734459, -0.0704524, -0.0674493, -0.0644372,
  -0.0614166, -0.0583882, -0.0553527, -0.0523106, -0.0492627,
  -0.0462096, -0.0431518, -0.0400901, -0.037025, -0.0339571,
  -0.0308872, -0.0278158, -0.0247435, -0.0216709, -0.0185987,
  -0.0155274, -0.0124577, -0.00939023, -0.00632548, -0.00326409,
  -0.000206663, 0.00284622, 0.00589397, 0.008936, 0.0119717,
  0.0150006, 0.0180221, 0.0210355, 0.0240403, 0.0270361, 0.0300221,
  0.0329979, 0.035963, 0.0389167, 0.0418586, 0.0447881, 0.0477046,
  0.0506078, 0.0534969, 0.0563716, 0.0592314, 0.0620756, 0.0649039,
  0.0677157, 0.0705105, 0.0732879, 0.0760474, 0.0787885, 0.0815107,
  0.0842136, 0.0868968, 0.0895597, 0.092202, 0.0948231, 0.0974227,
  0.1, 0.102556, 0.105088, 0.107597, 0.110083, 0.112545, 0.114982,
  0.117394, 0.119782, 0.122144, 0.124479, 0.126789, 0.129072,
  0.131328, 0.133557, 0.135758, 0.137931, 0.140076, 0.142192, 0.14428,
  0.146338, 0.148366, 0.150365, 0.152334, 0.154272, 0.15618, 0.158057,
  0.159902, 0.161717, 0.163499, 0.16525, 0.166968, 0.168655, 0.170308,
  0.171929, 0.173517, 0.175072, 0.176594, 0.178081, 0.179536,
  0.180956, 0.182342, 0.183694, 0.185012, 0.186295, 0.187543,
  0.188757, 0.189935, 0.191079, 0.192188, 0.193261, 0.194299,
  0.195301, 0.196268, 0.1972, 0.198095, 0.198955, 0.199779, 0.200568,
  0.20132, 0.202036, 0.202717, 0.203361, 0.20397, 0.204542, 0.205078,
  0.205578, 0.206042, 0.20647, 0.206862, 0.207218, 0.207538, 0.207822,
  0.20807, 0.208283, 0.208459, 0.2086, 0.208704, 0.208774, 0.208807,
  0.208805, 0.208768, 0.208695, 0.208588, 0.208445, 0.208267,
  0.208054, 0.207806, 0.207524, 0.207207, 0.206856, 0.20647, 0.20605,
  0.205597, 0.205109, 0.204588, 0.204033, 0.203446, 0.202824, 0.20217,
  0.201483, 0.200764, 0.200012, 0.199228, 0.198412, 0.197564,
  0.196684, 0.195773, 0.194831, 0.193858, 0.192854, 0.19182, 0.190756,
  0.189661, 0.188537, 0.187383, 0.1862, 0.184988, 0.183748, 0.182478,
  0.181181, 0.179856, 0.178503, 0.177122, 0.175715, 0.174281, 0.17282,
  0.171333, 0.16982, 0.168281, 0.166717, 0.165128, 0.163514, 0.161876,
  0.160214, 0.158528, 0.156818, 0.155085, 0.15333, 0.151552, 0.149751,
  0.147929, 0.146086, 0.144221, 0.142335, 0.140429, 0.138503,
  0.136557, 0.134591, 0.132607, 0.130603, 0.128581, 0.126541,
  0.124484, 0.122409, 0.120317, 0.118208, 0.116083, 0.113943,
  0.111786, 0.109615, 0.107428, 0.105228, 0.103013, 0.100784,
  0.0985424, 0.0962875, 0.09402, 0.0917404, 0.0894488, 0.0871459,
  0.0848318, 0.082507, 0.0801718, 0.0778267, 0.075472, 0.0731081,
  0.0707353, 0.0683541, 0.0659648, 0.0635678, 0.0611635, 0.0587523,
  0.0563345, 0.0539105, 0.0514807, 0.0490454, 0.0466051, 0.0441601,
  0.0417108, 0.0392576, 0.0368009, 0.0343409, 0.0318782, 0.029413,
  0.0269458, 0.0244769, 0.0220067, 0.0195356, 0.0170639, 0.0145919,
  0.0121202, 0.00964897, 0.00717864, 0.00470958, 0.00224215,
  -0.000223301, -0.0026864, -0.0051468, -0.00760413, -0.010058,
  -0.0125082, -0.0149542, -0.0173957, -0.0198324, -0.0222639,
  -0.0246899, -0.02711, -0.0295239, -0.0319313, -0.0343318, -0.036725,
  -0.0391106, -0.0414884, -0.0438579, -0.0462189, -0.048571,
  -0.0509139, -0.0532472, -0.0555707, -0.057884, -0.0601868,
  -0.0624788, -0.0647597, -0.0670292, -0.0692869, -0.0715326,
  -0.073766, -0.0759867, -0.0781945, -0.0803891, -0.0825702,
  -0.0847375, -0.0868906, -0.0890294, -0.0911536, -0.0932628,
  -0.0953568, -0.0974354, -0.0994982, -0.101545, -0.103576, -0.10559,
  -0.107587, -0.109567, -0.11153, -0.113475, -0.115403, -0.117312,
  -0.119203, -0.121076, -0.12293, -0.124765, -0.126581, -0.128378,
  -0.130154, -0.131911, -0.133648, -0.135365, -0.137061, -0.138737,
  -0.140391, -0.142025, -0.143637, -0.145228, -0.146798, -0.148345,
  -0.14987, -0.151374, -0.152855, -0.154313, -0.155749, -0.157162,
  -0.158552, -0.159918, -0.161262, -0.162582, -0.163878, -0.165151,
  -0.1664, -0.167625, -0.168825, -0.170002, -0.171154, -0.172281,
  -0.173384, -0.174463, -0.175516, -0.176545, -0.177548, -0.178526,
  -0.17948, -0.180407, -0.18131, -0.182187, -0.183038, -0.183864,
  -0.184664, -0.185438, -0.186187, -0.186909, -0.187606, -0.188276,
  -0.188921, -0.189539, -0.190132, -0.190698, -0.191238, -0.191751,
  -0.192238, -0.192699, -0.193134, -0.193543, -0.193925, -0.19428,
  -0.194609, -0.194912, -0.195189, -0.195439, -0.195663, -0.19586,
  -0.196031, -0.196176, -0.196294, -0.196386, -0.196452, -0.196492,
  -0.196505, -0.196493, -0.196454, -0.196389, -0.196298, -0.196181,
  -0.196038, -0.19587, -0.195675, -0.195455, -0.195209, -0.194938,
  -0.194641, -0.194318, -0.193971, -0.193598, -0.193199, -0.192776,
  -0.192328, -0.191854, -0.191356, -0.190833, -0.190286, -0.189714,
  -0.189117, -0.188497, -0.187852, -0.187183, -0.18649, -0.185773,
  -0.185033, -0.184269, -0.183481, -0.182671, -0.181837, -0.18098,
  -0.1801, -0.179198, -0.178273, -0.177326, -0.176356, -0.175364,
  -0.17435, -0.173315, -0.172258, -0.171179, -0.170079, -0.168958,
  -0.167816, -0.166653, -0.16547, -0.164266, -0.163042, -0.161798,
  -0.160534, -0.15925, -0.157947, -0.156625, -0.155283, -0.153922,
  -0.152543, -0.151146, -0.14973, -0.148295, -0.146843, -0.145374,
  -0.143887, -0.142382, -0.140861, -0.139322, -0.137767, -0.136196,
  -0.134608, -0.133005, -0.131385, -0.129751, -0.1281, -0.126435,
  -0.124755, -0.123061, -0.121352, -0.119628, -0.117891, -0.116141,
  -0.114377, -0.112599, -0.110809, -0.109006, -0.10719, -0.105362,
  -0.103523, -0.101671, -0.0998081, -0.0979338, -0.0960485,
  -0.0941525, -0.0922459, -0.090329, -0.0884021, -0.0864655,
  -0.0845193, -0.0825639, -0.0805995, -0.0786263, -0.0766446,
  -0.0746547, -0.0726568, -0.0706512, -0.068638, -0.0666177,
  -0.0645904, -0.0625563, -0.0605159, -0.0584692, -0.0564166,
  -0.0543584, -0.0522947, -0.0502259, -0.0481521, -0.0460738,
  -0.043991, -0.0419041, -0.0398134, -0.0377191, -0.0356214,
  -0.0335207, -0.0314171, -0.029311, -0.0272026, -0.0250921,
  -0.0229799, -0.0208661, -0.018751, -0.016635, -0.0145182,
  -0.0124008, -0.0102833, -0.00816575, -0.00604848, -0.00393174,
  -0.00181577, 0.000299153, 0.00241279, 0.00452489, 0.00663519,
  0.00874345, 0.0108494, 0.0129528, 0.0150535, 0.017151, 0.0192453,
  0.0213361, 0.023423, 0.0255059, 0.0275846, 0.0296587, 0.0317281,
  0.0337924, 0.0358516, 0.0379052, 0.0399531, 0.0419951, 0.0440308,
  0.0460601, 0.0480828, 0.0500986, 0.0521072, 0.0541085, 0.0561022,
  0.058088, 0.0600658, 0.0620354, 0.0639965, 0.0659488, 0.0678922,
  0.0698265, 0.0717514, 0.0736666, 0.0755721, 0.0774676, 0.0793528,
  0.0812276, 0.0830917, 0.084945, 0.0867872, 0.0886182, 0.0904376,
  0.0922454, 0.0940414, 0.0958252, 0.0975968, 0.0993559, 0.101102,
  0.102836, 0.104557, 0.106264, 0.107958, 0.109638, 0.111305,
  0.112958, 0.114596, 0.11622, 0.11783, 0.119425, 0.121006, 0.122571,
  0.124121, 0.125656, 0.127175, 0.128679, 0.130167, 0.131639,
  0.133095, 0.134534, 0.135957, 0.137364, 0.138754, 0.140127,
  0.141483, 0.142822, 0.144144, 0.145448, 0.146735, 0.148004,
  0.149256, 0.150489, 0.151705, 0.152902, 0.154081, 0.155242,
  0.156384, 0.157507, 0.158612, 0.159698, 0.160765, 0.161813,
  0.162842, 0.163851, 0.164842, 0.165812, 0.166764, 0.167695,
  0.168607, 0.1695, 0.170372, 0.171224, 0.172057, 0.172869, 0.173661,
  0.174433, 0.175185, 0.175916, 0.176627, 0.177317, 0.177987,
  0.178636, 0.179264, 0.179872, 0.180459, 0.181025, 0.18157, 0.182095,
  0.182598, 0.183081, 0.183542, 0.183983, 0.184402, 0.184801,
  0.185178, 0.185534, 0.185869, 0.186183, 0.186475, 0.186747,
  0.186997, 0.187226, 0.187433, 0.18762, 0.187785, 0.187929, 0.188052,
  0.188153, 0.188234, 0.188293, 0.188331, 0.188348, 0.188343,
  0.188318, 0.188271, 0.188204, 0.188115, 0.188005, 0.187874,
  0.187722, 0.18755, 0.187356, 0.187142, 0.186907, 0.186651, 0.186374,
  0.186077, 0.185759, 0.18542, 0.185061, 0.184681, 0.184282, 0.183861,
  0.183421, 0.18296, 0.182479, 0.181979, 0.181458, 0.180917, 0.180357,
  0.179776, 0.179176, 0.178557, 0.177918, 0.177259, 0.176582,
  0.175885, 0.175168, 0.174433, 0.173679, 0.172906, 0.172115,
  0.171304, 0.170475, 0.169628, 0.168762, 0.167879, 0.166977,
  0.166057, 0.165119, 0.164164, 0.16319, 0.1622, 0.161192, 0.160166,
  0.159124, 0.158065, 0.156988, 0.155895, 0.154786, 0.15366, 0.152517,
  0.151358, 0.150184, 0.148993, 0.147787, 0.146565, 0.145327,
  0.144074, 0.142806, 0.141523, 0.140225, 0.138912, 0.137585,
  0.136243, 0.134887, 0.133517, 0.132133, 0.130735, 0.129324,
  0.127899, 0.12646, 0.125009, 0.123544, 0.122067, 0.120577, 0.119075,
  0.117561, 0.116034, 0.114495, 0.112945, 0.111383, 0.109809,
  0.108225, 0.106629, 0.105023, 0.103405, 0.101777, 0.100139,
  0.098491, 0.0968328, 0.0951648, 0.0934872, 0.0918001, 0.0901039,
  0.0883986, 0.0866845, 0.0849618, 0.0832305, 0.081491, 0.0797435,
  0.077988, 0.0762249, 0.0744543, 0.0726763, 0.0708913, 0.0690993,
  0.0673006, 0.0654954, 0.0636839, 0.0618663, 0.0600427, 0.0582134,
  0.0563785, 0.0545384, 0.0526931, 0.0508428, 0.0489878, 0.0471283,
  0.0452645, 0.0433965, 0.0415246, 0.039649, 0.0377698, 0.0358873,
  0.0340017, 0.0321131, 0.0302219, 0.0283281, 0.0264319, 0.0245337,
  0.0226335, 0.0207317, 0.0188283, 0.0169236, 0.0150178, 0.0131111,
  0.0112036, 0.00929572, 0.00738748, 0.00547914, 0.0035709,
  0.00166295, -0.0002445, -0.00215126, -0.00405711, -0.00596188,
  -0.00786534, -0.00976732, -0.0116676, -0.013566, -0.0154623,
  -0.0173563, -0.0192479, -0.0211367, -0.0230227, -0.0249056,
  -0.0267853, -0.0286615, -0.0305341, -0.0324028, -0.0342674,
  -0.0361279, -0.0379839, -0.0398353, -0.041682, -0.0435236, -0.04536,
  -0.0471911, -0.0490167, -0.0508365, -0.0526503, -0.0544581,
  -0.0562596, -0.0580546, -0.0598429, -0.0616244, -0.0633989,
  -0.0651662, -0.0669261, -0.0686784, -0.070423, -0.0721597,
  -0.0738884, -0.0756087, -0.0773207, -0.079024, -0.0807186,
  -0.0824042, -0.0840807, -0.085748, -0.0874058, -0.0890539,
  -0.0906924, -0.0923208, -0.0939392, -0.0955473, -0.097145,
  -0.0987322, -0.100309, -0.101874, -0.103429, -0.104972, -0.106504,
  -0.108024, -0.109533, -0.11103, -0.112515, -0.113988, -0.115449,
  -0.116897, -0.118333, -0.119756, -0.121166, -0.122564, -0.123948,
  -0.125319, -0.126677, -0.128021, -0.129352, -0.130669, -0.131973,
  -0.133262, -0.134537, -0.135798, -0.137044, -0.138277, -0.139494,
  -0.140697, -0.141885, -0.143058, -0.144216, -0.145359, -0.146487,
  -0.147599, -0.148696, -0.149778, -0.150843, -0.151893, -0.152927,
  -0.153946, -0.154948, -0.155934, -0.156903, -0.157857, -0.158794,
  -0.159714, -0.160618, -0.161505, -0.162376, -0.163229, -0.164066,
  -0.164886, -0.165689, -0.166474, -0.167243, -0.167994, -0.168728,
  -0.169445, -0.170144, -0.170825, -0.171489, -0.172135, -0.172764,
  -0.173375, -0.173968, -0.174543, -0.175101, -0.17564, -0.176162,
  -0.176665, -0.17715, -0.177618, -0.178067, -0.178498, -0.178911,
  -0.179305, -0.179681, -0.180039, -0.180379, -0.1807, -0.181003,
  -0.181287, -0.181554, -0.181801, -0.18203, -0.182241, -0.182433,
  -0.182607, -0.182762, -0.182899, -0.183018, -0.183117, -0.183199,
  -0.183261, -0.183306, -0.183332, -0.183339, -0.183328, -0.183298,
  -0.18325, -0.183184, -0.183099, -0.182995, -0.182874, -0.182734,
  -0.182575, -0.182398, -0.182203, -0.18199, -0.181758, -0.181509,
  -0.181241, -0.180955, -0.180651, -0.180329, -0.179988, -0.17963,
  -0.179254, -0.17886, -0.178448, -0.178019, -0.177572, -0.177107,
  -0.176624, -0.176124, -0.175606, -0.175071, -0.174519, -0.173949,
  -0.173362, -0.172757, -0.172136, -0.171498, -0.170842, -0.17017,
  -0.169481, -0.168775, -0.168052, -0.167313, -0.166557, -0.165785,
  -0.164997, -0.164192, -0.163371, -0.162534, -0.161681, -0.160812,
  -0.159927, -0.159026, -0.15811, -0.157179, -0.156232, -0.155269,
  -0.154292, -0.153299, -0.152291, -0.151268, -0.150231, -0.149179,
  -0.148112, -0.147031, -0.145935, -0.144825, -0.143701, -0.142563,
  -0.141411, -0.140245, -0.139066, -0.137873, -0.136667, -0.135447,
  -0.134215, -0.132969, -0.13171, -0.130439, -0.129155, -0.127858,
  -0.126549, -0.125228, -0.123895, -0.12255, -0.121192, -0.119824,
  -0.118443, -0.117051, -0.115648, -0.114234, -0.112809, -0.111373,
  -0.109926, -0.108469, -0.107001, -0.105523, -0.104035, -0.102537,
  -0.101029, -0.0995115, -0.0979845, -0.0964481, -0.0949025,
  -0.0933479, -0.0917844, -0.0902121, -0.0886313, -0.0870421,
  -0.0854446, -0.083839, -0.0822255, -0.0806042, -0.0789752,
  -0.0773389, -0.0756952, -0.0740444, -0.0723866, -0.0707221,
  -0.0690509, -0.0673732, -0.0656893, -0.0639992, -0.0623031,
  -0.0606012, -0.0588938, -0.0571808, -0.0554625, -0.0537392,
  -0.0520108, -0.0502777, -0.04854, -0.0467978, -0.0450514,
  -0.0433008, -0.0415464, -0.0397881, -0.0380263, -0.0362611,
  -0.0344926, -0.0327211, -0.0309467, -0.0291695, -0.0273899,
  -0.0256078, -0.0238236, -0.0220373, -0.0202492, -0.0184594,
  -0.0166681, -0.0148755, -0.0130818, -0.011287, -0.00949151,
  -0.00769536, -0.00589875, -0.00410187, -0.00230488, -0.000507966,
  0.0012887, 0.00308495, 0.0048806, 0.00667548, 0.00846943, 0.0102623,
  0.0120538, 0.0138439, 0.0156323, 0.0174189, 0.0192036, 0.0209861,
  0.0227663, 0.0245439, 0.0263189, 0.0280911, 0.0298603, 0.0316263,
  0.0333889, 0.035148, 0.0369035, 0.038655, 0.0404026, 0.0421459,
  0.0438849, 0.0456194, 0.0473492, 0.0490741, 0.050794, 0.0525088,
  0.0542181, 0.055922, 0.0576202, 0.0593125, 0.0609988, 0.062679,
  0.0643529, 0.0660202, 0.067681, 0.0693349, 0.0709819, 0.0726218,
  0.0742544, 0.0758795, 0.0774971, 0.079107, 0.080709, 0.0823029,
  0.0838887, 0.0854661, 0.087035, 0.0885953, 0.0901468, 0.0916894,
  0.0932229, 0.0947471, 0.0962621, 0.0977674, 0.0992632, 0.100749,
  0.102225, 0.103691, 0.105147, 0.106592, 0.108027, 0.109451,
  0.110865, 0.112268, 0.113659, 0.11504, 0.116409, 0.117767, 0.119113,
  0.120448, 0.12177, 0.123081, 0.12438, 0.125667, 0.126941, 0.128203,
  0.129453, 0.13069, 0.131914, 0.133125, 0.134323, 0.135509, 0.136681,
  0.137839, 0.138985, 0.140117, 0.141235, 0.142339, 0.14343, 0.144507,
  0.145569, 0.146618, 0.147652, 0.148672, 0.149678, 0.150669,
  0.151645, 0.152607, 0.153554, 0.154486, 0.155403, 0.156306,
  0.157193, 0.158064, 0.158921, 0.159762, 0.160588, 0.161398,
  0.162193, 0.162972, 0.163735, 0.164482, 0.165214, 0.16593, 0.166629,
  0.167313, 0.16798, 0.168632, 0.169267, 0.169885, 0.170488, 0.171074,
  0.171643, 0.172196, 0.172733, 0.173253, 0.173756, 0.174242,
  0.174712, 0.175165, 0.175601, 0.17602, 0.176422, 0.176808, 0.177176,
  0.177527, 0.177862, 0.178179, 0.178479, 0.178762, 0.179028,
  0.179277, 0.179509, 0.179723, 0.17992, 0.1801, 0.180263, 0.180408,
  0.180536, 0.180647, 0.180741, 0.180817, 0.180876, 0.180918,
  0.180942, 0.180949, 0.180939, 0.180911, 0.180867, 0.180804,
  0.180725, 0.180628, 0.180514, 0.180383, 0.180235, 0.180069,
  0.179887, 0.179687, 0.179469, 0.179235, 0.178984, 0.178716, 0.17843,
  0.178128, 0.177808, 0.177472, 0.177118, 0.176748, 0.176361,
  0.175957, 0.175537, 0.175099, 0.174645, 0.174174, 0.173687,
  0.173183, 0.172663, 0.172126, 0.171573, 0.171004, 0.170418,
  0.169816, 0.169198, 0.168564, 0.167914, 0.167247, 0.166565,
  0.165867, 0.165154, 0.164424, 0.163679, 0.162919, 0.162143,
  0.161351, 0.160544, 0.159722, 0.158885, 0.158033, 0.157165,
  0.156283, 0.155386, 0.154474, 0.153547, 0.152606, 0.151651,
  0.150681, 0.149696, 0.148698, 0.147685, 0.146658, 0.145618,
  0.144564, 0.143495, 0.142414, 0.141319, 0.14021, 0.139088, 0.137953,
  0.136805, 0.135644, 0.13447, 0.133283, 0.132083, 0.130872, 0.129647,
  0.128411, 0.127162, 0.125901, 0.124628, 0.123344, 0.122048, 0.12074,
  0.11942, 0.11809, 0.116748, 0.115395, 0.114032, 0.112657, 0.111272,
  0.109876, 0.10847, 0.107054, 0.105627, 0.104191, 0.102744, 0.101288,
  0.0998225, 0.0983474, 0.0968629, 0.0953693, 0.0938667, 0.0923551,
  0.0908349, 0.089306, 0.0877687, 0.0862231, 0.0846693, 0.0831076,
  0.0815379, 0.0799606, 0.0783756, 0.0767833, 0.0751837, 0.073577,
  0.0719634, 0.0703429, 0.0687158, 0.0670822, 0.0654422, 0.0637961,
  0.0621439, 0.0604858, 0.0588221, 0.0571527, 0.055478, 0.053798,
  0.0521129, 0.0504229, 0.0487282, 0.0470288, 0.045325, 0.0436169,
  0.0419047, 0.0401885, 0.0384685, 0.0367449, 0.0350178, 0.0332874,
  0.0315539, 0.0298173, 0.028078, 0.026336, 0.0245915, 0.0228447,
  0.0210957, 0.0193448, 0.017592, 0.0158375, 0.0140816, 0.0123243,
  0.0105658, 0.00880638, 0.00704611, 0.00528516, 0.00352372,
  0.00176194, -0, -0.00176194, -0.00352372, -0.00528516, -0.00704611,
  -0.00880638, -0.0105658, -0.0123243, -0.0140816, -0.0158375,
  -0.017592, -0.0193448, -0.0210957, -0.0228447, -0.0245915,
  -0.026336, -0.028078, -0.0298173, -0.0315539, -0.0332874,
  -0.0350178, -0.0367449, -0.0384685, -0.0401885, -0.0419047,
  -0.0436169, -0.045325, -0.0470288, -0.0487282, -0.0504229,
  -0.0521129, -0.053798, -0.055478, -0.0571527, -0.0588221,
  -0.0604858, -0.0621439, -0.0637961, -0.0654422, -0.0670822,
  -0.0687158, -0.0703429, -0.0719634, -0.073577, -0.0751837,
  -0.0767833, -0.0783756, -0.0799606, -0.0815379, -0.0831076,
  -0.0846693, -0.0862231, -0.0877687, -0.089306, -0.0908349,
  -0.0923551, -0.0938667, -0.0953693, -0.0968629, -0.0983474,
  -0.0998225, -0.101288, -0.102744, -0.104191, -0.105627, -0.107054,
  -0.10847, -0.109876, -0.111272, -0.112657, -0.114032, -0.115395,
  -0.116748, -0.11809, -0.11942, -0.12074, -0.122048, -0.123344,
  -0.124628, -0.125901, -0.127162, -0.128411, -0.129647, -0.130872,
  -0.132083, -0.133283, -0.13447, -0.135644, -0.136805, -0.137953,
  -0.139088, -0.14021, -0.141319, -0.142414, -0.143495, -0.144564,
  -0.145618, -0.146658, -0.147685, -0.148698, -0.149696, -0.150681,
  -0.151651, -0.152606, -0.153547, -0.154474, -0.155386, -0.156283,
  -0.157165, -0.158033, -0.158885, -0.159722, -0.160544, -0.161351,
  -0.162143, -0.162919, -0.163679, -0.164424, -0.165154, -0.165867,
  -0.166565, -0.167247, -0.167914, -0.168564, -0.169198, -0.169816,
  -0.170418, -0.171004, -0.171573, -0.172126, -0.172663, -0.173183,
  -0.173687, -0.174174, -0.174645, -0.175099, -0.175537, -0.175957,
  -0.176361, -0.176748, -0.177118, -0.177472, -0.177808, -0.178128,
  -0.17843, -0.178716, -0.178984, -0.179235, -0.179469, -0.179687,
  -0.179887, -0.180069, -0.180235, -0.180383, -0.180514, -0.180628,
  -0.180725, -0.180804, -0.180867, -0.180911, -0.180939, -0.180949,
  -0.180942, -0.180918, -0.180876, -0.180817, -0.180741, -0.180647,
  -0.180536, -0.180408, -0.180263, -0.1801, -0.17992, -0.179723,
  -0.179509, -0.179277, -0.179028, -0.178762, -0.178479, -0.178179,
  -0.177862, -0.177527, -0.177176, -0.176808, -0.176422, -0.17602,
  -0.175601, -0.175165, -0.174712, -0.174242, -0.173756, -0.173253,
  -0.172733, -0.172196, -0.171643, -0.171074, -0.170488, -0.169885,
  -0.169267, -0.168632, -0.16798, -0.167313, -0.166629, -0.16593,
  -0.165214, -0.164482, -0.163735, -0.162972, -0.162193, -0.161398,
  -0.160588, -0.159762, -0.158921, -0.158064, -0.157193, -0.156306,
  -0.155403, -0.154486, -0.153554, -0.152607, -0.151645, -0.150669,
  -0.149678, -0.148672, -0.147652, -0.146618, -0.145569, -0.144507,
  -0.14343, -0.142339, -0.141235, -0.140117, -0.138985, -0.137839,
  -0.136681, -0.135509, -0.134323, -0.133125, -0.131914, -0.13069,
  -0.129453, -0.128203, -0.126941, -0.125667, -0.12438, -0.123081,
  -0.12177, -0.120448, -0.119113, -0.117767, -0.116409, -0.11504,
  -0.113659, -0.112268, -0.110865, -0.109451, -0.108027, -0.106592,
  -0.105147, -0.103691, -0.102225, -0.100749, -0.0992632, -0.0977674,
  -0.0962621, -0.0947471, -0.0932229, -0.0916894, -0.0901468,
  -0.0885953, -0.087035, -0.0854661, -0.0838887, -0.0823029,
  -0.080709, -0.079107, -0.0774971, -0.0758795, -0.0742544,
  -0.0726218, -0.0709819, -0.0693349, -0.067681, -0.0660202,
  -0.0643529, -0.062679, -0.0609988, -0.0593125, -0.0576202,
  -0.055922, -0.0542181, -0.0525088, -0.050794, -0.0490741,
  -0.0473492, -0.0456194, -0.0438849, -0.0421459, -0.0404026,
  -0.038655, -0.0369035, -0.035148, -0.0333889, -0.0316263,
  -0.0298603, -0.0280911, -0.0263189, -0.0245439, -0.0227663,
  -0.0209861, -0.0192036, -0.0174189, -0.0156323, -0.0138439,
  -0.0120538, -0.0102623, -0.00846943, -0.00667548, -0.0048806,
  -0.00308495, -0.0012887, 0.000507966, 0.00230488, 0.00410187,
  0.00589875, 0.00769536, 0.00949151, 0.011287, 0.0130818, 0.0148755,
  0.0166681, 0.0184594, 0.0202492, 0.0220373, 0.0238236, 0.0256078,
  0.0273899, 0.0291695, 0.0309467, 0.0327211, 0.0344926, 0.0362611,
  0.0380263, 0.0397881, 0.0415464, 0.0433008, 0.0450514, 0.0467978,
  0.04854, 0.0502777, 0.0520108, 0.0537392, 0.0554625, 0.0571808,
  0.0588938, 0.0606012, 0.0623031, 0.0639992, 0.0656893, 0.0673732,
  0.0690509, 0.0707221, 0.0723866, 0.0740444, 0.0756952, 0.0773389,
  0.0789752, 0.0806042, 0.0822255, 0.083839, 0.0854446, 0.0870421,
  0.0886313, 0.0902121, 0.0917844, 0.0933479, 0.0949025, 0.0964481,
  0.0979845, 0.0995115, 0.101029, 0.102537, 0.104035, 0.105523,
  0.107001, 0.108469, 0.109926, 0.111373, 0.112809, 0.114234,
  0.115648, 0.117051, 0.118443, 0.119824, 0.121192, 0.12255, 0.123895,
  0.125228, 0.126549, 0.127858, 0.129155, 0.130439, 0.13171, 0.132969,
  0.134215, 0.135447, 0.136667, 0.137873, 0.139066, 0.140245,
  0.141411, 0.142563, 0.143701, 0.144825, 0.145935, 0.147031,
  0.148112, 0.149179, 0.150231, 0.151268, 0.152291, 0.153299,
  0.154292, 0.155269, 0.156232, 0.157179, 0.15811, 0.159026, 0.159927,
  0.160812, 0.161681, 0.162534, 0.163371, 0.164192, 0.164997,
  0.165785, 0.166557, 0.167313, 0.168052, 0.168775, 0.169481, 0.17017,
  0.170842, 0.171498, 0.172136, 0.172757, 0.173362, 0.173949,
  0.174519, 0.175071, 0.175606, 0.176124, 0.176624, 0.177107,
  0.177572, 0.178019, 0.178448, 0.17886, 0.179254, 0.17963, 0.179988,
  0.180329, 0.180651, 0.180955, 0.181241, 0.181509, 0.181758, 0.18199,
  0.182203, 0.182398, 0.182575, 0.182734, 0.182874, 0.182995,
  0.183099, 0.183184, 0.18325, 0.183298, 0.183328, 0.183339, 0.183332,
  0.183306, 0.183261, 0.183199, 0.183117, 0.183018, 0.182899,
  0.182762, 0.182607, 0.182433, 0.182241, 0.18203, 0.181801, 0.181554,
  0.181287, 0.181003, 0.1807, 0.180379, 0.180039, 0.179681, 0.179305,
  0.178911, 0.178498, 0.178067, 0.177618, 0.17715, 0.176665, 0.176162,
  0.17564, 0.175101, 0.174543, 0.173968, 0.173375, 0.172764, 0.172135,
  0.171489, 0.170825, 0.170144, 0.169445, 0.168728, 0.167994,
  0.167243, 0.166474, 0.165689, 0.164886, 0.164066, 0.163229,
  0.162376, 0.161505, 0.160618, 0.159714, 0.158794, 0.157857,
  0.156903, 0.155934, 0.154948, 0.153946, 0.152927, 0.151893,
  0.150843, 0.149778, 0.148696, 0.147599, 0.146487, 0.145359,
  0.144216, 0.143058, 0.141885, 0.140697, 0.139494, 0.138277,
  0.137044, 0.135798, 0.134537, 0.133262, 0.131973, 0.130669,
  0.129352, 0.128021, 0.126677, 0.125319, 0.123948, 0.122564,
  0.121166, 0.119756, 0.118333, 0.116897, 0.115449, 0.113988,
  0.112515, 0.11103, 0.109533, 0.108024, 0.106504, 0.104972, 0.103429,
  0.101874, 0.100309, 0.0987322, 0.097145, 0.0955473, 0.0939392,
  0.0923208, 0.0906924, 0.0890539, 0.0874058, 0.085748, 0.0840807,
  0.0824042, 0.0807186, 0.079024, 0.0773207, 0.0756087, 0.0738884,
  0.0721597, 0.070423, 0.0686784, 0.0669261, 0.0651662, 0.0633989,
  0.0616244, 0.0598429, 0.0580546, 0.0562596, 0.0544581, 0.0526503,
  0.0508365, 0.0490167, 0.0471911, 0.04536, 0.0435236, 0.041682,
  0.0398353, 0.0379839, 0.0361279, 0.0342674, 0.0324028, 0.0305341,
  0.0286615, 0.0267853, 0.0249056, 0.0230227, 0.0211367, 0.0192479,
  0.0173563, 0.0154623, 0.013566, 0.0116676, 0.00976732, 0.00786534,
  0.00596188, 0.00405711, 0.00215126, 0.0002445, -0.00166295,
  -0.0035709, -0.00547914, -0.00738748, -0.00929572, -0.0112036,
  -0.0131111, -0.0150178, -0.0169236, -0.0188283, -0.0207317,
  -0.0226335, -0.0245337, -0.0264319, -0.0283281, -0.0302219,
  -0.0321131, -0.0340017, -0.0358873, -0.0377698, -0.039649,
  -0.0415246, -0.0433965, -0.0452645, -0.0471283, -0.0489878,
  -0.0508428, -0.0526931, -0.0545384, -0.0563785, -0.0582134,
  -0.0600427, -0.0618663, -0.0636839, -0.0654954, -0.0673006,
  -0.0690993, -0.0708913, -0.0726763, -0.0744543, -0.0762249,
  -0.077988, -0.0797435, -0.081491, -0.0832305, -0.0849618,
  -0.0866845, -0.0883986, -0.0901039, -0.0918001, -0.0934872,
  -0.0951648, -0.0968328, -0.098491, -0.100139, -0.101777, -0.103405,
  -0.105023, -0.106629, -0.108225, -0.109809, -0.111383, -0.112945,
  -0.114495, -0.116034, -0.117561, -0.119075, -0.120577, -0.122067,
  -0.123544, -0.125009, -0.12646, -0.127899, -0.129324, -0.130735,
  -0.132133, -0.133517, -0.134887, -0.136243, -0.137585, -0.138912,
  -0.140225, -0.141523, -0.142806, -0.144074, -0.145327, -0.146565,
  -0.147787, -0.148993, -0.150184, -0.151358, -0.152517, -0.15366,
  -0.154786, -0.155895, -0.156988, -0.158065, -0.159124, -0.160166,
  -0.161192, -0.1622, -0.16319, -0.164164, -0.165119, -0.166057,
  -0.166977, -0.167879, -0.168762, -0.169628, -0.170475, -0.171304,
  -0.172115, -0.172906, -0.173679, -0.174433, -0.175168, -0.175885,
  -0.176582, -0.177259, -0.177918, -0.178557, -0.179176, -0.179776,
  -0.180357, -0.180917, -0.181458, -0.181979, -0.182479, -0.18296,
  -0.183421, -0.183861, -0.184282, -0.184681, -0.185061, -0.18542,
  -0.185759, -0.186077, -0.186374, -0.186651, -0.186907, -0.187142,
  -0.187356, -0.18755, -0.187722, -0.187874, -0.188005, -0.188115,
  -0.188204, -0.188271, -0.188318, -0.188343, -0.188348, -0.188331,
  -0.188293, -0.188234, -0.188153, -0.188052, -0.187929, -0.187785,
  -0.18762, -0.187433, -0.187226, -0.186997, -0.186747, -0.186475,
  -0.186183, -0.185869, -0.185534, -0.185178, -0.184801, -0.184402,
  -0.183983, -0.183542, -0.183081, -0.182598, -0.182095, -0.18157,
  -0.181025, -0.180459, -0.179872, -0.179264, -0.178636, -0.177987,
  -0.177317, -0.176627, -0.175916, -0.175185, -0.174433, -0.173661,
  -0.172869, -0.172057, -0.171224, -0.170372, -0.1695, -0.168607,
  -0.167695, -0.166764, -0.165812, -0.164842, -0.163851, -0.162842,
  -0.161813, -0.160765, -0.159698, -0.158612, -0.157507, -0.156384,
  -0.155242, -0.154081, -0.152902, -0.151705, -0.150489, -0.149256,
  -0.148004, -0.146735, -0.145448, -0.144144, -0.142822, -0.141483,
  -0.140127, -0.138754, -0.137364, -0.135957, -0.134534, -0.133095,
  -0.131639, -0.130167, -0.128679, -0.127175, -0.125656, -0.124121,
  -0.122571, -0.121006, -0.119425, -0.11783, -0.11622, -0.114596,
  -0.112958, -0.111305, -0.109638, -0.107958, -0.106264, -0.104557,
  -0.102836, -0.101102, -0.0993559, -0.0975968, -0.0958252,
  -0.0940414, -0.0922454, -0.0904376, -0.0886182, -0.0867872,
  -0.084945, -0.0830917, -0.0812276, -0.0793528, -0.0774676,
  -0.0755721, -0.0736666, -0.0717514, -0.0698265, -0.0678922,
  -0.0659488, -0.0639965, -0.0620354, -0.0600658, -0.058088,
  -0.0561022, -0.0541085, -0.0521072, -0.0500986, -0.0480828,
  -0.0460601, -0.0440308, -0.0419951, -0.0399531, -0.0379052,
  -0.0358516, -0.0337924, -0.0317281, -0.0296587, -0.0275846,
  -0.0255059, -0.023423, -0.0213361, -0.0192453, -0.017151,
  -0.0150535, -0.0129528, -0.0108494, -0.00874345, -0.00663519,
  -0.00452489, -0.00241279, -0.000299153, 0.00181577, 0.00393174,
  0.00604848, 0.00816575, 0.0102833, 0.0124008, 0.0145182, 0.016635,
  0.018751, 0.0208661, 0.0229799, 0.0250921, 0.0272026, 0.029311,
  0.0314171, 0.0335207, 0.0356214, 0.0377191, 0.0398134, 0.0419041,
  0.043991, 0.0460738, 0.0481521, 0.0502259, 0.0522947, 0.0543584,
  0.0564166, 0.0584692, 0.0605159, 0.0625563, 0.0645904, 0.0666177,
  0.068638, 0.0706512, 0.0726568, 0.0746547, 0.0766446, 0.0786263,
  0.0805995, 0.0825639, 0.0845193, 0.0864655, 0.0884021, 0.090329,
  0.0922459, 0.0941525, 0.0960485, 0.0979338, 0.0998081, 0.101671,
  0.103523, 0.105362, 0.10719, 0.109006, 0.110809, 0.112599, 0.114377,
  0.116141, 0.117891, 0.119628, 0.121352, 0.123061, 0.124755,
  0.126435, 0.1281, 0.129751, 0.131385, 0.133005, 0.134608, 0.136196,
  0.137767, 0.139322, 0.140861, 0.142382, 0.143887, 0.145374,
  0.146843, 0.148295, 0.14973, 0.151146, 0.152543, 0.153922, 0.155283,
  0.156625, 0.157947, 0.15925, 0.160534, 0.161798, 0.163042, 0.164266,
  0.16547, 0.166653, 0.167816, 0.168958, 0.170079, 0.171179, 0.172258,
  0.173315, 0.17435, 0.175364, 0.176356, 0.177326, 0.178273, 0.179198,
  0.1801, 0.18098, 0.181837, 0.182671, 0.183481, 0.184269, 0.185033,
  0.185773, 0.18649, 0.187183, 0.187852, 0.188497, 0.189117, 0.189714,
  0.190286, 0.190833, 0.191356, 0.191854, 0.192328, 0.192776,
  0.193199, 0.193598, 0.193971, 0.194318, 0.194641, 0.194938,
  0.195209, 0.195455, 0.195675, 0.19587, 0.196038, 0.196181, 0.196298,
  0.196389, 0.196454, 0.196493, 0.196505, 0.196492, 0.196452,
  0.196386, 0.196294, 0.196176, 0.196031, 0.19586, 0.195663, 0.195439,
  0.195189, 0.194912, 0.194609, 0.19428, 0.193925, 0.193543, 0.193134,
  0.192699, 0.192238, 0.191751, 0.191238, 0.190698, 0.190132,
  0.189539, 0.188921, 0.188276, 0.187606, 0.186909, 0.186187,
  0.185438, 0.184664, 0.183864, 0.183038, 0.182187, 0.18131, 0.180407,
  0.17948, 0.178526, 0.177548, 0.176545, 0.175516, 0.174463, 0.173384,
  0.172281, 0.171154, 0.170002, 0.168825, 0.167625, 0.1664, 0.165151,
  0.163878, 0.162582, 0.161262, 0.159918, 0.158552, 0.157162,
  0.155749, 0.154313, 0.152855, 0.151374, 0.14987, 0.148345, 0.146798,
  0.145228, 0.143637, 0.142025, 0.140391, 0.138737, 0.137061,
  0.135365, 0.133648, 0.131911, 0.130154, 0.128378, 0.126581,
  0.124765, 0.12293, 0.121076, 0.119203, 0.117312, 0.115403, 0.113475,
  0.11153, 0.109567, 0.107587, 0.10559, 0.103576, 0.101545, 0.0994982,
  0.0974354, 0.0953568, 0.0932628, 0.0911536, 0.0890294, 0.0868906,
  0.0847375, 0.0825702, 0.0803891, 0.0781945, 0.0759867, 0.073766,
  0.0715326, 0.0692869, 0.0670292, 0.0647597, 0.0624788, 0.0601868,
  0.057884, 0.0555707, 0.0532472, 0.0509139, 0.048571, 0.0462189,
  0.0438579, 0.0414884, 0.0391106, 0.036725, 0.0343318, 0.0319313,
  0.0295239, 0.02711, 0.0246899, 0.0222639, 0.0198324, 0.0173957,
  0.0149542, 0.0125082, 0.010058, 0.00760413, 0.0051468, 0.0026864,
  0.000223301, -0.00224215, -0.00470958, -0.00717864, -0.00964897,
  -0.0121202, -0.0145919, -0.0170639, -0.0195356, -0.0220067,
  -0.0244769, -0.0269458, -0.029413, -0.0318782, -0.0343409,
  -0.0368009, -0.0392576, -0.0417108, -0.0441601, -0.0466051,
  -0.0490454, -0.0514807, -0.0539105, -0.0563345, -0.0587523,
  -0.0611635, -0.0635678, -0.0659648, -0.0683541, -0.0707353,
  -0.0731081, -0.075472, -0.0778267, -0.0801718, -0.082507,
  -0.0848318, -0.0871459, -0.0894488, -0.0917404, -0.09402,
  -0.0962875, -0.0985424, -0.100784, -0.103013, -0.105228, -0.107428,
  -0.109615, -0.111786, -0.113943, -0.116083, -0.118208, -0.120317,
  -0.122409, -0.124484, -0.126541, -0.128581, -0.130603, -0.132607,
  -0.134591, -0.136557, -0.138503, -0.140429, -0.142335, -0.144221,
  -0.146086, -0.147929, -0.149751, -0.151552, -0.15333, -0.155085,
  -0.156818, -0.158528, -0.160214, -0.161876, -0.163514, -0.165128,
  -0.166717, -0.168281, -0.16982, -0.171333, -0.17282, -0.174281,
  -0.175715, -0.177122, -0.178503, -0.179856, -0.181181, -0.182478,
  -0.183748, -0.184988, -0.1862, -0.187383, -0.188537, -0.189661,
  -0.190756, -0.19182, -0.192854, -0.193858, -0.194831, -0.195773,
  -0.196684, -0.197564, -0.198412, -0.199228, -0.200012, -0.200764,
  -0.201483, -0.20217, -0.202824, -0.203446, -0.204033, -0.204588,
  -0.205109, -0.205597, -0.20605, -0.20647, -0.206856, -0.207207,
  -0.207524, -0.207806, -0.208054, -0.208267, -0.208445, -0.208588,
  -0.208695, -0.208768, -0.208805, -0.208807, -0.208774, -0.208704,
  -0.2086, -0.208459, -0.208283, -0.20807, -0.207822, -0.207538,
  -0.207218, -0.206862, -0.20647, -0.206042, -0.205578, -0.205078,
  -0.204542, -0.20397, -0.203361, -0.202717, -0.202036, -0.20132,
  -0.200568, -0.199779, -0.198955, -0.198095, -0.1972, -0.196268,
  -0.195301, -0.194299, -0.193261, -0.192188, -0.191079, -0.189935,
  -0.188757, -0.187543, -0.186295, -0.185012, -0.183694, -0.182342,
  -0.180956, -0.179536, -0.178081, -0.176594, -0.175072, -0.173517,
  -0.171929, -0.170308, -0.168655, -0.166968, -0.16525, -0.163499,
  -0.161717, -0.159902, -0.158057, -0.15618, -0.154272, -0.152334,
  -0.150365, -0.148366, -0.146338, -0.14428, -0.142192, -0.140076,
  -0.137931, -0.135758, -0.133557, -0.131328, -0.129072, -0.126789,
  -0.124479, -0.122144, -0.119782, -0.117394, -0.114982, -0.112545,
  -0.110083, -0.107597, -0.105088, -0.102556, -0.1, -0.0974227,
  -0.0948231, -0.092202, -0.0895597, -0.0868968, -0.0842136,
  -0.0815107, -0.0787885, -0.0760474, -0.0732879, -0.0705105,
  -0.0677157, -0.0649039, -0.0620756, -0.0592314, -0.0563716,
  -0.0534969, -0.0506078, -0.0477046, -0.0447881, -0.0418586,
  -0.0389167, -0.035963, -0.0329979, -0.0300221, -0.0270361,
  -0.0240403, -0.0210355, -0.0180221, -0.0150006, -0.0119717,
  -0.008936, -0.00589397, -0.00284622, 0.000206663, 0.00326409,
  0.00632548, 0.00939023, 0.0124577, 0.0155274, 0.0185987, 0.0216709,
  0.0247435, 0.0278158, 0.0308872, 0.0339571, 0.037025, 0.0400901,
  0.0431518, 0.0462096, 0.0492627, 0.0523106, 0.0553527, 0.0583882,
  0.0614166, 0.0644372, 0.0674493, 0.0704524, 0.0734459, 0.0764289,
  0.079401, 0.0823614, 0.0853096, 0.0882448, 0.0911665, 0.094074,
  0.0969666, 0.0998436, 0.102705, 0.105549, 0.108375, 0.111184,
  0.113974, 0.116744, 0.119495, 0.122224, 0.124933, 0.127619,
  0.130283, 0.132924, 0.135541, 0.138133, 0.1407, 0.143241, 0.145756,
  0.148244, 0.150705, 0.153137, 0.15554, 0.157914, 0.160257, 0.16257,
  0.164852, 0.167102, 0.169319, 0.171503, 0.173653, 0.17577, 0.177851,
  0.179897, 0.181906, 0.18388, 0.185816, 0.187714, 0.189574, 0.191396,
  0.193178, 0.19492, 0.196622, 0.198283, 0.199903, 0.20148, 0.203015,
  0.204508, 0.205956, 0.207361, 0.208722, 0.210037, 0.211308,
  0.212532, 0.213711, 0.214842, 0.215927, 0.216964, 0.217953,
  0.218894, 0.219786, 0.220629, 0.221423, 0.222167, 0.22286, 0.223503,
  0.224096, 0.224636, 0.225126, 0.225563, 0.225949, 0.226282,
  0.226562, 0.226789, 0.226963, 0.227083, 0.22715, 0.227163, 0.227122,
  0.227026, 0.226876, 0.226671, 0.226411, 0.226096, 0.225725, 0.2253,
  0.224819, 0.224282, 0.22369, 0.223042, 0.222338, 0.221579, 0.220764,
  0.219892, 0.218965, 0.217982, 0.216943, 0.215848, 0.214697, 0.21349,
  0.212228, 0.21091, 0.209536, 0.208108, 0.206623, 0.205084, 0.20349,
  0.20184, 0.200136, 0.198378, 0.196566, 0.194699, 0.192779, 0.190805,
  0.188778, 0.186698, 0.184565, 0.18238, 0.180143, 0.177855, 0.175515,
  0.173124, 0.170683, 0.168192, 0.165651, 0.163061, 0.160422,
  0.157735, 0.155, 0.152218, 0.14939, 0.146515, 0.143594, 0.140629,
  0.137618, 0.134564, 0.131467, 0.128327, 0.125146, 0.121923,
  0.118659, 0.115355, 0.112012, 0.108631, 0.105212, 0.101756,
  0.0982638, 0.0947362, 0.091174, 0.087578, 0.083949, 0.0802879,
  0.0765956, 0.072873, 0.0691208, 0.0653402, 0.0615319, 0.0576969,
  0.0538362, 0.0499508, 0.0460415, 0.0421095, 0.0381557, 0.0341811,
  0.0301868, 0.0261739, 0.0221433, 0.0180962, 0.0140337, 0.00995684,
  0.00586675, 0.00176456, -0.0023486, -0.00647157, -0.0106032,
  -0.0147423, -0.0188877, -0.0230381, -0.0271925, -0.0313496,
  -0.035508, -0.0396667, -0.0438244, -0.0479798, -0.0521316,
  -0.0562785, -0.0604194, -0.0645528, -0.0686775, -0.0727922,
  -0.0768956, -0.0809863, -0.085063, -0.0891244, -0.0931691,
  -0.0971958, -0.101203, -0.10519, -0.109154, -0.113095, -0.117011,
  -0.120901, -0.124764, -0.128597, -0.1324, -0.136172, -0.13991,
  -0.143613, -0.147281, -0.150912, -0.154503, -0.158055, -0.161565,
  -0.165032, -0.168455, -0.171832, -0.175163, -0.178445, -0.181677,
  -0.184857, -0.187986, -0.19106, -0.194079, -0.197042, -0.199947,
  -0.202792, -0.205577, -0.208299, -0.210959, -0.213554, -0.216083,
  -0.218545, -0.220939, -0.223263, -0.225516, -0.227696, -0.229804,
  -0.231837, -0.233794, -0.235674, -0.237476, -0.239199, -0.240841,
  -0.242402, -0.24388, -0.245275, -0.246585, -0.247809, -0.248946,
  -0.249995, -0.250956, -0.251827, -0.252608, -0.253296, -0.253893,
  -0.254396, -0.254805, -0.255119, -0.255338, -0.25546, -0.255485,
  -0.255412, -0.255241, -0.25497, -0.2546, -0.254129, -0.253558,
  -0.252886, -0.252111, -0.251235, -0.250256, -0.249173, -0.247988,
  -0.246699, -0.245306, -0.243809, -0.242208, -0.240503, -0.238693,
  -0.236779, -0.23476, -0.232636, -0.230409, -0.228077, -0.225641,
  -0.223101, -0.220457, -0.21771, -0.21486, -0.211908, -0.208853,
  -0.205696, -0.202439, -0.199081, -0.195623, -0.192066, -0.18841,
  -0.184657, -0.180806, -0.17686, -0.172819, -0.168684, -0.164456,
  -0.160136, -0.155725, -0.151225, -0.146637, -0.141962, -0.137201,
  -0.132357, -0.12743, -0.122422, -0.117335, -0.11217, -0.106929,
  -0.101615, -0.0962275, -0.0907701, -0.0852444, -0.0796523,
  -0.073996, -0.0682777, -0.0624994, -0.0566635, -0.0507724,
  -0.0448284, -0.038834, -0.0327916, -0.0267039, -0.0205735,
  -0.014403, -0.00819522, -0.00195298, 0.00432088, 0.0106234,
  0.0169517, 0.0233026, 0.0296731, 0.0360601, 0.0424602, 0.0488703,
  0.055287, 0.0617069, 0.0681267, 0.0745427, 0.0809516, 0.0873497,
  0.0937333, 0.100099, 0.106442, 0.11276, 0.119049, 0.125304,
  0.131522, 0.137698, 0.143829, 0.149911, 0.155939, 0.16191, 0.167819,
  0.173662, 0.179435, 0.185133, 0.190753, 0.196289, 0.201738,
  0.207095, 0.212356, 0.217516, 0.222571, 0.227516, 0.232347, 0.23706,
  0.241649, 0.246111, 0.250441, 0.254634, 0.258686, 0.262592,
  0.266348, 0.26995, 0.273392, 0.276671, 0.279782, 0.282721, 0.285483,
  0.288063, 0.290458, 0.292664, 0.294676, 0.296489, 0.298101,
  0.299505, 0.3007, 0.301681, 0.302443, 0.302983, 0.303298, 0.303383,
  0.303236, 0.302852, 0.302229, 0.301362, 0.30025, 0.298889, 0.297276,
  0.295408, 0.293283, 0.290899, 0.288252, 0.285342, 0.282165,
  0.278721, 0.275006, 0.271021, 0.266764, 0.262233, 0.257429,
  0.252349, 0.246995, 0.241365, 0.23546, 0.229281, 0.222827, 0.2161,
  0.209101, 0.201832, 0.194293, 0.186488, 0.178419, 0.170088,
  0.161499, 0.152655, 0.14356, 0.134218, 0.124634, 0.114813, 0.104759,
  0.0944799, 0.0839809, 0.073269, 0.0623514, 0.0512359, 0.0399306,
  0.0284443, 0.0167862, 0.00496608, -0.00700568, -0.0191182,
  -0.0313599, -0.0437188, -0.0561821, -0.0687364, -0.0813678,
  -0.0940615, -0.106802, -0.119574, -0.13236, -0.145142, -0.157902,
  -0.170622, -0.183281, -0.195859, -0.208334, -0.220683, -0.232884,
  -0.244912, -0.256742, -0.268348, -0.279703, -0.290779, -0.301548,
  -0.311978, -0.322039, -0.331698, -0.340923, -0.349678, -0.357929,
  -0.365637, -0.372766, -0.379277, -0.385127, -0.390276, -0.394681,
  -0.398296, -0.401076, -0.402974, -0.403941, -0.403926, -0.402878,
  -0.400743, -0.397467, -0.392993, -0.387263, -0.380217, -0.371793,
  -0.361929, -0.350559, -0.337616, -0.323032, -0.306735, -0.288655,
  -0.268715, -0.246839, -0.22295, -0.196965, -0.168803, -0.138378,
  -0.105604, -0.07039, -0.0326452, 0.00772479, 0.0508163, 0.0967284,
  0.145562, 0.197422, 0.252415, 0.310648, 0.372236, 0.437291,
  0.505931, 0.578277, 0.654452, 0.734581, 0.818793, 0.907221, 1};
  const G4double G4NeutronHPFastLegendre::i19[4001] = {0, -0.000476615,
  -0.000907935, -0.0012961, -0.00164319, -0.0019512, -0.00222209,
  -0.00245774, -0.00265997, -0.00283054, -0.00297117, -0.00308349,
  -0.0031691, -0.00322955, -0.00326631, -0.00328083, -0.00327448,
  -0.00324861, -0.00320451, -0.00314341, -0.00306652, -0.00297498,
  -0.00286991, -0.00275237, -0.0026234, -0.00248397, -0.00233505,
  -0.00217753, -0.0020123, -0.00184019, -0.001662, -0.0014785,
  -0.00129044, -0.00109851, -0.000903394, -0.000705726, -0.000506124,
  -0.00030517, -0.000103424, 9.85859e-05, 0.000300356, 0.000501407,
  0.000701287, 0.000899566, 0.00109584, 0.00128972, 0.00148085,
  0.00166889, 0.00185352, 0.00203443, 0.00221135, 0.00238403,
  0.0025522, 0.00271565, 0.00287417, 0.00302757, 0.00317567,
  0.0033183, 0.00345532, 0.00358661, 0.00371203, 0.00383149,
  0.00394488, 0.00405214, 0.0041532, 0.00424799, 0.00433646,
  0.0044186, 0.00449436, 0.00456374, 0.00462672, 0.00468331,
  0.00473353, 0.00477738, 0.00481491, 0.00484613, 0.0048711,
  0.00488987, 0.00490248, 0.00490901, 0.00490951, 0.00490407,
  0.00489275, 0.00487565, 0.00485285, 0.00482444, 0.00479053,
  0.00475121, 0.00470658, 0.00465677, 0.00460186, 0.00454199,
  0.00447727, 0.00440781, 0.00433375, 0.0042552, 0.00417229,
  0.00408515, 0.00399391, 0.00389871, 0.00379966, 0.00369692,
  0.00359061, 0.00348086, 0.00336783, 0.00325163, 0.00313241,
  0.00301031, 0.00288546, 0.002758, 0.00262808, 0.00249582,
  0.00236136, 0.00222484, 0.0020864, 0.00194616, 0.00180427,
  0.00166086, 0.00151607, 0.00137001, 0.00122282, 0.00107464,
  0.000925591, 0.000775795, 0.000625381, 0.000474473, 0.000323193,
  0.000171661, 1.99958e-05, -0.000131684, -0.000283264, -0.00043463,
  -0.000585671, -0.000736275, -0.000886336, -0.00103575, -0.0011844,
  -0.0013322, -0.00147905, -0.00162483, -0.00176947, -0.00191287,
  -0.00205493, -0.00219556, -0.00233468, -0.0024722, -0.00260805,
  -0.00274213, -0.00287437, -0.00300469, -0.00313303, -0.0032593,
  -0.00338345, -0.00350539, -0.00362508, -0.00374243, -0.0038574,
  -0.00396993, -0.00407996, -0.00418743, -0.0042923, -0.00439451,
  -0.00449402, -0.00459078, -0.00468476, -0.0047759, -0.00486418,
  -0.00494955, -0.00503199, -0.00511145, -0.00518792, -0.00526136,
  -0.00533174, -0.00539905, -0.00546325, -0.00552434, -0.0055823,
  -0.0056371, -0.00568874, -0.0057372, -0.00578247, -0.00582454,
  -0.00586342, -0.00589908, -0.00593154, -0.00596079, -0.00598683,
  -0.00600966, -0.00602929, -0.00604572, -0.00605897, -0.00606903,
  -0.00607592, -0.00607966, -0.00608025, -0.00607771, -0.00607206,
  -0.00606331, -0.00605149, -0.00603662, -0.00601871, -0.00599779,
  -0.00597389, -0.00594703, -0.00591723, -0.00588454, -0.00584897,
  -0.00581055, -0.00576932, -0.00572532, -0.00567857, -0.0056291,
  -0.00557696, -0.00552218, -0.0054648, -0.00540486, -0.0053424,
  -0.00527745, -0.00521005, -0.00514026, -0.0050681, -0.00499364,
  -0.00491689, -0.00483792, -0.00475677, -0.00467348, -0.0045881,
  -0.00450068, -0.00441126, -0.00431989, -0.00422662, -0.0041315,
  -0.00403457, -0.00393589, -0.0038355, -0.00373347, -0.00362982,
  -0.00352463, -0.00341793, -0.00330979, -0.00320024, -0.00308935,
  -0.00297716, -0.00286372, -0.0027491, -0.00263333, -0.00251648,
  -0.00239859, -0.00227972, -0.00215991, -0.00203923, -0.00191772,
  -0.00179544, -0.00167243, -0.00154876, -0.00142446, -0.0012996,
  -0.00117422, -0.00104838, -0.000922129, -0.000795514, -0.000668588,
  -0.000541401, -0.000414004, -0.000286447, -0.00015878, -3.10513e-05,
  9.66891e-05, 0.000224393, 0.000352011, 0.000479496, 0.000606801,
  0.000733877, 0.000860678, 0.000987158, 0.00111327, 0.00123897,
  0.00136421, 0.00148895, 0.00161314, 0.00173675, 0.00185971,
  0.00198201, 0.00210358, 0.0022244, 0.00234441, 0.00246358,
  0.00258187, 0.00269924, 0.00281565, 0.00293107, 0.00304544,
  0.00315875, 0.00327095, 0.003382, 0.00349188, 0.00360054,
  0.00370795, 0.00381408, 0.0039189, 0.00402237, 0.00412446,
  0.00422515, 0.0043244, 0.00442218, 0.00451847, 0.00461323,
  0.00470645, 0.00479808, 0.00488811, 0.00497652, 0.00506327,
  0.00514834, 0.00523172, 0.00531337, 0.00539328, 0.00547142,
  0.00554777, 0.00562232, 0.00569505, 0.00576593, 0.00583495,
  0.0059021, 0.00596735, 0.00603069, 0.00609211, 0.00615158,
  0.00620911, 0.00626468, 0.00631826, 0.00636986, 0.00641946,
  0.00646705, 0.00651263, 0.00655618, 0.00659769, 0.00663716,
  0.00667458, 0.00670995, 0.00674326, 0.0067745, 0.00680368,
  0.00683078, 0.00685581, 0.00687876, 0.00689963, 0.00691843,
  0.00693514, 0.00694978, 0.00696233, 0.00697281, 0.00698122,
  0.00698756, 0.00699183, 0.00699403, 0.00699418, 0.00699227,
  0.00698831, 0.00698231, 0.00697428, 0.00696422, 0.00695214,
  0.00693805, 0.00692196, 0.00690387, 0.0068838, 0.00686176,
  0.00683777, 0.00681182, 0.00678393, 0.00675412, 0.00672241,
  0.00668879, 0.00665329, 0.00661592, 0.0065767, 0.00653564,
  0.00649276, 0.00644807, 0.00640159, 0.00635334, 0.00630333,
  0.00625159, 0.00619812, 0.00614296, 0.00608612, 0.00602761,
  0.00596746, 0.0059057, 0.00584233, 0.00577737, 0.00571086,
  0.00564282, 0.00557325, 0.0055022, 0.00542967, 0.00535569,
  0.00528028, 0.00520348, 0.00512529, 0.00504575, 0.00496488,
  0.0048827, 0.00479924, 0.00471451, 0.00462856, 0.0045414,
  0.00445305, 0.00436355, 0.00427292, 0.00418118, 0.00408836,
  0.00399449, 0.00389959, 0.0038037, 0.00370682, 0.00360901,
  0.00351027, 0.00341064, 0.00331014, 0.0032088, 0.00310666,
  0.00300373, 0.00290004, 0.00279563, 0.00269052, 0.00258473,
  0.0024783, 0.00237125, 0.00226361, 0.00215541, 0.00204668,
  0.00193744, 0.00182772, 0.00171756, 0.00160697, 0.00149599,
  0.00138464, 0.00127295, 0.00116096, 0.00104868, 0.000936147,
  0.000823389, 0.000710431, 0.000597302, 0.000484029, 0.000370641,
  0.000257163, 0.000143624, 3.00501e-05, -8.35305e-05, -0.000197091,
  -0.000310605, -0.000424045, -0.000537386, -0.000650599,
  -0.000763659, -0.000876539, -0.000989213, -0.00110166, -0.00121384,
  -0.00132574, -0.00143734, -0.0015486, -0.0016595, -0.00177001,
  -0.00188012, -0.00198979, -0.002099, -0.00220773, -0.00231596,
  -0.00242365, -0.00253079, -0.00263736, -0.00274332, -0.00284866,
  -0.00295335, -0.00305737, -0.0031607, -0.00326332, -0.0033652,
  -0.00346633, -0.00356668, -0.00366622, -0.00376495, -0.00386284,
  -0.00395986, -0.00405601, -0.00415125, -0.00424558, -0.00433896,
  -0.00443139, -0.00452284, -0.00461329, -0.00470273, -0.00479113,
  -0.00487849, -0.00496478, -0.00504999, -0.00513409, -0.00521708,
  -0.00529894, -0.00537965, -0.00545919, -0.00553756, -0.00561473,
  -0.00569069, -0.00576543, -0.00583893, -0.00591118, -0.00598217,
  -0.00605188, -0.0061203, -0.00618741, -0.00625322, -0.00631769,
  -0.00638083, -0.00644262, -0.00650305, -0.00656211, -0.00661979,
  -0.00667608, -0.00673097, -0.00678446, -0.00683652, -0.00688716,
  -0.00693636, -0.00698412, -0.00703043, -0.00707529, -0.00711868,
  -0.00716059, -0.00720103, -0.00723999, -0.00727746, -0.00731344,
  -0.00734791, -0.00738088, -0.00741235, -0.0074423, -0.00747074,
  -0.00749765, -0.00752305, -0.00754691, -0.00756925, -0.00759006,
  -0.00760934, -0.00762709, -0.0076433, -0.00765798, -0.00767112,
  -0.00768272, -0.00769279, -0.00770132, -0.00770831, -0.00771378,
  -0.00771771, -0.0077201, -0.00772097, -0.00772031, -0.00771812,
  -0.00771442, -0.00770919, -0.00770245, -0.00769419, -0.00768443,
  -0.00767316, -0.00766039, -0.00764612, -0.00763037, -0.00761313,
  -0.00759441, -0.00757421, -0.00755255, -0.00752942, -0.00750485,
  -0.00747882, -0.00745135, -0.00742245, -0.00739212, -0.00736038,
  -0.00732722, -0.00729266, -0.00725671, -0.00721938, -0.00718067,
  -0.00714059, -0.00709916, -0.00705638, -0.00701227, -0.00696683,
  -0.00692007, -0.00687201, -0.00682265, -0.00677201, -0.0067201,
  -0.00666693, -0.00661251, -0.00655685, -0.00649996, -0.00644187,
  -0.00638257, -0.00632209, -0.00626044, -0.00619762, -0.00613365,
  -0.00606855, -0.00600233, -0.005935, -0.00586657, -0.00579707,
  -0.0057265, -0.00565488, -0.00558223, -0.00550855, -0.00543387,
  -0.00535819, -0.00528154, -0.00520392, -0.00512536, -0.00504587,
  -0.00496547, -0.00488416, -0.00480197, -0.00471892, -0.00463501,
  -0.00455027, -0.00446471, -0.00437834, -0.00429119, -0.00420328,
  -0.00411461, -0.0040252, -0.00393508, -0.00384425, -0.00375274,
  -0.00366056, -0.00356773, -0.00347427, -0.0033802, -0.00328552,
  -0.00319027, -0.00309445, -0.00299808, -0.00290119, -0.00280379,
  -0.0027059, -0.00260753, -0.0025087, -0.00240944, -0.00230975,
  -0.00220967, -0.00210919, -0.00200835, -0.00190716, -0.00180564,
  -0.00170381, -0.00160168, -0.00149927, -0.0013966, -0.0012937,
  -0.00119057, -0.00108723, -0.000983711, -0.00088002, -0.000776179,
  -0.000672204, -0.000568114, -0.000463927, -0.000359661,
  -0.000255333, -0.000150962, -4.65657e-05, 5.7839e-05, 0.000162234,
  0.000266601, 0.000370924, 0.000475183, 0.000579363, 0.000683444,
  0.000787411, 0.000891245, 0.000994929, 0.00109845, 0.00120178,
  0.00130491, 0.00140782, 0.0015105, 0.00161293, 0.00171508,
  0.00181696, 0.00191852, 0.00201977, 0.00212069, 0.00222125,
  0.00232145, 0.00242126, 0.00252067, 0.00261967, 0.00271823,
  0.00281634, 0.002914, 0.00301117, 0.00310785, 0.00320402,
  0.00329967, 0.00339477, 0.00348932, 0.0035833, 0.0036767, 0.0037695,
  0.00386168, 0.00395324, 0.00404416, 0.00413442, 0.00422401,
  0.00431292, 0.00440113, 0.00448863, 0.0045754, 0.00466144,
  0.00474673, 0.00483126, 0.00491501, 0.00499797, 0.00508013,
  0.00516148, 0.005242, 0.00532169, 0.00540053, 0.00547851,
  0.00555561, 0.00563183, 0.00570716, 0.00578158, 0.00585508,
  0.00592766, 0.0059993, 0.00606999, 0.00613973, 0.00620849,
  0.00627628, 0.00634308, 0.00640888, 0.00647368, 0.00653746,
  0.00660022, 0.00666194, 0.00672263, 0.00678226, 0.00684083,
  0.00689834, 0.00695477, 0.00701012, 0.00706438, 0.00711755,
  0.00716961, 0.00722056, 0.00727039, 0.0073191, 0.00736668,
  0.00741312, 0.00745842, 0.00750257, 0.00754556, 0.0075874,
  0.00762807, 0.00766757, 0.00770589, 0.00774304, 0.007779,
  0.00781377, 0.00784735, 0.00787973, 0.00791092, 0.0079409,
  0.00796967, 0.00799723, 0.00802358, 0.00804871, 0.00807262,
  0.00809531, 0.00811678, 0.00813702, 0.00815604, 0.00817382,
  0.00819038, 0.0082057, 0.00821979, 0.00823265, 0.00824427,
  0.00825465, 0.0082638, 0.00827172, 0.0082784, 0.00828384,
  0.00828804, 0.00829102, 0.00829275, 0.00829326, 0.00829253,
  0.00829057, 0.00828739, 0.00828297, 0.00827733, 0.00827046,
  0.00826237, 0.00825307, 0.00824254, 0.0082308, 0.00821785,
  0.0082037, 0.00818833, 0.00817176, 0.008154, 0.00813504, 0.00811489,
  0.00809355, 0.00807103, 0.00804734, 0.00802247, 0.00799642,
  0.00796922, 0.00794086, 0.00791134, 0.00788067, 0.00784886,
  0.00781591, 0.00778183, 0.00774663, 0.0077103, 0.00767286,
  0.00763432, 0.00759467, 0.00755393, 0.0075121, 0.0074692,
  0.00742522, 0.00738017, 0.00733406, 0.00728691, 0.00723871,
  0.00718948, 0.00713921, 0.00708793, 0.00703564, 0.00698235,
  0.00692806, 0.00687278, 0.00681653, 0.00675931, 0.00670113,
  0.006642, 0.00658193, 0.00652093, 0.006459, 0.00639617, 0.00633243,
  0.00626779, 0.00620227, 0.00613588, 0.00606863, 0.00600052,
  0.00593157, 0.00586179, 0.00579118, 0.00571977, 0.00564755,
  0.00557454, 0.00550076, 0.0054262, 0.00535089, 0.00527483,
  0.00519804, 0.00512052, 0.00504229, 0.00496336, 0.00488375,
  0.00480345, 0.00472249, 0.00464087, 0.00455861, 0.00447572,
  0.00439222, 0.0043081, 0.0042234, 0.00413811, 0.00405225,
  0.00396583, 0.00387887, 0.00379137, 0.00370335, 0.00361483,
  0.00352581, 0.00343631, 0.00334633, 0.0032559, 0.00316503,
  0.00307372, 0.00298199, 0.00288986, 0.00279733, 0.00270443,
  0.00261115, 0.00251752, 0.00242355, 0.00232925, 0.00223463,
  0.00213972, 0.00204451, 0.00194902, 0.00185327, 0.00175728,
  0.00166104, 0.00156458, 0.00146791, 0.00137104, 0.00127399,
  0.00117677, 0.00107938, 0.000981858, 0.0008842, 0.000786423,
  0.000688541, 0.000590567, 0.000492514, 0.000394396, 0.000296224,
  0.000198014, 9.97764e-05, 1.52595e-06, -9.67247e-05, -0.000194962,
  -0.000293174, -0.000391347, -0.000489468, -0.000587524,
  -0.000685502, -0.00078339, -0.000881174, -0.000978841, -0.00107638,
  -0.00117377, -0.00127102, -0.00136809, -0.00146498, -0.00156168,
  -0.00165818, -0.00175445, -0.0018505, -0.0019463, -0.00204185,
  -0.00213713, -0.00223213, -0.00232684, -0.00242125, -0.00251534,
  -0.0026091, -0.00270251, -0.00279558, -0.00288828, -0.00298061,
  -0.00307255, -0.00316409, -0.00325522, -0.00334592, -0.00343619,
  -0.00352602, -0.00361539, -0.00370429, -0.00379271, -0.00388064,
  -0.00396807, -0.00405499, -0.00414138, -0.00422724, -0.00431256,
  -0.00439732, -0.00448151, -0.00456513, -0.00464816, -0.00473059,
  -0.00481242, -0.00489363, -0.00497422, -0.00505416, -0.00513346,
  -0.00521211, -0.00529009, -0.00536739, -0.005444, -0.00551993,
  -0.00559515, -0.00566965, -0.00574344, -0.00581649, -0.00588881,
  -0.00596038, -0.00603119, -0.00610124, -0.00617051, -0.006239,
  -0.0063067, -0.00637361, -0.0064397, -0.00650499, -0.00656945,
  -0.00663309, -0.00669589, -0.00675784, -0.00681894, -0.00687919,
  -0.00693857, -0.00699708, -0.00705471, -0.00711145, -0.00716731,
  -0.00722226, -0.00727631, -0.00732945, -0.00738167, -0.00743297,
  -0.00748334, -0.00753277, -0.00758127, -0.00762882, -0.00767542,
  -0.00772107, -0.00776575, -0.00780947, -0.00785221, -0.00789398,
  -0.00793478, -0.00797458, -0.0080134, -0.00805123, -0.00808805,
  -0.00812388, -0.0081587, -0.00819252, -0.00822532, -0.00825711,
  -0.00828788, -0.00831762, -0.00834634, -0.00837404, -0.0084007,
  -0.00842633, -0.00845093, -0.00847448, -0.008497, -0.00851847,
  -0.0085389, -0.00855829, -0.00857662, -0.00859391, -0.00861014,
  -0.00862532, -0.00863945, -0.00865253, -0.00866454, -0.00867551,
  -0.00868541, -0.00869426, -0.00870204, -0.00870877, -0.00871445,
  -0.00871906, -0.00872261, -0.00872511, -0.00872654, -0.00872692,
  -0.00872624, -0.00872451, -0.00872172, -0.00871787, -0.00871298,
  -0.00870703, -0.00870002, -0.00869197, -0.00868287, -0.00867273,
  -0.00866154, -0.00864931, -0.00863603, -0.00862172, -0.00860638,
  -0.00858999, -0.00857258, -0.00855414, -0.00853468, -0.00851419,
  -0.00849269, -0.00847016, -0.00844663, -0.00842208, -0.00839653,
  -0.00836997, -0.00834242, -0.00831387, -0.00828433, -0.00825381,
  -0.0082223, -0.00818981, -0.00815635, -0.00812192, -0.00808653,
  -0.00805017, -0.00801286, -0.0079746, -0.0079354, -0.00789525,
  -0.00785417, -0.00781216, -0.00776923, -0.00772538, -0.00768061,
  -0.00763494, -0.00758837, -0.0075409, -0.00749255, -0.00744331,
  -0.00739319, -0.00734221, -0.00729036, -0.00723765, -0.0071841,
  -0.0071297, -0.00707446, -0.00701839, -0.0069615, -0.0069038,
  -0.00684529, -0.00678597, -0.00672586, -0.00666497, -0.0066033,
  -0.00654085, -0.00647764, -0.00641368, -0.00634897, -0.00628351,
  -0.00621733, -0.00615042, -0.0060828, -0.00601447, -0.00594544,
  -0.00587572, -0.00580531, -0.00573424, -0.00566249, -0.00559009,
  -0.00551705, -0.00544336, -0.00536905, -0.00529411, -0.00521856,
  -0.00514241, -0.00506566, -0.00498833, -0.00491042, -0.00483195,
  -0.00475292, -0.00467334, -0.00459322, -0.00451258, -0.00443141,
  -0.00434974, -0.00426757, -0.0041849, -0.00410176, -0.00401814,
  -0.00393406, -0.00384954, -0.00376457, -0.00367917, -0.00359335,
  -0.00350711, -0.00342048, -0.00333346, -0.00324605, -0.00315827,
  -0.00307014, -0.00298165, -0.00289282, -0.00280367, -0.00271419,
  -0.00262441, -0.00253432, -0.00244395, -0.0023533, -0.00226238,
  -0.00217121, -0.00207979, -0.00198813, -0.00189625, -0.00180415,
  -0.00171185, -0.00161936, -0.00152668, -0.00143383, -0.00134081,
  -0.00124765, -0.00115434, -0.0010609, -0.000967347, -0.000873681,
  -0.000779917, -0.000686065, -0.000592135, -0.000498139,
  -0.000404087, -0.000309989, -0.000215856, -0.000121699,
  -2.75289e-05, 6.66448e-05, 0.000160811, 0.000254959, 0.000349079,
  0.000443159, 0.00053719, 0.000631161, 0.000725061, 0.00081888,
  0.000912607, 0.00100623, 0.00109975, 0.00119314, 0.00128639,
  0.00137951, 0.00147247, 0.00156526, 0.00165788, 0.00175032,
  0.00184256, 0.0019346, 0.00202642, 0.00211801, 0.00220938,
  0.00230049, 0.00239135, 0.00248195, 0.00257226, 0.0026623,
  0.00275204, 0.00284147, 0.00293059, 0.00301939, 0.00310785,
  0.00319596, 0.00328373, 0.00337113, 0.00345816, 0.00354481,
  0.00363106, 0.00371692, 0.00380236, 0.00388739, 0.00397199,
  0.00405615, 0.00413986, 0.00422312, 0.00430592, 0.00438824,
  0.00447008, 0.00455143, 0.00463228, 0.00471262, 0.00479244,
  0.00487174, 0.0049505, 0.00502872, 0.00510639, 0.00518351,
  0.00526005, 0.00533602, 0.00541141, 0.0054862, 0.0055604,
  0.00563399, 0.00570696, 0.00577931, 0.00585103, 0.00592211,
  0.00599255, 0.00606234, 0.00613146, 0.00619992, 0.0062677,
  0.0063348, 0.00640122, 0.00646693, 0.00653195, 0.00659626,
  0.00665985, 0.00672271, 0.00678485, 0.00684626, 0.00690692,
  0.00696683, 0.00702599, 0.00708439, 0.00714202, 0.00719888,
  0.00725497, 0.00731026, 0.00736477, 0.00741849, 0.0074714,
  0.00752351, 0.0075748, 0.00762528, 0.00767494, 0.00772377,
  0.00777177, 0.00781894, 0.00786526, 0.00791074, 0.00795536,
  0.00799913, 0.00804204, 0.00808409, 0.00812527, 0.00816558,
  0.00820502, 0.00824357, 0.00828124, 0.00831802, 0.00835391,
  0.00838891, 0.00842301, 0.00845621, 0.00848851, 0.0085199,
  0.00855037, 0.00857994, 0.00860859, 0.00863631, 0.00866312,
  0.00868901, 0.00871396, 0.00873799, 0.00876109, 0.00878326,
  0.00880449, 0.00882478, 0.00884414, 0.00886255, 0.00888002,
  0.00889655, 0.00891214, 0.00892677, 0.00894046, 0.00895321,
  0.008965, 0.00897584, 0.00898573, 0.00899467, 0.00900265,
  0.00900968, 0.00901576, 0.00902089, 0.00902506, 0.00902828,
  0.00903054, 0.00903185, 0.0090322, 0.0090316, 0.00903005,
  0.00902754, 0.00902409, 0.00901968, 0.00901432, 0.00900801,
  0.00900076, 0.00899255, 0.0089834, 0.0089733, 0.00896226,
  0.00895028, 0.00893736, 0.0089235, 0.0089087, 0.00889296,
  0.00887629, 0.0088587, 0.00884017, 0.00882071, 0.00880033,
  0.00877903, 0.00875681, 0.00873367, 0.00870962, 0.00868466,
  0.00865878, 0.00863201, 0.00860433, 0.00857575, 0.00854627,
  0.00851591, 0.00848465, 0.00845251, 0.00841949, 0.00838558,
  0.00835081, 0.00831516, 0.00827865, 0.00824128, 0.00820304,
  0.00816396, 0.00812402, 0.00808324, 0.00804162, 0.00799916,
  0.00795587, 0.00791176, 0.00786682, 0.00782107, 0.0077745,
  0.00772713, 0.00767895, 0.00762998, 0.00758022, 0.00752968,
  0.00747835, 0.00742625, 0.00737338, 0.00731975, 0.00726536,
  0.00721022, 0.00715433, 0.00709771, 0.00704035, 0.00698226,
  0.00692345, 0.00686393, 0.0068037, 0.00674276, 0.00668114,
  0.00661882, 0.00655582, 0.00649214, 0.0064278, 0.00636279,
  0.00629713, 0.00623082, 0.00616387, 0.00609629, 0.00602808,
  0.00595925, 0.0058898, 0.00581975, 0.00574911, 0.00567787,
  0.00560605, 0.00553366, 0.0054607, 0.00538717, 0.0053131,
  0.00523848, 0.00516332, 0.00508764, 0.00501143, 0.00493471,
  0.00485749, 0.00477977, 0.00470156, 0.00462287, 0.00454371,
  0.00446408, 0.00438399, 0.00430346, 0.00422249, 0.00414109,
  0.00405927, 0.00397703, 0.00389438, 0.00381134, 0.00372791,
  0.0036441, 0.00355992, 0.00347538, 0.00339048, 0.00330523,
  0.00321966, 0.00313375, 0.00304752, 0.00296099, 0.00287415,
  0.00278702, 0.00269961, 0.00261192, 0.00252397, 0.00243577,
  0.00234731, 0.00225862, 0.0021697, 0.00208055, 0.0019912,
  0.00190165, 0.0018119, 0.00172197, 0.00163186, 0.00154159,
  0.00145117, 0.00136059, 0.00126988, 0.00117904, 0.00108808,
  0.000997015, 0.000905846, 0.000814585, 0.000723242, 0.000631825,
  0.000540345, 0.000448811, 0.000357231, 0.000265615, 0.000173973,
  8.23124e-05, -9.35602e-06, -0.000101023, -0.000192681, -0.000284319,
  -0.000375928, -0.000467499, -0.000559023, -0.000650491,
  -0.000741894, -0.000833222, -0.000924466, -0.00101562, -0.00110667,
  -0.0011976, -0.00128842, -0.00137911, -0.00146966, -0.00156006,
  -0.00165031, -0.00174039, -0.00183029, -0.00192001, -0.00200954,
  -0.00209887, -0.00218799, -0.00227689, -0.00236556, -0.00245399,
  -0.00254218, -0.00263011, -0.00271778, -0.00280518, -0.0028923,
  -0.00297913, -0.00306566, -0.00315188, -0.00323779, -0.00332338,
  -0.00340863, -0.00349354, -0.00357811, -0.00366232, -0.00374616,
  -0.00382963, -0.00391271, -0.00399541, -0.00407771, -0.0041596,
  -0.00424107, -0.00432213, -0.00440275, -0.00448294, -0.00456268,
  -0.00464196, -0.00472079, -0.00479914, -0.00487701, -0.0049544,
  -0.0050313, -0.0051077, -0.00518359, -0.00525897, -0.00533382,
  -0.00540814, -0.00548193, -0.00555517, -0.00562786, -0.00569999,
  -0.00577156, -0.00584255, -0.00591297, -0.0059828, -0.00605203,
  -0.00612067, -0.0061887, -0.00625611, -0.00632291, -0.00638908,
  -0.00645462, -0.00651952, -0.00658377, -0.00664737, -0.00671032,
  -0.0067726, -0.00683421, -0.00689515, -0.0069554, -0.00701497,
  -0.00707384, -0.00713202, -0.00718949, -0.00724625, -0.0073023,
  -0.00735762, -0.00741222, -0.00746609, -0.00751922, -0.00757161,
  -0.00762325, -0.00767415, -0.00772428, -0.00777366, -0.00782227,
  -0.0078701, -0.00791717, -0.00796345, -0.00800895, -0.00805366,
  -0.00809758, -0.0081407, -0.00818302, -0.00822454, -0.00826525,
  -0.00830514, -0.00834422, -0.00838248, -0.00841991, -0.00845652,
  -0.0084923, -0.00852724, -0.00856135, -0.00859462, -0.00862704,
  -0.00865861, -0.00868934, -0.00871921, -0.00874823, -0.00877639,
  -0.00880369, -0.00883013, -0.0088557, -0.00888041, -0.00890424,
  -0.00892721, -0.00894929, -0.00897051, -0.00899084, -0.00901029,
  -0.00902887, -0.00904655, -0.00906336, -0.00907928, -0.0090943,
  -0.00910844, -0.00912169, -0.00913405, -0.00914552, -0.00915609,
  -0.00916577, -0.00917455, -0.00918243, -0.00918942, -0.00919552,
  -0.00920071, -0.00920501, -0.00920841, -0.00921091, -0.00921251,
  -0.00921321, -0.00921302, -0.00921192, -0.00920993, -0.00920704,
  -0.00920326, -0.00919857, -0.00919299, -0.00918652, -0.00917915,
  -0.00917089, -0.00916173, -0.00915168, -0.00914075, -0.00912892,
  -0.0091162, -0.0091026, -0.00908811, -0.00907274, -0.00905649,
  -0.00903935, -0.00902134, -0.00900245, -0.00898268, -0.00896205,
  -0.00894054, -0.00891816, -0.00889492, -0.00887081, -0.00884585,
  -0.00882002, -0.00879334, -0.0087658, -0.00873742, -0.00870818,
  -0.00867811, -0.00864719, -0.00861543, -0.00858283, -0.00854941,
  -0.00851515, -0.00848008, -0.00844417, -0.00840745, -0.00836992,
  -0.00833158, -0.00829243, -0.00825247, -0.00821172, -0.00817017,
  -0.00812783, -0.0080847, -0.0080408, -0.00799611, -0.00795065,
  -0.00790442, -0.00785743, -0.00780968, -0.00776117, -0.00771191,
  -0.00766191, -0.00761116, -0.00755968, -0.00750747, -0.00745454,
  -0.00740088, -0.00734651, -0.00729143, -0.00723565, -0.00717917,
  -0.00712199, -0.00706413, -0.00700559, -0.00694637, -0.00688648,
  -0.00682592, -0.00676471, -0.00670284, -0.00664033, -0.00657718,
  -0.00651339, -0.00644898, -0.00638394, -0.00631829, -0.00625203,
  -0.00618516, -0.00611771, -0.00604966, -0.00598103, -0.00591182,
  -0.00584204, -0.00577171, -0.00570081, -0.00562937, -0.00555738,
  -0.00548487, -0.00541182, -0.00533825, -0.00526417, -0.00518958,
  -0.00511449, -0.00503891, -0.00496285, -0.00488631, -0.0048093,
  -0.00473183, -0.0046539, -0.00457552, -0.00449671, -0.00441746,
  -0.00433779, -0.0042577, -0.0041772, -0.00409631, -0.00401501,
  -0.00393334, -0.00385128, -0.00376886, -0.00368607, -0.00360293,
  -0.00351944, -0.00343562, -0.00335146, -0.00326699, -0.0031822,
  -0.00309711, -0.00301172, -0.00292604, -0.00284008, -0.00275384,
  -0.00266735, -0.00258059, -0.00249359, -0.00240635, -0.00231888,
  -0.00223119, -0.00214329, -0.00205517, -0.00196687, -0.00187837,
  -0.00178969, -0.00170084, -0.00161183, -0.00152267, -0.00143336,
  -0.00134391, -0.00125433, -0.00116463, -0.00107483, -0.000984914,
  -0.000894908, -0.000804817, -0.000714648, -0.000624411,
  -0.000534114, -0.000443767, -0.000353377, -0.000262952,
  -0.000172503, -8.20376e-05, 8.43601e-06, 9.89088e-05, 0.000189372,
  0.000279817, 0.000370236, 0.000460619, 0.000550958, 0.000641245,
  0.00073147, 0.000821625, 0.000911702, 0.00100169, 0.00109159,
  0.00118138, 0.00127105, 0.00136061, 0.00145003, 0.00153932,
  0.00162846, 0.00171745, 0.00180627, 0.00189491, 0.00198338,
  0.00207166, 0.00215974, 0.00224761, 0.00233527, 0.00242271,
  0.00250992, 0.00259688, 0.0026836, 0.00277006, 0.00285626,
  0.00294219, 0.00302783, 0.00311319, 0.00319825, 0.003283,
  0.00336744, 0.00345156, 0.00353535, 0.00361881, 0.00370192,
  0.00378467, 0.00386707, 0.00394909, 0.00403074, 0.00411201,
  0.00419288, 0.00427336, 0.00435343, 0.00443308, 0.00451231,
  0.00459111, 0.00466947, 0.00474739, 0.00482485, 0.00490186,
  0.0049784, 0.00505446, 0.00513005, 0.00520514, 0.00527974,
  0.00535384, 0.00542742, 0.00550049, 0.00557304, 0.00564506,
  0.00571653, 0.00578747, 0.00585785, 0.00592767, 0.00599694,
  0.00606563, 0.00613374, 0.00620127, 0.00626821, 0.00633455,
  0.00640029, 0.00646542, 0.00652993, 0.00659383, 0.00665709,
  0.00671973, 0.00678172, 0.00684307, 0.00690376, 0.0069638,
  0.00702318, 0.00708189, 0.00713993, 0.00719729, 0.00725396,
  0.00730994, 0.00736523, 0.00741982, 0.0074737, 0.00752687,
  0.00757932, 0.00763106, 0.00768207, 0.00773234, 0.00778189,
  0.00783069, 0.00787875, 0.00792606, 0.00797261, 0.00801841,
  0.00806345, 0.00810772, 0.00815121, 0.00819394, 0.00823588,
  0.00827704, 0.00831742, 0.008357, 0.00839579, 0.00843379,
  0.00847098, 0.00850736, 0.00854294, 0.0085777, 0.00861165,
  0.00864478, 0.00867709, 0.00870858, 0.00873924, 0.00876906,
  0.00879806, 0.00882622, 0.00885354, 0.00888001, 0.00890565,
  0.00893044, 0.00895438, 0.00897746, 0.0089997, 0.00902108,
  0.0090416, 0.00906127, 0.00908007, 0.00909801, 0.00911509,
  0.0091313, 0.00914664, 0.00916112, 0.00917472, 0.00918745,
  0.00919931, 0.0092103, 0.00922041, 0.00922964, 0.009238, 0.00924548,
  0.00925208, 0.0092578, 0.00926264, 0.00926661, 0.00926969,
  0.00927189, 0.00927321, 0.00927366, 0.00927321, 0.00927189,
  0.00926969, 0.00926661, 0.00926264, 0.0092578, 0.00925208,
  0.00924548, 0.009238, 0.00922964, 0.00922041, 0.0092103, 0.00919931,
  0.00918745, 0.00917472, 0.00916112, 0.00914664, 0.0091313,
  0.00911509, 0.00909801, 0.00908007, 0.00906127, 0.0090416,
  0.00902108, 0.0089997, 0.00897746, 0.00895438, 0.00893044,
  0.00890565, 0.00888001, 0.00885354, 0.00882622, 0.00879806,
  0.00876906, 0.00873924, 0.00870858, 0.00867709, 0.00864478,
  0.00861165, 0.0085777, 0.00854294, 0.00850736, 0.00847098,
  0.00843379, 0.00839579, 0.008357, 0.00831742, 0.00827704,
  0.00823588, 0.00819394, 0.00815121, 0.00810772, 0.00806345,
  0.00801841, 0.00797261, 0.00792606, 0.00787875, 0.00783069,
  0.00778189, 0.00773234, 0.00768207, 0.00763106, 0.00757932,
  0.00752687, 0.0074737, 0.00741982, 0.00736523, 0.00730994,
  0.00725396, 0.00719729, 0.00713993, 0.00708189, 0.00702318,
  0.0069638, 0.00690376, 0.00684307, 0.00678172, 0.00671973,
  0.00665709, 0.00659383, 0.00652993, 0.00646542, 0.00640029,
  0.00633455, 0.00626821, 0.00620127, 0.00613374, 0.00606563,
  0.00599694, 0.00592767, 0.00585785, 0.00578747, 0.00571653,
  0.00564506, 0.00557304, 0.00550049, 0.00542742, 0.00535384,
  0.00527974, 0.00520514, 0.00513005, 0.00505446, 0.0049784,
  0.00490186, 0.00482485, 0.00474739, 0.00466947, 0.00459111,
  0.00451231, 0.00443308, 0.00435343, 0.00427336, 0.00419288,
  0.00411201, 0.00403074, 0.00394909, 0.00386707, 0.00378467,
  0.00370192, 0.00361881, 0.00353535, 0.00345156, 0.00336744,
  0.003283, 0.00319825, 0.00311319, 0.00302783, 0.00294219,
  0.00285626, 0.00277006, 0.0026836, 0.00259688, 0.00250992,
  0.00242271, 0.00233527, 0.00224761, 0.00215974, 0.00207166,
  0.00198338, 0.00189491, 0.00180627, 0.00171745, 0.00162846,
  0.00153932, 0.00145003, 0.00136061, 0.00127105, 0.00118138,
  0.00109159, 0.00100169, 0.000911702, 0.000821625, 0.00073147,
  0.000641245, 0.000550958, 0.000460619, 0.000370236, 0.000279817,
  0.000189372, 9.89088e-05, 8.43601e-06, -8.20376e-05, -0.000172503,
  -0.000262952, -0.000353377, -0.000443767, -0.000534114,
  -0.000624411, -0.000714648, -0.000804817, -0.000894908,
  -0.000984914, -0.00107483, -0.00116463, -0.00125433, -0.00134391,
  -0.00143336, -0.00152267, -0.00161183, -0.00170084, -0.00178969,
  -0.00187837, -0.00196687, -0.00205517, -0.00214329, -0.00223119,
  -0.00231888, -0.00240635, -0.00249359, -0.00258059, -0.00266735,
  -0.00275384, -0.00284008, -0.00292604, -0.00301172, -0.00309711,
  -0.0031822, -0.00326699, -0.00335146, -0.00343562, -0.00351944,
  -0.00360293, -0.00368607, -0.00376886, -0.00385128, -0.00393334,
  -0.00401501, -0.00409631, -0.0041772, -0.0042577, -0.00433779,
  -0.00441746, -0.00449671, -0.00457552, -0.0046539, -0.00473183,
  -0.0048093, -0.00488631, -0.00496285, -0.00503891, -0.00511449,
  -0.00518958, -0.00526417, -0.00533825, -0.00541182, -0.00548487,
  -0.00555738, -0.00562937, -0.00570081, -0.00577171, -0.00584204,
  -0.00591182, -0.00598103, -0.00604966, -0.00611771, -0.00618516,
  -0.00625203, -0.00631829, -0.00638394, -0.00644898, -0.00651339,
  -0.00657718, -0.00664033, -0.00670284, -0.00676471, -0.00682592,
  -0.00688648, -0.00694637, -0.00700559, -0.00706413, -0.00712199,
  -0.00717917, -0.00723565, -0.00729143, -0.00734651, -0.00740088,
  -0.00745454, -0.00750747, -0.00755968, -0.00761116, -0.00766191,
  -0.00771191, -0.00776117, -0.00780968, -0.00785743, -0.00790442,
  -0.00795065, -0.00799611, -0.0080408, -0.0080847, -0.00812783,
  -0.00817017, -0.00821172, -0.00825247, -0.00829243, -0.00833158,
  -0.00836992, -0.00840745, -0.00844417, -0.00848008, -0.00851515,
  -0.00854941, -0.00858283, -0.00861543, -0.00864719, -0.00867811,
  -0.00870818, -0.00873742, -0.0087658, -0.00879334, -0.00882002,
  -0.00884585, -0.00887081, -0.00889492, -0.00891816, -0.00894054,
  -0.00896205, -0.00898268, -0.00900245, -0.00902134, -0.00903935,
  -0.00905649, -0.00907274, -0.00908811, -0.0091026, -0.0091162,
  -0.00912892, -0.00914075, -0.00915168, -0.00916173, -0.00917089,
  -0.00917915, -0.00918652, -0.00919299, -0.00919857, -0.00920326,
  -0.00920704, -0.00920993, -0.00921192, -0.00921302, -0.00921321,
  -0.00921251, -0.00921091, -0.00920841, -0.00920501, -0.00920071,
  -0.00919552, -0.00918942, -0.00918243, -0.00917455, -0.00916577,
  -0.00915609, -0.00914552, -0.00913405, -0.00912169, -0.00910844,
  -0.0090943, -0.00907928, -0.00906336, -0.00904655, -0.00902887,
  -0.00901029, -0.00899084, -0.00897051, -0.00894929, -0.00892721,
  -0.00890424, -0.00888041, -0.0088557, -0.00883013, -0.00880369,
  -0.00877639, -0.00874823, -0.00871921, -0.00868934, -0.00865861,
  -0.00862704, -0.00859462, -0.00856135, -0.00852724, -0.0084923,
  -0.00845652, -0.00841991, -0.00838248, -0.00834422, -0.00830514,
  -0.00826525, -0.00822454, -0.00818302, -0.0081407, -0.00809758,
  -0.00805366, -0.00800895, -0.00796345, -0.00791717, -0.0078701,
  -0.00782227, -0.00777366, -0.00772428, -0.00767415, -0.00762325,
  -0.00757161, -0.00751922, -0.00746609, -0.00741222, -0.00735762,
  -0.0073023, -0.00724625, -0.00718949, -0.00713202, -0.00707384,
  -0.00701497, -0.0069554, -0.00689515, -0.00683421, -0.0067726,
  -0.00671032, -0.00664737, -0.00658377, -0.00651952, -0.00645462,
  -0.00638908, -0.00632291, -0.00625611, -0.0061887, -0.00612067,
  -0.00605203, -0.0059828, -0.00591297, -0.00584255, -0.00577156,
  -0.00569999, -0.00562786, -0.00555517, -0.00548193, -0.00540814,
  -0.00533382, -0.00525897, -0.00518359, -0.0051077, -0.0050313,
  -0.0049544, -0.00487701, -0.00479914, -0.00472079, -0.00464196,
  -0.00456268, -0.00448294, -0.00440275, -0.00432213, -0.00424107,
  -0.0041596, -0.00407771, -0.00399541, -0.00391271, -0.00382963,
  -0.00374616, -0.00366232, -0.00357811, -0.00349354, -0.00340863,
  -0.00332338, -0.00323779, -0.00315188, -0.00306566, -0.00297913,
  -0.0028923, -0.00280518, -0.00271778, -0.00263011, -0.00254218,
  -0.00245399, -0.00236556, -0.00227689, -0.00218799, -0.00209887,
  -0.00200954, -0.00192001, -0.00183029, -0.00174039, -0.00165031,
  -0.00156006, -0.00146966, -0.00137911, -0.00128842, -0.0011976,
  -0.00110667, -0.00101562, -0.000924466, -0.000833222, -0.000741894,
  -0.000650491, -0.000559023, -0.000467499, -0.000375928,
  -0.000284319, -0.000192681, -0.000101023, -9.35602e-06, 8.23124e-05,
  0.000173973, 0.000265615, 0.000357231, 0.000448811, 0.000540345,
  0.000631825, 0.000723242, 0.000814585, 0.000905846, 0.000997015,
  0.00108808, 0.00117904, 0.00126988, 0.00136059, 0.00145117,
  0.00154159, 0.00163186, 0.00172197, 0.0018119, 0.00190165,
  0.0019912, 0.00208055, 0.0021697, 0.00225862, 0.00234731,
  0.00243577, 0.00252397, 0.00261192, 0.00269961, 0.00278702,
  0.00287415, 0.00296099, 0.00304752, 0.00313375, 0.00321966,
  0.00330523, 0.00339048, 0.00347538, 0.00355992, 0.0036441,
  0.00372791, 0.00381134, 0.00389438, 0.00397703, 0.00405927,
  0.00414109, 0.00422249, 0.00430346, 0.00438399, 0.00446408,
  0.00454371, 0.00462287, 0.00470156, 0.00477977, 0.00485749,
  0.00493471, 0.00501143, 0.00508764, 0.00516332, 0.00523848,
  0.0053131, 0.00538717, 0.0054607, 0.00553366, 0.00560605,
  0.00567787, 0.00574911, 0.00581975, 0.0058898, 0.00595925,
  0.00602808, 0.00609629, 0.00616387, 0.00623082, 0.00629713,
  0.00636279, 0.0064278, 0.00649214, 0.00655582, 0.00661882,
  0.00668114, 0.00674276, 0.0068037, 0.00686393, 0.00692345,
  0.00698226, 0.00704035, 0.00709771, 0.00715433, 0.00721022,
  0.00726536, 0.00731975, 0.00737338, 0.00742625, 0.00747835,
  0.00752968, 0.00758022, 0.00762998, 0.00767895, 0.00772713,
  0.0077745, 0.00782107, 0.00786682, 0.00791176, 0.00795587,
  0.00799916, 0.00804162, 0.00808324, 0.00812402, 0.00816396,
  0.00820304, 0.00824128, 0.00827865, 0.00831516, 0.00835081,
  0.00838558, 0.00841949, 0.00845251, 0.00848465, 0.00851591,
  0.00854627, 0.00857575, 0.00860433, 0.00863201, 0.00865878,
  0.00868466, 0.00870962, 0.00873367, 0.00875681, 0.00877903,
  0.00880033, 0.00882071, 0.00884017, 0.0088587, 0.00887629,
  0.00889296, 0.0089087, 0.0089235, 0.00893736, 0.00895028,
  0.00896226, 0.0089733, 0.0089834, 0.00899255, 0.00900076,
  0.00900801, 0.00901432, 0.00901968, 0.00902409, 0.00902754,
  0.00903005, 0.0090316, 0.0090322, 0.00903185, 0.00903054,
  0.00902828, 0.00902506, 0.00902089, 0.00901576, 0.00900968,
  0.00900265, 0.00899467, 0.00898573, 0.00897584, 0.008965,
  0.00895321, 0.00894046, 0.00892677, 0.00891214, 0.00889655,
  0.00888002, 0.00886255, 0.00884414, 0.00882478, 0.00880449,
  0.00878326, 0.00876109, 0.00873799, 0.00871396, 0.00868901,
  0.00866312, 0.00863631, 0.00860859, 0.00857994, 0.00855037,
  0.0085199, 0.00848851, 0.00845621, 0.00842301, 0.00838891,
  0.00835391, 0.00831802, 0.00828124, 0.00824357, 0.00820502,
  0.00816558, 0.00812527, 0.00808409, 0.00804204, 0.00799913,
  0.00795536, 0.00791074, 0.00786526, 0.00781894, 0.00777177,
  0.00772377, 0.00767494, 0.00762528, 0.0075748, 0.00752351,
  0.0074714, 0.00741849, 0.00736477, 0.00731026, 0.00725497,
  0.00719888, 0.00714202, 0.00708439, 0.00702599, 0.00696683,
  0.00690692, 0.00684626, 0.00678485, 0.00672271, 0.00665985,
  0.00659626, 0.00653195, 0.00646693, 0.00640122, 0.0063348,
  0.0062677, 0.00619992, 0.00613146, 0.00606234, 0.00599255,
  0.00592211, 0.00585103, 0.00577931, 0.00570696, 0.00563399,
  0.0055604, 0.0054862, 0.00541141, 0.00533602, 0.00526005,
  0.00518351, 0.00510639, 0.00502872, 0.0049505, 0.00487174,
  0.00479244, 0.00471262, 0.00463228, 0.00455143, 0.00447008,
  0.00438824, 0.00430592, 0.00422312, 0.00413986, 0.00405615,
  0.00397199, 0.00388739, 0.00380236, 0.00371692, 0.00363106,
  0.00354481, 0.00345816, 0.00337113, 0.00328373, 0.00319596,
  0.00310785, 0.00301939, 0.00293059, 0.00284147, 0.00275204,
  0.0026623, 0.00257226, 0.00248195, 0.00239135, 0.00230049,
  0.00220938, 0.00211801, 0.00202642, 0.0019346, 0.00184256,
  0.00175032, 0.00165788, 0.00156526, 0.00147247, 0.00137951,
  0.00128639, 0.00119314, 0.00109975, 0.00100623, 0.000912607,
  0.00081888, 0.000725061, 0.000631161, 0.00053719, 0.000443159,
  0.000349079, 0.000254959, 0.000160811, 6.66448e-05, -2.75289e-05,
  -0.000121699, -0.000215856, -0.000309989, -0.000404087,
  -0.000498139, -0.000592135, -0.000686065, -0.000779917,
  -0.000873681, -0.000967347, -0.0010609, -0.00115434, -0.00124765,
  -0.00134081, -0.00143383, -0.00152668, -0.00161936, -0.00171185,
  -0.00180415, -0.00189625, -0.00198813, -0.00207979, -0.00217121,
  -0.00226238, -0.0023533, -0.00244395, -0.00253432, -0.00262441,
  -0.00271419, -0.00280367, -0.00289282, -0.00298165, -0.00307014,
  -0.00315827, -0.00324605, -0.00333346, -0.00342048, -0.00350711,
  -0.00359335, -0.00367917, -0.00376457, -0.00384954, -0.00393406,
  -0.00401814, -0.00410176, -0.0041849, -0.00426757, -0.00434974,
  -0.00443141, -0.00451258, -0.00459322, -0.00467334, -0.00475292,
  -0.00483195, -0.00491042, -0.00498833, -0.00506566, -0.00514241,
  -0.00521856, -0.00529411, -0.00536905, -0.00544336, -0.00551705,
  -0.00559009, -0.00566249, -0.00573424, -0.00580531, -0.00587572,
  -0.00594544, -0.00601447, -0.0060828, -0.00615042, -0.00621733,
  -0.00628351, -0.00634897, -0.00641368, -0.00647764, -0.00654085,
  -0.0066033, -0.00666497, -0.00672586, -0.00678597, -0.00684529,
  -0.0069038, -0.0069615, -0.00701839, -0.00707446, -0.0071297,
  -0.0071841, -0.00723765, -0.00729036, -0.00734221, -0.00739319,
  -0.00744331, -0.00749255, -0.0075409, -0.00758837, -0.00763494,
  -0.00768061, -0.00772538, -0.00776923, -0.00781216, -0.00785417,
  -0.00789525, -0.0079354, -0.0079746, -0.00801286, -0.00805017,
  -0.00808653, -0.00812192, -0.00815635, -0.00818981, -0.0082223,
  -0.00825381, -0.00828433, -0.00831387, -0.00834242, -0.00836997,
  -0.00839653, -0.00842208, -0.00844663, -0.00847016, -0.00849269,
  -0.00851419, -0.00853468, -0.00855414, -0.00857258, -0.00858999,
  -0.00860638, -0.00862172, -0.00863603, -0.00864931, -0.00866154,
  -0.00867273, -0.00868287, -0.00869197, -0.00870002, -0.00870703,
  -0.00871298, -0.00871787, -0.00872172, -0.00872451, -0.00872624,
  -0.00872692, -0.00872654, -0.00872511, -0.00872261, -0.00871906,
  -0.00871445, -0.00870877, -0.00870204, -0.00869426, -0.00868541,
  -0.00867551, -0.00866454, -0.00865253, -0.00863945, -0.00862532,
  -0.00861014, -0.00859391, -0.00857662, -0.00855829, -0.0085389,
  -0.00851847, -0.008497, -0.00847448, -0.00845093, -0.00842633,
  -0.0084007, -0.00837404, -0.00834634, -0.00831762, -0.00828788,
  -0.00825711, -0.00822532, -0.00819252, -0.0081587, -0.00812388,
  -0.00808805, -0.00805123, -0.0080134, -0.00797458, -0.00793478,
  -0.00789398, -0.00785221, -0.00780947, -0.00776575, -0.00772107,
  -0.00767542, -0.00762882, -0.00758127, -0.00753277, -0.00748334,
  -0.00743297, -0.00738167, -0.00732945, -0.00727631, -0.00722226,
  -0.00716731, -0.00711145, -0.00705471, -0.00699708, -0.00693857,
  -0.00687919, -0.00681894, -0.00675784, -0.00669589, -0.00663309,
  -0.00656945, -0.00650499, -0.0064397, -0.00637361, -0.0063067,
  -0.006239, -0.00617051, -0.00610124, -0.00603119, -0.00596038,
  -0.00588881, -0.00581649, -0.00574344, -0.00566965, -0.00559515,
  -0.00551993, -0.005444, -0.00536739, -0.00529009, -0.00521211,
  -0.00513346, -0.00505416, -0.00497422, -0.00489363, -0.00481242,
  -0.00473059, -0.00464816, -0.00456513, -0.00448151, -0.00439732,
  -0.00431256, -0.00422724, -0.00414138, -0.00405499, -0.00396807,
  -0.00388064, -0.00379271, -0.00370429, -0.00361539, -0.00352602,
  -0.00343619, -0.00334592, -0.00325522, -0.00316409, -0.00307255,
  -0.00298061, -0.00288828, -0.00279558, -0.00270251, -0.0026091,
  -0.00251534, -0.00242125, -0.00232684, -0.00223213, -0.00213713,
  -0.00204185, -0.0019463, -0.0018505, -0.00175445, -0.00165818,
  -0.00156168, -0.00146498, -0.00136809, -0.00127102, -0.00117377,
  -0.00107638, -0.000978841, -0.000881174, -0.00078339, -0.000685502,
  -0.000587524, -0.000489468, -0.000391347, -0.000293174,
  -0.000194962, -9.67247e-05, 1.52595e-06, 9.97764e-05, 0.000198014,
  0.000296224, 0.000394396, 0.000492514, 0.000590567, 0.000688541,
  0.000786423, 0.0008842, 0.000981858, 0.00107938, 0.00117677,
  0.00127399, 0.00137104, 0.00146791, 0.00156458, 0.00166104,
  0.00175728, 0.00185327, 0.00194902, 0.00204451, 0.00213972,
  0.00223463, 0.00232925, 0.00242355, 0.00251752, 0.00261115,
  0.00270443, 0.00279733, 0.00288986, 0.00298199, 0.00307372,
  0.00316503, 0.0032559, 0.00334633, 0.00343631, 0.00352581,
  0.00361483, 0.00370335, 0.00379137, 0.00387887, 0.00396583,
  0.00405225, 0.00413811, 0.0042234, 0.0043081, 0.00439222,
  0.00447572, 0.00455861, 0.00464087, 0.00472249, 0.00480345,
  0.00488375, 0.00496336, 0.00504229, 0.00512052, 0.00519804,
  0.00527483, 0.00535089, 0.0054262, 0.00550076, 0.00557454,
  0.00564755, 0.00571977, 0.00579118, 0.00586179, 0.00593157,
  0.00600052, 0.00606863, 0.00613588, 0.00620227, 0.00626779,
  0.00633243, 0.00639617, 0.006459, 0.00652093, 0.00658193, 0.006642,
  0.00670113, 0.00675931, 0.00681653, 0.00687278, 0.00692806,
  0.00698235, 0.00703564, 0.00708793, 0.00713921, 0.00718948,
  0.00723871, 0.00728691, 0.00733406, 0.00738017, 0.00742522,
  0.0074692, 0.0075121, 0.00755393, 0.00759467, 0.00763432,
  0.00767286, 0.0077103, 0.00774663, 0.00778183, 0.00781591,
  0.00784886, 0.00788067, 0.00791134, 0.00794086, 0.00796922,
  0.00799642, 0.00802247, 0.00804734, 0.00807103, 0.00809355,
  0.00811489, 0.00813504, 0.008154, 0.00817176, 0.00818833, 0.0082037,
  0.00821785, 0.0082308, 0.00824254, 0.00825307, 0.00826237,
  0.00827046, 0.00827733, 0.00828297, 0.00828739, 0.00829057,
  0.00829253, 0.00829326, 0.00829275, 0.00829102, 0.00828804,
  0.00828384, 0.0082784, 0.00827172, 0.0082638, 0.00825465,
  0.00824427, 0.00823265, 0.00821979, 0.0082057, 0.00819038,
  0.00817382, 0.00815604, 0.00813702, 0.00811678, 0.00809531,
  0.00807262, 0.00804871, 0.00802358, 0.00799723, 0.00796967,
  0.0079409, 0.00791092, 0.00787973, 0.00784735, 0.00781377, 0.007779,
  0.00774304, 0.00770589, 0.00766757, 0.00762807, 0.0075874,
  0.00754556, 0.00750257, 0.00745842, 0.00741312, 0.00736668,
  0.0073191, 0.00727039, 0.00722056, 0.00716961, 0.00711755,
  0.00706438, 0.00701012, 0.00695477, 0.00689834, 0.00684083,
  0.00678226, 0.00672263, 0.00666194, 0.00660022, 0.00653746,
  0.00647368, 0.00640888, 0.00634308, 0.00627628, 0.00620849,
  0.00613973, 0.00606999, 0.0059993, 0.00592766, 0.00585508,
  0.00578158, 0.00570716, 0.00563183, 0.00555561, 0.00547851,
  0.00540053, 0.00532169, 0.005242, 0.00516148, 0.00508013,
  0.00499797, 0.00491501, 0.00483126, 0.00474673, 0.00466144,
  0.0045754, 0.00448863, 0.00440113, 0.00431292, 0.00422401,
  0.00413442, 0.00404416, 0.00395324, 0.00386168, 0.0037695,
  0.0036767, 0.0035833, 0.00348932, 0.00339477, 0.00329967,
  0.00320402, 0.00310785, 0.00301117, 0.002914, 0.00281634,
  0.00271823, 0.00261967, 0.00252067, 0.00242126, 0.00232145,
  0.00222125, 0.00212069, 0.00201977, 0.00191852, 0.00181696,
  0.00171508, 0.00161293, 0.0015105, 0.00140782, 0.00130491,
  0.00120178, 0.00109845, 0.000994929, 0.000891245, 0.000787411,
  0.000683444, 0.000579363, 0.000475183, 0.000370924, 0.000266601,
  0.000162234, 5.7839e-05, -4.65657e-05, -0.000150962, -0.000255333,
  -0.000359661, -0.000463927, -0.000568114, -0.000672204,
  -0.000776179, -0.00088002, -0.000983711, -0.00108723, -0.00119057,
  -0.0012937, -0.0013966, -0.00149927, -0.00160168, -0.00170381,
  -0.00180564, -0.00190716, -0.00200835, -0.00210919, -0.00220967,
  -0.00230975, -0.00240944, -0.0025087, -0.00260753, -0.0027059,
  -0.00280379, -0.00290119, -0.00299808, -0.00309445, -0.00319027,
  -0.00328552, -0.0033802, -0.00347427, -0.00356773, -0.00366056,
  -0.00375274, -0.00384425, -0.00393508, -0.0040252, -0.00411461,
  -0.00420328, -0.00429119, -0.00437834, -0.00446471, -0.00455027,
  -0.00463501, -0.00471892, -0.00480197, -0.00488416, -0.00496547,
  -0.00504587, -0.00512536, -0.00520392, -0.00528154, -0.00535819,
  -0.00543387, -0.00550855, -0.00558223, -0.00565488, -0.0057265,
  -0.00579707, -0.00586657, -0.005935, -0.00600233, -0.00606855,
  -0.00613365, -0.00619762, -0.00626044, -0.00632209, -0.00638257,
  -0.00644187, -0.00649996, -0.00655685, -0.00661251, -0.00666693,
  -0.0067201, -0.00677201, -0.00682265, -0.00687201, -0.00692007,
  -0.00696683, -0.00701227, -0.00705638, -0.00709916, -0.00714059,
  -0.00718067, -0.00721938, -0.00725671, -0.00729266, -0.00732722,
  -0.00736038, -0.00739212, -0.00742245, -0.00745135, -0.00747882,
  -0.00750485, -0.00752942, -0.00755255, -0.00757421, -0.00759441,
  -0.00761313, -0.00763037, -0.00764612, -0.00766039, -0.00767316,
  -0.00768443, -0.00769419, -0.00770245, -0.00770919, -0.00771442,
  -0.00771812, -0.00772031, -0.00772097, -0.0077201, -0.00771771,
  -0.00771378, -0.00770831, -0.00770132, -0.00769279, -0.00768272,
  -0.00767112, -0.00765798, -0.0076433, -0.00762709, -0.00760934,
  -0.00759006, -0.00756925, -0.00754691, -0.00752305, -0.00749765,
  -0.00747074, -0.0074423, -0.00741235, -0.00738088, -0.00734791,
  -0.00731344, -0.00727746, -0.00723999, -0.00720103, -0.00716059,
  -0.00711868, -0.00707529, -0.00703043, -0.00698412, -0.00693636,
  -0.00688716, -0.00683652, -0.00678446, -0.00673097, -0.00667608,
  -0.00661979, -0.00656211, -0.00650305, -0.00644262, -0.00638083,
  -0.00631769, -0.00625322, -0.00618741, -0.0061203, -0.00605188,
  -0.00598217, -0.00591118, -0.00583893, -0.00576543, -0.00569069,
  -0.00561473, -0.00553756, -0.00545919, -0.00537965, -0.00529894,
  -0.00521708, -0.00513409, -0.00504999, -0.00496478, -0.00487849,
  -0.00479113, -0.00470273, -0.00461329, -0.00452284, -0.00443139,
  -0.00433896, -0.00424558, -0.00415125, -0.00405601, -0.00395986,
  -0.00386284, -0.00376495, -0.00366622, -0.00356668, -0.00346633,
  -0.0033652, -0.00326332, -0.0031607, -0.00305737, -0.00295335,
  -0.00284866, -0.00274332, -0.00263736, -0.00253079, -0.00242365,
  -0.00231596, -0.00220773, -0.002099, -0.00198979, -0.00188012,
  -0.00177001, -0.0016595, -0.0015486, -0.00143734, -0.00132574,
  -0.00121384, -0.00110166, -0.000989213, -0.000876539, -0.000763659,
  -0.000650599, -0.000537386, -0.000424045, -0.000310605,
  -0.000197091, -8.35305e-05, 3.00501e-05, 0.000143624, 0.000257163,
  0.000370641, 0.000484029, 0.000597302, 0.000710431, 0.000823389,
  0.000936147, 0.00104868, 0.00116096, 0.00127295, 0.00138464,
  0.00149599, 0.00160697, 0.00171756, 0.00182772, 0.00193744,
  0.00204668, 0.00215541, 0.00226361, 0.00237125, 0.0024783,
  0.00258473, 0.00269052, 0.00279563, 0.00290004, 0.00300373,
  0.00310666, 0.0032088, 0.00331014, 0.00341064, 0.00351027,
  0.00360901, 0.00370682, 0.0038037, 0.00389959, 0.00399449,
  0.00408836, 0.00418118, 0.00427292, 0.00436355, 0.00445305,
  0.0045414, 0.00462856, 0.00471451, 0.00479924, 0.0048827,
  0.00496488, 0.00504575, 0.00512529, 0.00520348, 0.00528028,
  0.00535569, 0.00542967, 0.0055022, 0.00557325, 0.00564282,
  0.00571086, 0.00577737, 0.00584233, 0.0059057, 0.00596746,
  0.00602761, 0.00608612, 0.00614296, 0.00619812, 0.00625159,
  0.00630333, 0.00635334, 0.00640159, 0.00644807, 0.00649276,
  0.00653564, 0.0065767, 0.00661592, 0.00665329, 0.00668879,
  0.00672241, 0.00675412, 0.00678393, 0.00681182, 0.00683777,
  0.00686176, 0.0068838, 0.00690387, 0.00692196, 0.00693805,
  0.00695214, 0.00696422, 0.00697428, 0.00698231, 0.00698831,
  0.00699227, 0.00699418, 0.00699403, 0.00699183, 0.00698756,
  0.00698122, 0.00697281, 0.00696233, 0.00694978, 0.00693514,
  0.00691843, 0.00689963, 0.00687876, 0.00685581, 0.00683078,
  0.00680368, 0.0067745, 0.00674326, 0.00670995, 0.00667458,
  0.00663716, 0.00659769, 0.00655618, 0.00651263, 0.00646705,
  0.00641946, 0.00636986, 0.00631826, 0.00626468, 0.00620911,
  0.00615158, 0.00609211, 0.00603069, 0.00596735, 0.0059021,
  0.00583495, 0.00576593, 0.00569505, 0.00562232, 0.00554777,
  0.00547142, 0.00539328, 0.00531337, 0.00523172, 0.00514834,
  0.00506327, 0.00497652, 0.00488811, 0.00479808, 0.00470645,
  0.00461323, 0.00451847, 0.00442218, 0.0043244, 0.00422515,
  0.00412446, 0.00402237, 0.0039189, 0.00381408, 0.00370795,
  0.00360054, 0.00349188, 0.003382, 0.00327095, 0.00315875,
  0.00304544, 0.00293107, 0.00281565, 0.00269924, 0.00258187,
  0.00246358, 0.00234441, 0.0022244, 0.00210358, 0.00198201,
  0.00185971, 0.00173675, 0.00161314, 0.00148895, 0.00136421,
  0.00123897, 0.00111327, 0.000987158, 0.000860678, 0.000733877,
  0.000606801, 0.000479496, 0.000352011, 0.000224393, 9.66891e-05,
  -3.10513e-05, -0.00015878, -0.000286447, -0.000414004, -0.000541401,
  -0.000668588, -0.000795514, -0.000922129, -0.00104838, -0.00117422,
  -0.0012996, -0.00142446, -0.00154876, -0.00167243, -0.00179544,
  -0.00191772, -0.00203923, -0.00215991, -0.00227972, -0.00239859,
  -0.00251648, -0.00263333, -0.0027491, -0.00286372, -0.00297716,
  -0.00308935, -0.00320024, -0.00330979, -0.00341793, -0.00352463,
  -0.00362982, -0.00373347, -0.0038355, -0.00393589, -0.00403457,
  -0.0041315, -0.00422662, -0.00431989, -0.00441126, -0.00450068,
  -0.0045881, -0.00467348, -0.00475677, -0.00483792, -0.00491689,
  -0.00499364, -0.0050681, -0.00514026, -0.00521005, -0.00527745,
  -0.0053424, -0.00540486, -0.0054648, -0.00552218, -0.00557696,
  -0.0056291, -0.00567857, -0.00572532, -0.00576932, -0.00581055,
  -0.00584897, -0.00588454, -0.00591723, -0.00594703, -0.00597389,
  -0.00599779, -0.00601871, -0.00603662, -0.00605149, -0.00606331,
  -0.00607206, -0.00607771, -0.00608025, -0.00607966, -0.00607592,
  -0.00606903, -0.00605897, -0.00604572, -0.00602929, -0.00600966,
  -0.00598683, -0.00596079, -0.00593154, -0.00589908, -0.00586342,
  -0.00582454, -0.00578247, -0.0057372, -0.00568874, -0.0056371,
  -0.0055823, -0.00552434, -0.00546325, -0.00539905, -0.00533174,
  -0.00526136, -0.00518792, -0.00511145, -0.00503199, -0.00494955,
  -0.00486418, -0.0047759, -0.00468476, -0.00459078, -0.00449402,
  -0.00439451, -0.0042923, -0.00418743, -0.00407996, -0.00396993,
  -0.0038574, -0.00374243, -0.00362508, -0.00350539, -0.00338345,
  -0.0032593, -0.00313303, -0.00300469, -0.00287437, -0.00274213,
  -0.00260805, -0.0024722, -0.00233468, -0.00219556, -0.00205493,
  -0.00191287, -0.00176947, -0.00162483, -0.00147905, -0.0013322,
  -0.0011844, -0.00103575, -0.000886336, -0.000736275, -0.000585671,
  -0.00043463, -0.000283264, -0.000131684, 1.99958e-05, 0.000171661,
  0.000323193, 0.000474473, 0.000625381, 0.000775795, 0.000925591,
  0.00107464, 0.00122282, 0.00137001, 0.00151607, 0.00166086,
  0.00180427, 0.00194616, 0.0020864, 0.00222484, 0.00236136,
  0.00249582, 0.00262808, 0.002758, 0.00288546, 0.00301031,
  0.00313241, 0.00325163, 0.00336783, 0.00348086, 0.00359061,
  0.00369692, 0.00379966, 0.00389871, 0.00399391, 0.00408515,
  0.00417229, 0.0042552, 0.00433375, 0.00440781, 0.00447727,
  0.00454199, 0.00460186, 0.00465677, 0.00470658, 0.00475121,
  0.00479053, 0.00482444, 0.00485285, 0.00487565, 0.00489275,
  0.00490407, 0.00490951, 0.00490901, 0.00490248, 0.00488987,
  0.0048711, 0.00484613, 0.00481491, 0.00477738, 0.00473353,
  0.00468331, 0.00462672, 0.00456374, 0.00449436, 0.0044186,
  0.00433646, 0.00424799, 0.0041532, 0.00405214, 0.00394488,
  0.00383149, 0.00371203, 0.00358661, 0.00345532, 0.0033183,
  0.00317567, 0.00302757, 0.00287417, 0.00271565, 0.0025522,
  0.00238403, 0.00221135, 0.00203443, 0.00185352, 0.00166889,
  0.00148085, 0.00128972, 0.00109584, 0.000899566, 0.000701287,
  0.000501407, 0.000300356, 9.85859e-05, -0.000103424, -0.00030517,
  -0.000506124, -0.000705726, -0.000903394, -0.00109851, -0.00129044,
  -0.0014785, -0.001662, -0.00184019, -0.0020123, -0.00217753,
  -0.00233505, -0.00248397, -0.0026234, -0.00275237, -0.00286991,
  -0.00297498, -0.00306652, -0.00314341, -0.00320451, -0.00324861,
  -0.00327448, -0.00328083, -0.00326631, -0.00322955, -0.0031691,
  -0.00308349, -0.00297117, -0.00283054, -0.00265997, -0.00245774,
  -0.00222209, -0.0019512, -0.00164319, -0.0012961, -0.000907935,
  -0.000476615, 8.29415e-17}; const G4double
  G4NeutronHPFastLegendre::l20[4201] = {1, 0.902461, 0.809737,
  0.72167, 0.638107, 0.558898, 0.483895, 0.412957, 0.345943, 0.282719,
  0.223152, 0.167113, 0.114475, 0.0651177, 0.01892, -0.0242339,
  -0.0644574, -0.101861, -0.136552, -0.168634, -0.198211, -0.225381,
  -0.250239, -0.272882, -0.293398, -0.311878, -0.328407, -0.343069,
  -0.355946, -0.367117, -0.376659, -0.384646, -0.391152, -0.396246,
  -0.399997, -0.402472, -0.403734, -0.403846, -0.402869, -0.40086,
  -0.397878, -0.393977, -0.38921, -0.383629, -0.377284, -0.370224,
  -0.362494, -0.35414, -0.345206, -0.335735, -0.325766, -0.315339,
  -0.304492, -0.293262, -0.281684, -0.269792, -0.257619, -0.245196,
  -0.232554, -0.219722, -0.206728, -0.193599, -0.180361, -0.167039,
  -0.153656, -0.140235, -0.126799, -0.113367, -0.099961, -0.0865988,
  -0.073299, -0.0600789, -0.046955, -0.0339431, -0.021058,
  -0.00831404, 0.00427544, 0.0166977, 0.0289407, 0.0409932, 0.0528444,
  0.0644844, 0.0759037, 0.0870934, 0.0980455, 0.108752, 0.119206,
  0.129402, 0.139332, 0.148991, 0.158375, 0.167479, 0.176298,
  0.184829, 0.193069, 0.201015, 0.208664, 0.216014, 0.223064,
  0.229812, 0.236257, 0.242399, 0.248238, 0.253772, 0.259003,
  0.263931, 0.268557, 0.272882, 0.276907, 0.280634, 0.284065,
  0.287202, 0.290047, 0.292602, 0.29487, 0.296855, 0.298558, 0.299984,
  0.301135, 0.302016, 0.302629, 0.302978, 0.303068, 0.302903,
  0.302486, 0.301822, 0.300915, 0.29977, 0.298391, 0.296783, 0.294951,
  0.292899, 0.290632, 0.288155, 0.285473, 0.282591, 0.279515,
  0.276248, 0.272797, 0.269166, 0.265361, 0.261386, 0.257247, 0.25295,
  0.248499, 0.2439, 0.239157, 0.234277, 0.229263, 0.224123, 0.21886,
  0.213479, 0.207987, 0.202388, 0.196687, 0.19089, 0.185001, 0.179025,
  0.172968, 0.166834, 0.160628, 0.154355, 0.148021, 0.141629,
  0.135184, 0.128691, 0.122155, 0.115581, 0.108972, 0.102333,
  0.0956688, 0.0889837, 0.0822817, 0.0755673, 0.0688444, 0.0621173,
  0.0553898, 0.0486661, 0.0419499, 0.0352452, 0.0285557, 0.021885,
  0.0152368, 0.00861467, 0.00202207, -0.00453757, -0.0110609,
  -0.0175447, -0.0239857, -0.0303809, -0.036727, -0.0430213,
  -0.0492607, -0.0554424, -0.0615637, -0.0676219, -0.0736143,
  -0.0795384, -0.0853917, -0.0911718, -0.0968764, -0.102503, -0.10805,
  -0.113515, -0.118896, -0.12419, -0.129397, -0.134514, -0.139539,
  -0.144471, -0.149308, -0.154049, -0.158692, -0.163235, -0.167678,
  -0.172018, -0.176256, -0.180389, -0.184417, -0.188338, -0.192152,
  -0.195858, -0.199454, -0.202941, -0.206317, -0.209581, -0.212734,
  -0.215774, -0.218702, -0.221516, -0.224217, -0.226803, -0.229275,
  -0.231633, -0.233877, -0.236006, -0.23802, -0.239919, -0.241704,
  -0.243374, -0.244931, -0.246373, -0.247701, -0.248915, -0.250017,
  -0.251005, -0.251882, -0.252646, -0.253299, -0.253841, -0.254273,
  -0.254596, -0.254809, -0.254914, -0.254912, -0.254804, -0.254589,
  -0.25427, -0.253847, -0.25332, -0.252692, -0.251962, -0.251132,
  -0.250203, -0.249176, -0.248052, -0.246832, -0.245518, -0.24411,
  -0.24261, -0.241019, -0.239338, -0.237569, -0.235713, -0.23377,
  -0.231744, -0.229634, -0.227442, -0.22517, -0.222818, -0.220389,
  -0.217884, -0.215305, -0.212652, -0.209927, -0.207132, -0.204269,
  -0.201338, -0.198341, -0.19528, -0.192157, -0.188972, -0.185728,
  -0.182426, -0.179067, -0.175654, -0.172187, -0.168669, -0.1651,
  -0.161483, -0.157819, -0.15411, -0.150357, -0.146562, -0.142727,
  -0.138852, -0.134941, -0.130993, -0.127012, -0.122997, -0.118952,
  -0.114878, -0.110776, -0.106647, -0.102494, -0.0983176, -0.0941199,
  -0.0899021, -0.0856659, -0.0814128, -0.0771444, -0.0728621,
  -0.0685675, -0.0642621, -0.0599474, -0.0556248, -0.0512959,
  -0.0469621, -0.0426248, -0.0382856, -0.0339458, -0.0296069,
  -0.0252702, -0.0209372, -0.0166093, -0.0122878, -0.00797403,
  -0.00366943, 0.0006247, 0.00490706, 0.00917633, 0.0134312,
  0.0176705, 0.0218929, 0.0260971, 0.030282, 0.0344463, 0.0385888,
  0.0427083, 0.0468038, 0.0508739, 0.0549177, 0.058934, 0.0629217,
  0.0668796, 0.0708069, 0.0747024, 0.078565, 0.0823938, 0.0861878,
  0.0899461, 0.0936676, 0.0973514, 0.100997, 0.104602, 0.108168,
  0.111692, 0.115174, 0.118613, 0.122008, 0.125359, 0.128665,
  0.131924, 0.135137, 0.138302, 0.141419, 0.144488, 0.147507,
  0.150475, 0.153393, 0.15626, 0.159074, 0.161836, 0.164545, 0.167201,
  0.169802, 0.172349, 0.174841, 0.177277, 0.179658, 0.181982,
  0.184249, 0.186459, 0.188612, 0.190707, 0.192744, 0.194722,
  0.196642, 0.198503, 0.200305, 0.202047, 0.203729, 0.205352,
  0.206915, 0.208417, 0.209859, 0.211241, 0.212562, 0.213822,
  0.215022, 0.216161, 0.217239, 0.218256, 0.219212, 0.220108,
  0.220942, 0.221716, 0.222429, 0.223082, 0.223673, 0.224205,
  0.224676, 0.225086, 0.225437, 0.225727, 0.225958, 0.22613, 0.226242,
  0.226294, 0.226288, 0.226224, 0.2261, 0.225919, 0.22568, 0.225383,
  0.225029, 0.224618, 0.224151, 0.223627, 0.223047, 0.222412,
  0.221722, 0.220977, 0.220177, 0.219324, 0.218417, 0.217457,
  0.216445, 0.21538, 0.214264, 0.213096, 0.211878, 0.21061, 0.209292,
  0.207925, 0.206509, 0.205045, 0.203533, 0.201975, 0.20037, 0.198719,
  0.197022, 0.195281, 0.193496, 0.191667, 0.189796, 0.187882,
  0.185926, 0.183929, 0.181892, 0.179815, 0.177698, 0.175544,
  0.173351, 0.171121, 0.168855, 0.166552, 0.164215, 0.161843,
  0.159437, 0.156998, 0.154526, 0.152023, 0.149488, 0.146923,
  0.144329, 0.141706, 0.139054, 0.136375, 0.133669, 0.130936,
  0.128179, 0.125397, 0.12259, 0.119761, 0.116909, 0.114035, 0.111141,
  0.108226, 0.105291, 0.102338, 0.0993663, 0.0963774, 0.0933719,
  0.0903505, 0.0873139, 0.0842628, 0.081198, 0.0781202, 0.0750302,
  0.0719286, 0.0688163, 0.0656938, 0.062562, 0.0594216, 0.0562733,
  0.0531177, 0.0499557, 0.046788, 0.0436152, 0.0404381, 0.0372573,
  0.0340736, 0.0308878, 0.0277003, 0.0245121, 0.0213237, 0.0181359,
  0.0149494, 0.0117647, 0.00858269, 0.00540394, 0.00222915,
  -0.000941033, -0.00410593, -0.00726489, -0.0104173, -0.0135624,
  -0.0166996, -0.0198283, -0.0229479, -0.0260576, -0.029157,
  -0.0322452, -0.0353219, -0.0383863, -0.0414378, -0.0444758,
  -0.0474998, -0.0505091, -0.0535033, -0.0564816, -0.0594435,
  -0.0623885, -0.065316, -0.0682254, -0.0711163, -0.073988, -0.07684,
  -0.0796719, -0.082483, -0.085273, -0.0880411, -0.0907871,
  -0.0935103, -0.0962103, -0.0988867, -0.101539, -0.104166, -0.106769,
  -0.109346, -0.111897, -0.114421, -0.116919, -0.119389, -0.121832,
  -0.124246, -0.126632, -0.128989, -0.131317, -0.133615, -0.135884,
  -0.138121, -0.140328, -0.142504, -0.144649, -0.146762, -0.148842,
  -0.15089, -0.152906, -0.154888, -0.156837, -0.158753, -0.160634,
  -0.162482, -0.164295, -0.166073, -0.167816, -0.169524, -0.171197,
  -0.172834, -0.174435, -0.176001, -0.17753, -0.179022, -0.180478,
  -0.181897, -0.183279, -0.184624, -0.185931, -0.187201, -0.188434,
  -0.189628, -0.190785, -0.191904, -0.192985, -0.194027, -0.195032,
  -0.195998, -0.196925, -0.197814, -0.198664, -0.199476, -0.200249,
  -0.200983, -0.201679, -0.202336, -0.202953, -0.203532, -0.204073,
  -0.204574, -0.205036, -0.20546, -0.205845, -0.206191, -0.206499,
  -0.206767, -0.206997, -0.207189, -0.207342, -0.207457, -0.207533,
  -0.207571, -0.20757, -0.207532, -0.207456, -0.207341, -0.207189,
  -0.207, -0.206773, -0.206508, -0.206206, -0.205868, -0.205492,
  -0.205079, -0.20463, -0.204145, -0.203623, -0.203065, -0.202471,
  -0.201842, -0.201177, -0.200477, -0.199741, -0.198971, -0.198166,
  -0.197327, -0.196454, -0.195547, -0.194606, -0.193631, -0.192624,
  -0.191583, -0.19051, -0.189405, -0.188267, -0.187097, -0.185896,
  -0.184664, -0.1834, -0.182106, -0.180782, -0.179427, -0.178043,
  -0.176629, -0.175186, -0.173714, -0.172214, -0.170685, -0.169129,
  -0.167545, -0.165934, -0.164296, -0.162631, -0.16094, -0.159224,
  -0.157482, -0.155715, -0.153923, -0.152107, -0.150267, -0.148403,
  -0.146516, -0.144606, -0.142673, -0.140718, -0.138742, -0.136744,
  -0.134725, -0.132686, -0.130626, -0.128547, -0.126448, -0.12433,
  -0.122194, -0.120039, -0.117866, -0.115676, -0.113469, -0.111246,
  -0.109006, -0.10675, -0.104479, -0.102193, -0.0998926, -0.0975779,
  -0.0952495, -0.0929077, -0.0905531, -0.088186, -0.0858068,
  -0.0834159, -0.0810138, -0.078601, -0.0761777, -0.0737444,
  -0.0713017, -0.0688497, -0.0663891, -0.0639202, -0.0614434,
  -0.0589592, -0.056468, -0.0539701, -0.0514661, -0.0489563,
  -0.0464412, -0.0439211, -0.0413966, -0.0388679, -0.0363356, -0.0338,
  -0.0312616, -0.0287208, -0.026178, -0.0236335, -0.0210879,
  -0.0185415, -0.0159947, -0.013448, -0.0109018, -0.00835637,
  -0.00581223, -0.00326975, -0.000729345, 0.00180859, 0.00434367,
  0.00687548, 0.00940363, 0.0119277, 0.0144474, 0.0169622, 0.0194718,
  0.0219758, 0.0244738, 0.0269655, 0.0294503, 0.0319281, 0.0343984,
  0.0368607, 0.0393149, 0.0417604, 0.0441969, 0.0466241, 0.0490416,
  0.051449, 0.0538461, 0.0562323, 0.0586074, 0.0609711, 0.0633229,
  0.0656626, 0.0679898, 0.0703042, 0.0726054, 0.0748931, 0.077167,
  0.0794268, 0.081672, 0.0839025, 0.086118, 0.088318, 0.0905023,
  0.0926705, 0.0948225, 0.0969578, 0.0990762, 0.101177, 0.103261,
  0.105327, 0.107375, 0.109404, 0.111415, 0.113407, 0.11538, 0.117334,
  0.119267, 0.121181, 0.123075, 0.124948, 0.126801, 0.128633,
  0.130443, 0.132232, 0.134, 0.135745, 0.137469, 0.13917, 0.140849,
  0.142505, 0.144138, 0.145748, 0.147335, 0.148898, 0.150438,
  0.151954, 0.153445, 0.154913, 0.156356, 0.157774, 0.159168,
  0.160536, 0.16188, 0.163198, 0.164491, 0.165759, 0.167, 0.168216,
  0.169406, 0.17057, 0.171708, 0.17282, 0.173905, 0.174963, 0.175995,
  0.177, 0.177978, 0.17893, 0.179854, 0.180751, 0.181621, 0.182464,
  0.183279, 0.184067, 0.184827, 0.18556, 0.186265, 0.186942, 0.187592,
  0.188214, 0.188808, 0.189374, 0.189912, 0.190422, 0.190905,
  0.191359, 0.191786, 0.192184, 0.192555, 0.192897, 0.193211,
  0.193498, 0.193756, 0.193986, 0.194188, 0.194363, 0.194509,
  0.194627, 0.194718, 0.194781, 0.194815, 0.194822, 0.194802,
  0.194753, 0.194677, 0.194574, 0.194442, 0.194284, 0.194098,
  0.193884, 0.193644, 0.193376, 0.193081, 0.192759, 0.19241, 0.192034,
  0.191632, 0.191203, 0.190747, 0.190265, 0.189757, 0.189222,
  0.188662, 0.188075, 0.187463, 0.186825, 0.186161, 0.185472,
  0.184757, 0.184017, 0.183253, 0.182463, 0.181648, 0.180809,
  0.179946, 0.179058, 0.178146, 0.177211, 0.176251, 0.175268,
  0.174261, 0.173231, 0.172178, 0.171102, 0.170003, 0.168882,
  0.167738, 0.166572, 0.165384, 0.164174, 0.162943, 0.161691,
  0.160417, 0.159122, 0.157806, 0.15647, 0.155114, 0.153737, 0.15234,
  0.150924, 0.149488, 0.148033, 0.146559, 0.145066, 0.143555,
  0.142025, 0.140477, 0.138912, 0.137328, 0.135727, 0.134109,
  0.132474, 0.130823, 0.129155, 0.127471, 0.125771, 0.124055,
  0.122324, 0.120577, 0.118816, 0.11704, 0.11525, 0.113445, 0.111627,
  0.109795, 0.10795, 0.106091, 0.10422, 0.102336, 0.10044, 0.0985317,
  0.0966118, 0.0946804, 0.0927377, 0.0907842, 0.08882, 0.0868454,
  0.0848606, 0.0828661, 0.0808619, 0.0788485, 0.076826, 0.0747949,
  0.0727552, 0.0707074, 0.0686518, 0.0665884, 0.0645178, 0.0624401,
  0.0603556, 0.0582647, 0.0561675, 0.0540644, 0.0519557, 0.0498416,
  0.0477224, 0.0455985, 0.04347, 0.0413373, 0.0392006, 0.0370603,
  0.0349166, 0.0327698, 0.0306202, 0.028468, 0.0263136, 0.0241572,
  0.0219992, 0.0198397, 0.0176791, 0.0155176, 0.0133556, 0.0111933,
  0.00903096, 0.00686889, 0.00470737, 0.00254667, 0.000387071,
  -0.00177116, -0.00392775, -0.00608241, -0.00823488, -0.0103849,
  -0.0125322, -0.0146764, -0.0168174, -0.0189548, -0.0210884,
  -0.023218, -0.0253432, -0.0274637, -0.0295794, -0.03169, -0.0337952,
  -0.0358947, -0.0379882, -0.0400756, -0.0421566, -0.0442309,
  -0.0462982, -0.0483584, -0.0504111, -0.0524561, -0.0544931,
  -0.056522, -0.0585424, -0.0605542, -0.062557, -0.0645507,
  -0.0665349, -0.0685096, -0.0704743, -0.0724289, -0.0743732,
  -0.0763069, -0.0782299, -0.0801417, -0.0820424, -0.0839315,
  -0.085809, -0.0876745, -0.0895279, -0.091369, -0.0931974,
  -0.0950131, -0.0968158, -0.0986053, -0.100381, -0.102144, -0.103893,
  -0.105627, -0.107348, -0.109054, -0.110745, -0.112422, -0.114083,
  -0.11573, -0.117361, -0.118977, -0.120576, -0.12216, -0.123728,
  -0.12528, -0.126815, -0.128334, -0.129836, -0.131321, -0.132789,
  -0.134239, -0.135672, -0.137088, -0.138486, -0.139866, -0.141228,
  -0.142572, -0.143898, -0.145205, -0.146494, -0.147764, -0.149015,
  -0.150247, -0.15146, -0.152654, -0.153828, -0.154983, -0.156118,
  -0.157234, -0.15833, -0.159406, -0.160462, -0.161497, -0.162513,
  -0.163508, -0.164483, -0.165437, -0.16637, -0.167283, -0.168175,
  -0.169046, -0.169896, -0.170725, -0.171533, -0.17232, -0.173086,
  -0.17383, -0.174552, -0.175254, -0.175933, -0.176592, -0.177228,
  -0.177843, -0.178436, -0.179007, -0.179557, -0.180084, -0.18059,
  -0.181074, -0.181535, -0.181975, -0.182393, -0.182788, -0.183162,
  -0.183513, -0.183842, -0.184149, -0.184434, -0.184697, -0.184938,
  -0.185156, -0.185352, -0.185526, -0.185678, -0.185808, -0.185915,
  -0.186, -0.186064, -0.186105, -0.186124, -0.18612, -0.186095,
  -0.186048, -0.185979, -0.185887, -0.185774, -0.185639, -0.185482,
  -0.185303, -0.185103, -0.18488, -0.184636, -0.184371, -0.184083,
  -0.183775, -0.183444, -0.183093, -0.18272, -0.182325, -0.18191,
  -0.181473, -0.181015, -0.180537, -0.180037, -0.179517, -0.178975,
  -0.178413, -0.177831, -0.177228, -0.176604, -0.175961, -0.175297,
  -0.174613, -0.173908, -0.173184, -0.172441, -0.171677, -0.170894,
  -0.170091, -0.169269, -0.168428, -0.167567, -0.166688, -0.165789,
  -0.164872, -0.163936, -0.162982, -0.162009, -0.161018, -0.160009,
  -0.158982, -0.157936, -0.156873, -0.155793, -0.154695, -0.15358,
  -0.152447, -0.151298, -0.150131, -0.148948, -0.147749, -0.146533,
  -0.1453, -0.144052, -0.142787, -0.141507, -0.140211, -0.1389,
  -0.137573, -0.136231, -0.134875, -0.133503, -0.132117, -0.130716,
  -0.129301, -0.127872, -0.126429, -0.124972, -0.123502, -0.122018,
  -0.120521, -0.119011, -0.117488, -0.115952, -0.114404, -0.112844,
  -0.111271, -0.109687, -0.108091, -0.106483, -0.104864, -0.103234,
  -0.101593, -0.0999406, -0.0982781, -0.0966052, -0.0949221,
  -0.093229, -0.0915261, -0.0898136, -0.0880918, -0.0863608,
  -0.0846208, -0.082872, -0.0811147, -0.079349, -0.0775751,
  -0.0757933, -0.0740038, -0.0722067, -0.0704023, -0.0685907,
  -0.0667723, -0.0649471, -0.0631154, -0.0612775, -0.0594335,
  -0.0575836, -0.0557281, -0.0538671, -0.0520009, -0.0501297,
  -0.0482537, -0.0463731, -0.0444882, -0.042599, -0.040706,
  -0.0388092, -0.0369088, -0.0350052, -0.0330985, -0.0311888,
  -0.0292766, -0.0273619, -0.0254449, -0.0235259, -0.0216051,
  -0.0196828, -0.017759, -0.0158341, -0.0139082, -0.0119816,
  -0.0100545, -0.00812702, -0.00619948, -0.00427205, -0.00234495,
  -0.000418384, 0.00150743, 0.00343228, 0.00535595, 0.00727825,
  0.00919895, 0.0111178, 0.0130347, 0.0149494, 0.0168616, 0.0187712,
  0.0206779, 0.0225816, 0.0244821, 0.026379, 0.0282723, 0.0301617,
  0.0320471, 0.0339282, 0.0358047, 0.0376766, 0.0395437, 0.0414056,
  0.0432622, 0.0451134, 0.0469589, 0.0487985, 0.050632, 0.0524593,
  0.0542801, 0.0560942, 0.0579015, 0.0597018, 0.0614948, 0.0632804,
  0.0650584, 0.0668286, 0.0685909, 0.0703449, 0.0720907, 0.0738278,
  0.0755563, 0.0772759, 0.0789864, 0.0806877, 0.0823795, 0.0840617,
  0.0857342, 0.0873967, 0.089049, 0.0906911, 0.0923227, 0.0939437,
  0.0955539, 0.0971531, 0.0987412, 0.100318, 0.101883, 0.103437,
  0.104979, 0.106509, 0.108027, 0.109533, 0.111026, 0.112507,
  0.113975, 0.11543, 0.116872, 0.118301, 0.119717, 0.12112, 0.122508,
  0.123884, 0.125245, 0.126592, 0.127925, 0.129244, 0.130549,
  0.131839, 0.133115, 0.134375, 0.135621, 0.136852, 0.138068,
  0.139269, 0.140454, 0.141623, 0.142778, 0.143916, 0.145039,
  0.146145, 0.147236, 0.148311, 0.149369, 0.150411, 0.151437,
  0.152446, 0.153438, 0.154414, 0.155373, 0.156315, 0.15724, 0.158148,
  0.159039, 0.159912, 0.160768, 0.161607, 0.162429, 0.163233,
  0.164019, 0.164787, 0.165538, 0.166271, 0.166986, 0.167683,
  0.168362, 0.169023, 0.169666, 0.170291, 0.170897, 0.171485,
  0.172055, 0.172606, 0.173139, 0.173654, 0.17415, 0.174627, 0.175086,
  0.175526, 0.175948, 0.17635, 0.176734, 0.1771, 0.177446, 0.177774,
  0.178083, 0.178372, 0.178644, 0.178896, 0.179129, 0.179343,
  0.179539, 0.179715, 0.179873, 0.180012, 0.180131, 0.180232,
  0.180314, 0.180377, 0.180421, 0.180446, 0.180452, 0.180439,
  0.180407, 0.180357, 0.180287, 0.180199, 0.180092, 0.179966,
  0.179821, 0.179658, 0.179475, 0.179275, 0.179055, 0.178817, 0.17856,
  0.178285, 0.177991, 0.177679, 0.177348, 0.176999, 0.176632,
  0.176246, 0.175842, 0.17542, 0.17498, 0.174522, 0.174046, 0.173551,
  0.173039, 0.172509, 0.171962, 0.171396, 0.170813, 0.170213,
  0.169595, 0.168959, 0.168307, 0.167637, 0.16695, 0.166245, 0.165524,
  0.164786, 0.164031, 0.163259, 0.162471, 0.161666, 0.160845,
  0.160007, 0.159153, 0.158282, 0.157396, 0.156494, 0.155575,
  0.154641, 0.153692, 0.152726, 0.151746, 0.150749, 0.149738,
  0.148712, 0.14767, 0.146614, 0.145542, 0.144457, 0.143356, 0.142241,
  0.141112, 0.139969, 0.138811, 0.13764, 0.136455, 0.135256, 0.134044,
  0.132818, 0.131579, 0.130327, 0.129061, 0.127783, 0.126492,
  0.125189, 0.123873, 0.122545, 0.121204, 0.119852, 0.118487,
  0.117111, 0.115724, 0.114324, 0.112914, 0.111492, 0.11006, 0.108616,
  0.107162, 0.105697, 0.104222, 0.102737, 0.101241, 0.099736,
  0.0982208, 0.096696, 0.0951618, 0.0936183, 0.0920656, 0.090504,
  0.0889336, 0.0873546, 0.085767, 0.0841712, 0.0825672, 0.0809552,
  0.0793354, 0.077708, 0.0760731, 0.0744308, 0.0727815, 0.0711251,
  0.069462, 0.0677923, 0.066116, 0.0644336, 0.0627449, 0.0610504,
  0.0593501, 0.0576442, 0.0559329, 0.0542163, 0.0524947, 0.0507682,
  0.049037, 0.0473013, 0.0455612, 0.0438169, 0.0420686, 0.0403165,
  0.0385607, 0.0368015, 0.0350389, 0.0332733, 0.0315047, 0.0297334,
  0.0279594, 0.0261831, 0.0244046, 0.022624, 0.0208416, 0.0190575,
  0.0172719, 0.015485, 0.0136969, 0.0119079, 0.010118, 0.00832762,
  0.00653678, 0.0047457, 0.00295455, 0.00116351, -0.00062723,
  -0.0024175, -0.00420712, -0.00599591, -0.00778369, -0.00957028,
  -0.0113555, -0.0131392, -0.0149212, -0.0167013, -0.0184793,
  -0.020255, -0.0220283, -0.0237991, -0.025567, -0.027332, -0.0290939,
  -0.0308525, -0.0326076, -0.0343591, -0.0361067, -0.0378503,
  -0.0395898, -0.041325, -0.0430556, -0.0447816, -0.0465027,
  -0.0482188, -0.0499298, -0.0516354, -0.0533354, -0.0550298,
  -0.0567184, -0.0584009, -0.0600772, -0.0617472, -0.0634107,
  -0.0650675, -0.0667175, -0.0683606, -0.0699964, -0.071625,
  -0.0732461, -0.0748595, -0.0764652, -0.078063, -0.0796526,
  -0.081234, -0.082807, -0.0843715, -0.0859272, -0.0874741, -0.089012,
  -0.0905408, -0.0920603, -0.0935703, -0.0950707, -0.0965614,
  -0.0980422, -0.099513, -0.100974, -0.102424, -0.103864, -0.105293,
  -0.106712, -0.10812, -0.109516, -0.110902, -0.112276, -0.113639,
  -0.114991, -0.116331, -0.117659, -0.118975, -0.120279, -0.121571,
  -0.122851, -0.124118, -0.125373, -0.126616, -0.127845, -0.129062,
  -0.130265, -0.131456, -0.132633, -0.133798, -0.134948, -0.136085,
  -0.137209, -0.138319, -0.139415, -0.140497, -0.141565, -0.142618,
  -0.143658, -0.144683, -0.145694, -0.14669, -0.147672, -0.148639,
  -0.149591, -0.150528, -0.15145, -0.152357, -0.153249, -0.154126,
  -0.154988, -0.155834, -0.156664, -0.15748, -0.158279, -0.159063,
  -0.159831, -0.160583, -0.161319, -0.16204, -0.162744, -0.163432,
  -0.164104, -0.16476, -0.1654, -0.166023, -0.16663, -0.16722,
  -0.167794, -0.168352, -0.168893, -0.169417, -0.169924, -0.170415,
  -0.170889, -0.171346, -0.171787, -0.17221, -0.172617, -0.173006,
  -0.173379, -0.173734, -0.174073, -0.174394, -0.174699, -0.174986,
  -0.175256, -0.175509, -0.175744, -0.175963, -0.176164, -0.176348,
  -0.176515, -0.176664, -0.176797, -0.176912, -0.177009, -0.17709,
  -0.177153, -0.177199, -0.177227, -0.177239, -0.177232, -0.177209,
  -0.177169, -0.177111, -0.177036, -0.176943, -0.176834, -0.176707,
  -0.176563, -0.176402, -0.176224, -0.176028, -0.175816, -0.175586,
  -0.175339, -0.175076, -0.174795, -0.174497, -0.174183, -0.173851,
  -0.173503, -0.173138, -0.172756, -0.172357, -0.171942, -0.17151,
  -0.171061, -0.170596, -0.170114, -0.169616, -0.169102, -0.168571,
  -0.168024, -0.16746, -0.166881, -0.166285, -0.165673, -0.165046,
  -0.164402, -0.163742, -0.163067, -0.162376, -0.161669, -0.160947,
  -0.160209, -0.159456, -0.158688, -0.157904, -0.157105, -0.156291,
  -0.155461, -0.154617, -0.153758, -0.152884, -0.151996, -0.151093,
  -0.150175, -0.149243, -0.148297, -0.147336, -0.146362, -0.145373,
  -0.14437, -0.143354, -0.142324, -0.14128, -0.140222, -0.139151,
  -0.138067, -0.13697, -0.135859, -0.134736, -0.133599, -0.13245,
  -0.131288, -0.130114, -0.128927, -0.127728, -0.126517, -0.125294,
  -0.124058, -0.122811, -0.121552, -0.120282, -0.119, -0.117707,
  -0.116402, -0.115087, -0.11376, -0.112423, -0.111075, -0.109716,
  -0.108347, -0.106968, -0.105578, -0.104179, -0.102769, -0.10135,
  -0.0999213, -0.098483, -0.0970354, -0.0955786, -0.0941128,
  -0.092638, -0.0911544, -0.0896623, -0.0881616, -0.0866526,
  -0.0851355, -0.0836102, -0.0820771, -0.0805363, -0.0789878,
  -0.0774319, -0.0758687, -0.0742983, -0.072721, -0.0711368,
  -0.0695459, -0.0679484, -0.0663446, -0.0647346, -0.0631185,
  -0.0614964, -0.0598686, -0.0582352, -0.0565964, -0.0549522,
  -0.053303, -0.0516487, -0.0499897, -0.0483259, -0.0466577,
  -0.0449852, -0.0433084, -0.0416277, -0.0399431, -0.0382548,
  -0.036563, -0.0348678, -0.0331694, -0.031468, -0.0297637,
  -0.0280567, -0.0263471, -0.0246351, -0.0229209, -0.0212047,
  -0.0194865, -0.0177666, -0.0160452, -0.0143223, -0.0125982,
  -0.010873, -0.00914693, -0.0074201, -0.00569268, -0.00396485,
  -0.00223677, -0.000508602, 0.00121949, 0.00294734, 0.00467478,
  0.00640164, 0.00812778, 0.00985301, 0.0115772, 0.0133001, 0.0150216,
  0.0167416, 0.0184599, 0.0201763, 0.0218906, 0.0236027, 0.0253125,
  0.0270197, 0.0287242, 0.0304258, 0.0321245, 0.0338199, 0.035512,
  0.0372006, 0.0388856, 0.0405667, 0.0422438, 0.0439168, 0.0455854,
  0.0472497, 0.0489092, 0.0505641, 0.052214, 0.0538588, 0.0554983,
  0.0571325, 0.0587611, 0.0603839, 0.062001, 0.063612, 0.0652168,
  0.0668153, 0.0684074, 0.0699928, 0.0715714, 0.0731432, 0.0747078,
  0.0762653, 0.0778153, 0.0793579, 0.0808928, 0.0824199, 0.083939,
  0.0854501, 0.0869529, 0.0884473, 0.0899333, 0.0914105, 0.092879,
  0.0943385, 0.095789, 0.0972302, 0.0986621, 0.100085, 0.101497,
  0.1029, 0.104294, 0.105677, 0.10705, 0.108412, 0.109765, 0.111107,
  0.112438, 0.113758, 0.115068, 0.116366, 0.117653, 0.118929,
  0.120194, 0.121447, 0.122688, 0.123918, 0.125136, 0.126342,
  0.127536, 0.128717, 0.129886, 0.131043, 0.132188, 0.133319,
  0.134438, 0.135544, 0.136637, 0.137717, 0.138784, 0.139838,
  0.140878, 0.141905, 0.142918, 0.143917, 0.144903, 0.145875,
  0.146833, 0.147777, 0.148707, 0.149623, 0.150524, 0.151411,
  0.152284, 0.153142, 0.153986, 0.154814, 0.155628, 0.156428,
  0.157212, 0.157981, 0.158735, 0.159474, 0.160198, 0.160906, 0.1616,
  0.162277, 0.16294, 0.163587, 0.164218, 0.164833, 0.165433, 0.166017,
  0.166585, 0.167138, 0.167674, 0.168194, 0.168699, 0.169187,
  0.169659, 0.170115, 0.170555, 0.170979, 0.171386, 0.171777,
  0.172151, 0.17251, 0.172851, 0.173177, 0.173485, 0.173778, 0.174053,
  0.174313, 0.174555, 0.174781, 0.17499, 0.175183, 0.175359, 0.175518,
  0.17566, 0.175786, 0.175895, 0.175987, 0.176063, 0.176122, 0.176163,
  0.176189, 0.176197, 0.176189, 0.176163, 0.176122, 0.176063,
  0.175987, 0.175895, 0.175786, 0.17566, 0.175518, 0.175359, 0.175183,
  0.17499, 0.174781, 0.174555, 0.174313, 0.174053, 0.173778, 0.173485,
  0.173177, 0.172851, 0.17251, 0.172151, 0.171777, 0.171386, 0.170979,
  0.170555, 0.170115, 0.169659, 0.169187, 0.168699, 0.168194,
  0.167674, 0.167138, 0.166585, 0.166017, 0.165433, 0.164833,
  0.164218, 0.163587, 0.16294, 0.162277, 0.1616, 0.160906, 0.160198,
  0.159474, 0.158735, 0.157981, 0.157212, 0.156428, 0.155628,
  0.154814, 0.153986, 0.153142, 0.152284, 0.151411, 0.150524,
  0.149623, 0.148707, 0.147777, 0.146833, 0.145875, 0.144903,
  0.143917, 0.142918, 0.141905, 0.140878, 0.139838, 0.138784,
  0.137717, 0.136637, 0.135544, 0.134438, 0.133319, 0.132188,
  0.131043, 0.129886, 0.128717, 0.127536, 0.126342, 0.125136,
  0.123918, 0.122688, 0.121447, 0.120194, 0.118929, 0.117653,
  0.116366, 0.115068, 0.113758, 0.112438, 0.111107, 0.109765,
  0.108412, 0.10705, 0.105677, 0.104294, 0.1029, 0.101497, 0.100085,
  0.0986621, 0.0972302, 0.095789, 0.0943385, 0.092879, 0.0914105,
  0.0899333, 0.0884473, 0.0869529, 0.0854501, 0.083939, 0.0824199,
  0.0808928, 0.0793579, 0.0778153, 0.0762653, 0.0747078, 0.0731432,
  0.0715714, 0.0699928, 0.0684074, 0.0668153, 0.0652168, 0.063612,
  0.062001, 0.0603839, 0.0587611, 0.0571325, 0.0554983, 0.0538588,
  0.052214, 0.0505641, 0.0489092, 0.0472497, 0.0455854, 0.0439168,
  0.0422438, 0.0405667, 0.0388856, 0.0372006, 0.035512, 0.0338199,
  0.0321245, 0.0304258, 0.0287242, 0.0270197, 0.0253125, 0.0236027,
  0.0218906, 0.0201763, 0.0184599, 0.0167416, 0.0150216, 0.0133001,
  0.0115772, 0.00985301, 0.00812778, 0.00640164, 0.00467478,
  0.00294734, 0.00121949, -0.000508602, -0.00223677, -0.00396485,
  -0.00569268, -0.0074201, -0.00914693, -0.010873, -0.0125982,
  -0.0143223, -0.0160452, -0.0177666, -0.0194865, -0.0212047,
  -0.0229209, -0.0246351, -0.0263471, -0.0280567, -0.0297637,
  -0.031468, -0.0331694, -0.0348678, -0.036563, -0.0382548,
  -0.0399431, -0.0416277, -0.0433084, -0.0449852, -0.0466577,
  -0.0483259, -0.0499897, -0.0516487, -0.053303, -0.0549522,
  -0.0565964, -0.0582352, -0.0598686, -0.0614964, -0.0631185,
  -0.0647346, -0.0663446, -0.0679484, -0.0695459, -0.0711368,
  -0.072721, -0.0742983, -0.0758687, -0.0774319, -0.0789878,
  -0.0805363, -0.0820771, -0.0836102, -0.0851355, -0.0866526,
  -0.0881616, -0.0896623, -0.0911544, -0.092638, -0.0941128,
  -0.0955786, -0.0970354, -0.098483, -0.0999213, -0.10135, -0.102769,
  -0.104179, -0.105578, -0.106968, -0.108347, -0.109716, -0.111075,
  -0.112423, -0.11376, -0.115087, -0.116402, -0.117707, -0.119,
  -0.120282, -0.121552, -0.122811, -0.124058, -0.125294, -0.126517,
  -0.127728, -0.128927, -0.130114, -0.131288, -0.13245, -0.133599,
  -0.134736, -0.135859, -0.13697, -0.138067, -0.139151, -0.140222,
  -0.14128, -0.142324, -0.143354, -0.14437, -0.145373, -0.146362,
  -0.147336, -0.148297, -0.149243, -0.150175, -0.151093, -0.151996,
  -0.152884, -0.153758, -0.154617, -0.155461, -0.156291, -0.157105,
  -0.157904, -0.158688, -0.159456, -0.160209, -0.160947, -0.161669,
  -0.162376, -0.163067, -0.163742, -0.164402, -0.165046, -0.165673,
  -0.166285, -0.166881, -0.16746, -0.168024, -0.168571, -0.169102,
  -0.169616, -0.170114, -0.170596, -0.171061, -0.17151, -0.171942,
  -0.172357, -0.172756, -0.173138, -0.173503, -0.173851, -0.174183,
  -0.174497, -0.174795, -0.175076, -0.175339, -0.175586, -0.175816,
  -0.176028, -0.176224, -0.176402, -0.176563, -0.176707, -0.176834,
  -0.176943, -0.177036, -0.177111, -0.177169, -0.177209, -0.177232,
  -0.177239, -0.177227, -0.177199, -0.177153, -0.17709, -0.177009,
  -0.176912, -0.176797, -0.176664, -0.176515, -0.176348, -0.176164,
  -0.175963, -0.175744, -0.175509, -0.175256, -0.174986, -0.174699,
  -0.174394, -0.174073, -0.173734, -0.173379, -0.173006, -0.172617,
  -0.17221, -0.171787, -0.171346, -0.170889, -0.170415, -0.169924,
  -0.169417, -0.168893, -0.168352, -0.167794, -0.16722, -0.16663,
  -0.166023, -0.1654, -0.16476, -0.164104, -0.163432, -0.162744,
  -0.16204, -0.161319, -0.160583, -0.159831, -0.159063, -0.158279,
  -0.15748, -0.156664, -0.155834, -0.154988, -0.154126, -0.153249,
  -0.152357, -0.15145, -0.150528, -0.149591, -0.148639, -0.147672,
  -0.14669, -0.145694, -0.144683, -0.143658, -0.142618, -0.141565,
  -0.140497, -0.139415, -0.138319, -0.137209, -0.136085, -0.134948,
  -0.133798, -0.132633, -0.131456, -0.130265, -0.129062, -0.127845,
  -0.126616, -0.125373, -0.124118, -0.122851, -0.121571, -0.120279,
  -0.118975, -0.117659, -0.116331, -0.114991, -0.113639, -0.112276,
  -0.110902, -0.109516, -0.10812, -0.106712, -0.105293, -0.103864,
  -0.102424, -0.100974, -0.099513, -0.0980422, -0.0965614, -0.0950707,
  -0.0935703, -0.0920603, -0.0905408, -0.089012, -0.0874741,
  -0.0859272, -0.0843715, -0.082807, -0.081234, -0.0796526, -0.078063,
  -0.0764652, -0.0748595, -0.0732461, -0.071625, -0.0699964,
  -0.0683606, -0.0667175, -0.0650675, -0.0634107, -0.0617472,
  -0.0600772, -0.0584009, -0.0567184, -0.0550298, -0.0533354,
  -0.0516354, -0.0499298, -0.0482188, -0.0465027, -0.0447816,
  -0.0430556, -0.041325, -0.0395898, -0.0378503, -0.0361067,
  -0.0343591, -0.0326076, -0.0308525, -0.0290939, -0.027332,
  -0.025567, -0.0237991, -0.0220283, -0.020255, -0.0184793,
  -0.0167013, -0.0149212, -0.0131392, -0.0113555, -0.00957028,
  -0.00778369, -0.00599591, -0.00420712, -0.0024175, -0.00062723,
  0.00116351, 0.00295455, 0.0047457, 0.00653678, 0.00832762, 0.010118,
  0.0119079, 0.0136969, 0.015485, 0.0172719, 0.0190575, 0.0208416,
  0.022624, 0.0244046, 0.0261831, 0.0279594, 0.0297334, 0.0315047,
  0.0332733, 0.0350389, 0.0368015, 0.0385607, 0.0403165, 0.0420686,
  0.0438169, 0.0455612, 0.0473013, 0.049037, 0.0507682, 0.0524947,
  0.0542163, 0.0559329, 0.0576442, 0.0593501, 0.0610504, 0.0627449,
  0.0644336, 0.066116, 0.0677923, 0.069462, 0.0711251, 0.0727815,
  0.0744308, 0.0760731, 0.077708, 0.0793354, 0.0809552, 0.0825672,
  0.0841712, 0.085767, 0.0873546, 0.0889336, 0.090504, 0.0920656,
  0.0936183, 0.0951618, 0.096696, 0.0982208, 0.099736, 0.101241,
  0.102737, 0.104222, 0.105697, 0.107162, 0.108616, 0.11006, 0.111492,
  0.112914, 0.114324, 0.115724, 0.117111, 0.118487, 0.119852,
  0.121204, 0.122545, 0.123873, 0.125189, 0.126492, 0.127783,
  0.129061, 0.130327, 0.131579, 0.132818, 0.134044, 0.135256,
  0.136455, 0.13764, 0.138811, 0.139969, 0.141112, 0.142241, 0.143356,
  0.144457, 0.145542, 0.146614, 0.14767, 0.148712, 0.149738, 0.150749,
  0.151746, 0.152726, 0.153692, 0.154641, 0.155575, 0.156494,
  0.157396, 0.158282, 0.159153, 0.160007, 0.160845, 0.161666,
  0.162471, 0.163259, 0.164031, 0.164786, 0.165524, 0.166245, 0.16695,
  0.167637, 0.168307, 0.168959, 0.169595, 0.170213, 0.170813,
  0.171396, 0.171962, 0.172509, 0.173039, 0.173551, 0.174046,
  0.174522, 0.17498, 0.17542, 0.175842, 0.176246, 0.176632, 0.176999,
  0.177348, 0.177679, 0.177991, 0.178285, 0.17856, 0.178817, 0.179055,
  0.179275, 0.179475, 0.179658, 0.179821, 0.179966, 0.180092,
  0.180199, 0.180287, 0.180357, 0.180407, 0.180439, 0.180452,
  0.180446, 0.180421, 0.180377, 0.180314, 0.180232, 0.180131,
  0.180012, 0.179873, 0.179715, 0.179539, 0.179343, 0.179129,
  0.178896, 0.178644, 0.178372, 0.178083, 0.177774, 0.177446, 0.1771,
  0.176734, 0.17635, 0.175948, 0.175526, 0.175086, 0.174627, 0.17415,
  0.173654, 0.173139, 0.172606, 0.172055, 0.171485, 0.170897,
  0.170291, 0.169666, 0.169023, 0.168362, 0.167683, 0.166986,
  0.166271, 0.165538, 0.164787, 0.164019, 0.163233, 0.162429,
  0.161607, 0.160768, 0.159912, 0.159039, 0.158148, 0.15724, 0.156315,
  0.155373, 0.154414, 0.153438, 0.152446, 0.151437, 0.150411,
  0.149369, 0.148311, 0.147236, 0.146145, 0.145039, 0.143916,
  0.142778, 0.141623, 0.140454, 0.139269, 0.138068, 0.136852,
  0.135621, 0.134375, 0.133115, 0.131839, 0.130549, 0.129244,
  0.127925, 0.126592, 0.125245, 0.123884, 0.122508, 0.12112, 0.119717,
  0.118301, 0.116872, 0.11543, 0.113975, 0.112507, 0.111026, 0.109533,
  0.108027, 0.106509, 0.104979, 0.103437, 0.101883, 0.100318,
  0.0987412, 0.0971531, 0.0955539, 0.0939437, 0.0923227, 0.0906911,
  0.089049, 0.0873967, 0.0857342, 0.0840617, 0.0823795, 0.0806877,
  0.0789864, 0.0772759, 0.0755563, 0.0738278, 0.0720907, 0.0703449,
  0.0685909, 0.0668286, 0.0650584, 0.0632804, 0.0614948, 0.0597018,
  0.0579015, 0.0560942, 0.0542801, 0.0524593, 0.050632, 0.0487985,
  0.0469589, 0.0451134, 0.0432622, 0.0414056, 0.0395437, 0.0376766,
  0.0358047, 0.0339282, 0.0320471, 0.0301617, 0.0282723, 0.026379,
  0.0244821, 0.0225816, 0.0206779, 0.0187712, 0.0168616, 0.0149494,
  0.0130347, 0.0111178, 0.00919895, 0.00727825, 0.00535595,
  0.00343228, 0.00150743, -0.000418384, -0.00234495, -0.00427205,
  -0.00619948, -0.00812702, -0.0100545, -0.0119816, -0.0139082,
  -0.0158341, -0.017759, -0.0196828, -0.0216051, -0.0235259,
  -0.0254449, -0.0273619, -0.0292766, -0.0311888, -0.0330985,
  -0.0350052, -0.0369088, -0.0388092, -0.040706, -0.042599,
  -0.0444882, -0.0463731, -0.0482537, -0.0501297, -0.0520009,
  -0.0538671, -0.0557281, -0.0575836, -0.0594335, -0.0612775,
  -0.0631154, -0.0649471, -0.0667723, -0.0685907, -0.0704023,
  -0.0722067, -0.0740038, -0.0757933, -0.0775751, -0.079349,
  -0.0811147, -0.082872, -0.0846208, -0.0863608, -0.0880918,
  -0.0898136, -0.0915261, -0.093229, -0.0949221, -0.0966052,
  -0.0982781, -0.0999406, -0.101593, -0.103234, -0.104864, -0.106483,
  -0.108091, -0.109687, -0.111271, -0.112844, -0.114404, -0.115952,
  -0.117488, -0.119011, -0.120521, -0.122018, -0.123502, -0.124972,
  -0.126429, -0.127872, -0.129301, -0.130716, -0.132117, -0.133503,
  -0.134875, -0.136231, -0.137573, -0.1389, -0.140211, -0.141507,
  -0.142787, -0.144052, -0.1453, -0.146533, -0.147749, -0.148948,
  -0.150131, -0.151298, -0.152447, -0.15358, -0.154695, -0.155793,
  -0.156873, -0.157936, -0.158982, -0.160009, -0.161018, -0.162009,
  -0.162982, -0.163936, -0.164872, -0.165789, -0.166688, -0.167567,
  -0.168428, -0.169269, -0.170091, -0.170894, -0.171677, -0.172441,
  -0.173184, -0.173908, -0.174613, -0.175297, -0.175961, -0.176604,
  -0.177228, -0.177831, -0.178413, -0.178975, -0.179517, -0.180037,
  -0.180537, -0.181015, -0.181473, -0.18191, -0.182325, -0.18272,
  -0.183093, -0.183444, -0.183775, -0.184083, -0.184371, -0.184636,
  -0.18488, -0.185103, -0.185303, -0.185482, -0.185639, -0.185774,
  -0.185887, -0.185979, -0.186048, -0.186095, -0.18612, -0.186124,
  -0.186105, -0.186064, -0.186, -0.185915, -0.185808, -0.185678,
  -0.185526, -0.185352, -0.185156, -0.184938, -0.184697, -0.184434,
  -0.184149, -0.183842, -0.183513, -0.183162, -0.182788, -0.182393,
  -0.181975, -0.181535, -0.181074, -0.18059, -0.180084, -0.179557,
  -0.179007, -0.178436, -0.177843, -0.177228, -0.176592, -0.175933,
  -0.175254, -0.174552, -0.17383, -0.173086, -0.17232, -0.171533,
  -0.170725, -0.169896, -0.169046, -0.168175, -0.167283, -0.16637,
  -0.165437, -0.164483, -0.163508, -0.162513, -0.161497, -0.160462,
  -0.159406, -0.15833, -0.157234, -0.156118, -0.154983, -0.153828,
  -0.152654, -0.15146, -0.150247, -0.149015, -0.147764, -0.146494,
  -0.145205, -0.143898, -0.142572, -0.141228, -0.139866, -0.138486,
  -0.137088, -0.135672, -0.134239, -0.132789, -0.131321, -0.129836,
  -0.128334, -0.126815, -0.12528, -0.123728, -0.12216, -0.120576,
  -0.118977, -0.117361, -0.11573, -0.114083, -0.112422, -0.110745,
  -0.109054, -0.107348, -0.105627, -0.103893, -0.102144, -0.100381,
  -0.0986053, -0.0968158, -0.0950131, -0.0931974, -0.091369,
  -0.0895279, -0.0876745, -0.085809, -0.0839315, -0.0820424,
  -0.0801417, -0.0782299, -0.0763069, -0.0743732, -0.0724289,
  -0.0704743, -0.0685096, -0.0665349, -0.0645507, -0.062557,
  -0.0605542, -0.0585424, -0.056522, -0.0544931, -0.0524561,
  -0.0504111, -0.0483584, -0.0462982, -0.0442309, -0.0421566,
  -0.0400756, -0.0379882, -0.0358947, -0.0337952, -0.03169,
  -0.0295794, -0.0274637, -0.0253432, -0.023218, -0.0210884,
  -0.0189548, -0.0168174, -0.0146764, -0.0125322, -0.0103849,
  -0.00823488, -0.00608241, -0.00392775, -0.00177116, 0.000387071,
  0.00254667, 0.00470737, 0.00686889, 0.00903096, 0.0111933,
  0.0133556, 0.0155176, 0.0176791, 0.0198397, 0.0219992, 0.0241572,
  0.0263136, 0.028468, 0.0306202, 0.0327698, 0.0349166, 0.0370603,
  0.0392006, 0.0413373, 0.04347, 0.0455985, 0.0477224, 0.0498416,
  0.0519557, 0.0540644, 0.0561675, 0.0582647, 0.0603556, 0.0624401,
  0.0645178, 0.0665884, 0.0686518, 0.0707074, 0.0727552, 0.0747949,
  0.076826, 0.0788485, 0.0808619, 0.0828661, 0.0848606, 0.0868454,
  0.08882, 0.0907842, 0.0927377, 0.0946804, 0.0966118, 0.0985317,
  0.10044, 0.102336, 0.10422, 0.106091, 0.10795, 0.109795, 0.111627,
  0.113445, 0.11525, 0.11704, 0.118816, 0.120577, 0.122324, 0.124055,
  0.125771, 0.127471, 0.129155, 0.130823, 0.132474, 0.134109,
  0.135727, 0.137328, 0.138912, 0.140477, 0.142025, 0.143555,
  0.145066, 0.146559, 0.148033, 0.149488, 0.150924, 0.15234, 0.153737,
  0.155114, 0.15647, 0.157806, 0.159122, 0.160417, 0.161691, 0.162943,
  0.164174, 0.165384, 0.166572, 0.167738, 0.168882, 0.170003,
  0.171102, 0.172178, 0.173231, 0.174261, 0.175268, 0.176251,
  0.177211, 0.178146, 0.179058, 0.179946, 0.180809, 0.181648,
  0.182463, 0.183253, 0.184017, 0.184757, 0.185472, 0.186161,
  0.186825, 0.187463, 0.188075, 0.188662, 0.189222, 0.189757,
  0.190265, 0.190747, 0.191203, 0.191632, 0.192034, 0.19241, 0.192759,
  0.193081, 0.193376, 0.193644, 0.193884, 0.194098, 0.194284,
  0.194442, 0.194574, 0.194677, 0.194753, 0.194802, 0.194822,
  0.194815, 0.194781, 0.194718, 0.194627, 0.194509, 0.194363,
  0.194188, 0.193986, 0.193756, 0.193498, 0.193211, 0.192897,
  0.192555, 0.192184, 0.191786, 0.191359, 0.190905, 0.190422,
  0.189912, 0.189374, 0.188808, 0.188214, 0.187592, 0.186942,
  0.186265, 0.18556, 0.184827, 0.184067, 0.183279, 0.182464, 0.181621,
  0.180751, 0.179854, 0.17893, 0.177978, 0.177, 0.175995, 0.174963,
  0.173905, 0.17282, 0.171708, 0.17057, 0.169406, 0.168216, 0.167,
  0.165759, 0.164491, 0.163198, 0.16188, 0.160536, 0.159168, 0.157774,
  0.156356, 0.154913, 0.153445, 0.151954, 0.150438, 0.148898,
  0.147335, 0.145748, 0.144138, 0.142505, 0.140849, 0.13917, 0.137469,
  0.135745, 0.134, 0.132232, 0.130443, 0.128633, 0.126801, 0.124948,
  0.123075, 0.121181, 0.119267, 0.117334, 0.11538, 0.113407, 0.111415,
  0.109404, 0.107375, 0.105327, 0.103261, 0.101177, 0.0990762,
  0.0969578, 0.0948225, 0.0926705, 0.0905023, 0.088318, 0.086118,
  0.0839025, 0.081672, 0.0794268, 0.077167, 0.0748931, 0.0726054,
  0.0703042, 0.0679898, 0.0656626, 0.0633229, 0.0609711, 0.0586074,
  0.0562323, 0.0538461, 0.051449, 0.0490416, 0.0466241, 0.0441969,
  0.0417604, 0.0393149, 0.0368607, 0.0343984, 0.0319281, 0.0294503,
  0.0269655, 0.0244738, 0.0219758, 0.0194718, 0.0169622, 0.0144474,
  0.0119277, 0.00940363, 0.00687548, 0.00434367, 0.00180859,
  -0.000729345, -0.00326975, -0.00581223, -0.00835637, -0.0109018,
  -0.013448, -0.0159947, -0.0185415, -0.0210879, -0.0236335,
  -0.026178, -0.0287208, -0.0312616, -0.0338, -0.0363356, -0.0388679,
  -0.0413966, -0.0439211, -0.0464412, -0.0489563, -0.0514661,
  -0.0539701, -0.056468, -0.0589592, -0.0614434, -0.0639202,
  -0.0663891, -0.0688497, -0.0713017, -0.0737444, -0.0761777,
  -0.078601, -0.0810138, -0.0834159, -0.0858068, -0.088186,
  -0.0905531, -0.0929077, -0.0952495, -0.0975779, -0.0998926,
  -0.102193, -0.104479, -0.10675, -0.109006, -0.111246, -0.113469,
  -0.115676, -0.117866, -0.120039, -0.122194, -0.12433, -0.126448,
  -0.128547, -0.130626, -0.132686, -0.134725, -0.136744, -0.138742,
  -0.140718, -0.142673, -0.144606, -0.146516, -0.148403, -0.150267,
  -0.152107, -0.153923, -0.155715, -0.157482, -0.159224, -0.16094,
  -0.162631, -0.164296, -0.165934, -0.167545, -0.169129, -0.170685,
  -0.172214, -0.173714, -0.175186, -0.176629, -0.178043, -0.179427,
  -0.180782, -0.182106, -0.1834, -0.184664, -0.185896, -0.187097,
  -0.188267, -0.189405, -0.19051, -0.191583, -0.192624, -0.193631,
  -0.194606, -0.195547, -0.196454, -0.197327, -0.198166, -0.198971,
  -0.199741, -0.200477, -0.201177, -0.201842, -0.202471, -0.203065,
  -0.203623, -0.204145, -0.20463, -0.205079, -0.205492, -0.205868,
  -0.206206, -0.206508, -0.206773, -0.207, -0.207189, -0.207341,
  -0.207456, -0.207532, -0.20757, -0.207571, -0.207533, -0.207457,
  -0.207342, -0.207189, -0.206997, -0.206767, -0.206499, -0.206191,
  -0.205845, -0.20546, -0.205036, -0.204574, -0.204073, -0.203532,
  -0.202953, -0.202336, -0.201679, -0.200983, -0.200249, -0.199476,
  -0.198664, -0.197814, -0.196925, -0.195998, -0.195032, -0.194027,
  -0.192985, -0.191904, -0.190785, -0.189628, -0.188434, -0.187201,
  -0.185931, -0.184624, -0.183279, -0.181897, -0.180478, -0.179022,
  -0.17753, -0.176001, -0.174435, -0.172834, -0.171197, -0.169524,
  -0.167816, -0.166073, -0.164295, -0.162482, -0.160634, -0.158753,
  -0.156837, -0.154888, -0.152906, -0.15089, -0.148842, -0.146762,
  -0.144649, -0.142504, -0.140328, -0.138121, -0.135884, -0.133615,
  -0.131317, -0.128989, -0.126632, -0.124246, -0.121832, -0.119389,
  -0.116919, -0.114421, -0.111897, -0.109346, -0.106769, -0.104166,
  -0.101539, -0.0988867, -0.0962103, -0.0935103, -0.0907871,
  -0.0880411, -0.085273, -0.082483, -0.0796719, -0.07684, -0.073988,
  -0.0711163, -0.0682254, -0.065316, -0.0623885, -0.0594435,
  -0.0564816, -0.0535033, -0.0505091, -0.0474998, -0.0444758,
  -0.0414378, -0.0383863, -0.0353219, -0.0322452, -0.029157,
  -0.0260576, -0.0229479, -0.0198283, -0.0166996, -0.0135624,
  -0.0104173, -0.00726489, -0.00410593, -0.000941033, 0.00222915,
  0.00540394, 0.00858269, 0.0117647, 0.0149494, 0.0181359, 0.0213237,
  0.0245121, 0.0277003, 0.0308878, 0.0340736, 0.0372573, 0.0404381,
  0.0436152, 0.046788, 0.0499557, 0.0531177, 0.0562733, 0.0594216,
  0.062562, 0.0656938, 0.0688163, 0.0719286, 0.0750302, 0.0781202,
  0.081198, 0.0842628, 0.0873139, 0.0903505, 0.0933719, 0.0963774,
  0.0993663, 0.102338, 0.105291, 0.108226, 0.111141, 0.114035,
  0.116909, 0.119761, 0.12259, 0.125397, 0.128179, 0.130936, 0.133669,
  0.136375, 0.139054, 0.141706, 0.144329, 0.146923, 0.149488,
  0.152023, 0.154526, 0.156998, 0.159437, 0.161843, 0.164215,
  0.166552, 0.168855, 0.171121, 0.173351, 0.175544, 0.177698,
  0.179815, 0.181892, 0.183929, 0.185926, 0.187882, 0.189796,
  0.191667, 0.193496, 0.195281, 0.197022, 0.198719, 0.20037, 0.201975,
  0.203533, 0.205045, 0.206509, 0.207925, 0.209292, 0.21061, 0.211878,
  0.213096, 0.214264, 0.21538, 0.216445, 0.217457, 0.218417, 0.219324,
  0.220177, 0.220977, 0.221722, 0.222412, 0.223047, 0.223627,
  0.224151, 0.224618, 0.225029, 0.225383, 0.22568, 0.225919, 0.2261,
  0.226224, 0.226288, 0.226294, 0.226242, 0.22613, 0.225958, 0.225727,
  0.225437, 0.225086, 0.224676, 0.224205, 0.223673, 0.223082,
  0.222429, 0.221716, 0.220942, 0.220108, 0.219212, 0.218256,
  0.217239, 0.216161, 0.215022, 0.213822, 0.212562, 0.211241,
  0.209859, 0.208417, 0.206915, 0.205352, 0.203729, 0.202047,
  0.200305, 0.198503, 0.196642, 0.194722, 0.192744, 0.190707,
  0.188612, 0.186459, 0.184249, 0.181982, 0.179658, 0.177277,
  0.174841, 0.172349, 0.169802, 0.167201, 0.164545, 0.161836,
  0.159074, 0.15626, 0.153393, 0.150475, 0.147507, 0.144488, 0.141419,
  0.138302, 0.135137, 0.131924, 0.128665, 0.125359, 0.122008,
  0.118613, 0.115174, 0.111692, 0.108168, 0.104602, 0.100997,
  0.0973514, 0.0936676, 0.0899461, 0.0861878, 0.0823938, 0.078565,
  0.0747024, 0.0708069, 0.0668796, 0.0629217, 0.058934, 0.0549177,
  0.0508739, 0.0468038, 0.0427083, 0.0385888, 0.0344463, 0.030282,
  0.0260971, 0.0218929, 0.0176705, 0.0134312, 0.00917633, 0.00490706,
  0.0006247, -0.00366943, -0.00797403, -0.0122878, -0.0166093,
  -0.0209372, -0.0252702, -0.0296069, -0.0339458, -0.0382856,
  -0.0426248, -0.0469621, -0.0512959, -0.0556248, -0.0599474,
  -0.0642621, -0.0685675, -0.0728621, -0.0771444, -0.0814128,
  -0.0856659, -0.0899021, -0.0941199, -0.0983176, -0.102494,
  -0.106647, -0.110776, -0.114878, -0.118952, -0.122997, -0.127012,
  -0.130993, -0.134941, -0.138852, -0.142727, -0.146562, -0.150357,
  -0.15411, -0.157819, -0.161483, -0.1651, -0.168669, -0.172187,
  -0.175654, -0.179067, -0.182426, -0.185728, -0.188972, -0.192157,
  -0.19528, -0.198341, -0.201338, -0.204269, -0.207132, -0.209927,
  -0.212652, -0.215305, -0.217884, -0.220389, -0.222818, -0.22517,
  -0.227442, -0.229634, -0.231744, -0.23377, -0.235713, -0.237569,
  -0.239338, -0.241019, -0.24261, -0.24411, -0.245518, -0.246832,
  -0.248052, -0.249176, -0.250203, -0.251132, -0.251962, -0.252692,
  -0.25332, -0.253847, -0.25427, -0.254589, -0.254804, -0.254912,
  -0.254914, -0.254809, -0.254596, -0.254273, -0.253841, -0.253299,
  -0.252646, -0.251882, -0.251005, -0.250017, -0.248915, -0.247701,
  -0.246373, -0.244931, -0.243374, -0.241704, -0.239919, -0.23802,
  -0.236006, -0.233877, -0.231633, -0.229275, -0.226803, -0.224217,
  -0.221516, -0.218702, -0.215774, -0.212734, -0.209581, -0.206317,
  -0.202941, -0.199454, -0.195858, -0.192152, -0.188338, -0.184417,
  -0.180389, -0.176256, -0.172018, -0.167678, -0.163235, -0.158692,
  -0.154049, -0.149308, -0.144471, -0.139539, -0.134514, -0.129397,
  -0.12419, -0.118896, -0.113515, -0.10805, -0.102503, -0.0968764,
  -0.0911718, -0.0853917, -0.0795384, -0.0736143, -0.0676219,
  -0.0615637, -0.0554424, -0.0492607, -0.0430213, -0.036727,
  -0.0303809, -0.0239857, -0.0175447, -0.0110609, -0.00453757,
  0.00202207, 0.00861467, 0.0152368, 0.021885, 0.0285557, 0.0352452,
  0.0419499, 0.0486661, 0.0553898, 0.0621173, 0.0688444, 0.0755673,
  0.0822817, 0.0889837, 0.0956688, 0.102333, 0.108972, 0.115581,
  0.122155, 0.128691, 0.135184, 0.141629, 0.148021, 0.154355,
  0.160628, 0.166834, 0.172968, 0.179025, 0.185001, 0.19089, 0.196687,
  0.202388, 0.207987, 0.213479, 0.21886, 0.224123, 0.229263, 0.234277,
  0.239157, 0.2439, 0.248499, 0.25295, 0.257247, 0.261386, 0.265361,
  0.269166, 0.272797, 0.276248, 0.279515, 0.282591, 0.285473,
  0.288155, 0.290632, 0.292899, 0.294951, 0.296783, 0.298391, 0.29977,
  0.300915, 0.301822, 0.302486, 0.302903, 0.303068, 0.302978,
  0.302629, 0.302016, 0.301135, 0.299984, 0.298558, 0.296855, 0.29487,
  0.292602, 0.290047, 0.287202, 0.284065, 0.280634, 0.276907,
  0.272882, 0.268557, 0.263931, 0.259003, 0.253772, 0.248238,
  0.242399, 0.236257, 0.229812, 0.223064, 0.216014, 0.208664,
  0.201015, 0.193069, 0.184829, 0.176298, 0.167479, 0.158375,
  0.148991, 0.139332, 0.129402, 0.119206, 0.108752, 0.0980455,
  0.0870934, 0.0759037, 0.0644844, 0.0528444, 0.0409932, 0.0289407,
  0.0166977, 0.00427544, -0.00831404, -0.021058, -0.0339431,
  -0.046955, -0.0600789, -0.073299, -0.0865988, -0.099961, -0.113367,
  -0.126799, -0.140235, -0.153656, -0.167039, -0.180361, -0.193599,
  -0.206728, -0.219722, -0.232554, -0.245196, -0.257619, -0.269792,
  -0.281684, -0.293262, -0.304492, -0.315339, -0.325766, -0.335735,
  -0.345206, -0.35414, -0.362494, -0.370224, -0.377284, -0.383629,
  -0.38921, -0.393977, -0.397878, -0.40086, -0.402869, -0.403846,
  -0.403734, -0.402472, -0.399997, -0.396246, -0.391152, -0.384646,
  -0.376659, -0.367117, -0.355946, -0.343069, -0.328407, -0.311878,
  -0.293398, -0.272882, -0.250239, -0.225381, -0.198211, -0.168634,
  -0.136552, -0.101861, -0.0644574, -0.0242339, 0.01892, 0.0651177,
  0.114475, 0.167113, 0.223152, 0.282719, 0.345943, 0.412957,
  0.483895, 0.558898, 0.638107, 0.72167, 0.809737, 0.902461, 1};
  const G4double G4NeutronHPFastLegendre::i20[4201] = {0, 0.000452767,
  0.000860239, 0.00122467, 0.00154825, 0.00183307, 0.00208119,
  0.00229456, 0.00247509, 0.00262462, 0.00274492, 0.0028377,
  0.00290461, 0.00294724, 0.00296712, 0.00296573, 0.0029445,
  0.00290478, 0.00284791, 0.00277514, 0.0026877, 0.00258675,
  0.00247341, 0.00234877, 0.00221386, 0.00206966, 0.00191713,
  0.00175718, 0.00159068, 0.00141845, 0.0012413, 0.00105997,
  0.000875202, 0.00068767, 0.000498034, 0.000306919, 0.000114917,
  -7.74095e-05, -0.000269528, -0.000460933, -0.000651147,
  -0.000839721, -0.00102623, -0.00121027, -0.00139147, -0.00156948,
  -0.00174396, -0.00191461, -0.00208115, -0.0022433, -0.00240082,
  -0.00255348, -0.00270107, -0.00284341, -0.00298032, -0.00311163,
  -0.00323722, -0.00335694, -0.0034707, -0.00357839, -0.00367994,
  -0.00377526, -0.0038643, -0.00394702, -0.00402337, -0.00409335,
  -0.00415693, -0.00421411, -0.0042649, -0.00430932, -0.00434739,
  -0.00437914, -0.00440462, -0.00442388, -0.00443697, -0.00444395,
  -0.00444491, -0.00443991, -0.00442903, -0.00441238, -0.00439002,
  -0.00436208, -0.00432865, -0.00428983, -0.00424574, -0.00419649,
  -0.0041422, -0.004083, -0.004019, -0.00395034, -0.00387715,
  -0.00379956, -0.00371769, -0.0036317, -0.00354171, -0.00344787,
  -0.00335031, -0.00324919, -0.00314463, -0.00303679, -0.00292581,
  -0.00281183, -0.002695, -0.00257546, -0.00245336, -0.00232884,
  -0.00220205, -0.00207312, -0.00194221, -0.00180945, -0.00167498,
  -0.00153895, -0.0014015, -0.00126276, -0.00112288, -0.000981979,
  -0.000840202, -0.000697681, -0.000554546, -0.000410928,
  -0.000266954, -0.000122751, 2.15562e-05, 0.000165845, 0.000309996,
  0.000453888, 0.000597407, 0.000740437, 0.000882866, 0.00102458,
  0.00116548, 0.00130545, 0.0014444, 0.00158221, 0.0017188,
  0.00185406, 0.0019879, 0.00212024, 0.00225097, 0.00238001,
  0.00250729, 0.00263271, 0.0027562, 0.00287769, 0.00299708,
  0.00311433, 0.00322935, 0.00334208, 0.00345245, 0.0035604,
  0.00366588, 0.00376882, 0.00386917, 0.00396689, 0.00406191,
  0.00415419, 0.00424369, 0.00433037, 0.00441418, 0.00449509,
  0.00457306, 0.00464806, 0.00472006, 0.00478902, 0.00485493,
  0.00491776, 0.00497749, 0.00503409, 0.00508756, 0.00513787,
  0.00518502, 0.00522898, 0.00526976, 0.00530734, 0.00534173,
  0.00537291, 0.00540089, 0.00542566, 0.00544724, 0.00546562,
  0.00548081, 0.00549281, 0.00550165, 0.00550733, 0.00550986,
  0.00550926, 0.00550554, 0.00549873, 0.00548884, 0.0054759,
  0.00545992, 0.00544093, 0.00541895, 0.00539402, 0.00536616,
  0.0053354, 0.00530177, 0.0052653, 0.00522603, 0.00518399,
  0.00513921, 0.00509173, 0.0050416, 0.00498884, 0.0049335,
  0.00487562, 0.00481524, 0.0047524, 0.00468715, 0.00461952,
  0.00454957, 0.00447734, 0.00440287, 0.00432622, 0.00424743,
  0.00416654, 0.00408361, 0.00399869, 0.00391183, 0.00382308,
  0.00373248, 0.00364009, 0.00354596, 0.00345015, 0.0033527,
  0.00325368, 0.00315312, 0.00305109, 0.00294764, 0.00284282,
  0.00273669, 0.0026293, 0.0025207, 0.00241096, 0.00230012,
  0.00218824, 0.00207537, 0.00196157, 0.00184689, 0.00173139,
  0.00161513, 0.00149814, 0.0013805, 0.00126226, 0.00114346,
  0.00102416, 0.000904423, 0.000784293, 0.000663825, 0.000543073,
  0.000422089, 0.000300926, 0.000179634, 5.82672e-05, -6.31246e-05,
  -0.00018449, -0.000305778, -0.00042694, -0.000547924, -0.000668682,
  -0.000789166, -0.000909325, -0.00102911, -0.00114848, -0.00126739,
  -0.00138578, -0.00150361, -0.00162084, -0.00173742, -0.00185331,
  -0.00196847, -0.00208284, -0.0021964, -0.00230908, -0.00242087,
  -0.00253171, -0.00264157, -0.0027504, -0.00285816, -0.00296483,
  -0.00307036, -0.00317471, -0.00327786, -0.00337975, -0.00348037,
  -0.00357967, -0.00367763, -0.0037742, -0.00386937, -0.00396309,
  -0.00405534, -0.00414609, -0.0042353, -0.00432296, -0.00440903,
  -0.00449349, -0.00457631, -0.00465747, -0.00473694, -0.0048147,
  -0.00489073, -0.004965, -0.00503749, -0.00510819, -0.00517707,
  -0.00524412, -0.00530931, -0.00537263, -0.00543406, -0.00549358,
  -0.00555119, -0.00560687, -0.0056606, -0.00571236, -0.00576216,
  -0.00580997, -0.00585579, -0.00589961, -0.00594141, -0.00598119,
  -0.00601894, -0.00605466, -0.00608833, -0.00611996, -0.00614954,
  -0.00617705, -0.00620251, -0.00622591, -0.00624724, -0.0062665,
  -0.0062837, -0.00629883, -0.0063119, -0.0063229, -0.00633184,
  -0.00633872, -0.00634354, -0.00634631, -0.00634704, -0.00634572,
  -0.00634237, -0.00633698, -0.00632958, -0.00632016, -0.00630873,
  -0.0062953, -0.00627989, -0.0062625, -0.00624314, -0.00622183,
  -0.00619857, -0.00617338, -0.00614627, -0.00611726, -0.00608635,
  -0.00605357, -0.00601892, -0.00598243, -0.00594411, -0.00590397,
  -0.00586203, -0.00581831, -0.00577283, -0.0057256, -0.00567664,
  -0.00562598, -0.00557363, -0.00551962, -0.00546395, -0.00540666,
  -0.00534776, -0.00528728, -0.00522523, -0.00516164, -0.00509654,
  -0.00502993, -0.00496186, -0.00489233, -0.00482138, -0.00474903,
  -0.0046753, -0.00460022, -0.00452381, -0.0044461, -0.00436711,
  -0.00428687, -0.0042054, -0.00412274, -0.0040389, -0.00395391,
  -0.0038678, -0.0037806, -0.00369234, -0.00360303, -0.00351271,
  -0.00342141, -0.00332916, -0.00323597, -0.00314189, -0.00304693,
  -0.00295113, -0.00285452, -0.00275711, -0.00265895, -0.00256006,
  -0.00246047, -0.0023602, -0.0022593, -0.00215777, -0.00205567,
  -0.001953, -0.00184981, -0.00174612, -0.00164195, -0.00153735,
  -0.00143234, -0.00132694, -0.00122119, -0.00111511, -0.00100874,
  -0.0009021, -0.000795222, -0.000688133, -0.000580863, -0.000473441,
  -0.000365894, -0.000258251, -0.000150542, -4.27925e-05, 6.49678e-05,
  0.000172711, 0.00028041, 0.000388036, 0.000495562, 0.00060296,
  0.000710203, 0.000817264, 0.000924116, 0.00103073, 0.00113709,
  0.00124315, 0.0013489, 0.0014543, 0.00155934, 0.00166399,
  0.00176821, 0.001872, 0.00197531, 0.00207813, 0.00218042,
  0.00228218, 0.00238337, 0.00248396, 0.00258394, 0.00268328,
  0.00278195, 0.00287995, 0.00297723, 0.00307378, 0.00316958,
  0.0032646, 0.00335883, 0.00345223, 0.0035448, 0.00363651,
  0.00372734, 0.00381726, 0.00390626, 0.00399433, 0.00408143,
  0.00416755, 0.00425267, 0.00433678, 0.00441985, 0.00450187,
  0.00458282, 0.00466268, 0.00474143, 0.00481907, 0.00489557,
  0.00497091, 0.00504508, 0.00511807, 0.00518986, 0.00526044,
  0.00532978, 0.00539789, 0.00546474, 0.00553032, 0.00559461,
  0.00565761, 0.00571931, 0.00577969, 0.00583873, 0.00589643,
  0.00595279, 0.00600777, 0.00606139, 0.00611362, 0.00616446,
  0.00621389, 0.00626192, 0.00630852, 0.0063537, 0.00639745,
  0.00643975, 0.0064806, 0.00652, 0.00655793, 0.0065944, 0.00662939,
  0.0066629, 0.00669492, 0.00672546, 0.00675451, 0.00678205,
  0.0068081, 0.00683264, 0.00685567, 0.0068772, 0.00689721,
  0.00691571, 0.00693269, 0.00694816, 0.00696211, 0.00697454,
  0.00698546, 0.00699485, 0.00700273, 0.00700909, 0.00701393,
  0.00701726, 0.00701908, 0.00701939, 0.00701819, 0.00701548,
  0.00701127, 0.00700556, 0.00699835, 0.00698965, 0.00697947,
  0.0069678, 0.00695465, 0.00694003, 0.00692395, 0.0069064,
  0.00688739, 0.00686693, 0.00684503, 0.0068217, 0.00679693,
  0.00677075, 0.00674314, 0.00671414, 0.00668373, 0.00665193,
  0.00661875, 0.00658421, 0.00654829, 0.00651103, 0.00647242,
  0.00643248, 0.00639121, 0.00634863, 0.00630475, 0.00625958,
  0.00621312, 0.0061654, 0.00611642, 0.0060662, 0.00601474,
  0.00596207, 0.00590818, 0.0058531, 0.00579683, 0.0057394,
  0.00568081, 0.00562107, 0.00556021, 0.00549823, 0.00543515,
  0.00537098, 0.00530574, 0.00523944, 0.0051721, 0.00510373,
  0.00503434, 0.00496396, 0.0048926, 0.00482026, 0.00474698,
  0.00467275, 0.00459761, 0.00452157, 0.00444463, 0.00436683,
  0.00428817, 0.00420867, 0.00412835, 0.00404722, 0.00396531,
  0.00388262, 0.00379918, 0.00371501, 0.00363011, 0.00354452,
  0.00345824, 0.00337129, 0.00328369, 0.00319546, 0.00310662,
  0.00301718, 0.00292716, 0.00283659, 0.00274547, 0.00265383,
  0.00256168, 0.00246905, 0.00237594, 0.00228239, 0.0021884, 0.002094,
  0.0019992, 0.00190403, 0.0018085, 0.00171262, 0.00161643,
  0.00151993, 0.00142314, 0.00132609, 0.0012288, 0.00113127,
  0.00103353, 0.000935597, 0.000837492, 0.000739231, 0.000640832,
  0.000542315, 0.000443698, 0.000344998, 0.000246235, 0.000147427,
  4.85911e-05, -5.02535e-05, -0.000149089, -0.000247897, -0.00034666,
  -0.000445359, -0.000543977, -0.000642496, -0.000740898,
  -0.000839165, -0.000937279, -0.00103522, -0.00113298, -0.00123053,
  -0.00132786, -0.00142495, -0.00152178, -0.00161834, -0.00171461,
  -0.00181056, -0.0019062, -0.00200149, -0.00209642, -0.00219098,
  -0.00228515, -0.0023789, -0.00247224, -0.00256513, -0.00265757,
  -0.00274954, -0.00284102, -0.002932, -0.00302245, -0.00311238,
  -0.00320175, -0.00329056, -0.00337879, -0.00346642, -0.00355345,
  -0.00363985, -0.00372562, -0.00381073, -0.00389518, -0.00397895,
  -0.00406202, -0.00414438, -0.00422603, -0.00430694, -0.0043871,
  -0.0044665, -0.00454513, -0.00462297, -0.00470001, -0.00477624,
  -0.00485165, -0.00492622, -0.00499994, -0.00507281, -0.0051448,
  -0.00521591, -0.00528613, -0.00535545, -0.00542385, -0.00549133,
  -0.00555786, -0.00562346, -0.00568809, -0.00575176, -0.00581446,
  -0.00587617, -0.00593688, -0.00599659, -0.00605529, -0.00611296,
  -0.00616961, -0.00622521, -0.00627977, -0.00633328, -0.00638572,
  -0.00643709, -0.00648738, -0.00653659, -0.00658471, -0.00663172,
  -0.00667764, -0.00672244, -0.00676612, -0.00680868, -0.0068501,
  -0.00689039, -0.00692954, -0.00696755, -0.0070044, -0.0070401,
  -0.00707463, -0.007108, -0.0071402, -0.00717123, -0.00720108,
  -0.00722974, -0.00725723, -0.00728352, -0.00730863, -0.00733254,
  -0.00735525, -0.00737677, -0.00739708, -0.00741619, -0.0074341,
  -0.0074508, -0.00746629, -0.00748057, -0.00749364, -0.0075055,
  -0.00751615, -0.00752558, -0.00753381, -0.00754082, -0.00754661,
  -0.0075512, -0.00755457, -0.00755673, -0.00755769, -0.00755743,
  -0.00755596, -0.00755329, -0.00754942, -0.00754434, -0.00753806,
  -0.00753058, -0.0075219, -0.00751204, -0.00750098, -0.00748873,
  -0.0074753, -0.00746068, -0.00744489, -0.00742792, -0.00740979,
  -0.00739048, -0.00737001, -0.00734839, -0.00732561, -0.00730169,
  -0.00727661, -0.00725041, -0.00722306, -0.00719459, -0.007165,
  -0.00713428, -0.00710246, -0.00706953, -0.00703551, -0.00700039,
  -0.00696418, -0.0069269, -0.00688854, -0.00684912, -0.00680864,
  -0.0067671, -0.00672453, -0.00668091, -0.00663627, -0.00659061,
  -0.00654393, -0.00649625, -0.00644758, -0.00639791, -0.00634727,
  -0.00629565, -0.00624308, -0.00618955, -0.00613507, -0.00607966,
  -0.00602333, -0.00596608, -0.00590792, -0.00584887, -0.00578893,
  -0.00572811, -0.00566642, -0.00560388, -0.00554049, -0.00547626,
  -0.00541121, -0.00534535, -0.00527867, -0.00521121, -0.00514296,
  -0.00507394, -0.00500415, -0.00493362, -0.00486235, -0.00479035,
  -0.00471763, -0.00464421, -0.0045701, -0.00449531, -0.00441985,
  -0.00434372, -0.00426696, -0.00418956, -0.00411153, -0.0040329,
  -0.00395367, -0.00387386, -0.00379347, -0.00371252, -0.00363103,
  -0.003549, -0.00346644, -0.00338338, -0.00329981, -0.00321577,
  -0.00313125, -0.00304627, -0.00296084, -0.00287498, -0.0027887,
  -0.00270201, -0.00261493, -0.00252747, -0.00243963, -0.00235145,
  -0.00226291, -0.00217405, -0.00208488, -0.0019954, -0.00190563,
  -0.00181559, -0.00172528, -0.00163472, -0.00154393, -0.00145291,
  -0.00136169, -0.00127027, -0.00117866, -0.00108688, -0.000994953,
  -0.000902878, -0.000810674, -0.000718353, -0.00062593, -0.000533416,
  -0.000440827, -0.000348174, -0.000255471, -0.000162732,
  -6.99704e-05, 2.28017e-05, 0.000115571, 0.000208323, 0.000301046,
  0.000393725, 0.000486349, 0.000578904, 0.000671377, 0.000763755,
  0.000856025, 0.000948173, 0.00104019, 0.00113206, 0.00122376,
  0.0013153, 0.00140665, 0.0014978, 0.00158874, 0.00167946,
  0.00176994, 0.00186018, 0.00195015, 0.00203985, 0.00212927,
  0.00221838, 0.00230719, 0.00239568, 0.00248383, 0.00257163,
  0.00265908, 0.00274615, 0.00283285, 0.00291915, 0.00300504,
  0.00309052, 0.00317557, 0.00326018, 0.00334434, 0.00342804,
  0.00351126, 0.00359399, 0.00367624, 0.00375797, 0.00383919,
  0.00391987, 0.00400002, 0.00407962, 0.00415866, 0.00423713,
  0.00431501, 0.00439231, 0.004469, 0.00454508, 0.00462054,
  0.00469537, 0.00476956, 0.00484309, 0.00491597, 0.00498818,
  0.00505971, 0.00513054, 0.00520069, 0.00527012, 0.00533884,
  0.00540684, 0.0054741, 0.00554062, 0.00560639, 0.00567141,
  0.00573566, 0.00579913, 0.00586182, 0.00592372, 0.00598482,
  0.00604512, 0.0061046, 0.00616326, 0.0062211, 0.0062781, 0.00633425,
  0.00638956, 0.00644401, 0.0064976, 0.00655032, 0.00660217,
  0.00665313, 0.0067032, 0.00675238, 0.00680066, 0.00684804,
  0.0068945, 0.00694005, 0.00698467, 0.00702837, 0.00707113,
  0.00711296, 0.00715384, 0.00719378, 0.00723276, 0.00727079,
  0.00730785, 0.00734395, 0.00737908, 0.00741324, 0.00744642,
  0.00747862, 0.00750984, 0.00754007, 0.0075693, 0.00759755,
  0.00762479, 0.00765104, 0.00767628, 0.00770052, 0.00772375,
  0.00774597, 0.00776718, 0.00778737, 0.00780654, 0.0078247,
  0.00784184, 0.00785796, 0.00787305, 0.00788712, 0.00790016,
  0.00791218, 0.00792317, 0.00793313, 0.00794206, 0.00794997,
  0.00795684, 0.00796269, 0.0079675, 0.00797129, 0.00797404,
  0.00797577, 0.00797647, 0.00797614, 0.00797478, 0.0079724,
  0.00796899, 0.00796456, 0.0079591, 0.00795262, 0.00794512,
  0.00793661, 0.00792707, 0.00791652, 0.00790496, 0.00789239,
  0.0078788, 0.00786422, 0.00784862, 0.00783203, 0.00781444,
  0.00779585, 0.00777627, 0.0077557, 0.00773415, 0.00771161,
  0.0076881, 0.0076636, 0.00763814, 0.00761171, 0.00758431,
  0.00755595, 0.00752664, 0.00749638, 0.00746516, 0.00743301,
  0.00739992, 0.00736589, 0.00733094, 0.00729506, 0.00725827,
  0.00722056, 0.00718195, 0.00714243, 0.00710201, 0.00706071,
  0.00701851, 0.00697544, 0.0069315, 0.00688669, 0.00684101,
  0.00679448, 0.0067471, 0.00669888, 0.00664983, 0.00659994,
  0.00654923, 0.00649771, 0.00644537, 0.00639224, 0.00633831,
  0.00628359, 0.00622809, 0.00617182, 0.00611478, 0.00605699,
  0.00599844, 0.00593915, 0.00587913, 0.00581838, 0.00575691,
  0.00569473, 0.00563184, 0.00556827, 0.005504, 0.00543906,
  0.00537344, 0.00530717, 0.00524024, 0.00517267, 0.00510446,
  0.00503562, 0.00496617, 0.00489611, 0.00482545, 0.00475419,
  0.00468236, 0.00460995, 0.00453698, 0.00446345, 0.00438938,
  0.00431477, 0.00423963, 0.00416398, 0.00408782, 0.00401116,
  0.00393402, 0.00385639, 0.0037783, 0.00369975, 0.00362074,
  0.0035413, 0.00346143, 0.00338114, 0.00330044, 0.00321933,
  0.00313784, 0.00305597, 0.00297373, 0.00289113, 0.00280818,
  0.0027249, 0.00264128, 0.00255734, 0.0024731, 0.00238856,
  0.00230373, 0.00221862, 0.00213325, 0.00204762, 0.00196174,
  0.00187563, 0.0017893, 0.00170275, 0.00161599, 0.00152904,
  0.00144191, 0.0013546, 0.00126714, 0.00117952, 0.00109176,
  0.00100387, 0.000915863, 0.000827745, 0.000739527, 0.000651222,
  0.000562839, 0.000474389, 0.000385883, 0.000297331, 0.000208743,
  0.000120131, 3.15043e-05, -5.71261e-05, -0.00014575, -0.000234356,
  -0.000322935, -0.000411475, -0.000499967, -0.0005884, -0.000676763,
  -0.000765046, -0.000853239, -0.000941331, -0.00102931, -0.00111717,
  -0.0012049, -0.00129249, -0.00137992, -0.00146719, -0.00155429,
  -0.00164121, -0.00172793, -0.00181445, -0.00190076, -0.00198684,
  -0.00207269, -0.0021583, -0.00224366, -0.00232875, -0.00241357,
  -0.00249811, -0.00258236, -0.0026663, -0.00274994, -0.00283325,
  -0.00291623, -0.00299887, -0.00308117, -0.0031631, -0.00324467,
  -0.00332585, -0.00340665, -0.00348706, -0.00356706, -0.00364664,
  -0.00372581, -0.00380454, -0.00388282, -0.00396066, -0.00403804,
  -0.00411495, -0.00419139, -0.00426734, -0.0043428, -0.00441775,
  -0.0044922, -0.00456613, -0.00463952, -0.00471239, -0.00478471,
  -0.00485648, -0.00492769, -0.00499833, -0.0050684, -0.00513788,
  -0.00520678, -0.00527507, -0.00534276, -0.00540984, -0.0054763,
  -0.00554212, -0.00560732, -0.00567187, -0.00573577, -0.00579901,
  -0.00586159, -0.0059235, -0.00598473, -0.00604528, -0.00610514,
  -0.0061643, -0.00622276, -0.0062805, -0.00633754, -0.00639385,
  -0.00644943, -0.00650427, -0.00655838, -0.00661174, -0.00666435,
  -0.0067162, -0.00676729, -0.00681762, -0.00686716, -0.00691593,
  -0.00696392, -0.00701111, -0.00705751, -0.00710311, -0.00714791,
  -0.0071919, -0.00723508, -0.00727744, -0.00731897, -0.00735969,
  -0.00739956, -0.00743861, -0.00747682, -0.00751418, -0.0075507,
  -0.00758636, -0.00762117, -0.00765513, -0.00768822, -0.00772045,
  -0.00775181, -0.00778231, -0.00781192, -0.00784066, -0.00786853,
  -0.0078955, -0.0079216, -0.00794681, -0.00797112, -0.00799455,
  -0.00801708, -0.00803871, -0.00805945, -0.00807928, -0.00809821,
  -0.00811624, -0.00813337, -0.00814958, -0.00816489, -0.00817928,
  -0.00819277, -0.00820534, -0.008217, -0.00822775, -0.00823758,
  -0.00824649, -0.00825449, -0.00826157, -0.00826774, -0.00827298,
  -0.00827731, -0.00828072, -0.00828322, -0.00828479, -0.00828545,
  -0.00828519, -0.00828401, -0.00828192, -0.00827891, -0.00827499,
  -0.00827015, -0.0082644, -0.00825774, -0.00825017, -0.00824168,
  -0.00823229, -0.00822199, -0.00821078, -0.00819867, -0.00818566,
  -0.00817175, -0.00815694, -0.00814123, -0.00812462, -0.00810713,
  -0.00808874, -0.00806947, -0.00804931, -0.00802827, -0.00800634,
  -0.00798355, -0.00795987, -0.00793533, -0.00790991, -0.00788363,
  -0.00785649, -0.00782849, -0.00779963, -0.00776992, -0.00773937,
  -0.00770796, -0.00767572, -0.00764264, -0.00760873, -0.00757398,
  -0.00753842, -0.00750203, -0.00746482, -0.0074268, -0.00738798,
  -0.00734835, -0.00730792, -0.0072667, -0.00722469, -0.00718189,
  -0.00713832, -0.00709397, -0.00704885, -0.00700296, -0.00695632,
  -0.00690893, -0.00686078, -0.0068119, -0.00676227, -0.00671192,
  -0.00666084, -0.00660904, -0.00655652, -0.0065033, -0.00644938,
  -0.00639476, -0.00633944, -0.00628345, -0.00622678, -0.00616944,
  -0.00611143, -0.00605276, -0.00599345, -0.00593349, -0.00587289,
  -0.00581165, -0.0057498, -0.00568732, -0.00562424, -0.00556055,
  -0.00549626, -0.00543139, -0.00536593, -0.0052999, -0.0052333,
  -0.00516613, -0.00509842, -0.00503016, -0.00496136, -0.00489203,
  -0.00482218, -0.00475181, -0.00468093, -0.00460955, -0.00453768,
  -0.00446533, -0.0043925, -0.0043192, -0.00424544, -0.00417123,
  -0.00409657, -0.00402148, -0.00394596, -0.00387002, -0.00379366,
  -0.00371691, -0.00363976, -0.00356222, -0.0034843, -0.00340601,
  -0.00332736, -0.00324836, -0.00316901, -0.00308933, -0.00300932,
  -0.00292899, -0.00284834, -0.0027674, -0.00268617, -0.00260464,
  -0.00252285, -0.00244079, -0.00235846, -0.00227589, -0.00219308,
  -0.00211004, -0.00202677, -0.00194329, -0.00185961, -0.00177573,
  -0.00169166, -0.00160741, -0.001523, -0.00143842, -0.00135369,
  -0.00126882, -0.00118382, -0.00109869, -0.00101344, -0.00092809,
  -0.000842641, -0.000757104, -0.000671486, -0.000585799, -0.00050005,
  -0.000414248, -0.000328403, -0.000242524, -0.000156619,
  -7.06973e-05, 1.52315e-05, 0.000101159, 0.000187075, 0.000272972,
  0.00035884, 0.000444671, 0.000530455, 0.000616184, 0.000701848,
  0.000787439, 0.000872948, 0.000958365, 0.00104368, 0.00112889,
  0.00121398, 0.00129895, 0.00138377, 0.00146846, 0.00155299,
  0.00163736, 0.00172156, 0.00180558, 0.00188941, 0.00197304,
  0.00205647, 0.00213969, 0.00222268, 0.00230544, 0.00238796,
  0.00247024, 0.00255226, 0.00263401, 0.00271549, 0.00279669,
  0.00287759, 0.0029582, 0.0030385, 0.00311849, 0.00319815,
  0.00327749, 0.00335648, 0.00343513, 0.00351342, 0.00359134,
  0.0036689, 0.00374608, 0.00382287, 0.00389926, 0.00397525,
  0.00405083, 0.00412599, 0.00420073, 0.00427503, 0.00434889,
  0.00442231, 0.00449526, 0.00456776, 0.00463978, 0.00471133,
  0.00478239, 0.00485295, 0.00492302, 0.00499258, 0.00506163,
  0.00513016, 0.00519816, 0.00526562, 0.00533255, 0.00539893,
  0.00546475, 0.00553001, 0.0055947, 0.00565882, 0.00572236,
  0.00578531, 0.00584767, 0.00590943, 0.00597059, 0.00603113,
  0.00609105, 0.00615035, 0.00620903, 0.00626706, 0.00632446,
  0.0063812, 0.0064373, 0.00649274, 0.00654751, 0.00660162,
  0.00665505, 0.0067078, 0.00675986, 0.00681124, 0.00686192,
  0.0069119, 0.00696118, 0.00700974, 0.0070576, 0.00710473,
  0.00715114, 0.00719682, 0.00724177, 0.00728598, 0.00732945,
  0.00737217, 0.00741415, 0.00745537, 0.00749583, 0.00753553,
  0.00757446, 0.00761263, 0.00765002, 0.00768663, 0.00772247,
  0.00775752, 0.00779178, 0.00782525, 0.00785793, 0.00788982,
  0.0079209, 0.00795118, 0.00798066, 0.00800932, 0.00803718,
  0.00806422, 0.00809045, 0.00811586, 0.00814044, 0.00816421,
  0.00818714, 0.00820926, 0.00823054, 0.00825098, 0.0082706,
  0.00828938, 0.00830732, 0.00832443, 0.00834069, 0.00835612,
  0.0083707, 0.00838443, 0.00839733, 0.00840937, 0.00842057,
  0.00843092, 0.00844042, 0.00844907, 0.00845687, 0.00846381,
  0.00846991, 0.00847516, 0.00847955, 0.00848309, 0.00848577,
  0.00848761, 0.00848859, 0.00848871, 0.00848799, 0.00848641,
  0.00848398, 0.0084807, 0.00847657, 0.00847159, 0.00846575,
  0.00845907, 0.00845154, 0.00844317, 0.00843395, 0.00842388,
  0.00841297, 0.00840121, 0.00838862, 0.00837518, 0.00836091,
  0.0083458, 0.00832986, 0.00831308, 0.00829547, 0.00827703,
  0.00825776, 0.00823767, 0.00821676, 0.00819503, 0.00817247,
  0.0081491, 0.00812492, 0.00809993, 0.00807413, 0.00804752,
  0.00802011, 0.0079919, 0.00796289, 0.00793309, 0.0079025,
  0.00787113, 0.00783896, 0.00780602, 0.0077723, 0.00773781,
  0.00770255, 0.00766652, 0.00762972, 0.00759217, 0.00755386,
  0.00751481, 0.007475, 0.00743445, 0.00739317, 0.00735115, 0.0073084,
  0.00726492, 0.00722072, 0.00717581, 0.00713018, 0.00708384,
  0.00703681, 0.00698907, 0.00694064, 0.00689153, 0.00684173,
  0.00679125, 0.0067401, 0.00668828, 0.0066358, 0.00658266,
  0.00652887, 0.00647443, 0.00641936, 0.00636365, 0.0063073,
  0.00625034, 0.00619275, 0.00613456, 0.00607575, 0.00601635,
  0.00595635, 0.00589577, 0.0058346, 0.00577285, 0.00571054,
  0.00564766, 0.00558422, 0.00552024, 0.0054557, 0.00539063,
  0.00532503, 0.0052589, 0.00519226, 0.0051251, 0.00505743,
  0.00498927, 0.00492062, 0.00485148, 0.00478187, 0.00471178,
  0.00464123, 0.00457022, 0.00449876, 0.00442686, 0.00435453,
  0.00428176, 0.00420858, 0.00413498, 0.00406097, 0.00398657,
  0.00391177, 0.00383659, 0.00376103, 0.0036851, 0.00360881,
  0.00353217, 0.00345518, 0.00337785, 0.00330019, 0.0032222,
  0.0031439, 0.00306529, 0.00298638, 0.00290718, 0.00282769,
  0.00274792, 0.00266788, 0.00258759, 0.00250704, 0.00242624,
  0.00234521, 0.00226394, 0.00218246, 0.00210076, 0.00201886,
  0.00193675, 0.00185446, 0.00177199, 0.00168934, 0.00160653,
  0.00152356, 0.00144044, 0.00135718, 0.00127379, 0.00119028,
  0.00110664, 0.0010229, 0.000939062, 0.00085513, 0.000771114,
  0.000687023, 0.000602865, 0.000518648, 0.000434381, 0.000350071,
  0.000265726, 0.000181356, 9.69684e-05, 1.25711e-05, -7.18275e-05,
  -0.000156219, -0.000240595, -0.000324948, -0.00040927, -0.000493551,
  -0.000577784, -0.000661961, -0.000746074, -0.000830114,
  -0.000914073, -0.000997943, -0.00108172, -0.00116538, -0.00124894,
  -0.00133237, -0.00141567, -0.00149884, -0.00158186, -0.00166473,
  -0.00174743, -0.00182996, -0.00191232, -0.00199449, -0.00207647,
  -0.00215824, -0.00223981, -0.00232115, -0.00240228, -0.00248317,
  -0.00256381, -0.00264421, -0.00272435, -0.00280423, -0.00288384,
  -0.00296316, -0.0030422, -0.00312095, -0.00319939, -0.00327752,
  -0.00335533, -0.00343282, -0.00350997, -0.00358678, -0.00366325,
  -0.00373936, -0.00381511, -0.00389049, -0.00396549, -0.00404011,
  -0.00411434, -0.00418817, -0.00426159, -0.0043346, -0.00440719,
  -0.00447936, -0.00455109, -0.00462238, -0.00469322, -0.00476361,
  -0.00483354, -0.004903, -0.00497199, -0.0050405, -0.00510851,
  -0.00517604, -0.00524306, -0.00530958, -0.00537559, -0.00544107,
  -0.00550603, -0.00557046, -0.00563435, -0.0056977, -0.00576049,
  -0.00582273, -0.00588441, -0.00594552, -0.00600605, -0.00606601,
  -0.00612538, -0.00618416, -0.00624234, -0.00629992, -0.00635689,
  -0.00641325, -0.00646899, -0.00652411, -0.0065786, -0.00663245,
  -0.00668566, -0.00673823, -0.00679015, -0.00684142, -0.00689202,
  -0.00694197, -0.00699124, -0.00703984, -0.00708776, -0.007135,
  -0.00718156, -0.00722742, -0.00727258, -0.00731705, -0.00736081,
  -0.00740386, -0.0074462, -0.00748782, -0.00752872, -0.0075689,
  -0.00760835, -0.00764707, -0.00768505, -0.00772229, -0.00775879,
  -0.00779455, -0.00782955, -0.00786381, -0.0078973, -0.00793004,
  -0.00796201, -0.00799322, -0.00802366, -0.00805333, -0.00808223,
  -0.00811035, -0.00813769, -0.00816425, -0.00819003, -0.00821502,
  -0.00823922, -0.00826262, -0.00828524, -0.00830706, -0.00832808,
  -0.00834831, -0.00836773, -0.00838635, -0.00840416, -0.00842117,
  -0.00843737, -0.00845276, -0.00846734, -0.0084811, -0.00849406,
  -0.00850619, -0.00851752, -0.00852802, -0.00853771, -0.00854658,
  -0.00855463, -0.00856186, -0.00856827, -0.00857386, -0.00857863,
  -0.00858257, -0.00858569, -0.00858799, -0.00858947, -0.00859012,
  -0.00858995, -0.00858896, -0.00858715, -0.00858451, -0.00858105,
  -0.00857677, -0.00857167, -0.00856574, -0.008559, -0.00855144,
  -0.00854306, -0.00853386, -0.00852384, -0.00851301, -0.00850136,
  -0.0084889, -0.00847563, -0.00846155, -0.00844665, -0.00843095,
  -0.00841445, -0.00839713, -0.00837902, -0.0083601, -0.00834038,
  -0.00831987, -0.00829856, -0.00827645, -0.00825356, -0.00822987,
  -0.0082054, -0.00818015, -0.00815411, -0.00812729, -0.0080997,
  -0.00807133, -0.00804219, -0.00801228, -0.00798161, -0.00795017,
  -0.00791798, -0.00788502, -0.00785132, -0.00781686, -0.00778166,
  -0.00774571, -0.00770903, -0.0076716, -0.00763345, -0.00759456,
  -0.00755495, -0.00751462, -0.00747358, -0.00743181, -0.00738934,
  -0.00734616, -0.00730228, -0.00725771, -0.00721244, -0.00716648,
  -0.00711984, -0.00707252, -0.00702452, -0.00697586, -0.00692653,
  -0.00687653, -0.00682588, -0.00677458, -0.00672263, -0.00667005,
  -0.00661682, -0.00656296, -0.00650848, -0.00645338, -0.00639766,
  -0.00634133, -0.00628439, -0.00622686, -0.00616873, -0.00611002,
  -0.00605072, -0.00599084, -0.00593039, -0.00586938, -0.00580781,
  -0.00574568, -0.00568301, -0.00561979, -0.00555604, -0.00549175,
  -0.00542695, -0.00536163, -0.00529579, -0.00522945, -0.00516262,
  -0.00509529, -0.00502747, -0.00495918, -0.00489041, -0.00482117,
  -0.00475148, -0.00468134, -0.00461074, -0.00453971, -0.00446825,
  -0.00439636, -0.00432405, -0.00425133, -0.0041782, -0.00410468,
  -0.00403076, -0.00395646, -0.00388178, -0.00380674, -0.00373133,
  -0.00365556, -0.00357945, -0.003503, -0.00342621, -0.0033491,
  -0.00327166, -0.00319392, -0.00311587, -0.00303752, -0.00295889,
  -0.00287997, -0.00280078, -0.00272132, -0.0026416, -0.00256163,
  -0.00248142, -0.00240097, -0.00232029, -0.00223939, -0.00215828,
  -0.00207696, -0.00199544, -0.00191374, -0.00183185, -0.00174979,
  -0.00166756, -0.00158517, -0.00150263, -0.00141995, -0.00133713,
  -0.00125418, -0.00117112, -0.00108794, -0.00100466, -0.00092129,
  -0.000837827, -0.000754284, -0.000670669, -0.000586991,
  -0.000503257, -0.000419474, -0.000335652, -0.000251798, -0.00016792,
  -8.40261e-05, -1.24008e-07, 8.3778e-05, 0.000167672, 0.00025155,
  0.000335404, 0.000419226, 0.000503009, 0.000586743, 0.000670421,
  0.000754036, 0.000837579, 0.000921042, 0.00100442, 0.0010877,
  0.00117087, 0.00125394, 0.00133688, 0.0014197, 0.00150238,
  0.00158492, 0.00166731, 0.00174954, 0.0018316, 0.00191349,
  0.0019952, 0.00207671, 0.00215803, 0.00223914, 0.00232004,
  0.00240072, 0.00248117, 0.00256138, 0.00264135, 0.00272107,
  0.00280053, 0.00287972, 0.00295864, 0.00303727, 0.00311562,
  0.00319367, 0.00327141, 0.00334885, 0.00342596, 0.00350275,
  0.0035792, 0.00365532, 0.00373108, 0.00380649, 0.00388154,
  0.00395621, 0.00403051, 0.00410443, 0.00417795, 0.00425108,
  0.0043238, 0.00439611, 0.004468, 0.00453946, 0.0046105, 0.00468109,
  0.00475123, 0.00482093, 0.00489016, 0.00495893, 0.00502722,
  0.00509504, 0.00516237, 0.0052292, 0.00529554, 0.00536138,
  0.0054267, 0.00549151, 0.00555579, 0.00561954, 0.00568276,
  0.00574543, 0.00580756, 0.00586913, 0.00593014, 0.00599059,
  0.00605047, 0.00610977, 0.00616848, 0.00622661, 0.00628415,
  0.00634108, 0.00639741, 0.00645313, 0.00650823, 0.00656272,
  0.00661657, 0.0066698, 0.00672239, 0.00677433, 0.00682563,
  0.00687628, 0.00692628, 0.00697561, 0.00702428, 0.00707227,
  0.00711959, 0.00716623, 0.00721219, 0.00725746, 0.00730204,
  0.00734592, 0.00738909, 0.00743156, 0.00747333, 0.00751438,
  0.00755471, 0.00759432, 0.0076332, 0.00767136, 0.00770878,
  0.00774546, 0.00778141, 0.00781661, 0.00785107, 0.00788478,
  0.00791773, 0.00794992, 0.00798136, 0.00801204, 0.00804194,
  0.00807108, 0.00809945, 0.00812704, 0.00815386, 0.0081799,
  0.00820516, 0.00822963, 0.00825331, 0.00827621, 0.00829831,
  0.00831962, 0.00834013, 0.00835985, 0.00837877, 0.00839688,
  0.0084142, 0.0084307, 0.00844641, 0.0084613, 0.00847538, 0.00848866,
  0.00850112, 0.00851276, 0.00852359, 0.00853361, 0.00854281,
  0.00855119, 0.00855875, 0.0085655, 0.00857142, 0.00857652,
  0.0085808, 0.00858426, 0.0085869, 0.00858871, 0.00858971,
  0.00858988, 0.00858922, 0.00858775, 0.00858545, 0.00858232,
  0.00857838, 0.00857361, 0.00856802, 0.00856161, 0.00855438,
  0.00854633, 0.00853746, 0.00852778, 0.00851727, 0.00850595,
  0.00849381, 0.00848085, 0.00846709, 0.00845251, 0.00843712,
  0.00842092, 0.00840391, 0.0083861, 0.00836748, 0.00834806,
  0.00832783, 0.00830681, 0.00828499, 0.00826238, 0.00823897,
  0.00821477, 0.00818978, 0.008164, 0.00813744, 0.0081101, 0.00808198,
  0.00805309, 0.00802342, 0.00799297, 0.00796177, 0.00792979,
  0.00789705, 0.00786356, 0.00782931, 0.0077943, 0.00775855,
  0.00772205, 0.0076848, 0.00764682, 0.0076081, 0.00756865,
  0.00752847, 0.00748757, 0.00744595, 0.00740361, 0.00736056,
  0.0073168, 0.00727233, 0.00722717, 0.00718131, 0.00713475,
  0.00708752, 0.00703959, 0.00699099, 0.00694172, 0.00689178,
  0.00684117, 0.0067899, 0.00673798, 0.00668541, 0.0066322,
  0.00657835, 0.00652386, 0.00646874, 0.006413, 0.00635664,
  0.00629967, 0.00624209, 0.00618391, 0.00612513, 0.00606576,
  0.0060058, 0.00594527, 0.00588416, 0.00582248, 0.00576024,
  0.00569745, 0.0056341, 0.00557021, 0.00550578, 0.00544083,
  0.00537534, 0.00530933, 0.00524282, 0.00517579, 0.00510827,
  0.00504025, 0.00497174, 0.00490275, 0.00483329, 0.00476336,
  0.00469297, 0.00462213, 0.00455084, 0.00447911, 0.00440695,
  0.00433435, 0.00426134, 0.00418792, 0.00411409, 0.00403986,
  0.00396525, 0.00389024, 0.00381486, 0.00373911, 0.003663,
  0.00358654, 0.00350972, 0.00343257, 0.00335508, 0.00327727,
  0.00319914, 0.0031207, 0.00304195, 0.00296292, 0.00288359,
  0.00280398, 0.00272411, 0.00264396, 0.00256357, 0.00248292,
  0.00240203, 0.00232091, 0.00223956, 0.00215799, 0.00207622,
  0.00199424, 0.00191207, 0.00182972, 0.00174718, 0.00166448,
  0.00158161, 0.00149859, 0.00141543, 0.00133212, 0.00124869,
  0.00116514, 0.00108147, 0.000997695, 0.000913825, 0.000829866,
  0.000745826, 0.000661713, 0.000577536, 0.000493303, 0.000409022,
  0.0003247, 0.000240347, 0.000155971, 7.15795e-05, -1.28191e-05,
  -9.72164e-05, -0.000181604, -0.000265974, -0.000350319,
  -0.000434629, -0.000518896, -0.000603113, -0.000687271,
  -0.000771362, -0.000855378, -0.00093931, -0.00102315, -0.00110689,
  -0.00119052, -0.00127404, -0.00135743, -0.00144069, -0.00152381,
  -0.00160678, -0.00168959, -0.00177224, -0.00185471, -0.001937,
  -0.0020191, -0.00210101, -0.00218271, -0.00226419, -0.00234546,
  -0.00242649, -0.00250729, -0.00258784, -0.00266813, -0.00274817,
  -0.00282793, -0.00290742, -0.00298663, -0.00306554, -0.00314415,
  -0.00322245, -0.00330044, -0.0033781, -0.00345543, -0.00353242,
  -0.00360906, -0.00368535, -0.00376128, -0.00383684, -0.00391202,
  -0.00398682, -0.00406122, -0.00413523, -0.00420883, -0.00428201,
  -0.00435478, -0.00442711, -0.00449901, -0.00457047, -0.00464148,
  -0.00471203, -0.00478211, -0.00485173, -0.00492087, -0.00498952,
  -0.00505768, -0.00512535, -0.0051925, -0.00525915, -0.00532528,
  -0.00539088, -0.00545595, -0.00552048, -0.00558447, -0.00564791,
  -0.00571079, -0.0057731, -0.00583485, -0.00589602, -0.0059566,
  -0.0060166, -0.006076, -0.00613481, -0.006193, -0.00625059,
  -0.00630755, -0.00636389, -0.00641961, -0.00647468, -0.00652912,
  -0.00658291, -0.00663605, -0.00668853, -0.00674035, -0.0067915,
  -0.00684198, -0.00689178, -0.00694089, -0.00698932, -0.00703706,
  -0.00708409, -0.00713043, -0.00717605, -0.00722097, -0.00726517,
  -0.00730864, -0.0073514, -0.00739342, -0.0074347, -0.00747525,
  -0.00751506, -0.00755411, -0.00759242, -0.00762997, -0.00766676,
  -0.00770279, -0.00773806, -0.00777255, -0.00780627, -0.00783921,
  -0.00787137, -0.00790275, -0.00793334, -0.00796314, -0.00799215,
  -0.00802036, -0.00804777, -0.00807437, -0.00810018, -0.00812517,
  -0.00814935, -0.00817272, -0.00819527, -0.00821701, -0.00823792,
  -0.00825801, -0.00827728, -0.00829572, -0.00831333, -0.0083301,
  -0.00834605, -0.00836116, -0.00837543, -0.00838887, -0.00840146,
  -0.00841321, -0.00842413, -0.00843419, -0.00844342, -0.00845179,
  -0.00845932, -0.008466, -0.00847184, -0.00847682, -0.00848095,
  -0.00848423, -0.00848666, -0.00848824, -0.00848896, -0.00848883,
  -0.00848785, -0.00848602, -0.00848333, -0.00847979, -0.0084754,
  -0.00847016, -0.00846406, -0.00845711, -0.00844931, -0.00844067,
  -0.00843117, -0.00842082, -0.00840962, -0.00839757, -0.00838468,
  -0.00837095, -0.00835637, -0.00834094, -0.00832468, -0.00830757,
  -0.00828963, -0.00827085, -0.00825123, -0.00823078, -0.0082095,
  -0.00818739, -0.00816445, -0.00814069, -0.0081161, -0.0080907,
  -0.00806447, -0.00803743, -0.00800957, -0.00798091, -0.00795143,
  -0.00792115, -0.00789007, -0.00785818, -0.0078255, -0.00779203,
  -0.00775777, -0.00772272, -0.00768688, -0.00765027, -0.00761287,
  -0.00757471, -0.00753578, -0.00749608, -0.00745561, -0.00741439,
  -0.00737242, -0.0073297, -0.00728623, -0.00724202, -0.00719707,
  -0.00715139, -0.00710498, -0.00705785, -0.00700999, -0.00696143,
  -0.00691215, -0.00686217, -0.00681149, -0.00676011, -0.00670805,
  -0.00665529, -0.00660186, -0.00654776, -0.00649298, -0.00643755,
  -0.00638145, -0.0063247, -0.00626731, -0.00620927, -0.0061506,
  -0.0060913, -0.00603138, -0.00597083, -0.00590968, -0.00584792,
  -0.00578556, -0.00572261, -0.00565907, -0.00559495, -0.00553026,
  -0.005465, -0.00539917, -0.0053328, -0.00526587, -0.00519841,
  -0.00513041, -0.00506188, -0.00499283, -0.00492327, -0.0048532,
  -0.00478263, -0.00471157, -0.00464003, -0.00456801, -0.00449551,
  -0.00442255, -0.00434914, -0.00427528, -0.00420098, -0.00412624,
  -0.00405108, -0.0039755, -0.00389951, -0.00382311, -0.00374632,
  -0.00366915, -0.00359159, -0.00351367, -0.00343538, -0.00335673,
  -0.00327774, -0.0031984, -0.00311874, -0.00303875, -0.00295845,
  -0.00287784, -0.00279693, -0.00271574, -0.00263426, -0.0025525,
  -0.00247049, -0.00238821, -0.00230569, -0.00222293, -0.00213993,
  -0.00205672, -0.00197329, -0.00188966, -0.00180582, -0.0017218,
  -0.00163761, -0.00155324, -0.00146871, -0.00138402, -0.00129919,
  -0.00121423, -0.00112914, -0.00104393, -0.000958614, -0.000873196,
  -0.000787687, -0.000702097, -0.000616432, -0.000530703,
  -0.000444919, -0.000359088, -0.00027322, -0.000187323, -0.000101407,
  -1.54795e-05, 7.04492e-05, 0.000156371, 0.000242276, 0.000328155,
  0.000414, 0.000499802, 0.000585551, 0.000671238, 0.000756856,
  0.000842393, 0.000927842, 0.00101319, 0.00109844, 0.00118357,
  0.00126857, 0.00135344, 0.00143817, 0.00152275, 0.00160716,
  0.00169141, 0.00177548, 0.00185936, 0.00194305, 0.00202653,
  0.00210979, 0.00219283, 0.00227565, 0.00235822, 0.00244054,
  0.0025226, 0.0026044, 0.00268592, 0.00276715, 0.0028481, 0.00292874,
  0.00300907, 0.00308908, 0.00316876, 0.00324811, 0.00332711,
  0.00340576, 0.00348405, 0.00356197, 0.00363951, 0.00371666,
  0.00379342, 0.00386977, 0.00394571, 0.00402123, 0.00409633,
  0.00417098, 0.00424519, 0.00431895, 0.00439225, 0.00446508,
  0.00453744, 0.00460931, 0.00468068, 0.00475156, 0.00482193,
  0.00489178, 0.00496111, 0.00502991, 0.00509817, 0.00516589,
  0.00523305, 0.00529965, 0.00536568, 0.00543114, 0.00549602,
  0.0055603, 0.00562399, 0.00568708, 0.00574955, 0.00581141,
  0.00587264, 0.00593324, 0.0059932, 0.00605252, 0.00611118,
  0.00616919, 0.00622653, 0.0062832, 0.0063392, 0.00639451,
  0.00644913, 0.00650305, 0.00655628, 0.00660879, 0.00666059,
  0.00671167, 0.00676203, 0.00681165, 0.00686053, 0.00690868,
  0.00695607, 0.00700272, 0.0070486, 0.00709372, 0.00713807,
  0.00718164, 0.00722444, 0.00726645, 0.00730767, 0.0073481,
  0.00738773, 0.00742655, 0.00746457, 0.00750178, 0.00753817,
  0.00757374, 0.00760848, 0.00764239, 0.00767547, 0.00770772,
  0.00773912, 0.00776967, 0.00779938, 0.00782824, 0.00785624,
  0.00788338, 0.00790966, 0.00793508, 0.00795962, 0.0079833,
  0.0080061, 0.00802802, 0.00804906, 0.00806922, 0.00808849,
  0.00810688, 0.00812438, 0.00814098, 0.00815669, 0.0081715,
  0.00818541, 0.00819842, 0.00821053, 0.00822174, 0.00823204,
  0.00824143, 0.00824992, 0.00825749, 0.00826415, 0.00826991,
  0.00827474, 0.00827867, 0.00828167, 0.00828377, 0.00828494,
  0.0082852, 0.00828454, 0.00828297, 0.00828048, 0.00827706,
  0.00827274, 0.00826749, 0.00826132, 0.00825424, 0.00824624,
  0.00823733, 0.0082275, 0.00821675, 0.00820509, 0.00819252,
  0.00817904, 0.00816464, 0.00814933, 0.00813312, 0.00811599,
  0.00809797, 0.00807903, 0.0080592, 0.00803846, 0.00801683,
  0.0079943, 0.00797087, 0.00794656, 0.00792135, 0.00789526,
  0.00786828, 0.00784042, 0.00781168, 0.00778206, 0.00775157,
  0.0077202, 0.00768797, 0.00765488, 0.00762093, 0.00758611,
  0.00755045, 0.00751393, 0.00747657, 0.00743836, 0.00739932,
  0.00735944, 0.00731873, 0.00727719, 0.00723483, 0.00719165,
  0.00714767, 0.00710287, 0.00705726, 0.00701086, 0.00696367,
  0.00691568, 0.00686691, 0.00681737, 0.00676705, 0.00671596,
  0.0066641, 0.00661149, 0.00655813, 0.00650403, 0.00644918,
  0.0063936, 0.00633729, 0.00628026, 0.00622251, 0.00616405,
  0.00610489, 0.00604503, 0.00598448, 0.00592325, 0.00586134,
  0.00579876, 0.00573552, 0.00567162, 0.00560707, 0.00554188,
  0.00547605, 0.00540959, 0.00534252, 0.00527483, 0.00520653,
  0.00513764, 0.00506815, 0.00499808, 0.00492744, 0.00485623,
  0.00478446, 0.00471214, 0.00463928, 0.00456588, 0.00449195,
  0.00441751, 0.00434255, 0.00426709, 0.00419114, 0.00411471,
  0.00403779, 0.00396041, 0.00388258, 0.00380429, 0.00372556,
  0.0036464, 0.00356681, 0.00348681, 0.00340641, 0.00332561,
  0.00324442, 0.00316285, 0.00308092, 0.00299863, 0.00291598,
  0.002833, 0.00274969, 0.00266606, 0.00258211, 0.00249786,
  0.00241333, 0.0023285, 0.00224341, 0.00215806, 0.00207245,
  0.00198659, 0.00190051, 0.0018142, 0.00172768, 0.00164096,
  0.00155404, 0.00146694, 0.00137967, 0.00129224, 0.00120465,
  0.00111692, 0.00102906, 0.000941083, 0.000852991, 0.000764798,
  0.000676515, 0.000588152, 0.000499719, 0.000411227, 0.000322687,
  0.000234108, 0.000145502, 5.68781e-05, -3.17523e-05, -0.000120379,
  -0.000208991, -0.000297579, -0.000386131, -0.000474637,
  -0.000563087, -0.00065147, -0.000739775, -0.000827993, -0.000916111,
  -0.00100412, -0.00109201, -0.00117977, -0.00126739, -0.00135485,
  -0.00144216, -0.00152929, -0.00161624, -0.00170299, -0.00178954,
  -0.00187588, -0.00196199, -0.00204787, -0.0021335, -0.00221887,
  -0.00230398, -0.00238881, -0.00247335, -0.00255759, -0.00264153,
  -0.00272514, -0.00280843, -0.00289138, -0.00297398, -0.00305622,
  -0.00313809, -0.00321958, -0.00330068, -0.00338139, -0.00346168,
  -0.00354155, -0.00362099, -0.00369999, -0.00377855, -0.00385664,
  -0.00393427, -0.00401141, -0.00408807, -0.00416423, -0.00423988,
  -0.00431502, -0.00438962, -0.0044637, -0.00453722, -0.0046102,
  -0.00468261, -0.00475444, -0.0048257, -0.00489636, -0.00496642,
  -0.00503587, -0.00510471, -0.00517292, -0.00524049, -0.00530742,
  -0.00537369, -0.0054393, -0.00550425, -0.00556851, -0.00563209,
  -0.00569498, -0.00575716, -0.00581863, -0.00587938, -0.0059394,
  -0.00599869, -0.00605723, -0.00611503, -0.00617207, -0.00622834,
  -0.00628384, -0.00633855, -0.00639249, -0.00644562, -0.00649795,
  -0.00654948, -0.00660019, -0.00665007, -0.00669913, -0.00674735,
  -0.00679473, -0.00684126, -0.00688693, -0.00693175, -0.00697569,
  -0.00701876, -0.00706095, -0.00710226, -0.00714268, -0.00718219,
  -0.00722081, -0.00725852, -0.00729531, -0.00733119, -0.00736614,
  -0.00740017, -0.00743326, -0.00746541, -0.00749662, -0.00752689,
  -0.0075562, -0.00758456, -0.00761195, -0.00763839, -0.00766385,
  -0.00768834, -0.00771186, -0.0077344, -0.00775595, -0.00777652,
  -0.0077961, -0.00781469, -0.00783228, -0.00784887, -0.00786446,
  -0.00787905, -0.00789263, -0.00790521, -0.00791677, -0.00792732,
  -0.00793685, -0.00794537, -0.00795287, -0.00795935, -0.0079648,
  -0.00796924, -0.00797265, -0.00797503, -0.00797639, -0.00797672,
  -0.00797602, -0.00797429, -0.00797153, -0.00796775, -0.00796293,
  -0.00795709, -0.00795021, -0.00794231, -0.00793338, -0.00792342,
  -0.00791243, -0.00790041, -0.00788737, -0.0078733, -0.0078582,
  -0.00784209, -0.00782495, -0.00780679, -0.00778762, -0.00776742,
  -0.00774622, -0.007724, -0.00770077, -0.00767653, -0.00765129,
  -0.00762504, -0.0075978, -0.00756955, -0.00754032, -0.00751009,
  -0.00747887, -0.00744667, -0.00741349, -0.00737933, -0.0073442,
  -0.0073081, -0.00727103, -0.00723301, -0.00719402, -0.00715409,
  -0.00711321, -0.00707138, -0.00702862, -0.00698492, -0.0069403,
  -0.00689475, -0.00684829, -0.00680091, -0.00675263, -0.00670345,
  -0.00665338, -0.00660241, -0.00655057, -0.00649785, -0.00644426,
  -0.00638981, -0.0063345, -0.00627834, -0.00622135, -0.00616351,
  -0.00610485, -0.00604537, -0.00598507, -0.00592397, -0.00586207,
  -0.00579938, -0.0057359, -0.00567166, -0.00560664, -0.00554087,
  -0.00547435, -0.00540709, -0.00533909, -0.00527037, -0.00520093,
  -0.00513079, -0.00505995, -0.00498843, -0.00491622, -0.00484334,
  -0.00476981, -0.00469562, -0.00462079, -0.00454533, -0.00446925,
  -0.00439256, -0.00431526, -0.00423737, -0.00415891, -0.00407987,
  -0.00400027, -0.00392012, -0.00383943, -0.00375822, -0.00367648,
  -0.00359424, -0.00351151, -0.00342828, -0.00334459, -0.00326043,
  -0.00317582, -0.00309077, -0.00300529, -0.0029194, -0.0028331,
  -0.0027464, -0.00265933, -0.00257188, -0.00248408, -0.00239592,
  -0.00230744, -0.00221863, -0.00212952, -0.0020401, -0.0019504,
  -0.00186043, -0.00177019, -0.00167971, -0.00158899, -0.00149805,
  -0.0014069, -0.00131555, -0.00122401, -0.0011323, -0.00104044,
  -0.000948421, -0.000856273, -0.000764003, -0.000671625,
  -0.000579152, -0.000486597, -0.000393973, -0.000301294,
  -0.000208571, -0.000115819, -2.30497e-05, 6.97223e-05, 0.000162484,
  0.000255223, 0.000347926, 0.000440579, 0.000533168, 0.000625681,
  0.000718105, 0.000810426, 0.00090263, 0.000994705, 0.00108664,
  0.00117841, 0.00127002, 0.00136144, 0.00145267, 0.00154368,
  0.00163448, 0.00172503, 0.00181534, 0.00190538, 0.00199515,
  0.00208463, 0.00217381, 0.00226267, 0.0023512, 0.00243939,
  0.00252722, 0.00261468, 0.00270177, 0.00278845, 0.00287473,
  0.00296059, 0.00304602, 0.003131, 0.00321552, 0.00329957,
  0.00338313, 0.00346619, 0.00354875, 0.00363078, 0.00371228,
  0.00379322, 0.00387361, 0.00395343, 0.00403265, 0.00411129,
  0.00418931, 0.00426671, 0.00434348, 0.0044196, 0.00449506,
  0.00456985, 0.00464397, 0.00471739, 0.0047901, 0.0048621,
  0.00493337, 0.0050039, 0.00507369, 0.00514271, 0.00521096,
  0.00527842, 0.0053451, 0.00541096, 0.00547602, 0.00554024,
  0.00560363, 0.00566617, 0.00572786, 0.00578868, 0.00584862,
  0.00590767, 0.00596583, 0.00602308, 0.00607942, 0.00613482,
  0.0061893, 0.00624283, 0.00629541, 0.00634702, 0.00639766,
  0.00644733, 0.00649601, 0.00654369, 0.00659036, 0.00663602,
  0.00668067, 0.00672428, 0.00676686, 0.00680839, 0.00684887,
  0.00688829, 0.00692665, 0.00696394, 0.00700014, 0.00703526,
  0.00706929, 0.00710221, 0.00713404, 0.00716475, 0.00719434,
  0.00722281, 0.00725016, 0.00727637, 0.00730144, 0.00732536,
  0.00734814, 0.00736977, 0.00739023, 0.00740954, 0.00742767,
  0.00744464, 0.00746043, 0.00747505, 0.00748848, 0.00750073,
  0.00751179, 0.00752166, 0.00753033, 0.00753781, 0.00754409,
  0.00754917, 0.00755305, 0.00755572, 0.00755718, 0.00755744,
  0.00755649, 0.00755432, 0.00755095, 0.00754637, 0.00754057,
  0.00753356, 0.00752534, 0.0075159, 0.00750525, 0.00749339,
  0.00748032, 0.00746604, 0.00745055, 0.00743385, 0.00741594,
  0.00739683, 0.00737652, 0.007355, 0.00733229, 0.00730838,
  0.00728327, 0.00725698, 0.0072295, 0.00720083, 0.00717098,
  0.00713995, 0.00710775, 0.00707438, 0.00703985, 0.00700415,
  0.0069673, 0.0069293, 0.00689015, 0.00684985, 0.00680843,
  0.00676587, 0.00672219, 0.00667739, 0.00663148, 0.00658446,
  0.00653634, 0.00648713, 0.00643684, 0.00638547, 0.00633303,
  0.00627952, 0.00622497, 0.00616936, 0.00611271, 0.00605504,
  0.00599634, 0.00593663, 0.00587592, 0.00581421, 0.00575152,
  0.00568785, 0.00562321, 0.00555762, 0.00549108, 0.0054236,
  0.0053552, 0.00528589, 0.00521567, 0.00514455, 0.00507256,
  0.00499969, 0.00492597, 0.0048514, 0.00477599, 0.00469976,
  0.00462272, 0.00454488, 0.00446625, 0.00438685, 0.00430669,
  0.00422578, 0.00414414, 0.00406177, 0.0039787, 0.00389493,
  0.00381048, 0.00372537, 0.00363961, 0.0035532, 0.00346618,
  0.00337854, 0.00329031, 0.0032015, 0.00311213, 0.0030222,
  0.00293175, 0.00284077, 0.00274929, 0.00265733, 0.00256489,
  0.00247199, 0.00237866, 0.0022849, 0.00219073, 0.00209617,
  0.00200124, 0.00190595, 0.00181032, 0.00171436, 0.00161809,
  0.00152153, 0.0014247, 0.00132761, 0.00123028, 0.00113273,
  0.00103498, 0.000937031, 0.000838917, 0.00074065, 0.000642248,
  0.000543729, 0.000445111, 0.000346412, 0.000247649, 0.000148841,
  5.00055e-05, -4.88391e-05, -0.000147675, -0.000246483, -0.000345247,
  -0.000443946, -0.000542563, -0.00064108, -0.000739479, -0.00083774,
  -0.000935845, -0.00103378, -0.00113152, -0.00122904, -0.00132634,
  -0.00142339, -0.00152018, -0.00161667, -0.00171287, -0.00180874,
  -0.00190428, -0.00199945, -0.00209425, -0.00218865, -0.00228264,
  -0.00237619, -0.00246929, -0.00256193, -0.00265408, -0.00274572,
  -0.00283684, -0.00292741, -0.00301743, -0.00310687, -0.00319571,
  -0.00328394, -0.00337154, -0.00345848, -0.00354477, -0.00363036,
  -0.00371526, -0.00379943, -0.00388287, -0.00396556, -0.00404747,
  -0.0041286, -0.00420892, -0.00428842, -0.00436708, -0.00444488,
  -0.00452181, -0.00459786, -0.004673, -0.00474722, -0.00482051,
  -0.00489284, -0.00496421, -0.00503459, -0.00510398, -0.00517235,
  -0.00523969, -0.00530599, -0.00537123, -0.0054354, -0.00549848,
  -0.00556046, -0.00562132, -0.00568105, -0.00573965, -0.00579708,
  -0.00585335, -0.00590843, -0.00596231, -0.00601499, -0.00606645,
  -0.00611667, -0.00616565, -0.00621337, -0.00625982, -0.006305,
  -0.00634888, -0.00639146, -0.00643272, -0.00647267, -0.00651128,
  -0.00654854, -0.00658445, -0.006619, -0.00665218, -0.00668398,
  -0.00671438, -0.00674339, -0.00677099, -0.00679718, -0.00682195,
  -0.00684528, -0.00686718, -0.00688764, -0.00690664, -0.00692419,
  -0.00694028, -0.0069549, -0.00696805, -0.00697972, -0.0069899,
  -0.0069986, -0.00700581, -0.00701152, -0.00701573, -0.00701843,
  -0.00701964, -0.00701933, -0.00701751, -0.00701418, -0.00700934,
  -0.00700298, -0.0069951, -0.0069857, -0.00697479, -0.00696236,
  -0.00694841, -0.00693294, -0.00691596, -0.00689746, -0.00687745,
  -0.00685592, -0.00683289, -0.00680835, -0.0067823, -0.00675475,
  -0.00672571, -0.00669517, -0.00666315, -0.00662963, -0.00659464,
  -0.00655818, -0.00652025, -0.00648085, -0.00644, -0.0063977,
  -0.00635395, -0.00630877, -0.00626217, -0.00621414, -0.0061647,
  -0.00611387, -0.00606164, -0.00600802, -0.00595303, -0.00589668,
  -0.00583898, -0.00577993, -0.00571956, -0.00565786, -0.00559486,
  -0.00553056, -0.00546498, -0.00539814, -0.00533003, -0.00526068,
  -0.00519011, -0.00511832, -0.00504533, -0.00497116, -0.00489581,
  -0.00481932, -0.00474168, -0.00466293, -0.00458307, -0.00450212,
  -0.0044201, -0.00433703, -0.00425292, -0.0041678, -0.00408168,
  -0.00399457, -0.00390651, -0.00381751, -0.00372758, -0.00363676,
  -0.00354505, -0.00345248, -0.00335907, -0.00326485, -0.00316983,
  -0.00307403, -0.00297748, -0.00288019, -0.0027822, -0.00268353,
  -0.00258419, -0.00248421, -0.00238361, -0.00228243, -0.00218067,
  -0.00207837, -0.00197556, -0.00187224, -0.00176846, -0.00166424,
  -0.00155959, -0.00145455, -0.00134915, -0.0012434, -0.00113733,
  -0.00103098, -0.000924364, -0.000817512, -0.000710451, -0.000603208,
  -0.00049581, -0.000388284, -0.000280658, -0.000172959, -6.52158e-05,
  4.25445e-05, 0.000150294, 0.000258003, 0.000365646, 0.000473193,
  0.000580615, 0.000687885, 0.000794974, 0.000901852, 0.00100849,
  0.00111487, 0.00122094, 0.00132669, 0.00143209, 0.0015371,
  0.00164171, 0.00174587, 0.00184956, 0.00195275, 0.00205542,
  0.00215753, 0.00225905, 0.00235996, 0.00246022, 0.00255981,
  0.0026587, 0.00275686, 0.00285427, 0.00295088, 0.00304668,
  0.00314164, 0.00323573, 0.00332891, 0.00342117, 0.00351247,
  0.00360278, 0.00369209, 0.00378035, 0.00386755, 0.00395366,
  0.00403865, 0.00412249, 0.00420515, 0.00428662, 0.00436686,
  0.00444585, 0.00452356, 0.00459997, 0.00467505, 0.00474878,
  0.00482114, 0.00489209, 0.00496161, 0.00502969, 0.00509629,
  0.00516139, 0.00522498, 0.00528703, 0.00534751, 0.00540641,
  0.0054637, 0.00551937, 0.00557339, 0.00562574, 0.0056764,
  0.00572535, 0.00577258, 0.00581806, 0.00586178, 0.00590372,
  0.00594386, 0.00598218, 0.00601868, 0.00605332, 0.00608611,
  0.00611701, 0.00614603, 0.00617314, 0.00619833, 0.00622158,
  0.0062429, 0.00626225, 0.00627964, 0.00629506, 0.00630848,
  0.00631991, 0.00632933, 0.00633673, 0.00634212, 0.00634547,
  0.00634679, 0.00634606, 0.00634329, 0.00633847, 0.00633159,
  0.00632265, 0.00631165, 0.00629858, 0.00628345, 0.00626625,
  0.00624699, 0.00622566, 0.00620226, 0.0061768, 0.00614929,
  0.00611971, 0.00608809, 0.00605441, 0.0060187, 0.00598094,
  0.00594116, 0.00589936, 0.00585554, 0.00580973, 0.00576191,
  0.00571212, 0.00566035, 0.00560662, 0.00555094, 0.00549334,
  0.00543381, 0.00537238, 0.00530906, 0.00524387, 0.00517682,
  0.00510794, 0.00503725, 0.00496475, 0.00489048, 0.00481446,
  0.0047367, 0.00465723, 0.00457607, 0.00449325, 0.00440879,
  0.00432271, 0.00423506, 0.00414584, 0.00405509, 0.00396284,
  0.00386912, 0.00377396, 0.00367738, 0.00357943, 0.00348012,
  0.00337951, 0.00327761, 0.00317447, 0.00307011, 0.00296458,
  0.00285792, 0.00275015, 0.00264132, 0.00253146, 0.00242062,
  0.00230884, 0.00219615, 0.00208259, 0.00196822, 0.00185307,
  0.00173718, 0.00162059, 0.00150336, 0.00138553, 0.00126714,
  0.00114824, 0.00102887, 0.000909077, 0.000788918, 0.000668434,
  0.000547676, 0.000426692, 0.00030553, 0.000184242, 6.28766e-05,
  -5.85152e-05, -0.000179882, -0.000301174, -0.000422337,
  -0.000543321, -0.000664073, -0.000784541, -0.000904671, -0.00102441,
  -0.00114371, -0.0012625, -0.00138075, -0.00149839, -0.00161537,
  -0.00173164, -0.00184714, -0.00196182, -0.00207562, -0.00218849,
  -0.00230037, -0.00241121, -0.00252095, -0.00262955, -0.00273694,
  -0.00284307, -0.00294789, -0.00305134, -0.00315337, -0.00325392,
  -0.00335295, -0.0034504, -0.00354621, -0.00364034, -0.00373273,
  -0.00382332, -0.00391208, -0.00399894, -0.00408386, -0.00416679,
  -0.00424767, -0.00432647, -0.00440312, -0.00447759, -0.00454982,
  -0.00461977, -0.00468739, -0.00475265, -0.00481549, -0.00487587,
  -0.00493375, -0.00498909, -0.00504185, -0.00509198, -0.00513946,
  -0.00518423, -0.00522628, -0.00526555, -0.00530202, -0.00533565,
  -0.00536641, -0.00539427, -0.0054192, -0.00544117, -0.00546016,
  -0.00547614, -0.00548909, -0.00549898, -0.00550579, -0.00550951,
  -0.00551011, -0.00550758, -0.0055019, -0.00549306, -0.00548105,
  -0.00546586, -0.00544748, -0.00542591, -0.00540113, -0.00537316,
  -0.00534197, -0.00530759, -0.00527001, -0.00522923, -0.00518526,
  -0.00513812, -0.00508781, -0.00503434, -0.00497774, -0.00491801,
  -0.00485518, -0.00478927, -0.0047203, -0.00464831, -0.00457331,
  -0.00449534, -0.00441443, -0.00433062, -0.00424394, -0.00415444,
  -0.00406216, -0.00396714, -0.00386942, -0.00376907, -0.00366613,
  -0.00356065, -0.0034527, -0.00334232, -0.0032296, -0.00311458,
  -0.00299733, -0.00287793, -0.00275645, -0.00263296, -0.00250754,
  -0.00238026, -0.00225122, -0.00212048, -0.00198815, -0.00185431,
  -0.00171905, -0.00158246, -0.00144465, -0.0013057, -0.00116573,
  -0.00102483, -0.000883114, -0.000740685, -0.000597655, -0.000454137,
  -0.000310244, -0.000166093, -2.18042e-05, 0.000122503, 0.000266706,
  0.00041068, 0.000554298, 0.000697433, 0.000839954, 0.000981731,
  0.00112263, 0.00126252, 0.00140125, 0.00153871, 0.00167473,
  0.0018092, 0.00194196, 0.00207287, 0.0022018, 0.00232859,
  0.00245311, 0.00257522, 0.00269475, 0.00281159, 0.00292556,
  0.00303654, 0.00314438, 0.00324894, 0.00335007, 0.00344762,
  0.00354146, 0.00363145, 0.00371744, 0.00379931, 0.0038769,
  0.0039501, 0.00401876, 0.00408275, 0.00414195, 0.00419624,
  0.00424549, 0.00428958, 0.0043284, 0.00436183, 0.00438978,
  0.00441213, 0.00442879, 0.00443966, 0.00444466, 0.00444371,
  0.00443672, 0.00442363, 0.00440437, 0.00437889, 0.00434714,
  0.00430907, 0.00426465, 0.00421386, 0.00415668, 0.0040931,
  0.00402313, 0.00394677, 0.00386405, 0.00377501, 0.00367969,
  0.00357815, 0.00347045, 0.0033567, 0.00323697, 0.00311138,
  0.00298007, 0.00284316, 0.00270082, 0.00255323, 0.00240057,
  0.00224305, 0.0020809, 0.00191436, 0.00174371, 0.00156923,
  0.00139122, 0.00121002, 0.00102598, 0.000839473, 0.000650899,
  0.000460685, 0.00026928, 7.71615e-05, -0.000115165, -0.000307167,
  -0.000498282, -0.000687918, -0.00087545, -0.00106022, -0.00124155,
  -0.0014187, -0.00159093, -0.00175743, -0.00191738, -0.00206991,
  -0.0022141, -0.00234902, -0.00247366, -0.00258699, -0.00268795,
  -0.00277539, -0.00284816, -0.00290503, -0.00294474, -0.00296598,
  -0.00296737, -0.00294748, -0.00290486, -0.00283795, -0.00274517,
  -0.00262487, -0.00247534, -0.00229481, -0.00208144, -0.00183332,
  -0.0015485, -0.00122492, -0.000860487, -0.000453015, -2.48015e-07};
