//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
// MODULE:              G4NuclideTable2.cc
//
// Date:                10/10/13
// Author:              T.KOI
//
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
// HISTORY

#include "G4NuclideTable.hh"

const G4double G4NuclideTable::exciteStateTable[G4NuclideTable::nEntries_excite_state][6] =
{
{    6,   15,             740,        3.765434,    5,          -8.888e-27}, //    15C
{    7,   16,          120.42,        7574.149,    0,                   0}, //    16N
{    7,   21,               0,    1.197437e+08,    0,                   0}, //    21N
{    8,   19,              96,        2.005346,    0,                   0}, //    19O
{    9,   18,          1121.4,        233.7166,    0,                   0}, //    18F
{    9,   19,          197.14,        128.8327,    0,                   0}, //    19F
{    9,   21,          279.93,         8.80044,    0,                   0}, //    21F
{   10,   19,          238.27,        25.96851,    0,                   0}, //   19NE
{   10,   24,            3972,         28.8539,    0,                   0}, //   24NE
{   10,   24,            5575,         28.8539,    0,                   0}, //   24NE
{   11,   22,          583.11,        350.5749,    2,         2.70175e-27}, //   22NA
{   11,   24,          472.21,    2.911359e+07,    2,        -9.75155e-27}, //   24NA
{   11,   25,           89.53,        7.357745,    0,                   0}, //   25NA
{   11,   26,            82.5,        12984.26,    0,                   0}, //   26NA
{   12,   22,          5005.7,        24.52582,    0,                   0}, //   22MG
{   12,   22,            5318,        24.52582,    0,                   0}, //   22MG
{   12,   22,            5838,        24.52582,    0,                   0}, //   22MG
{   12,   22,          6246.6,        24.52582,    0,                   0}, //   22MG
{   12,   23,            3798,        20.19773,    0,                   0}, //   23MG
{   12,   23,            3973,        20.19773,    0,                   0}, //   23MG
{   12,   23,            4353,        20.19773,    0,                   0}, //   23MG
{   12,   25,          585.04,        4.876309,    0,                   0}, //   25MG
{   12,   29,            54.6,        1.832223,    0,                   0}, //   29MG
{   12,   29,          1430.7,        2.019773,    0,                   0}, //   29MG
{   12,   30,          1788.2,        5.626511,    0,                   0}, //   30MG
{   12,   31,            50.1,        23.08312,    0,                   0}, //   31MG
{   12,   31,             461,         15.1483,    0,                   0}, //   31MG
{   12,   32,            1058,        10.09887,    0,                   0}, //   32MG
{   13,   24,           425.8,    1.894259e+08,    0,                   0}, //   24AL
{   13,   24,           425.8,    1.875504e+08,    0,                   0}, //   24AL
{   13,   25,           451.7,        3.303772,    0,                   0}, //   25AL
{   13,   26,          228.31,    9.154189e+09,    0,                   0}, //   26AL
{   13,   26,          416.85,        1.803369,    6,            1.01e-26}, //   26AL
{   13,   28,          30.638,        2.986379,    4,         2.15635e-26}, //   28AL
{   13,   28,          5992.4,        50.49433,    0,                   0}, //   28AL
{   13,   29,            3433,        10.09887,    0,                   0}, //   29AL
{   13,   30,           243.9,        11.54156,    0,                   0}, //   30AL
{   13,   32,           956.6,         288.539,    0,                   0}, //   32AL
{   14,   32,            5581,        38.95277,    0,                   0}, //   32SI
{   14,   33,          1434.9,        14.71549,    0,                   0}, //   33SI
{   14,   34,          4256.1,         302.966,    0,                   0}, //   34SI
{   14,   35,          973.88,        8.511901,    0,                   0}, //   35SI
{   15,   34,          2305.1,         2.88539,    0,                   0}, //    34P
{   16,   35,          1991.3,        1.471549,    0,                   0}, //    35S
{   16,   36,            3346,        12.69572,    0,                   0}, //    36S
{   16,   43,             319,        692.4936,    0,                   0}, //    43S
{   16,   44,            1365,        3778.418,    0,                   0}, //    44S
{   17,   34,          146.36,    2.769109e+12,    0,                   0}, //   34CL
{   17,   36,          2518.4,        2.322739,    0,                   0}, //   36CL
{   17,   38,          671.36,    1.031527e+09,    0,                   0}, //   38CL
{   17,   38,          671.37,    1.031527e+09,    0,                   0}, //   38CL
{   17,   40,          244.03,        14.42695,    0,                   0}, //   40CL
{   17,   40,          601.28,        10.09887,    0,                   0}, //   40CL
{   18,   37,          1611.3,        6.319004,    7,         -6.7165e-27}, //   37AR
{   18,   40,            4041,         30.2966,    0,                   0}, //   40AR
{   18,   40,            4420,         30.2966,    0,                   0}, //   40AR
{   19,   37,          1380.2,        15.00403,    7,         2.65125e-26}, //    37K
{   19,   38,           130.4,     1.33305e+09,    0,                   0}, //    38K
{   19,   38,          3458.1,        31667.16,    0,                   0}, //    38K
{   19,   40,           29.83,        6.131454,    6,         -6.5145e-27}, //    40K
{   19,   40,          1643.6,        484.7455,    0,                   0}, //    40K
{   19,   40,          2542.8,        1.572538,   14,          2.0705e-26}, //    40K
{   19,   41,          1293.6,        10.60381,    7,          2.2321e-26}, //    41K
{   19,   42,          638.73,        2.019773,    0,                   0}, //    42K
{   19,   42,          1143.6,        2.019773,    0,                   0}, //    42K
{   19,   42,            1376,        1.601391,    0,                   0}, //    42K
{   19,   43,           738.1,         288.539,    7,         2.23715e-26}, //    43K
{   19,   45,          1081.4,        4.616624,    0,                   0}, //    45K
{   19,   47,             360,        1.586965,    0,                   0}, //    47K
{   19,   47,            2020,        9.088979,    0,                   0}, //    47K
{   19,   48,     2177.000004,        18.75504,    0,                   0}, //    48K
{   19,   49,            91.7,        11.54156,    0,                   0}, //    49K
{   19,   50,           171.4,        180.3369,    0,                   0}, //    50K
{   20,   40,          3352.6,        3.116221,    0,                   0}, //   40CA
{   20,   41,          3829.8,         4.25595,   15,          1.1009e-26}, //   41CA
{   20,   42,          3189.4,        7.732845,   12,        -1.25745e-26}, //   42CA
{   20,   44,            4584,        5.049433,    0,                   0}, //   44CA
{   20,   44,          5230.3,        6.059319,    0,                   0}, //   44CA
{   20,   44,          5733.2,        5.049433,    0,                   0}, //   44CA
{   20,   45,          2353.8,        6.780667,    0,                   0}, //   45CA
{   20,   46,          2973.9,        15.00403,    0,                   0}, //   46CA
{   20,   48,          4503.1,        2.207323,    0,                   0}, //   48CA
{   21,   42,          616.28,    8.901428e+10,    0,                   0}, //   42SC
{   21,   42,            1846,        5.049433,    0,                   0}, //   42SC
{   21,   43,           151.4,        631900.4,    3,          1.7574e-27}, //   43SC
{   21,   43,          3123.2,        678.0667,    0,                   0}, //   43SC
{   21,   44,          67.868,        223.3292,    2,          1.7271e-27}, //   44SC
{   21,   44,          146.19,        73577.45,    0,                   0}, //   44SC
{   21,   44,          234.74,        8.829294,    4,           3.434e-27}, //   44SC
{   21,   44,          271.24,    3.044087e+14,   12,        1.935665e-26}, //   44SC
{   21,   44,          349.85,        4.501209,    8,           1.818e-26}, //   44SC
{   21,   45,            12.4,     4.58777e+08,    3,          1.8584e-27}, //   45SC
{   21,   46,          52.011,        13561.33,    0,                   0}, //   46SC
{   21,   46,          142.53,    2.705053e+10,    0,                   0}, //   46SC
{   21,   47,          766.83,        392.4131,    0,                   0}, //   47SC
{   21,   49,          2228.6,        43.13658,    0,                   0}, //   49SC
{   21,   49,          2371.8,        2.019773,    0,                   0}, //   49SC
{   21,   50,          256.89,    5.049433e+08,    0,                   0}, //   50SC
{   21,   50,          328.45,        14.42695,    0,                   0}, //   50SC
{   21,   50,          1847.8,        14.42695,    0,                   0}, //   50SC
{   21,   54,             110,        10098.87,    0,                   0}, //   54SC
{   21,   56,           4e-06,    1.082021e+08,    0,                   0}, //   56SC
{   21,   56,           774.9,        418.3816,    0,                   0}, //   56SC
{   22,   42,            3043,        4.501209,    0,                   0}, //   42TI
{   22,   43,             313,        18177.96,    0,                   0}, //   43TI
{   22,   43,          3066.4,        807.9092,    0,                   0}, //   43TI
{   22,   44,          8039.9,         3.02966,    0,                   0}, //   44TI
{   22,   45,           36.53,        4328.085,    0,                   0}, //   45TI
{   22,   45,           39.39,        16.28803,    5,         -6.7165e-28}, //   45TI
{   22,   45,           329.3,        1.585522,    3,          5.3025e-27}, //   45TI
{   22,   50,            4410,        4.039546,    0,                   0}, //   50TI
{   23,   44,           4e-06,    2.164043e+08,    0,                   0}, //    44V
{   23,   45,            56.7,        6.059319,    0,                   0}, //    45V
{   23,   45,            56.8,        620.3589,    0,                   0}, //    45V
{   23,   46,           801.1,         1471549,    0,                   0}, //    46V
{   23,   46,          801.46,         1471549,    0,                   0}, //    46V
{   23,   48,          308.27,        10.25756,    4,           2.222e-27}, //    48V
{   23,   48,          518.67,        3.924131,    0,                   0}, //    48V
{   23,   49,          152.93,        28.70963,    3,         1.19685e-26}, //    49V
{   23,   50,           355.5,        4.328085,    0,                   0}, //    50V
{   23,   52,          17.156,        1.558111,    0,                   0}, //    52V
{   23,   53,          228.41,         5.77078,    0,                   0}, //    53V
{   23,   54,             108,        1298.426,    0,                   0}, //    54V
{   23,   60,           4e-06,     5.77078e+07,    0,                   0}, //    60V
{   23,   60,           5e-06,    1.760088e+08,    0,                   0}, //    60V
{   23,   60,      103.200005,        18.75504,    0,                   0}, //    60V
{   23,   60,      202.100005,        461.6624,    0,                   0}, //    60V
{   24,   47,            99.1,         3.02966,    0,                   0}, //   47CR
{   24,   47,           174.2,         3.02966,    0,                   0}, //   47CR
{   24,   48,          3533.5,        4.760894,    0,                   0}, //   48CR
{   24,   51,           749.1,        4.760894,    3,          -4.343e-27}, //   51CR
{   24,   51,          776.95,        9.954596,    0,                   0}, //   51CR
{   24,   59,             503,        138498.7,    0,                   0}, //   59CR
{   25,   50,          225.28,     1.51483e+11,   10,          1.3938e-26}, //   50MN
{   25,   51,          3680.6,        2.063054,    0,                   0}, //   51MN
{   25,   52,          377.75,    1.826452e+12,    4,          3.8784e-29}, //   52MN
{   25,   52,          546.44,        2.668986,    0,                   0}, //   52MN
{   25,   56,          26.605,        12.55145,    0,                   0}, //   56MN
{   25,   56,           110.5,        7.328891,    0,                   0}, //   56MN
{   25,   56,          335.53,         2.88539,    0,                   0}, //   56MN
{   25,   58,           71.77,    9.435226e+10,    0,                   0}, //   58MN
{   25,   58,           71.78,    9.435226e+10,    0,                   0}, //   58MN
{   25,   60,           271.9,     2.55357e+09,    0,                   0}, //   60MN
{   25,   62,           4e-06,    1.327279e+08,    0,                   0}, //   62MN
{   25,   62,           5e-06,    9.680484e+08,    0,                   0}, //   62MN
{   25,   62,      113.800005,         137.056,    0,                   0}, //   62MN
{   25,   64,             175,        721347.5,    0,                   0}, //   64MN
{   26,   51,          3589.7,        2.870963,    0,                   0}, //   51FE
{   26,   52,            6958,     6.62197e+10,    0,                   0}, //   52FE
{   26,   53,          741.11,        91.61114,    0,                   0}, //   53FE
{   26,   53,          774.42,         2.88539,    0,                   0}, //   53FE
{   26,   53,          3040.4,    2.198667e+11,    0,                   0}, //   53FE
{   26,   54,          2949.2,        1.752874,   12,          4.1511e-26}, //   54FE
{   26,   54,          6527.1,         525.141,   20,        3.676905e-26}, //   54FE
{   26,   57,          14.413,        141.8169,    3,        -7.82245e-28}, //   57FE
{   26,   57,          136.47,        12.55145,    5,         4.72175e-27}, //   57FE
{   26,   61,             861,        360.6738,    0,                   0}, //   61FE
{   26,   65,             364,        620.3589,    0,                   0}, //   65FE
{   26,   65,             402,    1.615818e+09,    0,                   0}, //   65FE
{   26,   67,             387,        108202.1,    0,                   0}, //   67FE
{   27,   53,            3197,    3.563457e+08,    0,                   0}, //   53CO
{   27,   54,             197,    1.281113e+11,    0,                   0}, //   54CO
{   27,   56,          1450.7,        2.279458,    0,                   0}, //   56CO
{   27,   58,          24.889,    4.726269e+13,    0,                   0}, //   58CO
{   27,   58,           24.95,    4.726269e+13,    0,                   0}, //   58CO
{   27,   58,           53.15,         15148.3,    8,         2.11292e-26}, //   58CO
{   27,   60,           58.59,    9.060413e+11,    4,           2.222e-26}, //   60CO
{   27,   60,          58.603,    9.060413e+11,    0,                   0}, //   60CO
{   27,   61,          1027.5,        144.2695,    0,                   0}, //   61CO
{   27,   61,          1205.1,        144.2695,    0,                   0}, //   61CO
{   27,   61,          1325.4,        144.2695,    0,                   0}, //   61CO
{   27,   62,              22,    1.199745e+12,    0,                   0}, //   62CO
{   27,   64,           833.6,        9.233248,    0,                   0}, //   64CO
{   27,   66,             175,        1745.661,    0,                   0}, //   66CO
{   27,   66,             642,        1442.695,    0,                   0}, //   66CO
{   27,   68,           4e-06,    2.308312e+09,    0,                   0}, //   68CO
{   27,   68,       48.400005,        145.7122,    0,                   0}, //   68CO
{   27,   70,           4e-06,    7.213475e+08,    0,                   0}, //   70CO
{   28,   58,          2942.6,        2.106335,    0,                   0}, //   58NI
{   28,   61,          67.413,        7.703992,    0,                   0}, //   61NI
{   28,   63,           87.15,        2409.301,    5,          3.7976e-27}, //   63NI
{   28,   63,          1291.8,        4.804174,    0,                   0}, //   63NI
{   28,   65,           63.37,        99545.96,    0,                   0}, //   65NI
{   28,   65,            1017,        36.93299,    0,                   0}, //   65NI
{   28,   66,          3599.3,        6.203589,    0,                   0}, //   66NI
{   28,   67,          1007.2,        19187.84,    0,                   0}, //   67NI
{   28,   68,            1770,        389.5277,    0,                   0}, //   68NI
{   28,   68,          2511.9,        21.64043,    0,                   0}, //   68NI
{   28,   68,          2849.1,         1240718,    0,                   0}, //   68NI
{   28,   68,            4210,        33.18199,    0,                   0}, //   68NI
{   28,   69,            2701,        633.3431,    0,                   0}, //   69NI
{   28,   70,          2678.4,         1.51483,    0,                   0}, //   70NI
{   28,   70,            2860,        334.7052,    0,                   0}, //   70NI
{   28,   71,             499,    3.318199e+09,    0,                   0}, //   71NI
{   28,   76,            2420,        851.1901,    0,                   0}, //   76NI
{   29,   60,            62.2,         2.88539,    0,                   0}, //   60CU
{   29,   62,           40.83,        6.593116,    4,           5.555e-27}, //   62CU
{   29,   62,          390.12,        15.86965,    8,         1.34835e-26}, //   62CU
{   29,   63,          4497.6,         5.91505,   17,           7.878e-27}, //   63CU
{   29,   64,          1594.2,        29.43098,   12,           5.353e-27}, //   64CU
{   29,   66,          1154.2,         865.617,    0,                   0}, //   66CU
{   29,   67,          3463.6,        3.462468,    0,                   0}, //   67CU
{   29,   68,           84.11,        11.31073,    0,                   0}, //   68CU
{   29,   68,          721.26,    3.246064e+11,   12,         5.83174e-27}, //   68CU
{   29,   68,           777.1,        3.462468,    0,                   0}, //   68CU
{   29,   69,          2741.8,        519.3702,    0,                   0}, //   69CU
{   29,   70,           101.1,    4.760894e+10,    0,                   0}, //   70CU
{   29,   70,           242.6,    9.521787e+09,    2,           9.393e-27}, //   70CU
{   29,   71,          2755.7,        390.9704,    0,                   0}, //   71CU
{   29,   72,          137.32,        25.39143,    0,                   0}, //   72CU
{   29,   72,           270.3,        2539.143,    0,                   0}, //   72CU
{   29,   76,           4e-06,    9.247675e+08,    0,                   0}, //   76CU
{   29,   76,           5e-06,    1.832223e+09,    0,                   0}, //   76CU
{   30,   61,            88.4,    6.203589e+08,    0,                   0}, //   61ZN
{   30,   61,           418.1,    2.019773e+08,    0,                   0}, //   61ZN
{   30,   61,          756.02,    1.875504e+08,    0,                   0}, //   61ZN
{   30,   65,          53.928,        2308.312,    0,                   0}, //   65ZN
{   30,   67,          93.312,        13085.24,    1,         2.96435e-27}, //   67ZN
{   30,   67,          184.58,        1.500403,    3,           2.525e-27}, //   67ZN
{   30,   67,          604.48,        480.4174,    9,        -5.53985e-27}, //   67ZN
{   30,   68,          3610.8,        3.606738,    0,                   0}, //   68ZN
{   30,   68,          3942.9,         8.65617,    0,                   0}, //   68ZN
{   30,   69,          438.64,    7.146534e+13,    9,         5.84285e-27}, //   69ZN
{   30,   70,          1070.2,        5.626511,    0,                   0}, //   70ZN
{   30,   71,           157.7,    2.056706e+13,    0,                   0}, //   71ZN
{   30,   73,           4e-06,    8.367631e+09,    0,                   0}, //   73ZN
{   30,   73,           195.5,    1.875504e+07,    0,                   0}, //   73ZN
{   30,   77,          772.43,     1.51483e+09,    0,                   0}, //   77ZN
{   30,   77,          772.44,     1.51483e+09,    0,                   0}, //   77ZN
{   30,   78,          2672.5,        460.2197,    0,                   0}, //   78ZN
{   30,   78,          2673.7,        460.2197,    0,                   0}, //   78ZN
{   31,   62,           817.2,        4.905163,    0,                   0}, //   62GA
{   31,   63,           75.32,        36.06738,    0,                   0}, //   63GA
{   31,   63,          2046.5,         2.88539,    0,                   0}, //   63GA
{   31,   64,           42.85,        31595.02,    0,                   0}, //   64GA
{   31,   64,          128.05,        9.954596,    0,                   0}, //   64GA
{   31,   64,          170.95,        4.328085,    0,                   0}, //   64GA
{   31,   65,           61.94,        1.731234,    0,                   0}, //   65GA
{   31,   66,          43.812,        25.96851,    0,                   0}, //   66GA
{   31,   66,          66.139,        33.18199,    0,                   0}, //   66GA
{   31,   66,          108.89,        1.731234,    0,                   0}, //   66GA
{   31,   66,          162.47,        18.75504,    0,                   0}, //   66GA
{   31,   66,          415.34,         2.88539,    0,                   0}, //   66GA
{   31,   66,           516.2,         2.88539,    0,                   0}, //   66GA
{   31,   66,          863.55,         2.88539,    0,                   0}, //   66GA
{   31,   66,          1464.3,        82.66643,   14,           4.545e-27}, //   66GA
{   31,   66,          2512.4,         2.88539,    0,                   0}, //   66GA
{   31,   66,            2653,         2.88539,    0,                   0}, //   66GA
{   31,   66,          4162.1,         2.88539,    0,                   0}, //   66GA
{   31,   67,          166.98,        60.59319,    0,                   0}, //   67GA
{   31,   68,          175.02,        7.213475,    0,                   0}, //   68GA
{   31,   68,          375.58,        7.213475,    0,                   0}, //   68GA
{   31,   68,          496.09,        7.213475,    0,                   0}, //   68GA
{   31,   68,          583.79,        7.213475,    0,                   0}, //   68GA
{   31,   68,          806.16,        7.213475,    0,                   0}, //   68GA
{   31,   68,          876.75,        7.213475,    0,                   0}, //   68GA
{   31,   68,          1055.9,        7.213475,    0,                   0}, //   68GA
{   31,   68,          1103.5,        7.213475,    0,                   0}, //   68GA
{   31,   68,          1223.5,        7.213475,    0,                   0}, //   68GA
{   31,   68,          1229.9,        89.44709,   14,           3.737e-27}, //   68GA
{   31,   68,          1247.6,        7.213475,    0,                   0}, //   68GA
{   31,   68,          1323.2,        7.213475,    0,                   0}, //   68GA
{   31,   68,          1493.8,        7.213475,    0,                   0}, //   68GA
{   31,   68,          2088.1,        7.213475,    0,                   0}, //   68GA
{   31,   68,            2103,        7.213475,    0,                   0}, //   68GA
{   31,   68,          2284.7,        7.213475,    0,                   0}, //   68GA
{   31,   68,          2396.8,        7.213475,    0,                   0}, //   68GA
{   31,   68,          2611.8,        7.213475,    0,                   0}, //   68GA
{   31,   68,          2896.1,        7.213475,    0,                   0}, //   68GA
{   31,   68,          2953.2,        7.213475,    0,                   0}, //   68GA
{   31,   68,          3817.6,        7.213475,    0,                   0}, //   68GA
{   31,   68,            3965,        7.213475,    0,                   0}, //   68GA
{   31,   70,           508.2,         5.77078,    0,                   0}, //   70GA
{   31,   70,           690.9,         5.77078,    0,                   0}, //   70GA
{   31,   70,           879.1,        32.74918,    8,          -1.313e-27}, //   70GA
{   31,   70,           901.4,        2.019773,    0,                   0}, //   70GA
{   31,   70,          1034.2,         5.77078,    0,                   0}, //   70GA
{   31,   70,          1180.6,         5.77078,    0,                   0}, //   70GA
{   31,   70,          1234.5,         5.77078,    0,                   0}, //   70GA
{   31,   70,          1371.7,         5.77078,    0,                   0}, //   70GA
{   31,   70,          1523.6,         5.77078,    0,                   0}, //   70GA
{   31,   70,            1539,         5.77078,    0,                   0}, //   70GA
{   31,   70,          1687.8,         5.77078,    0,                   0}, //   70GA
{   31,   70,          2601.6,         5.77078,    0,                   0}, //   70GA
{   31,   70,          2651.7,         5.77078,    0,                   0}, //   70GA
{   31,   70,          2886.4,         5.77078,    0,                   0}, //   70GA
{   31,   72,           16.44,        56.55365,    0,                   0}, //   72GA
{   31,   72,          119.66,    5.724614e+07,    0,                   0}, //   72GA
{   31,   74,           56.55,        44.72355,    0,                   0}, //   74GA
{   31,   74,          59.571,     1.37056e+10,    0,                   0}, //   74GA
{   31,   74,            59.7,     1.37056e+10,    0,                   0}, //   74GA
{   31,   75,          178.36,         5.77078,    0,                   0}, //   75GA
{   31,   75,          228.63,         2.88539,    0,                   0}, //   75GA
{   31,   77,          105.66,         5.77078,    0,                   0}, //   77GA
{   31,   77,          160.95,         2.88539,    0,                   0}, //   77GA
{   31,   77,          189.49,         2.88539,    0,                   0}, //   77GA
{   31,   77,          2028.8,        6.347858,    0,                   0}, //   77GA
{   31,   78,           559.6,        721.3475,    0,                   0}, //   78GA
{   31,   78,             560,        721.3475,    0,                   0}, //   78GA
{   31,   84,           4e-06,    1.226291e+08,    0,                   0}, //   84GA
{   32,   65,          1215.9,        10.09887,    0,                   0}, //   65GE
{   32,   65,          2080.2,         2.88539,    0,                   0}, //   65GE
{   32,   65,          5210.4,         2.88539,    0,                   0}, //   65GE
{   32,   67,            18.2,        19764.92,    0,                   0}, //   67GE
{   32,   67,           751.7,        210.6335,    9,        -4.28745e-27}, //   67GE
{   32,   69,              85,        7357.745,    0,                   0}, //   69GE
{   32,   69,          86.765,        7357.745,    0,                   0}, //   69GE
{   32,   69,          397.94,        4053.973,    9,       -5.055555e-27}, //   69GE
{   32,   70,          1215.5,        5.337972,    0,                   0}, //   70GE
{   32,   70,            5540,        7.213475,    0,                   0}, //   70GE
{   32,   71,          174.94,        113.9729,    5,          5.1409e-27}, //   71GE
{   32,   71,          198.35,    2.944541e+07,    9,       -5.258565e-27}, //   71GE
{   32,   71,          198.37,    2.944541e+07,    0,                   0}, //   71GE
{   32,   72,          691.43,        640.8451,    0,                   0}, //   72GE
{   32,   73,          13.284,         4212.67,    5,          -5.454e-27}, //   73GE
{   32,   73,           66.59,    7.199048e+08,    0,                   0}, //   73GE
{   32,   73,          66.726,    7.199048e+08,    0,                   0}, //   73GE
{   32,   73,          68.752,        2.510289,    0,                   0}, //   73GE
{   32,   75,          139.68,    6.881655e+10,    0,                   0}, //   75GE
{   32,   75,          139.69,    6.881655e+10,    0,                   0}, //   75GE
{   32,   75,          192.18,        311.6221,    0,                   0}, //   75GE
{   32,   77,           159.7,    7.747272e+10,    0,                   0}, //   77GE
{   32,   77,          159.71,    7.747272e+10,    0,                   0}, //   77GE
{   32,   79,          185.95,    5.626511e+10,    0,                   0}, //   79GE
{   32,   80,          3445.1,         4.25595,    0,                   0}, //   80GE
{   32,   81,          679.14,    1.096448e+10,    0,                   0}, //   81GE
{   32,   81,          711.21,        5.626511,    0,                   0}, //   81GE
{   33,   66,          1356.6,        1586.965,    0,                   0}, //   66AS
{   33,   66,          3023.8,         11830.1,    0,                   0}, //   66AS
{   33,   67,          1422.6,        17.31234,    0,                   0}, //   67AS
{   33,   68,           158.1,        7.213475,    0,                   0}, //   68AS
{   33,   68,           160.7,        14.42695,    0,                   0}, //   68AS
{   33,   68,           214.1,        7.213475,    0,                   0}, //   68AS
{   33,   68,           313.2,        7.213475,    0,                   0}, //   68AS
{   33,   68,           425.1,        154.3684,    0,                   0}, //   68AS
{   33,   68,           500.1,        7.213475,    0,                   0}, //   68AS
{   33,   68,           549.7,        7.213475,    0,                   0}, //   68AS
{   33,   68,           733.4,        7.213475,    0,                   0}, //   68AS
{   33,   68,           893.4,        7.213475,    0,                   0}, //   68AS
{   33,   68,           964.8,        7.213475,    0,                   0}, //   68AS
{   33,   68,          1214.3,        7.213475,    0,                   0}, //   68AS
{   33,   68,          1303.8,        7.213475,    0,                   0}, //   68AS
{   33,   68,          1322.9,        7.213475,    0,                   0}, //   68AS
{   33,   68,          1427.6,        7.213475,    0,                   0}, //   68AS
{   33,   68,          1571.2,        27.41121,    0,                   0}, //   68AS
{   33,   68,          1859.2,        7.213475,    0,                   0}, //   68AS
{   33,   68,          1955.4,        7.213475,    0,                   0}, //   68AS
{   33,   68,            2058,        7.213475,    0,                   0}, //   68AS
{   33,   68,          2093.9,        7.213475,    0,                   0}, //   68AS
{   33,   68,          2157.8,        51.93702,    0,                   0}, //   68AS
{   33,   68,          2251.2,        7.213475,    0,                   0}, //   68AS
{   33,   68,          2302.1,        7.213475,    0,                   0}, //   68AS
{   33,   68,          2474.4,        7.213475,    0,                   0}, //   68AS
{   33,   68,          2829.8,        7.213475,    0,                   0}, //   68AS
{   33,   68,          2938.8,        7.213475,    0,                   0}, //   68AS
{   33,   68,          3126.6,        7.213475,    0,                   0}, //   68AS
{   33,   68,          3170.2,        7.213475,    0,                   0}, //   68AS
{   33,   68,          3183.2,        7.213475,    0,                   0}, //   68AS
{   33,   68,            3341,        7.213475,    0,                   0}, //   68AS
{   33,   68,          4366.2,        7.213475,    0,                   0}, //   68AS
{   33,   68,          4388.2,        7.213475,    0,                   0}, //   68AS
{   33,   68,          4585.8,        7.213475,    0,                   0}, //   68AS
{   33,   68,          4897.3,        7.213475,    0,                   0}, //   68AS
{   33,   68,          5087.2,        7.213475,    0,                   0}, //   68AS
{   33,   68,          5652.7,        7.213475,    0,                   0}, //   68AS
{   33,   68,          6063.5,        7.213475,    0,                   0}, //   68AS
{   33,   69,           97.99,         2.88539,    0,                   0}, //   69AS
{   33,   69,          1306.8,        1.947638,    9,          2.3836e-26}, //   69AS
{   33,   70,          32.008,        138498.7,    0,                   0}, //   70AS
{   33,   70,           81.49,        4.328085,    0,                   0}, //   70AS
{   33,   70,          166.74,         8.65617,    0,                   0}, //   70AS
{   33,   70,          167.66,        4.328085,    0,                   0}, //   70AS
{   33,   70,          485.32,         5.91505,    0,                   0}, //   70AS
{   33,   70,          566.52,         2.88539,    0,                   0}, //   70AS
{   33,   70,          887.76,        6.492128,    0,                   0}, //   70AS
{   33,   70,          890.43,        7.934823,    0,                   0}, //   70AS
{   33,   70,          1676.1,         2.88539,    0,                   0}, //   70AS
{   33,   70,          1752.2,         2.88539,    0,                   0}, //   70AS
{   33,   71,           143.5,        85.11901,    0,                   0}, //   71AS
{   33,   71,          1000.3,        28.56536,    9,         2.60075e-26}, //   71AS
{   33,   72,          46.025,        15.43684,    0,                   0}, //   72AS
{   33,   72,          213.56,        122.6291,    6,           7.979e-27}, //   72AS
{   33,   72,          288.47,         2.88539,    0,                   0}, //   72AS
{   33,   72,          309.74,        38.95277,    0,                   0}, //   72AS
{   33,   72,          318.19,        38.95277,    0,                   0}, //   72AS
{   33,   72,          562.85,        126.8129,    0,                   0}, //   72AS
{   33,   73,          67.039,         7.14134,    5,          8.2315e-27}, //   73AS
{   33,   73,          427.91,        8223.362,    9,         2.64317e-26}, //   73AS
{   33,   74,          259.19,        38.66423,    0,                   0}, //   74AS
{   33,   75,          303.92,    2.542029e+07,    0,                   0}, //   75AS
{   33,   75,          400.66,        2.409301,    0,                   0}, //   75AS
{   33,   76,          44.425,        2654.559,    0,                   0}, //   76AS
{   33,   77,          194.71,        10.67594,    0,                   0}, //   77AS
{   33,   77,          475.48,        164467.2,    9,        2.790125e-26}, //   77AS
{   33,   78,           211.7,        5.626511,    0,                   0}, //   78AS
{   33,   78,           364.7,        4.328085,    0,                   0}, //   78AS
{   33,   79,          772.81,        1255.145,    0,                   0}, //   79AS
{   33,   82,           4e-06,    1.962065e+10,    0,                   0}, //   82AS
{   34,   69,            39.4,         2885.39,    0,                   0}, //   69SE
{   34,   69,           573.9,        1384.987,    0,                   0}, //   69SE
{   34,   70,          7304.9,        2.308312,    0,                   0}, //   70SE
{   34,   71,           48.79,        8079.092,    0,                   0}, //   71SE
{   34,   71,          260.48,        27411.21,    0,                   0}, //   71SE
{   34,   72,          937.22,        25.24716,    0,                   0}, //   72SE
{   34,   73,           25.71,    3.445156e+12,    0,                   0}, //   73SE
{   34,   75,          133.04,        7.646284,    0,                   0}, //   75SE
{   34,   75,          286.57,        1.861077,    0,                   0}, //   75SE
{   34,   75,           293.1,        43.28085,    0,                   0}, //   75SE
{   34,   77,          161.92,    2.504519e+10,    0,                   0}, //   77SE
{   34,   77,          249.79,        13.96529,    5,          5.6459e-27}, //   77SE
{   34,   78,            3014,        4.328085,    0,                   0}, //   78SE
{   34,   79,           95.77,    3.393219e+11,    0,                   0}, //   79SE
{   34,   81,             103,    4.958254e+12,    0,                   0}, //   81SE
{   34,   82,          3518.5,        9.521787,    0,                   0}, //   82SE
{   34,   83,           228.5,    1.011329e+11,    0,                   0}, //   83SE
{   34,   83,             582,        4.328085,    0,                   0}, //   83SE
{   35,   70,          2292.3,    3.173929e+09,    0,                   0}, //   70BR
{   35,   71,          759.06,        46.88759,    0,                   0}, //   71BR
{   35,   72,          100.76,    1.529257e+10,    0,                   0}, //   72BR
{   35,   72,          370.56,         3.02966,    0,                   0}, //   72BR
{   35,   72,           716.7,        2.452582,    0,                   0}, //   72BR
{   35,   73,           240.5,        50.49433,    0,                   0}, //   73BR
{   35,   73,          473.63,        1.586965,    0,                   0}, //   73BR
{   35,   74,           13.58,    3.981838e+12,    0,                   0}, //   74BR
{   35,   74,           85.71,        19.18784,    0,                   0}, //   74BR
{   35,   75,          119.52,        2.452582,    0,                   0}, //   75BR
{   35,   75,          132.46,         8.80044,    0,                   0}, //   75BR
{   35,   75,          154.61,        1.731234,    0,                   0}, //   75BR
{   35,   75,           220.8,        45.73343,    0,                   0}, //   75BR
{   35,   76,           45.47,        1.630245,    0,                   0}, //   76BR
{   35,   76,          102.58,    1.889931e+09,    0,                   0}, //   76BR
{   35,   76,          102.59,    1.889931e+09,    0,                   0}, //   76BR
{   35,   76,          252.28,        3.145075,    0,                   0}, //   76BR
{   35,   77,          105.86,    3.704841e+11,    0,                   0}, //   77BR
{   35,   77,          129.64,        13.41706,    5,          1.6665e-26}, //   77BR
{   35,   78,           32.32,        16.30245,    0,                   0}, //   78BR
{   35,   78,           55.11,        10.82021,    0,                   0}, //   78BR
{   35,   78,          180.89,        172257.8,    0,                   0}, //   78BR
{   35,   78,           180.9,        172257.8,    0,                   0}, //   78BR
{   35,   78,          197.24,        6.780667,    0,                   0}, //   78BR
{   35,   78,           204.4,        8.511901,    0,                   0}, //   78BR
{   35,   78,          227.67,        121.1864,    0,                   0}, //   78BR
{   35,   78,          242.82,        24.52582,    0,                   0}, //   78BR
{   35,   78,          265.03,        7.357745,    0,                   0}, //   78BR
{   35,   78,          337.85,        10.53167,    0,                   0}, //   78BR
{   35,   78,           423.4,        36.06738,    0,                   0}, //   78BR
{   35,   78,          437.74,        4.328085,    0,                   0}, //   78BR
{   35,   79,          207.58,    7.011498e+09,    0,                   0}, //   79BR
{   35,   79,          207.61,    7.011498e+09,    0,                   0}, //   79BR
{   35,   80,          37.053,        10.71922,    4,         -8.4335e-27}, //   80BR
{   35,   80,          85.843,    2.295905e+13,   10,        6.654385e-27}, //   80BR
{   35,   80,          85.902,    2.295905e+13,    0,                   0}, //   80BR
{   35,   81,           536.2,        49917.25,    9,         2.87547e-26}, //   81BR
{   35,   82,          45.949,    5.306232e+11,    0,                   0}, //   82BR
{   35,   82,          75.062,         10.3874,    0,                   0}, //   82BR
{   35,   83,          1091.9,         5.91505,    0,                   0}, //   83BR
{   35,   83,          3068.8,        1009.887,    0,                   0}, //   83BR
{   35,   84,             320,    5.193702e+11,    0,                   0}, //   84BR
{   35,   84,           408.2,        201.9773,    0,                   0}, //   84BR
{   35,   88,           270.1,        7646.284,    0,                   0}, //   88BR
{   36,   72,             671,        37.94288,    0,                   0}, //   72KR
{   36,   73,          433.66,        154.3684,    0,                   0}, //   73KR
{   36,   74,             509,        18.75504,    0,                   0}, //   74KR
{   36,   75,          178.93,        3.000806,    0,                   0}, //   75KR
{   36,   77,            66.5,         170.238,    0,                   0}, //   77KR
{   36,   79,          129.77,    7.213475e+10,    7,         -3.9693e-27}, //   79KR
{   36,   79,          147.06,        113.5401,    5,          5.6762e-27}, //   79KR
{   36,   80,          3041.7,        3.173929,    0,                   0}, //   80KR
{   36,   81,           49.57,        5.626511,    0,                   0}, //   81KR
{   36,   81,          190.64,    1.889931e+10,    1,          2.9593e-27}, //   81KR
{   36,   83,          9.4053,        222.7521,    7,        -4.76215e-27}, //   83KR
{   36,   83,          41.557,    9.504475e+12,    1,         2.98455e-27}, //   83KR
{   36,   84,          3236.1,        2640.132,   16,         -9.9384e-27}, //   84KR
{   36,   84,          5373.4,        63.04577,   24,          1.0302e-26}, //   84KR
{   36,   85,          304.87,    2.326779e+13,    0,                   0}, //   85KR
{   36,   85,          1991.8,        1731.234,    0,                   0}, //   85KR
{   36,   86,            2250,        4.472355,    0,                   0}, //   86KR
{   36,   89,           28.59,        31.30648,    0,                   0}, //   89KR
{   36,   91,           144.3,        80.79092,    0,                   0}, //   91KR
{   36,   93,          354.85,        14.42695,    0,                   0}, //   93KR
{   36,   95,           195.5,        2019.773,    0,                   0}, //   95KR
{   37,   76,          316.93,        4616.624,    0,                   0}, //   76RB
{   37,   77,          146.93,        7.357745,    0,                   0}, //   77RB
{   37,   78,           46.84,        1312.852,    0,                   0}, //   78RB
{   37,   78,          111.19,    4.968642e+11,    0,                   0}, //   78RB
{   37,   78,           111.2,    4.968642e+11,    0,                   0}, //   78RB
{   37,   79,           39.37,        29.57525,    0,                   0}, //   79RB
{   37,   79,           96.76,        26.83413,    9,         2.54015e-26}, //   79RB
{   37,   79,          144.38,        4.328085,    0,                   0}, //   79RB
{   37,   79,           174.2,        4.328085,    0,                   0}, //   79RB
{   37,   79,          285.34,        4.328085,    0,                   0}, //   79RB
{   37,   79,          357.13,        4.328085,    0,                   0}, //   79RB
{   37,   79,          363.37,        4.328085,    0,                   0}, //   79RB
{   37,   79,          452.89,        4.328085,    0,                   0}, //   79RB
{   37,   79,          651.75,        4.328085,    0,                   0}, //   79RB
{   37,   80,           334.5,        5.049433,    0,                   0}, //   80RB
{   37,   80,           397.6,        3.895277,    0,                   0}, //   80RB
{   37,   80,           418.5,        1.601391,    0,                   0}, //   80RB
{   37,   80,           472.5,        7.069206,    0,                   0}, //   80RB
{   37,   80,           493.9,        2351.593,    0,                   0}, //   80RB
{   37,   80,           650.7,        20.05346,    0,                   0}, //   80RB
{   37,   81,           86.31,    2.640132e+12,    9,         2.82699e-26}, //   81RB
{   37,   82,              69,    3.361335e+13,   10,        7.625541e-27}, //   82RB
{   37,   82,            88.9,        2.394874,    0,                   0}, //   82RB
{   37,   82,           192.2,        17.74515,   12,          2.0301e-26}, //   82RB
{   37,   82,           256.2,        7.213475,    0,                   0}, //   82RB
{   37,   82,             302,        7.213475,    0,                   0}, //   82RB
{   37,   83,            5.26,        103.1527,    0,                   0}, //   83RB
{   37,   83,           42.11,        432808.5,    0,                   0}, //   83RB
{   37,   84,          463.59,     1.75374e+12,   12,        1.075312e-27}, //   84RB
{   37,   84,          466.64,        12.98426,    0,                   0}, //   84RB
{   37,   84,          543.28,        15.86965,    0,                   0}, //   84RB
{   37,   85,          514.01,        1464.335,    9,         3.05323e-26}, //   85RB
{   37,   85,          2826.6,        18.03369,    0,                   0}, //   85RB
{   37,   86,          556.05,    8.803325e+10,   12,         9.16575e-27}, //   86RB
{   37,   86,          556.07,    8.803325e+10,    0,                   0}, //   86RB
{   37,   87,          1577.9,         8.65617,    0,                   0}, //   87RB
{   37,   88,          1373.9,        144.2695,    0,                   0}, //   88RB
{   37,   90,           106.9,    3.722153e+11,    6,        8.160699e-27}, //   90RB
{   37,   91,          1133.8,        24.52582,    0,                   0}, //   91RB
{   37,   93,          253.39,        82233.62,    0,                   0}, //   93RB
{   37,   93,          266.86,         2.88539,    0,                   0}, //   93RB
{   37,   93,          4423.1,        160.1391,    0,                   0}, //   93RB
{   37,   94,          190.87,        3.606738,    0,                   0}, //   94RB
{   37,   94,          1485.2,        25.96851,    0,                   0}, //   94RB
{   37,   94,          2074.9,        154.3684,    0,                   0}, //   94RB
{   37,   95,             835,        721.3475,    0,                   0}, //   95RB
{   37,   96,          1134.6,         2885.39,    0,                   0}, //   96RB
{   37,   98,             270,    1.384987e+08,    0,                   0}, //   98RB
{   38,   79,           177.3,         28.8539,    0,                   0}, //   79SR
{   38,   81,           79.23,        562.6511,    0,                   0}, //   81SR
{   38,   81,           89.05,        9233.248,    0,                   0}, //   81SR
{   38,   81,          119.76,        34.62468,    0,                   0}, //   81SR
{   38,   81,           132.2,        12.98426,    0,                   0}, //   81SR
{   38,   81,          203.39,        1.586965,    0,                   0}, //   81SR
{   38,   81,          611.57,        10.09887,    0,                   0}, //   81SR
{   38,   82,          1310.9,        5.049433,    0,                   0}, //   82SR
{   38,   83,           35.47,        21.64043,    0,                   0}, //   83SR
{   38,   83,          259.15,     7.14134e+09,    1,         2.93405e-27}, //   83SR
{   38,   85,          238.66,    5.854168e+12,    1,         3.02495e-27}, //   85SR
{   38,   85,          238.78,    5.854168e+12,    0,                   0}, //   85SR
{   38,   85,          2367.3,        1.731234,    0,                   0}, //   85SR
{   38,   86,          2229.7,        7.213475,    0,                   0}, //   86SR
{   38,   86,          2481.9,        7.213475,    0,                   0}, //   86SR
{   38,   86,          2672.8,        7.213475,    0,                   0}, //   86SR
{   38,   86,            2857,        7.213475,    0,                   0}, //   86SR
{   38,   86,          2955.7,        656.4262,   16,          -9.696e-27}, //   86SR
{   38,   86,          3055.8,        7.213475,    0,                   0}, //   86SR
{   38,   86,          3185.2,        7.213475,    0,                   0}, //   86SR
{   38,   86,          3291.3,        7.213475,    0,                   0}, //   86SR
{   38,   86,          3482.2,        7.213475,    0,                   0}, //   86SR
{   38,   86,          3665.2,        7.213475,    0,                   0}, //   86SR
{   38,   86,          3765.7,        7.213475,    0,                   0}, //   86SR
{   38,   86,            3973,        7.213475,    0,                   0}, //   86SR
{   38,   86,          4148.1,        7.213475,    0,                   0}, //   86SR
{   38,   86,          4600.5,        7.213475,    0,                   0}, //   86SR
{   38,   86,          5012.7,        7.213475,    0,                   0}, //   86SR
{   38,   86,          5425.6,        7.213475,    0,                   0}, //   86SR
{   38,   87,          388.53,    1.462027e+13,    1,          3.1512e-27}, //   87SR
{   38,   91,          93.628,        128.9769,    0,                   0}, //   91SR
{   38,   93,          213.43,        6.203589,    0,                   0}, //   93SR
{   38,   95,          556.08,        31.59502,    0,                   0}, //   95SR
{   38,   96,          1464.6,        9.666057,    0,                   0}, //   96SR
{   38,   96,          3524.5,         57.7078,    0,                   0}, //   96SR
{   38,   97,          308.13,        243.8155,    0,                   0}, //   97SR
{   38,   97,          312.03,         5.77078,    0,                   0}, //   97SR
{   38,   97,          644.73,         10.3874,    0,                   0}, //   97SR
{   38,   97,          713.82,        1.832223,    0,                   0}, //   97SR
{   38,   97,          830.83,        569.8645,    0,                   0}, //   97SR
{   38,   98,          144.22,        4.010692,    4,           3.838e-27}, //   98SR
{   38,   98,          215.35,        32.89345,    0,                   0}, //   98SR
{   38,   98,          1837.5,        10.24313,    0,                   0}, //   98SR
{   38,  100,          129.16,        5.640938,    0,                   0}, //  100SR
{   38,  100,          1618.7,        122.6291,    0,                   0}, //  100SR
{   38,  101,           363.9,        2.019773,    0,                   0}, //  101SR
{   38,  102,             126,        4.328085,    0,                   0}, //  102SR
{   39,   78,           4e-06,    8.367631e+09,    0,                   0}, //    78Y
{   39,   80,           228.5,    6.924936e+09,    0,                   0}, //    80Y
{   39,   80,           312.6,        6780.667,    0,                   0}, //    80Y
{   39,   81,          113.28,        10.09887,    0,                   0}, //    81Y
{   39,   81,          149.63,        10.09887,    0,                   0}, //    81Y
{   39,   81,          268.56,        10.09887,    0,                   0}, //    81Y
{   39,   81,          288.63,        10.09887,    0,                   0}, //    81Y
{   39,   81,          537.07,        10.09887,    0,                   0}, //    81Y
{   39,   81,          683.39,        10.09887,    0,                   0}, //    81Y
{   39,   81,          825.59,        10.09887,    0,                   0}, //    81Y
{   39,   81,          1167.4,        10.09887,    0,                   0}, //    81Y
{   39,   81,          1530.4,        10.09887,    0,                   0}, //    81Y
{   39,   81,          1952.2,        10.09887,    0,                   0}, //    81Y
{   39,   82,           401.1,        15.86965,    0,                   0}, //    82Y
{   39,   82,          402.63,        386.6423,    0,                   0}, //    82Y
{   39,   82,          405.76,        50.92713,    0,                   0}, //    82Y
{   39,   82,           507.5,        212.0762,    0,                   0}, //    82Y
{   39,   82,          511.82,        2.048627,    0,                   0}, //    82Y
{   39,   83,           61.98,    2.467009e+11,    0,                   0}, //    83Y
{   39,   83,            97.1,        14.13841,    0,                   0}, //    83Y
{   39,   84,              67,    6.636397e+09,    0,                   0}, //    84Y
{   39,   84,           112.4,        113.9729,    0,                   0}, //    84Y
{   39,   84,           156.7,        21.06335,    0,                   0}, //    84Y
{   39,   84,          162.88,        46.16624,    0,                   0}, //    84Y
{   39,   84,          210.42,         421.267,    0,                   0}, //    84Y
{   39,   84,          216.11,         26.9784,    0,                   0}, //    84Y
{   39,   85,            19.8,    2.524139e+13,    9,           3.131e-26}, //    85Y
{   39,   85,           266.3,        256.7997,    5,          6.7165e-27}, //    85Y
{   39,   86,           218.3,    4.154962e+12,    0,                   0}, //    86Y
{   39,   86,           242.8,        41.11681,    4,          -5.353e-27}, //    86Y
{   39,   86,           271.9,        14.42695,    0,                   0}, //    86Y
{   39,   86,           302.2,        180.3369,    0,                   0}, //    86Y
{   39,   87,          380.82,     6.94398e+13,    9,         3.05525e-26}, //    87Y
{   39,   87,          793.73,        14.42695,    0,                   0}, //    87Y
{   39,   87,          1404.4,        14.42695,    0,                   0}, //    87Y
{   39,   87,          1404.9,        14.42695,    0,                   0}, //    87Y
{   39,   87,          1590.9,        14.42695,    0,                   0}, //    87Y
{   39,   87,            2038,        14.42695,    0,                   0}, //    87Y
{   39,   87,          2366.9,        14.42695,    0,                   0}, //    87Y
{   39,   87,          2428.1,        14.42695,    0,                   0}, //    87Y
{   39,   88,          392.86,        434251.2,    0,                   0}, //    88Y
{   39,   88,          674.55,    2.015445e+07,    0,                   0}, //    88Y
{   39,   89,          908.96,    2.259693e+10,    0,                   0}, //    89Y
{   39,   89,          908.97,    2.259693e+10,    9,         3.14615e-26}, //    89Y
{   39,   90,          681.67,    1.656791e+13,   14,          2.5755e-26}, //    90Y
{   39,   90,          682.04,    1.656791e+13,    0,                   0}, //    90Y
{   39,   91,          555.57,    4.302982e+12,    0,                   0}, //    91Y
{   39,   91,          555.58,    4.302982e+12,    9,          3.0098e-26}, //    91Y
{   39,   93,          758.72,     1.18301e+09,    0,                   0}, //    93Y
{   39,   94,          1202.3,        1947.638,    0,                   0}, //    94Y
{   39,   95,          1087.6,        75885.76,    0,                   0}, //    95Y
{   39,   95,          3142.5,        23.08312,    0,                   0}, //    95Y
{   39,   95,          5022.2,        93.77518,    0,                   0}, //    95Y
{   39,   96,            1140,    1.384987e+10,   16,         3.31785e-26}, //    96Y
{   39,   97,          667.52,    1.687953e+09,    0,                   0}, //    97Y
{   39,   97,            1336,        4.328085,    0,                   0}, //    97Y
{   39,   97,          1657.4,         2.88539,    0,                   0}, //    97Y
{   39,   97,          2568.8,         2.88539,    0,                   0}, //    97Y
{   39,   97,          2748.2,         5.77078,    0,                   0}, //    97Y
{   39,   97,          2965.3,         2.88539,    0,                   0}, //    97Y
{   39,   97,          3360.3,         2.88539,    0,                   0}, //    97Y
{   39,   97,          3522.6,    2.048627e+08,    0,                   0}, //    97Y
{   39,   98,          170.74,        894.4709,    0,                   0}, //    98Y
{   39,   98,          374.91,        51.64848,    0,                   0}, //    98Y
{   39,   98,             410,     2.88539e+09,    0,                   0}, //    98Y
{   39,   98,          496.19,        10964.48,    0,                   0}, //    98Y
{   39,   98,          563.98,        3.462468,    0,                   0}, //    98Y
{   39,   98,          600.22,        10.82021,    0,                   0}, //    98Y
{   39,   98,          1070.3,        2.164043,    0,                   0}, //    98Y
{   39,   98,          1181.1,        1197.437,    0,                   0}, //    98Y
{   39,   99,          1654.7,        2.019773,    0,                   0}, //    99Y
{   39,   99,          2141.7,        12407.18,    0,                   0}, //    99Y
{   39,  100,             145,    1.356133e+09,    0,                   0}, //   100Y
{   39,  102,           4e-06,    5.193702e+08,    0,                   0}, //   102Y
{   39,  102,           5e-06,    4.299231e+08,    0,                   0}, //   102Y
{   40,   81,           133.2,        40.39546,    0,                   0}, //   81ZR
{   40,   81,          191.85,        40.39546,    0,                   0}, //   81ZR
{   40,   83,           52.72,        764.6284,    0,                   0}, //   83ZR
{   40,   83,           77.04,        190.4357,    0,                   0}, //   83ZR
{   40,   85,           292.2,    1.572538e+10,    0,                   0}, //   85ZR
{   40,   87,          200.91,        3.520176,    0,                   0}, //   87ZR
{   40,   87,          335.84,    2.019773e+10,    0,                   0}, //   87ZR
{   40,   87,          2073.7,        4.284804,    0,                   0}, //   87ZR
{   40,   87,          2312.5,        3.895277,    0,                   0}, //   87ZR
{   40,   88,          2887.8,        1904.357,    0,                   0}, //   88ZR
{   40,   88,          4713.1,        3.246064,    0,                   0}, //   88ZR
{   40,   89,           587.8,    3.601832e+11,    0,                   0}, //   89ZR
{   40,   89,          587.82,    3.601832e+11,    0,                   0}, //   89ZR
{   40,   89,          2121.3,         3.21721,    0,                   0}, //   89ZR
{   40,   89,          2150.6,        4.905163,    0,                   0}, //   89ZR
{   40,   89,            2159,        4.905163,    0,                   0}, //   89ZR
{   40,   89,          2995.3,        7.415453,    0,                   0}, //   89ZR
{   40,   90,          1760.7,        88.43721,    0,                   0}, //   90ZR
{   40,   90,            2319,    1.167429e+09,   10,         3.15625e-26}, //   90ZR
{   40,   90,          3589.4,        188.9931,   16,         5.47925e-26}, //   90ZR
{   40,   91,          2287.8,        41.83816,    0,                   0}, //   91ZR
{   40,   91,          2857.1,        10.09887,    0,                   0}, //   91ZR
{   40,   91,          3146.9,        10.09887,    0,                   0}, //   91ZR
{   40,   91,          3167.3,        6275.723,    0,                   0}, //   91ZR
{   40,   92,            2486,        5.049433,    0,                   0}, //   92ZR
{   40,   92,          2957.7,        5.049433,    0,                   0}, //   92ZR
{   40,   92,            3309,         1.70238,    0,                   0}, //   92ZR
{   40,   92,          3379.8,        5.049433,    0,                   0}, //   92ZR
{   40,   92,          3819.4,        5.049433,    0,                   0}, //   92ZR
{   40,   92,          3998.8,        5.049433,    0,                   0}, //   92ZR
{   40,   92,          4296.9,        5.049433,    0,                   0}, //   92ZR
{   40,   92,          4947.5,        5.049433,    0,                   0}, //   92ZR
{   40,   93,          266.82,        2.091908,    0,                   0}, //   93ZR
{   40,   96,          1581.6,        54.82241,    0,                   0}, //   96ZR
{   40,   97,          1264.3,        148.3091,    7,          6.9185e-27}, //   97ZR
{   40,   97,          2263.6,        2.452582,    0,                   0}, //   97ZR
{   40,   98,          854.02,        92.33248,    0,                   0}, //   98ZR
{   40,   99,          121.74,        1.543684,    0,                   0}, //   99ZR
{   40,   99,          251.96,        422.7096,    0,                   0}, //   99ZR
{   40,   99,          614.14,        10.09887,    0,                   0}, //   99ZR
{   40,   99,          667.48,        3.751007,    0,                   0}, //   99ZR
{   40,   99,          678.55,        12.83999,    0,                   0}, //   99ZR
{   40,   99,          1038.5,        77.90553,    0,                   0}, //   99ZR
{   40,  100,          331.13,        7.978104,    0,                   0}, //  100ZR
{   40,  100,          2259.7,        3.606738,    0,                   0}, //  100ZR
{   40,  101,          941.81,        23.08312,    0,                   0}, //  101ZR
{   40,  102,          151.78,        2.596851,    4,           2.222e-27}, //  102ZR
{   40,  103,           109.1,        4.328085,    0,                   0}, //  103ZR
{   40,  103,           357.1,        4.328085,    0,                   0}, //  103ZR
{   40,  104,           139.3,         2.88539,    0,                   0}, //  104ZR
{   40,  108,           4e-06,        894.4709,    0,                   0}, //  108ZR
{   41,   82,            1180,        132.7279,    0,                   0}, //   82NB
{   41,   84,           337.7,        148.5976,    0,                   0}, //   84NB
{   41,   84,           338.7,        148.5976,    0,                   0}, //   84NB
{   41,   86,           4e-06,    1.269572e+11,    0,                   0}, //   86NB
{   41,   86,           6e-06,    8.079092e+10,    0,                   0}, //   86NB
{   41,   86,       49.800005,        98.10326,    0,                   0}, //   86NB
{   41,   87,            3.84,    2.250604e+11,    0,                   0}, //   87NB
{   41,   87,             334,        40.39546,    0,                   0}, //   87NB
{   41,   88,           4e-06,      6.7345e+11,    0,                   0}, //   88NB
{   41,   89,              35,    5.713072e+12,    0,                   0}, //   89NB
{   41,   89,          2192.9,        19.90919,    0,                   0}, //   89NB
{   41,   90,          122.37,        90889.79,   12,          1.8786e-26}, //   90NB
{   41,   90,          124.67,    2.713709e+10,    0,                   0}, //   90NB
{   41,   90,           171.1,        1442.695,    0,                   0}, //   90NB
{   41,   90,          382.01,         8930282,    0,                   0}, //   90NB
{   41,   90,          1880.2,        680.9521,    0,                   0}, //   90NB
{   41,   91,           104.6,    7.586123e+15,    0,                   0}, //   91NB
{   41,   91,          104.62,    7.586123e+15,    0,                   0}, //   91NB
{   41,   91,          1984.2,        14.42695,    0,                   0}, //   91NB
{   41,   91,          2034.3,        5424.533,    0,                   0}, //   91NB
{   41,   91,          5455.4,        1.731234,    0,                   0}, //   91NB
{   41,   92,           135.5,    1.265186e+15,    0,                   0}, //   92NB
{   41,   92,           225.7,        8511.901,    0,                   0}, //   92NB
{   41,   92,           285.7,        1.586965,    0,                   0}, //   92NB
{   41,   92,          357.49,        2.755548,    0,                   0}, //   92NB
{   41,   92,           389.7,        14.42695,    0,                   0}, //   92NB
{   41,   92,             975,        14.42695,    0,                   0}, //   92NB
{   41,   92,          1089.4,        14.42695,    0,                   0}, //   92NB
{   41,   92,          1310.7,        14.42695,    0,                   0}, //   92NB
{   41,   92,          1345.6,        14.42695,    0,                   0}, //   92NB
{   41,   92,            1415,        14.42695,    0,                   0}, //   92NB
{   41,   92,          1422.6,        14.42695,    0,                   0}, //   92NB
{   41,   92,          1553.8,        14.42695,    0,                   0}, //   92NB
{   41,   92,          1945.3,         8.65617,    0,                   0}, //   92NB
{   41,   92,          2087.5,         8.65617,    0,                   0}, //   92NB
{   41,   92,          2203.3,        240.9301,    0,                   0}, //   92NB
{   41,   92,          2235.7,         8.65617,    0,                   0}, //   92NB
{   41,   92,          2287.1,         8.65617,    0,                   0}, //   92NB
{   41,   92,          2998.2,         8.65617,    0,                   0}, //   92NB
{   41,   92,          3325.9,         8.65617,    0,                   0}, //   92NB
{   41,   92,          3796.9,         8.65617,    0,                   0}, //   92NB
{   41,   93,           30.77,    7.339134e+17,    0,                   0}, //   93NB
{   41,   93,            1335,        20.19773,    0,                   0}, //   93NB
{   41,   93,            1491,        20.19773,    0,                   0}, //   93NB
{   41,   93,     7435.300004,        2164.043,    0,                   0}, //   93NB
{   41,   94,          40.892,    5.421359e+11,    0,                   0}, //   94NB
{   41,   94,           113.4,        7.213475,    0,                   0}, //   94NB
{   41,   94,           140.3,        43.28085,    0,                   0}, //   94NB
{   41,   94,          396.23,        7.213475,    0,                   0}, //   94NB
{   41,   95,          235.69,    4.499766e+14,    0,                   0}, //   95NB
{   41,   96,          634.96,        2.019773,    0,                   0}, //   96NB
{   41,   96,          694.62,        2.019773,    0,                   0}, //   96NB
{   41,   97,          743.35,     8.46862e+10,    0,                   0}, //   97NB
{   41,   98,              84,    4.440615e+12,    0,                   0}, //   98NB
{   41,   99,          365.27,    2.164043e+11,    0,                   0}, //   99NB
{   41,   99,          1974.5,        7.213475,    0,                   0}, //   99NB
{   41,  100,       34.300004,        663.6397,    0,                   0}, //  100NB
{   41,  100,             314,    4.313658e+09,    0,                   0}, //  100NB
{   41,  100,      420.700004,        18755.04,    0,                   0}, //  100NB
{   41,  101,          205.28,        2.640132,    0,                   0}, //  101NB
{   41,  102,           4e-06,    1.875504e+09,    0,                   0}, //  102NB
{   41,  103,          163.97,        7.357745,    0,                   0}, //  103NB
{   41,  103,          247.72,        1.803369,    0,                   0}, //  103NB
{   41,  104,             215,    1.356133e+09,    0,                   0}, //  104NB
{   42,   89,           387.3,    2.741121e+08,    0,                   0}, //   89MO
{   42,   89,           387.5,    2.741121e+08,    0,                   0}, //   89MO
{   42,   89,          2271.2,        1.644672,    0,                   0}, //   89MO
{   42,   89,          2583.7,        13.69118,    0,                   0}, //   89MO
{   42,   90,          2874.7,        1615.818,   16,        -7.02455e-27}, //   90MO
{   42,   91,           652.9,     9.31981e+10,    0,                   0}, //   91MO
{   42,   91,          653.01,     9.31981e+10,    0,                   0}, //   91MO
{   42,   91,          2267.4,        67.80667,    0,                   0}, //   91MO
{   42,   91,          2279.6,        54.82241,    0,                   0}, //   91MO
{   42,   92,          2526.9,        2.236177,    0,                   0}, //   92MO
{   42,   92,          2612.3,        2.207323,    0,                   0}, //   92MO
{   42,   92,          2760.5,        274.1121,   16,          5.7065e-26}, //   92MO
{   42,   92,          4486.2,        12.65244,    0,                   0}, //   92MO
{   42,   93,          2424.9,    3.557686e+13,   21,         5.01465e-26}, //   93MO
{   42,   93,            2425,    3.557686e+13,    0,                   0}, //   93MO
{   42,   93,          2429.8,        5.092713,    0,                   0}, //   93MO
{   42,   93,     9670.000004,        1586.965,    0,                   0}, //   93MO
{   42,   94,          2955.6,        141.3841,   16,          5.2823e-26}, //   94MO
{   42,   95,          1318.2,        9.954596,    0,                   0}, //   95MO
{   42,   95,          1369.8,        9.954596,    0,                   0}, //   95MO
{   42,   95,            1426,        9.954596,    0,                   0}, //   95MO
{   42,   95,            1440,        9.954596,    0,                   0}, //   95MO
{   42,   95,          1540.8,        9.954596,    0,                   0}, //   95MO
{   42,   95,          1551.8,        9.954596,    0,                   0}, //   95MO
{   42,   95,          1742.9,        9.954596,    0,                   0}, //   95MO
{   42,   95,          1796.3,        9.954596,    0,                   0}, //   95MO
{   42,   95,            1808,        9.954596,    0,                   0}, //   95MO
{   42,   95,          1888.5,        9.954596,    0,                   0}, //   95MO
{   42,   95,          1937.5,        9.954596,    0,                   0}, //   95MO
{   42,   95,          2058.5,        9.954596,    0,                   0}, //   95MO
{   42,   95,          2232.3,        9.954596,    0,                   0}, //   95MO
{   42,   95,          2580.1,        9.954596,    0,                   0}, //   95MO
{   42,   95,          2611.1,        9.954596,    0,                   0}, //   95MO
{   42,   95,          2732.1,        9.954596,    0,                   0}, //   95MO
{   42,   97,          1321.5,        10.09887,    0,                   0}, //   97MO
{   42,   97,          1409.5,        10.09887,    0,                   0}, //   97MO
{   42,   97,          1436.9,        3.606738,    0,                   0}, //   97MO
{   42,   97,          1544.9,        10.09887,    0,                   0}, //   97MO
{   42,   97,          1565.6,        10.09887,    0,                   0}, //   97MO
{   42,   97,          1629.9,        10.09887,    0,                   0}, //   97MO
{   42,   97,            1783,        10.09887,    0,                   0}, //   97MO
{   42,   97,            1921,        10.09887,    0,                   0}, //   97MO
{   42,   97,          1939.9,        10.09887,    0,                   0}, //   97MO
{   42,   98,          734.75,        31.45075,    0,                   0}, //   98MO
{   42,   99,          97.785,        22361.77,    5,        -3.91375e-27}, //   99MO
{   42,   99,           684.1,        1096.448,    0,                   0}, //   99MO
{   42,   99,          3010.2,        11.54156,    0,                   0}, //   99MO
{   42,  100,          695.11,        2.337166,    0,                   0}, //  100MO
{   42,  101,          13.497,        326.0491,    0,                   0}, //  101MO
{   42,  101,          57.015,        191.8784,    0,                   0}, //  101MO
{   42,  101,             273,         137.056,    0,                   0}, //  101MO
{   42,  103,          353.74,        1.731234,    0,                   0}, //  103MO
{   42,  106,          171.55,        1.803369,    4,           2.121e-27}, //  106MO
{   42,  107,            65.4,        605.9319,    0,                   0}, //  107MO
{   43,   86,     1445.000004,        1601.391,    0,                   0}, //   86TC
{   43,   86,            1524,        1586.965,    0,                   0}, //   86TC
{   43,   88,           4e-06,    9.233248e+09,    0,                   0}, //   88TC
{   43,   88,           5e-06,    8.367631e+09,    0,                   0}, //   88TC
{   43,   89,            62.6,    1.861077e+10,    0,                   0}, //   89TC
{   43,   90,           5e-06,    1.255145e+10,    0,                   0}, //   90TC
{   43,   90,      500.000005,     7.09806e+10,    0,                   0}, //   90TC
{   43,   91,           139.3,    2.856536e+11,    0,                   0}, //   91TC
{   43,   91,          2137.2,        2.668986,    0,                   0}, //   91TC
{   43,   91,            2153,        1.543684,    0,                   0}, //   91TC
{   43,   92,          270.15,        1485.976,    0,                   0}, //   92TC
{   43,   92,          529.47,        144.2695,    0,                   0}, //   92TC
{   43,   92,          576.93,         2.88539,    0,                   0}, //   92TC
{   43,   92,          711.39,        144.2695,    0,                   0}, //   92TC
{   43,   92,          2002.7,        4.544489,    0,                   0}, //   92TC
{   43,   93,          391.83,    3.765434e+12,    0,                   0}, //   93TC
{   43,   93,          391.84,    3.765434e+12,    0,                   0}, //   93TC
{   43,   93,          680.59,        50.49433,    0,                   0}, //   93TC
{   43,   93,          1194.1,        50.49433,    0,                   0}, //   93TC
{   43,   93,          1407.8,        50.49433,    0,                   0}, //   93TC
{   43,   93,          1434.4,        14.42695,    0,                   0}, //   93TC
{   43,   93,          2185.2,        14715.49,    0,                   0}, //   93TC
{   43,   93,          2535.3,        2.077481,    0,                   0}, //   93TC
{   43,   94,              76,    4.501209e+12,    0,                   0}, //   94TC
{   43,   94,           103.4,        7.213475,    0,                   0}, //   94TC
{   43,   94,           212.4,        7.213475,    0,                   0}, //   94TC
{   43,   94,             336,        2.164043,    0,                   0}, //   94TC
{   43,   94,          2347.1,        6.492128,    0,                   0}, //   94TC
{   43,   95,            38.9,     7.60358e+15,    0,                   0}, //   95TC
{   43,   95,           38.91,     7.60358e+15,    0,                   0}, //   95TC
{   43,   95,          1515.2,        7.213475,    0,                   0}, //   95TC
{   43,   96,            34.2,    4.457928e+12,    0,                   0}, //   96TC
{   43,   96,           34.23,    4.457928e+12,    0,                   0}, //   96TC
{   43,   96,          121.24,        36.93299,    0,                   0}, //   96TC
{   43,   96,           316.6,         2.88539,    0,                   0}, //   96TC
{   43,   97,            96.5,    1.134305e+16,    0,                   0}, //   97TC
{   43,   97,           96.57,    1.134305e+16,    0,                   0}, //   97TC
{   43,   98,            21.8,        3.462468,    0,                   0}, //   98TC
{   43,   98,           65.43,        2.019773,    0,                   0}, //   98TC
{   43,   98,           81.68,        2.019773,    0,                   0}, //   98TC
{   43,   98,           90.76,        21207.62,    0,                   0}, //   98TC
{   43,   98,          138.55,         11.8301,    0,                   0}, //   98TC
{   43,   98,          152.09,        2.019773,    0,                   0}, //   98TC
{   43,   98,          190.21,        2.019773,    0,                   0}, //   98TC
{   43,   98,          203.67,        2.019773,    0,                   0}, //   98TC
{   43,   99,          142.68,    3.119684e+13,    0,                   0}, //   99TC
{   43,   99,          181.09,        5.208129,    5,          1.7574e-26}, //   99TC
{   43,  100,          172.15,        4.328085,    0,                   0}, //  100TC
{   43,  100,          200.67,        12003.22,    0,                   0}, //  100TC
{   43,  100,          223.47,        4.328085,    0,                   0}, //  100TC
{   43,  100,          243.95,        4616.624,    0,                   0}, //  100TC
{   43,  100,          263.56,        4.328085,    0,                   0}, //  100TC
{   43,  100,          287.52,        4.328085,    0,                   0}, //  100TC
{   43,  100,          299.66,        4.328085,    0,                   0}, //  100TC
{   43,  100,          335.17,        4.328085,    0,                   0}, //  100TC
{   43,  100,          355.58,        4.328085,    0,                   0}, //  100TC
{   43,  101,            9.32,        20.63054,    0,                   0}, //  101TC
{   43,  101,          15.602,        38.66423,    0,                   0}, //  101TC
{   43,  101,          207.53,          917554,    0,                   0}, //  101TC
{   43,  102,           4e-06,    3.765434e+11,    0,                   0}, //  102TC
{   43,  104,            69.7,        5049.433,    0,                   0}, //  104TC
{   43,  104,           106.1,         577.078,    0,                   0}, //  104TC
{   43,  105,           85.43,        30.00806,    0,                   0}, //  105TC
{   43,  105,          149.61,        1.572538,    0,                   0}, //  105TC
{   43,  105,          303.76,        9.810326,    0,                   0}, //  105TC
{   43,  105,          322.17,        14.28268,    0,                   0}, //  105TC
{   43,  106,           77.35,        10.09887,    0,                   0}, //  106TC
{   43,  107,            30.1,        5554.376,    0,                   0}, //  107TC
{   43,  107,           65.72,        265.4559,    0,                   0}, //  107TC
{   43,  108,      176.600004,        40.39546,    0,                   0}, //  108TC
{   43,  110,          142.05,        14.42695,    0,                   0}, //  110TC
{   43,  114,           4e-06,    1.442695e+08,    0,                   0}, //  114TC
{   43,  114,           5e-06,    1.298426e+08,    0,                   0}, //  114TC
{   44,   91,           4e-06,    1.096448e+10,    0,                   0}, //   91RU
{   44,   92,          2535.2,        23.08312,    0,                   0}, //   92RU
{   44,   92,          2833.9,        144.2695,    0,                   0}, //   92RU
{   44,   93,           734.4,    1.558111e+10,    0,                   0}, //   93RU
{   44,   93,          2082.5,        3592.311,    0,                   0}, //   93RU
{   44,   93,          2280.5,        50.49433,    0,                   0}, //   93RU
{   44,   94,            2498,        93.77518,    0,                   0}, //   94RU
{   44,   94,          2644.1,        102431.3,    0,                   0}, //   94RU
{   44,   95,            2284,         4.40022,    0,                   0}, //   95RU
{   44,   95,            2538,        14.49909,   21,         4.63085e-26}, //   95RU
{   44,   97,          2739.1,        11.25302,    0,                   0}, //   97RU
{   44,   99,           89.57,        29.57525,    3,         -1.4342e-27}, //   99RU
{   44,   99,          618.13,        1.500403,    0,                   0}, //   99RU
{   44,   99,          1069.9,        4.039546,    0,                   0}, //   99RU
{   44,  101,           527.3,        25247.16,    0,                   0}, //  101RU
{   44,  101,          527.56,        25247.16,    0,                   0}, //  101RU
{   44,  103,          213.56,        21.64043,    0,                   0}, //  103RU
{   44,  103,           238.2,         2438155,    0,                   0}, //  103RU
{   44,  105,           20.61,        490.5163,    0,                   0}, //  105RU
{   44,  105,          159.52,        79.34823,    0,                   0}, //  105RU
{   44,  105,          163.81,        79.34823,    0,                   0}, //  105RU
{   44,  107,          102.68,        15.58111,    0,                   0}, //  107RU
{   44,  107,          106.31,        48.18601,    0,                   0}, //  107RU
{   44,  109,            96.2,        981.0326,    0,                   0}, //  109RU
{   44,  109,           137.9,        2.077481,    0,                   0}, //  109RU
{   44,  111,          253.97,        20.19773,    0,                   0}, //  111RU
{   44,  111,          316.79,        7.213475,    0,                   0}, //  111RU
{   44,  111,           368.8,         10.3874,    0,                   0}, //  111RU
{   44,  113,           4e-06,    7.357745e+08,    0,                   0}, //  113RU
{   44,  113,             130,    7.357745e+08,    0,                   0}, //  113RU
{   45,   94,           4e-06,    3.722153e+10,    0,                   0}, //   94RH
{   45,   94,            54.6,        692.4936,    0,                   0}, //   94RH
{   45,   95,           543.3,    1.696609e+11,    0,                   0}, //   95RH
{   45,   95,          2236.4,        27.12267,    0,                   0}, //   95RH
{   45,   95,          2449.1,        3.664445,    0,                   0}, //   95RH
{   45,   96,           51.98,    1.307082e+11,    0,                   0}, //   96RH
{   45,   96,              52,    1.307082e+11,    0,                   0}, //   96RH
{   45,   97,          258.76,    3.999151e+12,    0,                   0}, //   97RH
{   45,   98,           4e-06,    3.116221e+11,    0,                   0}, //   98RH
{   45,   99,            64.6,     2.44104e+13,    9,         2.86234e-26}, //   99RH
{   45,  100,          32.696,        39.81838,    0,                   0}, //  100RH
{   45,  100,          74.782,        308.7367,    0,                   0}, //  100RH
{   45,  100,           107.6,    3.981838e+11,    0,                   0}, //  100RH
{   45,  100,          160.69,        5.698645,    0,                   0}, //  100RH
{   45,  100,          219.61,        187.5504,    0,                   0}, //  100RH
{   45,  101,          157.32,    5.409818e+14,    9,         2.74215e-26}, //  101RH
{   45,  101,          181.78,        2.755548,    0,                   0}, //  101RH
{   45,  102,           41.94,        27.26694,    0,                   0}, //  102RH
{   45,  102,           140.7,    1.703679e+17,    0,                   0}, //  102RH
{   45,  102,          140.73,    1.703679e+17,    0,                   0}, //  102RH
{   45,  102,          178.68,        1.500403,    0,                   0}, //  102RH
{   45,  103,          39.753,    4.857266e+12,    7,          2.2927e-26}, //  103RH
{   45,  103,          39.754,    4.857266e+12,    0,                   0}, //  103RH
{   45,  103,          93.036,        1.601391,    9,          2.4745e-26}, //  103RH
{   45,  104,          51.423,        3.751007,    0,                   0}, //  104RH
{   45,  104,          128.97,    3.756778e+11,    0,                   0}, //  104RH
{   45,  104,          213.06,        1.731234,    0,                   0}, //  104RH
{   45,  104,          344.59,        67.80667,   12,            1.01e-26}, //  104RH
{   45,  104,          394.76,        4.328085,    0,                   0}, //  104RH
{   45,  104,          404.51,        1.731234,    0,                   0}, //  104RH
{   45,  104,          514.52,        5.193702,    0,                   0}, //  104RH
{   45,  104,           524.7,        1.731234,    0,                   0}, //  104RH
{   45,  104,          644.72,        1.731234,    0,                   0}, //  104RH
{   45,  104,          695.79,        2.019773,    0,                   0}, //  104RH
{   45,  104,          711.07,        4.183816,    0,                   0}, //  104RH
{   45,  104,          826.73,        4.183816,    0,                   0}, //  104RH
{   45,  104,          888.66,        7.213475,    0,                   0}, //  104RH
{   45,  104,          915.65,        1.731234,    0,                   0}, //  104RH
{   45,  105,          129.57,     5.77078e+10,    0,                   0}, //  105RH
{   45,  105,          129.78,    6.189162e+10,    0,                   0}, //  105RH
{   45,  106,             137,    1.133958e+13,    0,                   0}, //  106RH
{   45,  107,          268.36,        14426.95,    0,                   0}, //  107RH
{   45,  107,          374.28,        21.64043,    0,                   0}, //  107RH
{   45,  108,           4e-06,    5.193702e+11,    0,                   0}, //  108RH
{   45,  109,          225.97,        2394.874,    0,                   0}, //  109RH
{   45,  109,          257.77,        41.40535,    0,                   0}, //  109RH
{   45,  109,          374.09,        47.60894,    0,                   0}, //  109RH
{   45,  110,           5e-06,    4.039546e+10,    0,                   0}, //  110RH
{   45,  111,          394.95,        125.5145,    0,                   0}, //  111RH
{   45,  111,          440.42,        6.924936,    0,                   0}, //  111RH
{   45,  111,          492.73,        9.810326,    0,                   0}, //  111RH
{   45,  112,           4e-06,     3.02966e+09,    0,                   0}, //  112RH
{   45,  112,           5e-06,    9.810326e+09,    0,                   0}, //  112RH
{   45,  114,           4e-06,    2.668986e+09,    0,                   0}, //  114RH
{   45,  116,             150,    8.223362e+08,    0,                   0}, //  116RH
{   46,   94,          4883.1,        764.6284,    0,                   0}, //   94PD
{   46,   95,          1875.1,    1.918784e+10,    0,                   0}, //   95PD
{   46,   95,          1875.2,    1.918784e+10,    0,                   0}, //   95PD
{   46,   95,          4330.9,        17.31234,    0,                   0}, //   95PD
{   46,   96,          2424.2,        10.82021,    0,                   0}, //   96PD
{   46,   96,          2530.6,         3029.66,    0,                   0}, //   96PD
{   46,   96,            7040,        50.49433,    0,                   0}, //   96PD
{   46,   97,          2244.2,        3.318199,    0,                   0}, //   97PD
{   46,   99,          4037.5,         5.77078,    0,                   0}, //   99PD
{   46,  101,            80.3,        6.924936,    0,                   0}, //  101PD
{   46,  102,          1593.2,        20.91908,    0,                   0}, //  102PD
{   46,  102,          2294.6,        1.586965,    0,                   0}, //  102PD
{   46,  103,          784.79,        36.06738,   11,          5.3025e-27}, //  103PD
{   46,  105,          489.14,        52081.29,    0,                   0}, //  105PD
{   46,  106,          2305.6,         2.88539,    0,                   0}, //  106PD
{   46,  106,          2757.1,        5.193702,    0,                   0}, //  106PD
{   46,  106,          2951.8,         2.88539,    0,                   0}, //  106PD
{   46,  107,          115.74,        1226.291,    0,                   0}, //  107PD
{   46,  107,           214.6,     3.07294e+10,    0,                   0}, //  107PD
{   46,  109,           113.4,        548.2241,    0,                   0}, //  109PD
{   46,  109,           188.9,    4.059744e+11,    0,                   0}, //  109PD
{   46,  109,          188.99,    4.064938e+11,    0,                   0}, //  109PD
{   46,  111,          172.18,    2.856536e+13,    0,                   0}, //  111PD
{   46,  111,           172.2,    2.856536e+13,    0,                   0}, //  111PD
{   46,  113,            81.1,    4.328085e+08,    0,                   0}, //  113PD
{   46,  113,            81.3,    4.328085e+08,    0,                   0}, //  113PD
{   46,  115,           89.18,    7.213475e+10,    0,                   0}, //  115PD
{   46,  115,            89.3,    7.213475e+10,    0,                   0}, //  115PD
{   46,  117,           203.2,    2.755548e+07,    0,                   0}, //  117PD
{   46,  117,           203.3,    2.755548e+07,    0,                   0}, //  117PD
{   47,   94,           4e-06,    7.934823e+08,    0,                   0}, //   94AG
{   47,   94,            6670,     5.77078e+08,    0,                   0}, //   94AG
{   47,   95,           344.2,    7.213475e+08,    0,                   0}, //   95AG
{   47,   95,          2531.3,    2.308312e+07,    0,                   0}, //   95AG
{   47,   95,            4860,     5.77078e+07,    0,                   0}, //   95AG
{   47,   96,           4e-06,    6.347858e+09,    0,                   0}, //   96AG
{   47,   96,           5e-06,    9.954596e+09,    0,                   0}, //   96AG
{   47,   96,           6e-06,        1009.887,    0,                   0}, //   96AG
{   47,   97,          2343.3,        2.596851,    0,                   0}, //   97AG
{   47,   97,          6481.4,        5.337972,    0,                   0}, //   97AG
{   47,   99,           506.2,     1.51483e+10,    0,                   0}, //   99AG
{   47,  100,           15.52,    1.938982e+11,    0,                   0}, //  100AG
{   47,  101,           274.1,    4.472355e+09,    0,                   0}, //  101AG
{   47,  101,           274.3,    4.472355e+09,    0,                   0}, //  101AG
{   47,  102,             9.3,    6.665251e+11,    0,                   0}, //  102AG
{   47,  102,             9.4,    6.665251e+11,    4,          2.0907e-26}, //  102AG
{   47,  102,             141,        5.049433,    0,                   0}, //  102AG
{   47,  102,            2117,        4.039546,    0,                   0}, //  102AG
{   47,  103,           134.4,    8.223362e+09,    0,                   0}, //  103AG
{   47,  103,          134.45,    8.223362e+09,    0,                   0}, //  103AG
{   47,  104,             6.9,    2.899817e+12,    4,          1.8685e-26}, //  104AG
{   47,  104,             212,        2.019773,    0,                   0}, //  104AG
{   47,  105,          25.479,    6.258411e+11,    7,         2.22907e-26}, //  105AG
{   47,  105,           25.48,    6.258411e+11,    0,                   0}, //  105AG
{   47,  105,           53.15,        3.361479,    0,                   0}, //  105AG
{   47,  105,          1733.9,        8.079092,   15,         1.88365e-26}, //  105AG
{   47,  106,           89.66,     1.03209e+15,    0,                   0}, //  106AG
{   47,  107,          93.125,    6.391139e+10,    0,                   0}, //  107AG
{   47,  107,          125.59,        4.111681,    0,                   0}, //  107AG
{   47,  107,          773.31,        21.64043,    0,                   0}, //  107AG
{   47,  107,             991,        21.64043,    0,                   0}, //  107AG
{   47,  108,           79.14,        1.731234,    0,                   0}, //  108AG
{   47,  108,          109.47,    1.994093e+19,   12,          1.8079e-26}, //  108AG
{   47,  108,          215.38,        66.07543,    6,         1.96344e-26}, //  108AG
{   47,  109,          88.034,    5.713072e+10,    0,                   0}, //  109AG
{   47,  109,          132.74,        3.751007,    0,                   0}, //  109AG
{   47,  109,          724.35,        4.616624,    0,                   0}, //  109AG
{   47,  110,           1.112,        952.1787,    0,                   0}, //  110AG
{   47,  110,          117.59,    3.114057e+16,   12,         1.81194e-26}, //  110AG
{   47,  110,          118.72,        52.80264,    6,         1.91395e-26}, //  110AG
{   47,  110,          767.01,        1.875504,    0,                   0}, //  110AG
{   47,  110,             820,        1.586965,    0,                   0}, //  110AG
{   47,  110,           953.2,         2.88539,    0,                   0}, //  110AG
{   47,  110,            1104,        1.731234,    0,                   0}, //  110AG
{   47,  111,           59.82,    9.348664e+10,    0,                   0}, //  111AG
{   47,  111,          130.28,        1.760088,    0,                   0}, //  111AG
{   47,  111,          376.71,        23.08312,    0,                   0}, //  111AG
{   47,  113,            43.5,    9.911315e+10,    0,                   0}, //  113AG
{   47,  113,            43.6,    9.911315e+10,    0,                   0}, //  113AG
{   47,  113,          222.08,        33.18199,    0,                   0}, //  113AG
{   47,  113,          273.59,        43.28085,    0,                   0}, //  113AG
{   47,  114,             199,         2164043,    0,                   0}, //  114AG
{   47,  115,            41.1,    2.596851e+10,    0,                   0}, //  115AG
{   47,  115,           41.16,    2.596851e+10,    0,                   0}, //  115AG
{   47,  115,          303.84,        7.502014,    0,                   0}, //  115AG
{   47,  115,          414.11,        2.308312,    0,                   0}, //  115AG
{   47,  116,            47.9,     2.88539e+10,    0,                   0}, //  116AG
{   47,  116,           129.8,    1.341706e+10,    0,                   0}, //  116AG
{   47,  117,            28.6,    7.703992e+09,    0,                   0}, //  117AG
{   47,  118,           45.79,        144.2695,    0,                   0}, //  118AG
{   47,  118,          127.63,     2.88539e+09,    0,                   0}, //  118AG
{   47,  118,          127.74,     2.88539e+09,    0,                   0}, //  118AG
{   47,  118,          279.37,        144.2695,    0,                   0}, //  118AG
{   47,  119,           4e-06,     3.02966e+09,    0,                   0}, //  119AG
{   47,  119,           5e-06,     8.65617e+09,    0,                   0}, //  119AG
{   47,  120,             203,    4.616624e+08,    0,                   0}, //  120AG
{   47,  122,           4e-06,    7.934823e+08,    0,                   0}, //  122AG
{   47,  122,              80,     2.88539e+08,    0,                   0}, //  122AG
{   47,  129,           4e-06,    2.308312e+08,    0,                   0}, //  129AG
{   48,   98,          2427.5,        692.4936,    0,                   0}, //   98CD
{   48,   99,          2057.5,        18.89931,    0,                   0}, //   99CD
{   48,  100,          2548.2,         86.5617,    0,                   0}, //  100CD
{   48,  101,          2284.8,        6.636397,    0,                   0}, //  101CD
{   48,  102,          2718.6,        56.26511,    0,                   0}, //  102CD
{   48,  103,          2452.2,        1.875504,    0,                   0}, //  103CD
{   48,  105,          131.11,        2.524716,    0,                   0}, //  105CD
{   48,  106,          3507.8,        2.164043,    0,                   0}, //  106CD
{   48,  106,          4659.7,        89.44709,    0,                   0}, //  106CD
{   48,  106,          7118.9,        15.86965,    0,                   0}, //  106CD
{   48,  107,          845.54,        102.4313,   11,        -5.25705e-27}, //  107CD
{   48,  107,          2678.9,        79.34823,   21,          4.5955e-26}, //  107CD
{   48,  109,           59.49,        17312.34,    0,                   0}, //  109CD
{   48,  109,            59.9,        17312.34,    0,                   0}, //  109CD
{   48,  109,           463.5,        15725.38,   11,         -5.5348e-27}, //  109CD
{   48,  109,          2866.9,        1.817796,    0,                   0}, //  109CD
{   48,  110,          3055.7,        3.260491,    0,                   0}, //  110CD
{   48,  111,          245.39,        121.9077,    5,        -3.86628e-27}, //  111CD
{   48,  111,          396.21,    4.198243e+12,   11,       -5.580755e-27}, //  111CD
{   48,  111,          396.22,    4.201705e+12,    0,                   0}, //  111CD
{   48,  112,          1433.2,        2.741121,    0,                   0}, //  112CD
{   48,  113,          263.54,    6.419416e+17,    0,                   0}, //  113CD
{   48,  113,           263.7,    6.419416e+17,    0,                   0}, //  113CD
{   48,  113,          316.21,        15.58111,    0,                   0}, //  113CD
{   48,  114,          1305.6,        6.780667,    0,                   0}, //  114CD
{   48,  115,             181,    5.554376e+15,    0,                   0}, //  115CD
{   48,  117,           136.4,    1.745084e+13,    0,                   0}, //  117CD
{   48,  117,           293.5,        5.193702,    0,                   0}, //  117CD
{   48,  119,              27,        3.318199,    0,                   0}, //  119CD
{   48,  119,          146.54,    1.904357e+11,    0,                   0}, //  119CD
{   48,  119,          213.91,        2.164043,    0,                   0}, //  119CD
{   48,  119,          228.27,        62.03589,    0,                   0}, //  119CD
{   48,  119,          427.28,        2.308312,    0,                   0}, //  119CD
{   48,  121,          214.86,    1.197437e+10,    0,                   0}, //  121CD
{   48,  121,           314.5,        27.41121,    0,                   0}, //  121CD
{   48,  121,          329.92,         2.88539,    0,                   0}, //  121CD
{   48,  121,          508.39,         2.88539,    0,                   0}, //  121CD
{   48,  123,          263.87,        115.4156,    0,                   0}, //  123CD
{   48,  123,          316.53,    2.625705e+09,    0,                   0}, //  123CD
{   48,  125,           4e-06,    6.924936e+08,    0,                   0}, //  125CD
{   48,  130,            2130,        317.3929,    0,                   0}, //  130CD
{   49,   98,           4e-06,    4.616624e+07,    0,                   0}, //   98IN
{   49,   98,           5e-06,    1.731234e+09,    0,                   0}, //   98IN
{   49,  103,           631.7,    4.905163e+10,    0,                   0}, //  103IN
{   49,  104,           93.48,    2.265031e+10,    0,                   0}, //  104IN
{   49,  105,          674.08,    6.924936e+10,    0,                   0}, //  105IN
{   49,  105,           674.1,    6.924936e+10,    0,                   0}, //  105IN
{   49,  106,            28.6,    4.501209e+11,    0,                   0}, //  106IN
{   49,  107,           678.5,    7.271183e+10,    0,                   0}, //  107IN
{   49,  107,          1853.6,        2.452582,    0,                   0}, //  107IN
{   49,  108,           29.75,    3.427843e+12,    4,        2.492175e-26}, //  108IN
{   49,  109,           650.1,    1.159927e+11,    0,                   0}, //  109IN
{   49,  109,          2101.8,    3.015233e+08,    0,                   0}, //  109IN
{   49,  110,           62.08,    5.981414e+12,    4,        2.204325e-26}, //  110IN
{   49,  111,          536.99,    6.665251e+11,    0,                   0}, //  111IN
{   49,  111,             537,    6.665251e+11,    0,                   0}, //  111IN
{   49,  111,          2716.8,        19.76492,   21,         2.66135e-26}, //  111IN
{   49,  112,           156.4,    1.779709e+12,    0,                   0}, //  112IN
{   49,  112,          156.59,    1.779709e+12,    8,        2.664885e-26}, //  112IN
{   49,  112,          350.76,        995.4596,   14,        2.386125e-26}, //  112IN
{   49,  112,          613.69,        4053.973,   16,          1.5554e-26}, //  112IN
{   49,  113,          391.69,     8.61087e+12,    0,                   0}, //  113IN
{   49,  113,           391.7,     8.61087e+12,    1,       -1.064237e-27}, //  113IN
{   49,  114,          190.27,    6.171417e+15,   10,        2.349765e-26}, //  114IN
{   49,  114,          501.95,    6.218016e+07,    0,                   0}, //  114IN
{   49,  114,          641.75,        6.203589,    0,                   0}, //  114IN
{   49,  115,          336.24,    2.329952e+13,    1,       -1.232099e-27}, //  115IN
{   49,  115,          828.59,        8.338777,    3,           3.737e-27}, //  115IN
{   49,  116,          127.27,    4.699435e+12,   10,        2.239675e-26}, //  116IN
{   49,  116,          289.66,    3.145075e+09,   16,        1.623575e-26}, //  116IN
{   49,  117,           315.3,    1.005847e+13,    1,       -1.271287e-27}, //  117IN
{   49,  117,          659.76,        77.32845,    3,          4.7369e-27}, //  117IN
{   49,  117,          749.49,        6.823948,    0,                   0}, //  117IN
{   49,  118,              60,    3.851996e+11,   10,        2.136655e-26}, //  118IN
{   49,  118,             200,    1.226291e+10,   16,        1.677105e-26}, //  118IN
{   49,  119,          311.37,    1.558111e+12,    1,        -1.61095e-27}, //  119IN
{   49,  119,          654.27,        187.5504,    0,                   0}, //  119IN
{   49,  119,          788.26,         2.88539,    0,                   0}, //  119IN
{   49,  119,          2656.9,        346.2468,    0,                   0}, //  119IN
{   49,  120,           4e-06,    6.823948e+10,    0,                   0}, //  120IN
{   49,  120,              70,    6.665251e+10,    0,                   0}, //  120IN
{   49,  121,           313.6,    3.358594e+11,    0,                   0}, //  121IN
{   49,  121,          313.68,    3.358594e+11,    1,        -1.79275e-27}, //  121IN
{   49,  121,          987.17,        7.934823,    0,                   0}, //  121IN
{   49,  121,          1197.3,         2.88539,    0,                   0}, //  121IN
{   49,  121,     2447.000005,        504.9433,    0,                   0}, //  121IN
{   49,  122,              40,    1.485976e+10,   10,         2.18059e-26}, //  122IN
{   49,  122,             290,    1.558111e+10,    0,                   0}, //  122IN
{   49,  123,          327.21,    6.838374e+10,    0,                   0}, //  123IN
{   49,  124,              50,    5.337972e+09,    0,                   0}, //  124IN
{   49,  124,          242.68,        72.13475,    0,                   0}, //  124IN
{   49,  125,          360.12,    1.760088e+10,    0,                   0}, //  125IN
{   49,  125,          2009.4,        13561.33,    0,                   0}, //  125IN
{   49,  125,          2161.2,         7213475,    0,                   0}, //  125IN
{   49,  126,             102,     2.36602e+09,    0,                   0}, //  126IN
{   49,  127,           408.9,    5.294691e+09,    0,                   0}, //  127IN
{   49,  127,            1863,    1.500403e+09,    0,                   0}, //  127IN
{   49,  127,            2364,        12984.26,    0,                   0}, //  127IN
{   49,  128,             340,     1.03874e+09,    0,                   0}, //  128IN
{   49,  129,             380,    1.774515e+09,    0,                   0}, //  129IN
{   49,  130,              50,    7.790553e+08,    0,                   0}, //  130IN
{   49,  130,           388.3,        4472.355,    0,                   0}, //  130IN
{   49,  130,           388.8,        4472.355,    0,                   0}, //  130IN
{   49,  130,             400,    7.790553e+08,    0,                   0}, //  130IN
{   49,  131,             302,    5.049433e+08,    0,                   0}, //  131IN
{   49,  131,            3764,    4.616624e+08,    0,                   0}, //  131IN
{   49,  133,             330,    2.596851e+08,    0,                   0}, //  133IN
{   50,  102,     1969.000005,        1154.156,    0,                   0}, //  102SN
{   50,  104,          2257.2,        2.164043,    0,                   0}, //  104SN
{   50,  106,            2325,        3.751007,    0,                   0}, //  106SN
{   50,  108,          2364.5,        10.53167,   12,          -1.212e-27}, //  108SN
{   50,  109,          1257.3,         2.88539,    0,                   0}, //  109SN
{   50,  109,          1269.3,         2.88539,    0,                   0}, //  109SN
{   50,  109,          2115.4,        10.09887,    0,                   0}, //  109SN
{   50,  110,          2477.7,        8.079092,   12,           3.636e-28}, //  110SN
{   50,  110,          3765.8,        1.673526,    0,                   0}, //  110SN
{   50,  111,          254.71,        18033.69,    0,                   0}, //  111SN
{   50,  111,           978.6,        14.42695,   11,          -6.363e-27}, //  111SN
{   50,  111,          2257.4,         5.77078,    0,                   0}, //  111SN
{   50,  112,          2549.3,        19.76492,   12,          2.6967e-27}, //  112SN
{   50,  113,              77,     1.85242e+12,    0,                   0}, //  113SN
{   50,  113,          77.389,     1.85242e+12,    0,                   0}, //  113SN
{   50,  113,           738.4,        124.0718,   11,        -6.52965e-27}, //  113SN
{   50,  114,          3087.4,        1057.495,   14,        -2.86335e-27}, //  114SN
{   50,  115,          612.81,        4703.186,    7,         3.44915e-27}, //  115SN
{   50,  115,          713.64,        229388.5,   11,         -6.9589e-27}, //  115SN
{   50,  116,            2366,        502.0579,   10,         -1.8988e-27}, //  116SN
{   50,  116,          3547.2,        1201.765,   20,        -1.17463e-26}, //  116SN
{   50,  117,          314.58,    1.745084e+15,   11,         -7.0195e-27}, //  117SN
{   50,  117,          2406.4,        2524.716,    0,                   0}, //  117SN
{   50,  118,          2321.2,        31.30648,   10,          -1.515e-27}, //  118SN
{   50,  118,          2574.9,        331.8199,   14,        -3.47945e-27}, //  118SN
{   50,  118,          3108.1,        3635.592,    0,                   0}, //  118SN
{   50,  119,          23.871,        26.01179,    3,         3.19665e-27}, //  119SN
{   50,  119,          89.531,    3.653481e+16,   11,           -7.07e-27}, //  119SN
{   50,  119,          89.535,    3.652182e+16,    0,                   0}, //  119SN
{   50,  119,            2127,        13849.87,    0,                   0}, //  119SN
{   50,  119,          3103.3,        49.05163,    0,                   0}, //  119SN
{   50,  120,          2284.3,        8.006957,   10,          -1.414e-27}, //  120SN
{   50,  120,          2481.6,         17023.8,    0,                   0}, //  120SN
{   50,  120,          2902.2,        9031.271,    0,                   0}, //  120SN
{   50,  121,            6.29,     1.99871e+18,    0,                   0}, //  121SN
{   50,  121,            6.31,     1.99871e+18,   11,       -7.007885e-27}, //  121SN
{   50,  121,            1998,        7646.284,    0,                   0}, //  121SN
{   50,  121,            2834,        240.9301,    0,                   0}, //  121SN
{   50,  122,          2245.8,        11.39729,    0,                   0}, //  122SN
{   50,  122,            2409,        10820.21,    0,                   0}, //  122SN
{   50,  122,          2765.6,        89447.09,    0,                   0}, //  122SN
{   50,  123,            24.6,    3.467662e+12,    0,                   0}, //  123SN
{   50,  123,            1945,        10675.94,    0,                   0}, //  123SN
{   50,  123,            2153,         8656.17,    0,                   0}, //  123SN
{   50,  123,            2713,        49051.63,    0,                   0}, //  123SN
{   50,  124,          2204.6,        389.5277,    0,                   0}, //  124SN
{   50,  124,            2325,        4472.355,    0,                   0}, //  124SN
{   50,  124,          2656.6,        64921.28,    0,                   0}, //  124SN
{   50,  125,            27.5,    8.240674e+11,    3,          3.8582e-27}, //  125SN
{   50,  125,          1892.8,        8944.709,    0,                   0}, //  125SN
{   50,  125,          2059.5,         865.617,    0,                   0}, //  125SN
{   50,  125,          2623.5,        331.8199,    0,                   0}, //  125SN
{   50,  126,          2161.5,        15.58111,    0,                   0}, //  126SN
{   50,  126,            2219,        9521.787,    0,                   0}, //  126SN
{   50,  126,          2564.5,        11108.75,    0,                   0}, //  126SN
{   50,  127,            5.07,    3.574998e+11,    3,         3.82285e-27}, //  127SN
{   50,  127,          1826.7,        6520.982,    0,                   0}, //  127SN
{   50,  127,            1931,        1716.807,    0,                   0}, //  127SN
{   50,  127,          2552.4,        360.6738,    0,                   0}, //  127SN
{   50,  128,          2091.5,    9.377518e+09,    0,                   0}, //  128SN
{   50,  128,          2120.9,        12.40718,    0,                   0}, //  128SN
{   50,  128,          2412.7,         57.7078,    0,                   0}, //  128SN
{   50,  128,          2491.9,         3880.85,    0,                   0}, //  128SN
{   50,  129,            35.2,    5.972757e+11,    0,                   0}, //  129SN
{   50,  130,          1946.9,    1.471549e+11,    0,                   0}, //  130SN
{   50,  130,          2084.8,        75.02014,    0,                   0}, //  130SN
{   50,  130,          2338.3,         57.7078,    0,                   0}, //  130SN
{   50,  130,          2434.8,        2322.739,    0,                   0}, //  130SN
{   50,  131,           4e-06,    8.425339e+10,    0,                   0}, //  131SN
{   50,  131,     4557.900004,         2.88539,    0,                   0}, //  131SN
{   50,  131,     4604.900004,        432.8085,    0,                   0}, //  131SN
{   50,  132,          4416.3,        5.698645,    0,                   0}, //  132SN
{   50,  132,          4715.9,        28.99817,    0,                   0}, //  132SN
{   50,  132,            4847,        2928.671,    0,                   0}, //  132SN
{   50,  132,          4848.5,        2928.671,    0,                   0}, //  132SN
{   50,  134,          1247.4,        115.4156,    0,                   0}, //  134SN
{   51,  106,           103.5,        334.7052,    0,                   0}, //  106SB
{   51,  110,          1152.9,        34.62468,    0,                   0}, //  110SB
{   51,  112,           796.4,        807.9092,    0,                   0}, //  112SB
{   51,  113,          3044.7,        5.337972,    0,                   0}, //  113SB
{   51,  114,           45.86,        37.51007,    0,                   0}, //  114SB
{   51,  114,           54.64,        29.43098,    0,                   0}, //  114SB
{   51,  114,           83.84,         2.88539,    0,                   0}, //  114SB
{   51,  114,          173.81,         2.88539,    0,                   0}, //  114SB
{   51,  114,           495.5,        315950.2,    0,                   0}, //  114SB
{   51,  115,          1300.2,        8.944709,   11,         2.79265e-26}, //  115SB
{   51,  115,          2796.3,        229.3885,    0,                   0}, //  115SB
{   51,  115,          3659.6,         5.91505,    0,                   0}, //  115SB
{   51,  116,           93.99,        279.8828,    2,         1.24735e-26}, //  116SB
{   51,  116,             383,    5.219671e+12,    0,                   0}, //  116SB
{   51,  116,          455.18,         3.02966,    0,                   0}, //  116SB
{   51,  116,          1158.8,        15.29257,   14,         2.36845e-26}, //  116SB
{   51,  116,          1782.1,         5.77078,    0,                   0}, //  116SB
{   51,  116,            3207,        1.875504,    0,                   0}, //  116SB
{   51,  117,          1322.9,        5.482241,   11,         2.70175e-26}, //  117SB
{   51,  117,          3130.8,        512156.7,    0,                   0}, //  117SB
{   51,  117,          3230.7,        418.3816,    0,                   0}, //  117SB
{   51,  118,           31.26,        21.64043,    0,                   0}, //  118SB
{   51,  118,          50.814,        29719.52,    0,                   0}, //  118SB
{   51,  118,             250,    2.596851e+13,   16,          1.1716e-26}, //  118SB
{   51,  118,          269.82,        19.18784,    0,                   0}, //  118SB
{   51,  118,          964.88,        32.60491,    0,                   0}, //  118SB
{   51,  119,          2553.6,        187.5504,    0,                   0}, //  119SB
{   51,  119,     2841.700004,    1.226291e+09,    0,                   0}, //  119SB
{   51,  120,           4e-06,    7.179716e+14,   16,          1.1817e-26}, //  120SB
{   51,  120,           78.16,         354.903,    6,         1.30492e-26}, //  120SB
{   51,  120,     2328.300004,         577.078,    0,                   0}, //  120SB
{   51,  120,     2884.700004,        20.19773,    0,                   0}, //  120SB
{   51,  121,           37.13,        4.991725,    7,         1.27159e-26}, //  121SB
{   51,  121,          2142.2,        2.596851,    0,                   0}, //  121SB
{   51,  121,          2434.6,        11.25302,    0,                   0}, //  121SB
{   51,  121,     2721.500004,        258242.4,    0,                   0}, //  121SB
{   51,  121,          2721.6,        2.741121,    0,                   0}, //  121SB
{   51,  122,          61.413,        2683.413,    6,        1.506415e-26}, //  122SB
{   51,  122,           121.5,        9.088979,    0,                   0}, //  122SB
{   51,  122,          137.47,        764628.4,    0,                   0}, //  122SB
{   51,  122,          163.56,    3.627801e+11,    0,                   0}, //  122SB
{   51,  124,           10.86,    1.341706e+11,    0,                   0}, //  124SB
{   51,  124,          10.863,    1.341706e+11,    0,                   0}, //  124SB
{   51,  124,          36.844,    1.748546e+12,    0,                   0}, //  124SB
{   51,  124,          40.804,        4616.624,    0,                   0}, //  124SB
{   51,  124,          80.764,         5.77078,    0,                   0}, //  124SB
{   51,  124,          125.23,        124.0718,    0,                   0}, //  124SB
{   51,  125,     1969.000004,        36067.38,    0,                   0}, //  125SB
{   51,  125,          1971.2,         5915.05,    0,                   0}, //  125SB
{   51,  125,     1971.200004,        36067.38,    0,                   0}, //  125SB
{   51,  125,          2112.1,        40395.46,    0,                   0}, //  125SB
{   51,  125,            2325,        44.72355,    0,                   0}, //  125SB
{   51,  125,            2471,        392.4131,    0,                   0}, //  125SB
{   51,  126,            17.7,    1.657657e+12,    0,                   0}, //  126SB
{   51,  126,            40.4,    1.586965e+10,    0,                   0}, //  126SB
{   51,  126,              83,        7.357745,    0,                   0}, //  126SB
{   51,  126,           104.6,        797.8104,    0,                   0}, //  126SB
{   51,  126,           127.9,        112.5302,    0,                   0}, //  126SB
{   51,  127,          1920.2,        15869.65,    0,                   0}, //  127SB
{   51,  127,          2324.7,        238.0447,    0,                   0}, //  127SB
{   51,  128,           4e-06,    9.002417e+11,    0,                   0}, //  128SB
{   51,  129,            1851,    1.532142e+12,    0,                   0}, //  129SB
{   51,  129,          1860.9,         2885.39,    0,                   0}, //  129SB
{   51,  130,             4.8,    5.453387e+11,    0,                   0}, //  130SB
{   51,  130,           74.82,        5.193702,    0,                   0}, //  130SB
{   51,  131,          1676.1,        131285.2,    0,                   0}, //  131SB
{   51,  131,          1687.2,        6203.589,    0,                   0}, //  131SB
{   51,  131,          2165.6,        1586.965,    0,                   0}, //  131SB
{   51,  132,           4e-06,     3.54903e+11,    0,                   0}, //  132SB
{   51,  132,           85.55,         22.5349,    0,                   0}, //  132SB
{   51,  132,           254.5,        147.1549,    0,                   0}, //  132SB
{   51,  133,            4560,        23862.18,    0,                   0}, //  133SB
{   51,  134,             279,    1.452794e+10,    0,                   0}, //  134SB
{   51,  135,           281.7,         8.80044,    0,                   0}, //  135SB
{   51,  135,             523,        1.731234,    0,                   0}, //  135SB
{   51,  135,          1342.3,         28.8539,    0,                   0}, //  135SB
{   51,  136,           5e-06,        822.3362,    0,                   0}, //  136SB
{   51,  138,           4e-06,        432.8085,    0,                   0}, //  138SB
{   52,  111,           839.4,        46.45478,    0,                   0}, //  111TE
{   52,  115,              20,    5.799634e+11,    0,                   0}, //  115TE
{   52,  115,          280.05,        10820.21,   11,         -4.8177e-27}, //  115TE
{   52,  117,           274.4,        28.70963,    5,        -3.97435e-27}, //  117TE
{   52,  117,           296.1,    1.485976e+08,    0,                   0}, //  117TE
{   52,  119,          260.96,    5.858496e+14,   11,          4.5147e-27}, //  119TE
{   52,  119,          320.51,        3.173929,    5,          -4.545e-27}, //  119TE
{   52,  121,          293.97,    2.046751e+16,   11,         4.51975e-27}, //  121TE
{   52,  121,          443.11,        123.0619,    7,          3.7269e-27}, //  121TE
{   52,  123,          247.47,    1.485832e+16,   11,        -4.68135e-27}, //  123TE
{   52,  123,          489.81,        44.29074,    0,                   0}, //  123TE
{   52,  125,          35.492,        2.138074,    3,         3.05525e-27}, //  125TE
{   52,  125,          144.78,    7.154902e+15,   11,        -4.97425e-27}, //  125TE
{   52,  126,          2974.4,        15.43684,   20,         -7.6255e-27}, //  126TE
{   52,  127,           88.23,    1.322519e+16,   11,        -5.25705e-27}, //  127TE
{   52,  127,           88.26,    1.322519e+16,    0,                   0}, //  127TE
{   52,  128,          2337.7,        3.468239,    0,                   0}, //  128TE
{   52,  128,          2790.7,        533.7972,    0,                   0}, //  128TE
{   52,  129,           105.5,    4.188144e+15,   11,        -5.50955e-27}, //  129TE
{   52,  130,          1815.3,        14.13841,    0,                   0}, //  130TE
{   52,  130,          2146.4,        165.9099,    0,                   0}, //  130TE
{   52,  130,     2648.600004,        2741.121,    0,                   0}, //  130TE
{   52,  130,          4375.4,        376.5434,    0,                   0}, //  130TE
{   52,  131,          182.26,    1.726906e+14,   11,          -5.252e-27}, //  131TE
{   52,  131,            1940,    1.341706e+08,    0,                   0}, //  131TE
{   52,  132,          1774.8,        209.1908,   12,          2.3735e-26}, //  132TE
{   52,  132,          1925.5,        40539.73,    0,                   0}, //  132TE
{   52,  132,          2722.4,        5337.972,    0,                   0}, //  132TE
{   52,  132,          2723.3,        5337.972,    0,                   0}, //  132TE
{   52,  133,          334.26,    4.795518e+12,    0,                   0}, //  133TE
{   52,  133,          1610.4,        144.2695,    0,                   0}, //  133TE
{   52,  134,          1576.1,        1.962065,    0,                   0}, //  134TE
{   52,  134,          1691.3,        236.7463,   12,          2.5654e-26}, //  134TE
{   52,  134,            5804,        25.96851,    0,                   0}, //  134TE
{   52,  135,          1554.9,        737.2172,    0,                   0}, //  135TE
{   52,  135,          1555.3,        737.2172,    0,                   0}, //  135TE
{   52,  135,          3233.3,         5.77078,    0,                   0}, //  135TE
{   53,  114,           265.9,    8.944709e+09,    0,                   0}, //   114I
{   53,  115,             413,        207748.1,    0,                   0}, //   115I
{   53,  116,           430.4,        4717.613,    0,                   0}, //   116I
{   53,  117,          353.59,        17.45661,    0,                   0}, //   117I
{   53,  117,          5063.8,        72.13475,    0,                   0}, //   117I
{   53,  118,      104.000004,    7.357745e+11,    0,                   0}, //   118I
{   53,  119,          306.66,        49.91725,    9,           2.727e-26}, //   119I
{   53,  119,          687.41,        7.934823,    0,                   0}, //   119I
{   53,  119,          2417.3,         5.77078,    0,                   0}, //   119I
{   53,  120,           25.07,        19.62065,    0,                   0}, //   120I
{   53,  120,           72.61,        328.9345,    0,                   0}, //   120I
{   53,  120,           89.82,         2.88539,    0,                   0}, //   120I
{   53,  120,          102.25,        1.947638,    0,                   0}, //   120I
{   53,  120,             320,     4.58777e+12,    0,                   0}, //   120I
{   53,  121,           95.71,        11.97437,    0,                   0}, //   121I
{   53,  121,          433.56,        13.84987,    0,                   0}, //   121I
{   53,  121,            2353,        115.4156,    0,                   0}, //   121I
{   53,  121,          2376.9,        12984.26,    0,                   0}, //   121I
{   53,  122,          61.625,        10.67594,    0,                   0}, //   122I
{   53,  122,          90.596,        2.741121,    0,                   0}, //   122I
{   53,  122,           155.7,        23.94874,    0,                   0}, //   122I
{   53,  122,           314.9,        274.1121,    0,                   0}, //   122I
{   53,  122,           379.4,        115415.6,    0,                   0}, //   122I
{   53,  122,           394.1,        115415.6,    0,                   0}, //   122I
{   53,  122,           444.1,        213.5189,    0,                   0}, //   122I
{   53,  123,          148.92,        3.390333,    0,                   0}, //   123I
{   53,  123,          2659.9,        39.24131,    0,                   0}, //   123I
{   53,  124,           55.48,        75.02014,    0,                   0}, //   124I
{   53,  124,          123.04,        13.84987,    0,                   0}, //   124I
{   53,  124,          250.54,        20.19773,    0,                   0}, //   124I
{   53,  124,          287.36,        2.308312,    0,                   0}, //   124I
{   53,  124,           311.4,        4.328085,    0,                   0}, //   124I
{   53,  124,           397.1,        14.42695,    0,                   0}, //   124I
{   53,  124,           689.7,        20.19773,    0,                   0}, //   124I
{   53,  125,          2350.5,        2.308312,    0,                   0}, //   125I
{   53,  126,           56.43,        22.93885,    0,                   0}, //   126I
{   53,  126,          110.85,        80.79092,    0,                   0}, //   126I
{   53,  126,          122.17,        19.47638,    0,                   0}, //   126I
{   53,  127,          57.608,        2.813255,    7,          1.2827e-26}, //   127I
{   53,  128,          133.61,        17.74515,    0,                   0}, //   128I
{   53,  128,          137.85,        1219.077,    8,          -3.636e-27}, //   128I
{   53,  128,          167.37,        252.4716,    0,                   0}, //   128I
{   53,  128,          180.38,        2.452582,    0,                   0}, //   128I
{   53,  128,          232.58,        2.452582,    0,                   0}, //   128I
{   53,  128,          344.52,        1.731234,    0,                   0}, //   128I
{   53,  128,          376.62,        7.213475,    0,                   0}, //   128I
{   53,  128,          485.42,        2.019773,    0,                   0}, //   128I
{   53,  128,          521.08,        2.164043,    0,                   0}, //   128I
{   53,  129,            27.8,        24.23728,    5,        1.416273e-26}, //   129I
{   53,  130,          39.953,    7.652054e+11,    0,                   0}, //   130I
{   53,  130,          69.587,        191.8784,    0,                   0}, //   130I
{   53,  130,          82.396,        454.4489,    0,                   0}, //   130I
{   53,  130,       82.400004,        95.21787,    0,                   0}, //   130I
{   53,  130,           85.11,        366.4445,    0,                   0}, //   130I
{   53,  130,          374.68,        10.09887,    0,                   0}, //   130I
{   53,  130,          804.07,         2.88539,    0,                   0}, //   130I
{   53,  130,          825.02,        2.019773,    0,                   0}, //   130I
{   53,  130,          944.96,         2.88539,    0,                   0}, //   130I
{   53,  131,          1797.1,        8.511901,    0,                   0}, //   131I
{   53,  131,          2352.2,        62.03589,    0,                   0}, //   131I
{   53,  132,           49.72,        10.30084,    0,                   0}, //   132I
{   53,  132,             120,    7.203665e+12,    0,                   0}, //   132I
{   53,  132,          161.52,        5.150421,    0,                   0}, //   132I
{   53,  132,          277.86,        2.048627,    2,           9.494e-27}, //   132I
{   53,  133,          1634.1,    1.298426e+10,    0,                   0}, //   133I
{   53,  133,          1729.1,        245.2582,    0,                   0}, //   133I
{   53,  133,            2435,        1125.302,    0,                   0}, //   133I
{   53,  133,          2493.7,         676.624,    0,                   0}, //   133I
{   53,  134,           44.39,        14.42695,    0,                   0}, //   134I
{   53,  134,          79.461,        2.337166,    0,                   0}, //   134I
{   53,  134,          316.49,    3.046972e+11,    0,                   0}, //   134I
{   53,  136,             640,     6.76624e+10,    0,                   0}, //   136I
{   53,  136,     1372.000004,         5.77078,    0,                   0}, //   136I
{   53,  144,           4e-06,        432.8085,    0,                   0}, //   144I
{   54,  117,          205.52,        24.52582,    0,                   0}, //  117XE
{   54,  117,          229.78,        85.11901,    0,                   0}, //  117XE
{   54,  119,          176.08,         28.8539,    0,                   0}, //  119XE
{   54,  119,          243.39,        38.95277,    0,                   0}, //  119XE
{   54,  119,          245.99,        100.9887,    0,                   0}, //  119XE
{   54,  119,          246.42,         5.77078,    0,                   0}, //  119XE
{   54,  121,          153.99,        115.4156,    0,                   0}, //  121XE
{   54,  121,          196.06,        9.810326,    0,                   0}, //  121XE
{   54,  121,          264.72,         8.65617,    0,                   0}, //  121XE
{   54,  123,          180.59,        3.606738,    0,                   0}, //  123XE
{   54,  123,          185.18,        7920.396,    0,                   0}, //  123XE
{   54,  123,          206.24,         17.0238,    0,                   0}, //  123XE
{   54,  123,          263.14,        2.164043,    0,                   0}, //  123XE
{   54,  125,          252.61,    8.208935e+10,    0,                   0}, //  125XE
{   54,  125,          252.61,    8.223362e+10,    0,                   0}, //  125XE
{   54,  125,          295.89,        201.9773,    0,                   0}, //  125XE
{   54,  126,          2758.2,        1.875504,    0,                   0}, //  126XE
{   54,  127,           297.1,     9.98345e+10,    0,                   0}, //  127XE
{   54,  127,          342.23,        52.94691,    7,          4.2925e-27}, //  127XE
{   54,  127,          711.61,         2.88539,    0,                   0}, //  127XE
{   54,  127,            2730,        36.06738,    0,                   0}, //  127XE
{   54,  128,          1429.6,         5.77078,    0,                   0}, //  128XE
{   54,  128,          1603.5,         8.65617,    0,                   0}, //  128XE
{   54,  128,          2229.2,         8.65617,    0,                   0}, //  128XE
{   54,  128,          2280.9,         5.77078,    0,                   0}, //  128XE
{   54,  128,          2500.9,        4.328085,    0,                   0}, //  128XE
{   54,  128,            2720,        7.213475,    0,                   0}, //  128XE
{   54,  128,          2787.3,        119.7437,   16,         -1.4645e-27}, //  128XE
{   54,  128,          2942.1,         5.77078,    0,                   0}, //  128XE
{   54,  128,          3196.8,         5.77078,    0,                   0}, //  128XE
{   54,  129,          236.14,    1.106879e+15,   11,       -4.500676e-27}, //  129XE
{   54,  130,          1122.1,        4.328085,    0,                   0}, //  130XE
{   54,  130,          1204.6,         2.88539,    0,                   0}, //  130XE
{   54,  130,          1632.6,         2.88539,    0,                   0}, //  130XE
{   54,  130,          1944.1,         2.88539,    0,                   0}, //  130XE
{   54,  130,            2310,        4.328085,    0,                   0}, //  130XE
{   54,  130,          2345.9,        4.328085,    0,                   0}, //  130XE
{   54,  130,            2442,         2.88539,    0,                   0}, //  130XE
{   54,  130,          2659.3,         2.88539,    0,                   0}, //  130XE
{   54,  130,          2696.9,        4.328085,    0,                   0}, //  130XE
{   54,  130,          2841.6,         5.77078,    0,                   0}, //  130XE
{   54,  130,          2972.4,        7.401026,   20,        -1.03525e-26}, //  130XE
{   54,  130,          3461.2,        4.328085,    0,                   0}, //  130XE
{   54,  130,          3693.3,         2.88539,    0,                   0}, //  130XE
{   54,  131,          163.93,    1.475877e+15,   11,       -5.019942e-27}, //  131XE
{   54,  131,          341.14,        2.308312,    0,                   0}, //  131XE
{   54,  131,          1805.3,        20.19773,    0,                   0}, //  131XE
{   54,  132,            2214,        125.5145,    0,                   0}, //  132XE
{   54,  132,          2752.2,    1.210421e+07,    0,                   0}, //  132XE
{   54,  133,          233.22,    2.739822e+14,    0,                   0}, //  133XE
{   54,  134,          1965.5,    4.183816e+08,    0,                   0}, //  134XE
{   54,  134,          3025.2,        7213.475,    0,                   0}, //  134XE
{   54,  135,          526.55,    1.323528e+12,   11,        -5.57318e-27}, //  135XE
{   54,  135,          526.56,    1.323528e+12,    0,                   0}, //  135XE
{   54,  136,          1694.4,        1.865405,    8,           1.616e-26}, //  136XE
{   54,  136,          1891.7,         4255.95,    0,                   0}, //  136XE
{   54,  137,          1935.2,        14.57122,    0,                   0}, //  137XE
{   54,  139,          559.69,        14.42695,    0,                   0}, //  139XE
{   54,  139,          594.28,        14.42695,    0,                   0}, //  139XE
{   54,  139,          678.86,        14.42695,    0,                   0}, //  139XE
{   54,  139,          1086.2,        14.42695,    0,                   0}, //  139XE
{   54,  139,          1179.6,        14.42695,    0,                   0}, //  139XE
{   54,  139,          1194.9,        14.42695,    0,                   0}, //  139XE
{   54,  139,          1418.2,        14.42695,    0,                   0}, //  139XE
{   54,  139,          1512.5,        14.42695,    0,                   0}, //  139XE
{   54,  139,          1577.1,        14.42695,    0,                   0}, //  139XE
{   54,  139,          1809.9,        14.42695,    0,                   0}, //  139XE
{   54,  139,          1862.2,        14.42695,    0,                   0}, //  139XE
{   54,  139,          2014.7,        14.42695,    0,                   0}, //  139XE
{   54,  139,          2158.9,        14.42695,    0,                   0}, //  139XE
{   54,  139,          2192.9,        14.42695,    0,                   0}, //  139XE
{   54,  139,          2500.2,        14.42695,    0,                   0}, //  139XE
{   54,  139,          2575.3,        14.42695,    0,                   0}, //  139XE
{   54,  139,          2921.9,        14.42695,    0,                   0}, //  139XE
{   54,  139,          2925.4,        14.42695,    0,                   0}, //  139XE
{   54,  139,          2993.9,        14.42695,    0,                   0}, //  139XE
{   54,  139,          3161.6,        14.42695,    0,                   0}, //  139XE
{   54,  139,          3212.1,        14.42695,    0,                   0}, //  139XE
{   54,  139,          3547.9,        14.42695,    0,                   0}, //  139XE
{   54,  139,          3586.2,        14.42695,    0,                   0}, //  139XE
{   54,  139,          3793.1,        14.42695,    0,                   0}, //  139XE
{   54,  139,          4023.1,        14.42695,    0,                   0}, //  139XE
{   54,  139,          4232.7,        14.42695,    0,                   0}, //  139XE
{   54,  139,          4299.2,        14.42695,    0,                   0}, //  139XE
{   54,  139,          5096.5,        14.42695,    0,                   0}, //  139XE
{   55,  116,             100,    5.554376e+09,    0,                   0}, //  116CS
{   55,  117,           5e-06,    1.211864e+10,    0,                   0}, //  117CS
{   55,  117,           6e-06,    9.377518e+09,    0,                   0}, //  117CS
{   55,  118,           4e-06,    2.452582e+10,    0,                   0}, //  118CS
{   55,  119,           4e-06,    4.385793e+10,    0,                   0}, //  119CS
{   55,  120,           4e-06,    8.223362e+10,    0,                   0}, //  120CS
{   55,  121,            68.5,    1.760088e+11,    0,                   0}, //  121CS
{   55,  122,           45.87,        1442.695,    0,                   0}, //  122CS
{   55,  122,          127.05,    5.193702e+08,    0,                   0}, //  122CS
{   55,  122,          127.07,    5.193702e+08,    0,                   0}, //  122CS
{   55,  122,             140,    3.202783e+11,    0,                   0}, //  122CS
{   55,  123,           94.57,        12.98426,    0,                   0}, //  123CS
{   55,  123,          156.27,     2.36602e+09,    0,                   0}, //  123CS
{   55,  123,      231.630004,        164.4672,    0,                   0}, //  123CS
{   55,  124,          301.14,        99.54596,    0,                   0}, //  124CS
{   55,  124,          462.54,    9.088979e+09,    0,                   0}, //  124CS
{   55,  124,          462.63,    9.088979e+09,    0,                   0}, //  124CS
{   55,  125,           77.11,        1.731234,    0,                   0}, //  125CS
{   55,  125,           84.82,        20.91908,    0,                   0}, //  125CS
{   55,  125,             266,         1298426,    0,                   0}, //  125CS
{   55,  125,           266.1,         1298426,    0,                   0}, //  125CS
{   55,  126,             273,        1442.695,    0,                   0}, //  126CS
{   55,  126,           596.1,        246700.9,    0,                   0}, //  126CS
{   55,  127,           66.09,        35.89425,    0,                   0}, //  127CS
{   55,  127,           451.1,        79348.23,    0,                   0}, //  127CS
{   55,  127,          452.23,        79348.23,    0,                   0}, //  127CS
{   55,  127,          707.35,        11.54156,    0,                   0}, //  127CS
{   55,  127,           866.5,        11.54156,    0,                   0}, //  127CS
{   55,  127,            1131,        11.54156,    0,                   0}, //  127CS
{   55,  127,          1323.8,        11.54156,    0,                   0}, //  127CS
{   55,  127,          1442.4,        11.54156,    0,                   0}, //  127CS
{   55,  127,          1458.2,        11.54156,    0,                   0}, //  127CS
{   55,  127,          1492.3,        11.54156,    0,                   0}, //  127CS
{   55,  127,          1956.3,        11.54156,    0,                   0}, //  127CS
{   55,  127,          2096.9,        11.54156,    0,                   0}, //  127CS
{   55,  127,          2117.5,        11.54156,    0,                   0}, //  127CS
{   55,  127,          2258.3,        11.54156,    0,                   0}, //  127CS
{   55,  127,          2935.7,        11.54156,    0,                   0}, //  127CS
{   55,  127,          3000.2,        11.54156,    0,                   0}, //  127CS
{   55,  127,          3002.4,        11.54156,    0,                   0}, //  127CS
{   55,  127,          3156.8,        11.54156,    0,                   0}, //  127CS
{   55,  127,          3261.9,        11.54156,    0,                   0}, //  127CS
{   55,  128,      755.300004,        72.13475,    0,                   0}, //  128CS
{   55,  129,            6.55,         103.874,    0,                   0}, //  129CS
{   55,  129,          188.93,        3.260491,    0,                   0}, //  129CS
{   55,  129,          575.44,        995.4596,    0,                   0}, //  129CS
{   55,  130,          163.25,    2.995035e+11,   10,         3.17645e-27}, //  130CS
{   55,  131,           78.73,        13.56133,    0,                   0}, //  131CS
{   55,  131,           123.8,        5.410106,    0,                   0}, //  131CS
{   55,  131,          133.62,        12.40718,    5,           9.393e-27}, //  131CS
{   55,  131,          775.28,        15.09059,   11,          3.1815e-26}, //  131CS
{   55,  133,          80.998,        9.064453,    5,         1.74225e-26}, //  133CS
{   55,  134,          11.244,        67.22959,   10,         1.69175e-26}, //  134CS
{   55,  134,          138.74,    1.512377e+13,   16,         5.54389e-27}, //  134CS
{   55,  134,           176.4,        71.70194,    0,                   0}, //  134CS
{   55,  134,          257.11,        17.74515,    0,                   0}, //  134CS
{   55,  135,          1632.9,     4.58777e+12,   19,          1.1009e-26}, //  135CS
{   55,  135,          1633.3,     4.58777e+12,    0,                   0}, //  135CS
{   55,  136,           4e-06,    2.741121e+10,   16,         6.66095e-27}, //  136CS
{   55,  138,            79.9,    2.518946e+11,   12,         8.65065e-27}, //  138CS
{   55,  140,          13.931,        679.5094,    0,                   0}, //  140CS
{   55,  140,          64.756,        5.337972,    0,                   0}, //  140CS
{   55,  140,          80.118,        3.895277,    0,                   0}, //  140CS
{   55,  140,           103.1,        10.53167,    0,                   0}, //  140CS
{   55,  140,          112.51,        3.318199,    0,                   0}, //  140CS
{   55,  140,          118.45,        3.462468,    0,                   0}, //  140CS
{   55,  140,          149.01,        3.895277,    0,                   0}, //  140CS
{   55,  140,          212.06,        3.751007,    0,                   0}, //  140CS
{   55,  140,          232.08,        2.741121,    0,                   0}, //  140CS
{   55,  141,           69.05,        33.61479,    0,                   0}, //  141CS
{   55,  141,          105.94,        12.55145,    0,                   0}, //  141CS
{   55,  141,          187.76,        2.741121,    0,                   0}, //  141CS
{   55,  141,          206.65,         3.02966,    0,                   0}, //  141CS
{   55,  142,      122.900004,        15.86965,    0,                   0}, //  142CS
{   55,  144,           5e-06,    1.442695e+09,    0,                   0}, //  144CS
{   55,  144,            92.2,        1586.965,    0,                   0}, //  144CS
{   55,  144,      107.900004,        11.54156,    0,                   0}, //  144CS
{   56,  123,            92.5,         57.7078,    0,                   0}, //  123BA
{   56,  123,          120.95,        1197.437,    0,                   0}, //  123BA
{   56,  125,       67.700004,        3981.838,    0,                   0}, //  125BA
{   56,  127,           80.32,    2.784401e+09,    7,       -3.649635e-27}, //  127BA
{   56,  127,           81.29,        108.2021,    0,                   0}, //  127BA
{   56,  128,          2395.8,         8.80044,    0,                   0}, //  128BA
{   56,  129,            8.42,     1.12184e+13,    7,          4.6965e-27}, //  129BA
{   56,  129,          182.04,        23.08312,    0,                   0}, //  129BA
{   56,  129,          2462.6,        67.80667,    0,                   0}, //  129BA
{   56,  130,          2475.1,    1.356133e+07,    0,                   0}, //  130BA
{   56,  130,          2476.2,    1.356133e+07,    0,                   0}, //  130BA
{   56,  131,           187.5,    1.263801e+12,    0,                   0}, //  131BA
{   56,  131,             188,    1.263801e+12,    9,         -4.3935e-27}, //  131BA
{   56,  132,          3116.1,        12.89769,   20,         -8.0295e-27}, //  132BA
{   56,  133,          12.327,        10.09887,    3,           2.929e-27}, //  133BA
{   56,  133,          288.25,    2.021937e+14,   11,          4.5955e-27}, //  133BA
{   56,  133,          1942.1,        5.049433,    0,                   0}, //  133BA
{   56,  134,          1986.3,        75.02014,    0,                   0}, //  134BA
{   56,  134,          2957.2,        3794.288,    0,                   0}, //  134BA
{   56,  135,          268.22,    1.490593e+14,   11,        -5.05505e-27}, //  135BA
{   56,  136,          2030.5,    4.449272e+08,    0,                   0}, //  136BA
{   56,  136,          2140.2,        2.308312,   10,          -9.595e-27}, //  136BA
{   56,  136,          2207.1,        4.486782,    0,                   0}, //  136BA
{   56,  137,          661.66,    2.209055e+11,   11,         -5.0096e-27}, //  137BA
{   56,  137,          2349.1,        851.1901,    0,                   0}, //  137BA
{   56,  137,          2623.8,        43.28085,    0,                   0}, //  137BA
{   56,  138,          1898.6,        3.121992,    8,           1.616e-26}, //  138BA
{   56,  138,          2090.5,        1154.156,   12,          2.9593e-26}, //  138BA
{   56,  141,           48.53,        3.318199,    0,                   0}, //  141BA
{   56,  141,              55,        7.502014,    0,                   0}, //  141BA
{   56,  143,          117.37,        5.049433,    9,           2.525e-27}, //  143BA
{   56,  147,           109.8,        2.019773,    0,                   0}, //  147BA
{   57,  117,             151,    1.442695e+07,    0,                   0}, //  117LA
{   57,  120,           4e-06,    4.039546e+09,    0,                   0}, //  120LA
{   57,  124,           2e-06,     3.02966e+10,    0,                   0}, //  124LA
{   57,  124,           5e-06,    4.214112e+10,    0,                   0}, //  124LA
{   57,  125,             107,    5.626511e+08,    0,                   0}, //  125LA
{   57,  126,           4e-06,    7.790553e+10,    0,                   0}, //  126LA
{   57,  126,           6e-06,    7.213475e+10,    0,                   0}, //  126LA
{   57,  127,            14.2,    3.202783e+11,    0,                   0}, //  127LA
{   57,  127,           210.2,        2.741121,    0,                   0}, //  127LA
{   57,  128,           4e-06,    1.211864e+11,    0,                   0}, //  128LA
{   57,  129,           172.1,    8.079092e+08,    0,                   0}, //  129LA
{   57,  130,          110.44,        24.52582,    0,                   0}, //  130LA
{   57,  130,          131.01,        111.0875,    0,                   0}, //  130LA
{   57,  131,          230.44,        43.28085,    0,                   0}, //  131LA
{   57,  131,           304.4,        245258.2,    0,                   0}, //  131LA
{   57,  131,           304.6,        245258.2,    0,                   0}, //  131LA
{   57,  131,          416.83,        43.28085,    0,                   0}, //  131LA
{   57,  131,          421.56,        43.28085,    0,                   0}, //  131LA
{   57,  131,          440.48,        43.28085,    0,                   0}, //  131LA
{   57,  131,           459.9,        43.28085,    0,                   0}, //  131LA
{   57,  131,          463.03,        43.28085,    0,                   0}, //  131LA
{   57,  131,          588.11,        43.28085,    0,                   0}, //  131LA
{   57,  131,          595.14,        43.28085,    0,                   0}, //  131LA
{   57,  131,          671.66,        43.28085,    0,                   0}, //  131LA
{   57,  131,          743.31,        43.28085,    0,                   0}, //  131LA
{   57,  131,          911.17,        43.28085,    0,                   0}, //  131LA
{   57,  131,          946.13,        43.28085,    0,                   0}, //  131LA
{   57,  131,          1774.5,        43.28085,    0,                   0}, //  131LA
{   57,  131,            1890,        43.28085,    0,                   0}, //  131LA
{   57,  131,          1910.1,        43.28085,    0,                   0}, //  131LA
{   57,  131,          2121.8,        54.82241,    0,                   0}, //  131LA
{   57,  132,           188.2,    2.103449e+12,    0,                   0}, //  132LA
{   57,  132,          188.56,    2.103449e+12,    0,                   0}, //  132LA
{   57,  133,           87.94,        1.875504,    0,                   0}, //  133LA
{   57,  133,           130.8,        1.615818,    0,                   0}, //  133LA
{   57,  133,           535.6,        89.44709,   11,          3.7875e-26}, //  133LA
{   57,  134,      336.440004,        41838.16,    0,                   0}, //  134LA
{   57,  135,          119.53,         5.77078,    0,                   0}, //  135LA
{   57,  135,           785.7,         28.8539,    0,                   0}, //  135LA
{   57,  135,          2265.8,         28.8539,    0,                   0}, //  135LA
{   57,  135,          2735.5,         37.3658,    0,                   0}, //  135LA
{   57,  136,      230.000004,    1.644672e+08,    0,                   0}, //  136LA
{   57,  136,          270.14,        24.52582,    0,                   0}, //  136LA
{   57,  137,           10.59,        128.3999,    0,                   0}, //  137LA
{   57,  137,          1869.5,        493.4017,   19,          1.1817e-26}, //  137LA
{   57,  138,           72.57,        167.3526,    0,                   0}, //  138LA
{   57,  139,          165.86,          2.1626,    0,                   0}, //  139LA
{   57,  140,          467.63,        11.10875,    0,                   0}, //  140LA
{   57,  141,          190.33,        1.832223,    0,                   0}, //  141LA
{   57,  142,          145.82,        1255.145,    0,                   0}, //  142LA
{   57,  145,            65.9,        12.98426,    0,                   0}, //  145LA
{   57,  146,           4e-06,    1.442695e+10,    0,                   0}, //  146LA
{   57,  147,            74.5,        4.328085,    0,                   0}, //  147LA
{   57,  147,           120.8,        2.019773,    0,                   0}, //  147LA
{   57,  147,           167.4,        5.049433,    0,                   0}, //  147LA
{   57,  148,          56.033,        96.66057,    0,                   0}, //  148LA
{   58,  127,             7.3,    4.126108e+10,    0,                   0}, //  127CE
{   58,  127,            36.8,        14426.95,    0,                   0}, //  127CE
{   58,  129,           107.6,        89.44709,    0,                   0}, //  129CE
{   58,  130,          2453.6,        144.2695,    0,                   0}, //  130CE
{   58,  131,           63.09,    4.674332e+11,    0,                   0}, //  131CE
{   58,  131,          161.98,        126.9572,    9,         -4.2925e-27}, //  131CE
{   58,  132,          2340.6,    1.356133e+07,    0,                   0}, //  132CE
{   58,  132,          2341.2,    1.356133e+07,    0,                   0}, //  132CE
{   58,  133,            37.2,    2.648788e+13,    0,                   0}, //  133CE
{   58,  134,          3208.6,        444.3501,   20,         -9.4435e-27}, //  134CE
{   58,  135,           445.8,     2.88539e+10,    0,                   0}, //  135CE
{   58,  135,          445.81,     2.88539e+10,    0,                   0}, //  135CE
{   58,  135,          2125.3,         11.8301,    0,                   0}, //  135CE
{   58,  136,          1978.5,        4.328085,    0,                   0}, //  136CE
{   58,  136,            2214,        7.213475,    0,                   0}, //  136CE
{   58,  136,          2307.1,        4.328085,    0,                   0}, //  136CE
{   58,  136,          2366.5,        7.213475,    0,                   0}, //  136CE
{   58,  136,          2424.9,        4.328085,    0,                   0}, //  136CE
{   58,  136,          3095.1,        3173.929,    0,                   0}, //  136CE
{   58,  136,          3095.5,        3173.929,   20,           -9.09e-27}, //  136CE
{   58,  136,          3146.7,        4.328085,    0,                   0}, //  136CE
{   58,  136,          3278.1,        4.328085,    0,                   0}, //  136CE
{   58,  136,            3400,        4.328085,    0,                   0}, //  136CE
{   58,  136,            3987,        4.328085,    0,                   0}, //  136CE
{   58,  136,          4084.3,        4.328085,    0,                   0}, //  136CE
{   58,  137,          254.29,    1.786634e+14,   11,          5.1005e-27}, //  137CE
{   58,  138,          2129.2,    1.247931e+07,    0,                   0}, //  138CE
{   58,  138,          3539.1,        116.8583,   20,          -8.585e-27}, //  138CE
{   58,  138,          3942.2,        2.164043,    0,                   0}, //  138CE
{   58,  139,          754.24,    7.905969e+10,    0,                   0}, //  139CE
{   58,  139,            2631,        100.9887,    0,                   0}, //  139CE
{   58,  139,          2818.8,        4.328085,    0,                   0}, //  139CE
{   58,  140,          2083.3,        4.977298,    8,         2.19675e-26}, //  140CE
{   58,  140,          2107.9,        10531.67,    0,                   0}, //  140CE
{   58,  140,          2349.8,        14.42695,    0,                   0}, //  140CE
{   58,  140,          2480.9,        4.616624,    0,                   0}, //  140CE
{   58,  140,            3493,        2.452582,    0,                   0}, //  140CE
{   58,  140,          3715.3,        33.32626,   20,          5.2015e-26}, //  140CE
{   58,  141,          1368.7,        7.646284,    0,                   0}, //  141CE
{   58,  141,            2274,        3.173929,    0,                   0}, //  141CE
{   58,  145,            64.3,        18.75504,    0,                   0}, //  145CE
{   58,  148,          158.47,        1.457122,    4,           3.737e-27}, //  148CE
{   58,  150,            97.1,        5.193702,    0,                   0}, //  150CE
{   58,  151,           4e-06,    1.471549e+09,    0,                   0}, //  151CE
{   59,  130,           4e-06,     5.77078e+10,    0,                   0}, //  130PR
{   59,  131,           152.4,    8.266643e+09,    0,                   0}, //  131PR
{   59,  133,          192.12,    1.586965e+09,    0,                   0}, //  133PR
{   59,  133,          2033.8,        50.49433,    0,                   0}, //  133PR
{   59,  133,          2203.3,        50.49433,    0,                   0}, //  133PR
{   59,  134,           4e-06,    1.471549e+12,    0,                   0}, //  134PR
{   59,  134,           5e-06,    9.521787e+11,    0,                   0}, //  134PR
{   59,  134,      306.500005,         4.58777,    0,                   0}, //  134PR
{   59,  135,           357.6,          151483,    0,                   0}, //  135PR
{   59,  135,          358.06,          151483,    0,                   0}, //  135PR
{   59,  136,           40.19,        13.34493,    0,                   0}, //  136PR
{   59,  136,          594.62,        132.2951,    0,                   0}, //  136PR
{   59,  137,          561.22,        3837.569,    0,                   0}, //  137PR
{   59,  138,             364,    1.101065e+13,    0,                   0}, //  138PR
{   59,  139,          113.92,        3.751007,    7,          6.0095e-27}, //  139PR
{   59,  139,          821.98,        62.61296,   11,           3.333e-26}, //  139PR
{   59,  140,           127.8,        504.9433,    0,                   0}, //  140PR
{   59,  140,           763.7,         4400.22,    0,                   0}, //  140PR
{   59,  141,          145.44,        2.668986,    7,         1.48975e-26}, //  141PR
{   59,  141,            1118,        6.924936,   11,           3.131e-26}, //  141PR
{   59,  142,           3.694,    1.263801e+12,   10,           1.111e-26}, //  142PR
{   59,  142,           911.4,         88.0044,    0,                   0}, //  142PR
{   59,  143,          57.356,        5.972757,    5,           1.717e-26}, //  143PR
{   59,  144,           59.03,    6.232443e+11,    0,                   0}, //  144PR
{   59,  145,           62.65,         5.77078,    0,                   0}, //  145PR
{   59,  147,           93.29,        17.31234,    0,                   0}, //  147PR
{   59,  148,              90,     1.73989e+11,    0,                   0}, //  148PR
{   59,  149,            58.5,        33.03772,    0,                   0}, //  149PR
{   59,  151,            35.1,        14426.95,    0,                   0}, //  151PR
{   59,  151,       96.000004,         28.8539,    0,                   0}, //  151PR
{   60,  131,           210.8,        72.13475,    0,                   0}, //  131ND
{   60,  133,          127.97,    1.009887e+11,    0,                   0}, //  133ND
{   60,  133,           176.1,        434.2512,    0,                   0}, //  133ND
{   60,  133,          353.62,        66.36397,    0,                   0}, //  133ND
{   60,  134,            2293,          591505,    0,                   0}, //  134ND
{   60,  135,           64.95,    4.760894e+11,    0,                   0}, //  135ND
{   60,  137,          519.43,    2.308312e+09,    0,                   0}, //  137ND
{   60,  137,          2223.4,        3.606738,    0,                   0}, //  137ND
{   60,  138,          3174.9,         591.505,    0,                   0}, //  138ND
{   60,  139,          231.15,    2.856536e+13,    0,                   0}, //  139ND
{   60,  139,     2570.900004,          203.42,    0,                   0}, //  139ND
{   60,  140,          2221.4,          865617,    0,                   0}, //  140ND
{   60,  140,          3621.2,        31.73929,   20,          -9.696e-27}, //  140ND
{   60,  141,          193.68,        1.687953,    0,                   0}, //  141ND
{   60,  141,          756.51,    8.944709e+10,    0,                   0}, //  141ND
{   60,  141,     2887.500004,        37.51007,    0,                   0}, //  141ND
{   60,  142,          2100.8,        40.39546,    0,                   0}, //  142ND
{   60,  142,          3484.9,        2.308312,   18,          4.7975e-26}, //  142ND
{   60,  143,            1228,        9.795899,   13,           1.919e-27}, //  143ND
{   60,  143,          8987.7,        50.49433,    0,                   0}, //  143ND
{   60,  145,          67.167,        42.41523,    0,                   0}, //  145ND
{   60,  147,          214.59,        6.535409,    0,                   0}, //  147ND
{   60,  149,          220.71,         3.02966,    0,                   0}, //  149ND
{   60,  149,          270.86,        7.357745,    0,                   0}, //  149ND
{   60,  150,          130.21,        2.152501,    4,          3.2522e-27}, //  150ND
{   60,  152,           72.51,        6.492128,    0,                   0}, //  152ND
{   60,  153,           191.7,        1529.257,    0,                   0}, //  153ND
{   60,  154,            70.8,        11.10875,    0,                   0}, //  154ND
{   60,  154,      233.200004,        1875.504,    0,                   0}, //  154ND
{   60,  154,            1349,        1442.695,    0,                   0}, //  154ND
{   60,  156,            1432,        194.7638,    0,                   0}, //  156ND
{   61,  133,           129.7,    1.269572e+10,    0,                   0}, //  133PM
{   61,  134,           4e-06,    3.173929e+10,    0,                   0}, //  134PM
{   61,  135,           4e-06,    7.069206e+10,    0,                   0}, //  135PM
{   61,  135,       68.700005,    6.492128e+10,    0,                   0}, //  135PM
{   61,  136,           4e-06,    6.780667e+10,    0,                   0}, //  136PM
{   61,  136,           5e-06,    1.543684e+11,    0,                   0}, //  136PM
{   61,  138,              20,    2.804599e+11,    0,                   0}, //  138PM
{   61,  138,      584.260004,         30.2966,    0,                   0}, //  138PM
{   61,  139,           188.7,    2.596851e+08,    0,                   0}, //  139PM
{   61,  139,           778.9,        14.42695,    0,                   0}, //  139PM
{   61,  139,          1375.9,        14.42695,    0,                   0}, //  139PM
{   61,  139,          1405.8,        14.42695,    0,                   0}, //  139PM
{   61,  139,          1714.7,        14.42695,    0,                   0}, //  139PM
{   61,  139,          1951.6,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2106.7,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2163.7,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2190.4,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2301.9,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2352.2,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2570.9,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2689.8,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2798.7,        14.42695,    0,                   0}, //  139PM
{   61,  139,          2964.5,        14.42695,    0,                   0}, //  139PM
{   61,  139,          3023.8,        14.42695,    0,                   0}, //  139PM
{   61,  139,          3157.6,        14.42695,    0,                   0}, //  139PM
{   61,  139,          3261.7,        14.42695,    0,                   0}, //  139PM
{   61,  139,          3279.9,        14.42695,    0,                   0}, //  139PM
{   61,  139,          3417.1,        14.42695,    0,                   0}, //  139PM
{   61,  139,          3558.3,        14.42695,    0,                   0}, //  139PM
{   61,  139,          3590.3,        14.42695,    0,                   0}, //  139PM
{   61,  139,          3906.6,        14.42695,    0,                   0}, //  139PM
{   61,  139,          4155.3,        14.42695,    0,                   0}, //  139PM
{   61,  139,          4379.6,        14.42695,    0,                   0}, //  139PM
{   61,  139,          4383.5,        14.42695,    0,                   0}, //  139PM
{   61,  139,          4418.1,        14.42695,    0,                   0}, //  139PM
{   61,  139,          4833.3,        14.42695,    0,                   0}, //  139PM
{   61,  139,          5258.8,        14.42695,    0,                   0}, //  139PM
{   61,  139,          5506.1,        14.42695,    0,                   0}, //  139PM
{   61,  139,          6059.3,        14.42695,    0,                   0}, //  139PM
{   61,  139,          6722.4,        14.42695,    0,                   0}, //  139PM
{   61,  139,            7503,        14.42695,    0,                   0}, //  139PM
{   61,  139,            8445,        14.42695,    0,                   0}, //  139PM
{   61,  139,            9480,        14.42695,    0,                   0}, //  139PM
{   61,  139,           10592,        14.42695,    0,                   0}, //  139PM
{   61,  140,           4e-06,    5.150421e+11,    0,                   0}, //  140PM
{   61,  141,           628.4,        908.8979,    0,                   0}, //  141PM
{   61,  141,          2530.9,         2885.39,    0,                   0}, //  141PM
{   61,  142,          240.98,        1.586965,    0,                   0}, //  142PM
{   61,  142,          449.47,        23.80447,    0,                   0}, //  142PM
{   61,  142,          883.17,         2885390,    0,                   0}, //  142PM
{   61,  142,          2828.7,        96660.57,    0,                   0}, //  142PM
{   61,  142,          4015.2,        12.98426,    0,                   0}, //  142PM
{   61,  142,          4236.6,        4.039546,    0,                   0}, //  142PM
{   61,  143,          272.04,        1.529257,    0,                   0}, //  143PM
{   61,  143,          959.73,        34.62468,   11,           3.434e-26}, //  143PM
{   61,  143,          1898.4,         15.1483,   15,          3.8885e-26}, //  143PM
{   61,  143,          2929.9,        2.813255,    0,                   0}, //  143PM
{   61,  143,            4281,        2.596851,    0,                   0}, //  143PM
{   61,  144,           840.9,        1125.302,    0,                   0}, //  144PM
{   61,  144,          8595.8,        3895.277,    0,                   0}, //  144PM
{   61,  145,           61.25,        3.808715,    0,                   0}, //  145PM
{   61,  145,           794.6,        24.67009,    0,                   0}, //  145PM
{   61,  147,          91.105,        3.606738,    5,          1.6261e-26}, //  147PM
{   61,  147,          649.14,        38.95277,    0,                   0}, //  147PM
{   61,  148,           137.9,    5.146815e+15,    0,                   0}, //  148PM
{   61,  149,          114.31,        3.650018,    5,         1.07565e-26}, //  149PM
{   61,  149,          188.63,        4.717613,    3,          5.5045e-27}, //  149PM
{   61,  149,          240.21,        50494.33,    0,                   0}, //  149PM
{   61,  149,          270.17,         3.73658,    7,         1.10595e-26}, //  149PM
{   61,  149,          510.08,        4.328085,    0,                   0}, //  149PM
{   61,  152,           16.03,         3.02966,    0,                   0}, //  152PM
{   61,  152,             150,     6.50944e+11,    0,                   0}, //  152PM
{   61,  152,      150.000004,    1.194551e+12,    0,                   0}, //  152PM
{   61,  153,          32.194,        1.731234,    0,                   0}, //  153PM
{   61,  154,           4e-06,    1.497517e+11,    0,                   0}, //  154PM
{   61,  156,           4e-06,    3.851996e+10,    0,                   0}, //  156PM
{   62,  133,           5e-06,    5.049433e+09,    0,                   0}, //  133SM
{   62,  135,      100.000005,         30.2966,    0,                   0}, //  135SM
{   62,  136,          2264.7,        21640.43,    0,                   0}, //  136SM
{   62,  139,           457.4,    1.543684e+10,   11,           5.555e-27}, //  139SM
{   62,  140,          3172.1,        27.98828,   20,          -8.888e-27}, //  140SM
{   62,  140,          3210.9,        7.502014,   20,          6.4135e-26}, //  140SM
{   62,  140,          3652.8,        21.92896,    0,                   0}, //  140SM
{   62,  140,          3790.8,        10.96448,    0,                   0}, //  140SM
{   62,  141,             176,    1.956294e+12,   11,         -4.1915e-27}, //  141SM
{   62,  142,          2372.1,        245.2582,    0,                   0}, //  142SM
{   62,  142,          2420.1,         2.88539,    0,                   0}, //  142SM
{   62,  142,          3662.2,        692.4936,    0,                   0}, //  142SM
{   62,  142,            4547,        3.751007,    0,                   0}, //  142SM
{   62,  143,          753.99,    9.521787e+10,    0,                   0}, //  143SM
{   62,  143,          2793.8,    4.328085e+07,    0,                   0}, //  143SM
{   62,  144,          2323.6,        1269.572,    0,                   0}, //  144SM
{   62,  144,          3376.8,         2.22175,    0,                   0}, //  144SM
{   62,  144,          9232.8,        3.751007,    0,                   0}, //  144SM
{   62,  145,            1105,        19.47638,    0,                   0}, //  145SM
{   62,  145,            2050,        4.328085,    0,                   0}, //  145SM
{   62,  145,          3922.4,        1.586965,    0,                   0}, //  145SM
{   62,  145,          8786.2,        1384.987,    0,                   0}, //  145SM
{   62,  145,           11148,        10.67594,    0,                   0}, //  145SM
{   62,  147,          197.28,        1.803369,    3,         -1.3635e-27}, //  147SM
{   62,  148,          6694.3,        46.16624,    0,                   0}, //  148SM
{   62,  149,          22.507,        10.57495,    5,        -3.15019e-27}, //  149SM
{   62,  149,     3181.000004,         5.77078,    0,                   0}, //  149SM
{   62,  151,           4.821,        50.49433,    0,                   0}, //  151SM
{   62,  151,          91.532,        112.5302,    0,                   0}, //  151SM
{   62,  151,          261.13,        2019.773,    0,                   0}, //  151SM
{   62,  152,          121.78,        2.019773,    4,           4.242e-27}, //  152SM
{   62,  152,            2121,        3.462468,    0,                   0}, //  152SM
{   62,  153,           98.37,    1.529257e+07,    0,                   0}, //  153SM
{   62,  153,            98.4,    1.529257e+07,    0,                   0}, //  153SM
{   62,  153,           182.9,        24.52582,    0,                   0}, //  153SM
{   62,  154,          81.981,        4.356939,    4,           3.939e-27}, //  154SM
{   62,  156,           75.89,         2.88539,    0,                   0}, //  156SM
{   62,  156,          1397.5,        266.8986,    0,                   0}, //  156SM
{   62,  156,            1515,        6.492128,    0,                   0}, //  156SM
{   62,  158,          1279.1,        165.9099,    0,                   0}, //  158SM
{   62,  159,          1276.8,        165.9099,    0,                   0}, //  159SM
{   63,  136,           4e-06,    4.760894e+09,    0,                   0}, //  136EU
{   63,  136,           5e-06,    5.482241e+09,    0,                   0}, //  136EU
{   63,  140,           4e-06,    1.803369e+08,    0,                   0}, //  140EU
{   63,  140,      459.500004,          432.52,    0,                   0}, //  140EU
{   63,  141,           96.45,    3.895277e+09,    0,                   0}, //  141EU
{   63,  142,           4e-06,     1.05865e+11,   16,         1.50389e-26}, //  142EU
{   63,  142,      282.600004,        8.944709,    0,                   0}, //  142EU
{   63,  143,          389.51,        72134.75,    0,                   0}, //  143EU
{   63,  143,          2473.9,        8.367631,    0,                   0}, //  143EU
{   63,  144,             926,        40.10692,    0,                   0}, //  144EU
{   63,  144,          1127.6,        1442.695,    0,                   0}, //  144EU
{   63,  144,            1338,        7.213475,    0,                   0}, //  144EU
{   63,  145,             716,        706.9206,   11,          3.7673e-26}, //  145EU
{   63,  145,          2836.4,        7.934823,    0,                   0}, //  145EU
{   63,  145,          8527.7,        5.337972,    0,                   0}, //  145EU
{   63,  146,          666.37,        339033.3,    0,                   0}, //  146EU
{   63,  146,          1768.7,        6.492128,    0,                   0}, //  146EU
{   63,  147,          625.27,        1103.662,   11,         3.56025e-26}, //  147EU
{   63,  148,           720.4,        233.7166,   18,          3.0906e-26}, //  148EU
{   63,  149,          496.39,        3534.603,   11,         3.52995e-26}, //  149EU
{   63,  150,            42.1,    6.647939e+13,    0,                   0}, //  150EU
{   63,  150,           588.8,        64.92128,    0,                   0}, //  150EU
{   63,  151,          21.541,        13.84987,    7,        1.308455e-26}, //  151EU
{   63,  151,          196.25,        84974.74,    0,                   0}, //  151EU
{   63,  152,            45.6,    4.836202e+13,    0,                   0}, //  152EU
{   63,  152,          65.297,        1356.133,    0,                   0}, //  152EU
{   63,  152,          77.259,        54.82241,    0,                   0}, //  152EU
{   63,  152,          78.233,        238.0447,    0,                   0}, //  152EU
{   63,  152,           89.85,        553.9949,    0,                   0}, //  152EU
{   63,  152,          108.11,         28.8539,    0,                   0}, //  152EU
{   63,  152,          141.83,        3.606738,    0,                   0}, //  152EU
{   63,  152,          147.81,    8.309923e+12,    0,                   0}, //  152EU
{   63,  152,          147.86,    8.309923e+12,    0,                   0}, //  152EU
{   63,  152,          158.06,        2.596851,    0,                   0}, //  152EU
{   63,  152,          160.88,        3.318199,    0,                   0}, //  152EU
{   63,  152,          180.63,         3.02966,    0,                   0}, //  152EU
{   63,  152,          286.47,        5.049433,    0,                   0}, //  152EU
{   63,  153,          103.18,        5.554376,    3,         1.03424e-26}, //  153EU
{   63,  153,            1771,        685.2801,    0,                   0}, //  153EU
{   63,  153,          3101.5,        12.40718,    0,                   0}, //  153EU
{   63,  154,           68.17,        3173.929,    0,                   0}, //  154EU
{   63,  154,           82.82,         28.8539,    0,                   0}, //  154EU
{   63,  154,          99.948,         2.88539,    0,                   0}, //  154EU
{   63,  154,          100.86,        77.90553,    0,                   0}, //  154EU
{   63,  154,          127.43,        14.42695,    0,                   0}, //  154EU
{   63,  154,          129.68,         2.88539,    0,                   0}, //  154EU
{   63,  154,           145.3,    3.981838e+12,    0,                   0}, //  154EU
{   63,  154,           145.3,    4.007807e+12,    0,                   0}, //  154EU
{   63,  155,          245.78,        1.947638,    0,                   0}, //  155EU
{   63,  156,           87.49,        17.31234,    0,                   0}, //  156EU
{   64,  138,          2232.7,         8656.17,    0,                   0}, //  138GD
{   64,  139,           4e-06,    6.924936e+09,    0,                   0}, //  139GD
{   64,  141,           377.8,    3.534603e+10,    0,                   0}, //  141GD
{   64,  143,           152.6,    1.586965e+11,    0,                   0}, //  143GD
{   64,  144,          2471.6,        18.75504,    0,                   0}, //  144GD
{   64,  144,          3433.1,        209.1908,    0,                   0}, //  144GD
{   64,  145,            27.3,        16.59099,    0,                   0}, //  145GD
{   64,  145,           749.1,    1.226291e+11,   11,           -5.05e-27}, //  145GD
{   64,  145,          2200.1,        29.43098,    0,                   0}, //  145GD
{   64,  146,          1579.3,        1.529257,    6,          1.0605e-26}, //  146GD
{   64,  146,          2981.9,         10.3874,   14,           4.545e-26}, //  146GD
{   64,  146,          8029.4,        2.164043,    0,                   0}, //  146GD
{   64,  146,          8914.9,        6.203589,   40,           6.363e-26}, //  146GD
{   64,  147,           997.1,        30.87367,   13,         2.45935e-27}, //  147GD
{   64,  147,          2760.5,        6.492128,   21,           3.838e-26}, //  147GD
{   64,  147,          3581.9,        38.66423,   27,          5.7267e-26}, //  147GD
{   64,  147,          8587.8,        735.7745,    0,                   0}, //  147GD
{   64,  148,          2694.6,        23.94874,   18,          -8.181e-28}, //  148GD
{   64,  148,          6834.9,        2.164043,    0,                   0}, //  148GD
{   64,  148,           13870,         2.88539,   70,          1.0605e-25}, //  148GD
{   64,  149,          164.99,        2.452582,    5,          -4.545e-27}, //  149GD
{   64,  149,          873.35,        2.308312,    0,                   0}, //  149GD
{   64,  149,            3387,         8.65617,    0,                   0}, //  149GD
{   64,  149,          6656.4,        4.760894,    0,                   0}, //  149GD
{   64,  151,          108.09,        4.039546,    5,          -5.454e-27}, //  151GD
{   64,  153,          41.557,        5.886196,    0,                   0}, //  153GD
{   64,  153,           95.17,        5049.433,    0,                   0}, //  153GD
{   64,  153,          95.174,        5049.433,    0,                   0}, //  153GD
{   64,  153,          129.16,        3.635592,    3,          1.8685e-27}, //  153GD
{   64,  153,          171.19,        109644.8,    0,                   0}, //  153GD
{   64,  154,          123.07,        1.708151,    4,          4.5955e-27}, //  154GD
{   64,  154,          2137.5,        98.10326,    0,                   0}, //  154GD
{   64,  155,          86.547,        9.377518,    5,        -2.65125e-27}, //  155GD
{   64,  155,          105.31,        1.673526,    3,          7.2215e-28}, //  155GD
{   64,  155,          121.05,    4.612296e+07,    0,                   0}, //  155GD
{   64,  156,           88.97,        3.188356,    4,          3.9087e-27}, //  156GD
{   64,  156,          2137.6,        1875.504,    0,                   0}, //  156GD
{   64,  157,          63.917,        663.6397,    5,         -2.3432e-27}, //  157GD
{   64,  157,             425,        26689.86,    0,                   0}, //  157GD
{   64,  157,           426.6,        26689.86,    0,                   0}, //  157GD
{   64,  158,          79.513,        3.635592,    4,          3.8481e-27}, //  158GD
{   64,  158,      260.000004,        685280.1,    0,                   0}, //  158GD
{   64,  159,          67.829,        37.79861,    0,                   0}, //  159GD
{   64,  160,           75.26,        3.924131,    4,          3.6865e-27}, //  160GD
{   65,  138,           4e-06,         288.539,    0,                   0}, //  138TB
{   65,  141,           4e-06,    1.139729e+10,    0,                   0}, //  141TB
{   65,  142,           279.7,    4.371366e+08,    0,                   0}, //  142TB
{   65,  142,           279.8,    4.371366e+08,    0,                   0}, //  142TB
{   65,  142,           652.1,        37510.07,    0,                   0}, //  142TB
{   65,  143,           4e-06,     3.02966e+10,    0,                   0}, //  143TB
{   65,  144,           396.9,    6.131454e+09,    0,                   0}, //  144TB
{   65,  144,           476.2,        4039.546,    0,                   0}, //  144TB
{   65,  144,           517.1,        966.6057,    0,                   0}, //  144TB
{   65,  144,           544.5,        432.8085,    0,                   0}, //  144TB
{   65,  145,           5e-06,    4.457928e+10,    0,                   0}, //  145TB
{   65,  146,           4e-06,    3.318199e+10,    0,                   0}, //  146TB
{   65,  146,      779.600004,         1702380,    0,                   0}, //  146TB
{   65,  147,            50.6,    1.584079e+11,    0,                   0}, //  147TB
{   65,  147,          253.19,        1.875504,    0,                   0}, //  147TB
{   65,  147,          353.98,         2.88539,    0,                   0}, //  147TB
{   65,  147,           719.2,        1.875504,    0,                   0}, //  147TB
{   65,  147,          1316.4,        6.492128,    0,                   0}, //  147TB
{   65,  147,          3042.5,        5.482241,    0,                   0}, //  147TB
{   65,  147,            7762,        2.596851,    0,                   0}, //  147TB
{   65,  148,            90.1,    1.904357e+11,    0,                   0}, //  148TB
{   65,  148,           109.6,        115.4156,    0,                   0}, //  148TB
{   65,  148,           178.4,        10.09887,    0,                   0}, //  148TB
{   65,  148,           327.9,        6.492128,    0,                   0}, //  148TB
{   65,  148,          1095.8,        31.73929,    0,                   0}, //  148TB
{   65,  148,          8618.6,        1889.931,    0,                   0}, //  148TB
{   65,  149,           35.78,    3.600967e+11,    0,                   0}, //  149TB
{   65,  149,          2518.4,        3.462468,    0,                   0}, //  149TB
{   65,  149,          9955.3,         5.77078,    0,                   0}, //  149TB
{   65,  150,             474,    5.020579e+11,    0,                   0}, //  150TB
{   65,  151,          22.922,        5.842915,    0,                   0}, //  151TB
{   65,  151,           99.53,    3.606738e+10,    0,                   0}, //  151TB
{   65,  152,          342.15,        1384.987,    0,                   0}, //  152TB
{   65,  152,          501.74,    3.635592e+11,    0,                   0}, //  152TB
{   65,  152,           600.3,         2.88539,    0,                   0}, //  152TB
{   65,  152,           806.1,         2.88539,    0,                   0}, //  152TB
{   65,  152,          1212.4,         2.88539,    0,                   0}, //  152TB
{   65,  152,          1230.1,         2.88539,    0,                   0}, //  152TB
{   65,  152,          1237.7,        6.059319,    0,                   0}, //  152TB
{   65,  152,          1349.2,         2.88539,    0,                   0}, //  152TB
{   65,  152,          1370.2,         2.88539,    0,                   0}, //  152TB
{   65,  152,          1712.1,         2.88539,    0,                   0}, //  152TB
{   65,  152,          1887.7,         2.88539,    0,                   0}, //  152TB
{   65,  152,          1887.8,         2.88539,    0,                   0}, //  152TB
{   65,  152,          1920.3,         2.88539,    0,                   0}, //  152TB
{   65,  152,          2269.3,         2.88539,    0,                   0}, //  152TB
{   65,  152,          2499.4,         2.88539,    0,                   0}, //  152TB
{   65,  152,          2889.4,         2.88539,    0,                   0}, //  152TB
{   65,  152,          3126.7,         2.88539,    0,                   0}, //  152TB
{   65,  152,          3218.3,         2.88539,    0,                   0}, //  152TB
{   65,  152,          3596.2,         2.88539,    0,                   0}, //  152TB
{   65,  152,          3845.3,         2.88539,    0,                   0}, //  152TB
{   65,  152,          4350.2,         2.88539,    0,                   0}, //  152TB
{   65,  153,          163.18,        268341.3,    0,                   0}, //  153TB
{   65,  154,           2e-06,        740.1026,    0,                   0}, //  154TB
{   65,  154,           4e-06,     4.88208e+13,    6,            8.08e-27}, //  154TB
{   65,  154,           5e-06,     1.17897e+14,   14,           4.545e-27}, //  154TB
{   65,  156,       49.600004,    1.267263e+14,    0,                   0}, //  156TB
{   65,  156,           49.63,        70.69206,    0,                   0}, //  156TB
{   65,  156,            88.4,    2.752662e+13,    0,                   0}, //  156TB
{   65,  158,           110.3,    1.543684e+10,    0,                   0}, //  158TB
{   65,  158,           388.4,          577078,    0,                   0}, //  158TB
{   65,  160,          63.685,         86.5617,    0,                   0}, //  160TB
{   65,  160,           64.11,         2.88539,    0,                   0}, //  160TB
{   65,  160,          138.74,        8.223362,    0,                   0}, //  160TB
{   66,  140,          2166.1,        10098.87,    0,                   0}, //  140DY
{   66,  143,           310.7,    4.328085e+09,    0,                   0}, //  143DY
{   66,  143,           405.7,        1731.234,    0,                   0}, //  143DY
{   66,  145,           118.2,      2.0342e+10,    0,                   0}, //  145DY
{   66,  146,          2935.7,    2.164043e+08,    0,                   0}, //  146DY
{   66,  147,           750.5,    7.963677e+10,    0,                   0}, //  147DY
{   66,  147,           750.7,    7.963677e+10,    0,                   0}, //  147DY
{   66,  147,          2680.6,        10.09887,    0,                   0}, //  147DY
{   66,  147,          3407.2,         577.078,    0,                   0}, //  147DY
{   66,  147,          3650.6,        23.08312,    0,                   0}, //  147DY
{   66,  148,          2832.2,        93.77518,    0,                   0}, //  148DY
{   66,  148,          2919.1,        679.5094,    0,                   0}, //  148DY
{   66,  149,          1073.2,        18.03369,    0,                   0}, //  149DY
{   66,  149,          2661.1,    7.069206e+08,    0,                   0}, //  149DY
{   66,  149,          8520.5,        40.39546,    0,                   0}, //  149DY
{   66,  150,            3026,        1.586965,    0,                   0}, //  150DY
{   66,  150,            4567,        2.452582,    0,                   0}, //  150DY
{   66,  151,          2958.6,        1.875504,    0,                   0}, //  151DY
{   66,  151,          4903.9,        8.511901,    0,                   0}, //  151DY
{   66,  151,          6032.2,        17.16807,    0,                   0}, //  151DY
{   66,  152,          3160.6,        5.626511,    0,                   0}, //  152DY
{   66,  152,          5088.1,         86.5617,    0,                   0}, //  152DY
{   66,  152,          6129.4,         13.7056,   42,           5.858e-26}, //  152DY
{   66,  152,          7881.9,        2.308312,    0,                   0}, //  152DY
{   66,  153,          108.81,        1.947638,    0,                   0}, //  153DY
{   66,  153,          5592.1,        3.318199,    0,                   0}, //  153DY
{   66,  155,          39.384,        4.818601,    0,                   0}, //  155DY
{   66,  155,          86.767,        1.586965,    0,                   0}, //  155DY
{   66,  155,          132.19,        73.57745,    0,                   0}, //  155DY
{   66,  155,          224.53,        7.213475,    0,                   0}, //  155DY
{   66,  155,          234.33,         8656.17,    0,                   0}, //  155DY
{   66,  157,          161.99,        1875.504,    0,                   0}, //  157DY
{   66,  157,          199.38,    3.116221e+07,    0,                   0}, //  157DY
{   66,  157,           199.5,    3.116221e+07,    0,                   0}, //  157DY
{   66,  157,           435.6,         2.88539,    0,                   0}, //  157DY
{   66,  157,          5004.1,         2.88539,    0,                   0}, //  157DY
{   66,  158,          98.918,        2.394874,    4,           3.636e-27}, //  158DY
{   66,  159,          177.61,        13.41706,    0,                   0}, //  159DY
{   66,  159,          208.99,        1.947638,    0,                   0}, //  159DY
{   66,  159,          352.77,        176008.8,    0,                   0}, //  159DY
{   66,  160,          86.788,        2.914244,    4,         3.65115e-27}, //  160DY
{   66,  160,          1358.7,        3.895277,    0,                   0}, //  160DY
{   66,  161,          25.651,        41.98243,    5,          2.9997e-27}, //  161DY
{   66,  161,          74.567,        4.530062,    3,        -2.03515e-27}, //  161DY
{   66,  162,          80.661,        3.159502,    4,          3.4643e-27}, //  162DY
{   66,  162,          1485.7,        2.769974,    0,                   0}, //  162DY
{   66,  163,          73.445,         2.17847,    0,                   0}, //  163DY
{   66,  164,          73.392,        3.448041,    4,          3.4542e-27}, //  164DY
{   66,  165,          108.16,    1.088081e+11,    0,                   0}, //  165DY
{   66,  165,          158.59,        2.596851,    0,                   0}, //  165DY
{   66,  165,          180.92,        3.606738,    0,                   0}, //  165DY
{   67,  141,              66,        9521.787,    0,                   0}, //  141HO
{   67,  144,           265.3,        730.0037,    0,                   0}, //  144HO
{   67,  147,          2353.4,         28.8539,    0,                   0}, //  147HO
{   67,  147,          2687.1,        454.4489,    0,                   0}, //  147HO
{   67,  148,           4e-06,    1.383545e+10,    0,                   0}, //  148HO
{   67,  148,      694.400004,         3404760,    0,                   0}, //  148HO
{   67,  149,            48.8,    8.079092e+10,    0,                   0}, //  149HO
{   67,  149,            2738,        85.11901,    0,                   0}, //  149HO
{   67,  149,            7200,        144.2695,    0,                   0}, //  149HO
{   67,  150,             800,    3.361479e+10,    0,                   0}, //  150HO
{   67,  150,            1896,        25.96851,    0,                   0}, //  150HO
{   67,  150,          3425.4,        121.1864,    0,                   0}, //  150HO
{   67,  151,              41,    6.809521e+10,    0,                   0}, //  151HO
{   67,  151,          8340.9,        13.27279,    0,                   0}, //  151HO
{   67,  152,             160,    7.213475e+10,   18,          2.9997e-26}, //  152HO
{   67,  152,          3019.6,        12118.64,    0,                   0}, //  152HO
{   67,  152,          4883.8,        7.213475,    0,                   0}, //  152HO
{   67,  152,          5997.9,        67.80667,    0,                   0}, //  152HO
{   67,  153,            68.7,    8.050238e+11,    1,          6.0095e-27}, //  153HO
{   67,  153,            2772,        330.3772,    0,                   0}, //  153HO
{   67,  153,            7598,         4.25595,    0,                   0}, //  153HO
{   67,  154,           4e-06,    2.683413e+11,   16,         2.84315e-26}, //  154HO
{   67,  155,          141.97,         1269572,    0,                   0}, //  155HO
{   67,  156,            52.4,     1.37056e+10,    0,                   0}, //  156HO
{   67,  156,       52.400004,    6.751813e+11,    0,                   0}, //  156HO
{   67,  156,            82.1,        1.990919,    0,                   0}, //  156HO
{   67,  156,           117.5,        83.67631,    0,                   0}, //  156HO
{   67,  157,          53.048,         28.8539,    0,                   0}, //  157HO
{   67,  158,          67.199,    2.423728e+12,    4,          1.2322e-26}, //  158HO
{   67,  158,            67.2,    2.423728e+12,    0,                   0}, //  158HO
{   67,  158,          146.71,        2.668986,    0,                   0}, //  158HO
{   67,  158,           156.9,        41.83816,    0,                   0}, //  158HO
{   67,  158,             180,    1.843764e+12,    0,                   0}, //  158HO
{   67,  159,          205.91,    1.197437e+10,    0,                   0}, //  159HO
{   67,  160,           59.98,    2.607238e+13,    4,          1.2726e-26}, //  160HO
{   67,  160,          107.27,        69.24936,    0,                   0}, //  160HO
{   67,  160,          118.44,        80.79092,    0,                   0}, //  160HO
{   67,  160,      169.600004,    4.328085e+09,    0,                   0}, //  160HO
{   67,  161,          211.15,    9.752618e+09,    0,                   0}, //  161HO
{   67,  162,           38.34,        1.731234,    0,                   0}, //  162HO
{   67,  162,          105.87,    5.799634e+12,   12,           1.818e-26}, //  162HO
{   67,  162,           179.8,        12.55145,    0,                   0}, //  162HO
{   67,  163,          297.88,    1.572538e+09,    0,                   0}, //  163HO
{   67,  163,          1505.2,        21.64043,    0,                   0}, //  163HO
{   67,  164,           37.34,        4.039546,    0,                   0}, //  164HO
{   67,  164,          139.77,    3.246064e+12,    0,                   0}, //  164HO
{   67,  164,           139.8,    3.246064e+12,    0,                   0}, //  164HO
{   67,  164,           342.8,        3.751007,    0,                   0}, //  164HO
{   67,  165,          361.68,        2181.355,    0,                   0}, //  165HO
{   67,  165,          715.33,        144.2695,    0,                   0}, //  165HO
{   67,  166,           5.969,    5.463342e+19,   14,           1.818e-26}, //  166HO
{   67,  166,          54.239,        4.962871,    4,           3.434e-28}, //  166HO
{   67,  166,           190.9,        266898.6,    0,                   0}, //  166HO
{   67,  166,          295.08,        1.586965,    0,                   0}, //  166HO
{   67,  167,          259.34,         8656.17,    0,                   0}, //  167HO
{   67,  168,              59,    1.904357e+11,    0,                   0}, //  168HO
{   67,  168,          143.43,         5770.78,    0,                   0}, //  168HO
{   67,  168,          192.57,        155.8111,    0,                   0}, //  168HO
{   67,  170,             120,    6.203589e+10,    0,                   0}, //  170HO
{   68,  145,             253,    1.298426e+09,    0,                   0}, //  145ER
{   68,  147,           4e-06,    3.606738e+09,    0,                   0}, //  147ER
{   68,  148,          2913.2,        18755.04,    0,                   0}, //  148ER
{   68,  149,           741.8,    1.283999e+10,    0,                   0}, //  149ER
{   68,  149,          2611.1,         880.044,    0,                   0}, //  149ER
{   68,  149,     3242.700004,        6924.936,    0,                   0}, //  149ER
{   68,  150,          2733.8,         28.8539,    0,                   0}, //  150ER
{   68,  150,            2797,        3678.872,    0,                   0}, //  150ER
{   68,  150,          7372.4,        21.64043,    0,                   0}, //  150ER
{   68,  150,            9509,        62.03589,    0,                   0}, //  150ER
{   68,  151,          1140.3,        14.42695,    0,                   0}, //  151ER
{   68,  151,          2585.5,    8.367631e+08,    0,                   0}, //  151ER
{   68,  151,            2586,    8.367631e+08,    0,                   0}, //  151ER
{   68,  151,           10287,        605.9319,    0,                   0}, //  151ER
{   68,  152,          2183.3,        2.596851,   16,          -2.828e-27}, //  152ER
{   68,  152,          4519.7,        1.731234,   32,          2.3432e-26}, //  152ER
{   68,  152,          4685.4,        6.636397,    0,                   0}, //  152ER
{   68,  152,          9712.9,        50.49433,    0,                   0}, //  152ER
{   68,  152,           13388,        15.86965,    0,                   0}, //  152ER
{   68,  153,          2798.2,        538.1253,    0,                   0}, //  153ER
{   68,  153,          2992.7,        14.42695,    0,                   0}, //  153ER
{   68,  153,          3939.5,        14.42695,    0,                   0}, //  153ER
{   68,  153,          5248.1,        357.7884,    0,                   0}, //  153ER
{   68,  154,            3025,        56.26511,   22,          8.5345e-28}, //  154ER
{   68,  155,          563.22,        50.20579,   13,         -2.7775e-27}, //  155ER
{   68,  157,            10.3,        9.810326,    0,                   0}, //  157ER
{   68,  157,           36.17,        1.875504,    0,                   0}, //  157ER
{   68,  157,           155.4,    1.096448e+08,    0,                   0}, //  157ER
{   68,  159,           182.6,        486.1882,    0,                   0}, //  159ER
{   68,  159,          429.05,        851.1901,    0,                   0}, //  159ER
{   68,  161,          189.42,        121.1864,    0,                   0}, //  161ER
{   68,  161,          267.45,         2.88539,    0,                   0}, //  161ER
{   68,  161,          396.44,        10820.21,    0,                   0}, //  161ER
{   68,  161,             397,        10820.21,    0,                   0}, //  161ER
{   68,  162,          102.04,        1.861077,    0,                   0}, //  162ER
{   68,  163,           69.23,        11.97437,    0,                   0}, //  163ER
{   68,  163,           445.5,        836.7631,    0,                   0}, //  163ER
{   68,  164,           91.38,        2.120762,    4,         3.51985e-27}, //  164ER
{   68,  164,            1985,        33.18199,    0,                   0}, //  164ER
{   68,  164,          3376.1,        245.2582,    0,                   0}, //  164ER
{   68,  165,          47.159,         5.77078,    0,                   0}, //  165ER
{   68,  165,           551.3,        360.6738,    0,                   0}, //  165ER
{   68,  166,          80.578,        2.618491,    4,         3.23705e-27}, //  166ER
{   68,  167,           207.8,    3.273475e+09,    0,                   0}, //  167ER
{   68,  167,          264.87,        2.120762,    0,                   0}, //  167ER
{   68,  168,          79.804,        2.673314,    4,          3.2421e-27}, //  168ER
{   68,  168,            1094,        157.2538,    8,           4.848e-27}, //  168ER
{   68,  169,           92.05,        411.1681,    0,                   0}, //  169ER
{   68,  169,          243.69,         288.539,    0,                   0}, //  169ER
{   68,  170,          78.599,        2.728136,    4,         3.19665e-27}, //  170ER
{   68,  170,          1268.7,        60.59319,    0,                   0}, //  170ER
{   68,  171,           198.6,         302.966,    0,                   0}, //  171ER
{   69,  146,             180,     1.03874e+08,    0,                   0}, //  146TM
{   69,  147,              68,        519370.2,    0,                   0}, //  147TM
{   69,  148,           4e-06,    1.009887e+09,    0,                   0}, //  148TM
{   69,  150,           671.6,         7502014,    0,                   0}, //  150TM
{   69,  151,           4e-06,    9.521787e+09,    0,                   0}, //  151TM
{   69,  151,          2655.7,        650.6555,    0,                   0}, //  151TM
{   69,  151,          6908.5,        34.62468,    0,                   0}, //  151TM
{   69,  152,           4e-06,    7.502014e+09,    0,                   0}, //  152TM
{   69,  152,     2554.900004,        424.1523,    0,                   0}, //  152TM
{   69,  152,     2555.100004,        424.1523,    0,                   0}, //  152TM
{   69,  152,            6300,        60.59319,    0,                   0}, //  152TM
{   69,  153,            43.2,    3.606738e+09,    0,                   0}, //  153TM
{   69,  154,           4e-06,    4.760894e+09,   18,         2.98455e-26}, //  154TM
{   69,  155,              41,    6.492128e+10,    0,                   0}, //  155TM
{   69,  156,      203.600004,         577.078,    0,                   0}, //  156TM
{   69,  158,           4e-06,     2.88539e+10,    0,                   0}, //  158TM
{   69,  158,           5e-06,        23.08312,    0,                   0}, //  158TM
{   69,  158,            74.1,        2.510289,    0,                   0}, //  158TM
{   69,  159,          166.17,        54.10106,    0,                   0}, //  159TM
{   69,  160,            42.1,        2.308312,    0,                   0}, //  160TM
{   69,  160,              70,    1.074808e+11,    0,                   0}, //  160TM
{   69,  160,       98.200004,         288.539,    0,                   0}, //  160TM
{   69,  160,          174.38,        24.52582,    0,                   0}, //  160TM
{   69,  161,            18.9,        72.13475,    0,                   0}, //  161TM
{   69,  161,            78.2,        158.6965,    0,                   0}, //  161TM
{   69,  162,           4e-06,    3.505749e+10,    0,                   0}, //  162TM
{   69,  162,          44.651,        2.077481,    0,                   0}, //  162TM
{   69,  162,             129,    3.505749e+10,    0,                   0}, //  162TM
{   69,  162,          163.35,        1.586965,    0,                   0}, //  162TM
{   69,  163,           86.92,        548.2241,    0,                   0}, //  163TM
{   69,  163,          164.69,        62.03589,    0,                   0}, //  163TM
{   69,  163,           290.3,        62.03589,    0,                   0}, //  163TM
{   69,  163,          436.89,        12.26291,    0,                   0}, //  163TM
{   69,  163,           804.8,        12.26291,    0,                   0}, //  163TM
{   69,  164,           4e-06,    4.414647e+11,    0,                   0}, //  164TM
{   69,  164,      124.040004,        51.93702,    0,                   0}, //  164TM
{   69,  164,      140.990004,        7.213475,    0,                   0}, //  164TM
{   69,  165,           80.37,        115415.6,    0,                   0}, //  165TM
{   69,  165,          160.47,        12984.26,    0,                   0}, //  165TM
{   69,  166,      109.340004,    4.905163e+08,    0,                   0}, //  166TM
{   69,  166,      231.050004,        51.93702,    0,                   0}, //  166TM
{   69,  167,          179.48,        1673.526,    0,                   0}, //  167TM
{   69,  167,          292.82,        1298.426,    0,                   0}, //  167TM
{   69,  169,          8.4102,        5.900623,    3,         2.59974e-27}, //  169TM
{   69,  169,          316.15,        952.0345,    7,           7.878e-28}, //  169TM
{   69,  169,          379.27,        75.30868,    7,          1.5352e-26}, //  169TM
{   69,  170,          38.714,        2.467009,    0,                   0}, //  170TM
{   69,  170,           183.2,        5943.904,    0,                   0}, //  170TM
{   69,  171,          5.0361,        6.881655,    0,                   0}, //  171TM
{   69,  171,          424.96,        3751.007,    0,                   0}, //  171TM
{   69,  171,          635.54,        1.817796,    7,          5.8075e-27}, //  171TM
{   69,  172,          407.34,        1.543684,    0,                   0}, //  172TM
{   69,  172,          535.14,        1.760088,    0,                   0}, //  172TM
{   69,  173,          317.73,        14426.95,    0,                   0}, //  173TM
{   69,  177,           4e-06,    1.298426e+11,    0,                   0}, //  177TM
{   70,  151,           4e-06,    2.308312e+09,    0,                   0}, //  151YB
{   70,  151,     1791.200005,        3751.007,    0,                   0}, //  151YB
{   70,  151,     2448.000006,         28853.9,    0,                   0}, //  151YB
{   70,  152,          2743.8,        43280.85,    0,                   0}, //  152YB
{   70,  152,          2744.5,        43280.85,    0,                   0}, //  152YB
{   70,  153,          1201.7,         8.65617,    0,                   0}, //  153YB
{   70,  153,     2578.200004,        21640.43,    0,                   0}, //  153YB
{   70,  154,          2046.2,        40.39546,    0,                   0}, //  154YB
{   70,  154,          4479.1,        26.83413,    0,                   0}, //  154YB
{   70,  156,          3028.3,         8.65617,    0,                   0}, //  156YB
{   70,  157,           529.3,        64.92128,   13,         -3.7875e-27}, //  157YB
{   70,  163,           53.88,        5.482241,    0,                   0}, //  163YB
{   70,  163,            58.1,        14.42695,    0,                   0}, //  163YB
{   70,  163,            99.2,        14.42695,    0,                   0}, //  163YB
{   70,  163,             124,        14.42695,    0,                   0}, //  163YB
{   70,  163,          133.06,        1.659099,    0,                   0}, //  163YB
{   70,  163,           167.6,        3.419187,    0,                   0}, //  163YB
{   70,  165,           126.8,        432.8085,    0,                   0}, //  165YB
{   70,  165,          132.52,        4.039546,    0,                   0}, //  165YB
{   70,  165,           209.9,        2.164043,    0,                   0}, //  165YB
{   70,  165,          217.15,        1.817796,    0,                   0}, //  165YB
{   70,  166,          102.37,        1.788942,    0,                   0}, //  166YB
{   70,  166,          2233.4,        14.42695,    0,                   0}, //  166YB
{   70,  167,          29.658,        20.19773,    0,                   0}, //  167YB
{   70,  167,          33.909,        23.08312,    0,                   0}, //  167YB
{   70,  167,          188.75,        33.18199,    0,                   0}, //  167YB
{   70,  167,          571.55,        259.6851,    0,                   0}, //  167YB
{   70,  168,           87.73,        2.149616,    0,                   0}, //  168YB
{   70,  168,            1197,        1.875504,    0,                   0}, //  168YB
{   70,  168,            1543,        1.586965,    0,                   0}, //  168YB
{   70,  168,          1998.7,         118.301,    0,                   0}, //  168YB
{   70,  168,          2222.4,        89.44709,    0,                   0}, //  168YB
{   70,  169,            24.2,    6.636397e+10,    1,         2.56035e-27}, //  169YB
{   70,  169,          191.21,        4.833028,    0,                   0}, //  169YB
{   70,  170,          84.255,        2.315526,    4,          3.4037e-27}, //  170YB
{   70,  170,          1258.5,        533.7972,    0,                   0}, //  170YB
{   70,  170,          2189.7,        3.606738,    0,                   0}, //  170YB
{   70,  171,          75.882,         2.36602,    5,         5.12575e-27}, //  171YB
{   70,  171,          95.282,         7574149,    0,                   0}, //  171YB
{   70,  171,          122.42,        382.3142,    0,                   0}, //  171YB
{   70,  172,          78.743,        2.380447,    4,         3.37845e-27}, //  172YB
{   70,  172,          1172.4,        11.74354,    6,          3.2825e-27}, //  172YB
{   70,  172,          1550.4,        5193.702,    0,                   0}, //  172YB
{   70,  173,           398.9,        4183.816,    0,                   0}, //  173YB
{   70,  174,          76.471,        2.582424,    4,          3.4138e-27}, //  174YB
{   70,  174,          1518.1,         1197437,    0,                   0}, //  174YB
{   70,  175,          514.87,     9.83918e+07,    0,                   0}, //  175YB
{   70,  176,          82.135,        2.539143,    4,          3.3835e-27}, //  176YB
{   70,  176,          1049.8,    1.644672e+10,    0,                   0}, //  176YB
{   70,  176,          1050.3,    1.644672e+10,    0,                   0}, //  176YB
{   70,  177,           104.5,        6.463274,    0,                   0}, //  177YB
{   70,  177,           331.5,    9.247675e+09,    0,                   0}, //  177YB
{   71,  150,              34,        43280.85,    0,                   0}, //  150LU
{   71,  151,              78,        23083.12,    0,                   0}, //  151LU
{   71,  153,          2502.5,        144.2695,    0,                   0}, //  153LU
{   71,  153,          2632.9,        21640.43,    0,                   0}, //  153LU
{   71,  154,           4e-06,    1.615818e+09,    0,                   0}, //  154LU
{   71,  154,      130.400005,        50494.33,    0,                   0}, //  154LU
{   71,  155,              20,    1.990919e+08,    0,                   0}, //  155LU
{   71,  155,            1781,         3880850,    0,                   0}, //  155LU
{   71,  156,           4e-06,    2.856536e+08,    0,                   0}, //  156LU
{   71,  157,              26,    6.910509e+09,    0,                   0}, //  157LU
{   71,  160,           4e-06,     5.77078e+10,    0,                   0}, //  160LU
{   71,  161,      166.500004,    1.053167e+07,    0,                   0}, //  161LU
{   71,  162,           4e-06,    1.298426e+11,    0,                   0}, //  162LU
{   71,  162,           5e-06,    1.644672e+11,    0,                   0}, //  162LU
{   71,  166,           34.37,     1.22052e+11,    0,                   0}, //  166LU
{   71,  166,              43,    1.835108e+11,    0,                   0}, //  166LU
{   71,  166,            83.5,        132.7279,    0,                   0}, //  166LU
{   71,  167,           4e-06,     8.65617e+10,    1,        -5.04495e-28}, //  167LU
{   71,  168,          202.81,    5.799634e+11,    6,         6.16605e-27}, //  168LU
{   71,  169,              29,    2.308312e+11,    1,          2.7169e-27}, //  169LU
{   71,  170,           44.51,        4.328085,    0,                   0}, //  170LU
{   71,  170,           92.91,    9.666057e+08,    0,                   0}, //  170LU
{   71,  170,              93,    9.666057e+08,    0,                   0}, //  170LU
{   71,  170,           98.53,        3.751007,    0,                   0}, //  170LU
{   71,  170,          164.73,        5.626511,    0,                   0}, //  170LU
{   71,  171,            71.1,    1.139729e+11,    0,                   0}, //  171LU
{   71,  171,           71.13,    1.139729e+11,    1,         2.95425e-27}, //  171LU
{   71,  171,          208.15,        42.84804,    0,                   0}, //  171LU
{   71,  172,           41.86,    3.202783e+11,    0,                   0}, //  172LU
{   71,  172,           65.79,        478.9748,    0,                   0}, //  172LU
{   71,  172,          109.41,        634785.8,    0,                   0}, //  172LU
{   71,  172,          109.85,        3.318199,    0,                   0}, //  172LU
{   71,  172,          213.57,        216.4043,    0,                   0}, //  172LU
{   71,  173,          123.67,          107048,    0,                   0}, //  173LU
{   71,  173,          128.34,        7.502014,    0,                   0}, //  173LU
{   71,  174,          170.83,    1.770043e+16,    0,                   0}, //  174LU
{   71,  174,          240.82,        569.8645,    0,                   0}, //  174LU
{   71,  174,          365.18,        209.1908,    0,                   0}, //  174LU
{   71,  174,          431.41,        2.164043,    0,                   0}, //  174LU
{   71,  175,          353.48,        2149.616,    0,                   0}, //  175LU
{   71,  175,          396.33,         4.73204,    0,                   0}, //  175LU
{   71,  175,          626.53,        15.29257,    0,                   0}, //  175LU
{   71,  175,          1392.2,         1419612,    0,                   0}, //  175LU
{   71,  176,          122.84,    1.902915e+13,    2,          1.6059e-27}, //  176LU
{   71,  176,          194.36,        50.49433,    0,                   0}, //  176LU
{   71,  176,          424.89,         2.88539,    0,                   0}, //  176LU
{   71,  176,          487.84,        9.954596,    0,                   0}, //  176LU
{   71,  176,           635.2,        11.25302,    0,                   0}, //  176LU
{   71,  176,          658.43,        9.088979,    0,                   0}, //  176LU
{   71,  176,           722.9,        4.328085,    0,                   0}, //  176LU
{   71,  176,          985.55,        1.731234,    0,                   0}, //  176LU
{   71,  176,          1351.7,         2.88539,    0,                   0}, //  176LU
{   71,  176,          1514.5,        450.1209,    0,                   0}, //  176LU
{   71,  176,          1587.5,         57707.8,    0,                   0}, //  176LU
{   71,  177,           150.4,        187.5504,    9,          2.7775e-26}, //  177LU
{   71,  177,          569.71,        223617.7,    0,                   0}, //  177LU
{   71,  177,          573.64,        5.049433,    0,                   0}, //  177LU
{   71,  177,           761.7,         47.3204,    0,                   0}, //  177LU
{   71,  177,          970.17,    1.999864e+16,   23,          1.1716e-26}, //  177LU
{   71,  177,          1356.9,        16.01391,    0,                   0}, //  177LU
{   71,  177,          1437.9,        18.75504,    0,                   0}, //  177LU
{   71,  177,            2700,    5.193702e+11,    0,                   0}, //  177LU
{   71,  178,           123.8,    1.999575e+12,    0,                   0}, //  178LU
{   71,  179,           592.4,         4472355,    0,                   0}, //  179LU
{   71,  180,             624,         1442695,    0,                   0}, //  180LU
{   72,  154,     2671.000004,        12984.26,    0,                   0}, //  154HF
{   72,  156,            1959,        750201.4,    0,                   0}, //  156HF
{   72,  157,          2875.4,        75.02014,    0,                   0}, //  157HF
{   72,  169,            28.8,         118.301,    0,                   0}, //  169HF
{   72,  170,           100.8,        1.731234,    0,                   0}, //  170HF
{   72,  170,          1773.4,        7.213475,    0,                   0}, //  170HF
{   72,  170,          2183.8,        33.18199,    0,                   0}, //  170HF
{   72,  171,           21.93,     4.25595e+10,    0,                   0}, //  171HF
{   72,  171,           49.57,        92.33248,    0,                   0}, //  171HF
{   72,  171,          1645.3,        8.944709,    0,                   0}, //  171HF
{   72,  171,          1984.8,        25.96851,    0,                   0}, //  171HF
{   72,  172,           95.22,        2.236177,    0,                   0}, //  172HF
{   72,  172,          1684.7,        6.924936,    0,                   0}, //  172HF
{   72,  172,          1856.8,        23.08312,    0,                   0}, //  172HF
{   72,  172,          2005.8,        235.1593,    0,                   0}, //  172HF
{   72,  173,          107.16,        259.6851,    0,                   0}, //  173HF
{   72,  173,          197.47,        230.8312,    0,                   0}, //  173HF
{   72,  173,          1700.5,        7.213475,    0,                   0}, //  173HF
{   72,  173,          1982.1,        28.13255,    0,                   0}, //  173HF
{   72,  173,          2814.7,        5.049433,    0,                   0}, //  173HF
{   72,  174,          90.985,        2.394874,    0,                   0}, //  174HF
{   72,  174,          1319.4,        7.213475,    0,                   0}, //  174HF
{   72,  174,          1503.3,        7.213475,    0,                   0}, //  174HF
{   72,  174,          1549.3,        199.0919,    0,                   0}, //  174HF
{   72,  174,          1797.5,        3448.041,    0,                   0}, //  174HF
{   72,  174,          3311.7,        5337.972,    0,                   0}, //  174HF
{   72,  175,          125.89,        77472.72,    0,                   0}, //  175HF
{   72,  175,          207.41,        2.236177,    0,                   0}, //  175HF
{   72,  175,          1433.4,        1586.965,    0,                   0}, //  175HF
{   72,  175,          1766.3,        1.673526,    0,                   0}, //  175HF
{   72,  175,          3015.6,        1745.661,    0,                   0}, //  175HF
{   72,  175,          3819.6,        10.09887,    0,                   0}, //  175HF
{   72,  175,          4636.2,        4039.546,    0,                   0}, //  175HF
{   72,  175,          6510.1,        10.09887,    0,                   0}, //  175HF
{   72,  175,          7455.2,        10.09887,    0,                   0}, //  175HF
{   72,  176,          88.349,        2.063054,    4,         2.72195e-27}, //  176HF
{   72,  176,          1247.7,        6.722959,    0,                   0}, //  176HF
{   72,  176,          1333.1,        13849.87,    0,                   0}, //  176HF
{   72,  176,          1559.3,        14282.68,    0,                   0}, //  176HF
{   72,  176,          2865.8,        578520.7,    0,                   0}, //  176HF
{   72,  176,          4376.6,        49.05163,    0,                   0}, //  176HF
{   72,  176,          4863.5,        62035.89,    0,                   0}, //  176HF
{   72,  177,          1315.5,    1.572538e+09,    0,                   0}, //  177HF
{   72,  177,          1342.4,        80646.65,    0,                   0}, //  177HF
{   72,  177,            2740,    4.449272e+12,    0,                   0}, //  177HF
{   72,  178,           93.18,        2.155386,    4,           2.424e-27}, //  178HF
{   72,  178,          1147.4,     5.77078e+09,    0,                   0}, //  178HF
{   72,  178,            1554,        111.8089,   12,          2.9492e-26}, //  178HF
{   72,  178,          2446.1,    1.411374e+18,    0,                   0}, //  178HF
{   72,  178,          2572.4,        98103.26,    0,                   0}, //  178HF
{   72,  179,          214.34,        2.668986,    0,                   0}, //  179HF
{   72,  179,          375.04,    2.693512e+10,    0,                   0}, //  179HF
{   72,  179,          1105.7,    3.122425e+15,   25,           3.737e-26}, //  179HF
{   72,  179,          1309.8,        4.328085,    0,                   0}, //  179HF
{   72,  179,          1404.5,         5.77078,    0,                   0}, //  179HF
{   72,  179,     1404.500004,        20.19773,    0,                   0}, //  179HF
{   72,  179,          2549.6,        43.28085,    0,                   0}, //  179HF
{   72,  179,          3439.2,        17.31234,    0,                   0}, //  179HF
{   72,  179,          3775.2,        21640.43,    0,                   0}, //  179HF
{   72,  180,          93.324,        2.195782,    4,          3.0805e-27}, //  180HF
{   72,  180,          1141.5,    2.840955e+13,   16,          4.3935e-26}, //  180HF
{   72,  180,          1141.7,    2.856536e+13,    0,                   0}, //  180HF
{   72,  180,          1374.2,        822.3362,    0,                   0}, //  180HF
{   72,  180,          2425.8,        21640.43,    0,                   0}, //  180HF
{   72,  180,          2486.3,        14426.95,    0,                   0}, //  180HF
{   72,  180,          2538.3,        14426.95,    0,                   0}, //  180HF
{   72,  180,          3599.3,        129842.6,    0,                   0}, //  180HF
{   72,  181,          1043.5,        144269.5,    0,                   0}, //  181HF
{   72,  181,          1741.9,         2164043,    0,                   0}, //  181HF
{   72,  182,          1172.9,    5.323545e+12,    0,                   0}, //  182HF
{   72,  182,          2571.3,         57707.8,    0,                   0}, //  182HF
{   72,  184,          1272.2,    6.924936e+10,    0,                   0}, //  184HF
{   73,  155,           4e-06,         4183816,    0,                   0}, //  155TA
{   73,  156,             102,    5.193702e+08,    0,                   0}, //  156TA
{   73,  157,              22,         6203589,    0,                   0}, //  157TA
{   73,  157,            1589,         2452582,    0,                   0}, //  157TA
{   73,  158,             141,    5.294691e+07,    0,                   0}, //  158TA
{   73,  159,              64,    8.079092e+08,    0,                   0}, //  159TA
{   73,  160,           4e-06,    2.452582e+09,    0,                   0}, //  160TA
{   73,  161,           4e-06,    4.443501e+09,    0,                   0}, //  161TA
{   73,  169,           180.1,        24.52582,    0,                   0}, //  169TA
{   73,  169,          219.72,        40.39546,    0,                   0}, //  169TA
{   73,  171,          236.29,        66.36397,    0,                   0}, //  171TA
{   73,  173,      130.190004,        7.213475,    0,                   0}, //  173TA
{   73,  173,      165.880004,        324.6064,    0,                   0}, //  173TA
{   73,  173,     1713.500004,        144.2695,    0,                   0}, //  173TA
{   73,  175,          36.405,        144.2695,    0,                   0}, //  175TA
{   73,  175,          131.41,        320.2783,    0,                   0}, //  175TA
{   73,  175,           339.2,        245.2582,    0,                   0}, //  175TA
{   73,  175,          1552.5,        7.357745,    0,                   0}, //  175TA
{   73,  175,          1567.6,        2813.255,    0,                   0}, //  175TA
{   73,  175,          3763.2,         2.88539,    0,                   0}, //  175TA
{   73,  176,       90.400004,        38.95277,    0,                   0}, //  176TA
{   73,  176,       99.900004,        54.82241,    0,                   0}, //  176TA
{   73,  176,           100.2,         44.0022,    0,                   0}, //  176TA
{   73,  176,             103,         1586965,    0,                   0}, //  176TA
{   73,  176,           133.8,         2.88539,    0,                   0}, //  176TA
{   73,  176,      182.600004,         2.88539,    0,                   0}, //  176TA
{   73,  176,      186.500003,        2.164043,    0,                   0}, //  176TA
{   73,  176,           193.8,        19.18784,    0,                   0}, //  176TA
{   73,  176,     1371.000003,        5482.241,    0,                   0}, //  176TA
{   73,  176,     1382.000003,         2.88539,    0,                   0}, //  176TA
{   73,  176,     1432.000003,        36.06738,    0,                   0}, //  176TA
{   73,  176,     2771.000003,         1399414,    0,                   0}, //  176TA
{   73,  177,           70.59,        101.2772,    0,                   0}, //  177TA
{   73,  177,           73.36,         591.505,    0,                   0}, //  177TA
{   73,  177,          186.15,        5222.556,    0,                   0}, //  177TA
{   73,  177,          487.62,        37.51007,    0,                   0}, //  177TA
{   73,  177,          899.36,        2.019773,    0,                   0}, //  177TA
{   73,  177,            1355,        7660.711,    0,                   0}, //  177TA
{   73,  177,          1475.8,        2.019773,    0,                   0}, //  177TA
{   73,  177,            1523,        7.934823,    0,                   0}, //  177TA
{   73,  177,          1602.7,        2.019773,    0,                   0}, //  177TA
{   73,  177,          2098.3,        4.039546,    0,                   0}, //  177TA
{   73,  177,          2671.2,        4.039546,    0,                   0}, //  177TA
{   73,  177,          2826.5,        33.18199,    0,                   0}, //  177TA
{   73,  177,          2852.7,        66.36397,    0,                   0}, //  177TA
{   73,  177,          2956.9,        2.596851,    0,                   0}, //  177TA
{   73,  177,          3287.1,        2.019773,    0,                   0}, //  177TA
{   73,  177,          4656.3,        191878.4,    0,                   0}, //  177TA
{   73,  178,           4e-06,    1.225714e+13,    0,                   0}, //  178TA
{   73,  178,           5e-06,    8.058894e+11,    0,                   0}, //  178TA
{   73,  178,      219.700004,        12.26291,    0,                   0}, //  178TA
{   73,  178,      392.120004,        2.019773,    0,                   0}, //  178TA
{   73,  178,      447.700005,         86.5617,    0,                   0}, //  178TA
{   73,  178,     1467.800004,    8.367631e+07,    0,                   0}, //  178TA
{   73,  178,     1551.900004,        62.03589,    0,                   0}, //  178TA
{   73,  178,     2902.200004,    4.183816e+08,    0,                   0}, //  178TA
{   73,  178,     2956.900004,        9.521787,    0,                   0}, //  178TA
{   73,  179,            30.7,        2048.627,    0,                   0}, //  179TA
{   73,  179,          238.56,        93.77518,    0,                   0}, //  179TA
{   73,  179,          520.23,        403.9546,    0,                   0}, //  179TA
{   73,  179,          627.98,        115.4156,    0,                   0}, //  179TA
{   73,  179,          1252.6,        464.5478,    0,                   0}, //  179TA
{   73,  179,          1317.2,    1.298426e+07,    0,                   0}, //  179TA
{   73,  179,            1328,        2308.312,    0,                   0}, //  179TA
{   73,  179,          2639.5,     7.80498e+07,    0,                   0}, //  179TA
{   73,  179,          2792.8,        24.52582,    0,                   0}, //  179TA
{   73,  179,          5391.8,        76.46284,    0,                   0}, //  179TA
{   73,  180,            77.1,    5.463342e+31,   18,        2.436625e-26}, //  180TA
{   73,  180,          107.85,        27.69974,    0,                   0}, //  180TA
{   73,  180,          177.65,        100.9887,    0,                   0}, //  180TA
{   73,  180,          356.68,        60.59319,    0,                   0}, //  180TA
{   73,  180,          463.24,        45.01209,    0,                   0}, //  180TA
{   73,  180,          520.14,        53.95679,    0,                   0}, //  180TA
{   73,  180,          574.51,        10.09887,    0,                   0}, //  180TA
{   73,  180,          594.43,        23.22739,    0,                   0}, //  180TA
{   73,  180,          722.02,         2.88539,    0,                   0}, //  180TA
{   73,  180,          809.55,         2.88539,    0,                   0}, //  180TA
{   73,  180,          1452.4,        45012.09,    0,                   0}, //  180TA
{   73,  180,          1597.4,        3.462468,    0,                   0}, //  180TA
{   73,  180,          2588.4,        31.73929,    0,                   0}, //  180TA
{   73,  180,          2899.9,         2.88539,    0,                   0}, //  180TA
{   73,  180,            3679,         2885.39,    0,                   0}, //  180TA
{   73,  180,     4171.000004,        24525.82,    0,                   0}, //  180TA
{   73,  181,           6.237,        8728.305,    9,          2.6664e-26}, //  181TA
{   73,  181,          482.17,        15.58111,    5,         1.66145e-26}, //  181TA
{   73,  181,             615,        27266.94,    0,                   0}, //  181TA
{   73,  181,          615.19,        25968.51,    0,                   0}, //  181TA
{   73,  181,     1403.200004,        201.9773,    0,                   0}, //  181TA
{   73,  181,          1483.4,        36067.38,    0,                   0}, //  181TA
{   73,  181,          2227.9,          302966,    0,                   0}, //  181TA
{   73,  182,          16.263,    4.082827e+08,    0,                   0}, //  182TA
{   73,  182,          16.273,    4.082827e+08,    0,                   0}, //  182TA
{   73,  182,           270.4,        1.731234,    0,                   0}, //  182TA
{   73,  182,          443.61,        3.173929,    0,                   0}, //  182TA
{   73,  182,          519.58,    1.371137e+12,    0,                   0}, //  182TA
{   73,  183,          73.174,        154.3684,    0,                   0}, //  183TA
{   73,  185,             175,        7.213475,    0,                   0}, //  185TA
{   73,  185,     1258.500004,         1442695,    0,                   0}, //  185TA
{   73,  188,           4e-06,        21.64043,    0,                   0}, //  188TA
{   73,  190,      175.000004,        60.59319,    0,                   0}, //  190TA
{   74,  158,            1888,        206305.4,    0,                   0}, //   158W
{   74,  163,           480.3,         222.175,    0,                   0}, //   163W
{   74,  173,           85.37,        20.19773,    0,                   0}, //   173W
{   74,  174,             113,        1.644672,    0,                   0}, //   174W
{   74,  174,            1672,         269.784,    0,                   0}, //   174W
{   74,  174,          1919.7,         269.784,    0,                   0}, //   174W
{   74,  174,          3968.6,        43.28085,    0,                   0}, //   174W
{   74,  174,          4588.6,        43.28085,    0,                   0}, //   174W
{   74,  175,          104.03,        64.92128,    0,                   0}, //   175W
{   74,  175,          234.96,        311.6221,    0,                   0}, //   175W
{   74,  176,            3747,         59.1505,   28,         3.35825e-26}, //   176W
{   74,  176,          4894.7,        14.42695,    0,                   0}, //   176W
{   74,  177,          101.17,        54.82241,    0,                   0}, //   177W
{   74,  177,          185.96,        18.75504,    0,                   0}, //   177W
{   74,  177,          3431.2,        12.98426,    0,                   0}, //   177W
{   74,  178,          1664.9,        4.328085,    0,                   0}, //   178W
{   74,  178,          1738.7,        13.84987,    0,                   0}, //   178W
{   74,  178,          3053.8,         2.88539,    0,                   0}, //   178W
{   74,  178,          3593.6,        4.328085,    0,                   0}, //   178W
{   74,  178,          3654.9,        43.28085,    0,                   0}, //   178W
{   74,  178,          4879.7,        4.328085,    0,                   0}, //   178W
{   74,  178,          5313.7,        92.33248,    0,                   0}, //   178W
{   74,  178,          6572.7,        317.3929,    0,                   0}, //   178W
{   74,  178,          8148.4,        7.213475,    0,                   0}, //   178W
{   74,  179,          221.91,    5.539949e+11,    0,                   0}, //   179W
{   74,  179,          308.96,        2.207323,    0,                   0}, //   179W
{   74,  179,          1631.9,        562.6511,    0,                   0}, //   179W
{   74,  179,          3348.4,        1082.021,    0,                   0}, //   179W
{   74,  180,          103.53,         1.84665,    4,         2.57045e-27}, //   180W
{   74,  180,          1006.3,        10.67594,    0,                   0}, //   180W
{   74,  180,            1529,         7891542,    0,                   0}, //   180W
{   74,  180,          1639.8,        27.69974,    0,                   0}, //   180W
{   74,  180,          3264.6,        3361.479,    0,                   0}, //   180W
{   74,  181,          365.55,        21048.92,    0,                   0}, //   181W
{   74,  181,          1653.1,        201.9773,    0,                   0}, //   181W
{   74,  181,          1744.9,        72.13475,    0,                   0}, //   181W
{   74,  181,          3943.9,         28.8539,    0,                   0}, //   181W
{   74,  181,            8041,        4.328085,    0,                   0}, //   181W
{   74,  182,          100.11,        1.992362,    4,         2.63105e-27}, //   182W
{   74,  182,          1289.1,        1.615818,    4,           8.787e-27}, //   182W
{   74,  182,          1553.2,        1.832223,    0,                   0}, //   182W
{   74,  182,          2230.7,        1875.504,    0,                   0}, //   182W
{   74,  182,          3754.9,        53.37972,    0,                   0}, //   182W
{   74,  182,          3893.7,        10.09887,    0,                   0}, //   182W
{   74,  182,          4040.6,         28.8539,    0,                   0}, //   182W
{   74,  183,          309.49,    7.502014e+09,    0,                   0}, //   183W
{   74,  183,          453.07,        26.68986,    0,                   0}, //   183W
{   74,  184,          111.22,        1.804811,    4,          2.9189e-27}, //   184W
{   74,  184,            1285,        12017.65,    0,                   0}, //   184W
{   74,  184,          1501.5,        3.390333,    0,                   0}, //   184W
{   74,  184,          3863.2,        271.2267,    0,                   0}, //   184W
{   74,  185,           173.7,        2.164043,    0,                   0}, //   185W
{   74,  185,          197.38,     1.44558e+11,    0,                   0}, //   185W
{   74,  185,          197.43,     1.44558e+11,    0,                   0}, //   185W
{   74,  185,          243.62,        27.84401,    0,                   0}, //   185W
{   74,  186,          122.63,        1.494632,    4,         3.10575e-27}, //   186W
{   74,  186,          1517.2,        25968.51,    0,                   0}, //   186W
{   74,  186,          1661.4,         7.09806,    0,                   0}, //   186W
{   74,  186,          3542.8,         4328085,    0,                   0}, //   186W
{   74,  187,          350.43,        7.213475,    0,                   0}, //   187W
{   74,  187,          364.22,        21.64043,    0,                   0}, //   187W
{   74,  187,          410.06,        1990.919,    0,                   0}, //   187W
{   74,  190,            2381,         4472355,    0,                   0}, //   190W
{   75,  159,           4e-06,         28853.9,    0,                   0}, //  159RE
{   75,  161,           123.8,    2.120762e+07,    0,                   0}, //  161RE
{   75,  162,             173,    1.110875e+08,    0,                   0}, //  162RE
{   75,  163,             115,    3.087367e+08,    0,                   0}, //  163RE
{   75,  165,              48,    3.347052e+09,    0,                   0}, //  165RE
{   75,  167,           4e-06,    4.905163e+09,    0,                   0}, //  167RE
{   75,  169,           4e-06,     2.17847e+10,    0,                   0}, //  169RE
{   75,  172,           4e-06,    2.164043e+10,    0,                   0}, //  172RE
{   75,  172,           5e-06,    7.934823e+10,    0,                   0}, //  172RE
{   75,  174,      343.600004,        33.18199,    0,                   0}, //  174RE
{   75,  175,          1793.8,        39.96265,    0,                   0}, //  175RE
{   75,  176,      114.800004,        43.28085,    0,                   0}, //  176RE
{   75,  177,           84.71,        72134.75,    0,                   0}, //  177RE
{   75,  179,           65.35,          137056,    0,                   0}, //  179RE
{   75,  179,          1202.2,         30.2966,    0,                   0}, //  179RE
{   75,  179,     1772.200004,        588.6196,    0,                   0}, //  179RE
{   75,  179,            5408,        672295.9,    0,                   0}, //  179RE
{   75,  180,            20.1,        126.9572,    0,                   0}, //  180RE
{   75,  180,      213.400004,        105.3167,    0,                   0}, //  180RE
{   75,  180,     1496.000004,        100.9887,    0,                   0}, //  180RE
{   75,  181,          262.91,        226.0703,    0,                   0}, //  181RE
{   75,  181,          356.72,        126.3801,    5,         1.02515e-26}, //  181RE
{   75,  181,          1656.4,        360.6738,    0,                   0}, //  181RE
{   75,  181,          1880.6,        16590.99,    0,                   0}, //  181RE
{   75,  181,          3869.4,        1731.234,    0,                   0}, //  181RE
{   75,  181,            3990,        32.02783,    0,                   0}, //  181RE
{   75,  182,           4e-06,    6.596002e+13,    4,          1.6463e-26}, //  182RE
{   75,  182,      235.730004,        843.9766,    0,                   0}, //  182RE
{   75,  182,      263.280004,        7.357745,    0,                   0}, //  182RE
{   75,  182,          443.15,         8.65617,    0,                   0}, //  182RE
{   75,  182,      461.300004,        1125.302,    0,                   0}, //  182RE
{   75,  182,          2256.5,         118.301,    0,                   0}, //  182RE
{   75,  183,          496.23,        11.25302,    0,                   0}, //  183RE
{   75,  183,          598.86,        2.827682,    0,                   0}, //  183RE
{   75,  183,          1906.9,         1500403,    0,                   0}, //  183RE
{   75,  183,          1907.6,         1500403,    0,                   0}, //  183RE
{   75,  184,          188.05,    2.106623e+16,    0,                   0}, //  184RE
{   75,  184,          311.62,         8.65617,    0,                   0}, //  184RE
{   75,  184,          347.56,        11.68583,    0,                   0}, //  184RE
{   75,  184,          702.87,         5.77078,    0,                   0}, //  184RE
{   75,  184,           825.5,        7.213475,    0,                   0}, //  184RE
{   75,  184,             917,        7.213475,    0,                   0}, //  184RE
{   75,  184,          1543.2,         8.65617,    0,                   0}, //  184RE
{   75,  184,            1834,        7.213475,    0,                   0}, //  184RE
{   75,  184,          2406.2,        7.213475,    0,                   0}, //  184RE
{   75,  185,           368.3,        47.60894,    0,                   0}, //  185RE
{   75,  185,          1206.1,         8.65617,    0,                   0}, //  185RE
{   75,  185,          2123.8,        174.5661,    0,                   0}, //  185RE
{   75,  186,          99.361,        36.78872,    0,                   0}, //  186RE
{   75,  186,             149,     9.10557e+21,    0,                   0}, //  186RE
{   75,  186,          314.01,        34.76895,    0,                   0}, //  186RE
{   75,  186,             330,        24.95862,    0,                   0}, //  186RE
{   75,  187,          206.25,        801.1286,    9,         2.58055e-26}, //  187RE
{   75,  187,          1474.3,        4.328085,    0,                   0}, //  187RE
{   75,  187,          1681.6,        164.4672,    0,                   0}, //  187RE
{   75,  188,           171.9,    1.609182e+12,    0,                   0}, //  188RE
{   75,  188,          172.07,    1.609182e+12,    0,                   0}, //  188RE
{   75,  188,          182.74,        29.28671,    0,                   0}, //  188RE
{   75,  188,          205.34,        5.337972,    0,                   0}, //  188RE
{   75,  188,          207.85,        5.482241,    0,                   0}, //  188RE
{   75,  188,          230.91,        30.87367,    0,                   0}, //  188RE
{   75,  188,          300.21,        2.164043,    0,                   0}, //  188RE
{   75,  188,          360.88,        8.079092,    0,                   0}, //  188RE
{   75,  190,             210,    1.661985e+13,    0,                   0}, //  190RE
{   75,  193,      146.000004,        115415.6,    0,                   0}, //  193RE
{   75,  194,           4e-06,        54822.41,    0,                   0}, //  194RE
{   76,  167,           435.1,        969.4911,    0,                   0}, //  167OS
{   76,  173,           141.2,        40.39546,    0,                   0}, //  173OS
{   76,  175,           105.7,        14.42695,    0,                   0}, //  175OS
{   76,  177,           152.3,         57.7078,    0,                   0}, //  177OS
{   76,  177,           300.6,        66.79678,    0,                   0}, //  177OS
{   76,  179,          145.41,        721.3475,    0,                   0}, //  179OS
{   76,  179,             243,         1129.63,    0,                   0}, //  179OS
{   76,  180,          1862.5,        24.52582,    0,                   0}, //  180OS
{   76,  180,          1928.6,        36.06738,    0,                   0}, //  180OS
{   76,  180,            3702,        7.213475,    0,                   0}, //  180OS
{   76,  180,          5848.3,        17.31234,    0,                   0}, //  180OS
{   76,  181,            49.2,    2.337166e+11,    0,                   0}, //  181OS
{   76,  181,          156.91,        377.9861,    0,                   0}, //  181OS
{   76,  181,          1744.1,        10.09887,    0,                   0}, //  181OS
{   76,  181,          3579.3,        7.213475,    0,                   0}, //  181OS
{   76,  181,          3738.7,        34.62468,    0,                   0}, //  181OS
{   76,  181,          4521.8,        4.328085,    0,                   0}, //  181OS
{   76,  182,          1831.4,         1125302,    0,                   0}, //  182OS
{   76,  182,          4370.3,         8.65617,    0,                   0}, //  182OS
{   76,  182,          7049.5,        216.4043,    0,                   0}, //  182OS
{   76,  183,          170.71,    5.141765e+13,    0,                   0}, //  183OS
{   76,  183,     4180.200004,        43.28085,    0,                   0}, //  183OS
{   76,  184,          119.77,        1.708151,    0,                   0}, //  184OS
{   76,  184,          774.08,        3.173929,    0,                   0}, //  184OS
{   76,  184,          1274.8,        3.173929,    0,                   0}, //  184OS
{   76,  184,          1871.2,        3.173929,    0,                   0}, //  184OS
{   76,  184,          2046.7,        2.019773,    0,                   0}, //  184OS
{   76,  184,          2366.8,         34.0476,    0,                   0}, //  184OS
{   76,  184,          2547.6,        3.173929,    0,                   0}, //  184OS
{   76,  184,          3261.4,        3.173929,    0,                   0}, //  184OS
{   76,  184,          3359.4,        3.173929,    0,                   0}, //  184OS
{   76,  184,            3791,        3.173929,    0,                   0}, //  184OS
{   76,  184,          3792.4,        4.328085,    0,                   0}, //  184OS
{   76,  184,          4046.5,        3.173929,    0,                   0}, //  184OS
{   76,  184,          4349.3,        3.173929,    0,                   0}, //  184OS
{   76,  184,          4756.7,        69.24936,    0,                   0}, //  184OS
{   76,  184,          4800.5,        3.173929,    0,                   0}, //  184OS
{   76,  184,          5000.9,        3.173929,    0,                   0}, //  184OS
{   76,  184,          5200.3,        4.328085,    0,                   0}, //  184OS
{   76,  184,          5230.6,        4.328085,    0,                   0}, //  184OS
{   76,  184,          5565.7,        2.019773,    0,                   0}, //  184OS
{   76,  184,          5670.5,        4.328085,    0,                   0}, //  184OS
{   76,  184,          5742.5,        3.173929,    0,                   0}, //  184OS
{   76,  184,          5743.3,        1.500403,    0,                   0}, //  184OS
{   76,  184,            6340,        4.328085,    0,                   0}, //  184OS
{   76,  184,          6797.7,        4.328085,    0,                   0}, //  184OS
{   76,  184,          6912.9,        4.328085,    0,                   0}, //  184OS
{   76,  184,          7283.8,        4.328085,    0,                   0}, //  184OS
{   76,  185,          102.37,        4328.085,    0,                   0}, //  185OS
{   76,  185,          275.53,        1125.302,    0,                   0}, //  185OS
{   76,  185,          1987.1,        7.934823,    0,                   0}, //  185OS
{   76,  185,          5007.1,        25.96851,    0,                   0}, //  185OS
{   76,  186,          1774.7,        12.06093,    0,                   0}, //  186OS
{   76,  186,          2165.5,        8.223362,    0,                   0}, //  186OS
{   76,  186,          5024.7,         2.88539,    0,                   0}, //  186OS
{   76,  186,          7141.9,         2.88539,    0,                   0}, //  186OS
{   76,  187,           9.756,        3.433614,    0,                   0}, //  187OS
{   76,  187,          75.016,        3.116221,    0,                   0}, //  187OS
{   76,  187,          100.45,        161.5818,    0,                   0}, //  187OS
{   76,  187,           257.1,        333262.6,    0,                   0}, //  187OS
{   76,  188,            1771,        20.19773,    0,                   0}, //  188OS
{   76,  189,          30.812,    3.017541e+13,    0,                   0}, //  189OS
{   76,  189,          69.535,        2.337166,    5,          4.9894e-27}, //  189OS
{   76,  190,          1705.4,    8.569609e+11,    0,                   0}, //  190OS
{   76,  190,          1705.8,    8.569609e+11,    0,                   0}, //  190OS
{   76,  191,           74.38,     6.80375e+13,    0,                   0}, //  191OS
{   76,  191,          74.382,     6.80375e+13,    0,                   0}, //  191OS
{   76,  191,            2640,         88.0044,    0,                   0}, //  191OS
{   76,  192,          2015.4,    8.511901e+09,    0,                   0}, //  192OS
{   76,  195,          1464.7,        37.51007,    0,                   0}, //  195OS
{   76,  197,           4e-06,        112.5302,    0,                   0}, //  197OS
{   76,  198,     1680.800004,        23.08312,    0,                   0}, //  198OS
{   76,  198,     3198.500005,        25.96851,    0,                   0}, //  198OS
{   77,  164,           4e-06,        135613.3,    0,                   0}, //  164IR
{   77,  165,             180,        432808.5,    0,                   0}, //  165IR
{   77,  166,             172,     2.17847e+07,    0,                   0}, //  166IR
{   77,  167,           175.3,    4.328085e+07,    0,                   0}, //  167IR
{   77,  168,           4e-06,    2.293885e+08,    0,                   0}, //  168IR
{   77,  169,             153,    4.053973e+08,    0,                   0}, //  169IR
{   77,  170,           4e-06,    1.170026e+09,    0,                   0}, //  170IR
{   77,  171,           4e-06,    2.019773e+09,    0,                   0}, //  171IR
{   77,  172,             139,     2.88539e+09,    0,                   0}, //  172IR
{   77,  173,           4e-06,    3.173929e+09,    0,                   0}, //  173IR
{   77,  173,           5e-06,    1.298426e+10,    0,                   0}, //  173IR
{   77,  174,             193,    7.069206e+09,    0,                   0}, //  174IR
{   77,  176,       37.000006,        9.954596,    0,                   0}, //  176IR
{   77,  176,       97.300004,        4.039546,    0,                   0}, //  176IR
{   77,  178,      140.500005,         5.77078,    0,                   0}, //  178IR
{   77,  181,          289.33,        429.9231,    0,                   0}, //  181IR
{   77,  181,           366.3,        181.7796,    0,                   0}, //  181IR
{   77,  181,          2034.3,        31.73929,    0,                   0}, //  181IR
{   77,  182,           71.02,        245.2582,    0,                   0}, //  182IR
{   77,  182,           176.4,        187.5504,    0,                   0}, //  182IR
{   77,  184,          225.65,        678066.7,    0,                   0}, //  184IR
{   77,  184,          293.28,        1.586965,    0,                   0}, //  184IR
{   77,  184,           328.4,        504.9433,    0,                   0}, //  184IR
{   77,  184,          432.49,        14.42695,    0,                   0}, //  184IR
{   77,  185,             5.8,        7.213475,    0,                   0}, //  185IR
{   77,  185,           229.6,         3.02966,    0,                   0}, //  185IR
{   77,  185,           646.6,        31.01794,    0,                   0}, //  185IR
{   77,  185,     2157.200004,        173.1234,    0,                   0}, //  185IR
{   77,  185,     2614.000004,         57.7078,    0,                   0}, //  185IR
{   77,  186,           4e-06,    9.868034e+12,    4,          3.2219e-27}, //  186IR
{   77,  187,          106.48,        16.59099,    0,                   0}, //  187IR
{   77,  187,          186.16,    4.371366e+07,    0,                   0}, //  187IR
{   77,  187,          433.75,        219.2896,   11,         3.13605e-26}, //  187IR
{   77,  188,           54.82,        2.784401,    0,                   0}, //  188IR
{   77,  188,           96.71,        2.293885,    0,                   0}, //  188IR
{   77,  188,      923.500004,         6059319,    0,                   0}, //  188IR
{   77,  189,           94.34,        16.44672,    0,                   0}, //  189IR
{   77,  189,          372.17,    1.918784e+07,    0,                   0}, //  189IR
{   77,  189,          2333.2,         5337972,    0,                   0}, //  189IR
{   77,  190,            26.1,    5.816946e+12,    0,                   0}, //  190IR
{   77,  190,          36.154,         2885.39,    0,                   0}, //  190IR
{   77,  190,          82.594,         8.65617,    0,                   0}, //  190IR
{   77,  190,          171.53,        5.381253,    0,                   0}, //  190IR
{   77,  190,          227.68,        5.337972,    0,                   0}, //  190IR
{   77,  190,          317.56,        129.8426,    0,                   0}, //  190IR
{   77,  190,           376.4,    1.603267e+13,    0,                   0}, //  190IR
{   77,  191,          82.423,        5.886196,    1,            3.03e-27}, //  191IR
{   77,  191,          171.28,    7.067763e+09,    0,                   0}, //  191IR
{   77,  191,          171.29,    7.067763e+09,   11,         3.04515e-26}, //  191IR
{   77,  191,     2046.700004,    7.934823e+09,    0,                   0}, //  191IR
{   77,  192,           56.71,    1.255145e+11,    0,                   0}, //  192IR
{   77,  192,           56.72,    1.255145e+11,    0,                   0}, //  192IR
{   77,  192,           66.83,        21.64043,    0,                   0}, //  192IR
{   77,  192,          84.275,        2.741121,    0,                   0}, //  192IR
{   77,  192,          104.78,        25.10289,    0,                   0}, //  192IR
{   77,  192,          118.78,        21.64043,    0,                   0}, //  192IR
{   77,  192,          168.14,    1.097227e+19,    0,                   0}, //  192IR
{   77,  192,          193.51,        3.895277,    0,                   0}, //  192IR
{   77,  193,          73.045,        8.786013,    1,         2.62095e-27}, //  193IR
{   77,  193,           80.22,     1.31255e+15,    0,                   0}, //  193IR
{   77,  193,          80.239,     1.31255e+15,    0,                   0}, //  193IR
{   77,  194,          147.07,    4.594984e+07,    0,                   0}, //  194IR
{   77,  194,          147.08,    4.594984e+07,    0,                   0}, //  194IR
{   77,  194,      190.000004,    2.131438e+16,    0,                   0}, //  194IR
{   77,  195,             100,    1.973607e+13,    0,                   0}, //  195IR
{   77,  196,             410,    7.271183e+12,    0,                   0}, //  196IR
{   77,  197,             115,    7.703992e+11,    0,                   0}, //  197IR
{   77,  198,           116.4,        111.0875,    0,                   0}, //  198IR
{   77,  199,           4e-06,        230.8312,    0,                   0}, //  199IR
{   78,  171,           412.6,        1299.868,    0,                   0}, //  171PT
{   78,  177,            94.8,        11.97437,    0,                   0}, //  177PT
{   78,  177,           147.4,        3173.929,    0,                   0}, //  177PT
{   78,  181,          116.65,        432.8085,    0,                   0}, //  181PT
{   78,  181,          275.99,        142.8268,    0,                   0}, //  181PT
{   78,  183,            34.5,    6.203589e+10,    0,                   0}, //  183PT
{   78,  183,          195.68,        216.4043,    0,                   0}, //  183PT
{   78,  184,          843.91,        2.164043,    0,                   0}, //  184PT
{   78,  184,          1234.3,        2.164043,    0,                   0}, //  184PT
{   78,  184,          1675.6,        2.164043,    0,                   0}, //  184PT
{   78,  184,          1840.3,         1457122,    0,                   0}, //  184PT
{   78,  185,          103.41,    2.856536e+12,    1,           2.727e-27}, //  185PT
{   78,  185,          200.89,        1050.282,    0,                   0}, //  185PT
{   78,  186,            2195,        11.54156,    0,                   0}, //  186PT
{   78,  187,           57.11,        25.96851,    0,                   0}, //  187PT
{   78,  187,          174.38,        448678.2,    0,                   0}, //  187PT
{   78,  189,           172.8,        669.4105,    0,                   0}, //  189PT
{   78,  189,           191.5,        206305.4,    0,                   0}, //  189PT
{   78,  190,          2297.4,        69.24936,    0,                   0}, //  190PT
{   78,  190,          2726.7,        2.005346,    0,                   0}, //  190PT
{   78,  191,          100.66,        1442.695,    0,                   0}, //  191PT
{   78,  191,           148.9,          137056,    0,                   0}, //  191PT
{   78,  191,          149.03,          137056,    0,                   0}, //  191PT
{   78,  191,          1545.8,        1.543684,    0,                   0}, //  191PT
{   78,  192,          1518.3,        2.668986,    0,                   0}, //  192PT
{   78,  192,          2172.4,        403.9546,    0,                   0}, //  192PT
{   78,  192,          2623.7,        3.779861,    0,                   0}, //  192PT
{   78,  193,           1.642,        13.99414,    0,                   0}, //  193PT
{   78,  193,          149.78,    5.397266e+14,    0,                   0}, //  193PT
{   78,  194,            1485,        4.977298,    0,                   0}, //  194PT
{   78,  194,          2451.1,        9.233248,    0,                   0}, //  194PT
{   78,  195,          259.29,    4.998361e+14,    0,                   0}, //  195PT
{   78,  195,           259.3,    4.998361e+14,   13,         -3.0603e-27}, //  195PT
{   78,  196,          1270.2,        1.586965,    0,                   0}, //  196PT
{   78,  196,          1373.6,        7.502014,   14,         -1.0605e-27}, //  196PT
{   78,  197,          53.088,        23.91988,    5,          4.2925e-27}, //  197PT
{   78,  197,          399.59,    8.258852e+12,    0,                   0}, //  197PT
{   78,  198,          1501.9,        4.905163,    0,                   0}, //  198PT
{   78,  198,            3017,        51.93702,    0,                   0}, //  198PT
{   78,  199,             424,    1.962065e+10,    0,                   0}, //  199PT
{   78,  200,     1566.900004,        20.48627,    0,                   0}, //  200PT
{   78,  200,     3226.600004,        14.85976,    0,                   0}, //  200PT
{   78,  201,     1455.500004,         30.2966,    0,                   0}, //  201PT
{   78,  202,          1788.5,        403954.6,    0,                   0}, //  202PT
{   78,  204,            1995,        7934.823,    0,                   0}, //  204PT
{   78,  204,     1995.000004,        79348.23,    0,                   0}, //  204PT
{   78,  204,     3153.000004,        210.6335,    0,                   0}, //  204PT
{   79,  170,             275,        894470.9,    0,                   0}, //  170AU
{   79,  171,             250,         1471549,    0,                   0}, //  171AU
{   79,  172,           4e-06,    1.110875e+07,    0,                   0}, //  172AU
{   79,  173,             214,    2.019773e+07,    0,                   0}, //  173AU
{   79,  175,           4e-06,    2.250604e+08,    0,                   0}, //  175AU
{   79,  176,           4e-06,     1.51483e+09,    0,                   0}, //  176AU
{   79,  176,           5e-06,    1.962065e+09,    0,                   0}, //  176AU
{   79,  177,      157.900004,     1.70238e+09,    0,                   0}, //  177AU
{   79,  177,      398.700004,        21.64043,    0,                   0}, //  177AU
{   79,  179,       86.000004,        144269.5,    0,                   0}, //  179AU
{   79,  182,          129.49,        72.13475,    0,                   0}, //  182AU
{   79,  183,            73.3,        1442.695,    0,                   0}, //  183AU
{   79,  183,           230.6,        1442.695,    0,                   0}, //  183AU
{   79,  184,           68.46,    6.867228e+10,    4,           7.272e-27}, //  184AU
{   79,  184,           228.4,        99.54596,    0,                   0}, //  184AU
{   79,  184,          320.51,         2.88539,    0,                   0}, //  184AU
{   79,  184,          490.91,         2.88539,    0,                   0}, //  184AU
{   79,  185,           4e-06,    5.886196e+11,    0,                   0}, //  185AU
{   79,  185,             8.9,        6.924936,    0,                   0}, //  185AU
{   79,  185,            40.8,        10.09887,    0,                   0}, //  185AU
{   79,  185,           220.1,        37.51007,    0,                   0}, //  185AU
{   79,  186,          113.94,        2.308312,    0,                   0}, //  186AU
{   79,  186,          227.77,        158.6965,    0,                   0}, //  186AU
{   79,  186,      455.100004,        56.26511,    0,                   0}, //  186AU
{   79,  187,           19.53,        9.377518,    0,                   0}, //  187AU
{   79,  187,          120.33,    3.318199e+09,    0,                   0}, //  187AU
{   79,  187,           120.6,    3.318199e+09,    0,                   0}, //  187AU
{   79,  187,          171.81,        1.586965,    0,                   0}, //  187AU
{   79,  187,           223.9,        69.24936,    0,                   0}, //  187AU
{   79,  187,          2281.7,        14.42695,    0,                   0}, //  187AU
{   79,  187,          2431.3,        34.62468,    0,                   0}, //  187AU
{   79,  187,          2669.4,        144.2695,    0,                   0}, //  187AU
{   79,  188,            82.7,        2.019773,    0,                   0}, //  188AU
{   79,  189,            9.92,        43.28085,    0,                   0}, //  189AU
{   79,  189,          247.23,    3.973182e+11,   11,         3.12595e-26}, //  189AU
{   79,  189,          325.11,        274.1121,    0,                   0}, //  189AU
{   79,  189,     2554.500005,        13.41706,    0,                   0}, //  189AU
{   79,  189,          2554.7,        349.1322,   31,          3.2825e-26}, //  189AU
{   79,  190,           4e-06,    1.803369e+08,    0,                   0}, //  190AU
{   79,  190,     2172.000004,        10.09887,    0,                   0}, //  190AU
{   79,  191,            11.1,        22.36177,    0,                   0}, //  191AU
{   79,  191,           266.2,    1.327279e+09,    0,                   0}, //  191AU
{   79,  191,             267,    1.327279e+09,    0,                   0}, //  191AU
{   79,  191,           540.4,        14.42695,    0,                   0}, //  191AU
{   79,  191,          2489.6,        579.9634,    0,                   0}, //  191AU
{   79,  191,          2502.5,         8.80044,    0,                   0}, //  191AU
{   79,  192,          135.41,    4.183816e+07,    0,                   0}, //  192AU
{   79,  192,           431.6,    2.308312e+08,    0,                   0}, //  192AU
{   79,  193,           38.23,        5.496668,    0,                   0}, //  193AU
{   79,  193,          290.19,    5.626511e+09,   11,          3.1209e-26}, //  193AU
{   79,  193,          789.93,        1.731234,    0,                   0}, //  193AU
{   79,  193,          1946.9,        15.00403,    0,                   0}, //  193AU
{   79,  193,          2079.8,        3.621165,    0,                   0}, //  193AU
{   79,  193,          2476.4,        5.078287,    0,                   0}, //  193AU
{   79,  193,          2486.5,        216.4043,    0,                   0}, //  193AU
{   79,  193,          2700.9,        2.596851,    0,                   0}, //  193AU
{   79,  194,           107.4,     8.65617e+08,    0,                   0}, //  194AU
{   79,  194,           244.6,        3.751007,    0,                   0}, //  194AU
{   79,  194,           278.2,        1.586965,    0,                   0}, //  194AU
{   79,  194,           406.8,        4.183816,    0,                   0}, //  194AU
{   79,  194,           475.8,    6.059319e+08,    0,                   0}, //  194AU
{   79,  195,          61.435,        4.328085,    0,                   0}, //  195AU
{   79,  195,          318.58,     4.40022e+10,    0,                   0}, //  195AU
{   79,  195,          318.59,     4.40022e+10,    0,                   0}, //  195AU
{   79,  195,            1813,        11.54156,    0,                   0}, //  195AU
{   79,  196,          84.656,    1.168583e+10,    0,                   0}, //  196AU
{   79,  196,           84.66,    1.168583e+10,    0,                   0}, //  196AU
{   79,  196,           212.8,        2.582424,    0,                   0}, //  196AU
{   79,  196,          232.47,        2.380447,    0,                   0}, //  196AU
{   79,  196,          370.14,        43.28085,    0,                   0}, //  196AU
{   79,  196,          400.84,        43.28085,    0,                   0}, //  196AU
{   79,  196,          420.75,         2.88539,    0,                   0}, //  196AU
{   79,  196,          595.66,    4.985954e+13,    0,                   0}, //  196AU
{   79,  197,          77.351,        2.755548,    0,                   0}, //  197AU
{   79,  197,          409.15,    1.115203e+10,    0,                   0}, //  197AU
{   79,  198,          312.22,        178.8942,   10,         -5.6055e-27}, //  198AU
{   79,  198,           381.2,        3.318199,    0,                   0}, //  198AU
{   79,  198,           811.7,     2.83201e+14,    0,                   0}, //  198AU
{   79,  199,          77.194,        1.875504,    0,                   0}, //  199AU
{   79,  199,          548.94,        634785.8,    0,                   0}, //  199AU
{   79,  200,             962,    9.712223e+13,    0,                   0}, //  200AU
{   79,  203,             641,         57707.8,    0,                   0}, //  203AU
{   79,  204,      976.600004,         3029.66,    0,                   0}, //  204AU
{   80,  175,             494,        490.5163,    0,                   0}, //  175HG
{   80,  179,           171.4,        9233.248,    0,                   0}, //  179HG
{   80,  183,           67.16,        23.08312,    0,                   0}, //  183HG
{   80,  183,          275.33,        23.08312,    0,                   0}, //  183HG
{   80,  185,              99,    3.116221e+10,    0,                   0}, //  185HG
{   80,  185,            99.3,    3.116221e+10,   13,        -5.13585e-27}, //  185HG
{   80,  186,          2217.3,          118301,    0,                   0}, //  186HG
{   80,  187,           4e-06,    1.644672e+11,    0,                   0}, //  187HG
{   80,  187,          161.57,        47.60894,    0,                   0}, //  187HG
{   80,  188,          2724.3,        193.3211,    0,                   0}, //  188HG
{   80,  189,           4e-06,    7.444306e+11,   13,         -5.3429e-27}, //  189HG
{   80,  190,          2620.7,        33.18199,    0,                   0}, //  190HG
{   80,  191,           4e-06,    4.397334e+12,    0,                   0}, //  191HG
{   80,  192,            1977,        1.500403,    0,                   0}, //  192HG
{   80,  192,          2507.3,        5.193702,    0,                   0}, //  192HG
{   80,  192,          2535.5,        16.01391,    0,                   0}, //  192HG
{   80,  193,          140.76,    6.128569e+13,    0,                   0}, //  193HG
{   80,  193,          1886.2,        2.279458,    0,                   0}, //  193HG
{   80,  194,            1910,        5.410106,    0,                   0}, //  194HG
{   80,  194,          2423.2,        4.183816,    0,                   0}, //  194HG
{   80,  194,          2475.1,        11.68583,    0,                   0}, //  194HG
{   80,  195,          176.07,     2.16058e+14,   13,       -5.275469e-27}, //  195HG
{   80,  195,          1870.1,        2.135189,    0,                   0}, //  195HG
{   80,  196,          1841.3,        7.530868,   14,         -1.0605e-27}, //  196HG
{   80,  196,          2342.3,        6.968217,    0,                   0}, //  196HG
{   80,  196,            2439,        5.049433,    0,                   0}, //  196HG
{   80,  197,          133.96,        11.64255,    0,                   0}, //  197HG
{   80,  197,          298.93,    1.236101e+14,    0,                   0}, //  197HG
{   80,  197,            1833,        1.630245,    0,                   0}, //  197HG
{   80,  198,          1683.3,        9.954596,   14,          -1.111e-27}, //  198HG
{   80,  198,          2434.8,        2.769974,    0,                   0}, //  198HG
{   80,  198,            2578,        1.990919,    0,                   0}, //  198HG
{   80,  199,          158.38,        3.534603,    5,           4.444e-27}, //  199HG
{   80,  199,          532.48,    3.693588e+12,   13,        -5.12425e-27}, //  199HG
{   80,  200,          2143.8,        1.543684,    0,                   0}, //  200HG
{   80,  201,          1.5648,        116.8583,    0,                   0}, //  201HG
{   80,  201,          547.32,         28.8539,    0,                   0}, //  201HG
{   80,  201,          766.22,        135613.3,    0,                   0}, //  201HG
{   80,  201,           766.9,        135613.3,    0,                   0}, //  201HG
{   80,  203,           932.9,        34624.68,    0,                   0}, //  203HG
{   80,  203,          933.14,        34624.68,    0,                   0}, //  203HG
{   80,  204,          2300.7,        9.810326,    0,                   0}, //  204HG
{   80,  205,          1556.4,         1572538,    0,                   0}, //  205HG
{   80,  206,          1068.2,         30.2966,    0,                   0}, //  206HG
{   80,  206,          2102.4,        3101.794,   10,         2.75225e-26}, //  206HG
{   80,  206,          3723.4,        132.7279,    0,                   0}, //  206HG
{   80,  208,     1296.900004,        142.8268,    0,                   0}, //  208HG
{   81,  177,             807,        331819.9,    0,                   0}, //  177TL
{   81,  179,           4e-06,         2164043,    0,                   0}, //  179TL
{   81,  181,           835.9,         2019773,    0,                   0}, //  181TL
{   81,  183,             630,     8.65617e+07,    0,                   0}, //  183TL
{   81,  183,           976.8,        2135.189,    0,                   0}, //  183TL
{   81,  185,             453,    2.784401e+09,    0,                   0}, //  185TL
{   81,  185,           454.8,    2.784401e+09,    0,                   0}, //  185TL
{   81,  185,          1004.5,        12.00322,    0,                   0}, //  185TL
{   81,  186,           4e-06,    3.967411e+10,    0,                   0}, //  186TL
{   81,  186,      293.700005,        15.86965,    0,                   0}, //  186TL
{   81,  186,      374.000004,    4.183816e+09,    0,                   0}, //  186TL
{   81,  187,             334,    2.250604e+10,    0,                   0}, //  187TL
{   81,  187,     1434.200004,        1601.391,    0,                   0}, //  187TL
{   81,  187,          2582.5,        995.4596,    0,                   0}, //  187TL
{   81,  188,           4e-06,    1.024313e+11,    0,                   0}, //  188TL
{   81,  188,           5e-06,    1.024313e+11,    0,                   0}, //  188TL
{   81,  188,      184.600004,        49.05163,    0,                   0}, //  188TL
{   81,  188,      268.800005,     5.91505e+07,    0,                   0}, //  188TL
{   81,  189,             281,    1.211864e+11,    0,                   0}, //  189TL
{   81,  190,           4e-06,    2.250604e+11,    0,                   0}, //  190TL
{   81,  190,           5e-06,    3.202783e+11,    0,                   0}, //  190TL
{   81,  190,      151.300004,        49.05163,    0,                   0}, //  190TL
{   81,  190,      161.900005,         1082021,    0,                   0}, //  190TL
{   81,  191,           4e-06,    4.518521e+11,    0,                   0}, //  191TL
{   81,  192,             156,    9.348664e+11,    0,                   0}, //  192TL
{   81,  192,             407,        427.0377,    0,                   0}, //  192TL
{   81,  193,      365.000004,    1.826452e+11,    0,                   0}, //  193TL
{   81,  193,      365.200004,    1.826452e+11,    0,                   0}, //  193TL
{   81,  194,           4e-06,    2.839224e+12,    0,                   0}, //  194TL
{   81,  195,           482.6,    5.193702e+09,    0,                   0}, //  195TL
{   81,  195,          482.63,    5.193702e+09,    0,                   0}, //  195TL
{   81,  196,           394.2,     7.32312e+12,    0,                   0}, //  196TL
{   81,  196,           394.6,     7.32312e+12,    0,                   0}, //  196TL
{   81,  196,           638.1,        3.606738,    0,                   0}, //  196TL
{   81,  196,           738.1,         30.7294,    0,                   0}, //  196TL
{   81,  197,          608.22,    7.790553e+08,    0,                   0}, //  197TL
{   81,  197,          2529.7,        25.96851,    0,                   0}, //  197TL
{   81,  198,          173.41,        6.492128,    0,                   0}, //  198TL
{   81,  198,           543.5,    9.712223e+12,    0,                   0}, //  198TL
{   81,  198,           543.6,    9.712223e+12,   14,         3.23705e-27}, //  198TL
{   81,  198,           687.2,        216.4043,    0,                   0}, //  198TL
{   81,  198,           742.4,    4.631051e+07,    0,                   0}, //  198TL
{   81,  198,           934.2,        17.74515,    0,                   0}, //  198TL
{   81,  199,          366.89,        2.164043,    0,                   0}, //  199TL
{   81,  199,          748.87,    4.097254e+07,    0,                   0}, //  199TL
{   81,  199,           749.8,    4.097254e+07,    0,                   0}, //  199TL
{   81,  200,          147.63,        10.24313,    0,                   0}, //  200TL
{   81,  200,           753.6,    4.905163e+07,    0,                   0}, //  200TL
{   81,  200,             762,        476.0894,    0,                   0}, //  200TL
{   81,  200,            1244,        6.924936,    0,                   0}, //  200TL
{   81,  201,           919.1,         2899817,    0,                   0}, //  201TL
{   81,  201,          919.16,         2899817,    0,                   0}, //  201TL
{   81,  201,          2014.5,        4.183816,    0,                   0}, //  201TL
{   81,  202,          950.19,        852632.8,   14,           4.545e-27}, //  202TL
{   81,  203,     3514.600004,        11108.75,    0,                   0}, //  203TL
{   81,  204,          145.89,         26.9784,    0,                   0}, //  204TL
{   81,  204,          413.99,         8.65617,    0,                   0}, //  204TL
{   81,  204,          1103.9,        89014.28,    0,                   0}, //  204TL
{   81,  204,     2318.800004,        3751.007,    0,                   0}, //  204TL
{   81,  204,     2318.800005,        2308.312,    0,                   0}, //  204TL
{   81,  205,          203.68,        2.106335,    0,                   0}, //  205TL
{   81,  205,          1483.9,        6.492128,    0,                   0}, //  205TL
{   81,  205,          3290.6,        3751.007,    0,                   0}, //  205TL
{   81,  205,          4835.6,        339.0333,    0,                   0}, //  205TL
{   81,  206,          265.83,        3.303772,    0,                   0}, //  206TL
{   81,  206,          1405.5,        112.5302,    0,                   0}, //  206TL
{   81,  206,          1621.7,        14.57122,    0,                   0}, //  206TL
{   81,  206,          2643.1,    3.237408e+11,    0,                   0}, //  206TL
{   81,  206,          2643.3,    3.237408e+11,    0,                   0}, //  206TL
{   81,  207,          1348.2,    1.918784e+09,    0,                   0}, //  207TL
{   81,  207,            1350,    1.918784e+09,    0,                   0}, //  207TL
{   82,  181,           4e-06,    6.492128e+07,    0,                   0}, //  181PB
{   82,  183,              97,    5.987184e+08,    0,                   0}, //  183PB
{   82,  185,           4e-06,    6.203589e+09,   13,         -6.0095e-27}, //  185PB
{   82,  187,              33,    2.192896e+10,    0,                   0}, //  187PB
{   82,  187,             408,        14.42695,    0,                   0}, //  187PB
{   82,  187,             494,        14.42695,    0,                   0}, //  187PB
{   82,  188,          2578.2,        1197.437,    0,                   0}, //  188PB
{   82,  188,     2700.500004,        1149.828,    0,                   0}, //  188PB
{   82,  188,          2704.9,        37.51007,    0,                   0}, //  188PB
{   82,  188,            2713,        135.6133,    0,                   0}, //  188PB
{   82,  189,           4e-06,    7.213475e+10,    0,                   0}, //  189PB
{   82,  189,     1141.600004,        9.954596,    0,                   0}, //  189PB
{   82,  189,     1567.400004,        4.039546,    0,                   0}, //  189PB
{   82,  189,     2097.800004,         3.02966,    0,                   0}, //  189PB
{   82,  189,     2434.500004,        32027.83,    0,                   0}, //  189PB
{   82,  190,          2614.8,        216.4043,    0,                   0}, //  190PB
{   82,  190,     2615.000004,        36067.38,    0,                   0}, //  190PB
{   82,  190,          2658.2,         10387.4,    0,                   0}, //  190PB
{   82,  190,          4516.8,        20.19773,    0,                   0}, //  190PB
{   82,  191,           4e-06,    1.887045e+11,    0,                   0}, //  191PB
{   82,  191,     2417.700004,        21.64043,    0,                   0}, //  191PB
{   82,  191,     2440.700004,        24.52582,    0,                   0}, //  191PB
{   82,  191,     2602.300004,        216.4043,    0,                   0}, //  191PB
{   82,  192,          2581.1,         236.602,    0,                   0}, //  192PB
{   82,  192,          2625.1,        1586.965,    0,                   0}, //  192PB
{   82,  192,          2743.5,        1090.677,    0,                   0}, //  192PB
{   82,  193,           4e-06,    5.020579e+11,    0,                   0}, //  193PB
{   82,  193,     1585.900004,        29.57525,    0,                   0}, //  193PB
{   82,  193,     2584.800004,        13.56133,    0,                   0}, //  193PB
{   82,  193,     2612.500004,        259.6851,    0,                   0}, //  193PB
{   82,  194,          930.67,        1.586965,    0,                   0}, //  194PB
{   82,  194,            1820,        1.586965,    0,                   0}, //  194PB
{   82,  194,          2407.1,        24.52582,    0,                   0}, //  194PB
{   82,  194,          2437.4,        24.52582,    0,                   0}, //  194PB
{   82,  194,          2580.8,        24.81435,    0,                   0}, //  194PB
{   82,  194,          2628.1,        533.7972,    0,                   0}, //  194PB
{   82,  194,            2933,        191.8784,    0,                   0}, //  194PB
{   82,  195,           202.9,    1.298426e+12,    0,                   0}, //  195PB
{   82,  195,            1759,        14426.95,    0,                   0}, //  195PB
{   82,  195,          2413.2,        3.318199,    0,                   0}, //  195PB
{   82,  195,          2901.7,         137.056,    0,                   0}, //  195PB
{   82,  196,          1049.2,        144.2695,    0,                   0}, //  196PB
{   82,  196,          1738.3,        1442.695,    0,                   0}, //  196PB
{   82,  196,          1797.5,        201.9773,   10,          2.4745e-27}, //  196PB
{   82,  196,          2169.4,        7.213475,    0,                   0}, //  196PB
{   82,  196,          2307.8,        75.02014,   18,         -1.6665e-27}, //  196PB
{   82,  196,          2621.9,        72.13475,    0,                   0}, //  196PB
{   82,  196,          2645.1,         2.88539,    0,                   0}, //  196PB
{   82,  196,          2694.6,        389.5277,   24,          -9.696e-27}, //  196PB
{   82,  196,          3192.7,         103.874,   22,           5.757e-26}, //  196PB
{   82,  196,          4479.6,        7.213475,    0,                   0}, //  196PB
{   82,  197,          319.31,    3.713497e+12,   13,         -5.5449e-27}, //  197PB
{   82,  197,          1914.1,        1659.099,   21,        -2.68155e-27}, //  197PB
{   82,  197,          3168.9,        79.34823,    0,                   0}, //  197PB
{   82,  198,          1823.5,        72.71183,    0,                   0}, //  198PB
{   82,  198,          2141.4,        6044.892,    0,                   0}, //  198PB
{   82,  198,          2231.4,        197.6492,    0,                   0}, //  198PB
{   82,  198,          2820.5,        305.8513,    0,                   0}, //  198PB
{   82,  198,          4895.4,        9.233248,    0,                   0}, //  198PB
{   82,  199,      424.100004,    1.056053e+12,    0,                   0}, //  199PB
{   82,  199,      424.800004,    1.056053e+12,    0,                   0}, //  199PB
{   82,  199,     1826.000004,         2.88539,    0,                   0}, //  199PB
{   82,  199,     2127.500004,        5.554376,    0,                   0}, //  199PB
{   82,  199,     2499.900004,        11.39729,    0,                   0}, //  199PB
{   82,  199,     2559.100004,        14571.22,    0,                   0}, //  199PB
{   82,  199,     3490.100004,        90.88979,    0,                   0}, //  199PB
{   82,  199,     4474.700004,         57.7078,    0,                   0}, //  199PB
{   82,  200,          1908.7,        1.947638,    0,                   0}, //  200PB
{   82,  200,          2153.8,        65.06555,   14,         -1.0605e-27}, //  200PB
{   82,  200,          2183.3,        646.3274,    0,                   0}, //  200PB
{   82,  200,          3005.8,        287.0963,    0,                   0}, //  200PB
{   82,  200,          4145.5,        4.472355,    0,                   0}, //  200PB
{   82,  200,          5075.9,         103.874,    0,                   0}, //  200PB
{   82,  200,          6948.3,        83.67631,    0,                   0}, //  200PB
{   82,  201,           629.1,    8.771586e+10,    0,                   0}, //  201PB
{   82,  201,          1896.7,        4.616624,    0,                   0}, //  201PB
{   82,  201,          2719.6,        90.88979,   25,         -3.9895e-27}, //  201PB
{   82,  201,     2719.600004,        732.8891,    0,                   0}, //  201PB
{   82,  201,     4640.900004,        62.03589,    0,                   0}, //  201PB
{   82,  202,          1382.8,        2.842109,    8,            4.04e-29}, //  202PB
{   82,  202,          2169.8,    1.838571e+13,   18,        -1.14938e-27}, //  202PB
{   82,  202,          2208.4,        94.35226,    0,                   0}, //  202PB
{   82,  202,          3237.7,        34.91322,    0,                   0}, //  202PB
{   82,  202,     4091.000004,        158.6965,   32,         -3.3835e-27}, //  202PB
{   82,  202,     5251.000001,        154.3684,   38,          -9.494e-27}, //  202PB
{   82,  203,           126.5,        108.2021,    0,                   0}, //  203PB
{   82,  203,           825.2,    8.959136e+09,    0,                   0}, //  203PB
{   82,  203,           825.3,    8.959136e+09,    0,                   0}, //  203PB
{   82,  203,          1922.1,        60.59319,   21,        -3.23705e-27}, //  203PB
{   82,  203,     2923.400004,        176.0088,    0,                   0}, //  203PB
{   82,  203,          2949.2,    6.924936e+08,    0,                   0}, //  203PB
{   82,  204,          1274.1,        382.3142,    8,          1.1312e-27}, //  204PB
{   82,  204,          2185.9,    5.793575e+12,    0,                   0}, //  204PB
{   82,  204,          2264.4,        649.2128,    0,                   0}, //  204PB
{   82,  205,           2.329,        34913.22,    0,                   0}, //  205PB
{   82,  205,          1013.9,         8006957,    0,                   0}, //  205PB
{   82,  205,          3195.7,        313.0648,    0,                   0}, //  205PB
{   82,  205,          5064.5,        5.049433,    0,                   0}, //  205PB
{   82,  205,          5161.7,        90.88979,    0,                   0}, //  205PB
{   82,  205,          5902.8,        20.19773,    0,                   0}, //  205PB
{   82,  205,          6318.7,        20.19773,    0,                   0}, //  205PB
{   82,  205,          6533.5,        20.19773,    0,                   0}, //  205PB
{   82,  206,          2200.1,        180336.9,    0,                   0}, //  206PB
{   82,  206,          2200.2,        180336.9,   14,          -7.676e-28}, //  206PB
{   82,  206,          4027.3,        291.4244,   24,        -9.06475e-27}, //  206PB
{   82,  206,     7759.200004,        10.82021,    0,                   0}, //  206PB
{   82,  207,          1633.4,    1.162812e+09,    0,                   0}, //  207PB
{   82,  208,          4610.7,        4.616624,    0,                   0}, //  208PB
{   82,  208,          4895.2,        721.3475,    0,                   0}, //  208PB
{   82,  209,            1423,        2.019773,    0,                   0}, //  209PB
{   82,  209,          2149.4,        5.713072,    0,                   0}, //  209PB
{   82,  210,            1195,        70.69206,   12,         -9.4536e-27}, //  210PB
{   82,  210,            1278,        289.9817,   16,        -1.26048e-26}, //  210PB
{   82,  212,           4e-06,        7213.475,    0,                   0}, //  212PB
{   83,  184,           4e-06,    1.875504e+07,    0,                   0}, //  184BI
{   83,  184,           5e-06,         9521787,    0,                   0}, //  184BI
{   83,  186,           4e-06,    1.413841e+07,    0,                   0}, //  186BI
{   83,  187,             112,        533797.2,    0,                   0}, //  187BI
{   83,  187,             252,        4616.624,    0,                   0}, //  187BI
{   83,  188,           4e-06,     3.02966e+08,    0,                   0}, //  188BI
{   83,  188,           5e-06,    6.347858e+07,    0,                   0}, //  188BI
{   83,  189,            99.6,        14.42695,    0,                   0}, //  189BI
{   83,  189,             184,         7213475,    0,                   0}, //  189BI
{   83,  189,           357.6,         1269572,    0,                   0}, //  189BI
{   83,  190,           4e-06,    9.088979e+09,    0,                   0}, //  190BI
{   83,  190,           5e-06,    8.944709e+09,    0,                   0}, //  190BI
{   83,  190,      273.000005,        721.3475,    0,                   0}, //  190BI
{   83,  191,             149,        14.42695,    0,                   0}, //  191BI
{   83,  191,             241,    1.803369e+08,    0,                   0}, //  191BI
{   83,  191,           429.7,        789.1542,    0,                   0}, //  191BI
{   83,  192,           4e-06,    5.713072e+10,    0,                   0}, //  192BI
{   83,  193,             308,    4.616624e+09,    0,                   0}, //  193BI
{   83,  193,           605.5,        220.7323,    0,                   0}, //  193BI
{   83,  193,     2357.000004,        4328.085,    0,                   0}, //  193BI
{   83,  194,           4e-06,    1.659099e+11,    0,                   0}, //  194BI
{   83,  194,           5e-06,    1.803369e+11,    0,                   0}, //  194BI
{   83,  195,             401,    1.255145e+11,    0,                   0}, //  195BI
{   83,  195,           887.9,        46.16624,    0,                   0}, //  195BI
{   83,  195,          2196.2,        115.4156,    0,                   0}, //  195BI
{   83,  195,     2311.400004,        1082.021,    0,                   0}, //  195BI
{   83,  196,             169,     8.65617e+08,    0,                   0}, //  196BI
{   83,  196,             269,    3.462468e+11,    0,                   0}, //  196BI
{   83,  196,             271,    3.462468e+11,    0,                   0}, //  196BI
{   83,  197,             500,     4.36271e+11,    0,                   0}, //  197BI
{   83,  197,            1601,        22.07323,    0,                   0}, //  197BI
{   83,  197,     1968.000004,        25.96851,    0,                   0}, //  197BI
{   83,  197,          2064.7,        52.94691,    0,                   0}, //  197BI
{   83,  197,          2088.6,        27.84401,    0,                   0}, //  197BI
{   83,  197,          2129.3,        294.3098,    0,                   0}, //  197BI
{   83,  197,          2357.4,        76.46284,    0,                   0}, //  197BI
{   83,  197,     2360.400004,        379.4288,    0,                   0}, //  197BI
{   83,  197,     2383.100004,        365.0018,    0,                   0}, //  197BI
{   83,  197,          2929.5,        301.5233,    0,                   0}, //  197BI
{   83,  198,           2e-06,    1.004116e+12,    0,                   0}, //  198BI
{   83,  198,      248.500002,    1.110875e+10,    0,                   0}, //  198BI
{   83,  198,      248.500004,    1.110875e+10,    0,                   0}, //  198BI
{   83,  198,     1877.100002,        11.54156,    0,                   0}, //  198BI
{   83,  199,             667,    2.138074e+12,    0,                   0}, //  199BI
{   83,  199,          1647.5,         49.1959,    0,                   0}, //  199BI
{   83,  199,          1922.3,        72.13475,    0,                   0}, //  199BI
{   83,  199,     1922.300004,        144.2695,    0,                   0}, //  199BI
{   83,  199,     2523.200004,        242.3728,    0,                   0}, //  199BI
{   83,  200,           4e-06,    2.683413e+12,    0,                   0}, //  200BI
{   83,  200,           428.2,     5.77078e+08,    0,                   0}, //  200BI
{   83,  201,          846.35,    4.977298e+12,    0,                   0}, //  201BI
{   83,  201,          1747.5,        7.357745,    0,                   0}, //  201BI
{   83,  201,          1933.3,         57.7078,    0,                   0}, //  201BI
{   83,  201,     1933.300004,         170.238,    0,                   0}, //  201BI
{   83,  201,     1972.300004,         151.483,    0,                   0}, //  201BI
{   83,  201,     2741.000004,        178.8942,    0,                   0}, //  201BI
{   83,  202,      605.000004,        4385.793,    0,                   0}, //  202BI
{   83,  202,     2546.400004,         2.88539,    0,                   0}, //  202BI
{   83,  202,     2597.100004,        447.2355,    0,                   0}, //  202BI
{   83,  203,          1098.1,     4.40022e+08,    0,                   0}, //  203BI
{   83,  203,          1990.6,        129.8426,    0,                   0}, //  203BI
{   83,  203,          2041.5,        279.8828,    0,                   0}, //  203BI
{   83,  203,          3032.2,        32.31637,    0,                   0}, //  203BI
{   83,  203,          4544.3,        5.958331,    0,                   0}, //  203BI
{   83,  204,           805.5,    1.875504e+07,   20,          1.1918e-26}, //  204BI
{   83,  204,          1094.6,        5.713072,    0,                   0}, //  204BI
{   83,  204,          2833.4,         1543684,    0,                   0}, //  204BI
{   83,  205,          1497.2,        11397.29,    0,                   0}, //  205BI
{   83,  205,          2064.7,        144.2695,   21,          1.3635e-26}, //  205BI
{   83,  205,            2139,        317.3929,   25,         1.62105e-26}, //  205BI
{   83,  205,          3379.8,        3.606738,    0,                   0}, //  205BI
{   83,  206,          59.897,        11108.75,    0,                   0}, //  206BI
{   83,  206,          1044.8,         1283999,   20,         1.33522e-26}, //  206BI
{   83,  206,          3147.1,        22.50604,    0,                   0}, //  206BI
{   83,  207,          2101.4,        262570.5,    0,                   0}, //  207BI
{   83,  207,          2101.6,        262570.5,    0,                   0}, //  207BI
{   83,  207,          3887.4,        18.32223,    0,                   0}, //  207BI
{   83,  208,          1571.1,         3722153,   20,         1.34936e-26}, //  208BI
{   83,  208,            9000,         57.7078,    0,                   0}, //  208BI
{   83,  209,          2442.9,        14.42695,    0,                   0}, //  209BI
{   83,  209,          2986.8,        25.96851,   19,          1.7675e-26}, //  209BI
{   83,  210,          46.539,        4.328085,    0,                   0}, //  210BI
{   83,  210,          271.31,    1.384049e+23,   18,         1.37764e-26}, //  210BI
{   83,  210,          433.49,        82.95496,   14,         1.06757e-26}, //  210BI
{   83,  210,           439.2,         54.3896,   10,          7.7265e-27}, //  210BI
{   83,  210,          502.81,        2.019773,    0,                   0}, //  210BI
{   83,  210,             550,        2.019773,    0,                   0}, //  210BI
{   83,  211,          1227.2,        100.9887,    0,                   0}, //  211BI
{   83,  211,            1257,        2019.773,    0,                   0}, //  211BI
{   83,  212,             250,    2.164043e+12,    0,                   0}, //  212BI
{   83,  212,            1910,    6.059319e+11,    0,                   0}, //  212BI
{   83,  215,          1347.5,     5.25141e+10,    0,                   0}, //  215BI
{   83,  216,           4e-06,    5.713072e+11,    0,                   0}, //  216BI
{   84,  191,              40,    1.341706e+08,    0,                   0}, //  191PO
{   84,  193,           4e-06,    5.337972e+08,    0,                   0}, //  193PO
{   84,  193,           5e-06,    3.534603e+08,    0,                   0}, //  193PO
{   84,  194,          2525.2,        21640.43,    0,                   0}, //  194PO
{   84,  195,             230,    2.769974e+09,    0,                   0}, //  195PO
{   84,  196,          859.05,        17.31234,    0,                   0}, //  196PO
{   84,  196,          2493.9,        1234.947,    0,                   0}, //  196PO
{   84,  197,             204,    4.616624e+10,    0,                   0}, //  197PO
{   84,  198,          1853.6,        41.83816,    0,                   0}, //  198PO
{   84,  198,          2565.9,         288.539,    0,                   0}, //  198PO
{   84,  198,     2691.900004,        1082.021,    0,                   0}, //  198PO
{   84,  199,             310,    3.609623e+11,    0,                   0}, //  199PO
{   84,  200,          1773.6,         88.0044,   16,          3.7572e-26}, //  200PO
{   84,  200,          2261.3,         2.88539,    0,                   0}, //  200PO
{   84,  200,          2596.1,        144.2695,   22,          5.9994e-26}, //  200PO
{   84,  200,     2804.500004,        386.6423,   24,         -9.0294e-27}, //  200PO
{   84,  200,          3625.4,         2.88539,    0,                   0}, //  200PO
{   84,  200,          3689.6,         2.88539,    0,                   0}, //  200PO
{   84,  201,             424,    7.755929e+11,    0,                   0}, //  201PO
{   84,  201,           424.1,    7.755929e+11,   13,            5.05e-27}, //  201PO
{   84,  202,     1691.500004,        158.6965,   16,          3.7673e-26}, //  202PO
{   84,  202,     2218.100004,        2.164043,    0,                   0}, //  202PO
{   84,  202,     2604.100004,        122.6291,   22,            6.06e-26}, //  202PO
{   84,  202,     3040.500004,        27.41121,    0,                   0}, //  202PO
{   84,  202,     3573.500004,        15.86965,    0,                   0}, //  202PO
{   84,  203,          641.68,    6.492128e+10,    0,                   0}, //  203PO
{   84,  203,           641.8,    6.492128e+10,    0,                   0}, //  203PO
{   84,  203,          2158.5,         288.539,    0,                   0}, //  203PO
{   84,  203,          2792.4,        17.31234,    0,                   0}, //  203PO
{   84,  203,          2824.5,        10.09887,    0,                   0}, //  203PO
{   84,  204,            1639,         222.175,   16,          3.7269e-26}, //  204PO
{   84,  204,          2227.3,        22.50604,    0,                   0}, //  204PO
{   84,  204,          2620.5,        5.193702,    0,                   0}, //  204PO
{   84,  204,          3387.3,        12.98426,    0,                   0}, //  204PO
{   84,  204,          3564.1,        16.59099,   30,         3.10575e-26}, //  204PO
{   84,  205,          143.17,        447.2355,    0,                   0}, //  205PO
{   84,  205,          880.31,        930538.3,   13,         -4.7975e-27}, //  205PO
{   84,  205,          1461.2,     8.28107e+07,    0,                   0}, //  205PO
{   84,  205,          2224.7,         2.88539,    0,                   0}, //  205PO
{   84,  205,          3087.2,        165.9099,    0,                   0}, //  205PO
{   84,  206,          1585.9,        334.7052,   16,          3.7067e-26}, //  206PO
{   84,  206,          2262.1,         1514.83,    0,                   0}, //  206PO
{   84,  207,          68.557,        295.7525,    0,                   0}, //  207PO
{   84,  207,          1115.1,        70692.06,   13,         -4.5955e-27}, //  207PO
{   84,  207,            1383,    4.025119e+09,    0,                   0}, //  207PO
{   84,  207,          1383.2,    4.025119e+09,    0,                   0}, //  207PO
{   84,  207,          2379.7,        62.03589,   25,         2.73205e-26}, //  207PO
{   84,  208,          1524.2,        5.785207,   12,          2.6765e-26}, //  208PO
{   84,  208,          1528.2,        504.9433,   16,         3.72185e-26}, //  208PO
{   84,  208,          2369.2,        2.019773,    0,                   0}, //  208PO
{   84,  208,            2703,        11.59927,   22,         6.11555e-26}, //  208PO
{   84,  208,          5102.6,        2.019773,    0,                   0}, //  208PO
{   84,  208,          5262.2,        2.019773,    0,                   0}, //  208PO
{   84,  208,            5327,        10.09887,    0,                   0}, //  208PO
{   84,  208,          6521.2,        20.19773,    0,                   0}, //  208PO
{   84,  208,          6598.3,        20.19773,    0,                   0}, //  208PO
{   84,  208,            6620,        20.19773,    0,                   0}, //  208PO
{   84,  208,          6647.7,        20.19773,    0,                   0}, //  208PO
{   84,  208,          6950.8,        20.19773,    0,                   0}, //  208PO
{   84,  208,          7475.5,        10.09887,    0,                   0}, //  208PO
{   84,  208,          7653.1,        20.19773,    0,                   0}, //  208PO
{   84,  208,          7932.5,        10.09887,    0,                   0}, //  208PO
{   84,  208,            8023,        10.09887,    0,                   0}, //  208PO
{   84,  208,          8835.5,        2.019773,    0,                   0}, //  208PO
{   84,  209,          1417.6,        35.63457,    0,                   0}, //  209PO
{   84,  209,          1472.5,        134.1706,    0,                   0}, //  209PO
{   84,  209,          2769.9,        3.606738,    0,                   0}, //  209PO
{   84,  209,          4265.6,        171.6807,    0,                   0}, //  209PO
{   84,  210,          1426.7,        2.207323,    0,                   0}, //  210PO
{   84,  210,          1473.3,        61.45881,   12,          2.7674e-26}, //  210PO
{   84,  210,            1557,        142.6825,   16,         3.60065e-26}, //  210PO
{   84,  210,          2849.2,        28.27682,   22,           6.161e-26}, //  210PO
{   84,  210,          4371.9,        78.48261,   26,           3.232e-26}, //  210PO
{   84,  210,          5057.6,        379.4288,   32,          4.9692e-26}, //  210PO
{   84,  211,          1064.8,        20.19773,   15,          -1.919e-27}, //  211PO
{   84,  211,     1427.800004,        36.06738,    0,                   0}, //  211PO
{   84,  211,            1462,    3.635592e+10,    0,                   0}, //  211PO
{   84,  211,            1578,        5.049433,    0,                   0}, //  211PO
{   84,  211,          2135.7,        350.5749,    0,                   0}, //  211PO
{   84,  211,          3443.2,         2.88539,    0,                   0}, //  211PO
{   84,  211,          4873.3,        4039.546,    0,                   0}, //  211PO
{   84,  212,          1476.4,        24.67009,    0,                   0}, //  212PO
{   84,  212,            2922,    6.506555e+10,    0,                   0}, //  212PO
{   85,  191,              55,         3029660,    0,                   0}, //  191AT
{   85,  192,           4e-06,    1.269572e+08,    0,                   0}, //  192AT
{   85,  192,           5e-06,    1.659099e+07,    0,                   0}, //  192AT
{   85,  193,               5,     3.02966e+07,    0,                   0}, //  193AT
{   85,  193,              39,    3.895277e+07,    0,                   0}, //  193AT
{   85,  194,           4e-06,     5.77078e+07,    0,                   0}, //  194AT
{   85,  194,           5e-06,    3.606738e+08,    0,                   0}, //  194AT
{   85,  195,           4e-06,    2.120762e+08,    0,                   0}, //  195AT
{   85,  196,           157.9,        15869.65,    0,                   0}, //  196AT
{   85,  197,              52,     2.88539e+09,    0,                   0}, //  197AT
{   85,  198,      102.000004,    1.500403e+09,    0,                   0}, //  198AT
{   85,  199,             573,        836.7631,    0,                   0}, //  199AT
{   85,  200,             112,    6.780667e+10,    0,                   0}, //  200AT
{   85,  200,             344,    1.053167e+10,    0,                   0}, //  200AT
{   85,  201,             749,        22.93885,    0,                   0}, //  201AT
{   85,  202,           4e-06,    2.625705e+11,    0,                   0}, //  202AT
{   85,  202,      391.700004,    6.636397e+08,    0,                   0}, //  202AT
{   85,  203,     1942.000004,        23.94874,    0,                   0}, //  203AT
{   85,  203,     1964.600005,         17.0238,    0,                   0}, //  203AT
{   85,  204,           587.3,    1.558111e+08,    0,                   0}, //  204AT
{   85,  205,          2062.6,        96.08349,    0,                   0}, //  205AT
{   85,  205,          2339.7,        11195.31,    0,                   0}, //  205AT
{   85,  206,      806.700004,         591.505,    0,                   0}, //  206AT
{   85,  207,          2117.3,        155.8111,   25,         1.89375e-26}, //  207AT
{   85,  208,          1090.5,        68.96082,   20,         1.35845e-26}, //  208AT
{   85,  208,          2276.4,        2164.043,    0,                   0}, //  208AT
{   85,  209,          408.33,        7.213475,    0,                   0}, //  209AT
{   85,  209,           577.1,        7.213475,    0,                   0}, //  209AT
{   85,  209,          725.06,        7.213475,    0,                   0}, //  209AT
{   85,  209,          745.78,        7.213475,    0,                   0}, //  209AT
{   85,  209,          789.13,        7.213475,    0,                   0}, //  209AT
{   85,  209,          1214.3,        7.213475,    0,                   0}, //  209AT
{   85,  209,          1242.3,        7.213475,    0,                   0}, //  209AT
{   85,  209,          1321.6,        7.213475,    0,                   0}, //  209AT
{   85,  209,          1427.7,        36.78872,    0,                   0}, //  209AT
{   85,  209,          1772.5,        7.213475,    0,                   0}, //  209AT
{   85,  209,          1851.7,        7.213475,    0,                   0}, //  209AT
{   85,  209,          2429.2,        1283.999,    0,                   0}, //  209AT
{   85,  210,          1363.2,        35.77884,    0,                   0}, //  210AT
{   85,  210,          1688.7,        22.36177,    0,                   0}, //  210AT
{   85,  210,          2549.6,         695.379,    0,                   0}, //  210AT
{   85,  210,          4027.7,        8165.654,    0,                   0}, //  210AT
{   85,  210,          6959.3,        141.3841,    0,                   0}, //  210AT
{   85,  210,          7847.3,        51.93702,    0,                   0}, //  210AT
{   85,  211,          1270.4,        17.31234,    0,                   0}, //  211AT
{   85,  211,          1416.6,         50.6386,    0,                   0}, //  211AT
{   85,  211,          2641.4,        73.28891,    0,                   0}, //  211AT
{   85,  211,          4816.2,        6059.319,    0,                   0}, //  211AT
{   85,  211,          6567.2,        73.00037,    0,                   0}, //  211AT
{   85,  211,          7517.4,        35.05749,    0,                   0}, //  211AT
{   85,  212,             223,    1.716807e+08,    0,                   0}, //  212AT
{   85,  212,           275.5,        46.16624,    0,                   0}, //  212AT
{   85,  212,           701.6,        2.019773,    0,                   0}, //  212AT
{   85,  212,           885.4,         26.9784,    0,                   0}, //  212AT
{   85,  212,          1282.7,         5.77078,    0,                   0}, //  212AT
{   85,  212,            1317,         2.88539,    0,                   0}, //  212AT
{   85,  212,          1320.6,         5.77078,    0,                   0}, //  212AT
{   85,  212,          1540.6,        2.019773,    0,                   0}, //  212AT
{   85,  212,          1604.5,         51.0714,    0,                   0}, //  212AT
{   85,  212,          1827.6,         5.77078,    0,                   0}, //  212AT
{   85,  212,          1933.2,         5.77078,    0,                   0}, //  212AT
{   85,  212,            2250,        60.59319,    0,                   0}, //  212AT
{   85,  212,          3505.9,        4.039546,    0,                   0}, //  212AT
{   85,  212,          4771.6,        219289.6,    0,                   0}, //  212AT
{   85,  213,           340.5,        7.934823,    0,                   0}, //  213AT
{   85,  213,           724.6,        7.934823,    0,                   0}, //  213AT
{   85,  213,          1111.3,        7.934823,    0,                   0}, //  213AT
{   85,  213,          1129.7,        7.934823,    0,                   0}, //  213AT
{   85,  213,          1318.1,        7.934823,    0,                   0}, //  213AT
{   85,  213,     1318.100004,        158.6965,    0,                   0}, //  213AT
{   85,  213,     1319.000005,        122.6291,    0,                   0}, //  213AT
{   85,  213,     1838.000005,         118.301,    0,                   0}, //  213AT
{   85,  213,     2620.000005,        50.06152,    0,                   0}, //  213AT
{   85,  213,     2926.000005,        64921.28,    0,                   0}, //  213AT
{   85,  214,              59,        382.3142,    0,                   0}, //  214AT
{   85,  214,             232,        1096.448,    0,                   0}, //  214AT
{   85,  216,             413,        144269.5,    0,                   0}, //  216AT
{   86,  195,              59,         7213475,    0,                   0}, //  195RN
{   86,  197,           4e-06,    2.741121e+07,    0,                   0}, //  197RN
{   86,  199,             180,    4.472355e+08,    0,                   0}, //  199RN
{   86,  200,     2300.500004,        36067.38,    0,                   0}, //  200RN
{   86,  201,           4e-06,    5.482241e+09,    0,                   0}, //  201RN
{   86,  203,             362,     3.88085e+10,    0,                   0}, //  203RN
{   86,  204,          2032.7,        7.213475,    0,                   0}, //  204RN
{   86,  204,          2461.9,        48.18601,    0,                   0}, //  204RN
{   86,  204,          3035.3,        20.19773,    0,                   0}, //  204RN
{   86,  205,           4e-06,        144.2695,    0,                   0}, //  205RN
{   86,  206,          1762.9,        2.596851,    0,                   0}, //  206RN
{   86,  206,          1924.3,        9.088979,   16,           3.333e-26}, //  206RN
{   86,  206,          2475.6,        93.77518,   20,           5.656e-26}, //  206RN
{   86,  206,          4129.8,        15.86965,    0,                   0}, //  206RN
{   86,  207,           899.1,        266177.2,   13,        -4.56015e-27}, //  207RN
{   86,  208,          1828.3,        702.5925,   16,          3.5249e-26}, //  208RN
{   86,  208,          2618.1,         17.0238,   20,         5.43885e-26}, //  208RN
{   86,  208,          2621.2,        5.049433,    0,                   0}, //  208RN
{   86,  208,            3469,        5.049433,    0,                   0}, //  208RN
{   86,  208,          4066.4,        26.40132,    0,                   0}, //  208RN
{   86,  209,           797.8,        2.019773,    0,                   0}, //  209RN
{   86,  209,            1174,        19332.11,    0,                   0}, //  209RN
{   86,  209,          1465.5,        2.019773,    0,                   0}, //  209RN
{   86,  209,          1561.5,        2.019773,    0,                   0}, //  209RN
{   86,  209,          1610.7,        2.019773,    0,                   0}, //  209RN
{   86,  209,          2238.2,        2.019773,    0,                   0}, //  209RN
{   86,  209,          2418.7,        12.59473,    0,                   0}, //  209RN
{   86,  209,          2501.3,        2.019773,    0,                   0}, //  209RN
{   86,  209,          2744.2,        2.019773,    0,                   0}, //  209RN
{   86,  209,          2848.5,        2.019773,    0,                   0}, //  209RN
{   86,  209,          2864.6,        2.019773,    0,                   0}, //  209RN
{   86,  209,          2957.6,        2.019773,    0,                   0}, //  209RN
{   86,  209,          3049.9,        2.019773,    0,                   0}, //  209RN
{   86,  209,          3157.5,        20.05346,    0,                   0}, //  209RN
{   86,  209,          3400.6,        2.019773,    0,                   0}, //  209RN
{   86,  209,          3539.9,        2.019773,    0,                   0}, //  209RN
{   86,  209,          3636.8,        4328.085,    0,                   0}, //  209RN
{   86,  209,          3671.5,        2.019773,    0,                   0}, //  209RN
{   86,  209,            3987,        2.019773,    0,                   0}, //  209RN
{   86,  209,          4182.4,        2.019773,    0,                   0}, //  209RN
{   86,  209,          4583.6,        2.019773,    0,                   0}, //  209RN
{   86,  209,          4833.7,        14.42695,    0,                   0}, //  209RN
{   86,  209,            4988,        2.019773,    0,                   0}, //  209RN
{   86,  209,          5216.9,        2.019773,    0,                   0}, //  209RN
{   86,  209,          5819.8,        2.019773,    0,                   0}, //  209RN
{   86,  209,            6538,        2.019773,    0,                   0}, //  209RN
{   86,  209,          6772.1,        2.019773,    0,                   0}, //  209RN
{   86,  209,          6826.1,        2.019773,    0,                   0}, //  209RN
{   86,  209,          7307.7,        2.019773,    0,                   0}, //  209RN
{   86,  210,          1664.6,        10.96448,    0,                   0}, //  210RN
{   86,  210,     1664.600004,        929.0956,    0,                   0}, //  210RN
{   86,  210,     2265.700004,         30.2966,    0,                   0}, //  210RN
{   86,  210,     2376.800004,        2.019773,    0,                   0}, //  210RN
{   86,  210,     2562.300004,        92.33248,    0,                   0}, //  210RN
{   86,  210,     2922.400004,        2.019773,    0,                   0}, //  210RN
{   86,  210,     3247.700004,        109.6448,    0,                   0}, //  210RN
{   86,  210,     3812.000004,        1529.257,    0,                   0}, //  210RN
{   86,  210,     3863.700004,        11.54156,    0,                   0}, //  210RN
{   86,  210,     4993.200004,        17.74515,    0,                   0}, //  210RN
{   86,  210,     5875.700004,        10.09887,    0,                   0}, //  210RN
{   86,  210,     6035.300004,        10.09887,    0,                   0}, //  210RN
{   86,  210,     6468.300004,        1500.403,    0,                   0}, //  210RN
{   86,  210,     6894.200004,        50.49433,    0,                   0}, //  210RN
{   86,  210,     7310.100004,        49.05163,    0,                   0}, //  210RN
{   86,  210,     8555.000004,        2.596851,    0,                   0}, //  210RN
{   86,  211,           539.9,         5.77078,    0,                   0}, //  211RN
{   86,  211,     1577.800004,        859.8462,    0,                   0}, //  211RN
{   86,  211,     2147.600004,        5.049433,    0,                   0}, //  211RN
{   86,  211,     2650.300004,        9.666057,    0,                   0}, //  211RN
{   86,  211,     2731.800004,        4.328085,    0,                   0}, //  211RN
{   86,  211,     3243.300004,        3.895277,    0,                   0}, //  211RN
{   86,  211,     3844.300004,         2.88539,    0,                   0}, //  211RN
{   86,  211,     3926.000004,        57.99634,    0,                   0}, //  211RN
{   86,  211,     5239.900004,        10.09887,    0,                   0}, //  211RN
{   86,  211,     5245.900004,        5.049433,    0,                   0}, //  211RN
{   86,  211,     5246.100005,        20.19773,    0,                   0}, //  211RN
{   86,  211,     6100.300005,        40.97254,    0,                   0}, //  211RN
{   86,  211,     7399.100005,        2.164043,    0,                   0}, //  211RN
{   86,  211,     8167.700005,        3.318199,    0,                   0}, //  211RN
{   86,  211,     8854.700005,        289.9817,    0,                   0}, //  211RN
{   86,  211,     9915.600005,        12.98426,    0,                   0}, //  211RN
{   86,  212,          1501.5,        12.69572,    8,            2.02e-26}, //  212RN
{   86,  212,          1639.8,         170.238,    0,                   0}, //  212RN
{   86,  212,            1694,        1312.852,    0,                   0}, //  212RN
{   86,  212,          2760.7,        7.934823,    0,                   0}, //  212RN
{   86,  212,          2881.4,         3.02966,    0,                   0}, //  212RN
{   86,  212,          3357.6,        10.67594,    0,                   0}, //  212RN
{   86,  212,          4066.8,        41.69389,    0,                   0}, //  212RN
{   86,  212,          5427.2,        7.502014,    0,                   0}, //  212RN
{   86,  212,     6167.400004,        157.2538,    0,                   0}, //  212RN
{   86,  212,     7135.200004,        25.96851,    0,                   0}, //  212RN
{   86,  212,     7870.900004,        20.19773,    0,                   0}, //  212RN
{   86,  212,     8571.000004,         222.175,    0,                   0}, //  212RN
{   86,  212,     9687.600004,        7.069206,    0,                   0}, //  212RN
{   86,  212,    10612.000004,         28.8539,    0,                   0}, //  212RN
{   86,  213,           896.1,        37.51007,    0,                   0}, //  213RN
{   86,  213,            1664,        41.83816,    0,                   0}, //  213RN
{   86,  213,     1664.000004,        1442.695,    0,                   0}, //  213RN
{   86,  213,     2186.700004,        1962.065,    0,                   0}, //  213RN
{   86,  213,     3029.300004,        37.51007,    0,                   0}, //  213RN
{   86,  213,     3495.400004,        40.39546,    0,                   0}, //  213RN
{   86,  213,     4505.500004,        17.31234,    0,                   0}, //  213RN
{   86,  213,     5929.000005,         236.602,    0,                   0}, //  213RN
{   86,  213,     6744.000005,        85.11901,    0,                   0}, //  213RN
{   86,  214,           694.7,        2.019773,    0,                   0}, //  214RN
{   86,  214,          1141.2,        2.019773,    0,                   0}, //  214RN
{   86,  214,          1625.1,        9.377518,    0,                   0}, //  214RN
{   86,  214,          2394.7,        2.019773,    0,                   0}, //  214RN
{   86,  214,          2676.2,        5.337972,    0,                   0}, //  214RN
{   86,  214,          2878.2,        2.019773,    0,                   0}, //  214RN
{   86,  214,          3148.1,        2.019773,    0,                   0}, //  214RN
{   86,  214,          3327.9,        7.357745,    0,                   0}, //  214RN
{   86,  214,          3490.1,        63.47858,    0,                   0}, //  214RN
{   86,  214,          3745.9,        3.462468,    0,                   0}, //  214RN
{   86,  214,          4595.4,        353.4603,    0,                   0}, //  214RN
{   86,  214,          4977.6,        11.54156,    0,                   0}, //  214RN
{   86,  217,            88.9,        2.164043,    0,                   0}, //  217RN
{   86,  217,           93.02,         5.77078,    0,                   0}, //  217RN
{   86,  217,          149.18,        2.164043,    0,                   0}, //  217RN
{   86,  217,           174.3,        2.164043,    0,                   0}, //  217RN
{   86,  219,            4.47,         22.2175,    0,                   0}, //  219RN
{   87,  201,           4e-06,    2.741121e+07,    0,                   0}, //  201FR
{   87,  202,           4e-06,    4.183816e+08,    0,                   0}, //  202FR
{   87,  204,              41,    2.308312e+09,    0,                   0}, //  204FR
{   87,  204,             316,    1.154156e+09,    0,                   0}, //  204FR
{   87,  206,           4e-06,    2.308312e+10,    0,                   0}, //  206FR
{   87,  206,      531.000004,    1.009887e+09,    0,                   0}, //  206FR
{   87,  208,             827,         288.539,    0,                   0}, //  208FR
{   87,  211,          1452.9,         2.88539,    0,                   0}, //  211FR
{   87,  211,          1686.3,         3.02966,    0,                   0}, //  211FR
{   87,  211,            1860,         2.88539,    0,                   0}, //  211FR
{   87,  211,          2310.2,         2.88539,    0,                   0}, //  211FR
{   87,  211,          2423.2,        210.6335,    0,                   0}, //  211FR
{   87,  211,            2980,         2.88539,    0,                   0}, //  211FR
{   87,  211,            3244,         2.88539,    0,                   0}, //  211FR
{   87,  211,          3601.6,         2.88539,    0,                   0}, //  211FR
{   87,  211,          3928.9,         2.88539,    0,                   0}, //  211FR
{   87,  211,          4657.3,        177.4515,    0,                   0}, //  211FR
{   87,  211,          5556.4,        10.09887,    0,                   0}, //  211FR
{   87,  211,          6182.5,        10.09887,    0,                   0}, //  211FR
{   87,  211,          6259.4,        10.09887,    0,                   0}, //  211FR
{   87,  211,          6560.1,        10.09887,    0,                   0}, //  211FR
{   87,  212,          1389.4,         2.88539,    0,                   0}, //  212FR
{   87,  212,          1551.4,        46021.97,    0,                   0}, //  212FR
{   87,  212,          1879.8,         2.88539,    0,                   0}, //  212FR
{   87,  212,          2337.6,         2.88539,    0,                   0}, //  212FR
{   87,  212,          2492.2,        871.3878,    0,                   0}, //  212FR
{   87,  212,          2495.6,         2.88539,    0,                   0}, //  212FR
{   87,  212,          2612.5,        2.019773,    0,                   0}, //  212FR
{   87,  212,          2951.7,         2.88539,    0,                   0}, //  212FR
{   87,  212,          2964.1,        2.019773,    0,                   0}, //  212FR
{   87,  212,            3241,        2.019773,    0,                   0}, //  212FR
{   87,  212,          3256.2,        2.019773,    0,                   0}, //  212FR
{   87,  212,          3583.6,        2.019773,    0,                   0}, //  212FR
{   87,  212,          3750.8,        2.019773,    0,                   0}, //  212FR
{   87,  212,          4025.6,         2.88539,    0,                   0}, //  212FR
{   87,  212,          4081.8,        2.019773,    0,                   0}, //  212FR
{   87,  212,          4137.4,         2.88539,    0,                   0}, //  212FR
{   87,  212,          4447.1,        2.019773,    0,                   0}, //  212FR
{   87,  212,          4499.3,         2.88539,    0,                   0}, //  212FR
{   87,  212,            4547,         2.88539,    0,                   0}, //  212FR
{   87,  212,          4834.3,        6.059319,    0,                   0}, //  212FR
{   87,  212,          5056.2,        3.462468,    0,                   0}, //  212FR
{   87,  212,          5266.4,         2.88539,    0,                   0}, //  212FR
{   87,  212,          5803.3,         2.88539,    0,                   0}, //  212FR
{   87,  212,          5854.7,        450.1209,    0,                   0}, //  212FR
{   87,  212,          6344.9,        2.019773,    0,                   0}, //  212FR
{   87,  212,            6977,        2.019773,    0,                   0}, //  212FR
{   87,  212,          7660.8,         2.88539,    0,                   0}, //  212FR
{   87,  212,          8533.4,         34047.6,    0,                   0}, //  212FR
{   87,  213,          1188.8,         3.02966,    0,                   0}, //  213FR
{   87,  213,            1411,        25.96851,   17,          3.7875e-26}, //  213FR
{   87,  213,          1590.4,         728.561,   21,          4.7066e-26}, //  213FR
{   87,  213,          1856.3,        2.019773,    0,                   0}, //  213FR
{   87,  213,          2537.6,        343.3614,   29,          7.6861e-26}, //  213FR
{   87,  213,          2740.2,        10.09887,    0,                   0}, //  213FR
{   87,  213,          2950.6,         3.02966,    0,                   0}, //  213FR
{   87,  213,          3427.3,         3.02966,    0,                   0}, //  213FR
{   87,  213,          3655.5,        3.462468,    0,                   0}, //  213FR
{   87,  213,          4082.9,        2.019773,    0,                   0}, //  213FR
{   87,  213,          4675.5,         3.02966,    0,                   0}, //  213FR
{   87,  213,          4695.9,         3.02966,    0,                   0}, //  213FR
{   87,  213,          4898.5,        4.039546,    0,                   0}, //  213FR
{   87,  213,          4992.7,        18.75504,   45,         1.12615e-25}, //  213FR
{   87,  213,          5506.3,         3.02966,    0,                   0}, //  213FR
{   87,  213,          5785.9,        2.019773,    0,                   0}, //  213FR
{   87,  213,          6572.9,         3.02966,    0,                   0}, //  213FR
{   87,  213,          6715.3,        8.944709,    0,                   0}, //  213FR
{   87,  213,            7288,         3.02966,    0,                   0}, //  213FR
{   87,  213,          7983.5,        5.049433,    0,                   0}, //  213FR
{   87,  213,          8094.8,        4472.355,    0,                   0}, //  213FR
{   87,  214,             122,         4833028,    0,                   0}, //  214FR
{   87,  214,             638,        148.5976,    0,                   0}, //  214FR
{   87,  214,            1661,        15.86965,    0,                   0}, //  214FR
{   87,  214,            1732,        14.42695,    0,                   0}, //  214FR
{   87,  214,            2164,        10.09887,    0,                   0}, //  214FR
{   87,  214,     3265.000004,        6.059319,    0,                   0}, //  214FR
{   87,  214,     3566.000004,        14.42695,    0,                   0}, //  214FR
{   87,  214,     4318.000004,        11.54156,    0,                   0}, //  214FR
{   87,  214,     6477.000005,        155.8111,    0,                   0}, //  214FR
{   87,  214,     7545.000005,        7.069206,    0,                   0}, //  214FR
{   87,  215,          1573.1,        5.049433,    0,                   0}, //  215FR
{   87,  215,          1813.6,         3.02966,    0,                   0}, //  215FR
{   87,  215,          2015.9,        6.780667,    0,                   0}, //  215FR
{   87,  215,          2251.3,        7.646284,    0,                   0}, //  215FR
{   87,  215,          3068.9,        21.06335,    0,                   0}, //  215FR
{   87,  215,          3462.3,        33.18199,    0,                   0}, //  215FR
{   87,  216,           133.3,        102.4313,    0,                   0}, //  216FR
{   87,  218,              86,    3.173929e+07,    0,                   0}, //  218FR
{   87,  221,           36.64,        2.164043,    0,                   0}, //  221FR
{   87,  227,           39.88,        3.895277,    0,                   0}, //  227FR
{   88,  201,           4e-06,         2308312,    0,                   0}, //  201RA
{   88,  203,           4e-06,    3.462468e+07,    0,                   0}, //  203RA
{   88,  205,           4e-06,    2.452582e+08,    0,                   0}, //  205RA
{   88,  207,             554,    8.511901e+07,    0,                   0}, //  207RA
{   88,  208,          2147.4,        389.5277,    0,                   0}, //  208RA
{   88,  210,            2100,        3231.637,    0,                   0}, //  210RA
{   88,  212,          1958.4,        15725.38,    0,                   0}, //  212RA
{   88,  212,          2613.4,        1226.291,    0,                   0}, //  212RA
{   88,  213,            1770,         3101794,    0,                   0}, //  213RA
{   88,  214,          1639.3,         50.6386,    0,                   0}, //  214RA
{   88,  214,          1819.7,         170.238,    0,                   0}, //  214RA
{   88,  214,          1865.2,        98968.88,    0,                   0}, //  214RA
{   88,  214,          1865.2,        97093.38,   16,          3.5754e-26}, //  214RA
{   88,  214,          2683.2,         425.595,   22,          6.0499e-26}, //  214RA
{   88,  214,          3478.4,        402.5119,   28,         7.21645e-26}, //  214RA
{   88,  214,          3990.1,        5.193702,    0,                   0}, //  214RA
{   88,  214,          4146.8,        324.6064,   34,          8.7668e-26}, //  214RA
{   88,  214,          5390.3,        2.164043,    0,                   0}, //  214RA
{   88,  214,          6530.2,        2.308312,    0,                   0}, //  214RA
{   88,  214,            6577,         184.665,    0,                   0}, //  214RA
{   88,  215,             773,        100.9887,    0,                   0}, //  215RA
{   88,  215,          1821.2,        35.77884,    0,                   0}, //  215RA
{   88,  215,          1877.8,        10243.13,    0,                   0}, //  215RA
{   88,  215,          2246.9,        2005.346,    0,                   0}, //  215RA
{   88,  215,     3756.600004,        800.6957,    0,                   0}, //  215RA
{   88,  215,     4567.000004,         15.1483,    0,                   0}, //  215RA
{   88,  215,     5608.700004,        2.452582,    0,                   0}, //  215RA
{   88,  216,          1711.1,        2.048627,   16,           1.616e-26}, //  216RA
{   88,  216,          3763.5,        7.703992,   38,          4.8985e-26}, //  216RA
{   88,  216,          5170.5,        9.521787,    0,                   0}, //  216RA
{   88,  217,          2393.6,        6.665251,    0,                   0}, //  217RA
{   88,  217,          3825.5,        2.149616,    0,                   0}, //  217RA
{   88,  222,          242.11,        1.731234,    0,                   0}, //  222RA
{   88,  222,          301.39,        2.019773,    0,                   0}, //  222RA
{   88,  225,           31.56,         3.02966,    0,                   0}, //  225RA
{   88,  225,           42.77,        4.328085,    0,                   0}, //  225RA
{   88,  229,          142.67,        24.85764,    0,                   0}, //  229RA
{   88,  231,           66.21,        76462.84,    0,                   0}, //  231RA
{   88,  231,            95.5,        6.809521,    0,                   0}, //  231RA
{   89,  206,           4e-06,    4.760894e+07,    0,                   0}, //  206AC
{   89,  208,             506,    3.606738e+07,    0,                   0}, //  208AC
{   89,  215,            1621,        43.28085,   17,          3.9491e-26}, //  215AC
{   89,  215,            1796,        266.8986,   21,          4.8783e-26}, //  215AC
{   89,  215,     2438.000004,        483.3028,    0,                   0}, //  215AC
{   89,  216,              48,        636228.5,    0,                   0}, //  216AC
{   89,  216,      322.000004,        432.8085,    0,                   0}, //  216AC
{   89,  217,          1528.5,        14.42695,    0,                   0}, //  217AC
{   89,  217,          1682.3,        14.42695,    0,                   0}, //  217AC
{   89,  217,            2013,        1067.594,    0,                   0}, //  217AC
{   89,  218,      384.490005,        148.5976,    0,                   0}, //  218AC
{   89,  222,           4e-06,    9.088979e+10,    0,                   0}, //  222AC
{   89,  227,           27.37,        55.25522,    0,                   0}, //  227AC
{   90,  214,            2181,        1788.942,    0,                   0}, //  214TH
{   90,  216,            2040,        193321.1,    0,                   0}, //  216TH
{   90,  216,          2646.8,        836.7631,    0,                   0}, //  216TH
{   90,  216,          3681.4,        1067.594,    0,                   0}, //  216TH
{   90,  217,           673.8,          203.42,    0,                   0}, //  217TH
{   90,  218,          1765.8,        1.731234,    0,                   0}, //  218TH
{   90,  233,            1850,        72.13475,    0,                   0}, //  233TH
{   91,  217,            1850,         1731234,    0,                   0}, //  217PA
{   91,  219,           4e-06,        76.46284,    0,                   0}, //  219PA
{   91,  220,           4e-06,        1125.302,    0,                   0}, //  220PA
{   91,  231,          84.215,        65.06555,    0,                   0}, //  231PA
{   91,  233,          86.468,        51.50421,    0,                   0}, //  233PA
{   91,  234,       73.920004,     1.00325e+11,    0,                   0}, //  234PA
{   92,  218,            2105,        807909.2,    0,                   0}, //   218U
{   92,  234,          1421.3,        48330.28,    0,                   0}, //   234U
{   92,  234,          1552.6,        3.173929,    0,                   0}, //   234U
{   92,  235,          0.0765,    2.250604e+12,    0,                   0}, //   235U
{   92,  236,          687.59,        5.453387,    0,                   0}, //   236U
{   92,  236,          1052.5,        144.2695,    0,                   0}, //   236U
{   92,  236,            2750,        173.1234,    0,                   0}, //   236U
{   92,  237,          159.96,        4.472355,    0,                   0}, //   237U
{   92,  237,             274,        223.6177,    0,                   0}, //   237U
{   92,  238,          2557.9,        403.9546,    0,                   0}, //   238U
{   92,  239,           4e-06,        360.6738,    0,                   0}, //   239U
{   92,  239,           133.8,        1125.302,    0,                   0}, //   239U
{   93,  235,            49.1,        9.954596,    0,                   0}, //  235NP
{   93,  236,           4e-06,    1.168583e+14,    0,                   0}, //  236NP
{   93,  237,          59.541,        96.94911,    5,           8.484e-27}, //  237NP
{   93,  237,          267.56,        7.502014,    0,                   0}, //  237NP
{   93,  237,           945.2,        1024.313,    0,                   0}, //  237NP
{   93,  237,            2800,        64.92128,    0,                   0}, //  237NP
{   93,  238,          136.04,         8.65617,    0,                   0}, //  238NP
{   93,  238,            2300,        161.5818,    0,                   0}, //  238NP
{   93,  239,          74.664,        2.005346,    5,         1.02515e-26}, //  239NP
{   93,  240,           4e-06,    6.249755e+11,    0,                   0}, //  240NP
{   93,  242,           5e-06,    4.760894e+11,    0,                   0}, //  242NP
{   94,  234,            4170,        4.328085,    0,                   0}, //  234PU
{   94,  235,            3000,        36.06738,    0,                   0}, //  235PU
{   94,  236,          1185.5,        1731.234,    0,                   0}, //  236PU
{   94,  236,            4000,        49.05163,    0,                   0}, //  236PU
{   94,  237,          145.54,    2.596851e+08,    0,                   0}, //  237PU
{   94,  237,            2600,        139.9414,    0,                   0}, //  237PU
{   94,  237,            2900,        1586.965,    0,                   0}, //  237PU
{   94,  238,           968.2,        12.26291,    0,                   0}, //  238PU
{   94,  238,          1082.6,        12.26291,    0,                   0}, //  238PU
{   94,  238,            3500,         8.65617,    0,                   0}, //  238PU
{   94,  239,          285.46,        1.615818,    5,         -6.3125e-27}, //  239PU
{   94,  239,          391.58,        278.4401,    0,                   0}, //  239PU
{   94,  239,            3100,        10820.21,    0,                   0}, //  239PU
{   94,  239,            3303,        3.751007,    0,                   0}, //  239PU
{   94,  240,           4e-06,        5.193702,    0,                   0}, //  240PU
{   94,  240,          742.33,         2.88539,    0,                   0}, //  240PU
{   94,  240,          1030.5,        1.904357,    0,                   0}, //  240PU
{   94,  240,          1308.7,        238.0447,    0,                   0}, //  240PU
{   94,  241,          161.69,        1269.572,    0,                   0}, //  241PU
{   94,  241,            2200,         30296.6,    0,                   0}, //  241PU
{   94,  241,     2200.000004,        46.16624,    0,                   0}, //  241PU
{   94,  242,            2000,        5.049433,    0,                   0}, //  242PU
{   94,  242,     2000.000005,        40.39546,    0,                   0}, //  242PU
{   94,  243,           383.6,        476.0894,    0,                   0}, //  243PU
{   94,  243,            1700,        64.92128,    0,                   0}, //  243PU
{   94,  245,           264.5,        476.0894,    0,                   0}, //  245PU
{   94,  245,            2000,        129.8426,    0,                   0}, //  245PU
{   95,  235,           4e-06,    8.569609e+11,    0,                   0}, //  235AM
{   95,  236,           4e-06,    2.510289e+11,    0,                   0}, //  236AM
{   95,  237,            2400,        7.213475,    0,                   0}, //  237AM
{   95,  238,            2500,        50494.33,    0,                   0}, //  238AM
{   95,  239,            2500,        235.1593,    0,                   0}, //  239AM
{   95,  240,            3000,         1356133,    0,                   0}, //  240AM
{   95,  241,            2200,        1731.234,    0,                   0}, //  241AM
{   95,  242,            48.6,    6.419416e+18,   10,          4.8985e-27}, //  242AM
{   95,  242,            2200,    2.019773e+07,    0,                   0}, //  242AM
{   95,  243,              84,        3.375906,    5,          1.3635e-26}, //  243AM
{   95,  243,            2300,        7934.823,    0,                   0}, //  243AM
{   95,  244,           4e-06,         1298426,    0,                   0}, //  244AM
{   95,  244,           5e-06,        9377.518,    0,                   0}, //  244AM
{   95,  244,            86.1,    2.250604e+12,    0,                   0}, //  244AM
{   95,  245,            2400,        923.3248,    0,                   0}, //  245AM
{   95,  246,           4e-06,    2.164043e+12,    0,                   0}, //  246AM
{   95,  246,       43.810004,        6.203589,    0,                   0}, //  246AM
{   95,  246,            2000,        105316.7,    0,                   0}, //  246AM
{   96,  240,            3000,        79.34823,    0,                   0}, //  240CM
{   96,  241,            2300,        22.07323,    0,                   0}, //  241CM
{   96,  242,            2800,        259.6851,    0,                   0}, //  242CM
{   96,  243,            87.4,        1558.111,    0,                   0}, //  243CM
{   96,  243,            1900,        60.59319,    0,                   0}, //  243CM
{   96,  244,           4e-06,        721.3475,    0,                   0}, //  244CM
{   96,  244,          1040.2,    4.905163e+07,    0,                   0}, //  244CM
{   96,  245,          355.92,        418.3816,    0,                   0}, //  245CM
{   96,  245,            2100,        19.04357,    0,                   0}, //  245CM
{   96,  247,          227.38,        37942.88,    0,                   0}, //  247CM
{   96,  247,           404.9,        145.1351,    0,                   0}, //  247CM
{   96,  249,           48.76,        33181.99,    0,                   0}, //  249CM
{   96,  249,          375.23,        27.41121,    0,                   0}, //  249CM
{   97,  242,           4e-06,         13.7056,    0,                   0}, //  242BK
{   97,  242,           5e-06,         865.617,    0,                   0}, //  242BK
{   97,  243,            2200,        7.213475,    0,                   0}, //  243BK
{   97,  244,           4e-06,         1183.01,    0,                   0}, //  244BK
{   97,  245,            1560,         2.88539,    0,                   0}, //  245BK
{   97,  246,           4e-06,    2.243679e+14,    0,                   0}, //  246BK
{   97,  248,           4e-06,    1.230907e+14,    0,                   0}, //  248BK
{   97,  249,           8.777,        432808.5,    0,                   0}, //  249BK
{   97,  250,           35.59,        41838.16,    0,                   0}, //  250BK
{   97,  250,              86,          307294,    0,                   0}, //  250BK
{   97,  250,           97.49,        54.82241,    0,                   0}, //  250BK
{   97,  250,          175.13,        60.59319,    0,                   0}, //  250BK
{   97,  251,            35.5,        83676.31,    0,                   0}, //  251BK
{   98,  246,            2500,        64.92128,    0,                   0}, //  246CF
{   98,  249,          144.98,        64921.28,    0,                   0}, //  249CF
{   98,  251,          106.31,        54.82241,    0,                   0}, //  251CF
{   98,  251,          370.47,        1875.504,    0,                   0}, //  251CF
{   99,  246,           4e-06,    6.492128e+11,    0,                   0}, //  246ES
{   99,  250,           4e-06,    1.153002e+13,    0,                   0}, //  250ES
{   99,  254,            84.2,    2.041125e+14,    4,          1.4645e-26}, //  254ES
{   99,  256,           4e-06,    3.947214e+13,    0,                   0}, //  256ES
{  100,  247,           3e-06,    1.327279e+10,    0,                   0}, //  247FM
{  100,  250,           4e-06,    2.596851e+09,    0,                   0}, //  250FM
{  100,  251,             191,        21928.96,    0,                   0}, //  251FM
{  100,  256,          1425.5,        100.9887,    0,                   0}, //  256FM
{  101,  245,             300,    5.049433e+08,    0,                   0}, //  245MD
{  101,  246,           4e-06,    1.298426e+09,    0,                   0}, //  246MD
{  101,  246,           5e-06,    6.347858e+09,    0,                   0}, //  246MD
{  101,  249,           4e-06,    2.741121e+09,    0,                   0}, //  249MD
{  101,  254,           4e-06,     8.65617e+11,    0,                   0}, //  254MD
{  101,  254,           5e-06,    2.423728e+12,    0,                   0}, //  254MD
{  101,  258,           4e-06,    4.934017e+12,    0,                   0}, //  258MD
{  102,  251,             106,    1.471549e+09,    0,                   0}, //  251NO
{  102,  251,     1699.200004,         2885.39,    0,                   0}, //  251NO
{  102,  251,     1699.700004,         2885.39,    0,                   0}, //  251NO
{  102,  253,             167,        44867.82,    0,                   0}, //  253NO
{  102,  254,           4e-06,    4.039546e+08,    0,                   0}, //  254NO
{  103,  253,           4e-06,    2.149616e+09,    0,                   0}, //  253LR
{  104,  253,           4e-06,    1.586965e+07,    0,                   0}, //  253RF
{  104,  253,           5e-06,        69249.36,    0,                   0}, //  253RF
{  104,  257,           5e-06,    5.626511e+09,    0,                   0}, //  257RF
{  104,  261,           4e-06,    1.125302e+11,    0,                   0}, //  261RF
{  104,  261,             227,    4.472355e+09,    0,                   0}, //  261RF
{  105,  257,           4e-06,    2.164043e+09,    0,                   0}, //  257DB
{  105,  258,           5e-06,     2.88539e+10,    0,                   0}, //  258DB
{  105,  270,           4e-06,    1.194551e+14,    0,                   0}, //  270DB
{  106,  263,           5e-06,    1.731234e+08,    0,                   0}, //  263SG
{  106,  265,           4e-06,    2.337166e+10,    0,                   0}, //  265SG
{  106,  265,             150,    1.283999e+10,    0,                   0}, //  265SG
{  107,  262,           4e-06,    1.471549e+08,    0,                   0}, //  262BH
{  107,  262,           5e-06,    1.154156e+07,    0,                   0}, //  262BH
{  107,  267,           4e-06,    2.452582e+10,    0,                   0}, //  267BH
{  107,  274,           4e-06,    7.790553e+10,    0,                   0}, //  274BH
{  108,  265,             300,         1082021,    0,                   0}, //  265HS
{  108,  269,           4e-06,    1.399414e+10,    0,                   0}, //  269HS
{  109,  266,           4e-06,         2452582,    0,                   0}, //  266MT
{  109,  268,           4e-06,     3.02966e+07,    0,                   0}, //  268MT
{  109,  274,           4e-06,    6.492128e+08,    0,                   0}, //  274MT
{  109,  278,           4e-06,    1.096448e+10,    0,                   0}, //  278MT
{  110,  271,           4e-06,    9.954596e+07,    0,                   0}, //  271DS
{  111,  272,           4e-06,         5482241,    0,                   0}, //  272RG
{  111,  278,           4e-06,         6059319,    0,                   0}, //  278RG
{  111,  281,           4e-06,    3.751007e+10,    0,                   0}, //  281RG
{  111,  282,           4e-06,    7.213475e+08,    0,                   0}, //  282RG
{  113,  285,           4e-06,    7.934823e+09,    0,                   0}, //  28513
{  113,  286,           4e-06,     2.88539e+10,    0,                   0}, //  28613
{  115,  289,           4e-06,    3.173929e+08,    0,                   0}, //  28915
{  115,  290,           4e-06,    2.308312e+07,    0,                   0}, //  29015
{  117,  293,           4e-06,    2.019773e+07,    0,                   0}, //  29317
};
