//$Id: GAGpipe.java,v 1.2 2004/09/24 08:50:51 suzuki Exp $
// GAG (Geant4 Adaptive GUI)
// 2000 May 19 JDK1.2.2-RC4
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GAG;

import java.io.*;     

class GAGpipe extends Thread {
  private Process ps;
  private BufferedReader inpS, errS;
  private PrintWriter outS;
  private String errMsg;
  private boolean isErr;

  GAGpipe(String[] execFile){
    errMsg = null; isErr = false;
    try {
      ps = Runtime.getRuntime().exec(execFile);
    } catch(IOException e){
      isErr = true;
      errMsg = e.getMessage();
      return;
    }
    inpS = new BufferedReader(new InputStreamReader(ps.getInputStream()));
    errS = new BufferedReader(new InputStreamReader(ps.getErrorStream()));
    outS = new PrintWriter(new DataOutputStream(ps.getOutputStream()));
  }


    String readStdLine(){  // 2000 test if sync is good?
    String line = null;
    try{
      line=inpS.readLine();
    }catch(IOException e){
      isErr = true;
      errMsg = e.getMessage();
    }
    return line;
  }

  String readErrLine(){
    String line = null;
    try{
      line=errS.readLine();
    }catch(IOException e){
      isErr = true;
      errMsg = e.getMessage();
      System.err.println(errMsg);
    }
    return line;
  }

  synchronized boolean writeLine(String st){
    outS.println(st);
    return outS.checkError();
  }

  synchronized void processKill(){
    ps.destroy();
  }

  boolean isError(){
    return isErr;
  }

  String getErrorMsg(){
    if (!isErr) return "";
    return errMsg;
  }
}
