// $Id: Doxymodules_persistency.h 76473 2013-11-11 10:35:14Z gcosmo $
// The example class categories definitions for Doxygen

/// \file Doxymodules_persistency.h
/// \brief The page that defines the extended/persistency examples modules 


/** @defgroup extended_persistency persistency
 *  Extended examples persistency classes
 *  @{
 */

/** @defgroup extended_persistency_gdml gdml
 *  Extended examples persistency gdml classes
 *  @{
 */

/** @defgroup extended_persistency_gdml_G01 G01
 *  Persistency gdml example G01 
 *  @ingroup extended_persistency_gdml
 *  @{
 */

  class G01DetectorConstruction {};
  class G01PhysicsList {};
  class G01PrimaryGeneratorAction {};

/** @} */

/** @defgroup extended_persistency_gdml_G02 G02
 *  Persistency gdml example G02 
 *  @ingroup extended_persistency_gdml
 *  @{
 */

  class G02ChamberParameterisation {};
  class G02DetectorConstruction {};
  class G02DetectorMessenger {};
  class G02PrimaryGeneratorAction {};
  class G02RunAction {};

/** @} */

/** @defgroup extended_persistency_gdml_G03 G03
 *  Persistency gdml example G03
 *  @ingroup extended_persistency_gdml
 *  @{
 */

  class G03ColorReader {};
  class G03ColorWriter {};
  class G03DetectorConstruction {};
  class G03DetectorMessenger {};
  class G03PrimaryGeneratorAction {};
  class G03RunAction {};

/** @} */

/** @defgroup extended_persistency_gdml_G04 G04
 *  Persistency gdml example G04
 *  @ingroup extended_persistency_gdml
 *  @{
 */

  class G04DetectorConstruction {};
  class G04PhysicsList {};
  class G04PrimaryGeneratorAction {};
  class G04SensitiveDetector {};

/** @} */

/** @} */


/** @defgroup extended_persistency_P01 P01
 *  Persistency example P01
 *  @ingroup extended_persistency
 *  @{
 */

  class Classes {};
  class ExP01ChamberParameterisation {};
  class ExP01DetectorConstruction {};
  class ExP01DetectorMessenger {};
  class ExP01EventAction {};
  class ExP01MagneticField {};
  class ExP01PhysicsList {};
  class ExP01PrimaryGeneratorAction {};
  class ExP01RunAction {};
  class ExP01SteppingAction {};
  class ExP01SteppingVerbose {};
  class ExP01TrackerHit {};
  class ExP01TrackerSD {};
  class RootIO {};

/** @} */

/** @defgroup extended_persistency_P02 P02
 *  Persistency example P02
 *  @ingroup extended_persistency
 *  @{
 */

  class ExP02Classes {};
  class ExP02DetConstrReader {};
  class ExP02DetectorConstruction {};
  class ExP02GeoTree {};
  class ExP02PhysicsList {};
  class ExP02PrimaryGeneratorAction {};

/** @} */

/** @defgroup extended_persistency_P03 P03
 *  Persistency example P03
 *  @ingroup extended_persistency
 *  @{
 */

  class ExTGActionInitialization {};
  class ExTGDetectorConstruction {};
  class ExTGDetectorConstructionWithCpp {};
  class ExTGDetectorConstructionWithCuts {};
  class ExTGDetectorConstructionWithSD {};
  class ExTGPhysicsList {};
  class ExTGPrimaryGeneratorAction {};
  class ExTGRCDetectorBuilder {};
  class ExTGRCLineProcessor {};
  class ExTGRCRegionCutsMgr {};
  class ExTGRCRegionData {};
  class ExTGRunAction {};
  class ExTGTrackerHit {};
  class ExTGTrackerSD {};

/** @} */

/** @} */
