// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef HEPREP_HEPREPATTVALUE_H
#define HEPREP_HEPREPATTVALUE_H 1

// Copyright 2000-2005, FreeHEP.

#include <string>
#include <vector>

#include "HEPREP/Types.h"

namespace HEPREP {

/**
 * HepRepAttValue interface.
 *
 * @author Mark Donszelmann
 */
class HepRepAttValue {

public: 
    /// Destructor.
    virtual ~HepRepAttValue() { /* nop */; }

    /**
     * Returns name of the attvalue.
     *
     * @return Capitalized Name.
     */
    virtual std::string getName() = 0;

    /**
     * Returns lowercased name of the attvalue.
     *
     * @return Lowercased Name.
     */
    virtual std::string getLowerCaseName() = 0;

    /**
     * Returns type of the attvalue, defined in HepRepConstants with names TYPE_xxx.
     *
     * @return type.
     */
    virtual int getType() = 0;

    /**
     * Returns the Java-like name for the type of this attvalue.
     *
     * @return type name.
     */
    virtual std::string getTypeName() = 0;

    /**
     * Returns the flag bits for showing this attvalue as a label, defined in HepRepConstants with names SHOW_xxx.
     *
     * @return flag bits if should be shown as label.
     */
    virtual int showLabel() = 0;

    /**
     * Returns value as string.
     *
     * @return value as string (if type is string).
     */
    virtual std::string getString() = 0;

    /**
     * Returns value as lowercase string.
     *
     * @return value as string (if type is string).
     */
    virtual std::string getLowerCaseString() = 0;

    /**
     * Returns value as string.
     *
     * @return value (of any type) in string format.
     */
    virtual std::string getAsString() = 0;

    /**
     * Returns value as Color.
     *
     * @return value as Color.
     */
    virtual std::vector<double> getColor() = 0;

    /**
     * Returns value as long.
     *
     * @return value as long.
     */
    virtual int64 getLong() = 0;

    /**
     * Returns value as int.
     *
     * @return value as integer.
     */
    virtual int getInteger() = 0;

    /**
     * Returns value as double.
     *
     * @return value as double.
     */
    virtual double getDouble() = 0;

    /**
     * Returns value as boolean.
     *
     * @return value as boolean.
     */
    virtual bool getBoolean() = 0;

    /**
     * Returns a deep copy of this attvalue.
     *
     * @return copy of this attvalue.
     */
    virtual HepRepAttValue * copy() = 0;
}; // class
} // namespace HEPREP
#endif /* ifndef HEPREP_HEPREPATTVALUE_H */
