//$Id: CSGItem.java,v 1.2 2004/09/24 08:50:51 suzuki Exp $

//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import java.lang.Math;

public class CSGItem extends SolidItem {
  static final int BOX=0, TRD=1, TUBS=2, CONS=3 , SPHERE=4, PARALLEL=5,
                   TORUS=6, HYPE=7;
  static final String solidName[] = {"Box","SymTrapezoid",
                      "TubeSegment","ConeSegment","SphereSegment",
                                  "Parallelepiped","TorusSegment","HYPE"};

  static final String csgName[] = {"Box","Trd","Tubs",
                           "Cons","Sphere","Para","Torus","Hype"};

  static final String csgDAWNName[] = {"Box","Trd","Tubs",
                           "Cons","SphereSeg","Parallelepiped","Torus","Hype"};

  static final String solidConstr[] = {"Box","Trapezoid","TubeSegment",
                           "ConeSegment","SphereSegment","Parallelepiped",
                                                    "TorusSegment","HYPE"};
  static final String paraName[][] = {
        {"XHalfLength","YHalfLength","ZHalfLength"},
	{"XHalfLengthAt-dz", "XHalfLengthAt+dz", "YHalfLengthAt-dz", 
                                        "YHalfLengthAt+dz", "ZHalfLength"},
	{"InnerRadius", "OuterRadius", "ZHalfLength", "StartPhiAngle", 
                                                          "DeltaPhiAngle"},
	{"InnerRadiusAt-dz", "OuterRadiusAt-dz", "InnerRadiusAt+dz", 
         "OuterRadiusAt+dz","ZHalfLength","StartPhiAngle","DeltaPhiAngle"},
        {"InnerRadius","OuterRadius","StartPhiAngle","DeltaPhiAngle",
                                      "StartThetaAngle","DeltaThetaAngle"},
        {"XHalfLength","YHalfLength","ZHalfLength","Alpha", "Theta","phi"},
        {"InnerRadius","OuterRadius","SweptRadius","StartPhiAngle",
                                                          "DeltaPhiAngle"},
        {"InnerRadius","OuterRadius","InnerStereo","OuterStereo",
                                                            "ZHalfLength"},
    };
  static final boolean isAngl[][] = {{false, false, false},
                  {false, false, false, false, false},
                  {false, false, false, true, true},
       	          {false, false, false, false, false, true, true},
                  {false, false, true, true, true, true},
                  {false, false, false, true, true,true},
                  {false, false, false, true, true},
                  {false, false, true, true, false},
       };

  private double values[];
  private String units[];
  private double mmValue;
  private double bound;

public  CSGItem(int solidType){
    super(solidType);
    values = new double[paraName[solidType].length];
    units = new String[isAngl[solidType].length];
    isEmpty = true;
  }
  int getParaCount(){
    return paraName[solidType].length;
  }
  double getValues(int pos){
    return values[pos];
  }
  String getUnits(int pos){
    return units[pos];
  }
  void setValuesUnits(int pos, double value, String unit){
    values[pos] = value;
    units[pos] = unit;
    isEmpty = false;
  }
  String getParaName(int pos){
    return paraName[solidType][pos];
  }
  boolean isAngle(int pos){
    return isAngl[solidType][pos];
  }
  public String toString(){
    return solidName[solidType];
  }
    //MOMO  public String getCPP(String name){
   String getCPP(String name){
    StringBuffer cpp = new StringBuffer("G4"+csgName[solidType]+
                     " *solid" + name + "= new G4" + 
                     csgName[solidType] +"(\"solid"+name+"\""); 
    for (int i=0; i<values.length; i++){
      cpp.append(", "+ values[i]+"*"+units[i]);
    }
    cpp.append(" );\n");
    return cpp.toString();
  }

    String getXML(String name, int defNum){
     StringBuffer xml= new StringBuffer();
     int i = defNum;
      if(csgName[solidType]=="Box"){
	if(name==null || name.equals("")){
	   name = "box"+defNum; 
	}
        xml.append("     <box name=\""+name
                +"\" x=\"x-"+i+"\" y=\"y-"+i+"\" z=\"z-"+i+"\" />\n");

      }else if(csgName[solidType]=="Trd"){
	if(name==null || name.equals("")){
	  name = "trd"+defNum;
	}
        xml.append("     <trd name=\""+name
                +"\" x1=\"x1-"+i+"\" x2=\"x2-"+i
                +"\" y1=\"y1-"+i+"\" y2=\"y2-"+i
                +"\" z=\"z-"+i+"\" />\n");

      }else if(csgName[solidType]=="Tubs"){
	if(name ==null || name.equals("")){
	   name = "tube"+defNum;
	}
        xml.append("     <tube name=\""+name
                +"\" rmin=\"rmin-"+i+"\" rmax=\"rmax-"+i
                +"\" z=\"z-"+i
                +"\" startphi=\"startphi-"+i+"\" deltaphi=\"deltaphi-"+i
		+"\" />\n");

      }else if(csgName[solidType]=="Cons"){
	if(name==null || name.equals("")){
	   name = "cone"+defNum;
	}
        xml.append("     <cone name=\""+name
                +"\" rmin1=\"rmin1-"+i+"\" rmax1=\"rmax1-"+i
                +"\" rmin2=\"rmin2-"+i+"\" rmax2=\"rmax2-"+i
                +"\" z=\"z-"+i
                +"\" startphi=\"startphi-"+i+"\" deltaphi=\"deltaphi-"+i
		+"\" />\n");

      }else if(csgName[solidType]=="Sphere"){
	if(name==null || name.equals("")){
	   name = "sphere"+defNum;
	}
        xml.append("     <sphere name=\""+name
                +"\" rmin=\"rmin-"+i+"\" rmax=\"rmax-"+i
                +"\" startphi=\"startphi-"+i+"\" deltaphi=\"deltaphi-"+i
                +"\" starttheta=\"starttheta-"+i
                +"\" deltatheta=\"deltatheta-"+i+"\" />\n");

      }else if(csgName[solidType]=="Para"){
	if(name==null || name.equals("")){
	   name = "para"+defNum;
	}
        xml.append("     <para name=\""+name
                +"\" x=\"x-"+i+"\" y=\"y-"+i+"\" z=\"z-"+i
                +"\" alpha=\"alpha-"+i+"\" theta=\"theta-"+i
                +"\" phi=\"phi-"+i+"\" />\n");

     /*}else{
        xml.append("     <"+csgName[solidType]+" name=\""+name+"\" ");
           for(int j=0; j<values.length; j++){
              xml.append(values[j]);
           }*/
      }

      return xml.toString();
     }

   String getDefine(String name, int defNum){
     StringBuffer xml = new StringBuffer();
     int solidNum = 0;
     boolean isGDMLSolid = true;
     String xmlparaName[][] = {{"x", "y", "z"},
        {"x1", "x2", "y1", "y2", "z"},
        {"rmin", "rmax", "z", "startphi", "deltaphi"},
        {"rmin1", "rmax1", "rmin2", "rmax2", "z", "startphi", "deltaphi"},
        {"rmin", "rmax", "startphi", "deltaphi", "starttheta", "deltatheta"},
                {"x", "y", "z", "alpha", "theta", "phi"} };
     if(csgName[solidType]=="Box"){ solidNum = 0;}
     else if(csgName[solidType]=="Trd"){ solidNum = 1; }
     else if(csgName[solidType]=="Tubs"){ solidNum = 2; }
     else if(csgName[solidType]=="Cons"){ solidNum = 3; }
     else if(csgName[solidType]=="Sphere"){ solidNum = 4; }
     else if(csgName[solidType]=="Para"){ solidNum = 5; }
     else{ isGDMLSolid = false; }
     if( isGDMLSolid != false){
       for(int i=0; i < values.length; i++){
          xml.append("        <quantity name=\""+xmlparaName[solidNum][i]+"-"
                        +defNum+"\" value=\""+values[i]+"\" unit=\""
                        +units[i]+"\"/>\n");
       }
     }

     return xml.toString();
   }

  private double changMM(int count){
       
       if(getUnits(count).equals("km")){
          mmValue = Math.pow(values[count]*1000000,2.0);
       }else if(getUnits(count).equals("m")){
          mmValue = Math.pow(values[count]*1000,2.0);
       }else if(getUnits(count).equals("cm")){
          mmValue = Math.pow(values[count]*10,2.0);
       }else if(getUnits(count).equals("micrometer")){
          mmValue = Math.pow(values[count]/1000,2.0);
       }else if(getUnits(count).equals("nanoometer")){
          mmValue = Math.pow(values[count]/1000000,2.0);
       }else if(getUnits(count).equals("fermi")){
          mmValue = Math.pow(values[count]/1000000000,2.0);
       }else if(getUnits(count).equals("mm")){
          mmValue = Math.pow(values[count],2.0);
       }else{
          mmValue = 0;
       }
       return mmValue;
  }

  private double Bound(){ 
    bound = 0.0;
    for (int j=0; j<values.length; j++){
      bound += changMM(j);
    }
    return Math.sqrt(bound)*2;
  } 

  public String getPrim(){
   StringBuffer prim = new StringBuffer("#################################\n");
    prim.append("###         GGESolid.prim      ###\n");
    prim.append("#################################\n#\n");

    prim.append("/BoundingBox ");
    prim.append(" -"+Bound()+"   -"+Bound()+"   -"+Bound()+"   ");
    prim.append(Bound()+"   "+Bound()+"   "+Bound()+"\n");

    prim.append("!SetCamera\n!OpenDevice\n!BeginModeling\n\n");
    prim.append("/"+csgDAWNName[solidType]);
    for (int j=0; j<values.length; j++){
       if(getUnits(j).equals("km")){
          prim.append("    "+values[j]*1000000);
       }else if(getUnits(j).equals("m")){
          prim.append("    "+values[j]*1000);
       }else if(getUnits(j).equals("cm")){
          prim.append("    "+values[j]*10);
       }else if(getUnits(j).equals("micrometer")){
          prim.append("    "+values[j]/1000);
       }else if(getUnits(j).equals("nanoometer")){
          prim.append("    "+values[j]/1000000);
       }else if(getUnits(j).equals("fermi")){
          prim.append("    "+values[j]/1000000000);
       }else if(getUnits(j).equals("mm")){
          prim.append("    "+values[j]);
       }else if(getUnits(j).equals("mrad")){
          prim.append(" "+values[j]/1000);
       }else if(getUnits(j).equals("deg")){
          prim.append(" "+values[j]*2*3.14159265358979323/360);
       }else{
          prim.append(" "+values[j]);
       }
    }
    prim.append("\n\n!EndModeling\n!DrawAll\n!CloseDevice");
    return prim.toString();
  }
}

// pX,pY,pZ - The box's half-widths

// pDx1    Half-length along x at the surface positioned at -dz
// pDx2    Half-length along x at the surface positioned at +dz
// pDy1    Half-length along y at the surface positioned at -dz
// pDy2    Half-length along y at the surface positioned at +dz
// pDz     Half-length along z axis

// pRMin   Inside radius
// pRMax   Outside radius
// pDz     half length in z
// pSPhi   The starting phi angle in radians,
//         adjusted such the fSPhi+fDPhi<=2PI,
//         fSPhi>-2PI
// pDPhi   Delta angle of the segment in radians

// pRMin1  inside radius at  -Dz
// pRMin2  inside radius at  +Dz
// pRMax1  outside radius at -Dz
// pRMax2  outside radius at +Dz
// pDz     half length in z
// pSPhi   starting angle of the segment in radians
// pDPhi   delta angle of the segment in radian
