//$Id: GAGConsole.java,v 1.2 2004/09/24 08:50:51 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

package GAG;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class GAGConsole extends JPanel{

   JTextArea  textArea = new JTextArea(25, 20);
   String line;

   public GAGConsole(){

        setLayout(new BorderLayout());

        textArea.setEditable(false);
        textArea.setTabSize(4);
        textArea.setBackground(Color.BLACK);
	textArea.setForeground(Color.WHITE);
	
        add(new JScrollPane(textArea));

   }

   public void setLine(String line){
	this.line = line;

	if(textArea.getLineCount() < 200){
	  textArea.append(line);
	  textArea.append("\n");
	  textArea.setCaretPosition( textArea.getText().length() );
	}else{
	  try{
	    textArea.getDocument().remove(0, 100);
	  }catch(Exception e){}
	  textArea.append(line);
	  textArea.append("\n");
	  textArea.setCaretPosition( textArea.getText().length() );
	}

   }
}

