//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import javax.swing.*;
//import javax.swing.plaf.basic.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class VisAtbPanel extends JPanel implements ActionListener, ListSelectionListener {
  private JButton addVis, delVis;
  JList visList;
  VisAtbItem visItem;
  public GGEListModel listModel;
  private VisAtbDialog visDialog;

  VisAtbPanel(VolumesFrame parent){
    setLayout(new BorderLayout());
    setBorder(new TitledBorder(LineBorder.createBlackLineBorder(),
                                                      " VisAttrib "));
    visList = new JList(listModel = new GGEListModel());
    JPanel buttons = new JPanel(new BorderLayout());
    buttons.add("Center", addVis = new JButton(" Create "));
    buttons.add("East", delVis = new JButton("Del"));
    delVis.setEnabled(false);
    add("North", buttons);
    visDialog = new VisAtbDialog(parent);
    addVis.addActionListener(this);
    delVis.addActionListener(this);
    visList.addListSelectionListener(this);
    visList.addMouseListener(new editVis());
    //MOMO renderer DEBUG
    //visList.setCellRenderer(new VisCellRenderer());

    JScrollPane scrollpane = new JScrollPane(visList);
    scrollpane.setPreferredSize(new Dimension(80,270));
    scrollpane.setMinimumSize(new Dimension(50,30));
    add("Center", scrollpane);
  }

  VisAtbItem getSelectedVis(){
    return (VisAtbItem)visList.getSelectedValue();
  }

  String[] getColorName(){
     int size = listModel.getSize();
     String[] colName = new String[size];
     for(int i=0; i < size; i++){
        colName[i] = listModel.elementAt(i).toString();
     }
     return colName;
  }

  public void actionPerformed(ActionEvent ae){
    Object o = ae.getSource();
    if (o == addVis){
      addVis.setForeground(Color.red);
      VisAtbItem visItem = visDialog.getNewAtb();
      if (visItem == null) return;
      listModel.addElement(visItem);
      addVis.setForeground(Color.black);
      repaint();
    }else if (o == delVis){
      delVis.setForeground(Color.red);
      int index = visList.getSelectedIndex();
      if (index < 0) return;
      listModel.removeElementAt(index);
    }
  }


  public void visCloseAct(){addVis.setForeground(Color.black);}  

  public void visClear(){
    visList.setModel(listModel = new GGEListModel());
    repaint();
  }

 
  public void valueChanged(ListSelectionEvent le){
    if (le.getValueIsAdjusting()) return;
    //    select(visList.getSelectedIndex());
    //System.out.println(le);
    delVis.setEnabled(!(visList.getSelectedIndex() < 0));
  }
  class editVis extends MouseAdapter {
    public void mouseClicked(MouseEvent e){
      if (e.getClickCount() == 2){
	int index = visList.locationToIndex(e.getPoint());
	if (index < 0) return;
	VisAtbItem newItem = visDialog.getChangedAtb((VisAtbItem)listModel.getElementAt(index));
	if (newItem == null) return;
	listModel.setElementAt(newItem, index);
      }
    }
  }

  public String getCPP(){
    StringBuffer cpp = new StringBuffer("\n// Visualization attributes\n\n");
    if (listModel.getSize()==0){
      return cpp.toString();
    }else{
     for(int i=0; i<listModel.getSize(); i++){
      VisAtbItem vObject = (VisAtbItem)listModel.elementAt(i);
      cpp.append("\nG4VisAttributes * ");

      //BUGBUG 2002 July 10 getCPP mat data size = 0 BUGBUG

      cpp.append(vObject.name+"= new G4VisAttributes( G4Colour(");
      cpp.append(vObject.color.getRed()+"/255. ,"+vObject.color.getGreen()+"/255. ,"+vObject.color.getBlue()+"/255. ));\n");
// next line added 2010 11/19
      cpp.append(vObject.name+" -> SetVisibility(true);");
      for (int j=0; j<vObject.atbsIsValid.length; j++){
        if (vObject.atbsIsValid[j]){
          cpp.append(vObject.name+ "->Set"+vObject.atbMethodName[j]+"("+vObject.atbsValue[j]+");\n");
        }
      }
     }
     return cpp.toString();
    }
  }

  String getXML(){
    StringBuffer xml = new StringBuffer("\n  <!-Visualization attributes->\n\n");
    if (listModel.getSize()==0){
      return xml.toString();
    }else{
     for(int i=0; i<listModel.getSize(); i++){
      VisAtbItem vObject = (VisAtbItem)listModel.elementAt(i);
      xml.append("\nG4VisAttributes * ");

      //BUGBUG 2002 July 10 getCPP mat data size = 0 BUGBUG

      xml.append(vObject.name+"= new G4VisAttributes( G4Colour(");
      xml.append(vObject.color.getRed()+"/255. ,"+vObject.color.getGreen()+"/255. ,"+vObject.color.getBlue()+"/255. ));\n");
      for (int j=0; j<vObject.atbsIsValid.length; j++){
        if (vObject.atbsIsValid[j]){
          xml.append(vObject.name+ "->Set"+vObject.atbMethodName[j]+"("+vObject.atbsValue[j]+");\n");
        }
      }
     }
     return xml.toString();
    }
  }

}


//  2.15.1998

//class VisCellRenderer extends BasicListCellRenderer {

class VisCellRenderer extends JLabel implements ListCellRenderer {
  public Component getListCellRendererComponent(JList list, Object value, 
		       int index, boolean isSelected, boolean cellHasFocus){

      //  setIcon(new VisIcon(((VisAtbItem)value).color));
      //Color color = ((VisAtbItem)value).color;
      //	this.setForeground(color);
      //	if( visList.getSelectedIndex() < 0 ) return;
      /*
      if (isSelected ) {
	setOpaque(true);
	setForeground(color);
      } else {
	  setOpaque(false);
      }
      */
    //    return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

    return this;
  }

  class VisIcon implements Icon {
    Color color;
    VisIcon(Color color){
      this.color = color;
    }
    public void paintIcon(Component c, Graphics g, int x, int y){
      g.setColor(color);
      g.fillOval(0,0,10,10);
    }

    public int getIconWidth(){
      return 8;
    }

    public int getIconHeight(){
      return 8;
    }
  }
}











