//$Id: ElementCell.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//MOMO
public class ElementCell extends JPanel implements ActionListener {
  static int selectedElems = 0;
  ElementItem ei;
  private boolean isSelected;
  private JButton e;
  private Color bg;
//MOMO
public  ElementCell(ElementItem ei){
    this.ei = ei;
    isSelected = false;
    setLayout(new GridLayout(2,1));
    if (ei.isMetal){
      bg =  new Color(255, 175, 175);
    }else{
      bg  = new Color(175, 175, 255);
    }
    setBackground(bg);
    e = new JButton(ei.symbol);
    e.setMargin(new Insets(1,3,1,3));
    e.setToolTipText(ei.name);
    e.addActionListener(this);
    add(e);
    add(new JLabel(Integer.toString(ei.atomNum), JLabel.CENTER));
  }
  public void actionPerformed(ActionEvent ev){
    Object source = ev.getSource();
    if (isSelected){
      selectedElems--;
      isSelected = false;
      setBackground(bg);
    }else{
	if (selectedElems >= 20) return; //2003 Dec increased
      selectedElems++;
      isSelected = true;
      //      setBackground(Color.lightGray);
      setBackground(Color.green);
    }
    repaint();
  }
  void clear(){
    selectedElems = 0;
    isSelected = false;
    setBackground(bg);
    repaint();
  }
  boolean isSelected(){
    return isSelected;
  }
}













