/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.BREPItem;
import GGE.CSGItem;
import GGE.GGETableModel;
import GGE.MaterialCombiTable;
import GGE.MaterialScratchTable;
import GGE.NameCellEditor;
import GGE.SolidCellEditor;
import GGE.SolidItem;
import GGE.VolumesFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class LogicalPanel
extends JPanel
implements ActionListener,
MouseListener {
    private JButton ok;
    private JButton app;
    private JButton ins;
    private JButton del;
    private JComboBox solidSelect;
    private JComboBox matSelect;
    private JComboBox colorSelect;
    DefaultComboBoxModel matComboModel;
    DefaultComboBoxModel colComboModel;
    private JFrame messageFrame;
    private JFrame frame1;
    JTable logTable;
    MaterialScratchTable msTable;
    MaterialCombiTable mcTable;
    private boolean noSld = false;
    private StringBuffer noSldName;
    public GGETableModel logDataModel;
    String[] tableIdent = new String[]{"Name", "Solid", "Material", "VisAtb"};
    VolumesFrame volFrame;

    LogicalPanel(VolumesFrame volFrame) {
        int i;
        this.volFrame = volFrame;
        this.setLayout(new BorderLayout(2, 2));
        this.noSldName = new StringBuffer();
        this.logDataModel = new GGETableModel(this.tableIdent, 0);
        this.logTable = new JTable(this.logDataModel);
        this.logTable.setAutoCreateColumnsFromModel(false);
        this.logTable.setColumnSelectionAllowed(true);
        this.logTable.setRowSelectionAllowed(true);
        this.logTable.getTableHeader().setReorderingAllowed(false);
        this.logTable.setSelectionMode(0);
        this.logTable.addMouseListener(this);
        this.matSelect = new JComboBox();
        this.matSelect.setEditable(true);
        this.matComboModel = new DefaultComboBoxModel();
        this.matSelect.setModel(this.matComboModel);
        this.matComboModel.addElement("");
        this.colorSelect = new JComboBox();
        this.colorSelect.setEditable(true);
        this.colComboModel = new DefaultComboBoxModel();
        this.colorSelect.setModel(this.colComboModel);
        this.colComboModel.addElement("");
        TableColumn[] columns = new TableColumn[this.tableIdent.length];
        for (int i2 = 0; i2 < this.tableIdent.length; ++i2) {
            columns[i2] = this.logTable.getColumn(this.tableIdent[i2]);
        }
        DefaultTableCellRenderer logNameCellRenderer = new DefaultTableCellRenderer();
        logNameCellRenderer.setBackground(Color.pink);
        columns[0].setCellEditor(new NameCellEditor());
        columns[0].setCellRenderer(logNameCellRenderer);
        columns[0].setMinWidth(50);
        columns[1].setCellEditor(new SolidCellEditor(volFrame));
        columns[1].setMinWidth(60);
        columns[2].setCellEditor(new DefaultCellEditor(this.matSelect));
        columns[2].setMinWidth(60);
        columns[3].setCellEditor(new DefaultCellEditor(this.colorSelect));
        columns[3].setMinWidth(50);
        JScrollPane scrollpane = new JScrollPane(this.logTable);
        scrollpane.setPreferredSize(new Dimension(350, 270));
        scrollpane.setMinimumSize(new Dimension(100, 30));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout(2, 2));
        tablePanel.setBorder(new TitledBorder(LineBorder.createBlackLineBorder(), " Logical Volume "));
        tablePanel.add("Center", scrollpane);
        JPanel south = new JPanel(new BorderLayout());
        this.solidSelect = new JComboBox();
        this.solidSelect.setMaximumRowCount(10);
        for (i = 0; i < CSGItem.solidName.length; ++i) {
            this.solidSelect.addItem(new CSGItem(i));
        }
        for (i = 0; i < BREPItem.solidName.length; ++i) {
            this.solidSelect.addItem(new BREPItem(i));
        }
        south.add("West", new JLabel("Select a solid "));
        south.add("Center", this.solidSelect);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3));
        this.app = new JButton("Append");
        buttonPanel.add(this.app);
        this.ins = new JButton("Insert");
        buttonPanel.add(this.ins);
        this.del = new JButton("Delete");
        buttonPanel.add(this.del);
        this.app.setForeground(Color.cyan);
        this.ins.setForeground(Color.cyan);
        this.del.setForeground(Color.cyan);
        south.add("North", buttonPanel);
        JPanel materialPane = new JPanel();
        materialPane.setBorder(new TitledBorder(LineBorder.createBlackLineBorder(), " Materials "));
        materialPane.setLayout(new BorderLayout(2, 2));
        this.ok = new JButton("Mark the Used Materials");
        materialPane.add("North", this.ok);
        this.ok.addActionListener(this);
        this.ok.setForeground(Color.cyan);
        this.ins.addActionListener(this);
        this.del.addActionListener(this);
        this.app.addActionListener(this);
        tablePanel.add("North", south);
        this.add("Center", tablePanel);
        this.add("South", materialPane);
        this.setSize(250, 580);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.ok) {
            this.ok.setForeground(Color.red);
            JOptionPane opane = new JOptionPane();
            int choose = JOptionPane.showConfirmDialog(this, "Clear and set flags to materials Used in Logical Volum", "Used Materials Dialog", 0);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (choose == 0) {
                this.volFrame.okCommand();
                this.ok.setForeground(Color.black);
            } else {
                this.ok.setForeground(Color.black);
                return;
            }
        }
        if (o == this.app) {
            this.addLogicalRow();
            this.app.setForeground(Color.red);
            this.repaint();
            this.appLogCloseAct();
            return;
        }
        if (o == this.ins) {
            this.insertLogicalRow();
            this.ins.setForeground(Color.red);
            return;
        }
        if (o == this.del) {
            this.dell();
            this.del.setForeground(Color.red);
        }
    }

    public void dellLogCloseAct() {
        this.del.setForeground(Color.black);
        this.repaint();
    }

    public void appLogCloseAct() {
        this.app.setForeground(Color.black);
        this.repaint();
    }

    public void insertLogCloseAct() {
        this.ins.setForeground(Color.black);
        this.repaint();
    }

    public void logClear() {
        this.logDataModel = new GGETableModel(this.tableIdent, 0);
        this.logTable.setModel(this.logDataModel);
        this.repaint();
    }

    public void addLogicalRow() {
        SolidItem seleItem = (SolidItem)this.solidSelect.getSelectedItem();
        Object[] newRow = new Object[4];
        newRow[0] = "";
        newRow[2] = "";
        newRow[1] = seleItem instanceof CSGItem ? new CSGItem(seleItem.getSolidType()) : new BREPItem(seleItem.getSolidType());
        newRow[3] = this.volFrame.visPanel.getSelectedVis();
        if (newRow[3] == null) {
            newRow[3] = "";
        }
        this.logDataModel.addRow(newRow);
        this.appLogCloseAct();
        this.app.setForeground(Color.black);
        this.repaint();
    }

    public void insertLogicalRow() {
        SolidItem seleItem = (SolidItem)this.solidSelect.getSelectedItem();
        Object[] newRow = new Object[4];
        newRow[0] = "";
        newRow[2] = "";
        newRow[1] = seleItem instanceof CSGItem ? new CSGItem(seleItem.getSolidType()) : new BREPItem(seleItem.getSolidType());
        newRow[3] = this.volFrame.visPanel.getSelectedVis();
        if (newRow[3] == null) {
            newRow[3] = "";
        }
        if (this.logTable.getSelectedRow() == -1) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the Name", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {}
        } else {
            int logRowCount = this.logTable.getSelectedRow() + 1;
            this.logDataModel.insertRow(logRowCount, newRow);
            this.ins.setForeground(Color.black);
            this.repaint();
        }
    }

    public void dell() {
        if (this.logTable.getSelectedRow() == -1) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the Name", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.stopEditing();
            this.logDataModel.removeRow(this.logTable.getSelectedRow());
            this.del.setForeground(Color.black);
            this.repaint();
        }
    }

    public void stopEditing() {
        int row = 0;
        int column = 0;
        row = this.logTable.getEditingRow();
        if (row != -1 && (column = this.logTable.getEditingColumn()) != -1) {
            TableCellEditor cellEditor = this.logTable.getCellEditor(row, column);
            cellEditor.stopCellEditing();
        }
    }

    Vector getSaveData() {
        Vector logicalData = new Vector();
        Component[] compo = this.getComponents();
        for (int i = 0; i < compo.length; ++i) {
        }
        return logicalData;
    }

    void setLoadData(Vector logicalData) {
        this.removeAll();
        for (int i = 0; i < logicalData.size(); ++i) {
        }
        this.validate();
    }

    public String getCPP() {
        StringBuffer cpp = new StringBuffer("\n// Logical  Volumes\n\n");
        this.stopEditing();
        Vector data = this.logDataModel.getDataVector();
        if (data.size() == 0) {
            return cpp.toString();
        }
        for (int i = 0; i < data.size(); ++i) {
            Vector rowData = (Vector)data.elementAt(i);
            String name = (String)rowData.elementAt(0);
            SolidItem solid = (SolidItem)rowData.elementAt(1);
            cpp.append(solid.getCPP(name));
            cpp.append("G4LogicalVolume * " + name + " = new G4LogicalVolume(solid" + name + ", \t //its solid\n" + "\t\t\t " + rowData.elementAt(2) + ", \t\t //its material\n" + "\t\t\t\"" + name + "\" ,\t\t //its name\n" + "\t\t\t 0,0,0);\n\n");
            if (rowData.elementAt(3).equals("")) continue;
            cpp.append(name + "->SetVisAttributes(" + rowData.elementAt(3) + ");\n\n");
        }
        return cpp.toString();
    }

    String getXML() {
        StringBuffer xml = new StringBuffer("\n<!--Solid-->\n");
        StringBuffer solidxml = new StringBuffer();
        StringBuffer logicalxml = new StringBuffer("\n<!--Logical Volumes-->\n\n");
        StringBuffer defxml = new StringBuffer();
        this.stopEditing();
        Vector data = this.logDataModel.getDataVector();
        this.noSld = false;
        this.noSldName.delete(0, this.noSldName.length());
        if (data.size() == 0) {
            return xml.toString();
        }
        xml.append("  <solids>\n");
        defxml.append("     <define>\n");
        logicalxml.append("  <structure>\n");
        for (int i = 0; i < data.size(); ++i) {
            Vector rowData = (Vector)data.elementAt(i);
            String name = (String)rowData.elementAt(0);
            SolidItem solid = (SolidItem)rowData.elementAt(1);
            String solidName = solid.toString();
            solidxml.append(solid.getXML(name, i));
            defxml.append(solid.getDefine(name, i));
            logicalxml.append("     <volume name=\"" + rowData.elementAt(0) + "\">\n" + "\t<solidref ref=\"");
            if (solidName == "Box") {
                solidName = "box" + i;
            } else if (solidName == "SymTrapezoid") {
                solidName = "trd" + i;
            } else if (solidName == "TubeSegment") {
                solidName = "tube" + i;
            } else if (solidName == "ConeSegment") {
                solidName = "cone" + i;
            } else if (solidName == "SphereSegment") {
                solidName = "sphere" + i;
            } else if (solidName == "Parallelepiped") {
                solidName = "para" + i;
            } else if (solidName == "TorusSegment") {
                solidName = "torus";
                this.noSld = true;
                this.noSldName.append("TorusSegment\n");
            } else if (solidName == "HYPE") {
                solidName = "hype";
                this.noSld = true;
                this.noSldName.append("HYPE\n");
            } else if (solidName == "PolyConeSegment") {
                solidName = "pcon";
                this.noSld = true;
                this.noSldName.append("PolyConeSegment\n");
            } else if (solidName == "PolyGonSegment") {
                solidName = "pgon";
                this.noSld = true;
                this.noSldName.append("PolyGonSegment\n");
            } else {
                this.noSld = true;
                this.noSldName.append(solidName);
            }
            logicalxml.append(solidName + "\"/>\n");
            logicalxml.append("\t<materialref ref=\"" + rowData.elementAt(2) + "\"/>\n");
            logicalxml.append("     </volume>\n");
        }
        defxml.append("     </define>\n");
        xml.append(defxml.toString());
        xml.append(solidxml.toString());
        xml.append("  </solids>\n");
        logicalxml.append("  </structure>\n");
        xml.append(logicalxml.toString());
        return xml.toString();
    }

    boolean isSaveOk() {
        return this.noSld;
    }

    String noSldName() {
        return this.noSldName.toString();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        if (table.getSelectedColumn() == 2) {
            int i;
            String[] matStr = this.volFrame.getMaterialName();
            int modelSize = this.matComboModel.getSize();
            String[] modelStr = new String[modelSize];
            for (int i2 = 0; i2 < modelSize; ++i2) {
                modelStr[i2] = this.matComboModel.getElementAt(i2).toString();
            }
            boolean exist = false;
            for (i = 0; i < matStr.length; ++i) {
                for (int j = 0; j < modelSize; ++j) {
                    if (!modelStr[j].equals(matStr[i])) continue;
                    exist = true;
                }
                if (!exist) {
                    this.matComboModel.addElement(matStr[i]);
                }
                exist = false;
            }
            modelSize = this.matComboModel.getSize();
            modelStr = new String[modelSize];
            for (i = 0; i < modelSize; ++i) {
                modelStr[i] = this.matComboModel.getElementAt(i).toString();
            }
            exist = false;
            for (int j = 0; j < modelSize; ++j) {
                for (int i3 = 0; i3 < matStr.length; ++i3) {
                    if (!modelStr[j].equals(matStr[i3])) continue;
                    exist = true;
                }
                if (!exist && !modelStr[j].equals("")) {
                    this.matComboModel.removeElementAt(j);
                }
                exist = false;
            }
            this.repaint();
        } else if (table.getSelectedColumn() == 3) {
            int i;
            String[] colStr = this.volFrame.visPanel.getColorName();
            int modelSize = this.colComboModel.getSize();
            String[] modelStr = new String[modelSize];
            for (int i4 = 0; i4 < modelSize; ++i4) {
                modelStr[i4] = this.colComboModel.getElementAt(i4).toString();
            }
            boolean exist = false;
            for (i = 0; i < colStr.length; ++i) {
                for (int j = 0; j < modelSize; ++j) {
                    if (!modelStr[j].equals(colStr[i])) continue;
                    exist = true;
                }
                if (!exist) {
                    this.colComboModel.addElement(colStr[i]);
                }
                exist = false;
            }
            modelSize = this.colComboModel.getSize();
            modelStr = new String[modelSize];
            for (i = 0; i < modelSize; ++i) {
                modelStr[i] = this.colComboModel.getElementAt(i).toString();
            }
            exist = false;
            for (int j = 0; j < modelSize; ++j) {
                for (int i5 = 0; i5 < colStr.length; ++i5) {
                    if (!modelStr[j].equals(colStr[i5])) continue;
                    exist = true;
                }
                if (!exist && !modelStr[j].equals("")) {
                    this.colComboModel.removeElementAt(j);
                }
                exist = false;
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

