/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GPE.ExampleFileFilter;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

class DAWNSourceFrame
extends JFrame
implements ActionListener {
    private JMenuItem close;
    private JMenuItem save;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private String fileName;
    public JTextArea dawnEditor;
    private JFileChooser fileChooser;

    DAWNSourceFrame() {
        super(" DAWN Text Editor");
        this.getContentPane().setLayout(new BorderLayout());
        this.dawnEditor = new JTextArea();
        JScrollPane scroller = new JScrollPane();
        JViewport port = scroller.getViewport();
        port.add(this.dawnEditor);
        this.setJMenuBar(this.createMenubar());
        this.getContentPane().add("Center", scroller);
        this.pack();
        this.setSize(350, 350);
    }

    JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        this.close = new JMenuItem("Close");
        file.add(this.close);
        this.save = new JMenuItem("Save");
        file.add(this.save);
        JMenu edit = new JMenu("Edit");
        this.cut = new JMenuItem("Cut");
        edit.add(this.cut);
        this.copy = new JMenuItem("Copy");
        edit.add(this.copy);
        this.paste = new JMenuItem("Paste");
        edit.add(this.paste);
        mb.add(file);
        mb.add(edit);
        this.close.addActionListener(this);
        this.save.addActionListener(this);
        this.cut.addActionListener(this);
        this.copy.addActionListener(this);
        this.paste.addActionListener(this);
        return mb;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.save) {
            this.saveAction();
            return;
        }
        if (o == this.close) {
            this.setVisible(false);
        }
        if (o == this.cut) {
            this.dawnEditor.cut();
            return;
        }
        if (o == this.copy) {
            this.dawnEditor.copy();
            return;
        }
        if (o == this.paste) {
            this.dawnEditor.paste();
            return;
        }
    }

    void saveAction() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        this.fileChooser.setDialogTitle("Save C++ Source Code");
        this.fileChooser.setDialogType(1);
        ExampleFileFilter primFile = new ExampleFileFilter("prim", "PRIM Source Code");
        this.fileChooser.setFileFilter(primFile);
        this.fileChooser.showDialog(this, null);
        this.fileChooser.getSelectedFile();
        File f = this.fileChooser.getSelectedFile();
        this.fileName = f.getPath();
        try {
            FileOutputStream fo = new FileOutputStream(this.fileName);
            PrintWriter outf = new PrintWriter(new DataOutputStream(fo));
            outf.println(this.dawnEditor.getText());
            outf.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }
}

