//$Id: ProcessesTable.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
//Process table
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//



package GPE;



import java.awt.*;



import java.awt.event.*;



import javax.swing.*;



import javax.swing.table.*;



import javax.swing.event.*;



import java.util.*;





class ProcessesTable extends AbstractGPEFrame implements ActionListener {



    private ProcessCell procel[];

    PhysicsFrame phyFrame;



   JButton changeProcessButton, closeTableButton;



    ProcessesTable(PhysicsFrame phyFrame){



        super("EMProcesses Table");



        this.phyFrame = phyFrame;



        GridBagLayout gbl = new GridBagLayout();



        GridBagConstraints gbc = new GridBagConstraints();



        //getContentPane().setLayout(gbl);



        //getContentPane().setBackground(new Color(230, 250, 230));







        int proPosX[] = {2,              //0



                         2, 3, 4, 5,     //1



                         2, 3, 4, 5,     //2



                         2, 3,           //3



                         2, 3,           //4



                         2, 3, 4, 5,     //5



                         2,              //6



                         2,              //7



                         2, 3, 4,          //8



                         2, 3, 4,        //9



	                 2, 3,           //10



	                 2, 3, 4, 5,     //11



	                 2, 3,           //12



                         2               //13



                         };







        int proPosY[] = {0,



                         1, 1, 1, 1,



                         2, 2, 2, 2,



                         3, 3, 



                         4, 4,



                         5, 5, 5,5,



                         6,



                         7, 



                         8, 8, 8,



	                 9, 9, 9, 



	                 10,10,



	                 11, 11, 11, 11,



                         12, 12,



                         13



                         };







        ProcessItem proi[] = makeProcess();



        gbc.insets = new Insets(1, 1, 1, 1);



        gbc.fill = GridBagConstraints.BOTH;



        gbc.weightx = 1.0; gbc.weighty = 1.0;



        procel = new ProcessCell[proi.length];











	//Color buttonColor = new Color(255, 140, 140);



       changeProcessButton = new JButton("Change the process");



         changeProcessButton.setBackground(Color.green);



       closeTableButton = new JButton("CloseTable");



         closeTableButton.setBackground(Color.yellow); 







       JPanel buttonPanel = new JPanel();



         buttonPanel.setLayout(new GridLayout(1, 2));



         buttonPanel.setBackground(new Color(230, 250, 230));



         buttonPanel.add(changeProcessButton);



         //MOMO buttonPanel.add(closeTableButton);



       JPanel tablePanel = new JPanel();



       JPanel mainPanel = new JPanel();



         mainPanel.setLayout(new BorderLayout(1, 1));



         mainPanel.add(buttonPanel, "North");



         mainPanel.add(tablePanel, "Center");



         tablePanel.setLayout(gbl);



	 //         tablePanel.setBackground(new Color(230, 250, 230));



         tablePanel.setBackground(new Color(230, 230, 100));







       changeProcessButton.addActionListener(this);



       closeTableButton.addActionListener(this);











        for(int i = 0; i<proi.length; i++){



            gbc.gridx = proPosX[i]; gbc.gridy = proPosY[i];



            procel[i] = new ProcessCell(proi[i]);



            //gbl.setConstraints(procel[i], gbc); getContentPane().add(procel[i]);



            gbl.setConstraints(procel[i], gbc); tablePanel.add(procel[i]);



	}







          Color lightred = new Color(255, 200, 200);



          Color brightred = new Color(255, 190, 190);











        JLabel l00 = new JLabel("Default", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 0;



          gbl.setConstraints(l00, gbc); tablePanel.add(l00);



          l00.setOpaque(true); 



          l00.setBackground(brightred);



          l00.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l01 = new JLabel("Standard EM", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 1;



          gbl.setConstraints(l01, gbc); tablePanel.add(l01);



          l01.setOpaque(true); 



          l01.setBackground(brightred);



          l01.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l11 = new JLabel("photon", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 1;



          gbl.setConstraints(l11, gbc); tablePanel.add(l11);



          l11.setOpaque(true); 



          l11.setBackground(lightred);



          l11.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l12 = new JLabel("e-/e+", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 2;



          gbl.setConstraints(l12, gbc); tablePanel.add(l12);



          l12.setOpaque(true); 



          l12.setBackground(lightred);



          l12.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l14 = new JLabel("hadron/ions", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 4;



          gbl.setConstraints(l14, gbc); tablePanel.add(l14);



          l14.setOpaque(true); 



          l14.setBackground(lightred);



          l14.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l15 = new JLabel("integral", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 5;



          gbl.setConstraints(l15, gbc); tablePanel.add(l15);



          l15.setOpaque(true); 



          l15.setBackground(lightred);



          l15.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l17 = new JLabel("all charged", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 7;



          gbl.setConstraints(l17, gbc); tablePanel.add(l17);



          l17.setOpaque(true); 



          l17.setBackground(lightred);



          l17.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l08 = new JLabel("Muon EM", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 8;



          gbl.setConstraints(l08, gbc); tablePanel.add(l08);



          l08.setOpaque(true); 



          l08.setBackground(brightred);



          l08.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l18 = new JLabel("mu-/mu+", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 8;



          gbl.setConstraints(l18, gbc); tablePanel.add(l18);



          l18.setOpaque(true); 



          l18.setBackground(lightred);



          l18.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l19 = new JLabel("integral", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 9;



          gbl.setConstraints(l19, gbc); tablePanel.add(l19);



          l19.setOpaque(true); 



          l19.setBackground(lightred);



          l19.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l010 = new JLabel("X Rays", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 10;



          gbl.setConstraints(l010, gbc); tablePanel.add(l010);



          l010.setOpaque(true); 



          l010.setBackground(brightred);



          l010.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l110 = new JLabel("all charged", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 10;



          gbl.setConstraints(l110, gbc); tablePanel.add(l110);



          l110.setOpaque(true); 



          l110.setBackground(lightred);



          l110.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l011 = new JLabel("Low energy EM", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 11;



          gbl.setConstraints(l011, gbc); tablePanel.add(l011);



          l011.setOpaque(true); 



          l011.setBackground(brightred);



          l011.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l111 = new JLabel("photon", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 11;



          gbl.setConstraints(l111, gbc); tablePanel.add(l111);



          l111.setOpaque(true); 



          l111.setBackground(lightred);



          l111.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l112 = new JLabel("e-/e+", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 12;



          gbl.setConstraints(l112, gbc); tablePanel.add(l112);



          l112.setOpaque(true); 



          l112.setBackground(lightred);



          l112.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l113 = new JLabel("hadron/ions", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 13;



          gbl.setConstraints(l113, gbc); tablePanel.add(l113);



          l113.setOpaque(true); 



          l113.setBackground(lightred);



          l113.setFont(new Font("Serif", Font.BOLD, 12)); 







        setSize(820, 360);



       // setResizable(false);







        add(mainPanel);



    }







    public void actionPerformed(ActionEvent e) {







        if (e.getSource() == changeProcessButton) {



            phyFrame.changeProcess();







	}else if (e.getSource() == closeTableButton) {



	    this.setVisible(false);



            phyFrame.phyEMTable.openProcButtonCloseAct();







            getSelectedProcess();



	}



    }  







    ProcessItem[] getSelectedProcess(){



        int k = 0;



        if(ProcessCell.selectedProc == 0) return null;



            ProcessItem pi[] = new ProcessItem[ProcessCell.selectedProc];



            for(int i=0; i<procel.length; i++){



                if(procel[i].isSelected()){



                     pi[k] = procel[i].pi;



                     procel[i].clear();



                     k++;



		}



	    }



            return pi;



    }







    ProcessItem[] makeProcess(){



      //        ProcessItem proi[] = new ProcessItem[42];



      //  ProcessItem proi[] = new ProcessItem[27];



      ProcessItem proi[] = new ProcessItem[34];







        proi[0] = new ProcessItem("", "Null", "Null", "", "", "", "");







	//



        proi[1] = new ProcessItem("G4ComptonScattering", "ComptonScattering",



                  "Compton", "", "ordInActive", "ordInActive", "ordDefault");







        proi[2] = new ProcessItem("G4PolarizedComptonScattering",



                   "PolarizedComptonScattering", "PolarizedCompton", "",



                   "ordInActive", "ordInActive", "ordDefault");    







        proi[3] = new ProcessItem("G4GammaConversion", "GammaConversion",



                  "GammaConv", "", "ordInActive", "ordInActive", "ordDefault");







        proi[4] = new ProcessItem("G4PhotoElectricEffect",



                   "PhotoElectricEffect", "PhotoElectric", "", "ordInActive",



                   "ordInActive", "ordDefault");    



	//



        proi[5] = new ProcessItem("G4eIonisation", 



		      "eIonisation", "eIonisation",



                      "", "ordInActive", "2", "2");    







        proi[6] = new ProcessItem("G4eBremsstrahlung", "eBremsstrahlung",



                  "eBrems", "", "ordInActive", "ordInActive", "3");







        proi[7] = new ProcessItem("G4eplusAnnihilation", "eplusAnnihilation",



                  "e+Annihilation", "", "ordDefault", "ordInActive", "4");    







        proi[8] = new ProcessItem("G4SynchrotronRadiation",



                   "SynchrotronRadition", "SynchrotronRad", "",



                   "ordInActive", "ordInActive", "ordDefault");    



	//



        proi[9] = new ProcessItem("G4eIonisationPlus", "eIonisationPlus",



                  "eIonisationPlus", "", "ordInActive", "2", "2");    







        proi[10] = new ProcessItem("G4eBremsstrahlungPlus", 



                  "eBremsstrahlungPlus", "eBremsPlus", "", "ordInActive", 



                  "ordInActive", "3");    



	//



        proi[11] = new ProcessItem("G4hIonisation", 



		    "hIonisation", "hIonisation",



                    "", "ordInActive", "2", "2");    







        proi[12] = new ProcessItem("G4ionIonisation", "ionIonisation",



                   "ionIonisation", "", "ordInActive", "2", "2");    







	//







        proi[13] = new ProcessItem("G4IeIonisation", "IeIonisation",



                   "IeIonisation", "", "ordInActive", "2", "2");    











        proi[14] = new ProcessItem("G4IeBremsstrahlung", "IeBremsstrahlung",



                  "IeBrems", "", "ordInActive", "ordInActive", "3");    











        proi[15] = new ProcessItem("G4IeplusAnnihilation",



                   "IeplusAnnihilation", "Ie+Annihilation", "", "ordDefault",



                   "ordInActive" ,"4");    







        proi[16] = new ProcessItem("G4IMultipleScattering",



                   "IMultipleScattering", "IMultipleScatt", "", "ordInActive",



                   "1", "1");    



	//



        proi[17] = new ProcessItem("G4IhIonisation", "IhIonisation",



                   "IhIonisation", "", "ordInActive", "2", "2");    







	//



        proi[18] = new ProcessItem("G4MultipleScattering",



                   "MultipleScattering", "MultipleScatt", "", "ordInActive",



                   "1", "1");



	//



        proi[19] = new ProcessItem("G4MuIonisation", "MuIonisation",



                   "MuIonisation", "", "ordInActive", "2", "2"); 







        proi[20] = new ProcessItem("G4MuBremsstrahlung", "MuBremsstrahlung",



                   "MuBrems", "", "ordInActive", "ordInActive", "3");    







        proi[21] = new ProcessItem("G4MuPairProduction", "MuPairProduction",



                   "MuPairProd", "", "ordInActive", "ordInActive", "4");    



	//



        proi[22] = new ProcessItem("G4IMuIonisation", "IMuIonisation",



                   "IMuIonisation", "", "ordInActive", "2", "2");    







        proi[23] = new ProcessItem("G4IMuBremsstrahlung", "IMuBremsstrahlung", 



                   "IMuBrems", "", "ordInActive", "ordInActive", "3");    



        proi[24] = new ProcessItem("G4IMuPairProduction", "IMuPairProduction",



                   "IMuPairProd", "", "ordInActive", "ordInActive", "4");    







	//







        proi[25] = new ProcessItem("G4Cerenkov", "Cerenkov", "Cerenkov", "",



                   "ordInActive", "ordDefault", "ordInActive");    







        proi[26] = new ProcessItem("G4Scintillation", "Scintillation", 



                   "Scintillation", "", "ordInActive", "ordInActive",



                   "ordDefault");    



	//



        proi[27] = new ProcessItem("G4LowEnergyCompton", "LECompton",



                   "LECompton", "", "ordInActive", "ordInActive",



                   "ordDefault");    



        proi[28] = new ProcessItem("G4LowEnergyGammaConversion", "LEGammaConv",



                   "LEGammaConv", "", "ordInActive", "ordInActive",



                   "ordDefault");    



        proi[29] = new ProcessItem("G4LowEnergyPhotoElectric", "LEPhotoElec",



                   "LEPhotoElec", "", "ordInActive", "ordInActive",



                   "ordDefault");    



        proi[30] = new ProcessItem("G4LowEnergyRayleigh", "LERayleigh",



                   "LERayleigh", "", "ordInActive", "ordInActive",



                   "ordDefault");    



	//



        proi[31] = new ProcessItem("G4LowEnergyIonisation", "LEIonisation",



                   "LEIonisation", "", "ordInActive", "2",



                   "2");    



        proi[32] = new ProcessItem("G4LowEnergyBremsstrahlung", "LEBrems",



                   "LEBrems", "", "ordInActive", "ordInActive",



                   "3"); 



	//



        proi[33] = new ProcessItem("G4hLowEnergyIonisation", "hLEIonisation",



                   "hLEIonisation", "", "ordInActive", "2",



                   "2");    







/*



        proi[36] = new ProcessItem("G4TransitionRadiation",



                   "TransitionRadiation", "TransitionRad", "", "ordInActive",



                   "ordInActive", "ordInActive");    



        proi[30] = new ProcessItem("G4OpAbsorption", "OpAbsorption", 



                   "OpAbsorption", "", "ordInActive", "ordInActive",



                   "ordDefault");    



        proi[31] = new ProcessItem("G4OpBoundaryProcess", "OpBoundaryProcess",



                   "OpBoundaryProc", "", "ordInActive", "ordInActive", 



                   "ordDefault");    



        proi[32] = new ProcessItem("G4OpRayleigh", "OpRayleigh", "OpRayleigh",



                   "", "ordInActive", "ordInActive", "ordDefault");    



*/



	//        proi[40] = new ProcessItem("on", "on", "on", "", "", "", "");    



        //proi[41] = new ProcessItem("off", "off", "off", "", "", "", "");     



                          



        return proi;



    }



} 



