//$Id: EMParticlesTable.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// Particle table
// 1999 June 23
// 2001 Dec 13 PANElise
// 2002 May Momo Web Start version
//       delete rho0 from the table

package GPE;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.util.*;

class EMParticlesTable extends AbstractGPEFrame implements ActionListener {
    private ParticleCell parcel[];
    PhysicsFrame phyFrame;
    JButton appendButton;
    JButton insertButton;
    JButton closeTableButton;
    private Color buttonColor;

  EMParticlesTable(PhysicsFrame phyFrame){
        super("Particles Table");
        this.phyFrame = phyFrame;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        buttonColor = new Color(230, 200, 140);

        int elemPosX[] = {0, 1, 2, 3, 
       		          0, 1, 2, 3, 4, 5, 6,
		             1, 2, 3, 4, 5, 6,
		          0, 1, 2, 3, 4, 5, 6,
		             1, 2, 3, 4, 5, 6,
		             1, 2, 3, 4, 5, 6,
                             1, 2, 3, 4, 5, 6, 7,
                          0, 1, 2, 3, 4,
                             1, 2, 3, 4, 5, 6, 7,
                             1, 2, 3, 4, 5, 6, 7,
                             1, 2, 3, 4, 5, 6, 7,
                             1, 2, 3, 4, 5, 6, 7,
                          0, 1, 2, 3, 4, 5,
                          0 };

        int elemPosY[] = {0, 0, 0, 0,
	    	          1, 1, 1, 1, 1, 1, 1,
		             2, 2, 2, 2, 2, 2,
		          3, 3, 3, 3, 3, 3, 3,
		             4, 4, 4, 4, 4, 4,
		             5, 5, 5, 5, 5, 5,
                             6, 6, 6, 6, 6, 6, 6,
		          7, 7, 7, 7, 7,
		             8, 8, 8, 8, 8, 8, 8,
                             9, 9, 9, 9, 9, 9, 9,
                             10, 10, 10, 10, 10, 10, 10,
                             11, 11, 11, 11, 11, 11, 11,
                          12, 12, 12, 12, 12, 12,
                          13 };

        ParticleItem pari[] = makeParticle();
        gbc.insets = new Insets(1,1,1,1);
        gbc.fill = GridBagConstraints.BOTH;
        gbc.weightx = 1.0; gbc.weighty = 1.0;

        parcel = new ParticleCell[pari.length];
        JLabel columnLabel = new JLabel("Particle(s) ==>", JLabel.CENTER);
          columnLabel.setFont(new Font("Serif", Font.BOLD, 12));

        //MOMO JLabel tableLabel = new JLabel("ThisTable ==>", JLabel.CENTER);
        //MOMO  tableLabel.setFont(new Font("Serif", Font.BOLD, 12)); 

        appendButton = new JButton("Append a particle or particles group");
          appendButton.setBackground(Color.green);
        insertButton = new JButton("Insert a particle or particles group");
          insertButton.setBackground(Color.green);

	  // MOMO this button must be instantiated
	closeTableButton = new JButton("CloseTable");
          closeTableButton.setBackground(Color.yellow);    

        JPanel buttonPanel = new JPanel();
          //buttonPanel.setLayout(new GridLayout(1, 5));
          buttonPanel.setLayout(new GridLayout(1, 2));
          buttonPanel.setBackground(new Color(230, 250, 230));

          // buttonPanel.add(columnLabel);
          buttonPanel.add(appendButton);
          buttonPanel.add(insertButton);

          // buttonPanel.add(tableLabel);
	  //          buttonPanel.add(closeTableButton);

        JPanel tablePanel = new JPanel();
        JPanel mainPanel = new JPanel();
          mainPanel.setLayout(new BorderLayout(1, 1));
          mainPanel.add(buttonPanel, "North");
          mainPanel.add(tablePanel, "Center");
          tablePanel.setLayout(gbl);
          tablePanel.setBackground(new Color(100, 250, 230));

          ///////   R= 230 -> 100 (lightblue)

        appendButton.addActionListener(this);
        insertButton.addActionListener(this);
        closeTableButton.addActionListener(this);

        for (int i = 0; i<pari.length; i++){
	    // skip 23-th entry, i.e., rho0
	    if(i == 23) continue;
            gbc.gridx = elemPosX[i]; gbc.gridy = elemPosY[i];
            parcel[i] = new ParticleCell(pari[i]);
            gbl.setConstraints(parcel[i], gbc); tablePanel.add(parcel[i]);
            add(mainPanel);
	}

        setSize(830, 360);
        //setResizable(false);
    }

  public void actionPerformed(ActionEvent e){

        if (e.getSource() == appendButton) {
	    phyFrame.appendEMParticle();
        }else if (e.getSource() == insertButton) {
            phyFrame.insertEMParticle();

	    // 2001 PANEL how to do these actions associated with the close button?
        }else if (e.getSource() == closeTableButton) {
	      this.setVisible(false);
	      phyFrame.phyEMTable.createMatCloseAct();
            getSelectedElements();
	}
    }

  ParticleItem[] getSelectedElements(){

      int k = 0;
      if (ParticleCell.selectedElems == 0) return null;
         ParticleItem parItem[] = new ParticleItem[ParticleCell.selectedElems];
         for (int i=0; i<parcel.length; i++){
	     // skip 23-th rho0
	     if(i == 23) continue;
                if(parcel[i].isSelected()){
	            parItem[k] = parcel[i].parItem;
	            parcel[i].clear();
	            k++;
		}
        }
         return parItem;
    }

  ParticleItem[] makeParticle(){
        ParticleItem pari[] = new ParticleItem[83];
        pari[0] = new ParticleItem("all_bosons","all bosons");
        pari[1] = new ParticleItem("gamma","\u03B3");
        pari[2] = new ParticleItem("geantino","geantino");
        pari[3] = new ParticleItem("chargedgeantino","chargedgeantino");

        //pari[4] = new ParticleItem("opticalphoton","optical \u03B3");

        pari[4] = new ParticleItem("all_leptons","all leptons");
        pari[5] = new ParticleItem("e-","e-");
        pari[6] = new ParticleItem("mu-","\u03BC-");
        pari[7] = new ParticleItem("tau-","\u03C4-");
        pari[8] = new ParticleItem("anti_nu_e","anti-\u03BDe");
        pari[9] = new ParticleItem("anti_nu_mu","anti-\u03BD\u03BC");
        pari[10] = new ParticleItem("anti_nu_tau","anti-\u03BD\u03C4");
        pari[11] = new ParticleItem("e+","e+");
        pari[12] = new ParticleItem("mu+","\u03BC+");
        pari[13] = new ParticleItem("tau+","\u03C4+");
        pari[14] = new ParticleItem("nu_e","\u03BDe");
        pari[15] = new ParticleItem("nu_mu","\u03BD\u03BC");
        pari[16] = new ParticleItem("nu_tau","\u03BD\u03C4");
        pari[17] = new ParticleItem("all_mesons","all mesons");
        pari[18] = new ParticleItem("pi+","\u03C0+");
        pari[19] = new ParticleItem("pi-","\u03C0-");
        pari[20] = new ParticleItem("pi0","\u03C00");
        pari[21] = new ParticleItem("eta","\u03B7");
        pari[22] = new ParticleItem("eta_prime","\u03B7\u0374");
        pari[23] = new ParticleItem("rho0","\u03C10");
        pari[24] = new ParticleItem("kaon+","K+");
        pari[25] = new ParticleItem("kaon-","K-");
        pari[26] = new ParticleItem("kaon0","K0");
        pari[27] = new ParticleItem("kaon0S","K0S");
        pari[28] = new ParticleItem("kaon0L","K0L");
        pari[29] = new ParticleItem("anti_kaon0","anti-K0");
        pari[30] = new ParticleItem("D+","D+");
        pari[31] = new ParticleItem("D-","D-");
        pari[32] = new ParticleItem("D0","D0");
        pari[33] = new ParticleItem("anti_D0","anti-D0");
        pari[34] = new ParticleItem("Ds+","Ds+");
        pari[35] = new ParticleItem("Ds-","Ds-");
        pari[36] = new ParticleItem("B+","B+");
        pari[37] = new ParticleItem("B-","B-");
        pari[38] = new ParticleItem("B0","B0");
        pari[39] = new ParticleItem("Bs0","Bs0");
        pari[40] = new ParticleItem("anti_B0","anti-B0");
        pari[41] = new ParticleItem("anti_Bs0","anti-Bs0");
        pari[42] = new ParticleItem("J/psi","\u03A8");
        pari[43] = new ParticleItem("all_baryons","all baryons");
        pari[44] = new ParticleItem("proton","p");
        pari[45] = new ParticleItem("neutron","n");
        pari[46] = new ParticleItem("anti_proton","anti-p");
        pari[47] = new ParticleItem("anti_neutron","anti-n");
        pari[48] = new ParticleItem("lambda","\u039B");
        pari[49] = new ParticleItem("sigma+","\u03A3+");
        pari[50] = new ParticleItem("sigma0","\u03A30");
        pari[51] = new ParticleItem("sigma-","\u03A3-");
        pari[52] = new ParticleItem("xi0","\u039E0");
        pari[53] = new ParticleItem("xi-","\u039E-");
        pari[54] = new ParticleItem("omega-","\u03A9-");
        pari[55] = new ParticleItem("anti_lambda","anti-\u039B");
        pari[56] = new ParticleItem("anti_sigma+","anti-\u03A3+");
        pari[57] = new ParticleItem("anti_sigma0","anti-\u03A30");
        pari[58] = new ParticleItem("anti_sigma-","anti-\u03A3-");
        pari[59] = new ParticleItem("anti_xi0","anti-\u039E0");
        pari[60] = new ParticleItem("anti_xi-","anti-\u039E-");
        pari[61] = new ParticleItem("anti_omega-","anti-\u03A9-");
        pari[62] = new ParticleItem("lambda_c+","\u039Bc+");
        pari[63] = new ParticleItem("sigma_c++","\u03A3c++");
        pari[64] = new ParticleItem("sigma_c+","\u03A3c+");
        pari[65] = new ParticleItem("sigma_c0","\u03A3c0");
        pari[66] = new ParticleItem("xi_c+","\u039Ec+");
        pari[67] = new ParticleItem("xi_c0","\u039Ec0");
        pari[68] = new ParticleItem("omega_c0","\u03A9c0");
        pari[69] = new ParticleItem("anti_lambda_c+","anti-\u039Bc+");
        pari[70] = new ParticleItem("anti_sigma_c++","anti-\u03A3c++");
        pari[71] = new ParticleItem("anti_sigma_c+","anti-\u03A3c+");
        pari[72] = new ParticleItem("anti_sigma_c0","anti-\u03A3c0");
        pari[73] = new ParticleItem("anti_xi_c+","anti-\u039Ec+");
        pari[74] = new ParticleItem("anti_xi_c0","anti-\u039Ec0");
        pari[75] = new ParticleItem("anti_omega_c0","anti-\u03A9c0");
        pari[76] = new ParticleItem("all_ions","all ions");
        pari[77] = new ParticleItem("alpha","\u03B1");
        pari[78] = new ParticleItem("deuteron","d");
        pari[79] = new ParticleItem("He3","He3");
        pari[80] = new ParticleItem("triton","triton");
        pari[81] = new ParticleItem("GenericIon","GenericIon");
        pari[82] = new ParticleItem("all_shortlived","all shortlived");

       return pari;
    }
}













