//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
class RatioDialog extends JDialog {
  private JTextField paramField[];
  private JComboBox ratioType;
  private CSGItem solid;
  private RatioItem ratioItem;
//MOMO

public  RatioDialog(RatioCellEditor parent, RatioItem ratioItem){
    //    super(parent.parent, "Mix Ratio");  // Frame owner , string
    super();  // not Frame 
    this.ratioItem = ratioItem;
    JLabel lbl;
    GridBagConstraints gbc = new GridBagConstraints();
    GridBagLayout gbl = new GridBagLayout();
    getContentPane().setLayout(gbl);
    gbc.gridx = 0; gbc.gridy = 0;
    gbc.gridwidth = 1; gbc.gridheight = 1;
    gbc.weightx = 0.0; gbc.weighty = 0.0;
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.EAST;
    lbl = new JLabel("Ratio");
    gbl.setConstraints(lbl, gbc);
    getContentPane().add(lbl);
    gbc.gridx = 1;
    gbc.weightx = 1.0; gbc.weighty = 0.0;
    gbc.fill = GridBagConstraints.HORIZONTAL;
    ratioType = new JComboBox();
    ratioType.addItem("Number");
    ratioType.addItem("Fraction"); 

   gbl.setConstraints(ratioType, gbc);
    getContentPane().add(ratioType);
    int paraCount = ratioItem.getLength();
    paramField = new JTextField[paraCount];
    for (int i=0; i<paraCount; i++){
      gbc.gridx = 0; gbc.gridy = i+1;
      gbc.gridwidth = 1; gbc.gridheight = 1;
      gbc.weightx = 0.0; gbc.weighty = 0.0;
      gbc.fill = GridBagConstraints.NONE;
      gbc.anchor = GridBagConstraints.EAST;
      lbl = new JLabel(ratioItem.getEleName(i));
      gbl.setConstraints(lbl, gbc);
      getContentPane().add(lbl);
      gbc.gridx = 1; 
     gbc.weightx = 1.0; gbc.weighty = 0.0;
      gbc.fill = GridBagConstraints.HORIZONTAL;
      paramField[i] = new JTextField(8);
      gbl.setConstraints(paramField[i], gbc);
      getContentPane().add(paramField[i]);
    } 
   gbc.gridx = 0; gbc.gridy = paraCount+1;
    gbc.gridwidth = 2; gbc.gridheight = 1;
    gbc.weightx = 1.0; gbc.weighty = 0.0;
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.CENTER; 
   JButton okButton = new JButton(" OK ");
    gbl.setConstraints(okButton, gbc);
    getContentPane().add(okButton);
    okButton.addActionListener(parent);
    setValues();
    pack();
    setVisible(true);
  }
  void editStop(){
    setVisible(false);
  }
  private void setValues(){
    if (ratioItem.isEmpty) return;
    ratioType.setSelectedIndex(ratioItem.isFraction);
    for (int i=0; i<ratioItem.getLength(); i++){
      paramField[i].setText( ratioItem.getRatioStr(i) );
    }
  }
  RatioItem getValues(){
    ratioItem.isFraction = ratioType.getSelectedIndex();
    for (int i=0; i<ratioItem.getLength(); i++){
      try{
	ratioItem.ratio[i] = new Float(paramField[i].getText()).floatValue();
      }catch(NumberFormatException e){
	ratioItem.ratio[i] = 0f;
      }
    }
    ratioItem.isEmpty = false;
    dispose();
    return ratioItem;
  }
}
