//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// neutron_hp -- source file
// J.P. Wellisch, Nov-1996
// A prototype of the low energy neutron transport model.
#include "G4NeutronHPFastLegendre.hh"

const G4double
  G4NeutronHPFastLegendre::l26[5401] = {1, 0.874153, 0.756377,
  0.646326, 0.543667, 0.448076, 0.35924, 0.276858, 0.200635, 0.130289,
  0.0655456, 0.00614123, -0.0481802, -0.0976654, -0.142553, -0.183073,
  -0.219448, -0.251892, -0.280612, -0.305806, -0.327669, -0.346383,
  -0.362129, -0.375077, -0.385394, -0.393237, -0.39876, -0.402111,
  -0.40343, -0.402853, -0.400512, -0.396529, -0.391027, -0.38412,
  -0.375918, -0.366526, -0.356047, -0.344576, -0.332206, -0.319025,
  -0.305118, -0.290565, -0.275443, -0.259825, -0.24378, -0.227374,
  -0.210671, -0.19373, -0.176607, -0.159357, -0.14203, -0.124673,
  -0.107332, -0.0900505, -0.0728673, -0.0558205, -0.0389456,
  -0.0222756, -0.00584152, 0.0103279, 0.0262058, 0.0417674, 0.0569896,
  0.0718512, 0.0863327, 0.100416, 0.114086, 0.127327, 0.140126,
  0.152471, 0.164352, 0.175759, 0.186686, 0.197124, 0.207069,
  0.216517, 0.225462, 0.233904, 0.241841, 0.249271, 0.256196,
  0.262616, 0.268533, 0.27395, 0.27887, 0.283297, 0.287236, 0.290691,
  0.293668, 0.296173, 0.298214, 0.299797, 0.300929, 0.30162, 0.301876,
  0.301707, 0.301122, 0.300129, 0.298739, 0.296962, 0.294807,
  0.292284, 0.289404, 0.286178, 0.282615, 0.278728, 0.274526,
  0.270022, 0.265225, 0.260147, 0.2548, 0.249193, 0.24334, 0.23725,
  0.230935, 0.224406, 0.217675, 0.210752, 0.203648, 0.196374,
  0.188941, 0.18136, 0.173642, 0.165796, 0.157834, 0.149766, 0.141601,
  0.133351, 0.125025, 0.116632, 0.108182, 0.0996857, 0.0911509,
  0.0825873, 0.0740037, 0.065409, 0.0568117, 0.0482202, 0.0396428,
  0.0310876, 0.0225623, 0.0140746, 0.00563203, -0.00275818,
  -0.0110889, -0.0193534, -0.0275448, -0.0356568, -0.043683,
  -0.0516174, -0.059454, -0.0671872, -0.0748116, -0.0823218,
  -0.0897127, -0.0969795, -0.104117, -0.111122, -0.117989, -0.124714,
  -0.131294, -0.137725, -0.144002, -0.150123, -0.156085, -0.161885,
  -0.167519, -0.172986, -0.178283, -0.183407, -0.188357, -0.19313,
  -0.197726, -0.202141, -0.206376, -0.210428, -0.214297, -0.217981,
  -0.221481, -0.224794, -0.227922, -0.230862, -0.233617, -0.236184,
  -0.238564, -0.240759, -0.242767, -0.244589, -0.246226, -0.247679,
  -0.248949, -0.250036, -0.250941, -0.251667, -0.252213, -0.252582,
  -0.252774, -0.252793, -0.252638, -0.252313, -0.251818, -0.251156,
  -0.250329, -0.249339, -0.248188, -0.246878, -0.245413, -0.243793,
  -0.242022, -0.240103, -0.238037, -0.235827, -0.233477, -0.230989,
  -0.228365, -0.225609, -0.222724, -0.219712, -0.216576, -0.21332,
  -0.209947, -0.206459, -0.202859, -0.199152, -0.19534, -0.191426,
  -0.187413, -0.183305, -0.179105, -0.174816, -0.170442, -0.165985,
  -0.161449, -0.156838, -0.152154, -0.147401, -0.142582, -0.137701,
  -0.132761, -0.127764, -0.122715, -0.117617, -0.112472, -0.107284,
  -0.102057, -0.0967935, -0.0914966, -0.0861695, -0.0808155,
  -0.0754377, -0.0700392, -0.0646231, -0.0591924, -0.0537503,
  -0.0482996, -0.0428434, -0.0373846, -0.0319261, -0.0264709,
  -0.0210217, -0.0155814, -0.0101527, -0.00473847, 0.00065867,
  0.00603603, 0.011391, 0.016721, 0.0220234, 0.0272957, 0.0325356,
  0.0377405, 0.0429081, 0.048036, 0.053122, 0.0581638, 0.0631591,
  0.0681059, 0.073002, 0.0778454, 0.0826341, 0.087366, 0.0920392,
  0.0966519, 0.101202, 0.105688, 0.110109, 0.114462, 0.118745,
  0.122958, 0.127099, 0.131165, 0.135157, 0.139072, 0.142908,
  0.146666, 0.150343, 0.153939, 0.157451, 0.16088, 0.164224, 0.167481,
  0.170652, 0.173735, 0.176729, 0.179634, 0.182449, 0.185172,
  0.187804, 0.190344, 0.192791, 0.195145, 0.197405, 0.19957, 0.201641,
  0.203617, 0.205498, 0.207283, 0.208973, 0.210566, 0.212064,
  0.213465, 0.214771, 0.21598, 0.217093, 0.21811, 0.219031, 0.219857,
  0.220587, 0.221221, 0.221761, 0.222206, 0.222556, 0.222813,
  0.222976, 0.223046, 0.223023, 0.222908, 0.222702, 0.222405,
  0.222017, 0.22154, 0.220974, 0.22032, 0.219578, 0.218749, 0.217835,
  0.216835, 0.215751, 0.214584, 0.213334, 0.212003, 0.210591, 0.2091,
  0.20753, 0.205883, 0.204159, 0.20236, 0.200486, 0.198539, 0.19652,
  0.194431, 0.192271, 0.190043, 0.187748, 0.185386, 0.18296, 0.18047,
  0.177917, 0.175304, 0.17263, 0.169898, 0.167109, 0.164264, 0.161365,
  0.158413, 0.155408, 0.152354, 0.14925, 0.146098, 0.142901, 0.139658,
  0.136372, 0.133044, 0.129676, 0.126268, 0.122822, 0.11934, 0.115823,
  0.112273, 0.108691, 0.105078, 0.101435, 0.0977654, 0.0940691,
  0.090348, 0.0866035, 0.082837, 0.0790499, 0.0752436, 0.0714197,
  0.0675795, 0.0637244, 0.0598558, 0.0559752, 0.052084, 0.0481835,
  0.0442751, 0.0403603, 0.0364403, 0.0325167, 0.0285906, 0.0246635,
  0.0207368, 0.0168117, 0.0128896, 0.00897179, 0.00505959, 0.00115428,
  -0.00274284, -0.00663051, -0.0105075, -0.0143724, -0.0182242,
  -0.0220616, -0.0258833, -0.0296882, -0.033475, -0.0372427, -0.04099,
  -0.0447158, -0.048419, -0.0520984, -0.055753, -0.0593816,
  -0.0629833, -0.0665569, -0.0701013, -0.0736157, -0.0770989,
  -0.0805501, -0.0839681, -0.0873521, -0.0907011, -0.0940141,
  -0.0972904, -0.100529, -0.103729, -0.106889, -0.11001, -0.113089,
  -0.116126, -0.11912, -0.122071, -0.124978, -0.12784, -0.130656,
  -0.133426, -0.136149, -0.138825, -0.141451, -0.14403, -0.146558,
  -0.149036, -0.151464, -0.153841, -0.156165, -0.158438, -0.160658,
  -0.162824, -0.164937, -0.166996, -0.169, -0.17095, -0.172844,
  -0.174682, -0.176465, -0.178191, -0.179861, -0.181474, -0.183029,
  -0.184528, -0.185968, -0.187351, -0.188676, -0.189942, -0.191151,
  -0.192301, -0.193392, -0.194424, -0.195398, -0.196313, -0.197169,
  -0.197966, -0.198704, -0.199383, -0.200003, -0.200564, -0.201067,
  -0.20151, -0.201895, -0.202222, -0.20249, -0.202699, -0.20285,
  -0.202944, -0.202979, -0.202957, -0.202877, -0.202741, -0.202547,
  -0.202296, -0.201989, -0.201626, -0.201207, -0.200732, -0.200203,
  -0.199618, -0.198979, -0.198285, -0.197538, -0.196737, -0.195884,
  -0.194977, -0.194019, -0.193009, -0.191948, -0.190835, -0.189673,
  -0.18846, -0.187199, -0.185888, -0.184529, -0.183123, -0.181669,
  -0.180168, -0.178622, -0.17703, -0.175392, -0.173711, -0.171985,
  -0.170217, -0.168405, -0.166552, -0.164658, -0.162723, -0.160747,
  -0.158733, -0.156679, -0.154588, -0.152459, -0.150293, -0.148092,
  -0.145855, -0.143583, -0.141278, -0.138939, -0.136568, -0.134165,
  -0.131731, -0.129266, -0.126772, -0.124249, -0.121698, -0.119119,
  -0.116514, -0.113883, -0.111227, -0.108547, -0.105843, -0.103116,
  -0.100367, -0.0975962, -0.0948052, -0.0919945, -0.0891648,
  -0.0863168, -0.0834514, -0.0805692, -0.0776712, -0.074758,
  -0.0718305, -0.0688894, -0.0659354, -0.0629695, -0.0599922,
  -0.0570045, -0.0540071, -0.0510007, -0.0479862, -0.0449642,
  -0.0419356, -0.0389012, -0.0358617, -0.0328178, -0.0297703,
  -0.02672, -0.0236677, -0.020614, -0.0175598, -0.0145058, -0.0114526,
  -0.00840114, -0.00535207, -0.00230611, 0.000735983, 0.0037735,
  0.00680573, 0.00983194, 0.0128514, 0.0158635, 0.0188674, 0.0218625,
  0.0248481, 0.0278235, 0.0307881, 0.033741, 0.0366818, 0.0396096,
  0.0425239, 0.045424, 0.0483093, 0.0511791, 0.0540327, 0.0568697,
  0.0596892, 0.0624908, 0.0652738, 0.0680377, 0.0707817, 0.0735054,
  0.0762082, 0.0788894, 0.0815486, 0.0841851, 0.0867985, 0.0893881,
  0.0919535, 0.0944941, 0.0970093, 0.0994988, 0.101962, 0.104398,
  0.106807, 0.109189, 0.111542, 0.113866, 0.116161, 0.118427,
  0.120662, 0.122868, 0.125042, 0.127185, 0.129296, 0.131375,
  0.133422, 0.135435, 0.137416, 0.139363, 0.141276, 0.143155,
  0.144999, 0.146808, 0.148582, 0.150321, 0.152023, 0.15369, 0.15532,
  0.156914, 0.15847, 0.15999, 0.161472, 0.162916, 0.164323, 0.165691,
  0.167021, 0.168313, 0.169566, 0.17078, 0.171955, 0.173091, 0.174188,
  0.175245, 0.176263, 0.177241, 0.178179, 0.179077, 0.179935,
  0.180753, 0.181531, 0.182269, 0.182966, 0.183623, 0.18424, 0.184816,
  0.185351, 0.185847, 0.186301, 0.186716, 0.187089, 0.187423,
  0.187716, 0.187968, 0.18818, 0.188352, 0.188484, 0.188576, 0.188627,
  0.188638, 0.18861, 0.188542, 0.188434, 0.188286, 0.188099, 0.187873,
  0.187608, 0.187303, 0.18696, 0.186578, 0.186157, 0.185698, 0.185201,
  0.184666, 0.184093, 0.183483, 0.182835, 0.18215, 0.181428, 0.18067,
  0.179875, 0.179044, 0.178177, 0.177274, 0.176336, 0.175363,
  0.174355, 0.173312, 0.172235, 0.171124, 0.16998, 0.168802, 0.167591,
  0.166348, 0.165071, 0.163763, 0.162424, 0.161052, 0.15965, 0.158217,
  0.156754, 0.155261, 0.153738, 0.152186, 0.150605, 0.148995,
  0.147358, 0.145693, 0.144, 0.142281, 0.140535, 0.138763, 0.136966,
  0.135143, 0.133295, 0.131423, 0.129526, 0.127607, 0.125664,
  0.123698, 0.12171, 0.1197, 0.117669, 0.115617, 0.113544, 0.111451,
  0.109339, 0.107208, 0.105057, 0.102889, 0.100703, 0.0984991,
  0.0962787, 0.0940419, 0.0917892, 0.0895211, 0.087238, 0.0849404,
  0.0826288, 0.0803037, 0.0779655, 0.0756146, 0.0732517, 0.0708771,
  0.0684914, 0.066095, 0.0636884, 0.0612721, 0.0588466, 0.0564123,
  0.0539697, 0.0515194, 0.0490618, 0.0465973, 0.0441266, 0.0416499,
  0.0391679, 0.036681, 0.0341897, 0.0316945, 0.0291958, 0.0266941,
  0.0241899, 0.0216838, 0.019176, 0.0166672, 0.0141578, 0.0116483,
  0.00913911, 0.00663074, 0.00412365, 0.0016183, -0.000884837,
  -0.00338531, -0.00588265, -0.0083764, -0.0108661, -0.0133513,
  -0.0158316, -0.0183064, -0.0207754, -0.0232382, -0.0256942,
  -0.028143, -0.0305842, -0.0330173, -0.035442, -0.0378578,
  -0.0402642, -0.0426609, -0.0450475, -0.0474234, -0.0497883,
  -0.0521418, -0.0544835, -0.056813, -0.0591298, -0.0614336,
  -0.063724, -0.0660005, -0.0682629, -0.0705107, -0.0727436,
  -0.0749611, -0.0771629, -0.0793486, -0.0815179, -0.0836704,
  -0.0858058, -0.0879237, -0.0900237, -0.0921055, -0.0941688,
  -0.0962132, -0.0982384, -0.100244, -0.10223, -0.104196, -0.106141,
  -0.108065, -0.109969, -0.111851, -0.113711, -0.115549, -0.117365,
  -0.119159, -0.120929, -0.122677, -0.124401, -0.126102, -0.127779,
  -0.129431, -0.13106, -0.132663, -0.134242, -0.135796, -0.137324,
  -0.138827, -0.140304, -0.141756, -0.143181, -0.144579, -0.145952,
  -0.147297, -0.148615, -0.149907, -0.151171, -0.152407, -0.153616,
  -0.154797, -0.155951, -0.157076, -0.158173, -0.159241, -0.160281,
  -0.161292, -0.162275, -0.163229, -0.164153, -0.165049, -0.165915,
  -0.166753, -0.16756, -0.168338, -0.169087, -0.169806, -0.170495,
  -0.171155, -0.171785, -0.172384, -0.172954, -0.173494, -0.174004,
  -0.174484, -0.174933, -0.175353, -0.175742, -0.176101, -0.176431,
  -0.17673, -0.176998, -0.177237, -0.177445, -0.177624, -0.177772,
  -0.17789, -0.177978, -0.178036, -0.178064, -0.178063, -0.178031,
  -0.177969, -0.177878, -0.177757, -0.177607, -0.177426, -0.177217,
  -0.176978, -0.176709, -0.176412, -0.176085, -0.17573, -0.175345,
  -0.174932, -0.17449, -0.174019, -0.17352, -0.172993, -0.172438,
  -0.171854, -0.171243, -0.170604, -0.169937, -0.169243, -0.168522,
  -0.167773, -0.166998, -0.166196, -0.165367, -0.164512, -0.16363,
  -0.162723, -0.16179, -0.160831, -0.159846, -0.158836, -0.157802,
  -0.156742, -0.155658, -0.154549, -0.153416, -0.152259, -0.151078,
  -0.149874, -0.148646, -0.147396, -0.146122, -0.144826, -0.143508,
  -0.142167, -0.140805, -0.139421, -0.138016, -0.136589, -0.135142,
  -0.133674, -0.132186, -0.130678, -0.12915, -0.127603, -0.126036,
  -0.124451, -0.122847, -0.121225, -0.119584, -0.117926, -0.11625,
  -0.114557, -0.112847, -0.111121, -0.109378, -0.107619, -0.105845,
  -0.104055, -0.10225, -0.10043, -0.0985963, -0.0967479, -0.0948857,
  -0.0930099, -0.0911209, -0.089219, -0.0873045, -0.0853777,
  -0.083439, -0.0814886, -0.079527, -0.0775543, -0.075571, -0.0735773,
  -0.0715737, -0.0695603, -0.0675376, -0.0655059, -0.0634654,
  -0.0614166, -0.0593598, -0.0572952, -0.0552233, -0.0531443,
  -0.0510586, -0.0489665, -0.0468684, -0.0447645, -0.0426553,
  -0.040541, -0.038422, -0.0362986, -0.0341712, -0.03204, -0.0299055,
  -0.0277679, -0.0256275, -0.0234848, -0.02134, -0.0191935,
  -0.0170456, -0.0148966, -0.0127469, -0.0105968, -0.00844658,
  -0.00629662, -0.00414723, -0.00199874, 0.000148526, 0.00229424,
  0.00443808, 0.00657973, 0.00871887, 0.0108552, 0.0129883, 0.015118,
  0.0172438, 0.0193656, 0.0214829, 0.0235956, 0.0257031, 0.0278053,
  0.0299019, 0.0319924, 0.0340767, 0.0361544, 0.0382253, 0.0402889,
  0.042345, 0.0443934, 0.0464337, 0.0484656, 0.0504888, 0.0525031,
  0.0545082, 0.0565037, 0.0584894, 0.060465, 0.0624302, 0.0643848,
  0.0663284, 0.0682608, 0.0701818, 0.072091, 0.0739882, 0.0758731,
  0.0777455, 0.079605, 0.0814515, 0.0832847, 0.0851044, 0.0869102,
  0.088702, 0.0904794, 0.0922423, 0.0939904, 0.0957235, 0.0974413,
  0.0991436, 0.10083, 0.102501, 0.104155, 0.105793, 0.107415,
  0.109019, 0.110607, 0.112177, 0.11373, 0.115265, 0.116783, 0.118282,
  0.119763, 0.121226, 0.12267, 0.124095, 0.125501, 0.126888, 0.128256,
  0.129604, 0.130932, 0.13224, 0.133529, 0.134797, 0.136045, 0.137273,
  0.138479, 0.139665, 0.14083, 0.141974, 0.143097, 0.144199, 0.145278,
  0.146337, 0.147373, 0.148388, 0.149381, 0.150351, 0.1513, 0.152226,
  0.153129, 0.154011, 0.154869, 0.155705, 0.156518, 0.157308,
  0.158075, 0.158819, 0.15954, 0.160238, 0.160913, 0.161564, 0.162192,
  0.162796, 0.163377, 0.163934, 0.164468, 0.164978, 0.165464,
  0.165927, 0.166365, 0.16678, 0.167171, 0.167538, 0.167882, 0.168201,
  0.168497, 0.168768, 0.169016, 0.169239, 0.169439, 0.169615,
  0.169766, 0.169894, 0.169998, 0.170078, 0.170134, 0.170166,
  0.170174, 0.170159, 0.17012, 0.170057, 0.16997, 0.169859, 0.169725,
  0.169567, 0.169386, 0.169181, 0.168953, 0.168702, 0.168427,
  0.168128, 0.167807, 0.167463, 0.167095, 0.166705, 0.166292,
  0.165855, 0.165397, 0.164915, 0.164411, 0.163885, 0.163336,
  0.162766, 0.162173, 0.161558, 0.160921, 0.160262, 0.159582, 0.15888,
  0.158156, 0.157412, 0.156646, 0.155859, 0.155051, 0.154222,
  0.153373, 0.152503, 0.151613, 0.150703, 0.149772, 0.148822,
  0.147852, 0.146862, 0.145853, 0.144824, 0.143777, 0.14271, 0.141625,
  0.140521, 0.139398, 0.138257, 0.137098, 0.135921, 0.134727,
  0.133514, 0.132284, 0.131038, 0.129774, 0.128493, 0.127195,
  0.125881, 0.124551, 0.123205, 0.121843, 0.120465, 0.119072,
  0.117664, 0.11624, 0.114802, 0.113349, 0.111881, 0.1104, 0.108904,
  0.107394, 0.105871, 0.104335, 0.102786, 0.101223, 0.0996482,
  0.0980606, 0.0964609, 0.0948491, 0.0932255, 0.0915904, 0.089944,
  0.0882864, 0.086618, 0.084939, 0.0832496, 0.08155, 0.0798405,
  0.0781213, 0.0763926, 0.0746548, 0.0729079, 0.0711524, 0.0693884,
  0.0676161, 0.0658358, 0.0640477, 0.0622521, 0.0604493, 0.0586394,
  0.0568228, 0.0549996, 0.0531701, 0.0513346, 0.0494933, 0.0476464,
  0.0457942, 0.043937, 0.042075, 0.0402084, 0.0383376, 0.0364626,
  0.0345839, 0.0327016, 0.030816, 0.0289273, 0.0270359, 0.0251418,
  0.0232455, 0.0213471, 0.0194469, 0.0175451, 0.0156421, 0.0137379,
  0.011833, 0.00992744, 0.0080216, 0.00611569, 0.00420995, 0.00230464,
  0.0004, -0.00150373, -0.00340629, -0.00530745, -0.00720696,
  -0.00910458, -0.0110001, -0.0128932, -0.0147836, -0.0166712,
  -0.0185558, -0.0204369, -0.0223145, -0.0241883, -0.026058,
  -0.0279234, -0.0297843, -0.0316404, -0.0334916, -0.0353375,
  -0.0371779, -0.0390126, -0.0408415, -0.0426641, -0.0444804,
  -0.0462901, -0.048093, -0.0498888, -0.0516774, -0.0534584,
  -0.0552318, -0.0569972, -0.0587544, -0.0605033, -0.0622436,
  -0.0639751, -0.0656976, -0.0674109, -0.0691148, -0.070809,
  -0.0724934, -0.0741678, -0.0758319, -0.0774855, -0.0791285,
  -0.0807607, -0.0823818, -0.0839917, -0.0855902, -0.087177,
  -0.0887521, -0.0903151, -0.091866, -0.0934045, -0.0949304,
  -0.0964436, -0.0979439, -0.0994312, -0.100905, -0.102366, -0.103813,
  -0.105246, -0.106665, -0.10807, -0.109461, -0.110837, -0.112199,
  -0.113546, -0.114878, -0.116196, -0.117497, -0.118784, -0.120055,
  -0.121311, -0.12255, -0.123774, -0.124982, -0.126173, -0.127348,
  -0.128507, -0.129649, -0.130774, -0.131883, -0.132974, -0.134049,
  -0.135106, -0.136146, -0.137168, -0.138173, -0.13916, -0.14013,
  -0.141082, -0.142015, -0.142931, -0.143828, -0.144707, -0.145568,
  -0.146411, -0.147235, -0.14804, -0.148826, -0.149594, -0.150343,
  -0.151073, -0.151784, -0.152476, -0.153149, -0.153802, -0.154436,
  -0.155051, -0.155647, -0.156223, -0.15678, -0.157317, -0.157834,
  -0.158332, -0.15881, -0.159269, -0.159707, -0.160126, -0.160525,
  -0.160904, -0.161263, -0.161603, -0.161922, -0.162221, -0.162501,
  -0.16276, -0.163, -0.163219, -0.163418, -0.163597, -0.163757,
  -0.163896, -0.164015, -0.164114, -0.164193, -0.164252, -0.16429,
  -0.164309, -0.164308, -0.164287, -0.164246, -0.164185, -0.164104,
  -0.164003, -0.163882, -0.163742, -0.163581, -0.163401, -0.163201,
  -0.162982, -0.162743, -0.162484, -0.162206, -0.161908, -0.161591,
  -0.161254, -0.160898, -0.160523, -0.160128, -0.159715, -0.159282,
  -0.15883, -0.15836, -0.15787, -0.157362, -0.156835, -0.156289,
  -0.155725, -0.155142, -0.154541, -0.153921, -0.153284, -0.152628,
  -0.151954, -0.151262, -0.150553, -0.149825, -0.14908, -0.148318,
  -0.147538, -0.14674, -0.145926, -0.145094, -0.144246, -0.14338,
  -0.142498, -0.141599, -0.140683, -0.139752, -0.138804, -0.137839,
  -0.136859, -0.135863, -0.134851, -0.133823, -0.13278, -0.131722,
  -0.130648, -0.129559, -0.128456, -0.127337, -0.126204, -0.125056,
  -0.123894, -0.122718, -0.121528, -0.120324, -0.119106, -0.117874,
  -0.116629, -0.115371, -0.114099, -0.112815, -0.111518, -0.110208,
  -0.108885, -0.107551, -0.106204, -0.104845, -0.103474, -0.102092,
  -0.100698, -0.0992928, -0.0978766, -0.0964494, -0.0950114,
  -0.0935628, -0.0921037, -0.0906345, -0.0891551, -0.0876659,
  -0.0861669, -0.0846585, -0.0831407, -0.0816137, -0.0800777,
  -0.078533, -0.0769797, -0.075418, -0.073848, -0.07227, -0.0706841,
  -0.0690906, -0.0674897, -0.0658815, -0.0642661, -0.0626439,
  -0.0610151, -0.0593797, -0.057738, -0.0560902, -0.0544365,
  -0.052777, -0.0511121, -0.0494418, -0.0477664, -0.0460861,
  -0.044401, -0.0427114, -0.0410175, -0.0393195, -0.0376175,
  -0.0359117, -0.0342025, -0.0324899, -0.0307742, -0.0290555,
  -0.0273341, -0.0256102, -0.0238839, -0.0221555, -0.0204252,
  -0.0186931, -0.0169595, -0.0152246, -0.0134885, -0.0117515,
  -0.0100138, -0.00827559, -0.00653701, -0.00479831, -0.00305967,
  -0.00132131, 0.000416588, 0.00215382, 0.00389018, 0.00562548,
  0.00735952, 0.0090921, 0.010823, 0.0125521, 0.0142791, 0.0160039,
  0.0177262, 0.0194459, 0.0211628, 0.0228766, 0.0245872, 0.0262945,
  0.0279981, 0.0296979, 0.0313937, 0.0330854, 0.0347727, 0.0364554,
  0.0381334, 0.0398064, 0.0414744, 0.043137, 0.0447942, 0.0464456,
  0.0480913, 0.0497308, 0.0513642, 0.0529911, 0.0546115, 0.0562251,
  0.0578318, 0.0594314, 0.0610236, 0.0626084, 0.0641856, 0.0657549,
  0.0673162, 0.0688694, 0.0704143, 0.0719506, 0.0734783, 0.0749972,
  0.0765071, 0.0780078, 0.0794991, 0.080981, 0.0824533, 0.0839157,
  0.0853682, 0.0868105, 0.0882426, 0.0896642, 0.0910753, 0.0924756,
  0.093865, 0.0952434, 0.0966106, 0.0979665, 0.0993109, 0.100644,
  0.101965, 0.103274, 0.104571, 0.105856, 0.107128, 0.108389,
  0.109636, 0.110871, 0.112093, 0.113302, 0.114498, 0.115681, 0.11685,
  0.118006, 0.119148, 0.120277, 0.121392, 0.122493, 0.12358, 0.124652,
  0.125711, 0.126755, 0.127784, 0.128799, 0.129799, 0.130785,
  0.131755, 0.132711, 0.133651, 0.134576, 0.135486, 0.136381, 0.13726,
  0.138123, 0.138971, 0.139803, 0.14062, 0.14142, 0.142205, 0.142973,
  0.143726, 0.144462, 0.145182, 0.145885, 0.146572, 0.147243,
  0.147897, 0.148535, 0.149156, 0.14976, 0.150347, 0.150918, 0.151472,
  0.152008, 0.152528, 0.153031, 0.153517, 0.153985, 0.154437,
  0.154871, 0.155288, 0.155688, 0.156071, 0.156436, 0.156784,
  0.157114, 0.157427, 0.157723, 0.158001, 0.158262, 0.158505,
  0.158731, 0.158939, 0.159129, 0.159302, 0.159458, 0.159596,
  0.159716, 0.159819, 0.159904, 0.159972, 0.160022, 0.160054,
  0.160069, 0.160067, 0.160047, 0.160009, 0.159954, 0.159881,
  0.159791, 0.159684, 0.159559, 0.159416, 0.159257, 0.159079,
  0.158885, 0.158673, 0.158444, 0.158198, 0.157934, 0.157654,
  0.157356, 0.157041, 0.15671, 0.156361, 0.155995, 0.155612, 0.155213,
  0.154797, 0.154364, 0.153914, 0.153448, 0.152965, 0.152466, 0.15195,
  0.151418, 0.15087, 0.150305, 0.149725, 0.149128, 0.148515, 0.147886,
  0.147242, 0.146581, 0.145905, 0.145214, 0.144506, 0.143784,
  0.143046, 0.142292, 0.141524, 0.14074, 0.139942, 0.139128, 0.1383,
  0.137457, 0.136599, 0.135727, 0.134841, 0.13394, 0.133025, 0.132096,
  0.131152, 0.130195, 0.129225, 0.12824, 0.127242, 0.126231, 0.125206,
  0.124168, 0.123117, 0.122053, 0.120976, 0.119887, 0.118785, 0.11767,
  0.116543, 0.115404, 0.114253, 0.113089, 0.111914, 0.110728,
  0.109529, 0.10832, 0.107099, 0.105867, 0.104623, 0.103369, 0.102105,
  0.100829, 0.0995433, 0.0982471, 0.0969408, 0.0956244, 0.0942982,
  0.0929622, 0.0916166, 0.0902616, 0.0888973, 0.0875239, 0.0861414,
  0.0847502, 0.0833502, 0.0819418, 0.0805249, 0.0790998, 0.0776667,
  0.0762256, 0.0747768, 0.0733204, 0.0718565, 0.0703854, 0.0689072,
  0.067422, 0.06593, 0.0644314, 0.0629263, 0.0614148, 0.0598973,
  0.0583737, 0.0568444, 0.0553094, 0.0537688, 0.052223, 0.050672,
  0.0491161, 0.0475553, 0.0459898, 0.0444199, 0.0428456, 0.0412672,
  0.0396848, 0.0380986, 0.0365087, 0.0349154, 0.0333187, 0.031719,
  0.0301162, 0.0285107, 0.0269025, 0.0252919, 0.023679, 0.022064,
  0.0204471, 0.0188284, 0.0172081, 0.0155863, 0.0139633, 0.0123393,
  0.0107143, 0.00908853, 0.00746223, 0.00583553, 0.0042086,
  0.00258162, 0.000954744, -0.000671844, -0.00229798, -0.00392348,
  -0.00554819, -0.00717194, -0.00879455, -0.0104159, -0.0120357,
  -0.0136539, -0.0152703, -0.0168846, -0.0184969, -0.0201068,
  -0.0217143, -0.0233191, -0.024921, -0.02652, -0.0281159, -0.0297084,
  -0.0312975, -0.0328829, -0.0344645, -0.0360421, -0.0376156,
  -0.0391848, -0.0407495, -0.0423096, -0.043865, -0.0454153,
  -0.0469606, -0.0485007, -0.0500353, -0.0515643, -0.0530876,
  -0.0546051, -0.0561165, -0.0576216, -0.0591205, -0.0606128,
  -0.0620985, -0.0635773, -0.0650492, -0.066514, -0.0679716,
  -0.0694217, -0.0708643, -0.0722992, -0.0737262, -0.0751452,
  -0.0765561, -0.0779588, -0.079353, -0.0807386, -0.0821156,
  -0.0834837, -0.0848428, -0.0861928, -0.0875336, -0.088865,
  -0.0901869, -0.0914991, -0.0928015, -0.094094, -0.0953765,
  -0.0966488, -0.0979108, -0.0991624, -0.100403, -0.101634, -0.102853,
  -0.104062, -0.10526, -0.106446, -0.107621, -0.108785, -0.109937,
  -0.111078, -0.112207, -0.113324, -0.114429, -0.115522, -0.116603,
  -0.117671, -0.118728, -0.119771, -0.120803, -0.121821, -0.122827,
  -0.123819, -0.124799, -0.125766, -0.126719, -0.12766, -0.128587,
  -0.1295, -0.1304, -0.131286, -0.132159, -0.133018, -0.133862,
  -0.134693, -0.13551, -0.136313, -0.137102, -0.137876, -0.138636,
  -0.139382, -0.140113, -0.140829, -0.141531, -0.142218, -0.142891,
  -0.143549, -0.144191, -0.144819, -0.145432, -0.14603, -0.146613,
  -0.14718, -0.147733, -0.14827, -0.148791, -0.149298, -0.149789,
  -0.150264, -0.150724, -0.151169, -0.151598, -0.152011, -0.152409,
  -0.152791, -0.153157, -0.153508, -0.153842, -0.154161, -0.154465,
  -0.154752, -0.155023, -0.155279, -0.155518, -0.155742, -0.15595,
  -0.156141, -0.156317, -0.156477, -0.156621, -0.156748, -0.15686,
  -0.156956, -0.157035, -0.157099, -0.157147, -0.157178, -0.157194,
  -0.157193, -0.157177, -0.157144, -0.157096, -0.157031, -0.156951,
  -0.156854, -0.156742, -0.156613, -0.156469, -0.156309, -0.156133,
  -0.155941, -0.155733, -0.15551, -0.155271, -0.155016, -0.154745,
  -0.154459, -0.154157, -0.153839, -0.153506, -0.153157, -0.152793,
  -0.152413, -0.152018, -0.151608, -0.151182, -0.150741, -0.150285,
  -0.149814, -0.149328, -0.148826, -0.14831, -0.147778, -0.147232,
  -0.146671, -0.146095, -0.145505, -0.1449, -0.14428, -0.143646,
  -0.142997, -0.142334, -0.141657, -0.140965, -0.14026, -0.13954,
  -0.138806, -0.138059, -0.137298, -0.136522, -0.135734, -0.134931,
  -0.134116, -0.133286, -0.132444, -0.131588, -0.130719, -0.129837,
  -0.128942, -0.128034, -0.127114, -0.126181, -0.125235, -0.124277,
  -0.123306, -0.122323, -0.121328, -0.120321, -0.119302, -0.118272,
  -0.117229, -0.116175, -0.115109, -0.114032, -0.112943, -0.111844,
  -0.110733, -0.109611, -0.108479, -0.107336, -0.106182, -0.105017,
  -0.103843, -0.102658, -0.101463, -0.100258, -0.0990427, -0.097818,
  -0.0965837, -0.0953399, -0.0940867, -0.0928242, -0.0915527,
  -0.0902721, -0.0889827, -0.0876846, -0.0863778, -0.0850627,
  -0.0837391, -0.0824074, -0.0810677, -0.07972, -0.0783646,
  -0.0770015, -0.0756309, -0.0742529, -0.0728677, -0.0714755,
  -0.0700762, -0.0686702, -0.0672575, -0.0658383, -0.0644128,
  -0.062981, -0.0615431, -0.0600992, -0.0586496, -0.0571943,
  -0.0557336, -0.0542674, -0.0527961, -0.0513197, -0.0498384,
  -0.0483523, -0.0468617, -0.0453665, -0.0438671, -0.0423635,
  -0.0408558, -0.0393443, -0.0378291, -0.0363104, -0.0347882,
  -0.0332628, -0.0317343, -0.0302029, -0.0286686, -0.0271317,
  -0.0255923, -0.0240506, -0.0225067, -0.0209608, -0.019413,
  -0.0178635, -0.0163125, -0.01476, -0.0132062, -0.0116514,
  -0.0100956, -0.00853906, -0.00698185, -0.00542416, -0.00386614,
  -0.00230795, -0.000749747, 0.000808324, 0.0023661, 0.00392344,
  0.00548017, 0.00703616, 0.00859123, 0.0101452, 0.011698, 0.0132495,
  0.0147994, 0.0163476, 0.017894, 0.0194385, 0.0209808, 0.0225208,
  0.0240583, 0.0255933, 0.0271256, 0.028655, 0.0301813, 0.0317044,
  0.0332242, 0.0347405, 0.0362532, 0.0377621, 0.039267, 0.0407679,
  0.0422645, 0.0437568, 0.0452445, 0.0467276, 0.0482058, 0.0496791,
  0.0511473, 0.0526103, 0.0540678, 0.0555199, 0.0569662, 0.0584068,
  0.0598414, 0.0612699, 0.0626921, 0.064108, 0.0655174, 0.0669201,
  0.068316, 0.0697051, 0.071087, 0.0724618, 0.0738293, 0.0751893,
  0.0765417, 0.0778864, 0.0792232, 0.080552, 0.0818728, 0.0831853,
  0.0844894, 0.0857851, 0.0870721, 0.0883504, 0.0896198, 0.0908803,
  0.0921316, 0.0933737, 0.0946065, 0.0958297, 0.0970434, 0.0982474,
  0.0994416, 0.100626, 0.1018, 0.102964, 0.104118, 0.105261, 0.106394,
  0.107516, 0.108628, 0.109729, 0.110818, 0.111897, 0.112965,
  0.114021, 0.115066, 0.1161, 0.117122, 0.118132, 0.119131, 0.120118,
  0.121093, 0.122056, 0.123007, 0.123946, 0.124872, 0.125786,
  0.126688, 0.127577, 0.128453, 0.129317, 0.130168, 0.131006,
  0.131831, 0.132643, 0.133442, 0.134227, 0.135, 0.135759, 0.136505,
  0.137237, 0.137956, 0.138661, 0.139352, 0.14003, 0.140694, 0.141344,
  0.14198, 0.142602, 0.14321, 0.143804, 0.144384, 0.14495, 0.145501,
  0.146038, 0.146561, 0.147069, 0.147563, 0.148042, 0.148507,
  0.148957, 0.149392, 0.149813, 0.150219, 0.150611, 0.150988,
  0.151349, 0.151696, 0.152028, 0.152346, 0.152648, 0.152935,
  0.153207, 0.153465, 0.153707, 0.153934, 0.154146, 0.154343,
  0.154525, 0.154692, 0.154844, 0.15498, 0.155102, 0.155208, 0.155299,
  0.155375, 0.155435, 0.155481, 0.155511, 0.155526, 0.155526,
  0.155511, 0.15548, 0.155434, 0.155374, 0.155298, 0.155206, 0.1551,
  0.154979, 0.154842, 0.15469, 0.154524, 0.154342, 0.154145, 0.153933,
  0.153706, 0.153465, 0.153208, 0.152936, 0.15265, 0.152348, 0.152032,
  0.151701, 0.151355, 0.150995, 0.150619, 0.15023, 0.149825, 0.149406,
  0.148973, 0.148525, 0.148062, 0.147585, 0.147094, 0.146589,
  0.146069, 0.145535, 0.144987, 0.144425, 0.143849, 0.143259,
  0.142655, 0.142037, 0.141406, 0.14076, 0.140101, 0.139429, 0.138743,
  0.138043, 0.137331, 0.136604, 0.135865, 0.135113, 0.134347,
  0.133568, 0.132777, 0.131972, 0.131155, 0.130325, 0.129483,
  0.128628, 0.12776, 0.126881, 0.125989, 0.125084, 0.124168, 0.12324,
  0.1223, 0.121348, 0.120384, 0.119408, 0.118421, 0.117423, 0.116413,
  0.115393, 0.11436, 0.113317, 0.112263, 0.111199, 0.110123, 0.109037,
  0.10794, 0.106833, 0.105716, 0.104588, 0.10345, 0.102303, 0.101145,
  0.0999782, 0.0988013, 0.097615, 0.0964193, 0.0952143, 0.0940001,
  0.0927769, 0.0915448, 0.0903039, 0.0890543, 0.0877961, 0.0865296,
  0.0852547, 0.0839716, 0.0826804, 0.0813813, 0.0800745, 0.0787599,
  0.0774377, 0.0761082, 0.0747713, 0.0734273, 0.0720763, 0.0707183,
  0.0693536, 0.0679822, 0.0666043, 0.0652201, 0.0638296, 0.062433,
  0.0610305, 0.0596221, 0.058208, 0.0567883, 0.0553633, 0.0539329,
  0.0524974, 0.051057, 0.0496116, 0.0481615, 0.0467068, 0.0452477,
  0.0437843, 0.0423167, 0.0408452, 0.0393697, 0.0378905, 0.0364077,
  0.0349215, 0.0334319, 0.0319392, 0.0304435, 0.0289449, 0.0274436,
  0.0259397, 0.0244334, 0.0229248, 0.021414, 0.0199012, 0.0183866,
  0.0168703, 0.0153524, 0.0138331, 0.0123126, 0.0107909, 0.00926824,
  0.00774476, 0.0062206, 0.00469591, 0.00317084, 0.00164553,
  0.000120122, -0.00140523, -0.00293037, -0.00445517, -0.00597947,
  -0.00750313, -0.009026, -0.0105479, -0.0120688, -0.0135884,
  -0.0151066, -0.0166234, -0.0181384, -0.0196516, -0.0211629,
  -0.0226721, -0.024179, -0.0256836, -0.0271856, -0.0286849,
  -0.0301813, -0.0316749, -0.0331652, -0.0346524, -0.0361361,
  -0.0376163, -0.0390928, -0.0405655, -0.0420342, -0.0434988,
  -0.0449591, -0.0464151, -0.0478665, -0.0493132, -0.0507552,
  -0.0521922, -0.0536241, -0.0550508, -0.0564721, -0.0578879,
  -0.0592981, -0.0607025, -0.0621011, -0.0634935, -0.0648799,
  -0.0662599, -0.0676335, -0.0690005, -0.0703608, -0.0717143,
  -0.0730608, -0.0744002, -0.0757324, -0.0770573, -0.0783747,
  -0.0796845, -0.0809866, -0.0822808, -0.0835671, -0.0848453,
  -0.0861152, -0.0873769, -0.08863, -0.0898746, -0.0911105,
  -0.0923375, -0.0935557, -0.0947647, -0.0959646, -0.0971553,
  -0.0983365, -0.0995082, -0.10067, -0.101823, -0.102965, -0.104098,
  -0.10522, -0.106333, -0.107435, -0.108526, -0.109608, -0.110678,
  -0.111738, -0.112787, -0.113826, -0.114853, -0.115869, -0.116874,
  -0.117868, -0.11885, -0.119821, -0.12078, -0.121728, -0.122664,
  -0.123588, -0.1245, -0.1254, -0.126288, -0.127164, -0.128027,
  -0.128878, -0.129717, -0.130544, -0.131357, -0.132158, -0.132946,
  -0.133722, -0.134484, -0.135234, -0.135971, -0.136694, -0.137404,
  -0.138101, -0.138785, -0.139455, -0.140112, -0.140756, -0.141385,
  -0.142002, -0.142604, -0.143193, -0.143768, -0.144329, -0.144876,
  -0.14541, -0.145929, -0.146434, -0.146925, -0.147402, -0.147865,
  -0.148313, -0.148747, -0.149167, -0.149573, -0.149964, -0.15034,
  -0.150703, -0.15105, -0.151383, -0.151702, -0.152006, -0.152295,
  -0.15257, -0.152829, -0.153075, -0.153305, -0.153521, -0.153722,
  -0.153908, -0.154079, -0.154235, -0.154377, -0.154504, -0.154616,
  -0.154712, -0.154795, -0.154862, -0.154914, -0.154951, -0.154974,
  -0.154981, -0.154974, -0.154951, -0.154914, -0.154862, -0.154795,
  -0.154712, -0.154616, -0.154504, -0.154377, -0.154235, -0.154079,
  -0.153908, -0.153722, -0.153521, -0.153305, -0.153075, -0.152829,
  -0.15257, -0.152295, -0.152006, -0.151702, -0.151383, -0.15105,
  -0.150703, -0.15034, -0.149964, -0.149573, -0.149167, -0.148747,
  -0.148313, -0.147865, -0.147402, -0.146925, -0.146434, -0.145929,
  -0.14541, -0.144876, -0.144329, -0.143768, -0.143193, -0.142604,
  -0.142002, -0.141385, -0.140756, -0.140112, -0.139455, -0.138785,
  -0.138101, -0.137404, -0.136694, -0.135971, -0.135234, -0.134484,
  -0.133722, -0.132946, -0.132158, -0.131357, -0.130544, -0.129717,
  -0.128878, -0.128027, -0.127164, -0.126288, -0.1254, -0.1245,
  -0.123588, -0.122664, -0.121728, -0.12078, -0.119821, -0.11885,
  -0.117868, -0.116874, -0.115869, -0.114853, -0.113826, -0.112787,
  -0.111738, -0.110678, -0.109608, -0.108526, -0.107435, -0.106333,
  -0.10522, -0.104098, -0.102965, -0.101823, -0.10067, -0.0995082,
  -0.0983365, -0.0971553, -0.0959646, -0.0947647, -0.0935557,
  -0.0923375, -0.0911105, -0.0898746, -0.08863, -0.0873769,
  -0.0861152, -0.0848453, -0.0835671, -0.0822808, -0.0809866,
  -0.0796845, -0.0783747, -0.0770573, -0.0757324, -0.0744002,
  -0.0730608, -0.0717143, -0.0703608, -0.0690005, -0.0676335,
  -0.0662599, -0.0648799, -0.0634935, -0.0621011, -0.0607025,
  -0.0592981, -0.0578879, -0.0564721, -0.0550508, -0.0536241,
  -0.0521922, -0.0507552, -0.0493132, -0.0478665, -0.0464151,
  -0.0449591, -0.0434988, -0.0420342, -0.0405655, -0.0390928,
  -0.0376163, -0.0361361, -0.0346524, -0.0331652, -0.0316749,
  -0.0301813, -0.0286849, -0.0271856, -0.0256836, -0.024179,
  -0.0226721, -0.0211629, -0.0196516, -0.0181384, -0.0166234,
  -0.0151066, -0.0135884, -0.0120688, -0.0105479, -0.009026,
  -0.00750313, -0.00597947, -0.00445517, -0.00293037, -0.00140523,
  0.000120122, 0.00164553, 0.00317084, 0.00469591, 0.0062206,
  0.00774476, 0.00926824, 0.0107909, 0.0123126, 0.0138331, 0.0153524,
  0.0168703, 0.0183866, 0.0199012, 0.021414, 0.0229248, 0.0244334,
  0.0259397, 0.0274436, 0.0289449, 0.0304435, 0.0319392, 0.0334319,
  0.0349215, 0.0364077, 0.0378905, 0.0393697, 0.0408452, 0.0423167,
  0.0437843, 0.0452477, 0.0467068, 0.0481615, 0.0496116, 0.051057,
  0.0524974, 0.0539329, 0.0553633, 0.0567883, 0.058208, 0.0596221,
  0.0610305, 0.062433, 0.0638296, 0.0652201, 0.0666043, 0.0679822,
  0.0693536, 0.0707183, 0.0720763, 0.0734273, 0.0747713, 0.0761082,
  0.0774377, 0.0787599, 0.0800745, 0.0813813, 0.0826804, 0.0839716,
  0.0852547, 0.0865296, 0.0877961, 0.0890543, 0.0903039, 0.0915448,
  0.0927769, 0.0940001, 0.0952143, 0.0964193, 0.097615, 0.0988013,
  0.0999782, 0.101145, 0.102303, 0.10345, 0.104588, 0.105716,
  0.106833, 0.10794, 0.109037, 0.110123, 0.111199, 0.112263, 0.113317,
  0.11436, 0.115393, 0.116413, 0.117423, 0.118421, 0.119408, 0.120384,
  0.121348, 0.1223, 0.12324, 0.124168, 0.125084, 0.125989, 0.126881,
  0.12776, 0.128628, 0.129483, 0.130325, 0.131155, 0.131972, 0.132777,
  0.133568, 0.134347, 0.135113, 0.135865, 0.136604, 0.137331,
  0.138043, 0.138743, 0.139429, 0.140101, 0.14076, 0.141406, 0.142037,
  0.142655, 0.143259, 0.143849, 0.144425, 0.144987, 0.145535,
  0.146069, 0.146589, 0.147094, 0.147585, 0.148062, 0.148525,
  0.148973, 0.149406, 0.149825, 0.15023, 0.150619, 0.150995, 0.151355,
  0.151701, 0.152032, 0.152348, 0.15265, 0.152936, 0.153208, 0.153465,
  0.153706, 0.153933, 0.154145, 0.154342, 0.154524, 0.15469, 0.154842,
  0.154979, 0.1551, 0.155206, 0.155298, 0.155374, 0.155434, 0.15548,
  0.155511, 0.155526, 0.155526, 0.155511, 0.155481, 0.155435,
  0.155375, 0.155299, 0.155208, 0.155102, 0.15498, 0.154844, 0.154692,
  0.154525, 0.154343, 0.154146, 0.153934, 0.153707, 0.153465,
  0.153207, 0.152935, 0.152648, 0.152346, 0.152028, 0.151696,
  0.151349, 0.150988, 0.150611, 0.150219, 0.149813, 0.149392,
  0.148957, 0.148507, 0.148042, 0.147563, 0.147069, 0.146561,
  0.146038, 0.145501, 0.14495, 0.144384, 0.143804, 0.14321, 0.142602,
  0.14198, 0.141344, 0.140694, 0.14003, 0.139352, 0.138661, 0.137956,
  0.137237, 0.136505, 0.135759, 0.135, 0.134227, 0.133442, 0.132643,
  0.131831, 0.131006, 0.130168, 0.129317, 0.128453, 0.127577,
  0.126688, 0.125786, 0.124872, 0.123946, 0.123007, 0.122056,
  0.121093, 0.120118, 0.119131, 0.118132, 0.117122, 0.1161, 0.115066,
  0.114021, 0.112965, 0.111897, 0.110818, 0.109729, 0.108628,
  0.107516, 0.106394, 0.105261, 0.104118, 0.102964, 0.1018, 0.100626,
  0.0994416, 0.0982474, 0.0970434, 0.0958297, 0.0946065, 0.0933737,
  0.0921316, 0.0908803, 0.0896198, 0.0883504, 0.0870721, 0.0857851,
  0.0844894, 0.0831853, 0.0818728, 0.080552, 0.0792232, 0.0778864,
  0.0765417, 0.0751893, 0.0738293, 0.0724618, 0.071087, 0.0697051,
  0.068316, 0.0669201, 0.0655174, 0.064108, 0.0626921, 0.0612699,
  0.0598414, 0.0584068, 0.0569662, 0.0555199, 0.0540678, 0.0526103,
  0.0511473, 0.0496791, 0.0482058, 0.0467276, 0.0452445, 0.0437568,
  0.0422645, 0.0407679, 0.039267, 0.0377621, 0.0362532, 0.0347405,
  0.0332242, 0.0317044, 0.0301813, 0.028655, 0.0271256, 0.0255933,
  0.0240583, 0.0225208, 0.0209808, 0.0194385, 0.017894, 0.0163476,
  0.0147994, 0.0132495, 0.011698, 0.0101452, 0.00859123, 0.00703616,
  0.00548017, 0.00392344, 0.0023661, 0.000808324, -0.000749747,
  -0.00230795, -0.00386614, -0.00542416, -0.00698185, -0.00853906,
  -0.0100956, -0.0116514, -0.0132062, -0.01476, -0.0163125,
  -0.0178635, -0.019413, -0.0209608, -0.0225067, -0.0240506,
  -0.0255923, -0.0271317, -0.0286686, -0.0302029, -0.0317343,
  -0.0332628, -0.0347882, -0.0363104, -0.0378291, -0.0393443,
  -0.0408558, -0.0423635, -0.0438671, -0.0453665, -0.0468617,
  -0.0483523, -0.0498384, -0.0513197, -0.0527961, -0.0542674,
  -0.0557336, -0.0571943, -0.0586496, -0.0600992, -0.0615431,
  -0.062981, -0.0644128, -0.0658383, -0.0672575, -0.0686702,
  -0.0700762, -0.0714755, -0.0728677, -0.0742529, -0.0756309,
  -0.0770015, -0.0783646, -0.07972, -0.0810677, -0.0824074,
  -0.0837391, -0.0850627, -0.0863778, -0.0876846, -0.0889827,
  -0.0902721, -0.0915527, -0.0928242, -0.0940867, -0.0953399,
  -0.0965837, -0.097818, -0.0990427, -0.100258, -0.101463, -0.102658,
  -0.103843, -0.105017, -0.106182, -0.107336, -0.108479, -0.109611,
  -0.110733, -0.111844, -0.112943, -0.114032, -0.115109, -0.116175,
  -0.117229, -0.118272, -0.119302, -0.120321, -0.121328, -0.122323,
  -0.123306, -0.124277, -0.125235, -0.126181, -0.127114, -0.128034,
  -0.128942, -0.129837, -0.130719, -0.131588, -0.132444, -0.133286,
  -0.134116, -0.134931, -0.135734, -0.136522, -0.137298, -0.138059,
  -0.138806, -0.13954, -0.14026, -0.140965, -0.141657, -0.142334,
  -0.142997, -0.143646, -0.14428, -0.1449, -0.145505, -0.146095,
  -0.146671, -0.147232, -0.147778, -0.14831, -0.148826, -0.149328,
  -0.149814, -0.150285, -0.150741, -0.151182, -0.151608, -0.152018,
  -0.152413, -0.152793, -0.153157, -0.153506, -0.153839, -0.154157,
  -0.154459, -0.154745, -0.155016, -0.155271, -0.15551, -0.155733,
  -0.155941, -0.156133, -0.156309, -0.156469, -0.156613, -0.156742,
  -0.156854, -0.156951, -0.157031, -0.157096, -0.157144, -0.157177,
  -0.157193, -0.157194, -0.157178, -0.157147, -0.157099, -0.157035,
  -0.156956, -0.15686, -0.156748, -0.156621, -0.156477, -0.156317,
  -0.156141, -0.15595, -0.155742, -0.155518, -0.155279, -0.155023,
  -0.154752, -0.154465, -0.154161, -0.153842, -0.153508, -0.153157,
  -0.152791, -0.152409, -0.152011, -0.151598, -0.151169, -0.150724,
  -0.150264, -0.149789, -0.149298, -0.148791, -0.14827, -0.147733,
  -0.14718, -0.146613, -0.14603, -0.145432, -0.144819, -0.144191,
  -0.143549, -0.142891, -0.142218, -0.141531, -0.140829, -0.140113,
  -0.139382, -0.138636, -0.137876, -0.137102, -0.136313, -0.13551,
  -0.134693, -0.133862, -0.133018, -0.132159, -0.131286, -0.1304,
  -0.1295, -0.128587, -0.12766, -0.126719, -0.125766, -0.124799,
  -0.123819, -0.122827, -0.121821, -0.120803, -0.119771, -0.118728,
  -0.117671, -0.116603, -0.115522, -0.114429, -0.113324, -0.112207,
  -0.111078, -0.109937, -0.108785, -0.107621, -0.106446, -0.10526,
  -0.104062, -0.102853, -0.101634, -0.100403, -0.0991624, -0.0979108,
  -0.0966488, -0.0953765, -0.094094, -0.0928015, -0.0914991,
  -0.0901869, -0.088865, -0.0875336, -0.0861928, -0.0848428,
  -0.0834837, -0.0821156, -0.0807386, -0.079353, -0.0779588,
  -0.0765561, -0.0751452, -0.0737262, -0.0722992, -0.0708643,
  -0.0694217, -0.0679716, -0.066514, -0.0650492, -0.0635773,
  -0.0620985, -0.0606128, -0.0591205, -0.0576216, -0.0561165,
  -0.0546051, -0.0530876, -0.0515643, -0.0500353, -0.0485007,
  -0.0469606, -0.0454153, -0.043865, -0.0423096, -0.0407495,
  -0.0391848, -0.0376156, -0.0360421, -0.0344645, -0.0328829,
  -0.0312975, -0.0297084, -0.0281159, -0.02652, -0.024921, -0.0233191,
  -0.0217143, -0.0201068, -0.0184969, -0.0168846, -0.0152703,
  -0.0136539, -0.0120357, -0.0104159, -0.00879455, -0.00717194,
  -0.00554819, -0.00392348, -0.00229798, -0.000671844, 0.000954744,
  0.00258162, 0.0042086, 0.00583553, 0.00746223, 0.00908853,
  0.0107143, 0.0123393, 0.0139633, 0.0155863, 0.0172081, 0.0188284,
  0.0204471, 0.022064, 0.023679, 0.0252919, 0.0269025, 0.0285107,
  0.0301162, 0.031719, 0.0333187, 0.0349154, 0.0365087, 0.0380986,
  0.0396848, 0.0412672, 0.0428456, 0.0444199, 0.0459898, 0.0475553,
  0.0491161, 0.050672, 0.052223, 0.0537688, 0.0553094, 0.0568444,
  0.0583737, 0.0598973, 0.0614148, 0.0629263, 0.0644314, 0.06593,
  0.067422, 0.0689072, 0.0703854, 0.0718565, 0.0733204, 0.0747768,
  0.0762256, 0.0776667, 0.0790998, 0.0805249, 0.0819418, 0.0833502,
  0.0847502, 0.0861414, 0.0875239, 0.0888973, 0.0902616, 0.0916166,
  0.0929622, 0.0942982, 0.0956244, 0.0969408, 0.0982471, 0.0995433,
  0.100829, 0.102105, 0.103369, 0.104623, 0.105867, 0.107099, 0.10832,
  0.109529, 0.110728, 0.111914, 0.113089, 0.114253, 0.115404,
  0.116543, 0.11767, 0.118785, 0.119887, 0.120976, 0.122053, 0.123117,
  0.124168, 0.125206, 0.126231, 0.127242, 0.12824, 0.129225, 0.130195,
  0.131152, 0.132096, 0.133025, 0.13394, 0.134841, 0.135727, 0.136599,
  0.137457, 0.1383, 0.139128, 0.139942, 0.14074, 0.141524, 0.142292,
  0.143046, 0.143784, 0.144506, 0.145214, 0.145905, 0.146581,
  0.147242, 0.147886, 0.148515, 0.149128, 0.149725, 0.150305, 0.15087,
  0.151418, 0.15195, 0.152466, 0.152965, 0.153448, 0.153914, 0.154364,
  0.154797, 0.155213, 0.155612, 0.155995, 0.156361, 0.15671, 0.157041,
  0.157356, 0.157654, 0.157934, 0.158198, 0.158444, 0.158673,
  0.158885, 0.159079, 0.159257, 0.159416, 0.159559, 0.159684,
  0.159791, 0.159881, 0.159954, 0.160009, 0.160047, 0.160067,
  0.160069, 0.160054, 0.160022, 0.159972, 0.159904, 0.159819,
  0.159716, 0.159596, 0.159458, 0.159302, 0.159129, 0.158939,
  0.158731, 0.158505, 0.158262, 0.158001, 0.157723, 0.157427,
  0.157114, 0.156784, 0.156436, 0.156071, 0.155688, 0.155288,
  0.154871, 0.154437, 0.153985, 0.153517, 0.153031, 0.152528,
  0.152008, 0.151472, 0.150918, 0.150347, 0.14976, 0.149156, 0.148535,
  0.147897, 0.147243, 0.146572, 0.145885, 0.145182, 0.144462,
  0.143726, 0.142973, 0.142205, 0.14142, 0.14062, 0.139803, 0.138971,
  0.138123, 0.13726, 0.136381, 0.135486, 0.134576, 0.133651, 0.132711,
  0.131755, 0.130785, 0.129799, 0.128799, 0.127784, 0.126755,
  0.125711, 0.124652, 0.12358, 0.122493, 0.121392, 0.120277, 0.119148,
  0.118006, 0.11685, 0.115681, 0.114498, 0.113302, 0.112093, 0.110871,
  0.109636, 0.108389, 0.107128, 0.105856, 0.104571, 0.103274,
  0.101965, 0.100644, 0.0993109, 0.0979665, 0.0966106, 0.0952434,
  0.093865, 0.0924756, 0.0910753, 0.0896642, 0.0882426, 0.0868105,
  0.0853682, 0.0839157, 0.0824533, 0.080981, 0.0794991, 0.0780078,
  0.0765071, 0.0749972, 0.0734783, 0.0719506, 0.0704143, 0.0688694,
  0.0673162, 0.0657549, 0.0641856, 0.0626084, 0.0610236, 0.0594314,
  0.0578318, 0.0562251, 0.0546115, 0.0529911, 0.0513642, 0.0497308,
  0.0480913, 0.0464456, 0.0447942, 0.043137, 0.0414744, 0.0398064,
  0.0381334, 0.0364554, 0.0347727, 0.0330854, 0.0313937, 0.0296979,
  0.0279981, 0.0262945, 0.0245872, 0.0228766, 0.0211628, 0.0194459,
  0.0177262, 0.0160039, 0.0142791, 0.0125521, 0.010823, 0.0090921,
  0.00735952, 0.00562548, 0.00389018, 0.00215382, 0.000416588,
  -0.00132131, -0.00305967, -0.00479831, -0.00653701, -0.00827559,
  -0.0100138, -0.0117515, -0.0134885, -0.0152246, -0.0169595,
  -0.0186931, -0.0204252, -0.0221555, -0.0238839, -0.0256102,
  -0.0273341, -0.0290555, -0.0307742, -0.0324899, -0.0342025,
  -0.0359117, -0.0376175, -0.0393195, -0.0410175, -0.0427114,
  -0.044401, -0.0460861, -0.0477664, -0.0494418, -0.0511121,
  -0.052777, -0.0544365, -0.0560902, -0.057738, -0.0593797,
  -0.0610151, -0.0626439, -0.0642661, -0.0658815, -0.0674897,
  -0.0690906, -0.0706841, -0.07227, -0.073848, -0.075418, -0.0769797,
  -0.078533, -0.0800777, -0.0816137, -0.0831407, -0.0846585,
  -0.0861669, -0.0876659, -0.0891551, -0.0906345, -0.0921037,
  -0.0935628, -0.0950114, -0.0964494, -0.0978766, -0.0992928,
  -0.100698, -0.102092, -0.103474, -0.104845, -0.106204, -0.107551,
  -0.108885, -0.110208, -0.111518, -0.112815, -0.114099, -0.115371,
  -0.116629, -0.117874, -0.119106, -0.120324, -0.121528, -0.122718,
  -0.123894, -0.125056, -0.126204, -0.127337, -0.128456, -0.129559,
  -0.130648, -0.131722, -0.13278, -0.133823, -0.134851, -0.135863,
  -0.136859, -0.137839, -0.138804, -0.139752, -0.140683, -0.141599,
  -0.142498, -0.14338, -0.144246, -0.145094, -0.145926, -0.14674,
  -0.147538, -0.148318, -0.14908, -0.149825, -0.150553, -0.151262,
  -0.151954, -0.152628, -0.153284, -0.153921, -0.154541, -0.155142,
  -0.155725, -0.156289, -0.156835, -0.157362, -0.15787, -0.15836,
  -0.15883, -0.159282, -0.159715, -0.160128, -0.160523, -0.160898,
  -0.161254, -0.161591, -0.161908, -0.162206, -0.162484, -0.162743,
  -0.162982, -0.163201, -0.163401, -0.163581, -0.163742, -0.163882,
  -0.164003, -0.164104, -0.164185, -0.164246, -0.164287, -0.164308,
  -0.164309, -0.16429, -0.164252, -0.164193, -0.164114, -0.164015,
  -0.163896, -0.163757, -0.163597, -0.163418, -0.163219, -0.163,
  -0.16276, -0.162501, -0.162221, -0.161922, -0.161603, -0.161263,
  -0.160904, -0.160525, -0.160126, -0.159707, -0.159269, -0.15881,
  -0.158332, -0.157834, -0.157317, -0.15678, -0.156223, -0.155647,
  -0.155051, -0.154436, -0.153802, -0.153149, -0.152476, -0.151784,
  -0.151073, -0.150343, -0.149594, -0.148826, -0.14804, -0.147235,
  -0.146411, -0.145568, -0.144707, -0.143828, -0.142931, -0.142015,
  -0.141082, -0.14013, -0.13916, -0.138173, -0.137168, -0.136146,
  -0.135106, -0.134049, -0.132974, -0.131883, -0.130774, -0.129649,
  -0.128507, -0.127348, -0.126173, -0.124982, -0.123774, -0.12255,
  -0.121311, -0.120055, -0.118784, -0.117497, -0.116196, -0.114878,
  -0.113546, -0.112199, -0.110837, -0.109461, -0.10807, -0.106665,
  -0.105246, -0.103813, -0.102366, -0.100905, -0.0994312, -0.0979439,
  -0.0964436, -0.0949304, -0.0934045, -0.091866, -0.0903151,
  -0.0887521, -0.087177, -0.0855902, -0.0839917, -0.0823818,
  -0.0807607, -0.0791285, -0.0774855, -0.0758319, -0.0741678,
  -0.0724934, -0.070809, -0.0691148, -0.0674109, -0.0656976,
  -0.0639751, -0.0622436, -0.0605033, -0.0587544, -0.0569972,
  -0.0552318, -0.0534584, -0.0516774, -0.0498888, -0.048093,
  -0.0462901, -0.0444804, -0.0426641, -0.0408415, -0.0390126,
  -0.0371779, -0.0353375, -0.0334916, -0.0316404, -0.0297843,
  -0.0279234, -0.026058, -0.0241883, -0.0223145, -0.0204369,
  -0.0185558, -0.0166712, -0.0147836, -0.0128932, -0.0110001,
  -0.00910458, -0.00720696, -0.00530745, -0.00340629, -0.00150373,
  0.0004, 0.00230464, 0.00420995, 0.00611569, 0.0080216, 0.00992744,
  0.011833, 0.0137379, 0.0156421, 0.0175451, 0.0194469, 0.0213471,
  0.0232455, 0.0251418, 0.0270359, 0.0289273, 0.030816, 0.0327016,
  0.0345839, 0.0364626, 0.0383376, 0.0402084, 0.042075, 0.043937,
  0.0457942, 0.0476464, 0.0494933, 0.0513346, 0.0531701, 0.0549996,
  0.0568228, 0.0586394, 0.0604493, 0.0622521, 0.0640477, 0.0658358,
  0.0676161, 0.0693884, 0.0711524, 0.0729079, 0.0746548, 0.0763926,
  0.0781213, 0.0798405, 0.08155, 0.0832496, 0.084939, 0.086618,
  0.0882864, 0.089944, 0.0915904, 0.0932255, 0.0948491, 0.0964609,
  0.0980606, 0.0996482, 0.101223, 0.102786, 0.104335, 0.105871,
  0.107394, 0.108904, 0.1104, 0.111881, 0.113349, 0.114802, 0.11624,
  0.117664, 0.119072, 0.120465, 0.121843, 0.123205, 0.124551,
  0.125881, 0.127195, 0.128493, 0.129774, 0.131038, 0.132284,
  0.133514, 0.134727, 0.135921, 0.137098, 0.138257, 0.139398,
  0.140521, 0.141625, 0.14271, 0.143777, 0.144824, 0.145853, 0.146862,
  0.147852, 0.148822, 0.149772, 0.150703, 0.151613, 0.152503,
  0.153373, 0.154222, 0.155051, 0.155859, 0.156646, 0.157412,
  0.158156, 0.15888, 0.159582, 0.160262, 0.160921, 0.161558, 0.162173,
  0.162766, 0.163336, 0.163885, 0.164411, 0.164915, 0.165397,
  0.165855, 0.166292, 0.166705, 0.167095, 0.167463, 0.167807,
  0.168128, 0.168427, 0.168702, 0.168953, 0.169181, 0.169386,
  0.169567, 0.169725, 0.169859, 0.16997, 0.170057, 0.17012, 0.170159,
  0.170174, 0.170166, 0.170134, 0.170078, 0.169998, 0.169894,
  0.169766, 0.169615, 0.169439, 0.169239, 0.169016, 0.168768,
  0.168497, 0.168201, 0.167882, 0.167538, 0.167171, 0.16678, 0.166365,
  0.165927, 0.165464, 0.164978, 0.164468, 0.163934, 0.163377,
  0.162796, 0.162192, 0.161564, 0.160913, 0.160238, 0.15954, 0.158819,
  0.158075, 0.157308, 0.156518, 0.155705, 0.154869, 0.154011,
  0.153129, 0.152226, 0.1513, 0.150351, 0.149381, 0.148388, 0.147373,
  0.146337, 0.145278, 0.144199, 0.143097, 0.141974, 0.14083, 0.139665,
  0.138479, 0.137273, 0.136045, 0.134797, 0.133529, 0.13224, 0.130932,
  0.129604, 0.128256, 0.126888, 0.125501, 0.124095, 0.12267, 0.121226,
  0.119763, 0.118282, 0.116783, 0.115265, 0.11373, 0.112177, 0.110607,
  0.109019, 0.107415, 0.105793, 0.104155, 0.102501, 0.10083,
  0.0991436, 0.0974413, 0.0957235, 0.0939904, 0.0922423, 0.0904794,
  0.088702, 0.0869102, 0.0851044, 0.0832847, 0.0814515, 0.079605,
  0.0777455, 0.0758731, 0.0739882, 0.072091, 0.0701818, 0.0682608,
  0.0663284, 0.0643848, 0.0624302, 0.060465, 0.0584894, 0.0565037,
  0.0545082, 0.0525031, 0.0504888, 0.0484656, 0.0464337, 0.0443934,
  0.042345, 0.0402889, 0.0382253, 0.0361544, 0.0340767, 0.0319924,
  0.0299019, 0.0278053, 0.0257031, 0.0235956, 0.0214829, 0.0193656,
  0.0172438, 0.015118, 0.0129883, 0.0108552, 0.00871887, 0.00657973,
  0.00443808, 0.00229424, 0.000148526, -0.00199874, -0.00414723,
  -0.00629662, -0.00844658, -0.0105968, -0.0127469, -0.0148966,
  -0.0170456, -0.0191935, -0.02134, -0.0234848, -0.0256275,
  -0.0277679, -0.0299055, -0.03204, -0.0341712, -0.0362986, -0.038422,
  -0.040541, -0.0426553, -0.0447645, -0.0468684, -0.0489665,
  -0.0510586, -0.0531443, -0.0552233, -0.0572952, -0.0593598,
  -0.0614166, -0.0634654, -0.0655059, -0.0675376, -0.0695603,
  -0.0715737, -0.0735773, -0.075571, -0.0775543, -0.079527,
  -0.0814886, -0.083439, -0.0853777, -0.0873045, -0.089219,
  -0.0911209, -0.0930099, -0.0948857, -0.0967479, -0.0985963,
  -0.10043, -0.10225, -0.104055, -0.105845, -0.107619, -0.109378,
  -0.111121, -0.112847, -0.114557, -0.11625, -0.117926, -0.119584,
  -0.121225, -0.122847, -0.124451, -0.126036, -0.127603, -0.12915,
  -0.130678, -0.132186, -0.133674, -0.135142, -0.136589, -0.138016,
  -0.139421, -0.140805, -0.142167, -0.143508, -0.144826, -0.146122,
  -0.147396, -0.148646, -0.149874, -0.151078, -0.152259, -0.153416,
  -0.154549, -0.155658, -0.156742, -0.157802, -0.158836, -0.159846,
  -0.160831, -0.16179, -0.162723, -0.16363, -0.164512, -0.165367,
  -0.166196, -0.166998, -0.167773, -0.168522, -0.169243, -0.169937,
  -0.170604, -0.171243, -0.171854, -0.172438, -0.172993, -0.17352,
  -0.174019, -0.17449, -0.174932, -0.175345, -0.17573, -0.176085,
  -0.176412, -0.176709, -0.176978, -0.177217, -0.177426, -0.177607,
  -0.177757, -0.177878, -0.177969, -0.178031, -0.178063, -0.178064,
  -0.178036, -0.177978, -0.17789, -0.177772, -0.177624, -0.177445,
  -0.177237, -0.176998, -0.17673, -0.176431, -0.176101, -0.175742,
  -0.175353, -0.174933, -0.174484, -0.174004, -0.173494, -0.172954,
  -0.172384, -0.171785, -0.171155, -0.170495, -0.169806, -0.169087,
  -0.168338, -0.16756, -0.166753, -0.165915, -0.165049, -0.164153,
  -0.163229, -0.162275, -0.161292, -0.160281, -0.159241, -0.158173,
  -0.157076, -0.155951, -0.154797, -0.153616, -0.152407, -0.151171,
  -0.149907, -0.148615, -0.147297, -0.145952, -0.144579, -0.143181,
  -0.141756, -0.140304, -0.138827, -0.137324, -0.135796, -0.134242,
  -0.132663, -0.13106, -0.129431, -0.127779, -0.126102, -0.124401,
  -0.122677, -0.120929, -0.119159, -0.117365, -0.115549, -0.113711,
  -0.111851, -0.109969, -0.108065, -0.106141, -0.104196, -0.10223,
  -0.100244, -0.0982384, -0.0962132, -0.0941688, -0.0921055,
  -0.0900237, -0.0879237, -0.0858058, -0.0836704, -0.0815179,
  -0.0793486, -0.0771629, -0.0749611, -0.0727436, -0.0705107,
  -0.0682629, -0.0660005, -0.063724, -0.0614336, -0.0591298,
  -0.056813, -0.0544835, -0.0521418, -0.0497883, -0.0474234,
  -0.0450475, -0.0426609, -0.0402642, -0.0378578, -0.035442,
  -0.0330173, -0.0305842, -0.028143, -0.0256942, -0.0232382,
  -0.0207754, -0.0183064, -0.0158316, -0.0133513, -0.0108661,
  -0.0083764, -0.00588265, -0.00338531, -0.000884837, 0.0016183,
  0.00412365, 0.00663074, 0.00913911, 0.0116483, 0.0141578, 0.0166672,
  0.019176, 0.0216838, 0.0241899, 0.0266941, 0.0291958, 0.0316945,
  0.0341897, 0.036681, 0.0391679, 0.0416499, 0.0441266, 0.0465973,
  0.0490618, 0.0515194, 0.0539697, 0.0564123, 0.0588466, 0.0612721,
  0.0636884, 0.066095, 0.0684914, 0.0708771, 0.0732517, 0.0756146,
  0.0779655, 0.0803037, 0.0826288, 0.0849404, 0.087238, 0.0895211,
  0.0917892, 0.0940419, 0.0962787, 0.0984991, 0.100703, 0.102889,
  0.105057, 0.107208, 0.109339, 0.111451, 0.113544, 0.115617,
  0.117669, 0.1197, 0.12171, 0.123698, 0.125664, 0.127607, 0.129526,
  0.131423, 0.133295, 0.135143, 0.136966, 0.138763, 0.140535,
  0.142281, 0.144, 0.145693, 0.147358, 0.148995, 0.150605, 0.152186,
  0.153738, 0.155261, 0.156754, 0.158217, 0.15965, 0.161052, 0.162424,
  0.163763, 0.165071, 0.166348, 0.167591, 0.168802, 0.16998, 0.171124,
  0.172235, 0.173312, 0.174355, 0.175363, 0.176336, 0.177274,
  0.178177, 0.179044, 0.179875, 0.18067, 0.181428, 0.18215, 0.182835,
  0.183483, 0.184093, 0.184666, 0.185201, 0.185698, 0.186157,
  0.186578, 0.18696, 0.187303, 0.187608, 0.187873, 0.188099, 0.188286,
  0.188434, 0.188542, 0.18861, 0.188638, 0.188627, 0.188576, 0.188484,
  0.188352, 0.18818, 0.187968, 0.187716, 0.187423, 0.187089, 0.186716,
  0.186301, 0.185847, 0.185351, 0.184816, 0.18424, 0.183623, 0.182966,
  0.182269, 0.181531, 0.180753, 0.179935, 0.179077, 0.178179,
  0.177241, 0.176263, 0.175245, 0.174188, 0.173091, 0.171955, 0.17078,
  0.169566, 0.168313, 0.167021, 0.165691, 0.164323, 0.162916,
  0.161472, 0.15999, 0.15847, 0.156914, 0.15532, 0.15369, 0.152023,
  0.150321, 0.148582, 0.146808, 0.144999, 0.143155, 0.141276,
  0.139363, 0.137416, 0.135435, 0.133422, 0.131375, 0.129296,
  0.127185, 0.125042, 0.122868, 0.120662, 0.118427, 0.116161,
  0.113866, 0.111542, 0.109189, 0.106807, 0.104398, 0.101962,
  0.0994988, 0.0970093, 0.0944941, 0.0919535, 0.0893881, 0.0867985,
  0.0841851, 0.0815486, 0.0788894, 0.0762082, 0.0735054, 0.0707817,
  0.0680377, 0.0652738, 0.0624908, 0.0596892, 0.0568697, 0.0540327,
  0.0511791, 0.0483093, 0.045424, 0.0425239, 0.0396096, 0.0366818,
  0.033741, 0.0307881, 0.0278235, 0.0248481, 0.0218625, 0.0188674,
  0.0158635, 0.0128514, 0.00983194, 0.00680573, 0.0037735,
  0.000735983, -0.00230611, -0.00535207, -0.00840114, -0.0114526,
  -0.0145058, -0.0175598, -0.020614, -0.0236677, -0.02672, -0.0297703,
  -0.0328178, -0.0358617, -0.0389012, -0.0419356, -0.0449642,
  -0.0479862, -0.0510007, -0.0540071, -0.0570045, -0.0599922,
  -0.0629695, -0.0659354, -0.0688894, -0.0718305, -0.074758,
  -0.0776712, -0.0805692, -0.0834514, -0.0863168, -0.0891648,
  -0.0919945, -0.0948052, -0.0975962, -0.100367, -0.103116, -0.105843,
  -0.108547, -0.111227, -0.113883, -0.116514, -0.119119, -0.121698,
  -0.124249, -0.126772, -0.129266, -0.131731, -0.134165, -0.136568,
  -0.138939, -0.141278, -0.143583, -0.145855, -0.148092, -0.150293,
  -0.152459, -0.154588, -0.156679, -0.158733, -0.160747, -0.162723,
  -0.164658, -0.166552, -0.168405, -0.170217, -0.171985, -0.173711,
  -0.175392, -0.17703, -0.178622, -0.180168, -0.181669, -0.183123,
  -0.184529, -0.185888, -0.187199, -0.18846, -0.189673, -0.190835,
  -0.191948, -0.193009, -0.194019, -0.194977, -0.195884, -0.196737,
  -0.197538, -0.198285, -0.198979, -0.199618, -0.200203, -0.200732,
  -0.201207, -0.201626, -0.201989, -0.202296, -0.202547, -0.202741,
  -0.202877, -0.202957, -0.202979, -0.202944, -0.20285, -0.202699,
  -0.20249, -0.202222, -0.201895, -0.20151, -0.201067, -0.200564,
  -0.200003, -0.199383, -0.198704, -0.197966, -0.197169, -0.196313,
  -0.195398, -0.194424, -0.193392, -0.192301, -0.191151, -0.189942,
  -0.188676, -0.187351, -0.185968, -0.184528, -0.183029, -0.181474,
  -0.179861, -0.178191, -0.176465, -0.174682, -0.172844, -0.17095,
  -0.169, -0.166996, -0.164937, -0.162824, -0.160658, -0.158438,
  -0.156165, -0.153841, -0.151464, -0.149036, -0.146558, -0.14403,
  -0.141451, -0.138825, -0.136149, -0.133426, -0.130656, -0.12784,
  -0.124978, -0.122071, -0.11912, -0.116126, -0.113089, -0.11001,
  -0.106889, -0.103729, -0.100529, -0.0972904, -0.0940141, -0.0907011,
  -0.0873521, -0.0839681, -0.0805501, -0.0770989, -0.0736157,
  -0.0701013, -0.0665569, -0.0629833, -0.0593816, -0.055753,
  -0.0520984, -0.048419, -0.0447158, -0.04099, -0.0372427, -0.033475,
  -0.0296882, -0.0258833, -0.0220616, -0.0182242, -0.0143724,
  -0.0105075, -0.00663051, -0.00274284, 0.00115428, 0.00505959,
  0.00897179, 0.0128896, 0.0168117, 0.0207368, 0.0246635, 0.0285906,
  0.0325167, 0.0364403, 0.0403603, 0.0442751, 0.0481835, 0.052084,
  0.0559752, 0.0598558, 0.0637244, 0.0675795, 0.0714197, 0.0752436,
  0.0790499, 0.082837, 0.0866035, 0.090348, 0.0940691, 0.0977654,
  0.101435, 0.105078, 0.108691, 0.112273, 0.115823, 0.11934, 0.122822,
  0.126268, 0.129676, 0.133044, 0.136372, 0.139658, 0.142901,
  0.146098, 0.14925, 0.152354, 0.155408, 0.158413, 0.161365, 0.164264,
  0.167109, 0.169898, 0.17263, 0.175304, 0.177917, 0.18047, 0.18296,
  0.185386, 0.187748, 0.190043, 0.192271, 0.194431, 0.19652, 0.198539,
  0.200486, 0.20236, 0.204159, 0.205883, 0.20753, 0.2091, 0.210591,
  0.212003, 0.213334, 0.214584, 0.215751, 0.216835, 0.217835,
  0.218749, 0.219578, 0.22032, 0.220974, 0.22154, 0.222017, 0.222405,
  0.222702, 0.222908, 0.223023, 0.223046, 0.222976, 0.222813,
  0.222556, 0.222206, 0.221761, 0.221221, 0.220587, 0.219857,
  0.219031, 0.21811, 0.217093, 0.21598, 0.214771, 0.213465, 0.212064,
  0.210566, 0.208973, 0.207283, 0.205498, 0.203617, 0.201641, 0.19957,
  0.197405, 0.195145, 0.192791, 0.190344, 0.187804, 0.185172,
  0.182449, 0.179634, 0.176729, 0.173735, 0.170652, 0.167481,
  0.164224, 0.16088, 0.157451, 0.153939, 0.150343, 0.146666, 0.142908,
  0.139072, 0.135157, 0.131165, 0.127099, 0.122958, 0.118745,
  0.114462, 0.110109, 0.105688, 0.101202, 0.0966519, 0.0920392,
  0.087366, 0.0826341, 0.0778454, 0.073002, 0.0681059, 0.0631591,
  0.0581638, 0.053122, 0.048036, 0.0429081, 0.0377405, 0.0325356,
  0.0272957, 0.0220234, 0.016721, 0.011391, 0.00603603, 0.00065867,
  -0.00473847, -0.0101527, -0.0155814, -0.0210217, -0.0264709,
  -0.0319261, -0.0373846, -0.0428434, -0.0482996, -0.0537503,
  -0.0591924, -0.0646231, -0.0700392, -0.0754377, -0.0808155,
  -0.0861695, -0.0914966, -0.0967935, -0.102057, -0.107284, -0.112472,
  -0.117617, -0.122715, -0.127764, -0.132761, -0.137701, -0.142582,
  -0.147401, -0.152154, -0.156838, -0.161449, -0.165985, -0.170442,
  -0.174816, -0.179105, -0.183305, -0.187413, -0.191426, -0.19534,
  -0.199152, -0.202859, -0.206459, -0.209947, -0.21332, -0.216576,
  -0.219712, -0.222724, -0.225609, -0.228365, -0.230989, -0.233477,
  -0.235827, -0.238037, -0.240103, -0.242022, -0.243793, -0.245413,
  -0.246878, -0.248188, -0.249339, -0.250329, -0.251156, -0.251818,
  -0.252313, -0.252638, -0.252793, -0.252774, -0.252582, -0.252213,
  -0.251667, -0.250941, -0.250036, -0.248949, -0.247679, -0.246226,
  -0.244589, -0.242767, -0.240759, -0.238564, -0.236184, -0.233617,
  -0.230862, -0.227922, -0.224794, -0.221481, -0.217981, -0.214297,
  -0.210428, -0.206376, -0.202141, -0.197726, -0.19313, -0.188357,
  -0.183407, -0.178283, -0.172986, -0.167519, -0.161885, -0.156085,
  -0.150123, -0.144002, -0.137725, -0.131294, -0.124714, -0.117989,
  -0.111122, -0.104117, -0.0969795, -0.0897127, -0.0823218,
  -0.0748116, -0.0671872, -0.059454, -0.0516174, -0.043683,
  -0.0356568, -0.0275448, -0.0193534, -0.0110889, -0.00275818,
  0.00563203, 0.0140746, 0.0225623, 0.0310876, 0.0396428, 0.0482202,
  0.0568117, 0.065409, 0.0740037, 0.0825873, 0.0911509, 0.0996857,
  0.108182, 0.116632, 0.125025, 0.133351, 0.141601, 0.149766,
  0.157834, 0.165796, 0.173642, 0.18136, 0.188941, 0.196374, 0.203648,
  0.210752, 0.217675, 0.224406, 0.230935, 0.23725, 0.24334, 0.249193,
  0.2548, 0.260147, 0.265225, 0.270022, 0.274526, 0.278728, 0.282615,
  0.286178, 0.289404, 0.292284, 0.294807, 0.296962, 0.298739,
  0.300129, 0.301122, 0.301707, 0.301876, 0.30162, 0.300929, 0.299797,
  0.298214, 0.296173, 0.293668, 0.290691, 0.287236, 0.283297, 0.27887,
  0.27395, 0.268533, 0.262616, 0.256196, 0.249271, 0.241841, 0.233904,
  0.225462, 0.216517, 0.207069, 0.197124, 0.186686, 0.175759,
  0.164352, 0.152471, 0.140126, 0.127327, 0.114086, 0.100416,
  0.0863327, 0.0718512, 0.0569896, 0.0417674, 0.0262058, 0.0103279,
  -0.00584152, -0.0222756, -0.0389456, -0.0558205, -0.0728673,
  -0.0900505, -0.107332, -0.124673, -0.14203, -0.159357, -0.176607,
  -0.19373, -0.210671, -0.227374, -0.24378, -0.259825, -0.275443,
  -0.290565, -0.305118, -0.319025, -0.332206, -0.344576, -0.356047,
  -0.366526, -0.375918, -0.38412, -0.391027, -0.396529, -0.400512,
  -0.402853, -0.40343, -0.402111, -0.39876, -0.393237, -0.385394,
  -0.375077, -0.362129, -0.346383, -0.327669, -0.305806, -0.280612,
  -0.251892, -0.219448, -0.183073, -0.142553, -0.0976654, -0.0481802,
  0.00614123, 0.0655456, 0.130289, 0.200635, 0.276858, 0.35924,
  0.448076, 0.543667, 0.646326, 0.756377, 0.874153, 1}; const G4double
  G4NeutronHPFastLegendre::i26[5401] = {0, 0.000346803, 0.000648502,
  0.000908021, 0.00112816, 0.0013116, 0.00146089, 0.00157848,
  0.00166672, 0.00172782, 0.00176391, 0.00177702, 0.00176907,
  0.00174192, 0.00169729, 0.00163685, 0.00156218, 0.00147478,
  0.00137605, 0.00126734, 0.00114993, 0.00102501, 0.000893711,
  0.000757105, 0.000616196, 0.000471929, 0.000325191, 0.000176815,
  2.75783e-05, -0.000121792, -0.000270617, -0.000418268, -0.000564158,
  -0.000707747, -0.000848534, -0.00098606, -0.0011199, -0.00124968,
  -0.00137503, -0.00149566, -0.00161126, -0.00172159, -0.00182643,
  -0.00192556, -0.00201884, -0.0021061, -0.00218723, -0.00226212,
  -0.00233071, -0.00239293, -0.00244874, -0.00249813, -0.00254109,
  -0.00257764, -0.00260781, -0.00263164, -0.00264918, -0.00266051,
  -0.00266571, -0.00266487, -0.00265809, -0.00264549, -0.0026272,
  -0.00260332, -0.00257402, -0.00253942, -0.00249969, -0.00245497,
  -0.00240542, -0.00235122, -0.00229254, -0.00222954, -0.00216241,
  -0.00209131, -0.00201645, -0.00193799, -0.00185613, -0.00177104,
  -0.00168292, -0.00159196, -0.00149834, -0.00140225, -0.00130387,
  -0.0012034, -0.00110101, -0.000996885, -0.000891215, -0.000784176,
  -0.000675947, -0.000566702, -0.000456615, -0.000345858,
  -0.000234598, -0.000123001, -1.12293e-05, 0.000100559, 0.000212207,
  0.000323562, 0.000434476, 0.000544804, 0.000654402, 0.000763134,
  0.000870865, 0.000977465, 0.00108281, 0.00118677, 0.00128923,
  0.00139009, 0.00148922, 0.00158652, 0.00168188, 0.00177522,
  0.00186644, 0.00195545, 0.00204216, 0.00212648, 0.00220836,
  0.0022877, 0.00236445, 0.00243853, 0.00250989, 0.00257847,
  0.00264421, 0.00270708, 0.00276701, 0.00282398, 0.00287794,
  0.00292886, 0.00297671, 0.00302146, 0.00306309, 0.00310159,
  0.00313693, 0.00316911, 0.0031981, 0.00322392, 0.00324656,
  0.00326601, 0.00328228, 0.00329537, 0.00330531, 0.00331209,
  0.00331574, 0.00331627, 0.0033137, 0.00330806, 0.00329938,
  0.00328767, 0.00327297, 0.00325532, 0.00323475, 0.00321129,
  0.00318499, 0.00315589, 0.00312403, 0.00308945, 0.00305221,
  0.00301235, 0.00296991, 0.00292496, 0.00287755, 0.00282773,
  0.00277555, 0.00272108, 0.00266437, 0.00260548, 0.00254447,
  0.00248141, 0.00241636, 0.00234937, 0.00228052, 0.00220987,
  0.00213748, 0.00206343, 0.00198777, 0.00191058, 0.00183192,
  0.00175186, 0.00167047, 0.00158782, 0.00150398, 0.00141902,
  0.001333, 0.00124599, 0.00115807, 0.0010693, 0.00097975,
  0.000889493, 0.000798596, 0.000707126, 0.000615152, 0.000522741,
  0.000429962, 0.000336881, 0.000243564, 0.000150078, 5.6488e-05,
  -3.71411e-05, -0.000130745, -0.00022426, -0.000317623, -0.000410771,
  -0.000503644, -0.00059618, -0.00068832, -0.000780004, -0.000871174,
  -0.000961772, -0.00105174, -0.00114103, -0.00122958, -0.00131734,
  -0.00140425, -0.00149027, -0.00157534, -0.00165941, -0.00174244,
  -0.00182437, -0.00190517, -0.00198479, -0.00206317, -0.00214029,
  -0.00221609, -0.00229054, -0.0023636, -0.00243523, -0.00250538,
  -0.00257404, -0.00264115, -0.0027067, -0.00277064, -0.00283294,
  -0.00289358, -0.00295252, -0.00300975, -0.00306522, -0.00311892,
  -0.00317083, -0.00322092, -0.00326916, -0.00331555, -0.00336006,
  -0.00340267, -0.00344337, -0.00348213, -0.00351896, -0.00355383,
  -0.00358673, -0.00361766, -0.00364659, -0.00367353, -0.00369847,
  -0.0037214, -0.00374232, -0.00376121, -0.00377809, -0.00379295,
  -0.00380578, -0.0038166, -0.00382539, -0.00383217, -0.00383694,
  -0.00383969, -0.00384045, -0.00383921, -0.00383598, -0.00383077,
  -0.0038236, -0.00381446, -0.00380338, -0.00379037, -0.00377543,
  -0.00375859, -0.00373985, -0.00371924, -0.00369678, -0.00367247,
  -0.00364633, -0.0036184, -0.00358868, -0.00355719, -0.00352397,
  -0.00348902, -0.00345238, -0.00341407, -0.0033741, -0.00333251,
  -0.00328932, -0.00324456, -0.00319825, -0.00315042, -0.0031011,
  -0.00305032, -0.0029981, -0.00294447, -0.00288946, -0.00283311,
  -0.00277545, -0.00271649, -0.00265629, -0.00259486, -0.00253224,
  -0.00246846, -0.00240355, -0.00233756, -0.0022705, -0.00220242,
  -0.00213335, -0.00206332, -0.00199236, -0.00192052, -0.00184782,
  -0.00177431, -0.00170001, -0.00162495, -0.00154919, -0.00147275,
  -0.00139566, -0.00131796, -0.0012397, -0.00116089, -0.00108158,
  -0.00100181, -0.000921611, -0.000841015, -0.00076006, -0.000678781,
  -0.000597215, -0.000515395, -0.000433359, -0.00035114, -0.000268773,
  -0.000186295, -0.000103738, -2.11387e-05, 6.14695e-05, 0.000144052,
  0.000226576, 0.000309006, 0.000391309, 0.000473452, 0.000555402,
  0.000637126, 0.000718591, 0.000799765, 0.000880617, 0.000961114,
  0.00104123, 0.00112092, 0.00120017, 0.00127894, 0.0013572,
  0.00143492, 0.00151208, 0.00158864, 0.00166457, 0.00173986,
  0.00181446, 0.00188835, 0.00196152, 0.00203392, 0.00210553,
  0.00217633, 0.00224629, 0.0023154, 0.00238361, 0.00245091,
  0.00251728, 0.0025827, 0.00264713, 0.00271056, 0.00277297,
  0.00283434, 0.00289465, 0.00295387, 0.00301198, 0.00306898,
  0.00312483, 0.00317953, 0.00323305, 0.00328537, 0.00333649,
  0.00338638, 0.00343504, 0.00348244, 0.00352856, 0.00357341,
  0.00361696, 0.0036592, 0.00370012, 0.00373971, 0.00377795,
  0.00381484, 0.00385037, 0.00388452, 0.00391729, 0.00394867,
  0.00397865, 0.00400722, 0.00403438, 0.00406012, 0.00408444,
  0.00410733, 0.00412878, 0.00414879, 0.00416736, 0.00418448,
  0.00420015, 0.00421437, 0.00422714, 0.00423846, 0.00424832,
  0.00425673, 0.00426368, 0.00426918, 0.00427323, 0.00427583,
  0.00427698, 0.00427669, 0.00427495, 0.00427177, 0.00426717,
  0.00426113, 0.00425367, 0.00424479, 0.0042345, 0.0042228, 0.0042097,
  0.00419522, 0.00417934, 0.0041621, 0.00414348, 0.00412351,
  0.00410219, 0.00407952, 0.00405554, 0.00403023, 0.00400361,
  0.0039757, 0.00394651, 0.00391604, 0.00388431, 0.00385134,
  0.00381713, 0.0037817, 0.00374507, 0.00370724, 0.00366824,
  0.00362807, 0.00358675, 0.0035443, 0.00350074, 0.00345607,
  0.00341032, 0.0033635, 0.00331563, 0.00326672, 0.0032168,
  0.00316588, 0.00311397, 0.00306111, 0.00300729, 0.00295255,
  0.0028969, 0.00284036, 0.00278295, 0.00272469, 0.0026656,
  0.00260569, 0.00254499, 0.00248352, 0.0024213, 0.00235834,
  0.00229467, 0.00223032, 0.00216529, 0.00209961, 0.0020333,
  0.00196638, 0.00189888, 0.00183081, 0.0017622, 0.00169307,
  0.00162343, 0.00155331, 0.00148274, 0.00141173, 0.0013403,
  0.00126848, 0.00119629, 0.00112375, 0.00105088, 0.000977707,
  0.000904248, 0.000830526, 0.000756564, 0.000682383, 0.000608005,
  0.000533452, 0.000458745, 0.000383907, 0.000308958, 0.000233922,
  0.000158818, 8.36692e-05, 8.49639e-06, -6.66788e-05, -0.000141835,
  -0.000216951, -0.000292006, -0.000366979, -0.000441849,
  -0.000516594, -0.000591195, -0.00066563, -0.000739878, -0.000813921,
  -0.000887737, -0.000961306, -0.00103461, -0.00110762, -0.00118033,
  -0.00125272, -0.00132475, -0.00139643, -0.00146772, -0.00153861,
  -0.00160907, -0.0016791, -0.00174867, -0.00181776, -0.00188635,
  -0.00195444, -0.002022, -0.002089, -0.00215545, -0.00222131,
  -0.00228658, -0.00235123, -0.00241524, -0.00247862, -0.00254133,
  -0.00260336, -0.00266469, -0.00272532, -0.00278522, -0.00284439,
  -0.0029028, -0.00296044, -0.0030173, -0.00307337, -0.00312863,
  -0.00318306, -0.00323666, -0.00328942, -0.00334131, -0.00339233,
  -0.00344247, -0.00349171, -0.00354004, -0.00358746, -0.00363394,
  -0.00367949, -0.00372409, -0.00376772, -0.00381039, -0.00385208,
  -0.00389278, -0.00393248, -0.00397118, -0.00400886, -0.00404552,
  -0.00408115, -0.00411574, -0.00414929, -0.00418179, -0.00421323,
  -0.0042436, -0.00427291, -0.00430114, -0.00432828, -0.00435434,
  -0.00437931, -0.00440318, -0.00442595, -0.00444762, -0.00446818,
  -0.00448762, -0.00450595, -0.00452317, -0.00453926, -0.00455423,
  -0.00456808, -0.00458079, -0.00459238, -0.00460285, -0.00461218,
  -0.00462038, -0.00462745, -0.00463338, -0.00463819, -0.00464187,
  -0.00464442, -0.00464583, -0.00464612, -0.00464529, -0.00464333,
  -0.00464025, -0.00463605, -0.00463073, -0.0046243, -0.00461675,
  -0.0046081, -0.00459835, -0.0045875, -0.00457555, -0.0045625,
  -0.00454838, -0.00453316, -0.00451688, -0.00449952, -0.00448109,
  -0.00446161, -0.00444107, -0.00441949, -0.00439686, -0.0043732,
  -0.00434851, -0.0043228, -0.00429608, -0.00426836, -0.00423964,
  -0.00420992, -0.00417923, -0.00414757, -0.00411494, -0.00408136,
  -0.00404683, -0.00401136, -0.00397497, -0.00393767, -0.00389945,
  -0.00386034, -0.00382034, -0.00377946, -0.00373772, -0.00369512,
  -0.00365167, -0.0036074, -0.0035623, -0.00351639, -0.00346968,
  -0.00342218, -0.00337391, -0.00332487, -0.00327508, -0.00322455,
  -0.0031733, -0.00312132, -0.00306865, -0.00301529, -0.00296125,
  -0.00290655, -0.00285119, -0.0027952, -0.00273859, -0.00268136,
  -0.00262354, -0.00256513, -0.00250616, -0.00244663, -0.00238655,
  -0.00232595, -0.00226484, -0.00220322, -0.00214112, -0.00207855,
  -0.00201552, -0.00195205, -0.00188815, -0.00182384, -0.00175913,
  -0.00169404, -0.00162857, -0.00156275, -0.00149659, -0.00143011,
  -0.00136331, -0.00129622, -0.00122885, -0.00116121, -0.00109332,
  -0.0010252, -0.000956855, -0.000888304, -0.000819562, -0.000750645,
  -0.000681566, -0.000612342, -0.000542986, -0.000473515,
  -0.000403942, -0.000334284, -0.000264554, -0.000194769,
  -0.000124941, -5.50878e-05, 1.47774e-05, 8.46395e-05, 0.000154484,
  0.000224295, 0.00029406, 0.000363762, 0.000433388, 0.000502922,
  0.000572352, 0.000641661, 0.000710836, 0.000779862, 0.000848725,
  0.000917412, 0.000985907, 0.0010542, 0.00112227, 0.00119011,
  0.0012577, 0.00132503, 0.00139208, 0.00145885, 0.00152532,
  0.00159147, 0.0016573, 0.00172278, 0.00178791, 0.00185268,
  0.00191706, 0.00198105, 0.00204464, 0.00210781, 0.00217055,
  0.00223284, 0.00229468, 0.00235606, 0.00241695, 0.00247736,
  0.00253726, 0.00259665, 0.00265552, 0.00271385, 0.00277163,
  0.00282885, 0.00288551, 0.00294158, 0.00299706, 0.00305194,
  0.00310621, 0.00315986, 0.00321288, 0.00326525, 0.00331697,
  0.00336804, 0.00341843, 0.00346814, 0.00351716, 0.00356549,
  0.0036131, 0.00366001, 0.00370618, 0.00375163, 0.00379634,
  0.0038403, 0.0038835, 0.00392594, 0.0039676, 0.00400849, 0.00404859,
  0.0040879, 0.00412641, 0.00416411, 0.004201, 0.00423707, 0.00427232,
  0.00430673, 0.00434031, 0.00437304, 0.00440493, 0.00443596,
  0.00446613, 0.00449544, 0.00452388, 0.00455145, 0.00457814,
  0.00460395, 0.00462887, 0.00465291, 0.00467605, 0.00469829,
  0.00471964, 0.00474008, 0.00475962, 0.00477824, 0.00479596,
  0.00481276, 0.00482864, 0.00484361, 0.00485765, 0.00487078,
  0.00488298, 0.00489426, 0.00490461, 0.00491403, 0.00492252,
  0.00493009, 0.00493673, 0.00494244, 0.00494722, 0.00495107,
  0.00495399, 0.00495598, 0.00495704, 0.00495718, 0.00495639,
  0.00495467, 0.00495203, 0.00494846, 0.00494398, 0.00493858,
  0.00493225, 0.00492502, 0.00491687, 0.0049078, 0.00489783,
  0.00488696, 0.00487518, 0.0048625, 0.00484893, 0.00483446,
  0.0048191, 0.00480286, 0.00478574, 0.00476773, 0.00474886,
  0.00472911, 0.0047085, 0.00468703, 0.0046647, 0.00464152, 0.0046175,
  0.00459264, 0.00456694, 0.00454041, 0.00451305, 0.00448488,
  0.0044559, 0.00442611, 0.00439552, 0.00436413, 0.00433196,
  0.00429901, 0.00426528, 0.00423078, 0.00419553, 0.00415952,
  0.00412276, 0.00408526, 0.00404704, 0.00400808, 0.00396842,
  0.00392804, 0.00388696, 0.00384519, 0.00380273, 0.0037596,
  0.0037158, 0.00367134, 0.00362622, 0.00358047, 0.00353408,
  0.00348706, 0.00343943, 0.00339119, 0.00334235, 0.00329292,
  0.00324292, 0.00319234, 0.0031412, 0.0030895, 0.00303727, 0.0029845,
  0.00293121, 0.00287741, 0.0028231, 0.00276831, 0.00271302,
  0.00265727, 0.00260105, 0.00254438, 0.00248726, 0.00242971,
  0.00237175, 0.00231337, 0.00225458, 0.00219541, 0.00213586,
  0.00207594, 0.00201566, 0.00195503, 0.00189407, 0.00183278,
  0.00177117, 0.00170926, 0.00164706, 0.00158457, 0.00152181,
  0.00145879, 0.00139552, 0.00133201, 0.00126828, 0.00120433,
  0.00114017, 0.00107581, 0.00101128, 0.000946571, 0.000881702,
  0.000816684, 0.000751527, 0.000686242, 0.000620841, 0.000555335,
  0.000489735, 0.000424052, 0.000358297, 0.000292482, 0.000226618,
  0.000160716, 9.47861e-05, 2.88406e-05, -3.71098e-05, -0.000103054,
  -0.000168981, -0.00023488, -0.000300739, -0.000366548, -0.000432296,
  -0.000497971, -0.000563564, -0.000629062, -0.000694456,
  -0.000759734, -0.000824886, -0.000889901, -0.000954768, -0.00101948,
  -0.00108402, -0.00114838, -0.00121255, -0.00127652, -0.00134027,
  -0.00140381, -0.00146712, -0.00153018, -0.00159299, -0.00165554,
  -0.00171782, -0.00177982, -0.00184152, -0.00190292, -0.00196401,
  -0.00202478, -0.00208522, -0.00214531, -0.00220506, -0.00226444,
  -0.00232346, -0.0023821, -0.00244035, -0.0024982, -0.00255564,
  -0.00261268, -0.00266928, -0.00272546, -0.00278119, -0.00283647,
  -0.0028913, -0.00294565, -0.00299953, -0.00305293, -0.00310583,
  -0.00315823, -0.00321013, -0.00326151, -0.00331236, -0.00336268,
  -0.00341246, -0.0034617, -0.00351038, -0.00355849, -0.00360604,
  -0.00365301, -0.0036994, -0.00374519, -0.00379039, -0.00383499,
  -0.00387897, -0.00392234, -0.00396508, -0.00400719, -0.00404867,
  -0.0040895, -0.00412969, -0.00416922, -0.00420809, -0.0042463,
  -0.00428383, -0.00432069, -0.00435686, -0.00439235, -0.00442715,
  -0.00446124, -0.00449464, -0.00452733, -0.00455931, -0.00459057,
  -0.00462111, -0.00465093, -0.00468002, -0.00470838, -0.004736,
  -0.00476288, -0.00478902, -0.0048144, -0.00483904, -0.00486293,
  -0.00488605, -0.00490842, -0.00493002, -0.00495086, -0.00497093,
  -0.00499022, -0.00500875, -0.0050265, -0.00504346, -0.00505965,
  -0.00507506, -0.00508968, -0.00510352, -0.00511657, -0.00512883,
  -0.0051403, -0.00515098, -0.00516087, -0.00516997, -0.00517827,
  -0.00518577, -0.00519249, -0.0051984, -0.00520352, -0.00520784,
  -0.00521137, -0.0052141, -0.00521603, -0.00521717, -0.00521751,
  -0.00521706, -0.00521582, -0.00521377, -0.00521094, -0.00520732,
  -0.0052029, -0.0051977, -0.0051917, -0.00518492, -0.00517736,
  -0.00516901, -0.00515988, -0.00514997, -0.00513929, -0.00512782,
  -0.00511559, -0.00510258, -0.00508881, -0.00507427, -0.00505897,
  -0.0050429, -0.00502608, -0.00500851, -0.00499018, -0.00497111,
  -0.00495129, -0.00493073, -0.00490944, -0.00488741, -0.00486465,
  -0.00484117, -0.00481696, -0.00479204, -0.0047664, -0.00474005,
  -0.004713, -0.00468525, -0.0046568, -0.00462766, -0.00459783,
  -0.00456733, -0.00453614, -0.00450429, -0.00447177, -0.00443858,
  -0.00440475, -0.00437026, -0.00433513, -0.00429935, -0.00426295,
  -0.00422592, -0.00418826, -0.00414999, -0.00411111, -0.00407163,
  -0.00403155, -0.00399088, -0.00394962, -0.00390778, -0.00386538,
  -0.0038224, -0.00377887, -0.00373479, -0.00369016, -0.00364499,
  -0.0035993, -0.00355307, -0.00350634, -0.00345909, -0.00341133,
  -0.00336309, -0.00331435, -0.00326513, -0.00321544, -0.00316529,
  -0.00311467, -0.0030636, -0.0030121, -0.00296015, -0.00290778,
  -0.00285499, -0.00280178, -0.00274818, -0.00269417, -0.00263978,
  -0.00258501, -0.00252987, -0.00247436, -0.0024185, -0.00236229,
  -0.00230574, -0.00224886, -0.00219166, -0.00213415, -0.00207633,
  -0.00201821, -0.00195981, -0.00190112, -0.00184217, -0.00178295,
  -0.00172347, -0.00166375, -0.0016038, -0.00154362, -0.00148321,
  -0.0014226, -0.00136178, -0.00130077, -0.00123958, -0.00117821,
  -0.00111667, -0.00105498, -0.000993136, -0.000931151, -0.000869036,
  -0.000806798, -0.000744445, -0.000681988, -0.000619435,
  -0.000556794, -0.000494075, -0.000431287, -0.000368438,
  -0.000305537, -0.000242593, -0.000179615, -0.000116612,
  -5.35931e-05, 9.43368e-06, 7.24591e-05, 0.000135474, 0.000198471,
  0.000261439, 0.000324371, 0.000387258, 0.000450091, 0.000512861,
  0.000575559, 0.000638177, 0.000700707, 0.000763139, 0.000825464,
  0.000887675, 0.000949763, 0.00101172, 0.00107353, 0.0011352,
  0.00119671, 0.00125805, 0.00131922, 0.00138021, 0.00144101,
  0.0015016, 0.00156199, 0.00162217, 0.00168212, 0.00174184,
  0.00180132, 0.00186055, 0.00191952, 0.00197823, 0.00203667,
  0.00209483, 0.00215271, 0.00221028, 0.00226756, 0.00232452,
  0.00238116, 0.00243748, 0.00249347, 0.00254911, 0.00260441,
  0.00265935, 0.00271392, 0.00276813, 0.00282196, 0.00287541,
  0.00292846, 0.00298112, 0.00303336, 0.0030852, 0.00313662,
  0.00318761, 0.00323817, 0.00328829, 0.00333797, 0.00338719,
  0.00343595, 0.00348425, 0.00353208, 0.00357943, 0.0036263,
  0.00367267, 0.00371856, 0.00376394, 0.00380881, 0.00385317,
  0.00389701, 0.00394032, 0.00398311, 0.00402536, 0.00406707,
  0.00410823, 0.00414885, 0.0041889, 0.0042284, 0.00426732,
  0.00430568, 0.00434346, 0.00438066, 0.00441727, 0.00445329,
  0.00448872, 0.00452355, 0.00455778, 0.00459139, 0.0046244,
  0.00465679, 0.00468856, 0.00471971, 0.00475023, 0.00478011,
  0.00480937, 0.00483798, 0.00486595, 0.00489328, 0.00491996,
  0.00494598, 0.00497135, 0.00499607, 0.00502012, 0.00504351,
  0.00506623, 0.00508829, 0.00510967, 0.00513038, 0.00515041,
  0.00516976, 0.00518843, 0.00520642, 0.00522373, 0.00524034,
  0.00525627, 0.00527151, 0.00528605, 0.00529991, 0.00531306,
  0.00532552, 0.00533729, 0.00534835, 0.00535871, 0.00536838,
  0.00537734, 0.00538559, 0.00539315, 0.0054, 0.00540615, 0.00541159,
  0.00541632, 0.00542035, 0.00542368, 0.00542629, 0.00542821,
  0.00542941, 0.00542991, 0.00542971, 0.0054288, 0.00542719,
  0.00542487, 0.00542185, 0.00541812, 0.0054137, 0.00540857,
  0.00540275, 0.00539622, 0.005389, 0.00538109, 0.00537248,
  0.00536317, 0.00535317, 0.00534249, 0.00533111, 0.00531905,
  0.0053063, 0.00529287, 0.00527877, 0.00526398, 0.00524851,
  0.00523237, 0.00521557, 0.00519809, 0.00517994, 0.00516113,
  0.00514166, 0.00512153, 0.00510075, 0.00507932, 0.00505723,
  0.0050345, 0.00501113, 0.00498711, 0.00496246, 0.00493718,
  0.00491127, 0.00488473, 0.00485757, 0.00482979, 0.0048014,
  0.0047724, 0.00474279, 0.00471257, 0.00468176, 0.00465036,
  0.00461837, 0.00458579, 0.00455262, 0.00451889, 0.00448458,
  0.0044497, 0.00441426, 0.00437826, 0.00434171, 0.00430461,
  0.00426697, 0.00422879, 0.00419007, 0.00415083, 0.00411106,
  0.00407078, 0.00402998, 0.00398868, 0.00394687, 0.00390457,
  0.00386178, 0.0038185, 0.00377475, 0.00373052, 0.00368582,
  0.00364066, 0.00359504, 0.00354898, 0.00350246, 0.00345552,
  0.00340814, 0.00336033, 0.0033121, 0.00326346, 0.00321441,
  0.00316496, 0.00311512, 0.00306489, 0.00301427, 0.00296328,
  0.00291192, 0.0028602, 0.00280813, 0.0027557, 0.00270293,
  0.00264983, 0.00259639, 0.00254264, 0.00248857, 0.00243419,
  0.00237951, 0.00232453, 0.00226927, 0.00221372, 0.00215791,
  0.00210182, 0.00204548, 0.00198888, 0.00193203, 0.00187495,
  0.00181764, 0.0017601, 0.00170235, 0.00164438, 0.00158622,
  0.00152786, 0.00146931, 0.00141057, 0.00135167, 0.0012926,
  0.00123337, 0.00117399, 0.00111447, 0.0010548, 0.000995014,
  0.000935101, 0.000875074, 0.00081494, 0.000754706, 0.000694379,
  0.000633968, 0.000573479, 0.00051292, 0.000452298, 0.000391621,
  0.000330896, 0.000270131, 0.000209333, 0.000148509, 8.76676e-05,
  2.68152e-05, -3.40405e-05, -9.48921e-05, -0.000155732, -0.000216553,
  -0.000277348, -0.000338109, -0.000398829, -0.000459501,
  -0.000520117, -0.00058067, -0.000641153, -0.000701558, -0.000761878,
  -0.000822106, -0.000882234, -0.000942256, -0.00100216, -0.00106195,
  -0.00112161, -0.00118113, -0.00124051, -0.00129974, -0.00135882,
  -0.00141773, -0.00147647, -0.00153503, -0.0015934, -0.00165159,
  -0.00170958, -0.00176736, -0.00182493, -0.00188227, -0.0019394,
  -0.00199629, -0.00205294, -0.00210934, -0.0021655, -0.00222139,
  -0.00227701, -0.00233237, -0.00238744, -0.00244223, -0.00249673,
  -0.00255092, -0.00260482, -0.0026584, -0.00271166, -0.00276461,
  -0.00281722, -0.00286949, -0.00292142, -0.00297301, -0.00302424,
  -0.00307511, -0.00312561, -0.00317575, -0.0032255, -0.00327487,
  -0.00332386, -0.00337244, -0.00342063, -0.00346841, -0.00351578,
  -0.00356273, -0.00360926, -0.00365537, -0.00370104, -0.00374627,
  -0.00379105, -0.00383539, -0.00387928, -0.00392271, -0.00396567,
  -0.00400816, -0.00405019, -0.00409173, -0.00413279, -0.00417336,
  -0.00421344, -0.00425303, -0.00429211, -0.00433069, -0.00436876,
  -0.00440631, -0.00444335, -0.00447986, -0.00451585, -0.0045513,
  -0.00458623, -0.00462061, -0.00465445, -0.00468774, -0.00472049,
  -0.00475268, -0.00478432, -0.00481539, -0.0048459, -0.00487584,
  -0.00490522, -0.00493401, -0.00496224, -0.00498988, -0.00501694,
  -0.00504341, -0.0050693, -0.00509459, -0.00511929, -0.00514339,
  -0.00516689, -0.00518979, -0.00521209, -0.00523377, -0.00525485,
  -0.00527532, -0.00529518, -0.00531442, -0.00533304, -0.00535104,
  -0.00536842, -0.00538518, -0.00540131, -0.00541681, -0.00543169,
  -0.00544594, -0.00545956, -0.00547254, -0.00548489, -0.00549661,
  -0.00550769, -0.00551813, -0.00552793, -0.0055371, -0.00554562,
  -0.00555351, -0.00556075, -0.00556736, -0.00557332, -0.00557863,
  -0.00558331, -0.00558734, -0.00559073, -0.00559347, -0.00559557,
  -0.00559702, -0.00559783, -0.005598, -0.00559753, -0.00559641,
  -0.00559464, -0.00559224, -0.00558919, -0.0055855, -0.00558118,
  -0.00557621, -0.0055706, -0.00556435, -0.00555747, -0.00554995,
  -0.00554179, -0.005533, -0.00552358, -0.00551353, -0.00550284,
  -0.00549153, -0.00547959, -0.00546702, -0.00545383, -0.00544002,
  -0.00542558, -0.00541053, -0.00539486, -0.00537858, -0.00536168,
  -0.00534418, -0.00532606, -0.00530734, -0.00528801, -0.00526809,
  -0.00524756, -0.00522644, -0.00520472, -0.00518242, -0.00515952,
  -0.00513604, -0.00511198, -0.00508734, -0.00506212, -0.00503632,
  -0.00500996, -0.00498303, -0.00495553, -0.00492747, -0.00489886,
  -0.00486969, -0.00483997, -0.00480971, -0.0047789, -0.00474755,
  -0.00471566, -0.00468325, -0.0046503, -0.00461683, -0.00458284,
  -0.00454833, -0.00451331, -0.00447778, -0.00444175, -0.00440521,
  -0.00436818, -0.00433066, -0.00429266, -0.00425417, -0.0042152,
  -0.00417576, -0.00413585, -0.00409547, -0.00405463, -0.00401334,
  -0.0039716, -0.00392942, -0.00388679, -0.00384373, -0.00380024,
  -0.00375632, -0.00371198, -0.00366723, -0.00362206, -0.00357649,
  -0.00353053, -0.00348416, -0.00343741, -0.00339027, -0.00334276,
  -0.00329487, -0.00324661, -0.00319799, -0.00314901, -0.00309969,
  -0.00305002, -0.003, -0.00294966, -0.00289898, -0.00284799,
  -0.00279667, -0.00274505, -0.00269312, -0.00264089, -0.00258836,
  -0.00253555, -0.00248246, -0.00242909, -0.00237545, -0.00232155,
  -0.00226739, -0.00221298, -0.00215832, -0.00210343, -0.0020483,
  -0.00199294, -0.00193737, -0.00188158, -0.00182558, -0.00176938,
  -0.00171298, -0.0016564, -0.00159963, -0.00154268, -0.00148557,
  -0.00142829, -0.00137085, -0.00131326, -0.00125553, -0.00119765,
  -0.00113965, -0.00108152, -0.00102327, -0.00096491, -0.000906442,
  -0.000847875, -0.000789214, -0.000730466, -0.000671638,
  -0.000612736, -0.000553766, -0.000494736, -0.000435651,
  -0.000376519, -0.000317345, -0.000258137, -0.0001989, -0.000139641,
  -8.03672e-05, -2.10844e-05, 3.82006e-05, 9.74815e-05, 0.000156752,
  0.000216005, 0.000275234, 0.000334433, 0.000393596, 0.000452715,
  0.000511785, 0.000570799, 0.000629751, 0.000688634, 0.000747442,
  0.000806167, 0.000864805, 0.000923349, 0.000981792, 0.00104013,
  0.00109835, 0.00115645, 0.00121443, 0.00127227, 0.00132998,
  0.00138754, 0.00144495, 0.0015022, 0.00155929, 0.00161621,
  0.00167295, 0.00172952, 0.00178589, 0.00184207, 0.00189805,
  0.00195382, 0.00200938, 0.00206473, 0.00211985, 0.00217474,
  0.00222939, 0.0022838, 0.00233797, 0.00239188, 0.00244553,
  0.00249892, 0.00255204, 0.00260488, 0.00265744, 0.00270971,
  0.00276169, 0.00281337, 0.00286474, 0.00291581, 0.00296656,
  0.00301699, 0.0030671, 0.00311687, 0.00316631, 0.00321541,
  0.00326416, 0.00331256, 0.0033606, 0.00340828, 0.00345559,
  0.00350253, 0.00354909, 0.00359527, 0.00364107, 0.00368647,
  0.00373147, 0.00377608, 0.00382028, 0.00386407, 0.00390744,
  0.00395039, 0.00399292, 0.00403502, 0.00407669, 0.00411792,
  0.00415871, 0.00419905, 0.00423894, 0.00427838, 0.00431736,
  0.00435588, 0.00439393, 0.00443151, 0.00446862, 0.00450525,
  0.00454139, 0.00457705, 0.00461222, 0.0046469, 0.00468108,
  0.00471477, 0.00474794, 0.00478061, 0.00481277, 0.00484442,
  0.00487555, 0.00490616, 0.00493625, 0.00496581, 0.00499484,
  0.00502334, 0.0050513, 0.00507873, 0.00510561, 0.00513195,
  0.00515775, 0.005183, 0.00520769, 0.00523183, 0.00525542,
  0.00527844, 0.00530091, 0.00532281, 0.00534415, 0.00536492,
  0.00538512, 0.00540474, 0.0054238, 0.00544228, 0.00546018,
  0.0054775, 0.00549425, 0.00551041, 0.00552598, 0.00554098,
  0.00555538, 0.0055692, 0.00558242, 0.00559506, 0.0056071,
  0.00561855, 0.00562941, 0.00563967, 0.00564934, 0.00565841,
  0.00566688, 0.00567475, 0.00568202, 0.0056887, 0.00569477,
  0.00570024, 0.00570511, 0.00570938, 0.00571305, 0.00571612,
  0.00571858, 0.00572044, 0.0057217, 0.00572235, 0.0057224,
  0.00572185, 0.0057207, 0.00571895, 0.00571659, 0.00571363,
  0.00571008, 0.00570592, 0.00570116, 0.0056958, 0.00568985,
  0.0056833, 0.00567615, 0.0056684, 0.00566006, 0.00565113,
  0.00564161, 0.00563149, 0.00562078, 0.00560948, 0.0055976,
  0.00558512, 0.00557207, 0.00555843, 0.0055442, 0.0055294,
  0.00551402, 0.00549806, 0.00548153, 0.00546442, 0.00544674,
  0.0054285, 0.00540968, 0.0053903, 0.00537036, 0.00534985,
  0.00532879, 0.00530717, 0.005285, 0.00526227, 0.005239, 0.00521518,
  0.00519082, 0.00516591, 0.00514047, 0.00511449, 0.00508798,
  0.00506093, 0.00503337, 0.00500527, 0.00497666, 0.00494753,
  0.00491788, 0.00488772, 0.00485705, 0.00482588, 0.00479421,
  0.00476204, 0.00472937, 0.00469621, 0.00466257, 0.00462844,
  0.00459383, 0.00455874, 0.00452318, 0.00448715, 0.00445065,
  0.0044137, 0.00437628, 0.00433841, 0.00430009, 0.00426133,
  0.00422213, 0.00418248, 0.00414241, 0.0041019, 0.00406097,
  0.00401963, 0.00397786, 0.00393568, 0.0038931, 0.00385011,
  0.00380673, 0.00376295, 0.00371878, 0.00367423, 0.0036293, 0.003584,
  0.00353832, 0.00349228, 0.00344588, 0.00339912, 0.00335201,
  0.00330456, 0.00325677, 0.00320864, 0.00316017, 0.00311139,
  0.00306228, 0.00301286, 0.00296313, 0.00291309, 0.00286275,
  0.00281212, 0.00276119, 0.00270999, 0.0026585, 0.00260674,
  0.00255472, 0.00250243, 0.00244988, 0.00239708, 0.00234404,
  0.00229075, 0.00223723, 0.00218348, 0.00212951, 0.00207531,
  0.00202091, 0.00196629, 0.00191148, 0.00185646, 0.00180126,
  0.00174587, 0.00169031, 0.00163457, 0.00157866, 0.00152259,
  0.00146637, 0.00141, 0.00135348, 0.00129682, 0.00124003, 0.00118311,
  0.00112607, 0.00106892, 0.00101166, 0.000954291, 0.000896827,
  0.000839271, 0.00078163, 0.000723909, 0.000666114, 0.00060825,
  0.000550325, 0.000492344, 0.000434312, 0.000376236, 0.000318121,
  0.000259974, 0.0002018, 0.000143606, 8.53973e-05, 2.71797e-05,
  -3.10406e-05, -8.92578e-05, -0.000147466, -0.000205659,
  -0.000263831, -0.000321976, -0.000380089, -0.000438163,
  -0.000496192, -0.000554171, -0.000612093, -0.000669954,
  -0.000727746, -0.000785464, -0.000843102, -0.000900654,
  -0.000958115, -0.00101548, -0.00107274, -0.00112989, -0.00118693,
  -0.00124384, -0.00130063, -0.00135729, -0.00141381, -0.00147019,
  -0.00152642, -0.00158249, -0.0016384, -0.00169415, -0.00174972,
  -0.00180512, -0.00186033, -0.00191536, -0.00197019, -0.00202482,
  -0.00207925, -0.00213347, -0.00218747, -0.00224125, -0.0022948,
  -0.00234812, -0.0024012, -0.00245404, -0.00250663, -0.00255897,
  -0.00261105, -0.00266286, -0.00271441, -0.00276568, -0.00281667,
  -0.00286738, -0.0029178, -0.00296792, -0.00301775, -0.00306727,
  -0.00311648, -0.00316537, -0.00321395, -0.0032622, -0.00331012,
  -0.00335771, -0.00340496, -0.00345187, -0.00349843, -0.00354463,
  -0.00359048, -0.00363597, -0.00368109, -0.00372584, -0.00377021,
  -0.00381421, -0.00385782, -0.00390105, -0.00394388, -0.00398631,
  -0.00402834, -0.00406997, -0.00411119, -0.00415199, -0.00419238,
  -0.00423235, -0.00427189, -0.004311, -0.00434968, -0.00438792,
  -0.00442572, -0.00446307, -0.00449998, -0.00453644, -0.00457244,
  -0.00460798, -0.00464306, -0.00467767, -0.00471182, -0.00474549,
  -0.00477868, -0.0048114, -0.00484364, -0.00487538, -0.00490664,
  -0.00493741, -0.00496768, -0.00499746, -0.00502674, -0.00505551,
  -0.00508377, -0.00511153, -0.00513877, -0.0051655, -0.00519172,
  -0.00521741, -0.00524258, -0.00526723, -0.00529135, -0.00531494,
  -0.005338, -0.00536053, -0.00538252, -0.00540397, -0.00542489,
  -0.00544526, -0.00546508, -0.00548437, -0.0055031, -0.00552128,
  -0.00553891, -0.00555599, -0.00557252, -0.00558849, -0.0056039,
  -0.00561875, -0.00563304, -0.00564677, -0.00565994, -0.00567254,
  -0.00568458, -0.00569605, -0.00570695, -0.00571728, -0.00572705,
  -0.00573624, -0.00574486, -0.00575291, -0.00576039, -0.00576729,
  -0.00577362, -0.00577937, -0.00578455, -0.00578916, -0.00579318,
  -0.00579663, -0.00579951, -0.00580181, -0.00580353, -0.00580467,
  -0.00580524, -0.00580523, -0.00580464, -0.00580347, -0.00580173,
  -0.00579941, -0.00579652, -0.00579305, -0.005789, -0.00578438,
  -0.00577919, -0.00577342, -0.00576708, -0.00576017, -0.00575268,
  -0.00574463, -0.005736, -0.00572681, -0.00571704, -0.00570671,
  -0.00569582, -0.00568436, -0.00567233, -0.00565975, -0.0056466,
  -0.00563289, -0.00561863, -0.00560381, -0.00558843, -0.0055725,
  -0.00555602, -0.00553899, -0.00552141, -0.00550328, -0.00548461,
  -0.00546539, -0.00544564, -0.00542534, -0.00540451, -0.00538315,
  -0.00536125, -0.00533882, -0.00531587, -0.00529238, -0.00526838,
  -0.00524385, -0.00521881, -0.00519325, -0.00516718, -0.00514059,
  -0.0051135, -0.00508591, -0.00505781, -0.00502921, -0.00500011,
  -0.00497053, -0.00494045, -0.00490988, -0.00487883, -0.0048473,
  -0.00481529, -0.0047828, -0.00474984, -0.00471642, -0.00468252,
  -0.00464817, -0.00461336, -0.00457809, -0.00454238, -0.00450621,
  -0.0044696, -0.00443255, -0.00439507, -0.00435715, -0.0043188,
  -0.00428002, -0.00424083, -0.00420121, -0.00416119, -0.00412075,
  -0.00407991, -0.00403866, -0.00399702, -0.00395499, -0.00391256,
  -0.00386975, -0.00382656, -0.003783, -0.00373906, -0.00369475,
  -0.00365009, -0.00360506, -0.00355968, -0.00351394, -0.00346787,
  -0.00342145, -0.00337469, -0.00332761, -0.00328019, -0.00323246,
  -0.0031844, -0.00313604, -0.00308736, -0.00303839, -0.00298911,
  -0.00293954, -0.00288969, -0.00283955, -0.00278913, -0.00273843,
  -0.00268747, -0.00263624, -0.00258476, -0.00253302, -0.00248104,
  -0.00242881, -0.00237634, -0.00232364, -0.00227071, -0.00221756,
  -0.00216419, -0.00211061, -0.00205682, -0.00200283, -0.00194865,
  -0.00189427, -0.00183971, -0.00178497, -0.00173005, -0.00167496,
  -0.00161971, -0.0015643, -0.00150874, -0.00145303, -0.00139718,
  -0.00134119, -0.00128507, -0.00122883, -0.00117246, -0.00111598,
  -0.00105939, -0.00100269, -0.000945903, -0.000889019, -0.000832048,
  -0.000774996, -0.000717868, -0.000660669, -0.000603406,
  -0.000546084, -0.000488709, -0.000431286, -0.000373821,
  -0.000316319, -0.000258787, -0.000201229, -0.000143651, -8.606e-05,
  -2.84601e-05, 2.91426e-05, 8.67424e-05, 0.000144334, 0.000201911,
  0.000259468, 0.000317001, 0.000374502, 0.000431966, 0.000489389,
  0.000546764, 0.000604085, 0.000661347, 0.000718545, 0.000775673,
  0.000832725, 0.000889696, 0.00094658, 0.00100337, 0.00106007,
  0.00111666, 0.00117314, 0.0012295, 0.00128575, 0.00134187,
  0.00139786, 0.00145372, 0.00150943, 0.001565, 0.00162041,
  0.00167567, 0.00173076, 0.00178569, 0.00184044, 0.00189501,
  0.00194939, 0.00200359, 0.00205759, 0.00211139, 0.00216499,
  0.00221837, 0.00227154, 0.00232449, 0.00237721, 0.0024297,
  0.00248195, 0.00253396, 0.00258573, 0.00263724, 0.0026885,
  0.00273949, 0.00279022, 0.00284068, 0.00289086, 0.00294076,
  0.00299038, 0.0030397, 0.00308873, 0.00313746, 0.00318588,
  0.00323399, 0.00328179, 0.00332927, 0.00337643, 0.00342325,
  0.00346975, 0.00351591, 0.00356173, 0.0036072, 0.00365232,
  0.00369708, 0.00374149, 0.00378553, 0.00382921, 0.00387251,
  0.00391544, 0.00395798, 0.00400015, 0.00404192, 0.0040833,
  0.00412429, 0.00416487, 0.00420506, 0.00424483, 0.00428419,
  0.00432314, 0.00436166, 0.00439976, 0.00443744, 0.00447469,
  0.0045115, 0.00454787, 0.0045838, 0.00461929, 0.00465433,
  0.00468892, 0.00472305, 0.00475673, 0.00478994, 0.0048227,
  0.00485498, 0.00488679, 0.00491813, 0.00494899, 0.00497937,
  0.00500927, 0.00503869, 0.00506761, 0.00509605, 0.00512399,
  0.00515143, 0.00517838, 0.00520482, 0.00523076, 0.00525619,
  0.00528112, 0.00530553, 0.00532943, 0.00535281, 0.00537567,
  0.00539802, 0.00541984, 0.00544113, 0.0054619, 0.00548214,
  0.00550185, 0.00552103, 0.00553967, 0.00555778, 0.00557535,
  0.00559237, 0.00560886, 0.00562481, 0.00564021, 0.00565506,
  0.00566937, 0.00568313, 0.00569634, 0.005709, 0.0057211, 0.00573265,
  0.00574365, 0.00575409, 0.00576398, 0.00577331, 0.00578208,
  0.00579029, 0.00579794, 0.00580503, 0.00581156, 0.00581753,
  0.00582293, 0.00582777, 0.00583205, 0.00583577, 0.00583892,
  0.0058415, 0.00584353, 0.00584498, 0.00584587, 0.0058462,
  0.00584596, 0.00584516, 0.00584379, 0.00584186, 0.00583936,
  0.0058363, 0.00583268, 0.00582849, 0.00582374, 0.00581842,
  0.00581255, 0.00580611, 0.00579911, 0.00579155, 0.00578344,
  0.00577476, 0.00576553, 0.00575574, 0.00574539, 0.00573449,
  0.00572303, 0.00571103, 0.00569847, 0.00568536, 0.0056717,
  0.00565749, 0.00564274, 0.00562745, 0.00561161, 0.00559522,
  0.0055783, 0.00556084, 0.00554285, 0.00552432, 0.00550525,
  0.00548566, 0.00546553, 0.00544488, 0.0054237, 0.005402, 0.00537978,
  0.00535703, 0.00533378, 0.00531, 0.00528572, 0.00526092, 0.00523562,
  0.00520981, 0.0051835, 0.00515669, 0.00512938, 0.00510158,
  0.00507329, 0.0050445, 0.00501523, 0.00498548, 0.00495524,
  0.00492453, 0.00489334, 0.00486168, 0.00482955, 0.00479696,
  0.0047639, 0.00473039, 0.00469642, 0.00466199, 0.00462712,
  0.0045918, 0.00455603, 0.00451983, 0.00448319, 0.00444612,
  0.00440862, 0.0043707, 0.00433235, 0.00429359, 0.00425441,
  0.00421483, 0.00417483, 0.00413444, 0.00409364, 0.00405245,
  0.00401088, 0.00396891, 0.00392656, 0.00388383, 0.00384073,
  0.00379726, 0.00375343, 0.00370923, 0.00366467, 0.00361976,
  0.0035745, 0.0035289, 0.00348296, 0.00343668, 0.00339007,
  0.00334314, 0.00329588, 0.0032483, 0.00320041, 0.00315222,
  0.00310372, 0.00305492, 0.00300582, 0.00295644, 0.00290677,
  0.00285682, 0.0028066, 0.00275611, 0.00270535, 0.00265433,
  0.00260305, 0.00255152, 0.00249975, 0.00244774, 0.00239549,
  0.00234301, 0.00229031, 0.00223738, 0.00218424, 0.00213089,
  0.00207733, 0.00202357, 0.00196962, 0.00191548, 0.00186115,
  0.00180665, 0.00175197, 0.00169712, 0.00164211, 0.00158694,
  0.00153162, 0.00147615, 0.00142053, 0.00136478, 0.0013089,
  0.0012529, 0.00119677, 0.00114053, 0.00108417, 0.00102772,
  0.000971161, 0.000914512, 0.000857775, 0.000800955, 0.000744057,
  0.000687088, 0.000630053, 0.000572958, 0.000515807, 0.000458606,
  0.000401361, 0.000344078, 0.000286761, 0.000229417, 0.000172051,
  0.000114668, 5.72741e-05, -1.25385e-07, -5.75249e-05, -0.000114919,
  -0.000172302, -0.000229668, -0.000287012, -0.000344329,
  -0.000401612, -0.000458857, -0.000516058, -0.000573208,
  -0.000630304, -0.000687339, -0.000744308, -0.000801205,
  -0.000858025, -0.000914763, -0.000971412, -0.00102797, -0.00108442,
  -0.00114078, -0.00119702, -0.00125315, -0.00130915, -0.00136503,
  -0.00142078, -0.0014764, -0.00153187, -0.00158719, -0.00164236,
  -0.00169737, -0.00175222, -0.0018069, -0.0018614, -0.00191573,
  -0.00196987, -0.00202382, -0.00207758, -0.00213114, -0.00218449,
  -0.00223763, -0.00229056, -0.00234326, -0.00239574, -0.00244799,
  -0.0025, -0.00255177, -0.0026033, -0.00265458, -0.0027056,
  -0.00275636, -0.00280685, -0.00285707, -0.00290702, -0.00295669,
  -0.00300607, -0.00305517, -0.00310397, -0.00315247, -0.00320066,
  -0.00324855, -0.00329613, -0.00334339, -0.00339032, -0.00343693,
  -0.00348321, -0.00352915, -0.00357475, -0.00362001, -0.00366492,
  -0.00370948, -0.00375368, -0.00379751, -0.00384098, -0.00388409,
  -0.00392681, -0.00396916, -0.00401113, -0.00405271, -0.00409389,
  -0.00413469, -0.00417508, -0.00421508, -0.00425466, -0.00429384,
  -0.0043326, -0.00437095, -0.00440887, -0.00444637, -0.00448344,
  -0.00452008, -0.00455628, -0.00459205, -0.00462737, -0.00466224,
  -0.00469667, -0.00473064, -0.00476415, -0.00479721, -0.0048298,
  -0.00486193, -0.00489359, -0.00492478, -0.00495549, -0.00498573,
  -0.00501548, -0.00504475, -0.00507354, -0.00510183, -0.00512963,
  -0.00515694, -0.00518375, -0.00521006, -0.00523587, -0.00526117,
  -0.00528597, -0.00531025, -0.00533403, -0.00535729, -0.00538003,
  -0.00540225, -0.00542395, -0.00544513, -0.00546578, -0.00548591,
  -0.0055055, -0.00552457, -0.0055431, -0.00556109, -0.00557855,
  -0.00559548, -0.00561186, -0.0056277, -0.00564299, -0.00565774,
  -0.00567195, -0.00568561, -0.00569872, -0.00571128, -0.00572328,
  -0.00573474, -0.00574564, -0.00575599, -0.00576578, -0.00577501,
  -0.00578369, -0.0057918, -0.00579936, -0.00580636, -0.0058128,
  -0.00581867, -0.00582399, -0.00582874, -0.00583293, -0.00583655,
  -0.00583961, -0.00584211, -0.00584404, -0.00584541, -0.00584621,
  -0.00584645, -0.00584612, -0.00584523, -0.00584378, -0.00584175,
  -0.00583917, -0.00583602, -0.0058323, -0.00582802, -0.00582318,
  -0.00581778, -0.00581181, -0.00580528, -0.00579819, -0.00579054,
  -0.00578233, -0.00577356, -0.00576423, -0.00575434, -0.0057439,
  -0.0057329, -0.00572135, -0.00570925, -0.00569659, -0.00568338,
  -0.00566962, -0.00565531, -0.00564046, -0.00562506, -0.00560911,
  -0.00559262, -0.0055756, -0.00555803, -0.00553992, -0.00552128,
  -0.0055021, -0.00548239, -0.00546215, -0.00544138, -0.00542009,
  -0.00539827, -0.00537592, -0.00535306, -0.00532968, -0.00530578,
  -0.00528137, -0.00525644, -0.00523101, -0.00520507, -0.00517863,
  -0.00515168, -0.00512424, -0.0050963, -0.00506786, -0.00503894,
  -0.00500952, -0.00497962, -0.00494924, -0.00491838, -0.00488704,
  -0.00485523, -0.00482295, -0.0047902, -0.00475698, -0.0047233,
  -0.00468917, -0.00465458, -0.00461954, -0.00458405, -0.00454812,
  -0.00451175, -0.00447494, -0.00443769, -0.00440002, -0.00436191,
  -0.00432339, -0.00428444, -0.00424508, -0.00420531, -0.00416513,
  -0.00412454, -0.00408355, -0.00404217, -0.0040004, -0.00395823,
  -0.00391569, -0.00387276, -0.00382946, -0.00378578, -0.00374174,
  -0.00369733, -0.00365257, -0.00360745, -0.00356198, -0.00351616,
  -0.00347, -0.00342351, -0.00337668, -0.00332952, -0.00328204,
  -0.00323424, -0.00318613, -0.00313771, -0.00308898, -0.00303995,
  -0.00299063, -0.00294101, -0.00289111, -0.00284093, -0.00279047,
  -0.00273974, -0.00268875, -0.00263749, -0.00258598, -0.00253421,
  -0.0024822, -0.00242995, -0.00237746, -0.00232474, -0.00227179,
  -0.00221862, -0.00216524, -0.00211164, -0.00205784, -0.00200384,
  -0.00194964, -0.00189526, -0.00184069, -0.00178594, -0.00173101,
  -0.00167592, -0.00162066, -0.00156525, -0.00150968, -0.00145397,
  -0.00139812, -0.00134212, -0.001286, -0.00122976, -0.00117339,
  -0.00111691, -0.00106032, -0.00100362, -0.00094683, -0.000889946,
  -0.000832976, -0.000775924, -0.000718796, -0.000661598,
  -0.000604336, -0.000547014, -0.00048964, -0.000432217, -0.000374753,
  -0.000317251, -0.000259719, -0.000202162, -0.000144585,
  -8.69932e-05, -2.93934e-05, 2.82093e-05, 8.58092e-05, 0.000143401,
  0.000200978, 0.000258536, 0.000316069, 0.00037357, 0.000431035,
  0.000488458, 0.000545834, 0.000603156, 0.000660419, 0.000717617,
  0.000774745, 0.000831797, 0.000888768, 0.000945653, 0.00100244,
  0.00105914, 0.00111573, 0.00117221, 0.00122857, 0.00128482,
  0.00134094, 0.00139693, 0.00145278, 0.00150849, 0.00156405,
  0.00161946, 0.00167471, 0.0017298, 0.00178472, 0.00183946,
  0.00189402, 0.0019484, 0.00200258, 0.00205657, 0.00211036,
  0.00216394, 0.00221731, 0.00227046, 0.00232339, 0.00237609,
  0.00242856, 0.00248079, 0.00253277, 0.00258451, 0.00263599,
  0.00268722, 0.00273818, 0.00278887, 0.00283929, 0.00288944,
  0.00293929, 0.00298886, 0.00303814, 0.00308711, 0.00313579,
  0.00318415, 0.00323221, 0.00327994, 0.00332736, 0.00337444,
  0.0034212, 0.00346761, 0.00351369, 0.00355942, 0.00360481,
  0.00364984, 0.0036945, 0.00373881, 0.00378275, 0.00382631,
  0.0038695, 0.00391231, 0.00395474, 0.00399677, 0.00403841,
  0.00407966, 0.0041205, 0.00416094, 0.00420096, 0.00424058,
  0.00427977, 0.00431855, 0.00435689, 0.00439481, 0.0044323,
  0.00446935, 0.00450596, 0.00454213, 0.00457784, 0.00461311,
  0.00464792, 0.00468227, 0.00471617, 0.00474959, 0.00478255,
  0.00481504, 0.00484705, 0.00487858, 0.00490963, 0.0049402,
  0.00497028, 0.00499986, 0.00502896, 0.00505756, 0.00508565,
  0.00511325, 0.00514034, 0.00516693, 0.005193, 0.00521856, 0.0052436,
  0.00526813, 0.00529213, 0.00531561, 0.00533857, 0.005361, 0.0053829,
  0.00540426, 0.00542509, 0.00544539, 0.00546514, 0.00548436,
  0.00550303, 0.00552116, 0.00553874, 0.00555577, 0.00557225,
  0.00558818, 0.00560356, 0.00561838, 0.00563264, 0.00564635,
  0.0056595, 0.00567208, 0.00568411, 0.00569557, 0.00570646,
  0.00571679, 0.00572656, 0.00573575, 0.00574438, 0.00575243,
  0.00575992, 0.00576683, 0.00577317, 0.00577894, 0.00578413,
  0.00578875, 0.0057928, 0.00579627, 0.00579916, 0.00580148,
  0.00580322, 0.00580439, 0.00580497, 0.00580499, 0.00580442,
  0.00580328, 0.00580156, 0.00579926, 0.00579638, 0.00579293,
  0.00578891, 0.0057843, 0.00577912, 0.00577337, 0.00576704,
  0.00576014, 0.00575266, 0.00574461, 0.00573599, 0.0057268,
  0.00571703, 0.0057067, 0.0056958, 0.00568433, 0.00567229,
  0.00565969, 0.00564652, 0.00563279, 0.0056185, 0.00560365,
  0.00558824, 0.00557227, 0.00555574, 0.00553866, 0.00552103,
  0.00550285, 0.00548411, 0.00546483, 0.00544501, 0.00542464,
  0.00540372, 0.00538227, 0.00536028, 0.00533775, 0.00531469,
  0.0052911, 0.00526698, 0.00524233, 0.00521716, 0.00519147,
  0.00516525, 0.00513852, 0.00511128, 0.00508352, 0.00505526,
  0.00502649, 0.00499721, 0.00496743, 0.00493716, 0.00490639,
  0.00487513, 0.00484338, 0.00481115, 0.00477843, 0.00474524,
  0.00471157, 0.00467742, 0.00464281, 0.00460773, 0.00457219,
  0.00453619, 0.00449973, 0.00446282, 0.00442547, 0.00438767,
  0.00434943, 0.00431075, 0.00427164, 0.0042321, 0.00419213,
  0.00415174, 0.00411094, 0.00406972, 0.00402809, 0.00398606,
  0.00394363, 0.00390079, 0.00385757, 0.00381396, 0.00376996,
  0.00372559, 0.00368084, 0.00363572, 0.00359023, 0.00354438,
  0.00349817, 0.00345162, 0.00340471, 0.00335746, 0.00330987,
  0.00326195, 0.0032137, 0.00316512, 0.00311622, 0.00306702,
  0.0030175, 0.00296767, 0.00291755, 0.00286713, 0.00281642,
  0.00276543, 0.00271416, 0.00266261, 0.0026108, 0.00255872,
  0.00250638, 0.00245379, 0.00240095, 0.00234787, 0.00229455,
  0.00224099, 0.00218722, 0.00213321, 0.002079, 0.00202457,
  0.00196994, 0.00191511, 0.00186008, 0.00180487, 0.00174947,
  0.0016939, 0.00163815, 0.00158224, 0.00152617, 0.00146994,
  0.00141356, 0.00135704, 0.00130038, 0.00124359, 0.00118668,
  0.00112964, 0.00107249, 0.00101523, 0.000957864, 0.000900404,
  0.000842851, 0.000785213, 0.000727495, 0.000669703, 0.000611843,
  0.00055392, 0.000495941, 0.000437912, 0.000379838, 0.000321726,
  0.00026358, 0.000205408, 0.000147215, 8.9007e-05, 3.07899e-05,
  -2.74305e-05, -8.5648e-05, -0.000143857, -0.000202051, -0.000260225,
  -0.000318372, -0.000376486, -0.000434562, -0.000492594,
  -0.000550576, -0.000608501, -0.000666364, -0.00072416, -0.000781881,
  -0.000839522, -0.000897078, -0.000954542, -0.00101191, -0.00106917,
  -0.00112632, -0.00118336, -0.00124028, -0.00129707, -0.00135373,
  -0.00141025, -0.00146662, -0.00152285, -0.00157891, -0.00163482,
  -0.00169056, -0.00174613, -0.00180151, -0.00185671, -0.00191173,
  -0.00196654, -0.00202116, -0.00207556, -0.00212976, -0.00218373,
  -0.00223748, -0.002291, -0.00234429, -0.00239733, -0.00245013,
  -0.00250268, -0.00255497, -0.00260699, -0.00265875, -0.00271024,
  -0.00276144, -0.00281237, -0.002863, -0.00291334, -0.00296338,
  -0.00301311, -0.00306253, -0.00311164, -0.00316043, -0.00320889,
  -0.00325702, -0.00330481, -0.00335226, -0.00339937, -0.00344613,
  -0.00349253, -0.00353857, -0.00358425, -0.00362955, -0.00367448,
  -0.00371903, -0.0037632, -0.00380698, -0.00385036, -0.00389335,
  -0.00393593, -0.00397811, -0.00401988, -0.00406123, -0.00410215,
  -0.00414266, -0.00418273, -0.00422238, -0.00426158, -0.00430035,
  -0.00433866, -0.00437653, -0.00441395, -0.0044509, -0.0044874,
  -0.00452343, -0.00455899, -0.00459408, -0.00462869, -0.00466282,
  -0.00469646, -0.00472962, -0.00476229, -0.00479446, -0.00482613,
  -0.00485731, -0.00488797, -0.00491813, -0.00494778, -0.00497691,
  -0.00500552, -0.00503362, -0.00506119, -0.00508823, -0.00511474,
  -0.00514072, -0.00516616, -0.00519107, -0.00521543, -0.00523925,
  -0.00526252, -0.00528525, -0.00530742, -0.00532904, -0.0053501,
  -0.00537061, -0.00539055, -0.00540993, -0.00542875, -0.00544699,
  -0.00546467, -0.00548178, -0.00549831, -0.00551427, -0.00552965,
  -0.00554446, -0.00555868, -0.00557232, -0.00558538, -0.00559785,
  -0.00560973, -0.00562103, -0.00563174, -0.00564186, -0.00565138,
  -0.00566032, -0.00566866, -0.0056764, -0.00568355, -0.0056901,
  -0.00569606, -0.00570141, -0.00570617, -0.00571033, -0.00571388,
  -0.00571684, -0.0057192, -0.00572095, -0.0057221, -0.00572265,
  -0.0057226, -0.00572195, -0.00572069, -0.00571883, -0.00571637,
  -0.0057133, -0.00570963, -0.00570536, -0.00570049, -0.00569502,
  -0.00568895, -0.00568228, -0.005675, -0.00566713, -0.00565866,
  -0.00564959, -0.00563992, -0.00562966, -0.00561881, -0.00560735,
  -0.00559531, -0.00558267, -0.00556945, -0.00555563, -0.00554123,
  -0.00552624, -0.00551066, -0.0054945, -0.00547776, -0.00546043,
  -0.00544253, -0.00542405, -0.005405, -0.00538537, -0.00536517,
  -0.0053444, -0.00532306, -0.00530116, -0.00527869, -0.00525567,
  -0.00523208, -0.00520794, -0.00518325, -0.005158, -0.0051322,
  -0.00510586, -0.00507898, -0.00505155, -0.00502359, -0.00499509,
  -0.00496606, -0.0049365, -0.00490641, -0.0048758, -0.00484467,
  -0.00481303, -0.00478086, -0.00474819, -0.00471502, -0.00468133,
  -0.00464715, -0.00461248, -0.0045773, -0.00454164, -0.0045055,
  -0.00446887, -0.00443176, -0.00439418, -0.00435613, -0.00431761,
  -0.00427863, -0.0042392, -0.0041993, -0.00415896, -0.00411817,
  -0.00407694, -0.00403527, -0.00399317, -0.00395064, -0.00390769,
  -0.00386432, -0.00382053, -0.00377633, -0.00373172, -0.00368672,
  -0.00364132, -0.00359552, -0.00354934, -0.00350278, -0.00345584,
  -0.00340853, -0.00336085, -0.00331281, -0.00326441, -0.00321566,
  -0.00316656, -0.00311712, -0.00306735, -0.00301724, -0.00296681,
  -0.00291606, -0.00286499, -0.00281362, -0.00276194, -0.00270996,
  -0.00265769, -0.00260513, -0.00255229, -0.00249917, -0.00244578,
  -0.00239213, -0.00233822, -0.00228405, -0.00222964, -0.00217499,
  -0.0021201, -0.00206498, -0.00200964, -0.00195407, -0.0018983,
  -0.00184232, -0.00178614, -0.00172977, -0.0016732, -0.00161646,
  -0.00155954, -0.00150245, -0.0014452, -0.00138779, -0.00133023,
  -0.00127252, -0.00121468, -0.0011567, -0.0010986, -0.00104038,
  -0.000982043, -0.0009236, -0.000865056, -0.000806418, -0.000747692,
  -0.000688885, -0.000630002, -0.00057105, -0.000512036, -0.000452966,
  -0.000393847, -0.000334684, -0.000275485, -0.000216255,
  -0.000157002, -9.77323e-05, -3.84514e-05, 2.08337e-05, 8.01164e-05,
  0.00013939, 0.000198649, 0.000257886, 0.000317095, 0.000376268,
  0.000435401, 0.000494485, 0.000553515, 0.000612485, 0.000671387,
  0.000730215, 0.000788963, 0.000847624, 0.000906192, 0.00096466,
  0.00102302, 0.00108127, 0.0011394, 0.0011974, 0.00125528,
  0.00131301, 0.0013706, 0.00142804, 0.00148532, 0.00154243,
  0.00159938, 0.00165615, 0.00171273, 0.00176913, 0.00182533,
  0.00188133, 0.00193712, 0.00199269, 0.00204805, 0.00210318,
  0.00215807, 0.00221273, 0.00226714, 0.0023213, 0.0023752,
  0.00242884, 0.00248221, 0.0025353, 0.00258811, 0.00264063,
  0.00269286, 0.0027448, 0.00279642, 0.00284773, 0.00289873,
  0.00294941, 0.00299975, 0.00304977, 0.00309944, 0.00314876,
  0.00319774, 0.00324636, 0.00329462, 0.0033425, 0.00339002,
  0.00343716, 0.00348391, 0.00353027, 0.00357624, 0.00362181,
  0.00366698, 0.00371173, 0.00375607, 0.00379999, 0.00384348,
  0.00388654, 0.00392917, 0.00397135, 0.00401309, 0.00405438,
  0.00409522, 0.00413559, 0.00417551, 0.00421495, 0.00425392,
  0.00429241, 0.00433041, 0.00436793, 0.00440496, 0.0044415,
  0.00447753, 0.00451306, 0.00454808, 0.00458259, 0.00461658,
  0.00465005, 0.00468299, 0.00471541, 0.0047473, 0.00477865,
  0.00480946, 0.00483972, 0.00486944, 0.00489861, 0.00492722,
  0.00495528, 0.00498278, 0.00500971, 0.00503607, 0.00506186,
  0.00508708, 0.00511173, 0.00513579, 0.00515927, 0.00518217,
  0.00520447, 0.00522619, 0.00524731, 0.00526784, 0.00528776,
  0.00530709, 0.00532581, 0.00534393, 0.00536143, 0.00537833,
  0.00539461, 0.00541028, 0.00542533, 0.00543977, 0.00545358,
  0.00546677, 0.00547934, 0.00549128, 0.00550259, 0.00551328,
  0.00552333, 0.00553275, 0.00554154, 0.0055497, 0.00555722,
  0.0055641, 0.00557035, 0.00557596, 0.00558092, 0.00558525,
  0.00558894, 0.00559199, 0.00559439, 0.00559616, 0.00559727,
  0.00559775, 0.00559758, 0.00559677, 0.00559532, 0.00559322,
  0.00559047, 0.00558709, 0.00558306, 0.00557838, 0.00557307,
  0.00556711, 0.0055605, 0.00555326, 0.00554537, 0.00553685,
  0.00552768, 0.00551788, 0.00550743, 0.00549635, 0.00548464,
  0.00547229, 0.0054593, 0.00544569, 0.00543144, 0.00541656,
  0.00540106, 0.00538493, 0.00536817, 0.00535079, 0.00533279,
  0.00531417, 0.00529493, 0.00527507, 0.0052546, 0.00523352,
  0.00521184, 0.00518954, 0.00516664, 0.00514314, 0.00511904,
  0.00509434, 0.00506904, 0.00504316, 0.00501669, 0.00498963,
  0.00496199, 0.00493376, 0.00490496, 0.00487559, 0.00484565,
  0.00481514, 0.00478406, 0.00475243, 0.00472024, 0.00468749,
  0.0046542, 0.00462036, 0.00458597, 0.00455105, 0.0045156,
  0.00447961, 0.0044431, 0.00440606, 0.00436851, 0.00433044,
  0.00429186, 0.00425278, 0.00421319, 0.00417311, 0.00413254,
  0.00409148, 0.00404994, 0.00400791, 0.00396542, 0.00392246,
  0.00387903, 0.00383514, 0.0037908, 0.00374602, 0.00370079,
  0.00365512, 0.00360901, 0.00356248, 0.00351553, 0.00346816,
  0.00342038, 0.00337219, 0.00332361, 0.00327462, 0.00322525,
  0.0031755, 0.00312536, 0.00307486, 0.00302399, 0.00297276,
  0.00292117, 0.00286924, 0.00281697, 0.00276435, 0.00271141,
  0.00265815, 0.00260457, 0.00255067, 0.00249648, 0.00244198,
  0.00238719, 0.00233212, 0.00227676, 0.00222114, 0.00216524,
  0.00210909, 0.00205269, 0.00199604, 0.00193915, 0.00188202,
  0.00182467, 0.00176711, 0.00170933, 0.00165134, 0.00159315,
  0.00153478, 0.00147622, 0.00141748, 0.00135857, 0.00129949,
  0.00124026, 0.00118088, 0.00112136, 0.0010617, 0.00100191,
  0.000942005, 0.000881983, 0.000821855, 0.000761627, 0.000701307,
  0.000640902, 0.000580419, 0.000519866, 0.00045925, 0.000398579,
  0.000337859, 0.000277097, 0.000216302, 0.000155481, 9.46413e-05,
  3.37897e-05, -2.7066e-05, -8.79184e-05, -0.00014876, -0.000209584,
  -0.000270382, -0.000331147, -0.000391872, -0.000452549, -0.00051317,
  -0.00057373, -0.000634218, -0.00069463, -0.000754956, -0.000815191,
  -0.000875325, -0.000935352, -0.000995265, -0.00105506, -0.00111472,
  -0.00117424, -0.00123362, -0.00129285, -0.00135192, -0.00141083,
  -0.00146956, -0.00152811, -0.00158647, -0.00164463, -0.0017026,
  -0.00176035, -0.00181789, -0.0018752, -0.00193229, -0.00198913,
  -0.00204573, -0.00210207, -0.00215816, -0.00221398, -0.00226952,
  -0.00232478, -0.00237976, -0.00243444, -0.00248882, -0.00254289,
  -0.00259665, -0.00265008, -0.00270318, -0.00275595, -0.00280838,
  -0.00286045, -0.00291217, -0.00296353, -0.00301452, -0.00306514,
  -0.00311537, -0.00316521, -0.00321466, -0.00326371, -0.00331235,
  -0.00336058, -0.00340839, -0.00345577, -0.00350272, -0.00354923,
  -0.00359529, -0.00364091, -0.00368607, -0.00373077, -0.003775,
  -0.00381875, -0.00386203, -0.00390482, -0.00394712, -0.00398893,
  -0.00403023, -0.00407103, -0.00411131, -0.00415108, -0.00419032,
  -0.00422904, -0.00426722, -0.00430486, -0.00434196, -0.00437851,
  -0.00441451, -0.00444995, -0.00448483, -0.00451914, -0.00455288,
  -0.00458604, -0.00461862, -0.00465061, -0.00468201, -0.00471283,
  -0.00474304, -0.00477265, -0.00480165, -0.00483004, -0.00485782,
  -0.00488498, -0.00491152, -0.00493743, -0.00496271, -0.00498736,
  -0.00501138, -0.00503475, -0.00505748, -0.00507957, -0.005101,
  -0.00512179, -0.00514191, -0.00516138, -0.00518019, -0.00519834,
  -0.00521582, -0.00523263, -0.00524876, -0.00526423, -0.00527902,
  -0.00529313, -0.00530655, -0.0053193, -0.00533136, -0.00534274,
  -0.00535342, -0.00536342, -0.00537273, -0.00538134, -0.00538925,
  -0.00539648, -0.005403, -0.00540882, -0.00541395, -0.00541837,
  -0.0054221, -0.00542512, -0.00542744, -0.00542905, -0.00542996,
  -0.00543016, -0.00542966, -0.00542846, -0.00542654, -0.00542393,
  -0.0054206, -0.00541657, -0.00541184, -0.0054064, -0.00540025,
  -0.0053934, -0.00538585, -0.00537759, -0.00536863, -0.00535896,
  -0.0053486, -0.00533754, -0.00532577, -0.00531331, -0.00530016,
  -0.00528631, -0.00527176, -0.00525652, -0.00524059, -0.00522398,
  -0.00520667, -0.00518868, -0.00517001, -0.00515066, -0.00513063,
  -0.00510992, -0.00508854, -0.00506648, -0.00504376, -0.00502037,
  -0.00499632, -0.0049716, -0.00494623, -0.00492021, -0.00489353,
  -0.0048662, -0.00483823, -0.00480962, -0.00478036, -0.00475048,
  -0.00471996, -0.00468881, -0.00465704, -0.00462465, -0.00459164,
  -0.00455803, -0.0045238, -0.00448897, -0.00445354, -0.00441752,
  -0.00438091, -0.00434371, -0.00430593, -0.00426757, -0.00422865,
  -0.00418915, -0.0041491, -0.00410848, -0.00406732, -0.00402561,
  -0.00398336, -0.00394057, -0.00389726, -0.00385342, -0.00380906,
  -0.00376419, -0.00371881, -0.00367293, -0.00362655, -0.00357968,
  -0.00353233, -0.0034845, -0.0034362, -0.00338744, -0.00333822,
  -0.00328854, -0.00323842, -0.00318786, -0.00313687, -0.00308545,
  -0.00303362, -0.00298137, -0.00292871, -0.00287566, -0.00282221,
  -0.00276838, -0.00271417, -0.0026596, -0.00260466, -0.00254936,
  -0.00249372, -0.00243773, -0.00238141, -0.00232477, -0.00226781,
  -0.00221053, -0.00215296, -0.00209508, -0.00203692, -0.00197849,
  -0.00191977, -0.0018608, -0.00180157, -0.00174209, -0.00168237,
  -0.00162242, -0.00156225, -0.00150186, -0.00144126, -0.00138046,
  -0.00131947, -0.00125831, -0.00119696, -0.00113545, -0.00107379,
  -0.00101197, -0.000950014, -0.000887926, -0.000825715, -0.000763389,
  -0.000700957, -0.000638428, -0.00057581, -0.000513111, -0.000450342,
  -0.000387509, -0.000324622, -0.00026169, -0.000198722, -0.000135725,
  -7.27099e-05, -9.68445e-06, 5.33424e-05, 0.000116362, 0.000179365,
  0.000242342, 0.000305286, 0.000368187, 0.000431036, 0.000493825,
  0.000556544, 0.000619184, 0.000681737, 0.000744195, 0.000806547,
  0.000868785, 0.000930901, 0.000992885, 0.00105473, 0.00111642,
  0.00117796, 0.00123933, 0.00130052, 0.00136153, 0.00142235,
  0.00148296, 0.00154336, 0.00160355, 0.0016635, 0.00172322,
  0.0017827, 0.00184191, 0.00190087, 0.00195956, 0.00201796,
  0.00207608, 0.0021339, 0.00219141, 0.00224861, 0.00230549,
  0.00236204, 0.00241825, 0.00247411, 0.00252962, 0.00258476,
  0.00263953, 0.00269392, 0.00274793, 0.00280153, 0.00285474,
  0.00290753, 0.0029599, 0.00301184, 0.00306335, 0.00311442,
  0.00316503, 0.00321519, 0.00326488, 0.0033141, 0.00336284,
  0.00341108, 0.00345884, 0.00350608, 0.00355282, 0.00359905,
  0.00364474, 0.00368991, 0.00373454, 0.00377862, 0.00382215,
  0.00386512, 0.00390753, 0.00394937, 0.00399062, 0.0040313,
  0.00407138, 0.00411086, 0.00414974, 0.00418801, 0.00422567,
  0.0042627, 0.0042991, 0.00433487, 0.00437001, 0.0044045, 0.00443833,
  0.00447152, 0.00450404, 0.00453589, 0.00456708, 0.00459758,
  0.00462741, 0.00465655, 0.004685, 0.00471275, 0.0047398, 0.00476615,
  0.00479179, 0.00481671, 0.00484092, 0.0048644, 0.00488716,
  0.00490919, 0.00493048, 0.00495104, 0.00497086, 0.00498993,
  0.00500826, 0.00502583, 0.00504265, 0.00505871, 0.00507402,
  0.00508856, 0.00510233, 0.00511534, 0.00512757, 0.00513903,
  0.00514972, 0.00515963, 0.00516876, 0.00517711, 0.00518467,
  0.00519145, 0.00519745, 0.00520265, 0.00520707, 0.00521069,
  0.00521352, 0.00521556, 0.00521681, 0.00521726, 0.00521692,
  0.00521578, 0.00521385, 0.00521112, 0.00520759, 0.00520327,
  0.00519815, 0.00519223, 0.00518552, 0.00517802, 0.00516972,
  0.00516062, 0.00515073, 0.00514005, 0.00512858, 0.00511632,
  0.00510327, 0.00508943, 0.00507481, 0.0050594, 0.00504321,
  0.00502624, 0.0050085, 0.00498997, 0.00497068, 0.00495061,
  0.00492977, 0.00490817, 0.0048858, 0.00486268, 0.00483879,
  0.00481415, 0.00478877, 0.00476263, 0.00473575, 0.00470813,
  0.00467977, 0.00465068, 0.00462086, 0.00459032, 0.00455906,
  0.00452708, 0.00449439, 0.00446099, 0.00442689, 0.0043921,
  0.00435661, 0.00432044, 0.00428358, 0.00424604, 0.00420784,
  0.00416897, 0.00412944, 0.00408925, 0.00404842, 0.00400694,
  0.00396483, 0.00392209, 0.00387872, 0.00383474, 0.00379014,
  0.00374494, 0.00369915, 0.00365276, 0.00360579, 0.00355824,
  0.00351012, 0.00346145, 0.00341221, 0.00336243, 0.00331211,
  0.00326126, 0.00320988, 0.00315798, 0.00310558, 0.00305268,
  0.00299928, 0.0029454, 0.00289104, 0.00283622, 0.00278094,
  0.00272521, 0.00266903, 0.00261243, 0.00255539, 0.00249795,
  0.0024401, 0.00238185, 0.00232321, 0.00226419, 0.00220481,
  0.00214506, 0.00208497, 0.00202453, 0.00196376, 0.00190267,
  0.00184127, 0.00177957, 0.00171757, 0.00165529, 0.00159274,
  0.00152993, 0.00146687, 0.00140356, 0.00134002, 0.00127627,
  0.0012123, 0.00114813, 0.00108377, 0.00101923, 0.000954517,
  0.00088965, 0.000824635, 0.000759483, 0.000694205, 0.000628812,
  0.000563313, 0.00049772, 0.000432045, 0.000366297, 0.000300488,
  0.000234629, 0.00016873, 0.000102803, 3.6859e-05, -2.90914e-05,
  -9.50369e-05, -0.000160966, -0.000226869, -0.000292733,
  -0.000358548, -0.000424303, -0.000489986, -0.000555586,
  -0.000621092, -0.000686493, -0.000751777, -0.000816935,
  -0.000881953, -0.000946822, -0.00101153, -0.00107607, -0.00114042,
  -0.00120458, -0.00126853, -0.00133226, -0.00139577, -0.00145904,
  -0.00152206, -0.00158482, -0.00164731, -0.00170951, -0.00177142,
  -0.00183303, -0.00189432, -0.00195528, -0.00201591, -0.00207619,
  -0.00213611, -0.00219566, -0.00225484, -0.00231362, -0.002372,
  -0.00242997, -0.00248751, -0.00254463, -0.0026013, -0.00265752,
  -0.00271327, -0.00276856, -0.00282336, -0.00287766, -0.00293146,
  -0.00298475, -0.00303752, -0.00308976, -0.00314145, -0.00319259,
  -0.00324317, -0.00329317, -0.0033426, -0.00339144, -0.00343968,
  -0.00348731, -0.00353433, -0.00358072, -0.00362647, -0.00367159,
  -0.00371605, -0.00375985, -0.00380298, -0.00384544, -0.00388721,
  -0.00392829, -0.00396867, -0.00400833, -0.00404729, -0.00408551,
  -0.00412301, -0.00415977, -0.00419578, -0.00423103, -0.00426553,
  -0.00429926, -0.00433221, -0.00436438, -0.00439577, -0.00442636,
  -0.00445615, -0.00448513, -0.00451331, -0.00454066, -0.00456719,
  -0.00459289, -0.00461775, -0.00464177, -0.00466495, -0.00468728,
  -0.00470875, -0.00472936, -0.00474911, -0.00476798, -0.00478599,
  -0.00480311, -0.00481935, -0.00483471, -0.00484918, -0.00486275,
  -0.00487543, -0.00488721, -0.00489808, -0.00490805, -0.00491712,
  -0.00492527, -0.0049325, -0.00493883, -0.00494423, -0.00494872,
  -0.00495228, -0.00495492, -0.00495664, -0.00495743, -0.00495729,
  -0.00495623, -0.00495424, -0.00495132, -0.00494747, -0.00494269,
  -0.00493698, -0.00493034, -0.00492278, -0.00491428, -0.00490486,
  -0.00489451, -0.00488323, -0.00487103, -0.00485791, -0.00484386,
  -0.00482889, -0.00481301, -0.00479621, -0.00477849, -0.00475987,
  -0.00474033, -0.00471989, -0.00469854, -0.0046763, -0.00465316,
  -0.00462912, -0.0046042, -0.00457839, -0.0045517, -0.00452413,
  -0.00449569, -0.00446638, -0.00443621, -0.00440518, -0.00437329,
  -0.00434056, -0.00430698, -0.00427257, -0.00423732, -0.00420125,
  -0.00416436, -0.00412666, -0.00408815, -0.00404884, -0.00400874,
  -0.00396785, -0.00392619, -0.00388375, -0.00384055, -0.00379659,
  -0.00375188, -0.00370644, -0.00366026, -0.00361335, -0.00356574,
  -0.00351741, -0.00346839, -0.00341868, -0.00336829, -0.00331722,
  -0.0032655, -0.00321313, -0.00316011, -0.00310646, -0.00305219,
  -0.00299731, -0.00294183, -0.00288576, -0.0028291, -0.00277188,
  -0.0027141, -0.00265577, -0.00259691, -0.00253752, -0.00247761,
  -0.00241721, -0.00235631, -0.00229493, -0.00223309, -0.0021708,
  -0.00210806, -0.00204489, -0.0019813, -0.00191731, -0.00185293,
  -0.00178816, -0.00172303, -0.00165755, -0.00159172, -0.00152557,
  -0.0014591, -0.00139233, -0.00132528, -0.00125795, -0.00119036,
  -0.00112252, -0.00105445, -0.000986158, -0.000917662, -0.000848976,
  -0.000780113, -0.000711086, -0.000641912, -0.000572602,
  -0.000503173, -0.000433638, -0.000364013, -0.00029431, -0.000224546,
  -0.000154734, -8.48903e-05, -1.50282e-05, 5.4837e-05, 0.000124691,
  0.000194518, 0.000264304, 0.000334033, 0.000403692, 0.000473264,
  0.000542735, 0.000612091, 0.000681315, 0.000750394, 0.000819311,
  0.000888053, 0.000956604, 0.00102495, 0.00109307, 0.00116096,
  0.0012286, 0.00129597, 0.00136306, 0.00142986, 0.00149634,
  0.0015625, 0.00162832, 0.00169379, 0.00175888, 0.00182359,
  0.0018879, 0.0019518, 0.00201527, 0.0020783, 0.00214087, 0.00220297,
  0.00226459, 0.0023257, 0.0023863, 0.00244638, 0.00250591,
  0.00256488, 0.00262329, 0.00268111, 0.00273834, 0.00279495,
  0.00285094, 0.00290629, 0.002961, 0.00301504, 0.0030684, 0.00312107,
  0.00317304, 0.0032243, 0.00327483, 0.00332462, 0.00337366,
  0.00342193, 0.00346943, 0.00351614, 0.00356205, 0.00360715,
  0.00365142, 0.00369487, 0.00373747, 0.00377921, 0.00382009,
  0.00386009, 0.0038992, 0.00393741, 0.00397472, 0.00401111,
  0.00404658, 0.00408111, 0.00411469, 0.00414732, 0.00417898,
  0.00420967, 0.00423938, 0.00426811, 0.00429583, 0.00432255,
  0.00434826, 0.00437295, 0.00439661, 0.00441924, 0.00444082,
  0.00446136, 0.00448084, 0.00449927, 0.00451663, 0.00453291,
  0.00454812, 0.00456225, 0.00457529, 0.00458724, 0.0045981,
  0.00460785, 0.0046165, 0.00462405, 0.00463048, 0.0046358, 0.00464,
  0.00464308, 0.00464504, 0.00464587, 0.00464558, 0.00464416,
  0.00464162, 0.00463794, 0.00463313, 0.0046272, 0.00462013,
  0.00461193, 0.0046026, 0.00459213, 0.00458054, 0.00456782,
  0.00455398, 0.00453901, 0.00452292, 0.0045057, 0.00448737,
  0.00446793, 0.00444737, 0.0044257, 0.00440293, 0.00437906,
  0.00435409, 0.00432803, 0.00430089, 0.00427266, 0.00424335,
  0.00421298, 0.00418154, 0.00414904, 0.00411549, 0.0040809,
  0.00404527, 0.00400861, 0.00397093, 0.00393223, 0.00389253,
  0.00385183, 0.00381014, 0.00376747, 0.00372384, 0.00367924,
  0.00363369, 0.00358721, 0.00353979, 0.00349146, 0.00344222,
  0.00339208, 0.00334106, 0.00328917, 0.00323641, 0.00318281,
  0.00312838, 0.00307312, 0.00301705, 0.00296019, 0.00290255,
  0.00284414, 0.00278497, 0.00272507, 0.00266444, 0.00260311,
  0.00254108, 0.00247837, 0.00241499, 0.00235097, 0.00228632,
  0.00222106, 0.0021552, 0.00208875, 0.00202174, 0.00195419,
  0.0018861, 0.00181751, 0.00174841, 0.00167885, 0.00160882,
  0.00153835, 0.00146747, 0.00139618, 0.0013245, 0.00125247,
  0.00118008, 0.00110737, 0.00103436, 0.000961055, 0.000887486,
  0.00081367, 0.000739628, 0.000665379, 0.000590944, 0.000516343,
  0.000441598, 0.000366728, 0.000291756, 0.000216701, 0.000141584,
  6.64281e-05, -8.74716e-06, -8.39199e-05, -0.000159069, -0.000234172,
  -0.000309209, -0.000384158, -0.000458996, -0.000533703,
  -0.000608256, -0.000682634, -0.000756815, -0.000830777,
  -0.000904499, -0.000977958, -0.00105113, -0.001124, -0.00119654,
  -0.00126873, -0.00134055, -0.00141198, -0.00148299, -0.00155357,
  -0.00162368, -0.00169332, -0.00176245, -0.00183107, -0.00189913,
  -0.00196664, -0.00203355, -0.00209986, -0.00216554, -0.00223057,
  -0.00229493, -0.00235859, -0.00242155, -0.00248377, -0.00254524,
  -0.00260594, -0.00266585, -0.00272494, -0.0027832, -0.00284061,
  -0.00289715, -0.0029528, -0.00300754, -0.00306136, -0.00311422,
  -0.00316613, -0.00321705, -0.00326697, -0.00331588, -0.00336375,
  -0.00341057, -0.00345632, -0.00350099, -0.00354455, -0.003587,
  -0.00362832, -0.00366849, -0.00370749, -0.00374532, -0.00378195,
  -0.00381738, -0.00385159, -0.00388456, -0.00391629, -0.00394676,
  -0.00397595, -0.00400386, -0.00403048, -0.00405579, -0.00407978,
  -0.00410244, -0.00412376, -0.00414373, -0.00416235, -0.0041796,
  -0.00419547, -0.00420996, -0.00422305, -0.00423475, -0.00424504,
  -0.00425392, -0.00426138, -0.00426742, -0.00427203, -0.0042752,
  -0.00427694, -0.00427723, -0.00427608, -0.00427348, -0.00426943,
  -0.00426393, -0.00425698, -0.00424857, -0.00423871, -0.00422739,
  -0.00421462, -0.0042004, -0.00418473, -0.00416761, -0.00414904,
  -0.00412903, -0.00410758, -0.00408469, -0.00406037, -0.00403463,
  -0.00400747, -0.0039789, -0.00394892, -0.00391754, -0.00388477,
  -0.00385062, -0.00381509, -0.0037782, -0.00373996, -0.00370037,
  -0.00365945, -0.00361721, -0.00357366, -0.00352882, -0.00348269,
  -0.00343529, -0.00338664, -0.00333674, -0.00328562, -0.0032333,
  -0.00317978, -0.00312508, -0.00306923, -0.00301223, -0.00295412,
  -0.0028949, -0.00283459, -0.00277323, -0.00271081, -0.00264738,
  -0.00258295, -0.00251753, -0.00245116, -0.00238386, -0.00231565,
  -0.00224655, -0.00217658, -0.00210578, -0.00203417, -0.00196177,
  -0.00188861, -0.00181471, -0.00174011, -0.00166482, -0.00158889,
  -0.00151233, -0.00143517, -0.00135745, -0.00127919, -0.00120042,
  -0.00112117, -0.00104148, -0.000961365, -0.000880868, -0.000800016,
  -0.000718842, -0.000637377, -0.000555653, -0.000473703, -0.00039156,
  -0.000309256, -0.000226826, -0.000144303, -6.17203e-05, 2.0888e-05,
  0.000103487, 0.000186044, 0.000268523, 0.000350889, 0.000433108,
  0.000515145, 0.000596964, 0.00067853, 0.000759809, 0.000840764,
  0.00092136, 0.00100156, 0.00108133, 0.00116064, 0.00123944,
  0.00131771, 0.00139541, 0.0014725, 0.00154894, 0.0016247,
  0.00169976, 0.00177406, 0.00184757, 0.00192027, 0.00199211,
  0.00206307, 0.0021331, 0.00220217, 0.00227025, 0.00233731,
  0.0024033, 0.00246821, 0.00253198, 0.0025946, 0.00265603,
  0.00271624, 0.00277519, 0.00283286, 0.00288921, 0.00294422,
  0.00299784, 0.00305007, 0.00310085, 0.00315017, 0.003198,
  0.00324431, 0.00328907, 0.00333226, 0.00337385, 0.00341382,
  0.00345213, 0.00348877, 0.00352372, 0.00355694, 0.00358843,
  0.00361815, 0.00364608, 0.00367221, 0.00369652, 0.00371899,
  0.0037396, 0.00375834, 0.00377518, 0.00379012, 0.00380313,
  0.00381421, 0.00382335, 0.00383052, 0.00383573, 0.00383896,
  0.0038402, 0.00383944, 0.00383669, 0.00383192, 0.00382514,
  0.00381635, 0.00380553, 0.0037927, 0.00377784, 0.00376096,
  0.00374206, 0.00372115, 0.00369822, 0.00367328, 0.00364634,
  0.0036174, 0.00358648, 0.00355358, 0.00351871, 0.00348188,
  0.00344312, 0.00340242, 0.00335981, 0.0033153, 0.00326891,
  0.00322067, 0.00317058, 0.00311867, 0.00306497, 0.0030095,
  0.00295227, 0.00289333, 0.00283269, 0.00277039, 0.00270645,
  0.0026409, 0.00257379, 0.00250513, 0.00243497, 0.00236335,
  0.00229029, 0.00221584, 0.00214004, 0.00206292, 0.00198454,
  0.00190492, 0.00182412, 0.00174219, 0.00165916, 0.00157508,
  0.00149001, 0.001404, 0.00131709, 0.00122933, 0.00114078,
  0.00105149, 0.000961522, 0.000870923, 0.000779753, 0.000688069,
  0.000595929, 0.000503393, 0.00041052, 0.000317372, 0.000224009,
  0.000130494, 3.68903e-05, -5.67387e-05, -0.000150329, -0.000243815,
  -0.000337132, -0.000430213, -0.000522992, -0.000615403,
  -0.000707376, -0.000798846, -0.000889744, -0.000980001, -0.00106955,
  -0.00115832, -0.00124624, -0.00133325, -0.00141927, -0.00150423,
  -0.00158807, -0.00167072, -0.00175211, -0.00183217, -0.00191083,
  -0.00198802, -0.00206368, -0.00213773, -0.00221012, -0.00228077,
  -0.00234962, -0.00241661, -0.00248166, -0.00254472, -0.00260573,
  -0.00266462, -0.00272133, -0.0027758, -0.00282798, -0.0028778,
  -0.00292521, -0.00297016, -0.0030126, -0.00305246, -0.0030897,
  -0.00312428, -0.00315614, -0.00318525, -0.00321155, -0.003235,
  -0.00325557, -0.00327322, -0.00328792, -0.00329963, -0.00330831,
  -0.00331395, -0.00331652, -0.00331599, -0.00331234, -0.00330556,
  -0.00329562, -0.00328253, -0.00326626, -0.00324681, -0.00322417,
  -0.00319836, -0.00316936, -0.00313718, -0.00310184, -0.00306335,
  -0.00302171, -0.00297696, -0.00292911, -0.00287819, -0.00282423,
  -0.00276726, -0.00270733, -0.00264447, -0.00257872, -0.00251014,
  -0.00243878, -0.0023647, -0.00228795, -0.00220861, -0.00212673,
  -0.00204241, -0.0019557, -0.00186669, -0.00177547, -0.00168213,
  -0.00158677, -0.00148947, -0.00139034, -0.00128949, -0.00118702,
  -0.00108306, -0.000977716, -0.000871116, -0.000763385, -0.000654653,
  -0.000545054, -0.000434727, -0.000323813, -0.000212457,
  -0.000100809, 1.09785e-05, 0.000122751, 0.000234348, 0.000345607,
  0.000456365, 0.000566451, 0.000675696, 0.000783925, 0.000890964,
  0.000996634, 0.00110075, 0.00120314, 0.00130362, 0.001402,
  0.00149809, 0.00159171, 0.00168267, 0.00177079, 0.00185587,
  0.00193774, 0.0020162, 0.00209106, 0.00216215, 0.00222929,
  0.00229229, 0.00235097, 0.00240517, 0.00245472, 0.00249944,
  0.00253917, 0.00257377, 0.00260307, 0.00262694, 0.00264524,
  0.00265784, 0.00266462, 0.00266546, 0.00266026, 0.00264893,
  0.00263138, 0.00260756, 0.00257739, 0.00254084, 0.00249788,
  0.00244849, 0.00239268, 0.00233046, 0.00226187, 0.00218698,
  0.00210585, 0.00201859, 0.00192531, 0.00182618, 0.00172134,
  0.00161101, 0.00149541, 0.00137478, 0.00124943, 0.00111965,
  0.000985809, 0.000848283, 0.000707496, 0.000563907, 0.000418017,
  0.000270366, 0.000121541, -2.78291e-05, -0.000177066, -0.000325442,
  -0.00047218, -0.000616447, -0.000757356, -0.000893962, -0.00102526,
  -0.00115018, -0.00126759, -0.0013763, -0.00147503, -0.00156243,
  -0.0016371, -0.00169754, -0.00174217, -0.00176933, -0.00177727,
  -0.00176416, -0.00172807, -0.00166697, -0.00157874, -0.00146114,
  -0.00131185, -0.00112841, -0.000908272, -0.000648752, -0.000347054,
  -2.5077e-07}; const G4double G4NeutronHPFastLegendre::l27[5601] = {-1,
  -0.869477, -0.747645, -0.634117, -0.52852, -0.430494, -0.33969,
  -0.255771, -0.178412, -0.107299, -0.0421279, 0.0173932, 0.0715469,
  0.120606, 0.164832, 0.204479, 0.239791, 0.271002, 0.29834, 0.322021,
  0.342256, 0.359247, 0.373186, 0.384261, 0.39265, 0.398526, 0.402053,
  0.403391, 0.40269, 0.400097, 0.395751, 0.389786, 0.382329, 0.373503,
  0.363425, 0.352207, 0.339955, 0.326771, 0.312751, 0.29799, 0.282573,
  0.266586, 0.250108, 0.233214, 0.215975, 0.198461, 0.180735,
  0.162857, 0.144886, 0.126876, 0.108877, 0.0909371, 0.073102,
  0.0554135, 0.0379113, 0.0206322, 0.00361057, -0.0131216, -0.0295348,
  -0.0456015, -0.0612965, -0.0765968, -0.0914811, -0.10593, -0.119927,
  -0.133455, -0.1465, -0.159051, -0.171097, -0.182627, -0.193635,
  -0.204112, -0.214055, -0.223459, -0.232321, -0.240639, -0.248412,
  -0.25564, -0.262325, -0.268469, -0.274074, -0.279144, -0.283683,
  -0.287698, -0.291193, -0.294175, -0.29665, -0.298628, -0.300115,
  -0.301121, -0.301654, -0.301724, -0.301341, -0.300514, -0.299255,
  -0.297575, -0.295484, -0.292993, -0.290115, -0.28686, -0.283242,
  -0.279272, -0.274961, -0.270324, -0.26537, -0.260115, -0.254568,
  -0.248744, -0.242655, -0.236312, -0.22973, -0.222919, -0.215893,
  -0.208664, -0.201244, -0.193645, -0.185879, -0.177959, -0.169895,
  -0.161701, -0.153387, -0.144965, -0.136446, -0.127841, -0.119162,
  -0.110419, -0.101622, -0.0927819, -0.0839093, -0.0750138,
  -0.0661054, -0.0571936, -0.0482878, -0.0393972, -0.0305307,
  -0.0216972, -0.0129051, -0.00416273, 0.00452185, 0.0131408,
  0.0216865, 0.0301516, 0.0385289, 0.0468114, 0.0549926, 0.0630659,
  0.0710252, 0.0788644, 0.0865777, 0.0941596, 0.101605, 0.108908,
  0.116065, 0.123071, 0.129921, 0.136611, 0.143138, 0.149497,
  0.155685, 0.161698, 0.167534, 0.17319, 0.178662, 0.18395, 0.189049,
  0.193958, 0.198676, 0.2032, 0.207529, 0.211662, 0.215598, 0.219335,
  0.222872, 0.22621, 0.229348, 0.232285, 0.235022, 0.237558, 0.239893,
  0.242029, 0.243965, 0.245702, 0.247241, 0.248582, 0.249728,
  0.250679, 0.251436, 0.252001, 0.252375, 0.25256, 0.252558, 0.252371,
  0.252001, 0.251449, 0.250719, 0.249812, 0.24873, 0.247477, 0.246055,
  0.244466, 0.242713, 0.240799, 0.238727, 0.236499, 0.23412, 0.231591,
  0.228916, 0.226098, 0.22314, 0.220047, 0.216819, 0.213463, 0.209979,
  0.206373, 0.202648, 0.198806, 0.194853, 0.19079, 0.186622, 0.182352,
  0.177985, 0.173522, 0.16897, 0.164329, 0.159606, 0.154803, 0.149923,
  0.144971, 0.13995, 0.134864, 0.129717, 0.124511, 0.119252, 0.113942,
  0.108585, 0.103184, 0.0977437, 0.092267, 0.0867577, 0.0812192,
  0.0756549, 0.0700683, 0.064463, 0.0588421, 0.0532092, 0.0475676,
  0.0419206, 0.0362714, 0.0306232, 0.0249793, 0.0193429, 0.013717,
  0.0081047, 0.00250904, -0.00306698, -0.00862044, -0.0141484,
  -0.0196481, -0.0251166, -0.0305513, -0.0359493, -0.0413081,
  -0.0466251, -0.0518976, -0.0571232, -0.0622994, -0.0674238,
  -0.0724941, -0.077508, -0.0824633, -0.0873576, -0.092189,
  -0.0969553, -0.101655, -0.106285, -0.110844, -0.11533, -0.119742,
  -0.124078, -0.128335, -0.132513, -0.136609, -0.140623, -0.144552,
  -0.148396, -0.152153, -0.155822, -0.159401, -0.162889, -0.166286,
  -0.16959, -0.172799, -0.175915, -0.178934, -0.181857, -0.184682,
  -0.187409, -0.190038, -0.192567, -0.194996, -0.197325, -0.199553,
  -0.201679, -0.203703, -0.205626, -0.207446, -0.209163, -0.210778,
  -0.21229, -0.213699, -0.215005, -0.216208, -0.217308, -0.218306,
  -0.219201, -0.219993, -0.220684, -0.221272, -0.221759, -0.222145,
  -0.222431, -0.222616, -0.222701, -0.222688, -0.222575, -0.222365,
  -0.222058, -0.221653, -0.221153, -0.220558, -0.219869, -0.219086,
  -0.21821, -0.217243, -0.216185, -0.215037, -0.2138, -0.212475,
  -0.211064, -0.209567, -0.207985, -0.20632, -0.204573, -0.202744,
  -0.200836, -0.198849, -0.196784, -0.194644, -0.192428, -0.190139,
  -0.187778, -0.185346, -0.182844, -0.180274, -0.177638, -0.174936,
  -0.172171, -0.169343, -0.166454, -0.163505, -0.160499, -0.157436,
  -0.154319, -0.151147, -0.147924, -0.144651, -0.141328, -0.137959,
  -0.134544, -0.131084, -0.127582, -0.124039, -0.120457, -0.116836,
  -0.11318, -0.109489, -0.105765, -0.102009, -0.0982233, -0.0944094,
  -0.0905688, -0.0867031, -0.0828139, -0.0789027, -0.0749712,
  -0.0710209, -0.0670533, -0.0630701, -0.0590729, -0.055063,
  -0.0510422, -0.047012, -0.0429738, -0.0389293, -0.0348799,
  -0.0308272, -0.0267726, -0.0227176, -0.0186638, -0.0146125,
  -0.0105653, -0.00652362, -0.00248884, 0.0015376, 0.00555427,
  0.00955979, 0.0135528, 0.0175318, 0.0214956, 0.0254429, 0.0293721,
  0.0332822, 0.0371717, 0.0410393, 0.044884, 0.0487043, 0.052499,
  0.056267, 0.060007, 0.0637179, 0.0673985, 0.0710476, 0.0746642,
  0.0782471, 0.0817953, 0.0853076, 0.0887831, 0.0922207, 0.0956194,
  0.0989782, 0.102296, 0.105572, 0.108806, 0.111995, 0.11514, 0.11824,
  0.121294, 0.1243, 0.127259, 0.130168, 0.133029, 0.135839, 0.138598,
  0.141306, 0.143961, 0.146564, 0.149112, 0.151607, 0.154047,
  0.156431, 0.15876, 0.161032, 0.163247, 0.165405, 0.167504, 0.169546,
  0.171528, 0.173452, 0.175316, 0.17712, 0.178863, 0.180546, 0.182169,
  0.18373, 0.185229, 0.186667, 0.188044, 0.189358, 0.19061, 0.191799,
  0.192926, 0.193991, 0.194992, 0.195931, 0.196808, 0.197621,
  0.198371, 0.199059, 0.199684, 0.200246, 0.200745, 0.201181,
  0.201555, 0.201867, 0.202117, 0.202304, 0.202429, 0.202493,
  0.202495, 0.202436, 0.202315, 0.202134, 0.201892, 0.201591,
  0.201229, 0.200807, 0.200327, 0.199787, 0.199189, 0.198533,
  0.197819, 0.197048, 0.19622, 0.195335, 0.194395, 0.193399, 0.192348,
  0.191242, 0.190083, 0.18887, 0.187604, 0.186286, 0.184916, 0.183495,
  0.182023, 0.180501, 0.17893, 0.17731, 0.175642, 0.173926, 0.172164,
  0.170355, 0.168501, 0.166602, 0.164658, 0.162672, 0.160642,
  0.158571, 0.156458, 0.154305, 0.152112, 0.14988, 0.14761, 0.145302,
  0.142957, 0.140577, 0.138161, 0.135711, 0.133227, 0.13071, 0.128161,
  0.125581, 0.122971, 0.120331, 0.117662, 0.114965, 0.112242,
  0.109492, 0.106716, 0.103916, 0.101092, 0.0982453, 0.0953764,
  0.0924863, 0.0895758, 0.0866458, 0.0836971, 0.0807306, 0.0777471,
  0.0747475, 0.0717326, 0.0687033, 0.0656604, 0.0626048, 0.0595373,
  0.0564589, 0.0533703, 0.0502723, 0.047166, 0.044052, 0.0409312,
  0.0378045, 0.0346726, 0.0315366, 0.0283971, 0.025255, 0.0221111,
  0.0189663, 0.0158214, 0.0126772, 0.00953446, 0.00639405, 0.00325677,
  0.000123397, -0.00300526, -0.00612841, -0.00924527, -0.0123551,
  -0.015457, -0.0185503, -0.0216343, -0.0247081, -0.027771,
  -0.0308223, -0.0338612, -0.036887, -0.039899, -0.0428964,
  -0.0458786, -0.0488448, -0.0517943, -0.0547264, -0.0576405,
  -0.0605359, -0.0634118, -0.0662677, -0.0691029, -0.0719168,
  -0.0747086, -0.0774778, -0.0802238, -0.0829459, -0.0856436,
  -0.0883162, -0.0909631, -0.0935839, -0.0961778, -0.0987444,
  -0.101283, -0.103793, -0.106275, -0.108726, -0.111148, -0.113539,
  -0.115899, -0.118228, -0.120525, -0.122789, -0.12502, -0.127218,
  -0.129383, -0.131513, -0.133608, -0.135668, -0.137693, -0.139682,
  -0.141635, -0.143551, -0.145431, -0.147273, -0.149077, -0.150844,
  -0.152572, -0.154262, -0.155913, -0.157525, -0.159097, -0.16063,
  -0.162123, -0.163575, -0.164987, -0.166359, -0.16769, -0.168979,
  -0.170228, -0.171435, -0.1726, -0.173724, -0.174806, -0.175846,
  -0.176843, -0.177799, -0.178712, -0.179582, -0.18041, -0.181195,
  -0.181938, -0.182637, -0.183294, -0.183908, -0.184479, -0.185007,
  -0.185492, -0.185935, -0.186334, -0.18669, -0.187004, -0.187275,
  -0.187502, -0.187687, -0.18783, -0.18793, -0.187987, -0.188002,
  -0.187975, -0.187905, -0.187793, -0.18764, -0.187444, -0.187207,
  -0.186929, -0.186609, -0.186248, -0.185846, -0.185403, -0.184919,
  -0.184395, -0.183831, -0.183227, -0.182584, -0.181901, -0.181178,
  -0.180417, -0.179617, -0.178778, -0.177901, -0.176987, -0.176035,
  -0.175045, -0.174019, -0.172956, -0.171856, -0.170721, -0.169549,
  -0.168343, -0.167101, -0.165825, -0.164514, -0.16317, -0.161792,
  -0.16038, -0.158936, -0.15746, -0.155951, -0.154411, -0.152839,
  -0.151237, -0.149604, -0.147942, -0.146249, -0.144528, -0.142778,
  -0.140999, -0.139193, -0.13736, -0.135499, -0.133612, -0.131699,
  -0.12976, -0.127796, -0.125808, -0.123796, -0.121759, -0.1197,
  -0.117618, -0.115514, -0.113388, -0.11124, -0.109072, -0.106884,
  -0.104676, -0.102448, -0.100202, -0.0979379, -0.0956558, -0.0933565,
  -0.0910405, -0.0887083, -0.0863604, -0.0839973, -0.0816196,
  -0.0792278, -0.0768223, -0.0744038, -0.0719727, -0.0695295,
  -0.0670749, -0.0646092, -0.0621331, -0.059647, -0.0571515,
  -0.0546472, -0.0521345, -0.0496139, -0.047086, -0.0445514,
  -0.0420104, -0.0394638, -0.0369119, -0.0343554, -0.0317947,
  -0.0292303, -0.0266629, -0.0240928, -0.0215207, -0.018947,
  -0.0163722, -0.013797, -0.0112217, -0.00864687, -0.00607308,
  -0.0035008, -0.00093054, 0.00163719, 0.0042019, 0.00676308,
  0.00932024, 0.0118729, 0.0144205, 0.0169626, 0.0194987, 0.0220284,
  0.0245511, 0.0270663, 0.0295737, 0.0320726, 0.0345627, 0.0370434,
  0.0395144, 0.0419751, 0.0444251, 0.046864, 0.0492912, 0.0517064,
  0.054109, 0.0564987, 0.0588751, 0.0612376, 0.0635859, 0.0659195,
  0.0682381, 0.0705412, 0.0728283, 0.0750991, 0.0773533, 0.0795903,
  0.0818098, 0.0840114, 0.0861947, 0.0883593, 0.090505, 0.0926312,
  0.0947376, 0.0968239, 0.0988897, 0.100935, 0.102958, 0.104961,
  0.106941, 0.108899, 0.110835, 0.112748, 0.114638, 0.116504,
  0.118346, 0.120165, 0.121959, 0.123728, 0.125472, 0.127191,
  0.128885, 0.130553, 0.132195, 0.133811, 0.1354, 0.136962, 0.138497,
  0.140006, 0.141486, 0.142939, 0.144364, 0.145761, 0.14713, 0.14847,
  0.149781, 0.151064, 0.152317, 0.153541, 0.154736, 0.155901,
  0.157036, 0.158142, 0.159217, 0.160263, 0.161277, 0.162262,
  0.163216, 0.164139, 0.165031, 0.165893, 0.166723, 0.167523,
  0.168291, 0.169028, 0.169734, 0.170408, 0.171051, 0.171662,
  0.172241, 0.172789, 0.173305, 0.17379, 0.174243, 0.174664, 0.175053,
  0.175411, 0.175736, 0.17603, 0.176292, 0.176523, 0.176721, 0.176888,
  0.177023, 0.177126, 0.177198, 0.177238, 0.177247, 0.177224, 0.17717,
  0.177084, 0.176967, 0.176818, 0.176639, 0.176428, 0.176187,
  0.175915, 0.175612, 0.175278, 0.174913, 0.174519, 0.174094,
  0.173638, 0.173153, 0.172638, 0.172093, 0.171518, 0.170914,
  0.170281, 0.169618, 0.168927, 0.168206, 0.167457, 0.16668, 0.165874,
  0.16504, 0.164178, 0.163289, 0.162372, 0.161428, 0.160456, 0.159458,
  0.158433, 0.157382, 0.156304, 0.155201, 0.154071, 0.152916,
  0.151736, 0.150531, 0.149301, 0.148047, 0.146768, 0.145465,
  0.144139, 0.142789, 0.141416, 0.14002, 0.138601, 0.13716, 0.135696,
  0.134211, 0.132704, 0.131177, 0.129628, 0.128058, 0.126468,
  0.124858, 0.123228, 0.121579, 0.119911, 0.118224, 0.116518,
  0.114794, 0.113052, 0.111293, 0.109516, 0.107723, 0.105913,
  0.104086, 0.102244, 0.100386, 0.098513, 0.0966249, 0.0947223,
  0.0928054, 0.0908746, 0.0889302, 0.0869726, 0.0850021, 0.0830191,
  0.0810239, 0.0790169, 0.0769984, 0.0749687, 0.0729283, 0.0708774,
  0.0688165, 0.0667459, 0.0646659, 0.0625768, 0.0604792, 0.0583732,
  0.0562593, 0.0541378, 0.0520091, 0.0498735, 0.0477315, 0.0455833,
  0.0434293, 0.0412699, 0.0391054, 0.0369362, 0.0347627, 0.0325852,
  0.030404, 0.0282196, 0.0260323, 0.0238425, 0.0216504, 0.0194565,
  0.0172612, 0.0150647, 0.0128675, 0.0106698, 0.0084721, 0.00627469,
  0.00407794, 0.00188218, -0.000312214, -0.00250491, -0.00469555,
  -0.00688379, -0.00906928, -0.0112517, -0.0134306, -0.0156058,
  -0.0177769, -0.0199435, -0.0221053, -0.024262, -0.0264132,
  -0.0285586, -0.0306978, -0.0328306, -0.0349566, -0.0370755,
  -0.0391869, -0.0412905, -0.0433861, -0.0454732, -0.0475517,
  -0.049621, -0.051681, -0.0537314, -0.0557718, -0.0578019,
  -0.0598214, -0.06183, -0.0638274, -0.0658133, -0.0677875,
  -0.0697496, -0.0716993, -0.0736364, -0.0755605, -0.0774715,
  -0.0793689, -0.0812526, -0.0831222, -0.0849775, -0.0868182,
  -0.0886441, -0.0904548, -0.0922502, -0.09403, -0.0957938,
  -0.0975416, -0.099273, -0.100988, -0.102686, -0.104366, -0.10603,
  -0.107676, -0.109304, -0.110914, -0.112505, -0.114079, -0.115633,
  -0.117169, -0.118686, -0.120183, -0.121661, -0.123119, -0.124557,
  -0.125975, -0.127373, -0.12875, -0.130107, -0.131442, -0.132757,
  -0.134051, -0.135323, -0.136574, -0.137803, -0.13901, -0.140195,
  -0.141358, -0.142499, -0.143617, -0.144713, -0.145786, -0.146836,
  -0.147863, -0.148868, -0.149849, -0.150806, -0.15174, -0.152651,
  -0.153538, -0.154401, -0.155241, -0.156056, -0.156848, -0.157615,
  -0.158358, -0.159077, -0.159772, -0.160442, -0.161087, -0.161708,
  -0.162304, -0.162876, -0.163423, -0.163945, -0.164443, -0.164915,
  -0.165363, -0.165785, -0.166183, -0.166556, -0.166903, -0.167226,
  -0.167524, -0.167796, -0.168044, -0.168266, -0.168463, -0.168636,
  -0.168783, -0.168905, -0.169002, -0.169074, -0.169121, -0.169143,
  -0.16914, -0.169112, -0.16906, -0.168982, -0.16888, -0.168753,
  -0.168601, -0.168425, -0.168224, -0.167999, -0.167749, -0.167474,
  -0.167176, -0.166853, -0.166506, -0.166134, -0.165739, -0.16532,
  -0.164877, -0.164411, -0.16392, -0.163407, -0.162869, -0.162309,
  -0.161725, -0.161118, -0.160488, -0.159835, -0.15916, -0.158462,
  -0.157741, -0.156998, -0.156233, -0.155446, -0.154637, -0.153806,
  -0.152953, -0.152079, -0.151183, -0.150267, -0.149329, -0.14837,
  -0.147391, -0.146391, -0.145371, -0.14433, -0.14327, -0.14219,
  -0.14109, -0.13997, -0.138831, -0.137673, -0.136496, -0.1353,
  -0.134086, -0.132853, -0.131602, -0.130334, -0.129047, -0.127743,
  -0.126421, -0.125083, -0.123727, -0.122355, -0.120966, -0.11956,
  -0.118139, -0.116702, -0.115249, -0.113781, -0.112298, -0.110799,
  -0.109286, -0.107758, -0.106216, -0.10466, -0.103091, -0.101507,
  -0.0999104, -0.0983006, -0.0966779, -0.0950425, -0.0933949,
  -0.091735, -0.0900633, -0.08838, -0.0866853, -0.0849794, -0.0832626,
  -0.0815352, -0.0797974, -0.0780495, -0.0762917, -0.0745243,
  -0.0727475, -0.0709616, -0.0691669, -0.0673636, -0.0655519,
  -0.0637322, -0.0619046, -0.0600695, -0.0582272, -0.0563778,
  -0.0545216, -0.0526589, -0.0507901, -0.0489152, -0.0470346,
  -0.0451487, -0.0432575, -0.0413614, -0.0394607, -0.0375556,
  -0.0356464, -0.0337334, -0.0318168, -0.0298969, -0.0279739,
  -0.0260482, -0.02412, -0.0221895, -0.0202571, -0.0183229,
  -0.0163873, -0.0144506, -0.0125129, -0.0105746, -0.00863585,
  -0.00669703, -0.00475836, -0.00282009, -0.000882507, 0.00105414,
  0.00298959, 0.00492359, 0.00685586, 0.00878614, 0.0107142,
  0.0126397, 0.0145625, 0.0164823, 0.0183988, 0.0203118, 0.022221,
  0.0241262, 0.026027, 0.0279234, 0.0298149, 0.0317014, 0.0335827,
  0.0354584, 0.0373283, 0.0391921, 0.0410497, 0.0429008, 0.0447452,
  0.0465825, 0.0484126, 0.0502353, 0.0520502, 0.0538572, 0.055656,
  0.0574464, 0.0592282, 0.0610011, 0.0627649, 0.0645194, 0.0662643,
  0.0679995, 0.0697247, 0.0714396, 0.0731442, 0.0748381, 0.0765211,
  0.0781931, 0.0798538, 0.0815031, 0.0831406, 0.0847662, 0.0863798,
  0.087981, 0.0895697, 0.0911457, 0.0927089, 0.0942589, 0.0957957,
  0.0973189, 0.0988286, 0.100324, 0.101806, 0.103274, 0.104727,
  0.106165, 0.107589, 0.108998, 0.110392, 0.111771, 0.113134,
  0.114482, 0.115814, 0.11713, 0.11843, 0.119713, 0.120981, 0.122232,
  0.123466, 0.124683, 0.125884, 0.127067, 0.128234, 0.129382,
  0.130514, 0.131628, 0.132724, 0.133802, 0.134862, 0.135904,
  0.136928, 0.137933, 0.13892, 0.139889, 0.140838, 0.141769, 0.142682,
  0.143575, 0.144449, 0.145304, 0.146139, 0.146955, 0.147752,
  0.148529, 0.149287, 0.150025, 0.150743, 0.151442, 0.15212, 0.152779,
  0.153417, 0.154036, 0.154634, 0.155212, 0.15577, 0.156307, 0.156824,
  0.157321, 0.157797, 0.158252, 0.158687, 0.159102, 0.159496,
  0.159869, 0.160221, 0.160553, 0.160864, 0.161155, 0.161424,
  0.161673, 0.161901, 0.162108, 0.162295, 0.16246, 0.162605, 0.162729,
  0.162832, 0.162915, 0.162976, 0.163017, 0.163037, 0.163036,
  0.163015, 0.162973, 0.16291, 0.162826, 0.162722, 0.162597, 0.162452,
  0.162286, 0.1621, 0.161893, 0.161666, 0.161419, 0.161151, 0.160863,
  0.160555, 0.160226, 0.159878, 0.159509, 0.159121, 0.158713,
  0.158285, 0.157837, 0.157369, 0.156882, 0.156375, 0.155849,
  0.155304, 0.154739, 0.154156, 0.153553, 0.152931, 0.15229, 0.15163,
  0.150952, 0.150255, 0.14954, 0.148806, 0.148054, 0.147284, 0.146495,
  0.145689, 0.144865, 0.144023, 0.143164, 0.142287, 0.141393,
  0.140481, 0.139553, 0.138607, 0.137645, 0.136666, 0.135671,
  0.134659, 0.13363, 0.132586, 0.131526, 0.130449, 0.129358, 0.12825,
  0.127127, 0.125989, 0.124836, 0.123668, 0.122485, 0.121287,
  0.120075, 0.118849, 0.117608, 0.116354, 0.115085, 0.113803,
  0.112508, 0.111199, 0.109877, 0.108542, 0.107195, 0.105834,
  0.104462, 0.103077, 0.10168, 0.100271, 0.0988504, 0.0974183,
  0.0959748, 0.0945202, 0.0930546, 0.0915783, 0.0900913, 0.0885939,
  0.0870864, 0.0855688, 0.0840414, 0.0825043, 0.0809579, 0.0794022,
  0.0778374, 0.0762638, 0.0746815, 0.0730909, 0.0714919, 0.0698849,
  0.0682701, 0.0666476, 0.0650177, 0.0633806, 0.0617364, 0.0600854,
  0.0584278, 0.0567638, 0.0550936, 0.0534173, 0.0517353, 0.0500477,
  0.0483547, 0.0466565, 0.0449534, 0.0432456, 0.0415331, 0.0398164,
  0.0380956, 0.0363708, 0.0346423, 0.0329104, 0.0311752, 0.0294369,
  0.0276957, 0.0259519, 0.0242057, 0.0224573, 0.0207068, 0.0189546,
  0.0172008, 0.0154456, 0.0136892, 0.0119319, 0.0101739, 0.00841531,
  0.00665642, 0.00489742, 0.00313853, 0.00137995, -0.000378112,
  -0.00213544, -0.00389182, -0.00564705, -0.00740092, -0.00915323,
  -0.0109038, -0.0126523, -0.0143987, -0.0161426, -0.017884,
  -0.0196226, -0.0213581, -0.0230905, -0.0248194, -0.0265447,
  -0.0282662, -0.0299836, -0.0316969, -0.0334057, -0.0351099,
  -0.0368092, -0.0385036, -0.0401927, -0.0418764, -0.0435545,
  -0.0452269, -0.0468932, -0.0485533, -0.0502071, -0.0518543,
  -0.0534947, -0.0551282, -0.0567546, -0.0583736, -0.0599851,
  -0.061589, -0.063185, -0.0647729, -0.0663526, -0.0679239,
  -0.0694865, -0.0710404, -0.0725854, -0.0741213, -0.0756478,
  -0.0771649, -0.0786723, -0.08017, -0.0816576, -0.0831352,
  -0.0846024, -0.0860591, -0.0875052, -0.0889405, -0.0903649,
  -0.0917781, -0.0931801, -0.0945706, -0.0959496, -0.0973168,
  -0.0986722, -0.100015, -0.101347, -0.102665, -0.103972, -0.105265,
  -0.106546, -0.107814, -0.109069, -0.110311, -0.11154, -0.112755,
  -0.113956, -0.115144, -0.116318, -0.117478, -0.118624, -0.119756,
  -0.120873, -0.121976, -0.123065, -0.124138, -0.125197, -0.126241,
  -0.12727, -0.128284, -0.129283, -0.130266, -0.131234, -0.132187,
  -0.133123, -0.134044, -0.134949, -0.135839, -0.136712, -0.137569,
  -0.13841, -0.139235, -0.140043, -0.140835, -0.14161, -0.142369,
  -0.143111, -0.143836, -0.144545, -0.145236, -0.145911, -0.146568,
  -0.147209, -0.147832, -0.148438, -0.149027, -0.149599, -0.150153,
  -0.15069, -0.151209, -0.151711, -0.152195, -0.152661, -0.15311,
  -0.153542, -0.153955, -0.154351, -0.154729, -0.155089, -0.155431,
  -0.155755, -0.156062, -0.15635, -0.156621, -0.156873, -0.157108,
  -0.157324, -0.157523, -0.157703, -0.157866, -0.15801, -0.158137,
  -0.158245, -0.158335, -0.158407, -0.158462, -0.158498, -0.158516,
  -0.158516, -0.158498, -0.158462, -0.158408, -0.158336, -0.158246,
  -0.158139, -0.158013, -0.157869, -0.157708, -0.157529, -0.157332,
  -0.157117, -0.156885, -0.156634, -0.156367, -0.156081, -0.155778,
  -0.155458, -0.15512, -0.154765, -0.154392, -0.154002, -0.153595,
  -0.153171, -0.152729, -0.15227, -0.151795, -0.151302, -0.150793,
  -0.150266, -0.149723, -0.149164, -0.148587, -0.147995, -0.147385,
  -0.14676, -0.146118, -0.14546, -0.144785, -0.144095, -0.143389,
  -0.142667, -0.141929, -0.141175, -0.140406, -0.139622, -0.138822,
  -0.138006, -0.137176, -0.13633, -0.135469, -0.134594, -0.133704,
  -0.132799, -0.131879, -0.130945, -0.129997, -0.129035, -0.128058,
  -0.127068, -0.126063, -0.125045, -0.124013, -0.122968, -0.121909,
  -0.120837, -0.119752, -0.118654, -0.117543, -0.11642, -0.115283,
  -0.114135, -0.112974, -0.1118, -0.110615, -0.109418, -0.108209,
  -0.106988, -0.105756, -0.104512, -0.103257, -0.101992, -0.100715,
  -0.0994272, -0.0981291, -0.0968204, -0.0955015, -0.0941723,
  -0.0928331, -0.0914841, -0.0901253, -0.088757, -0.0873793,
  -0.0859923, -0.0845963, -0.0831913, -0.0817775, -0.0803552,
  -0.0789244, -0.0774853, -0.076038, -0.0745829, -0.0731199,
  -0.0716493, -0.0701712, -0.0686858, -0.0671934, -0.0656939,
  -0.0641876, -0.0626748, -0.0611554, -0.0596298, -0.0580981,
  -0.0565604, -0.055017, -0.0534679, -0.0519134, -0.0503537,
  -0.0487889, -0.0472192, -0.0456448, -0.0440657, -0.0424824,
  -0.0408948, -0.0393031, -0.0377077, -0.0361085, -0.0345058,
  -0.0328999, -0.0312907, -0.0296786, -0.0280637, -0.0264462,
  -0.0248262, -0.023204, -0.0215797, -0.0199535, -0.0183255,
  -0.016696, -0.0150652, -0.0134331, -0.0118, -0.0101661, -0.00853151,
  -0.00689645, -0.00526108, -0.00362558, -0.00199013, -0.00035491,
  0.00127991, 0.00291414, 0.00454762, 0.00618017, 0.0078116,
  0.00944175, 0.0110704, 0.0126975, 0.0143227, 0.015946, 0.0175671,
  0.0191858, 0.020802, 0.0224156, 0.0240263, 0.025634, 0.0272385,
  0.0288396, 0.0304371, 0.032031, 0.0336209, 0.0352068, 0.0367885,
  0.0383658, 0.0399386, 0.0415066, 0.0430697, 0.0446278, 0.0461807,
  0.0477281, 0.0492701, 0.0508063, 0.0523366, 0.0538609, 0.055379,
  0.0568908, 0.058396, 0.0598946, 0.0613863, 0.062871, 0.0643486,
  0.065819, 0.0672818, 0.0687371, 0.0701846, 0.0716241, 0.0730557,
  0.074479, 0.075894, 0.0773004, 0.0786982, 0.0800873, 0.0814673,
  0.0828384, 0.0842001, 0.0855526, 0.0868955, 0.0882287, 0.0895522,
  0.0908658, 0.0921693, 0.0934627, 0.0947457, 0.0960183, 0.0972803,
  0.0985316, 0.099772, 0.101001, 0.10222, 0.103427, 0.104623,
  0.105807, 0.10698, 0.108141, 0.10929, 0.110428, 0.111553, 0.112666,
  0.113767, 0.114856, 0.115932, 0.116995, 0.118046, 0.119084,
  0.120109, 0.12112, 0.122119, 0.123105, 0.124077, 0.125036, 0.125981,
  0.126913, 0.127831, 0.128735, 0.129626, 0.130502, 0.131364,
  0.132213, 0.133047, 0.133866, 0.134672, 0.135462, 0.136239, 0.137,
  0.137748, 0.13848, 0.139197, 0.1399, 0.140587, 0.14126, 0.141917,
  0.14256, 0.143187, 0.143799, 0.144395, 0.144976, 0.145542, 0.146092,
  0.146627, 0.147146, 0.147649, 0.148137, 0.148609, 0.149065,
  0.149505, 0.14993, 0.150339, 0.150731, 0.151108, 0.151469, 0.151814,
  0.152142, 0.152455, 0.152751, 0.153032, 0.153296, 0.153544,
  0.153776, 0.153992, 0.154191, 0.154374, 0.154541, 0.154692,
  0.154826, 0.154945, 0.155046, 0.155132, 0.155201, 0.155254,
  0.155291, 0.155312, 0.155316, 0.155304, 0.155275, 0.155231, 0.15517,
  0.155093, 0.155, 0.15489, 0.154765, 0.154623, 0.154465, 0.154291,
  0.154101, 0.153895, 0.153672, 0.153434, 0.15318, 0.15291, 0.152624,
  0.152322, 0.152005, 0.151671, 0.151322, 0.150957, 0.150576, 0.15018,
  0.149769, 0.149341, 0.148899, 0.148441, 0.147967, 0.147478,
  0.146974, 0.146455, 0.145921, 0.145372, 0.144807, 0.144228,
  0.143634, 0.143025, 0.142401, 0.141763, 0.14111, 0.140442, 0.13976,
  0.139064, 0.138354, 0.137629, 0.13689, 0.136137, 0.13537, 0.134589,
  0.133795, 0.132987, 0.132165, 0.131329, 0.130481, 0.129619,
  0.128743, 0.127855, 0.126953, 0.126039, 0.125111, 0.124171,
  0.123218, 0.122253, 0.121275, 0.120285, 0.119283, 0.118268,
  0.117242, 0.116204, 0.115153, 0.114092, 0.113018, 0.111933,
  0.110837, 0.10973, 0.108611, 0.107482, 0.106342, 0.105191, 0.104029,
  0.102857, 0.101674, 0.100481, 0.0992786, 0.0980658, 0.0968431,
  0.0956106, 0.0943686, 0.0931171, 0.0918563, 0.0905862, 0.0893071,
  0.0880191, 0.0867222, 0.0854167, 0.0841027, 0.0827803, 0.0814496,
  0.0801108, 0.0787641, 0.0774095, 0.0760472, 0.0746774, 0.0733002,
  0.0719157, 0.0705241, 0.0691256, 0.0677202, 0.0663081, 0.0648895,
  0.0634645, 0.0620333, 0.060596, 0.0591528, 0.0577037, 0.056249,
  0.0547889, 0.0533234, 0.0518527, 0.0503769, 0.0488963, 0.047411,
  0.0459211, 0.0444267, 0.0429281, 0.0414254, 0.0399187, 0.0384082,
  0.036894, 0.0353764, 0.0338554, 0.0323312, 0.030804, 0.0292739,
  0.0277411, 0.0262058, 0.024668, 0.023128, 0.021586, 0.020042,
  0.0184962, 0.0169488, 0.0153999, 0.0138498, 0.0122985, 0.0107462,
  0.00919308, 0.00763931, 0.00608503, 0.00453039, 0.00297556,
  0.0014207, -0.000134046, -0.00168851, -0.00324254, -0.00479598,
  -0.00634866, -0.00790044, -0.00945116, -0.0110006, -0.0125488,
  -0.0140953, -0.0156402, -0.0171833, -0.0187243, -0.0202632,
  -0.0217998, -0.0233339, -0.0248654, -0.0263941, -0.0279199,
  -0.0294426, -0.0309621, -0.0324782, -0.0339907, -0.0354996,
  -0.0370046, -0.0385056, -0.0400025, -0.0414951, -0.0429833,
  -0.0444668, -0.0459457, -0.0474196, -0.0488885, -0.0503522,
  -0.0518106, -0.0532636, -0.0547109, -0.0561525, -0.0575881,
  -0.0590177, -0.0604412, -0.0618583, -0.0632689, -0.0646729,
  -0.0660702, -0.0674606, -0.068844, -0.0702202, -0.0715891,
  -0.0729505, -0.0743044, -0.0756506, -0.076989, -0.0783194,
  -0.0796417, -0.0809558, -0.0822615, -0.0835588, -0.0848474,
  -0.0861273, -0.0873983, -0.0886603, -0.0899132, -0.0911569,
  -0.0923912, -0.093616, -0.0948313, -0.0960368, -0.0972325,
  -0.0984182, -0.0995938, -0.100759, -0.101914, -0.103059, -0.104193,
  -0.105317, -0.10643, -0.107532, -0.108623, -0.109703, -0.110772,
  -0.111829, -0.112875, -0.11391, -0.114933, -0.115945, -0.116944,
  -0.117932, -0.118908, -0.119872, -0.120823, -0.121763, -0.12269,
  -0.123604, -0.124506, -0.125396, -0.126273, -0.127137, -0.127988,
  -0.128826, -0.129651, -0.130464, -0.131263, -0.132048, -0.132821,
  -0.13358, -0.134325, -0.135057, -0.135776, -0.136481, -0.137172,
  -0.137849, -0.138512, -0.139162, -0.139797, -0.140419, -0.141026,
  -0.141619, -0.142198, -0.142763, -0.143313, -0.143849, -0.14437,
  -0.144878, -0.14537, -0.145848, -0.146311, -0.14676, -0.147194,
  -0.147613, -0.148018, -0.148408, -0.148783, -0.149143, -0.149488,
  -0.149818, -0.150133, -0.150433, -0.150718, -0.150989, -0.151244,
  -0.151484, -0.151709, -0.151918, -0.152113, -0.152293, -0.152457,
  -0.152606, -0.15274, -0.152859, -0.152962, -0.153051, -0.153124,
  -0.153182, -0.153224, -0.153252, -0.153264, -0.153261, -0.153243,
  -0.153209, -0.15316, -0.153097, -0.153018, -0.152923, -0.152814,
  -0.152689, -0.15255, -0.152395, -0.152225, -0.15204, -0.15184,
  -0.151625, -0.151395, -0.15115, -0.15089, -0.150615, -0.150325,
  -0.150021, -0.149701, -0.149367, -0.149018, -0.148654, -0.148276,
  -0.147883, -0.147475, -0.147053, -0.146616, -0.146165, -0.1457,
  -0.14522, -0.144725, -0.144217, -0.143694, -0.143158, -0.142607,
  -0.142042, -0.141463, -0.14087, -0.140263, -0.139643, -0.139008,
  -0.138361, -0.137699, -0.137024, -0.136336, -0.135634, -0.134919,
  -0.13419, -0.133449, -0.132694, -0.131926, -0.131146, -0.130352,
  -0.129546, -0.128727, -0.127896, -0.127052, -0.126195, -0.125326,
  -0.124445, -0.123552, -0.122646, -0.121729, -0.1208, -0.119859,
  -0.118906, -0.117942, -0.116966, -0.115978, -0.11498, -0.11397,
  -0.112949, -0.111917, -0.110874, -0.10982, -0.108756, -0.107681,
  -0.106596, -0.1055, -0.104394, -0.103277, -0.102151, -0.101015,
  -0.0998686, -0.0987128, -0.0975475, -0.0963726, -0.0951884,
  -0.093995, -0.0927924, -0.0915809, -0.0903604, -0.0891312,
  -0.0878934, -0.0866471, -0.0853924, -0.0841294, -0.0828582,
  -0.0815791, -0.0802921, -0.0789973, -0.0776949, -0.076385,
  -0.0750677, -0.0737431, -0.0724115, -0.0710729, -0.0697274,
  -0.0683753, -0.0670165, -0.0656513, -0.0642798, -0.0629021,
  -0.0615184, -0.0601288, -0.0587334, -0.0573324, -0.0559259,
  -0.054514, -0.0530969, -0.0516748, -0.0502477, -0.0488158,
  -0.0473793, -0.0459383, -0.0444929, -0.0430433, -0.0415895,
  -0.0401319, -0.0386704, -0.0372053, -0.0357367, -0.0342647,
  -0.0327895, -0.0313112, -0.02983, -0.028346, -0.0268593, -0.0253701,
  -0.0238786, -0.0223849, -0.0208891, -0.0193914, -0.017892,
  -0.0163909, -0.0148883, -0.0133845, -0.0118794, -0.0103733,
  -0.00886631, -0.00735859, -0.00585027, -0.0043415, -0.00283244,
  -0.00132323, 0.000185991, 0.00169507, 0.00320385, 0.0047122,
  0.00621997, 0.00772701, 0.00923317, 0.0107383, 0.0122423, 0.0137449,
  0.0152461, 0.0167457, 0.0182435, 0.0197394, 0.0212333, 0.022725,
  0.0242144, 0.0257013, 0.0271855, 0.028667, 0.0301456, 0.0316211,
  0.0330934, 0.0345624, 0.0360279, 0.0374898, 0.0389479, 0.0404021,
  0.0418523, 0.0432983, 0.0447399, 0.0461771, 0.0476096, 0.0490375,
  0.0504604, 0.0518783, 0.0532911, 0.0546985, 0.0561006, 0.057497,
  0.0588878, 0.0602727, 0.0616517, 0.0630246, 0.0643912, 0.0657514,
  0.0671052, 0.0684523, 0.0697927, 0.0711262, 0.0724527, 0.073772,
  0.0750841, 0.0763887, 0.0776859, 0.0789754, 0.0802571, 0.0815309,
  0.0827967, 0.0840544, 0.0853038, 0.0865449, 0.0877774, 0.0890013,
  0.0902165, 0.0914228, 0.0926202, 0.0938085, 0.0949876, 0.0961574,
  0.0973177, 0.0984685, 0.0996097, 0.100741, 0.101863, 0.102974,
  0.104076, 0.105167, 0.106248, 0.107319, 0.108379, 0.109429,
  0.110468, 0.111496, 0.112513, 0.113519, 0.114514, 0.115498,
  0.116471, 0.117432, 0.118382, 0.11932, 0.120247, 0.121162, 0.122065,
  0.122956, 0.123836, 0.124703, 0.125558, 0.126401, 0.127231,
  0.128049, 0.128855, 0.129648, 0.130429, 0.131196, 0.131951,
  0.132694, 0.133423, 0.134139, 0.134842, 0.135532, 0.136209,
  0.136873, 0.137524, 0.138161, 0.138784, 0.139394, 0.139991,
  0.140574, 0.141143, 0.141699, 0.142241, 0.142769, 0.143283,
  0.143783, 0.14427, 0.144742, 0.1452, 0.145644, 0.146074, 0.14649,
  0.146892, 0.147279, 0.147653, 0.148011, 0.148356, 0.148686,
  0.149002, 0.149303, 0.14959, 0.149862, 0.15012, 0.150363, 0.150591,
  0.150806, 0.151005, 0.15119, 0.15136, 0.151515, 0.151656, 0.151783,
  0.151894, 0.151991, 0.152073, 0.15214, 0.152193, 0.152231, 0.152254,
  0.152262, 0.152256, 0.152235, 0.152199, 0.152149, 0.152083,
  0.152004, 0.151909, 0.1518, 0.151676, 0.151537, 0.151384, 0.151216,
  0.151033, 0.150836, 0.150625, 0.150398, 0.150158, 0.149902,
  0.149632, 0.149348, 0.14905, 0.148737, 0.148409, 0.148067, 0.147711,
  0.147341, 0.146956, 0.146558, 0.146145, 0.145718, 0.145277,
  0.144822, 0.144353, 0.14387, 0.143373, 0.142862, 0.142337, 0.141799,
  0.141247, 0.140682, 0.140103, 0.13951, 0.138904, 0.138284, 0.137652,
  0.137005, 0.136346, 0.135674, 0.134988, 0.134289, 0.133578,
  0.132854, 0.132116, 0.131366, 0.130604, 0.129829, 0.129041,
  0.128241, 0.127428, 0.126603, 0.125766, 0.124917, 0.124056,
  0.123183, 0.122298, 0.121401, 0.120493, 0.119572, 0.118641,
  0.117698, 0.116743, 0.115778, 0.114801, 0.113813, 0.112814,
  0.111805, 0.110784, 0.109753, 0.108711, 0.107659, 0.106597,
  0.105524, 0.104441, 0.103348, 0.102245, 0.101132, 0.10001,
  0.0988775, 0.0977359, 0.0965848, 0.0954244, 0.0942548, 0.0930761,
  0.0918885, 0.090692, 0.0894868, 0.088273, 0.0870507, 0.08582,
  0.0845811, 0.083334, 0.0820789, 0.0808159, 0.0795451, 0.0782667,
  0.0769807, 0.0756873, 0.0743867, 0.0730788, 0.071764, 0.0704422,
  0.0691137, 0.0677785, 0.0664368, 0.0650887, 0.0637344, 0.0623739,
  0.0610074, 0.059635, 0.0582569, 0.0568732, 0.055484, 0.0540895,
  0.0526898, 0.051285, 0.0498753, 0.0484608, 0.0470416, 0.0456179,
  0.0441898, 0.0427574, 0.041321, 0.0398805, 0.0384363, 0.0369883,
  0.0355368, 0.0340819, 0.0326236, 0.0311623, 0.0296979, 0.0282307,
  0.0267608, 0.0252883, 0.0238134, 0.0223361, 0.0208568, 0.0193754,
  0.0178922, 0.0164072, 0.0149207, 0.0134327, 0.0119434, 0.010453,
  0.00896159, 0.00746931, 0.00597631, 0.00448273, 0.00298873,
  0.00149444, -0, -0.00149444, -0.00298873, -0.00448273, -0.00597631,
  -0.00746931, -0.00896159, -0.010453, -0.0119434, -0.0134327,
  -0.0149207, -0.0164072, -0.0178922, -0.0193754, -0.0208568,
  -0.0223361, -0.0238134, -0.0252883, -0.0267608, -0.0282307,
  -0.0296979, -0.0311623, -0.0326236, -0.0340819, -0.0355368,
  -0.0369883, -0.0384363, -0.0398805, -0.041321, -0.0427574,
  -0.0441898, -0.0456179, -0.0470416, -0.0484608, -0.0498753,
  -0.051285, -0.0526898, -0.0540895, -0.055484, -0.0568732,
  -0.0582569, -0.059635, -0.0610074, -0.0623739, -0.0637344,
  -0.0650887, -0.0664368, -0.0677785, -0.0691137, -0.0704422,
  -0.071764, -0.0730788, -0.0743867, -0.0756873, -0.0769807,
  -0.0782667, -0.0795451, -0.0808159, -0.0820789, -0.083334,
  -0.0845811, -0.08582, -0.0870507, -0.088273, -0.0894868, -0.090692,
  -0.0918885, -0.0930761, -0.0942548, -0.0954244, -0.0965848,
  -0.0977359, -0.0988775, -0.10001, -0.101132, -0.102245, -0.103348,
  -0.104441, -0.105524, -0.106597, -0.107659, -0.108711, -0.109753,
  -0.110784, -0.111805, -0.112814, -0.113813, -0.114801, -0.115778,
  -0.116743, -0.117698, -0.118641, -0.119572, -0.120493, -0.121401,
  -0.122298, -0.123183, -0.124056, -0.124917, -0.125766, -0.126603,
  -0.127428, -0.128241, -0.129041, -0.129829, -0.130604, -0.131366,
  -0.132116, -0.132854, -0.133578, -0.134289, -0.134988, -0.135674,
  -0.136346, -0.137005, -0.137652, -0.138284, -0.138904, -0.13951,
  -0.140103, -0.140682, -0.141247, -0.141799, -0.142337, -0.142862,
  -0.143373, -0.14387, -0.144353, -0.144822, -0.145277, -0.145718,
  -0.146145, -0.146558, -0.146956, -0.147341, -0.147711, -0.148067,
  -0.148409, -0.148737, -0.14905, -0.149348, -0.149632, -0.149902,
  -0.150158, -0.150398, -0.150625, -0.150836, -0.151033, -0.151216,
  -0.151384, -0.151537, -0.151676, -0.1518, -0.151909, -0.152004,
  -0.152083, -0.152149, -0.152199, -0.152235, -0.152256, -0.152262,
  -0.152254, -0.152231, -0.152193, -0.15214, -0.152073, -0.151991,
  -0.151894, -0.151783, -0.151656, -0.151515, -0.15136, -0.15119,
  -0.151005, -0.150806, -0.150591, -0.150363, -0.15012, -0.149862,
  -0.14959, -0.149303, -0.149002, -0.148686, -0.148356, -0.148011,
  -0.147653, -0.147279, -0.146892, -0.14649, -0.146074, -0.145644,
  -0.1452, -0.144742, -0.14427, -0.143783, -0.143283, -0.142769,
  -0.142241, -0.141699, -0.141143, -0.140574, -0.139991, -0.139394,
  -0.138784, -0.138161, -0.137524, -0.136873, -0.136209, -0.135532,
  -0.134842, -0.134139, -0.133423, -0.132694, -0.131951, -0.131196,
  -0.130429, -0.129648, -0.128855, -0.128049, -0.127231, -0.126401,
  -0.125558, -0.124703, -0.123836, -0.122956, -0.122065, -0.121162,
  -0.120247, -0.11932, -0.118382, -0.117432, -0.116471, -0.115498,
  -0.114514, -0.113519, -0.112513, -0.111496, -0.110468, -0.109429,
  -0.108379, -0.107319, -0.106248, -0.105167, -0.104076, -0.102974,
  -0.101863, -0.100741, -0.0996097, -0.0984685, -0.0973177,
  -0.0961574, -0.0949876, -0.0938085, -0.0926202, -0.0914228,
  -0.0902165, -0.0890013, -0.0877774, -0.0865449, -0.0853038,
  -0.0840544, -0.0827967, -0.0815309, -0.0802571, -0.0789754,
  -0.0776859, -0.0763887, -0.0750841, -0.073772, -0.0724527,
  -0.0711262, -0.0697927, -0.0684523, -0.0671052, -0.0657514,
  -0.0643912, -0.0630246, -0.0616517, -0.0602727, -0.0588878,
  -0.057497, -0.0561006, -0.0546985, -0.0532911, -0.0518783,
  -0.0504604, -0.0490375, -0.0476096, -0.0461771, -0.0447399,
  -0.0432983, -0.0418523, -0.0404021, -0.0389479, -0.0374898,
  -0.0360279, -0.0345624, -0.0330934, -0.0316211, -0.0301456,
  -0.028667, -0.0271855, -0.0257013, -0.0242144, -0.022725,
  -0.0212333, -0.0197394, -0.0182435, -0.0167457, -0.0152461,
  -0.0137449, -0.0122423, -0.0107383, -0.00923317, -0.00772701,
  -0.00621997, -0.0047122, -0.00320385, -0.00169507, -0.000185991,
  0.00132323, 0.00283244, 0.0043415, 0.00585027, 0.00735859,
  0.00886631, 0.0103733, 0.0118794, 0.0133845, 0.0148883, 0.0163909,
  0.017892, 0.0193914, 0.0208891, 0.0223849, 0.0238786, 0.0253701,
  0.0268593, 0.028346, 0.02983, 0.0313112, 0.0327895, 0.0342647,
  0.0357367, 0.0372053, 0.0386704, 0.0401319, 0.0415895, 0.0430433,
  0.0444929, 0.0459383, 0.0473793, 0.0488158, 0.0502477, 0.0516748,
  0.0530969, 0.054514, 0.0559259, 0.0573324, 0.0587334, 0.0601288,
  0.0615184, 0.0629021, 0.0642798, 0.0656513, 0.0670165, 0.0683753,
  0.0697274, 0.0710729, 0.0724115, 0.0737431, 0.0750677, 0.076385,
  0.0776949, 0.0789973, 0.0802921, 0.0815791, 0.0828582, 0.0841294,
  0.0853924, 0.0866471, 0.0878934, 0.0891312, 0.0903604, 0.0915809,
  0.0927924, 0.093995, 0.0951884, 0.0963726, 0.0975475, 0.0987128,
  0.0998686, 0.101015, 0.102151, 0.103277, 0.104394, 0.1055, 0.106596,
  0.107681, 0.108756, 0.10982, 0.110874, 0.111917, 0.112949, 0.11397,
  0.11498, 0.115978, 0.116966, 0.117942, 0.118906, 0.119859, 0.1208,
  0.121729, 0.122646, 0.123552, 0.124445, 0.125326, 0.126195,
  0.127052, 0.127896, 0.128727, 0.129546, 0.130352, 0.131146,
  0.131926, 0.132694, 0.133449, 0.13419, 0.134919, 0.135634, 0.136336,
  0.137024, 0.137699, 0.138361, 0.139008, 0.139643, 0.140263, 0.14087,
  0.141463, 0.142042, 0.142607, 0.143158, 0.143694, 0.144217,
  0.144725, 0.14522, 0.1457, 0.146165, 0.146616, 0.147053, 0.147475,
  0.147883, 0.148276, 0.148654, 0.149018, 0.149367, 0.149701,
  0.150021, 0.150325, 0.150615, 0.15089, 0.15115, 0.151395, 0.151625,
  0.15184, 0.15204, 0.152225, 0.152395, 0.15255, 0.152689, 0.152814,
  0.152923, 0.153018, 0.153097, 0.15316, 0.153209, 0.153243, 0.153261,
  0.153264, 0.153252, 0.153224, 0.153182, 0.153124, 0.153051,
  0.152962, 0.152859, 0.15274, 0.152606, 0.152457, 0.152293, 0.152113,
  0.151918, 0.151709, 0.151484, 0.151244, 0.150989, 0.150718,
  0.150433, 0.150133, 0.149818, 0.149488, 0.149143, 0.148783,
  0.148408, 0.148018, 0.147613, 0.147194, 0.14676, 0.146311, 0.145848,
  0.14537, 0.144878, 0.14437, 0.143849, 0.143313, 0.142763, 0.142198,
  0.141619, 0.141026, 0.140419, 0.139797, 0.139162, 0.138512,
  0.137849, 0.137172, 0.136481, 0.135776, 0.135057, 0.134325, 0.13358,
  0.132821, 0.132048, 0.131263, 0.130464, 0.129651, 0.128826,
  0.127988, 0.127137, 0.126273, 0.125396, 0.124506, 0.123604, 0.12269,
  0.121763, 0.120823, 0.119872, 0.118908, 0.117932, 0.116944,
  0.115945, 0.114933, 0.11391, 0.112875, 0.111829, 0.110772, 0.109703,
  0.108623, 0.107532, 0.10643, 0.105317, 0.104193, 0.103059, 0.101914,
  0.100759, 0.0995938, 0.0984182, 0.0972325, 0.0960368, 0.0948313,
  0.093616, 0.0923912, 0.0911569, 0.0899132, 0.0886603, 0.0873983,
  0.0861273, 0.0848474, 0.0835588, 0.0822615, 0.0809558, 0.0796417,
  0.0783194, 0.076989, 0.0756506, 0.0743044, 0.0729505, 0.0715891,
  0.0702202, 0.068844, 0.0674606, 0.0660702, 0.0646729, 0.0632689,
  0.0618583, 0.0604412, 0.0590177, 0.0575881, 0.0561525, 0.0547109,
  0.0532636, 0.0518106, 0.0503522, 0.0488885, 0.0474196, 0.0459457,
  0.0444668, 0.0429833, 0.0414951, 0.0400025, 0.0385056, 0.0370046,
  0.0354996, 0.0339907, 0.0324782, 0.0309621, 0.0294426, 0.0279199,
  0.0263941, 0.0248654, 0.0233339, 0.0217998, 0.0202632, 0.0187243,
  0.0171833, 0.0156402, 0.0140953, 0.0125488, 0.0110006, 0.00945116,
  0.00790044, 0.00634866, 0.00479598, 0.00324254, 0.00168851,
  0.000134046, -0.0014207, -0.00297556, -0.00453039, -0.00608503,
  -0.00763931, -0.00919308, -0.0107462, -0.0122985, -0.0138498,
  -0.0153999, -0.0169488, -0.0184962, -0.020042, -0.021586, -0.023128,
  -0.024668, -0.0262058, -0.0277411, -0.0292739, -0.030804,
  -0.0323312, -0.0338554, -0.0353764, -0.036894, -0.0384082,
  -0.0399187, -0.0414254, -0.0429281, -0.0444267, -0.0459211,
  -0.047411, -0.0488963, -0.0503769, -0.0518527, -0.0533234,
  -0.0547889, -0.056249, -0.0577037, -0.0591528, -0.060596,
  -0.0620333, -0.0634645, -0.0648895, -0.0663081, -0.0677202,
  -0.0691256, -0.0705241, -0.0719157, -0.0733002, -0.0746774,
  -0.0760472, -0.0774095, -0.0787641, -0.0801108, -0.0814496,
  -0.0827803, -0.0841027, -0.0854167, -0.0867222, -0.0880191,
  -0.0893071, -0.0905862, -0.0918563, -0.0931171, -0.0943686,
  -0.0956106, -0.0968431, -0.0980658, -0.0992786, -0.100481,
  -0.101674, -0.102857, -0.104029, -0.105191, -0.106342, -0.107482,
  -0.108611, -0.10973, -0.110837, -0.111933, -0.113018, -0.114092,
  -0.115153, -0.116204, -0.117242, -0.118268, -0.119283, -0.120285,
  -0.121275, -0.122253, -0.123218, -0.124171, -0.125111, -0.126039,
  -0.126953, -0.127855, -0.128743, -0.129619, -0.130481, -0.131329,
  -0.132165, -0.132987, -0.133795, -0.134589, -0.13537, -0.136137,
  -0.13689, -0.137629, -0.138354, -0.139064, -0.13976, -0.140442,
  -0.14111, -0.141763, -0.142401, -0.143025, -0.143634, -0.144228,
  -0.144807, -0.145372, -0.145921, -0.146455, -0.146974, -0.147478,
  -0.147967, -0.148441, -0.148899, -0.149341, -0.149769, -0.15018,
  -0.150576, -0.150957, -0.151322, -0.151671, -0.152005, -0.152322,
  -0.152624, -0.15291, -0.15318, -0.153434, -0.153672, -0.153895,
  -0.154101, -0.154291, -0.154465, -0.154623, -0.154765, -0.15489,
  -0.155, -0.155093, -0.15517, -0.155231, -0.155275, -0.155304,
  -0.155316, -0.155312, -0.155291, -0.155254, -0.155201, -0.155132,
  -0.155046, -0.154945, -0.154826, -0.154692, -0.154541, -0.154374,
  -0.154191, -0.153992, -0.153776, -0.153544, -0.153296, -0.153032,
  -0.152751, -0.152455, -0.152142, -0.151814, -0.151469, -0.151108,
  -0.150731, -0.150339, -0.14993, -0.149505, -0.149065, -0.148609,
  -0.148137, -0.147649, -0.147146, -0.146627, -0.146092, -0.145542,
  -0.144976, -0.144395, -0.143799, -0.143187, -0.14256, -0.141917,
  -0.14126, -0.140587, -0.1399, -0.139197, -0.13848, -0.137748,
  -0.137, -0.136239, -0.135462, -0.134672, -0.133866, -0.133047,
  -0.132213, -0.131364, -0.130502, -0.129626, -0.128735, -0.127831,
  -0.126913, -0.125981, -0.125036, -0.124077, -0.123105, -0.122119,
  -0.12112, -0.120109, -0.119084, -0.118046, -0.116995, -0.115932,
  -0.114856, -0.113767, -0.112666, -0.111553, -0.110428, -0.10929,
  -0.108141, -0.10698, -0.105807, -0.104623, -0.103427, -0.10222,
  -0.101001, -0.099772, -0.0985316, -0.0972803, -0.0960183,
  -0.0947457, -0.0934627, -0.0921693, -0.0908658, -0.0895522,
  -0.0882287, -0.0868955, -0.0855526, -0.0842001, -0.0828384,
  -0.0814673, -0.0800873, -0.0786982, -0.0773004, -0.075894,
  -0.074479, -0.0730557, -0.0716241, -0.0701846, -0.0687371,
  -0.0672818, -0.065819, -0.0643486, -0.062871, -0.0613863,
  -0.0598946, -0.058396, -0.0568908, -0.055379, -0.0538609,
  -0.0523366, -0.0508063, -0.0492701, -0.0477281, -0.0461807,
  -0.0446278, -0.0430697, -0.0415066, -0.0399386, -0.0383658,
  -0.0367885, -0.0352068, -0.0336209, -0.032031, -0.0304371,
  -0.0288396, -0.0272385, -0.025634, -0.0240263, -0.0224156,
  -0.020802, -0.0191858, -0.0175671, -0.015946, -0.0143227,
  -0.0126975, -0.0110704, -0.00944175, -0.0078116, -0.00618017,
  -0.00454762, -0.00291414, -0.00127991, 0.00035491, 0.00199013,
  0.00362558, 0.00526108, 0.00689645, 0.00853151, 0.0101661, 0.0118,
  0.0134331, 0.0150652, 0.016696, 0.0183255, 0.0199535, 0.0215797,
  0.023204, 0.0248262, 0.0264462, 0.0280637, 0.0296786, 0.0312907,
  0.0328999, 0.0345058, 0.0361085, 0.0377077, 0.0393031, 0.0408948,
  0.0424824, 0.0440657, 0.0456448, 0.0472192, 0.0487889, 0.0503537,
  0.0519134, 0.0534679, 0.055017, 0.0565604, 0.0580981, 0.0596298,
  0.0611554, 0.0626748, 0.0641876, 0.0656939, 0.0671934, 0.0686858,
  0.0701712, 0.0716493, 0.0731199, 0.0745829, 0.076038, 0.0774853,
  0.0789244, 0.0803552, 0.0817775, 0.0831913, 0.0845963, 0.0859923,
  0.0873793, 0.088757, 0.0901253, 0.0914841, 0.0928331, 0.0941723,
  0.0955015, 0.0968204, 0.0981291, 0.0994272, 0.100715, 0.101992,
  0.103257, 0.104512, 0.105756, 0.106988, 0.108209, 0.109418,
  0.110615, 0.1118, 0.112974, 0.114135, 0.115283, 0.11642, 0.117543,
  0.118654, 0.119752, 0.120837, 0.121909, 0.122968, 0.124013,
  0.125045, 0.126063, 0.127068, 0.128058, 0.129035, 0.129997,
  0.130945, 0.131879, 0.132799, 0.133704, 0.134594, 0.135469, 0.13633,
  0.137176, 0.138006, 0.138822, 0.139622, 0.140406, 0.141175,
  0.141929, 0.142667, 0.143389, 0.144095, 0.144785, 0.14546, 0.146118,
  0.14676, 0.147385, 0.147995, 0.148587, 0.149164, 0.149723, 0.150266,
  0.150793, 0.151302, 0.151795, 0.15227, 0.152729, 0.153171, 0.153595,
  0.154002, 0.154392, 0.154765, 0.15512, 0.155458, 0.155778, 0.156081,
  0.156367, 0.156634, 0.156885, 0.157117, 0.157332, 0.157529,
  0.157708, 0.157869, 0.158013, 0.158139, 0.158246, 0.158336,
  0.158408, 0.158462, 0.158498, 0.158516, 0.158516, 0.158498,
  0.158462, 0.158407, 0.158335, 0.158245, 0.158137, 0.15801, 0.157866,
  0.157703, 0.157523, 0.157324, 0.157108, 0.156873, 0.156621, 0.15635,
  0.156062, 0.155755, 0.155431, 0.155089, 0.154729, 0.154351,
  0.153955, 0.153542, 0.15311, 0.152661, 0.152195, 0.151711, 0.151209,
  0.15069, 0.150153, 0.149599, 0.149027, 0.148438, 0.147832, 0.147209,
  0.146568, 0.145911, 0.145236, 0.144545, 0.143836, 0.143111,
  0.142369, 0.14161, 0.140835, 0.140043, 0.139235, 0.13841, 0.137569,
  0.136712, 0.135839, 0.134949, 0.134044, 0.133123, 0.132187,
  0.131234, 0.130266, 0.129283, 0.128284, 0.12727, 0.126241, 0.125197,
  0.124138, 0.123065, 0.121976, 0.120873, 0.119756, 0.118624,
  0.117478, 0.116318, 0.115144, 0.113956, 0.112755, 0.11154, 0.110311,
  0.109069, 0.107814, 0.106546, 0.105265, 0.103972, 0.102665,
  0.101347, 0.100015, 0.0986722, 0.0973168, 0.0959496, 0.0945706,
  0.0931801, 0.0917781, 0.0903649, 0.0889405, 0.0875052, 0.0860591,
  0.0846024, 0.0831352, 0.0816576, 0.08017, 0.0786723, 0.0771649,
  0.0756478, 0.0741213, 0.0725854, 0.0710404, 0.0694865, 0.0679239,
  0.0663526, 0.0647729, 0.063185, 0.061589, 0.0599851, 0.0583736,
  0.0567546, 0.0551282, 0.0534947, 0.0518543, 0.0502071, 0.0485533,
  0.0468932, 0.0452269, 0.0435545, 0.0418764, 0.0401927, 0.0385036,
  0.0368092, 0.0351099, 0.0334057, 0.0316969, 0.0299836, 0.0282662,
  0.0265447, 0.0248194, 0.0230905, 0.0213581, 0.0196226, 0.017884,
  0.0161426, 0.0143987, 0.0126523, 0.0109038, 0.00915323, 0.00740092,
  0.00564705, 0.00389182, 0.00213544, 0.000378112, -0.00137995,
  -0.00313853, -0.00489742, -0.00665642, -0.00841531, -0.0101739,
  -0.0119319, -0.0136892, -0.0154456, -0.0172008, -0.0189546,
  -0.0207068, -0.0224573, -0.0242057, -0.0259519, -0.0276957,
  -0.0294369, -0.0311752, -0.0329104, -0.0346423, -0.0363708,
  -0.0380956, -0.0398164, -0.0415331, -0.0432456, -0.0449534,
  -0.0466565, -0.0483547, -0.0500477, -0.0517353, -0.0534173,
  -0.0550936, -0.0567638, -0.0584278, -0.0600854, -0.0617364,
  -0.0633806, -0.0650177, -0.0666476, -0.0682701, -0.0698849,
  -0.0714919, -0.0730909, -0.0746815, -0.0762638, -0.0778374,
  -0.0794022, -0.0809579, -0.0825043, -0.0840414, -0.0855688,
  -0.0870864, -0.0885939, -0.0900913, -0.0915783, -0.0930546,
  -0.0945202, -0.0959748, -0.0974183, -0.0988504, -0.100271, -0.10168,
  -0.103077, -0.104462, -0.105834, -0.107195, -0.108542, -0.109877,
  -0.111199, -0.112508, -0.113803, -0.115085, -0.116354, -0.117608,
  -0.118849, -0.120075, -0.121287, -0.122485, -0.123668, -0.124836,
  -0.125989, -0.127127, -0.12825, -0.129358, -0.130449, -0.131526,
  -0.132586, -0.13363, -0.134659, -0.135671, -0.136666, -0.137645,
  -0.138607, -0.139553, -0.140481, -0.141393, -0.142287, -0.143164,
  -0.144023, -0.144865, -0.145689, -0.146495, -0.147284, -0.148054,
  -0.148806, -0.14954, -0.150255, -0.150952, -0.15163, -0.15229,
  -0.152931, -0.153553, -0.154156, -0.154739, -0.155304, -0.155849,
  -0.156375, -0.156882, -0.157369, -0.157837, -0.158285, -0.158713,
  -0.159121, -0.159509, -0.159878, -0.160226, -0.160555, -0.160863,
  -0.161151, -0.161419, -0.161666, -0.161893, -0.1621, -0.162286,
  -0.162452, -0.162597, -0.162722, -0.162826, -0.16291, -0.162973,
  -0.163015, -0.163036, -0.163037, -0.163017, -0.162976, -0.162915,
  -0.162832, -0.162729, -0.162605, -0.16246, -0.162295, -0.162108,
  -0.161901, -0.161673, -0.161424, -0.161155, -0.160864, -0.160553,
  -0.160221, -0.159869, -0.159496, -0.159102, -0.158687, -0.158252,
  -0.157797, -0.157321, -0.156824, -0.156307, -0.15577, -0.155212,
  -0.154634, -0.154036, -0.153417, -0.152779, -0.15212, -0.151442,
  -0.150743, -0.150025, -0.149287, -0.148529, -0.147752, -0.146955,
  -0.146139, -0.145304, -0.144449, -0.143575, -0.142682, -0.141769,
  -0.140838, -0.139889, -0.13892, -0.137933, -0.136928, -0.135904,
  -0.134862, -0.133802, -0.132724, -0.131628, -0.130514, -0.129382,
  -0.128234, -0.127067, -0.125884, -0.124683, -0.123466, -0.122232,
  -0.120981, -0.119713, -0.11843, -0.11713, -0.115814, -0.114482,
  -0.113134, -0.111771, -0.110392, -0.108998, -0.107589, -0.106165,
  -0.104727, -0.103274, -0.101806, -0.100324, -0.0988286, -0.0973189,
  -0.0957957, -0.0942589, -0.0927089, -0.0911457, -0.0895697,
  -0.087981, -0.0863798, -0.0847662, -0.0831406, -0.0815031,
  -0.0798538, -0.0781931, -0.0765211, -0.0748381, -0.0731442,
  -0.0714396, -0.0697247, -0.0679995, -0.0662643, -0.0645194,
  -0.0627649, -0.0610011, -0.0592282, -0.0574464, -0.055656,
  -0.0538572, -0.0520502, -0.0502353, -0.0484126, -0.0465825,
  -0.0447452, -0.0429008, -0.0410497, -0.0391921, -0.0373283,
  -0.0354584, -0.0335827, -0.0317014, -0.0298149, -0.0279234,
  -0.026027, -0.0241262, -0.022221, -0.0203118, -0.0183988,
  -0.0164823, -0.0145625, -0.0126397, -0.0107142, -0.00878614,
  -0.00685586, -0.00492359, -0.00298959, -0.00105414, 0.000882507,
  0.00282009, 0.00475836, 0.00669703, 0.00863585, 0.0105746,
  0.0125129, 0.0144506, 0.0163873, 0.0183229, 0.0202571, 0.0221895,
  0.02412, 0.0260482, 0.0279739, 0.0298969, 0.0318168, 0.0337334,
  0.0356464, 0.0375556, 0.0394607, 0.0413614, 0.0432575, 0.0451487,
  0.0470346, 0.0489152, 0.0507901, 0.0526589, 0.0545216, 0.0563778,
  0.0582272, 0.0600695, 0.0619046, 0.0637322, 0.0655519, 0.0673636,
  0.0691669, 0.0709616, 0.0727475, 0.0745243, 0.0762917, 0.0780495,
  0.0797974, 0.0815352, 0.0832626, 0.0849794, 0.0866853, 0.08838,
  0.0900633, 0.091735, 0.0933949, 0.0950425, 0.0966779, 0.0983006,
  0.0999104, 0.101507, 0.103091, 0.10466, 0.106216, 0.107758,
  0.109286, 0.110799, 0.112298, 0.113781, 0.115249, 0.116702,
  0.118139, 0.11956, 0.120966, 0.122355, 0.123727, 0.125083, 0.126421,
  0.127743, 0.129047, 0.130334, 0.131602, 0.132853, 0.134086, 0.1353,
  0.136496, 0.137673, 0.138831, 0.13997, 0.14109, 0.14219, 0.14327,
  0.14433, 0.145371, 0.146391, 0.147391, 0.14837, 0.149329, 0.150267,
  0.151183, 0.152079, 0.152953, 0.153806, 0.154637, 0.155446,
  0.156233, 0.156998, 0.157741, 0.158462, 0.15916, 0.159835, 0.160488,
  0.161118, 0.161725, 0.162309, 0.162869, 0.163407, 0.16392, 0.164411,
  0.164877, 0.16532, 0.165739, 0.166134, 0.166506, 0.166853, 0.167176,
  0.167474, 0.167749, 0.167999, 0.168224, 0.168425, 0.168601,
  0.168753, 0.16888, 0.168982, 0.16906, 0.169112, 0.16914, 0.169143,
  0.169121, 0.169074, 0.169002, 0.168905, 0.168783, 0.168636,
  0.168463, 0.168266, 0.168044, 0.167796, 0.167524, 0.167226,
  0.166903, 0.166556, 0.166183, 0.165785, 0.165363, 0.164915,
  0.164443, 0.163945, 0.163423, 0.162876, 0.162304, 0.161708,
  0.161087, 0.160442, 0.159772, 0.159077, 0.158358, 0.157615,
  0.156848, 0.156056, 0.155241, 0.154401, 0.153538, 0.152651, 0.15174,
  0.150806, 0.149849, 0.148868, 0.147863, 0.146836, 0.145786,
  0.144713, 0.143617, 0.142499, 0.141358, 0.140195, 0.13901, 0.137803,
  0.136574, 0.135323, 0.134051, 0.132757, 0.131442, 0.130107, 0.12875,
  0.127373, 0.125975, 0.124557, 0.123119, 0.121661, 0.120183,
  0.118686, 0.117169, 0.115633, 0.114079, 0.112505, 0.110914,
  0.109304, 0.107676, 0.10603, 0.104366, 0.102686, 0.100988, 0.099273,
  0.0975416, 0.0957938, 0.09403, 0.0922502, 0.0904548, 0.0886441,
  0.0868182, 0.0849775, 0.0831222, 0.0812526, 0.0793689, 0.0774715,
  0.0755605, 0.0736364, 0.0716993, 0.0697496, 0.0677875, 0.0658133,
  0.0638274, 0.06183, 0.0598214, 0.0578019, 0.0557718, 0.0537314,
  0.051681, 0.049621, 0.0475517, 0.0454732, 0.0433861, 0.0412905,
  0.0391869, 0.0370755, 0.0349566, 0.0328306, 0.0306978, 0.0285586,
  0.0264132, 0.024262, 0.0221053, 0.0199435, 0.0177769, 0.0156058,
  0.0134306, 0.0112517, 0.00906928, 0.00688379, 0.00469555,
  0.00250491, 0.000312214, -0.00188218, -0.00407794, -0.00627469,
  -0.0084721, -0.0106698, -0.0128675, -0.0150647, -0.0172612,
  -0.0194565, -0.0216504, -0.0238425, -0.0260323, -0.0282196,
  -0.030404, -0.0325852, -0.0347627, -0.0369362, -0.0391054,
  -0.0412699, -0.0434293, -0.0455833, -0.0477315, -0.0498735,
  -0.0520091, -0.0541378, -0.0562593, -0.0583732, -0.0604792,
  -0.0625768, -0.0646659, -0.0667459, -0.0688165, -0.0708774,
  -0.0729283, -0.0749687, -0.0769984, -0.0790169, -0.0810239,
  -0.0830191, -0.0850021, -0.0869726, -0.0889302, -0.0908746,
  -0.0928054, -0.0947223, -0.0966249, -0.098513, -0.100386, -0.102244,
  -0.104086, -0.105913, -0.107723, -0.109516, -0.111293, -0.113052,
  -0.114794, -0.116518, -0.118224, -0.119911, -0.121579, -0.123228,
  -0.124858, -0.126468, -0.128058, -0.129628, -0.131177, -0.132704,
  -0.134211, -0.135696, -0.13716, -0.138601, -0.14002, -0.141416,
  -0.142789, -0.144139, -0.145465, -0.146768, -0.148047, -0.149301,
  -0.150531, -0.151736, -0.152916, -0.154071, -0.155201, -0.156304,
  -0.157382, -0.158433, -0.159458, -0.160456, -0.161428, -0.162372,
  -0.163289, -0.164178, -0.16504, -0.165874, -0.16668, -0.167457,
  -0.168206, -0.168927, -0.169618, -0.170281, -0.170914, -0.171518,
  -0.172093, -0.172638, -0.173153, -0.173638, -0.174094, -0.174519,
  -0.174913, -0.175278, -0.175612, -0.175915, -0.176187, -0.176428,
  -0.176639, -0.176818, -0.176967, -0.177084, -0.17717, -0.177224,
  -0.177247, -0.177238, -0.177198, -0.177126, -0.177023, -0.176888,
  -0.176721, -0.176523, -0.176292, -0.17603, -0.175736, -0.175411,
  -0.175053, -0.174664, -0.174243, -0.17379, -0.173305, -0.172789,
  -0.172241, -0.171662, -0.171051, -0.170408, -0.169734, -0.169028,
  -0.168291, -0.167523, -0.166723, -0.165893, -0.165031, -0.164139,
  -0.163216, -0.162262, -0.161277, -0.160263, -0.159217, -0.158142,
  -0.157036, -0.155901, -0.154736, -0.153541, -0.152317, -0.151064,
  -0.149781, -0.14847, -0.14713, -0.145761, -0.144364, -0.142939,
  -0.141486, -0.140006, -0.138497, -0.136962, -0.1354, -0.133811,
  -0.132195, -0.130553, -0.128885, -0.127191, -0.125472, -0.123728,
  -0.121959, -0.120165, -0.118346, -0.116504, -0.114638, -0.112748,
  -0.110835, -0.108899, -0.106941, -0.104961, -0.102958, -0.100935,
  -0.0988897, -0.0968239, -0.0947376, -0.0926312, -0.090505,
  -0.0883593, -0.0861947, -0.0840114, -0.0818098, -0.0795903,
  -0.0773533, -0.0750991, -0.0728283, -0.0705412, -0.0682381,
  -0.0659195, -0.0635859, -0.0612376, -0.0588751, -0.0564987,
  -0.054109, -0.0517064, -0.0492912, -0.046864, -0.0444251,
  -0.0419751, -0.0395144, -0.0370434, -0.0345627, -0.0320726,
  -0.0295737, -0.0270663, -0.0245511, -0.0220284, -0.0194987,
  -0.0169626, -0.0144205, -0.0118729, -0.00932024, -0.00676308,
  -0.0042019, -0.00163719, 0.00093054, 0.0035008, 0.00607308,
  0.00864687, 0.0112217, 0.013797, 0.0163722, 0.018947, 0.0215207,
  0.0240928, 0.0266629, 0.0292303, 0.0317947, 0.0343554, 0.0369119,
  0.0394638, 0.0420104, 0.0445514, 0.047086, 0.0496139, 0.0521345,
  0.0546472, 0.0571515, 0.059647, 0.0621331, 0.0646092, 0.0670749,
  0.0695295, 0.0719727, 0.0744038, 0.0768223, 0.0792278, 0.0816196,
  0.0839973, 0.0863604, 0.0887083, 0.0910405, 0.0933565, 0.0956558,
  0.0979379, 0.100202, 0.102448, 0.104676, 0.106884, 0.109072,
  0.11124, 0.113388, 0.115514, 0.117618, 0.1197, 0.121759, 0.123796,
  0.125808, 0.127796, 0.12976, 0.131699, 0.133612, 0.135499, 0.13736,
  0.139193, 0.140999, 0.142778, 0.144528, 0.146249, 0.147942,
  0.149604, 0.151237, 0.152839, 0.154411, 0.155951, 0.15746, 0.158936,
  0.16038, 0.161792, 0.16317, 0.164514, 0.165825, 0.167101, 0.168343,
  0.169549, 0.170721, 0.171856, 0.172956, 0.174019, 0.175045,
  0.176035, 0.176987, 0.177901, 0.178778, 0.179617, 0.180417,
  0.181178, 0.181901, 0.182584, 0.183227, 0.183831, 0.184395,
  0.184919, 0.185403, 0.185846, 0.186248, 0.186609, 0.186929,
  0.187207, 0.187444, 0.18764, 0.187793, 0.187905, 0.187975, 0.188002,
  0.187987, 0.18793, 0.18783, 0.187687, 0.187502, 0.187275, 0.187004,
  0.18669, 0.186334, 0.185935, 0.185492, 0.185007, 0.184479, 0.183908,
  0.183294, 0.182637, 0.181938, 0.181195, 0.18041, 0.179582, 0.178712,
  0.177799, 0.176843, 0.175846, 0.174806, 0.173724, 0.1726, 0.171435,
  0.170228, 0.168979, 0.16769, 0.166359, 0.164987, 0.163575, 0.162123,
  0.16063, 0.159097, 0.157525, 0.155913, 0.154262, 0.152572, 0.150844,
  0.149077, 0.147273, 0.145431, 0.143551, 0.141635, 0.139682,
  0.137693, 0.135668, 0.133608, 0.131513, 0.129383, 0.127218, 0.12502,
  0.122789, 0.120525, 0.118228, 0.115899, 0.113539, 0.111148,
  0.108726, 0.106275, 0.103793, 0.101283, 0.0987444, 0.0961778,
  0.0935839, 0.0909631, 0.0883162, 0.0856436, 0.0829459, 0.0802238,
  0.0774778, 0.0747086, 0.0719168, 0.0691029, 0.0662677, 0.0634118,
  0.0605359, 0.0576405, 0.0547264, 0.0517943, 0.0488448, 0.0458786,
  0.0428964, 0.039899, 0.036887, 0.0338612, 0.0308223, 0.027771,
  0.0247081, 0.0216343, 0.0185503, 0.015457, 0.0123551, 0.00924527,
  0.00612841, 0.00300526, -0.000123397, -0.00325677, -0.00639405,
  -0.00953446, -0.0126772, -0.0158214, -0.0189663, -0.0221111,
  -0.025255, -0.0283971, -0.0315366, -0.0346726, -0.0378045,
  -0.0409312, -0.044052, -0.047166, -0.0502723, -0.0533703,
  -0.0564589, -0.0595373, -0.0626048, -0.0656604, -0.0687033,
  -0.0717326, -0.0747475, -0.0777471, -0.0807306, -0.0836971,
  -0.0866458, -0.0895758, -0.0924863, -0.0953764, -0.0982453,
  -0.101092, -0.103916, -0.106716, -0.109492, -0.112242, -0.114965,
  -0.117662, -0.120331, -0.122971, -0.125581, -0.128161, -0.13071,
  -0.133227, -0.135711, -0.138161, -0.140577, -0.142957, -0.145302,
  -0.14761, -0.14988, -0.152112, -0.154305, -0.156458, -0.158571,
  -0.160642, -0.162672, -0.164658, -0.166602, -0.168501, -0.170355,
  -0.172164, -0.173926, -0.175642, -0.17731, -0.17893, -0.180501,
  -0.182023, -0.183495, -0.184916, -0.186286, -0.187604, -0.18887,
  -0.190083, -0.191242, -0.192348, -0.193399, -0.194395, -0.195335,
  -0.19622, -0.197048, -0.197819, -0.198533, -0.199189, -0.199787,
  -0.200327, -0.200807, -0.201229, -0.201591, -0.201892, -0.202134,
  -0.202315, -0.202436, -0.202495, -0.202493, -0.202429, -0.202304,
  -0.202117, -0.201867, -0.201555, -0.201181, -0.200745, -0.200246,
  -0.199684, -0.199059, -0.198371, -0.197621, -0.196808, -0.195931,
  -0.194992, -0.193991, -0.192926, -0.191799, -0.19061, -0.189358,
  -0.188044, -0.186667, -0.185229, -0.18373, -0.182169, -0.180546,
  -0.178863, -0.17712, -0.175316, -0.173452, -0.171528, -0.169546,
  -0.167504, -0.165405, -0.163247, -0.161032, -0.15876, -0.156431,
  -0.154047, -0.151607, -0.149112, -0.146564, -0.143961, -0.141306,
  -0.138598, -0.135839, -0.133029, -0.130168, -0.127259, -0.1243,
  -0.121294, -0.11824, -0.11514, -0.111995, -0.108806, -0.105572,
  -0.102296, -0.0989782, -0.0956194, -0.0922207, -0.0887831,
  -0.0853076, -0.0817953, -0.0782471, -0.0746642, -0.0710476,
  -0.0673985, -0.0637179, -0.060007, -0.056267, -0.052499, -0.0487043,
  -0.044884, -0.0410393, -0.0371717, -0.0332822, -0.0293721,
  -0.0254429, -0.0214956, -0.0175318, -0.0135528, -0.00955979,
  -0.00555427, -0.0015376, 0.00248884, 0.00652362, 0.0105653,
  0.0146125, 0.0186638, 0.0227176, 0.0267726, 0.0308272, 0.0348799,
  0.0389293, 0.0429738, 0.047012, 0.0510422, 0.055063, 0.0590729,
  0.0630701, 0.0670533, 0.0710209, 0.0749712, 0.0789027, 0.0828139,
  0.0867031, 0.0905688, 0.0944094, 0.0982233, 0.102009, 0.105765,
  0.109489, 0.11318, 0.116836, 0.120457, 0.124039, 0.127582, 0.131084,
  0.134544, 0.137959, 0.141328, 0.144651, 0.147924, 0.151147,
  0.154319, 0.157436, 0.160499, 0.163505, 0.166454, 0.169343,
  0.172171, 0.174936, 0.177638, 0.180274, 0.182844, 0.185346,
  0.187778, 0.190139, 0.192428, 0.194644, 0.196784, 0.198849,
  0.200836, 0.202744, 0.204573, 0.20632, 0.207985, 0.209567, 0.211064,
  0.212475, 0.2138, 0.215037, 0.216185, 0.217243, 0.21821, 0.219086,
  0.219869, 0.220558, 0.221153, 0.221653, 0.222058, 0.222365,
  0.222575, 0.222688, 0.222701, 0.222616, 0.222431, 0.222145,
  0.221759, 0.221272, 0.220684, 0.219993, 0.219201, 0.218306,
  0.217308, 0.216208, 0.215005, 0.213699, 0.21229, 0.210778, 0.209163,
  0.207446, 0.205626, 0.203703, 0.201679, 0.199553, 0.197325,
  0.194996, 0.192567, 0.190038, 0.187409, 0.184682, 0.181857,
  0.178934, 0.175915, 0.172799, 0.16959, 0.166286, 0.162889, 0.159401,
  0.155822, 0.152153, 0.148396, 0.144552, 0.140623, 0.136609,
  0.132513, 0.128335, 0.124078, 0.119742, 0.11533, 0.110844, 0.106285,
  0.101655, 0.0969553, 0.092189, 0.0873576, 0.0824633, 0.077508,
  0.0724941, 0.0674238, 0.0622994, 0.0571232, 0.0518976, 0.0466251,
  0.0413081, 0.0359493, 0.0305513, 0.0251166, 0.0196481, 0.0141484,
  0.00862044, 0.00306698, -0.00250904, -0.0081047, -0.013717,
  -0.0193429, -0.0249793, -0.0306232, -0.0362714, -0.0419206,
  -0.0475676, -0.0532092, -0.0588421, -0.064463, -0.0700683,
  -0.0756549, -0.0812192, -0.0867577, -0.092267, -0.0977437,
  -0.103184, -0.108585, -0.113942, -0.119252, -0.124511, -0.129717,
  -0.134864, -0.13995, -0.144971, -0.149923, -0.154803, -0.159606,
  -0.164329, -0.16897, -0.173522, -0.177985, -0.182352, -0.186622,
  -0.19079, -0.194853, -0.198806, -0.202648, -0.206373, -0.209979,
  -0.213463, -0.216819, -0.220047, -0.22314, -0.226098, -0.228916,
  -0.231591, -0.23412, -0.236499, -0.238727, -0.240799, -0.242713,
  -0.244466, -0.246055, -0.247477, -0.24873, -0.249812, -0.250719,
  -0.251449, -0.252001, -0.252371, -0.252558, -0.25256, -0.252375,
  -0.252001, -0.251436, -0.250679, -0.249728, -0.248582, -0.247241,
  -0.245702, -0.243965, -0.242029, -0.239893, -0.237558, -0.235022,
  -0.232285, -0.229348, -0.22621, -0.222872, -0.219335, -0.215598,
  -0.211662, -0.207529, -0.2032, -0.198676, -0.193958, -0.189049,
  -0.18395, -0.178662, -0.17319, -0.167534, -0.161698, -0.155685,
  -0.149497, -0.143138, -0.136611, -0.129921, -0.123071, -0.116065,
  -0.108908, -0.101605, -0.0941596, -0.0865777, -0.0788644,
  -0.0710252, -0.0630659, -0.0549926, -0.0468114, -0.0385289,
  -0.0301516, -0.0216865, -0.0131408, -0.00452185, 0.00416273,
  0.0129051, 0.0216972, 0.0305307, 0.0393972, 0.0482878, 0.0571936,
  0.0661054, 0.0750138, 0.0839093, 0.0927819, 0.101622, 0.110419,
  0.119162, 0.127841, 0.136446, 0.144965, 0.153387, 0.161701,
  0.169895, 0.177959, 0.185879, 0.193645, 0.201244, 0.208664,
  0.215893, 0.222919, 0.22973, 0.236312, 0.242655, 0.248744, 0.254568,
  0.260115, 0.26537, 0.270324, 0.274961, 0.279272, 0.283242, 0.28686,
  0.290115, 0.292993, 0.295484, 0.297575, 0.299255, 0.300514,
  0.301341, 0.301724, 0.301654, 0.301121, 0.300115, 0.298628, 0.29665,
  0.294175, 0.291193, 0.287698, 0.283683, 0.279144, 0.274074,
  0.268469, 0.262325, 0.25564, 0.248412, 0.240639, 0.232321, 0.223459,
  0.214055, 0.204112, 0.193635, 0.182627, 0.171097, 0.159051, 0.1465,
  0.133455, 0.119927, 0.10593, 0.0914811, 0.0765968, 0.0612965,
  0.0456015, 0.0295348, 0.0131216, -0.00361057, -0.0206322,
  -0.0379113, -0.0554135, -0.073102, -0.0909371, -0.108877, -0.126876,
  -0.144886, -0.162857, -0.180735, -0.198461, -0.215975, -0.233214,
  -0.250108, -0.266586, -0.282573, -0.29799, -0.312751, -0.326771,
  -0.339955, -0.352207, -0.363425, -0.373503, -0.382329, -0.389786,
  -0.395751, -0.400097, -0.40269, -0.403391, -0.402053, -0.398526,
  -0.39265, -0.384261, -0.373186, -0.359247, -0.342256, -0.322021,
  -0.29834, -0.271002, -0.239791, -0.204479, -0.164832, -0.120606,
  -0.0715469, -0.0173932, 0.0421279, 0.107299, 0.178412, 0.255771,
  0.33969, 0.430494, 0.52852, 0.634117, 0.747645, 0.869477, 1};
  const G4double G4NeutronHPFastLegendre::i27[5601] = {0, -0.000333562,
  -0.000622073, -0.000868567, -0.00107594, -0.00124697, -0.00138429,
  -0.00149041, -0.00156775, -0.00161858, -0.00164509, -0.00164933,
  -0.00163329, -0.00159883, -0.00154771, -0.00148163, -0.00140216,
  -0.00131083, -0.00120904, -0.00109816, -0.000979432, -0.000854067,
  -0.000723185, -0.000587841, -0.000449027, -0.000307671,
  -0.000164641, -2.0747e-05, 0.000123256, 0.000266667, 0.000408835,
  0.000549157, 0.000687078, 0.000822089, 0.00095372, 0.00108154,
  0.00120517, 0.00132426, 0.00143848, 0.00154757, 0.00165126,
  0.00174934, 0.00184162, 0.00192794, 0.00200816, 0.00208217,
  0.00214989, 0.00221125, 0.00226621, 0.00231474, 0.00235684,
  0.00239251, 0.0024218, 0.00244475, 0.00246141, 0.00247185,
  0.00247617, 0.00247447, 0.00246684, 0.00245341, 0.00243431,
  0.00240967, 0.00237965, 0.00234438, 0.00230403, 0.00225877,
  0.00220877, 0.00215419, 0.00209522, 0.00203204, 0.00196483,
  0.00189379, 0.0018191, 0.00174095, 0.00165955, 0.00157508,
  0.00148773, 0.0013977, 0.00130519, 0.00121039, 0.00111349,
  0.00101469, 0.000914165, 0.000812117, 0.000708728, 0.000604182,
  0.000498662, 0.000392348, 0.000285414, 0.000178036, 7.03832e-05,
  -3.73769e-05, -0.000145081, -0.000252568, -0.000359683,
  -0.000466273, -0.000572188, -0.000677286, -0.000781424,
  -0.000884466, -0.000986281, -0.00108674, -0.00118572, -0.0012831,
  -0.00137877, -0.00147262, -0.00156453, -0.00165442, -0.00174218,
  -0.00182772, -0.00191094, -0.00199178, -0.00207015, -0.00214597,
  -0.00221917, -0.00228969, -0.00235747, -0.00242244, -0.00248457,
  -0.00254378, -0.00260005, -0.00265333, -0.00270359, -0.00275078,
  -0.00279489, -0.00283589, -0.00287376, -0.00290847, -0.00294003,
  -0.00296841, -0.00299361, -0.00301562, -0.00303446, -0.00305012,
  -0.0030626, -0.00307193, -0.00307811, -0.00308115, -0.00308109,
  -0.00307793, -0.00307171, -0.00306245, -0.00305018, -0.00303494,
  -0.00301676, -0.00299567, -0.00297172, -0.00294495, -0.00291541,
  -0.00288313, -0.00284817, -0.00281057, -0.00277039, -0.00272768,
  -0.0026825, -0.0026349, -0.00258494, -0.00253268, -0.00247818,
  -0.0024215, -0.0023627, -0.00230185, -0.00223901, -0.00217426,
  -0.00210764, -0.00203924, -0.00196912, -0.00189736, -0.001824,
  -0.00174914, -0.00167284, -0.00159517, -0.0015162, -0.001436,
  -0.00135464, -0.0012722, -0.00118875, -0.00110435, -0.00101909,
  -0.000933022, -0.000846231, -0.000758785, -0.000670753,
  -0.000582207, -0.000493217, -0.000403853, -0.000314184,
  -0.000224279, -0.000134206, -4.40329e-05, 4.61725e-05, 0.000136344,
  0.000226416, 0.000316323, 0.000406002, 0.000495387, 0.000584418,
  0.000673032, 0.000761168, 0.000848765, 0.000935767, 0.00102211,
  0.00110775, 0.00119261, 0.00127666, 0.00135982, 0.00144206,
  0.00152332, 0.00160354, 0.00168269, 0.00176071, 0.00183755,
  0.00191316, 0.00198752, 0.00206056, 0.00213225, 0.00220255,
  0.00227142, 0.00233882, 0.00240471, 0.00246906, 0.00253183,
  0.00259299, 0.00265251, 0.00271036, 0.00276651, 0.00282092,
  0.00287359, 0.00292447, 0.00297354, 0.00302079, 0.00306619,
  0.00310972, 0.00315136, 0.0031911, 0.00322892, 0.0032648,
  0.00329873, 0.0033307, 0.0033607, 0.00338871, 0.00341474,
  0.00343876, 0.00346078, 0.00348079, 0.00349878, 0.00351476,
  0.00352873, 0.00354067, 0.0035506, 0.00355852, 0.00356442,
  0.00356831, 0.00357021, 0.00357011, 0.00356802, 0.00356395,
  0.00355792, 0.00354992, 0.00353998, 0.00352811, 0.00351431,
  0.00349861, 0.00348101, 0.00346154, 0.00344021, 0.00341705,
  0.00339206, 0.00336527, 0.0033367, 0.00330638, 0.00327431,
  0.00324054, 0.00320507, 0.00316793, 0.00312916, 0.00308877,
  0.00304679, 0.00300325, 0.00295817, 0.00291159, 0.00286353,
  0.00281402, 0.00276309, 0.00271078, 0.00265711, 0.00260211,
  0.00254582, 0.00248826, 0.00242948, 0.0023695, 0.00230835,
  0.00224608, 0.00218271, 0.00211828, 0.00205282, 0.00198638,
  0.00191897, 0.00185065, 0.00178144, 0.00171138, 0.0016405,
  0.00156885, 0.00149646, 0.00142336, 0.00134959, 0.0012752,
  0.0012002, 0.00112465, 0.00104858, 0.000972022, 0.000895017,
  0.0008176, 0.000739809, 0.000661679, 0.000583249, 0.000504554,
  0.00042563, 0.000346514, 0.000267242, 0.00018785, 0.000108375,
  2.88508e-05, -5.0686e-05, -0.0001302, -0.000209657, -0.000289021,
  -0.000368258, -0.000447334, -0.000526214, -0.000604864,
  -0.000683252, -0.000761343, -0.000839105, -0.000916506,
  -0.000993512, -0.00107009, -0.00114622, -0.00122185, -0.00129697,
  -0.00137153, -0.00144552, -0.00151889, -0.00159163, -0.0016637,
  -0.00173508, -0.00180573, -0.00187563, -0.00194475, -0.00201307,
  -0.00208056, -0.00214719, -0.00221294, -0.00227778, -0.0023417,
  -0.00240466, -0.00246664, -0.00252763, -0.0025876, -0.00264652,
  -0.00270438, -0.00276115, -0.00281683, -0.00287138, -0.00292478,
  -0.00297703, -0.0030281, -0.00307797, -0.00312664, -0.00317407,
  -0.00322026, -0.0032652, -0.00330886, -0.00335123, -0.00339231,
  -0.00343207, -0.00347051, -0.00350761, -0.00354337, -0.00357777,
  -0.0036108, -0.00364246, -0.00367273, -0.00370161, -0.00372909,
  -0.00375516, -0.00377981, -0.00380305, -0.00382486, -0.00384524,
  -0.00386419, -0.0038817, -0.00389777, -0.0039124, -0.00392558,
  -0.00393731, -0.0039476, -0.00395643, -0.00396382, -0.00396976,
  -0.00397426, -0.00397731, -0.00397892, -0.00397909, -0.00397782,
  -0.00397512, -0.003971, -0.00396545, -0.00395848, -0.00395009,
  -0.0039403, -0.00392912, -0.00391653, -0.00390257, -0.00388722,
  -0.00387051, -0.00385244, -0.00383301, -0.00381225, -0.00379016,
  -0.00376674, -0.00374202, -0.003716, -0.00368869, -0.00366011,
  -0.00363027, -0.00359918, -0.00356686, -0.00353331, -0.00349856,
  -0.00346262, -0.0034255, -0.00338721, -0.00334778, -0.00330722,
  -0.00326555, -0.00322277, -0.00317891, -0.00313399, -0.00308802,
  -0.00304102, -0.00299301, -0.002944, -0.00289401, -0.00284307,
  -0.00279119, -0.00273839, -0.00268469, -0.00263011, -0.00257466,
  -0.00251838, -0.00246127, -0.00240336, -0.00234467, -0.00228522,
  -0.00222503, -0.00216412, -0.00210252, -0.00204024, -0.0019773,
  -0.00191373, -0.00184955, -0.00178477, -0.00171943, -0.00165355,
  -0.00158713, -0.00152022, -0.00145282, -0.00138497, -0.00131668,
  -0.00124798, -0.00117888, -0.00110942, -0.00103961, -0.000969477,
  -0.000899042, -0.000828327, -0.000757355, -0.000686149,
  -0.000614731, -0.000543124, -0.00047135, -0.00039943, -0.000327389,
  -0.000255247, -0.000183027, -0.000110751, -3.84421e-05, 3.3879e-05,
  0.00010619, 0.000178469, 0.000250694, 0.000322843, 0.000394896,
  0.000466829, 0.000538623, 0.000610256, 0.000681707, 0.000752955,
  0.000823978, 0.000894757, 0.000965271, 0.0010355, 0.00110542,
  0.00117502, 0.00124427, 0.00131315, 0.00138165, 0.00144975,
  0.00151742, 0.00158465, 0.00165142, 0.0017177, 0.00178349,
  0.00184877, 0.0019135, 0.00197769, 0.0020413, 0.00210433,
  0.00216676, 0.00222856, 0.00228973, 0.00235024, 0.00241008,
  0.00246923, 0.00252769, 0.00258542, 0.00264243, 0.00269868,
  0.00275418, 0.0028089, 0.00286282, 0.00291595, 0.00296826,
  0.00301973, 0.00307036, 0.00312014, 0.00316905, 0.00321707,
  0.0032642, 0.00331043, 0.00335574, 0.00340013, 0.00344358,
  0.00348608, 0.00352762, 0.00356819, 0.00360779, 0.0036464,
  0.00368401, 0.00372062, 0.00375622, 0.00379079, 0.00382434,
  0.00385685, 0.00388832, 0.00391874, 0.0039481, 0.0039764,
  0.00400363, 0.00402979, 0.00405487, 0.00407886, 0.00410177,
  0.00412358, 0.00414429, 0.00416391, 0.00418241, 0.00419981,
  0.0042161, 0.00423128, 0.00424534, 0.00425828, 0.00427011,
  0.00428081, 0.00429039, 0.00429885, 0.00430618, 0.00431239,
  0.00431748, 0.00432145, 0.00432429, 0.00432602, 0.00432662,
  0.00432611, 0.00432447, 0.00432173, 0.00431787, 0.00431291,
  0.00430683, 0.00429966, 0.00429138, 0.00428201, 0.00427155,
  0.00425999, 0.00424736, 0.00423365, 0.00421886, 0.00420301,
  0.00418609, 0.00416812, 0.0041491, 0.00412903, 0.00410793,
  0.0040858, 0.00406264, 0.00403846, 0.00401328, 0.0039871,
  0.00395992, 0.00393176, 0.00390262, 0.00387252, 0.00384145,
  0.00380944, 0.00377648, 0.00374259, 0.00370778, 0.00367206,
  0.00363544, 0.00359793, 0.00355954, 0.00352027, 0.00348015,
  0.00343918, 0.00339737, 0.00335473, 0.00331128, 0.00326703,
  0.00322198, 0.00317616, 0.00312957, 0.00308223, 0.00303414,
  0.00298533, 0.00293579, 0.00288556, 0.00283463, 0.00278303,
  0.00273076, 0.00267783, 0.00262428, 0.00257009, 0.0025153,
  0.00245991, 0.00240394, 0.0023474, 0.0022903, 0.00223267,
  0.00217451, 0.00211583, 0.00205666, 0.00199701, 0.00193689,
  0.00187631, 0.0018153, 0.00175387, 0.00169202, 0.00162978,
  0.00156716, 0.00150418, 0.00144085, 0.00137719, 0.00131321,
  0.00124892, 0.00118435, 0.0011195, 0.0010544, 0.00098905,
  0.000923477, 0.000857692, 0.000791711, 0.000725549, 0.000659221,
  0.000592744, 0.000526131, 0.000459398, 0.000392562, 0.000325636,
  0.000258636, 0.000191578, 0.000124477, 5.73477e-05, -9.79447e-06,
  -7.69345e-05, -0.000144057, -0.000211147, -0.00027819, -0.000345171,
  -0.000412074, -0.000478886, -0.00054559, -0.000612173, -0.000678619,
  -0.000744915, -0.000811045, -0.000876995, -0.000942751, -0.0010083,
  -0.00107362, -0.00113871, -0.00120355, -0.00126812, -0.00133241,
  -0.00139641, -0.00146011, -0.00152348, -0.00158652, -0.00164921,
  -0.00171155, -0.00177351, -0.00183508, -0.00189626, -0.00195702,
  -0.00201736, -0.00207726, -0.00213672, -0.00219571, -0.00225422,
  -0.00231225, -0.00236978, -0.00242681, -0.00248331, -0.00253927,
  -0.0025947, -0.00264956, -0.00270386, -0.00275759, -0.00281072,
  -0.00286325, -0.00291518, -0.00296649, -0.00301716, -0.0030672,
  -0.00311658, -0.00316531, -0.00321336, -0.00326074, -0.00330743,
  -0.00335342, -0.00339871, -0.00344328, -0.00348713, -0.00353025,
  -0.00357263, -0.00361426, -0.00365514, -0.00369525, -0.00373459,
  -0.00377316, -0.00381094, -0.00384792, -0.00388411, -0.00391949,
  -0.00395407, -0.00398782, -0.00402075, -0.00405285, -0.00408411,
  -0.00411453, -0.0041441, -0.00417283, -0.00420069, -0.0042277,
  -0.00425384, -0.00427911, -0.0043035, -0.00432702, -0.00434965,
  -0.0043714, -0.00439225, -0.00441222, -0.00443129, -0.00444946,
  -0.00446672, -0.00448309, -0.00449854, -0.00451309, -0.00452673,
  -0.00453946, -0.00455127, -0.00456217, -0.00457215, -0.00458121,
  -0.00458936, -0.00459659, -0.00460289, -0.00460828, -0.00461275,
  -0.0046163, -0.00461892, -0.00462063, -0.00462142, -0.0046213,
  -0.00462026, -0.0046183, -0.00461543, -0.00461164, -0.00460695,
  -0.00460134, -0.00459483, -0.00458741, -0.0045791, -0.00456988,
  -0.00455976, -0.00454876, -0.00453686, -0.00452407, -0.0045104,
  -0.00449585, -0.00448042, -0.00446411, -0.00444694, -0.00442891,
  -0.00441001, -0.00439026, -0.00436966, -0.00434821, -0.00432592,
  -0.00430279, -0.00427883, -0.00425405, -0.00422845, -0.00420203,
  -0.00417481, -0.00414678, -0.00411796, -0.00408835, -0.00405796,
  -0.00402678, -0.00399484, -0.00396214, -0.00392868, -0.00389447,
  -0.00385952, -0.00382384, -0.00378743, -0.0037503, -0.00371246,
  -0.00367392, -0.00363468, -0.00359475, -0.00355415, -0.00351287,
  -0.00347093, -0.00342834, -0.0033851, -0.00334123, -0.00329673,
  -0.00325161, -0.00320588, -0.00315955, -0.00311263, -0.00306513,
  -0.00301706, -0.00296842, -0.00291923, -0.0028695, -0.00281923,
  -0.00276844, -0.00271713, -0.00266532, -0.00261302, -0.00256023,
  -0.00250697, -0.00245325, -0.00239907, -0.00234446, -0.00228941,
  -0.00223393, -0.00217805, -0.00212177, -0.0020651, -0.00200805,
  -0.00195063, -0.00189285, -0.00183473, -0.00177627, -0.00171749,
  -0.0016584, -0.001599, -0.00153931, -0.00147934, -0.00141911,
  -0.00135861, -0.00129787, -0.0012369, -0.0011757, -0.00111428,
  -0.00105267, -0.000990868, -0.000928885, -0.000866736, -0.00080443,
  -0.000741979, -0.000679396, -0.00061669, -0.000553873, -0.000490958,
  -0.000427954, -0.000364874, -0.000301728, -0.000238529,
  -0.000175287, -0.000112014, -4.87205e-05, 1.45814e-05, 7.78807e-05,
  0.000141166, 0.000204427, 0.000267651, 0.000330828, 0.000393946,
  0.000456995, 0.000519963, 0.000582839, 0.000645613, 0.000708272,
  0.000770808, 0.000833207, 0.00089546, 0.000957556, 0.00101948,
  0.00108123, 0.00114279, 0.00120415, 0.0012653, 0.00132623,
  0.00138693, 0.00144738, 0.00150759, 0.00156753, 0.0016272,
  0.00168658, 0.00174567, 0.00180446, 0.00186294, 0.0019211,
  0.00197892, 0.0020364, 0.00209353, 0.00215029, 0.00220669,
  0.00226271, 0.00231833, 0.00237356, 0.00242838, 0.00248278,
  0.00253676, 0.0025903, 0.0026434, 0.00269605, 0.00274823,
  0.00279995, 0.00285119, 0.00290194, 0.0029522, 0.00300195,
  0.00305119, 0.00309992, 0.00314812, 0.00319578, 0.0032429,
  0.00328948, 0.00333549, 0.00338094, 0.00342582, 0.00347013,
  0.00351384, 0.00355697, 0.00359949, 0.00364141, 0.00368272,
  0.0037234, 0.00376347, 0.0038029, 0.00384169, 0.00387984,
  0.00391734, 0.00395418, 0.00399037, 0.00402589, 0.00406073,
  0.0040949, 0.00412839, 0.00416119, 0.0041933, 0.00422471,
  0.00425542, 0.00428543, 0.00431472, 0.0043433, 0.00437116,
  0.0043983, 0.00442471, 0.00445039, 0.00447533, 0.00449954,
  0.00452301, 0.00454573, 0.0045677, 0.00458893, 0.0046094,
  0.00462911, 0.00464807, 0.00466626, 0.00468369, 0.00470035,
  0.00471625, 0.00473137, 0.00474573, 0.0047593, 0.00477211,
  0.00478414, 0.00479538, 0.00480585, 0.00481554, 0.00482445,
  0.00483257, 0.00483991, 0.00484647, 0.00485224, 0.00485723,
  0.00486143, 0.00486485, 0.00486748, 0.00486933, 0.0048704,
  0.00487068, 0.00487017, 0.00486889, 0.00486682, 0.00486397,
  0.00486034, 0.00485593, 0.00485075, 0.00484479, 0.00483805,
  0.00483054, 0.00482226, 0.00481321, 0.0048034, 0.00479281,
  0.00478147, 0.00476936, 0.0047565, 0.00474288, 0.00472851,
  0.00471339, 0.00469752, 0.00468091, 0.00466356, 0.00464547,
  0.00462664, 0.00460709, 0.00458681, 0.0045658, 0.00454408,
  0.00452164, 0.00449849, 0.00447463, 0.00445007, 0.00442481,
  0.00439886, 0.00437222, 0.00434489, 0.00431688, 0.0042882,
  0.00425885, 0.00422883, 0.00419815, 0.00416682, 0.00413483,
  0.00410221, 0.00406894, 0.00403505, 0.00400052, 0.00396538,
  0.00392961, 0.00389324, 0.00385627, 0.0038187, 0.00378054,
  0.00374179, 0.00370246, 0.00366257, 0.0036221, 0.00358108,
  0.00353951, 0.00349739, 0.00345474, 0.00341155, 0.00336784,
  0.00332361, 0.00327887, 0.00323363, 0.0031879, 0.00314167,
  0.00309496, 0.00304779, 0.00300014, 0.00295204, 0.00290348,
  0.00285449, 0.00280506, 0.0027552, 0.00270492, 0.00265423,
  0.00260314, 0.00255165, 0.00249977, 0.00244752, 0.00239489,
  0.0023419, 0.00228856, 0.00223487, 0.00218085, 0.00212649,
  0.00207181, 0.00201682, 0.00196153, 0.00190594, 0.00185006,
  0.00179391, 0.00173748, 0.0016808, 0.00162386, 0.00156668,
  0.00150926, 0.00145162, 0.00139376, 0.00133569, 0.00127742,
  0.00121896, 0.00116032, 0.00110151, 0.00104253, 0.000983392,
  0.000924111, 0.000864693, 0.000805146, 0.000745479, 0.000685701,
  0.000625822, 0.00056585, 0.000505794, 0.000445663, 0.000385466,
  0.000325212, 0.00026491, 0.000204568, 0.000144197, 8.38042e-05,
  2.33991e-05, -3.70094e-05, -9.74124e-05, -0.000157801, -0.000218167,
  -0.0002785, -0.000338792, -0.000399035, -0.000459219, -0.000519336,
  -0.000579376, -0.000639332, -0.000699194, -0.000758953,
  -0.000818602, -0.000878131, -0.000937532, -0.000996796, -0.00105591,
  -0.00111488, -0.00117368, -0.00123231, -0.00129076, -0.00134903,
  -0.0014071, -0.00146496, -0.00152261, -0.00158004, -0.00163724,
  -0.00169421, -0.00175093, -0.00180739, -0.0018636, -0.00191953,
  -0.00197519, -0.00203056, -0.00208564, -0.00214042, -0.00219489,
  -0.00224905, -0.00230288, -0.00235638, -0.00240954, -0.00246235,
  -0.00251481, -0.00256692, -0.00261865, -0.00267001, -0.00272098,
  -0.00277157, -0.00282176, -0.00287154, -0.00292092, -0.00296988,
  -0.00301842, -0.00306652, -0.00311419, -0.00316141, -0.00320819,
  -0.00325451, -0.00330036, -0.00334575, -0.00339066, -0.00343509,
  -0.00347904, -0.00352249, -0.00356544, -0.00360789, -0.00364982,
  -0.00369124, -0.00373214, -0.00377251, -0.00381235, -0.00385165,
  -0.00389041, -0.00392862, -0.00396628, -0.00400338, -0.00403991,
  -0.00407588, -0.00411128, -0.00414609, -0.00418033, -0.00421398,
  -0.00424704, -0.0042795, -0.00431137, -0.00434263, -0.00437329,
  -0.00440333, -0.00443276, -0.00446157, -0.00448975, -0.00451732,
  -0.00454425, -0.00457055, -0.00459621, -0.00462123, -0.00464561,
  -0.00466935, -0.00469243, -0.00471487, -0.00473665, -0.00475778,
  -0.00477824, -0.00479805, -0.00481718, -0.00483566, -0.00485346,
  -0.0048706, -0.00488706, -0.00490285, -0.00491796, -0.00493239,
  -0.00494614, -0.00495921, -0.0049716, -0.00498331, -0.00499433,
  -0.00500466, -0.00501431, -0.00502327, -0.00503154, -0.00503912,
  -0.00504601, -0.00505221, -0.00505771, -0.00506253, -0.00506665,
  -0.00507008, -0.00507282, -0.00507486, -0.00507622, -0.00507688,
  -0.00507685, -0.00507613, -0.00507471, -0.00507261, -0.00506982,
  -0.00506633, -0.00506216, -0.00505731, -0.00505176, -0.00504553,
  -0.00503862, -0.00503102, -0.00502275, -0.00501379, -0.00500416,
  -0.00499385, -0.00498286, -0.0049712, -0.00495888, -0.00494588,
  -0.00493221, -0.00491788, -0.00490289, -0.00488724, -0.00487093,
  -0.00485397, -0.00483635, -0.00481809, -0.00479918, -0.00477962,
  -0.00475942, -0.00473859, -0.00471712, -0.00469502, -0.00467229,
  -0.00464893, -0.00462496, -0.00460036, -0.00457515, -0.00454933,
  -0.00452291, -0.00449588, -0.00446825, -0.00444003, -0.00441121,
  -0.00438181, -0.00435183, -0.00432127, -0.00429013, -0.00425843,
  -0.00422615, -0.00419332, -0.00415994, -0.004126, -0.00409151,
  -0.00405649, -0.00402092, -0.00398483, -0.0039482, -0.00391106,
  -0.0038734, -0.00383523, -0.00379655, -0.00375738, -0.0037177,
  -0.00367754, -0.0036369, -0.00359577, -0.00355417, -0.00351211,
  -0.00346958, -0.0034266, -0.00338317, -0.00333929, -0.00329498,
  -0.00325024, -0.00320507, -0.00315948, -0.00311347, -0.00306706,
  -0.00302025, -0.00297304, -0.00292545, -0.00287747, -0.00282912,
  -0.0027804, -0.00273132, -0.00268188, -0.00263209, -0.00258196,
  -0.0025315, -0.0024807, -0.00242958, -0.00237815, -0.00232641,
  -0.00227436, -0.00222202, -0.0021694, -0.00211649, -0.00206331,
  -0.00200986, -0.00195615, -0.00190219, -0.00184798, -0.00179353,
  -0.00173885, -0.00168395, -0.00162883, -0.0015735, -0.00151797,
  -0.00146224, -0.00140632, -0.00135022, -0.00129395, -0.00123751,
  -0.00118092, -0.00112417, -0.00106728, -0.00101025, -0.000953086,
  -0.000895804, -0.000838408, -0.000780904, -0.0007233, -0.000665603,
  -0.000607821, -0.000549962, -0.000492032, -0.00043404, -0.000375992,
  -0.000317896, -0.000259759, -0.000201589, -0.000143394,
  -8.51802e-05, -2.69557e-05, 3.12723e-05, 8.94964e-05, 0.000147709,
  0.000205903, 0.000264071, 0.000322205, 0.000380298, 0.000438344,
  0.000496333, 0.00055426, 0.000612117, 0.000669896, 0.00072759,
  0.000785192, 0.000842695, 0.000900092, 0.000957375, 0.00101454,
  0.00107157, 0.00112847, 0.00118523, 0.00124183, 0.00129828,
  0.00135457, 0.00141069, 0.00146663, 0.00152238, 0.00157795,
  0.00163331, 0.00168847, 0.00174342, 0.00179815, 0.00185266,
  0.00190693, 0.00196096, 0.00201475, 0.00206828, 0.00212156,
  0.00217457, 0.00222731, 0.00227977, 0.00233195, 0.00238383,
  0.00243542, 0.00248671, 0.00253768, 0.00258834, 0.00263867,
  0.00268868, 0.00273835, 0.00278768, 0.00283667, 0.0028853,
  0.00293357, 0.00298148, 0.00302902, 0.00307618, 0.00312297,
  0.00316936, 0.00321536, 0.00326097, 0.00330617, 0.00335096,
  0.00339533, 0.00343929, 0.00348282, 0.00352592, 0.00356859,
  0.00361081, 0.00365259, 0.00369392, 0.00373479, 0.00377521,
  0.00381515, 0.00385463, 0.00389364, 0.00393216, 0.0039702,
  0.00400776, 0.00404482, 0.00408138, 0.00411744, 0.004153,
  0.00418805, 0.00422258, 0.0042566, 0.0042901, 0.00432307,
  0.00435551, 0.00438742, 0.00441879, 0.00444962, 0.00447991,
  0.00450965, 0.00453884, 0.00456748, 0.00459555, 0.00462307,
  0.00465003, 0.00467642, 0.00470223, 0.00472748, 0.00475215,
  0.00477624, 0.00479976, 0.00482268, 0.00484503, 0.00486678,
  0.00488794, 0.00490851, 0.00492849, 0.00494787, 0.00496664,
  0.00498482, 0.00500239, 0.00501936, 0.00503572, 0.00505147,
  0.00506661, 0.00508113, 0.00509505, 0.00510834, 0.00512102,
  0.00513309, 0.00514453, 0.00515535, 0.00516556, 0.00517514,
  0.00518409, 0.00519243, 0.00520013, 0.00520722, 0.00521367,
  0.0052195, 0.00522471, 0.00522928, 0.00523323, 0.00523655,
  0.00523924, 0.0052413, 0.00524274, 0.00524354, 0.00524372,
  0.00524327, 0.0052422, 0.00524049, 0.00523816, 0.00523521,
  0.00523163, 0.00522742, 0.00522259, 0.00521714, 0.00521106,
  0.00520436, 0.00519704, 0.00518911, 0.00518055, 0.00517138,
  0.00516159, 0.00515119, 0.00514017, 0.00512855, 0.00511631,
  0.00510347, 0.00509002, 0.00507597, 0.00506131, 0.00504606,
  0.0050302, 0.00501375, 0.00499671, 0.00497907, 0.00496085,
  0.00494204, 0.00492264, 0.00490266, 0.0048821, 0.00486096,
  0.00483925, 0.00481697, 0.00479412, 0.00477071, 0.00474673,
  0.00472219, 0.0046971, 0.00467145, 0.00464525, 0.00461851,
  0.00459122, 0.00456339, 0.00453503, 0.00450613, 0.0044767,
  0.00444675, 0.00441627, 0.00438528, 0.00435377, 0.00432175,
  0.00428922, 0.00425619, 0.00422267, 0.00418865, 0.00415413,
  0.00411913, 0.00408365, 0.0040477, 0.00401127, 0.00397437, 0.003937,
  0.00389918, 0.0038609, 0.00382217, 0.00378299, 0.00374338,
  0.00370332, 0.00366284, 0.00362193, 0.00358059, 0.00353885,
  0.00349668, 0.00345412, 0.00341115, 0.00336778, 0.00332402,
  0.00327988, 0.00323535, 0.00319045, 0.00314518, 0.00309955,
  0.00305355, 0.0030072, 0.00296051, 0.00291347, 0.00286609,
  0.00281838, 0.00277035, 0.00272199, 0.00267332, 0.00262434,
  0.00257506, 0.00252548, 0.00247561, 0.00242545, 0.00237501,
  0.0023243, 0.00227332, 0.00222208, 0.00217058, 0.00211884,
  0.00206685, 0.00201462, 0.00196216, 0.00190947, 0.00185656,
  0.00180344, 0.00175012, 0.00169659, 0.00164287, 0.00158896,
  0.00153486, 0.00148059, 0.00142615, 0.00137155, 0.00131679,
  0.00126188, 0.00120683, 0.00115163, 0.00109631, 0.00104086,
  0.000985288, 0.000929606, 0.000873818, 0.000817929, 0.000761948,
  0.000705879, 0.00064973, 0.000593507, 0.000537216, 0.000480863,
  0.000424456, 0.000368001, 0.000311504, 0.000254971, 0.000198409,
  0.000141825, 8.52244e-05, 2.86142e-05, -2.79991e-05, -8.46093e-05,
  -0.00014121, -0.000197794, -0.000254356, -0.000310889, -0.000367387,
  -0.000423843, -0.000480252, -0.000536605, -0.000592898,
  -0.000649124, -0.000705276, -0.000761348, -0.000817334,
  -0.000873228, -0.000929022, -0.000984712, -0.00104029, -0.00109575,
  -0.00115109, -0.0012063, -0.00126137, -0.0013163, -0.00137108,
  -0.0014257, -0.00148017, -0.00153446, -0.00158859, -0.00164253,
  -0.0016963, -0.00174987, -0.00180324, -0.00185641, -0.00190937,
  -0.00196212, -0.00201464, -0.00206694, -0.00211901, -0.00217084,
  -0.00222243, -0.00227377, -0.00232485, -0.00237567, -0.00242622,
  -0.00247651, -0.00252651, -0.00257623, -0.00262567, -0.00267481,
  -0.00272365, -0.00277218, -0.00282041, -0.00286832, -0.00291591,
  -0.00296318, -0.00301011, -0.00305671, -0.00310296, -0.00314887,
  -0.00319443, -0.00323963, -0.00328448, -0.00332895, -0.00337305,
  -0.00341678, -0.00346013, -0.00350309, -0.00354567, -0.00358785,
  -0.00362962, -0.003671, -0.00371197, -0.00375252, -0.00379266,
  -0.00383238, -0.00387167, -0.00391053, -0.00394896, -0.00398695,
  -0.0040245, -0.0040616, -0.00409825, -0.00413445, -0.00417019,
  -0.00420547, -0.00424028, -0.00427463, -0.0043085, -0.00434189,
  -0.00437481, -0.00440724, -0.00443918, -0.00447063, -0.00450159,
  -0.00453206, -0.00456202, -0.00459148, -0.00462043, -0.00464887,
  -0.0046768, -0.00470422, -0.00473111, -0.00475749, -0.00478334,
  -0.00480867, -0.00483346, -0.00485773, -0.00488146, -0.00490465,
  -0.00492731, -0.00494942, -0.00497099, -0.00499201, -0.00501249,
  -0.00503241, -0.00505178, -0.0050706, -0.00508886, -0.00510657,
  -0.00512371, -0.00514029, -0.00515631, -0.00517177, -0.00518666,
  -0.00520098, -0.00521473, -0.00522791, -0.00524052, -0.00525256,
  -0.00526402, -0.00527491, -0.00528522, -0.00529496, -0.00530411,
  -0.00531269, -0.00532069, -0.0053281, -0.00533494, -0.00534119,
  -0.00534686, -0.00535195, -0.00535646, -0.00536038, -0.00536372,
  -0.00536647, -0.00536865, -0.00537023, -0.00537124, -0.00537165,
  -0.00537149, -0.00537074, -0.00536941, -0.00536749, -0.00536499,
  -0.00536191, -0.00535825, -0.005354, -0.00534918, -0.00534377,
  -0.00533779, -0.00533123, -0.00532409, -0.00531637, -0.00530808,
  -0.00529921, -0.00528977, -0.00527975, -0.00526917, -0.00525801,
  -0.00524629, -0.005234, -0.00522114, -0.00520772, -0.00519374,
  -0.00517919, -0.00516409, -0.00514843, -0.00513221, -0.00511544,
  -0.00509812, -0.00508025, -0.00506183, -0.00504287, -0.00502336,
  -0.00500331, -0.00498273, -0.0049616, -0.00493994, -0.00491776,
  -0.00489504, -0.00487179, -0.00484803, -0.00482374, -0.00479893,
  -0.00477361, -0.00474777, -0.00472142, -0.00469457, -0.00466721,
  -0.00463936, -0.004611, -0.00458215, -0.00455281, -0.00452298,
  -0.00449267, -0.00446188, -0.0044306, -0.00439886, -0.00436664,
  -0.00433395, -0.0043008, -0.0042672, -0.00423313, -0.00419861,
  -0.00416365, -0.00412823, -0.00409238, -0.00405609, -0.00401937,
  -0.00398222, -0.00394464, -0.00390664, -0.00386823, -0.0038294,
  -0.00379016, -0.00375052, -0.00371048, -0.00367005, -0.00362922,
  -0.00358801, -0.00354642, -0.00350444, -0.0034621, -0.00341939,
  -0.00337631, -0.00333287, -0.00328908, -0.00324494, -0.00320046,
  -0.00315563, -0.00311047, -0.00306498, -0.00301917, -0.00297303,
  -0.00292658, -0.00287982, -0.00283275, -0.00278538, -0.00273772,
  -0.00268976, -0.00264152, -0.00259301, -0.00254421, -0.00249515,
  -0.00244582, -0.00239624, -0.0023464, -0.00229631, -0.00224598,
  -0.00219541, -0.00214461, -0.00209359, -0.00204234, -0.00199087,
  -0.0019392, -0.00188732, -0.00183524, -0.00178297, -0.00173051,
  -0.00167787, -0.00162505, -0.00157206, -0.0015189, -0.00146559,
  -0.00141212, -0.0013585, -0.00130473, -0.00125083, -0.0011968,
  -0.00114264, -0.00108836, -0.00103397, -0.000979469, -0.000924864,
  -0.000870162, -0.000815369, -0.00076049, -0.000705531, -0.000650498,
  -0.000595396, -0.000540232, -0.000485012, -0.00042974, -0.000374423,
  -0.000319067, -0.000263678, -0.000208261, -0.000152821,
  -9.73664e-05, -4.19011e-05, 1.35685e-05, 6.90368e-05, 0.000124498,
  0.000179946, 0.000235375, 0.00029078, 0.000346154, 0.000401492,
  0.000456788, 0.000512036, 0.000567231, 0.000622366, 0.000677437,
  0.000732436, 0.00078736, 0.000842201, 0.000896954, 0.000951613,
  0.00100617, 0.00106063, 0.00111497, 0.0011692, 0.00122331,
  0.00127729, 0.00133113, 0.00138484, 0.0014384, 0.00149182,
  0.00154507, 0.00159817, 0.0016511, 0.00170386, 0.00175644,
  0.00180884, 0.00186105, 0.00191307, 0.00196488, 0.0020165,
  0.0020679, 0.00211909, 0.00217006, 0.0022208, 0.00227132, 0.0023216,
  0.00237163, 0.00242142, 0.00247096, 0.00252025, 0.00256927,
  0.00261802, 0.00266651, 0.00271471, 0.00276264, 0.00281028,
  0.00285763, 0.00290468, 0.00295143, 0.00299788, 0.00304402,
  0.00308984, 0.00313534, 0.00318052, 0.00322537, 0.00326988,
  0.00331406, 0.00335789, 0.00340138, 0.00344452, 0.0034873,
  0.00352972, 0.00357177, 0.00361346, 0.00365477, 0.00369571,
  0.00373627, 0.00377644, 0.00381622, 0.00385561, 0.00389459,
  0.00393318, 0.00397137, 0.00400914, 0.0040465, 0.00408345,
  0.00411997, 0.00415607, 0.00419174, 0.00422698, 0.00426179,
  0.00429615, 0.00433008, 0.00436356, 0.00439659, 0.00442917,
  0.00446129, 0.00449296, 0.00452416, 0.0045549, 0.00458517,
  0.00461497, 0.0046443, 0.00467315, 0.00470152, 0.00472941,
  0.00475681, 0.00478373, 0.00481015, 0.00483609, 0.00486152,
  0.00488646, 0.0049109, 0.00493483, 0.00495826, 0.00498118,
  0.00500359, 0.00502549, 0.00504687, 0.00506774, 0.00508809,
  0.00510792, 0.00512722, 0.005146, 0.00516426, 0.00518199,
  0.00519918, 0.00521585, 0.00523199, 0.00524758, 0.00526265,
  0.00527717, 0.00529116, 0.00530461, 0.00531751, 0.00532988,
  0.00534169, 0.00535297, 0.0053637, 0.00537388, 0.00538351,
  0.0053926, 0.00540113, 0.00540912, 0.00541655, 0.00542343,
  0.00542976, 0.00543554, 0.00544076, 0.00544543, 0.00544955,
  0.00545311, 0.00545611, 0.00545856, 0.00546046, 0.0054618,
  0.00546258, 0.00546281, 0.00546249, 0.00546161, 0.00546017,
  0.00545818, 0.00545564, 0.00545254, 0.00544889, 0.00544468,
  0.00543992, 0.00543461, 0.00542875, 0.00542234, 0.00541538,
  0.00540787, 0.00539981, 0.0053912, 0.00538205, 0.00537235,
  0.0053621, 0.00535132, 0.00533999, 0.00532812, 0.00531571,
  0.00530276, 0.00528928, 0.00527526, 0.00526071, 0.00524562, 0.00523,
  0.00521386, 0.00519719, 0.00517999, 0.00516227, 0.00514402,
  0.00512526, 0.00510598, 0.00508618, 0.00506587, 0.00504505,
  0.00502372, 0.00500188, 0.00497953, 0.00495668, 0.00493334,
  0.00490949, 0.00488515, 0.00486032, 0.004835, 0.00480919,
  0.00478289, 0.00475611, 0.00472885, 0.00470112, 0.00467291,
  0.00464423, 0.00461509, 0.00458548, 0.0045554, 0.00452487,
  0.00449389, 0.00446245, 0.00443056, 0.00439822, 0.00436545,
  0.00433223, 0.00429858, 0.0042645, 0.00422998, 0.00419505,
  0.00415969, 0.00412391, 0.00408772, 0.00405111, 0.0040141,
  0.00397669, 0.00393888, 0.00390067, 0.00386207, 0.00382308,
  0.00378371, 0.00374396, 0.00370384, 0.00366334, 0.00362247,
  0.00358124, 0.00353966, 0.00349771, 0.00345542, 0.00341278,
  0.0033698, 0.00332648, 0.00328283, 0.00323885, 0.00319454,
  0.00314992, 0.00310497, 0.00305972, 0.00301416, 0.0029683,
  0.00292215, 0.0028757, 0.00282896, 0.00278194, 0.00273464,
  0.00268707, 0.00263923, 0.00259112, 0.00254276, 0.00249414,
  0.00244528, 0.00239616, 0.00234681, 0.00229723, 0.00224741,
  0.00219738, 0.00214712, 0.00209664, 0.00204596, 0.00199508,
  0.00194399, 0.00189271, 0.00184124, 0.00178959, 0.00173776,
  0.00168576, 0.00163358, 0.00158125, 0.00152876, 0.00147611,
  0.00142332, 0.00137039, 0.00131732, 0.00126412, 0.00121079,
  0.00115734, 0.00110378, 0.00105011, 0.000996328, 0.000942451,
  0.00088848, 0.000834421, 0.000780279, 0.00072606, 0.000671768,
  0.000617409, 0.000562989, 0.000508513, 0.000453987, 0.000399415,
  0.000344804, 0.000290158, 0.000235483, 0.000180786, 0.00012607,
  7.13415e-05, 1.66061e-05, -3.81309e-05, -9.28641e-05, -0.000147588,
  -0.000202297, -0.000256987, -0.00031165, -0.000366283, -0.00042088,
  -0.000475434, -0.000529942, -0.000584396, -0.000638793,
  -0.000693127, -0.000747392, -0.000801582, -0.000855694, -0.00090972,
  -0.000963656, -0.0010175, -0.00107124, -0.00112487, -0.00117839,
  -0.0012318, -0.00128508, -0.00133824, -0.00139126, -0.00144415,
  -0.00149689, -0.00154948, -0.00160193, -0.00165421, -0.00170633,
  -0.00175828, -0.00181005, -0.00186165, -0.00191307, -0.00196429,
  -0.00201532, -0.00206615, -0.00211678, -0.00216719, -0.0022174,
  -0.00226738, -0.00231714, -0.00236667, -0.00241597, -0.00246502,
  -0.00251384, -0.00256241, -0.00261072, -0.00265877, -0.00270657,
  -0.00275409, -0.00280135, -0.00284832, -0.00289502, -0.00294143,
  -0.00298755, -0.00303338, -0.0030789, -0.00312413, -0.00316904,
  -0.00321365, -0.00325793, -0.0033019, -0.00334553, -0.00338884,
  -0.00343182, -0.00347445, -0.00351675, -0.0035587, -0.0036003,
  -0.00364154, -0.00368242, -0.00372294, -0.0037631, -0.00380288,
  -0.00384229, -0.00388133, -0.00391997, -0.00395824, -0.00399611,
  -0.00403359, -0.00407068, -0.00410736, -0.00414364, -0.00417952,
  -0.00421498, -0.00425002, -0.00428465, -0.00431886, -0.00435264,
  -0.004386, -0.00441892, -0.00445141, -0.00448346, -0.00451508,
  -0.00454624, -0.00457697, -0.00460724, -0.00463706, -0.00466642,
  -0.00469533, -0.00472377, -0.00475175, -0.00477927, -0.00480631,
  -0.00483289, -0.00485899, -0.00488461, -0.00490975, -0.00493441,
  -0.00495859, -0.00498228, -0.00500548, -0.00502819, -0.00505041,
  -0.00507213, -0.00509336, -0.00511409, -0.00513431, -0.00515403,
  -0.00517325, -0.00519196, -0.00521016, -0.00522785, -0.00524503,
  -0.00526169, -0.00527784, -0.00529347, -0.00530858, -0.00532318,
  -0.00533725, -0.0053508, -0.00536382, -0.00537632, -0.0053883,
  -0.00539975, -0.00541066, -0.00542105, -0.00543091, -0.00544024,
  -0.00544903, -0.00545729, -0.00546502, -0.00547221, -0.00547887,
  -0.00548499, -0.00549058, -0.00549563, -0.00550014, -0.00550411,
  -0.00550755, -0.00551045, -0.0055128, -0.00551462, -0.00551591,
  -0.00551665, -0.00551685, -0.00551652, -0.00551564, -0.00551423,
  -0.00551227, -0.00550978, -0.00550676, -0.00550319, -0.00549909,
  -0.00549444, -0.00548927, -0.00548355, -0.00547731, -0.00547052,
  -0.00546321, -0.00545536, -0.00544698, -0.00543806, -0.00542862,
  -0.00541864, -0.00540814, -0.00539711, -0.00538556, -0.00537347,
  -0.00536087, -0.00534774, -0.00533409, -0.00531992, -0.00530523,
  -0.00529003, -0.00527431, -0.00525807, -0.00524132, -0.00522406,
  -0.0052063, -0.00518802, -0.00516924, -0.00514996, -0.00513017,
  -0.00510989, -0.0050891, -0.00506782, -0.00504605, -0.00502379,
  -0.00500103, -0.00497779, -0.00495407, -0.00492986, -0.00490518,
  -0.00488001, -0.00485437, -0.00482826, -0.00480168, -0.00477463,
  -0.00474712, -0.00471914, -0.00469071, -0.00466182, -0.00463247,
  -0.00460268, -0.00457243, -0.00454175, -0.00451062, -0.00447905,
  -0.00444705, -0.00441461, -0.00438174, -0.00434845, -0.00431474,
  -0.00428061, -0.00424606, -0.00421109, -0.00417572, -0.00413995,
  -0.00410377, -0.00406719, -0.00403021, -0.00399285, -0.0039551,
  -0.00391696, -0.00387844, -0.00383955, -0.00380028, -0.00376064,
  -0.00372064, -0.00368028, -0.00363956, -0.00359848, -0.00355706,
  -0.00351529, -0.00347318, -0.00343073, -0.00338795, -0.00334484,
  -0.00330141, -0.00325766, -0.00321359, -0.0031692, -0.00312451,
  -0.00307952, -0.00303423, -0.00298864, -0.00294277, -0.0028966,
  -0.00285016, -0.00280344, -0.00275645, -0.00270919, -0.00266167,
  -0.00261389, -0.00256586, -0.00251758, -0.00246905, -0.00242029,
  -0.00237129, -0.00232206, -0.0022726, -0.00222293, -0.00217304,
  -0.00212294, -0.00207263, -0.00202212, -0.00197142, -0.00192052,
  -0.00186944, -0.00181818, -0.00176674, -0.00171513, -0.00166336,
  -0.00161142, -0.00155933, -0.00150708, -0.00145469, -0.00140216,
  -0.00134949, -0.0012967, -0.00124377, -0.00119073, -0.00113757,
  -0.0010843, -0.00103093, -0.000977453, -0.000923884, -0.000870226,
  -0.000816484, -0.000762663, -0.000708768, -0.000654804,
  -0.000600777, -0.000546691, -0.000492553, -0.000438367,
  -0.000384139, -0.000329873, -0.000275576, -0.000221251,
  -0.000166906, -0.000112544, -5.81713e-05, -3.79298e-06, 5.05857e-05,
  0.00010496, 0.000159323, 0.000213671, 0.000267999, 0.000322301,
  0.000376571, 0.000430805, 0.000484998, 0.000539144, 0.000593237,
  0.000647273, 0.000701247, 0.000755152, 0.000808985, 0.00086274,
  0.000916411, 0.000969993, 0.00102348, 0.00107687, 0.00113016,
  0.00118333, 0.0012364, 0.00128934, 0.00134216, 0.00139485,
  0.0014474, 0.00149981, 0.00155208, 0.0016042, 0.00165616,
  0.00170797, 0.00175961, 0.00181107, 0.00186237, 0.00191348,
  0.00196441, 0.00201515, 0.00206569, 0.00211604, 0.00216618,
  0.00221611, 0.00226583, 0.00231533, 0.0023646, 0.00241365,
  0.00246246, 0.00251104, 0.00255937, 0.00260745, 0.00265529,
  0.00270287, 0.00275018, 0.00279723, 0.00284401, 0.00289052,
  0.00293675, 0.00298269, 0.00302835, 0.00307371, 0.00311878,
  0.00316354, 0.003208, 0.00325215, 0.00329599, 0.00333951, 0.0033827,
  0.00342557, 0.00346811, 0.00351031, 0.00355218, 0.0035937,
  0.00363487, 0.0036757, 0.00371617, 0.00375628, 0.00379603,
  0.00383541, 0.00387442, 0.00391306, 0.00395132, 0.0039892,
  0.00402669, 0.0040638, 0.00410051, 0.00413683, 0.00417275,
  0.00420826, 0.00424337, 0.00427807, 0.00431236, 0.00434623,
  0.00437969, 0.00441271, 0.00444532, 0.00447749, 0.00450924,
  0.00454054, 0.00457141, 0.00460184, 0.00463183, 0.00466137,
  0.00469046, 0.00471909, 0.00474727, 0.004775, 0.00480226,
  0.00482906, 0.00485539, 0.00488126, 0.00490665, 0.00493157,
  0.00495602, 0.00497998, 0.00500347, 0.00502647, 0.00504899,
  0.00507103, 0.00509257, 0.00511362, 0.00513418, 0.00515425,
  0.00517381, 0.00519288, 0.00521145, 0.00522951, 0.00524707,
  0.00526413, 0.00528067, 0.00529671, 0.00531224, 0.00532725,
  0.00534175, 0.00535574, 0.0053692, 0.00538216, 0.00539459,
  0.0054065, 0.00541789, 0.00542876, 0.0054391, 0.00544892,
  0.00545822, 0.00546699, 0.00547523, 0.00548294, 0.00549012,
  0.00549678, 0.0055029, 0.0055085, 0.00551356, 0.00551809,
  0.00552209, 0.00552556, 0.00552849, 0.00553089, 0.00553276,
  0.0055341, 0.0055349, 0.00553516, 0.0055349, 0.0055341, 0.00553276,
  0.00553089, 0.00552849, 0.00552556, 0.00552209, 0.00551809,
  0.00551356, 0.0055085, 0.0055029, 0.00549678, 0.00549012,
  0.00548294, 0.00547523, 0.00546699, 0.00545822, 0.00544892,
  0.0054391, 0.00542876, 0.00541789, 0.0054065, 0.00539459,
  0.00538216, 0.0053692, 0.00535574, 0.00534175, 0.00532725,
  0.00531224, 0.00529671, 0.00528067, 0.00526413, 0.00524707,
  0.00522951, 0.00521145, 0.00519288, 0.00517381, 0.00515425,
  0.00513418, 0.00511362, 0.00509257, 0.00507103, 0.00504899,
  0.00502647, 0.00500347, 0.00497998, 0.00495602, 0.00493157,
  0.00490665, 0.00488126, 0.00485539, 0.00482906, 0.00480226,
  0.004775, 0.00474727, 0.00471909, 0.00469046, 0.00466137,
  0.00463183, 0.00460184, 0.00457141, 0.00454054, 0.00450924,
  0.00447749, 0.00444532, 0.00441271, 0.00437969, 0.00434623,
  0.00431236, 0.00427807, 0.00424337, 0.00420826, 0.00417275,
  0.00413683, 0.00410051, 0.0040638, 0.00402669, 0.0039892,
  0.00395132, 0.00391306, 0.00387442, 0.00383541, 0.00379603,
  0.00375628, 0.00371617, 0.0036757, 0.00363487, 0.0035937,
  0.00355218, 0.00351031, 0.00346811, 0.00342557, 0.0033827,
  0.00333951, 0.00329599, 0.00325215, 0.003208, 0.00316354,
  0.00311878, 0.00307371, 0.00302835, 0.00298269, 0.00293675,
  0.00289052, 0.00284401, 0.00279723, 0.00275018, 0.00270287,
  0.00265529, 0.00260745, 0.00255937, 0.00251104, 0.00246246,
  0.00241365, 0.0023646, 0.00231533, 0.00226583, 0.00221611,
  0.00216618, 0.00211604, 0.00206569, 0.00201515, 0.00196441,
  0.00191348, 0.00186237, 0.00181107, 0.00175961, 0.00170797,
  0.00165616, 0.0016042, 0.00155208, 0.00149981, 0.0014474,
  0.00139485, 0.00134216, 0.00128934, 0.0012364, 0.00118333,
  0.00113016, 0.00107687, 0.00102348, 0.000969993, 0.000916411,
  0.00086274, 0.000808985, 0.000755152, 0.000701247, 0.000647273,
  0.000593237, 0.000539144, 0.000484998, 0.000430805, 0.000376571,
  0.000322301, 0.000267999, 0.000213671, 0.000159323, 0.00010496,
  5.05857e-05, -3.79298e-06, -5.81713e-05, -0.000112544, -0.000166906,
  -0.000221251, -0.000275576, -0.000329873, -0.000384139,
  -0.000438367, -0.000492553, -0.000546691, -0.000600777,
  -0.000654804, -0.000708768, -0.000762663, -0.000816484,
  -0.000870226, -0.000923884, -0.000977453, -0.00103093, -0.0010843,
  -0.00113757, -0.00119073, -0.00124377, -0.0012967, -0.00134949,
  -0.00140216, -0.00145469, -0.00150708, -0.00155933, -0.00161142,
  -0.00166336, -0.00171513, -0.00176674, -0.00181818, -0.00186944,
  -0.00192052, -0.00197142, -0.00202212, -0.00207263, -0.00212294,
  -0.00217304, -0.00222293, -0.0022726, -0.00232206, -0.00237129,
  -0.00242029, -0.00246905, -0.00251758, -0.00256586, -0.00261389,
  -0.00266167, -0.00270919, -0.00275645, -0.00280344, -0.00285016,
  -0.0028966, -0.00294277, -0.00298864, -0.00303423, -0.00307952,
  -0.00312451, -0.0031692, -0.00321359, -0.00325766, -0.00330141,
  -0.00334484, -0.00338795, -0.00343073, -0.00347318, -0.00351529,
  -0.00355706, -0.00359848, -0.00363956, -0.00368028, -0.00372064,
  -0.00376064, -0.00380028, -0.00383955, -0.00387844, -0.00391696,
  -0.0039551, -0.00399285, -0.00403021, -0.00406719, -0.00410377,
  -0.00413995, -0.00417572, -0.00421109, -0.00424606, -0.00428061,
  -0.00431474, -0.00434845, -0.00438174, -0.00441461, -0.00444705,
  -0.00447905, -0.00451062, -0.00454175, -0.00457243, -0.00460268,
  -0.00463247, -0.00466182, -0.00469071, -0.00471914, -0.00474712,
  -0.00477463, -0.00480168, -0.00482826, -0.00485437, -0.00488001,
  -0.00490518, -0.00492986, -0.00495407, -0.00497779, -0.00500103,
  -0.00502379, -0.00504605, -0.00506782, -0.0050891, -0.00510989,
  -0.00513017, -0.00514996, -0.00516924, -0.00518802, -0.0052063,
  -0.00522406, -0.00524132, -0.00525807, -0.00527431, -0.00529003,
  -0.00530523, -0.00531992, -0.00533409, -0.00534774, -0.00536087,
  -0.00537347, -0.00538556, -0.00539711, -0.00540814, -0.00541864,
  -0.00542862, -0.00543806, -0.00544698, -0.00545536, -0.00546321,
  -0.00547052, -0.00547731, -0.00548355, -0.00548927, -0.00549444,
  -0.00549909, -0.00550319, -0.00550676, -0.00550978, -0.00551227,
  -0.00551423, -0.00551564, -0.00551652, -0.00551685, -0.00551665,
  -0.00551591, -0.00551462, -0.0055128, -0.00551045, -0.00550755,
  -0.00550411, -0.00550014, -0.00549563, -0.00549058, -0.00548499,
  -0.00547887, -0.00547221, -0.00546502, -0.00545729, -0.00544903,
  -0.00544024, -0.00543091, -0.00542105, -0.00541066, -0.00539975,
  -0.0053883, -0.00537632, -0.00536382, -0.0053508, -0.00533725,
  -0.00532318, -0.00530858, -0.00529347, -0.00527784, -0.00526169,
  -0.00524503, -0.00522785, -0.00521016, -0.00519196, -0.00517325,
  -0.00515403, -0.00513431, -0.00511409, -0.00509336, -0.00507213,
  -0.00505041, -0.00502819, -0.00500548, -0.00498228, -0.00495859,
  -0.00493441, -0.00490975, -0.00488461, -0.00485899, -0.00483289,
  -0.00480631, -0.00477927, -0.00475175, -0.00472377, -0.00469533,
  -0.00466642, -0.00463706, -0.00460724, -0.00457697, -0.00454624,
  -0.00451508, -0.00448346, -0.00445141, -0.00441892, -0.004386,
  -0.00435264, -0.00431886, -0.00428465, -0.00425002, -0.00421498,
  -0.00417952, -0.00414364, -0.00410736, -0.00407068, -0.00403359,
  -0.00399611, -0.00395824, -0.00391997, -0.00388133, -0.00384229,
  -0.00380288, -0.0037631, -0.00372294, -0.00368242, -0.00364154,
  -0.0036003, -0.0035587, -0.00351675, -0.00347445, -0.00343182,
  -0.00338884, -0.00334553, -0.0033019, -0.00325793, -0.00321365,
  -0.00316904, -0.00312413, -0.0030789, -0.00303338, -0.00298755,
  -0.00294143, -0.00289502, -0.00284832, -0.00280135, -0.00275409,
  -0.00270657, -0.00265877, -0.00261072, -0.00256241, -0.00251384,
  -0.00246502, -0.00241597, -0.00236667, -0.00231714, -0.00226738,
  -0.0022174, -0.00216719, -0.00211678, -0.00206615, -0.00201532,
  -0.00196429, -0.00191307, -0.00186165, -0.00181005, -0.00175828,
  -0.00170633, -0.00165421, -0.00160193, -0.00154948, -0.00149689,
  -0.00144415, -0.00139126, -0.00133824, -0.00128508, -0.0012318,
  -0.00117839, -0.00112487, -0.00107124, -0.0010175, -0.000963656,
  -0.00090972, -0.000855694, -0.000801582, -0.000747392, -0.000693127,
  -0.000638793, -0.000584396, -0.000529942, -0.000475434, -0.00042088,
  -0.000366283, -0.00031165, -0.000256987, -0.000202297, -0.000147588,
  -9.28641e-05, -3.81309e-05, 1.66061e-05, 7.13415e-05, 0.00012607,
  0.000180786, 0.000235483, 0.000290158, 0.000344804, 0.000399415,
  0.000453987, 0.000508513, 0.000562989, 0.000617409, 0.000671768,
  0.00072606, 0.000780279, 0.000834421, 0.00088848, 0.000942451,
  0.000996328, 0.00105011, 0.00110378, 0.00115734, 0.00121079,
  0.00126412, 0.00131732, 0.00137039, 0.00142332, 0.00147611,
  0.00152876, 0.00158125, 0.00163358, 0.00168576, 0.00173776,
  0.00178959, 0.00184124, 0.00189271, 0.00194399, 0.00199508,
  0.00204596, 0.00209664, 0.00214712, 0.00219738, 0.00224741,
  0.00229723, 0.00234681, 0.00239616, 0.00244528, 0.00249414,
  0.00254276, 0.00259112, 0.00263923, 0.00268707, 0.00273464,
  0.00278194, 0.00282896, 0.0028757, 0.00292215, 0.0029683,
  0.00301416, 0.00305972, 0.00310497, 0.00314992, 0.00319454,
  0.00323885, 0.00328283, 0.00332648, 0.0033698, 0.00341278,
  0.00345542, 0.00349771, 0.00353966, 0.00358124, 0.00362247,
  0.00366334, 0.00370384, 0.00374396, 0.00378371, 0.00382308,
  0.00386207, 0.00390067, 0.00393888, 0.00397669, 0.0040141,
  0.00405111, 0.00408772, 0.00412391, 0.00415969, 0.00419505,
  0.00422998, 0.0042645, 0.00429858, 0.00433223, 0.00436545,
  0.00439822, 0.00443056, 0.00446245, 0.00449389, 0.00452487,
  0.0045554, 0.00458548, 0.00461509, 0.00464423, 0.00467291,
  0.00470112, 0.00472885, 0.00475611, 0.00478289, 0.00480919,
  0.004835, 0.00486032, 0.00488515, 0.00490949, 0.00493334,
  0.00495668, 0.00497953, 0.00500188, 0.00502372, 0.00504505,
  0.00506587, 0.00508618, 0.00510598, 0.00512526, 0.00514402,
  0.00516227, 0.00517999, 0.00519719, 0.00521386, 0.00523, 0.00524562,
  0.00526071, 0.00527526, 0.00528928, 0.00530276, 0.00531571,
  0.00532812, 0.00533999, 0.00535132, 0.0053621, 0.00537235,
  0.00538205, 0.0053912, 0.00539981, 0.00540787, 0.00541538,
  0.00542234, 0.00542875, 0.00543461, 0.00543992, 0.00544468,
  0.00544889, 0.00545254, 0.00545564, 0.00545818, 0.00546017,
  0.00546161, 0.00546249, 0.00546281, 0.00546258, 0.0054618,
  0.00546046, 0.00545856, 0.00545611, 0.00545311, 0.00544955,
  0.00544543, 0.00544076, 0.00543554, 0.00542976, 0.00542343,
  0.00541655, 0.00540912, 0.00540113, 0.0053926, 0.00538351,
  0.00537388, 0.0053637, 0.00535297, 0.00534169, 0.00532988,
  0.00531751, 0.00530461, 0.00529116, 0.00527717, 0.00526265,
  0.00524758, 0.00523199, 0.00521585, 0.00519918, 0.00518199,
  0.00516426, 0.005146, 0.00512722, 0.00510792, 0.00508809,
  0.00506774, 0.00504687, 0.00502549, 0.00500359, 0.00498118,
  0.00495826, 0.00493483, 0.0049109, 0.00488646, 0.00486152,
  0.00483609, 0.00481015, 0.00478373, 0.00475681, 0.00472941,
  0.00470152, 0.00467315, 0.0046443, 0.00461497, 0.00458517,
  0.0045549, 0.00452416, 0.00449296, 0.00446129, 0.00442917,
  0.00439659, 0.00436356, 0.00433008, 0.00429615, 0.00426179,
  0.00422698, 0.00419174, 0.00415607, 0.00411997, 0.00408345,
  0.0040465, 0.00400914, 0.00397137, 0.00393318, 0.00389459,
  0.00385561, 0.00381622, 0.00377644, 0.00373627, 0.00369571,
  0.00365477, 0.00361346, 0.00357177, 0.00352972, 0.0034873,
  0.00344452, 0.00340138, 0.00335789, 0.00331406, 0.00326988,
  0.00322537, 0.00318052, 0.00313534, 0.00308984, 0.00304402,
  0.00299788, 0.00295143, 0.00290468, 0.00285763, 0.00281028,
  0.00276264, 0.00271471, 0.00266651, 0.00261802, 0.00256927,
  0.00252025, 0.00247096, 0.00242142, 0.00237163, 0.0023216,
  0.00227132, 0.0022208, 0.00217006, 0.00211909, 0.0020679, 0.0020165,
  0.00196488, 0.00191307, 0.00186105, 0.00180884, 0.00175644,
  0.00170386, 0.0016511, 0.00159817, 0.00154507, 0.00149182,
  0.0014384, 0.00138484, 0.00133113, 0.00127729, 0.00122331,
  0.0011692, 0.00111497, 0.00106063, 0.00100617, 0.000951613,
  0.000896954, 0.000842201, 0.00078736, 0.000732436, 0.000677437,
  0.000622366, 0.000567231, 0.000512036, 0.000456788, 0.000401492,
  0.000346154, 0.00029078, 0.000235375, 0.000179946, 0.000124498,
  6.90368e-05, 1.35685e-05, -4.19011e-05, -9.73664e-05, -0.000152821,
  -0.000208261, -0.000263678, -0.000319067, -0.000374423, -0.00042974,
  -0.000485012, -0.000540232, -0.000595396, -0.000650498,
  -0.000705531, -0.00076049, -0.000815369, -0.000870162, -0.000924864,
  -0.000979469, -0.00103397, -0.00108836, -0.00114264, -0.0011968,
  -0.00125083, -0.00130473, -0.0013585, -0.00141212, -0.00146559,
  -0.0015189, -0.00157206, -0.00162505, -0.00167787, -0.00173051,
  -0.00178297, -0.00183524, -0.00188732, -0.0019392, -0.00199087,
  -0.00204234, -0.00209359, -0.00214461, -0.00219541, -0.00224598,
  -0.00229631, -0.0023464, -0.00239624, -0.00244582, -0.00249515,
  -0.00254421, -0.00259301, -0.00264152, -0.00268976, -0.00273772,
  -0.00278538, -0.00283275, -0.00287982, -0.00292658, -0.00297303,
  -0.00301917, -0.00306498, -0.00311047, -0.00315563, -0.00320046,
  -0.00324494, -0.00328908, -0.00333287, -0.00337631, -0.00341939,
  -0.0034621, -0.00350444, -0.00354642, -0.00358801, -0.00362922,
  -0.00367005, -0.00371048, -0.00375052, -0.00379016, -0.0038294,
  -0.00386823, -0.00390664, -0.00394464, -0.00398222, -0.00401937,
  -0.00405609, -0.00409238, -0.00412823, -0.00416365, -0.00419861,
  -0.00423313, -0.0042672, -0.0043008, -0.00433395, -0.00436664,
  -0.00439886, -0.0044306, -0.00446188, -0.00449267, -0.00452298,
  -0.00455281, -0.00458215, -0.004611, -0.00463936, -0.00466721,
  -0.00469457, -0.00472142, -0.00474777, -0.00477361, -0.00479893,
  -0.00482374, -0.00484803, -0.00487179, -0.00489504, -0.00491776,
  -0.00493994, -0.0049616, -0.00498273, -0.00500331, -0.00502336,
  -0.00504287, -0.00506183, -0.00508025, -0.00509812, -0.00511544,
  -0.00513221, -0.00514843, -0.00516409, -0.00517919, -0.00519374,
  -0.00520772, -0.00522114, -0.005234, -0.00524629, -0.00525801,
  -0.00526917, -0.00527975, -0.00528977, -0.00529921, -0.00530808,
  -0.00531637, -0.00532409, -0.00533123, -0.00533779, -0.00534377,
  -0.00534918, -0.005354, -0.00535825, -0.00536191, -0.00536499,
  -0.00536749, -0.00536941, -0.00537074, -0.00537149, -0.00537165,
  -0.00537124, -0.00537023, -0.00536865, -0.00536647, -0.00536372,
  -0.00536038, -0.00535646, -0.00535195, -0.00534686, -0.00534119,
  -0.00533494, -0.0053281, -0.00532069, -0.00531269, -0.00530411,
  -0.00529496, -0.00528522, -0.00527491, -0.00526402, -0.00525256,
  -0.00524052, -0.00522791, -0.00521473, -0.00520098, -0.00518666,
  -0.00517177, -0.00515631, -0.00514029, -0.00512371, -0.00510657,
  -0.00508886, -0.0050706, -0.00505178, -0.00503241, -0.00501249,
  -0.00499201, -0.00497099, -0.00494942, -0.00492731, -0.00490465,
  -0.00488146, -0.00485773, -0.00483346, -0.00480867, -0.00478334,
  -0.00475749, -0.00473111, -0.00470422, -0.0046768, -0.00464887,
  -0.00462043, -0.00459148, -0.00456202, -0.00453206, -0.00450159,
  -0.00447063, -0.00443918, -0.00440724, -0.00437481, -0.00434189,
  -0.0043085, -0.00427463, -0.00424028, -0.00420547, -0.00417019,
  -0.00413445, -0.00409825, -0.0040616, -0.0040245, -0.00398695,
  -0.00394896, -0.00391053, -0.00387167, -0.00383238, -0.00379266,
  -0.00375252, -0.00371197, -0.003671, -0.00362962, -0.00358785,
  -0.00354567, -0.00350309, -0.00346013, -0.00341678, -0.00337305,
  -0.00332895, -0.00328448, -0.00323963, -0.00319443, -0.00314887,
  -0.00310296, -0.00305671, -0.00301011, -0.00296318, -0.00291591,
  -0.00286832, -0.00282041, -0.00277218, -0.00272365, -0.00267481,
  -0.00262567, -0.00257623, -0.00252651, -0.00247651, -0.00242622,
  -0.00237567, -0.00232485, -0.00227377, -0.00222243, -0.00217084,
  -0.00211901, -0.00206694, -0.00201464, -0.00196212, -0.00190937,
  -0.00185641, -0.00180324, -0.00174987, -0.0016963, -0.00164253,
  -0.00158859, -0.00153446, -0.00148017, -0.0014257, -0.00137108,
  -0.0013163, -0.00126137, -0.0012063, -0.00115109, -0.00109575,
  -0.00104029, -0.000984712, -0.000929022, -0.000873228, -0.000817334,
  -0.000761348, -0.000705276, -0.000649124, -0.000592898,
  -0.000536605, -0.000480252, -0.000423843, -0.000367387,
  -0.000310889, -0.000254356, -0.000197794, -0.00014121, -8.46093e-05,
  -2.79991e-05, 2.86142e-05, 8.52244e-05, 0.000141825, 0.000198409,
  0.000254971, 0.000311504, 0.000368001, 0.000424456, 0.000480863,
  0.000537216, 0.000593507, 0.00064973, 0.000705879, 0.000761948,
  0.000817929, 0.000873818, 0.000929606, 0.000985288, 0.00104086,
  0.00109631, 0.00115163, 0.00120683, 0.00126188, 0.00131679,
  0.00137155, 0.00142615, 0.00148059, 0.00153486, 0.00158896,
  0.00164287, 0.00169659, 0.00175012, 0.00180344, 0.00185656,
  0.00190947, 0.00196216, 0.00201462, 0.00206685, 0.00211884,
  0.00217058, 0.00222208, 0.00227332, 0.0023243, 0.00237501,
  0.00242545, 0.00247561, 0.00252548, 0.00257506, 0.00262434,
  0.00267332, 0.00272199, 0.00277035, 0.00281838, 0.00286609,
  0.00291347, 0.00296051, 0.0030072, 0.00305355, 0.00309955,
  0.00314518, 0.00319045, 0.00323535, 0.00327988, 0.00332402,
  0.00336778, 0.00341115, 0.00345412, 0.00349668, 0.00353885,
  0.00358059, 0.00362193, 0.00366284, 0.00370332, 0.00374338,
  0.00378299, 0.00382217, 0.0038609, 0.00389918, 0.003937, 0.00397437,
  0.00401127, 0.0040477, 0.00408365, 0.00411913, 0.00415413,
  0.00418865, 0.00422267, 0.00425619, 0.00428922, 0.00432175,
  0.00435377, 0.00438528, 0.00441627, 0.00444675, 0.0044767,
  0.00450613, 0.00453503, 0.00456339, 0.00459122, 0.00461851,
  0.00464525, 0.00467145, 0.0046971, 0.00472219, 0.00474673,
  0.00477071, 0.00479412, 0.00481697, 0.00483925, 0.00486096,
  0.0048821, 0.00490266, 0.00492264, 0.00494204, 0.00496085,
  0.00497907, 0.00499671, 0.00501375, 0.0050302, 0.00504606,
  0.00506131, 0.00507597, 0.00509002, 0.00510347, 0.00511631,
  0.00512855, 0.00514017, 0.00515119, 0.00516159, 0.00517138,
  0.00518055, 0.00518911, 0.00519704, 0.00520436, 0.00521106,
  0.00521714, 0.00522259, 0.00522742, 0.00523163, 0.00523521,
  0.00523816, 0.00524049, 0.0052422, 0.00524327, 0.00524372,
  0.00524354, 0.00524274, 0.0052413, 0.00523924, 0.00523655,
  0.00523323, 0.00522928, 0.00522471, 0.0052195, 0.00521367,
  0.00520722, 0.00520013, 0.00519243, 0.00518409, 0.00517514,
  0.00516556, 0.00515535, 0.00514453, 0.00513309, 0.00512102,
  0.00510834, 0.00509505, 0.00508113, 0.00506661, 0.00505147,
  0.00503572, 0.00501936, 0.00500239, 0.00498482, 0.00496664,
  0.00494787, 0.00492849, 0.00490851, 0.00488794, 0.00486678,
  0.00484503, 0.00482268, 0.00479976, 0.00477624, 0.00475215,
  0.00472748, 0.00470223, 0.00467642, 0.00465003, 0.00462307,
  0.00459555, 0.00456748, 0.00453884, 0.00450965, 0.00447991,
  0.00444962, 0.00441879, 0.00438742, 0.00435551, 0.00432307,
  0.0042901, 0.0042566, 0.00422258, 0.00418805, 0.004153, 0.00411744,
  0.00408138, 0.00404482, 0.00400776, 0.0039702, 0.00393216,
  0.00389364, 0.00385463, 0.00381515, 0.00377521, 0.00373479,
  0.00369392, 0.00365259, 0.00361081, 0.00356859, 0.00352592,
  0.00348282, 0.00343929, 0.00339533, 0.00335096, 0.00330617,
  0.00326097, 0.00321536, 0.00316936, 0.00312297, 0.00307618,
  0.00302902, 0.00298148, 0.00293357, 0.0028853, 0.00283667,
  0.00278768, 0.00273835, 0.00268868, 0.00263867, 0.00258834,
  0.00253768, 0.00248671, 0.00243542, 0.00238383, 0.00233195,
  0.00227977, 0.00222731, 0.00217457, 0.00212156, 0.00206828,
  0.00201475, 0.00196096, 0.00190693, 0.00185266, 0.00179815,
  0.00174342, 0.00168847, 0.00163331, 0.00157795, 0.00152238,
  0.00146663, 0.00141069, 0.00135457, 0.00129828, 0.00124183,
  0.00118523, 0.00112847, 0.00107157, 0.00101454, 0.000957375,
  0.000900092, 0.000842695, 0.000785192, 0.00072759, 0.000669896,
  0.000612117, 0.00055426, 0.000496333, 0.000438344, 0.000380298,
  0.000322205, 0.000264071, 0.000205903, 0.000147709, 8.94964e-05,
  3.12723e-05, -2.69557e-05, -8.51802e-05, -0.000143394, -0.000201589,
  -0.000259759, -0.000317896, -0.000375992, -0.00043404, -0.000492032,
  -0.000549962, -0.000607821, -0.000665603, -0.0007233, -0.000780904,
  -0.000838408, -0.000895804, -0.000953086, -0.00101025, -0.00106728,
  -0.00112417, -0.00118092, -0.00123751, -0.00129395, -0.00135022,
  -0.00140632, -0.00146224, -0.00151797, -0.0015735, -0.00162883,
  -0.00168395, -0.00173885, -0.00179353, -0.00184798, -0.00190219,
  -0.00195615, -0.00200986, -0.00206331, -0.00211649, -0.0021694,
  -0.00222202, -0.00227436, -0.00232641, -0.00237815, -0.00242958,
  -0.0024807, -0.0025315, -0.00258196, -0.00263209, -0.00268188,
  -0.00273132, -0.0027804, -0.00282912, -0.00287747, -0.00292545,
  -0.00297304, -0.00302025, -0.00306706, -0.00311347, -0.00315948,
  -0.00320507, -0.00325024, -0.00329498, -0.00333929, -0.00338317,
  -0.0034266, -0.00346958, -0.00351211, -0.00355417, -0.00359577,
  -0.0036369, -0.00367754, -0.0037177, -0.00375738, -0.00379655,
  -0.00383523, -0.0038734, -0.00391106, -0.0039482, -0.00398483,
  -0.00402092, -0.00405649, -0.00409151, -0.004126, -0.00415994,
  -0.00419332, -0.00422615, -0.00425843, -0.00429013, -0.00432127,
  -0.00435183, -0.00438181, -0.00441121, -0.00444003, -0.00446825,
  -0.00449588, -0.00452291, -0.00454933, -0.00457515, -0.00460036,
  -0.00462496, -0.00464893, -0.00467229, -0.00469502, -0.00471712,
  -0.00473859, -0.00475942, -0.00477962, -0.00479918, -0.00481809,
  -0.00483635, -0.00485397, -0.00487093, -0.00488724, -0.00490289,
  -0.00491788, -0.00493221, -0.00494588, -0.00495888, -0.0049712,
  -0.00498286, -0.00499385, -0.00500416, -0.00501379, -0.00502275,
  -0.00503102, -0.00503862, -0.00504553, -0.00505176, -0.00505731,
  -0.00506216, -0.00506633, -0.00506982, -0.00507261, -0.00507471,
  -0.00507613, -0.00507685, -0.00507688, -0.00507622, -0.00507486,
  -0.00507282, -0.00507008, -0.00506665, -0.00506253, -0.00505771,
  -0.00505221, -0.00504601, -0.00503912, -0.00503154, -0.00502327,
  -0.00501431, -0.00500466, -0.00499433, -0.00498331, -0.0049716,
  -0.00495921, -0.00494614, -0.00493239, -0.00491796, -0.00490285,
  -0.00488706, -0.0048706, -0.00485346, -0.00483566, -0.00481718,
  -0.00479805, -0.00477824, -0.00475778, -0.00473665, -0.00471487,
  -0.00469243, -0.00466935, -0.00464561, -0.00462123, -0.00459621,
  -0.00457055, -0.00454425, -0.00451732, -0.00448975, -0.00446157,
  -0.00443276, -0.00440333, -0.00437329, -0.00434263, -0.00431137,
  -0.0042795, -0.00424704, -0.00421398, -0.00418033, -0.00414609,
  -0.00411128, -0.00407588, -0.00403991, -0.00400338, -0.00396628,
  -0.00392862, -0.00389041, -0.00385165, -0.00381235, -0.00377251,
  -0.00373214, -0.00369124, -0.00364982, -0.00360789, -0.00356544,
  -0.00352249, -0.00347904, -0.00343509, -0.00339066, -0.00334575,
  -0.00330036, -0.00325451, -0.00320819, -0.00316141, -0.00311419,
  -0.00306652, -0.00301842, -0.00296988, -0.00292092, -0.00287154,
  -0.00282176, -0.00277157, -0.00272098, -0.00267001, -0.00261865,
  -0.00256692, -0.00251481, -0.00246235, -0.00240954, -0.00235638,
  -0.00230288, -0.00224905, -0.00219489, -0.00214042, -0.00208564,
  -0.00203056, -0.00197519, -0.00191953, -0.0018636, -0.00180739,
  -0.00175093, -0.00169421, -0.00163724, -0.00158004, -0.00152261,
  -0.00146496, -0.0014071, -0.00134903, -0.00129076, -0.00123231,
  -0.00117368, -0.00111488, -0.00105591, -0.000996796, -0.000937532,
  -0.000878131, -0.000818602, -0.000758953, -0.000699194,
  -0.000639332, -0.000579376, -0.000519336, -0.000459219,
  -0.000399035, -0.000338792, -0.0002785, -0.000218167, -0.000157801,
  -9.74124e-05, -3.70094e-05, 2.33991e-05, 8.38042e-05, 0.000144197,
  0.000204568, 0.00026491, 0.000325212, 0.000385466, 0.000445663,
  0.000505794, 0.00056585, 0.000625822, 0.000685701, 0.000745479,
  0.000805146, 0.000864693, 0.000924111, 0.000983392, 0.00104253,
  0.00110151, 0.00116032, 0.00121896, 0.00127742, 0.00133569,
  0.00139376, 0.00145162, 0.00150926, 0.00156668, 0.00162386,
  0.0016808, 0.00173748, 0.00179391, 0.00185006, 0.00190594,
  0.00196153, 0.00201682, 0.00207181, 0.00212649, 0.00218085,
  0.00223487, 0.00228856, 0.0023419, 0.00239489, 0.00244752,
  0.00249977, 0.00255165, 0.00260314, 0.00265423, 0.00270492,
  0.0027552, 0.00280506, 0.00285449, 0.00290348, 0.00295204,
  0.00300014, 0.00304779, 0.00309496, 0.00314167, 0.0031879,
  0.00323363, 0.00327887, 0.00332361, 0.00336784, 0.00341155,
  0.00345474, 0.00349739, 0.00353951, 0.00358108, 0.0036221,
  0.00366257, 0.00370246, 0.00374179, 0.00378054, 0.0038187,
  0.00385627, 0.00389324, 0.00392961, 0.00396538, 0.00400052,
  0.00403505, 0.00406894, 0.00410221, 0.00413483, 0.00416682,
  0.00419815, 0.00422883, 0.00425885, 0.0042882, 0.00431688,
  0.00434489, 0.00437222, 0.00439886, 0.00442481, 0.00445007,
  0.00447463, 0.00449849, 0.00452164, 0.00454408, 0.0045658,
  0.00458681, 0.00460709, 0.00462664, 0.00464547, 0.00466356,
  0.00468091, 0.00469752, 0.00471339, 0.00472851, 0.00474288,
  0.0047565, 0.00476936, 0.00478147, 0.00479281, 0.0048034,
  0.00481321, 0.00482226, 0.00483054, 0.00483805, 0.00484479,
  0.00485075, 0.00485593, 0.00486034, 0.00486397, 0.00486682,
  0.00486889, 0.00487017, 0.00487068, 0.0048704, 0.00486933,
  0.00486748, 0.00486485, 0.00486143, 0.00485723, 0.00485224,
  0.00484647, 0.00483991, 0.00483257, 0.00482445, 0.00481554,
  0.00480585, 0.00479538, 0.00478414, 0.00477211, 0.0047593,
  0.00474573, 0.00473137, 0.00471625, 0.00470035, 0.00468369,
  0.00466626, 0.00464807, 0.00462911, 0.0046094, 0.00458893,
  0.0045677, 0.00454573, 0.00452301, 0.00449954, 0.00447533,
  0.00445039, 0.00442471, 0.0043983, 0.00437116, 0.0043433,
  0.00431472, 0.00428543, 0.00425542, 0.00422471, 0.0041933,
  0.00416119, 0.00412839, 0.0040949, 0.00406073, 0.00402589,
  0.00399037, 0.00395418, 0.00391734, 0.00387984, 0.00384169,
  0.0038029, 0.00376347, 0.0037234, 0.00368272, 0.00364141,
  0.00359949, 0.00355697, 0.00351384, 0.00347013, 0.00342582,
  0.00338094, 0.00333549, 0.00328948, 0.0032429, 0.00319578,
  0.00314812, 0.00309992, 0.00305119, 0.00300195, 0.0029522,
  0.00290194, 0.00285119, 0.00279995, 0.00274823, 0.00269605,
  0.0026434, 0.0025903, 0.00253676, 0.00248278, 0.00242838,
  0.00237356, 0.00231833, 0.00226271, 0.00220669, 0.00215029,
  0.00209353, 0.0020364, 0.00197892, 0.0019211, 0.00186294,
  0.00180446, 0.00174567, 0.00168658, 0.0016272, 0.00156753,
  0.00150759, 0.00144738, 0.00138693, 0.00132623, 0.0012653,
  0.00120415, 0.00114279, 0.00108123, 0.00101948, 0.000957556,
  0.00089546, 0.000833207, 0.000770808, 0.000708272, 0.000645613,
  0.000582839, 0.000519963, 0.000456995, 0.000393946, 0.000330828,
  0.000267651, 0.000204427, 0.000141166, 7.78807e-05, 1.45814e-05,
  -4.87205e-05, -0.000112014, -0.000175287, -0.000238529,
  -0.000301728, -0.000364874, -0.000427954, -0.000490958,
  -0.000553873, -0.00061669, -0.000679396, -0.000741979, -0.00080443,
  -0.000866736, -0.000928885, -0.000990868, -0.00105267, -0.00111428,
  -0.0011757, -0.0012369, -0.00129787, -0.00135861, -0.00141911,
  -0.00147934, -0.00153931, -0.001599, -0.0016584, -0.00171749,
  -0.00177627, -0.00183473, -0.00189285, -0.00195063, -0.00200805,
  -0.0020651, -0.00212177, -0.00217805, -0.00223393, -0.00228941,
  -0.00234446, -0.00239907, -0.00245325, -0.00250697, -0.00256023,
  -0.00261302, -0.00266532, -0.00271713, -0.00276844, -0.00281923,
  -0.0028695, -0.00291923, -0.00296842, -0.00301706, -0.00306513,
  -0.00311263, -0.00315955, -0.00320588, -0.00325161, -0.00329673,
  -0.00334123, -0.0033851, -0.00342834, -0.00347093, -0.00351287,
  -0.00355415, -0.00359475, -0.00363468, -0.00367392, -0.00371246,
  -0.0037503, -0.00378743, -0.00382384, -0.00385952, -0.00389447,
  -0.00392868, -0.00396214, -0.00399484, -0.00402678, -0.00405796,
  -0.00408835, -0.00411796, -0.00414678, -0.00417481, -0.00420203,
  -0.00422845, -0.00425405, -0.00427883, -0.00430279, -0.00432592,
  -0.00434821, -0.00436966, -0.00439026, -0.00441001, -0.00442891,
  -0.00444694, -0.00446411, -0.00448042, -0.00449585, -0.0045104,
  -0.00452407, -0.00453686, -0.00454876, -0.00455976, -0.00456988,
  -0.0045791, -0.00458741, -0.00459483, -0.00460134, -0.00460695,
  -0.00461164, -0.00461543, -0.0046183, -0.00462026, -0.0046213,
  -0.00462142, -0.00462063, -0.00461892, -0.0046163, -0.00461275,
  -0.00460828, -0.00460289, -0.00459659, -0.00458936, -0.00458121,
  -0.00457215, -0.00456217, -0.00455127, -0.00453946, -0.00452673,
  -0.00451309, -0.00449854, -0.00448309, -0.00446672, -0.00444946,
  -0.00443129, -0.00441222, -0.00439225, -0.0043714, -0.00434965,
  -0.00432702, -0.0043035, -0.00427911, -0.00425384, -0.0042277,
  -0.00420069, -0.00417283, -0.0041441, -0.00411453, -0.00408411,
  -0.00405285, -0.00402075, -0.00398782, -0.00395407, -0.00391949,
  -0.00388411, -0.00384792, -0.00381094, -0.00377316, -0.00373459,
  -0.00369525, -0.00365514, -0.00361426, -0.00357263, -0.00353025,
  -0.00348713, -0.00344328, -0.00339871, -0.00335342, -0.00330743,
  -0.00326074, -0.00321336, -0.00316531, -0.00311658, -0.0030672,
  -0.00301716, -0.00296649, -0.00291518, -0.00286325, -0.00281072,
  -0.00275759, -0.00270386, -0.00264956, -0.0025947, -0.00253927,
  -0.00248331, -0.00242681, -0.00236978, -0.00231225, -0.00225422,
  -0.00219571, -0.00213672, -0.00207726, -0.00201736, -0.00195702,
  -0.00189626, -0.00183508, -0.00177351, -0.00171155, -0.00164921,
  -0.00158652, -0.00152348, -0.00146011, -0.00139641, -0.00133241,
  -0.00126812, -0.00120355, -0.00113871, -0.00107362, -0.0010083,
  -0.000942751, -0.000876995, -0.000811045, -0.000744915,
  -0.000678619, -0.000612173, -0.00054559, -0.000478886, -0.000412074,
  -0.000345171, -0.00027819, -0.000211147, -0.000144057, -7.69345e-05,
  -9.79447e-06, 5.73477e-05, 0.000124477, 0.000191578, 0.000258636,
  0.000325636, 0.000392562, 0.000459398, 0.000526131, 0.000592744,
  0.000659221, 0.000725549, 0.000791711, 0.000857692, 0.000923477,
  0.00098905, 0.0010544, 0.0011195, 0.00118435, 0.00124892,
  0.00131321, 0.00137719, 0.00144085, 0.00150418, 0.00156716,
  0.00162978, 0.00169202, 0.00175387, 0.0018153, 0.00187631,
  0.00193689, 0.00199701, 0.00205666, 0.00211583, 0.00217451,
  0.00223267, 0.0022903, 0.0023474, 0.00240394, 0.00245991, 0.0025153,
  0.00257009, 0.00262428, 0.00267783, 0.00273076, 0.00278303,
  0.00283463, 0.00288556, 0.00293579, 0.00298533, 0.00303414,
  0.00308223, 0.00312957, 0.00317616, 0.00322198, 0.00326703,
  0.00331128, 0.00335473, 0.00339737, 0.00343918, 0.00348015,
  0.00352027, 0.00355954, 0.00359793, 0.00363544, 0.00367206,
  0.00370778, 0.00374259, 0.00377648, 0.00380944, 0.00384145,
  0.00387252, 0.00390262, 0.00393176, 0.00395992, 0.0039871,
  0.00401328, 0.00403846, 0.00406264, 0.0040858, 0.00410793,
  0.00412903, 0.0041491, 0.00416812, 0.00418609, 0.00420301,
  0.00421886, 0.00423365, 0.00424736, 0.00425999, 0.00427155,
  0.00428201, 0.00429138, 0.00429966, 0.00430683, 0.00431291,
  0.00431787, 0.00432173, 0.00432447, 0.00432611, 0.00432662,
  0.00432602, 0.00432429, 0.00432145, 0.00431748, 0.00431239,
  0.00430618, 0.00429885, 0.00429039, 0.00428081, 0.00427011,
  0.00425828, 0.00424534, 0.00423128, 0.0042161, 0.00419981,
  0.00418241, 0.00416391, 0.00414429, 0.00412358, 0.00410177,
  0.00407886, 0.00405487, 0.00402979, 0.00400363, 0.0039764,
  0.0039481, 0.00391874, 0.00388832, 0.00385685, 0.00382434,
  0.00379079, 0.00375622, 0.00372062, 0.00368401, 0.0036464,
  0.00360779, 0.00356819, 0.00352762, 0.00348608, 0.00344358,
  0.00340013, 0.00335574, 0.00331043, 0.0032642, 0.00321707,
  0.00316905, 0.00312014, 0.00307036, 0.00301973, 0.00296826,
  0.00291595, 0.00286282, 0.0028089, 0.00275418, 0.00269868,
  0.00264243, 0.00258542, 0.00252769, 0.00246923, 0.00241008,
  0.00235024, 0.00228973, 0.00222856, 0.00216676, 0.00210433,
  0.0020413, 0.00197769, 0.0019135, 0.00184877, 0.00178349, 0.0017177,
  0.00165142, 0.00158465, 0.00151742, 0.00144975, 0.00138165,
  0.00131315, 0.00124427, 0.00117502, 0.00110542, 0.0010355,
  0.000965271, 0.000894757, 0.000823978, 0.000752955, 0.000681707,
  0.000610256, 0.000538623, 0.000466829, 0.000394896, 0.000322843,
  0.000250694, 0.000178469, 0.00010619, 3.3879e-05, -3.84421e-05,
  -0.000110751, -0.000183027, -0.000255247, -0.000327389, -0.00039943,
  -0.00047135, -0.000543124, -0.000614731, -0.000686149, -0.000757355,
  -0.000828327, -0.000899042, -0.000969477, -0.00103961, -0.00110942,
  -0.00117888, -0.00124798, -0.00131668, -0.00138497, -0.00145282,
  -0.00152022, -0.00158713, -0.00165355, -0.00171943, -0.00178477,
  -0.00184955, -0.00191373, -0.0019773, -0.00204024, -0.00210252,
  -0.00216412, -0.00222503, -0.00228522, -0.00234467, -0.00240336,
  -0.00246127, -0.00251838, -0.00257466, -0.00263011, -0.00268469,
  -0.00273839, -0.00279119, -0.00284307, -0.00289401, -0.002944,
  -0.00299301, -0.00304102, -0.00308802, -0.00313399, -0.00317891,
  -0.00322277, -0.00326555, -0.00330722, -0.00334778, -0.00338721,
  -0.0034255, -0.00346262, -0.00349856, -0.00353331, -0.00356686,
  -0.00359918, -0.00363027, -0.00366011, -0.00368869, -0.003716,
  -0.00374202, -0.00376674, -0.00379016, -0.00381225, -0.00383301,
  -0.00385244, -0.00387051, -0.00388722, -0.00390257, -0.00391653,
  -0.00392912, -0.0039403, -0.00395009, -0.00395848, -0.00396545,
  -0.003971, -0.00397512, -0.00397782, -0.00397909, -0.00397892,
  -0.00397731, -0.00397426, -0.00396976, -0.00396382, -0.00395643,
  -0.0039476, -0.00393731, -0.00392558, -0.0039124, -0.00389777,
  -0.0038817, -0.00386419, -0.00384524, -0.00382486, -0.00380305,
  -0.00377981, -0.00375516, -0.00372909, -0.00370161, -0.00367273,
  -0.00364246, -0.0036108, -0.00357777, -0.00354337, -0.00350761,
  -0.00347051, -0.00343207, -0.00339231, -0.00335123, -0.00330886,
  -0.0032652, -0.00322026, -0.00317407, -0.00312664, -0.00307797,
  -0.0030281, -0.00297703, -0.00292478, -0.00287138, -0.00281683,
  -0.00276115, -0.00270438, -0.00264652, -0.0025876, -0.00252763,
  -0.00246664, -0.00240466, -0.0023417, -0.00227778, -0.00221294,
  -0.00214719, -0.00208056, -0.00201307, -0.00194475, -0.00187563,
  -0.00180573, -0.00173508, -0.0016637, -0.00159163, -0.00151889,
  -0.00144552, -0.00137153, -0.00129697, -0.00122185, -0.00114622,
  -0.00107009, -0.000993512, -0.000916506, -0.000839105, -0.000761343,
  -0.000683252, -0.000604864, -0.000526214, -0.000447334,
  -0.000368258, -0.000289021, -0.000209657, -0.0001302, -5.0686e-05,
  2.88508e-05, 0.000108375, 0.00018785, 0.000267242, 0.000346514,
  0.00042563, 0.000504554, 0.000583249, 0.000661679, 0.000739809,
  0.0008176, 0.000895017, 0.000972022, 0.00104858, 0.00112465,
  0.0012002, 0.0012752, 0.00134959, 0.00142336, 0.00149646,
  0.00156885, 0.0016405, 0.00171138, 0.00178144, 0.00185065,
  0.00191897, 0.00198638, 0.00205282, 0.00211828, 0.00218271,
  0.00224608, 0.00230835, 0.0023695, 0.00242948, 0.00248826,
  0.00254582, 0.00260211, 0.00265711, 0.00271078, 0.00276309,
  0.00281402, 0.00286353, 0.00291159, 0.00295817, 0.00300325,
  0.00304679, 0.00308877, 0.00312916, 0.00316793, 0.00320507,
  0.00324054, 0.00327431, 0.00330638, 0.0033367, 0.00336527,
  0.00339206, 0.00341705, 0.00344021, 0.00346154, 0.00348101,
  0.00349861, 0.00351431, 0.00352811, 0.00353998, 0.00354992,
  0.00355792, 0.00356395, 0.00356802, 0.00357011, 0.00357021,
  0.00356831, 0.00356442, 0.00355852, 0.0035506, 0.00354067,
  0.00352873, 0.00351476, 0.00349878, 0.00348079, 0.00346078,
  0.00343876, 0.00341474, 0.00338871, 0.0033607, 0.0033307,
  0.00329873, 0.0032648, 0.00322892, 0.0031911, 0.00315136,
  0.00310972, 0.00306619, 0.00302079, 0.00297354, 0.00292447,
  0.00287359, 0.00282092, 0.00276651, 0.00271036, 0.00265251,
  0.00259299, 0.00253183, 0.00246906, 0.00240471, 0.00233882,
  0.00227142, 0.00220255, 0.00213225, 0.00206056, 0.00198752,
  0.00191316, 0.00183755, 0.00176071, 0.00168269, 0.00160354,
  0.00152332, 0.00144206, 0.00135982, 0.00127666, 0.00119261,
  0.00110775, 0.00102211, 0.000935767, 0.000848765, 0.000761168,
  0.000673032, 0.000584418, 0.000495387, 0.000406002, 0.000316323,
  0.000226416, 0.000136344, 4.61725e-05, -4.40329e-05, -0.000134206,
  -0.000224279, -0.000314184, -0.000403853, -0.000493217,
  -0.000582207, -0.000670753, -0.000758785, -0.000846231,
  -0.000933022, -0.00101909, -0.00110435, -0.00118875, -0.0012722,
  -0.00135464, -0.001436, -0.0015162, -0.00159517, -0.00167284,
  -0.00174914, -0.001824, -0.00189736, -0.00196912, -0.00203924,
  -0.00210764, -0.00217426, -0.00223901, -0.00230185, -0.0023627,
  -0.0024215, -0.00247818, -0.00253268, -0.00258494, -0.0026349,
  -0.0026825, -0.00272768, -0.00277039, -0.00281057, -0.00284817,
  -0.00288313, -0.00291541, -0.00294495, -0.00297172, -0.00299567,
  -0.00301676, -0.00303494, -0.00305018, -0.00306245, -0.00307171,
  -0.00307793, -0.00308109, -0.00308115, -0.00307811, -0.00307193,
  -0.0030626, -0.00305012, -0.00303446, -0.00301562, -0.00299361,
  -0.00296841, -0.00294003, -0.00290847, -0.00287376, -0.00283589,
  -0.00279489, -0.00275078, -0.00270359, -0.00265333, -0.00260005,
  -0.00254378, -0.00248457, -0.00242244, -0.00235747, -0.00228969,
  -0.00221917, -0.00214597, -0.00207015, -0.00199178, -0.00191094,
  -0.00182772, -0.00174218, -0.00165442, -0.00156453, -0.00147262,
  -0.00137877, -0.0012831, -0.00118572, -0.00108674, -0.000986281,
  -0.000884466, -0.000781424, -0.000677286, -0.000572188,
  -0.000466273, -0.000359683, -0.000252568, -0.000145081,
  -3.73769e-05, 7.03832e-05, 0.000178036, 0.000285414, 0.000392348,
  0.000498662, 0.000604182, 0.000708728, 0.000812117, 0.000914165,
  0.00101469, 0.00111349, 0.00121039, 0.00130519, 0.0013977,
  0.00148773, 0.00157508, 0.00165955, 0.00174095, 0.0018191,
  0.00189379, 0.00196483, 0.00203204, 0.00209522, 0.00215419,
  0.00220877, 0.00225877, 0.00230403, 0.00234438, 0.00237965,
  0.00240967, 0.00243431, 0.00245341, 0.00246684, 0.00247447,
  0.00247617, 0.00247185, 0.00246141, 0.00244475, 0.0024218,
  0.00239251, 0.00235684, 0.00231474, 0.00226621, 0.00221125,
  0.00214989, 0.00208217, 0.00200816, 0.00192794, 0.00184162,
  0.00174934, 0.00165126, 0.00154757, 0.00143848, 0.00132426,
  0.00120517, 0.00108154, 0.00095372, 0.000822089, 0.000687078,
  0.000549157, 0.000408835, 0.000266667, 0.000123256, -2.0747e-05,
  -0.000164641, -0.000307671, -0.000449027, -0.000587841,
  -0.000723185, -0.000854067, -0.000979432, -0.00109816, -0.00120904,
  -0.00131083, -0.00140216, -0.00148163, -0.00154771, -0.00159883,
  -0.00163329, -0.00164933, -0.00164509, -0.00161858, -0.00156775,
  -0.00149041, -0.00138429, -0.00124697, -0.00107594, -0.000868567,
  -0.000622073, -0.000333562, 6.89959e-17}; 
