//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
// MODULE:              G4IsomerTable2.cc
//
// Date:                16/03/07
// Author:              H.Kurashige
//
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
// HISTORY
////////////////////////////////////////////////////////////////////////////////// IsomerLevel is added                         30 Apr. 2013  H.Kurashige

#include "G4IsomerTable.hh"

const G4double G4IsomerTable::isomerTable[G4IsomerTable::nEntries][5] =
{
{  20060 ,  0       ,  1.16382e+09    ,  0     ,  0            },   //He6   
{  20080 ,  0       ,  1.71681e+08    ,  0     ,  0            },   //He8   
{  30060 ,  0       ,  -1             ,  2     ,  4.15198e-27  },   //Li6   
{  30070 ,  0       ,  -1             ,  3     ,  1.64475e-26  },   //Li7   
{  30080 ,  0       ,  1.20898e+09    ,  4     ,  8.35177e-27  },   //Li8   
{  30090 ,  0       ,  2.57233e+08    ,  3     ,  1.73701e-26  },   //Li9   
{  30110 ,  0       ,  1.22629e+07    ,  3     ,  1.85253e-26  },   //Li11  
{  40070 ,  0       ,  6.64217e+15    ,  0     ,  0            },   //Be7   
{  40090 ,  0       ,  -1             ,  3     ,  -5.94881e-27 },   //Be9   
{  40100 ,  0       ,  6.87444e+22    ,  0     ,  0            },   //Be10  
{  40110 ,  0       ,  1.99236e+10    ,  0     ,  0            },   //Be11  
{  40120 ,  0       ,  3.40476e+07    ,  0     ,  0            },   //Be12  
{  40140 ,  0       ,  6.27573e+06    ,  0     ,  0            },   //Be14  
{  50080 ,  0       ,  1.11088e+09    ,  4     ,  5.23009e-27  },   //B8    
{  50100 ,  0       ,  -1             ,  6     ,  9.09464e-27  },   //B10   
{  50110 ,  0       ,  -1             ,  3     ,  1.35798e-26  },   //B11   
{  50120 ,  0       ,  2.91424e+07    ,  2     ,  5.06624e-27  },   //B12   
{  50130 ,  0       ,  2.50452e+07    ,  3     ,  1.60504e-26  },   //B13   
{  50140 ,  0       ,  1.99092e+07    ,  0     ,  0            },   //B14   
{  50150 ,  0       ,  1.51483e+07    ,  0     ,  0            },   //B15   
{  50170 ,  0       ,  7.32889e+06    ,  0     ,  0            },   //B17   
{  60090 ,  0       ,  1.82501e+08    ,  0     ,  0            },   //C9    
{  60100 ,  0       ,  2.77719e+10    ,  0     ,  0            },   //C10   
{  60110 ,  0       ,  1.76442e+12    ,  3     ,  -4.86896e-27 },   //C11   
{  60130 ,  0       ,  -1             ,  1     ,  3.54773e-27  },   //C13   
{  60140 ,  0       ,  2.60839e+20    ,  0     ,  0            },   //C14   
{  60150 ,  0       ,  3.53316e+09    ,  1     ,  6.66703e-27  },   //C15   
{  60160 ,  0       ,  1.07769e+09    ,  0     ,  0            },   //C16   
{  60170 ,  0       ,  2.7844e+08     ,  0     ,  0            },   //C17   
{  60180 ,  0       ,  1.37056e+08    ,  0     ,  0            },   //C18   
{  60190 ,  0       ,  6.6364e+07     ,  0     ,  0            },   //C19   
{  60200 ,  0       ,  2.01977e+07    ,  0     ,  0            },   //C20   
{  70120 ,  0       ,  1.58696e+07    ,  2     ,  2.30972e-27  },   //N12   
{  70130 ,  0       ,  8.62588e+11    ,  1     ,  1.62736e-27  },   //N13   
{  70140 ,  0       ,  -1             ,  2     ,  2.03931e-27  },   //N14   
{  70150 ,  0       ,  -1             ,  1     ,  -1.43033e-27 },   //N15   
{  70160 ,  0       ,  1.02864e+10    ,  0     ,  0            },   //N16   
{  70161 ,  120.42  ,  7574.15        ,  0     ,  0            },   //N16   
{  70170 ,  0       ,  6.02037e+09    ,  0     ,  0            },   //N17   
{  70180 ,  0       ,  9.00242e+08    ,  0     ,  0            },   //N18   
{  70190 ,  0       ,  4.38579e+08    ,  0     ,  0            },   //N19   
{  70200 ,  0       ,  1.4427e+08     ,  0     ,  0            },   //N20   
{  70210 ,  0       ,  1.22629e+08    ,  0     ,  0            },   //N21   
{  70220 ,  0       ,  3.46247e+07    ,  0     ,  0            },   //N22   
{  80130 ,  0       ,  1.23783e+07    ,  0     ,  0            },   //O13   
{  80140 ,  0       ,  1.01869e+11    ,  0     ,  0            },   //O14   
{  80150 ,  0       ,  1.76297e+11    ,  1     ,  3.63101e-27  },   //O15   
{  80170 ,  0       ,  -1             ,  5     ,  -9.56512e-27 },   //O17   
{  80190 ,  0       ,  3.88229e+10    ,  0     ,  0            },   //O19   
{  80200 ,  0       ,  1.94908e+10    ,  0     ,  0            },   //O20   
{  80210 ,  0       ,  4.93402e+09    ,  0     ,  0            },   //O21   
{  80220 ,  0       ,  3.24606e+09    ,  0     ,  0            },   //O22   
{  80230 ,  0       ,  1.18301e+08    ,  0     ,  0            },   //O23   
{  80240 ,  0       ,  8.80044e+07    ,  0     ,  0            },   //O24   
{  90170 ,  0       ,  9.30394e+10    ,  5     ,  2.38463e-26  },   //F17   
{  90180 ,  0       ,  9.50159e+12    ,  0     ,  0            },   //F18   
{  90190 ,  0       ,  -1             ,  1     ,  1.32779e-26  },   //F19   
{  90200 ,  0       ,  1.58696e+10    ,  4     ,  1.05738e-26  },   //F20   
{  90210 ,  0       ,  5.99873e+09    ,  0     ,  0            },   //F21   
{  90220 ,  0       ,  6.1026e+09     ,  0     ,  0            },   //F22   
{  90230 ,  0       ,  3.21721e+09    ,  0     ,  0            },   //F23   
{  90240 ,  0       ,  4.90516e+08    ,  0     ,  0            },   //F24   
{  90250 ,  0       ,  8.5119e+07     ,  0     ,  0            },   //F25   
{  100170,  0       ,  1.57542e+08    ,  0     ,  0            },   //Ne17  
{  100180,  0       ,  2.41219e+09    ,  0     ,  0            },   //Ne18  
{  100190,  0       ,  2.48432e+10    ,  1     ,  -9.52285e-27 },   //Ne19  
{  100210,  0       ,  -1             ,  3     ,  -3.34259e-27 },   //Ne21  
{  100230,  0       ,  5.3726e+10     ,  5     ,  -5.45485e-27 },   //Ne23  
{  100240,  0       ,  2.92579e+11    ,  0     ,  0            },   //Ne24  
{  100250,  0       ,  8.68503e+08    ,  0     ,  0            },   //Ne25  
{  100260,  0       ,  2.84211e+08    ,  0     ,  0            },   //Ne26  
{  100270,  0       ,  4.61663e+07    ,  0     ,  0            },   //Ne27  
{  100280,  0       ,  2.45258e+07    ,  0     ,  0            },   //Ne28  
{  100290,  0       ,  2.88539e+08    ,  0     ,  0            },   //Ne29  
{  110200,  0       ,  6.46183e+08    ,  4     ,  1.86576e-27  },   //Na20  
{  110210,  0       ,  3.24462e+10    ,  3     ,  1.20527e-26  },   //Na21  
{  110220,  0       ,  1.1846e+17     ,  6     ,  8.81867e-27  },   //Na22  
{  110230,  0       ,  -1             ,  3     ,  1.12002e-26  },   //Na23  
{  110240,  0       ,  7.76891e+13    ,  8     ,  8.53734e-27  },   //Na24  
{  110241,  472.207 ,  2.91424e+07    ,  0     ,  0            },   //Na24  
{  110250,  0       ,  8.52633e+10    ,  5     ,  1.8602e-26   },   //Na25  
{  110260,  0       ,  1.54657e+09    ,  6     ,  1.43998e-26  },   //Na26  
{  110261,  82.5    ,  12984.3        ,  0     ,  0            },   //Na26  
{  110270,  0       ,  4.34251e+08    ,  5     ,  1.96728e-26  },   //Na27  
{  110280,  0       ,  4.40022e+07    ,  2     ,  1.22532e-26  },   //Na28  
{  110290,  0       ,  6.4777e+07     ,  3     ,  1.23694e-26  },   //Na29  
{  110300,  0       ,  6.92494e+07    ,  4     ,  1.05208e-26  },   //Na30  
{  110310,  0       ,  2.45258e+07    ,  7     ,  1.16421e-26  },   //Na31  
{  110320,  0       ,  1.90436e+07    ,  0     ,  0            },   //Na32  
{  110330,  0       ,  1.18301e+07    ,  0     ,  0            },   //Na33  
{  110340,  0       ,  7.93482e+06    ,  0     ,  0            },   //Na34  
{  110350,  0       ,  2.16404e+06    ,  0     ,  0            },   //Na35  
{  120200,  0       ,  1.37056e+08    ,  0     ,  0            },   //Mg20  
{  120210,  0       ,  1.76009e+08    ,  0     ,  0            },   //Mg21  
{  120220,  0       ,  5.56448e+09    ,  0     ,  0            },   //Mg22  
{  120230,  0       ,  1.63313e+10    ,  0     ,  0            },   //Mg23  
{  120250,  0       ,  -1             ,  5     ,  -4.32069e-27 },   //Mg25  
{  120270,  0       ,  8.1873e+11     ,  0     ,  0            },   //Mg27  
{  120280,  0       ,  1.08606e+14    ,  0     ,  0            },   //Mg28  
{  120290,  0       ,  1.8755e+09     ,  0     ,  0            },   //Mg29  
{  120300,  0       ,  4.83303e+08    ,  0     ,  0            },   //Mg30  
{  120310,  0       ,  3.3182e+08     ,  0     ,  0            },   //Mg31  
{  120320,  0       ,  1.73123e+08    ,  0     ,  0            },   //Mg32  
{  120330,  0       ,  1.29843e+08    ,  0     ,  0            },   //Mg33  
{  120340,  0       ,  2.88539e+07    ,  0     ,  0            },   //Mg34  
{  130220,  0       ,  1.00989e+08    ,  0     ,  0            },   //Al22  
{  130230,  0       ,  6.78067e+08    ,  0     ,  0            },   //Al23  
{  130240,  0       ,  2.96185e+09    ,  0     ,  0            },   //Al24  
{  130241,  425.8   ,  1.89426e+08    ,  0     ,  0            },   //Al24  
{  130250,  0       ,  1.03629e+10    ,  5     ,  1.84126e-26  },   //Al25  
{  130260,  0       ,  3.36869e+22    ,  0     ,  0            },   //Al26  
{  130261,  228.305 ,  9.1539e+09     ,  0     ,  0            },   //Al26  
{  130270,  0       ,  -1             ,  5     ,  1.83925e-26  },   //Al27  
{  130280,  0       ,  1.94043e+11    ,  6     ,  1.63746e-26  },   //Al28  
{  130290,  0       ,  5.67845e+11    ,  0     ,  0            },   //Al29  
{  130300,  0       ,  5.1937e+09     ,  0     ,  0            },   //Al30  
{  130310,  0       ,  9.29096e+08    ,  0     ,  0            },   //Al31  
{  130320,  0       ,  4.76089e+07    ,  0     ,  0            },   //Al32  
{  130340,  0       ,  8.65617e+07    ,  0     ,  0            },   //Al34  
{  130350,  0       ,  2.16404e+08    ,  0     ,  0            },   //Al35  
{  140220,  0       ,  8.65617e+06    ,  0     ,  0            },   //Si22  
{  140240,  0       ,  1.47155e+08    ,  0     ,  0            },   //Si24  
{  140250,  0       ,  3.17393e+08    ,  0     ,  0            },   //Si25  
{  140260,  0       ,  3.22298e+09    ,  0     ,  0            },   //Si26  
{  140270,  0       ,  6.00161e+09    ,  5     ,  0            },   //Si27  
{  140290,  0       ,  -1             ,  1     ,  -2.80465e-27 },   //Si29  
{  140310,  0       ,  1.36162e+13    ,  0     ,  0            },   //Si31  
{  140320,  0       ,  7.83095e+18    ,  0     ,  0            },   //Si32  
{  140330,  0       ,  8.91586e+09    ,  0     ,  0            },   //Si33  
{  140340,  0       ,  3.99627e+09    ,  0     ,  0            },   //Si34  
{  140350,  0       ,  1.1253e+09     ,  0     ,  0            },   //Si35  
{  140360,  0       ,  6.49213e+08    ,  0     ,  0            },   //Si36  
{  150260,  0       ,  2.88539e+07    ,  0     ,  0            },   //P26   
{  150270,  0       ,  3.75101e+08    ,  0     ,  0            },   //P27   
{  150280,  0       ,  3.89961e+08    ,  0     ,  0            },   //P28   
{  150290,  0       ,  5.97276e+09    ,  1     ,  6.23721e-27  },   //P29   
{  150300,  0       ,  2.1626e+11     ,  0     ,  0            },   //P30   
{  150310,  0       ,  -1             ,  1     ,  5.71547e-27  },   //P31   
{  150320,  0       ,  1.7774e+15     ,  2     ,  -1.27482e-27 },   //P32   
{  150330,  0       ,  3.15806e+15    ,  0     ,  0            },   //P33   
{  150340,  0       ,  1.79327e+10    ,  0     ,  0            },   //P34   
{  150350,  0       ,  6.82395e+10    ,  0     ,  0            },   //P35   
{  150360,  0       ,  8.07909e+09    ,  0     ,  0            },   //P36   
{  150370,  0       ,  3.33263e+09    ,  0     ,  0            },   //P37   
{  150380,  0       ,  9.23325e+08    ,  0     ,  0            },   //P38   
{  150390,  0       ,  2.30831e+08    ,  0     ,  0            },   //P39   
{  150400,  0       ,  3.75101e+08    ,  0     ,  0            },   //P40   
{  150410,  0       ,  1.73123e+08    ,  0     ,  0            },   //P41   
{  150420,  0       ,  1.58696e+08    ,  0     ,  0            },   //P42   
{  150430,  0       ,  4.76089e+07    ,  0     ,  0            },   //P43   
{  160270,  0       ,  3.02966e+07    ,  0     ,  0            },   //S27   
{  160280,  0       ,  1.80337e+08    ,  0     ,  0            },   //S28   
{  160290,  0       ,  2.69784e+08    ,  0     ,  0            },   //S29   
{  160300,  0       ,  1.6995e+09     ,  0     ,  0            },   //S30   
{  160310,  0       ,  3.71061e+09    ,  1     ,  2.46443e-27  },   //S31   
{  160330,  0       ,  -1             ,  3     ,  3.2518e-27   },   //S33   
{  160350,  0       ,  1.09082e+16    ,  3     ,  5.05078e-27  },   //S35   
{  160370,  0       ,  4.37137e+11    ,  0     ,  0            },   //S37   
{  160380,  0       ,  1.47443e+13    ,  0     ,  0            },   //S38   
{  160390,  0       ,  1.6591e+10     ,  0     ,  0            },   //S39   
{  160400,  0       ,  1.26957e+10    ,  0     ,  0            },   //S40   
{  160420,  0       ,  8.07909e+08    ,  0     ,  0            },   //S42   
{  160430,  0       ,  3.17393e+08    ,  0     ,  0            },   //S43   
{  160440,  0       ,  1.77452e+08    ,  0     ,  0            },   //S44   
{  160450,  0       ,  1.18301e+08    ,  0     ,  0            },   //S45   
{  170310,  0       ,  2.16404e+08    ,  0     ,  0            },   //Cl31  
{  170320,  0       ,  4.29923e+08    ,  0     ,  0            },   //Cl32  
{  170330,  0       ,  3.62261e+09    ,  3     ,  3.7997e-27   },   //Cl33  
{  170340,  0       ,  2.20155e+09    ,  0     ,  0            },   //Cl34  
{  170341,  146.36  ,  2.76998e+12    ,  0     ,  0            },   //Cl34  
{  170350,  0       ,  -1             ,  3     ,  4.15111e-27  },   //Cl35  
{  170360,  0       ,  1.37042e+22    ,  4     ,  6.49263e-27  },   //Cl36  
{  170370,  0       ,  -1             ,  3     ,  3.45536e-27  },   //Cl37  
{  170380,  0       ,  3.22298e+12    ,  4     ,  1.03541e-26  },   //Cl38  
{  170381,  671.361 ,  1.03153e+09    ,  0     ,  0            },   //Cl38  
{  170390,  0       ,  4.81283e+12    ,  0     ,  0            },   //Cl39  
{  170400,  0       ,  1.16858e+11    ,  0     ,  0            },   //Cl40  
{  170410,  0       ,  5.53995e+10    ,  0     ,  0            },   //Cl41  
{  170420,  0       ,  9.81033e+09    ,  0     ,  0            },   //Cl42  
{  170430,  0       ,  4.76089e+09    ,  0     ,  0            },   //Cl43  
{  170440,  0       ,  6.2613e+08     ,  0     ,  0            },   //Cl44  
{  170450,  0       ,  5.77078e+08    ,  0     ,  0            },   //Cl45  
{  170460,  0       ,  3.21721e+08    ,  0     ,  0            },   //Cl46  
{  180310,  0       ,  2.17847e+07    ,  0     ,  0            },   //Ar31  
{  180320,  0       ,  1.41384e+08    ,  0     ,  0            },   //Ar32  
{  180330,  0       ,  2.49586e+08    ,  0     ,  0            },   //Ar33  
{  180340,  0       ,  1.21836e+09    ,  0     ,  0            },   //Ar34  
{  180350,  0       ,  2.56078e+09    ,  3     ,  3.19715e-27  },   //Ar35  
{  180370,  0       ,  4.36704e+15    ,  3     ,  5.78315e-27  },   //Ar37  
{  180390,  0       ,  1.2247e+19     ,  7     ,  -6.56602e-27 },   //Ar39  
{  180410,  0       ,  9.46408e+12    ,  0     ,  0            },   //Ar41  
{  180420,  0       ,  1.49752e+18    ,  0     ,  0            },   //Ar42  
{  180430,  0       ,  4.64836e+11    ,  0     ,  0            },   //Ar43  
{  180440,  0       ,  1.02749e+12    ,  0     ,  0            },   //Ar44  
{  180450,  0       ,  3.09891e+10    ,  0     ,  0            },   //Ar45  
{  180460,  0       ,  1.21186e+10    ,  0     ,  0            },   //Ar46  
{  180470,  0       ,  1.00989e+09    ,  0     ,  0            },   //Ar47  
{  190350,  0       ,  2.74112e+08    ,  0     ,  0            },   //K35   
{  190360,  0       ,  4.93402e+08    ,  4     ,  2.76783e-27  },   //K36   
{  190370,  0       ,  1.76874e+09    ,  3     ,  1.02637e-27  },   //K37   
{  190380,  0       ,  6.61043e+11    ,  6     ,  6.92462e-27  },   //K38   
{  190381,  130.4   ,  1.33291e+09    ,  0     ,  0            },   //K38   
{  190382,  3458    ,  31739.3        ,  0     ,  0            },   //K38   
{  190390,  0       ,  -1             ,  3     ,  1.97721e-27  },   //K39   
{  190400,  0       ,  5.81406e+25    ,  8     ,  -6.55642e-27 },   //K40   
{  190410,  0       ,  -1             ,  3     ,  1.08526e-27  },   //K41   
{  190420,  0       ,  6.41999e+13    ,  4     ,  -5.77052e-27 },   //K42   
{  190430,  0       ,  1.1582e+14     ,  3     ,  8.24793e-28  },   //K43   
{  190440,  0       ,  1.9159e+12     ,  4     ,  -4.32347e-27 },   //K44   
{  190450,  0       ,  1.49752e+12    ,  3     ,  8.75806e-28  },   //K45   
{  190460,  0       ,  1.51483e+11    ,  4     ,  -5.30837e-27 },   //K46   
{  190470,  0       ,  2.52472e+10    ,  1     ,  9.76316e-27  },   //K47   
{  190480,  0       ,  9.81033e+09    ,  0     ,  0            },   //K48   
{  190490,  0       ,  1.8178e+09     ,  0     ,  0            },   //K49   
{  190500,  0       ,  6.80952e+08    ,  0     ,  0            },   //K50   
{  190510,  0       ,  5.26584e+08    ,  0     ,  0            },   //K51   
{  190520,  0       ,  1.51483e+08    ,  0     ,  0            },   //K52   
{  190530,  0       ,  4.32809e+07    ,  0     ,  0            },   //K53   
{  190540,  0       ,  1.4427e+07     ,  0     ,  0            },   //K54   
{  200350,  0       ,  7.21348e+07    ,  0     ,  0            },   //Ca35  
{  200360,  0       ,  1.47155e+08    ,  0     ,  0            },   //Ca36  
{  200370,  0       ,  2.61272e+08    ,  0     ,  0            },   //Ca37  
{  200380,  0       ,  6.34786e+08    ,  0     ,  0            },   //Ca38  
{  200390,  0       ,  1.24014e+09    ,  3     ,  5.16028e-27  },   //Ca39  
{  200410,  0       ,  4.68876e+21    ,  7     ,  -8.05489e-27 },   //Ca41  
{  200430,  0       ,  -1             ,  7     ,  -6.65511e-27 },   //Ca43  
{  200450,  0       ,  2.02699e+16    ,  7     ,  -6.70441e-27 },   //Ca45  
{  200470,  0       ,  5.65392e+14    ,  7     ,  -6.97008e-27 },   //Ca47  
{  200480,  0       ,  2.73102e+35    ,  0     ,  0            },   //Ca48  
{  200490,  0       ,  7.54674e+11    ,  0     ,  0            },   //Ca49  
{  200500,  0       ,  2.00535e+10    ,  0     ,  0            },   //Ca50  
{  200510,  0       ,  1.4427e+10     ,  0     ,  0            },   //Ca51  
{  200520,  0       ,  6.6364e+09     ,  0     ,  0            },   //Ca52  
{  200530,  0       ,  1.29843e+08    ,  0     ,  0            },   //Ca53  
{  210400,  0       ,  2.63003e+08    ,  0     ,  0            },   //Sc40  
{  210410,  0       ,  8.60279e+08    ,  7     ,  2.79561e-26  },   //Sc41  
{  210420,  0       ,  9.82908e+08    ,  0     ,  0            },   //Sc42  
{  210421,  616.28  ,  8.90143e+10    ,  0     ,  0            },   //Sc42  
{  210430,  0       ,  2.02122e+13    ,  7     ,  2.33346e-26  },   //Sc43  
{  210431,  151.4   ,  631901         ,  0     ,  0            },   //Sc43  
{  210440,  0       ,  2.03997e+13    ,  4     ,  1.293e-26    },   //Sc44  
{  210441,  146.224 ,  72711.8        ,  0     ,  0            },   //Sc44  
{  210442,  270.95  ,  3.04409e+14    ,  0     ,  0            },   //Sc44  
{  210443,  271.13  ,  3.04409e+14    ,  0     ,  0            },   //Sc44  
{  210450,  0       ,  -1             ,  7     ,  2.4024e-26   },   //Sc45  
{  210451,  12.4    ,  4.58777e+08    ,  0     ,  0            },   //Sc45  
{  210460,  0       ,  1.04437e+16    ,  8     ,  1.53039e-26  },   //Sc46  
{  210461,  52.011  ,  13561.3        ,  0     ,  0            },   //Sc46  
{  210462,  142.528 ,  2.70505e+10    ,  0     ,  0            },   //Sc46  
{  210470,  0       ,  4.17516e+14    ,  7     ,  2.69712e-26  },   //Sc47  
{  210480,  0       ,  2.26792e+14    ,  0     ,  0            },   //Sc48  
{  210490,  0       ,  4.95133e+12    ,  0     ,  0            },   //Sc49  
{  210500,  0       ,  1.47876e+11    ,  0     ,  0            },   //Sc50  
{  210501,  256.895 ,  5.04943e+08    ,  0     ,  0            },   //Sc50  
{  210510,  0       ,  1.78894e+10    ,  0     ,  0            },   //Sc51  
{  210520,  0       ,  1.18301e+10    ,  0     ,  0            },   //Sc52  
{  210541,  110     ,  10098.9        ,  0     ,  0            },   //Sc54  
{  220390,  0       ,  3.75101e+07    ,  0     ,  0            },   //Ti39  
{  220400,  0       ,  7.21348e+07    ,  0     ,  0            },   //Ti40  
{  220410,  0       ,  1.15416e+08    ,  0     ,  0            },   //Ti41  
{  220420,  0       ,  2.87096e+08    ,  0     ,  0            },   //Ti42  
{  220430,  0       ,  7.34332e+08    ,  7     ,  3.53555e-27  },   //Ti43  
{  220431,  313     ,  18178          ,  0     ,  0            },   //Ti43  
{  220440,  0       ,  2.86808e+18    ,  0     ,  0            },   //Ti44  
{  220450,  0       ,  1.59995e+13    ,  7     ,  4.79824e-28  },   //Ti45  
{  220451,  36.74   ,  4328.09        ,  0     ,  0            },   //Ti45  
{  220470,  0       ,  -1             ,  5     ,  -3.98244e-27 },   //Ti47  
{  220490,  0       ,  -1             ,  7     ,  -5.57692e-27 },   //Ti49  
{  220510,  0       ,  4.98596e+11    ,  0     ,  0            },   //Ti51  
{  220520,  0       ,  1.47155e+11    ,  0     ,  0            },   //Ti52  
{  220530,  0       ,  4.71761e+10    ,  0     ,  0            },   //Ti53  
{  230430,  0       ,  1.15416e+09    ,  0     ,  0            },   //V43   
{  230440,  0       ,  1.29843e+08    ,  0     ,  0            },   //V44   
{  230450,  0       ,  7.89154e+08    ,  0     ,  0            },   //V45   
{  230460,  0       ,  6.09395e+08    ,  0     ,  0            },   //V46   
{  230461,  801.52  ,  1.47155e+06    ,  0     ,  0            },   //V46   
{  230470,  0       ,  2.82191e+12    ,  0     ,  0            },   //V47   
{  230480,  0       ,  1.99092e+15    ,  8     ,  1.01622e-26  },   //V48   
{  230490,  0       ,  4.11312e+16    ,  7     ,  2.2577e-26   },   //V49   
{  230500,  0       ,  6.37383e+33    ,  12    ,  1.68984e-26  },   //V50   
{  230510,  0       ,  -1             ,  7     ,  2.6005e-26   },   //V51   
{  230520,  0       ,  3.24029e+11    ,  0     ,  0            },   //V52   
{  230530,  0       ,  1.39364e+11    ,  0     ,  0            },   //V53   
{  230540,  0       ,  7.18462e+10    ,  0     ,  0            },   //V54   
{  230541,  108     ,  1298.43        ,  0     ,  0            },   //V54   
{  230550,  0       ,  9.43523e+09    ,  0     ,  0            },   //V55   
{  240430,  0       ,  3.02966e+07    ,  0     ,  0            },   //Cr43  
{  240440,  0       ,  7.64629e+07    ,  0     ,  0            },   //Cr44  
{  240450,  0       ,  7.21348e+07    ,  0     ,  0            },   //Cr45  
{  240460,  0       ,  3.75101e+08    ,  0     ,  0            },   //Cr46  
{  240470,  0       ,  7.21348e+08    ,  0     ,  0            },   //Cr47  
{  240480,  0       ,  1.11982e+14    ,  0     ,  0            },   //Cr48  
{  240490,  0       ,  3.66156e+12    ,  5     ,  2.40417e-27  },   //Cr49  
{  240500,  0       ,  8.19451e+33    ,  0     ,  0            },   //Cr50  
{  240510,  0       ,  3.45237e+15    ,  7     ,  -4.71743e-27 },   //Cr51  
{  240530,  0       ,  -1             ,  3     ,  -2.3968e-27  },   //Cr53  
{  240550,  0       ,  3.02677e+11    ,  0     ,  0            },   //Cr55  
{  240560,  0       ,  5.14177e+11    ,  0     ,  0            },   //Cr56  
{  240570,  0       ,  3.04409e+10    ,  0     ,  0            },   //Cr57  
{  240580,  0       ,  1.00989e+10    ,  0     ,  0            },   //Cr58  
{  240590,  0       ,  1.06759e+09    ,  0     ,  0            },   //Cr59  
{  240600,  0       ,  8.22336e+08    ,  0     ,  0            },   //Cr60  
{  250460,  0       ,  5.91505e+07    ,  0     ,  0            },   //Mn46  
{  250470,  0       ,  1.4427e+08     ,  0     ,  0            },   //Mn47  
{  250480,  0       ,  2.2809e+08     ,  0     ,  0            },   //Mn48  
{  250490,  0       ,  5.5111e+08     ,  0     ,  0            },   //Mn49  
{  250500,  0       ,  4.09581e+08    ,  0     ,  0            },   //Mn50  
{  250501,  229     ,  1.51483e+11    ,  0     ,  0            },   //Mn50  
{  250510,  0       ,  3.99915e+12    ,  5     ,  1.80227e-26  },   //Mn51  
{  250520,  0       ,  6.96966e+14    ,  12    ,  1.54665e-26  },   //Mn52  
{  250521,  377.749 ,  1.82645e+12    ,  0     ,  0            },   //Mn52  
{  250530,  0       ,  1.70238e+23    ,  7     ,  2.53751e-26  },   //Mn53  
{  250540,  0       ,  3.89239e+16    ,  6     ,  1.65762e-26  },   //Mn54  
{  250550,  0       ,  -1             ,  5     ,  1.74414e-26  },   //Mn55  
{  250560,  0       ,  1.33925e+13    ,  6     ,  1.62969e-26  },   //Mn56  
{  250570,  0       ,  1.23206e+11    ,  0     ,  0            },   //Mn57  
{  250580,  0       ,  4.32809e+09    ,  0     ,  0            },   //Mn58  
{  250581,  71.78   ,  9.40637e+10    ,  0     ,  0            },   //Mn58  
{  250582,  72      ,  9.4208e+10     ,  0     ,  0            },   //Mn58  
{  250590,  0       ,  6.6364e+09     ,  0     ,  0            },   //Mn59  
{  250600,  0       ,  7.35775e+10    ,  0     ,  0            },   //Mn60  
{  250601,  271.8   ,  2.55357e+09    ,  0     ,  0            },   //Mn60  
{  250610,  0       ,  1.02431e+09    ,  0     ,  0            },   //Mn61  
{  250620,  0       ,  1.26957e+09    ,  0     ,  0            },   //Mn62  
{  250630,  0       ,  3.60674e+08    ,  0     ,  0            },   //Mn63  
{  260460,  0       ,  2.88539e+07    ,  0     ,  0            },   //Fe46  
{  260470,  0       ,  3.89528e+07    ,  0     ,  0            },   //Fe47  
{  260480,  0       ,  6.34786e+07    ,  0     ,  0            },   //Fe48  
{  260490,  0       ,  1.00989e+08    ,  0     ,  0            },   //Fe49  
{  260500,  0       ,  2.16404e+08    ,  0     ,  0            },   //Fe50  
{  260510,  0       ,  4.40022e+08    ,  0     ,  0            },   //Fe51  
{  260520,  0       ,  4.29779e+13    ,  0     ,  0            },   //Fe52  
{  260521,  6820    ,  6.62197e+10    ,  0     ,  0            },   //Fe52  
{  260530,  0       ,  7.3664e+11     ,  0     ,  0            },   //Fe53  
{  260531,  3040.4  ,  2.23329e+11    ,  0     ,  0            },   //Fe53  
{  260550,  0       ,  1.24288e+17    ,  0     ,  0            },   //Fe55  
{  260570,  0       ,  -1             ,  1     ,  4.56793e-28  },   //Fe57  
{  260590,  0       ,  5.54716e+15    ,  3     ,  1.46473e-27  },   //Fe59  
{  260600,  0       ,  6.82972e+22    ,  0     ,  0            },   //Fe60  
{  260610,  0       ,  5.17639e+11    ,  0     ,  0            },   //Fe61  
{  260620,  0       ,  9.81033e+10    ,  0     ,  0            },   //Fe62  
{  260630,  0       ,  8.80044e+09    ,  0     ,  0            },   //Fe63  
{  260640,  0       ,  2.88539e+09    ,  0     ,  0            },   //Fe64  
{  260650,  0       ,  5.77078e+08    ,  0     ,  0            },   //Fe65  
{  260680,  0       ,  1.4427e+08     ,  0     ,  0            },   //Fe68  
{  270500,  0       ,  6.34786e+07    ,  0     ,  0            },   //Co50  
{  270520,  0       ,  2.59685e+07    ,  0     ,  0            },   //Co52  
{  270530,  0       ,  3.46247e+08    ,  0     ,  0            },   //Co53  
{  270531,  3190    ,  3.56346e+08    ,  0     ,  0            },   //Co53  
{  270540,  0       ,  2.78729e+08    ,  0     ,  0            },   //Co54  
{  270541,  199     ,  1.28111e+11    ,  0     ,  0            },   //Co54  
{  270550,  0       ,  9.10485e+13    ,  7     ,  2.43549e-26  },   //Co55  
{  270560,  0       ,  9.63143e+15    ,  8     ,  1.94506e-26  },   //Co56  
{  270570,  0       ,  3.38745e+16    ,  7     ,  2.38397e-26  },   //Co57  
{  270580,  0       ,  8.82785e+15    ,  4     ,  2.04254e-26  },   //Co58  
{  270581,  24.889  ,  4.75224e+13    ,  0     ,  0            },   //Co58  
{  270582,  53.15   ,  15004          ,  0     ,  0            },   //Co58  
{  270590,  0       ,  -1             ,  7     ,  2.337e-26    },   //Co59  
{  270600,  0       ,  2.40065e+17    ,  10    ,  1.91879e-26  },   //Co60  
{  270601,  58.59   ,  9.06013e+11    ,  0     ,  0            },   //Co60  
{  270610,  0       ,  8.56961e+12    ,  0     ,  0            },   //Co61  
{  270620,  0       ,  1.29843e+11    ,  0     ,  0            },   //Co62  
{  270621,  22      ,  1.20407e+12    ,  0     ,  0            },   //Co62  
{  270630,  0       ,  3.95299e+10    ,  0     ,  0            },   //Co63  
{  270640,  0       ,  4.32809e+08    ,  0     ,  0            },   //Co64  
{  270650,  0       ,  1.73123e+09    ,  0     ,  0            },   //Co65  
{  270660,  0       ,  3.3182e+08     ,  0     ,  0            },   //Co66  
{  270670,  0       ,  6.05932e+08    ,  0     ,  0            },   //Co67  
{  270680,  0       ,  2.59685e+08    ,  0     ,  0            },   //Co68  
{  270690,  0       ,  3.89528e+08    ,  0     ,  0            },   //Co69  
{  280520,  0       ,  5.48224e+07    ,  0     ,  0            },   //Ni52  
{  280530,  0       ,  6.49213e+07    ,  0     ,  0            },   //Ni53  
{  280550,  0       ,  3.05996e+08    ,  0     ,  0            },   //Ni55  
{  280560,  0       ,  7.57559e+14    ,  0     ,  0            },   //Ni56  
{  280570,  0       ,  1.84954e+14    ,  3     ,  4.44469e-27  },   //Ni57  
{  280590,  0       ,  3.45958e+21    ,  0     ,  0            },   //Ni59  
{  280610,  0       ,  -1             ,  3     ,  -3.78819e-27 },   //Ni61  
{  280630,  0       ,  4.55747e+18    ,  0     ,  0            },   //Ni63  
{  280631,  87.15   ,  2409.3         ,  0     ,  0            },   //Ni63  
{  280650,  0       ,  1.30737e+13    ,  5     ,  3.48504e-27  },   //Ni65  
{  280651,  63.37   ,  99546          ,  0     ,  0            },   //Ni65  
{  280660,  0       ,  2.83634e+14    ,  0     ,  0            },   //Ni66  
{  280670,  0       ,  3.02966e+10    ,  0     ,  0            },   //Ni67  
{  280671,  1007    ,  19187.8        ,  0     ,  0            },   //Ni67  
{  280680,  0       ,  2.74112e+10    ,  0     ,  0            },   //Ni68  
{  280681,  2847    ,  1.24072e+06    ,  0     ,  0            },   //Ni68  
{  280690,  0       ,  1.64467e+10    ,  0     ,  0            },   //Ni69  
{  280710,  0       ,  2.68341e+09    ,  0     ,  0            },   //Ni71  
{  280720,  0       ,  3.02966e+09    ,  0     ,  0            },   //Ni72  
{  280730,  0       ,  1.29843e+09    ,  0     ,  0            },   //Ni73  
{  280740,  0       ,  1.58696e+09    ,  0     ,  0            },   //Ni74  
{  290570,  0       ,  2.87673e+08    ,  0     ,  0            },   //Cu57  
{  290580,  0       ,  4.6224e+09     ,  0     ,  0            },   //Cu58  
{  290590,  0       ,  1.1758e+11     ,  0     ,  0            },   //Cu59  
{  290600,  0       ,  2.05151e+12    ,  4     ,  6.1569e-27   },   //Cu60  
{  290610,  0       ,  1.73123e+13    ,  3     ,  1.08087e-26  },   //Cu61  
{  290620,  0       ,  8.43111e+11    ,  2     ,  -1.9193e-27  },   //Cu62  
{  290630,  0       ,  -1             ,  3     ,  1.12294e-26  },   //Cu63  
{  290640,  0       ,  6.596e+13      ,  2     ,  -1.09602e-27 },   //Cu64  
{  290650,  0       ,  -1             ,  3     ,  1.20293e-26  },   //Cu65  
{  290660,  0       ,  4.40455e+11    ,  2     ,  -1.42432e-27 },   //Cu66  
{  290670,  0       ,  3.21144e+14    ,  0     ,  0            },   //Cu67  
{  290680,  0       ,  4.48678e+10    ,  0     ,  0            },   //Cu68  
{  290681,  721.6   ,  3.24606e+11    ,  0     ,  0            },   //Cu68  
{  290690,  0       ,  2.46701e+11    ,  0     ,  0            },   //Cu69  
{  290700,  0       ,  6.49213e+09    ,  0     ,  0            },   //Cu70  
{  290701,  140     ,  6.78067e+10    ,  0     ,  0            },   //Cu70  
{  290710,  0       ,  2.81326e+10    ,  0     ,  0            },   //Cu71  
{  290720,  0       ,  9.52179e+09    ,  0     ,  0            },   //Cu72  
{  290730,  0       ,  5.62651e+09    ,  0     ,  0            },   //Cu73  
{  290740,  0       ,  2.29966e+09    ,  0     ,  0            },   //Cu74  
{  290750,  0       ,  1.76586e+09    ,  0     ,  0            },   //Cu75  
{  290760,  0       ,  9.24768e+08    ,  0     ,  0            },   //Cu76  
{  290770,  0       ,  6.76624e+08    ,  0     ,  0            },   //Cu77  
{  290780,  0       ,  4.93402e+08    ,  0     ,  0            },   //Cu78  
{  290790,  0       ,  2.71227e+08    ,  0     ,  0            },   //Cu79  
{  300570,  0       ,  5.77078e+07    ,  0     ,  0            },   //Zn57  
{  300580,  0       ,  9.37752e+07    ,  0     ,  0            },   //Zn58  
{  300590,  0       ,  2.62571e+08    ,  0     ,  0            },   //Zn59  
{  300600,  0       ,  2.06017e+11    ,  0     ,  0            },   //Zn60  
{  300610,  0       ,  1.28544e+11    ,  0     ,  0            },   //Zn61  
{  300611,  88.4    ,  6.20359e+08    ,  0     ,  0            },   //Zn61  
{  300612,  418.1   ,  2.01977e+08    ,  0     ,  0            },   //Zn61  
{  300613,  756.02  ,  1.8755e+08     ,  0     ,  0            },   //Zn61  
{  300620,  0       ,  4.77099e+13    ,  0     ,  0            },   //Zn62  
{  300630,  0       ,  3.32974e+12    ,  3     ,  -1.4225e-27  },   //Zn63  
{  300650,  0       ,  3.04409e+16    ,  5     ,  3.88405e-27  },   //Zn65  
{  300651,  53.928  ,  2308.31        ,  0     ,  0            },   //Zn65  
{  300670,  0       ,  -1             ,  5     ,  4.42185e-27  },   //Zn67  
{  300671,  93.312  ,  13215.1        ,  0     ,  0            },   //Zn67  
{  300690,  0       ,  4.88208e+12    ,  0     ,  0            },   //Zn69  
{  300691,  438.64  ,  7.14711e+13    ,  0     ,  0            },   //Zn69  
{  300700,  0       ,  2.27657e+31    ,  0     ,  0            },   //Zn70  
{  300710,  0       ,  2.12076e+11    ,  0     ,  0            },   //Zn71  
{  300711,  157.7   ,  2.05728e+13    ,  0     ,  0            },   //Zn71  
{  300720,  0       ,  2.41507e+14    ,  0     ,  0            },   //Zn72  
{  300730,  0       ,  3.39033e+10    ,  0     ,  0            },   //Zn73  
{  300731,  195.5   ,  8.36763e+09    ,  0     ,  0            },   //Zn73  
{  300740,  0       ,  1.37922e+11    ,  0     ,  0            },   //Zn74  
{  300750,  0       ,  1.47155e+10    ,  0     ,  0            },   //Zn75  
{  300760,  0       ,  8.22336e+09    ,  0     ,  0            },   //Zn76  
{  300770,  0       ,  3.00081e+09    ,  0     ,  0            },   //Zn77  
{  300771,  772.39  ,  1.51483e+09    ,  0     ,  0            },   //Zn77  
{  300780,  0       ,  2.12076e+09    ,  0     ,  0            },   //Zn78  
{  300790,  0       ,  1.43548e+09    ,  0     ,  0            },   //Zn79  
{  300800,  0       ,  7.86269e+08    ,  0     ,  0            },   //Zn80  
{  300810,  0       ,  4.18382e+08    ,  0     ,  0            },   //Zn81  
{  310610,  0       ,  2.16404e+08    ,  0     ,  0            },   //Ga61  
{  310620,  0       ,  1.67497e+08    ,  0     ,  0            },   //Ga62  
{  310630,  0       ,  4.67433e+10    ,  0     ,  0            },   //Ga63  
{  310640,  0       ,  2.27369e+11    ,  0     ,  0            },   //Ga64  
{  310641,  42.85   ,  1442.7         ,  0     ,  0            },   //Ga64  
{  310650,  0       ,  1.31574e+12    ,  0     ,  0            },   //Ga65  
{  310660,  0       ,  4.92825e+13    ,  0     ,  0            },   //Ga66  
{  310670,  0       ,  4.06552e+14    ,  3     ,  9.34748e-27  },   //Ga67  
{  310680,  0       ,  5.85446e+12    ,  2     ,  5.93467e-29  },   //Ga68  
{  310690,  0       ,  -1             ,  3     ,  1.01854e-26  },   //Ga69  
{  310700,  0       ,  1.82934e+12    ,  0     ,  0            },   //Ga70  
{  310710,  0       ,  -1             ,  3     ,  1.29415e-26  },   //Ga71  
{  310720,  0       ,  7.32312e+13    ,  6     ,  -6.67916e-28 },   //Ga72  
{  310721,  119.66  ,  5.72462e+07    ,  0     ,  0            },   //Ga72  
{  310730,  0       ,  2.52472e+13    ,  0     ,  0            },   //Ga73  
{  310740,  0       ,  7.02881e+11    ,  0     ,  0            },   //Ga74  
{  310741,  59.571  ,  1.37056e+10    ,  0     ,  0            },   //Ga74  
{  310750,  0       ,  1.8178e+11     ,  0     ,  0            },   //Ga75  
{  310760,  0       ,  4.70319e+10    ,  0     ,  0            },   //Ga76  
{  310770,  0       ,  1.90436e+10    ,  0     ,  0            },   //Ga77  
{  310780,  0       ,  7.34332e+09    ,  0     ,  0            },   //Ga78  
{  310790,  0       ,  4.10735e+09    ,  0     ,  0            },   //Ga79  
{  310800,  0       ,  2.44825e+09    ,  0     ,  0            },   //Ga80  
{  310810,  0       ,  1.75576e+09    ,  0     ,  0            },   //Ga81  
{  310820,  0       ,  8.64175e+08    ,  0     ,  0            },   //Ga82  
{  310830,  0       ,  4.47236e+08    ,  0     ,  0            },   //Ga83  
{  310840,  0       ,  1.22629e+08    ,  0     ,  0            },   //Ga84  
{  320610,  0       ,  5.77078e+07    ,  0     ,  0            },   //Ge61  
{  320630,  0       ,  1.37056e+08    ,  0     ,  0            },   //Ge63  
{  320640,  0       ,  9.18997e+10    ,  0     ,  0            },   //Ge64  
{  320650,  0       ,  4.45793e+10    ,  0     ,  0            },   //Ge65  
{  320660,  0       ,  1.17378e+13    ,  0     ,  0            },   //Ge66  
{  320670,  0       ,  1.63602e+12    ,  0     ,  0            },   //Ge67  
{  320671,  18.2    ,  19764.9        ,  0     ,  0            },   //Ge67  
{  320680,  0       ,  3.37591e+16    ,  0     ,  0            },   //Ge68  
{  320690,  0       ,  2.02843e+14    ,  5     ,  3.71233e-27  },   //Ge69  
{  320691,  86.765  ,  7357.75        ,  0     ,  0            },   //Ge69  
{  320692,  397.944 ,  4053.97        ,  0     ,  0            },   //Ge69  
{  320710,  0       ,  1.42481e+15    ,  1     ,  2.76278e-27  },   //Ge71  
{  320711,  198.367 ,  2.9431e+07     ,  0     ,  0            },   //Ge71  
{  320730,  0       ,  -1             ,  9     ,  -4.442e-27   },   //Ge73  
{  320731,  13.275  ,  4255.95        ,  0     ,  0            },   //Ge73  
{  320732,  66.716  ,  7.19905e+08    ,  0     ,  0            },   //Ge73  
{  320733,  13275   ,  -1             ,  5     ,  -4.75279e-28 },   //Ge73  
{  320750,  0       ,  7.16587e+12    ,  1     ,  2.5759e-27   },   //Ge75  
{  320751,  139.69  ,  6.88166e+10    ,  0     ,  0            },   //Ge75  
{  320770,  0       ,  5.86888e+13    ,  0     ,  0            },   //Ge77  
{  320771,  159.7   ,  7.63186e+10    ,  0     ,  0            },   //Ge77  
{  320780,  0       ,  7.61743e+12    ,  0     ,  0            },   //Ge78  
{  320790,  0       ,  2.73824e+10    ,  0     ,  0            },   //Ge79  
{  320791,  185.95  ,  5.62651e+10    ,  0     ,  0            },   //Ge79  
{  320800,  0       ,  4.25595e+10    ,  0     ,  0            },   //Ge80  
{  320810,  0       ,  1.09645e+10    ,  0     ,  0            },   //Ge81  
{  320811,  679.13  ,  1.09645e+10    ,  0     ,  0            },   //Ge81  
{  320820,  0       ,  6.6364e+09     ,  0     ,  0            },   //Ge82  
{  320830,  0       ,  2.66899e+09    ,  0     ,  0            },   //Ge83  
{  320840,  0       ,  1.39364e+09    ,  0     ,  0            },   //Ge84  
{  320850,  0       ,  7.71842e+08    ,  0     ,  0            },   //Ge85  
{  330650,  0       ,  2.74112e+08    ,  0     ,  0            },   //As65  
{  330660,  0       ,  1.38167e+08    ,  0     ,  0            },   //As66  
{  330670,  0       ,  6.13146e+10    ,  0     ,  0            },   //As67  
{  330680,  0       ,  2.18713e+11    ,  0     ,  0            },   //As68  
{  330690,  0       ,  1.31574e+12    ,  5     ,  6.06094e-27  },   //As69  
{  330700,  0       ,  4.55315e+12    ,  8     ,  1.06375e-26  },   //As70  
{  330701,  32.06   ,  138499         ,  0     ,  0            },   //As70  
{  330710,  0       ,  3.39033e+14    ,  5     ,  8.45249e-27  },   //As71  
{  330720,  0       ,  1.35036e+14    ,  4     ,  -1.08925e-26 },   //As72  
{  330730,  0       ,  1.00094e+16    ,  0     ,  0            },   //As73  
{  330731,  427.76  ,  8223.36        ,  0     ,  0            },   //As73  
{  330740,  0       ,  2.21454e+15    ,  4     ,  -8.0661e-27  },   //As74  
{  330750,  0       ,  -1             ,  3     ,  7.27045e-27  },   //As75  
{  330751,  303.925 ,  2.42229e+07    ,  0     ,  0            },   //As75  
{  330760,  0       ,  1.34344e+14    ,  4     ,  -4.57601e-27 },   //As76  
{  330761,  44.425  ,  2654.56        ,  0     ,  0            },   //As76  
{  330770,  0       ,  2.01689e+14    ,  0     ,  0            },   //As77  
{  330771,  475.443 ,  164467         ,  0     ,  0            },   //As77  
{  330780,  0       ,  7.85115e+12    ,  0     ,  0            },   //As78  
{  330790,  0       ,  7.79921e+11    ,  0     ,  0            },   //As79  
{  330800,  0       ,  2.1929e+10     ,  0     ,  0            },   //As80  
{  330810,  0       ,  4.80418e+10    ,  0     ,  0            },   //As81  
{  330820,  0       ,  2.75555e+10    ,  0     ,  0            },   //As82  
{  330830,  0       ,  1.93321e+10    ,  0     ,  0            },   //As83  
{  330840,  0       ,  5.79964e+09    ,  0     ,  0            },   //As84  
{  330850,  0       ,  2.91569e+09    ,  0     ,  0            },   //As85  
{  330860,  0       ,  1.36335e+09    ,  0     ,  0            },   //As86  
{  330870,  0       ,  6.92494e+08    ,  0     ,  0            },   //As87  
{  340670,  0       ,  8.65617e+07    ,  0     ,  0            },   //Se67  
{  340680,  0       ,  5.12157e+10    ,  0     ,  0            },   //Se68  
{  340690,  0       ,  3.95299e+10    ,  0     ,  0            },   //Se69  
{  340691,  39.4    ,  2885.39        ,  0     ,  0            },   //Se69  
{  340692,  573.9   ,  1384.99        ,  0     ,  0            },   //Se69  
{  340700,  0       ,  3.55769e+12    ,  0     ,  0            },   //Se70  
{  340710,  0       ,  4.10303e+11    ,  0     ,  0            },   //Se71  
{  340711,  48.79   ,  8079.09        ,  0     ,  0            },   //Se71  
{  340712,  260.48  ,  27411.2        ,  0     ,  0            },   //Se71  
{  340720,  0       ,  1.04711e+15    ,  0     ,  0            },   //Se72  
{  340730,  0       ,  3.7135e+13     ,  9     ,  4.39418e-27  },   //Se73  
{  340731,  25.71   ,  3.44516e+12    ,  0     ,  0            },   //Se73  
{  340750,  0       ,  1.49319e+16    ,  5     ,  3.38402e-27  },   //Se75  
{  340770,  0       ,  -1             ,  1     ,  2.70238e-27  },   //Se77  
{  340771,  161.92  ,  2.50452e+10    ,  0     ,  0            },   //Se77  
{  340790,  0       ,  5.14465e+22    ,  7     ,  -5.1417e-27  },   //Se79  
{  340791,  95.77   ,  3.39322e+11    ,  0     ,  0            },   //Se79  
{  340810,  0       ,  1.59706e+12    ,  0     ,  0            },   //Se81  
{  340811,  102.99  ,  4.95854e+12    ,  0     ,  0            },   //Se81  
{  340820,  0       ,  4.91671e+36    ,  0     ,  0            },   //Se82  
{  340830,  0       ,  1.93033e+12    ,  0     ,  0            },   //Se83  
{  340831,  228.5   ,  1.01133e+11    ,  0     ,  0            },   //Se83  
{  340840,  0       ,  2.68341e+11    ,  0     ,  0            },   //Se84  
{  340850,  0       ,  4.57334e+10    ,  0     ,  0            },   //Se85  
{  340860,  0       ,  2.20732e+10    ,  0     ,  0            },   //Se86  
{  340870,  0       ,  7.63186e+09    ,  0     ,  0            },   //Se87  
{  340880,  0       ,  2.20732e+09    ,  0     ,  0            },   //Se88  
{  340890,  0       ,  5.91505e+08    ,  0     ,  0            },   //Se89  
{  340910,  0       ,  3.89528e+08    ,  0     ,  0            },   //Se91  
{  350700,  0       ,  1.14117e+08    ,  0     ,  0            },   //Br70  
{  350710,  0       ,  3.08737e+10    ,  0     ,  0            },   //Br71  
{  350720,  0       ,  1.13396e+11    ,  0     ,  0            },   //Br72  
{  350721,  100.92  ,  1.52926e+10    ,  0     ,  0            },   //Br72  
{  350730,  0       ,  2.9431e+11     ,  0     ,  0            },   //Br73  
{  350740,  0       ,  2.19867e+12    ,  8     ,  7.32364e-27  },   //Br74  
{  350741,  13.58   ,  3.98184e+12    ,  0     ,  0            },   //Br74  
{  350750,  0       ,  8.37052e+12    ,  3     ,  3.78809e-27  },   //Br75  
{  350760,  0       ,  8.4138e+13     ,  2     ,  -2.76889e-27 },   //Br76  
{  350761,  102.58  ,  1.88993e+09    ,  0     ,  0            },   //Br76  
{  350770,  0       ,  2.96185e+14    ,  3     ,  4.64672e-27  },   //Br77  
{  350771,  105.85  ,  3.70484e+11    ,  0     ,  0            },   //Br77  
{  350780,  0       ,  5.59189e+11    ,  0     ,  0            },   //Br78  
{  350781,  180.82  ,  171681         ,  0     ,  0            },   //Br78  
{  350790,  0       ,  -1             ,  3     ,  1.0639e-26   },   //Br79  
{  350791,  207.52  ,  7.0115e+09     ,  0     ,  0            },   //Br79  
{  350800,  0       ,  1.5307e+12     ,  2     ,  2.5961e-27   },   //Br80  
{  350801,  85.843  ,  2.29533e+13    ,  0     ,  0            },   //Br80  
{  350810,  0       ,  -1             ,  3     ,  1.14681e-26  },   //Br81  
{  350811,  536.2   ,  49917.3        ,  0     ,  0            },   //Br81  
{  350820,  0       ,  1.83367e+14    ,  10    ,  8.21762e-27  },   //Br82  
{  350821,  45.9492 ,  5.30623e+11    ,  0     ,  0            },   //Br82  
{  350830,  0       ,  1.24649e+13    ,  0     ,  0            },   //Br83  
{  350831,  3068.8  ,  1009.89        ,  0     ,  0            },   //Br83  
{  350840,  0       ,  2.75266e+12    ,  0     ,  0            },   //Br84  
{  350841,  320     ,  5.1937e+11     ,  0     ,  0            },   //Br84  
{  350850,  0       ,  2.51029e+11    ,  0     ,  0            },   //Br85  
{  350860,  0       ,  7.94925e+10    ,  0     ,  0            },   //Br86  
{  350870,  0       ,  8.02139e+10    ,  0     ,  0            },   //Br87  
{  350880,  0       ,  2.35736e+10    ,  0     ,  0            },   //Br88  
{  350890,  0       ,  6.27284e+09    ,  0     ,  0            },   //Br89  
{  350900,  0       ,  2.75555e+09    ,  0     ,  0            },   //Br90  
{  350910,  0       ,  7.80498e+08    ,  0     ,  0            },   //Br91  
{  350920,  0       ,  4.94845e+08    ,  0     ,  0            },   //Br92  
{  350930,  0       ,  1.47155e+08    ,  0     ,  0            },   //Br93  
{  350940,  0       ,  1.00989e+08    ,  0     ,  0            },   //Br94  
{  360710,  0       ,  9.23325e+07    ,  0     ,  0            },   //Kr71  
{  360720,  0       ,  2.48144e+10    ,  0     ,  0            },   //Kr72  
{  360730,  0       ,  3.89528e+10    ,  0     ,  0            },   //Kr73  
{  360740,  0       ,  9.9546e+11     ,  0     ,  0            },   //Kr74  
{  360750,  0       ,  3.72215e+11    ,  0     ,  0            },   //Kr75  
{  360760,  0       ,  7.68668e+13    ,  0     ,  0            },   //Kr76  
{  360770,  0       ,  6.44019e+12    ,  0     ,  0            },   //Kr77  
{  360790,  0       ,  1.81924e+14    ,  0     ,  0            },   //Kr79  
{  360791,  129.78  ,  7.21348e+10    ,  0     ,  0            },   //Kr79  
{  360810,  0       ,  1.04264e+22    ,  0     ,  0            },   //Kr81  
{  360811,  190.62  ,  1.88993e+10    ,  0     ,  0            },   //Kr81  
{  360830,  0       ,  -1             ,  9     ,  -4.90264e-27 },   //Kr83  
{  360831,  41.543  ,  9.50448e+12    ,  0     ,  0            },   //Kr83  
{  360841,  3236.02 ,  2726.69        ,  0     ,  0            },   //Kr84  
{  360850,  0       ,  4.89651e+17    ,  9     ,  5.05078e-27  },   //Kr85  
{  360851,  304.871 ,  2.32707e+13    ,  0     ,  0            },   //Kr85  
{  360852,  1991.8  ,  1731.23        ,  0     ,  0            },   //Kr85  
{  360870,  0       ,  6.60466e+12    ,  5     ,  -5.1417e-27  },   //Kr87  
{  360880,  0       ,  1.47443e+13    ,  0     ,  0            },   //Kr88  
{  360890,  0       ,  2.72669e+11    ,  0     ,  0            },   //Kr89  
{  360900,  0       ,  4.66279e+10    ,  0     ,  0            },   //Kr90  
{  360910,  0       ,  1.23639e+10    ,  0     ,  0            },   //Kr91  
{  360920,  0       ,  2.65456e+09    ,  0     ,  0            },   //Kr92  
{  360930,  0       ,  1.85531e+09    ,  1     ,  -2.02031e-27 },   //Kr93  
{  360940,  0       ,  2.88539e+08    ,  0     ,  0            },   //Kr94  
{  360950,  0       ,  1.1253e+09     ,  0     ,  0            },   //Kr95  
{  370740,  0       ,  9.36309e+07    ,  0     ,  0            },   //Rb74  
{  370750,  0       ,  2.74112e+10    ,  0     ,  0            },   //Rb75  
{  370760,  0       ,  5.26584e+10    ,  2     ,  -1.88204e-27 },   //Rb76  
{  370761,  316.93  ,  4616.63        ,  0     ,  0            },   //Rb76  
{  370770,  0       ,  3.24606e+11    ,  3     ,  3.30558e-27  },   //Rb77  
{  370780,  0       ,  1.52926e+12    ,  0     ,  0            },   //Rb78  
{  370781,  103.3   ,  4.96864e+11    ,  0     ,  0            },   //Rb78  
{  370790,  0       ,  1.98226e+12    ,  5     ,  1.696e-26    },   //Rb79  
{  370800,  0       ,  4.90516e+10    ,  2     ,  -4.22245e-28 },   //Rb80  
{  370810,  0       ,  2.37612e+13    ,  3     ,  1.04021e-26  },   //Rb81  
{  370811,  86.31   ,  2.64013e+12    ,  0     ,  0            },   //Rb81  
{  370820,  0       ,  1.10193e+11    ,  2     ,  2.8007e-27   },   //Rb82  
{  370821,  68.9    ,  3.36148e+13    ,  0     ,  0            },   //Rb82  
{  370830,  0       ,  1.07452e+16    ,  5     ,  7.19686e-27  },   //Rb83  
{  370831,  42.11   ,  432809         ,  0     ,  0            },   //Rb83  
{  370840,  0       ,  4.08427e+15    ,  4     ,  -6.68784e-27 },   //Rb84  
{  370841,  463.62  ,  1.75432e+12    ,  0     ,  0            },   //Rb84  
{  370850,  0       ,  -1             ,  5     ,  6.83548e-27  },   //Rb85  
{  370851,  514.008 ,  1471.55        ,  0     ,  0            },   //Rb85  
{  370860,  0       ,  2.32274e+15    ,  4     ,  -8.54593e-27 },   //Rb86  
{  370861,  556.06  ,  8.80333e+10    ,  0     ,  0            },   //Rb86  
{  370870,  0       ,  2.1626e+27     ,  3     ,  1.38988e-26  },   //Rb87  
{  370880,  0       ,  1.53936e+12    ,  4     ,  2.5658e-27   },   //Rb88  
{  370890,  0       ,  1.31141e+12    ,  0     ,  0            },   //Rb89  
{  370900,  0       ,  2.27946e+11    ,  0     ,  0            },   //Rb90  
{  370901,  106.9   ,  3.72215e+11    ,  0     ,  0            },   //Rb90  
{  370910,  0       ,  8.42534e+10    ,  3     ,  1.10183e-26  },   //Rb91  
{  370920,  0       ,  6.48059e+09    ,  0     ,  0            },   //Rb92  
{  370930,  0       ,  8.42534e+09    ,  5     ,  7.11908e-27  },   //Rb93  
{  370931,  253.38  ,  82233.6        ,  0     ,  0            },   //Rb93  
{  370940,  0       ,  3.89816e+09    ,  6     ,  7.56809e-27  },   //Rb94  
{  370950,  0       ,  5.44618e+08    ,  5     ,  6.73572e-27  },   //Rb95  
{  370960,  0       ,  2.87096e+08    ,  4     ,  7.40344e-27  },   //Rb96  
{  370970,  0       ,  2.45114e+08    ,  3     ,  9.29849e-27  },   //Rb97  
{  370980,  0       ,  1.64467e+08    ,  0     ,  0            },   //Rb98  
{  370981,  270     ,  1.38499e+08    ,  0     ,  0            },   //Rb98  
{  370990,  0       ,  7.25676e+07    ,  0     ,  0            },   //Rb99  
{  371000,  0       ,  7.35775e+07    ,  0     ,  0            },   //Rb100 
{  371010,  0       ,  4.61663e+07    ,  0     ,  0            },   //Rb101 
{  371020,  0       ,  5.33797e+07    ,  0     ,  0            },   //Rb102 
{  380750,  0       ,  1.02431e+08    ,  0     ,  0            },   //Sr75  
{  380760,  0       ,  1.284e+10      ,  0     ,  0            },   //Sr76  
{  380770,  0       ,  1.29843e+10    ,  0     ,  0            },   //Sr77  
{  380780,  0       ,  2.16404e+11    ,  0     ,  0            },   //Sr78  
{  380790,  0       ,  1.94764e+11    ,  3     ,  -2.39407e-27 },   //Sr79  
{  380800,  0       ,  9.20151e+12    ,  0     ,  0            },   //Sr80  
{  380810,  0       ,  1.93033e+12    ,  1     ,  2.74763e-27  },   //Sr81  
{  380811,  89.05   ,  9233.25        ,  0     ,  0            },   //Sr81  
{  380820,  0       ,  3.18547e+15    ,  0     ,  0            },   //Sr82  
{  380830,  0       ,  1.68363e+14    ,  7     ,  -4.19114e-27 },   //Sr83  
{  380831,  259.15  ,  7.14134e+09    ,  0     ,  0            },   //Sr83  
{  380850,  0       ,  8.08198e+15    ,  9     ,  -5.05331e-27 },   //Sr85  
{  380851,  238.66  ,  5.85446e+12    ,  0     ,  0            },   //Sr85  
{  380870,  0       ,  -1             ,  9     ,  -5.52354e-27 },   //Sr87  
{  380871,  388.532 ,  1.45568e+13    ,  0     ,  0            },   //Sr87  
{  380890,  0       ,  6.29881e+15    ,  5     ,  -5.80234e-27 },   //Sr89  
{  380900,  0       ,  1.31026e+18    ,  0     ,  0            },   //Sr90  
{  380910,  0       ,  5.00183e+13    ,  5     ,  -4.47903e-27 },   //Sr91  
{  380920,  0       ,  1.40749e+13    ,  0     ,  0            },   //Sr92  
{  380930,  0       ,  6.42577e+11    ,  5     ,  -4.01133e-27 },   //Sr93  
{  380940,  0       ,  1.08635e+11    ,  0     ,  0            },   //Sr94  
{  380950,  0       ,  3.44804e+10    ,  1     ,  -2.71227e-27 },   //Sr95  
{  380960,  0       ,  1.54368e+09    ,  0     ,  0            },   //Sr96  
{  380970,  0       ,  6.14588e+08    ,  1     ,  -2.51681e-27 },   //Sr97  
{  380980,  0       ,  9.4208e+08     ,  0     ,  0            },   //Sr98  
{  380990,  0       ,  3.88085e+08    ,  3     ,  -1.31825e-27 },   //Sr99  
{  381000,  0       ,  2.91424e+08    ,  0     ,  0            },   //Sr100 
{  381010,  0       ,  1.70238e+08    ,  0     ,  0            },   //Sr101 
{  381020,  0       ,  9.9546e+07     ,  0     ,  0            },   //Sr102 
{  390790,  0       ,  2.13519e+10    ,  0     ,  0            },   //Y79   
{  390800,  0       ,  5.04943e+10    ,  0     ,  0            },   //Y80   
{  390810,  0       ,  1.01566e+11    ,  0     ,  0            },   //Y81   
{  390820,  0       ,  1.37056e+10    ,  0     ,  0            },   //Y82   
{  390830,  0       ,  6.12857e+11    ,  0     ,  0            },   //Y83   
{  390831,  61.98   ,  2.46701e+11    ,  0     ,  0            },   //Y83   
{  390840,  0       ,  6.6364e+09     ,  0     ,  0            },   //Y84   
{  390841,  500     ,  3.46247e+12    ,  0     ,  0            },   //Y84   
{  390850,  0       ,  1.39191e+13    ,  0     ,  0            },   //Y85   
{  390851,  19.8    ,  2.52472e+13    ,  0     ,  0            },   //Y85   
{  390852,  19800   ,  -1             ,  9     ,  3.13149e-26  },   //Y85   
{  390860,  0       ,  7.65494e+13    ,  8     ,  0            },   //Y86   
{  390861,  218.3   ,  4.15496e+12    ,  0     ,  0            },   //Y86   
{  390870,  0       ,  4.14486e+14    ,  0     ,  0            },   //Y87   
{  390871,  380.79  ,  6.94369e+13    ,  0     ,  0            },   //Y87   
{  390880,  0       ,  1.32944e+16    ,  0     ,  0            },   //Y88   
{  390881,  392.86  ,  432809         ,  0     ,  0            },   //Y88   
{  390882,  674.55  ,  2.00535e+07    ,  0     ,  0            },   //Y88   
{  390890,  0       ,  -1             ,  1     ,  -6.94053e-28 },   //Y89   
{  390891,  908.96  ,  2.31697e+10    ,  0     ,  0            },   //Y89   
{  390900,  0       ,  3.32974e+14    ,  4     ,  -8.23278e-27 },   //Y90   
{  390901,  681.67  ,  1.6591e+13     ,  0     ,  0            },   //Y90   
{  390902,  682.03  ,  1.65621e+13    ,  0     ,  0            },   //Y90   
{  390910,  0       ,  7.29283e+15    ,  1     ,  8.28834e-28  },   //Y91   
{  390911,  555.58  ,  4.30356e+12    ,  0     ,  0            },   //Y91   
{  390920,  0       ,  1.83799e+13    ,  0     ,  0            },   //Y92   
{  390930,  0       ,  5.28748e+13    ,  0     ,  0            },   //Y93   
{  390931,  758.719 ,  1.18301e+09    ,  0     ,  0            },   //Y93   
{  390940,  0       ,  1.6187e+12     ,  0     ,  0            },   //Y94   
{  390950,  0       ,  8.91586e+11    ,  0     ,  0            },   //Y95   
{  390951,  1087.5  ,  81079.5        ,  0     ,  0            },   //Y95   
{  390960,  0       ,  7.70399e+09    ,  0     ,  0            },   //Y96   
{  390970,  0       ,  5.41011e+09    ,  0     ,  0            },   //Y97   
{  390971,  667.51  ,  1.68795e+09    ,  0     ,  0            },   //Y97   
{  390972,  3523.3  ,  2.04863e+08    ,  0     ,  0            },   //Y97   
{  390980,  0       ,  7.90597e+08    ,  0     ,  0            },   //Y98   
{  390981,  495.8   ,  11541.6        ,  0     ,  0            },   //Y98   
{  390982,  1180.5  ,  1197.44        ,  0     ,  0            },   //Y98   
{  390990,  0       ,  2.12076e+09    ,  0     ,  0            },   //Y99   
{  390991,  2141.65 ,  12407.2        ,  0     ,  0            },   //Y99   
{  391000,  0       ,  1.06038e+09    ,  0     ,  0            },   //Y100  
{  391010,  0       ,  6.46328e+08    ,  0     ,  0            },   //Y101  
{  391020,  0       ,  5.1937e+08     ,  0     ,  0            },   //Y102  
{  391030,  0       ,  3.3182e+08     ,  0     ,  0            },   //Y103  
{  400810,  0       ,  2.16404e+10    ,  0     ,  0            },   //Zr81  
{  400820,  0       ,  4.61663e+10    ,  0     ,  0            },   //Zr82  
{  400830,  0       ,  6.34786e+10    ,  0     ,  0            },   //Zr83  
{  400840,  0       ,  2.24195e+12    ,  0     ,  0            },   //Zr84  
{  400850,  0       ,  6.80375e+11    ,  0     ,  0            },   //Zr85  
{  400851,  292.2   ,  1.57254e+10    ,  0     ,  0            },   //Zr85  
{  400860,  0       ,  8.56961e+13    ,  0     ,  0            },   //Zr86  
{  400870,  0       ,  8.72542e+12    ,  0     ,  0            },   //Zr87  
{  400871,  335.73  ,  2.01977e+10    ,  0     ,  0            },   //Zr87  
{  400880,  0       ,  1.03961e+16    ,  0     ,  0            },   //Zr88  
{  400881,  2887.79 ,  1904.36        ,  0     ,  0            },   //Zr88  
{  400890,  0       ,  4.07273e+14    ,  0     ,  0            },   //Zr89  
{  400891,  587.84  ,  3.61828e+11    ,  0     ,  0            },   //Zr89  
{  400901,  2319    ,  1.16743e+09    ,  0     ,  0            },   //Zr90  
{  400910,  0       ,  -1             ,  5     ,  -6.5843e-27  },   //Zr91  
{  400911,  3167.3  ,  6275.73        ,  0     ,  0            },   //Zr91  
{  400930,  0       ,  6.96533e+22    ,  0     ,  0            },   //Zr93  
{  400950,  0       ,  7.97955e+15    ,  0     ,  0            },   //Zr95  
{  400960,  0       ,  1.77596e+36    ,  0     ,  0            },   //Zr96  
{  400970,  0       ,  8.78313e+13    ,  0     ,  0            },   //Zr97  
{  400980,  0       ,  4.42907e+10    ,  0     ,  0            },   //Zr98  
{  400990,  0       ,  3.02966e+09    ,  0     ,  0            },   //Zr99  
{  401000,  0       ,  1.02431e+10    ,  0     ,  0            },   //Zr100 
{  401010,  0       ,  3.02966e+09    ,  0     ,  0            },   //Zr101 
{  401020,  0       ,  4.18382e+09    ,  0     ,  0            },   //Zr102 
{  401030,  0       ,  1.8755e+09     ,  0     ,  0            },   //Zr103 
{  401040,  0       ,  1.73123e+09    ,  0     ,  0            },   //Zr104 
{  401050,  0       ,  8.65617e+08    ,  0     ,  0            },   //Zr105 
{  410830,  0       ,  5.91505e+09    ,  0     ,  0            },   //Nb83  
{  410840,  0       ,  1.73123e+10    ,  0     ,  0            },   //Nb84  
{  410850,  0       ,  3.01523e+10    ,  0     ,  0            },   //Nb85  
{  410860,  0       ,  1.26957e+11    ,  0     ,  0            },   //Nb86  
{  410870,  0       ,  2.2506e+11     ,  0     ,  0            },   //Nb87  
{  410880,  0       ,  1.25515e+12    ,  0     ,  0            },   //Nb88  
{  410890,  0       ,  9.86804e+12    ,  0     ,  0            },   //Nb89  
{  410900,  0       ,  7.58281e+13    ,  16    ,  2.50569e-26  },   //Nb90  
{  410901,  122.37  ,  90889.8        ,  0     ,  0            },   //Nb90  
{  410902,  124.67  ,  2.71371e+10    ,  0     ,  0            },   //Nb90  
{  410903,  171.1   ,  1442.7         ,  0     ,  0            },   //Nb90  
{  410904,  382.01  ,  8.93028e+06    ,  0     ,  0            },   //Nb90  
{  410910,  0       ,  3.09602e+19    ,  0     ,  0            },   //Nb91  
{  410911,  104.49  ,  7.58569e+15    ,  0     ,  0            },   //Nb91  
{  410912,  2034.35 ,  5424.53        ,  0     ,  0            },   //Nb91  
{  410920,  0       ,  1.57975e+24    ,  0     ,  0            },   //Nb92  
{  410921,  135.5   ,  1.26524e+15    ,  0     ,  0            },   //Nb92  
{  410922,  225.7   ,  8511.9         ,  0     ,  0            },   //Nb92  
{  410930,  0       ,  -1             ,  9     ,  3.11659e-26  },   //Nb93  
{  410931,  30.82   ,  7.34332e+17    ,  0     ,  0            },   //Nb93  
{  410940,  0       ,  9.24191e+20    ,  0     ,  0            },   //Nb94  
{  410941,  40.902  ,  5.42165e+11    ,  0     ,  0            },   //Nb94  
{  410950,  0       ,  4.35983e+15    ,  9     ,  3.10169e-26  },   //Nb95  
{  410951,  235.68  ,  4.49832e+14    ,  0     ,  0            },   //Nb95  
{  410960,  0       ,  1.21273e+14    ,  12    ,  2.51327e-26  },   //Nb96  
{  410970,  0       ,  6.2411e+12     ,  9     ,  3.10775e-26  },   //Nb97  
{  410971,  743.35  ,  7.603e+10      ,  0     ,  0            },   //Nb97  
{  410980,  0       ,  4.12611e+09    ,  0     ,  0            },   //Nb98  
{  410981,  84      ,  4.44062e+12    ,  0     ,  0            },   //Nb98  
{  410990,  0       ,  2.16404e+10    ,  0     ,  0            },   //Nb99  
{  410991,  365.29  ,  2.2506e+11     ,  0     ,  0            },   //Nb99  
{  411000,  0       ,  2.16404e+09    ,  0     ,  0            },   //Nb100 
{  411001,  480     ,  4.31366e+09    ,  0     ,  0            },   //Nb100 
{  411010,  0       ,  1.02431e+10    ,  0     ,  0            },   //Nb101 
{  411020,  0       ,  1.8755e+09     ,  0     ,  0            },   //Nb102 
{  411030,  0       ,  2.16404e+09    ,  0     ,  0            },   //Nb103 
{  411040,  0       ,  6.92494e+09    ,  0     ,  0            },   //Nb104 
{  411041,  215     ,  1.32728e+09    ,  0     ,  0            },   //Nb104 
{  411050,  0       ,  4.25595e+09    ,  0     ,  0            },   //Nb105 
{  411060,  0       ,  1.47155e+09    ,  0     ,  0            },   //Nb106 
{  411070,  0       ,  4.76089e+08    ,  0     ,  0            },   //Nb107 
{  411080,  0       ,  2.74112e+08    ,  0     ,  0            },   //Nb108 
{  411090,  0       ,  2.74112e+08    ,  0     ,  0            },   //Nb109 
{  411100,  0       ,  2.45258e+08    ,  0     ,  0            },   //Nb110 
{  420860,  0       ,  2.82768e+10    ,  0     ,  0            },   //Mo86  
{  420870,  0       ,  1.93321e+10    ,  0     ,  0            },   //Mo87  
{  420880,  0       ,  6.92494e+11    ,  0     ,  0            },   //Mo88  
{  420890,  0       ,  1.76586e+11    ,  0     ,  0            },   //Mo89  
{  420891,  387.5   ,  2.74112e+08    ,  0     ,  0            },   //Mo89  
{  420900,  0       ,  2.94454e+13    ,  0     ,  0            },   //Mo90  
{  420901,  2874.73 ,  1615.82        ,  0     ,  0            },   //Mo90  
{  420910,  0       ,  1.34084e+12    ,  0     ,  0            },   //Mo91  
{  420911,  653.01  ,  9.37752e+10    ,  0     ,  0            },   //Mo91  
{  420930,  0       ,  1.82068e+20    ,  0     ,  0            },   //Mo93  
{  420931,  2424.89 ,  3.55769e+13    ,  0     ,  0            },   //Mo93  
{  420950,  0       ,  -1             ,  5     ,  -4.61743e-27 },   //Mo95  
{  420970,  0       ,  -1             ,  5     ,  -4.71491e-27 },   //Mo97  
{  420990,  0       ,  3.42496e+14    ,  1     ,  1.89404e-27  },   //Mo99  
{  420991,  97.785  ,  22361.8        ,  0     ,  0            },   //Mo99  
{  420992,  684.5   ,  1096.45        ,  0     ,  0            },   //Mo99  
{  421000,  0       ,  5.46349e+35    ,  0     ,  0            },   //Mo100 
{  421010,  0       ,  1.26467e+12    ,  0     ,  0            },   //Mo101 
{  421020,  0       ,  9.78147e+11    ,  0     ,  0            },   //Mo102 
{  421030,  0       ,  9.73819e+10    ,  0     ,  0            },   //Mo103 
{  421040,  0       ,  8.65617e+10    ,  0     ,  0            },   //Mo104 
{  421050,  0       ,  5.136e+10      ,  0     ,  0            },   //Mo105 
{  421060,  0       ,  1.21186e+10    ,  0     ,  0            },   //Mo106 
{  421070,  0       ,  5.04943e+09    ,  0     ,  0            },   //Mo107 
{  421080,  0       ,  1.57254e+09    ,  0     ,  0            },   //Mo108 
{  421090,  0       ,  7.64629e+08    ,  0     ,  0            },   //Mo109 
{  421100,  0       ,  4.32809e+08    ,  0     ,  0            },   //Mo110 
{  430880,  0       ,  9.23325e+09    ,  0     ,  0            },   //Tc88  
{  430890,  0       ,  1.84665e+10    ,  0     ,  0            },   //Tc89  
{  430900,  0       ,  1.25515e+10    ,  0     ,  0            },   //Tc90  
{  430901,  500     ,  7.09806e+10    ,  0     ,  0            },   //Tc90  
{  430910,  0       ,  2.71804e+11    ,  0     ,  0            },   //Tc91  
{  430911,  350     ,  2.85654e+11    ,  0     ,  0            },   //Tc91  
{  430920,  0       ,  3.66156e+11    ,  0     ,  0            },   //Tc92  
{  430921,  270.15  ,  1485.98        ,  0     ,  0            },   //Tc92  
{  430930,  0       ,  1.42827e+13    ,  9     ,  3.16179e-26  },   //Tc93  
{  430931,  391.84  ,  3.76544e+12    ,  0     ,  0            },   //Tc93  
{  430932,  2185.16 ,  14715.5        ,  0     ,  0            },   //Tc93  
{  430940,  0       ,  2.53626e+13    ,  14    ,  2.5658e-26   },   //Tc94  
{  430941,  75.5    ,  4.50121e+12    ,  0     ,  0            },   //Tc94  
{  430950,  0       ,  1.03874e+14    ,  9     ,  2.97491e-26  },   //Tc95  
{  430951,  38.89   ,  7.603e+15      ,  0     ,  0            },   //Tc95  
{  430960,  0       ,  5.33509e+14    ,  14    ,  2.54559e-26  },   //Tc96  
{  430961,  34.28   ,  4.45793e+12    ,  0     ,  0            },   //Tc96  
{  430970,  0       ,  1.18373e+23    ,  0     ,  0            },   //Tc97  
{  430971,  96.56   ,  1.12314e+16    ,  0     ,  0            },   //Tc97  
{  430980,  0       ,  1.91157e+23    ,  0     ,  0            },   //Tc98  
{  430990,  0       ,  9.61124e+21    ,  9     ,  2.87122e-26  },   //Tc99  
{  430991,  142.683 ,  3.12199e+13    ,  0     ,  0            },   //Tc99  
{  431000,  0       ,  2.27946e+10    ,  0     ,  0            },   //Tc100 
{  431001,  200.67  ,  12003.2        ,  0     ,  0            },   //Tc100 
{  431002,  243.96  ,  4616.63        ,  0     ,  0            },   //Tc100 
{  431010,  0       ,  1.23091e+12    ,  0     ,  0            },   //Tc101 
{  431011,  207.53  ,  917554         ,  0     ,  0            },   //Tc101 
{  431020,  0       ,  7.61743e+09    ,  0     ,  0            },   //Tc102 
{  431030,  0       ,  7.81941e+10    ,  0     ,  0            },   //Tc103 
{  431040,  0       ,  1.58408e+12    ,  0     ,  0            },   //Tc104 
{  431041,  69.7    ,  5049.43        ,  0     ,  0            },   //Tc104 
{  431050,  0       ,  6.57869e+11    ,  0     ,  0            },   //Tc105 
{  431060,  0       ,  5.136e+10      ,  0     ,  0            },   //Tc106 
{  431070,  0       ,  3.05851e+10    ,  0     ,  0            },   //Tc107 
{  431080,  0       ,  7.45874e+09    ,  0     ,  0            },   //Tc108 
{  431090,  0       ,  1.25515e+09    ,  0     ,  0            },   //Tc109 
{  431100,  0       ,  1.32728e+09    ,  0     ,  0            },   //Tc110 
{  431110,  0       ,  4.32809e+08    ,  0     ,  0            },   //Tc111 
{  431120,  0       ,  4.03955e+08    ,  0     ,  0            },   //Tc112 
{  431130,  0       ,  1.8755e+08     ,  0     ,  0            },   //Tc113 
{  440900,  0       ,  1.8755e+10     ,  0     ,  0            },   //Ru90  
{  440910,  0       ,  1.29843e+10    ,  0     ,  0            },   //Ru91  
{  440920,  0       ,  3.1595e+11     ,  0     ,  0            },   //Ru92  
{  440930,  0       ,  8.61289e+10    ,  0     ,  0            },   //Ru93  
{  440931,  734.4   ,  1.55811e+10    ,  0     ,  0            },   //Ru93  
{  440932,  2082.6  ,  3173.93        ,  0     ,  0            },   //Ru93  
{  440940,  0       ,  4.4839e+12     ,  0     ,  0            },   //Ru94  
{  440941,  2644.55 ,  102431         ,  0     ,  0            },   //Ru94  
{  440950,  0       ,  8.53354e+12    ,  5     ,  0            },   //Ru95  
{  440970,  0       ,  3.61539e+14    ,  5     ,  0            },   //Ru97  
{  440990,  0       ,  -1             ,  5     ,  -3.23755e-27 },   //Ru99  
{  441010,  0       ,  -1             ,  5     ,  -3.6305e-27  },   //Ru101 
{  441011,  527.56  ,  25247.2        ,  0     ,  0            },   //Ru101 
{  441030,  0       ,  4.89362e+15    ,  3     ,  0            },   //Ru103 
{  441031,  238.2   ,  2.43816e+06    ,  0     ,  0            },   //Ru103 
{  441050,  0       ,  2.30543e+13    ,  3     ,  0            },   //Ru105 
{  441060,  0       ,  4.65702e+16    ,  0     ,  0            },   //Ru106 
{  441070,  0       ,  3.24606e+11    ,  0     ,  0            },   //Ru107 
{  441080,  0       ,  3.93856e+11    ,  0     ,  0            },   //Ru108 
{  441090,  0       ,  4.9773e+10     ,  0     ,  0            },   //Ru109 
{  441100,  0       ,  1.67353e+10    ,  0     ,  0            },   //Ru110 
{  441110,  0       ,  3.05851e+09    ,  0     ,  0            },   //Ru111 
{  441120,  0       ,  2.52472e+09    ,  0     ,  0            },   //Ru112 
{  441130,  0       ,  1.15416e+09    ,  0     ,  0            },   //Ru113 
{  441140,  0       ,  7.64629e+08    ,  0     ,  0            },   //Ru114 
{  441150,  0       ,  5.77078e+08    ,  0     ,  0            },   //Ru115 
{  450940,  0       ,  1.01854e+11    ,  0     ,  0            },   //Rh94  
{  450950,  0       ,  4.3454e+11     ,  0     ,  0            },   //Rh95  
{  450951,  543.3   ,  1.69661e+11    ,  0     ,  0            },   //Rh95  
{  450960,  0       ,  8.56961e+11    ,  0     ,  0            },   //Rh96  
{  450961,  52      ,  1.30708e+11    ,  0     ,  0            },   //Rh96  
{  450970,  0       ,  2.65744e+12    ,  0     ,  0            },   //Rh97  
{  450971,  258.85  ,  3.99915e+12    ,  0     ,  0            },   //Rh97  
{  450980,  0       ,  7.53087e+11    ,  0     ,  0            },   //Rh98  
{  450990,  0       ,  2.00679e+15    ,  0     ,  0            },   //Rh99  
{  450991,  64.3    ,  2.44104e+13    ,  0     ,  0            },   //Rh99  
{  451000,  0       ,  1.08029e+14    ,  0     ,  0            },   //Rh100 
{  451001,  107.6   ,  3.98184e+11    ,  0     ,  0            },   //Rh100 
{  451010,  0       ,  1.50185e+17    ,  0     ,  0            },   //Rh101 
{  451011,  157.32  ,  5.41011e+14    ,  0     ,  0            },   //Rh101 
{  451020,  0       ,  2.57954e+16    ,  2     ,  2.27285e-27  },   //Rh102 
{  451021,  140.75  ,  1.32035e+17    ,  0     ,  0            },   //Rh102 
{  451030,  0       ,  -1             ,  1     ,  -4.46489e-28 },   //Rh103 
{  451031,  39.756  ,  4.85756e+12    ,  0     ,  0            },   //Rh103 
{  451040,  0       ,  6.1026e+10     ,  0     ,  0            },   //Rh104 
{  451041,  128.97  ,  3.75678e+11    ,  0     ,  0            },   //Rh104 
{  451050,  0       ,  1.83655e+14    ,  7     ,  2.24861e-26  },   //Rh105 
{  451051,  129.781 ,  6.49213e+10    ,  0     ,  0            },   //Rh105 
{  451060,  0       ,  4.29923e+10    ,  2     ,  1.30058e-26  },   //Rh106 
{  451061,  137     ,  1.13396e+13    ,  0     ,  0            },   //Rh106 
{  451070,  0       ,  1.87839e+12    ,  0     ,  0            },   //Rh107 
{  451071,  268.36  ,  14427          ,  0     ,  0            },   //Rh107 
{  451080,  0       ,  5.1937e+11     ,  0     ,  0            },   //Rh108 
{  451090,  0       ,  1.15416e+11    ,  0     ,  0            },   //Rh109 
{  451091,  225.98  ,  2394.87        ,  0     ,  0            },   //Rh109 
{  451100,  0       ,  4.61663e+09    ,  0     ,  0            },   //Rh110 
{  451110,  0       ,  1.58696e+10    ,  0     ,  0            },   //Rh111 
{  451120,  0       ,  3.02966e+09    ,  0     ,  0            },   //Rh112 
{  451130,  0       ,  4.03955e+09    ,  0     ,  0            },   //Rh113 
{  451140,  0       ,  2.66899e+09    ,  0     ,  0            },   //Rh114 
{  451150,  0       ,  1.42827e+09    ,  0     ,  0            },   //Rh115 
{  451160,  0       ,  9.81033e+08    ,  0     ,  0            },   //Rh116 
{  451170,  0       ,  6.34786e+08    ,  0     ,  0            },   //Rh117 
{  460940,  0       ,  1.29843e+10    ,  0     ,  0            },   //Pd94  
{  460951,  2000    ,  1.91878e+10    ,  0     ,  0            },   //Pd95  
{  460960,  0       ,  1.76009e+11    ,  0     ,  0            },   //Pd96  
{  460961,  2530.8  ,  3173.93        ,  0     ,  0            },   //Pd96  
{  460970,  0       ,  2.68341e+11    ,  0     ,  0            },   //Pd97  
{  460980,  0       ,  1.53214e+12    ,  0     ,  0            },   //Pd98  
{  460990,  0       ,  1.85242e+12    ,  0     ,  0            },   //Pd99  
{  461000,  0       ,  4.52429e+14    ,  0     ,  0            },   //Pd100 
{  461010,  0       ,  4.39878e+13    ,  5     ,  0            },   //Pd101 
{  461030,  0       ,  2.11788e+15    ,  0     ,  0            },   //Pd103 
{  461050,  0       ,  -1             ,  5     ,  -3.2426e-27  },   //Pd105 
{  461051,  489.14  ,  52081.3        ,  0     ,  0            },   //Pd105 
{  461070,  0       ,  2.95897e+23    ,  0     ,  0            },   //Pd107 
{  461071,  115.74  ,  1226.29        ,  0     ,  0            },   //Pd107 
{  461072,  214.9   ,  3.07294e+10    ,  0     ,  0            },   //Pd107 
{  461090,  0       ,  7.11537e+13    ,  0     ,  0            },   //Pd109 
{  461091,  188.99  ,  4.06552e+11    ,  0     ,  0            },   //Pd109 
{  461110,  0       ,  2.02554e+12    ,  0     ,  0            },   //Pd111 
{  461111,  172.18  ,  2.85654e+13    ,  0     ,  0            },   //Pd111 
{  461120,  0       ,  1.09226e+14    ,  0     ,  0            },   //Pd112 
{  461130,  0       ,  1.34171e+11    ,  0     ,  0            },   //Pd113 
{  461131,  81.1    ,  5.77078e+08    ,  0     ,  0            },   //Pd113 
{  461140,  0       ,  2.09479e+11    ,  0     ,  0            },   //Pd114 
{  461150,  0       ,  3.60674e+10    ,  0     ,  0            },   //Pd115 
{  461151,  89.3    ,  7.21348e+10    ,  0     ,  0            },   //Pd115 
{  461160,  0       ,  1.70238e+10    ,  0     ,  0            },   //Pd116 
{  461170,  0       ,  6.20359e+09    ,  0     ,  0            },   //Pd117 
{  461171,  203.2   ,  2.75555e+07    ,  0     ,  0            },   //Pd117 
{  461180,  0       ,  2.74112e+09    ,  0     ,  0            },   //Pd118 
{  461190,  0       ,  1.32728e+09    ,  0     ,  0            },   //Pd119 
{  461200,  0       ,  7.21348e+08    ,  0     ,  0            },   //Pd120 
{  470940,  0       ,  1.4427e+07     ,  0     ,  0            },   //Ag94  
{  470950,  0       ,  2.88539e+09    ,  0     ,  0            },   //Ag95  
{  470960,  0       ,  7.35775e+09    ,  0     ,  0            },   //Ag96  
{  470970,  0       ,  2.74112e+10    ,  0     ,  0            },   //Ag97  
{  470980,  0       ,  6.73739e+10    ,  0     ,  0            },   //Ag98  
{  470990,  0       ,  1.78894e+11    ,  0     ,  0            },   //Ag99  
{  470991,  506.1   ,  1.51483e+10    ,  0     ,  0            },   //Ag99  
{  471000,  0       ,  1.73989e+11    ,  0     ,  0            },   //Ag100 
{  471001,  15.52   ,  1.93898e+11    ,  0     ,  0            },   //Ag100 
{  471010,  0       ,  9.60835e+11    ,  9     ,  2.84208e-26  },   //Ag101 
{  471011,  274.1   ,  4.47236e+09    ,  0     ,  0            },   //Ag101 
{  471020,  0       ,  1.11665e+12    ,  10    ,  2.32336e-26  },   //Ag102 
{  471021,  9.3     ,  6.66525e+11    ,  0     ,  0            },   //Ag102 
{  471022,  9300    ,  -1             ,  4     ,  2.09102e-26  },   //Ag102 
{  471030,  0       ,  5.68711e+12    ,  7     ,  2.2577e-26   },   //Ag103 
{  471031,  134.44  ,  8.22336e+09    ,  0     ,  0            },   //Ag103 
{  471040,  0       ,  5.99007e+12    ,  10    ,  1.9794e-26   },   //Ag104 
{  471041,  6.9     ,  2.89982e+12    ,  0     ,  0            },   //Ag104 
{  471042,  6900    ,  -1             ,  4     ,  1.86879e-26  },   //Ag104 
{  471050,  0       ,  5.14609e+15    ,  1     ,  5.12149e-28  },   //Ag105 
{  471051,  25.465  ,  6.25841e+11    ,  0     ,  0            },   //Ag105 
{  471060,  0       ,  2.0746e+12     ,  2     ,  1.43947e-26  },   //Ag106 
{  471061,  89.66   ,  1.0321e+15     ,  0     ,  0            },   //Ag106 
{  471070,  0       ,  -1             ,  1     ,  -5.73617e-28 },   //Ag107 
{  471071,  93.13   ,  6.39114e+10    ,  0     ,  0            },   //Ag107 
{  471080,  0       ,  2.05151e+11    ,  2     ,  1.35785e-26  },   //Ag108 
{  471081,  109.44  ,  1.90292e+19    ,  0     ,  0            },   //Ag108 
{  471090,  0       ,  -1             ,  1     ,  -6.59445e-28 },   //Ag109 
{  471091,  88.0341 ,  5.71307e+10    ,  0     ,  0            },   //Ag109 
{  471100,  0       ,  3.54903e+10    ,  2     ,  1.3774e-26   },   //Ag110 
{  471101,  117.59  ,  3.11334e+16    ,  0     ,  0            },   //Ag110 
{  471110,  0       ,  9.28663e+14    ,  1     ,  -7.37414e-28 },   //Ag111 
{  471111,  59.82   ,  9.34867e+10    ,  0     ,  0            },   //Ag111 
{  471120,  0       ,  1.62592e+13    ,  4     ,  2.76278e-28  },   //Ag112 
{  471130,  0       ,  2.78873e+13    ,  1     ,  8.03075e-28  },   //Ag113 
{  471131,  43.5    ,  9.91132e+10    ,  0     ,  0            },   //Ag113 
{  471140,  0       ,  6.6364e+09     ,  0     ,  0            },   //Ag114 
{  471141,  199     ,  2.16404e+06    ,  0     ,  0            },   //Ag114 
{  471150,  0       ,  1.73123e+12    ,  0     ,  0            },   //Ag115 
{  471151,  41.1    ,  2.59685e+10    ,  0     ,  0            },   //Ag115 
{  471160,  0       ,  2.31985e+11    ,  0     ,  0            },   //Ag116 
{  471161,  81.9    ,  1.24072e+10    ,  0     ,  0            },   //Ag116 
{  471170,  0       ,  1.05028e+11    ,  0     ,  0            },   //Ag117 
{  471171,  28.6    ,  7.70399e+09    ,  0     ,  0            },   //Ag117 
{  471180,  0       ,  5.42453e+09    ,  0     ,  0            },   //Ag118 
{  471181,  127.63  ,  2.88539e+09    ,  0     ,  0            },   //Ag118 
{  471190,  0       ,  3.02966e+09    ,  0     ,  0            },   //Ag119 
{  471200,  0       ,  1.77452e+09    ,  0     ,  0            },   //Ag120 
{  471201,  203     ,  4.61663e+08    ,  0     ,  0            },   //Ag120 
{  471210,  0       ,  1.1253e+09     ,  0     ,  0            },   //Ag121 
{  471220,  0       ,  6.92494e+08    ,  0     ,  0            },   //Ag122 
{  471230,  0       ,  4.45793e+08    ,  0     ,  0            },   //Ag123 
{  471240,  0       ,  2.48144e+08    ,  0     ,  0            },   //Ag124 
{  471250,  0       ,  2.39487e+08    ,  0     ,  0            },   //Ag125 
{  471260,  0       ,  1.54368e+08    ,  0     ,  0            },   //Ag126 
{  471270,  0       ,  1.57254e+08    ,  0     ,  0            },   //Ag127 
{  480970,  0       ,  4.32809e+09    ,  0     ,  0            },   //Cd97  
{  480980,  0       ,  1.32728e+10    ,  0     ,  0            },   //Cd98  
{  480990,  0       ,  2.30831e+10    ,  0     ,  0            },   //Cd99  
{  481000,  0       ,  7.08363e+10    ,  0     ,  0            },   //Cd100 
{  481010,  0       ,  1.03874e+11    ,  0     ,  0            },   //Cd101 
{  481020,  0       ,  4.76089e+11    ,  0     ,  0            },   //Cd102 
{  481030,  0       ,  6.31901e+11    ,  5     ,  -4.09113e-27 },   //Cd103 
{  481040,  0       ,  4.99461e+12    ,  0     ,  0            },   //Cd104 
{  481050,  0       ,  4.80418e+12    ,  5     ,  -3.73404e-27 },   //Cd105 
{  481070,  0       ,  3.37591e+13    ,  5     ,  -3.10651e-27 },   //Cd107 
{  481090,  0       ,  5.76645e+16    ,  5     ,  -4.18127e-27 },   //Cd109 
{  481091,  59.6    ,  17312.3        ,  0     ,  0            },   //Cd109 
{  481092,  463     ,  15725.4        ,  0     ,  0            },   //Cd109 
{  481110,  0       ,  -1             ,  1     ,  -3.00464e-27 },   //Cd111 
{  481111,  396.214 ,  4.20113e+12    ,  0     ,  0            },   //Cd111 
{  481130,  0       ,  4.23431e+32    ,  1     ,  -3.14311e-27 },   //Cd113 
{  481131,  263.59  ,  6.41999e+17    ,  0     ,  0            },   //Cd113 
{  481150,  0       ,  2.77719e+14    ,  1     ,  -3.27506e-27 },   //Cd115 
{  481151,  181     ,  5.55871e+15    ,  0     ,  0            },   //Cd115 
{  481170,  0       ,  1.29323e+13    ,  0     ,  0            },   //Cd117 
{  481171,  136.4   ,  1.74566e+13    ,  0     ,  0            },   //Cd117 
{  481180,  0       ,  4.35405e+12    ,  0     ,  0            },   //Cd118 
{  481190,  0       ,  2.32851e+11    ,  0     ,  0            },   //Cd119 
{  481191,  146.53  ,  1.90436e+11    ,  0     ,  0            },   //Cd119 
{  481200,  0       ,  7.32889e+10    ,  0     ,  0            },   //Cd120 
{  481210,  0       ,  1.94764e+10    ,  0     ,  0            },   //Cd121 
{  481211,  214.89  ,  1.19744e+10    ,  0     ,  0            },   //Cd121 
{  481220,  0       ,  7.55972e+09    ,  0     ,  0            },   //Cd122 
{  481230,  0       ,  3.02966e+09    ,  0     ,  0            },   //Cd123 
{  481231,  316.52  ,  2.62571e+09    ,  0     ,  0            },   //Cd123 
{  481240,  0       ,  1.80337e+09    ,  0     ,  0            },   //Cd124 
{  481250,  0       ,  9.37752e+08    ,  0     ,  0            },   //Cd125 
{  481251,  49      ,  8.22336e+08    ,  0     ,  0            },   //Cd125 
{  481260,  0       ,  7.30004e+08    ,  0     ,  0            },   //Cd126 
{  481270,  0       ,  5.33797e+08    ,  0     ,  0            },   //Cd127 
{  481280,  0       ,  4.90516e+08    ,  0     ,  0            },   //Cd128 
{  481290,  0       ,  3.89528e+08    ,  0     ,  0            },   //Cd129 
{  481300,  0       ,  2.88539e+08    ,  0     ,  0            },   //Cd130 
{  491000,  0       ,  8.80044e+09    ,  0     ,  0            },   //In100 
{  491010,  0       ,  2.30831e+10    ,  0     ,  0            },   //In101 
{  491020,  0       ,  3.46247e+10    ,  0     ,  0            },   //In102 
{  491030,  0       ,  9.37752e+10    ,  0     ,  0            },   //In103 
{  491031,  631.7   ,  4.90516e+10    ,  0     ,  0            },   //In103 
{  491040,  0       ,  1.55811e+11    ,  0     ,  0            },   //In104 
{  491041,  93.5    ,  2.26503e+10    ,  0     ,  0            },   //In104 
{  491050,  0       ,  4.38868e+11    ,  9     ,  2.86632e-26  },   //In105 
{  491051,  674.1   ,  6.92494e+10    ,  0     ,  0            },   //In105 
{  491060,  0       ,  5.36683e+11    ,  14    ,  2.48297e-26  },   //In106 
{  491061,  28.6    ,  4.50121e+11    ,  0     ,  0            },   //In106 
{  491070,  0       ,  2.8046e+12     ,  9     ,  2.82086e-26  },   //In107 
{  491071,  678.5   ,  7.27118e+10    ,  0     ,  0            },   //In107 
{  491080,  0       ,  5.02058e+12    ,  14    ,  2.30366e-26  },   //In108 
{  491081,  29.75   ,  3.42784e+12    ,  0     ,  0            },   //In108 
{  491090,  0       ,  2.18136e+13    ,  9     ,  2.79712e-26  },   //In109 
{  491091,  650.1   ,  1.15993e+11    ,  0     ,  0            },   //In109 
{  491092,  2101.8  ,  3.01523e+08    ,  0     ,  0            },   //In109 
{  491100,  0       ,  2.54491e+13    ,  14    ,  2.38043e-26  },   //In110 
{  491101,  62.09   ,  5.98142e+12    ,  0     ,  0            },   //In110 
{  491110,  0       ,  3.49565e+14    ,  9     ,  2.77945e-26  },   //In111 
{  491111,  536.95  ,  6.66525e+11    ,  0     ,  0            },   //In111 
{  491120,  0       ,  1.29583e+12    ,  2     ,  1.42432e-26  },   //In112 
{  491121,  156.59  ,  1.78029e+12    ,  0     ,  0            },   //In112 
{  491122,  613.69  ,  4053.97        ,  0     ,  0            },   //In112 
{  491130,  0       ,  -1             ,  9     ,  2.79253e-26  },   //In113 
{  491131,  391.691 ,  8.61289e+12    ,  0     ,  0            },   //In113 
{  491140,  0       ,  1.0373e+11     ,  2     ,  1.42281e-26  },   //In114 
{  491141,  190.29  ,  6.17185e+15    ,  0     ,  0            },   //In114 
{  491142,  501.93  ,  6.21802e+07    ,  0     ,  0            },   //In114 
{  491143,  641.7   ,  6203.59        ,  0     ,  0            },   //In114 
{  491150,  0       ,  2.00823e+31    ,  9     ,  2.79854e-26  },   //In115 
{  491151,  336.24  ,  2.32995e+13    ,  0     ,  0            },   //In115 
{  491160,  0       ,  2.0342e+10     ,  2     ,  1.4073e-26   },   //In116 
{  491161,  127.267 ,  4.69886e+12    ,  0     ,  0            },   //In116 
{  491162,  289.66  ,  3.14508e+09    ,  0     ,  0            },   //In116 
{  491170,  0       ,  3.73947e+12    ,  9     ,  2.78753e-26  },   //In117 
{  491171,  315.302 ,  1.00585e+13    ,  0     ,  0            },   //In117 
{  491180,  0       ,  7.21348e+09    ,  0     ,  0            },   //In118 
{  491181,  60      ,  3.852e+11      ,  0     ,  0            },   //In118 
{  491182,  200     ,  1.22629e+10    ,  0     ,  0            },   //In118 
{  491190,  0       ,  2.07748e+11    ,  9     ,  2.78551e-26  },   //In119 
{  491191,  311.37  ,  1.55811e+12    ,  0     ,  0            },   //In119 
{  491200,  0       ,  4.4435e+09     ,  6     ,  2.16931e-26  },   //In120 
{  491210,  0       ,  3.33263e+10    ,  9     ,  2.77894e-26  },   //In121 
{  491211,  312.98  ,  3.36148e+11    ,  0     ,  0            },   //In121 
{  491212,  313.69  ,  3.35859e+11    ,  0     ,  0            },   //In121 
{  491220,  0       ,  2.16404e+09    ,  10    ,  1.9097e-26   },   //In122 
{  491221,  200     ,  1.55811e+10    ,  0     ,  0            },   //In122 
{  491230,  0       ,  8.62732e+09    ,  9     ,  2.77339e-26  },   //In123 
{  491231,  327.21  ,  6.89608e+10    ,  0     ,  0            },   //In123 
{  491240,  0       ,  4.48678e+09    ,  6     ,  2.04203e-26  },   //In124 
{  491241,  50      ,  5.33797e+09    ,  0     ,  0            },   //In124 
{  491250,  0       ,  3.40476e+09    ,  9     ,  2.77894e-26  },   //In125 
{  491251,  360.12  ,  1.76009e+10    ,  0     ,  0            },   //In125 
{  491260,  0       ,  2.30831e+09    ,  6     ,  2.03749e-26  },   //In126 
{  491261,  102     ,  2.36602e+09    ,  0     ,  0            },   //In126 
{  491270,  0       ,  1.57254e+09    ,  9     ,  2.78904e-26  },   //In127 
{  491271,  462     ,  5.29469e+09    ,  0     ,  0            },   //In127 
{  491280,  0       ,  1.21186e+09    ,  0     ,  0            },   //In128 
{  491281,  340     ,  1.03874e+09    ,  0     ,  0            },   //In128 
{  491290,  0       ,  8.80044e+08    ,  0     ,  0            },   //In129 
{  491291,  380     ,  1.77452e+09    ,  0     ,  0            },   //In129 
{  491300,  0       ,  4.61663e+08    ,  0     ,  0            },   //In130 
{  491301,  50      ,  7.93482e+08    ,  0     ,  0            },   //In130 
{  491302,  400     ,  7.93482e+08    ,  0     ,  0            },   //In130 
{  491310,  0       ,  4.0684e+08     ,  0     ,  0            },   //In131 
{  491311,  363     ,  5.04943e+08    ,  0     ,  0            },   //In131 
{  491312,  4270    ,  4.61663e+08    ,  0     ,  0            },   //In131 
{  491320,  0       ,  2.89982e+08    ,  0     ,  0            },   //In132 
{  491330,  0       ,  2.59685e+08    ,  0     ,  0            },   //In133 
{  491340,  0       ,  1.99092e+08    ,  0     ,  0            },   //In134 
{  501000,  0       ,  1.35613e+09    ,  0     ,  0            },   //Sn100 
{  501010,  0       ,  4.32809e+09    ,  0     ,  0            },   //Sn101 
{  501020,  0       ,  6.49213e+09    ,  0     ,  0            },   //Sn102 
{  501030,  0       ,  1.00989e+10    ,  0     ,  0            },   //Sn103 
{  501040,  0       ,  3.00081e+10    ,  0     ,  0            },   //Sn104 
{  501050,  0       ,  4.47236e+10    ,  0     ,  0            },   //Sn105 
{  501060,  0       ,  1.6591e+11     ,  0     ,  0            },   //Sn106 
{  501070,  0       ,  2.51029e+11    ,  0     ,  0            },   //Sn107 
{  501080,  0       ,  8.91586e+11    ,  0     ,  0            },   //Sn108 
{  501090,  0       ,  1.55811e+12    ,  5     ,  -5.4498e-27  },   //Sn109 
{  501100,  0       ,  2.13519e+13    ,  0     ,  0            },   //Sn110 
{  501110,  0       ,  3.05563e+12    ,  7     ,  3.07088e-27  },   //Sn111 
{  501111,  254.72  ,  18033.7        ,  0     ,  0            },   //Sn111 
{  501130,  0       ,  1.43462e+16    ,  1     ,  -4.44014e-27 },   //Sn113 
{  501131,  77.389  ,  1.85242e+12    ,  0     ,  0            },   //Sn113 
{  501141,  3087.4  ,  1057.5         ,  0     ,  0            },   //Sn114 
{  501150,  0       ,  -1             ,  1     ,  -4.64081e-27 },   //Sn115 
{  501151,  612.81  ,  4703.19        ,  0     ,  0            },   //Sn115 
{  501152,  713.64  ,  229389         ,  0     ,  0            },   //Sn115 
{  501161,  3547.16 ,  1201.77        ,  0     ,  0            },   //Sn116 
{  501170,  0       ,  -1             ,  1     ,  -5.05604e-27 },   //Sn117 
{  501171,  314.58  ,  1.69517e+15    ,  0     ,  0            },   //Sn117 
{  501172,  2406.4  ,  2524.72        ,  0     ,  0            },   //Sn117 
{  501181,  3108.06 ,  3635.59        ,  0     ,  0            },   //Sn118 
{  501190,  0       ,  -1             ,  1     ,  -5.28958e-27 },   //Sn119 
{  501191,  89.531  ,  3.6529e+16     ,  0     ,  0            },   //Sn119 
{  501192,  2127    ,  13849.9        ,  0     ,  0            },   //Sn119 
{  501201,  2481.6  ,  17023.8        ,  0     ,  0            },   //Sn120 
{  501210,  0       ,  1.40547e+14    ,  3     ,  3.52444e-27  },   //Sn121 
{  501211,  6.3     ,  2.50452e+18    ,  0     ,  0            },   //Sn121 
{  501212,  1998.8  ,  7646.29        ,  0     ,  0            },   //Sn121 
{  501213,  6300    ,  -1             ,  11    ,  -7.00897e-27 },   //Sn121 
{  501221,  2409.21 ,  10820.2        ,  0     ,  0            },   //Sn122 
{  501230,  0       ,  1.61005e+16    ,  11    ,  -6.91957e-27 },   //Sn123 
{  501231,  24.6    ,  3.46824e+12    ,  0     ,  0            },   //Sn123 
{  501232,  1945    ,  10675.9        ,  0     ,  0            },   //Sn123 
{  501241,  2325.01 ,  4472.36        ,  0     ,  0            },   //Sn124 
{  501242,  2656.6  ,  64921.3        ,  0     ,  0            },   //Sn124 
{  501250,  0       ,  1.20162e+15    ,  11    ,  -6.80846e-27 },   //Sn125 
{  501251,  27.5    ,  8.24068e+11    ,  0     ,  0            },   //Sn125 
{  501260,  0       ,  4.55315e+21    ,  0     ,  0            },   //Sn126 
{  501261,  2218.96 ,  9521.79        ,  0     ,  0            },   //Sn126 
{  501270,  0       ,  1.09068e+13    ,  0     ,  0            },   //Sn127 
{  501271,  4.7     ,  3.575e+11      ,  0     ,  0            },   //Sn127 
{  501280,  0       ,  5.11291e+12    ,  0     ,  0            },   //Sn128 
{  501281,  2091.5  ,  9.37752e+09    ,  0     ,  0            },   //Sn128 
{  501290,  0       ,  1.93033e+11    ,  0     ,  0            },   //Sn129 
{  501291,  35.2    ,  5.97276e+11    ,  0     ,  0            },   //Sn129 
{  501300,  0       ,  3.2201e+11     ,  0     ,  0            },   //Sn130 
{  501301,  1946.88 ,  1.47155e+11    ,  0     ,  0            },   //Sn130 
{  501302,  2434.79 ,  2322.74        ,  0     ,  0            },   //Sn130 
{  501310,  0       ,  8.07909e+10    ,  0     ,  0            },   //Sn131 
{  501311,  241.8   ,  8.42534e+10    ,  0     ,  0            },   //Sn131 
{  501320,  0       ,  5.7275e+10     ,  0     ,  0            },   //Sn132 
{  501321,  4847.1  ,  2856.54        ,  0     ,  0            },   //Sn132 
{  501330,  0       ,  2.09191e+09    ,  0     ,  0            },   //Sn133 
{  501340,  0       ,  1.61582e+09    ,  0     ,  0            },   //Sn134 
{  511040,  0       ,  6.34786e+08    ,  0     ,  0            },   //Sb104 
{  511050,  0       ,  1.61582e+09    ,  0     ,  0            },   //Sb105 
{  511080,  0       ,  1.00989e+10    ,  0     ,  0            },   //Sb108 
{  511090,  0       ,  2.45258e+10    ,  0     ,  0            },   //Sb109 
{  511100,  0       ,  3.3182e+10     ,  0     ,  0            },   //Sb110 
{  511110,  0       ,  1.08202e+11    ,  0     ,  0            },   //Sb111 
{  511120,  0       ,  7.41545e+10    ,  0     ,  0            },   //Sb112 
{  511130,  0       ,  5.77367e+11    ,  0     ,  0            },   //Sb113 
{  511140,  0       ,  3.021e+11      ,  0     ,  0            },   //Sb114 
{  511141,  495.5   ,  315950         ,  0     ,  0            },   //Sb114 
{  511150,  0       ,  2.77863e+12    ,  5     ,  1.74757e-26  },   //Sb115 
{  511160,  0       ,  1.36768e+12    ,  6     ,  1.37129e-26  },   //Sb116 
{  511161,  383     ,  5.21967e+12    ,  0     ,  0            },   //Sb116 
{  511170,  0       ,  1.45424e+13    ,  5     ,  1.73242e-26  },   //Sb117 
{  511171,  3130.76 ,  512157         ,  0     ,  0            },   //Sb117 
{  511180,  0       ,  3.11622e+11    ,  2     ,  1.24754e-26  },   //Sb118 
{  511181,  50.814  ,  29719.5        ,  0     ,  0            },   //Sb118 
{  511182,  250     ,  2.59685e+13    ,  0     ,  0            },   //Sb118 
{  511190,  0       ,  1.98371e+14    ,  5     ,  1.74252e-26  },   //Sb119 
{  511191,  2841.1  ,  1.22629e+09    ,  0     ,  0            },   //Sb119 
{  511200,  0       ,  1.37547e+12    ,  16    ,  1.29856e-26  },   //Sb120 
{  511210,  0       ,  -1             ,  5     ,  1.69878e-26  },   //Sb121 
{  511220,  0       ,  3.39466e+14    ,  4     ,  -9.62174e-27 },   //Sb122 
{  511221,  61.4131 ,  2683.41        ,  0     ,  0            },   //Sb122 
{  511222,  137.473 ,  764629         ,  0     ,  0            },   //Sb122 
{  511223,  163.559 ,  3.62838e+11    ,  0     ,  0            },   //Sb122 
{  511230,  0       ,  -1             ,  7     ,  1.28785e-26  },   //Sb123 
{  511240,  0       ,  7.50346e+15    ,  6     ,  6.06094e-27  },   //Sb124 
{  511241,  10.8627 ,  1.34171e+11    ,  0     ,  0            },   //Sb124 
{  511242,  36.844  ,  1.74855e+12    ,  0     ,  0            },   //Sb124 
{  511243,  40.8038 ,  4616.63        ,  0     ,  0            },   //Sb124 
{  511250,  0       ,  1.25572e+17    ,  7     ,  1.32836e-26  },   //Sb125 
{  511260,  0       ,  1.55378e+15    ,  16    ,  6.465e-27    },   //Sb126 
{  511261,  17.7    ,  1.65766e+12    ,  0     ,  0            },   //Sb126 
{  511262,  40.4    ,  1.58696e+10    ,  0     ,  0            },   //Sb126 
{  511270,  0       ,  4.7984e+14     ,  7     ,  1.30815e-26  },   //Sb127 
{  511271,  1920.2  ,  15869.6        ,  0     ,  0            },   //Sb127 
{  511280,  0       ,  4.6801e+13     ,  16    ,  6.61653e-27  },   //Sb128 
{  511290,  0       ,  2.28523e+13    ,  0     ,  0            },   //Sb129 
{  511291,  1851.05 ,  1.53214e+12    ,  0     ,  0            },   //Sb129 
{  511292,  1860.9  ,  2885.39        ,  0     ,  0            },   //Sb129 
{  511300,  0       ,  3.41919e+12    ,  0     ,  0            },   //Sb130 
{  511310,  0       ,  1.99381e+12    ,  0     ,  0            },   //Sb131 
{  511311,  1676.06 ,  131285         ,  0     ,  0            },   //Sb131 
{  511320,  0       ,  2.41507e+11    ,  0     ,  0            },   //Sb132 
{  511330,  0       ,  2.16404e+11    ,  0     ,  0            },   //Sb133 
{  511331,  4527    ,  23083.1        ,  0     ,  0            },   //Sb133 
{  511340,  0       ,  1.1253e+09     ,  0     ,  0            },   //Sb134 
{  511350,  0       ,  2.46701e+09    ,  0     ,  0            },   //Sb135 
{  511360,  0       ,  1.18301e+09    ,  0     ,  0            },   //Sb136 
{  521060,  0       ,  86561.7        ,  0     ,  0            },   //Te106 
{  521070,  0       ,  4.47236e+06    ,  0     ,  0            },   //Te107 
{  521080,  0       ,  3.02966e+09    ,  0     ,  0            },   //Te108 
{  521090,  0       ,  6.6364e+09     ,  0     ,  0            },   //Te109 
{  521100,  0       ,  2.68341e+10    ,  0     ,  0            },   //Te110 
{  521110,  0       ,  2.7844e+10     ,  0     ,  0            },   //Te111 
{  521120,  0       ,  1.73123e+11    ,  0     ,  0            },   //Te112 
{  521130,  0       ,  1.47155e+11    ,  0     ,  0            },   //Te113 
{  521140,  0       ,  1.31574e+12    ,  0     ,  0            },   //Te114 
{  521150,  0       ,  5.02058e+11    ,  0     ,  0            },   //Te115 
{  521151,  20      ,  5.79964e+11    ,  0     ,  0            },   //Te115 
{  521152,  280.05  ,  10820.2        ,  0     ,  0            },   //Te115 
{  521160,  0       ,  1.29323e+13    ,  0     ,  0            },   //Te116 
{  521170,  0       ,  5.36683e+12    ,  0     ,  0            },   //Te117 
{  521171,  296     ,  1.48598e+08    ,  0     ,  0            },   //Te117 
{  521180,  0       ,  7.47893e+14    ,  0     ,  0            },   //Te118 
{  521190,  0       ,  8.3258e+13     ,  1     ,  1.2627e-27   },   //Te119 
{  521191,  260.96  ,  5.85879e+14    ,  0     ,  0            },   //Te119 
{  521210,  0       ,  2.38766e+15    ,  0     ,  0            },   //Te121 
{  521211,  293.98  ,  1.92023e+16    ,  0     ,  0            },   //Te121 
{  521230,  0       ,  4.55315e+29    ,  1     ,  -3.72216e-27 },   //Te123 
{  521231,  247.55  ,  1.49175e+16    ,  0     ,  0            },   //Te123 
{  521250,  0       ,  -1             ,  1     ,  -4.48765e-27 },   //Te125 
{  521251,  144.795 ,  7.15433e+15    ,  0     ,  0            },   //Te125 
{  521270,  0       ,  4.85611e+13    ,  3     ,  3.20725e-27  },   //Te127 
{  521271,  88.26   ,  1.35873e+16    ,  0     ,  0            },   //Te127 
{  521280,  0       ,  1.00166e+41    ,  0     ,  0            },   //Te128 
{  521290,  0       ,  6.0247e+12     ,  3     ,  3.54565e-27  },   //Te129 
{  521291,  105.5   ,  4.18814e+15    ,  0     ,  0            },   //Te129 
{  521300,  0       ,  3.59664e+37    ,  0     ,  0            },   //Te130 
{  521310,  0       ,  2.16404e+12    ,  3     ,  3.51535e-27  },   //Te131 
{  521311,  182.25  ,  1.55811e+14    ,  0     ,  0            },   //Te131 
{  521320,  0       ,  3.99338e+14    ,  0     ,  0            },   //Te132 
{  521321,  1924.74 ,  40539.7        ,  0     ,  0            },   //Te132 
{  521330,  0       ,  1.08202e+12    ,  0     ,  0            },   //Te133 
{  521331,  334.26  ,  4.79552e+12    ,  0     ,  0            },   //Te133 
{  521340,  0       ,  3.61828e+12    ,  0     ,  0            },   //Te134 
{  521350,  0       ,  2.74112e+10    ,  0     ,  0            },   //Te135 
{  521360,  0       ,  2.52472e+10    ,  0     ,  0            },   //Te136 
{  521370,  0       ,  3.59231e+09    ,  0     ,  0            },   //Te137 
{  521380,  0       ,  2.01977e+09    ,  0     ,  0            },   //Te138 
{  531080,  0       ,  5.1937e+07     ,  0     ,  0            },   //I108  
{  531090,  0       ,  144270         ,  0     ,  0            },   //I109  
{  531100,  0       ,  9.37752e+08    ,  0     ,  0            },   //I110  
{  531110,  0       ,  3.60674e+09    ,  0     ,  0            },   //I111  
{  531120,  0       ,  4.93402e+09    ,  0     ,  0            },   //I112  
{  531130,  0       ,  9.52179e+09    ,  0     ,  0            },   //I113  
{  531140,  0       ,  3.02966e+09    ,  0     ,  0            },   //I114  
{  531141,  265.9   ,  8.94471e+09    ,  0     ,  0            },   //I114  
{  531150,  0       ,  1.1253e+11     ,  0     ,  0            },   //I115  
{  531160,  0       ,  4.19824e+09    ,  0     ,  0            },   //I116  
{  531170,  0       ,  1.92167e+11    ,  5     ,  1.56574e-26  },   //I117  
{  531180,  0       ,  1.1859e+12     ,  14    ,  2.12133e-26  },   //I118  
{  531181,  104     ,  7.35775e+11    ,  0     ,  0            },   //I118  
{  531190,  0       ,  1.65333e+12    ,  5     ,  1.46473e-26  },   //I119  
{  531200,  0       ,  7.0115e+12     ,  8     ,  0            },   //I120  
{  531210,  0       ,  1.10107e+13    ,  5     ,  1.16168e-26  },   //I121  
{  531211,  2376.9  ,  12984.3        ,  0     ,  0            },   //I121  
{  531220,  0       ,  3.14219e+11    ,  2     ,  4.74774e-27  },   //I122  
{  531230,  0       ,  6.89176e+13    ,  5     ,  1.42331e-26  },   //I123  
{  531240,  0       ,  5.20525e+14    ,  4     ,  5.75789e-27  },   //I124  
{  531250,  0       ,  7.40536e+15    ,  5     ,  1.42483e-26  },   //I125  
{  531260,  0       ,  1.63457e+15    ,  4     ,  7.25292e-27  },   //I126  
{  531270,  0       ,  -1             ,  5     ,  1.42092e-26  },   //I127  
{  531280,  0       ,  2.1626e+12     ,  0     ,  0            },   //I128  
{  531281,  137.85  ,  1219.08        ,  0     ,  0            },   //I128  
{  531290,  0       ,  7.14856e+23    ,  7     ,  1.32381e-26  },   //I129  
{  531300,  0       ,  6.41999e+13    ,  0     ,  0            },   //I130  
{  531301,  39.9525 ,  7.79056e+11    ,  0     ,  0            },   //I130  
{  531310,  0       ,  9.99788e+14    ,  7     ,  1.38492e-26  },   //I131  
{  531320,  0       ,  1.19195e+13    ,  8     ,  1.55968e-26  },   //I132  
{  531321,  120     ,  7.20338e+12    ,  0     ,  0            },   //I132  
{  531330,  0       ,  1.08029e+14    ,  7     ,  1.4425e-26   },   //I133  
{  531331,  1634.17 ,  1.29843e+10    ,  0     ,  0            },   //I133  
{  531340,  0       ,  4.54449e+12    ,  0     ,  0            },   //I134  
{  531341,  316.49  ,  3.11622e+11    ,  0     ,  0            },   //I134  
{  531350,  0       ,  3.41197e+13    ,  0     ,  0            },   //I135  
{  531360,  0       ,  1.20321e+11    ,  0     ,  0            },   //I136  
{  531361,  640     ,  6.76624e+10    ,  0     ,  0            },   //I136  
{  531370,  0       ,  3.5346e+10     ,  0     ,  0            },   //I137  
{  531380,  0       ,  9.36309e+09    ,  0     ,  0            },   //I138  
{  531390,  0       ,  3.30377e+09    ,  0     ,  0            },   //I139  
{  531400,  0       ,  1.24072e+09    ,  0     ,  0            },   //I140  
{  531410,  0       ,  6.20359e+08    ,  0     ,  0            },   //I141  
{  541100,  0       ,  2.88539e+08    ,  0     ,  0            },   //Xe110 
{  541110,  0       ,  1.06759e+09    ,  0     ,  0            },   //Xe111 
{  541120,  0       ,  3.89528e+09    ,  0     ,  0            },   //Xe112 
{  541130,  0       ,  3.95299e+09    ,  0     ,  0            },   //Xe113 
{  541140,  0       ,  1.4427e+10     ,  0     ,  0            },   //Xe114 
{  541150,  0       ,  2.59685e+10    ,  0     ,  0            },   //Xe115 
{  541160,  0       ,  8.5119e+10     ,  0     ,  0            },   //Xe116 
{  541170,  0       ,  8.80044e+10    ,  5     ,  -2.99916e-27 },   //Xe117 
{  541180,  0       ,  3.28935e+11    ,  0     ,  0            },   //Xe118 
{  541190,  0       ,  5.02058e+11    ,  5     ,  2.97996e-27  },   //Xe119 
{  541200,  0       ,  3.46247e+12    ,  0     ,  0            },   //Xe120 
{  541210,  0       ,  3.47113e+12    ,  5     ,  3.28301e-27  },   //Xe121 
{  541220,  0       ,  1.04393e+14    ,  0     ,  0            },   //Xe122 
{  541230,  0       ,  1.08029e+13    ,  0     ,  0            },   //Xe123 
{  541231,  185.18  ,  7920.4         ,  0     ,  0            },   //Xe123 
{  541240,  0       ,  7.28417e+30    ,  0     ,  0            },   //Xe124 
{  541250,  0       ,  8.77736e+13    ,  0     ,  0            },   //Xe125 
{  541251,  252.8   ,  8.22336e+10    ,  0     ,  0            },   //Xe125 
{  541270,  0       ,  4.53728e+15    ,  1     ,  -2.54509e-27 },   //Xe127 
{  541271,  297.1   ,  9.98345e+10    ,  0     ,  0            },   //Xe127 
{  541290,  0       ,  -1             ,  1     ,  -3.92939e-27 },   //Xe129 
{  541291,  236.14  ,  1.10684e+15    ,  0     ,  0            },   //Xe129 
{  541310,  0       ,  -1             ,  3     ,  3.49444e-27  },   //Xe131 
{  541311,  163.931 ,  1.47588e+15    ,  0     ,  0            },   //Xe131 
{  541321,  2752.27 ,  1.21042e+07    ,  0     ,  0            },   //Xe132 
{  541330,  0       ,  6.53541e+14    ,  3     ,  4.10831e-27  },   //Xe133 
{  541331,  233.221 ,  2.72958e+14    ,  0     ,  0            },   //Xe133 
{  541341,  1965.5  ,  4.18382e+08    ,  0     ,  0            },   //Xe134 
{  541350,  0       ,  4.74647e+13    ,  3     ,  4.56111e-27  },   //Xe135 
{  541351,  526.551 ,  1.32353e+12    ,  0     ,  0            },   //Xe135 
{  541360,  0       ,  1.07452e+38    ,  0     ,  0            },   //Xe136 
{  541361,  1891.7  ,  4255.95        ,  0     ,  0            },   //Xe136 
{  541370,  0       ,  3.30522e+11    ,  7     ,  -4.90128e-27 },   //Xe137 
{  541380,  0       ,  1.21879e+12    ,  0     ,  0            },   //Xe138 
{  541390,  0       ,  5.72462e+10    ,  3     ,  -1.53544e-27 },   //Xe139 
{  541400,  0       ,  1.96207e+10    ,  0     ,  0            },   //Xe140 
{  541410,  0       ,  2.49586e+09    ,  5     ,  5.05078e-29  },   //Xe141 
{  541420,  0       ,  1.76009e+09    ,  0     ,  0            },   //Xe142 
{  541430,  0       ,  4.32809e+08    ,  5     ,  -2.32286e-27 },   //Xe143 
{  541440,  0       ,  1.6591e+09     ,  0     ,  0            },   //Xe144 
{  541450,  0       ,  1.29843e+09    ,  0     ,  0            },   //Xe145 
{  551120,  0       ,  721348         ,  0     ,  0            },   //Cs112 
{  551130,  0       ,  24525.8        ,  0     ,  0            },   //Cs113 
{  551140,  0       ,  8.22336e+08    ,  0     ,  0            },   //Cs114 
{  551150,  0       ,  2.01977e+09    ,  0     ,  0            },   //Cs115 
{  551160,  0       ,  5.53995e+09    ,  0     ,  0            },   //Cs116 
{  551170,  0       ,  1.21186e+10    ,  0     ,  0            },   //Cs117 
{  551171,  150     ,  9.37752e+09    ,  0     ,  0            },   //Cs117 
{  551180,  0       ,  2.01977e+10    ,  4     ,  1.95768e-26  },   //Cs118 
{  551190,  0       ,  6.20359e+10    ,  3     ,  2.75773e-26  },   //Cs119 
{  551200,  0       ,  9.23325e+10    ,  4     ,  1.95465e-26  },   //Cs120 
{  551210,  0       ,  2.23618e+11    ,  3     ,  3.8891e-27   },   //Cs121 
{  551211,  68.5    ,  1.76009e+11    ,  0     ,  0            },   //Cs121 
{  551220,  0       ,  3.02966e+10    ,  2     ,  -6.73269e-28 },   //Cs122 
{  551221,  45.8    ,  1442.7         ,  0     ,  0            },   //Cs122 
{  551222,  76      ,  3.20278e+11    ,  0     ,  0            },   //Cs122 
{  551223,  127     ,  5.1937e+08     ,  0     ,  0            },   //Cs122 
{  551230,  0       ,  5.14177e+11    ,  1     ,  6.95493e-27  },   //Cs123 
{  551231,  156.74  ,  2.36602e+09    ,  0     ,  0            },   //Cs123 
{  551240,  0       ,  4.4435e+10     ,  2     ,  3.39918e-27  },   //Cs124 
{  551241,  462.55  ,  9.08898e+09    ,  0     ,  0            },   //Cs124 
{  551250,  0       ,  3.89528e+12    ,  1     ,  7.11655e-27  },   //Cs125 
{  551251,  266.1   ,  1.29843e+06    ,  0     ,  0            },   //Cs125 
{  551260,  0       ,  1.41961e+11    ,  2     ,  3.92446e-27  },   //Cs126 
{  551270,  0       ,  3.24606e+13    ,  1     ,  7.36909e-27  },   //Cs127 
{  551271,  452.23  ,  79348.2        ,  0     ,  0            },   //Cs127 
{  551280,  0       ,  3.16816e+11    ,  2     ,  4.91946e-27  },   //Cs128 
{  551290,  0       ,  1.66487e+14    ,  1     ,  7.53072e-27  },   //Cs129 
{  551300,  0       ,  2.52905e+12    ,  2     ,  7.37414e-27  },   //Cs130 
{  551301,  163.25  ,  2.99504e+11    ,  0     ,  0            },   //Cs130 
{  551310,  0       ,  1.20768e+15    ,  5     ,  1.78949e-26  },   //Cs131 
{  551320,  0       ,  8.07621e+14    ,  4     ,  1.12228e-26  },   //Cs132 
{  551330,  0       ,  -1             ,  7     ,  1.30412e-26  },   //Cs133 
{  551340,  0       ,  9.4006e+16     ,  8     ,  1.51205e-26  },   //Cs134 
{  551341,  138.744 ,  1.50762e+13    ,  0     ,  0            },   //Cs134 
{  551350,  0       ,  1.04711e+23    ,  7     ,  1.38008e-26  },   //Cs135 
{  551351,  1632.9  ,  4.58777e+12    ,  0     ,  0            },   //Cs135 
{  551360,  0       ,  1.64034e+15    ,  10    ,  1.87435e-26  },   //Cs136 
{  551370,  0       ,  1.36912e+18    ,  7     ,  1.43508e-26  },   //Cs137 
{  551380,  0       ,  2.8926e+12     ,  6     ,  3.53555e-27  },   //Cs138 
{  551381,  79.9    ,  2.51895e+11    ,  0     ,  0            },   //Cs138 
{  551390,  0       ,  8.02427e+11    ,  7     ,  1.36169e-26  },   //Cs139 
{  551400,  0       ,  9.18997e+10    ,  2     ,  6.76275e-28  },   //Cs140 
{  551410,  0       ,  3.59808e+10    ,  7     ,  1.23138e-26  },   //Cs141 
{  551420,  0       ,  2.45258e+09    ,  0     ,  0            },   //Cs142 
{  551430,  0       ,  2.568e+09      ,  3     ,  4.39418e-27  },   //Cs143 
{  551440,  0       ,  1.45712e+09    ,  2     ,  -2.75773e-27 },   //Cs144 
{  551450,  0       ,  8.56961e+08    ,  3     ,  3.95981e-27  },   //Cs145 
{  551460,  0       ,  4.94845e+08    ,  2     ,  -2.60115e-27 },   //Cs146 
{  551470,  0       ,  3.24606e+08    ,  0     ,  0            },   //Cs147 
{  551480,  0       ,  2.27946e+08    ,  0     ,  0            },   //Cs148 
{  561140,  0       ,  6.20359e+08    ,  0     ,  0            },   //Ba114 
{  561150,  0       ,  5.77078e+08    ,  0     ,  0            },   //Ba115 
{  561160,  0       ,  4.32809e+08    ,  0     ,  0            },   //Ba116 
{  561170,  0       ,  2.52472e+09    ,  0     ,  0            },   //Ba117 
{  561180,  0       ,  7.93482e+09    ,  0     ,  0            },   //Ba118 
{  561190,  0       ,  7.79056e+09    ,  0     ,  0            },   //Ba119 
{  561200,  0       ,  4.61663e+10    ,  0     ,  0            },   //Ba120 
{  561210,  0       ,  4.28481e+10    ,  5     ,  3.33352e-27  },   //Ba121 
{  561220,  0       ,  1.68795e+11    ,  0     ,  0            },   //Ba122 
{  561230,  0       ,  2.33717e+11    ,  5     ,  -3.43453e-27 },   //Ba123 
{  561231,  120.95  ,  1197.44        ,  0     ,  0            },   //Ba123 
{  561240,  0       ,  9.52179e+11    ,  0     ,  0            },   //Ba124 
{  561250,  0       ,  3.02966e+11    ,  1     ,  8.93989e-28  },   //Ba125 
{  561251,  67.7    ,  3981.84        ,  0     ,  0            },   //Ba125 
{  561260,  0       ,  8.65617e+12    ,  0     ,  0            },   //Ba126 
{  561270,  0       ,  1.09933e+12    ,  1     ,  4.4952e-28   },   //Ba127 
{  561271,  80.33   ,  2.74112e+09    ,  0     ,  0            },   //Ba127 
{  561280,  0       ,  3.02966e+14    ,  0     ,  0            },   //Ba128 
{  561290,  0       ,  1.1582e+13     ,  1     ,  -2.01021e-27 },   //Ba129 
{  561291,  8.42    ,  1.12184e+13    ,  0     ,  0            },   //Ba129 
{  561292,  8420    ,  -1             ,  7     ,  4.69723e-27  },   //Ba129 
{  561301,  2475.12 ,  1.58696e+07    ,  0     ,  0            },   //Ba130 
{  561310,  0       ,  1.43346e+15    ,  1     ,  3.57653e-27  },   //Ba131 
{  561311,  187.14  ,  1.2638e+12     ,  0     ,  0            },   //Ba131 
{  561330,  0       ,  4.78542e+17    ,  1     ,  -3.89756e-27 },   //Ba133 
{  561331,  288.247 ,  2.01977e+14    ,  0     ,  0            },   //Ba133 
{  561341,  2957.2  ,  3794.29        ,  0     ,  0            },   //Ba134 
{  561350,  0       ,  -1             ,  3     ,  4.23227e-27  },   //Ba135 
{  561351,  268.219 ,  1.4903e+14     ,  0     ,  0            },   //Ba135 
{  561361,  2030.52 ,  4.44927e+08    ,  0     ,  0            },   //Ba136 
{  561370,  0       ,  -1             ,  3     ,  4.73443e-27  },   //Ba137 
{  561371,  661.66  ,  2.20877e+11    ,  0     ,  0            },   //Ba137 
{  561381,  2090.54 ,  1154.16        ,  0     ,  0            },   //Ba138 
{  561390,  0       ,  7.19039e+12    ,  7     ,  -4.91441e-27 },   //Ba139 
{  561400,  0       ,  1.58985e+15    ,  0     ,  0            },   //Ba140 
{  561410,  0       ,  1.58119e+12    ,  3     ,  -1.70211e-27 },   //Ba141 
{  561420,  0       ,  9.17554e+11    ,  0     ,  0            },   //Ba142 
{  561430,  0       ,  2.06738e+10    ,  5     ,  2.2375e-27   },   //Ba143 
{  561440,  0       ,  1.6591e+10     ,  0     ,  0            },   //Ba144 
{  561450,  0       ,  6.21802e+09    ,  5     ,  -1.43947e-27 },   //Ba145 
{  561460,  0       ,  3.20278e+09    ,  0     ,  0            },   //Ba146 
{  561470,  0       ,  1.28833e+09    ,  0     ,  0            },   //Ba147 
{  561480,  0       ,  8.75716e+08    ,  0     ,  0            },   //Ba148 
{  561490,  0       ,  4.96287e+08    ,  0     ,  0            },   //Ba149 
{  561500,  0       ,  4.32809e+08    ,  0     ,  0            },   //Ba150 
{  571200,  0       ,  4.03955e+09    ,  0     ,  0            },   //La120 
{  571210,  0       ,  7.64629e+09    ,  0     ,  0            },   //La121 
{  571220,  0       ,  1.25515e+10    ,  0     ,  0            },   //La122 
{  571230,  0       ,  2.45258e+10    ,  0     ,  0            },   //La123 
{  571240,  0       ,  4.18382e+10    ,  0     ,  0            },   //La124 
{  571250,  0       ,  1.09645e+11    ,  0     ,  0            },   //La125 
{  571251,  107     ,  5.77078e+08    ,  0     ,  0            },   //La125 
{  571260,  0       ,  7.79056e+10    ,  0     ,  0            },   //La126 
{  571270,  0       ,  4.41465e+11    ,  0     ,  0            },   //La127 
{  571271,  14.8    ,  3.20278e+11    ,  0     ,  0            },   //La127 
{  571280,  0       ,  4.32809e+11    ,  0     ,  0            },   //La128 
{  571290,  0       ,  1.00412e+12    ,  0     ,  0            },   //La129 
{  571291,  172.1   ,  8.07909e+08    ,  0     ,  0            },   //La129 
{  571300,  0       ,  7.53087e+11    ,  0     ,  0            },   //La130 
{  571310,  0       ,  5.10714e+12    ,  0     ,  0            },   //La131 
{  571311,  304.52  ,  245258         ,  0     ,  0            },   //La131 
{  571320,  0       ,  2.49298e+13    ,  0     ,  0            },   //La132 
{  571321,  188.18  ,  2.10345e+12    ,  0     ,  0            },   //La132 
{  571330,  0       ,  2.03132e+13    ,  0     ,  0            },   //La133 
{  571340,  0       ,  5.58323e+11    ,  0     ,  0            },   //La134 
{  571350,  0       ,  1.01277e+14    ,  0     ,  0            },   //La135 
{  571360,  0       ,  8.54364e+11    ,  0     ,  0            },   //La136 
{  571361,  230     ,  1.64467e+08    ,  0     ,  0            },   //La136 
{  571370,  0       ,  2.73102e+21    ,  7     ,  1.36119e-26  },   //La137 
{  571380,  0       ,  4.78109e+27    ,  10    ,  1.87568e-26  },   //La138 
{  571390,  0       ,  -1             ,  7     ,  1.40566e-26  },   //La139 
{  571400,  0       ,  2.09191e+14    ,  6     ,  3.68707e-27  },   //La140 
{  571410,  0       ,  2.03564e+13    ,  0     ,  0            },   //La141 
{  571420,  0       ,  7.88577e+12    ,  0     ,  0            },   //La142 
{  571421,  145.82  ,  1255.15        ,  0     ,  0            },   //La142 
{  571430,  0       ,  1.22918e+12    ,  0     ,  0            },   //La143 
{  571440,  0       ,  5.8862e+10     ,  0     ,  0            },   //La144 
{  571450,  0       ,  3.57788e+10    ,  0     ,  0            },   //La145 
{  571460,  0       ,  9.0457e+09     ,  0     ,  0            },   //La146 
{  571470,  0       ,  5.79242e+09    ,  0     ,  0            },   //La147 
{  571480,  0       ,  1.51483e+09    ,  0     ,  0            },   //La148 
{  571490,  0       ,  1.51483e+09    ,  0     ,  0            },   //La149 
{  571500,  0       ,  1.24072e+09    ,  0     ,  0            },   //La150 
{  581230,  0       ,  4.61663e+09    ,  0     ,  0            },   //Ce123 
{  581240,  0       ,  8.65617e+09    ,  0     ,  0            },   //Ce124 
{  581250,  0       ,  1.29843e+10    ,  0     ,  0            },   //Ce125 
{  581260,  0       ,  7.21348e+10    ,  0     ,  0            },   //Ce126 
{  581270,  0       ,  4.47236e+10    ,  0     ,  0            },   //Ce127 
{  581271,  29.56   ,  14427          ,  0     ,  0            },   //Ce127 
{  581280,  0       ,  8.65617e+09    ,  0     ,  0            },   //Ce128 
{  581290,  0       ,  3.02966e+11    ,  0     ,  0            },   //Ce129 
{  581300,  0       ,  2.16404e+12    ,  0     ,  0            },   //Ce130 
{  581310,  0       ,  8.91586e+11    ,  0     ,  0            },   //Ce131 
{  581320,  0       ,  1.82357e+13    ,  0     ,  0            },   //Ce132 
{  581321,  2340.8  ,  1.8755e+07     ,  0     ,  0            },   //Ce132 
{  581330,  0       ,  8.39649e+12    ,  0     ,  0            },   //Ce133 
{  581331,  37.1    ,  2.54491e+13    ,  0     ,  0            },   //Ce133 
{  581340,  0       ,  3.93856e+14    ,  0     ,  0            },   //Ce134 
{  581350,  0       ,  9.19286e+13    ,  0     ,  0            },   //Ce135 
{  581351,  445.8   ,  2.88539e+10    ,  0     ,  0            },   //Ce135 
{  581361,  3095.5  ,  3173.93        ,  0     ,  0            },   //Ce136 
{  581370,  0       ,  4.67433e+13    ,  3     ,  4.84875e-27  },   //Ce137 
{  581371,  254.29  ,  1.78606e+14    ,  0     ,  0            },   //Ce137 
{  581381,  2129.17 ,  1.24793e+07    ,  0     ,  0            },   //Ce138 
{  581390,  0       ,  1.71536e+16    ,  3     ,  4.59621e-27  },   //Ce139 
{  581391,  754.24  ,  7.90597e+10    ,  0     ,  0            },   //Ce139 
{  581401,  2107.85 ,  10531.7        ,  0     ,  0            },   //Ce140 
{  581410,  0       ,  4.05109e+15    ,  7     ,  5.50535e-27  },   //Ce141 
{  581420,  0       ,  2.27657e+33    ,  0     ,  0            },   //Ce142 
{  581430,  0       ,  1.71536e+14    ,  3     ,  5.05078e-27  },   //Ce143 
{  581440,  0       ,  3.55047e+16    ,  0     ,  0            },   //Ce144 
{  581450,  0       ,  2.60551e+11    ,  0     ,  0            },   //Ce145 
{  581460,  0       ,  1.17031e+12    ,  0     ,  0            },   //Ce146 
{  581470,  0       ,  8.1368e+10     ,  0     ,  0            },   //Ce147 
{  581480,  0       ,  8.07909e+10    ,  0     ,  0            },   //Ce148 
{  581490,  0       ,  7.64629e+09    ,  0     ,  0            },   //Ce149 
{  581500,  0       ,  5.77078e+09    ,  0     ,  0            },   //Ce150 
{  581510,  0       ,  1.47155e+09    ,  0     ,  0            },   //Ce151 
{  581520,  0       ,  2.01977e+09    ,  0     ,  0            },   //Ce152 
{  591210,  0       ,  2.01977e+09    ,  0     ,  0            },   //Pr121 
{  591240,  0       ,  1.73123e+09    ,  0     ,  0            },   //Pr124 
{  591250,  0       ,  4.76089e+09    ,  0     ,  0            },   //Pr125 
{  591260,  0       ,  4.53006e+09    ,  0     ,  0            },   //Pr126 
{  591270,  0       ,  6.05932e+09    ,  0     ,  0            },   //Pr127 
{  591280,  0       ,  4.47236e+09    ,  0     ,  0            },   //Pr128 
{  591290,  0       ,  4.32809e+10    ,  0     ,  0            },   //Pr129 
{  591300,  0       ,  5.77078e+10    ,  0     ,  0            },   //Pr130 
{  591310,  0       ,  1.32439e+11    ,  0     ,  0            },   //Pr131 
{  591311,  152     ,  8.22336e+09    ,  0     ,  0            },   //Pr131 
{  591312,  152.3   ,  8.22336e+09    ,  0     ,  0            },   //Pr131 
{  591320,  0       ,  1.38499e+11    ,  0     ,  0            },   //Pr132 
{  591330,  0       ,  5.62651e+11    ,  0     ,  0            },   //Pr133 
{  591331,  192.05  ,  1442.7         ,  0     ,  0            },   //Pr133 
{  591340,  0       ,  1.47155e+12    ,  0     ,  0            },   //Pr134 
{  591350,  0       ,  2.07748e+12    ,  0     ,  0            },   //Pr135 
{  591351,  358.06  ,  151483         ,  0     ,  0            },   //Pr135 
{  591360,  0       ,  1.13396e+12    ,  0     ,  0            },   //Pr136 
{  591370,  0       ,  6.64794e+12    ,  0     ,  0            },   //Pr137 
{  591371,  561.22  ,  3837.57        ,  0     ,  0            },   //Pr137 
{  591380,  0       ,  1.25515e+11    ,  0     ,  0            },   //Pr138 
{  591381,  364     ,  1.10107e+13    ,  0     ,  0            },   //Pr138 
{  591390,  0       ,  2.291e+13      ,  0     ,  0            },   //Pr139 
{  591400,  0       ,  2.93444e+11    ,  0     ,  0            },   //Pr140 
{  591401,  763.3   ,  4400.22        ,  0     ,  0            },   //Pr140 
{  591410,  0       ,  -1             ,  5     ,  2.15941e-26  },   //Pr141 
{  591420,  0       ,  9.93007e+13    ,  4     ,  1.18188e-27  },   //Pr142 
{  591421,  3.6815  ,  1.2638e+12     ,  0     ,  0            },   //Pr142 
{  591422,  3681.5  ,  -1             ,  10    ,  1.11117e-26  },   //Pr142 
{  591430,  0       ,  1.69084e+15    ,  0     ,  0            },   //Pr143 
{  591440,  0       ,  1.49608e+12    ,  0     ,  0            },   //Pr144 
{  591441,  59.03   ,  6.23244e+11    ,  0     ,  0            },   //Pr144 
{  591450,  0       ,  3.10757e+13    ,  0     ,  0            },   //Pr145 
{  591460,  0       ,  2.09047e+12    ,  0     ,  0            },   //Pr146 
{  591470,  0       ,  1.15993e+12    ,  0     ,  0            },   //Pr147 
{  591480,  0       ,  1.96495e+11    ,  0     ,  0            },   //Pr148 
{  591481,  90      ,  1.73123e+11    ,  0     ,  0            },   //Pr148 
{  591490,  0       ,  1.95629e+11    ,  0     ,  0            },   //Pr149 
{  591500,  0       ,  8.93028e+09    ,  0     ,  0            },   //Pr150 
{  591510,  0       ,  2.72669e+10    ,  0     ,  0            },   //Pr151 
{  591520,  0       ,  5.23698e+09    ,  0     ,  0            },   //Pr152 
{  591530,  0       ,  6.20359e+09    ,  0     ,  0            },   //Pr153 
{  591540,  0       ,  3.3182e+09     ,  0     ,  0            },   //Pr154 
{  601270,  0       ,  2.59685e+09    ,  0     ,  0            },   //Nd127 
{  601280,  0       ,  5.77078e+09    ,  0     ,  0            },   //Nd128 
{  601290,  0       ,  7.06921e+09    ,  0     ,  0            },   //Nd129 
{  601300,  0       ,  4.03955e+10    ,  0     ,  0            },   //Nd130 
{  601310,  0       ,  3.89528e+10    ,  0     ,  0            },   //Nd131 
{  601320,  0       ,  1.51483e+11    ,  0     ,  0            },   //Nd132 
{  601330,  0       ,  1.00989e+11    ,  0     ,  0            },   //Nd133 
{  601331,  127.97  ,  1.00989e+11    ,  0     ,  0            },   //Nd133 
{  601340,  0       ,  7.35775e+11    ,  0     ,  0            },   //Nd134 
{  601341,  2293.1  ,  591505         ,  0     ,  0            },   //Nd134 
{  601350,  0       ,  1.07337e+12    ,  9     ,  3.93961e-27  },   //Nd135 
{  601351,  65      ,  4.76089e+11    ,  0     ,  0            },   //Nd135 
{  601360,  0       ,  4.38435e+12    ,  0     ,  0            },   //Nd136 
{  601370,  0       ,  3.33263e+12    ,  1     ,  -3.19715e-27 },   //Nd137 
{  601371,  519.6   ,  2.30831e+09    ,  0     ,  0            },   //Nd137 
{  601380,  0       ,  2.61705e+13    ,  0     ,  0            },   //Nd138 
{  601390,  0       ,  2.57088e+12    ,  3     ,  4.58106e-27  },   //Nd139 
{  601391,  231.15  ,  2.85654e+13    ,  0     ,  0            },   //Nd139 
{  601400,  0       ,  4.20113e+14    ,  0     ,  0            },   //Nd140 
{  601401,  2221.4  ,  865617         ,  0     ,  0            },   //Nd140 
{  601410,  0       ,  1.29323e+13    ,  3     ,  5.11644e-27  },   //Nd141 
{  601411,  756.7   ,  8.94471e+10    ,  0     ,  0            },   //Nd141 
{  601421,  2209.8  ,  26112.8        ,  0     ,  0            },   //Nd142 
{  601430,  0       ,  -1             ,  7     ,  -5.37908e-27 },   //Nd143 
{  601440,  0       ,  1.04264e+32    ,  0     ,  0            },   //Nd144 
{  601450,  0       ,  -1             ,  7     ,  -3.31331e-27 },   //Nd145 
{  601470,  0       ,  1.36869e+15    ,  5     ,  2.91935e-27  },   //Nd147 
{  601490,  0       ,  8.97501e+12    ,  5     ,  1.77282e-27  },   //Nd149 
{  601500,  0       ,  5.0076e+35     ,  0     ,  0            },   //Nd150 
{  601510,  0       ,  1.07683e+12    ,  0     ,  0            },   //Nd151 
{  601520,  0       ,  9.86804e+11    ,  0     ,  0            },   //Nd152 
{  601530,  0       ,  4.16939e+10    ,  0     ,  0            },   //Nd153 
{  601540,  0       ,  3.73658e+10    ,  0     ,  0            },   //Nd154 
{  601541,  1349    ,  1442.7         ,  0     ,  0            },   //Nd154 
{  601550,  0       ,  1.284e+10      ,  0     ,  0            },   //Nd155 
{  601560,  0       ,  7.89154e+09    ,  0     ,  0            },   //Nd156 
{  611300,  0       ,  3.17393e+09    ,  0     ,  0            },   //Pm130 
{  611320,  0       ,  9.08898e+09    ,  0     ,  0            },   //Pm132 
{  611330,  0       ,  2.16404e+10    ,  0     ,  0            },   //Pm133 
{  611340,  0       ,  7.21348e+09    ,  0     ,  0            },   //Pm134 
{  611350,  0       ,  6.49213e+10    ,  0     ,  0            },   //Pm135 
{  611360,  0       ,  6.78067e+10    ,  0     ,  0            },   //Pm136 
{  611370,  0       ,  2.07748e+11    ,  0     ,  0            },   //Pm137 
{  611380,  0       ,  1.4427e+10     ,  0     ,  0            },   //Pm138 
{  611390,  0       ,  3.59231e+11    ,  0     ,  0            },   //Pm139 
{  611391,  188.7   ,  2.59685e+08    ,  0     ,  0            },   //Pm139 
{  611400,  0       ,  1.32728e+10    ,  0     ,  0            },   //Pm140 
{  611401,  400     ,  5.15042e+11    ,  0     ,  0            },   //Pm140 
{  611410,  0       ,  1.80914e+12    ,  0     ,  0            },   //Pm141 
{  611411,  2530.9  ,  2885.39        ,  0     ,  0            },   //Pm141 
{  611420,  0       ,  5.84292e+10    ,  0     ,  0            },   //Pm142 
{  611421,  883.17  ,  2.88539e+06    ,  0     ,  0            },   //Pm142 
{  611422,  926.2   ,  96660.6        ,  0     ,  0            },   //Pm142 
{  611430,  0       ,  3.30377e+16    ,  5     ,  1.9193e-26   },   //Pm143 
{  611440,  0       ,  4.52429e+16    ,  10    ,  8.53582e-27  },   //Pm144 
{  611441,  840.9   ,  1125.3         ,  0     ,  0            },   //Pm144 
{  611442,  8595.8  ,  3895.28        ,  0     ,  0            },   //Pm144 
{  611450,  0       ,  8.0589e+17     ,  0     ,  0            },   //Pm145 
{  611460,  0       ,  2.5175e+17     ,  0     ,  0            },   //Pm146 
{  611470,  0       ,  1.19441e+17    ,  7     ,  1.3031e-26   },   //Pm147 
{  611480,  0       ,  6.69411e+14    ,  2     ,  1.05056e-26  },   //Pm148 
{  611481,  137.9   ,  5.14609e+15    ,  0     ,  0            },   //Pm148 
{  611490,  0       ,  2.75699e+14    ,  7     ,  1.66676e-26  },   //Pm149 
{  611491,  240.214 ,  50494.3        ,  0     ,  0            },   //Pm149 
{  611500,  0       ,  1.39191e+13    ,  0     ,  0            },   //Pm150 
{  611510,  0       ,  1.47443e+14    ,  5     ,  9.09141e-27  },   //Pm151 
{  611520,  0       ,  3.56634e+11    ,  0     ,  0            },   //Pm152 
{  611521,  150     ,  6.50944e+11    ,  0     ,  0            },   //Pm152 
{  611530,  0       ,  4.67433e+11    ,  0     ,  0            },   //Pm153 
{  611540,  0       ,  1.49752e+11    ,  0     ,  0            },   //Pm154 
{  611550,  0       ,  5.98719e+10    ,  0     ,  0            },   //Pm155 
{  611560,  0       ,  3.852e+10      ,  0     ,  0            },   //Pm156 
{  611570,  0       ,  1.52349e+10    ,  0     ,  0            },   //Pm157 
{  611580,  0       ,  6.92494e+09    ,  0     ,  0            },   //Pm158 
{  621310,  0       ,  1.73123e+09    ,  0     ,  0            },   //Sm131 
{  621320,  0       ,  5.77078e+09    ,  0     ,  0            },   //Sm132 
{  621330,  0       ,  5.33797e+09    ,  0     ,  0            },   //Sm133 
{  621340,  0       ,  1.4427e+10     ,  0     ,  0            },   //Sm134 
{  621350,  0       ,  1.48598e+10    ,  0     ,  0            },   //Sm135 
{  621360,  0       ,  6.78067e+10    ,  0     ,  0            },   //Sm136 
{  621370,  0       ,  6.49213e+10    ,  0     ,  0            },   //Sm137 
{  621380,  0       ,  2.68341e+11    ,  0     ,  0            },   //Sm138 
{  621390,  0       ,  2.22464e+11    ,  1     ,  -2.67692e-27 },   //Sm139 
{  621391,  457.8   ,  1.54368e+10    ,  0     ,  0            },   //Sm139 
{  621400,  0       ,  1.28284e+12    ,  0     ,  0            },   //Sm140 
{  621410,  0       ,  8.8293e+11     ,  1     ,  -3.72243e-27 },   //Sm141 
{  621411,  175.8   ,  1.95629e+12    ,  0     ,  0            },   //Sm141 
{  621420,  0       ,  6.27428e+12    ,  0     ,  0            },   //Sm142 
{  621430,  0       ,  7.6434e+11     ,  3     ,  5.10129e-27  },   //Sm143 
{  621431,  753.99  ,  9.52179e+10    ,  0     ,  0            },   //Sm143 
{  621432,  2793.8  ,  4.32809e+07    ,  0     ,  0            },   //Sm143 
{  621433,  2794.7  ,  4.32809e+07    ,  0     ,  0            },   //Sm143 
{  621441,  2323.6  ,  1269.57        ,  0     ,  0            },   //Sm144 
{  621450,  0       ,  4.23864e+16    ,  7     ,  -5.60637e-27 },   //Sm145 
{  621451,  8785.3  ,  1384.99        ,  0     ,  0            },   //Sm145 
{  621460,  0       ,  4.68876e+24    ,  0     ,  0            },   //Sm146 
{  621470,  0       ,  4.82582e+27    ,  7     ,  -4.11538e-27 },   //Sm147 
{  621480,  0       ,  3.18691e+32    ,  0     ,  0            },   //Sm148 
{  621490,  0       ,  9.10629e+31    ,  7     ,  -3.39261e-27 },   //Sm149 
{  621510,  0       ,  4.09725e+18    ,  5     ,  -1.83343e-27 },   //Sm151 
{  621511,  261.13  ,  2019.77        ,  0     ,  0            },   //Sm151 
{  621530,  0       ,  2.40353e+14    ,  3     ,  -1.09097e-28 },   //Sm153 
{  621531,  98.4    ,  1.52926e+07    ,  0     ,  0            },   //Sm153 
{  621550,  0       ,  1.93033e+12    ,  3     ,  5.70739e-27  },   //Sm155 
{  621560,  0       ,  4.88208e+13    ,  0     ,  0            },   //Sm156 
{  621570,  0       ,  6.95379e+11    ,  0     ,  0            },   //Sm157 
{  621580,  0       ,  4.58777e+11    ,  0     ,  0            },   //Sm158 
{  621590,  0       ,  1.64034e+10    ,  0     ,  0            },   //Sm159 
{  621600,  0       ,  1.38499e+10    ,  0     ,  0            },   //Sm160 
{  631340,  0       ,  7.21348e+08    ,  0     ,  0            },   //Eu134 
{  631350,  0       ,  2.16404e+09    ,  0     ,  0            },   //Eu135 
{  631360,  0       ,  4.76089e+09    ,  0     ,  0            },   //Eu136 
{  631370,  0       ,  1.58696e+10    ,  0     ,  0            },   //Eu137 
{  631380,  0       ,  1.74566e+10    ,  12    ,  2.62641e-26  },   //Eu138 
{  631390,  0       ,  2.58242e+10    ,  0     ,  0            },   //Eu139 
{  631400,  0       ,  2.17847e+09    ,  2     ,  6.89432e-27  },   //Eu140 
{  631401,  185.3   ,  1.80337e+08    ,  0     ,  0            },   //Eu140 
{  631410,  0       ,  5.77078e+10    ,  5     ,  1.76474e-26  },   //Eu141 
{  631411,  96.4    ,  3.89528e+09    ,  0     ,  0            },   //Eu141 
{  631420,  0       ,  3.37591e+09    ,  16    ,  1.50412e-26  },   //Eu142 
{  631430,  0       ,  2.27657e+11    ,  5     ,  1.85515e-26  },   //Eu143 
{  631431,  389.51  ,  72134.8        ,  0     ,  0            },   //Eu143 
{  631440,  0       ,  1.47155e+10    ,  2     ,  9.56113e-27  },   //Eu144 
{  631441,  1127.6  ,  1442.7         ,  0     ,  0            },   //Eu144 
{  631450,  0       ,  7.39237e+14    ,  5     ,  2.01678e-26  },   //Eu145 
{  631460,  0       ,  5.72173e+14    ,  8     ,  7.19737e-27  },   //Eu146 
{  631461,  666.37  ,  339033         ,  0     ,  0            },   //Eu146 
{  631470,  0       ,  3.00369e+15    ,  5     ,  1.88091e-26  },   //Eu147 
{  631471,  625.3   ,  1103.66        ,  0     ,  0            },   //Eu147 
{  631480,  0       ,  6.79365e+15    ,  10    ,  1.18188e-26  },   //Eu148 
{  631490,  0       ,  1.1605e+16     ,  5     ,  1.8006e-26   },   //Eu149 
{  631491,  496.386 ,  3534.6         ,  0     ,  0            },   //Eu149 
{  631500,  0       ,  1.6793e+18     ,  10    ,  1.36775e-26  },   //Eu150 
{  631501,  42.1    ,  6.64794e+13    ,  0     ,  0            },   //Eu150 
{  631510,  0       ,  -1             ,  5     ,  1.75348e-26  },   //Eu151 
{  631511,  196.245 ,  84974.8        ,  0     ,  0            },   //Eu151 
{  631520,  0       ,  6.16319e+17    ,  6     ,  -9.80559e-27 },   //Eu152 
{  631521,  45.5998 ,  4.83592e+13    ,  0     ,  0            },   //Eu152 
{  631522,  65.2969 ,  1356.13        ,  0     ,  0            },   //Eu152 
{  631523,  147.86  ,  8.30993e+12    ,  0     ,  0            },   //Eu152 
{  631530,  0       ,  -1             ,  5     ,  7.74285e-27  },   //Eu153 
{  631540,  0       ,  3.91259e+17    ,  6     ,  -1.01268e-26 },   //Eu154 
{  631541,  68.1702 ,  3173.93        ,  0     ,  0            },   //Eu154 
{  631542,  145.3   ,  4.00781e+12    ,  0     ,  0            },   //Eu154 
{  631550,  0       ,  2.16837e+17    ,  5     ,  7.87922e-27  },   //Eu155 
{  631560,  0       ,  1.89282e+15    ,  0     ,  0            },   //Eu156 
{  631570,  0       ,  7.88433e+13    ,  5     ,  7.57617e-27  },   //Eu157 
{  631580,  0       ,  3.97318e+12    ,  2     ,  7.27313e-27  },   //Eu158 
{  631590,  0       ,  1.56677e+12    ,  5     ,  6.97008e-27  },   //Eu159 
{  631600,  0       ,  5.48224e+10    ,  0     ,  0            },   //Eu160 
{  631610,  0       ,  3.75101e+10    ,  0     ,  0            },   //Eu161 
{  631620,  0       ,  1.52926e+10    ,  0     ,  0            },   //Eu162 
{  641370,  0       ,  1.00989e+10    ,  0     ,  0            },   //Gd137 
{  641390,  0       ,  7.06921e+09    ,  0     ,  0            },   //Gd139 
{  641400,  0       ,  2.27946e+10    ,  0     ,  0            },   //Gd140 
{  641410,  0       ,  2.01977e+10    ,  0     ,  0            },   //Gd141 
{  641411,  377.8   ,  3.5346e+10     ,  0     ,  0            },   //Gd141 
{  641420,  0       ,  1.01277e+11    ,  0     ,  0            },   //Gd142 
{  641430,  0       ,  5.62651e+10    ,  0     ,  0            },   //Gd143 
{  641431,  152.6   ,  1.61582e+11    ,  0     ,  0            },   //Gd143 
{  641440,  0       ,  3.89528e+11    ,  0     ,  0            },   //Gd144 
{  641450,  0       ,  1.99092e+12    ,  0     ,  0            },   //Gd145 
{  641451,  748.7   ,  1.22629e+11    ,  0     ,  0            },   //Gd145 
{  641452,  749.1   ,  1.22629e+11    ,  0     ,  0            },   //Gd145 
{  641460,  0       ,  6.01748e+15    ,  0     ,  0            },   //Gd146 
{  641470,  0       ,  1.97649e+14    ,  7     ,  5.1518e-27   },   //Gd147 
{  641480,  0       ,  3.39611e+18    ,  0     ,  0            },   //Gd148 
{  641490,  0       ,  1.15675e+15    ,  7     ,  4.44469e-27  },   //Gd149 
{  641500,  0       ,  8.14979e+22    ,  0     ,  0            },   //Gd150 
{  641510,  0       ,  1.54513e+16    ,  7     ,  3.8891e-27   },   //Gd151 
{  641520,  0       ,  4.91671e+30    ,  0     ,  0            },   //Gd152 
{  641530,  0       ,  3.01091e+16    ,  3     ,  1.9193e-27   },   //Gd153 
{  641531,  95.1737 ,  5049.43        ,  0     ,  0            },   //Gd153 
{  641532,  171.189 ,  109645         ,  0     ,  0            },   //Gd153 
{  641550,  0       ,  -1             ,  3     ,  -1.30866e-27 },   //Gd155 
{  641551,  121.05  ,  4.6123e+07     ,  0     ,  0            },   //Gd155 
{  641561,  2137.55 ,  1875.5         ,  0     ,  0            },   //Gd156 
{  641570,  0       ,  -1             ,  3     ,  -1.71626e-27 },   //Gd157 
{  641571,  426     ,  26689.9        ,  0     ,  0            },   //Gd157 
{  641590,  0       ,  9.59681e+13    ,  3     ,  -2.22234e-27 },   //Gd159 
{  641610,  0       ,  3.16816e+11    ,  0     ,  0            },   //Gd161 
{  641620,  0       ,  7.27118e+11    ,  0     ,  0            },   //Gd162 
{  641630,  0       ,  9.81033e+10    ,  0     ,  0            },   //Gd163 
{  641640,  0       ,  6.49213e+10    ,  0     ,  0            },   //Gd164 
{  651400,  0       ,  3.46247e+09    ,  0     ,  0            },   //Tb140 
{  651410,  0       ,  5.04943e+09    ,  0     ,  0            },   //Tb141 
{  651420,  0       ,  8.61289e+08    ,  0     ,  0            },   //Tb142 
{  651421,  280.2   ,  4.37137e+08    ,  0     ,  0            },   //Tb142 
{  651422,  621.4   ,  21640.4        ,  0     ,  0            },   //Tb142 
{  651430,  0       ,  1.73123e+10    ,  0     ,  0            },   //Tb143 
{  651440,  0       ,  1.4427e+09     ,  0     ,  0            },   //Tb144 
{  651441,  396.9   ,  6.13146e+09    ,  0     ,  0            },   //Tb144 
{  651442,  476.2   ,  4039.55        ,  0     ,  0            },   //Tb144 
{  651450,  0       ,  4.25595e+10    ,  0     ,  0            },   //Tb145 
{  651460,  0       ,  1.15416e+10    ,  0     ,  0            },   //Tb146 
{  651461,  779.6   ,  1.70238e+06    ,  0     ,  0            },   //Tb146 
{  651470,  0       ,  8.8293e+12     ,  0     ,  0            },   //Tb147 
{  651471,  50.6    ,  1.58408e+11    ,  0     ,  0            },   //Tb147 
{  651480,  0       ,  5.1937e+12     ,  0     ,  0            },   //Tb148 
{  651481,  90.1    ,  1.90436e+11    ,  0     ,  0            },   //Tb148 
{  651482,  8618.6  ,  1889.93        ,  0     ,  0            },   //Tb148 
{  651490,  0       ,  2.13807e+13    ,  1     ,  6.81856e-27  },   //Tb149 
{  651491,  35.78   ,  3.60097e+11    ,  0     ,  0            },   //Tb149 
{  651500,  0       ,  1.8077e+13     ,  0     ,  0            },   //Tb150 
{  651501,  474     ,  5.02058e+11    ,  0     ,  0            },   //Tb150 
{  651510,  0       ,  9.14525e+13    ,  0     ,  0            },   //Tb151 
{  651511,  99.54   ,  3.60674e+10    ,  0     ,  0            },   //Tb151 
{  651520,  0       ,  9.08898e+13    ,  4     ,  4.5457e-27   },   //Tb152 
{  651521,  342.15  ,  1384.99        ,  0     ,  0            },   //Tb152 
{  651522,  501.74  ,  3.63559e+11    ,  0     ,  0            },   //Tb152 
{  651530,  0       ,  2.91713e+14    ,  5     ,  1.76777e-26  },   //Tb153 
{  651531,  163.175 ,  268341         ,  0     ,  0            },   //Tb153 
{  651540,  0       ,  1.11665e+14    ,  6     ,  9.09141e-27  },   //Tb154 
{  651550,  0       ,  6.63063e+14    ,  3     ,  1.01016e-26  },   //Tb155 
{  651560,  0       ,  6.66814e+14    ,  6     ,  7.1216e-27   },   //Tb156 
{  651561,  49.63   ,  1.26726e+14    ,  0     ,  0            },   //Tb156 
{  651562,  88.4    ,  2.75266e+13    ,  0     ,  0            },   //Tb156 
{  651570,  0       ,  3.23308e+18    ,  3     ,  1.01016e-26  },   //Tb157 
{  651580,  0       ,  8.19451e+18    ,  6     ,  8.87928e-27  },   //Tb158 
{  651581,  110.3   ,  1.54368e+10    ,  0     ,  0            },   //Tb158 
{  651582,  388.4   ,  577078         ,  0     ,  0            },   //Tb158 
{  651590,  0       ,  -1             ,  3     ,  1.01723e-26  },   //Tb159 
{  651600,  0       ,  9.01252e+15    ,  6     ,  9.0409e-27   },   //Tb160 
{  651610,  0       ,  8.57538e+14    ,  3     ,  1.11117e-26  },   //Tb161 
{  651620,  0       ,  6.57869e+11    ,  0     ,  0            },   //Tb162 
{  651630,  0       ,  1.68795e+12    ,  0     ,  0            },   //Tb163 
{  651640,  0       ,  2.59685e+11    ,  0     ,  0            },   //Tb164 
{  651650,  0       ,  1.82645e+11    ,  0     ,  0            },   //Tb165 
{  661410,  0       ,  1.29843e+09    ,  0     ,  0            },   //Dy141 
{  661420,  0       ,  3.3182e+09     ,  0     ,  0            },   //Dy142 
{  661430,  0       ,  5.91505e+09    ,  0     ,  0            },   //Dy143 
{  661440,  0       ,  1.31285e+10    ,  0     ,  0            },   //Dy144 
{  661450,  0       ,  1.4427e+10     ,  0     ,  0            },   //Dy145 
{  661451,  118.2   ,  1.96207e+10    ,  0     ,  0            },   //Dy145 
{  661460,  0       ,  4.18382e+10    ,  0     ,  0            },   //Dy146 
{  661461,  2935.6  ,  2.16404e+08    ,  0     ,  0            },   //Dy146 
{  661470,  0       ,  5.77078e+10    ,  1     ,  -4.62147e-27 },   //Dy147 
{  661471,  750.5   ,  7.93482e+10    ,  0     ,  0            },   //Dy147 
{  661480,  0       ,  2.68341e+11    ,  0     ,  0            },   //Dy148 
{  661490,  0       ,  3.63559e+11    ,  7     ,  -6.01043e-28 },   //Dy149 
{  661491,  2661.1  ,  7.06921e+08    ,  0     ,  0            },   //Dy149 
{  661500,  0       ,  6.20648e+11    ,  0     ,  0            },   //Dy150 
{  661510,  0       ,  1.54945e+12    ,  7     ,  -4.77299e-27 },   //Dy151 
{  661520,  0       ,  1.2361e+13     ,  0     ,  0            },   //Dy152 
{  661530,  0       ,  3.32397e+13    ,  7     ,  -3.94971e-27 },   //Dy153 
{  661540,  0       ,  1.3658e+23     ,  0     ,  0            },   //Dy154 
{  661550,  0       ,  5.14177e+13    ,  3     ,  -1.94455e-27 },   //Dy155 
{  661551,  234.33  ,  8656.17        ,  0     ,  0            },   //Dy155 
{  661570,  0       ,  4.2271e+13     ,  3     ,  -1.52029e-27 },   //Dy157 
{  661571,  161.99  ,  1875.5         ,  0     ,  0            },   //Dy157 
{  661572,  199.38  ,  3.11622e+07    ,  0     ,  0            },   //Dy157 
{  661590,  0       ,  1.80048e+16    ,  3     ,  -1.78798e-27 },   //Dy159 
{  661591,  352.77  ,  176009         ,  0     ,  0            },   //Dy159 
{  661610,  0       ,  -1             ,  5     ,  -2.42589e-27 },   //Dy161 
{  661630,  0       ,  -1             ,  5     ,  3.39716e-27  },   //Dy163 
{  661650,  0       ,  1.21215e+13    ,  7     ,  -2.62641e-27 },   //Dy165 
{  661651,  108.16  ,  1.08808e+11    ,  0     ,  0            },   //Dy165 
{  661660,  0       ,  4.23864e+14    ,  0     ,  0            },   //Dy166 
{  661670,  0       ,  5.36683e+11    ,  0     ,  0            },   //Dy167 
{  661680,  0       ,  7.53087e+11    ,  0     ,  0            },   //Dy168 
{  661690,  0       ,  5.62651e+10    ,  0     ,  0            },   //Dy169 
{  671440,  0       ,  1.00989e+09    ,  0     ,  0            },   //Ho144 
{  671450,  0       ,  3.46247e+09    ,  0     ,  0            },   //Ho145 
{  671460,  0       ,  5.1937e+09     ,  0     ,  0            },   //Ho146 
{  671470,  0       ,  8.36763e+09    ,  0     ,  0            },   //Ho147 
{  671480,  0       ,  3.17393e+09    ,  0     ,  0            },   //Ho148 
{  671481,  694.4   ,  3.39033e+06    ,  0     ,  0            },   //Ho148 
{  671490,  0       ,  3.04409e+10    ,  0     ,  0            },   //Ho149 
{  671491,  48.8    ,  8.07909e+10    ,  0     ,  0            },   //Ho149 
{  671500,  0       ,  1.03874e+11    ,  0     ,  0            },   //Ho150 
{  671501,  800     ,  3.36148e+10    ,  0     ,  0            },   //Ho150 
{  671510,  0       ,  5.07829e+10    ,  0     ,  0            },   //Ho151 
{  671511,  41.4    ,  6.80952e+10    ,  0     ,  0            },   //Ho151 
{  671520,  0       ,  2.33428e+11    ,  4     ,  -5.1518e-27  },   //Ho152 
{  671521,  160     ,  7.21348e+10    ,  0     ,  0            },   //Ho152 
{  671522,  3019.59 ,  12118.6        ,  0     ,  0            },   //Ho152 
{  671530,  0       ,  1.73123e+11    ,  11    ,  3.43958e-26  },   //Ho153 
{  671531,  68      ,  8.05024e+11    ,  0     ,  0            },   //Ho153 
{  671540,  0       ,  1.01797e+12    ,  4     ,  -3.24765e-27 },   //Ho154 
{  671541,  320     ,  2.68341e+11    ,  0     ,  0            },   //Ho154 
{  671550,  0       ,  4.15496e+12    ,  5     ,  1.76777e-26  },   //Ho155 
{  671551,  141.97  ,  1.26957e+06    ,  0     ,  0            },   //Ho155 
{  671560,  0       ,  4.84746e+12    ,  8     ,  1.51018e-26  },   //Ho156 
{  671570,  0       ,  1.09068e+12    ,  7     ,  2.19709e-26  },   //Ho157 
{  671580,  0       ,  9.78147e+11    ,  10    ,  1.90415e-26  },   //Ho158 
{  671581,  67.2    ,  2.42373e+12    ,  0     ,  0            },   //Ho158 
{  671582,  180     ,  1.84376e+12    ,  0     ,  0            },   //Ho158 
{  671590,  0       ,  2.86087e+12    ,  7     ,  2.16174e-26  },   //Ho159 
{  671591,  205.91  ,  1.19744e+10    ,  0     ,  0            },   //Ho159 
{  671600,  0       ,  2.21598e+12    ,  10    ,  1.86879e-26  },   //Ho160 
{  671601,  59.98   ,  2.60695e+13    ,  0     ,  0            },   //Ho160 
{  671602,  169.6   ,  4.32809e+09    ,  0     ,  0            },   //Ho160 
{  671610,  0       ,  1.28804e+13    ,  7     ,  2.14658e-26  },   //Ho161 
{  671611,  211.14  ,  9.75262e+09    ,  0     ,  0            },   //Ho161 
{  671620,  0       ,  1.29843e+12    ,  2     ,  1.17178e-26  },   //Ho162 
{  671621,  106     ,  5.79964e+12    ,  0     ,  0            },   //Ho162 
{  671630,  0       ,  2.08037e+20    ,  7     ,  2.13648e-26  },   //Ho163 
{  671631,  297.88  ,  1.57254e+09    ,  0     ,  0            },   //Ho163 
{  671640,  0       ,  2.51029e+12    ,  0     ,  0            },   //Ho164 
{  671641,  139.77  ,  3.24606e+12    ,  0     ,  0            },   //Ho164 
{  671642,  140     ,  3.24606e+12    ,  0     ,  0            },   //Ho164 
{  671650,  0       ,  -1             ,  7     ,  2.08698e-26  },   //Ho165 
{  671651,  361.68  ,  2178.47        ,  0     ,  0            },   //Ho165 
{  671660,  0       ,  1.3935e+14     ,  0     ,  0            },   //Ho166 
{  671661,  5.985   ,  5.46349e+19    ,  0     ,  0            },   //Ho166 
{  671662,  190.905 ,  266899         ,  0     ,  0            },   //Ho166 
{  671663,  5985    ,  -1             ,  14    ,  1.81828e-26  },   //Ho166 
{  671670,  0       ,  1.61005e+13    ,  0     ,  0            },   //Ho167 
{  671671,  259.34  ,  8656.17        ,  0     ,  0            },   //Ho167 
{  671680,  0       ,  2.5882e+11     ,  0     ,  0            },   //Ho168 
{  671681,  59      ,  1.90436e+11    ,  0     ,  0            },   //Ho168 
{  671682,  143.4   ,  5770.78        ,  0     ,  0            },   //Ho168 
{  671690,  0       ,  4.0684e+11     ,  0     ,  0            },   //Ho169 
{  671700,  0       ,  2.3891e+11     ,  0     ,  0            },   //Ho170 
{  671701,  120     ,  6.20359e+10    ,  0     ,  0            },   //Ho170 
{  671710,  0       ,  7.64629e+10    ,  0     ,  0            },   //Ho171 
{  671720,  0       ,  3.60674e+10    ,  0     ,  0            },   //Ho172 
{  681450,  0       ,  1.29843e+09    ,  0     ,  0            },   //Er145 
{  681460,  0       ,  2.45258e+09    ,  0     ,  0            },   //Er146 
{  681470,  0       ,  3.60674e+09    ,  0     ,  0            },   //Er147 
{  681480,  0       ,  6.6364e+09     ,  0     ,  0            },   //Er148 
{  681481,  2915.5  ,  18755          ,  0     ,  0            },   //Er148 
{  681490,  0       ,  5.77078e+09    ,  0     ,  0            },   //Er149 
{  681491,  741.8   ,  1.284e+10      ,  0     ,  0            },   //Er149 
{  681492,  3242.7  ,  6924.94        ,  0     ,  0            },   //Er149 
{  681500,  0       ,  2.66899e+10    ,  0     ,  0            },   //Er150 
{  681501,  2797    ,  3678.87        ,  0     ,  0            },   //Er150 
{  681510,  0       ,  3.39033e+10    ,  0     ,  0            },   //Er151 
{  681511,  2585.5  ,  8.36763e+08    ,  0     ,  0            },   //Er151 
{  681520,  0       ,  1.48598e+10    ,  0     ,  0            },   //Er152 
{  681530,  0       ,  5.3524e+10     ,  7     ,  -4.71743e-27 },   //Er153 
{  681540,  0       ,  3.22875e+11    ,  0     ,  0            },   //Er154 
{  681550,  0       ,  4.58777e+11    ,  7     ,  -3.37897e-27 },   //Er155 
{  681560,  0       ,  1.68795e+12    ,  0     ,  0            },   //Er156 
{  681570,  0       ,  1.61438e+12    ,  3     ,  -2.08092e-27 },   //Er157 
{  681571,  155.4   ,  1.09645e+08    ,  0     ,  0            },   //Er157 
{  681580,  0       ,  1.18936e+13    ,  0     ,  0            },   //Er158 
{  681590,  0       ,  3.11622e+12    ,  3     ,  -1.53544e-27 },   //Er159 
{  681600,  0       ,  1.48453e+14    ,  0     ,  0            },   //Er160 
{  681610,  0       ,  1.66776e+13    ,  3     ,  -1.84354e-27 },   //Er161 
{  681611,  396.44  ,  10820.2        ,  0     ,  0            },   //Er161 
{  681630,  0       ,  6.49213e+12    ,  5     ,  2.81329e-27  },   //Er163 
{  681650,  0       ,  5.38125e+13    ,  5     ,  3.24765e-27  },   //Er165 
{  681670,  0       ,  -1             ,  7     ,  -2.84788e-27 },   //Er167 
{  681671,  207.802 ,  3.27348e+09    ,  0     ,  0            },   //Er167 
{  681690,  0       ,  1.17176e+15    ,  1     ,  2.60115e-27  },   //Er169 
{  681710,  0       ,  3.90393e+13    ,  5     ,  3.32847e-27  },   //Er171 
{  681720,  0       ,  2.56078e+14    ,  0     ,  0            },   //Er172 
{  681730,  0       ,  1.21186e+11    ,  0     ,  0            },   //Er173 
{  681740,  0       ,  2.85654e+11    ,  0     ,  0            },   //Er174 
{  681750,  0       ,  1.03874e+11    ,  0     ,  0            },   //Er175 
{  691460,  0       ,  3.39033e+08    ,  0     ,  0            },   //Tm146 
{  691461,  70      ,  1.03874e+08    ,  0     ,  0            },   //Tm146 
{  691470,  0       ,  8.07909e+08    ,  0     ,  0            },   //Tm147 
{  691480,  0       ,  1.00989e+09    ,  0     ,  0            },   //Tm148 
{  691490,  0       ,  1.29843e+09    ,  0     ,  0            },   //Tm149 
{  691500,  0       ,  3.17393e+09    ,  0     ,  0            },   //Tm150 
{  691501,  671.6   ,  7.50202e+06    ,  0     ,  0            },   //Tm150 
{  691510,  0       ,  7.50202e+09    ,  0     ,  0            },   //Tm151 
{  691520,  0       ,  1.15416e+10    ,  0     ,  0            },   //Tm152 
{  691530,  0       ,  2.13519e+09    ,  0     ,  0            },   //Tm153 
{  691531,  43.2    ,  3.60674e+09    ,  0     ,  0            },   //Tm153 
{  691540,  0       ,  1.16858e+10    ,  0     ,  0            },   //Tm154 
{  691550,  0       ,  3.11622e+10    ,  0     ,  0            },   //Tm155 
{  691551,  41      ,  6.49213e+10    ,  0     ,  0            },   //Tm155 
{  691560,  0       ,  1.20898e+11    ,  4     ,  2.02031e-27  },   //Tm156 
{  691570,  0       ,  3.14219e+11    ,  1     ,  2.40417e-27  },   //Tm157 
{  691580,  0       ,  3.44516e+11    ,  4     ,  2.12133e-28  },   //Tm158 
{  691590,  0       ,  7.90309e+11    ,  5     ,  1.72737e-26  },   //Tm159 
{  691600,  0       ,  8.1368e+11     ,  2     ,  7.87922e-28  },   //Tm160 
{  691601,  70      ,  1.07481e+11    ,  0     ,  0            },   //Tm160 
{  691610,  0       ,  2.85654e+12    ,  7     ,  1.21219e-26  },   //Tm161 
{  691620,  0       ,  1.87839e+12    ,  2     ,  3.43453e-28  },   //Tm162 
{  691621,  66.9    ,  3.50575e+10    ,  0     ,  0            },   //Tm162 
{  691630,  0       ,  9.4006e+12     ,  1     ,  -4.14164e-28 },   //Tm163 
{  691640,  0       ,  1.73123e+11    ,  2     ,  1.19704e-26  },   //Tm164 
{  691650,  0       ,  1.561e+14      ,  1     ,  -7.02059e-28 },   //Tm165 
{  691651,  80.37   ,  115848         ,  0     ,  0            },   //Tm165 
{  691652,  160.47  ,  12984.3        ,  0     ,  0            },   //Tm165 
{  691660,  0       ,  3.99915e+13    ,  4     ,  4.64672e-28  },   //Tm166 
{  691670,  0       ,  1.153e+15      ,  1     ,  -9.95004e-28 },   //Tm167 
{  691671,  179.48  ,  1673.53        ,  0     ,  0            },   //Tm167 
{  691672,  292.82  ,  1298.43        ,  0     ,  0            },   //Tm167 
{  691680,  0       ,  1.1605e+16     ,  6     ,  1.14653e-27  },   //Tm168 
{  691690,  0       ,  -1             ,  1     ,  -1.16976e-27 },   //Tm169 
{  691700,  0       ,  1.60283e+16    ,  2     ,  1.25057e-27  },   //Tm170 
{  691701,  183.197 ,  5943.91        ,  0     ,  0            },   //Tm170 
{  691710,  0       ,  8.74129e+16    ,  1     ,  -1.1632e-27  },   //Tm171 
{  691711,  424.95  ,  3751.01        ,  0     ,  0            },   //Tm171 
{  691720,  0       ,  3.30377e+14    ,  0     ,  0            },   //Tm172 
{  691730,  0       ,  4.27903e+13    ,  0     ,  0            },   //Tm173 
{  691731,  317.73  ,  14427          ,  0     ,  0            },   //Tm173 
{  691740,  0       ,  4.67433e+11    ,  0     ,  0            },   //Tm174 
{  691750,  0       ,  1.31574e+12    ,  0     ,  0            },   //Tm175 
{  691760,  0       ,  1.64467e+11    ,  0     ,  0            },   //Tm176 
{  691770,  0       ,  1.22629e+11    ,  0     ,  0            },   //Tm177 
{  701510,  0       ,  2.30831e+09    ,  0     ,  0            },   //Yb151 
{  701511,  2448    ,  28853.9        ,  0     ,  0            },   //Yb151 
{  701520,  0       ,  4.38579e+09    ,  0     ,  0            },   //Yb152 
{  701521,  2744.5  ,  43280.9        ,  0     ,  0            },   //Yb152 
{  701530,  0       ,  6.05932e+09    ,  0     ,  0            },   //Yb153 
{  701540,  0       ,  5.82849e+08    ,  0     ,  0            },   //Yb154 
{  701550,  0       ,  2.52472e+09    ,  7     ,  -4.24266e-27 },   //Yb155 
{  701560,  0       ,  3.76544e+10    ,  0     ,  0            },   //Yb156 
{  701570,  0       ,  5.5688e+10     ,  7     ,  -3.22745e-27 },   //Yb157 
{  701580,  0       ,  1.28977e+11    ,  0     ,  0            },   //Yb158 
{  701590,  0       ,  1.36768e+11    ,  5     ,  -1.84859e-27 },   //Yb159 
{  701600,  0       ,  4.15496e+11    ,  0     ,  0            },   //Yb160 
{  701610,  0       ,  3.63559e+11    ,  3     ,  -1.65161e-27 },   //Yb161 
{  701620,  0       ,  1.63313e+12    ,  0     ,  0            },   //Yb162 
{  701630,  0       ,  9.56507e+11    ,  3     ,  -1.88899e-27 },   //Yb163 
{  701640,  0       ,  6.56138e+12    ,  0     ,  0            },   //Yb164 
{  701650,  0       ,  8.56961e+11    ,  5     ,  2.41427e-27  },   //Yb165 
{  701660,  0       ,  2.94454e+14    ,  0     ,  0            },   //Yb166 
{  701670,  0       ,  1.51483e+12    ,  5     ,  3.14664e-27  },   //Yb167 
{  701690,  0       ,  3.99194e+15    ,  7     ,  -3.20725e-27 },   //Yb169 
{  701691,  24.199  ,  6.6364e+10     ,  0     ,  0            },   //Yb169 
{  701710,  0       ,  -1             ,  1     ,  2.49342e-27  },   //Yb171 
{  701711,  95.272  ,  7.57415e+06    ,  0     ,  0            },   //Yb171 
{  701721,  1550.43 ,  5193.7         ,  0     ,  0            },   //Yb172 
{  701730,  0       ,  -1             ,  5     ,  -3.43398e-27 },   //Yb173 
{  701731,  398.9   ,  4183.82        ,  0     ,  0            },   //Yb173 
{  701741,  1518.15 ,  1.19744e+06    ,  0     ,  0            },   //Yb174 
{  701750,  0       ,  5.21679e+14    ,  7     ,  2.92945e-27  },   //Yb175 
{  701751,  514.869 ,  9.83918e+07    ,  0     ,  0            },   //Yb175 
{  701761,  1050    ,  1.64467e+10    ,  0     ,  0            },   //Yb176 
{  701770,  0       ,  9.92574e+12    ,  0     ,  0            },   //Yb177 
{  701771,  331.5   ,  9.24768e+09    ,  0     ,  0            },   //Yb177 
{  701780,  0       ,  6.40557e+12    ,  0     ,  0            },   //Yb178 
{  701790,  0       ,  6.92494e+11    ,  0     ,  0            },   //Yb179 
{  701800,  0       ,  2.07748e+11    ,  0     ,  0            },   //Yb180 
{  711500,  0       ,  5.04943e+07    ,  0     ,  0            },   //Lu150 
{  711510,  0       ,  1.22629e+08    ,  0     ,  0            },   //Lu151 
{  711520,  0       ,  1.00989e+09    ,  0     ,  0            },   //Lu152 
{  711531,  2632.9  ,  21640.4        ,  0     ,  0            },   //Lu153 
{  711540,  0       ,  1.61582e+09    ,  0     ,  0            },   //Lu154 
{  711541,  130.4   ,  50494.3        ,  0     ,  0            },   //Lu154 
{  711550,  0       ,  2.01977e+08    ,  0     ,  0            },   //Lu155 
{  711551,  21      ,  9.81033e+07    ,  0     ,  0            },   //Lu155 
{  711552,  1798    ,  3.75101e+06    ,  0     ,  0            },   //Lu155 
{  711560,  0       ,  7.21348e+08    ,  0     ,  0            },   //Lu156 
{  711570,  0       ,  9.81033e+09    ,  0     ,  0            },   //Lu157 
{  711571,  26      ,  6.91051e+09    ,  0     ,  0            },   //Lu157 
{  711580,  0       ,  1.52926e+10    ,  0     ,  0            },   //Lu158 
{  711590,  0       ,  1.74566e+10    ,  0     ,  0            },   //Lu159 
{  711600,  0       ,  5.20813e+10    ,  0     ,  0            },   //Lu160 
{  711610,  0       ,  1.11088e+11    ,  0     ,  0            },   //Lu161 
{  711611,  135.8   ,  1.05317e+07    ,  0     ,  0            },   //Lu161 
{  711620,  0       ,  1.1859e+11     ,  0     ,  0            },   //Lu162 
{  711630,  0       ,  3.43362e+11    ,  0     ,  0            },   //Lu163 
{  711640,  0       ,  2.71804e+11    ,  0     ,  0            },   //Lu164 
{  711650,  0       ,  9.29673e+11    ,  0     ,  0            },   //Lu165 
{  711660,  0       ,  2.29389e+11    ,  0     ,  0            },   //Lu166 
{  711661,  34.37   ,  1.22052e+11    ,  0     ,  0            },   //Lu166 
{  711662,  42.9    ,  1.83511e+11    ,  0     ,  0            },   //Lu166 
{  711670,  0       ,  4.45793e+12    ,  0     ,  0            },   //Lu167 
{  711680,  0       ,  4.76089e+11    ,  0     ,  0            },   //Lu168 
{  711681,  220     ,  5.79964e+11    ,  0     ,  0            },   //Lu168 
{  711690,  0       ,  1.76874e+14    ,  0     ,  0            },   //Lu169 
{  711691,  29      ,  2.30831e+11    ,  0     ,  0            },   //Lu169 
{  711700,  0       ,  2.5074e+14     ,  0     ,  0            },   //Lu170 
{  711701,  92.89   ,  9.66606e+08    ,  0     ,  0            },   //Lu170 
{  711710,  0       ,  1.02705e+15    ,  7     ,  1.02531e-26  },   //Lu171 
{  711711,  71.2    ,  1.13973e+11    ,  0     ,  0            },   //Lu171 
{  711720,  0       ,  8.35176e+14    ,  8     ,  1.13643e-26  },   //Lu172 
{  711721,  41.86   ,  3.20278e+11    ,  0     ,  0            },   //Lu172 
{  711722,  109.41  ,  634786         ,  0     ,  0            },   //Lu172 
{  711730,  0       ,  6.23677e+16    ,  7     ,  1.18188e-26  },   //Lu173 
{  711731,  123.672 ,  107048         ,  0     ,  0            },   //Lu173 
{  711740,  0       ,  1.50762e+17    ,  2     ,  9.79852e-27  },   //Lu174 
{  711741,  170.83  ,  1.77019e+16    ,  0     ,  0            },   //Lu174 
{  711750,  0       ,  -1             ,  7     ,  1.12769e-26  },   //Lu175 
{  711751,  353.3   ,  2149.62        ,  0     ,  0            },   //Lu175 
{  711760,  0       ,  1.72114e+27    ,  14    ,  1.60069e-26  },   //Lu176 
{  711761,  123     ,  1.88849e+13    ,  0     ,  0            },   //Lu176 
{  711770,  0       ,  8.3936e+14     ,  7     ,  1.13087e-26  },   //Lu177 
{  711771,  569.66  ,  216404         ,  0     ,  0            },   //Lu177 
{  711772,  970.175 ,  1.99958e+16    ,  0     ,  0            },   //Lu177 
{  711780,  0       ,  2.45835e+12    ,  0     ,  0            },   //Lu178 
{  711781,  120     ,  1.99958e+12    ,  0     ,  0            },   //Lu178 
{  711790,  0       ,  2.38333e+13    ,  7     ,  1.66676e-26  },   //Lu179 
{  711791,  592.4   ,  4.47236e+06    ,  0     ,  0            },   //Lu179 
{  711800,  0       ,  4.93402e+11    ,  0     ,  0            },   //Lu180 
{  711810,  0       ,  3.02966e+11    ,  0     ,  0            },   //Lu181 
{  711820,  0       ,  1.73123e+11    ,  0     ,  0            },   //Lu182 
{  711830,  0       ,  8.36763e+10    ,  0     ,  0            },   //Lu183 
{  711840,  0       ,  2.88539e+10    ,  0     ,  0            },   //Lu184 
{  721540,  0       ,  2.88539e+09    ,  0     ,  0            },   //Hf154 
{  721550,  0       ,  1.284e+09      ,  0     ,  0            },   //Hf155 
{  721560,  0       ,  3.60674e+07    ,  0     ,  0            },   //Hf156 
{  721570,  0       ,  1.58696e+08    ,  0     ,  0            },   //Hf157 
{  721580,  0       ,  4.12611e+09    ,  0     ,  0            },   //Hf158 
{  721590,  0       ,  8.07909e+09    ,  0     ,  0            },   //Hf159 
{  721600,  0       ,  1.96207e+10    ,  0     ,  0            },   //Hf160 
{  721610,  0       ,  2.42373e+10    ,  0     ,  0            },   //Hf161 
{  721620,  0       ,  5.42453e+10    ,  0     ,  0            },   //Hf162 
{  721630,  0       ,  5.77078e+10    ,  0     ,  0            },   //Hf163 
{  721640,  0       ,  1.60139e+11    ,  0     ,  0            },   //Hf164 
{  721650,  0       ,  1.09645e+11    ,  0     ,  0            },   //Hf165 
{  721660,  0       ,  5.86023e+11    ,  0     ,  0            },   //Hf166 
{  721670,  0       ,  1.77452e+11    ,  0     ,  0            },   //Hf167 
{  721680,  0       ,  2.24628e+12    ,  0     ,  0            },   //Hf168 
{  721690,  0       ,  2.8046e+11     ,  0     ,  0            },   //Hf169 
{  721700,  0       ,  8.3157e+13     ,  0     ,  0            },   //Hf170 
{  721710,  0       ,  6.28438e+13    ,  0     ,  0            },   //Hf171 
{  721720,  0       ,  8.51335e+16    ,  0     ,  0            },   //Hf172 
{  721730,  0       ,  1.22571e+14    ,  0     ,  0            },   //Hf173 
{  721740,  0       ,  9.10629e+31    ,  0     ,  0            },   //Hf174 
{  721741,  1797.5  ,  3448.04        ,  0     ,  0            },   //Hf174 
{  721742,  3311.7  ,  5337.97        ,  0     ,  0            },   //Hf174 
{  721750,  0       ,  8.72542e+15    ,  5     ,  2.72237e-27  },   //Hf175 
{  721751,  125.93  ,  77472.7        ,  0     ,  0            },   //Hf175 
{  721752,  1433.5  ,  1586.96        ,  0     ,  0            },   //Hf175 
{  721753,  3015.8  ,  1745.66        ,  0     ,  0            },   //Hf175 
{  721761,  1333.06 ,  13849.9        ,  0     ,  0            },   //Hf176 
{  721762,  1559.3  ,  14282.7        ,  0     ,  0            },   //Hf176 
{  721763,  2866    ,  578521         ,  0     ,  0            },   //Hf176 
{  721764,  4863.6  ,  62035.9        ,  0     ,  0            },   //Hf176 
{  721770,  0       ,  -1             ,  7     ,  4.0078e-27   },   //Hf177 
{  721771,  1315.45 ,  1.55811e+09    ,  0     ,  0            },   //Hf177 
{  721772,  2740    ,  4.44927e+12    ,  0     ,  0            },   //Hf177 
{  721781,  1147.42 ,  5.77078e+09    ,  0     ,  0            },   //Hf178 
{  721782,  2446.05 ,  1.41139e+18    ,  0     ,  0            },   //Hf178 
{  721783,  2573.5  ,  98103.3        ,  0     ,  0            },   //Hf178 
{  721790,  0       ,  -1             ,  9     ,  -3.23705e-27 },   //Hf179 
{  721791,  375.037 ,  2.69351e+10    ,  0     ,  0            },   //Hf179 
{  721792,  1105.84 ,  3.12199e+15    ,  0     ,  0            },   //Hf179 
{  721801,  1141.48 ,  2.85654e+13    ,  0     ,  0            },   //Hf180 
{  721810,  0       ,  5.28315e+15    ,  0     ,  0            },   //Hf181 
{  721820,  0       ,  4.09725e+23    ,  0     ,  0            },   //Hf182 
{  721821,  1172.88 ,  5.32355e+12    ,  0     ,  0            },   //Hf182 
{  721830,  0       ,  5.54139e+12    ,  0     ,  0            },   //Hf183 
{  721840,  0       ,  2.13952e+13    ,  0     ,  0            },   //Hf184 
{  721850,  0       ,  3.02966e+11    ,  0     ,  0            },   //Hf185 
{  731560,  0       ,  1.4427e+07     ,  0     ,  0            },   //Ta156 
{  731570,  0       ,  7.64629e+06    ,  0     ,  0            },   //Ta157 
{  731580,  0       ,  5.30912e+07    ,  0     ,  0            },   //Ta158 
{  731590,  0       ,  8.22336e+08    ,  0     ,  0            },   //Ta159 
{  731600,  0       ,  2.23618e+09    ,  0     ,  0            },   //Ta160 
{  731610,  0       ,  3.89528e+09    ,  0     ,  0            },   //Ta161 
{  731620,  0       ,  5.07829e+09    ,  0     ,  0            },   //Ta162 
{  731630,  0       ,  1.52926e+10    ,  0     ,  0            },   //Ta163 
{  731640,  0       ,  2.04863e+10    ,  0     ,  0            },   //Ta164 
{  731650,  0       ,  4.47236e+10    ,  0     ,  0            },   //Ta165 
{  731660,  0       ,  4.96287e+10    ,  0     ,  0            },   //Ta166 
{  731670,  0       ,  1.21186e+11    ,  0     ,  0            },   //Ta167 
{  731680,  0       ,  1.73123e+11    ,  0     ,  0            },   //Ta168 
{  731690,  0       ,  4.24152e+11    ,  0     ,  0            },   //Ta169 
{  731700,  0       ,  5.85157e+11    ,  0     ,  0            },   //Ta170 
{  731710,  0       ,  2.01689e+12    ,  0     ,  0            },   //Ta171 
{  731720,  0       ,  3.18547e+12    ,  0     ,  0            },   //Ta172 
{  731730,  0       ,  1.63025e+13    ,  5     ,  8.60148e-27  },   //Ta173 
{  731740,  0       ,  5.45339e+12    ,  0     ,  0            },   //Ta174 
{  731750,  0       ,  5.45339e+13    ,  7     ,  1.14653e-26  },   //Ta175 
{  731760,  0       ,  4.20113e+13    ,  0     ,  0            },   //Ta176 
{  731761,  103     ,  1.58696e+06    ,  0     ,  0            },   //Ta176 
{  731762,  1372.6  ,  5482.24        ,  0     ,  0            },   //Ta176 
{  731763,  2774    ,  2.01977e+06    ,  0     ,  0            },   //Ta176 
{  731764,  2774.8  ,  1.39941e+06    ,  0     ,  0            },   //Ta176 
{  731770,  0       ,  2.93733e+14    ,  7     ,  1.13643e-26  },   //Ta177 
{  731771,  186.1   ,  5193.7         ,  0     ,  0            },   //Ta177 
{  731772,  1355.4  ,  7242.33        ,  0     ,  0            },   //Ta177 
{  731780,  0       ,  8.0589e+11     ,  2     ,  1.38391e-26  },   //Ta178 
{  731781,  1470.6  ,  8.65617e+07    ,  0     ,  0            },   //Ta178 
{  731790,  0       ,  8.28684e+16    ,  0     ,  0            },   //Ta179 
{  731791,  30.7    ,  2048.63        ,  0     ,  0            },   //Ta179 
{  731792,  1317.3  ,  1.29843e+07    ,  0     ,  0            },   //Ta179 
{  731793,  1318    ,  1.29843e+07    ,  0     ,  0            },   //Ta179 
{  731794,  1327.9  ,  2308.31        ,  0     ,  0            },   //Ta179 
{  731795,  2639.3  ,  7.80498e+07    ,  0     ,  0            },   //Ta179 
{  731796,  2640.9  ,  7.50202e+07    ,  0     ,  0            },   //Ta179 
{  731800,  0       ,  4.23431e+13    ,  0     ,  0            },   //Ta180 
{  731801,  75.3    ,  5.46349e+31    ,  0     ,  0            },   //Ta180 
{  731810,  0       ,  -1             ,  7     ,  1.19729e-26  },   //Ta181 
{  731811,  6.238   ,  8728.31        ,  0     ,  0            },   //Ta181 
{  731812,  615.21  ,  25968.5        ,  0     ,  0            },   //Ta181 
{  731813,  6238    ,  -1             ,  9     ,  2.66681e-26  },   //Ta181 
{  731820,  0       ,  1.42639e+16    ,  6     ,  1.52534e-26  },   //Ta182 
{  731821,  16.263  ,  4.08283e+08    ,  0     ,  0            },   //Ta182 
{  731822,  519.572 ,  1.37114e+12    ,  0     ,  0            },   //Ta182 
{  731830,  0       ,  6.35652e+14    ,  7     ,  1.19198e-26  },   //Ta183 
{  731840,  0       ,  4.51852e+13    ,  0     ,  0            },   //Ta184 
{  731850,  0       ,  4.27615e+12    ,  0     ,  0            },   //Ta185 
{  731860,  0       ,  9.08898e+11    ,  0     ,  0            },   //Ta186 
{  741580,  0       ,  1.29843e+06    ,  0     ,  0            },   //W158  
{  741590,  0       ,  1.05317e+07    ,  0     ,  0            },   //W159  
{  741600,  0       ,  1.31285e+08    ,  0     ,  0            },   //W160  
{  741610,  0       ,  5.91505e+08    ,  0     ,  0            },   //W161  
{  741620,  0       ,  2.00535e+09    ,  0     ,  0            },   //W162  
{  741630,  0       ,  3.96741e+09    ,  0     ,  0            },   //W163  
{  741640,  0       ,  8.65617e+09    ,  0     ,  0            },   //W164  
{  741650,  0       ,  7.35775e+09    ,  0     ,  0            },   //W165  
{  741660,  0       ,  2.71227e+10    ,  0     ,  0            },   //W166  
{  741670,  0       ,  2.87096e+10    ,  0     ,  0            },   //W167  
{  741680,  0       ,  7.35775e+10    ,  0     ,  0            },   //W168  
{  741690,  0       ,  1.09645e+11    ,  0     ,  0            },   //W169  
{  741700,  0       ,  2.09479e+11    ,  0     ,  0            },   //W170  
{  741710,  0       ,  2.06017e+11    ,  0     ,  0            },   //W171  
{  741720,  0       ,  5.71307e+11    ,  0     ,  0            },   //W172  
{  741730,  0       ,  6.57869e+11    ,  0     ,  0            },   //W173  
{  741740,  0       ,  2.68341e+12    ,  0     ,  0            },   //W174  
{  741750,  0       ,  3.04697e+12    ,  0     ,  0            },   //W175  
{  741760,  0       ,  1.29843e+13    ,  0     ,  0            },   //W176  
{  741770,  0       ,  1.16858e+13    ,  0     ,  0            },   //W177  
{  741780,  0       ,  2.69207e+15    ,  0     ,  0            },   //W178  
{  741790,  0       ,  3.20711e+12    ,  0     ,  0            },   //W179  
{  741791,  221.926 ,  5.53995e+11    ,  0     ,  0            },   //W179  
{  741792,  3348.45 ,  1082.02        ,  0     ,  0            },   //W179  
{  741801,  1529.04 ,  7.89154e+06    ,  0     ,  0            },   //W180  
{  741802,  3264.8  ,  3606.74        ,  0     ,  0            },   //W180  
{  741810,  0       ,  1.5105e+16     ,  0     ,  0            },   //W181  
{  741811,  365.57  ,  20919.1        ,  0     ,  0            },   //W181  
{  741821,  2230.9  ,  2019.77        ,  0     ,  0            },   //W182  
{  741830,  0       ,  5.0076e+33     ,  1     ,  5.94907e-28  },   //W183  
{  741831,  309.493 ,  7.50202e+09    ,  0     ,  0            },   //W183  
{  741840,  0       ,  1.3658e+34     ,  0     ,  0            },   //W184  
{  741841,  1284.99 ,  12017.7        ,  0     ,  0            },   //W184  
{  741850,  0       ,  9.36165e+15    ,  0     ,  0            },   //W185  
{  741851,  197.43  ,  1.44558e+11    ,  0     ,  0            },   //W185  
{  741861,  1517.2  ,  25968.5        ,  0     ,  0            },   //W186  
{  741862,  3542.8  ,  4.32809e+06    ,  0     ,  0            },   //W186  
{  741870,  0       ,  1.23192e+14    ,  3     ,  3.13654e-27  },   //W187  
{  741880,  0       ,  8.6504e+15     ,  0     ,  0            },   //W188  
{  741890,  0       ,  9.9546e+11     ,  0     ,  0            },   //W189  
{  741900,  0       ,  2.59685e+12    ,  0     ,  0            },   //W190  
{  751600,  0       ,  1.13973e+06    ,  0     ,  0            },   //Re160 
{  751610,  0       ,  1.4427e+07     ,  0     ,  0            },   //Re161 
{  751620,  0       ,  1.4427e+08     ,  0     ,  0            },   //Re162 
{  751630,  0       ,  3.75101e+08    ,  0     ,  0            },   //Re163 
{  751640,  0       ,  1.26957e+09    ,  0     ,  0            },   //Re164 
{  751650,  0       ,  3.46247e+09    ,  0     ,  0            },   //Re165 
{  751660,  0       ,  4.03955e+09    ,  0     ,  0            },   //Re166 
{  751670,  0       ,  8.80044e+09    ,  0     ,  0            },   //Re167 
{  751680,  0       ,  6.34786e+09    ,  0     ,  0            },   //Re168 
{  751690,  0       ,  1.86108e+10    ,  0     ,  0            },   //Re169 
{  751700,  0       ,  1.32728e+10    ,  0     ,  0            },   //Re170 
{  751710,  0       ,  2.1929e+10     ,  0     ,  0            },   //Re171 
{  751720,  0       ,  2.16404e+10    ,  0     ,  0            },   //Re172 
{  751730,  0       ,  1.71392e+11    ,  0     ,  0            },   //Re173 
{  751740,  0       ,  2.07748e+11    ,  0     ,  0            },   //Re174 
{  751750,  0       ,  5.09849e+11    ,  0     ,  0            },   //Re175 
{  751760,  0       ,  4.58777e+11    ,  0     ,  0            },   //Re176 
{  751770,  0       ,  1.21186e+12    ,  0     ,  0            },   //Re177 
{  751771,  84.7    ,  72134.8        ,  0     ,  0            },   //Re177 
{  751780,  0       ,  1.14261e+12    ,  0     ,  0            },   //Re178 
{  751790,  0       ,  1.68795e+12    ,  5     ,  1.41422e-26  },   //Re179 
{  751791,  65.39   ,  137056         ,  0     ,  0            },   //Re179 
{  751800,  0       ,  2.11211e+11    ,  0     ,  0            },   //Re180 
{  751810,  0       ,  1.03355e+14    ,  5     ,  1.6112e-26   },   //Re181 
{  751811,  1656.7  ,  2885.39        ,  0     ,  0            },   //Re181 
{  751812,  1881.1  ,  16446.7        ,  0     ,  0            },   //Re181 
{  751820,  0       ,  3.32397e+14    ,  4     ,  1.43442e-26  },   //Re182 
{  751821,  461.3   ,  1125.3         ,  0     ,  0            },   //Re182 
{  751830,  0       ,  8.72542e+15    ,  5     ,  1.60009e-26  },   //Re183 
{  751831,  1907.6  ,  1.5004e+06     ,  0     ,  0            },   //Re183 
{  751840,  0       ,  4.73637e+15    ,  6     ,  1.27785e-26  },   //Re184 
{  751841,  188.01  ,  2.10634e+16    ,  0     ,  0            },   //Re184 
{  751850,  0       ,  -1             ,  5     ,  1.60974e-26  },   //Re185 
{  751860,  0       ,  4.70752e+14    ,  2     ,  8.78331e-27  },   //Re186 
{  751861,  149     ,  9.10629e+21    ,  0     ,  0            },   //Re186 
{  751870,  0       ,  1.98082e+27    ,  5     ,  1.6262e-26   },   //Re187 
{  751880,  0       ,  8.8192e+13     ,  2     ,  9.0308e-27   },   //Re188 
{  751881,  172.069 ,  1.61005e+12    ,  0     ,  0            },   //Re188 
{  751890,  0       ,  1.26207e+14    ,  0     ,  0            },   //Re189 
{  751900,  0       ,  2.68341e+11    ,  0     ,  0            },   //Re190 
{  751901,  119.12  ,  1.66199e+13    ,  0     ,  0            },   //Re190 
{  751910,  0       ,  8.48305e+11    ,  0     ,  0            },   //Re191 
{  751920,  0       ,  2.30831e+10    ,  0     ,  0            },   //Re192 
{  761620,  0       ,  2.74112e+06    ,  0     ,  0            },   //Os162 
{  761640,  0       ,  5.91505e+07    ,  0     ,  0            },   //Os164 
{  761650,  0       ,  9.37752e+07    ,  0     ,  0            },   //Os165 
{  761660,  0       ,  2.61128e+08    ,  0     ,  0            },   //Os166 
{  761670,  0       ,  1.19744e+09    ,  0     ,  0            },   //Os167 
{  761680,  0       ,  3.17393e+09    ,  0     ,  0            },   //Os168 
{  761690,  0       ,  4.90516e+09    ,  0     ,  0            },   //Os169 
{  761700,  0       ,  1.05317e+10    ,  0     ,  0            },   //Os170 
{  761710,  0       ,  1.15416e+10    ,  0     ,  0            },   //Os171 
{  761720,  0       ,  2.76998e+10    ,  0     ,  0            },   //Os172 
{  761730,  0       ,  2.30831e+10    ,  0     ,  0            },   //Os173 
{  761740,  0       ,  6.34786e+10    ,  0     ,  0            },   //Os174 
{  761750,  0       ,  1.21186e+11    ,  0     ,  0            },   //Os175 
{  761760,  0       ,  3.11622e+11    ,  0     ,  0            },   //Os176 
{  761770,  0       ,  2.42373e+11    ,  0     ,  0            },   //Os177 
{  761780,  0       ,  4.32809e+11    ,  0     ,  0            },   //Os178 
{  761790,  0       ,  5.62651e+11    ,  0     ,  0            },   //Os179 
{  761791,  145.41  ,  1038.74        ,  0     ,  0            },   //Os179 
{  761792,  243     ,  1630.25        ,  0     ,  0            },   //Os179 
{  761800,  0       ,  1.86108e+12    ,  0     ,  0            },   //Os180 
{  761810,  0       ,  9.08898e+12    ,  0     ,  0            },   //Os181 
{  761811,  49      ,  2.33717e+11    ,  0     ,  0            },   //Os181 
{  761820,  0       ,  1.14781e+14    ,  0     ,  0            },   //Os182 
{  761821,  1831.5  ,  1.1253e+06     ,  0     ,  0            },   //Os182 
{  761830,  0       ,  6.75181e+13    ,  9     ,  0            },   //Os183 
{  761831,  170.71  ,  5.14177e+13    ,  0     ,  0            },   //Os183 
{  761840,  0       ,  2.54924e+30    ,  0     ,  0            },   //Os184 
{  761850,  0       ,  1.16671e+16    ,  0     ,  0            },   //Os185 
{  761851,  102.3   ,  4328.09        ,  0     ,  0            },   //Os185 
{  761852,  275.7   ,  1125.3         ,  0     ,  0            },   //Os185 
{  761860,  0       ,  9.10629e+31    ,  0     ,  0            },   //Os186 
{  761870,  0       ,  -1             ,  1     ,  3.26543e-28  },   //Os187 
{  761871,  257.17  ,  333263         ,  0     ,  0            },   //Os187 
{  761890,  0       ,  -1             ,  3     ,  3.33318e-27  },   //Os189 
{  761891,  30.814  ,  3.01235e+13    ,  0     ,  0            },   //Os189 
{  761901,  1705.4  ,  8.56961e+11    ,  0     ,  0            },   //Os190 
{  761910,  0       ,  1.92023e+15    ,  9     ,  1.27785e-26  },   //Os191 
{  761911,  74.382  ,  6.80375e+13    ,  0     ,  0            },   //Os191 
{  761921,  2015.39 ,  8.5119e+09     ,  0     ,  0            },   //Os192 
{  761930,  0       ,  1.58408e+14    ,  3     ,  3.78809e-27  },   //Os193 
{  761940,  0       ,  2.73102e+17    ,  0     ,  0            },   //Os194 
{  761950,  0       ,  5.62651e+11    ,  0     ,  0            },   //Os195 
{  761960,  0       ,  3.021e+12      ,  0     ,  0            },   //Os196 
{  771660,  0       ,  7.21348e+06    ,  0     ,  0            },   //Ir166 
{  771670,  0       ,  7.21348e+06    ,  0     ,  0            },   //Ir167 
{  771690,  0       ,  5.77078e+08    ,  0     ,  0            },   //Ir169 
{  771700,  0       ,  1.51483e+09    ,  0     ,  0            },   //Ir170 
{  771710,  0       ,  2.16404e+09    ,  0     ,  0            },   //Ir171 
{  771720,  0       ,  6.34786e+09    ,  0     ,  0            },   //Ir172 
{  771721,  139     ,  2.88539e+09    ,  0     ,  0            },   //Ir172 
{  771730,  0       ,  1.29843e+10    ,  0     ,  0            },   //Ir173 
{  771740,  0       ,  1.29843e+10    ,  0     ,  0            },   //Ir174 
{  771741,  193     ,  7.06921e+09    ,  0     ,  0            },   //Ir174 
{  771750,  0       ,  1.29843e+10    ,  0     ,  0            },   //Ir175 
{  771760,  0       ,  1.15416e+10    ,  0     ,  0            },   //Ir176 
{  771770,  0       ,  4.32809e+10    ,  0     ,  0            },   //Ir177 
{  771780,  0       ,  1.73123e+10    ,  0     ,  0            },   //Ir178 
{  771790,  0       ,  1.13973e+11    ,  0     ,  0            },   //Ir179 
{  771800,  0       ,  1.29843e+11    ,  0     ,  0            },   //Ir180 
{  771810,  0       ,  4.24152e+11    ,  0     ,  0            },   //Ir181 
{  771820,  0       ,  1.29843e+12    ,  0     ,  0            },   //Ir182 
{  771830,  0       ,  5.02058e+12    ,  0     ,  0            },   //Ir183 
{  771840,  0       ,  1.60428e+13    ,  10    ,  3.51535e-27  },   //Ir184 
{  771841,  225.65  ,  678067         ,  0     ,  0            },   //Ir184 
{  771850,  0       ,  7.47893e+13    ,  5     ,  1.31573e-26  },   //Ir185 
{  771860,  0       ,  8.64175e+13    ,  10    ,  1.9597e-26   },   //Ir186 
{  771870,  0       ,  5.45339e+13    ,  0     ,  0            },   //Ir187 
{  771871,  186.15  ,  4.37137e+07    ,  0     ,  0            },   //Ir187 
{  771880,  0       ,  2.15539e+14    ,  2     ,  1.52534e-27  },   //Ir188 
{  771881,  923.5   ,  6.05932e+06    ,  0     ,  0            },   //Ir188 
{  771890,  0       ,  1.64467e+15    ,  3     ,  6.56602e-28  },   //Ir189 
{  771891,  372.18  ,  1.91878e+07    ,  0     ,  0            },   //Ir189 
{  771892,  2333.3  ,  5.33797e+06    ,  0     ,  0            },   //Ir189 
{  771900,  0       ,  1.46866e+15    ,  8     ,  2.02031e-28  },   //Ir190 
{  771901,  26.3    ,  6.23244e+12    ,  0     ,  0            },   //Ir190 
{  771902,  148.7   ,  1.68795e+13    ,  0     ,  0            },   //Ir190 
{  771903,  175     ,  1.68795e+13    ,  0     ,  0            },   //Ir190 
{  771910,  0       ,  -1             ,  3     ,  7.61153e-28  },   //Ir191 
{  771911,  171.24  ,  7.12692e+09    ,  0     ,  0            },   //Ir191 
{  771912,  2047    ,  7.93482e+09    ,  0     ,  0            },   //Ir191 
{  771920,  0       ,  9.20295e+15    ,  8     ,  9.71771e-27  },   //Ir192 
{  771921,  56.74   ,  1.25515e+11    ,  0     ,  0            },   //Ir192 
{  771922,  155.16  ,  1.09731e+19    ,  0     ,  0            },   //Ir192 
{  771923,  168.14  ,  1.09645e+19    ,  0     ,  0            },   //Ir192 
{  771930,  0       ,  -1             ,  3     ,  8.26813e-28  },   //Ir193 
{  771931,  80.22   ,  1.31256e+15    ,  0     ,  0            },   //Ir193 
{  771940,  0       ,  1.00137e+14    ,  2     ,  1.96981e-27  },   //Ir194 
{  771941,  147.078 ,  4.59498e+07    ,  0     ,  0            },   //Ir194 
{  771942,  190     ,  2.13086e+16    ,  0     ,  0            },   //Ir194 
{  771950,  0       ,  1.29843e+13    ,  0     ,  0            },   //Ir195 
{  771951,  100     ,  1.97361e+13    ,  0     ,  0            },   //Ir195 
{  771960,  0       ,  7.50202e+10    ,  0     ,  0            },   //Ir196 
{  771961,  410     ,  7.27118e+12    ,  0     ,  0            },   //Ir196 
{  771970,  0       ,  5.02058e+11    ,  0     ,  0            },   //Ir197 
{  771971,  115     ,  7.70399e+11    ,  0     ,  0            },   //Ir197 
{  771980,  0       ,  1.15416e+10    ,  0     ,  0            },   //Ir198 
{  781690,  0       ,  3.60674e+06    ,  0     ,  0            },   //Pt169 
{  781700,  0       ,  8.65617e+06    ,  0     ,  0            },   //Pt170 
{  781710,  0       ,  3.60674e+07    ,  0     ,  0            },   //Pt171 
{  781720,  0       ,  1.5004e+08     ,  0     ,  0            },   //Pt172 
{  781730,  0       ,  4.93402e+08    ,  0     ,  0            },   //Pt173 
{  781740,  0       ,  1.29843e+09    ,  0     ,  0            },   //Pt174 
{  781750,  0       ,  3.63559e+09    ,  0     ,  0            },   //Pt175 
{  781760,  0       ,  9.13226e+09    ,  0     ,  0            },   //Pt176 
{  781770,  0       ,  1.58696e+10    ,  0     ,  0            },   //Pt177 
{  781771,  147.7   ,  3173.93        ,  0     ,  0            },   //Pt177 
{  781780,  0       ,  3.04409e+10    ,  0     ,  0            },   //Pt178 
{  781790,  0       ,  3.05851e+10    ,  0     ,  0            },   //Pt179 
{  781800,  0       ,  7.50202e+10    ,  0     ,  0            },   //Pt180 
{  781810,  0       ,  7.35775e+10    ,  0     ,  0            },   //Pt181 
{  781820,  0       ,  1.90436e+11    ,  0     ,  0            },   //Pt182 
{  781830,  0       ,  5.62651e+11    ,  1     ,  2.63146e-27  },   //Pt183 
{  781831,  34.5    ,  6.20359e+10    ,  0     ,  0            },   //Pt183 
{  781840,  0       ,  1.49752e+12    ,  0     ,  0            },   //Pt184 
{  781841,  1839.4  ,  1.45712e+06    ,  0     ,  0            },   //Pt184 
{  781842,  1843.8  ,  1.58696e+06    ,  0     ,  0            },   //Pt184 
{  781850,  0       ,  6.13723e+12    ,  9     ,  -4.19215e-27 },   //Pt185 
{  781860,  0       ,  1.03874e+13    ,  0     ,  0            },   //Pt186 
{  781870,  0       ,  1.22052e+13    ,  3     ,  -2.00516e-27 },   //Pt187 
{  781871,  174.4   ,  448678         ,  0     ,  0            },   //Pt187 
{  781880,  0       ,  1.27145e+15    ,  0     ,  0            },   //Pt188 
{  781890,  0       ,  5.64527e+13    ,  3     ,  2.19204e-27  },   //Pt189 
{  781891,  191.6   ,  206305         ,  0     ,  0            },   //Pt189 
{  781900,  0       ,  2.95897e+28    ,  0     ,  0            },   //Pt190 
{  781910,  0       ,  3.49277e+14    ,  3     ,  -2.52539e-27 },   //Pt191 
{  781911,  100.67  ,  1442.7         ,  0     ,  0            },   //Pt191 
{  781912,  149.04  ,  137056         ,  0     ,  0            },   //Pt191 
{  781930,  0       ,  2.27657e+18    ,  0     ,  0            },   //Pt193 
{  781931,  149.78  ,  5.39712e+14    ,  0     ,  0            },   //Pt193 
{  781950,  0       ,  -1             ,  1     ,  3.07855e-27  },   //Pt195 
{  781951,  259.3   ,  5.01048e+14    ,  0     ,  0            },   //Pt195 
{  781970,  0       ,  1.03311e+14    ,  1     ,  2.5759e-27   },   //Pt197 
{  781971,  399.59  ,  8.25943e+12    ,  0     ,  0            },   //Pt197 
{  781990,  0       ,  2.6661e+12     ,  0     ,  0            },   //Pt199 
{  781991,  424     ,  1.96207e+10    ,  0     ,  0            },   //Pt199 
{  782000,  0       ,  6.49213e+13    ,  0     ,  0            },   //Pt200 
{  782010,  0       ,  2.16404e+11    ,  0     ,  0            },   //Pt201 
{  782020,  0       ,  2.28523e+14    ,  0     ,  0            },   //Pt202 
{  791720,  0       ,  5.77078e+06    ,  0     ,  0            },   //Au172 
{  791730,  0       ,  8.5119e+07     ,  0     ,  0            },   //Au173 
{  791740,  0       ,  1.73123e+08    ,  0     ,  0            },   //Au174 
{  791750,  0       ,  2.88539e+08    ,  0     ,  0            },   //Au175 
{  791760,  0       ,  1.55811e+09    ,  0     ,  0            },   //Au176 
{  791770,  0       ,  1.70238e+09    ,  0     ,  0            },   //Au177 
{  791780,  0       ,  3.75101e+09    ,  0     ,  0            },   //Au178 
{  791790,  0       ,  1.02431e+10    ,  0     ,  0            },   //Au179 
{  791800,  0       ,  1.16858e+10    ,  0     ,  0            },   //Au180 
{  791810,  0       ,  1.64467e+10    ,  0     ,  0            },   //Au181 
{  791820,  0       ,  2.2506e+10     ,  0     ,  0            },   //Au182 
{  791830,  0       ,  6.05932e+10    ,  0     ,  0            },   //Au183 
{  791831,  73.3    ,  1442.7         ,  0     ,  0            },   //Au183 
{  791832,  230.6   ,  1442.7         ,  0     ,  0            },   //Au183 
{  791840,  0       ,  7.64629e+10    ,  0     ,  0            },   //Au184 
{  791850,  0       ,  3.67887e+11    ,  5     ,  1.09602e-26  },   //Au185 
{  791860,  0       ,  9.2621e+11     ,  6     ,  -6.36399e-27 },   //Au186 
{  791870,  0       ,  7.27118e+11    ,  1     ,  2.68197e-27  },   //Au187 
{  791871,  120.51  ,  3.3182e+09     ,  0     ,  0            },   //Au187 
{  791880,  0       ,  7.65206e+11    ,  2     ,  -3.38402e-28 },   //Au188 
{  791890,  0       ,  2.48432e+12    ,  1     ,  2.47488e-27  },   //Au189 
{  791891,  247.23  ,  3.97318e+11    ,  0     ,  0            },   //Au189 
{  791900,  0       ,  3.70484e+12    ,  2     ,  -3.28301e-28 },   //Au190 
{  791910,  0       ,  1.65189e+13    ,  3     ,  6.91957e-28  },   //Au191 
{  791911,  266.2   ,  1.32728e+09    ,  0     ,  0            },   //Au191 
{  791920,  0       ,  2.56511e+13    ,  2     ,  -4.5457e-29  },   //Au192 
{  791921,  135.4   ,  4.18382e+07    ,  0     ,  0            },   //Au192 
{  791922,  431.6   ,  2.30831e+08    ,  0     ,  0            },   //Au192 
{  791930,  0       ,  9.16689e+13    ,  3     ,  7.0711e-28   },   //Au193 
{  791931,  290.17  ,  5.62651e+09    ,  0     ,  0            },   //Au193 
{  791940,  0       ,  1.97505e+14    ,  2     ,  3.78809e-28  },   //Au194 
{  791941,  107.4   ,  8.65617e+08    ,  0     ,  0            },   //Au194 
{  791942,  475.8   ,  6.05932e+08    ,  0     ,  0            },   //Au194 
{  791950,  0       ,  2.31985e+16    ,  3     ,  7.52567e-28  },   //Au195 
{  791951,  318.58  ,  4.40022e+10    ,  0     ,  0            },   //Au195 
{  791960,  0       ,  7.70688e+14    ,  4     ,  2.98299e-27  },   //Au196 
{  791961,  84.66   ,  1.16858e+10    ,  0     ,  0            },   //Au196 
{  791962,  595.66  ,  4.98596e+13    ,  0     ,  0            },   //Au196 
{  791970,  0       ,  -1             ,  3     ,  7.36131e-28  },   //Au197 
{  791971,  409.15  ,  1.1152e+10     ,  0     ,  0            },   //Au197 
{  791980,  0       ,  3.36004e+14    ,  4     ,  2.99713e-27  },   //Au198 
{  791981,  811.7   ,  2.82913e+14    ,  0     ,  0            },   //Au198 
{  791990,  0       ,  3.91259e+14    ,  3     ,  1.37129e-27  },   //Au199 
{  791991,  548.937 ,  634786         ,  0     ,  0            },   //Au199 
{  792000,  0       ,  4.18959e+12    ,  0     ,  0            },   //Au200 
{  792001,  962     ,  9.71223e+13    ,  0     ,  0            },   //Au200 
{  792010,  0       ,  2.2506e+12     ,  0     ,  0            },   //Au201 
{  792020,  0       ,  4.15496e+10    ,  0     ,  0            },   //Au202 
{  792030,  0       ,  7.64629e+10    ,  0     ,  0            },   //Au203 
{  792040,  0       ,  5.74193e+10    ,  0     ,  0            },   //Au204 
{  792050,  0       ,  4.47236e+10    ,  0     ,  0            },   //Au205 
{  801750,  0       ,  2.88539e+07    ,  0     ,  0            },   //Hg175 
{  801760,  0       ,  4.90516e+07    ,  0     ,  0            },   //Hg176 
{  801770,  0       ,  1.8755e+08     ,  0     ,  0            },   //Hg177 
{  801780,  0       ,  3.66445e+08    ,  0     ,  0            },   //Hg178 
{  801790,  0       ,  1.57254e+09    ,  0     ,  0            },   //Hg179 
{  801800,  0       ,  4.03955e+09    ,  0     ,  0            },   //Hg180 
{  801810,  0       ,  5.1937e+09     ,  1     ,  2.56125e-27  },   //Hg181 
{  801820,  0       ,  1.56244e+10    ,  0     ,  0            },   //Hg182 
{  801830,  0       ,  1.35613e+10    ,  1     ,  2.64661e-27  },   //Hg183 
{  801840,  0       ,  4.41465e+10    ,  0     ,  0            },   //Hg184 
{  801850,  0       ,  7.08363e+10    ,  1     ,  2.5658e-27   },   //Hg185 
{  801851,  99.3    ,  3.11622e+10    ,  0     ,  0            },   //Hg185 
{  801860,  0       ,  1.19455e+11    ,  0     ,  0            },   //Hg186 
{  801861,  2217.3  ,  118301         ,  0     ,  0            },   //Hg186 
{  801870,  0       ,  2.07748e+11    ,  13    ,  -5.27302e-27 },   //Hg187 
{  801871,  134     ,  1.64467e+11    ,  0     ,  0            },   //Hg187 
{  801880,  0       ,  2.81326e+11    ,  0     ,  0            },   //Hg188 
{  801890,  0       ,  6.57869e+11    ,  3     ,  -5.34373e-27 },   //Hg189 
{  801900,  0       ,  1.73123e+12    ,  0     ,  0            },   //Hg190 
{  801910,  0       ,  4.24152e+12    ,  3     ,  -5.39424e-27 },   //Hg191 
{  801920,  0       ,  2.51895e+13    ,  0     ,  0            },   //Hg192 
{  801930,  0       ,  1.97361e+13    ,  3     ,  -3.16972e-27 },   //Hg193 
{  801931,  140.76  ,  6.12857e+13    ,  0     ,  0            },   //Hg193 
{  801940,  0       ,  2.02122e+19    ,  0     ,  0            },   //Hg194 
{  801950,  0       ,  5.14177e+13    ,  1     ,  2.73487e-27  },   //Hg195 
{  801951,  176.07  ,  2.16116e+14    ,  0     ,  0            },   //Hg195 
{  801970,  0       ,  3.33118e+14    ,  1     ,  2.66365e-27  },   //Hg197 
{  801971,  298.93  ,  1.2361e+14     ,  0     ,  0            },   //Hg197 
{  801990,  0       ,  -1             ,  1     ,  2.55512e-27  },   //Hg199 
{  801991,  532.48  ,  3.68753e+12    ,  0     ,  0            },   //Hg199 
{  802010,  0       ,  -1             ,  3     ,  -2.82958e-27 },   //Hg201 
{  802011,  766.22  ,  135613         ,  0     ,  0            },   //Hg201 
{  802030,  0       ,  5.80973e+15    ,  5     ,  4.28786e-27  },   //Hg203 
{  802031,  933.1   ,  34624.7        ,  0     ,  0            },   //Hg203 
{  802050,  0       ,  4.50121e+11    ,  1     ,  3.03552e-27  },   //Hg205 
{  802051,  1556.53 ,  1.58696e+06    ,  0     ,  0            },   //Hg205 
{  802060,  0       ,  7.05478e+11    ,  0     ,  0            },   //Hg206 
{  802061,  2102.6  ,  3101.8         ,  0     ,  0            },   //Hg206 
{  802070,  0       ,  2.51029e+11    ,  0     ,  0            },   //Hg207 
{  802080,  0       ,  3.63559e+12    ,  0     ,  0            },   //Hg208 
{  811790,  0       ,  2.30831e+08    ,  0     ,  0            },   //Tl179 
{  811800,  0       ,  1.00989e+09    ,  0     ,  0            },   //Tl180 
{  811820,  0       ,  4.47236e+09    ,  0     ,  0            },   //Tl182 
{  811831,  550     ,  8.65617e+07    ,  0     ,  0            },   //Tl183 
{  811832,  976.8   ,  2135.19        ,  0     ,  0            },   //Tl183 
{  811840,  0       ,  1.58696e+10    ,  0     ,  0            },   //Tl184 
{  811850,  0       ,  2.81326e+10    ,  0     ,  0            },   //Tl185 
{  811851,  454     ,  2.64013e+09    ,  0     ,  0            },   //Tl185 
{  811860,  0       ,  3.96741e+10    ,  0     ,  0            },   //Tl186 
{  811861,  374     ,  4.18382e+09    ,  0     ,  0            },   //Tl186 
{  811870,  0       ,  7.35775e+10    ,  0     ,  0            },   //Tl187 
{  811871,  335     ,  2.2506e+10     ,  0     ,  0            },   //Tl187 
{  811880,  0       ,  1.02431e+11    ,  14    ,  2.52539e-27  },   //Tl188 
{  811881,  268.8   ,  5.91505e+07    ,  0     ,  0            },   //Tl188 
{  811890,  0       ,  1.99092e+11    ,  0     ,  0            },   //Tl189 
{  811891,  281     ,  1.21186e+11    ,  0     ,  0            },   //Tl189 
{  811900,  0       ,  2.2506e+11     ,  4     ,  1.2627e-27   },   //Tl190 
{  811901,  161.9   ,  1.08202e+06    ,  0     ,  0            },   //Tl190 
{  811910,  0       ,  -1             ,  1     ,  8.02064e-27  },   //Tl191 
{  811911,  299     ,  4.51852e+11    ,  0     ,  0            },   //Tl191 
{  811920,  0       ,  8.30993e+11    ,  4     ,  1.01016e-27  },   //Tl192 
{  811930,  0       ,  1.86973e+12    ,  1     ,  8.03681e-27  },   //Tl193 
{  811931,  365.2   ,  1.82645e+11    ,  0     ,  0            },   //Tl193 
{  811940,  0       ,  2.85654e+12    ,  4     ,  7.0711e-28   },   //Tl194 
{  811950,  0       ,  6.0247e+12     ,  1     ,  7.98024e-27  },   //Tl195 
{  811951,  482.63  ,  5.1937e+09     ,  0     ,  0            },   //Tl195 
{  811960,  0       ,  9.55641e+12    ,  4     ,  3.53555e-28  },   //Tl196 
{  811961,  394.2   ,  7.32312e+12    ,  0     ,  0            },   //Tl196 
{  811970,  0       ,  1.47443e+13    ,  1     ,  7.98024e-27  },   //Tl197 
{  811971,  608.22  ,  7.79056e+08    ,  0     ,  0            },   //Tl197 
{  811980,  0       ,  2.75266e+13    ,  4     ,  0            },   //Tl198 
{  811981,  543.5   ,  9.71223e+12    ,  0     ,  0            },   //Tl198 
{  811982,  742.3   ,  4.63105e+07    ,  0     ,  0            },   //Tl198 
{  811990,  0       ,  3.85344e+13    ,  1     ,  8.08125e-27  },   //Tl199 
{  811991,  749.7   ,  4.09725e+07    ,  0     ,  0            },   //Tl199 
{  812000,  0       ,  1.35556e+14    ,  4     ,  2.02031e-28  },   //Tl200 
{  812001,  753.6   ,  4.94845e+07    ,  0     ,  0            },   //Tl200 
{  812010,  0       ,  3.78708e+14    ,  1     ,  8.10701e-27  },   //Tl201 
{  812011,  919.5   ,  2.93589e+06    ,  0     ,  0            },   //Tl201 
{  812020,  0       ,  1.52493e+15    ,  4     ,  3.03047e-28  },   //Tl202 
{  812021,  950.19  ,  825222         ,  0     ,  0            },   //Tl202 
{  812030,  0       ,  -1             ,  1     ,  8.19368e-27  },   //Tl203 
{  812040,  0       ,  1.72114e+17    ,  4     ,  4.5457e-28   },   //Tl204 
{  812041,  1104    ,  90889.8        ,  0     ,  0            },   //Tl204 
{  812050,  0       ,  -1             ,  1     ,  8.27424e-27  },   //Tl205 
{  812051,  3290.63 ,  3751.01        ,  0     ,  0            },   //Tl205 
{  812060,  0       ,  3.63415e+11    ,  0     ,  0            },   //Tl206 
{  812061,  2643.11 ,  3.23741e+11    ,  0     ,  0            },   //Tl206 
{  812070,  0       ,  4.12899e+11    ,  1     ,  9.47527e-27  },   //Tl207 
{  812071,  1348.1  ,  1.91878e+09    ,  0     ,  0            },   //Tl207 
{  812080,  0       ,  2.64302e+11    ,  0     ,  0            },   //Tl208 
{  812090,  0       ,  1.90436e+11    ,  0     ,  0            },   //Tl209 
{  812100,  0       ,  1.1253e+11     ,  0     ,  0            },   //Tl210 
{  821810,  0       ,  7.21348e+07    ,  0     ,  0            },   //Pb181 
{  821820,  0       ,  7.93482e+07    ,  0     ,  0            },   //Pb182 
{  821830,  0       ,  4.32809e+08    ,  0     ,  0            },   //Pb183 
{  821840,  0       ,  7.93482e+08    ,  0     ,  0            },   //Pb184 
{  821850,  0       ,  5.91505e+09    ,  0     ,  0            },   //Pb185 
{  821860,  0       ,  6.91051e+09    ,  0     ,  0            },   //Pb186 
{  821870,  0       ,  2.64013e+10    ,  0     ,  0            },   //Pb187 
{  821880,  0       ,  3.49132e+10    ,  0     ,  0            },   //Pb188 
{  821890,  0       ,  7.35775e+10    ,  0     ,  0            },   //Pb189 
{  821900,  0       ,  1.03874e+11    ,  0     ,  0            },   //Pb190 
{  821910,  0       ,  1.15127e+11    ,  0     ,  0            },   //Pb191 
{  821911,  138     ,  1.88705e+11    ,  0     ,  0            },   //Pb191 
{  821920,  0       ,  3.02966e+11    ,  0     ,  0            },   //Pb192 
{  821921,  2625.1  ,  1586.96        ,  0     ,  0            },   //Pb192 
{  821931,  100     ,  5.02058e+11    ,  0     ,  0            },   //Pb193 
{  821940,  0       ,  1.03874e+12    ,  0     ,  0            },   //Pb194 
{  821950,  0       ,  1.29843e+12    ,  0     ,  0            },   //Pb195 
{  821951,  203     ,  1.29843e+12    ,  0     ,  0            },   //Pb195 
{  821952,  1759    ,  14427          ,  0     ,  0            },   //Pb195 
{  821960,  0       ,  3.20278e+12    ,  0     ,  0            },   //Pb196 
{  821961,  1738.27 ,  1442.7         ,  0     ,  0            },   //Pb196 
{  821970,  0       ,  6.92494e+11    ,  3     ,  -5.43111e-27 },   //Pb197 
{  821971,  319.31  ,  3.72215e+12    ,  0     ,  0            },   //Pb197 
{  821972,  1914.1  ,  1659.1         ,  0     ,  0            },   //Pb197 
{  821980,  0       ,  1.24649e+13    ,  0     ,  0            },   //Pb198 
{  821981,  2141.4  ,  6044.89        ,  0     ,  0            },   //Pb198 
{  821990,  0       ,  7.79056e+12    ,  3     ,  -5.42555e-27 },   //Pb199 
{  821991,  424.8   ,  1.05605e+12    ,  0     ,  0            },   //Pb199 
{  821992,  430     ,  1.05605e+12    ,  0     ,  0            },   //Pb199 
{  821993,  2559.1  ,  14571.2        ,  0     ,  0            },   //Pb199 
{  822000,  0       ,  1.11665e+14    ,  0     ,  0            },   //Pb200 
{  822010,  0       ,  4.84601e+13    ,  5     ,  3.41079e-27  },   //Pb201 
{  822011,  629.14  ,  8.80044e+10    ,  0     ,  0            },   //Pb201 
{  822020,  0       ,  2.39055e+21    ,  0     ,  0            },   //Pb202 
{  822021,  2169.84 ,  1.83367e+13    ,  0     ,  0            },   //Pb202 
{  822030,  0       ,  2.69351e+14    ,  5     ,  3.46686e-27  },   //Pb203 
{  822031,  825.2   ,  9.08898e+09    ,  0     ,  0            },   //Pb203 
{  822032,  2949.47 ,  6.92494e+08    ,  0     ,  0            },   //Pb203 
{  822040,  0       ,  6.37383e+33    ,  0     ,  0            },   //Pb204 
{  822041,  2185.79 ,  5.81695e+12    ,  0     ,  0            },   //Pb204 
{  822050,  0       ,  6.96533e+23    ,  5     ,  3.59464e-27  },   //Pb205 
{  822051,  1013.84 ,  7.99253e+06    ,  0     ,  0            },   //Pb205 
{  822061,  2200.14 ,  180337         ,  0     ,  0            },   //Pb206 
{  822070,  0       ,  -1             ,  1     ,  2.99301e-27  },   //Pb207 
{  822071,  1633.37 ,  1.16137e+09    ,  0     ,  0            },   //Pb207 
{  822090,  0       ,  1.6894e+13     ,  9     ,  -7.44233e-27 },   //Pb209 
{  822100,  0       ,  1.01522e+18    ,  0     ,  0            },   //Pb210 
{  822110,  0       ,  3.12488e+12    ,  9     ,  -7.08978e-27 },   //Pb211 
{  822120,  0       ,  5.52552e+13    ,  0     ,  0            },   //Pb212 
{  822130,  0       ,  8.8293e+11     ,  0     ,  0            },   //Pb213 
{  822140,  0       ,  2.31985e+12    ,  0     ,  0            },   //Pb214 
{  831850,  0       ,  63478.6        ,  0     ,  0            },   //Bi185 
{  831870,  0       ,  5.04943e+07    ,  0     ,  0            },   //Bi187 
{  831880,  0       ,  3.02966e+08    ,  0     ,  0            },   //Bi188 
{  831890,  0       ,  9.81033e+08    ,  0     ,  0            },   //Bi189 
{  831891,  92      ,  7.21348e+06    ,  0     ,  0            },   //Bi189 
{  831900,  0       ,  9.08898e+09    ,  0     ,  0            },   //Bi190 
{  831910,  0       ,  1.73123e+10    ,  0     ,  0            },   //Bi191 
{  831911,  242     ,  2.16404e+08    ,  0     ,  0            },   //Bi191 
{  831920,  0       ,  5.33797e+10    ,  0     ,  0            },   //Bi192 
{  831921,  105     ,  5.71307e+10    ,  0     ,  0            },   //Bi192 
{  831930,  0       ,  9.66606e+10    ,  0     ,  0            },   //Bi193 
{  831931,  307     ,  4.61663e+09    ,  0     ,  0            },   //Bi193 
{  831940,  0       ,  1.37056e+11    ,  0     ,  0            },   //Bi194 
{  831950,  0       ,  2.64013e+11    ,  0     ,  0            },   //Bi195 
{  831951,  401     ,  1.25515e+11    ,  0     ,  0            },   //Bi195 
{  831960,  0       ,  4.4435e+11     ,  0     ,  0            },   //Bi196 
{  831961,  167     ,  8.65617e+08    ,  0     ,  0            },   //Bi196 
{  831962,  269     ,  3.46247e+11    ,  0     ,  0            },   //Bi196 
{  831970,  0       ,  8.07621e+11    ,  0     ,  0            },   //Bi197 
{  831971,  500     ,  4.36271e+11    ,  0     ,  0            },   //Bi197 
{  831980,  0       ,  8.91586e+11    ,  0     ,  0            },   //Bi198 
{  831981,  248.5   ,  1.11088e+10    ,  0     ,  0            },   //Bi198 
{  831990,  0       ,  2.33717e+12    ,  9     ,  2.32336e-26  },   //Bi199 
{  831991,  680     ,  2.13807e+12    ,  0     ,  0            },   //Bi199 
{  832000,  0       ,  3.15085e+12    ,  0     ,  0            },   //Bi200 
{  832001,  428.2   ,  5.77078e+08    ,  0     ,  0            },   //Bi200 
{  832010,  0       ,  9.34867e+12    ,  0     ,  0            },   //Bi201 
{  832011,  846.34  ,  5.1158e+12     ,  0     ,  0            },   //Bi201 
{  832020,  0       ,  8.93317e+12    ,  0     ,  0            },   //Bi202 
{  832021,  615     ,  4385.79        ,  0     ,  0            },   //Bi202 
{  832030,  0       ,  6.10837e+13    ,  9     ,  2.33346e-26  },   //Bi203 
{  832031,  1098.14 ,  4.37137e+08    ,  0     ,  0            },   //Bi203 
{  832040,  0       ,  5.82705e+13    ,  12    ,  2.16174e-26  },   //Bi204 
{  832041,  805.5   ,  1.8755e+07     ,  0     ,  0            },   //Bi204 
{  832042,  2833.4  ,  1.54368e+06    ,  0     ,  0            },   //Bi204 
{  832050,  0       ,  1.90869e+15    ,  9     ,  2.10113e-26  },   //Bi205 
{  832051,  1497.17 ,  11397.3        ,  0     ,  0            },   //Bi205 
{  832060,  0       ,  7.7819e+14     ,  12    ,  2.32336e-26  },   //Bi206 
{  832061,  59.897  ,  11108.8        ,  0     ,  0            },   //Bi206 
{  832062,  1044.8  ,  1.284e+06      ,  0     ,  0            },   //Bi206 
{  832070,  0       ,  1.43649e+18    ,  9     ,  2.06122e-26  },   //Bi207 
{  832071,  2101.49 ,  262571         ,  0     ,  0            },   //Bi207 
{  832080,  0       ,  1.67497e+22    ,  0     ,  0            },   //Bi208 
{  832081,  1571.1  ,  3.72215e+06    ,  0     ,  0            },   //Bi208 
{  832090,  0       ,  -1             ,  9     ,  2.07617e-26  },   //Bi209 
{  832100,  0       ,  6.24831e+14    ,  2     ,  -2.2481e-28  },   //Bi210 
{  832101,  271.31  ,  1.38412e+23    ,  0     ,  0            },   //Bi210 
{  832110,  0       ,  1.85242e+11    ,  0     ,  0            },   //Bi211 
{  832120,  0       ,  5.24131e+12    ,  0     ,  0            },   //Bi212 
{  832121,  250     ,  2.16404e+12    ,  0     ,  0            },   //Bi212 
{  832122,  1910    ,  6.05932e+11    ,  0     ,  0            },   //Bi212 
{  832130,  0       ,  3.94577e+12    ,  0     ,  0            },   //Bi213 
{  832140,  0       ,  1.72258e+12    ,  0     ,  0            },   //Bi214 
{  832150,  0       ,  6.57869e+11    ,  0     ,  0            },   //Bi215 
{  832151,  1347.5  ,  5.25141e+10    ,  0     ,  0            },   //Bi215 
{  832160,  0       ,  3.11622e+11    ,  0     ,  0            },   //Bi216 
{  841910,  0       ,  2.23618e+07    ,  0     ,  0            },   //Po191 
{  841920,  0       ,  4.90516e+07    ,  0     ,  0            },   //Po192 
{  841930,  0       ,  5.1937e+08     ,  0     ,  0            },   //Po193 
{  841940,  0       ,  5.65537e+08    ,  0     ,  0            },   //Po194 
{  841950,  0       ,  6.69411e+09    ,  0     ,  0            },   //Po195 
{  841951,  230     ,  2.76998e+09    ,  0     ,  0            },   //Po195 
{  841960,  0       ,  8.36763e+09    ,  0     ,  0            },   //Po196 
{  841961,  2492    ,  1226.29        ,  0     ,  0            },   //Po196 
{  841970,  0       ,  7.73285e+10    ,  0     ,  0            },   //Po197 
{  841971,  204     ,  3.72215e+10    ,  0     ,  0            },   //Po197 
{  841980,  0       ,  1.52349e+11    ,  0     ,  0            },   //Po198 
{  841990,  0       ,  4.74358e+11    ,  0     ,  0            },   //Po199 
{  841991,  310     ,  3.575e+11      ,  0     ,  0            },   //Po199 
{  842000,  0       ,  9.9546e+11     ,  0     ,  0            },   //Po200 
{  842010,  0       ,  1.32439e+12    ,  3     ,  3.73758e-27  },   //Po201 
{  842011,  424     ,  7.70399e+11    ,  0     ,  0            },   //Po201 
{  842020,  0       ,  3.86931e+12    ,  0     ,  0            },   //Po202 
{  842030,  0       ,  3.17682e+12    ,  5     ,  3.74768e-27  },   //Po203 
{  842031,  641.49  ,  6.49213e+10    ,  0     ,  0            },   //Po203 
{  842040,  0       ,  1.83367e+13    ,  0     ,  0            },   //Po204 
{  842050,  0       ,  8.62155e+12    ,  5     ,  3.8386e-27   },   //Po205 
{  842051,  880.3   ,  930539         ,  0     ,  0            },   //Po205 
{  842052,  1461.2  ,  8.36763e+07    ,  0     ,  0            },   //Po205 
{  842060,  0       ,  1.09688e+15    ,  0     ,  0            },   //Po206 
{  842061,  2262.22 ,  1514.83        ,  0     ,  0            },   //Po206 
{  842070,  0       ,  3.01235e+13    ,  5     ,  4.00527e-27  },   //Po207 
{  842071,  1115.07 ,  70692.1        ,  0     ,  0            },   //Po207 
{  842072,  1383.2  ,  4.03955e+09    ,  0     ,  0            },   //Po207 
{  842080,  0       ,  1.31949e+17    ,  0     ,  0            },   //Po208 
{  842090,  0       ,  4.64404e+18    ,  1     ,  3.8891e-27   },   //Po209 
{  842100,  0       ,  1.72546e+16    ,  0     ,  0            },   //Po210 
{  842110,  0       ,  7.44431e+08    ,  0     ,  0            },   //Po211 
{  842111,  1462    ,  3.63559e+10    ,  0     ,  0            },   //Po211 
{  842121,  2922    ,  6.50656e+10    ,  0     ,  0            },   //Po212 
{  842130,  0       ,  6059.32        ,  0     ,  0            },   //Po213 
{  842140,  0       ,  237035         ,  0     ,  0            },   //Po214 
{  842150,  0       ,  2.56944e+06    ,  0     ,  0            },   //Po215 
{  842160,  0       ,  2.09191e+08    ,  0     ,  0            },   //Po216 
{  842170,  0       ,  1.4427e+10     ,  0     ,  0            },   //Po217 
{  842180,  0       ,  2.68341e+11    ,  0     ,  0            },   //Po218 
{  851930,  0       ,  5.77078e+07    ,  0     ,  0            },   //At193 
{  851940,  0       ,  5.77078e+07    ,  0     ,  0            },   //At194 
{  851960,  0       ,  4.32809e+08    ,  0     ,  0            },   //At196 
{  851970,  0       ,  5.04943e+08    ,  0     ,  0            },   //At197 
{  851971,  52      ,  5.33797e+09    ,  0     ,  0            },   //At197 
{  851980,  0       ,  6.05932e+09    ,  0     ,  0            },   //At198 
{  851981,  102     ,  1.4427e+09     ,  0     ,  0            },   //At198 
{  851990,  0       ,  1.03874e+10    ,  0     ,  0            },   //At199 
{  852000,  0       ,  6.20359e+10    ,  0     ,  0            },   //At200 
{  852001,  104     ,  6.78067e+10    ,  0     ,  0            },   //At200 
{  852002,  335     ,  5.04943e+09    ,  0     ,  0            },   //At200 
{  852010,  0       ,  1.284e+11      ,  0     ,  0            },   //At201 
{  852020,  0       ,  2.65456e+11    ,  0     ,  0            },   //At202 
{  852021,  391.7   ,  6.6364e+08     ,  0     ,  0            },   //At202 
{  852022,  392     ,  6.6364e+08     ,  0     ,  0            },   //At202 
{  852030,  0       ,  6.40557e+11    ,  0     ,  0            },   //At203 
{  852040,  0       ,  7.96368e+11    ,  0     ,  0            },   //At204 
{  852041,  587.3   ,  1.55811e+08    ,  0     ,  0            },   //At204 
{  852050,  0       ,  2.26792e+12    ,  0     ,  0            },   //At205 
{  852051,  2339.6  ,  11253          ,  0     ,  0            },   //At205 
{  852060,  0       ,  2.59685e+12    ,  0     ,  0            },   //At206 
{  852070,  0       ,  9.34867e+12    ,  0     ,  0            },   //At207 
{  852080,  0       ,  8.46574e+12    ,  0     ,  0            },   //At208 
{  852081,  2275.8  ,  2164.04        ,  0     ,  0            },   //At208 
{  852090,  0       ,  2.81037e+13    ,  0     ,  0            },   //At209 
{  852091,  2429.25 ,  1284           ,  0     ,  0            },   //At209 
{  852100,  0       ,  4.2069e+13     ,  0     ,  0            },   //At210 
{  852101,  4027.7  ,  8511.9         ,  0     ,  0            },   //At210 
{  852110,  0       ,  3.74668e+13    ,  0     ,  0            },   //At211 
{  852111,  4816.2  ,  6059.32        ,  0     ,  0            },   //At211 
{  852120,  0       ,  4.53006e+08    ,  0     ,  0            },   //At212 
{  852121,  222     ,  1.71681e+08    ,  0     ,  0            },   //At212 
{  852150,  0       ,  144270         ,  0     ,  0            },   //At215 
{  852160,  0       ,  432809         ,  0     ,  0            },   //At216 
{  852170,  0       ,  4.65991e+07    ,  0     ,  0            },   //At217 
{  852180,  0       ,  2.16404e+09    ,  0     ,  0            },   //At218 
{  852190,  0       ,  8.07909e+10    ,  0     ,  0            },   //At219 
{  852200,  0       ,  3.21144e+11    ,  0     ,  0            },   //At220 
{  852210,  0       ,  1.99092e+11    ,  0     ,  0            },   //At221 
{  852220,  0       ,  7.79056e+10    ,  0     ,  0            },   //At222 
{  852230,  0       ,  7.21348e+10    ,  0     ,  0            },   //At223 
{  861960,  0       ,  4.32809e+06    ,  0     ,  0            },   //Rn196 
{  861970,  0       ,  9.37752e+07    ,  0     ,  0            },   //Rn197 
{  861980,  0       ,  9.23325e+07    ,  0     ,  0            },   //Rn198 
{  861990,  0       ,  8.94471e+08    ,  0     ,  0            },   //Rn199 
{  862000,  0       ,  1.52926e+09    ,  0     ,  0            },   //Rn200 
{  862010,  0       ,  1.00989e+10    ,  0     ,  0            },   //Rn201 
{  862011,  280     ,  5.48224e+09    ,  0     ,  0            },   //Rn201 
{  862020,  0       ,  1.42105e+10    ,  0     ,  0            },   //Rn202 
{  862030,  0       ,  6.49213e+10    ,  0     ,  0            },   //Rn203 
{  862031,  361     ,  4.03955e+10    ,  0     ,  0            },   //Rn203 
{  862040,  0       ,  1.07337e+11    ,  0     ,  0            },   //Rn204 
{  862050,  0       ,  2.42373e+11    ,  5     ,  4.05073e-27  },   //Rn205 
{  862060,  0       ,  4.90805e+11    ,  0     ,  0            },   //Rn206 
{  862070,  0       ,  8.00696e+11    ,  5     ,  4.12144e-27  },   //Rn207 
{  862071,  899     ,  261128         ,  0     ,  0            },   //Rn207 
{  862080,  0       ,  2.10778e+12    ,  0     ,  0            },   //Rn208 
{  862090,  0       ,  2.46701e+12    ,  5     ,  4.23665e-27  },   //Rn209 
{  862091,  1173.98 ,  19332.1        ,  0     ,  0            },   //Rn209 
{  862092,  3636.78 ,  4328.09        ,  0     ,  0            },   //Rn209 
{  862100,  0       ,  1.24649e+13    ,  0     ,  0            },   //Rn210 
{  862101,  3812    ,  1529.26        ,  0     ,  0            },   //Rn210 
{  862102,  6468.3  ,  1500.4         ,  0     ,  0            },   //Rn210 
{  862110,  0       ,  7.58281e+13    ,  1     ,  3.03552e-27  },   //Rn211 
{  862120,  0       ,  2.06883e+12    ,  0     ,  0            },   //Rn212 
{  862121,  1694    ,  1312.85        ,  0     ,  0            },   //Rn212 
{  862130,  0       ,  3.60674e+07    ,  0     ,  0            },   //Rn213 
{  862131,  2186.7  ,  1962.07        ,  0     ,  0            },   //Rn213 
{  862150,  0       ,  3318.2         ,  0     ,  0            },   //Rn215 
{  862160,  0       ,  64921.3        ,  0     ,  0            },   //Rn216 
{  862170,  0       ,  779056         ,  0     ,  0            },   //Rn217 
{  862180,  0       ,  5.04943e+07    ,  0     ,  0            },   //Rn218 
{  862190,  0       ,  5.71307e+09    ,  5     ,  -2.23245e-27 },   //Rn219 
{  862200,  0       ,  8.02139e+10    ,  0     ,  0            },   //Rn220 
{  862210,  0       ,  2.16404e+12    ,  7     ,  -1.01016e-28 },   //Rn221 
{  862220,  0       ,  4.76667e+14    ,  0     ,  0            },   //Rn222 
{  862230,  0       ,  2.00823e+12    ,  7     ,  -3.91941e-27 },   //Rn223 
{  862240,  0       ,  9.2621e+12     ,  0     ,  0            },   //Rn224 
{  862250,  0       ,  3.89528e+11    ,  7     ,  -3.51535e-27 },   //Rn225 
{  862260,  0       ,  6.40557e+11    ,  0     ,  0            },   //Rn226 
{  862270,  0       ,  3.24606e+10    ,  0     ,  0            },   //Rn227 
{  862280,  0       ,  9.37752e+10    ,  0     ,  0            },   //Rn228 
{  872010,  0       ,  6.92494e+07    ,  0     ,  0            },   //Fr201 
{  872020,  0       ,  4.90516e+08    ,  0     ,  0            },   //Fr202 
{  872030,  0       ,  7.93482e+08    ,  0     ,  0            },   //Fr203 
{  872040,  0       ,  2.45258e+09    ,  0     ,  0            },   //Fr204 
{  872041,  41      ,  3.75101e+09    ,  0     ,  0            },   //Fr204 
{  872042,  316     ,  1.4427e+09     ,  0     ,  0            },   //Fr204 
{  872050,  0       ,  5.55438e+09    ,  0     ,  0            },   //Fr205 
{  872060,  0       ,  2.29389e+10    ,  0     ,  0            },   //Fr206 
{  872061,  531     ,  1.00989e+09    ,  0     ,  0            },   //Fr206 
{  872070,  0       ,  2.13519e+10    ,  9     ,  1.96475e-26  },   //Fr207 
{  872080,  0       ,  8.52633e+10    ,  14    ,  2.39912e-26  },   //Fr208 
{  872090,  0       ,  7.21348e+10    ,  9     ,  1.99506e-26  },   //Fr209 
{  872100,  0       ,  2.75266e+11    ,  12    ,  2.22234e-26  },   //Fr210 
{  872110,  0       ,  2.68341e+11    ,  9     ,  2.02031e-26  },   //Fr211 
{  872120,  0       ,  1.73123e+12    ,  10    ,  2.33346e-26  },   //Fr212 
{  872121,  1551.4  ,  46022          ,  0     ,  0            },   //Fr212 
{  872122,  8533.4  ,  34047.6        ,  0     ,  0            },   //Fr212 
{  872130,  0       ,  4.99173e+10    ,  9     ,  2.03041e-26  },   //Fr213 
{  872131,  8094.7  ,  4472.36        ,  0     ,  0            },   //Fr213 
{  872140,  0       ,  7.21348e+06    ,  0     ,  0            },   //Fr214 
{  872141,  122     ,  4.83303e+06    ,  0     ,  0            },   //Fr214 
{  872160,  0       ,  1009.89        ,  0     ,  0            },   //Fr216 
{  872170,  0       ,  31739.3        ,  0     ,  0            },   //Fr217 
{  872180,  0       ,  1.4427e+06     ,  0     ,  0            },   //Fr218 
{  872181,  86      ,  3.17393e+07    ,  0     ,  0            },   //Fr218 
{  872190,  0       ,  2.88539e+07    ,  0     ,  0            },   //Fr219 
{  872200,  0       ,  3.95299e+10    ,  2     ,  -3.38402e-27 },   //Fr220 
{  872210,  0       ,  4.24152e+11    ,  5     ,  7.98024e-27  },   //Fr221 
{  872220,  0       ,  1.22918e+12    ,  4     ,  3.18199e-27  },   //Fr222 
{  872230,  0       ,  1.88705e+12    ,  3     ,  5.90942e-27  },   //Fr223 
{  872240,  0       ,  2.88251e+11    ,  2     ,  2.02031e-27  },   //Fr224 
{  872250,  0       ,  3.46247e+11    ,  3     ,  5.40434e-27  },   //Fr225 
{  872260,  0       ,  7.06921e+10    ,  2     ,  3.59616e-28  },   //Fr226 
{  872270,  0       ,  2.13807e+11    ,  1     ,  7.57617e-27  },   //Fr227 
{  872280,  0       ,  5.48224e+10    ,  4     ,  -3.8386e-27  },   //Fr228 
{  872290,  0       ,  7.21348e+10    ,  0     ,  0            },   //Fr229 
{  872300,  0       ,  2.75555e+10    ,  0     ,  0            },   //Fr230 
{  872310,  0       ,  2.52472e+10    ,  0     ,  0            },   //Fr231 
{  872320,  0       ,  7.21348e+09    ,  0     ,  0            },   //Fr232 
{  882030,  0       ,  1.4427e+06     ,  0     ,  0            },   //Ra203 
{  882040,  0       ,  8.5119e+07     ,  0     ,  0            },   //Ra204 
{  882050,  0       ,  3.02966e+08    ,  0     ,  0            },   //Ra205 
{  882060,  0       ,  3.46247e+08    ,  0     ,  0            },   //Ra206 
{  882070,  0       ,  1.8755e+09     ,  0     ,  0            },   //Ra207 
{  882071,  470     ,  7.93482e+07    ,  0     ,  0            },   //Ra207 
{  882080,  0       ,  1.8755e+09     ,  0     ,  0            },   //Ra208 
{  882090,  0       ,  6.6364e+09     ,  5     ,  4.36893e-27  },   //Ra209 
{  882100,  0       ,  5.33797e+09    ,  0     ,  0            },   //Ra210 
{  882110,  0       ,  1.8755e+10     ,  5     ,  4.43459e-27  },   //Ra211 
{  882120,  0       ,  1.8755e+10     ,  0     ,  0            },   //Ra212 
{  882121,  1958.4  ,  15725.4        ,  0     ,  0            },   //Ra212 
{  882122,  2613.4  ,  1226.29        ,  0     ,  0            },   //Ra212 
{  882130,  0       ,  2.37179e+11    ,  1     ,  3.09765e-27  },   //Ra213 
{  882131,  1770    ,  3.02966e+06    ,  0     ,  0            },   //Ra213 
{  882140,  0       ,  3.54903e+09    ,  0     ,  0            },   //Ra214 
{  882141,  1865.2  ,  96660.6        ,  0     ,  0            },   //Ra214 
{  882150,  0       ,  2.29389e+06    ,  0     ,  0            },   //Ra215 
{  882151,  1877.8  ,  10243.1        ,  0     ,  0            },   //Ra215 
{  882152,  2246.9  ,  2005.35        ,  0     ,  0            },   //Ra215 
{  882170,  0       ,  2308.31        ,  0     ,  0            },   //Ra217 
{  882180,  0       ,  36933          ,  0     ,  0            },   //Ra218 
{  882190,  0       ,  1.4427e+07     ,  0     ,  0            },   //Ra219 
{  882200,  0       ,  2.59685e+07    ,  0     ,  0            },   //Ra220 
{  882210,  0       ,  4.03955e+10    ,  5     ,  -9.08636e-28 },   //Ra221 
{  882220,  0       ,  5.48224e+10    ,  0     ,  0            },   //Ra222 
{  882230,  0       ,  1.42538e+15    ,  3     ,  1.36624e-27  },   //Ra223 
{  882240,  0       ,  4.5618e+14     ,  0     ,  0            },   //Ra224 
{  882250,  0       ,  1.85675e+15    ,  1     ,  -3.70626e-27 },   //Ra225 
{  882260,  0       ,  7.28417e+19    ,  0     ,  0            },   //Ra226 
{  882270,  0       ,  3.6529e+12     ,  3     ,  -2.03951e-27 },   //Ra227 
{  882280,  0       ,  2.61849e+17    ,  0     ,  0            },   //Ra228 
{  882290,  0       ,  3.46247e+11    ,  5     ,  2.53802e-27  },   //Ra229 
{  882300,  0       ,  8.05024e+12    ,  0     ,  0            },   //Ra230 
{  882310,  0       ,  1.48598e+11    ,  0     ,  0            },   //Ra231 
{  882311,  66.21   ,  76462.9        ,  0     ,  0            },   //Ra231 
{  882320,  0       ,  3.60674e+11    ,  0     ,  0            },   //Ra232 
{  882330,  0       ,  4.32809e+10    ,  0     ,  0            },   //Ra233 
{  882340,  0       ,  4.32809e+10    ,  0     ,  0            },   //Ra234 
{  892070,  0       ,  3.17393e+07    ,  0     ,  0            },   //Ac207 
{  892080,  0       ,  1.37056e+08    ,  0     ,  0            },   //Ac208 
{  892081,  506     ,  3.60674e+07    ,  0     ,  0            },   //Ac208 
{  892090,  0       ,  1.4427e+08     ,  0     ,  0            },   //Ac209 
{  892100,  0       ,  5.04943e+08    ,  0     ,  0            },   //Ac210 
{  892110,  0       ,  3.60674e+08    ,  0     ,  0            },   //Ac211 
{  892120,  0       ,  1.34171e+09    ,  0     ,  0            },   //Ac212 
{  892130,  0       ,  1.15416e+09    ,  0     ,  0            },   //Ac213 
{  892140,  0       ,  1.18301e+10    ,  0     ,  0            },   //Ac214 
{  892150,  0       ,  2.45258e+08    ,  0     ,  0            },   //Ac215 
{  892160,  0       ,  476089         ,  0     ,  0            },   //Ac216 
{  892171,  2013    ,  1067.59        ,  0     ,  0            },   //Ac217 
{  892180,  0       ,  1558.11        ,  0     ,  0            },   //Ac218 
{  892190,  0       ,  17023.8        ,  0     ,  0            },   //Ac219 
{  892200,  0       ,  3.80872e+07    ,  0     ,  0            },   //Ac220 
{  892210,  0       ,  7.50202e+07    ,  0     ,  0            },   //Ac221 
{  892220,  0       ,  7.21348e+09    ,  0     ,  0            },   //Ac222 
{  892230,  0       ,  1.8178e+11     ,  0     ,  0            },   //Ac223 
{  892240,  0       ,  1.44414e+13    ,  0     ,  0            },   //Ac224 
{  892250,  0       ,  1.24649e+15    ,  0     ,  0            },   //Ac225 
{  892260,  0       ,  1.52493e+14    ,  0     ,  0            },   //Ac226 
{  892270,  0       ,  9.91276e+17    ,  3     ,  5.55586e-27  },   //Ac227 
{  892280,  0       ,  3.19413e+13    ,  0     ,  0            },   //Ac228 
{  892290,  0       ,  5.42742e+12    ,  0     ,  0            },   //Ac229 
{  892300,  0       ,  1.76009e+11    ,  0     ,  0            },   //Ac230 
{  892310,  0       ,  6.49213e+11    ,  0     ,  0            },   //Ac231 
{  892320,  0       ,  1.71681e+11    ,  0     ,  0            },   //Ac232 
{  892330,  0       ,  2.09191e+11    ,  0     ,  0            },   //Ac233 
{  892340,  0       ,  6.34786e+10    ,  0     ,  0            },   //Ac234 
{  902100,  0       ,  1.29843e+07    ,  0     ,  0            },   //Th210 
{  902110,  0       ,  5.33797e+07    ,  0     ,  0            },   //Th211 
{  902120,  0       ,  4.32809e+07    ,  0     ,  0            },   //Th212 
{  902130,  0       ,  2.01977e+08    ,  0     ,  0            },   //Th213 
{  902140,  0       ,  1.4427e+08     ,  0     ,  0            },   //Th214 
{  902150,  0       ,  1.73123e+09    ,  0     ,  0            },   //Th215 
{  902160,  0       ,  4.03955e+07    ,  0     ,  0            },   //Th216 
{  902170,  0       ,  363559         ,  0     ,  0            },   //Th217 
{  902190,  0       ,  1514.83        ,  0     ,  0            },   //Th219 
{  902200,  0       ,  13994.1        ,  0     ,  0            },   //Th220 
{  902210,  0       ,  2.42373e+06    ,  0     ,  0            },   //Th221 
{  902220,  0       ,  4.03955e+06    ,  0     ,  0            },   //Th222 
{  902230,  0       ,  8.65617e+08    ,  0     ,  0            },   //Th223 
{  902240,  0       ,  1.51483e+09    ,  0     ,  0            },   //Th224 
{  902250,  0       ,  7.54818e+11    ,  0     ,  0            },   //Th225 
{  902260,  0       ,  2.6459e+12     ,  0     ,  0            },   //Th226 
{  902270,  0       ,  2.33284e+15    ,  0     ,  0            },   //Th227 
{  902280,  0       ,  8.70378e+16    ,  0     ,  0            },   //Th228 
{  902290,  0       ,  3.34128e+20    ,  5     ,  2.32336e-27  },   //Th229 
{  902300,  0       ,  3.43217e+21    ,  0     ,  0            },   //Th230 
{  902310,  0       ,  1.3254e+14     ,  0     ,  0            },   //Th231 
{  902320,  0       ,  6.39691e+26    ,  0     ,  0            },   //Th232 
{  902330,  0       ,  1.93033e+12    ,  0     ,  0            },   //Th233 
{  902340,  0       ,  3.00369e+15    ,  0     ,  0            },   //Th234 
{  902350,  0       ,  6.14588e+11    ,  0     ,  0            },   //Th235 
{  902360,  0       ,  3.24606e+12    ,  0     ,  0            },   //Th236 
{  902370,  0       ,  4.32809e+11    ,  0     ,  0            },   //Th237 
{  912130,  0       ,  7.64629e+06    ,  0     ,  0            },   //Pa213 
{  912140,  0       ,  2.45258e+07    ,  0     ,  0            },   //Pa214 
{  912150,  0       ,  2.01977e+07    ,  0     ,  0            },   //Pa215 
{  912160,  0       ,  2.88539e+08    ,  0     ,  0            },   //Pa216 
{  912170,  0       ,  7.06921e+06    ,  0     ,  0            },   //Pa217 
{  912171,  1854    ,  2.30831e+06    ,  0     ,  0            },   //Pa217 
{  912180,  0       ,  173123         ,  0     ,  0            },   //Pa218 
{  912200,  0       ,  1125.3         ,  0     ,  0            },   //Pa220 
{  912210,  0       ,  8511.9         ,  0     ,  0            },   //Pa221 
{  912220,  0       ,  4.18382e+06    ,  0     ,  0            },   //Pa222 
{  912230,  0       ,  9.37752e+06    ,  0     ,  0            },   //Pa223 
{  912240,  0       ,  1.13973e+09    ,  0     ,  0            },   //Pa224 
{  912250,  0       ,  2.45258e+09    ,  0     ,  0            },   //Pa225 
{  912260,  0       ,  1.55811e+11    ,  0     ,  0            },   //Pa226 
{  912270,  0       ,  3.31531e+12    ,  0     ,  0            },   //Pa227 
{  912280,  0       ,  1.14261e+14    ,  6     ,  1.75767e-26  },   //Pa228 
{  912290,  0       ,  1.86973e+14    ,  0     ,  0            },   //Pa229 
{  912300,  0       ,  2.16837e+15    ,  4     ,  1.01016e-26  },   //Pa230 
{  912310,  0       ,  1.49175e+21    ,  3     ,  1.01521e-26  },   //Pa231 
{  912320,  0       ,  1.63313e+14    ,  0     ,  0            },   //Pa232 
{  912330,  0       ,  3.36148e+15    ,  3     ,  1.71222e-26  },   //Pa233 
{  912340,  0       ,  3.47978e+13    ,  0     ,  0            },   //Pa234 
{  912341,  78.92   ,  1.01277e+11    ,  0     ,  0            },   //Pa234 
{  912350,  0       ,  2.12076e+12    ,  0     ,  0            },   //Pa235 
{  912360,  0       ,  7.87712e+11    ,  0     ,  0            },   //Pa236 
{  912370,  0       ,  7.53087e+11    ,  0     ,  0            },   //Pa237 
{  912380,  0       ,  1.99092e+11    ,  0     ,  0            },   //Pa238 
{  922180,  0       ,  2.16404e+06    ,  0     ,  0            },   //U218  
{  922190,  0       ,  60593.2        ,  0     ,  0            },   //U219  
{  922220,  0       ,  1442.7         ,  0     ,  0            },   //U222  
{  922230,  0       ,  25968.5        ,  0     ,  0            },   //U223  
{  922240,  0       ,  1.29843e+06    ,  0     ,  0            },   //U224  
{  922250,  0       ,  1.37056e+08    ,  0     ,  0            },   //U225  
{  922260,  0       ,  2.88539e+08    ,  0     ,  0            },   //U226  
{  922270,  0       ,  9.52179e+10    ,  0     ,  0            },   //U227  
{  922280,  0       ,  7.87712e+11    ,  0     ,  0            },   //U228  
{  922290,  0       ,  5.02058e+12    ,  0     ,  0            },   //U229  
{  922300,  0       ,  2.59252e+15    ,  0     ,  0            },   //U230  
{  922310,  0       ,  5.23554e+14    ,  0     ,  0            },   //U231  
{  922320,  0       ,  3.13642e+18    ,  0     ,  0            },   //U232  
{  922330,  0       ,  7.2481e+21     ,  5     ,  2.97996e-27  },   //U233  
{  922340,  0       ,  1.1178e+22     ,  0     ,  0            },   //U234  
{  922341,  1421.32 ,  48330.3        ,  0     ,  0            },   //U234  
{  922350,  0       ,  3.20423e+25    ,  7     ,  -1.9193e-27  },   //U235  
{  922351,  0.0768  ,  2.16404e+12    ,  0     ,  0            },   //U235  
{  922360,  0       ,  1.0663e+24     ,  0     ,  0            },   //U236  
{  922370,  0       ,  8.4138e+14     ,  0     ,  0            },   //U237  
{  922380,  0       ,  2.0342e+26     ,  0     ,  0            },   //U238  
{  922390,  0       ,  2.02987e+12    ,  0     ,  0            },   //U239  
{  922391,  133.799 ,  1125.3         ,  0     ,  0            },   //U239  
{  922400,  0       ,  7.32312e+13    ,  0     ,  0            },   //U240  
{  922420,  0       ,  1.45424e+12    ,  0     ,  0            },   //U242  
{  932250,  0       ,  8.65617e+06    ,  0     ,  0            },   //Np225 
{  932260,  0       ,  5.04943e+07    ,  0     ,  0            },   //Np226 
{  932270,  0       ,  7.35775e+08    ,  0     ,  0            },   //Np227 
{  932280,  0       ,  8.85815e+10    ,  0     ,  0            },   //Np228 
{  932290,  0       ,  3.46247e+11    ,  0     ,  0            },   //Np229 
{  932300,  0       ,  3.98184e+11    ,  0     ,  0            },   //Np230 
{  932310,  0       ,  4.22421e+12    ,  0     ,  0            },   //Np231 
{  932320,  0       ,  1.27246e+12    ,  0     ,  0            },   //Np232 
{  932330,  0       ,  3.13353e+12    ,  0     ,  0            },   //Np233 
{  932340,  0       ,  5.48513e+14    ,  0     ,  0            },   //Np234 
{  932350,  0       ,  4.9369e+16     ,  0     ,  0            },   //Np235 
{  932360,  0       ,  7.0115e+21     ,  0     ,  0            },   //Np236 
{  932361,  60      ,  1.16858e+14    ,  0     ,  0            },   //Np236 
{  932370,  0       ,  9.76128e+22    ,  5     ,  1.58595e-26  },   //Np237 
{  932371,  945.3   ,  1024.31        ,  0     ,  0            },   //Np237 
{  932380,  0       ,  2.63869e+14    ,  0     ,  0            },   //Np238 
{  932390,  0       ,  2.93733e+14    ,  0     ,  0            },   //Np239 
{  932400,  0       ,  5.35817e+12    ,  0     ,  0            },   //Np240 
{  932401,  20      ,  6.24976e+11    ,  0     ,  0            },   //Np240 
{  932410,  0       ,  1.20321e+12    ,  0     ,  0            },   //Np241 
{  932420,  0       ,  4.76089e+11    ,  0     ,  0            },   //Np242 
{  932430,  0       ,  1.55811e+11    ,  0     ,  0            },   //Np243 
{  932440,  0       ,  1.98226e+11    ,  0     ,  0            },   //Np244 
{  942280,  0       ,  5.77078e+06    ,  0     ,  0            },   //Pu228 
{  942320,  0       ,  2.95175e+12    ,  0     ,  0            },   //Pu232 
{  942330,  0       ,  1.80914e+12    ,  0     ,  0            },   //Pu233 
{  942340,  0       ,  4.57046e+13    ,  0     ,  0            },   //Pu234 
{  942350,  0       ,  2.19001e+12    ,  0     ,  0            },   //Pu235 
{  942360,  0       ,  1.30117e+17    ,  0     ,  0            },   //Pu236 
{  942370,  0       ,  5.63373e+15    ,  0     ,  0            },   //Pu237 
{  942371,  145.544 ,  2.59685e+08    ,  0     ,  0            },   //Pu237 
{  942380,  0       ,  3.99338e+18    ,  0     ,  0            },   //Pu238 
{  942390,  0       ,  1.09775e+21    ,  1     ,  1.02531e-27  },   //Pu239 
{  942400,  0       ,  2.98782e+20    ,  0     ,  0            },   //Pu240 
{  942410,  0       ,  6.53397e+17    ,  5     ,  -3.44968e-27 },   //Pu241 
{  942411,  161.6   ,  1269.57        ,  0     ,  0            },   //Pu241 
{  942420,  0       ,  1.6995e+22     ,  0     ,  0            },   //Pu242 
{  942430,  0       ,  2.57377e+13    ,  0     ,  0            },   //Pu243 
{  942440,  0       ,  3.67887e+24    ,  0     ,  0            },   //Pu244 
{  942450,  0       ,  5.45339e+13    ,  0     ,  0            },   //Pu245 
{  942460,  0       ,  1.35123e+15    ,  0     ,  0            },   //Pu246 
{  942470,  0       ,  2.82913e+14    ,  0     ,  0            },   //Pu247 
{  952320,  0       ,  1.13973e+11    ,  0     ,  0            },   //Am232 
{  952340,  0       ,  2.00823e+11    ,  0     ,  0            },   //Am234 
{  952350,  0       ,  1.29843e+12    ,  0     ,  0            },   //Am235 
{  952370,  0       ,  6.31901e+12    ,  0     ,  0            },   //Am237 
{  952380,  0       ,  8.48305e+12    ,  0     ,  0            },   //Am238 
{  952390,  0       ,  6.18051e+13    ,  0     ,  0            },   //Am239 
{  952400,  0       ,  2.63869e+14    ,  0     ,  0            },   //Am240 
{  952410,  0       ,  1.96784e+19    ,  5     ,  8.13176e-27  },   //Am241 
{  952420,  0       ,  8.32002e+13    ,  2     ,  1.9592e-27   },   //Am242 
{  952421,  48.63   ,  6.41999e+18    ,  0     ,  0            },   //Am242 
{  952422,  2200    ,  2.01977e+07    ,  0     ,  0            },   //Am242 
{  952430,  0       ,  3.35571e+20    ,  5     ,  7.7277e-27   },   //Am243 
{  952440,  0       ,  5.24564e+13    ,  0     ,  0            },   //Am244 
{  952441,  88      ,  2.2506e+12     ,  0     ,  0            },   //Am244 
{  952450,  0       ,  1.06471e+13    ,  0     ,  0            },   //Am245 
{  952460,  0       ,  3.37591e+12    ,  0     ,  0            },   //Am246 
{  952461,  30      ,  2.16404e+12    ,  0     ,  0            },   //Am246 
{  952470,  0       ,  1.99092e+12    ,  0     ,  0            },   //Am247 
{  962380,  0       ,  1.24649e+13    ,  0     ,  0            },   //Cm238 
{  962390,  0       ,  1.50617e+13    ,  0     ,  0            },   //Cm239 
{  962400,  0       ,  3.36581e+15    ,  0     ,  0            },   //Cm240 
{  962410,  0       ,  4.0886e+15     ,  0     ,  0            },   //Cm241 
{  962420,  0       ,  2.02987e+16    ,  0     ,  0            },   //Cm242 
{  962430,  0       ,  1.32483e+18    ,  5     ,  2.07082e-27  },   //Cm243 
{  962431,  87.4    ,  1558.11        ,  0     ,  0            },   //Cm243 
{  962440,  0       ,  8.24068e+17    ,  0     ,  0            },   //Cm244 
{  962441,  1040.18 ,  4.90516e+07    ,  0     ,  0            },   //Cm244 
{  962450,  0       ,  3.86931e+20    ,  7     ,  2.52539e-27  },   //Cm245 
{  962460,  0       ,  2.15394e+20    ,  0     ,  0            },   //Cm246 
{  962470,  0       ,  7.10239e+23    ,  9     ,  1.86879e-27  },   //Cm247 
{  962471,  227     ,  36067.4        ,  0     ,  0            },   //Cm247 
{  962480,  0       ,  1.54801e+22    ,  0     ,  0            },   //Cm248 
{  962490,  0       ,  5.55293e+12    ,  0     ,  0            },   //Cm249 
{  962491,  48.758  ,  33182          ,  0     ,  0            },   //Cm249 
{  962500,  0       ,  4.09725e+20    ,  0     ,  0            },   //Cm250 
{  972380,  0       ,  2.07748e+11    ,  0     ,  0            },   //Bk238 
{  972400,  0       ,  4.15496e+11    ,  0     ,  0            },   //Bk240 
{  972420,  0       ,  6.05932e+11    ,  0     ,  0            },   //Bk242 
{  972430,  0       ,  2.33717e+13    ,  0     ,  0            },   //Bk243 
{  972440,  0       ,  2.25926e+13    ,  0     ,  0            },   //Bk244 
{  972450,  0       ,  6.15742e+14    ,  0     ,  0            },   //Bk245 
{  972460,  0       ,  2.24339e+14    ,  0     ,  0            },   //Bk246 
{  972470,  0       ,  6.28294e+19    ,  0     ,  0            },   //Bk247 
{  972480,  0       ,  4.09725e+17    ,  0     ,  0            },   //Bk248 
{  972481,  30      ,  1.23091e+14    ,  0     ,  0            },   //Bk248 
{  972490,  0       ,  3.98905e+16    ,  7     ,  1.01016e-26  },   //Bk249 
{  972491,  8.8     ,  432809         ,  0     ,  0            },   //Bk249 
{  972500,  0       ,  1.67064e+13    ,  0     ,  0            },   //Bk250 
{  972501,  35.59   ,  41838.2        ,  0     ,  0            },   //Bk250 
{  972502,  86      ,  307294         ,  0     ,  0            },   //Bk250 
{  982370,  0       ,  3.02966e+09    ,  0     ,  0            },   //Cf237 
{  982380,  0       ,  3.02966e+07    ,  0     ,  0            },   //Cf238 
{  982390,  0       ,  5.62651e+10    ,  0     ,  0            },   //Cf239 
{  982400,  0       ,  9.17554e+10    ,  0     ,  0            },   //Cf240 
{  982410,  0       ,  3.27203e+11    ,  0     ,  0            },   //Cf241 
{  982420,  0       ,  3.021e+11      ,  0     ,  0            },   //Cf242 
{  982430,  0       ,  9.2621e+11     ,  0     ,  0            },   //Cf243 
{  982440,  0       ,  1.6793e+12     ,  0     ,  0            },   //Cf244 
{  982450,  0       ,  3.89528e+12    ,  0     ,  0            },   //Cf245 
{  982460,  0       ,  1.85386e+14    ,  0     ,  0            },   //Cf246 
{  982470,  0       ,  1.61582e+13    ,  0     ,  0            },   //Cf247 
{  982480,  0       ,  4.15641e+16    ,  0     ,  0            },   //Cf248 
{  982490,  0       ,  1.59851e+19    ,  0     ,  0            },   //Cf249 
{  982491,  144.98  ,  64921.3        ,  0     ,  0            },   //Cf249 
{  982500,  0       ,  5.95545e+17    ,  0     ,  0            },   //Cf250 
{  982520,  0       ,  1.20422e+17    ,  0     ,  0            },   //Cf252 
{  992410,  0       ,  1.29843e+10    ,  0     ,  0            },   //Es241 
{  992420,  0       ,  5.77078e+10    ,  0     ,  0            },   //Es242 
{  992430,  0       ,  3.02966e+10    ,  0     ,  0            },   //Es243 
{  992440,  0       ,  5.33797e+10    ,  0     ,  0            },   //Es244 
{  992450,  0       ,  9.52179e+10    ,  0     ,  0            },   //Es245 
{  992460,  0       ,  6.66525e+11    ,  0     ,  0            },   //Es246 
{  992470,  0       ,  3.93856e+11    ,  0     ,  0            },   //Es247 
{  992480,  0       ,  2.33717e+12    ,  0     ,  0            },   //Es248 
{  992490,  0       ,  8.84661e+12    ,  0     ,  0            },   //Es249 
{  992500,  0       ,  4.46659e+13    ,  0     ,  0            },   //Es250 
{  992530,  0       ,  -1             ,  7     ,  2.07082e-26  },   //Es253 
{  1002420,  0       ,  1.15416e+06    ,  0     ,  0            },   //Fm242 
{  1002430,  0       ,  2.59685e+08    ,  0     ,  0            },   //Fm243 
{  1002440,  0       ,  4.76089e+06    ,  0     ,  0            },   //Fm244 
{  1002450,  0       ,  6.05932e+09    ,  0     ,  0            },   //Fm245 
{  1002460,  0       ,  1.58696e+09    ,  0     ,  0            },   //Fm246 
{  1002470,  0       ,  5.04943e+10    ,  0     ,  0            },   //Fm247 
{  1002471,  150     ,  1.32728e+10    ,  0     ,  0            },   //Fm247 
{  1002480,  0       ,  5.1937e+10     ,  0     ,  0            },   //Fm248 
{  1002490,  0       ,  2.2506e+11     ,  0     ,  0            },   //Fm249 
{  1002500,  0       ,  2.59685e+12    ,  0     ,  0            },   //Fm250 
{  1002501,  1000    ,  2.59685e+09    ,  0     ,  0            }    //Fm250 
};
