//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// --------------------------------------------------------------
//   GEANT 4 - Underground Dark Matter Detector Advanced Example
//
//      For information related to this code contact: Alex Howard
//      e-mail: alexander.howard@cern.ch
// --------------------------------------------------------------
// Comments
//
//                  Underground Advanced
//               by A. Howard and H. Araujo 
//                    (27th November 2001)
//
// PmtHit (sensitive detector) program
// --------------------------------------------------------------

#include "DMXPmtHit.hh"

#include "G4UnitsTable.hh"
#include "G4VVisManager.hh"
#include "G4Circle.hh"
#include "G4Colour.hh"
#include "G4VisAttributes.hh"

#include <iomanip>

G4Allocator<DMXPmtHit> DMXPmtHitsAllocator;


DMXPmtHit::DMXPmtHit() {
  
  pos = G4ThreeVector(0., 0., 0.);
  time=0.;

}


DMXPmtHit::~DMXPmtHit() {;}


DMXPmtHit::DMXPmtHit(const DMXPmtHit& right) : G4VHit(right) {

  pos  = right.pos;
  time = right.time;

}



const DMXPmtHit& DMXPmtHit::operator=(const DMXPmtHit& right) {

  pos  = right.pos;
  time = right.time;

  return *this;

}


int DMXPmtHit::operator==(const DMXPmtHit& right) const {

  return (this==&right) ? 1 : 0;

}



void DMXPmtHit::Draw()  {

  G4VVisManager* pVVisManager = G4VVisManager::GetConcreteInstance();

  if(pVVisManager) {
    G4Circle circle(pos);
    circle.SetScreenSize(0.002);
    circle.SetFillStyle(G4Circle::filled);
    G4Colour colour(1.,1.,0.);
    G4VisAttributes attribs(colour);
    circle.SetVisAttributes(attribs);
    pVVisManager->Draw(circle);
  }


}


void DMXPmtHit::Print() {

  //  G4cout << "      PMT hit: " << G4BestUnit(pos,"Length") << G4endl;

  G4cout << "      PMT hit: " << std::setw(5) << G4BestUnit(time,"Time") 
	 << ", at " << G4BestUnit(pos,"Length") << G4endl;


}



