//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: lArCal.cc 67976 2013-03-13 10:23:17Z gcosmo $
//
// 
// --------------------------------------------------------------
//      GEANT 4 - exampleN03 
//
//      For information related to this code contact:
//      CERN, IT Division, ASD Group
// --------------------------------------------------------------
// Comments
//
// --------------------------------------------------------------

#include "G4RunManager.hh"
#include "G4UImanager.hh"

#include "Randomize.hh"

#ifdef G4VIS_USE
#include "G4VisExecutive.hh"
#endif

#ifdef G4UI_USE
#include "G4UIExecutive.hh"
#endif

#include "FCALTestbeamSetup.hh"
#include "FCALSteppingVerbose.hh"
#include "FCALPrimaryGeneratorAction.hh"
#include "G4PhysListFactory.hh"
#include "FCALRunAction.hh"
#include "FCALTBEventAction.hh"
#include "FCALSteppingAction.hh"



int main(int argc,char** argv) {

  // choose the Random engine
  CLHEP::HepRandom::setTheEngine(new CLHEP::RanecuEngine);
  
  //my Verbose output class
  G4VSteppingVerbose::SetInstance(new FCALSteppingVerbose);
     
  // Construct the default run manager
  G4RunManager * runManager = new G4RunManager;

  // set mandatory initialization classes
  FCALTestbeamSetup* detector = new FCALTestbeamSetup;
  runManager->SetUserInitialization(detector);

  G4PhysListFactory factory;
  runManager->SetUserInitialization(factory.ReferencePhysList());
  
#ifdef G4VIS_USE
  // visualization manager
  G4VisManager* visManager = new G4VisExecutive;
  visManager->Initialize();
#endif
    
  // set user action classes
  runManager->SetUserAction(new FCALPrimaryGeneratorAction());

  FCALRunAction* RunAction = new FCALRunAction;
  runManager ->SetUserAction(RunAction);

  FCALSteppingAction* StepAction = new FCALSteppingAction;
  runManager->SetUserAction(StepAction);

  //  runManager->SetUserAction(new FCALRunAction);
  
  runManager->SetUserAction(new FCALTBEventAction(StepAction));
  

  //Initialize G4 kernel
  runManager->Initialize();
    
  // get the pointer to the User Interface manager 
  G4UImanager* UImanager = G4UImanager::GetUIpointer();  

  if (argc==1)   // Define UI session for interactive mode.
     {
#ifdef G4UI_USE
       G4UIExecutive* ui = new G4UIExecutive(argc, argv);
#ifdef G4VIS_USE
       UImanager->ApplyCommand("/control/execute prerunlArcal.mac");     
#endif
       if (ui->IsGUI())
	 UImanager->ApplyCommand("/control/execute gui.mac");     
       ui->SessionStart();
       delete ui;
#endif
    }
  else           // Batch mode
    { 
      G4String command = "/control/execute ";
      G4String fileName = argv[1];
      UImanager->ApplyCommand(command+fileName);
    }

  // job termination
#ifdef G4VIS_USE
  delete visManager;
#endif
  delete runManager;

  return 0;
}

