/*
 * Decompiled with CFR 0.152.
 */
package GAG;

import GAG.BooleanCombo;
import GAG.ExampleFileFilter;
import GAG.GAG;
import GAG.GAGcommandItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ParamPanel
extends JPanel
implements ActionListener,
ItemListener {
    private GAG gag;
    private GridBagLayout gbl;
    GridBagConstraints gbc;
    private JPanel paramArea;
    private JButton def;
    private JButton current;
    private JButton clear;
    private JButton ok;
    private JButton fileBrowser;
    private JComboBox history;
    private int posY;
    private GAGcommandItem ci;
    private Component[] paraBox;
    private boolean isExecuting = false;
    private JFileChooser fileChooser;
    private ExampleFileFilter g4mFilter;
    private ExampleFileFilter macroFilter;
    private ExampleFileFilter g4macroFilter;
    private ExampleFileFilter txtFilter;
    public String macroPath;

    public ParamPanel(GAG gag) {
        this.gag = gag;
        this.macroPath = gag.workdirpath;
        this.setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbl = new GridBagLayout();
        this.paramArea = new JPanel();
        this.paramArea.setLayout(this.gbl);
        this.paramArea.setBackground(new Color(255, 250, 230));
        this.add("Center", new JScrollPane(this.paramArea));
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 0, 2, 2));
        this.def = new JButton("Default");
        this.current = new JButton("Current");
        this.clear = new JButton("Clear");
        this.ok = new JButton("Execute");
        this.ok.setBackground(Color.green);
        this.def.setBackground(Color.blue);
        this.current.setBackground(Color.orange);
        this.clear.setBackground(SystemColor.white);
        buttons.add(this.def);
        buttons.add(this.current);
        buttons.add(this.clear);
        buttons.add(this.ok);
        this.add("South", buttons);
        this.history = new JComboBox();
        this.history.setEnabled(true);
        String titleHist = "#Command History List";
        this.history.addItem(titleHist);
        this.history.addItemListener(this);
        this.history.addActionListener(this);
        this.add("North", this.history);
        this.def.setVisible(false);
        this.def.setEnabled(false);
        this.def.setMargin(new Insets(1, 3, 1, 3));
        this.def.addActionListener(this);
        this.current.setVisible(false);
        this.current.setEnabled(false);
        this.current.setMargin(new Insets(1, 3, 1, 3));
        this.current.addActionListener(this);
        this.clear.setVisible(false);
        this.clear.setEnabled(false);
        this.clear.setMargin(new Insets(1, 3, 1, 3));
        this.clear.addActionListener(this);
        this.ok.setVisible(false);
        this.ok.setEnabled(false);
        this.ok.setMargin(new Insets(1, 3, 1, 3));
        this.ok.addActionListener(this);
        this.fileBrowser = new JButton("Open a Macro File");
        this.fileBrowser.addActionListener(this);
        this.fileChooser = new JFileChooser(".");
        this.fileChooser.setDialogTitle("Macro File");
        this.macroFilter = new ExampleFileFilter("mac", "Geant4 macro");
        this.g4mFilter = new ExampleFileFilter("g4m", "Geant4 macro");
        this.txtFilter = new ExampleFileFilter("txt", "Geant4 macro");
        this.fileChooser.addChoosableFileFilter(this.macroFilter);
    }

    void setParamBox(GAGcommandItem ci, boolean enable) {
        JLabel lab;
        this.paramArea.removeAll();
        this.ci = ci;
        this.posY = 0;
        if (!enable) {
            lab = new JLabel("This command is not available.");
            lab.setForeground(Color.red);
            this.addComponent(lab);
        }
        this.addComponent(new JLabel(ci.getCommandName()));
        String[] guide = ci.getCommandGuide();
        for (int i = 0; i < guide.length; ++i) {
            this.addComponent(new JLabel(guide[i]));
        }
        if (!ci.getCommandRange().equals("")) {
            lab = new JLabel(ci.getCommandRange());
            lab.setForeground(Color.green);
            this.addComponent(lab);
        }
        if (ci.getParamEntries() > 0) {
            this.def.setEnabled(true);
            this.def.setVisible(true);
            this.current.setEnabled(!this.isExecuting && enable);
            this.current.setVisible(!this.isExecuting && enable);
            this.clear.setEnabled(true);
            this.clear.setVisible(true);
            this.paraBox = new JComponent[ci.getParamEntries()];
            for (int i = 0; i < ci.getParamEntries(); ++i) {
                String candidateList = ci.getParamCandidate(i);
                if (candidateList.equals("")) {
                    if (ci.getParamType(i).equals("b")) {
                        this.paraBox[i] = new BooleanCombo(ci.getParamDefault(i));
                    } else {
                        this.paraBox[i] = new JTextField(20);
                        ((JTextField)this.paraBox[i]).setText(ci.getParamDefault(i));
                    }
                } else {
                    this.paraBox[i] = new JComboBox();
                    StringTokenizer st = new StringTokenizer(candidateList);
                    while (st.hasMoreTokens()) {
                        ((JComboBox)this.paraBox[i]).addItem(st.nextToken());
                    }
                    if (!ci.getParamDefault(i).equals("")) {
                        ((JComboBox)this.paraBox[i]).setSelectedItem(ci.getParamDefault(i));
                    }
                }
                this.addComponent(new JLabel(ci.getParamName(i)), this.paraBox[i], new JLabel("(" + ci.getParamType(i) + ") " + ci.getParamGuide(i)));
                if (!ci.getParamName(i).equals("fileName")) continue;
                this.addComponent(new JLabel(), this.fileBrowser);
            }
        } else {
            this.def.setVisible(false);
            this.def.setEnabled(false);
            this.current.setVisible(false);
            this.current.setEnabled(false);
            this.clear.setVisible(false);
            this.clear.setEnabled(false);
        }
        this.ok.setEnabled(!this.isExecuting && enable);
        this.ok.setVisible(!this.isExecuting && enable);
        this.validate();
        this.repaint();
    }

    void setTreeHelp(String dirHelp, JLabel[][] helps) {
        this.ok.setVisible(false);
        this.ok.setEnabled(false);
        this.def.setVisible(false);
        this.def.setEnabled(false);
        this.current.setVisible(false);
        this.current.setEnabled(false);
        this.clear.setVisible(false);
        this.clear.setEnabled(false);
        this.paramArea.removeAll();
        this.posY = 0;
        this.ci = null;
        JLabel title = new JLabel(dirHelp);
        title.setForeground(Color.green);
        this.addComponent(title);
        for (int i = 0; i < helps[0].length; ++i) {
            this.addComponent(helps[0][i], helps[1][i]);
        }
        this.validate();
        this.repaint();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String makeCommandLine() {
        StringBuffer param = new StringBuffer(this.ci.getCommandName());
        if (this.ci.getParamEntries() > 0) {
            for (int i = 0; i < this.ci.getParamEntries(); ++i) {
                String val;
                if (this.paraBox[i] instanceof JTextField) {
                    val = ((JTextField)this.paraBox[i]).getText().trim();
                    if (val.equals("")) {
                        if (!this.ci.isOmittable(i)) {
                            JOptionPane.showMessageDialog(this, this.ci.getParamName(i) + "\nThis parameter cannot be omitted.", "Error", 2);
                            return null;
                        }
                        if (this.ci.getParamDefault(i).equals("")) {
                            JOptionPane.showMessageDialog(this, this.ci.getParamName(i) + "\nThis omittable parameter has not default value.", "Error", 2);
                            return null;
                        }
                        val = this.ci.getParamDefault(i);
                    }
                } else {
                    val = (String)((JComboBox)this.paraBox[i]).getSelectedItem();
                }
                param.append(" " + val);
            }
            this.current.setVisible(false);
            this.current.setEnabled(false);
        }
        this.ok.setVisible(false);
        this.ok.setEnabled(false);
        this.history.addItem(param.toString());
        return param.toString();
    }

    private void addComponent(Component compo) {
        this.gbc.gridx = 0;
        this.gbc.gridy = this.posY++;
        this.gbc.gridwidth = 3;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 17;
        this.gbl.setConstraints(compo, this.gbc);
        this.paramArea.add(compo);
    }

    private void addComponent(Component compo1, Component compo2) {
        this.gbc.gridx = 0;
        this.gbc.gridy = this.posY++;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 13;
        this.gbl.setConstraints(compo1, this.gbc);
        this.paramArea.add(compo1);
        this.gbc.gridx = 1;
        this.gbc.anchor = 17;
        this.gbl.setConstraints(compo2, this.gbc);
        this.paramArea.add(compo2);
    }

    private void addComponent(Component title, Component compo1, Component compo2) {
        this.gbc.gridx = 0;
        this.gbc.gridy = this.posY++;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 13;
        this.gbl.setConstraints(title, this.gbc);
        this.paramArea.add(title);
        this.gbc.gridx = 1;
        this.gbc.fill = 2;
        this.gbl.setConstraints(compo1, this.gbc);
        this.paramArea.add(compo1);
        this.gbc.gridx = 2;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbl.setConstraints(compo2, this.gbc);
        this.paramArea.add(compo2);
    }

    private void loadValue(int i, String str) {
        if (this.paraBox[i] instanceof JTextField) {
            ((JTextField)this.paraBox[i]).setText(str);
        }
        if (this.paraBox[i] instanceof JComboBox) {
            ((JComboBox)this.paraBox[i]).setSelectedItem(str);
        }
    }

    public void addHistory(String line) {
        if (line.startsWith("/")) {
            this.history.addItem(line);
        }
    }

    public void clearAllHistory() {
        this.history.removeAllItems();
        this.history.addItem("#Command History List");
    }

    public void clearOneHistory() {
        int ix = this.history.getSelectedIndex();
        if (ix > 0) {
            this.history.removeItemAt(ix);
        }
    }

    public Vector getHistoryItems() {
        int no = this.history.getItemCount();
        Vector<String> item = new Vector<String>(no);
        for (int i = 0; i < no; ++i) {
            item.add((String)this.history.getItemAt(i));
        }
        return item;
    }

    void loadCurrentValues(String line) {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        int i = 0;
        while (st.hasMoreTokens()) {
            this.loadValue(i++, st.nextToken());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (this.isExecuting) {
            return;
        }
        if (ie.getStateChange() != 1) {
            return;
        }
        String str = (String)ie.getItem();
        if (!str.startsWith("/")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(str);
        if (!this.gag.setParamPanel(st.nextToken())) {
            return;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            this.loadValue(i++, st.nextToken());
            if (i < this.ci.getParamEntries()) continue;
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.ok) {
            String p = this.makeCommandLine();
            if (p == null) {
                return;
            }
            this.isExecuting = true;
            this.gag.sendCommand(p);
            return;
        }
        if (source == this.def) {
            for (int i = 0; this.ci.getParamEntries() > i; ++i) {
                this.loadValue(i, this.ci.getParamDefault(i));
            }
            return;
        }
        if (source == this.current) {
            this.gag.reqCurrent(this.ci.getCommandName());
            return;
        }
        if (source == this.clear) {
            for (int i = 0; this.ci.getParamEntries() > i; ++i) {
                if (!(this.paraBox[i] instanceof JTextField)) continue;
                ((JTextField)this.paraBox[i]).setText("");
            }
            return;
        }
        if (source == this.fileBrowser) {
            if (this.fileChooser.showOpenDialog(this) != 0) {
                return;
            }
            File f = this.fileChooser.getSelectedFile();
            if (f.isFile() && this.paraBox[0] instanceof JTextField) {
                ((JTextField)this.paraBox[0]).setText(f.getPath());
            }
            return;
        }
    }

    void toReady() {
        this.isExecuting = false;
        if (this.ci == null) {
            return;
        }
        if (this.ci.getParamEntries() == 0) {
            return;
        }
        this.isExecuting = false;
        this.ok.setEnabled(true);
        this.ok.setVisible(true);
        this.current.setEnabled(true);
        this.current.setVisible(true);
        this.repaint();
    }
}

