/*----------------------
   Copyright (C): OpenGATE Collaboration

This software is distributed under the terms
of the GNU Lesser General  Public Licence (LGPL)
See GATE/LICENSE.txt for further details
----------------------*/

#ifndef GateMuDatabase_h
#define GateMuDatabase_h 1

/*! \file  GateMuDatabase
    \brief  Database of attenuation and energy absorption coefficients
*/

//----------------------------------------------------------------------------------------------------------------------
// NIST
static const int NIST_mu_muen_data_elementNumber = 92;

static const int NIST_mu_muen_data_energyNumber[93] = {
0,25,25,25,25,25,25,25,25,25,25,28,28,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,30,30,36,36,36,35,35,35,35,34,34,35,
35,35,35,34,34,35,35,35,34,34,34,35,38,37,37,41,44,43,43,42,
46,49,49,48,48,48,47,48,48,47,47,47,47,47,48,48,47,48,48,48,
48,47,47,47,46,49,49,50,54,53,52,55,55};

static const float NIST_mu_muen_data[10401] = { 
1.00000e-03,7.21700e+00,6.82000e+00,1.50000e-03,2.14800e+00,1.75200e+00,2.00000e-03,1.05900e+00,6.64300e-01,3.00000e-03,
5.61200e-01,1.69300e-01,4.00000e-03,4.54600e-01,6.54900e-02,5.00000e-03,4.19300e-01,3.27800e-02,6.00000e-03,4.04200e-01,
1.99600e-02,8.00000e-03,3.91400e-01,1.16000e-02,1.00000e-02,3.85400e-01,9.84900e-03,1.50000e-02,3.76400e-01,1.10200e-02,
2.00000e-02,3.69500e-01,1.35500e-02,3.00000e-02,3.57000e-01,1.86300e-02,4.00000e-02,3.45800e-01,2.31500e-02,5.00000e-02,
3.35500e-01,2.70900e-02,6.00000e-02,3.26000e-01,3.05300e-02,8.00000e-02,3.09100e-01,3.62000e-02,1.00000e-01,2.94400e-01,
4.06300e-02,1.50000e-01,2.65100e-01,4.81300e-02,2.00000e-01,2.42900e-01,5.25400e-02,3.00000e-01,2.11200e-01,5.69500e-02,
4.00000e-01,1.89300e-01,5.86000e-02,5.00000e-01,1.72900e-01,5.90000e-02,6.00000e-01,1.59900e-01,5.87500e-02,8.00000e-01,
1.40500e-01,5.73900e-02,1.00000e+00,1.26300e-01,5.55600e-02,1.00000e-03,6.08400e+01,6.04500e+01,1.50000e-03,1.67600e+01,
1.63800e+01,2.00000e-03,6.86300e+00,6.50300e+00,3.00000e-03,2.00700e+00,1.68100e+00,4.00000e-03,9.32900e-01,6.37900e-01,
5.00000e-03,5.76600e-01,3.06100e-01,6.00000e-03,4.19500e-01,1.67100e-01,8.00000e-03,2.93300e-01,6.44600e-02,1.00000e-02,
2.47600e-01,3.26000e-02,1.50000e-02,2.09200e-01,1.24600e-02,2.00000e-02,1.96000e-01,9.41000e-03,3.00000e-02,1.83800e-01,
1.00300e-02,4.00000e-02,1.76300e-01,1.19000e-02,5.00000e-02,1.70300e-01,1.37500e-02,6.00000e-02,1.65100e-01,1.54400e-02,
8.00000e-02,1.56200e-01,1.82600e-02,1.00000e-01,1.48600e-01,2.04700e-02,1.50000e-01,1.33600e-01,2.42400e-02,2.00000e-01,
1.22400e-01,2.64700e-02,3.00000e-01,1.06400e-01,2.86800e-02,4.00000e-01,9.53500e-02,2.95100e-02,5.00000e-01,8.70700e-02,
2.97100e-02,6.00000e-01,8.05400e-02,2.95900e-02,8.00000e-01,7.07600e-02,2.89000e-02,1.00000e+00,6.36200e-02,2.79700e-02,
1.00000e-03,2.33900e+02,2.33500e+02,1.50000e-03,6.66800e+01,6.62900e+01,2.00000e-03,2.70700e+01,2.67200e+01,3.00000e-03,
7.54900e+00,7.24900e+00,4.00000e-03,3.11400e+00,2.84000e+00,5.00000e-03,1.61900e+00,1.36400e+00,6.00000e-03,9.87500e-01,
7.47700e-01,8.00000e-03,5.05400e-01,2.88800e-01,1.00000e-02,3.39500e-01,1.38700e-01,1.50000e-02,2.17600e-01,3.91000e-02,
2.00000e-02,1.85600e-01,1.88500e-02,3.00000e-02,1.64400e-01,1.13800e-02,4.00000e-02,1.55100e-01,1.13100e-02,5.00000e-02,
1.48800e-01,1.23700e-02,6.00000e-02,1.43800e-01,1.36100e-02,8.00000e-02,1.35600e-01,1.58800e-02,1.00000e-01,1.28900e-01,
1.77600e-02,1.50000e-01,1.15800e-01,2.09800e-02,2.00000e-01,1.06000e-01,2.29000e-02,3.00000e-01,9.21000e-02,2.48100e-02,
4.00000e-01,8.24900e-02,2.55200e-02,5.00000e-01,7.53200e-02,2.56900e-02,6.00000e-01,6.96800e-02,2.55900e-02,8.00000e-01,
6.12100e-02,2.49900e-02,1.00000e+00,5.50300e-02,2.41900e-02,1.00000e-03,6.04100e+02,6.03500e+02,1.50000e-03,1.79700e+02,
1.79100e+02,2.00000e-03,7.46900e+01,7.42200e+01,3.00000e-03,2.12700e+01,2.09000e+01,4.00000e-03,8.68500e+00,8.36700e+00,
5.00000e-03,4.36900e+00,4.08100e+00,6.00000e-03,2.52700e+00,2.26000e+00,8.00000e-03,1.12400e+00,8.83900e-01,1.00000e-02,
6.46600e-01,4.25500e-01,1.50000e-02,3.07000e-01,1.14300e-01,2.00000e-02,2.25100e-01,4.78000e-02,3.00000e-02,1.79200e-01,
1.89800e-02,4.00000e-02,1.64000e-01,1.43800e-02,5.00000e-02,1.55400e-01,1.40100e-02,6.00000e-02,1.49300e-01,1.46800e-02,
8.00000e-02,1.40100e-01,1.65800e-02,1.00000e-01,1.32800e-01,1.83600e-02,1.50000e-01,1.19000e-01,2.15700e-02,2.00000e-01,
1.08900e-01,2.35300e-02,3.00000e-01,9.46300e-02,2.54800e-02,4.00000e-01,8.47100e-02,2.62000e-02,5.00000e-01,7.73900e-02,
2.63900e-02,6.00000e-01,7.15500e-02,2.62700e-02,8.00000e-01,6.28600e-02,2.56500e-02,1.00000e+00,5.65200e-02,2.48300e-02,
1.00000e-03,1.22900e+03,1.22800e+03,1.50000e-03,3.76600e+02,3.75900e+02,2.00000e-03,1.59700e+02,1.59100e+02,3.00000e-03,
4.66700e+01,4.61700e+01,4.00000e-03,1.92700e+01,1.88600e+01,5.00000e-03,9.68300e+00,9.33200e+00,6.00000e-03,5.53800e+00,
5.22300e+00,8.00000e-03,2.34600e+00,2.07200e+00,1.00000e-02,1.25500e+00,1.00600e+00,1.50000e-02,4.82700e-01,2.69800e-01,
2.00000e-02,3.01400e-01,1.08400e-01,3.00000e-02,2.06300e-01,3.50600e-02,4.00000e-02,1.79300e-01,2.08400e-02,5.00000e-02,
1.66500e-01,1.73700e-02,6.00000e-02,1.58300e-01,1.68000e-02,8.00000e-02,1.47200e-01,1.78500e-02,1.00000e-01,1.39100e-01,
1.94000e-02,1.50000e-01,1.24300e-01,2.25500e-02,2.00000e-01,1.13600e-01,2.45300e-02,3.00000e-01,9.86200e-02,2.65400e-02,
4.00000e-01,8.83400e-02,2.73100e-02,5.00000e-01,8.06500e-02,2.74900e-02,6.00000e-01,7.46000e-02,2.73700e-02,8.00000e-01,
6.54900e-02,2.67100e-02,1.00000e+00,5.89000e-02,2.58600e-02,1.00000e-03,2.21100e+03,2.20900e+03,1.50000e-03,7.00200e+02,
6.99000e+02,2.00000e-03,3.02600e+02,3.01600e+02,3.00000e-03,9.03300e+01,8.96300e+01,4.00000e-03,3.77800e+01,3.72300e+01,
5.00000e-03,1.91200e+01,1.86600e+01,6.00000e-03,1.09500e+01,1.05400e+01,8.00000e-03,4.57600e+00,4.24200e+00,1.00000e-02,
2.37300e+00,2.07800e+00,1.50000e-02,8.07100e-01,5.62700e-01,2.00000e-02,4.42000e-01,2.23800e-01,3.00000e-02,2.56200e-01,
6.61400e-02,4.00000e-02,2.07600e-01,3.34300e-02,5.00000e-02,1.87100e-01,2.39700e-02,6.00000e-02,1.75300e-01,2.09800e-02,
8.00000e-02,1.61000e-01,2.03700e-02,1.00000e-01,1.51400e-01,2.14700e-02,1.50000e-01,1.34700e-01,2.44900e-02,2.00000e-01,
1.22900e-01,2.65500e-02,3.00000e-01,1.06600e-01,2.87000e-02,4.00000e-01,9.54600e-02,2.95000e-02,5.00000e-01,8.71500e-02,
2.96900e-02,6.00000e-01,8.05800e-02,2.95600e-02,8.00000e-01,7.07600e-02,2.88500e-02,1.00000e+00,6.36100e-02,2.79200e-02,
1.00000e-03,3.31100e+03,3.30600e+03,1.50000e-03,1.08300e+03,1.08000e+03,2.00000e-03,4.76900e+02,4.75500e+02,3.00000e-03,
1.45600e+02,1.44700e+02,4.00000e-03,6.16600e+01,6.09400e+01,5.00000e-03,3.14400e+01,3.08600e+01,6.00000e-03,1.80900e+01,
1.75900e+01,8.00000e-03,7.56200e+00,7.17000e+00,1.00000e-02,3.87900e+00,3.54500e+00,1.50000e-02,1.23600e+00,9.71500e-01,
2.00000e-02,6.17800e-01,3.86700e-01,3.00000e-02,3.06600e-01,1.09900e-01,4.00000e-02,2.28800e-01,5.05100e-02,5.00000e-02,
1.98000e-01,3.21700e-02,6.00000e-02,1.81700e-01,2.54800e-02,8.00000e-02,1.63900e-01,2.21100e-02,1.00000e-01,1.52900e-01,
2.23100e-02,1.50000e-01,1.35300e-01,2.47200e-02,2.00000e-01,1.23300e-01,2.66500e-02,3.00000e-01,1.06800e-01,2.87300e-02,
4.00000e-01,9.55700e-02,2.95200e-02,5.00000e-01,8.71900e-02,2.96900e-02,6.00000e-01,8.06300e-02,2.95600e-02,8.00000e-01,
7.08100e-02,2.88600e-02,1.00000e+00,6.36400e-02,2.79200e-02,1.00000e-03,4.59000e+03,4.57600e+03,1.50000e-03,1.54900e+03,
1.54500e+03,2.00000e-03,6.94900e+02,6.92600e+02,3.00000e-03,2.17100e+02,2.15800e+02,4.00000e-03,9.31500e+01,9.22100e+01,
5.00000e-03,4.79000e+01,4.71500e+01,6.00000e-03,2.77000e+01,2.70800e+01,8.00000e-03,1.16300e+01,1.11600e+01,1.00000e-02,
5.95200e+00,5.56500e+00,1.50000e-02,1.83600e+00,1.54500e+00,2.00000e-02,8.65100e-01,6.17900e-01,3.00000e-02,3.77900e-01,
1.72900e-01,4.00000e-02,2.58500e-01,7.53000e-02,5.00000e-02,2.13200e-01,4.41400e-02,6.00000e-02,1.90700e-01,3.20700e-02,
8.00000e-02,1.67800e-01,2.46800e-02,1.00000e-01,1.55100e-01,2.35500e-02,1.50000e-01,1.36100e-01,2.50600e-02,2.00000e-01,
1.23700e-01,2.67900e-02,3.00000e-01,1.07000e-01,2.87700e-02,4.00000e-01,9.56600e-02,2.95300e-02,5.00000e-01,8.72900e-02,
2.97100e-02,6.00000e-01,8.07000e-02,2.95700e-02,8.00000e-01,7.08700e-02,2.88700e-02,1.00000e+00,6.37200e-02,2.79400e-02,
1.00000e-03,5.64900e+03,5.61500e+03,1.50000e-03,1.97900e+03,1.96900e+03,2.00000e-03,9.04700e+02,9.00500e+02,3.00000e-03,
2.88800e+02,2.87000e+02,4.00000e-03,1.25600e+02,1.24400e+02,5.00000e-03,6.51400e+01,6.42400e+01,6.00000e-03,3.78900e+01,
3.71600e+01,8.00000e-03,1.60200e+01,1.54800e+01,1.00000e-02,8.20500e+00,7.77600e+00,1.50000e-02,2.49200e+00,2.18600e+00,
2.00000e-02,1.13300e+00,8.79600e-01,3.00000e-02,4.48700e-01,2.45100e-01,4.00000e-02,2.82800e-01,1.03600e-01,5.00000e-02,
2.21400e-01,5.74700e-02,6.00000e-02,1.92000e-01,3.90300e-02,8.00000e-02,1.63900e-01,2.67600e-02,1.00000e-01,1.49600e-01,
2.39400e-02,1.50000e-01,1.29800e-01,2.41700e-02,2.00000e-01,1.17600e-01,2.55400e-02,3.00000e-01,1.01500e-01,2.72900e-02,
4.00000e-01,9.07300e-02,2.80000e-02,5.00000e-01,8.27400e-02,2.81500e-02,6.00000e-01,7.64900e-02,2.80100e-02,8.00000e-01,
6.71700e-02,2.73400e-02,1.00000e+00,6.03700e-02,2.64500e-02,1.00000e-03,7.40900e+03,7.32600e+03,1.50000e-03,2.66600e+03,
2.64500e+03,2.00000e-03,1.24300e+03,1.23400e+03,3.00000e-03,4.05100e+02,4.02100e+02,4.00000e-03,1.78500e+02,1.76700e+02,
5.00000e-03,9.33900e+01,9.21400e+01,6.00000e-03,5.46700e+01,5.36900e+01,8.00000e-03,2.32800e+01,2.26000e+01,1.00000e-02,
1.19700e+01,1.14300e+01,1.50000e-02,3.61300e+00,3.25300e+00,2.00000e-02,1.60600e+00,1.31700e+00,3.00000e-02,5.92300e-01,
3.67600e-01,4.00000e-02,3.47300e-01,1.52800e-01,5.00000e-02,2.57900e-01,8.18200e-02,6.00000e-02,2.16100e-01,5.28700e-02,
8.00000e-02,1.78100e-01,3.27300e-02,1.00000e-01,1.60000e-01,2.73300e-02,1.50000e-01,1.37000e-01,2.59000e-02,2.00000e-01,
1.23600e-01,2.69700e-02,3.00000e-01,1.06400e-01,2.86200e-02,4.00000e-01,9.50200e-02,2.93100e-02,5.00000e-01,8.66400e-02,
2.94600e-02,6.00000e-01,8.00600e-02,2.93000e-02,8.00000e-01,7.02900e-02,2.86000e-02,1.00000e+00,6.31600e-02,2.76600e-02,
1.00000e-03,6.54200e+02,6.52200e+02,1.03542e-03,5.96000e+02,5.94100e+02,1.07210e-03,5.42900e+02,5.41000e+02,1.07210e-03,
6.43500e+03,6.32000e+03,1.50000e-03,3.19400e+03,3.15100e+03,2.00000e-03,1.52100e+03,1.50400e+03,3.00000e-03,5.07000e+02,
5.02300e+02,4.00000e-03,2.26100e+02,2.23800e+02,5.00000e-03,1.19400e+02,1.17800e+02,6.00000e-03,7.03000e+01,6.91500e+01,
8.00000e-03,3.01800e+01,2.94100e+01,1.00000e-02,1.55700e+01,1.49900e+01,1.50000e-02,4.69400e+00,4.31300e+00,2.00000e-02,
2.05700e+00,1.75900e+00,3.00000e-02,7.19700e-01,4.92800e-01,4.00000e-02,3.96900e-01,2.03100e-01,5.00000e-02,2.80400e-01,
1.06300e-01,6.00000e-02,2.26800e-01,6.62500e-02,8.00000e-02,1.79600e-01,3.76100e-02,1.00000e-01,1.58500e-01,2.93100e-02,
1.50000e-01,1.33500e-01,2.57900e-02,2.00000e-01,1.19900e-01,2.63500e-02,3.00000e-01,1.02900e-01,2.77100e-02,4.00000e-01,
9.18500e-02,2.83300e-02,5.00000e-01,8.37200e-02,2.84500e-02,6.00000e-01,7.73600e-02,2.83000e-02,8.00000e-01,6.78800e-02,
2.76000e-02,1.00000e+00,6.10000e-02,2.66900e-02,1.00000e-03,9.22500e+02,9.20300e+02,1.14237e-03,6.47400e+02,6.45200e+02,
1.30500e-03,4.53000e+02,4.50900e+02,1.30500e-03,5.44400e+03,5.31000e+03,1.50000e-03,4.00400e+03,3.91800e+03,2.00000e-03,
1.93200e+03,1.89900e+03,3.00000e-03,6.58500e+02,6.49900e+02,4.00000e-03,2.97400e+02,2.93700e+02,5.00000e-03,1.58300e+02,
1.56100e+02,6.00000e-03,9.38100e+01,9.22700e+01,8.00000e-03,4.06100e+01,3.96500e+01,1.00000e-02,2.10500e+01,2.03600e+01,
1.50000e-02,6.35800e+00,5.92500e+00,2.00000e-02,2.76300e+00,2.43200e+00,3.00000e-02,9.30600e-01,6.85500e-01,4.00000e-02,
4.88100e-01,2.81500e-01,5.00000e-02,3.29200e-01,1.45100e-01,6.00000e-02,2.57000e-01,8.82000e-02,8.00000e-02,1.95100e-01,
4.67100e-02,1.00000e-01,1.68600e-01,3.41000e-02,1.50000e-01,1.39400e-01,2.76600e-02,2.00000e-01,1.24500e-01,2.76100e-02,
3.00000e-01,1.06500e-01,2.87100e-02,4.00000e-01,9.49200e-02,2.92800e-02,5.00000e-01,8.64700e-02,2.93800e-02,6.00000e-01,
7.98800e-02,2.92100e-02,8.00000e-01,7.00800e-02,2.84800e-02,1.00000e+00,6.29600e-02,2.75300e-02,1.00000e-03,1.18500e+03,
1.18300e+03,1.50000e-03,4.02200e+02,4.00100e+02,1.55960e-03,3.62100e+02,3.60000e+02,1.55960e-03,3.95700e+03,3.82900e+03,
2.00000e-03,2.26300e+03,2.20400e+03,3.00000e-03,7.88000e+02,7.73200e+02,4.00000e-03,3.60500e+02,3.54500e+02,5.00000e-03,
1.93400e+02,1.90200e+02,6.00000e-03,1.15300e+02,1.13300e+02,8.00000e-03,5.03300e+01,4.91800e+01,1.00000e-02,2.62300e+01,
2.54300e+01,1.50000e-02,7.95500e+00,7.48700e+00,2.00000e-02,3.44100e+00,3.09400e+00,3.00000e-02,1.12800e+00,8.77800e-01,
4.00000e-02,5.68500e-01,3.60100e-01,5.00000e-02,3.68100e-01,1.84000e-01,6.00000e-02,2.77800e-01,1.09900e-01,8.00000e-02,
2.01800e-01,5.51100e-02,1.00000e-01,1.70400e-01,3.79400e-02,1.50000e-01,1.37800e-01,2.82700e-02,2.00000e-01,1.22300e-01,
2.74500e-02,3.00000e-01,1.04200e-01,2.81600e-02,4.00000e-01,9.27600e-02,2.86200e-02,5.00000e-01,8.44500e-02,2.86800e-02,
6.00000e-01,7.80200e-02,2.85100e-02,8.00000e-01,6.84100e-02,2.77800e-02,1.00000e+00,6.14600e-02,2.68600e-02,1.00000e-03,
1.57000e+03,1.56700e+03,1.50000e-03,5.35500e+02,5.33100e+02,1.83890e-03,3.09200e+02,3.07000e+02,1.83890e-03,3.19200e+03,
3.05900e+03,2.00000e-03,2.77700e+03,2.66900e+03,3.00000e-03,9.78400e+02,9.51600e+02,4.00000e-03,4.52900e+02,4.42700e+02,
5.00000e-03,2.45000e+02,2.40000e+02,6.00000e-03,1.47000e+02,1.43900e+02,8.00000e-03,6.46800e+01,6.31300e+01,1.00000e-02,
3.38900e+01,3.28900e+01,1.50000e-02,1.03400e+01,9.79400e+00,2.00000e-02,4.46400e+00,4.07600e+00,3.00000e-02,1.43600e+00,
1.16400e+00,4.00000e-02,7.01200e-01,4.78200e-01,5.00000e-02,4.38500e-01,2.43000e-01,6.00000e-02,3.20700e-01,1.43400e-01,
8.00000e-02,2.22800e-01,6.89600e-02,1.00000e-01,1.83500e-01,4.51300e-02,1.50000e-01,1.44800e-01,3.08600e-02,2.00000e-01,
1.27500e-01,2.90500e-02,3.00000e-01,1.08200e-01,2.93200e-02,4.00000e-01,9.61400e-02,2.96800e-02,5.00000e-01,8.74800e-02,
2.97100e-02,6.00000e-01,8.07700e-02,2.95100e-02,8.00000e-01,7.08200e-02,2.87500e-02,1.00000e+00,6.36100e-02,2.77800e-02,
1.00000e-03,1.91300e+03,1.91000e+03,1.50000e-03,6.54700e+02,6.52200e+02,2.00000e-03,3.01800e+02,2.99600e+02,2.14550e-03,
2.49400e+02,2.47300e+02,2.14550e-03,2.47300e+03,2.34300e+03,3.00000e-03,1.11800e+03,1.07400e+03,4.00000e-03,5.24200e+02,
5.07900e+02,5.00000e-03,2.86000e+02,2.78200e+02,6.00000e-03,1.72600e+02,1.68200e+02,8.00000e-03,7.66000e+01,7.45700e+01,
1.00000e-02,4.03500e+01,3.91200e+01,1.50000e-02,1.23900e+01,1.17900e+01,2.00000e-02,5.35200e+00,4.93900e+00,3.00000e-02,
1.70000e+00,1.42200e+00,4.00000e-02,8.09600e-01,5.85000e-01,5.00000e-02,4.91600e-01,2.96500e-01,6.00000e-02,3.49400e-01,
1.73500e-01,8.00000e-02,2.32400e-01,8.08300e-02,1.00000e-01,1.86500e-01,5.06800e-02,1.50000e-01,1.43200e-01,3.18800e-02,
2.00000e-01,1.25000e-01,2.89900e-02,3.00000e-01,1.05500e-01,2.87000e-02,4.00000e-01,9.35900e-02,2.89200e-02,5.00000e-01,
8.51100e-02,2.89100e-02,6.00000e-01,7.85400e-02,2.86900e-02,8.00000e-01,6.88400e-02,2.79300e-02,1.00000e+00,6.18200e-02,
2.69800e-02,1.00000e-03,2.42900e+03,2.42600e+03,1.50000e-03,8.34200e+02,8.31400e+02,2.00000e-03,3.85300e+02,3.82800e+02,
2.47200e-03,2.16800e+02,2.14500e+02,2.47200e-03,2.07000e+03,1.93500e+03,3.00000e-03,1.33900e+03,1.26500e+03,4.00000e-03,
6.33800e+02,6.06600e+02,5.00000e-03,3.48700e+02,3.36000e+02,6.00000e-03,2.11600e+02,2.04600e+02,8.00000e-03,9.46500e+01,
9.17100e+01,1.00000e-02,5.01200e+01,4.84700e+01,1.50000e-02,1.55000e+01,1.47700e+01,2.00000e-02,6.70800e+00,6.23500e+00,
3.00000e-02,2.11300e+00,1.80900e+00,4.00000e-02,9.87200e-01,7.46600e-01,5.00000e-02,5.84900e-01,3.77900e-01,6.00000e-02,
4.05300e-01,2.19900e-01,8.00000e-02,2.58500e-01,1.00000e-01,1.00000e-01,2.02000e-01,6.05200e-02,1.50000e-01,1.50600e-01,
3.51600e-02,2.00000e-01,1.30200e-01,3.08000e-02,3.00000e-01,1.09100e-01,2.98300e-02,4.00000e-01,9.66500e-02,2.99100e-02,
5.00000e-01,8.78100e-02,2.98400e-02,6.00000e-01,8.10200e-02,2.95900e-02,8.00000e-01,7.09800e-02,2.87800e-02,1.00000e+00,
6.37300e-02,2.78000e-02,1.00000e-03,2.83200e+03,2.82900e+03,1.50000e-03,9.77100e+02,9.74200e+02,2.00000e-03,4.52000e+02,
4.49400e+02,2.82240e-03,1.77400e+02,1.75200e+02,2.82240e-03,1.63700e+03,1.50600e+03,3.00000e-03,1.47300e+03,1.36100e+03,
4.00000e-03,7.03700e+02,6.62600e+02,5.00000e-03,3.90100e+02,3.71100e+02,6.00000e-03,2.38400e+02,2.28200e+02,8.00000e-03,
1.07500e+02,1.03400e+02,1.00000e-02,5.72500e+01,5.51000e+01,1.50000e-02,1.78400e+01,1.70000e+01,2.00000e-02,7.73900e+00,
7.22700e+00,3.00000e-02,2.42500e+00,2.11400e+00,4.00000e-02,1.11700e+00,8.75600e-01,5.00000e-02,6.48300e-01,4.43300e-01,
6.00000e-02,4.39500e-01,2.57000e-01,8.00000e-02,2.69600e-01,1.14800e-01,1.00000e-01,2.05000e-01,6.74500e-02,1.50000e-01,
1.48000e-01,3.63900e-02,2.00000e-01,1.26600e-01,3.06700e-02,3.00000e-01,1.05400e-01,2.89800e-02,4.00000e-01,9.31100e-02,
2.88700e-02,5.00000e-01,8.45300e-02,2.87400e-02,6.00000e-01,7.79500e-02,2.84700e-02,8.00000e-01,6.82600e-02,2.76700e-02,
1.00000e+00,6.12800e-02,2.67100e-02,1.00000e-03,3.18400e+03,3.18000e+03,1.50000e-03,1.10500e+03,1.10200e+03,2.00000e-03,
5.12000e+02,5.09300e+02,3.00000e-03,1.70300e+02,1.68200e+02,3.20290e-03,1.42400e+02,1.40300e+02,3.20290e-03,1.27500e+03,
1.15300e+03,4.00000e-03,7.57200e+02,6.97900e+02,5.00000e-03,4.22500e+02,3.95300e+02,6.00000e-03,2.59300e+02,2.44900e+02,
8.00000e-03,1.18000e+02,1.12500e+02,1.00000e-02,6.31600e+01,6.03800e+01,1.50000e-02,1.98300e+01,1.88600e+01,2.00000e-02,
8.62900e+00,8.07400e+00,3.00000e-02,2.69700e+00,2.38200e+00,4.00000e-02,1.22800e+00,9.90700e-01,5.00000e-02,7.01200e-01,
5.02000e-01,6.00000e-02,4.66400e-01,2.90400e-01,8.00000e-02,2.76000e-01,1.28000e-01,1.00000e-01,2.04300e-01,7.34400e-02,
1.50000e-01,1.42700e-01,3.70300e-02,2.00000e-01,1.20500e-01,2.99800e-02,3.00000e-01,9.95300e-02,2.75700e-02,4.00000e-01,
8.77600e-02,2.72700e-02,5.00000e-01,7.95800e-02,2.70800e-02,6.00000e-01,7.33500e-02,2.67900e-02,8.00000e-01,6.41900e-02,
2.60100e-02,1.00000e+00,5.76200e-02,2.51000e-02,1.00000e-03,4.05800e+03,4.05300e+03,1.50000e-03,1.41800e+03,1.41500e+03,
2.00000e-03,6.59200e+02,6.56300e+02,3.00000e-03,2.19800e+02,2.17400e+02,3.60740e-03,1.32700e+02,1.30600e+02,3.60740e-03,
1.20100e+03,1.06500e+03,4.00000e-03,9.25600e+02,8.30400e+02,5.00000e-03,5.18900e+02,4.75200e+02,6.00000e-03,3.20500e+02,
2.97400e+02,8.00000e-03,1.46900e+02,1.38300e+02,1.00000e-02,7.90700e+01,7.49000e+01,1.50000e-02,2.50300e+01,2.37000e+01,
2.00000e-02,1.09300e+01,1.02300e+01,3.00000e-02,3.41300e+00,3.04500e+00,4.00000e-02,1.54100e+00,1.27200e+00,5.00000e-02,
8.67900e-01,6.45400e-01,6.00000e-02,5.67800e-01,3.73000e-01,8.00000e-02,3.25100e-01,1.62800e-01,1.00000e-01,2.34500e-01,
9.16100e-02,1.50000e-01,1.58200e-01,4.34600e-02,2.00000e-01,1.31900e-01,3.37800e-02,3.00000e-01,1.08000e-01,3.01500e-02,
4.00000e-01,9.49500e-02,2.95900e-02,5.00000e-01,8.60000e-02,2.92900e-02,6.00000e-01,7.92200e-02,2.89500e-02,8.00000e-01,
6.92900e-02,2.80700e-02,1.00000e+00,6.21600e-02,2.70700e-02,1.00000e-03,4.86700e+03,4.86100e+03,1.50000e-03,1.71400e+03,
1.71000e+03,2.00000e-03,7.99900e+02,7.96600e+02,3.00000e-03,2.67600e+02,2.65000e+02,4.00000e-03,1.21800e+02,1.19700e+02,
4.03810e-03,1.18700e+02,1.16600e+02,4.03810e-03,1.02300e+03,8.88700e+02,5.00000e-03,6.02600e+02,5.37300e+02,6.00000e-03,
3.73100e+02,3.38700e+02,8.00000e-03,1.72600e+02,1.60000e+02,1.00000e-02,9.34100e+01,8.74400e+01,1.50000e-02,2.97900e+01,
2.80400e+01,2.00000e-02,1.30600e+01,1.22000e+01,3.00000e-02,4.08000e+00,3.66500e+00,4.00000e-02,1.83000e+00,1.53800e+00,
5.00000e-02,1.01900e+00,7.82200e-01,6.00000e-02,6.57800e-01,4.52000e-01,8.00000e-02,3.65600e-01,1.95800e-01,1.00000e-01,
2.57100e-01,1.08500e-01,1.50000e-01,1.67400e-01,4.87600e-02,2.00000e-01,1.37600e-01,3.63900e-02,3.00000e-01,1.11600e-01,
3.14600e-02,4.00000e-01,9.78300e-02,3.06000e-02,5.00000e-01,8.85100e-02,3.01900e-02,6.00000e-01,8.14800e-02,2.97900e-02,
8.00000e-01,7.12200e-02,2.88400e-02,1.00000e+00,6.38800e-02,2.78000e-02,1.00000e-03,5.23800e+03,5.23100e+03,1.50000e-03,
1.85800e+03,1.85300e+03,2.00000e-03,8.70600e+02,8.67200e+02,3.00000e-03,2.92200e+02,2.89600e+02,4.00000e-03,1.33200e+02,
1.31100e+02,4.49280e-03,9.68700e+01,9.49000e+01,4.49280e-03,8.14800e+02,6.91100e+02,5.00000e-03,6.30500e+02,5.43600e+02,
6.00000e-03,3.93300e+02,3.47400e+02,8.00000e-03,1.82800e+02,1.66100e+02,1.00000e-02,9.95200e+01,9.17500e+01,1.50000e-02,
3.20200e+01,2.98800e+01,2.00000e-02,1.40900e+01,1.31100e+01,3.00000e-02,4.40900e+00,3.97500e+00,4.00000e-02,1.96900e+00,
1.67700e+00,5.00000e-02,1.08700e+00,8.55200e-01,6.00000e-02,6.93200e-01,4.94400e-01,8.00000e-02,3.75300e-01,2.13200e-01,
1.00000e-01,2.57700e-01,1.16700e-01,1.50000e-01,1.61900e-01,4.99800e-02,2.00000e-01,1.31000e-01,3.58600e-02,3.00000e-01,
1.05200e-01,2.99700e-02,4.00000e-01,9.19300e-02,2.88700e-02,5.00000e-01,8.30500e-02,2.83700e-02,6.00000e-01,7.63900e-02,
2.79500e-02,8.00000e-01,6.67500e-02,2.70300e-02,1.00000e+00,5.98500e-02,2.60300e-02,1.00000e-03,5.86900e+03,5.86000e+03,
1.50000e-03,2.09600e+03,2.09100e+03,2.00000e-03,9.86000e+02,9.82400e+02,3.00000e-03,3.32300e+02,3.29500e+02,4.00000e-03,
1.51700e+02,1.49400e+02,4.96640e-03,8.38000e+01,8.18800e+01,4.96640e-03,6.87800e+02,5.68400e+02,5.00000e-03,6.83800e+02,
5.65700e+02,6.00000e-03,4.32300e+02,3.69100e+02,8.00000e-03,2.02300e+02,1.79300e+02,1.00000e-02,1.10700e+02,1.00100e+02,
1.50000e-02,3.58700e+01,3.31100e+01,2.00000e-02,1.58500e+01,1.46500e+01,3.00000e-02,4.97200e+00,4.48800e+00,4.00000e-02,
2.21400e+00,1.90400e+00,5.00000e-02,1.21300e+00,9.73700e-01,6.00000e-02,7.66100e-01,5.63400e-01,8.00000e-02,4.05200e-01,
2.42200e-01,1.00000e-01,2.72100e-01,1.31200e-01,1.50000e-01,1.64900e-01,5.39300e-02,2.00000e-01,1.31400e-01,3.72600e-02,
3.00000e-01,1.04300e-01,3.00700e-02,4.00000e-01,9.08100e-02,2.86400e-02,5.00000e-01,8.19100e-02,2.80400e-02,6.00000e-01,
7.52900e-02,2.75600e-02,8.00000e-01,6.57200e-02,2.66100e-02,1.00000e+00,5.89100e-02,2.56100e-02,1.00000e-03,6.49500e+03,
6.48300e+03,1.50000e-03,2.34200e+03,2.33600e+03,2.00000e-03,1.10600e+03,1.10200e+03,3.00000e-03,3.74300e+02,3.71300e+02,
4.00000e-03,1.71200e+02,1.68800e+02,5.00000e-03,9.29100e+01,9.08900e+01,5.46510e-03,7.27700e+01,7.09000e+01,5.46510e-03,
5.87000e+02,4.71700e+02,6.00000e-03,4.68700e+02,3.84100e+02,8.00000e-03,2.21700e+02,1.90800e+02,1.00000e-02,1.21800e+02,
1.07700e+02,1.50000e-02,3.98300e+01,3.62700e+01,2.00000e-02,1.76800e+01,1.62000e+01,3.00000e-02,5.56400e+00,5.01500e+00,
4.00000e-02,2.47200e+00,2.14000e+00,5.00000e-02,1.34700e+00,1.09800e+00,6.00000e-02,8.43800e-01,6.36400e-01,8.00000e-02,
4.37100e-01,2.73100e-01,1.00000e-01,2.87700e-01,1.46900e-01,1.50000e-01,1.68200e-01,5.82100e-02,2.00000e-01,1.31800e-01,
3.87900e-02,3.00000e-01,1.03400e-01,3.01900e-02,4.00000e-01,8.96500e-02,2.84300e-02,5.00000e-01,8.07400e-02,2.77000e-02,
6.00000e-01,7.41400e-02,2.71700e-02,8.00000e-01,6.46600e-02,2.61800e-02,1.00000e+00,5.79400e-02,2.51800e-02,1.00000e-03,
7.40500e+03,7.38800e+03,1.50000e-03,2.69400e+03,2.68700e+03,2.00000e-03,1.27700e+03,1.27200e+03,3.00000e-03,4.33900e+02,
4.30500e+02,4.00000e-03,1.98800e+02,1.96100e+02,5.00000e-03,1.08000e+02,1.05700e+02,5.98920e-03,6.57400e+01,6.38300e+01,
5.98920e-03,5.97700e+02,4.02700e+02,6.00000e-03,5.16000e+02,4.02700e+02,8.00000e-03,2.51300e+02,2.08700e+02,1.00000e-02,
1.38600e+02,1.19300e+02,1.50000e-02,4.57100e+01,4.09300e+01,2.00000e-02,2.03800e+01,1.84600e+01,3.00000e-02,6.43400e+00,
5.78000e+00,4.00000e-02,2.85600e+00,2.48200e+00,5.00000e-02,1.55000e+00,1.27800e+00,6.00000e-02,9.63900e-01,7.42000e-01,
8.00000e-02,4.90500e-01,3.18200e-01,1.00000e-01,3.16600e-01,1.70100e-01,1.50000e-01,1.78800e-01,6.53600e-02,2.00000e-01,
1.37800e-01,4.21100e-02,3.00000e-01,1.06700e-01,3.16000e-02,4.00000e-01,9.21300e-02,2.93800e-02,5.00000e-01,8.28100e-02,
2.84900e-02,6.00000e-01,7.59800e-02,2.78800e-02,8.00000e-01,6.62000e-02,2.68000e-02,1.00000e+00,5.93000e-02,2.57600e-02,
1.00000e-03,8.09300e+03,8.06900e+03,1.50000e-03,2.98400e+03,2.97500e+03,2.00000e-03,1.42100e+03,1.41500e+03,3.00000e-03,
4.85100e+02,4.81500e+02,4.00000e-03,2.22900e+02,2.20100e+02,5.00000e-03,1.21200e+02,1.18800e+02,6.00000e-03,7.35000e+01,
7.15000e+01,6.53900e-03,5.80300e+01,5.61900e+01,6.53900e-03,4.52000e+02,3.41500e+02,8.00000e-03,2.73400e+02,2.17700e+02,
1.00000e-02,1.51400e+02,1.26200e+02,1.50000e-02,5.02700e+01,4.41400e+01,2.00000e-02,2.25300e+01,2.01500e+01,3.00000e-02,
7.14100e+00,6.38200e+00,4.00000e-02,3.16900e+00,2.75700e+00,5.00000e-02,1.71400e+00,1.42500e+00,6.00000e-02,1.06000e+00,
8.29400e-01,8.00000e-02,5.30600e-01,3.55800e-01,1.00000e-01,3.36700e-01,1.89400e-01,1.50000e-01,1.83800e-01,7.08500e-02,
2.00000e-01,1.39100e-01,4.42100e-02,3.00000e-01,1.06200e-01,3.19600e-02,4.00000e-01,9.13300e-02,2.93200e-02,5.00000e-01,
8.19200e-02,2.82700e-02,6.00000e-01,7.50900e-02,2.76000e-02,8.00000e-01,6.53700e-02,2.64700e-02,1.00000e+00,5.85200e-02,
2.54100e-02,1.00000e-03,9.08500e+03,9.05200e+03,1.50000e-03,3.39900e+03,3.38800e+03,2.00000e-03,1.62600e+03,1.62000e+03,
3.00000e-03,5.57600e+02,5.53500e+02,4.00000e-03,2.56700e+02,2.53600e+02,5.00000e-03,1.39800e+02,1.37200e+02,6.00000e-03,
8.48400e+01,8.26500e+01,7.11200e-03,5.31900e+01,5.13300e+01,7.11200e-03,4.07600e+02,2.97800e+02,8.00000e-03,3.05600e+02,
2.31600e+02,1.00000e-02,1.70600e+02,1.36900e+02,1.50000e-02,5.70800e+01,4.89600e+01,2.00000e-02,2.56800e+01,2.26000e+01,
3.00000e-02,8.17600e+00,7.25100e+00,4.00000e-02,3.62900e+00,3.15500e+00,5.00000e-02,1.95800e+00,1.63800e+00,6.00000e-02,
1.20500e+00,9.55500e-01,8.00000e-02,5.95200e-01,4.10400e-01,1.00000e-01,3.71700e-01,2.17700e-01,1.50000e-01,1.96400e-01,
7.96100e-02,2.00000e-01,1.46000e-01,4.82500e-02,3.00000e-01,1.09900e-01,3.36100e-02,4.00000e-01,9.40000e-02,3.03900e-02,
5.00000e-01,8.41400e-02,2.91400e-02,6.00000e-01,7.70400e-02,2.83600e-02,8.00000e-01,6.69900e-02,2.71400e-02,1.00000e+00,
5.99500e-02,2.60300e-02,1.00000e-03,9.79600e+03,9.75000e+03,1.50000e-03,3.69700e+03,3.68200e+03,2.00000e-03,1.77900e+03,
1.77100e+03,3.00000e-03,6.12900e+02,6.08400e+02,4.00000e-03,2.83000e+02,2.79600e+02,5.00000e-03,1.54300e+02,1.51500e+02,
6.00000e-03,9.37000e+01,9.13800e+01,7.70890e-03,4.71000e+01,4.53000e+01,7.70890e-03,3.55500e+02,2.50700e+02,8.00000e-03,
3.24800e+02,2.32200e+02,1.00000e-02,1.84100e+02,1.41300e+02,1.50000e-02,6.20100e+01,5.17800e+01,2.00000e-02,2.80300e+01,
2.42100e+01,3.00000e-02,8.96200e+00,7.87300e+00,4.00000e-02,3.98100e+00,3.45000e+00,5.00000e-02,2.14400e+00,1.79900e+00,
6.00000e-02,1.31400e+00,1.05200e+00,8.00000e-02,6.41400e-01,4.52800e-01,1.00000e-01,3.94900e-01,2.39700e-01,1.50000e-01,
2.02300e-01,8.59700e-02,2.00000e-01,1.47600e-01,5.07100e-02,3.00000e-01,1.09400e-01,3.40600e-02,4.00000e-01,9.31100e-02,
3.03400e-02,5.00000e-01,8.31500e-02,2.89000e-02,6.00000e-01,7.60400e-02,2.80500e-02,8.00000e-01,6.60400e-02,2.67700e-02,
1.00000e+00,5.90600e-02,2.56400e-02,1.00000e-03,9.85500e+03,9.79700e+03,1.00404e-03,9.75300e+03,9.69700e+03,1.00810e-03,
9.65400e+03,9.59800e+03,1.00810e-03,1.09900e+04,1.09300e+04,1.50000e-03,4.23400e+03,4.21400e+03,2.00000e-03,2.04900e+03,
2.03900e+03,3.00000e-03,7.09400e+02,7.04200e+02,4.00000e-03,3.28200e+02,3.24400e+02,5.00000e-03,1.79300e+02,1.76100e+02,
6.00000e-03,1.09000e+02,1.06400e+02,8.00000e-03,4.95200e+01,4.75800e+01,8.33280e-03,4.42800e+01,4.24200e+01,8.33280e-03,
3.29400e+02,2.24000e+02,1.00000e-02,2.09000e+02,1.52400e+02,1.50000e-02,7.08100e+01,5.73400e+01,2.00000e-02,3.22000e+01,
2.72200e+01,3.00000e-02,1.03400e+01,8.98200e+00,4.00000e-02,4.60000e+00,3.96700e+00,5.00000e-02,2.47400e+00,2.07800e+00,
6.00000e-02,1.51200e+00,1.21900e+00,8.00000e-02,7.30600e-01,5.25900e-01,1.00000e-01,4.44000e-01,2.78100e-01,1.50000e-01,
2.20800e-01,9.81200e-02,2.00000e-01,1.58200e-01,5.64900e-02,3.00000e-01,1.15400e-01,3.65900e-02,4.00000e-01,9.76500e-02,
3.20900e-02,5.00000e-01,8.69800e-02,3.03600e-02,6.00000e-01,7.94400e-02,2.93700e-02,8.00000e-01,6.89100e-02,2.79500e-02,
1.00000e+00,6.16000e-02,2.67400e-02,1.00000e-03,1.05700e+04,1.04900e+04,1.04695e-03,9.30700e+03,9.24100e+03,1.09610e-03,
8.24200e+03,8.18600e+03,1.09610e-03,9.34700e+03,9.28200e+03,1.50000e-03,4.41800e+03,4.39300e+03,2.00000e-03,2.15400e+03,
2.14200e+03,3.00000e-03,7.48800e+02,7.43000e+02,4.00000e-03,3.47300e+02,3.43200e+02,5.00000e-03,1.89900e+02,1.86600e+02,
6.00000e-03,1.15600e+02,1.12800e+02,8.00000e-03,5.25500e+01,5.05400e+01,8.97890e-03,3.82900e+01,3.65200e+01,8.97890e-03,
2.78400e+02,1.82400e+02,1.00000e-02,2.15900e+02,1.48400e+02,1.50000e-02,7.40500e+01,5.78800e+01,2.00000e-02,3.37900e+01,
2.78800e+01,3.00000e-02,1.09200e+01,9.34900e+00,4.00000e-02,4.86200e+00,4.16300e+00,5.00000e-02,2.61300e+00,2.19200e+00,
6.00000e-02,1.59300e+00,1.29000e+00,8.00000e-02,7.63000e-01,5.58100e-01,1.00000e-01,4.58400e-01,2.94900e-01,1.50000e-01,
2.21700e-01,1.02700e-01,2.00000e-01,1.55900e-01,5.78100e-02,3.00000e-01,1.11900e-01,3.61700e-02,4.00000e-01,9.41300e-02,
3.12100e-02,5.00000e-01,8.36200e-02,2.93300e-02,6.00000e-01,7.62500e-02,2.82600e-02,8.00000e-01,6.60500e-02,2.68100e-02,
1.00000e+00,5.90100e-02,2.56200e-02,1.00000e-03,1.55300e+03,1.54800e+03,1.00980e-03,1.51800e+03,1.51300e+03,1.01970e-03,
1.48400e+03,1.47800e+03,1.01970e-03,3.80400e+03,3.77700e+03,1.03119e-03,5.09700e+03,5.05700e+03,1.04280e-03,6.51800e+03,
6.46400e+03,1.04280e-03,8.27400e+03,8.20200e+03,1.11565e-03,8.45200e+03,8.38200e+03,1.19360e-03,7.37100e+03,7.31200e+03,
1.19360e-03,8.39600e+03,8.32800e+03,1.50000e-03,4.82500e+03,4.79100e+03,2.00000e-03,2.37500e+03,2.35900e+03,3.00000e-03,
8.31100e+02,8.24400e+02,4.00000e-03,3.86500e+02,3.82000e+02,5.00000e-03,2.11800e+02,2.08200e+02,6.00000e-03,1.29000e+02,
1.26100e+02,8.00000e-03,5.87500e+01,5.66000e+01,9.65860e-03,3.50500e+01,3.33200e+01,9.65860e-03,2.53600e+02,1.59900e+02,
1.00000e-02,2.33100e+02,1.49700e+02,1.50000e-02,8.11700e+01,6.09900e+01,2.00000e-02,3.71900e+01,2.98600e+01,3.00000e-02,
1.20700e+01,1.01800e+01,4.00000e-02,5.38400e+00,4.57000e+00,5.00000e-02,2.89200e+00,2.41900e+00,6.00000e-02,1.76000e+00,
1.42900e+00,8.00000e-02,8.36400e-01,6.20300e-01,1.00000e-01,4.97300e-01,3.27800e-01,1.50000e-01,2.34100e-01,1.12800e-01,
2.00000e-01,1.61700e-01,6.22500e-02,3.00000e-01,1.14100e-01,3.76400e-02,4.00000e-01,9.53900e-02,3.19500e-02,5.00000e-01,
8.45000e-02,2.97900e-02,6.00000e-01,7.69500e-02,2.86100e-02,8.00000e-01,6.65600e-02,2.70400e-02,1.00000e+00,5.94100e-02,
2.58000e-02,1.00000e-03,1.69700e+03,1.69200e+03,1.05613e-03,1.49200e+03,1.48700e+03,1.11540e-03,1.31200e+03,1.30700e+03,
1.11540e-03,3.99000e+03,3.95500e+03,1.12877e-03,4.88700e+03,4.84200e+03,1.14230e-03,5.66400e+03,5.61100e+03,1.14230e-03,
7.40500e+03,7.33200e+03,1.21752e-03,7.13800e+03,7.07000e+03,1.29770e-03,6.35800e+03,6.29900e+03,1.29770e-03,7.20600e+03,
7.13900e+03,1.50000e-03,5.08700e+03,5.04400e+03,2.00000e-03,2.51500e+03,2.49600e+03,3.00000e-03,8.85700e+02,8.78200e+02,
4.00000e-03,4.13000e+02,4.08200e+02,5.00000e-03,2.26600e+02,2.22900e+02,6.00000e-03,1.38200e+02,1.35200e+02,8.00000e-03,
6.30200e+01,6.08200e+01,1.00000e-02,3.42100e+01,3.25000e+01,1.03671e-02,3.09900e+01,2.93600e+01,1.03671e-02,2.21400e+02,
1.34400e+02,1.50000e-02,8.53700e+01,6.13500e+01,2.00000e-02,3.92800e+01,3.05900e+01,3.00000e-02,1.28100e+01,1.06100e+01,
4.00000e-02,5.72600e+00,4.81000e+00,5.00000e-02,3.07600e+00,2.56000e+00,6.00000e-02,1.86800e+00,1.51800e+00,8.00000e-02,
8.82300e-01,6.61300e-01,1.00000e-01,5.19700e-01,3.49700e-01,1.50000e-01,2.38700e-01,1.19300e-01,2.00000e-01,1.61900e-01,
6.46300e-02,3.00000e-01,1.12300e-01,3.78200e-02,4.00000e-01,9.32500e-02,3.15600e-02,5.00000e-01,8.23600e-02,2.92000e-02,
6.00000e-01,7.48700e-02,2.79300e-02,8.00000e-01,6.46600e-02,2.63100e-02,1.00000e+00,5.76700e-02,2.50600e-02,1.00000e-03,
1.89300e+03,1.88700e+03,1.10304e-03,1.50200e+03,1.49600e+03,1.21670e-03,1.19000e+03,1.18500e+03,1.21670e-03,4.38900e+03,
4.34300e+03,1.23215e-03,4.73400e+03,4.68400e+03,1.24780e-03,4.97400e+03,4.92200e+03,1.24780e-03,6.69800e+03,6.62200e+03,
1.32844e-03,6.34800e+03,6.27900e+03,1.41430e-03,5.55400e+03,5.49500e+03,1.41430e-03,6.28700e+03,6.22100e+03,1.50000e-03,
5.47500e+03,5.42000e+03,2.00000e-03,2.71100e+03,2.68800e+03,3.00000e-03,9.61300e+02,9.52700e+02,4.00000e-03,4.49700e+02,
4.44500e+02,5.00000e-03,2.47200e+02,2.43300e+02,6.00000e-03,1.50900e+02,1.47700e+02,8.00000e-03,6.89000e+01,6.66000e+01,
1.00000e-02,3.74200e+01,3.56400e+01,1.11031e-02,2.81100e+01,2.65300e+01,1.11031e-02,1.98100e+02,1.15700e+02,1.50000e-02,
9.15200e+01,6.25600e+01,2.00000e-02,4.22200e+01,3.17800e+01,3.00000e-02,1.38500e+01,1.12600e+01,4.00000e-02,6.20700e+00,
5.15200e+00,5.00000e-02,3.33500e+00,2.75900e+00,6.00000e-02,2.02300e+00,1.64200e+00,8.00000e-02,9.50100e-01,7.18400e-01,
1.00000e-01,5.55000e-01,3.80300e-01,1.50000e-01,2.49100e-01,1.28800e-01,2.00000e-01,1.66100e-01,6.86500e-02,3.00000e-01,
1.13100e-01,3.89100e-02,4.00000e-01,9.32700e-02,3.19300e-02,5.00000e-01,8.21200e-02,2.93000e-02,6.00000e-01,7.45200e-02,
2.79000e-02,8.00000e-01,6.42600e-02,2.61800e-02,1.00000e+00,5.72700e-02,2.48900e-02,1.00000e-03,2.12100e+03,2.11600e+03,
1.15026e-03,1.52300e+03,1.51700e+03,1.32310e-03,1.09200e+03,1.08700e+03,1.32310e-03,4.51300e+03,4.45900e+03,1.34073e-03,
4.46900e+03,4.41600e+03,1.35860e-03,4.45200e+03,4.39800e+03,1.35860e-03,6.09300e+03,6.01500e+03,1.50000e-03,5.22700e+03,
5.16400e+03,1.52650e-03,4.99700e+03,4.93800e+03,1.52650e-03,5.65300e+03,5.58500e+03,2.00000e-03,2.93100e+03,2.90200e+03,
3.00000e-03,1.04900e+03,1.03900e+03,4.00000e-03,4.92000e+02,4.86200e+02,5.00000e-03,2.70900e+02,2.66700e+02,6.00000e-03,
1.65600e+02,1.62200e+02,8.00000e-03,7.57300e+01,7.33000e+01,1.00000e-02,4.11500e+01,3.92800e+01,1.18667e-02,2.57700e+01,
2.42500e+01,1.18667e-02,1.79200e+02,1.00800e+02,1.50000e-02,9.85600e+01,6.37100e+01,2.00000e-02,4.56400e+01,3.31000e+01,
3.00000e-02,1.50600e+01,1.19800e+01,4.00000e-02,6.76000e+00,5.53700e+00,5.00000e-02,3.63500e+00,2.98300e+00,6.00000e-02,
2.20300e+00,1.78300e+00,8.00000e-02,1.03000e+00,7.83700e-01,1.00000e-01,5.97100e-01,4.15500e-01,1.50000e-01,2.62200e-01,
1.39900e-01,2.00000e-01,1.71900e-01,7.35000e-02,3.00000e-01,1.15000e-01,4.04300e-02,4.00000e-01,9.41400e-02,3.26100e-02,
5.00000e-01,8.25900e-02,2.96600e-02,6.00000e-01,7.48300e-02,2.81300e-02,8.00000e-01,6.44000e-02,2.62800e-02,1.00000e+00,
5.73500e-02,2.49400e-02,1.00000e-03,2.31700e+03,2.31200e+03,1.19825e-03,1.51200e+03,1.50600e+03,1.43580e-03,9.81400e+02,
9.76000e+02,1.43580e-03,4.34700e+03,4.28700e+03,1.45586e-03,4.05700e+03,4.00200e+03,1.47620e-03,3.90700e+03,3.85500e+03,
1.47620e-03,5.18600e+03,5.11200e+03,1.50000e-03,5.33600e+03,5.26000e+03,1.65390e-03,4.34200e+03,4.28400e+03,1.65390e-03,
4.91500e+03,4.84900e+03,2.00000e-03,3.09800e+03,3.06200e+03,3.00000e-03,1.11600e+03,1.10400e+03,4.00000e-03,5.25200e+02,
5.18700e+02,5.00000e-03,2.89600e+02,2.85100e+02,6.00000e-03,1.77300e+02,1.73700e+02,8.00000e-03,8.11600e+01,7.86500e+01,
1.00000e-02,4.41400e+01,4.22100e+01,1.26578e-02,2.31800e+01,2.17300e+01,1.26578e-02,1.58900e+02,8.59900e+01,1.50000e-02,
1.03300e+02,6.27000e+01,2.00000e-02,4.81800e+01,3.35200e+01,3.00000e-02,1.59600e+01,1.24000e+01,4.00000e-02,7.18400e+00,
5.79600e+00,5.00000e-02,3.86400e+00,3.14300e+00,6.00000e-02,2.34100e+00,1.88600e+00,8.00000e-02,1.09000e+00,8.33200e-01,
1.00000e-01,6.27800e-01,4.42600e-01,1.50000e-01,2.70300e-01,1.48300e-01,2.00000e-01,1.74200e-01,7.69500e-02,3.00000e-01,
1.14400e-01,4.11300e-02,4.00000e-01,9.29900e-02,3.26100e-02,5.00000e-01,8.12900e-02,2.94100e-02,6.00000e-01,7.35000e-02,
2.77500e-02,8.00000e-01,6.31400e-02,2.58100e-02,1.00000e+00,5.61900e-02,2.44600e-02,1.00000e-03,2.62400e+03,2.61800e+03,
1.50000e-03,1.00200e+03,9.96400e+02,1.54990e-03,9.25500e+02,9.20000e+02,1.54990e-03,4.28900e+03,4.22300e+03,1.57278e-03,
3.83800e+03,3.78000e+03,1.59600e-03,3.58700e+03,3.53400e+03,1.59600e-03,5.09700e+03,5.01400e+03,1.68644e-03,4.59500e+03,
4.52300e+03,1.78200e-03,3.96900e+03,3.91000e+03,1.78200e-03,4.49500e+03,4.42700e+03,2.00000e-03,3.40700e+03,3.36000e+03,
3.00000e-03,1.23100e+03,1.21600e+03,4.00000e-03,5.81500e+02,5.74000e+02,5.00000e-03,3.21300e+02,3.16300e+02,6.00000e-03,
1.96800e+02,1.93000e+02,8.00000e-03,9.02600e+01,8.75600e+01,1.00000e-02,4.91200e+01,4.70600e+01,1.34737e-02,2.17600e+01,
2.03300e+01,1.34737e-02,1.47100e+02,7.66800e+01,1.50000e-02,1.11900e+02,6.33600e+01,2.00000e-02,5.26600e+01,3.50200e+01,
3.00000e-02,1.75300e+01,1.32800e+01,4.00000e-02,7.90000e+00,6.26700e+00,5.00000e-02,4.26400e+00,3.43100e+00,6.00000e-02,
2.58200e+00,2.06800e+00,8.00000e-02,1.19800e+00,9.18500e-01,1.00000e-01,6.86100e-01,4.89000e-01,1.50000e-01,2.89900e-01,
1.63400e-01,2.00000e-01,1.83800e-01,8.37800e-02,3.00000e-01,1.18600e-01,4.36000e-02,4.00000e-01,9.56300e-02,3.39800e-02,
5.00000e-01,8.32800e-02,3.03600e-02,6.00000e-01,7.51500e-02,2.85100e-02,8.00000e-01,6.44300e-02,2.64000e-02,1.00000e+00,
5.72800e-02,2.49600e-02,1.00000e-03,2.85400e+03,2.84800e+03,1.50000e-03,1.09300e+03,1.08700e+03,1.67490e-03,8.36100e+02,
8.30500e+02,1.67490e-03,3.90900e+03,3.84200e+03,1.70085e-03,3.40900e+03,3.35200e+03,1.72720e-03,3.16600e+03,3.11400e+03,
1.72720e-03,4.56600e+03,4.48400e+03,1.82152e-03,4.01400e+03,3.94500e+03,1.92100e-03,3.48200e+03,3.42500e+03,1.92100e-03,
3.94800e+03,3.88200e+03,2.00000e-03,3.59900e+03,3.54100e+03,3.00000e-03,1.30500e+03,1.28800e+03,4.00000e-03,6.18600e+02,
6.10100e+02,5.00000e-03,3.42500e+02,3.37100e+02,6.00000e-03,2.10100e+02,2.06000e+02,8.00000e-03,9.65100e+01,9.37100e+01,
1.00000e-02,5.25700e+01,5.04400e+01,1.43256e-02,1.97100e+01,1.83600e+01,1.43256e-02,1.31300e+02,6.60400e+01,1.50000e-02,
1.16800e+02,6.11200e+01,2.00000e-02,5.54800e+01,3.50900e+01,3.00000e-02,1.85400e+01,1.36500e+01,4.00000e-02,8.38900e+00,
6.53800e+00,5.00000e-02,4.52300e+00,3.59600e+00,6.00000e-02,2.73900e+00,2.17800e+00,8.00000e-02,1.26700e+00,9.72900e-01,
1.00000e-01,7.22100e-01,5.19200e-01,1.50000e-01,2.99800e-01,1.73100e-01,2.00000e-01,1.87200e-01,8.78700e-02,3.00000e-01,
1.18600e-01,4.45900e-02,4.00000e-01,9.48000e-02,3.41400e-02,5.00000e-01,8.22600e-02,3.02300e-02,6.00000e-01,7.41000e-02,
2.82500e-02,8.00000e-01,6.34000e-02,2.60300e-02,1.00000e+00,5.63100e-02,2.45600e-02,1.00000e-03,3.17400e+03,3.16800e+03,
1.50000e-03,1.21900e+03,1.21300e+03,1.80440e-03,7.78200e+02,7.72600e+02,1.80440e-03,3.09600e+03,3.04000e+03,1.83391e-03,
2.96900e+03,2.91500e+03,1.86390e-03,2.86100e+03,2.81000e+03,1.86390e-03,3.95700e+03,3.88000e+03,2.00000e-03,3.41000e+03,
3.34700e+03,2.06510e-03,3.15300e+03,3.09600e+03,2.06510e-03,3.60600e+03,3.54000e+03,3.00000e-03,1.41800e+03,1.39700e+03,
4.00000e-03,6.74800e+02,6.64800e+02,5.00000e-03,3.74400e+02,3.68200e+02,6.00000e-03,2.30000e+02,2.25500e+02,8.00000e-03,
1.05800e+02,1.02800e+02,1.00000e-02,5.76600e+01,5.54100e+01,1.50000e-02,1.90900e+01,1.77500e+01,1.51997e-02,1.84200e+01,
1.70900e+01,1.51997e-02,1.20800e+02,5.86400e+01,2.00000e-02,5.98000e+01,3.58100e+01,3.00000e-02,2.00900e+01,1.43600e+01,
4.00000e-02,9.11200e+00,6.96300e+00,5.00000e-02,4.91800e+00,3.85800e+00,6.00000e-02,2.97900e+00,2.34900e+00,8.00000e-02,
1.37500e+00,1.05600e+00,1.00000e-01,7.79900e-01,5.64900e-01,1.50000e-01,3.18700e-01,1.88100e-01,2.00000e-01,1.96000e-01,
9.46500e-02,3.00000e-01,1.21900e-01,4.69000e-02,4.00000e-01,9.67000e-02,3.53100e-02,5.00000e-01,8.36000e-02,3.09800e-02,
6.00000e-01,7.51000e-02,2.87800e-02,8.00000e-01,6.41200e-02,2.63800e-02,1.00000e+00,5.68900e-02,2.48400e-02,1.00000e-03,
3.49400e+03,3.48700e+03,1.50000e-03,1.34700e+03,1.34100e+03,1.93960e-03,7.20700e+02,7.15200e+02,1.93960e-03,2.86400e+03,
2.80700e+03,2.00000e-03,2.58900e+03,2.53900e+03,2.00680e-03,2.57100e+03,2.52100e+03,2.00680e-03,3.57700e+03,3.50100e+03,
2.10895e-03,3.20100e+03,3.13400e+03,2.21630e-03,2.84200e+03,2.78600e+03,2.21630e-03,3.24100e+03,3.17600e+03,3.00000e-03,
1.52500e+03,1.50000e+03,4.00000e-03,7.29700e+02,7.18100e+02,5.00000e-03,4.05800e+02,3.98800e+02,6.00000e-03,2.49600e+02,
2.44600e+02,8.00000e-03,1.15000e+02,1.11800e+02,1.00000e-02,6.27400e+01,6.03700e+01,1.50000e-02,2.07900e+01,1.93800e+01,
1.61046e-02,1.71400e+01,1.58500e+01,1.61046e-02,1.10800e+02,5.20000e+01,2.00000e-02,6.38600e+01,3.60200e+01,3.00000e-02,
2.15700e+01,1.49300e+01,4.00000e-02,9.81800e+00,7.34600e+00,5.00000e-02,5.30600e+00,4.10300e+00,6.00000e-02,3.21400e+00,
2.51100e+00,8.00000e-02,1.48100e+00,1.13500e+00,1.00000e-01,8.36500e-01,6.09300e-01,1.50000e-01,3.36900e-01,2.02800e-01,
2.00000e-01,2.04200e-01,1.01300e-01,3.00000e-01,1.24700e-01,4.90600e-02,4.00000e-01,9.81100e-02,3.63400e-02,5.00000e-01,
8.44300e-02,3.15600e-02,6.00000e-01,7.57000e-02,2.91700e-02,8.00000e-01,6.44700e-02,2.66000e-02,1.00000e+00,5.71400e-02,
2.49800e-02,1.00000e-03,3.86400e+03,3.85700e+03,1.50000e-03,1.49300e+03,1.48700e+03,2.00000e-03,7.42200e+02,7.36500e+02,
2.08000e-03,6.73800e+02,6.68200e+02,2.08000e-03,2.62700e+03,2.56900e+03,2.11741e-03,2.46600e+03,2.41200e+03,2.15550e-03,
2.34200e+03,2.29200e+03,2.15550e-03,3.26400e+03,3.18700e+03,2.26140e-03,2.91600e+03,2.84900e+03,2.37250e-03,2.59700e+03,
2.54000e+03,2.37250e-03,2.96200e+03,2.89700e+03,3.00000e-03,1.65400e+03,1.62300e+03,4.00000e-03,7.93600e+02,7.79800e+02,
5.00000e-03,4.42400e+02,4.34400e+02,6.00000e-03,2.72500e+02,2.67000e+02,8.00000e-03,1.25800e+02,1.22400e+02,1.00000e-02,
6.87100e+01,6.61900e+01,1.50000e-02,2.27900e+01,2.13000e+01,1.70384e-02,1.61200e+01,1.48600e+01,1.70384e-02,1.02900e+02,
4.67200e+01,2.00000e-02,6.85500e+01,3.62000e+01,3.00000e-02,2.33000e+01,1.55800e+01,4.00000e-02,1.06500e+01,7.79000e+00,
5.00000e-02,5.76400e+00,4.38800e+00,6.00000e-02,3.49300e+00,2.69900e+00,8.00000e-02,1.60700e+00,1.22800e+00,1.00000e-01,
9.04700e-01,6.61600e-01,1.50000e-01,3.59500e-01,2.20300e-01,2.00000e-01,2.14900e-01,1.09300e-01,3.00000e-01,1.28900e-01,
5.18600e-02,4.00000e-01,1.00600e-01,3.77900e-02,5.00000e-01,8.61300e-02,3.24900e-02,6.00000e-01,7.70300e-02,2.98600e-02,
8.00000e-01,6.54600e-02,2.70800e-02,1.00000e+00,5.79500e-02,2.53700e-02,1.00000e-03,4.21000e+03,4.20300e+03,1.50000e-03,
1.63100e+03,1.62500e+03,2.00000e-03,8.11500e+02,8.05700e+02,2.22230e-03,6.25800e+02,6.20100e+02,2.22230e-03,2.39200e+03,
2.33500e+03,2.26411e-03,2.23900e+03,2.18600e+03,2.30670e-03,2.12000e+03,2.07100e+03,2.30670e-03,2.95300e+03,2.87800e+03,
2.41654e-03,2.64100e+03,2.57500e+03,2.53160e-03,2.35900e+03,2.30300e+03,2.53160e-03,2.69100e+03,2.62700e+03,3.00000e-03,
1.77200e+03,1.73400e+03,4.00000e-03,8.50700e+02,8.34400e+02,5.00000e-03,4.75500e+02,4.66400e+02,6.00000e-03,2.93500e+02,
2.87300e+02,8.00000e-03,1.35600e+02,1.32000e+02,1.00000e-02,7.41700e+01,7.15000e+01,1.50000e-02,2.46300e+01,2.30800e+01,
1.79976e-02,1.50100e+01,1.38000e+01,1.79976e-02,9.47000e+01,4.16400e+01,2.00000e-02,7.23700e+01,3.55500e+01,3.00000e-02,
2.48500e+01,1.60000e+01,4.00000e-02,1.13900e+01,8.12900e+00,5.00000e-02,6.17300e+00,4.62100e+00,6.00000e-02,3.74400e+00,
2.85900e+00,8.00000e-02,1.72100e+00,1.31000e+00,1.00000e-01,9.65800e-01,7.08000e-01,1.50000e-01,3.79000e-01,2.36100e-01,
2.00000e-01,2.23700e-01,1.16400e-01,3.00000e-01,1.31800e-01,5.42000e-02,4.00000e-01,1.01800e-01,3.88500e-02,5.00000e-01,
8.69300e-02,3.31100e-02,6.00000e-01,7.75600e-02,3.02500e-02,8.00000e-01,6.57100e-02,2.72600e-02,1.00000e+00,5.81000e-02,
2.54700e-02,1.00000e-03,4.60000e+03,4.59200e+03,1.50000e-03,1.78600e+03,1.78000e+03,2.00000e-03,8.89300e+02,8.83200e+02,
2.37050e-03,5.84400e+02,5.78600e+02,2.37050e-03,2.18100e+03,2.12500e+03,2.41714e-03,2.04500e+03,1.99200e+03,2.46470e-03,
1.93500e+03,1.88600e+03,2.46470e-03,2.69400e+03,2.61900e+03,2.57857e-03,2.41200e+03,2.34700e+03,2.69770e-03,2.16100e+03,
2.10400e+03,2.69770e-03,2.47000e+03,2.40500e+03,3.00000e-03,1.90600e+03,1.85900e+03,4.00000e-03,9.16400e+02,8.97000e+02,
5.00000e-03,5.13400e+02,5.02700e+02,6.00000e-03,3.17200e+02,3.10300e+02,8.00000e-03,1.46900e+02,1.42900e+02,1.00000e-02,
8.03800e+01,7.75400e+01,1.50000e-02,2.67200e+01,2.50800e+01,1.89856e-02,1.40900e+01,1.29100e+01,1.89856e-02,8.78400e+01,
3.74600e+01,2.00000e-02,7.71200e+01,3.49300e+01,3.00000e-02,2.66600e+01,1.64800e+01,4.00000e-02,1.22300e+01,8.51100e+00,
5.00000e-02,6.64400e+00,4.88400e+00,6.00000e-02,4.03200e+00,3.04000e+00,8.00000e-02,1.85200e+00,1.40300e+00,1.00000e-01,
1.03700e+00,7.60800e-01,1.50000e-01,4.02300e-01,2.54200e-01,2.00000e-01,2.34400e-01,1.24700e-01,3.00000e-01,1.35700e-01,
5.70500e-02,4.00000e-01,1.04000e-01,4.02600e-02,5.00000e-01,8.83100e-02,3.39600e-02,6.00000e-01,7.85800e-02,3.08500e-02,
8.00000e-01,6.64200e-02,2.76400e-02,1.00000e+00,5.86600e-02,2.57500e-02,1.00000e-03,4.94200e+03,4.93500e+03,1.50000e-03,
1.92500e+03,1.91800e+03,2.00000e-03,9.59300e+02,9.53100e+02,2.52020e-03,5.41500e+02,5.35800e+02,2.52020e-03,1.97900e+03,
1.92400e+03,2.57212e-03,1.85400e+03,1.80200e+03,2.62510e-03,1.75000e+03,1.70300e+03,2.62510e-03,2.43300e+03,2.36000e+03,
2.74267e-03,2.18300e+03,2.11900e+03,2.86550e-03,1.96100e+03,1.90600e+03,2.86550e-03,2.24300e+03,2.17900e+03,3.00000e-03,
2.01100e+03,1.95600e+03,4.00000e-03,9.70300e+02,9.47500e+02,5.00000e-03,5.45000e+02,5.32800e+02,6.00000e-03,3.37300e+02,
3.29500e+02,8.00000e-03,1.56500e+02,1.52200e+02,1.00000e-02,8.57600e+01,8.27500e+01,1.50000e-02,2.85400e+01,2.68400e+01,
1.99995e-02,1.30800e+01,1.19300e+01,1.99995e-02,8.05500e+01,3.29300e+01,2.00000e-02,8.05400e+01,3.33600e+01,3.00000e-02,
2.81000e+01,1.66400e+01,4.00000e-02,1.29400e+01,8.75700e+00,5.00000e-02,7.03700e+00,5.07400e+00,6.00000e-02,4.27400e+00,
3.17800e+00,8.00000e-02,1.96200e+00,1.47700e+00,1.00000e-01,1.09600e+00,8.04200e-01,1.50000e-01,4.20800e-01,2.69300e-01,
2.00000e-01,2.42300e-01,1.31600e-01,3.00000e-01,1.37900e-01,5.91900e-02,4.00000e-01,1.04700e-01,4.11700e-02,5.00000e-01,
8.84800e-02,3.43700e-02,6.00000e-01,7.85100e-02,3.10400e-02,8.00000e-01,6.61900e-02,2.76400e-02,1.00000e+00,5.83700e-02,
2.56700e-02,1.00000e-03,5.35600e+03,5.34800e+03,1.50000e-03,2.09200e+03,2.08500e+03,2.00000e-03,1.04400e+03,1.03700e+03,
2.67690e-03,5.07200e+02,5.01400e+02,2.67690e-03,1.81200e+03,1.75800e+03,2.73443e-03,1.69900e+03,1.64800e+03,2.79320e-03,
1.60200e+03,1.55500e+03,2.79320e-03,2.22300e+03,2.15100e+03,3.00000e-03,1.86200e+03,1.80500e+03,3.04250e-03,1.80000e+03,
1.74500e+03,3.04250e-03,2.05900e+03,1.99500e+03,4.00000e-03,1.03600e+03,1.00900e+03,5.00000e-03,5.83600e+02,5.69400e+02,
6.00000e-03,3.61900e+02,3.53000e+02,8.00000e-03,1.68300e+02,1.63500e+02,1.00000e-02,9.23100e+01,8.90800e+01,1.50000e-02,
3.07600e+01,2.89800e+01,2.00000e-02,1.41000e+01,1.29000e+01,2.10440e-02,1.22900e+01,1.11700e+01,2.10440e-02,7.48100e+01,
3.01400e+01,3.00000e-02,2.99300e+01,1.69300e+01,4.00000e-02,1.38100e+01,9.07500e+00,5.00000e-02,7.52100e+00,5.31200e+00,
6.00000e-02,4.57100e+00,3.34800e+00,8.00000e-02,2.09900e+00,1.56800e+00,1.00000e-01,1.16900e+00,8.57200e-01,1.50000e-01,
4.44900e-01,2.88000e-01,2.00000e-01,2.53400e-01,1.40300e-01,3.00000e-01,1.41800e-01,6.21400e-02,4.00000e-01,1.06600e-01,
4.25700e-02,5.00000e-01,8.96800e-02,3.52100e-02,6.00000e-01,7.93500e-02,3.15900e-02,8.00000e-01,6.67400e-02,2.79700e-02,
1.00000e+00,5.87600e-02,2.58900e-02,1.00000e-03,5.71800e+03,5.70900e+03,1.50000e-03,2.24000e+03,2.23300e+03,2.00000e-03,
1.12000e+03,1.11300e+03,2.83790e-03,4.70400e+02,4.64600e+02,2.83790e-03,1.64400e+03,1.59100e+03,2.90168e-03,1.54200e+03,
1.49200e+03,2.96690e-03,1.45200e+03,1.40700e+03,2.96690e-03,2.31700e+03,2.23300e+03,3.00000e-03,1.96300e+03,1.89400e+03,
3.22400e-03,1.63800e+03,1.58400e+03,3.22400e-03,1.87400e+03,1.81100e+03,4.00000e-03,1.09500e+03,1.06300e+03,5.00000e-03,
6.16500e+02,6.00000e+02,6.00000e-03,3.83200e+02,3.73100e+02,8.00000e-03,1.78500e+02,1.73300e+02,1.00000e-02,9.80000e+01,
9.45600e+01,1.50000e-02,3.27000e+01,3.08500e+01,2.00000e-02,1.49900e+01,1.37600e+01,2.21172e-02,1.14300e+01,1.03500e+01,
2.21172e-02,6.87600e+01,2.70000e+01,3.00000e-02,3.13900e+01,1.68900e+01,4.00000e-02,1.45200e+01,9.25100e+00,5.00000e-02,
7.92600e+00,5.47700e+00,6.00000e-02,4.82200e+00,3.47600e+00,8.00000e-02,2.21500e+00,1.64100e+00,1.00000e-01,1.23200e+00,
9.01200e-01,1.50000e-01,4.64700e-01,3.03700e-01,2.00000e-01,2.61800e-01,1.47500e-01,3.00000e-01,1.44000e-01,6.44500e-02,
4.00000e-01,1.07400e-01,4.35500e-02,5.00000e-01,8.99200e-02,3.56700e-02,6.00000e-01,7.93300e-02,3.18200e-02,8.00000e-01,
6.64700e-02,2.79600e-02,1.00000e+00,5.84600e-02,2.58100e-02,1.00000e-03,6.16900e+03,6.16000e+03,1.50000e-03,2.42600e+03,
2.41900e+03,2.00000e-03,1.21400e+03,1.20700e+03,3.00000e-03,4.44100e+02,4.38200e+02,3.00380e-03,4.42700e+02,4.36800e+02,
3.00380e-03,1.51300e+03,1.46100e+03,3.07413e-03,1.42200e+03,1.37200e+03,3.14610e-03,1.33700e+03,1.29200e+03,3.14610e-03,
1.84700e+03,1.77700e+03,3.27631e-03,1.67100e+03,1.60800e+03,3.41190e-03,1.51200e+03,1.45800e+03,3.41190e-03,1.73100e+03,
1.66900e+03,4.00000e-03,1.17000e+03,1.13200e+03,5.00000e-03,6.58900e+02,6.39600e+02,6.00000e-03,4.10100e+02,3.98500e+02,
8.00000e-03,1.91500e+02,1.85700e+02,1.00000e-02,1.05300e+02,1.01500e+02,1.50000e-02,3.51800e+01,3.32200e+01,2.00000e-02,
1.61300e+01,1.48400e+01,2.32199e-02,1.07900e+01,9.73600e+00,2.32199e-02,6.41400e+01,2.45800e+01,3.00000e-02,3.33000e+01,
1.69900e+01,4.00000e-02,1.54400e+01,9.52000e+00,5.00000e-02,8.44800e+00,5.70600e+00,6.00000e-02,5.14700e+00,3.64900e+00,
8.00000e-02,2.36500e+00,1.73700e+00,1.00000e-01,1.31400e+00,9.58100e-01,1.50000e-01,4.91600e-01,3.24100e-01,2.00000e-01,
2.74200e-01,1.57100e-01,3.00000e-01,1.48500e-01,6.77600e-02,4.00000e-01,1.09700e-01,4.51700e-02,5.00000e-01,9.13400e-02,
3.66300e-02,6.00000e-01,8.03500e-02,3.24700e-02,8.00000e-01,6.71100e-02,2.83400e-02,1.00000e+00,5.89400e-02,2.60800e-02,
1.00000e-03,6.53800e+03,6.52900e+03,1.50000e-03,2.57900e+03,2.57100e+03,2.00000e-03,1.29200e+03,1.28500e+03,3.00000e-03,
4.73000e+02,4.66800e+02,3.17330e-03,4.10600e+02,4.04700e+02,3.17330e-03,1.35500e+03,1.30500e+03,3.25085e-03,1.28700e+03,
1.23800e+03,3.33030e-03,1.21500e+03,1.17100e+03,3.33030e-03,1.66400e+03,1.59700e+03,3.46459e-03,1.51800e+03,1.45600e+03,
3.60430e-03,1.37900e+03,1.32600e+03,3.60430e-03,1.58200e+03,1.52000e+03,4.00000e-03,1.22700e+03,1.18200e+03,5.00000e-03,
6.91200e+02,6.68800e+02,6.00000e-03,4.30800e+02,4.17500e+02,8.00000e-03,2.01700e+02,1.95300e+02,1.00000e-02,1.11000e+02,
1.07000e+02,1.50000e-02,3.71500e+01,3.51100e+01,2.00000e-02,1.70400e+01,1.57100e+01,2.43503e-02,1.00300e+01,9.01600e+00,
2.43503e-02,5.89800e+01,2.20800e+01,3.00000e-02,3.46500e+01,1.66900e+01,4.00000e-02,1.61400e+01,9.61100e+00,5.00000e-02,
8.85000e+00,5.83300e+00,6.00000e-02,5.39900e+00,3.75900e+00,8.00000e-02,2.48100e+00,1.80400e+00,1.00000e-01,1.37700e+00,
1.00000e+00,1.50000e-01,5.11500e-01,3.39700e-01,2.00000e-01,2.82700e-01,1.64400e-01,3.00000e-01,1.50600e-01,7.00700e-02,
4.00000e-01,1.10300e-01,4.61100e-02,5.00000e-01,9.13400e-02,3.70400e-02,6.00000e-01,8.01000e-02,3.26200e-02,8.00000e-01,
6.66900e-02,2.82800e-02,1.00000e+00,5.84900e-02,2.59400e-02,1.00000e-03,7.03900e+03,7.02900e+03,1.50000e-03,2.79000e+03,
2.78200e+03,2.00000e-03,1.40100e+03,1.39300e+03,3.00000e-03,5.13600e+02,5.07300e+02,3.35110e-03,3.88700e+02,3.82700e+02,
3.35110e-03,1.27400e+03,1.22300e+03,3.43632e-03,1.20000e+03,1.15100e+03,3.52370e-03,1.12600e+03,1.08200e+03,3.52370e-03,
1.54700e+03,1.47900e+03,3.66203e-03,1.40900e+03,1.34800e+03,3.80580e-03,1.28200e+03,1.22900e+03,3.80580e-03,1.46800e+03,
1.40600e+03,4.00000e-03,1.30500e+03,1.25200e+03,5.00000e-03,7.38500e+02,7.12200e+02,6.00000e-03,4.61000e+02,4.45700e+02,
8.00000e-03,2.16400e+02,2.09200e+02,1.00000e-02,1.19300e+02,1.14900e+02,1.50000e-02,3.99800e+01,3.78000e+01,2.00000e-02,
1.83600e+01,1.69500e+01,2.55140e-02,9.52700e+00,8.53400e+00,2.55140e-02,5.53900e+01,2.03100e+01,3.00000e-02,3.66800e+01,
1.66000e+01,4.00000e-02,1.72000e+01,9.86900e+00,5.00000e-02,9.44400e+00,6.06600e+00,6.00000e-02,5.76600e+00,3.93800e+00,
8.00000e-02,2.65100e+00,1.90700e+00,1.00000e-01,1.47000e+00,1.06200e+00,1.50000e-01,5.42600e-01,3.62200e-01,2.00000e-01,
2.97200e-01,1.75100e-01,3.00000e-01,1.56000e-01,7.39200e-02,4.00000e-01,1.13100e-01,4.80300e-02,5.00000e-01,9.32100e-02,
3.82200e-02,6.00000e-01,8.15300e-02,3.34700e-02,8.00000e-01,6.76600e-02,2.88100e-02,1.00000e+00,5.92100e-02,2.63200e-02,
1.00000e-03,7.35000e+03,7.34000e+03,1.50000e-03,2.93100e+03,2.92200e+03,2.00000e-03,1.47300e+03,1.46600e+03,3.00000e-03,
5.41400e+02,5.35000e+02,3.53750e-03,3.57500e+02,3.51700e+02,3.53750e-03,1.15200e+03,1.10300e+03,3.63101e-03,1.08300e+03,
1.03600e+03,3.72700e-03,1.01300e+03,9.71500e+02,3.72700e-03,1.38900e+03,1.32400e+03,4.00000e-03,1.17000e+03,1.11800e+03,
4.01800e-03,1.15700e+03,1.10600e+03,4.01800e-03,1.32400e+03,1.26400e+03,5.00000e-03,7.68500e+02,7.38300e+02,6.00000e-03,
4.79300e+02,4.61900e+02,8.00000e-03,2.25400e+02,2.17400e+02,1.00000e-02,1.24400e+02,1.19700e+02,1.50000e-02,4.17800e+01,
3.95200e+01,2.00000e-02,1.92000e+01,1.77600e+01,2.67112e-02,8.80900e+00,7.86300e+00,2.67112e-02,5.06500e+01,1.82100e+01,
3.00000e-02,3.76500e+01,1.59400e+01,4.00000e-02,1.77800e+01,9.81200e+00,5.00000e-02,9.77900e+00,6.11500e+00,6.00000e-02,
5.97500e+00,4.00100e+00,8.00000e-02,2.75100e+00,1.95700e+00,1.00000e-01,1.52400e+00,1.09600e+00,1.50000e-01,5.59300e-01,
3.75300e-01,2.00000e-01,3.03800e-01,1.81300e-01,3.00000e-01,1.57100e-01,7.58000e-02,4.00000e-01,1.12900e-01,4.86800e-02,
5.00000e-01,9.25000e-02,3.83800e-02,6.00000e-01,8.06400e-02,3.33900e-02,8.00000e-01,6.67000e-02,2.85400e-02,1.00000e+00,
5.82600e-02,2.59700e-02,1.00000e-03,7.80900e+03,7.79700e+03,1.50000e-03,3.13100e+03,3.12200e+03,2.00000e-03,1.57800e+03,
1.57000e+03,3.00000e-03,5.80800e+02,5.74300e+02,3.73010e-03,3.35600e+02,3.29800e+02,3.73010e-03,1.04600e+03,9.98900e+02,
3.83264e-03,9.93000e+02,9.46500e+02,3.93800e-03,9.31300e+02,8.90500e+02,3.93800e-03,1.26100e+03,1.19900e+03,4.00000e-03,
1.23100e+03,1.17000e+03,4.23750e-03,1.06600e+03,1.01600e+03,4.23750e-03,1.22300e+03,1.16400e+03,5.00000e-03,8.13400e+02,
7.78000e+02,6.00000e-03,5.07200e+02,4.87100e+02,8.00000e-03,2.39100e+02,2.30100e+02,1.00000e-02,1.32100e+02,1.26900e+02,
1.50000e-02,4.44500e+01,4.20600e+01,2.00000e-02,2.04400e+01,1.89300e+01,2.79399e-02,8.31600e+00,7.39500e+00,2.79399e-02,
4.73300e+01,1.67000e+01,3.00000e-02,3.94900e+01,1.55300e+01,4.00000e-02,1.87300e+01,9.91100e+00,5.00000e-02,1.03000e+01,
6.26200e+00,6.00000e-02,6.30600e+00,4.13500e+00,8.00000e-02,2.90700e+00,2.04300e+00,1.00000e-01,1.60900e+00,1.15000e+00,
1.50000e-01,5.87600e-01,3.96000e-01,2.00000e-01,3.16700e-01,1.91300e-01,3.00000e-01,1.61400e-01,7.92300e-02,4.00000e-01,
1.14900e-01,5.03100e-02,5.00000e-01,9.37100e-02,3.93200e-02,6.00000e-01,8.13800e-02,3.39800e-02,8.00000e-01,6.70700e-02,
2.88300e-02,1.00000e+00,5.84900e-02,2.61500e-02,1.00000e-03,8.15700e+03,8.14400e+03,1.50000e-03,3.29600e+03,3.28700e+03,
2.00000e-03,1.66500e+03,1.65700e+03,3.00000e-03,6.14300e+02,6.07700e+02,3.92880e-03,3.11400e+02,3.05800e+02,3.92880e-03,
9.28500e+02,8.84500e+02,4.00000e-03,9.39300e+02,8.94500e+02,4.15610e-03,8.46900e+02,8.07400e+02,4.15610e-03,1.14500e+03,
1.08400e+03,4.30764e-03,1.06000e+03,1.00200e+03,4.46470e-03,9.71200e+02,9.22100e+02,4.46470e-03,1.11700e+03,1.05900e+03,
5.00000e-03,8.47100e+02,8.06400e+02,6.00000e-03,5.29400e+02,5.06500e+02,8.00000e-03,2.50000e+02,2.40000e+02,1.00000e-02,
1.38400e+02,1.32700e+02,1.50000e-02,4.66400e+01,4.41300e+01,2.00000e-02,2.14600e+01,1.99000e+01,2.92001e-02,7.76000e+00,
6.87600e+00,2.92001e-02,4.36000e+01,1.51400e+01,3.00000e-02,4.12100e+01,1.49000e+01,4.00000e-02,1.94200e+01,9.83500e+00,
5.00000e-02,1.07000e+01,6.31400e+00,6.00000e-02,6.56400e+00,4.21100e+00,8.00000e-02,3.02900e+00,2.10100e+00,1.00000e-01,
1.67600e+00,1.18900e+00,1.50000e-01,6.09100e-01,4.11900e-01,2.00000e-01,3.26000e-01,1.99000e-01,3.00000e-01,1.63900e-01,
8.17900e-02,4.00000e-01,1.15600e-01,5.13800e-02,5.00000e-01,9.37400e-02,3.98000e-02,6.00000e-01,8.11300e-02,3.41700e-02,
8.00000e-01,6.66200e-02,2.87800e-02,1.00000e+00,5.80000e-02,2.60100e-02,1.00000e-03,8.58200e+03,8.56800e+03,1.50000e-03,
3.49100e+03,3.48100e+03,2.00000e-03,1.76700e+03,1.75900e+03,3.00000e-03,6.53600e+02,6.46900e+02,4.00000e-03,3.16900e+02,
3.11300e+02,4.13220e-03,2.91800e+02,2.86300e+02,4.13220e-03,8.69100e+02,8.25200e+02,4.25449e-03,8.30800e+02,7.86500e+02,
4.38040e-03,7.77600e+02,7.39200e+02,4.38040e-03,1.05000e+03,9.90600e+02,4.53657e-03,9.74300e+02,9.17800e+02,4.69830e-03,
8.93900e+02,8.45700e+02,4.69830e-03,1.02900e+03,9.72500e+02,5.00000e-03,8.84600e+02,8.37700e+02,6.00000e-03,5.56900e+02,
5.30500e+02,8.00000e-03,2.63100e+02,2.51800e+02,1.00000e-02,1.45900e+02,1.39600e+02,1.50000e-02,4.92300e+01,4.65700e+01,
2.00000e-02,2.26800e+01,2.10500e+01,3.00000e-02,7.63100e+00,6.75500e+00,3.04912e-02,7.30700e+00,6.45200e+00,3.04912e-02,
4.07300e+01,1.39100e+01,4.00000e-02,2.02700e+01,9.78900e+00,5.00000e-02,1.12000e+01,6.40000e+00,6.00000e-02,6.87900e+00,
4.31100e+00,8.00000e-02,3.17600e+00,2.17300e+00,1.00000e-01,1.75800e+00,1.23700e+00,1.50000e-01,6.36100e-01,4.31200e-01,
2.00000e-01,3.38100e-01,2.08400e-01,3.00000e-01,1.67700e-01,8.50400e-02,4.00000e-01,1.17200e-01,5.28800e-02,5.00000e-01,
9.45300e-02,4.06100e-02,6.00000e-01,8.15300e-02,3.46500e-02,8.00000e-01,6.67000e-02,2.89600e-02,1.00000e+00,5.79700e-02,
2.60800e-02,1.00000e-03,8.43400e+03,8.41900e+03,1.00300e-03,8.38000e+03,8.36500e+03,1.00600e-03,8.32600e+03,8.31100e+03,
1.00600e-03,8.68400e+03,8.66800e+03,1.50000e-03,3.60800e+03,3.59800e+03,2.00000e-03,1.83200e+03,1.82400e+03,3.00000e-03,
6.79200e+02,6.72600e+02,4.00000e-03,3.29700e+02,3.24000e+02,4.34140e-03,2.67800e+02,2.62500e+02,4.34140e-03,7.88200e+02,
7.46000e+02,4.47465e-03,7.50400e+02,7.07800e+02,4.61200e-03,6.99500e+02,6.62900e+02,4.61200e-03,9.44500e+02,8.88000e+02,
4.77280e-03,8.78200e+02,8.23700e+02,4.93920e-03,8.06200e+02,7.60000e+02,4.93920e-03,9.29200e+02,8.74400e+02,5.00000e-03,
9.01400e+02,8.48700e+02,6.00000e-03,5.72100e+02,5.42300e+02,8.00000e-03,2.70200e+02,2.57800e+02,1.00000e-02,1.50100e+02,
1.43300e+02,1.50000e-02,5.07800e+01,4.80200e+01,2.00000e-02,2.34100e+01,2.17500e+01,3.00000e-02,7.87800e+00,6.99700e+00,
3.18138e-02,6.73800e+00,5.92900e+00,3.18138e-02,3.71900e+01,1.25100e+01,4.00000e-02,2.06400e+01,9.48000e+00,5.00000e-02,
1.14500e+01,6.33000e+00,6.00000e-02,7.04100e+00,4.30600e+00,8.00000e-02,3.25500e+00,2.19500e+00,1.00000e-01,1.80100e+00,
1.25600e+00,1.50000e-01,6.49200e-01,4.40900e-01,2.00000e-01,3.42900e-01,2.13200e-01,3.00000e-01,1.67900e-01,8.64600e-02,
4.00000e-01,1.16300e-01,5.32600e-02,5.00000e-01,9.32800e-02,4.05500e-02,6.00000e-01,8.02200e-02,3.44000e-02,8.00000e-01,
6.53800e-02,2.85400e-02,1.00000e+00,5.66900e-02,2.55900e-02,1.00000e-03,9.09600e+03,9.07800e+03,1.03542e-03,8.46500e+03,
8.44800e+03,1.07210e-03,7.86300e+03,7.84700e+03,1.07210e-03,8.19800e+03,8.18100e+03,1.50000e-03,3.91900e+03,3.90800e+03,
2.00000e-03,1.99700e+03,1.98800e+03,3.00000e-03,7.42000e+02,7.35100e+02,4.00000e-03,3.60700e+02,3.54800e+02,4.55710e-03,
2.59200e+02,2.53700e+02,4.55710e-03,7.55000e+02,7.12100e+02,4.70229e-03,7.12300e+02,6.72400e+02,4.85210e-03,6.63600e+02,
6.27000e+02,4.85210e-03,8.94300e+02,8.37500e+02,5.00000e-03,8.43000e+02,7.90300e+02,5.18810e-03,7.66500e+02,7.19800e+02,
5.18810e-03,8.83700e+02,8.28300e+02,6.00000e-03,6.17300e+02,5.82200e+02,8.00000e-03,2.92200e+02,2.77700e+02,1.00000e-02,
1.62600e+02,1.54800e+02,1.50000e-02,5.51200e+01,5.20800e+01,2.00000e-02,2.54300e+01,2.36300e+01,3.00000e-02,8.56100e+00,
7.62200e+00,3.31694e-02,6.55300e+00,5.74400e+00,3.31694e-02,3.58200e+01,1.18800e+01,4.00000e-02,2.21000e+01,9.61600e+00,
5.00000e-02,1.23200e+01,6.57300e+00,6.00000e-02,7.57900e+00,4.51800e+00,8.00000e-02,3.51000e+00,2.33100e+00,1.00000e-01,
1.94200e+00,1.34200e+00,1.50000e-01,6.97800e-01,4.74200e-01,2.00000e-01,3.66300e-01,2.29500e-01,3.00000e-01,1.77100e-01,
9.25700e-02,4.00000e-01,1.21700e-01,5.65000e-02,5.00000e-01,9.70100e-02,4.26700e-02,6.00000e-01,8.31300e-02,3.59800e-02,
8.00000e-01,6.74900e-02,2.96200e-02,1.00000e+00,5.84100e-02,2.64600e-02,1.00000e-03,9.41300e+03,9.39300e+03,1.07191e-03,
8.15100e+03,8.13200e+03,1.14900e-03,7.03500e+03,7.01900e+03,1.14900e-03,7.33800e+03,7.32100e+03,1.50000e-03,4.08500e+03,
4.07300e+03,2.00000e-03,2.08800e+03,2.07800e+03,3.00000e-03,7.78000e+02,7.70900e+02,4.00000e-03,3.78700e+02,3.72800e+02,
4.78220e-03,2.40800e+02,2.35500e+02,4.78220e-03,6.94100e+02,6.52400e+02,5.00000e-03,6.39200e+02,6.01500e+02,5.10370e-03,
6.04400e+02,5.69300e+02,5.10370e-03,8.18100e+02,7.63000e+02,5.27536e-03,7.57900e+02,7.07900e+02,5.45280e-03,6.99100e+02,
6.53900e+02,5.45280e-03,8.06400e+02,7.52700e+02,6.00000e-03,6.37600e+02,5.97900e+02,8.00000e-03,3.03200e+02,2.87100e+02,
1.00000e-02,1.69000e+02,1.60500e+02,1.50000e-02,5.74300e+01,5.42000e+01,2.00000e-02,2.65200e+01,2.46500e+01,3.00000e-02,
8.93000e+00,7.96900e+00,3.45614e-02,6.12900e+00,5.35200e+00,3.45614e-02,3.31600e+01,1.08600e+01,4.00000e-02,2.27000e+01,
9.32300e+00,5.00000e-02,1.27200e+01,6.54000e+00,6.00000e-02,7.82500e+00,4.54100e+00,8.00000e-02,3.63300e+00,2.37400e+00,
1.00000e-01,2.01100e+00,1.37600e+00,1.50000e-01,7.20200e-01,4.89400e-01,2.00000e-01,3.76000e-01,2.37300e-01,3.00000e-01,
1.79700e-01,9.52200e-02,4.00000e-01,1.22300e-01,5.76100e-02,5.00000e-01,9.69900e-02,4.31700e-02,6.00000e-01,8.28100e-02,
3.61700e-02,8.00000e-01,6.69600e-02,2.95600e-02,1.00000e+00,5.78500e-02,2.63000e-02,1.00000e-03,9.36500e+03,9.34300e+03,
1.03199e-03,8.77500e+03,8.75400e+03,1.06500e-03,8.21400e+03,8.19400e+03,1.06500e-03,8.68500e+03,8.66300e+03,1.13851e-03,
7.57600e+03,7.55700e+03,1.21710e-03,6.58400e+03,6.56700e+03,1.21710e-03,6.88800e+03,6.87000e+03,1.50000e-03,4.33500e+03,
4.32200e+03,2.00000e-03,2.22600e+03,2.21600e+03,3.00000e-03,8.31900e+02,8.24600e+02,4.00000e-03,4.05500e+02,3.99400e+02,
5.00000e-03,2.30300e+02,2.25100e+02,5.01190e-03,2.29000e+02,2.23700e+02,5.01190e-03,6.67400e+02,6.24800e+02,5.18274e-03,
6.18400e+02,5.76300e+02,5.35940e-03,5.64500e+02,5.29900e+02,5.35940e-03,7.69200e+02,7.14200e+02,5.53401e-03,7.14600e+02,
6.61000e+02,5.71430e-03,6.55600e+02,6.10800e+02,5.71430e-03,7.54700e+02,7.01500e+02,6.00000e-03,6.71100e+02,6.25300e+02,
8.00000e-03,3.21400e+02,3.02900e+02,1.00000e-02,1.79300e+02,1.69700e+02,1.50000e-02,6.10400e+01,5.75300e+01,2.00000e-02,
2.82200e+01,2.62300e+01,3.00000e-02,9.50700e+00,8.50200e+00,3.59846e-02,5.86300e+00,5.10200e+00,3.59846e-02,3.14300e+01,
1.01700e+01,4.00000e-02,2.38100e+01,9.18500e+00,5.00000e-02,1.34000e+01,6.61800e+00,6.00000e-02,8.24800e+00,4.65300e+00,
8.00000e-02,3.83600e+00,2.46400e+00,1.00000e-01,2.12400e+00,1.43800e+00,1.50000e-01,7.58900e-01,5.15400e-01,2.00000e-01,
3.94100e-01,2.50200e-01,3.00000e-01,1.86300e-01,1.00000e-01,4.00000e-01,1.25700e-01,6.00300e-02,5.00000e-01,9.91200e-02,
4.46300e-02,6.00000e-01,8.43100e-02,3.71700e-02,8.00000e-01,6.78900e-02,3.01400e-02,1.00000e+00,5.85400e-02,2.67100e-02,
1.00000e-03,8.54300e+03,8.52100e+03,1.03063e-03,7.99000e+03,7.96900e+03,1.06220e-03,7.46500e+03,7.44500e+03,1.06220e-03,
8.54700e+03,8.52400e+03,1.09882e-03,7.95700e+03,7.93500e+03,1.13670e-03,7.40400e+03,7.38400e+03,1.13670e-03,7.83700e+03,
7.81500e+03,1.21224e-03,6.86100e+03,6.84100e+03,1.29280e-03,5.98500e+03,5.96800e+03,1.29280e-03,6.25500e+03,6.23700e+03,
1.50000e-03,4.49900e+03,4.48500e+03,2.00000e-03,2.31900e+03,2.30800e+03,3.00000e-03,8.69600e+02,8.62200e+02,4.00000e-03,
4.24600e+02,4.18400e+02,5.00000e-03,2.41400e+02,2.36100e+02,5.24700e-03,2.13500e+02,2.08400e+02,5.24700e-03,6.09800e+02,
5.68900e+02,5.43204e-03,5.63400e+02,5.26300e+02,5.62360e-03,5.16900e+02,4.83500e+02,5.62360e-03,7.01600e+02,6.48600e+02,
5.80333e-03,6.50700e+02,6.02500e+02,5.98880e-03,6.01300e+02,5.57700e+02,5.98880e-03,6.93000e+02,6.41200e+02,6.00000e-03,
6.89800e+02,6.38300e+02,8.00000e-03,3.33400e+02,3.12700e+02,1.00000e-02,1.86000e+02,1.75400e+02,1.50000e-02,6.34700e+01,
5.97200e+01,2.00000e-02,2.93800e+01,2.73000e+01,3.00000e-02,9.90400e+00,8.87500e+00,3.74406e-02,5.49800e+00,4.76800e+00,
3.74406e-02,2.91900e+01,9.34600e+00,4.00000e-02,2.45700e+01,8.84200e+00,5.00000e-02,1.37900e+01,6.53400e+00,6.00000e-02,
8.51100e+00,4.66000e+00,8.00000e-02,3.96300e+00,2.50100e+00,1.00000e-01,2.19600e+00,1.47000e+00,1.50000e-01,7.82800e-01,
5.30900e-01,2.00000e-01,4.04600e-01,2.58300e-01,3.00000e-01,1.89100e-01,1.02800e-01,4.00000e-01,1.26500e-01,6.12500e-02,
5.00000e-01,9.92300e-02,4.52100e-02,6.00000e-01,8.41000e-02,3.74300e-02,8.00000e-01,6.74400e-02,3.01100e-02,1.00000e+00,
5.80300e-02,2.65700e-02,1.00000e-03,9.08700e+03,9.06100e+03,1.05991e-03,7.98800e+03,7.96500e+03,1.12340e-03,7.00000e+03,
6.97900e+03,1.12340e-03,8.02500e+03,8.00100e+03,1.16320e-03,7.44700e+03,7.42500e+03,1.20440e-03,6.91100e+03,6.89000e+03,
1.20440e-03,7.32100e+03,7.29800e+03,1.28045e-03,6.44000e+03,6.41900e+03,1.36130e-03,5.65200e+03,5.63400e+03,1.36130e-03,
5.90500e+03,5.88600e+03,1.50000e-03,4.77200e+03,4.75500e+03,2.00000e-03,2.46400e+03,2.45300e+03,3.00000e-03,9.26700e+02,
9.19000e+02,4.00000e-03,4.53100e+02,4.46800e+02,5.00000e-03,2.57800e+02,2.52400e+02,5.48270e-03,2.03900e+02,1.98800e+02,
5.48270e-03,5.76400e+02,5.35600e+02,5.68299e-03,5.30200e+02,4.93500e+02,5.89060e-03,4.84600e+02,4.51700e+02,5.89060e-03,
6.54500e+02,6.02300e+02,6.00000e-03,6.31900e+02,5.81900e+02,6.26630e-03,5.65400e+02,5.22100e+02,6.26630e-03,6.51800e+02,
6.00300e+02,8.00000e-03,3.52900e+02,3.29000e+02,1.00000e-02,1.96700e+02,1.84700e+02,1.50000e-02,6.73100e+01,6.32100e+01,
2.00000e-02,3.11900e+01,2.89700e+01,3.00000e-02,1.05200e+01,9.44400e+00,3.89246e-02,5.27100e+00,4.55400e+00,3.89246e-02,
2.77200e+01,8.78500e+00,4.00000e-02,2.57900e+01,8.60800e+00,5.00000e-02,1.44700e+01,6.56000e+00,6.00000e-02,8.96200e+00,
4.75600e+00,8.00000e-02,4.17700e+00,2.58700e+00,1.00000e-01,2.31500e+00,1.53200e+00,1.50000e-01,8.23900e-01,5.57600e-01,
2.00000e-01,4.23900e-01,2.71800e-01,3.00000e-01,1.96100e-01,1.07900e-01,4.00000e-01,1.30100e-01,6.38200e-02,5.00000e-01,
1.01500e-01,4.67700e-02,6.00000e-01,8.57000e-02,3.84900e-02,8.00000e-01,6.84300e-02,3.07300e-02,1.00000e+00,5.87600e-02,
2.70000e-02,1.00000e-03,9.71100e+03,9.67900e+03,1.08876e-03,7.99100e+03,7.96400e+03,1.18540e-03,6.56300e+03,6.54100e+03,
1.18540e-03,7.54500e+03,7.51900e+03,1.22832e-03,6.98400e+03,6.96000e+03,1.27280e-03,6.46500e+03,6.44200e+03,1.27280e-03,
6.85300e+03,6.82900e+03,1.35222e-03,6.03100e+03,6.01000e+03,1.43660e-03,5.29300e+03,5.27300e+03,1.43660e-03,5.53200e+03,
5.51200e+03,1.50000e-03,5.03300e+03,5.01500e+03,2.00000e-03,2.60700e+03,2.59500e+03,3.00000e-03,9.85700e+02,9.77600e+02,
4.00000e-03,4.81100e+02,4.74500e+02,5.00000e-03,2.74000e+02,2.68400e+02,5.72340e-03,1.94300e+02,1.89200e+02,5.72340e-03,
5.45400e+02,5.04600e+02,6.00000e-03,4.90800e+02,4.55000e+02,6.16420e-03,4.55400e+02,4.22800e+02,6.16420e-03,6.18800e+02,
5.66500e+02,6.35359e-03,5.75600e+02,5.27800e+02,6.54880e-03,5.33200e+02,4.89900e+02,6.54880e-03,6.14900e+02,5.63300e+02,
8.00000e-03,3.73200e+02,3.45800e+02,1.00000e-02,2.08200e+02,1.94500e+02,1.50000e-02,7.14300e+01,6.69000e+01,2.00000e-02,
3.31200e+01,3.07300e+01,3.00000e-02,1.11900e+01,1.00500e+01,4.00000e-02,5.21500e+00,4.49600e+00,4.04430e-02,5.06600e+00,
4.35900e+00,4.04430e-02,2.63500e+01,8.27200e+00,5.00000e-02,1.52000e+01,6.56900e+00,6.00000e-02,9.44700e+00,4.84700e+00,
8.00000e-02,4.40900e+00,2.67700e+00,1.00000e-01,2.44500e+00,1.59700e+00,1.50000e-01,8.68700e-01,5.86200e-01,2.00000e-01,
4.45200e-01,2.86500e-01,3.00000e-01,2.03900e-01,1.13400e-01,4.00000e-01,1.34200e-01,6.66400e-02,5.00000e-01,1.04100e-01,
4.85100e-02,6.00000e-01,8.75700e-02,3.97000e-02,8.00000e-01,6.96200e-02,3.14500e-02,1.00000e+00,5.96100e-02,2.75000e-02,
1.00000e-03,1.05800e+04,1.05400e+04,1.11454e-03,8.12200e+03,8.09100e+03,1.24220e-03,6.27800e+03,6.25400e+03,1.24220e-03,
7.22400e+03,7.19600e+03,1.28892e-03,6.66100e+03,6.63500e+03,1.33740e-03,6.14200e+03,6.11800e+03,1.33740e-03,6.51300e+03,
6.48700e+03,1.50000e-03,5.09000e+03,5.06900e+03,1.51100e-03,5.00600e+03,4.98600e+03,1.51100e-03,5.23500e+03,5.21400e+03,
2.00000e-03,2.76800e+03,2.75500e+03,3.00000e-03,1.04700e+03,1.03800e+03,4.00000e-03,5.13100e+02,5.06100e+02,5.00000e-03,
2.92400e+02,2.86500e+02,5.96430e-03,1.86800e+02,1.81600e+02,5.96430e-03,5.21400e+02,4.80200e+02,6.00000e-03,5.14500e+02,
4.73900e+02,6.44040e-03,4.31000e+02,3.98400e+02,6.44040e-03,5.85700e+02,5.33300e+02,6.63467e-03,5.45500e+02,4.97600e+02,
6.83480e-03,5.06000e+02,4.62500e+02,6.83480e-03,5.83600e+02,5.31700e+02,8.00000e-03,3.95000e+02,3.63400e+02,1.00000e-02,
2.20900e+02,2.05200e+02,1.50000e-02,7.59700e+01,7.09400e+01,2.00000e-02,3.52600e+01,3.26700e+01,3.00000e-02,1.19200e+01,
1.07200e+01,4.00000e-02,5.55700e+00,4.80300e+00,4.19906e-02,4.89200e+00,4.19200e+00,4.19906e-02,2.51800e+01,7.83300e+00,
5.00000e-02,1.59900e+01,6.56700e+00,6.00000e-02,9.97700e+00,4.94200e+00,8.00000e-02,4.66400e+00,2.77300e+00,1.00000e-01,
2.58800e+00,1.66700e+00,1.50000e-01,9.18000e-01,6.17200e-01,2.00000e-01,4.68700e-01,3.02500e-01,3.00000e-01,2.12600e-01,
1.19500e-01,4.00000e-01,1.38900e-01,6.98000e-02,5.00000e-01,1.07100e-01,5.04700e-02,6.00000e-01,8.97600e-02,4.10700e-02,
8.00000e-01,7.10500e-02,3.22900e-02,1.00000e+00,6.07000e-02,2.81100e-02,1.00000e-03,6.62700e+03,6.59800e+03,1.00250e-03,
6.80600e+03,6.77600e+03,1.00500e-03,6.94900e+03,6.91800e+03,1.00500e-03,8.55400e+03,8.51600e+03,1.14188e-03,7.57900e+03,
7.54700e+03,1.29740e-03,5.93300e+03,5.90800e+03,1.29740e-03,6.83300e+03,6.80300e+03,1.34907e-03,6.26400e+03,6.23600e+03,
1.40280e-03,5.74400e+03,5.71900e+03,1.40280e-03,6.09300e+03,6.06600e+03,1.50000e-03,5.27300e+03,5.25000e+03,1.57530e-03,
4.73800e+03,4.71700e+03,1.57530e-03,4.95100e+03,4.92900e+03,2.00000e-03,2.87800e+03,2.86400e+03,3.00000e-03,1.09300e+03,
1.08400e+03,4.00000e-03,5.36600e+02,5.29400e+02,5.00000e-03,3.06100e+02,3.00000e+02,6.00000e-03,1.92700e+02,1.87400e+02,
6.20790e-03,1.76700e+02,1.71500e+02,6.20790e-03,4.89200e+02,4.48400e+02,6.45960e-03,4.48700e+02,4.07900e+02,6.72150e-03,
4.01300e+02,3.69400e+02,6.72150e-03,5.45600e+02,4.93900e+02,6.92080e-03,5.13500e+02,4.61400e+02,7.12600e-03,4.72300e+02,
4.29300e+02,7.12600e-03,5.44800e+02,4.93600e+02,8.00000e-03,4.09400e+02,3.73900e+02,1.00000e-02,2.30000e+02,2.12500e+02,
1.50000e-02,7.92500e+01,7.37600e+01,2.00000e-02,3.68400e+01,3.40700e+01,3.00000e-02,1.24700e+01,1.12100e+01,4.00000e-02,
5.80900e+00,5.03300e+00,4.35689e-02,4.64200e+00,3.96200e+00,4.35689e-02,2.36600e+01,7.29600e+00,5.00000e-02,1.65000e+01,
6.41800e+00,6.00000e-02,1.03300e+01,4.92800e+00,8.00000e-02,4.83900e+00,2.81500e+00,1.00000e-01,2.68700e+00,1.70600e+00,
1.50000e-01,9.52200e-01,6.37600e-01,2.00000e-01,4.84400e-01,3.13300e-01,3.00000e-01,2.17800e-01,1.23600e-01,4.00000e-01,
1.41200e-01,7.17700e-02,5.00000e-01,1.08300e-01,5.15700e-02,6.00000e-01,9.04000e-02,4.17400e-02,8.00000e-01,7.12700e-02,
3.25800e-02,1.00000e+00,6.07200e-02,2.82300e-02,1.00000e-03,2.05600e+03,2.04600e+03,1.01336e-03,2.00700e+03,1.99700e+03,
1.02690e-03,1.95900e+03,1.94900e+03,1.02690e-03,2.72900e+03,2.71500e+03,1.03913e-03,3.89400e+03,3.87400e+03,1.05150e-03,
5.83000e+03,5.80100e+03,1.05150e-03,7.24200e+03,7.20500e+03,1.19448e-03,7.23200e+03,7.19600e+03,1.35690e-03,5.68700e+03,
5.66000e+03,1.35690e-03,6.55500e+03,6.52400e+03,1.41299e-03,5.98500e+03,5.95600e+03,1.47140e-03,5.46600e+03,5.43900e+03,
1.47140e-03,5.79900e+03,5.77000e+03,1.50000e-03,5.55300e+03,5.52600e+03,1.65300e-03,4.49700e+03,4.47400e+03,1.65300e-03,
4.69900e+03,4.67600e+03,2.00000e-03,3.04800e+03,3.03100e+03,3.00000e-03,1.16200e+03,1.15200e+03,4.00000e-03,5.70900e+02,
5.63300e+02,5.00000e-03,3.26000e+02,3.19600e+02,6.00000e-03,2.05300e+02,1.99800e+02,6.45930e-03,1.70200e+02,1.64900e+02,
6.45930e-03,4.67800e+02,4.26700e+02,6.73036e-03,4.22600e+02,3.86400e+02,7.01280e-03,3.80500e+02,3.48700e+02,7.01280e-03,
5.17400e+02,4.65700e+02,7.21737e-03,4.88400e+02,4.35900e+02,7.42790e-03,4.49400e+02,4.06200e+02,7.42790e-03,5.18400e+02,
4.66900e+02,8.00000e-03,4.31400e+02,3.90800e+02,1.00000e-02,2.44000e+02,2.24000e+02,1.50000e-02,8.41100e+01,7.79900e+01,
2.00000e-02,3.91600e+01,3.61400e+01,3.00000e-02,1.32700e+01,1.19300e+01,4.00000e-02,6.18100e+00,5.36600e+00,4.51840e-02,
4.49100e+00,3.81600e+00,4.51840e-02,2.26500e+01,6.93000e+00,5.00000e-02,1.73500e+01,6.36300e+00,6.00000e-02,1.08700e+01,
4.98900e+00,8.00000e-02,5.10700e+00,2.90400e+00,1.00000e-01,2.84000e+00,1.77600e+00,1.50000e-01,1.00500e+00,6.69900e-01,
2.00000e-01,5.09800e-01,3.30200e-01,3.00000e-01,2.27300e-01,1.30100e-01,4.00000e-01,1.46200e-01,7.51700e-02,5.00000e-01,
1.11500e-01,5.36900e-02,6.00000e-01,9.27600e-02,4.32300e-02,8.00000e-01,7.28000e-02,3.34900e-02,1.00000e+00,6.18800e-02,
2.88900e-02,1.00000e-03,2.10700e+03,2.09700e+03,1.03933e-03,1.96300e+03,1.95300e+03,1.08020e-03,1.82700e+03,1.81700e+03,
1.08020e-03,2.63500e+03,2.62000e+03,1.09302e-03,3.83700e+03,3.81600e+03,1.10600e-03,5.61300e+03,5.58200e+03,1.10600e-03,
6.85200e+03,6.81400e+03,1.25312e-03,6.64100e+03,6.60500e+03,1.41980e-03,5.26200e+03,5.23400e+03,1.41980e-03,6.07200e+03,
6.03900e+03,1.50000e-03,5.35800e+03,5.32900e+03,1.54070e-03,5.04600e+03,5.01800e+03,1.54070e-03,5.35500e+03,5.32500e+03,
1.62921e-03,4.74000e+03,4.71400e+03,1.72280e-03,4.18900e+03,4.16500e+03,1.72280e-03,4.37600e+03,4.35200e+03,2.00000e-03,
3.12000e+03,3.10200e+03,3.00000e-03,1.19300e+03,1.18300e+03,4.00000e-03,5.87300e+02,5.79500e+02,5.00000e-03,3.35600e+02,
3.29100e+02,6.00000e-03,2.11500e+02,2.05900e+02,6.71620e-03,1.58700e+02,1.53600e+02,6.71620e-03,4.33400e+02,3.93300e+02,
7.00767e-03,3.89800e+02,3.54700e+02,7.31180e-03,3.49600e+02,3.18900e+02,7.31180e-03,4.75600e+02,4.25500e+02,7.52130e-03,
4.50100e+02,3.98800e+02,7.73680e-03,4.14100e+02,3.72100e+02,7.73680e-03,4.77700e+02,4.27600e+02,8.00000e-03,4.40100e+02,
3.95100e+02,1.00000e-02,2.49900e+02,2.27800e+02,1.50000e-02,8.63300e+01,7.97200e+01,2.00000e-02,4.02500e+01,3.70600e+01,
3.00000e-02,1.36500e+01,1.22700e+01,4.00000e-02,6.36200e+00,5.53200e+00,4.68342e-02,4.20800e+00,3.56200e+00,4.68342e-02,
2.10000e+01,6.37800e+00,5.00000e-02,1.77400e+01,6.09400e+00,6.00000e-02,1.10700e+01,4.87200e+00,8.00000e-02,5.21200e+00,
2.89300e+00,1.00000e-01,2.90100e+00,1.78600e+00,1.50000e-01,1.02700e+00,6.80600e-01,2.00000e-01,5.19200e-01,3.36600e-01,
3.00000e-01,2.29600e-01,1.32600e-01,4.00000e-01,1.46600e-01,7.62000e-02,5.00000e-01,1.11200e-01,5.41100e-02,6.00000e-01,
9.21800e-02,4.33400e-02,8.00000e-01,7.20100e-02,3.33300e-02,1.00000e+00,6.10600e-02,2.86200e-02,1.00000e-03,2.21600e+03,
2.20600e+03,1.06344e-03,1.97800e+03,1.96800e+03,1.13090e-03,1.76300e+03,1.75300e+03,1.13090e-03,2.44300e+03,2.42800e+03,
1.14565e-03,3.61700e+03,3.59500e+03,1.16060e-03,5.41600e+03,5.38200e+03,1.16060e-03,6.54000e+03,6.49800e+03,1.31087e-03,
6.29100e+03,6.25300e+03,1.48060e-03,5.03100e+03,5.00100e+03,1.48060e-03,5.81000e+03,5.77400e+03,1.50000e-03,5.62400e+03,
5.59000e+03,1.61390e-03,4.77100e+03,4.74200e+03,1.61390e-03,5.06400e+03,5.03400e+03,1.70441e-03,4.49200e+03,4.46500e+03,
1.80000e-03,3.98000e+03,3.95500e+03,1.80000e-03,4.15800e+03,4.13200e+03,2.00000e-03,3.27800e+03,3.25800e+03,3.00000e-03,
1.25600e+03,1.24500e+03,4.00000e-03,6.19300e+02,6.11100e+02,5.00000e-03,3.54200e+02,3.47400e+02,6.00000e-03,2.23400e+02,
2.17500e+02,6.97690e-03,1.52200e+02,1.47100e+02,6.97690e-03,4.12700e+02,3.72500e+02,7.28997e-03,3.69600e+02,3.34600e+02,
7.61710e-03,3.30200e+02,2.99800e+02,7.61710e-03,4.49200e+02,3.99300e+02,8.00000e-03,3.98900e+02,3.56000e+02,8.05200e-03,
3.92100e+02,3.50200e+02,8.05200e-03,4.52400e+02,4.02400e+02,1.00000e-02,2.62900e+02,2.37800e+02,1.50000e-02,9.08700e+01,
8.35200e+01,2.00000e-02,4.24200e+01,3.89500e+01,3.00000e-02,1.44100e+01,1.29500e+01,4.00000e-02,6.71600e+00,5.84800e+00,
4.85190e-02,4.05100e+00,3.41400e+00,4.85190e-02,2.00100e+01,6.03600e+00,5.00000e-02,1.85000e+01,5.92700e+00,6.00000e-02,
1.15500e+01,4.86300e+00,8.00000e-02,5.45500e+00,2.95300e+00,1.00000e-01,3.04000e+00,1.84100e+00,1.50000e-01,1.07600e+00,
7.08800e-01,2.00000e-01,5.42500e-01,3.51800e-01,3.00000e-01,2.38000e-01,1.38500e-01,4.00000e-01,1.50900e-01,7.92700e-02,
5.00000e-01,1.13900e-01,5.59800e-02,6.00000e-01,9.40400e-02,4.46200e-02,8.00000e-01,7.31200e-02,3.40600e-02,1.00000e+00,
6.18600e-02,2.91200e-02,1.00000e-03,2.29100e+03,2.28100e+03,1.08867e-03,1.96000e+03,1.94900e+03,1.18520e-03,1.66800e+03,
1.65800e+03,1.18520e-03,1.93100e+03,1.91900e+03,1.20109e-03,2.52700e+03,2.51000e+03,1.21720e-03,3.96100e+03,3.93400e+03,
1.21720e-03,4.76400e+03,4.73100e+03,1.50000e-03,5.04100e+03,5.00800e+03,1.54400e-03,4.70100e+03,4.67000e+03,1.54400e-03,
5.43200e+03,5.39500e+03,1.61454e-03,4.90000e+03,4.86700e+03,1.68830e-03,4.42100e+03,4.39100e+03,1.68830e-03,4.69400e+03,
4.66200e+03,1.78195e-03,4.16400e+03,4.13600e+03,1.88080e-03,3.69100e+03,3.66600e+03,1.88080e-03,3.85400e+03,3.82900e+03,
2.00000e-03,3.36000e+03,3.33700e+03,3.00000e-03,1.29200e+03,1.28000e+03,4.00000e-03,6.38000e+02,6.29600e+02,5.00000e-03,
3.65300e+02,3.58400e+02,6.00000e-03,2.30500e+02,2.24600e+02,7.24280e-03,1.42900e+02,1.37900e+02,7.24280e-03,3.84400e+02,
3.45200e+02,7.57876e-03,3.42700e+02,3.08800e+02,7.93030e-03,3.04900e+02,2.75500e+02,7.93030e-03,4.14900e+02,3.66500e+02,
8.00000e-03,4.06800e+02,3.59500e+02,8.37560e-03,3.63100e+02,3.22300e+02,8.37560e-03,4.19000e+02,3.70200e+02,1.00000e-02,
2.69300e+02,2.41600e+02,1.50000e-02,9.33500e+01,8.53800e+01,2.00000e-02,4.36300e+01,3.99400e+01,3.00000e-02,1.48400e+01,
1.33300e+01,4.00000e-02,6.92000e+00,6.03300e+00,5.00000e-02,3.85900e+00,3.24200e+00,5.02391e-02,3.81200e+00,3.19900e+00,
5.02391e-02,1.86400e+01,5.58500e+00,6.00000e-02,1.17500e+01,4.72200e+00,8.00000e-02,5.57300e+00,2.93700e+00,1.00000e-01,
3.10900e+00,1.84900e+00,1.50000e-01,1.10000e+00,7.19700e-01,2.00000e-01,5.53400e-01,3.58400e-01,3.00000e-01,2.41000e-01,
1.40900e-01,4.00000e-01,1.51700e-01,8.03900e-02,5.00000e-01,1.13900e-01,5.65000e-02,6.00000e-01,9.37100e-02,4.48300e-02,
8.00000e-01,7.25200e-02,3.39900e-02,1.00000e+00,6.12000e-02,2.89300e-02,1.00000e-03,2.39600e+03,2.38600e+03,1.11409e-03,
1.95600e+03,1.94600e+03,1.24120e-03,1.59100e+03,1.58100e+03,1.24120e-03,2.33700e+03,2.32100e+03,1.25799e-03,3.51500e+03,
3.48800e+03,1.27500e-03,5.02300e+03,4.98400e+03,1.27500e-03,5.92800e+03,5.88100e+03,1.50000e-03,5.31400e+03,5.27400e+03,
1.61130e-03,4.46400e+03,4.43100e+03,1.61130e-03,5.16400e+03,5.12500e+03,1.68769e-03,4.63500e+03,4.60100e+03,1.76770e-03,
4.16600e+03,4.13500e+03,1.76770e-03,4.42400e+03,4.39100e+03,1.86493e-03,3.92900e+03,3.89900e+03,1.96750e-03,3.48200e+03,
3.45600e+03,1.96750e-03,3.63800e+03,3.61100e+03,2.00000e-03,3.50700e+03,3.48100e+03,3.00000e-03,1.35400e+03,1.34200e+03,
4.00000e-03,6.69700e+02,6.60700e+02,5.00000e-03,3.83800e+02,3.76500e+02,6.00000e-03,2.42300e+02,2.36200e+02,7.51400e-03,
1.36800e+02,1.31800e+02,7.51400e-03,3.65800e+02,3.26600e+02,8.00000e-03,3.13300e+02,2.81000e+02,8.25160e-03,2.88100e+02,
2.59000e+02,8.25160e-03,3.92500e+02,3.44300e+02,8.47673e-03,3.68400e+02,3.23900e+02,8.70800e-03,3.44100e+02,3.03300e+02,
8.70800e-03,3.97000e+02,3.48300e+02,1.00000e-02,2.81500e+02,2.50200e+02,1.50000e-02,9.80200e+01,8.91400e+01,2.00000e-02,
4.58800e+01,4.18400e+01,3.00000e-02,1.56300e+01,1.40200e+01,4.00000e-02,7.28800e+00,6.35700e+00,5.00000e-02,4.06400e+00,
3.42200e+00,5.19957e-02,3.67200e+00,3.06800e+00,5.19957e-02,1.77700e+01,5.29100e+00,6.00000e-02,1.22300e+01,4.67300e+00,
8.00000e-02,5.82600e+00,2.98600e+00,1.00000e-01,3.25300e+00,1.89900e+00,1.50000e-01,1.15100e+00,7.47400e-01,2.00000e-01,
5.77500e-01,3.73600e-01,3.00000e-01,2.49800e-01,1.47000e-01,4.00000e-01,1.56200e-01,8.35400e-02,5.00000e-01,1.16700e-01,
5.84200e-02,6.00000e-01,9.56200e-02,4.61400e-02,8.00000e-01,7.36500e-02,3.47400e-02,1.00000e+00,6.19600e-02,2.94200e-02,
1.00000e-03,2.49400e+03,2.48300e+03,1.13794e-03,1.95300e+03,1.94300e+03,1.29490e-03,1.52100e+03,1.51100e+03,1.29490e-03,
2.17300e+03,2.15600e+03,1.31356e-03,3.29300e+03,3.26500e+03,1.33250e-03,4.74500e+03,4.70400e+03,1.33250e-03,5.55100e+03,
5.50200e+03,1.50000e-03,5.55000e+03,5.50300e+03,1.67560e-03,4.22900e+03,4.19400e+03,1.67560e-03,4.89600e+03,4.85500e+03,
1.75674e-03,4.38200e+03,4.34500e+03,1.84180e-03,3.92400e+03,3.89200e+03,1.84180e-03,4.16800e+03,4.13300e+03,2.00000e-03,
3.46700e+03,3.43800e+03,2.04680e-03,3.28600e+03,3.25900e+03,2.04680e-03,3.43300e+03,3.40400e+03,3.00000e-03,1.40500e+03,
1.39100e+03,4.00000e-03,6.95300e+02,6.85800e+02,5.00000e-03,3.98800e+02,3.91300e+02,6.00000e-03,2.52000e+02,2.45600e+02,
7.79010e-03,1.29900e+02,1.24900e+02,7.79010e-03,3.43700e+02,3.05100e+02,8.00000e-03,3.26900e+02,2.90600e+02,8.58060e-03,
2.69500e+02,2.41000e+02,8.58060e-03,3.67200e+02,3.19800e+02,8.81013e-03,3.45200e+02,3.01300e+02,9.04580e-03,3.22800e+02,
2.82600e+02,9.04580e-03,3.72500e+02,3.24500e+02,1.00000e-02,2.90200e+02,2.55400e+02,1.50000e-02,1.01600e+02,9.18700e+01,
2.00000e-02,4.76500e+01,4.32800e+01,3.00000e-02,1.62500e+01,1.45600e+01,4.00000e-02,7.58200e+00,6.61600e+00,5.00000e-02,
4.22700e+00,3.56600e+00,5.37885e-02,3.50000e+00,2.91100e+00,5.37885e-02,1.67600e+01,4.96100e+00,6.00000e-02,1.25900e+01,
4.55400e+00,8.00000e-02,6.01200e+00,2.99300e+00,1.00000e-01,3.36000e+00,1.92500e+00,1.50000e-01,1.18900e+00,7.66000e-01,
2.00000e-01,5.95300e-01,3.84600e-01,3.00000e-01,2.55800e-01,1.51400e-01,4.00000e-01,1.59000e-01,8.57800e-02,5.00000e-01,
1.18100e-01,5.97100e-02,6.00000e-01,9.64400e-02,4.69400e-02,8.00000e-01,7.39300e-02,3.50900e-02,1.00000e+00,6.20400e-02,
2.95800e-02,1.00000e-03,2.61600e+03,2.60500e+03,1.16250e-03,1.96100e+03,1.95100e+03,1.35140e-03,1.46200e+03,1.45200e+03,
1.35140e-03,2.10800e+03,2.09100e+03,1.37130e-03,3.19300e+03,3.16400e+03,1.39150e-03,4.52800e+03,4.48500e+03,1.39150e-03,
5.23900e+03,5.18700e+03,1.50000e-03,5.84700e+03,5.79000e+03,1.74120e-03,4.03800e+03,4.00100e+03,1.74120e-03,4.67700e+03,
4.63300e+03,1.82975e-03,4.16100e+03,4.12200e+03,1.92280e-03,3.70300e+03,3.66900e+03,1.92280e-03,3.93400e+03,3.89800e+03,
2.00000e-03,3.59000e+03,3.55800e+03,2.12830e-03,3.12700e+03,3.09900e+03,2.12830e-03,3.26600e+03,3.23600e+03,3.00000e-03,
1.46500e+03,1.45000e+03,4.00000e-03,7.26400e+02,7.16400e+02,5.00000e-03,4.17000e+02,4.09100e+02,6.00000e-03,2.63600e+02,
2.57000e+02,8.00000e-03,1.27100e+02,1.22000e+02,8.07110e-03,1.24200e+02,1.19200e+02,8.07110e-03,3.28300e+02,2.89700e+02,
8.48389e-03,2.88900e+02,2.56000e+02,8.91780e-03,2.54000e+02,2.26000e+02,8.91780e-03,3.46300e+02,2.99400e+02,9.15290e-03,
3.25900e+02,2.82500e+02,9.39420e-03,3.05100e+02,2.65200e+02,9.39420e-03,3.52000e+02,3.04400e+02,1.00000e-02,3.01200e+02,
2.62300e+02,1.50000e-02,1.06000e+02,9.52100e+01,2.00000e-02,4.98000e+01,4.50400e+01,3.00000e-02,1.70100e+01,1.52100e+01,
4.00000e-02,7.94000e+00,6.92800e+00,5.00000e-02,4.42500e+00,3.74000e+00,5.56177e-02,3.36100e+00,2.78300e+00,5.56177e-02,
1.59200e+01,4.69700e+00,6.00000e-02,1.30900e+01,4.46600e+00,8.00000e-02,6.24400e+00,3.01500e+00,1.00000e-01,3.49200e+00,
1.96100e+00,1.50000e-01,1.23600e+00,7.90100e-01,2.00000e-01,6.17800e-01,3.98400e-01,3.00000e-01,2.63900e-01,1.57000e-01,
4.00000e-01,1.62900e-01,8.86900e-02,5.00000e-01,1.20500e-01,6.14500e-02,6.00000e-01,9.80000e-02,4.81100e-02,8.00000e-01,
7.47700e-02,3.57100e-02,1.00000e+00,6.25700e-02,2.99700e-02,1.00000e-03,2.74800e+03,2.73700e+03,1.18714e-03,1.97800e+03,
1.96700e+03,1.40930e-03,1.40800e+03,1.39700e+03,1.40930e-03,2.06900e+03,2.05100e+03,1.43113e-03,3.17000e+03,3.13800e+03,
1.45330e-03,4.33900e+03,4.29300e+03,1.45330e-03,4.95200e+03,4.89800e+03,1.50000e-03,6.06900e+03,6.00300e+03,1.81180e-03,
3.84100e+03,3.80200e+03,1.81180e-03,4.45200e+03,4.40600e+03,2.00000e-03,3.52300e+03,3.48800e+03,2.00580e-03,3.49900e+03,
3.46400e+03,2.00580e-03,3.71700e+03,3.68000e+03,2.10376e-03,3.33700e+03,3.30400e+03,2.20650e-03,2.99500e+03,2.96500e+03,
2.20650e-03,3.12700e+03,3.09600e+03,3.00000e-03,1.52600e+03,1.51000e+03,4.00000e-03,7.58700e+02,7.48000e+02,5.00000e-03,
4.35900e+02,4.27600e+02,6.00000e-03,2.75700e+02,2.68800e+02,8.00000e-03,1.33000e+02,1.27800e+02,8.35790e-03,1.19000e+02,
1.14000e+02,8.35790e-03,3.12600e+02,2.74100e+02,8.79944e-03,2.79900e+02,2.41200e+02,9.26430e-03,2.39700e+02,2.12100e+02,
9.26430e-03,3.27100e+02,2.80600e+02,9.50468e-03,3.08000e+02,2.65000e+02,9.75130e-03,2.88600e+02,2.49100e+02,9.75130e-03,
3.33000e+02,2.85800e+02,1.00000e-02,3.12900e+02,2.69400e+02,1.50000e-02,1.10600e+02,9.86000e+01,2.00000e-02,5.20400e+01,
4.68300e+01,3.00000e-02,1.78000e+01,1.58800e+01,4.00000e-02,8.31500e+00,7.25300e+00,5.00000e-02,4.63400e+00,3.92200e+00,
5.74855e-02,3.23200e+00,2.66400e+00,5.74855e-02,1.51400e+01,4.44200e+00,6.00000e-02,1.36200e+01,4.34900e+00,8.00000e-02,
6.47800e+00,3.02800e+00,1.00000e-01,3.62800e+00,1.99500e+00,1.50000e-01,1.28500e+00,8.14100e-01,2.00000e-01,6.41500e-01,
4.12500e-01,3.00000e-01,2.72400e-01,1.62900e-01,4.00000e-01,1.67200e-01,9.17300e-02,5.00000e-01,1.23000e-01,6.32900e-02,
6.00000e-01,9.96800e-02,4.93400e-02,8.00000e-01,7.56900e-02,3.63800e-02,1.00000e+00,6.31700e-02,3.04000e-02,1.00000e-03,
2.89900e+03,2.88800e+03,1.21149e-03,1.99500e+03,1.98400e+03,1.46770e-03,1.36200e+03,1.35200e+03,1.46770e-03,1.91900e+03,
1.90100e+03,1.50000e-03,3.93700e+03,3.89200e+03,1.51460e-03,4.14500e+03,4.09800e+03,1.51460e-03,4.83000e+03,4.77300e+03,
1.68946e-03,4.44600e+03,4.39500e+03,1.88450e-03,3.66800e+03,3.62700e+03,1.88450e-03,4.25400e+03,4.20600e+03,2.00000e-03,
3.68600e+03,3.64600e+03,2.08980e-03,3.32600e+03,3.29000e+03,2.08980e-03,3.53400e+03,3.49500e+03,2.19562e-03,3.16000e+03,
3.12500e+03,2.30680e-03,2.82100e+03,2.79100e+03,2.30680e-03,2.94500e+03,2.91400e+03,3.00000e-03,1.59400e+03,1.57600e+03,
4.00000e-03,7.94600e+02,7.83100e+02,5.00000e-03,4.56900e+02,4.48200e+02,6.00000e-03,2.89200e+02,2.82000e+02,8.00000e-03,
1.39700e+02,1.34200e+02,8.64800e-03,1.14600e+02,1.09600e+02,8.64800e-03,2.99100e+02,2.60600e+02,9.11959e-03,2.60900e+02,
2.28400e+02,9.61690e-03,2.27400e+02,2.00100e+02,9.61690e-03,3.10100e+02,2.64000e+02,1.00000e-02,2.83000e+02,2.42000e+02,
1.01157e-02,2.74500e+02,2.35100e+02,1.01157e-02,3.16700e+02,2.69700e+02,1.50000e-02,1.15700e+02,1.02300e+02,2.00000e-02,
5.45300e+01,4.88200e+01,3.00000e-02,1.86800e+01,1.66300e+01,4.00000e-02,8.73500e+00,7.61500e+00,5.00000e-02,4.86700e+00,
4.12400e+00,5.93896e-02,3.12200e+00,2.56200e+00,5.93896e-02,1.20000e+01,4.72100e+00,6.00000e-02,1.40900e+01,4.20300e+00,
8.00000e-02,6.74100e+00,3.04400e+00,1.00000e-01,3.78000e+00,2.03300e+00,1.50000e-01,1.34000e+00,8.41000e-01,2.00000e-01,
6.68200e-01,4.28300e-01,3.00000e-01,2.82200e-01,1.69500e-01,4.00000e-01,1.72200e-01,9.52200e-02,5.00000e-01,1.26100e-01,
6.54400e-02,6.00000e-01,1.01800e-01,5.08100e-02,8.00000e-01,7.69300e-02,3.72100e-02,1.00000e+00,6.40400e-02,3.09500e-02,
1.00000e-03,3.01700e+03,3.00600e+03,1.50000e-03,1.35000e+03,1.34000e+03,1.52780e-03,1.30000e+03,1.28900e+03,1.52780e-03,
1.96500e+03,1.94400e+03,1.55186e-03,2.94900e+03,2.91400e+03,1.57630e-03,3.90800e+03,3.85900e+03,1.57630e-03,4.54000e+03,
4.48200e+03,1.75313e-03,4.20000e+03,4.14600e+03,1.94980e-03,3.49500e+03,3.45300e+03,1.94980e-03,4.05400e+03,4.00400e+03,
2.00000e-03,3.79700e+03,3.75100e+03,2.17300e-03,3.12800e+03,3.09100e+03,2.17300e-03,3.32300e+03,3.28400e+03,2.28278e-03,
2.97000e+03,2.93500e+03,2.39810e-03,2.65200e+03,2.62100e+03,2.39810e-03,2.76900e+03,2.73700e+03,3.00000e-03,1.64000e+03,
1.62000e+03,4.00000e-03,8.19300e+02,8.07200e+02,5.00000e-03,4.71700e+02,4.62600e+02,6.00000e-03,2.98800e+02,2.91300e+02,
8.00000e-03,1.44400e+02,1.38900e+02,8.94360e-03,1.08800e+02,1.03900e+02,8.94360e-03,2.82400e+02,2.44400e+02,9.44675e-03,
2.51100e+02,2.13400e+02,9.97820e-03,2.12800e+02,1.86200e+02,9.97820e-03,2.90600e+02,2.45500e+02,1.00000e-02,2.89300e+02,
2.44400e+02,1.04864e-02,2.57700e+02,2.18900e+02,1.04864e-02,2.97300e+02,2.51200e+02,1.50000e-02,1.19300e+02,1.04700e+02,
2.00000e-02,5.62800e+01,5.01200e+01,3.00000e-02,1.93200e+01,1.71600e+01,4.00000e-02,9.04000e+00,7.87500e+00,5.00000e-02,
5.03800e+00,4.27300e+00,6.00000e-02,3.14700e+00,2.58400e+00,6.13323e-02,2.97500e+00,2.43200e+00,6.13323e-02,1.36500e+01,
3.96400e+00,8.00000e-02,6.90900e+00,3.00800e+00,1.00000e-01,3.88100e+00,2.03800e+00,1.50000e-01,1.37800e+00,8.55400e-01,
2.00000e-01,6.86000e-01,4.38100e-01,3.00000e-01,2.88200e-01,1.73700e-01,4.00000e-01,1.74900e-01,9.74100e-02,5.00000e-01,
1.27400e-01,6.67100e-02,6.00000e-01,1.02500e-01,5.15900e-02,8.00000e-01,7.71000e-02,3.75400e-02,1.00000e+00,6.39700e-02,
3.10700e-02,1.00000e-03,3.18700e+03,3.17500e+03,1.50000e-03,1.42400e+03,1.41300e+03,1.58850e-03,1.26400e+03,1.25300e+03,
1.58850e-03,1.59700e+03,1.58100e+03,1.61375e-03,2.30200e+03,2.27300e+03,1.63940e-03,3.44200e+03,3.39600e+03,1.63940e-03,
3.93500e+03,3.88100e+03,2.00000e-03,3.45200e+03,3.40600e+03,2.02360e-03,3.35200e+03,3.30700e+03,2.02360e-03,3.89000e+03,
3.83800e+03,2.14019e-03,3.39700e+03,3.35200e+03,2.26350e-03,2.96900e+03,2.93100e+03,2.26350e-03,3.15500e+03,3.11500e+03,
2.37462e-03,2.82600e+03,2.79000e+03,2.49120e-03,2.53100e+03,2.49900e+03,2.49120e-03,2.64000e+03,2.60700e+03,3.00000e-03,
1.71000e+03,1.68800e+03,4.00000e-03,8.56000e+02,8.43000e+02,5.00000e-03,4.93400e+02,4.83900e+02,6.00000e-03,3.12900e+02,
3.05100e+02,8.00000e-03,1.51300e+02,1.45600e+02,9.24410e-03,1.04900e+02,9.99400e+01,9.24410e-03,2.70300e+02,2.32400e+02,
1.00000e-02,2.21100e+02,1.91600e+02,1.03486e-02,2.01900e+02,1.75600e+02,1.03486e-02,2.75700e+02,2.31000e+02,1.06063e-02,
2.67600e+02,2.19000e+02,1.08704e-02,2.45000e+02,2.06500e+02,1.08704e-02,2.82600e+02,2.36900e+02,1.50000e-02,1.24700e+02,
1.08400e+02,2.00000e-02,5.88100e+01,5.20600e+01,3.00000e-02,2.02300e+01,1.79100e+01,4.00000e-02,9.47200e+00,8.24200e+00,
5.00000e-02,5.27900e+00,4.48000e+00,6.00000e-02,3.29700e+00,2.71200e+00,6.33138e-02,2.87400e+00,2.33900e+00,6.33138e-02,
1.30500e+01,3.77000e+00,8.00000e-02,7.16100e+00,3.00000e+00,1.00000e-01,4.03300e+00,2.06700e+00,1.50000e-01,1.43300e+00,
8.80500e-01,2.00000e-01,7.13000e-01,4.53400e-01,3.00000e-01,2.98100e-01,1.80300e-01,4.00000e-01,1.79900e-01,1.00900e-01,
5.00000e-01,1.30500e-01,6.88600e-02,6.00000e-01,1.04600e-01,5.30600e-02,8.00000e-01,7.82900e-02,3.83600e-02,1.00000e+00,
6.47800e-02,3.16100e-02,1.00000e-03,3.33500e+03,3.32400e+03,1.50000e-03,1.48900e+03,1.47800e+03,1.66170e-03,1.20300e+03,
1.19200e+03,1.66170e-03,1.50500e+03,1.48900e+03,1.68883e-03,2.18900e+03,2.16000e+03,1.71640e-03,3.27300e+03,3.22500e+03,
1.71640e-03,3.68200e+03,3.62800e+03,2.00000e-03,3.59800e+03,3.54600e+03,2.10760e-03,3.15200e+03,3.10800e+03,2.10760e-03,
3.65900e+03,3.60700e+03,2.23278e-03,3.18200e+03,3.13700e+03,2.36540e-03,2.76900e+03,2.73100e+03,2.36540e-03,2.94300e+03,
2.90300e+03,2.48036e-03,2.63700e+03,2.60100e+03,2.60090e-03,2.36300e+03,2.33100e+03,2.60090e-03,2.46500e+03,2.43200e+03,
3.00000e-03,1.76800e+03,1.74500e+03,4.00000e-03,8.85900e+02,8.72000e+02,5.00000e-03,5.11300e+02,5.01300e+02,6.00000e-03,
3.24400e+02,3.16400e+02,8.00000e-03,1.57100e+02,1.51200e+02,9.56070e-03,9.99700e+01,9.51000e+01,9.56070e-03,2.55700e+02,
2.18400e+02,1.00000e-02,2.30100e+02,1.97500e+02,1.07394e-02,1.89400e+02,1.63900e+02,1.07394e-02,2.58900e+02,2.15100e+02,
1.10018e-02,2.52200e+02,2.04200e+02,1.12707e-02,2.30600e+02,1.92800e+02,1.12707e-02,2.65900e+02,2.21200e+02,1.50000e-02,
1.29000e+02,1.11100e+02,2.00000e-02,6.08700e+01,5.35300e+01,3.00000e-02,2.09800e+01,1.85100e+01,4.00000e-02,9.82800e+00,
8.54200e+00,5.00000e-02,5.47800e+00,4.65100e+00,6.00000e-02,3.42000e+00,2.82000e+00,6.53508e-02,2.75100e+00,2.22800e+00,
6.53508e-02,1.23700e+01,3.55700e+00,8.00000e-02,7.35200e+00,2.95800e+00,1.00000e-01,4.15400e+00,2.07500e+00,1.50000e-01,
1.47700e+00,8.97300e-01,2.00000e-01,7.33900e-01,4.64500e-01,3.00000e-01,3.05400e-01,1.85300e-01,4.00000e-01,1.83400e-01,
1.03500e-01,5.00000e-01,1.32400e-01,7.04400e-02,6.00000e-01,1.05800e-01,5.40900e-02,8.00000e-01,7.88000e-02,3.88600e-02,
1.00000e+00,6.50200e-02,3.18800e-02,1.00000e-03,3.51000e+03,3.49800e+03,1.50000e-03,1.56600e+03,1.55500e+03,1.73510e-03,
1.15400e+03,1.14400e+03,1.73510e-03,1.41700e+03,1.40100e+03,1.76391e-03,2.05300e+03,2.02400e+03,1.79320e-03,3.08200e+03,
3.03400e+03,1.79320e-03,3.42100e+03,3.36700e+03,2.00000e-03,3.77100e+03,3.71100e+03,2.19400e-03,2.98500e+03,2.93900e+03,
2.19400e-03,3.46400e+03,3.41100e+03,2.32730e-03,3.00300e+03,2.95700e+03,2.46870e-03,2.60400e+03,2.56600e+03,2.46870e-03,
2.76800e+03,2.72700e+03,2.58558e-03,2.48600e+03,2.44900e+03,2.70800e-03,2.23300e+03,2.20100e+03,2.70800e-03,2.32900e+03,
2.29600e+03,3.00000e-03,1.83800e+03,1.81200e+03,4.00000e-03,9.22200e+02,9.07300e+02,5.00000e-03,5.32800e+02,5.22300e+02,
6.00000e-03,3.38200e+02,3.29900e+02,8.00000e-03,1.63900e+02,1.57900e+02,9.88110e-03,9.59900e+01,9.11700e+01,9.88110e-03,
2.44300e+02,2.07300e+02,1.00000e-02,2.37900e+02,2.02100e+02,1.11361e-02,1.79100e+02,1.54000e+02,1.11361e-02,2.44900e+02,
2.01800e+02,1.14055e-02,2.39300e+02,1.91700e+02,1.16815e-02,2.18200e+02,1.81100e+02,1.16815e-02,2.51800e+02,2.07700e+02,
1.50000e-02,1.34000e+02,1.14300e+02,2.00000e-02,6.33400e+01,5.53200e+01,3.00000e-02,2.18700e+01,1.92300e+01,4.00000e-02,
1.02500e+01,8.89900e+00,5.00000e-02,5.71700e+00,4.85400e+00,6.00000e-02,3.56900e+00,2.94700e+00,6.74164e-02,2.65200e+00,
2.13900e+00,6.74164e-02,1.18000e+01,3.37900e+00,8.00000e-02,7.58700e+00,2.92400e+00,1.00000e-01,4.30200e+00,2.09200e+00,
1.50000e-01,1.53100e+00,9.18800e-01,2.00000e-01,7.59800e-01,4.78400e-01,3.00000e-01,3.14900e-01,1.91500e-01,4.00000e-01,
1.88100e-01,1.06900e-01,5.00000e-01,1.35200e-01,7.24800e-02,6.00000e-01,1.07600e-01,5.54500e-02,8.00000e-01,7.98100e-02,
3.96000e-02,1.00000e+00,6.56700e-02,3.23500e-02,1.00000e-03,3.68300e+03,3.67100e+03,1.50000e-03,1.64300e+03,1.63200e+03,
1.80920e-03,1.10800e+03,1.09700e+03,1.80920e-03,1.32700e+03,1.31100e+03,1.84014e-03,1.91100e+03,1.88300e+03,1.87160e-03,
2.90100e+03,2.85300e+03,1.87160e-03,3.17000e+03,3.11600e+03,2.00000e-03,3.92200e+03,3.85300e+03,2.28100e-03,2.82800e+03,
2.78100e+03,2.28100e-03,3.27900e+03,3.22600e+03,2.42350e-03,2.83300e+03,2.78600e+03,2.57490e-03,2.44500e+03,2.40700e+03,
2.57490e-03,2.59900e+03,2.55800e+03,2.69447e-03,2.33900e+03,2.30100e+03,2.81960e-03,2.10400e+03,2.07100e+03,2.81960e-03,
2.19400e+03,2.16000e+03,3.00000e-03,1.90200e+03,1.87300e+03,4.00000e-03,9.56400e+02,9.40500e+02,5.00000e-03,5.53400e+02,
5.42300e+02,6.00000e-03,3.51400e+02,3.42800e+02,8.00000e-03,1.70500e+02,1.64300e+02,1.00000e-02,9.69100e+01,9.20400e+01,
1.02068e-02,9.20100e+01,8.72400e+01,1.02068e-02,2.33400e+02,1.96600e+02,1.08548e-02,1.98300e+02,1.68400e+02,1.15440e-02,
1.68900e+02,1.44400e+02,1.15440e-02,2.31200e+02,1.88900e+02,1.18186e-02,2.26800e+02,1.79700e+02,1.20998e-02,2.06500e+02,
1.69900e+02,1.20998e-02,2.38200e+02,1.94800e+02,1.50000e-02,1.38900e+02,1.17200e+02,2.00000e-02,6.57300e+01,5.69700e+01,
3.00000e-02,2.27300e+01,1.99100e+01,4.00000e-02,1.06700e+01,9.24000e+00,5.00000e-02,5.94900e+00,5.05000e+00,6.00000e-02,
3.71300e+00,3.07000e+00,6.95250e-02,2.55200e+00,2.04900e+00,6.95250e-02,1.12300e+01,3.21200e+00,8.00000e-02,7.81000e+00,
2.87900e+00,1.00000e-01,4.43800e+00,2.10000e+00,1.50000e-01,1.58100e+00,9.37800e-01,2.00000e-01,7.84400e-01,4.91300e-01,
3.00000e-01,3.23800e-01,1.97300e-01,4.00000e-01,1.92500e-01,1.10000e-01,5.00000e-01,1.37800e-01,7.44000e-02,6.00000e-01,
1.09300e-01,5.67300e-02,8.00000e-01,8.06600e-02,4.02800e-02,1.00000e+00,6.61800e-02,3.27600e-02,1.00000e-03,3.87200e+03,
3.86000e+03,1.50000e-03,1.72900e+03,1.71700e+03,1.82240e-03,1.14700e+03,1.13500e+03,1.82240e-03,1.15200e+03,1.14100e+03,
1.88459e-03,1.25100e+03,1.23500e+03,1.94890e-03,2.68900e+03,2.64200e+03,1.94890e-03,3.80200e+03,3.73000e+03,2.00000e-03,
3.77300e+03,3.70200e+03,2.36730e-03,2.69600e+03,2.64800e+03,2.36730e-03,3.12400e+03,3.06900e+03,2.51955e-03,2.68600e+03,
2.63900e+03,2.68160e-03,2.30900e+03,2.27000e+03,2.68160e-03,2.45400e+03,2.41200e+03,2.80386e-03,2.21000e+03,2.17400e+03,
2.93170e-03,1.99200e+03,1.95900e+03,2.93170e-03,2.07800e+03,2.04300e+03,3.00000e-03,1.97200e+03,1.93900e+03,4.00000e-03,
9.94300e+02,9.77100e+02,5.00000e-03,5.75900e+02,5.64200e+02,6.00000e-03,3.66000e+02,3.56900e+02,8.00000e-03,1.77800e+02,
1.71400e+02,1.00000e-02,1.01100e+02,9.61000e+01,1.05353e-02,8.85800e+01,8.38600e+01,1.05353e-02,2.23400e+02,1.86900e+02,
1.12245e-02,1.96400e+02,1.59400e+02,1.19587e-02,1.60000e+02,1.36000e+02,1.19587e-02,2.19100e+02,1.77600e+02,1.22394e-02,
2.07900e+02,1.69000e+02,1.25267e-02,1.96100e+02,1.60000e+02,1.25267e-02,2.26200e+02,1.83400e+02,1.50000e-02,1.44000e+02,
1.20100e+02,2.00000e-02,6.83500e+01,5.87600e+01,3.00000e-02,2.36700e+01,2.06400e+01,4.00000e-02,1.11200e+01,9.61400e+00,
5.00000e-02,6.20600e+00,5.26500e+00,6.00000e-02,3.87200e+00,3.20500e+00,7.16764e-02,2.46400e+00,1.97000e+00,7.16764e-02,
1.07300e+01,3.05800e+00,8.00000e-02,8.06900e+00,2.83200e+00,1.00000e-01,4.58700e+00,2.10700e+00,1.50000e-01,1.63700e+00,
9.58000e-01,2.00000e-01,8.11900e-01,5.05400e-01,3.00000e-01,3.33900e-01,2.03800e-01,4.00000e-01,1.97600e-01,1.13500e-01,
5.00000e-01,1.40900e-01,7.65800e-02,6.00000e-01,1.11400e-01,5.82200e-02,8.00000e-01,8.17900e-02,4.10900e-02,1.00000e+00,
6.68800e-02,3.32700e-02,1.00000e-03,4.03200e+03,4.01900e+03,1.50000e-03,1.80100e+03,1.79000e+03,1.96010e-03,1.02300e+03,
1.01200e+03,1.96010e-03,2.00300e+03,1.96900e+03,2.00000e-03,2.21800e+03,2.17900e+03,2.03080e-03,2.62200e+03,2.57300e+03,
2.03080e-03,2.86400e+03,2.81000e+03,2.23385e-03,2.85200e+03,2.79700e+03,2.45720e-03,2.54600e+03,2.49800e+03,2.45720e-03,
2.94800e+03,2.89300e+03,2.61935e-03,2.52400e+03,2.47800e+03,2.79220e-03,2.16100e+03,2.12300e+03,2.79220e-03,2.29600e+03,
2.25500e+03,3.00000e-03,1.93800e+03,1.90400e+03,3.04850e-03,1.86900e+03,1.83600e+03,3.04850e-03,1.94900e+03,1.91500e+03,
4.00000e-03,1.02300e+03,1.00400e+03,5.00000e-03,5.93600e+02,5.81300e+02,6.00000e-03,3.77600e+02,3.68200e+02,8.00000e-03,
1.83600e+02,1.77000e+02,1.00000e-02,1.04500e+02,9.94000e+01,1.08709e-02,8.45800e+01,7.99400e+01,1.08709e-02,2.12100e+02,
1.76200e+02,1.16033e-02,1.86000e+02,1.49500e+02,1.23850e-02,1.50300e+02,1.27100e+02,1.23850e-02,2.06000e+02,1.65400e+02,
1.26731e-02,1.95600e+02,1.57600e+02,1.29680e-02,1.84600e+02,1.49400e+02,1.29680e-02,2.12900e+02,1.71100e+02,1.50000e-02,
1.47800e+02,1.21800e+02,2.00000e-02,7.03900e+01,5.99900e+01,3.00000e-02,2.44300e+01,2.12000e+01,4.00000e-02,1.14900e+01,
9.90700e+00,5.00000e-02,6.41400e+00,5.43700e+00,6.00000e-02,4.00200e+00,3.31400e+00,7.38708e-02,2.36000e+00,1.87900e+00,
7.38708e-02,1.01600e+01,2.88800e+00,8.00000e-02,8.29000e+00,2.75600e+00,1.00000e-01,4.69600e+00,2.09200e+00,1.50000e-01,
1.68000e+00,9.69600e-01,2.00000e-01,8.32700e-01,5.15000e-01,3.00000e-01,3.41400e-01,2.08500e-01,4.00000e-01,2.01100e-01,
1.16100e-01,5.00000e-01,1.42800e-01,7.81300e-02,6.00000e-01,1.12500e-01,5.92300e-02,8.00000e-01,8.22400e-02,4.15700e-02,
1.00000e+00,6.70500e-02,3.35100e-02,1.00000e-03,4.24300e+03,4.23000e+03,1.50000e-03,1.89800e+03,1.88600e+03,2.00000e-03,
1.03200e+03,1.02100e+03,2.04040e-03,9.88200e+02,9.77100e+02,2.04040e-03,1.06600e+03,1.05300e+03,2.07790e-03,1.49200e+03,
1.46600e+03,2.11610e-03,2.47800e+03,2.42900e+03,2.11610e-03,2.60800e+03,2.55600e+03,2.32326e-03,2.62100e+03,2.56600e+03,
2.55070e-03,2.42400e+03,2.37600e+03,2.55070e-03,2.80000e+03,2.74400e+03,2.72382e-03,2.39300e+03,2.34500e+03,2.90870e-03,
2.04100e+03,2.00200e+03,2.90870e-03,2.16600e+03,2.12500e+03,3.00000e-03,2.01100e+03,1.97300e+03,3.17370e-03,1.76700e+03,
1.73400e+03,3.17370e-03,1.84300e+03,1.80900e+03,4.00000e-03,1.06300e+03,1.04300e+03,5.00000e-03,6.17800e+02,6.04700e+02,
6.00000e-03,3.93500e+02,3.83700e+02,8.00000e-03,1.91400e+02,1.84600e+02,1.00000e-02,1.09000e+02,1.03800e+02,1.12154e-02,
8.15500e+01,7.69500e+01,1.12154e-02,2.03800e+02,1.68100e+02,1.19928e-02,1.70200e+02,1.41800e+02,1.28241e-02,1.42600e+02,
1.19900e+02,1.28241e-02,1.95900e+02,1.55900e+02,1.31179e-02,1.93300e+02,1.48600e+02,1.34185e-02,1.75600e+02,1.40900e+02,
1.34185e-02,2.02500e+02,1.61300e+02,1.50000e-02,1.53000e+02,1.24400e+02,2.00000e-02,7.31700e+01,6.17900e+01,3.00000e-02,
2.54600e+01,2.19800e+01,4.00000e-02,1.19900e+01,1.03000e+01,5.00000e-02,6.69300e+00,5.66700e+00,6.00000e-02,4.17600e+00,
3.46000e+00,7.61110e-02,2.28400e+00,1.81000e+00,7.61110e-02,9.72800e+00,2.75800e+00,8.00000e-02,8.58500e+00,2.69400e+00,
1.00000e-01,4.85500e+00,2.09300e+00,1.50000e-01,1.74000e+00,9.90300e-01,2.00000e-01,8.62800e-01,5.29000e-01,3.00000e-01,
3.52500e-01,2.15500e-01,4.00000e-01,2.06800e-01,1.19900e-01,5.00000e-01,1.46300e-01,8.05400e-02,6.00000e-01,1.14900e-01,
6.08800e-02,8.00000e-01,8.35700e-02,4.25000e-02,1.00000e+00,6.79400e-02,3.41200e-02,1.00000e-03,4.43300e+03,4.42100e+03,
1.50000e-03,1.98600e+03,1.97400e+03,2.00000e-03,1.08100e+03,1.06900e+03,2.12160e-03,9.50600e+02,9.39300e+02,2.12160e-03,
1.03400e+03,1.02100e+03,2.16138e-03,1.43100e+03,1.40500e+03,2.20190e-03,2.34100e+03,2.29200e+03,2.20190e-03,2.48700e+03,
2.43400e+03,2.41348e-03,2.51200e+03,2.45700e+03,2.64540e-03,2.30700e+03,2.25800e+03,2.64540e-03,2.66300e+03,2.60600e+03,
3.00000e-03,1.96500e+03,1.92500e+03,3.02650e-03,1.92300e+03,1.88400e+03,3.02650e-03,2.04100e+03,2.00000e+03,3.15838e-03,
1.84400e+03,1.80600e+03,3.29600e-03,1.67100e+03,1.63700e+03,3.29600e-03,1.74200e+03,1.70700e+03,4.00000e-03,1.10000e+03,
1.07800e+03,5.00000e-03,6.40200e+02,6.26200e+02,6.00000e-03,4.08300e+02,3.97900e+02,8.00000e-03,1.98700e+02,1.91700e+02,
1.00000e-02,1.13200e+02,1.07800e+02,1.15637e-02,7.84400e+01,7.38800e+01,1.15637e-02,1.94600e+02,1.59400e+02,1.23887e-02,
1.61800e+02,1.33900e+02,1.32726e-02,1.34900e+02,1.12700e+02,1.32726e-02,1.85300e+02,1.46300e+02,1.35729e-02,1.84800e+02,
1.39500e+02,1.38799e-02,1.66600e+02,1.32500e+02,1.38799e-02,1.92100e+02,1.51700e+02,1.50000e-02,1.57800e+02,1.26500e+02,
2.00000e-02,7.57400e+01,6.33300e+01,3.00000e-02,2.64100e+01,2.26800e+01,4.00000e-02,1.24500e+01,1.06700e+01,5.00000e-02,
6.95400e+00,5.87900e+00,6.00000e-02,4.33900e+00,3.59500e+00,7.83948e-02,2.20300e+00,1.73800e+00,7.83948e-02,9.30100e+00,
2.62700e+00,8.00000e-02,8.73100e+00,2.59200e+00,1.00000e-01,4.99300e+00,2.08100e+00,1.50000e-01,1.79500e+00,1.00600e+00,
2.00000e-01,8.89600e-01,5.41300e-01,3.00000e-01,3.62500e-01,2.21600e-01,4.00000e-01,2.11800e-01,1.23300e-01,5.00000e-01,
1.49200e-01,8.26500e-02,6.00000e-01,1.16800e-01,6.23000e-02,8.00000e-01,8.45600e-02,4.32500e-02,1.00000e+00,6.85700e-02,
3.45900e-02,1.00000e-03,4.65200e+03,4.63900e+03,1.50000e-03,2.08900e+03,2.07600e+03,2.00000e-03,1.13700e+03,1.12500e+03,
2.20570e-03,9.18700e+02,9.07400e+02,2.20570e-03,9.97100e+02,9.83600e+02,2.24799e-03,1.38600e+03,1.36000e+03,2.29110e-03,
2.25800e+03,2.20800e+03,2.29110e-03,2.38900e+03,2.33600e+03,2.50689e-03,2.38000e+03,2.32500e+03,2.74300e-03,2.20300e+03,
2.15400e+03,2.74300e-03,2.54100e+03,2.48400e+03,3.00000e-03,2.04900e+03,2.00500e+03,3.14780e-03,1.82200e+03,1.78300e+03,
3.14780e-03,1.93300e+03,1.89200e+03,3.28343e-03,1.74800e+03,1.71000e+03,3.42490e-03,1.58500e+03,1.55200e+03,3.42490e-03,
1.65200e+03,1.61800e+03,4.00000e-03,1.14400e+03,1.12000e+03,5.00000e-03,6.66100e+02,6.51200e+02,6.00000e-03,4.25300e+02,
4.14300e+02,8.00000e-03,2.07200e+02,1.99900e+02,1.00000e-02,1.18100e+02,1.12600e+02,1.19187e-02,7.58200e+01,7.12900e+01,
1.19187e-02,1.87000e+02,1.52100e+02,1.27940e-02,1.54600e+02,1.27200e+02,1.37336e-02,1.28300e+02,1.06600e+02,1.37336e-02,
1.76400e+02,1.37900e+02,1.40398e-02,1.76600e+02,1.31700e+02,1.43528e-02,1.58800e+02,1.25200e+02,1.43528e-02,1.83000e+02,
1.43200e+02,1.50000e-02,1.63700e+02,1.29400e+02,2.00000e-02,7.88300e+01,6.52200e+01,3.00000e-02,2.75200e+01,2.34900e+01,
4.00000e-02,1.29800e+01,1.10900e+01,5.00000e-02,7.25600e+00,6.12400e+00,6.00000e-02,4.52800e+00,3.75100e+00,8.00000e-02,
2.18500e+00,1.72000e+00,8.07249e-02,2.13700e+00,1.67800e+00,8.07249e-02,8.90400e+00,2.51200e+00,1.00000e-01,5.15800e+00,
2.07400e+00,1.50000e-01,1.86000e+00,1.02600e+00,2.00000e-01,9.21400e-01,5.56300e-01,3.00000e-01,3.74400e-01,2.28900e-01,
4.00000e-01,2.18000e-01,1.27400e-01,5.00000e-01,1.53000e-01,8.52300e-02,6.00000e-01,1.19400e-01,6.40900e-02,8.00000e-01,
8.60300e-02,4.42700e-02,1.00000e+00,6.95300e-02,3.52500e-02,1.00000e-03,4.83000e+03,4.81700e+03,1.50000e-03,2.17400e+03,
2.16100e+03,2.00000e-03,1.18400e+03,1.17200e+03,2.29490e-03,8.77300e+02,8.66000e+02,2.29490e-03,9.92500e+02,9.77800e+02,
2.33947e-03,1.40700e+03,1.37800e+03,2.38490e-03,2.15100e+03,2.10100e+03,2.38490e-03,2.31600e+03,2.26100e+03,2.60577e-03,
2.25700e+03,2.20200e+03,2.84710e-03,2.08000e+03,2.03000e+03,2.84710e-03,2.40000e+03,2.34300e+03,3.00000e-03,2.11700e+03,
2.06900e+03,3.27850e-03,1.70400e+03,1.66600e+03,3.27850e-03,1.80800e+03,1.76700e+03,3.41712e-03,1.63800e+03,1.60000e+03,
3.56160e-03,1.48600e+03,1.45400e+03,3.56160e-03,1.54900e+03,1.51500e+03,4.00000e-03,1.17900e+03,1.15300e+03,5.00000e-03,
6.86900e+02,6.71000e+02,6.00000e-03,4.38700e+02,4.27200e+02,8.00000e-03,2.14000e+02,2.06500e+02,1.00000e-02,1.22100e+02,
1.16400e+02,1.22839e-02,7.26600e+01,6.82100e+01,1.22839e-02,1.78000e+02,1.43700e+02,1.32113e-02,1.46400e+02,1.19700e+02,
1.42087e-02,1.20900e+02,9.98800e+01,1.42087e-02,1.66300e+02,1.28900e+02,1.45206e-02,1.67400e+02,1.23300e+02,1.48393e-02,
1.50100e+02,1.17300e+02,1.48393e-02,1.72800e+02,1.34000e+02,1.50000e-02,1.68100e+02,1.30700e+02,2.00000e-02,8.12300e+01,
6.64700e+01,3.00000e-02,2.84100e+01,2.41000e+01,4.00000e-02,1.34200e+01,1.14100e+01,5.00000e-02,7.50400e+00,6.32100e+00,
6.00000e-02,4.68300e+00,3.87800e+00,8.00000e-02,2.25900e+00,1.78200e+00,8.31023e-02,2.05500e+00,1.60700e+00,8.31023e-02,
8.46400e+00,2.38400e+00,1.00000e-01,5.27900e+00,2.04300e+00,1.50000e-01,1.90900e+00,1.03600e+00,2.00000e-01,9.45600e-01,
5.66100e-01,3.00000e-01,3.83400e-01,2.34200e-01,4.00000e-01,2.22400e-01,1.30400e-01,5.00000e-01,1.55500e-01,8.71100e-02,
6.00000e-01,1.21000e-01,6.53600e-02,8.00000e-01,8.67900e-02,4.49300e-02,1.00000e+00,6.99300e-02,3.56300e-02,1.00000e-03,
5.00800e+03,4.99500e+03,1.50000e-03,2.25900e+03,2.24700e+03,2.00000e-03,1.23100e+03,1.21900e+03,2.38930e-03,8.35200e+02,
8.24000e+02,2.38930e-03,1.13600e+03,1.11500e+03,2.43673e-03,1.58200e+03,1.54600e+03,2.48510e-03,2.04900e+03,1.99900e+03,
2.48510e-03,2.36400e+03,2.30300e+03,2.71062e-03,2.20700e+03,2.15000e+03,2.95660e-03,1.95800e+03,1.91000e+03,2.95660e-03,
2.26700e+03,2.21000e+03,3.00000e-03,2.18800e+03,2.13500e+03,3.41570e-03,1.59100e+03,1.55300e+03,3.41570e-03,1.68700e+03,
1.64700e+03,3.55698e-03,1.53000e+03,1.49500e+03,3.70410e-03,1.39200e+03,1.36000e+03,3.70410e-03,1.45200e+03,1.41900e+03,
4.00000e-03,1.21200e+03,1.18500e+03,5.00000e-03,7.06800e+02,6.90000e+02,6.00000e-03,4.51800e+02,4.39800e+02,8.00000e-03,
2.20800e+02,2.13100e+02,1.00000e-02,1.26000e+02,1.20200e+02,1.26575e-02,6.95700e+01,6.52100e+01,1.26575e-02,1.69300e+02,
1.35700e+02,1.36396e-02,1.47300e+02,1.12600e+02,1.46979e-02,1.13900e+02,9.35600e+01,1.46979e-02,1.57200e+02,1.20700e+02,
1.50000e-02,1.49700e+02,1.15400e+02,1.53467e-02,1.41600e+02,1.09700e+02,1.53467e-02,1.63200e+02,1.25400e+02,2.00000e-02,
8.36100e+01,6.76100e+01,3.00000e-02,2.92900e+01,2.46700e+01,4.00000e-02,1.38500e+01,1.17300e+01,5.00000e-02,7.75100e+00,
6.51300e+00,6.00000e-02,4.83800e+00,4.00300e+00,8.00000e-02,2.33200e+00,1.84400e+00,8.55304e-02,1.97600e+00,1.53900e+00,
8.55304e-02,8.04600e+00,2.26400e+00,1.00000e-01,5.39800e+00,2.00700e+00,1.50000e-01,1.95700e+00,1.04400e+00,2.00000e-01,
9.69600e-01,5.75300e-01,3.00000e-01,3.92300e-01,2.39300e-01,4.00000e-01,2.26700e-01,1.33400e-01,5.00000e-01,1.58000e-01,
8.89700e-02,6.00000e-01,1.22600e-01,6.66100e-02,8.00000e-01,8.75100e-02,4.55700e-02,1.00000e+00,7.03100e-02,3.60000e-02,
1.00000e-03,5.21000e+03,5.19700e+03,1.50000e-03,2.35600e+03,2.34400e+03,2.00000e-03,1.28500e+03,1.27400e+03,2.48400e-03,
8.00600e+02,7.89500e+02,2.48400e-03,1.39700e+03,1.36600e+03,2.53429e-03,1.72600e+03,1.68200e+03,2.58560e-03,1.94400e+03,
1.89500e+03,2.58560e-03,2.45800e+03,2.39000e+03,3.00000e-03,1.96500e+03,1.91300e+03,3.06640e-03,1.85700e+03,1.80800e+03,
3.06640e-03,2.14600e+03,2.09000e+03,3.30130e-03,1.79600e+03,1.74800e+03,3.55420e-03,1.49600e+03,1.45900e+03,3.55420e-03,
1.58500e+03,1.54600e+03,3.69948e-03,1.44200e+03,1.40500e+03,3.85070e-03,1.31100e+03,1.27900e+03,3.85070e-03,1.36800e+03,
1.33500e+03,4.00000e-03,1.25100e+03,1.22100e+03,5.00000e-03,7.30400e+02,7.12400e+02,6.00000e-03,4.67200e+02,4.54600e+02,
8.00000e-03,2.28700e+02,2.20700e+02,1.00000e-02,1.30600e+02,1.24700e+02,1.30352e-02,6.70100e+01,6.27000e+01,1.30352e-02,
1.62100e+02,1.29100e+02,1.50000e-02,1.11600e+02,9.10000e+01,1.52000e-02,1.07800e+02,8.80700e+01,1.52000e-02,1.48500e+02,
1.13100e+02,1.55269e-02,1.41600e+02,1.08300e+02,1.58608e-02,1.34400e+02,1.03200e+02,1.58608e-02,1.54800e+02,1.18000e+02,
2.00000e-02,8.63600e+01,6.89900e+01,3.00000e-02,3.03200e+01,2.53600e+01,4.00000e-02,1.43600e+01,1.21100e+01,5.00000e-02,
8.04100e+00,6.74000e+00,6.00000e-02,5.02100e+00,4.14900e+00,8.00000e-02,2.41900e+00,1.91600e+00,8.80045e-02,1.91000e+00,
1.48200e+00,8.80045e-02,7.68300e+00,2.16000e+00,1.00000e-01,5.54900e+00,1.97600e+00,1.50000e-01,2.01400e+00,1.05600e+00,
2.00000e-01,9.98500e-01,5.87000e-01,3.00000e-01,4.03100e-01,2.45500e-01,4.00000e-01,2.32300e-01,1.37000e-01,5.00000e-01,
1.61400e-01,9.12800e-02,6.00000e-01,1.24800e-01,6.81900e-02,8.00000e-01,8.87000e-02,4.64400e-02,1.00000e+00,7.10200e-02,
3.65400e-02,1.00000e-03,5.44100e+03,5.42700e+03,1.50000e-03,2.46800e+03,2.45500e+03,2.00000e-03,1.34800e+03,1.33600e+03,
2.57960e-03,7.72400e+02,7.61200e+02,2.57960e-03,1.77700e+03,1.73100e+03,2.63305e-03,1.85000e+03,1.79900e+03,2.68760e-03,
1.85200e+03,1.80200e+03,2.68760e-03,2.57600e+03,2.50000e+03,3.00000e-03,2.05300e+03,1.99600e+03,3.17690e-03,1.77400e+03,
1.72500e+03,3.17690e-03,2.04800e+03,1.99200e+03,3.42677e-03,1.70700e+03,1.65900e+03,3.69630e-03,1.41500e+03,1.37800e+03,
3.69630e-03,1.49800e+03,1.46000e+03,3.84472e-03,1.36600e+03,1.32900e+03,3.99910e-03,1.24300e+03,1.21100e+03,3.99910e-03,
1.29700e+03,1.26400e+03,4.00000e-03,1.29600e+03,1.26300e+03,5.00000e-03,7.58000e+02,7.38600e+02,6.00000e-03,4.85500e+02,
4.72100e+02,8.00000e-03,2.37800e+02,2.29500e+02,1.00000e-02,1.36000e+02,1.29800e+02,1.34186e-02,6.49100e+01,6.06400e+01,
1.34186e-02,1.56000e+02,1.23400e+02,1.50000e-02,1.16000e+02,9.35800e+01,1.57111e-02,1.02700e+02,8.34600e+01,1.57111e-02,
1.41600e+02,1.06900e+02,1.60457e-02,1.35100e+02,1.02400e+02,1.63875e-02,1.28200e+02,9.76900e+01,1.63875e-02,1.47800e+02,
1.11600e+02,2.00000e-02,8.95200e+01,7.06000e+01,3.00000e-02,3.15200e+01,2.61700e+01,4.00000e-02,1.49500e+01,1.25500e+01,
5.00000e-02,8.37900e+00,7.00400e+00,6.00000e-02,5.23300e+00,4.32000e+00,8.00000e-02,2.52200e+00,1.99900e+00,9.05259e-02,
1.85600e+00,1.43400e+00,9.05259e-02,7.38000e+00,2.07300e+00,1.00000e-01,5.73900e+00,1.95100e+00,1.50000e-01,2.08200e+00,
1.07100e+00,2.00000e-01,1.03300e+00,6.01400e-01,3.00000e-01,4.16300e-01,2.53200e-01,4.00000e-01,2.39100e-01,1.41400e-01,
5.00000e-01,1.65600e-01,9.41100e-02,6.00000e-01,1.27700e-01,7.01700e-02,8.00000e-01,9.03600e-02,4.75800e-02,1.00000e+00,
7.21400e-02,3.73000e-02,1.00000e-03,5.72400e+03,5.71000e+03,1.50000e-03,2.60400e+03,2.59100e+03,2.00000e-03,1.42300e+03,
1.41100e+03,2.68300e-03,7.48200e+02,7.36900e+02,2.68300e-03,2.20600e+03,2.14200e+03,2.73990e-03,1.94100e+03,1.88400e+03,
2.79800e-03,1.77500e+03,1.72600e+03,2.79800e-03,2.71100e+03,2.62500e+03,3.00000e-03,2.15500e+03,2.09000e+03,3.30190e-03,
1.69300e+03,1.64500e+03,3.30190e-03,1.95600e+03,1.90000e+03,3.56733e-03,1.62200e+03,1.57600e+03,3.85410e-03,1.33900e+03,
1.30300e+03,3.85410e-03,1.41900e+03,1.38100e+03,4.00000e-03,1.29900e+03,1.26400e+03,4.14940e-03,1.19000e+03,1.15800e+03,
4.14940e-03,1.24200e+03,1.20900e+03,5.00000e-03,7.93100e+02,7.72100e+02,6.00000e-03,5.08500e+02,4.94200e+02,8.00000e-03,
2.49400e+02,2.40600e+02,1.00000e-02,1.42700e+02,1.36300e+02,1.38138e-02,6.33700e+01,5.91000e+01,1.38138e-02,1.51300e+02,
1.18900e+02,1.50000e-02,1.21900e+02,9.72800e+01,1.62443e-02,9.84900e+01,7.96500e+01,1.62443e-02,1.36100e+02,1.01900e+02,
1.65882e-02,1.29700e+02,9.75500e+01,1.69393e-02,1.23200e+02,9.30800e+01,1.69393e-02,1.42000e+02,1.06300e+02,2.00000e-02,
9.35200e+01,7.27800e+01,3.00000e-02,3.30300e+01,2.72100e+01,4.00000e-02,1.56900e+01,1.31100e+01,5.00000e-02,8.80200e+00,
7.33400e+00,6.00000e-02,5.49900e+00,4.53200e+00,8.00000e-02,2.64900e+00,2.10300e+00,9.31050e-02,1.82000e+00,1.40000e+00,
9.31050e-02,7.14000e+00,2.00500e+00,1.00000e-01,5.99100e+00,1.93600e+00,1.50000e-01,2.17000e+00,1.09500e+00,2.00000e-01,
1.07800e+00,6.20700e-01,3.00000e-01,4.33500e-01,2.63000e-01,4.00000e-01,2.48300e-01,1.47100e-01,5.00000e-01,1.71400e-01,
9.78100e-02,6.00000e-01,1.31800e-01,7.28100e-02,8.00000e-01,9.28600e-02,4.91600e-02,1.00000e+00,7.39100e-02,3.83900e-02,
1.00000e-03,5.86800e+03,5.85400e+03,1.02078e-03,5.65100e+03,5.63700e+03,1.04200e-03,5.43500e+03,5.42000e+03,1.04200e-03,
5.55100e+03,5.53700e+03,1.50000e-03,2.73100e+03,2.71700e+03,2.00000e-03,1.49500e+03,1.48200e+03,2.78670e-03,7.22500e+02,
7.11200e+02,2.78670e-03,2.43100e+03,2.35500e+03,2.84705e-03,1.92800e+03,1.86900e+03,2.90870e-03,1.68600e+03,1.63800e+03,
2.90870e-03,2.76300e+03,2.67100e+03,3.00000e-03,2.25000e+03,2.17800e+03,3.42600e-03,1.61400e+03,1.56600e+03,3.42600e-03,
1.86600e+03,1.81100e+03,4.00000e-03,1.27500e+03,1.24000e+03,4.00800e-03,1.26900e+03,1.23300e+03,4.00800e-03,1.34500e+03,
1.30800e+03,4.15963e-03,1.23400e+03,1.19600e+03,4.31700e-03,1.12600e+03,1.09500e+03,4.31700e-03,1.17500e+03,1.14200e+03,
5.00000e-03,8.25100e+02,8.02500e+02,6.00000e-03,5.29900e+02,5.14600e+02,8.00000e-03,2.60100e+02,2.50900e+02,1.00000e-02,
1.49000e+02,1.42300e+02,1.42135e-02,6.16200e+01,5.73800e+01,1.42135e-02,1.46100e+02,1.14000e+02,1.50000e-02,1.27900e+02,
1.00800e+02,1.67847e-02,9.41700e+01,7.57600e+01,1.67847e-02,1.30200e+02,9.67000e+01,1.71352e-02,1.33800e+02,9.26400e+01,
1.74930e-02,1.18100e+02,8.84700e+01,1.74930e-02,1.36000e+02,1.01000e+02,2.00000e-02,9.70400e+01,7.44600e+01,3.00000e-02,
3.44200e+01,2.81200e+01,4.00000e-02,1.63800e+01,1.36100e+01,5.00000e-02,9.19600e+00,7.63700e+00,6.00000e-02,5.74800e+00,
4.72900e+00,8.00000e-02,2.76900e+00,2.20000e+00,9.57299e-02,1.77700e+00,1.36100e+00,9.57299e-02,6.89500e+00,1.93500e+00,
1.00000e-01,6.17400e+00,1.89700e+00,1.50000e-01,2.24900e+00,1.11200e+00,2.00000e-01,1.11800e+00,6.36900e-01,3.00000e-01,
4.49100e-01,2.71800e-01,4.00000e-01,2.56500e-01,1.52200e-01,5.00000e-01,1.76500e-01,1.01200e-01,6.00000e-01,1.35400e-01,
7.51700e-02,8.00000e-01,9.49500e-02,5.05500e-02,1.00000e+00,7.53800e-02,3.93400e-02,1.00000e-03,5.82600e+03,5.81200e+03,
1.04738e-03,5.35400e+03,5.34000e+03,1.09700e-03,4.90900e+03,4.89500e+03,1.09700e-03,5.01300e+03,5.00000e+03,1.50000e-03,
2.71900e+03,2.70600e+03,2.00000e-03,1.49000e+03,1.47800e+03,2.89240e-03,6.63400e+02,6.52600e+02,2.89240e-03,2.31900e+03,
2.24300e+03,3.00000e-03,1.55400e+03,1.50700e+03,3.02150e-03,1.52400e+03,1.47900e+03,3.02150e-03,2.47000e+03,2.38400e+03,
3.26957e-03,1.86700e+03,1.80400e+03,3.53800e-03,1.47900e+03,1.43300e+03,3.53800e-03,1.71000e+03,1.65700e+03,4.00000e-03,
1.26600e+03,1.22900e+03,4.15900e-03,1.14800e+03,1.11500e+03,4.15900e-03,1.21700e+03,1.18200e+03,4.31748e-03,1.11200e+03,
1.08000e+03,4.48200e-03,1.01700e+03,9.87700e+02,4.48200e-03,1.06100e+03,1.03100e+03,5.00000e-03,8.16300e+02,7.93100e+02,
6.00000e-03,5.24000e+02,5.08500e+02,8.00000e-03,2.57700e+02,2.48500e+02,1.00000e-02,1.47700e+02,1.41100e+02,1.46194e-02,
5.69700e+01,5.29600e+01,1.46194e-02,1.34400e+02,1.04200e+02,1.50000e-02,1.25900e+02,9.80700e+01,1.73371e-02,8.55700e+01,
6.85100e+01,1.73371e-02,1.18500e+02,8.72400e+01,1.76895e-02,1.22500e+02,8.36600e+01,1.80490e-02,1.07700e+02,8.00200e+01,
1.80490e-02,1.24100e+02,9.13000e+01,2.00000e-02,9.56300e+01,7.23100e+01,3.00000e-02,3.40800e+01,2.76000e+01,4.00000e-02,
1.62400e+01,1.34200e+01,5.00000e-02,9.12500e+00,7.55200e+00,6.00000e-02,5.70600e+00,4.68600e+00,8.00000e-02,2.74900e+00,
2.18500e+00,9.84040e-02,1.64900e+00,1.25800e+00,9.84040e-02,6.37100e+00,1.77900e+00,1.00000e-01,6.08600e+00,1.76600e+00,
1.50000e-01,2.21500e+00,1.07300e+00,2.00000e-01,1.10100e+00,6.20400e-01,3.00000e-01,4.42000e-01,2.66800e-01,4.00000e-01,
2.51800e-01,1.49600e-01,5.00000e-01,1.72800e-01,9.94100e-02,6.00000e-01,1.32200e-01,7.37700e-02,8.00000e-01,9.23000e-02,
4.94200e-02,1.00000e+00,7.30300e-02,3.83200e-02,1.00000e-03,6.23800e+03,6.22400e+03,1.07378e-03,5.35600e+03,5.34200e+03,
1.15300e-03,4.67300e+03,4.65900e+03,1.15300e-03,4.77200e+03,4.75800e+03,1.50000e-03,2.84600e+03,2.83300e+03,2.00000e-03,
1.56200e+03,1.54900e+03,2.99990e-03,6.41400e+02,6.30600e+02,2.99990e-03,1.99500e+03,1.92900e+03,3.00000e-03,1.99400e+03,
1.92800e+03,3.13620e-03,1.44900e+03,1.40500e+03,3.13620e-03,2.25500e+03,2.17500e+03,3.38938e-03,1.76100e+03,1.70000e+03,
3.66300e-03,1.41500e+03,1.37000e+03,3.66300e-03,1.64100e+03,1.58800e+03,4.00000e-03,1.32200e+03,1.28100e+03,4.32700e-03,
1.08600e+03,1.05300e+03,4.32700e-03,1.15300e+03,1.11800e+03,4.48656e-03,1.05900e+03,1.02300e+03,4.65200e-03,9.66600e+02,
9.37700e+02,4.65200e-03,1.00800e+03,9.78000e+02,5.00000e-03,8.48900e+02,8.23800e+02,6.00000e-03,5.45100e+02,5.28500e+02,
8.00000e-03,2.68400e+02,2.58800e+02,1.00000e-02,1.53900e+02,1.47100e+02,1.50000e-02,5.57300e+01,5.17400e+01,1.50312e-02,
5.54400e+01,5.14600e+01,1.50312e-02,1.30400e+02,1.00300e+02,1.64060e-02,1.03100e+02,8.08600e+01,1.79065e-02,8.18400e+01,
6.52100e+01,1.79065e-02,1.13700e+02,8.29900e+01,1.82691e-02,1.17900e+02,7.94700e+01,1.86390e-02,1.03100e+02,7.60200e+01,
1.86390e-02,1.18700e+02,8.66600e+01,2.00000e-02,9.93300e+01,7.39500e+01,3.00000e-02,3.55000e+01,2.84900e+01,4.00000e-02,
1.69400e+01,1.39100e+01,5.00000e-02,9.52500e+00,7.85100e+00,6.00000e-02,5.95900e+00,4.88100e+00,8.00000e-02,2.87100e+00,
2.28300e+00,1.00000e-01,1.65500e+00,1.26100e+00,1.01137e-01,1.61000e+00,1.22400e+00,1.01137e-01,6.08900e+00,1.71000e+00,
1.50000e-01,2.29500e+00,1.08700e+00,2.00000e-01,1.14100e+00,6.35100e-01,3.00000e-01,4.57700e-01,2.75000e-01,4.00000e-01,
2.60100e-01,1.54200e-01,5.00000e-01,1.78000e-01,1.02500e-01,6.00000e-01,1.35800e-01,7.59700e-02,8.00000e-01,9.44400e-02,
5.06700e-02,1.00000e+00,7.45000e-02,3.92000e-02,1.00000e-03,6.20100e+03,6.18700e+03,1.02840e-03,5.89500e+03,5.88100e+03,
1.05760e-03,5.60200e+03,5.58800e+03,1.05760e-03,5.68300e+03,5.66900e+03,1.13049e-03,5.01900e+03,5.00500e+03,1.20840e-03,
4.42400e+03,4.41100e+03,1.20840e-03,4.51600e+03,4.50200e+03,1.50000e-03,2.95000e+03,2.93700e+03,2.00000e-03,1.62000e+03,
1.60800e+03,3.00000e-03,6.66400e+02,6.55500e+02,3.10490e-03,6.16900e+02,6.06100e+02,3.10490e-03,1.71500e+03,1.65700e+03,
3.17584e-03,1.50600e+03,1.45700e+03,3.24840e-03,1.37400e+03,1.33100e+03,3.24840e-03,2.03900e+03,1.96500e+03,3.50960e-03,
1.64700e+03,1.58700e+03,3.79180e-03,1.34200e+03,1.29700e+03,3.79180e-03,1.55800e+03,1.50600e+03,4.00000e-03,1.36700e+03,
1.32200e+03,4.48950e-03,1.02400e+03,9.91700e+02,4.48950e-03,1.08600e+03,1.05200e+03,4.65278e-03,9.99500e+02,9.64300e+02,
4.82200e-03,9.12900e+02,8.84600e+02,4.82200e-03,9.52200e+02,9.22800e+02,5.00000e-03,8.74100e+02,8.47200e+02,6.00000e-03,
5.61300e+02,5.43800e+02,8.00000e-03,2.76900e+02,2.66900e+02,1.00000e-02,1.58900e+02,1.51900e+02,1.50000e-02,5.76000e+01,
5.35300e+01,1.54444e-02,5.35500e+01,4.96200e+01,1.54444e-02,1.25300e+02,9.58100e+01,1.68961e-02,9.83900e+01,7.67700e+01,
1.84843e-02,7.76600e+01,6.16000e+01,1.84843e-02,1.08100e+02,7.83500e+01,1.88568e-02,1.12600e+02,7.50000e+01,1.92367e-02,
9.79900e+01,7.17500e+01,1.92367e-02,1.12800e+02,8.17200e+01,2.00000e-02,1.02300e+02,7.49600e+01,3.00000e-02,3.66400e+01,
2.91300e+01,4.00000e-02,1.75000e+01,1.42900e+01,5.00000e-02,9.85000e+00,8.08800e+00,6.00000e-02,6.16600e+00,5.03900e+00,
8.00000e-02,2.97100e+00,2.36300e+00,1.00000e-01,1.71200e+00,1.30800e+00,1.03922e-01,1.56000e+00,1.18100e+00,1.03922e-01,
5.82600e+00,1.63800e+00,1.50000e-01,2.35500e+00,1.09100e+00,2.00000e-01,1.17200e+00,6.44000e-01,3.00000e-01,4.69600e-01,
2.81100e-01,4.00000e-01,2.66200e-01,1.58000e-01,5.00000e-01,1.81700e-01,1.05000e-01,6.00000e-01,1.38300e-01,7.77200e-02,
8.00000e-01,9.57900e-02,5.16500e-02,1.00000e+00,7.53500e-02,3.98300e-02,1.00000e-03,6.46900e+03,6.45500e+03,1.03923e-03,
6.03400e+03,6.02000e+03,1.08000e-03,5.62200e+03,5.60800e+03,1.08000e-03,5.70200e+03,5.68800e+03,1.17069e-03,4.90500e+03,
4.89100e+03,1.26900e-03,4.20300e+03,4.19000e+03,1.26900e-03,4.28900e+03,4.27500e+03,1.50000e-03,3.08200e+03,3.06900e+03,
2.00000e-03,1.69600e+03,1.68300e+03,3.00000e-03,6.98100e+02,6.87000e+02,3.21900e-03,5.95900e+02,5.85100e+02,3.21900e-03,
1.53700e+03,1.48500e+03,3.29373e-03,1.40400e+03,1.35800e+03,3.37020e-03,1.30700e+03,1.26400e+03,3.37020e-03,1.89200e+03,
1.82200e+03,3.62962e-03,1.56400e+03,1.50800e+03,3.90900e-03,1.29600e+03,1.25200e+03,3.90900e-03,1.50400e+03,1.45300e+03,
4.00000e-03,1.42600e+03,1.37700e+03,4.65600e-03,9.74500e+02,9.42800e+02,4.65600e-03,1.03400e+03,1.00000e+03,5.00000e-03,
8.68700e+02,8.40800e+02,5.00200e-03,8.67800e+02,8.39900e+02,5.00200e-03,9.05100e+02,8.76100e+02,6.00000e-03,5.82900e+02,
5.64100e+02,8.00000e-03,2.87800e+02,2.77300e+02,1.00000e-02,1.65300e+02,1.58000e+02,1.50000e-02,6.00200e+01,5.58300e+01,
1.58710e-02,5.21300e+01,4.82300e+01,1.58710e-02,1.21400e+02,9.22400e+01,1.74031e-02,1.04200e+02,7.35000e+01,1.90832e-02,
7.42600e+01,5.86500e+01,1.90832e-02,1.03600e+02,7.44800e+01,1.94579e-02,1.07900e+02,7.13300e+01,1.98400e-02,9.40300e+01,
6.83100e+01,1.98400e-02,1.08200e+02,7.77400e+01,2.00000e-02,1.06200e+02,7.64500e+01,3.00000e-02,3.81100e+01,3.00000e+01,
4.00000e-02,1.82300e+01,1.47900e+01,5.00000e-02,1.02700e+01,8.39600e+00,6.00000e-02,6.43300e+00,5.24200e+00,8.00000e-02,
3.10000e+00,2.46500e+00,1.00000e-01,1.78600e+00,1.36700e+00,1.06756e-01,1.52500e+00,1.15000e+00,1.06756e-01,5.62200e+00,
1.58200e+00,1.50000e-01,2.43400e+00,1.10000e+00,2.00000e-01,1.21300e+00,6.58100e-01,3.00000e-01,4.85900e-01,2.89600e-01,
4.00000e-01,2.74900e-01,1.63200e-01,5.00000e-01,1.87200e-01,1.08500e-01,6.00000e-01,1.42100e-01,8.01800e-02,8.00000e-01,
9.80400e-02,5.31100e-02,1.00000e+00,7.68600e-02,4.08000e-02,1.00000e-03,6.61400e+03,6.60000e+03,1.08088e-03,5.74700e+03,
5.73300e+03,1.16830e-03,4.97600e+03,4.96200e+03,1.16830e-03,5.04800e+03,5.03400e+03,1.24630e-03,4.46300e+03,4.44900e+03,
1.32950e-03,3.93700e+03,3.92400e+03,1.32950e-03,4.01700e+03,4.00300e+03,1.50000e-03,3.16100e+03,3.14800e+03,2.00000e-03,
1.74200e+03,1.72900e+03,3.00000e-03,7.18000e+02,7.07000e+02,3.33200e-03,5.67100e+02,5.56500e+02,3.33200e-03,1.39400e+03,
1.34600e+03,3.41048e-03,1.30400e+03,1.26000e+03,3.49080e-03,1.22600e+03,1.18500e+03,3.49080e-03,1.74900e+03,1.68300e+03,
4.00000e-03,1.25300e+03,1.20800e+03,4.04610e-03,1.21700e+03,1.17400e+03,4.04610e-03,1.41500e+03,1.36400e+03,4.42089e-03,
1.13700e+03,1.09800e+03,4.83040e-03,9.10300e+02,8.79700e+02,4.83040e-03,9.65500e+02,9.33000e+02,5.00000e-03,8.87800e+02,
8.58100e+02,5.18230e-03,8.12900e+02,7.85900e+02,5.18230e-03,8.47700e+02,8.19600e+02,6.00000e-03,5.94500e+02,5.74900e+02,
8.00000e-03,2.93900e+02,2.83000e+02,1.00000e-02,1.68900e+02,1.61500e+02,1.50000e-02,6.14100e+01,5.71800e+01,1.63003e-02,
4.99100e+01,4.61100e+01,1.63003e-02,1.15600e+02,8.73200e+01,1.79166e-02,9.92400e+01,6.92400e+01,1.96932e-02,6.98400e+01,
5.49200e+01,1.96932e-02,9.52700e+01,6.83600e+01,2.00000e-02,9.36800e+01,6.71400e+01,2.04721e-02,8.85100e+01,6.38300e+01,
2.04721e-02,1.01800e+02,7.25900e+01,3.00000e-02,3.89200e+01,3.03200e+01,4.00000e-02,1.86500e+01,1.50300e+01,5.00000e-02,
1.05200e+01,8.55800e+00,6.00000e-02,6.59200e+00,5.35500e+00,8.00000e-02,3.17800e+00,2.52600e+00,1.00000e-01,1.83000e+00,
1.40300e+00,1.09651e-01,1.46500e+00,1.10000e+00,1.09651e-01,5.33600e+00,1.50200e+00,1.50000e-01,2.47200e+00,1.09000e+00,
2.00000e-01,1.23400e+00,6.60300e-01,3.00000e-01,4.93900e-01,2.93100e-01,4.00000e-01,2.78900e-01,1.65600e-01,5.00000e-01,
1.89500e-01,1.10100e-01,6.00000e-01,1.43500e-01,8.12800e-02,8.00000e-01,9.86100e-02,5.36600e-02,1.00000e+00,7.70900e-02,
4.10900e-02,1.00000e-03,6.53000e+03,6.51500e+03,1.00334e-03,6.49000e+03,6.47600e+03,1.00670e-03,6.45100e+03,6.43700e+03,
1.00670e-03,6.86800e+03,6.85300e+03,1.11018e-03,5.75500e+03,5.74000e+03,1.22430e-03,4.79400e+03,4.78000e+03,1.22430e-03,
4.86300e+03,4.84800e+03,1.30316e-03,4.31100e+03,4.29600e+03,1.38710e-03,3.81500e+03,3.80100e+03,1.38710e-03,3.89100e+03,
3.87700e+03,1.50000e-03,3.32700e+03,3.31300e+03,2.00000e-03,1.83400e+03,1.82100e+03,3.00000e-03,7.55800e+02,7.44400e+02,
3.44180e-03,5.54800e+02,5.44000e+02,3.44180e-03,1.36300e+03,1.31400e+03,3.52548e-03,1.26600e+03,1.22200e+03,3.61120e-03,
1.18500e+03,1.14400e+03,3.61120e-03,1.69500e+03,1.62800e+03,4.00000e-03,1.31500e+03,1.26500e+03,4.17380e-03,1.18200e+03,
1.13900e+03,4.17380e-03,1.37400e+03,1.32400e+03,5.00000e-03,8.75900e+02,8.45400e+02,5.00090e-03,8.75500e+02,8.45000e+02,
5.00090e-03,9.28800e+02,8.96400e+02,5.18067e-03,8.51400e+02,8.21900e+02,5.36690e-03,7.81000e+02,7.54100e+02,5.36690e-03,
8.14400e+02,7.86400e+02,6.00000e-03,6.21700e+02,6.00400e+02,8.00000e-03,3.07400e+02,2.95800e+02,1.00000e-02,1.76900e+02,
1.69000e+02,1.50000e-02,6.44200e+01,6.00000e+01,1.67331e-02,4.90300e+01,4.52200e+01,1.67331e-02,1.13000e+02,8.48300e+01,
2.00000e-02,7.02500e+01,5.48600e+01,2.03137e-02,6.74700e+01,5.28400e+01,2.03137e-02,9.45200e+01,6.70400e+01,2.07054e-02,
8.99500e+01,6.41800e+01,2.11046e-02,8.57600e+01,6.15300e+01,2.11046e-02,9.86100e+01,6.99000e+01,3.00000e-02,4.07700e+01,
3.14600e+01,4.00000e-02,1.95700e+01,1.56700e+01,5.00000e-02,1.10500e+01,8.95000e+00,6.00000e-02,6.92900e+00,5.61200e+00,
8.00000e-02,3.34200e+00,2.65500e+00,1.00000e-01,1.92400e+00,1.47700e+00,1.12601e-01,1.44500e+00,1.08100e+00,1.12601e-01,
5.19800e+00,1.46600e+00,1.50000e-01,2.57500e+00,1.10600e+00,2.00000e-01,1.28800e+00,6.79200e-01,3.00000e-01,5.15200e-01,
3.04200e-01,4.00000e-01,2.90400e-01,1.72300e-01,5.00000e-01,1.96900e-01,1.14600e-01,6.00000e-01,1.48700e-01,8.45300e-02,
8.00000e-01,1.01800e-01,5.56300e-02,1.00000e+00,7.93700e-02,4.24700e-02,1.00000e-03,6.62600e+03,6.61200e+03,1.02220e-03,
6.37500e+03,6.36000e+03,1.04490e-03,6.12700e+03,6.11200e+03,1.04490e-03,6.51900e+03,6.50400e+03,1.15314e-03,5.44600e+03,
5.43100e+03,1.27260e-03,4.52600e+03,4.51100e+03,1.27260e-03,4.58900e+03,4.57500e+03,1.35409e-03,4.06500e+03,4.05100e+03,
1.44080e-03,3.59800e+03,3.58400e+03,1.44080e-03,3.66800e+03,3.65400e+03,1.50000e-03,3.38200e+03,3.36800e+03,2.00000e-03,
1.86500e+03,1.85200e+03,3.00000e-03,7.69200e+02,7.57800e+02,3.55170e-03,5.25700e+02,5.15100e+02,3.55170e-03,1.26600e+03,
1.22000e+03,3.63859e-03,1.18800e+03,1.14200e+03,3.72760e-03,1.11200e+03,1.07200e+03,3.72760e-03,1.58200e+03,1.51700e+03,
4.00000e-03,1.32900e+03,1.27700e+03,4.30340e-03,1.11000e+03,1.06800e+03,4.30340e-03,1.29200e+03,1.24200e+03,5.00000e-03,
8.89100e+02,8.56900e+02,5.18220e-03,8.11800e+02,7.82500e+02,5.18220e-03,8.61100e+02,8.30100e+02,5.36198e-03,7.91500e+02,
7.63200e+02,5.54800e-03,7.28200e+02,7.02200e+02,5.54800e-03,7.59200e+02,7.32200e+02,6.00000e-03,6.28400e+02,6.06200e+02,
8.00000e-03,3.10800e+02,2.98900e+02,1.00000e-02,1.79100e+02,1.71100e+02,1.50000e-02,6.52800e+01,6.08400e+01,1.71663e-02,
4.66300e+01,4.29300e+01,1.71663e-02,1.07000e+02,7.98000e+01,2.00000e-02,7.10600e+01,5.49600e+01,2.09476e-02,6.30000e+01,
4.91400e+01,2.09476e-02,8.83800e+01,6.22200e+01,2.13487e-02,9.51500e+01,5.95900e+01,2.17574e-02,8.02300e+01,5.71500e+01,
2.17574e-02,9.22200e+01,6.48700e+01,3.00000e-02,4.12800e+01,3.14900e+01,4.00000e-02,1.98300e+01,1.57600e+01,5.00000e-02,
1.12100e+01,9.03400e+00,6.00000e-02,7.03500e+00,5.67800e+00,8.00000e-02,3.39500e+00,2.69500e+00,1.00000e-01,1.95400e+00,
1.50200e+00,1.15606e-01,1.37800e+00,1.02700e+00,1.15606e-01,4.89300e+00,1.38200e+00,1.50000e-01,2.59100e+00,1.08300e+00,
2.00000e-01,1.29800e+00,6.74600e-01,3.00000e-01,5.19200e-01,3.05000e-01,4.00000e-01,2.92200e-01,1.73200e-01,5.00000e-01,
1.97600e-01,1.15200e-01,6.00000e-01,1.49000e-01,8.49400e-02,8.00000e-01,1.01600e-01,5.57400e-02,1.00000e+00,7.89600e-02,
4.24100e-02};

//----------------------------------------------------------------------------------------------------------------------
// EPDL

static const int EPDL_mu_muen_data_elementNumber = 100;
 
static const int EPDL_mu_muen_data_energyNumber[101] = {
0,117,122,140,149,222,221,238,244,240,260,328,330,408,388,384,387,390,381,410,
413,457,461,448,465,453,457,447,487,491,570,611,611,577,591,586,605,580,579,610,
613,616,601,605,615,616,614,603,593,652,639,651,643,650,651,685,676,703,735,719,
728,766,760,761,765,749,763,766,738,752,777,761,788,803,764,783,773,776,767,776,
768,814,792,808,809,817,821,805,804,818,814,844,842,849,824,837,833,838,830,849,
868};
 
static const float EPDL_mu_muen_data[184014] = { 
1.00000e-03,7.21396e+00,6.81612e+00,1.03514e-03,6.47332e+00,6.07570e+00,1.12914e-03,4.93789e+00,4.53987e+00,1.15654e-03,
4.58633e+00,4.18932e+00,1.25890e-03,3.54931e+00,3.15264e+00,1.25892e-03,3.54910e+00,3.15243e+00,1.33245e-03,3.00309e+00,
2.60625e+00,1.46218e-03,2.30460e+00,1.90885e+00,1.51247e-03,2.09901e+00,1.70303e+00,1.58489e-03,1.85027e+00,1.45445e+00,
1.58490e-03,1.85025e+00,1.45443e+00,1.67171e-03,1.61047e+00,1.21502e+00,1.80370e-03,1.33519e+00,9.40363e-01,1.91323e-03,
1.16579e+00,7.70897e-01,1.99526e-03,1.06411e+00,6.69217e-01,1.99530e-03,1.06406e+00,6.69174e-01,2.07247e-03,9.83108e-01,
5.88892e-01,2.11349e-03,9.45016e-01,5.51290e-01,2.24307e-03,8.43857e-01,4.50703e-01,2.42538e-03,7.39194e-01,3.46055e-01,
2.51189e-03,7.00826e-01,3.07436e-01,2.51190e-03,7.00820e-01,3.07430e-01,2.64103e-03,6.51829e-01,2.59625e-01,2.86425e-03,
5.88649e-01,1.97637e-01,3.10125e-03,5.42834e-01,1.51469e-01,3.16228e-03,5.33569e-01,1.41941e-01,3.16230e-03,5.33566e-01,
1.41938e-01,3.36845e-03,5.04755e-01,1.14970e-01,3.65229e-03,4.76680e-01,8.79832e-02,3.98107e-03,4.55811e-01,6.64366e-02,
3.98110e-03,4.55810e-01,6.64351e-02,4.02321e-03,4.53248e-01,6.42231e-02,4.44211e-03,4.33542e-01,4.69319e-02,5.01187e-03,
4.19269e-01,3.25693e-02,5.01190e-03,4.19269e-01,3.25688e-02,5.01510e-03,4.19186e-01,3.25083e-02,5.37032e-03,4.11286e-01,
2.67688e-02,5.65701e-03,4.06794e-01,2.32456e-02,6.30957e-03,4.00642e-01,1.77176e-02,6.30960e-03,4.00642e-01,1.77174e-02,
6.48242e-03,3.98718e-01,1.66935e-02,7.46198e-03,3.91632e-01,1.28105e-02,7.94328e-03,3.89859e-01,1.16845e-02,7.94330e-03,
3.89859e-01,1.16844e-02,8.72644e-03,3.85730e-01,1.06319e-02,8.81049e-03,3.85375e-01,1.05504e-02,1.00000e-02,3.81882e-01,
9.80686e-03,1.03417e-02,3.81338e-01,9.78167e-03,1.21908e-02,3.80145e-01,9.97590e-03,1.25890e-02,3.80162e-01,1.00583e-02,
1.25892e-02,3.80161e-01,1.00583e-02,1.48908e-02,3.76164e-01,1.10430e-02,1.58489e-02,3.75043e-01,1.14167e-02,1.58490e-02,
3.75043e-01,1.14167e-02,1.67880e-02,3.73438e-01,1.19742e-02,1.85796e-02,3.70922e-01,1.29043e-02,1.99526e-02,3.69341e-01,
1.35170e-02,1.99530e-02,3.69341e-01,1.35172e-02,2.45264e-02,3.63384e-01,1.59556e-02,2.51189e-02,3.62752e-01,1.62049e-02,
2.51190e-02,3.62752e-01,1.62050e-02,3.16228e-02,3.54974e-01,1.93989e-02,3.16230e-02,3.54974e-01,1.93990e-02,3.34965e-02,
3.52624e-01,2.04205e-02,3.50597e-02,3.50794e-01,2.11768e-02,3.98107e-02,3.45824e-01,2.30556e-02,3.98110e-02,3.45823e-01,
2.30558e-02,5.01187e-02,3.35199e-01,2.71150e-02,5.01190e-02,3.35199e-01,2.71151e-02,6.09537e-02,3.24816e-01,3.09286e-02,
6.30957e-02,3.23028e-01,3.14857e-02,6.30960e-02,3.23028e-01,3.14858e-02,7.94328e-02,3.09340e-01,3.60393e-02,7.94330e-02,
3.09340e-01,3.60393e-02,9.33254e-02,2.98686e-01,3.94438e-02,1.00000e-01,2.94241e-01,4.06039e-02,1.18850e-01,2.81930e-01,
4.40972e-02,1.25890e-01,2.77948e-01,4.49931e-02,1.25893e-01,2.77946e-01,4.49933e-02,1.46218e-01,2.66621e-01,4.78627e-02,
1.58489e-01,2.60719e-01,4.90088e-02,1.58490e-01,2.60719e-01,4.90089e-02,1.75792e-01,2.52553e-01,5.08652e-02,1.83377e-01,
2.49299e-01,5.14781e-02,1.99526e-01,2.42923e-01,5.24799e-02,1.99530e-01,2.42922e-01,5.24803e-02,2.04174e-01,2.41058e-01,
5.28701e-02,2.37137e-01,2.29277e-01,5.47885e-02,2.51189e-01,2.24901e-01,5.52732e-02,2.51190e-01,2.24901e-01,5.52733e-02,
2.69154e-01,2.19371e-01,5.61260e-02,3.01995e-01,2.10455e-01,5.70718e-02,3.16228e-01,2.06992e-01,5.73032e-02,3.16230e-01,
2.06991e-01,5.73033e-02,3.38844e-01,2.01569e-01,5.79011e-02,3.75837e-01,1.93701e-01,5.84170e-02,3.98107e-01,1.89464e-01,
5.85304e-02,3.98110e-01,1.89463e-01,5.85304e-02,4.12098e-01,1.86818e-01,5.87225e-02,4.51856e-01,1.79941e-01,5.89956e-02,
4.95450e-01,1.73318e-01,5.89628e-02,5.01187e-01,1.72508e-01,5.89396e-02,5.01190e-01,1.72507e-01,5.89397e-02,5.37032e-01,
1.67461e-01,5.90104e-02,5.56304e-01,1.64943e-01,5.89793e-02,5.82103e-01,1.61760e-01,5.88785e-02,6.30957e-01,1.56253e-01,
5.85468e-02,6.30960e-01,1.56253e-01,5.85468e-02,6.83912e-01,1.50651e-01,5.83146e-02,7.41310e-01,1.45251e-01,5.78845e-02,
7.94328e-01,1.40776e-01,5.73810e-02,7.94330e-01,1.40776e-01,5.73810e-02,8.03526e-01,1.40005e-01,5.73190e-02,8.60994e-01,
1.35464e-01,5.68676e-02,9.22571e-01,1.31071e-01,5.62944e-02,9.88553e-01,1.26820e-01,5.56165e-02,1.00000e+00,1.26125e-01,
5.54944e-02,1.00000e-03,6.11933e+01,6.07990e+01,1.25890e-03,2.94634e+01,2.90769e+01,1.25892e-03,2.94615e+01,2.90750e+01,
1.33352e-03,2.45633e+01,2.41783e+01,1.37314e-03,2.23792e+01,2.19950e+01,1.42547e-03,1.98731e+01,1.94900e+01,1.45702e-03,
1.85388e+01,1.81588e+01,1.58489e-03,1.42104e+01,1.38351e+01,1.58490e-03,1.42102e+01,1.38349e+01,1.69824e-03,1.14382e+01,
1.10664e+01,1.82314e-03,9.14392e+00,8.77527e+00,1.85976e-03,8.58938e+00,8.22302e+00,1.92753e-03,7.67903e+00,7.31509e+00,
1.98756e-03,6.96987e+00,6.60787e+00,1.99526e-03,6.88538e+00,6.52369e+00,1.99530e-03,6.88497e+00,6.52328e+00,2.19600e-03,
5.10215e+00,4.74764e+00,2.43434e-03,3.72013e+00,3.37398e+00,2.48313e-03,3.50355e+00,3.15917e+00,2.51189e-03,3.38349e+00,
3.04011e+00,2.51190e-03,3.38344e+00,3.04005e+00,2.61919e-03,2.98364e+00,2.64405e+00,2.93269e-03,2.14170e+00,1.81323e+00,
3.16228e-03,1.73080e+00,1.41014e+00,3.16230e-03,1.73077e+00,1.41011e+00,3.24186e-03,1.61601e+00,1.29797e+00,3.51420e-03,
1.30088e+00,9.91859e-01,3.81820e-03,1.05230e+00,7.52249e-01,3.98107e-03,9.50103e-01,6.54534e-01,3.98110e-03,9.50087e-01,
6.54519e-01,4.16911e-03,8.51573e-01,5.61310e-01,4.46684e-03,7.28531e-01,4.46215e-01,4.51206e-03,7.12707e-01,4.31432e-01,
4.88217e-03,6.04620e-01,3.31528e-01,5.01187e-03,5.74244e-01,3.03756e-01,5.01190e-03,5.74238e-01,3.03751e-01,5.31806e-03,
5.13218e-01,2.49304e-01,5.75270e-03,4.47987e-01,1.92044e-01,6.16595e-03,4.02446e-01,1.52669e-01,6.30957e-03,3.89454e-01,
1.41409e-01,6.30960e-03,3.89451e-01,1.41407e-01,6.37131e-03,3.84011e-01,1.36909e-01,7.02009e-03,3.37656e-01,9.93929e-02,
7.76780e-03,3.02444e-01,7.14856e-02,7.94328e-03,2.96096e-01,6.65266e-02,7.94330e-03,2.96095e-01,6.65261e-02,8.72725e-03,
2.72024e-01,4.93981e-02,8.81049e-03,2.69948e-01,4.79601e-02,9.87753e-03,2.49535e-01,3.38368e-02,1.00000e-02,2.47752e-01,
3.26258e-02,1.13385e-02,2.31061e-01,2.29624e-02,1.25890e-02,2.21429e-01,1.76602e-02,1.25892e-02,2.21427e-01,1.76594e-02,
1.31880e-02,2.17453e-01,1.59357e-02,1.42889e-02,2.11674e-01,1.35942e-02,1.55160e-02,2.07094e-01,1.18417e-02,1.58489e-02,
2.06080e-01,1.14773e-02,1.58490e-02,2.06080e-01,1.14772e-02,1.81782e-02,1.99352e-01,9.96730e-03,1.99526e-02,1.95978e-01,
9.40187e-03,1.99530e-02,1.95977e-01,9.40183e-03,2.16783e-02,1.92907e-01,9.27716e-03,2.51189e-02,1.88619e-01,9.33917e-03,
2.51190e-02,1.88618e-01,9.33919e-03,2.62977e-02,1.87191e-01,9.52041e-03,2.85102e-02,1.84901e-01,9.85808e-03,3.16228e-02,
1.82367e-01,1.03050e-02,3.16230e-02,1.82367e-01,1.03051e-02,3.32882e-02,1.80905e-01,1.06757e-02,3.98107e-02,1.76370e-01,
1.18552e-02,3.98110e-02,1.76370e-01,1.18553e-02,4.40009e-02,1.73575e-01,1.27564e-02,5.01187e-02,1.70209e-01,1.37728e-02,
5.01190e-02,1.70209e-01,1.37728e-02,5.68853e-02,1.66477e-01,1.50425e-02,6.30957e-02,1.63585e-01,1.59170e-02,6.30960e-02,
1.63585e-01,1.59171e-02,6.39160e-02,1.63165e-01,1.60685e-02,7.94328e-02,1.56385e-01,1.81849e-02,7.94330e-02,1.56385e-01,
1.81849e-02,8.41395e-02,1.54382e-01,1.88534e-02,1.00000e-01,1.48591e-01,2.04737e-02,1.09648e-01,1.45185e-01,2.14885e-02,
1.12346e-01,1.44303e-01,2.17252e-02,1.25890e-01,1.40253e-01,2.26779e-02,1.25893e-01,1.40253e-01,2.26781e-02,1.42889e-01,
1.35365e-01,2.39332e-02,1.58489e-01,1.31507e-01,2.47007e-02,1.58490e-01,1.31507e-01,2.47007e-02,1.69824e-01,1.28731e-01,
2.53524e-02,1.99526e-01,1.22493e-01,2.64483e-02,1.99530e-01,1.22492e-01,2.64485e-02,2.00000e-01,1.22395e-01,2.64692e-02,
2.31740e-01,1.16492e-01,2.74948e-02,2.51189e-01,1.13387e-01,2.78555e-02,2.51190e-01,1.13387e-01,2.78556e-02,2.63027e-01,
1.11516e-01,2.81547e-02,2.95121e-01,1.06976e-01,2.86881e-02,3.16228e-01,1.04343e-01,2.88782e-02,3.16230e-01,1.04343e-01,
2.88783e-02,3.31131e-01,1.02511e-01,2.90912e-02,3.39271e-01,1.01557e-01,2.91839e-02,3.67282e-01,9.85052e-02,2.94000e-02,
3.98107e-01,9.54995e-02,2.94968e-02,3.98110e-01,9.54992e-02,2.94968e-02,4.07380e-01,9.46075e-02,2.95642e-02,4.46684e-01,
9.11226e-02,2.97229e-02,4.89779e-01,8.77669e-02,2.97243e-02,5.01187e-01,8.69476e-02,2.97030e-02,5.01190e-01,8.69474e-02,
2.97030e-02,5.37032e-01,8.44026e-02,2.97386e-02,5.82103e-01,8.15279e-02,2.96721e-02,6.30957e-01,7.87514e-02,2.95050e-02,
6.30960e-01,7.87513e-02,2.95050e-02,6.83912e-01,7.59268e-02,2.93877e-02,7.41310e-01,7.32037e-02,2.91707e-02,7.94328e-01,
7.09476e-02,2.89168e-02,7.94330e-01,7.09475e-02,2.89168e-02,8.03526e-01,7.05588e-02,2.88856e-02,8.81049e-01,6.75239e-02,
2.85683e-02,9.77237e-01,6.42656e-02,2.80881e-02,1.00000e+00,6.35632e-02,2.79664e-02,1.00000e-03,2.33847e+02,2.33387e+02,
1.03514e-03,2.10517e+02,2.10062e+02,1.11010e-03,1.69719e+02,1.69275e+02,1.12202e-03,1.64228e+02,1.63785e+02,1.25890e-03,
1.15205e+02,1.14780e+02,1.25892e-03,1.15198e+02,1.14773e+02,1.28825e-03,1.07224e+02,1.06803e+02,1.32072e-03,9.92236e+01,
9.88065e+01,1.51130e-03,6.52249e+01,6.48292e+01,1.54882e-03,6.04364e+01,6.00447e+01,1.56675e-03,5.82878e+01,5.78978e+01,
1.58489e-03,5.62155e+01,5.58274e+01,1.58490e-03,5.62147e+01,5.58266e+01,1.90428e-03,3.15960e+01,3.12362e+01,1.92753e-03,
3.04181e+01,3.00601e+01,1.94984e-03,2.93300e+01,2.89735e+01,1.99526e-03,2.72700e+01,2.69168e+01,1.99530e-03,2.72683e+01,
2.69151e+01,2.42661e-03,1.47219e+01,1.43947e+01,2.51189e-03,1.31980e+01,1.28750e+01,2.51190e-03,1.31977e+01,1.28747e+01,
2.54097e-03,1.27265e+01,1.24049e+01,2.67855e-03,1.07773e+01,1.04617e+01,3.09030e-03,6.89115e+00,6.59128e+00,3.16228e-03,
6.41199e+00,6.11445e+00,3.16230e-03,6.41185e+00,6.11431e+00,3.23594e-03,5.96747e+00,5.67213e+00,3.43154e-03,4.97395e+00,
4.68397e+00,3.88052e-03,3.41532e+00,3.13660e+00,3.98107e-03,3.16195e+00,2.88556e+00,3.98110e-03,3.16189e+00,2.88549e+00,
4.00000e-03,3.11724e+00,2.84126e+00,4.21723e-03,2.65920e+00,2.38779e+00,4.77921e-03,1.84308e+00,1.58275e+00,5.01187e-03,
1.60987e+00,1.35385e+00,5.01190e-03,1.60984e+00,1.35383e+00,5.12861e-03,1.50920e+00,1.25521e+00,5.30312e-03,1.37573e+00,
1.12455e+00,5.30884e-03,1.37165e+00,1.12057e+00,5.85630e-03,1.05243e+00,8.09775e-01,6.30957e-03,8.69275e-01,6.32840e-01,
6.30960e-03,8.69266e-01,6.32831e-01,6.34712e-03,8.56491e-01,6.20553e-01,6.76083e-03,7.34196e-01,5.03749e-01,6.91831e-03,
6.95502e-01,4.66889e-01,7.16143e-03,6.42331e-01,4.16625e-01,7.53848e-03,5.73192e-01,3.51410e-01,7.94328e-03,5.13355e-01,
2.95513e-01,7.94330e-03,5.13353e-01,2.95511e-01,8.17539e-03,4.84229e-01,2.68683e-01,8.88246e-03,4.13587e-01,2.04430e-01,
9.77237e-03,3.52262e-01,1.49549e-01,9.82274e-03,3.49475e-01,1.47064e-01,1.00000e-02,3.40043e-01,1.38746e-01,1.01158e-02,
3.34104e-01,1.33658e-01,1.09218e-02,2.99531e-01,1.04209e-01,1.21164e-02,2.64197e-01,7.47911e-02,1.25890e-02,2.53820e-01,
6.63162e-02,1.25892e-02,2.53814e-01,6.63121e-02,1.36373e-02,2.34882e-01,5.18748e-02,1.39637e-02,2.30087e-01,4.83113e-02,
1.47911e-02,2.19829e-01,4.07611e-02,1.54553e-02,2.13165e-01,3.59054e-02,1.58489e-02,2.09717e-01,3.34435e-02,1.58490e-02,
2.09716e-01,3.34431e-02,1.77816e-02,1.95803e-01,2.47130e-02,1.99526e-02,1.85892e-01,1.89334e-02,1.99530e-02,1.85891e-01,
1.89327e-02,2.05282e-02,1.83672e-01,1.78897e-02,2.11349e-02,1.81544e-01,1.69316e-02,2.39883e-02,1.74051e-01,1.38270e-02,
2.39919e-02,1.74043e-01,1.38241e-02,2.51189e-02,1.71880e-01,1.30325e-02,2.51190e-02,1.71880e-01,1.30325e-02,2.80769e-02,
1.66753e-01,1.18595e-02,3.16228e-02,1.62484e-01,1.11777e-02,3.16230e-02,1.62484e-01,1.11777e-02,3.38679e-02,1.59984e-01,
1.11239e-02,3.84592e-02,1.56011e-01,1.12154e-02,3.98107e-02,1.55064e-01,1.12695e-02,3.98110e-02,1.55064e-01,1.12695e-02,
4.10549e-02,1.54123e-01,1.14178e-02,5.01187e-02,1.48763e-01,1.23875e-02,5.01190e-02,1.48763e-01,1.23876e-02,5.15303e-02,
1.47936e-01,1.26024e-02,6.30957e-02,1.42395e-01,1.39852e-02,6.30960e-02,1.42395e-01,1.39853e-02,6.84644e-02,1.39973e-01,
1.47163e-02,7.16143e-02,1.38682e-01,1.50823e-02,7.41310e-02,1.37711e-01,1.53463e-02,7.94328e-02,1.35819e-01,1.58321e-02,
7.94330e-02,1.35819e-01,1.58321e-02,9.85191e-02,1.29295e-01,1.76571e-02,1.00000e-01,1.28863e-01,1.77581e-02,1.04713e-01,
1.27348e-01,1.82110e-02,1.05925e-01,1.26973e-01,1.83178e-02,1.25890e-01,1.21535e-01,1.96420e-02,1.25893e-01,1.21534e-01,
1.96421e-02,1.31826e-01,1.19956e-01,2.00713e-02,1.33352e-01,1.19566e-01,2.01717e-02,1.58489e-01,1.13888e-01,2.13792e-02,
1.58490e-01,1.13888e-01,2.13793e-02,1.60324e-01,1.13481e-01,2.14801e-02,1.62181e-01,1.13075e-01,2.15779e-02,1.75101e-01,
1.10417e-01,2.21576e-02,1.94984e-01,1.06802e-01,2.27792e-02,1.99526e-01,1.06045e-01,2.28860e-02,1.99530e-01,1.06045e-01,
2.28862e-02,2.23872e-01,1.02011e-01,2.36210e-02,2.51189e-01,9.81386e-02,2.41019e-02,2.51190e-01,9.81385e-02,2.41019e-02,
2.57040e-01,9.73241e-02,2.42367e-02,2.91743e-01,9.29675e-02,2.47858e-02,3.16228e-01,9.03005e-02,2.49852e-02,3.16230e-01,
9.03003e-02,2.49852e-02,3.27341e-01,8.91070e-02,2.51273e-02,3.63078e-01,8.56223e-02,2.54162e-02,3.98107e-01,8.26414e-02,
2.55206e-02,3.98110e-01,8.26412e-02,2.55207e-02,4.02717e-01,8.22542e-02,2.55511e-02,4.41570e-01,7.92220e-02,2.57068e-02,
4.84172e-01,7.63029e-02,2.57239e-02,5.01187e-01,7.52365e-02,2.56990e-02,5.01190e-01,7.52363e-02,2.56990e-02,5.30884e-01,
7.33956e-02,2.57299e-02,5.75440e-01,7.08942e-02,2.56857e-02,5.82103e-01,7.05440e-02,2.56718e-02,6.23735e-01,6.84787e-02,
2.55526e-02,6.30957e-01,6.81405e-02,2.55271e-02,6.30960e-01,6.81404e-02,2.55271e-02,6.76083e-01,6.60398e-02,2.54459e-02,
6.83912e-01,6.56961e-02,2.54258e-02,7.32825e-01,6.36711e-02,2.52698e-02,7.41310e-01,6.33398e-02,2.52382e-02,7.94328e-01,
6.13877e-02,2.50188e-02,7.94330e-01,6.13877e-02,2.50188e-02,8.03526e-01,6.10512e-02,2.49917e-02,8.70964e-01,5.87464e-02,
2.47567e-02,8.91251e-01,5.81041e-02,2.46761e-02,1.00000e+00,5.49966e-02,2.41962e-02,1.00000e-03,6.03527e+02,6.02861e+02,
1.03514e-03,5.44913e+02,5.44255e+02,1.04638e-03,5.27784e+02,5.27128e+02,1.13501e-03,4.14923e+02,4.14289e+02,1.19384e-03,
3.56621e+02,3.55999e+02,1.23027e-03,3.25909e+02,3.25295e+02,1.25890e-03,3.04194e+02,3.03586e+02,1.25892e-03,3.04176e+02,
3.03568e+02,1.33217e-03,2.56758e+02,2.56164e+02,1.40000e-03,2.21264e+02,2.20683e+02,1.45244e-03,1.97910e+02,1.97339e+02,
1.47911e-03,1.87284e+02,1.86717e+02,1.58489e-03,1.51878e+02,1.51329e+02,1.58490e-03,1.51876e+02,1.51327e+02,1.59569e-03,
1.48782e+02,1.48235e+02,1.71791e-03,1.18953e+02,1.18427e+02,1.74790e-03,1.12802e+02,1.12281e+02,1.81970e-03,9.97005e+01,
9.91911e+01,1.93777e-03,8.22203e+01,8.17282e+01,1.99526e-03,7.51730e+01,7.46891e+01,1.99530e-03,7.51686e+01,7.46847e+01,
2.08930e-03,6.52819e+01,6.48110e+01,2.20795e-03,5.50217e+01,5.45657e+01,2.21310e-03,5.46269e+01,5.41715e+01,2.51189e-03,
3.69284e+01,3.65062e+01,2.51190e-03,3.69278e+01,3.65056e+01,2.54097e-03,3.56389e+01,3.52196e+01,2.57595e-03,3.41511e+01,
3.37352e+01,2.72270e-03,2.87351e+01,2.83332e+01,3.16228e-03,1.80486e+01,1.76801e+01,3.16230e-03,1.80482e+01,1.76797e+01,
3.27341e-03,1.62029e+01,1.58416e+01,3.84592e-03,9.81908e+00,9.48818e+00,3.98107e-03,8.81690e+00,8.49176e+00,3.98110e-03,
8.81670e+00,8.49157e+00,4.07380e-03,8.20761e+00,7.88633e+00,4.28333e-03,7.02567e+00,6.71245e+00,4.89779e-03,4.65753e+00,
4.36327e+00,5.01187e-03,4.34066e+00,4.04934e+00,5.01190e-03,4.34058e+00,4.04926e+00,5.12861e-03,4.04639e+00,3.75801e+00,
5.48566e-03,3.30127e+00,3.02102e+00,6.30797e-03,2.18560e+00,1.92069e+00,6.30957e-03,2.18399e+00,1.91911e+00,6.30960e-03,
2.18397e+00,1.91908e+00,6.60693e-03,1.91087e+00,1.65094e+00,7.05849e-03,1.58350e+00,1.33012e+00,7.85151e-03,1.18283e+00,
9.39425e-01,7.94328e-03,1.14676e+00,9.04460e-01,7.94330e-03,1.14676e+00,9.04454e-01,8.31764e-03,1.01624e+00,7.78306e-01,
8.60994e-03,9.29671e-01,6.94797e-01,8.68773e-03,9.08672e-01,6.74562e-01,9.44351e-03,7.39921e-01,5.12982e-01,1.00000e-02,
6.47519e-01,4.25234e-01,1.03125e-02,6.04272e-01,3.84542e-01,1.12202e-02,5.04999e-01,2.92064e-01,1.13683e-02,4.91760e-01,
2.79780e-01,1.14815e-02,4.82062e-01,2.70849e-01,1.25890e-02,4.05416e-01,2.00570e-01,1.25890e-02,4.05416e-01,2.00569e-01,
1.25892e-02,4.05402e-01,2.00557e-01,1.44685e-02,3.23398e-01,1.28184e-01,1.56675e-02,2.90260e-01,9.96658e-02,1.58489e-02,
2.86110e-01,9.61158e-02,1.58490e-02,2.86108e-01,9.61144e-02,1.60324e-02,2.82021e-01,9.27166e-02,1.60380e-02,2.81899e-01,
9.26157e-02,1.76954e-02,2.52117e-01,6.84456e-02,1.99526e-02,2.26120e-01,4.80864e-02,1.99530e-02,2.26116e-01,4.80838e-02,
2.01182e-02,2.24570e-01,4.69829e-02,2.29087e-02,2.04488e-01,3.32322e-02,2.31740e-02,2.03053e-01,3.22839e-02,2.37475e-02,
2.00166e-01,3.03938e-02,2.51189e-02,1.94235e-01,2.66297e-02,2.51190e-02,1.94234e-01,2.66294e-02,2.79255e-02,1.84485e-01,
2.14979e-02,3.16228e-02,1.76009e-01,1.75870e-02,3.16230e-02,1.76009e-01,1.75868e-02,3.30498e-02,1.73279e-01,1.67004e-02,
3.50752e-02,1.69975e-01,1.57456e-02,3.67282e-02,1.67705e-01,1.51640e-02,3.94927e-02,1.64558e-01,1.44696e-02,3.98107e-02,
1.64236e-01,1.44073e-02,3.98110e-02,1.64235e-01,1.44073e-02,4.73869e-02,1.57240e-01,1.40061e-02,5.01187e-02,1.55364e-01,
1.40077e-02,5.01190e-02,1.55364e-01,1.40078e-02,5.80505e-02,1.50227e-01,1.45979e-02,6.30957e-02,1.47651e-01,1.49514e-02,
6.30960e-02,1.47650e-01,1.49514e-02,6.99842e-02,1.44164e-01,1.57102e-02,7.32825e-02,1.42703e-01,1.60209e-02,7.40244e-02,
1.42389e-01,1.60867e-02,7.94328e-02,1.40251e-01,1.65239e-02,7.94330e-02,1.40251e-01,1.65239e-02,9.77237e-02,1.33475e-01,
1.82033e-02,1.00000e-01,1.32766e-01,1.83550e-02,1.00446e-01,1.32609e-01,1.83999e-02,1.01158e-01,1.32361e-01,1.84703e-02,
1.25890e-01,1.25043e-01,2.02210e-02,1.25893e-01,1.25043e-01,2.02211e-02,1.31826e-01,1.23395e-01,2.06531e-02,1.36458e-01,
1.22178e-01,2.09485e-02,1.49398e-01,1.19062e-01,2.16161e-02,1.58489e-01,1.17085e-01,2.19739e-02,1.58490e-01,1.17085e-01,
2.19740e-02,1.60324e-01,1.16662e-01,2.20763e-02,1.64059e-01,1.15822e-01,2.22721e-02,1.90546e-01,1.10531e-01,2.32794e-02,
1.92752e-01,1.10136e-01,2.33394e-02,1.99526e-01,1.08961e-01,2.35058e-02,1.99530e-01,1.08960e-01,2.35060e-02,2.23872e-01,
1.04793e-01,2.42543e-02,2.26464e-01,1.04386e-01,2.43142e-02,2.51189e-01,1.00799e-01,2.47440e-02,2.51190e-01,1.00799e-01,
2.47440e-02,2.57040e-01,9.99604e-02,2.48822e-02,2.91743e-01,9.54766e-02,2.54456e-02,2.93849e-01,9.52283e-02,2.54684e-02,
3.16228e-01,9.27338e-02,2.56506e-02,3.16230e-01,9.27336e-02,2.56507e-02,3.27341e-01,9.15059e-02,2.57962e-02,3.63078e-01,
8.79220e-02,2.60920e-02,3.98107e-01,8.48577e-02,2.61989e-02,3.98110e-01,8.48575e-02,2.61989e-02,4.02717e-01,8.44597e-02,
2.62301e-02,4.41570e-01,8.13435e-02,2.63899e-02,4.84172e-01,7.83443e-02,2.64074e-02,5.01187e-01,7.72488e-02,2.63819e-02,
5.01190e-01,7.72486e-02,2.63819e-02,5.30884e-01,7.53567e-02,2.64133e-02,5.75440e-01,7.27864e-02,2.63676e-02,5.82103e-01,
7.24265e-02,2.63533e-02,6.23735e-01,7.03046e-02,2.62307e-02,6.30957e-01,6.99571e-02,2.62045e-02,6.30960e-01,6.99570e-02,
2.62045e-02,6.76083e-01,6.77989e-02,2.61208e-02,6.83912e-01,6.74457e-02,2.61001e-02,7.32825e-01,6.53655e-02,2.59398e-02,
7.41310e-01,6.50251e-02,2.59073e-02,7.94328e-01,6.30200e-02,2.56818e-02,7.94330e-01,6.30199e-02,2.56818e-02,8.00000e-01,
6.28062e-02,2.56649e-02,8.03526e-01,6.26744e-02,2.56541e-02,8.81049e-01,5.99774e-02,2.53723e-02,8.90610e-01,5.96691e-02,
2.53329e-02,1.00000e+00,5.64582e-02,2.48378e-02,1.00000e-03,1.22765e+03,1.22674e+03,1.07152e-03,1.00621e+03,1.00532e+03,
1.07678e-03,9.92119e+02,9.91227e+02,1.12202e-03,8.81191e+02,8.80313e+02,1.21619e-03,6.96672e+02,6.95821e+02,1.25890e-03,
6.29983e+02,6.29143e+02,1.25892e-03,6.29947e+02,6.29107e+02,1.28825e-03,5.89029e+02,5.88196e+02,1.29182e-03,5.84296e+02,
5.83464e+02,1.33352e-03,5.32587e+02,5.31767e+02,1.47911e-03,3.92160e+02,3.91377e+02,1.48830e-03,3.85047e+02,3.84266e+02,
1.51356e-03,3.66360e+02,3.65585e+02,1.58489e-03,3.19747e+02,3.18990e+02,1.58490e-03,3.19743e+02,3.18986e+02,1.62181e-03,
2.98717e+02,2.97969e+02,1.64059e-03,2.88728e+02,2.87984e+02,1.68637e-03,2.65906e+02,2.65172e+02,1.75792e-03,2.34824e+02,
2.34107e+02,1.85394e-03,2.00279e+02,1.99583e+02,1.99526e-03,1.60770e+02,1.60105e+02,1.99530e-03,1.60761e+02,1.60095e+02,
2.04174e-03,1.50074e+02,1.49418e+02,2.05624e-03,1.46895e+02,1.46242e+02,2.13796e-03,1.30556e+02,1.29919e+02,2.21310e-03,
1.17607e+02,1.16984e+02,2.23872e-03,1.13582e+02,1.12963e+02,2.30201e-03,1.04398e+02,1.03790e+02,2.51189e-03,8.01959e+01,
7.96228e+01,2.51190e-03,8.01945e+01,7.96215e+01,2.58177e-03,7.37453e+01,7.31828e+01,2.69154e-03,6.49386e+01,6.43927e+01,
2.72270e-03,6.26956e+01,6.21542e+01,2.78612e-03,5.84383e+01,5.79057e+01,2.90509e-03,5.14365e+01,5.09192e+01,3.12608e-03,
4.11328e+01,4.06421e+01,3.16228e-03,3.96995e+01,3.92126e+01,3.16230e-03,3.96986e+01,3.92118e+01,3.33120e-03,3.38223e+01,
3.33534e+01,3.34520e-03,3.33886e+01,3.29211e+01,3.34965e-03,3.32523e+01,3.27853e+01,3.42768e-03,3.09776e+01,3.05185e+01,
3.84592e-03,2.17529e+01,2.13298e+01,3.98107e-03,1.95468e+01,1.91335e+01,3.98110e-03,1.95464e+01,1.91331e+01,4.08224e-03,
1.80871e+01,1.76810e+01,4.12097e-03,1.75669e+01,1.71634e+01,4.16869e-03,1.69528e+01,1.65525e+01,4.78630e-03,1.10807e+01,
1.07153e+01,4.89779e-03,1.03190e+01,9.95891e+00,5.00000e-03,9.68155e+00,9.32593e+00,5.01187e-03,9.61095e+00,9.25584e+00,
5.01190e-03,9.61078e+00,9.25568e+00,5.18800e-03,8.64025e+00,8.29277e+00,5.96407e-03,5.64270e+00,5.32264e+00,6.02560e-03,
5.46997e+00,5.15170e+00,6.09537e-03,5.28102e+00,4.96474e+00,6.23735e-03,4.92335e+00,4.61093e+00,6.30957e-03,4.75405e+00,
4.44353e+00,6.30960e-03,4.75399e+00,4.44347e+00,6.38263e-03,4.59079e+00,4.28221e+00,7.67362e-03,2.65154e+00,2.37015e+00,
7.85236e-03,2.47830e+00,2.19982e+00,7.86243e-03,2.46902e+00,2.19071e+00,7.94328e-03,2.39627e+00,2.11928e+00,7.94330e-03,
2.39626e+00,2.11926e+00,8.12830e-03,2.24085e+00,1.96695e+00,9.06570e-03,1.64192e+00,1.38140e+00,1.00000e-02,1.25542e+00,
1.00584e+00,1.02460e-02,1.17637e+00,9.29229e-01,1.08393e-02,1.01506e+00,7.73591e-01,1.13559e-02,9.02049e-01,6.64852e-01,
1.24946e-02,7.16457e-01,4.87516e-01,1.25890e-02,7.04077e-01,4.75769e-01,1.25892e-02,7.04044e-01,4.75739e-01,1.30317e-02,
6.50507e-01,4.25438e-01,1.31826e-02,6.33928e-01,4.09893e-01,1.38038e-02,5.72986e-01,3.52872e-01,1.38056e-02,5.72829e-01,
3.52725e-01,1.49702e-02,4.84960e-01,2.71336e-01,1.54882e-02,4.54214e-01,2.43153e-01,1.58489e-02,4.35231e-01,2.25801e-01,
1.58490e-02,4.35228e-01,2.25797e-01,1.65687e-02,4.01893e-01,1.95910e-01,1.73780e-02,3.70787e-01,1.68368e-01,1.79887e-02,
3.51015e-01,1.50973e-01,1.83926e-02,3.39333e-01,1.40733e-01,1.99526e-02,3.02708e-01,1.09096e-01,1.99530e-02,3.02701e-01,
1.09090e-01,2.08519e-02,2.86039e-01,9.53238e-02,2.39067e-02,2.46450e-01,6.36201e-02,2.39883e-02,2.45656e-01,6.30029e-02,
2.51189e-02,2.35709e-01,5.53255e-02,2.51190e-02,2.35708e-01,5.53246e-02,2.54097e-02,2.33321e-01,5.36107e-02,2.76315e-02,
2.18114e-01,4.29283e-02,2.95121e-02,2.08462e-01,3.64780e-02,3.16228e-02,2.00145e-01,3.11435e-02,3.16230e-02,2.00144e-01,
3.11430e-02,3.26962e-02,1.96402e-01,2.90792e-02,3.54813e-02,1.88453e-01,2.49764e-02,3.67282e-02,1.85571e-01,2.35849e-02,
3.85628e-02,1.81908e-01,2.18996e-02,3.98107e-02,1.79728e-01,2.09576e-02,3.98110e-02,1.79727e-01,2.09574e-02,4.02717e-02,
1.78895e-01,2.06778e-02,4.58306e-02,1.70850e-01,1.83278e-02,5.01187e-02,1.66385e-01,1.73474e-02,5.01190e-02,1.66385e-01,
1.73474e-02,5.06991e-02,1.65789e-01,1.72868e-02,5.18800e-02,1.64631e-01,1.71802e-02,5.47598e-02,1.62077e-01,1.69969e-02,
6.30957e-02,1.56254e-01,1.68425e-02,6.30960e-02,1.56254e-01,1.68425e-02,6.38264e-02,1.55762e-01,1.68862e-02,6.53131e-02,
1.54796e-01,1.69761e-02,6.68199e-02,1.53864e-01,1.70680e-02,7.07946e-02,1.51594e-01,1.73091e-02,7.32825e-02,1.50301e-01,
1.74563e-02,7.67362e-02,1.48645e-01,1.76536e-02,7.85236e-02,1.47843e-01,1.77517e-02,7.94328e-02,1.47448e-01,1.78004e-02,
7.94330e-02,1.47448e-01,1.78004e-02,8.44368e-02,1.45089e-01,1.82701e-02,9.12011e-02,1.42255e-01,1.88138e-02,9.22571e-02,
1.41845e-01,1.88903e-02,1.00000e-01,1.39058e-01,1.93897e-02,1.01158e-01,1.38615e-01,1.94993e-02,1.05925e-01,1.36870e-01,
1.99166e-02,1.08393e-01,1.36015e-01,2.01124e-02,1.10918e-01,1.35169e-01,2.02999e-02,1.11457e-01,1.34992e-01,2.03384e-02,
1.23027e-01,1.31482e-01,2.10443e-02,1.25890e-01,1.30689e-01,2.11886e-02,1.25893e-01,1.30688e-01,2.11887e-02,1.27350e-01,
1.30243e-01,2.13006e-02,1.30317e-01,1.29361e-01,2.15163e-02,1.36458e-01,1.27624e-01,2.19161e-02,1.41254e-01,1.26344e-01,
2.21891e-02,1.44544e-01,1.25501e-01,2.23589e-02,1.58489e-01,1.22211e-01,2.29461e-02,1.58490e-01,1.22211e-01,2.29462e-02,
1.60324e-01,1.21764e-01,2.30505e-02,1.60607e-01,1.21695e-01,2.30662e-02,1.62181e-01,1.21319e-01,2.31518e-02,1.64059e-01,
1.20876e-01,2.32501e-02,1.65959e-01,1.20435e-01,2.33456e-02,1.79887e-01,1.17405e-01,2.39354e-02,1.84077e-01,1.16557e-01,
2.40801e-02,1.90546e-01,1.15299e-01,2.42786e-02,1.99526e-01,1.13647e-01,2.45102e-02,1.99530e-01,1.13647e-01,2.45104e-02,
2.04174e-01,1.12756e-01,2.46880e-02,2.21309e-01,1.09701e-01,2.52169e-02,2.26464e-01,1.08845e-01,2.53430e-02,2.29087e-01,
1.08420e-01,2.54021e-02,2.31740e-01,1.07997e-01,2.54586e-02,2.48313e-01,1.05497e-01,2.57462e-02,2.51189e-01,1.05087e-01,
2.57860e-02,2.51190e-01,1.05087e-01,2.57860e-02,2.54097e-01,1.04646e-01,2.58587e-02,2.57040e-01,1.04206e-01,2.59283e-02,
2.66073e-01,1.02901e-01,2.61194e-02,2.84097e-01,1.00471e-01,2.64127e-02,2.88403e-01,9.99220e-02,2.64680e-02,2.91743e-01,
9.95041e-02,2.65074e-02,2.98538e-01,9.86739e-02,2.65789e-02,3.12608e-01,9.70356e-02,2.66939e-02,3.16228e-01,9.66305e-02,
2.67170e-02,3.16230e-01,9.66303e-02,2.67171e-02,3.23594e-01,9.57742e-02,2.68209e-02,3.34965e-01,9.45047e-02,2.69555e-02,
3.42768e-01,9.36681e-02,2.70315e-02,3.54813e-01,9.24278e-02,2.71262e-02,3.58922e-01,9.20182e-02,2.71528e-02,3.71535e-01,
9.08006e-02,2.72183e-02,3.89045e-01,8.92033e-02,2.72740e-02,3.98107e-01,8.84156e-02,2.72891e-02,3.98110e-01,8.84154e-02,
2.72891e-02,4.02717e-01,8.80000e-02,2.73214e-02,4.12098e-01,8.71749e-02,2.73779e-02,4.26580e-01,8.59520e-02,2.74433e-02,
4.36516e-01,8.51466e-02,2.74746e-02,4.41020e-01,8.47900e-02,2.74855e-02,4.51856e-01,8.39530e-02,2.75040e-02,4.69580e-01,
8.26435e-02,2.75133e-02,4.73151e-01,8.23881e-02,2.75123e-02,4.84172e-01,8.16169e-02,2.75041e-02,4.95450e-01,8.08531e-02,
2.74881e-02,5.01187e-01,8.04739e-02,2.74773e-02,5.01190e-01,8.04737e-02,2.74773e-02,5.06991e-01,8.00755e-02,2.74886e-02,
5.18800e-01,7.92845e-02,2.75040e-02,5.30884e-01,7.85016e-02,2.75100e-02,5.43250e-01,7.77264e-02,2.75069e-02,5.49541e-01,
7.73418e-02,2.75022e-02,5.62341e-01,7.65783e-02,2.74864e-02,5.82103e-01,7.54474e-02,2.74476e-02,5.95662e-01,7.47029e-02,
2.74122e-02,6.09537e-01,7.39659e-02,2.73696e-02,6.30957e-01,7.28741e-02,2.72928e-02,6.30960e-01,7.28740e-02,2.72928e-02,
6.38264e-01,7.24943e-02,2.72835e-02,6.45654e-01,7.21165e-02,2.72721e-02,6.60694e-01,7.13669e-02,2.72429e-02,6.83912e-01,
7.02571e-02,2.71842e-02,6.99842e-01,6.95270e-02,2.71356e-02,7.16143e-01,6.88045e-02,2.70799e-02,7.41310e-01,6.77350e-02,
2.69835e-02,7.58578e-01,6.70313e-02,2.69113e-02,7.94328e-01,6.56460e-02,2.67489e-02,7.94330e-01,6.56459e-02,2.67489e-02,
8.03526e-01,6.52857e-02,2.67199e-02,8.22243e-01,6.45711e-02,2.66564e-02,8.41395e-01,6.38644e-02,2.65861e-02,8.51138e-01,
6.35140e-02,2.65484e-02,8.81049e-01,6.24742e-02,2.64258e-02,8.91251e-01,6.21315e-02,2.63819e-02,9.01571e-01,6.17906e-02,
2.63366e-02,9.54993e-01,6.01142e-02,2.60891e-02,9.66051e-01,5.97845e-02,2.60358e-02,1.00000e+00,5.88061e-02,2.58685e-02,
1.00000e-03,2.20904e+03,2.20680e+03,1.02329e-03,2.07210e+03,2.06995e+03,1.04713e-03,1.94355e+03,1.94149e+03,1.05925e-03,
1.88231e+03,1.88028e+03,1.16145e-03,1.45209e+03,1.45033e+03,1.18850e-03,1.36089e+03,1.35919e+03,1.19064e-03,1.35401e+03,
1.35231e+03,1.20226e-03,1.31746e+03,1.31579e+03,1.24451e-03,1.19523e+03,1.19363e+03,1.25890e-03,1.15652e+03,1.15495e+03,
1.25892e-03,1.15645e+03,1.15488e+03,1.32218e-03,1.00494e+03,1.00346e+03,1.33352e-03,9.80656e+02,9.79190e+02,1.36458e-03,
9.18068e+02,9.16641e+02,1.39637e-03,8.59480e+02,8.58088e+02,1.41837e-03,8.21818e+02,8.20450e+02,1.51356e-03,6.82235e+02,
6.80956e+02,1.54882e-03,6.38044e+02,6.36794e+02,1.58489e-03,5.96720e+02,5.95497e+02,1.58490e-03,5.96713e+02,5.95489e+02,
1.63345e-03,5.46592e+02,5.45401e+02,1.64059e-03,5.39702e+02,5.38516e+02,1.75792e-03,4.41443e+02,4.40329e+02,1.81970e-03,
3.99251e+02,3.98170e+02,1.87638e-03,3.64767e+02,3.63712e+02,1.92753e-03,3.36992e+02,3.35961e+02,1.99526e-03,3.04386e+02,
3.03383e+02,1.99530e-03,3.04369e+02,3.03366e+02,2.04662e-03,2.82431e+02,2.81449e+02,2.18776e-03,2.32066e+02,2.31135e+02,
2.25085e-03,2.13218e+02,2.12308e+02,2.26464e-03,2.09373e+02,2.08468e+02,2.34423e-03,1.88890e+02,1.88009e+02,2.49475e-03,
1.56921e+02,1.56082e+02,2.51189e-03,1.53754e+02,1.52920e+02,2.51190e-03,1.53751e+02,1.52917e+02,2.66073e-03,1.29531e+02,
1.28736e+02,2.69154e-03,1.25117e+02,1.24330e+02,2.76167e-03,1.15787e+02,1.15016e+02,2.88403e-03,1.01615e+02,1.00871e+02,
2.91743e-03,9.81529e+01,9.74158e+01,3.05617e-03,8.53455e+01,8.46356e+01,3.16228e-03,7.70181e+01,7.63284e+01,3.16230e-03,
7.70164e+01,7.63268e+01,3.23594e-03,7.18659e+01,7.11896e+01,3.27341e-03,6.94198e+01,6.87500e+01,3.33188e-03,6.57820e+01,
6.51219e+01,3.63078e-03,5.06726e+01,5.00594e+01,3.67282e-03,4.89328e+01,4.83255e+01,3.75956e-03,4.55882e+01,4.49924e+01,
3.93550e-03,3.96860e+01,3.91129e+01,3.98107e-03,3.83251e+01,3.77575e+01,3.98110e-03,3.83243e+01,3.77567e+01,4.02717e-03,
3.70111e+01,3.64490e+01,4.31328e-03,2.99999e+01,2.94693e+01,4.84172e-03,2.10850e+01,2.06026e+01,5.01187e-03,1.89811e+01,
1.85115e+01,5.01190e-03,1.89807e+01,1.85112e+01,5.24066e-03,1.65493e+01,1.60961e+01,6.00000e-03,1.09449e+01,1.05359e+01,
6.09537e-03,1.04323e+01,1.00280e+01,6.23735e-03,9.72774e+00,9.32992e+00,6.30957e-03,9.39070e+00,8.99604e+00,6.30960e-03,
9.39058e+00,8.99592e+00,7.24436e-03,6.16844e+00,5.80967e+00,7.44480e-03,5.68148e+00,5.32896e+00,7.49894e-03,5.55898e+00,
5.20809e+00,7.85236e-03,4.84254e+00,4.50150e+00,7.94328e-03,4.67748e+00,4.33879e+00,7.94330e-03,4.67745e+00,4.33876e+00,
8.68742e-03,3.57946e+00,3.25863e+00,9.01571e-03,3.20837e+00,2.89432e+00,9.33254e-03,2.89994e+00,2.59186e+00,9.44061e-03,
2.80436e+00,2.49820e+00,1.00000e-02,2.37545e+00,2.07836e+00,1.06888e-02,1.96362e+00,1.67681e+00,1.16145e-02,1.55820e+00,
1.28327e+00,1.18850e-02,1.46352e+00,1.19162e+00,1.20747e-02,1.40231e+00,1.13242e+00,1.23027e-02,1.33371e+00,1.06626e+00,
1.25890e-02,1.25476e+00,9.90206e-01,1.25892e-02,1.25470e+00,9.90143e-01,1.28825e-02,1.18127e+00,9.19518e-01,1.34872e-02,
1.04910e+00,7.92609e-01,1.48618e-02,8.25468e-01,5.79282e-01,1.53109e-02,7.69508e-01,5.26292e-01,1.56675e-02,7.29720e-01,
4.88680e-01,1.58489e-02,7.10899e-01,4.70910e-01,1.58490e-02,7.10892e-01,4.70904e-01,1.65233e-02,6.47732e-01,4.11968e-01,
1.69824e-02,6.10368e-01,3.77355e-01,1.71791e-02,5.95513e-01,3.63614e-01,1.82065e-02,5.28343e-01,3.01713e-01,1.99526e-02,
4.44394e-01,2.25319e-01,1.99530e-02,4.44379e-01,2.25305e-01,2.01837e-02,4.35347e-01,2.17270e-01,2.02160e-02,4.34115e-01,
2.16175e-01,2.27135e-02,3.58814e-01,1.50231e-01,2.31740e-02,3.48342e-01,1.41230e-01,2.51189e-02,3.12152e-01,1.10386e-01,
2.51190e-02,3.12150e-01,1.10385e-01,2.56117e-02,3.04503e-01,1.04158e-01,2.75423e-02,2.79459e-01,8.41709e-02,2.95798e-02,
2.59705e-01,6.87881e-02,3.16228e-02,2.44619e-01,5.74128e-02,3.16230e-02,2.44617e-01,5.74118e-02,3.23594e-02,2.39857e-01,
5.41129e-02,3.42768e-02,2.29195e-01,4.68869e-02,3.49442e-02,2.25998e-01,4.47738e-02,3.93550e-02,2.09590e-01,3.44937e-02,
3.98107e-02,2.08271e-01,3.37096e-02,3.98110e-02,2.08270e-01,3.37091e-02,4.19488e-02,2.02340e-01,3.06849e-02,4.21696e-02,
2.01783e-01,3.04125e-02,4.51856e-02,1.95095e-01,2.72876e-02,4.95825e-02,1.87699e-01,2.41974e-02,5.01187e-02,1.86936e-01,
2.39064e-02,5.01190e-02,1.86936e-01,2.39063e-02,5.43250e-02,1.81170e-01,2.23404e-02,5.49541e-02,1.80419e-01,2.21587e-02,
5.68853e-02,1.78265e-01,2.16682e-02,6.02313e-02,1.74992e-01,2.10147e-02,6.30957e-02,1.72553e-01,2.06052e-02,6.30960e-02,
1.72553e-01,2.06051e-02,6.91831e-02,1.67618e-01,2.03642e-02,6.99842e-02,1.67046e-01,2.03495e-02,7.34390e-02,1.64745e-01,
2.03173e-02,7.94328e-02,1.61271e-01,2.03441e-02,7.94330e-02,1.61271e-01,2.03441e-02,8.31764e-02,1.59104e-01,2.05718e-02,
9.22052e-02,1.54594e-01,2.10847e-02,9.44061e-02,1.53617e-01,2.11995e-02,9.77237e-02,1.52222e-01,2.13651e-02,1.00000e-01,
1.51314e-01,2.14729e-02,1.13501e-01,1.45908e-01,2.24702e-02,1.19057e-01,1.43982e-01,2.27946e-02,1.25890e-01,1.41799e-01,
2.31381e-02,1.25893e-01,1.41798e-01,2.31382e-02,1.27350e-01,1.41300e-01,2.32499e-02,1.30317e-01,1.40314e-01,2.34659e-02,
1.38038e-01,1.37901e-01,2.39613e-02,1.47911e-01,1.35098e-01,2.44761e-02,1.56675e-01,1.32832e-01,2.48425e-02,1.58489e-01,
1.32386e-01,2.49094e-02,1.58490e-01,1.32386e-01,2.49094e-02,1.67880e-01,1.29950e-01,2.54214e-02,1.68281e-01,1.29850e-01,
2.54410e-02,1.86209e-01,1.25716e-01,2.61626e-02,1.90546e-01,1.24801e-01,2.62984e-02,1.99526e-01,1.22996e-01,2.65406e-02,
1.99530e-01,1.22995e-01,2.65408e-02,2.06538e-01,1.21539e-01,2.68179e-02,2.13796e-01,1.20103e-01,2.70667e-02,2.21309e-01,
1.18687e-01,2.72884e-02,2.29087e-01,1.17292e-01,2.74844e-02,2.31740e-01,1.16831e-01,2.75442e-02,2.39883e-01,1.15461e-01,
2.77079e-02,2.51189e-01,1.13664e-01,2.78907e-02,2.51190e-01,1.13664e-01,2.78907e-02,2.54097e-01,1.13185e-01,2.79683e-02,
2.63027e-01,1.11761e-01,2.81819e-02,2.66073e-01,1.11291e-01,2.82468e-02,2.75423e-01,1.09894e-01,2.84236e-02,2.80150e-01,
1.09213e-01,2.85010e-02,2.88403e-01,1.08061e-01,2.86192e-02,2.95121e-01,1.07157e-01,2.87008e-02,2.98538e-01,1.06708e-01,
2.87377e-02,3.01995e-01,1.06262e-01,2.87721e-02,3.16228e-01,1.04495e-01,2.88853e-02,3.16230e-01,1.04495e-01,2.88853e-02,
3.23594e-01,1.03565e-01,2.89964e-02,3.27341e-01,1.03104e-01,2.90473e-02,3.34965e-01,1.02187e-01,2.91402e-02,3.54813e-01,
9.99334e-02,2.93224e-02,3.58922e-01,9.94890e-02,2.93507e-02,3.71535e-01,9.81684e-02,2.94203e-02,3.84592e-01,9.68663e-02,
2.94679e-02,3.93550e-01,9.60083e-02,2.94880e-02,3.98107e-01,9.55823e-02,2.94948e-02,3.98110e-01,9.55821e-02,2.94948e-02,
4.12098e-01,9.42391e-02,2.95904e-02,4.16869e-01,9.37957e-02,2.96165e-02,4.31519e-01,9.24786e-02,2.96788e-02,4.36516e-01,
9.20438e-02,2.96943e-02,4.51856e-01,9.07522e-02,2.97258e-02,4.73151e-01,8.90591e-02,2.97346e-02,4.78630e-01,8.86409e-02,
2.97313e-02,4.89779e-01,8.78107e-02,2.97181e-02,4.95450e-01,8.73986e-02,2.97084e-02,5.01187e-01,8.69885e-02,2.96967e-02,
5.01190e-01,8.69883e-02,2.96967e-02,5.12861e-01,8.61277e-02,2.97181e-02,5.24808e-01,8.52756e-02,2.97292e-02,5.30884e-01,
8.48528e-02,2.97310e-02,5.43250e-01,8.40136e-02,2.97274e-02,5.55904e-01,8.31829e-02,2.97145e-02,5.75440e-01,8.19526e-02,
2.96785e-02,5.95662e-01,8.07408e-02,2.96238e-02,6.09537e-01,7.99431e-02,2.95775e-02,6.16595e-01,7.95473e-02,2.95515e-02,
6.23735e-01,7.91534e-02,2.95237e-02,6.30957e-01,7.87616e-02,2.94942e-02,6.30960e-01,7.87614e-02,2.94942e-02,6.45654e-01,
7.79425e-02,2.94717e-02,6.60694e-01,7.71320e-02,2.94402e-02,6.68344e-01,7.67300e-02,2.94211e-02,6.76083e-01,7.63301e-02,
2.94000e-02,6.99842e-01,7.51430e-02,2.93243e-02,7.07946e-01,7.47515e-02,2.92951e-02,7.32825e-01,7.35892e-02,2.91965e-02,
7.58578e-01,7.24453e-02,2.90820e-02,7.62957e-01,7.22564e-02,2.90614e-02,7.94328e-01,7.09480e-02,2.89066e-02,7.94330e-01,
7.09479e-02,2.89066e-02,8.00000e-01,7.07070e-02,2.88874e-02,8.03526e-01,7.05585e-02,2.88752e-02,8.22243e-01,6.97859e-02,
2.88067e-02,8.70964e-01,6.78917e-02,2.86033e-02,9.01571e-01,6.67802e-02,2.84610e-02,9.54993e-01,6.49682e-02,2.81937e-02,
1.00000e+00,6.35543e-02,2.79553e-02,1.00000e-03,3.30890e+03,3.30300e+03,1.01158e-03,3.20789e+03,3.20217e+03,1.05925e-03,
2.83346e+03,2.82842e+03,1.08393e-03,2.66298e+03,2.65824e+03,1.09648e-03,2.58018e+03,2.57558e+03,1.11047e-03,2.49198e+03,
2.48752e+03,1.17490e-03,2.13474e+03,2.13088e+03,1.21619e-03,1.94163e+03,1.93808e+03,1.23027e-03,1.88123e+03,1.87777e+03,
1.24451e-03,1.82186e+03,1.81849e+03,1.25890e-03,1.76447e+03,1.76119e+03,1.25892e-03,1.76437e+03,1.76109e+03,1.34947e-03,
1.45408e+03,1.45126e+03,1.36458e-03,1.40967e+03,1.40691e+03,1.39637e-03,1.32206e+03,1.31943e+03,1.42889e-03,1.23990e+03,
1.23738e+03,1.45189e-03,1.18595e+03,1.18351e+03,1.47911e-03,1.12614e+03,1.12378e+03,1.58489e-03,9.25960e+02,9.23878e+02,
1.58490e-03,9.25948e+02,9.23866e+02,1.60325e-03,8.96246e+02,8.94204e+02,1.64911e-03,8.27373e+02,8.25422e+02,1.71791e-03,
7.36862e+02,7.35032e+02,1.75792e-03,6.90308e+02,6.88539e+02,1.84077e-03,6.04805e+02,6.03148e+02,1.88365e-03,5.66117e+02,
5.64510e+02,1.99526e-03,4.79831e+02,4.78340e+02,1.99530e-03,4.79805e+02,4.78313e+02,2.00000e-03,4.76573e+02,4.75086e+02,
2.06538e-03,4.34518e+02,4.33087e+02,2.09549e-03,4.16595e+02,4.15189e+02,2.18776e-03,3.67500e+02,3.66162e+02,2.26464e-03,
3.32343e+02,3.31056e+02,2.27332e-03,3.28666e+02,3.27384e+02,2.39883e-03,2.81073e+02,2.79863e+02,2.46932e-03,2.58357e+02,
2.57182e+02,2.48313e-03,2.54199e+02,2.53030e+02,2.51189e-03,2.45715e+02,2.44561e+02,2.51190e-03,2.45711e+02,2.44557e+02,
2.57680e-03,2.27911e+02,2.26787e+02,2.63027e-03,2.14515e+02,2.13413e+02,2.68772e-03,2.01273e+02,2.00194e+02,2.81838e-03,
1.74984e+02,1.73956e+02,2.92554e-03,1.56762e+02,1.55769e+02,3.01995e-03,1.42756e+02,1.41794e+02,3.05492e-03,1.37937e+02,
1.36986e+02,3.09030e-03,1.33278e+02,1.32337e+02,3.16228e-03,1.24428e+02,1.23508e+02,3.16230e-03,1.24426e+02,1.23505e+02,
3.23412e-03,1.16363e+02,1.15462e+02,3.50752e-03,9.13549e+01,9.05213e+01,3.57488e-03,8.63211e+01,8.55022e+01,3.63078e-03,
8.24218e+01,8.16152e+01,3.71535e-03,7.69556e+01,7.61667e+01,3.93913e-03,6.45221e+01,6.37754e+01,3.98107e-03,6.24965e+01,
6.17574e+01,3.98110e-03,6.24952e+01,6.17561e+01,4.31519e-03,4.90379e+01,4.83542e+01,4.36516e-03,4.73698e+01,4.66934e+01,
4.40737e-03,4.60193e+01,4.53489e+01,4.41570e-03,4.57588e+01,4.50896e+01,4.57088e-03,4.12457e+01,4.05986e+01,4.98967e-03,
3.16148e+01,3.10183e+01,5.01187e-03,3.11924e+01,3.05984e+01,5.01190e-03,3.11919e+01,3.05979e+01,5.30884e-03,2.62037e+01,
2.56414e+01,5.43250e-03,2.44407e+01,2.38903e+01,5.49541e-03,2.36047e+01,2.30601e+01,5.62341e-03,2.20186e+01,2.14853e+01,
5.80017e-03,2.00361e+01,1.95174e+01,6.30957e-03,1.55107e+01,1.50294e+01,6.30960e-03,1.55105e+01,1.50292e+01,6.60693e-03,
1.34897e+01,1.30276e+01,6.91831e-03,1.17358e+01,1.12916e+01,7.00000e-03,1.13272e+01,1.08874e+01,7.24436e-03,1.02037e+01,
9.77623e+00,7.61377e-03,8.77474e+00,8.36390e+00,7.94328e-03,7.72052e+00,7.32296e+00,7.94330e-03,7.72047e+00,7.32291e+00,
8.12830e-03,7.20310e+00,6.81269e+00,8.51138e-03,6.27278e+00,5.89594e+00,8.70964e-03,5.85536e+00,5.48494e+00,9.33254e-03,
4.75918e+00,4.40672e+00,1.00000e-02,3.87701e+00,3.54063e+00,1.01158e-02,3.74764e+00,3.41386e+00,1.09648e-02,2.96145e+00,
2.64461e+00,1.18937e-02,2.34105e+00,2.03924e+00,1.22470e-02,2.15389e+00,1.85717e+00,1.25890e-02,1.99292e+00,1.70076e+00,
1.25892e-02,1.99281e+00,1.70066e+00,1.27350e-02,1.92947e+00,1.63928e+00,1.40974e-02,1.45952e+00,1.18515e+00,1.41254e-02,
1.45176e+00,1.17768e+00,1.42889e-02,1.40725e+00,1.13486e+00,1.58489e-02,1.07209e+00,8.13500e-01,1.58490e-02,1.07208e+00,
8.13488e-01,1.59365e-02,1.05713e+00,7.99258e-01,1.60324e-02,1.04108e+00,7.84020e-01,1.64059e-02,9.82253e-01,7.28231e-01,
1.77686e-02,8.08558e-01,5.64175e-01,1.84077e-02,7.44367e-01,5.04024e-01,1.86209e-02,7.24809e-01,4.85727e-01,1.99526e-02,
6.21365e-01,3.89302e-01,1.99530e-02,6.21340e-01,3.89278e-01,2.00588e-02,6.14270e-01,3.82768e-01,2.06538e-02,5.77116e-01,
3.48737e-01,2.24853e-02,4.86626e-01,2.66452e-01,2.45471e-02,4.15087e-01,2.02446e-01,2.49472e-02,4.03852e-01,1.92465e-01,
2.51189e-02,3.99234e-01,1.88391e-01,2.51190e-02,3.99230e-01,1.88388e-01,2.75423e-02,3.45016e-01,1.41954e-01,2.78255e-02,
3.39891e-01,1.37619e-01,3.09030e-02,2.95485e-01,1.00749e-01,3.16228e-02,2.87515e-01,9.42455e-02,3.16230e-02,2.87513e-01,
9.42436e-02,3.28310e-02,2.75308e-01,8.47649e-02,3.34965e-02,2.69285e-01,8.01626e-02,3.80189e-02,2.38372e-01,5.72199e-02,
3.93765e-02,2.31655e-01,5.24347e-02,3.98107e-02,2.29680e-01,5.10538e-02,3.98110e-02,2.29679e-01,5.10529e-02,4.31519e-02,
2.16212e-01,4.25863e-02,4.62381e-02,2.06789e-01,3.70185e-02,4.69759e-02,2.04861e-01,3.59241e-02,5.01187e-02,1.97711e-01,
3.20420e-02,5.01190e-02,1.97711e-01,3.20418e-02,5.18800e-02,1.94091e-01,3.04291e-02,5.49541e-02,1.88659e-01,2.81608e-02,
5.61966e-02,1.86734e-01,2.74071e-02,5.95662e-02,1.82118e-01,2.57281e-02,6.02560e-02,1.81272e-01,2.54397e-02,6.30957e-02,
1.78088e-01,2.44108e-02,6.30960e-02,1.78088e-01,2.44108e-02,6.86889e-02,1.72343e-01,2.32516e-02,6.91831e-02,1.71894e-01,
2.31740e-02,7.32825e-02,1.68480e-01,2.26441e-02,7.94328e-02,1.64202e-01,2.21327e-02,7.94330e-02,1.64202e-01,2.21327e-02,
8.31764e-02,1.61689e-01,2.21069e-02,8.40973e-02,1.61110e-01,2.21068e-02,8.81049e-02,1.58738e-01,2.21277e-02,9.77237e-02,
1.53898e-01,2.22639e-02,9.88553e-02,1.53393e-01,2.22843e-02,1.00000e-01,1.52894e-01,2.23058e-02,1.05925e-01,1.50159e-01,
2.26403e-02,1.05990e-01,1.50130e-01,2.26437e-02,1.13501e-01,1.47042e-01,2.30200e-02,1.21619e-01,1.44092e-01,2.33693e-02,
1.25890e-01,1.42674e-01,2.35310e-02,1.25893e-01,1.42673e-01,2.35310e-02,1.30317e-01,1.41116e-01,2.38167e-02,1.33352e-01,
1.40098e-01,2.39968e-02,1.38038e-01,1.38598e-01,2.42525e-02,1.39637e-01,1.38105e-01,2.43337e-02,1.40925e-01,1.37715e-01,
2.43971e-02,1.49624e-01,1.35214e-01,2.47794e-02,1.54882e-01,1.33810e-01,2.49762e-02,1.58489e-01,1.32888e-01,2.50981e-02,
1.58490e-01,1.32888e-01,2.50981e-02,1.62181e-01,1.31879e-01,2.52986e-02,1.69824e-01,1.29895e-01,2.56667e-02,1.73780e-01,
1.28921e-01,2.58347e-02,1.90546e-01,1.25130e-01,2.64056e-02,1.92752e-01,1.24668e-01,2.64661e-02,1.94984e-01,1.24208e-01,
2.65245e-02,1.99526e-01,1.23296e-01,2.66344e-02,1.99530e-01,1.23295e-01,2.66346e-02,2.01837e-01,1.22800e-01,2.67270e-02,
2.13796e-01,1.20361e-01,2.71432e-02,2.18776e-01,1.19403e-01,2.72890e-02,2.26464e-01,1.17983e-01,2.74867e-02,2.34423e-01,
1.16586e-01,2.76604e-02,2.37137e-01,1.16124e-01,2.77132e-02,2.39883e-01,1.15665e-01,2.77634e-02,2.51189e-01,1.13851e-01,
2.79401e-02,2.51190e-01,1.13851e-01,2.79401e-02,2.60016e-01,1.12408e-01,2.81588e-02,2.63027e-01,1.11931e-01,2.82256e-02,
2.63880e-01,1.11798e-01,2.82438e-02,2.66073e-01,1.11457e-01,2.82892e-02,2.88403e-01,1.08204e-01,2.86542e-02,2.91743e-01,
1.07748e-01,2.86954e-02,2.95121e-01,1.07294e-01,2.87340e-02,3.01995e-01,1.06393e-01,2.88037e-02,3.16228e-01,1.04617e-01,
2.89141e-02,3.16230e-01,1.04617e-01,2.89141e-02,3.23594e-01,1.03682e-01,2.90236e-02,3.31131e-01,1.02755e-01,2.91209e-02,
3.38844e-01,1.01838e-01,2.92065e-02,3.46737e-01,1.00930e-01,2.92808e-02,3.50265e-01,1.00533e-01,2.93100e-02,3.58922e-01,
9.95833e-02,2.93719e-02,3.67282e-01,9.86965e-02,2.94197e-02,3.75837e-01,9.78183e-02,2.94576e-02,3.93550e-01,9.60869e-02,
2.95053e-02,3.98107e-01,9.56591e-02,2.95116e-02,3.98110e-01,9.56589e-02,2.95116e-02,4.07380e-01,9.47579e-02,2.95773e-02,
4.16869e-01,9.38657e-02,2.96315e-02,4.26580e-01,9.29823e-02,2.96749e-02,4.41570e-01,9.16735e-02,2.97203e-02,4.46684e-01,
9.12415e-02,2.97304e-02,4.57088e-01,9.03840e-02,2.97435e-02,4.67735e-01,8.95350e-02,2.97472e-02,4.73151e-01,8.91135e-02,
2.97457e-02,4.89779e-01,8.78617e-02,2.97283e-02,5.01187e-01,8.70373e-02,2.97063e-02,5.01190e-01,8.70371e-02,2.97063e-02,
5.12861e-01,8.61754e-02,2.97278e-02,5.37032e-01,8.44780e-02,2.97401e-02,5.49541e-01,8.36422e-02,2.97319e-02,5.55904e-01,
8.32275e-02,2.97244e-02,5.75440e-01,8.19961e-02,2.96886e-02,5.88844e-01,8.11856e-02,2.96542e-02,6.02560e-01,8.03833e-02,
2.96119e-02,6.30957e-01,7.88030e-02,2.95048e-02,6.30960e-01,7.88028e-02,2.95048e-02,6.44740e-01,7.80326e-02,2.94836e-02,
6.53131e-01,7.75752e-02,2.94672e-02,6.83912e-01,7.59685e-02,2.93863e-02,6.99842e-01,7.51779e-02,2.93335e-02,7.07946e-01,
7.47857e-02,2.93042e-02,7.41310e-01,7.32377e-02,2.91686e-02,7.58578e-01,7.24759e-02,2.90903e-02,7.67362e-01,7.20981e-02,
2.90487e-02,7.76247e-01,7.17222e-02,2.90055e-02,7.94328e-01,7.09765e-02,2.89145e-02,7.94330e-01,7.09764e-02,2.89144e-02,
8.03526e-01,7.05866e-02,2.88831e-02,8.22243e-01,6.98133e-02,2.88144e-02,8.31764e-01,6.94299e-02,2.87773e-02,8.41395e-01,
6.90486e-02,2.87383e-02,9.01571e-01,6.68049e-02,2.84684e-02,9.12011e-01,6.64382e-02,2.84178e-02,9.54993e-01,6.49915e-02,
2.82009e-02,9.77237e-01,6.42802e-02,2.80842e-02,1.00000e+00,6.35766e-02,2.79624e-02,1.00000e-03,4.58819e+03,4.57246e+03,
1.02329e-03,4.32475e+03,4.31013e+03,1.03514e-03,4.19548e+03,4.18139e+03,1.04713e-03,4.07000e+03,4.05641e+03,1.06040e-03,
3.93705e+03,3.92400e+03,1.13501e-03,3.29069e+03,3.28013e+03,1.14815e-03,3.19052e+03,3.18034e+03,1.16145e-03,3.09341e+03,
3.08358e+03,1.20616e-03,2.79506e+03,2.78630e+03,1.21619e-03,2.73365e+03,2.72511e+03,1.23027e-03,2.65045e+03,2.64220e+03,
1.25890e-03,2.49159e+03,2.48389e+03,1.25892e-03,2.49146e+03,2.48376e+03,1.33352e-03,2.13450e+03,2.12797e+03,1.36458e-03,
2.00648e+03,2.00037e+03,1.39637e-03,1.88380e+03,1.87807e+03,1.44544e-03,1.71370e+03,1.70848e+03,1.44726e-03,1.70780e+03,
1.70260e+03,1.53109e-03,1.46349e+03,1.45900e+03,1.56675e-03,1.37396e+03,1.36972e+03,1.58489e-03,1.33067e+03,1.32656e+03,
1.58490e-03,1.33066e+03,1.32654e+03,1.60325e-03,1.28876e+03,1.28476e+03,1.61613e-03,1.26039e+03,1.25647e+03,1.65959e-03,
1.17076e+03,1.16708e+03,1.75792e-03,9.97521e+02,9.94293e+02,1.79112e-03,9.46943e+02,9.43842e+02,1.84077e-03,8.77600e+02,
8.74676e+02,1.86209e-03,8.49946e+02,8.47091e+02,1.94984e-03,7.46152e+02,7.43551e+02,1.99526e-03,6.99087e+02,6.96599e+02,
1.99530e-03,6.99049e+02,6.96561e+02,2.00894e-03,6.85700e+02,6.83244e+02,2.04174e-03,6.54992e+02,6.52610e+02,2.11349e-03,
5.94018e+02,5.91781e+02,2.23872e-03,5.04763e+02,5.02734e+02,2.31740e-03,4.57130e+02,4.55213e+02,2.37137e-03,4.27884e+02,
4.26034e+02,2.44402e-03,3.92375e+02,3.90607e+02,2.45471e-03,3.87491e+02,3.85736e+02,2.51189e-03,3.62708e+02,3.61011e+02,
2.51190e-03,3.62702e+02,3.61005e+02,2.66073e-03,3.07476e+02,3.05911e+02,2.70999e-03,2.91512e+02,2.89985e+02,2.72270e-03,
2.87574e+02,2.86057e+02,2.75423e-03,2.78105e+02,2.76611e+02,2.85102e-03,2.51534e+02,2.50106e+02,2.95005e-03,2.27769e+02,
2.26400e+02,3.16228e-03,1.86136e+02,1.84878e+02,3.16230e-03,1.86133e+02,1.84875e+02,3.16267e-03,1.86068e+02,1.84811e+02,
3.19889e-03,1.79938e+02,1.78698e+02,3.27341e-03,1.68148e+02,1.66941e+02,3.34965e-03,1.57133e+02,1.55958e+02,3.43587e-03,
1.45815e+02,1.44674e+02,3.71535e-03,1.15863e+02,1.14818e+02,3.76152e-03,1.11734e+02,1.10703e+02,3.80189e-03,1.08283e+02,
1.07265e+02,3.84592e-03,1.04636e+02,1.03631e+02,3.98107e-03,9.44186e+01,9.34508e+01,3.98110e-03,9.44166e+01,9.34489e+01,
4.11241e-03,8.57319e+01,8.47975e+01,4.41570e-03,6.93926e+01,6.85279e+01,4.44279e-03,6.81437e+01,6.72846e+01,4.46684e-03,
6.70603e+01,6.62063e+01,4.57088e-03,6.26263e+01,6.17935e+01,4.62381e-03,6.05211e+01,5.96986e+01,4.88640e-03,5.12760e+01,
5.04999e+01,5.01187e-03,4.75219e+01,4.67665e+01,5.01190e-03,4.75211e+01,4.67657e+01,5.37032e-03,3.86382e+01,3.79361e+01,
5.44760e-03,3.70198e+01,3.63280e+01,5.55904e-03,3.48422e+01,3.41651e+01,5.62341e-03,3.36623e+01,3.29933e+01,6.07401e-03,
2.66725e+01,2.60542e+01,6.30957e-03,2.37825e+01,2.31876e+01,6.30960e-03,2.37822e+01,2.31873e+01,6.45654e-03,2.21894e+01,
2.16084e+01,6.91831e-03,1.80276e+01,1.74852e+01,7.05863e-03,1.69631e+01,1.64310e+01,7.32824e-03,1.51432e+01,1.46303e+01,
7.49894e-03,1.41252e+01,1.36235e+01,7.94328e-03,1.18750e+01,1.13993e+01,7.94330e-03,1.18749e+01,1.13992e+01,8.00000e-03,
1.16234e+01,1.11509e+01,8.60994e-03,9.32270e+00,8.88079e+00,8.93991e-03,8.32217e+00,7.89457e+00,9.33254e-03,7.31293e+00,
6.90087e+00,9.66051e-03,6.59420e+00,6.19385e+00,9.88553e-03,6.15617e+00,5.76324e+00,1.00000e-02,5.94851e+00,5.55919e+00,
1.08393e-02,4.68448e+00,4.31962e+00,1.20226e-02,3.45083e+00,3.11302e+00,1.23027e-02,3.22693e+00,2.89453e+00,1.24451e-02,
3.12084e+00,2.79105e+00,1.25890e-02,3.01868e+00,2.69146e+00,1.25892e-02,3.01851e+00,2.69130e+00,1.38038e-02,2.31912e+00,
2.01174e+00,1.41277e-02,2.17141e+00,1.86857e+00,1.54882e-02,1.68076e+00,1.39478e+00,1.58489e-02,1.57847e+00,1.29631e+00,
1.58490e-02,1.57846e+00,1.29629e+00,1.65959e-02,1.39444e+00,1.11990e+00,1.67928e-02,1.35141e+00,1.07874e+00,1.71791e-02,
1.27269e+00,1.00365e+00,1.95989e-02,9.09468e-01,6.58849e-01,1.97242e-02,8.95409e-01,6.45610e-01,1.99526e-02,8.70703e-01,
6.22361e-01,1.99530e-02,8.70663e-01,6.22323e-01,2.13796e-02,7.39292e-01,4.99778e-01,2.23852e-02,6.66349e-01,4.32149e-01,
2.23872e-02,6.66215e-01,4.32025e-01,2.51189e-02,5.22147e-01,3.00027e-01,2.51190e-02,5.22141e-01,3.00021e-01,2.51588e-02,
5.20484e-01,2.98532e-01,2.54097e-02,5.10245e-01,2.89380e-01,2.57040e-02,4.98749e-01,2.79123e-01,2.81470e-02,4.21160e-01,
2.10471e-01,2.95121e-02,3.88429e-01,1.82002e-01,3.16228e-02,3.48292e-01,1.47446e-01,3.16230e-02,3.48288e-01,1.47443e-01,
3.38844e-02,3.15207e-01,1.20129e-01,3.41733e-02,3.11598e-01,1.17184e-01,3.98107e-02,2.60015e-01,7.62906e-02,3.98110e-02,
2.60013e-01,7.62892e-02,3.98939e-02,2.59442e-01,7.58703e-02,4.16869e-02,2.48055e-01,6.76717e-02,4.31519e-02,2.40027e-01,
6.20046e-02,4.78630e-02,2.20158e-01,4.85342e-02,4.84172e-02,2.18285e-01,4.73134e-02,4.88371e-02,2.16919e-01,4.64293e-02,
5.01187e-02,2.12988e-01,4.39309e-02,5.01190e-02,2.12987e-01,4.39304e-02,5.55904e-02,1.98895e-01,3.62327e-02,5.83102e-02,
1.93532e-01,3.35428e-02,5.88844e-02,1.92500e-01,3.30464e-02,6.30957e-02,1.85872e-01,3.00066e-02,6.30960e-02,1.85871e-01,
3.00064e-02,6.38264e-02,1.84783e-01,2.96129e-02,6.91831e-02,1.77860e-01,2.73079e-02,7.13225e-02,1.75526e-01,2.66141e-02,
7.76247e-02,1.69682e-01,2.50872e-02,7.94328e-02,1.68245e-01,2.47582e-02,7.94330e-02,1.68245e-01,2.47582e-02,8.31764e-02,
1.65241e-01,2.43634e-02,8.73787e-02,1.62255e-01,2.40408e-02,9.22571e-02,1.59191e-01,2.37817e-02,9.54993e-02,1.57360e-01,
2.36598e-02,9.88553e-02,1.55611e-01,2.35652e-02,1.00000e-01,1.55045e-01,2.35391e-02,1.08751e-01,1.50684e-01,2.37280e-02,
1.09648e-01,1.50276e-01,2.37489e-02,1.14815e-01,1.48053e-01,2.38710e-02,1.25890e-01,1.43894e-01,2.41274e-02,1.25893e-01,
1.43893e-01,2.41275e-02,1.30317e-01,1.42237e-01,2.43513e-02,1.31826e-01,1.41695e-01,2.44233e-02,1.42437e-01,1.38170e-01,
2.48729e-02,1.44544e-01,1.37522e-01,2.49511e-02,1.51356e-01,1.35534e-01,2.51827e-02,1.58489e-01,1.33604e-01,2.53912e-02,
1.58490e-01,1.33604e-01,2.53912e-02,1.60324e-01,1.33080e-01,2.54829e-02,1.64059e-01,1.32041e-01,2.56590e-02,1.71791e-01,
1.30006e-01,2.59824e-02,1.73780e-01,1.29506e-01,2.60574e-02,1.84077e-01,1.27052e-01,2.63994e-02,1.92752e-01,1.25143e-01,
2.66334e-02,1.94984e-01,1.24672e-01,2.66867e-02,1.97022e-01,1.24250e-01,2.67330e-02,1.99526e-01,1.23740e-01,2.67870e-02,
1.99530e-01,1.23739e-01,2.67872e-02,2.04174e-01,1.22731e-01,2.69599e-02,2.06538e-01,1.22232e-01,2.70419e-02,2.18776e-01,
1.19775e-01,2.74101e-02,2.26464e-01,1.18334e-01,2.75985e-02,2.39883e-01,1.15983e-01,2.78617e-02,2.45471e-01,1.15060e-01,
2.79504e-02,2.51189e-01,1.14147e-01,2.80298e-02,2.51190e-01,1.14147e-01,2.80298e-02,2.60016e-01,1.12687e-01,2.82428e-02,
2.72270e-01,1.10776e-01,2.84847e-02,2.75423e-01,1.10304e-01,2.85381e-02,2.95121e-01,1.07524e-01,2.88018e-02,3.01995e-01,
1.06616e-01,2.88693e-02,3.09029e-01,1.05717e-01,2.89271e-02,3.16228e-01,1.04826e-01,2.89758e-02,3.16230e-01,1.04826e-01,
2.89758e-02,3.16455e-01,1.04797e-01,2.89793e-02,3.31131e-01,1.02947e-01,2.91763e-02,3.34965e-01,1.02483e-01,2.92191e-02,
3.46737e-01,1.01105e-01,2.93305e-02,3.58922e-01,9.97478e-02,2.94178e-02,3.67282e-01,9.88542e-02,2.94632e-02,3.71535e-01,
9.84107e-02,2.94822e-02,3.84592e-01,9.70933e-02,2.95251e-02,3.89045e-01,9.66585e-02,2.95348e-02,3.98107e-01,9.57953e-02,
2.95477e-02,3.98110e-01,9.57950e-02,2.95477e-02,4.07380e-01,9.48914e-02,2.96131e-02,4.12098e-01,9.44429e-02,2.96415e-02,
4.22950e-01,9.34387e-02,2.96956e-02,4.26580e-01,9.31110e-02,2.97103e-02,4.46684e-01,9.13663e-02,2.97658e-02,4.51856e-01,
9.09356e-02,2.97736e-02,4.57088e-01,9.05070e-02,2.97789e-02,4.67735e-01,8.96563e-02,2.97827e-02,4.89779e-01,8.79802e-02,
2.97641e-02,4.95450e-01,8.75663e-02,2.97542e-02,5.01187e-01,8.71545e-02,2.97423e-02,5.01190e-01,8.71543e-02,2.97423e-02,
5.12861e-01,8.62902e-02,2.97632e-02,5.37032e-01,8.45882e-02,2.97747e-02,5.43250e-01,8.41682e-02,2.97715e-02,5.62341e-01,
8.29210e-02,2.97483e-02,5.82103e-01,8.16931e-02,2.97056e-02,5.88844e-01,8.12880e-02,2.96873e-02,5.95662e-01,8.08849e-02,
2.96669e-02,6.16595e-01,7.96881e-02,2.95944e-02,6.30957e-01,7.89004e-02,2.95370e-02,6.30960e-01,7.89003e-02,2.95370e-02,
6.44740e-01,7.81281e-02,2.95155e-02,6.53131e-01,7.76697e-02,2.94989e-02,6.68344e-01,7.68602e-02,2.94624e-02,6.83912e-01,
7.60593e-02,2.94174e-02,6.99842e-01,7.52670e-02,2.93644e-02,7.16143e-01,7.44831e-02,2.93036e-02,7.24436e-01,7.40943e-02,
2.92705e-02,7.41310e-01,7.33229e-02,2.91988e-02,7.58578e-01,7.25596e-02,2.91203e-02,7.65156e-01,7.22755e-02,2.90892e-02,
7.85236e-01,7.14299e-02,2.89904e-02,7.94328e-01,7.10573e-02,2.89441e-02,7.94330e-01,7.10572e-02,2.89440e-02,8.03526e-01,
7.06667e-02,2.89125e-02,8.22243e-01,6.98919e-02,2.88436e-02,8.51138e-01,6.87458e-02,2.87264e-02,8.70964e-01,6.79924e-02,
2.86395e-02,9.01571e-01,6.68780e-02,2.84968e-02,9.33254e-01,6.57820e-02,2.83402e-02,9.44061e-01,6.54207e-02,2.82852e-02,
9.54993e-01,6.50615e-02,2.82287e-02,9.88553e-01,6.39956e-02,2.80514e-02,1.00000e+00,6.36443e-02,2.79898e-02,1.00000e-03,
5.66438e+03,5.62842e+03,1.03514e-03,5.19479e+03,5.16271e+03,1.09393e-03,4.50919e+03,4.48251e+03,1.12202e-03,4.22558e+03,
4.20104e+03,1.15513e-03,3.92220e+03,3.89989e+03,1.20226e-03,3.54028e+03,3.52069e+03,1.21619e-03,3.43740e+03,3.41853e+03,
1.24378e-03,3.24528e+03,3.22772e+03,1.25890e-03,3.14633e+03,3.12944e+03,1.25892e-03,3.14617e+03,3.12928e+03,1.31826e-03,
2.78658e+03,2.77203e+03,1.38351e-03,2.45349e+03,2.44101e+03,1.39637e-03,2.39440e+03,2.38227e+03,1.41254e-03,2.32285e+03,
2.31115e+03,1.42889e-03,2.25235e+03,2.24107e+03,1.51356e-03,1.93049e+03,1.92105e+03,1.54882e-03,1.81503e+03,1.80622e+03,
1.57369e-03,1.73921e+03,1.73081e+03,1.58489e-03,1.70648e+03,1.69826e+03,1.58490e-03,1.70646e+03,1.69824e+03,1.62725e-03,
1.59009e+03,1.58248e+03,1.65959e-03,1.50847e+03,1.50129e+03,1.75792e-03,1.28869e+03,1.28260e+03,1.79887e-03,1.21003e+03,
1.20432e+03,1.86302e-03,1.09947e+03,1.09428e+03,1.92753e-03,1.00174e+03,9.96997e+02,1.94564e-03,9.76100e+02,9.71470e+02,
1.94984e-03,9.70276e+02,9.65672e+02,1.99526e-03,9.10244e+02,9.05906e+02,1.99530e-03,9.10196e+02,9.05858e+02,2.08930e-03,
8.01104e+02,7.97237e+02,2.11349e-03,7.75932e+02,7.72170e+02,2.21392e-03,6.82213e+02,6.78837e+02,2.23872e-03,6.61465e+02,
6.58175e+02,2.29087e-03,6.19916e+02,6.16793e+02,2.45471e-03,5.10238e+02,5.07546e+02,2.48313e-03,4.93949e+02,4.91319e+02,
2.51189e-03,4.78183e+02,4.75613e+02,2.51190e-03,4.78175e+02,4.75605e+02,2.57168e-03,4.47517e+02,4.45062e+02,2.69154e-03,
3.93619e+02,3.91369e+02,2.85102e-03,3.33854e+02,3.31825e+02,2.91743e-03,3.12575e+02,3.10626e+02,3.09806e-03,2.63244e+02,
2.61478e+02,3.12608e-03,2.56555e+02,2.54814e+02,3.16228e-03,2.48243e+02,2.46534e+02,3.16230e-03,2.48238e+02,2.46529e+02,
3.19889e-03,2.40202e+02,2.38523e+02,3.31131e-03,2.17327e+02,2.15734e+02,3.33401e-03,2.13067e+02,2.11490e+02,3.38844e-03,
2.03302e+02,2.01764e+02,3.56296e-03,1.75783e+02,1.74352e+02,3.67282e-03,1.60988e+02,1.59617e+02,3.75837e-03,1.50603e+02,
1.49274e+02,3.79203e-03,1.46765e+02,1.45452e+02,3.80189e-03,1.45665e+02,1.44356e+02,3.89045e-03,1.36155e+02,1.34887e+02,
3.98107e-03,1.27268e+02,1.26039e+02,3.98110e-03,1.27266e+02,1.26037e+02,4.15879e-03,1.11982e+02,1.10820e+02,4.36516e-03,
9.71738e+01,9.60827e+01,4.41570e-03,9.39512e+01,9.28758e+01,4.57088e-03,8.49136e+01,8.38829e+01,5.01187e-03,6.46434e+01,
6.37224e+01,5.01190e-03,6.46423e+01,6.37213e+01,5.05178e-03,6.31442e+01,6.22318e+01,5.18800e-03,5.83639e+01,5.74808e+01,
5.24807e-03,5.64087e+01,5.55379e+01,5.43250e-03,5.09302e+01,5.00944e+01,5.50000e-03,4.91044e+01,4.82806e+01,5.62991e-03,
4.57959e+01,4.49940e+01,6.23735e-03,3.37319e+01,3.30192e+01,6.30957e-03,3.25935e+01,3.18902e+01,6.30960e-03,3.25930e+01,
3.18898e+01,6.53131e-03,2.94052e+01,2.87295e+01,6.68344e-03,2.74567e+01,2.67984e+01,7.00000e-03,2.38898e+01,2.32645e+01,
7.18770e-03,2.20651e+01,2.14575e+01,7.49894e-03,1.94306e+01,1.88506e+01,7.94328e-03,1.63541e+01,1.58084e+01,7.94330e-03,
1.63540e+01,1.58083e+01,8.03526e-03,1.58007e+01,1.52617e+01,8.31764e-03,1.42522e+01,1.37323e+01,8.45867e-03,1.35480e+01,
1.30370e+01,8.70964e-03,1.24063e+01,1.19107e+01,9.12011e-03,1.08039e+01,1.03309e+01,1.00000e-02,8.20376e+00,7.77095e+00,
1.01158e-02,7.92731e+00,7.49926e+00,1.03514e-02,7.40286e+00,6.98403e+00,1.07583e-02,6.59614e+00,6.19199e+00,1.10918e-02,
6.02208e+00,5.62909e+00,1.12202e-02,5.81930e+00,5.43037e+00,1.25890e-02,4.14307e+00,3.79057e+00,1.25892e-02,4.14283e+00,
3.79033e+00,1.30317e-02,3.74541e+00,3.40290e+00,1.33352e-02,3.50077e+00,3.16462e+00,1.39637e-02,3.06119e+00,2.73702e+00,
1.44544e-02,2.77039e+00,2.45461e+00,1.54454e-02,2.29269e+00,1.99169e+00,1.58489e-02,2.13183e+00,1.83627e+00,1.58490e-02,
2.13181e+00,1.83624e+00,1.65959e-02,1.87446e+00,1.58847e+00,1.75792e-02,1.59820e+00,1.32317e+00,1.77828e-02,1.54865e+00,
1.27568e+00,1.89184e-02,1.31081e+00,1.04827e+00,1.99526e-02,1.13983e+00,8.85648e-01,1.99530e-02,1.13978e+00,8.85594e-01,
2.01837e-02,1.10635e+00,8.53986e-01,2.13796e-02,9.55828e-01,7.12039e-01,2.17908e-02,9.11318e-01,6.70186e-01,2.23872e-02,
8.52480e-01,6.15094e-01,2.47998e-02,6.69564e-01,4.44837e-01,2.51189e-02,6.50494e-01,4.27256e-01,2.51190e-02,6.50486e-01,
4.27249e-01,2.54097e-02,6.33854e-01,4.12057e-01,2.75423e-02,5.32622e-01,3.20142e-01,2.83395e-02,5.02209e-01,2.92725e-01,
2.85102e-02,4.96128e-01,2.87275e-01,3.16228e-02,4.07215e-01,2.08228e-01,3.16230e-02,4.07210e-01,2.08224e-01,3.49954e-02,
3.43042e-01,1.53194e-01,3.75837e-02,3.08245e-01,1.24092e-01,3.80189e-02,3.03274e-01,1.19977e-01,3.87944e-02,2.94964e-01,
1.13127e-01,3.98107e-02,2.84977e-01,1.04999e-01,3.98110e-02,2.84974e-01,1.04997e-01,4.67104e-02,2.36398e-01,6.80741e-02,
4.73151e-02,2.33375e-01,6.58777e-02,5.01187e-02,2.21133e-01,5.71381e-02,5.01190e-02,2.21131e-01,5.71374e-02,5.24807e-02,
2.12330e-01,5.14209e-02,5.30884e-02,2.10295e-01,5.01273e-02,5.44320e-02,2.06076e-01,4.74782e-02,6.09537e-02,1.90016e-01,
3.79951e-02,6.30957e-02,1.85981e-01,3.57760e-02,6.30960e-02,1.85981e-01,3.57757e-02,6.60126e-02,1.80868e-01,3.33975e-02,
6.76083e-02,1.78364e-01,3.22911e-02,7.49894e-02,1.68928e-01,2.84826e-02,7.94328e-02,1.64525e-01,2.69283e-02,7.94330e-02,
1.64525e-01,2.69283e-02,8.22243e-02,1.61900e-01,2.62700e-02,8.26692e-02,1.61505e-01,2.61756e-02,9.01571e-02,1.55621e-01,
2.49260e-02,9.77237e-02,1.50868e-01,2.41273e-02,1.00000e-01,1.49615e-01,2.39488e-02,1.04713e-01,1.46974e-01,2.38079e-02,
1.05083e-01,1.46778e-01,2.37992e-02,1.05925e-01,1.46337e-01,2.37805e-02,1.07152e-01,1.45709e-01,2.37562e-02,1.14815e-01,
1.42123e-01,2.36596e-02,1.24452e-01,1.38287e-01,2.36248e-02,1.25890e-01,1.37767e-01,2.36247e-02,1.25893e-01,1.37766e-01,
2.36247e-02,1.31826e-01,1.35515e-01,2.37959e-02,1.35139e-01,1.34340e-01,2.38866e-02,1.36458e-01,1.33887e-01,2.39216e-02,
1.42889e-01,1.31791e-01,2.40852e-02,1.51356e-01,1.29281e-01,2.42753e-02,1.58489e-01,1.27353e-01,2.44138e-02,1.58490e-01,
1.27353e-01,2.44139e-02,1.62181e-01,1.26316e-01,2.45584e-02,1.65959e-01,1.25295e-01,2.46957e-02,1.67880e-01,1.24791e-01,
2.47621e-02,1.69824e-01,1.24290e-01,2.48266e-02,1.82533e-01,1.21238e-01,2.51897e-02,1.84077e-01,1.20891e-01,2.52275e-02,
1.90546e-01,1.19483e-01,2.53729e-02,1.97242e-01,1.18104e-01,2.55028e-02,1.99526e-01,1.17651e-01,2.55430e-02,1.99530e-01,
1.17650e-01,2.55431e-02,2.01837e-01,1.17159e-01,2.56199e-02,2.06538e-01,1.16185e-01,2.57660e-02,2.11349e-01,1.15222e-01,
2.59020e-02,2.29087e-01,1.11947e-01,2.63024e-02,2.31740e-01,1.11491e-01,2.63506e-02,2.34423e-01,1.11037e-01,2.63966e-02,
2.51189e-01,1.08367e-01,2.66279e-02,2.51190e-01,1.08367e-01,2.66280e-02,2.57040e-01,1.07428e-01,2.67589e-02,2.63027e-01,
1.06499e-01,2.68786e-02,2.69154e-01,1.05581e-01,2.69877e-02,2.70951e-01,1.05317e-01,2.70173e-02,2.81838e-01,1.03774e-01,
2.71749e-02,2.85102e-01,1.03328e-01,2.72154e-02,2.98538e-01,1.01569e-01,2.73539e-02,3.05492e-01,1.00703e-01,2.74096e-02,
3.09029e-01,1.00273e-01,2.74342e-02,3.16228e-01,9.94212e-02,2.74769e-02,3.16230e-01,9.94210e-02,2.74770e-02,3.34965e-01,
9.71882e-02,2.77033e-02,3.38844e-01,9.67486e-02,2.77405e-02,3.42768e-01,9.63114e-02,2.77751e-02,3.50752e-01,9.54437e-02,
2.78366e-02,3.67282e-01,9.37350e-02,2.79304e-02,3.71535e-01,9.33132e-02,2.79481e-02,3.80189e-01,9.24763e-02,2.79768e-02,
3.89045e-01,9.16477e-02,2.79969e-02,3.98107e-01,9.08275e-02,2.80086e-02,3.98110e-01,9.08272e-02,2.80086e-02,4.12098e-01,
8.95377e-02,2.80942e-02,4.21697e-01,8.86890e-02,2.81383e-02,4.26580e-01,8.82679e-02,2.81565e-02,4.31519e-01,8.78490e-02,
2.81723e-02,4.51856e-01,8.61949e-02,2.82120e-02,4.62381e-01,8.53805e-02,2.82183e-02,4.67735e-01,8.49764e-02,2.82183e-02,
4.95450e-01,8.29866e-02,2.81877e-02,5.01187e-01,8.25946e-02,2.81758e-02,5.01190e-01,8.25944e-02,2.81758e-02,5.06991e-01,
8.21823e-02,2.81865e-02,5.12861e-01,8.17722e-02,2.81947e-02,5.43250e-01,7.97536e-02,2.82004e-02,5.49541e-01,7.93563e-02,
2.81948e-02,5.55904e-01,7.89610e-02,2.81871e-02,5.62341e-01,7.85678e-02,2.81773e-02,5.95662e-01,7.66321e-02,2.80984e-02,
6.09537e-01,7.58719e-02,2.80538e-02,6.16595e-01,7.54947e-02,2.80289e-02,6.30957e-01,7.47462e-02,2.79738e-02,6.30960e-01,
7.47461e-02,2.79738e-02,6.45654e-01,7.39655e-02,2.79516e-02,6.60694e-01,7.31933e-02,2.79208e-02,6.76083e-01,7.24293e-02,
2.78819e-02,6.99842e-01,7.12988e-02,2.78090e-02,7.16143e-01,7.05552e-02,2.77513e-02,7.41310e-01,6.94547e-02,2.76518e-02,
7.58578e-01,6.87309e-02,2.75772e-02,7.76247e-01,6.80148e-02,2.74965e-02,7.94328e-01,6.73063e-02,2.74100e-02,7.94330e-01,
6.73062e-02,2.74100e-02,8.22243e-01,6.62012e-02,2.73147e-02,8.31764e-01,6.58370e-02,2.72793e-02,8.41395e-01,6.54748e-02,
2.72422e-02,8.60994e-01,6.47565e-02,2.71631e-02,8.91251e-01,6.36941e-02,2.70324e-02,9.12011e-01,6.29956e-02,2.69377e-02,
9.22571e-01,6.26493e-02,2.68883e-02,9.66051e-01,6.12834e-02,2.66770e-02,1.00000e+00,6.02788e-02,2.65054e-02,1.00000e-03,
7.41154e+03,7.32929e+03,1.00497e-03,7.31434e+03,7.23352e+03,1.01158e-03,7.18777e+03,7.10882e+03,1.02679e-03,6.90753e+03,
6.83265e+03,1.03000e-03,6.85021e+03,6.77616e+03,1.05705e-03,6.42048e+03,6.35264e+03,1.07152e-03,6.20605e+03,6.14125e+03,
1.10370e-03,5.77700e+03,5.71821e+03,1.14815e-03,5.25034e+03,5.19869e+03,1.16145e-03,5.10606e+03,5.05631e+03,1.17790e-03,
4.93502e+03,4.88750e+03,1.19236e-03,4.78519e+03,4.73957e+03,1.20226e-03,4.68615e+03,4.64179e+03,1.25621e-03,4.19413e+03,
4.15581e+03,1.25890e-03,4.17151e+03,4.13346e+03,1.25892e-03,4.17130e+03,4.13326e+03,1.28825e-03,3.93549e+03,3.90025e+03,
1.33830e-03,3.56980e+03,3.53876e+03,1.34896e-03,3.49800e+03,3.46776e+03,1.41254e-03,3.10897e+03,3.08299e+03,1.43522e-03,
2.98473e+03,2.96007e+03,1.51356e-03,2.60510e+03,2.58434e+03,1.54882e-03,2.45203e+03,2.43277e+03,1.55776e-03,2.41519e+03,
2.39629e+03,1.56675e-03,2.37891e+03,2.36035e+03,1.58489e-03,2.30791e+03,2.29003e+03,1.58490e-03,2.30788e+03,2.29000e+03,
1.62181e-03,2.17221e+03,2.15561e+03,1.67775e-03,1.98678e+03,1.97187e+03,1.69824e-03,1.92430e+03,1.90996e+03,1.77624e-03,
1.70693e+03,1.69449e+03,1.79887e-03,1.65022e+03,1.63826e+03,1.81970e-03,1.60029e+03,1.58875e+03,1.88365e-03,1.45928e+03,
1.44890e+03,1.97242e-03,1.29042e+03,1.28138e+03,1.99526e-03,1.25053e+03,1.24180e+03,1.99530e-03,1.25047e+03,1.24174e+03,
2.01375e-03,1.21947e+03,1.21098e+03,2.11349e-03,1.06885e+03,1.06148e+03,2.13796e-03,1.03579e+03,1.02866e+03,2.22052e-03,
9.34068e+02,9.27658e+02,2.23872e-03,9.13498e+02,9.07232e+02,2.31740e-03,8.31359e+02,8.25655e+02,2.39609e-03,7.57986e+02,
7.52769e+02,2.45471e-03,7.08953e+02,7.04056e+02,2.48313e-03,6.86714e+02,6.81960e+02,2.51189e-03,6.65174e+02,6.60557e+02,
2.51190e-03,6.65163e+02,6.60547e+02,2.60016e-03,6.04529e+02,6.00292e+02,2.66073e-03,5.67208e+02,5.63201e+02,2.67104e-03,
5.61077e+02,5.57106e+02,2.88403e-03,4.52269e+02,4.48949e+02,2.88810e-03,4.50480e+02,4.47171e+02,2.98006e-03,4.12490e+02,
4.09400e+02,3.01995e-03,3.97360e+02,3.94357e+02,3.16228e-03,3.49130e+02,3.46401e+02,3.16230e-03,3.49123e+02,3.46394e+02,
3.19889e-03,3.38019e+02,3.35352e+02,3.31131e-03,3.06296e+02,3.03807e+02,3.38844e-03,2.86823e+02,2.84442e+02,3.42575e-03,
2.77997e+02,2.75665e+02,3.54813e-03,2.51499e+02,2.49314e+02,3.78704e-03,2.08841e+02,2.06892e+02,3.84592e-03,1.99852e+02,
1.97954e+02,3.89045e-03,1.93307e+02,1.91446e+02,3.98107e-03,1.80856e+02,1.79065e+02,3.98110e-03,1.80852e+02,1.79062e+02,
4.00000e-03,1.78393e+02,1.76616e+02,4.15517e-03,1.59798e+02,1.58126e+02,4.26579e-03,1.48107e+02,1.46504e+02,4.54352e-03,
1.23428e+02,1.21971e+02,4.62381e-03,1.17338e+02,1.15918e+02,4.73151e-03,1.09693e+02,1.08321e+02,4.88613e-03,9.98412e+01,
9.85311e+01,4.95450e-03,9.58628e+01,9.45787e+01,5.01187e-03,9.26878e+01,9.14246e+01,5.01190e-03,9.26863e+01,9.14231e+01,
5.24807e-03,8.10098e+01,7.98253e+01,5.34182e-03,7.69248e+01,7.57684e+01,5.55904e-03,6.84684e+01,6.73737e+01,5.82103e-03,
5.97509e+01,5.87212e+01,5.87824e-03,5.80488e+01,5.70320e+01,6.30957e-03,4.70939e+01,4.61669e+01,6.30960e-03,4.70933e+01,
4.61663e+01,6.45654e-03,4.40008e+01,4.31006e+01,6.50344e-03,4.30717e+01,4.21796e+01,6.68344e-03,3.97402e+01,3.88789e+01,
6.76083e-03,3.84135e+01,3.75648e+01,7.07946e-03,3.34849e+01,3.26834e+01,7.15741e-03,3.24101e+01,3.16193e+01,7.58578e-03,
2.72608e+01,2.65245e+01,7.94328e-03,2.37753e+01,2.30780e+01,7.94330e-03,2.37751e+01,2.30779e+01,8.03526e-03,2.29766e+01,
2.22888e+01,8.09765e-03,2.24550e+01,2.17734e+01,8.31764e-03,2.07380e+01,2.00780e+01,8.41395e-03,2.00344e+01,1.93834e+01,
9.27526e-03,1.49706e+01,1.43880e+01,9.66051e-03,1.32612e+01,1.27045e+01,9.88553e-03,1.23833e+01,1.18403e+01,1.00000e-02,
1.19668e+01,1.14305e+01,1.02329e-02,1.11760e+01,1.06530e+01,1.04713e-02,1.04314e+01,9.92116e+00,1.12254e-02,8.47730e+00,
8.00255e+00,1.17490e-02,7.40419e+00,6.95089e+00,1.25890e-02,6.03868e+00,5.61463e+00,1.25892e-02,6.03833e+00,5.61429e+00,
1.27350e-02,5.83733e+00,5.41800e+00,1.38038e-02,4.60181e+00,4.21291e+00,1.46218e-02,3.88986e+00,3.52021e+00,1.50287e-02,
3.59225e+00,3.23111e+00,1.58489e-02,3.08290e+00,2.73738e+00,1.58490e-02,3.08286e+00,2.73734e+00,1.60324e-02,2.98301e+00,
2.64081e+00,1.73780e-02,2.36964e+00,2.04900e+00,1.79887e-02,2.15030e+00,1.83802e+00,1.81970e-02,2.08226e+00,1.77265e+00,
1.92565e-02,1.78085e+00,1.48362e+00,1.99526e-02,1.61687e+00,1.32696e+00,1.99530e-02,1.61678e+00,1.32688e+00,2.04174e-02,
1.51957e+00,1.23443e+00,2.28621e-02,1.12807e+00,8.63738e-01,2.29087e-02,1.12219e+00,8.58210e-01,2.37137e-02,1.02797e+00,
7.69720e-01,2.42661e-02,9.70539e-01,7.15922e-01,2.51189e-02,8.91742e-01,6.42290e-01,2.51190e-02,8.91730e-01,6.42279e-01,
2.54097e-02,8.67190e-01,6.19521e-01,2.60625e-02,8.15679e-01,5.71816e-01,2.91743e-02,6.29492e-01,4.01168e-01,3.03448e-02,
5.78416e-01,3.54814e-01,3.16228e-02,5.31028e-01,3.12136e-01,3.16230e-02,5.31020e-01,3.12129e-01,3.34965e-02,4.73666e-01,
2.61477e-01,3.65717e-02,4.03024e-01,1.99877e-01,3.80189e-02,3.77263e-01,1.77812e-01,3.98107e-02,3.50395e-01,1.55014e-01,
3.98110e-02,3.50391e-01,1.55011e-01,4.03676e-02,3.42868e-01,1.48824e-01,4.57088e-02,2.87493e-01,1.04432e-01,4.73151e-02,
2.75323e-01,9.49431e-02,5.01187e-02,2.57600e-01,8.13685e-02,5.01190e-02,2.57598e-01,8.13674e-02,5.18800e-02,2.47992e-01,
7.44932e-02,5.31699e-02,2.41703e-01,7.00680e-02,5.62341e-02,2.28796e-01,6.12496e-02,6.16595e-02,2.11449e-01,4.99528e-02,
6.28437e-02,2.08372e-01,4.80306e-02,6.30957e-02,2.07741e-01,4.76419e-02,6.30960e-02,2.07740e-01,4.76415e-02,6.99842e-02,
1.92789e-01,3.96012e-02,7.16143e-02,1.89950e-01,3.81784e-02,7.58578e-02,1.83495e-01,3.50943e-02,7.94328e-02,1.78918e-01,
3.30484e-02,7.94330e-02,1.78918e-01,3.30483e-02,8.06852e-02,1.77354e-01,3.24824e-02,8.81049e-02,1.69401e-01,2.98609e-02,
9.12011e-02,1.66637e-01,2.90524e-02,1.00000e-01,1.60070e-01,2.73653e-02,1.02023e-01,1.58654e-01,2.71491e-02,1.04713e-01,
1.56873e-01,2.68974e-02,1.08393e-01,1.54616e-01,2.66091e-02,1.20226e-01,1.48477e-01,2.59927e-02,1.21619e-01,1.47847e-01,
2.59437e-02,1.25890e-01,1.46013e-01,2.58135e-02,1.25893e-01,1.46012e-01,2.58134e-02,1.27350e-01,1.45357e-01,2.58188e-02,
1.30412e-01,1.44031e-01,2.58342e-02,1.39637e-01,1.40392e-01,2.59013e-02,1.44544e-01,1.38648e-01,2.59437e-02,1.54882e-01,
1.35328e-01,2.60351e-02,1.58489e-01,1.34268e-01,2.60671e-02,1.58490e-01,1.34268e-01,2.60671e-02,1.62181e-01,1.33124e-01,
2.61816e-02,1.64059e-01,1.32559e-01,2.62370e-02,1.72530e-01,1.30151e-01,2.64641e-02,1.79887e-01,1.28218e-01,2.66333e-02,
1.86209e-01,1.26663e-01,2.67597e-02,1.90546e-01,1.25647e-01,2.68371e-02,1.94984e-01,1.24647e-01,2.69097e-02,1.99526e-01,
1.23663e-01,2.69768e-02,1.99530e-01,1.23662e-01,2.69769e-02,2.01837e-01,1.23132e-01,2.70482e-02,2.08930e-01,1.21562e-01,
2.72482e-02,2.23872e-01,1.18519e-01,2.75867e-02,2.29910e-01,1.17379e-01,2.76967e-02,2.34423e-01,1.16557e-01,2.77699e-02,
2.44193e-01,1.14860e-01,2.79046e-02,2.48313e-01,1.14175e-01,2.79525e-02,2.51189e-01,1.13707e-01,2.79831e-02,2.51190e-01,
1.13706e-01,2.79831e-02,2.57040e-01,1.12706e-01,2.81116e-02,2.60016e-01,1.12210e-01,2.81719e-02,2.63027e-01,1.11718e-01,
2.82294e-02,2.72270e-01,1.10258e-01,2.83860e-02,2.88403e-01,1.07880e-01,2.85961e-02,2.91743e-01,1.07413e-01,2.86308e-02,
2.98538e-01,1.06486e-01,2.86936e-02,3.00000e-01,1.06291e-01,2.87057e-02,3.16228e-01,1.04214e-01,2.88115e-02,3.16230e-01,
1.04214e-01,2.88115e-02,3.19889e-01,1.03736e-01,2.88625e-02,3.27341e-01,1.02790e-01,2.89560e-02,3.34965e-01,1.01853e-01,
2.90384e-02,3.54813e-01,9.95571e-02,2.91979e-02,3.63078e-01,9.86558e-02,2.92440e-02,3.71535e-01,9.77642e-02,2.92808e-02,
3.84592e-01,9.64442e-02,2.93187e-02,3.93550e-01,9.55756e-02,2.93331e-02,3.98107e-01,9.51447e-02,2.93371e-02,3.98110e-01,
9.51445e-02,2.93372e-02,4.02717e-01,9.46897e-02,2.93688e-02,4.02960e-01,9.46659e-02,2.93704e-02,4.12098e-01,9.37869e-02,
2.94239e-02,4.16869e-01,9.33391e-02,2.94475e-02,4.31519e-01,9.20099e-02,2.95023e-02,4.46684e-01,9.07017e-02,2.95348e-02,
4.51856e-01,9.02703e-02,2.95410e-02,4.73151e-01,8.85669e-02,2.95430e-02,4.89779e-01,8.73124e-02,2.95221e-02,4.95450e-01,
8.68986e-02,2.95112e-02,5.01187e-01,8.64869e-02,2.94983e-02,5.01190e-01,8.64867e-02,2.94983e-02,5.18800e-01,8.51946e-02,
2.95222e-02,5.30884e-01,8.43445e-02,2.95257e-02,5.37032e-01,8.39228e-02,2.95239e-02,5.43250e-01,8.35035e-02,2.95198e-02,
5.68853e-01,8.18481e-02,2.94813e-02,5.75440e-01,8.14397e-02,2.94664e-02,5.88844e-01,8.06293e-02,2.94305e-02,5.95662e-01,
8.02274e-02,2.94096e-02,6.23735e-01,7.86405e-02,2.93074e-02,6.30957e-01,7.82490e-02,2.92774e-02,6.30960e-01,7.82488e-02,
2.92774e-02,6.45654e-01,7.74305e-02,2.92539e-02,6.53131e-01,7.70246e-02,2.92388e-02,6.76083e-01,7.58202e-02,2.91806e-02,
6.83912e-01,7.54231e-02,2.91571e-02,6.99842e-01,7.46354e-02,2.91042e-02,7.07946e-01,7.42447e-02,2.90749e-02,7.32825e-01,
7.30853e-02,2.89759e-02,7.41310e-01,7.27030e-02,2.89394e-02,7.58578e-01,7.19447e-02,2.88614e-02,7.67362e-01,7.15685e-02,
2.88199e-02,7.94328e-01,7.04523e-02,2.86864e-02,7.94330e-01,7.04522e-02,2.86863e-02,8.03526e-01,7.00641e-02,2.86549e-02,
8.12831e-01,6.96782e-02,2.86216e-02,8.31764e-01,6.89127e-02,2.85492e-02,8.60994e-01,6.77807e-02,2.84273e-02,8.91251e-01,
6.66677e-02,2.82902e-02,8.91310e-01,6.66655e-02,2.82900e-02,9.22571e-01,6.55733e-02,2.81393e-02,9.54993e-01,6.44973e-02,
2.79754e-02,9.59020e-01,6.43675e-02,2.79546e-02,9.69110e-01,6.40456e-02,2.79021e-02,9.79300e-01,6.37256e-02,2.78485e-02,
9.89600e-01,6.34071e-02,2.77939e-02,9.94780e-01,6.32487e-02,2.77662e-02,1.00000e+00,6.30904e-02,2.77383e-02,1.00000e-03,
6.52543e+02,6.51619e+02,1.00191e-03,6.49201e+02,6.48285e+02,1.01046e-03,6.34570e+02,6.33695e+02,1.01732e-03,6.23131e+02,
6.22295e+02,1.02398e-03,6.12297e+02,6.11504e+02,1.02951e-03,6.03495e+02,6.02745e+02,1.03404e-03,5.96400e+02,5.95691e+02,
1.03514e-03,5.94684e+02,5.93987e+02,1.03720e-03,5.91518e+02,5.90841e+02,1.04064e-03,5.86257e+02,5.85616e+02,1.04567e-03,
5.78699e+02,5.78114e+02,1.04996e-03,5.72352e+02,5.71810e+02,1.05200e-03,5.69363e+02,5.68838e+02,1.05391e-03,5.66597e+02,
5.66085e+02,1.05553e-03,5.64276e+02,5.63772e+02,1.05677e-03,5.62497e+02,5.61997e+02,1.05803e-03,5.60705e+02,5.60207e+02,
1.05968e-03,5.58379e+02,5.57880e+02,1.06069e-03,5.56954e+02,5.56454e+02,1.06147e-03,5.55868e+02,5.55365e+02,1.06305e-03,
5.53664e+02,5.53153e+02,1.06398e-03,5.52376e+02,5.51859e+02,1.06400e-03,5.52349e+02,5.51831e+02,1.06400e-03,5.45030e+03,
5.35537e+03,1.06500e-03,5.62664e+03,5.52843e+03,1.06536e-03,5.68504e+03,5.58573e+03,1.06600e-03,5.78940e+03,5.68813e+03,
1.06675e-03,5.89620e+03,5.79288e+03,1.06750e-03,6.00488e+03,5.89948e+03,1.06777e-03,6.03890e+03,5.93288e+03,1.06880e-03,
6.16731e+03,6.05892e+03,1.07030e-03,6.33147e+03,6.22003e+03,1.07152e-03,6.44612e+03,6.33252e+03,1.07180e-03,6.47285e+03,
6.35875e+03,1.07338e-03,6.59579e+03,6.47949e+03,1.07400e-03,6.64451e+03,6.52734e+03,1.07630e-03,6.78635e+03,6.66663e+03,
1.07900e-03,6.91261e+03,6.79059e+03,1.08109e-03,6.98194e+03,6.85881e+03,1.08180e-03,7.00566e+03,6.88216e+03,1.08446e-03,
7.06015e+03,6.93583e+03,1.08550e-03,7.08156e+03,6.95692e+03,1.08663e-03,7.09082e+03,6.96608e+03,1.09000e-03,7.11862e+03,
6.99358e+03,1.09200e-03,7.11644e+03,6.99154e+03,1.09400e-03,7.11427e+03,6.98952e+03,1.09648e-03,7.09316e+03,6.96902e+03,
1.09775e-03,7.08237e+03,6.95854e+03,1.10000e-03,7.06335e+03,6.94008e+03,1.10002e-03,7.06302e+03,6.93975e+03,1.10401e-03,
7.00299e+03,6.88115e+03,1.10918e-03,6.92646e+03,6.80644e+03,1.11161e-03,6.88072e+03,6.76172e+03,1.11604e-03,6.79866e+03,
6.68148e+03,1.12181e-03,6.69358e+03,6.57874e+03,1.12798e-03,6.58351e+03,6.47111e+03,1.13271e-03,6.50086e+03,6.39029e+03,
1.13947e-03,6.38512e+03,6.27709e+03,1.14653e-03,6.26714e+03,6.16168e+03,1.14815e-03,6.24032e+03,6.13545e+03,1.15713e-03,
6.11324e+03,6.01123e+03,1.17300e-03,5.89722e+03,5.80002e+03,1.17607e-03,5.85982e+03,5.76346e+03,1.18850e-03,5.71184e+03,
5.61880e+03,1.19735e-03,5.60967e+03,5.51890e+03,1.21619e-03,5.40067e+03,5.31450e+03,1.22090e-03,5.35005e+03,5.26499e+03,
1.24144e-03,5.13707e+03,5.05661e+03,1.24451e-03,5.10623e+03,5.02643e+03,1.25890e-03,4.96100e+03,4.88426e+03,1.25892e-03,
4.96076e+03,4.88402e+03,1.26988e-03,4.85399e+03,4.77947e+03,1.28825e-03,4.68213e+03,4.61116e+03,1.30955e-03,4.49331e+03,
4.42619e+03,1.34478e-03,4.20358e+03,4.14223e+03,1.38038e-03,3.93672e+03,3.88056e+03,1.40000e-03,3.79975e+03,3.74619e+03,
1.40293e-03,3.77986e+03,3.72668e+03,1.44544e-03,3.50678e+03,3.45868e+03,1.45825e-03,3.42991e+03,3.38321e+03,1.50000e-03,
3.19520e+03,3.15271e+03,1.53895e-03,2.99381e+03,2.95482e+03,1.58489e-03,2.77827e+03,2.74295e+03,1.58490e-03,2.77824e+03,
2.74292e+03,1.62181e-03,2.62046e+03,2.58774e+03,1.64059e-03,2.54489e+03,2.51341e+03,1.65209e-03,2.50011e+03,2.46934e+03,
1.73000e-03,2.22388e+03,2.19745e+03,1.73780e-03,2.19780e+03,2.17177e+03,1.74854e-03,2.16260e+03,2.13710e+03,1.87866e-03,
1.79174e+03,1.77165e+03,1.88365e-03,1.77933e+03,1.75941e+03,1.90546e-03,1.72640e+03,1.70722e+03,1.99526e-03,1.53001e+03,
1.51351e+03,1.99530e-03,1.52994e+03,1.51343e+03,2.01798e-03,1.48527e+03,1.46936e+03,2.01837e-03,1.48452e+03,1.46861e+03,
2.04174e-03,1.44037e+03,1.42504e+03,2.18776e-03,1.19810e+03,1.18583e+03,2.23229e-03,1.13541e+03,1.12390e+03,2.23872e-03,
1.12673e+03,1.11532e+03,2.29087e-03,1.05961e+03,1.04899e+03,2.37137e-03,9.64682e+02,9.55154e+02,2.40529e-03,9.28171e+02,
9.19052e+02,2.51189e-03,8.25016e+02,8.17025e+02,2.51190e-03,8.25003e+02,8.17012e+02,2.57040e-03,7.74992e+02,7.67531e+02,
2.63027e-03,7.27973e+02,7.21001e+02,2.67503e-03,6.95341e+02,6.88702e+02,2.72270e-03,6.62750e+02,6.56441e+02,2.78612e-03,
6.21834e+02,6.15929e+02,2.95005e-03,5.30855e+02,5.25820e+02,3.01995e-03,4.97553e+02,4.92827e+02,3.09030e-03,4.66831e+02,
4.62386e+02,3.16228e-03,4.38011e+02,4.33824e+02,3.16230e-03,4.38002e+02,4.33816e+02,3.16267e-03,4.37860e+02,4.33675e+02,
3.19889e-03,4.24276e+02,4.20212e+02,3.27341e-03,3.97727e+02,3.93896e+02,3.49919e-03,3.29853e+02,3.26599e+02,3.54813e-03,
3.17248e+02,3.14100e+02,3.63078e-03,2.97396e+02,2.94412e+02,3.71535e-03,2.78791e+02,2.75958e+02,3.76142e-03,2.69189e+02,
2.66433e+02,3.84592e-03,2.52708e+02,2.50085e+02,3.98107e-03,2.29073e+02,2.26638e+02,3.98110e-03,2.29069e+02,2.26634e+02,
4.13756e-03,2.05299e+02,2.03050e+02,4.16869e-03,2.00972e+02,1.98757e+02,4.26579e-03,1.88235e+02,1.86121e+02,4.41570e-03,
1.70633e+02,1.68657e+02,4.51856e-03,1.59680e+02,1.57788e+02,4.60333e-03,1.51356e+02,1.49528e+02,4.89779e-03,1.26608e+02,
1.24974e+02,5.01187e-03,1.18485e+02,1.16914e+02,5.01190e-03,1.18483e+02,1.16913e+02,5.04171e-03,1.16477e+02,1.14922e+02,
5.30000e-03,1.00874e+02,9.94451e+01,5.30884e-03,1.00385e+02,9.89598e+01,5.40844e-03,9.50902e+01,9.37073e+01,5.75440e-03,
7.93715e+01,7.81196e+01,5.82103e-03,7.67545e+01,7.55247e+01,5.93576e-03,7.25116e+01,7.13176e+01,5.95662e-03,7.17743e+01,
7.05868e+01,6.23735e-03,6.27659e+01,6.16585e+01,6.30957e-03,6.06975e+01,5.96087e+01,6.30960e-03,6.06967e+01,5.96080e+01,
6.38263e-03,5.86976e+01,5.76271e+01,6.58875e-03,5.34547e+01,5.24320e+01,6.83912e-03,4.78986e+01,4.69299e+01,6.92820e-03,
4.61099e+01,4.51589e+01,7.07946e-03,4.32715e+01,4.23487e+01,7.33114e-03,3.90487e+01,3.81688e+01,7.41310e-03,3.77935e+01,
3.69270e+01,7.67362e-03,3.41480e+01,3.33213e+01,7.94328e-03,3.08219e+01,3.00320e+01,7.94330e-03,3.08217e+01,3.00318e+01,
8.13582e-03,2.87093e+01,2.79437e+01,8.22243e-03,2.78223e+01,2.70674e+01,8.41395e-03,2.59865e+01,2.52542e+01,8.81049e-03,
2.26745e+01,2.19840e+01,9.10115e-03,2.06003e+01,1.99370e+01,9.33254e-03,1.91281e+01,1.84854e+01,9.88553e-03,1.61133e+01,
1.55137e+01,1.00000e-02,1.55705e+01,1.49790e+01,1.01158e-02,1.50462e+01,1.44628e+01,1.04039e-02,1.38415e+01,1.32770e+01,
1.08393e-02,1.22561e+01,1.17182e+01,1.15000e-02,1.02886e+01,9.78547e+00,1.20226e-02,9.01361e+00,8.53411e+00,1.23027e-02,
8.41774e+00,7.94973e+00,1.25421e-02,7.95022e+00,7.49143e+00,1.25890e-02,7.86287e+00,7.40587e+00,1.25892e-02,7.86241e+00,
7.40542e+00,1.27350e-02,7.59877e+00,7.14741e+00,1.36458e-02,6.19775e+00,5.77772e+00,1.42889e-02,5.41515e+00,5.01388e+00,
1.46218e-02,5.05997e+00,4.66751e+00,1.50000e-02,4.69419e+00,4.31107e+00,1.58489e-02,3.99716e+00,3.63272e+00,1.58490e-02,
3.99711e+00,3.63267e+00,1.61129e-02,3.80985e+00,3.45087e+00,1.65959e-02,3.49762e+00,3.14818e+00,1.77828e-02,2.86910e+00,
2.54008e+00,1.79887e-02,2.77588e+00,2.45002e+00,1.81970e-02,2.68587e+00,2.36311e+00,1.84077e-02,2.59902e+00,2.27930e+00,
1.99526e-02,2.07060e+00,1.77046e+00,1.99530e-02,2.07049e+00,1.77035e+00,2.07912e-02,1.84707e+00,1.55633e+00,2.23872e-02,
1.51006e+00,1.23496e+00,2.26464e-02,1.46415e+00,1.19131e+00,2.29087e-02,1.41945e+00,1.14882e+00,2.47116e-02,1.16210e+00,
9.04922e-01,2.51189e-02,1.11399e+00,8.59570e-01,2.51190e-02,1.11397e+00,8.59555e-01,2.80719e-02,8.43312e-01,6.06784e-01,
2.85102e-02,8.12375e-01,5.78135e-01,2.88403e-02,7.90311e-01,5.57731e-01,2.91743e-02,7.69017e-01,5.38064e-01,3.16228e-02,
6.38794e-01,4.18314e-01,3.16230e-02,6.38784e-01,4.18305e-01,3.40302e-02,5.44705e-01,3.33361e-01,3.42768e-02,5.36519e-01,
3.26034e-01,3.67282e-02,4.66229e-01,2.63447e-01,3.71535e-02,4.55894e-01,2.54308e-01,3.83771e-02,4.28694e-01,2.30349e-01,
3.98107e-02,4.00878e-01,2.06107e-01,3.98110e-02,4.00873e-01,2.06103e-01,4.35652e-02,3.43558e-01,1.57711e-01,4.57088e-02,
3.18721e-01,1.37179e-01,4.67735e-02,3.08019e-01,1.28424e-01,4.73151e-02,3.02911e-01,1.24261e-01,5.01187e-02,2.79835e-01,
1.05654e-01,5.01190e-02,2.79833e-01,1.05652e-01,5.33455e-02,2.58384e-01,8.92960e-02,5.43250e-02,2.52793e-01,8.51322e-02,
6.02560e-02,2.25927e-01,6.56930e-02,6.19833e-02,2.19859e-01,6.14619e-02,6.30957e-02,2.16264e-01,5.89980e-02,6.30960e-02,
2.16264e-01,5.89975e-02,6.45654e-02,2.11681e-01,5.60936e-02,6.53131e-02,2.09487e-01,5.47197e-02,7.07946e-02,1.95847e-01,
4.64837e-02,7.32825e-02,1.90812e-01,4.35965e-02,7.49894e-02,1.87690e-01,4.18550e-02,7.87296e-02,1.81650e-01,3.86023e-02,
7.94328e-02,1.80618e-01,3.80654e-02,7.94330e-02,1.80617e-01,3.80653e-02,8.91251e-02,1.68251e-01,3.27982e-02,9.12011e-02,
1.66127e-01,3.19848e-02,1.00000e-01,1.58562e-01,2.93410e-02,1.00051e-01,1.58521e-01,2.93307e-02,1.05925e-01,1.54114e-01,
2.82890e-02,1.07152e-01,1.53276e-01,2.81066e-02,1.10918e-01,1.50859e-01,2.76084e-02,1.17490e-01,1.47126e-01,2.69285e-02,
1.24452e-01,1.43705e-01,2.63927e-02,1.25890e-01,1.43056e-01,2.63003e-02,1.25893e-01,1.43055e-01,2.63001e-02,1.26682e-01,
1.42673e-01,2.62751e-02,1.28825e-01,1.41662e-01,2.62127e-02,1.42889e-01,1.35866e-01,2.59483e-02,1.58489e-01,1.30716e-01,
2.58209e-02,1.58490e-01,1.30716e-01,2.58209e-02,1.60324e-01,1.30127e-01,2.58528e-02,1.62181e-01,1.29544e-01,2.58845e-02,
1.64059e-01,1.28967e-01,2.59158e-02,1.66956e-01,1.28102e-01,2.59625e-02,1.84077e-01,1.23500e-01,2.61992e-02,1.86209e-01,
1.22981e-01,2.62238e-02,1.90546e-01,1.21958e-01,2.62707e-02,1.99526e-01,1.19967e-01,2.63564e-02,1.99530e-01,1.19966e-01,
2.63565e-02,2.01837e-01,1.19436e-01,2.64138e-02,2.06538e-01,1.18387e-01,2.65231e-02,2.08930e-01,1.17869e-01,2.65749e-02,
2.23872e-01,1.14843e-01,2.68473e-02,2.26464e-01,1.14352e-01,2.68868e-02,2.29087e-01,1.13865e-01,2.69244e-02,2.34423e-01,
1.12900e-01,2.69944e-02,2.51189e-01,1.10083e-01,2.71630e-02,2.51190e-01,1.10083e-01,2.71631e-02,2.54097e-01,1.09589e-01,
2.72209e-02,2.60016e-01,1.08610e-01,2.73291e-02,2.69154e-01,1.07166e-01,2.74738e-02,2.78612e-01,1.05750e-01,2.75973e-02,
2.88403e-01,1.04360e-01,2.77005e-02,2.95121e-01,1.03447e-01,2.77584e-02,3.05492e-01,1.02099e-01,2.78301e-02,3.16228e-01,
1.00774e-01,2.78839e-02,3.16230e-01,1.00774e-01,2.78839e-02,3.19889e-01,1.00308e-01,2.79302e-02,3.31131e-01,9.89245e-02,
2.80530e-02,3.34965e-01,9.84689e-02,2.80888e-02,3.42768e-01,9.75653e-02,2.81530e-02,3.54813e-01,9.62291e-02,2.82311e-02,
3.63078e-01,9.53507e-02,2.82714e-02,3.66773e-01,9.49675e-02,2.82863e-02,3.67282e-01,9.49151e-02,2.82882e-02,3.80189e-01,
9.36227e-02,2.83260e-02,3.89045e-01,9.27728e-02,2.83406e-02,3.93550e-01,9.23512e-02,2.83450e-02,3.98107e-01,9.19319e-02,
2.83473e-02,3.98110e-01,9.19317e-02,2.83473e-02,4.07380e-01,9.10476e-02,2.84025e-02,4.21697e-01,8.97395e-02,2.84663e-02,
4.26580e-01,8.93083e-02,2.84825e-02,4.51856e-01,8.71868e-02,2.85285e-02,4.62381e-01,8.63543e-02,2.85315e-02,4.67735e-01,
8.59414e-02,2.85298e-02,4.95450e-01,8.39093e-02,2.84912e-02,5.01187e-01,8.35094e-02,2.84778e-02,5.01190e-01,8.35092e-02,
2.84778e-02,5.12861e-01,8.26748e-02,2.84955e-02,5.43250e-01,8.06275e-02,2.84985e-02,5.62341e-01,7.94256e-02,2.84740e-02,
5.88844e-01,7.78528e-02,2.84129e-02,5.95662e-01,7.74648e-02,2.83929e-02,6.16595e-01,7.63132e-02,2.83221e-02,6.30957e-01,
7.55556e-02,2.82663e-02,6.30960e-01,7.55555e-02,2.82663e-02,6.38264e-01,7.51586e-02,2.82557e-02,6.45654e-01,7.47637e-02,
2.82429e-02,6.53131e-01,7.43710e-02,2.82280e-02,6.68344e-01,7.35922e-02,2.81919e-02,6.91831e-01,7.24399e-02,2.81230e-02,
6.99842e-01,7.20600e-02,2.80962e-02,7.16143e-01,7.13065e-02,2.80373e-02,7.24436e-01,7.09328e-02,2.80052e-02,7.32825e-01,
7.05611e-02,2.79714e-02,7.49894e-01,6.98239e-02,2.78989e-02,7.58578e-01,6.94583e-02,2.78602e-02,7.76247e-01,6.87330e-02,
2.77783e-02,7.82979e-01,6.84630e-02,2.77460e-02,7.94328e-01,6.80156e-02,2.76905e-02,7.94330e-01,6.80155e-02,2.76905e-02,
8.03526e-01,6.76404e-02,2.76600e-02,8.12831e-01,6.72673e-02,2.76276e-02,8.22243e-01,6.68964e-02,2.75934e-02,8.41395e-01,
6.61609e-02,2.75198e-02,8.81049e-01,6.47146e-02,2.73525e-02,8.91251e-01,6.43581e-02,2.73067e-02,9.01571e-01,6.40037e-02,
2.72595e-02,9.22571e-01,6.33008e-02,2.71607e-02,9.54993e-01,6.22612e-02,2.70021e-02,9.88553e-01,6.12390e-02,2.68321e-02,
1.00000e+00,6.09022e-02,2.67730e-02,1.00000e-03,9.21031e+02,9.19398e+02,1.03198e-03,8.46965e+02,8.45388e+02,1.03514e-03,
8.40090e+02,8.38518e+02,1.04713e-03,8.14756e+02,8.13206e+02,1.05750e-03,7.93644e+02,7.92112e+02,1.07993e-03,7.50478e+02,
7.48987e+02,1.10643e-03,7.03518e+02,7.02078e+02,1.12632e-03,6.70904e+02,6.69505e+02,1.13501e-03,6.57295e+02,6.55916e+02,
1.14568e-03,6.40954e+02,6.39599e+02,1.15858e-03,6.21922e+02,6.20599e+02,1.17236e-03,6.02429e+02,6.01142e+02,1.18552e-03,
5.84590e+02,5.83341e+02,1.18850e-03,5.80651e+02,5.79411e+02,1.19893e-03,5.67179e+02,5.65972e+02,1.20919e-03,5.54329e+02,
5.53159e+02,1.21619e-03,5.45796e+02,5.44654e+02,1.22085e-03,5.40200e+02,5.39076e+02,1.23034e-03,5.29027e+02,5.27947e+02,
1.23915e-03,5.18937e+02,5.17905e+02,1.24638e-03,5.10849e+02,5.09863e+02,1.25270e-03,5.03909e+02,5.02969e+02,1.25804e-03,
4.98132e+02,4.97237e+02,1.25890e-03,4.97214e+02,4.96327e+02,1.25892e-03,4.97187e+02,4.96301e+02,1.26290e-03,4.92961e+02,
4.92111e+02,1.26769e-03,4.87923e+02,4.87121e+02,1.27536e-03,4.80002e+02,4.79272e+02,1.27852e-03,4.76792e+02,4.76086e+02,
1.28107e-03,4.74240e+02,4.73549e+02,1.28338e-03,4.71931e+02,4.71249e+02,1.28517e-03,4.70165e+02,4.69487e+02,1.28739e-03,
4.67992e+02,4.67314e+02,1.28901e-03,4.66417e+02,4.65737e+02,1.29029e-03,4.65171e+02,4.64487e+02,1.29139e-03,4.64116e+02,
4.63426e+02,1.29306e-03,4.62518e+02,4.61819e+02,1.29450e-03,4.61145e+02,4.60435e+02,1.29450e-03,5.63188e+03,5.49494e+03,
1.29602e-03,5.62085e+03,5.48431e+03,1.29862e-03,5.60212e+03,5.46626e+03,1.30170e-03,5.58012e+03,5.44504e+03,1.30317e-03,
5.56965e+03,5.43493e+03,1.31105e-03,5.51398e+03,5.38121e+03,1.31503e-03,5.48619e+03,5.35439e+03,1.31826e-03,5.46385e+03,
5.33282e+03,1.32089e-03,5.44574e+03,5.31535e+03,1.32402e-03,5.42431e+03,5.29467e+03,1.32742e-03,5.40122e+03,5.27238e+03,
1.33205e-03,5.37000e+03,5.24225e+03,1.33757e-03,5.33311e+03,5.20665e+03,1.34315e-03,5.29624e+03,5.17107e+03,1.34896e-03,
5.25828e+03,5.13444e+03,1.35284e-03,5.21922e+03,5.09661e+03,1.35873e-03,5.16069e+03,5.03992e+03,1.36426e-03,5.10649e+03,
4.98742e+03,1.37246e-03,5.02762e+03,4.91101e+03,1.38088e-03,4.94835e+03,4.83421e+03,1.39574e-03,4.81269e+03,4.70275e+03,
1.40443e-03,4.73570e+03,4.62811e+03,1.41254e-03,4.66540e+03,4.55996e+03,1.41659e-03,4.63077e+03,4.52638e+03,1.42862e-03,
4.53017e+03,4.42882e+03,1.44016e-03,4.43648e+03,4.33794e+03,1.45816e-03,4.29560e+03,4.20125e+03,1.47911e-03,4.13930e+03,
4.04954e+03,1.50000e-03,3.99589e+03,3.91032e+03,1.51383e-03,3.90467e+03,3.82174e+03,1.53109e-03,3.79487e+03,3.71509e+03,
1.54882e-03,3.68651e+03,3.60979e+03,1.55971e-03,3.62210e+03,3.54719e+03,1.58489e-03,3.47903e+03,3.40809e+03,1.58490e-03,
3.47899e+03,3.40805e+03,1.59763e-03,3.40968e+03,3.34065e+03,1.62181e-03,3.28322e+03,3.21761e+03,1.64369e-03,3.17439e+03,
3.11170e+03,1.71723e-03,2.84345e+03,2.78938e+03,1.73000e-03,2.79096e+03,2.73823e+03,1.73780e-03,2.75953e+03,2.70759e+03,
1.77828e-03,2.60414e+03,2.55607e+03,1.79290e-03,2.55101e+03,2.50424e+03,1.81970e-03,2.45751e+03,2.41302e+03,1.86209e-03,
2.31708e+03,2.27592e+03,1.90460e-03,2.18719e+03,2.14904e+03,1.99526e-03,1.94215e+03,1.90952e+03,1.99530e-03,1.94206e+03,
1.90942e+03,2.00000e-03,1.93042e+03,1.89804e+03,2.01837e-03,1.88582e+03,1.85442e+03,2.05845e-03,1.79335e+03,1.76393e+03,
2.06538e-03,1.77800e+03,1.74891e+03,2.08930e-03,1.72643e+03,1.69843e+03,2.16272e-03,1.57652e+03,1.55160e+03,2.18713e-03,
1.53068e+03,1.50667e+03,2.31740e-03,1.31467e+03,1.29487e+03,2.34423e-03,1.27545e+03,1.25638e+03,2.35193e-03,1.26450e+03,
1.24563e+03,2.39883e-03,1.20047e+03,1.18280e+03,2.40000e-03,1.19894e+03,1.18129e+03,2.51189e-03,1.06185e+03,1.04666e+03,
2.51190e-03,1.06184e+03,1.04665e+03,2.59881e-03,9.69842e+02,9.56241e+02,2.69154e-03,8.83370e+02,8.71217e+02,2.72270e-03,
8.56673e+02,8.44958e+02,2.75423e-03,8.30232e+02,8.18943e+02,2.78612e-03,8.04607e+02,7.93727e+02,2.86864e-03,7.43145e+02,
7.33227e+02,2.95121e-03,6.87897e+02,6.78822e+02,3.12608e-03,5.88145e+02,5.80537e+02,3.16228e-03,5.69992e+02,5.62643e+02,
3.16230e-03,5.69982e+02,5.62633e+02,3.23594e-03,5.35355e+02,5.28492e+02,3.23634e-03,5.35174e+02,5.28313e+02,3.27341e-03,
5.18834e+02,5.12201e+02,3.46737e-03,4.42337e+02,4.36733e+02,3.67282e-03,3.77145e+02,3.72378e+02,3.72233e-03,3.63409e+02,
3.58813e+02,3.80189e-03,3.42723e+02,3.38383e+02,3.84592e-03,3.31819e+02,3.27611e+02,3.98107e-03,3.01151e+02,2.97311e+02,
3.98110e-03,3.01145e+02,2.97305e+02,4.02491e-03,2.92034e+02,2.88301e+02,4.07380e-03,2.82301e+02,2.78682e+02,4.31519e-03,
2.40191e+02,2.37056e+02,4.31734e-03,2.39856e+02,2.36724e+02,4.46684e-03,2.17996e+02,2.15111e+02,4.51856e-03,2.10966e+02,
2.08159e+02,4.74475e-03,1.83586e+02,1.81077e+02,4.78630e-03,1.79088e+02,1.76628e+02,5.01187e-03,1.57100e+02,1.54876e+02,
5.01190e-03,1.57098e+02,1.54874e+02,5.06991e-03,1.52041e+02,1.49870e+02,5.11258e-03,1.48458e+02,1.46326e+02,5.24807e-03,
1.37811e+02,1.35792e+02,5.30884e-03,1.33372e+02,1.31399e+02,5.49232e-03,1.20928e+02,1.19086e+02,5.62341e-03,1.12980e+02,
1.11222e+02,6.02560e-03,9.25987e+01,9.10546e+01,6.08270e-03,9.01170e+01,8.85988e+01,6.16595e-03,8.66566e+01,8.51756e+01,
6.30957e-03,8.10974e+01,7.96760e+01,6.30960e-03,8.10964e+01,7.96750e+01,6.38263e-03,7.84537e+01,7.70607e+01,6.54958e-03,
7.27657e+01,7.14334e+01,6.60693e-03,7.09396e+01,6.96273e+01,7.14655e-03,5.64408e+01,5.52890e+01,7.16143e-03,5.61000e+01,
5.49521e+01,7.24436e-03,5.42501e+01,5.31236e+01,7.49894e-03,4.90610e+01,4.79950e+01,7.67362e-03,4.58826e+01,4.48539e+01,
7.76247e-03,4.43538e+01,4.33431e+01,7.93882e-03,4.15175e+01,4.05403e+01,7.94328e-03,4.14489e+01,4.04725e+01,7.94330e-03,
4.14486e+01,4.04722e+01,8.51138e-03,3.38319e+01,3.29515e+01,8.70964e-03,3.16193e+01,3.07675e+01,8.91251e-03,2.95521e+01,
2.87282e+01,9.33254e-03,2.58186e+01,2.50461e+01,9.64011e-03,2.34534e+01,2.27141e+01,1.00000e-02,2.10420e+01,2.03385e+01,
1.01158e-02,2.03376e+01,1.96448e+01,1.04713e-02,1.83633e+01,1.77013e+01,1.05925e-02,1.77494e+01,1.70972e+01,1.07907e-02,
1.68045e+01,1.61675e+01,1.12202e-02,1.49782e+01,1.43721e+01,1.15000e-02,1.39309e+01,1.33431e+01,1.21619e-02,1.17988e+01,
1.12491e+01,1.25674e-02,1.07064e+01,1.01772e+01,1.25890e-02,1.06523e+01,1.01241e+01,1.25892e-02,1.06516e+01,1.01235e+01,
1.27350e-02,1.02949e+01,9.77389e+00,1.28825e-02,9.95033e+00,9.43636e+00,1.38038e-02,8.11772e+00,7.64257e+00,1.42889e-02,
7.33564e+00,6.87800e+00,1.47911e-02,6.62426e+00,6.18299e+00,1.51608e-02,6.15965e+00,5.72942e+00,1.54882e-02,5.78476e+00,
5.36384e+00,1.58489e-02,5.40729e+00,4.99597e+00,1.58490e-02,5.40722e+00,4.99590e+00,1.64059e-02,4.88821e+00,4.49100e+00,
1.73780e-02,4.13607e+00,3.76043e+00,1.80000e-02,3.73758e+00,3.37402e+00,1.81970e-02,3.62155e+00,3.26158e+00,1.90546e-02,
3.17129e+00,2.82569e+00,1.99526e-02,2.78063e+00,2.44823e+00,1.99530e-02,2.78048e+00,2.44808e+00,2.00262e-02,2.75168e+00,
2.42033e+00,2.26464e-02,1.95073e+00,1.65131e+00,2.37137e-02,1.71847e+00,1.42931e+00,2.37899e-02,1.70350e+00,1.41502e+00,
2.39883e-02,1.66536e+00,1.37867e+00,2.51189e-02,1.47078e+00,1.19355e+00,2.51190e-02,1.47075e+00,1.19353e+00,2.79793e-02,
1.10919e+00,8.52422e-01,2.85102e-02,1.05747e+00,8.03975e-01,2.88403e-02,1.02722e+00,7.75674e-01,2.98538e-02,9.41970e-01,
6.96046e-01,3.16228e-02,8.18682e-01,5.81368e-01,3.16230e-02,8.18668e-01,5.81356e-01,3.42762e-02,6.78386e-01,4.52629e-01,
3.63078e-02,5.97192e-01,3.78960e-01,3.80189e-02,5.41781e-01,3.29042e-01,3.84592e-02,5.29004e-01,3.17572e-01,3.85806e-02,
5.25584e-01,3.14504e-01,3.98107e-02,4.93167e-01,2.85613e-01,3.98110e-02,4.93160e-01,2.85607e-01,4.43249e-02,4.02133e-01,
2.06534e-01,4.67735e-02,3.66463e-01,1.76173e-01,5.01187e-02,3.28328e-01,1.44192e-01,5.01190e-02,3.28325e-01,1.44189e-01,
5.12861e-02,3.17059e-01,1.35102e-01,5.35724e-02,2.97595e-01,1.19563e-01,5.88844e-02,2.62854e-01,9.26615e-02,6.23432e-02,
2.46035e-01,8.00570e-02,6.30957e-02,2.42824e-01,7.76978e-02,6.30960e-02,2.42823e-01,7.76969e-02,6.53131e-02,2.33884e-01,
7.15229e-02,6.68344e-02,2.28376e-01,6.77866e-02,7.49894e-02,2.05410e-01,5.28900e-02,7.84558e-02,1.98132e-01,4.84563e-02,
7.94328e-02,1.96275e-01,4.73563e-02,7.94330e-02,1.96275e-01,4.73561e-02,8.12830e-02,1.92799e-01,4.55082e-02,8.22243e-02,
1.91132e-01,4.46382e-02,9.33254e-02,1.75452e-01,3.70356e-02,9.77237e-02,1.70773e-01,3.50111e-02,1.00000e-01,1.68602e-01,
3.41164e-02,1.03211e-01,1.65589e-01,3.31164e-02,1.09648e-01,1.60286e-01,3.15039e-02,1.14815e-01,1.56629e-01,3.05010e-02,
1.20226e-01,1.53257e-01,2.96590e-02,1.23027e-01,1.51671e-01,2.92945e-02,1.24452e-01,1.50900e-01,2.91238e-02,1.25890e-01,
1.50145e-01,2.89608e-02,1.25893e-01,1.50143e-01,2.89605e-02,1.27350e-01,1.49339e-01,2.88478e-02,1.29599e-01,1.48141e-01,
2.86873e-02,1.33352e-01,1.46246e-01,2.84511e-02,1.46218e-01,1.40615e-01,2.78657e-02,1.53109e-01,1.38041e-01,2.76515e-02,
1.56675e-01,1.36808e-01,2.75621e-02,1.58489e-01,1.36204e-01,2.75206e-02,1.58490e-01,1.36204e-01,2.75206e-02,1.65959e-01,
1.33648e-01,2.75298e-02,1.70498e-01,1.32206e-01,2.75396e-02,1.73780e-01,1.31208e-01,2.75479e-02,1.86209e-01,1.27740e-01,
2.75815e-02,1.88365e-01,1.27183e-01,2.75871e-02,1.97242e-01,1.25011e-01,2.76095e-02,1.99526e-01,1.24482e-01,2.76144e-02,
1.99530e-01,1.24481e-01,2.76145e-02,2.00000e-01,1.24364e-01,2.76236e-02,2.08930e-01,1.22233e-01,2.77818e-02,2.21309e-01,
1.19530e-01,2.79593e-02,2.29087e-01,1.17962e-01,2.80502e-02,2.31740e-01,1.17448e-01,2.80776e-02,2.34423e-01,1.16938e-01,
2.81035e-02,2.36456e-01,1.16558e-01,2.81219e-02,2.48313e-01,1.14443e-01,2.82111e-02,2.51189e-01,1.13955e-01,2.82283e-02,
2.51190e-01,1.13955e-01,2.82284e-02,2.54097e-01,1.13434e-01,2.82808e-02,2.57040e-01,1.12917e-01,2.83313e-02,2.63027e-01,
1.11893e-01,2.84253e-02,2.69154e-01,1.10884e-01,2.85103e-02,2.75423e-01,1.09888e-01,2.85864e-02,2.81838e-01,1.08906e-01,
2.86538e-02,2.88403e-01,1.07936e-01,2.87128e-02,3.00000e-01,1.06306e-01,2.87957e-02,3.05492e-01,1.05568e-01,2.88260e-02,
3.09029e-01,1.05104e-01,2.88427e-02,3.16228e-01,1.04183e-01,2.88705e-02,3.16230e-01,1.04182e-01,2.88706e-02,3.27341e-01,
1.02729e-01,2.89956e-02,3.38844e-01,1.01303e-01,2.90979e-02,3.42768e-01,1.00834e-01,2.91271e-02,3.61286e-01,9.87222e-02,
2.92300e-02,3.63078e-01,9.85265e-02,2.92372e-02,3.71535e-01,9.76223e-02,2.92657e-02,3.75837e-01,9.71741e-02,2.92767e-02,
3.80189e-01,9.67284e-02,2.92856e-02,3.98107e-01,9.49707e-02,2.93008e-02,3.98110e-01,9.49705e-02,2.93009e-02,4.02717e-01,
9.45104e-02,2.93292e-02,4.07380e-01,9.40528e-02,2.93551e-02,4.16869e-01,9.31454e-02,2.93989e-02,4.21697e-01,9.26955e-02,
2.94170e-02,4.36516e-01,9.13611e-02,2.94566e-02,4.46684e-01,9.04838e-02,2.94711e-02,4.62381e-01,8.91863e-02,2.94764e-02,
4.67735e-01,8.87586e-02,2.94739e-02,4.69580e-01,8.86128e-02,2.94725e-02,4.89779e-01,8.70706e-02,2.94431e-02,4.95450e-01,
8.66543e-02,2.94306e-02,5.01187e-01,8.62404e-02,2.94162e-02,5.01190e-01,8.62402e-02,2.94162e-02,5.06991e-01,8.58073e-02,
2.94261e-02,5.12861e-01,8.53766e-02,2.94335e-02,5.37032e-01,8.36775e-02,2.94389e-02,5.43250e-01,8.32587e-02,2.94345e-02,
5.49541e-01,8.28421e-02,2.94279e-02,5.55904e-01,8.24277e-02,2.94192e-02,5.62341e-01,8.20156e-02,2.94083e-02,5.88844e-01,
8.03895e-02,2.93442e-02,5.95662e-01,7.99886e-02,2.93234e-02,6.09537e-01,7.91930e-02,2.92762e-02,6.30957e-01,7.80156e-02,
2.91919e-02,6.30960e-01,7.80154e-02,2.91919e-02,6.45654e-01,7.71963e-02,2.91668e-02,6.60694e-01,7.63862e-02,2.91331e-02,
6.68344e-01,7.59845e-02,2.91130e-02,6.99842e-01,7.43999e-02,2.90128e-02,7.16143e-01,7.36207e-02,2.89514e-02,7.24436e-01,
7.32343e-02,2.89179e-02,7.33267e-01,7.28300e-02,2.88809e-02,7.58578e-01,7.17099e-02,2.87672e-02,7.67362e-01,7.13340e-02,
2.87254e-02,7.85236e-01,7.05884e-02,2.86374e-02,7.94328e-01,7.02186e-02,2.85911e-02,7.94330e-01,7.02186e-02,2.85911e-02,
8.22243e-01,6.90622e-02,2.84903e-02,8.41395e-01,6.83022e-02,2.84140e-02,8.51138e-01,6.79254e-02,2.83732e-02,8.60994e-01,
6.75508e-02,2.83307e-02,8.91251e-01,6.64397e-02,2.81934e-02,9.12011e-01,6.57095e-02,2.80941e-02,9.22571e-01,6.53475e-02,
2.80422e-02,9.33254e-01,6.49875e-02,2.79890e-02,9.44061e-01,6.46296e-02,2.79343e-02,9.66051e-01,6.39198e-02,2.78210e-02,
1.00000e+00,6.28701e-02,2.76415e-02,1.00000e-03,1.18402e+03,1.18219e+03,1.01158e-03,1.14896e+03,1.14714e+03,1.03514e-03,
1.08082e+03,1.07903e+03,1.04713e-03,1.04832e+03,1.04654e+03,1.06040e-03,1.01387e+03,1.01210e+03,1.09648e-03,9.27708e+02,
9.25980e+02,1.10419e-03,9.10689e+02,9.08968e+02,1.14815e-03,8.21400e+02,8.19728e+02,1.14873e-03,8.20322e+02,8.18651e+02,
1.16145e-03,7.96849e+02,7.95192e+02,1.19058e-03,7.45734e+02,7.44110e+02,1.20226e-03,7.26507e+02,7.24898e+02,1.23039e-03,
6.82881e+02,6.81305e+02,1.24451e-03,6.62327e+02,6.60769e+02,1.25890e-03,6.42326e+02,6.40787e+02,1.25892e-03,6.42292e+02,
6.40753e+02,1.26865e-03,6.29242e+02,6.27715e+02,1.30065e-03,5.88775e+02,5.87291e+02,1.30317e-03,5.85744e+02,5.84264e+02,
1.31826e-03,5.68066e+02,5.66609e+02,1.32969e-03,5.55029e+02,5.53589e+02,1.33352e-03,5.50750e+02,5.49316e+02,1.35707e-03,
5.25337e+02,5.23942e+02,1.38038e-03,5.01729e+02,5.00377e+02,1.39637e-03,4.86359e+02,4.85040e+02,1.40140e-03,4.81657e+02,
4.80348e+02,1.41508e-03,4.69183e+02,4.67904e+02,1.42866e-03,4.57230e+02,4.55984e+02,1.42889e-03,4.57028e+02,4.55783e+02,
1.44303e-03,4.45071e+02,4.43865e+02,1.45465e-03,4.35547e+02,4.34376e+02,1.46428e-03,4.27868e+02,4.26728e+02,1.47325e-03,
4.20875e+02,4.19769e+02,1.48190e-03,4.14274e+02,4.13204e+02,1.49115e-03,4.07369e+02,4.06343e+02,1.49886e-03,4.01719e+02,
4.00737e+02,1.50521e-03,3.97140e+02,3.96199e+02,1.51094e-03,3.93069e+02,3.92171e+02,1.51356e-03,3.91223e+02,3.90345e+02,
1.51742e-03,3.88493e+02,3.87645e+02,1.52531e-03,3.82988e+02,3.82199e+02,1.52953e-03,3.80091e+02,3.79328e+02,1.53304e-03,
3.77711e+02,3.76965e+02,1.53572e-03,3.75908e+02,3.75171e+02,1.53818e-03,3.74269e+02,3.73537e+02,1.54021e-03,3.72925e+02,
3.72194e+02,1.54190e-03,3.71817e+02,3.71085e+02,1.54332e-03,3.70884e+02,3.70151e+02,1.54660e-03,3.68761e+02,3.68018e+02,
1.54934e-03,3.66999e+02,3.66242e+02,1.54990e-03,3.66641e+02,3.65881e+02,1.54990e-03,4.23580e+03,4.10185e+03,1.55153e-03,
4.22710e+03,4.09354e+03,1.55463e-03,4.21071e+03,4.07789e+03,1.55845e-03,4.19058e+03,4.05868e+03,1.56675e-03,4.14741e+03,
4.01743e+03,1.57180e-03,4.12147e+03,3.99263e+03,1.57476e-03,4.10640e+03,3.97822e+03,1.57820e-03,4.08898e+03,3.96157e+03,
1.58219e-03,4.06895e+03,3.94241e+03,1.58489e-03,4.05541e+03,3.92948e+03,1.58490e-03,4.05538e+03,3.92944e+03,1.58566e-03,
4.05161e+03,3.92584e+03,1.58957e-03,4.03217e+03,3.90726e+03,1.59500e-03,4.00548e+03,3.88174e+03,1.59956e-03,3.97769e+03,
3.85510e+03,1.60325e-03,3.95545e+03,3.83378e+03,1.60526e-03,3.94333e+03,3.82216e+03,1.61181e-03,3.90440e+03,3.78484e+03,
1.61875e-03,3.86370e+03,3.74582e+03,1.62181e-03,3.84597e+03,3.72882e+03,1.62781e-03,3.81151e+03,3.69577e+03,1.63750e-03,
3.75676e+03,3.64327e+03,1.64791e-03,3.69916e+03,3.58802e+03,1.65893e-03,3.63955e+03,3.53083e+03,1.66915e-03,3.58544e+03,
3.47890e+03,1.67000e-03,3.58099e+03,3.47463e+03,1.68198e-03,3.51552e+03,3.41178e+03,1.70623e-03,3.38795e+03,3.28925e+03,
1.72398e-03,3.29861e+03,3.20341e+03,1.73780e-03,3.23130e+03,3.13870e+03,1.75257e-03,3.16138e+03,3.07147e+03,1.77828e-03,
3.04457e+03,2.95911e+03,1.79176e-03,2.98572e+03,2.90248e+03,1.81970e-03,2.86866e+03,2.78978e+03,1.83488e-03,2.80884e+03,
2.73217e+03,1.84077e-03,2.78608e+03,2.71026e+03,1.86209e-03,2.70589e+03,2.63300e+03,1.88094e-03,2.63764e+03,2.56722e+03,
1.94879e-03,2.41094e+03,2.34855e+03,1.99526e-03,2.27109e+03,2.21351e+03,1.99530e-03,2.27098e+03,2.21340e+03,2.00000e-03,
2.25747e+03,2.20036e+03,2.01497e-03,2.21516e+03,2.15947e+03,2.01837e-03,2.20571e+03,2.15034e+03,2.06538e-03,2.08049e+03,
2.02929e+03,2.08799e-03,2.02380e+03,1.97446e+03,2.10000e-03,1.99455e+03,1.94616e+03,2.13796e-03,1.90590e+03,1.86035e+03,
2.18776e-03,1.79773e+03,1.75560e+03,2.20575e-03,1.76077e+03,1.71978e+03,2.23872e-03,1.69573e+03,1.65674e+03,2.31740e-03,
1.55167e+03,1.51697e+03,2.32755e-03,1.53432e+03,1.50013e+03,2.34423e-03,1.50638e+03,1.47301e+03,2.39883e-03,1.41973e+03,
1.38884e+03,2.43604e-03,1.36461e+03,1.33528e+03,2.48230e-03,1.30015e+03,1.27261e+03,2.48313e-03,1.29903e+03,1.27152e+03,
2.51189e-03,1.26112e+03,1.23465e+03,2.51190e-03,1.26110e+03,1.23463e+03,2.54097e-03,1.22327e+03,1.19781e+03,2.64652e-03,
1.09838e+03,1.07619e+03,2.66073e-03,1.08293e+03,1.06114e+03,2.72270e-03,1.01888e+03,9.98712e+02,2.78612e-03,9.58616e+02,
9.39937e+02,2.85102e-03,9.01927e+02,8.84621e+02,2.86365e-03,8.91437e+02,8.74382e+02,2.88403e-03,8.74852e+02,8.58192e+02,
2.95121e-03,8.23122e+02,8.07681e+02,3.01995e-03,7.74461e+02,7.60142e+02,3.09030e-03,7.27861e+02,7.14588e+02,3.15477e-03,
6.88435e+02,6.76029e+02,3.16228e-03,6.84034e+02,6.71724e+02,3.16230e-03,6.84021e+02,6.71711e+02,3.19889e-03,6.63121e+02,
6.51264e+02,3.31131e-03,6.04146e+02,5.93539e+02,3.38844e-03,5.67779e+02,5.57923e+02,3.40000e-03,5.62591e+02,5.52840e+02,
3.42029e-03,5.53500e+02,5.43933e+02,3.46737e-03,5.33161e+02,5.24002e+02,3.58922e-03,4.85057e+02,4.76844e+02,3.75710e-03,
4.27970e+02,4.20839e+02,3.75837e-03,4.27574e+02,4.20450e+02,3.89045e-03,3.88984e+02,3.82569e+02,3.93550e-03,3.76913e+02,
3.70715e+02,3.98107e-03,3.65217e+02,3.59228e+02,3.98110e-03,3.65210e+02,3.59221e+02,4.02717e-03,3.53885e+02,3.48097e+02,
4.07380e-03,3.42708e+02,3.37113e+02,4.15879e-03,3.23543e+02,3.18277e+02,4.21696e-03,3.11256e+02,3.06200e+02,4.41570e-03,
2.73747e+02,2.69314e+02,4.57088e-03,2.48621e+02,2.44591e+02,4.59113e-03,2.45578e+02,2.41596e+02,4.62381e-03,2.40770e+02,
2.36865e+02,4.78630e-03,2.18678e+02,2.15118e+02,4.84172e-03,2.11776e+02,2.08323e+02,4.94420e-03,1.99594e+02,1.96325e+02,
4.95450e-03,1.98423e+02,1.95171e+02,5.01187e-03,1.92061e+02,1.88905e+02,5.01190e-03,1.92058e+02,1.88902e+02,5.18800e-03,
1.74177e+02,1.71287e+02,5.30884e-03,1.63192e+02,1.60463e+02,5.37032e-03,1.57964e+02,1.55310e+02,5.43250e-03,1.52904e+02,
1.50323e+02,5.51382e-03,1.46613e+02,1.44122e+02,5.62341e-03,1.38678e+02,1.36300e+02,5.75440e-03,1.29940e+02,1.27686e+02,
5.82103e-03,1.25725e+02,1.23530e+02,6.09537e-03,1.10184e+02,1.08203e+02,6.11177e-03,1.09339e+02,1.07369e+02,6.23735e-03,
1.03150e+02,1.01267e+02,6.30957e-03,9.98050e+01,9.79674e+01,6.30960e-03,9.98038e+01,9.79662e+01,6.45654e-03,9.34377e+01,
9.16874e+01,6.60693e-03,8.74788e+01,8.58096e+01,6.77902e-03,8.12756e+01,7.96902e+01,6.83912e-03,7.92494e+01,7.76919e+01,
6.91831e-03,7.66507e+01,7.51287e+01,7.16143e-03,6.93522e+01,6.79293e+01,7.30065e-03,6.55917e+01,6.42197e+01,7.32824e-03,
6.48791e+01,6.35169e+01,7.41310e-03,6.27522e+01,6.14194e+01,7.67362e-03,5.67836e+01,5.55331e+01,7.76247e-03,5.49239e+01,
5.36991e+01,7.84671e-03,5.32363e+01,5.20348e+01,7.94328e-03,5.13863e+01,5.02108e+01,7.94330e-03,5.13860e+01,5.02105e+01,
8.12830e-03,4.80777e+01,4.69490e+01,8.22243e-03,4.64863e+01,4.53800e+01,8.40611e-03,4.35772e+01,4.25119e+01,8.41395e-03,
4.34586e+01,4.23951e+01,8.60994e-03,4.06287e+01,3.96062e+01,8.81049e-03,3.79849e+01,3.70009e+01,9.12011e-03,3.43411e+01,
3.34106e+01,9.20207e-03,3.34561e+01,3.25388e+01,9.22571e-03,3.32065e+01,3.22930e+01,9.77237e-03,2.80758e+01,2.72413e+01,
9.80000e-03,2.78457e+01,2.70147e+01,1.00000e-02,2.62358e+01,2.54299e+01,1.01963e-02,2.47753e+01,2.39925e+01,1.02329e-02,
2.45152e+01,2.37366e+01,1.05925e-02,2.21451e+01,2.14057e+01,1.08393e-02,2.06954e+01,1.99804e+01,1.09648e-02,2.00070e+01,
1.93038e+01,1.14744e-02,1.75102e+01,1.68501e+01,1.17490e-02,1.63376e+01,1.56988e+01,1.18850e-02,1.57956e+01,1.51667e+01,
1.20226e-02,1.52661e+01,1.46469e+01,1.23027e-02,1.42607e+01,1.36602e+01,1.25890e-02,1.33236e+01,1.27407e+01,1.25892e-02,
1.33228e+01,1.27399e+01,1.28825e-02,1.24474e+01,1.18817e+01,1.30235e-02,1.20542e+01,1.14962e+01,1.30317e-02,1.20320e+01,
1.14745e+01,1.33352e-02,1.12428e+01,1.07015e+01,1.41254e-02,9.49345e+00,8.98942e+00,1.46218e-02,8.57984e+00,8.09603e+00,
1.50000e-02,7.95654e+00,7.48679e+00,1.53584e-02,7.42190e+00,6.96448e+00,1.56675e-02,6.99933e+00,6.55205e+00,1.58489e-02,
6.76664e+00,6.32504e+00,1.58490e-02,6.76656e+00,6.32495e+00,1.60324e-02,6.54181e+00,6.10591e+00,1.65959e-02,5.91265e+00,
5.49306e+00,1.71791e-02,5.34618e+00,4.94182e+00,1.81970e-02,4.52406e+00,4.14285e+00,1.84077e-02,4.37470e+00,3.99782e+00,
1.88365e-02,4.09136e+00,3.72285e+00,1.90546e-02,3.95702e+00,3.59255e+00,1.92261e-02,3.85573e+00,3.49435e+00,1.99526e-02,
3.46446e+00,3.11549e+00,1.99530e-02,3.46427e+00,3.11531e+00,2.11349e-02,2.93820e+00,2.60751e+00,2.13796e-02,2.84356e+00,
2.51629e+00,2.21309e-02,2.57884e+00,2.26141e+00,2.31740e-02,2.26669e+00,1.96143e+00,2.34423e-02,2.19463e+00,1.89224e+00,
2.43625e-02,1.97136e+00,1.67818e+00,2.45471e-02,1.93059e+00,1.63917e+00,2.51189e-02,1.81187e+00,1.52570e+00,2.51190e-02,
1.81185e+00,1.52567e+00,2.63027e-02,1.59785e+00,1.32201e+00,2.91743e-02,1.21366e+00,9.58136e-01,2.92154e-02,1.20923e+00,
9.53956e-01,2.95121e-02,1.17798e+00,9.24539e-01,3.16228e-02,9.86971e-01,7.45126e-01,3.16230e-02,9.86954e-01,7.45110e-01,
3.31131e-02,8.80070e-01,6.45691e-01,3.38844e-02,8.32003e-01,6.01139e-01,3.47745e-02,7.81792e-01,5.54723e-01,3.54813e-02,
7.45411e-01,5.21243e-01,3.71535e-02,6.70130e-01,4.52226e-01,3.84592e-02,6.20234e-01,4.06704e-01,3.92545e-02,5.92865e-01,
3.81802e-01,3.98107e-02,5.74975e-01,3.65611e-01,3.98110e-02,5.74966e-01,3.65604e-01,4.21696e-02,5.08798e-01,3.06623e-01,
4.64630e-02,4.20418e-01,2.28882e-01,4.73151e-02,4.06519e-01,2.16822e-01,5.01187e-02,3.67201e-01,1.82970e-01,5.01190e-02,
3.67198e-01,1.82967e-01,5.12861e-02,3.53067e-01,1.71157e-01,5.39753e-02,3.24780e-01,1.47736e-01,5.43250e-02,3.21486e-01,
1.45045e-01,5.49541e-02,3.15765e-01,1.40383e-01,5.55904e-02,3.10234e-01,1.35893e-01,5.75440e-02,2.94725e-01,1.23394e-01,
5.95662e-02,2.80709e-01,1.12230e-01,6.30957e-02,2.60265e-01,9.62128e-02,6.30960e-02,2.60263e-01,9.62118e-02,6.33913e-02,
2.58716e-01,9.50571e-02,6.60693e-02,2.45812e-01,8.55657e-02,7.07946e-02,2.27289e-01,7.23080e-02,7.58578e-02,2.11978e-01,
6.17782e-02,7.67362e-02,2.09694e-01,6.02478e-02,7.93151e-02,2.03516e-01,5.61684e-02,7.94328e-02,2.03250e-01,5.59956e-02,
7.94330e-02,2.03250e-01,5.59954e-02,8.22243e-02,1.97081e-01,5.23179e-02,8.51138e-02,1.91425e-01,4.90477e-02,8.81049e-02,
1.86233e-01,4.61412e-02,8.91251e-02,1.84598e-01,4.52463e-02,9.22571e-02,1.79955e-01,4.27638e-02,9.33254e-02,1.78491e-01,
4.19996e-02,1.00000e-01,1.70483e-01,3.79987e-02,1.04713e-01,1.65518e-01,3.59752e-02,1.05925e-01,1.64346e-01,3.55193e-02,
1.09648e-01,1.60990e-01,3.42593e-02,1.12202e-01,1.58879e-01,3.35021e-02,1.17490e-01,1.54932e-01,3.21635e-02,1.23027e-01,
1.51322e-01,3.10380e-02,1.24452e-01,1.50466e-01,3.07844e-02,1.25890e-01,1.49629e-01,3.05415e-02,1.25893e-01,1.49628e-01,
3.05411e-02,1.27350e-01,1.48744e-01,3.03497e-02,1.30317e-01,1.47025e-01,2.99921e-02,1.30551e-01,1.46894e-01,2.99655e-02,
1.39637e-01,1.42218e-01,2.90941e-02,1.42889e-01,1.40725e-01,2.88451e-02,1.44544e-01,1.39997e-01,2.87287e-02,1.46218e-01,
1.39281e-01,2.86174e-02,1.50000e-01,1.37734e-01,2.83875e-02,1.58489e-01,1.34576e-01,2.79619e-02,1.58490e-01,1.34576e-01,
2.79619e-02,1.60324e-01,1.33890e-01,2.79228e-02,1.62181e-01,1.33213e-01,2.78861e-02,1.64059e-01,1.32547e-01,2.78530e-02,
1.65959e-01,1.31890e-01,2.78218e-02,1.69824e-01,1.30601e-01,2.77646e-02,1.71684e-01,1.30003e-01,2.77398e-02,1.73780e-01,
1.29343e-01,2.77136e-02,1.86209e-01,1.25749e-01,2.75896e-02,1.88365e-01,1.25175e-01,2.75721e-02,1.90546e-01,1.24607e-01,
2.75553e-02,1.94984e-01,1.23490e-01,2.75235e-02,1.99526e-01,1.22399e-01,2.74955e-02,1.99530e-01,1.22398e-01,2.74956e-02,
2.08930e-01,1.20108e-01,2.75899e-02,2.11349e-01,1.19549e-01,2.76116e-02,2.13796e-01,1.18995e-01,2.76324e-02,2.29910e-01,
1.15619e-01,2.77438e-02,2.31740e-01,1.15262e-01,2.77540e-02,2.34423e-01,1.14748e-01,2.77681e-02,2.34943e-01,1.14650e-01,
2.77707e-02,2.37137e-01,1.14238e-01,2.77811e-02,2.48313e-01,1.12239e-01,2.78227e-02,2.51189e-01,1.11749e-01,2.78305e-02,
2.51190e-01,1.11749e-01,2.78305e-02,2.57040e-01,1.10707e-01,2.79130e-02,2.60016e-01,1.10192e-01,2.79513e-02,2.63027e-01,
1.09682e-01,2.79877e-02,2.66073e-01,1.09175e-01,2.80226e-02,2.81838e-01,1.06698e-01,2.81685e-02,2.85102e-01,1.06213e-01,
2.81921e-02,2.91743e-01,1.05254e-01,2.82339e-02,2.95121e-01,1.04779e-01,2.82521e-02,2.98538e-01,1.04308e-01,2.82686e-02,
3.01995e-01,1.03840e-01,2.82836e-02,3.09029e-01,1.02914e-01,2.83086e-02,3.12608e-01,1.02455e-01,2.83185e-02,3.16228e-01,
1.02000e-01,2.83268e-02,3.16230e-01,1.02000e-01,2.83268e-02,3.23594e-01,1.01037e-01,2.84025e-02,3.27341e-01,1.00560e-01,
2.84368e-02,3.34965e-01,9.96160e-02,2.84981e-02,3.38844e-01,9.91483e-02,2.85253e-02,3.42768e-01,9.86839e-02,2.85504e-02,
3.49453e-01,9.79113e-02,2.85876e-02,3.59090e-01,9.68360e-02,2.86295e-02,3.63078e-01,9.64039e-02,2.86431e-02,3.71535e-01,
9.55112e-02,2.86655e-02,3.75837e-01,9.50689e-02,2.86736e-02,3.93550e-01,9.33263e-02,2.86875e-02,3.98107e-01,9.28970e-02,
2.86862e-02,3.98110e-01,9.28967e-02,2.86863e-02,4.02717e-01,9.24441e-02,2.87118e-02,4.16869e-01,9.11014e-02,2.87736e-02,
4.26580e-01,9.02197e-02,2.88030e-02,4.36516e-01,8.93482e-02,2.88231e-02,4.41570e-01,8.89161e-02,2.88298e-02,4.46684e-01,
8.84866e-02,2.88342e-02,4.57088e-01,8.76348e-02,2.88368e-02,4.62381e-01,8.72126e-02,2.88351e-02,4.73151e-01,8.63754e-02,
2.88256e-02,4.79510e-01,8.58943e-02,2.88165e-02,4.84172e-01,8.55475e-02,2.88083e-02,4.89779e-01,8.51370e-02,2.87968e-02,
5.01187e-01,8.43227e-02,2.87683e-02,5.01190e-01,8.43225e-02,2.87683e-02,5.06991e-01,8.38958e-02,2.87760e-02,5.12861e-01,
8.34713e-02,2.87813e-02,5.24808e-01,8.26294e-02,2.87849e-02,5.30884e-01,8.22121e-02,2.87832e-02,5.37032e-01,8.17970e-02,
2.87794e-02,5.49541e-01,8.09739e-02,2.87651e-02,5.55904e-01,8.05659e-02,2.87549e-02,5.75440e-01,7.93554e-02,2.87122e-02,
5.82103e-01,7.89563e-02,2.86941e-02,5.88844e-01,7.85594e-02,2.86741e-02,5.95662e-01,7.81648e-02,2.86522e-02,6.02560e-01,
7.77722e-02,2.86286e-02,6.09537e-01,7.73819e-02,2.86032e-02,6.30957e-01,7.62237e-02,2.85169e-02,6.30960e-01,7.62236e-02,
2.85169e-02,6.38264e-01,7.58212e-02,2.85052e-02,6.45654e-01,7.54210e-02,2.84913e-02,6.53131e-01,7.50231e-02,2.84753e-02,
6.58819e-01,7.47248e-02,2.84619e-02,6.60694e-01,7.46274e-02,2.84573e-02,6.68344e-01,7.42339e-02,2.84372e-02,6.91831e-01,
7.30668e-02,2.83653e-02,6.99842e-01,7.26821e-02,2.83376e-02,7.07946e-01,7.22995e-02,2.83080e-02,7.24436e-01,7.15408e-02,
2.82436e-02,7.32825e-01,7.11646e-02,2.82089e-02,7.58578e-01,7.00486e-02,2.80950e-02,7.67362e-01,6.96807e-02,2.80539e-02,
7.85236e-01,6.89509e-02,2.79673e-02,7.94328e-01,6.85891e-02,2.79218e-02,7.94330e-01,6.85891e-02,2.79218e-02,8.00000e-01,
6.83544e-02,2.79027e-02,8.22243e-01,6.74573e-02,2.78224e-02,8.31764e-01,6.70843e-02,2.77856e-02,8.41395e-01,6.67135e-02,
2.77471e-02,8.51138e-01,6.63449e-02,2.77069e-02,8.60994e-01,6.59783e-02,2.76651e-02,8.70964e-01,6.56139e-02,2.76217e-02,
8.91251e-01,6.48912e-02,2.75302e-02,9.01571e-01,6.45330e-02,2.74822e-02,9.12011e-01,6.41768e-02,2.74327e-02,9.22571e-01,
6.38227e-02,2.73818e-02,9.44061e-01,6.31204e-02,2.72759e-02,9.54993e-01,6.27723e-02,2.72210e-02,9.66051e-01,6.24262e-02,
2.71648e-02,9.77237e-01,6.20820e-02,2.71074e-02,1.00000e+00,6.13995e-02,2.69889e-02,1.00000e-03,1.56818e+03,1.56598e+03,
1.04713e-03,1.38983e+03,1.38768e+03,1.08393e-03,1.26886e+03,1.26675e+03,1.09372e-03,1.23909e+03,1.23698e+03,1.09648e-03,
1.23087e+03,1.22877e+03,1.13501e-03,1.12373e+03,1.12167e+03,1.14152e-03,1.10687e+03,1.10481e+03,1.18850e-03,9.94841e+02,
9.92830e+02,1.23027e-03,9.07531e+02,9.05562e+02,1.24451e-03,8.80217e+02,8.78263e+02,1.25890e-03,8.53721e+02,8.51781e+02,
1.25892e-03,8.53676e+02,8.51736e+02,1.27350e-03,8.27935e+02,8.26008e+02,1.28502e-03,8.08370e+02,8.06454e+02,1.30317e-03,
7.78820e+02,7.76923e+02,1.34074e-03,7.21981e+02,7.20120e+02,1.35000e-03,7.08848e+02,7.06997e+02,1.39298e-03,6.51657e+02,
6.49851e+02,1.41254e-03,6.27723e+02,6.25939e+02,1.43894e-03,5.97370e+02,5.95615e+02,1.44544e-03,5.90207e+02,5.88459e+02,
1.47844e-03,5.55562e+02,5.53853e+02,1.47911e-03,5.54894e+02,5.53186e+02,1.49624e-03,5.38048e+02,5.36361e+02,1.51305e-03,
5.22202e+02,5.20534e+02,1.51356e-03,5.21731e+02,5.20064e+02,1.54882e-03,4.90418e+02,4.88797e+02,1.54959e-03,4.89756e+02,
4.88136e+02,1.57644e-03,4.67479e+02,4.65896e+02,1.58489e-03,4.60754e+02,4.59185e+02,1.58490e-03,4.60748e+02,4.59179e+02,
1.60794e-03,4.43077e+02,4.41543e+02,1.62181e-03,4.32876e+02,4.31366e+02,1.63389e-03,4.24281e+02,4.22791e+02,1.65957e-03,
4.06756e+02,4.05314e+02,1.65959e-03,4.06746e+02,4.05303e+02,1.67907e-03,3.94102e+02,3.92700e+02,1.69695e-03,3.82961e+02,
3.81599e+02,1.71064e-03,3.74716e+02,3.73389e+02,1.71791e-03,3.70433e+02,3.69128e+02,1.72601e-03,3.65745e+02,3.64462e+02,
1.73885e-03,3.58476e+02,3.57234e+02,1.75123e-03,3.51644e+02,3.50449e+02,1.75792e-03,3.48021e+02,3.46856e+02,1.76158e-03,
3.46054e+02,3.44904e+02,1.77026e-03,3.41445e+02,3.40339e+02,1.77825e-03,3.37263e+02,3.36203e+02,1.77828e-03,3.37248e+02,
3.36189e+02,1.78489e-03,3.33803e+02,3.32787e+02,1.80209e-03,3.25064e+02,3.24160e+02,1.80663e-03,3.22815e+02,3.21934e+02,
1.81040e-03,3.20969e+02,3.20103e+02,1.81380e-03,3.19316e+02,3.18460e+02,1.81742e-03,3.17578e+02,3.16727e+02,1.82074e-03,
3.16000e+02,3.15148e+02,1.82460e-03,3.14184e+02,3.13325e+02,1.82697e-03,3.13080e+02,3.12214e+02,1.82850e-03,3.12371e+02,
3.11498e+02,1.82850e-03,3.30949e+03,3.17490e+03,1.82911e-03,3.30811e+03,3.17362e+03,1.83332e-03,3.29862e+03,3.16477e+03,
1.83757e-03,3.28911e+03,3.15588e+03,1.84233e-03,3.27852e+03,3.14599e+03,1.85704e-03,3.24621e+03,3.11576e+03,1.86095e-03,
3.23771e+03,3.10781e+03,1.86209e-03,3.23524e+03,3.10550e+03,1.86500e-03,3.22896e+03,3.09962e+03,1.86579e-03,3.22674e+03,
3.09753e+03,1.87040e-03,3.21383e+03,3.08537e+03,1.87565e-03,3.19922e+03,3.07162e+03,1.87923e-03,3.18929e+03,3.06227e+03,
1.88365e-03,3.17714e+03,3.05083e+03,1.88602e-03,3.17065e+03,3.04471e+03,1.89000e-03,3.15980e+03,3.03450e+03,1.89689e-03,
3.13724e+03,3.01319e+03,1.90416e-03,3.11372e+03,2.99097e+03,1.91302e-03,3.08538e+03,2.96419e+03,1.92246e-03,3.05560e+03,
2.93605e+03,1.93000e-03,3.03214e+03,2.91388e+03,1.93429e-03,3.01624e+03,2.89884e+03,1.94564e-03,2.97474e+03,2.85956e+03,
1.95000e-03,2.95902e+03,2.84467e+03,1.95684e-03,2.93263e+03,2.81966e+03,1.96952e-03,2.88453e+03,2.77406e+03,1.97242e-03,
2.87368e+03,2.76376e+03,1.99526e-03,2.79024e+03,2.68461e+03,1.99530e-03,2.79010e+03,2.68448e+03,2.00000e-03,2.77335e+03,
2.66859e+03,2.01304e-03,2.72761e+03,2.62517e+03,2.01837e-03,2.70922e+03,2.60772e+03,2.04174e-03,2.63052e+03,2.53298e+03,
2.04629e-03,2.61555e+03,2.51876e+03,2.08930e-03,2.47978e+03,2.38972e+03,2.08973e-03,2.47847e+03,2.38847e+03,2.14171e-03,
2.32724e+03,2.24458e+03,2.16272e-03,2.26976e+03,2.18983e+03,2.19929e-03,2.17433e+03,2.09889e+03,2.26464e-03,2.01718e+03,
1.94898e+03,2.27225e-03,1.99994e+03,1.93253e+03,2.31740e-03,1.90166e+03,1.83866e+03,2.34423e-03,1.84640e+03,1.78584e+03,
2.34714e-03,1.84054e+03,1.78024e+03,2.39883e-03,1.74055e+03,1.68459e+03,2.44325e-03,1.66058e+03,1.60803e+03,2.51189e-03,
1.54676e+03,1.49896e+03,2.51190e-03,1.54674e+03,1.49894e+03,2.57080e-03,1.45755e+03,1.41337e+03,2.60016e-03,1.41575e+03,
1.37324e+03,2.69154e-03,1.29587e+03,1.25806e+03,2.74145e-03,1.23622e+03,1.20069e+03,2.75423e-03,1.22156e+03,1.18658e+03,
2.78612e-03,1.18603e+03,1.15238e+03,2.90068e-03,1.06769e+03,1.03834e+03,2.91743e-03,1.05178e+03,1.02300e+03,3.01995e-03,
9.61178e+02,9.35565e+02,3.05492e-03,9.32754e+02,9.08112e+02,3.09030e-03,9.04573e+02,8.80877e+02,3.12608e-03,8.77219e+02,
8.54432e+02,3.13058e-03,8.73858e+02,8.51182e+02,3.16228e-03,8.50687e+02,8.28773e+02,3.16230e-03,8.50672e+02,8.28758e+02,
3.23594e-03,8.00010e+02,7.79737e+02,3.38844e-03,7.07566e+02,6.90203e+02,3.44589e-03,6.76554e+02,6.60138e+02,3.50752e-03,
6.45330e+02,6.29854e+02,3.58922e-03,6.06921e+02,5.92580e+02,3.63078e-03,5.88568e+02,5.74760e+02,3.71535e-03,5.53507e+02,
5.40700e+02,3.75837e-03,5.36399e+02,5.24070e+02,3.82539e-03,5.11166e+02,4.99533e+02,3.98107e-03,4.58495e+02,4.48281e+02,
3.98110e-03,4.58487e+02,4.48273e+02,4.07380e-03,4.30608e+02,4.21124e+02,4.16869e-03,4.04423e+02,3.95611e+02,4.21696e-03,
3.91925e+02,3.83428e+02,4.26579e-03,3.79814e+02,3.71619e+02,4.28011e-03,3.76360e+02,3.68250e+02,4.36516e-03,3.56701e+02,
3.49076e+02,4.67735e-03,2.94711e+02,2.88551e+02,4.73151e-03,2.85486e+02,2.79536e+02,4.78749e-03,2.76361e+02,2.70617e+02,
4.89779e-03,2.59512e+02,2.54145e+02,4.95450e-03,2.51385e+02,2.46196e+02,5.01187e-03,2.43513e+02,2.38496e+02,5.01190e-03,
2.43509e+02,2.38492e+02,5.06991e-03,2.35771e+02,2.30920e+02,5.16542e-03,2.23744e+02,2.19149e+02,5.55904e-03,1.82098e+02,
1.78364e+02,5.75440e-03,1.65299e+02,1.61899e+02,5.75512e-03,1.65241e+02,1.61842e+02,5.82103e-03,1.60047e+02,1.56751e+02,
5.88844e-03,1.54963e+02,1.51766e+02,5.95662e-03,1.50041e+02,1.46939e+02,6.02560e-03,1.45275e+02,1.42265e+02,6.16249e-03,
1.36279e+02,1.33439e+02,6.30957e-03,1.27432e+02,1.24759e+02,6.30960e-03,1.27430e+02,1.24757e+02,6.53131e-03,1.15508e+02,
1.13056e+02,6.64246e-03,1.10098e+02,1.07744e+02,6.76083e-03,1.04706e+02,1.02450e+02,6.83912e-03,1.01332e+02,9.91381e+01,
6.91831e-03,9.80681e+01,9.59327e+01,6.99842e-03,9.49093e+01,9.28305e+01,7.24436e-03,8.60341e+01,8.41128e+01,7.36764e-03,
8.19527e+01,8.01026e+01,7.67362e-03,7.28917e+01,7.12008e+01,7.76247e-03,7.05163e+01,6.88667e+01,7.94328e-03,6.59966e+01,
6.44253e+01,7.94330e-03,6.59962e+01,6.44248e+01,8.00000e-03,6.46599e+01,6.31116e+01,8.01856e-03,6.42301e+01,6.26892e+01,
8.12830e-03,6.17653e+01,6.02676e+01,8.22243e-03,5.97524e+01,5.82898e+01,8.60829e-03,5.23688e+01,5.10343e+01,8.70964e-03,
5.06358e+01,4.93318e+01,9.12011e-03,4.42842e+01,4.30912e+01,9.22571e-03,4.28261e+01,4.16585e+01,9.46422e-03,3.97640e+01,
3.86498e+01,9.54993e-03,3.87357e+01,3.76399e+01,9.66051e-03,3.74602e+01,3.63873e+01,9.77237e-03,3.62271e+01,3.51762e+01,
1.00000e-02,3.38826e+01,3.28737e+01,1.05041e-02,2.93749e+01,2.84477e+01,1.05925e-02,2.86692e+01,2.77552e+01,1.07152e-02,
2.77164e+01,2.68201e+01,1.09648e-02,2.59059e+01,2.50434e+01,1.13501e-02,2.34121e+01,2.25966e+01,1.14815e-02,2.26354e+01,
2.18346e+01,1.16145e-02,2.18848e+01,2.10983e+01,1.25890e-02,1.72907e+01,1.65955e+01,1.25892e-02,1.72897e+01,1.65945e+01,
1.28825e-02,1.61662e+01,1.54941e+01,1.31611e-02,1.51782e+01,1.45266e+01,1.31826e-02,1.51054e+01,1.44553e+01,1.34896e-02,
1.41150e+01,1.34862e+01,1.38038e-02,1.31901e+01,1.25813e+01,1.39637e-02,1.27510e+01,1.21518e+01,1.52737e-02,9.80428e+00,
9.27195e+00,1.56675e-02,9.10212e+00,8.58672e+00,1.58489e-02,8.80175e+00,8.29370e+00,1.58490e-02,8.80164e+00,8.29358e+00,
1.62181e-02,8.22496e+00,7.73137e+00,1.65959e-02,7.68660e+00,7.20677e+00,1.67880e-02,7.43119e+00,6.95797e+00,1.69824e-02,
7.18453e+00,6.71776e+00,1.84431e-02,5.64770e+00,5.22278e+00,1.97242e-02,4.65080e+00,4.25543e+00,1.99526e-02,4.49770e+00,
4.10699e+00,1.99530e-02,4.49745e+00,4.10675e+00,2.01837e-02,4.34976e+00,3.96376e+00,2.04174e-02,4.20692e+00,3.82552e+00,
2.13796e-02,3.68328e+00,3.31923e+00,2.40124e-02,2.64781e+00,2.32108e+00,2.42661e-02,2.57089e+00,2.24719e+00,2.48313e-02,
2.41064e+00,2.09338e+00,2.51189e-02,2.33463e+00,2.02048e+00,2.51190e-02,2.33460e+00,2.02045e+00,2.63027e-02,2.05296e+00,
1.75112e+00,2.81838e-02,1.69854e+00,1.41327e+00,2.88403e-02,1.59613e+00,1.31593e+00,2.92718e-02,1.53381e+00,1.25677e+00,
3.01995e-02,1.41162e+00,1.14107e+00,3.09030e-02,1.32860e+00,1.06260e+00,3.16228e-02,1.25122e+00,9.89576e-01,3.16230e-02,
1.25119e+00,9.89554e-01,3.19889e-02,1.21442e+00,9.55021e-01,3.58469e-02,9.10210e-01,6.70681e-01,3.80189e-02,7.89809e-01,
5.59326e-01,3.89045e-02,7.48254e-01,5.21058e-01,3.98107e-02,7.09524e-01,4.85480e-01,3.98110e-02,7.09512e-01,4.85469e-01,
4.06035e-02,6.78273e-01,4.57062e-01,4.12097e-02,6.55933e-01,4.36843e-01,4.89779e-02,4.56628e-01,2.58663e-01,4.89938e-02,
4.56342e-01,2.58411e-01,5.01187e-02,4.37044e-01,2.41504e-01,5.01190e-02,4.37039e-01,2.41500e-01,5.06991e-02,4.27643e-01,
2.33422e-01,5.24807e-02,4.01305e-01,2.10898e-01,5.55904e-02,3.62997e-01,1.78500e-01,5.56188e-02,3.62683e-01,1.78236e-01,
5.62341e-02,3.56014e-01,1.72662e-01,6.30957e-02,2.97863e-01,1.24876e-01,6.30960e-02,2.97861e-01,1.24875e-01,6.38264e-02,
2.92963e-01,1.21048e-01,6.45654e-02,2.88220e-01,1.17361e-01,6.60693e-02,2.79193e-01,1.10390e-01,6.61215e-02,2.78894e-01,
1.10160e-01,6.99842e-02,2.58993e-01,9.51046e-02,7.07946e-02,2.55333e-01,9.23794e-02,7.58578e-02,2.35688e-01,7.80306e-02,
7.94328e-02,2.24533e-01,7.01292e-02,7.94330e-02,2.24532e-01,7.01288e-02,8.20642e-02,2.17197e-01,6.53353e-02,8.41395e-02,
2.11968e-01,6.19998e-02,8.70964e-02,2.05273e-01,5.78235e-02,9.33254e-02,1.93525e-01,5.07933e-02,1.00000e-01,1.83625e-01,
4.52229e-02,1.01158e-01,1.82051e-01,4.44551e-02,1.05925e-01,1.76150e-01,4.16725e-02,1.08135e-01,1.73693e-01,4.05618e-02,
1.12202e-01,1.69548e-01,3.87640e-02,1.18850e-01,1.63696e-01,3.63825e-02,1.24452e-01,1.59483e-01,3.47923e-02,1.25890e-01,
1.58490e-01,3.44336e-02,1.25893e-01,1.58488e-01,3.44329e-02,1.27350e-01,1.57449e-01,3.41313e-02,1.30317e-01,1.55437e-01,
3.35654e-02,1.36032e-01,1.51896e-01,3.26305e-02,1.38038e-01,1.50743e-01,3.23438e-02,1.39637e-01,1.49859e-01,3.21316e-02,
1.44544e-01,1.47304e-01,3.15458e-02,1.50000e-01,1.44715e-01,3.09933e-02,1.58489e-01,1.41126e-01,3.02962e-02,1.58490e-01,
1.41125e-01,3.02961e-02,1.60324e-01,1.40354e-01,3.02072e-02,1.64059e-01,1.38847e-01,3.00414e-02,1.65959e-01,1.38111e-01,
2.99642e-02,1.67880e-01,1.37385e-01,2.98904e-02,1.69824e-01,1.36670e-01,2.98200e-02,1.71791e-01,1.35965e-01,2.97528e-02,
1.79887e-01,1.33250e-01,2.95181e-02,1.81970e-01,1.32593e-01,2.94653e-02,1.88365e-01,1.30671e-01,2.93190e-02,1.90546e-01,
1.30047e-01,2.92738e-02,1.99526e-01,1.27626e-01,2.91082e-02,1.99530e-01,1.27625e-01,2.91082e-02,2.00000e-01,1.27494e-01,
2.91084e-02,2.01837e-01,1.26992e-01,2.91094e-02,2.06538e-01,1.25745e-01,2.91123e-02,2.11349e-01,1.24525e-01,2.91153e-02,
2.13796e-01,1.23926e-01,2.91177e-02,2.23872e-01,1.21592e-01,2.91246e-02,2.31740e-01,1.19901e-01,2.91259e-02,2.34423e-01,
1.19348e-01,2.91253e-02,2.37137e-01,1.18800e-01,2.91243e-02,2.39883e-01,1.18258e-01,2.91227e-02,2.45471e-01,1.17188e-01,
2.91179e-02,2.48313e-01,1.16660e-01,2.91153e-02,2.51189e-01,1.16137e-01,2.91120e-02,2.51190e-01,1.16137e-01,2.91121e-02,
2.60016e-01,1.14480e-01,2.92050e-02,2.63027e-01,1.13936e-01,2.92326e-02,2.69154e-01,1.12863e-01,2.92830e-02,2.75423e-01,
1.11807e-01,2.93268e-02,2.81838e-01,1.10768e-01,2.93643e-02,2.88403e-01,1.09745e-01,2.93964e-02,3.00000e-01,1.08030e-01,
2.94364e-02,3.01995e-01,1.07746e-01,2.94413e-02,3.05492e-01,1.07256e-01,2.94486e-02,3.12608e-01,1.06285e-01,2.94585e-02,
3.16228e-01,1.05804e-01,2.94612e-02,3.16230e-01,1.05804e-01,2.94613e-02,3.19889e-01,1.05296e-01,2.94958e-02,3.31131e-01,
1.03792e-01,2.95866e-02,3.42768e-01,1.02318e-01,2.96569e-02,3.46737e-01,1.01833e-01,2.96760e-02,3.50752e-01,1.01352e-01,
2.96929e-02,3.54813e-01,1.00874e-01,2.97078e-02,3.58922e-01,1.00398e-01,2.97205e-02,3.67282e-01,9.94577e-02,2.97406e-02,
3.68154e-01,9.93615e-02,2.97422e-02,3.75837e-01,9.85284e-02,2.97527e-02,3.80189e-01,9.80681e-02,2.97558e-02,3.89045e-01,
9.71561e-02,2.97564e-02,3.93550e-01,9.67043e-02,2.97539e-02,3.98107e-01,9.62552e-02,2.97496e-02,3.98110e-01,9.62549e-02,
2.97496e-02,4.00000e-01,9.60598e-02,2.97597e-02,4.07380e-01,9.53116e-02,2.97951e-02,4.21697e-01,9.39178e-02,2.98449e-02,
4.22950e-01,9.37992e-02,2.98482e-02,4.31519e-01,9.30026e-02,2.98662e-02,4.41570e-01,9.20983e-02,2.98783e-02,4.46684e-01,
9.16504e-02,2.98812e-02,4.57088e-01,9.07624e-02,2.98806e-02,4.67735e-01,8.98847e-02,2.98716e-02,4.73151e-01,8.94497e-02,
2.98641e-02,4.78630e-01,8.90172e-02,2.98546e-02,4.84172e-01,8.85871e-02,2.98432e-02,4.89779e-01,8.81597e-02,2.98300e-02,
4.95450e-01,8.77346e-02,2.98150e-02,5.01187e-01,8.73120e-02,2.97982e-02,5.01190e-01,8.73118e-02,2.97982e-02,5.12861e-01,
8.64261e-02,2.98088e-02,5.18800e-01,8.59870e-02,2.98105e-02,5.30884e-01,8.51163e-02,2.98068e-02,5.37032e-01,8.46849e-02,
2.98017e-02,5.62341e-01,8.29836e-02,2.97595e-02,5.68853e-01,8.25643e-02,2.97437e-02,5.82103e-01,8.17328e-02,2.97063e-02,
5.88844e-01,8.13206e-02,2.96847e-02,6.09537e-01,8.00978e-02,2.96090e-02,6.16595e-01,7.96948e-02,2.95802e-02,6.23735e-01,
7.92939e-02,2.95497e-02,6.30957e-01,7.88953e-02,2.95175e-02,6.30960e-01,7.88951e-02,2.95175e-02,6.38264e-01,7.84773e-02,
2.95046e-02,6.45654e-01,7.80617e-02,2.94896e-02,6.60694e-01,7.72377e-02,2.94530e-02,6.76083e-01,7.64231e-02,2.94081e-02,
6.83912e-01,7.60192e-02,2.93827e-02,6.91831e-01,7.56177e-02,2.93553e-02,6.97831e-01,7.53180e-02,2.93335e-02,6.99842e-01,
7.52184e-02,2.93260e-02,7.07946e-01,7.48214e-02,2.92949e-02,7.16143e-01,7.44267e-02,2.92620e-02,7.41310e-01,7.32557e-02,
2.91527e-02,7.49894e-01,7.28697e-02,2.91129e-02,7.58578e-01,7.24859e-02,2.90716e-02,7.76247e-01,7.17248e-02,2.89842e-02,
7.94328e-01,7.09722e-02,2.88907e-02,7.94330e-01,7.09721e-02,2.88907e-02,8.03526e-01,7.05789e-02,2.88580e-02,8.12831e-01,
7.01879e-02,2.88233e-02,8.22243e-01,6.97992e-02,2.87868e-02,8.31764e-01,6.94128e-02,2.87484e-02,8.41395e-01,6.90286e-02,
2.87083e-02,8.60994e-01,6.82669e-02,2.86230e-02,8.81049e-01,6.75139e-02,2.85310e-02,8.82040e-01,6.74773e-02,2.85263e-02,
8.91251e-01,6.71406e-02,2.84826e-02,9.12011e-01,6.64006e-02,2.83813e-02,9.33254e-01,6.56690e-02,2.82741e-02,9.44061e-01,
6.53064e-02,2.82184e-02,9.66051e-01,6.45873e-02,2.81031e-02,9.88553e-01,6.38765e-02,2.79826e-02,1.00000e+00,6.35241e-02,
2.79205e-02,1.00000e-03,1.91110e+03,1.90867e+03,1.00415e-03,1.89057e+03,1.88815e+03,1.02329e-03,1.79962e+03,1.79721e+03,
1.03000e-03,1.76930e+03,1.76690e+03,1.04909e-03,1.68617e+03,1.68378e+03,1.05925e-03,1.64413e+03,1.64175e+03,1.07152e-03,
1.59531e+03,1.59295e+03,1.09648e-03,1.50139e+03,1.49905e+03,1.14273e-03,1.34651e+03,1.34421e+03,1.16145e-03,1.29006e+03,
1.28779e+03,1.17490e-03,1.25163e+03,1.24937e+03,1.20226e-03,1.17767e+03,1.17543e+03,1.23027e-03,1.10820e+03,1.10599e+03,
1.25890e-03,1.04254e+03,1.04035e+03,1.25892e-03,1.04249e+03,1.04030e+03,1.28284e-03,9.91694e+02,9.89525e+02,1.31826e-03,
9.22535e+02,9.20396e+02,1.32974e-03,9.01593e+02,8.99463e+02,1.33352e-03,8.94843e+02,8.92717e+02,1.36458e-03,8.41541e+02,
8.39442e+02,1.38572e-03,8.07809e+02,8.05729e+02,1.41254e-03,7.67642e+02,7.65588e+02,1.42889e-03,7.44375e+02,7.42336e+02,
1.50701e-03,6.45575e+02,6.43605e+02,1.51356e-03,6.38133e+02,6.36169e+02,1.53109e-03,6.18839e+02,6.16892e+02,1.57126e-03,
5.77208e+02,5.75297e+02,1.58489e-03,5.63948e+02,5.62051e+02,1.58490e-03,5.63941e+02,5.62044e+02,1.63539e-03,5.18450e+02,
5.16601e+02,1.64059e-03,5.14056e+02,5.12213e+02,1.65000e-03,5.06195e+02,5.04362e+02,1.65959e-03,4.98335e+02,4.96512e+02,
1.69236e-03,4.72734e+02,4.70942e+02,1.73780e-03,4.40131e+02,4.38388e+02,1.73867e-03,4.39542e+02,4.37800e+02,1.77828e-03,
4.13707e+02,4.12009e+02,1.78224e-03,4.11217e+02,4.09523e+02,1.81970e-03,3.88652e+02,3.87003e+02,1.82121e-03,3.87783e+02,
3.86136e+02,1.86063e-03,3.65941e+02,3.64344e+02,1.89312e-03,3.49186e+02,3.47635e+02,1.90000e-03,3.45771e+02,3.44230e+02,
1.91989e-03,3.36100e+02,3.34590e+02,1.92753e-03,3.32482e+02,3.30985e+02,1.94130e-03,3.26098e+02,3.24624e+02,1.96124e-03,
3.17149e+02,3.15711e+02,1.98092e-03,3.08641e+02,3.07241e+02,1.99526e-03,3.02630e+02,3.01261e+02,1.99530e-03,3.02614e+02,
3.01246e+02,1.99598e-03,3.02333e+02,3.00966e+02,2.00000e-03,3.00678e+02,2.99321e+02,2.01289e-03,2.95465e+02,2.94139e+02,
2.02702e-03,2.89888e+02,2.88601e+02,2.03811e-03,2.85606e+02,2.84354e+02,2.04174e-03,2.84222e+02,2.82983e+02,2.04964e-03,
2.81212e+02,2.80001e+02,2.06025e-03,2.77235e+02,2.76067e+02,2.07118e-03,2.73205e+02,2.72089e+02,2.07798e-03,2.70734e+02,
2.69655e+02,2.08879e-03,2.66864e+02,2.65847e+02,2.08930e-03,2.66684e+02,2.65670e+02,2.10105e-03,2.62572e+02,2.61622e+02,
2.10722e-03,2.60452e+02,2.59529e+02,2.11091e-03,2.59201e+02,2.58290e+02,2.11575e-03,2.57575e+02,2.56674e+02,2.12011e-03,
2.56129e+02,2.55231e+02,2.12224e-03,2.55430e+02,2.54531e+02,2.12586e-03,2.54250e+02,2.53348e+02,2.13040e-03,2.52786e+02,
2.51871e+02,2.13040e-03,2.57863e+03,2.44506e+03,2.13106e-03,2.57743e+03,2.44396e+03,2.13590e-03,2.56870e+03,2.43593e+03,
2.14074e-03,2.56002e+03,2.42794e+03,2.14616e-03,2.55036e+03,2.41904e+03,2.16272e-03,2.52126e+03,2.39221e+03,2.16294e-03,
2.52087e+03,2.39185e+03,2.16738e-03,2.51318e+03,2.38475e+03,2.17200e-03,2.50520e+03,2.37740e+03,2.17314e-03,2.50248e+03,
2.37486e+03,2.18165e-03,2.48225e+03,2.35604e+03,2.18678e-03,2.47017e+03,2.34481e+03,2.18776e-03,2.46786e+03,2.34266e+03,
2.19197e-03,2.45803e+03,2.33352e+03,2.19651e-03,2.44748e+03,2.32370e+03,2.20476e-03,2.42848e+03,2.30603e+03,2.21552e-03,
2.40402e+03,2.28328e+03,2.22703e-03,2.37824e+03,2.25931e+03,2.23872e-03,2.35249e+03,2.23535e+03,2.23996e-03,2.34978e+03,
2.23283e+03,2.25076e-03,2.32640e+03,2.21107e+03,2.26464e-03,2.29685e+03,2.18355e+03,2.27908e-03,2.25967e+03,2.14885e+03,
2.29454e-03,2.22080e+03,2.11254e+03,2.31238e-03,2.17706e+03,2.07168e+03,2.31740e-03,2.16500e+03,2.06040e+03,2.33116e-03,
2.13233e+03,2.02985e+03,2.34423e-03,2.10194e+03,2.00144e+03,2.36928e-03,2.04531e+03,1.94845e+03,2.39883e-03,1.98118e+03,
1.88840e+03,2.42138e-03,1.93413e+03,1.84431e+03,2.45471e-03,1.86737e+03,1.78171e+03,2.46974e-03,1.83831e+03,1.75444e+03,
2.51189e-03,1.76009e+03,1.68100e+03,2.51190e-03,1.76007e+03,1.68098e+03,2.53997e-03,1.71051e+03,1.63441e+03,2.60016e-03,
1.61060e+03,1.54042e+03,2.62377e-03,1.57363e+03,1.50561e+03,2.66073e-03,1.51808e+03,1.45327e+03,2.69154e-03,1.47384e+03,
1.41155e+03,2.74407e-03,1.40239e+03,1.34411e+03,2.75423e-03,1.38912e+03,1.33158e+03,2.85102e-03,1.27110e+03,1.22001e+03,
2.87180e-03,1.24760e+03,1.19775e+03,2.90000e-03,1.21665e+03,1.16845e+03,3.01995e-03,1.09628e+03,1.05432e+03,3.02041e-03,
1.09585e+03,1.05391e+03,3.05492e-03,1.06432e+03,1.02397e+03,3.12608e-03,1.00317e+03,9.65867e+02,3.16228e-03,9.73911e+02,
9.38033e+02,3.16230e-03,9.73893e+02,9.38017e+02,3.22066e-03,9.29164e+02,8.95442e+02,3.31131e-03,8.65157e+02,8.34455e+02,
3.34965e-03,8.39927e+02,8.10393e+02,3.44747e-03,7.78266e+02,7.51508e+02,3.50752e-03,7.43464e+02,7.18242e+02,3.58922e-03,
6.99482e+02,6.76163e+02,3.63078e-03,6.78479e+02,6.56054e+02,3.71301e-03,6.39382e+02,6.18594e+02,3.75837e-03,6.19136e+02,
5.99183e+02,3.84592e-03,5.82098e+02,5.63650e+02,3.89045e-03,5.64420e+02,5.46679e+02,3.98107e-03,5.30659e+02,5.14245e+02,
3.98110e-03,5.30649e+02,5.14236e+02,4.07380e-03,4.98921e+02,4.83728e+02,4.08747e-03,4.94465e+02,4.79442e+02,4.16869e-03,
4.69087e+02,4.55019e+02,4.21696e-03,4.54848e+02,4.41309e+02,4.36516e-03,4.14643e+02,4.02565e+02,4.51856e-03,3.77233e+02,
3.66463e+02,4.53340e-03,3.73863e+02,3.63208e+02,4.73151e-03,3.32553e+02,3.23292e+02,4.84172e-03,3.12245e+02,3.03649e+02,
4.95450e-03,2.93182e+02,2.85197e+02,5.01187e-03,2.84086e+02,2.76389e+02,5.01190e-03,2.84082e+02,2.76385e+02,5.14421e-03,
2.64526e+02,2.57437e+02,5.30000e-03,2.43787e+02,2.37328e+02,5.30884e-03,2.42658e+02,2.36233e+02,5.55904e-03,2.13462e+02,
2.07893e+02,5.68853e-03,2.00215e+02,1.95022e+02,5.74612e-03,1.94682e+02,1.89644e+02,5.75440e-03,1.93904e+02,1.88888e+02,
6.16595e-03,1.59991e+02,1.55899e+02,6.23735e-03,1.54884e+02,1.50927e+02,6.30957e-03,1.49941e+02,1.46112e+02,6.30960e-03,
1.49939e+02,1.46111e+02,6.41695e-03,1.42980e+02,1.39331e+02,6.53131e-03,1.36040e+02,1.32569e+02,6.68344e-03,1.27499e+02,
1.24244e+02,6.76083e-03,1.23432e+02,1.20279e+02,6.87984e-03,1.17512e+02,1.14506e+02,7.24436e-03,1.01611e+02,9.89921e+01,
7.41310e-03,9.51522e+01,9.26862e+01,7.67362e-03,8.62287e+01,8.39702e+01,7.67388e-03,8.62201e+01,8.39618e+01,7.85236e-03,
8.07510e+01,7.86191e+01,7.94328e-03,7.81450e+01,7.60728e+01,7.94330e-03,7.81445e+01,7.60723e+01,8.00000e-03,7.65770e+01,
7.45406e+01,8.24207e-03,7.03395e+01,6.84439e+01,8.60994e-03,6.21118e+01,6.04010e+01,8.70964e-03,6.00832e+01,5.84171e+01,
8.81049e-03,5.81211e+01,5.64982e+01,8.85804e-03,5.72262e+01,5.56228e+01,9.12011e-03,5.26124e+01,5.11109e+01,9.22571e-03,
5.08955e+01,4.94316e+01,9.44061e-03,4.76293e+01,4.62367e+01,9.65508e-03,4.46444e+01,4.33164e+01,1.00000e-02,4.03520e+01,
3.91178e+01,1.03514e-02,3.65346e+01,3.53835e+01,1.03861e-02,3.61804e+01,3.50369e+01,1.04713e-02,3.53296e+01,3.42048e+01,
1.07152e-02,3.30385e+01,3.19639e+01,1.08393e-02,3.19498e+01,3.08991e+01,1.12202e-02,2.88966e+01,2.79126e+01,1.14692e-02,
2.71102e+01,2.61652e+01,1.23027e-02,2.21130e+01,2.12798e+01,1.25484e-02,2.08809e+01,2.00754e+01,1.25890e-02,2.06864e+01,
1.98854e+01,1.25892e-02,2.06852e+01,1.98842e+01,1.28825e-02,1.93347e+01,1.85648e+01,1.33352e-02,1.74747e+01,1.67480e+01,
1.38485e-02,1.56467e+01,1.49628e+01,1.47911e-02,1.29106e+01,1.22932e+01,1.53109e-02,1.16760e+01,1.10892e+01,1.54882e-02,
1.12876e+01,1.07104e+01,1.56806e-02,1.08857e+01,1.03186e+01,1.58489e-02,1.05499e+01,9.99139e+00,1.58490e-02,1.05498e+01,
9.99125e+00,1.79887e-02,7.28640e+00,6.81584e+00,1.84077e-02,6.81527e+00,6.35804e+00,1.87274e-02,6.48361e+00,6.03590e+00,
1.88365e-02,6.37552e+00,5.93099e+00,1.90546e-02,6.16453e+00,5.72620e+00,1.99526e-02,5.39005e+00,4.97490e+00,1.99530e-02,
5.38975e+00,4.97461e+00,2.23872e-02,3.86577e+00,3.50064e+00,2.31740e-02,3.50287e+00,3.15050e+00,2.34423e-02,3.39001e+00,
3.04169e+00,2.37137e-02,3.27997e+00,2.93560e+00,2.40532e-02,3.14937e+00,2.80976e+00,2.45471e-02,2.97204e+00,2.63910e+00,
2.48313e-02,2.87638e+00,2.54710e+00,2.51189e-02,2.78404e+00,2.45833e+00,2.51190e-02,2.78399e+00,2.45828e+00,2.75423e-02,
2.15037e+00,1.85143e+00,2.85102e-02,1.95498e+00,1.66489e+00,2.95121e-02,1.77897e+00,1.49714e+00,2.98538e-02,1.72381e+00,
1.44462e+00,3.00722e-02,1.68989e+00,1.41233e+00,3.16228e-02,1.47526e+00,1.20861e+00,3.16230e-02,1.47523e+00,1.20858e+00,
3.42768e-02,1.19262e+00,9.42242e-01,3.54813e-02,1.09121e+00,8.47110e-01,3.63004e-02,1.02980e+00,7.89629e-01,3.75837e-02,
9.43988e-01,7.09644e-01,3.98107e-02,8.19463e-01,5.93988e-01,3.98110e-02,8.19449e-01,5.93975e-01,4.19444e-02,7.23588e-01,
5.05967e-01,4.26579e-02,6.95673e-01,4.80499e-01,4.46684e-02,6.26369e-01,4.17518e-01,4.84172e-02,5.26070e-01,3.27129e-01,
4.95450e-02,5.01466e-01,3.05109e-01,5.01187e-02,4.89796e-01,2.94694e-01,5.01190e-02,4.89791e-01,2.94689e-01,5.07250e-02,
4.77928e-01,2.84253e-01,5.55904e-02,4.00081e-01,2.16655e-01,5.75440e-02,3.75842e-01,1.95900e-01,5.82103e-02,3.68300e-01,
1.89478e-01,5.84065e-02,3.66144e-01,1.87645e-01,5.95662e-02,3.53921e-01,1.77319e-01,6.30957e-02,3.21974e-01,1.50586e-01,
6.30960e-02,3.21972e-01,1.50585e-01,6.60693e-02,2.99664e-01,1.32640e-01,6.99842e-02,2.75636e-01,1.13661e-01,7.12141e-02,
2.69079e-01,1.08551e-01,7.49894e-02,2.51394e-01,9.49981e-02,7.58578e-02,2.47794e-01,9.22771e-02,7.85236e-02,2.37668e-01,
8.47017e-02,7.94328e-02,2.34506e-01,8.23612e-02,7.94330e-02,2.34505e-01,8.23608e-02,8.12830e-02,2.28302e-01,7.80130e-02,
8.41395e-02,2.19692e-01,7.20807e-02,8.77964e-02,2.10124e-01,6.56471e-02,9.22571e-02,2.00225e-01,5.92121e-02,9.54993e-02,
1.94042e-01,5.53144e-02,9.88553e-02,1.88380e-01,5.18398e-02,1.00000e-01,1.86599e-01,5.07677e-02,1.01158e-01,1.84794e-01,
4.97772e-02,1.10918e-01,1.71992e-01,4.31051e-02,1.11727e-01,1.71092e-01,4.26623e-02,1.14815e-01,1.67834e-01,4.10950e-02,
1.17490e-01,1.65231e-01,3.98804e-02,1.18850e-01,1.63979e-01,3.93080e-02,1.25890e-01,1.58161e-01,3.67605e-02,1.25893e-01,
1.58159e-01,3.67597e-02,1.27350e-01,1.57010e-01,3.63473e-02,1.30317e-01,1.54798e-01,3.55788e-02,1.31826e-01,1.53728e-01,
3.52174e-02,1.33352e-01,1.52680e-01,3.48704e-02,1.36458e-01,1.50652e-01,3.42168e-02,1.39637e-01,1.48708e-01,3.36137e-02,
1.44565e-01,1.45925e-01,3.27919e-02,1.51356e-01,1.42479e-01,3.18456e-02,1.53109e-01,1.41656e-01,3.16308e-02,1.56675e-01,
1.40055e-01,3.12260e-02,1.58489e-01,1.39276e-01,3.10351e-02,1.58490e-01,1.39276e-01,3.10351e-02,1.60324e-01,1.38457e-01,
3.08913e-02,1.62181e-01,1.37651e-01,3.07535e-02,1.67880e-01,1.35320e-01,3.03806e-02,1.73780e-01,1.33099e-01,3.00513e-02,
1.77828e-01,1.31675e-01,2.98529e-02,1.79887e-01,1.30979e-01,2.97595e-02,1.81970e-01,1.30293e-01,2.96699e-02,1.92416e-01,
1.27106e-01,2.92803e-02,1.94984e-01,1.26378e-01,2.91975e-02,1.97242e-01,1.25755e-01,2.91283e-02,1.99526e-01,1.25141e-01,
2.90614e-02,1.99530e-01,1.25140e-01,2.90614e-02,2.00000e-01,1.25006e-01,2.90558e-02,2.06538e-01,1.23207e-01,2.89852e-02,
2.08930e-01,1.22578e-01,2.89618e-02,2.13796e-01,1.21346e-01,2.89202e-02,2.18776e-01,1.20142e-01,2.88813e-02,2.21309e-01,
1.19550e-01,2.88625e-02,2.23872e-01,1.18965e-01,2.88441e-02,2.31740e-01,1.17247e-01,2.87905e-02,2.42661e-01,1.15039e-01,
2.87208e-02,2.48313e-01,1.13971e-01,2.86878e-02,2.51189e-01,1.13444e-01,2.86712e-02,2.51190e-01,1.13444e-01,2.86712e-02,
2.60016e-01,1.11782e-01,2.87230e-02,2.61705e-01,1.11475e-01,2.87316e-02,2.69154e-01,1.10163e-01,2.87643e-02,2.72270e-01,
1.09633e-01,2.87757e-02,2.78612e-01,1.08586e-01,2.87948e-02,2.85102e-01,1.07558e-01,2.88104e-02,2.88403e-01,1.07051e-01,
2.88163e-02,2.95121e-01,1.06048e-01,2.88245e-02,3.00000e-01,1.05344e-01,2.88272e-02,3.09029e-01,1.04090e-01,2.88256e-02,
3.16228e-01,1.03134e-01,2.88188e-02,3.16230e-01,1.03133e-01,2.88188e-02,3.19889e-01,1.02630e-01,2.88462e-02,3.23594e-01,
1.02130e-01,2.88716e-02,3.27341e-01,1.01633e-01,2.88950e-02,3.42768e-01,9.96834e-02,2.89682e-02,3.50752e-01,9.87290e-02,
2.89932e-02,3.54813e-01,9.82568e-02,2.90028e-02,3.58922e-01,9.77882e-02,2.90110e-02,3.63078e-01,9.73228e-02,2.90174e-02,
3.80189e-01,9.54921e-02,2.90248e-02,3.89045e-01,9.45946e-02,2.90181e-02,3.93550e-01,9.41502e-02,2.90123e-02,3.98107e-01,
9.37087e-02,2.90051e-02,3.98110e-01,9.37084e-02,2.90051e-02,4.02717e-01,9.32437e-02,2.90252e-02,4.12098e-01,9.23226e-02,
2.90584e-02,4.21697e-01,9.14131e-02,2.90825e-02,4.31519e-01,9.05151e-02,2.90976e-02,4.36516e-01,9.00703e-02,2.91020e-02,
4.46684e-01,8.91893e-02,2.91050e-02,4.57088e-01,8.83191e-02,2.91000e-02,4.62381e-01,8.78879e-02,2.90945e-02,4.73151e-01,
8.70333e-02,2.90777e-02,4.84172e-01,8.61888e-02,2.90536e-02,4.89779e-01,8.57705e-02,2.90391e-02,4.95450e-01,8.53546e-02,
2.90228e-02,5.01187e-01,8.49412e-02,2.90048e-02,5.01190e-01,8.49410e-02,2.90048e-02,5.06991e-01,8.45066e-02,2.90095e-02,
5.18800e-01,8.36452e-02,2.90121e-02,5.24808e-01,8.32183e-02,2.90100e-02,5.30884e-01,8.27939e-02,2.90058e-02,5.37032e-01,
8.23722e-02,2.89995e-02,5.55904e-01,8.11219e-02,2.89681e-02,5.68853e-01,8.03003e-02,2.89372e-02,5.82103e-01,7.94882e-02,
2.88987e-02,5.88844e-01,7.90858e-02,2.88768e-02,6.09537e-01,7.78922e-02,2.88005e-02,6.16595e-01,7.74988e-02,2.87717e-02,
6.23735e-01,7.71076e-02,2.87412e-02,6.30957e-01,7.67187e-02,2.87090e-02,6.30960e-01,7.67185e-02,2.87090e-02,6.38264e-01,
7.63109e-02,2.86955e-02,6.45654e-01,7.59055e-02,2.86799e-02,6.68344e-01,7.47035e-02,2.86208e-02,6.76083e-01,7.43075e-02,
2.85972e-02,6.83912e-01,7.39137e-02,2.85716e-02,6.91831e-01,7.35222e-02,2.85442e-02,6.99842e-01,7.31331e-02,2.85150e-02,
7.24436e-01,7.19788e-02,2.84169e-02,7.32825e-01,7.15985e-02,2.83808e-02,7.41310e-01,7.12203e-02,2.83431e-02,7.56397e-01,
7.05635e-02,2.82733e-02,7.58578e-01,7.04702e-02,2.82630e-02,7.67362e-01,7.00984e-02,2.82207e-02,7.85236e-01,6.93611e-02,
2.81316e-02,7.94328e-01,6.89956e-02,2.80850e-02,7.94330e-01,6.89955e-02,2.80850e-02,8.03526e-01,6.86125e-02,2.80528e-02,
8.31764e-01,6.74766e-02,2.79455e-02,8.41395e-01,6.71024e-02,2.79062e-02,8.51138e-01,6.67304e-02,2.78653e-02,8.60994e-01,
6.63606e-02,2.78228e-02,8.70964e-01,6.59929e-02,2.77786e-02,9.12011e-01,6.45433e-02,2.75867e-02,9.22571e-01,6.41862e-02,
2.75351e-02,9.44061e-01,6.34782e-02,2.74279e-02,9.66051e-01,6.27783e-02,2.73155e-02,9.88553e-01,6.20864e-02,2.71980e-02,
1.00000e+00,6.17434e-02,2.71376e-02,1.00000e-03,2.42717e+03,2.42436e+03,1.01158e-03,2.35527e+03,2.35247e+03,1.01962e-03,
2.30724e+03,2.30444e+03,1.05925e-03,2.08918e+03,2.08643e+03,1.09648e-03,1.90934e+03,1.90663e+03,1.11000e-03,1.84900e+03,
1.84631e+03,1.13501e-03,1.74341e+03,1.74074e+03,1.14815e-03,1.69128e+03,1.68862e+03,1.20226e-03,1.49831e+03,1.49570e+03,
1.20970e-03,1.47429e+03,1.47168e+03,1.23027e-03,1.41048e+03,1.40790e+03,1.25890e-03,1.32773e+03,1.32517e+03,1.25892e-03,
1.32766e+03,1.32511e+03,1.26379e-03,1.31409e+03,1.31154e+03,1.30317e-03,1.21106e+03,1.20854e+03,1.31826e-03,1.17458e+03,
1.17208e+03,1.36458e-03,1.07174e+03,1.06928e+03,1.40000e-03,1.00148e+03,9.99049e+02,1.41884e-03,9.66639e+02,9.64225e+02,
1.42889e-03,9.48728e+02,9.46322e+02,1.45000e-03,9.12320e+02,9.09933e+02,1.47911e-03,8.64969e+02,8.62607e+02,1.53109e-03,
7.88630e+02,7.86310e+02,1.53792e-03,7.79309e+02,7.76994e+02,1.56675e-03,7.41594e+02,7.39306e+02,1.58489e-03,7.19178e+02,
7.16907e+02,1.58490e-03,7.19170e+02,7.16898e+02,1.60325e-03,6.97441e+02,6.95186e+02,1.65000e-03,6.45955e+02,6.43740e+02,
1.65959e-03,6.35971e+02,6.33764e+02,1.66541e-03,6.29980e+02,6.27778e+02,1.69824e-03,5.97609e+02,5.95437e+02,1.73566e-03,
5.63533e+02,5.61393e+02,1.77828e-03,5.27883e+02,5.25782e+02,1.79823e-03,5.12276e+02,5.10192e+02,1.79887e-03,5.11789e+02,
5.09706e+02,1.84077e-03,4.81093e+02,4.79049e+02,1.87518e-03,4.57730e+02,4.55717e+02,1.88365e-03,4.52218e+02,4.50213e+02,
1.92753e-03,4.24884e+02,4.22919e+02,1.93683e-03,4.19357e+02,4.17401e+02,1.94984e-03,4.11783e+02,4.09840e+02,1.98894e-03,
3.90194e+02,3.88290e+02,1.99526e-03,3.86849e+02,3.84952e+02,1.99530e-03,3.86829e+02,3.84932e+02,2.04175e-03,3.63418e+02,
3.61569e+02,2.06538e-03,3.52247e+02,3.50424e+02,2.08859e-03,3.41750e+02,3.39952e+02,2.11349e-03,3.30959e+02,3.29191e+02,
2.12888e-03,3.24517e+02,3.22766e+02,2.16272e-03,3.10941e+02,3.09233e+02,2.16998e-03,3.08108e+02,3.06409e+02,2.20406e-03,
2.95260e+02,2.93607e+02,2.23163e-03,2.85394e+02,2.83783e+02,2.23872e-03,2.82927e+02,2.81328e+02,2.25814e-03,2.76311e+02,
2.74743e+02,2.28297e-03,2.68146e+02,2.66622e+02,2.30148e-03,2.62271e+02,2.60784e+02,2.32014e-03,2.56518e+02,2.55072e+02,
2.33655e-03,2.51592e+02,2.50186e+02,2.35239e-03,2.46956e+02,2.45595e+02,2.36602e-03,2.43049e+02,2.41732e+02,2.37137e-03,
2.41535e+02,2.40239e+02,2.37767e-03,2.39775e+02,2.38503e+02,2.38693e-03,2.37213e+02,2.35981e+02,2.39547e-03,2.34877e+02,
2.33686e+02,2.39883e-03,2.33963e+02,2.32791e+02,2.40000e-03,2.33648e+02,2.32482e+02,2.40736e-03,2.31665e+02,2.30538e+02,
2.42362e-03,2.27369e+02,2.26325e+02,2.42918e-03,2.25929e+02,2.24909e+02,2.43491e-03,2.24461e+02,2.23460e+02,2.44081e-03,
2.22974e+02,2.21985e+02,2.44670e-03,2.21509e+02,2.20523e+02,2.45066e-03,2.20535e+02,2.19547e+02,2.45590e-03,2.19265e+02,
2.18267e+02,2.45590e-03,2.13853e+03,2.00083e+03,2.45613e-03,2.13821e+03,2.00055e+03,2.45941e-03,2.13373e+03,1.99651e+03,
2.46271e-03,2.12925e+03,1.99246e+03,2.46871e-03,2.12113e+03,1.98514e+03,2.47753e-03,2.10930e+03,1.97444e+03,2.49654e-03,
2.08421e+03,1.95172e+03,2.50443e-03,2.07393e+03,1.94241e+03,2.51169e-03,2.06455e+03,1.93391e+03,2.51189e-03,2.06429e+03,
1.93368e+03,2.51190e-03,2.06427e+03,1.93366e+03,2.51300e-03,2.06285e+03,1.93238e+03,2.52170e-03,2.04967e+03,1.92037e+03,
2.52708e-03,2.04157e+03,1.91300e+03,2.53718e-03,2.02652e+03,1.89930e+03,2.54679e-03,2.01234e+03,1.88638e+03,2.55668e-03,
1.99791e+03,1.87325e+03,2.55800e-03,1.99599e+03,1.87150e+03,2.57040e-03,1.97489e+03,1.85220e+03,2.57335e-03,1.96992e+03,
1.84764e+03,2.58508e-03,1.95031e+03,1.82970e+03,2.60016e-03,1.92551e+03,1.80700e+03,2.60453e-03,1.91733e+03,1.79950e+03,
2.61987e-03,1.88896e+03,1.77348e+03,2.63642e-03,1.85902e+03,1.74601e+03,2.67000e-03,1.80024e+03,1.69205e+03,2.69625e-03,
1.75608e+03,1.65147e+03,2.72270e-03,1.71310e+03,1.61195e+03,2.74045e-03,1.68509e+03,1.58618e+03,2.75423e-03,1.66377e+03,
1.56655e+03,2.78612e-03,1.61585e+03,1.52241e+03,2.79063e-03,1.60924e+03,1.51632e+03,2.81838e-03,1.56932e+03,1.47950e+03,
2.86604e-03,1.50286e+03,1.41813e+03,2.91743e-03,1.43548e+03,1.35584e+03,2.95121e-03,1.39342e+03,1.31690e+03,2.95766e-03,
1.38558e+03,1.30963e+03,3.05848e-03,1.27063e+03,1.20303e+03,3.12608e-03,1.20086e+03,1.13819e+03,3.16228e-03,1.16568e+03,
1.10546e+03,3.16230e-03,1.16566e+03,1.10544e+03,3.20262e-03,1.12813e+03,1.07049e+03,3.23594e-03,1.09838e+03,1.04277e+03,
3.37048e-03,9.88727e+02,9.40391e+02,3.38844e-03,9.75248e+02,9.27788e+02,3.58922e-03,8.40441e+02,8.01481e+02,3.67282e-03,
7.91909e+02,7.55893e+02,3.75837e-03,7.46184e+02,7.12882e+02,3.80040e-03,7.25062e+02,6.92993e+02,3.84592e-03,7.03107e+02,
6.72306e+02,3.89045e-03,6.81938e+02,6.52337e+02,3.93550e-03,6.61402e+02,6.32953e+02,3.98107e-03,6.41469e+02,6.14125e+02,
3.98110e-03,6.41457e+02,6.14114e+02,4.07777e-03,6.01833e+02,5.76650e+02,4.12097e-03,5.85206e+02,5.60917e+02,4.30000e-03,
5.22691e+02,5.01679e+02,4.31519e-03,5.17818e+02,4.97055e+02,4.43282e-03,4.81776e+02,4.62838e+02,4.46684e-03,4.71996e+02,
4.53545e+02,4.51856e-03,4.57645e+02,4.39903e+02,4.57088e-03,4.43728e+02,4.26667e+02,4.73151e-03,4.04438e+02,3.89257e+02,
4.90084e-03,3.68028e+02,3.54533e+02,5.01187e-03,3.46562e+02,3.34036e+02,5.01190e-03,3.46557e+02,3.34031e+02,5.06991e-03,
3.35795e+02,3.23744e+02,5.18800e-03,3.15255e+02,3.04098e+02,5.24807e-03,3.05464e+02,2.94726e+02,5.30884e-03,2.95976e+02,
2.85640e+02,5.40910e-03,2.81172e+02,2.71454e+02,5.49541e-03,2.69226e+02,2.60000e+02,5.88844e-03,2.22787e+02,2.15407e+02,
6.02560e-03,2.09168e+02,2.02307e+02,6.09537e-03,2.02676e+02,1.96058e+02,6.16248e-03,1.96584e+02,1.90192e+02,6.16595e-03,
1.96276e+02,1.89895e+02,6.30957e-03,1.84065e+02,1.78131e+02,6.30960e-03,1.84063e+02,1.78129e+02,6.53131e-03,1.67163e+02,
1.61833e+02,6.83997e-03,1.46979e+02,1.42347e+02,6.91831e-03,1.42389e+02,1.37912e+02,7.16143e-03,1.29331e+02,1.25288e+02,
7.24436e-03,1.25200e+02,1.21292e+02,7.63653e-03,1.07899e+02,1.04543e+02,7.67362e-03,1.06434e+02,1.03125e+02,7.94328e-03,
9.65606e+01,9.35565e+01,7.94330e-03,9.65600e+01,9.35559e+01,8.12830e-03,9.04950e+01,8.76750e+01,8.20290e-03,8.81963e+01,
8.54453e+01,8.31764e-03,8.48119e+01,8.21627e+01,8.41395e-03,8.20719e+01,7.95040e+01,8.51138e-03,7.94211e+01,7.69313e+01,
8.60994e-03,7.68563e+01,7.44415e+01,9.01571e-03,6.73951e+01,6.52522e+01,9.10699e-03,6.54874e+01,6.33985e+01,9.66051e-03,
5.53536e+01,5.35491e+01,9.78055e-03,5.34414e+01,5.16896e+01,9.88553e-03,5.18415e+01,5.01339e+01,1.00000e-02,5.01490e+01,
4.84879e+01,1.01158e-02,4.85123e+01,4.68959e+01,1.02329e-02,4.69279e+01,4.53545e+01,1.05054e-02,4.35043e+01,4.20232e+01,
1.05925e-02,4.24805e+01,4.10272e+01,1.14206e-02,3.42046e+01,3.29730e+01,1.14815e-02,3.36850e+01,3.24674e+01,1.18850e-02,
3.05011e+01,2.93689e+01,1.20226e-02,2.94967e+01,2.83911e+01,1.21619e-02,2.85248e+01,2.74450e+01,1.25890e-02,2.58007e+01,
2.47927e+01,1.25892e-02,2.57992e+01,2.47912e+01,1.26567e-02,2.54016e+01,2.44041e+01,1.36458e-02,2.04178e+01,1.95543e+01,
1.39295e-02,1.92364e+01,1.84047e+01,1.42889e-02,1.78686e+01,1.70744e+01,1.44544e-02,1.72828e+01,1.65047e+01,1.46218e-02,
1.67101e+01,1.59476e+01,1.51356e-02,1.51049e+01,1.43863e+01,1.54298e-02,1.42792e+01,1.35833e+01,1.58489e-02,1.32055e+01,
1.25397e+01,1.58490e-02,1.32053e+01,1.25395e+01,1.62181e-02,1.23486e+01,1.17073e+01,1.71791e-02,1.04464e+01,9.86005e+00,
1.75792e-02,9.77157e+00,9.20497e+00,1.75792e-02,9.77156e+00,9.20495e+00,1.77828e-02,9.44746e+00,8.89050e+00,1.84077e-02,
8.53978e+00,8.01013e+00,1.94985e-02,7.22156e+00,6.73238e+00,1.99526e-02,6.75489e+00,6.28034e+00,1.99530e-02,6.75452e+00,
6.27998e+00,2.06538e-02,6.11221e+00,5.65861e+00,2.13796e-02,5.53234e+00,5.09804e+00,2.16233e-02,5.35481e+00,4.92651e+00,
2.16272e-02,5.35203e+00,4.92383e+00,2.18776e-02,5.17602e+00,4.75386e+00,2.29087e-02,4.53026e+00,4.13074e+00,2.34423e-02,
4.23965e+00,3.85058e+00,2.51189e-02,3.48002e+00,3.11922e+00,2.51190e-02,3.47997e+00,3.11916e+00,2.69154e-02,2.86275e+00,
2.52682e+00,2.76352e-02,2.65698e+00,2.32964e+00,2.78612e-02,2.59671e+00,2.27197e+00,2.85102e-02,2.43422e+00,2.11657e+00,
2.91743e-02,2.28273e+00,1.97186e+00,2.95121e-02,2.21089e+00,1.90327e+00,3.09030e-02,1.94744e+00,1.65212e+00,3.16228e-02,
1.82886e+00,1.53927e+00,3.16230e-02,1.82882e+00,1.53924e+00,3.42768e-02,1.47270e+00,1.20220e+00,3.49130e-02,1.40232e+00,
1.13579e+00,3.50752e-02,1.38519e+00,1.11965e+00,3.84592e-02,1.09042e+00,8.42958e-01,3.98107e-02,9.99507e-01,7.58048e-01,
3.98110e-02,9.99489e-01,7.58031e-01,4.00000e-02,9.87711e-01,7.47101e-01,4.06709e-02,9.47670e-01,7.09979e-01,4.41570e-02,
7.76526e-01,5.52368e-01,4.86413e-02,6.21813e-01,4.11215e-01,4.89779e-02,6.12404e-01,4.02707e-01,5.01187e-02,5.82358e-01,
3.75592e-01,5.01190e-02,5.82351e-01,3.75586e-01,5.55904e-02,4.69350e-01,2.75626e-01,5.60500e-02,4.61787e-01,2.69007e-01,
5.75440e-02,4.38758e-01,2.48982e-01,5.82103e-02,4.29234e-01,2.40731e-01,5.88844e-02,4.20030e-01,2.32777e-01,6.30957e-02,
3.70701e-01,1.90460e-01,6.30960e-02,3.70698e-01,1.90458e-01,6.53131e-02,3.49325e-01,1.72689e-01,6.55024e-02,3.47629e-01,
1.71287e-01,6.99842e-02,3.12430e-01,1.42552e-01,7.32825e-02,2.91638e-01,1.25888e-01,7.41310e-02,2.86857e-01,1.22095e-01,
7.67362e-02,2.73429e-01,1.11529e-01,7.87194e-02,2.64325e-01,1.04447e-01,7.94328e-02,2.61252e-01,1.02080e-01,7.94330e-02,
2.61252e-01,1.02079e-01,8.41395e-02,2.42899e-01,8.86808e-02,8.51138e-02,2.39554e-01,8.62799e-02,8.70964e-02,2.33169e-01,
8.17402e-02,8.81049e-02,2.30123e-01,7.95958e-02,9.01571e-02,2.24309e-01,7.55425e-02,9.12011e-02,2.21534e-01,7.36280e-02,
1.00000e-01,2.02134e-01,6.06624e-02,1.04713e-01,1.93737e-01,5.56750e-02,1.08393e-01,1.88013e-01,5.24072e-02,1.09648e-01,
1.86209e-01,5.13992e-02,1.23027e-01,1.70614e-01,4.31947e-02,1.25890e-01,1.67959e-01,4.19016e-02,1.25893e-01,1.67956e-01,
4.19006e-02,1.27350e-01,1.66609e-01,4.13322e-02,1.28825e-01,1.65299e-01,4.07911e-02,1.30822e-01,1.63597e-01,4.01007e-02,
1.33352e-01,1.61544e-01,3.92899e-02,1.41254e-01,1.55825e-01,3.71509e-02,1.42889e-01,1.54756e-01,3.67711e-02,1.46218e-01,
1.52686e-01,3.60547e-02,1.47911e-01,1.51683e-01,3.57168e-02,1.50000e-01,1.50490e-01,3.53226e-02,1.58489e-01,1.46085e-01,
3.39433e-02,1.58490e-01,1.46085e-01,3.39432e-02,1.62181e-01,1.44247e-01,3.35163e-02,1.67880e-01,1.41622e-01,3.29461e-02,
1.69824e-01,1.40777e-01,3.27707e-02,1.71791e-01,1.39948e-01,3.26022e-02,1.73916e-01,1.39077e-01,3.24294e-02,1.81970e-01,
1.35994e-01,3.18511e-02,1.84077e-01,1.35242e-01,3.17174e-02,1.88365e-01,1.33771e-01,3.14644e-02,1.92752e-01,1.32346e-01,
3.12293e-02,1.94984e-01,1.31649e-01,3.11179e-02,1.99526e-01,1.30286e-01,3.09066e-02,1.99530e-01,1.30285e-01,3.09066e-02,
2.06538e-01,1.28172e-01,3.07301e-02,2.08930e-01,1.27486e-01,3.06756e-02,2.11349e-01,1.26811e-01,3.06250e-02,2.13796e-01,
1.26145e-01,3.05760e-02,2.18776e-01,1.24838e-01,3.04829e-02,2.21309e-01,1.24196e-01,3.04385e-02,2.29087e-01,1.22318e-01,
3.03124e-02,2.33392e-01,1.21333e-01,3.02484e-02,2.34423e-01,1.21102e-01,3.02335e-02,2.42661e-01,1.19327e-01,3.01212e-02,
2.45471e-01,1.18749e-01,3.00864e-02,2.48313e-01,1.18178e-01,3.00521e-02,2.51189e-01,1.17613e-01,3.00182e-02,2.51190e-01,
1.17613e-01,3.00182e-02,2.54097e-01,1.17014e-01,3.00210e-02,2.57040e-01,1.16422e-01,3.00231e-02,2.60016e-01,1.15835e-01,
3.00246e-02,2.75423e-01,1.12987e-01,3.00211e-02,2.78612e-01,1.12433e-01,3.00181e-02,2.85102e-01,1.11343e-01,3.00113e-02,
2.95121e-01,1.09744e-01,2.99944e-02,3.05492e-01,1.08185e-01,2.99689e-02,3.09029e-01,1.07674e-01,2.99585e-02,3.12608e-01,
1.07168e-01,2.99471e-02,3.16228e-01,1.06665e-01,2.99347e-02,3.16230e-01,1.06665e-01,2.99347e-02,3.23594e-01,1.05609e-01,
2.99738e-02,3.28284e-01,1.04957e-01,2.99944e-02,3.34965e-01,1.04054e-01,3.00185e-02,3.38844e-01,1.03544e-01,3.00298e-02,
3.42768e-01,1.03037e-01,3.00393e-02,3.54813e-01,1.01540e-01,3.00572e-02,3.63078e-01,1.00562e-01,3.00615e-02,3.67282e-01,
1.00078e-01,3.00611e-02,3.71535e-01,9.95968e-02,3.00591e-02,3.75837e-01,9.91195e-02,3.00554e-02,3.80189e-01,9.86455e-02,
3.00500e-02,3.93550e-01,9.72428e-02,3.00243e-02,3.98107e-01,9.67819e-02,3.00130e-02,3.98110e-01,9.67817e-02,3.00130e-02,
4.02717e-01,9.62966e-02,3.00298e-02,4.12098e-01,9.53356e-02,3.00564e-02,4.16869e-01,9.48598e-02,3.00663e-02,4.31519e-01,
9.34513e-02,3.00830e-02,4.36516e-01,9.29879e-02,3.00844e-02,4.46684e-01,9.20706e-02,3.00816e-02,4.51856e-01,9.16164e-02,
3.00772e-02,4.57088e-01,9.11650e-02,3.00708e-02,4.62381e-01,9.07164e-02,3.00625e-02,4.67735e-01,9.02706e-02,3.00523e-02,
4.73151e-01,8.98275e-02,3.00402e-02,4.84172e-01,8.89496e-02,3.00107e-02,4.95450e-01,8.80828e-02,2.99746e-02,5.01187e-01,
8.76534e-02,2.99539e-02,5.01190e-01,8.76532e-02,2.99540e-02,5.06991e-01,8.72009e-02,2.99560e-02,5.12861e-01,8.67511e-02,
2.99558e-02,5.30884e-01,8.54184e-02,2.99415e-02,5.35488e-01,8.50891e-02,2.99350e-02,5.43250e-01,8.45435e-02,2.99215e-02,
5.47720e-01,8.42347e-02,2.99124e-02,5.49541e-01,8.41100e-02,2.99084e-02,5.55904e-01,8.36791e-02,2.98932e-02,5.82103e-01,
8.19808e-02,2.98131e-02,5.95662e-01,8.11469e-02,2.97621e-02,6.02560e-01,8.07336e-02,2.97340e-02,6.09537e-01,8.03226e-02,
2.97041e-02,6.30957e-01,7.91041e-02,2.96046e-02,6.30960e-01,7.91039e-02,2.96046e-02,6.38264e-01,7.86830e-02,2.95904e-02,
6.45654e-01,7.82645e-02,2.95741e-02,6.53131e-01,7.78484e-02,2.95557e-02,6.60694e-01,7.74349e-02,2.95353e-02,6.68344e-01,
7.70237e-02,2.95128e-02,6.91831e-01,7.58046e-02,2.94335e-02,6.99842e-01,7.54030e-02,2.94034e-02,7.07946e-01,7.50038e-02,
2.93715e-02,7.16143e-01,7.46069e-02,2.93377e-02,7.24436e-01,7.42123e-02,2.93023e-02,7.32825e-01,7.38199e-02,2.92651e-02,
7.58578e-01,7.26563e-02,2.91438e-02,7.67362e-01,7.22730e-02,2.91003e-02,7.85236e-01,7.15128e-02,2.90087e-02,7.94328e-01,
7.11359e-02,2.89607e-02,7.94330e-01,7.11358e-02,2.89607e-02,8.03526e-01,7.07402e-02,2.89271e-02,8.22243e-01,6.99558e-02,
2.88540e-02,8.31764e-01,6.95670e-02,2.88148e-02,8.41395e-01,6.91806e-02,2.87739e-02,8.51138e-01,6.87964e-02,2.87312e-02,
8.60994e-01,6.84146e-02,2.86869e-02,8.70964e-01,6.80349e-02,2.86409e-02,8.91251e-01,6.72823e-02,2.85443e-02,9.12011e-01,
6.65384e-02,2.84415e-02,9.44061e-01,6.54389e-02,2.82768e-02,9.66051e-01,6.47165e-02,2.81602e-02,9.88553e-01,6.40024e-02,
2.80386e-02,1.00000e+00,6.36485e-02,2.79760e-02,1.00000e-03,2.82993e+03,2.82691e+03,1.03514e-03,2.58858e+03,2.58560e+03,
1.04713e-03,2.51244e+03,2.50947e+03,1.05293e-03,2.47674e+03,2.47377e+03,1.07000e-03,2.37564e+03,2.37270e+03,1.08393e-03,
2.29680e+03,2.29387e+03,1.09648e-03,2.22886e+03,2.22595e+03,1.18652e-03,1.81403e+03,1.81121e+03,1.18850e-03,1.80614e+03,
1.80333e+03,1.19410e-03,1.78420e+03,1.78139e+03,1.20226e-03,1.75264e+03,1.74984e+03,1.23027e-03,1.64929e+03,1.64651e+03,
1.24451e-03,1.59998e+03,1.59722e+03,1.25890e-03,1.55225e+03,1.54950e+03,1.25892e-03,1.55216e+03,1.54942e+03,1.28610e-03,
1.46722e+03,1.46449e+03,1.34896e-03,1.29383e+03,1.29117e+03,1.35000e-03,1.29122e+03,1.28856e+03,1.39637e-03,1.18091e+03,
1.17828e+03,1.42889e-03,1.11071e+03,1.10812e+03,1.45974e-03,1.04937e+03,1.04680e+03,1.53109e-03,9.24278e+02,9.21764e+02,
1.54882e-03,8.96492e+02,8.93992e+02,1.56675e-03,8.69342e+02,8.66855e+02,1.57777e-03,8.53237e+02,8.50758e+02,1.58489e-03,
8.43034e+02,8.40560e+02,1.58490e-03,8.43024e+02,8.40550e+02,1.60325e-03,8.17524e+02,8.15065e+02,1.63736e-03,7.72625e+02,
7.70193e+02,1.64059e-03,7.68558e+02,7.66128e+02,1.73780e-03,6.58651e+02,6.56305e+02,1.75792e-03,6.38690e+02,6.36359e+02,
1.77828e-03,6.19204e+02,6.16890e+02,1.83925e-03,5.65587e+02,5.63319e+02,1.84077e-03,5.64336e+02,5.62069e+02,1.86209e-03,
5.47167e+02,5.44917e+02,1.88365e-03,5.30433e+02,5.28200e+02,1.91284e-03,5.08865e+02,5.06654e+02,1.97242e-03,4.68436e+02,
4.66278e+02,1.99526e-03,4.54139e+02,4.52000e+02,1.99530e-03,4.54115e+02,4.51977e+02,2.00000e-03,4.51248e+02,4.49113e+02,
2.04174e-03,4.26655e+02,4.24555e+02,2.06536e-03,4.13579e+02,4.11497e+02,2.13796e-03,3.76666e+02,3.74644e+02,2.14765e-03,
3.72094e+02,3.70080e+02,2.16272e-03,3.65128e+02,3.63127e+02,2.18776e-03,3.53887e+02,3.51908e+02,2.22086e-03,3.39733e+02,
3.37782e+02,2.26464e-03,3.22171e+02,3.20260e+02,2.28930e-03,3.12847e+02,3.10957e+02,2.31740e-03,3.02663e+02,3.00800e+02,
2.33936e-03,2.94952e+02,2.93109e+02,2.34423e-03,2.93277e+02,2.91439e+02,2.38821e-03,2.78770e+02,2.76974e+02,2.43567e-03,
2.64189e+02,2.62442e+02,2.48216e-03,2.50894e+02,2.49198e+02,2.48313e-03,2.50624e+02,2.48929e+02,2.51189e-03,2.42880e+02,
2.41220e+02,2.51190e-03,2.42877e+02,2.41216e+02,2.51819e-03,2.41225e+02,2.39572e+02,2.54097e-03,2.35372e+02,2.33748e+02,
2.54955e-03,2.33205e+02,2.31592e+02,2.57490e-03,2.26954e+02,2.25376e+02,2.59680e-03,2.21734e+02,2.20188e+02,2.60016e-03,
2.20947e+02,2.19407e+02,2.61928e-03,2.16550e+02,2.15040e+02,2.63950e-03,2.12025e+02,2.10551e+02,2.65953e-03,2.07663e+02,
2.06228e+02,2.67511e-03,2.04350e+02,2.02949e+02,2.68678e-03,2.01913e+02,2.00541e+02,2.69154e-03,2.00928e+02,1.99569e+02,
2.70225e-03,1.98719e+02,1.97388e+02,2.71555e-03,1.96014e+02,1.94726e+02,2.72558e-03,1.94003e+02,1.92752e+02,2.73695e-03,
1.91750e+02,1.90545e+02,2.74881e-03,1.89432e+02,1.88282e+02,2.76918e-03,1.85536e+02,1.84478e+02,2.77713e-03,1.84050e+02,
1.83020e+02,2.78369e-03,1.82843e+02,1.81831e+02,2.78949e-03,1.81790e+02,1.80788e+02,2.79579e-03,1.80663e+02,1.79664e+02,
2.80154e-03,1.79648e+02,1.78646e+02,2.80490e-03,1.79063e+02,1.78055e+02,2.80490e-03,1.68318e+03,1.55078e+03,2.80609e-03,
1.68190e+03,1.54965e+03,2.80940e-03,1.67833e+03,1.54650e+03,2.81367e-03,1.67376e+03,1.54245e+03,2.81774e-03,1.66942e+03,
1.53861e+03,2.82533e-03,1.66139e+03,1.53149e+03,2.85118e-03,1.63451e+03,1.50760e+03,2.86272e-03,1.62272e+03,1.49712e+03,
2.86988e-03,1.61548e+03,1.49068e+03,2.87660e-03,1.60872e+03,1.48468e+03,2.88403e-03,1.60130e+03,1.47807e+03,2.88539e-03,
1.59995e+03,1.47687e+03,2.89438e-03,1.59106e+03,1.46897e+03,2.90133e-03,1.58423e+03,1.46291e+03,2.91274e-03,1.57312e+03,
1.45303e+03,2.91743e-03,1.56859e+03,1.44900e+03,2.92403e-03,1.56225e+03,1.44337e+03,2.93500e-03,1.55179e+03,1.43407e+03,
2.93997e-03,1.54610e+03,1.42898e+03,2.95121e-03,1.53336e+03,1.41757e+03,2.95656e-03,1.52735e+03,1.41218e+03,2.96500e-03,
1.51793e+03,1.40374e+03,2.97387e-03,1.50658e+03,1.39352e+03,2.99287e-03,1.48267e+03,1.37199e+03,3.00000e-03,1.47382e+03,
1.36402e+03,3.01344e-03,1.45737e+03,1.34923e+03,3.05492e-03,1.40816e+03,1.30495e+03,3.09030e-03,1.36800e+03,1.26878e+03,
3.11039e-03,1.34591e+03,1.24887e+03,3.12608e-03,1.32900e+03,1.23361e+03,3.16228e-03,1.29107e+03,1.19936e+03,3.16230e-03,
1.29105e+03,1.19934e+03,3.16607e-03,1.28706e+03,1.19574e+03,3.22012e-03,1.23186e+03,1.14578e+03,3.29661e-03,1.15918e+03,
1.07987e+03,3.34965e-03,1.11223e+03,1.03721e+03,3.40000e-03,1.07007e+03,9.98852e+02,3.41291e-03,1.05961e+03,9.89330e+02,
3.46737e-03,1.01703e+03,9.50518e+02,3.53196e-03,9.69555e+02,9.07171e+02,3.54813e-03,9.58149e+02,8.96748e+02,3.63078e-03,
9.02684e+02,8.45999e+02,3.70954e-03,8.53853e+02,8.01228e+02,3.84592e-03,7.77593e+02,7.31142e+02,3.86628e-03,7.67028e+02,
7.21416e+02,3.89045e-03,7.54741e+02,7.10099e+02,3.93550e-03,7.32560e+02,6.89655e+02,3.98107e-03,7.11027e+02,6.69789e+02,
3.98110e-03,7.11014e+02,6.69777e+02,4.00000e-03,7.02341e+02,6.61770e+02,4.07380e-03,6.69848e+02,6.31746e+02,4.11866e-03,
6.51115e+02,6.14416e+02,4.16869e-03,6.31064e+02,5.95853e+02,4.36189e-03,5.61153e+02,5.30986e+02,4.41570e-03,5.43600e+02,
5.14666e+02,4.47210e-03,5.25493e+02,4.97806e+02,4.51856e-03,5.11194e+02,4.84481e+02,4.57088e-03,4.95723e+02,4.70053e+02,
4.62381e-03,4.80723e+02,4.56052e+02,4.67735e-03,4.66174e+02,4.42462e+02,4.72027e-03,4.54946e+02,4.31968e+02,4.80000e-03,
4.35057e+02,4.13363e+02,5.01187e-03,3.87664e+02,3.68960e+02,5.01190e-03,3.87658e+02,3.68955e+02,5.18800e-03,3.53518e+02,
3.36890e+02,5.22547e-03,3.46720e+02,3.30497e+02,5.24807e-03,3.42705e+02,3.26719e+02,5.30884e-03,3.32222e+02,3.16852e+02,
5.37032e-03,3.22062e+02,3.07282e+02,5.43250e-03,3.12211e+02,2.97998e+02,5.55904e-03,2.93408e+02,2.80259e+02,5.82103e-03,
2.59114e+02,2.47845e+02,5.90797e-03,2.48763e+02,2.38042e+02,6.14000e-03,2.23760e+02,2.14336e+02,6.16595e-03,2.21181e+02,
2.11887e+02,6.23735e-03,2.14290e+02,2.05345e+02,6.30957e-03,2.07616e+02,1.99003e+02,6.30960e-03,2.07613e+02,1.99001e+02,
6.38263e-03,2.01148e+02,1.92856e+02,6.51253e-03,1.90314e+02,1.82550e+02,6.53131e-03,1.88815e+02,1.81123e+02,7.07946e-03,
1.51294e+02,1.45354e+02,7.24436e-03,1.41859e+02,1.36337e+02,7.27644e-03,1.40117e+02,1.34672e+02,7.32824e-03,1.37364e+02,
1.32040e+02,7.49894e-03,1.28799e+02,1.23845e+02,7.67362e-03,1.20770e+02,1.16157e+02,7.94328e-03,1.09652e+02,1.05500e+02,
7.94330e-03,1.09651e+02,1.05500e+02,8.03075e-03,1.06346e+02,1.02330e+02,8.51138e-03,9.04010e+01,8.70220e+01,8.60994e-03,
8.75007e+01,8.42339e+01,8.81049e-03,8.19779e+01,7.89221e+01,9.01571e-03,7.68054e+01,7.39441e+01,1.00000e-02,5.72848e+01,
5.51328e+01,1.00280e-02,5.68289e+01,5.46929e+01,1.01158e-02,5.54287e+01,5.33418e+01,1.02329e-02,5.36330e+01,5.16088e+01,
1.04713e-02,5.02156e+01,4.83094e+01,1.05925e-02,4.85899e+01,4.67394e+01,1.07440e-02,4.66564e+01,4.48715e+01,1.15221e-02,
3.82069e+01,3.67054e+01,1.17490e-02,3.61377e+01,3.47050e+01,1.18850e-02,3.49562e+01,3.35624e+01,1.20226e-02,3.38137e+01,
3.24572e+01,1.21619e-02,3.27088e+01,3.13883e+01,1.24451e-02,3.06073e+01,2.93548e+01,1.25890e-02,2.96101e+01,2.83896e+01,
1.25892e-02,2.96084e+01,2.83879e+01,1.27655e-02,2.84450e+01,2.72619e+01,1.40000e-02,2.18041e+01,2.08345e+01,1.40408e-02,
2.16203e+01,2.06565e+01,1.41254e-02,2.12459e+01,2.02941e+01,1.42889e-02,2.05464e+01,1.96170e+01,1.46218e-02,1.92165e+01,
1.83296e+01,1.49624e-02,1.79739e+01,1.71266e+01,1.50000e-02,1.78433e+01,1.70002e+01,1.55189e-02,1.61667e+01,1.53768e+01,
1.58489e-02,1.52099e+01,1.44509e+01,1.58490e-02,1.52097e+01,1.44507e+01,1.69824e-02,1.24548e+01,1.17854e+01,1.71791e-02,
1.20432e+01,1.13872e+01,1.77329e-02,1.09792e+01,1.03577e+01,1.77828e-02,1.08897e+01,1.02712e+01,1.79887e-02,1.05307e+01,
9.92406e+00,1.81970e-02,1.01835e+01,9.58835e+00,1.99526e-02,7.79586e+00,7.28082e+00,1.99530e-02,7.79543e+00,7.28040e+00,
2.04174e-02,7.29424e+00,6.79657e+00,2.06538e-02,7.05604e+00,6.56667e+00,2.07300e-02,6.98079e+00,6.49404e+00,2.08930e-02,
6.82340e+00,6.34220e+00,2.16272e-02,6.17180e+00,5.71380e+00,2.18776e-02,5.96904e+00,5.51833e+00,2.21309e-02,5.77319e+00,
5.32955e+00,2.26464e-02,5.40125e+00,4.97115e+00,2.45471e-02,4.28479e+00,3.89643e+00,2.51189e-02,4.01241e+00,3.63454e+00,
2.51190e-02,4.01235e+00,3.63447e+00,2.53417e-02,3.91276e+00,3.53886e+00,2.57040e-02,3.75790e+00,3.39031e+00,2.60016e-02,
3.63582e+00,3.27322e+00,2.63027e-02,3.51794e+00,3.16018e+00,2.78612e-02,2.98606e+00,2.65069e+00,2.85102e-02,2.79796e+00,
2.47077e+00,2.95121e-02,2.53932e+00,2.22361e+00,3.00000e-02,2.42568e+00,2.11513e+00,3.16228e-02,2.09649e+00,1.80129e+00,
3.16230e-02,2.09645e+00,1.80125e+00,3.19889e-02,2.03117e+00,1.73922e+00,3.23594e-02,1.96802e+00,1.67926e+00,3.32590e-02,
1.82490e+00,1.54343e+00,3.38844e-02,1.73420e+00,1.45752e+00,3.71535e-02,1.35416e+00,1.09866e+00,3.80189e-02,1.27465e+00,
1.02385e+00,3.93988e-02,1.16200e+00,9.18079e-01,3.98107e-02,1.13132e+00,8.89364e-01,3.98110e-02,1.13130e+00,8.89345e-01,
4.12097e-02,1.03575e+00,8.00416e-01,4.67735e-02,7.57685e-01,5.43268e-01,4.74183e-02,7.33543e-01,5.21108e-01,5.01187e-02,
6.45319e-01,4.40571e-01,5.01190e-02,6.45311e-01,4.40564e-01,5.37032e-02,5.53496e-01,3.58062e-01,5.46780e-02,5.32406e-01,
3.39222e-01,5.62341e-02,5.01623e-01,3.11898e-01,5.88844e-02,4.56416e-01,2.72017e-01,6.02560e-02,4.36052e-01,2.54162e-01,
6.16595e-02,4.17045e-01,2.37566e-01,6.30957e-02,3.99302e-01,2.22143e-01,6.30960e-02,3.99299e-01,2.22140e-01,6.39034e-02,
3.89902e-01,2.14134e-01,6.53131e-02,3.74533e-01,2.01129e-01,6.76083e-02,3.52122e-01,1.82296e-01,7.16143e-02,3.19459e-01,
1.55181e-01,7.58578e-02,2.91739e-01,1.32535e-01,7.67282e-02,2.86774e-01,1.28524e-01,7.67362e-02,2.86729e-01,1.28488e-01,
7.76247e-02,2.81869e-01,1.24588e-01,7.94328e-02,2.72619e-01,1.17209e-01,7.94330e-02,2.72618e-01,1.17208e-01,8.41395e-02,
2.51553e-01,1.01167e-01,8.81049e-02,2.36973e-01,9.03211e-02,9.33254e-02,2.21163e-01,7.88562e-02,9.44061e-02,2.18287e-01,
7.68094e-02,9.54993e-02,2.15499e-01,7.48378e-02,1.00000e-01,2.05170e-01,6.76500e-02,1.02728e-01,1.99515e-01,6.40129e-02,
1.05925e-01,1.93511e-01,6.02440e-02,1.12202e-01,1.83409e-01,5.41163e-02,1.14815e-01,1.79753e-01,5.19727e-02,1.24452e-01,
1.68436e-01,4.56308e-02,1.25577e-01,1.67299e-01,4.50213e-02,1.25890e-01,1.66989e-01,4.48560e-02,1.25893e-01,1.66986e-01,
4.48547e-02,1.31826e-01,1.61277e-01,4.21841e-02,1.34896e-01,1.58634e-01,4.10021e-02,1.44544e-01,1.51427e-01,3.79560e-02,
1.46218e-01,1.50320e-01,3.75132e-02,1.53109e-01,1.46137e-01,3.59026e-02,1.54882e-01,1.45148e-01,3.55369e-02,1.58489e-01,
1.43232e-01,3.48459e-02,1.58490e-01,1.43232e-01,3.48458e-02,1.64059e-01,1.40338e-01,3.40142e-02,1.67262e-01,1.38791e-01,
3.35896e-02,1.69824e-01,1.37607e-01,3.32749e-02,1.75792e-01,1.35033e-01,3.26267e-02,1.77828e-01,1.34206e-01,3.24266e-02,
1.84077e-01,1.31811e-01,3.18692e-02,1.86209e-01,1.31041e-01,3.16970e-02,1.97242e-01,1.27377e-01,3.09240e-02,1.99526e-01,
1.26679e-01,3.07853e-02,1.99530e-01,1.26678e-01,3.07851e-02,2.00000e-01,1.26527e-01,3.07651e-02,2.01837e-01,1.25946e-01,
3.06886e-02,2.04174e-01,1.25224e-01,3.05955e-02,2.08930e-01,1.23816e-01,3.04237e-02,2.18776e-01,1.21115e-01,3.01140e-02,
2.21309e-01,1.20463e-01,3.00430e-02,2.23872e-01,1.19820e-01,2.99741e-02,2.24564e-01,1.19649e-01,2.99560e-02,2.26464e-01,
1.19184e-01,2.99074e-02,2.31740e-01,1.17937e-01,2.97796e-02,2.42661e-01,1.15534e-01,2.95441e-02,2.45471e-01,1.14953e-01,
2.94903e-02,2.51189e-01,1.13811e-01,2.93861e-02,2.51190e-01,1.13811e-01,2.93861e-02,2.54097e-01,1.13212e-01,2.93702e-02,
2.57040e-01,1.12619e-01,2.93544e-02,2.60016e-01,1.12033e-01,2.93386e-02,2.72270e-01,1.09749e-01,2.92742e-02,2.78612e-01,
1.08643e-01,2.92407e-02,2.81838e-01,1.08099e-01,2.92247e-02,2.85102e-01,1.07560e-01,2.92082e-02,2.91743e-01,1.06498e-01,
2.91739e-02,2.98538e-01,1.05456e-01,2.91377e-02,3.00000e-01,1.05238e-01,2.91298e-02,3.09029e-01,1.03929e-01,2.90793e-02,
3.10238e-01,1.03759e-01,2.90724e-02,3.16228e-01,1.02932e-01,2.90375e-02,3.16230e-01,1.02931e-01,2.90375e-02,3.27341e-01,
1.01377e-01,2.90652e-02,3.31131e-01,1.00868e-01,2.90714e-02,3.38844e-01,9.98611e-02,2.90796e-02,3.50752e-01,9.83815e-02,
2.90807e-02,3.54813e-01,9.78960e-02,2.90782e-02,3.58922e-01,9.74149e-02,2.90749e-02,3.67282e-01,9.64637e-02,2.90639e-02,
3.71535e-01,9.59935e-02,2.90562e-02,3.80189e-01,9.50634e-02,2.90368e-02,3.89045e-01,9.41469e-02,2.90119e-02,3.93550e-01,
9.36935e-02,2.89974e-02,3.98107e-01,9.32439e-02,2.89820e-02,3.98110e-01,9.32437e-02,2.89820e-02,4.12098e-01,9.18328e-02,
2.90095e-02,4.21697e-01,9.09083e-02,2.90177e-02,4.26580e-01,9.04509e-02,2.90189e-02,4.31519e-01,8.99965e-02,2.90182e-02,
4.36516e-01,8.95453e-02,2.90156e-02,4.57088e-01,8.77715e-02,2.89882e-02,4.67735e-01,8.69019e-02,2.89639e-02,4.73151e-01,
8.64714e-02,2.89492e-02,4.79510e-01,8.59755e-02,2.89301e-02,4.95450e-01,8.47767e-02,2.88749e-02,5.01187e-01,8.43596e-02,
2.88525e-02,5.01190e-01,8.43594e-02,2.88525e-02,5.12861e-01,8.34853e-02,2.88506e-02,5.24808e-01,8.26220e-02,2.88401e-02,
5.37032e-01,8.17700e-02,2.88219e-02,5.49541e-01,8.09284e-02,2.87957e-02,5.55904e-01,8.05115e-02,2.87797e-02,5.62341e-01,
8.00971e-02,2.87619e-02,5.75440e-01,7.92760e-02,2.87208e-02,5.82103e-01,7.88693e-02,2.86978e-02,6.02560e-01,7.76639e-02,
2.86185e-02,6.16595e-01,7.68722e-02,2.85575e-02,6.30957e-01,7.60897e-02,2.84902e-02,6.30960e-01,7.60896e-02,2.84902e-02,
6.53131e-01,7.48779e-02,2.84400e-02,6.60694e-01,7.44787e-02,2.84192e-02,6.76083e-01,7.36876e-02,2.83720e-02,6.83912e-01,
7.32956e-02,2.83456e-02,6.91831e-01,7.29059e-02,2.83174e-02,7.07946e-01,7.21336e-02,2.82560e-02,7.24436e-01,7.13703e-02,
2.81879e-02,7.41310e-01,7.06159e-02,2.81133e-02,7.58578e-01,6.98702e-02,2.80325e-02,7.76247e-01,6.91334e-02,2.79461e-02,
7.94328e-01,6.84050e-02,2.78540e-02,7.94330e-01,6.84050e-02,2.78540e-02,8.03526e-01,6.80237e-02,2.78211e-02,8.12831e-01,
6.76447e-02,2.77863e-02,8.31764e-01,6.68935e-02,2.77115e-02,8.41395e-01,6.65213e-02,2.76717e-02,8.60994e-01,6.57835e-02,
2.75871e-02,8.70964e-01,6.54178e-02,2.75425e-02,8.81049e-01,6.50544e-02,2.74964e-02,8.91251e-01,6.46930e-02,2.74487e-02,
9.01571e-01,6.43338e-02,2.73997e-02,9.12011e-01,6.39768e-02,2.73493e-02,9.44061e-01,6.29183e-02,2.71899e-02,9.54993e-01,
6.25696e-02,2.71342e-02,9.66051e-01,6.22229e-02,2.70772e-02,9.77237e-01,6.18782e-02,2.70190e-02,9.88553e-01,6.15356e-02,
2.69597e-02,1.00000e+00,6.11950e-02,2.68993e-02,1.00000e-03,3.18223e+03,3.17911e+03,1.02329e-03,2.99942e+03,2.99632e+03,
1.04713e-03,2.82657e+03,2.82350e+03,1.05925e-03,2.74401e+03,2.74096e+03,1.07152e-03,2.66390e+03,2.66085e+03,1.09350e-03,
2.52750e+03,2.52447e+03,1.09648e-03,2.50977e+03,2.50675e+03,1.12202e-03,2.36473e+03,2.36174e+03,1.17490e-03,2.09799e+03,
2.09506e+03,1.18850e-03,2.03605e+03,2.03313e+03,1.20226e-03,1.97595e+03,1.97304e+03,1.25890e-03,1.75198e+03,1.74912e+03,
1.25892e-03,1.75189e+03,1.74903e+03,1.27350e-03,1.69996e+03,1.69712e+03,1.31826e-03,1.55248e+03,1.54967e+03,1.33352e-03,
1.50610e+03,1.50330e+03,1.34586e-03,1.47003e+03,1.46725e+03,1.38038e-03,1.37527e+03,1.37252e+03,1.40512e-03,1.31224e+03,
1.30950e+03,1.45000e-03,1.20764e+03,1.20495e+03,1.47911e-03,1.14562e+03,1.14295e+03,1.50000e-03,1.10379e+03,1.10114e+03,
1.53109e-03,1.04540e+03,1.04277e+03,1.56675e-03,9.83413e+02,9.80812e+02,1.58489e-03,9.53687e+02,9.51100e+02,1.58490e-03,
9.53676e+02,9.51088e+02,1.59746e-03,9.33822e+02,9.31243e+02,1.65959e-03,8.43509e+02,8.40981e+02,1.69824e-03,7.93087e+02,
7.90589e+02,1.75792e-03,7.23134e+02,7.20680e+02,1.78509e-03,6.94064e+02,6.91629e+02,1.80000e-03,6.78793e+02,6.76370e+02,
1.85749e-03,6.23737e+02,6.21354e+02,1.88365e-03,6.00701e+02,5.98339e+02,1.92753e-03,5.64709e+02,5.62380e+02,1.97242e-03,
5.30717e+02,5.28421e+02,1.99526e-03,5.14525e+02,5.12245e+02,1.99530e-03,5.14498e+02,5.12218e+02,2.00977e-03,5.04588e+02,
5.02318e+02,2.04174e-03,4.83607e+02,4.81362e+02,2.06538e-03,4.68837e+02,4.66609e+02,2.16253e-03,4.13921e+02,4.11762e+02,
2.16272e-03,4.13825e+02,4.11666e+02,2.21310e-03,3.88856e+02,3.86734e+02,2.25347e-03,3.70251e+02,3.68158e+02,2.29087e-03,
3.54088e+02,3.52022e+02,2.34331e-03,3.33055e+02,3.31027e+02,2.37137e-03,3.22496e+02,3.20489e+02,2.43034e-03,3.01595e+02,
2.99632e+02,2.48313e-03,2.84420e+02,2.82497e+02,2.51189e-03,2.75649e+02,2.73747e+02,2.51190e-03,2.75645e+02,2.73743e+02,
2.51629e-03,2.74338e+02,2.72440e+02,2.54097e-03,2.67147e+02,2.65268e+02,2.59164e-03,2.53138e+02,2.51299e+02,2.65415e-03,
2.37199e+02,2.35411e+02,2.66073e-03,2.35603e+02,2.33821e+02,2.71750e-03,2.22437e+02,2.20703e+02,2.72270e-03,2.21281e+02,
2.19552e+02,2.77013e-03,2.11020e+02,2.09333e+02,2.80934e-03,2.03018e+02,2.01368e+02,2.85102e-03,1.94956e+02,1.93349e+02,
2.85179e-03,1.94811e+02,1.93205e+02,2.88909e-03,1.87981e+02,1.86416e+02,2.91743e-03,1.83005e+02,1.81473e+02,2.94812e-03,
1.77803e+02,1.76309e+02,2.97252e-03,1.73807e+02,1.72347e+02,2.99906e-03,1.69593e+02,1.68174e+02,3.02156e-03,1.66124e+02,
1.64742e+02,3.04330e-03,1.62857e+02,1.61517e+02,3.06086e-03,1.60275e+02,1.58975e+02,3.07579e-03,1.58117e+02,1.56856e+02,
3.08811e-03,1.56360e+02,1.55135e+02,3.09030e-03,1.56050e+02,1.54833e+02,3.10013e-03,1.54668e+02,1.53484e+02,3.11331e-03,
1.52836e+02,1.51703e+02,3.12608e-03,1.51086e+02,1.50004e+02,3.13877e-03,1.49372e+02,1.48338e+02,3.14853e-03,1.48079e+02,
1.47074e+02,3.15575e-03,1.47137e+02,1.46148e+02,3.16228e-03,1.46300e+02,1.45318e+02,3.16230e-03,1.46297e+02,1.45315e+02,
3.16411e-03,1.46063e+02,1.45083e+02,3.17082e-03,1.45209e+02,1.44230e+02,3.17693e-03,1.44444e+02,1.43460e+02,3.17760e-03,
1.44361e+02,1.43376e+02,3.17760e-03,1.31734e+03,1.19243e+03,3.18053e-03,1.31495e+03,1.19036e+03,3.18733e-03,1.30944e+03,
1.18560e+03,3.19457e-03,1.30360e+03,1.18054e+03,3.20462e-03,1.29558e+03,1.17359e+03,3.22855e-03,1.27681e+03,1.15727e+03,
3.23618e-03,1.27091e+03,1.15214e+03,3.24410e-03,1.26483e+03,1.14685e+03,3.25018e-03,1.26019e+03,1.14282e+03,3.25920e-03,
1.25334e+03,1.13687e+03,3.26615e-03,1.24811e+03,1.13232e+03,3.27644e-03,1.24041e+03,1.12562e+03,3.28699e-03,1.23260e+03,
1.11883e+03,3.29567e-03,1.22621e+03,1.11328e+03,3.31001e-03,1.21578e+03,1.10421e+03,3.31131e-03,1.21484e+03,1.10339e+03,
3.32625e-03,1.20413e+03,1.09408e+03,3.34003e-03,1.19439e+03,1.08560e+03,3.34965e-03,1.18764e+03,1.07973e+03,3.35000e-03,
1.18740e+03,1.07952e+03,3.35723e-03,1.18103e+03,1.07392e+03,3.37771e-03,1.16325e+03,1.05829e+03,3.38844e-03,1.15408e+03,
1.05022e+03,3.42029e-03,1.12747e+03,1.02686e+03,3.46581e-03,1.09089e+03,9.94702e+02,3.53268e-03,1.04010e+03,9.49969e+02,
3.58922e-03,9.99703e+02,9.14307e+02,3.59762e-03,9.93888e+02,9.09167e+02,3.60000e-03,9.92251e+02,9.07720e+02,3.67890e-03,
9.37990e+02,8.59630e+02,3.69864e-03,9.25046e+02,8.48137e+02,3.80189e-03,8.61229e+02,7.91374e+02,3.81855e-03,8.51514e+02,
7.82716e+02,3.84592e-03,8.35872e+02,7.68768e+02,3.89045e-03,8.11254e+02,7.46792e+02,3.96552e-03,7.71996e+02,7.11686e+02,
3.98107e-03,7.64190e+02,7.04697e+02,3.98110e-03,7.64176e+02,7.04684e+02,4.13030e-03,6.94581e+02,6.42232e+02,4.16869e-03,
6.78099e+02,6.27406e+02,4.26579e-03,6.38770e+02,5.91965e+02,4.32877e-03,6.14916e+02,5.70426e+02,4.36516e-03,6.01689e+02,
5.58470e+02,4.46684e-03,5.66768e+02,5.26855e+02,4.58860e-03,5.28541e+02,4.92160e+02,4.67735e-03,5.02892e+02,4.68831e+02,
4.84172e-03,4.59496e+02,4.29255e+02,4.90043e-03,4.45253e+02,4.16237e+02,4.95450e-03,4.32669e+02,4.04725e+02,5.01187e-03,
4.19837e+02,3.92975e+02,5.01190e-03,4.19830e+02,3.92969e+02,5.06991e-03,4.07386e+02,3.81562e+02,5.12861e-03,3.94993e+02,
3.70184e+02,5.18800e-03,3.82980e+02,3.59143e+02,5.27315e-03,3.66614e+02,3.44092e+02,5.62341e-03,3.08530e+02,2.90507e+02,
5.75440e-03,2.90060e+02,2.73408e+02,5.80036e-03,2.83933e+02,2.67730e+02,5.88844e-03,2.72681e+02,2.57293e+02,5.95662e-03,
2.64388e+02,2.49593e+02,6.02560e-03,2.56348e+02,2.42122e+02,6.30957e-03,2.26564e+02,2.14392e+02,6.30960e-03,2.26562e+02,
2.14389e+02,6.55008e-03,2.04475e+02,1.93759e+02,6.60693e-03,1.99687e+02,1.89280e+02,6.68344e-03,1.93482e+02,1.83473e+02,
6.83912e-03,1.81636e+02,1.72373e+02,6.91831e-03,1.75989e+02,1.67077e+02,7.07946e-03,1.65219e+02,1.56965e+02,7.56205e-03,
1.37898e+02,1.31250e+02,7.67362e-03,1.32474e+02,1.26134e+02,7.76247e-03,1.28297e+02,1.22191e+02,7.94328e-03,1.20327e+02,
1.14659e+02,7.94330e-03,1.20326e+02,1.14659e+02,8.03526e-03,1.16530e+02,1.11069e+02,8.12830e-03,1.12854e+02,1.07590e+02,
8.31764e-03,1.05849e+02,1.00956e+02,8.50660e-03,9.94356e+01,9.48773e+01,8.81049e-03,9.01859e+01,8.61001e+01,9.12011e-03,
8.18372e+01,7.81644e+01,9.16914e-03,8.06114e+01,7.69983e+01,9.22571e-03,7.92278e+01,7.56819e+01,9.44061e-03,7.42568e+01,
7.09500e+01,9.54993e-03,7.18904e+01,6.86959e+01,9.77237e-03,6.73830e+01,6.43996e+01,9.91213e-03,6.47463e+01,6.18846e+01,
1.00000e-02,6.31598e+01,6.03710e+01,1.03514e-02,5.73181e+01,5.47940e+01,1.06998e-02,5.21634e+01,4.98663e+01,1.07152e-02,
5.19502e+01,4.96624e+01,1.09648e-02,4.86518e+01,4.65071e+01,1.12202e-02,4.55645e+01,4.35517e+01,1.14577e-02,4.29281e+01,
4.10265e+01,1.16145e-02,4.12995e+01,3.94662e+01,1.23057e-02,3.50412e+01,3.34651e+01,1.24451e-02,3.39376e+01,3.24065e+01,
1.25890e-02,3.28335e+01,3.13469e+01,1.25892e-02,3.28316e+01,3.13451e+01,1.27350e-02,3.17618e+01,3.03182e+01,1.30317e-02,
2.97248e+01,2.83622e+01,1.33352e-02,2.78199e+01,2.65321e+01,1.35926e-02,2.63326e+01,2.51028e+01,1.38038e-02,2.51908e+01,
2.40057e+01,1.50000e-02,1.98470e+01,1.88676e+01,1.50933e-02,1.94976e+01,1.85314e+01,1.51356e-02,1.93419e+01,1.83817e+01,
1.56675e-02,1.74975e+01,1.66072e+01,1.58489e-02,1.69232e+01,1.60546e+01,1.58490e-02,1.69230e+01,1.60544e+01,1.60324e-02,
1.63680e+01,1.55203e+01,1.65959e-02,1.48109e+01,1.40218e+01,1.66077e-02,1.47804e+01,1.39925e+01,1.79887e-02,1.17362e+01,
1.10636e+01,1.84077e-02,1.09828e+01,1.03386e+01,1.89948e-02,1.00243e+01,9.41591e+00,1.90546e-02,9.93300e+00,9.32811e+00,
1.92752e-02,9.60621e+00,9.01372e+00,1.94985e-02,9.29041e+00,8.70992e+00,1.99526e-02,8.69038e+00,8.13270e+00,1.99530e-02,
8.68990e+00,8.13224e+00,2.01837e-02,8.40528e+00,7.85859e+00,2.13796e-02,7.11731e+00,6.62056e+00,2.16272e-02,6.88510e+00,
6.39740e+00,2.21514e-02,6.42633e+00,5.95659e+00,2.23872e-02,6.23359e+00,5.77153e+00,2.31740e-02,5.63940e+00,5.20098e+00,
2.39883e-02,5.10377e+00,4.68689e+00,2.48313e-02,4.62089e+00,4.22366e+00,2.51189e-02,4.47074e+00,4.07967e+00,2.51190e-02,
4.47067e+00,4.07960e+00,2.57040e-02,4.18539e+00,3.80629e+00,2.60016e-02,4.04993e+00,3.67656e+00,2.77393e-02,3.36935e+00,
3.02526e+00,2.78612e-02,3.32779e+00,2.98555e+00,2.91743e-02,2.91894e+00,2.59496e+00,3.09030e-02,2.48186e+00,2.17801e+00,
3.12608e-02,2.40321e+00,2.10306e+00,3.16228e-02,2.32724e+00,2.03070e+00,3.16230e-02,2.32720e+00,2.03066e+00,3.50752e-02,
1.74883e+00,1.48206e+00,3.70425e-02,1.50748e+00,1.25391e+00,3.84592e-02,1.36310e+00,1.11790e+00,3.89045e-02,1.32200e+00,
1.07924e+00,3.98107e-02,1.24395e+00,1.00589e+00,3.98110e-02,1.24393e+00,1.00587e+00,4.33406e-02,9.98169e-01,7.76498e-01,
4.46684e-02,9.24880e-01,7.08502e-01,4.50000e-02,9.07910e-01,6.92782e-01,4.84172e-02,7.57788e-01,5.54117e-01,5.01187e-02,
6.97692e-01,4.98890e-01,5.01190e-02,6.97683e-01,4.98882e-01,5.19578e-02,6.41069e-01,4.47398e-01,5.90219e-02,4.83216e-01,
3.05602e-01,5.95662e-02,4.73988e-01,2.97419e-01,6.16595e-02,4.41229e-01,2.68440e-01,6.23735e-02,4.31044e-01,2.59464e-01,
6.30957e-02,4.21198e-01,2.50803e-01,6.30960e-02,4.21195e-01,2.50800e-01,6.83912e-02,3.60379e-01,1.98503e-01,6.98606e-02,
3.46608e-01,1.86802e-01,7.07946e-02,3.38412e-01,1.79883e-01,7.76247e-02,2.89553e-01,1.39179e-01,7.94328e-02,2.79236e-01,
1.30720e-01,7.94330e-02,2.79235e-01,1.30719e-01,8.12830e-02,2.69417e-01,1.22931e-01,8.19879e-02,2.65897e-01,1.20155e-01,
8.60994e-02,2.47454e-01,1.05800e-01,8.70964e-02,2.43472e-01,1.02738e-01,8.91251e-02,2.35884e-01,9.69440e-02,9.12011e-02,
2.28767e-01,9.15645e-02,9.66051e-02,2.12838e-01,7.97393e-02,1.00000e-01,2.04419e-01,7.36294e-02,1.05925e-01,1.91651e-01,
6.50183e-02,1.07152e-01,1.89320e-01,6.34815e-02,1.07614e-01,1.88466e-01,6.29221e-02,1.10918e-01,1.82702e-01,5.92020e-02,
1.14815e-01,1.76638e-01,5.53780e-02,1.25890e-01,1.62794e-01,4.70578e-02,1.25893e-01,1.62792e-01,4.70563e-02,1.28825e-01,
1.59663e-01,4.54130e-02,1.30317e-01,1.58159e-01,4.46373e-02,1.34896e-01,1.53890e-01,4.24937e-02,1.36719e-01,1.52317e-01,
4.17243e-02,1.41254e-01,1.48669e-01,3.99893e-02,1.46218e-01,1.45077e-01,3.83453e-02,1.47911e-01,1.43936e-01,3.78373e-02,
1.51356e-01,1.41734e-01,3.68770e-02,1.56675e-01,1.38617e-01,3.55654e-02,1.58489e-01,1.37625e-01,3.51600e-02,1.58490e-01,
1.37625e-01,3.51599e-02,1.67880e-01,1.32719e-01,3.35148e-02,1.71791e-01,1.30895e-01,3.29401e-02,1.79887e-01,1.27458e-01,
3.19134e-02,1.80689e-01,1.27141e-01,3.18235e-02,1.81970e-01,1.26642e-01,3.16835e-02,1.84077e-01,1.25841e-01,3.14618e-02,
1.88365e-01,1.24282e-01,3.10426e-02,1.90546e-01,1.23524e-01,3.08441e-02,1.92752e-01,1.22779e-01,3.06526e-02,1.99526e-01,
1.20622e-01,3.01174e-02,1.99530e-01,1.20621e-01,3.01171e-02,2.06538e-01,1.18442e-01,2.97372e-02,2.13796e-01,1.16362e-01,
2.93963e-02,2.16272e-01,1.15693e-01,2.92928e-02,2.18776e-01,1.15033e-01,2.91928e-02,2.26464e-01,1.13111e-01,2.89120e-02,
2.31740e-01,1.11874e-01,2.87391e-02,2.37137e-01,1.10670e-01,2.85763e-02,2.39883e-01,1.10081e-01,2.84983e-02,2.41594e-01,
1.09721e-01,2.84513e-02,2.42661e-01,1.09499e-01,2.84225e-02,2.48313e-01,1.08355e-01,2.82768e-02,2.51189e-01,1.07796e-01,
2.82083e-02,2.51190e-01,1.07796e-01,2.82083e-02,2.54097e-01,1.07208e-01,2.81739e-02,2.60016e-01,1.06051e-01,2.81071e-02,
2.63027e-01,1.05483e-01,2.80746e-02,2.66073e-01,1.04922e-01,2.80426e-02,2.72270e-01,1.03817e-01,2.79797e-02,2.88403e-01,
1.01160e-01,2.78271e-02,2.91743e-01,1.00647e-01,2.77982e-02,3.01995e-01,9.91372e-02,2.77113e-02,3.16228e-01,9.71919e-02,
2.75933e-02,3.16230e-01,9.71916e-02,2.75933e-02,3.19889e-01,9.66871e-02,2.75928e-02,3.27341e-01,9.56912e-02,2.75888e-02,
3.31131e-01,9.52009e-02,2.75861e-02,3.34965e-01,9.47149e-02,2.75824e-02,3.37942e-01,9.43443e-02,2.75787e-02,3.42768e-01,
9.37549e-02,2.75715e-02,3.46737e-01,9.32808e-02,2.75644e-02,3.50752e-01,9.28108e-02,2.75562e-02,3.54813e-01,9.23446e-02,
2.75468e-02,3.67282e-01,9.09690e-02,2.75120e-02,3.71535e-01,9.05185e-02,2.74989e-02,3.80189e-01,8.96281e-02,2.74693e-02,
3.84592e-01,8.91881e-02,2.74529e-02,3.93550e-01,8.83181e-02,2.74166e-02,3.98107e-01,8.78880e-02,2.73968e-02,3.98110e-01,
8.78877e-02,2.73968e-02,4.07380e-01,8.69871e-02,2.74065e-02,4.12098e-01,8.65421e-02,2.74092e-02,4.16869e-01,8.61005e-02,
2.74102e-02,4.26580e-01,8.52267e-02,2.74069e-02,4.36516e-01,8.43653e-02,2.73970e-02,4.46684e-01,8.35159e-02,2.73805e-02,
4.51856e-01,8.30956e-02,2.73698e-02,4.57088e-01,8.26786e-02,2.73581e-02,4.73151e-01,8.14446e-02,2.73136e-02,4.84172e-01,
8.06355e-02,2.72765e-02,4.89779e-01,8.02349e-02,2.72558e-02,5.01187e-01,7.94415e-02,2.72103e-02,5.01190e-01,7.94413e-02,
2.72103e-02,5.18800e-01,7.82062e-02,2.71990e-02,5.24808e-01,7.77997e-02,2.71913e-02,5.30884e-01,7.73958e-02,2.71819e-02,
5.37032e-01,7.69945e-02,2.71705e-02,5.43250e-01,7.65958e-02,2.71574e-02,5.49541e-01,7.61995e-02,2.71425e-02,5.62341e-01,
7.54149e-02,2.71081e-02,5.68853e-01,7.50262e-02,2.70884e-02,5.75440e-01,7.46400e-02,2.70671e-02,5.82103e-01,7.42561e-02,
2.70441e-02,5.88844e-01,7.38747e-02,2.70195e-02,6.02560e-01,7.31187e-02,2.69659e-02,6.09537e-01,7.27444e-02,2.69370e-02,
6.23735e-01,7.20025e-02,2.68750e-02,6.30957e-01,7.16349e-02,2.68419e-02,6.30960e-01,7.16347e-02,2.68419e-02,6.45654e-01,
7.08662e-02,2.68084e-02,6.60694e-01,7.01069e-02,2.67675e-02,6.62370e-01,7.00240e-02,2.67626e-02,6.76083e-01,6.93573e-02,
2.67200e-02,6.83912e-01,6.89859e-02,2.66936e-02,6.91831e-01,6.86167e-02,2.66656e-02,7.07946e-01,6.78850e-02,2.66047e-02,
7.16143e-01,6.75224e-02,2.65719e-02,7.24436e-01,6.71620e-02,2.65376e-02,7.32825e-01,6.68039e-02,2.65019e-02,7.49894e-01,
6.60939e-02,2.64263e-02,7.76247e-01,6.50446e-02,2.63024e-02,7.94328e-01,6.43553e-02,2.62133e-02,7.94330e-01,6.43552e-02,
2.62133e-02,8.03526e-01,6.39953e-02,2.61815e-02,8.22243e-01,6.32819e-02,2.61128e-02,8.45900e-01,6.24148e-02,2.60195e-02,
8.60994e-01,6.18806e-02,2.59567e-02,8.81049e-01,6.11925e-02,2.58698e-02,8.91251e-01,6.08516e-02,2.58244e-02,9.12011e-01,
6.01759e-02,2.57295e-02,9.33254e-01,5.95082e-02,2.56295e-02,9.54993e-01,5.88483e-02,2.55247e-02,9.66051e-01,5.85214e-02,
2.54706e-02,9.77237e-01,5.81964e-02,2.54154e-02,1.00000e+00,5.75521e-02,2.53017e-02,1.00000e-03,4.05544e+03,4.05184e+03,
1.01158e-03,3.93876e+03,3.93518e+03,1.05925e-03,3.50142e+03,3.49791e+03,1.08393e-03,3.30041e+03,3.29693e+03,1.09648e-03,
3.20398e+03,3.20051e+03,1.11000e-03,3.10450e+03,3.10105e+03,1.13501e-03,2.93161e+03,2.92821e+03,1.15000e-03,2.83442e+03,
2.83103e+03,1.18850e-03,2.60289e+03,2.59955e+03,1.21619e-03,2.45263e+03,2.44933e+03,1.24451e-03,2.31040e+03,2.30713e+03,
1.25890e-03,2.24233e+03,2.23907e+03,1.25892e-03,2.24221e+03,2.23895e+03,1.27350e-03,2.17602e+03,2.17278e+03,1.30317e-03,
2.04959e+03,2.04638e+03,1.32111e-03,1.97753e+03,1.97433e+03,1.33352e-03,1.92968e+03,1.92650e+03,1.36458e-03,1.81696e+03,
1.81381e+03,1.42889e-03,1.61008e+03,1.60700e+03,1.47911e-03,1.47033e+03,1.46730e+03,1.50000e-03,1.41681e+03,1.41380e+03,
1.51356e-03,1.38352e+03,1.38052e+03,1.52779e-03,1.34977e+03,1.34679e+03,1.54882e-03,1.30193e+03,1.29896e+03,1.57000e-03,
1.25614e+03,1.25319e+03,1.58489e-03,1.22507e+03,1.22214e+03,1.58490e-03,1.22506e+03,1.22212e+03,1.60325e-03,1.18822e+03,
1.18530e+03,1.62181e-03,1.15250e+03,1.14960e+03,1.65006e-03,1.10083e+03,1.09795e+03,1.67880e-03,1.05148e+03,1.04863e+03,
1.69824e-03,1.01965e+03,1.01681e+03,1.75792e-03,9.29974e+02,9.27187e+02,1.79887e-03,8.74718e+02,8.71964e+02,1.80000e-03,
8.73260e+02,8.70507e+02,1.81970e-03,8.48185e+02,8.45448e+02,1.86209e-03,7.97526e+02,7.94821e+02,1.92753e-03,7.27078e+02,
7.24421e+02,1.94424e-03,7.10405e+02,7.07760e+02,1.99526e-03,6.62648e+02,6.60042e+02,1.99530e-03,6.62614e+02,6.60008e+02,
2.01837e-03,6.42468e+02,6.39880e+02,2.04174e-03,6.22936e+02,6.20365e+02,2.06538e-03,6.03867e+02,6.01314e+02,2.09834e-03,
5.78639e+02,5.76109e+02,2.16272e-03,5.33370e+02,5.30888e+02,2.18776e-03,5.17059e+02,5.14595e+02,2.21310e-03,5.01258e+02,
4.98811e+02,2.27340e-03,4.66122e+02,4.63717e+02,2.34423e-03,4.29031e+02,4.26677e+02,2.37137e-03,4.15796e+02,4.13463e+02,
2.46583e-03,3.73965e+02,3.71696e+02,2.48313e-03,3.66933e+02,3.64676e+02,2.51189e-03,3.55667e+02,3.53430e+02,2.51190e-03,
3.55661e+02,3.53425e+02,2.54097e-03,3.44725e+02,3.42509e+02,2.56042e-03,3.37647e+02,3.35444e+02,2.66073e-03,3.04124e+02,
3.01993e+02,2.66493e-03,3.02824e+02,3.00696e+02,2.69154e-03,2.94764e+02,2.92655e+02,2.72270e-03,2.85619e+02,2.83533e+02,
2.75423e-03,2.76758e+02,2.74694e+02,2.76451e-03,2.73955e+02,2.71897e+02,2.85102e-03,2.51835e+02,2.49839e+02,2.91743e-03,
2.36508e+02,2.34562e+02,2.93320e-03,2.33041e+02,2.31106e+02,2.99586e-03,2.19927e+02,2.18040e+02,3.05492e-03,2.08467e+02,
2.06630e+02,3.11606e-03,1.97475e+02,1.95686e+02,3.12608e-03,1.95748e+02,1.93968e+02,3.16228e-03,1.89630e+02,1.87882e+02,
3.16230e-03,1.89626e+02,1.87878e+02,3.17307e-03,1.87856e+02,1.86118e+02,3.22138e-03,1.80187e+02,1.78493e+02,3.23594e-03,
1.77958e+02,1.76280e+02,3.27341e-03,1.72396e+02,1.70758e+02,3.28489e-03,1.70741e+02,1.69114e+02,3.31048e-03,1.67126e+02,
1.65528e+02,3.34083e-03,1.62970e+02,1.61409e+02,3.34965e-03,1.61786e+02,1.60238e+02,3.38304e-03,1.57398e+02,1.55894e+02,
3.38844e-03,1.56702e+02,1.55207e+02,3.40795e-03,1.54221e+02,1.52757e+02,3.43196e-03,1.51234e+02,1.49812e+02,3.45165e-03,
1.48837e+02,1.47455e+02,3.46849e-03,1.46821e+02,1.45479e+02,3.48239e-03,1.45179e+02,1.43875e+02,3.49665e-03,1.43512e+02,
1.42253e+02,3.50752e-03,1.42255e+02,1.41035e+02,3.51467e-03,1.41438e+02,1.40243e+02,3.53962e-03,1.38632e+02,1.37524e+02,
3.55051e-03,1.37437e+02,1.36360e+02,3.55866e-03,1.36558e+02,1.35498e+02,3.56600e-03,1.35780e+02,1.34728e+02,3.57166e-03,
1.35187e+02,1.34138e+02,3.57890e-03,1.34440e+02,1.33388e+02,3.58330e-03,1.33992e+02,1.32935e+02,3.58330e-03,1.20652e+03,
1.07061e+03,3.58511e-03,1.20505e+03,1.06937e+03,3.59362e-03,1.19822e+03,1.06359e+03,3.60270e-03,1.19099e+03,1.05747e+03,
3.61445e-03,1.18173e+03,1.04962e+03,3.63078e-03,1.16906e+03,1.03885e+03,3.64091e-03,1.16128e+03,1.03223e+03,3.65465e-03,
1.15086e+03,1.02337e+03,3.66411e-03,1.14374e+03,1.01732e+03,3.67282e-03,1.13725e+03,1.01179e+03,3.67859e-03,1.13298e+03,
1.00816e+03,3.69485e-03,1.12106e+03,9.98016e+02,3.70914e-03,1.11072e+03,9.89220e+02,3.72170e-03,1.10174e+03,9.81580e+02,
3.73309e-03,1.09368e+03,9.74720e+02,3.75179e-03,1.08063e+03,9.63610e+02,3.75837e-03,1.07609e+03,9.59739e+02,3.78655e-03,
1.05654e+03,9.43061e+02,3.82935e-03,1.02779e+03,9.18502e+02,3.85893e-03,1.00856e+03,9.02050e+02,3.89045e-03,9.88609e+02,
8.84965e+02,3.91625e-03,9.72694e+02,8.71319e+02,3.93550e-03,9.61045e+02,8.61325e+02,3.98107e-03,9.34244e+02,8.38300e+02,
3.98110e-03,9.34228e+02,8.38285e+02,3.99851e-03,9.23968e+02,8.29448e+02,4.02717e-03,9.07415e+02,8.15179e+02,4.06681e-03,
8.85201e+02,7.96006e+02,4.15167e-03,8.40129e+02,7.57019e+02,4.16869e-03,8.31473e+02,7.49519e+02,4.21696e-03,8.06907e+02,
7.28183e+02,4.26579e-03,7.83044e+02,7.07422e+02,4.26677e-03,7.82579e+02,7.07017e+02,4.36516e-03,7.37412e+02,6.67629e+02,
4.40618e-03,7.19649e+02,6.52116e+02,4.50000e-03,6.81188e+02,6.18460e+02,4.57088e-03,6.53989e+02,5.94598e+02,4.59661e-03,
6.44490e+02,5.86252e+02,4.62381e-03,6.34649e+02,5.77601e+02,4.84686e-03,5.61314e+02,5.12909e+02,4.89779e-03,5.46228e+02,
4.99552e+02,5.00000e-03,5.17583e+02,4.74142e+02,5.01187e-03,5.14392e+02,4.71307e+02,5.01190e-03,5.14384e+02,4.71300e+02,
5.06991e-03,4.99178e+02,4.57780e+02,5.11756e-03,4.87150e+02,4.47074e+02,5.12861e-03,4.84416e+02,4.44638e+02,5.18800e-03,
4.70092e+02,4.31869e+02,5.30884e-03,4.42699e+02,4.07402e+02,5.45355e-03,4.12728e+02,3.80556e+02,5.62341e-03,3.81017e+02,
3.52065e+02,5.65000e-03,3.76358e+02,3.47871e+02,5.82103e-03,3.47382e+02,3.21716e+02,5.88507e-03,3.37322e+02,3.12618e+02,
5.88844e-03,3.36803e+02,3.12148e+02,5.95662e-03,3.26548e+02,3.02862e+02,6.02560e-03,3.16606e+02,2.93850e+02,6.09537e-03,
3.06966e+02,2.85101e+02,6.16595e-03,2.97620e+02,2.76611e+02,6.30957e-03,2.79778e+02,2.60382e+02,6.30960e-03,2.79775e+02,
2.60379e+02,6.35835e-03,2.74053e+02,2.55167e+02,6.53131e-03,2.55003e+02,2.37789e+02,6.76083e-03,2.32411e+02,2.17123e+02,
6.83912e-03,2.25336e+02,2.10637e+02,6.99842e-03,2.11828e+02,1.98239e+02,7.00000e-03,2.11700e+02,1.98121e+02,7.07946e-03,
2.05382e+02,1.92313e+02,7.16143e-03,1.99000e+02,1.86438e+02,7.22778e-03,1.94033e+02,1.81861e+02,7.58578e-03,1.69955e+02,
1.59632e+02,7.94328e-03,1.49797e+02,1.40956e+02,7.94330e-03,1.49796e+02,1.40955e+02,8.00000e-03,1.46904e+02,1.38271e+02,
8.00029e-03,1.46890e+02,1.38257e+02,8.12830e-03,1.40636e+02,1.32448e+02,8.22243e-03,1.36268e+02,1.28388e+02,8.51138e-03,
1.23829e+02,1.16802e+02,8.91251e-03,1.09000e+02,1.02956e+02,9.17827e-03,1.00478e+02,9.49802e+01,9.33254e-03,9.59442e+01,
9.07319e+01,9.50000e-03,9.13333e+01,8.64076e+01,9.54993e-03,8.99969e+01,8.51531e+01,1.00000e-02,7.90695e+01,7.48815e+01,
1.01158e-02,7.65529e+01,7.25124e+01,1.02256e-02,7.42671e+01,7.03599e+01,1.04713e-02,6.94755e+01,6.58449e+01,1.09648e-02,
6.10452e+01,5.78884e+01,1.10918e-02,5.91037e+01,5.60535e+01,1.12202e-02,5.72245e+01,5.42767e+01,1.13501e-02,5.54055e+01,
5.25559e+01,1.14115e-02,5.45729e+01,5.17679e+01,1.15000e-02,5.34030e+01,5.06609e+01,1.20226e-02,4.70563e+01,4.46470e+01,
1.22938e-02,4.41637e+01,4.19025e+01,1.23027e-02,4.40733e+01,4.18167e+01,1.25890e-02,4.12798e+01,3.91651e+01,1.25892e-02,
4.12775e+01,3.91629e+01,1.28825e-02,3.86603e+01,3.66767e+01,1.31826e-02,3.62107e+01,3.43479e+01,1.33352e-02,3.50453e+01,
3.32394e+01,1.34896e-02,3.39178e+01,3.21666e+01,1.35816e-02,3.32694e+01,3.15494e+01,1.40000e-02,3.05235e+01,2.89355e+01,
1.44544e-02,2.78452e+01,2.63832e+01,1.46218e-02,2.69393e+01,2.55194e+01,1.46323e-02,2.68836e+01,2.54663e+01,1.51356e-02,
2.43930e+01,2.30913e+01,1.56675e-02,2.20900e+01,2.08935e+01,1.58489e-02,2.13725e+01,2.02084e+01,1.58490e-02,2.13722e+01,
2.02081e+01,1.60324e-02,2.06784e+01,1.95456e+01,1.62569e-02,1.98709e+01,1.87743e+01,1.69824e-02,1.75348e+01,1.65434e+01,
1.73780e-02,1.64042e+01,1.54627e+01,1.75792e-02,1.58664e+01,1.49487e+01,1.79469e-02,1.49444e+01,1.40670e+01,1.79887e-02,
1.48441e+01,1.39712e+01,1.88365e-02,1.29950e+01,1.22033e+01,1.90546e-02,1.25706e+01,1.17974e+01,1.92752e-02,1.21604e+01,
1.14050e+01,1.99526e-02,1.10098e+01,1.03044e+01,1.99530e-02,1.10092e+01,1.03038e+01,2.06409e-02,9.98771e+00,9.32688e+00,
2.06538e-02,9.96982e+00,9.30978e+00,2.13796e-02,9.01890e+00,8.40051e+00,2.16272e-02,8.72302e+00,8.11758e+00,2.23872e-02,
7.89377e+00,7.32465e+00,2.31740e-02,7.14547e+00,6.60917e+00,2.34423e-02,6.91263e+00,6.38656e+00,2.41605e-02,6.33883e+00,
5.83802e+00,2.48313e-02,5.86047e+00,5.38104e+00,2.51189e-02,5.67055e+00,5.19964e+00,2.51190e-02,5.67046e+00,5.19955e+00,
2.60016e-02,5.13293e+00,4.68630e+00,2.69154e-02,4.64820e+00,4.22367e+00,2.88403e-02,3.81714e+00,3.43109e+00,2.91743e-02,
3.69460e+00,3.31432e+00,2.95121e-02,3.57622e+00,3.20152e+00,3.01995e-02,3.35135e+00,2.98735e+00,3.03997e-02,3.28960e+00,
2.92854e+00,3.09030e-02,3.14123e+00,2.78737e+00,3.12608e-02,3.04051e+00,2.69152e+00,3.16228e-02,2.94322e+00,2.59897e+00,
3.16230e-02,2.94316e+00,2.59892e+00,3.23594e-02,2.75824e+00,2.42339e+00,3.54813e-02,2.13449e+00,1.83244e+00,3.67282e-02,
1.94177e+00,1.65030e+00,3.75837e-02,1.82390e+00,1.53904e+00,3.84592e-02,1.71393e+00,1.43533e+00,3.89045e-02,1.66174e+00,
1.38615e+00,3.93945e-02,1.60651e+00,1.33412e+00,3.98107e-02,1.56168e+00,1.29196e+00,3.98110e-02,1.56165e+00,1.29193e+00,
4.07380e-02,1.46812e+00,1.20429e+00,4.57088e-02,1.08675e+00,8.48442e-01,4.78630e-02,9.67589e-01,7.37905e-01,4.80230e-02,
9.59578e-01,7.30489e-01,4.95450e-02,8.88371e-01,6.64747e-01,5.00000e-02,8.68745e-01,6.46659e-01,5.01187e-02,8.63702e-01,
6.42010e-01,5.01190e-02,8.63691e-01,6.41999e-01,5.53857e-02,6.80206e-01,4.74667e-01,5.75440e-02,6.23261e-01,4.23268e-01,
6.09537e-02,5.48905e-01,3.56559e-01,6.23735e-02,5.22572e-01,3.33066e-01,6.30957e-02,5.10071e-01,3.21941e-01,6.30960e-02,
5.10067e-01,3.21937e-01,6.49703e-02,4.79905e-01,2.95486e-01,6.60693e-02,4.63726e-01,2.81390e-01,6.76083e-02,4.42660e-01,
2.63088e-01,7.16143e-02,3.95880e-01,2.22770e-01,7.41310e-02,3.71391e-01,2.01872e-01,7.49894e-02,3.63766e-01,1.95400e-01,
7.57521e-02,3.57274e-01,1.89904e-01,7.94328e-02,3.29202e-01,1.66361e-01,7.94330e-02,3.29200e-01,1.66360e-01,8.31764e-02,
3.05068e-01,1.46811e-01,8.41395e-02,2.99516e-01,1.42356e-01,8.60994e-02,2.88944e-01,1.33921e-01,9.33254e-02,2.56924e-01,
1.08838e-01,9.54993e-02,2.49029e-01,1.02781e-01,9.79234e-02,2.40989e-01,9.66742e-02,1.00000e-01,2.34657e-01,9.19256e-02,
1.01158e-01,2.31255e-01,8.94913e-02,1.02329e-01,2.27956e-01,8.71459e-02,1.04713e-01,2.21656e-01,8.27079e-02,1.14815e-01,
1.99926e-01,6.78890e-02,1.17945e-01,1.94500e-01,6.43308e-02,1.20226e-01,1.90844e-01,6.19783e-02,1.21619e-01,1.88730e-01,
6.06330e-02,1.25890e-01,1.82747e-01,5.68872e-02,1.25893e-01,1.82743e-01,5.68851e-02,1.33352e-01,1.73494e-01,5.16894e-02,
1.34896e-01,1.71789e-01,5.07626e-02,1.41254e-01,1.65404e-01,4.73856e-02,1.42889e-01,1.63909e-01,4.66178e-02,1.46218e-01,
1.61032e-01,4.51666e-02,1.53109e-01,1.55719e-01,4.25953e-02,1.55177e-01,1.54266e-01,4.19151e-02,1.56675e-01,1.53248e-01,
4.14458e-02,1.58489e-01,1.52054e-01,4.09021e-02,1.58490e-01,1.52054e-01,4.09020e-02,1.64059e-01,1.48466e-01,3.94990e-02,
1.65959e-01,1.47322e-01,3.90655e-02,1.73780e-01,1.42988e-01,3.74852e-02,1.77828e-01,1.40955e-01,3.67793e-02,1.81970e-01,
1.39005e-01,3.61237e-02,1.86209e-01,1.37140e-01,3.55224e-02,1.88365e-01,1.36235e-01,3.52380e-02,1.94984e-01,1.33623e-01,
3.44432e-02,1.99526e-01,1.31961e-01,3.39584e-02,1.99530e-01,1.31960e-01,3.39581e-02,2.00000e-01,1.31783e-01,3.39182e-02,
2.08133e-01,1.28893e-01,3.32857e-02,2.13796e-01,1.27037e-01,3.29020e-02,2.18776e-01,1.25500e-01,3.25970e-02,2.21309e-01,
1.24750e-01,3.24521e-02,2.23872e-01,1.24012e-01,3.23123e-02,2.31740e-01,1.21874e-01,3.19274e-02,2.39883e-01,1.19828e-01,
3.15770e-02,2.42661e-01,1.19166e-01,3.14670e-02,2.48313e-01,1.17869e-01,3.12563e-02,2.51189e-01,1.17233e-01,3.11553e-02,
2.51190e-01,1.17233e-01,3.11552e-02,2.57040e-01,1.15909e-01,3.10299e-02,2.60016e-01,1.15259e-01,3.09697e-02,2.69154e-01,
1.13365e-01,3.08035e-02,2.75423e-01,1.12140e-01,3.06982e-02,2.78011e-01,1.11651e-01,3.06564e-02,2.95121e-01,1.08627e-01,
3.04014e-02,2.98538e-01,1.08063e-01,3.03541e-02,3.00000e-01,1.07827e-01,3.03348e-02,3.01995e-01,1.07508e-01,3.03088e-02,
3.05492e-01,1.06958e-01,3.02637e-02,3.09029e-01,1.06414e-01,3.02189e-02,3.16228e-01,1.05342e-01,3.01300e-02,3.16230e-01,
1.05342e-01,3.01300e-02,3.23594e-01,1.04227e-01,3.01043e-02,3.31131e-01,1.03133e-01,3.00755e-02,3.34965e-01,1.02594e-01,
3.00600e-02,3.38844e-01,1.02060e-01,3.00436e-02,3.42768e-01,1.01532e-01,3.00277e-02,3.46737e-01,1.01009e-01,3.00108e-02,
3.54813e-01,9.99760e-02,2.99743e-02,3.63078e-01,9.89613e-02,2.99340e-02,3.71535e-01,9.79640e-02,2.98900e-02,3.80189e-01,
9.69832e-02,2.98423e-02,3.84592e-01,9.64998e-02,2.98180e-02,3.89045e-01,9.60203e-02,2.97926e-02,3.93550e-01,9.55446e-02,
2.97663e-02,3.98107e-01,9.50727e-02,2.97389e-02,3.98110e-01,9.50724e-02,2.97390e-02,4.07674e-01,9.40546e-02,2.97376e-02,
4.12098e-01,9.35969e-02,2.97345e-02,4.16869e-01,9.31124e-02,2.97296e-02,4.21697e-01,9.26315e-02,2.97231e-02,4.26580e-01,
9.21550e-02,2.97156e-02,4.31519e-01,9.16821e-02,2.97064e-02,4.51856e-01,8.98246e-02,2.96535e-02,4.62381e-01,8.89158e-02,
2.96176e-02,4.67735e-01,8.84662e-02,2.95974e-02,4.73151e-01,8.80203e-02,2.95763e-02,4.78630e-01,8.75775e-02,2.95536e-02,
4.89779e-01,8.67009e-02,2.95040e-02,4.95450e-01,8.62671e-02,2.94770e-02,5.01187e-01,8.58362e-02,2.94486e-02,5.01190e-01,
8.58359e-02,2.94486e-02,5.12861e-01,8.49334e-02,2.94344e-02,5.18800e-01,8.44871e-02,2.94247e-02,5.24808e-01,8.40437e-02,
2.94131e-02,5.30884e-01,8.36032e-02,2.93995e-02,5.43250e-01,8.27310e-02,2.93667e-02,5.62341e-01,8.14438e-02,2.93040e-02,
5.68853e-01,8.10207e-02,2.92800e-02,5.75440e-01,8.06002e-02,2.92542e-02,5.88844e-01,7.97672e-02,2.91978e-02,5.95662e-01,
7.93547e-02,2.91671e-02,6.16595e-01,7.81324e-02,2.90659e-02,6.23735e-01,7.77303e-02,2.90295e-02,6.30957e-01,7.73306e-02,
2.89917e-02,6.30960e-01,7.73305e-02,2.89917e-02,6.38264e-01,7.69135e-02,2.89738e-02,6.53131e-01,7.60870e-02,2.89322e-02,
6.68344e-01,7.52707e-02,2.88828e-02,6.76083e-01,7.48664e-02,2.88554e-02,6.83912e-01,7.44648e-02,2.88264e-02,6.91831e-01,
7.40656e-02,2.87957e-02,6.97831e-01,7.37679e-02,2.87714e-02,7.16143e-01,7.28825e-02,2.86932e-02,7.24436e-01,7.24929e-02,
2.86557e-02,7.32825e-01,7.21057e-02,2.86167e-02,7.41310e-01,7.17210e-02,2.85763e-02,7.49894e-01,7.13385e-02,2.85344e-02,
7.58578e-01,7.09584e-02,2.84910e-02,7.85236e-01,6.98315e-02,2.83523e-02,7.94328e-01,6.94603e-02,2.83034e-02,7.94330e-01,
6.94602e-02,2.83034e-02,8.03526e-01,6.90705e-02,2.82681e-02,8.12831e-01,6.86833e-02,2.82312e-02,8.22243e-01,6.82985e-02,
2.81926e-02,8.31764e-01,6.79160e-02,2.81523e-02,8.51138e-01,6.71580e-02,2.80666e-02,8.60994e-01,6.67824e-02,2.80214e-02,
8.70964e-01,6.64091e-02,2.79747e-02,8.91251e-01,6.56692e-02,2.78767e-02,9.01571e-01,6.53027e-02,2.78257e-02,9.12011e-01,
6.49385e-02,2.77733e-02,9.22571e-01,6.45764e-02,2.77195e-02,9.66051e-01,6.31494e-02,2.74914e-02,9.77237e-01,6.27981e-02,
2.74314e-02,9.88553e-01,6.24488e-02,2.73702e-02,1.00000e+00,6.21016e-02,2.73079e-02,1.00000e-03,4.86337e+03,4.85923e+03,
1.05925e-03,4.20493e+03,4.20092e+03,1.07152e-03,4.08369e+03,4.07971e+03,1.08393e-03,3.96555e+03,3.96160e+03,1.09648e-03,
3.85032e+03,3.84639e+03,1.10918e-03,3.73853e+03,3.73462e+03,1.11658e-03,3.67541e+03,3.67152e+03,1.13501e-03,3.52467e+03,
3.52081e+03,1.20226e-03,3.04317e+03,3.03943e+03,1.21619e-03,2.95447e+03,2.95076e+03,1.23027e-03,2.86743e+03,2.86373e+03,
1.25890e-03,2.70125e+03,2.69759e+03,1.25892e-03,2.70111e+03,2.69746e+03,1.30317e-03,2.46983e+03,2.46624e+03,1.31271e-03,
2.42371e+03,2.42014e+03,1.35000e-03,2.25444e+03,2.25092e+03,1.36458e-03,2.19278e+03,2.18928e+03,1.38038e-03,2.12826e+03,
2.12478e+03,1.39637e-03,2.06515e+03,2.06169e+03,1.40000e-03,2.05118e+03,2.04772e+03,1.42889e-03,1.94417e+03,1.94075e+03,
1.50156e-03,1.70764e+03,1.70431e+03,1.53109e-03,1.62286e+03,1.61956e+03,1.54882e-03,1.57489e+03,1.57161e+03,1.56675e-03,
1.52804e+03,1.52478e+03,1.57000e-03,1.51976e+03,1.51650e+03,1.58489e-03,1.48230e+03,1.47906e+03,1.58490e-03,1.48228e+03,
1.47904e+03,1.59493e-03,1.45769e+03,1.45446e+03,1.60325e-03,1.43772e+03,1.43450e+03,1.73178e-03,1.17263e+03,1.16954e+03,
1.77828e-03,1.09334e+03,1.09029e+03,1.79887e-03,1.06049e+03,1.05746e+03,1.80000e-03,1.05873e+03,1.05570e+03,1.81970e-03,
1.02843e+03,1.02542e+03,1.84077e-03,9.97201e+02,9.94210e+02,1.95739e-03,8.46467e+02,8.43574e+02,1.99526e-03,8.04278e+02,
8.01418e+02,1.99530e-03,8.04237e+02,8.01377e+02,2.01837e-03,7.79955e+02,7.77114e+02,2.04174e-03,7.56287e+02,7.53466e+02,
2.06538e-03,7.33343e+02,7.30540e+02,2.08930e-03,7.10967e+02,7.08183e+02,2.11349e-03,6.89223e+02,6.86458e+02,2.11490e-03,
6.87989e+02,6.85225e+02,2.13796e-03,6.68164e+02,6.65419e+02,2.29087e-03,5.54946e+02,5.52315e+02,2.29382e-03,5.53037e+02,
5.50408e+02,2.31740e-03,5.38091e+02,5.35481e+02,2.37137e-03,5.05664e+02,5.03094e+02,2.40000e-03,4.89473e+02,4.86924e+02,
2.45471e-03,4.60405e+02,4.57894e+02,2.47899e-03,4.48278e+02,4.45783e+02,2.48313e-03,4.46251e+02,4.43760e+02,2.51189e-03,
4.32552e+02,4.30082e+02,2.51190e-03,4.32546e+02,4.30075e+02,2.60016e-03,3.93934e+02,3.91525e+02,2.63027e-03,3.81872e+02,
3.79483e+02,2.66073e-03,3.70183e+02,3.67814e+02,2.68380e-03,3.61597e+02,3.59243e+02,2.75423e-03,3.37014e+02,3.34709e+02,
2.78612e-03,3.26594e+02,3.24310e+02,2.85102e-03,3.06686e+02,3.04444e+02,2.88403e-03,2.97207e+02,2.94985e+02,2.89371e-03,
2.94505e+02,2.92289e+02,2.95121e-03,2.79124e+02,2.76947e+02,3.00000e-03,2.66940e+02,2.64794e+02,3.00434e-03,2.65893e+02,
2.63749e+02,3.05492e-03,2.54089e+02,2.51980e+02,3.11499e-03,2.40910e+02,2.38839e+02,3.16228e-03,2.31182e+02,2.29143e+02,
3.16230e-03,2.31177e+02,2.29139e+02,3.19889e-03,2.24015e+02,2.22000e+02,3.20142e-03,2.23530e+02,2.21517e+02,3.23594e-03,
2.17050e+02,2.15060e+02,3.27341e-03,2.10291e+02,2.08327e+02,3.27930e-03,2.09256e+02,2.07295e+02,3.34965e-03,1.97413e+02,
1.95502e+02,3.36373e-03,1.95155e+02,1.93253e+02,3.38844e-03,1.91273e+02,1.89391e+02,3.42768e-03,1.85328e+02,1.83474e+02,
3.48880e-03,1.76567e+02,1.74757e+02,3.50752e-03,1.73996e+02,1.72200e+02,3.55184e-03,1.68075e+02,1.66315e+02,3.60862e-03,
1.60880e+02,1.59167e+02,3.68113e-03,1.52281e+02,1.50635e+02,3.71535e-03,1.48435e+02,1.46823e+02,3.71720e-03,1.48230e+02,
1.46620e+02,3.75027e-03,1.44634e+02,1.43061e+02,3.75837e-03,1.43770e+02,1.42206e+02,3.79754e-03,1.39683e+02,1.38167e+02,
3.80189e-03,1.39238e+02,1.37728e+02,3.82192e-03,1.37216e+02,1.35734e+02,3.84589e-03,1.34843e+02,1.33399e+02,3.86749e-03,
1.32747e+02,1.31342e+02,3.88636e-03,1.30945e+02,1.29580e+02,3.89045e-03,1.30557e+02,1.29202e+02,3.90193e-03,1.29477e+02,
1.28150e+02,3.91698e-03,1.28074e+02,1.26788e+02,3.93494e-03,1.26420e+02,1.25188e+02,3.93550e-03,1.26369e+02,1.25139e+02,
3.96554e-03,1.23665e+02,1.22527e+02,3.97826e-03,1.22551e+02,1.21444e+02,3.98107e-03,1.22308e+02,1.21206e+02,3.98110e-03,
1.22306e+02,1.21204e+02,3.98739e-03,1.21765e+02,1.20674e+02,3.99796e-03,1.20872e+02,1.19792e+02,4.00644e-03,1.20170e+02,
1.19090e+02,4.01034e-03,1.19850e+02,1.18769e+02,4.01500e-03,1.19473e+02,1.18387e+02,4.01500e-03,1.03293e+03,8.97189e+02,
4.01620e-03,1.03226e+03,8.96646e+02,4.02206e-03,1.02902e+03,8.94005e+02,4.02863e-03,1.02540e+03,8.91054e+02,4.03775e-03,
1.02043e+03,8.86986e+02,4.04300e-03,1.01758e+03,8.84654e+02,4.05246e-03,1.01247e+03,8.80476e+02,4.07950e-03,9.98099e+02,
8.68679e+02,4.08914e-03,9.93049e+02,8.64532e+02,4.10558e-03,9.84519e+02,8.57524e+02,4.12294e-03,9.75621e+02,8.50215e+02,
4.13564e-03,9.69177e+02,8.44922e+02,4.14691e-03,9.63508e+02,8.40264e+02,4.15840e-03,9.57782e+02,8.35559e+02,4.16869e-03,
9.52685e+02,8.31372e+02,4.17719e-03,9.47981e+02,8.27477e+02,4.20944e-03,9.30416e+02,8.12928e+02,4.23312e-03,9.17799e+02,
8.02468e+02,4.25847e-03,9.04561e+02,7.91482e+02,4.27000e-03,8.98628e+02,7.86556e+02,4.28733e-03,8.89536e+02,7.78989e+02,
4.31519e-03,8.75179e+02,7.67030e+02,4.34772e-03,8.58818e+02,7.53384e+02,4.36516e-03,8.50223e+02,7.46209e+02,4.41489e-03,
8.26355e+02,7.26298e+02,4.41570e-03,8.25973e+02,7.25979e+02,4.48707e-03,7.93354e+02,6.98701e+02,4.51856e-03,7.79531e+02,
6.87118e+02,4.57088e-03,7.57302e+02,6.68459e+02,4.60389e-03,7.43732e+02,6.57049e+02,4.62381e-03,7.35706e+02,6.50294e+02,
4.67735e-03,7.14705e+02,6.32592e+02,4.72027e-03,6.97860e+02,6.18341e+02,4.87737e-03,6.40678e+02,5.69794e+02,5.01187e-03,
5.96749e+02,5.32314e+02,5.01190e-03,5.96740e+02,5.32306e+02,5.06637e-03,5.80132e+02,5.18091e+02,5.06991e-03,5.79077e+02,
5.17188e+02,5.18800e-03,5.45285e+02,4.88187e+02,5.24807e-03,5.29141e+02,4.74293e+02,5.30884e-03,5.13477e+02,4.60788e+02,
5.57400e-03,4.52097e+02,4.07638e+02,5.80000e-03,4.07522e+02,3.68794e+02,5.82103e-03,4.03688e+02,3.65443e+02,5.96735e-03,
3.78355e+02,3.43256e+02,6.09537e-03,3.57957e+02,3.25339e+02,6.16595e-03,3.47350e+02,3.16001e+02,6.30957e-03,3.27072e+02,
2.98111e+02,6.30960e-03,3.27069e+02,2.98107e+02,6.48798e-03,3.03440e+02,2.77186e+02,6.68344e-03,2.80157e+02,2.56501e+02,
7.00000e-03,2.47377e+02,2.27250e+02,7.00016e-03,2.47362e+02,2.27236e+02,7.07946e-03,2.39977e+02,2.20625e+02,7.16143e-03,
2.32657e+02,2.14064e+02,7.24436e-03,2.25562e+02,2.07696e+02,7.76247e-03,1.87329e+02,1.73242e+02,7.87493e-03,1.80225e+02,
1.66812e+02,7.94328e-03,1.76087e+02,1.63063e+02,7.94330e-03,1.76085e+02,1.63062e+02,8.12830e-03,1.65292e+02,1.53263e+02,
8.22243e-03,1.60142e+02,1.48580e+02,8.31764e-03,1.55152e+02,1.44038e+02,8.51138e-03,1.45638e+02,1.35363e+02,8.76888e-03,
1.34188e+02,1.24901e+02,9.01571e-03,1.24337e+02,1.15878e+02,9.12011e-03,1.20468e+02,1.12329e+02,9.54993e-03,1.06164e+02,
9.91775e+01,9.75206e-03,1.00148e+02,9.36293e+01,9.77237e-03,9.95688e+01,9.30952e+01,1.00000e-02,9.33849e+01,8.73839e+01,
1.05925e-02,7.95624e+01,7.45862e+01,1.08393e-02,7.46277e+01,7.00047e+01,1.09305e-02,7.29092e+01,6.84076e+01,1.09648e-02,
7.22770e+01,6.78200e+01,1.12202e-02,6.77409e+01,6.35992e+01,1.14815e-02,6.34873e+01,5.96357e+01,1.17490e-02,5.95030e+01,
5.59181e+01,1.20942e-02,5.48475e+01,5.15679e+01,1.25890e-02,4.89998e+01,4.60954e+01,1.25892e-02,4.89970e+01,4.60928e+01,
1.28825e-02,4.59273e+01,4.32155e+01,1.30317e-02,4.44659e+01,4.18446e+01,1.31826e-02,4.30321e+01,4.04984e+01,1.33352e-02,
4.16437e+01,3.91941e+01,1.34896e-02,4.03004e+01,3.79315e+01,1.38038e-02,3.77427e+01,3.55267e+01,1.49060e-02,3.03369e+01,
2.85496e+01,1.50000e-02,2.98000e+01,2.80432e+01,1.54882e-02,2.72099e+01,2.55984e+01,1.56675e-02,2.63355e+01,2.47724e+01,
1.58489e-02,2.54779e+01,2.39617e+01,1.58490e-02,2.54776e+01,2.39614e+01,1.60324e-02,2.46485e+01,2.31775e+01,1.60555e-02,
2.45468e+01,2.30813e+01,1.64059e-02,2.30701e+01,2.16850e+01,1.77034e-02,1.85449e+01,1.74002e+01,1.79887e-02,1.77149e+01,
1.66138e+01,1.84077e-02,1.65852e+01,1.55429e+01,1.86209e-02,1.60481e+01,1.50336e+01,1.88365e-02,1.55282e+01,1.45404e+01,
1.90546e-02,1.50254e+01,1.40634e+01,1.94985e-02,1.40576e+01,1.31447e+01,1.97459e-02,1.35548e+01,1.26672e+01,1.99526e-02,
1.31532e+01,1.22860e+01,1.99530e-02,1.31525e+01,1.22853e+01,2.16272e-02,1.04281e+01,9.69793e+00,2.21309e-02,9.76110e+00,
9.06404e+00,2.23034e-02,9.54608e+00,8.85966e+00,2.23872e-02,9.44382e+00,8.76250e+00,2.26464e-02,9.13699e+00,8.47098e+00,
2.31740e-02,8.55369e+00,7.91669e+00,2.37137e-02,8.00262e+00,7.39278e+00,2.51189e-02,6.77956e+00,6.22976e+00,2.51190e-02,
6.77945e+00,6.22966e+00,2.60822e-02,6.08543e+00,5.57019e+00,2.66073e-02,5.74791e+00,5.24968e+00,2.72270e-02,5.38174e+00,
4.90197e+00,2.75423e-02,5.20784e+00,4.73686e+00,2.78612e-02,5.03979e+00,4.57731e+00,2.85102e-02,4.72042e+00,4.27414e+00,
2.91743e-02,4.41916e+00,3.98812e+00,2.98538e-02,4.13802e+00,3.72126e+00,3.16228e-02,3.51459e+00,3.12981e+00,3.16230e-02,
3.51452e+00,3.12975e+00,3.23594e-02,3.29358e+00,2.92055e+00,3.27341e-02,3.18858e+00,2.82116e+00,3.38844e-02,2.89444e+00,
2.54290e+00,3.42768e-02,2.80296e+00,2.45640e+00,3.50752e-02,2.62917e+00,2.29216e+00,3.54813e-02,2.54667e+00,2.21422e+00,
3.65008e-02,2.35357e+00,2.03185e+00,3.93550e-02,1.91350e+00,1.61722e+00,3.98107e-02,1.85454e+00,1.56176e+00,3.98110e-02,
1.85451e+00,1.56173e+00,4.00000e-02,1.83080e+00,1.53948e+00,4.02717e-02,1.79749e+00,1.50825e+00,4.16869e-02,1.63775e+00,
1.35857e+00,4.33015e-02,1.48014e+00,1.21116e+00,4.41570e-02,1.40565e+00,1.14169e+00,4.46684e-02,1.36383e+00,1.10271e+00,
4.50000e-02,1.33771e+00,1.07838e+00,4.89779e-02,1.07450e+00,8.33786e-01,4.95450e-02,1.04363e+00,8.05193e-01,5.01187e-02,
1.01381e+00,7.77602e-01,5.01190e-02,1.01380e+00,7.77588e-01,5.12861e-02,9.57011e-01,7.25351e-01,5.32671e-02,8.71673e-01,
6.47064e-01,5.88844e-02,6.87270e-01,4.79299e-01,6.16261e-02,6.19684e-01,4.18272e-01,6.23735e-02,6.03245e-01,4.03511e-01,
6.30957e-02,5.88082e-01,3.89915e-01,6.30960e-02,5.88076e-01,3.89910e-01,6.53131e-02,5.45319e-01,3.52060e-01,6.76083e-02,
5.06734e-01,3.18091e-01,7.07946e-02,4.61073e-01,2.78170e-01,7.24436e-02,4.40474e-01,2.60275e-01,7.29703e-02,4.34279e-01,
2.54908e-01,7.67362e-02,3.94597e-01,2.20818e-01,7.94328e-02,3.70565e-01,2.00355e-01,7.94330e-02,3.70563e-01,2.00354e-01,
8.31764e-02,3.41700e-01,1.76461e-01,8.41395e-02,3.35059e-01,1.71008e-01,8.60994e-02,3.22377e-01,1.60640e-01,8.81049e-02,
3.10506e-01,1.51003e-01,8.82179e-02,3.09868e-01,1.50487e-01,9.01571e-02,2.99372e-01,1.42046e-01,9.44061e-02,2.79172e-01,
1.25982e-01,9.66051e-02,2.70017e-01,1.18791e-01,1.00000e-01,2.57348e-01,1.08944e-01,1.05925e-01,2.38349e-01,9.49486e-02,
1.08956e-01,2.30065e-01,8.89770e-02,1.13501e-01,2.19078e-01,8.12271e-02,1.16145e-01,2.13392e-01,7.72878e-02,1.24452e-01,
1.98243e-01,6.70729e-02,1.25890e-01,1.95973e-01,6.55823e-02,1.25893e-01,1.95969e-01,6.55798e-02,1.33352e-01,1.85192e-01,
5.90833e-02,1.36458e-01,1.81285e-01,5.68052e-02,1.38119e-01,1.79316e-01,5.56749e-02,1.44544e-01,1.72380e-01,5.17999e-02,
1.46218e-01,1.70737e-01,5.09058e-02,1.47911e-01,1.69136e-01,5.00443e-02,1.54882e-01,1.63136e-01,4.69031e-02,1.56675e-01,
1.61737e-01,4.61959e-02,1.58489e-01,1.60373e-01,4.55141e-02,1.58490e-01,1.60373e-01,4.55138e-02,1.65959e-01,1.55001e-01,
4.31738e-02,1.67880e-01,1.53735e-01,4.26410e-02,1.75792e-01,1.48946e-01,4.06961e-02,1.79887e-01,1.46706e-01,3.98258e-02,
1.86156e-01,1.43547e-01,3.86429e-02,1.88365e-01,1.42502e-01,3.82643e-02,1.90546e-01,1.41503e-01,3.79080e-02,1.92752e-01,
1.40529e-01,3.75685e-02,1.94984e-01,1.39575e-01,3.72409e-02,1.97242e-01,1.38639e-01,3.69246e-02,1.99526e-01,1.37721e-01,
3.66192e-02,1.99530e-01,1.37720e-01,3.66188e-02,2.01837e-01,1.36772e-01,3.63623e-02,2.13796e-01,1.32275e-01,3.52073e-02,
2.16272e-01,1.31423e-01,3.49997e-02,2.21309e-01,1.29762e-01,3.46055e-02,2.26464e-01,1.28157e-01,3.42372e-02,2.29087e-01,
1.27374e-01,3.40624e-02,2.31740e-01,1.26608e-01,3.38964e-02,2.34423e-01,1.25853e-01,3.37358e-02,2.42661e-01,1.23658e-01,
3.32827e-02,2.45471e-01,1.22949e-01,3.31407e-02,2.48402e-01,1.22228e-01,3.29986e-02,2.51189e-01,1.21560e-01,3.28690e-02,
2.51190e-01,1.21559e-01,3.28689e-02,2.63027e-01,1.18734e-01,3.25064e-02,2.66073e-01,1.18052e-01,3.24221e-02,2.69154e-01,
1.17381e-01,3.23423e-02,2.72270e-01,1.16718e-01,3.22644e-02,2.75423e-01,1.16064e-01,3.21883e-02,2.78612e-01,1.15419e-01,
3.21139e-02,2.98538e-01,1.11705e-01,3.16968e-02,3.01995e-01,1.11112e-01,3.16314e-02,3.05492e-01,1.10525e-01,3.15671e-02,
3.09029e-01,1.09946e-01,3.15054e-02,3.12608e-01,1.09374e-01,3.14444e-02,3.16228e-01,1.08808e-01,3.13840e-02,3.16230e-01,
1.08808e-01,3.13840e-02,3.27341e-01,1.07045e-01,3.13019e-02,3.34965e-01,1.05900e-01,3.12453e-02,3.38844e-01,1.05336e-01,
3.12164e-02,3.42768e-01,1.04777e-01,3.11871e-02,3.45814e-01,1.04353e-01,3.11653e-02,3.46737e-01,1.04225e-01,3.11587e-02,
3.50752e-01,1.03678e-01,3.11297e-02,3.58922e-01,1.02599e-01,3.10698e-02,3.67282e-01,1.01540e-01,3.10075e-02,3.71535e-01,
1.01017e-01,3.09753e-02,3.75837e-01,1.00500e-01,3.09425e-02,3.84592e-01,9.94777e-02,3.08747e-02,3.89045e-01,9.89745e-02,
3.08409e-02,3.93550e-01,9.84754e-02,3.08064e-02,3.98107e-01,9.79806e-02,3.07710e-02,3.98110e-01,9.79803e-02,3.07710e-02,
4.00000e-01,9.77662e-02,3.07683e-02,4.12098e-01,9.64357e-02,3.07449e-02,4.16869e-01,9.59290e-02,3.07331e-02,4.26580e-01,
9.49278e-02,3.07049e-02,4.31519e-01,9.44340e-02,3.06895e-02,4.36516e-01,9.39440e-02,3.06726e-02,4.51856e-01,9.24963e-02,
3.06129e-02,4.62381e-01,9.15491e-02,3.05659e-02,4.73151e-01,9.06158e-02,3.05133e-02,4.78630e-01,9.01549e-02,3.04856e-02,
4.84172e-01,8.96973e-02,3.04566e-02,4.95450e-01,8.87918e-02,3.03944e-02,5.01187e-01,8.83438e-02,3.03614e-02,5.01190e-01,
8.83435e-02,3.03614e-02,5.06991e-01,8.78745e-02,3.03525e-02,5.12861e-01,8.74086e-02,3.03416e-02,5.18800e-01,8.69459e-02,
3.03288e-02,5.24808e-01,8.64869e-02,3.03145e-02,5.30884e-01,8.60311e-02,3.02984e-02,5.43250e-01,8.51287e-02,3.02607e-02,
5.43481e-01,8.51122e-02,3.02599e-02,5.55904e-01,8.42381e-02,3.02158e-02,5.68853e-01,8.33593e-02,3.01639e-02,5.75440e-01,
8.29247e-02,3.01359e-02,5.82103e-01,8.24929e-02,3.01062e-02,5.88844e-01,8.20639e-02,3.00749e-02,5.95662e-01,8.16377e-02,
3.00421e-02,6.02560e-01,8.12142e-02,3.00077e-02,6.09537e-01,8.07935e-02,2.99717e-02,6.23735e-01,7.99599e-02,2.98954e-02,
6.30957e-01,7.95475e-02,2.98554e-02,6.30960e-01,7.95473e-02,2.98554e-02,6.38264e-01,7.91151e-02,2.98344e-02,6.53131e-01,
7.82586e-02,2.97865e-02,6.68344e-01,7.74130e-02,2.97310e-02,6.83912e-01,7.65780e-02,2.96681e-02,6.91831e-01,7.61647e-02,
2.96343e-02,6.99842e-01,7.57541e-02,2.95988e-02,7.07946e-01,7.53459e-02,2.95616e-02,7.16143e-01,7.49403e-02,2.95228e-02,
7.32825e-01,7.41366e-02,2.94402e-02,7.49894e-01,7.33431e-02,2.93520e-02,7.58578e-01,7.29500e-02,2.93056e-02,7.67362e-01,
7.25593e-02,2.92578e-02,7.85236e-01,7.17848e-02,2.91580e-02,7.94328e-01,7.14011e-02,2.91060e-02,7.94330e-01,7.14011e-02,
2.91060e-02,8.03526e-01,7.09992e-02,2.90687e-02,8.22243e-01,7.02031e-02,2.89892e-02,8.31764e-01,6.98087e-02,2.89468e-02,
8.41395e-01,6.94168e-02,2.89027e-02,8.60994e-01,6.86401e-02,2.88097e-02,8.81049e-01,6.78729e-02,2.87105e-02,8.91251e-01,
6.74928e-02,2.86586e-02,9.01571e-01,6.71151e-02,2.86054e-02,9.12011e-01,6.67397e-02,2.85507e-02,9.22571e-01,6.63666e-02,
2.84947e-02,9.33254e-01,6.59958e-02,2.84373e-02,9.66051e-01,6.48965e-02,2.82575e-02,9.77237e-01,6.45346e-02,2.81953e-02,
9.88553e-01,6.41749e-02,2.81318e-02,1.00000e+00,6.38173e-02,2.80672e-02,1.00000e-03,5.23693e+03,5.23204e+03,1.01158e-03,
5.08897e+03,5.08414e+03,1.03000e-03,4.86340e+03,4.85865e+03,1.04037e-03,4.74197e+03,4.73726e+03,1.04713e-03,4.66507e+03,
4.66040e+03,1.07152e-03,4.40180e+03,4.39722e+03,1.12202e-03,3.91990e+03,3.91550e+03,1.13501e-03,3.80751e+03,3.80315e+03,
1.14815e-03,3.69662e+03,3.69230e+03,1.17490e-03,3.48461e+03,3.48036e+03,1.17553e-03,3.47980e+03,3.47556e+03,1.25890e-03,
2.92030e+03,2.91628e+03,1.25892e-03,2.92015e+03,2.91613e+03,1.27350e-03,2.83566e+03,2.83168e+03,1.28825e-03,2.75364e+03,
2.74969e+03,1.30317e-03,2.67403e+03,2.67011e+03,1.31826e-03,2.59595e+03,2.59207e+03,1.34896e-03,2.44518e+03,2.44135e+03,
1.35188e-03,2.43151e+03,2.42769e+03,1.41254e-03,2.17010e+03,2.16640e+03,1.45000e-03,2.02819e+03,2.02455e+03,1.46218e-03,
1.98463e+03,1.98101e+03,1.49624e-03,1.86904e+03,1.86547e+03,1.51356e-03,1.81381e+03,1.81027e+03,1.55520e-03,1.68915e+03,
1.68567e+03,1.56675e-03,1.65668e+03,1.65321e+03,1.58489e-03,1.60748e+03,1.60404e+03,1.58490e-03,1.60746e+03,1.60402e+03,
1.65959e-03,1.42527e+03,1.42194e+03,1.69824e-03,1.34169e+03,1.33840e+03,1.71791e-03,1.30160e+03,1.29833e+03,1.75792e-03,
1.22448e+03,1.22126e+03,1.77828e-03,1.18771e+03,1.18452e+03,1.81898e-03,1.11873e+03,1.11557e+03,1.86209e-03,1.05156e+03,
1.04846e+03,1.88365e-03,1.02012e+03,1.01703e+03,1.92753e-03,9.59677e+02,9.56634e+02,1.95000e-03,9.30632e+02,9.27610e+02,
1.97242e-03,9.02771e+02,8.99769e+02,1.98331e-03,8.89567e+02,8.86575e+02,1.99526e-03,8.75370e+02,8.72389e+02,1.99530e-03,
8.75325e+02,8.72345e+02,2.00000e-03,8.69829e+02,8.66853e+02,2.08930e-03,7.74069e+02,7.71176e+02,2.11349e-03,7.50673e+02,
7.47801e+02,2.15000e-03,7.17198e+02,7.14357e+02,2.16272e-03,7.05944e+02,7.03113e+02,2.18776e-03,6.84480e+02,6.81669e+02,
2.21310e-03,6.63688e+02,6.60897e+02,2.22000e-03,6.58175e+02,6.55389e+02,2.23058e-03,6.49826e+02,6.47049e+02,2.26464e-03,
6.23917e+02,6.21166e+02,2.29087e-03,6.04952e+02,6.02222e+02,2.33172e-03,5.76825e+02,5.74126e+02,2.39883e-03,5.34378e+02,
5.31731e+02,2.42661e-03,5.18097e+02,5.15472e+02,2.45471e-03,5.02314e+02,4.99710e+02,2.48313e-03,4.87017e+02,4.84433e+02,
2.51189e-03,4.72080e+02,4.69517e+02,2.51190e-03,4.72073e+02,4.69510e+02,2.54097e-03,4.57616e+02,4.55073e+02,2.57040e-03,
4.43607e+02,4.41084e+02,2.63500e-03,4.14800e+02,4.12320e+02,2.65000e-03,4.08482e+02,4.06012e+02,2.72270e-03,3.79549e+02,
3.77128e+02,2.78612e-03,3.56598e+02,3.54219e+02,2.81838e-03,3.45658e+02,3.43300e+02,2.84742e-03,3.36203e+02,3.33863e+02,
2.85102e-03,3.35056e+02,3.32718e+02,2.91743e-03,3.14684e+02,3.12388e+02,2.95121e-03,3.04983e+02,3.02707e+02,2.96422e-03,
3.01360e+02,2.99093e+02,3.00000e-03,2.91693e+02,2.89449e+02,3.05492e-03,2.77641e+02,2.75432e+02,3.09030e-03,2.69043e+02,
2.66856e+02,3.16228e-03,2.52660e+02,2.50515e+02,3.16230e-03,2.52655e+02,2.50510e+02,3.19494e-03,2.45684e+02,2.43558e+02,
3.23594e-03,2.37295e+02,2.35194e+02,3.27341e-03,2.29971e+02,2.27892e+02,3.33113e-03,2.19223e+02,2.17178e+02,3.45748e-03,
1.97979e+02,1.96009e+02,3.46737e-03,1.96437e+02,1.94473e+02,3.50752e-03,1.90357e+02,1.88418e+02,3.52024e-03,1.88472e+02,
1.86540e+02,3.54813e-03,1.84429e+02,1.82513e+02,3.57151e-03,1.81136e+02,1.79233e+02,3.63078e-03,1.73133e+02,1.71267e+02,
3.67117e-03,1.67964e+02,1.66121e+02,3.75837e-03,1.57499e+02,1.55710e+02,3.76063e-03,1.57239e+02,1.55451e+02,3.83885e-03,
1.48565e+02,1.46827e+02,3.91095e-03,1.41136e+02,1.39445e+02,3.97014e-03,1.35407e+02,1.33758e+02,3.98107e-03,1.34383e+02,
1.32741e+02,3.98110e-03,1.34380e+02,1.32739e+02,4.01965e-03,1.30853e+02,1.29240e+02,4.02717e-03,1.30179e+02,1.28571e+02,
4.06817e-03,1.26582e+02,1.25006e+02,4.07380e-03,1.26098e+02,1.24527e+02,4.10715e-03,1.23280e+02,1.21736e+02,4.12097e-03,
1.22135e+02,1.20604e+02,4.15074e-03,1.19722e+02,1.18217e+02,4.16869e-03,1.18296e+02,1.16807e+02,4.18463e-03,1.17049e+02,
1.15576e+02,4.21696e-03,1.14571e+02,1.13132e+02,4.21792e-03,1.14500e+02,1.13061e+02,4.24821e-03,1.12243e+02,1.10839e+02,
4.27743e-03,1.10119e+02,1.08752e+02,4.30173e-03,1.08388e+02,1.07058e+02,4.31519e-03,1.07441e+02,1.06134e+02,4.32271e-03,
1.06913e+02,1.05619e+02,4.34003e-03,1.05705e+02,1.04445e+02,4.35677e-03,1.04550e+02,1.03328e+02,4.36516e-03,1.03975e+02,
1.02774e+02,4.38026e-03,1.02950e+02,1.01787e+02,4.41091e-03,1.00909e+02,9.98237e+01,4.42494e-03,9.99990e+01,9.89419e+01,
4.43509e-03,9.93524e+01,9.83102e+01,4.44685e-03,9.86183e+01,9.75860e+01,4.45628e-03,9.80412e+01,9.70102e+01,4.46580e-03,
9.74694e+01,9.64334e+01,4.46580e-03,8.30732e+02,7.03550e+02,4.46677e-03,8.30297e+02,7.03207e+02,4.47306e-03,8.27475e+02,
7.00979e+02,4.47987e-03,8.24437e+02,6.98578e+02,4.49227e-03,8.18960e+02,6.94241e+02,4.50814e-03,8.12028e+02,6.88739e+02,
4.54105e-03,7.97936e+02,6.77529e+02,4.55230e-03,7.93195e+02,6.73753e+02,4.56313e-03,7.88672e+02,6.70150e+02,4.57178e-03,
7.85081e+02,6.67289e+02,4.58493e-03,7.79663e+02,6.62973e+02,4.59756e-03,7.74508e+02,6.58866e+02,4.61048e-03,7.69280e+02,
6.54700e+02,4.62381e-03,7.63938e+02,6.50443e+02,4.63436e-03,7.59747e+02,6.47101e+02,4.65534e-03,7.51501e+02,6.40523e+02,
4.67735e-03,7.42979e+02,6.33722e+02,4.69377e-03,7.36715e+02,6.28717e+02,4.71755e-03,7.27766e+02,6.21563e+02,4.73151e-03,
7.22584e+02,6.17417e+02,4.74728e-03,7.16567e+02,6.12586e+02,4.78630e-03,7.01966e+02,6.00853e+02,4.80761e-03,6.94169e+02,
5.94577e+02,4.84172e-03,6.81933e+02,5.84720e+02,4.88938e-03,6.65346e+02,5.71330e+02,4.98106e-03,6.34979e+02,5.46743e+02,
5.00000e-03,6.28947e+02,5.41848e+02,5.01187e-03,6.25203e+02,5.38808e+02,5.01190e-03,6.25194e+02,5.38801e+02,5.05576e-03,
6.11633e+02,5.27773e+02,5.06991e-03,6.07345e+02,5.24283e+02,5.17542e-03,5.76660e+02,4.99239e+02,5.18800e-03,5.73147e+02,
4.96365e+02,5.24807e-03,5.56278e+02,4.82519e+02,5.30830e-03,5.40052e+02,4.69170e+02,5.30884e-03,5.39909e+02,4.69051e+02,
5.43250e-03,5.08591e+02,4.43197e+02,5.44906e-03,5.04591e+02,4.39886e+02,5.50000e-03,4.92554e+02,4.29912e+02,5.55904e-03,
4.79093e+02,4.18736e+02,5.62341e-03,4.64994e+02,4.07004e+02,5.68853e-03,4.51172e+02,3.95485e+02,5.70090e-03,4.48611e+02,
3.93348e+02,5.75440e-03,4.37762e+02,3.84286e+02,5.88844e-03,4.12106e+02,3.62788e+02,5.98190e-03,3.95434e+02,3.48768e+02,
6.02560e-03,3.87957e+02,3.42469e+02,6.09537e-03,3.76421e+02,3.32732e+02,6.25635e-03,3.51550e+02,3.11672e+02,6.30957e-03,
3.43829e+02,3.05114e+02,6.30960e-03,3.43825e+02,3.05110e+02,6.38263e-03,3.33607e+02,2.96418e+02,6.45654e-03,3.23690e+02,
2.87966e+02,6.53131e-03,3.14068e+02,2.79749e+02,6.60693e-03,3.04734e+02,2.71763e+02,6.62355e-03,3.02733e+02,2.70048e+02,
6.68344e-03,2.95668e+02,2.63992e+02,6.91831e-03,2.70065e+02,2.41968e+02,7.00000e-03,2.61880e+02,2.34902e+02,7.10137e-03,
2.51933e+02,2.26289e+02,7.32824e-03,2.31473e+02,2.08515e+02,7.41310e-03,2.24409e+02,2.02359e+02,7.50000e-03,2.17479e+02,
1.96310e+02,7.67362e-03,2.04488e+02,1.84945e+02,7.70424e-03,2.02305e+02,1.83032e+02,7.76247e-03,1.98243e+02,1.79469e+02,
7.94328e-03,1.86322e+02,1.68994e+02,7.94330e-03,1.86321e+02,1.68993e+02,8.00000e-03,1.82786e+02,1.65880e+02,8.12830e-03,
1.75122e+02,1.59122e+02,8.51138e-03,1.54704e+02,1.41060e+02,8.62949e-03,1.49072e+02,1.36061e+02,8.70964e-03,1.45410e+02,
1.32805e+02,8.81049e-03,1.40975e+02,1.28858e+02,9.00000e-03,1.32965e+02,1.21711e+02,9.01571e-03,1.32329e+02,1.21142e+02,
9.33254e-03,1.20337e+02,1.10406e+02,9.50000e-03,1.14595e+02,1.05252e+02,9.54993e-03,1.12956e+02,1.03778e+02,9.69970e-03,
1.08226e+02,9.95225e+01,9.88553e-03,1.02726e+02,9.45654e+01,1.00000e-02,9.95274e+01,9.16785e+01,1.02329e-02,9.34273e+01,
8.61638e+01,1.03514e-02,9.05202e+01,8.35313e+01,1.04713e-02,8.77036e+01,8.09782e+01,1.05000e-02,8.70469e+01,8.03825e+01,
1.05925e-02,8.49733e+01,7.85005e+01,1.08187e-02,8.01162e+01,7.40847e+01,1.09648e-02,7.71783e+01,7.14101e+01,1.12202e-02,
7.23856e+01,6.70403e+01,1.16145e-02,6.57505e+01,6.09762e+01,1.16765e-02,6.47843e+01,6.00918e+01,1.21619e-02,5.78455e+01,
5.37304e+01,1.23027e-02,5.60014e+01,5.20359e+01,1.25890e-02,5.24888e+01,4.88040e+01,1.25892e-02,5.24858e+01,4.88013e+01,
1.30243e-02,4.77000e+01,4.43894e+01,1.31826e-02,4.61064e+01,4.29186e+01,1.33352e-02,4.46373e+01,4.15616e+01,1.36458e-02,
4.18388e+01,3.89744e+01,1.38038e-02,4.05066e+01,3.77415e+01,1.44544e-02,3.55929e+01,3.31859e+01,1.44824e-02,3.53974e+01,
3.30043e+01,1.47911e-02,3.33333e+01,3.10870e+01,1.56675e-02,2.82979e+01,2.63995e+01,1.58489e-02,2.73870e+01,2.55500e+01,
1.58490e-02,2.73867e+01,2.55497e+01,1.60307e-02,2.65140e+01,2.47355e+01,1.60324e-02,2.65057e+01,2.47278e+01,1.62181e-02,
2.56525e+01,2.39317e+01,1.65959e-02,2.40287e+01,2.24155e+01,1.71791e-02,2.17860e+01,2.03187e+01,1.73780e-02,2.10858e+01,
1.96634e+01,1.76402e-02,2.01982e+01,1.88320e+01,1.79887e-02,1.90949e+01,1.77984e+01,1.86209e-02,1.72940e+01,1.61096e+01,
1.90546e-02,1.61901e+01,1.50733e+01,1.92752e-02,1.56653e+01,1.45804e+01,1.94748e-02,1.52106e+01,1.41531e+01,1.99526e-02,
1.41918e+01,1.31958e+01,1.99530e-02,1.41910e+01,1.31951e+01,2.00000e-02,1.40959e+01,1.31057e+01,2.04174e-02,1.32881e+01,
1.23464e+01,2.11349e-02,1.20401e+01,1.11724e+01,2.16876e-02,1.11761e+01,1.03588e+01,2.18776e-02,1.08985e+01,1.00974e+01,
2.21309e-02,1.05429e+01,9.76251e+00,2.31740e-02,9.23497e+00,8.53003e+00,2.34423e-02,8.93477e+00,8.24699e+00,2.42661e-02,
8.09280e+00,7.45287e+00,2.48126e-02,7.59312e+00,6.98136e+00,2.51189e-02,7.33134e+00,6.73444e+00,2.51190e-02,7.33123e+00,
6.73433e+00,2.57040e-02,6.86479e+00,6.29440e+00,2.66073e-02,6.21488e+00,5.68104e+00,2.72270e-02,5.81721e+00,5.30565e+00,
2.85102e-02,5.09906e+00,4.62764e+00,2.91743e-02,4.77522e+00,4.32188e+00,2.99129e-02,4.44745e+00,4.01239e+00,3.05492e-02,
4.18972e+00,3.76912e+00,3.16228e-02,3.80024e+00,3.40152e+00,3.16230e-02,3.80016e+00,3.40145e+00,3.19889e-02,3.67767e+00,
3.28596e+00,3.50752e-02,2.83540e+00,2.49239e+00,3.54813e-02,2.74552e+00,2.40779e+00,3.63078e-02,2.57466e+00,2.24698e+00,
3.71535e-02,2.41518e+00,2.09697e+00,3.89045e-02,2.12735e+00,1.82644e+00,3.91730e-02,2.08766e+00,1.78916e+00,3.93550e-02,
2.06135e+00,1.76447e+00,3.98107e-02,1.99694e+00,1.70403e+00,3.98110e-02,1.99690e+00,1.70400e+00,4.07380e-02,1.87447e+00,
1.58940e+00,4.31519e-02,1.60298e+00,1.33568e+00,4.46684e-02,1.46116e+00,1.20340e+00,4.76696e-02,1.23101e+00,9.89237e-01,
4.78630e-02,1.21809e+00,9.77254e-01,4.89779e-02,1.14758e+00,9.11869e-01,5.01187e-02,1.08177e+00,8.50929e-01,5.01190e-02,
1.08175e+00,8.50915e-01,5.12861e-02,1.01965e+00,7.93693e-01,5.30884e-02,9.34199e-01,7.15123e-01,5.37032e-02,9.07633e-01,
6.90741e-01,5.69942e-02,7.84038e-01,5.77636e-01,5.95662e-02,7.05440e-01,5.06172e-01,6.30957e-02,6.17371e-01,4.26501e-01,
6.30960e-02,6.17365e-01,4.26496e-01,6.60693e-02,5.56688e-01,3.72377e-01,6.65106e-02,5.48528e-01,3.65121e-01,6.76083e-02,
5.29098e-01,3.47902e-01,6.83912e-02,5.15990e-01,3.36310e-01,6.91831e-02,5.03315e-01,3.25120e-01,7.00000e-02,4.90832e-01,
3.14119e-01,7.07946e-02,4.79233e-01,3.03916e-01,7.58578e-02,4.16120e-01,2.48753e-01,7.67362e-02,4.06799e-01,2.40665e-01,
7.70907e-02,4.03155e-01,2.37508e-01,7.85236e-02,3.89047e-01,2.25340e-01,7.94328e-02,3.80608e-01,2.18082e-01,7.94330e-02,
3.80606e-01,2.18081e-01,8.12830e-02,3.64386e-01,2.04401e-01,8.91251e-02,3.09313e-01,1.58594e-01,9.12011e-02,2.97679e-01,
1.49072e-01,9.22571e-02,2.92141e-01,1.44562e-01,9.33254e-02,2.86782e-01,1.40212e-01,9.44061e-02,2.81596e-01,1.36018e-01,
9.72502e-02,2.68981e-01,1.25882e-01,9.77237e-02,2.67012e-01,1.24312e-01,1.00000e-01,2.58034e-01,1.17187e-01,1.01158e-01,
2.53681e-01,1.13851e-01,1.02329e-01,2.49454e-01,1.10625e-01,1.05925e-01,2.37550e-01,1.01625e-01,1.07152e-01,2.33826e-01,
9.88382e-02,1.10918e-01,2.23330e-01,9.10646e-02,1.13860e-01,2.16002e-01,8.57161e-02,1.17490e-01,2.07847e-01,7.98659e-02,
1.21619e-01,1.99624e-01,7.40686e-02,1.25890e-01,1.92120e-01,6.88783e-02,1.25893e-01,1.92116e-01,6.88754e-02,1.30317e-01,
1.85052e-01,6.43354e-02,1.33352e-01,1.80672e-01,6.15769e-02,1.36458e-01,1.76534e-01,5.90150e-02,1.38038e-01,1.74552e-01,
5.78034e-02,1.41254e-01,1.70749e-01,5.55103e-02,1.46218e-01,1.65424e-01,5.23733e-02,1.47911e-01,1.63754e-01,5.14114e-02,
1.48213e-01,1.63462e-01,5.12448e-02,1.50000e-01,1.61774e-01,5.02862e-02,1.51356e-01,1.60536e-01,4.95901e-02,1.53109e-01,
1.58990e-01,4.87280e-02,1.54882e-01,1.57485e-01,4.78969e-02,1.56675e-01,1.56018e-01,4.70956e-02,1.58489e-01,1.54588e-01,
4.63230e-02,1.58490e-01,1.54588e-01,4.63227e-02,1.60324e-01,1.53138e-01,4.56144e-02,1.62181e-01,1.51722e-01,4.49315e-02,
1.67880e-01,1.47679e-01,4.30274e-02,1.69824e-01,1.46394e-01,4.24379e-02,1.73780e-01,1.43916e-01,4.13218e-02,1.81970e-01,
1.39290e-01,3.93196e-02,1.84077e-01,1.38198e-01,3.88628e-02,1.86209e-01,1.37136e-01,3.84276e-02,1.94984e-01,1.33108e-01,
3.68332e-02,1.97242e-01,1.32154e-01,3.64686e-02,1.97637e-01,1.31990e-01,3.64066e-02,1.99526e-01,1.31217e-01,3.61169e-02,
1.99530e-01,1.31216e-01,3.61164e-02,2.04174e-01,1.29308e-01,3.55195e-02,2.06538e-01,1.28381e-01,3.52365e-02,2.21309e-01,
1.23173e-01,3.37323e-02,2.23872e-01,1.22360e-01,3.35106e-02,2.26464e-01,1.21561e-01,3.32963e-02,2.29087e-01,1.20780e-01,
3.30928e-02,2.31740e-01,1.20012e-01,3.28959e-02,2.34423e-01,1.19257e-01,3.27052e-02,2.45471e-01,1.16361e-01,3.20017e-02,
2.48313e-01,1.15666e-01,3.18391e-02,2.51189e-01,1.14981e-01,3.16813e-02,2.51190e-01,1.14981e-01,3.16813e-02,2.54097e-01,
1.14269e-01,3.15614e-02,2.57040e-01,1.13567e-01,3.14451e-02,2.62271e-01,1.12364e-01,3.12498e-02,2.63027e-01,1.12194e-01,
3.12227e-02,2.69154e-01,1.10863e-01,3.10180e-02,2.72270e-01,1.10212e-01,3.09197e-02,2.78612e-01,1.08935e-01,3.07309e-02,
2.81838e-01,1.08310e-01,3.06399e-02,2.85102e-01,1.07693e-01,3.05511e-02,2.91743e-01,1.06482e-01,3.03794e-02,3.01995e-01,
1.04723e-01,3.01352e-02,3.05492e-01,1.04152e-01,3.00590e-02,3.09029e-01,1.03589e-01,2.99840e-02,3.12608e-01,1.03032e-01,
2.99102e-02,3.16228e-01,1.02482e-01,2.98379e-02,3.16230e-01,1.02482e-01,2.98378e-02,3.19889e-01,1.01906e-01,2.97970e-02,
3.34965e-01,9.96659e-02,2.96353e-02,3.38844e-01,9.91208e-02,2.95951e-02,3.42768e-01,9.85813e-02,2.95550e-02,3.46737e-01,
9.80489e-02,2.95162e-02,3.50752e-01,9.75220e-02,2.94773e-02,3.66680e-01,9.55379e-02,2.93258e-02,3.67282e-01,9.54658e-02,
2.93201e-02,3.71535e-01,9.49637e-02,2.92802e-02,3.75837e-01,9.44663e-02,2.92399e-02,3.80189e-01,9.39735e-02,2.91993e-02,
3.84592e-01,9.34853e-02,2.91583e-02,3.93550e-01,9.25244e-02,2.90774e-02,3.98107e-01,9.20505e-02,2.90364e-02,3.98110e-01,
9.20502e-02,2.90364e-02,4.02717e-01,9.15540e-02,2.90220e-02,4.07380e-01,9.10617e-02,2.90063e-02,4.21697e-01,8.96101e-02,
2.89522e-02,4.26580e-01,8.91343e-02,2.89317e-02,4.31519e-01,8.86634e-02,2.89110e-02,4.36516e-01,8.81963e-02,2.88890e-02,
4.41570e-01,8.77330e-02,2.88660e-02,4.62381e-01,8.59162e-02,2.87617e-02,4.67735e-01,8.54708e-02,2.87327e-02,4.73151e-01,
8.50288e-02,2.87026e-02,4.78630e-01,8.45909e-02,2.86721e-02,4.84172e-01,8.41562e-02,2.86405e-02,4.95450e-01,8.32966e-02,
2.85739e-02,5.01187e-01,8.28714e-02,2.85389e-02,5.01190e-01,8.28712e-02,2.85389e-02,5.06991e-01,8.24265e-02,2.85266e-02,
5.12861e-01,8.19848e-02,2.85126e-02,5.18800e-01,8.15463e-02,2.84969e-02,5.24808e-01,8.11110e-02,2.84795e-02,5.30884e-01,
8.06793e-02,2.84610e-02,5.37032e-01,8.02506e-02,2.84409e-02,5.55904e-01,7.89826e-02,2.83711e-02,5.68853e-01,7.81518e-02,
2.83168e-02,5.75440e-01,7.77406e-02,2.82874e-02,5.78762e-01,7.75363e-02,2.82724e-02,5.82103e-01,7.73326e-02,2.82570e-02,
5.88844e-01,7.69272e-02,2.82252e-02,6.02560e-01,7.61246e-02,2.81575e-02,6.09537e-01,7.57272e-02,2.81215e-02,6.16595e-01,
7.53324e-02,2.80842e-02,6.30957e-01,7.45506e-02,2.80058e-02,6.30960e-01,7.45505e-02,2.80058e-02,6.38264e-01,7.41429e-02,
2.79842e-02,6.45654e-01,7.37378e-02,2.79607e-02,6.53131e-01,7.33354e-02,2.79355e-02,6.60694e-01,7.29356e-02,2.79086e-02,
6.68344e-01,7.25384e-02,2.78800e-02,6.76083e-01,7.21438e-02,2.78497e-02,6.91831e-01,7.13622e-02,2.77842e-02,6.99842e-01,
7.09754e-02,2.77495e-02,7.07946e-01,7.05911e-02,2.77132e-02,7.08570e-01,7.05618e-02,2.77104e-02,7.16143e-01,7.02092e-02,
2.76754e-02,7.24436e-01,6.98298e-02,2.76362e-02,7.41310e-01,6.90780e-02,2.75534e-02,7.44480e-01,6.89397e-02,2.75374e-02,
7.49894e-01,6.87056e-02,2.75099e-02,7.67362e-01,6.79682e-02,2.74194e-02,7.76247e-01,6.76028e-02,2.73722e-02,7.94328e-01,
6.68789e-02,2.72741e-02,7.94330e-01,6.68788e-02,2.72741e-02,8.03526e-01,6.65010e-02,2.72381e-02,8.22243e-01,6.57523e-02,
2.71614e-02,8.41395e-01,6.50134e-02,2.70786e-02,8.51138e-01,6.46473e-02,2.70350e-02,8.60994e-01,6.42836e-02,2.69898e-02,
8.91251e-01,6.32057e-02,2.68460e-02,9.12011e-01,6.24982e-02,2.67433e-02,9.22571e-01,6.21476e-02,2.66901e-02,9.33254e-01,
6.17994e-02,2.66357e-02,9.44061e-01,6.14533e-02,2.65802e-02,9.66051e-01,6.07674e-02,2.64656e-02,9.77237e-01,6.04275e-02,
2.64066e-02,9.88553e-01,6.00898e-02,2.63465e-02,1.00000e+00,5.97540e-02,2.62853e-02,1.00000e-03,5.86568e+03,5.85986e+03,
1.01158e-03,5.70111e+03,5.69537e+03,1.03514e-03,5.38011e+03,5.37454e+03,1.06498e-03,5.00946e+03,5.00406e+03,1.07152e-03,
4.93309e+03,4.92773e+03,1.10918e-03,4.52380e+03,4.51864e+03,1.12202e-03,4.39522e+03,4.39012e+03,1.15000e-03,4.13258e+03,
4.12761e+03,1.16145e-03,4.03151e+03,4.02659e+03,1.17490e-03,3.91663e+03,3.91177e+03,1.18338e-03,3.84547e+03,3.84064e+03,
1.20226e-03,3.69346e+03,3.68870e+03,1.25890e-03,3.28536e+03,3.28080e+03,1.25892e-03,3.28519e+03,3.28064e+03,1.28825e-03,
3.09870e+03,3.09423e+03,1.30000e-03,3.02775e+03,3.02333e+03,1.31826e-03,2.92152e+03,2.91714e+03,1.33352e-03,2.83589e+03,
2.83156e+03,1.34718e-03,2.76226e+03,2.75797e+03,1.34896e-03,2.75284e+03,2.74855e+03,1.36458e-03,2.67222e+03,2.66797e+03,
1.41254e-03,2.44451e+03,2.44038e+03,1.42889e-03,2.37314e+03,2.36904e+03,1.47911e-03,2.17154e+03,2.16755e+03,1.50000e-03,
2.09434e+03,2.09040e+03,1.51356e-03,2.04630e+03,2.04238e+03,1.53109e-03,1.98618e+03,1.98229e+03,1.58434e-03,1.81643e+03,
1.81264e+03,1.58489e-03,1.81478e+03,1.81099e+03,1.58490e-03,1.81476e+03,1.81097e+03,1.60325e-03,1.76110e+03,1.75734e+03,
1.62181e-03,1.70906e+03,1.70533e+03,1.65000e-03,1.63403e+03,1.63034e+03,1.69824e-03,1.51528e+03,1.51168e+03,1.73780e-03,
1.42682e+03,1.42327e+03,1.75792e-03,1.38440e+03,1.38087e+03,1.77828e-03,1.34295e+03,1.33945e+03,1.79125e-03,1.31747e+03,
1.31399e+03,1.84077e-03,1.22611e+03,1.22270e+03,1.88365e-03,1.15407e+03,1.15071e+03,1.90546e-03,1.11971e+03,1.11637e+03,
1.97242e-03,1.02205e+03,1.01879e+03,1.99526e-03,9.91336e+02,9.88094e+02,1.99530e-03,9.91286e+02,9.88044e+02,2.00000e-03,
9.85123e+02,9.81886e+02,2.06538e-03,9.04158e+02,9.00992e+02,2.08930e-03,8.76867e+02,8.73725e+02,2.16272e-03,7.99992e+02,
7.96921e+02,2.21310e-03,7.52345e+02,7.49320e+02,2.23872e-03,7.29609e+02,7.26606e+02,2.26464e-03,7.07562e+02,7.04581e+02,
2.29087e-03,6.86201e+02,6.83242e+02,2.30000e-03,6.78946e+02,6.75995e+02,2.33413e-03,6.52581e+02,6.49657e+02,2.34423e-03,
6.45049e+02,6.42134e+02,2.37137e-03,6.25405e+02,6.22513e+02,2.45471e-03,5.70104e+02,5.67281e+02,2.51189e-03,5.35825e+02,
5.33047e+02,2.51190e-03,5.35817e+02,5.33038e+02,2.54097e-03,5.19469e+02,5.16712e+02,2.57040e-03,5.03629e+02,5.00893e+02,
2.60016e-03,4.88273e+02,4.85559e+02,2.63500e-03,4.71122e+02,4.68432e+02,2.65000e-03,4.63994e+02,4.61315e+02,2.66073e-03,
4.58958e+02,4.56288e+02,2.69154e-03,4.44858e+02,4.42210e+02,2.85102e-03,3.80794e+02,3.78257e+02,2.88403e-03,3.69075e+02,
3.66559e+02,2.95121e-03,3.46725e+02,3.44251e+02,2.97092e-03,3.40531e+02,3.38069e+02,3.00000e-03,3.31663e+02,3.29221e+02,
3.01995e-03,3.25761e+02,3.23332e+02,3.05492e-03,3.15763e+02,3.13356e+02,3.09030e-03,3.05996e+02,3.03612e+02,3.12608e-03,
2.96542e+02,2.94179e+02,3.16228e-03,2.87402e+02,2.85062e+02,3.16230e-03,2.87397e+02,2.85056e+02,3.22272e-03,2.72983e+02,
2.70678e+02,3.27341e-03,2.61645e+02,2.59371e+02,3.36084e-03,2.43476e+02,2.41252e+02,3.42768e-03,2.30732e+02,2.28548e+02,
3.46737e-03,2.23607e+02,2.21446e+02,3.50752e-03,2.16703e+02,2.14564e+02,3.54813e-03,2.09999e+02,2.07884e+02,3.58922e-03,
2.03476e+02,2.01383e+02,3.63078e-03,1.97161e+02,1.95092e+02,3.64297e-03,1.95363e+02,1.93301e+02,3.71535e-03,1.85131e+02,
1.83110e+02,3.78480e-03,1.75946e+02,1.73962e+02,3.93251e-03,1.58377e+02,1.56475e+02,3.93550e-03,1.58046e+02,1.56145e+02,
3.98107e-03,1.53138e+02,1.51263e+02,3.98110e-03,1.53135e+02,1.51260e+02,4.02717e-03,1.48382e+02,1.46533e+02,4.04014e-03,
1.47081e+02,1.45239e+02,4.07380e-03,1.43775e+02,1.41952e+02,4.12097e-03,1.39304e+02,1.37508e+02,4.14331e-03,1.37246e+02,
1.35462e+02,4.16869e-03,1.34955e+02,1.33186e+02,4.23323e-03,1.29369e+02,1.27637e+02,4.26579e-03,1.26668e+02,1.24956e+02,
4.31752e-03,1.22509e+02,1.20828e+02,4.38947e-03,1.17024e+02,1.15388e+02,4.49167e-03,1.09785e+02,1.08217e+02,4.51856e-03,
1.07979e+02,1.06432e+02,4.57765e-03,1.04162e+02,1.02658e+02,4.64429e-03,1.00066e+02,9.86178e+01,4.67735e-03,9.81097e+01,
9.66932e+01,4.67968e-03,9.79739e+01,9.65596e+01,4.70134e-03,9.67213e+01,9.53293e+01,4.73151e-03,9.50086e+01,9.36511e+01,
4.73257e-03,9.49494e+01,9.35931e+01,4.75908e-03,9.34723e+01,9.21504e+01,4.78230e-03,9.21990e+01,9.09119e+01,4.78630e-03,
9.19809e+01,9.07008e+01,4.80000e-03,9.12399e+01,8.99832e+01,4.80146e-03,9.11610e+01,8.99068e+01,4.81998e-03,9.01645e+01,
8.89463e+01,4.84172e-03,8.90069e+01,8.78361e+01,4.84597e-03,8.87835e+01,8.76218e+01,4.88335e-03,8.68451e+01,8.57645e+01,
4.89779e-03,8.61177e+01,8.50613e+01,4.89818e-03,8.60983e+01,8.50426e+01,4.90972e-03,8.55286e+01,8.44865e+01,4.91963e-03,
8.50478e+01,8.40127e+01,4.93007e-03,8.45513e+01,8.35181e+01,4.94060e-03,8.40601e+01,8.30226e+01,4.94060e-03,6.96858e+02,
5.74244e+02,4.94163e-03,6.96542e+02,5.74006e+02,4.94856e-03,6.94409e+02,5.72402e+02,4.95450e-03,6.92592e+02,5.71034e+02,
4.95603e-03,6.92124e+02,5.70682e+02,4.96962e-03,6.87999e+02,5.67568e+02,4.98703e-03,6.82777e+02,5.63616e+02,5.01187e-03,
6.75435e+02,5.58045e+02,5.01190e-03,6.75427e+02,5.58038e+02,5.02724e-03,6.70952e+02,5.54637e+02,5.04734e-03,6.65151e+02,
5.50227e+02,5.05738e-03,6.62277e+02,5.48041e+02,5.06991e-03,6.58716e+02,5.45333e+02,5.07000e-03,6.58690e+02,5.45313e+02,
5.07472e-03,6.57214e+02,5.44181e+02,5.08400e-03,6.54320e+02,5.41960e+02,5.10171e-03,6.48848e+02,5.37761e+02,5.11834e-03,
6.43768e+02,5.33860e+02,5.14161e-03,6.36745e+02,5.28466e+02,5.18214e-03,6.24762e+02,5.19251e+02,5.23000e-03,6.11015e+02,
5.08659e+02,5.23447e-03,6.09699e+02,5.07641e+02,5.24807e-03,6.05719e+02,5.04560e+02,5.29637e-03,5.91885e+02,4.93833e+02,
5.36488e-03,5.73000e+02,4.79152e+02,5.43250e-03,5.55169e+02,4.65246e+02,5.46069e-03,5.47968e+02,4.59616e+02,5.50000e-03,
5.38136e+02,4.51920e+02,5.58522e-03,5.17655e+02,4.35880e+02,5.62341e-03,5.08827e+02,4.28947e+02,5.68853e-03,4.94250e+02,
4.17471e+02,5.71886e-03,4.87659e+02,4.12271e+02,5.75440e-03,4.80091e+02,4.06292e+02,5.82103e-03,4.66323e+02,3.95389e+02,
5.90813e-03,4.48517e+02,3.81205e+02,5.95662e-03,4.39007e+02,3.73609e+02,6.09537e-03,4.13298e+02,3.52998e+02,6.12494e-03,
4.08090e+02,3.48809e+02,6.30957e-03,3.77540e+02,3.24141e+02,6.30960e-03,3.77535e+02,3.24138e+02,6.38263e-03,3.66324e+02,
3.15041e+02,6.42605e-03,3.59876e+02,3.09799e+02,6.53131e-03,3.44880e+02,2.97580e+02,6.60693e-03,3.34637e+02,2.89207e+02,
6.68057e-03,3.25060e+02,2.81360e+02,6.68344e-03,3.24695e+02,2.81061e+02,6.91831e-03,2.96580e+02,2.57915e+02,7.07946e-03,
2.79211e+02,2.43533e+02,7.12321e-03,2.74740e+02,2.39820e+02,7.24436e-03,2.62863e+02,2.29936e+02,7.41310e-03,2.47410e+02,
2.17024e+02,7.49894e-03,2.40027e+02,2.10835e+02,7.58578e-03,2.32866e+02,2.04819e+02,7.67362e-03,2.25920e+02,1.98971e+02,
7.67687e-03,2.25668e+02,1.98759e+02,7.76247e-03,2.19178e+02,1.93286e+02,7.85236e-03,2.12632e+02,1.87753e+02,7.94328e-03,
2.06120e+02,1.82232e+02,7.94330e-03,2.06119e+02,1.82231e+02,8.22243e-03,1.87765e+02,1.66609e+02,8.28600e-03,1.83902e+02,
1.63313e+02,8.41395e-03,1.76449e+02,1.56942e+02,8.70964e-03,1.60748e+02,1.43468e+02,8.81049e-03,1.55831e+02,1.39233e+02,
9.01571e-03,1.46447e+02,1.31130e+02,9.22571e-03,1.37620e+02,1.23481e+02,9.37675e-03,1.31719e+02,1.18354e+02,9.54993e-03,
1.25372e+02,1.12826e+02,9.77237e-03,1.17821e+02,1.06232e+02,9.88553e-03,1.14220e+02,1.03079e+02,1.00000e-02,1.10651e+02,
9.99472e+01,1.02329e-02,1.03846e+02,9.39626e+01,1.03191e-02,1.01474e+02,9.18728e+01,1.04713e-02,9.74592e+01,8.83309e+01,
1.05925e-02,9.44124e+01,8.56385e+01,1.08393e-02,8.86022e+01,8.04937e+01,1.09648e-02,8.58337e+01,7.80372e+01,1.10918e-02,
8.31521e+01,7.56548e+01,1.16145e-02,7.32440e+01,6.68244e+01,1.16188e-02,7.31689e+01,6.67573e+01,1.18850e-02,6.87446e+01,
6.28002e+01,1.20226e-02,6.66005e+01,6.08790e+01,1.21619e-02,6.45233e+01,5.90157e+01,1.23027e-02,6.25113e+01,5.72088e+01,
1.24451e-02,6.05251e+01,5.54219e+01,1.25452e-02,5.91815e+01,5.42120e+01,1.25890e-02,5.86054e+01,5.36931e+01,1.25892e-02,
5.86022e+01,5.36901e+01,1.27350e-02,5.67402e+01,5.20118e+01,1.30317e-02,5.31935e+01,4.88099e+01,1.31826e-02,5.15049e+01,
4.72836e+01,1.38883e-02,4.45082e+01,4.09418e+01,1.39637e-02,4.38392e+01,4.03341e+01,1.41254e-02,4.24495e+01,3.90710e+01,
1.44544e-02,3.98021e+01,3.66611e+01,1.49624e-02,3.61361e+01,3.33166e+01,1.50000e-02,3.58831e+01,3.30854e+01,1.54882e-02,
3.27668e+01,3.02334e+01,1.55077e-02,3.26499e+01,3.01263e+01,1.58489e-02,3.06959e+01,2.83353e+01,1.58490e-02,3.06955e+01,
2.83349e+01,1.62181e-02,2.87569e+01,2.65555e+01,1.65959e-02,2.69419e+01,2.48870e+01,1.69824e-02,2.52426e+01,2.33226e+01,
1.71189e-02,2.46770e+01,2.28014e+01,1.71791e-02,2.44331e+01,2.25767e+01,1.75792e-02,2.28916e+01,2.11553e+01,1.77828e-02,
2.21581e+01,2.04783e+01,1.79887e-02,2.14484e+01,1.98229e+01,1.81970e-02,2.07617e+01,1.91882e+01,1.86209e-02,1.94375e+01,
1.79628e+01,1.90675e-02,1.81640e+01,1.67830e+01,1.97242e-02,1.64887e+01,1.52296e+01,1.99526e-02,1.59556e+01,1.47348e+01,
1.99530e-02,1.59547e+01,1.47340e+01,2.01837e-02,1.54399e+01,1.42560e+01,2.11349e-02,1.35391e+01,1.24891e+01,2.13724e-02,
1.31149e+01,1.20943e+01,2.13796e-02,1.31023e+01,1.20827e+01,2.16272e-02,1.26796e+01,1.16893e+01,2.18776e-02,1.22708e+01,
1.13087e+01,2.21309e-02,1.18754e+01,1.09405e+01,2.26464e-02,1.11140e+01,1.02307e+01,2.31740e-02,1.04024e+01,9.56686e+00,
2.34423e-02,1.00643e+01,9.25123e+00,2.37479e-02,9.69724e+00,8.90850e+00,2.39883e-02,9.42109e+00,8.65070e+00,2.51189e-02,
8.25664e+00,7.56276e+00,2.51190e-02,8.25651e+00,7.56264e+00,2.66073e-02,7.00581e+00,6.39305e+00,2.69154e-02,6.78002e+00,
6.18174e+00,2.71179e-02,6.63703e+00,6.04790e+00,2.72270e-02,6.56167e+00,5.97740e+00,2.81838e-02,5.94233e+00,5.39751e+00,
2.88403e-02,5.56328e+00,5.04245e+00,3.01995e-02,4.87799e+00,4.40023e+00,3.16228e-02,4.28025e+00,3.83981e+00,3.16230e-02,
4.28016e+00,3.83973e+00,3.19889e-02,4.14299e+00,3.71125e+00,3.34965e-02,3.63847e+00,3.23872e+00,3.38844e-02,3.52153e+00,
3.12914e+00,3.46737e-02,3.29937e+00,2.92101e+00,3.63078e-02,2.89808e+00,2.54511e+00,3.67282e-02,2.80610e+00,2.45898e+00,
3.91113e-02,2.35607e+00,2.03772e+00,3.98107e-02,2.24360e+00,1.93261e+00,3.98110e-02,2.24356e+00,1.93257e+00,4.07380e-02,
2.10592e+00,1.80422e+00,4.16869e-02,1.97736e+00,1.68440e+00,4.21696e-02,1.91574e+00,1.62698e+00,4.36516e-02,1.74305e+00,
1.46613e+00,4.41570e-02,1.68935e+00,1.41616e+00,4.62381e-02,1.49222e+00,1.23287e+00,4.68013e-02,1.44477e+00,1.18880e+00,
5.01187e-02,1.20632e+00,9.67883e-01,5.01190e-02,1.20630e+00,9.67867e-01,5.18800e-02,1.10311e+00,8.72847e-01,5.30884e-02,
1.03995e+00,8.14776e-01,5.37032e-02,1.00970e+00,7.86988e-01,5.49541e-02,9.52268e-01,7.34281e-01,5.68853e-02,8.73242e-01,
6.61909e-01,5.72343e-02,8.60084e-01,6.49877e-01,6.30957e-02,6.79569e-01,4.85756e-01,6.30960e-02,6.79562e-01,4.85750e-01,
6.53131e-02,6.26957e-01,4.38572e-01,6.76083e-02,5.79442e-01,3.96132e-01,6.77172e-02,5.77344e-01,3.94263e-01,6.83912e-02,
5.64630e-01,3.82963e-01,6.91831e-02,5.50211e-01,3.70156e-01,7.32825e-02,4.85090e-01,3.12584e-01,7.67362e-02,4.40446e-01,
2.73419e-01,7.85236e-02,4.20306e-01,2.55850e-01,7.94328e-02,4.10738e-01,2.47527e-01,7.94330e-02,4.10736e-01,2.47526e-01,
7.98528e-02,4.06431e-01,2.43833e-01,8.12830e-02,3.92375e-01,2.31833e-01,8.41395e-02,3.67032e-01,2.10316e-01,8.60994e-02,
3.51498e-01,1.97210e-01,9.33254e-02,3.04585e-01,1.58099e-01,9.44061e-02,2.98729e-01,1.53277e-01,9.54993e-02,2.93064e-01,
1.48625e-01,9.88553e-02,2.77145e-01,1.35640e-01,1.00000e-01,2.72178e-01,1.31616e-01,1.02527e-01,2.61765e-01,1.23447e-01,
1.07152e-01,2.44992e-01,1.10490e-01,1.08393e-01,2.40940e-01,1.07395e-01,1.10918e-01,2.33213e-01,1.01533e-01,1.13501e-01,
2.25957e-01,9.60812e-02,1.14815e-01,2.22496e-01,9.35004e-02,1.18850e-01,2.12737e-01,8.62982e-02,1.20226e-01,2.09680e-01,
8.40669e-02,1.21619e-01,2.06716e-01,8.19152e-02,1.21990e-01,2.05947e-01,8.13589e-02,1.25890e-01,1.98335e-01,7.59135e-02,
1.25893e-01,1.98330e-01,7.59102e-02,1.33352e-01,1.85622e-01,6.74311e-02,1.34896e-01,1.83296e-01,6.59137e-02,1.36458e-01,
1.81037e-01,6.44509e-02,1.38038e-01,1.78847e-01,6.30467e-02,1.39637e-01,1.76720e-01,6.16926e-02,1.41254e-01,1.74652e-01,
6.03870e-02,1.51356e-01,1.63393e-01,5.34777e-02,1.54882e-01,1.60036e-01,5.14913e-02,1.56675e-01,1.58425e-01,5.05510e-02,
1.58489e-01,1.56856e-01,4.96441e-02,1.58490e-01,1.56856e-01,4.96437e-02,1.60324e-01,1.55271e-01,4.88044e-02,1.64059e-01,
1.52220e-01,4.72145e-02,1.64711e-01,1.51710e-01,4.69523e-02,1.71791e-01,1.46551e-01,4.43633e-02,1.75792e-01,1.43919e-01,
4.30861e-02,1.77828e-01,1.42650e-01,4.24815e-02,1.79887e-01,1.41412e-01,4.18984e-02,1.81970e-01,1.40203e-01,4.13360e-02,
1.84077e-01,1.39022e-01,4.07936e-02,1.86209e-01,1.37875e-01,4.02771e-02,1.90546e-01,1.35658e-01,3.92974e-02,1.94984e-01,
1.33539e-01,3.83846e-02,1.97242e-01,1.32515e-01,3.79518e-02,1.99526e-01,1.31512e-01,3.75339e-02,1.99530e-01,1.31511e-01,
3.75333e-02,2.01837e-01,1.30485e-01,3.71656e-02,2.04174e-01,1.29479e-01,3.68102e-02,2.11349e-01,1.26582e-01,3.58167e-02,
2.13796e-01,1.25654e-01,3.55082e-02,2.17814e-01,1.24192e-01,3.50315e-02,2.18776e-01,1.23852e-01,3.49225e-02,2.29087e-01,
1.20460e-01,3.38817e-02,2.31740e-01,1.19651e-01,3.36425e-02,2.34423e-01,1.18856e-01,3.34110e-02,2.37137e-01,1.18075e-01,
3.31870e-02,2.51189e-01,1.14370e-01,3.21701e-02,2.51190e-01,1.14370e-01,3.21700e-02,2.54097e-01,1.13628e-01,3.20176e-02,
2.57040e-01,1.12900e-01,3.18726e-02,2.63027e-01,1.11478e-01,3.15956e-02,2.72270e-01,1.09425e-01,3.12093e-02,2.75423e-01,
1.08760e-01,3.10877e-02,2.81838e-01,1.07460e-01,3.08545e-02,2.88403e-01,1.06197e-01,3.06333e-02,2.91743e-01,1.05578e-01,
3.05268e-02,2.92885e-01,1.05370e-01,3.04921e-02,2.95121e-01,1.04969e-01,3.04253e-02,2.98538e-01,1.04368e-01,3.03261e-02,
3.09029e-01,1.02611e-01,3.00412e-02,3.12608e-01,1.02040e-01,2.99500e-02,3.16228e-01,1.01476e-01,2.98607e-02,3.16230e-01,
1.01476e-01,2.98607e-02,3.19889e-01,1.00888e-01,2.98031e-02,3.23594e-01,1.00307e-01,2.97464e-02,3.27341e-01,9.97328e-02,
2.96903e-02,3.31131e-01,9.91652e-02,2.96350e-02,3.38844e-01,9.80529e-02,2.95296e-02,3.50752e-01,9.64299e-02,2.93743e-02,
3.54813e-01,9.59005e-02,2.93231e-02,3.58922e-01,9.53768e-02,2.92722e-02,3.63078e-01,9.48586e-02,2.92216e-02,3.67282e-01,
9.43457e-02,2.91710e-02,3.71535e-01,9.38380e-02,2.91206e-02,3.80189e-01,9.28405e-02,2.90225e-02,3.84592e-01,9.23490e-02,
2.89734e-02,3.89045e-01,9.18622e-02,2.89241e-02,3.93550e-01,9.13801e-02,2.88748e-02,3.98107e-01,9.09024e-02,2.88252e-02,
3.98110e-01,9.09021e-02,2.88252e-02,4.02717e-01,9.04030e-02,2.88022e-02,4.12098e-01,8.94179e-02,2.87534e-02,4.16869e-01,
8.89330e-02,2.87288e-02,4.24191e-01,8.82078e-02,2.86896e-02,4.31519e-01,8.75031e-02,2.86488e-02,4.36516e-01,8.70345e-02,
2.86203e-02,4.41570e-01,8.65699e-02,2.85907e-02,4.51856e-01,8.56525e-02,2.85290e-02,4.57088e-01,8.51995e-02,2.84967e-02,
4.62381e-01,8.47511e-02,2.84643e-02,4.73151e-01,8.38650e-02,2.83966e-02,4.78630e-01,8.34272e-02,2.83613e-02,4.84172e-01,
8.29928e-02,2.83250e-02,4.89779e-01,8.25619e-02,2.82877e-02,5.01187e-01,8.17099e-02,2.82106e-02,5.01190e-01,8.17097e-02,
2.82106e-02,5.06991e-01,8.12660e-02,2.81940e-02,5.12861e-01,8.08262e-02,2.81764e-02,5.24808e-01,7.99564e-02,2.81367e-02,
5.30884e-01,7.95263e-02,2.81145e-02,5.37032e-01,7.90994e-02,2.80908e-02,5.43250e-01,7.86755e-02,2.80657e-02,5.49541e-01,
7.82548e-02,2.80391e-02,5.55904e-01,7.78371e-02,2.80112e-02,5.75440e-01,7.66033e-02,2.79205e-02,5.82103e-01,7.61978e-02,
2.78876e-02,5.88844e-01,7.57950e-02,2.78533e-02,5.95662e-01,7.53951e-02,2.78177e-02,6.02560e-01,7.49979e-02,2.77809e-02,
6.09537e-01,7.46034e-02,2.77429e-02,6.16595e-01,7.42120e-02,2.77040e-02,6.30957e-01,7.34370e-02,2.76227e-02,6.30960e-01,
7.34369e-02,2.76227e-02,6.38264e-01,7.30327e-02,2.75990e-02,6.45654e-01,7.26311e-02,2.75736e-02,6.53131e-01,7.22322e-02,
2.75466e-02,6.60694e-01,7.18360e-02,2.75179e-02,6.68344e-01,7.14425e-02,2.74876e-02,6.83912e-01,7.06639e-02,2.74231e-02,
6.91831e-01,7.02784e-02,2.73886e-02,6.97831e-01,6.99910e-02,2.73617e-02,6.99842e-01,6.98954e-02,2.73525e-02,7.07946e-01,
6.95149e-02,2.73150e-02,7.08570e-01,6.94858e-02,2.73121e-02,7.16143e-01,6.91368e-02,2.72761e-02,7.24436e-01,6.87611e-02,
2.72358e-02,7.32825e-01,6.83879e-02,2.71941e-02,7.58578e-01,6.72831e-02,2.70620e-02,7.67362e-01,6.69195e-02,2.70154e-02,
7.76247e-01,6.65582e-02,2.69676e-02,7.85236e-01,6.61991e-02,2.69186e-02,7.94328e-01,6.58423e-02,2.68684e-02,7.94330e-01,
6.58422e-02,2.68684e-02,8.03526e-01,6.54686e-02,2.68317e-02,8.31764e-01,6.43625e-02,2.67129e-02,8.41395e-01,6.39985e-02,
2.66703e-02,8.51138e-01,6.36368e-02,2.66262e-02,8.60994e-01,6.32773e-02,2.65807e-02,8.81049e-01,6.25652e-02,2.64856e-02,
8.91251e-01,6.22127e-02,2.64363e-02,9.01571e-01,6.18624e-02,2.63856e-02,9.12011e-01,6.15142e-02,2.63337e-02,9.22571e-01,
6.11682e-02,2.62806e-02,9.44061e-01,6.04826e-02,2.61707e-02,9.54993e-01,6.01430e-02,2.61141e-02,9.66051e-01,5.98057e-02,
2.60565e-02,9.77237e-01,5.94704e-02,2.59979e-02,9.88553e-01,5.91371e-02,2.59382e-02,1.00000e+00,5.88059e-02,2.58774e-02,
1.00000e-03,6.49283e+03,6.48458e+03,1.01538e-03,6.25624e+03,6.24820e+03,1.02329e-03,6.13927e+03,6.13135e+03,1.03514e-03,
5.97014e+03,5.96237e+03,1.04713e-03,5.80384e+03,5.79622e+03,1.05925e-03,5.64222e+03,5.63475e+03,1.08393e-03,5.32864e+03,
5.32145e+03,1.09648e-03,5.17863e+03,5.17158e+03,1.10000e-03,5.13763e+03,5.13060e+03,1.12202e-03,4.89126e+03,4.88445e+03,
1.13501e-03,4.75299e+03,4.74630e+03,1.14321e-03,4.66803e+03,4.66141e+03,1.15000e-03,4.59922e+03,4.59266e+03,1.16145e-03,
4.48645e+03,4.47998e+03,1.17490e-03,4.35754e+03,4.35119e+03,1.23027e-03,3.87867e+03,3.87271e+03,1.23877e-03,3.81187e+03,
3.80597e+03,1.24451e-03,3.76765e+03,3.76179e+03,1.25890e-03,3.66011e+03,3.65434e+03,1.25892e-03,3.65993e+03,3.65416e+03,
1.30317e-03,3.35490e+03,3.34939e+03,1.31826e-03,3.25866e+03,3.25322e+03,1.35000e-03,3.06766e+03,3.06238e+03,1.36458e-03,
2.98436e+03,2.97915e+03,1.39637e-03,2.81350e+03,2.80842e+03,1.42000e-03,2.69535e+03,2.69037e+03,1.42889e-03,2.65266e+03,
2.64771e+03,1.45482e-03,2.53284e+03,2.52798e+03,1.46218e-03,2.50023e+03,2.49540e+03,1.47911e-03,2.42707e+03,2.42230e+03,
1.49624e-03,2.35607e+03,2.35137e+03,1.51356e-03,2.28722e+03,2.28257e+03,1.56675e-03,2.09130e+03,2.08682e+03,1.58489e-03,
2.02992e+03,2.02548e+03,1.58490e-03,2.02989e+03,2.02545e+03,1.60325e-03,1.97039e+03,1.96600e+03,1.62883e-03,1.89138e+03,
1.88705e+03,1.65000e-03,1.82927e+03,1.82500e+03,1.67880e-03,1.74891e+03,1.74471e+03,1.69824e-03,1.69744e+03,1.69328e+03,
1.73780e-03,1.59869e+03,1.59461e+03,1.79887e-03,1.46032e+03,1.45637e+03,1.81970e-03,1.41700e+03,1.41308e+03,1.84077e-03,
1.37496e+03,1.37109e+03,1.86209e-03,1.33396e+03,1.33012e+03,1.90000e-03,1.26518e+03,1.26140e+03,1.90546e-03,1.25568e+03,
1.25191e+03,1.99526e-03,1.11236e+03,1.10873e+03,1.99530e-03,1.11231e+03,1.10867e+03,2.00000e-03,1.10544e+03,1.10182e+03,
2.01837e-03,1.07902e+03,1.07542e+03,2.04174e-03,1.04666e+03,1.04310e+03,2.09588e-03,9.76749e+02,9.73253e+02,2.11349e-03,
9.55399e+02,9.51927e+02,2.16272e-03,8.98769e+02,8.95358e+02,2.18776e-03,8.71751e+02,8.68369e+02,2.21310e-03,8.45455e+02,
8.42103e+02,2.26464e-03,7.95254e+02,7.91959e+02,2.29087e-03,7.71316e+02,7.68049e+02,2.31740e-03,7.47949e+02,7.44709e+02,
2.35872e-03,7.13470e+02,7.10271e+02,2.37137e-03,7.03347e+02,7.00161e+02,2.40000e-03,6.81202e+02,6.78045e+02,2.45471e-03,
6.41284e+02,6.38182e+02,2.51189e-03,6.02994e+02,5.99944e+02,2.51190e-03,6.02985e+02,5.99935e+02,2.54097e-03,5.84717e+02,
5.81693e+02,2.57040e-03,5.66962e+02,5.63963e+02,2.60016e-03,5.49748e+02,5.46775e+02,2.63027e-03,5.33074e+02,5.30125e+02,
2.65628e-03,5.19134e+02,5.16207e+02,2.69154e-03,5.01031e+02,4.98133e+02,2.72270e-03,4.85764e+02,4.82891e+02,2.78612e-03,
4.56436e+02,4.53614e+02,2.87006e-03,4.21307e+02,4.18548e+02,2.90000e-03,4.09674e+02,4.06937e+02,2.91743e-03,4.03097e+02,
4.00374e+02,2.98538e-03,3.78822e+02,3.76148e+02,3.00000e-03,3.73866e+02,3.71202e+02,3.01995e-03,3.67240e+02,3.64590e+02,
3.05492e-03,3.55949e+02,3.53322e+02,3.09030e-03,3.45017e+02,3.42414e+02,3.10355e-03,3.41045e+02,3.38451e+02,3.16228e-03,
3.24179e+02,3.21625e+02,3.16230e-03,3.24173e+02,3.21619e+02,3.31131e-03,2.86006e+02,2.83548e+02,3.36517e-03,2.73726e+02,
2.71300e+02,3.38844e-03,2.68641e+02,2.66230e+02,3.46737e-03,2.52350e+02,2.49988e+02,3.50752e-03,2.44584e+02,2.42246e+02,
3.58922e-03,2.29700e+02,2.27409e+02,3.63078e-03,2.22610e+02,2.20342e+02,3.64055e-03,2.20979e+02,2.18716e+02,3.84592e-03,
1.90160e+02,1.88013e+02,3.93757e-03,1.78302e+02,1.76202e+02,3.98107e-03,1.73024e+02,1.70948e+02,3.98110e-03,1.73021e+02,
1.70945e+02,4.02717e-03,1.67663e+02,1.65612e+02,4.07380e-03,1.62475e+02,1.60448e+02,4.09075e-03,1.60634e+02,1.58616e+02,
4.12097e-03,1.57423e+02,1.55421e+02,4.16869e-03,1.52534e+02,1.50557e+02,4.23578e-03,1.45970e+02,1.44027e+02,4.35666e-03,
1.35080e+02,1.33200e+02,4.41570e-03,1.30160e+02,1.28312e+02,4.47376e-03,1.25571e+02,1.23752e+02,4.51856e-03,1.22177e+02,
1.20383e+02,4.57088e-03,1.18366e+02,1.16599e+02,4.58174e-03,1.17597e+02,1.15835e+02,4.67735e-03,1.11105e+02,1.09394e+02,
4.75784e-03,1.06012e+02,1.04346e+02,4.78630e-03,1.04287e+02,1.02638e+02,4.80000e-03,1.03467e+02,1.01826e+02,4.83955e-03,
1.01130e+02,9.95106e+01,4.84172e-03,1.01003e+02,9.93854e+01,4.91287e-03,9.69869e+01,9.54120e+01,4.96804e-03,9.40183e+01,
9.24785e+01,5.01187e-03,9.17442e+01,9.02340e+01,5.01190e-03,9.17428e+01,9.02326e+01,5.02066e-03,9.12975e+01,8.97931e+01,
5.06762e-03,8.89557e+01,8.74850e+01,5.06991e-03,8.88437e+01,8.73748e+01,5.11325e-03,8.67608e+01,8.53253e+01,5.15249e-03,
8.49280e+01,8.35257e+01,5.17613e-03,8.38470e+01,8.24663e+01,5.21054e-03,8.23026e+01,8.09565e+01,5.23975e-03,8.10173e+01,
7.97045e+01,5.26463e-03,7.99389e+01,7.86587e+01,5.28551e-03,7.90443e+01,7.77953e+01,5.30680e-03,7.81410e+01,7.69281e+01,
5.30884e-03,7.80544e+01,7.68455e+01,5.33541e-03,7.69415e+01,7.57831e+01,5.37032e-03,7.55087e+01,7.44173e+01,5.37657e-03,
7.52564e+01,7.41765e+01,5.39289e-03,7.46080e+01,7.35524e+01,5.40685e-03,7.40652e+01,7.30243e+01,5.41651e-03,7.36967e+01,
7.26618e+01,5.42879e-03,7.32374e+01,7.22048e+01,5.43250e-03,7.31012e+01,7.20673e+01,5.43960e-03,7.28415e+01,7.18054e+01,
5.43960e-03,5.95139e+02,4.76049e+02,5.44084e-03,5.94817e+02,4.75817e+02,5.44855e-03,5.92829e+02,4.74380e+02,5.45694e-03,
5.90676e+02,4.72821e+02,5.47221e-03,5.86794e+02,4.70003e+02,5.49178e-03,5.81884e+02,4.66427e+02,5.53432e-03,5.71420e+02,
4.58782e+02,5.55904e-03,5.65460e+02,4.54420e+02,5.55954e-03,5.65342e+02,4.54334e+02,5.57042e-03,5.62741e+02,4.52430e+02,
5.58500e-03,5.59280e+02,4.49895e+02,5.60019e-03,5.55605e+02,4.47196e+02,5.62146e-03,5.50513e+02,4.43454e+02,5.62341e-03,
5.50049e+02,4.43113e+02,5.64510e-03,5.44928e+02,4.39348e+02,5.66934e-03,5.39280e+02,4.35192e+02,5.68853e-03,5.34865e+02,
4.31941e+02,5.71746e-03,5.28306e+02,4.27104e+02,5.74816e-03,5.21467e+02,4.22054e+02,5.75440e-03,5.20090e+02,4.21037e+02,
5.82103e-03,5.05179e+02,4.09958e+02,5.90797e-03,4.86609e+02,3.96105e+02,6.01877e-03,4.64290e+02,3.79372e+02,6.10748e-03,
4.47434e+02,3.66671e+02,6.22664e-03,4.26106e+02,3.50518e+02,6.23735e-03,4.24259e+02,3.49115e+02,6.30957e-03,4.12094e+02,
3.39855e+02,6.30960e-03,4.12089e+02,3.39852e+02,6.38263e-03,4.00278e+02,3.30831e+02,6.40000e-03,3.97540e+02,3.28735e+02,
6.40737e-03,3.96350e+02,3.27821e+02,6.45654e-03,3.88532e+02,3.21812e+02,6.50000e-03,3.81792e+02,3.16621e+02,6.60693e-03,
3.65877e+02,3.04322e+02,6.64265e-03,3.60767e+02,3.00361e+02,6.68344e-03,3.55051e+02,2.95924e+02,6.76083e-03,3.44546e+02,
2.87766e+02,6.83912e-03,3.34353e+02,2.79825e+02,6.91442e-03,3.24941e+02,2.72470e+02,7.00000e-03,3.14682e+02,2.64429e+02,
7.24436e-03,2.87527e+02,2.43002e+02,7.24980e-03,2.86961e+02,2.42553e+02,7.49894e-03,2.62564e+02,2.23136e+02,7.50000e-03,
2.62467e+02,2.23058e+02,7.68321e-03,2.46309e+02,2.10105e+02,7.76247e-03,2.39743e+02,2.04820e+02,7.85236e-03,2.32588e+02,
1.99047e+02,7.94328e-03,2.25647e+02,1.93432e+02,7.94330e-03,2.25646e+02,1.93431e+02,8.00000e-03,2.21462e+02,1.90039e+02,
8.12830e-03,2.12385e+02,1.82662e+02,8.29126e-03,2.01502e+02,1.73778e+02,8.41395e-03,1.93809e+02,1.67476e+02,8.70964e-03,
1.76863e+02,1.53524e+02,8.80000e-03,1.72087e+02,1.49574e+02,8.81049e-03,1.71533e+02,1.49115e+02,9.12011e-03,1.56236e+02,
1.36390e+02,9.13582e-03,1.55510e+02,1.35784e+02,9.22571e-03,1.51447e+02,1.32389e+02,9.33254e-03,1.46806e+02,1.28504e+02,
9.77237e-03,1.29629e+02,1.14051e+02,9.88553e-03,1.25661e+02,1.10695e+02,9.98218e-03,1.22403e+02,1.07936e+02,1.00000e-02,
1.21814e+02,1.07438e+02,1.01158e-02,1.18086e+02,1.04275e+02,1.02329e-02,1.14468e+02,1.01200e+02,1.03514e-02,1.10960e+02,
9.82138e+01,1.04713e-02,1.07561e+02,9.53135e+01,1.05925e-02,1.04266e+02,9.24976e+01,1.07152e-02,1.01073e+02,8.97637e+01,
1.08393e-02,9.79782e+01,8.71091e+01,1.13007e-02,8.73402e+01,7.79391e+01,1.13501e-02,8.62961e+01,7.70362e+01,1.17490e-02,
7.84629e+01,7.02438e+01,1.21619e-02,7.13374e+01,6.40354e+01,1.23027e-02,6.91093e+01,6.20880e+01,1.24451e-02,6.69513e+01,
6.01991e+01,1.25890e-02,6.48650e+01,5.83703e+01,1.25892e-02,6.48614e+01,5.83671e+01,1.26642e-02,6.38097e+01,5.74442e+01,
1.33352e-02,5.53552e+01,5.00016e+01,1.38038e-02,5.02603e+01,4.54908e+01,1.41254e-02,4.71259e+01,4.27067e+01,1.41427e-02,
4.69644e+01,4.25631e+01,1.42889e-02,4.56328e+01,4.13785e+01,1.44544e-02,4.41873e+01,4.00910e+01,1.47911e-02,4.14328e+01,
3.76333e+01,1.49624e-02,4.01212e+01,3.64610e+01,1.56675e-02,3.52812e+01,3.21231e+01,1.56734e-02,3.52440e+01,3.20898e+01,
1.58489e-02,3.41535e+01,3.11097e+01,1.58490e-02,3.41531e+01,3.11093e+01,1.62181e-02,3.20062e+01,2.91777e+01,1.67880e-02,
2.90352e+01,2.64979e+01,1.71791e-02,2.72110e+01,2.48483e+01,1.73294e-02,2.65511e+01,2.42509e+01,1.73780e-02,2.63424e+01,
2.40619e+01,1.81970e-02,2.31391e+01,2.11560e+01,1.86209e-02,2.16713e+01,1.98206e+01,1.86569e-02,2.15525e+01,1.97123e+01,
1.90546e-02,2.02973e+01,1.85689e+01,1.99526e-02,1.78061e+01,1.62942e+01,1.99530e-02,1.78051e+01,1.62933e+01,2.04174e-02,
1.66789e+01,1.52629e+01,2.06538e-02,1.61428e+01,1.47718e+01,2.08008e-02,1.58212e+01,1.44771e+01,2.08930e-02,1.56240e+01,
1.42964e+01,2.18776e-02,1.37119e+01,1.25422e+01,2.26464e-02,1.24205e+01,1.13543e+01,2.31654e-02,1.16406e+01,1.06358e+01,
2.31740e-02,1.16284e+01,1.06245e+01,2.37137e-02,1.08873e+01,9.94147e+00,2.42661e-02,1.01943e+01,9.30209e+00,2.45471e-02,
9.86487e+00,8.99793e+00,2.51189e-02,9.23835e+00,8.41902e+00,2.51190e-02,9.23820e+00,8.41889e+00,2.57322e-02,8.62528e+00,
7.85226e+00,2.60016e-02,8.37349e+00,7.61948e+00,2.66073e-02,7.84323e+00,7.12897e+00,2.69154e-02,7.58833e+00,6.89295e+00,
2.81838e-02,6.65018e+00,6.02348e+00,2.88403e-02,6.22673e+00,5.63065e+00,2.95121e-02,5.83109e+00,5.26339e+00,3.01995e-02,
5.46141e+00,4.92005e+00,3.04139e-02,5.35279e+00,4.81912e+00,3.09030e-02,5.11594e+00,4.59908e+00,3.16228e-02,4.79309e+00,
4.29901e+00,3.16230e-02,4.79299e+00,4.29892e+00,3.19889e-02,4.63958e+00,4.15641e+00,3.23594e-02,4.49118e+00,4.01854e+00,
3.31131e-02,4.20595e+00,3.75336e+00,3.34965e-02,4.07050e+00,3.62742e+00,3.54813e-02,3.45856e+00,3.05829e+00,3.71535e-02,
3.03908e+00,2.66806e+00,3.80189e-02,2.84991e+00,2.49206e+00,3.93550e-02,2.58933e+00,2.24966e+00,3.98107e-02,2.50817e+00,
2.17416e+00,3.98110e-02,2.50812e+00,2.17411e+00,3.98680e-02,2.49820e+00,2.16491e+00,4.00000e-02,2.47546e+00,2.14381e+00,
4.07380e-02,2.35238e+00,2.02959e+00,4.31519e-02,2.00603e+00,1.70837e+00,4.57088e-02,1.71448e+00,1.43827e+00,4.84172e-02,
1.46901e+00,1.21119e+00,5.01187e-02,1.34063e+00,1.09260e+00,5.01190e-02,1.34061e+00,1.09258e+00,5.06991e-02,1.30060e+00,
1.05576e+00,5.24807e-02,1.18745e+00,9.51699e-01,5.33672e-02,1.13666e+00,9.05049e-01,5.37032e-02,1.11826e+00,8.88175e-01,
6.02560e-02,8.35385e-01,6.29694e-01,6.30957e-02,7.46756e-01,5.49161e-01,6.30960e-02,7.46748e-01,5.49154e-01,6.32544e-02,
7.42245e-01,5.45094e-01,6.60693e-02,6.69041e-01,4.79350e-01,6.76083e-02,6.33736e-01,4.47729e-01,6.99842e-02,5.85123e-01,
4.04325e-01,7.52007e-02,4.98624e-01,3.27574e-01,7.58578e-02,4.89334e-01,3.19392e-01,7.76247e-02,4.65870e-01,2.98772e-01,
7.94328e-02,4.43936e-01,2.79558e-01,7.94330e-02,4.43934e-01,2.79556e-01,8.22243e-02,4.13450e-01,2.53289e-01,8.31764e-02,
4.03952e-01,2.45140e-01,8.41395e-02,3.94768e-01,2.37278e-01,8.51138e-02,3.85888e-01,2.29692e-01,8.81049e-02,3.60961e-01,
2.08497e-01,9.03795e-02,3.44101e-01,1.94252e-01,9.12011e-02,3.38398e-01,1.89461e-01,9.54993e-02,3.11505e-01,1.66995e-01,
9.66051e-02,3.05321e-01,1.61865e-01,9.88553e-02,2.93551e-01,1.52144e-01,1.00000e-01,2.87950e-01,1.47538e-01,1.03514e-01,
2.71982e-01,1.34782e-01,1.05925e-01,2.62165e-01,1.27014e-01,1.07152e-01,2.57490e-01,1.23336e-01,1.08393e-01,2.52961e-01,
1.19788e-01,1.09272e-01,2.49869e-01,1.17374e-01,1.10918e-01,2.44309e-01,1.13066e-01,1.16145e-01,2.28557e-01,1.00995e-01,
1.23027e-01,2.11462e-01,8.81664e-02,1.25890e-01,2.05342e-01,8.36543e-02,1.25893e-01,2.05336e-01,8.36505e-02,1.35274e-01,
1.88054e-01,7.16907e-02,1.36458e-01,1.86164e-01,7.04158e-02,1.39637e-01,1.81369e-01,6.72133e-02,1.41254e-01,1.79075e-01,
6.56972e-02,1.44544e-01,1.74681e-01,6.28255e-02,1.46218e-01,1.72584e-01,6.14728e-02,1.54882e-01,1.62946e-01,5.53959e-02,
1.58489e-01,1.59453e-01,5.32575e-02,1.58490e-01,1.59452e-01,5.32571e-02,1.60324e-01,1.57721e-01,5.22794e-02,1.62181e-01,
1.56034e-01,5.13363e-02,1.67880e-01,1.51232e-01,4.87040e-02,1.71791e-01,1.48232e-01,4.71017e-02,1.77828e-01,1.44008e-01,
4.49051e-02,1.78888e-01,1.43313e-01,4.45504e-02,1.81970e-01,1.41359e-01,4.35671e-02,1.86209e-01,1.38835e-01,4.23220e-02,
1.90546e-01,1.36445e-01,4.11772e-02,1.97242e-01,1.33063e-01,3.96042e-02,1.99526e-01,1.31987e-01,3.91156e-02,1.99530e-01,
1.31985e-01,3.91148e-02,2.01837e-01,1.30889e-01,3.86778e-02,2.06538e-01,1.28763e-01,3.78475e-02,2.08930e-01,1.27734e-01,
3.74539e-02,2.13796e-01,1.25741e-01,3.67078e-02,2.18776e-01,1.23828e-01,3.60119e-02,2.21309e-01,1.22901e-01,3.56815e-02,
2.31740e-01,1.19390e-01,3.44859e-02,2.34423e-01,1.18553e-01,3.42110e-02,2.37137e-01,1.17733e-01,3.39450e-02,2.39883e-01,
1.16927e-01,3.36876e-02,2.40255e-01,1.16820e-01,3.36536e-02,2.42661e-01,1.16135e-01,3.34384e-02,2.45471e-01,1.15357e-01,
3.31971e-02,2.51189e-01,1.13842e-01,3.27377e-02,2.51190e-01,1.13842e-01,3.27376e-02,2.54097e-01,1.13068e-01,3.25505e-02,
2.57040e-01,1.12306e-01,3.23692e-02,2.60016e-01,1.11560e-01,3.21969e-02,2.63027e-01,1.10826e-01,3.20298e-02,2.63880e-01,
1.10622e-01,3.19837e-02,2.69154e-01,1.09393e-01,3.17103e-02,2.75423e-01,1.08005e-01,3.14090e-02,2.78612e-01,1.07327e-01,
3.12647e-02,2.81838e-01,1.06659e-01,3.11244e-02,2.91743e-01,1.04715e-01,3.07266e-02,2.95121e-01,1.04085e-01,3.06009e-02,
2.98538e-01,1.03465e-01,3.04783e-02,3.00000e-01,1.03206e-01,3.04284e-02,3.16228e-01,1.00500e-01,2.99202e-02,3.16230e-01,
1.00500e-01,2.99201e-02,3.19889e-01,9.98999e-02,2.98451e-02,3.23594e-01,9.93071e-02,2.97715e-02,3.26847e-01,9.87981e-02,
2.97087e-02,3.27341e-01,9.87216e-02,2.96993e-02,3.38844e-01,9.70059e-02,2.94898e-02,3.50752e-01,9.53564e-02,2.92949e-02,
3.58922e-01,9.42876e-02,2.91685e-02,3.63078e-01,9.37620e-02,2.91062e-02,3.80189e-01,9.17166e-02,2.88623e-02,3.84592e-01,
9.12202e-02,2.88038e-02,3.89045e-01,9.07288e-02,2.87455e-02,3.98107e-01,8.97607e-02,2.86295e-02,3.98110e-01,8.97604e-02,
2.86294e-02,4.02717e-01,8.92579e-02,2.85977e-02,4.07380e-01,8.87600e-02,2.85654e-02,4.12098e-01,8.82669e-02,2.85326e-02,
4.21697e-01,8.72947e-02,2.84651e-02,4.41570e-01,8.54079e-02,2.83265e-02,4.46684e-01,8.49466e-02,2.82900e-02,4.51856e-01,
8.44893e-02,2.82527e-02,4.57088e-01,8.40361e-02,2.82149e-02,4.59860e-01,8.37997e-02,2.81947e-02,4.67735e-01,8.31413e-02,
2.81369e-02,4.84172e-01,8.18296e-02,2.80171e-02,4.84739e-01,8.17858e-02,2.80129e-02,4.89779e-01,8.13992e-02,2.79756e-02,
4.95450e-01,8.09723e-02,2.79333e-02,5.01187e-01,8.05487e-02,2.78903e-02,5.01190e-01,8.05485e-02,2.78903e-02,5.06991e-01,
8.01063e-02,2.78695e-02,5.18800e-01,7.92317e-02,2.78238e-02,5.30884e-01,7.83722e-02,2.77741e-02,5.37032e-01,7.79473e-02,
2.77472e-02,5.43250e-01,7.75256e-02,2.77190e-02,5.49541e-01,7.71071e-02,2.76895e-02,5.55904e-01,7.66918e-02,2.76587e-02,
5.68853e-01,7.58703e-02,2.75933e-02,5.82103e-01,7.50619e-02,2.75241e-02,5.88844e-01,7.46620e-02,2.74877e-02,6.00000e-01,
7.40162e-02,2.74257e-02,6.02560e-01,7.38707e-02,2.74113e-02,6.23735e-01,7.27045e-02,2.72882e-02,6.30957e-01,7.23217e-02,
2.72454e-02,6.30960e-01,7.23215e-02,2.72454e-02,6.45654e-01,7.15231e-02,2.71927e-02,6.53131e-01,7.11279e-02,2.71640e-02,
6.60694e-01,7.07355e-02,2.71337e-02,6.83912e-01,6.95741e-02,2.70339e-02,7.07946e-01,6.84372e-02,2.69224e-02,7.24436e-01,
6.76917e-02,2.68412e-02,7.32825e-01,6.73226e-02,2.67986e-02,7.41310e-01,6.69563e-02,2.67552e-02,7.49894e-01,6.65923e-02,
2.67104e-02,7.67362e-01,6.58713e-02,2.66173e-02,7.76247e-01,6.55143e-02,2.65690e-02,7.94328e-01,6.48070e-02,2.64689e-02,
7.94330e-01,6.48069e-02,2.64689e-02,8.03526e-01,6.44381e-02,2.64316e-02,8.12831e-01,6.40718e-02,2.63930e-02,8.41395e-01,
6.29870e-02,2.62683e-02,8.42097e-01,6.29611e-02,2.62651e-02,8.51138e-01,6.26300e-02,2.62239e-02,8.60994e-01,6.22753e-02,
2.61781e-02,8.70964e-01,6.19228e-02,2.61310e-02,8.81049e-01,6.15726e-02,2.60826e-02,8.91251e-01,6.12246e-02,2.60329e-02,
9.01571e-01,6.08788e-02,2.59820e-02,9.12011e-01,6.05354e-02,2.59301e-02,9.33254e-01,5.98550e-02,2.58227e-02,9.44061e-01,
5.95179e-02,2.57673e-02,9.54993e-01,5.91830e-02,2.57108e-02,9.66051e-01,5.88502e-02,2.56532e-02,9.77237e-01,5.85194e-02,
2.55947e-02,1.00000e+00,5.78645e-02,2.54749e-02,1.00000e-03,7.40624e+03,7.39295e+03,1.01751e-03,7.09953e+03,7.08676e+03,
1.03514e-03,6.80855e+03,6.79627e+03,1.04713e-03,6.62027e+03,6.60829e+03,1.09648e-03,5.91467e+03,5.90382e+03,1.12808e-03,
5.51559e+03,5.50536e+03,1.16145e-03,5.13422e+03,5.12457e+03,1.17490e-03,4.99012e+03,4.98069e+03,1.19000e-03,4.83510e+03,
4.82590e+03,1.21619e-03,4.58208e+03,4.57325e+03,1.23381e-03,4.41887e+03,4.41027e+03,1.24451e-03,4.32375e+03,4.31529e+03,
1.25890e-03,4.20047e+03,4.19219e+03,1.25892e-03,4.20026e+03,4.19198e+03,1.30317e-03,3.84948e+03,3.84169e+03,1.33352e-03,
3.63228e+03,3.62480e+03,1.35000e-03,3.52156e+03,3.51423e+03,1.36458e-03,3.42712e+03,3.41991e+03,1.37543e-03,3.35866e+03,
3.35155e+03,1.38038e-03,3.32801e+03,3.32093e+03,1.46218e-03,2.87473e+03,2.86826e+03,1.47911e-03,2.79143e+03,2.78506e+03,
1.50000e-03,2.69329e+03,2.68705e+03,1.51356e-03,2.63216e+03,2.62600e+03,1.52585e-03,2.57850e+03,2.57240e+03,1.54882e-03,
2.48217e+03,2.47620e+03,1.58489e-03,2.33873e+03,2.33294e+03,1.58490e-03,2.33870e+03,2.33292e+03,1.61180e-03,2.23913e+03,
2.23347e+03,1.64059e-03,2.13860e+03,2.13308e+03,1.69824e-03,1.95537e+03,1.95007e+03,1.71791e-03,1.89792e+03,1.89270e+03,
1.75208e-03,1.80365e+03,1.79854e+03,1.75792e-03,1.78817e+03,1.78308e+03,1.77828e-03,1.73577e+03,1.73075e+03,1.84077e-03,
1.58619e+03,1.58136e+03,1.86209e-03,1.53930e+03,1.53453e+03,1.92753e-03,1.40624e+03,1.40164e+03,1.94984e-03,1.36452e+03,
1.35997e+03,1.99526e-03,1.28487e+03,1.28043e+03,1.99530e-03,1.28481e+03,1.28036e+03,2.00000e-03,1.27694e+03,1.27250e+03,
2.01837e-03,1.24661e+03,1.24221e+03,2.03733e-03,1.21622e+03,1.21186e+03,2.06538e-03,1.17313e+03,1.16883e+03,2.08930e-03,
1.13787e+03,1.13362e+03,2.16272e-03,1.03844e+03,1.03432e+03,2.18776e-03,1.00732e+03,1.00325e+03,2.21310e-03,9.77152e+02,
9.73125e+02,2.26464e-03,9.19578e+02,9.15632e+02,2.30000e-03,8.82797e+02,8.78904e+02,2.34423e-03,8.39292e+02,8.35462e+02,
2.35677e-03,8.27464e+02,8.23651e+02,2.37137e-03,8.13974e+02,8.10182e+02,2.45471e-03,7.42098e+02,7.38420e+02,2.48313e-03,
7.19622e+02,7.15981e+02,2.51189e-03,6.97859e+02,6.94253e+02,2.51190e-03,6.97849e+02,6.94243e+02,2.57040e-03,6.56291e+02,
6.52754e+02,2.64113e-03,6.10585e+02,6.07126e+02,2.66073e-03,5.98701e+02,5.95265e+02,2.69154e-03,5.80479e+02,5.77077e+02,
2.78612e-03,5.28823e+02,5.25519e+02,2.81838e-03,5.12679e+02,5.09407e+02,2.95113e-03,4.53079e+02,4.49928e+02,3.00000e-03,
4.33534e+02,4.30428e+02,3.01995e-03,4.25909e+02,4.22821e+02,3.05492e-03,4.12914e+02,4.09856e+02,3.09030e-03,4.00177e+02,
3.97149e+02,3.16228e-03,3.75893e+02,3.72923e+02,3.16230e-03,3.75885e+02,3.72916e+02,3.18529e-03,3.68556e+02,3.65605e+02,
3.19889e-03,3.64317e+02,3.61376e+02,3.26304e-03,3.45264e+02,3.42372e+02,3.46737e-03,2.92955e+02,2.90214e+02,3.50752e-03,
2.83950e+02,2.81235e+02,3.54369e-03,2.76166e+02,2.73476e+02,3.54813e-03,2.75230e+02,2.72543e+02,3.58922e-03,2.66689e+02,
2.64031e+02,3.63078e-03,2.58416e+02,2.55786e+02,3.83193e-03,2.23067e+02,2.20564e+02,3.89045e-03,2.14035e+02,2.11568e+02,
3.97626e-03,2.01725e+02,1.99310e+02,3.98107e-03,2.01064e+02,1.98652e+02,3.98110e-03,2.01060e+02,1.98648e+02,4.02717e-03,
1.94876e+02,1.92492e+02,4.07380e-03,1.88872e+02,1.86516e+02,4.12097e-03,1.83014e+02,1.80685e+02,4.16587e-03,1.77658e+02,
1.75354e+02,4.21696e-03,1.71818e+02,1.69544e+02,4.26579e-03,1.66487e+02,1.64241e+02,4.33191e-03,1.59641e+02,1.57431e+02,
4.46684e-03,1.46818e+02,1.44682e+02,4.48640e-03,1.45079e+02,1.42953e+02,4.51856e-03,1.42282e+02,1.40174e+02,4.57088e-03,
1.37883e+02,1.35803e+02,4.62381e-03,1.33625e+02,1.31572e+02,4.64883e-03,1.31677e+02,1.29637e+02,4.67735e-03,1.29502e+02,
1.27478e+02,4.73151e-03,1.25477e+02,1.23481e+02,4.78630e-03,1.21559e+02,1.19591e+02,4.89779e-03,1.14069e+02,1.12160e+02,
4.91682e-03,1.12853e+02,1.10953e+02,4.95450e-03,1.10495e+02,1.08616e+02,5.01187e-03,1.07036e+02,1.05187e+02,5.01190e-03,
1.07035e+02,1.05185e+02,5.03461e-03,1.05708e+02,1.03870e+02,5.06991e-03,1.03688e+02,1.01869e+02,5.12308e-03,1.00745e+02,
9.89544e+01,5.22293e-03,9.55164e+01,9.37804e+01,5.24807e-03,9.42573e+01,9.25358e+01,5.30884e-03,9.13041e+01,8.96166e+01,
5.31267e-03,9.11227e+01,8.94373e+01,5.37032e-03,8.84433e+01,8.67918e+01,5.38580e-03,8.77359e+01,8.60932e+01,5.43250e-03,
8.56451e+01,8.40312e+01,5.44935e-03,8.49083e+01,8.33046e+01,5.50784e-03,8.24127e+01,8.08469e+01,5.55904e-03,8.03062e+01,
7.87757e+01,5.62341e-03,7.77350e+01,7.62533e+01,5.63206e-03,7.73984e+01,7.59231e+01,5.67023e-03,7.59318e+01,7.44889e+01,
5.69820e-03,7.48774e+01,7.34609e+01,5.70703e-03,7.45460e+01,7.31377e+01,5.73190e-03,7.36193e+01,7.22375e+01,5.73872e-03,
7.33680e+01,7.19934e+01,5.75440e-03,7.27918e+01,7.14363e+01,5.76597e-03,7.23709e+01,7.10294e+01,5.78884e-03,7.15439e+01,
7.02340e+01,5.81464e-03,7.06201e+01,6.93509e+01,5.82103e-03,7.03921e+01,6.91344e+01,5.84527e-03,6.95439e+01,6.83288e+01,
5.88844e-03,6.80641e+01,6.69250e+01,5.89070e-03,6.79877e+01,6.68524e+01,5.90959e-03,6.73620e+01,6.62521e+01,5.92599e-03,
6.68318e+01,6.57366e+01,5.93824e-03,6.64448e+01,6.53551e+01,5.95030e-03,6.60716e+01,6.49825e+01,5.95662e-03,6.58794e+01,
6.47884e+01,5.95760e-03,6.58500e+01,6.47587e+01,5.95760e-03,5.25816e+02,4.06946e+02,5.95841e-03,5.25666e+02,4.06844e+02,
5.96653e-03,5.24180e+02,4.05836e+02,5.98323e-03,5.21145e+02,4.03771e+02,5.99850e-03,5.18402e+02,4.01897e+02,6.02031e-03,
5.14527e+02,3.99241e+02,6.02560e-03,5.13596e+02,3.98602e+02,6.05583e-03,5.08333e+02,3.94983e+02,6.08200e-03,5.03839e+02,
3.91888e+02,6.10538e-03,4.99871e+02,3.89154e+02,6.12072e-03,4.97289e+02,3.87374e+02,6.15000e-03,4.92410e+02,3.84010e+02,
6.16595e-03,4.89233e+02,3.81769e+02,6.17103e-03,4.88227e+02,3.81058e+02,6.21326e-03,4.79968e+02,3.75223e+02,6.23735e-03,
4.75342e+02,3.71949e+02,6.24503e-03,4.73881e+02,3.70921e+02,6.27943e-03,4.67408e+02,3.66359e+02,6.30957e-03,4.61836e+02,
3.62426e+02,6.30960e-03,4.61831e+02,3.62423e+02,6.31537e-03,4.60775e+02,3.61677e+02,6.36028e-03,4.52669e+02,3.55940e+02,
6.45654e-03,4.35947e+02,3.44061e+02,6.50000e-03,4.28659e+02,3.38861e+02,6.53167e-03,4.23453e+02,3.35138e+02,6.60693e-03,
4.11429e+02,3.26516e+02,6.65530e-03,4.03953e+02,3.21135e+02,6.68344e-03,3.99688e+02,3.18061e+02,6.76083e-03,3.88275e+02,
3.09807e+02,6.83242e-03,3.78122e+02,3.02434e+02,6.83912e-03,3.77191e+02,3.01757e+02,6.91831e-03,3.66419e+02,2.93904e+02,
7.00000e-03,3.55751e+02,2.86092e+02,7.02578e-03,3.52330e+02,2.83570e+02,7.07946e-03,3.45351e+02,2.78416e+02,7.16143e-03,
3.35057e+02,2.70788e+02,7.23923e-03,3.25666e+02,2.63803e+02,7.24436e-03,3.25059e+02,2.63351e+02,7.49894e-03,2.96826e+02,
2.42198e+02,7.50000e-03,2.96716e+02,2.42115e+02,7.57574e-03,2.88972e+02,2.36269e+02,7.58578e-03,2.87966e+02,2.35509e+02,
7.94328e-03,2.55101e+02,2.10491e+02,7.94330e-03,2.55100e+02,2.10490e+02,8.01505e-03,2.49135e+02,2.05912e+02,8.03526e-03,
2.47490e+02,2.04647e+02,8.12830e-03,2.40113e+02,1.98965e+02,8.31764e-03,2.26016e+02,1.88055e+02,8.41395e-03,2.19275e+02,
1.82813e+02,8.47471e-03,2.15166e+02,1.79614e+02,8.60994e-03,2.06393e+02,1.72764e+02,8.70964e-03,2.00240e+02,1.67942e+02,
8.81049e-03,1.94269e+02,1.63248e+02,9.09390e-03,1.78763e+02,1.50991e+02,9.33254e-03,1.67002e+02,1.41629e+02,9.54993e-03,
1.56935e+02,1.33553e+02,9.66051e-03,1.52134e+02,1.29685e+02,9.77237e-03,1.47474e+02,1.25922e+02,9.84294e-03,1.44636e+02,
1.23624e+02,9.88553e-03,1.42959e+02,1.22265e+02,1.00000e-02,1.38582e+02,1.18713e+02,1.01158e-02,1.34341e+02,1.15262e+02,
1.02329e-02,1.30228e+02,1.11907e+02,1.08332e-02,1.11658e+02,9.66528e+01,1.08393e-02,1.11489e+02,9.65130e+01,1.09648e-02,
1.08080e+02,9.36931e+01,1.12202e-02,1.01573e+02,8.82934e+01,1.13501e-02,9.84658e+01,8.57057e+01,1.16145e-02,9.25353e+01,
8.07518e+01,1.17490e-02,8.97064e+01,7.83813e+01,1.18850e-02,8.69046e+01,7.60259e+01,1.21619e-02,8.15610e+01,7.15239e+01,
1.22494e-02,7.99654e+01,7.01761e+01,1.23027e-02,7.90142e+01,6.93719e+01,1.25890e-02,7.41624e+01,6.52611e+01,1.25892e-02,
7.41584e+01,6.52576e+01,1.28825e-02,6.96022e+01,6.13828e+01,1.31826e-02,6.53288e+01,5.77350e+01,1.33071e-02,6.36594e+01,
5.63064e+01,1.33352e-02,6.32900e+01,5.59900e+01,1.35540e-02,6.05163e+01,5.36115e+01,1.36458e-02,5.94012e+01,5.26536e+01,
1.40000e-02,5.53546e+01,4.91693e+01,1.44544e-02,5.06964e+01,4.51419e+01,1.46218e-02,4.91161e+01,4.37714e+01,1.48371e-02,
4.71466e+01,4.20591e+01,1.54882e-02,4.18083e+01,3.74025e+01,1.56675e-02,4.04825e+01,3.62420e+01,1.58489e-02,3.91992e+01,
3.51171e+01,1.58490e-02,3.91988e+01,3.51167e+01,1.64500e-02,3.53236e+01,3.17103e+01,1.65959e-02,3.44625e+01,3.09517e+01,
1.69824e-02,3.23144e+01,2.90559e+01,1.71791e-02,3.12917e+01,2.81516e+01,1.73780e-02,3.03017e+01,2.72751e+01,1.77828e-02,
2.84156e+01,2.56023e+01,1.81970e-02,2.66237e+01,2.40085e+01,1.83637e-02,2.59456e+01,2.34043e+01,1.86209e-02,2.49439e+01,
2.25114e+01,1.88365e-02,2.41445e+01,2.17980e+01,1.90546e-02,2.33710e+01,2.11068e+01,1.97242e-02,2.11977e+01,1.91611e+01,
1.99526e-02,2.05197e+01,1.85528e+01,1.99530e-02,2.05186e+01,1.85518e+01,2.01837e-02,1.98636e+01,1.79637e+01,2.03603e-02,
1.93813e+01,1.75303e+01,2.11349e-02,1.74441e+01,1.57873e+01,2.13796e-02,1.68873e+01,1.52854e+01,2.18776e-02,1.58134e+01,
1.43158e+01,2.23872e-02,1.48089e+01,1.34073e+01,2.26337e-02,1.43542e+01,1.29956e+01,2.26464e-02,1.43312e+01,1.29748e+01,
2.39883e-02,1.21665e+01,1.10113e+01,2.42661e-02,1.17752e+01,1.06556e+01,2.49351e-02,1.09012e+01,9.86003e+00,2.51189e-02,
1.06766e+01,9.65552e+00,2.51190e-02,1.06764e+01,9.65536e+00,2.54097e-02,1.03338e+01,9.34336e+00,2.57680e-02,9.93171e+00,
8.97690e+00,2.60016e-02,9.67821e+00,8.74562e+00,2.69154e-02,8.76763e+00,7.91392e+00,2.75423e-02,8.20974e+00,7.40363e+00,
2.78275e-02,7.97208e+00,7.18608e+00,2.85102e-02,7.44014e+00,6.69900e+00,2.95121e-02,6.74448e+00,6.06123e+00,3.01995e-02,
6.31825e+00,5.67001e+00,3.05492e-02,6.11547e+00,5.48376e+00,3.12608e-02,5.72986e+00,5.12937e+00,3.16228e-02,5.54461e+00,
4.95894e+00,3.16230e-02,5.54450e+00,4.95884e+00,3.19889e-02,5.36546e+00,4.79420e+00,3.27341e-02,5.02490e+00,4.48087e+00,
3.42768e-02,4.40954e+00,3.91422e+00,3.50752e-02,4.13188e+00,3.65834e+00,3.63078e-02,3.74925e+00,3.30553e+00,3.71535e-02,
3.51479e+00,3.08924e+00,3.84592e-02,3.19166e+00,2.79104e+00,3.92006e-02,3.02502e+00,2.63714e+00,3.98107e-02,2.89689e+00,
2.51891e+00,3.98110e-02,2.89683e+00,2.51886e+00,4.16869e-02,2.54759e+00,2.19706e+00,4.21696e-02,2.46750e+00,2.12326e+00,
4.36516e-02,2.24305e+00,1.91648e+00,4.41570e-02,2.17322e+00,1.85215e+00,4.67735e-02,1.85746e+00,1.56138e+00,4.78630e-02,
1.74551e+00,1.45836e+00,5.00000e-02,1.55139e+00,1.27973e+00,5.01187e-02,1.54156e+00,1.27069e+00,5.01190e-02,1.54154e+00,
1.27067e+00,5.06991e-02,1.49473e+00,1.22774e+00,5.17001e-02,1.41879e+00,1.15814e+00,5.30884e-02,1.32263e+00,1.07015e+00,
5.43250e-02,1.24504e+00,9.99207e-01,5.68853e-02,1.10484e+00,8.71218e-01,6.12532e-02,9.16257e-01,6.99557e-01,6.16595e-02,
9.01319e-01,6.86010e-01,6.30957e-02,8.51127e-01,6.40504e-01,6.30960e-02,8.51118e-01,6.40496e-01,6.76083e-02,7.19206e-01,
5.21937e-01,6.83912e-02,6.99738e-01,5.04503e-01,7.07946e-02,6.45137e-01,4.55711e-01,7.24436e-02,6.11727e-01,4.25942e-01,
7.25451e-02,6.09769e-01,4.24199e-01,7.67362e-02,5.37392e-01,3.60106e-01,7.76247e-02,5.23984e-01,3.48280e-01,7.94328e-02,
4.98498e-01,3.25848e-01,7.94330e-02,4.98496e-01,3.25846e-01,8.12830e-02,4.74511e-01,3.05020e-01,8.22243e-02,4.63110e-01,
2.95147e-01,8.31764e-02,4.52086e-01,2.85618e-01,8.41395e-02,4.41375e-01,2.76372e-01,8.56833e-02,4.25178e-01,2.62425e-01,
8.60994e-02,4.20998e-01,2.58839e-01,8.91251e-02,3.92857e-01,2.34781e-01,9.54993e-02,3.44363e-01,1.93727e-01,9.77237e-02,
3.30238e-01,1.81886e-01,9.88553e-02,3.23520e-01,1.76277e-01,1.00000e-01,3.17020e-01,1.70864e-01,1.04148e-01,2.95440e-01,
1.53357e-01,1.04713e-01,2.92744e-01,1.51191e-01,1.05925e-01,2.87140e-01,1.46698e-01,1.07152e-01,2.81715e-01,1.42365e-01,
1.10918e-01,2.66452e-01,1.30259e-01,1.12202e-01,2.61683e-01,1.26506e-01,1.17490e-01,2.44063e-01,1.12770e-01,1.23686e-01,
2.26869e-01,9.96029e-02,1.25890e-01,2.21481e-01,9.55432e-02,1.25893e-01,2.21475e-01,9.55387e-02,1.27350e-01,2.18031e-01,
9.30470e-02,1.28825e-01,2.14691e-01,9.06436e-02,1.38038e-01,1.96646e-01,7.79131e-02,1.42889e-01,1.88769e-01,7.25105e-02,
1.44544e-01,1.86294e-01,7.08359e-02,1.47911e-01,1.81558e-01,6.76625e-02,1.50000e-01,1.78804e-01,6.58388e-02,1.54882e-01,
1.72869e-01,6.19629e-02,1.58489e-01,1.68906e-01,5.94294e-02,1.58490e-01,1.68905e-01,5.94290e-02,1.60324e-01,1.66949e-01,
5.82651e-02,1.62181e-01,1.65045e-01,5.71418e-02,1.66258e-01,1.61110e-01,5.48532e-02,1.69824e-01,1.57912e-01,5.30317e-02,
1.71791e-01,1.56242e-01,5.20930e-02,1.75792e-01,1.53030e-01,5.03132e-02,1.81970e-01,1.48512e-01,4.78708e-02,1.84077e-01,
1.47081e-01,4.71130e-02,1.86209e-01,1.45685e-01,4.63815e-02,1.92752e-01,1.41699e-01,4.43365e-02,1.94984e-01,1.40441e-01,
4.37079e-02,1.99526e-01,1.38013e-01,4.25148e-02,1.99530e-01,1.38011e-01,4.25139e-02,2.01837e-01,1.36794e-01,4.19836e-02,
2.06538e-01,1.34438e-01,4.09757e-02,2.08930e-01,1.33299e-01,4.04977e-02,2.11349e-01,1.32185e-01,4.00362e-02,2.13796e-01,
1.31095e-01,3.95904e-02,2.16272e-01,1.30029e-01,3.91605e-02,2.18776e-01,1.28985e-01,3.87451e-02,2.21967e-01,1.27704e-01,
3.82426e-02,2.23872e-01,1.26962e-01,3.79561e-02,2.31740e-01,1.24077e-01,3.68690e-02,2.34423e-01,1.23159e-01,3.65359e-02,
2.37137e-01,1.22260e-01,3.62136e-02,2.39883e-01,1.21377e-01,3.59016e-02,2.42661e-01,1.20512e-01,3.55997e-02,2.45471e-01,
1.19663e-01,3.53074e-02,2.48313e-01,1.18830e-01,3.50244e-02,2.51189e-01,1.18013e-01,3.47504e-02,2.51190e-01,1.18013e-01,
3.47503e-02,2.54097e-01,1.17172e-01,3.45178e-02,2.66073e-01,1.13954e-01,3.36584e-02,2.69154e-01,1.13183e-01,3.34598e-02,
2.75423e-01,1.11688e-01,3.30882e-02,2.85102e-01,1.09534e-01,3.25698e-02,2.88403e-01,1.08838e-01,3.24066e-02,2.95121e-01,
1.07479e-01,3.20939e-02,2.98538e-01,1.06815e-01,3.19438e-02,3.00000e-01,1.06536e-01,3.18813e-02,3.05492e-01,1.05514e-01,
3.16550e-02,3.09029e-01,1.04877e-01,3.15161e-02,3.16228e-01,1.03637e-01,3.12540e-02,3.16230e-01,1.03636e-01,3.12540e-02,
3.23594e-01,1.02366e-01,3.10623e-02,3.27341e-01,1.01744e-01,3.09694e-02,3.31131e-01,1.01129e-01,3.08783e-02,3.34965e-01,
1.00523e-01,3.07893e-02,3.50752e-01,9.81721e-02,3.04486e-02,3.54813e-01,9.76046e-02,3.03691e-02,3.58922e-01,9.70437e-02,
3.02907e-02,3.67282e-01,9.59413e-02,3.01369e-02,3.71535e-01,9.53995e-02,3.00614e-02,3.80189e-01,9.43345e-02,2.99131e-02,
3.89045e-01,9.32926e-02,2.97678e-02,3.93550e-01,9.27800e-02,2.96961e-02,3.98107e-01,9.22746e-02,2.96267e-02,3.98110e-01,
9.22743e-02,2.96267e-02,4.00000e-01,9.20568e-02,2.96093e-02,4.07380e-01,9.12259e-02,2.95418e-02,4.12098e-01,9.07094e-02,
2.94989e-02,4.16869e-01,9.01980e-02,2.94556e-02,4.21697e-01,8.96918e-02,2.94121e-02,4.22912e-01,8.95660e-02,2.94011e-02,
4.26580e-01,8.91902e-02,2.93681e-02,4.36516e-01,8.82012e-02,2.92789e-02,4.46684e-01,8.72333e-02,2.91905e-02,4.51856e-01,
8.67560e-02,2.91454e-02,4.57088e-01,8.62830e-02,2.90998e-02,4.62381e-01,8.58143e-02,2.90537e-02,4.73151e-01,8.48894e-02,
2.89599e-02,4.78630e-01,8.44330e-02,2.89122e-02,4.84172e-01,8.39806e-02,2.88639e-02,4.95450e-01,8.30893e-02,2.87675e-02,
5.00000e-01,8.27395e-02,2.87286e-02,5.01187e-01,8.26492e-02,2.87184e-02,5.01190e-01,8.26490e-02,2.87184e-02,5.06991e-01,
8.21888e-02,2.86910e-02,5.12861e-01,8.17323e-02,2.86622e-02,5.18800e-01,8.12795e-02,2.86323e-02,5.37032e-01,7.99430e-02,
2.85352e-02,5.43250e-01,7.95053e-02,2.85013e-02,5.49541e-01,7.90711e-02,2.84661e-02,5.55904e-01,7.86401e-02,2.84298e-02,
5.62341e-01,7.82125e-02,2.83922e-02,5.82103e-01,7.69491e-02,2.82729e-02,5.88844e-01,7.65342e-02,2.82308e-02,5.95662e-01,
7.61230e-02,2.81884e-02,6.02560e-01,7.57148e-02,2.81448e-02,6.09537e-01,7.53096e-02,2.81002e-02,6.16595e-01,7.49073e-02,
2.80544e-02,6.30957e-01,7.41113e-02,2.79600e-02,6.30960e-01,7.41111e-02,2.79600e-02,6.38264e-01,7.36975e-02,2.79310e-02,
6.45654e-01,7.32867e-02,2.79005e-02,6.53131e-01,7.28793e-02,2.78691e-02,6.60694e-01,7.24748e-02,2.78360e-02,6.68344e-01,
7.20731e-02,2.78015e-02,6.76083e-01,7.16742e-02,2.77655e-02,6.79093e-01,7.15211e-02,2.77513e-02,6.83912e-01,7.12781e-02,
2.77282e-02,6.91831e-01,7.08846e-02,2.76894e-02,7.08570e-01,7.00760e-02,2.76045e-02,7.16143e-01,6.97206e-02,2.75653e-02,
7.24436e-01,6.93382e-02,2.75217e-02,7.32825e-01,6.89584e-02,2.74768e-02,7.41310e-01,6.85810e-02,2.74306e-02,7.49894e-01,
6.82062e-02,2.73832e-02,7.76247e-01,6.70965e-02,2.72339e-02,7.85236e-01,6.67318e-02,2.71822e-02,7.94328e-01,6.63693e-02,
2.71294e-02,7.94330e-01,6.63693e-02,2.71294e-02,8.03526e-01,6.59896e-02,2.70897e-02,8.12831e-01,6.56125e-02,2.70485e-02,
8.41395e-01,6.44958e-02,2.69160e-02,8.51138e-01,6.41284e-02,2.68690e-02,8.60994e-01,6.37636e-02,2.68209e-02,8.81049e-01,
6.30412e-02,2.67207e-02,8.91251e-01,6.26834e-02,2.66687e-02,9.01571e-01,6.23280e-02,2.66154e-02,9.12011e-01,6.19748e-02,
2.65610e-02,9.33254e-01,6.12752e-02,2.64486e-02,9.44061e-01,6.09287e-02,2.63907e-02,9.54993e-01,6.05847e-02,2.63320e-02,
9.66051e-01,6.02428e-02,2.62722e-02,9.77237e-01,5.99031e-02,2.62114e-02,1.00000e+00,5.92301e-02,2.60867e-02,1.00000e-03,
8.10558e+03,8.08698e+03,1.03000e-03,7.56046e+03,7.54318e+03,1.03432e-03,7.48535e+03,7.46825e+03,1.04713e-03,7.26858e+03,
7.25200e+03,1.05925e-03,7.07023e+03,7.05411e+03,1.08238e-03,6.71064e+03,6.69535e+03,1.08393e-03,6.68745e+03,6.67222e+03,
1.11000e-03,6.31433e+03,6.29995e+03,1.12202e-03,6.15218e+03,6.13816e+03,1.13501e-03,5.98043e+03,5.96678e+03,1.17424e-03,
5.49894e+03,5.48633e+03,1.23027e-03,4.90082e+03,4.88946e+03,1.25890e-03,4.63077e+03,4.61995e+03,1.25892e-03,4.63054e+03,
4.61973e+03,1.27350e-03,4.50106e+03,4.49050e+03,1.28825e-03,4.37529e+03,4.36499e+03,1.28881e-03,4.37056e+03,4.36026e+03,
1.31826e-03,4.13288e+03,4.12306e+03,1.33352e-03,4.01555e+03,4.00595e+03,1.38038e-03,3.68155e+03,3.67259e+03,1.40000e-03,
3.55339e+03,3.54466e+03,1.41167e-03,3.47980e+03,3.47121e+03,1.41254e-03,3.47441e+03,3.46584e+03,1.44544e-03,3.27849e+03,
3.27027e+03,1.45000e-03,3.25257e+03,3.24440e+03,1.46218e-03,3.18395e+03,3.17591e+03,1.55000e-03,2.74288e+03,2.73562e+03,
1.57349e-03,2.63967e+03,2.63259e+03,1.58489e-03,2.59154e+03,2.58454e+03,1.58490e-03,2.59151e+03,2.58451e+03,1.62181e-03,
2.44389e+03,2.43715e+03,1.64059e-03,2.37294e+03,2.36632e+03,1.65959e-03,2.30411e+03,2.29761e+03,1.69824e-03,2.17255e+03,
2.16627e+03,1.70120e-03,2.16288e+03,2.15662e+03,1.71791e-03,2.10882e+03,2.10264e+03,1.73780e-03,2.04687e+03,2.04081e+03,
1.74498e-03,2.02517e+03,2.01913e+03,1.75792e-03,1.98681e+03,1.98084e+03,1.77828e-03,1.92853e+03,1.92266e+03,1.79887e-03,
1.87167e+03,1.86590e+03,1.86209e-03,1.71109e+03,1.70558e+03,1.88365e-03,1.66076e+03,1.65534e+03,1.90546e-03,1.61197e+03,
1.60662e+03,1.92337e-03,1.57300e+03,1.56772e+03,1.99526e-03,1.42902e+03,1.42398e+03,1.99530e-03,1.42895e+03,1.42391e+03,
2.00000e-03,1.42019e+03,1.41516e+03,2.01837e-03,1.38670e+03,1.38173e+03,2.04174e-03,1.34563e+03,1.34073e+03,2.06538e-03,
1.30580e+03,1.30096e+03,2.07000e-03,1.29821e+03,1.29339e+03,2.11349e-03,1.22929e+03,1.22459e+03,2.18776e-03,1.12302e+03,
1.11849e+03,2.21310e-03,1.08958e+03,1.08511e+03,2.25489e-03,1.03696e+03,1.03257e+03,2.26464e-03,1.02518e+03,1.02081e+03,
2.29087e-03,9.94452e+02,9.90137e+02,2.31740e-03,9.64646e+02,9.60383e+02,2.39883e-03,8.80156e+02,8.76040e+02,2.40000e-03,
8.79023e+02,8.74909e+02,2.43711e-03,8.44003e+02,8.39951e+02,2.45471e-03,8.28065e+02,8.24042e+02,2.51189e-03,7.79145e+02,
7.75211e+02,2.51190e-03,7.79133e+02,7.75200e+02,2.57040e-03,7.33037e+02,7.29189e+02,2.60016e-03,7.10863e+02,7.07055e+02,
2.64783e-03,6.77248e+02,6.73504e+02,2.66073e-03,6.68534e+02,6.64807e+02,2.72270e-03,6.28528e+02,6.24882e+02,2.81838e-03,
5.73093e+02,5.69562e+02,2.85102e-03,5.55744e+02,5.52249e+02,2.88403e-03,5.38873e+02,5.35414e+02,2.91743e-03,5.22531e+02,
5.19108e+02,2.95121e-03,5.06694e+02,5.03305e+02,2.97466e-03,4.96022e+02,4.92656e+02,3.01995e-03,4.76267e+02,4.72947e+02,
3.05492e-03,4.61678e+02,4.58393e+02,3.16228e-03,4.20690e+02,4.17504e+02,3.16230e-03,4.20682e+02,4.17496e+02,3.21929e-03,
4.00941e+02,3.97804e+02,3.31131e-03,3.71659e+02,3.68603e+02,3.34965e-03,3.60308e+02,3.57284e+02,3.38844e-03,3.49236e+02,
3.46243e+02,3.42768e-03,3.38515e+02,3.35553e+02,3.46737e-03,3.28061e+02,3.25129e+02,3.62472e-03,2.90838e+02,2.88018e+02,
3.75837e-03,2.63625e+02,2.60900e+02,3.80189e-03,2.55548e+02,2.52851e+02,3.84592e-03,2.47720e+02,2.45052e+02,3.89045e-03,
2.40108e+02,2.37469e+02,3.92701e-03,2.34066e+02,2.31449e+02,3.93550e-03,2.32693e+02,2.30081e+02,3.98107e-03,2.25463e+02,
2.22882e+02,3.98110e-03,2.25459e+02,2.22877e+02,4.07380e-03,2.11675e+02,2.09151e+02,4.24690e-03,1.88940e+02,1.86516e+02,
4.26579e-03,1.86664e+02,1.84252e+02,4.31519e-03,1.80899e+02,1.78515e+02,4.46684e-03,1.64674e+02,1.62375e+02,4.51856e-03,
1.59588e+02,1.57316e+02,4.61384e-03,1.50667e+02,1.48443e+02,4.67735e-03,1.45093e+02,1.42903e+02,4.79774e-03,1.35304e+02,
1.33174e+02,4.84172e-03,1.31952e+02,1.29845e+02,4.89779e-03,1.27848e+02,1.25769e+02,4.98060e-03,1.22108e+02,1.20070e+02,
5.01187e-03,1.20032e+02,1.18009e+02,5.01190e-03,1.20031e+02,1.18007e+02,5.12861e-03,1.12695e+02,1.10728e+02,5.15190e-03,
1.11305e+02,1.09349e+02,5.18800e-03,1.09196e+02,1.07257e+02,5.30055e-03,1.02913e+02,1.01027e+02,5.30884e-03,1.02469e+02,
1.00588e+02,5.42691e-03,9.64088e+01,9.45831e+01,5.43250e-03,9.61338e+01,9.43108e+01,5.54779e-03,9.07056e+01,8.89376e+01,
5.55904e-03,9.01983e+01,8.84358e+01,5.62341e-03,8.73712e+01,8.56400e+01,5.65784e-03,8.59118e+01,8.41969e+01,5.75750e-03,
8.18673e+01,8.02017e+01,5.84427e-03,7.85511e+01,7.69299e+01,5.95662e-03,7.45175e+01,7.29575e+01,5.97591e-03,7.38498e+01,
7.22999e+01,6.00000e-03,7.30255e+01,7.14900e+01,6.02560e-03,7.21617e+01,7.06412e+01,6.04026e-03,7.16731e+01,7.01610e+01,
6.09841e-03,6.97754e+01,6.82998e+01,6.14380e-03,6.83380e+01,6.68930e+01,6.16595e-03,6.76498e+01,6.62210e+01,6.18115e-03,
6.71835e+01,6.57657e+01,6.22447e-03,6.58748e+01,6.44914e+01,6.26337e-03,6.47242e+01,6.33758e+01,6.29481e-03,6.38089e+01,
6.24927e+01,6.30000e-03,6.36587e+01,6.23487e+01,6.30957e-03,6.33817e+01,6.20831e+01,6.30960e-03,6.33810e+01,6.20823e+01,
6.32097e-03,6.30543e+01,6.17689e+01,6.35194e-03,6.21696e+01,6.09260e+01,6.38263e-03,6.13025e+01,6.01061e+01,6.38619e-03,
6.12032e+01,6.00121e+01,6.43545e-03,5.98458e+01,5.87305e+01,6.45654e-03,5.92835e+01,5.81932e+01,6.45843e-03,5.92335e+01,
5.81454e+01,6.47020e-03,5.89269e+01,5.78489e+01,6.48327e-03,5.85928e+01,5.75220e+01,6.49907e-03,5.81979e+01,5.71299e+01,
6.51090e-03,5.79095e+01,5.68390e+01,6.51090e-03,4.59400e+02,3.44065e+02,6.51199e-03,4.59208e+02,3.43940e+02,6.52097e-03,
4.57633e+02,3.42906e+02,6.53042e-03,4.55986e+02,3.41822e+02,6.54761e-03,4.53016e+02,3.39863e+02,6.56962e-03,4.49260e+02,
3.37376e+02,6.60693e-03,4.43005e+02,3.33217e+02,6.61750e-03,4.41257e+02,3.32053e+02,6.64588e-03,4.36608e+02,3.28953e+02,
6.67454e-03,4.31978e+02,3.25863e+02,6.70674e-03,4.26850e+02,3.22438e+02,6.73043e-03,4.23128e+02,3.19950e+02,6.75817e-03,
4.18824e+02,3.17070e+02,6.78362e-03,4.14926e+02,3.14460e+02,6.83912e-03,4.06595e+02,3.08867e+02,6.84049e-03,4.06391e+02,
3.08730e+02,6.91578e-03,3.95450e+02,3.01356e+02,6.91831e-03,3.95090e+02,3.01113e+02,7.00000e-03,3.83495e+02,2.93244e+02,
7.01547e-03,3.81354e+02,2.91786e+02,7.11079e-03,3.68510e+02,2.83014e+02,7.22396e-03,3.54029e+02,2.73064e+02,7.32824e-03,
3.41374e+02,2.64313e+02,7.41310e-03,3.31537e+02,2.57473e+02,7.64942e-03,3.06142e+02,2.39665e+02,7.67362e-03,3.03696e+02,
2.37938e+02,7.76247e-03,2.94947e+02,2.31743e+02,7.85236e-03,2.86146e+02,2.25459e+02,7.92442e-03,2.79346e+02,2.20583e+02,
7.94328e-03,2.77602e+02,2.19330e+02,7.94330e-03,2.77600e+02,2.19328e+02,8.22243e-03,2.53466e+02,2.01875e+02,8.30031e-03,
2.47253e+02,1.97354e+02,8.51138e-03,2.31432e+02,1.85775e+02,8.60994e-03,2.24521e+02,1.80684e+02,8.70871e-03,2.17879e+02,
1.75772e+02,8.70964e-03,2.17818e+02,1.75727e+02,9.12011e-03,1.92954e+02,1.57167e+02,9.22571e-03,1.87191e+02,1.52825e+02,
9.28847e-03,1.83880e+02,1.50322e+02,9.54993e-03,1.70920e+02,1.40479e+02,9.66051e-03,1.65818e+02,1.36581e+02,9.86928e-03,
1.56745e+02,1.29615e+02,9.88553e-03,1.56068e+02,1.29093e+02,1.00000e-02,1.51409e+02,1.25498e+02,1.02329e-02,1.42507e+02,
1.18596e+02,1.04713e-02,1.33904e+02,1.11870e+02,1.05925e-02,1.29802e+02,1.08648e+02,1.06777e-02,1.27021e+02,1.06458e+02,
1.12202e-02,1.11086e+02,9.38241e+01,1.13501e-02,1.07682e+02,9.11044e+01,1.14815e-02,1.04382e+02,8.84612e+01,1.15000e-02,
1.03930e+02,8.80984e+01,1.16145e-02,1.01184e+02,8.58920e+01,1.17688e-02,9.76380e+01,8.30391e+01,1.20226e-02,9.21665e+01,
7.86202e+01,1.23027e-02,8.66087e+01,7.41096e+01,1.24451e-02,8.39548e+01,7.19474e+01,1.25890e-02,8.13877e+01,6.98509e+01,
1.25892e-02,8.13833e+01,6.98473e+01,1.30000e-02,7.46222e+01,6.43012e+01,1.31822e-02,7.18093e+01,6.19798e+01,1.31826e-02,
7.18039e+01,6.19753e+01,1.33352e-02,6.95576e+01,6.01174e+01,1.34896e-02,6.73816e+01,5.83136e+01,1.35000e-02,6.72388e+01,
5.81951e+01,1.41254e-02,5.93404e+01,5.16126e+01,1.44544e-02,5.56903e+01,4.85516e+01,1.46218e-02,5.39492e+01,4.70870e+01,
1.47009e-02,5.31521e+01,4.64155e+01,1.49624e-02,5.06290e+01,4.42867e+01,1.56675e-02,4.45940e+01,3.91686e+01,1.58489e-02,
4.32019e+01,3.79825e+01,1.58490e-02,4.32013e+01,3.79821e+01,1.60324e-02,4.18535e+01,3.68318e+01,1.62181e-02,4.05474e+01,
3.57152e+01,1.65486e-02,3.83184e+01,3.38035e+01,1.65959e-02,3.80134e+01,3.35416e+01,1.69824e-02,3.56386e+01,3.14986e+01,
1.73780e-02,3.34112e+01,2.95763e+01,1.81970e-02,2.93697e+01,2.60725e+01,1.84077e-02,2.84390e+01,2.52627e+01,1.88365e-02,
2.66653e+01,2.37166e+01,1.90546e-02,2.58207e+01,2.29789e+01,1.94985e-02,2.42118e+01,2.15713e+01,1.97889e-02,2.32328e+01,
2.07129e+01,1.99526e-02,2.27042e+01,2.02490e+01,1.99530e-02,2.27030e+01,2.02480e+01,2.00000e-02,2.25544e+01,2.01175e+01,
2.13796e-02,1.86697e+01,1.66924e+01,2.18776e-02,1.74926e+01,1.56497e+01,2.21309e-02,1.69321e+01,1.51527e+01,2.26464e-02,
1.58654e+01,1.42052e+01,2.29087e-02,1.53579e+01,1.37537e+01,2.31740e-02,1.48668e+01,1.33164e+01,2.37137e-02,1.39320e+01,
1.24827e+01,2.44692e-02,1.27531e+01,1.14288e+01,2.45471e-02,1.26393e+01,1.13270e+01,2.51189e-02,1.18354e+01,1.06067e+01,
2.51190e-02,1.18352e+01,1.06065e+01,2.60016e-02,1.07257e+01,9.61051e+00,2.63027e-02,1.03798e+01,9.29955e+00,2.68609e-02,
9.77809e+00,8.75787e+00,2.75423e-02,9.10627e+00,8.15253e+00,2.78612e-02,8.81357e+00,7.88848e+00,2.81838e-02,8.53046e+00,
7.63291e+00,2.85102e-02,8.25640e+00,7.38531e+00,3.01995e-02,7.01561e+00,6.26212e+00,3.09030e-02,6.56949e+00,5.85717e+00,
3.16228e-02,6.15254e+00,5.47826e+00,3.16230e-02,6.15242e+00,5.47815e+00,3.23594e-02,5.76264e+00,5.12381e+00,3.27341e-02,
5.57738e+00,4.95525e+00,3.38844e-02,5.05773e+00,4.48205e+00,3.46737e-02,4.73916e+00,4.19160e+00,3.60086e-02,4.26098e+00,
3.75520e+00,3.63078e-02,4.16308e+00,3.66583e+00,3.71535e-02,3.90286e+00,3.42818e+00,3.98107e-02,3.21322e+00,2.79737e+00,
3.98110e-02,3.21315e+00,2.79732e+00,4.07380e-02,3.01279e+00,2.61410e+00,4.09394e-02,2.97158e+00,2.57641e+00,4.12097e-02,
2.91745e+00,2.52694e+00,4.36516e-02,2.48647e+00,2.13293e+00,4.51856e-02,2.26102e+00,1.92674e+00,4.62381e-02,2.12300e+00,
1.80051e+00,4.84172e-02,1.87137e+00,1.57027e+00,4.95450e-02,1.75795e+00,1.46651e+00,5.01187e-02,1.70404e+00,1.41720e+00,
5.01190e-02,1.70402e+00,1.41718e+00,5.12861e-02,1.60144e+00,1.32360e+00,5.37032e-02,1.41617e+00,1.15470e+00,5.43250e-02,
1.37369e+00,1.11600e+00,5.69317e-02,1.21495e+00,9.71523e-01,5.75440e-02,1.18168e+00,9.41301e-01,5.82103e-02,1.14702e+00,
9.09840e-01,5.95662e-02,1.08064e+00,8.49578e-01,6.16595e-02,9.89255e-01,7.66716e-01,6.30957e-02,9.33320e-01,7.16066e-01,
6.30960e-02,9.33310e-01,7.16057e-01,6.79759e-02,7.75974e-01,5.74666e-01,6.83912e-02,7.64569e-01,5.64461e-01,7.16143e-02,
6.84670e-01,4.93120e-01,7.58578e-02,5.98948e-01,4.16921e-01,7.76247e-02,5.68534e-01,3.89992e-01,7.85236e-02,5.54073e-01,
3.77210e-01,7.94328e-02,5.39985e-01,3.64763e-01,7.94330e-02,5.39983e-01,3.64760e-01,8.08642e-02,5.18930e-01,3.46359e-01,
8.22243e-02,5.00207e-01,3.30063e-01,8.51138e-02,4.64238e-01,2.98869e-01,8.91251e-02,4.21613e-01,2.62127e-01,9.01571e-02,
4.11824e-01,2.53729e-01,9.66051e-02,3.59503e-01,2.09150e-01,9.88553e-02,3.44267e-01,1.96283e-01,1.00000e-01,3.37021e-01,
1.90186e-01,1.01158e-01,3.29934e-01,1.84337e-01,1.01682e-01,3.26831e-01,1.81782e-01,1.04713e-01,3.09975e-01,1.67994e-01,
1.09648e-01,2.86218e-01,1.48751e-01,1.12202e-01,2.75447e-01,1.40113e-01,1.13501e-01,2.70318e-01,1.36021e-01,1.18277e-01,
2.53250e-01,1.22512e-01,1.18850e-01,2.51369e-01,1.21037e-01,1.20226e-01,2.46989e-01,1.17615e-01,1.25890e-01,2.30807e-01,
1.05090e-01,1.25893e-01,2.30800e-01,1.05085e-01,1.28825e-01,2.23304e-01,9.95306e-02,1.30317e-01,2.19726e-01,9.68995e-02,
1.34896e-01,2.09630e-01,8.95502e-02,1.41254e-01,1.97525e-01,8.09050e-02,1.44544e-01,1.91998e-01,7.70265e-02,1.46218e-01,
1.89356e-01,7.51891e-02,1.47911e-01,1.86791e-01,7.34165e-02,1.50638e-01,1.82896e-01,7.07530e-02,1.51356e-01,1.81910e-01,
7.00843e-02,1.56675e-01,1.75088e-01,6.55099e-02,1.58489e-01,1.72943e-01,6.40903e-02,1.58490e-01,1.72942e-01,6.40898e-02,
1.62181e-01,1.68717e-01,6.14669e-02,1.64059e-01,1.66691e-01,6.02239e-02,1.65959e-01,1.64719e-01,5.90245e-02,1.73780e-01,
1.57349e-01,5.46332e-02,1.79887e-01,1.52317e-01,5.17267e-02,1.84077e-01,1.49176e-01,4.99540e-02,1.88365e-01,1.46195e-01,
4.83041e-02,1.92752e-01,1.43363e-01,4.67666e-02,1.97242e-01,1.40682e-01,4.53466e-02,1.98828e-01,1.39781e-01,4.48755e-02,
1.99526e-01,1.39390e-01,4.46727e-02,1.99530e-01,1.39388e-01,4.46717e-02,2.04174e-01,1.36801e-01,4.34608e-02,2.06538e-01,
1.35552e-01,4.28860e-02,2.11349e-01,1.33138e-01,4.17949e-02,2.13796e-01,1.31972e-01,4.12772e-02,2.16272e-01,1.30832e-01,
4.07772e-02,2.21309e-01,1.28627e-01,3.98275e-02,2.21340e-01,1.28614e-01,3.98220e-02,2.29087e-01,1.25498e-01,3.85216e-02,
2.37137e-01,1.22582e-01,3.73599e-02,2.39883e-01,1.21649e-01,3.69976e-02,2.42661e-01,1.20735e-01,3.66470e-02,2.45471e-01,
1.19839e-01,3.63076e-02,2.48313e-01,1.18960e-01,3.59791e-02,2.51189e-01,1.18099e-01,3.56610e-02,2.51190e-01,1.18099e-01,
3.56609e-02,2.54097e-01,1.17215e-01,3.53846e-02,2.57040e-01,1.16348e-01,3.51171e-02,2.60016e-01,1.15497e-01,3.48580e-02,
2.64571e-01,1.14243e-01,3.44833e-02,2.66073e-01,1.13840e-01,3.43649e-02,2.69154e-01,1.13038e-01,3.41344e-02,2.72270e-01,
1.12249e-01,3.39107e-02,2.78612e-01,1.10711e-01,3.34832e-02,2.81838e-01,1.09962e-01,3.32787e-02,2.88403e-01,1.08500e-01,
3.28873e-02,2.91743e-01,1.07787e-01,3.26998e-02,3.00000e-01,1.06105e-01,3.22668e-02,3.01995e-01,1.05715e-01,3.21681e-02,
3.05492e-01,1.05047e-01,3.20007e-02,3.09029e-01,1.04391e-01,3.18410e-02,3.16228e-01,1.03110e-01,3.15334e-02,3.16230e-01,
1.03109e-01,3.15333e-02,3.27341e-01,1.01161e-01,3.11849e-02,3.31131e-01,1.00530e-01,3.10740e-02,3.34965e-01,9.99069e-02,
3.09655e-02,3.38844e-01,9.92924e-02,3.08593e-02,3.42768e-01,9.86860e-02,3.07553e-02,3.46737e-01,9.80877e-02,3.06537e-02,
3.54813e-01,9.69193e-02,3.04611e-02,3.63078e-01,9.57797e-02,3.02749e-02,3.67282e-01,9.52203e-02,3.01841e-02,3.71535e-01,
9.46676e-02,3.00946e-02,3.72858e-01,9.44984e-02,3.00673e-02,3.75837e-01,9.41211e-02,3.00065e-02,3.84592e-01,9.30467e-02,
2.98339e-02,3.89045e-01,9.25190e-02,2.97494e-02,3.98107e-01,9.14852e-02,2.95874e-02,3.98110e-01,9.14849e-02,2.95874e-02,
4.07380e-01,9.04211e-02,2.94804e-02,4.12098e-01,8.98975e-02,2.94269e-02,4.16869e-01,8.93794e-02,2.93735e-02,4.26580e-01,
8.83592e-02,2.92664e-02,4.31519e-01,8.78570e-02,2.92129e-02,4.41570e-01,8.68707e-02,2.91084e-02,4.46684e-01,8.63847e-02,
2.90558e-02,4.57088e-01,8.54266e-02,2.89498e-02,4.62381e-01,8.49543e-02,2.88963e-02,4.67735e-01,8.44864e-02,2.88426e-02,
4.73151e-01,8.40228e-02,2.87885e-02,4.78630e-01,8.35636e-02,2.87342e-02,4.84172e-01,8.31098e-02,2.86808e-02,5.01187e-01,
8.17721e-02,2.85179e-02,5.01190e-01,8.17719e-02,2.85179e-02,5.06991e-01,8.13101e-02,2.84847e-02,5.12861e-01,8.08521e-02,
2.84504e-02,5.18800e-01,8.03980e-02,2.84150e-02,5.24808e-01,7.99477e-02,2.83786e-02,5.30884e-01,7.95012e-02,2.83412e-02,
5.49541e-01,7.81865e-02,2.82257e-02,5.55904e-01,7.77553e-02,2.81851e-02,5.62341e-01,7.73275e-02,2.81434e-02,5.68853e-01,
7.69031e-02,2.81008e-02,5.75440e-01,7.64820e-02,2.80572e-02,5.75751e-01,7.64623e-02,2.80551e-02,5.82103e-01,7.60640e-02,
2.80126e-02,5.95662e-01,7.52391e-02,2.79221e-02,6.02560e-01,7.48314e-02,2.78754e-02,6.09537e-01,7.44267e-02,2.78277e-02,
6.16595e-01,7.40249e-02,2.77790e-02,6.30957e-01,7.32304e-02,2.76789e-02,6.30960e-01,7.32302e-02,2.76789e-02,6.38264e-01,
7.28179e-02,2.76472e-02,6.45654e-01,7.24092e-02,2.76146e-02,6.53131e-01,7.20034e-02,2.75805e-02,6.60694e-01,7.16005e-02,
2.75451e-02,6.68344e-01,7.12005e-02,2.75082e-02,6.76083e-01,7.08033e-02,2.74699e-02,6.91831e-01,7.00175e-02,2.73895e-02,
6.99842e-01,6.96288e-02,2.73474e-02,7.16143e-01,6.88606e-02,2.72605e-02,7.32825e-01,6.81029e-02,2.71687e-02,7.41310e-01,
6.77279e-02,2.71210e-02,7.49894e-01,6.73555e-02,2.70721e-02,7.58578e-01,6.69856e-02,2.70222e-02,7.76247e-01,6.62540e-02,
2.69198e-02,7.85236e-01,6.58918e-02,2.68669e-02,7.94328e-01,6.55320e-02,2.68131e-02,7.94330e-01,6.55320e-02,2.68130e-02,
8.12831e-01,6.47806e-02,2.67297e-02,8.22243e-01,6.44087e-02,2.66859e-02,8.31764e-01,6.40393e-02,2.66407e-02,8.51138e-01,
6.33085e-02,2.65468e-02,8.60994e-01,6.29467e-02,2.64979e-02,8.70964e-01,6.25872e-02,2.64477e-02,8.81049e-01,6.22301e-02,
2.63962e-02,8.91251e-01,6.18754e-02,2.63436e-02,9.12011e-01,6.11728e-02,2.62347e-02,9.22571e-01,6.08249e-02,2.61786e-02,
9.33254e-01,6.04793e-02,2.61213e-02,9.54993e-01,5.97953e-02,2.60043e-02,9.66051e-01,5.94565e-02,2.59442e-02,9.77237e-01,
5.91200e-02,2.58832e-02,9.88553e-01,5.87855e-02,2.58211e-02,1.00000e+00,5.84532e-02,2.57581e-02,1.00000e-03,9.11683e+03,
9.08873e+03,1.02294e-03,8.64467e+03,8.61826e+03,1.02329e-03,8.63762e+03,8.61124e+03,1.04713e-03,8.18383e+03,8.15904e+03,
1.05279e-03,8.08030e+03,8.05587e+03,1.05925e-03,7.96454e+03,7.94050e+03,1.08393e-03,7.54383e+03,7.52123e+03,1.09648e-03,
7.33887e+03,7.31695e+03,1.11237e-03,7.09084e+03,7.06973e+03,1.13501e-03,6.75761e+03,6.73759e+03,1.15000e-03,6.54919e+03,
6.52983e+03,1.20226e-03,5.88375e+03,5.86646e+03,1.21619e-03,5.71949e+03,5.70269e+03,1.24451e-03,5.40475e+03,5.38888e+03,
1.25890e-03,5.25435e+03,5.23893e+03,1.25892e-03,5.25410e+03,5.23867e+03,1.27266e-03,5.11494e+03,5.09991e+03,1.31826e-03,
4.68842e+03,4.67461e+03,1.33352e-03,4.55589e+03,4.54244e+03,1.33700e-03,4.52647e+03,4.51311e+03,1.34896e-03,4.42713e+03,
4.41405e+03,1.36458e-03,4.30213e+03,4.28939e+03,1.38038e-03,4.18075e+03,4.16834e+03,1.41254e-03,3.94834e+03,3.93655e+03,
1.42889e-03,3.83704e+03,3.82554e+03,1.49624e-03,3.42051e+03,3.41008e+03,1.50441e-03,3.37409e+03,3.36378e+03,1.51356e-03,
3.32313e+03,3.31295e+03,1.54882e-03,3.13440e+03,3.12469e+03,1.57000e-03,3.02773e+03,3.01828e+03,1.58489e-03,2.95576e+03,
2.94648e+03,1.58490e-03,2.95573e+03,2.94645e+03,1.60325e-03,2.87028e+03,2.86121e+03,1.64261e-03,2.69847e+03,2.68980e+03,
1.65959e-03,2.62876e+03,2.62026e+03,1.67880e-03,2.55264e+03,2.54433e+03,1.73780e-03,2.33582e+03,2.32801e+03,1.75792e-03,
2.26781e+03,2.26016e+03,1.77828e-03,2.20185e+03,2.19434e+03,1.80000e-03,2.13436e+03,2.12701e+03,1.81970e-03,2.07532e+03,
2.06811e+03,1.82070e-03,2.07239e+03,2.06518e+03,1.86209e-03,1.95592e+03,1.94897e+03,1.90546e-03,1.84351e+03,1.83681e+03,
1.94984e-03,1.73717e+03,1.73071e+03,1.95000e-03,1.73682e+03,1.73035e+03,1.97242e-03,1.68582e+03,1.67947e+03,1.99526e-03,
1.63575e+03,1.62950e+03,1.99530e-03,1.63567e+03,1.62942e+03,2.00000e-03,1.62562e+03,1.61940e+03,2.01837e-03,1.58720e+03,
1.58106e+03,2.03940e-03,1.54473e+03,1.53868e+03,2.06538e-03,1.49442e+03,1.48848e+03,2.16272e-03,1.32524e+03,1.31967e+03,
2.18776e-03,1.28598e+03,1.28049e+03,2.21310e-03,1.24790e+03,1.24249e+03,2.23872e-03,1.21095e+03,1.20563e+03,2.26464e-03,
1.17487e+03,1.16962e+03,2.29087e-03,1.13985e+03,1.13468e+03,2.34031e-03,1.07735e+03,1.07231e+03,2.34423e-03,1.07260e+03,
1.06757e+03,2.45471e-03,9.50085e+02,9.45327e+02,2.48313e-03,9.21645e+02,9.16950e+02,2.51189e-03,8.94083e+02,8.89449e+02,
2.51190e-03,8.94070e+02,8.89436e+02,2.54097e-03,8.67346e+02,8.62772e+02,2.57040e-03,8.41246e+02,8.36730e+02,2.63027e-03,
7.91112e+02,7.86708e+02,2.66073e-03,7.67194e+02,7.62843e+02,2.81838e-03,6.58306e+02,6.54215e+02,2.85102e-03,6.38508e+02,
6.34465e+02,2.91743e-03,6.00598e+02,5.96648e+02,2.95121e-03,5.82366e+02,5.78461e+02,3.01089e-03,5.51805e+02,5.47976e+02,
3.01995e-03,5.47359e+02,5.43542e+02,3.09030e-03,5.14519e+02,5.10789e+02,3.16228e-03,4.83700e+02,4.80053e+02,3.16230e-03,
4.83691e+02,4.80044e+02,3.19889e-03,4.68993e+02,4.65387e+02,3.23594e-03,4.54755e+02,4.51187e+02,3.27341e-03,4.40916e+02,
4.37387e+02,3.31131e-03,4.27512e+02,4.24021e+02,3.33304e-03,4.20081e+02,4.16611e+02,3.34965e-03,4.14517e+02,4.11064e+02,
3.38844e-03,4.01848e+02,3.98435e+02,3.42768e-03,3.89495e+02,3.86120e+02,3.58922e-03,3.43878e+02,3.40650e+02,3.63078e-03,
3.33353e+02,3.30160e+02,3.71535e-03,3.13284e+02,3.10159e+02,3.75145e-03,3.05206e+02,3.02108e+02,3.75837e-03,3.03689e+02,
3.00597e+02,3.80189e-03,2.94388e+02,2.91331e+02,3.89045e-03,2.76535e+02,2.73547e+02,3.98107e-03,2.59722e+02,2.56801e+02,
3.98110e-03,2.59717e+02,2.56796e+02,4.12097e-03,2.36411e+02,2.33585e+02,4.13691e-03,2.33946e+02,2.31130e+02,4.16869e-03,
2.29134e+02,2.26340e+02,4.21696e-03,2.22082e+02,2.19319e+02,4.26579e-03,2.15254e+02,2.12523e+02,4.31519e-03,2.08639e+02,
2.05938e+02,4.31752e-03,2.08334e+02,2.05634e+02,4.36516e-03,2.02212e+02,1.99544e+02,4.41570e-03,1.95942e+02,1.93305e+02,
4.46684e-03,1.89872e+02,1.87267e+02,4.67735e-03,1.67354e+02,1.64870e+02,4.69544e-03,1.65599e+02,1.63125e+02,4.84172e-03,
1.52284e+02,1.49891e+02,4.88658e-03,1.48501e+02,1.46131e+02,5.01187e-03,1.38590e+02,1.36287e+02,5.01190e-03,1.38588e+02,
1.36285e+02,5.06991e-03,1.34268e+02,1.31995e+02,5.09703e-03,1.32314e+02,1.30054e+02,5.12861e-03,1.30085e+02,1.27842e+02,
5.18800e-03,1.26035e+02,1.23822e+02,5.29359e-03,1.19228e+02,1.17066e+02,5.37032e-03,1.14591e+02,1.12467e+02,5.47020e-03,
1.08931e+02,1.06854e+02,5.55904e-03,1.04212e+02,1.02177e+02,5.62341e-03,1.00970e+02,9.89651e+01,5.64623e-03,9.98543e+01,
9.78599e+01,5.75440e-03,9.47859e+01,9.28420e+01,5.81020e-03,9.22924e+01,9.03735e+01,5.82103e-03,9.18182e+01,8.99045e+01,
5.88844e-03,8.89379e+01,8.70555e+01,5.95549e-03,8.61960e+01,8.43438e+01,5.95662e-03,8.61508e+01,8.42992e+01,6.07946e-03,
8.14257e+01,7.96306e+01,6.09537e-03,8.08393e+01,7.90520e+01,6.16595e-03,7.82966e+01,7.65432e+01,6.27844e-03,7.44689e+01,
7.27674e+01,6.30957e-03,7.34531e+01,7.17670e+01,6.30960e-03,7.34522e+01,7.17662e+01,6.37533e-03,7.13727e+01,6.97185e+01,
6.44576e-03,6.92298e+01,6.76114e+01,6.52874e-03,6.68124e+01,6.52383e+01,6.53131e-03,6.67393e+01,6.51667e+01,6.59320e-03,
6.50108e+01,6.34733e+01,6.60693e-03,6.46349e+01,6.31058e+01,6.65099e-03,6.34401e+01,6.19373e+01,6.70223e-03,6.20845e+01,
6.06149e+01,6.76083e-03,6.05763e+01,5.91492e+01,6.77255e-03,6.02804e+01,5.88616e+01,6.81410e-03,5.92411e+01,5.78569e+01,
6.83912e-03,5.86235e+01,5.72632e+01,6.84831e-03,5.83988e+01,5.70472e+01,6.87677e-03,5.77066e+01,5.63858e+01,6.91182e-03,
5.68627e+01,5.55855e+01,6.91831e-03,5.67067e+01,5.54389e+01,6.95199e-03,5.59078e+01,5.46875e+01,6.99842e-03,5.48288e+01,
5.36740e+01,7.00132e-03,5.47625e+01,5.36117e+01,7.02354e-03,5.42628e+01,5.31368e+01,7.04167e-03,5.38652e+01,5.27535e+01,
7.06002e-03,5.34734e+01,5.23695e+01,7.06806e-03,5.33052e+01,5.22025e+01,7.07946e-03,5.30704e+01,5.19668e+01,7.08340e-03,
5.29909e+01,5.18856e+01,7.08340e-03,4.14635e+02,2.99605e+02,7.09581e-03,4.12699e+02,2.98391e+02,7.10709e-03,4.10953e+02,
2.97294e+02,7.12668e-03,4.07953e+02,2.95401e+02,7.15220e-03,4.04095e+02,2.92958e+02,7.16143e-03,4.02714e+02,2.92082e+02,
7.20678e-03,3.96025e+02,2.87824e+02,7.22000e-03,3.94103e+02,2.86598e+02,7.22506e-03,3.93432e+02,2.86175e+02,7.24436e-03,
3.90886e+02,2.84572e+02,7.25375e-03,3.89657e+02,2.83796e+02,7.28417e-03,3.85704e+02,2.81303e+02,7.29954e-03,3.83727e+02,
2.80056e+02,7.32745e-03,3.80168e+02,2.77808e+02,7.35198e-03,3.77077e+02,2.75853e+02,7.38490e-03,3.72980e+02,2.73260e+02,
7.44442e-03,3.65727e+02,2.68654e+02,7.50000e-03,3.59126e+02,2.64449e+02,7.52101e-03,3.56584e+02,2.62815e+02,7.58578e-03,
3.48898e+02,2.57865e+02,7.62570e-03,3.44275e+02,2.54877e+02,7.67362e-03,3.38837e+02,2.51352e+02,7.72643e-03,3.32974e+02,
2.47539e+02,7.85236e-03,3.19551e+02,2.38759e+02,7.85592e-03,3.19182e+02,2.38517e+02,7.94328e-03,3.10322e+02,2.32683e+02,
7.94330e-03,3.10320e+02,2.32681e+02,8.03095e-03,3.01771e+02,2.27021e+02,8.12830e-03,2.92654e+02,2.20953e+02,8.22243e-03,
2.84204e+02,2.15296e+02,8.25885e-03,2.81026e+02,2.13161e+02,8.31764e-03,2.75997e+02,2.09774e+02,8.41395e-03,2.68025e+02,
2.04382e+02,8.51138e-03,2.60285e+02,1.99118e+02,8.57921e-03,2.54898e+02,1.95423e+02,8.91251e-03,2.30544e+02,1.78557e+02,
8.98056e-03,2.25966e+02,1.75356e+02,9.12011e-03,2.16961e+02,1.69030e+02,9.44087e-03,1.98064e+02,1.55651e+02,9.54993e-03,
1.92157e+02,1.51431e+02,9.66051e-03,1.86414e+02,1.47311e+02,9.77237e-03,1.80842e+02,1.43295e+02,1.00000e-02,1.70197e+02,
1.35576e+02,1.00054e-02,1.69956e+02,1.35400e+02,1.03514e-02,1.55395e+02,1.24733e+02,1.04713e-02,1.50749e+02,1.21302e+02,
1.05925e-02,1.46243e+02,1.17961e+02,1.08081e-02,1.38682e+02,1.12326e+02,1.10918e-02,1.29531e+02,1.05458e+02,1.12202e-02,
1.25561e+02,1.02453e+02,1.13501e-02,1.21712e+02,9.95301e+01,1.14815e-02,1.17981e+02,9.66866e+01,1.17046e-02,1.12002e+02,
9.21095e+01,1.20226e-02,1.04173e+02,8.60781e+01,1.23027e-02,9.78834e+01,8.11990e+01,1.24451e-02,9.48832e+01,7.88606e+01,
1.25890e-02,9.19808e+01,7.65942e+01,1.25892e-02,9.19759e+01,7.65903e+01,1.28857e-02,8.63682e+01,7.21916e+01,1.30317e-02,
8.37787e+01,7.01516e+01,1.31826e-02,8.12129e+01,6.81247e+01,1.35000e-02,7.61583e+01,6.41141e+01,1.38038e-02,7.17164e+01,
6.05700e+01,1.40000e-02,6.90366e+01,5.84227e+01,1.41254e-02,6.73603e+01,5.70740e+01,1.44544e-02,6.32139e+01,5.37256e+01,
1.46008e-02,6.14815e+01,5.23216e+01,1.47911e-02,5.93237e+01,5.05689e+01,1.53109e-02,5.39349e+01,4.61703e+01,1.54882e-02,
5.22505e+01,4.47889e+01,1.58489e-02,4.90396e+01,4.21465e+01,1.58490e-02,4.90390e+01,4.21461e+01,1.60324e-02,4.75095e+01,
4.08833e+01,1.63669e-02,4.48846e+01,3.87095e+01,1.65959e-02,4.32008e+01,3.73111e+01,1.69824e-02,4.05462e+01,3.50991e+01,
1.73780e-02,3.80561e+01,3.30157e+01,1.75792e-02,3.68487e+01,3.20016e+01,1.77828e-02,3.56801e+01,3.10181e+01,1.79887e-02,
3.45488e+01,3.00642e+01,1.81970e-02,3.34538e+01,2.91392e+01,1.82418e-02,3.32248e+01,2.89455e+01,1.90546e-02,2.94119e+01,
2.57111e+01,1.92752e-02,2.84809e+01,2.49179e+01,1.94985e-02,2.75797e+01,2.41489e+01,1.98203e-02,2.63465e+01,2.30944e+01,
1.99526e-02,2.58610e+01,2.26788e+01,1.99530e-02,2.58596e+01,2.26776e+01,2.00000e-02,2.56902e+01,2.25324e+01,2.13796e-02,
2.13262e+01,1.87791e+01,2.13937e-02,2.12867e+01,1.87449e+01,2.16272e-02,2.06426e+01,1.81879e+01,2.29087e-02,1.75435e+01,
1.54966e+01,2.30000e-02,1.73476e+01,1.53258e+01,2.35553e-02,1.62176e+01,1.43392e+01,2.37137e-02,1.59134e+01,1.40734e+01,
2.42661e-02,1.49123e+01,1.31971e+01,2.51189e-02,1.35295e+01,1.19829e+01,2.51190e-02,1.35293e+01,1.19827e+01,2.54097e-02,
1.30980e+01,1.16033e+01,2.57040e-02,1.26806e+01,1.12356e+01,2.60016e-02,1.22767e+01,1.08795e+01,2.62067e-02,1.20052e+01,
1.06397e+01,2.63027e-02,1.18810e+01,1.05300e+01,2.69154e-02,1.11278e+01,9.86425e+00,2.72270e-02,1.07697e+01,9.54718e+00,
2.75423e-02,1.04229e+01,9.23987e+00,2.78612e-02,1.00876e+01,8.94240e+00,2.81838e-02,9.76326e+00,8.65439e+00,3.00983e-02,
8.10556e+00,7.17798e+00,3.01995e-02,8.02904e+00,7.10967e+00,3.12608e-02,7.28370e+00,6.44340e+00,3.16228e-02,7.05139e+00,
6.23541e+00,3.16230e-02,7.05125e+00,6.23528e+00,3.23594e-02,6.60417e+00,5.83458e+00,3.27341e-02,6.39143e+00,5.64370e+00,
3.34965e-02,5.98690e+00,5.28037e+00,3.38844e-02,5.79462e+00,5.10750e+00,3.46737e-02,5.42901e+00,4.77849e+00,3.63078e-02,
4.76780e+00,4.18244e+00,3.84592e-02,4.05743e+00,3.54057e+00,3.87927e-02,3.96083e+00,3.45317e+00,3.89045e-02,3.92914e+00,
3.42452e+00,3.98107e-02,3.68219e+00,3.20104e+00,3.98110e-02,3.68211e+00,3.20097e+00,4.02717e-02,3.56477e+00,3.09485e+00,
4.16869e-02,3.23557e+00,2.79691e+00,4.36516e-02,2.84582e+00,2.44381e+00,4.55168e-02,2.53486e+00,2.16184e+00,4.57088e-02,
2.50563e+00,2.13533e+00,4.73151e-02,2.27914e+00,1.92987e+00,4.84172e-02,2.14035e+00,1.80392e+00,4.89779e-02,2.07379e+00,
1.74347e+00,5.01187e-02,1.94730e+00,1.62859e+00,5.01190e-02,1.94727e+00,1.62857e+00,5.06991e-02,1.88714e+00,1.57407e+00,
5.24807e-02,1.71853e+00,1.42129e+00,5.43250e-02,1.56637e+00,1.28346e+00,5.82103e-02,1.30507e+00,1.04696e+00,5.82216e-02,
1.30441e+00,1.04636e+00,6.02560e-02,1.19295e+00,9.45698e-01,6.16595e-02,1.12432e+00,8.83769e-01,6.30957e-02,1.05968e+00,
8.25455e-01,6.30960e-02,1.05967e+00,8.25444e-01,6.53131e-02,9.70426e-01,7.45352e-01,7.04345e-02,8.04480e-01,5.96870e-01,
7.16143e-02,7.72642e-01,5.68507e-01,7.32825e-02,7.31024e-01,5.31483e-01,7.67362e-02,6.55766e-01,4.64703e-01,7.94328e-02,
6.05667e-01,4.20397e-01,7.94330e-02,6.05663e-01,4.20394e-01,8.03526e-02,5.89979e-01,4.06666e-01,8.12830e-02,5.74813e-01,
3.93409e-01,8.31764e-02,5.45806e-01,3.68087e-01,8.39298e-02,5.34971e-01,3.58648e-01,8.41395e-02,5.32018e-01,3.56081e-01,
8.51138e-02,5.18671e-01,3.44491e-01,8.70964e-02,4.93292e-01,3.22501e-01,9.12011e-02,4.47392e-01,2.82918e-01,9.33254e-02,
4.26655e-01,2.65127e-01,9.66051e-02,3.98041e-01,2.40691e-01,9.88553e-02,3.80491e-01,2.25775e-01,1.00000e-01,3.72145e-01,
2.18703e-01,1.02329e-01,3.56104e-01,2.05361e-01,1.02752e-01,3.53344e-01,2.03071e-01,1.04713e-01,3.41056e-01,1.92931e-01,
1.07152e-01,3.26958e-01,1.81353e-01,1.08393e-01,3.20248e-01,1.75864e-01,1.13501e-01,2.95490e-01,1.55761e-01,1.14815e-01,
2.89787e-01,1.51166e-01,1.21843e-01,2.63113e-01,1.29883e-01,1.23027e-01,2.59163e-01,1.26773e-01,1.24452e-01,2.54598e-01,
1.23189e-01,1.25890e-01,2.50184e-01,1.19737e-01,1.25893e-01,2.50177e-01,1.19731e-01,1.28825e-01,2.41600e-01,1.13243e-01,
1.36458e-01,2.22354e-01,9.89119e-02,1.41254e-01,2.12150e-01,9.14623e-02,1.44544e-01,2.05848e-01,8.69208e-02,1.47911e-01,
1.99915e-01,8.26918e-02,1.51356e-01,1.94327e-01,7.87537e-02,1.58489e-01,1.84099e-01,7.16715e-02,1.58490e-01,1.84098e-01,
7.16709e-02,1.59155e-01,1.83205e-01,7.10887e-02,1.60324e-01,1.81663e-01,7.00888e-02,1.62181e-01,1.79295e-01,6.85618e-02,
1.65959e-01,1.74785e-01,6.56964e-02,1.67880e-01,1.72623e-01,6.43382e-02,1.71791e-01,1.68475e-01,6.17618e-02,1.73780e-01,
1.66485e-01,6.05402e-02,1.77828e-01,1.62665e-01,5.82249e-02,1.79887e-01,1.60832e-01,5.71269e-02,1.84077e-01,1.57308e-01,
5.50435e-02,1.92752e-01,1.50795e-01,5.12907e-02,1.97242e-01,1.47783e-01,4.96023e-02,1.99526e-01,1.46334e-01,4.88013e-02,
1.99530e-01,1.46331e-01,4.88001e-02,2.00000e-01,1.46030e-01,4.86469e-02,2.08930e-01,1.40695e-01,4.59946e-02,2.13796e-01,
1.38072e-01,4.47319e-02,2.15245e-01,1.37331e-01,4.43832e-02,2.16272e-01,1.36814e-01,4.41417e-02,2.18776e-01,1.35584e-01,
4.35714e-02,2.21309e-01,1.34381e-01,4.30202e-02,2.21340e-01,1.34367e-01,4.30137e-02,2.23872e-01,1.33205e-01,4.24874e-02,
2.34423e-01,1.28759e-01,4.05301e-02,2.37137e-01,1.27706e-01,4.00804e-02,2.45471e-01,1.24681e-01,3.88175e-02,2.51189e-01,
1.22767e-01,3.80424e-02,2.51190e-01,1.22767e-01,3.80422e-02,2.57040e-01,1.20862e-01,3.73915e-02,2.60016e-01,1.19937e-01,
3.70815e-02,2.63027e-01,1.19029e-01,3.67812e-02,2.72270e-01,1.16406e-01,3.59364e-02,2.75423e-01,1.15564e-01,3.56719e-02,
2.78612e-01,1.14736e-01,3.54154e-02,2.81838e-01,1.13924e-01,3.51666e-02,2.88403e-01,1.12340e-01,3.46908e-02,2.91743e-01,
1.11573e-01,3.44676e-02,2.94061e-01,1.11053e-01,3.43179e-02,3.00000e-01,1.09764e-01,3.39524e-02,3.01995e-01,1.09345e-01,
3.38351e-02,3.09029e-01,1.07919e-01,3.34423e-02,3.12608e-01,1.07223e-01,3.32538e-02,3.16228e-01,1.06537e-01,3.30702e-02,
3.16230e-01,1.06537e-01,3.30701e-02,3.27341e-01,1.04447e-01,3.26342e-02,3.31131e-01,1.03771e-01,3.24960e-02,3.42768e-01,
1.01809e-01,3.21101e-02,3.46737e-01,1.01173e-01,3.19873e-02,3.54813e-01,9.99270e-02,3.17491e-02,3.63078e-01,9.87137e-02,
3.15203e-02,3.71535e-01,9.75315e-02,3.13000e-02,3.80189e-01,9.63839e-02,3.10923e-02,3.84592e-01,9.58206e-02,3.09910e-02,
3.98107e-01,9.41711e-02,3.06962e-02,3.98110e-01,9.41708e-02,3.06962e-02,4.12098e-01,9.24969e-02,3.04911e-02,4.16869e-01,
9.19512e-02,3.04237e-02,4.18499e-01,9.17684e-02,3.04016e-02,4.26580e-01,9.08808e-02,3.02938e-02,4.31519e-01,9.03541e-02,
3.02293e-02,4.36516e-01,8.98330e-02,3.01649e-02,4.46684e-01,8.88068e-02,3.00365e-02,4.62381e-01,8.73059e-02,2.98442e-02,
4.67735e-01,8.68172e-02,2.97817e-02,4.73151e-01,8.63330e-02,2.97190e-02,4.78630e-01,8.58537e-02,2.96564e-02,4.84172e-01,
8.53788e-02,2.95935e-02,5.01187e-01,8.39802e-02,2.94039e-02,5.01190e-01,8.39800e-02,2.94039e-02,5.06991e-01,8.34982e-02,
2.93628e-02,5.12861e-01,8.30204e-02,2.93208e-02,5.18800e-01,8.25481e-02,2.92792e-02,5.24808e-01,8.20799e-02,2.92366e-02,
5.30884e-01,8.16159e-02,2.91932e-02,5.43250e-01,8.06997e-02,2.91036e-02,5.49541e-01,8.02473e-02,2.90575e-02,5.62341e-01,
7.93539e-02,2.89626e-02,5.68853e-01,7.89137e-02,2.89148e-02,5.75440e-01,7.84770e-02,2.88661e-02,5.82103e-01,7.80439e-02,
2.88165e-02,5.88844e-01,7.76142e-02,2.87661e-02,5.95662e-01,7.71880e-02,2.87148e-02,6.16595e-01,7.59289e-02,2.85557e-02,
6.23735e-01,7.55164e-02,2.85018e-02,6.30957e-01,7.51071e-02,2.84470e-02,6.30960e-01,7.51069e-02,2.84470e-02,6.38264e-01,
7.46808e-02,2.84114e-02,6.43373e-01,7.43874e-02,2.83859e-02,6.45654e-01,7.42576e-02,2.83743e-02,6.68344e-01,7.30065e-02,
2.82550e-02,6.76083e-01,7.25957e-02,2.82126e-02,6.83912e-01,7.21885e-02,2.81695e-02,6.91831e-01,7.17842e-02,2.81252e-02,
6.99842e-01,7.13829e-02,2.80796e-02,7.24436e-01,7.01961e-02,2.79357e-02,7.41310e-01,6.94187e-02,2.78339e-02,7.49894e-01,
6.90346e-02,2.77819e-02,7.58578e-01,6.86532e-02,2.77288e-02,7.85236e-01,6.75245e-02,2.75631e-02,7.94328e-01,6.71534e-02,
2.75058e-02,7.94330e-01,6.71533e-02,2.75057e-02,8.12831e-01,6.63786e-02,2.74163e-02,8.22243e-01,6.59956e-02,2.73699e-02,
8.31764e-01,6.56153e-02,2.73221e-02,8.60994e-01,6.44896e-02,2.71706e-02,8.70964e-01,6.41194e-02,2.71176e-02,8.91251e-01,
6.33864e-02,2.70079e-02,9.01571e-01,6.30239e-02,2.69516e-02,9.12011e-01,6.26638e-02,2.68941e-02,9.22571e-01,6.23061e-02,
2.68356e-02,9.33254e-01,6.19507e-02,2.67759e-02,9.44061e-01,6.15976e-02,2.67152e-02,9.66051e-01,6.08984e-02,2.65907e-02,
9.77237e-01,6.05525e-02,2.65272e-02,9.88553e-01,6.02088e-02,2.64628e-02,1.00000e+00,5.98673e-02,2.63975e-02,1.00000e-03,
9.81329e+03,9.77085e+03,1.01158e-03,9.55518e+03,9.51412e+03,1.01899e-03,9.39372e+03,9.35352e+03,1.02329e-03,9.30162e+03,
9.26191e+03,1.04937e-03,8.76871e+03,8.73178e+03,1.07152e-03,8.34971e+03,8.31494e+03,1.08393e-03,8.12769e+03,8.09403e+03,
1.08862e-03,8.04564e+03,8.01239e+03,1.09648e-03,7.91069e+03,7.87811e+03,1.13501e-03,7.29431e+03,7.26475e+03,1.13869e-03,
7.23909e+03,7.20979e+03,1.14815e-03,7.09985e+03,7.07122e+03,1.15000e-03,7.07271e+03,7.04421e+03,1.19104e-03,6.50282e+03,
6.47697e+03,1.21619e-03,6.18536e+03,6.16096e+03,1.23027e-03,6.01720e+03,5.99355e+03,1.25890e-03,5.69526e+03,5.67302e+03,
1.25892e-03,5.69499e+03,5.67275e+03,1.27350e-03,5.54042e+03,5.51884e+03,1.28162e-03,5.45455e+03,5.43334e+03,1.28825e-03,
5.38583e+03,5.36491e+03,1.36458e-03,4.67640e+03,4.65840e+03,1.36483e-03,4.67434e+03,4.65635e+03,1.38038e-03,4.54627e+03,
4.52880e+03,1.44018e-03,4.08941e+03,4.07371e+03,1.45000e-03,4.02062e+03,4.00519e+03,1.46218e-03,3.93765e+03,3.92254e+03,
1.51356e-03,3.61325e+03,3.59936e+03,1.54882e-03,3.41230e+03,3.39914e+03,1.56675e-03,3.31540e+03,3.30258e+03,1.58489e-03,
3.22137e+03,3.20889e+03,1.58490e-03,3.22133e+03,3.20885e+03,1.62181e-03,3.04124e+03,3.02939e+03,1.62376e-03,3.03200e+03,
3.02018e+03,1.64059e-03,2.95395e+03,2.94240e+03,1.67880e-03,2.78597e+03,2.77500e+03,1.71791e-03,2.62714e+03,2.61670e+03,
1.73780e-03,2.55124e+03,2.54105e+03,1.74285e-03,2.53249e+03,2.52236e+03,1.77828e-03,2.40599e+03,2.39628e+03,1.79550e-03,
2.34771e+03,2.33819e+03,1.80000e-03,2.33267e+03,2.32319e+03,1.81970e-03,2.26808e+03,2.25882e+03,1.94984e-03,1.89888e+03,
1.89077e+03,1.95000e-03,1.89849e+03,1.89039e+03,1.95679e-03,1.88156e+03,1.87350e+03,1.99526e-03,1.78939e+03,1.78162e+03,
1.99530e-03,1.78931e+03,1.78154e+03,2.01837e-03,1.73704e+03,1.72943e+03,2.04174e-03,1.68630e+03,1.67885e+03,2.05000e-03,
1.66887e+03,1.66146e+03,2.08930e-03,1.58931e+03,1.58214e+03,2.15000e-03,1.47479e+03,1.46796e+03,2.15224e-03,1.47077e+03,
1.46395e+03,2.18776e-03,1.40900e+03,1.40236e+03,2.29087e-03,1.24903e+03,1.24285e+03,2.31740e-03,1.21204e+03,1.20597e+03,
2.33581e-03,1.18726e+03,1.18126e+03,2.37137e-03,1.14137e+03,1.13550e+03,2.42661e-03,1.07423e+03,1.06856e+03,2.48313e-03,
1.01117e+03,1.00568e+03,2.50000e-03,9.93334e+02,9.87895e+02,2.51189e-03,9.80968e+02,9.75564e+02,2.51190e-03,9.80954e+02,
9.75550e+02,2.60016e-03,8.95455e+02,8.90294e+02,2.63027e-03,8.68693e+02,8.63608e+02,2.63704e-03,8.62827e+02,8.57758e+02,
2.69154e-03,8.17586e+02,8.12650e+02,2.72270e-03,7.93008e+02,7.88145e+02,2.80000e-03,7.36120e+02,7.31423e+02,2.81838e-03,
7.23371e+02,7.18712e+02,2.88403e-03,6.80256e+02,6.75722e+02,2.91743e-03,6.59702e+02,6.55228e+02,2.95121e-03,6.39774e+02,
6.35359e+02,3.00000e-03,6.12456e+02,6.08122e+02,3.03055e-03,5.96187e+02,5.91901e+02,3.09030e-03,5.66045e+02,5.61855e+02,
3.16228e-03,5.32296e+02,5.28214e+02,3.16230e-03,5.32286e+02,5.28204e+02,3.19889e-03,5.16187e+02,5.12156e+02,3.34965e-03,
4.55997e+02,4.52161e+02,3.38844e-03,4.42115e+02,4.38324e+02,3.42768e-03,4.28661e+02,4.24917e+02,3.54813e-03,3.90751e+02,
3.87141e+02,3.62112e-03,3.69909e+02,3.66374e+02,3.63078e-03,3.67264e+02,3.63739e+02,3.67282e-03,3.56027e+02,3.52544e+02,
3.80189e-03,3.24200e+02,3.20840e+02,3.84592e-03,3.14257e+02,3.10936e+02,3.92893e-03,2.96646e+02,2.93396e+02,3.98107e-03,
2.86269e+02,2.83065e+02,3.98110e-03,2.86264e+02,2.83059e+02,4.00000e-03,2.82626e+02,2.79437e+02,4.07380e-03,2.69033e+02,
2.65905e+02,4.12097e-03,2.60772e+02,2.57680e+02,4.16869e-03,2.52766e+02,2.49710e+02,4.26388e-03,2.37645e+02,2.34658e+02,
4.26579e-03,2.37353e+02,2.34368e+02,4.31519e-03,2.30012e+02,2.27063e+02,4.36516e-03,2.22906e+02,2.19993e+02,4.57952e-03,
1.95688e+02,1.92917e+02,4.67735e-03,1.84770e+02,1.82062e+02,4.78630e-03,1.73532e+02,1.70890e+02,4.80000e-03,1.72187e+02,
1.69554e+02,4.84172e-03,1.68148e+02,1.65539e+02,4.89779e-03,1.62910e+02,1.60333e+02,4.96342e-03,1.57065e+02,1.54525e+02,
5.00000e-03,1.53931e+02,1.51412e+02,5.01187e-03,1.52935e+02,1.50423e+02,5.01190e-03,1.52933e+02,1.50420e+02,5.30884e-03,
1.30650e+02,1.28297e+02,5.34930e-03,1.27973e+02,1.25640e+02,5.43250e-03,1.22698e+02,1.20406e+02,5.55904e-03,1.15199e+02,
1.12968e+02,5.62341e-03,1.11598e+02,1.09398e+02,5.68853e-03,1.08113e+02,1.05944e+02,5.75267e-03,1.04823e+02,1.02685e+02,
5.95020e-03,9.55123e+01,9.34634e+01,6.09537e-03,8.93749e+01,8.73907e+01,6.13683e-03,8.77271e+01,8.57606e+01,6.30677e-03,
8.13883e+01,7.94954e+01,6.30957e-03,8.12889e+01,7.93972e+01,6.30960e-03,8.12880e+01,7.93962e+01,6.38263e-03,7.87486e+01,
7.68886e+01,6.44866e-03,7.65474e+01,7.47154e+01,6.45654e-03,7.62901e+01,7.44616e+01,6.53131e-03,7.38888e+01,7.20936e+01,
6.68344e-03,6.93157e+01,6.75850e+01,6.70163e-03,6.87950e+01,6.70717e+01,6.81989e-03,6.55325e+01,6.38611e+01,6.99763e-03,
6.10064e+01,5.94162e+01,7.00000e-03,6.09488e+01,5.93598e+01,7.13742e-03,5.77406e+01,5.62195e+01,7.23510e-03,5.55907e+01,
5.41232e+01,7.28252e-03,5.45828e+01,5.31437e+01,7.32824e-03,5.36307e+01,5.22219e+01,7.34429e-03,5.33011e+01,5.19026e+01,
7.38869e-03,5.23978e+01,5.10324e+01,7.41310e-03,5.19071e+01,5.05624e+01,7.42579e-03,5.16527e+01,5.03187e+01,7.45665e-03,
5.10369e+01,4.97325e+01,7.49494e-03,5.02799e+01,4.90178e+01,7.49894e-03,5.02010e+01,4.89439e+01,7.53829e-03,4.94336e+01,
4.82259e+01,7.58578e-03,4.85265e+01,4.73781e+01,7.59446e-03,4.83634e+01,4.72255e+01,7.62109e-03,4.78739e+01,4.67612e+01,
7.64037e-03,4.75294e+01,4.64291e+01,7.65707e-03,4.72384e+01,4.61438e+01,7.67389e-03,4.69529e+01,4.58590e+01,7.68070e-03,
4.68401e+01,4.57443e+01,7.68070e-03,3.59302e+02,2.50254e+02,7.69203e-03,3.58029e+02,2.49515e+02,7.71363e-03,3.55623e+02,
2.48112e+02,7.73392e-03,3.53392e+02,2.46804e+02,7.77365e-03,3.49092e+02,2.44271e+02,7.82552e-03,3.43596e+02,2.41016e+02,
7.85236e-03,3.40797e+02,2.39355e+02,7.85660e-03,3.40358e+02,2.39094e+02,7.89035e-03,3.36885e+02,2.37030e+02,7.93186e-03,
3.32675e+02,2.34525e+02,7.94328e-03,3.31528e+02,2.33842e+02,7.94330e-03,3.31527e+02,2.33841e+02,7.96399e-03,3.29388e+02,
2.32557e+02,7.99874e-03,3.25837e+02,2.30423e+02,8.03526e-03,3.22159e+02,2.28208e+02,8.06605e-03,3.19104e+02,2.26363e+02,
8.14756e-03,3.11202e+02,2.21575e+02,8.15000e-03,3.10970e+02,2.21434e+02,8.25530e-03,3.01003e+02,2.15338e+02,8.37058e-03,
2.90590e+02,2.08921e+02,8.51138e-03,2.78539e+02,2.01430e+02,8.51174e-03,2.78509e+02,2.01411e+02,8.60994e-03,2.70503e+02,
1.96395e+02,8.70964e-03,2.62697e+02,1.91472e+02,8.74293e-03,2.60161e+02,1.89866e+02,8.81049e-03,2.55117e+02,1.86662e+02,
9.01774e-03,2.40473e+02,1.77283e+02,9.15000e-03,2.31732e+02,1.71630e+02,9.22571e-03,2.26756e+02,1.68376e+02,9.33254e-03,
2.19982e+02,1.63925e+02,9.38238e-03,2.16918e+02,1.61910e+02,9.75800e-03,1.95613e+02,1.47751e+02,9.80000e-03,1.93413e+02,
1.46274e+02,1.00000e-02,1.83384e+02,1.39500e+02,1.01158e-02,1.77902e+02,1.35769e+02,1.02669e-02,1.71086e+02,1.31103e+02,
1.03514e-02,1.67427e+02,1.28587e+02,1.08393e-02,1.48300e+02,1.15280e+02,1.09411e-02,1.44692e+02,1.12741e+02,1.13501e-02,
1.31366e+02,1.03279e+02,1.14815e-02,1.27442e+02,1.00466e+02,1.16145e-02,1.23635e+02,9.77256e+01,1.17490e-02,1.19942e+02,
9.50554e+01,1.19000e-02,1.15974e+02,9.21739e+01,1.19901e-02,1.13632e+02,9.04619e+01,1.21619e-02,1.09343e+02,8.73168e+01,
1.25890e-02,9.96002e+01,8.01129e+01,1.25892e-02,9.95949e+01,8.01090e+01,1.27350e-02,9.65438e+01,7.78357e+01,1.31826e-02,
8.79429e+01,7.13809e+01,1.31926e-02,8.77613e+01,7.12441e+01,1.34896e-02,8.26349e+01,6.73678e+01,1.36458e-02,8.01032e+01,
6.54437e+01,1.38038e-02,7.76490e+01,6.35719e+01,1.42889e-02,7.07305e+01,5.82605e+01,1.46218e-02,6.64671e+01,5.49609e+01,
1.48391e-02,6.38731e+01,5.29429e+01,1.51356e-02,6.05518e+01,5.03482e+01,1.54882e-02,5.68275e+01,4.74177e+01,1.56675e-02,
5.50510e+01,4.60136e+01,1.58489e-02,5.33306e+01,4.46501e+01,1.58490e-02,5.33299e+01,4.46495e+01,1.62181e-02,5.00502e+01,
4.20397e+01,1.64841e-02,4.78557e+01,4.02853e+01,1.67880e-02,4.55050e+01,3.83993e+01,1.71791e-02,4.27083e+01,3.61453e+01,
1.80000e-02,3.75598e+01,3.19651e+01,1.81970e-02,3.64521e+01,3.10604e+01,1.84077e-02,3.53153e+01,3.01297e+01,1.86037e-02,
3.43014e+01,2.92979e+01,1.88365e-02,3.31475e+01,2.83495e+01,1.90546e-02,3.20962e+01,2.74826e+01,1.92752e-02,3.10786e+01,
2.66416e+01,1.97242e-02,2.91397e+01,2.50342e+01,1.99526e-02,2.82167e+01,2.42666e+01,1.99530e-02,2.82152e+01,2.42654e+01,
2.01837e-02,2.73231e+01,2.35222e+01,2.06422e-02,2.56614e+01,2.21346e+01,2.13796e-02,2.32657e+01,2.01257e+01,2.16272e-02,
2.25296e+01,1.95060e+01,2.23872e-02,2.04596e+01,1.77573e+01,2.29087e-02,1.91877e+01,1.66780e+01,2.29634e-02,1.90605e+01,
1.65699e+01,2.31740e-02,1.85817e+01,1.61628e+01,2.34423e-02,1.79867e+01,1.56557e+01,2.39883e-02,1.68540e+01,1.46880e+01,
2.46924e-02,1.55331e+01,1.35555e+01,2.51189e-02,1.48009e+01,1.29263e+01,2.51190e-02,1.48006e+01,1.29261e+01,2.54097e-02,
1.43282e+01,1.25195e+01,2.66073e-02,1.25846e+01,1.10136e+01,2.72117e-02,1.18140e+01,1.03453e+01,2.75423e-02,1.14195e+01,
1.00028e+01,2.78612e-02,1.10560e+01,9.68670e+00,2.81838e-02,1.07042e+01,9.38046e+00,2.88403e-02,1.00263e+01,8.78895e+00,
2.98538e-02,9.09087e+00,7.97030e+00,3.01995e-02,8.79932e+00,7.71458e+00,3.16228e-02,7.72475e+00,6.76959e+00,3.16230e-02,
7.72460e+00,6.76945e+00,3.27341e-02,7.00745e+00,6.13705e+00,3.32052e-02,6.73109e+00,5.89286e+00,3.34965e-02,6.56761e+00,
5.74833e+00,3.42768e-02,6.15607e+00,5.38406e+00,3.54813e-02,5.58178e+00,4.87440e+00,3.63078e-02,5.22998e+00,4.56158e+00,
3.80189e-02,4.59311e+00,3.99418e+00,3.91059e-02,4.24358e+00,3.68209e+00,3.93550e-02,4.16867e+00,3.61522e+00,3.98107e-02,
4.03637e+00,3.49705e+00,3.98110e-02,4.03629e+00,3.49697e+00,4.21696e-02,3.43770e+00,2.96164e+00,4.36516e-02,3.12091e+00,
2.67759e+00,4.41570e-02,3.02220e+00,2.58900e+00,4.46684e-02,2.92680e+00,2.50334e+00,4.57088e-02,2.74546e+00,2.34043e+00,
4.78630e-02,2.41775e+00,2.04571e+00,5.01187e-02,2.13176e+00,1.78821e+00,5.01190e-02,2.13172e+00,1.78818e+00,5.24807e-02,
1.88150e+00,1.56331e+00,5.30884e-02,1.82351e+00,1.51116e+00,5.43250e-02,1.71323e+00,1.41195e+00,5.54097e-02,1.62437e+00,
1.33202e+00,5.62341e-02,1.56125e+00,1.27530e+00,5.82103e-02,1.42402e+00,1.15199e+00,6.23735e-02,1.18835e+00,9.40338e-01,
6.30957e-02,1.15355e+00,9.09109e-01,6.30960e-02,1.15353e+00,9.09097e-01,6.60693e-02,1.02526e+00,7.94517e-01,6.69866e-02,
9.90098e-01,7.63137e-01,6.76083e-02,9.67293e-01,7.42820e-01,6.91831e-02,9.12653e-01,6.94141e-01,7.07946e-02,8.61624e-01,
6.48731e-01,7.32825e-02,7.91329e-01,5.86272e-01,7.94328e-02,6.52739e-01,4.63563e-01,7.94330e-02,6.52736e-01,4.63560e-01,
8.15636e-02,6.13754e-01,4.29434e-01,8.31764e-02,5.86760e-01,4.05893e-01,8.41395e-02,5.71598e-01,3.92691e-01,8.60994e-02,
5.42742e-01,3.67612e-01,8.70964e-02,5.29027e-01,3.55715e-01,9.01571e-02,4.90538e-01,3.22416e-01,9.12011e-02,4.78546e-01,
3.12071e-01,9.22571e-02,4.66904e-01,3.02038e-01,9.66051e-02,4.24057e-01,2.65255e-01,9.77237e-02,4.14212e-01,2.56839e-01,
1.00000e-01,3.95484e-01,2.40871e-01,1.00088e-01,3.94790e-01,2.40288e-01,1.01158e-01,3.86481e-01,2.33334e-01,1.04713e-01,
3.61187e-01,2.12254e-01,1.07152e-01,3.45662e-01,1.99391e-01,1.08393e-01,3.38273e-01,1.93292e-01,1.13501e-01,3.11021e-01,
1.70937e-01,1.14815e-01,3.04745e-01,1.65824e-01,1.16145e-01,2.98670e-01,1.60889e-01,1.17490e-01,2.92788e-01,1.56124e-01,
1.25890e-01,2.61156e-01,1.30826e-01,1.25893e-01,2.61148e-01,1.30819e-01,1.27350e-01,2.56372e-01,1.27134e-01,1.28825e-01,
2.51745e-01,1.23578e-01,1.30317e-01,2.47261e-01,1.20145e-01,1.31826e-01,2.42916e-01,1.16832e-01,1.36458e-01,2.30666e-01,
1.07570e-01,1.39637e-01,2.23111e-01,1.01920e-01,1.46360e-01,2.09053e-01,9.15557e-02,1.47911e-01,2.06131e-01,8.94317e-02,
1.50000e-01,2.02366e-01,8.67096e-02,1.51356e-01,2.00022e-01,8.50239e-02,1.58489e-01,1.88853e-01,7.70925e-02,1.58490e-01,
1.88852e-01,7.70918e-02,1.62181e-01,1.83634e-01,7.35985e-02,1.65959e-01,1.78709e-01,7.03446e-02,1.67880e-01,1.76367e-01,
6.88190e-02,1.71791e-01,1.71877e-01,6.59245e-02,1.73780e-01,1.69724e-01,6.45517e-02,1.75792e-01,1.67631e-01,6.32263e-02,
1.81970e-01,1.61686e-01,5.95179e-02,1.84077e-01,1.59811e-01,5.83659e-02,1.86209e-01,1.57985e-01,5.72534e-02,1.88365e-01,
1.56208e-01,5.61791e-02,1.92752e-01,1.52796e-01,5.41419e-02,1.99526e-01,1.47993e-01,5.13397e-02,1.99530e-01,1.47990e-01,
5.13383e-02,2.00000e-01,1.47667e-01,5.11648e-02,2.01837e-01,1.46425e-01,5.05023e-02,2.06538e-01,1.43405e-01,4.89126e-02,
2.08930e-01,1.41951e-01,4.81584e-02,2.11349e-01,1.40532e-01,4.74300e-02,2.16272e-01,1.37795e-01,4.60469e-02,2.18776e-01,
1.36486e-01,4.54000e-02,2.21309e-01,1.35207e-01,4.47749e-02,2.23872e-01,1.33958e-01,4.41706e-02,2.26464e-01,1.32737e-01,
4.35863e-02,2.29087e-01,1.31545e-01,4.30222e-02,2.31740e-01,1.30379e-01,4.24768e-02,2.37137e-01,1.28126e-01,4.14392e-02,
2.42661e-01,1.25971e-01,4.04683e-02,2.51189e-01,1.22909e-01,3.91271e-02,2.51190e-01,1.22909e-01,3.91269e-02,2.54097e-01,
1.21892e-01,3.87401e-02,2.57040e-01,1.20902e-01,3.83723e-02,2.60016e-01,1.19931e-01,3.80163e-02,2.63027e-01,1.18980e-01,
3.76715e-02,2.66073e-01,1.18046e-01,3.73375e-02,2.81838e-01,1.13635e-01,3.58183e-02,2.85102e-01,1.12801e-01,3.55416e-02,
2.88403e-01,1.11983e-01,3.52731e-02,2.91743e-01,1.11179e-01,3.50126e-02,2.98538e-01,1.09623e-01,3.45229e-02,3.01995e-01,
1.08864e-01,3.42884e-02,3.09029e-01,1.07386e-01,3.38389e-02,3.12608e-01,1.06666e-01,3.36237e-02,3.16228e-01,1.05957e-01,
3.34144e-02,3.16230e-01,1.05957e-01,3.34143e-02,3.19889e-01,1.05228e-01,3.32399e-02,3.23594e-01,1.04510e-01,3.30701e-02,
3.31131e-01,1.03107e-01,3.27435e-02,3.38844e-01,1.01753e-01,3.24400e-02,3.42768e-01,1.01090e-01,3.22936e-02,3.46737e-01,
1.00438e-01,3.21505e-02,3.50752e-01,9.97944e-02,3.20107e-02,3.58922e-01,9.85352e-02,3.17408e-02,3.67282e-01,9.73102e-02,
3.14821e-02,3.68589e-01,9.71242e-02,3.14431e-02,3.71535e-01,9.67095e-02,3.13567e-02,3.80189e-01,9.55370e-02,3.11186e-02,
3.84592e-01,9.49620e-02,3.10028e-02,3.89045e-01,9.43943e-02,3.08890e-02,3.93550e-01,9.38337e-02,3.07771e-02,3.98107e-01,
9.32802e-02,3.06672e-02,3.98110e-01,9.32799e-02,3.06671e-02,4.00000e-01,9.30431e-02,3.06333e-02,4.16869e-01,9.10260e-02,
3.03448e-02,4.21697e-01,9.04810e-02,3.02686e-02,4.26580e-01,8.99422e-02,3.01929e-02,4.31519e-01,8.94093e-02,3.01178e-02,
4.36516e-01,8.88823e-02,3.00431e-02,4.41570e-01,8.83611e-02,2.99691e-02,4.51856e-01,8.73355e-02,2.98223e-02,4.57088e-01,
8.68308e-02,2.97494e-02,4.62381e-01,8.63313e-02,2.96768e-02,4.67735e-01,8.58388e-02,2.96062e-02,4.73151e-01,8.53511e-02,
2.95358e-02,4.78630e-01,8.48684e-02,2.94655e-02,4.84172e-01,8.43903e-02,2.93953e-02,4.89779e-01,8.39171e-02,2.93254e-02,
4.95450e-01,8.34484e-02,2.92554e-02,5.01187e-01,8.29842e-02,2.91855e-02,5.01190e-01,8.29840e-02,2.91855e-02,5.06991e-01,
8.25009e-02,2.91382e-02,5.12861e-01,8.20220e-02,2.90902e-02,5.24808e-01,8.10802e-02,2.89949e-02,5.30884e-01,8.06156e-02,
2.89462e-02,5.37032e-01,8.01552e-02,2.88967e-02,5.49541e-01,7.92466e-02,2.87959e-02,5.53509e-01,7.89660e-02,2.87638e-02,
5.62341e-01,7.83534e-02,2.86922e-02,5.75440e-01,7.74774e-02,2.85878e-02,5.82103e-01,7.70448e-02,2.85345e-02,5.88844e-01,
7.66158e-02,2.84804e-02,5.95662e-01,7.61904e-02,2.84257e-02,6.16595e-01,7.49347e-02,2.82572e-02,6.23735e-01,7.45237e-02,
2.82005e-02,6.30957e-01,7.41159e-02,2.81431e-02,6.30960e-01,7.41157e-02,2.81431e-02,6.38264e-01,7.36904e-02,2.81036e-02,
6.45654e-01,7.32682e-02,2.80629e-02,6.76083e-01,7.16121e-02,2.78879e-02,6.80480e-01,7.13834e-02,2.78622e-02,6.83912e-01,
7.12066e-02,2.78419e-02,6.91831e-01,7.08041e-02,2.77948e-02,6.99842e-01,7.04046e-02,2.77464e-02,7.08570e-01,6.99778e-02,
2.76932e-02,7.32825e-01,6.88358e-02,2.75424e-02,7.41310e-01,6.84506e-02,2.74887e-02,7.58578e-01,6.76897e-02,2.73795e-02,
7.67362e-01,6.73132e-02,2.73234e-02,7.76247e-01,6.69394e-02,2.72664e-02,7.94328e-01,6.61996e-02,2.71495e-02,7.94330e-01,
6.61995e-02,2.71494e-02,8.03526e-01,6.58142e-02,2.71039e-02,8.12831e-01,6.54315e-02,2.70571e-02,8.31764e-01,6.46750e-02,
2.69603e-02,8.41395e-01,6.43007e-02,2.69100e-02,8.51138e-01,6.39290e-02,2.68584e-02,8.60994e-01,6.35598e-02,2.68056e-02,
8.70964e-01,6.31931e-02,2.67516e-02,8.91251e-01,6.24673e-02,2.66402e-02,9.01571e-01,6.21085e-02,2.65832e-02,9.12011e-01,
6.17521e-02,2.65251e-02,9.33254e-01,6.10464e-02,2.64058e-02,9.54993e-01,6.03500e-02,2.62824e-02,9.66051e-01,6.00052e-02,
2.62192e-02,9.77237e-01,5.96631e-02,2.61555e-02,9.88553e-01,5.93233e-02,2.60909e-02,1.00000e+00,5.89856e-02,2.60254e-02,
1.00000e-03,9.86369e+03,9.80706e+03,1.00331e-03,9.77976e+03,9.72369e+03,1.00650e-03,9.70000e+03,9.64447e+03,1.00650e-03,
1.10118e+04,1.09481e+04,1.01141e-03,1.08815e+04,1.08187e+04,1.01604e-03,1.07604e+04,1.06984e+04,1.02130e-03,1.06253e+04,
1.05642e+04,1.02643e-03,1.04956e+04,1.04354e+04,1.03000e-03,1.04068e+04,1.03473e+04,1.03514e-03,1.02826e+04,1.02240e+04,
1.04458e-03,1.00656e+04,1.00085e+04,1.05796e-03,9.76906e+03,9.71408e+03,1.05925e-03,9.74095e+03,9.68617e+03,1.08155e-03,
9.27540e+03,9.22392e+03,1.08393e-03,9.22772e+03,9.17657e+03,1.10918e-03,8.74193e+03,8.69416e+03,1.11000e-03,8.72668e+03,
8.67902e+03,1.11076e-03,8.71260e+03,8.66503e+03,1.12202e-03,8.50803e+03,8.46186e+03,1.13501e-03,8.28041e+03,8.23578e+03,
1.14706e-03,8.07782e+03,8.03455e+03,1.17490e-03,7.63604e+03,7.59569e+03,1.18644e-03,7.46220e+03,7.42297e+03,1.19000e-03,
7.40973e+03,7.37084e+03,1.21619e-03,7.03926e+03,7.00273e+03,1.23921e-03,6.73127e+03,6.69666e+03,1.24451e-03,6.66300e+03,
6.62882e+03,1.25890e-03,6.48285e+03,6.44977e+03,1.25892e-03,6.48254e+03,6.44946e+03,1.29485e-03,6.05927e+03,6.02873e+03,
1.33352e-03,5.64616e+03,5.61804e+03,1.35000e-03,5.48235e+03,5.45516e+03,1.36458e-03,5.34123e+03,5.31484e+03,1.36898e-03,
5.29957e+03,5.27342e+03,1.39637e-03,5.05028e+03,5.02551e+03,1.40000e-03,5.01847e+03,4.99388e+03,1.41254e-03,4.91007e+03,
4.88607e+03,1.42889e-03,4.77364e+03,4.75037e+03,1.44505e-03,4.64350e+03,4.62093e+03,1.46218e-03,4.51093e+03,4.48906e+03,
1.47911e-03,4.38512e+03,4.36391e+03,1.51356e-03,4.14048e+03,4.12054e+03,1.53109e-03,4.02333e+03,4.00398e+03,1.54764e-03,
3.91634e+03,3.89753e+03,1.57000e-03,3.77804e+03,3.75991e+03,1.58489e-03,3.68974e+03,3.67205e+03,1.58490e-03,3.68970e+03,
3.67201e+03,1.60325e-03,3.58494e+03,3.56777e+03,1.62181e-03,3.48319e+03,3.46651e+03,1.69824e-03,3.10503e+03,3.09013e+03,
1.70120e-03,3.09159e+03,3.07675e+03,1.70907e-03,3.05599e+03,3.04131e+03,1.71791e-03,3.01669e+03,3.00220e+03,1.73780e-03,
2.93079e+03,2.91669e+03,1.77828e-03,2.76483e+03,2.75148e+03,1.80000e-03,2.68120e+03,2.66823e+03,1.81970e-03,2.60793e+03,
2.59527e+03,1.84077e-03,2.53266e+03,2.52033e+03,1.86209e-03,2.45963e+03,2.44761e+03,1.88365e-03,2.38844e+03,2.37673e+03,
1.90546e-03,2.31937e+03,2.30795e+03,1.91305e-03,2.29574e+03,2.28442e+03,1.92753e-03,2.25157e+03,2.24043e+03,1.99526e-03,
2.05996e+03,2.04961e+03,1.99530e-03,2.05985e+03,2.04951e+03,2.00000e-03,2.04741e+03,2.03712e+03,2.01837e-03,1.99966e+03,
1.98957e+03,2.05086e-03,1.91890e+03,1.90912e+03,2.06538e-03,1.88427e+03,1.87464e+03,2.08930e-03,1.82917e+03,1.81976e+03,
2.16272e-03,1.67362e+03,1.66482e+03,2.21310e-03,1.57688e+03,1.56846e+03,2.23872e-03,1.53069e+03,1.52244e+03,2.29087e-03,
1.44161e+03,1.43370e+03,2.30000e-03,1.42676e+03,1.41891e+03,2.34423e-03,1.35745e+03,1.34985e+03,2.37137e-03,1.31724e+03,
1.30980e+03,2.39038e-03,1.29008e+03,1.28273e+03,2.40000e-03,1.27662e+03,1.26932e+03,2.42661e-03,1.24022e+03,1.23306e+03,
2.51189e-03,1.13289e+03,1.12613e+03,2.51190e-03,1.13287e+03,1.12611e+03,2.60016e-03,1.03434e+03,1.02793e+03,2.66073e-03,
9.73559e+02,9.67378e+02,2.69154e-03,9.44450e+02,9.38374e+02,2.73164e-03,9.08380e+02,9.02433e+02,2.75423e-03,8.88897e+02,
8.83022e+02,2.78612e-03,8.62372e+02,8.56594e+02,2.80000e-03,8.51102e+02,8.45365e+02,2.91743e-03,7.63489e+02,7.58073e+02,
2.95121e-03,7.40452e+02,7.35120e+02,3.00000e-03,7.08859e+02,7.03641e+02,3.01995e-03,6.96434e+02,6.91261e+02,3.05492e-03,
6.75386e+02,6.70289e+02,3.07719e-03,6.62454e+02,6.57405e+02,3.12608e-03,6.35235e+02,6.30288e+02,3.16228e-03,6.16004e+02,
6.11130e+02,3.16230e-03,6.15993e+02,6.11118e+02,3.30000e-03,5.49747e+02,5.45123e+02,3.34965e-03,5.28309e+02,5.23766e+02,
3.36407e-03,5.22259e+02,5.17739e+02,3.38844e-03,5.12249e+02,5.07770e+02,3.42768e-03,4.96694e+02,4.92276e+02,3.46737e-03,
4.81626e+02,4.77268e+02,3.50752e-03,4.67030e+02,4.62731e+02,3.54813e-03,4.52832e+02,4.48591e+02,3.69864e-03,4.04895e+02,
4.00848e+02,3.80189e-03,3.75962e+02,3.72041e+02,3.84592e-03,3.64520e+02,3.60648e+02,3.89045e-03,3.53353e+02,3.49531e+02,
3.93550e-03,3.42541e+02,3.38766e+02,3.98107e-03,3.32070e+02,3.28343e+02,3.98110e-03,3.32064e+02,3.28336e+02,3.99398e-03,
3.29186e+02,3.25472e+02,4.02717e-03,3.21929e+02,3.18249e+02,4.07380e-03,3.12099e+02,3.08466e+02,4.31319e-03,2.67329e+02,
2.63915e+02,4.31519e-03,2.66994e+02,2.63582e+02,4.41570e-03,2.50882e+02,2.47557e+02,4.46684e-03,2.43160e+02,2.39877e+02,
4.51856e-03,2.35684e+02,2.32442e+02,4.57088e-03,2.28440e+02,2.25238e+02,4.62381e-03,2.21421e+02,2.18258e+02,4.66954e-03,
2.15549e+02,2.12420e+02,4.89779e-03,1.89219e+02,1.86252e+02,5.01187e-03,1.77729e+02,1.74836e+02,5.01190e-03,1.77726e+02,
1.74834e+02,5.05533e-03,1.73609e+02,1.70744e+02,5.06991e-03,1.72257e+02,1.69401e+02,5.18800e-03,1.61768e+02,1.58987e+02,
5.24807e-03,1.56771e+02,1.54026e+02,5.30884e-03,1.51930e+02,1.49221e+02,5.37032e-03,1.47205e+02,1.44531e+02,5.40844e-03,
1.44372e+02,1.41719e+02,5.55904e-03,1.33881e+02,1.31312e+02,5.61402e-03,1.30319e+02,1.27779e+02,5.75440e-03,1.21794e+02,
1.19328e+02,5.82103e-03,1.18021e+02,1.15589e+02,5.83453e-03,1.17276e+02,1.14852e+02,5.88844e-03,1.14367e+02,1.11970e+02,
6.06584e-03,1.05429e+02,1.03118e+02,6.09537e-03,1.04034e+02,1.01738e+02,6.16595e-03,1.00805e+02,9.85419e+01,6.23735e-03,
9.76528e+01,9.54230e+01,6.29597e-03,9.51671e+01,9.29637e+01,6.30957e-03,9.46023e+01,9.24052e+01,6.30960e-03,9.46012e+01,
9.24041e+01,6.38263e-03,9.16407e+01,8.94772e+01,6.51015e-03,8.67775e+01,8.46703e+01,6.68344e-03,8.07147e+01,7.86834e+01,
6.69809e-03,8.02299e+01,7.82047e+01,6.76083e-03,7.81966e+01,7.61988e+01,6.83912e-03,7.57594e+01,7.37948e+01,6.87929e-03,
7.45453e+01,7.25974e+01,7.07946e-03,6.88716e+01,6.70090e+01,7.15055e-03,6.70002e+01,6.51665e+01,7.16143e-03,6.67194e+01,
6.48905e+01,7.24436e-03,6.46155e+01,6.28228e+01,7.32824e-03,6.25799e+01,6.08226e+01,7.37977e-03,6.13735e+01,5.96374e+01,
7.41310e-03,6.06079e+01,5.88871e+01,7.57650e-03,5.70352e+01,5.53865e+01,7.67362e-03,5.50404e+01,5.34386e+01,7.71743e-03,
5.41728e+01,5.25916e+01,7.82223e-03,5.21642e+01,5.06379e+01,7.85236e-03,5.16029e+01,5.00946e+01,7.91046e-03,5.05450e+01,
4.90705e+01,7.94239e-03,4.99736e+01,4.85200e+01,7.94328e-03,4.99577e+01,4.85047e+01,7.94330e-03,4.99574e+01,4.85044e+01,
7.98806e-03,4.91679e+01,4.77467e+01,8.02724e-03,4.84865e+01,4.70967e+01,8.03526e-03,4.83476e+01,4.69652e+01,8.06060e-03,
4.79112e+01,4.65517e+01,8.10220e-03,4.71998e+01,4.58835e+01,8.14909e-03,4.64066e+01,4.51456e+01,8.20957e-03,4.54079e+01,
4.42177e+01,8.22243e-03,4.52023e+01,4.40238e+01,8.23695e-03,4.49715e+01,4.38061e+01,8.25646e-03,4.46690e+01,4.35160e+01,
8.27539e-03,4.43829e+01,4.32369e+01,8.29286e-03,4.41261e+01,4.29817e+01,8.30280e-03,4.39833e+01,4.28373e+01,8.30280e-03,
3.34399e+02,2.24132e+02,8.30794e-03,3.33800e+02,2.23794e+02,8.31764e-03,3.32677e+02,2.23157e+02,8.32947e-03,3.31313e+02,
2.22384e+02,8.35006e-03,3.28961e+02,2.21045e+02,8.37549e-03,3.26095e+02,2.19406e+02,8.41395e-03,3.21831e+02,2.16957e+02,
8.42000e-03,3.21168e+02,2.16575e+02,8.45116e-03,3.18880e+02,2.15367e+02,8.47000e-03,3.17506e+02,2.14640e+02,8.48138e-03,
3.16451e+02,2.14047e+02,8.50308e-03,3.14449e+02,2.12921e+02,8.51138e-03,3.13687e+02,2.12492e+02,8.52616e-03,3.12337e+02,
2.11732e+02,8.55050e-03,3.10130e+02,2.10487e+02,8.59512e-03,3.06134e+02,2.08232e+02,8.65261e-03,3.01083e+02,2.05372e+02,
8.69999e-03,2.97005e+02,2.03056e+02,8.70964e-03,2.96183e+02,2.02588e+02,8.78248e-03,2.90081e+02,1.99104e+02,8.81049e-03,
2.87778e+02,1.97786e+02,8.85000e-03,2.84575e+02,1.95946e+02,8.89223e-03,2.81141e+02,1.93958e+02,9.02622e-03,2.70612e+02,
1.87829e+02,9.12011e-03,2.63556e+02,1.83688e+02,9.18556e-03,2.58790e+02,1.80875e+02,9.33254e-03,2.48511e+02,1.74763e+02,
9.43520e-03,2.41669e+02,1.70659e+02,9.44061e-03,2.41316e+02,1.70447e+02,9.54993e-03,2.34323e+02,1.66223e+02,9.66051e-03,
2.27534e+02,1.62092e+02,9.74428e-03,2.22567e+02,1.59051e+02,9.77237e-03,2.20935e+02,1.58048e+02,1.00000e-02,2.08306e+02,
1.50232e+02,1.01158e-02,2.02268e+02,1.46457e+02,1.02329e-02,1.96209e+02,1.42625e+02,1.05796e-02,1.79687e+02,1.32081e+02,
1.10918e-02,1.58600e+02,1.18339e+02,1.12158e-02,1.54013e+02,1.15304e+02,1.12202e-02,1.53853e+02,1.15198e+02,1.13501e-02,
1.49241e+02,1.12130e+02,1.16145e-02,1.40432e+02,1.06221e+02,1.17490e-02,1.36226e+02,1.03377e+02,1.18850e-02,1.32146e+02,
1.00604e+02,1.20226e-02,1.28190e+02,9.79005e+01,1.20241e-02,1.28148e+02,9.78716e+01,1.25890e-02,1.13526e+02,8.77588e+01,
1.25892e-02,1.13520e+02,8.77546e+01,1.30317e-02,1.03634e+02,8.08021e+01,1.31826e-02,1.00453e+02,7.85384e+01,1.33352e-02,
9.73664e+01,7.63320e+01,1.38038e-02,8.86682e+01,7.00610e+01,1.41254e-02,8.33087e+01,6.61566e+01,1.42482e-02,8.13793e+01,
6.47455e+01,1.53109e-02,6.69884e+01,5.40826e+01,1.54882e-02,6.49333e+01,5.25384e+01,1.56675e-02,6.29416e+01,5.10365e+01,
1.57291e-02,6.22775e+01,5.05346e+01,1.58489e-02,6.10112e+01,4.95761e+01,1.58490e-02,6.10105e+01,4.95755e+01,1.60324e-02,
5.91402e+01,4.81558e+01,1.62181e-02,5.73270e+01,4.67748e+01,1.65959e-02,5.38673e+01,4.41267e+01,1.67880e-02,5.21820e+01,
4.28282e+01,1.72857e-02,4.81411e+01,3.96974e+01,1.77828e-02,4.45193e+01,3.68706e+01,1.81970e-02,4.17788e+01,3.47175e+01,
1.86209e-02,3.92077e+01,3.26861e+01,1.87317e-02,3.85712e+01,3.21814e+01,1.88365e-02,3.79825e+01,3.17142e+01,1.90546e-02,
3.67957e+01,3.07705e+01,1.92752e-02,3.56465e+01,2.98541e+01,1.94985e-02,3.45335e+01,2.89644e+01,1.99526e-02,3.24121e+01,
2.72620e+01,1.99530e-02,3.24104e+01,2.72606e+01,2.01837e-02,3.14011e+01,2.64477e+01,2.06538e-02,2.94737e+01,2.48897e+01,
2.08930e-02,2.85396e+01,2.41311e+01,2.09443e-02,2.83441e+01,2.39721e+01,2.13796e-02,2.67578e+01,2.26796e+01,2.18776e-02,
2.50883e+01,2.13134e+01,2.21309e-02,2.42933e+01,2.06612e+01,2.23872e-02,2.35239e+01,2.00285e+01,2.29995e-02,2.18160e+01,
1.86194e+01,2.34423e-02,2.06846e+01,1.76826e+01,2.42661e-02,1.87848e+01,1.61023e+01,2.45471e-02,1.81917e+01,1.56071e+01,
2.48313e-02,1.76171e+01,1.51262e+01,2.51189e-02,1.70608e+01,1.46600e+01,2.51190e-02,1.70605e+01,1.46597e+01,2.54097e-02,
1.65222e+01,1.42078e+01,2.54566e-02,1.64365e+01,1.41357e+01,2.63027e-02,1.49860e+01,1.29134e+01,2.66073e-02,1.45068e+01,
1.25083e+01,2.81911e-02,1.23258e+01,1.06556e+01,2.91743e-02,1.11929e+01,9.68780e+00,3.01995e-02,1.01579e+01,8.79979e+00,
3.05492e-02,9.83500e+00,8.52202e+00,3.09030e-02,9.52262e+00,8.25290e+00,3.16228e-02,8.92083e+00,7.73309e+00,3.16230e-02,
8.92066e+00,7.73293e+00,3.19889e-02,8.63459e+00,7.48549e+00,3.27341e-02,8.09003e+00,7.01361e+00,3.31131e-02,7.83108e+00,
6.78881e+00,3.46737e-02,6.87764e+00,5.95886e+00,3.58922e-02,6.24104e+00,5.40259e+00,3.68540e-02,5.79498e+00,5.01179e+00,
3.80189e-02,5.31166e+00,4.58766e+00,3.91085e-02,4.90451e+00,4.22933e+00,3.93550e-02,4.81847e+00,4.15350e+00,3.98107e-02,
4.66488e+00,4.01810e+00,3.98110e-02,4.66478e+00,4.01802e+00,4.06659e-02,4.39438e+00,3.77961e+00,4.12097e-02,4.23355e+00,
3.63775e+00,4.16869e-02,4.09914e+00,3.51910e+00,4.31519e-02,3.72171e+00,3.18547e+00,4.57088e-02,3.17163e+00,2.69799e+00,
4.73151e-02,2.88346e+00,2.44205e+00,5.01187e-02,2.45945e+00,2.06453e+00,5.01190e-02,2.45941e+00,2.06450e+00,5.06991e-02,
2.38286e+00,1.99638e+00,5.18800e-02,2.23713e+00,1.86664e+00,5.43250e-02,1.97375e+00,1.63196e+00,5.55904e-02,1.85487e+00,
1.52599e+00,5.62341e-02,1.79840e+00,1.47563e+00,5.88102e-02,1.59601e+00,1.29511e+00,5.95662e-02,1.54297e+00,1.24784e+00,
6.23735e-02,1.36594e+00,1.08999e+00,6.30957e-02,1.32530e+00,1.05375e+00,6.30960e-02,1.32529e+00,1.05374e+00,6.38264e-02,
1.28593e+00,1.01877e+00,6.60693e-02,1.17554e+00,9.20730e-01,6.76083e-02,1.10797e+00,8.60757e-01,7.07946e-02,9.85853e-01,
7.52490e-01,7.41310e-02,8.79244e-01,6.58130e-01,7.48157e-02,8.59637e-01,6.40798e-01,7.76247e-02,7.86052e-01,5.75903e-01,
7.85236e-02,7.64486e-01,5.56895e-01,7.94328e-02,7.43628e-01,5.38520e-01,7.94330e-02,7.43624e-01,5.38517e-01,8.12830e-02,
7.03819e-01,5.03713e-01,8.51138e-02,6.31853e-01,4.40962e-01,8.70964e-02,5.99362e-01,4.12720e-01,9.02399e-02,5.53428e-01,
3.72908e-01,9.33254e-02,5.14003e-01,3.38911e-01,9.54993e-02,4.89151e-01,3.17552e-01,9.66051e-02,4.77336e-01,3.07419e-01,
1.00000e-01,4.44175e-01,2.79061e-01,1.01158e-01,4.33753e-01,2.70285e-01,1.02329e-01,4.23671e-01,2.61813e-01,1.03514e-01,
4.13917e-01,2.53632e-01,1.04713e-01,4.04475e-01,2.45728e-01,1.07152e-01,3.86502e-01,2.30729e-01,1.07246e-01,3.85840e-01,
2.30179e-01,1.12202e-01,3.53841e-01,2.03710e-01,1.16145e-01,3.32003e-01,1.85795e-01,1.17490e-01,3.25186e-01,1.80231e-01,
1.23027e-01,3.00027e-01,1.59829e-01,1.25890e-01,2.88626e-01,1.50663e-01,1.25893e-01,2.88616e-01,1.50655e-01,1.26642e-01,
2.85753e-01,1.48411e-01,1.28825e-01,2.77752e-01,1.42174e-01,1.30317e-01,2.72571e-01,1.38153e-01,1.33352e-01,2.62686e-01,
1.30524e-01,1.38038e-01,2.48975e-01,1.20042e-01,1.39637e-01,2.44684e-01,1.16787e-01,1.44544e-01,2.32580e-01,1.07684e-01,
1.46218e-01,2.28788e-01,1.04858e-01,1.50000e-01,2.20782e-01,9.89317e-02,1.53109e-01,2.14732e-01,9.44960e-02,1.58489e-01,
2.05257e-01,8.76289e-02,1.58490e-01,2.05256e-01,8.76281e-02,1.62181e-01,1.99279e-01,8.35093e-02,1.63470e-01,1.97304e-01,
8.21593e-02,1.64059e-01,1.96418e-01,8.15564e-02,1.65959e-01,1.93635e-01,7.96713e-02,1.67880e-01,1.90951e-01,7.78693e-02,
1.69824e-01,1.88342e-01,7.61293e-02,1.71791e-01,1.85807e-01,7.44493e-02,1.77828e-01,1.78620e-01,6.97474e-02,1.84077e-01,
1.72013e-01,6.55128e-02,1.86209e-01,1.69931e-01,6.41980e-02,1.88365e-01,1.67906e-01,6.29281e-02,1.90546e-01,1.65935e-01,
6.17016e-02,1.99526e-01,1.58563e-01,5.71995e-02,1.99530e-01,1.58560e-01,5.71979e-02,2.04174e-01,1.55059e-01,5.52398e-02,
2.06538e-01,1.53373e-01,5.43100e-02,2.08930e-01,1.51730e-01,5.34118e-02,2.16272e-01,1.47041e-01,5.08968e-02,2.16331e-01,
1.47006e-01,5.08781e-02,2.21309e-01,1.44121e-01,4.93805e-02,2.23872e-01,1.42712e-01,4.86602e-02,2.26464e-01,1.41338e-01,
4.79637e-02,2.29087e-01,1.39996e-01,4.72912e-02,2.31740e-01,1.38685e-01,4.66409e-02,2.34423e-01,1.37405e-01,4.60120e-02,
2.42661e-01,1.33737e-01,4.42465e-02,2.45471e-01,1.32569e-01,4.36959e-02,2.48313e-01,1.31427e-01,4.31633e-02,2.51189e-01,
1.30310e-01,4.26478e-02,2.51190e-01,1.30309e-01,4.26476e-02,2.54097e-01,1.29175e-01,4.21817e-02,2.60016e-01,1.26993e-01,
4.13092e-02,2.63027e-01,1.25935e-01,4.08938e-02,2.66073e-01,1.24899e-01,4.04914e-02,2.69154e-01,1.23883e-01,4.01022e-02,
2.72270e-01,1.22888e-01,3.97251e-02,2.75423e-01,1.21913e-01,3.93597e-02,2.81838e-01,1.20018e-01,3.86622e-02,2.88403e-01,
1.18195e-01,3.80064e-02,2.91743e-01,1.17309e-01,3.76932e-02,2.95121e-01,1.16444e-01,3.73947e-02,2.98538e-01,1.15593e-01,
3.71048e-02,3.01995e-01,1.14759e-01,3.68232e-02,3.05492e-01,1.13939e-01,3.65497e-02,3.09029e-01,1.13133e-01,3.62838e-02,
3.12608e-01,1.12342e-01,3.60259e-02,3.16228e-01,1.11564e-01,3.57751e-02,3.16230e-01,1.11563e-01,3.57750e-02,3.19889e-01,
1.10766e-01,3.55617e-02,3.23594e-01,1.09980e-01,3.53541e-02,3.27341e-01,1.09208e-01,3.51520e-02,3.31131e-01,1.08448e-01,
3.49554e-02,3.42768e-01,1.06251e-01,3.44071e-02,3.46737e-01,1.05540e-01,3.42332e-02,3.50752e-01,1.04841e-01,3.40635e-02,
3.58922e-01,1.03473e-01,3.37365e-02,3.71535e-01,1.01494e-01,3.32729e-02,3.75837e-01,1.00856e-01,3.31282e-02,3.80189e-01,
1.00227e-01,3.29864e-02,3.84592e-01,9.96059e-02,3.28473e-02,3.89045e-01,9.89932e-02,3.27110e-02,3.93550e-01,9.83886e-02,
3.25771e-02,3.98107e-01,9.77921e-02,3.24460e-02,3.98110e-01,9.77917e-02,3.24459e-02,4.02717e-01,9.71750e-02,3.23443e-02,
4.10064e-01,9.62213e-02,3.21875e-02,4.12098e-01,9.59633e-02,3.21452e-02,4.16869e-01,9.53707e-02,3.20502e-02,4.21697e-01,
9.47851e-02,3.19564e-02,4.31519e-01,9.36345e-02,3.17719e-02,4.36516e-01,9.30692e-02,3.16810e-02,4.41570e-01,9.25106e-02,
3.15913e-02,4.51856e-01,9.14120e-02,3.14141e-02,4.57088e-01,9.08718e-02,3.13267e-02,4.67735e-01,8.98131e-02,3.11577e-02,
4.73151e-01,8.92921e-02,3.10740e-02,4.78630e-01,8.87765e-02,3.09906e-02,4.84172e-01,8.82663e-02,3.09077e-02,4.89779e-01,
8.77614e-02,3.08254e-02,4.95450e-01,8.72617e-02,3.07434e-02,5.01187e-01,8.67669e-02,3.06616e-02,5.01190e-01,8.67667e-02,
3.06616e-02,5.06991e-01,8.62526e-02,3.06038e-02,5.12861e-01,8.57449e-02,3.05473e-02,5.18800e-01,8.52421e-02,3.04902e-02,
5.30884e-01,8.42507e-02,3.03745e-02,5.37032e-01,8.37619e-02,3.03158e-02,5.43250e-01,8.32778e-02,3.02568e-02,5.49541e-01,
8.27981e-02,3.01972e-02,5.55904e-01,8.23227e-02,3.01370e-02,5.62341e-01,8.18515e-02,3.00764e-02,5.68853e-01,8.13859e-02,
3.00164e-02,5.75440e-01,8.09243e-02,2.99559e-02,5.82103e-01,8.04667e-02,2.98947e-02,5.88844e-01,8.00130e-02,2.98330e-02,
5.95662e-01,7.95633e-02,2.97707e-02,6.00000e-01,7.92817e-02,2.97312e-02,6.02560e-01,7.91173e-02,2.97078e-02,6.16595e-01,
7.82365e-02,2.95803e-02,6.23735e-01,7.78025e-02,2.95167e-02,6.30957e-01,7.73721e-02,2.94524e-02,6.30960e-01,7.73719e-02,
2.94524e-02,6.38264e-01,7.69233e-02,2.94069e-02,6.43373e-01,7.66147e-02,2.93746e-02,6.45654e-01,7.64781e-02,2.93601e-02,
6.53131e-01,7.60364e-02,2.93122e-02,6.60694e-01,7.55982e-02,2.92632e-02,6.76083e-01,7.47321e-02,2.91617e-02,6.83912e-01,
7.43050e-02,2.91103e-02,6.99842e-01,7.34606e-02,2.90040e-02,7.07946e-01,7.30432e-02,2.89492e-02,7.08570e-01,7.30114e-02,
2.89449e-02,7.24436e-01,7.22179e-02,2.88366e-02,7.32825e-01,7.18099e-02,2.87788e-02,7.49894e-01,7.10042e-02,2.86616e-02,
7.67362e-01,7.02102e-02,2.85405e-02,7.76247e-01,6.98174e-02,2.84785e-02,7.94328e-01,6.90404e-02,2.83519e-02,7.94330e-01,
6.90403e-02,2.83519e-02,8.03526e-01,6.86357e-02,2.83022e-02,8.41395e-01,6.70479e-02,2.80922e-02,8.51138e-01,6.66579e-02,
2.80365e-02,8.60994e-01,6.62707e-02,2.79795e-02,8.91251e-01,6.51251e-02,2.78018e-02,9.01571e-01,6.47484e-02,2.77403e-02,
9.12011e-01,6.43748e-02,2.76780e-02,9.22571e-01,6.40037e-02,2.76147e-02,9.33254e-01,6.36351e-02,2.75504e-02,9.54993e-01,
6.29053e-02,2.74187e-02,9.66051e-01,6.25441e-02,2.73514e-02,9.77237e-01,6.21853e-02,2.72832e-02,1.00000e+00,6.14758e-02,
2.71449e-02,1.00000e-03,1.05594e+04,1.04815e+04,1.00202e-03,1.04943e+04,1.04170e+04,1.00651e-03,1.03523e+04,1.02763e+04,
1.00800e-03,1.03055e+04,1.02299e+04,1.01373e-03,1.01450e+04,1.00709e+04,1.02051e-03,9.95940e+03,9.88701e+03,1.02329e-03,
9.88459e+03,9.81290e+03,1.02812e-03,9.76519e+03,9.69462e+03,1.03514e-03,9.59520e+03,9.52623e+03,1.03707e-03,9.54916e+03,
9.48062e+03,1.04525e-03,9.35758e+03,9.29083e+03,1.04713e-03,9.31430e+03,9.24797e+03,1.05404e-03,9.15713e+03,9.09226e+03,
1.06639e-03,8.88550e+03,8.82316e+03,1.07114e-03,8.78409e+03,8.72267e+03,1.07152e-03,8.77598e+03,8.71463e+03,1.07584e-03,
8.68326e+03,8.62273e+03,1.07935e-03,8.60908e+03,8.54918e+03,1.08393e-03,8.51361e+03,8.45451e+03,1.08610e-03,8.46878e+03,
8.41006e+03,1.08610e-03,9.56222e+03,9.49517e+03,1.08628e-03,9.55836e+03,9.49135e+03,1.09572e-03,9.35800e+03,9.29268e+03,
1.10118e-03,9.24463e+03,9.18028e+03,1.10738e-03,9.11852e+03,9.05524e+03,1.10918e-03,9.08235e+03,9.01939e+03,1.11502e-03,
8.96641e+03,8.90445e+03,1.12202e-03,8.83023e+03,8.76945e+03,1.12366e-03,8.79867e+03,8.73816e+03,1.13000e-03,8.67857e+03,
8.61910e+03,1.13501e-03,8.58752e+03,8.52885e+03,1.15000e-03,8.33051e+03,8.27408e+03,1.15171e-03,8.30201e+03,8.24583e+03,
1.17490e-03,7.92784e+03,7.87487e+03,1.18300e-03,7.80367e+03,7.75176e+03,1.20226e-03,7.51545e+03,7.46596e+03,1.20500e-03,
7.47578e+03,7.42663e+03,1.21619e-03,7.31491e+03,7.26708e+03,1.21943e-03,7.26927e+03,7.22181e+03,1.24451e-03,6.92919e+03,
6.88450e+03,1.25745e-03,6.76281e+03,6.71945e+03,1.25890e-03,6.74450e+03,6.70128e+03,1.25892e-03,6.74418e+03,6.70097e+03,
1.27350e-03,6.56202e+03,6.52025e+03,1.28825e-03,6.38382e+03,6.34344e+03,1.30317e-03,6.21048e+03,6.17144e+03,1.30563e-03,
6.18251e+03,6.14368e+03,1.31826e-03,6.04188e+03,6.00413e+03,1.37211e-03,5.49067e+03,5.45704e+03,1.38038e-03,5.41240e+03,
5.37934e+03,1.40000e-03,5.23331e+03,5.20155e+03,1.41254e-03,5.12182e+03,5.09085e+03,1.42889e-03,4.98045e+03,4.95048e+03,
1.43994e-03,4.88785e+03,4.85852e+03,1.47911e-03,4.57853e+03,4.55133e+03,1.48233e-03,4.55431e+03,4.52729e+03,1.51356e-03,
4.32893e+03,4.30343e+03,1.56675e-03,3.97807e+03,3.95487e+03,1.58489e-03,3.86524e+03,3.84276e+03,1.58490e-03,3.86520e+03,
3.84272e+03,1.59175e-03,3.82376e+03,3.80154e+03,1.60325e-03,3.75561e+03,3.73383e+03,1.67880e-03,3.34796e+03,3.32869e+03,
1.69824e-03,3.25323e+03,3.23453e+03,1.70067e-03,3.24162e+03,3.22299e+03,1.71791e-03,3.16074e+03,3.14260e+03,1.73780e-03,
3.07095e+03,3.05334e+03,1.77828e-03,2.89794e+03,2.88133e+03,1.80000e-03,2.81074e+03,2.79463e+03,1.81970e-03,2.73481e+03,
2.71914e+03,1.84077e-03,2.65680e+03,2.64156e+03,1.85877e-03,2.59227e+03,2.57739e+03,1.90000e-03,2.45246e+03,2.43834e+03,
1.97242e-03,2.23152e+03,2.21859e+03,1.99526e-03,2.16688e+03,2.15429e+03,1.99530e-03,2.16678e+03,2.15419e+03,2.01837e-03,
2.10373e+03,2.09146e+03,2.02875e-03,2.07609e+03,2.06396e+03,2.04174e-03,2.04220e+03,2.03025e+03,2.06538e-03,1.98249e+03,
1.97085e+03,2.13796e-03,1.81380e+03,1.80301e+03,2.21340e-03,1.65912e+03,1.64910e+03,2.23872e-03,1.61102e+03,1.60122e+03,
2.29087e-03,1.51762e+03,1.50827e+03,2.31240e-03,1.48129e+03,1.47211e+03,2.34423e-03,1.42975e+03,1.42082e+03,2.39883e-03,
1.34661e+03,1.33807e+03,2.42661e-03,1.30688e+03,1.29852e+03,2.46214e-03,1.25846e+03,1.25033e+03,2.51189e-03,1.19477e+03,
1.18692e+03,2.51190e-03,1.19475e+03,1.18691e+03,2.54097e-03,1.15958e+03,1.15190e+03,2.57040e-03,1.12514e+03,1.11761e+03,
2.60016e-03,1.09158e+03,1.08420e+03,2.66073e-03,1.02715e+03,1.02006e+03,2.72270e-03,9.66631e+02,9.59808e+02,2.73120e-03,
9.58728e+02,9.51940e+02,2.85102e-03,8.56278e+02,8.49945e+02,2.91743e-03,8.06033e+02,7.99922e+02,2.95121e-03,7.82063e+02,
7.76058e+02,2.98538e-03,7.58635e+02,7.52732e+02,3.00000e-03,7.48879e+02,7.43018e+02,3.01995e-03,7.35759e+02,7.29954e+02,
3.06703e-03,7.06058e+02,7.00381e+02,3.09030e-03,6.91991e+02,6.86377e+02,3.16228e-03,6.50953e+02,6.45522e+02,3.16230e-03,
6.50941e+02,6.45510e+02,3.34965e-03,5.58730e+02,5.53708e+02,3.38844e-03,5.41771e+02,5.36825e+02,3.41783e-03,5.29337e+02,
5.24446e+02,3.42768e-03,5.25256e+02,5.20383e+02,3.50752e-03,4.93762e+02,4.89034e+02,3.55566e-03,4.76028e+02,4.71381e+02,
3.71363e-03,4.23797e+02,4.19392e+02,3.80189e-03,3.98006e+02,3.93729e+02,3.84592e-03,3.85979e+02,3.81761e+02,3.89045e-03,
3.74163e+02,3.70004e+02,3.93550e-03,3.62674e+02,3.58572e+02,3.98107e-03,3.51543e+02,3.47497e+02,3.98110e-03,3.51536e+02,
3.47490e+02,4.00000e-03,3.47057e+02,3.43034e+02,4.07380e-03,3.30308e+02,3.26369e+02,4.11001e-03,3.22520e+02,3.18621e+02,
4.31519e-03,2.82820e+02,2.79140e+02,4.36516e-03,2.74200e+02,2.70568e+02,4.41570e-03,2.65851e+02,2.62266e+02,4.51856e-03,
2.49729e+02,2.46235e+02,4.56103e-03,2.43452e+02,2.39995e+02,4.57088e-03,2.42025e+02,2.38577e+02,4.62381e-03,2.34560e+02,
2.31158e+02,4.67735e-03,2.27326e+02,2.23969e+02,4.84172e-03,2.06980e+02,2.03753e+02,4.89779e-03,2.00625e+02,1.97441e+02,
4.92359e-03,1.97792e+02,1.94626e+02,4.95450e-03,1.94469e+02,1.91326e+02,5.01187e-03,1.88507e+02,1.85407e+02,5.01190e-03,
1.88504e+02,1.85404e+02,5.06991e-03,1.82694e+02,1.79635e+02,5.12861e-03,1.77032e+02,1.74015e+02,5.18800e-03,1.71536e+02,
1.68558e+02,5.34989e-03,1.57714e+02,1.54840e+02,5.43250e-03,1.51243e+02,1.48421e+02,5.55904e-03,1.42036e+02,1.39290e+02,
5.68853e-03,1.33405e+02,1.30734e+02,5.75117e-03,1.29493e+02,1.26856e+02,5.75440e-03,1.29296e+02,1.26660e+02,5.88844e-03,
1.21399e+02,1.18838e+02,5.95662e-03,1.17616e+02,1.15092e+02,6.24112e-03,1.03461e+02,1.01077e+02,6.30957e-03,1.00405e+02,
9.80543e+01,6.30960e-03,1.00404e+02,9.80532e+01,6.38263e-03,9.72845e+01,9.49679e+01,6.45654e-03,9.42629e+01,9.19802e+01,
6.49494e-03,9.27468e+01,9.04812e+01,6.68344e-03,8.57654e+01,8.35844e+01,6.75817e-03,8.31795e+01,8.10303e+01,6.83912e-03,
8.04960e+01,7.83818e+01,6.98996e-03,7.57888e+01,7.37370e+01,7.00000e-03,7.54889e+01,7.34413e+01,7.20015e-03,6.98336e+01,
6.78669e+01,7.32824e-03,6.65116e+01,6.45971e+01,7.41310e-03,6.44309e+01,6.25496e+01,7.55064e-03,6.12479e+01,5.94183e+01,
7.58578e-03,6.04679e+01,5.86525e+01,7.67362e-03,5.85793e+01,5.67984e+01,7.76247e-03,5.67505e+01,5.50035e+01,7.84106e-03,
5.51862e+01,5.34682e+01,7.94328e-03,5.32337e+01,5.15569e+01,7.94330e-03,5.32334e+01,5.15566e+01,8.07507e-03,5.08478e+01,
4.92220e+01,8.17113e-03,4.91960e+01,4.76095e+01,8.22243e-03,4.83421e+01,4.67776e+01,8.26348e-03,4.76731e+01,4.61259e+01,
8.34555e-03,4.63701e+01,4.48595e+01,8.41395e-03,4.53180e+01,4.38397e+01,8.42032e-03,4.52217e+01,4.37465e+01,8.51138e-03,
4.38699e+01,4.24422e+01,8.52130e-03,4.37260e+01,4.23033e+01,8.57122e-03,4.30074e+01,4.16138e+01,8.61846e-03,4.23382e+01,
4.09752e+01,8.65833e-03,4.17804e+01,4.04466e+01,8.69281e-03,4.13022e+01,3.99967e+01,8.70964e-03,4.10695e+01,3.97798e+01,
8.73159e-03,4.07689e+01,3.94993e+01,8.78729e-03,4.00115e+01,3.87999e+01,8.81049e-03,3.97012e+01,3.85135e+01,8.84589e-03,
3.92344e+01,3.80821e+01,8.87556e-03,3.88548e+01,3.77256e+01,8.89407e-03,3.86244e+01,3.75056e+01,8.91251e-03,3.84005e+01,
3.72880e+01,8.91414e-03,3.83808e+01,3.72688e+01,8.93213e-03,3.81684e+01,3.70585e+01,8.94320e-03,3.80415e+01,3.69299e+01,
8.94320e-03,2.80746e+02,1.80899e+02,8.95613e-03,2.80275e+02,1.80712e+02,8.97749e-03,2.79507e+02,1.80404e+02,9.00077e-03,
2.78679e+02,1.80068e+02,9.01571e-03,2.78153e+02,1.79853e+02,9.03580e-03,2.77450e+02,1.79564e+02,9.05000e-03,2.76955e+02,
1.79360e+02,9.10044e-03,2.73167e+02,1.77301e+02,9.12011e-03,2.71708e+02,1.76507e+02,9.14220e-03,2.70083e+02,1.75652e+02,
9.15000e-03,2.69511e+02,1.75351e+02,9.17069e-03,2.68130e+02,1.74639e+02,9.20019e-03,2.66174e+02,1.73629e+02,9.22562e-03,
2.64502e+02,1.72766e+02,9.22571e-03,2.64496e+02,1.72763e+02,9.25668e-03,2.62263e+02,1.71577e+02,9.28745e-03,2.60068e+02,
1.70409e+02,9.32939e-03,2.57115e+02,1.68834e+02,9.42005e-03,2.50882e+02,1.65493e+02,9.53541e-03,2.43244e+02,1.61367e+02,
9.66041e-03,2.35323e+02,1.57047e+02,9.66051e-03,2.35317e+02,1.57044e+02,9.77237e-03,2.28529e+02,1.53308e+02,9.79719e-03,
2.27060e+02,1.52495e+02,9.88553e-03,2.21936e+02,1.49647e+02,9.97691e-03,2.16804e+02,1.46776e+02,1.00000e-02,2.15533e+02,
1.46062e+02,1.02202e-02,2.03918e+02,1.39479e+02,1.02329e-02,2.03274e+02,1.39112e+02,1.03514e-02,1.97408e+02,1.35746e+02,
1.04713e-02,1.91714e+02,1.32451e+02,1.05032e-02,1.90236e+02,1.31591e+02,1.05925e-02,1.86177e+02,1.29222e+02,1.07152e-02,
1.80801e+02,1.26062e+02,1.08868e-02,1.73376e+02,1.21629e+02,1.10918e-02,1.65043e+02,1.16600e+02,1.13501e-02,1.55313e+02,
1.10652e+02,1.13827e-02,1.54141e+02,1.09932e+02,1.16145e-02,1.46155e+02,1.04998e+02,1.18850e-02,1.37541e+02,9.96073e+01,
1.20625e-02,1.32268e+02,9.62718e+01,1.21619e-02,1.29436e+02,9.44697e+01,1.24451e-02,1.21802e+02,8.95690e+01,1.25890e-02,
1.18162e+02,8.72108e+01,1.25892e-02,1.18156e+02,8.72067e+01,1.27350e-02,1.14620e+02,8.49016e+01,1.28941e-02,1.10927e+02,
8.24802e+01,1.31826e-02,1.04636e+02,7.83207e+01,1.33352e-02,1.01507e+02,7.62347e+01,1.36458e-02,9.55272e+01,7.22160e+01,
1.38038e-02,9.26716e+01,7.02814e+01,1.38389e-02,9.20535e+01,6.98613e+01,1.40000e-02,8.92879e+01,6.79763e+01,1.42889e-02,
8.44845e+01,6.46684e+01,1.46218e-02,7.93760e+01,6.11176e+01,1.49776e-02,7.43717e+01,5.76054e+01,1.51356e-02,7.22883e+01,
5.61336e+01,1.54882e-02,6.79204e+01,5.30279e+01,1.56675e-02,6.58373e+01,5.15370e+01,1.58489e-02,6.38185e+01,5.00860e+01,
1.58490e-02,6.38177e+01,5.00854e+01,1.60324e-02,6.18618e+01,4.86738e+01,1.65036e-02,5.72025e+01,4.52923e+01,1.65959e-02,
5.63465e+01,4.46674e+01,1.67880e-02,5.46184e+01,4.34019e+01,1.73000e-02,5.03569e+01,4.02595e+01,1.77828e-02,4.67465e+01,
3.75720e+01,1.81970e-02,4.38694e+01,3.54089e+01,1.82762e-02,4.33472e+01,3.50148e+01,1.84077e-02,4.24983e+01,3.43729e+01,
1.86209e-02,4.11703e+01,3.33662e+01,1.88365e-02,3.98840e+01,3.23878e+01,1.92752e-02,3.74316e+01,3.05132e+01,1.97242e-02,
3.51290e+01,2.87417e+01,1.99526e-02,3.40321e+01,2.78938e+01,1.99530e-02,3.40303e+01,2.78924e+01,2.04690e-02,3.17193e+01,
2.60975e+01,2.06538e-02,3.09438e+01,2.54928e+01,2.16272e-02,2.72601e+01,2.26011e+01,2.18776e-02,2.64106e+01,2.19296e+01,
2.21309e-02,2.55880e+01,2.12776e+01,2.23872e-02,2.47777e+01,2.06328e+01,2.26464e-02,2.39933e+01,2.00070e+01,2.29115e-02,
2.32252e+01,1.93925e+01,2.31740e-02,2.24971e+01,1.88090e+01,2.48313e-02,1.85509e+01,1.56207e+01,2.51189e-02,1.79650e+01,
1.51438e+01,2.51190e-02,1.79647e+01,1.51435e+01,2.53696e-02,1.74746e+01,1.47438e+01,2.60016e-02,1.63164e+01,1.37968e+01,
2.63027e-02,1.58017e+01,1.33745e+01,2.66073e-02,1.53034e+01,1.29648e+01,2.72270e-02,1.43531e+01,1.21812e+01,2.75423e-02,
1.38942e+01,1.18012e+01,2.78612e-02,1.34501e+01,1.14329e+01,2.81838e-02,1.30206e+01,1.10759e+01,2.82600e-02,1.29220e+01,
1.09938e+01,3.05492e-02,1.03788e+01,8.86625e+00,3.12608e-02,9.72950e+00,8.31891e+00,3.13000e-02,9.69537e+00,8.29008e+00,
3.16228e-02,9.42028e+00,8.05758e+00,3.16230e-02,9.42010e+00,8.05742e+00,3.19889e-02,9.12096e+00,7.80434e+00,3.27341e-02,
8.55117e+00,7.32120e+00,3.34965e-02,8.01783e+00,6.86763e+00,3.46737e-02,7.27205e+00,6.23069e+00,3.59470e-02,6.56920e+00,
5.62796e+00,3.71535e-02,5.98685e+00,5.12699e+00,3.80189e-02,5.61204e+00,4.80361e+00,3.84592e-02,5.43382e+00,4.64957e+00,
3.93550e-02,5.09475e+00,4.35603e+00,3.96241e-02,4.99868e+00,4.27274e+00,3.98107e-02,4.93348e+00,4.21624e+00,3.98110e-02,
4.93339e+00,4.21616e+00,4.02717e-02,4.77732e+00,4.08092e+00,4.12097e-02,4.48020e+00,3.82310e+00,4.46684e-02,3.57440e+00,
3.03343e+00,4.62381e-02,3.24672e+00,2.74655e+00,4.73151e-02,3.04599e+00,2.57053e+00,4.84172e-02,2.85835e+00,2.40576e+00,
4.95450e-02,2.68294e+00,2.25153e+00,5.01187e-02,2.59957e+00,2.17816e+00,5.01190e-02,2.59953e+00,2.17813e+00,5.12861e-02,
2.44082e+00,2.03857e+00,5.30884e-02,2.21971e+00,1.84379e+00,5.37032e-02,2.15087e+00,1.78309e+00,5.43250e-02,2.08432e+00,
1.72440e+00,5.62341e-02,1.89755e+00,1.55953e+00,5.68853e-02,1.83940e+00,1.50817e+00,5.71532e-02,1.81624e+00,1.48770e+00,
5.82103e-02,1.72878e+00,1.41049e+00,6.30957e-02,1.39566e+00,1.11613e+00,6.30960e-02,1.39564e+00,1.11611e+00,6.53131e-02,
1.27506e+00,1.00984e+00,6.68344e-02,1.20055e+00,9.44130e-01,6.83912e-02,1.13088e+00,8.82706e-01,7.07946e-02,1.03488e+00,
7.98102e-01,7.32825e-02,9.48185e-01,7.21759e-01,7.33872e-02,9.44787e-01,7.18767e-01,7.94328e-02,7.76963e-01,5.71397e-01,
7.94330e-02,7.76959e-01,5.71393e-01,8.31764e-02,6.95523e-01,5.00502e-01,8.41395e-02,6.76818e-01,4.84250e-01,8.51138e-02,
6.58718e-01,4.68535e-01,8.60994e-02,6.41216e-01,4.53352e-01,8.88555e-02,5.95966e-01,4.14139e-01,8.91251e-02,5.91825e-01,
4.10561e-01,9.12011e-02,5.61530e-01,3.84410e-01,9.66051e-02,4.94136e-01,3.26454e-01,9.88553e-02,4.70190e-01,3.05949e-01,
1.00000e-01,4.58804e-01,2.96220e-01,1.04713e-01,4.16605e-01,2.60665e-01,1.05925e-01,4.06900e-01,2.52524e-01,1.06843e-01,
3.99838e-01,2.46610e-01,1.08393e-01,3.88399e-01,2.37070e-01,1.12202e-01,3.62816e-01,2.15819e-01,1.13501e-01,3.54832e-01,
2.09214e-01,1.14815e-01,3.47106e-01,2.02835e-01,1.18850e-01,3.25387e-01,1.84984e-01,1.20226e-01,3.18608e-01,1.79438e-01,
1.23027e-01,3.05693e-01,1.68911e-01,1.25890e-01,2.93601e-01,1.59103e-01,1.25893e-01,2.93591e-01,1.59095e-01,1.27942e-01,
2.85449e-01,1.52654e-01,1.30317e-01,2.76593e-01,1.45696e-01,1.31826e-01,2.71274e-01,1.41534e-01,1.36458e-01,2.56291e-01,
1.29888e-01,1.41254e-01,2.42658e-01,1.19405e-01,1.46218e-01,2.30248e-01,1.09970e-01,1.50000e-01,2.21786e-01,1.03604e-01,
1.53109e-01,2.15396e-01,9.88375e-02,1.54882e-01,2.11961e-01,9.62900e-02,1.58489e-01,2.05396e-01,9.14555e-02,1.58490e-01,
2.05395e-01,9.14546e-02,1.60324e-01,2.02202e-01,8.91966e-02,1.62665e-01,1.98315e-01,8.64639e-02,1.65959e-01,1.93162e-01,
8.28775e-02,1.69824e-01,1.87562e-01,7.90205e-02,1.73780e-01,1.82318e-01,7.54625e-02,1.79887e-01,1.74995e-01,7.05685e-02,
1.84077e-01,1.70449e-01,6.75776e-02,1.86209e-01,1.68271e-01,6.61593e-02,1.88365e-01,1.66153e-01,6.47893e-02,1.90546e-01,
1.64093e-01,6.34658e-02,1.92752e-01,1.62090e-01,6.21872e-02,1.99526e-01,1.56398e-01,5.86058e-02,1.99530e-01,1.56395e-01,
5.86040e-02,2.06538e-01,1.51003e-01,5.54723e-02,2.08930e-01,1.49296e-01,5.44980e-02,2.13796e-01,1.46013e-01,5.26473e-02,
2.15379e-01,1.44996e-01,5.20810e-02,2.16272e-01,1.44432e-01,5.17687e-02,2.18776e-01,1.42900e-01,5.09305e-02,2.23872e-01,
1.39948e-01,4.93368e-02,2.26464e-01,1.38527e-01,4.85803e-02,2.29087e-01,1.37140e-01,4.78490e-02,2.34423e-01,1.34464e-01,
4.64578e-02,2.37137e-01,1.33174e-01,4.57963e-02,2.39883e-01,1.31914e-01,4.51565e-02,2.42661e-01,1.30683e-01,4.45377e-02,
2.45471e-01,1.29481e-01,4.39389e-02,2.51189e-01,1.27158e-01,4.27992e-02,2.51190e-01,1.27157e-01,4.27990e-02,2.54097e-01,
1.25995e-01,4.22880e-02,2.63027e-01,1.22680e-01,4.08746e-02,2.66073e-01,1.21622e-01,4.04337e-02,2.68312e-01,1.20866e-01,
4.01216e-02,2.72270e-01,1.19571e-01,3.95932e-02,2.91743e-01,1.13896e-01,3.73666e-02,2.94340e-01,1.13220e-01,3.71140e-02,
2.95121e-01,1.13020e-01,3.70397e-02,2.98538e-01,1.12158e-01,3.67224e-02,3.01995e-01,1.11313e-01,3.64144e-02,3.05492e-01,
1.10483e-01,3.61153e-02,3.09029e-01,1.09669e-01,3.58252e-02,3.16228e-01,1.08085e-01,3.52697e-02,3.16230e-01,1.08085e-01,
3.52696e-02,3.19889e-01,1.07281e-01,3.50327e-02,3.27341e-01,1.05715e-01,3.45781e-02,3.31131e-01,1.04951e-01,3.43601e-02,
3.38844e-01,1.03470e-01,3.39502e-02,3.46737e-01,1.02036e-01,3.35609e-02,3.50752e-01,1.01337e-01,3.33739e-02,3.58922e-01,
9.99693e-02,3.30135e-02,3.63078e-01,9.93011e-02,3.28398e-02,3.71535e-01,9.79945e-02,3.25042e-02,3.75837e-01,9.73590e-02,
3.23456e-02,3.84592e-01,9.61148e-02,3.20383e-02,3.89045e-01,9.55057e-02,3.18893e-02,3.93550e-01,9.49052e-02,3.17437e-02,
3.98107e-01,9.43129e-02,3.16010e-02,3.98110e-01,9.43125e-02,3.16010e-02,4.02717e-01,9.37015e-02,3.14869e-02,4.12098e-01,
9.25025e-02,3.12644e-02,4.16869e-01,9.19173e-02,3.11587e-02,4.23197e-01,9.11625e-02,3.10225e-02,4.26580e-01,9.07682e-02,
3.09515e-02,4.31519e-01,9.02037e-02,3.08501e-02,4.36516e-01,8.96463e-02,3.07501e-02,4.41570e-01,8.90955e-02,3.06514e-02,
4.46684e-01,8.85512e-02,3.05539e-02,4.57088e-01,8.74816e-02,3.03621e-02,4.62381e-01,8.69583e-02,3.02700e-02,4.67735e-01,
8.64408e-02,3.01787e-02,4.73151e-01,8.59289e-02,3.00881e-02,4.78630e-01,8.54226e-02,2.99983e-02,4.89779e-01,8.44267e-02,
2.98210e-02,4.95450e-01,8.39367e-02,2.97332e-02,5.01187e-01,8.34518e-02,2.96461e-02,5.01190e-01,8.34516e-02,2.96461e-02,
5.06991e-01,8.29481e-02,2.95821e-02,5.12861e-01,8.24514e-02,2.95197e-02,5.30884e-01,8.09906e-02,2.93310e-02,5.43250e-01,
8.00404e-02,2.92040e-02,5.49541e-01,7.95721e-02,2.91401e-02,5.55904e-01,7.91082e-02,2.90758e-02,5.62341e-01,7.86487e-02,
2.90113e-02,5.88844e-01,7.68574e-02,2.87547e-02,6.00000e-01,7.61456e-02,2.86484e-02,6.02560e-01,7.59856e-02,2.86241e-02,
6.16595e-01,7.51289e-02,2.84919e-02,6.30957e-01,7.42889e-02,2.83601e-02,6.30960e-01,7.42887e-02,2.83601e-02,6.38264e-01,
7.38520e-02,2.83108e-02,6.43373e-01,7.35515e-02,2.82761e-02,6.45654e-01,7.34186e-02,2.82605e-02,6.53131e-01,7.29888e-02,
2.82093e-02,6.60694e-01,7.25625e-02,2.81571e-02,6.76083e-01,7.17203e-02,2.80498e-02,6.91831e-01,7.08935e-02,2.79407e-02,
7.07946e-01,7.00796e-02,2.78279e-02,7.08570e-01,7.00487e-02,2.78235e-02,7.16143e-01,6.96775e-02,2.77701e-02,7.24436e-01,
6.92784e-02,2.77115e-02,7.32825e-01,6.88824e-02,2.76521e-02,7.41310e-01,6.84903e-02,2.75925e-02,7.49894e-01,6.81010e-02,
2.75321e-02,7.58578e-01,6.77147e-02,2.74709e-02,7.67362e-01,6.73312e-02,2.74088e-02,7.76247e-01,6.69505e-02,2.73458e-02,
7.94328e-01,6.61975e-02,2.72176e-02,7.94330e-01,6.61974e-02,2.72176e-02,8.00000e-01,6.59565e-02,2.71875e-02,8.03526e-01,
6.58081e-02,2.71686e-02,8.12831e-01,6.54222e-02,2.71190e-02,8.51138e-01,6.39060e-02,2.69082e-02,8.60994e-01,6.35337e-02,
2.68526e-02,8.70964e-01,6.31641e-02,2.67959e-02,8.91251e-01,6.24327e-02,2.66794e-02,9.01571e-01,6.20709e-02,2.66196e-02,
9.12011e-01,6.17119e-02,2.65592e-02,9.22571e-01,6.13555e-02,2.64978e-02,9.33254e-01,6.10015e-02,2.64354e-02,9.44061e-01,
6.06499e-02,2.63721e-02,9.54993e-01,6.03007e-02,2.63079e-02,9.66051e-01,5.99540e-02,2.62428e-02,9.77237e-01,5.96096e-02,
2.61768e-02,1.00000e+00,5.89287e-02,2.60434e-02,1.00000e-03,1.54823e+03,1.54731e+03,1.00093e-03,1.54484e+03,1.54394e+03,
1.00405e-03,1.53346e+03,1.53262e+03,1.00602e-03,1.52636e+03,1.52556e+03,1.01158e-03,1.50654e+03,1.50585e+03,1.01284e-03,
1.50211e+03,1.50144e+03,1.01512e-03,1.49411e+03,1.49348e+03,1.01621e-03,1.49033e+03,1.48971e+03,1.01724e-03,1.48674e+03,
1.48614e+03,1.01829e-03,1.48314e+03,1.48254e+03,1.01922e-03,1.47994e+03,1.47935e+03,1.02048e-03,1.47563e+03,1.47505e+03,
1.02152e-03,1.47209e+03,1.47152e+03,1.02274e-03,1.46796e+03,1.46738e+03,1.02391e-03,1.46401e+03,1.46344e+03,1.02523e-03,
1.45957e+03,1.45899e+03,1.02600e-03,1.45699e+03,1.45640e+03,1.02600e-03,3.24222e+03,3.22379e+03,1.02618e-03,3.29319e+03,
3.27425e+03,1.02639e-03,3.37226e+03,3.35253e+03,1.02650e-03,3.41682e+03,3.39664e+03,1.02685e-03,3.54813e+03,3.52663e+03,
1.02720e-03,3.67563e+03,3.65285e+03,1.02765e-03,3.83345e+03,3.80908e+03,1.02776e-03,3.87084e+03,3.84610e+03,1.02800e-03,
3.95259e+03,3.92703e+03,1.02850e-03,4.11605e+03,4.08885e+03,1.02880e-03,4.21104e+03,4.18289e+03,1.02900e-03,4.27342e+03,
4.24464e+03,1.02950e-03,4.42444e+03,4.39417e+03,1.03000e-03,4.56887e+03,4.53713e+03,1.03060e-03,4.73432e+03,4.70095e+03,
1.03075e-03,4.77319e+03,4.73941e+03,1.03110e-03,4.86597e+03,4.83125e+03,1.03180e-03,5.04139e+03,5.00492e+03,1.03188e-03,
5.05942e+03,5.02276e+03,1.03260e-03,5.22928e+03,5.19095e+03,1.03301e-03,5.31886e+03,5.27962e+03,1.03330e-03,5.38313e+03,
5.34323e+03,1.03410e-03,5.54742e+03,5.50591e+03,1.03433e-03,5.58998e+03,5.54804e+03,1.03514e-03,5.74367e+03,5.70016e+03,
1.03584e-03,5.86315e+03,5.81847e+03,1.03600e-03,5.89108e+03,5.84613e+03,1.03710e-03,6.06226e+03,6.01556e+03,1.03850e-03,
6.25322e+03,6.20466e+03,1.04000e-03,6.42702e+03,6.37667e+03,1.04150e-03,6.57200e+03,6.52022e+03,1.04300e-03,6.69106e+03,
6.63804e+03,1.04500e-03,6.81448e+03,6.76026e+03,1.04547e-03,6.83452e+03,6.78008e+03,1.04730e-03,6.91407e+03,6.85877e+03,
1.04858e-03,6.94747e+03,6.89183e+03,1.05000e-03,6.98489e+03,6.92885e+03,1.05050e-03,6.99062e+03,6.93451e+03,1.05050e-03,
7.83175e+03,7.76674e+03,1.05056e-03,7.84019e+03,7.77509e+03,1.05061e-03,7.84864e+03,7.78344e+03,1.05090e-03,7.90644e+03,
7.84066e+03,1.05120e-03,7.96514e+03,7.89875e+03,1.05150e-03,8.02220e+03,7.95523e+03,1.05195e-03,8.10505e+03,8.03721e+03,
1.05240e-03,8.18551e+03,8.11682e+03,1.05285e-03,8.26302e+03,8.19350e+03,1.05300e-03,8.28773e+03,8.21795e+03,1.05330e-03,
8.33490e+03,8.26459e+03,1.05336e-03,8.34325e+03,8.27285e+03,1.05370e-03,8.39470e+03,8.32373e+03,1.05430e-03,8.48100e+03,
8.40915e+03,1.05500e-03,8.57678e+03,8.50394e+03,1.05560e-03,8.65480e+03,8.58114e+03,1.05601e-03,8.70619e+03,8.63199e+03,
1.05610e-03,8.71690e+03,8.64259e+03,1.05650e-03,8.76319e+03,8.68838e+03,1.05690e-03,8.80704e+03,8.73175e+03,1.05770e-03,
8.88715e+03,8.81096e+03,1.05850e-03,8.96147e+03,8.88452e+03,1.05879e-03,8.98567e+03,8.90848e+03,1.05950e-03,9.04637e+03,
8.96855e+03,1.06040e-03,9.11573e+03,9.03718e+03,1.06145e-03,9.18856e+03,9.10923e+03,1.06150e-03,9.19182e+03,9.11245e+03,
1.06270e-03,9.25684e+03,9.17673e+03,1.06400e-03,9.31576e+03,9.23506e+03,1.06421e-03,9.32343e+03,9.24264e+03,1.06550e-03,
9.37033e+03,9.28906e+03,1.06700e-03,9.41185e+03,9.33012e+03,1.06825e-03,9.43668e+03,9.35465e+03,1.06850e-03,9.44169e+03,
9.35961e+03,1.07050e-03,9.46576e+03,9.38348e+03,1.07148e-03,9.46977e+03,9.38744e+03,1.07270e-03,9.47472e+03,9.39236e+03,
1.07500e-03,9.46876e+03,9.38645e+03,1.07582e-03,9.46168e+03,9.37943e+03,1.07800e-03,9.44283e+03,9.36075e+03,1.08012e-03,
9.41349e+03,9.33176e+03,1.08150e-03,9.39440e+03,9.31289e+03,1.08393e-03,9.35227e+03,9.27123e+03,1.08500e-03,9.33368e+03,
9.25285e+03,1.08956e-03,9.24237e+03,9.16253e+03,1.09000e-03,9.23360e+03,9.15385e+03,1.09400e-03,9.15824e+03,9.07933e+03,
1.09537e-03,9.13189e+03,9.05327e+03,1.09648e-03,9.11055e+03,9.03216e+03,1.10068e-03,9.03041e+03,8.95291e+03,1.10844e-03,
8.88525e+03,8.80936e+03,1.11300e-03,8.80135e+03,8.72640e+03,1.11599e-03,8.74846e+03,8.67409e+03,1.12000e-03,8.67835e+03,
8.60477e+03,1.12505e-03,8.58236e+03,8.50982e+03,1.13478e-03,8.40167e+03,8.33110e+03,1.13501e-03,8.39738e+03,8.32687e+03,
1.14300e-03,8.25303e+03,8.18409e+03,1.14400e-03,8.23433e+03,8.16559e+03,1.14500e-03,8.21573e+03,8.14719e+03,1.14815e-03,
8.15611e+03,8.08822e+03,1.15777e-03,7.97795e+03,7.91199e+03,1.16377e-03,7.86946e+03,7.80466e+03,1.16500e-03,7.84740e+03,
7.78283e+03,1.16808e-03,7.79189e+03,7.72790e+03,1.17322e-03,7.70057e+03,7.63751e+03,1.17490e-03,7.67099e+03,7.60822e+03,
1.17500e-03,7.66920e+03,7.60645e+03,1.17963e-03,7.59194e+03,7.52996e+03,1.18440e-03,7.51362e+03,7.45241e+03,1.18440e-03,
8.53934e+03,8.46893e+03,1.19305e-03,8.38836e+03,8.31946e+03,1.19807e-03,8.30261e+03,8.23456e+03,1.20226e-03,8.23180e+03,
8.16446e+03,1.20372e-03,8.20783e+03,8.14074e+03,1.20925e-03,8.11816e+03,8.05198e+03,1.21619e-03,8.00739e+03,7.94234e+03,
1.22033e-03,7.94233e+03,7.87794e+03,1.23026e-03,7.78956e+03,7.72673e+03,1.24083e-03,7.63135e+03,7.57013e+03,1.25129e-03,
7.47919e+03,7.41953e+03,1.25890e-03,7.37124e+03,7.31266e+03,1.25892e-03,7.37089e+03,7.31231e+03,1.26933e-03,7.22689e+03,
7.16976e+03,1.27350e-03,7.17016e+03,7.11359e+03,1.28208e-03,7.05573e+03,7.00031e+03,1.30317e-03,6.78511e+03,6.73236e+03,
1.31740e-03,6.61226e+03,6.56119e+03,1.35000e-03,6.23907e+03,6.19160e+03,1.35617e-03,6.17180e+03,6.12497e+03,1.36458e-03,
6.08183e+03,6.03585e+03,1.38038e-03,5.91781e+03,5.87337e+03,1.41567e-03,5.57206e+03,5.53080e+03,1.42889e-03,5.44988e+03,
5.40973e+03,1.45000e-03,5.26272e+03,5.22424e+03,1.46218e-03,5.15753e+03,5.11998e+03,1.47058e-03,5.08629e+03,5.04936e+03,
1.50000e-03,4.84761e+03,4.81276e+03,1.51356e-03,4.74296e+03,4.70901e+03,1.53550e-03,4.58027e+03,4.54769e+03,1.54882e-03,
4.48533e+03,4.45355e+03,1.58489e-03,4.24202e+03,4.21226e+03,1.58490e-03,4.24198e+03,4.21222e+03,1.60325e-03,4.12544e+03,
4.09663e+03,1.61000e-03,4.08369e+03,4.05522e+03,1.62181e-03,4.01187e+03,3.98397e+03,1.64059e-03,3.89928e+03,3.87227e+03,
1.67000e-03,3.73169e+03,3.70600e+03,1.69824e-03,3.57972e+03,3.55520e+03,1.73281e-03,3.40533e+03,3.38213e+03,1.73780e-03,
3.38112e+03,3.35811e+03,1.75792e-03,3.28606e+03,3.26375e+03,1.77828e-03,3.19372e+03,3.17209e+03,1.81708e-03,3.02409e+03,
3.00369e+03,1.84077e-03,2.92667e+03,2.90697e+03,1.88365e-03,2.76150e+03,2.74297e+03,1.90546e-03,2.68255e+03,2.66457e+03,
1.99414e-03,2.39238e+03,2.37636e+03,1.99526e-03,2.38900e+03,2.37300e+03,1.99530e-03,2.38889e+03,2.37289e+03,2.00000e-03,
2.37471e+03,2.35881e+03,2.01837e-03,2.32042e+03,2.30488e+03,2.08930e-03,2.12644e+03,2.11216e+03,2.11349e-03,2.06555e+03,
2.05165e+03,2.13796e-03,2.00544e+03,1.99191e+03,2.16272e-03,1.94707e+03,1.93391e+03,2.18776e-03,1.89041e+03,1.87761e+03,
2.23872e-03,1.78172e+03,1.76958e+03,2.26464e-03,1.72981e+03,1.71798e+03,2.31740e-03,1.63052e+03,1.61929e+03,2.36116e-03,
1.55311e+03,1.54233e+03,2.37137e-03,1.53577e+03,1.52509e+03,2.45471e-03,1.40407e+03,1.39416e+03,2.51189e-03,1.32276e+03,
1.31331e+03,2.51190e-03,1.32274e+03,1.31329e+03,2.54097e-03,1.28389e+03,1.27466e+03,2.57040e-03,1.24599e+03,1.23697e+03,
2.66073e-03,1.13899e+03,1.13056e+03,2.69154e-03,1.10547e+03,1.09722e+03,2.71488e-03,1.08087e+03,1.07275e+03,2.72270e-03,
1.07279e+03,1.06471e+03,2.75423e-03,1.04079e+03,1.03289e+03,2.80000e-03,9.96647e+02,9.88980e+02,2.81838e-03,9.79650e+02,
9.72073e+02,2.91743e-03,8.94371e+02,8.87245e+02,3.05492e-03,7.92365e+02,7.85768e+02,3.12608e-03,7.45450e+02,7.39099e+02,
3.16228e-03,7.23078e+02,7.16844e+02,3.16230e-03,7.23065e+02,7.16830e+02,3.23594e-03,6.80337e+02,6.74324e+02,3.31131e-03,
6.39963e+02,6.34158e+02,3.38656e-03,6.02929e+02,5.97312e+02,3.46737e-03,5.66370e+02,5.60946e+02,3.50000e-03,5.52501e+02,
5.47150e+02,3.50752e-03,5.49359e+02,5.44024e+02,3.54813e-03,5.32678e+02,5.27431e+02,3.65000e-03,4.93826e+02,4.88781e+02,
3.71113e-03,4.72290e+02,4.67357e+02,3.71535e-03,4.70851e+02,4.65926e+02,3.75837e-03,4.56536e+02,4.51689e+02,3.89045e-03,
4.16211e+02,4.11582e+02,3.93550e-03,4.03593e+02,3.99033e+02,3.98107e-03,3.91376e+02,3.86883e+02,3.98110e-03,3.91369e+02,
3.86876e+02,4.02717e-03,3.79531e+02,3.75103e+02,4.03478e-03,3.77624e+02,3.73206e+02,4.07380e-03,3.68049e+02,3.63686e+02,
4.16869e-03,3.45916e+02,3.41679e+02,4.26579e-03,3.25017e+02,3.20898e+02,4.36398e-03,3.05634e+02,3.01627e+02,4.36516e-03,
3.05411e+02,3.01406e+02,4.46684e-03,2.87021e+02,2.83129e+02,4.57088e-03,2.69775e+02,2.65991e+02,4.62381e-03,2.61544e+02,
2.57812e+02,4.67735e-03,2.53547e+02,2.49866e+02,4.76650e-03,2.40905e+02,2.37304e+02,4.80000e-03,2.36376e+02,2.32806e+02,
4.84172e-03,2.30869e+02,2.27337e+02,5.01187e-03,2.10184e+02,2.06794e+02,5.01190e-03,2.10180e+02,2.06791e+02,5.06991e-03,
2.03711e+02,2.00367e+02,5.15609e-03,1.94620e+02,1.91341e+02,5.18800e-03,1.91394e+02,1.88139e+02,5.30884e-03,1.79834e+02,
1.76669e+02,5.37032e-03,1.74310e+02,1.71188e+02,5.43250e-03,1.68924e+02,1.65846e+02,5.49541e-03,1.63676e+02,1.60639e+02,
5.59114e-03,1.56125e+02,1.53149e+02,5.75440e-03,1.44306e+02,1.41432e+02,5.82097e-03,1.39851e+02,1.37016e+02,5.88844e-03,
1.35525e+02,1.32731e+02,6.16595e-03,1.19571e+02,1.16931e+02,6.23735e-03,1.15885e+02,1.13282e+02,6.30957e-03,1.12266e+02,
1.09699e+02,6.30960e-03,1.12265e+02,1.09698e+02,6.53131e-03,1.02085e+02,9.96296e+01,6.68344e-03,9.58336e+01,9.34493e+01,
6.81745e-03,9.07624e+01,8.84372e+01,6.91831e-03,8.71835e+01,8.49033e+01,7.07946e-03,8.18682e+01,7.96563e+01,7.07987e-03,
8.18551e+01,7.96434e+01,7.16143e-03,7.93365e+01,7.71592e+01,7.24436e-03,7.68597e+01,7.47164e+01,7.33720e-03,7.41999e+01,
7.20934e+01,7.58237e-03,6.77517e+01,6.57405e+01,7.58578e-03,6.76674e+01,6.56576e+01,7.67362e-03,6.55507e+01,6.35747e+01,
7.80443e-03,6.25692e+01,6.06416e+01,7.94328e-03,5.96009e+01,5.77257e+01,7.94330e-03,5.96005e+01,5.77254e+01,8.12830e-03,
5.59375e+01,5.41285e+01,8.17879e-03,5.49941e+01,5.32025e+01,8.23037e-03,5.40511e+01,5.22787e+01,8.31764e-03,5.25066e+01,
5.07658e+01,8.41395e-03,5.08542e+01,4.91473e+01,8.44124e-03,5.03988e+01,4.87013e+01,8.51138e-03,4.92510e+01,4.75798e+01,
8.69206e-03,4.64460e+01,4.48398e+01,8.81049e-03,4.47187e+01,4.31586e+01,8.89134e-03,4.35935e+01,4.20638e+01,9.03725e-03,
4.16503e+01,4.01814e+01,9.10513e-03,4.07826e+01,3.93444e+01,9.16539e-03,4.00301e+01,3.86212e+01,9.21889e-03,3.93747e+01,
3.79941e+01,9.27026e-03,3.87555e+01,3.74049e+01,9.31409e-03,3.82336e+01,3.69118e+01,9.35141e-03,3.77930e+01,3.64989e+01,
9.39113e-03,3.73274e+01,3.60664e+01,9.45200e-03,3.66210e+01,3.54169e+01,9.51967e-03,3.58558e+01,3.47133e+01,9.54963e-03,
3.55295e+01,3.44079e+01,9.54993e-03,3.55263e+01,3.44048e+01,9.57124e-03,3.53015e+01,3.41905e+01,9.59113e-03,3.50971e+01,
3.39921e+01,9.61326e-03,3.48764e+01,3.37732e+01,9.62240e-03,3.47881e+01,3.36834e+01,9.62240e-03,2.56619e+02,1.59051e+02,
9.64082e-03,2.55418e+02,1.58478e+02,9.66051e-03,2.54149e+02,1.57869e+02,9.66892e-03,2.53609e+02,1.57609e+02,9.69000e-03,
2.52269e+02,1.56961e+02,9.70709e-03,2.51189e+02,1.56438e+02,9.77237e-03,2.47136e+02,1.54458e+02,9.79348e-03,2.45846e+02,
1.53825e+02,9.83073e-03,2.43589e+02,1.52715e+02,9.87396e-03,2.41004e+02,1.51440e+02,9.90459e-03,2.39191e+02,1.50545e+02,
9.96384e-03,2.35733e+02,1.48833e+02,1.00000e-02,2.33654e+02,1.47800e+02,1.00421e-02,2.31266e+02,1.46610e+02,1.01158e-02,
2.27157e+02,1.44554e+02,1.01466e-02,2.25472e+02,1.43706e+02,1.02329e-02,2.20834e+02,1.41363e+02,1.02673e-02,2.18945e+02,
1.40393e+02,1.04091e-02,2.11375e+02,1.36476e+02,1.06391e-02,1.99839e+02,1.30418e+02,1.07152e-02,1.96217e+02,1.28494e+02,
1.09277e-02,1.86573e+02,1.23312e+02,1.10918e-02,1.79570e+02,1.19498e+02,1.12202e-02,1.74343e+02,1.16621e+02,1.13360e-02,
1.69803e+02,1.14101e+02,1.13501e-02,1.69262e+02,1.13799e+02,1.15000e-02,1.63651e+02,1.10655e+02,1.17490e-02,1.54888e+02,
1.05682e+02,1.18205e-02,1.52424e+02,1.04269e+02,1.23193e-02,1.36660e+02,9.50823e+01,1.25890e-02,1.29060e+02,9.05588e+01,
1.25892e-02,1.29053e+02,9.05548e+01,1.28825e-02,1.21439e+02,8.59567e+01,1.30317e-02,1.17805e+02,8.37384e+01,1.30884e-02,
1.16461e+02,8.29138e+01,1.33352e-02,1.10852e+02,7.94502e+01,1.35000e-02,1.07313e+02,7.72448e+01,1.36458e-02,1.04310e+02,
7.53609e+01,1.41181e-02,9.53450e+01,6.96659e+01,1.41254e-02,9.52156e+01,6.95830e+01,1.42889e-02,9.23646e+01,6.77494e+01,
1.53109e-02,7.68761e+01,5.75759e+01,1.54882e-02,7.45147e+01,5.59892e+01,1.55231e-02,7.40616e+01,5.56837e+01,1.56675e-02,
7.22261e+01,5.44436e+01,1.58489e-02,7.00078e+01,5.29378e+01,1.58490e-02,7.00070e+01,5.29373e+01,1.60324e-02,6.78576e+01,
5.14709e+01,1.69824e-02,5.80626e+01,4.46911e+01,1.70846e-02,5.71280e+01,4.40369e+01,1.77828e-02,5.12622e+01,3.98946e+01,
1.79887e-02,4.96897e+01,3.87727e+01,1.84077e-02,4.66894e+01,3.66185e+01,1.86209e-02,4.52583e+01,3.55845e+01,1.88365e-02,
4.38715e+01,3.45783e+01,1.89529e-02,4.31470e+01,3.40510e+01,1.90546e-02,4.25272e+01,3.35992e+01,1.99526e-02,3.74537e+01,
2.98611e+01,1.99530e-02,3.74518e+01,2.98596e+01,2.04174e-02,3.51503e+01,2.81448e+01,2.06538e-02,3.40531e+01,2.73229e+01,
2.10053e-02,3.25055e+01,2.61584e+01,2.11349e-02,3.19590e+01,2.57459e+01,2.13796e-02,3.09610e+01,2.49908e+01,2.16272e-02,
2.99944e+01,2.42570e+01,2.18776e-02,2.90583e+01,2.35439e+01,2.23872e-02,2.72738e+01,2.21781e+01,2.26464e-02,2.64236e+01,
2.15243e+01,2.29703e-02,2.54117e+01,2.07435e+01,2.30000e-02,2.53216e+01,2.06739e+01,2.40000e-02,2.25260e+01,1.85013e+01,
2.42661e-02,2.18421e+01,1.79655e+01,2.48313e-02,2.04797e+01,1.68935e+01,2.51189e-02,1.98312e+01,1.63812e+01,2.51190e-02,
1.98309e+01,1.63810e+01,2.52830e-02,1.94735e+01,1.60981e+01,2.54097e-02,1.92032e+01,1.58840e+01,2.57040e-02,1.85950e+01,
1.54015e+01,2.60016e-02,1.80064e+01,1.49333e+01,2.75423e-02,1.53350e+01,1.27930e+01,2.80000e-02,1.46469e+01,1.22379e+01,
2.81142e-02,1.44819e+01,1.21045e+01,2.85102e-02,1.39287e+01,1.16568e+01,2.95121e-02,1.26516e+01,1.06183e+01,3.00000e-02,
1.20877e+01,1.01575e+01,3.01995e-02,1.18638e+01,9.97408e+00,3.12608e-02,1.07639e+01,9.06938e+00,3.16228e-02,1.04209e+01,
8.78612e+00,3.16230e-02,1.04207e+01,8.78595e+00,3.19889e-02,1.00889e+01,8.51157e+00,3.32680e-02,9.03741e+00,7.63853e+00,
3.38844e-02,8.58413e+00,7.26060e+00,3.42768e-02,8.31155e+00,7.03282e+00,3.46737e-02,8.04782e+00,6.81207e+00,3.50752e-02,
7.79265e+00,6.59813e+00,3.58922e-02,7.30695e+00,6.18993e+00,3.67282e-02,6.85228e+00,5.80662e+00,3.69098e-02,6.75764e+00,
5.72663e+00,3.80189e-02,6.21660e+00,5.26866e+00,3.93550e-02,5.64159e+00,4.78004e+00,3.98107e-02,5.46240e+00,4.62736e+00,
3.98110e-02,5.46229e+00,4.62727e+00,4.02717e-02,5.28897e+00,4.47953e+00,4.04843e-02,5.21149e+00,4.41341e+00,4.21696e-02,
4.64943e+00,3.93301e+00,4.31519e-02,4.36031e+00,3.68510e+00,4.41570e-02,4.08985e+00,3.45268e+00,4.51856e-02,3.83685e+00,
3.23481e+00,4.84172e-02,3.16513e+00,2.65377e+00,5.01187e-02,2.87669e+00,2.40326e+00,5.01190e-02,2.87665e+00,2.40322e+00,
5.06991e-02,2.78674e+00,2.32513e+00,5.12861e-02,2.69978e+00,2.24954e+00,5.30884e-02,2.45576e+00,2.03721e+00,5.55904e-02,
2.16648e+00,1.78495e+00,5.62341e-02,2.10004e+00,1.72694e+00,5.75440e-02,1.97250e+00,1.61541e+00,5.87732e-02,1.86280e+00,
1.51940e+00,5.88844e-02,1.85332e+00,1.51110e+00,6.09537e-02,1.68875e+00,1.36706e+00,6.16595e-02,1.63751e+00,1.32218e+00,
6.23735e-02,1.58799e+00,1.27878e+00,6.30957e-02,1.54011e+00,1.23681e+00,6.30960e-02,1.54009e+00,1.23680e+00,6.53131e-02,
1.40554e+00,1.11915e+00,6.99842e-02,1.17410e+00,9.16683e-01,7.16143e-02,1.10679e+00,8.57804e-01,7.24436e-02,1.07454e+00,
8.29574e-01,7.76247e-02,9.02304e-01,6.78881e-01,7.85236e-02,8.76856e-01,6.56634e-01,7.85557e-02,8.75967e-01,6.55857e-01,
7.94328e-02,8.52225e-01,6.35134e-01,7.94330e-02,8.52220e-01,6.35130e-01,8.51138e-02,7.20206e-01,5.20692e-01,8.70964e-02,
6.81806e-01,4.87485e-01,8.91251e-02,6.45903e-01,4.56483e-01,9.12011e-02,6.12331e-01,4.27537e-01,9.22571e-02,5.96370e-01,
4.13793e-01,9.54993e-02,5.51540e-01,3.75254e-01,9.66051e-02,5.37514e-01,3.63215e-01,9.77237e-02,5.23952e-01,3.51585e-01,
9.88720e-02,5.10648e-01,3.40189e-01,1.00000e-01,4.98132e-01,3.29498e-01,1.01158e-01,4.85765e-01,3.19049e-01,1.03514e-01,
4.62230e-01,2.99207e-01,1.09648e-01,4.09785e-01,2.55224e-01,1.16145e-01,3.65315e-01,2.18250e-01,1.16457e-01,3.63412e-01,
2.16676e-01,1.17490e-01,3.57251e-01,2.11594e-01,1.18850e-01,3.49443e-01,2.05167e-01,1.20226e-01,3.41886e-01,1.98959e-01,
1.21619e-01,3.34572e-01,1.92963e-01,1.25890e-01,3.14018e-01,1.76187e-01,1.25893e-01,3.14007e-01,1.76178e-01,1.31826e-01,
2.89233e-01,1.56487e-01,1.34896e-01,2.77984e-01,1.47625e-01,1.39637e-01,2.62394e-01,1.35440e-01,1.42889e-01,2.52791e-01,
1.27996e-01,1.44544e-01,2.48204e-01,1.24464e-01,1.53109e-01,2.27295e-01,1.08542e-01,1.56675e-01,2.19799e-01,1.02911e-01,
1.58489e-01,2.16221e-01,1.00240e-01,1.58490e-01,2.16219e-01,1.00239e-01,1.64059e-01,2.05942e-01,9.28630e-02,1.67880e-01,
1.99586e-01,8.83581e-02,1.69824e-01,1.96569e-01,8.62419e-02,1.73780e-01,1.90792e-01,8.22229e-02,1.75792e-01,1.88028e-01,
8.03152e-02,1.77828e-01,1.85343e-01,7.84727e-02,1.81970e-01,1.80199e-01,7.49731e-02,1.88365e-01,1.73015e-01,7.01568e-02,
1.89937e-01,1.71377e-01,6.90715e-02,1.90546e-01,1.70753e-01,6.86602e-02,1.92752e-01,1.68551e-01,6.72143e-02,1.94984e-01,
1.66409e-01,6.58174e-02,1.99526e-01,1.62301e-01,6.31635e-02,1.99530e-01,1.62298e-01,6.31615e-02,2.06538e-01,1.56399e-01,
5.96053e-02,2.08930e-01,1.54534e-01,5.84986e-02,2.16272e-01,1.49226e-01,5.53979e-02,2.18776e-01,1.47560e-01,5.44462e-02,
2.26464e-01,1.42809e-01,5.17761e-02,2.29087e-01,1.41304e-01,5.09442e-02,2.37137e-01,1.37007e-01,4.86126e-02,2.42661e-01,
1.34312e-01,4.71827e-02,2.45471e-01,1.33013e-01,4.65025e-02,2.48313e-01,1.31744e-01,4.58444e-02,2.51189e-01,1.30504e-01,
4.52076e-02,2.51190e-01,1.30504e-01,4.52073e-02,2.54097e-01,1.29253e-01,4.46227e-02,2.59053e-01,1.27232e-01,4.36988e-02,
2.66073e-01,1.24550e-01,4.24997e-02,2.69154e-01,1.23437e-01,4.20103e-02,2.72270e-01,1.22348e-01,4.15372e-02,2.78612e-01,
1.20237e-01,4.06346e-02,2.91743e-01,1.16272e-01,3.89907e-02,2.95121e-01,1.15336e-01,3.86169e-02,2.98538e-01,1.14419e-01,
3.82541e-02,3.01995e-01,1.13519e-01,3.79021e-02,3.12608e-01,1.10922e-01,3.69063e-02,3.16228e-01,1.10088e-01,3.65939e-02,
3.16230e-01,1.10088e-01,3.65937e-02,3.19889e-01,1.09238e-01,3.63194e-02,3.23594e-01,1.08402e-01,3.60527e-02,3.31131e-01,
1.06774e-01,3.55416e-02,3.46737e-01,1.03700e-01,3.46187e-02,3.54813e-01,1.02238e-01,3.41923e-02,3.63078e-01,1.00821e-01,
3.37878e-02,3.67282e-01,1.00129e-01,3.35930e-02,3.71535e-01,9.94479e-02,3.34028e-02,3.75837e-01,9.87810e-02,3.32210e-02,
3.84592e-01,9.74767e-02,3.28694e-02,3.89045e-01,9.68387e-02,3.26993e-02,3.98107e-01,9.55901e-02,3.23700e-02,3.98110e-01,
9.55897e-02,3.23699e-02,4.00000e-01,9.53261e-02,3.23147e-02,4.02717e-01,9.49521e-02,3.22367e-02,4.07380e-01,9.43229e-02,
3.21060e-02,4.12098e-01,9.37023e-02,3.19778e-02,4.26580e-01,9.18982e-02,3.16153e-02,4.31519e-01,9.13122e-02,3.14982e-02,
4.36516e-01,9.07336e-02,3.13829e-02,4.46684e-01,8.95978e-02,3.11573e-02,4.51856e-01,8.90406e-02,3.10471e-02,4.57088e-01,
8.84901e-02,3.09384e-02,4.67735e-01,8.74137e-02,3.07298e-02,4.73151e-01,8.68847e-02,3.06273e-02,4.95450e-01,8.48277e-02,
3.02272e-02,5.01187e-01,8.43278e-02,3.01297e-02,5.01190e-01,8.43275e-02,3.01296e-02,5.06991e-01,8.38094e-02,3.00556e-02,
5.12861e-01,8.32985e-02,2.99837e-02,5.18800e-01,8.27930e-02,2.99118e-02,5.26202e-01,8.21780e-02,2.98234e-02,5.49541e-01,
8.03394e-02,2.95518e-02,5.55904e-01,7.98633e-02,2.94797e-02,5.62341e-01,7.93919e-02,2.94075e-02,5.68853e-01,7.89265e-02,
2.93368e-02,5.95662e-01,7.71080e-02,2.90515e-02,6.02560e-01,7.66637e-02,2.89796e-02,6.16595e-01,7.57873e-02,2.88352e-02,
6.23735e-01,7.53563e-02,2.87639e-02,6.30957e-01,7.49289e-02,2.86922e-02,6.30960e-01,7.49288e-02,2.86922e-02,6.45654e-01,
7.40405e-02,2.85821e-02,6.53131e-01,7.36020e-02,2.85258e-02,6.60694e-01,7.31671e-02,2.84685e-02,6.76083e-01,7.23086e-02,
2.83519e-02,6.83912e-01,7.18858e-02,2.82934e-02,6.91831e-01,7.14664e-02,2.82340e-02,6.99842e-01,7.10504e-02,2.81738e-02,
7.07946e-01,7.06377e-02,2.81128e-02,7.16143e-01,7.02283e-02,2.80510e-02,7.24436e-01,6.98222e-02,2.79884e-02,7.32825e-01,
6.94193e-02,2.79251e-02,7.49894e-01,6.86248e-02,2.77980e-02,7.58578e-01,6.82320e-02,2.77332e-02,7.67362e-01,6.78423e-02,
2.76677e-02,7.85236e-01,6.70715e-02,2.75344e-02,7.94328e-01,6.66905e-02,2.74667e-02,7.94330e-01,6.66904e-02,2.74667e-02,
8.00000e-01,6.64460e-02,2.74347e-02,8.03526e-01,6.62954e-02,2.74147e-02,8.12831e-01,6.59039e-02,2.73622e-02,8.22243e-01,
6.55154e-02,2.73084e-02,8.51138e-01,6.43667e-02,2.71404e-02,8.60994e-01,6.39893e-02,2.70822e-02,8.70964e-01,6.36147e-02,
2.70230e-02,8.91251e-01,6.28737e-02,2.69015e-02,9.01571e-01,6.25071e-02,2.68393e-02,9.12011e-01,6.21437e-02,2.67766e-02,
9.16635e-01,6.19848e-02,2.67488e-02,9.22571e-01,6.17827e-02,2.67130e-02,9.33254e-01,6.14242e-02,2.66484e-02,9.44061e-01,
6.10682e-02,2.65829e-02,9.54993e-01,6.07147e-02,2.65166e-02,9.66051e-01,6.03638e-02,2.64494e-02,9.77237e-01,6.00152e-02,
2.63814e-02,1.00000e+00,5.93263e-02,2.62441e-02,1.00000e-03,1.69340e+03,1.69145e+03,1.00290e-03,1.68185e+03,1.67991e+03,
1.02113e-03,1.61159e+03,1.60977e+03,1.02329e-03,1.60354e+03,1.60173e+03,1.03603e-03,1.55743e+03,1.55571e+03,1.04986e-03,
1.50942e+03,1.50782e+03,1.05925e-03,1.47800e+03,1.47649e+03,1.06168e-03,1.47002e+03,1.46853e+03,1.07152e-03,1.43835e+03,
1.43696e+03,1.07169e-03,1.43780e+03,1.43642e+03,1.08102e-03,1.40854e+03,1.40727e+03,1.08823e-03,1.38648e+03,1.38532e+03,
1.09382e-03,1.36970e+03,1.36864e+03,1.09648e-03,1.36181e+03,1.36080e+03,1.09745e-03,1.35892e+03,1.35793e+03,1.09998e-03,
1.35143e+03,1.35048e+03,1.10523e-03,1.33610e+03,1.33525e+03,1.10899e-03,1.32526e+03,1.32448e+03,1.11135e-03,1.31853e+03,
1.31778e+03,1.11358e-03,1.31224e+03,1.31152e+03,1.11481e-03,1.30876e+03,1.30805e+03,1.11615e-03,1.30503e+03,1.30433e+03,
1.11742e-03,1.30149e+03,1.30080e+03,1.11911e-03,1.29680e+03,1.29612e+03,1.12075e-03,1.29227e+03,1.29158e+03,1.12200e-03,
1.28885e+03,1.28817e+03,1.12200e-03,2.67073e+03,2.65433e+03,1.12202e-03,2.67195e+03,2.65552e+03,1.12225e-03,2.72609e+03,
2.70905e+03,1.12250e-03,2.82021e+03,2.80210e+03,1.12251e-03,2.82204e+03,2.80391e+03,1.12280e-03,2.93208e+03,2.91269e+03,
1.12310e-03,3.04295e+03,3.02229e+03,1.12340e-03,3.15307e+03,3.13116e+03,1.12380e-03,3.29648e+03,3.27293e+03,1.12399e-03,
3.36388e+03,3.33957e+03,1.12420e-03,3.43769e+03,3.41254e+03,1.12460e-03,3.57484e+03,3.54812e+03,1.12500e-03,3.70808e+03,
3.67984e+03,1.12540e-03,3.83676e+03,3.80706e+03,1.12550e-03,3.86920e+03,3.83913e+03,1.12600e-03,4.02361e+03,3.99179e+03,
1.12650e-03,4.17039e+03,4.13692e+03,1.12655e-03,4.18368e+03,4.15005e+03,1.12690e-03,4.28240e+03,4.24763e+03,1.12710e-03,
4.28484e+03,4.25004e+03,1.12791e-03,4.44708e+03,4.41045e+03,1.12810e-03,4.48651e+03,4.44944e+03,1.12830e-03,4.52069e+03,
4.48320e+03,1.12960e-03,4.68961e+03,4.65020e+03,1.13000e-03,4.74228e+03,4.70226e+03,1.13117e-03,4.87657e+03,4.83502e+03,
1.13150e-03,4.91495e+03,4.87297e+03,1.13340e-03,5.06943e+03,5.02569e+03,1.13344e-03,5.07165e+03,5.02788e+03,1.13501e-03,
5.16177e+03,5.11698e+03,1.13600e-03,5.21960e+03,5.17417e+03,1.13613e-03,5.22600e+03,5.18049e+03,1.13900e-03,5.37016e+03,
5.32295e+03,1.14230e-03,5.48729e+03,5.43872e+03,1.14300e-03,5.50115e+03,5.45240e+03,1.14413e-03,5.54148e+03,5.49226e+03,
1.14600e-03,5.60877e+03,5.55877e+03,1.14841e-03,5.64056e+03,5.59016e+03,1.15040e-03,5.66699e+03,5.61625e+03,1.15040e-03,
6.32391e+03,6.26524e+03,1.15051e-03,6.33986e+03,6.28100e+03,1.15080e-03,6.39655e+03,6.33702e+03,1.15110e-03,6.45480e+03,
6.39458e+03,1.15140e-03,6.51278e+03,6.45187e+03,1.15153e-03,6.53759e+03,6.47638e+03,1.15170e-03,6.57017e+03,6.50857e+03,
1.15210e-03,6.64550e+03,6.58300e+03,1.15255e-03,6.72860e+03,6.66508e+03,1.15300e-03,6.80928e+03,6.74477e+03,1.15350e-03,
6.89108e+03,6.82562e+03,1.15400e-03,6.96952e+03,6.90312e+03,1.15442e-03,7.03306e+03,6.96590e+03,1.15450e-03,7.04433e+03,
6.97703e+03,1.15500e-03,7.11569e+03,7.04752e+03,1.15560e-03,7.19669e+03,7.12751e+03,1.15630e-03,7.28449e+03,7.21429e+03,
1.15690e-03,7.35393e+03,7.28291e+03,1.15730e-03,7.39734e+03,7.32580e+03,1.15732e-03,7.39984e+03,7.32827e+03,1.15800e-03,
7.46761e+03,7.39521e+03,1.15870e-03,7.53089e+03,7.45770e+03,1.15950e-03,7.59536e+03,7.52143e+03,1.15995e-03,7.62692e+03,
7.55262e+03,1.16040e-03,7.65860e+03,7.58393e+03,1.16145e-03,7.72087e+03,7.64546e+03,1.16150e-03,7.72375e+03,7.64830e+03,
1.16270e-03,7.77710e+03,7.70096e+03,1.16359e-03,7.80772e+03,7.73125e+03,1.16400e-03,7.82201e+03,7.74538e+03,1.16500e-03,
7.84882e+03,7.77189e+03,1.16650e-03,7.87868e+03,7.80140e+03,1.16700e-03,7.88503e+03,7.80767e+03,1.16850e-03,7.90400e+03,
7.82640e+03,1.17000e-03,7.91489e+03,7.83712e+03,1.17300e-03,7.91890e+03,7.84113e+03,1.17429e-03,7.91557e+03,7.83786e+03,
1.17800e-03,7.90607e+03,7.82852e+03,1.17969e-03,7.89957e+03,7.82210e+03,1.18000e-03,7.89837e+03,7.82092e+03,1.18406e-03,
7.86194e+03,7.78492e+03,1.18850e-03,7.82232e+03,7.74579e+03,1.19000e-03,7.80906e+03,7.73269e+03,1.19063e-03,7.80181e+03,
7.72552e+03,1.19766e-03,7.72122e+03,7.64597e+03,1.20226e-03,7.66924e+03,7.59467e+03,1.20500e-03,7.63459e+03,7.56045e+03,
1.20573e-03,7.62444e+03,7.55043e+03,1.21341e-03,7.51886e+03,7.44615e+03,1.21500e-03,7.49721e+03,7.42477e+03,1.21619e-03,
7.47960e+03,7.40737e+03,1.22277e-03,7.38279e+03,7.31173e+03,1.22500e-03,7.35033e+03,7.27967e+03,1.23125e-03,7.25346e+03,
7.18399e+03,1.24000e-03,7.12080e+03,7.05296e+03,1.24032e-03,7.11620e+03,7.04841e+03,1.25890e-03,6.85439e+03,6.78983e+03,
1.25892e-03,6.85405e+03,6.78949e+03,1.26957e-03,6.71012e+03,6.64730e+03,1.27350e-03,6.65796e+03,6.59577e+03,1.27915e-03,
6.58488e+03,6.52355e+03,1.28818e-03,6.47048e+03,6.41048e+03,1.28825e-03,6.46958e+03,6.40959e+03,1.29000e-03,6.44772e+03,
6.38798e+03,1.29070e-03,6.43880e+03,6.37916e+03,1.29070e-03,7.31999e+03,7.25131e+03,1.31180e-03,7.03697e+03,6.97156e+03,
1.31811e-03,6.95532e+03,6.89086e+03,1.31826e-03,6.95337e+03,6.88893e+03,1.32459e-03,6.87210e+03,6.80859e+03,1.33352e-03,
6.75961e+03,6.69740e+03,1.33406e-03,6.75293e+03,6.69080e+03,1.34573e-03,6.61007e+03,6.54958e+03,1.35000e-03,6.55891e+03,
6.49902e+03,1.35783e-03,6.46702e+03,6.40818e+03,1.36458e-03,6.38912e+03,6.33118e+03,1.36500e-03,6.38435e+03,6.32646e+03,
1.37408e-03,6.28332e+03,6.22659e+03,1.38798e-03,6.13306e+03,6.07804e+03,1.39000e-03,6.11166e+03,6.05688e+03,1.39637e-03,
6.04545e+03,5.99142e+03,1.41101e-03,5.89791e+03,5.84555e+03,1.41254e-03,5.88285e+03,5.83066e+03,1.42889e-03,5.72474e+03,
5.67432e+03,1.44784e-03,5.54690e+03,5.49844e+03,1.46218e-03,5.41742e+03,5.37037e+03,1.49057e-03,5.17367e+03,5.12925e+03,
1.50000e-03,5.09610e+03,5.05251e+03,1.51356e-03,4.98750e+03,4.94506e+03,1.55490e-03,4.67599e+03,4.63679e+03,1.55683e-03,
4.66209e+03,4.62303e+03,1.56675e-03,4.59162e+03,4.55328e+03,1.57000e-03,4.56887e+03,4.53077e+03,1.58489e-03,4.46533e+03,
4.42828e+03,1.58490e-03,4.46529e+03,4.42823e+03,1.60325e-03,4.34234e+03,4.30652e+03,1.61731e-03,4.25069e+03,4.21577e+03,
1.62181e-03,4.22198e+03,4.18735e+03,1.67880e-03,3.88085e+03,3.84953e+03,1.69824e-03,3.77343e+03,3.74312e+03,1.70222e-03,
3.75201e+03,3.72191e+03,1.75792e-03,3.46908e+03,3.44161e+03,1.77828e-03,3.37206e+03,3.34547e+03,1.81146e-03,3.22124e+03,
3.19599e+03,1.81970e-03,3.18522e+03,3.16030e+03,1.82000e-03,3.18393e+03,3.15902e+03,1.86209e-03,3.00765e+03,2.98428e+03,
1.90546e-03,2.84003e+03,2.81809e+03,1.92753e-03,2.75985e+03,2.73859e+03,1.95000e-03,2.68039e+03,2.65979e+03,1.97242e-03,
2.60374e+03,2.58378e+03,1.99526e-03,2.52886e+03,2.50950e+03,1.99530e-03,2.52873e+03,2.50938e+03,2.00000e-03,2.51370e+03,
2.49447e+03,2.04174e-03,2.38565e+03,2.36744e+03,2.05205e-03,2.35544e+03,2.33748e+03,2.06538e-03,2.31717e+03,2.29951e+03,
2.08930e-03,2.25066e+03,2.23352e+03,2.18776e-03,2.00344e+03,1.98820e+03,2.21310e-03,1.94573e+03,1.93093e+03,2.23872e-03,
1.88974e+03,1.87535e+03,2.27501e-03,1.81431e+03,1.80047e+03,2.30000e-03,1.76480e+03,1.75132e+03,2.31740e-03,1.73107e+03,
1.71784e+03,2.34423e-03,1.68049e+03,1.66762e+03,2.37137e-03,1.63137e+03,1.61885e+03,2.40000e-03,1.58172e+03,1.56954e+03,
2.43638e-03,1.52147e+03,1.50971e+03,2.48313e-03,1.44861e+03,1.43736e+03,2.51189e-03,1.40626e+03,1.39529e+03,2.51190e-03,
1.40624e+03,1.39527e+03,2.54097e-03,1.36518e+03,1.35449e+03,2.57040e-03,1.32479e+03,1.31438e+03,2.60016e-03,1.28564e+03,
1.27549e+03,2.63027e-03,1.24767e+03,1.23776e+03,2.66073e-03,1.21081e+03,1.20114e+03,2.69797e-03,1.16785e+03,1.15846e+03,
2.78612e-03,1.07424e+03,1.06545e+03,2.80000e-03,1.06048e+03,1.05178e+03,2.81838e-03,1.04252e+03,1.03394e+03,2.85102e-03,
1.01168e+03,1.00329e+03,2.88403e-03,9.81775e+02,9.73575e+02,2.91743e-03,9.52783e+02,9.44763e+02,2.95121e-03,9.24658e+02,
9.16813e+02,2.98538e-03,8.97089e+02,8.89413e+02,3.01995e-03,8.70228e+02,8.62715e+02,3.03520e-03,8.58747e+02,8.51303e+02,
3.09030e-03,8.18962e+02,8.11764e+02,3.12608e-03,7.94388e+02,7.87339e+02,3.16228e-03,7.70572e+02,7.63668e+02,3.16230e-03,
7.70558e+02,7.63654e+02,3.19889e-03,7.47493e+02,7.40728e+02,3.27341e-03,7.03448e+02,6.96947e+02,3.34965e-03,6.62028e+02,
6.55774e+02,3.38844e-03,6.42113e+02,6.35976e+02,3.41537e-03,6.28738e+02,6.22679e+02,3.42768e-03,6.22750e+02,6.16727e+02,
3.54813e-03,5.68196e+02,5.62500e+02,3.58922e-03,5.51132e+02,5.45537e+02,3.63078e-03,5.34483e+02,5.28987e+02,3.67282e-03,
5.18351e+02,5.12951e+02,3.71535e-03,5.02722e+02,4.97413e+02,3.77156e-03,4.83061e+02,4.77868e+02,3.80189e-03,4.72890e+02,
4.67758e+02,3.84592e-03,4.58650e+02,4.53605e+02,3.89045e-03,4.44673e+02,4.39711e+02,3.98107e-03,4.18036e+02,4.13233e+02,
3.98110e-03,4.18028e+02,4.13225e+02,4.02717e-03,4.05325e+02,4.00598e+02,4.04795e-03,3.99780e+02,3.95086e+02,4.07380e-03,
3.93024e+02,3.88373e+02,4.12097e-03,3.81044e+02,3.76466e+02,4.21696e-03,3.58201e+02,3.53766e+02,4.31519e-03,3.36762e+02,
3.32461e+02,4.36516e-03,3.26535e+02,3.22299e+02,4.40246e-03,3.19185e+02,3.14995e+02,4.41570e-03,3.16629e+02,3.12456e+02,
4.46684e-03,3.07031e+02,3.02921e+02,4.51856e-03,2.97635e+02,2.93587e+02,4.57088e-03,2.88530e+02,2.84542e+02,4.62381e-03,
2.79715e+02,2.75785e+02,4.67735e-03,2.71117e+02,2.67245e+02,4.78630e-03,2.54732e+02,2.50969e+02,4.87702e-03,2.42128e+02,
2.38451e+02,4.89779e-03,2.39362e+02,2.35705e+02,5.01187e-03,2.24935e+02,2.21382e+02,5.01190e-03,2.24931e+02,2.21379e+02,
5.06991e-03,2.18061e+02,2.14559e+02,5.12861e-03,2.11384e+02,2.07931e+02,5.18800e-03,2.04877e+02,2.01473e+02,5.28153e-03,
1.95191e+02,1.91860e+02,5.30884e-03,1.92481e+02,1.89171e+02,5.37032e-03,1.86570e+02,1.83308e+02,5.43250e-03,1.80807e+02,
1.77590e+02,5.55904e-03,1.69822e+02,1.66695e+02,5.68853e-03,1.59520e+02,1.56478e+02,5.73373e-03,1.56133e+02,1.53120e+02,
5.88844e-03,1.45259e+02,1.42344e+02,6.02560e-03,1.36411e+02,1.33578e+02,6.09537e-03,1.32199e+02,1.29405e+02,6.16595e-03,
1.28096e+02,1.25341e+02,6.22489e-03,1.24804e+02,1.22080e+02,6.23735e-03,1.24123e+02,1.21406e+02,6.30957e-03,1.20272e+02,
1.17594e+02,6.30960e-03,1.20271e+02,1.17593e+02,6.45654e-03,1.12931e+02,1.10330e+02,6.68344e-03,1.02779e+02,1.00288e+02,
6.71455e-03,1.01489e+02,9.90121e+01,6.83912e-03,9.65379e+01,9.41202e+01,6.91831e-03,9.35498e+01,9.11680e+01,6.92820e-03,
9.31847e+01,9.08074e+01,6.99842e-03,9.06299e+01,8.82835e+01,7.07946e-03,8.78017e+01,8.54900e+01,7.16143e-03,8.50640e+01,
8.27863e+01,7.24436e-03,8.24129e+01,8.01685e+01,7.26867e-03,8.16573e+01,7.94225e+01,7.41310e-03,7.73563e+01,7.51797e+01,
7.54313e-03,7.37521e+01,7.16255e+01,7.58578e-03,7.26196e+01,7.05095e+01,7.82310e-03,6.67497e+01,6.47273e+01,7.94328e-03,
6.40223e+01,6.20435e+01,7.94330e-03,6.40219e+01,6.20431e+01,8.00000e-03,6.27848e+01,6.08260e+01,8.03526e-03,6.20324e+01,
6.00858e+01,8.09329e-03,6.08083e+01,5.88816e+01,8.12830e-03,6.00848e+01,5.81707e+01,8.22243e-03,5.81987e+01,5.63175e+01,
8.41395e-03,5.46057e+01,5.27886e+01,8.51138e-03,5.28962e+01,5.11101e+01,8.53988e-03,5.24098e+01,5.06326e+01,8.60994e-03,
5.12380e+01,4.94844e+01,8.90290e-03,4.67194e+01,4.50587e+01,9.07684e-03,4.42877e+01,4.26824e+01,9.12011e-03,4.37087e+01,
4.21178e+01,9.22571e-03,4.23415e+01,4.07853e+01,9.33254e-03,4.10129e+01,3.94903e+01,9.34890e-03,4.08129e+01,3.92954e+01,
9.44061e-03,3.97119e+01,3.82264e+01,9.55759e-03,3.83638e+01,3.69175e+01,9.64945e-03,3.73449e+01,3.59318e+01,9.73302e-03,
3.64469e+01,3.50657e+01,9.77237e-03,3.60322e+01,3.46678e+01,9.84725e-03,3.52618e+01,3.39284e+01,9.88553e-03,3.48734e+01,
3.35586e+01,9.94091e-03,3.43215e+01,3.30332e+01,9.98947e-03,3.38428e+01,3.25815e+01,1.00000e-02,3.37393e+01,3.24847e+01,
1.00314e-02,3.34337e+01,3.21987e+01,1.00808e-02,3.29559e+01,3.17561e+01,1.01392e-02,3.23948e+01,3.12422e+01,1.02150e-02,
3.16851e+01,3.05931e+01,1.02529e-02,3.13441e+01,3.02754e+01,1.02811e-02,3.10985e+01,3.00415e+01,1.03090e-02,3.08646e+01,
2.98131e+01,1.03310e-02,3.06865e+01,2.96341e+01,1.03310e-02,2.22894e+02,1.32988e+02,1.03378e-02,2.22570e+02,1.32850e+02,
1.03649e-02,2.21286e+02,1.32297e+02,1.03911e-02,2.20061e+02,1.31767e+02,1.04367e-02,2.17962e+02,1.30850e+02,1.04800e-02,
2.15998e+02,1.29985e+02,1.05182e-02,2.13965e+02,1.29032e+02,1.05664e-02,2.11433e+02,1.27840e+02,1.05925e-02,2.10073e+02,
1.27199e+02,1.06000e-02,2.09687e+02,1.27017e+02,1.06492e-02,2.07344e+02,1.25934e+02,1.07125e-02,2.04373e+02,1.24554e+02,
1.07647e-02,2.01965e+02,1.23432e+02,1.08000e-02,2.00357e+02,1.22680e+02,1.08393e-02,1.98589e+02,1.21850e+02,1.08500e-02,
1.98109e+02,1.21624e+02,1.08658e-02,1.97376e+02,1.21274e+02,1.09648e-02,1.92854e+02,1.19106e+02,1.09858e-02,1.91911e+02,
1.18651e+02,1.10918e-02,1.87260e+02,1.16396e+02,1.11400e-02,1.85192e+02,1.15387e+02,1.13069e-02,1.78278e+02,1.11981e+02,
1.13501e-02,1.76547e+02,1.11121e+02,1.14815e-02,1.71421e+02,1.08556e+02,1.15877e-02,1.67432e+02,1.06540e+02,1.16145e-02,
1.66445e+02,1.06039e+02,1.18850e-02,1.56920e+02,1.01146e+02,1.19659e-02,1.54223e+02,9.97418e+01,1.22364e-02,1.45651e+02,
9.52243e+01,1.23027e-02,1.43649e+02,9.41574e+01,1.24451e-02,1.39481e+02,9.19197e+01,1.25890e-02,1.35318e+02,8.96483e+01,
1.25892e-02,1.35311e+02,8.96444e+01,1.27167e-02,1.31759e+02,8.76894e+01,1.28825e-02,1.27328e+02,8.52295e+01,1.30317e-02,
1.23516e+02,8.31047e+01,1.33464e-02,1.15974e+02,7.88450e+01,1.34896e-02,1.12752e+02,7.70023e+01,1.36458e-02,1.09378e+02,
7.50574e+01,1.36854e-02,1.08545e+02,7.45749e+01,1.41251e-02,9.98581e+01,6.94822e+01,1.42889e-02,9.68661e+01,6.77031e+01,
1.46218e-02,9.11607e+01,6.42728e+01,1.47911e-02,8.84363e+01,6.26168e+01,1.50000e-02,8.52226e+01,6.06476e+01,1.52140e-02,
8.20967e+01,5.87159e+01,1.54000e-02,7.95061e+01,5.71031e+01,1.54882e-02,7.83033e+01,5.63490e+01,1.56675e-02,7.59327e+01,
5.48554e+01,1.58489e-02,7.36346e+01,5.33981e+01,1.58490e-02,7.36337e+01,5.33976e+01,1.64059e-02,6.71512e+01,4.92364e+01,
1.65959e-02,6.51207e+01,4.79172e+01,1.66041e-02,6.50329e+01,4.78598e+01,1.71791e-02,5.93057e+01,4.40886e+01,1.73780e-02,
5.74861e+01,4.28771e+01,1.75792e-02,5.57208e+01,4.16951e+01,1.84077e-02,4.91877e+01,3.72644e+01,1.86209e-02,4.76782e+01,
3.62301e+01,1.94985e-02,4.20930e+01,3.23566e+01,1.99526e-02,3.95533e+01,3.05701e+01,1.99530e-02,3.95513e+01,3.05687e+01,
2.00000e-02,3.93006e+01,3.03915e+01,2.01837e-02,3.83420e+01,2.97124e+01,2.03810e-02,3.73465e+01,2.90045e+01,2.04174e-02,
3.71668e+01,2.88764e+01,2.06538e-02,3.60047e+01,2.80446e+01,2.08930e-02,3.48792e+01,2.72355e+01,2.16272e-02,3.17109e+01,
2.49394e+01,2.18776e-02,3.07209e+01,2.42161e+01,2.21309e-02,2.97616e+01,2.35128e+01,2.29087e-02,2.70612e+01,2.15184e+01,
2.37137e-02,2.46088e+01,1.96873e+01,2.39883e-02,2.38415e+01,1.91103e+01,2.40927e-02,2.35585e+01,1.88969e+01,2.45471e-02,
2.23782e+01,1.80048e+01,2.51189e-02,2.10057e+01,1.69612e+01,2.51190e-02,2.10054e+01,1.69610e+01,2.57040e-02,1.97181e+01,
1.59761e+01,2.61744e-02,1.87440e+01,1.52255e+01,2.63027e-02,1.84896e+01,1.50291e+01,2.69154e-02,1.73382e+01,1.41367e+01,
2.72270e-02,1.67900e+01,1.37100e+01,2.80000e-02,1.55294e+01,1.27240e+01,2.90400e-02,1.40285e+01,1.15413e+01,2.91743e-02,
1.38494e+01,1.13995e+01,3.05492e-02,1.21840e+01,1.00756e+01,3.16228e-02,1.10696e+01,9.18214e+00,3.16230e-02,1.10694e+01,
9.18197e+00,3.19889e-02,1.07169e+01,8.89783e+00,3.23594e-02,1.03756e+01,8.62215e+00,3.31131e-02,9.72605e+00,8.09568e+00,
3.42768e-02,8.82771e+00,7.36372e+00,3.49112e-02,8.38570e+00,7.00189e+00,3.50752e-02,8.27639e+00,6.91228e+00,3.58922e-02,
7.76009e+00,6.48807e+00,3.63078e-02,7.51444e+00,6.28567e+00,3.80189e-02,6.60902e+00,5.53631e+00,3.89045e-02,6.19918e+00,
5.19532e+00,3.89133e-02,6.19526e+00,5.19205e+00,3.93550e-02,6.00156e+00,5.03051e+00,3.98107e-02,5.81024e+00,4.87070e+00,
3.98110e-02,5.81012e+00,4.87060e+00,4.26579e-02,4.78682e+00,4.01205e+00,4.36516e-02,4.48880e+00,3.76055e+00,4.61865e-02,
3.83702e+00,3.20807e+00,4.62381e-02,3.82516e+00,3.19799e+00,4.67735e-02,3.70520e+00,3.09593e+00,4.80000e-02,3.44942e+00,
2.87790e+00,4.89779e-02,3.26104e+00,2.71685e+00,5.01187e-02,3.05915e+00,2.54390e+00,5.01190e-02,3.05910e+00,2.54386e+00,
5.06991e-02,2.96308e+00,2.46160e+00,5.18800e-02,2.78040e+00,2.30488e+00,5.62341e-02,2.22964e+00,1.83065e+00,5.68853e-02,
2.16102e+00,1.77139e+00,5.73903e-02,2.10983e+00,1.72716e+00,5.75440e-02,2.09459e+00,1.71400e+00,5.95662e-02,1.90805e+00,
1.55274e+00,6.02560e-02,1.84941e+00,1.50195e+00,6.30957e-02,1.63377e+00,1.31493e+00,6.30960e-02,1.63375e+00,1.31491e+00,
6.38264e-02,1.58418e+00,1.27197e+00,6.68344e-02,1.40175e+00,1.11383e+00,7.00000e-02,1.24165e+00,9.74890e-01,7.07946e-02,
1.20575e+00,9.43720e-01,7.49894e-02,1.04005e+00,7.99795e-01,7.58578e-02,1.01013e+00,7.73803e-01,7.69717e-02,9.73365e-01,
7.41848e-01,7.94328e-02,8.99101e-01,6.77370e-01,7.94330e-02,8.99096e-01,6.77365e-01,8.03526e-02,8.73522e-01,6.55273e-01,
8.60994e-02,7.36916e-01,5.37399e-01,8.81049e-02,6.97181e-01,5.03173e-01,9.01571e-02,6.60001e-01,4.71180e-01,9.22571e-02,
6.25237e-01,4.41303e-01,9.33254e-02,6.08711e-01,4.27114e-01,9.54993e-02,5.77275e-01,4.00153e-01,9.55823e-02,5.76130e-01,
3.99171e-01,1.00000e-01,5.20294e-01,3.51468e-01,1.01158e-01,5.07120e-01,3.40338e-01,1.02329e-01,4.94377e-01,3.29585e-01,
1.03514e-01,4.82048e-01,3.19192e-01,1.04713e-01,4.70121e-01,3.09151e-01,1.07152e-01,4.47347e-01,2.90008e-01,1.13822e-01,
3.94303e-01,2.45648e-01,1.14815e-01,3.87386e-01,2.39902e-01,1.17490e-01,3.69861e-01,2.25379e-01,1.18850e-01,3.61520e-01,
2.18483e-01,1.20226e-01,3.53447e-01,2.11822e-01,1.23027e-01,3.38071e-01,1.99170e-01,1.24452e-01,3.30753e-01,1.93166e-01,
1.25890e-01,3.23681e-01,1.87375e-01,1.25893e-01,3.23669e-01,1.87365e-01,1.28825e-01,3.10036e-01,1.76417e-01,1.34896e-01,
2.85264e-01,1.56675e-01,1.36395e-01,2.79777e-01,1.52332e-01,1.38038e-01,2.74006e-01,1.47785e-01,1.39637e-01,2.68636e-01,
1.43566e-01,1.42889e-01,2.58393e-01,1.35556e-01,1.44544e-01,2.53510e-01,1.31754e-01,1.47911e-01,2.44193e-01,1.24536e-01,
1.51356e-01,2.35443e-01,1.17802e-01,1.53109e-01,2.31269e-01,1.14607e-01,1.56675e-01,2.23302e-01,1.08539e-01,1.58489e-01,
2.19500e-01,1.05660e-01,1.58490e-01,2.19498e-01,1.05659e-01,1.62181e-01,2.12122e-01,1.00257e-01,1.67880e-01,2.01927e-01,
9.28895e-02,1.69824e-01,1.98726e-01,9.05981e-02,1.71791e-01,1.95619e-01,8.83846e-02,1.73780e-01,1.92603e-01,8.62460e-02,
1.76577e-01,1.88565e-01,8.33999e-02,1.79887e-01,1.84061e-01,8.02555e-02,1.88365e-01,1.73765e-01,7.31732e-02,1.92752e-01,
1.69048e-01,6.99841e-02,1.94984e-01,1.66789e-01,6.84697e-02,1.97242e-01,1.64593e-01,6.70064e-02,1.99526e-01,1.62457e-01,
6.55926e-02,1.99530e-01,1.62454e-01,6.55903e-02,2.06538e-01,1.56253e-01,6.17230e-02,2.13796e-01,1.50569e-01,5.82675e-02,
2.16272e-01,1.48773e-01,5.71914e-02,2.18776e-01,1.47023e-01,5.61513e-02,2.21309e-01,1.45319e-01,5.51456e-02,2.23872e-01,
1.43658e-01,5.41733e-02,2.29087e-01,1.40462e-01,5.23243e-02,2.31740e-01,1.38925e-01,5.14463e-02,2.33540e-01,1.37914e-01,
5.08723e-02,2.34423e-01,1.37426e-01,5.05973e-02,2.42661e-01,1.33143e-01,4.82138e-02,2.45471e-01,1.31784e-01,4.74707e-02,
2.48313e-01,1.30470e-01,4.67628e-02,2.51189e-01,1.29187e-01,4.60776e-02,2.51190e-01,1.29186e-01,4.60773e-02,2.54097e-01,
1.27894e-01,4.54443e-02,2.69154e-01,1.21855e-01,4.25692e-02,2.72270e-01,1.20727e-01,4.20486e-02,2.75423e-01,1.19624e-01,
4.15444e-02,2.78612e-01,1.18545e-01,4.10561e-02,2.85102e-01,1.16456e-01,4.01247e-02,2.98538e-01,1.12562e-01,3.84566e-02,
3.00000e-01,1.12168e-01,3.82913e-02,3.05492e-01,1.10731e-01,3.76953e-02,3.09029e-01,1.09842e-01,3.73314e-02,3.12608e-01,
1.08971e-01,3.69782e-02,3.16228e-01,1.08117e-01,3.66358e-02,3.16230e-01,1.08116e-01,3.66356e-02,3.19889e-01,1.07248e-01,
3.63317e-02,3.23594e-01,1.06394e-01,3.60364e-02,3.24001e-01,1.06302e-01,3.60046e-02,3.27341e-01,1.05556e-01,3.57495e-02,
3.34965e-01,1.03935e-01,3.52108e-02,3.42768e-01,1.02370e-01,3.47011e-02,3.50752e-01,1.00858e-01,3.42181e-02,3.54813e-01,
1.00121e-01,3.39861e-02,3.58922e-01,9.93975e-02,3.37605e-02,3.67282e-01,9.79850e-02,3.33265e-02,3.80189e-01,9.59630e-02,
3.27276e-02,3.89045e-01,9.46663e-02,3.23511e-02,3.93550e-01,9.40325e-02,3.21693e-02,3.98107e-01,9.34082e-02,3.19914e-02,
3.98110e-01,9.34078e-02,3.19913e-02,4.00000e-01,9.31426e-02,3.19297e-02,4.02717e-01,9.27665e-02,3.18427e-02,4.12098e-01,
9.15107e-02,3.15546e-02,4.16869e-01,9.08995e-02,3.14184e-02,4.21697e-01,9.02967e-02,3.12846e-02,4.31519e-01,8.91149e-02,
3.10241e-02,4.36516e-01,8.85358e-02,3.08971e-02,4.41570e-01,8.79641e-02,3.07722e-02,4.46684e-01,8.73998e-02,3.06493e-02,
4.51856e-01,8.68429e-02,3.05286e-02,4.57088e-01,8.62931e-02,3.04098e-02,4.62381e-01,8.57529e-02,3.02954e-02,4.73151e-01,
8.46918e-02,3.00711e-02,4.73236e-01,8.46836e-02,3.00693e-02,4.78630e-01,8.41702e-02,2.99610e-02,4.84172e-01,8.36547e-02,
2.98523e-02,4.95450e-01,8.26417e-02,2.96386e-02,5.01187e-01,8.21440e-02,2.95337e-02,5.01190e-01,8.21438e-02,2.95337e-02,
5.06991e-01,8.16285e-02,2.94514e-02,5.12861e-01,8.11210e-02,2.93716e-02,5.18800e-01,8.06189e-02,2.92922e-02,5.30884e-01,
7.96306e-02,2.91340e-02,5.37032e-01,7.91443e-02,2.90553e-02,5.43250e-01,7.86630e-02,2.89767e-02,5.49541e-01,7.81866e-02,
2.88983e-02,5.55904e-01,7.77153e-02,2.88202e-02,5.62341e-01,7.72487e-02,2.87423e-02,5.68853e-01,7.67886e-02,2.86661e-02,
5.82103e-01,7.58816e-02,2.85138e-02,5.88844e-01,7.54347e-02,2.84376e-02,6.09537e-01,7.41189e-02,2.82086e-02,6.16595e-01,
7.36886e-02,2.81323e-02,6.23735e-01,7.32637e-02,2.80573e-02,6.30957e-01,7.28425e-02,2.79821e-02,6.30960e-01,7.28423e-02,
2.79821e-02,6.38264e-01,7.24037e-02,2.79244e-02,6.45654e-01,7.19688e-02,2.78660e-02,6.60694e-01,7.11103e-02,2.77470e-02,
6.68344e-01,7.06867e-02,2.76865e-02,6.76083e-01,7.02668e-02,2.76255e-02,6.83912e-01,6.98517e-02,2.75649e-02,6.99842e-01,
6.90319e-02,2.74417e-02,7.07946e-01,6.86271e-02,2.73790e-02,7.16143e-01,6.82255e-02,2.73156e-02,7.24436e-01,6.78272e-02,
2.72515e-02,7.32825e-01,6.74323e-02,2.71869e-02,7.58578e-01,6.62692e-02,2.69920e-02,7.67362e-01,6.58875e-02,2.69256e-02,
7.76247e-01,6.55086e-02,2.68586e-02,7.85236e-01,6.51326e-02,2.67910e-02,7.94328e-01,6.47596e-02,2.67228e-02,7.94330e-01,
6.47595e-02,2.67228e-02,8.03526e-01,6.43728e-02,2.66694e-02,8.51138e-01,6.24865e-02,2.63906e-02,8.60994e-01,6.21176e-02,
2.63318e-02,8.81049e-01,6.13880e-02,2.62113e-02,8.82040e-01,6.13527e-02,2.62053e-02,8.91251e-01,6.10273e-02,2.61497e-02,
9.01571e-01,6.06692e-02,2.60873e-02,9.12011e-01,6.03142e-02,2.60244e-02,9.22571e-01,5.99618e-02,2.59608e-02,9.33254e-01,
5.96119e-02,2.58962e-02,9.54993e-01,5.89195e-02,2.57647e-02,9.66051e-01,5.85770e-02,2.56977e-02,9.77237e-01,5.82369e-02,
2.56300e-02,9.88553e-01,5.78999e-02,2.55622e-02,1.00000e+00,5.75651e-02,2.54937e-02,1.00000e-03,1.88917e+03,1.88669e+03,
1.01395e-03,1.82885e+03,1.82642e+03,1.02329e-03,1.78996e+03,1.78756e+03,1.03000e-03,1.76273e+03,1.76036e+03,1.04393e-03,
1.70789e+03,1.70557e+03,1.05925e-03,1.65032e+03,1.64808e+03,1.07053e-03,1.60969e+03,1.60750e+03,1.07152e-03,1.60619e+03,
1.60400e+03,1.08393e-03,1.56282e+03,1.56070e+03,1.09313e-03,1.53166e+03,1.52959e+03,1.10918e-03,1.47938e+03,1.47741e+03,
1.11148e-03,1.47210e+03,1.47014e+03,1.12925e-03,1.41767e+03,1.41583e+03,1.13501e-03,1.40061e+03,1.39881e+03,1.14398e-03,
1.37455e+03,1.37283e+03,1.14815e-03,1.36266e+03,1.36097e+03,1.15707e-03,1.33770e+03,1.33610e+03,1.16145e-03,1.32565e+03,
1.32410e+03,1.16758e-03,1.30909e+03,1.30759e+03,1.17490e-03,1.28967e+03,1.28827e+03,1.17690e-03,1.28445e+03,1.28306e+03,
1.18468e-03,1.26438e+03,1.26311e+03,1.19000e-03,1.25090e+03,1.24971e+03,1.19058e-03,1.24944e+03,1.24826e+03,1.19415e-03,
1.24044e+03,1.23932e+03,1.19732e-03,1.23251e+03,1.23146e+03,1.20161e-03,1.22192e+03,1.22095e+03,1.20739e-03,1.20783e+03,
1.20696e+03,1.20986e-03,1.20190e+03,1.20106e+03,1.21229e-03,1.19611e+03,1.19530e+03,1.21345e-03,1.19334e+03,1.19254e+03,
1.21458e-03,1.19067e+03,1.18989e+03,1.21602e-03,1.18729e+03,1.18651e+03,1.21619e-03,1.18690e+03,1.18612e+03,1.21736e-03,
1.18415e+03,1.18337e+03,1.21889e-03,1.18056e+03,1.17979e+03,1.22036e-03,1.17714e+03,1.17637e+03,1.22203e-03,1.17326e+03,
1.17248e+03,1.22280e-03,1.17148e+03,1.17070e+03,1.22280e-03,2.47645e+03,2.45897e+03,1.22297e-03,2.52428e+03,2.50618e+03,
1.22325e-03,2.63443e+03,2.61492e+03,1.22350e-03,2.73264e+03,2.71187e+03,1.22356e-03,2.75492e+03,2.73386e+03,1.22375e-03,
2.82998e+03,2.80795e+03,1.22410e-03,2.96471e+03,2.94095e+03,1.22440e-03,3.07823e+03,3.05302e+03,1.22470e-03,3.18883e+03,
3.16222e+03,1.22478e-03,3.21741e+03,3.19043e+03,1.22500e-03,3.29734e+03,3.26932e+03,1.22540e-03,3.43704e+03,3.40723e+03,
1.22585e-03,3.58654e+03,3.55480e+03,1.22635e-03,3.74301e+03,3.70927e+03,1.22664e-03,3.82715e+03,3.79234e+03,1.22680e-03,
3.87483e+03,3.83941e+03,1.22730e-03,4.01068e+03,3.97354e+03,1.22770e-03,4.11114e+03,4.07269e+03,1.22800e-03,4.17304e+03,
4.13379e+03,1.22838e-03,4.23077e+03,4.19079e+03,1.22950e-03,4.40869e+03,4.36643e+03,1.23027e-03,4.51117e+03,4.46761e+03,
1.23030e-03,4.51537e+03,4.47175e+03,1.23042e-03,4.52884e+03,4.48505e+03,1.23050e-03,4.53803e+03,4.49412e+03,1.23250e-03,
4.71974e+03,4.67348e+03,1.23353e-03,4.78693e+03,4.73981e+03,1.23500e-03,4.88373e+03,4.83537e+03,1.23600e-03,4.92165e+03,
4.87283e+03,1.24000e-03,5.01095e+03,4.96091e+03,1.24392e-03,5.04641e+03,4.99586e+03,1.24500e-03,5.05617e+03,5.00548e+03,
1.25067e-03,5.05534e+03,5.00457e+03,1.25394e-03,5.05487e+03,5.00405e+03,1.25540e-03,5.05466e+03,5.00382e+03,1.25540e-03,
5.67837e+03,5.61904e+03,1.25560e-03,5.70292e+03,5.64322e+03,1.25590e-03,5.76030e+03,5.69984e+03,1.25620e-03,5.81722e+03,
5.75600e+03,1.25650e-03,5.87370e+03,5.81172e+03,1.25680e-03,5.92974e+03,5.86701e+03,1.25715e-03,5.99317e+03,5.92958e+03,
1.25745e-03,6.04639e+03,5.98207e+03,1.25750e-03,6.05552e+03,5.99107e+03,1.25785e-03,6.11563e+03,6.05034e+03,1.25820e-03,
6.17350e+03,6.10740e+03,1.25865e-03,6.24480e+03,6.17776e+03,1.25890e-03,6.28216e+03,6.21463e+03,1.25892e-03,6.28591e+03,
6.21832e+03,1.25900e-03,6.29736e+03,6.22963e+03,1.25950e-03,6.36799e+03,6.29930e+03,1.26000e-03,6.43290e+03,6.36330e+03,
1.26050e-03,6.49118e+03,6.42075e+03,1.26100e-03,6.54432e+03,6.47320e+03,1.26170e-03,6.61012e+03,6.53812e+03,1.26220e-03,
6.65132e+03,6.57875e+03,1.26300e-03,6.70802e+03,6.63464e+03,1.26380e-03,6.75428e+03,6.68031e+03,1.26450e-03,6.78733e+03,
6.71292e+03,1.26452e-03,6.78802e+03,6.71360e+03,1.26560e-03,6.82762e+03,6.75265e+03,1.26650e-03,6.85177e+03,6.77643e+03,
1.26800e-03,6.87875e+03,6.80309e+03,1.26820e-03,6.88076e+03,6.80507e+03,1.26950e-03,6.89402e+03,6.81817e+03,1.27220e-03,
6.90955e+03,6.83347e+03,1.27500e-03,6.91289e+03,6.83672e+03,1.27581e-03,6.91010e+03,6.83398e+03,1.27980e-03,6.89649e+03,
6.82058e+03,1.28300e-03,6.88559e+03,6.80986e+03,1.28595e-03,6.86798e+03,6.79249e+03,1.28800e-03,6.85575e+03,6.78044e+03,
1.28825e-03,6.85414e+03,6.77885e+03,1.29000e-03,6.84291e+03,6.76778e+03,1.29009e-03,6.84213e+03,6.76701e+03,1.29663e-03,
6.78580e+03,6.71144e+03,1.30317e-03,6.73027e+03,6.65667e+03,1.30500e-03,6.71491e+03,6.64152e+03,1.31300e-03,6.64066e+03,
6.56828e+03,1.31826e-03,6.58445e+03,6.51287e+03,1.32300e-03,6.53427e+03,6.46341e+03,1.33055e-03,6.44602e+03,6.37638e+03,
1.34192e-03,6.31618e+03,6.24835e+03,1.34896e-03,6.23760e+03,6.17087e+03,1.35314e-03,6.19163e+03,6.12554e+03,1.36458e-03,
6.06817e+03,6.00379e+03,1.36800e-03,6.03199e+03,5.96810e+03,1.37707e-03,5.93253e+03,5.86999e+03,1.38038e-03,5.89682e+03,
5.83476e+03,1.38704e-03,5.82592e+03,5.76480e+03,1.39637e-03,5.72862e+03,5.66876e+03,1.39839e-03,5.70719e+03,5.64760e+03,
1.40230e-03,5.66619e+03,5.60712e+03,1.40230e-03,6.43633e+03,6.36859e+03,1.41254e-03,6.32474e+03,6.25846e+03,1.42505e-03,
6.19226e+03,6.12770e+03,1.43207e-03,6.11963e+03,6.05601e+03,1.43964e-03,6.04257e+03,5.97995e+03,1.44544e-03,5.98452e+03,
5.92266e+03,1.44930e-03,5.94561e+03,5.88425e+03,1.45000e-03,5.93860e+03,5.87733e+03,1.45838e-03,5.85545e+03,5.79526e+03,
1.46218e-03,5.81824e+03,5.75853e+03,1.47352e-03,5.71040e+03,5.65208e+03,1.48714e-03,5.58467e+03,5.52797e+03,1.50000e-03,
5.46953e+03,5.41430e+03,1.50236e-03,5.44884e+03,5.39388e+03,1.51356e-03,5.35235e+03,5.29862e+03,1.53109e-03,5.20616e+03,
5.15427e+03,1.54207e-03,5.11750e+03,5.06672e+03,1.57000e-03,4.90157e+03,4.85346e+03,1.57720e-03,4.84770e+03,4.80025e+03,
1.58489e-03,4.79110e+03,4.74435e+03,1.58490e-03,4.79105e+03,4.74430e+03,1.62181e-03,4.53203e+03,4.48840e+03,1.62327e-03,
4.52220e+03,4.47869e+03,1.64059e-03,4.40776e+03,4.36561e+03,1.66907e-03,4.22848e+03,4.18843e+03,1.69824e-03,4.05532e+03,
4.01727e+03,1.71791e-03,3.94435e+03,3.90757e+03,1.74469e-03,3.79816e+03,3.76302e+03,1.75792e-03,3.72875e+03,3.69438e+03,
1.77828e-03,3.62546e+03,3.59223e+03,1.81970e-03,3.42628e+03,3.39520e+03,1.82889e-03,3.38417e+03,3.35355e+03,1.84077e-03,
3.33080e+03,3.30074e+03,1.90546e-03,3.06045e+03,3.03322e+03,1.92753e-03,2.97434e+03,2.94799e+03,1.92978e-03,2.96574e+03,
2.93948e+03,1.94984e-03,2.89073e+03,2.86522e+03,1.97242e-03,2.80954e+03,2.78484e+03,1.99526e-03,2.73014e+03,2.70623e+03,
1.99530e-03,2.73001e+03,2.70610e+03,2.04174e-03,2.57734e+03,2.55492e+03,2.06538e-03,2.50418e+03,2.48245e+03,2.08930e-03,
2.43312e+03,2.41207e+03,2.13796e-03,2.29542e+03,2.27566e+03,2.15000e-03,2.26307e+03,2.24361e+03,2.16272e-03,2.22938e+03,
2.21022e+03,2.19971e-03,2.13537e+03,2.11706e+03,2.21310e-03,2.10272e+03,2.08471e+03,2.22000e-03,2.08615e+03,2.06829e+03,
2.29087e-03,1.92629e+03,1.90984e+03,2.31740e-03,1.87093e+03,1.85496e+03,2.34423e-03,1.81715e+03,1.80164e+03,2.35000e-03,
1.80587e+03,1.79045e+03,2.37630e-03,1.75541e+03,1.74042e+03,2.42661e-03,1.66421e+03,1.64999e+03,2.50000e-03,1.54286e+03,
1.52964e+03,2.51189e-03,1.52416e+03,1.51109e+03,2.51190e-03,1.52414e+03,1.51107e+03,2.57040e-03,1.43656e+03,1.42419e+03,
2.60765e-03,1.38388e+03,1.37193e+03,2.63027e-03,1.35320e+03,1.34149e+03,2.66073e-03,1.31336e+03,1.30196e+03,2.69154e-03,
1.27472e+03,1.26363e+03,2.72270e-03,1.23726e+03,1.22645e+03,2.75423e-03,1.20092e+03,1.19039e+03,2.78612e-03,1.16568e+03,
1.15542e+03,2.81838e-03,1.13126e+03,1.12125e+03,2.88403e-03,1.06548e+03,1.05596e+03,2.91612e-03,1.03519e+03,1.02589e+03,
2.91743e-03,1.03398e+03,1.02468e+03,2.95121e-03,1.00343e+03,9.94361e+02,3.00000e-03,9.61480e+02,9.52717e+02,3.01995e-03,
9.44929e+02,9.36284e+02,3.09030e-03,8.89675e+02,8.81424e+02,3.12608e-03,8.63309e+02,8.55244e+02,3.13664e-03,8.55743e+02,
8.47731e+02,3.16228e-03,8.37741e+02,8.29858e+02,3.16230e-03,8.37726e+02,8.29843e+02,3.19889e-03,8.12953e+02,8.05245e+02,
3.20000e-03,8.12214e+02,8.04511e+02,3.30000e-03,7.49024e+02,7.41762e+02,3.31131e-03,7.42283e+02,7.35067e+02,3.42768e-03,
6.77272e+02,6.70499e+02,3.45327e-03,6.64060e+02,6.57376e+02,3.46737e-03,6.56930e+02,6.50295e+02,3.54813e-03,6.18115e+02,
6.11745e+02,3.63078e-03,5.81635e+02,5.75512e+02,3.67282e-03,5.64229e+02,5.58222e+02,3.71535e-03,5.47243e+02,5.41350e+02,
3.75837e-03,5.30785e+02,5.25002e+02,3.84592e-03,4.99359e+02,4.93783e+02,3.89045e-03,4.84214e+02,4.78738e+02,3.90167e-03,
4.80504e+02,4.75052e+02,3.93550e-03,4.69539e+02,4.64163e+02,3.98107e-03,4.55329e+02,4.50050e+02,3.98110e-03,4.55321e+02,
4.50041e+02,4.02717e-03,4.41551e+02,4.36366e+02,4.07380e-03,4.28208e+02,4.23113e+02,4.16869e-03,4.02747e+02,3.97825e+02,
4.26579e-03,3.78655e+02,3.73898e+02,4.31519e-03,3.67164e+02,3.62484e+02,4.36516e-03,3.55977e+02,3.51373e+02,4.37641e-03,
3.53517e+02,3.48929e+02,4.41570e-03,3.45101e+02,3.40572e+02,4.46684e-03,3.34566e+02,3.30111e+02,4.57088e-03,3.14484e+02,
3.10170e+02,4.62381e-03,3.04915e+02,3.00668e+02,4.76311e-03,2.81614e+02,2.77532e+02,4.84172e-03,2.69534e+02,2.65542e+02,
4.89779e-03,2.61303e+02,2.57373e+02,5.01187e-03,2.45495e+02,2.41684e+02,5.01190e-03,2.45492e+02,2.41681e+02,5.06991e-03,
2.37965e+02,2.34212e+02,5.18800e-03,2.23559e+02,2.19915e+02,5.24807e-03,2.16697e+02,2.13106e+02,5.30741e-03,2.10212e+02,
2.06672e+02,5.49541e-03,1.91343e+02,1.87957e+02,5.62341e-03,1.79830e+02,1.76540e+02,5.68853e-03,1.74274e+02,1.71030e+02,
5.70477e-03,1.72925e+02,1.69693e+02,5.75440e-03,1.68890e+02,1.65693e+02,5.88844e-03,1.58632e+02,1.55525e+02,5.93548e-03,
1.55240e+02,1.52163e+02,5.95662e-03,1.53747e+02,1.50684e+02,6.00000e-03,1.50737e+02,1.47703e+02,6.09537e-03,1.44401e+02,
1.41427e+02,6.23735e-03,1.35643e+02,1.32753e+02,6.30957e-03,1.31471e+02,1.28623e+02,6.30960e-03,1.31469e+02,1.28621e+02,
6.38263e-03,1.27428e+02,1.24620e+02,6.40709e-03,1.26106e+02,1.23311e+02,6.45654e-03,1.23489e+02,1.20721e+02,6.50000e-03,
1.21251e+02,1.18508e+02,6.53131e-03,1.19666e+02,1.16939e+02,6.68344e-03,1.12362e+02,1.09714e+02,6.83912e-03,1.05513e+02,
1.02940e+02,6.91831e-03,1.02251e+02,9.97151e+01,6.94918e-03,1.01015e+02,9.84933e+01,7.07946e-03,9.60163e+01,9.35555e+01,
7.16143e-03,9.30458e+01,9.06217e+01,7.32824e-03,8.73876e+01,8.50347e+01,7.41310e-03,8.46726e+01,8.23543e+01,7.49355e-03,
8.21968e+01,7.99103e+01,7.67362e-03,7.69995e+01,7.47858e+01,7.76247e-03,7.46045e+01,7.24250e+01,7.85236e-03,7.22844e+01,
7.01384e+01,7.94328e-03,7.00382e+01,6.79251e+01,7.94330e-03,7.00377e+01,6.79246e+01,8.03526e-03,6.78589e+01,6.57781e+01,
8.08902e-03,6.66294e+01,6.45670e+01,8.31764e-03,6.17240e+01,5.97422e+01,8.51138e-03,5.79555e+01,5.60374e+01,8.60994e-03,
5.61467e+01,5.42595e+01,8.63981e-03,5.56121e+01,5.37341e+01,8.81049e-03,5.26839e+01,5.08598e+01,8.89703e-03,5.12822e+01,
4.94843e+01,9.01571e-03,4.94393e+01,4.76786e+01,9.22571e-03,4.63952e+01,4.46971e+01,9.33254e-03,4.49422e+01,4.32744e+01,
9.34588e-03,4.47656e+01,4.31015e+01,9.66051e-03,4.08519e+01,3.92794e+01,9.68959e-03,4.05147e+01,3.89503e+01,9.77237e-03,
3.95737e+01,3.80336e+01,9.85464e-03,3.86686e+01,3.71522e+01,9.88553e-03,3.83353e+01,3.68284e+01,1.00000e-02,3.71246e+01,
3.56524e+01,1.01208e-02,3.58993e+01,3.44622e+01,1.03068e-02,3.41114e+01,3.27333e+01,1.03514e-02,3.36992e+01,3.23363e+01,
1.04043e-02,3.32196e+01,3.18744e+01,1.04713e-02,3.26223e+01,3.13023e+01,1.05432e-02,3.19969e+01,3.07032e+01,1.05907e-02,
3.15899e+01,3.03156e+01,1.05925e-02,3.15746e+01,3.03012e+01,1.06491e-02,3.10971e+01,2.98489e+01,1.07011e-02,3.06635e+01,
2.94411e+01,1.07152e-02,3.05467e+01,2.93323e+01,1.07461e-02,3.02925e+01,2.90953e+01,1.07968e-02,2.98763e+01,2.87112e+01,
1.08393e-02,2.95296e+01,2.83951e+01,1.08616e-02,2.93496e+01,2.82308e+01,1.09466e-02,2.86747e+01,2.76160e+01,1.09648e-02,
2.85355e+01,2.74867e+01,1.09833e-02,2.83949e+01,2.73561e+01,1.10137e-02,2.81711e+01,2.71435e+01,1.10434e-02,2.79604e+01,
2.69381e+01,1.10670e-02,2.77994e+01,2.67763e+01,1.10670e-02,1.99789e+02,1.14717e+02,1.10751e-02,1.99434e+02,1.14571e+02,
1.10918e-02,1.98710e+02,1.14272e+02,1.11019e-02,1.98270e+02,1.14090e+02,1.11400e-02,1.96640e+02,1.13411e+02,1.11413e-02,
1.96585e+02,1.13388e+02,1.11969e-02,1.94252e+02,1.12406e+02,1.12202e-02,1.93288e+02,1.11998e+02,1.12250e-02,1.93089e+02,
1.11914e+02,1.12796e-02,1.90681e+02,1.10859e+02,1.13328e-02,1.88371e+02,1.09844e+02,1.13501e-02,1.87624e+02,1.09515e+02,
1.13606e-02,1.87176e+02,1.09317e+02,1.14000e-02,1.85498e+02,1.08576e+02,1.14584e-02,1.83172e+02,1.07563e+02,1.15000e-02,
1.81537e+02,1.06849e+02,1.15101e-02,1.81141e+02,1.06675e+02,1.16137e-02,1.77160e+02,1.04922e+02,1.17363e-02,1.72602e+02,
1.02894e+02,1.17490e-02,1.72140e+02,1.02687e+02,1.18783e-02,1.67335e+02,1.00493e+02,1.20226e-02,1.62189e+02,9.81138e+01,
1.20559e-02,1.61033e+02,9.75751e+01,1.21619e-02,1.57429e+02,9.58853e+01,1.23027e-02,1.52807e+02,9.36952e+01,1.23544e-02,
1.51184e+02,9.29226e+01,1.24451e-02,1.48387e+02,9.15850e+01,1.25890e-02,1.44103e+02,8.95158e+01,1.25892e-02,1.44096e+02,
8.95123e+01,1.27125e-02,1.40563e+02,8.77869e+01,1.27350e-02,1.39929e+02,8.74758e+01,1.30007e-02,1.32754e+02,8.39146e+01,
1.30317e-02,1.31951e+02,8.35120e+01,1.33352e-02,1.24431e+02,7.96942e+01,1.34969e-02,1.20547e+02,7.76742e+01,1.36458e-02,
1.17116e+02,7.58722e+01,1.39637e-02,1.10230e+02,7.22036e+01,1.40736e-02,1.07980e+02,7.09891e+01,1.41254e-02,1.06941e+02,
7.04263e+01,1.42889e-02,1.03751e+02,6.86866e+01,1.46218e-02,9.76537e+01,6.53170e+01,1.49624e-02,9.18780e+01,6.20786e+01,
1.50000e-02,9.12685e+01,6.17336e+01,1.51356e-02,8.91189e+01,6.05120e+01,1.54882e-02,8.38488e+01,5.74824e+01,1.58489e-02,
7.88873e+01,5.45833e+01,1.58490e-02,7.88863e+01,5.45828e+01,1.60324e-02,7.65180e+01,5.31827e+01,1.64059e-02,7.19905e+01,
5.04768e+01,1.65959e-02,6.98291e+01,4.91707e+01,1.67880e-02,6.77329e+01,4.78949e+01,1.73000e-02,6.25577e+01,4.47058e+01,
1.74297e-02,6.13058e+01,4.39227e+01,1.77828e-02,5.80653e+01,4.18809e+01,1.81970e-02,5.45572e+01,3.96443e+01,1.84077e-02,
5.28821e+01,3.85663e+01,1.86209e-02,5.12590e+01,3.75155e+01,1.88365e-02,4.96857e+01,3.64908e+01,1.91319e-02,4.76363e+01,
3.51471e+01,1.92752e-02,4.66836e+01,3.45191e+01,1.94985e-02,4.52515e+01,3.35708e+01,1.99526e-02,4.25196e+01,3.17508e+01,
1.99530e-02,4.25174e+01,3.17494e+01,2.09867e-02,3.70921e+01,2.80745e+01,2.13796e-02,3.52794e+01,2.68281e+01,2.18776e-02,
3.31510e+01,2.53516e+01,2.21309e-02,3.21149e+01,2.46260e+01,2.26464e-02,3.01394e+01,2.32331e+01,2.28707e-02,2.93321e+01,
2.26602e+01,2.29087e-02,2.91982e+01,2.25651e+01,2.34423e-02,2.74030e+01,2.12833e+01,2.37137e-02,2.65478e+01,2.06687e+01,
2.48313e-02,2.33887e+01,1.83761e+01,2.48966e-02,2.32205e+01,1.82530e+01,2.50000e-02,2.29574e+01,1.80603e+01,2.51189e-02,
2.26597e+01,1.78419e+01,2.51190e-02,2.26593e+01,1.78417e+01,2.60016e-02,2.06060e+01,1.63264e+01,2.63027e-02,1.99642e+01,
1.58492e+01,2.66073e-02,1.93426e+01,1.53856e+01,2.68020e-02,1.89591e+01,1.50986e+01,2.69154e-02,1.87404e+01,1.49349e+01,
2.75423e-02,1.75919e+01,1.40712e+01,2.78612e-02,1.70354e+01,1.36500e+01,2.85102e-02,1.59754e+01,1.28438e+01,2.95121e-02,
1.45097e+01,1.17204e+01,2.98538e-02,1.40516e+01,1.13672e+01,2.99175e-02,1.39686e+01,1.13030e+01,3.09030e-02,1.27632e+01,
1.03685e+01,3.16228e-02,1.19717e+01,9.75064e+00,3.16230e-02,1.19715e+01,9.75046e+00,3.19889e-02,1.15948e+01,9.45558e+00,
3.23594e-02,1.12299e+01,9.16921e+00,3.31131e-02,1.05347e+01,8.62148e+00,3.34965e-02,1.02038e+01,8.35973e+00,3.38844e-02,
9.88342e+00,8.10573e+00,3.46737e-02,9.26502e+00,7.61309e+00,3.50752e-02,8.97082e+00,7.37788e+00,3.53561e-02,8.77238e+00,
7.21890e+00,3.54813e-02,8.68581e+00,7.14951e+00,3.75837e-02,7.39333e+00,6.10765e+00,3.80189e-02,7.15946e+00,5.91789e+00,
3.89211e-02,6.70636e+00,5.54912e+00,3.98107e-02,6.29717e+00,5.21511e+00,3.98110e-02,6.29705e+00,5.21500e+00,4.02717e-02,
6.09859e+00,5.05265e+00,4.07380e-02,5.90644e+00,4.89517e+00,4.12097e-02,5.72054e+00,4.74254e+00,4.16869e-02,5.54065e+00,
4.59458e+00,4.21696e-02,5.36435e+00,4.44917e+00,4.36516e-02,4.86945e+00,4.03965e+00,4.44128e-02,4.63977e+00,3.84888e+00,
4.51856e-02,4.42173e+00,3.66739e+00,4.78630e-02,3.76818e+00,3.12083e+00,5.01187e-02,3.31843e+00,2.74236e+00,5.01190e-02,
3.31838e+00,2.74232e+00,5.06991e-02,3.21485e+00,2.65502e+00,5.12861e-02,3.11466e+00,2.57044e+00,5.24807e-02,2.92207e+00,
2.40746e+00,5.30884e-02,2.83052e+00,2.32986e+00,5.58279e-02,2.46466e+00,2.01889e+00,5.62341e-02,2.41620e+00,1.97762e+00,
5.82103e-02,2.19890e+00,1.79232e+00,6.00000e-02,2.02560e+00,1.64419e+00,6.02560e-02,2.00245e+00,1.62437e+00,6.09537e-02,
1.94124e+00,1.57196e+00,6.16595e-02,1.88200e+00,1.52119e+00,6.24925e-02,1.81541e+00,1.46409e+00,6.30957e-02,1.76932e+00,
1.42454e+00,6.30960e-02,1.76930e+00,1.42452e+00,6.38264e-02,1.71567e+00,1.37858e+00,6.45654e-02,1.66332e+00,1.33368e+00,
7.18000e-02,1.25534e+00,9.82964e-01,7.32825e-02,1.19034e+00,9.27002e-01,7.49894e-02,1.12162e+00,8.67814e-01,7.67362e-02,
1.05733e+00,8.12407e-01,7.94328e-02,9.68647e-01,7.35964e-01,7.94330e-02,9.68641e-01,7.35959e-01,8.12830e-02,9.14142e-01,
6.89181e-01,8.22243e-02,8.88227e-01,6.66941e-01,8.91251e-02,7.28041e-01,5.29473e-01,8.91437e-02,7.27673e-01,5.29158e-01,
9.01571e-02,7.08065e-01,5.12372e-01,9.22571e-02,6.70074e-01,4.79869e-01,9.33254e-02,6.52015e-01,4.64428e-01,9.54993e-02,
6.17665e-01,4.35083e-01,9.77237e-02,5.85519e-01,4.07650e-01,9.88553e-02,5.70238e-01,3.94621e-01,1.00000e-01,5.55460e-01,
3.82030e-01,1.03514e-01,5.13738e-01,3.46830e-01,1.04713e-01,5.00727e-01,3.35875e-01,1.07152e-01,4.75967e-01,3.15062e-01,
1.08097e-01,4.66946e-01,3.07490e-01,1.13501e-01,4.20692e-01,2.68858e-01,1.18850e-01,3.82573e-01,2.37197e-01,1.21619e-01,
3.65309e-01,2.22923e-01,1.23027e-01,3.57092e-01,2.16146e-01,1.25890e-01,3.41456e-01,2.03283e-01,1.25893e-01,3.41443e-01,
2.03272e-01,1.28434e-01,3.28543e-01,1.92850e-01,1.36458e-01,2.93489e-01,1.64797e-01,1.39637e-01,2.81646e-01,1.55404e-01,
1.42889e-01,2.70533e-01,1.46636e-01,1.44544e-01,2.65236e-01,1.42474e-01,1.46218e-01,2.60104e-01,1.38454e-01,1.47911e-01,
2.55132e-01,1.34569e-01,1.56675e-01,2.32483e-01,1.17035e-01,1.58489e-01,2.28363e-01,1.13876e-01,1.58490e-01,2.28362e-01,
1.13875e-01,1.59634e-01,2.25816e-01,1.11978e-01,1.62181e-01,2.20371e-01,1.07943e-01,1.67880e-01,2.09257e-01,9.97795e-02,
1.71791e-01,2.02390e-01,9.47892e-02,1.73780e-01,1.99108e-01,9.24204e-02,1.77828e-01,1.92879e-01,8.79655e-02,1.81970e-01,
1.87005e-01,8.38049e-02,1.84077e-01,1.84196e-01,8.18290e-02,1.86209e-01,1.81467e-01,7.99195e-02,1.88365e-01,1.78817e-01,
7.80755e-02,1.92752e-01,1.73743e-01,7.45708e-02,1.94984e-01,1.71314e-01,7.29061e-02,1.99526e-01,1.66658e-01,6.97421e-02,
1.99530e-01,1.66654e-01,6.97397e-02,2.00000e-01,1.66183e-01,6.94347e-02,2.06853e-01,1.59722e-01,6.52927e-02,2.13796e-01,
1.53867e-01,6.16157e-02,2.16272e-01,1.51929e-01,6.04155e-02,2.18776e-01,1.50044e-01,5.92553e-02,2.21309e-01,1.48208e-01,
5.81340e-02,2.23872e-01,1.46421e-01,5.70500e-02,2.31740e-01,1.41375e-01,5.40495e-02,2.34423e-01,1.39779e-01,5.31142e-02,
2.45471e-01,1.33786e-01,4.96721e-02,2.48313e-01,1.32380e-01,4.88802e-02,2.51189e-01,1.31008e-01,4.81140e-02,2.51190e-01,
1.31007e-01,4.81136e-02,2.54097e-01,1.29630e-01,4.74021e-02,2.57040e-01,1.28284e-01,4.67133e-02,2.63027e-01,1.25686e-01,
4.54018e-02,2.72270e-01,1.22039e-01,4.36166e-02,2.75423e-01,1.20878e-01,4.30587e-02,2.81838e-01,1.18633e-01,4.19961e-02,
2.85102e-01,1.17547e-01,4.14894e-02,2.85256e-01,1.17497e-01,4.14660e-02,3.00006e-01,1.13004e-01,3.94266e-02,3.01995e-01,
1.12446e-01,3.91791e-02,3.05492e-01,1.11496e-01,3.87654e-02,3.09029e-01,1.10566e-01,3.83639e-02,3.16228e-01,1.08760e-01,
3.75958e-02,3.16230e-01,1.08759e-01,3.75956e-02,3.19889e-01,1.07852e-01,3.72563e-02,3.31131e-01,1.05231e-01,3.62970e-02,
3.34965e-01,1.04390e-01,3.59953e-02,3.38844e-01,1.03564e-01,3.57020e-02,3.42768e-01,1.02753e-01,3.54168e-02,3.54813e-01,
1.00422e-01,3.46235e-02,3.58922e-01,9.96722e-02,3.43728e-02,3.63078e-01,9.89348e-02,3.41286e-02,3.67282e-01,9.82103e-02,
3.38912e-02,3.71535e-01,9.74979e-02,3.36598e-02,3.80189e-01,9.61077e-02,3.32141e-02,3.84592e-01,9.54295e-02,3.29995e-02,
3.89045e-01,9.47664e-02,3.27943e-02,3.93550e-01,9.41137e-02,3.25939e-02,3.98107e-01,9.34709e-02,3.23981e-02,3.98110e-01,
9.34705e-02,3.23980e-02,4.02717e-01,9.28108e-02,3.22315e-02,4.07380e-01,9.21606e-02,3.20686e-02,4.16869e-01,9.08891e-02,
3.17536e-02,4.26580e-01,8.96538e-02,3.14511e-02,4.36516e-01,8.84596e-02,3.11669e-02,4.41570e-01,8.78746e-02,3.10286e-02,
4.46684e-01,8.72974e-02,3.08927e-02,4.51856e-01,8.67278e-02,3.07591e-02,4.57088e-01,8.61660e-02,3.06280e-02,4.62381e-01,
8.56115e-02,3.04990e-02,4.73151e-01,8.45235e-02,3.02470e-02,4.78630e-01,8.39925e-02,3.01266e-02,4.84172e-01,8.34680e-02,
3.00078e-02,4.89779e-01,8.29498e-02,2.98906e-02,5.01187e-01,8.19318e-02,2.96606e-02,5.01190e-01,8.19315e-02,2.96605e-02,
5.06991e-01,8.14090e-02,2.95697e-02,5.12861e-01,8.08921e-02,2.94795e-02,5.18800e-01,8.03812e-02,2.93900e-02,5.24808e-01,
7.98760e-02,2.93011e-02,5.30884e-01,7.93786e-02,2.92151e-02,5.37032e-01,7.88867e-02,2.91294e-02,5.55904e-01,7.74420e-02,
2.88747e-02,5.62341e-01,7.69707e-02,2.87907e-02,5.68853e-01,7.65043e-02,2.87070e-02,5.82103e-01,7.55856e-02,2.85402e-02,
6.02560e-01,7.42468e-02,2.82968e-02,6.09537e-01,7.38091e-02,2.82158e-02,6.09976e-01,7.37819e-02,2.82107e-02,6.16595e-01,
7.33755e-02,2.81350e-02,6.23735e-01,7.29460e-02,2.80543e-02,6.30957e-01,7.25205e-02,2.79736e-02,6.30960e-01,7.25204e-02,
2.79736e-02,6.38264e-01,7.20787e-02,2.79106e-02,6.53131e-01,7.12101e-02,2.77859e-02,6.60694e-01,7.07816e-02,2.77227e-02,
6.68344e-01,7.03570e-02,2.76589e-02,6.76083e-01,6.99362e-02,2.75946e-02,6.83912e-01,6.95191e-02,2.75298e-02,6.99842e-01,
6.86958e-02,2.73985e-02,7.07946e-01,6.82908e-02,2.73334e-02,7.16143e-01,6.78892e-02,2.72677e-02,7.24436e-01,6.74910e-02,
2.72014e-02,7.32825e-01,6.70960e-02,2.71345e-02,7.41310e-01,6.67044e-02,2.70672e-02,7.67362e-01,6.55485e-02,2.68617e-02,
7.76247e-01,6.51703e-02,2.67931e-02,7.85236e-01,6.47951e-02,2.67240e-02,7.94328e-01,6.44229e-02,2.66542e-02,7.94330e-01,
6.44228e-02,2.66542e-02,8.03526e-01,6.40345e-02,2.65976e-02,8.12831e-01,6.36491e-02,2.65401e-02,8.22243e-01,6.32668e-02,
2.64816e-02,8.31764e-01,6.28875e-02,2.64222e-02,8.51138e-01,6.21377e-02,2.63007e-02,8.60994e-01,6.17677e-02,2.62392e-02,
8.81049e-01,6.10359e-02,2.61136e-02,8.91251e-01,6.06742e-02,2.60495e-02,9.01571e-01,6.03152e-02,2.59846e-02,9.22571e-01,
5.96051e-02,2.58525e-02,9.33254e-01,5.92540e-02,2.57853e-02,9.44061e-01,5.89054e-02,2.57174e-02,9.66051e-01,5.82171e-02,
2.55806e-02,9.77237e-01,5.78768e-02,2.55112e-02,9.88553e-01,5.75388e-02,2.54412e-02,1.00000e+00,5.72032e-02,2.53704e-02,
1.00000e-03,2.11782e+03,2.11490e+03,1.01158e-03,2.06142e+03,2.05853e+03,1.02329e-03,2.00660e+03,2.00374e+03,1.02754e-03,
1.98717e+03,1.98432e+03,1.03514e-03,1.95299e+03,1.95017e+03,1.06479e-03,1.82741e+03,1.82467e+03,1.08393e-03,1.75239e+03,
1.74972e+03,1.09648e-03,1.70562e+03,1.70299e+03,1.10007e-03,1.69242e+03,1.68980e+03,1.10918e-03,1.65956e+03,1.65698e+03,
1.12202e-03,1.61481e+03,1.61228e+03,1.12962e-03,1.58917e+03,1.58667e+03,1.14815e-03,1.52908e+03,1.52665e+03,1.15000e-03,
1.52325e+03,1.52083e+03,1.15561e-03,1.50563e+03,1.50324e+03,1.16145e-03,1.48763e+03,1.48526e+03,1.17971e-03,1.43337e+03,
1.43110e+03,1.20226e-03,1.37012e+03,1.36796e+03,1.21619e-03,1.33277e+03,1.33070e+03,1.22111e-03,1.31989e+03,1.31785e+03,
1.23027e-03,1.29637e+03,1.29439e+03,1.23774e-03,1.27765e+03,1.27573e+03,1.24451e-03,1.26100e+03,1.25913e+03,1.25140e-03,
1.24437e+03,1.24255e+03,1.25890e-03,1.22659e+03,1.22485e+03,1.25892e-03,1.22653e+03,1.22479e+03,1.26195e-03,1.21947e+03,
1.21776e+03,1.27238e-03,1.19551e+03,1.19390e+03,1.27350e-03,1.19297e+03,1.19138e+03,1.28151e-03,1.17499e+03,1.17349e+03,
1.28921e-03,1.15802e+03,1.15663e+03,1.29520e-03,1.14506e+03,1.14377e+03,1.29897e-03,1.13699e+03,1.13576e+03,1.30372e-03,
1.12695e+03,1.12581e+03,1.31005e-03,1.11374e+03,1.11271e+03,1.31295e-03,1.10777e+03,1.10678e+03,1.31560e-03,1.10237e+03,
1.10142e+03,1.31693e-03,1.09968e+03,1.09874e+03,1.31829e-03,1.09692e+03,1.09600e+03,1.31957e-03,1.09435e+03,1.09343e+03,
1.32117e-03,1.09116e+03,1.09025e+03,1.32286e-03,1.08780e+03,1.08689e+03,1.32508e-03,1.08341e+03,1.08250e+03,1.32716e-03,
1.07931e+03,1.07839e+03,1.32830e-03,1.07709e+03,1.07616e+03,1.32830e-03,3.95108e+03,3.90911e+03,1.32907e-03,3.98314e+03,
3.94071e+03,1.33057e-03,4.04588e+03,4.00255e+03,1.33160e-03,4.08947e+03,4.04551e+03,1.33210e-03,4.10512e+03,4.06094e+03,
1.33352e-03,4.15053e+03,4.10569e+03,1.33413e-03,4.17038e+03,4.12525e+03,1.33590e-03,4.22792e+03,4.18196e+03,1.33617e-03,
4.23370e+03,4.18766e+03,1.33975e-03,4.31178e+03,4.26460e+03,1.34050e-03,4.32841e+03,4.28099e+03,1.34200e-03,4.35627e+03,
4.30842e+03,1.34968e-03,4.42131e+03,4.37246e+03,1.35000e-03,4.42401e+03,4.37512e+03,1.35300e-03,4.44406e+03,4.39483e+03,
1.35784e-03,4.45690e+03,4.40742e+03,1.36500e-03,4.47589e+03,4.42603e+03,1.36570e-03,4.47604e+03,4.42617e+03,1.36570e-03,
5.09070e+03,5.03145e+03,1.36582e-03,5.10525e+03,5.04575e+03,1.36610e-03,5.16185e+03,5.10151e+03,1.36640e-03,5.22228e+03,
5.16103e+03,1.36670e-03,5.28206e+03,5.21992e+03,1.36700e-03,5.34097e+03,5.27793e+03,1.36730e-03,5.39851e+03,5.33459e+03,
1.36760e-03,5.45412e+03,5.38933e+03,1.36785e-03,5.49935e+03,5.43385e+03,1.36820e-03,5.56004e+03,5.49364e+03,1.36850e-03,
5.60930e+03,5.54217e+03,1.36890e-03,5.67121e+03,5.60314e+03,1.36935e-03,5.73562e+03,5.66654e+03,1.36959e-03,5.76690e+03,
5.69733e+03,1.36970e-03,5.78168e+03,5.71187e+03,1.37020e-03,5.84120e+03,5.77052e+03,1.37065e-03,5.88857e+03,5.81717e+03,
1.37100e-03,5.92161e+03,5.84970e+03,1.37150e-03,5.96329e+03,5.89071e+03,1.37220e-03,6.01193e+03,5.93865e+03,1.37300e-03,
6.05538e+03,5.98142e+03,1.37330e-03,6.06872e+03,5.99454e+03,1.37500e-03,6.10170e+03,6.02703e+03,1.37650e-03,6.12805e+03,
6.05297e+03,1.37900e-03,6.13925e+03,6.06401e+03,1.38038e-03,6.14545e+03,6.07012e+03,1.38150e-03,6.15052e+03,6.07511e+03,
1.38300e-03,6.15299e+03,6.07754e+03,1.38500e-03,6.14994e+03,6.07450e+03,1.38764e-03,6.14023e+03,6.06494e+03,1.39300e-03,
6.12062e+03,6.04565e+03,1.39500e-03,6.11040e+03,6.03559e+03,1.39637e-03,6.10032e+03,6.02565e+03,1.39926e-03,6.07911e+03,
6.00475e+03,1.40400e-03,6.04465e+03,5.97079e+03,1.40614e-03,6.02755e+03,5.95394e+03,1.41254e-03,5.97668e+03,5.90382e+03,
1.41425e-03,5.96063e+03,5.88802e+03,1.41900e-03,5.91647e+03,5.84454e+03,1.42378e-03,5.87717e+03,5.80587e+03,1.43000e-03,
5.82653e+03,5.75604e+03,1.43190e-03,5.80928e+03,5.73906e+03,1.44278e-03,5.71175e+03,5.64305e+03,1.44500e-03,5.69215e+03,
5.62377e+03,1.45405e-03,5.61101e+03,5.54388e+03,1.46218e-03,5.53947e+03,5.47345e+03,1.46574e-03,5.50851e+03,5.44297e+03,
1.47000e-03,5.47173e+03,5.40676e+03,1.49674e-03,5.23555e+03,5.17414e+03,1.50000e-03,5.20772e+03,5.14672e+03,1.50377e-03,
5.17449e+03,5.11398e+03,1.51741e-03,5.05683e+03,4.99801e+03,1.51920e-03,5.04166e+03,4.98305e+03,1.51920e-03,5.72469e+03,
5.65759e+03,1.53109e-03,5.61953e+03,5.55396e+03,1.54331e-03,5.51355e+03,5.44952e+03,1.54882e-03,5.46676e+03,5.40340e+03,
1.55082e-03,5.44992e+03,5.38680e+03,1.55926e-03,5.37961e+03,5.31750e+03,1.56675e-03,5.31832e+03,5.25710e+03,1.57000e-03,
5.29204e+03,5.23120e+03,1.58209e-03,5.19604e+03,5.13659e+03,1.58489e-03,5.17409e+03,5.11495e+03,1.58490e-03,5.17403e+03,
5.11490e+03,1.59404e-03,5.10346e+03,5.04534e+03,1.61501e-03,4.94669e+03,4.89082e+03,1.63000e-03,4.83874e+03,4.78441e+03,
1.63328e-03,4.81521e+03,4.76120e+03,1.64059e-03,4.76332e+03,4.71005e+03,1.65959e-03,4.63202e+03,4.58058e+03,1.67372e-03,
4.53771e+03,4.48759e+03,1.67880e-03,4.50443e+03,4.45477e+03,1.69824e-03,4.38043e+03,4.33247e+03,1.71737e-03,4.26243e+03,
4.21607e+03,1.73780e-03,4.14130e+03,4.09657e+03,1.75792e-03,4.02680e+03,3.98359e+03,1.76727e-03,3.97515e+03,3.93263e+03,
1.84077e-03,3.59989e+03,3.56224e+03,1.84508e-03,3.57946e+03,3.54207e+03,1.85000e-03,3.55636e+03,3.51926e+03,1.88365e-03,
3.40361e+03,3.36843e+03,1.90546e-03,3.30956e+03,3.27555e+03,1.92753e-03,3.21775e+03,3.18486e+03,1.93609e-03,3.18271e+03,
3.15024e+03,1.94984e-03,3.12752e+03,3.09572e+03,1.97242e-03,3.03988e+03,3.00914e+03,1.99526e-03,2.95474e+03,2.92501e+03,
1.99530e-03,2.95461e+03,2.92487e+03,2.02481e-03,2.84948e+03,2.82098e+03,2.07000e-03,2.69846e+03,2.67170e+03,2.11349e-03,
2.56368e+03,2.53844e+03,2.13796e-03,2.49087e+03,2.46645e+03,2.16272e-03,2.42019e+03,2.39654e+03,2.17318e-03,2.39103e+03,
2.36770e+03,2.18776e-03,2.35120e+03,2.32830e+03,2.21310e-03,2.28420e+03,2.26202e+03,2.29087e-03,2.09468e+03,2.07450e+03,
2.30000e-03,2.07365e+03,2.05370e+03,2.31740e-03,2.03413e+03,2.01458e+03,2.42661e-03,1.80862e+03,1.79135e+03,2.45471e-03,
1.75635e+03,1.73959e+03,2.47810e-03,1.71448e+03,1.69813e+03,2.51189e-03,1.65642e+03,1.64063e+03,2.51190e-03,1.65640e+03,
1.64061e+03,2.54097e-03,1.60866e+03,1.59334e+03,2.60016e-03,1.51673e+03,1.50227e+03,2.66368e-03,1.42607e+03,1.41246e+03,
2.69154e-03,1.38870e+03,1.37543e+03,2.72270e-03,1.34851e+03,1.33561e+03,2.75423e-03,1.30950e+03,1.29695e+03,2.80000e-03,
1.25461e+03,1.24255e+03,2.85102e-03,1.19701e+03,1.18545e+03,2.95121e-03,1.09428e+03,1.08361e+03,2.95476e-03,1.09087e+03,
1.08023e+03,3.05492e-03,1.00050e+03,9.90629e+02,3.09030e-03,9.70776e+02,9.61155e+02,3.12608e-03,9.41965e+02,9.32583e+02,
3.16228e-03,9.14034e+02,9.04881e+02,3.16230e-03,9.14017e+02,9.04865e+02,3.23594e-03,8.60679e+02,8.51960e+02,3.32086e-03,
8.04142e+02,7.95875e+02,3.34965e-03,7.86135e+02,7.78013e+02,3.42768e-03,7.40111e+02,7.32357e+02,3.46737e-03,7.18140e+02,
7.10559e+02,3.50752e-03,6.96841e+02,6.89428e+02,3.54813e-03,6.76083e+02,6.68833e+02,3.58922e-03,6.55757e+02,6.48663e+02,
3.67282e-03,6.16800e+02,6.10005e+02,3.71535e-03,5.98224e+02,5.91570e+02,3.76506e-03,5.77492e+02,5.70994e+02,3.80189e-03,
5.62759e+02,5.56375e+02,3.84592e-03,5.45829e+02,5.39575e+02,3.93550e-03,5.13514e+02,5.07507e+02,3.98107e-03,4.98112e+02,
4.92222e+02,3.98110e-03,4.98103e+02,4.92213e+02,4.02717e-03,4.83174e+02,4.77398e+02,4.07380e-03,4.68704e+02,4.63037e+02,
4.12097e-03,4.54629e+02,4.49068e+02,4.21583e-03,4.27732e+02,4.22371e+02,4.21696e-03,4.27423e+02,4.22065e+02,4.26579e-03,
4.14453e+02,4.09193e+02,4.36516e-03,3.89697e+02,3.84626e+02,4.46684e-03,3.66438e+02,3.61545e+02,4.51856e-03,3.55352e+02,
3.50543e+02,4.57088e-03,3.44613e+02,3.39885e+02,4.62381e-03,3.34208e+02,3.29560e+02,4.67735e-03,3.24032e+02,3.19463e+02,
4.78630e-03,3.04494e+02,3.00077e+02,4.84172e-03,2.95185e+02,2.90842e+02,4.95450e-03,2.77426e+02,2.73222e+02,5.01187e-03,
2.68969e+02,2.64832e+02,5.01190e-03,2.68965e+02,2.64828e+02,5.12861e-03,2.52826e+02,2.48817e+02,5.14754e-03,2.50338e+02,
2.46349e+02,5.18800e-03,2.45130e+02,2.41184e+02,5.30000e-03,2.31487e+02,2.27654e+02,5.30884e-03,2.30448e+02,2.26624e+02,
5.43250e-03,2.16581e+02,2.12874e+02,5.49541e-03,2.09901e+02,2.06250e+02,5.58309e-03,2.01058e+02,1.97481e+02,5.62341e-03,
1.97162e+02,1.93620e+02,5.82103e-03,1.79526e+02,1.76142e+02,5.88844e-03,1.74018e+02,1.70684e+02,6.02281e-03,1.63726e+02,
1.60486e+02,6.02560e-03,1.63522e+02,1.60284e+02,6.16595e-03,1.53669e+02,1.50527e+02,6.23735e-03,1.48942e+02,1.45846e+02,
6.30957e-03,1.44361e+02,1.41311e+02,6.30960e-03,1.44360e+02,1.41309e+02,6.38263e-03,1.39899e+02,1.36893e+02,6.50193e-03,
1.32998e+02,1.30061e+02,6.60693e-03,1.27303e+02,1.24427e+02,6.68344e-03,1.23370e+02,1.20536e+02,6.76083e-03,1.19563e+02,
1.16771e+02,7.00000e-03,1.08791e+02,1.06119e+02,7.01854e-03,1.08009e+02,1.05346e+02,7.07946e-03,1.05491e+02,1.02858e+02,
7.32824e-03,9.60057e+01,9.34891e+01,7.49894e-03,9.01270e+01,8.76841e+01,7.55977e-03,8.81554e+01,8.57376e+01,7.67362e-03,
8.46189e+01,8.22494e+01,7.76247e-03,8.19966e+01,7.96633e+01,7.94328e-03,7.70045e+01,7.47417e+01,7.94330e-03,7.70040e+01,
7.47412e+01,8.03526e-03,7.46247e+01,7.23961e+01,8.17523e-03,7.11733e+01,6.89948e+01,8.31764e-03,6.78805e+01,6.57533e+01,
8.41395e-03,6.57718e+01,6.36778e+01,8.50850e-03,6.37848e+01,6.17227e+01,8.51138e-03,6.37256e+01,6.16645e+01,8.60994e-03,
6.17340e+01,5.97067e+01,8.81049e-03,5.79422e+01,5.59804e+01,9.11286e-03,5.28194e+01,5.09492e+01,9.22571e-03,5.10651e+01,
4.92288e+01,9.33254e-03,4.94798e+01,4.76746e+01,9.39815e-03,4.85330e+01,4.67465e+01,9.54993e-03,4.64335e+01,4.46914e+01,
9.66051e-03,4.49828e+01,4.32719e+01,9.77237e-03,4.35774e+01,4.18970e+01,9.80000e-03,4.32398e+01,4.15667e+01,9.88553e-03,
4.22150e+01,4.05644e+01,9.90345e-03,4.20038e+01,4.03579e+01,1.00000e-02,4.08885e+01,3.92695e+01,1.01158e-02,3.96036e+01,
3.80159e+01,1.02329e-02,3.83608e+01,3.68038e+01,1.03151e-02,3.75226e+01,3.59865e+01,1.05925e-02,3.48619e+01,3.34005e+01,
1.06492e-02,3.43509e+01,3.29040e+01,1.07152e-02,3.37668e+01,3.23387e+01,1.08393e-02,3.27054e+01,3.13116e+01,1.08979e-02,
3.22163e+01,3.08383e+01,1.09648e-02,3.16672e+01,3.03094e+01,1.10934e-02,3.06481e+01,2.93281e+01,1.11818e-02,2.99695e+01,
2.86778e+01,1.12202e-02,2.96805e+01,2.84020e+01,1.12524e-02,2.94404e+01,2.81729e+01,1.13256e-02,2.89028e+01,2.76622e+01,
1.13858e-02,2.84678e+01,2.72516e+01,1.14410e-02,2.80738e+01,2.68824e+01,1.14880e-02,2.77410e+01,2.65735e+01,1.15000e-02,
2.76557e+01,2.64951e+01,1.15402e-02,2.73720e+01,2.62342e+01,1.16162e-02,2.68395e+01,2.57507e+01,1.17003e-02,2.62653e+01,
2.52297e+01,1.17395e-02,2.60078e+01,2.49913e+01,1.17490e-02,2.59479e+01,2.49344e+01,1.17788e-02,2.57601e+01,2.47561e+01,
1.18038e-02,2.56085e+01,2.46080e+01,1.18290e-02,2.54603e+01,2.44598e+01,1.18290e-02,1.80081e+02,9.97910e+01,1.18317e-02,
1.79984e+02,9.97546e+01,1.18670e-02,1.78728e+02,9.92767e+01,1.19015e-02,1.77516e+02,9.88112e+01,1.19569e-02,1.75604e+02,
9.80694e+01,1.20226e-02,1.73381e+02,9.71980e+01,1.20300e-02,1.73135e+02,9.71010e+01,1.20566e-02,1.72186e+02,9.67156e+01,
1.21135e-02,1.70181e+02,9.58989e+01,1.21619e-02,1.68495e+02,9.52100e+01,1.21731e-02,1.68108e+02,9.50512e+01,1.22463e-02,
1.65602e+02,9.40216e+01,1.23440e-02,1.62335e+02,9.26696e+01,1.24534e-02,1.58775e+02,9.11820e+01,1.25890e-02,1.54507e+02,
8.93771e+01,1.25892e-02,1.54499e+02,8.93738e+01,1.27350e-02,1.49967e+02,8.74126e+01,1.27789e-02,1.48640e+02,8.68327e+01,
1.30317e-02,1.41294e+02,8.35819e+01,1.30587e-02,1.40540e+02,8.32437e+01,1.31826e-02,1.37147e+02,8.17129e+01,1.32778e-02,
1.34617e+02,8.05603e+01,1.33000e-02,1.34035e+02,8.02941e+01,1.35000e-02,1.29013e+02,7.79835e+01,1.36458e-02,1.25514e+02,
7.63497e+01,1.37009e-02,1.24228e+02,7.57446e+01,1.41254e-02,1.14896e+02,7.12748e+01,1.42581e-02,1.12179e+02,6.99469e+01,
1.44544e-02,1.08323e+02,6.80410e+01,1.45000e-02,1.07454e+02,6.76080e+01,1.47911e-02,1.01948e+02,6.48094e+01,1.49005e-02,
9.99773e+01,6.37948e+01,1.51356e-02,9.59149e+01,6.16829e+01,1.53109e-02,9.30345e+01,6.01677e+01,1.56546e-02,8.77228e+01,
5.73488e+01,1.58489e-02,8.49036e+01,5.58313e+01,1.58490e-02,8.49026e+01,5.58308e+01,1.60324e-02,8.23544e+01,5.44457e+01,
1.64059e-02,7.74833e+01,5.17614e+01,1.68363e-02,7.23522e+01,4.88805e+01,1.73780e-02,6.65375e+01,4.55476e+01,1.75792e-02,
6.45402e+01,4.43850e+01,1.79887e-02,6.07254e+01,4.21384e+01,1.82100e-02,5.87930e+01,4.09871e+01,1.84077e-02,5.71372e+01,
3.99936e+01,1.86209e-02,5.54239e+01,3.89584e+01,1.88365e-02,5.37219e+01,3.79181e+01,1.90546e-02,5.20722e+01,3.69030e+01,
1.92752e-02,5.04732e+01,3.59122e+01,1.96379e-02,4.79889e+01,3.43597e+01,1.99526e-02,4.59671e+01,3.30844e+01,1.99530e-02,
4.59647e+01,3.30829e+01,2.04174e-02,4.31896e+01,3.13140e+01,2.06538e-02,4.18637e+01,3.04610e+01,2.11349e-02,3.93340e+01,
2.88191e+01,2.16150e-02,3.70150e+01,2.73003e+01,2.21309e-02,3.47269e+01,2.57854e+01,2.26464e-02,3.26317e+01,2.43829e+01,
2.29087e-02,3.16323e+01,2.37086e+01,2.34423e-02,2.97249e+01,2.24117e+01,2.38466e-02,2.83577e+01,2.14716e+01,2.40000e-02,
2.78613e+01,2.11288e+01,2.42661e-02,2.70273e+01,2.05506e+01,2.48313e-02,2.53663e+01,1.93912e+01,2.51189e-02,2.45749e+01,
1.88350e+01,2.51190e-02,2.45745e+01,1.88348e+01,2.59977e-02,2.23561e+01,1.72624e+01,2.60016e-02,2.23469e+01,1.72559e+01,
2.63027e-02,2.16503e+01,1.67582e+01,2.66073e-02,2.09757e+01,1.62742e+01,2.69154e-02,2.03224e+01,1.58036e+01,2.75423e-02,
1.90770e+01,1.49012e+01,2.81838e-02,1.79086e+01,1.40479e+01,2.88403e-02,1.68116e+01,1.32407e+01,2.89422e-02,1.66496e+01,
1.31210e+01,2.91743e-02,1.62887e+01,1.28539e+01,3.05492e-02,1.43255e+01,1.13872e+01,3.16228e-02,1.30125e+01,1.03947e+01,
3.16230e-02,1.30122e+01,1.03945e+01,3.23594e-02,1.22058e+01,9.78025e+00,3.24849e-02,1.20752e+01,9.68042e+00,3.34965e-02,
1.10897e+01,8.92411e+00,3.38844e-02,1.07409e+01,8.65518e+00,3.42768e-02,1.04032e+01,8.39406e+00,3.46737e-02,1.00763e+01,
8.14062e+00,3.54813e-02,9.45362e+00,7.65580e+00,3.63078e-02,8.87024e+00,7.19915e+00,3.64311e-02,8.78632e+00,7.13319e+00,
3.67282e-02,8.58847e+00,6.97759e+00,3.71535e-02,8.31579e+00,6.76269e+00,3.89045e-02,7.31093e+00,5.96598e+00,3.93550e-02,
7.07980e+00,5.78162e+00,3.98107e-02,6.85596e+00,5.60266e+00,3.98110e-02,6.85583e+00,5.60255e+00,4.02130e-02,6.66631e+00,
5.45082e+00,4.12097e-02,6.22634e+00,5.09775e+00,4.21696e-02,5.83980e+00,4.78621e+00,4.31519e-02,5.47793e+00,4.49336e+00,
4.36516e-02,5.30577e+00,4.35362e+00,4.46684e-02,4.97800e+00,4.08682e+00,4.50000e-02,4.87722e+00,4.00458e+00,4.67735e-02,
4.37822e+00,3.59557e+00,4.89779e-02,3.85183e+00,3.16140e+00,4.95450e-02,3.73086e+00,3.06122e+00,5.01187e-02,3.61384e+00,
2.96416e+00,5.01190e-02,3.61379e+00,2.96411e+00,5.06991e-02,3.50056e+00,2.87017e+00,5.12861e-02,3.39100e+00,2.77913e+00,
5.43250e-02,2.89476e+00,2.36517e+00,5.49541e-02,2.80506e+00,2.29004e+00,5.55904e-02,2.71828e+00,2.21728e+00,5.61215e-02,
2.64805e+00,2.15827e+00,5.62341e-02,2.63348e+00,2.14604e+00,6.00000e-02,2.20504e+00,1.78508e+00,6.02560e-02,2.17964e+00,
1.76362e+00,6.23735e-02,1.98483e+00,1.59874e+00,6.30957e-02,1.92414e+00,1.54729e+00,6.30960e-02,1.92412e+00,1.54727e+00,
6.60693e-02,1.70041e+00,1.35761e+00,6.83912e-02,1.55123e+00,1.23082e+00,7.00000e-02,1.45884e+00,1.15217e+00,7.24295e-02,
1.33303e+00,1.04484e+00,7.41310e-02,1.25429e+00,9.77613e-01,7.49894e-02,1.21718e+00,9.45917e-01,7.58578e-02,1.18131e+00,
9.15262e-01,7.76247e-02,1.11310e+00,8.56936e-01,7.94328e-02,1.04933e+00,8.02379e-01,7.94330e-02,1.04932e+00,8.02374e-01,
8.03526e-02,1.01892e+00,7.76466e-01,8.51138e-02,8.81317e-01,6.59153e-01,9.01571e-02,7.64831e-01,5.59862e-01,9.12011e-02,
7.43781e-01,5.41928e-01,9.12647e-02,7.42529e-01,5.40861e-01,9.22571e-02,7.23402e-01,5.24587e-01,9.44061e-02,6.84402e-01,
4.91399e-01,9.54993e-02,6.65860e-01,4.75628e-01,1.00000e-01,5.97605e-01,4.17630e-01,1.02329e-01,5.66620e-01,3.91530e-01,
1.07152e-01,5.10505e-01,3.44370e-01,1.08393e-01,4.97601e-01,3.33550e-01,1.09349e-01,4.88040e-01,3.25540e-01,1.10918e-01,
4.73013e-01,3.12985e-01,1.17490e-01,4.18140e-01,2.67288e-01,1.21619e-01,3.89302e-01,2.43390e-01,1.23027e-01,3.80303e-01,
2.35954e-01,1.24452e-01,3.71594e-01,2.28767e-01,1.25890e-01,3.63181e-01,2.21834e-01,1.25893e-01,3.63166e-01,2.21822e-01,
1.27350e-01,3.54934e-01,2.15141e-01,1.31246e-01,3.34610e-01,1.98703e-01,1.33352e-01,3.24527e-01,1.90594e-01,1.39637e-01,
2.97762e-01,1.69192e-01,1.41254e-01,2.91589e-01,1.64285e-01,1.42889e-01,2.85611e-01,1.59543e-01,1.46218e-01,2.74210e-01,
1.50534e-01,1.49624e-01,2.63510e-01,1.42123e-01,1.51356e-01,2.58409e-01,1.38129e-01,1.56675e-01,2.44036e-01,1.26938e-01,
1.58489e-01,2.39538e-01,1.23457e-01,1.58490e-01,2.39537e-01,1.23456e-01,1.62181e-01,2.30836e-01,1.16908e-01,1.63090e-01,
2.28804e-01,1.15386e-01,1.65959e-01,2.22643e-01,1.10796e-01,1.71791e-01,2.11252e-01,1.02381e-01,1.73780e-01,2.07680e-01,
9.97629e-02,1.75792e-01,2.04241e-01,9.72593e-02,1.84077e-01,1.91465e-01,8.80557e-02,1.86209e-01,1.88502e-01,8.59457e-02,
1.92752e-01,1.80117e-01,8.00289e-02,1.94984e-01,1.77481e-01,7.81868e-02,1.97242e-01,1.74920e-01,7.64062e-02,1.99526e-01,
1.72432e-01,7.46850e-02,1.99530e-01,1.72428e-01,7.46822e-02,2.00000e-01,1.71918e-01,7.43439e-02,2.06538e-01,1.65234e-01,
6.99474e-02,2.11349e-01,1.60759e-01,6.70467e-02,2.16272e-01,1.56525e-01,6.43360e-02,2.16626e-01,1.56233e-01,6.41502e-02,
2.21309e-01,1.52510e-01,6.18027e-02,2.23872e-01,1.50583e-01,6.05989e-02,2.29087e-01,1.46912e-01,5.83398e-02,2.31740e-01,
1.45148e-01,5.72653e-02,2.34423e-01,1.43429e-01,5.62259e-02,2.37137e-01,1.41756e-01,5.52218e-02,2.39883e-01,1.40126e-01,
5.42504e-02,2.51189e-01,1.34007e-01,5.06687e-02,2.51190e-01,1.34006e-01,5.06684e-02,2.57040e-01,1.31093e-01,4.91053e-02,
2.60016e-01,1.29688e-01,4.83613e-02,2.63027e-01,1.28317e-01,4.76413e-02,2.72270e-01,1.24427e-01,4.56482e-02,2.75423e-01,
1.23189e-01,4.50251e-02,2.78612e-01,1.21981e-01,4.44225e-02,2.81838e-01,1.20799e-01,4.38387e-02,2.85102e-01,1.19644e-01,
4.32730e-02,2.88403e-01,1.18515e-01,4.27248e-02,2.91743e-01,1.17410e-01,4.21935e-02,3.01995e-01,1.14238e-01,4.06950e-02,
3.02213e-01,1.14175e-01,4.06657e-02,3.05492e-01,1.13232e-01,4.02335e-02,3.09029e-01,1.12247e-01,3.97856e-02,3.16228e-01,
1.10337e-01,3.89290e-02,3.16230e-01,1.10336e-01,3.89288e-02,3.19889e-01,1.09379e-01,3.85474e-02,3.27341e-01,1.07522e-01,
3.78187e-02,3.38844e-01,1.04867e-01,3.68024e-02,3.42768e-01,1.04016e-01,3.64826e-02,3.46737e-01,1.03186e-01,3.61780e-02,
3.50752e-01,1.02372e-01,3.58817e-02,3.54813e-01,1.01572e-01,3.55934e-02,3.63078e-01,1.00015e-01,3.50394e-02,3.71535e-01,
9.85127e-02,3.45152e-02,3.80189e-01,9.70614e-02,3.40176e-02,3.84592e-01,9.63539e-02,3.37781e-02,3.89045e-01,9.56630e-02,
3.35494e-02,3.98107e-01,9.43144e-02,3.31082e-02,3.98110e-01,9.43140e-02,3.31081e-02,4.02717e-01,9.36293e-02,3.29199e-02,
4.07380e-01,9.29546e-02,3.27358e-02,4.16869e-01,9.16367e-02,3.23807e-02,4.21697e-01,9.09925e-02,3.22088e-02,4.24474e-01,
9.06294e-02,3.21124e-02,4.26580e-01,9.03574e-02,3.20405e-02,4.46684e-01,8.79198e-02,3.14145e-02,4.51856e-01,8.73314e-02,
3.12652e-02,4.57088e-01,8.67513e-02,3.11189e-02,4.62381e-01,8.61791e-02,3.09752e-02,4.67735e-01,8.56145e-02,3.08339e-02,
4.73151e-01,8.50573e-02,3.06951e-02,4.84172e-01,8.39706e-02,3.04300e-02,4.95450e-01,8.29109e-02,3.01727e-02,5.00000e-01,
8.24974e-02,3.00725e-02,5.01187e-01,8.23908e-02,3.00467e-02,5.01190e-01,8.23906e-02,3.00466e-02,5.06991e-01,8.18540e-02,
2.99442e-02,5.18800e-01,8.07994e-02,2.97423e-02,5.24808e-01,8.02813e-02,2.96427e-02,5.30884e-01,7.97718e-02,2.95466e-02,
5.43250e-01,7.87697e-02,2.93564e-02,5.49541e-01,7.82769e-02,2.92623e-02,5.55904e-01,7.77896e-02,2.91687e-02,5.62341e-01,
7.73077e-02,2.90760e-02,5.68853e-01,7.68309e-02,2.89838e-02,5.75440e-01,7.63593e-02,2.88920e-02,5.82103e-01,7.58925e-02,
2.88008e-02,5.88844e-01,7.54327e-02,2.87119e-02,6.02560e-01,7.45268e-02,2.85352e-02,6.09537e-01,7.40806e-02,2.84472e-02,
6.16595e-01,7.36390e-02,2.83597e-02,6.23735e-01,7.32018e-02,2.82724e-02,6.30957e-01,7.27687e-02,2.81853e-02,6.30960e-01,
7.27686e-02,2.81853e-02,6.36008e-01,7.24572e-02,2.81373e-02,6.38264e-01,7.23194e-02,2.81160e-02,6.45654e-01,7.18758e-02,
2.80480e-02,6.60694e-01,7.10010e-02,2.79106e-02,6.68344e-01,7.05696e-02,2.78413e-02,6.76083e-01,7.01423e-02,2.77716e-02,
6.83912e-01,6.97188e-02,2.77016e-02,6.91831e-01,6.92992e-02,2.76312e-02,6.99842e-01,6.88833e-02,2.75603e-02,7.24436e-01,
6.76618e-02,2.73496e-02,7.32825e-01,6.72616e-02,2.72784e-02,7.41310e-01,6.68648e-02,2.72069e-02,7.49894e-01,6.64714e-02,
2.71349e-02,7.67362e-01,6.56944e-02,2.69896e-02,7.85236e-01,6.49322e-02,2.68446e-02,7.94328e-01,6.45556e-02,2.67714e-02,
7.94330e-01,6.45556e-02,2.67714e-02,8.03526e-01,6.41630e-02,2.67114e-02,8.12831e-01,6.37735e-02,2.66505e-02,8.22243e-01,
6.33872e-02,2.65888e-02,8.41395e-01,6.26238e-02,2.64629e-02,8.51138e-01,6.22466e-02,2.63986e-02,8.60994e-01,6.18731e-02,
2.63343e-02,8.91251e-01,6.07694e-02,2.61364e-02,9.01571e-01,6.04072e-02,2.60689e-02,9.22571e-01,5.96910e-02,2.59319e-02,
9.33254e-01,5.93369e-02,2.58623e-02,9.44061e-01,5.89855e-02,2.57920e-02,9.54993e-01,5.86374e-02,2.57218e-02,9.66051e-01,
5.82919e-02,2.56509e-02,9.77237e-01,5.79489e-02,2.55794e-02,9.88553e-01,5.76084e-02,2.55073e-02,1.00000e+00,5.72704e-02,
2.54345e-02,1.00000e-03,2.31434e+03,2.31113e+03,1.02329e-03,2.19308e+03,2.18992e+03,1.03514e-03,2.13456e+03,2.13142e+03,
1.04112e-03,2.10593e+03,2.10280e+03,1.04713e-03,2.07768e+03,2.07456e+03,1.05925e-03,2.02214e+03,2.01905e+03,1.07152e-03,
1.96816e+03,1.96510e+03,1.08393e-03,1.91568e+03,1.91265e+03,1.09351e-03,1.87640e+03,1.87339e+03,1.11000e-03,1.81140e+03,
1.80844e+03,1.14230e-03,1.69257e+03,1.68969e+03,1.14815e-03,1.67222e+03,1.66937e+03,1.15000e-03,1.66590e+03,1.66305e+03,
1.16145e-03,1.62727e+03,1.62446e+03,1.17490e-03,1.58336e+03,1.58059e+03,1.18118e-03,1.56342e+03,1.56067e+03,1.18850e-03,
1.54059e+03,1.53786e+03,1.20226e-03,1.49901e+03,1.49633e+03,1.21619e-03,1.45844e+03,1.45581e+03,1.21642e-03,1.45777e+03,
1.45514e+03,1.24395e-03,1.38153e+03,1.37900e+03,1.25890e-03,1.34248e+03,1.34001e+03,1.25892e-03,1.34241e+03,1.33995e+03,
1.27231e-03,1.30886e+03,1.30645e+03,1.27350e-03,1.30592e+03,1.30352e+03,1.29380e-03,1.25727e+03,1.25497e+03,1.30317e-03,
1.23567e+03,1.23342e+03,1.31447e-03,1.21028e+03,1.20808e+03,1.31826e-03,1.20192e+03,1.19975e+03,1.33225e-03,1.17181e+03,
1.16972e+03,1.33352e-03,1.16912e+03,1.16705e+03,1.34605e-03,1.14306e+03,1.14107e+03,1.35000e-03,1.13501e+03,1.13305e+03,
1.36004e-03,1.11473e+03,1.11285e+03,1.37147e-03,1.09222e+03,1.09044e+03,1.38302e-03,1.07011e+03,1.06845e+03,1.39275e-03,
1.05194e+03,1.05041e+03,1.40013e-03,1.03843e+03,1.03701e+03,1.40439e-03,1.03074e+03,1.02939e+03,1.40818e-03,1.02396e+03,
1.02267e+03,1.41254e-03,1.01624e+03,1.01503e+03,1.41930e-03,1.00441e+03,1.00331e+03,1.42249e-03,9.98893e+02,9.97834e+02,
1.42554e-03,9.93677e+02,9.92650e+02,1.42705e-03,9.91123e+02,9.90109e+02,1.42851e-03,9.88650e+02,9.87645e+02,1.42889e-03,
9.87999e+02,9.86996e+02,1.42993e-03,9.86256e+02,9.85258e+02,1.43151e-03,9.83612e+02,9.82619e+02,1.43341e-03,9.80440e+02,
9.79448e+02,1.43578e-03,9.76525e+02,9.75527e+02,1.43812e-03,9.72691e+02,9.71681e+02,1.43860e-03,9.71905e+02,9.70892e+02,
1.43860e-03,3.58130e+03,3.53891e+03,1.44050e-03,3.65118e+03,3.60771e+03,1.44057e-03,3.65333e+03,3.60983e+03,1.44236e-03,
3.70638e+03,3.66200e+03,1.44335e-03,3.73607e+03,3.69120e+03,1.44472e-03,3.76756e+03,3.72218e+03,1.44630e-03,3.80427e+03,
3.75830e+03,1.44876e-03,3.84408e+03,3.79748e+03,1.45000e-03,3.86431e+03,3.81738e+03,1.45300e-03,3.90026e+03,3.85271e+03,
1.45800e-03,3.93725e+03,3.88910e+03,1.46194e-03,3.94837e+03,3.89996e+03,1.46218e-03,3.94904e+03,3.90061e+03,1.46600e-03,
3.95991e+03,3.91131e+03,1.46669e-03,3.95950e+03,3.91090e+03,1.47400e-03,3.95523e+03,3.90660e+03,1.47911e-03,3.94224e+03,
3.89370e+03,1.48120e-03,3.93696e+03,3.88846e+03,1.48120e-03,4.52729e+03,4.46876e+03,1.48141e-03,4.54595e+03,4.48705e+03,
1.48160e-03,4.58489e+03,4.52538e+03,1.48168e-03,4.60181e+03,4.54202e+03,1.48185e-03,4.63602e+03,4.57569e+03,1.48192e-03,
4.63584e+03,4.57546e+03,1.48200e-03,4.66659e+03,4.60573e+03,1.48215e-03,4.69694e+03,4.63551e+03,1.48222e-03,4.69676e+03,
4.63534e+03,1.48230e-03,4.72715e+03,4.66527e+03,1.48260e-03,4.78649e+03,4.72358e+03,1.48285e-03,4.83506e+03,4.77129e+03,
1.48292e-03,4.83488e+03,4.77106e+03,1.48300e-03,4.86336e+03,4.79912e+03,1.48330e-03,4.91798e+03,4.85284e+03,1.48355e-03,
4.96197e+03,4.89609e+03,1.48385e-03,5.01216e+03,4.94543e+03,1.48415e-03,5.05915e+03,4.99160e+03,1.48450e-03,5.11006e+03,
5.04161e+03,1.48485e-03,5.15655e+03,5.08734e+03,1.48500e-03,5.17516e+03,5.10566e+03,1.48510e-03,5.17614e+03,5.10658e+03,
1.48520e-03,5.18298e+03,5.11328e+03,1.48535e-03,5.18973e+03,5.11991e+03,1.48550e-03,5.20372e+03,5.13368e+03,1.48565e-03,
5.20642e+03,5.13632e+03,1.48590e-03,5.22480e+03,5.15440e+03,1.48620e-03,5.24333e+03,5.17262e+03,1.48640e-03,5.25297e+03,
5.18209e+03,1.48830e-03,5.29120e+03,5.21971e+03,1.48999e-03,5.31148e+03,5.23964e+03,1.49100e-03,5.32367e+03,5.25161e+03,
1.49300e-03,5.33702e+03,5.26468e+03,1.49416e-03,5.34314e+03,5.27070e+03,1.49500e-03,5.34760e+03,5.27510e+03,1.49812e-03,
5.35481e+03,5.28218e+03,1.49900e-03,5.35684e+03,5.28417e+03,1.50000e-03,5.35560e+03,5.28295e+03,1.50264e-03,5.35236e+03,
5.27972e+03,1.50350e-03,5.35131e+03,5.27868e+03,1.50400e-03,5.34935e+03,5.27674e+03,1.50748e-03,5.33033e+03,5.25804e+03,
1.51356e-03,5.29737e+03,5.22562e+03,1.51421e-03,5.29390e+03,5.22221e+03,1.51680e-03,5.27998e+03,5.20853e+03,1.51900e-03,
5.26724e+03,5.19601e+03,1.52082e-03,5.25533e+03,5.18429e+03,1.52300e-03,5.24114e+03,5.17034e+03,1.52813e-03,5.20204e+03,
5.13187e+03,1.53663e-03,5.13812e+03,5.06900e+03,1.54300e-03,5.09099e+03,5.02266e+03,1.54500e-03,5.08020e+03,5.01205e+03,
1.54762e-03,5.06147e+03,4.99365e+03,1.54882e-03,5.05296e+03,4.98528e+03,1.55500e-03,5.01109e+03,4.94415e+03,1.55871e-03,
4.98482e+03,4.91834e+03,1.57000e-03,4.90595e+03,4.84083e+03,1.57063e-03,4.90158e+03,4.83654e+03,1.58000e-03,4.83756e+03,
4.77363e+03,1.58328e-03,4.81333e+03,4.74981e+03,1.58489e-03,4.80145e+03,4.73813e+03,1.58490e-03,4.80140e+03,4.73808e+03,
1.59000e-03,4.76414e+03,4.70145e+03,1.60325e-03,4.67131e+03,4.61020e+03,1.61000e-03,4.62497e+03,4.56463e+03,1.62054e-03,
4.55230e+03,4.49317e+03,1.62181e-03,4.54364e+03,4.48466e+03,1.63265e-03,4.46740e+03,4.40964e+03,1.64150e-03,4.40647e+03,
4.34966e+03,1.64150e-03,5.00462e+03,4.93955e+03,1.64306e-03,4.99338e+03,4.92849e+03,1.65000e-03,4.94391e+03,4.87983e+03,
1.65959e-03,4.87579e+03,4.81280e+03,1.66510e-03,4.83731e+03,4.77493e+03,1.67409e-03,4.77545e+03,4.71404e+03,1.68282e-03,
4.71639e+03,4.65592e+03,1.69433e-03,4.64013e+03,4.58088e+03,1.70597e-03,4.56477e+03,4.50673e+03,1.72074e-03,4.47161e+03,
4.41506e+03,1.73672e-03,4.37384e+03,4.31884e+03,1.73780e-03,4.36735e+03,4.31245e+03,1.76000e-03,4.23712e+03,4.18428e+03,
1.77438e-03,4.15371e+03,4.10217e+03,1.79887e-03,4.01695e+03,3.96753e+03,1.81741e-03,3.91767e+03,3.86977e+03,1.84077e-03,
3.79743e+03,3.75135e+03,1.86209e-03,3.69228e+03,3.64778e+03,1.87149e-03,3.64719e+03,3.60336e+03,1.90546e-03,3.49058e+03,
3.44906e+03,1.92753e-03,3.39348e+03,3.35338e+03,1.94364e-03,3.32498e+03,3.28586e+03,1.99526e-03,3.11830e+03,3.08213e+03,
1.99530e-03,3.11816e+03,3.08198e+03,2.00000e-03,3.10025e+03,3.06433e+03,2.01837e-03,3.03171e+03,2.99675e+03,2.01853e-03,
3.03111e+03,2.99615e+03,2.07000e-03,2.85022e+03,2.81775e+03,2.08930e-03,2.78573e+03,2.75414e+03,2.11977e-03,2.68797e+03,
2.65768e+03,2.13796e-03,2.63190e+03,2.60236e+03,2.16272e-03,2.55778e+03,2.52921e+03,2.25084e-03,2.31679e+03,2.29130e+03,
2.26464e-03,2.28195e+03,2.25690e+03,2.30000e-03,2.19615e+03,2.17217e+03,2.31740e-03,2.15509e+03,2.13162e+03,2.34423e-03,
2.09354e+03,2.07082e+03,2.37137e-03,2.03380e+03,2.01179e+03,2.37840e-03,2.01867e+03,1.99684e+03,2.45471e-03,1.86398e+03,
1.84398e+03,2.48313e-03,1.81064e+03,1.79126e+03,2.51189e-03,1.75836e+03,1.73957e+03,2.51190e-03,1.75833e+03,1.73955e+03,
2.54097e-03,1.70758e+03,1.68938e+03,2.56716e-03,1.66340e+03,1.64568e+03,2.57040e-03,1.65805e+03,1.64039e+03,2.63027e-03,
1.56322e+03,1.54661e+03,2.70105e-03,1.46081e+03,1.44532e+03,2.72270e-03,1.43134e+03,1.41617e+03,2.78612e-03,1.34928e+03,
1.33498e+03,2.85102e-03,1.27201e+03,1.25852e+03,2.88403e-03,1.23510e+03,1.22198e+03,2.90000e-03,1.21777e+03,1.20483e+03,
2.91743e-03,1.19923e+03,1.18648e+03,2.95121e-03,1.16442e+03,1.15202e+03,2.98538e-03,1.13023e+03,1.11817e+03,3.00000e-03,
1.11599e+03,1.10407e+03,3.05492e-03,1.06468e+03,1.05328e+03,3.16228e-03,9.73017e+02,9.62504e+02,3.16230e-03,9.72999e+02,
9.62486e+02,3.19889e-03,9.44286e+02,9.34047e+02,3.23594e-03,9.16428e+02,9.06454e+02,3.27341e-03,8.89391e+02,8.79670e+02,
3.30044e-03,8.70447e+02,8.60902e+02,3.31131e-03,8.62988e+02,8.53513e+02,3.38844e-03,8.12561e+02,8.03557e+02,3.42768e-03,
7.88485e+02,7.79703e+02,3.50000e-03,7.46553e+02,7.38152e+02,3.54813e-03,7.20200e+02,7.12036e+02,3.58922e-03,6.98732e+02,
6.90760e+02,3.63078e-03,6.77911e+02,6.70124e+02,3.66969e-03,6.59195e+02,6.51573e+02,3.71535e-03,6.38125e+02,6.30690e+02,
3.75837e-03,6.19141e+02,6.11875e+02,3.80189e-03,6.00735e+02,5.93630e+02,3.90000e-03,5.61608e+02,5.54844e+02,3.98107e-03,
5.31663e+02,5.25156e+02,3.98110e-03,5.31653e+02,5.25146e+02,4.00000e-03,5.24990e+02,5.18540e+02,4.04782e-03,5.08654e+02,
5.02342e+02,4.07380e-03,5.00070e+02,4.93832e+02,4.12097e-03,4.84982e+02,4.78875e+02,4.16869e-03,4.70365e+02,4.64383e+02,
4.21696e-03,4.56202e+02,4.50341e+02,4.31519e-03,4.29183e+02,4.23552e+02,4.36516e-03,4.16297e+02,4.10775e+02,4.46684e-03,
3.91558e+02,3.86244e+02,4.53811e-03,3.75334e+02,3.70156e+02,4.57088e-03,3.68183e+02,3.63066e+02,4.62381e-03,3.56987e+02,
3.51965e+02,4.67735e-03,3.46136e+02,3.41207e+02,4.73151e-03,3.35626e+02,3.30787e+02,4.89779e-03,3.06011e+02,3.01424e+02,
4.95450e-03,2.96750e+02,2.92242e+02,4.98042e-03,2.92621e+02,2.88148e+02,5.00000e-03,2.89552e+02,2.85106e+02,5.01187e-03,
2.87714e+02,2.83285e+02,5.01190e-03,2.87710e+02,2.83280e+02,5.06991e-03,2.78960e+02,2.74608e+02,5.18800e-03,2.62185e+02,
2.57981e+02,5.24807e-03,2.54155e+02,2.50022e+02,5.37032e-03,2.38843e+02,2.34846e+02,5.55904e-03,2.17644e+02,2.13837e+02,
5.63397e-03,2.09959e+02,2.06221e+02,5.75440e-03,1.98369e+02,1.94740e+02,5.82103e-03,1.92258e+02,1.88686e+02,5.88844e-03,
1.86342e+02,1.82825e+02,6.00000e-03,1.77089e+02,1.73660e+02,6.02221e-03,1.75325e+02,1.71913e+02,6.09537e-03,1.69678e+02,
1.66322e+02,6.16595e-03,1.64451e+02,1.61147e+02,6.30957e-03,1.54491e+02,1.51287e+02,6.30960e-03,1.54489e+02,1.51285e+02,
6.38263e-03,1.49748e+02,1.46592e+02,6.45363e-03,1.45335e+02,1.42224e+02,6.53131e-03,1.40707e+02,1.37646e+02,6.68344e-03,
1.32223e+02,1.29254e+02,6.76083e-03,1.28149e+02,1.25224e+02,6.83912e-03,1.24180e+02,1.21298e+02,6.91831e-03,1.20336e+02,
1.17497e+02,6.95051e-03,1.18821e+02,1.15999e+02,7.07946e-03,1.13010e+02,1.10257e+02,7.16143e-03,1.09522e+02,1.06810e+02,
7.24436e-03,1.06135e+02,1.03464e+02,7.50797e-03,9.63035e+01,9.37535e+01,7.67362e-03,9.07547e+01,8.82783e+01,7.76247e-03,
8.79427e+01,8.55040e+01,7.85236e-03,8.52199e+01,8.28180e+01,7.94328e-03,8.25730e+01,8.02072e+01,7.94330e-03,8.25724e+01,
8.02067e+01,8.03154e-03,8.01105e+01,7.77788e+01,8.12830e-03,7.75237e+01,7.52300e+01,8.22243e-03,7.51203e+01,7.28624e+01,
8.31764e-03,7.27942e+01,7.05712e+01,8.64015e-03,6.56094e+01,6.34972e+01,8.70964e-03,6.41889e+01,6.21005e+01,8.81049e-03,
6.21898e+01,6.01352e+01,8.91251e-03,6.02552e+01,5.82337e+01,9.01571e-03,5.83802e+01,5.63911e+01,9.30949e-03,5.34504e+01,
5.15481e+01,9.33254e-03,5.30877e+01,5.11923e+01,9.44061e-03,5.14349e+01,4.95710e+01,9.54993e-03,4.98354e+01,4.80024e+01,
9.66051e-03,4.82873e+01,4.64845e+01,9.67078e-03,4.81468e+01,4.63468e+01,1.00000e-02,4.39205e+01,4.22099e+01,1.01158e-02,
4.25568e+01,4.08758e+01,1.02329e-02,4.12261e+01,3.95741e+01,1.02574e-02,4.09557e+01,3.93096e+01,1.03514e-02,3.99362e+01,
3.83145e+01,1.07152e-02,3.62918e+01,3.47584e+01,1.07210e-02,3.62377e+01,3.47056e+01,1.09648e-02,3.40504e+01,3.25777e+01,
1.10918e-02,3.29838e+01,3.15404e+01,1.10973e-02,3.29384e+01,3.14964e+01,1.13501e-02,3.09473e+01,2.95666e+01,1.14234e-02,
3.04008e+01,2.90371e+01,1.14815e-02,2.99743e+01,2.86255e+01,1.16145e-02,2.90299e+01,2.77145e+01,1.16815e-02,2.85694e+01,
2.72703e+01,1.17490e-02,2.81138e+01,2.68333e+01,1.18747e-02,2.72845e+01,2.60374e+01,1.20226e-02,2.63443e+01,2.51416e+01,
1.20258e-02,2.63245e+01,2.51227e+01,1.21425e-02,2.56050e+01,2.44434e+01,1.22018e-02,2.52457e+01,2.41077e+01,1.22530e-02,
2.49380e+01,2.38228e+01,1.23027e-02,2.46412e+01,2.35509e+01,1.23109e-02,2.45926e+01,2.35064e+01,1.23920e-02,2.41135e+01,
2.30732e+01,1.24773e-02,2.36214e+01,2.26291e+01,1.25271e-02,2.33458e+01,2.23750e+01,1.25654e-02,2.31425e+01,2.21823e+01,
1.25890e-02,2.30226e+01,2.20649e+01,1.25892e-02,2.30213e+01,2.20636e+01,1.26039e-02,2.29474e+01,2.19912e+01,1.26190e-02,
2.28737e+01,2.19166e+01,1.26190e-02,1.59729e+02,8.52287e+01,1.26375e-02,1.59222e+02,8.50595e+01,1.26781e-02,1.58123e+02,
8.46889e+01,1.27244e-02,1.56891e+02,8.42681e+01,1.27600e-02,1.55958e+02,8.39464e+01,1.28614e-02,1.52759e+02,8.27155e+01,
1.28825e-02,1.52103e+02,8.24620e+01,1.29280e-02,1.50704e+02,8.19182e+01,1.30001e-02,1.48516e+02,8.10649e+01,1.30317e-02,
1.47569e+02,8.06945e+01,1.30500e-02,1.47023e+02,8.04803e+01,1.30811e-02,1.46169e+02,8.01543e+01,1.31397e-02,1.44575e+02,
7.95444e+01,1.31826e-02,1.43422e+02,7.91010e+01,1.32503e-02,1.41627e+02,7.84065e+01,1.33352e-02,1.39418e+02,7.75458e+01,
1.33500e-02,1.39038e+02,7.73969e+01,1.34225e-02,1.37102e+02,7.66186e+01,1.36054e-02,1.32381e+02,7.46969e+01,1.36458e-02,
1.31367e+02,7.42797e+01,1.38243e-02,1.27013e+02,7.24682e+01,1.41254e-02,1.20105e+02,6.95300e+01,1.41873e-02,1.18773e+02,
6.89574e+01,1.46252e-02,1.09903e+02,6.50637e+01,1.52391e-02,9.89494e+01,6.00516e+01,1.53109e-02,9.77692e+01,5.94977e+01,
1.54882e-02,9.48481e+01,5.81018e+01,1.58489e-02,8.92679e+01,5.53880e+01,1.58490e-02,8.92669e+01,5.53875e+01,1.58747e-02,
8.88875e+01,5.52007e+01,1.60324e-02,8.66014e+01,5.40692e+01,1.64059e-02,8.15001e+01,5.15039e+01,1.65959e-02,7.90645e+01,
5.02666e+01,1.68768e-02,7.56422e+01,4.85051e+01,1.69824e-02,7.44080e+01,4.78635e+01,1.77828e-02,6.58599e+01,4.33137e+01,
1.79887e-02,6.38824e+01,4.22354e+01,1.81589e-02,6.23094e+01,4.13706e+01,1.81970e-02,6.19647e+01,4.11803e+01,1.84077e-02,
6.01046e+01,4.01480e+01,1.86209e-02,5.83009e+01,3.91382e+01,1.88365e-02,5.65518e+01,3.81505e+01,1.90546e-02,5.48532e+01,
3.71830e+01,1.92752e-02,5.32062e+01,3.62372e+01,1.94985e-02,5.16091e+01,3.53126e+01,1.95000e-02,5.15982e+01,3.53063e+01,
1.95157e-02,5.14862e+01,3.52408e+01,1.99526e-02,4.84911e+01,3.34791e+01,1.99530e-02,4.84886e+01,3.34776e+01,2.08930e-02,
4.28115e+01,3.00651e+01,2.11349e-02,4.15000e+01,2.92624e+01,2.14560e-02,3.98435e+01,2.82407e+01,2.16272e-02,3.89971e+01,
2.77153e+01,2.21309e-02,3.66463e+01,2.62434e+01,2.23872e-02,3.55237e+01,2.55336e+01,2.26464e-02,3.44360e+01,2.48416e+01,
2.29087e-02,3.33817e+01,2.41667e+01,2.32456e-02,3.20913e+01,2.33371e+01,2.34423e-02,3.13695e+01,2.28704e+01,2.37137e-02,
3.04093e+01,2.22464e+01,2.45471e-02,2.77036e+01,2.04682e+01,2.48313e-02,2.68401e+01,1.98927e+01,2.51189e-02,2.60040e+01,
1.93325e+01,2.51190e-02,2.60036e+01,1.93323e+01,2.55829e-02,2.47281e+01,1.84721e+01,2.57040e-02,2.44094e+01,1.82561e+01,
2.60016e-02,2.36493e+01,1.77393e+01,2.63027e-02,2.29124e+01,1.72357e+01,2.66073e-02,2.21987e+01,1.67456e+01,2.69154e-02,
2.15075e+01,1.62686e+01,2.75423e-02,2.01896e+01,1.53529e+01,2.77063e-02,1.98633e+01,1.51249e+01,2.81838e-02,1.89530e+01,
1.44861e+01,2.85102e-02,1.83636e+01,1.40703e+01,2.91743e-02,1.72400e+01,1.32725e+01,3.05492e-02,1.51977e+01,1.18044e+01,
3.09030e-02,1.47188e+01,1.14561e+01,3.09437e-02,1.46648e+01,1.14168e+01,3.16228e-02,1.38050e+01,1.07880e+01,3.16230e-02,
1.38048e+01,1.07878e+01,3.38844e-02,1.13944e+01,9.00096e+00,3.46737e-02,1.06901e+01,8.47157e+00,3.50752e-02,1.03546e+01,
8.21821e+00,3.53931e-02,1.00992e+01,8.02500e+00,3.67282e-02,9.11612e+00,7.27717e+00,3.75837e-02,8.55407e+00,6.84621e+00,
3.80189e-02,8.28645e+00,6.64011e+00,3.84592e-02,8.02374e+00,6.43696e+00,3.89045e-02,7.76958e+00,6.23988e+00,3.92393e-02,
7.58584e+00,6.09707e+00,3.98107e-02,7.28547e+00,5.86323e+00,3.98110e-02,7.28533e+00,5.86312e+00,4.12097e-02,6.61586e+00,
5.33950e+00,4.26579e-02,6.00936e+00,4.86163e+00,4.36516e-02,5.63709e+00,4.56658e+00,4.46684e-02,5.28815e+00,4.28874e+00,
4.51856e-02,5.12209e+00,4.15608e+00,4.67581e-02,4.65978e+00,3.78523e+00,4.67735e-02,4.65553e+00,3.78181e+00,4.78630e-02,
4.36585e+00,3.54807e+00,4.84172e-02,4.22809e+00,3.43660e+00,4.95450e-02,3.96598e+00,3.22390e+00,5.01187e-02,3.84133e+00,
3.12247e+00,5.01190e-02,3.84128e+00,3.12242e+00,5.24807e-02,3.38226e+00,2.74743e+00,5.30884e-02,3.27662e+00,2.66076e+00,
5.49541e-02,2.97997e+00,2.41661e+00,5.53706e-02,2.91899e+00,2.36627e+00,5.75440e-02,2.62758e+00,2.12529e+00,5.95662e-02,
2.39014e+00,1.92792e+00,6.16595e-02,2.17547e+00,1.74879e+00,6.30957e-02,2.04391e+00,1.63869e+00,6.30960e-02,2.04389e+00,
1.63867e+00,6.38264e-02,1.98123e+00,1.58628e+00,6.45654e-02,1.92055e+00,1.53551e+00,6.60693e-02,1.80510e+00,1.43878e+00,
6.82193e-02,1.65689e+00,1.31432e+00,7.16143e-02,1.45674e+00,1.14582e+00,7.32825e-02,1.37055e+00,1.07304e+00,7.67362e-02,
1.21465e+00,9.41143e-01,7.85236e-02,1.14423e+00,8.81464e-01,7.94328e-02,1.11073e+00,8.53049e-01,7.94330e-02,1.11072e+00,
8.53043e-01,8.03526e-02,1.07825e+00,8.25592e-01,8.93411e-02,8.25150e-01,6.11376e-01,9.22571e-02,7.62575e-01,5.58437e-01,
9.33254e-02,7.41528e-01,5.40632e-01,9.44061e-02,7.21171e-01,5.23413e-01,9.77237e-02,6.63704e-01,4.74788e-01,9.88553e-02,
6.45796e-01,4.59643e-01,1.00000e-01,6.28477e-01,4.44999e-01,1.01158e-01,6.11639e-01,4.30863e-01,1.03514e-01,5.79597e-01,
4.03981e-01,1.07079e-01,5.36180e-01,3.67611e-01,1.08393e-01,5.21536e-01,3.55380e-01,1.09648e-01,5.08168e-01,3.44224e-01,
1.14815e-01,4.58905e-01,3.03193e-01,1.21619e-01,4.05795e-01,2.59147e-01,1.23027e-01,3.96181e-01,2.51200e-01,1.24452e-01,
3.86876e-01,2.43519e-01,1.25890e-01,3.77887e-01,2.36107e-01,1.25893e-01,3.77872e-01,2.36095e-01,1.29061e-01,3.59262e-01,
2.20971e-01,1.30317e-01,3.52342e-01,2.15372e-01,1.33352e-01,3.36630e-01,2.02689e-01,1.42889e-01,2.95130e-01,1.69437e-01,
1.44544e-01,2.88957e-01,1.64527e-01,1.47911e-01,2.77186e-01,1.55196e-01,1.50000e-01,2.70374e-01,1.49816e-01,1.51356e-01,
2.66140e-01,1.46480e-01,1.53109e-01,2.60874e-01,1.42341e-01,1.58489e-01,2.46039e-01,1.30739e-01,1.58490e-01,2.46037e-01,
1.30737e-01,1.60324e-01,2.41338e-01,1.27159e-01,1.62367e-01,2.36336e-01,1.23363e-01,1.64059e-01,2.32356e-01,1.20358e-01,
1.69824e-01,2.19870e-01,1.10989e-01,1.73780e-01,2.12162e-01,1.05258e-01,1.75792e-01,2.08480e-01,1.02536e-01,1.77828e-01,
2.04937e-01,9.99318e-02,1.81970e-01,1.98161e-01,9.49816e-02,1.86209e-01,1.91778e-01,9.03554e-02,1.88365e-01,1.88726e-01,
8.81570e-02,1.90546e-01,1.85762e-01,8.60318e-02,1.97242e-01,1.77381e-01,8.00751e-02,1.99526e-01,1.74747e-01,7.82200e-02,
1.99530e-01,1.74742e-01,7.82170e-02,2.01837e-01,1.72141e-01,7.64572e-02,2.04174e-01,1.69608e-01,7.47531e-02,2.06538e-01,
1.67146e-01,7.31059e-02,2.08930e-01,1.64753e-01,7.15134e-02,2.11575e-01,1.62213e-01,6.98331e-02,2.18776e-01,1.55812e-01,
6.56544e-02,2.26464e-01,1.49724e-01,6.17500e-02,2.29087e-01,1.47821e-01,6.05503e-02,2.31740e-01,1.45967e-01,5.93898e-02,
2.34423e-01,1.44163e-01,5.82670e-02,2.37137e-01,1.42406e-01,5.71806e-02,2.39883e-01,1.40694e-01,5.61296e-02,2.51189e-01,
1.34282e-01,5.22595e-02,2.51190e-01,1.34281e-01,5.22591e-02,2.57040e-01,1.31235e-01,5.05622e-02,2.60016e-01,1.29767e-01,
4.97545e-02,2.63027e-01,1.28335e-01,4.89727e-02,2.66073e-01,1.26938e-01,4.82160e-02,2.78612e-01,1.21718e-01,4.54652e-02,
2.81838e-01,1.20487e-01,4.48304e-02,2.85102e-01,1.19286e-01,4.42163e-02,2.88403e-01,1.18112e-01,4.36213e-02,2.95121e-01,
1.15843e-01,4.24856e-02,3.00000e-01,1.14285e-01,4.17187e-02,3.05492e-01,1.12618e-01,4.09087e-02,3.16228e-01,1.09622e-01,
3.94942e-02,3.16230e-01,1.09622e-01,3.94939e-02,3.19889e-01,1.08634e-01,3.90771e-02,3.23594e-01,1.07665e-01,3.86722e-02,
3.31131e-01,1.05788e-01,3.78991e-02,3.34965e-01,1.04877e-01,3.75292e-02,3.46737e-01,1.02248e-01,3.64814e-02,3.50752e-01,
1.01412e-01,3.61582e-02,3.58922e-01,9.97852e-02,3.55379e-02,3.67282e-01,9.82172e-02,3.49503e-02,3.71535e-01,9.74548e-02,
3.46687e-02,3.80189e-01,9.59698e-02,3.41273e-02,3.84592e-01,9.52466e-02,3.38669e-02,3.89045e-01,9.45358e-02,3.36132e-02,
3.98107e-01,9.31600e-02,3.31344e-02,3.98110e-01,9.31596e-02,3.31343e-02,4.07380e-01,9.17765e-02,3.27257e-02,4.12098e-01,
9.11010e-02,3.25283e-02,4.14328e-01,9.07883e-02,3.24375e-02,4.16869e-01,9.04361e-02,3.23358e-02,4.21697e-01,8.97811e-02,
3.21477e-02,4.26580e-01,8.91361e-02,3.19636e-02,4.31519e-01,8.85008e-02,3.17835e-02,4.41570e-01,8.72662e-02,3.14423e-02,
4.51856e-01,8.60669e-02,3.11143e-02,4.57088e-01,8.54799e-02,3.09549e-02,4.62381e-01,8.49011e-02,3.07986e-02,4.78630e-01,
8.32130e-02,3.03474e-02,4.84172e-01,8.26687e-02,3.02054e-02,4.95450e-01,8.16010e-02,2.99282e-02,5.00000e-01,8.11847e-02,
2.98205e-02,5.01187e-01,8.10774e-02,2.97927e-02,5.01190e-01,8.10771e-02,2.97927e-02,5.06991e-01,8.05375e-02,2.96800e-02,
5.12861e-01,8.00043e-02,2.95685e-02,5.30884e-01,7.84441e-02,2.92427e-02,5.37032e-01,7.79391e-02,2.91391e-02,5.43250e-01,
7.74399e-02,2.90364e-02,5.49541e-01,7.69463e-02,2.89346e-02,5.62341e-01,7.59758e-02,2.87334e-02,5.68853e-01,7.54986e-02,
2.86340e-02,5.82103e-01,7.45604e-02,2.84379e-02,5.88844e-01,7.40988e-02,2.83409e-02,5.95662e-01,7.36443e-02,2.82465e-02,
6.02560e-01,7.31945e-02,2.81527e-02,6.16595e-01,7.23087e-02,2.79663e-02,6.19932e-01,7.21036e-02,2.79229e-02,6.23735e-01,
7.18723e-02,2.78738e-02,6.30957e-01,7.14402e-02,2.77817e-02,6.30960e-01,7.14400e-02,2.77817e-02,6.38264e-01,7.09919e-02,
2.77070e-02,6.45654e-01,7.05480e-02,2.76322e-02,6.60694e-01,6.96765e-02,2.74853e-02,6.76083e-01,6.88213e-02,2.73374e-02,
6.83912e-01,6.83997e-02,2.72630e-02,6.91831e-01,6.79822e-02,2.71885e-02,7.08570e-01,6.71273e-02,2.70330e-02,7.24436e-01,
6.63528e-02,2.68910e-02,7.32825e-01,6.59553e-02,2.68166e-02,7.41310e-01,6.55612e-02,2.67419e-02,7.49894e-01,6.51705e-02,
2.66669e-02,7.58578e-01,6.47832e-02,2.65916e-02,7.76247e-01,6.40186e-02,2.64401e-02,7.85236e-01,6.36422e-02,2.63650e-02,
7.94328e-01,6.32688e-02,2.62894e-02,7.94330e-01,6.32687e-02,2.62894e-02,8.03526e-01,6.28816e-02,2.62283e-02,8.31764e-01,
6.17387e-02,2.60402e-02,8.41395e-01,6.13640e-02,2.59760e-02,8.60994e-01,6.06236e-02,2.58455e-02,8.70964e-01,6.02585e-02,
2.57798e-02,8.91251e-01,5.95368e-02,2.56464e-02,9.01571e-01,5.91802e-02,2.55786e-02,9.12011e-01,5.88263e-02,2.55102e-02,
9.22571e-01,5.84751e-02,2.54411e-02,9.33254e-01,5.81266e-02,2.53714e-02,9.44061e-01,5.77809e-02,2.53011e-02,9.54993e-01,
5.74377e-02,2.52302e-02,9.66051e-01,5.70980e-02,2.51596e-02,9.77237e-01,5.67608e-02,2.50884e-02,9.88553e-01,5.64261e-02,
2.50166e-02,1.00000e+00,5.60938e-02,2.49442e-02,1.00000e-03,2.62050e+03,2.61689e+03,1.00103e-03,2.61419e+03,2.61058e+03,
1.02329e-03,2.48344e+03,2.47987e+03,1.03514e-03,2.41783e+03,2.41429e+03,1.05256e-03,2.32560e+03,2.32208e+03,1.05925e-03,
2.29147e+03,2.28796e+03,1.07152e-03,2.23033e+03,2.22685e+03,1.09648e-03,2.11316e+03,2.10973e+03,1.10490e-03,2.07557e+03,
2.07215e+03,1.12202e-03,2.00206e+03,1.99867e+03,1.13501e-03,1.94848e+03,1.94513e+03,1.14815e-03,1.89602e+03,1.89269e+03,
1.16145e-03,1.84501e+03,1.84171e+03,1.16164e-03,1.84428e+03,1.84098e+03,1.20226e-03,1.69930e+03,1.69611e+03,1.21112e-03,
1.66997e+03,1.66680e+03,1.23027e-03,1.60895e+03,1.60583e+03,1.25236e-03,1.54237e+03,1.53932e+03,1.25890e-03,1.52340e+03,
1.52037e+03,1.25892e-03,1.52333e+03,1.52029e+03,1.27000e-03,1.49187e+03,1.48887e+03,1.28825e-03,1.44184e+03,1.43890e+03,
1.29444e-03,1.42529e+03,1.42237e+03,1.32995e-03,1.33541e+03,1.33262e+03,1.33352e-03,1.32681e+03,1.32403e+03,1.34896e-03,
1.29054e+03,1.28782e+03,1.35770e-03,1.27068e+03,1.26800e+03,1.38038e-03,1.22107e+03,1.21849e+03,1.38546e-03,1.21038e+03,
1.20781e+03,1.39637e-03,1.18781e+03,1.18530e+03,1.40000e-03,1.18041e+03,1.17792e+03,1.40707e-03,1.16612e+03,1.16366e+03,
1.41254e-03,1.15525e+03,1.15282e+03,1.42685e-03,1.12712e+03,1.12477e+03,1.44544e-03,1.09199e+03,1.08975e+03,1.46004e-03,
1.06557e+03,1.06343e+03,1.47143e-03,1.04556e+03,1.04351e+03,1.48578e-03,1.02108e+03,1.01916e+03,1.49669e-03,1.00298e+03,
1.00118e+03,1.50606e-03,9.87769e+02,9.86091e+02,1.51310e-03,9.76532e+02,9.74959e+02,1.51356e-03,9.75803e+02,9.74238e+02,
1.51730e-03,9.69927e+02,9.68422e+02,1.52376e-03,9.59908e+02,9.58513e+02,1.53109e-03,9.48701e+02,9.47423e+02,1.53288e-03,
9.45992e+02,9.44741e+02,1.53724e-03,9.39445e+02,9.38250e+02,1.54047e-03,9.34637e+02,9.33472e+02,1.54190e-03,9.32528e+02,
9.31374e+02,1.54353e-03,9.30140e+02,9.28995e+02,1.54555e-03,9.27181e+02,9.26043e+02,1.54751e-03,9.24339e+02,9.23204e+02,
1.55029e-03,9.20325e+02,9.19187e+02,1.55269e-03,9.16895e+02,9.15746e+02,1.55360e-03,9.15596e+02,9.14440e+02,1.55360e-03,
3.49254e+03,3.44619e+03,1.55550e-03,3.50239e+03,3.45587e+03,1.55790e-03,3.51483e+03,3.46809e+03,1.56031e-03,3.52739e+03,
3.48042e+03,1.56350e-03,3.54403e+03,3.49675e+03,1.56482e-03,3.54861e+03,3.50123e+03,1.57000e-03,3.56665e+03,3.51888e+03,
1.57500e-03,3.58419e+03,3.53609e+03,1.57589e-03,3.58459e+03,3.53648e+03,1.58059e-03,3.58674e+03,3.53851e+03,1.58489e-03,
3.58870e+03,3.54037e+03,1.58490e-03,3.58870e+03,3.54037e+03,1.59000e-03,3.59112e+03,3.54271e+03,1.59567e-03,3.58631e+03,
3.53790e+03,1.60210e-03,3.58091e+03,3.53247e+03,1.60210e-03,4.16448e+03,4.10506e+03,1.60228e-03,4.18104e+03,4.12131e+03,
1.60250e-03,4.22902e+03,4.16840e+03,1.60270e-03,4.27274e+03,4.21130e+03,1.60300e-03,4.33831e+03,4.27566e+03,1.60330e-03,
4.40310e+03,4.33922e+03,1.60360e-03,4.46639e+03,4.40130e+03,1.60390e-03,4.52809e+03,4.46181e+03,1.60415e-03,4.57724e+03,
4.51007e+03,1.60450e-03,4.64260e+03,4.57421e+03,1.60470e-03,4.67823e+03,4.60917e+03,1.60500e-03,4.72840e+03,4.65838e+03,
1.60520e-03,4.75943e+03,4.68879e+03,1.60535e-03,4.77603e+03,4.70511e+03,1.60590e-03,4.81097e+03,4.73939e+03,1.60600e-03,
4.82452e+03,4.75272e+03,1.60680e-03,4.85998e+03,4.78744e+03,1.60695e-03,4.86438e+03,4.79175e+03,1.60710e-03,4.87357e+03,
4.80078e+03,1.60790e-03,4.91055e+03,4.83706e+03,1.60810e-03,4.91810e+03,4.84447e+03,1.61020e-03,4.95097e+03,4.87675e+03,
1.61050e-03,4.95849e+03,4.88415e+03,1.61300e-03,4.96873e+03,4.89411e+03,1.61600e-03,4.96222e+03,4.88774e+03,1.61729e-03,
4.95677e+03,4.88238e+03,1.62150e-03,4.93901e+03,4.86493e+03,1.62181e-03,4.93466e+03,4.86065e+03,1.62400e-03,4.92349e+03,
4.84966e+03,1.62589e-03,4.91104e+03,4.83742e+03,1.63000e-03,4.88402e+03,4.81085e+03,1.63154e-03,4.87275e+03,4.79978e+03,
1.63728e-03,4.83122e+03,4.75898e+03,1.64059e-03,4.80747e+03,4.73565e+03,1.64413e-03,4.78222e+03,4.71086e+03,1.64817e-03,
4.75373e+03,4.68288e+03,1.65563e-03,4.70161e+03,4.63172e+03,1.66493e-03,4.63777e+03,4.56906e+03,1.66500e-03,4.63727e+03,
4.56857e+03,1.67000e-03,4.60533e+03,4.53723e+03,1.67639e-03,4.56681e+03,4.49945e+03,1.68750e-03,4.50095e+03,4.43485e+03,
1.69824e-03,4.43854e+03,4.37364e+03,1.70134e-03,4.41927e+03,4.35473e+03,1.71000e-03,4.36607e+03,4.30254e+03,1.71383e-03,
4.34370e+03,4.28058e+03,1.72500e-03,4.27931e+03,4.21743e+03,1.73780e-03,4.20350e+03,4.14303e+03,1.74365e-03,4.16949e+03,
4.10964e+03,1.75000e-03,4.13299e+03,4.07381e+03,1.75249e-03,4.11812e+03,4.05921e+03,1.75792e-03,4.08601e+03,4.02767e+03,
1.76066e-03,4.06995e+03,4.01189e+03,1.76920e-03,4.02033e+03,3.96313e+03,1.76920e-03,4.57017e+03,4.50430e+03,1.77184e-03,
4.55412e+03,4.48854e+03,1.77828e-03,4.51534e+03,4.45045e+03,1.78000e-03,4.50505e+03,4.44034e+03,1.79427e-03,4.41963e+03,
4.35641e+03,1.80307e-03,4.36808e+03,4.30576e+03,1.81194e-03,4.31702e+03,4.25560e+03,1.81970e-03,4.27300e+03,4.21235e+03,
1.82180e-03,4.26124e+03,4.20079e+03,1.83624e-03,4.18161e+03,4.12258e+03,1.85387e-03,4.08716e+03,4.02979e+03,1.86899e-03,
4.00855e+03,3.95257e+03,1.88365e-03,3.93439e+03,3.87971e+03,1.89434e-03,3.88093e+03,3.82717e+03,1.90546e-03,3.82635e+03,
3.77354e+03,1.91000e-03,3.80440e+03,3.75198e+03,1.92753e-03,3.72012e+03,3.66914e+03,1.93765e-03,3.67259e+03,3.62242e+03,
1.94984e-03,3.61652e+03,3.56730e+03,1.95000e-03,3.61582e+03,3.56661e+03,1.97242e-03,3.51634e+03,3.46881e+03,1.98606e-03,
3.45778e+03,3.41122e+03,1.99526e-03,3.41903e+03,3.37313e+03,1.99530e-03,3.41887e+03,3.37297e+03,2.01837e-03,3.32441e+03,
3.28008e+03,2.04174e-03,3.23186e+03,3.18903e+03,2.04383e-03,3.22372e+03,3.18103e+03,2.06538e-03,3.14172e+03,3.10035e+03,
2.08930e-03,3.05412e+03,3.01416e+03,2.09656e-03,3.02806e+03,2.98851e+03,2.13796e-03,2.88533e+03,2.84803e+03,2.15000e-03,
2.84565e+03,2.80897e+03,2.16272e-03,2.80453e+03,2.76849e+03,2.18304e-03,2.74038e+03,2.70532e+03,2.18776e-03,2.72578e+03,
2.69094e+03,2.26464e-03,2.50281e+03,2.47134e+03,2.29087e-03,2.43270e+03,2.40227e+03,2.29293e-03,2.42732e+03,2.39696e+03,
2.31740e-03,2.36460e+03,2.33517e+03,2.34423e-03,2.29846e+03,2.26998e+03,2.37137e-03,2.23383e+03,2.20628e+03,2.39883e-03,
2.17026e+03,2.14361e+03,2.40834e-03,2.14885e+03,2.12249e+03,2.42661e-03,2.10855e+03,2.08276e+03,2.51189e-03,1.93362e+03,
1.91023e+03,2.51190e-03,1.93359e+03,1.91021e+03,2.54097e-03,1.87860e+03,1.85595e+03,2.57040e-03,1.82507e+03,1.80314e+03,
2.57780e-03,1.81194e+03,1.79018e+03,2.63027e-03,1.72266e+03,1.70208e+03,2.69154e-03,1.62402e+03,1.60470e+03,2.72270e-03,
1.57690e+03,1.55818e+03,2.72659e-03,1.57115e+03,1.55249e+03,2.75423e-03,1.53110e+03,1.51295e+03,2.85102e-03,1.40174e+03,
1.38518e+03,2.88403e-03,1.36113e+03,1.34507e+03,2.91743e-03,1.32174e+03,1.30615e+03,2.94915e-03,1.28550e+03,1.27034e+03,
3.01995e-03,1.20944e+03,1.19518e+03,3.09030e-03,1.14007e+03,1.12662e+03,3.12608e-03,1.10687e+03,1.09380e+03,3.16228e-03,
1.07467e+03,1.06196e+03,3.16230e-03,1.07465e+03,1.06194e+03,3.19889e-03,1.04342e+03,1.03106e+03,3.22223e-03,1.02385e+03,
1.01171e+03,3.23594e-03,1.01260e+03,1.00058e+03,3.31131e-03,9.53711e+02,9.42344e+02,3.34965e-03,9.25410e+02,9.14351e+02,
3.38844e-03,8.97956e+02,8.87193e+02,3.50752e-03,8.20530e+02,8.10589e+02,3.54813e-03,7.96236e+02,7.86549e+02,3.58922e-03,
7.72678e+02,7.63239e+02,3.63078e-03,7.49695e+02,7.40494e+02,3.67282e-03,7.27417e+02,7.18447e+02,3.75837e-03,6.84885e+02,
6.76351e+02,3.80189e-03,6.64452e+02,6.56124e+02,3.84592e-03,6.44581e+02,6.36452e+02,3.93550e-03,6.06657e+02,5.98905e+02,
3.95253e-03,5.99804e+02,5.92119e+02,3.98107e-03,5.88552e+02,5.80980e+02,3.98110e-03,5.88541e+02,5.80969e+02,4.00000e-03,
5.81247e+02,5.73748e+02,4.02717e-03,5.70978e+02,5.63581e+02,4.07380e-03,5.53939e+02,5.46710e+02,4.12097e-03,5.37424e+02,
5.30357e+02,4.16869e-03,5.21256e+02,5.14347e+02,4.21696e-03,5.05589e+02,4.98831e+02,4.26579e-03,4.90341e+02,4.83730e+02,
4.36516e-03,4.61117e+02,4.54786e+02,4.46684e-03,4.33686e+02,4.27620e+02,4.51856e-03,4.20596e+02,4.14655e+02,4.57088e-03,
4.07907e+02,4.02087e+02,4.62381e-03,3.95613e+02,3.89910e+02,4.73151e-03,3.72143e+02,3.66663e+02,4.81244e-03,3.55784e+02,
3.50458e+02,4.84172e-03,3.50109e+02,3.44838e+02,4.95450e-03,3.29126e+02,3.24056e+02,5.01187e-03,3.19127e+02,3.14152e+02,
5.01190e-03,3.19122e+02,3.14147e+02,5.12861e-03,2.99966e+02,2.95173e+02,5.24430e-03,2.82530e+02,2.77903e+02,5.24807e-03,
2.81985e+02,2.77363e+02,5.37032e-03,2.65110e+02,2.60653e+02,5.43250e-03,2.57068e+02,2.52690e+02,5.50000e-03,2.48716e+02,
2.44419e+02,5.55904e-03,2.41677e+02,2.37450e+02,5.62341e-03,2.34281e+02,2.30125e+02,5.68853e-03,2.27112e+02,2.23026e+02,
5.78379e-03,2.17139e+02,2.13151e+02,5.82103e-03,2.13403e+02,2.09454e+02,6.00000e-03,1.96657e+02,1.92878e+02,6.09537e-03,
1.88481e+02,1.84787e+02,6.16595e-03,1.82735e+02,1.79100e+02,6.23735e-03,1.77170e+02,1.73593e+02,6.30957e-03,1.71745e+02,
1.68224e+02,6.30960e-03,1.71743e+02,1.68222e+02,6.34390e-03,1.69232e+02,1.65737e+02,6.38263e-03,1.66455e+02,1.62991e+02,
6.53131e-03,1.56357e+02,1.53003e+02,6.60693e-03,1.51548e+02,1.48247e+02,6.81745e-03,1.39161e+02,1.35998e+02,6.83912e-03,
1.37966e+02,1.34816e+02,6.91831e-03,1.33723e+02,1.30623e+02,7.24436e-03,1.18060e+02,1.15147e+02,7.29054e-03,1.16038e+02,
1.13149e+02,7.41310e-03,1.10896e+02,1.08072e+02,7.49894e-03,1.07459e+02,1.04678e+02,7.59670e-03,1.03726e+02,1.00993e+02,
7.76247e-03,9.77902e+01,9.51359e+01,7.85236e-03,9.47610e+01,9.21479e+01,7.94328e-03,9.18331e+01,8.92602e+01,7.94330e-03,
9.18326e+01,8.92596e+01,8.19253e-03,8.44192e+01,8.19500e+01,8.22243e-03,8.35853e+01,8.11286e+01,8.31764e-03,8.10079e+01,
7.85899e+01,8.51138e-03,7.60652e+01,7.37224e+01,8.60994e-03,7.37119e+01,7.14055e+01,8.70964e-03,7.14307e+01,6.91600e+01,
8.81049e-03,6.92104e+01,6.69746e+01,8.85150e-03,6.83357e+01,6.61138e+01,9.01571e-03,6.49788e+01,6.28142e+01,9.12011e-03,
6.29642e+01,6.08344e+01,9.44061e-03,5.72851e+01,5.52558e+01,9.50000e-03,5.63117e+01,5.43000e+01,9.60263e-03,5.46731e+01,
5.26911e+01,9.77237e-03,5.21013e+01,5.01689e+01,9.88553e-03,5.04807e+01,4.85801e+01,9.98218e-03,4.91516e+01,4.72774e+01,
1.00000e-02,4.89117e+01,4.70424e+01,1.01158e-02,4.73920e+01,4.55545e+01,1.02329e-02,4.59195e+01,4.41131e+01,1.03473e-02,
4.45357e+01,4.27588e+01,1.03514e-02,4.44875e+01,4.27116e+01,1.07152e-02,4.04588e+01,3.87755e+01,1.08393e-02,3.91985e+01,
3.75448e+01,1.09638e-02,3.79872e+01,3.63623e+01,1.09648e-02,3.79783e+01,3.63535e+01,1.12202e-02,3.56321e+01,3.40680e+01,
1.13501e-02,3.45157e+01,3.29809e+01,1.14543e-02,3.36560e+01,3.21440e+01,1.16145e-02,3.23866e+01,3.09117e+01,1.17490e-02,
3.13724e+01,2.99274e+01,1.18679e-02,3.05114e+01,2.90920e+01,1.20226e-02,2.94359e+01,2.80520e+01,1.21787e-02,2.84008e+01,
2.70513e+01,1.24451e-02,2.67384e+01,2.54512e+01,1.25890e-02,2.58921e+01,2.46414e+01,1.25892e-02,2.58906e+01,2.46400e+01,
1.26484e-02,2.55530e+01,2.43169e+01,1.27350e-02,2.50657e+01,2.38535e+01,1.27574e-02,2.49413e+01,2.37351e+01,1.28246e-02,
2.45701e+01,2.33835e+01,1.28825e-02,2.42543e+01,2.30861e+01,1.28981e-02,2.41702e+01,2.30069e+01,1.29659e-02,2.38072e+01,
2.26675e+01,1.30243e-02,2.34973e+01,2.23804e+01,1.31044e-02,2.30750e+01,2.19942e+01,1.31826e-02,2.26663e+01,2.16264e+01,
1.31933e-02,2.26109e+01,2.15765e+01,1.32841e-02,2.21484e+01,2.11610e+01,1.33352e-02,2.18989e+01,2.09321e+01,1.33762e-02,
2.17069e+01,2.07509e+01,1.34182e-02,2.15190e+01,2.05675e+01,1.34350e-02,2.14471e+01,2.04948e+01,1.34350e-02,1.47619e+02,
7.59558e+01,1.34538e-02,1.47201e+02,7.58335e+01,1.34778e-02,1.46673e+02,7.56773e+01,1.35138e-02,1.45887e+02,7.54431e+01,
1.35694e-02,1.44695e+02,7.50825e+01,1.35900e-02,1.44258e+02,7.49491e+01,1.36458e-02,1.42696e+02,7.43841e+01,1.36829e-02,
1.41672e+02,7.40114e+01,1.37587e-02,1.39607e+02,7.32560e+01,1.38038e-02,1.38392e+02,7.28095e+01,1.38289e-02,1.37725e+02,
7.25632e+01,1.38737e-02,1.36539e+02,7.21247e+01,1.39000e-02,1.35848e+02,7.18689e+01,1.39747e-02,1.34086e+02,7.12405e+01,
1.41018e-02,1.31152e+02,7.01833e+01,1.41254e-02,1.30617e+02,6.99893e+01,1.42000e-02,1.28944e+02,6.93782e+01,1.42713e-02,
1.27280e+02,6.87492e+01,1.42889e-02,1.26874e+02,6.85950e+01,1.44502e-02,1.23234e+02,6.72004e+01,1.44544e-02,1.23141e+02,
6.71642e+01,1.46656e-02,1.18591e+02,6.53876e+01,1.49624e-02,1.12580e+02,6.29816e+01,1.49943e-02,1.11957e+02,6.27282e+01,
1.50000e-02,1.11847e+02,6.26833e+01,1.51356e-02,1.09258e+02,6.16223e+01,1.53109e-02,1.06080e+02,6.03085e+01,1.54882e-02,
1.02995e+02,5.90135e+01,1.54882e-02,1.02995e+02,5.90134e+01,1.58489e-02,9.70911e+01,5.64812e+01,1.58490e-02,9.70900e+01,
5.64807e+01,1.60324e-02,9.42679e+01,5.52438e+01,1.61780e-02,9.21098e+01,5.42940e+01,1.65959e-02,8.62827e+01,5.16775e+01,
1.67880e-02,8.36930e+01,5.04767e+01,1.69727e-02,8.13034e+01,4.93545e+01,1.69824e-02,8.11805e+01,4.92965e+01,1.73780e-02,
7.63791e+01,4.70007e+01,1.75792e-02,7.40870e+01,4.58849e+01,1.77828e-02,7.18618e+01,4.47886e+01,1.79548e-02,7.00531e+01,
4.38882e+01,1.79887e-02,6.97033e+01,4.37132e+01,1.88365e-02,6.17010e+01,3.96206e+01,1.94579e-02,5.66237e+01,3.69317e+01,
1.94985e-02,5.63128e+01,3.67647e+01,1.99526e-02,5.29861e+01,3.49595e+01,1.99530e-02,5.29834e+01,3.49580e+01,2.00000e-02,
5.26548e+01,3.47779e+01,2.04174e-02,4.98566e+01,3.32303e+01,2.06538e-02,4.83608e+01,3.23926e+01,2.08930e-02,4.69103e+01,
3.15734e+01,2.10438e-02,4.60054e+01,3.10564e+01,2.11349e-02,4.54707e+01,3.07498e+01,2.16272e-02,4.27226e+01,2.91589e+01,
2.21309e-02,4.01424e+01,2.76420e+01,2.29087e-02,3.65636e+01,2.54988e+01,2.31764e-02,3.54339e+01,2.48147e+01,2.37137e-02,
3.33062e+01,2.35132e+01,2.45471e-02,3.03375e+01,2.16662e+01,2.48313e-02,2.94086e+01,2.10807e+01,2.51189e-02,2.85086e+01,
2.05098e+01,2.51190e-02,2.85082e+01,2.05095e+01,2.54097e-02,2.76363e+01,1.99532e+01,2.55840e-02,2.71312e+01,1.96293e+01,
2.60016e-02,2.59711e+01,1.88813e+01,2.63027e-02,2.51768e+01,1.83655e+01,2.69154e-02,2.36313e+01,1.73506e+01,2.72270e-02,
2.28951e+01,1.68630e+01,2.78612e-02,2.14915e+01,1.59261e+01,2.81727e-02,2.08445e+01,1.54907e+01,2.85102e-02,2.01731e+01,
1.50370e+01,2.95121e-02,1.83468e+01,1.37903e+01,3.01995e-02,1.72233e+01,1.30142e+01,3.05492e-02,1.66881e+01,1.26418e+01,
3.12608e-02,1.56676e+01,1.19271e+01,3.13479e-02,1.55486e+01,1.18434e+01,3.16228e-02,1.51811e+01,1.15843e+01,3.16230e-02,
1.51808e+01,1.15841e+01,3.23594e-02,1.42535e+01,1.09267e+01,3.30000e-02,1.35092e+01,1.03950e+01,3.31131e-02,1.33813e+01,
1.03031e+01,3.46737e-02,1.17734e+01,9.13791e+00,3.51432e-02,1.13419e+01,8.82256e+00,3.54813e-02,1.10444e+01,8.60448e+00,
3.58922e-02,1.06972e+01,8.34914e+00,3.63078e-02,1.03611e+01,8.10111e+00,3.67282e-02,1.00358e+01,7.86014e+00,3.90831e-02,
8.45152e+00,6.67440e+00,3.93550e-02,8.29125e+00,6.55337e+00,3.98107e-02,8.03170e+00,6.35685e+00,3.98110e-02,8.03154e+00,
6.35673e+00,4.07380e-02,7.53703e+00,5.98084e+00,4.30000e-02,6.48213e+00,5.17030e+00,4.31519e-02,6.41880e+00,5.12129e+00,
4.33538e-02,6.33593e+00,5.05710e+00,4.36516e-02,6.21635e+00,4.96439e+00,4.51856e-02,5.64750e+00,4.52136e+00,4.62381e-02,
5.29837e+00,4.24773e+00,4.67735e-02,5.13226e+00,4.11707e+00,4.89779e-02,4.51930e+00,3.63214e+00,5.01187e-02,4.24184e+00,
3.41115e+00,5.01190e-02,4.24178e+00,3.41110e+00,5.12861e-02,3.97890e+00,3.20087e+00,5.18800e-02,3.85384e+00,3.10055e+00,
5.37032e-02,3.50268e+00,2.81779e+00,5.46607e-02,3.33612e+00,2.68311e+00,5.55904e-02,3.18478e+00,2.56052e+00,5.62341e-02,
3.08563e+00,2.48003e+00,6.09537e-02,2.47609e+00,1.98207e+00,6.16595e-02,2.40003e+00,1.91955e+00,6.23735e-02,2.32647e+00,
1.85899e+00,6.30957e-02,2.25459e+00,1.79969e+00,6.30960e-02,2.25457e+00,1.79967e+00,6.47514e-02,2.10125e+00,1.67320e+00,
6.83912e-02,1.81289e+00,1.43447e+00,7.67362e-02,1.33652e+00,1.03717e+00,7.85236e-02,1.25890e+00,9.72086e-01,7.94328e-02,
1.22169e+00,9.40828e-01,7.94330e-02,1.22168e+00,9.40822e-01,8.41395e-02,1.05285e+00,7.99269e-01,8.87924e-02,9.18530e-01,
6.86423e-01,9.22571e-02,8.34931e-01,6.16183e-01,9.33254e-02,8.11553e-01,5.96534e-01,9.77237e-02,7.25472e-01,5.24171e-01,
1.00000e-01,6.86544e-01,4.91448e-01,1.04713e-01,6.15733e-01,4.32332e-01,1.05925e-01,5.99449e-01,4.18750e-01,1.08393e-01,
5.68347e-01,3.92815e-01,1.08807e-01,5.63387e-01,3.88682e-01,1.09648e-01,5.53528e-01,3.80480e-01,1.16145e-01,4.86320e-01,
3.24669e-01,1.17490e-01,4.74159e-01,3.14593e-01,1.23027e-01,4.29328e-01,2.77523e-01,1.25890e-01,4.09044e-01,2.60798e-01,
1.25893e-01,4.09027e-01,2.60784e-01,1.28825e-01,3.89873e-01,2.45203e-01,1.31447e-01,3.74106e-01,2.32411e-01,1.33352e-01,
3.63359e-01,2.23727e-01,1.41254e-01,3.24459e-01,1.92447e-01,1.42889e-01,3.17402e-01,1.86803e-01,1.44544e-01,3.10568e-01,
1.81348e-01,1.47911e-01,2.97539e-01,1.70977e-01,1.51356e-01,2.85314e-01,1.61286e-01,1.58489e-01,2.63077e-01,1.43774e-01,
1.58490e-01,2.63075e-01,1.43773e-01,1.60324e-01,2.57883e-01,1.39788e-01,1.64059e-01,2.47968e-01,1.32209e-01,1.64615e-01,
2.46561e-01,1.31138e-01,1.65959e-01,2.43231e-01,1.28609e-01,1.73780e-01,2.25672e-01,1.15376e-01,1.75792e-01,2.21610e-01,
1.12339e-01,1.79887e-01,2.13909e-01,1.06626e-01,1.84077e-01,2.06657e-01,1.01284e-01,1.86209e-01,2.03191e-01,9.87454e-02,
1.90546e-01,1.96562e-01,9.39169e-02,1.92752e-01,1.93394e-01,9.16236e-02,1.94984e-01,1.90319e-01,8.94064e-02,1.99526e-01,
1.84433e-01,8.51897e-02,1.99530e-01,1.84429e-01,8.51864e-02,2.00000e-01,1.83837e-01,8.47778e-02,2.01837e-01,1.81570e-01,
8.32168e-02,2.08930e-01,1.73458e-01,7.76817e-02,2.11349e-01,1.70905e-01,7.59573e-02,2.15833e-01,1.66431e-01,7.29582e-02,
2.16272e-01,1.66009e-01,7.26777e-02,2.21309e-01,1.61374e-01,6.96110e-02,2.26464e-01,1.56991e-01,6.67434e-02,2.31740e-01,
1.52880e-01,6.40971e-02,2.34423e-01,1.50907e-01,6.28380e-02,2.37137e-01,1.48985e-01,6.16196e-02,2.39883e-01,1.47115e-01,
6.04406e-02,2.42661e-01,1.45295e-01,5.93015e-02,2.51189e-01,1.40116e-01,5.60993e-02,2.51190e-01,1.40115e-01,5.60988e-02,
2.54097e-01,1.38437e-01,5.51286e-02,2.60016e-01,1.35204e-01,5.32801e-02,2.63027e-01,1.33647e-01,5.24001e-02,2.66073e-01,
1.32129e-01,5.15482e-02,2.72270e-01,1.29229e-01,4.99503e-02,2.81838e-01,1.25133e-01,4.77359e-02,2.88403e-01,1.22562e-01,
4.63747e-02,2.91743e-01,1.21320e-01,4.57254e-02,2.95121e-01,1.20107e-01,4.50960e-02,2.97038e-01,1.19437e-01,4.47505e-02,
3.01995e-01,1.17761e-01,4.38945e-02,3.05492e-01,1.16626e-01,4.33211e-02,3.12608e-01,1.14451e-01,4.22439e-02,3.16228e-01,
1.13398e-01,4.17291e-02,3.16230e-01,1.13397e-01,4.17289e-02,3.19889e-01,1.12336e-01,4.12569e-02,3.23594e-01,1.11295e-01,
4.07985e-02,3.27341e-01,1.10277e-01,4.03544e-02,3.31131e-01,1.09280e-01,3.99233e-02,3.34965e-01,1.08303e-01,3.95047e-02,
3.42768e-01,1.06407e-01,3.87034e-02,3.46737e-01,1.05488e-01,3.83198e-02,3.54813e-01,1.03716e-01,3.75990e-02,3.58922e-01,
1.02856e-01,3.72534e-02,3.67282e-01,1.01183e-01,3.65899e-02,3.71535e-01,1.00370e-01,3.62720e-02,3.75837e-01,9.95715e-02,
3.59627e-02,3.89045e-01,9.72620e-02,3.50822e-02,3.93550e-01,9.65250e-02,3.48094e-02,3.98107e-01,9.58005e-02,3.45434e-02,
3.98110e-01,9.58000e-02,3.45432e-02,4.00000e-01,9.54944e-02,3.44458e-02,4.02717e-01,9.50611e-02,3.43081e-02,4.07380e-01,
9.43338e-02,3.40784e-02,4.12098e-01,9.36183e-02,3.38541e-02,4.16869e-01,9.29149e-02,3.36355e-02,4.17601e-01,9.28087e-02,
3.36027e-02,4.26580e-01,9.15399e-02,3.32134e-02,4.31519e-01,9.08685e-02,3.30094e-02,4.36516e-01,9.02119e-02,3.28144e-02,
4.41570e-01,8.95653e-02,3.26234e-02,4.51856e-01,8.83006e-02,3.22530e-02,4.62381e-01,8.70725e-02,3.18973e-02,4.67735e-01,
8.64721e-02,3.17250e-02,4.73151e-01,8.58802e-02,3.15560e-02,4.78630e-01,8.52966e-02,3.13902e-02,4.84172e-01,8.47248e-02,
3.12310e-02,4.95450e-01,8.36040e-02,3.09207e-02,5.01187e-01,8.30547e-02,3.07694e-02,5.01190e-01,8.30544e-02,3.07693e-02,
5.12861e-01,8.19316e-02,3.05161e-02,5.18800e-01,8.13811e-02,3.03924e-02,5.24808e-01,8.08375e-02,3.02703e-02,5.30884e-01,
8.03006e-02,3.01497e-02,5.37032e-01,7.97733e-02,3.00335e-02,5.43250e-01,7.92523e-02,2.99186e-02,5.55904e-01,7.82286e-02,
2.96923e-02,5.62341e-01,7.77257e-02,2.95809e-02,5.68853e-01,7.72285e-02,2.94704e-02,5.75440e-01,7.67373e-02,2.93613e-02,
5.88844e-01,7.57713e-02,2.91459e-02,5.95662e-01,7.52987e-02,2.90419e-02,6.02560e-01,7.48311e-02,2.89385e-02,6.09537e-01,
7.43685e-02,2.88359e-02,6.16595e-01,7.39108e-02,2.87339e-02,6.23735e-01,7.34579e-02,2.86326e-02,6.30957e-01,7.30097e-02,
2.85319e-02,6.30960e-01,7.30095e-02,2.85318e-02,6.38264e-01,7.25458e-02,2.84494e-02,6.43799e-01,7.22010e-02,2.83875e-02,
6.45654e-01,7.20866e-02,2.83669e-02,6.60694e-01,7.11852e-02,2.82056e-02,6.68344e-01,7.07411e-02,2.81249e-02,6.76083e-01,
7.03013e-02,2.80440e-02,6.83912e-01,6.98657e-02,2.79629e-02,6.91831e-01,6.94344e-02,2.78820e-02,7.08570e-01,6.85519e-02,
2.77135e-02,7.16143e-01,6.81666e-02,2.76400e-02,7.24436e-01,6.77530e-02,2.75603e-02,7.32825e-01,6.73431e-02,2.74803e-02,
7.41310e-01,6.69369e-02,2.74001e-02,7.49894e-01,6.65343e-02,2.73196e-02,7.58578e-01,6.61352e-02,2.72389e-02,7.76247e-01,
6.53477e-02,2.70772e-02,7.85236e-01,6.49603e-02,2.69971e-02,7.94328e-01,6.45761e-02,2.69168e-02,7.94330e-01,6.45761e-02,
2.69168e-02,8.03526e-01,6.41765e-02,2.68499e-02,8.12831e-01,6.37802e-02,2.67822e-02,8.22243e-01,6.33872e-02,2.67138e-02,
8.41395e-01,6.26109e-02,2.65749e-02,8.51138e-01,6.22277e-02,2.65046e-02,8.60994e-01,6.18477e-02,2.64337e-02,8.91251e-01,
6.07280e-02,2.62194e-02,9.01571e-01,6.03607e-02,2.61467e-02,9.12011e-01,5.99963e-02,2.60733e-02,9.22571e-01,5.96347e-02,
2.59995e-02,9.33254e-01,5.92760e-02,2.59250e-02,9.44061e-01,5.89201e-02,2.58500e-02,9.54993e-01,5.85670e-02,2.57746e-02,
9.66051e-01,5.82176e-02,2.56996e-02,9.77237e-01,5.78709e-02,2.56240e-02,9.88553e-01,5.75267e-02,2.55479e-02,1.00000e+00,
5.71851e-02,2.54713e-02,1.00000e-03,2.85071e+03,2.84685e+03,1.01158e-03,2.77545e+03,2.77160e+03,1.02565e-03,2.68776e+03,
2.68393e+03,1.05925e-03,2.49381e+03,2.49003e+03,1.08393e-03,2.36365e+03,2.35991e+03,1.08412e-03,2.36265e+03,2.35891e+03,
1.09648e-03,2.30083e+03,2.29712e+03,1.13501e-03,2.12110e+03,2.11745e+03,1.14156e-03,2.09255e+03,2.08890e+03,1.16145e-03,
2.00914e+03,2.00554e+03,1.19000e-03,1.89782e+03,1.89427e+03,1.20193e-03,1.85380e+03,1.85027e+03,1.20226e-03,1.85257e+03,
1.84905e+03,1.21619e-03,1.80236e+03,1.79887e+03,1.23027e-03,1.75355e+03,1.75009e+03,1.24451e-03,1.70612e+03,1.70270e+03,
1.25782e-03,1.66345e+03,1.66006e+03,1.25890e-03,1.66004e+03,1.65664e+03,1.25892e-03,1.65996e+03,1.65657e+03,1.27350e-03,
1.61504e+03,1.61168e+03,1.30912e-03,1.51229e+03,1.50901e+03,1.31826e-03,1.48741e+03,1.48416e+03,1.33352e-03,1.44711e+03,
1.44390e+03,1.35000e-03,1.40501e+03,1.40184e+03,1.35839e-03,1.38414e+03,1.38100e+03,1.36458e-03,1.36903e+03,1.36591e+03,
1.38038e-03,1.33153e+03,1.32845e+03,1.40054e-03,1.28594e+03,1.28292e+03,1.43869e-03,1.20547e+03,1.20257e+03,1.45000e-03,
1.18299e+03,1.18013e+03,1.46218e-03,1.15932e+03,1.15651e+03,1.46946e-03,1.14546e+03,1.14267e+03,1.47911e-03,1.12745e+03,
1.12471e+03,1.49258e-03,1.10281e+03,1.10011e+03,1.51797e-03,1.05837e+03,1.05579e+03,1.53109e-03,1.03639e+03,1.03387e+03,
1.53927e-03,1.02296e+03,1.02049e+03,1.54882e-03,1.00759e+03,1.00517e+03,1.56108e-03,9.88389e+02,9.86046e+02,1.57878e-03,
9.61537e+02,9.59316e+02,1.58489e-03,9.52499e+02,9.50328e+02,1.58490e-03,9.52489e+02,9.50318e+02,1.59224e-03,9.41796e+02,
9.39683e+02,1.60227e-03,9.27426e+02,9.25402e+02,1.61422e-03,9.10708e+02,9.08806e+02,1.62181e-03,9.00287e+02,8.98476e+02,
1.62367e-03,8.97755e+02,8.95966e+02,1.63112e-03,8.87703e+02,8.86016e+02,1.63551e-03,8.81850e+02,8.80228e+02,1.64059e-03,
8.75138e+02,8.73597e+02,1.64212e-03,8.73121e+02,8.71603e+02,1.65000e-03,8.62865e+02,8.61465e+02,1.65042e-03,8.62324e+02,
8.60930e+02,1.65496e-03,8.56454e+02,8.55118e+02,1.65810e-03,8.52436e+02,8.51132e+02,1.66162e-03,8.47974e+02,8.46698e+02,
1.66323e-03,8.45949e+02,8.44682e+02,1.66533e-03,8.43327e+02,8.42067e+02,1.66765e-03,8.40432e+02,8.39175e+02,1.67066e-03,
8.36723e+02,8.35462e+02,1.67340e-03,8.33368e+02,8.32095e+02,1.67340e-03,3.09250e+03,3.04767e+03,1.67362e-03,3.09534e+03,
3.05046e+03,1.67520e-03,3.11544e+03,3.07020e+03,1.67660e-03,3.12439e+03,3.07896e+03,1.67800e-03,3.13337e+03,3.08773e+03,
1.67815e-03,3.12486e+03,3.07935e+03,1.67880e-03,3.12660e+03,3.08109e+03,1.67996e-03,3.12974e+03,3.08416e+03,1.68403e-03,
3.14082e+03,3.09501e+03,1.69500e-03,3.17073e+03,3.12425e+03,1.69896e-03,3.17705e+03,3.13038e+03,1.70400e-03,3.18509e+03,
3.13820e+03,1.70423e-03,3.18521e+03,3.13831e+03,1.71400e-03,3.19035e+03,3.14327e+03,1.71547e-03,3.18982e+03,3.14274e+03,
1.71791e-03,3.18895e+03,3.14185e+03,1.72100e-03,3.18786e+03,3.14074e+03,1.72677e-03,3.17523e+03,3.12827e+03,1.72830e-03,
3.17189e+03,3.12497e+03,1.72830e-03,3.72048e+03,3.66217e+03,1.72851e-03,3.73857e+03,3.67988e+03,1.72870e-03,3.77979e+03,
3.72026e+03,1.72890e-03,3.82371e+03,3.76327e+03,1.72900e-03,3.84539e+03,3.78451e+03,1.72910e-03,3.86773e+03,3.80638e+03,
1.72940e-03,3.93358e+03,3.87086e+03,1.72950e-03,3.95161e+03,3.88850e+03,1.72960e-03,3.94733e+03,3.88424e+03,1.73000e-03,
3.98642e+03,3.92258e+03,1.73015e-03,3.99639e+03,3.93234e+03,1.73030e-03,4.01711e+03,3.95266e+03,1.73060e-03,4.04825e+03,
3.98317e+03,1.73070e-03,4.05454e+03,3.98931e+03,1.73085e-03,4.06072e+03,3.99532e+03,1.73100e-03,4.07369e+03,4.00803e+03,
1.73120e-03,4.08673e+03,4.02081e+03,1.73135e-03,4.09316e+03,4.02710e+03,1.73150e-03,4.10664e+03,4.04033e+03,1.73165e-03,
4.11324e+03,4.04679e+03,1.73180e-03,4.12221e+03,4.05558e+03,1.73200e-03,4.13045e+03,4.06364e+03,1.73215e-03,4.13444e+03,
4.06753e+03,1.73250e-03,4.15138e+03,4.08411e+03,1.73260e-03,4.15069e+03,4.08341e+03,1.73285e-03,4.15688e+03,4.08946e+03,
1.73320e-03,4.16986e+03,4.10218e+03,1.73335e-03,4.17294e+03,4.10519e+03,1.73350e-03,4.17960e+03,4.11172e+03,1.73365e-03,
4.18273e+03,4.11477e+03,1.73380e-03,4.18946e+03,4.12137e+03,1.73650e-03,4.22359e+03,4.15480e+03,1.73780e-03,4.23256e+03,
4.16356e+03,1.73800e-03,4.23395e+03,4.16491e+03,1.74300e-03,4.23794e+03,4.16882e+03,1.74400e-03,4.23766e+03,4.16853e+03,
1.74748e-03,4.23198e+03,4.16294e+03,1.75100e-03,4.22627e+03,4.15731e+03,1.75254e-03,4.22250e+03,4.15359e+03,1.75800e-03,
4.20920e+03,4.14049e+03,1.75925e-03,4.20433e+03,4.13571e+03,1.76749e-03,4.17249e+03,4.10448e+03,1.76800e-03,4.17051e+03,
4.10254e+03,1.77200e-03,4.15704e+03,4.08934e+03,1.77400e-03,4.14920e+03,4.08165e+03,1.78138e-03,4.12040e+03,4.05343e+03,
1.78500e-03,4.10639e+03,4.03969e+03,1.78700e-03,4.09948e+03,4.03293e+03,1.79070e-03,4.08351e+03,4.01727e+03,1.79800e-03,
4.05226e+03,3.98664e+03,1.80000e-03,4.04227e+03,3.97685e+03,1.80396e-03,4.02258e+03,3.95756e+03,1.81427e-03,3.97199e+03,
3.90801e+03,1.81970e-03,3.94568e+03,3.88225e+03,1.82804e-03,3.90571e+03,3.84311e+03,1.83500e-03,3.87283e+03,3.81092e+03,
1.84077e-03,3.84304e+03,3.78173e+03,1.84135e-03,3.84019e+03,3.77894e+03,1.85362e-03,3.78025e+03,3.72023e+03,1.86209e-03,
3.73969e+03,3.68050e+03,1.87000e-03,3.70231e+03,3.64389e+03,1.87350e-03,3.68561e+03,3.62754e+03,1.88160e-03,3.64742e+03,
3.59011e+03,1.88937e-03,3.61134e+03,3.55475e+03,1.89000e-03,3.60842e+03,3.55188e+03,1.89636e-03,3.57755e+03,3.52160e+03,
1.90230e-03,3.54909e+03,3.49367e+03,1.90230e-03,4.04206e+03,3.97805e+03,1.90707e-03,4.01790e+03,3.95437e+03,1.92753e-03,
3.91659e+03,3.85499e+03,1.93066e-03,3.90138e+03,3.84007e+03,1.94032e-03,3.85513e+03,3.79470e+03,1.94984e-03,3.81023e+03,
3.75066e+03,1.95000e-03,3.80951e+03,3.74995e+03,1.95022e-03,3.80847e+03,3.74893e+03,1.96299e-03,3.74951e+03,3.69111e+03,
1.97242e-03,3.70678e+03,3.64921e+03,1.97684e-03,3.68703e+03,3.62985e+03,1.99300e-03,3.61597e+03,3.56016e+03,1.99526e-03,
3.60618e+03,3.55056e+03,1.99530e-03,3.60601e+03,3.55040e+03,2.00000e-03,3.58579e+03,3.53057e+03,2.01321e-03,3.52938e+03,
3.47523e+03,2.01837e-03,3.50770e+03,3.45398e+03,2.03593e-03,3.43525e+03,3.38291e+03,2.04174e-03,3.41178e+03,3.35989e+03,
2.08289e-03,3.24770e+03,3.19889e+03,2.10000e-03,3.18274e+03,3.13514e+03,2.13539e-03,3.05423e+03,3.00899e+03,2.13796e-03,
3.04516e+03,3.00008e+03,2.16272e-03,2.95976e+03,2.91624e+03,2.18776e-03,2.87683e+03,2.83479e+03,2.19262e-03,2.86114e+03,
2.81939e+03,2.21310e-03,2.79627e+03,2.75567e+03,2.26464e-03,2.64197e+03,2.60409e+03,2.27845e-03,2.60247e+03,2.56527e+03,
2.31740e-03,2.49537e+03,2.46000e+03,2.34423e-03,2.42522e+03,2.39104e+03,2.37018e-03,2.36005e+03,2.32697e+03,2.42661e-03,
2.22661e+03,2.19574e+03,2.45471e-03,2.16418e+03,2.13432e+03,2.47555e-03,2.11900e+03,2.08987e+03,2.48313e-03,2.10289e+03,
2.07402e+03,2.51189e-03,2.04335e+03,2.01543e+03,2.51190e-03,2.04332e+03,2.01540e+03,2.54097e-03,1.98543e+03,1.95843e+03,
2.58152e-03,1.90812e+03,1.88231e+03,2.63027e-03,1.82061e+03,1.79616e+03,2.66073e-03,1.76885e+03,1.74518e+03,2.72270e-03,
1.66976e+03,1.64756e+03,2.74089e-03,1.64218e+03,1.62039e+03,2.75423e-03,1.62237e+03,1.60087e+03,2.81838e-03,1.53015e+03,
1.51000e+03,2.88403e-03,1.44317e+03,1.42425e+03,2.91743e-03,1.40125e+03,1.38291e+03,2.95121e-03,1.36045e+03,1.34268e+03,
3.05492e-03,1.24523e+03,1.22903e+03,3.09030e-03,1.20910e+03,1.19338e+03,3.12608e-03,1.17406e+03,1.15880e+03,3.14315e-03,
1.15783e+03,1.14279e+03,3.16228e-03,1.14002e+03,1.12521e+03,3.16230e-03,1.14000e+03,1.12519e+03,3.19889e-03,1.10675e+03,
1.09237e+03,3.27341e-03,1.04308e+03,1.02952e+03,3.34965e-03,9.83169e+02,9.70375e+02,3.37992e-03,9.60503e+02,9.47991e+02,
3.42768e-03,9.26182e+02,9.14099e+02,3.46737e-03,8.98974e+02,8.87228e+02,3.50752e-03,8.72589e+02,8.61167e+02,3.54813e-03,
8.46766e+02,8.35656e+02,3.58922e-03,8.21708e+02,8.10900e+02,3.67282e-03,7.73806e+02,7.63566e+02,3.68640e-03,7.66343e+02,
7.56191e+02,3.80189e-03,7.06700e+02,6.97248e+02,3.89045e-03,6.65325e+02,6.56351e+02,3.93550e-03,6.45515e+02,6.36767e+02,
3.98107e-03,6.26323e+02,6.17792e+02,3.98110e-03,6.26311e+02,6.17781e+02,4.02717e-03,6.07704e+02,5.99383e+02,4.05917e-03,
5.95150e+02,5.86969e+02,4.07380e-03,5.89529e+02,5.81411e+02,4.26579e-03,5.22176e+02,5.14808e+02,4.36516e-03,4.91510e+02,
4.84478e+02,4.41570e-03,4.76731e+02,4.69859e+02,4.46684e-03,4.62411e+02,4.55692e+02,4.50000e-03,4.53445e+02,4.46823e+02,
4.51856e-03,4.48513e+02,4.41943e+02,4.53872e-03,4.43213e+02,4.36699e+02,4.57088e-03,4.34934e+02,4.28510e+02,4.62381e-03,
4.21767e+02,4.15485e+02,5.00000e-03,3.42486e+02,3.37047e+02,5.01187e-03,3.40339e+02,3.34922e+02,5.01190e-03,3.40334e+02,
3.34917e+02,5.05170e-03,3.33224e+02,3.27882e+02,5.06991e-03,3.30039e+02,3.24731e+02,5.18800e-03,3.10393e+02,3.05295e+02,
5.24807e-03,3.00957e+02,2.95959e+02,5.37032e-03,2.82944e+02,2.78137e+02,5.43250e-03,2.74324e+02,2.69609e+02,5.68853e-03,
2.42472e+02,2.38094e+02,5.75440e-03,2.35072e+02,2.30771e+02,5.80013e-03,2.30123e+02,2.25875e+02,5.88844e-03,2.20961e+02,
2.16814e+02,5.95662e-03,2.14229e+02,2.10155e+02,6.00000e-03,2.10069e+02,2.06041e+02,6.09537e-03,2.01313e+02,1.97381e+02,
6.30957e-03,1.83385e+02,1.79651e+02,6.30960e-03,1.83383e+02,1.79649e+02,6.38263e-03,1.77774e+02,1.74102e+02,6.45654e-03,
1.72348e+02,1.68736e+02,6.51061e-03,1.68525e+02,1.64956e+02,6.53131e-03,1.67092e+02,1.63540e+02,6.60693e-03,1.62000e+02,
1.58507e+02,6.68344e-03,1.57036e+02,1.53602e+02,6.76083e-03,1.52198e+02,1.48821e+02,6.83912e-03,1.47513e+02,1.44190e+02,
6.91831e-03,1.42972e+02,1.39703e+02,7.05703e-03,1.35473e+02,1.32294e+02,7.07946e-03,1.34311e+02,1.31147e+02,7.41310e-03,
1.18525e+02,1.15560e+02,7.49894e-03,1.14888e+02,1.11970e+02,7.58227e-03,1.11506e+02,1.08631e+02,7.58578e-03,1.11367e+02,
1.08493e+02,7.67362e-03,1.07955e+02,1.05128e+02,7.76247e-03,1.04633e+02,1.01851e+02,7.94328e-03,9.82546e+01,9.55594e+01,
7.94330e-03,9.82540e+01,9.55589e+01,8.12830e-03,9.22685e+01,8.96566e+01,8.21919e-03,8.95157e+01,8.69426e+01,8.31764e-03,
8.66579e+01,8.41274e+01,8.60994e-03,7.88712e+01,7.64588e+01,8.81049e-03,7.40870e+01,7.17489e+01,8.86933e-03,7.27600e+01,
7.04429e+01,8.91251e-03,7.18061e+01,6.95049e+01,9.54993e-03,5.94248e+01,5.73354e+01,9.58652e-03,5.88077e+01,5.67292e+01,
9.77237e-03,5.58035e+01,5.37812e+01,9.88553e-03,5.40746e+01,5.20850e+01,9.97529e-03,5.27569e+01,5.07926e+01,1.00000e-02,
5.24018e+01,5.04445e+01,1.01158e-02,5.07806e+01,4.88558e+01,1.02329e-02,4.91993e+01,4.73063e+01,1.03514e-02,4.76684e+01,
4.58066e+01,1.03862e-02,4.72303e+01,4.53774e+01,1.04713e-02,4.61788e+01,4.43486e+01,1.10918e-02,3.94213e+01,3.77422e+01,
1.11420e-02,3.89360e+01,3.72681e+01,1.13501e-02,3.70079e+01,3.53884e+01,1.14815e-02,3.58561e+01,3.42659e+01,1.16145e-02,
3.47414e+01,3.31799e+01,1.17490e-02,3.36619e+01,3.21285e+01,1.17871e-02,3.33623e+01,3.18366e+01,1.18850e-02,3.26069e+01,
3.11025e+01,1.20226e-02,3.15854e+01,3.01101e+01,1.21619e-02,3.05930e+01,2.91460e+01,1.22979e-02,2.96658e+01,2.82457e+01,
1.25890e-02,2.78014e+01,2.64409e+01,1.25892e-02,2.77999e+01,2.64394e+01,1.27114e-02,2.70673e+01,2.57306e+01,1.30317e-02,
2.52612e+01,2.39902e+01,1.30481e-02,2.51730e+01,2.39053e+01,1.30560e-02,2.51306e+01,2.38646e+01,1.33199e-02,2.37680e+01,
2.25586e+01,1.33352e-02,2.36919e+01,2.24861e+01,1.34417e-02,2.31695e+01,2.19880e+01,1.34896e-02,2.29379e+01,2.17686e+01,
1.36209e-02,2.23198e+01,2.11830e+01,1.36458e-02,2.22043e+01,2.10745e+01,1.36916e-02,2.19922e+01,2.08751e+01,1.37594e-02,
2.16812e+01,2.05845e+01,1.38251e-02,2.13829e+01,2.03082e+01,1.38802e-02,2.11345e+01,2.00804e+01,1.39525e-02,2.08099e+01,
1.97865e+01,1.39637e-02,2.07596e+01,1.97417e+01,1.40000e-02,2.05973e+01,1.95968e+01,1.40786e-02,2.02514e+01,1.92875e+01,
1.41493e-02,1.99487e+01,1.90144e+01,1.41927e-02,1.97708e+01,1.88498e+01,1.42336e-02,1.96096e+01,1.86961e+01,1.42631e-02,
1.94977e+01,1.85863e+01,1.42800e-02,1.94360e+01,1.85239e+01,1.42800e-02,1.32028e+02,6.55919e+01,1.43038e-02,1.31619e+02,
6.54893e+01,1.43445e-02,1.30927e+02,6.53133e+01,1.43970e-02,1.30050e+02,6.50867e+01,1.44150e-02,1.29753e+02,6.50089e+01,
1.45390e-02,1.26800e+02,6.39973e+01,1.45754e-02,1.25950e+02,6.37034e+01,1.46434e-02,1.24381e+02,6.31580e+01,1.47237e-02,
1.22558e+02,6.25207e+01,1.47500e-02,1.21967e+02,6.23133e+01,1.47742e-02,1.21479e+02,6.21493e+01,1.48819e-02,1.19327e+02,
6.14232e+01,1.49624e-02,1.17751e+02,6.08858e+01,1.51356e-02,1.14453e+02,5.97460e+01,1.51378e-02,1.14410e+02,5.97310e+01,
1.53993e-02,1.09442e+02,5.79534e+01,1.54882e-02,1.07818e+02,5.73619e+01,1.56675e-02,1.04646e+02,5.61888e+01,1.57482e-02,
1.03260e+02,5.56694e+01,1.58000e-02,1.02384e+02,5.53392e+01,1.58489e-02,1.01565e+02,5.50289e+01,1.58490e-02,1.01564e+02,
5.50285e+01,1.60324e-02,9.85741e+01,5.38826e+01,1.61744e-02,9.63420e+01,5.30131e+01,1.62181e-02,9.56676e+01,5.27483e+01,
1.64059e-02,9.28867e+01,5.16516e+01,1.65959e-02,9.01863e+01,5.05685e+01,1.66737e-02,8.91125e+01,5.01328e+01,1.72180e-02,
8.20729e+01,4.72056e+01,1.73780e-02,8.01498e+01,4.63840e+01,1.75792e-02,7.78211e+01,4.53760e+01,1.77828e-02,7.54948e+01,
4.43442e+01,1.79887e-02,7.32382e+01,4.33294e+01,1.80125e-02,7.29831e+01,4.32138e+01,1.84077e-02,6.89247e+01,4.13521e+01,
1.86209e-02,6.68651e+01,4.03896e+01,1.88365e-02,6.48672e+01,3.94443e+01,1.90769e-02,6.27334e+01,3.84214e+01,1.92752e-02,
6.10448e+01,3.76027e+01,1.94985e-02,5.92185e+01,3.67075e+01,1.97242e-02,5.74332e+01,3.58205e+01,1.99526e-02,5.57025e+01,
3.49560e+01,1.99530e-02,5.56997e+01,3.49546e+01,2.01837e-02,5.40242e+01,3.41084e+01,2.04327e-02,5.22929e+01,3.32244e+01,
2.08930e-02,4.92886e+01,3.16670e+01,2.11349e-02,4.78047e+01,3.08861e+01,2.18776e-02,4.36181e+01,2.86405e+01,2.21309e-02,
4.23066e+01,2.79236e+01,2.21389e-02,4.22666e+01,2.79016e+01,2.23872e-02,4.10330e+01,2.72212e+01,2.29087e-02,3.85518e+01,
2.58287e+01,2.30000e-02,3.81387e+01,2.55946e+01,2.39194e-02,3.43001e+01,2.33854e+01,2.42661e-02,3.29900e+01,2.26177e+01,
2.45471e-02,3.19786e+01,2.20200e+01,2.48313e-02,3.09984e+01,2.14364e+01,2.51189e-02,3.00487e+01,2.08668e+01,2.51190e-02,
3.00483e+01,2.08665e+01,2.57040e-02,2.82362e+01,1.97683e+01,2.60016e-02,2.73710e+01,1.92383e+01,2.62615e-02,2.66451e+01,
1.87908e+01,2.66073e-02,2.57197e+01,1.82169e+01,2.72270e-02,2.41688e+01,1.72454e+01,2.75423e-02,2.34292e+01,1.67776e+01,
2.81838e-02,2.20176e+01,1.58767e+01,2.88403e-02,2.06669e+01,1.50018e+01,2.89815e-02,2.03914e+01,1.48221e+01,2.95121e-02,
1.93994e+01,1.41719e+01,3.00000e-02,1.85450e+01,1.36085e+01,3.01995e-02,1.82106e+01,1.33868e+01,3.12608e-02,1.65626e+01,
1.22837e+01,3.16228e-02,1.60476e+01,1.19354e+01,3.16230e-02,1.60473e+01,1.19352e+01,3.23594e-02,1.50657e+01,1.12665e+01,
3.23666e-02,1.50564e+01,1.12602e+01,3.34965e-02,1.37055e+01,1.03294e+01,3.42768e-02,1.28685e+01,9.74603e+00,3.50752e-02,
1.20834e+01,9.19396e+00,3.54813e-02,1.17032e+01,8.92438e+00,3.56002e-02,1.15950e+01,8.84747e+00,3.58922e-02,1.13350e+01,
8.66235e+00,3.71535e-02,1.02984e+01,7.91879e+00,3.84592e-02,9.35841e+00,7.23669e+00,3.90555e-02,8.96840e+00,6.95138e+00,
3.98107e-02,8.50560e+00,6.61131e+00,3.98110e-02,8.50543e+00,6.61118e+00,4.07380e-02,7.98123e+00,6.22375e+00,4.12097e-02,
7.73154e+00,6.03826e+00,4.26579e-02,7.02934e+00,5.51324e+00,4.31519e-02,6.80984e+00,5.34806e+00,4.36516e-02,6.59738e+00,
5.18768e+00,4.36658e-02,6.59140e+00,5.18315e+00,4.41570e-02,6.38888e+00,5.02966e+00,4.84172e-02,4.94706e+00,3.92351e+00,
5.01187e-02,4.49717e+00,3.57346e+00,5.01190e-02,4.49711e+00,3.57340e+00,5.06991e-02,4.35671e+00,3.46372e+00,5.12861e-02,
4.22067e+00,3.35718e+00,5.24807e-02,3.96168e+00,3.15365e+00,5.33773e-02,3.78176e+00,3.01170e+00,5.37032e-02,3.71915e+00,
2.96224e+00,5.43250e-02,3.60240e+00,2.86975e+00,5.82103e-02,2.97792e+00,2.37160e+00,5.95662e-02,2.79595e+00,2.22530e+00,
6.09537e-02,2.62569e+00,2.08793e+00,6.09638e-02,2.62450e+00,2.08697e+00,6.30957e-02,2.39025e+00,1.89726e+00,6.30960e-02,
2.39022e+00,1.89724e+00,6.38264e-02,2.31675e+00,1.83764e+00,6.68344e-02,2.04600e+00,1.61724e+00,6.76083e-02,1.98314e+00,
1.56584e+00,7.07946e-02,1.75176e+00,1.37603e+00,7.16143e-02,1.69859e+00,1.33228e+00,7.49894e-02,1.50283e+00,1.17075e+00,
7.58578e-02,1.45780e+00,1.13349e+00,7.85236e-02,1.33142e+00,1.02871e+00,7.94328e-02,1.29203e+00,9.95991e-01,7.94330e-02,
1.29202e+00,9.95985e-01,8.51138e-02,1.08090e+00,8.20745e-01,8.76701e-02,1.00200e+00,7.55025e-01,8.81049e-02,9.89444e-01,
7.44571e-01,9.12011e-02,9.06655e-01,6.75569e-01,9.33254e-02,8.55901e-01,6.33227e-01,9.44061e-02,8.31748e-01,6.13067e-01,
1.00000e-01,7.22379e-01,5.21735e-01,1.01158e-01,7.02533e-01,5.05250e-01,1.07152e-01,6.12601e-01,4.30580e-01,1.07372e-01,
6.09657e-01,4.28137e-01,1.08393e-01,5.96315e-01,4.17082e-01,1.10918e-01,5.65306e-01,3.91400e-01,1.13501e-01,5.36277e-01,
3.67377e-01,1.14815e-01,5.22464e-01,3.55953e-01,1.17490e-01,4.96164e-01,3.34220e-01,1.18850e-01,4.83628e-01,3.23867e-01,
1.24452e-01,4.37407e-01,2.85758e-01,1.25890e-01,4.26784e-01,2.77016e-01,1.25893e-01,4.26766e-01,2.77001e-01,1.28540e-01,
4.08271e-01,2.61957e-01,1.30317e-01,3.96634e-01,2.52523e-01,1.36458e-01,3.60728e-01,2.23507e-01,1.39637e-01,3.44444e-01,
2.10401e-01,1.41254e-01,3.36686e-01,2.04172e-01,1.42889e-01,3.29175e-01,1.98150e-01,1.44544e-01,3.21901e-01,1.92328e-01,
1.53109e-01,2.88828e-01,1.65991e-01,1.56675e-01,2.77006e-01,1.56641e-01,1.58489e-01,2.71371e-01,1.52198e-01,1.58490e-01,
2.71369e-01,1.52196e-01,1.59015e-01,2.69765e-01,1.50956e-01,1.60324e-01,2.65844e-01,1.47932e-01,1.62181e-01,2.60485e-01,
1.43809e-01,1.64059e-01,2.55290e-01,1.39823e-01,1.65959e-01,2.50255e-01,1.35970e-01,1.67880e-01,2.45375e-01,1.32245e-01,
1.69824e-01,2.40644e-01,1.28644e-01,1.75792e-01,2.27300e-01,1.18547e-01,1.79887e-01,2.19117e-01,1.12415e-01,1.81970e-01,
2.15208e-01,1.09499e-01,1.86209e-01,2.07737e-01,1.03954e-01,1.90546e-01,2.00702e-01,9.87692e-02,1.94984e-01,1.94076e-01,
9.39205e-02,1.99526e-01,1.87834e-01,8.93871e-02,1.99530e-01,1.87829e-01,8.93835e-02,2.00000e-01,1.87202e-01,8.89436e-02,
2.06538e-01,1.78998e-01,8.32220e-02,2.07427e-01,1.77953e-01,8.24980e-02,2.08930e-01,1.76217e-01,8.13013e-02,2.11349e-01,
1.73513e-01,7.94441e-02,2.13796e-01,1.70886e-01,7.76480e-02,2.16272e-01,1.68334e-01,7.59132e-02,2.21309e-01,1.63444e-01,
7.26130e-02,2.23872e-01,1.61121e-01,7.10639e-02,2.34423e-01,1.52447e-01,6.53534e-02,2.37137e-01,1.50423e-01,6.40395e-02,
2.39883e-01,1.48454e-01,6.27679e-02,2.42661e-01,1.46537e-01,6.15377e-02,2.51189e-01,1.41085e-01,5.80795e-02,2.51190e-01,
1.41084e-01,5.80790e-02,2.54097e-01,1.39322e-01,5.70282e-02,2.57040e-01,1.37604e-01,5.60108e-02,2.60016e-01,1.35931e-01,
5.50275e-02,2.63027e-01,1.34315e-01,5.40907e-02,2.66073e-01,1.32740e-01,5.31834e-02,2.69154e-01,1.31203e-01,5.23047e-02,
2.72270e-01,1.29704e-01,5.14535e-02,2.81838e-01,1.25421e-01,4.90561e-02,2.85102e-01,1.24061e-01,4.83064e-02,2.91743e-01,
1.21434e-01,4.68761e-02,3.00000e-01,1.18412e-01,4.52584e-02,3.00006e-01,1.18409e-01,4.52573e-02,3.01995e-01,1.17719e-01,
4.48924e-02,3.05492e-01,1.16549e-01,4.42823e-02,3.12608e-01,1.14286e-01,4.31162e-02,3.16228e-01,1.13192e-01,4.25590e-02,
3.16230e-01,1.13191e-01,4.25587e-02,3.19889e-01,1.12090e-01,4.20450e-02,3.23594e-01,1.11011e-01,4.15462e-02,3.27341e-01,
1.09956e-01,4.10622e-02,3.31131e-01,1.08923e-01,4.05925e-02,3.34965e-01,1.07911e-01,4.01366e-02,3.38844e-01,1.06921e-01,
3.96940e-02,3.42768e-01,1.05950e-01,3.92641e-02,3.46737e-01,1.05009e-01,3.88555e-02,3.54813e-01,1.03181e-01,3.80720e-02,
3.58922e-01,1.02294e-01,3.76965e-02,3.63078e-01,1.01423e-01,3.73312e-02,3.67282e-01,1.00570e-01,3.69760e-02,3.71535e-01,
9.97325e-02,3.66304e-02,3.75837e-01,9.89110e-02,3.62941e-02,3.80189e-01,9.81048e-02,3.59669e-02,3.84592e-01,9.73135e-02,
3.56483e-02,3.89045e-01,9.65433e-02,3.53447e-02,3.98107e-01,9.50449e-02,3.47616e-02,3.98110e-01,9.50444e-02,3.47614e-02,
4.00000e-01,9.47318e-02,3.46550e-02,4.00533e-01,9.46443e-02,3.46253e-02,4.02717e-01,9.42882e-02,3.45047e-02,4.07380e-01,
9.35439e-02,3.42541e-02,4.16869e-01,9.20924e-02,3.37708e-02,4.21697e-01,9.13847e-02,3.35378e-02,4.26580e-01,9.06886e-02,
3.33103e-02,4.31519e-01,9.00037e-02,3.30881e-02,4.36516e-01,8.93350e-02,3.28759e-02,4.41570e-01,8.86772e-02,3.26688e-02,
4.62381e-01,8.61445e-02,3.18833e-02,4.67735e-01,8.55347e-02,3.16969e-02,4.73151e-01,8.49340e-02,3.15142e-02,4.78630e-01,
8.43421e-02,3.13352e-02,4.84172e-01,8.37625e-02,3.11635e-02,4.89779e-01,8.31915e-02,3.09952e-02,5.01187e-01,8.20727e-02,
3.06676e-02,5.01190e-01,8.20725e-02,3.06676e-02,5.12861e-01,8.09385e-02,3.03915e-02,5.18800e-01,8.03826e-02,3.02565e-02,
5.24808e-01,7.98339e-02,3.01235e-02,5.30884e-01,7.92922e-02,2.99924e-02,5.37032e-01,7.87607e-02,2.98663e-02,5.43250e-01,
7.82361e-02,2.97421e-02,5.55904e-01,7.72058e-02,2.94980e-02,5.62341e-01,7.66999e-02,2.93780e-02,5.68853e-01,7.62001e-02,
2.92594e-02,5.75440e-01,7.57061e-02,2.91421e-02,5.82103e-01,7.52179e-02,2.90260e-02,5.88844e-01,7.47354e-02,2.89111e-02,
5.93950e-01,7.43790e-02,2.88275e-02,5.95662e-01,7.42608e-02,2.87998e-02,6.02560e-01,7.37915e-02,2.86898e-02,6.09537e-01,
7.33273e-02,2.85806e-02,6.16595e-01,7.28683e-02,2.84724e-02,6.23735e-01,7.24142e-02,2.83649e-02,6.30957e-01,7.19649e-02,
2.82583e-02,6.30960e-01,7.19648e-02,2.82583e-02,6.38264e-01,7.15002e-02,2.81702e-02,6.45654e-01,7.10403e-02,2.80822e-02,
6.53131e-01,7.05872e-02,2.79965e-02,6.60694e-01,7.01388e-02,2.79109e-02,6.68344e-01,6.96951e-02,2.78255e-02,6.83912e-01,
6.88208e-02,2.76549e-02,6.99842e-01,6.79635e-02,2.74844e-02,7.07946e-01,6.75412e-02,2.73993e-02,7.08570e-01,6.75090e-02,
2.73927e-02,7.16143e-01,6.71247e-02,2.73159e-02,7.24436e-01,6.67123e-02,2.72326e-02,7.49894e-01,6.54980e-02,2.69826e-02,
7.67362e-01,6.47068e-02,2.68153e-02,7.76247e-01,6.43165e-02,2.67315e-02,7.85236e-01,6.39309e-02,2.66489e-02,7.94328e-01,
6.35487e-02,2.65662e-02,7.94330e-01,6.35486e-02,2.65662e-02,8.00000e-01,6.33028e-02,2.65231e-02,8.03526e-01,6.31515e-02,
2.64964e-02,8.31764e-01,6.19806e-02,2.62837e-02,8.51138e-01,6.12164e-02,2.61391e-02,8.60994e-01,6.08391e-02,2.60659e-02,
8.81049e-01,6.00956e-02,2.59198e-02,9.01571e-01,5.93644e-02,2.57717e-02,9.22571e-01,5.86449e-02,2.56214e-02,9.33254e-01,
5.82895e-02,2.55456e-02,9.44061e-01,5.79369e-02,2.54693e-02,9.54993e-01,5.75870e-02,2.53925e-02,9.77237e-01,5.68978e-02,
2.52399e-02,9.88553e-01,5.65571e-02,2.51629e-02,1.00000e+00,5.62191e-02,2.50853e-02,1.00000e-03,3.17063e+03,3.16651e+03,
1.01158e-03,3.08739e+03,3.08329e+03,1.03830e-03,2.90693e+03,2.90287e+03,1.05925e-03,2.77578e+03,2.77176e+03,1.07152e-03,
2.70280e+03,2.69880e+03,1.08393e-03,2.63087e+03,2.62688e+03,1.09648e-03,2.56096e+03,2.55699e+03,1.09806e-03,2.55236e+03,
2.54840e+03,1.10918e-03,2.49302e+03,2.48907e+03,1.11000e-03,2.48870e+03,2.48475e+03,1.12202e-03,2.42670e+03,2.42277e+03,
1.15000e-03,2.29090e+03,2.28701e+03,1.15278e-03,2.27801e+03,2.27413e+03,1.16145e-03,2.23843e+03,2.23457e+03,1.18850e-03,
2.12056e+03,2.11674e+03,1.20226e-03,2.06364e+03,2.05984e+03,1.21619e-03,2.00805e+03,2.00427e+03,1.25890e-03,1.85004e+03,
1.84635e+03,1.25892e-03,1.84996e+03,1.84626e+03,1.27775e-03,1.78619e+03,1.78252e+03,1.30317e-03,1.70491e+03,1.70130e+03,
1.31826e-03,1.65888e+03,1.65530e+03,1.34326e-03,1.58593e+03,1.58240e+03,1.34896e-03,1.56991e+03,1.56640e+03,1.35000e-03,
1.56703e+03,1.56352e+03,1.35540e-03,1.55207e+03,1.54857e+03,1.39637e-03,1.44476e+03,1.44136e+03,1.40039e-03,1.43483e+03,
1.43144e+03,1.45000e-03,1.31998e+03,1.31671e+03,1.45289e-03,1.31368e+03,1.31041e+03,1.49624e-03,1.22393e+03,1.22078e+03,
1.49910e-03,1.21829e+03,1.21515e+03,1.50000e-03,1.21652e+03,1.21339e+03,1.51356e-03,1.19017e+03,1.18708e+03,1.54198e-03,
1.13745e+03,1.13444e+03,1.54882e-03,1.12526e+03,1.12227e+03,1.56675e-03,1.09418e+03,1.09125e+03,1.57674e-03,1.07743e+03,
1.07453e+03,1.58489e-03,1.06402e+03,1.06115e+03,1.58490e-03,1.06401e+03,1.06114e+03,1.60325e-03,1.03468e+03,1.03188e+03,
1.60905e-03,1.02558e+03,1.02281e+03,1.62181e-03,1.00597e+03,1.00324e+03,1.63616e-03,9.84581e+02,9.81919e+02,1.65959e-03,
9.50999e+02,9.48449e+02,1.66102e-03,9.48991e+02,9.46448e+02,1.67880e-03,9.24560e+02,9.22117e+02,1.68474e-03,9.16583e+02,
9.14172e+02,1.69824e-03,8.98797e+02,8.96473e+02,1.70480e-03,8.90310e+02,8.88027e+02,1.71658e-03,8.75323e+02,8.73128e+02,
1.72862e-03,8.60351e+02,8.58255e+02,1.73780e-03,8.49166e+02,8.47160e+02,1.74082e-03,8.45536e+02,8.43559e+02,1.75088e-03,
8.33596e+02,8.31733e+02,1.75927e-03,8.23792e+02,8.22038e+02,1.76591e-03,8.16140e+02,8.14479e+02,1.77828e-03,8.02156e+02,
8.00664e+02,1.77903e-03,8.01309e+02,7.99827e+02,1.78282e-03,7.97063e+02,7.95623e+02,1.78672e-03,7.92742e+02,7.91338e+02,
1.79055e-03,7.88525e+02,7.87145e+02,1.79271e-03,7.86176e+02,7.84806e+02,1.79715e-03,7.81377e+02,7.80012e+02,1.80062e-03,
7.77671e+02,7.76299e+02,1.80368e-03,7.74429e+02,7.73043e+02,1.80510e-03,7.72930e+02,7.71534e+02,1.80510e-03,3.08173e+03,
3.03155e+03,1.80513e-03,3.08160e+03,3.03142e+03,1.80798e-03,3.07081e+03,3.02085e+03,1.81295e-03,3.05211e+03,3.00251e+03,
1.81857e-03,3.03120e+03,2.98199e+03,1.82940e-03,2.99149e+03,2.94301e+03,1.83384e-03,2.97540e+03,2.92721e+03,1.83884e-03,
2.95749e+03,2.90963e+03,1.85000e-03,2.91799e+03,2.87084e+03,1.86209e-03,2.87608e+03,2.82966e+03,1.86496e-03,2.86625e+03,
2.82000e+03,1.86710e-03,2.85896e+03,2.81283e+03,1.86710e-03,3.97115e+03,3.89959e+03,1.88254e-03,3.89713e+03,3.82713e+03,
1.88365e-03,3.89190e+03,3.82201e+03,1.88714e-03,3.87547e+03,3.80592e+03,1.89334e-03,3.84654e+03,3.77760e+03,1.89500e-03,
3.83883e+03,3.77006e+03,1.90000e-03,3.81671e+03,3.74841e+03,1.90101e-03,3.81244e+03,3.74423e+03,1.90546e-03,3.79370e+03,
3.72590e+03,1.90738e-03,3.78568e+03,3.71805e+03,1.91404e-03,3.75794e+03,3.69092e+03,1.92000e-03,3.73340e+03,3.66694e+03,
1.92407e-03,3.71502e+03,3.64895e+03,1.92753e-03,3.69952e+03,3.63380e+03,1.93608e-03,3.66150e+03,3.59662e+03,1.94978e-03,
3.60178e+03,3.53823e+03,1.94984e-03,3.60150e+03,3.53795e+03,1.96214e-03,3.54908e+03,3.48671e+03,1.97242e-03,3.50604e+03,
3.44464e+03,1.97732e-03,3.48579e+03,3.42484e+03,1.99133e-03,3.42875e+03,3.36909e+03,1.99526e-03,3.41298e+03,3.35368e+03,
1.99530e-03,3.41283e+03,3.35353e+03,2.01837e-03,3.31945e+03,3.26223e+03,2.02273e-03,3.30153e+03,3.24471e+03,2.03123e-03,
3.26694e+03,3.21087e+03,2.03989e-03,3.23229e+03,3.17695e+03,2.04800e-03,3.20031e+03,3.14562e+03,2.04800e-03,3.65533e+03,
3.59191e+03,2.05191e-03,3.63881e+03,3.57575e+03,2.06538e-03,3.58268e+03,3.52079e+03,2.07655e-03,3.53706e+03,3.47613e+03,
2.08700e-03,3.49513e+03,3.43507e+03,2.08930e-03,3.48602e+03,3.42615e+03,2.09738e-03,3.45418e+03,3.39498e+03,2.10941e-03,
3.40757e+03,3.34936e+03,2.11000e-03,3.40529e+03,3.34713e+03,2.11349e-03,3.39169e+03,3.33381e+03,2.12275e-03,3.35536e+03,
3.29824e+03,2.13768e-03,3.29793e+03,3.24203e+03,2.15500e-03,3.23305e+03,3.17851e+03,2.15848e-03,3.22016e+03,3.16589e+03,
2.16272e-03,3.20458e+03,3.15064e+03,2.17941e-03,3.14423e+03,3.09155e+03,2.18776e-03,3.11464e+03,3.06258e+03,2.21310e-03,
3.02713e+03,2.97688e+03,2.22779e-03,2.97800e+03,2.92875e+03,2.23872e-03,2.94214e+03,2.89363e+03,2.26464e-03,2.85926e+03,
2.81243e+03,2.28608e-03,2.79341e+03,2.74791e+03,2.31740e-03,2.70101e+03,2.65736e+03,2.34634e-03,2.61945e+03,2.57741e+03,
2.37137e-03,2.55167e+03,2.51096e+03,2.41811e-03,2.43085e+03,2.39247e+03,2.42661e-03,2.40972e+03,2.37175e+03,2.45471e-03,
2.34181e+03,2.30514e+03,2.48313e-03,2.27571e+03,2.24027e+03,2.51189e-03,2.21154e+03,2.17730e+03,2.51190e-03,2.21151e+03,
2.17727e+03,2.51772e-03,2.19882e+03,2.16482e+03,2.54097e-03,2.14918e+03,2.11609e+03,2.60016e-03,2.02953e+03,1.99862e+03,
2.63440e-03,1.96460e+03,1.93485e+03,2.66073e-03,1.91664e+03,1.88773e+03,2.69154e-03,1.86261e+03,1.83465e+03,2.72270e-03,
1.80960e+03,1.78256e+03,2.75423e-03,1.75813e+03,1.73197e+03,2.76217e-03,1.74541e+03,1.71947e+03,2.78612e-03,1.70780e+03,
1.68250e+03,2.90000e-03,1.54394e+03,1.52136e+03,2.95776e-03,1.46924e+03,1.44787e+03,2.98538e-03,1.43529e+03,1.41447e+03,
3.05492e-03,1.35346e+03,1.33394e+03,3.09030e-03,1.31415e+03,1.29524e+03,3.12608e-03,1.27596e+03,1.25763e+03,3.14573e-03,
1.25566e+03,1.23764e+03,3.16228e-03,1.23891e+03,1.22114e+03,3.16230e-03,1.23888e+03,1.22112e+03,3.19889e-03,1.20296e+03,
1.18574e+03,3.23594e-03,1.16809e+03,1.15140e+03,3.27341e-03,1.13413e+03,1.11794e+03,3.34965e-03,1.06886e+03,1.05363e+03,
3.37841e-03,1.04563e+03,1.03073e+03,3.42768e-03,1.00744e+03,9.93092e+02,3.46737e-03,9.78083e+02,9.64156e+02,3.50752e-03,
9.49569e+02,9.36045e+02,3.65000e-03,8.56874e+02,8.44638e+02,3.70184e-03,8.25927e+02,8.14110e+02,3.75837e-03,7.93915e+02,
7.82532e+02,3.80189e-03,7.70460e+02,7.59393e+02,3.84592e-03,7.47562e+02,7.36799e+02,3.89045e-03,7.25342e+02,7.14871e+02,
3.93550e-03,7.03803e+02,6.93613e+02,3.98107e-03,6.82918e+02,6.73000e+02,3.98110e-03,6.82906e+02,6.72988e+02,4.02717e-03,
6.62672e+02,6.53015e+02,4.06826e-03,6.45323e+02,6.35887e+02,4.07380e-03,6.43032e+02,6.33625e+02,4.12097e-03,6.23867e+02,
6.14706e+02,4.26579e-03,5.69809e+02,5.61331e+02,4.31519e-03,5.52773e+02,5.44507e+02,4.36516e-03,5.36245e+02,5.28184e+02,
4.41570e-03,5.20178e+02,5.12313e+02,4.46684e-03,5.04606e+02,4.96931e+02,4.51856e-03,4.89511e+02,4.82019e+02,4.53199e-03,
4.85699e+02,4.78253e+02,4.67735e-03,4.46953e+02,4.39978e+02,4.73151e-03,4.33624e+02,4.26810e+02,4.84172e-03,4.07800e+02,
4.01292e+02,4.89779e-03,3.95475e+02,3.89112e+02,4.98274e-03,3.77696e+02,3.71542e+02,5.01187e-03,3.71852e+02,3.65768e+02,
5.01190e-03,3.71847e+02,3.65762e+02,5.12861e-03,3.49682e+02,3.43860e+02,5.24807e-03,3.28872e+02,3.23295e+02,5.30884e-03,
3.18946e+02,3.13486e+02,5.49541e-03,2.90989e+02,2.85856e+02,5.50000e-03,2.90346e+02,2.85219e+02,5.55904e-03,2.82180e+02,
2.77148e+02,5.68853e-03,2.65242e+02,2.60406e+02,5.74307e-03,2.58538e+02,2.53778e+02,5.82103e-03,2.49351e+02,2.44700e+02,
5.95662e-03,2.34379e+02,2.29904e+02,6.23735e-03,2.07150e+02,2.02996e+02,6.30957e-03,2.00832e+02,1.96752e+02,6.30960e-03,
2.00830e+02,1.96750e+02,6.36429e-03,1.96197e+02,1.92172e+02,6.45654e-03,1.88708e+02,1.84773e+02,6.53131e-03,1.82931e+02,
1.79067e+02,6.60693e-03,1.77334e+02,1.73538e+02,6.76083e-03,1.66630e+02,1.62965e+02,6.97297e-03,1.53313e+02,1.49812e+02,
7.07946e-03,1.47176e+02,1.43754e+02,7.16143e-03,1.42658e+02,1.39295e+02,7.24436e-03,1.38280e+02,1.34973e+02,7.32824e-03,
1.34041e+02,1.30789e+02,7.41310e-03,1.29910e+02,1.26711e+02,7.49894e-03,1.25910e+02,1.22764e+02,7.64056e-03,1.19681e+02,
1.16618e+02,7.67362e-03,1.18288e+02,1.15243e+02,7.76247e-03,1.14640e+02,1.11646e+02,7.94328e-03,1.07698e+02,1.04801e+02,
7.94330e-03,1.07697e+02,1.04800e+02,8.21919e-03,9.81753e+01,9.54139e+01,8.22243e-03,9.80706e+01,9.53108e+01,8.31764e-03,
9.50415e+01,9.23270e+01,8.51138e-03,8.92708e+01,8.66434e+01,8.60994e-03,8.65071e+01,8.39219e+01,8.70964e-03,8.38319e+01,
8.12879e+01,8.87133e-03,7.97354e+01,7.72552e+01,8.91251e-03,7.87354e+01,7.62717e+01,9.01571e-03,7.63064e+01,7.38830e+01,
9.12011e-03,7.39453e+01,7.15613e+01,9.33254e-03,6.94482e+01,6.71404e+01,9.44061e-03,6.73056e+01,6.50346e+01,9.63757e-03,
6.36109e+01,6.14040e+01,9.77237e-03,6.12392e+01,5.90762e+01,9.88553e-03,5.93445e+01,5.72170e+01,1.00000e-02,5.75014e+01,
5.54087e+01,1.02329e-02,5.39912e+01,5.19659e+01,1.03769e-02,5.19706e+01,4.99848e+01,1.05925e-02,4.91327e+01,4.72064e+01,
1.07152e-02,4.76096e+01,4.57156e+01,1.08000e-02,4.65942e+01,4.47219e+01,1.09648e-02,4.46931e+01,4.28617e+01,1.11649e-02,
4.25276e+01,4.07436e+01,1.12202e-02,4.19545e+01,4.01839e+01,1.14815e-02,3.93873e+01,3.76773e+01,1.15000e-02,3.92144e+01,
3.75086e+01,1.16170e-02,3.81383e+01,3.64582e+01,1.17490e-02,3.69712e+01,3.53209e+01,1.18850e-02,3.58199e+01,3.41993e+01,
1.23027e-02,3.25837e+01,3.10484e+01,1.23466e-02,3.22673e+01,3.07405e+01,1.24451e-02,3.15716e+01,3.00650e+01,1.25890e-02,
3.05824e+01,2.91045e+01,1.25892e-02,3.05807e+01,2.91029e+01,1.27350e-02,2.96211e+01,2.81716e+01,1.29367e-02,2.83625e+01,
2.69503e+01,1.30317e-02,2.77937e+01,2.64002e+01,1.31826e-02,2.69225e+01,2.55577e+01,1.34178e-02,2.56389e+01,2.43169e+01,
1.35000e-02,2.52087e+01,2.39027e+01,1.35540e-02,2.49306e+01,2.36349e+01,1.36458e-02,2.44672e+01,2.31887e+01,1.37741e-02,
2.38400e+01,2.25849e+01,1.39637e-02,2.29483e+01,2.17307e+01,1.40808e-02,2.24208e+01,2.12256e+01,1.41254e-02,2.22230e+01,
2.10374e+01,1.43106e-02,2.14269e+01,2.02800e+01,1.44165e-02,2.09864e+01,1.98636e+01,1.45000e-02,2.06456e+01,1.95434e+01,
1.45116e-02,2.05985e+01,1.94991e+01,1.45911e-02,2.02776e+01,1.91995e+01,1.46218e-02,2.01543e+01,1.90854e+01,1.46618e-02,
1.99949e+01,1.89379e+01,1.47220e-02,1.97556e+01,1.87187e+01,1.48031e-02,1.94348e+01,1.84285e+01,1.49108e-02,1.90131e+01,
1.80528e+01,1.50000e-02,1.86734e+01,1.77494e+01,1.50017e-02,1.86671e+01,1.77438e+01,1.50548e-02,1.84736e+01,1.75667e+01,
1.50947e-02,1.83340e+01,1.74353e+01,1.51356e-02,1.81969e+01,1.73017e+01,1.51414e-02,1.81775e+01,1.72828e+01,1.51590e-02,
1.81211e+01,1.72261e+01,1.51590e-02,1.21721e+02,5.84760e+01,1.51713e-02,1.21502e+02,5.84189e+01,1.52078e-02,1.20861e+02,
5.82498e+01,1.52611e-02,1.19938e+02,5.80028e+01,1.53109e-02,1.19091e+02,5.77726e+01,1.53326e-02,1.18673e+02,5.76471e+01,
1.54527e-02,1.16402e+02,5.69572e+01,1.54882e-02,1.15742e+02,5.67549e+01,1.55161e-02,1.15167e+02,5.65666e+01,1.55979e-02,
1.13497e+02,5.60172e+01,1.56675e-02,1.12098e+02,5.55540e+01,1.56872e-02,1.11706e+02,5.54234e+01,1.57000e-02,1.11453e+02,
5.53391e+01,1.58148e-02,1.09481e+02,5.47239e+01,1.58489e-02,1.08903e+02,5.45419e+01,1.58490e-02,1.08901e+02,5.45415e+01,
1.59568e-02,1.07104e+02,5.39707e+01,1.61000e-02,1.04774e+02,5.32201e+01,1.61360e-02,1.04167e+02,5.30162e+01,1.62181e-02,
1.02800e+02,5.25539e+01,1.63519e-02,1.00625e+02,5.18096e+01,1.64059e-02,9.97636e+01,5.15121e+01,1.66041e-02,9.66910e+01,
5.04358e+01,1.69824e-02,9.11777e+01,4.84471e+01,1.70230e-02,9.06120e+01,4.82387e+01,1.71791e-02,8.84791e+01,4.74457e+01,
1.73000e-02,8.68990e+01,4.68548e+01,1.73780e-02,8.59003e+01,4.64778e+01,1.74940e-02,8.44447e+01,4.59235e+01,1.77828e-02,
8.09652e+01,4.45758e+01,1.79887e-02,7.86058e+01,4.36428e+01,1.81970e-02,7.63160e+01,4.27221e+01,1.82211e-02,7.60572e+01,
4.26171e+01,1.86209e-02,7.19338e+01,4.09185e+01,1.88365e-02,6.98390e+01,4.00361e+01,1.90000e-02,6.83063e+01,3.93819e+01,
1.90546e-02,6.77887e+01,3.91568e+01,1.92528e-02,6.59556e+01,3.83531e+01,1.97242e-02,6.18596e+01,3.65213e+01,1.99526e-02,
5.99996e+01,3.56717e+01,1.99530e-02,5.99966e+01,3.56703e+01,2.01837e-02,5.81958e+01,3.48371e+01,2.02517e-02,5.76790e+01,
3.45978e+01,2.06538e-02,5.47489e+01,3.32241e+01,2.13796e-02,4.99601e+01,3.09141e+01,2.17976e-02,4.74636e+01,2.96766e+01,
2.21309e-02,4.55935e+01,2.87345e+01,2.23872e-02,4.42251e+01,2.80366e+01,2.26464e-02,4.28976e+01,2.73523e+01,2.30000e-02,
4.11747e+01,2.64536e+01,2.31740e-02,4.03613e+01,2.60249e+01,2.34423e-02,3.91496e+01,2.53811e+01,2.37137e-02,3.79499e+01,
2.47344e+01,2.37765e-02,3.76795e+01,2.45878e+01,2.50000e-02,3.29018e+01,2.19459e+01,2.51189e-02,3.24831e+01,2.17095e+01,
2.51190e-02,3.24826e+01,2.17092e+01,2.54097e-02,3.14889e+01,2.11449e+01,2.56776e-02,3.06102e+01,2.06419e+01,2.63027e-02,
2.86864e+01,1.95282e+01,2.66073e-02,2.78093e+01,1.90143e+01,2.69154e-02,2.69591e+01,1.85124e+01,2.75423e-02,2.53349e+01,
1.75427e+01,2.78612e-02,2.45603e+01,1.70753e+01,2.81838e-02,2.38098e+01,1.66192e+01,2.82931e-02,2.35628e+01,1.64685e+01,
2.85102e-02,2.30821e+01,1.61742e+01,2.91743e-02,2.16934e+01,1.53189e+01,3.05492e-02,1.91188e+01,1.36970e+01,3.12608e-02,
1.79499e+01,1.29469e+01,3.12819e-02,1.79167e+01,1.29255e+01,3.16228e-02,1.73926e+01,1.25863e+01,3.16230e-02,1.73923e+01,
1.25861e+01,3.19889e-02,1.68521e+01,1.22346e+01,3.27341e-02,1.58216e+01,1.15583e+01,3.46737e-02,1.35161e+01,1.00174e+01,
3.52393e-02,1.29318e+01,9.62042e+00,3.54813e-02,1.26923e+01,9.45699e+00,3.63078e-02,1.19194e+01,8.92633e+00,3.71535e-02,
1.11828e+01,8.41497e+00,3.75837e-02,1.08317e+01,8.16956e+00,3.78334e-02,1.06349e+01,8.03150e+00,3.80189e-02,1.04918e+01,
7.93096e+00,3.89045e-02,9.84377e+00,7.47351e+00,3.98107e-02,9.23649e+00,7.04127e+00,3.98110e-02,9.23631e+00,7.04114e+00,
4.17580e-02,8.09580e+00,6.21990e+00,4.26579e-02,7.63370e+00,5.88358e+00,4.36516e-02,7.16508e+00,5.54019e+00,4.46684e-02,
6.72550e+00,5.21581e+00,4.51856e-02,6.51619e+00,5.06058e+00,4.62381e-02,6.11197e+00,4.75921e+00,4.67735e-02,5.91960e+00,
4.61510e+00,5.00000e-02,4.92162e+00,3.85990e+00,5.01187e-02,4.88952e+00,3.83539e+00,5.01190e-02,4.88945e+00,3.83534e+00,
5.06991e-02,4.73663e+00,3.71858e+00,5.15989e-02,4.51250e+00,3.54675e+00,5.18800e-02,4.44548e+00,3.49527e+00,5.24807e-02,
4.30670e+00,3.38846e+00,5.30884e-02,4.17241e+00,3.28484e+00,5.43250e-02,3.91675e+00,3.08681e+00,5.62341e-02,3.56341e+00,
2.81147e+00,5.68853e-02,3.45191e+00,2.72409e+00,5.82103e-02,3.23974e+00,2.55724e+00,5.95959e-02,3.03709e+00,2.39719e+00,
6.16595e-02,2.76694e+00,2.18289e+00,6.23735e-02,2.68142e+00,2.11479e+00,6.30957e-02,2.59861e+00,2.04871e+00,6.30960e-02,
2.59858e+00,2.04869e+00,6.38264e-02,2.51841e+00,1.98470e+00,6.45654e-02,2.44084e+00,1.92267e+00,6.60693e-02,2.29320e+00,
1.80431e+00,6.91831e-02,2.02570e+00,1.58882e+00,7.00000e-02,1.96300e+00,1.53811e+00,7.41310e-02,1.68298e+00,1.31048e+00,
7.58578e-02,1.58301e+00,1.22883e+00,7.76247e-02,1.48942e+00,1.15220e+00,7.85236e-02,1.44491e+00,1.11570e+00,7.94328e-02,
1.40187e+00,1.08035e+00,7.94330e-02,1.40186e+00,1.08034e+00,8.03526e-02,1.36015e+00,1.04616e+00,8.22243e-02,1.28078e+00,
9.81017e-01,8.60988e-02,1.13703e+00,8.62742e-01,9.01571e-02,1.01104e+00,7.58831e-01,9.12011e-02,9.81851e-01,7.34704e-01,
9.22571e-02,9.53626e-01,7.11364e-01,9.54993e-02,8.74395e-01,6.45778e-01,1.00000e-01,7.80295e-01,5.67760e-01,1.01158e-01,
7.58588e-01,5.49844e-01,1.02329e-01,7.37593e-01,5.32513e-01,1.07152e-01,6.60225e-01,4.68638e-01,1.08393e-01,6.42433e-01,
4.53950e-01,1.08576e-01,6.39874e-01,4.51838e-01,1.16145e-01,5.47060e-01,3.75364e-01,1.23027e-01,4.80782e-01,3.20851e-01,
1.24452e-01,4.68783e-01,3.10996e-01,1.25890e-01,4.57192e-01,3.01482e-01,1.25893e-01,4.57172e-01,3.01466e-01,1.27350e-01,
4.45865e-01,2.92279e-01,1.29764e-01,4.28191e-01,2.77936e-01,1.31826e-01,4.14039e-01,2.66484e-01,1.41254e-01,3.58916e-01,
2.22051e-01,1.44544e-01,3.42787e-01,2.09116e-01,1.47911e-01,3.27662e-01,1.97021e-01,1.50000e-01,3.18912e-01,1.90040e-01,
1.54882e-01,3.00165e-01,1.75133e-01,1.57361e-01,2.91466e-01,1.68241e-01,1.58489e-01,2.87671e-01,1.65244e-01,1.58490e-01,
2.87668e-01,1.65242e-01,1.60324e-01,2.81649e-01,1.60576e-01,1.64059e-01,2.70159e-01,1.51698e-01,1.67880e-01,2.59366e-01,
1.43397e-01,1.71791e-01,2.49225e-01,1.35637e-01,1.75792e-01,2.39693e-01,1.28382e-01,1.79887e-01,2.30734e-01,1.21601e-01,
1.81970e-01,2.26457e-01,1.18377e-01,1.84077e-01,2.22309e-01,1.15260e-01,1.86209e-01,2.18286e-01,1.12247e-01,1.88365e-01,
2.14384e-01,1.09333e-01,1.90546e-01,2.10628e-01,1.06544e-01,1.92752e-01,2.06985e-01,1.03847e-01,1.97242e-01,2.00018e-01,
9.87168e-02,1.98584e-01,1.98045e-01,9.72702e-02,1.99526e-01,1.96686e-01,9.62771e-02,1.99530e-01,1.96680e-01,9.62731e-02,
2.00000e-01,1.96001e-01,9.57907e-02,2.04174e-01,1.90208e-01,9.16935e-02,2.08930e-01,1.84098e-01,8.74058e-02,2.11349e-01,
1.81174e-01,8.53670e-02,2.16272e-01,1.75572e-01,8.14872e-02,2.18776e-01,1.72890e-01,7.96421e-02,2.21309e-01,1.70283e-01,
7.78572e-02,2.23872e-01,1.67749e-01,7.61307e-02,2.30000e-01,1.62080e-01,7.22989e-02,2.34423e-01,1.58337e-01,6.98054e-02,
2.37137e-01,1.56156e-01,6.83623e-02,2.39883e-01,1.54034e-01,6.69657e-02,2.42661e-01,1.51971e-01,6.56155e-02,2.45471e-01,
1.49963e-01,6.43088e-02,2.51189e-01,1.46107e-01,6.18191e-02,2.51190e-01,1.46106e-01,6.18185e-02,2.60016e-01,1.40573e-01,
5.84571e-02,2.66073e-01,1.37116e-01,5.63906e-02,2.69154e-01,1.35453e-01,5.54065e-02,2.72270e-01,1.33843e-01,5.44675e-02,
2.75423e-01,1.32274e-01,5.35577e-02,2.78612e-01,1.30743e-01,5.26762e-02,2.81838e-01,1.29249e-01,5.18221e-02,2.85102e-01,
1.27793e-01,5.09958e-02,2.88403e-01,1.26372e-01,5.01951e-02,2.91743e-01,1.24985e-01,4.94191e-02,2.95121e-01,1.23631e-01,
4.86669e-02,3.00006e-01,1.21755e-01,4.76340e-02,3.01995e-01,1.21018e-01,4.72310e-02,3.05492e-01,1.19757e-01,4.65459e-02,
3.09029e-01,1.18525e-01,4.58815e-02,3.12608e-01,1.17322e-01,4.52373e-02,3.16228e-01,1.16158e-01,4.46238e-02,3.16230e-01,
1.16157e-01,4.46235e-02,3.19889e-01,1.14987e-01,4.40551e-02,3.23594e-01,1.13842e-01,4.35033e-02,3.27341e-01,1.12723e-01,
4.29686e-02,3.31131e-01,1.11627e-01,4.24496e-02,3.38844e-01,1.09506e-01,4.14568e-02,3.42768e-01,1.08478e-01,4.09819e-02,
3.46737e-01,1.07472e-01,4.05206e-02,3.50752e-01,1.06487e-01,4.00726e-02,3.54813e-01,1.05522e-01,3.96373e-02,3.58922e-01,
1.04585e-01,3.92229e-02,3.67282e-01,1.02765e-01,3.84279e-02,3.71535e-01,1.01883e-01,3.80473e-02,3.75837e-01,1.01017e-01,
3.76769e-02,3.78552e-01,1.00485e-01,3.74506e-02,3.80189e-01,1.00168e-01,3.73166e-02,3.84592e-01,9.93340e-02,3.69659e-02,
3.93550e-01,9.77123e-02,3.62919e-02,3.98107e-01,9.69239e-02,3.59682e-02,3.98110e-01,9.69234e-02,3.59680e-02,4.00000e-01,
9.65920e-02,3.58472e-02,4.07380e-01,9.53465e-02,3.54033e-02,4.12098e-01,9.45796e-02,3.51326e-02,4.16869e-01,9.38263e-02,
3.48690e-02,4.21697e-01,9.30858e-02,3.46118e-02,4.26580e-01,9.23578e-02,3.43607e-02,4.31519e-01,9.16418e-02,3.41155e-02,
4.41570e-01,9.02449e-02,3.36420e-02,4.46684e-01,8.95633e-02,3.34133e-02,4.51856e-01,8.88977e-02,3.31947e-02,4.57088e-01,
8.82424e-02,3.29807e-02,4.62381e-01,8.75972e-02,3.27713e-02,4.67735e-01,8.69622e-02,3.25667e-02,4.73151e-01,8.63367e-02,
3.23662e-02,4.84172e-01,8.51137e-02,3.19774e-02,4.89779e-01,8.45156e-02,3.17888e-02,4.95450e-01,8.39262e-02,3.16037e-02,
5.01187e-01,8.33492e-02,3.14262e-02,5.01190e-01,8.33489e-02,3.14261e-02,5.06991e-01,8.27574e-02,3.12723e-02,5.12861e-01,
8.21736e-02,3.11210e-02,5.18800e-01,8.15980e-02,3.09723e-02,5.24808e-01,8.10301e-02,3.08260e-02,5.30884e-01,8.04697e-02,
3.06819e-02,5.37032e-01,7.99166e-02,3.05400e-02,5.43250e-01,7.93707e-02,3.04001e-02,5.49541e-01,7.88318e-02,3.02622e-02,
5.54307e-01,7.84346e-02,3.01624e-02,5.62341e-01,7.77802e-02,2.99983e-02,5.68853e-01,7.72639e-02,2.98688e-02,5.75440e-01,
7.67542e-02,2.97412e-02,5.82103e-01,7.62506e-02,2.96150e-02,5.88844e-01,7.57529e-02,2.94903e-02,6.02560e-01,7.47751e-02,
2.92448e-02,6.09537e-01,7.42947e-02,2.91240e-02,6.16595e-01,7.38224e-02,2.90071e-02,6.23735e-01,7.33554e-02,2.88911e-02,
6.30957e-01,7.28935e-02,2.87762e-02,6.30960e-01,7.28933e-02,2.87762e-02,6.38264e-01,7.24162e-02,2.86802e-02,6.53131e-01,
7.14771e-02,2.84895e-02,6.60694e-01,7.10149e-02,2.83946e-02,6.68344e-01,7.05577e-02,2.83001e-02,6.76083e-01,7.01072e-02,
2.82079e-02,6.83912e-01,6.96614e-02,2.81160e-02,6.91831e-01,6.92202e-02,2.80244e-02,6.99842e-01,6.87835e-02,2.79330e-02,
7.07946e-01,6.83510e-02,2.78417e-02,7.24436e-01,6.74988e-02,2.76596e-02,7.32825e-01,6.70807e-02,2.75705e-02,7.41310e-01,
6.66666e-02,2.74815e-02,7.49894e-01,6.62563e-02,2.73925e-02,7.58578e-01,6.58498e-02,2.73034e-02,7.67362e-01,6.54472e-02,
2.72146e-02,7.76247e-01,6.50483e-02,2.71257e-02,7.94328e-01,6.42613e-02,2.69480e-02,7.94330e-01,6.42613e-02,2.69480e-02,
8.00000e-01,6.40104e-02,2.69021e-02,8.03526e-01,6.38560e-02,2.68737e-02,8.22243e-01,6.30558e-02,2.67235e-02,8.31764e-01,
6.26610e-02,2.66476e-02,8.41395e-01,6.22696e-02,2.65713e-02,8.51138e-01,6.18816e-02,2.64946e-02,8.60994e-01,6.14970e-02,
2.64174e-02,8.70964e-01,6.11156e-02,2.63399e-02,8.81049e-01,6.07375e-02,2.62618e-02,8.91251e-01,6.03625e-02,2.61833e-02,
9.01571e-01,5.99915e-02,2.61053e-02,9.09390e-01,5.97153e-02,2.60464e-02,9.22571e-01,5.92585e-02,2.59478e-02,9.33254e-01,
5.88964e-02,2.58684e-02,9.44061e-01,5.85372e-02,2.57886e-02,9.54993e-01,5.81811e-02,2.57085e-02,9.66051e-01,5.78278e-02,
2.56281e-02,9.77237e-01,5.74785e-02,2.55484e-02,1.00000e+00,5.67880e-02,2.53877e-02,1.00000e-03,3.49061e+03,3.48610e+03,
1.01158e-03,3.40022e+03,3.39572e+03,1.02329e-03,3.31171e+03,3.30724e+03,1.02502e-03,3.29892e+03,3.29446e+03,1.03000e-03,
3.26255e+03,3.25809e+03,1.03514e-03,3.22508e+03,3.22063e+03,1.05925e-03,3.05699e+03,3.05259e+03,1.07152e-03,2.97647e+03,
2.97209e+03,1.08205e-03,2.90967e+03,2.90531e+03,1.08393e-03,2.89800e+03,2.89364e+03,1.11000e-03,2.74282e+03,2.73852e+03,
1.13501e-03,2.60432e+03,2.60006e+03,1.13722e-03,2.59247e+03,2.58822e+03,1.14815e-03,2.53506e+03,2.53083e+03,1.15000e-03,
2.52555e+03,2.52132e+03,1.19775e-03,2.29543e+03,2.29129e+03,1.21619e-03,2.21453e+03,2.21043e+03,1.24451e-03,2.09762e+03,
2.09358e+03,1.25760e-03,2.04670e+03,2.04269e+03,1.25890e-03,2.04175e+03,2.03773e+03,1.25892e-03,2.04165e+03,2.03764e+03,
1.27350e-03,1.98685e+03,1.98287e+03,1.28825e-03,1.93334e+03,1.92939e+03,1.32395e-03,1.81166e+03,1.80778e+03,1.35000e-03,
1.72962e+03,1.72579e+03,1.36458e-03,1.68578e+03,1.68198e+03,1.38038e-03,1.64009e+03,1.63633e+03,1.38849e-03,1.61732e+03,
1.61357e+03,1.42889e-03,1.51020e+03,1.50654e+03,1.44544e-03,1.46887e+03,1.46525e+03,1.45544e-03,1.44472e+03,1.44112e+03,
1.50000e-03,1.34370e+03,1.34020e+03,1.51356e-03,1.31478e+03,1.31132e+03,1.51713e-03,1.30733e+03,1.30387e+03,1.53109e-03,
1.27873e+03,1.27532e+03,1.57127e-03,1.20108e+03,1.19776e+03,1.58489e-03,1.17625e+03,1.17297e+03,1.58490e-03,1.17624e+03,
1.17296e+03,1.60325e-03,1.14394e+03,1.14071e+03,1.62181e-03,1.11237e+03,1.10919e+03,1.65770e-03,1.05480e+03,1.05173e+03,
1.65959e-03,1.05189e+03,1.04883e+03,1.69106e-03,1.00458e+03,1.00162e+03,1.69824e-03,9.94201e+02,9.91271e+02,1.71791e-03,
9.66489e+02,9.63632e+02,1.72163e-03,9.61381e+02,9.58538e+02,1.75517e-03,9.16973e+02,9.14271e+02,1.77828e-03,8.88028e+02,
8.85438e+02,1.78046e-03,8.85362e+02,8.82782e+02,1.79887e-03,8.63295e+02,8.60815e+02,1.80021e-03,8.61726e+02,8.59253e+02,
1.81808e-03,8.41098e+02,8.38734e+02,1.81970e-03,8.39255e+02,8.36903e+02,1.83616e-03,8.20824e+02,8.18586e+02,1.85000e-03,
8.05752e+02,8.03628e+02,1.86123e-03,7.93704e+02,7.91687e+02,1.87131e-03,7.83087e+02,7.81182e+02,1.88016e-03,7.73912e+02,
7.72122e+02,1.88365e-03,7.70333e+02,7.68594e+02,1.88738e-03,7.66524e+02,7.64839e+02,1.90164e-03,7.52175e+02,7.50698e+02,
1.90609e-03,7.47787e+02,7.46364e+02,1.90906e-03,7.44879e+02,7.43485e+02,1.91075e-03,7.43244e+02,7.41864e+02,1.91300e-03,
7.41069e+02,7.39705e+02,1.91626e-03,7.37937e+02,7.36586e+02,1.91869e-03,7.35626e+02,7.34278e+02,1.92059e-03,7.33828e+02,
7.32479e+02,1.92317e-03,7.31402e+02,7.30044e+02,1.92572e-03,7.29024e+02,7.27651e+02,1.92753e-03,7.27353e+02,7.25964e+02,
1.92831e-03,7.26633e+02,7.25238e+02,1.93026e-03,7.24840e+02,7.23423e+02,1.93333e-03,7.22041e+02,7.20584e+02,1.93875e-03,
7.17149e+02,7.15606e+02,1.94240e-03,7.13893e+02,7.12285e+02,1.94240e-03,2.81700e+03,2.76670e+03,1.94877e-03,2.79474e+03,
2.74487e+03,1.95000e-03,2.79046e+03,2.74067e+03,1.95095e-03,2.78717e+03,2.73745e+03,1.95443e-03,2.77514e+03,2.72565e+03,
1.95739e-03,2.76494e+03,2.71566e+03,1.95800e-03,2.76286e+03,2.71362e+03,1.96181e-03,2.74874e+03,2.69978e+03,1.96523e-03,
2.73613e+03,2.68742e+03,1.96790e-03,2.72633e+03,2.67783e+03,1.97154e-03,2.71308e+03,2.66486e+03,1.97242e-03,2.70986e+03,
2.66171e+03,1.98092e-03,2.67927e+03,2.63177e+03,1.99066e-03,2.64478e+03,2.59801e+03,1.99526e-03,2.62869e+03,2.58225e+03,
1.99530e-03,2.62855e+03,2.58212e+03,1.99932e-03,2.61462e+03,2.56846e+03,2.00968e-03,2.57922e+03,2.53377e+03,2.01000e-03,
2.57813e+03,2.53269e+03,2.01210e-03,2.57170e+03,2.52639e+03,2.01210e-03,3.58004e+03,3.50937e+03,2.02537e-03,3.52067e+03,
3.45139e+03,2.03011e-03,3.49978e+03,3.43099e+03,2.04000e-03,3.45676e+03,3.38898e+03,2.04174e-03,3.44940e+03,3.38178e+03,
2.04767e-03,3.42440e+03,3.35737e+03,2.05619e-03,3.38898e+03,3.32280e+03,2.06386e-03,3.35752e+03,3.29208e+03,2.06538e-03,
3.35131e+03,3.28602e+03,2.07000e-03,3.33256e+03,3.26773e+03,2.07433e-03,3.31511e+03,3.25069e+03,2.08000e-03,3.29246e+03,
3.22859e+03,2.08616e-03,3.27005e+03,3.20673e+03,2.09820e-03,3.22685e+03,3.16459e+03,2.11349e-03,3.17314e+03,3.11223e+03,
2.11472e-03,3.16887e+03,3.10805e+03,2.13000e-03,3.11654e+03,3.05702e+03,2.13079e-03,3.11378e+03,3.05433e+03,2.14470e-03,
3.06559e+03,3.00733e+03,2.15000e-03,3.04751e+03,2.98970e+03,2.16272e-03,3.00305e+03,2.94632e+03,2.16757e-03,2.98634e+03,
2.93001e+03,2.17654e-03,2.95577e+03,2.90018e+03,2.18497e-03,2.92745e+03,2.87252e+03,2.18776e-03,2.91817e+03,2.86346e+03,
2.19319e-03,2.90023e+03,2.84593e+03,2.20010e-03,2.87763e+03,2.82384e+03,2.20010e-03,3.29077e+03,3.22829e+03,2.20678e-03,
3.26725e+03,3.20532e+03,2.22000e-03,3.22138e+03,3.16052e+03,2.23223e-03,3.17979e+03,3.11988e+03,2.23872e-03,3.15801e+03,
3.09860e+03,2.24286e-03,3.14403e+03,3.08494e+03,2.25340e-03,3.10882e+03,3.05053e+03,2.26464e-03,3.07184e+03,3.01440e+03,
2.26580e-03,3.06799e+03,3.01064e+03,2.27942e-03,3.02318e+03,2.96686e+03,2.29087e-03,2.98622e+03,2.93076e+03,2.29713e-03,
2.96629e+03,2.91129e+03,2.30000e-03,2.95720e+03,2.90240e+03,2.31740e-03,2.90300e+03,2.84945e+03,2.31998e-03,2.89505e+03,
2.84168e+03,2.34423e-03,2.82202e+03,2.77033e+03,2.35000e-03,2.80501e+03,2.75370e+03,2.38000e-03,2.71793e+03,2.66859e+03,
2.39601e-03,2.67299e+03,2.62466e+03,2.45431e-03,2.51783e+03,2.47294e+03,2.45471e-03,2.51680e+03,2.47193e+03,2.51189e-03,
2.37695e+03,2.33514e+03,2.51190e-03,2.37692e+03,2.33511e+03,2.51856e-03,2.36137e+03,2.31989e+03,2.57040e-03,2.24506e+03,
2.20606e+03,2.60016e-03,2.18195e+03,2.14429e+03,2.62365e-03,2.13360e+03,2.09694e+03,2.63027e-03,2.12025e+03,2.08386e+03,
2.66073e-03,2.05987e+03,2.02473e+03,2.72270e-03,1.94431e+03,1.91151e+03,2.72515e-03,1.93993e+03,1.90722e+03,2.75423e-03,
1.88901e+03,1.85732e+03,2.81838e-03,1.78320e+03,1.75360e+03,2.88222e-03,1.68610e+03,1.65837e+03,2.88403e-03,1.68345e+03,
1.65577e+03,2.90000e-03,1.66038e+03,1.63315e+03,2.91743e-03,1.63570e+03,1.60893e+03,2.95121e-03,1.58928e+03,1.56339e+03,
3.00000e-03,1.52516e+03,1.50047e+03,3.01995e-03,1.50000e+03,1.47576e+03,3.05929e-03,1.45155e+03,1.42820e+03,3.09030e-03,
1.41488e+03,1.39219e+03,3.16228e-03,1.33471e+03,1.31345e+03,3.16230e-03,1.33468e+03,1.31343e+03,3.19889e-03,1.29639e+03,
1.27580e+03,3.23594e-03,1.25918e+03,1.23924e+03,3.24295e-03,1.25229e+03,1.23247e+03,3.27341e-03,1.22301e+03,1.20370e+03,
3.31131e-03,1.18789e+03,1.16919e+03,3.34965e-03,1.15342e+03,1.13529e+03,3.46238e-03,1.05919e+03,1.04262e+03,3.46737e-03,
1.05527e+03,1.03877e+03,3.54813e-03,9.94663e+02,9.79149e+02,3.57000e-03,9.79107e+02,9.63843e+02,3.58922e-03,9.65619e+02,
9.50570e+02,3.65000e-03,9.24655e+02,9.10254e+02,3.67282e-03,9.09890e+02,8.95720e+02,3.72127e-03,8.79621e+02,8.65921e+02,
3.75837e-03,8.57372e+02,8.44018e+02,3.89045e-03,7.84314e+02,7.72081e+02,3.93550e-03,7.61326e+02,7.49439e+02,3.98107e-03,
7.38757e+02,7.27205e+02,3.98110e-03,7.38743e+02,7.27191e+02,4.02717e-03,7.16873e+02,7.05643e+02,4.05282e-03,7.05022e+02,
6.93965e+02,4.12097e-03,6.74815e+02,6.64201e+02,4.15000e-03,6.62498e+02,6.52063e+02,4.21696e-03,6.35235e+02,6.25193e+02,
4.36516e-03,5.80277e+02,5.71015e+02,4.41570e-03,5.63069e+02,5.54047e+02,4.46684e-03,5.46282e+02,5.37493e+02,4.47875e-03,
5.42471e+02,5.33734e+02,4.50000e-03,5.35767e+02,5.27124e+02,4.62381e-03,4.98833e+02,4.90699e+02,4.67735e-03,4.83864e+02,
4.75933e+02,4.73151e-03,4.69339e+02,4.61605e+02,4.88547e-03,4.31309e+02,4.24083e+02,5.01187e-03,4.03197e+02,3.96346e+02,
5.01190e-03,4.03191e+02,3.96341e+02,5.06991e-03,3.91136e+02,3.84445e+02,5.12861e-03,3.79359e+02,3.72823e+02,5.18800e-03,
3.67901e+02,3.61514e+02,5.30884e-03,3.45902e+02,3.39799e+02,5.30885e-03,3.45902e+02,3.39799e+02,5.43250e-03,3.25231e+02,
3.19398e+02,5.75440e-03,2.78957e+02,2.73721e+02,5.82103e-03,2.70551e+02,2.65424e+02,5.88844e-03,2.62407e+02,2.57384e+02,
5.95662e-03,2.54460e+02,2.49538e+02,6.00000e-03,2.49546e+02,2.44685e+02,6.01260e-03,2.48142e+02,2.43299e+02,6.02560e-03,
2.46705e+02,2.41881e+02,6.09537e-03,2.39187e+02,2.34460e+02,6.16595e-03,2.31900e+02,2.27267e+02,6.30957e-03,2.17973e+02,
2.13519e+02,6.30960e-03,2.17970e+02,2.13516e+02,6.53131e-03,1.98644e+02,1.94438e+02,6.54102e-03,1.97855e+02,1.93659e+02,
6.68344e-03,1.86759e+02,1.82711e+02,6.76083e-03,1.81064e+02,1.77091e+02,6.83912e-03,1.75512e+02,1.71611e+02,6.91831e-03,
1.70134e+02,1.66305e+02,7.07946e-03,1.59856e+02,1.56163e+02,7.16143e-03,1.54960e+02,1.51332e+02,7.31244e-03,1.46476e+02,
1.42961e+02,7.41310e-03,1.41170e+02,1.37729e+02,7.58578e-03,1.32688e+02,1.29365e+02,7.67362e-03,1.28617e+02,1.25351e+02,
7.76247e-03,1.24671e+02,1.21460e+02,7.92615e-03,1.17795e+02,1.14681e+02,7.94328e-03,1.17106e+02,1.14002e+02,7.94330e-03,
1.17105e+02,1.14002e+02,8.03526e-03,1.13497e+02,1.10447e+02,8.12830e-03,1.09995e+02,1.06996e+02,8.31764e-03,1.03322e+02,
1.00422e+02,8.41395e-03,1.00144e+02,9.72917e+01,8.50850e-03,9.71564e+01,9.43494e+01,8.70964e-03,9.11945e+01,8.84819e+01,
8.81049e-03,8.83977e+01,8.57298e+01,9.12011e-03,8.04696e+01,7.79299e+01,9.22491e-03,7.79977e+01,7.54985e+01,9.22571e-03,
7.79792e+01,7.54803e+01,9.54993e-03,7.09722e+01,6.85953e+01,9.66051e-03,6.87776e+01,6.64396e+01,9.77237e-03,6.66536e+01,
6.43534e+01,9.88553e-03,6.45975e+01,6.23344e+01,9.89826e-03,6.43717e+01,6.21127e+01,1.00000e-02,6.26037e+01,6.03783e+01,
1.01158e-02,6.06595e+01,5.84713e+01,1.05925e-02,5.34880e+01,5.14403e+01,1.07104e-02,5.19005e+01,4.98848e+01,1.07152e-02,
5.18367e+01,4.98224e+01,1.10918e-02,4.71653e+01,4.52516e+01,1.12202e-02,4.57074e+01,4.38258e+01,1.13501e-02,4.42924e+01,
4.24422e+01,1.14815e-02,4.29130e+01,4.10936e+01,1.15499e-02,4.22186e+01,4.04147e+01,1.16145e-02,4.15757e+01,3.97870e+01,
1.19941e-02,3.80605e+01,3.63564e+01,1.21619e-02,3.66356e+01,3.49677e+01,1.24597e-02,3.42883e+01,3.26812e+01,1.25890e-02,
3.33318e+01,3.17513e+01,1.25892e-02,3.33300e+01,3.17495e+01,1.27350e-02,3.22925e+01,3.07410e+01,1.30317e-02,3.03170e+01,
2.88217e+01,1.31826e-02,2.93768e+01,2.79086e+01,1.32007e-02,2.92652e+01,2.78002e+01,1.34896e-02,2.75617e+01,2.61500e+01,
1.36458e-02,2.66979e+01,2.53137e+01,1.38086e-02,2.58370e+01,2.44803e+01,1.41254e-02,2.42637e+01,2.29626e+01,1.42961e-02,
2.34719e+01,2.21992e+01,1.46218e-02,2.20512e+01,2.08351e+01,1.46638e-02,2.18768e+01,2.06676e+01,1.47911e-02,2.13576e+01,
2.01717e+01,1.49408e-02,2.07661e+01,1.96068e+01,1.49624e-02,2.06825e+01,1.95274e+01,1.51356e-02,2.00259e+01,1.89042e+01,
1.51745e-02,1.98823e+01,1.87680e+01,1.52879e-02,1.94693e+01,1.83786e+01,1.53109e-02,1.93866e+01,1.83010e+01,1.53716e-02,
1.91701e+01,1.80981e+01,1.54603e-02,1.88579e+01,1.78074e+01,1.54882e-02,1.87603e+01,1.77174e+01,1.55358e-02,1.85934e+01,
1.75632e+01,1.56011e-02,1.83659e+01,1.73553e+01,1.56868e-02,1.80683e+01,1.70869e+01,1.57998e-02,1.76798e+01,1.67419e+01,
1.58489e-02,1.75142e+01,1.65947e+01,1.58490e-02,1.75140e+01,1.65945e+01,1.59003e-02,1.73436e+01,1.64428e+01,1.59565e-02,
1.71635e+01,1.62784e+01,1.59988e-02,1.70335e+01,1.61564e+01,1.60324e-02,1.69346e+01,1.60602e+01,1.60487e-02,1.68870e+01,
1.60140e+01,1.60670e-02,1.68357e+01,1.59622e+01,1.60670e-02,1.11382e+02,5.18153e+01,1.60863e-02,1.11094e+02,5.17476e+01,
1.61223e-02,1.10562e+02,5.16208e+01,1.61834e-02,1.09674e+02,5.14059e+01,1.62181e-02,1.09178e+02,5.12839e+01,1.62770e-02,
1.08243e+02,5.10295e+01,1.63856e-02,1.06554e+02,5.05626e+01,1.64059e-02,1.06242e+02,5.04757e+01,1.64536e-02,1.05403e+02,
5.02190e+01,1.64974e-02,1.04639e+02,4.99840e+01,1.65566e-02,1.03617e+02,4.96686e+01,1.65959e-02,1.02945e+02,4.94599e+01,
1.66089e-02,1.02724e+02,4.93911e+01,1.66500e-02,1.02028e+02,4.91739e+01,1.66749e-02,1.01651e+02,4.90635e+01,1.67880e-02,
9.99660e+01,4.85653e+01,1.68139e-02,9.95866e+01,4.84521e+01,1.69911e-02,9.70329e+01,4.76814e+01,1.71791e-02,9.44206e+01,
4.68755e+01,1.72228e-02,9.37992e+01,4.66756e+01,1.73780e-02,9.16366e+01,4.59729e+01,1.74623e-02,9.04905e+01,4.55952e+01,
1.75792e-02,8.89322e+01,4.50765e+01,1.77828e-02,8.63075e+01,4.41875e+01,1.77858e-02,8.62698e+01,4.41746e+01,1.81970e-02,
8.12857e+01,4.24340e+01,1.82753e-02,8.03812e+01,4.21103e+01,1.84077e-02,7.88823e+01,4.15690e+01,1.86209e-02,7.65818e+01,
4.07306e+01,1.88365e-02,7.43488e+01,3.99012e+01,1.89998e-02,7.27174e+01,3.92855e+01,1.90546e-02,7.21812e+01,3.90814e+01,
1.94985e-02,6.80340e+01,3.74720e+01,1.97727e-02,6.56367e+01,3.65255e+01,1.99526e-02,6.41271e+01,3.59196e+01,1.99530e-02,
6.41239e+01,3.59183e+01,2.00000e-02,6.37376e+01,3.57620e+01,2.01837e-02,6.22149e+01,3.51336e+01,2.04174e-02,6.03492e+01,
3.43529e+01,2.06538e-02,5.85401e+01,3.35842e+01,2.07904e-02,5.75283e+01,3.31491e+01,2.08930e-02,5.67846e+01,3.28272e+01,
2.13796e-02,5.34305e+01,3.13500e+01,2.18610e-02,5.03737e+01,2.99663e+01,2.18776e-02,5.02727e+01,2.99200e+01,2.21309e-02,
4.87642e+01,2.92235e+01,2.29087e-02,4.45068e+01,2.72085e+01,2.34423e-02,4.18795e+01,2.59273e+01,2.34999e-02,4.16069e+01,
2.57924e+01,2.37137e-02,4.06163e+01,2.52997e+01,2.39883e-02,3.93914e+01,2.46845e+01,2.45471e-02,3.70525e+01,2.34911e+01,
2.48313e-02,3.59359e+01,2.29123e+01,2.51189e-02,3.48533e+01,2.23455e+01,2.51190e-02,3.48528e+01,2.23452e+01,2.57040e-02,
3.27487e+01,2.12228e+01,2.58152e-02,3.23686e+01,2.10177e+01,2.60016e-02,3.17445e+01,2.06797e+01,2.66073e-02,2.98283e+01,
1.96295e+01,2.72270e-02,2.80288e+01,1.86259e+01,2.78612e-02,2.63392e+01,1.76711e+01,2.81838e-02,2.55335e+01,1.72101e+01,
2.83680e-02,2.50889e+01,1.69540e+01,2.91743e-02,2.32622e+01,1.58903e+01,2.95121e-02,2.25504e+01,1.54702e+01,3.01995e-02,
2.11923e+01,1.46598e+01,3.05492e-02,2.05446e+01,1.42691e+01,3.09030e-02,1.99169e+01,1.38878e+01,3.12608e-02,1.93087e+01,
1.35158e+01,3.13436e-02,1.91691e+01,1.34297e+01,3.16228e-02,1.87081e+01,1.31448e+01,3.16230e-02,1.87077e+01,1.31446e+01,
3.23594e-02,1.75625e+01,1.24307e+01,3.27341e-02,1.70168e+01,1.20872e+01,3.34965e-02,1.59762e+01,1.14263e+01,3.42768e-02,
1.50003e+01,1.07990e+01,3.46288e-02,1.45863e+01,1.05306e+01,3.50752e-02,1.40835e+01,1.02030e+01,3.58922e-02,1.32232e+01,
9.63775e+00,3.63078e-02,1.28133e+01,9.36616e+00,3.82674e-02,1.10999e+01,8.21520e+00,3.89045e-02,1.06109e+01,7.88202e+00,
3.93550e-02,1.02778e+01,7.65331e+00,3.98107e-02,9.95538e+00,7.43091e+00,3.98110e-02,9.95519e+00,7.43077e+00,4.02717e-02,
9.64320e+00,7.21469e+00,4.07380e-02,9.34099e+00,7.00446e+00,4.16869e-02,8.76461e+00,6.60146e+00,4.21768e-02,8.48623e+00,
6.40556e+00,4.26579e-02,8.22437e+00,6.22063e+00,4.31519e-02,7.96697e+00,6.03810e+00,4.46684e-02,7.24320e+00,5.52080e+00,
4.84172e-02,5.80542e+00,4.47423e+00,4.95450e-02,5.44614e+00,4.20806e+00,5.01187e-02,5.27520e+00,4.08079e+00,5.01190e-02,
5.27511e+00,4.08073e+00,5.06991e-02,5.10974e+00,3.95729e+00,5.12861e-02,4.94962e+00,3.83739e+00,5.19749e-02,4.77056e+00,
3.70287e+00,5.30884e-02,4.49949e+00,3.49851e+00,5.55904e-02,3.96430e+00,3.09169e+00,5.82103e-02,3.49510e+00,2.73119e+00,
5.97991e-02,3.24777e+00,2.53961e+00,6.02560e-02,3.18119e+00,2.48789e+00,6.09537e-02,3.08213e+00,2.41069e+00,6.16595e-02,
2.98628e+00,2.33584e+00,6.30957e-02,2.80391e+00,2.19294e+00,6.30960e-02,2.80388e+00,2.19291e+00,6.38264e-02,2.71703e+00,
2.12477e+00,6.53131e-02,2.55169e+00,1.99465e+00,6.76083e-02,2.32339e+00,1.81410e+00,7.07946e-02,2.05226e+00,1.59830e+00,
7.16143e-02,1.98985e+00,1.54840e+00,7.41310e-02,1.81456e+00,1.40781e+00,7.49894e-02,1.75989e+00,1.36382e+00,7.50000e-02,
1.75923e+00,1.36329e+00,7.58578e-02,1.70653e+00,1.32081e+00,7.94328e-02,1.51005e+00,1.16187e+00,7.94330e-02,1.51004e+00,
1.16186e+00,8.31764e-02,1.33775e+00,1.02215e+00,8.70964e-02,1.18693e+00,8.99323e-01,8.75362e-02,1.17162e+00,8.86825e-01,
8.81049e-02,1.15224e+00,8.71013e-01,9.22571e-02,1.02430e+00,7.66397e-01,9.33254e-02,9.94882e-01,7.42290e-01,9.44061e-02,
9.66422e-01,7.18954e-01,9.54993e-02,9.38890e-01,6.96364e-01,9.77237e-02,8.86488e-01,6.53326e-01,9.88553e-02,8.61411e-01,
6.32699e-01,1.00000e-01,8.37156e-01,6.12737e-01,1.02329e-01,7.90864e-01,5.74798e-01,1.04713e-01,7.47544e-01,5.39271e-01,
1.09498e-01,6.71239e-01,4.76659e-01,1.13501e-01,6.16561e-01,4.31839e-01,1.14815e-01,6.00180e-01,4.18411e-01,1.16145e-01,
5.84331e-01,4.05420e-01,1.17490e-01,5.68995e-01,3.92851e-01,1.18850e-01,5.54156e-01,3.80692e-01,1.20226e-01,5.39797e-01,
3.68928e-01,1.21619e-01,5.25901e-01,3.57547e-01,1.25890e-01,4.86874e-01,3.25602e-01,1.25893e-01,4.86853e-01,3.25584e-01,
1.28825e-01,4.62725e-01,3.06032e-01,1.30317e-01,4.51239e-01,2.96733e-01,1.32539e-01,4.35029e-01,2.83622e-01,1.33352e-01,
4.29346e-01,2.79037e-01,1.38038e-01,3.99024e-01,2.54606e-01,1.41254e-01,3.80384e-01,2.39625e-01,1.44544e-01,3.62909e-01,
2.25609e-01,1.51356e-01,3.31156e-01,2.00235e-01,1.53109e-01,3.23833e-01,1.94403e-01,1.56675e-01,3.09871e-01,1.83308e-01,
1.58489e-01,3.03216e-01,1.78032e-01,1.58490e-01,3.03214e-01,1.78030e-01,1.61347e-01,2.93207e-01,1.70235e-01,1.65959e-01,
2.78357e-01,1.58731e-01,1.69824e-01,2.67044e-01,1.50010e-01,1.73780e-01,2.56416e-01,1.41853e-01,1.84077e-01,2.32561e-01,
1.23701e-01,1.86209e-01,2.28216e-01,1.20421e-01,1.88365e-01,2.24034e-01,1.17280e-01,1.90546e-01,2.19978e-01,1.14243e-01,
1.94984e-01,2.12227e-01,1.08463e-01,1.97242e-01,2.08522e-01,1.05714e-01,1.99526e-01,2.04928e-01,1.03055e-01,1.99530e-01,
2.04922e-01,1.03051e-01,2.07401e-01,1.93435e-01,9.48312e-02,2.08930e-01,1.91377e-01,9.33723e-02,2.13796e-01,1.85166e-01,
8.89918e-02,2.16272e-01,1.82193e-01,8.69081e-02,2.18776e-01,1.79305e-01,8.48925e-02,2.21309e-01,1.76500e-01,8.29428e-02,
2.26464e-01,1.71124e-01,7.92316e-02,2.29087e-01,1.68550e-01,7.74661e-02,2.30000e-01,1.67677e-01,7.68695e-02,2.39883e-01,
1.59027e-01,7.10340e-02,2.42661e-01,1.56811e-01,6.95562e-02,2.45471e-01,1.54655e-01,6.81262e-02,2.48313e-01,1.52558e-01,
6.67418e-02,2.51189e-01,1.50517e-01,6.54014e-02,2.51190e-01,1.50516e-01,6.54008e-02,2.57040e-01,1.46515e-01,6.29034e-02,
2.72270e-01,1.37387e-01,5.73218e-02,2.75423e-01,1.35714e-01,5.63238e-02,2.78612e-01,1.34082e-01,5.53569e-02,2.79717e-01,
1.33531e-01,5.50315e-02,2.81838e-01,1.32490e-01,5.44200e-02,2.85102e-01,1.30938e-01,5.35135e-02,2.91743e-01,1.27946e-01,
5.17842e-02,3.00000e-01,1.24536e-01,4.98520e-02,3.01995e-01,1.23755e-01,4.94138e-02,3.05492e-01,1.22424e-01,4.86710e-02,
3.09029e-01,1.21123e-01,4.79505e-02,3.12608e-01,1.19853e-01,4.72516e-02,3.16228e-01,1.18612e-01,4.65735e-02,3.16230e-01,
1.18611e-01,4.65732e-02,3.23594e-01,1.16149e-01,4.53300e-02,3.27341e-01,1.14960e-01,4.47370e-02,3.31131e-01,1.13797e-01,
4.41615e-02,3.34965e-01,1.12659e-01,4.36032e-02,3.38844e-01,1.11547e-01,4.30613e-02,3.42768e-01,1.10468e-01,4.25456e-02,
3.50752e-01,1.08379e-01,4.15578e-02,3.63078e-01,1.05404e-01,4.01778e-02,3.67282e-01,1.04452e-01,3.97432e-02,3.71535e-01,
1.03520e-01,3.93208e-02,3.75837e-01,1.02606e-01,3.89107e-02,3.80189e-01,1.01711e-01,3.85120e-02,3.84592e-01,1.00833e-01,
3.81240e-02,3.89045e-01,9.99810e-02,3.77548e-02,3.98107e-01,9.83236e-02,3.70447e-02,3.98110e-01,9.83231e-02,3.70445e-02,
4.00513e-01,9.78859e-02,3.68776e-02,4.02717e-01,9.74905e-02,3.67274e-02,4.07380e-01,9.66718e-02,3.64182e-02,4.12098e-01,
9.58678e-02,3.61168e-02,4.16869e-01,9.50780e-02,3.58229e-02,4.21697e-01,9.43027e-02,3.55369e-02,4.31519e-01,9.27923e-02,
3.49858e-02,4.41570e-01,9.13447e-02,3.44725e-02,4.46684e-01,9.06388e-02,3.42246e-02,4.51856e-01,8.99443e-02,3.39823e-02,
4.67735e-01,8.79268e-02,3.32869e-02,4.73151e-01,8.72759e-02,3.30655e-02,4.78630e-01,8.66351e-02,3.28489e-02,4.84172e-01,
8.60089e-02,3.26415e-02,4.89779e-01,8.53920e-02,3.24382e-02,4.95450e-01,8.47842e-02,3.22389e-02,5.01187e-01,8.41852e-02,
3.20434e-02,5.01190e-01,8.41849e-02,3.20433e-02,5.12861e-01,8.29669e-02,3.17037e-02,5.18800e-01,8.23705e-02,3.15382e-02,
5.24808e-01,8.17828e-02,3.13759e-02,5.30884e-01,8.12032e-02,3.12164e-02,5.37032e-01,8.06354e-02,3.10634e-02,5.43250e-01,
8.00751e-02,3.09126e-02,5.49541e-01,7.95220e-02,3.07640e-02,5.62341e-01,7.84373e-02,3.04731e-02,5.75440e-01,7.73798e-02,
3.01901e-02,5.82103e-01,7.68614e-02,3.00518e-02,5.88844e-01,7.63493e-02,2.99153e-02,5.90541e-01,7.62231e-02,2.98822e-02,
6.02560e-01,7.53492e-02,2.96532e-02,6.30957e-01,7.34178e-02,2.91458e-02,6.30960e-01,7.34176e-02,2.91458e-02,6.38264e-01,
7.29272e-02,2.90390e-02,6.45654e-01,7.24423e-02,2.89332e-02,6.53131e-01,7.19654e-02,2.88305e-02,6.60694e-01,7.14936e-02,
2.87282e-02,6.62370e-01,7.13904e-02,2.87058e-02,6.83912e-01,7.01080e-02,2.84243e-02,6.91831e-01,6.96557e-02,2.83238e-02,
6.99842e-01,6.92084e-02,2.82239e-02,7.07946e-01,6.87657e-02,2.81245e-02,7.08570e-01,6.87320e-02,2.81169e-02,7.16143e-01,
6.83297e-02,2.80275e-02,7.24436e-01,6.78982e-02,2.79310e-02,7.49894e-01,6.66288e-02,2.76427e-02,7.67362e-01,6.58027e-02,
2.74513e-02,7.76247e-01,6.53957e-02,2.73561e-02,7.85236e-01,6.49940e-02,2.72626e-02,7.94328e-01,6.45960e-02,2.71691e-02,
7.94330e-01,6.45960e-02,2.71691e-02,8.03526e-01,6.41845e-02,2.70905e-02,8.12831e-01,6.37767e-02,2.70116e-02,8.41395e-01,
6.25750e-02,2.67724e-02,8.51138e-01,6.21816e-02,2.66919e-02,8.60994e-01,6.17917e-02,2.66112e-02,8.70964e-01,6.14063e-02,
2.65311e-02,8.91251e-01,6.06452e-02,2.63698e-02,9.01571e-01,6.02696e-02,2.62886e-02,9.12011e-01,5.98971e-02,2.62070e-02,
9.22571e-01,5.95277e-02,2.61250e-02,9.33254e-01,5.91614e-02,2.60428e-02,9.44061e-01,5.87981e-02,2.59601e-02,9.54993e-01,
5.84379e-02,2.58773e-02,9.66051e-01,5.80820e-02,2.57954e-02,9.77237e-01,5.77289e-02,2.57132e-02,9.88553e-01,5.73787e-02,
2.56306e-02,1.00000e+00,5.70312e-02,2.55476e-02,1.00000e-03,3.86050e+03,3.85573e+03,1.01158e-03,3.76041e+03,3.75566e+03,
1.03514e-03,3.56775e+03,3.56304e+03,1.04713e-03,3.47465e+03,3.46996e+03,1.04937e-03,3.45757e+03,3.45288e+03,1.08393e-03,
3.20875e+03,3.20412e+03,1.10918e-03,3.04193e+03,3.03735e+03,1.11000e-03,3.03670e+03,3.03212e+03,1.12202e-03,2.96168e+03,
2.95711e+03,1.13501e-03,2.88361e+03,2.87907e+03,1.16248e-03,2.72721e+03,2.72271e+03,1.17490e-03,2.66047e+03,2.65599e+03,
1.20226e-03,2.52113e+03,2.51669e+03,1.21619e-03,2.45388e+03,2.44946e+03,1.22277e-03,2.42283e+03,2.41843e+03,1.23027e-03,
2.38812e+03,2.38373e+03,1.25890e-03,2.26228e+03,2.25793e+03,1.25892e-03,2.26217e+03,2.25783e+03,1.27350e-03,2.20136e+03,
2.19703e+03,1.28039e-03,2.17349e+03,2.16917e+03,1.30317e-03,2.08487e+03,2.08060e+03,1.31826e-03,2.02885e+03,2.02460e+03,
1.33352e-03,1.97437e+03,1.97015e+03,1.34098e-03,1.94855e+03,1.94435e+03,1.35000e-03,1.91795e+03,1.91376e+03,1.35540e-03,
1.89985e+03,1.89567e+03,1.36458e-03,1.86952e+03,1.86536e+03,1.38038e-03,1.81900e+03,1.81486e+03,1.40955e-03,1.73020e+03,
1.72612e+03,1.41254e-03,1.72145e+03,1.71737e+03,1.46218e-03,1.58497e+03,1.58098e+03,1.47911e-03,1.54188e+03,1.53792e+03,
1.47916e-03,1.54174e+03,1.53779e+03,1.51356e-03,1.45893e+03,1.45504e+03,1.53109e-03,1.41902e+03,1.41516e+03,1.55077e-03,
1.37579e+03,1.37197e+03,1.56675e-03,1.34204e+03,1.33825e+03,1.58489e-03,1.30520e+03,1.30145e+03,1.58490e-03,1.30518e+03,
1.30144e+03,1.61811e-03,1.24154e+03,1.23787e+03,1.64059e-03,1.20092e+03,1.19730e+03,1.65000e-03,1.18452e+03,1.18092e+03,
1.65959e-03,1.16804e+03,1.16446e+03,1.67880e-03,1.13583e+03,1.13230e+03,1.67891e-03,1.13565e+03,1.13212e+03,1.73237e-03,
1.05165e+03,1.04825e+03,1.75792e-03,1.01455e+03,1.01123e+03,1.77768e-03,9.87261e+02,9.83988e+02,1.81970e-03,9.32532e+02,
9.29388e+02,1.82088e-03,9.31059e+02,9.27918e+02,1.85000e-03,8.95639e+02,8.92598e+02,1.85797e-03,8.86266e+02,8.83252e+02,
1.86209e-03,8.81469e+02,8.78471e+02,1.88365e-03,8.56849e+02,8.53932e+02,1.88404e-03,8.56405e+02,8.53489e+02,1.90000e-03,
8.38674e+02,8.35826e+02,1.90546e-03,8.32713e+02,8.29888e+02,1.91371e-03,8.23844e+02,8.21053e+02,1.93881e-03,7.97616e+02,
7.94944e+02,1.95828e-03,7.78063e+02,7.75497e+02,1.97242e-03,7.64265e+02,7.61785e+02,1.97675e-03,7.60122e+02,7.57668e+02,
1.99422e-03,7.43702e+02,7.41372e+02,1.99526e-03,7.42739e+02,7.40418e+02,1.99530e-03,7.42704e+02,7.40383e+02,2.00825e-03,
7.30858e+02,7.28645e+02,2.01837e-03,7.21767e+02,7.19650e+02,2.01970e-03,7.20580e+02,7.18476e+02,2.03263e-03,7.09228e+02,
7.07258e+02,2.04174e-03,7.01386e+02,6.99506e+02,2.04521e-03,6.98415e+02,6.96569e+02,2.05144e-03,6.93146e+02,6.91349e+02,
2.05661e-03,6.88823e+02,6.87057e+02,2.05929e-03,6.86597e+02,6.84843e+02,2.06473e-03,6.82132e+02,6.80391e+02,2.06538e-03,
6.81599e+02,6.79858e+02,2.06959e-03,6.78178e+02,6.76438e+02,2.07145e-03,6.76674e+02,6.74933e+02,2.07662e-03,6.72529e+02,
6.70773e+02,2.08150e-03,6.68663e+02,6.66885e+02,2.08150e-03,2.52866e+03,2.47997e+03,2.08158e-03,2.52844e+03,2.47976e+03,
2.08661e-03,2.51578e+03,2.46740e+03,2.08930e-03,2.50904e+03,2.46082e+03,2.09445e-03,2.49619e+03,2.44827e+03,2.10939e-03,
2.45946e+03,2.41236e+03,2.11349e-03,2.44953e+03,2.40265e+03,2.14500e-03,2.37515e+03,2.32985e+03,2.15970e-03,2.33551e+03,
2.29101e+03,2.15970e-03,3.23238e+03,3.16319e+03,2.16024e-03,3.23044e+03,3.16129e+03,2.16800e-03,3.20280e+03,3.13436e+03,
2.17290e-03,3.18730e+03,3.11927e+03,2.17836e-03,3.17015e+03,3.10257e+03,2.19000e-03,3.13405e+03,3.06741e+03,2.19227e-03,
3.12639e+03,3.05995e+03,2.20174e-03,3.09476e+03,3.02912e+03,2.20767e-03,3.07518e+03,3.01005e+03,2.21310e-03,3.05741e+03,
2.99275e+03,2.21870e-03,3.03921e+03,2.97501e+03,2.22765e-03,3.01044e+03,2.94699e+03,2.23987e-03,2.97180e+03,2.90937e+03,
2.25330e-03,2.93011e+03,2.86877e+03,2.26464e-03,2.89553e+03,2.83511e+03,2.27039e-03,2.87825e+03,2.81829e+03,2.28621e-03,
2.83140e+03,2.77269e+03,2.29087e-03,2.81780e+03,2.75945e+03,2.30000e-03,2.79000e+03,2.73239e+03,2.31740e-03,2.73808e+03,
2.68183e+03,2.32351e-03,2.72013e+03,2.66435e+03,2.33335e-03,2.69158e+03,2.63654e+03,2.34353e-03,2.66252e+03,2.60821e+03,
2.34423e-03,2.66054e+03,2.60628e+03,2.35490e-03,2.63058e+03,2.57706e+03,2.35490e-03,3.01066e+03,2.94847e+03,2.35727e-03,
3.00347e+03,2.94147e+03,2.39595e-03,2.88964e+03,2.83049e+03,2.40000e-03,2.87808e+03,2.81921e+03,2.40695e-03,2.85791e+03,
2.79954e+03,2.41900e-03,2.82341e+03,2.76589e+03,2.42661e-03,2.80190e+03,2.74493e+03,2.43000e-03,2.79241e+03,2.73567e+03,
2.43267e-03,2.78486e+03,2.72831e+03,2.45109e-03,2.73354e+03,2.67828e+03,2.47202e-03,2.67680e+03,2.62296e+03,2.48313e-03,
2.64735e+03,2.59425e+03,2.49142e-03,2.62573e+03,2.57316e+03,2.51189e-03,2.57334e+03,2.52208e+03,2.51190e-03,2.57331e+03,
2.52204e+03,2.51975e-03,2.55361e+03,2.50283e+03,2.54097e-03,2.50139e+03,2.45190e+03,2.57040e-03,2.43149e+03,2.38371e+03,
2.57931e-03,2.41068e+03,2.36340e+03,2.60016e-03,2.36297e+03,2.31685e+03,2.63027e-03,2.29630e+03,2.25178e+03,2.63588e-03,
2.28410e+03,2.23986e+03,2.69154e-03,2.16769e+03,2.12620e+03,2.70707e-03,2.13672e+03,2.09595e+03,2.72270e-03,2.10618e+03,
2.06613e+03,2.78612e-03,1.98846e+03,1.95111e+03,2.80473e-03,1.95572e+03,1.91911e+03,2.81838e-03,1.93216e+03,1.89609e+03,
2.85102e-03,1.87706e+03,1.84222e+03,2.88403e-03,1.82354e+03,1.78989e+03,2.90000e-03,1.79843e+03,1.76533e+03,2.92204e-03,
1.76454e+03,1.73218e+03,2.95121e-03,1.72103e+03,1.68961e+03,3.05492e-03,1.57817e+03,1.54980e+03,3.07100e-03,1.55748e+03,
1.52953e+03,3.09030e-03,1.53314e+03,1.50570e+03,3.16228e-03,1.44680e+03,1.42115e+03,3.16230e-03,1.44678e+03,1.42112e+03,
3.19889e-03,1.40553e+03,1.38071e+03,3.19986e-03,1.40446e+03,1.37966e+03,3.23594e-03,1.36543e+03,1.34141e+03,3.27341e-03,
1.32603e+03,1.30280e+03,3.31131e-03,1.28779e+03,1.26531e+03,3.34965e-03,1.25069e+03,1.22893e+03,3.38189e-03,1.22067e+03,
1.19949e+03,3.42768e-03,1.17974e+03,1.15935e+03,3.46737e-03,1.14570e+03,1.12596e+03,3.54813e-03,1.08062e+03,1.06209e+03,
3.58922e-03,1.04919e+03,1.03124e+03,3.63078e-03,1.01866e+03,1.00126e+03,3.65000e-03,1.00497e+03,9.87822e+02,3.65996e-03,
9.97970e+02,9.80946e+02,3.67282e-03,9.89029e+02,9.72167e+02,3.71535e-03,9.60083e+02,9.43740e+02,3.80189e-03,9.04782e+02,
8.89417e+02,3.84592e-03,8.78197e+02,8.63295e+02,3.90000e-03,8.47027e+02,8.32662e+02,3.94338e-03,8.23148e+02,8.09190e+02,
3.98107e-03,8.03151e+02,7.89535e+02,3.98110e-03,8.03136e+02,7.89521e+02,4.00000e-03,7.93371e+02,7.79922e+02,4.02717e-03,
7.79626e+02,7.66409e+02,4.07380e-03,7.56795e+02,7.43962e+02,4.12097e-03,7.34653e+02,7.22189e+02,4.15000e-03,7.21429e+02,
7.09184e+02,4.16869e-03,7.13078e+02,7.00971e+02,4.21696e-03,6.92129e+02,6.80365e+02,4.35692e-03,6.35391e+02,6.24538e+02,
4.36516e-03,6.32255e+02,6.21452e+02,4.41570e-03,6.13375e+02,6.02873e+02,4.51856e-03,5.77333e+02,5.67400e+02,4.57088e-03,
5.60127e+02,5.50462e+02,4.62381e-03,5.43450e+02,5.34043e+02,4.73151e-03,5.11619e+02,5.02699e+02,4.75834e-03,5.04055e+02,
4.95249e+02,4.80000e-03,4.92607e+02,4.83977e+02,4.89779e-03,4.67147e+02,4.58901e+02,4.95450e-03,4.53219e+02,4.45181e+02,
5.01187e-03,4.39627e+02,4.31791e+02,5.01190e-03,4.39620e+02,4.31785e+02,5.06991e-03,4.26418e+02,4.18777e+02,5.12861e-03,
4.13617e+02,4.06163e+02,5.22006e-03,3.94723e+02,3.87544e+02,5.24807e-03,3.89173e+02,3.82075e+02,5.37032e-03,3.66215e+02,
3.59453e+02,5.43250e-03,3.55251e+02,3.48648e+02,5.49541e-03,3.44524e+02,3.38075e+02,5.50000e-03,3.43759e+02,3.37321e+02,
5.62341e-03,3.23986e+02,3.17830e+02,5.68853e-03,3.14147e+02,3.08130e+02,5.75440e-03,3.04611e+02,2.98727e+02,5.81874e-03,
2.95683e+02,2.89925e+02,5.82103e-03,2.95372e+02,2.89618e+02,5.95662e-03,2.77738e+02,2.72235e+02,6.09537e-03,2.61192e+02,
2.55924e+02,6.30957e-03,2.38239e+02,2.33294e+02,6.30960e-03,2.38236e+02,2.33291e+02,6.38263e-03,2.31011e+02,2.26167e+02,
6.51746e-03,2.18387e+02,2.13719e+02,6.60693e-03,2.10527e+02,2.05970e+02,6.68344e-03,2.04118e+02,1.99653e+02,6.76083e-03,
1.97882e+02,1.93505e+02,6.91831e-03,1.85995e+02,1.81786e+02,7.16143e-03,1.69518e+02,1.65543e+02,7.19907e-03,1.67142e+02,
1.63201e+02,7.24436e-03,1.64342e+02,1.60442e+02,7.41310e-03,1.54414e+02,1.50658e+02,7.49894e-03,1.49685e+02,1.45998e+02,
7.50000e-03,1.49628e+02,1.45942e+02,7.58578e-03,1.45103e+02,1.41484e+02,7.67362e-03,1.40653e+02,1.37099e+02,7.80000e-03,
1.34580e+02,1.31116e+02,7.85236e-03,1.32170e+02,1.28741e+02,7.93186e-03,1.28626e+02,1.25249e+02,7.94328e-03,1.28127e+02,
1.24758e+02,7.94330e-03,1.28126e+02,1.24757e+02,8.12830e-03,1.20408e+02,1.17157e+02,8.22243e-03,1.16707e+02,1.13513e+02,
8.41395e-03,1.09654e+02,1.06569e+02,8.46622e-03,1.07823e+02,1.04766e+02,8.51138e-03,1.06273e+02,1.03241e+02,8.60994e-03,
1.03000e+02,1.00020e+02,8.70964e-03,9.98288e+01,9.69000e+01,8.81049e-03,9.67586e+01,9.38796e+01,8.91251e-03,9.37759e+01,
9.09455e+01,9.00000e-03,9.13175e+01,8.85274e+01,9.11702e-03,8.81701e+01,8.54319e+01,9.22571e-03,8.53777e+01,8.26875e+01,
9.44061e-03,8.02096e+01,7.76094e+01,9.54993e-03,7.77486e+01,7.51918e+01,9.77237e-03,7.30251e+01,7.05519e+01,9.80000e-03,
7.24668e+01,7.00036e+01,9.88109e-03,7.08534e+01,6.84191e+01,9.88553e-03,7.07663e+01,6.83336e+01,1.00000e-02,6.85751e+01,
6.61837e+01,1.01158e-02,6.64525e+01,6.41014e+01,1.02329e-02,6.43990e+01,6.20872e+01,1.03514e-02,6.24111e+01,6.01378e+01,
1.04713e-02,6.04852e+01,5.82494e+01,1.06991e-02,5.70398e+01,5.48720e+01,1.08393e-02,5.50515e+01,5.29254e+01,1.09648e-02,
5.33525e+01,5.12624e+01,1.12202e-02,5.00958e+01,4.80755e+01,1.13501e-02,4.85454e+01,4.65589e+01,1.14815e-02,4.70442e+01,
4.50906e+01,1.15645e-02,4.61260e+01,4.41927e+01,1.16145e-02,4.55831e+01,4.36625e+01,1.18850e-02,4.27989e+01,4.09442e+01,
1.20226e-02,4.14727e+01,3.96499e+01,1.23027e-02,3.89463e+01,3.71852e+01,1.24409e-02,3.77755e+01,3.60433e+01,1.24451e-02,
3.77406e+01,3.60093e+01,1.25890e-02,3.65662e+01,3.48655e+01,1.25892e-02,3.65642e+01,3.48635e+01,1.27350e-02,3.54245e+01,
3.37537e+01,1.28825e-02,3.43216e+01,3.26801e+01,1.28914e-02,3.42566e+01,3.26168e+01,1.30317e-02,3.32530e+01,3.16416e+01,
1.31826e-02,3.22183e+01,3.06364e+01,1.34896e-02,3.02480e+01,2.87230e+01,1.35000e-02,3.01844e+01,2.86613e+01,1.36458e-02,
2.93064e+01,2.78090e+01,1.37444e-02,2.87333e+01,2.72528e+01,1.41254e-02,2.66526e+01,2.52390e+01,1.44412e-02,2.50851e+01,
2.37231e+01,1.44544e-02,2.50221e+01,2.36623e+01,1.46218e-02,2.42362e+01,2.29044e+01,1.47911e-02,2.34757e+01,2.21713e+01,
1.49624e-02,2.27391e+01,2.14614e+01,1.50000e-02,2.25810e+01,2.13096e+01,1.51356e-02,2.20238e+01,2.07747e+01,1.53109e-02,
2.13315e+01,2.01103e+01,1.54214e-02,2.09103e+01,1.97062e+01,1.54882e-02,2.06602e+01,1.94676e+01,1.56675e-02,2.00087e+01,
1.88459e+01,1.57886e-02,1.95845e+01,1.84412e+01,1.58489e-02,1.93765e+01,1.82442e+01,1.58490e-02,1.93763e+01,1.82439e+01,
1.60527e-02,1.86941e+01,1.75977e+01,1.62573e-02,1.80352e+01,1.69793e+01,1.63556e-02,1.77269e+01,1.66928e+01,1.64358e-02,
1.74780e+01,1.64638e+01,1.65041e-02,1.72675e+01,1.62721e+01,1.65946e-02,1.69899e+01,1.60227e+01,1.65959e-02,1.69860e+01,
1.60193e+01,1.67082e-02,1.66446e+01,1.57175e+01,1.67880e-02,1.64076e+01,1.55078e+01,1.68236e-02,1.63029e+01,1.54150e+01,
1.68831e-02,1.61337e+01,1.52611e+01,1.69278e-02,1.60117e+01,1.51468e+01,1.69790e-02,1.58786e+01,1.50177e+01,1.70000e-02,
1.58263e+01,1.49649e+01,1.70000e-02,1.03716e+02,4.67292e+01,1.70246e-02,1.03346e+02,4.66394e+01,1.70694e-02,1.02683e+02,
4.64761e+01,1.71297e-02,1.01805e+02,4.62564e+01,1.71791e-02,1.01097e+02,4.60770e+01,1.73322e-02,9.89499e+01,4.55221e+01,
1.73780e-02,9.83188e+01,4.53568e+01,1.74000e-02,9.80179e+01,4.52775e+01,1.74095e-02,9.78695e+01,4.52345e+01,1.74953e-02,
9.65407e+01,4.48484e+01,1.75544e-02,9.56378e+01,4.45841e+01,1.75792e-02,9.52604e+01,4.44732e+01,1.76000e-02,9.49470e+01,
4.43809e+01,1.76176e-02,9.47132e+01,4.43172e+01,1.77478e-02,9.30018e+01,4.38470e+01,1.77828e-02,9.25489e+01,4.37214e+01,
1.79460e-02,9.04755e+01,4.31384e+01,1.79887e-02,8.99427e+01,4.29867e+01,1.81646e-02,8.77954e+01,4.23664e+01,1.81970e-02,
8.74068e+01,4.22528e+01,1.82000e-02,8.73712e+01,4.22424e+01,1.85194e-02,8.34990e+01,4.10502e+01,1.86209e-02,8.23178e+01,
4.06779e+01,1.88365e-02,7.98837e+01,3.98973e+01,1.89584e-02,7.85511e+01,3.94620e+01,1.94985e-02,7.30012e+01,3.75899e+01,
1.97242e-02,7.08715e+01,3.68506e+01,1.99526e-02,6.88021e+01,3.61171e+01,1.99530e-02,6.87987e+01,3.61159e+01,2.01586e-02,
6.70074e+01,3.54688e+01,2.01837e-02,6.67933e+01,3.53908e+01,2.04174e-02,6.48427e+01,3.46724e+01,2.06538e-02,6.29489e+01,
3.39616e+01,2.08930e-02,6.11111e+01,3.32593e+01,2.11086e-02,5.95176e+01,3.26401e+01,2.11349e-02,5.93275e+01,3.25657e+01,
2.13796e-02,5.75954e+01,3.18810e+01,2.16272e-02,5.58627e+01,3.11760e+01,2.18776e-02,5.41828e+01,3.04817e+01,2.22377e-02,
5.18881e+01,2.95156e+01,2.23872e-02,5.09741e+01,2.91253e+01,2.26464e-02,4.94412e+01,2.84630e+01,2.29087e-02,4.79549e+01,
2.78167e+01,2.31740e-02,4.65138e+01,2.71811e+01,2.37137e-02,4.37582e+01,2.59401e+01,2.38850e-02,4.29314e+01,2.55611e+01,
2.39883e-02,4.24427e+01,2.53358e+01,2.42661e-02,4.11664e+01,2.47421e+01,2.45471e-02,3.99289e+01,2.41592e+01,2.48313e-02,
3.87288e+01,2.35869e+01,2.51189e-02,3.75652e+01,2.30254e+01,2.51190e-02,3.75646e+01,2.30252e+01,2.54097e-02,3.64367e+01,
2.24745e+01,2.57040e-02,3.53426e+01,2.19343e+01,2.60016e-02,3.42818e+01,2.14047e+01,2.60145e-02,3.42366e+01,2.13820e+01,
2.66073e-02,3.22548e+01,2.03769e+01,2.69154e-02,3.12664e+01,1.98649e+01,2.72270e-02,3.03086e+01,1.93637e+01,2.81838e-02,
2.76066e+01,1.79223e+01,2.83266e-02,2.72321e+01,1.77192e+01,2.85102e-02,2.67608e+01,1.74626e+01,2.91743e-02,2.51468e+01,
1.65739e+01,3.00000e-02,2.33219e+01,1.55497e+01,3.01995e-02,2.29085e+01,1.53148e+01,3.13713e-02,2.06746e+01,1.40257e+01,
3.16228e-02,2.02344e+01,1.37679e+01,3.16230e-02,2.02341e+01,1.37677e+01,3.19889e-02,1.96159e+01,1.34043e+01,3.23594e-02,
1.90163e+01,1.30492e+01,3.31131e-02,1.78724e+01,1.23644e+01,3.34965e-02,1.73164e+01,1.20268e+01,3.42768e-02,1.62565e+01,
1.13766e+01,3.45119e-02,1.59548e+01,1.11898e+01,3.46737e-02,1.57515e+01,1.10637e+01,3.58922e-02,1.43294e+01,1.01719e+01,
3.71535e-02,1.30379e+01,9.34691e+00,3.71767e-02,1.30157e+01,9.33260e+00,3.75837e-02,1.26334e+01,9.08564e+00,3.84592e-02,
1.18624e+01,8.58337e+00,3.93550e-02,1.11391e+01,8.10705e+00,3.98107e-02,1.07944e+01,7.87825e+00,3.98110e-02,1.07942e+01,
7.87811e+00,4.08987e-02,1.00291e+01,7.36605e+00,4.12097e-02,9.82389e+00,7.22782e+00,4.16869e-02,9.52037e+00,7.02251e+00,
4.21696e-02,9.22171e+00,6.81906e+00,4.36516e-02,8.38190e+00,6.24174e+00,4.41570e-02,8.11971e+00,6.05986e+00,4.46684e-02,
7.86562e+00,5.88281e+00,4.51856e-02,7.61969e+00,5.71071e+00,4.67735e-02,6.92816e+00,5.22280e+00,4.73151e-02,6.71222e+00,
5.06920e+00,4.78630e-02,6.50317e+00,4.91992e+00,4.94321e-02,5.95243e+00,4.52429e+00,5.01187e-02,5.73167e+00,4.36460e+00,
5.01190e-02,5.73158e+00,4.36454e+00,5.12861e-02,5.38154e+00,4.11009e+00,5.18800e-02,5.21486e+00,3.98828e+00,5.24807e-02,
5.05144e+00,3.86828e+00,5.30884e-02,4.89314e+00,3.75163e+00,5.37032e-02,4.73996e+00,3.63840e+00,5.51080e-02,4.41422e+00,
3.39635e+00,5.55904e-02,4.30950e+00,3.31823e+00,6.24459e-02,3.13545e+00,2.42938e+00,6.30957e-02,3.04862e+00,2.36263e+00,
6.30960e-02,3.04858e+00,2.36260e+00,6.38264e-02,2.95482e+00,2.29044e+00,6.48707e-02,2.82640e+00,2.19122e+00,6.60693e-02,
2.68850e+00,2.08435e+00,6.68344e-02,2.60544e+00,2.01980e+00,6.76083e-02,2.52508e+00,1.95721e+00,6.83912e-02,2.44735e+00,
1.89653e+00,7.07946e-02,2.22902e+00,1.72542e+00,7.67362e-02,1.79662e+00,1.38335e+00,7.76247e-02,1.74258e+00,1.34028e+00,
7.94328e-02,1.63972e+00,1.25811e+00,7.94330e-02,1.63971e+00,1.25811e+00,8.03526e-02,1.59069e+00,1.21896e+00,8.12830e-02,
1.54285e+00,1.18066e+00,8.22243e-02,1.49657e+00,1.14356e+00,8.31764e-02,1.45180e+00,1.10763e+00,8.41395e-02,1.40851e+00,
1.07282e+00,8.70964e-02,1.28693e+00,9.74863e-01,9.18002e-02,1.12358e+00,8.42738e-01,9.54993e-02,1.01611e+00,7.55517e-01,
9.77237e-02,9.58841e-01,7.08919e-01,1.00000e-01,9.05241e-01,6.65241e-01,1.01158e-01,8.79665e-01,6.44472e-01,1.02329e-01,
8.54922e-01,6.24369e-01,1.03514e-01,8.30978e-01,6.04904e-01,1.04713e-01,8.07809e-01,5.86060e-01,1.05925e-01,7.85393e-01,
5.67819e-01,1.09648e-01,7.22133e-01,5.16279e-01,1.10918e-01,7.02403e-01,5.00195e-01,1.13501e-01,6.64845e-01,4.69566e-01,
1.13677e-01,6.62410e-01,4.67580e-01,1.16145e-01,6.29640e-01,4.40882e-01,1.17490e-01,6.12887e-01,4.27231e-01,1.18850e-01,
5.96677e-01,4.14023e-01,1.20226e-01,5.80991e-01,4.01241e-01,1.25890e-01,5.23173e-01,3.54138e-01,1.25893e-01,5.23149e-01,
3.54119e-01,1.30317e-01,4.84260e-01,3.22721e-01,1.31826e-01,4.72118e-01,3.12927e-01,1.34896e-01,4.48986e-01,2.94286e-01,
1.35919e-01,4.41717e-01,2.88432e-01,1.36458e-01,4.37966e-01,2.85418e-01,1.38038e-01,4.27287e-01,2.76839e-01,1.42889e-01,
3.97246e-01,2.52743e-01,1.46218e-01,3.78774e-01,2.37960e-01,1.47911e-01,3.69975e-01,2.30928e-01,1.51356e-01,3.53201e-01,
2.17544e-01,1.54882e-01,3.37470e-01,2.05021e-01,1.58489e-01,3.22713e-01,1.93304e-01,1.58490e-01,3.22710e-01,1.93302e-01,
1.60324e-01,3.15620e-01,1.87763e-01,1.64059e-01,3.02088e-01,1.77220e-01,1.65959e-01,2.95636e-01,1.72207e-01,1.67880e-01,
2.89384e-01,1.67358e-01,1.68821e-01,2.86420e-01,1.65063e-01,1.71791e-01,2.77438e-01,1.58132e-01,1.73780e-01,2.71738e-01,
1.53744e-01,1.75792e-01,2.66212e-01,1.49500e-01,1.77828e-01,2.60856e-01,1.45395e-01,1.79887e-01,2.55664e-01,1.41425e-01,
1.84077e-01,2.45751e-01,1.33871e-01,1.86209e-01,2.41020e-01,1.30279e-01,1.88365e-01,2.36467e-01,1.26838e-01,1.92752e-01,
2.27767e-01,1.20288e-01,1.94984e-01,2.23611e-01,1.17171e-01,1.97242e-01,2.19581e-01,1.14158e-01,1.99526e-01,2.15671e-01,
1.11242e-01,1.99530e-01,2.15664e-01,1.11238e-01,2.00000e-01,2.14869e-01,1.10660e-01,2.01837e-01,2.11827e-01,1.08452e-01,
2.04174e-01,2.08095e-01,1.05752e-01,2.06538e-01,2.04472e-01,1.03140e-01,2.13796e-01,1.94224e-01,9.58027e-02,2.18461e-01,
1.88262e-01,9.15732e-02,2.18776e-01,1.87876e-01,9.13004e-02,2.21309e-01,1.84833e-01,8.91582e-02,2.23872e-01,1.81877e-01,
8.70855e-02,2.26464e-01,1.79005e-01,8.50800e-02,2.34423e-01,1.70941e-01,7.95152e-02,2.42661e-01,1.63529e-01,7.44669e-02,
2.45471e-01,1.61196e-01,7.28924e-02,2.48313e-01,1.58926e-01,7.13682e-02,2.51189e-01,1.56717e-01,6.98923e-02,2.51190e-01,
1.56716e-01,6.98916e-02,2.54097e-01,1.54527e-01,6.84921e-02,2.57040e-01,1.52395e-01,6.71364e-02,2.66073e-01,1.46331e-01,
6.33222e-02,2.72270e-01,1.42581e-01,6.10098e-02,2.75423e-01,1.40778e-01,5.99073e-02,2.81838e-01,1.37307e-01,5.78041e-02,
2.85102e-01,1.35636e-01,5.68011e-02,2.88403e-01,1.34009e-01,5.58305e-02,2.95121e-01,1.30874e-01,5.39781e-02,3.00000e-01,
1.28734e-01,5.27280e-02,3.00006e-01,1.28732e-01,5.27265e-02,3.01995e-01,1.27891e-01,5.22382e-02,3.02562e-01,1.27654e-01,
5.21012e-02,3.05492e-01,1.26451e-01,5.14081e-02,3.09029e-01,1.25046e-01,5.06033e-02,3.12608e-01,1.23689e-01,4.98363e-02,
3.16228e-01,1.22363e-01,4.90921e-02,3.16230e-01,1.22362e-01,4.90917e-02,3.19889e-01,1.21035e-01,4.83969e-02,3.27341e-01,
1.18468e-01,4.70678e-02,3.34965e-01,1.16017e-01,4.58181e-02,3.38844e-01,1.14832e-01,4.52207e-02,3.46737e-01,1.12539e-01,
4.40780e-02,3.50752e-01,1.11430e-01,4.35314e-02,3.54813e-01,1.10355e-01,4.30106e-02,3.58922e-01,1.09302e-01,4.25044e-02,
3.63078e-01,1.08272e-01,4.20123e-02,3.67282e-01,1.07262e-01,4.15340e-02,3.71535e-01,1.06273e-01,4.10689e-02,3.75837e-01,
1.05305e-01,4.06175e-02,3.80189e-01,1.04357e-01,4.01784e-02,3.84592e-01,1.03427e-01,3.97513e-02,3.93550e-01,1.01622e-01,
3.89317e-02,3.98107e-01,1.00755e-01,3.85465e-02,3.98110e-01,1.00754e-01,3.85463e-02,4.00000e-01,1.00391e-01,3.84009e-02,
4.02717e-01,9.98764e-02,3.81956e-02,4.07380e-01,9.90143e-02,3.78537e-02,4.12098e-01,9.81679e-02,3.75205e-02,4.16869e-01,
9.73367e-02,3.71957e-02,4.21697e-01,9.65213e-02,3.68797e-02,4.26580e-01,9.57202e-02,3.65715e-02,4.31519e-01,9.49333e-02,
3.62708e-02,4.41570e-01,9.34004e-02,3.56914e-02,4.41968e-01,9.33421e-02,3.56698e-02,4.46684e-01,9.26592e-02,3.54183e-02,
4.51856e-01,9.19304e-02,3.51515e-02,4.57088e-01,9.12135e-02,3.48907e-02,4.62381e-01,9.05083e-02,3.46357e-02,4.67735e-01,
8.98146e-02,3.43864e-02,4.78630e-01,8.84614e-02,3.39050e-02,4.84172e-01,8.78007e-02,3.36720e-02,4.89779e-01,8.71505e-02,
3.34441e-02,4.95450e-01,8.65154e-02,3.32258e-02,5.01187e-01,8.58897e-02,3.30119e-02,5.01190e-01,8.58894e-02,3.30118e-02,
5.06991e-01,8.52495e-02,3.28227e-02,5.12861e-01,8.46186e-02,3.26369e-02,5.18800e-01,8.39968e-02,3.24546e-02,5.24808e-01,
8.33843e-02,3.22758e-02,5.30884e-01,8.27804e-02,3.21002e-02,5.37032e-01,8.21849e-02,3.19276e-02,5.43250e-01,8.15978e-02,
3.17580e-02,5.49541e-01,8.10228e-02,3.15951e-02,5.62341e-01,7.98955e-02,3.12768e-02,5.75440e-01,7.87975e-02,3.09677e-02,
5.82103e-01,7.82594e-02,3.08168e-02,5.88844e-01,7.77281e-02,3.06679e-02,5.95662e-01,7.72035e-02,3.05211e-02,6.00000e-01,
7.68762e-02,3.04296e-02,6.02560e-01,7.66854e-02,3.03762e-02,6.09537e-01,7.61770e-02,3.02364e-02,6.23735e-01,7.51783e-02,
2.99617e-02,6.30957e-01,7.46878e-02,2.98267e-02,6.30960e-01,7.46876e-02,2.98266e-02,6.38264e-01,7.41813e-02,2.97101e-02,
6.45654e-01,7.36808e-02,2.95947e-02,6.53131e-01,7.31861e-02,2.94802e-02,6.60694e-01,7.26970e-02,2.93666e-02,6.68344e-01,
7.22158e-02,2.92562e-02,6.76083e-01,7.17399e-02,2.91465e-02,6.83912e-01,7.12691e-02,2.90373e-02,6.84404e-01,7.12398e-02,
2.90305e-02,6.91831e-01,7.08030e-02,2.89288e-02,6.99842e-01,7.03421e-02,2.88211e-02,7.07946e-01,6.98861e-02,2.87139e-02,
7.16143e-01,6.94348e-02,2.86072e-02,7.24436e-01,6.89906e-02,2.85034e-02,7.32825e-01,6.85508e-02,2.83999e-02,7.41310e-01,
6.81155e-02,2.82968e-02,7.49894e-01,6.76844e-02,2.81940e-02,7.58578e-01,6.72576e-02,2.80916e-02,7.67362e-01,6.68350e-02,
2.79894e-02,7.85236e-01,6.60023e-02,2.77864e-02,7.94328e-01,6.55936e-02,2.76869e-02,7.94330e-01,6.55935e-02,2.76869e-02,
8.00000e-01,6.53321e-02,2.76349e-02,8.03526e-01,6.51712e-02,2.76026e-02,8.12831e-01,6.47527e-02,2.75180e-02,8.31764e-01,
6.39272e-02,2.73479e-02,8.51138e-01,6.31168e-02,2.71768e-02,8.60994e-01,6.27172e-02,2.70909e-02,8.70964e-01,6.23211e-02,
2.70048e-02,8.81049e-01,6.19295e-02,2.69195e-02,8.91251e-01,6.15414e-02,2.68338e-02,9.01571e-01,6.11567e-02,2.67479e-02,
9.12011e-01,6.07752e-02,2.66617e-02,9.22571e-01,6.03971e-02,2.65752e-02,9.44061e-01,5.96504e-02,2.64014e-02,9.54993e-01,
5.92819e-02,2.63143e-02,9.66051e-01,5.89179e-02,2.62283e-02,9.77237e-01,5.85568e-02,2.61420e-02,9.88553e-01,5.81987e-02,
2.60554e-02,1.00000e+00,5.78435e-02,2.59685e-02,1.00000e-03,4.20753e+03,4.20247e+03,1.00242e-03,4.18431e+03,4.17926e+03,
1.01158e-03,4.09811e+03,4.09307e+03,1.02329e-03,3.99128e+03,3.98625e+03,1.04000e-03,3.84561e+03,3.84061e+03,1.04713e-03,
3.78586e+03,3.78087e+03,1.05446e-03,3.72589e+03,3.72091e+03,1.05925e-03,3.68738e+03,3.68241e+03,1.08393e-03,3.49723e+03,
3.49230e+03,1.09648e-03,3.40609e+03,3.40119e+03,1.10211e-03,3.36614e+03,3.36124e+03,1.11000e-03,3.31128e+03,3.30640e+03,
1.16145e-03,2.98067e+03,2.97587e+03,1.16828e-03,2.94030e+03,2.93551e+03,1.20226e-03,2.75047e+03,2.74573e+03,1.21619e-03,
2.67783e+03,2.67312e+03,1.23027e-03,2.60651e+03,2.60182e+03,1.24451e-03,2.53672e+03,2.53205e+03,1.25890e-03,2.46902e+03,
2.46437e+03,1.25892e-03,2.46890e+03,2.46425e+03,1.27350e-03,2.40289e+03,2.39826e+03,1.28825e-03,2.33833e+03,2.33372e+03,
1.28939e-03,2.33345e+03,2.32885e+03,1.30317e-03,2.27561e+03,2.27103e+03,1.33352e-03,2.15541e+03,2.15088e+03,1.35000e-03,
2.09383e+03,2.08932e+03,1.35377e-03,2.08008e+03,2.07558e+03,1.36458e-03,2.04136e+03,2.03689e+03,1.39637e-03,1.93234e+03,
1.92791e+03,1.41254e-03,1.88011e+03,1.87572e+03,1.42595e-03,1.83804e+03,1.83367e+03,1.42889e-03,1.82897e+03,1.82460e+03,
1.46218e-03,1.73106e+03,1.72675e+03,1.47911e-03,1.68418e+03,1.67990e+03,1.49624e-03,1.63845e+03,1.63420e+03,1.50000e-03,
1.62864e+03,1.62439e+03,1.51356e-03,1.59401e+03,1.58978e+03,1.53109e-03,1.55067e+03,1.54648e+03,1.54882e-03,1.50831e+03,
1.50415e+03,1.56675e-03,1.46686e+03,1.46274e+03,1.57802e-03,1.44165e+03,1.43754e+03,1.58489e-03,1.42658e+03,1.42249e+03,
1.58490e-03,1.42657e+03,1.42247e+03,1.62181e-03,1.34927e+03,1.34525e+03,1.64059e-03,1.31214e+03,1.30815e+03,1.65261e-03,
1.28919e+03,1.28522e+03,1.69824e-03,1.20702e+03,1.20315e+03,1.71791e-03,1.17386e+03,1.17003e+03,1.72616e-03,1.16029e+03,
1.15647e+03,1.73000e-03,1.15403e+03,1.15023e+03,1.75792e-03,1.10968e+03,1.10594e+03,1.77828e-03,1.07888e+03,1.07518e+03,
1.78962e-03,1.06226e+03,1.05859e+03,1.80000e-03,1.04735e+03,1.04371e+03,1.81970e-03,1.01979e+03,1.01619e+03,1.84077e-03,
9.91465e+02,9.87914e+02,1.84874e-03,9.81058e+02,9.77525e+02,1.86209e-03,9.63951e+02,9.60454e+02,1.90178e-03,9.15480e+02,
9.12087e+02,1.90546e-03,9.11157e+02,9.07775e+02,1.92753e-03,8.85788e+02,8.82470e+02,1.94401e-03,8.67293e+02,8.64023e+02,
1.94984e-03,8.60877e+02,8.57626e+02,1.97242e-03,8.36697e+02,8.33518e+02,1.98013e-03,8.28662e+02,8.25507e+02,1.99526e-03,
8.13199e+02,8.10099e+02,1.99530e-03,8.13161e+02,8.10061e+02,2.01482e-03,7.93756e+02,7.90724e+02,2.01837e-03,7.90296e+02,
7.87279e+02,2.04487e-03,7.65165e+02,7.62253e+02,2.06538e-03,7.46461e+02,7.43642e+02,2.07357e-03,7.39190e+02,7.36407e+02,
2.09551e-03,7.20179e+02,7.17509e+02,2.11349e-03,7.05086e+02,7.02522e+02,2.11567e-03,7.03287e+02,7.00735e+02,2.13251e-03,
6.89606e+02,6.87169e+02,2.13796e-03,6.85251e+02,6.82858e+02,2.14741e-03,6.77732e+02,6.75413e+02,2.15000e-03,6.75692e+02,
6.73397e+02,2.15952e-03,6.68228e+02,6.66018e+02,2.16272e-03,6.65740e+02,6.63563e+02,2.17562e-03,6.55831e+02,6.53777e+02,
2.18662e-03,6.47549e+02,6.45593e+02,2.18776e-03,6.46697e+02,6.44750e+02,2.19238e-03,6.43272e+02,6.41359e+02,2.19819e-03,
6.39002e+02,6.37122e+02,2.20444e-03,6.34471e+02,6.32613e+02,2.20893e-03,6.31253e+02,6.29403e+02,2.21310e-03,6.28295e+02,
6.26444e+02,2.21397e-03,6.27677e+02,6.25825e+02,2.21905e-03,6.24110e+02,6.22249e+02,2.22000e-03,6.23445e+02,6.21580e+02,
2.22467e-03,6.20191e+02,6.18308e+02,2.22480e-03,6.20099e+02,6.18215e+02,2.22480e-03,2.32506e+03,2.27639e+03,2.23019e-03,
2.31133e+03,2.26302e+03,2.23855e-03,2.29027e+03,2.24248e+03,2.25067e-03,2.26021e+03,2.21317e+03,2.26464e-03,2.22629e+03,
2.18006e+03,2.29630e-03,2.15211e+03,2.10762e+03,2.31220e-03,2.11618e+03,2.07251e+03,2.31220e-03,2.92872e+03,2.86064e+03,
2.31740e-03,2.91268e+03,2.84504e+03,2.31843e-03,2.90951e+03,2.84196e+03,2.33204e-03,2.86811e+03,2.80171e+03,2.34473e-03,
2.83029e+03,2.76495e+03,2.35332e-03,2.80506e+03,2.74042e+03,2.36198e-03,2.77996e+03,2.71602e+03,2.37137e-03,2.75307e+03,
2.68988e+03,2.38251e-03,2.72168e+03,2.65936e+03,2.39582e-03,2.68480e+03,2.62353e+03,2.40000e-03,2.67336e+03,2.61242e+03,
2.40300e-03,2.66518e+03,2.60447e+03,2.40693e-03,2.65502e+03,2.59460e+03,2.42221e-03,2.61606e+03,2.55677e+03,2.42661e-03,
2.60499e+03,2.54603e+03,2.44000e-03,2.57169e+03,2.51369e+03,2.44038e-03,2.57071e+03,2.51274e+03,2.45471e-03,2.53416e+03,
2.47725e+03,2.46792e-03,2.50033e+03,2.44438e+03,2.48313e-03,2.46217e+03,2.40731e+03,2.49029e-03,2.44449e+03,2.39013e+03,
2.50000e-03,2.42081e+03,2.36710e+03,2.50078e-03,2.41891e+03,2.36525e+03,2.51189e-03,2.39224e+03,2.33930e+03,2.51190e-03,
2.39220e+03,2.33927e+03,2.51460e-03,2.38578e+03,2.33301e+03,2.51460e-03,2.73199e+03,2.67071e+03,2.51647e-03,2.72715e+03,
2.66600e+03,2.53200e-03,2.68750e+03,2.62744e+03,2.54097e-03,2.66496e+03,2.60551e+03,2.55503e-03,2.63021e+03,2.57170e+03,
2.56740e-03,2.60016e+03,2.54246e+03,2.57040e-03,2.59296e+03,2.53545e+03,2.58162e-03,2.56558e+03,2.50881e+03,2.59642e-03,
2.53010e+03,2.47430e+03,2.60016e-03,2.52124e+03,2.46568e+03,2.61603e-03,2.48369e+03,2.42915e+03,2.63877e-03,2.43119e+03,
2.37808e+03,2.66073e-03,2.38199e+03,2.33020e+03,2.66302e-03,2.37692e+03,2.32527e+03,2.69613e-03,2.30557e+03,2.25584e+03,
2.72270e-03,2.25046e+03,2.20220e+03,2.75423e-03,2.18740e+03,2.14081e+03,2.75718e-03,2.18164e+03,2.13519e+03,2.77000e-03,
2.15678e+03,2.11099e+03,2.78612e-03,2.12583e+03,2.08085e+03,2.81838e-03,2.06518e+03,2.02177e+03,2.83378e-03,2.03714e+03,
1.99445e+03,2.91743e-03,1.89370e+03,1.85466e+03,2.92693e-03,1.87834e+03,1.83967e+03,2.95121e-03,1.83984e+03,1.80213e+03,
3.00538e-03,1.75784e+03,1.72215e+03,3.01995e-03,1.73665e+03,1.70148e+03,3.09030e-03,1.63868e+03,1.60586e+03,3.09823e-03,
1.62812e+03,1.59556e+03,3.12608e-03,1.59182e+03,1.56012e+03,3.16228e-03,1.54629e+03,1.51566e+03,3.16230e-03,1.54626e+03,
1.51564e+03,3.19889e-03,1.50207e+03,1.47247e+03,3.23983e-03,1.45477e+03,1.42626e+03,3.27341e-03,1.41751e+03,1.38986e+03,
3.30000e-03,1.38893e+03,1.36192e+03,3.34965e-03,1.33754e+03,1.31169e+03,3.40000e-03,1.28808e+03,1.26332e+03,3.42382e-03,
1.26540e+03,1.24114e+03,3.42768e-03,1.26178e+03,1.23760e+03,3.46737e-03,1.22535e+03,1.20196e+03,3.50752e-03,1.19000e+03,
1.16737e+03,3.54813e-03,1.15566e+03,1.13377e+03,3.58922e-03,1.12233e+03,1.10114e+03,3.64124e-03,1.08207e+03,1.06172e+03,
3.67282e-03,1.05861e+03,1.03875e+03,3.71535e-03,1.02816e+03,1.00892e+03,3.80189e-03,9.69639e+02,9.51586e+02,3.84108e-03,
9.44348e+02,9.26797e+02,3.84592e-03,9.41287e+02,9.23797e+02,3.89045e-03,9.13788e+02,8.96844e+02,3.93550e-03,8.87111e+02,
8.70691e+02,3.98107e-03,8.61224e+02,8.45308e+02,3.98110e-03,8.61209e+02,8.45293e+02,4.00000e-03,8.50781e+02,8.35066e+02,
4.02717e-03,8.36104e+02,8.20672e+02,4.07380e-03,8.11625e+02,7.96660e+02,4.13750e-03,7.79596e+02,7.65233e+02,4.16869e-03,
7.64543e+02,7.50463e+02,4.26579e-03,7.20263e+02,7.07009e+02,4.31519e-03,6.99123e+02,6.86257e+02,4.41570e-03,6.58690e+02,
6.46558e+02,4.46684e-03,6.39291e+02,6.27506e+02,4.47057e-03,6.37905e+02,6.26145e+02,4.51856e-03,6.20470e+02,6.09022e+02,
4.67735e-03,5.66722e+02,5.56216e+02,4.73151e-03,5.49780e+02,5.39565e+02,4.81244e-03,5.25757e+02,5.15952e+02,4.84172e-03,
5.17422e+02,5.07759e+02,4.95450e-03,4.86992e+02,4.77844e+02,5.01187e-03,4.72469e+02,4.63564e+02,5.01190e-03,4.72462e+02,
4.63557e+02,5.06991e-03,4.58390e+02,4.49719e+02,5.12861e-03,4.44738e+02,4.36293e+02,5.23046e-03,4.22282e+02,4.14203e+02,
5.24807e-03,4.18557e+02,4.10539e+02,5.30884e-03,4.06068e+02,3.98255e+02,5.37032e-03,3.93878e+02,3.86263e+02,5.43250e-03,
3.82032e+02,3.74609e+02,5.50000e-03,3.69723e+02,3.62497e+02,5.55904e-03,3.59402e+02,3.52340e+02,5.62341e-03,3.48600e+02,
3.41710e+02,5.75440e-03,3.27987e+02,3.21422e+02,5.79285e-03,3.22263e+02,3.15787e+02,5.82103e-03,3.18156e+02,3.11744e+02,
5.88420e-03,3.09135e+02,3.02863e+02,5.95662e-03,2.99219e+02,2.93103e+02,6.00000e-03,2.93473e+02,2.87447e+02,6.02560e-03,
2.90155e+02,2.84180e+02,6.09537e-03,2.81331e+02,2.75493e+02,6.16595e-03,2.72774e+02,2.67069e+02,6.23735e-03,2.64487e+02,
2.58910e+02,6.30957e-03,2.56460e+02,2.51007e+02,6.30960e-03,2.56458e+02,2.51004e+02,6.38263e-03,2.48681e+02,2.43347e+02,
6.53131e-03,2.33835e+02,2.28727e+02,6.54660e-03,2.32381e+02,2.27296e+02,6.83912e-03,2.06820e+02,2.02130e+02,6.91831e-03,
2.00543e+02,1.95949e+02,6.99842e-03,1.94413e+02,1.89912e+02,7.07946e-03,1.88477e+02,1.84067e+02,7.16143e-03,1.82728e+02,
1.78406e+02,7.17175e-03,1.82022e+02,1.77711e+02,7.24436e-03,1.77156e+02,1.72920e+02,7.41310e-03,1.66487e+02,1.62418e+02,
7.50000e-03,1.61343e+02,1.57354e+02,7.58578e-03,1.56479e+02,1.52565e+02,7.85236e-03,1.42614e+02,1.38917e+02,7.88713e-03,
1.40917e+02,1.37246e+02,7.94328e-03,1.38234e+02,1.34606e+02,7.94330e-03,1.38233e+02,1.34605e+02,8.00000e-03,1.35594e+02,
1.32008e+02,8.12830e-03,1.29877e+02,1.26384e+02,8.31764e-03,1.22040e+02,1.18673e+02,8.41395e-03,1.18295e+02,1.14989e+02,
8.51138e-03,1.14670e+02,1.11423e+02,8.60994e-03,1.11160e+02,1.07970e+02,8.70964e-03,1.07761e+02,1.04627e+02,8.74850e-03,
1.06476e+02,1.03363e+02,8.81049e-03,1.04469e+02,1.01391e+02,9.01571e-03,9.81463e+01,9.51758e+01,9.12011e-03,9.51167e+01,
9.21981e+01,9.22571e-03,9.21812e+01,8.93131e+01,9.44061e-03,8.65864e+01,8.38157e+01,9.47374e-03,8.57667e+01,8.30103e+01,
9.50000e-03,8.51241e+01,8.23793e+01,9.66051e-03,8.13286e+01,7.86530e+01,9.77237e-03,7.88227e+01,7.61930e+01,1.00000e-02,
7.40481e+01,7.15071e+01,1.02176e-02,6.98571e+01,6.73950e+01,1.02329e-02,6.95735e+01,6.71170e+01,1.03514e-02,6.74412e+01,
6.50271e+01,1.05925e-02,6.33389e+01,6.10066e+01,1.08393e-02,5.94722e+01,5.72179e+01,1.10537e-02,5.63772e+01,5.41865e+01,
1.12202e-02,5.41239e+01,5.19822e+01,1.14815e-02,5.08261e+01,4.87571e+01,1.18850e-02,4.62660e+01,4.42998e+01,1.18914e-02,
4.61981e+01,4.42335e+01,1.20226e-02,4.48396e+01,4.29077e+01,1.21619e-02,4.34494e+01,4.15512e+01,1.24451e-02,4.07977e+01,
3.89645e+01,1.25890e-02,3.95320e+01,3.77302e+01,1.25892e-02,3.95298e+01,3.77281e+01,1.27350e-02,3.83017e+01,3.65308e+01,
1.28614e-02,3.72803e+01,3.55353e+01,1.28825e-02,3.71134e+01,3.53729e+01,1.33352e-02,3.37693e+01,3.21206e+01,1.34896e-02,
3.27226e+01,3.11032e+01,1.36458e-02,3.17096e+01,3.01188e+01,1.38038e-02,3.07219e+01,2.91591e+01,1.38113e-02,3.06764e+01,
2.91149e+01,1.39637e-02,2.97645e+01,2.82308e+01,1.41254e-02,2.88374e+01,2.73323e+01,1.42889e-02,2.79403e+01,2.64631e+01,
1.44544e-02,2.70711e+01,2.56212e+01,1.46218e-02,2.62300e+01,2.48067e+01,1.46692e-02,2.59974e+01,2.45816e+01,1.50000e-02,
2.44484e+01,2.30860e+01,1.53701e-02,2.28654e+01,2.15585e+01,1.54882e-02,2.23886e+01,2.11000e+01,1.56675e-02,2.16914e+01,
2.04297e+01,1.58489e-02,2.10110e+01,1.97757e+01,1.58490e-02,2.10108e+01,1.97755e+01,1.59119e-02,2.07814e+01,1.95550e+01,
1.62181e-02,1.97083e+01,1.85280e+01,1.63586e-02,1.92418e+01,1.80816e+01,1.65959e-02,1.84839e+01,1.73604e+01,1.66947e-02,
1.81806e+01,1.70718e+01,1.67880e-02,1.78983e+01,1.68051e+01,1.69748e-02,1.73515e+01,1.62885e+01,1.71831e-02,1.67624e+01,
1.57373e+01,1.72838e-02,1.64846e+01,1.54800e+01,1.73705e-02,1.62478e+01,1.52628e+01,1.73780e-02,1.62273e+01,1.52442e+01,
1.74411e-02,1.60560e+01,1.50887e+01,1.75370e-02,1.57965e+01,1.48565e+01,1.75792e-02,1.56819e+01,1.47557e+01,1.76679e-02,
1.54454e+01,1.45474e+01,1.77842e-02,1.51431e+01,1.42802e+01,1.78497e-02,1.49809e+01,1.41326e+01,1.79088e-02,1.48420e+01,
1.40013e+01,1.79530e-02,1.47428e+01,1.39039e+01,1.79620e-02,1.47235e+01,1.38844e+01,1.79620e-02,9.52027e+01,4.16815e+01,
1.79908e-02,9.48440e+01,4.16036e+01,1.80432e-02,9.42001e+01,4.14619e+01,1.81103e-02,9.33898e+01,4.12803e+01,1.81970e-02,
9.23628e+01,4.10455e+01,1.82800e-02,9.13951e+01,4.08203e+01,1.83087e-02,9.10187e+01,4.07218e+01,1.83812e-02,9.00723e+01,
4.04729e+01,1.84077e-02,8.97294e+01,4.03824e+01,1.84754e-02,8.88619e+01,4.01517e+01,1.85775e-02,8.75698e+01,3.98051e+01,
1.86209e-02,8.70269e+01,3.96583e+01,1.86587e-02,8.65576e+01,3.95307e+01,1.87000e-02,8.60482e+01,3.93917e+01,1.88365e-02,
8.45158e+01,3.89918e+01,1.90546e-02,8.21408e+01,3.83577e+01,1.90550e-02,8.21363e+01,3.83565e+01,1.93000e-02,7.95756e+01,
3.76517e+01,1.93145e-02,7.94195e+01,3.76063e+01,1.94985e-02,7.74665e+01,3.70323e+01,1.97131e-02,7.52717e+01,3.63719e+01,
1.97242e-02,7.51605e+01,3.63380e+01,1.99526e-02,7.29209e+01,3.56472e+01,1.99530e-02,7.29173e+01,3.56461e+01,2.00000e-02,
7.24679e+01,3.55054e+01,2.01784e-02,7.07976e+01,3.49764e+01,2.04174e-02,6.86400e+01,3.42792e+01,2.06538e-02,6.66404e+01,
3.36262e+01,2.08433e-02,6.50952e+01,3.31113e+01,2.11349e-02,6.28126e+01,3.23345e+01,2.13796e-02,6.09823e+01,3.16971e+01,
2.16804e-02,5.88313e+01,3.09306e+01,2.18776e-02,5.74765e+01,3.04386e+01,2.21309e-02,5.58001e+01,2.98195e+01,2.23872e-02,
5.41731e+01,2.92074e+01,2.26464e-02,5.25942e+01,2.86027e+01,2.29087e-02,5.10155e+01,2.79797e+01,2.29087e-02,5.10155e+01,
2.79797e+01,2.31740e-02,4.94836e+01,2.73655e+01,2.42661e-02,4.38066e+01,2.50202e+01,2.43241e-02,4.35310e+01,2.49025e+01,
2.48313e-02,4.12176e+01,2.39009e+01,2.50000e-02,4.04862e+01,2.35788e+01,2.51189e-02,3.99810e+01,2.33546e+01,2.51190e-02,
3.99804e+01,2.33544e+01,2.57040e-02,3.76172e+01,2.22887e+01,2.60016e-02,3.64889e+01,2.17697e+01,2.63956e-02,3.50665e+01,
2.11058e+01,2.69154e-02,3.33044e+01,2.02684e+01,2.72270e-02,3.22872e+01,1.97744e+01,2.81838e-02,2.94193e+01,1.83500e+01,
2.83312e-02,2.90092e+01,1.81424e+01,2.88403e-02,2.76514e+01,1.74482e+01,2.91743e-02,2.68078e+01,1.70112e+01,2.95121e-02,
2.59893e+01,1.65828e+01,3.01995e-02,2.44275e+01,1.57535e+01,3.05492e-02,2.36826e+01,1.53523e+01,3.09030e-02,2.29607e+01,
1.49599e+01,3.11188e-02,2.25351e+01,1.47269e+01,3.16228e-02,2.15827e+01,1.42012e+01,3.16230e-02,2.15823e+01,1.42009e+01,
3.19889e-02,2.09253e+01,1.38346e+01,3.31131e-02,1.90721e+01,1.27840e+01,3.34965e-02,1.84922e+01,1.24511e+01,3.42768e-02,
1.73664e+01,1.17949e+01,3.44601e-02,1.71154e+01,1.16472e+01,3.46737e-02,1.68291e+01,1.14782e+01,3.54813e-02,1.58040e+01,
1.08673e+01,3.63078e-02,1.48423e+01,1.02861e+01,3.71279e-02,1.39663e+01,9.74942e+00,3.75837e-02,1.35099e+01,9.46718e+00,
3.89045e-02,1.22983e+01,8.70834e+00,3.98107e-02,1.15462e+01,8.22927e+00,3.98110e-02,1.15459e+01,8.22913e+00,4.02717e-02,
1.11877e+01,7.99903e+00,4.05775e-02,1.09585e+01,7.85105e+00,4.07380e-02,1.08406e+01,7.77481e+00,4.16869e-02,1.01777e+01,
7.34326e+00,4.21696e-02,9.86193e+00,7.13598e+00,4.36516e-02,8.97304e+00,6.54639e+00,4.41570e-02,8.69532e+00,6.36028e+00,
4.46684e-02,8.42638e+00,6.17916e+00,4.50000e-02,8.25807e+00,6.06536e+00,4.67735e-02,7.42255e+00,5.49413e+00,4.74654e-02,
7.12836e+00,5.29086e+00,4.84172e-02,6.74931e+00,5.02736e+00,5.01187e-02,6.13793e+00,4.59809e+00,5.01190e-02,6.13783e+00,
4.59802e+00,5.12861e-02,5.76208e+00,4.33170e+00,5.24807e-02,5.40991e+00,4.08016e+00,5.30836e-02,5.24355e+00,3.96067e+00,
5.30884e-02,5.24224e+00,3.95973e+00,5.37032e-02,5.07976e+00,3.84284e+00,5.50000e-02,4.75934e+00,3.61106e+00,5.62341e-02,
4.47686e+00,3.40499e+00,5.82103e-02,4.07132e+00,3.10671e+00,5.92855e-02,3.87190e+00,2.95892e+00,6.02560e-02,3.70337e+00,
2.83354e+00,6.16595e-02,3.47741e+00,2.66457e+00,6.30957e-02,3.26583e+00,2.50543e+00,6.30960e-02,3.26580e+00,2.50540e+00,
6.38264e-02,3.16506e+00,2.42941e+00,6.45654e-02,3.06752e+00,2.35563e+00,6.60693e-02,2.88179e+00,2.21460e+00,6.76083e-02,
2.70788e+00,2.08186e+00,6.99842e-02,2.46514e+00,1.89526e+00,7.07946e-02,2.38944e+00,1.83680e+00,7.16143e-02,2.31614e+00,
1.78005e+00,7.32825e-02,2.17663e+00,1.67169e+00,7.41310e-02,2.11027e+00,1.61998e+00,7.76247e-02,1.86574e+00,1.42851e+00,
7.94328e-02,1.75509e+00,1.34136e+00,7.94330e-02,1.75507e+00,1.34135e+00,8.12830e-02,1.65133e+00,1.25955e+00,8.45779e-02,
1.48763e+00,1.12990e+00,8.51138e-02,1.46327e+00,1.11056e+00,8.60994e-02,1.41962e+00,1.07582e+00,8.70964e-02,1.37739e+00,
1.04218e+00,8.91251e-02,1.29697e+00,9.77960e-01,9.12011e-02,1.22171e+00,9.17713e-01,9.66051e-02,1.05406e+00,7.82943e-01,
9.77237e-02,1.02373e+00,7.58485e-01,9.88553e-02,9.94392e-01,7.34800e-01,1.00000e-01,9.66014e-01,7.11868e-01,1.03514e-01,
8.86060e-01,6.47432e-01,1.04713e-01,8.61119e-01,6.27303e-01,1.07152e-01,8.13639e-01,5.88959e-01,1.07887e-01,8.00134e-01,
5.78044e-01,1.08393e-01,7.91034e-01,5.70696e-01,1.10918e-01,7.47968e-01,5.35897e-01,1.13501e-01,7.07621e-01,5.03262e-01,
1.14815e-01,6.88419e-01,4.87722e-01,1.18850e-01,6.34299e-01,4.43879e-01,1.21619e-01,6.01073e-01,4.16947e-01,1.24452e-01,
5.69957e-01,3.91719e-01,1.25890e-01,5.55174e-01,3.79734e-01,1.25893e-01,5.55149e-01,3.79713e-01,1.27350e-01,5.40748e-01,
3.68126e-01,1.28825e-01,5.26809e-01,3.56912e-01,1.29577e-01,5.19935e-01,3.51383e-01,1.33352e-01,4.87567e-01,3.25397e-01,
1.34896e-01,4.75310e-01,3.15563e-01,1.38038e-01,4.51961e-01,2.96841e-01,1.41254e-01,4.30074e-01,2.79311e-01,1.44544e-01,
4.09557e-01,2.62899e-01,1.46218e-01,3.99785e-01,2.55090e-01,1.47911e-01,3.90322e-01,2.47534e-01,1.50000e-01,3.79197e-01,
2.38659e-01,1.53109e-01,3.63691e-01,2.26306e-01,1.56675e-01,3.47308e-01,2.13279e-01,1.58199e-01,3.40730e-01,2.08056e-01,
1.58489e-01,3.39499e-01,2.07081e-01,1.58490e-01,3.39496e-01,2.07079e-01,1.60324e-01,3.31865e-01,2.01115e-01,1.62181e-01,
3.24468e-01,1.95344e-01,1.64059e-01,3.17302e-01,1.89760e-01,1.65959e-01,3.10359e-01,1.84359e-01,1.67880e-01,3.03632e-01,
1.79134e-01,1.69824e-01,2.97113e-01,1.74079e-01,1.73780e-01,2.84673e-01,1.64458e-01,1.75792e-01,2.78739e-01,1.59882e-01,
1.84077e-01,2.56770e-01,1.43021e-01,1.86209e-01,2.51692e-01,1.39144e-01,1.88365e-01,2.46804e-01,1.35428e-01,1.94984e-01,
2.33008e-01,1.24987e-01,1.99392e-01,2.24728e-01,1.18759e-01,1.99526e-01,2.24485e-01,1.18577e-01,1.99530e-01,2.24478e-01,
1.18572e-01,2.00000e-01,2.23624e-01,1.17947e-01,2.04174e-01,2.16350e-01,1.12634e-01,2.06538e-01,2.12463e-01,1.09808e-01,
2.08930e-01,2.08689e-01,1.07074e-01,2.13796e-01,2.01470e-01,1.01868e-01,2.16272e-01,1.98017e-01,9.93908e-02,2.18776e-01,
1.94664e-01,9.69936e-02,2.21309e-01,1.91408e-01,9.46740e-02,2.23872e-01,1.88245e-01,9.24292e-02,2.26464e-01,1.85173e-01,
9.02569e-02,2.29087e-01,1.82189e-01,8.81546e-02,2.29910e-01,1.81286e-01,8.75224e-02,2.31740e-01,1.79319e-01,8.61480e-02,
2.37137e-01,1.73817e-01,8.23241e-02,2.42661e-01,1.68617e-01,7.87393e-02,2.45471e-01,1.66125e-01,7.70319e-02,2.48313e-01,
1.63701e-01,7.53786e-02,2.51189e-01,1.61346e-01,7.37803e-02,2.51190e-01,1.61345e-01,7.37796e-02,2.54097e-01,1.59016e-01,
7.22616e-02,2.57040e-01,1.56748e-01,7.07912e-02,2.60016e-01,1.54540e-01,6.93672e-02,2.63939e-01,1.51757e-01,6.75821e-02,
2.69154e-01,1.48258e-01,6.53596e-02,2.72270e-01,1.46291e-01,6.41253e-02,2.78612e-01,1.42507e-01,6.17705e-02,2.85102e-01,
1.38914e-01,5.95590e-02,2.88403e-01,1.37185e-01,5.85041e-02,2.91743e-01,1.35500e-01,5.74817e-02,2.98538e-01,1.32258e-01,
5.55338e-02,3.00000e-01,1.31591e-01,5.51359e-02,3.00006e-01,1.31588e-01,5.51343e-02,3.01995e-01,1.30697e-01,5.46042e-02,
3.05492e-01,1.29174e-01,5.37030e-02,3.09029e-01,1.27688e-01,5.28292e-02,3.12608e-01,1.26239e-01,5.19820e-02,3.16228e-01,
1.24839e-01,5.11747e-02,3.16230e-01,1.24838e-01,5.11743e-02,3.19889e-01,1.23438e-01,5.04180e-02,3.23594e-01,1.22070e-01,
4.96838e-02,3.34965e-01,1.18149e-01,4.76086e-02,3.38844e-01,1.16902e-01,4.69584e-02,3.42768e-01,1.15683e-01,4.63274e-02,
3.46737e-01,1.14491e-01,4.57147e-02,3.50752e-01,1.13326e-01,4.51198e-02,3.54813e-01,1.12185e-01,4.45421e-02,3.58922e-01,
1.11081e-01,4.39919e-02,3.63078e-01,1.10000e-01,4.34571e-02,3.67282e-01,1.08941e-01,4.29373e-02,3.68606e-01,1.08615e-01,
4.27778e-02,3.71535e-01,1.07904e-01,4.24319e-02,3.75837e-01,1.06888e-01,4.19404e-02,3.80189e-01,1.05892e-01,4.14626e-02,
3.84592e-01,1.04918e-01,4.09986e-02,3.93550e-01,1.03028e-01,4.01085e-02,3.98107e-01,1.02112e-01,3.96814e-02,3.98110e-01,
1.02111e-01,3.96811e-02,4.00000e-01,1.01728e-01,3.95187e-02,4.02717e-01,1.01191e-01,3.92948e-02,4.07380e-01,1.00291e-01,
3.89219e-02,4.12098e-01,9.94074e-02,3.85586e-02,4.16869e-01,9.85406e-02,3.82044e-02,4.21697e-01,9.76897e-02,3.78593e-02,
4.26580e-01,9.68543e-02,3.75227e-02,4.31519e-01,9.60347e-02,3.71953e-02,4.36516e-01,9.52299e-02,3.68760e-02,4.41570e-01,
9.44393e-02,3.65644e-02,4.46684e-01,9.36627e-02,3.62605e-02,4.51856e-01,9.29062e-02,3.59703e-02,4.57088e-01,9.21625e-02,
3.56867e-02,4.62381e-01,9.14312e-02,3.54097e-02,4.67735e-01,9.07121e-02,3.51389e-02,4.78630e-01,8.93090e-02,3.46152e-02,
4.84172e-01,8.86251e-02,3.43625e-02,4.89779e-01,8.79522e-02,3.41154e-02,4.95450e-01,8.72900e-02,3.38736e-02,5.01187e-01,
8.66436e-02,3.36421e-02,5.01190e-01,8.66432e-02,3.36420e-02,5.06991e-01,8.59833e-02,3.34363e-02,5.12861e-01,8.53328e-02,
3.32343e-02,5.24808e-01,8.40605e-02,3.28417e-02,5.30884e-01,8.34381e-02,3.26507e-02,5.37032e-01,8.28252e-02,3.24636e-02,
5.37225e-01,8.28062e-02,3.24578e-02,5.43250e-01,8.22205e-02,3.22799e-02,5.49541e-01,8.16243e-02,3.20993e-02,5.55904e-01,
8.10408e-02,3.19261e-02,5.62341e-01,8.04652e-02,3.17556e-02,5.75440e-01,7.93369e-02,3.14225e-02,5.82103e-01,7.87840e-02,
3.12597e-02,5.88844e-01,7.82382e-02,3.10993e-02,5.95662e-01,7.77000e-02,3.09415e-02,6.02560e-01,7.71686e-02,3.07861e-02,
6.09537e-01,7.66440e-02,3.06328e-02,6.16595e-01,7.61295e-02,3.04849e-02,6.30957e-01,7.51191e-02,3.01947e-02,6.30960e-01,
7.51189e-02,3.01947e-02,6.45654e-01,7.40898e-02,2.99436e-02,6.53131e-01,7.35841e-02,2.98197e-02,6.60694e-01,7.30846e-02,
2.96973e-02,6.68344e-01,7.25910e-02,2.95759e-02,6.76083e-01,7.21056e-02,2.94581e-02,6.91831e-01,7.11510e-02,2.92251e-02,
6.99842e-01,7.06815e-02,2.91097e-02,7.07946e-01,7.02170e-02,2.89951e-02,7.16143e-01,6.97575e-02,2.88811e-02,7.24436e-01,
6.93031e-02,2.87681e-02,7.32825e-01,6.88561e-02,2.86582e-02,7.41310e-01,6.84136e-02,2.85489e-02,7.49894e-01,6.79757e-02,
2.84400e-02,7.58578e-01,6.75421e-02,2.83316e-02,7.67362e-01,6.71129e-02,2.82237e-02,7.76247e-01,6.66879e-02,2.81162e-02,
7.85236e-01,6.62672e-02,2.80091e-02,7.94328e-01,6.58505e-02,2.79024e-02,7.94330e-01,6.58504e-02,2.79024e-02,8.03526e-01,
6.54205e-02,2.78116e-02,8.12831e-01,6.49965e-02,2.77225e-02,8.31764e-01,6.41604e-02,2.75438e-02,8.41395e-01,6.37483e-02,
2.74542e-02,8.51138e-01,6.33399e-02,2.73644e-02,8.60994e-01,6.29352e-02,2.72745e-02,8.70964e-01,6.25343e-02,2.71844e-02,
8.81049e-01,6.21368e-02,2.70941e-02,8.91251e-01,6.17429e-02,2.70036e-02,9.01571e-01,6.13526e-02,2.69132e-02,9.12011e-01,
6.09659e-02,2.68226e-02,9.22571e-01,6.05839e-02,2.67332e-02,9.44061e-01,5.98297e-02,2.65537e-02,9.54993e-01,5.94575e-02,
2.64636e-02,9.66051e-01,5.90884e-02,2.63734e-02,9.77237e-01,5.87226e-02,2.62831e-02,9.88553e-01,5.83599e-02,2.61927e-02,
1.00000e+00,5.80016e-02,2.61035e-02,1.00000e-03,4.59665e+03,4.59124e+03,1.02329e-03,4.36292e+03,4.35755e+03,1.03514e-03,
4.24982e+03,4.24447e+03,1.04713e-03,4.13935e+03,4.13402e+03,1.07152e-03,3.92743e+03,3.92214e+03,1.09648e-03,3.72585e+03,
3.72059e+03,1.10918e-03,3.62841e+03,3.62317e+03,1.11000e-03,3.62220e+03,3.61696e+03,1.12202e-03,3.53292e+03,3.52770e+03,
1.13501e-03,3.43964e+03,3.43444e+03,1.13634e-03,3.43031e+03,3.42511e+03,1.16145e-03,3.26050e+03,3.25534e+03,1.17490e-03,
3.17461e+03,3.16947e+03,1.21619e-03,2.92978e+03,2.92470e+03,1.23027e-03,2.85207e+03,2.84701e+03,1.24451e-03,2.77573e+03,
2.77069e+03,1.25890e-03,2.70176e+03,2.69673e+03,1.25892e-03,2.70163e+03,2.69660e+03,1.26081e-03,2.69212e+03,2.68710e+03,
1.28825e-03,2.55929e+03,2.55431e+03,1.30317e-03,2.49118e+03,2.48622e+03,1.31826e-03,2.42495e+03,2.42002e+03,1.32317e-03,
2.40385e+03,2.39892e+03,1.33352e-03,2.36025e+03,2.35534e+03,1.35540e-03,2.27170e+03,2.26682e+03,1.36458e-03,2.23528e+03,
2.23042e+03,1.39637e-03,2.11566e+03,2.11086e+03,1.42889e-03,2.00271e+03,1.99796e+03,1.46218e-03,1.89612e+03,1.89142e+03,
1.46279e-03,1.89424e+03,1.88954e+03,1.47911e-03,1.84486e+03,1.84019e+03,1.50000e-03,1.78416e+03,1.77953e+03,1.51356e-03,
1.74609e+03,1.74147e+03,1.53993e-03,1.67484e+03,1.67027e+03,1.56675e-03,1.60650e+03,1.60197e+03,1.58489e-03,1.56259e+03,
1.55810e+03,1.58490e-03,1.56257e+03,1.55808e+03,1.61445e-03,1.49477e+03,1.49032e+03,1.62181e-03,1.47854e+03,1.47410e+03,
1.64059e-03,1.43815e+03,1.43375e+03,1.65000e-03,1.41851e+03,1.41413e+03,1.65959e-03,1.39881e+03,1.39445e+03,1.67880e-03,
1.36021e+03,1.35588e+03,1.70191e-03,1.31564e+03,1.31135e+03,1.73780e-03,1.25041e+03,1.24619e+03,1.75792e-03,1.21583e+03,
1.21165e+03,1.77828e-03,1.18223e+03,1.17809e+03,1.78212e-03,1.17605e+03,1.17191e+03,1.81970e-03,1.11792e+03,1.11387e+03,
1.84077e-03,1.08693e+03,1.08292e+03,1.85881e-03,1.06138e+03,1.05740e+03,1.86209e-03,1.05683e+03,1.05286e+03,1.92100e-03,
9.78737e+02,9.74896e+02,1.92753e-03,9.70586e+02,9.66761e+02,1.94984e-03,9.43508e+02,9.39736e+02,1.97242e-03,9.17216e+02,
9.13496e+02,1.98105e-03,9.07453e+02,9.03753e+02,1.99526e-03,8.91683e+02,8.88021e+02,1.99530e-03,8.91641e+02,8.87979e+02,
2.01837e-03,8.66858e+02,8.63256e+02,2.03550e-03,8.49028e+02,8.45470e+02,2.04174e-03,8.42666e+02,8.39127e+02,2.06538e-03,
8.19042e+02,8.15572e+02,2.08156e-03,8.03296e+02,7.99872e+02,2.08930e-03,7.95912e+02,7.92513e+02,2.12175e-03,7.65878e+02,
7.62583e+02,2.13796e-03,7.51460e+02,7.48224e+02,2.15664e-03,7.35353e+02,7.32182e+02,2.16272e-03,7.30207e+02,7.27061e+02,
2.18776e-03,7.09573e+02,7.06527e+02,2.18867e-03,7.08841e+02,7.05799e+02,2.21310e-03,6.89535e+02,6.86603e+02,2.21695e-03,
6.86559e+02,6.83644e+02,2.23872e-03,6.70052e+02,6.67250e+02,2.24025e-03,6.68908e+02,6.66113e+02,2.25315e-03,6.59379e+02,
6.56659e+02,2.26464e-03,6.51036e+02,6.48392e+02,2.27138e-03,6.46216e+02,6.43615e+02,2.28670e-03,6.35409e+02,6.32926e+02,
2.29958e-03,6.26495e+02,6.24125e+02,2.30656e-03,6.21738e+02,6.19436e+02,2.31740e-03,6.14437e+02,6.12243e+02,2.33238e-03,
6.04472e+02,6.02420e+02,2.34077e-03,5.99011e+02,5.97020e+02,2.34673e-03,5.95183e+02,5.93223e+02,2.35200e-03,5.91839e+02,
5.89895e+02,2.35769e-03,5.88268e+02,5.86329e+02,2.36338e-03,5.84740e+02,5.82793e+02,2.36910e-03,5.81236e+02,5.79268e+02,
2.36910e-03,2.13588e+03,2.08667e+03,2.36918e-03,2.13571e+03,2.08650e+03,2.37137e-03,2.13088e+03,2.08181e+03,2.37491e-03,
2.12314e+03,2.07429e+03,2.38345e-03,2.10461e+03,2.05627e+03,2.38600e-03,2.09912e+03,2.05093e+03,2.40000e-03,2.06936e+03,
2.02197e+03,2.41004e-03,2.04840e+03,2.00155e+03,2.42661e-03,2.01441e+03,1.96846e+03,2.45522e-03,1.95764e+03,1.91317e+03,
2.46660e-03,1.93570e+03,1.89177e+03,2.46660e-03,2.68016e+03,2.61131e+03,2.48313e-03,2.63648e+03,2.56897e+03,2.48639e-03,
2.62799e+03,2.56074e+03,2.50000e-03,2.59294e+03,2.52676e+03,2.50252e-03,2.58653e+03,2.52054e+03,2.51189e-03,2.56284e+03,
2.49758e+03,2.51190e-03,2.56281e+03,2.49754e+03,2.51312e-03,2.55974e+03,2.49457e+03,2.52159e-03,2.53862e+03,2.47409e+03,
2.53235e-03,2.51215e+03,2.44844e+03,2.54097e-03,2.49119e+03,2.42813e+03,2.54340e-03,2.48534e+03,2.42246e+03,2.55721e-03,
2.45238e+03,2.39054e+03,2.57040e-03,2.42147e+03,2.36060e+03,2.57335e-03,2.41479e+03,2.35413e+03,2.59055e-03,2.37645e+03,
2.31702e+03,2.60016e-03,2.35539e+03,2.29663e+03,2.60728e-03,2.33951e+03,2.28126e+03,2.63027e-03,2.28927e+03,2.23262e+03,
2.64000e-03,2.26846e+03,2.21247e+03,2.64430e-03,2.25917e+03,2.20347e+03,2.65473e-03,2.23681e+03,2.18181e+03,2.66073e-03,
2.22412e+03,2.16950e+03,2.66494e-03,2.21526e+03,2.16091e+03,2.67630e-03,2.19163e+03,2.13798e+03,2.67630e-03,2.51069e+03,
2.44838e+03,2.68143e-03,2.49920e+03,2.43724e+03,2.69154e-03,2.47677e+03,2.41549e+03,2.69500e-03,2.46915e+03,2.40810e+03,
2.71417e-03,2.42758e+03,2.36777e+03,2.72842e-03,2.39733e+03,2.33843e+03,2.74161e-03,2.36980e+03,2.31173e+03,2.75423e-03,
2.34386e+03,2.28656e+03,2.75724e-03,2.33757e+03,2.28046e+03,2.77618e-03,2.29858e+03,2.24265e+03,2.78612e-03,2.27847e+03,
2.22314e+03,2.79499e-03,2.26075e+03,2.20596e+03,2.80000e-03,2.25082e+03,2.19632e+03,2.81838e-03,2.21491e+03,2.16149e+03,
2.82358e-03,2.20480e+03,2.15168e+03,2.84859e-03,2.15698e+03,2.10528e+03,2.86348e-03,2.12920e+03,2.07833e+03,2.88403e-03,
2.09171e+03,2.04195e+03,2.90000e-03,2.06316e+03,2.01424e+03,2.91054e-03,2.04458e+03,1.99620e+03,2.91743e-03,2.03258e+03,
1.98456e+03,2.95121e-03,1.97513e+03,1.92877e+03,2.98134e-03,1.92583e+03,1.88089e+03,2.98538e-03,1.91935e+03,1.87460e+03,
3.01995e-03,1.86518e+03,1.82198e+03,3.05492e-03,1.81220e+03,1.77050e+03,3.06703e-03,1.79422e+03,1.75302e+03,3.09030e-03,
1.76038e+03,1.72013e+03,3.12608e-03,1.70997e+03,1.67112e+03,3.15000e-03,1.67742e+03,1.63946e+03,3.16228e-03,1.66106e+03,
1.62355e+03,3.16230e-03,1.66103e+03,1.62352e+03,3.18038e-03,1.63736e+03,1.60049e+03,3.27341e-03,1.52266e+03,1.48888e+03,
3.29154e-03,1.50146e+03,1.46823e+03,3.31131e-03,1.47880e+03,1.44618e+03,3.34965e-03,1.43624e+03,1.40472e+03,3.42768e-03,
1.35484e+03,1.32542e+03,3.45489e-03,1.32800e+03,1.29926e+03,3.46737e-03,1.31593e+03,1.28751e+03,3.50752e-03,1.27816e+03,
1.25068e+03,3.54813e-03,1.24146e+03,1.21490e+03,3.64329e-03,1.16118e+03,1.13659e+03,3.67282e-03,1.13774e+03,1.11371e+03,
3.71535e-03,1.10518e+03,1.08194e+03,3.75837e-03,1.07321e+03,1.05073e+03,3.80189e-03,1.04204e+03,1.02029e+03,3.83685e-03,
1.01793e+03,9.96740e+02,3.89045e-03,9.82436e+02,9.62066e+02,3.93550e-03,9.53961e+02,9.34243e+02,3.98107e-03,9.26327e+02,
9.07236e+02,3.98110e-03,9.26310e+02,9.07220e+02,4.00000e-03,9.15172e+02,8.96332e+02,4.07380e-03,8.73457e+02,8.55548e+02,
4.15074e-03,8.32458e+02,8.15447e+02,4.16869e-03,8.23273e+02,8.06462e+02,4.21696e-03,7.99303e+02,7.83013e+02,4.36516e-03,
7.31116e+02,7.16282e+02,4.41570e-03,7.09588e+02,6.95204e+02,4.46684e-03,6.88707e+02,6.74754e+02,4.47482e-03,6.85526e+02,
6.71639e+02,4.51856e-03,6.68443e+02,6.54910e+02,4.73151e-03,5.93275e+02,5.81266e+02,4.78630e-03,5.75597e+02,5.63937e+02,
4.89779e-03,5.41812e+02,5.30809e+02,4.91520e-03,5.36792e+02,5.25886e+02,4.95450e-03,5.25692e+02,5.15001e+02,5.01187e-03,
5.10062e+02,4.99673e+02,5.01190e-03,5.10054e+02,4.99665e+02,5.12861e-03,4.80020e+02,4.70202e+02,5.18800e-03,4.65679e+02,
4.56131e+02,5.30884e-03,4.38293e+02,4.29254e+02,5.31948e-03,4.35994e+02,4.26997e+02,5.37032e-03,4.25225e+02,4.16429e+02,
5.49541e-03,4.00141e+02,3.91806e+02,5.55904e-03,3.88179e+02,3.80062e+02,5.62341e-03,3.76584e+02,3.68677e+02,5.68853e-03,
3.65274e+02,3.57569e+02,5.82103e-03,3.43693e+02,3.36373e+02,5.88536e-03,3.33833e+02,3.26686e+02,6.02560e-03,3.13648e+02,
3.06858e+02,6.09537e-03,3.04235e+02,2.97611e+02,6.23735e-03,2.86091e+02,2.79783e+02,6.30957e-03,2.77407e+02,2.71248e+02,
6.30960e-03,2.77404e+02,2.71245e+02,6.51827e-03,2.54304e+02,2.48541e+02,6.53131e-03,2.52950e+02,2.47210e+02,6.60693e-03,
2.45264e+02,2.39657e+02,6.68344e-03,2.37814e+02,2.32335e+02,6.80000e-03,2.27063e+02,2.21768e+02,6.83912e-03,2.23605e+02,
2.18369e+02,6.91831e-03,2.16828e+02,2.11707e+02,7.07946e-03,2.03903e+02,1.99002e+02,7.16143e-03,1.97743e+02,1.92946e+02,
7.24436e-03,1.91770e+02,1.87074e+02,7.30000e-03,1.87877e+02,1.83247e+02,7.39712e-03,1.81299e+02,1.76779e+02,7.49894e-03,
1.74736e+02,1.70327e+02,7.58578e-03,1.69401e+02,1.65084e+02,7.67362e-03,1.64233e+02,1.60004e+02,7.76247e-03,1.59223e+02,
1.55079e+02,7.85236e-03,1.54370e+02,1.50309e+02,7.94328e-03,1.49650e+02,1.45669e+02,7.94330e-03,1.49649e+02,1.45668e+02,
8.03526e-03,1.45079e+02,1.41176e+02,8.17270e-03,1.38609e+02,1.34817e+02,8.22243e-03,1.36365e+02,1.32612e+02,8.41395e-03,
1.28152e+02,1.24543e+02,8.51138e-03,1.24213e+02,1.20674e+02,8.70964e-03,1.16709e+02,1.13301e+02,8.91251e-03,1.09663e+02,
1.06380e+02,9.01571e-03,1.06307e+02,1.03084e+02,9.09275e-03,1.03896e+02,1.00716e+02,9.12011e-03,1.03058e+02,9.98925e+01,
9.22571e-03,9.99092e+01,9.68022e+01,9.33254e-03,9.68512e+01,9.38009e+01,9.44061e-03,9.38700e+01,9.08750e+01,9.66051e-03,
8.81894e+01,8.53004e+01,9.77237e-03,8.54689e+01,8.26310e+01,9.88164e-03,8.29240e+01,8.01340e+01,9.88553e-03,8.28353e+01,
8.00470e+01,1.00000e-02,8.02794e+01,7.75412e+01,1.02329e-02,7.54082e+01,7.27661e+01,1.03514e-02,7.30889e+01,7.04930e+01,
1.04713e-02,7.08435e+01,6.82927e+01,1.06812e-02,6.71293e+01,6.46536e+01,1.07152e-02,6.65536e+01,6.40901e+01,1.08393e-02,
6.45092e+01,6.20892e+01,1.09648e-02,6.25168e+01,6.01391e+01,1.12202e-02,5.87214e+01,5.64255e+01,1.13501e-02,5.69043e+01,
5.46478e+01,1.14815e-02,5.51440e+01,5.29261e+01,1.15938e-02,5.37002e+01,5.15140e+01,1.16145e-02,5.34393e+01,5.12592e+01,
1.17490e-02,5.17863e+01,4.96446e+01,1.18850e-02,5.01865e+01,4.80823e+01,1.21619e-02,4.71390e+01,4.51072e+01,1.23027e-02,
4.56838e+01,4.36869e+01,1.24451e-02,4.42666e+01,4.23039e+01,1.25326e-02,4.34268e+01,4.14846e+01,1.25890e-02,4.28968e+01,
4.09681e+01,1.25892e-02,4.28944e+01,4.09658e+01,1.28825e-02,4.02785e+01,3.84178e+01,1.30317e-02,3.90332e+01,3.72053e+01,
1.31826e-02,3.78268e+01,3.60310e+01,1.34896e-02,3.55171e+01,3.37833e+01,1.35154e-02,3.53326e+01,3.36038e+01,1.36458e-02,
3.44169e+01,3.27140e+01,1.36804e-02,3.41798e+01,3.24837e+01,1.40115e-02,3.20199e+01,3.03860e+01,1.41254e-02,3.13198e+01,
2.97069e+01,1.44544e-02,2.94022e+01,2.78473e+01,1.45593e-02,2.88240e+01,2.72868e+01,1.47911e-02,2.75997e+01,2.61022e+01,
1.50000e-02,2.65576e+01,2.50942e+01,1.51356e-02,2.59100e+01,2.44681e+01,1.54625e-02,2.44370e+01,2.30444e+01,1.54882e-02,
2.43260e+01,2.29374e+01,1.56675e-02,2.35674e+01,2.22062e+01,1.58489e-02,2.28336e+01,2.14992e+01,1.58490e-02,2.28333e+01,
2.14989e+01,1.60324e-02,2.21229e+01,2.08147e+01,1.61836e-02,2.15607e+01,2.02734e+01,1.64059e-02,2.07663e+01,1.95110e+01,
1.67570e-02,1.95847e+01,1.83774e+01,1.67880e-02,1.94843e+01,1.82815e+01,1.69824e-02,1.88721e+01,1.76967e+01,1.72361e-02,
1.81130e+01,1.69719e+01,1.73000e-02,1.79273e+01,1.67956e+01,1.73780e-02,1.77039e+01,1.65834e+01,1.75792e-02,1.71447e+01,
1.60525e+01,1.76133e-02,1.70525e+01,1.59650e+01,1.77828e-02,1.66003e+01,1.55388e+01,1.78962e-02,1.63072e+01,1.52626e+01,
1.80259e-02,1.59781e+01,1.49546e+01,1.81447e-02,1.56828e+01,1.46800e+01,1.81970e-02,1.55540e+01,1.45613e+01,1.82409e-02,
1.54469e+01,1.44624e+01,1.83289e-02,1.52328e+01,1.42668e+01,1.84049e-02,1.50490e+01,1.41007e+01,1.84077e-02,1.50422e+01,
1.40946e+01,1.85032e-02,1.48126e+01,1.38902e+01,1.86543e-02,1.44523e+01,1.35745e+01,1.87604e-02,1.42074e+01,1.33587e+01,
1.88296e-02,1.40552e+01,1.32206e+01,1.88365e-02,1.40405e+01,1.32068e+01,1.88864e-02,1.39359e+01,1.31084e+01,1.89480e-02,
1.38138e+01,1.29884e+01,1.89480e-02,8.86253e+01,3.76492e+01,1.89486e-02,8.86181e+01,3.76477e+01,1.89838e-02,8.81996e+01,
3.75573e+01,1.90290e-02,8.76690e+01,3.74413e+01,1.90546e-02,8.73723e+01,3.73756e+01,1.90917e-02,8.69443e+01,3.72802e+01,
1.92217e-02,8.54756e+01,3.69460e+01,1.92752e-02,8.48813e+01,3.68086e+01,1.93438e-02,8.41289e+01,3.66327e+01,1.94288e-02,
8.32064e+01,3.64150e+01,1.94300e-02,8.31940e+01,3.64121e+01,1.94985e-02,8.24037e+01,3.62125e+01,1.95273e-02,8.20733e+01,
3.61285e+01,1.96355e-02,8.08482e+01,3.58148e+01,1.97242e-02,7.98602e+01,3.55588e+01,1.97258e-02,7.98445e+01,3.55550e+01,
1.99045e-02,7.81073e+01,3.51368e+01,1.99526e-02,7.76473e+01,3.50243e+01,1.99530e-02,7.76436e+01,3.50235e+01,2.01575e-02,
7.57325e+01,3.45474e+01,2.01837e-02,7.54920e+01,3.44866e+01,2.02000e-02,7.53426e+01,3.44487e+01,2.04174e-02,7.32711e+01,
3.38889e+01,2.04425e-02,7.30372e+01,3.38246e+01,2.06538e-02,7.11044e+01,3.32871e+01,2.08930e-02,6.90018e+01,3.26863e+01,
2.09478e-02,6.85322e+01,3.25498e+01,2.11349e-02,6.69602e+01,3.20874e+01,2.15340e-02,6.37715e+01,3.11198e+01,2.16272e-02,
6.30569e+01,3.08977e+01,2.18776e-02,6.11902e+01,3.03075e+01,2.21309e-02,5.94042e+01,2.97339e+01,2.21838e-02,5.90402e+01,
2.96153e+01,2.26464e-02,5.59815e+01,2.85967e+01,2.32543e-02,5.22903e+01,2.73127e+01,2.34423e-02,5.12170e+01,2.69280e+01,
2.37137e-02,4.97209e+01,2.63830e+01,2.39883e-02,4.82691e+01,2.58440e+01,2.40000e-02,4.82087e+01,2.58214e+01,2.42661e-02,
4.68217e+01,2.52901e+01,2.45471e-02,4.54165e+01,2.47427e+01,2.45575e-02,4.53654e+01,2.47226e+01,2.51189e-02,4.27310e+01,
2.36706e+01,2.51190e-02,4.27304e+01,2.36703e+01,2.57040e-02,4.02054e+01,2.26295e+01,2.58958e-02,3.94223e+01,2.23027e+01,
2.60016e-02,3.89992e+01,2.21249e+01,2.66073e-02,3.66914e+01,2.11373e+01,2.72270e-02,3.45217e+01,2.01818e+01,2.75423e-02,
3.34861e+01,1.97162e+01,2.80327e-02,3.19592e+01,1.90181e+01,2.85102e-02,3.05633e+01,1.83679e+01,2.88403e-02,2.96473e+01,
1.79346e+01,2.95121e-02,2.78612e+01,1.70692e+01,3.00000e-02,2.66561e+01,1.64737e+01,3.05492e-02,2.53841e+01,1.58347e+01,
3.08585e-02,2.47035e+01,1.54882e+01,3.09030e-02,2.46078e+01,1.54392e+01,3.12608e-02,2.38549e+01,1.50519e+01,3.16228e-02,
2.31254e+01,1.46728e+01,3.16230e-02,2.31250e+01,1.46726e+01,3.23594e-02,2.17333e+01,1.39387e+01,3.34965e-02,1.98028e+01,
1.28966e+01,3.38768e-02,1.92103e+01,1.25710e+01,3.38844e-02,1.91987e+01,1.25646e+01,3.42768e-02,1.86130e+01,1.22400e+01,
3.46737e-02,1.80454e+01,1.19228e+01,3.54813e-02,1.69625e+01,1.13101e+01,3.58922e-02,1.64454e+01,1.10139e+01,3.67282e-02,
1.54587e+01,1.04420e+01,3.71535e-02,1.49789e+01,1.01605e+01,3.73445e-02,1.47701e+01,1.00374e+01,3.75837e-02,1.45140e+01,
9.88593e+00,3.84592e-02,1.36272e+01,9.35655e+00,3.89045e-02,1.32047e+01,9.10163e+00,3.98107e-02,1.23992e+01,8.61065e+00,
3.98110e-02,1.23990e+01,8.61051e+00,4.02717e-02,1.20153e+01,8.37438e+00,4.06493e-02,1.17131e+01,8.18724e+00,4.16869e-02,
1.09342e+01,7.70083e+00,4.21696e-02,1.05959e+01,7.48737e+00,4.26579e-02,1.02682e+01,7.27940e+00,4.51856e-02,8.77822e+00,
6.31754e+00,4.62381e-02,8.24596e+00,5.96718e+00,4.73151e-02,7.73892e+00,5.62916e+00,4.78286e-02,7.51232e+00,5.47699e+00,
4.78630e-02,7.49745e+00,5.46698e+00,4.95450e-02,6.81812e+00,5.00657e+00,5.01187e-02,6.60578e+00,4.86128e+00,5.01190e-02,
6.60568e+00,4.86121e+00,5.06991e-02,6.40012e+00,4.72002e+00,5.24807e-02,5.82171e+00,4.31927e+00,5.28750e-02,5.70365e+00,
4.23683e+00,5.30884e-02,5.64105e+00,4.19307e+00,5.43250e-02,5.29670e+00,3.95118e+00,5.55904e-02,4.97401e+00,3.72270e+00,
5.68853e-02,4.67163e+00,3.50696e+00,5.75440e-02,4.52764e+00,3.40365e+00,5.88844e-02,4.24990e+00,3.20300e+00,5.94543e-02,
4.13890e+00,3.12250e+00,5.95662e-02,4.11758e+00,3.10702e+00,6.00000e-02,4.03633e+00,3.04796e+00,6.09537e-02,3.86545e+00,
2.92331e+00,6.30957e-02,3.51699e+00,2.66731e+00,6.30960e-02,3.51695e+00,2.66728e+00,6.53131e-02,3.20093e+00,2.43320e+00,
6.76083e-02,2.91454e+00,2.21920e+00,6.91831e-02,2.73870e+00,2.08687e+00,7.07946e-02,2.57402e+00,1.96228e+00,7.16143e-02,
2.49556e+00,1.90268e+00,7.24436e-02,2.41887e+00,1.84422e+00,7.32825e-02,2.34469e+00,1.78753e+00,7.49894e-02,2.20347e+00,
1.67922e+00,7.94328e-02,1.88877e+00,1.43600e+00,7.94330e-02,1.88876e+00,1.43599e+00,8.22243e-02,1.72319e+00,1.30723e+00,
8.31764e-02,1.67154e+00,1.26692e+00,8.36265e-02,1.64792e+00,1.24845e+00,8.51138e-02,1.57318e+00,1.18996e+00,8.70964e-02,
1.48109e+00,1.11766e+00,8.91251e-02,1.39479e+00,1.04968e+00,9.01571e-02,1.35372e+00,1.01726e+00,9.88553e-02,1.06761e+00,
7.89775e-01,1.00000e-01,1.03689e+00,7.65207e-01,1.01158e-01,1.00709e+00,7.41443e-01,1.02329e-01,9.78262e-01,7.18431e-01,
1.03514e-01,9.50368e-01,6.96144e-01,1.05925e-01,8.97263e-01,6.53656e-01,1.07152e-01,8.71995e-01,6.33415e-01,1.08690e-01,
8.41837e-01,6.09236e-01,1.09648e-01,8.23866e-01,5.94832e-01,1.10918e-01,8.00930e-01,5.76438e-01,1.13501e-01,7.57263e-01,
5.41383e-01,1.14815e-01,7.36482e-01,5.24686e-01,1.16145e-01,7.16373e-01,5.08520e-01,1.20226e-01,6.59856e-01,4.63044e-01,
1.23027e-01,6.25148e-01,4.35089e-01,1.24452e-01,6.08628e-01,4.21781e-01,1.25890e-01,5.92640e-01,4.08897e-01,1.25893e-01,
5.92612e-01,4.08875e-01,1.27350e-01,5.77041e-01,3.96412e-01,1.30317e-01,5.47382e-01,3.72674e-01,1.32598e-01,5.26271e-01,
3.55781e-01,1.34896e-01,5.06327e-01,3.39848e-01,1.38038e-01,4.81077e-01,3.19683e-01,1.39637e-01,4.69052e-01,3.10085e-01,
1.41254e-01,4.57411e-01,3.00795e-01,1.42889e-01,4.46140e-01,2.91805e-01,1.47911e-01,4.14429e-01,2.66536e-01,1.50000e-01,
4.02400e-01,2.56962e-01,1.53109e-01,3.85635e-01,2.43632e-01,1.54882e-01,3.76637e-01,2.36485e-01,1.58489e-01,3.59484e-01,
2.22877e-01,1.58490e-01,3.59480e-01,2.22875e-01,1.60324e-01,3.51248e-01,2.16432e-01,1.64059e-01,3.35539e-01,2.04161e-01,
1.65720e-01,3.28973e-01,1.99042e-01,1.65959e-01,3.28049e-01,1.98323e-01,1.71791e-01,3.06916e-01,1.81919e-01,1.73780e-01,
3.00303e-01,1.76801e-01,1.75792e-01,2.93895e-01,1.71849e-01,1.79887e-01,2.81665e-01,1.62422e-01,1.84077e-01,2.70175e-01,
1.53597e-01,1.86209e-01,2.64692e-01,1.49398e-01,1.88365e-01,2.59377e-01,1.45335e-01,1.90546e-01,2.54263e-01,1.41441e-01,
1.92752e-01,2.49303e-01,1.37672e-01,1.97242e-01,2.39827e-01,1.30494e-01,1.99526e-01,2.35300e-01,1.27077e-01,1.99530e-01,
2.35293e-01,1.27072e-01,2.00000e-01,2.34374e-01,1.26393e-01,2.01837e-01,2.30858e-01,1.23800e-01,2.04174e-01,2.26546e-01,
1.20629e-01,2.08930e-01,2.18301e-01,1.14590e-01,2.09168e-01,2.17906e-01,1.14302e-01,2.13796e-01,2.10526e-01,1.08938e-01,
2.16272e-01,2.06808e-01,1.06248e-01,2.18776e-01,2.03198e-01,1.03644e-01,2.21309e-01,1.99694e-01,1.01125e-01,2.23872e-01,
1.96290e-01,9.86861e-02,2.26464e-01,1.92985e-01,9.63259e-02,2.29087e-01,1.89775e-01,9.40414e-02,2.30000e-01,1.88687e-01,
9.32692e-02,2.34423e-01,1.83678e-01,8.97386e-02,2.42661e-01,1.75177e-01,8.37968e-02,2.45471e-01,1.72499e-01,8.19399e-02,
2.48313e-01,1.69896e-01,8.01420e-02,2.51189e-01,1.67366e-01,7.84007e-02,2.51190e-01,1.67364e-01,7.83999e-02,2.54097e-01,
1.64863e-01,7.67432e-02,2.57040e-01,1.62431e-01,7.51404e-02,2.60016e-01,1.60065e-01,7.35881e-02,2.63027e-01,1.57762e-01,
7.20850e-02,2.66073e-01,1.55521e-01,7.06293e-02,2.69154e-01,1.53340e-01,6.92194e-02,2.72270e-01,1.51216e-01,6.78538e-02,
2.75423e-01,1.49169e-01,6.65505e-02,2.79850e-01,1.46421e-01,6.48118e-02,2.85102e-01,1.43334e-01,6.28771e-02,2.88403e-01,
1.41487e-01,6.17270e-02,2.91743e-01,1.39687e-01,6.06123e-02,2.95121e-01,1.37932e-01,5.95317e-02,2.98538e-01,1.36221e-01,
5.84841e-02,3.01995e-01,1.34555e-01,5.74702e-02,3.05492e-01,1.32930e-01,5.64872e-02,3.09029e-01,1.31346e-01,5.55344e-02,
3.16228e-01,1.28294e-01,5.37146e-02,3.16230e-01,1.28293e-01,5.37141e-02,3.19889e-01,1.26806e-01,5.28882e-02,3.27341e-01,
1.23933e-01,5.13080e-02,3.31131e-01,1.22546e-01,5.05527e-02,3.38844e-01,1.19867e-01,4.91079e-02,3.42768e-01,1.18573e-01,
4.84172e-02,3.46737e-01,1.17309e-01,4.77478e-02,3.50752e-01,1.16074e-01,4.70978e-02,3.54813e-01,1.14867e-01,4.64668e-02,
3.58922e-01,1.13686e-01,4.58539e-02,3.63078e-01,1.12543e-01,4.52701e-02,3.67282e-01,1.11424e-01,4.47026e-02,3.71535e-01,
1.10329e-01,4.41509e-02,3.75837e-01,1.09257e-01,4.36146e-02,3.80189e-01,1.08207e-01,4.30930e-02,3.84592e-01,1.07179e-01,
4.25858e-02,3.89045e-01,1.06173e-01,4.20924e-02,3.98107e-01,1.04223e-01,4.11474e-02,3.98110e-01,1.04222e-01,4.11471e-02,
4.02717e-01,1.03250e-01,4.07184e-02,4.04605e-01,1.02864e-01,4.05513e-02,4.07380e-01,1.02305e-01,4.03102e-02,4.12098e-01,
1.01378e-01,3.99127e-02,4.21697e-01,9.95758e-02,3.91479e-02,4.26580e-01,9.86999e-02,3.87799e-02,4.36516e-01,9.69963e-02,
3.80715e-02,4.41570e-01,9.61685e-02,3.77311e-02,4.46684e-01,9.53557e-02,3.73992e-02,4.51856e-01,9.45574e-02,3.70754e-02,
4.57088e-01,9.37805e-02,3.67664e-02,4.62381e-01,9.30169e-02,3.64646e-02,4.67735e-01,9.22663e-02,3.61697e-02,4.78630e-01,
9.08029e-02,3.55999e-02,4.84172e-01,9.00893e-02,3.53245e-02,4.89779e-01,8.93876e-02,3.50552e-02,4.95450e-01,8.86979e-02,
3.47924e-02,5.01187e-01,8.80193e-02,3.45353e-02,5.01190e-01,8.80189e-02,3.45352e-02,5.06991e-01,8.73328e-02,3.43100e-02,
5.12861e-01,8.66568e-02,3.40890e-02,5.18800e-01,8.59910e-02,3.38723e-02,5.30884e-01,8.46892e-02,3.34512e-02,5.37032e-01,
8.40527e-02,3.32465e-02,5.43250e-01,8.34255e-02,3.30455e-02,5.55904e-01,8.21991e-02,3.26553e-02,5.62341e-01,8.16038e-02,
3.24701e-02,5.68853e-01,8.10167e-02,3.22878e-02,5.75440e-01,8.04375e-02,3.21085e-02,5.82103e-01,7.98662e-02,3.19320e-02,
5.88844e-01,7.93025e-02,3.17582e-02,6.02560e-01,7.81975e-02,3.14185e-02,6.06038e-01,7.79259e-02,3.13353e-02,6.09537e-01,
7.76559e-02,3.12527e-02,6.16595e-01,7.71211e-02,3.10894e-02,6.23735e-01,7.65970e-02,3.09321e-02,6.30957e-01,7.60794e-02,
3.07769e-02,6.30960e-01,7.60792e-02,3.07769e-02,6.38264e-01,7.55468e-02,3.06408e-02,6.45654e-01,7.50206e-02,3.05060e-02,
6.60694e-01,7.39870e-02,3.02405e-02,6.62370e-01,7.38748e-02,3.02116e-02,6.68344e-01,7.34797e-02,3.01099e-02,6.76083e-01,
7.29784e-02,2.99806e-02,6.83912e-01,7.24828e-02,2.98524e-02,6.99842e-01,7.15144e-02,2.96051e-02,7.07946e-01,7.10383e-02,
2.94828e-02,7.16143e-01,7.05673e-02,2.93614e-02,7.24436e-01,7.01015e-02,2.92408e-02,7.32825e-01,6.96407e-02,2.91211e-02,
7.41310e-01,6.91851e-02,2.90024e-02,7.49894e-01,6.87344e-02,2.88844e-02,7.58578e-01,6.82906e-02,2.87694e-02,7.67362e-01,
6.78515e-02,2.86551e-02,7.76247e-01,6.74168e-02,2.85414e-02,7.85236e-01,6.69865e-02,2.84282e-02,7.94328e-01,6.65606e-02,
2.83156e-02,7.94330e-01,6.65605e-02,2.83156e-02,8.03526e-01,6.61208e-02,2.82184e-02,8.12831e-01,6.56854e-02,2.81211e-02,
8.22243e-01,6.52544e-02,2.80242e-02,8.31764e-01,6.48296e-02,2.79292e-02,8.41395e-01,6.44089e-02,2.78341e-02,8.51138e-01,
6.39922e-02,2.77390e-02,8.60994e-01,6.35793e-02,2.76439e-02,8.70964e-01,6.31703e-02,2.75487e-02,9.01571e-01,6.19658e-02,
2.72628e-02,9.12011e-01,6.15733e-02,2.71690e-02,9.22571e-01,6.11843e-02,2.70751e-02,9.33254e-01,6.07989e-02,2.69813e-02,
9.44061e-01,6.04169e-02,2.68874e-02,9.54993e-01,6.00382e-02,2.67933e-02,9.66051e-01,5.96627e-02,2.66992e-02,9.77237e-01,
5.92905e-02,2.66049e-02,9.88553e-01,5.89215e-02,2.65105e-02,9.92501e-01,5.87949e-02,2.64782e-02,1.00000e+00,5.85568e-02,
2.64172e-02,1.00000e-03,4.93851e+03,4.93284e+03,1.02329e-03,4.68876e+03,4.68311e+03,1.03094e-03,4.60981e+03,4.60418e+03,
1.03514e-03,4.56729e+03,4.56167e+03,1.05000e-03,4.42109e+03,4.41548e+03,1.07664e-03,4.17607e+03,4.17050e+03,1.08393e-03,
4.11245e+03,4.10689e+03,1.10000e-03,3.97621e+03,3.97068e+03,1.10918e-03,3.90142e+03,3.89590e+03,1.11000e-03,3.89479e+03,
3.88928e+03,1.12202e-03,3.79997e+03,3.79448e+03,1.13501e-03,3.70056e+03,3.69509e+03,1.17490e-03,3.41590e+03,3.41049e+03,
1.20226e-03,3.23909e+03,3.23372e+03,1.21619e-03,3.15366e+03,3.14831e+03,1.23027e-03,3.07002e+03,3.06469e+03,1.24451e-03,
2.98823e+03,2.98292e+03,1.25890e-03,2.90882e+03,2.90353e+03,1.25892e-03,2.90868e+03,2.90340e+03,1.28825e-03,2.75530e+03,
2.75006e+03,1.31826e-03,2.61051e+03,2.60531e+03,1.33352e-03,2.54114e+03,2.53597e+03,1.35540e-03,2.44571e+03,2.44056e+03,
1.36458e-03,2.40694e+03,2.40180e+03,1.36822e-03,2.39178e+03,2.38665e+03,1.39637e-03,2.27908e+03,2.27400e+03,1.40000e-03,
2.26510e+03,2.26002e+03,1.41254e-03,2.21779e+03,2.21273e+03,1.43744e-03,2.12770e+03,2.12268e+03,1.45000e-03,2.08421e+03,
2.07921e+03,1.47911e-03,1.98825e+03,1.98330e+03,1.49624e-03,1.93442e+03,1.92950e+03,1.50000e-03,1.92279e+03,1.91788e+03,
1.51356e-03,1.88155e+03,1.87666e+03,1.54882e-03,1.78023e+03,1.77540e+03,1.56675e-03,1.73175e+03,1.72694e+03,1.57817e-03,
1.70182e+03,1.69703e+03,1.58489e-03,1.68457e+03,1.67978e+03,1.58490e-03,1.68455e+03,1.67977e+03,1.65167e-03,1.52574e+03,
1.52106e+03,1.65959e-03,1.50835e+03,1.50368e+03,1.67880e-03,1.46668e+03,1.46206e+03,1.69824e-03,1.42615e+03,1.42156e+03,
1.71791e-03,1.38679e+03,1.38223e+03,1.73800e-03,1.34822e+03,1.34370e+03,1.75792e-03,1.31146e+03,1.30697e+03,1.82008e-03,
1.20543e+03,1.20105e+03,1.84077e-03,1.17281e+03,1.16847e+03,1.86209e-03,1.14023e+03,1.13593e+03,1.90482e-03,1.07843e+03,
1.07420e+03,1.90546e-03,1.07754e+03,1.07331e+03,1.97242e-03,9.90003e+02,9.85907e+02,1.98524e-03,9.74405e+02,9.70333e+02,
1.99526e-03,9.62441e+02,9.58391e+02,1.99530e-03,9.62396e+02,9.58346e+02,2.04174e-03,9.09590e+02,9.05640e+02,2.05545e-03,
8.94649e+02,8.90727e+02,2.07000e-03,8.79158e+02,8.75271e+02,2.08930e-03,8.59133e+02,8.55292e+02,2.11349e-03,8.34937e+02,
8.31150e+02,2.11653e-03,8.31969e+02,8.28189e+02,2.17554e-03,7.77232e+02,7.73602e+02,2.18776e-03,7.66525e+02,7.62929e+02,
2.21310e-03,7.44985e+02,7.41460e+02,2.22429e-03,7.35742e+02,7.32247e+02,2.23872e-03,7.24055e+02,7.20605e+02,2.26464e-03,
7.03680e+02,7.00308e+02,2.30232e-03,6.75177e+02,6.71934e+02,2.31740e-03,6.64215e+02,6.61030e+02,2.33355e-03,6.52716e+02,
6.49593e+02,2.34423e-03,6.45256e+02,6.42180e+02,2.36355e-03,6.32093e+02,6.29100e+02,2.38750e-03,6.16267e+02,6.13394e+02,
2.40470e-03,6.05228e+02,6.02452e+02,2.42487e-03,5.92611e+02,5.89967e+02,2.42661e-03,5.91539e+02,5.88909e+02,2.44023e-03,
5.83252e+02,5.80726e+02,2.45392e-03,5.75061e+02,5.72656e+02,2.45471e-03,5.74592e+02,5.72194e+02,2.47176e-03,5.64595e+02,
5.62360e+02,2.48313e-03,5.58066e+02,5.55930e+02,2.48481e-03,5.57111e+02,5.54990e+02,2.49357e-03,5.52186e+02,5.50122e+02,
2.49793e-03,5.49763e+02,5.47720e+02,2.50294e-03,5.47009e+02,5.44982e+02,2.50898e-03,5.43722e+02,5.41703e+02,2.51189e-03,
5.42156e+02,5.40134e+02,2.51190e-03,5.42149e+02,5.40127e+02,2.51502e-03,5.40464e+02,5.38439e+02,2.52100e-03,5.37267e+02,
5.35224e+02,2.52100e-03,1.94507e+03,1.89636e+03,2.52106e-03,1.94495e+03,1.89625e+03,2.52746e-03,1.93246e+03,1.88415e+03,
2.53641e-03,1.91520e+03,1.86740e+03,2.54097e-03,1.90647e+03,1.85893e+03,2.56429e-03,1.86277e+03,1.81648e+03,2.57040e-03,
1.85156e+03,1.80559e+03,2.57503e-03,1.84311e+03,1.79738e+03,2.59241e-03,1.81191e+03,1.76709e+03,2.61745e-03,1.76825e+03,
1.72468e+03,2.62950e-03,1.74777e+03,1.70476e+03,2.62950e-03,2.41395e+03,2.34651e+03,2.63027e-03,2.41216e+03,2.34477e+03,
2.63636e-03,2.39799e+03,2.33108e+03,2.65062e-03,2.36527e+03,2.29944e+03,2.66073e-03,2.34246e+03,2.27738e+03,2.66500e-03,
2.33337e+03,2.26859e+03,2.66675e-03,2.32979e+03,2.26513e+03,2.67839e-03,2.30614e+03,2.24227e+03,2.68771e-03,2.28744e+03,
2.22420e+03,2.69776e-03,2.26752e+03,2.20495e+03,2.70000e-03,2.26311e+03,2.20069e+03,2.71000e-03,2.24409e+03,2.18232e+03,
2.71091e-03,2.24228e+03,2.18057e+03,2.72000e-03,2.22433e+03,2.16324e+03,2.72649e-03,2.21082e+03,2.15018e+03,2.74314e-03,
2.17667e+03,2.11720e+03,2.76000e-03,2.14282e+03,2.08450e+03,2.76049e-03,2.14189e+03,2.08360e+03,2.77764e-03,2.10953e+03,
2.05237e+03,2.78612e-03,2.09378e+03,2.03717e+03,2.80000e-03,2.06837e+03,2.01263e+03,2.81696e-03,2.03788e+03,1.98320e+03,
2.81838e-03,2.03535e+03,1.98075e+03,2.82871e-03,2.01663e+03,1.96265e+03,2.84625e-03,1.98537e+03,1.93241e+03,2.84650e-03,
1.98493e+03,1.93199e+03,2.84650e-03,2.27501e+03,2.21332e+03,2.86700e-03,2.23616e+03,2.17576e+03,2.87435e-03,2.22247e+03,
2.16252e+03,2.88403e-03,2.20462e+03,2.14525e+03,2.88863e-03,2.19622e+03,2.13712e+03,2.90000e-03,2.17563e+03,2.11720e+03,
2.90364e-03,2.16895e+03,2.11074e+03,2.91743e-03,2.14390e+03,2.08650e+03,2.91856e-03,2.14187e+03,2.08454e+03,2.93703e-03,
2.10898e+03,2.05273e+03,2.95121e-03,2.08422e+03,2.02878e+03,2.95900e-03,2.07081e+03,2.01581e+03,2.98538e-03,2.02624e+03,
1.97270e+03,3.00000e-03,2.00212e+03,1.94938e+03,3.01995e-03,1.96986e+03,1.91817e+03,3.04154e-03,1.93541e+03,1.88484e+03,
3.07000e-03,1.89127e+03,1.84213e+03,3.11067e-03,1.83052e+03,1.78332e+03,3.12608e-03,1.80821e+03,1.76173e+03,3.16228e-03,
1.75666e+03,1.71180e+03,3.16230e-03,1.75662e+03,1.71177e+03,3.18086e-03,1.73095e+03,1.68689e+03,3.19889e-03,1.70651e+03,
1.66321e+03,3.23594e-03,1.65781e+03,1.61603e+03,3.25208e-03,1.63708e+03,1.59593e+03,3.31131e-03,1.56403e+03,1.52511e+03,
3.34126e-03,1.52887e+03,1.49100e+03,3.34965e-03,1.51921e+03,1.48163e+03,3.42768e-03,1.43349e+03,1.39846e+03,3.45000e-03,
1.41023e+03,1.37588e+03,3.46773e-03,1.39198e+03,1.35817e+03,3.50752e-03,1.35223e+03,1.31956e+03,3.54813e-03,1.31329e+03,
1.28174e+03,3.58922e-03,1.27542e+03,1.24494e+03,3.63078e-03,1.23867e+03,1.20923e+03,3.65000e-03,1.22219e+03,1.19320e+03,
3.67282e-03,1.20300e+03,1.17455e+03,3.71535e-03,1.16836e+03,1.14087e+03,3.84592e-03,1.07051e+03,1.04567e+03,3.90000e-03,
1.03331e+03,1.00946e+03,3.93550e-03,1.00991e+03,9.86674e+02,3.98107e-03,9.80697e+02,9.58224e+02,3.98110e-03,9.80680e+02,
9.58207e+02,4.00000e-03,9.68907e+02,9.46739e+02,4.02717e-03,9.52309e+02,9.30568e+02,4.07380e-03,9.24627e+02,9.03592e+02,
4.12097e-03,8.97787e+02,8.77429e+02,4.16869e-03,8.71723e+02,8.52021e+02,4.21696e-03,8.46443e+02,8.27372e+02,4.31519e-03,
7.98120e+02,7.80236e+02,4.41570e-03,7.52198e+02,7.35422e+02,4.46684e-03,7.30138e+02,7.13889e+02,4.51856e-03,7.08732e+02,
6.92991e+02,4.57088e-03,6.87944e+02,6.72690e+02,4.62381e-03,6.67786e+02,6.53001e+02,4.67735e-03,6.48076e+02,6.33743e+02,
4.76890e-03,6.16231e+02,6.02621e+02,4.78630e-03,6.10423e+02,5.96945e+02,4.95450e-03,5.58109e+02,5.45802e+02,5.01187e-03,
5.41714e+02,5.29767e+02,5.01190e-03,5.41706e+02,5.29759e+02,5.06991e-03,5.25802e+02,5.14202e+02,5.12861e-03,5.10124e+02,
4.98862e+02,5.19839e-03,4.92317e+02,4.81433e+02,5.24807e-03,4.80155e+02,4.69531e+02,5.30000e-03,4.67810e+02,4.57448e+02,
5.37032e-03,4.51792e+02,4.41766e+02,5.43250e-03,4.38264e+02,4.28521e+02,5.55904e-03,4.12450e+02,4.03240e+02,5.68853e-03,
3.88201e+02,3.79484e+02,5.74576e-03,3.78118e+02,3.69603e+02,5.75440e-03,3.76627e+02,3.68143e+02,5.82103e-03,3.65408e+02,
3.57150e+02,5.95662e-03,3.43872e+02,3.36045e+02,6.00000e-03,3.37314e+02,3.29616e+02,6.02560e-03,3.33523e+02,3.25900e+02,
6.16595e-03,3.13768e+02,3.06531e+02,6.23735e-03,3.04319e+02,2.97264e+02,6.27071e-03,3.00045e+02,2.93073e+02,6.30957e-03,
2.95170e+02,2.88293e+02,6.30960e-03,2.95167e+02,2.88290e+02,6.50000e-03,2.72800e+02,2.66355e+02,6.53131e-03,2.69352e+02,
2.62974e+02,6.60693e-03,2.61198e+02,2.54975e+02,6.68344e-03,2.53289e+02,2.47216e+02,6.83912e-03,2.38151e+02,2.32363e+02,
6.91852e-03,2.30888e+02,2.25234e+02,7.00000e-03,2.23746e+02,2.18228e+02,7.07946e-03,2.17080e+02,2.11687e+02,7.11016e-03,
2.14577e+02,2.09231e+02,7.41310e-03,1.91919e+02,1.86997e+02,7.49894e-03,1.86111e+02,1.81297e+02,7.50000e-03,1.86041e+02,
1.81228e+02,7.67362e-03,1.75022e+02,1.70414e+02,7.76247e-03,1.69698e+02,1.65188e+02,7.82933e-03,1.65842e+02,1.61403e+02,
7.85236e-03,1.64541e+02,1.60126e+02,7.94328e-03,1.59507e+02,1.55186e+02,7.94330e-03,1.59506e+02,1.55185e+02,8.00000e-03,
1.56475e+02,1.52211e+02,8.03526e-03,1.54631e+02,1.50401e+02,8.22243e-03,1.45335e+02,1.41279e+02,8.31764e-03,1.40887e+02,
1.36914e+02,8.41395e-03,1.36576e+02,1.32683e+02,8.51138e-03,1.32399e+02,1.28584e+02,8.74800e-03,1.22968e+02,1.19329e+02,
8.81049e-03,1.20632e+02,1.17038e+02,9.00000e-03,1.13925e+02,1.10460e+02,9.12011e-03,1.09921e+02,1.06532e+02,9.22571e-03,
1.06543e+02,1.03219e+02,9.49688e-03,9.85123e+01,9.53434e+01,9.54993e-03,9.70391e+01,9.38995e+01,9.66051e-03,9.40680e+01,
9.09875e+01,9.77237e-03,9.11886e+01,8.81656e+01,9.80000e-03,9.04941e+01,8.74850e+01,1.00000e-02,8.56798e+01,8.27671e+01,
1.01158e-02,8.30530e+01,8.01933e+01,1.02329e-02,8.04965e+01,7.76884e+01,1.02647e-02,7.98231e+01,7.70286e+01,1.03514e-02,
7.80206e+01,7.52639e+01,1.04713e-02,7.56108e+01,7.29045e+01,1.05925e-02,7.32782e+01,7.06211e+01,1.08393e-02,6.88344e+01,
6.62716e+01,1.09648e-02,6.67175e+01,6.42001e+01,1.10830e-02,6.48056e+01,6.23295e+01,1.12202e-02,6.26790e+01,6.02506e+01,
1.15000e-02,5.86276e+01,5.62911e+01,1.16145e-02,5.70745e+01,5.47736e+01,1.17490e-02,5.53233e+01,5.30628e+01,1.20226e-02,
5.19615e+01,4.97790e+01,1.21619e-02,5.03506e+01,4.82073e+01,1.24451e-02,4.72817e+01,4.52140e+01,1.25890e-02,4.58228e+01,
4.37914e+01,1.25892e-02,4.58203e+01,4.37890e+01,1.28825e-02,4.30342e+01,4.10733e+01,1.29341e-02,4.25679e+01,4.06189e+01,
1.34896e-02,3.79610e+01,3.61366e+01,1.36458e-02,3.67913e+01,3.49991e+01,1.38038e-02,3.56590e+01,3.38983e+01,1.39009e-02,
3.49826e+01,3.32408e+01,1.39637e-02,3.45540e+01,3.28246e+01,1.41254e-02,3.34836e+01,3.17855e+01,1.42889e-02,3.24427e+01,
3.07752e+01,1.44544e-02,3.14347e+01,2.97971e+01,1.45065e-02,3.11265e+01,2.94980e+01,1.47911e-02,2.95118e+01,2.79341e+01,
1.50000e-02,2.84004e+01,2.68581e+01,1.51356e-02,2.77103e+01,2.61901e+01,1.55625e-02,2.56819e+01,2.42278e+01,1.58489e-02,
2.44319e+01,2.30217e+01,1.58490e-02,2.44316e+01,2.30214e+01,1.60324e-02,2.36753e+01,2.22921e+01,1.62181e-02,2.29377e+01,
2.15808e+01,1.64059e-02,2.22238e+01,2.08927e+01,1.64773e-02,2.19607e+01,2.06392e+01,1.65959e-02,2.15319e+01,2.02271e+01,
1.67880e-02,2.08609e+01,1.95823e+01,1.71791e-02,1.95776e+01,1.83497e+01,1.71912e-02,1.95395e+01,1.83131e+01,1.73780e-02,
1.89651e+01,1.77635e+01,1.77749e-02,1.78205e+01,1.66688e+01,1.77828e-02,1.77987e+01,1.66480e+01,1.80000e-02,1.72115e+01,
1.60890e+01,1.82217e-02,1.66388e+01,1.55439e+01,1.84077e-02,1.61757e+01,1.51055e+01,1.85783e-02,1.57642e+01,1.47158e+01,
1.86209e-02,1.56630e+01,1.46207e+01,1.88365e-02,1.51635e+01,1.41510e+01,1.88607e-02,1.51088e+01,1.40996e+01,1.89998e-02,
1.47976e+01,1.38091e+01,1.91244e-02,1.45243e+01,1.35558e+01,1.92257e-02,1.43054e+01,1.33545e+01,1.92752e-02,1.41990e+01,
1.32575e+01,1.93178e-02,1.41084e+01,1.31751e+01,1.93961e-02,1.39416e+01,1.30249e+01,1.94985e-02,1.37245e+01,1.28322e+01,
1.96556e-02,1.33945e+01,1.25441e+01,1.97674e-02,1.31670e+01,1.23444e+01,1.98402e-02,1.30257e+01,1.22166e+01,1.99052e-02,
1.29060e+01,1.21041e+01,1.99526e-02,1.28230e+01,1.20229e+01,1.99530e-02,1.28223e+01,1.20223e+01,1.99553e-02,1.28183e+01,
1.20183e+01,1.99650e-02,1.28020e+01,1.20018e+01,1.99650e-02,8.05426e+01,3.33674e+01,1.99976e-02,8.03076e+01,3.33360e+01,
2.00000e-02,8.02902e+01,3.33337e+01,2.00534e-02,7.99102e+01,3.32818e+01,2.01221e-02,7.94298e+01,3.32144e+01,2.01500e-02,
7.92378e+01,3.31869e+01,2.01837e-02,7.89213e+01,3.31172e+01,2.03313e-02,7.75567e+01,3.28122e+01,2.04332e-02,7.66322e+01,
3.26018e+01,2.04500e-02,7.64806e+01,3.25671e+01,2.05068e-02,7.59068e+01,3.24311e+01,2.06315e-02,7.46632e+01,3.21333e+01,
2.07849e-02,7.31669e+01,3.17687e+01,2.08000e-02,7.30216e+01,3.17330e+01,2.08930e-02,7.22214e+01,3.15516e+01,2.10060e-02,
7.12651e+01,3.13313e+01,2.11349e-02,7.01942e+01,3.10805e+01,2.11410e-02,7.01441e+01,3.10686e+01,2.12569e-02,6.92004e+01,
3.08432e+01,2.15000e-02,6.72751e+01,3.03721e+01,2.16272e-02,6.62481e+01,3.01039e+01,2.16739e-02,6.58762e+01,3.00057e+01,
2.18776e-02,6.42860e+01,2.95799e+01,2.22250e-02,6.16950e+01,2.88633e+01,2.22587e-02,6.14514e+01,2.87944e+01,2.23872e-02,
6.05339e+01,2.85331e+01,2.26464e-02,5.87399e+01,2.80115e+01,2.28433e-02,5.74266e+01,2.76206e+01,2.31740e-02,5.53098e+01,
2.69748e+01,2.34423e-02,5.36937e+01,2.64721e+01,2.37137e-02,5.21254e+01,2.59724e+01,2.37300e-02,5.20334e+01,2.59428e+01,
2.42661e-02,4.91230e+01,2.49829e+01,2.45471e-02,4.76863e+01,2.44933e+01,2.45620e-02,4.76117e+01,2.44676e+01,2.48201e-02,
4.63461e+01,2.40270e+01,2.51189e-02,4.49384e+01,2.35275e+01,2.51190e-02,4.49377e+01,2.35273e+01,2.54097e-02,4.36246e+01,
2.30520e+01,2.57040e-02,4.23146e+01,2.25627e+01,2.60016e-02,4.10441e+01,2.20793e+01,2.63027e-02,3.98120e+01,2.16022e+01,
2.63216e-02,3.97362e+01,2.15726e+01,2.66073e-02,3.86165e+01,2.11316e+01,2.69154e-02,3.74572e+01,2.06676e+01,2.72270e-02,
3.63331e+01,2.02105e+01,2.75423e-02,3.52432e+01,1.97602e+01,2.79916e-02,3.37673e+01,1.91442e+01,2.81838e-02,3.31614e+01,
1.88876e+01,2.88403e-02,3.12003e+01,1.80406e+01,2.91743e-02,3.02642e+01,1.76276e+01,2.95121e-02,2.93566e+01,1.72215e+01,
2.98538e-02,2.84765e+01,1.68225e+01,3.01995e-02,2.76232e+01,1.64305e+01,3.08773e-02,2.60186e+01,1.56748e+01,3.09030e-02,
2.59603e+01,1.56471e+01,3.12608e-02,2.51667e+01,1.52665e+01,3.16228e-02,2.43977e+01,1.48934e+01,3.16230e-02,2.43973e+01,
1.48932e+01,3.27341e-02,2.22300e+01,1.38181e+01,3.31131e-02,2.15509e+01,1.34738e+01,3.34965e-02,2.08929e+01,1.31365e+01,
3.39654e-02,2.01254e+01,1.27388e+01,3.42768e-02,1.96367e+01,1.24831e+01,3.48155e-02,1.88295e+01,1.20564e+01,3.50752e-02,
1.84567e+01,1.18575e+01,3.54813e-02,1.78940e+01,1.15548e+01,3.58922e-02,1.73485e+01,1.12588e+01,3.67282e-02,1.63078e+01,
1.06865e+01,3.73446e-02,1.55953e+01,1.02888e+01,3.75837e-02,1.53303e+01,1.01397e+01,3.80189e-02,1.48639e+01,9.87571e+00,
3.84592e-02,1.44114e+01,9.61742e+00,3.93550e-02,1.35319e+01,9.10750e+00,3.98107e-02,1.31127e+01,8.86175e+00,3.98110e-02,
1.31125e+01,8.86160e+00,4.01055e-02,1.28511e+01,8.70743e+00,4.07380e-02,1.23131e+01,8.38810e+00,4.21696e-02,1.12052e+01,
7.72240e+00,4.31519e-02,1.05235e+01,7.30565e+00,4.41570e-02,9.88403e+00,6.90963e+00,4.46684e-02,9.57931e+00,6.71909e+00,
4.50000e-02,9.38853e+00,6.59925e+00,4.62381e-02,8.72038e+00,6.17568e+00,4.80000e-02,7.87862e+00,5.63335e+00,4.95450e-02,
7.22102e+00,5.20158e+00,5.01187e-02,6.99625e+00,5.05254e+00,5.01190e-02,6.99614e+00,5.05247e+00,5.02474e-02,6.94712e+00,
5.01988e+00,5.06991e-02,6.77838e+00,4.90752e+00,5.12861e-02,6.56743e+00,4.76643e+00,5.18800e-02,6.36317e+00,4.62915e+00,
5.30000e-02,6.00138e+00,4.38434e+00,5.30884e-02,5.97401e+00,4.36573e+00,5.43250e-02,5.60894e+00,4.11629e+00,5.61349e-02,
5.12868e+00,3.78464e+00,6.00000e-02,4.27855e+00,3.18768e+00,6.02560e-02,4.22944e+00,3.15277e+00,6.16595e-02,3.97055e+00,
2.96759e+00,6.23735e-02,3.84734e+00,2.87899e+00,6.30957e-02,3.72812e+00,2.79295e+00,6.30960e-02,3.72808e+00,2.79292e+00,
6.41678e-02,3.56041e+00,2.67154e+00,6.45654e-02,3.50087e+00,2.62832e+00,6.91831e-02,2.90129e+00,2.18899e+00,7.00000e-02,
2.81063e+00,2.12181e+00,7.07946e-02,2.72627e+00,2.05912e+00,7.24436e-02,2.56236e+00,1.93678e+00,7.32825e-02,2.48434e+00,
1.87831e+00,7.41310e-02,2.40883e+00,1.82156e+00,7.49894e-02,2.33575e+00,1.76650e+00,7.50000e-02,2.33487e+00,1.76583e+00,
7.67362e-02,2.19524e+00,1.66009e+00,7.94328e-02,2.00114e+00,1.51220e+00,7.94330e-02,2.00113e+00,1.51219e+00,8.51138e-02,
1.66520e+00,1.25418e+00,8.60994e-02,1.61540e+00,1.21564e+00,8.85423e-02,1.50100e+00,1.12683e+00,8.91251e-02,1.47546e+00,
1.10696e+00,9.12011e-02,1.38952e+00,1.03994e+00,9.33254e-02,1.30904e+00,9.76964e-01,9.54993e-02,1.23369e+00,9.17808e-01,
9.66051e-02,1.19755e+00,8.89348e-01,9.77237e-02,1.16259e+00,8.61774e-01,9.88553e-02,1.12877e+00,8.35062e-01,1.00000e-01,
1.09603e+00,8.09162e-01,1.03514e-01,1.00382e+00,7.36310e-01,1.09648e-01,8.69028e-01,6.29358e-01,1.12202e-01,8.21020e-01,
5.91135e-01,1.13775e-01,7.93496e-01,5.69192e-01,1.14815e-01,7.76049e-01,5.55287e-01,1.18850e-01,7.13852e-01,5.05653e-01,
1.20226e-01,6.94443e-01,4.90144e-01,1.21619e-01,6.75659e-01,4.75126e-01,1.23027e-01,6.57482e-01,4.60587e-01,1.24452e-01,
6.39891e-01,4.46509e-01,1.25890e-01,6.22897e-01,4.32903e-01,1.25893e-01,6.22868e-01,4.32880e-01,1.27350e-01,6.06322e-01,
4.19715e-01,1.28825e-01,5.90305e-01,4.06969e-01,1.33352e-01,5.45264e-01,3.71116e-01,1.36125e-01,5.20439e-01,3.51358e-01,
1.38038e-01,5.04377e-01,3.38591e-01,1.41254e-01,4.79224e-01,3.18601e-01,1.44544e-01,4.55644e-01,2.99868e-01,1.46218e-01,
4.44412e-01,2.90949e-01,1.50000e-01,4.20753e-01,2.72172e-01,1.51356e-01,4.12810e-01,2.65872e-01,1.53109e-01,4.02935e-01,
2.58043e-01,1.54882e-01,3.93372e-01,2.50465e-01,1.56675e-01,3.84110e-01,2.43131e-01,1.58489e-01,3.75140e-01,2.36032e-01,
1.58490e-01,3.75137e-01,2.36029e-01,1.62181e-01,3.57912e-01,2.22569e-01,1.64059e-01,3.49699e-01,2.16161e-01,1.66559e-01,
3.39298e-01,2.08055e-01,1.71791e-01,3.19294e-01,1.92524e-01,1.73780e-01,3.12269e-01,1.87084e-01,1.75792e-01,3.05462e-01,
1.81818e-01,1.77828e-01,2.98865e-01,1.76722e-01,1.81970e-01,2.86275e-01,1.67019e-01,1.84077e-01,2.80269e-01,1.62401e-01,
1.92752e-01,2.58026e-01,1.45369e-01,1.94984e-01,2.52922e-01,1.41487e-01,1.97242e-01,2.47972e-01,1.37728e-01,1.99526e-01,
2.43171e-01,1.34090e-01,1.99530e-01,2.43163e-01,1.34084e-01,2.01837e-01,2.38464e-01,1.30598e-01,2.04174e-01,2.33896e-01,
1.27219e-01,2.06538e-01,2.29464e-01,1.23947e-01,2.08930e-01,2.25162e-01,1.20781e-01,2.13796e-01,2.16936e-01,1.14748e-01,
2.16272e-01,2.12996e-01,1.11876e-01,2.18776e-01,2.09172e-01,1.09096e-01,2.21309e-01,2.05459e-01,1.06405e-01,2.23872e-01,
2.01855e-01,1.03801e-01,2.31740e-01,1.91664e-01,9.64833e-02,2.37137e-01,1.85349e-01,9.19862e-02,2.45471e-01,1.76620e-01,
8.58445e-02,2.48313e-01,1.73872e-01,8.39246e-02,2.51189e-01,1.71200e-01,8.20649e-02,2.51190e-01,1.71199e-01,8.20640e-02,
2.57040e-01,1.65993e-01,7.85748e-02,2.60016e-01,1.63495e-01,7.69116e-02,2.63027e-01,1.61065e-01,7.53006e-02,2.66073e-01,
1.58701e-01,7.37406e-02,2.69154e-01,1.56401e-01,7.22295e-02,2.71080e-01,1.55008e-01,7.13186e-02,2.75423e-01,1.51987e-01,
6.93520e-02,2.80000e-01,1.48970e-01,6.74014e-02,2.81838e-01,1.47819e-01,6.66653e-02,2.85102e-01,1.45835e-01,6.54016e-02,
2.88403e-01,1.43901e-01,6.41763e-02,2.90277e-01,1.42835e-01,6.35035e-02,2.95121e-01,1.40177e-01,6.18364e-02,2.98538e-01,
1.38385e-01,6.07194e-02,3.05492e-01,1.34935e-01,5.85859e-02,3.09029e-01,1.33274e-01,5.75674e-02,3.12608e-01,1.31655e-01,
5.65799e-02,3.16228e-01,1.30078e-01,5.56238e-02,3.16230e-01,1.30077e-01,5.56232e-02,3.19889e-01,1.28506e-01,5.47231e-02,
3.27341e-01,1.25474e-01,5.30018e-02,3.34965e-01,1.22615e-01,5.14104e-02,3.38844e-01,1.21235e-01,5.06493e-02,3.42768e-01,
1.19886e-01,4.99104e-02,3.46737e-01,1.18568e-01,4.91929e-02,3.50752e-01,1.17280e-01,4.84962e-02,3.54813e-01,1.16021e-01,
4.78197e-02,3.58922e-01,1.14791e-01,4.71628e-02,3.63078e-01,1.13589e-01,4.65258e-02,3.67282e-01,1.12414e-01,4.59070e-02,
3.71535e-01,1.11264e-01,4.53057e-02,3.75837e-01,1.10151e-01,4.47329e-02,3.80189e-01,1.09062e-01,4.41758e-02,3.84592e-01,
1.07995e-01,4.36342e-02,3.89045e-01,1.06951e-01,4.31073e-02,3.98107e-01,1.04928e-01,4.20959e-02,3.98110e-01,1.04927e-01,
4.20956e-02,4.00000e-01,1.04510e-01,4.19043e-02,4.02717e-01,1.03919e-01,4.16346e-02,4.07380e-01,1.02931e-01,4.11859e-02,
4.12098e-01,1.01963e-01,4.07499e-02,4.16270e-01,1.01132e-01,4.03779e-02,4.16869e-01,1.01014e-01,4.03255e-02,4.21697e-01,
1.00092e-01,3.99211e-02,4.26580e-01,9.91874e-02,3.95270e-02,4.31519e-01,9.82997e-02,3.91428e-02,4.36516e-01,9.74285e-02,
3.87683e-02,4.46684e-01,9.57341e-02,3.80467e-02,4.51856e-01,9.49101e-02,3.76991e-02,4.57088e-01,9.41011e-02,3.73602e-02,
4.62381e-01,9.33073e-02,3.70301e-02,4.67735e-01,9.25350e-02,3.67151e-02,4.78630e-01,9.10298e-02,3.61066e-02,4.89779e-01,
8.95751e-02,3.55252e-02,5.01187e-01,8.81684e-02,3.49692e-02,5.01190e-01,8.81680e-02,3.49690e-02,5.06991e-01,8.74591e-02,
3.47214e-02,5.12861e-01,8.67619e-02,3.44795e-02,5.18800e-01,8.60816e-02,3.42483e-02,5.24808e-01,8.54116e-02,3.40216e-02,
5.37032e-01,8.41020e-02,3.35811e-02,5.49541e-01,8.28312e-02,3.31571e-02,5.55904e-01,8.22099e-02,3.29509e-02,5.62341e-01,
8.15975e-02,3.27484e-02,5.68853e-01,8.09946e-02,3.25501e-02,5.75440e-01,8.04049e-02,3.23598e-02,5.88844e-01,7.92498e-02,
3.19884e-02,5.95662e-01,7.86840e-02,3.18072e-02,6.02560e-01,7.81258e-02,3.16287e-02,6.09537e-01,7.75751e-02,3.14530e-02,
6.16595e-01,7.70317e-02,3.12800e-02,6.23735e-01,7.64954e-02,3.11096e-02,6.24071e-01,7.64706e-02,3.11019e-02,6.30957e-01,
7.59700e-02,3.09459e-02,6.30960e-01,7.59698e-02,3.09459e-02,6.38264e-01,7.54289e-02,3.08005e-02,6.45654e-01,7.48946e-02,
3.06567e-02,6.53131e-01,7.43668e-02,3.05145e-02,6.60694e-01,7.38454e-02,3.03738e-02,6.83912e-01,7.23185e-02,2.99604e-02,
6.91831e-01,7.18219e-02,2.98256e-02,6.99842e-01,7.13344e-02,2.96954e-02,7.07946e-01,7.08523e-02,2.95662e-02,7.16143e-01,
7.03757e-02,2.94381e-02,7.49894e-01,6.85211e-02,2.89353e-02,7.58578e-01,6.80700e-02,2.88120e-02,7.67362e-01,6.76240e-02,
2.86897e-02,7.76247e-01,6.71852e-02,2.85707e-02,7.85236e-01,6.67509e-02,2.84525e-02,7.94328e-01,6.63210e-02,2.83349e-02,
7.94330e-01,6.63210e-02,2.83348e-02,8.03526e-01,6.58782e-02,2.82330e-02,8.12831e-01,6.54398e-02,2.81312e-02,8.31764e-01,
6.45760e-02,2.79282e-02,8.41395e-01,6.41506e-02,2.78270e-02,8.51138e-01,6.37295e-02,2.77261e-02,8.60994e-01,6.33146e-02,
2.76273e-02,9.01571e-01,6.16936e-02,2.72326e-02,9.12011e-01,6.12977e-02,2.71340e-02,9.19730e-01,6.10102e-02,2.70618e-02,
9.22571e-01,6.09054e-02,2.70354e-02,9.33254e-01,6.05168e-02,2.69369e-02,9.44061e-01,6.01335e-02,2.68402e-02,9.54993e-01,
5.97538e-02,2.67436e-02,9.66051e-01,5.93774e-02,2.66470e-02,9.77237e-01,5.90043e-02,2.65503e-02,9.88553e-01,5.86344e-02,
2.64536e-02,1.00000e+00,5.82678e-02,2.63569e-02,1.00000e-03,5.29462e+03,5.28875e+03,1.01158e-03,5.15836e+03,5.15252e+03,
1.02329e-03,5.02530e+03,5.01947e+03,1.04713e-03,4.76987e+03,4.76407e+03,1.05925e-03,4.64735e+03,4.64157e+03,1.07152e-03,
4.52738e+03,4.52161e+03,1.08393e-03,4.41064e+03,4.40489e+03,1.10380e-03,4.23111e+03,4.22540e+03,1.11000e-03,4.17724e+03,
4.17153e+03,1.12202e-03,4.07488e+03,4.06919e+03,1.15000e-03,3.85067e+03,3.84503e+03,1.16145e-03,3.76418e+03,3.75856e+03,
1.17490e-03,3.66624e+03,3.66064e+03,1.19000e-03,3.56002e+03,3.55444e+03,1.20226e-03,3.47641e+03,3.47085e+03,1.23027e-03,
3.29545e+03,3.28993e+03,1.25890e-03,3.12349e+03,3.11800e+03,1.25892e-03,3.12334e+03,3.11786e+03,1.26970e-03,3.06193e+03,
3.05646e+03,1.27350e-03,3.04069e+03,3.03523e+03,1.28825e-03,2.95988e+03,2.95444e+03,1.30317e-03,2.88126e+03,2.87584e+03,
1.31826e-03,2.80454e+03,2.79915e+03,1.33352e-03,2.72985e+03,2.72447e+03,1.34896e-03,2.65681e+03,2.65146e+03,1.36458e-03,
2.58583e+03,2.58050e+03,1.40557e-03,2.41112e+03,2.40585e+03,1.41254e-03,2.38309e+03,2.37783e+03,1.42889e-03,2.31890e+03,
2.31367e+03,1.44544e-03,2.25630e+03,2.25110e+03,1.47911e-03,2.13632e+03,2.13117e+03,1.51356e-03,2.02249e+03,2.01740e+03,
1.53109e-03,1.96799e+03,1.96292e+03,1.54882e-03,1.91468e+03,1.90963e+03,1.55776e-03,1.88836e+03,1.88333e+03,1.58489e-03,
1.81157e+03,1.80658e+03,1.58490e-03,1.81155e+03,1.80657e+03,1.62181e-03,1.71392e+03,1.70899e+03,1.62649e-03,1.70210e+03,
1.69718e+03,1.64059e-03,1.66713e+03,1.66223e+03,1.65959e-03,1.62169e+03,1.61682e+03,1.69824e-03,1.53431e+03,1.52949e+03,
1.71051e-03,1.50786e+03,1.50307e+03,1.71791e-03,1.49222e+03,1.48744e+03,1.73780e-03,1.45105e+03,1.44631e+03,1.75792e-03,
1.41093e+03,1.40621e+03,1.77828e-03,1.37196e+03,1.36728e+03,1.79520e-03,1.34074e+03,1.33609e+03,1.81970e-03,1.29726e+03,
1.29265e+03,1.85000e-03,1.24628e+03,1.24172e+03,1.88205e-03,1.19535e+03,1.19084e+03,1.90546e-03,1.15999e+03,1.15552e+03,
1.94984e-03,1.09621e+03,1.09182e+03,1.95000e-03,1.09600e+03,1.09160e+03,1.97048e-03,1.06818e+03,1.06381e+03,1.97242e-03,
1.06559e+03,1.06123e+03,1.99526e-03,1.03588e+03,1.03156e+03,1.99530e-03,1.03583e+03,1.03151e+03,2.01837e-03,1.00699e+03,
1.00272e+03,2.04174e-03,9.78980e+02,9.74750e+02,2.05817e-03,9.59903e+02,9.55702e+02,2.07000e-03,9.46483e+02,9.42305e+02,
2.11349e-03,8.99301e+02,8.95210e+02,2.13796e-03,8.74061e+02,8.70017e+02,2.13950e-03,8.72509e+02,8.68467e+02,2.15000e-03,
8.62015e+02,8.57996e+02,2.16272e-03,8.49438e+02,8.45446e+02,2.20324e-03,8.11138e+02,8.07228e+02,2.23872e-03,7.79555e+02,
7.75725e+02,2.26318e-03,7.58852e+02,7.55075e+02,2.29087e-03,7.36332e+02,7.32623e+02,2.32240e-03,7.11856e+02,7.08221e+02,
2.34423e-03,6.95572e+02,6.91995e+02,2.36344e-03,6.81536e+02,6.78009e+02,2.37137e-03,6.75854e+02,6.72352e+02,2.39883e-03,
6.56643e+02,6.53220e+02,2.40000e-03,6.55843e+02,6.52424e+02,2.40932e-03,6.49474e+02,6.46081e+02,2.45137e-03,6.21776e+02,
6.18520e+02,2.48313e-03,6.01918e+02,5.98778e+02,2.48484e-03,6.00882e+02,5.97748e+02,2.51176e-03,5.84827e+02,5.81802e+02,
2.51189e-03,5.84752e+02,5.81728e+02,2.51190e-03,5.84744e+02,5.81720e+02,2.53712e-03,5.70227e+02,5.67320e+02,2.56088e-03,
5.56986e+02,5.54206e+02,2.57040e-03,5.51790e+02,5.49071e+02,2.57999e-03,5.46633e+02,5.43974e+02,2.59526e-03,5.38547e+02,
5.36000e+02,2.60701e-03,5.32421e+02,5.29973e+02,2.62015e-03,5.25677e+02,5.23347e+02,2.63027e-03,5.20563e+02,5.18323e+02,
2.63707e-03,5.17136e+02,5.14956e+02,2.64657e-03,5.12411e+02,5.10298e+02,2.65310e-03,5.09212e+02,5.07133e+02,2.65919e-03,
5.06264e+02,5.04206e+02,2.66073e-03,5.05527e+02,5.03471e+02,2.66534e-03,5.03304e+02,5.01255e+02,2.67189e-03,5.00190e+02,
4.98136e+02,2.67760e-03,4.97508e+02,4.95437e+02,2.67760e-03,1.76709e+03,1.71917e+03,2.67821e-03,1.76606e+03,1.71818e+03,
2.68492e-03,1.75484e+03,1.70733e+03,2.69154e-03,1.74389e+03,1.69673e+03,2.69470e-03,1.73868e+03,1.69169e+03,2.71771e-03,
1.70154e+03,1.65569e+03,2.72461e-03,1.69061e+03,1.64510e+03,2.73300e-03,1.67745e+03,1.63234e+03,2.73577e-03,1.67334e+03,
1.62836e+03,2.74514e-03,1.65956e+03,1.61502e+03,2.77426e-03,1.61774e+03,1.57453e+03,2.78612e-03,1.60114e+03,1.55844e+03,
2.79209e-03,1.59254e+03,1.55010e+03,2.79790e-03,1.58423e+03,1.54203e+03,2.79790e-03,2.19045e+03,2.12391e+03,2.81310e-03,
2.16037e+03,2.09493e+03,2.81838e-03,2.15006e+03,2.08499e+03,2.83131e-03,2.12510e+03,2.06093e+03,2.84363e-03,2.10171e+03,
2.03837e+03,2.85102e-03,2.08784e+03,2.02500e+03,2.85364e-03,2.08295e+03,2.02028e+03,2.87053e-03,2.05181e+03,1.99027e+03,
2.88403e-03,2.02736e+03,1.96672e+03,2.88547e-03,2.02478e+03,1.96423e+03,2.90347e-03,1.99285e+03,1.93348e+03,2.91743e-03,
1.96857e+03,1.91010e+03,2.92170e-03,1.96138e+03,1.90318e+03,2.93828e-03,1.93381e+03,1.87665e+03,2.95121e-03,1.91267e+03,
1.85631e+03,2.98391e-03,1.86143e+03,1.80700e+03,2.98538e-03,1.85916e+03,1.80482e+03,2.99512e-03,1.84429e+03,1.79051e+03,
3.00000e-03,1.83690e+03,1.78339e+03,3.00780e-03,1.82489e+03,1.77181e+03,3.01995e-03,1.80643e+03,1.75400e+03,3.02000e-03,
1.80635e+03,1.75393e+03,3.02240e-03,1.80267e+03,1.75037e+03,3.02240e-03,2.06707e+03,2.00609e+03,3.02714e-03,2.05919e+03,
1.99850e+03,3.04400e-03,2.03148e+03,1.97179e+03,3.07400e-03,1.98353e+03,1.92553e+03,3.08848e-03,1.96096e+03,1.90375e+03,
3.10335e-03,1.93814e+03,1.88175e+03,3.12255e-03,1.90921e+03,1.85386e+03,3.14573e-03,1.87509e+03,1.82095e+03,3.16228e-03,
1.85124e+03,1.79796e+03,3.16230e-03,1.85121e+03,1.79793e+03,3.17770e-03,1.82945e+03,1.77695e+03,3.19889e-03,1.80006e+03,
1.74862e+03,3.23000e-03,1.75746e+03,1.70752e+03,3.23594e-03,1.74946e+03,1.69981e+03,3.24151e-03,1.74193e+03,1.69253e+03,
3.30000e-03,1.66546e+03,1.61873e+03,3.31131e-03,1.65121e+03,1.60497e+03,3.31405e-03,1.64778e+03,1.60166e+03,3.34965e-03,
1.60415e+03,1.55954e+03,3.38802e-03,1.55891e+03,1.51583e+03,3.38844e-03,1.55841e+03,1.51536e+03,3.46737e-03,1.47091e+03,
1.43080e+03,3.47909e-03,1.45852e+03,1.41882e+03,3.50752e-03,1.42905e+03,1.39033e+03,3.54813e-03,1.38816e+03,1.35078e+03,
3.60197e-03,1.33621e+03,1.30052e+03,3.63078e-03,1.30951e+03,1.27467e+03,3.71535e-03,1.23498e+03,1.20250e+03,3.73088e-03,
1.22194e+03,1.18987e+03,3.75837e-03,1.19931e+03,1.16795e+03,3.84592e-03,1.13105e+03,1.10179e+03,3.87740e-03,1.10786e+03,
1.07931e+03,3.90000e-03,1.09161e+03,1.06355e+03,3.93550e-03,1.06669e+03,1.03938e+03,3.98107e-03,1.03584e+03,1.00945e+03,
3.98110e-03,1.03582e+03,1.00944e+03,4.02717e-03,1.00589e+03,9.80388e+02,4.04514e-03,9.94563e+02,9.69389e+02,4.12097e-03,
9.48649e+02,9.24813e+02,4.21696e-03,8.94741e+02,8.72448e+02,4.26579e-03,8.68924e+02,8.47358e+02,4.30000e-03,8.51461e+02,
8.30383e+02,4.34852e-03,8.27275e+02,8.06864e+02,4.36516e-03,8.19202e+02,7.99014e+02,4.41570e-03,7.95243e+02,7.75712e+02,
4.46684e-03,7.72038e+02,7.53140e+02,4.50000e-03,7.57499e+02,7.38994e+02,4.62381e-03,7.06512e+02,6.89366e+02,4.67735e-03,
6.85957e+02,6.69349e+02,4.73151e-03,6.65898e+02,6.49814e+02,4.80000e-03,6.41691e+02,6.26233e+02,4.84172e-03,6.27465e+02,
6.12370e+02,4.90000e-03,6.08329e+02,5.93718e+02,4.95450e-03,5.91037e+02,5.76860e+02,5.01187e-03,5.73576e+02,5.59832e+02,
5.01190e-03,5.73568e+02,5.59824e+02,5.03896e-03,5.65589e+02,5.52041e+02,5.12861e-03,5.40226e+02,5.27305e+02,5.30884e-03,
4.93892e+02,4.82092e+02,5.43250e-03,4.65190e+02,4.54069e+02,5.49146e-03,4.52146e+02,4.41329e+02,5.62341e-03,4.24723e+02,
4.14543e+02,5.75440e-03,3.99603e+02,3.89996e+02,6.00000e-03,3.57845e+02,3.49172e+02,6.02560e-03,3.53851e+02,3.45265e+02,
6.04975e-03,3.50139e+02,3.41635e+02,6.09537e-03,3.43275e+02,3.34922e+02,6.16595e-03,3.33022e+02,3.24896e+02,6.30957e-03,
3.13435e+02,3.05736e+02,6.30960e-03,3.13432e+02,3.05733e+02,6.38263e-03,3.04029e+02,2.96533e+02,6.45654e-03,2.94907e+02,
2.87606e+02,6.50000e-03,2.89690e+02,2.82501e+02,6.69066e-03,2.68283e+02,2.61545e+02,6.76083e-03,2.60952e+02,2.54369e+02,
6.80000e-03,2.56971e+02,2.50472e+02,6.83912e-03,2.53077e+02,2.46661e+02,6.91831e-03,2.45444e+02,2.39187e+02,7.00000e-03,
2.37905e+02,2.31805e+02,7.16143e-03,2.23869e+02,2.18060e+02,7.24436e-03,2.17057e+02,2.11387e+02,7.32824e-03,2.10459e+02,
2.04924e+02,7.49726e-03,1.97995e+02,1.92713e+02,7.50000e-03,1.97802e+02,1.92524e+02,7.67362e-03,1.86018e+02,1.80981e+02,
7.76247e-03,1.80364e+02,1.75443e+02,7.94328e-03,1.69586e+02,1.64884e+02,7.94330e-03,1.69585e+02,1.64883e+02,8.00000e-03,
1.66388e+02,1.61751e+02,8.03526e-03,1.64445e+02,1.59847e+02,8.12830e-03,1.59462e+02,1.54965e+02,8.22243e-03,1.54600e+02,
1.50201e+02,8.41395e-03,1.45332e+02,1.41119e+02,8.47968e-03,1.42333e+02,1.38180e+02,8.60994e-03,1.36634e+02,1.32598e+02,
8.70964e-03,1.32457e+02,1.28506e+02,8.81049e-03,1.28410e+02,1.24541e+02,8.91251e-03,1.24487e+02,1.20698e+02,9.01571e-03,
1.20672e+02,1.16960e+02,9.22571e-03,1.13401e+02,1.09837e+02,9.33254e-03,1.09934e+02,1.06441e+02,9.36281e-03,1.08975e+02,
1.05501e+02,9.44061e-03,1.06560e+02,1.03136e+02,9.66051e-03,1.00129e+02,9.68388e+01,9.88553e-03,9.40986e+01,9.09349e+01,
1.00000e-02,9.12248e+01,8.81214e+01,1.00443e-02,9.01462e+01,8.70655e+01,1.01158e-02,8.84410e+01,8.53971e+01,1.02329e-02,
8.57289e+01,8.27435e+01,1.04713e-02,8.05567e+01,7.76834e+01,1.05925e-02,7.80745e+01,7.52552e+01,1.07152e-02,7.56716e+01,
7.29046e+01,1.08812e-02,7.25731e+01,6.98739e+01,1.10918e-02,6.88868e+01,6.62711e+01,1.12202e-02,6.67673e+01,6.42000e+01,
1.13501e-02,6.47142e+01,6.21940e+01,1.16145e-02,6.08023e+01,5.83727e+01,1.17348e-02,5.91250e+01,5.67343e+01,1.20226e-02,
5.53613e+01,5.30619e+01,1.21000e-02,5.44068e+01,5.21307e+01,1.21619e-02,5.36595e+01,5.14017e+01,1.23027e-02,5.20113e+01,
4.97941e+01,1.24451e-02,5.04034e+01,4.82258e+01,1.25890e-02,4.88467e+01,4.67076e+01,1.25892e-02,4.88440e+01,4.67051e+01,
1.26984e-02,4.77064e+01,4.55959e+01,1.27350e-02,4.73329e+01,4.52321e+01,1.28825e-02,4.58697e+01,4.38073e+01,1.30317e-02,
4.44529e+01,4.24278e+01,1.35000e-02,4.03836e+01,3.84676e+01,1.36838e-02,3.89234e+01,3.70471e+01,1.39637e-02,3.68355e+01,
3.50185e+01,1.40000e-02,3.65760e+01,3.47665e+01,1.41254e-02,3.56991e+01,3.39147e+01,1.42479e-02,3.48707e+01,3.31102e+01,
1.42889e-02,3.45987e+01,3.28464e+01,1.46218e-02,3.24818e+01,3.07934e+01,1.47911e-02,3.14743e+01,2.98168e+01,1.50000e-02,
3.02907e+01,2.86698e+01,1.53109e-02,2.86414e+01,2.70722e+01,1.54019e-02,2.81827e+01,2.66280e+01,1.58000e-02,2.62895e+01,
2.47979e+01,1.58489e-02,2.60685e+01,2.45843e+01,1.58490e-02,2.60681e+01,2.45840e+01,1.60029e-02,2.53893e+01,2.39282e+01,
1.60324e-02,2.52617e+01,2.38051e+01,1.62181e-02,2.44793e+01,2.30507e+01,1.64059e-02,2.37173e+01,2.23159e+01,1.65959e-02,
2.29790e+01,2.16043e+01,1.67880e-02,2.22646e+01,2.09160e+01,1.70318e-02,2.14008e+01,2.00840e+01,1.71791e-02,2.08999e+01,
1.96028e+01,1.73780e-02,2.02493e+01,1.89781e+01,1.78935e-02,1.86900e+01,1.74818e+01,1.79887e-02,1.84194e+01,1.72231e+01,
1.84077e-02,1.72926e+01,1.61462e+01,1.85500e-02,1.69305e+01,1.58002e+01,1.86209e-02,1.67533e+01,1.56316e+01,1.88365e-02,
1.62262e+01,1.51300e+01,1.90546e-02,1.57162e+01,1.46449e+01,1.90787e-02,1.56613e+01,1.45927e+01,1.94732e-02,1.47930e+01,
1.37712e+01,1.94985e-02,1.47393e+01,1.37207e+01,1.97242e-02,1.42714e+01,1.32812e+01,1.98133e-02,1.40925e+01,1.31132e+01,
1.99526e-02,1.38162e+01,1.28562e+01,1.99530e-02,1.38155e+01,1.28555e+01,2.00000e-02,1.37239e+01,1.27703e+01,2.00605e-02,
1.36072e+01,1.26617e+01,2.01797e-02,1.33787e+01,1.24512e+01,2.01837e-02,1.33711e+01,1.24443e+01,2.02868e-02,1.31758e+01,
1.22661e+01,2.03771e-02,1.30061e+01,1.21131e+01,2.04174e-02,1.29300e+01,1.20456e+01,2.05112e-02,1.27553e+01,1.18906e+01,
2.06733e-02,1.24548e+01,1.16292e+01,2.08040e-02,1.22200e+01,1.14241e+01,2.08859e-02,1.20803e+01,1.12980e+01,2.09437e-02,
1.19866e+01,1.12101e+01,2.09925e-02,1.19110e+01,1.11367e+01,2.10120e-02,1.18821e+01,1.11075e+01,2.10120e-02,7.42012e+01,
2.99379e+01,2.10476e-02,7.39217e+01,2.98941e+01,2.10966e-02,7.35412e+01,2.98333e+01,2.11600e-02,7.30575e+01,2.97545e+01,
2.11666e-02,7.30074e+01,2.97462e+01,2.12000e-02,7.27563e+01,2.97045e+01,2.13002e-02,7.19537e+01,2.95548e+01,2.14253e-02,
7.09716e+01,2.93672e+01,2.15000e-02,7.03922e+01,2.92548e+01,2.15299e-02,7.01291e+01,2.91958e+01,2.16077e-02,6.94495e+01,
2.90426e+01,2.16272e-02,6.92803e+01,2.90043e+01,2.16769e-02,6.88508e+01,2.89063e+01,2.17652e-02,6.80940e+01,2.87323e+01,
2.18621e-02,6.72753e+01,2.85418e+01,2.19000e-02,6.69583e+01,2.84675e+01,2.20686e-02,6.57009e+01,2.81938e+01,2.21309e-02,
6.52433e+01,2.80926e+01,2.23298e-02,6.38141e+01,2.77703e+01,2.23872e-02,6.34087e+01,2.76773e+01,2.26464e-02,6.16239e+01,
2.72585e+01,2.26577e-02,6.15436e+01,2.72385e+01,2.29735e-02,5.93531e+01,2.66803e+01,2.34423e-02,5.62929e+01,2.58646e+01,
2.35818e-02,5.54249e+01,2.56252e+01,2.37137e-02,5.46202e+01,2.54004e+01,2.39883e-02,5.29968e+01,2.49373e+01,2.40000e-02,
5.29293e+01,2.49178e+01,2.42509e-02,5.15062e+01,2.45007e+01,2.42661e-02,5.14218e+01,2.44757e+01,2.45471e-02,4.99175e+01,
2.40282e+01,2.48313e-02,4.84577e+01,2.35828e+01,2.51189e-02,4.70412e+01,2.31448e+01,2.51190e-02,4.70405e+01,2.31446e+01,
2.52702e-02,4.63188e+01,2.29173e+01,2.54097e-02,4.56659e+01,2.27093e+01,2.57040e-02,4.43290e+01,2.22757e+01,2.60016e-02,
4.30312e+01,2.18450e+01,2.63027e-02,4.17720e+01,2.14179e+01,2.63988e-02,4.13809e+01,2.12833e+01,2.70000e-02,3.90450e+01,
2.04613e+01,2.72270e-02,3.81873e+01,2.01471e+01,2.78612e-02,3.59255e+01,1.92972e+01,2.78837e-02,3.58488e+01,1.92678e+01,
2.88403e-02,3.27824e+01,1.80642e+01,2.91743e-02,3.17977e+01,1.76648e+01,2.95121e-02,3.08428e+01,1.72712e+01,2.98538e-02,
2.99169e+01,1.68837e+01,3.01513e-02,2.91412e+01,1.65544e+01,3.05492e-02,2.81459e+01,1.61259e+01,3.09030e-02,2.73001e+01,
1.57561e+01,3.16228e-02,2.56849e+01,1.50353e+01,3.16230e-02,2.56844e+01,1.50351e+01,3.23000e-02,2.42838e+01,1.43942e+01,
3.27341e-02,2.34255e+01,1.39916e+01,3.31131e-02,2.27101e+01,1.36537e+01,3.32099e-02,2.25323e+01,1.35690e+01,3.42768e-02,
2.06928e+01,1.26786e+01,3.46737e-02,2.00614e+01,1.23664e+01,3.58922e-02,1.82804e+01,1.14661e+01,3.63078e-02,1.77230e+01,
1.11784e+01,3.65306e-02,1.74339e+01,1.10279e+01,3.71535e-02,1.66587e+01,1.06210e+01,3.80189e-02,1.56589e+01,1.00872e+01,
3.89045e-02,1.47200e+01,9.57675e+00,3.98107e-02,1.38384e+01,9.08892e+00,3.98110e-02,1.38382e+01,9.08877e+00,4.02717e-02,
1.34178e+01,8.85326e+00,4.03400e-02,1.33558e+01,8.81821e+00,4.07380e-02,1.30021e+01,8.61759e+00,4.12097e-02,1.25995e+01,
8.38753e+00,4.31519e-02,1.11118e+01,7.52118e+00,4.41570e-02,1.04362e+01,7.11894e+00,4.44596e-02,1.02441e+01,7.00349e+00,
4.51856e-02,9.80237e+00,6.73636e+00,4.57088e-02,9.50023e+00,6.55217e+00,4.62381e-02,9.20755e+00,6.37256e+00,4.73151e-02,
8.64954e+00,6.02684e+00,4.84172e-02,8.12552e+00,5.69807e+00,5.01187e-02,7.39974e+00,5.23697e+00,5.01190e-02,7.39963e+00,
5.23689e+00,5.01668e-02,7.38025e+00,5.22444e+00,5.12861e-02,6.94587e+00,4.94408e+00,5.30884e-02,6.31785e+00,4.53331e+00,
5.43250e-02,5.93189e+00,4.27754e+00,5.49541e-02,5.74811e+00,4.15483e+00,5.52548e-02,5.66306e+00,4.09784e+00,5.62341e-02,
5.39772e+00,3.91933e+00,5.75440e-02,5.06892e+00,3.69626e+00,5.82103e-02,4.91235e+00,3.58930e+00,6.02560e-02,4.47199e+00,
3.28586e+00,6.09537e-02,4.33444e+00,3.19026e+00,6.14027e-02,4.24905e+00,3.13070e+00,6.23735e-02,4.07221e+00,3.00695e+00,
6.30957e-02,3.94579e+00,2.91792e+00,6.30960e-02,3.94574e+00,2.91789e+00,6.53131e-02,3.59019e+00,2.66588e+00,6.60693e-02,
3.47922e+00,2.58664e+00,6.68344e-02,3.37183e+00,2.50967e+00,6.83912e-02,3.16711e+00,2.36218e+00,6.99842e-02,2.97538e+00,
2.22310e+00,7.16143e-02,2.79580e+00,2.09200e+00,7.32825e-02,2.62762e+00,1.96844e+00,7.58578e-02,2.39507e+00,1.79631e+00,
7.76247e-02,2.25225e+00,1.68984e+00,7.94328e-02,2.11718e+00,1.58849e+00,7.94330e-02,2.11717e+00,1.58848e+00,8.00000e-02,
2.07716e+00,1.55842e+00,8.12830e-02,1.99056e+00,1.49318e+00,8.27696e-02,1.89652e+00,1.42212e+00,8.31764e-02,1.87189e+00,
1.40348e+00,9.00000e-02,1.51980e+00,1.13482e+00,9.01571e-02,1.51287e+00,1.12949e+00,9.22571e-02,1.42458e+00,1.06145e+00,
9.33254e-02,1.38256e+00,1.02898e+00,9.88553e-02,1.19200e+00,8.80913e-01,1.00000e-01,1.15724e+00,8.53739e-01,1.01158e-01,
1.12352e+00,8.27438e-01,1.03514e-01,1.05929e+00,7.77216e-01,1.04713e-01,1.02873e+00,7.53270e-01,1.07152e-01,9.70553e-01,
7.07595e-01,1.08393e-01,9.42868e-01,6.85822e-01,1.09648e-01,9.16081e-01,6.64729e-01,1.10918e-01,8.90159e-01,6.44294e-01,
1.11127e-01,8.85985e-01,6.41001e-01,1.12202e-01,8.65050e-01,6.24496e-01,1.18850e-01,7.51141e-01,5.34439e-01,1.25890e-01,
6.54474e-01,4.57698e-01,1.25893e-01,6.54443e-01,4.57673e-01,1.27350e-01,6.36870e-01,4.43778e-01,1.28825e-01,6.19859e-01,
4.30322e-01,1.30317e-01,6.03394e-01,4.17292e-01,1.31826e-01,5.87456e-01,4.04675e-01,1.34896e-01,5.57092e-01,3.80628e-01,
1.35259e-01,5.53674e-01,3.77920e-01,1.38038e-01,5.28593e-01,3.58073e-01,1.41254e-01,5.01878e-01,3.36930e-01,1.46218e-01,
4.64910e-01,3.07672e-01,1.47911e-01,4.53362e-01,2.98533e-01,1.49624e-01,4.42178e-01,2.89685e-01,1.53109e-01,4.20863e-01,
2.72827e-01,1.54882e-01,4.10708e-01,2.64799e-01,1.56675e-01,4.00874e-01,2.57028e-01,1.58489e-01,3.91373e-01,2.49526e-01,
1.58490e-01,3.91369e-01,2.49523e-01,1.64059e-01,3.64421e-01,2.28502e-01,1.67880e-01,3.47824e-01,2.15583e-01,1.69272e-01,
3.42125e-01,2.11153e-01,1.75792e-01,3.17572e-01,1.92131e-01,1.81970e-01,2.97242e-01,1.76437e-01,1.84077e-01,2.90878e-01,
1.71537e-01,1.86209e-01,2.84709e-01,1.66795e-01,1.90546e-01,2.72932e-01,1.57760e-01,1.92752e-01,2.67313e-01,1.53460e-01,
1.97242e-01,2.56586e-01,1.45272e-01,1.99526e-01,2.51466e-01,1.41375e-01,1.99530e-01,2.51458e-01,1.41368e-01,2.04174e-01,
2.41583e-01,1.34008e-01,2.06538e-01,2.36862e-01,1.30500e-01,2.08930e-01,2.32321e-01,1.27142e-01,2.11349e-01,2.27913e-01,
1.23890e-01,2.12159e-01,2.26478e-01,1.22833e-01,2.13796e-01,2.23631e-01,1.20742e-01,2.18776e-01,2.15435e-01,1.14741e-01,
2.21309e-01,2.11516e-01,1.11883e-01,2.23872e-01,2.07712e-01,1.09116e-01,2.26464e-01,2.04018e-01,1.06437e-01,2.29087e-01,
2.00431e-01,1.03843e-01,2.29910e-01,1.99335e-01,1.03052e-01,2.34423e-01,1.93565e-01,9.88995e-02,2.37137e-01,1.90280e-01,
9.65446e-02,2.39883e-01,1.87088e-01,9.42644e-02,2.45471e-01,1.80976e-01,8.99183e-02,2.48313e-01,1.78053e-01,8.78508e-02,
2.51189e-01,1.75242e-01,8.58768e-02,2.51190e-01,1.75241e-01,8.58759e-02,2.63027e-01,1.64596e-01,7.86861e-02,2.66073e-01,
1.62113e-01,7.70260e-02,2.66732e-01,1.61588e-01,7.66759e-02,2.69154e-01,1.59697e-01,7.54179e-02,2.72270e-01,1.57346e-01,
7.38598e-02,2.75423e-01,1.55059e-01,7.23502e-02,2.78612e-01,1.52832e-01,7.08877e-02,2.88403e-01,1.46500e-01,6.67659e-02,
2.89519e-01,1.45824e-01,6.63296e-02,2.90000e-01,1.45535e-01,6.61432e-02,2.91743e-01,1.44511e-01,6.54889e-02,2.95121e-01,
1.42583e-01,6.42607e-02,2.98538e-01,1.40704e-01,6.30695e-02,3.00000e-01,1.39922e-01,6.25751e-02,3.01995e-01,1.38873e-01,
6.19144e-02,3.05492e-01,1.37088e-01,6.07939e-02,3.12608e-01,1.33652e-01,5.86532e-02,3.16228e-01,1.31999e-01,5.76310e-02,
3.16230e-01,1.31998e-01,5.76304e-02,3.23594e-01,1.28747e-01,5.57292e-02,3.27341e-01,1.27179e-01,5.48207e-02,3.31131e-01,
1.25650e-01,5.39393e-02,3.34965e-01,1.24157e-01,5.30841e-02,3.38844e-01,1.22718e-01,5.22716e-02,3.50752e-01,1.18597e-01,
4.99727e-02,3.54813e-01,1.17286e-01,4.92500e-02,3.58922e-01,1.16004e-01,4.85480e-02,3.63078e-01,1.14752e-01,4.78662e-02,
3.67282e-01,1.13527e-01,4.72039e-02,3.71535e-01,1.12330e-01,4.65603e-02,3.75837e-01,1.11159e-01,4.59349e-02,3.80189e-01,
1.10014e-01,4.53272e-02,3.84592e-01,1.08908e-01,4.47497e-02,3.93550e-01,1.06764e-01,4.36412e-02,3.98107e-01,1.05726e-01,
4.31093e-02,3.98110e-01,1.05725e-01,4.31090e-02,4.00000e-01,1.05293e-01,4.29041e-02,4.02717e-01,1.04681e-01,4.26153e-02,
4.07380e-01,1.03658e-01,4.21344e-02,4.12098e-01,1.02656e-01,4.16667e-02,4.16869e-01,1.01673e-01,4.12112e-02,4.21697e-01,
1.00710e-01,4.07678e-02,4.24131e-01,1.00236e-01,4.05505e-02,4.26580e-01,9.97656e-02,4.03361e-02,4.31519e-01,9.88485e-02,
3.99247e-02,4.36516e-01,9.79497e-02,3.95247e-02,4.41570e-01,9.70678e-02,3.91346e-02,4.46684e-01,9.62024e-02,3.87541e-02,
4.57088e-01,9.45194e-02,3.80211e-02,4.62381e-01,9.37010e-02,3.76680e-02,4.67735e-01,9.28975e-02,3.73234e-02,4.73151e-01,
9.21083e-02,3.69871e-02,4.78630e-01,9.13407e-02,3.66660e-02,4.84172e-01,9.05863e-02,3.63522e-02,4.89779e-01,8.98455e-02,
3.60462e-02,5.01187e-01,8.84014e-02,3.54546e-02,5.01190e-01,8.84011e-02,3.54545e-02,5.06991e-01,8.76736e-02,3.51892e-02,
5.12861e-01,8.69578e-02,3.49295e-02,5.18800e-01,8.62535e-02,3.46753e-02,5.24808e-01,8.55606e-02,3.44264e-02,5.30884e-01,
8.48846e-02,3.41884e-02,5.37032e-01,8.42189e-02,3.39550e-02,5.62341e-01,8.16579e-02,3.30673e-02,5.68853e-01,8.10414e-02,
3.28556e-02,5.75440e-01,8.04338e-02,3.26477e-02,5.82103e-01,7.98350e-02,3.24435e-02,5.88844e-01,7.92496e-02,3.22476e-02,
5.95662e-01,7.86723e-02,3.20549e-02,6.09537e-01,7.75424e-02,3.16797e-02,6.23735e-01,7.64428e-02,3.13161e-02,6.30957e-01,
7.59040e-02,3.11385e-02,6.30960e-01,7.59038e-02,3.11384e-02,6.38264e-01,7.53510e-02,3.09797e-02,6.38831e-01,7.53090e-02,
3.09679e-02,6.45654e-01,7.48087e-02,3.08268e-02,6.60694e-01,7.37442e-02,3.05264e-02,6.62370e-01,7.36287e-02,3.04938e-02,
6.76083e-01,7.27067e-02,3.02336e-02,6.83912e-01,7.21974e-02,3.00896e-02,6.91831e-01,7.16942e-02,2.99471e-02,6.99842e-01,
7.11971e-02,2.98062e-02,7.07946e-01,7.07059e-02,2.96667e-02,7.16143e-01,7.02237e-02,2.95318e-02,7.32825e-01,6.92757e-02,
2.92656e-02,7.41310e-01,6.88099e-02,2.91344e-02,7.49894e-01,6.83493e-02,2.90043e-02,7.58578e-01,6.78938e-02,2.88753e-02,
7.67362e-01,6.74433e-02,2.87473e-02,7.76247e-01,6.69977e-02,2.86203e-02,7.85236e-01,6.65569e-02,2.84943e-02,7.94328e-01,
6.61232e-02,2.83716e-02,7.94330e-01,6.61231e-02,2.83716e-02,8.03526e-01,6.56761e-02,2.82646e-02,8.12831e-01,6.52337e-02,
2.81579e-02,8.22243e-01,6.47959e-02,2.80518e-02,8.31764e-01,6.43627e-02,2.79459e-02,8.41395e-01,6.39337e-02,2.78403e-02,
8.51138e-01,6.35091e-02,2.77349e-02,8.60994e-01,6.30888e-02,2.76298e-02,8.70964e-01,6.26726e-02,2.75250e-02,9.01571e-01,
6.14544e-02,2.72180e-02,9.12011e-01,6.10560e-02,2.71159e-02,9.22571e-01,6.06614e-02,2.70139e-02,9.33254e-01,6.02706e-02,
2.69123e-02,9.44061e-01,5.98834e-02,2.68108e-02,9.54993e-01,5.94998e-02,2.67094e-02,9.66051e-01,5.91216e-02,2.66099e-02,
9.77237e-01,5.87467e-02,2.65105e-02,9.88553e-01,5.83751e-02,2.64111e-02,1.00000e+00,5.80068e-02,2.63118e-02,1.00000e-03,
5.68060e+03,5.67445e+03,1.01158e-03,5.53565e+03,5.52952e+03,1.02329e-03,5.39460e+03,5.38847e+03,1.02643e-03,5.35743e+03,
5.35131e+03,1.03000e-03,5.31566e+03,5.30954e+03,1.05925e-03,4.99074e+03,4.98467e+03,1.07152e-03,4.86243e+03,4.85637e+03,
1.09648e-03,4.61482e+03,4.60879e+03,1.10599e-03,4.52544e+03,4.51942e+03,1.10918e-03,4.49603e+03,4.49002e+03,1.11000e-03,
4.48841e+03,4.48240e+03,1.15000e-03,4.13772e+03,4.13178e+03,1.16145e-03,4.04449e+03,4.03857e+03,1.18850e-03,3.83617e+03,
3.83028e+03,1.19000e-03,3.82510e+03,3.81922e+03,1.21619e-03,3.63816e+03,3.63231e+03,1.23027e-03,3.54260e+03,3.53677e+03,
1.25052e-03,3.41068e+03,3.40488e+03,1.25890e-03,3.35813e+03,3.35234e+03,1.25892e-03,3.35797e+03,3.35219e+03,1.27350e-03,
3.26930e+03,3.26353e+03,1.28825e-03,3.18277e+03,3.17703e+03,1.30000e-03,3.11623e+03,3.11050e+03,1.30317e-03,3.09863e+03,
3.09291e+03,1.34896e-03,2.85858e+03,2.85293e+03,1.35000e-03,2.85347e+03,2.84781e+03,1.36458e-03,2.78242e+03,2.77678e+03,
1.38038e-03,2.70776e+03,2.70214e+03,1.38436e-03,2.68945e+03,2.68384e+03,1.40000e-03,2.61916e+03,2.61357e+03,1.41254e-03,
2.56453e+03,2.55896e+03,1.45000e-03,2.41075e+03,2.40523e+03,1.46218e-03,2.36368e+03,2.35818e+03,1.47911e-03,2.30015e+03,
2.29468e+03,1.49624e-03,2.23794e+03,2.23249e+03,1.51356e-03,2.17748e+03,2.17207e+03,1.53109e-03,2.11833e+03,2.11294e+03,
1.58210e-03,1.95874e+03,1.95342e+03,1.58489e-03,1.95048e+03,1.94517e+03,1.58490e-03,1.95046e+03,1.94515e+03,1.60325e-03,
1.89755e+03,1.89226e+03,1.62181e-03,1.84602e+03,1.84076e+03,1.65000e-03,1.77162e+03,1.76641e+03,1.65959e-03,1.74714e+03,
1.74194e+03,1.66269e-03,1.73930e+03,1.73411e+03,1.67880e-03,1.69942e+03,1.69424e+03,1.69824e-03,1.65270e+03,1.64755e+03,
1.74608e-03,1.54522e+03,1.54014e+03,1.77828e-03,1.47835e+03,1.47333e+03,1.80000e-03,1.43570e+03,1.43071e+03,1.81970e-03,
1.39840e+03,1.39344e+03,1.83069e-03,1.37806e+03,1.37312e+03,1.84077e-03,1.35977e+03,1.35485e+03,1.86209e-03,1.32226e+03,
1.31737e+03,1.88365e-03,1.28568e+03,1.28082e+03,1.90546e-03,1.24996e+03,1.24514e+03,1.92371e-03,1.22118e+03,1.21639e+03,
1.99526e-03,1.11690e+03,1.11223e+03,1.99530e-03,1.11685e+03,1.11217e+03,2.00000e-03,1.11045e+03,1.10578e+03,2.01414e-03,
1.09149e+03,1.08685e+03,2.01837e-03,1.08592e+03,1.08129e+03,2.04174e-03,1.05562e+03,1.05102e+03,2.06538e-03,1.02619e+03,
1.02164e+03,2.08930e-03,9.97631e+02,9.93114e+02,2.11159e-03,9.71808e+02,9.67328e+02,2.11349e-03,9.69653e+02,9.65176e+02,
2.13796e-03,9.42491e+02,9.38059e+02,2.18776e-03,8.90467e+02,8.86122e+02,2.19916e-03,8.79133e+02,8.74808e+02,2.23872e-03,
8.41340e+02,8.37089e+02,2.27975e-03,8.04211e+02,8.00035e+02,2.29087e-03,7.94545e+02,7.90393e+02,2.30000e-03,7.86736e+02,
7.82602e+02,2.34423e-03,7.50307e+02,7.46262e+02,2.35347e-03,7.42967e+02,7.38941e+02,2.37137e-03,7.29035e+02,7.25049e+02,
2.39883e-03,7.08393e+02,7.04467e+02,2.41461e-03,6.96929e+02,6.93038e+02,2.47250e-03,6.57008e+02,6.53255e+02,2.50000e-03,
6.39153e+02,6.35472e+02,2.51189e-03,6.31608e+02,6.27958e+02,2.51190e-03,6.31600e+02,6.27949e+02,2.51992e-03,6.26584e+02,
6.22953e+02,2.54097e-03,6.13672e+02,6.10102e+02,2.56393e-03,5.99983e+02,5.96477e+02,2.57040e-03,5.96202e+02,5.92717e+02,
2.60016e-03,5.79112e+02,5.75720e+02,2.60404e-03,5.76939e+02,5.73558e+02,2.64130e-03,5.56615e+02,5.53366e+02,2.66073e-03,
5.46403e+02,5.43233e+02,2.66928e-03,5.41978e+02,5.38842e+02,2.69154e-03,5.30682e+02,5.27649e+02,2.69444e-03,5.29234e+02,
5.26214e+02,2.71683e-03,5.18246e+02,5.15344e+02,2.73562e-03,5.09248e+02,5.06460e+02,2.75192e-03,5.01602e+02,4.98930e+02,
2.76197e-03,4.96952e+02,4.94360e+02,2.77561e-03,4.90729e+02,4.88256e+02,2.79693e-03,4.81210e+02,4.78923e+02,2.80000e-03,
4.79863e+02,4.77598e+02,2.80695e-03,4.76820e+02,4.74605e+02,2.81432e-03,4.73637e+02,4.71460e+02,2.81838e-03,4.71904e+02,
4.69740e+02,2.82119e-03,4.70710e+02,4.68556e+02,2.82707e-03,4.68239e+02,4.66093e+02,2.83074e-03,4.66708e+02,4.64561e+02,
2.83783e-03,4.63787e+02,4.61627e+02,2.83870e-03,4.63433e+02,4.61269e+02,2.83870e-03,1.62422e+03,1.57654e+03,2.84290e-03,
1.61765e+03,1.57022e+03,2.84330e-03,1.62166e+03,1.57407e+03,2.84571e-03,1.61798e+03,1.57052e+03,2.85102e-03,1.60993e+03,
1.56275e+03,2.85112e-03,1.60978e+03,1.56261e+03,2.86003e-03,1.59639e+03,1.54968e+03,2.88041e-03,1.56635e+03,1.52064e+03,
2.88403e-03,1.56110e+03,1.51556e+03,2.88860e-03,1.55451e+03,1.50919e+03,2.89709e-03,1.54234e+03,1.49742e+03,2.90477e-03,
1.53145e+03,1.48690e+03,2.91333e-03,1.51943e+03,1.47530e+03,2.92932e-03,1.49729e+03,1.45394e+03,2.94628e-03,1.47429e+03,
1.43174e+03,2.96387e-03,1.45097e+03,1.40921e+03,2.97180e-03,1.44064e+03,1.39921e+03,2.97180e-03,1.97870e+03,1.91371e+03,
2.97703e-03,1.97030e+03,1.90564e+03,2.99000e-03,1.94970e+03,1.88585e+03,3.00000e-03,1.93532e+03,1.87203e+03,3.01500e-03,
1.91403e+03,1.85157e+03,3.01893e-03,1.90828e+03,1.84604e+03,3.01995e-03,1.90679e+03,1.84461e+03,3.03696e-03,1.88220e+03,
1.82096e+03,3.04764e-03,1.86699e+03,1.80635e+03,3.05492e-03,1.85670e+03,1.79647e+03,3.05886e-03,1.85092e+03,1.79091e+03,
3.07000e-03,1.83470e+03,1.77533e+03,3.07699e-03,1.82392e+03,1.76497e+03,3.09030e-03,1.80363e+03,1.74548e+03,3.09589e-03,
1.79519e+03,1.73738e+03,3.11529e-03,1.76634e+03,1.70970e+03,3.12000e-03,1.75943e+03,1.70307e+03,3.12608e-03,1.75095e+03,
1.69494e+03,3.14805e-03,1.72074e+03,1.66596e+03,3.16228e-03,1.70156e+03,1.64755e+03,3.16230e-03,1.70153e+03,1.64753e+03,
3.17459e-03,1.68521e+03,1.63187e+03,3.18000e-03,1.67810e+03,1.62503e+03,3.18843e-03,1.66681e+03,1.61419e+03,3.19889e-03,
1.65295e+03,1.60086e+03,3.20390e-03,1.64638e+03,1.59454e+03,3.20390e-03,1.88870e+03,1.82821e+03,3.20895e-03,1.88150e+03,
1.82129e+03,3.23594e-03,1.84374e+03,1.78500e+03,3.25952e-03,1.81162e+03,1.75411e+03,3.27341e-03,1.79308e+03,1.73628e+03,
3.27381e-03,1.79254e+03,1.73576e+03,3.29070e-03,1.77037e+03,1.71445e+03,3.30954e-03,1.74606e+03,1.69109e+03,3.31131e-03,
1.74381e+03,1.68892e+03,3.33347e-03,1.71525e+03,1.66147e+03,3.34965e-03,1.69481e+03,1.64182e+03,3.36026e-03,1.68161e+03,
1.62913e+03,3.38844e-03,1.64719e+03,1.59605e+03,3.42336e-03,1.60595e+03,1.55639e+03,3.45000e-03,1.57545e+03,1.52706e+03,
3.46737e-03,1.55596e+03,1.50831e+03,3.50074e-03,1.51907e+03,1.47281e+03,3.50752e-03,1.51172e+03,1.46574e+03,3.54813e-03,
1.46871e+03,1.42434e+03,3.58922e-03,1.42694e+03,1.38411e+03,3.63078e-03,1.38596e+03,1.34463e+03,3.67282e-03,1.34618e+03,
1.30630e+03,3.68685e-03,1.33328e+03,1.29386e+03,3.71535e-03,1.30757e+03,1.26908e+03,3.75837e-03,1.27009e+03,1.23293e+03,
3.78707e-03,1.24581e+03,1.20951e+03,3.84592e-03,1.19799e+03,1.16337e+03,3.90942e-03,1.14930e+03,1.11636e+03,3.93550e-03,
1.13011e+03,1.09783e+03,3.98107e-03,1.09738e+03,1.06621e+03,3.98110e-03,1.09736e+03,1.06619e+03,4.00000e-03,1.08418e+03,
1.05345e+03,4.02717e-03,1.06562e+03,1.03552e+03,4.07380e-03,1.03479e+03,1.00571e+03,4.07747e-03,1.03242e+03,1.00342e+03,
4.12097e-03,1.00485e+03,9.76770e+02,4.16869e-03,9.75810e+02,9.48677e+02,4.21696e-03,9.47600e+02,9.21381e+02,4.29299e-03,
9.05419e+02,8.80548e+02,4.31519e-03,8.93594e+02,8.69100e+02,4.36516e-03,8.67781e+02,8.44102e+02,4.41570e-03,8.42736e+02,
8.19841e+02,4.46684e-03,8.18401e+02,7.96258e+02,4.51856e-03,7.94601e+02,7.73186e+02,4.57226e-03,7.70909e+02,7.50211e+02,
4.62381e-03,7.49082e+02,7.29042e+02,4.67735e-03,7.27252e+02,7.07866e+02,4.73151e-03,7.06075e+02,6.87318e+02,4.89779e-03,
6.46265e+02,6.29248e+02,4.90000e-03,6.45519e+02,6.28522e+02,4.90368e-03,6.44266e+02,6.27306e+02,4.95450e-03,6.27321e+02,
6.10846e+02,5.01187e-03,6.08921e+02,5.92969e+02,5.01190e-03,6.08912e+02,5.92960e+02,5.06991e-03,5.90980e+02,5.75532e+02,
5.12861e-03,5.73574e+02,5.58609e+02,5.18800e-03,5.56698e+02,5.42199e+02,5.24807e-03,5.40332e+02,5.26280e+02,5.30741e-03,
5.24712e+02,5.11081e+02,5.30884e-03,5.24342e+02,5.10722e+02,5.37032e-03,5.08833e+02,4.95632e+02,5.55904e-03,4.65070e+02,
4.53032e+02,5.68853e-03,4.38031e+02,4.26696e+02,5.75440e-03,4.25082e+02,4.14079e+02,5.80000e-03,4.16426e+02,4.05643e+02,
5.81686e-03,4.13248e+02,4.02545e+02,5.82103e-03,4.12466e+02,4.01784e+02,5.88844e-03,4.00125e+02,3.89755e+02,6.00000e-03,
3.80813e+02,3.70929e+02,6.02560e-03,3.76537e+02,3.66759e+02,6.30957e-03,3.33319e+02,3.24600e+02,6.30960e-03,3.33315e+02,
3.24596e+02,6.38263e-03,3.23324e+02,3.14845e+02,6.42715e-03,3.17441e+02,3.09103e+02,6.53131e-03,3.04238e+02,2.96218e+02,
6.60693e-03,2.95136e+02,2.87333e+02,6.68344e-03,2.86314e+02,2.78720e+02,6.76083e-03,2.77765e+02,2.70373e+02,6.80000e-03,
2.73572e+02,2.66278e+02,6.83912e-03,2.69442e+02,2.62245e+02,6.91831e-03,2.61345e+02,2.54336e+02,7.16143e-03,2.38396e+02,
2.31913e+02,7.17497e-03,2.37202e+02,2.30746e+02,7.24436e-03,2.31206e+02,2.24888e+02,7.41310e-03,2.17429e+02,2.11425e+02,
7.49894e-03,2.10862e+02,2.05007e+02,7.50000e-03,2.10783e+02,2.04929e+02,7.58578e-03,2.04499e+02,1.98786e+02,7.67362e-03,
1.98333e+02,1.92759e+02,7.76247e-03,1.92296e+02,1.86856e+02,7.94328e-03,1.80785e+02,1.75600e+02,7.94330e-03,1.80784e+02,
1.75599e+02,8.01823e-03,1.76295e+02,1.71208e+02,8.03526e-03,1.75295e+02,1.70231e+02,8.12830e-03,1.69958e+02,1.65013e+02,
8.22243e-03,1.64782e+02,1.59952e+02,8.41395e-03,1.54910e+02,1.50298e+02,8.60994e-03,1.45651e+02,1.41243e+02,8.70964e-03,
1.41237e+02,1.36927e+02,8.81049e-03,1.36932e+02,1.32716e+02,9.12011e-03,1.24812e+02,1.20861e+02,9.14361e-03,1.23949e+02,
1.20016e+02,9.22571e-03,1.20994e+02,1.17127e+02,9.33254e-03,1.17292e+02,1.13507e+02,9.54993e-03,1.10227e+02,1.06598e+02,
9.77237e-03,1.03574e+02,1.00093e+02,1.00000e-02,9.73378e+01,9.39952e+01,1.00641e-02,9.56709e+01,9.23654e+01,1.03514e-02,
8.86606e+01,8.55149e+01,1.04713e-02,8.59492e+01,8.28656e+01,1.05925e-02,8.33211e+01,8.02977e+01,1.08393e-02,7.83099e+01,
7.54018e+01,1.08433e-02,7.82307e+01,7.53245e+01,1.09648e-02,7.59067e+01,7.30553e+01,1.12202e-02,7.13233e+01,6.85806e+01,
1.14815e-02,6.69984e+01,6.43586e+01,1.15000e-02,6.67069e+01,6.40741e+01,1.17437e-02,6.30095e+01,6.04653e+01,1.18850e-02,
6.09923e+01,5.84982e+01,1.20000e-02,5.94187e+01,5.69639e+01,1.21619e-02,5.72966e+01,5.48951e+01,1.25890e-02,5.21815e+01,
4.99098e+01,1.25892e-02,5.21787e+01,4.99071e+01,1.27160e-02,5.07796e+01,4.85439e+01,1.28825e-02,4.90167e+01,4.68281e+01,
1.31826e-02,4.60498e+01,4.39413e+01,1.33352e-02,4.46264e+01,4.25564e+01,1.36458e-02,4.19149e+01,3.99192e+01,1.37642e-02,
4.09399e+01,3.89712e+01,1.38038e-02,4.06197e+01,3.86602e+01,1.39637e-02,3.93640e+01,3.74409e+01,1.42889e-02,3.69712e+01,
3.51180e+01,1.44544e-02,3.58318e+01,3.40124e+01,1.47853e-02,3.36894e+01,3.19340e+01,1.49624e-02,3.26135e+01,3.08920e+01,
1.51356e-02,3.16082e+01,2.99186e+01,1.53109e-02,3.06338e+01,2.89754e+01,1.54882e-02,2.96844e+01,2.80565e+01,1.56675e-02,
2.87656e+01,2.71675e+01,1.58489e-02,2.78763e+01,2.63072e+01,1.58490e-02,2.78760e+01,2.63068e+01,1.59433e-02,2.74276e+01,
2.58732e+01,1.60324e-02,2.70121e+01,2.54722e+01,1.65959e-02,2.45798e+01,2.31255e+01,1.67880e-02,2.38206e+01,2.23936e+01,
1.71297e-02,2.25456e+01,2.11647e+01,1.73780e-02,2.16756e+01,2.03284e+01,1.75792e-02,2.10010e+01,1.96801e+01,1.77828e-02,
2.03481e+01,1.90529e+01,1.79887e-02,1.97156e+01,1.84453e+01,1.81868e-02,1.91328e+01,1.78858e+01,1.81970e-02,1.91033e+01,
1.78576e+01,1.84077e-02,1.85088e+01,1.72886e+01,1.90188e-02,1.69217e+01,1.57703e+01,1.92752e-02,1.63094e+01,1.51870e+01,
1.96774e-02,1.54113e+01,1.43318e+01,1.97242e-02,1.53107e+01,1.42364e+01,1.99526e-02,1.48316e+01,1.37824e+01,1.99530e-02,
1.48308e+01,1.37817e+01,2.00000e-02,1.47347e+01,1.36907e+01,2.02068e-02,1.43197e+01,1.32975e+01,2.04174e-02,1.39109e+01,
1.29126e+01,2.06241e-02,1.35253e+01,1.25496e+01,2.06538e-02,1.34707e+01,1.24986e+01,2.08930e-02,1.30418e+01,1.20982e+01,
2.09271e-02,1.29822e+01,1.20424e+01,2.11349e-02,1.26228e+01,1.17104e+01,2.11616e-02,1.25776e+01,1.16686e+01,2.12692e-02,
1.23957e+01,1.15024e+01,2.13710e-02,1.22251e+01,1.13480e+01,2.13796e-02,1.22106e+01,1.13350e+01,2.14576e-02,1.20806e+01,
1.12188e+01,2.15725e-02,1.18898e+01,1.10507e+01,2.16272e-02,1.17985e+01,1.09718e+01,2.17697e-02,1.15652e+01,1.07697e+01,
2.18849e-02,1.13827e+01,1.06100e+01,2.19657e-02,1.12612e+01,1.04999e+01,2.20152e-02,1.11900e+01,1.04331e+01,2.20757e-02,
1.11071e+01,1.03525e+01,2.20870e-02,1.10922e+01,1.03374e+01,2.20870e-02,6.84688e+01,2.69709e+01,2.21235e-02,6.82139e+01,
2.69333e+01,2.21846e-02,6.77924e+01,2.68699e+01,2.22654e-02,6.72463e+01,2.67857e+01,2.23500e-02,6.66842e+01,2.66968e+01,
2.25119e-02,6.55576e+01,2.64953e+01,2.26292e-02,6.47558e+01,2.63484e+01,2.26464e-02,6.46386e+01,2.63267e+01,2.26500e-02,
6.46145e+01,2.63222e+01,2.27349e-02,6.39616e+01,2.61819e+01,2.28103e-02,6.33886e+01,2.60576e+01,2.29065e-02,6.26653e+01,
2.58990e+01,2.30000e-02,6.19717e+01,2.57451e+01,2.30120e-02,6.18921e+01,2.57290e+01,2.31740e-02,6.08322e+01,2.55126e+01,
2.32432e-02,6.03864e+01,2.54198e+01,2.34423e-02,5.91266e+01,2.51525e+01,2.35165e-02,5.86662e+01,2.50527e+01,2.37137e-02,
5.74658e+01,2.47878e+01,2.38281e-02,5.67472e+01,2.46175e+01,2.39883e-02,5.57598e+01,2.43796e+01,2.42661e-02,5.41041e+01,
2.39698e+01,2.43791e-02,5.34505e+01,2.38043e+01,2.45471e-02,5.24972e+01,2.35592e+01,2.49147e-02,5.04924e+01,2.30283e+01,
2.51189e-02,4.94235e+01,2.27370e+01,2.51190e-02,4.94228e+01,2.27368e+01,2.55000e-02,4.75112e+01,2.22005e+01,2.55604e-02,
4.72221e+01,2.21195e+01,2.57040e-02,4.65446e+01,2.19280e+01,2.63027e-02,4.38600e+01,2.11431e+01,2.66133e-02,4.25524e+01,
2.07454e+01,2.69154e-02,4.13312e+01,2.03650e+01,2.72270e-02,4.01207e+01,1.99785e+01,2.75423e-02,3.89461e+01,1.95947e+01,
2.78612e-02,3.78063e+01,1.92139e+01,2.81838e-02,3.66999e+01,1.88361e+01,2.81909e-02,3.66763e+01,1.88279e+01,2.85102e-02,
3.56255e+01,1.84617e+01,2.88403e-02,3.45554e+01,1.80763e+01,2.98538e-02,3.15355e+01,1.69471e+01,3.01995e-02,3.05889e+01,
1.65803e+01,3.09030e-02,2.87811e+01,1.58621e+01,3.15000e-02,2.73611e+01,1.52809e+01,3.16228e-02,2.70809e+01,1.51644e+01,
3.16230e-02,2.70804e+01,1.51642e+01,3.19889e-02,2.62684e+01,1.48231e+01,3.20049e-02,2.62338e+01,1.48085e+01,3.27341e-02,
2.47160e+01,1.41570e+01,3.31131e-02,2.39750e+01,1.38322e+01,3.34965e-02,2.32563e+01,1.35151e+01,3.38844e-02,2.25456e+01,
1.31951e+01,3.52281e-02,2.03037e+01,1.21568e+01,3.58922e-02,1.93079e+01,1.16813e+01,3.67282e-02,1.81483e+01,1.11159e+01,
3.75837e-02,1.70581e+01,1.05722e+01,3.80189e-02,1.65382e+01,1.03086e+01,3.82665e-02,1.62522e+01,1.01625e+01,3.84592e-02,
1.60342e+01,1.00506e+01,3.89045e-02,1.55456e+01,9.79791e+00,3.93550e-02,1.50721e+01,9.55064e+00,3.98107e-02,1.46132e+01,
9.30869e+00,3.98110e-02,1.46129e+01,9.30854e+00,4.00000e-02,1.44283e+01,9.21055e+00,4.02717e-02,1.41684e+01,9.07198e+00,
4.07380e-02,1.37372e+01,8.84034e+00,4.21959e-02,1.25013e+01,8.16432e+00,4.26579e-02,1.21416e+01,7.96427e+00,4.31519e-02,
1.17661e+01,7.75285e+00,4.36516e-02,1.14020e+01,7.54613e+00,4.46684e-02,1.07078e+01,7.14736e+00,4.73151e-02,9.15501e+00,
6.23204e+00,4.78630e-02,8.87312e+00,6.06223e+00,4.79608e-02,8.82407e+00,6.03257e+00,4.84172e-02,8.59994e+00,5.89666e+00,
4.89779e-02,8.33531e+00,5.73522e+00,4.95450e-02,8.07901e+00,5.57822e+00,5.01187e-02,7.83077e+00,5.42518e+00,5.01190e-02,
7.83065e+00,5.42510e+00,5.12861e-02,7.35718e+00,5.13059e+00,5.24807e-02,6.91242e+00,4.85047e+00,5.30884e-02,6.70048e+00,
4.71580e+00,5.35512e-02,6.54282e+00,4.61486e+00,5.49541e-02,6.09479e+00,4.32589e+00,5.62341e-02,5.72246e+00,4.08296e+00,
5.82103e-02,5.20727e+00,3.74246e+00,6.00786e-02,4.77802e+00,3.45472e+00,6.09537e-02,4.59375e+00,3.33010e+00,6.23735e-02,
4.31512e+00,3.14025e+00,6.30957e-02,4.18244e+00,3.04924e+00,6.30960e-02,4.18239e+00,3.04921e+00,6.38264e-02,4.05389e+00,
2.96077e+00,6.53131e-02,3.80896e+00,2.79116e+00,6.60693e-02,3.69230e+00,2.70988e+00,6.76083e-02,3.46744e+00,2.55202e+00,
7.07946e-02,3.05951e+00,2.26242e+00,7.24436e-02,2.87473e+00,2.12981e+00,7.31060e-02,2.80496e+00,2.07950e+00,7.32825e-02,
2.78677e+00,2.06637e+00,7.58578e-02,2.53917e+00,1.88666e+00,7.67362e-02,2.46190e+00,1.83021e+00,7.85236e-02,2.31473e+00,
1.72221e+00,7.94328e-02,2.24469e+00,1.67062e+00,7.94330e-02,2.24467e+00,1.67061e+00,8.22243e-02,2.04748e+00,1.52483e+00,
8.81049e-02,1.70356e+00,1.26726e+00,9.01571e-02,1.60321e+00,1.19134e+00,9.12011e-02,1.55541e+00,1.15505e+00,9.22571e-02,
1.50915e+00,1.11986e+00,9.33254e-02,1.46439e+00,1.08573e+00,9.90467e-02,1.25514e+00,9.25184e-01,1.00000e-01,1.22462e+00,
9.01648e-01,1.04713e-01,1.08871e+00,7.96726e-01,1.05925e-01,1.05742e+00,7.72476e-01,1.09648e-01,9.68996e-01,7.03691e-01,
1.13501e-01,8.88865e-01,6.41103e-01,1.14815e-01,8.63841e-01,6.21507e-01,1.18850e-01,7.93519e-01,5.66313e-01,1.19323e-01,
7.85875e-01,5.60303e-01,1.20226e-01,7.71556e-01,5.49050e-01,1.24452e-01,7.09794e-01,5.00429e-01,1.25890e-01,6.90550e-01,
4.85253e-01,1.25893e-01,6.90517e-01,4.85227e-01,1.27350e-01,6.71787e-01,4.70530e-01,1.28825e-01,6.53655e-01,4.56294e-01,
1.31826e-01,6.19113e-01,4.29150e-01,1.36458e-01,5.71329e-01,3.91556e-01,1.41254e-01,5.27964e-01,3.57401e-01,1.42889e-01,
5.14420e-01,3.46728e-01,1.44544e-01,5.01305e-01,3.36392e-01,1.44714e-01,4.99988e-01,3.35354e-01,1.47911e-01,4.76283e-01,
3.16691e-01,1.49624e-01,4.64361e-01,3.07304e-01,1.50000e-01,4.61810e-01,3.05296e-01,1.53109e-01,4.41638e-01,2.89414e-01,
1.56675e-01,4.20328e-01,2.72640e-01,1.58489e-01,4.10174e-01,2.64650e-01,1.58490e-01,4.10171e-01,2.64647e-01,1.64059e-01,
3.81412e-01,2.42261e-01,1.65959e-01,3.72417e-01,2.35267e-01,1.67880e-01,3.63702e-01,2.28496e-01,1.69824e-01,3.55259e-01,
2.21940e-01,1.71791e-01,3.47079e-01,2.15594e-01,1.75792e-01,3.31473e-01,2.03504e-01,1.77917e-01,3.23714e-01,1.97502e-01,
1.79887e-01,3.16810e-01,1.92173e-01,1.84077e-01,3.03028e-01,1.81553e-01,1.86209e-01,2.96453e-01,1.76496e-01,1.88365e-01,
2.90082e-01,1.71601e-01,1.92752e-01,2.77919e-01,1.62274e-01,1.94984e-01,2.72160e-01,1.57875e-01,1.97242e-01,2.66575e-01,
1.53615e-01,1.99526e-01,2.61160e-01,1.49490e-01,1.99530e-01,2.61151e-01,1.49483e-01,2.04174e-01,2.50712e-01,1.41685e-01,
2.06538e-01,2.45720e-01,1.37968e-01,2.11349e-01,2.36178e-01,1.30882e-01,2.16272e-01,2.27192e-01,1.24239e-01,2.18776e-01,
2.22897e-01,1.21075e-01,2.21235e-01,2.18852e-01,1.18102e-01,2.21309e-01,2.18731e-01,1.18013e-01,2.26464e-01,2.10753e-01,
1.12180e-01,2.29087e-01,2.06938e-01,1.09401e-01,2.31740e-01,2.03234e-01,1.06711e-01,2.34423e-01,1.99638e-01,1.04106e-01,
2.37137e-01,1.96146e-01,1.01583e-01,2.39883e-01,1.92790e-01,9.91735e-02,2.42661e-01,1.89530e-01,9.68392e-02,2.48313e-01,
1.83284e-01,9.23866e-02,2.51189e-01,1.80292e-01,9.02641e-02,2.51190e-01,1.80291e-01,9.02631e-02,2.60016e-01,1.71691e-01,
8.43682e-02,2.63027e-01,1.68981e-01,8.25242e-02,2.66073e-01,1.66348e-01,8.07402e-02,2.69154e-01,1.63787e-01,7.90116e-02,
2.72270e-01,1.61295e-01,7.73367e-02,2.75423e-01,1.58871e-01,7.57138e-02,2.78612e-01,1.56513e-01,7.41415e-02,2.80000e-01,
1.55514e-01,7.34781e-02,2.81838e-01,1.54232e-01,7.26320e-02,2.95121e-01,1.45738e-01,6.70804e-02,2.98538e-01,1.43751e-01,
6.57961e-02,3.00000e-01,1.42923e-01,6.52631e-02,3.05492e-01,1.39925e-01,6.33429e-02,3.09029e-01,1.38085e-01,6.21715e-02,
3.12608e-01,1.36293e-01,6.10374e-02,3.16228e-01,1.34547e-01,5.99375e-02,3.16230e-01,1.34546e-01,5.99368e-02,3.19889e-01,
1.32812e-01,5.88965e-02,3.23594e-01,1.31119e-01,5.78868e-02,3.27341e-01,1.29486e-01,5.69250e-02,3.31131e-01,1.27893e-01,
5.59918e-02,3.34965e-01,1.26338e-01,5.50858e-02,3.42768e-01,1.23338e-01,5.33523e-02,3.46737e-01,1.21891e-01,5.25232e-02,
3.54813e-01,1.19098e-01,5.09366e-02,3.58922e-01,1.17751e-01,5.01789e-02,3.63078e-01,1.16435e-01,4.94429e-02,3.67282e-01,
1.15149e-01,4.87281e-02,3.75837e-01,1.12691e-01,4.73848e-02,3.80189e-01,1.11503e-01,4.67413e-02,3.84592e-01,1.10341e-01,
4.61157e-02,3.93550e-01,1.08091e-01,4.49155e-02,3.98107e-01,1.07002e-01,4.43400e-02,3.98110e-01,1.07002e-01,4.43397e-02,
4.00000e-01,1.06549e-01,4.41172e-02,4.02717e-01,1.05909e-01,4.38036e-02,4.12098e-01,1.03793e-01,4.27761e-02,4.16869e-01,
1.02777e-01,4.22932e-02,4.26580e-01,1.00807e-01,4.13648e-02,4.26963e-01,1.00732e-01,4.13295e-02,4.31519e-01,9.98503e-02,
4.09186e-02,4.36516e-01,9.89121e-02,4.04838e-02,4.41570e-01,9.79919e-02,4.00601e-02,4.46684e-01,9.70895e-02,3.96471e-02,
4.51856e-01,9.62044e-02,3.92446e-02,4.57088e-01,9.53369e-02,3.88529e-02,4.62381e-01,9.44944e-02,3.84794e-02,4.67735e-01,
9.36672e-02,3.81147e-02,4.73151e-01,9.28550e-02,3.77587e-02,4.78630e-01,9.20574e-02,3.74111e-02,4.84172e-01,9.12741e-02,
3.70718e-02,4.89779e-01,9.05046e-02,3.67403e-02,4.95450e-01,8.97485e-02,3.64165e-02,5.01187e-01,8.90057e-02,3.61001e-02,
5.01190e-01,8.90053e-02,3.60999e-02,5.06991e-01,8.82519e-02,3.58114e-02,5.12861e-01,8.75182e-02,3.55363e-02,5.18800e-01,
8.67965e-02,3.52670e-02,5.24808e-01,8.60865e-02,3.50033e-02,5.30884e-01,8.53879e-02,3.47450e-02,5.37032e-01,8.47005e-02,
3.44920e-02,5.43250e-01,8.40239e-02,3.42441e-02,5.49541e-01,8.33579e-02,3.40012e-02,5.62341e-01,8.20567e-02,3.35295e-02,
5.68853e-01,8.14269e-02,3.33062e-02,5.75440e-01,8.08064e-02,3.30870e-02,5.82103e-01,8.01950e-02,3.28717e-02,5.88844e-01,
7.95924e-02,3.26601e-02,5.95662e-01,7.89986e-02,3.24524e-02,6.09537e-01,7.78362e-02,3.20475e-02,6.16595e-01,7.72672e-02,
3.18501e-02,6.23735e-01,7.67108e-02,3.16605e-02,6.30957e-01,7.61622e-02,3.14743e-02,6.30960e-01,7.61620e-02,3.14742e-02,
6.38264e-01,7.55995e-02,3.13068e-02,6.45654e-01,7.50442e-02,3.11416e-02,6.53131e-01,7.44956e-02,3.09785e-02,6.68344e-01,
7.34196e-02,3.06588e-02,6.76083e-01,7.28919e-02,3.05019e-02,6.83912e-01,7.23708e-02,3.03469e-02,6.91831e-01,7.18603e-02,
3.01979e-02,6.99842e-01,7.13560e-02,3.00504e-02,7.07946e-01,7.08577e-02,2.99045e-02,7.16143e-01,7.03653e-02,2.97601e-02,
7.24436e-01,6.98787e-02,2.96172e-02,7.32825e-01,6.93979e-02,2.94757e-02,7.41310e-01,6.89227e-02,2.93356e-02,7.49894e-01,
6.84529e-02,2.91969e-02,7.58578e-01,6.79885e-02,2.90594e-02,7.67362e-01,6.75324e-02,2.89263e-02,7.85236e-01,6.66352e-02,
2.86633e-02,7.94328e-01,6.61939e-02,2.85333e-02,7.94330e-01,6.61938e-02,2.85333e-02,8.03526e-01,6.57397e-02,2.84193e-02,
8.12831e-01,6.52904e-02,2.83058e-02,8.22243e-01,6.48458e-02,2.81929e-02,8.31764e-01,6.44059e-02,2.80804e-02,8.41395e-01,
6.39706e-02,2.79683e-02,8.51138e-01,6.35423e-02,2.78592e-02,8.60994e-01,6.31183e-02,2.77504e-02,8.70964e-01,6.26985e-02,
2.76419e-02,8.81049e-01,6.22829e-02,2.75337e-02,8.91251e-01,6.18715e-02,2.74259e-02,9.01571e-01,6.14640e-02,2.73183e-02,
9.12011e-01,6.10606e-02,2.72111e-02,9.22571e-01,6.06610e-02,2.71041e-02,9.44061e-01,5.98771e-02,2.68947e-02,9.54993e-01,
5.94909e-02,2.67905e-02,9.66051e-01,5.91083e-02,2.66864e-02,9.77237e-01,5.87291e-02,2.65826e-02,9.88553e-01,5.83535e-02,
2.64789e-02,1.00000e+00,5.79812e-02,2.63753e-02,1.00000e-03,6.16806e+03,6.16154e+03,1.01158e-03,6.01139e+03,6.00488e+03,
1.01304e-03,5.99198e+03,5.98547e+03,1.02329e-03,5.85783e+03,5.85133e+03,1.03514e-03,5.70837e+03,5.70190e+03,1.07152e-03,
5.28280e+03,5.27637e+03,1.09648e-03,5.01727e+03,5.01087e+03,1.10918e-03,4.88855e+03,4.88218e+03,1.11000e-03,4.88030e+03,
4.87392e+03,1.12202e-03,4.76228e+03,4.75592e+03,1.13501e-03,4.63848e+03,4.63213e+03,1.13664e-03,4.62321e+03,4.61686e+03,
1.16145e-03,4.40000e+03,4.39369e+03,1.17828e-03,4.25758e+03,4.25129e+03,1.20226e-03,4.06590e+03,4.05966e+03,1.21619e-03,
3.95979e+03,3.95356e+03,1.24451e-03,3.75372e+03,3.74754e+03,1.25890e-03,3.65461e+03,3.64845e+03,1.25892e-03,3.65444e+03,
3.64828e+03,1.27350e-03,3.55780e+03,3.55166e+03,1.28825e-03,3.46388e+03,3.45776e+03,1.33352e-03,3.19753e+03,3.19148e+03,
1.35540e-03,3.07853e+03,3.07251e+03,1.36618e-03,3.02181e+03,3.01581e+03,1.38038e-03,2.94931e+03,2.94333e+03,1.39637e-03,
2.87019e+03,2.86423e+03,1.41254e-03,2.79328e+03,2.78735e+03,1.45000e-03,2.62635e+03,2.62047e+03,1.46218e-03,2.57526e+03,
2.56940e+03,1.47911e-03,2.50612e+03,2.50028e+03,1.49886e-03,2.42856e+03,2.42274e+03,1.50000e-03,2.42419e+03,2.41838e+03,
1.51356e-03,2.37310e+03,2.36731e+03,1.53109e-03,2.30895e+03,2.30318e+03,1.54882e-03,2.24622e+03,2.24049e+03,1.58489e-03,
2.12610e+03,2.12042e+03,1.58490e-03,2.12607e+03,2.12039e+03,1.60325e-03,2.06857e+03,2.06291e+03,1.62181e-03,2.01233e+03,
2.00670e+03,1.63000e-03,1.98814e+03,1.98253e+03,1.65754e-03,1.90987e+03,1.90429e+03,1.65959e-03,1.90421e+03,1.89864e+03,
1.67880e-03,1.85245e+03,1.84691e+03,1.69824e-03,1.80182e+03,1.79630e+03,1.71791e-03,1.75240e+03,1.74692e+03,1.73712e-03,
1.70611e+03,1.70065e+03,1.77828e-03,1.61256e+03,1.60717e+03,1.79887e-03,1.56823e+03,1.56288e+03,1.80000e-03,1.56585e+03,
1.56050e+03,1.81970e-03,1.52509e+03,1.51977e+03,1.88365e-03,1.40249e+03,1.39727e+03,1.90000e-03,1.37348e+03,1.36828e+03,
1.90546e-03,1.36392e+03,1.35873e+03,1.91371e-03,1.34964e+03,1.34446e+03,1.97242e-03,1.25378e+03,1.24869e+03,1.99526e-03,
1.21897e+03,1.21392e+03,1.99530e-03,1.21892e+03,1.21386e+03,2.00000e-03,1.21192e+03,1.20687e+03,2.00786e-03,1.20034e+03,
1.19530e+03,2.04174e-03,1.15213e+03,1.14715e+03,2.08930e-03,1.08907e+03,1.08417e+03,2.10020e-03,1.07530e+03,1.07041e+03,
2.11349e-03,1.05885e+03,1.05399e+03,2.16272e-03,1.00053e+03,9.95745e+02,2.18776e-03,9.72640e+02,9.67897e+02,2.20518e-03,
9.53779e+02,9.49064e+02,2.23872e-03,9.18890e+02,9.14233e+02,2.29087e-03,8.68021e+02,8.63451e+02,2.29982e-03,8.59702e+02,
8.55147e+02,2.34423e-03,8.20051e+02,8.15579e+02,2.37137e-03,7.96994e+02,7.92572e+02,2.39151e-03,7.80447e+02,7.76060e+02,
2.39883e-03,7.74544e+02,7.70173e+02,2.40000e-03,7.73610e+02,7.69241e+02,2.42661e-03,7.52695e+02,7.48378e+02,2.45471e-03,
7.31344e+02,7.27082e+02,2.47036e-03,7.19790e+02,7.15559e+02,2.48313e-03,7.10545e+02,7.06341e+02,2.51189e-03,6.90356e+02,
6.86212e+02,2.51190e-03,6.90347e+02,6.86203e+02,2.53630e-03,6.73847e+02,6.69753e+02,2.57680e-03,6.47651e+02,6.43648e+02,
2.60016e-03,6.33208e+02,6.29256e+02,2.60157e-03,6.32353e+02,6.28404e+02,2.65450e-03,6.01325e+02,5.97504e+02,2.66073e-03,
5.97815e+02,5.94011e+02,2.69154e-03,5.80762e+02,5.77041e+02,2.70094e-03,5.75695e+02,5.71998e+02,2.71080e-03,5.70444e+02,
5.66778e+02,2.72270e-03,5.64147e+02,5.60518e+02,2.74196e-03,5.54164e+02,5.50592e+02,2.75423e-03,5.47925e+02,5.44394e+02,
2.77580e-03,5.37172e+02,5.33711e+02,2.80712e-03,5.22065e+02,5.18717e+02,2.81838e-03,5.16773e+02,5.13470e+02,2.83006e-03,
5.11356e+02,5.08100e+02,2.85423e-03,5.00372e+02,4.97222e+02,2.87298e-03,4.92065e+02,4.89009e+02,2.88403e-03,4.87250e+02,
4.84256e+02,2.89368e-03,4.83106e+02,4.80167e+02,2.91047e-03,4.75996e+02,4.73169e+02,2.92281e-03,4.70844e+02,4.68111e+02,
2.93773e-03,4.64710e+02,4.62102e+02,2.95121e-03,4.59250e+02,4.56761e+02,2.96407e-03,4.54140e+02,4.51759e+02,2.97476e-03,
4.49967e+02,4.47658e+02,2.97870e-03,4.48447e+02,4.46159e+02,2.98603e-03,4.45649e+02,4.43388e+02,2.99175e-03,4.43495e+02,
4.41246e+02,2.99578e-03,4.41993e+02,4.39745e+02,3.00000e-03,4.40432e+02,4.38178e+02,3.00299e-03,4.39329e+02,4.37072e+02,
3.00450e-03,4.38777e+02,4.36515e+02,3.00450e-03,1.50042e+03,1.45302e+03,3.01105e-03,1.49269e+03,1.44560e+03,3.01880e-03,
1.48363e+03,1.43688e+03,3.02500e-03,1.47646e+03,1.42996e+03,3.03027e-03,1.47039e+03,1.42411e+03,3.04933e-03,1.44878e+03,
1.40324e+03,3.05492e-03,1.44252e+03,1.39720e+03,3.05911e-03,1.43784e+03,1.39269e+03,3.06764e-03,1.42838e+03,1.38356e+03,
3.07634e-03,1.41881e+03,1.37433e+03,3.08622e-03,1.40804e+03,1.36397e+03,3.09656e-03,1.39689e+03,1.35324e+03,3.12000e-03,
1.37206e+03,1.32935e+03,3.12266e-03,1.36908e+03,1.32648e+03,3.13459e-03,1.35587e+03,1.31374e+03,3.15033e-03,1.33872e+03,
1.29720e+03,3.15150e-03,1.33746e+03,1.29598e+03,3.15150e-03,1.84332e+03,1.77771e+03,3.16228e-03,1.82748e+03,1.76254e+03,
3.16230e-03,1.82744e+03,1.76251e+03,3.16515e-03,1.82329e+03,1.75853e+03,3.19807e-03,1.77626e+03,1.71347e+03,3.19889e-03,
1.77510e+03,1.71235e+03,3.21133e-03,1.75778e+03,1.69576e+03,3.22323e-03,1.74144e+03,1.68010e+03,3.23594e-03,1.72420e+03,
1.66359e+03,3.23668e-03,1.72320e+03,1.66263e+03,3.25346e-03,1.70080e+03,1.64120e+03,3.27232e-03,1.67610e+03,1.61758e+03,
3.27341e-03,1.67469e+03,1.61623e+03,3.29343e-03,1.64848e+03,1.59116e+03,3.31131e-03,1.62554e+03,1.56922e+03,3.31158e-03,
1.62520e+03,1.56890e+03,3.34965e-03,1.57892e+03,1.52466e+03,3.35773e-03,1.56934e+03,1.51550e+03,3.37000e-03,1.55494e+03,
1.50172e+03,3.38844e-03,1.53368e+03,1.48134e+03,3.39013e-03,1.53171e+03,1.47946e+03,3.39120e-03,1.53047e+03,1.47826e+03,
3.39120e-03,1.75602e+03,1.69508e+03,3.40000e-03,1.74494e+03,1.68447e+03,3.42040e-03,1.71960e+03,1.66020e+03,3.42768e-03,
1.71069e+03,1.65166e+03,3.45014e-03,1.68360e+03,1.62570e+03,3.46467e-03,1.66640e+03,1.60921e+03,3.48237e-03,1.64577e+03,
1.58944e+03,3.50634e-03,1.61839e+03,1.56321e+03,3.50752e-03,1.61705e+03,1.56193e+03,3.53312e-03,1.58857e+03,1.53465e+03,
3.54813e-03,1.57219e+03,1.51895e+03,3.56291e-03,1.55630e+03,1.50374e+03,3.58922e-03,1.52858e+03,1.47718e+03,3.60304e-03,
1.51404e+03,1.46323e+03,3.63078e-03,1.48542e+03,1.43581e+03,3.67632e-03,1.43992e+03,1.39218e+03,3.70000e-03,1.41703e+03,
1.37023e+03,3.75432e-03,1.36587e+03,1.32114e+03,3.75837e-03,1.36215e+03,1.31757e+03,3.80189e-03,1.32317e+03,1.28015e+03,
3.84592e-03,1.28528e+03,1.24377e+03,3.89045e-03,1.24847e+03,1.20841e+03,3.90000e-03,1.24078e+03,1.20102e+03,3.93550e-03,
1.21275e+03,1.17408e+03,3.98107e-03,1.17787e+03,1.14055e+03,3.98110e-03,1.17785e+03,1.14053e+03,3.98990e-03,1.17127e+03,
1.13420e+03,4.00000e-03,1.16379e+03,1.12701e+03,4.02717e-03,1.14400e+03,1.10798e+03,4.07380e-03,1.11099e+03,1.07621e+03,
4.16869e-03,1.04787e+03,1.01545e+03,4.18108e-03,1.03996e+03,1.00782e+03,4.21696e-03,1.01747e+03,9.86168e+02,4.31519e-03,
9.59332e+02,9.30140e+02,4.39428e-03,9.15808e+02,8.88169e+02,4.41570e-03,9.04489e+02,8.77252e+02,4.46684e-03,8.78275e+02,
8.51964e+02,4.51856e-03,8.52845e+02,8.27421e+02,4.57088e-03,8.28128e+02,8.03558e+02,4.62381e-03,8.04150e+02,7.80400e+02,
4.64778e-03,7.93617e+02,7.70224e+02,4.67735e-03,7.80881e+02,7.57922e+02,4.80000e-03,7.31030e+02,7.09740e+02,4.84172e-03,
7.14937e+02,6.94175e+02,4.89927e-03,6.93523e+02,6.73459e+02,4.95450e-03,6.73797e+02,6.54373e+02,5.01187e-03,6.54088e+02,
6.35298e+02,5.01190e-03,6.54078e+02,6.35289e+02,5.06991e-03,6.35005e+02,6.16822e+02,5.12861e-03,6.16497e+02,5.98899e+02,
5.18800e-03,5.98543e+02,5.81505e+02,5.24807e-03,5.81032e+02,5.64535e+02,5.28978e-03,5.69302e+02,5.53165e+02,5.30884e-03,
5.64048e+02,5.48073e+02,5.37032e-03,5.47483e+02,5.32013e+02,5.43250e-03,5.31403e+02,5.16420e+02,5.55904e-03,5.00433e+02,
4.86371e+02,5.62341e-03,4.85643e+02,4.72015e+02,5.68853e-03,4.71303e+02,4.58093e+02,5.69854e-03,4.69153e+02,4.56005e+02,
5.75440e-03,4.57395e+02,4.44589e+02,5.82103e-03,4.43909e+02,4.31492e+02,5.95662e-03,4.18053e+02,4.06372e+02,6.02560e-03,
4.05712e+02,3.94378e+02,6.09537e-03,3.93577e+02,3.82579e+02,6.16595e-03,3.81809e+02,3.71135e+02,6.23735e-03,3.70401e+02,
3.60038e+02,6.24105e-03,3.69823e+02,3.59477e+02,6.30000e-03,3.60779e+02,3.50681e+02,6.30957e-03,3.59330e+02,3.49271e+02,
6.30960e-03,3.59326e+02,3.49267e+02,6.38263e-03,3.48531e+02,3.38765e+02,6.50000e-03,3.32123e+02,3.22798e+02,6.53131e-03,
3.27930e+02,3.18717e+02,6.60693e-03,3.18098e+02,3.09145e+02,6.76083e-03,2.99335e+02,2.90875e+02,6.83912e-03,2.90386e+02,
2.82159e+02,6.91831e-03,2.81697e+02,2.73694e+02,6.92625e-03,2.80846e+02,2.72865e+02,7.00000e-03,2.73110e+02,2.65330e+02,
7.07946e-03,2.65074e+02,2.57501e+02,7.24436e-03,2.49316e+02,2.42145e+02,7.32824e-03,2.41804e+02,2.34822e+02,7.41310e-03,
2.34524e+02,2.27725e+02,7.49894e-03,2.27470e+02,2.20847e+02,7.67362e-03,2.14010e+02,2.07721e+02,7.69020e-03,2.12790e+02,
2.06532e+02,7.76247e-03,2.07584e+02,2.01456e+02,7.80000e-03,2.04950e+02,1.98887e+02,7.85236e-03,2.01334e+02,1.95360e+02,
7.94328e-03,1.95202e+02,1.89379e+02,7.94330e-03,1.95201e+02,1.89377e+02,8.22243e-03,1.77887e+02,1.72484e+02,8.41395e-03,
1.67235e+02,1.62089e+02,8.51138e-03,1.62158e+02,1.57134e+02,8.60994e-03,1.57241e+02,1.52334e+02,8.66483e-03,1.54593e+02,
1.49750e+02,8.70964e-03,1.52477e+02,1.47685e+02,8.81049e-03,1.47862e+02,1.43181e+02,8.91251e-03,1.43388e+02,1.38814e+02,
9.01571e-03,1.39049e+02,1.34580e+02,9.12011e-03,1.34831e+02,1.30462e+02,9.33254e-03,1.26730e+02,1.22554e+02,9.50000e-03,
1.20819e+02,1.16783e+02,9.54993e-03,1.19119e+02,1.15124e+02,9.61846e-03,1.16840e+02,1.12899e+02,9.66051e-03,1.15471e+02,
1.11563e+02,9.77237e-03,1.11938e+02,1.08114e+02,9.88553e-03,1.08516e+02,1.04775e+02,1.00000e-02,1.05203e+02,1.01541e+02,
1.01158e-02,1.01992e+02,9.84077e+01,1.02329e-02,9.88804e+01,9.53705e+01,1.03514e-02,9.58555e+01,9.24183e+01,1.04713e-02,
9.29261e+01,8.95593e+01,1.05773e-02,9.04394e+01,8.71325e+01,1.05925e-02,9.00893e+01,8.67910e+01,1.07152e-02,8.73388e+01,
8.41082e+01,1.08393e-02,8.46598e+01,8.14951e+01,1.09648e-02,8.20660e+01,7.89653e+01,1.10918e-02,7.95543e+01,7.65155e+01,
1.13501e-02,7.47420e+01,7.18221e+01,1.15000e-02,7.21347e+01,6.92794e+01,1.16093e-02,7.03148e+01,6.75049e+01,1.20226e-02,
6.39719e+01,6.13253e+01,1.21619e-02,6.20063e+01,5.94105e+01,1.23027e-02,6.01030e+01,5.75566e+01,1.24451e-02,5.82535e+01,
5.57552e+01,1.25531e-02,5.69043e+01,5.44413e+01,1.25890e-02,5.64646e+01,5.40134e+01,1.25892e-02,5.64615e+01,5.40104e+01,
1.27350e-02,5.47242e+01,5.23201e+01,1.30317e-02,5.13998e+01,4.90861e+01,1.31826e-02,4.98162e+01,4.75458e+01,1.34969e-02,
4.67309e+01,4.45458e+01,1.38038e-02,4.39647e+01,4.18596e+01,1.40000e-02,4.23179e+01,4.02610e+01,1.41254e-02,4.13030e+01,
3.92758e+01,1.42889e-02,4.00298e+01,3.80401e+01,1.45560e-02,3.80665e+01,3.61351e+01,1.46218e-02,3.76031e+01,3.56861e+01,
1.47911e-02,3.64454e+01,3.45644e+01,1.50000e-02,3.50742e+01,3.32360e+01,1.51356e-02,3.42228e+01,3.24113e+01,1.53109e-02,
3.31634e+01,3.13854e+01,1.56622e-02,3.11763e+01,2.94620e+01,1.58489e-02,3.01854e+01,2.85045e+01,1.58490e-02,3.01851e+01,
2.85042e+01,1.60324e-02,2.92534e+01,2.76042e+01,1.62181e-02,2.83524e+01,2.67342e+01,1.64059e-02,2.74803e+01,2.58924e+01,
1.65959e-02,2.66297e+01,2.50714e+01,1.67880e-02,2.58065e+01,2.42770e+01,1.68662e-02,2.54820e+01,2.39639e+01,1.70000e-02,
2.49384e+01,2.34405e+01,1.73780e-02,2.34866e+01,2.20431e+01,1.75792e-02,2.27579e+01,2.13419e+01,1.79887e-02,2.13668e+01,
2.00039e+01,1.81278e-02,2.09220e+01,1.95763e+01,1.86209e-02,1.94409e+01,1.81564e+01,1.88365e-02,1.88396e+01,1.75802e+01,
1.90546e-02,1.82575e+01,1.70228e+01,1.91922e-02,1.79010e+01,1.66813e+01,1.94985e-02,1.71392e+01,1.59540e+01,1.97242e-02,
1.66066e+01,1.54456e+01,1.99526e-02,1.60910e+01,1.49538e+01,1.99530e-02,1.60902e+01,1.49530e+01,2.00000e-02,1.59868e+01,
1.48544e+01,2.00495e-02,1.58788e+01,1.47514e+01,2.01837e-02,1.55904e+01,1.44774e+01,2.04174e-02,1.51046e+01,1.40159e+01,
2.07033e-02,1.45367e+01,1.34765e+01,2.08930e-02,1.41746e+01,1.31343e+01,2.11349e-02,1.37300e+01,1.27141e+01,2.12058e-02,
1.36035e+01,1.25946e+01,2.15961e-02,1.29317e+01,1.19634e+01,2.18776e-02,1.24716e+01,1.15344e+01,2.19206e-02,1.24030e+01,
1.14703e+01,2.21911e-02,1.19786e+01,1.10785e+01,2.23203e-02,1.17805e+01,1.08976e+01,2.23872e-02,1.16786e+01,1.08056e+01,
2.24303e-02,1.16137e+01,1.07469e+01,2.25224e-02,1.14748e+01,1.06231e+01,2.26466e-02,1.12882e+01,1.04591e+01,2.28399e-02,
1.09999e+01,1.02104e+01,2.29087e-02,1.09003e+01,1.01239e+01,2.29614e-02,1.08248e+01,1.00583e+01,2.30460e-02,1.07086e+01,
9.95428e+00,2.31156e-02,1.06179e+01,9.86978e+00,2.31618e-02,1.05605e+01,9.81434e+00,2.31740e-02,1.05458e+01,9.79974e+00,
2.31910e-02,1.05253e+01,9.77939e+00,2.31910e-02,6.42115e+01,2.47294e+01,2.32031e-02,6.41381e+01,2.47201e+01,2.32624e-02,
6.37841e+01,2.46743e+01,2.33525e-02,6.32566e+01,2.46041e+01,2.34423e-02,6.27414e+01,2.45333e+01,2.34500e-02,6.26975e+01,
2.45272e+01,2.34680e-02,6.25822e+01,2.45078e+01,2.36506e-02,6.14339e+01,2.43101e+01,2.37497e-02,6.08212e+01,2.42020e+01,
2.38200e-02,6.03902e+01,2.41250e+01,2.38850e-02,5.99516e+01,2.40358e+01,2.40000e-02,5.91826e+01,2.38778e+01,2.40363e-02,
5.89429e+01,2.38280e+01,2.42525e-02,5.75361e+01,2.35310e+01,2.42661e-02,5.74487e+01,2.35123e+01,2.45333e-02,5.59202e+01,
2.32084e+01,2.48392e-02,5.42368e+01,2.28593e+01,2.50000e-02,5.33788e+01,2.26756e+01,2.51189e-02,5.27187e+01,2.25232e+01,
2.51190e-02,5.27179e+01,2.25231e+01,2.53746e-02,5.13343e+01,2.21958e+01,2.54097e-02,5.11478e+01,2.21509e+01,2.59251e-02,
4.85177e+01,2.15120e+01,2.63027e-02,4.67070e+01,2.10498e+01,2.64816e-02,4.58819e+01,2.08328e+01,2.66073e-02,4.53140e+01,
2.06814e+01,2.69154e-02,4.39901e+01,2.03262e+01,2.72270e-02,4.27055e+01,1.99712e+01,2.74631e-02,4.17670e+01,1.97053e+01,
2.75423e-02,4.14585e+01,1.96168e+01,2.81838e-02,3.90720e+01,1.89108e+01,2.85102e-02,3.79316e+01,1.85601e+01,2.87058e-02,
3.72700e+01,1.83527e+01,2.91743e-02,3.57488e+01,1.78645e+01,2.95121e-02,3.47040e+01,1.75197e+01,3.03243e-02,3.23019e+01,
1.66867e+01,3.05492e-02,3.16772e+01,1.64635e+01,3.16228e-02,2.89156e+01,1.54422e+01,3.16230e-02,2.89150e+01,1.54420e+01,
3.19889e-02,2.80503e+01,1.51103e+01,3.23594e-02,2.72111e+01,1.47828e+01,3.26592e-02,2.65572e+01,1.45238e+01,3.27341e-02,
2.63972e+01,1.44598e+01,3.34965e-02,2.48417e+01,1.38279e+01,3.42768e-02,2.33791e+01,1.32150e+01,3.54181e-02,2.14100e+01,
1.23607e+01,3.71535e-02,1.88297e+01,1.11874e+01,3.75837e-02,1.82575e+01,1.09184e+01,3.80189e-02,1.77029e+01,1.06545e+01,
3.86882e-02,1.68944e+01,1.02640e+01,3.89045e-02,1.66438e+01,1.01417e+01,3.93550e-02,1.61383e+01,9.89283e+00,3.98107e-02,
1.56484e+01,9.64903e+00,3.98110e-02,1.56482e+01,9.64888e+00,4.02717e-02,1.51736e+01,9.41019e+00,4.07380e-02,1.47128e+01,
9.17592e+00,4.16869e-02,1.38335e+01,8.72202e+00,4.21696e-02,1.34141e+01,8.50227e+00,4.26579e-02,1.30075e+01,8.28718e+00,
4.26792e-02,1.29899e+01,8.27779e+00,4.31519e-02,1.26067e+01,8.07245e+00,4.41570e-02,1.18425e+01,7.65743e+00,4.46684e-02,
1.14782e+01,7.45700e+00,4.51856e-02,1.11253e+01,7.26112e+00,4.57088e-02,1.07835e+01,7.06980e+00,4.73151e-02,9.82090e+00,
6.52234e+00,4.84172e-02,9.22762e+00,6.17820e+00,4.85081e-02,9.18093e+00,6.15089e+00,4.95450e-02,8.67061e+00,5.85049e+00,
5.01187e-02,8.40303e+00,5.69159e+00,5.01190e-02,8.40290e+00,5.69152e+00,5.24807e-02,7.41400e+00,5.09445e+00,5.27935e-02,
7.29540e+00,5.02174e+00,5.30884e-02,7.18586e+00,4.95442e+00,5.62341e-02,6.14783e+00,4.30572e+00,5.68853e-02,5.95923e+00,
4.18567e+00,5.81655e-02,5.60713e+00,3.95922e+00,6.02560e-02,5.09140e+00,3.62332e+00,6.23735e-02,4.63429e+00,3.32091e+00,
6.30957e-02,4.49155e+00,3.22552e+00,6.30960e-02,4.49149e+00,3.22549e+00,6.38264e-02,4.35325e+00,3.13277e+00,6.68344e-02,
3.84268e+00,2.78644e+00,6.76083e-02,3.72504e+00,2.70574e+00,6.93660e-02,3.47583e+00,2.53362e+00,7.00000e-02,3.39167e+00,
2.47516e+00,7.16143e-02,3.18779e+00,2.33255e+00,7.24436e-02,3.08976e+00,2.26359e+00,7.41310e-02,2.90307e+00,2.13151e+00,
7.58578e-02,2.72820e+00,2.00690e+00,7.67362e-02,2.64497e+00,1.94727e+00,7.94328e-02,2.41097e+00,1.77852e+00,7.94330e-02,
2.41095e+00,1.77850e+00,8.22243e-02,2.19851e+00,1.62409e+00,8.31764e-02,2.13213e+00,1.57554e+00,8.70964e-02,1.88725e+00,
1.39533e+00,8.91251e-02,1.77532e+00,1.31217e+00,8.95942e-02,1.75082e+00,1.29391e+00,9.01571e-02,1.72205e+00,1.27245e+00,
9.12011e-02,1.67048e+00,1.23391e+00,9.22571e-02,1.62059e+00,1.19652e+00,9.44061e-02,1.52558e+00,1.12508e+00,1.00000e-01,
1.31362e+00,9.64428e-01,1.02329e-01,1.23795e+00,9.06824e-01,1.07152e-01,1.10058e+00,8.01660e-01,1.08393e-01,1.06896e+00,
7.77343e-01,1.09648e-01,1.03835e+00,7.53770e-01,1.12202e-01,9.80055e-01,7.08764e-01,1.13501e-01,9.52304e-01,6.87291e-01,
1.13896e-01,9.44081e-01,6.80918e-01,1.14815e-01,9.25308e-01,6.66375e-01,1.17490e-01,8.73886e-01,6.26466e-01,1.20226e-01,
8.25723e-01,5.88989e-01,1.21619e-01,8.02795e-01,5.71115e-01,1.25890e-01,7.38370e-01,5.20778e-01,1.25893e-01,7.38334e-01,
5.20750e-01,1.27350e-01,7.18136e-01,5.05022e-01,1.28825e-01,6.98584e-01,4.89785e-01,1.30317e-01,6.79658e-01,4.75023e-01,
1.33352e-01,6.43598e-01,4.46865e-01,1.40925e-01,5.66022e-01,3.86163e-01,1.41254e-01,5.63006e-01,3.83803e-01,1.46218e-01,
5.20499e-01,3.50518e-01,1.47911e-01,5.07218e-01,3.40113e-01,1.49624e-01,4.94358e-01,3.30034e-01,1.50000e-01,4.91606e-01,
3.27877e-01,1.51356e-01,4.81906e-01,3.20273e-01,1.56675e-01,4.46858e-01,2.92794e-01,1.58489e-01,4.35904e-01,2.84206e-01,
1.58490e-01,4.35900e-01,2.84202e-01,1.62181e-01,4.14901e-01,2.67897e-01,1.67880e-01,3.85798e-01,2.45319e-01,1.69824e-01,
3.76696e-01,2.38265e-01,1.71791e-01,3.67878e-01,2.31435e-01,1.72534e-01,3.64642e-01,2.28930e-01,1.73780e-01,3.59326e-01,
2.24821e-01,1.77828e-01,3.43002e-01,2.12218e-01,1.79887e-01,3.35218e-01,2.06214e-01,1.84077e-01,3.20363e-01,1.94772e-01,
1.86209e-01,3.13278e-01,1.89322e-01,1.88365e-01,3.06411e-01,1.84045e-01,1.90546e-01,2.99755e-01,1.78936e-01,1.92752e-01,
2.93304e-01,1.73990e-01,1.94984e-01,2.87098e-01,1.69245e-01,1.99526e-01,2.75248e-01,1.60200e-01,1.99530e-01,2.75238e-01,
1.60193e-01,2.01837e-01,2.69538e-01,1.55919e-01,2.06538e-01,2.58625e-01,1.47758e-01,2.08930e-01,2.53412e-01,1.43870e-01,
2.13796e-01,2.43447e-01,1.36457e-01,2.16272e-01,2.38688e-01,1.32928e-01,2.18776e-01,2.34070e-01,1.29511e-01,2.20356e-01,
2.31253e-01,1.27430e-01,2.21309e-01,2.29585e-01,1.26201e-01,2.29087e-01,2.16899e-01,1.16888e-01,2.31740e-01,2.12915e-01,
1.13977e-01,2.34423e-01,2.09048e-01,1.11158e-01,2.37137e-01,2.05293e-01,1.08428e-01,2.39883e-01,2.01684e-01,1.05819e-01,
2.42661e-01,1.98179e-01,1.03290e-01,2.45471e-01,1.94773e-01,1.00841e-01,2.48313e-01,1.91464e-01,9.84672e-02,2.51189e-01,
1.88249e-01,9.61678e-02,2.51190e-01,1.88247e-01,9.61667e-02,2.54097e-01,1.85083e-01,9.39683e-02,2.60016e-01,1.79016e-01,
8.97732e-02,2.63027e-01,1.76110e-01,8.77756e-02,2.66073e-01,1.73285e-01,8.58400e-02,2.69154e-01,1.70538e-01,8.39644e-02,
2.72270e-01,1.67866e-01,8.21469e-02,2.75423e-01,1.65267e-01,8.03857e-02,2.78612e-01,1.62739e-01,7.86790e-02,2.80000e-01,
1.61669e-01,7.79590e-02,2.88403e-01,1.55637e-01,7.39444e-02,2.95121e-01,1.51218e-01,7.10305e-02,2.96291e-01,1.50481e-01,
7.05474e-02,3.00000e-01,1.48207e-01,6.90616e-02,3.01995e-01,1.47022e-01,6.82897e-02,3.05492e-01,1.45005e-01,6.69810e-02,
3.09029e-01,1.43042e-01,6.57136e-02,3.16228e-01,1.39266e-01,6.32921e-02,3.16230e-01,1.39265e-01,6.32914e-02,3.23594e-01,
1.35611e-01,6.10641e-02,3.27341e-01,1.33852e-01,5.99999e-02,3.31131e-01,1.32156e-01,5.89862e-02,3.34965e-01,1.30501e-01,
5.80021e-02,3.38844e-01,1.28885e-01,5.70467e-02,3.42768e-01,1.27309e-01,5.61190e-02,3.46737e-01,1.25770e-01,5.52184e-02,
3.50752e-01,1.24267e-01,5.43438e-02,3.63078e-01,1.19973e-01,5.18726e-02,3.71535e-01,1.17273e-01,5.03409e-02,3.75837e-01,
1.15984e-01,4.96216e-02,3.80189e-01,1.14724e-01,4.89227e-02,3.89045e-01,1.12287e-01,4.75822e-02,3.93550e-01,1.11108e-01,
4.69394e-02,3.98107e-01,1.09955e-01,4.63142e-02,3.98110e-01,1.09955e-01,4.63139e-02,4.00000e-01,1.09476e-01,4.60720e-02,
4.02717e-01,1.08800e-01,4.57309e-02,4.07380e-01,1.07670e-01,4.51634e-02,4.12098e-01,1.06563e-01,4.46112e-02,4.16869e-01,
1.05479e-01,4.40740e-02,4.21697e-01,1.04429e-01,4.35622e-02,4.26580e-01,1.03400e-01,4.30637e-02,4.31519e-01,1.02392e-01,
4.25784e-02,4.32763e-01,1.02144e-01,4.24590e-02,4.36516e-01,1.01404e-01,4.21054e-02,4.41570e-01,1.00434e-01,4.16445e-02,
4.46684e-01,9.94832e-02,4.11954e-02,4.51856e-01,9.85521e-02,4.07585e-02,4.62381e-01,9.67432e-02,3.99175e-02,4.67735e-01,
9.58645e-02,3.95126e-02,4.78630e-01,9.41739e-02,3.87495e-02,4.84172e-01,9.33518e-02,3.83815e-02,4.89779e-01,9.25444e-02,
3.80222e-02,4.95450e-01,9.17515e-02,3.76712e-02,5.01187e-01,9.09727e-02,3.73285e-02,5.01190e-01,9.09723e-02,3.73283e-02,
5.06991e-01,9.01845e-02,3.70148e-02,5.18800e-01,8.86481e-02,3.64080e-02,5.24808e-01,8.79066e-02,3.61217e-02,5.30884e-01,
8.71772e-02,3.58412e-02,5.37032e-01,8.64598e-02,3.55667e-02,5.43250e-01,8.57540e-02,3.52979e-02,5.49541e-01,8.50594e-02,
3.50345e-02,5.55904e-01,8.43758e-02,3.47763e-02,5.75440e-01,8.23901e-02,3.40336e-02,5.82103e-01,8.17543e-02,3.38012e-02,
5.88844e-01,8.11279e-02,3.35730e-02,5.95662e-01,8.05108e-02,3.33490e-02,6.09537e-01,7.93033e-02,3.29126e-02,6.16595e-01,
7.87125e-02,3.27001e-02,6.30957e-01,7.75569e-02,3.22867e-02,6.30960e-01,7.75567e-02,3.22866e-02,6.38264e-01,7.69698e-02,
3.21019e-02,6.45654e-01,7.63955e-02,3.19244e-02,6.51253e-01,7.59697e-02,3.17930e-02,6.53131e-01,7.58286e-02,3.17494e-02,
6.60694e-01,7.52690e-02,3.15769e-02,6.68344e-01,7.47166e-02,3.14066e-02,6.83912e-01,7.36332e-02,3.10727e-02,6.91831e-01,
7.31022e-02,3.09093e-02,6.99842e-01,7.25817e-02,3.07517e-02,7.07946e-01,7.20676e-02,3.05958e-02,7.16143e-01,7.15598e-02,
3.04417e-02,7.24436e-01,7.10580e-02,3.02892e-02,7.32825e-01,7.05623e-02,3.01384e-02,7.49894e-01,6.95883e-02,2.98415e-02,
7.58578e-01,6.91099e-02,2.96952e-02,7.67362e-01,6.86373e-02,2.95508e-02,7.76247e-01,6.81730e-02,2.94107e-02,7.85236e-01,
6.77140e-02,2.92717e-02,7.94328e-01,6.72600e-02,2.91340e-02,7.94330e-01,6.72599e-02,2.91340e-02,8.03526e-01,6.67924e-02,
2.90118e-02,8.31764e-01,6.54198e-02,2.86494e-02,8.41395e-01,6.49723e-02,2.85300e-02,8.51138e-01,6.45294e-02,2.84113e-02,
8.60994e-01,6.40932e-02,2.82950e-02,8.70964e-01,6.36615e-02,2.81792e-02,8.81049e-01,6.32341e-02,2.80639e-02,8.91251e-01,
6.28111e-02,2.79490e-02,9.01571e-01,6.23923e-02,2.78346e-02,9.12011e-01,6.19777e-02,2.77205e-02,9.22571e-01,6.15674e-02,
2.76071e-02,9.33254e-01,6.11611e-02,2.74941e-02,9.44061e-01,6.07588e-02,2.73815e-02,9.54993e-01,6.03626e-02,2.72714e-02,
9.66051e-01,5.99701e-02,2.71616e-02,9.77237e-01,5.95813e-02,2.70520e-02,9.88553e-01,5.91961e-02,2.69427e-02,1.00000e+00,
5.88144e-02,2.68337e-02,1.00000e-03,6.53549e+03,6.52870e+03,1.01021e-03,6.39028e+03,6.38351e+03,1.01158e-03,6.37115e+03,
6.36438e+03,1.02329e-03,6.21131e+03,6.20456e+03,1.03000e-03,6.12126e+03,6.11451e+03,1.04713e-03,5.89915e+03,5.89242e+03,
1.05925e-03,5.74919e+03,5.74248e+03,1.07152e-03,5.60217e+03,5.59548e+03,1.08393e-03,5.45905e+03,5.45237e+03,1.08693e-03,
5.42518e+03,5.41850e+03,1.12202e-03,5.05042e+03,5.04379e+03,1.13501e-03,4.91989e+03,4.91327e+03,1.15000e-03,4.77529e+03,
4.76869e+03,1.17490e-03,4.54831e+03,4.54174e+03,1.18850e-03,4.43038e+03,4.42383e+03,1.20660e-03,4.27954e+03,4.27300e+03,
1.23027e-03,4.09312e+03,4.08662e+03,1.24451e-03,3.98636e+03,3.97988e+03,1.25890e-03,3.88255e+03,3.87609e+03,1.25892e-03,
3.88238e+03,3.87591e+03,1.26255e-03,3.85681e+03,3.85034e+03,1.27000e-03,3.80510e+03,3.79865e+03,1.28825e-03,3.68149e+03,
3.67507e+03,1.30317e-03,3.58414e+03,3.57774e+03,1.32206e-03,3.46554e+03,3.45916e+03,1.33000e-03,3.41733e+03,3.41097e+03,
1.39637e-03,3.04993e+03,3.04368e+03,1.40000e-03,3.03152e+03,3.02527e+03,1.42889e-03,2.88967e+03,2.88347e+03,1.44544e-03,
2.81236e+03,2.80618e+03,1.46218e-03,2.73721e+03,2.73106e+03,1.47911e-03,2.66360e+03,2.65747e+03,1.54882e-03,2.38888e+03,
2.38285e+03,1.57000e-03,2.31364e+03,2.30765e+03,1.58000e-03,2.27880e+03,2.27281e+03,1.58489e-03,2.26202e+03,2.25604e+03,
1.58490e-03,2.26199e+03,2.25601e+03,1.58946e-03,2.24652e+03,2.24055e+03,1.61000e-03,2.17869e+03,2.17275e+03,1.62181e-03,
2.14091e+03,2.13498e+03,1.64059e-03,2.08248e+03,2.07658e+03,1.65000e-03,2.05407e+03,2.04818e+03,1.71791e-03,1.86472e+03,
1.85893e+03,1.73780e-03,1.81409e+03,1.80832e+03,1.74996e-03,1.78376e+03,1.77801e+03,1.75792e-03,1.76427e+03,1.75853e+03,
1.77828e-03,1.71573e+03,1.71003e+03,1.81970e-03,1.62275e+03,1.61711e+03,1.84077e-03,1.57808e+03,1.57247e+03,1.90546e-03,
1.45167e+03,1.44616e+03,1.91519e-03,1.43394e+03,1.42845e+03,1.92753e-03,1.41192e+03,1.40644e+03,1.94984e-03,1.37292e+03,
1.36748e+03,1.95000e-03,1.37266e+03,1.36722e+03,1.97242e-03,1.33479e+03,1.32938e+03,1.99526e-03,1.29764e+03,1.29226e+03,
1.99530e-03,1.29757e+03,1.29220e+03,2.00000e-03,1.29011e+03,1.28474e+03,2.00974e-03,1.27484e+03,1.26948e+03,2.01837e-03,
1.26153e+03,1.25619e+03,2.06538e-03,1.19218e+03,1.18691e+03,2.09715e-03,1.14844e+03,1.14321e+03,2.11349e-03,1.12682e+03,
1.12162e+03,2.13796e-03,1.09555e+03,1.09040e+03,2.15000e-03,1.08063e+03,1.07550e+03,2.16272e-03,1.06508e+03,1.05996e+03,
2.18776e-03,1.03528e+03,1.03021e+03,2.20277e-03,1.01793e+03,1.01288e+03,2.23872e-03,9.78003e+02,9.73011e+02,2.26464e-03,
9.50572e+02,9.45624e+02,2.30539e-03,9.09488e+02,9.04605e+02,2.31740e-03,8.97864e+02,8.93002e+02,2.34423e-03,8.72661e+02,
8.67845e+02,2.37137e-03,8.48193e+02,8.43424e+02,2.39883e-03,8.24433e+02,8.19710e+02,2.41141e-03,8.13797e+02,8.09095e+02,
2.42661e-03,8.01192e+02,7.96517e+02,2.50720e-03,7.38410e+02,7.33876e+02,2.51189e-03,7.34975e+02,7.30450e+02,2.51190e-03,
7.34965e+02,7.30440e+02,2.54097e-03,7.14139e+02,7.09668e+02,2.57040e-03,6.93885e+02,6.89468e+02,2.58194e-03,6.86154e+02,
6.81758e+02,2.60016e-03,6.74185e+02,6.69826e+02,2.63027e-03,6.55053e+02,6.50754e+02,2.66244e-03,6.35478e+02,6.31242e+02,
2.69154e-03,6.18464e+02,6.14291e+02,2.73448e-03,5.94290e+02,5.90209e+02,2.75423e-03,5.83611e+02,5.79577e+02,2.79396e-03,
5.62882e+02,5.58940e+02,2.81838e-03,5.50640e+02,5.46762e+02,2.84378e-03,5.38324e+02,5.34509e+02,2.85102e-03,5.34881e+02,
5.31086e+02,2.88403e-03,5.19522e+02,5.15819e+02,2.88997e-03,5.16827e+02,5.13140e+02,2.91743e-03,5.04605e+02,5.01004e+02,
2.93010e-03,4.99110e+02,4.95547e+02,2.96611e-03,4.83928e+02,4.80489e+02,2.99848e-03,4.70807e+02,4.67495e+02,3.00000e-03,
4.70201e+02,4.66895e+02,3.01995e-03,4.62319e+02,4.59102e+02,3.02213e-03,4.61467e+02,4.58260e+02,3.04574e-03,4.52334e+02,
4.49247e+02,3.06537e-03,4.44911e+02,4.41942e+02,3.08131e-03,4.38989e+02,4.36133e+02,3.09440e-03,4.34192e+02,4.31441e+02,
3.10987e-03,4.28598e+02,4.25984e+02,3.12608e-03,4.22842e+02,4.20371e+02,3.13147e-03,4.20950e+02,4.18524e+02,3.14125e-03,
4.17561e+02,4.15203e+02,3.14662e-03,4.15724e+02,4.13394e+02,3.15318e-03,4.13506e+02,4.11201e+02,3.16030e-03,4.11133e+02,
4.08839e+02,3.16228e-03,4.10479e+02,4.08185e+02,3.16230e-03,4.10472e+02,4.08178e+02,3.16657e-03,4.09069e+02,4.06773e+02,
3.17060e-03,4.07758e+02,4.05454e+02,3.17060e-03,1.37177e+03,1.32500e+03,3.17067e-03,1.37170e+03,1.32494e+03,3.17880e-03,
1.36343e+03,1.31702e+03,3.18651e-03,1.35569e+03,1.30958e+03,3.19719e-03,1.34507e+03,1.29936e+03,3.19889e-03,1.34339e+03,
1.29774e+03,3.21623e-03,1.32646e+03,1.28143e+03,3.22200e-03,1.32090e+03,1.27607e+03,3.23005e-03,1.31318e+03,1.26864e+03,
3.23594e-03,1.30757e+03,1.26324e+03,3.24065e-03,1.30310e+03,1.25894e+03,3.25143e-03,1.29295e+03,1.24919e+03,3.26110e-03,
1.28393e+03,1.24054e+03,3.27170e-03,1.27413e+03,1.23114e+03,3.27341e-03,1.27256e+03,1.22964e+03,3.27500e-03,1.27110e+03,
1.22824e+03,3.29000e-03,1.25590e+03,1.21367e+03,3.30113e-03,1.24588e+03,1.20407e+03,3.30969e-03,1.23826e+03,1.19676e+03,
3.31900e-03,1.23005e+03,1.18887e+03,3.32000e-03,1.22917e+03,1.18803e+03,3.32862e-03,1.22077e+03,1.17995e+03,3.33260e-03,
1.21692e+03,1.17624e+03,3.33260e-03,1.67506e+03,1.61056e+03,3.34392e-03,1.66041e+03,1.59658e+03,3.34965e-03,1.65305e+03,
1.58956e+03,3.37807e-03,1.61725e+03,1.55535e+03,3.38844e-03,1.60446e+03,1.54312e+03,3.39078e-03,1.60175e+03,1.54053e+03,
3.40492e-03,1.58548e+03,1.52500e+03,3.42027e-03,1.56806e+03,1.50838e+03,3.43778e-03,1.54850e+03,1.48973e+03,3.45000e-03,
1.53504e+03,1.47691e+03,3.45693e-03,1.52770e+03,1.46992e+03,3.47000e-03,1.51398e+03,1.45685e+03,3.47739e-03,1.50600e+03,
1.44926e+03,3.48000e-03,1.50320e+03,1.44659e+03,3.49744e-03,1.48376e+03,1.42807e+03,3.50752e-03,1.47268e+03,1.41751e+03,
3.54620e-03,1.43119e+03,1.37798e+03,3.54813e-03,1.42915e+03,1.37603e+03,3.55000e-03,1.42720e+03,1.37417e+03,3.56033e-03,
1.41675e+03,1.36421e+03,3.58000e-03,1.39717e+03,1.34552e+03,3.58000e-03,1.60222e+03,1.54183e+03,3.58185e-03,1.60025e+03,
1.53995e+03,3.58922e-03,1.59246e+03,1.53252e+03,3.60500e-03,1.57594e+03,1.51676e+03,3.60527e-03,1.57566e+03,1.51649e+03,
3.63078e-03,1.54951e+03,1.49153e+03,3.63464e-03,1.54554e+03,1.48774e+03,3.65229e-03,1.52757e+03,1.47058e+03,3.66719e-03,
1.51262e+03,1.45631e+03,3.67282e-03,1.50702e+03,1.45096e+03,3.69010e-03,1.49003e+03,1.43475e+03,3.70000e-03,1.48043e+03,
1.42558e+03,3.71535e-03,1.46542e+03,1.41126e+03,3.71692e-03,1.46390e+03,1.40981e+03,3.74816e-03,1.43406e+03,1.38133e+03,
3.75837e-03,1.42449e+03,1.37219e+03,3.77000e-03,1.41346e+03,1.36167e+03,3.78271e-03,1.40175e+03,1.35049e+03,3.84592e-03,
1.34549e+03,1.29676e+03,3.86455e-03,1.32934e+03,1.28133e+03,3.90000e-03,1.29934e+03,1.25268e+03,3.92000e-03,1.28284e+03,
1.23691e+03,3.94715e-03,1.26069e+03,1.21572e+03,3.98107e-03,1.23374e+03,1.18996e+03,3.98110e-03,1.23372e+03,1.18994e+03,
4.02717e-03,1.19840e+03,1.15615e+03,4.07096e-03,1.16616e+03,1.12530e+03,4.07380e-03,1.16412e+03,1.12334e+03,4.12097e-03,
1.13083e+03,1.09148e+03,4.21696e-03,1.06666e+03,1.03000e+03,4.22932e-03,1.05877e+03,1.02244e+03,4.26579e-03,1.03594e+03,
1.00055e+03,4.31519e-03,1.00609e+03,9.71925e+02,4.36516e-03,9.77006e+02,9.44022e+02,4.39431e-03,9.60470e+02,9.28154e+02,
4.41570e-03,9.48578e+02,9.16742e+02,4.57088e-03,8.68254e+02,8.39600e+02,4.57940e-03,8.64132e+02,8.35638e+02,4.62381e-03,
8.43055e+02,8.15384e+02,4.65000e-03,8.30969e+02,8.03766e+02,4.67735e-03,8.18579e+02,7.91852e+02,4.73151e-03,7.94802e+02,
7.68983e+02,4.80000e-03,7.66081e+02,7.41346e+02,4.81149e-03,7.61405e+02,7.36844e+02,4.84172e-03,7.49287e+02,7.25181e+02,
5.01187e-03,6.85927e+02,6.64158e+02,5.01190e-03,6.85918e+02,6.64149e+02,5.06991e-03,6.66035e+02,6.44984e+02,5.12861e-03,
6.46620e+02,6.26263e+02,5.15822e-03,6.37134e+02,6.17113e+02,5.18800e-03,6.27786e+02,6.08097e+02,5.24807e-03,6.09511e+02,
5.90466e+02,5.30884e-03,5.91720e+02,5.73297e+02,5.37032e-03,5.74471e+02,5.56644e+02,5.43250e-03,5.57730e+02,5.40477e+02,
5.50000e-03,5.40173e+02,5.23514e+02,5.55105e-03,5.27422e+02,5.11190e+02,5.68853e-03,4.95088e+02,4.79933e+02,5.75440e-03,
4.80517e+02,4.65841e+02,5.80000e-03,4.70785e+02,4.56426e+02,5.82103e-03,4.66355e+02,4.52139e+02,5.88844e-03,4.52548e+02,
4.38776e+02,5.95662e-03,4.39159e+02,4.25814e+02,5.98449e-03,4.33845e+02,4.20668e+02,6.02560e-03,4.26168e+02,4.13235e+02,
6.23735e-03,3.89443e+02,3.77660e+02,6.30957e-03,3.77904e+02,3.66475e+02,6.30960e-03,3.77899e+02,3.66471e+02,6.38263e-03,
3.66714e+02,3.55627e+02,6.45654e-03,3.55862e+02,3.45104e+02,6.53131e-03,3.45206e+02,3.34766e+02,6.55721e-03,3.41622e+02,
3.31289e+02,6.68344e-03,3.24867e+02,3.15033e+02,6.83912e-03,3.05629e+02,2.96359e+02,6.91831e-03,2.96436e+02,2.87433e+02,
7.00000e-03,2.87357e+02,2.78615e+02,7.16143e-03,2.70523e+02,2.62261e+02,7.24436e-03,2.62411e+02,2.54380e+02,7.32824e-03,
2.54548e+02,2.46741e+02,7.50000e-03,2.39459e+02,2.32076e+02,7.58578e-03,2.32345e+02,2.25159e+02,7.76247e-03,2.18599e+02,
2.11792e+02,7.80000e-03,2.15828e+02,2.09097e+02,7.85236e-03,2.12041e+02,2.05413e+02,7.94328e-03,2.05633e+02,1.99178e+02,
7.94330e-03,2.05632e+02,1.99177e+02,7.96235e-03,2.04323e+02,1.97904e+02,8.03526e-03,1.99418e+02,1.93132e+02,8.12830e-03,
1.93377e+02,1.87255e+02,8.22243e-03,1.87524e+02,1.81560e+02,8.31764e-03,1.81849e+02,1.76038e+02,8.60994e-03,1.65811e+02,
1.60425e+02,8.70964e-03,1.60795e+02,1.55542e+02,8.81049e-03,1.55909e+02,1.50783e+02,8.91251e-03,1.51176e+02,1.46173e+02,
9.01328e-03,1.46677e+02,1.41792e+02,9.22571e-03,1.37778e+02,1.33126e+02,9.33254e-03,1.33591e+02,1.29048e+02,9.44061e-03,
1.29535e+02,1.25098e+02,9.54993e-03,1.25607e+02,1.21272e+02,9.66051e-03,1.21799e+02,1.17563e+02,9.77237e-03,1.18084e+02,
1.13944e+02,1.00000e-02,1.11001e+02,1.07043e+02,1.01158e-02,1.07625e+02,1.03754e+02,1.01315e-02,1.07179e+02,1.03319e+02,
1.02329e-02,1.04351e+02,1.00565e+02,1.05925e-02,9.50646e+01,9.15211e+01,1.08393e-02,8.93303e+01,8.59361e+01,1.10918e-02,
8.39543e+01,8.07001e+01,1.11625e-02,8.25234e+01,7.93064e+01,1.13501e-02,7.88834e+01,7.57633e+01,1.15000e-02,7.61362e+01,
7.30894e+01,1.17490e-02,7.18589e+01,6.89264e+01,1.20226e-02,6.75361e+01,6.47197e+01,1.20847e-02,6.66076e+01,6.38162e+01,
1.21619e-02,6.54762e+01,6.27160e+01,1.24451e-02,6.15255e+01,5.88742e+01,1.25890e-02,5.96345e+01,5.70354e+01,1.25892e-02,
5.96312e+01,5.70323e+01,1.27350e-02,5.77971e+01,5.52491e+01,1.30258e-02,5.43574e+01,5.19052e+01,1.30317e-02,5.42910e+01,
5.18407e+01,1.33352e-02,5.09967e+01,4.86415e+01,1.35000e-02,4.93250e+01,4.70183e+01,1.38038e-02,4.64378e+01,4.42155e+01,
1.39794e-02,4.48782e+01,4.27020e+01,1.42889e-02,4.22987e+01,4.02014e+01,1.44544e-02,4.09991e+01,3.89418e+01,1.46218e-02,
3.97410e+01,3.77226e+01,1.47911e-02,3.85141e+01,3.65336e+01,1.50000e-02,3.70688e+01,3.51333e+01,1.50676e-02,3.66174e+01,
3.46960e+01,1.51356e-02,3.61697e+01,3.42629e+01,1.56675e-02,3.29200e+01,3.11200e+01,1.58489e-02,3.19049e+01,3.01388e+01,
1.58490e-02,3.19045e+01,3.01384e+01,1.62262e-02,2.99315e+01,2.82321e+01,1.64059e-02,2.90493e+01,2.73812e+01,1.65000e-02,
2.86023e+01,2.69503e+01,1.65959e-02,2.81551e+01,2.65190e+01,1.69824e-02,2.64480e+01,2.48735e+01,1.71791e-02,2.56281e+01,
2.40834e+01,1.73780e-02,2.48346e+01,2.33188e+01,1.75287e-02,2.42559e+01,2.27614e+01,1.75792e-02,2.40656e+01,2.25785e+01,
1.79887e-02,2.25977e+01,2.11678e+01,1.84077e-02,2.12221e+01,1.98467e+01,1.89010e-02,1.97496e+01,1.84336e+01,1.90546e-02,
1.93189e+01,1.80214e+01,1.92752e-02,1.87214e+01,1.74496e+01,1.99526e-02,1.70316e+01,1.58333e+01,1.99530e-02,1.70307e+01,
1.58325e+01,2.00000e-02,1.69214e+01,1.57280e+01,2.01837e-02,1.65017e+01,1.53279e+01,2.04174e-02,1.59883e+01,1.48388e+01,
2.08930e-02,1.50098e+01,1.39069e+01,2.09084e-02,1.49795e+01,1.38780e+01,2.16272e-02,1.36524e+01,1.26196e+01,2.18776e-02,
1.32267e+01,1.22182e+01,2.21309e-02,1.28148e+01,1.18297e+01,2.22186e-02,1.26755e+01,1.16984e+01,2.23872e-02,1.24118e+01,
1.14511e+01,2.26464e-02,1.20197e+01,1.10836e+01,2.26567e-02,1.20046e+01,1.10694e+01,2.30451e-02,1.14453e+01,1.05495e+01,
2.31740e-02,1.12655e+01,1.03843e+01,2.33088e-02,1.10815e+01,1.02153e+01,2.34309e-02,1.09164e+01,1.00654e+01,2.34423e-02,
1.09011e+01,1.00516e+01,2.35417e-02,1.07680e+01,9.93206e+00,2.36361e-02,1.06422e+01,9.82047e+00,2.37676e-02,1.04672e+01,
9.66766e+00,2.39883e-02,1.01773e+01,9.41844e+00,2.40000e-02,1.01623e+01,9.40550e+00,2.40686e-02,1.00746e+01,9.32980e+00,
2.41538e-02,9.96998e+00,9.23693e+00,2.42178e-02,9.89490e+00,9.16797e+00,2.42908e-02,9.81347e+00,9.09011e+00,2.43210e-02,
9.78159e+00,9.05821e+00,2.43210e-02,5.88800e+01,2.22024e+01,2.43559e-02,5.87429e+01,2.21980e+01,2.44324e-02,5.84481e+01,
2.21878e+01,2.44700e-02,5.83057e+01,2.21825e+01,2.44900e-02,5.81927e+01,2.21652e+01,2.45182e-02,5.80343e+01,2.21407e+01,
2.47896e-02,5.65488e+01,2.19026e+01,2.49043e-02,5.59364e+01,2.18008e+01,2.50000e-02,5.54301e+01,2.17153e+01,2.50256e-02,
5.52777e+01,2.16852e+01,2.51189e-02,5.47250e+01,2.15753e+01,2.51190e-02,5.47242e+01,2.15751e+01,2.51846e-02,5.43403e+01,
2.14979e+01,2.54011e-02,5.30931e+01,2.12427e+01,2.54097e-02,5.30443e+01,2.12326e+01,2.57040e-02,5.15595e+01,2.09611e+01,
2.57126e-02,5.15170e+01,2.09531e+01,2.60374e-02,4.99420e+01,2.06499e+01,2.62500e-02,4.89459e+01,2.04505e+01,2.63027e-02,
4.86887e+01,2.03947e+01,2.64718e-02,4.78751e+01,2.02155e+01,2.66073e-02,4.72363e+01,2.00723e+01,2.68851e-02,4.59627e+01,
1.97793e+01,2.69154e-02,4.58269e+01,1.97475e+01,2.75423e-02,4.31316e+01,1.90931e+01,2.76260e-02,4.27887e+01,1.90066e+01,
2.78612e-02,4.18437e+01,1.87645e+01,2.81838e-02,4.06215e+01,1.84482e+01,2.87718e-02,3.85191e+01,1.78804e+01,2.88403e-02,
3.82839e+01,1.78150e+01,2.95121e-02,3.60803e+01,1.71834e+01,2.98538e-02,3.50272e+01,1.68692e+01,3.00000e-02,3.45899e+01,
1.67364e+01,3.00154e-02,3.45443e+01,1.67224e+01,3.05492e-02,3.30104e+01,1.62445e+01,3.09030e-02,3.20462e+01,1.59349e+01,
3.16228e-02,3.01618e+01,1.53016e+01,3.16230e-02,3.01612e+01,1.53014e+01,3.16497e-02,3.00943e+01,1.52784e+01,3.27341e-02,
2.75401e+01,1.43746e+01,3.31131e-02,2.67186e+01,1.40725e+01,3.40000e-02,2.49250e+01,1.33930e+01,3.42768e-02,2.43934e+01,
1.31876e+01,3.50752e-02,2.29455e+01,1.26151e+01,3.54813e-02,2.22536e+01,1.23345e+01,3.69464e-02,1.99858e+01,1.13822e+01,
3.75837e-02,1.90982e+01,1.09957e+01,3.80189e-02,1.85160e+01,1.07366e+01,3.84592e-02,1.79518e+01,1.04821e+01,3.89045e-02,
1.74050e+01,1.02322e+01,3.93550e-02,1.68749e+01,9.98672e+00,3.94543e-02,1.67612e+01,9.93366e+00,3.98107e-02,1.63610e+01,
9.74595e+00,3.98110e-02,1.63607e+01,9.74580e+00,4.07380e-02,1.53799e+01,9.27813e+00,4.12097e-02,1.49114e+01,9.05075e+00,
4.16869e-02,1.44575e+01,8.82789e+00,4.26579e-02,1.35913e+01,8.39566e+00,4.26952e-02,1.35596e+01,8.37964e+00,4.31519e-02,
1.31779e+01,8.18620e+00,4.36516e-02,1.27774e+01,7.98113e+00,4.41570e-02,1.23892e+01,7.78041e+00,4.51856e-02,1.16484e+01,
7.39168e+00,4.62381e-02,1.09526e+01,7.01969e+00,4.67735e-02,1.06148e+01,6.83584e+00,4.78630e-02,9.97070e+00,6.48065e+00,
4.80000e-02,9.89358e+00,6.43771e+00,4.82031e-02,9.78063e+00,6.37465e+00,4.95450e-02,9.07703e+00,5.97775e+00,5.01187e-02,
8.79764e+00,5.81853e+00,5.01190e-02,8.79750e+00,5.81846e+00,5.12861e-02,8.26483e+00,5.51142e+00,5.30884e-02,7.52694e+00,
5.07812e+00,5.49541e-02,6.85574e+00,4.67583e+00,5.55904e-02,6.64591e+00,4.54832e+00,5.68853e-02,6.24580e+00,4.30283e+00,
5.80000e-02,5.92751e+00,4.10521e+00,5.85530e-02,5.77576e+00,4.01000e+00,5.88844e-02,5.68732e+00,3.95435e+00,6.09537e-02,
5.17567e+00,3.62914e+00,6.16595e-02,5.01589e+00,3.52641e+00,6.30957e-02,4.71142e+00,3.32908e+00,6.30960e-02,4.71137e+00,
3.32904e+00,6.45654e-02,4.42575e+00,3.14218e+00,6.60693e-02,4.15801e+00,2.96524e+00,6.76083e-02,3.90699e+00,2.79774e+00,
6.83912e-02,3.78744e+00,2.71739e+00,6.87297e-02,3.73729e+00,2.68357e+00,7.07946e-02,3.45060e+00,2.48907e+00,7.24436e-02,
3.24350e+00,2.34716e+00,7.32825e-02,3.14376e+00,2.27827e+00,7.49894e-02,2.95379e+00,2.14627e+00,7.94328e-02,2.52982e+00,
1.84776e+00,7.94330e-02,2.52981e+00,1.84775e+00,8.00000e-02,2.48200e+00,1.81379e+00,8.22243e-02,2.30644e+00,1.68859e+00,
8.61254e-02,2.03875e+00,1.49564e+00,8.70964e-02,1.97909e+00,1.45231e+00,9.01571e-02,1.80675e+00,1.32640e+00,9.22571e-02,
1.69996e+00,1.24773e+00,9.88553e-02,1.41862e+00,1.03833e+00,1.00000e-01,1.37687e+00,1.00698e+00,1.01158e-01,1.33639e+00,
9.76604e-01,1.05925e-01,1.18696e+00,8.63860e-01,1.08393e-01,1.11926e+00,8.12466e-01,1.09648e-01,1.08703e+00,7.87930e-01,
1.10400e-01,1.06838e+00,7.73717e-01,1.10918e-01,1.05582e+00,7.64141e-01,1.12202e-01,1.02561e+00,7.41074e-01,1.16145e-01,
9.40645e-01,6.76003e-01,1.18850e-01,8.88452e-01,6.35868e-01,1.23027e-01,8.16010e-01,5.79935e-01,1.24452e-01,7.93395e-01,
5.62426e-01,1.25890e-01,7.71544e-01,5.45487e-01,1.25893e-01,7.71507e-01,5.45458e-01,1.27350e-01,7.50245e-01,5.29041e-01,
1.28825e-01,7.29660e-01,5.13130e-01,1.30317e-01,7.09733e-01,4.97711e-01,1.31826e-01,6.90441e-01,4.82769e-01,1.33373e-01,
6.71503e-01,4.68087e-01,1.36458e-01,6.36115e-01,4.40645e-01,1.42889e-01,5.71394e-01,3.90345e-01,1.44544e-01,5.56479e-01,
3.78735e-01,1.47911e-01,5.28053e-01,3.56590e-01,1.53109e-01,4.88697e-01,3.25900e-01,1.54882e-01,4.76399e-01,3.16303e-01,
1.58489e-01,4.52954e-01,2.98003e-01,1.58490e-01,4.52950e-01,2.98000e-01,1.60324e-01,4.41722e-01,2.89311e-01,1.64451e-01,
4.18158e-01,2.71084e-01,1.65959e-01,4.10080e-01,2.64845e-01,1.67880e-01,4.00177e-01,2.57198e-01,1.69824e-01,3.90582e-01,
2.49791e-01,1.73780e-01,3.72283e-01,2.35671e-01,1.77828e-01,3.55102e-01,2.22426e-01,1.81970e-01,3.38970e-01,2.10004e-01,
1.86209e-01,3.23820e-01,1.98353e-01,1.88365e-01,3.16594e-01,1.92801e-01,1.90546e-01,3.09590e-01,1.87426e-01,1.94984e-01,
2.96221e-01,1.77178e-01,1.97242e-01,2.89893e-01,1.72344e-01,1.99526e-01,2.83759e-01,1.67661e-01,1.99530e-01,2.83749e-01,
1.67654e-01,2.02751e-01,2.75454e-01,1.61426e-01,2.04174e-01,2.71936e-01,1.58792e-01,2.06538e-01,2.66284e-01,1.54566e-01,
2.08930e-01,2.60801e-01,1.50472e-01,2.11349e-01,2.55482e-01,1.46507e-01,2.13796e-01,2.50326e-01,1.42671e-01,2.16272e-01,
2.45323e-01,1.38955e-01,2.21309e-01,2.35758e-01,1.31868e-01,2.23872e-01,2.31186e-01,1.28491e-01,2.26464e-01,2.26750e-01,
1.25221e-01,2.29087e-01,2.22444e-01,1.22053e-01,2.31740e-01,2.18265e-01,1.18984e-01,2.37137e-01,2.10269e-01,1.13133e-01,
2.39883e-01,2.06445e-01,1.10344e-01,2.40000e-01,2.06286e-01,1.10228e-01,2.42661e-01,2.02770e-01,1.07678e-01,2.45471e-01,
1.99201e-01,1.05095e-01,2.48313e-01,1.95734e-01,1.02592e-01,2.51189e-01,1.92365e-01,1.00167e-01,2.51190e-01,1.92364e-01,
1.00166e-01,2.52830e-01,1.90478e-01,9.88439e-02,2.54097e-01,1.89050e-01,9.78440e-02,2.57040e-01,1.85828e-01,9.55930e-02,
2.66073e-01,1.76691e-01,8.92498e-02,2.66358e-01,1.76420e-01,8.90627e-02,2.69154e-01,1.73812e-01,8.72672e-02,2.72270e-01,
1.71013e-01,8.53459e-02,2.75423e-01,1.68290e-01,8.34837e-02,2.78612e-01,1.65642e-01,8.16789e-02,2.81838e-01,1.63066e-01,
7.99296e-02,2.91743e-01,1.55829e-01,7.50732e-02,2.95121e-01,1.53544e-01,7.35513e-02,2.98538e-01,1.51319e-01,7.20752e-02,
3.00000e-01,1.50394e-01,7.14628e-02,3.05492e-01,1.47045e-01,6.92562e-02,3.12608e-01,1.42990e-01,6.66041e-02,3.16228e-01,
1.41044e-01,6.53397e-02,3.16230e-01,1.41043e-01,6.53389e-02,3.23594e-01,1.37231e-01,6.29732e-02,3.27341e-01,1.35418e-01,
6.18625e-02,3.31131e-01,1.33649e-01,6.07844e-02,3.34965e-01,1.31923e-01,5.97378e-02,3.38844e-01,1.30239e-01,5.87216e-02,
3.42768e-01,1.28596e-01,5.77350e-02,3.46737e-01,1.26993e-01,5.67771e-02,3.50752e-01,1.25429e-01,5.58473e-02,3.58922e-01,
1.22412e-01,5.40676e-02,3.63078e-01,1.20958e-01,5.32176e-02,3.67282e-01,1.19539e-01,5.23919e-02,3.71535e-01,1.18168e-01,
5.16049e-02,3.75837e-01,1.16829e-01,5.08399e-02,3.78807e-01,1.15930e-01,5.03293e-02,3.80189e-01,1.15519e-01,5.00962e-02,
3.84592e-01,1.14238e-01,4.93733e-02,3.89045e-01,1.12985e-01,4.86704e-02,3.93550e-01,1.11761e-01,4.79868e-02,3.98107e-01,
1.10564e-01,4.73223e-02,3.98110e-01,1.10563e-01,4.73219e-02,4.02717e-01,1.09365e-01,4.66992e-02,4.07380e-01,1.08192e-01,
4.60932e-02,4.12098e-01,1.07046e-01,4.55050e-02,4.16869e-01,1.05936e-01,4.49447e-02,4.21697e-01,1.04849e-01,4.43991e-02,
4.26580e-01,1.03785e-01,4.38679e-02,4.36516e-01,1.01721e-01,4.28463e-02,4.41570e-01,1.00720e-01,4.23552e-02,4.51856e-01,
9.87782e-02,4.14108e-02,4.57088e-01,9.78359e-02,4.09566e-02,4.62381e-01,9.69131e-02,4.05149e-02,4.73151e-01,9.51397e-02,
3.96827e-02,4.84172e-01,9.34319e-02,3.88900e-02,4.95450e-01,9.17863e-02,3.81345e-02,5.01187e-01,9.09861e-02,3.77702e-02,
5.01190e-01,9.09857e-02,3.77701e-02,5.06991e-01,9.01766e-02,3.74347e-02,5.12861e-01,8.93813e-02,3.71067e-02,5.24808e-01,
8.78487e-02,3.64892e-02,5.30884e-01,8.71017e-02,3.61903e-02,5.37032e-01,8.63671e-02,3.58977e-02,5.43250e-01,8.56446e-02,
3.56112e-02,5.49541e-01,8.49340e-02,3.53307e-02,5.55904e-01,8.42350e-02,3.50561e-02,5.68853e-01,8.28706e-02,3.45236e-02,
5.70930e-01,8.26608e-02,3.44434e-02,5.82103e-01,8.15615e-02,3.40253e-02,5.88844e-01,8.09218e-02,3.37831e-02,5.95662e-01,
8.02917e-02,3.35454e-02,6.02560e-01,7.96711e-02,3.33121e-02,6.09537e-01,7.90597e-02,3.30829e-02,6.16595e-01,7.84574e-02,
3.28580e-02,6.23735e-01,7.78639e-02,3.26370e-02,6.30957e-01,7.72789e-02,3.24199e-02,6.30960e-01,7.72787e-02,3.24198e-02,
6.38264e-01,7.66866e-02,3.22283e-02,6.45654e-01,7.61024e-02,3.20396e-02,6.53131e-01,7.55261e-02,3.18536e-02,6.60694e-01,
7.49576e-02,3.16704e-02,6.76083e-01,7.38434e-02,3.13116e-02,6.83912e-01,7.32973e-02,3.11360e-02,6.91831e-01,7.27627e-02,
3.09670e-02,6.99842e-01,7.22349e-02,3.08000e-02,7.07946e-01,7.17141e-02,3.06355e-02,7.16143e-01,7.11998e-02,3.04730e-02,
7.24436e-01,7.06918e-02,3.03123e-02,7.32825e-01,7.01901e-02,3.01536e-02,7.41310e-01,6.96944e-02,2.99966e-02,7.49894e-01,
6.92048e-02,2.98414e-02,7.58578e-01,6.87210e-02,2.96880e-02,7.67362e-01,6.82463e-02,2.95394e-02,7.76247e-01,6.77770e-02,
2.93922e-02,7.85236e-01,6.73134e-02,2.92468e-02,7.94328e-01,6.68550e-02,2.91027e-02,7.94330e-01,6.68549e-02,2.91027e-02,
8.03526e-01,6.63839e-02,2.89744e-02,8.22243e-01,6.54573e-02,2.87203e-02,8.41395e-01,6.45508e-02,2.84694e-02,8.51138e-01,
6.41073e-02,2.83474e-02,8.60994e-01,6.36688e-02,2.82262e-02,8.70964e-01,6.32348e-02,2.81057e-02,8.91251e-01,6.23803e-02,
2.78665e-02,9.01571e-01,6.19597e-02,2.77477e-02,9.12011e-01,6.15433e-02,2.76294e-02,9.22571e-01,6.11311e-02,2.75117e-02,
9.31626e-01,6.07848e-02,2.74124e-02,9.33254e-01,6.07231e-02,2.73946e-02,9.44061e-01,6.03193e-02,2.72783e-02,9.54993e-01,
5.99219e-02,2.71648e-02,9.66051e-01,5.95283e-02,2.70517e-02,9.77237e-01,5.91385e-02,2.69389e-02,9.88553e-01,5.87524e-02,
2.68265e-02,1.00000e+00,5.83699e-02,2.67145e-02,1.00000e-03,7.03925e+03,7.03221e+03,1.02329e-03,6.69336e+03,6.68634e+03,
1.04713e-03,6.36193e+03,6.35494e+03,1.05925e-03,6.20121e+03,6.19423e+03,1.06036e-03,6.18679e+03,6.17982e+03,1.07152e-03,
6.04416e+03,6.03720e+03,1.08393e-03,5.89008e+03,5.88314e+03,1.11000e-03,5.58462e+03,5.57771e+03,1.13000e-03,5.36347e+03,
5.35658e+03,1.14815e-03,5.17329e+03,5.16643e+03,1.16864e-03,4.96939e+03,4.96255e+03,1.17490e-03,4.90938e+03,4.90255e+03,
1.19000e-03,4.76852e+03,4.76171e+03,1.20226e-03,4.65851e+03,4.65173e+03,1.21619e-03,4.53803e+03,4.53127e+03,1.23027e-03,
4.42088e+03,4.41413e+03,1.24451e-03,4.30666e+03,4.29994e+03,1.25890e-03,4.19441e+03,4.18770e+03,1.25892e-03,4.19422e+03,
4.18751e+03,1.26437e-03,4.15280e+03,4.14610e+03,1.27350e-03,4.08470e+03,4.07801e+03,1.28825e-03,3.97829e+03,3.97163e+03,
1.33352e-03,3.67229e+03,3.66571e+03,1.35000e-03,3.56925e+03,3.56269e+03,1.38038e-03,3.38955e+03,3.38303e+03,1.40000e-03,
3.27967e+03,3.27318e+03,1.41254e-03,3.21168e+03,3.20521e+03,1.43611e-03,3.08880e+03,3.08236e+03,1.46218e-03,2.96056e+03,
2.95416e+03,1.47911e-03,2.88128e+03,2.87491e+03,1.50000e-03,2.78762e+03,2.78127e+03,1.51356e-03,2.72920e+03,2.72287e+03,
1.54882e-03,2.58557e+03,2.57929e+03,1.56675e-03,2.51623e+03,2.50998e+03,1.57000e-03,2.50397e+03,2.49771e+03,1.57394e-03,
2.48914e+03,2.48289e+03,1.58489e-03,2.44851e+03,2.44228e+03,1.58490e-03,2.44848e+03,2.44225e+03,1.62181e-03,2.31757e+03,
2.31139e+03,1.64059e-03,2.25470e+03,2.24854e+03,1.64237e-03,2.24889e+03,2.24273e+03,1.69824e-03,2.07650e+03,2.07043e+03,
1.71791e-03,2.02044e+03,2.01441e+03,1.75792e-03,1.91155e+03,1.90557e+03,1.77828e-03,1.85911e+03,1.85316e+03,1.79887e-03,
1.80798e+03,1.80206e+03,1.80615e-03,1.79040e+03,1.78449e+03,1.81970e-03,1.75829e+03,1.75240e+03,1.88365e-03,1.61756e+03,
1.61177e+03,1.90546e-03,1.57334e+03,1.56758e+03,1.92753e-03,1.53011e+03,1.52438e+03,1.97242e-03,1.44676e+03,1.44110e+03,
1.98250e-03,1.42886e+03,1.42321e+03,1.99526e-03,1.40663e+03,1.40100e+03,1.99530e-03,1.40656e+03,1.40093e+03,2.01837e-03,
1.36760e+03,1.36201e+03,2.04174e-03,1.32972e+03,1.32416e+03,2.07000e-03,1.28589e+03,1.28037e+03,2.11349e-03,1.22233e+03,
1.21688e+03,2.13796e-03,1.18830e+03,1.18289e+03,2.16272e-03,1.15526e+03,1.14988e+03,2.17827e-03,1.13508e+03,1.12972e+03,
2.18776e-03,1.12301e+03,1.11766e+03,2.23872e-03,1.06083e+03,1.05556e+03,2.28057e-03,1.01344e+03,1.00823e+03,2.29087e-03,
1.00222e+03,9.97037e+02,2.37137e-03,9.20570e+02,9.15507e+02,2.37705e-03,9.15145e+02,9.10091e+02,2.39883e-03,8.94748e+02,
8.89729e+02,2.40000e-03,8.93674e+02,8.88658e+02,2.42661e-03,8.69510e+02,8.64536e+02,2.45471e-03,8.44916e+02,8.39987e+02,
2.47868e-03,8.24652e+02,8.19761e+02,2.48313e-03,8.20966e+02,8.16083e+02,2.51189e-03,7.97745e+02,7.92910e+02,2.51190e-03,
7.97734e+02,7.92899e+02,2.57040e-03,7.53259e+02,7.48519e+02,2.58640e-03,7.41729e+02,7.37014e+02,2.63027e-03,7.11369e+02,
7.06731e+02,2.68634e-03,6.74882e+02,6.70338e+02,2.69154e-03,6.71630e+02,6.67096e+02,2.72270e-03,6.52559e+02,6.48083e+02,
2.75423e-03,6.33949e+02,6.29531e+02,2.77212e-03,6.23682e+02,6.19296e+02,2.84973e-03,5.81724e+02,5.77493e+02,2.85102e-03,
5.81062e+02,5.76833e+02,2.88403e-03,5.64466e+02,5.60309e+02,2.91661e-03,5.48741e+02,5.44652e+02,2.91743e-03,5.48353e+02,
5.44266e+02,2.95121e-03,5.32713e+02,5.28704e+02,2.97749e-03,5.20910e+02,5.16961e+02,3.00000e-03,5.11081e+02,5.07188e+02,
3.02379e-03,5.00956e+02,4.97122e+02,3.05492e-03,4.88112e+02,4.84365e+02,3.07477e-03,4.80165e+02,4.76472e+02,3.09030e-03,
4.74067e+02,4.70423e+02,3.11485e-03,4.64610e+02,4.61041e+02,3.14657e-03,4.52765e+02,4.49305e+02,3.16228e-03,4.47045e+02,
4.43647e+02,3.16230e-03,4.47037e+02,4.43639e+02,3.17825e-03,4.41334e+02,4.37996e+02,3.20854e-03,4.30751e+02,4.27549e+02,
3.23164e-03,4.22893e+02,4.19812e+02,3.23594e-03,4.21448e+02,4.18395e+02,3.24996e-03,4.16782e+02,4.13816e+02,3.26495e-03,
4.11853e+02,4.08997e+02,3.27341e-03,4.09100e+02,4.06312e+02,3.27555e-03,4.08405e+02,4.05634e+02,3.30866e-03,3.97825e+02,
3.95330e+02,3.31891e-03,3.94640e+02,3.92212e+02,3.32466e-03,3.92877e+02,3.90478e+02,3.33160e-03,3.90778e+02,3.88404e+02,
3.33982e-03,3.88321e+02,3.85960e+02,3.34602e-03,3.86498e+02,3.84134e+02,3.34965e-03,3.85441e+02,3.83069e+02,3.35000e-03,
3.85340e+02,3.82968e+02,3.35000e-03,1.27855e+03,1.23171e+03,3.35314e-03,1.27572e+03,1.22901e+03,3.35826e-03,1.27113e+03,
1.22462e+03,3.36713e-03,1.26325e+03,1.21707e+03,3.37870e-03,1.25309e+03,1.20732e+03,3.38844e-03,1.24464e+03,1.19920e+03,
3.40049e-03,1.23431e+03,1.18926e+03,3.40837e-03,1.22761e+03,1.18283e+03,3.41897e-03,1.21868e+03,1.17425e+03,3.42768e-03,
1.21140e+03,1.16727e+03,3.42932e-03,1.21003e+03,1.16596e+03,3.44264e-03,1.19900e+03,1.15540e+03,3.45504e-03,1.18885e+03,
1.14569e+03,3.47000e-03,1.17674e+03,1.13414e+03,3.47949e-03,1.16802e+03,1.12581e+03,3.49582e-03,1.15322e+03,1.11168e+03,
3.50460e-03,1.14537e+03,1.10418e+03,3.50752e-03,1.14278e+03,1.10171e+03,3.51313e-03,1.13783e+03,1.09697e+03,3.52269e-03,
1.12945e+03,1.08894e+03,3.52810e-03,1.12476e+03,1.08444e+03,3.52810e-03,1.54255e+03,1.47868e+03,3.53912e-03,1.53044e+03,
1.46718e+03,3.55000e-03,1.51863e+03,1.45594e+03,3.57988e-03,1.48905e+03,1.42780e+03,3.59457e-03,1.47480e+03,1.41424e+03,
3.60612e-03,1.46374e+03,1.40372e+03,3.62000e-03,1.45057e+03,1.39121e+03,3.62130e-03,1.44930e+03,1.38999e+03,3.63078e-03,
1.44002e+03,1.38118e+03,3.64054e-03,1.43056e+03,1.37219e+03,3.65000e-03,1.42147e+03,1.36356e+03,3.66170e-03,1.40949e+03,
1.35218e+03,3.67282e-03,1.39823e+03,1.34148e+03,3.68273e-03,1.38829e+03,1.33204e+03,3.69000e-03,1.38105e+03,1.32517e+03,
3.72047e-03,1.35256e+03,1.29813e+03,3.75091e-03,1.32492e+03,1.27189e+03,3.75837e-03,1.31827e+03,1.26557e+03,3.76671e-03,
1.31089e+03,1.25855e+03,3.78340e-03,1.29631e+03,1.24468e+03,3.78340e-03,1.48818e+03,1.42765e+03,3.79011e-03,1.48185e+03,
1.42163e+03,3.80189e-03,1.47084e+03,1.41118e+03,3.84592e-03,1.43022e+03,1.37254e+03,3.85320e-03,1.42364e+03,1.36629e+03,
3.87137e-03,1.40744e+03,1.35087e+03,3.89159e-03,1.38970e+03,1.33400e+03,3.92213e-03,1.36348e+03,1.30908e+03,3.93550e-03,
1.35221e+03,1.29837e+03,3.95539e-03,1.33538e+03,1.28236e+03,3.98107e-03,1.31407e+03,1.26210e+03,3.98110e-03,1.31405e+03,
1.26208e+03,4.00000e-03,1.29867e+03,1.24745e+03,4.02934e-03,1.27531e+03,1.22524e+03,4.07380e-03,1.24102e+03,1.19261e+03,
4.08000e-03,1.23634e+03,1.18816e+03,4.11061e-03,1.21353e+03,1.16644e+03,4.12097e-03,1.20593e+03,1.15921e+03,4.16869e-03,
1.17180e+03,1.12671e+03,4.21696e-03,1.13830e+03,1.09478e+03,4.22912e-03,1.13007e+03,1.08694e+03,4.26579e-03,1.10575e+03,
1.06376e+03,4.31519e-03,1.07383e+03,1.03332e+03,4.32927e-03,1.06497e+03,1.02487e+03,4.40000e-03,1.02200e+03,9.83861e+02,
4.44519e-03,9.95832e+02,9.58872e+02,4.50000e-03,9.65327e+02,9.29738e+02,4.51856e-03,9.55256e+02,9.20115e+02,4.57088e-03,
9.27644e+02,8.93722e+02,4.61431e-03,9.05549e+02,8.72594e+02,4.62381e-03,9.00810e+02,8.68061e+02,4.73151e-03,8.49139e+02,
8.18621e+02,4.78463e-03,8.25179e+02,7.95683e+02,4.78630e-03,8.24442e+02,7.94977e+02,4.84172e-03,8.00479e+02,7.72031e+02,
4.89779e-03,7.77233e+02,7.49760e+02,4.90000e-03,7.76335e+02,7.48900e+02,4.98755e-03,7.41864e+02,7.15855e+02,5.01187e-03,
7.32667e+02,7.07036e+02,5.01190e-03,7.32656e+02,7.07026e+02,5.12861e-03,6.90697e+02,6.66775e+02,5.18800e-03,6.70649e+02,
6.47531e+02,5.24807e-03,6.51167e+02,6.28821e+02,5.30884e-03,6.32264e+02,6.10660e+02,5.33784e-03,6.23460e+02,6.02198e+02,
5.37032e-03,6.13798e+02,5.92913e+02,5.43250e-03,5.95873e+02,5.75682e+02,5.50000e-03,5.77247e+02,5.57769e+02,5.55904e-03,
5.61562e+02,5.42678e+02,5.68853e-03,5.29303e+02,5.11624e+02,5.69779e-03,5.27080e+02,5.09484e+02,5.88844e-03,4.84079e+02,
4.68060e+02,5.95662e-03,4.69886e+02,4.54377e+02,6.00000e-03,4.61160e+02,4.45963e+02,6.02560e-03,4.56116e+02,4.41098e+02,
6.09537e-03,4.42655e+02,4.28112e+02,6.15708e-03,4.31159e+02,4.17017e+02,6.16595e-03,4.29541e+02,4.15455e+02,6.23735e-03,
4.16823e+02,4.03182e+02,6.30957e-03,4.04495e+02,3.91279e+02,6.30960e-03,4.04490e+02,3.91275e+02,6.38263e-03,3.92541e+02,
3.79736e+02,6.45654e-03,3.80944e+02,3.68533e+02,6.50000e-03,3.74325e+02,3.62137e+02,6.68344e-03,3.48099e+02,3.36785e+02,
6.76083e-03,3.37672e+02,3.26699e+02,6.79008e-03,3.33844e+02,3.22995e+02,6.80000e-03,3.32559e+02,3.21753e+02,6.99842e-03,
3.08247e+02,2.98230e+02,7.00000e-03,3.08064e+02,2.98053e+02,7.16143e-03,2.90110e+02,2.80673e+02,7.32824e-03,2.72952e+02,
2.64053e+02,7.41310e-03,2.64769e+02,2.56124e+02,7.48968e-03,2.57679e+02,2.49253e+02,7.50000e-03,2.56743e+02,2.48346e+02,
7.58578e-03,2.49147e+02,2.40986e+02,7.67362e-03,2.41659e+02,2.33728e+02,7.76247e-03,2.34402e+02,2.26693e+02,7.85236e-03,
2.27365e+02,2.19870e+02,7.94328e-03,2.20499e+02,2.13210e+02,7.94330e-03,2.20497e+02,2.13209e+02,8.12830e-03,2.07401e+02,
2.00503e+02,8.31764e-03,1.95106e+02,1.88571e+02,8.34283e-03,1.93549e+02,1.87060e+02,8.51138e-03,1.83557e+02,1.77362e+02,
8.60994e-03,1.78044e+02,1.72011e+02,8.70964e-03,1.72652e+02,1.66776e+02,8.81049e-03,1.67411e+02,1.61686e+02,8.91251e-03,
1.62326e+02,1.56747e+02,9.01571e-03,1.57374e+02,1.51937e+02,9.22571e-03,1.47936e+02,1.42766e+02,9.40348e-03,1.40559e+02,
1.35597e+02,9.44061e-03,1.39083e+02,1.34163e+02,9.54993e-03,1.34862e+02,1.30062e+02,9.88553e-03,1.22968e+02,1.18503e+02,
1.00000e-02,1.19248e+02,1.14888e+02,1.01158e-02,1.15643e+02,1.11384e+02,1.02329e-02,1.12124e+02,1.07963e+02,1.04713e-02,
1.05410e+02,1.01436e+02,1.05083e-02,1.04408e+02,1.00461e+02,1.07152e-02,9.90449e+01,9.52486e+01,1.08000e-02,9.69578e+01,
9.32199e+01,1.12202e-02,8.74716e+01,8.39991e+01,1.14815e-02,8.22194e+01,7.88938e+01,1.15232e-02,8.14230e+01,7.81197e+01,
1.16145e-02,7.97149e+01,7.64605e+01,1.17490e-02,7.72885e+01,7.41036e+01,1.18850e-02,7.49310e+01,7.18135e+01,1.19000e-02,
7.46776e+01,7.15674e+01,1.20226e-02,7.26362e+01,6.95843e+01,1.23027e-02,6.82560e+01,6.53293e+01,1.24451e-02,6.61561e+01,
6.32894e+01,1.25890e-02,6.41278e+01,6.13192e+01,1.25892e-02,6.41244e+01,6.13159e+01,1.27350e-02,6.21556e+01,5.94037e+01,
1.27962e-02,6.13551e+01,5.86263e+01,1.28825e-02,6.02493e+01,5.75532e+01,1.30317e-02,5.84032e+01,5.57620e+01,1.33352e-02,
5.48839e+01,5.23477e+01,1.36458e-02,5.15657e+01,4.91289e+01,1.37984e-02,5.00391e+01,4.76483e+01,1.40000e-02,4.81148e+01,
4.57838e+01,1.41254e-02,4.69666e+01,4.46714e+01,1.42889e-02,4.55163e+01,4.32662e+01,1.46218e-02,4.27537e+01,4.05902e+01,
1.47911e-02,4.14383e+01,3.93164e+01,1.49565e-02,4.02079e+01,3.81251e+01,1.49624e-02,4.01649e+01,3.80836e+01,1.53109e-02,
3.77356e+01,3.57346e+01,1.54882e-02,3.65788e+01,3.46164e+01,1.56675e-02,3.54506e+01,3.35258e+01,1.58489e-02,3.43588e+01,
3.24707e+01,1.58490e-02,3.43584e+01,3.24703e+01,1.60324e-02,3.33012e+01,3.14488e+01,1.61051e-02,3.28954e+01,3.10569e+01,
1.62181e-02,3.22767e+01,3.04601e+01,1.64059e-02,3.12836e+01,2.95023e+01,1.65959e-02,3.03179e+01,2.85711e+01,1.67880e-02,
2.93821e+01,2.76688e+01,1.69824e-02,2.84762e+01,2.67957e+01,1.71791e-02,2.75968e+01,2.59482e+01,1.73000e-02,2.70749e+01,
2.54454e+01,1.73816e-02,2.67306e+01,2.51137e+01,1.77828e-02,2.51212e+01,2.35660e+01,1.79887e-02,2.43479e+01,2.28228e+01,
1.81970e-02,2.35994e+01,2.21036e+01,1.86209e-02,2.21631e+01,2.07237e+01,1.87075e-02,2.18844e+01,2.04561e+01,1.88365e-02,
2.14780e+01,2.00666e+01,1.92752e-02,2.01719e+01,1.88154e+01,1.94985e-02,1.95475e+01,1.82174e+01,1.97242e-02,1.89425e+01,
1.76383e+01,1.99526e-02,1.83573e+01,1.70782e+01,1.99530e-02,1.83563e+01,1.70773e+01,2.01069e-02,1.79760e+01,1.67135e+01,
2.01837e-02,1.77899e+01,1.65359e+01,2.04174e-02,1.72399e+01,1.60112e+01,2.06538e-02,1.67062e+01,1.55023e+01,2.08930e-02,
1.61897e+01,1.50100e+01,2.11349e-02,1.56899e+01,1.45337e+01,2.12306e-02,1.54968e+01,1.43497e+01,2.16272e-02,1.47290e+01,
1.36205e+01,2.21309e-02,1.38281e+01,1.27653e+01,2.21494e-02,1.37966e+01,1.27355e+01,2.23872e-02,1.33977e+01,1.23585e+01,
2.26464e-02,1.29810e+01,1.19649e+01,2.28679e-02,1.26378e+01,1.16406e+01,2.29087e-02,1.25756e+01,1.15822e+01,2.34317e-02,
1.18152e+01,1.08678e+01,2.34423e-02,1.18004e+01,1.08540e+01,2.37137e-02,1.14291e+01,1.05075e+01,2.38470e-02,1.12529e+01,
1.03431e+01,2.40525e-02,1.09868e+01,1.00964e+01,2.42661e-02,1.07167e+01,9.84824e+00,2.43815e-02,1.05738e+01,9.71687e+00,
2.45265e-02,1.03956e+01,9.55505e+00,2.45471e-02,1.03704e+01,9.53243e+00,2.46496e-02,1.02457e+01,9.42046e+00,2.47541e-02,
1.01192e+01,9.30821e+00,2.48906e-02,9.95431e+00,9.16432e+00,2.51031e-02,9.69957e+00,8.94614e+00,2.51189e-02,9.68116e+00,
8.93029e+00,2.51190e-02,9.68100e+00,8.93015e+00,2.52367e-02,9.54477e+00,8.81272e+00,2.53297e-02,9.44212e+00,8.72140e+00,
2.54097e-02,9.35840e+00,8.64379e+00,2.54890e-02,9.28043e+00,8.56790e+00,2.54890e-02,5.54179e+01,2.04711e+01,2.54921e-02,
5.54022e+01,2.04692e+01,2.55619e-02,5.50550e+01,2.04268e+01,2.56582e-02,5.45853e+01,2.03675e+01,2.58059e-02,5.38822e+01,
2.02752e+01,2.60016e-02,5.29740e+01,2.01504e+01,2.60097e-02,5.29369e+01,2.01452e+01,2.61000e-02,5.25244e+01,2.00867e+01,
2.61030e-02,5.25083e+01,2.00838e+01,2.62386e-02,5.17943e+01,1.99556e+01,2.64102e-02,5.09053e+01,1.97924e+01,2.65308e-02,
5.02914e+01,1.96775e+01,2.66073e-02,4.99066e+01,1.96045e+01,2.66688e-02,4.95998e+01,1.95457e+01,2.67000e-02,4.94450e+01,
1.95158e+01,2.69154e-02,4.84760e+01,1.93427e+01,2.70051e-02,4.80801e+01,1.92702e+01,2.72270e-02,4.71181e+01,1.90901e+01,
2.73293e-02,4.66842e+01,1.90068e+01,2.75423e-02,4.57968e+01,1.88329e+01,2.77532e-02,4.48901e+01,1.86385e+01,2.78612e-02,
4.44345e+01,1.85389e+01,2.84594e-02,4.20229e+01,1.80024e+01,2.85102e-02,4.18263e+01,1.79570e+01,2.91743e-02,3.93702e+01,
1.73677e+01,2.94060e-02,3.85606e+01,1.71643e+01,2.95121e-02,3.81971e+01,1.70716e+01,3.01995e-02,3.59942e+01,1.64969e+01,
3.04388e-02,3.52694e+01,1.62999e+01,3.05492e-02,3.49414e+01,1.62094e+01,3.12608e-02,3.29272e+01,1.56360e+01,3.16228e-02,
3.19645e+01,1.53505e+01,3.16230e-02,3.19640e+01,1.53503e+01,3.19889e-02,3.10303e+01,1.50663e+01,3.19969e-02,3.10103e+01,
1.50601e+01,3.23594e-02,3.01220e+01,1.47831e+01,3.27341e-02,2.92403e+01,1.45015e+01,3.31131e-02,2.83847e+01,1.42219e+01,
3.37425e-02,2.70055e+01,1.37515e+01,3.38844e-02,2.67072e+01,1.36477e+01,3.42768e-02,2.59061e+01,1.33650e+01,3.54813e-02,
2.36457e+01,1.25363e+01,3.58922e-02,2.29376e+01,1.22670e+01,3.63501e-02,2.21826e+01,1.19745e+01,3.67282e-02,2.15846e+01,
1.17390e+01,3.71535e-02,2.09383e+01,1.14805e+01,3.84592e-02,1.91129e+01,1.07328e+01,3.93550e-02,1.79656e+01,1.02411e+01,
3.96122e-02,1.76539e+01,1.01050e+01,3.98107e-02,1.74181e+01,1.00015e+01,3.98110e-02,1.74178e+01,1.00013e+01,4.07380e-02,
1.63727e+01,9.53461e+00,4.12097e-02,1.58741e+01,9.30748e+00,4.16869e-02,1.53909e+01,9.08456e+00,4.21696e-02,1.49227e+01,
8.86582e+00,4.26579e-02,1.44690e+01,8.65125e+00,4.31519e-02,1.40293e+01,8.44082e+00,4.32418e-02,1.39511e+01,8.40315e+00,
4.51856e-02,1.23990e+01,7.63875e+00,4.57088e-02,1.20224e+01,7.44833e+00,4.84172e-02,1.03072e+01,6.55506e+00,4.84474e-02,
1.02901e+01,6.54591e+00,4.89779e-02,9.99505e+00,6.38778e+00,5.01187e-02,9.38883e+00,6.05720e+00,5.01190e-02,9.38869e+00,
6.05712e+00,5.06991e-02,9.09993e+00,5.89764e+00,5.12861e-02,8.81977e+00,5.74156e+00,5.20969e-02,8.45221e+00,5.53480e+00,
5.37032e-02,7.78383e+00,5.15317e+00,5.75327e-02,6.46161e+00,4.37633e+00,6.02560e-02,5.70458e+00,3.91607e+00,6.09537e-02,
5.53056e+00,3.80850e+00,6.16595e-02,5.35952e+00,3.70183e+00,6.30957e-02,5.03361e+00,3.49675e+00,6.30960e-02,5.03355e+00,
3.49671e+00,6.45654e-02,4.72784e+00,3.30231e+00,6.53601e-02,4.57332e+00,3.20322e+00,7.16143e-02,3.57176e+00,2.54661e+00,
7.32825e-02,3.35720e+00,2.40238e+00,7.41310e-02,3.25499e+00,2.33321e+00,7.49894e-02,3.15603e+00,2.26593e+00,7.67362e-02,
2.96746e+00,2.13692e+00,7.85236e-02,2.78873e+00,2.01341e+00,7.94328e-02,2.70365e+00,1.95426e+00,7.94330e-02,2.70363e+00,
1.95425e+00,8.00482e-02,2.64810e+00,1.91558e+00,8.03526e-02,2.62120e+00,1.89682e+00,8.60994e-02,2.17901e+00,1.58502e+00,
8.70964e-02,2.11337e+00,1.53815e+00,8.91251e-02,1.98817e+00,1.44830e+00,9.22571e-02,1.81499e+00,1.32317e+00,9.33254e-02,
1.76093e+00,1.28386e+00,9.54993e-02,1.65794e+00,1.20866e+00,9.66051e-02,1.60891e+00,1.17270e+00,1.00000e-01,1.46982e+00,
1.07002e+00,1.03514e-01,1.34351e+00,9.76317e-01,1.08393e-01,1.19329e+00,8.63976e-01,1.09648e-01,1.15870e+00,8.37969e-01,
1.10918e-01,1.12520e+00,8.12722e-01,1.12202e-01,1.09277e+00,7.88233e-01,1.12594e-01,1.08315e+00,7.80962e-01,1.14815e-01,
1.03095e+00,7.41457e-01,1.23027e-01,8.67910e-01,6.17249e-01,1.24452e-01,8.43705e-01,5.98701e-01,1.25890e-01,8.20316e-01,
5.80752e-01,1.25893e-01,8.20277e-01,5.80721e-01,1.28825e-01,7.75495e-01,5.46451e-01,1.30317e-01,7.54171e-01,5.30102e-01,
1.31826e-01,7.33525e-01,5.14253e-01,1.34896e-01,6.94182e-01,4.84001e-01,1.39388e-01,6.42424e-01,4.44106e-01,1.49624e-01,
5.45319e-01,3.69057e-01,1.50000e-01,5.42216e-01,3.66653e-01,1.54882e-01,5.04516e-01,3.37426e-01,1.58489e-01,4.79412e-01,
3.17944e-01,1.58490e-01,4.79408e-01,3.17940e-01,1.62181e-01,4.55739e-01,2.99713e-01,1.69824e-01,4.12675e-01,2.66546e-01,
1.74692e-01,3.88821e-01,2.48181e-01,1.75792e-01,3.83762e-01,2.44292e-01,1.77828e-01,3.74706e-01,2.37333e-01,1.79887e-01,
3.65931e-01,2.30593e-01,1.84077e-01,3.49189e-01,2.17740e-01,1.86209e-01,3.41203e-01,2.11615e-01,1.90546e-01,3.25962e-01,
1.99936e-01,1.92752e-01,3.18692e-01,1.94371e-01,1.97242e-01,3.04814e-01,1.83759e-01,1.99526e-01,2.98242e-01,1.78747e-01,
1.99530e-01,2.98232e-01,1.78739e-01,2.00000e-01,2.96903e-01,1.77740e-01,2.04174e-01,2.85589e-01,1.69247e-01,2.08930e-01,
2.73685e-01,1.60332e-01,2.11349e-01,2.67999e-01,1.56082e-01,2.13796e-01,2.62483e-01,1.51964e-01,2.16272e-01,2.57130e-01,
1.47976e-01,2.18776e-01,2.51937e-01,1.44111e-01,2.19984e-01,2.49511e-01,1.42308e-01,2.21309e-01,2.46898e-01,1.40370e-01,
2.23872e-01,2.42004e-01,1.36747e-01,2.31740e-01,2.28172e-01,1.26540e-01,2.34423e-01,2.23830e-01,1.23348e-01,2.37137e-01,
2.19615e-01,1.20256e-01,2.39883e-01,2.15525e-01,1.17261e-01,2.42661e-01,2.11554e-01,1.14360e-01,2.45471e-01,2.07737e-01,
1.11586e-01,2.48313e-01,2.04030e-01,1.08897e-01,2.51189e-01,2.00429e-01,1.06291e-01,2.51190e-01,2.00427e-01,1.06290e-01,
2.54097e-01,1.96887e-01,1.03793e-01,2.57040e-01,1.93446e-01,1.01372e-01,2.60016e-01,1.90101e-01,9.90247e-02,2.66073e-01,
1.83690e-01,9.45463e-02,2.69154e-01,1.80621e-01,9.24129e-02,2.72270e-01,1.77637e-01,9.03451e-02,2.75423e-01,1.74736e-01,
8.83407e-02,2.78612e-01,1.71915e-01,8.63977e-02,2.81838e-01,1.69171e-01,8.45143e-02,2.85102e-01,1.66502e-01,8.26886e-02,
2.88403e-01,1.63942e-01,8.09528e-02,2.91743e-01,1.61450e-01,7.92693e-02,2.97433e-01,1.57418e-01,7.65577e-02,3.00000e-01,
1.55679e-01,7.53948e-02,3.01995e-01,1.54362e-01,7.45158e-02,3.05492e-01,1.52121e-01,7.30251e-02,3.09029e-01,1.49938e-01,
7.15788e-02,3.12608e-01,1.47813e-01,7.01757e-02,3.16228e-01,1.45745e-01,6.88166e-02,3.16230e-01,1.45744e-01,6.88158e-02,
3.23594e-01,1.41699e-01,6.62689e-02,3.31131e-01,1.37857e-01,6.38710e-02,3.34965e-01,1.36008e-01,6.27253e-02,3.38844e-01,
1.34227e-01,6.16340e-02,3.42768e-01,1.32490e-01,6.05742e-02,3.50752e-01,1.29140e-01,5.85452e-02,3.54813e-01,1.27525e-01,
5.75743e-02,3.58922e-01,1.25949e-01,5.66312e-02,3.63078e-01,1.24413e-01,5.57169e-02,3.67282e-01,1.22913e-01,5.48288e-02,
3.71535e-01,1.21448e-01,5.39660e-02,3.80189e-01,1.18621e-01,5.23129e-02,3.84592e-01,1.17272e-01,5.15367e-02,3.93550e-01,
1.14665e-01,5.00480e-02,3.98107e-01,1.13406e-01,4.93342e-02,3.98110e-01,1.13405e-01,4.93338e-02,4.00000e-01,1.12883e-01,
4.90555e-02,4.02717e-01,1.12146e-01,4.86632e-02,4.07380e-01,1.10913e-01,4.80106e-02,4.16869e-01,1.08530e-01,4.67602e-02,
4.21697e-01,1.07376e-01,4.61602e-02,4.26580e-01,1.06247e-01,4.55761e-02,4.27328e-01,1.06079e-01,4.54904e-02,4.31519e-01,
1.05153e-01,4.50197e-02,4.36516e-01,1.04082e-01,4.44780e-02,4.41570e-01,1.03032e-01,4.39503e-02,4.46684e-01,1.02004e-01,
4.34361e-02,4.57088e-01,1.00008e-01,4.24466e-02,4.62381e-01,9.90416e-02,4.19716e-02,4.67735e-01,9.80936e-02,4.15084e-02,
4.73151e-01,9.71641e-02,4.10568e-02,4.78630e-01,9.62526e-02,4.06164e-02,4.84172e-01,9.53687e-02,4.01966e-02,4.89779e-01,
9.45015e-02,3.97869e-02,4.95450e-01,9.36503e-02,3.93869e-02,5.00000e-01,9.29857e-02,3.90760e-02,5.01187e-01,9.28148e-02,
3.89963e-02,5.01190e-01,9.28144e-02,3.89962e-02,5.12861e-01,9.11418e-02,3.82823e-02,5.18800e-01,9.03284e-02,3.79383e-02,
5.30884e-01,8.87440e-02,3.72733e-02,5.37032e-01,8.79802e-02,3.69594e-02,5.43250e-01,8.72293e-02,3.66522e-02,5.49541e-01,
8.64909e-02,3.63515e-02,5.62341e-01,8.50503e-02,3.57686e-02,5.68853e-01,8.43476e-02,3.54861e-02,5.82103e-01,8.29771e-02,
3.49393e-02,5.88844e-01,8.23081e-02,3.46739e-02,5.95662e-01,8.16560e-02,3.44200e-02,6.00000e-01,8.12501e-02,3.42623e-02,
6.02560e-01,8.10138e-02,3.41708e-02,6.09537e-01,8.03814e-02,3.39262e-02,6.16595e-01,7.97584e-02,3.36861e-02,6.30957e-01,
7.85400e-02,3.32187e-02,6.30960e-01,7.85398e-02,3.32186e-02,6.38264e-01,7.79233e-02,3.30090e-02,6.53131e-01,7.67162e-02,
3.25998e-02,6.60694e-01,7.61310e-02,3.24055e-02,6.68344e-01,7.55532e-02,3.22140e-02,6.76083e-01,7.49834e-02,3.20254e-02,
6.83912e-01,7.44212e-02,3.18395e-02,6.91831e-01,7.38665e-02,3.16561e-02,6.99842e-01,7.33190e-02,3.14752e-02,7.16143e-01,
7.22463e-02,3.11216e-02,7.24436e-01,7.17242e-02,3.09521e-02,7.32825e-01,7.12086e-02,3.07846e-02,7.41310e-01,7.06994e-02,
3.06192e-02,7.49894e-01,7.01966e-02,3.04557e-02,7.67362e-01,6.92090e-02,3.01343e-02,7.76247e-01,6.87241e-02,2.99762e-02,
7.94328e-01,6.77722e-02,2.96659e-02,7.94330e-01,6.77721e-02,2.96658e-02,8.00000e-01,6.74727e-02,2.95813e-02,8.03526e-01,
6.72886e-02,2.95292e-02,8.12831e-01,6.68105e-02,2.93935e-02,8.22243e-01,6.63377e-02,2.92589e-02,8.31764e-01,6.58703e-02,
2.91252e-02,8.41395e-01,6.54080e-02,2.89924e-02,8.51138e-01,6.49509e-02,2.88605e-02,8.60994e-01,6.44989e-02,2.87297e-02,
8.91251e-01,6.31721e-02,2.83423e-02,9.01571e-01,6.27414e-02,2.82169e-02,9.12011e-01,6.23151e-02,2.80922e-02,9.22571e-01,
6.18933e-02,2.79681e-02,9.33254e-01,6.14757e-02,2.78447e-02,9.44061e-01,6.10626e-02,2.77221e-02,9.54993e-01,6.06537e-02,
2.76001e-02,9.66051e-01,6.02488e-02,2.74787e-02,9.77237e-01,5.98480e-02,2.73578e-02,9.88553e-01,5.94537e-02,2.72401e-02,
1.00000e+00,5.90632e-02,2.71228e-02,1.00000e-03,7.35138e+03,7.34411e+03,1.01158e-03,7.16874e+03,7.16149e+03,1.03514e-03,
6.81663e+03,6.80941e+03,1.04194e-03,6.71981e+03,6.71259e+03,1.05000e-03,6.60753e+03,6.60032e+03,1.07152e-03,6.32090e+03,
6.31372e+03,1.08393e-03,6.16229e+03,6.15512e+03,1.09000e-03,6.08623e+03,6.07906e+03,1.09648e-03,6.00652e+03,5.99937e+03,
1.10603e-03,5.89116e+03,5.88402e+03,1.13501e-03,5.56004e+03,5.55295e+03,1.17490e-03,5.14682e+03,5.13979e+03,1.18850e-03,
5.01394e+03,5.00693e+03,1.19000e-03,4.99961e+03,4.99260e+03,1.20226e-03,4.88360e+03,4.87661e+03,1.21619e-03,4.75621e+03,
4.74924e+03,1.22092e-03,4.71403e+03,4.70707e+03,1.23027e-03,4.63231e+03,4.62536e+03,1.25890e-03,4.39531e+03,4.38841e+03,
1.25892e-03,4.39511e+03,4.38821e+03,1.28825e-03,4.17006e+03,4.16321e+03,1.30000e-03,4.08480e+03,4.07796e+03,1.31826e-03,
3.95647e+03,3.94966e+03,1.33352e-03,3.85191e+03,3.84512e+03,1.36458e-03,3.65140e+03,3.64465e+03,1.37246e-03,3.60315e+03,
3.59641e+03,1.42889e-03,3.28280e+03,3.27615e+03,1.44544e-03,3.19539e+03,3.18876e+03,1.46218e-03,3.11009e+03,3.10349e+03,
1.47911e-03,3.02706e+03,3.02048e+03,1.48658e-03,2.99129e+03,2.98472e+03,1.53109e-03,2.79009e+03,2.78360e+03,1.54882e-03,
2.71555e+03,2.70909e+03,1.56675e-03,2.64265e+03,2.63622e+03,1.58489e-03,2.57161e+03,2.56520e+03,1.58490e-03,2.57159e+03,
2.56518e+03,1.60325e-03,2.50249e+03,2.49610e+03,1.62181e-03,2.43487e+03,2.42852e+03,1.64059e-03,2.36913e+03,2.36280e+03,
1.65959e-03,2.30518e+03,2.29887e+03,1.68364e-03,2.22756e+03,2.22129e+03,1.71791e-03,2.12326e+03,2.11705e+03,1.73780e-03,
2.06592e+03,2.05974e+03,1.75792e-03,2.00980e+03,2.00365e+03,1.77828e-03,1.95512e+03,1.94899e+03,1.79887e-03,1.90161e+03,
1.89551e+03,1.81970e-03,1.84961e+03,1.84355e+03,1.85000e-03,1.77762e+03,1.77159e+03,1.90546e-03,1.65540e+03,1.64946e+03,
1.92753e-03,1.60970e+03,1.60379e+03,1.94984e-03,1.56525e+03,1.55937e+03,1.99526e-03,1.48018e+03,1.47437e+03,1.99530e-03,
1.48011e+03,1.47430e+03,2.00000e-03,1.47169e+03,1.46588e+03,2.01837e-03,1.43924e+03,1.43345e+03,2.08000e-03,1.33761e+03,
1.33193e+03,2.08930e-03,1.32320e+03,1.31752e+03,2.11349e-03,1.28657e+03,1.28093e+03,2.15000e-03,1.23389e+03,1.22830e+03,
2.20000e-03,1.16627e+03,1.16076e+03,2.21310e-03,1.14945e+03,1.14396e+03,2.21626e-03,1.14544e+03,1.13995e+03,2.22000e-03,
1.14072e+03,1.13524e+03,2.23872e-03,1.11740e+03,1.11194e+03,2.31740e-03,1.02639e+03,1.02104e+03,2.31990e-03,1.02367e+03,
1.01832e+03,2.34423e-03,9.97705e+02,9.92402e+02,2.35000e-03,9.91683e+02,9.86388e+02,2.37137e-03,9.69746e+02,9.64483e+02,
2.43643e-03,9.06772e+02,9.01604e+02,2.45471e-03,8.90107e+02,8.84968e+02,2.48313e-03,8.65078e+02,8.59984e+02,2.50000e-03,
8.50703e+02,8.45635e+02,2.51189e-03,8.40747e+02,8.35697e+02,2.51190e-03,8.40735e+02,8.35685e+02,2.55413e-03,8.06653e+02,
8.01667e+02,2.60016e-03,7.71676e+02,7.66763e+02,2.63027e-03,7.49940e+02,7.45075e+02,2.66073e-03,7.28699e+02,7.23880e+02,
2.67608e-03,7.18260e+02,7.13465e+02,2.72270e-03,6.87803e+02,6.83085e+02,2.75423e-03,6.68257e+02,6.63590e+02,2.77212e-03,
6.57520e+02,6.52882e+02,2.78612e-03,6.49287e+02,6.44673e+02,2.81838e-03,6.30869e+02,6.26311e+02,2.86645e-03,6.04715e+02,
6.00237e+02,2.90000e-03,5.87342e+02,5.82926e+02,2.95121e-03,5.62119e+02,5.57792e+02,2.95780e-03,5.58962e+02,5.54647e+02,
2.98538e-03,5.46016e+02,5.41754e+02,3.00000e-03,5.39308e+02,5.35074e+02,3.01995e-03,5.30322e+02,5.26124e+02,3.03090e-03,
5.25484e+02,5.21307e+02,3.05492e-03,5.15073e+02,5.10945e+02,3.09633e-03,4.97824e+02,4.93779e+02,3.12608e-03,4.85916e+02,
4.81938e+02,3.15760e-03,4.73703e+02,4.69794e+02,3.16228e-03,4.71925e+02,4.68027e+02,3.16230e-03,4.71916e+02,4.68019e+02,
3.21158e-03,4.53784e+02,4.50006e+02,3.23594e-03,4.45172e+02,4.41459e+02,3.25418e-03,4.38867e+02,4.35201e+02,3.29382e-03,
4.25571e+02,4.22022e+02,3.31131e-03,4.19877e+02,4.16385e+02,3.32449e-03,4.15617e+02,4.12167e+02,3.34965e-03,4.07635e+02,
4.04277e+02,3.35563e-03,4.05772e+02,4.02435e+02,3.38642e-03,3.96341e+02,3.93133e+02,3.38844e-03,3.95731e+02,3.92533e+02,
3.41049e-03,3.89169e+02,3.86079e+02,3.43044e-03,3.83342e+02,3.80367e+02,3.44634e-03,3.78764e+02,3.75897e+02,3.46553e-03,
3.73322e+02,3.70601e+02,3.46737e-03,3.72805e+02,3.70099e+02,3.49312e-03,3.65692e+02,3.63181e+02,3.50365e-03,3.62852e+02,
3.60404e+02,3.50752e-03,3.61823e+02,3.59391e+02,3.51330e-03,3.60284e+02,3.57876e+02,3.51835e-03,3.58954e+02,3.56559e+02,
3.52391e-03,3.57504e+02,3.55117e+02,3.53121e-03,3.55625e+02,3.53236e+02,3.53540e-03,3.54561e+02,3.52163e+02,3.53540e-03,
1.15647e+03,1.11069e+03,3.53876e-03,1.15405e+03,1.10839e+03,3.54394e-03,1.15032e+03,1.10484e+03,3.54813e-03,1.14732e+03,
1.10198e+03,3.55232e-03,1.14434e+03,1.09914e+03,3.56521e-03,1.13526e+03,1.09045e+03,3.58910e-03,1.11873e+03,1.07461e+03,
3.58922e-03,1.11865e+03,1.07454e+03,3.60000e-03,1.11129e+03,1.06749e+03,3.60364e-03,1.10854e+03,1.06485e+03,3.61275e-03,
1.10168e+03,1.05829e+03,3.62521e-03,1.09239e+03,1.04941e+03,3.63780e-03,1.08310e+03,1.04054e+03,3.65000e-03,1.07418e+03,
1.03205e+03,3.65049e-03,1.07381e+03,1.03169e+03,3.66379e-03,1.06376e+03,1.02214e+03,3.69733e-03,1.03897e+03,9.98573e+02,
3.70525e-03,1.03323e+03,9.93116e+02,3.71535e-03,1.02599e+03,9.86216e+02,3.72556e-03,1.01875e+03,9.79297e+02,3.73090e-03,
1.01499e+03,9.75705e+02,3.73090e-03,1.39209e+03,1.32979e+03,3.74188e-03,1.38218e+03,1.32042e+03,3.75837e-03,1.36752e+03,
1.30654e+03,3.79323e-03,1.33725e+03,1.27785e+03,3.80189e-03,1.32987e+03,1.27085e+03,3.80687e-03,1.32566e+03,1.26686e+03,
3.82183e-03,1.31310e+03,1.25497e+03,3.82300e-03,1.31212e+03,1.25405e+03,3.84136e-03,1.29603e+03,1.23881e+03,3.86050e-03,
1.27952e+03,1.22320e+03,3.88228e-03,1.26108e+03,1.20577e+03,3.90000e-03,1.24634e+03,1.19183e+03,3.90322e-03,1.24367e+03,
1.18930e+03,3.93550e-03,1.21735e+03,1.16443e+03,3.95638e-03,1.20073e+03,1.14872e+03,3.97312e-03,1.18765e+03,1.13635e+03,
3.98107e-03,1.18151e+03,1.13054e+03,3.98110e-03,1.18149e+03,1.13052e+03,3.99410e-03,1.17155e+03,1.12110e+03,3.99410e-03,
1.34583e+03,1.28649e+03,3.99731e-03,1.34314e+03,1.28394e+03,4.02717e-03,1.31855e+03,1.26067e+03,4.07380e-03,1.28139e+03,
1.22547e+03,4.07507e-03,1.28041e+03,1.22454e+03,4.08000e-03,1.27658e+03,1.22091e+03,4.09437e-03,1.26567e+03,1.21059e+03,
4.11526e-03,1.25004e+03,1.19579e+03,4.14154e-03,1.23076e+03,1.17755e+03,4.16869e-03,1.21127e+03,1.15910e+03,4.17903e-03,
1.20396e+03,1.15218e+03,4.21696e-03,1.17763e+03,1.12726e+03,4.24690e-03,1.15744e+03,1.10814e+03,4.24971e-03,1.15553e+03,
1.10633e+03,4.26579e-03,1.14472e+03,1.09609e+03,4.30000e-03,1.12220e+03,1.07476e+03,4.31519e-03,1.11239e+03,1.06547e+03,
4.35133e-03,1.08940e+03,1.04367e+03,4.36516e-03,1.08077e+03,1.03549e+03,4.41570e-03,1.04975e+03,1.00607e+03,4.45283e-03,
1.02779e+03,9.85226e+02,4.56103e-03,9.67319e+02,9.27810e+02,4.57088e-03,9.62059e+02,9.22813e+02,4.62381e-03,9.34512e+02,
8.96639e+02,4.67735e-03,9.07765e+02,8.71209e+02,4.68773e-03,9.02626e+02,8.66319e+02,4.73151e-03,8.81379e+02,8.46108e+02,
4.78630e-03,8.55778e+02,8.21743e+02,4.88547e-03,8.12072e+02,7.80115e+02,4.89779e-03,8.06860e+02,7.75149e+02,4.95450e-03,
7.83482e+02,7.52871e+02,5.01187e-03,7.60621e+02,7.31071e+02,5.01190e-03,7.60610e+02,7.31060e+02,5.06991e-03,7.38444e+02,
7.09913e+02,5.07306e-03,7.37266e+02,7.08788e+02,5.12861e-03,7.16926e+02,6.89382e+02,5.30884e-03,6.56125e+02,6.31315e+02,
5.32062e-03,6.52394e+02,6.27749e+02,5.37032e-03,6.36969e+02,6.13005e+02,5.43250e-03,6.18333e+02,5.95185e+02,5.55904e-03,
5.82729e+02,5.61116e+02,5.64330e-03,5.60616e+02,5.39941e+02,5.68853e-03,5.49223e+02,5.29029e+02,5.82103e-03,5.17692e+02,
4.98813e+02,5.88844e-03,5.02453e+02,4.84199e+02,5.90000e-03,4.99901e+02,4.81751e+02,5.95662e-03,4.87700e+02,4.70045e+02,
6.02560e-03,4.73401e+02,4.56320e+02,6.03427e-03,4.71643e+02,4.54633e+02,6.09537e-03,4.59513e+02,4.42989e+02,6.30957e-03,
4.20296e+02,4.05317e+02,6.30960e-03,4.20292e+02,4.05312e+02,6.45654e-03,3.95943e+02,3.81899e+02,6.51829e-03,3.86229e+02,
3.72553e+02,6.60693e-03,3.72849e+02,3.59679e+02,6.76083e-03,3.51125e+02,3.38765e+02,6.80000e-03,3.45882e+02,3.33716e+02,
6.91831e-03,3.30687e+02,3.19077e+02,6.99842e-03,3.20924e+02,3.09668e+02,7.00000e-03,3.20735e+02,3.09486e+02,7.07946e-03,
3.11426e+02,3.00510e+02,7.08298e-03,3.11017e+02,3.00115e+02,7.16143e-03,3.02098e+02,2.91515e+02,7.24436e-03,2.93055e+02,
2.82794e+02,7.32824e-03,2.84293e+02,2.74339e+02,7.41310e-03,2.75799e+02,2.66142e+02,7.58578e-03,2.59468e+02,2.50374e+02,
7.74016e-03,2.45992e+02,2.37356e+02,7.85236e-03,2.36797e+02,2.28473e+02,7.94328e-03,2.29683e+02,2.21599e+02,7.94330e-03,
2.29682e+02,2.21598e+02,8.22243e-03,2.09606e+02,2.02191e+02,8.31764e-03,2.03323e+02,1.96114e+02,8.41395e-03,1.97230e+02,
1.90221e+02,8.51138e-03,1.91282e+02,1.84465e+02,8.60994e-03,1.85512e+02,1.78881e+02,8.70964e-03,1.79922e+02,1.73469e+02,
8.74561e-03,1.77964e+02,1.71574e+02,8.91251e-03,1.69253e+02,1.63143e+02,9.12011e-03,1.59198e+02,1.53407e+02,9.33254e-03,
1.49676e+02,1.44183e+02,9.44061e-03,1.45138e+02,1.39786e+02,9.50000e-03,1.42724e+02,1.37447e+02,9.54993e-03,1.40732e+02,
1.35517e+02,9.66051e-03,1.36455e+02,1.31371e+02,9.88553e-03,1.28291e+02,1.23457e+02,9.92964e-03,1.26766e+02,1.21979e+02,
1.00000e-02,1.24386e+02,1.19672e+02,1.01158e-02,1.20602e+02,1.16005e+02,1.02329e-02,1.16938e+02,1.12452e+02,1.03514e-02,
1.13389e+02,1.09012e+02,1.05925e-02,1.06621e+02,1.02450e+02,1.07152e-02,1.03396e+02,9.93228e+01,1.08393e-02,1.00270e+02,
9.62911e+01,1.09648e-02,9.72164e+01,9.33294e+01,1.10599e-02,9.49759e+01,9.11560e+01,1.12202e-02,9.13553e+01,8.76454e+01,
1.13501e-02,8.85602e+01,8.49352e+01,1.14815e-02,8.58535e+01,8.23105e+01,1.17490e-02,8.06939e+01,7.73072e+01,1.21619e-02,
7.35215e+01,7.03515e+01,1.22850e-02,7.15551e+01,6.84445e+01,1.23027e-02,7.12785e+01,6.81764e+01,1.25890e-02,6.70006e+01,
6.40306e+01,1.25892e-02,6.69970e+01,6.40271e+01,1.27350e-02,6.49475e+01,6.20409e+01,1.28825e-02,6.29518e+01,6.01067e+01,
1.30317e-02,6.10197e+01,5.82342e+01,1.31826e-02,5.91488e+01,5.64212e+01,1.32587e-02,5.82364e+01,5.55370e+01,1.38038e-02,
5.22321e+01,4.97232e+01,1.39637e-02,5.06371e+01,4.81792e+01,1.40000e-02,5.02843e+01,4.78376e+01,1.41254e-02,4.90914e+01,
4.66830e+01,1.42889e-02,4.75945e+01,4.52341e+01,1.43333e-02,4.71963e+01,4.48487e+01,1.44544e-02,4.61299e+01,4.38173e+01,
1.45000e-02,4.57373e+01,4.34377e+01,1.46218e-02,4.47064e+01,4.24408e+01,1.49624e-02,4.19913e+01,3.98155e+01,1.50000e-02,
4.17056e+01,3.95393e+01,1.54882e-02,3.82356e+01,3.61855e+01,1.55070e-02,3.81099e+01,3.60640e+01,1.58489e-02,3.59238e+01,
3.39545e+01,1.58490e-02,3.59233e+01,3.39541e+01,1.60000e-02,3.50129e+01,3.30757e+01,1.60324e-02,3.48215e+01,3.28911e+01,
1.64059e-02,3.27198e+01,3.08642e+01,1.65959e-02,3.17189e+01,2.98993e+01,1.67518e-02,3.09234e+01,2.91323e+01,1.67880e-02,
3.07425e+01,2.89581e+01,1.69824e-02,2.97961e+01,2.80470e+01,1.71791e-02,2.88756e+01,2.71610e+01,1.73780e-02,2.79819e+01,
2.63008e+01,1.80576e-02,2.52071e+01,2.36318e+01,1.81970e-02,2.46848e+01,2.31304e+01,1.84077e-02,2.39238e+01,2.24001e+01,
1.86209e-02,2.31866e+01,2.16928e+01,1.92752e-02,2.11130e+01,1.97043e+01,1.94897e-02,2.04904e+01,1.91077e+01,1.94985e-02,
2.04655e+01,1.90839e+01,1.95000e-02,2.04611e+01,1.90796e+01,1.97242e-02,1.98330e+01,1.84788e+01,1.99526e-02,1.92208e+01,
1.78934e+01,1.99530e-02,1.92198e+01,1.78925e+01,2.01837e-02,1.86277e+01,1.73266e+01,2.04174e-02,1.80513e+01,1.67758e+01,
2.08418e-02,1.70652e+01,1.58339e+01,2.11349e-02,1.64260e+01,1.52250e+01,2.13796e-02,1.59177e+01,1.47410e+01,2.20039e-02,
1.47169e+01,1.35982e+01,2.26464e-02,1.36049e+01,1.25438e+01,2.29087e-02,1.31825e+01,1.21434e+01,2.30083e-02,1.30268e+01,
1.19959e+01,2.31740e-02,1.27727e+01,1.17560e+01,2.37137e-02,1.19912e+01,1.10187e+01,2.38039e-02,1.18673e+01,1.09017e+01,
2.40000e-02,1.16025e+01,1.06533e+01,2.44642e-02,1.10058e+01,1.00935e+01,2.45471e-02,1.09030e+01,9.99782e+00,2.48313e-02,
1.05598e+01,9.67811e+00,2.49644e-02,1.04043e+01,9.53326e+00,2.51189e-02,1.02261e+01,9.36888e+00,2.51190e-02,1.02260e+01,
9.36873e+00,2.53470e-02,9.97042e+00,9.13299e+00,2.56370e-02,9.65366e+00,8.84448e+00,2.57727e-02,9.50812e+00,8.71377e+00,
2.58863e-02,9.38701e+00,8.60633e+00,2.60016e-02,9.26397e+00,8.49913e+00,2.60516e-02,9.21111e+00,8.45300e+00,2.62605e-02,
8.98948e+00,8.26371e+00,2.64238e-02,8.82159e+00,8.11968e+00,2.65212e-02,8.72663e+00,8.03543e+00,2.66073e-02,8.64721e+00,
7.96194e+00,2.66751e-02,8.58798e+00,7.90465e+00,2.66880e-02,8.57733e+00,7.89387e+00,2.66880e-02,5.05904e+01,1.83357e+01,
2.67524e-02,5.03120e+01,1.83044e+01,2.68514e-02,4.98920e+01,1.82556e+01,2.69154e-02,4.96261e+01,1.82238e+01,2.69716e-02,
4.93941e+01,1.81955e+01,2.72021e-02,4.84636e+01,1.80775e+01,2.72270e-02,4.83643e+01,1.80645e+01,2.73065e-02,4.80496e+01,
1.80229e+01,2.74000e-02,4.76812e+01,1.79736e+01,2.74727e-02,4.73474e+01,1.79155e+01,2.76451e-02,4.65641e+01,1.77771e+01,
2.78997e-02,4.54357e+01,1.75718e+01,2.80000e-02,4.50002e+01,1.74906e+01,2.82188e-02,4.41482e+01,1.73444e+01,2.85102e-02,
4.30462e+01,1.71479e+01,2.85994e-02,4.27165e+01,1.70874e+01,2.88403e-02,4.18422e+01,1.69232e+01,2.90674e-02,4.09918e+01,
1.67530e+01,2.91743e-02,4.05991e+01,1.66727e+01,2.95121e-02,3.93924e+01,1.64191e+01,2.96540e-02,3.89003e+01,1.63126e+01,
3.00000e-02,3.77343e+01,1.60534e+01,3.05867e-02,3.58636e+01,1.56156e+01,3.09030e-02,3.49071e+01,1.53815e+01,3.16228e-02,
3.28910e+01,1.48707e+01,3.16230e-02,3.28904e+01,1.48705e+01,3.17631e-02,3.25170e+01,1.47722e+01,3.19889e-02,3.19268e+01,
1.46146e+01,3.23594e-02,3.09911e+01,1.43587e+01,3.27341e-02,3.00833e+01,1.41033e+01,3.34279e-02,2.84981e+01,1.36397e+01,
3.34965e-02,2.83477e+01,1.35946e+01,3.42768e-02,2.67123e+01,1.30905e+01,3.46737e-02,2.59306e+01,1.28407e+01,3.50000e-02,
2.53108e+01,1.26383e+01,3.50752e-02,2.51674e+01,1.25902e+01,3.53337e-02,2.46827e+01,1.24265e+01,3.63078e-02,2.29670e+01,
1.18290e+01,3.67282e-02,2.22777e+01,1.15808e+01,3.75837e-02,2.09611e+01,1.10930e+01,3.81124e-02,2.02014e+01,1.08058e+01,
3.98107e-02,1.80030e+01,9.93897e+00,3.98110e-02,1.80026e+01,9.93883e+00,4.02717e-02,1.74640e+01,9.71793e+00,4.07380e-02,
1.69407e+01,9.49991e+00,4.16713e-02,1.59406e+01,9.07120e+00,4.16869e-02,1.59246e+01,9.06422e+00,4.21696e-02,1.54394e+01,
8.85184e+00,4.31519e-02,1.45137e+01,8.43824e+00,4.46684e-02,1.32298e+01,7.84584e+00,4.53355e-02,1.27148e+01,7.60182e+00,
4.57088e-02,1.24385e+01,7.46943e+00,4.62381e-02,1.20610e+01,7.28674e+00,4.73151e-02,1.13404e+01,6.93217e+00,4.78630e-02,
1.09963e+01,6.76001e+00,4.84172e-02,1.06629e+01,6.59140e+00,5.01187e-02,9.72297e+00,6.10651e+00,5.01190e-02,9.72282e+00,
6.10643e+00,5.01463e-02,9.70869e+00,6.09903e+00,5.06991e-02,9.42855e+00,5.95175e+00,5.18800e-02,8.85729e+00,5.64601e+00,
5.24807e-02,8.58499e+00,5.49829e+00,5.39646e-02,7.96051e+00,5.15567e+00,5.62341e-02,7.12102e+00,4.68379e+00,5.75440e-02,
6.69146e+00,4.43684e+00,5.88844e-02,6.28839e+00,4.20160e+00,5.95277e-02,6.10697e+00,4.09457e+00,6.16595e-02,5.55506e+00,
3.76471e+00,6.30957e-02,5.22196e+00,3.56219e+00,6.30960e-02,5.22190e+00,3.56215e+00,6.38264e-02,5.06088e+00,3.46315e+00,
6.53131e-02,4.75391e+00,3.27268e+00,6.60693e-02,4.60771e+00,3.18114e+00,6.68344e-02,4.46616e+00,3.09199e+00,6.79677e-02,
4.26722e+00,2.96578e+00,6.83912e-02,4.19603e+00,2.92040e+00,6.91831e-02,4.06732e+00,2.83799e+00,7.41310e-02,3.37641e+00,
2.38763e+00,7.49894e-02,3.27372e+00,2.31949e+00,7.58578e-02,3.17430e+00,2.25319e+00,7.67362e-02,3.07803e+00,2.18871e+00,
7.85236e-02,2.89455e+00,2.06497e+00,7.94328e-02,2.80618e+00,2.00488e+00,7.94330e-02,2.80616e+00,2.00487e+00,8.03526e-02,
2.72055e+00,1.94650e+00,8.23766e-02,2.54463e+00,1.82590e+00,8.41395e-02,2.40424e+00,1.72894e+00,9.12011e-02,1.94056e+00,
1.40343e+00,9.22571e-02,1.88252e+00,1.36209e+00,9.44061e-02,1.77196e+00,1.28295e+00,9.88553e-02,1.57127e+00,1.13793e+00,
1.00000e-01,1.52459e+00,1.10391e+00,1.01158e-01,1.47933e+00,1.07091e+00,1.03514e-01,1.39313e+00,1.00780e+00,1.08393e-01,
1.23674e+00,8.92430e-01,1.12202e-01,1.13214e+00,8.14624e-01,1.13501e-01,1.09946e+00,7.90225e-01,1.14815e-01,1.06783e+00,
7.66557e-01,1.16145e-01,1.03720e+00,7.43600e-01,1.21619e-01,9.24208e-01,6.58473e-01,1.24452e-01,8.72987e-01,6.19667e-01,
1.25890e-01,8.48643e-01,6.01176e-01,1.25893e-01,8.48601e-01,6.01145e-01,1.30317e-01,7.79764e-01,5.48933e-01,1.31826e-01,
7.58263e-01,5.32577e-01,1.33352e-01,7.37446e-01,5.16721e-01,1.34896e-01,7.17290e-01,5.01347e-01,1.36458e-01,6.97772e-01,
4.86443e-01,1.38778e-01,6.70306e-01,4.65437e-01,1.39637e-01,6.60570e-01,4.57990e-01,1.50000e-01,5.58996e-01,3.80041e-01,
1.51356e-01,5.47603e-01,3.71270e-01,1.53109e-01,5.33439e-01,3.60360e-01,1.54882e-01,5.19723e-01,3.49786e-01,1.56675e-01,
5.06439e-01,3.39540e-01,1.58489e-01,4.93573e-01,3.29609e-01,1.58490e-01,4.93568e-01,3.29605e-01,1.60324e-01,4.81051e-01,
3.20015e-01,1.64059e-01,4.57169e-01,3.01709e-01,1.71791e-01,4.13721e-01,2.68397e-01,1.73780e-01,4.03690e-01,2.60704e-01,
1.74421e-01,4.00548e-01,2.58294e-01,1.75792e-01,3.93963e-01,2.53251e-01,1.77828e-01,3.84534e-01,2.46030e-01,1.79887e-01,
3.75397e-01,2.39032e-01,1.86209e-01,3.49651e-01,2.19325e-01,1.88365e-01,3.41594e-01,2.13161e-01,1.92752e-01,3.26215e-01,
2.01404e-01,1.94984e-01,3.18879e-01,1.95800e-01,1.99526e-01,3.04876e-01,1.85112e-01,1.99530e-01,3.04864e-01,1.85104e-01,
2.00000e-01,3.03472e-01,1.84055e-01,2.06538e-01,2.85425e-01,1.70513e-01,2.08930e-01,2.79331e-01,1.65949e-01,2.11349e-01,
2.73420e-01,1.61527e-01,2.14923e-01,2.65125e-01,1.55330e-01,2.16272e-01,2.62117e-01,1.53090e-01,2.18776e-01,2.56716e-01,
1.49070e-01,2.21309e-01,2.51476e-01,1.45176e-01,2.23872e-01,2.46391e-01,1.41403e-01,2.29087e-01,2.36669e-01,1.34205e-01,
2.31740e-01,2.32022e-01,1.30772e-01,2.34423e-01,2.27512e-01,1.27446e-01,2.37137e-01,2.23135e-01,1.24224e-01,2.42661e-01,
2.14762e-01,1.18078e-01,2.45471e-01,2.10758e-01,1.15147e-01,2.48313e-01,2.06913e-01,1.12346e-01,2.51189e-01,2.03177e-01,
1.09631e-01,2.51190e-01,2.03175e-01,1.09629e-01,2.54097e-01,1.99506e-01,1.07025e-01,2.63027e-01,1.89103e-01,9.96773e-02,
2.69154e-01,1.82646e-01,9.51469e-02,2.75423e-01,1.76551e-01,9.08954e-02,2.78612e-01,1.73629e-01,8.88664e-02,2.81838e-01,
1.70788e-01,8.68995e-02,2.81873e-01,1.70757e-01,8.68786e-02,2.85102e-01,1.68021e-01,8.49926e-02,2.88403e-01,1.65362e-01,
8.31733e-02,2.95121e-01,1.60257e-01,7.96971e-02,3.01995e-01,1.55422e-01,7.64262e-02,3.05492e-01,1.53100e-01,7.48635e-02,
3.09029e-01,1.50840e-01,7.33475e-02,3.12608e-01,1.48639e-01,7.18766e-02,3.16228e-01,1.46496e-01,7.04495e-02,3.16230e-01,
1.46494e-01,7.04487e-02,3.23594e-01,1.42312e-01,6.77752e-02,3.27341e-01,1.40301e-01,6.64972e-02,3.31131e-01,1.38341e-01,
6.52576e-02,3.34965e-01,1.36454e-01,6.40763e-02,3.38844e-01,1.34614e-01,6.29295e-02,3.42768e-01,1.32819e-01,6.18158e-02,
3.46737e-01,1.31068e-01,6.07343e-02,3.50752e-01,1.29361e-01,5.96840e-02,3.54813e-01,1.27695e-01,5.86639e-02,3.63078e-01,
1.24483e-01,5.67106e-02,3.67282e-01,1.22936e-01,5.57776e-02,3.75837e-01,1.19953e-01,5.39907e-02,3.80189e-01,1.18532e-01,
5.31516e-02,3.84592e-01,1.17143e-01,5.23356e-02,3.98107e-01,1.13165e-01,5.00212e-02,3.98110e-01,1.13164e-01,5.00208e-02,
4.02577e-01,1.11910e-01,4.93359e-02,4.07380e-01,1.10604e-01,4.86277e-02,4.12098e-01,1.09365e-01,4.79593e-02,4.16869e-01,
1.08155e-01,4.73104e-02,4.21697e-01,1.06971e-01,4.66791e-02,4.26580e-01,1.05826e-01,4.60774e-02,4.36516e-01,1.03607e-01,
4.49207e-02,4.41570e-01,1.02532e-01,4.43651e-02,4.46684e-01,1.01480e-01,4.38238e-02,4.51856e-01,1.00449e-01,4.32964e-02,
4.57088e-01,9.94389e-02,4.27826e-02,4.62381e-01,9.84494e-02,4.22819e-02,4.67735e-01,9.74807e-02,4.17949e-02,4.78630e-01,
9.56211e-02,4.08768e-02,4.84172e-01,9.47181e-02,4.04346e-02,4.89779e-01,9.38324e-02,4.00030e-02,5.01187e-01,9.21111e-02,
3.91708e-02,5.01190e-01,9.21107e-02,3.91706e-02,5.06991e-01,9.12510e-02,3.87897e-02,5.12861e-01,9.04065e-02,3.84174e-02,
5.18800e-01,8.95783e-02,3.80546e-02,5.24808e-01,8.87733e-02,3.77082e-02,5.30884e-01,8.79824e-02,3.73694e-02,5.37032e-01,
8.72051e-02,3.70380e-02,5.43250e-01,8.64412e-02,3.67138e-02,5.49541e-01,8.56903e-02,3.63966e-02,5.55904e-01,8.49523e-02,
3.60862e-02,5.68853e-01,8.35132e-02,3.54850e-02,5.75440e-01,8.28123e-02,3.51945e-02,5.88844e-01,8.14583e-02,3.46445e-02,
5.95662e-01,8.07972e-02,3.43774e-02,6.00000e-01,8.03859e-02,3.42117e-02,6.02560e-01,8.01465e-02,3.41155e-02,6.04296e-01,
7.99854e-02,3.40508e-02,6.09537e-01,7.95054e-02,3.38585e-02,6.16595e-01,7.88741e-02,3.36065e-02,6.23735e-01,7.82525e-02,
3.33592e-02,6.30957e-01,7.76403e-02,3.31164e-02,6.30960e-01,7.76401e-02,3.31163e-02,6.38264e-01,7.70171e-02,3.28951e-02,
6.53131e-01,7.58089e-02,3.24745e-02,6.60694e-01,7.52176e-02,3.22692e-02,6.68344e-01,7.46346e-02,3.20669e-02,6.76083e-01,
7.40597e-02,3.18678e-02,6.83912e-01,7.34929e-02,3.16718e-02,6.99842e-01,7.23823e-02,3.12885e-02,7.07946e-01,7.18387e-02,
3.11015e-02,7.24436e-01,7.07817e-02,3.07437e-02,7.32825e-01,7.02634e-02,3.05683e-02,7.41310e-01,6.97517e-02,3.03952e-02,
7.49894e-01,6.92464e-02,3.02242e-02,7.76247e-01,6.77684e-02,2.97240e-02,7.85236e-01,6.72881e-02,2.95616e-02,7.94328e-01,
6.68171e-02,2.94043e-02,7.94330e-01,6.68170e-02,2.94043e-02,8.03526e-01,6.63327e-02,2.92616e-02,8.12831e-01,6.58539e-02,
2.91201e-02,8.22243e-01,6.53807e-02,2.89798e-02,8.31764e-01,6.49129e-02,2.88406e-02,8.41395e-01,6.44504e-02,2.87025e-02,
8.51138e-01,6.39932e-02,2.85656e-02,8.60994e-01,6.35415e-02,2.84300e-02,8.70964e-01,6.30947e-02,2.82954e-02,8.81049e-01,
6.26559e-02,2.81648e-02,9.01571e-01,6.17923e-02,2.79060e-02,9.12011e-01,6.13673e-02,2.77777e-02,9.22571e-01,6.09468e-02,
2.76503e-02,9.33254e-01,6.05307e-02,2.75236e-02,9.44061e-01,6.01193e-02,2.73980e-02,9.54993e-01,5.97120e-02,2.72731e-02,
9.66051e-01,5.93115e-02,2.71514e-02,9.77237e-01,5.89150e-02,2.70303e-02,9.88553e-01,5.85223e-02,2.69098e-02,1.00000e+00,
5.81336e-02,2.67898e-02,1.00000e-03,7.81045e+03,7.80296e+03,1.00092e-03,7.79516e+03,7.78767e+03,1.01158e-03,7.62031e+03,
7.61284e+03,1.02329e-03,7.43502e+03,7.42757e+03,1.03514e-03,7.25165e+03,7.24420e+03,1.04713e-03,7.07000e+03,7.06257e+03,
1.05925e-03,6.89308e+03,6.88567e+03,1.06273e-03,6.84353e+03,6.83611e+03,1.07000e-03,6.74171e+03,6.73431e+03,1.08393e-03,
6.55231e+03,6.54494e+03,1.10918e-03,6.22880e+03,6.22146e+03,1.11000e-03,6.21865e+03,6.21131e+03,1.12202e-03,6.07332e+03,
6.06601e+03,1.13501e-03,5.92031e+03,5.91301e+03,1.14321e-03,5.82620e+03,5.81891e+03,1.15000e-03,5.74982e+03,5.74255e+03,
1.16145e-03,5.62344e+03,5.61618e+03,1.17000e-03,5.53167e+03,5.52443e+03,1.17490e-03,5.47999e+03,5.47275e+03,1.18850e-03,
5.34008e+03,5.33287e+03,1.23027e-03,4.94247e+03,4.93532e+03,1.24451e-03,4.81555e+03,4.80842e+03,1.25890e-03,4.69080e+03,
4.68370e+03,1.25892e-03,4.69059e+03,4.68349e+03,1.26255e-03,4.65964e+03,4.65254e+03,1.27350e-03,4.56800e+03,4.56091e+03,
1.28825e-03,4.44881e+03,4.44175e+03,1.31826e-03,4.22005e+03,4.21304e+03,1.33352e-03,4.10996e+03,4.10297e+03,1.34896e-03,
4.00282e+03,3.99585e+03,1.36458e-03,3.89862e+03,3.89168e+03,1.38038e-03,3.79598e+03,3.78906e+03,1.38636e-03,3.75808e+03,
3.75116e+03,1.41254e-03,3.59816e+03,3.59129e+03,1.42889e-03,3.50313e+03,3.49628e+03,1.44544e-03,3.41068e+03,3.40386e+03,
1.46218e-03,3.32084e+03,3.31404e+03,1.47911e-03,3.23345e+03,3.22668e+03,1.48706e-03,3.19348e+03,3.18672e+03,1.50000e-03,
3.12994e+03,3.12321e+03,1.51356e-03,3.06489e+03,3.05818e+03,1.53109e-03,2.98298e+03,2.97630e+03,1.54882e-03,2.90324e+03,
2.89659e+03,1.58489e-03,2.74961e+03,2.74301e+03,1.58490e-03,2.74958e+03,2.74298e+03,1.60325e-03,2.67596e+03,2.66938e+03,
1.62181e-03,2.60409e+03,2.59755e+03,1.64059e-03,2.53376e+03,2.52724e+03,1.65959e-03,2.46544e+03,2.45895e+03,1.67639e-03,
2.40724e+03,2.40077e+03,1.67880e-03,2.39904e+03,2.39258e+03,1.69824e-03,2.33410e+03,2.32766e+03,1.75792e-03,2.14920e+03,
2.14286e+03,1.79887e-03,2.03420e+03,2.02793e+03,1.80000e-03,2.03116e+03,2.02489e+03,1.81970e-03,1.97912e+03,1.97287e+03,
1.83786e-03,1.93258e+03,1.92636e+03,1.84077e-03,1.92527e+03,1.91905e+03,1.86209e-03,1.87284e+03,1.86665e+03,1.88365e-03,
1.82154e+03,1.81538e+03,1.90546e-03,1.77172e+03,1.76560e+03,1.92753e-03,1.72331e+03,1.71722e+03,1.94984e-03,1.67604e+03,
1.66999e+03,1.95000e-03,1.67572e+03,1.66966e+03,1.99526e-03,1.58519e+03,1.57919e+03,1.99530e-03,1.58511e+03,1.57912e+03,
2.00000e-03,1.57611e+03,1.57013e+03,2.00786e-03,1.56114e+03,1.55517e+03,2.01837e-03,1.54142e+03,1.53546e+03,2.04174e-03,
1.49886e+03,1.49293e+03,2.06538e-03,1.45752e+03,1.45163e+03,2.08930e-03,1.41732e+03,1.41147e+03,2.11349e-03,1.37805e+03,
1.37223e+03,2.13796e-03,1.33993e+03,1.33415e+03,2.15000e-03,1.32169e+03,1.31592e+03,2.16272e-03,1.30271e+03,1.29696e+03,
2.20753e-03,1.23890e+03,1.23321e+03,2.21310e-03,1.23128e+03,1.22560e+03,2.23872e-03,1.19712e+03,1.19147e+03,2.26464e-03,
1.16374e+03,1.15814e+03,2.31634e-03,1.10111e+03,1.09557e+03,2.31740e-03,1.09988e+03,1.09434e+03,2.39883e-03,1.01040e+03,
1.00498e+03,2.40000e-03,1.00919e+03,1.00378e+03,2.42661e-03,9.82008e+02,9.76632e+02,2.42780e-03,9.80815e+02,9.75441e+02,
2.45471e-03,9.54420e+02,9.49086e+02,2.48313e-03,9.27640e+02,9.22347e+02,2.50000e-03,9.12149e+02,9.06881e+02,2.51189e-03,
9.01463e+02,8.96211e+02,2.51190e-03,9.01451e+02,8.96199e+02,2.54097e-03,8.76044e+02,8.70833e+02,2.55080e-03,8.67707e+02,
8.62509e+02,2.63027e-03,8.04203e+02,7.99121e+02,2.66073e-03,7.81441e+02,7.76401e+02,2.66839e-03,7.75861e+02,7.70832e+02,
2.72270e-03,7.37898e+02,7.32951e+02,2.75423e-03,7.16989e+02,7.12089e+02,2.78534e-03,6.97195e+02,6.92340e+02,2.78612e-03,
6.96707e+02,6.91853e+02,2.81838e-03,6.76890e+02,6.72087e+02,2.85102e-03,6.57628e+02,6.52876e+02,2.90092e-03,6.29694e+02,
6.25017e+02,2.95121e-03,6.03196e+02,5.98600e+02,3.00333e-03,5.77225e+02,5.72710e+02,3.01995e-03,5.69266e+02,5.64779e+02,
3.05492e-03,5.53004e+02,5.48575e+02,3.09030e-03,5.37207e+02,5.32836e+02,3.09697e-03,5.34280e+02,5.29920e+02,3.12608e-03,
5.21769e+02,5.17463e+02,3.16228e-03,5.06807e+02,5.02566e+02,3.16230e-03,5.06798e+02,5.02557e+02,3.18071e-03,4.99419e+02,
4.95211e+02,3.19889e-03,4.92270e+02,4.88098e+02,3.25757e-03,4.70161e+02,4.66101e+02,3.27341e-03,4.64427e+02,4.60400e+02,
3.30000e-03,4.54993e+02,4.51021e+02,3.32205e-03,4.47350e+02,4.43423e+02,3.34965e-03,4.38026e+02,4.34160e+02,3.37142e-03,
4.30875e+02,4.27056e+02,3.40000e-03,4.21719e+02,4.17971e+02,3.42614e-03,4.13570e+02,4.09883e+02,3.42768e-03,4.13096e+02,
4.09413e+02,3.46737e-03,4.01140e+02,3.97563e+02,3.47197e-03,3.99777e+02,3.96213e+02,3.51193e-03,3.88199e+02,3.84755e+02,
3.54139e-03,3.79942e+02,3.76598e+02,3.54813e-03,3.78083e+02,3.74766e+02,3.56862e-03,3.72524e+02,3.69286e+02,3.58922e-03,
3.67032e+02,3.63886e+02,3.59302e-03,3.66032e+02,3.62903e+02,3.61384e-03,3.60601e+02,3.57581e+02,3.63078e-03,3.56247e+02,
3.53330e+02,3.64357e-03,3.53001e+02,3.50171e+02,3.67062e-03,3.46249e+02,3.43617e+02,3.67282e-03,3.45707e+02,3.43090e+02,
3.68653e-03,3.42356e+02,3.39829e+02,3.69835e-03,3.39519e+02,3.37054e+02,3.70509e-03,3.37926e+02,3.35485e+02,3.71040e-03,
3.36686e+02,3.34258e+02,3.71535e-03,3.35538e+02,3.33117e+02,3.71629e-03,3.35323e+02,3.32903e+02,3.72379e-03,3.33608e+02,
3.31186e+02,3.72840e-03,3.32570e+02,3.30139e+02,3.72840e-03,1.06805e+03,1.02288e+03,3.73360e-03,1.06473e+03,1.01973e+03,
3.73905e-03,1.06128e+03,1.01646e+03,3.75048e-03,1.05409e+03,1.00962e+03,3.75837e-03,1.04919e+03,1.00494e+03,3.76523e-03,
1.04495e+03,1.00090e+03,3.78633e-03,1.03207e+03,9.88591e+02,3.80266e-03,1.02225e+03,9.79218e+02,3.81300e-03,1.01609e+03,
9.73350e+02,3.81368e-03,1.01562e+03,9.72901e+02,3.82614e-03,1.00710e+03,9.64780e+02,3.83922e-03,9.98236e+02,9.56348e+02,
3.84592e-03,9.93735e+02,9.52072e+02,3.85384e-03,9.88444e+02,9.47055e+02,3.86816e-03,9.78971e+02,9.38082e+02,3.89045e-03,
9.64466e+02,9.24347e+02,3.90416e-03,9.55671e+02,9.16017e+02,3.91361e-03,9.49674e+02,9.10329e+02,3.92422e-03,9.43018e+02,
9.04010e+02,3.93409e-03,9.36889e+02,8.98181e+02,3.94250e-03,9.31720e+02,8.93258e+02,3.94250e-03,1.27162e+03,1.21079e+03,
3.94348e-03,1.27088e+03,1.21009e+03,3.95373e-03,1.26315e+03,1.20281e+03,3.97534e-03,1.24711e+03,1.18767e+03,3.98107e-03,
1.24291e+03,1.18370e+03,3.98110e-03,1.24288e+03,1.18368e+03,3.99565e-03,1.23231e+03,1.17369e+03,4.01064e-03,1.22154e+03,
1.16351e+03,4.02504e-03,1.21131e+03,1.15386e+03,4.02717e-03,1.20981e+03,1.15244e+03,4.03849e-03,1.20187e+03,1.14495e+03,
4.05000e-03,1.19387e+03,1.13741e+03,4.05716e-03,1.18862e+03,1.13246e+03,4.07380e-03,1.17653e+03,1.12106e+03,4.07958e-03,
1.17238e+03,1.11714e+03,4.10000e-03,1.15783e+03,1.10344e+03,4.10255e-03,1.15597e+03,1.10169e+03,4.14148e-03,1.12816e+03,
1.07553e+03,4.16869e-03,1.10927e+03,1.05775e+03,4.17524e-03,1.10479e+03,1.05354e+03,4.20584e-03,1.08422e+03,1.03414e+03,
4.21380e-03,1.07897e+03,1.02918e+03,4.21380e-03,1.23954e+03,1.18069e+03,4.22912e-03,1.22854e+03,1.17033e+03,4.24400e-03,
1.21799e+03,1.16039e+03,4.28000e-03,1.19301e+03,1.13685e+03,4.28551e-03,1.18930e+03,1.13334e+03,4.30605e-03,1.17559e+03,
1.12041e+03,4.31519e-03,1.16955e+03,1.11472e+03,4.32670e-03,1.16201e+03,1.10762e+03,4.35189e-03,1.14575e+03,1.09229e+03,
4.36516e-03,1.13731e+03,1.08434e+03,4.37813e-03,1.12913e+03,1.07663e+03,4.41570e-03,1.10591e+03,1.05475e+03,4.41654e-03,
1.10539e+03,1.05426e+03,4.46684e-03,1.07482e+03,1.02544e+03,4.50154e-03,1.05429e+03,1.00608e+03,4.51856e-03,1.04442e+03,
9.96771e+02,4.57088e-03,1.01464e+03,9.68665e+02,4.59410e-03,1.00181e+03,9.56551e+02,4.67735e-03,9.57618e+02,9.14812e+02,
4.70542e-03,9.43359e+02,9.01336e+02,4.78630e-03,9.03880e+02,8.64015e+02,4.80000e-03,8.97430e+02,8.57915e+02,4.88547e-03,
8.57854e+02,8.20448e+02,4.89779e-03,8.52349e+02,8.15236e+02,4.95450e-03,8.27624e+02,7.91817e+02,5.00000e-03,8.08511e+02,
7.73704e+02,5.01187e-03,8.03628e+02,7.69075e+02,5.01190e-03,8.03616e+02,7.69064e+02,5.06386e-03,7.82723e+02,7.49251e+02,
5.06991e-03,7.80340e+02,7.46992e+02,5.12861e-03,7.57747e+02,7.25560e+02,5.23320e-03,7.19721e+02,6.89461e+02,5.24807e-03,
7.14496e+02,6.84497e+02,5.24913e-03,7.14127e+02,6.84147e+02,5.30884e-03,6.93606e+02,6.64656e+02,5.43250e-03,6.53671e+02,
6.26694e+02,5.47962e-03,6.39316e+02,6.13037e+02,5.50000e-03,6.33238e+02,6.07256e+02,5.55904e-03,6.16075e+02,5.90924e+02,
5.62341e-03,5.98065e+02,5.73775e+02,5.68853e-03,5.80591e+02,5.57130e+02,5.75440e-03,5.63634e+02,5.40968e+02,5.78762e-03,
5.55343e+02,5.33063e+02,5.82103e-03,5.47173e+02,5.25273e+02,5.88844e-03,5.31202e+02,5.10041e+02,6.02560e-03,5.00688e+02,
4.80917e+02,6.09537e-03,4.85977e+02,4.66865e+02,6.16595e-03,4.71697e+02,4.53222e+02,6.23735e-03,4.57839e+02,4.39976e+02,
6.30957e-03,4.44439e+02,4.27163e+02,6.30960e-03,4.44434e+02,4.27158e+02,6.38263e-03,4.31427e+02,4.14716e+02,6.53131e-03,
4.06456e+02,3.90812e+02,6.58846e-03,3.97392e+02,3.82130e+02,6.60693e-03,3.94521e+02,3.79381e+02,6.68344e-03,3.82945e+02,
3.68292e+02,6.91831e-03,3.50040e+02,3.36745e+02,6.99842e-03,3.39719e+02,3.26843e+02,7.00000e-03,3.39520e+02,3.26652e+02,
7.16143e-03,3.19979e+02,3.07892e+02,7.22614e-03,3.12562e+02,3.00768e+02,7.24436e-03,3.10516e+02,2.98803e+02,7.32824e-03,
3.01243e+02,2.89895e+02,7.41310e-03,2.92255e+02,2.81258e+02,7.49894e-03,2.83532e+02,2.72872e+02,7.50000e-03,2.83426e+02,
2.72771e+02,7.58578e-03,2.75073e+02,2.64738e+02,7.85236e-03,2.51226e+02,2.41793e+02,7.94328e-03,2.43650e+02,2.34498e+02,
7.94330e-03,2.43649e+02,2.34497e+02,7.97765e-03,2.40873e+02,2.31823e+02,8.12830e-03,2.29197e+02,2.20579e+02,8.31764e-03,
2.15624e+02,2.07502e+02,8.41395e-03,2.09153e+02,2.01265e+02,8.51138e-03,2.02879e+02,1.95217e+02,8.60994e-03,1.96797e+02,
1.89353e+02,8.70964e-03,1.90905e+02,1.83670e+02,8.91251e-03,1.79575e+02,1.72738e+02,8.94126e-03,1.78042e+02,1.71259e+02,
9.01571e-03,1.74155e+02,1.67508e+02,9.22571e-03,1.63814e+02,1.57528e+02,9.33254e-03,1.58882e+02,1.52767e+02,9.50000e-03,
1.51564e+02,1.45700e+02,9.54993e-03,1.49454e+02,1.43662e+02,9.66051e-03,1.44924e+02,1.39286e+02,9.77237e-03,1.40520e+02,
1.35030e+02,1.00000e-02,1.32128e+02,1.26918e+02,1.01158e-02,1.28123e+02,1.23047e+02,1.01705e-02,1.26279e+02,1.21264e+02,
1.02329e-02,1.24222e+02,1.19276e+02,1.03514e-02,1.20440e+02,1.15620e+02,1.04713e-02,1.16777e+02,1.12079e+02,1.05000e-02,
1.15923e+02,1.11254e+02,1.07152e-02,1.09793e+02,1.05326e+02,1.08000e-02,1.07503e+02,1.03111e+02,1.09648e-02,1.03238e+02,
9.89869e+01,1.10000e-02,1.02358e+02,9.81353e+01,1.10918e-02,1.00113e+02,9.59641e+01,1.12202e-02,9.70867e+01,9.30363e+01,
1.15000e-02,9.08806e+01,8.70314e+01,1.16145e-02,8.84855e+01,8.47135e+01,1.17244e-02,8.62660e+01,8.25653e+01,1.17490e-02,
8.57808e+01,8.20961e+01,1.18850e-02,8.31607e+01,7.95616e+01,1.20226e-02,8.06231e+01,7.71069e+01,1.21619e-02,7.81632e+01,
7.47273e+01,1.23027e-02,7.57800e+01,7.24216e+01,1.24451e-02,7.34625e+01,7.01795e+01,1.25890e-02,7.12227e+01,6.80124e+01,
1.25892e-02,7.12189e+01,6.80087e+01,1.26984e-02,6.95826e+01,6.64256e+01,1.27350e-02,6.90454e+01,6.59062e+01,1.30317e-02,
6.49007e+01,6.18985e+01,1.31826e-02,6.29165e+01,5.99798e+01,1.33352e-02,6.09934e+01,5.81201e+01,1.34896e-02,5.91221e+01,
5.63105e+01,1.37246e-02,5.64268e+01,5.37041e+01,1.38038e-02,5.55557e+01,5.28624e+01,1.39637e-02,5.38553e+01,5.12194e+01,
1.41254e-02,5.22089e+01,4.96286e+01,1.44544e-02,4.90684e+01,4.65947e+01,1.46218e-02,4.75683e+01,4.51455e+01,1.48177e-02,
4.58832e+01,4.35176e+01,1.50000e-02,4.43876e+01,4.20742e+01,1.51356e-02,4.33184e+01,4.10425e+01,1.53109e-02,4.19896e+01,
3.97603e+01,1.54882e-02,4.06967e+01,3.85129e+01,1.56675e-02,3.94452e+01,3.73054e+01,1.58489e-02,3.82337e+01,3.61368e+01,
1.58490e-02,3.82332e+01,3.61364e+01,1.59979e-02,3.72778e+01,3.52150e+01,1.62181e-02,3.59228e+01,3.39097e+01,1.64059e-02,
3.48218e+01,3.28495e+01,1.65959e-02,3.37533e+01,3.18205e+01,1.67880e-02,3.27178e+01,3.08236e+01,1.69824e-02,3.17153e+01,
2.98585e+01,1.71791e-02,3.07448e+01,2.89246e+01,1.72457e-02,3.04230e+01,2.86149e+01,1.73780e-02,2.97964e+01,2.80126e+01,
1.75792e-02,2.88780e+01,2.71301e+01,1.77828e-02,2.79889e+01,2.62759e+01,1.80000e-02,2.70820e+01,2.54048e+01,1.81970e-02,
2.62912e+01,2.46453e+01,1.84077e-02,2.54810e+01,2.38673e+01,1.86209e-02,2.46964e+01,2.31141e+01,1.86544e-02,2.45762e+01,
2.29987e+01,1.90546e-02,2.31999e+01,2.16801e+01,1.92752e-02,2.24873e+01,2.09975e+01,1.94985e-02,2.17955e+01,2.03351e+01,
1.98207e-02,2.08476e+01,1.94277e+01,1.99526e-02,2.04761e+01,1.90721e+01,1.99530e-02,2.04750e+01,1.90711e+01,2.00000e-02,
2.03449e+01,1.89466e+01,2.00714e-02,2.01494e+01,1.87596e+01,2.01837e-02,1.98469e+01,1.84707e+01,2.04174e-02,1.92328e+01,
1.78844e+01,2.06538e-02,1.86384e+01,1.73170e+01,2.08930e-02,1.80630e+01,1.67679e+01,2.11349e-02,1.75061e+01,1.62366e+01,
2.13796e-02,1.69649e+01,1.57204e+01,2.15886e-02,1.65213e+01,1.52975e+01,2.21309e-02,1.54405e+01,1.42698e+01,2.23872e-02,
1.49644e+01,1.38174e+01,2.29087e-02,1.40575e+01,1.29561e+01,2.29113e-02,1.40532e+01,1.29519e+01,2.31740e-02,1.36237e+01,
1.25454e+01,2.34423e-02,1.32028e+01,1.21470e+01,2.37137e-02,1.27927e+01,1.17589e+01,2.39752e-02,1.24144e+01,1.14011e+01,
2.42661e-02,1.20102e+01,1.10202e+01,2.45471e-02,1.16370e+01,1.06687e+01,2.48313e-02,1.12760e+01,1.03287e+01,2.51189e-02,
1.09247e+01,9.99967e+00,2.51190e-02,1.09245e+01,9.99951e+00,2.55082e-02,1.04715e+01,9.57534e+00,2.57040e-02,1.02520e+01,
9.37115e+00,2.60584e-02,9.87095e+00,9.01692e+00,2.64876e-02,9.43115e+00,8.61187e+00,2.66073e-02,9.31206e+00,8.50335e+00,
2.67120e-02,9.20961e+00,8.41000e+00,2.68708e-02,9.05546e+00,8.27096e+00,2.69154e-02,9.01239e+00,8.23257e+00,2.70052e-02,
8.92577e+00,8.15526e+00,2.71160e-02,8.81897e+00,8.06117e+00,2.72270e-02,8.71199e+00,7.96844e+00,2.72604e-02,8.68023e+00,
7.94088e+00,2.74983e-02,8.45329e+00,7.74789e+00,2.75423e-02,8.41243e+00,7.71295e+00,2.76446e-02,8.31847e+00,7.63248e+00,
2.77465e-02,8.22914e+00,7.55348e+00,2.78303e-02,8.15952e+00,7.48931e+00,2.78612e-02,8.13513e+00,7.46580e+00,2.79071e-02,
8.09914e+00,7.43112e+00,2.79210e-02,8.08888e+00,7.42069e+00,2.79210e-02,4.71807e+01,1.67957e+01,2.80000e-02,4.68882e+01,
1.67681e+01,2.80079e-02,4.68589e+01,1.67653e+01,2.81243e-02,4.64381e+01,1.67238e+01,2.82700e-02,4.59242e+01,1.66705e+01,
2.82991e-02,4.58153e+01,1.66571e+01,2.84568e-02,4.52335e+01,1.65832e+01,2.85102e-02,4.50382e+01,1.65579e+01,2.85803e-02,
4.47838e+01,1.65244e+01,2.86500e-02,4.45314e+01,1.64909e+01,2.87466e-02,4.41366e+01,1.64256e+01,2.88403e-02,4.37559e+01,
1.63620e+01,2.89276e-02,4.34058e+01,1.63026e+01,2.91743e-02,4.24327e+01,1.61338e+01,2.91947e-02,4.23533e+01,1.61197e+01,
2.93000e-02,4.19470e+01,1.60473e+01,2.95078e-02,4.12282e+01,1.59304e+01,2.98538e-02,4.00664e+01,1.57332e+01,2.99001e-02,
3.99146e+01,1.57066e+01,3.01995e-02,3.89494e+01,1.55338e+01,3.05785e-02,3.76987e+01,1.52906e+01,3.09030e-02,3.66704e+01,
1.50818e+01,3.12214e-02,3.56978e+01,1.48763e+01,3.12608e-02,3.55797e+01,1.48509e+01,3.16228e-02,3.45207e+01,1.46177e+01,
3.16230e-02,3.45200e+01,1.46176e+01,3.19889e-02,3.34934e+01,1.43827e+01,3.22671e-02,3.27414e+01,1.42051e+01,3.23594e-02,
3.24968e+01,1.41463e+01,3.27341e-02,3.15295e+01,1.39089e+01,3.34965e-02,2.97130e+01,1.34472e+01,3.35431e-02,2.96069e+01,
1.34193e+01,3.42768e-02,2.80012e+01,1.29847e+01,3.46737e-02,2.71829e+01,1.27537e+01,3.53242e-02,2.59128e+01,1.23823e+01,
3.54813e-02,2.56183e+01,1.22939e+01,3.58922e-02,2.48701e+01,1.20655e+01,3.63078e-02,2.41429e+01,1.18378e+01,3.67282e-02,
2.34189e+01,1.16022e+01,3.71535e-02,2.27170e+01,1.13687e+01,3.72975e-02,2.24859e+01,1.12907e+01,3.75837e-02,2.20358e+01,
1.11372e+01,3.80189e-02,2.13752e+01,1.09081e+01,3.89045e-02,2.01137e+01,1.04573e+01,3.93550e-02,1.95116e+01,1.02359e+01,
3.98107e-02,1.89278e+01,1.00172e+01,3.98110e-02,1.89275e+01,1.00171e+01,4.01796e-02,1.84730e+01,9.84585e+00,4.16869e-02,
1.67628e+01,9.17909e+00,4.21696e-02,1.62620e+01,8.97678e+00,4.26579e-02,1.57670e+01,8.77213e+00,4.31519e-02,1.52872e+01,
8.57070e+00,4.36516e-02,1.48224e+01,8.37259e+00,4.37538e-02,1.47297e+01,8.33274e+00,4.41570e-02,1.43714e+01,8.17772e+00,
4.51856e-02,1.35105e+01,7.79790e+00,4.57088e-02,1.31000e+01,7.61304e+00,4.67735e-02,1.23166e+01,7.25344e+00,4.73151e-02,
1.19429e+01,7.07867e+00,4.78630e-02,1.15808e+01,6.90725e+00,4.84521e-02,1.12084e+01,6.72878e+00,4.95450e-02,1.05599e+01,
6.41287e+00,5.01187e-02,1.02400e+01,6.25440e+00,5.01190e-02,1.02398e+01,6.25432e+00,5.12861e-02,9.62930e+00,5.94717e+00,
5.18800e-02,9.33806e+00,5.79834e+00,5.24807e-02,9.05576e+00,5.65263e+00,5.25069e-02,9.04374e+00,5.64639e+00,5.30884e-02,
8.78198e+00,5.51003e+00,5.49541e-02,7.99743e+00,5.09192e+00,5.55904e-02,7.75217e+00,4.95881e+00,5.62341e-02,7.51455e+00,
4.82871e+00,5.65692e-02,7.39485e+00,4.76276e+00,5.82103e-02,6.84503e+00,4.45625e+00,5.88844e-02,6.63570e+00,4.33790e+00,
6.16595e-02,5.86120e+00,3.89288e+00,6.22273e-02,5.71847e+00,3.80936e+00,6.30957e-02,5.50929e+00,3.68614e+00,6.30960e-02,
5.50922e+00,3.68610e+00,6.38264e-02,5.34137e+00,3.58656e+00,6.60693e-02,4.86863e+00,3.30239e+00,6.68344e-02,4.71871e+00,
3.21082e+00,6.76083e-02,4.57357e+00,3.12160e+00,7.07856e-02,4.03906e+00,2.78811e+00,7.07946e-02,4.03768e+00,2.78724e+00,
7.41310e-02,3.56586e+00,2.48618e+00,7.49894e-02,3.45710e+00,2.41582e+00,7.67362e-02,3.24985e+00,2.28070e+00,7.76247e-02,
3.15113e+00,2.21586e+00,7.94328e-02,2.96300e+00,2.09138e+00,7.94330e-02,2.96299e+00,2.09137e+00,8.03526e-02,2.87331e+00,
2.03169e+00,8.31764e-02,2.62090e+00,1.86221e+00,8.60994e-02,2.38935e+00,1.70445e+00,8.68568e-02,2.33409e+00,1.66650e+00,
9.01571e-02,2.11340e+00,1.51382e+00,9.33254e-02,1.92871e+00,1.38454e+00,9.44061e-02,1.87105e+00,1.34388e+00,9.66051e-02,
1.76119e+00,1.26603e+00,9.77237e-02,1.70889e+00,1.22881e+00,9.88553e-02,1.65825e+00,1.19267e+00,1.00000e-01,1.60923e+00,
1.15757e+00,1.05925e-01,1.38623e+00,9.96848e-01,1.08393e-01,1.30603e+00,9.38395e-01,1.11830e-01,1.20532e+00,8.64539e-01,
1.12202e-01,1.19512e+00,8.57037e-01,1.13501e-01,1.16046e+00,8.31504e-01,1.16145e-01,1.09443e+00,7.82690e-01,1.20226e-01,
1.00310e+00,7.14791e-01,1.24452e-01,9.20255e-01,6.52801e-01,1.25890e-01,8.94434e-01,6.33404e-01,1.25893e-01,8.94390e-01,
6.33371e-01,1.28825e-01,8.44959e-01,5.96300e-01,1.30317e-01,8.21418e-01,5.78600e-01,1.31826e-01,7.98624e-01,5.61433e-01,
1.33352e-01,7.76555e-01,5.44786e-01,1.34896e-01,7.55184e-01,5.28641e-01,1.36458e-01,7.34493e-01,5.12986e-01,1.36494e-01,
7.34037e-01,5.12640e-01,1.38038e-01,7.14439e-01,4.97805e-01,1.39637e-01,6.95013e-01,4.83079e-01,1.51356e-01,5.75202e-01,
3.91826e-01,1.53109e-01,5.60180e-01,3.80334e-01,1.56675e-01,5.31540e-01,3.58396e-01,1.58489e-01,5.17892e-01,3.47929e-01,
1.58490e-01,5.17886e-01,3.47925e-01,1.64059e-01,4.79287e-01,3.18505e-01,1.65959e-01,4.67215e-01,3.09294e-01,1.67880e-01,
4.55520e-01,3.00368e-01,1.71791e-01,4.33213e-01,2.83334e-01,1.72213e-01,4.30916e-01,2.81579e-01,1.73780e-01,4.22567e-01,
2.75209e-01,1.77828e-01,4.02253e-01,2.59705e-01,1.79887e-01,3.92566e-01,2.52310e-01,1.84077e-01,3.74085e-01,2.38203e-01,
1.88365e-01,3.56728e-01,2.24957e-01,1.92752e-01,3.40426e-01,2.12520e-01,1.94984e-01,3.32648e-01,2.06590e-01,1.97242e-01,
3.25110e-01,2.00844e-01,1.99526e-01,3.17804e-01,1.95278e-01,1.99530e-01,3.17793e-01,1.95269e-01,2.01837e-01,3.10672e-01,
1.89913e-01,2.06538e-01,2.97158e-01,1.79776e-01,2.08496e-01,2.91854e-01,1.75804e-01,2.11349e-01,2.84436e-01,1.70261e-01,
2.13796e-01,2.78360e-01,1.65725e-01,2.18776e-01,2.66745e-01,1.57069e-01,2.21309e-01,2.61196e-01,1.52940e-01,2.23872e-01,
2.55812e-01,1.48939e-01,2.26464e-01,2.50589e-01,1.45061e-01,2.26510e-01,2.50499e-01,1.44995e-01,2.29087e-01,2.45519e-01,
1.41303e-01,2.34423e-01,2.35826e-01,1.34133e-01,2.37137e-01,2.31194e-01,1.30714e-01,2.39883e-01,2.26697e-01,1.27400e-01,
2.45471e-01,2.18096e-01,1.21077e-01,2.48313e-01,2.14024e-01,1.18099e-01,2.51189e-01,2.10069e-01,1.15212e-01,2.51190e-01,
2.10067e-01,1.15211e-01,2.54097e-01,2.06185e-01,1.12441e-01,2.60016e-01,1.98745e-01,1.07149e-01,2.63027e-01,1.95186e-01,
1.04627e-01,2.66073e-01,1.91728e-01,1.02182e-01,2.72270e-01,1.85101e-01,9.75154e-02,2.73294e-01,1.84056e-01,9.67819e-02,
2.78612e-01,1.78832e-01,9.31282e-02,2.81838e-01,1.75826e-01,9.10341e-02,2.85102e-01,1.72904e-01,8.90036e-02,2.88403e-01,
1.70097e-01,8.70667e-02,2.95121e-01,1.64708e-01,8.33646e-02,2.98538e-01,1.62122e-01,8.15962e-02,3.00006e-01,1.61042e-01,
8.08591e-02,3.05492e-01,1.57157e-01,7.82164e-02,3.12608e-01,1.52458e-01,7.50398e-02,3.16228e-01,1.50201e-01,7.35217e-02,
3.16230e-01,1.50199e-01,7.35208e-02,3.23594e-01,1.45798e-01,7.06701e-02,3.27341e-01,1.43681e-01,6.93073e-02,3.31131e-01,
1.41619e-01,6.79850e-02,3.34965e-01,1.39635e-01,6.67246e-02,3.38844e-01,1.37700e-01,6.55007e-02,3.42768e-01,1.35813e-01,
6.43124e-02,3.46737e-01,1.33973e-01,6.31583e-02,3.50752e-01,1.32179e-01,6.20374e-02,3.54813e-01,1.30429e-01,6.09487e-02,
3.58922e-01,1.28724e-01,5.98933e-02,3.63078e-01,1.27060e-01,5.88680e-02,3.67282e-01,1.25438e-01,5.78726e-02,3.71535e-01,
1.23854e-01,5.69055e-02,3.75837e-01,1.22309e-01,5.59659e-02,3.80189e-01,1.20818e-01,5.50702e-02,3.84592e-01,1.19363e-01,
5.41995e-02,3.89045e-01,1.17941e-01,5.33530e-02,3.90447e-01,1.17503e-01,5.30932e-02,3.93550e-01,1.16551e-01,5.25298e-02,
3.98107e-01,1.15192e-01,5.17292e-02,3.98110e-01,1.15191e-01,5.17288e-02,4.02717e-01,1.13838e-01,5.09739e-02,4.07380e-01,
1.12515e-01,5.02408e-02,4.12098e-01,1.11222e-01,4.95277e-02,4.21697e-01,1.08721e-01,4.81594e-02,4.26580e-01,1.07526e-01,
4.75164e-02,4.31519e-01,1.06356e-01,4.68903e-02,4.36516e-01,1.05211e-01,4.62805e-02,4.41570e-01,1.04090e-01,4.56868e-02,
4.51856e-01,1.01919e-01,4.45449e-02,4.57088e-01,1.00867e-01,4.39960e-02,4.62381e-01,9.98372e-02,4.34623e-02,4.67735e-01,
9.88291e-02,4.29424e-02,4.78630e-01,9.68953e-02,4.19628e-02,4.89779e-01,9.50365e-02,4.10306e-02,4.95450e-01,9.41340e-02,
4.05813e-02,5.01187e-01,9.32487e-02,4.01429e-02,5.01190e-01,9.32482e-02,4.01427e-02,5.06991e-01,9.23566e-02,3.97346e-02,
5.12861e-01,9.14811e-02,3.93359e-02,5.18800e-01,9.06229e-02,3.89476e-02,5.24808e-01,8.97895e-02,3.85771e-02,5.37032e-01,
8.81670e-02,3.78608e-02,5.49541e-01,8.66008e-02,3.71754e-02,5.55904e-01,8.58379e-02,3.68438e-02,5.62341e-01,8.50881e-02,
3.65194e-02,5.68853e-01,8.43511e-02,3.62019e-02,5.75440e-01,8.36266e-02,3.58911e-02,5.83528e-01,8.27748e-02,3.55330e-02,
5.88844e-01,8.22298e-02,3.53050e-02,6.00000e-01,8.11236e-02,3.48442e-02,6.02560e-01,8.08767e-02,3.47417e-02,6.09537e-01,
8.02162e-02,3.44682e-02,6.16595e-01,7.95661e-02,3.42000e-02,6.23735e-01,7.89261e-02,3.39369e-02,6.30957e-01,7.82961e-02,
3.36788e-02,6.30960e-01,7.82958e-02,3.36787e-02,6.38264e-01,7.76548e-02,3.34425e-02,6.45654e-01,7.70301e-02,3.32169e-02,
6.53131e-01,7.64143e-02,3.29951e-02,6.68344e-01,7.52093e-02,3.25621e-02,6.76083e-01,7.46197e-02,3.23507e-02,6.83912e-01,
7.40383e-02,3.21427e-02,6.91831e-01,7.34651e-02,3.19379e-02,6.99842e-01,7.28999e-02,3.17362e-02,7.07946e-01,7.23425e-02,
3.15376e-02,7.08570e-01,7.23005e-02,3.15229e-02,7.32825e-01,7.07305e-02,3.09740e-02,7.41310e-01,7.02072e-02,3.07912e-02,
7.49894e-01,6.96906e-02,3.06108e-02,7.58578e-01,6.91807e-02,3.04327e-02,7.67362e-01,6.86772e-02,3.02570e-02,7.85236e-01,
6.76892e-02,2.99121e-02,7.94328e-01,6.72085e-02,2.97469e-02,7.94330e-01,6.72084e-02,2.97468e-02,8.03526e-01,6.67145e-02,
2.95961e-02,8.12831e-01,6.62264e-02,2.94467e-02,8.22243e-01,6.57440e-02,2.92987e-02,8.31764e-01,6.52673e-02,2.91520e-02,
8.41395e-01,6.47962e-02,2.90066e-02,8.51138e-01,6.43305e-02,2.88624e-02,8.60994e-01,6.38701e-02,2.87195e-02,8.70964e-01,
6.34153e-02,2.85781e-02,8.81049e-01,6.29688e-02,2.84410e-02,8.91251e-01,6.25272e-02,2.83049e-02,9.01571e-01,6.20904e-02,
2.81697e-02,9.12011e-01,6.16584e-02,2.80355e-02,9.22571e-01,6.12310e-02,2.79022e-02,9.44061e-01,6.03897e-02,2.76382e-02,
9.54993e-01,5.99760e-02,2.75078e-02,9.63374e-01,5.96670e-02,2.74115e-02,9.66051e-01,5.95694e-02,2.73810e-02,9.77237e-01,
5.91667e-02,2.72548e-02,9.88553e-01,5.87680e-02,2.71293e-02,1.00000e+00,5.83734e-02,2.70045e-02,1.00000e-03,8.16736e+03,
8.15977e+03,1.01158e-03,7.97028e+03,7.96271e+03,1.03773e-03,7.54877e+03,7.54122e+03,1.04713e-03,7.40527e+03,7.39773e+03,
1.07152e-03,7.04732e+03,7.03981e+03,1.08393e-03,6.87274e+03,6.86524e+03,1.09648e-03,6.70266e+03,6.69517e+03,1.09815e-03,
6.68034e+03,6.67285e+03,1.10918e-03,6.53573e+03,6.52826e+03,1.12202e-03,6.37306e+03,6.36561e+03,1.14815e-03,6.05638e+03,
6.04897e+03,1.15000e-03,6.03492e+03,6.02750e+03,1.15645e-03,5.96010e+03,5.95269e+03,1.20226e-03,5.46492e+03,5.45759e+03,
1.21619e-03,5.32614e+03,5.31883e+03,1.22880e-03,5.20414e+03,5.19685e+03,1.23027e-03,5.19019e+03,5.18291e+03,1.24451e-03,
5.05750e+03,5.05024e+03,1.25890e-03,4.92785e+03,4.92061e+03,1.25892e-03,4.92763e+03,4.92039e+03,1.28825e-03,4.67842e+03,
4.67123e+03,1.30000e-03,4.58295e+03,4.57578e+03,1.31826e-03,4.43919e+03,4.43205e+03,1.33000e-03,4.35015e+03,4.34303e+03,
1.36458e-03,4.10187e+03,4.09480e+03,1.38038e-03,3.99441e+03,3.98737e+03,1.41254e-03,3.78838e+03,3.78138e+03,1.42889e-03,
3.68853e+03,3.68156e+03,1.45000e-03,3.56503e+03,3.55809e+03,1.46218e-03,3.49655e+03,3.48962e+03,1.49624e-03,3.31404e+03,
3.30716e+03,1.50055e-03,3.29196e+03,3.28509e+03,1.51356e-03,3.22661e+03,3.21976e+03,1.54882e-03,3.05759e+03,3.05080e+03,
1.56675e-03,2.97657e+03,2.96981e+03,1.58489e-03,2.89784e+03,2.89110e+03,1.58490e-03,2.89781e+03,2.89107e+03,1.61000e-03,
2.79238e+03,2.78569e+03,1.62181e-03,2.74458e+03,2.73790e+03,1.64059e-03,2.67095e+03,2.66430e+03,1.65000e-03,2.63514e+03,
2.62851e+03,1.67880e-03,2.52967e+03,2.52308e+03,1.69824e-03,2.46195e+03,2.45539e+03,1.71791e-03,2.39575e+03,2.38923e+03,
1.73780e-03,2.33104e+03,2.32454e+03,1.75792e-03,2.26744e+03,2.26097e+03,1.76455e-03,2.24705e+03,2.24059e+03,1.77828e-03,
2.20562e+03,2.19918e+03,1.79887e-03,2.14557e+03,2.13917e+03,1.84077e-03,2.03053e+03,2.02419e+03,1.86209e-03,1.97545e+03,
1.96915e+03,1.88365e-03,1.92193e+03,1.91565e+03,1.90546e-03,1.86971e+03,1.86346e+03,1.91254e-03,1.85316e+03,1.84693e+03,
1.92753e-03,1.81885e+03,1.81264e+03,1.95000e-03,1.76878e+03,1.76260e+03,1.97242e-03,1.72050e+03,1.71436e+03,1.99526e-03,
1.67315e+03,1.66705e+03,1.99530e-03,1.67308e+03,1.66697e+03,2.00000e-03,1.66356e+03,1.65746e+03,2.01837e-03,1.62714e+03,
1.62107e+03,2.06538e-03,1.53909e+03,1.53308e+03,2.07000e-03,1.53081e+03,1.52481e+03,2.08930e-03,1.49693e+03,1.49095e+03,
2.09715e-03,1.48346e+03,1.47749e+03,2.11349e-03,1.45599e+03,1.45005e+03,2.16272e-03,1.37634e+03,1.37047e+03,2.18776e-03,
1.33802e+03,1.33219e+03,2.21310e-03,1.30077e+03,1.29497e+03,2.29087e-03,1.19529e+03,1.18959e+03,2.29582e-03,1.18901e+03,
1.18332e+03,2.31740e-03,1.16215e+03,1.15649e+03,2.34423e-03,1.12987e+03,1.12425e+03,2.37137e-03,1.09852e+03,1.09294e+03,
2.41109e-03,1.05447e+03,1.04894e+03,2.42661e-03,1.03793e+03,1.03242e+03,2.45471e-03,1.00879e+03,1.00333e+03,2.48313e-03,
9.80498e+02,9.75074e+02,2.51189e-03,9.53040e+02,9.47656e+02,2.51190e-03,9.53027e+02,9.47643e+02,2.54097e-03,9.26352e+02,
9.21008e+02,2.57040e-03,9.00463e+02,8.95159e+02,2.60016e-03,8.75275e+02,8.70010e+02,2.64055e-03,8.42376e+02,8.37163e+02,
2.65000e-03,8.34928e+02,8.29729e+02,2.66073e-03,8.26565e+02,8.21381e+02,2.69154e-03,8.03194e+02,7.98053e+02,2.72270e-03,
7.80409e+02,7.75311e+02,2.75948e-03,7.54713e+02,7.49664e+02,2.78612e-03,7.36834e+02,7.31824e+02,2.81838e-03,7.15993e+02,
7.11030e+02,2.85102e-03,6.95765e+02,6.90847e+02,2.87434e-03,6.81776e+02,6.76891e+02,2.91743e-03,6.56947e+02,6.52125e+02,
2.95121e-03,6.38267e+02,6.33494e+02,3.00000e-03,6.12621e+02,6.07916e+02,3.00230e-03,6.11444e+02,6.06742e+02,3.01995e-03,
6.02526e+02,5.97851e+02,3.11336e-03,5.57988e+02,5.53451e+02,3.12608e-03,5.52282e+02,5.47766e+02,3.14069e-03,5.45833e+02,
5.41340e+02,3.16228e-03,5.36517e+02,5.32058e+02,3.16230e-03,5.36508e+02,5.32049e+02,3.21818e-03,5.13406e+02,5.09032e+02,
3.23594e-03,5.06353e+02,5.02009e+02,3.31013e-03,4.78095e+02,4.73870e+02,3.31131e-03,4.77663e+02,4.73440e+02,3.34965e-03,
4.63955e+02,4.59799e+02,3.40022e-03,4.46680e+02,4.42611e+02,3.42768e-03,4.37668e+02,4.33650e+02,3.46737e-03,4.25020e+02,
4.21075e+02,3.47154e-03,4.23722e+02,4.19784e+02,3.50752e-03,4.12743e+02,4.08878e+02,3.53977e-03,4.03244e+02,3.99444e+02,
3.54813e-03,4.00829e+02,3.97047e+02,3.58922e-03,3.89253e+02,3.85561e+02,3.59717e-03,3.87063e+02,3.83388e+02,3.64497e-03,
3.74235e+02,3.70674e+02,3.65000e-03,3.72918e+02,3.69372e+02,3.68573e-03,3.63696e+02,3.60245e+02,3.71535e-03,3.56274e+02,
3.52913e+02,3.72338e-03,3.54302e+02,3.50964e+02,3.75595e-03,3.46434e+02,3.43209e+02,3.75837e-03,3.45857e+02,3.42642e+02,
3.78253e-03,3.40181e+02,3.37064e+02,3.80189e-03,3.35708e+02,3.32683e+02,3.80462e-03,3.35085e+02,3.32073e+02,3.82324e-03,
3.30847e+02,3.27939e+02,3.83675e-03,3.27808e+02,3.24984e+02,3.84592e-03,3.25761e+02,3.23000e+02,3.86606e-03,3.21318e+02,
3.18691e+02,3.88407e-03,3.17420e+02,3.14903e+02,3.89515e-03,3.15070e+02,3.12604e+02,3.90225e-03,3.13586e+02,3.11144e+02,
3.90784e-03,3.12431e+02,3.10002e+02,3.91404e-03,3.11162e+02,3.08740e+02,3.92216e-03,3.09521e+02,3.07098e+02,3.92680e-03,
3.08597e+02,3.06167e+02,3.92680e-03,9.78561e+02,9.34395e+02,3.93058e-03,9.76274e+02,9.32238e+02,3.93550e-03,9.73306e+02,
9.29434e+02,3.93677e-03,9.72547e+02,9.28716e+02,3.94554e-03,9.67313e+02,9.23761e+02,3.95946e-03,9.59108e+02,9.15971e+02,
3.98107e-03,9.46585e+02,9.04057e+02,3.98110e-03,9.46569e+02,9.04042e+02,3.98620e-03,9.43648e+02,9.01261e+02,3.99647e-03,
9.37807e+02,8.95703e+02,4.00000e-03,9.35807e+02,8.93803e+02,4.00733e-03,9.31674e+02,8.89874e+02,4.01998e-03,9.24595e+02,
8.83154e+02,4.02717e-03,9.20600e+02,8.79369e+02,4.03581e-03,9.15818e+02,8.74837e+02,4.05008e-03,9.07983e+02,8.67427e+02,
4.06613e-03,8.99270e+02,8.59200e+02,4.07000e-03,8.97183e+02,8.57231e+02,4.07380e-03,8.95004e+02,8.55173e+02,4.08150e-03,
8.90607e+02,8.51022e+02,4.11762e-03,8.70365e+02,8.31915e+02,4.13794e-03,8.59271e+02,8.21422e+02,4.15598e-03,8.49611e+02,
8.12262e+02,4.16080e-03,8.47061e+02,8.09837e+02,4.16080e-03,1.15233e+03,1.09346e+03,4.16869e-03,1.14742e+03,1.08886e+03,
4.17552e-03,1.14320e+03,1.08490e+03,4.21696e-03,1.11814e+03,1.06133e+03,4.22414e-03,1.11389e+03,1.05733e+03,4.24144e-03,
1.10374e+03,1.04778e+03,4.25832e-03,1.09395e+03,1.03858e+03,4.26579e-03,1.08965e+03,1.03454e+03,4.27843e-03,1.08244e+03,
1.02777e+03,4.28000e-03,1.08155e+03,1.02694e+03,4.29500e-03,1.07231e+03,1.01826e+03,4.29803e-03,1.07034e+03,1.01641e+03,
4.31519e-03,1.05926e+03,1.00600e+03,4.32215e-03,1.05481e+03,1.00182e+03,4.35500e-03,1.03411e+03,9.82432e+02,4.36410e-03,
1.02860e+03,9.77264e+02,4.39967e-03,1.00741e+03,9.57408e+02,4.41570e-03,9.98067e+02,9.48643e+02,4.43105e-03,9.89245e+02,
9.40361e+02,4.44030e-03,9.83985e+02,9.35415e+02,4.44030e-03,1.13149e+03,1.07398e+03,4.45637e-03,1.12155e+03,1.06466e+03,
4.47200e-03,1.11200e+03,1.05570e+03,4.51544e-03,1.08582e+03,1.03113e+03,4.51856e-03,1.08398e+03,1.02940e+03,4.53531e-03,
1.07414e+03,1.02015e+03,4.56000e-03,1.05984e+03,1.00674e+03,4.57088e-03,1.05363e+03,1.00091e+03,4.58641e-03,1.04484e+03,
9.92663e+02,4.62194e-03,1.02511e+03,9.74145e+02,4.62381e-03,1.02408e+03,9.73182e+02,4.65000e-03,1.01005e+03,9.60017e+02,
4.66034e-03,1.00449e+03,9.54802e+02,4.67735e-03,9.95447e+02,9.46313e+02,4.71304e-03,9.76856e+02,9.28860e+02,4.78630e-03,
9.40183e+02,8.94419e+02,4.80000e-03,9.33479e+02,8.88119e+02,4.80528e-03,9.30913e+02,8.85706e+02,4.84172e-03,9.13458e+02,
8.69302e+02,4.89779e-03,8.87505e+02,8.44897e+02,4.91235e-03,8.80933e+02,8.38714e+02,4.95450e-03,8.62280e+02,8.21165e+02,
5.01187e-03,8.37582e+02,7.97911e+02,5.01190e-03,8.37570e+02,7.97900e+02,5.03433e-03,8.28072e+02,7.88952e+02,5.06991e-03,
8.13306e+02,7.75040e+02,5.12861e-03,7.89752e+02,7.52838e+02,5.18800e-03,7.66898e+02,7.31281e+02,5.20186e-03,7.61706e+02,
7.26382e+02,5.24807e-03,7.44735e+02,7.10367e+02,5.30884e-03,7.23231e+02,6.90065e+02,5.37878e-03,6.99425e+02,6.67572e+02,
5.43250e-03,6.81869e+02,6.50978e+02,5.49541e-03,6.62111e+02,6.32294e+02,5.50000e-03,6.60701e+02,6.30961e+02,5.60007e-03,
6.30778e+02,6.02636e+02,5.62341e-03,6.24067e+02,5.96282e+02,5.68853e-03,6.05880e+02,5.79060e+02,5.82103e-03,5.71080e+02,
5.46077e+02,5.83078e-03,5.68634e+02,5.43758e+02,5.88844e-03,5.54452e+02,5.30308e+02,5.95662e-03,5.38240e+02,5.14924e+02,
6.02560e-03,5.22430e+02,4.99912e+02,6.09537e-03,5.07060e+02,4.85310e+02,6.12615e-03,5.00484e+02,4.79060e+02,6.16595e-03,
4.92152e+02,4.71142e+02,6.23735e-03,4.77690e+02,4.57392e+02,6.30957e-03,4.63675e+02,4.44061e+02,6.30960e-03,4.63670e+02,
4.44056e+02,6.45654e-03,4.36873e+02,4.18548e+02,6.50785e-03,4.28032e+02,4.10127e+02,6.60693e-03,4.11644e+02,3.94514e+02,
6.68344e-03,3.99612e+02,3.83046e+02,6.76083e-03,3.87878e+02,3.71855e+02,6.83912e-03,3.76492e+02,3.60991e+02,6.91831e-03,
3.65452e+02,3.50453e+02,6.97297e-03,3.58100e+02,3.43433e+02,6.99842e-03,3.54746e+02,3.40230e+02,7.00000e-03,3.54539e+02,
3.40033e+02,7.07946e-03,3.44310e+02,3.30263e+02,7.16143e-03,3.34190e+02,3.20594e+02,7.24436e-03,3.24296e+02,3.11135e+02,
7.32824e-03,3.14698e+02,3.01955e+02,7.41310e-03,3.05388e+02,2.93048e+02,7.49894e-03,2.96351e+02,2.84398e+02,7.58848e-03,
2.87323e+02,2.75754e+02,7.67362e-03,2.79088e+02,2.67869e+02,7.76247e-03,2.70750e+02,2.59880e+02,7.94328e-03,2.54795e+02,
2.44586e+02,7.94330e-03,2.54793e+02,2.44585e+02,8.00000e-03,2.50064e+02,2.40049e+02,8.03526e-03,2.47184e+02,2.37287e+02,
8.12830e-03,2.39801e+02,2.30204e+02,8.22243e-03,2.32641e+02,2.23332e+02,8.31764e-03,2.25651e+02,2.16622e+02,8.32737e-03,
2.24954e+02,2.15952e+02,8.41395e-03,2.18875e+02,2.10116e+02,8.51138e-03,2.12300e+02,2.03802e+02,8.70964e-03,1.99709e+02,
1.91706e+02,8.81049e-03,1.93706e+02,1.85936e+02,9.01571e-03,1.82255e+02,1.74927e+02,9.12011e-03,1.76795e+02,1.69676e+02,
9.22571e-03,1.71503e+02,1.64585e+02,9.31610e-03,1.67148e+02,1.60394e+02,9.33254e-03,1.66372e+02,1.59647e+02,9.44061e-03,
1.61360e+02,1.54825e+02,9.54993e-03,1.56499e+02,1.50146e+02,9.66051e-03,1.51784e+02,1.45606e+02,9.80000e-03,1.46115e+02,
1.40148e+02,9.88553e-03,1.42777e+02,1.36932e+02,1.00000e-02,1.38435e+02,1.32748e+02,1.02329e-02,1.30157e+02,1.24770e+02,
1.03514e-02,1.26213e+02,1.20968e+02,1.04056e-02,1.24466e+02,1.19284e+02,1.04713e-02,1.22389e+02,1.17282e+02,1.05925e-02,
1.18683e+02,1.13710e+02,1.07152e-02,1.15082e+02,1.10238e+02,1.08393e-02,1.11593e+02,1.06873e+02,1.09648e-02,1.08197e+02,
1.03597e+02,1.10918e-02,1.04907e+02,1.00423e+02,1.12202e-02,1.01718e+02,9.73469e+01,1.13501e-02,9.86294e+01,9.43667e+01,
1.15738e-02,9.36150e+01,8.95276e+01,1.16145e-02,9.27408e+01,8.86843e+01,1.17490e-02,8.99338e+01,8.59761e+01,1.20226e-02,
8.45805e+01,8.08107e+01,1.21619e-02,8.19903e+01,7.83104e+01,1.23027e-02,7.94820e+01,7.58890e+01,1.24451e-02,7.70530e+01,
7.35440e+01,1.25890e-02,7.47041e+01,7.12763e+01,1.25892e-02,7.47001e+01,7.12724e+01,1.26968e-02,7.30078e+01,6.96385e+01,
1.28825e-02,7.02078e+01,6.69367e+01,1.30317e-02,6.80685e+01,6.48723e+01,1.31826e-02,6.59861e+01,6.28627e+01,1.33352e-02,
6.39701e+01,6.09170e+01,1.34896e-02,6.20178e+01,5.90329e+01,1.35000e-02,6.18897e+01,5.89093e+01,1.36458e-02,6.01272e+01,
5.72083e+01,1.38038e-02,5.82955e+01,5.54404e+01,1.39035e-02,5.71803e+01,5.43643e+01,1.39637e-02,5.65212e+01,5.37287e+01,
1.41254e-02,5.48018e+01,5.20708e+01,1.44544e-02,5.14854e+01,4.88725e+01,1.47911e-02,4.83769e+01,4.58749e+01,1.50000e-02,
4.65797e+01,4.41421e+01,1.53109e-02,4.40757e+01,4.17279e+01,1.54882e-02,4.27307e+01,4.04314e+01,1.55048e-02,4.26078e+01,
4.03130e+01,1.56675e-02,4.14269e+01,3.91759e+01,1.58489e-02,4.01594e+01,3.79556e+01,1.58490e-02,4.01589e+01,3.79551e+01,
1.60324e-02,3.89250e+01,3.67671e+01,1.62181e-02,3.77287e+01,3.56154e+01,1.64059e-02,3.65654e+01,3.44956e+01,1.67805e-02,
3.43924e+01,3.24042e+01,1.69824e-02,3.32934e+01,3.13477e+01,1.71791e-02,3.22709e+01,3.03651e+01,1.77828e-02,2.93952e+01,
2.76027e+01,1.79885e-02,2.84978e+01,2.67410e+01,1.80000e-02,2.84488e+01,2.66940e+01,1.81970e-02,2.76250e+01,2.59041e+01,
1.84077e-02,2.67807e+01,2.50947e+01,1.85000e-02,2.64211e+01,2.47499e+01,1.88365e-02,2.51568e+01,2.35380e+01,1.90546e-02,
2.43791e+01,2.27926e+01,1.94908e-02,2.29230e+01,2.13975e+01,1.97242e-02,2.21916e+01,2.06981e+01,1.99526e-02,2.15082e+01,
2.00448e+01,1.99530e-02,2.15071e+01,2.00437e+01,2.00000e-02,2.13701e+01,1.99128e+01,2.06538e-02,1.95858e+01,1.82082e+01,
2.08930e-02,1.89856e+01,1.76351e+01,2.09193e-02,1.89210e+01,1.75735e+01,2.11349e-02,1.84034e+01,1.70803e+01,2.13796e-02,
1.78384e+01,1.65421e+01,2.16272e-02,1.72903e+01,1.60200e+01,2.21309e-02,1.62387e+01,1.50187e+01,2.23872e-02,1.57362e+01,
1.45403e+01,2.24853e-02,1.55497e+01,1.43629e+01,2.26464e-02,1.52492e+01,1.40775e+01,2.31740e-02,1.43210e+01,1.31967e+01,
2.34423e-02,1.38792e+01,1.27777e+01,2.38298e-02,1.32745e+01,1.22045e+01,2.39883e-02,1.30369e+01,1.19799e+01,2.42661e-02,
1.26351e+01,1.16004e+01,2.45471e-02,1.22461e+01,1.12329e+01,2.48313e-02,1.18687e+01,1.08767e+01,2.50163e-02,1.16320e+01,
1.06532e+01,2.51189e-02,1.15030e+01,1.05320e+01,2.51190e-02,1.15029e+01,1.05318e+01,2.54097e-02,1.11449e+01,1.01953e+01,
2.59398e-02,1.05317e+01,9.61911e+00,2.63027e-02,1.01366e+01,9.24990e+00,2.66073e-02,9.82006e+00,8.95406e+00,2.66375e-02,
9.78938e+00,8.92540e+00,2.72173e-02,9.22296e+00,8.39975e+00,2.75423e-02,8.92244e+00,8.12335e+00,2.76287e-02,8.84494e+00,
8.05208e+00,2.78275e-02,8.66847e+00,7.89120e+00,2.79874e-02,8.52896e+00,7.76501e+00,2.81325e-02,8.40378e+00,7.65282e+00,
2.81838e-02,8.35960e+00,7.61370e+00,2.82652e-02,8.29021e+00,7.55223e+00,2.83765e-02,8.19535e+00,7.46933e+00,2.85102e-02,
8.08131e+00,7.37127e+00,2.85277e-02,8.06651e+00,7.35853e+00,2.88403e-02,7.80451e+00,7.13644e+00,2.88811e-02,7.77121e+00,
7.10812e+00,2.90000e-02,7.67831e+00,7.02641e+00,2.90016e-02,7.67709e+00,7.02533e+00,2.90892e-02,7.61208e+00,6.96555e+00,
2.91743e-02,7.55270e+00,6.90812e+00,2.91840e-02,7.54596e+00,6.90160e+00,2.91840e-02,4.34557e+01,1.52244e+01,2.91879e-02,
4.34445e+01,1.52239e+01,2.92746e-02,4.32006e+01,1.52122e+01,2.93700e-02,4.29376e+01,1.51987e+01,2.95113e-02,4.24686e+01,
1.51455e+01,2.97688e-02,4.16363e+01,1.50460e+01,2.99147e-02,4.11735e+01,1.49883e+01,3.00000e-02,4.09047e+01,1.49540e+01,
3.00848e-02,4.06005e+01,1.49049e+01,3.01995e-02,4.01916e+01,1.48381e+01,3.02860e-02,3.98874e+01,1.47876e+01,3.05492e-02,
3.89770e+01,1.46330e+01,3.05785e-02,3.88775e+01,1.46167e+01,3.07000e-02,3.84672e+01,1.45488e+01,3.09030e-02,3.78493e+01,
1.44556e+01,3.09184e-02,3.78030e+01,1.44485e+01,3.12608e-02,3.67917e+01,1.42887e+01,3.13326e-02,3.65844e+01,1.42548e+01,
3.16228e-02,3.57619e+01,1.41167e+01,3.16230e-02,3.57613e+01,1.41166e+01,3.19889e-02,3.47015e+01,1.39160e+01,3.23594e-02,
3.36712e+01,1.37122e+01,3.27341e-02,3.26720e+01,1.35057e+01,3.29579e-02,3.20947e+01,1.33824e+01,3.31131e-02,3.17024e+01,
1.32970e+01,3.34965e-02,3.07611e+01,1.30863e+01,3.38844e-02,2.98471e+01,1.28738e+01,3.39369e-02,2.97263e+01,1.28451e+01,
3.42768e-02,2.89596e+01,1.26601e+01,3.54336e-02,2.65870e+01,1.20593e+01,3.54813e-02,2.64950e+01,1.20348e+01,3.63078e-02,
2.49699e+01,1.16174e+01,3.67282e-02,2.42412e+01,1.14092e+01,3.75837e-02,2.28475e+01,1.09950e+01,3.75932e-02,2.28323e+01,
1.09903e+01,3.80189e-02,2.21652e+01,1.07816e+01,3.84592e-02,2.15036e+01,1.05697e+01,3.89045e-02,2.08621e+01,1.03595e+01,
3.93550e-02,2.02391e+01,1.01508e+01,3.98107e-02,1.96351e+01,9.94403e+00,3.98110e-02,1.96347e+01,9.94390e+00,3.98397e-02,
1.95975e+01,9.93102e+00,4.00000e-02,1.93913e+01,9.85946e+00,4.02717e-02,1.90487e+01,9.73938e+00,4.07380e-02,1.84800e+01,
9.53693e+00,4.12097e-02,1.79286e+01,9.33679e+00,4.16869e-02,1.73938e+01,9.13907e+00,4.21696e-02,1.68753e+01,8.94608e+00,
4.26579e-02,1.63726e+01,8.75549e+00,4.31519e-02,1.58755e+01,8.56207e+00,4.33386e-02,1.56931e+01,8.49027e+00,4.51856e-02,
1.40345e+01,7.81657e+00,4.57088e-02,1.36092e+01,7.63742e+00,4.62381e-02,1.31964e+01,7.46091e+00,4.73151e-02,1.24083e+01,
7.11657e+00,4.75968e-02,1.22130e+01,7.02972e+00,4.78630e-02,1.20322e+01,6.94886e+00,5.01187e-02,1.06398e+01,6.30813e+00,
5.01190e-02,1.06397e+01,6.30806e+00,5.18800e-02,9.70419e+00,5.85901e+00,5.19535e-02,9.66769e+00,5.84117e+00,5.30884e-02,
9.12713e+00,5.57429e+00,5.43250e-02,8.58506e+00,5.30108e+00,5.49541e-02,8.32617e+00,5.16853e+00,5.62341e-02,7.82327e+00,
4.90600e+00,5.64774e-02,7.73248e+00,4.85806e+00,5.82103e-02,7.12583e+00,4.53364e+00,5.88844e-02,6.90771e+00,4.41507e+00,
5.95662e-02,6.69645e+00,4.29924e+00,6.16595e-02,6.10160e+00,3.96767e+00,6.30957e-02,5.73548e+00,3.76013e+00,6.30960e-02,
5.73542e+00,3.76009e+00,6.35418e-02,5.62795e+00,3.69860e+00,6.38264e-02,5.56077e+00,3.66004e+00,6.45654e-02,5.39146e+00,
3.56237e+00,6.68344e-02,4.91416e+00,3.28291e+00,6.83912e-02,4.62032e+00,3.10779e+00,6.99842e-02,4.34087e+00,2.93855e+00,
7.07946e-02,4.20777e+00,2.85716e+00,7.16143e-02,4.07889e+00,2.77785e+00,7.31885e-02,3.84655e+00,2.63362e+00,7.41310e-02,
3.71618e+00,2.55202e+00,7.76247e-02,3.28385e+00,2.27753e+00,7.94328e-02,3.08749e+00,2.15076e+00,7.94330e-02,3.08747e+00,
2.15074e+00,8.03526e-02,2.99386e+00,2.08993e+00,8.12830e-02,2.90319e+00,2.03071e+00,8.41395e-02,2.64804e+00,1.86249e+00,
8.60994e-02,2.49112e+00,1.75780e+00,8.81049e-02,2.34242e+00,1.65755e+00,9.15472e-02,2.11538e+00,1.50276e+00,9.33254e-02,
2.01028e+00,1.43040e+00,9.44061e-02,1.95006e+00,1.38873e+00,9.54993e-02,1.89171e+00,1.34819e+00,9.66051e-02,1.83523e+00,
1.30880e+00,9.77237e-02,1.78054e+00,1.27052e+00,1.00000e-01,1.67635e+00,1.19730e+00,1.04713e-01,1.48685e+00,1.06309e+00,
1.09648e-01,1.32037e+00,9.43700e-01,1.10918e-01,1.28200e+00,9.15980e-01,1.12202e-01,1.24462e+00,8.88871e-01,1.13501e-01,
1.20844e+00,8.62562e-01,1.14815e-01,1.17341e+00,8.37024e-01,1.14989e-01,1.16890e+00,8.33729e-01,1.16145e-01,1.13947e+00,
8.12239e-01,1.17490e-01,1.10662e+00,7.88184e-01,1.20226e-01,1.04397e+00,7.42143e-01,1.25890e-01,9.30265e-01,6.58008e-01,
1.25893e-01,9.30219e-01,6.57974e-01,1.27350e-01,9.03940e-01,6.38502e-01,1.28825e-01,8.78500e-01,6.19614e-01,1.33352e-01,
8.06929e-01,5.66278e-01,1.34896e-01,7.84568e-01,5.49554e-01,1.36458e-01,7.62918e-01,5.33334e-01,1.38038e-01,7.41952e-01,
5.17601e-01,1.41254e-01,7.01990e-01,4.87542e-01,1.42889e-01,6.82956e-01,4.73192e-01,1.44965e-01,6.59964e-01,4.55832e-01,
1.50000e-01,6.09009e-01,4.17286e-01,1.54882e-01,5.65422e-01,3.84199e-01,1.58489e-01,5.36400e-01,3.62112e-01,1.58490e-01,
5.36394e-01,3.62107e-01,1.60324e-01,5.22510e-01,3.51600e-01,1.65959e-01,4.83392e-01,3.21951e-01,1.69824e-01,4.59305e-01,
3.03667e-01,1.71791e-01,4.47823e-01,2.94944e-01,1.73780e-01,4.36698e-01,2.86489e-01,1.75792e-01,4.25918e-01,2.78293e-01,
1.81970e-01,3.95544e-01,2.55186e-01,1.82556e-01,3.92858e-01,2.53143e-01,1.84077e-01,3.86031e-01,2.47953e-01,1.88365e-01,
3.67874e-01,2.34151e-01,1.94984e-01,3.42684e-01,2.15007e-01,1.97242e-01,3.34799e-01,2.09016e-01,1.99526e-01,3.27156e-01,
2.03210e-01,1.99530e-01,3.27144e-01,2.03200e-01,2.00000e-01,3.25600e-01,2.02042e-01,2.01837e-01,3.19698e-01,1.97612e-01,
2.06538e-01,3.05572e-01,1.87037e-01,2.11349e-01,2.92282e-01,1.77100e-01,2.16272e-01,2.79779e-01,1.67765e-01,2.18776e-01,
2.73807e-01,1.63311e-01,2.21309e-01,2.68012e-01,1.58995e-01,2.23872e-01,2.62394e-01,1.54814e-01,2.24369e-01,2.61332e-01,
1.54024e-01,2.26464e-01,2.56937e-01,1.50762e-01,2.29087e-01,2.51641e-01,1.46834e-01,2.31740e-01,2.46501e-01,1.43027e-01,
2.39883e-01,2.31975e-01,1.32295e-01,2.42661e-01,2.27417e-01,1.28937e-01,2.48313e-01,2.18698e-01,1.22527e-01,2.51189e-01,
2.14574e-01,1.19511e-01,2.51190e-01,2.14572e-01,1.19510e-01,2.51797e-01,2.13714e-01,1.18894e-01,2.54097e-01,2.10527e-01,
1.16613e-01,2.57040e-01,2.06595e-01,1.13802e-01,2.60016e-01,2.02775e-01,1.11077e-01,2.63027e-01,1.99063e-01,1.08435e-01,
2.66073e-01,1.95456e-01,1.05872e-01,2.69154e-01,1.91951e-01,1.03388e-01,2.72270e-01,1.88545e-01,1.00980e-01,2.81838e-01,
1.78899e-01,9.41933e-02,2.85102e-01,1.75861e-01,9.20664e-02,2.88403e-01,1.72907e-01,9.00038e-02,2.91743e-01,1.70035e-01,
8.80042e-02,2.95121e-01,1.67277e-01,8.60972e-02,3.00000e-01,1.63475e-01,8.34778e-02,3.01995e-01,1.61980e-01,8.24503e-02,
3.16228e-01,1.52202e-01,7.57846e-02,3.16230e-01,1.52201e-01,7.57836e-02,3.19889e-01,1.49884e-01,7.42642e-02,3.27341e-01,
1.45433e-01,7.13614e-02,3.34965e-01,1.41209e-01,6.86269e-02,3.38844e-01,1.39204e-01,6.73433e-02,3.46737e-01,1.35344e-01,
6.48871e-02,3.50752e-01,1.33485e-01,6.37115e-02,3.54813e-01,1.31673e-01,6.25696e-02,3.67282e-01,1.26500e-01,5.93356e-02,
3.71535e-01,1.24861e-01,5.83202e-02,3.75837e-01,1.23262e-01,5.73339e-02,3.80189e-01,1.21701e-01,5.63754e-02,3.84592e-01,
1.20197e-01,5.54618e-02,3.89045e-01,1.18728e-01,5.45734e-02,3.93550e-01,1.17293e-01,5.37098e-02,3.98107e-01,1.15892e-01,
5.28699e-02,3.98110e-01,1.15891e-01,5.28694e-02,4.07380e-01,1.13131e-01,5.13034e-02,4.12098e-01,1.11798e-01,5.05522e-02,
4.16869e-01,1.10494e-01,4.98213e-02,4.21697e-01,1.09221e-01,4.91118e-02,4.26580e-01,1.07977e-01,4.84214e-02,4.32808e-01,
1.06467e-01,4.75961e-02,4.36516e-01,1.05596e-01,4.71231e-02,4.41570e-01,1.04443e-01,4.64991e-02,4.46684e-01,1.03315e-01,
4.58917e-02,4.51856e-01,1.02210e-01,4.53000e-02,4.57088e-01,1.01129e-01,4.47236e-02,4.62381e-01,1.00070e-01,4.41619e-02,
4.67735e-01,9.90326e-02,4.36145e-02,4.73151e-01,9.80181e-02,4.30823e-02,4.78630e-01,9.70243e-02,4.25635e-02,4.89779e-01,
9.51192e-02,4.15865e-02,4.95450e-01,9.41946e-02,4.11158e-02,5.01187e-01,9.32882e-02,4.06566e-02,5.01190e-01,9.32877e-02,
4.06564e-02,5.06991e-01,9.23756e-02,4.02278e-02,5.12861e-01,9.14802e-02,3.98090e-02,5.18800e-01,9.06015e-02,3.94001e-02,
5.24808e-01,8.97403e-02,3.90018e-02,5.30884e-01,8.88950e-02,3.86126e-02,5.37032e-01,8.80744e-02,3.82412e-02,5.43250e-01,
8.72684e-02,3.78781e-02,5.55904e-01,8.56986e-02,3.71755e-02,5.62341e-01,8.49344e-02,3.68357e-02,5.68853e-01,8.41834e-02,
3.65032e-02,5.75440e-01,8.34452e-02,3.61778e-02,5.82103e-01,8.27196e-02,3.58593e-02,5.88844e-01,8.20071e-02,3.55482e-02,
5.95662e-01,8.13140e-02,3.52509e-02,6.02560e-01,8.06321e-02,3.49595e-02,6.09537e-01,7.99612e-02,3.46737e-02,6.16595e-01,
7.93009e-02,3.43935e-02,6.23735e-01,7.86513e-02,3.41188e-02,6.30957e-01,7.80118e-02,3.38493e-02,6.30960e-01,7.80116e-02,
3.38492e-02,6.38264e-01,7.73618e-02,3.36017e-02,6.45654e-01,7.67217e-02,3.33586e-02,6.53131e-01,7.60920e-02,3.31204e-02,
6.60694e-01,7.54784e-02,3.28929e-02,6.64508e-01,7.51749e-02,3.27805e-02,6.76083e-01,7.42769e-02,3.24487e-02,6.83912e-01,
7.36889e-02,3.22320e-02,6.91831e-01,7.31094e-02,3.20188e-02,6.99842e-01,7.25380e-02,3.18089e-02,7.07946e-01,7.19747e-02,
3.16023e-02,7.16143e-01,7.14192e-02,3.13988e-02,7.41310e-01,6.98128e-02,3.08208e-02,7.49894e-01,6.92913e-02,3.06334e-02,
7.58578e-01,6.87767e-02,3.04485e-02,7.67362e-01,6.82688e-02,3.02661e-02,7.76247e-01,6.77674e-02,3.00862e-02,7.85236e-01,
6.72725e-02,2.99086e-02,7.94328e-01,6.67838e-02,2.97332e-02,7.94330e-01,6.67837e-02,2.97332e-02,8.03526e-01,6.62862e-02,
2.95764e-02,8.12831e-01,6.57947e-02,2.94212e-02,8.31764e-01,6.48292e-02,2.91151e-02,8.41395e-01,6.43550e-02,2.89642e-02,
8.51138e-01,6.38863e-02,2.88147e-02,8.60994e-01,6.34233e-02,2.86666e-02,8.70964e-01,6.29656e-02,2.85199e-02,8.81049e-01,
6.25135e-02,2.83748e-02,8.91251e-01,6.20665e-02,2.82310e-02,9.01571e-01,6.16271e-02,2.80908e-02,9.12011e-01,6.11926e-02,
2.79517e-02,9.22571e-01,6.07628e-02,2.78136e-02,9.33254e-01,6.03377e-02,2.76766e-02,9.44061e-01,5.99173e-02,2.75407e-02,
9.54993e-01,5.95014e-02,2.74057e-02,9.66051e-01,5.90902e-02,2.72720e-02,9.77237e-01,5.86834e-02,2.71393e-02,9.88553e-01,
5.82839e-02,2.70104e-02,1.00000e+00,5.78885e-02,2.68823e-02,1.00000e-03,8.58024e+03,8.57246e+03,1.01158e-03,8.37794e+03,
8.37016e+03,1.01258e-03,8.36038e+03,8.35260e+03,1.01500e-03,8.31820e+03,8.31042e+03,1.02329e-03,8.17557e+03,8.16780e+03,
1.03514e-03,7.97823e+03,7.97047e+03,1.04713e-03,7.78528e+03,7.77752e+03,1.05000e-03,7.74006e+03,7.73231e+03,1.05659e-03,
7.63769e+03,7.62995e+03,1.08393e-03,7.23353e+03,7.22581e+03,1.08842e-03,7.16944e+03,7.16172e+03,1.11000e-03,6.87300e+03,
6.86531e+03,1.12199e-03,6.71419e+03,6.70652e+03,1.12202e-03,6.71380e+03,6.70613e+03,1.13501e-03,6.54724e+03,6.53959e+03,
1.14815e-03,6.38494e+03,6.37730e+03,1.16145e-03,6.22670e+03,6.21909e+03,1.17490e-03,6.07265e+03,6.06506e+03,1.18850e-03,
5.92176e+03,5.91419e+03,1.19000e-03,5.90532e+03,5.89775e+03,1.19141e-03,5.88967e+03,5.88210e+03,1.20226e-03,5.77128e+03,
5.76373e+03,1.23027e-03,5.48100e+03,5.47350e+03,1.24451e-03,5.34170e+03,5.33421e+03,1.25890e-03,5.20629e+03,5.19883e+03,
1.25892e-03,5.20606e+03,5.19860e+03,1.27350e-03,5.07360e+03,5.06617e+03,1.28825e-03,4.94359e+03,4.93617e+03,1.29433e-03,
4.89140e+03,4.88399e+03,1.30000e-03,4.84348e+03,4.83608e+03,1.30317e-03,4.81677e+03,4.80938e+03,1.31826e-03,4.69209e+03,
4.68472e+03,1.33352e-03,4.57085e+03,4.56351e+03,1.35000e-03,4.44483e+03,4.43752e+03,1.36458e-03,4.33676e+03,4.32947e+03,
1.38038e-03,4.22396e+03,4.21669e+03,1.41101e-03,4.01741e+03,4.01018e+03,1.41254e-03,4.00752e+03,4.00029e+03,1.42889e-03,
3.90363e+03,3.89643e+03,1.45000e-03,3.77487e+03,3.76771e+03,1.46218e-03,3.70293e+03,3.69579e+03,1.47911e-03,3.60465e+03,
3.59753e+03,1.50000e-03,3.48864e+03,3.48156e+03,1.51356e-03,3.41629e+03,3.40923e+03,1.53109e-03,3.32600e+03,3.31897e+03,
1.56675e-03,3.15242e+03,3.14545e+03,1.57000e-03,3.13727e+03,3.13031e+03,1.58489e-03,3.06915e+03,3.06221e+03,1.58490e-03,
3.06912e+03,3.06218e+03,1.60325e-03,2.98770e+03,2.98079e+03,1.62181e-03,2.90795e+03,2.90107e+03,1.65000e-03,2.79250e+03,
2.78566e+03,1.67880e-03,2.68067e+03,2.67387e+03,1.68850e-03,2.64447e+03,2.63769e+03,1.69824e-03,2.60879e+03,2.60203e+03,
1.73000e-03,2.49739e+03,2.49068e+03,1.73780e-03,2.47102e+03,2.46432e+03,1.75792e-03,2.40478e+03,2.39811e+03,1.77828e-03,
2.34032e+03,2.33368e+03,1.80000e-03,2.27379e+03,2.26719e+03,1.83879e-03,2.16041e+03,2.15386e+03,1.86209e-03,2.09612e+03,
2.08961e+03,1.90546e-03,1.98340e+03,1.97696e+03,1.92753e-03,1.92946e+03,1.92305e+03,1.97242e-03,1.82600e+03,1.81965e+03,
1.99526e-03,1.77624e+03,1.76993e+03,1.99530e-03,1.77616e+03,1.76985e+03,2.00000e-03,1.76616e+03,1.75985e+03,2.01401e-03,
1.73651e+03,1.73023e+03,2.01837e-03,1.72745e+03,1.72117e+03,2.04174e-03,1.67994e+03,1.67370e+03,2.06538e-03,1.63370e+03,
1.62749e+03,2.11349e-03,1.54516e+03,1.53903e+03,2.13796e-03,1.50271e+03,1.49661e+03,2.15000e-03,1.48244e+03,1.47636e+03,
2.16272e-03,1.46145e+03,1.45539e+03,2.18776e-03,1.42139e+03,1.41536e+03,2.21704e-03,1.37622e+03,1.37023e+03,2.23872e-03,
1.34406e+03,1.33810e+03,2.26464e-03,1.30682e+03,1.30090e+03,2.29087e-03,1.27035e+03,1.26446e+03,2.30000e-03,1.25799e+03,
1.25212e+03,2.30078e-03,1.25695e+03,1.25107e+03,2.34423e-03,1.20053e+03,1.19472e+03,2.37137e-03,1.16709e+03,1.16133e+03,
2.39883e-03,1.13462e+03,1.12889e+03,2.42661e-03,1.10310e+03,1.09741e+03,2.45471e-03,1.07233e+03,1.06667e+03,2.48313e-03,
1.04243e+03,1.03682e+03,2.51189e-03,1.01331e+03,1.00774e+03,2.51190e-03,1.01330e+03,1.00772e+03,2.52639e-03,9.98951e+02,
9.93394e+02,2.54097e-03,9.84792e+02,9.79255e+02,2.60016e-03,9.30236e+02,9.24780e+02,2.63027e-03,9.04146e+02,8.98730e+02,
2.63809e-03,8.97551e+02,8.92144e+02,2.69154e-03,8.54215e+02,8.48886e+02,2.75423e-03,8.06858e+02,8.01617e+02,2.78612e-03,
7.84147e+02,7.78949e+02,2.80000e-03,7.74553e+02,7.69374e+02,2.81838e-03,7.61994e+02,7.56839e+02,2.88100e-03,7.21225e+02,
7.16151e+02,2.91743e-03,6.98898e+02,6.93873e+02,2.98538e-03,6.59866e+02,6.54933e+02,3.00000e-03,6.51887e+02,6.46972e+02,
3.01817e-03,6.42105e+02,6.37214e+02,3.05492e-03,6.22941e+02,6.18103e+02,3.09030e-03,6.05208e+02,6.00420e+02,3.12608e-03,
5.87988e+02,5.83249e+02,3.15645e-03,5.73920e+02,5.69222e+02,3.16228e-03,5.71274e+02,5.66586e+02,3.16230e-03,5.71264e+02,
5.66576e+02,3.19889e-03,5.54921e+02,5.50286e+02,3.23594e-03,5.39060e+02,5.34478e+02,3.27341e-03,5.23638e+02,5.19108e+02,
3.28028e-03,5.20881e+02,5.16361e+02,3.34965e-03,4.94145e+02,4.89728e+02,3.38363e-03,4.81704e+02,4.77337e+02,3.46737e-03,
4.52842e+02,4.48605e+02,3.48277e-03,4.47784e+02,4.43570e+02,3.50752e-03,4.39816e+02,4.35644e+02,3.54813e-03,4.27144e+02,
4.23037e+02,3.57567e-03,4.18821e+02,4.14758e+02,3.58922e-03,4.14807e+02,4.10768e+02,3.63078e-03,4.02832e+02,3.98865e+02,
3.65139e-03,3.97081e+02,3.93149e+02,3.67282e-03,3.91215e+02,3.87324e+02,3.71808e-03,3.79213e+02,3.75405e+02,3.75837e-03,
3.68941e+02,3.65216e+02,3.77771e-03,3.64127e+02,3.60441e+02,3.80189e-03,3.58223e+02,3.54592e+02,3.83041e-03,3.51435e+02,
3.47868e+02,3.84592e-03,3.47815e+02,3.44287e+02,3.87620e-03,3.40874e+02,3.37422e+02,3.89045e-03,3.37667e+02,3.34255e+02,
3.91669e-03,3.31874e+02,3.28535e+02,3.93550e-03,3.27795e+02,3.24516e+02,3.94836e-03,3.25041e+02,3.21803e+02,3.97755e-03,
3.18889e+02,3.15759e+02,3.98107e-03,3.18156e+02,3.15042e+02,3.98110e-03,3.18151e+02,3.15036e+02,4.00000e-03,3.14251e+02,
3.11219e+02,4.00198e-03,3.13846e+02,3.10823e+02,4.02059e-03,3.10060e+02,3.07131e+02,4.03504e-03,3.07154e+02,3.04308e+02,
4.06072e-03,3.02064e+02,2.99376e+02,4.08110e-03,2.98106e+02,2.95540e+02,4.09412e-03,2.95630e+02,2.93126e+02,4.10650e-03,
2.93319e+02,2.90856e+02,4.11708e-03,2.91382e+02,2.88936e+02,4.12097e-03,2.90679e+02,2.88232e+02,4.12542e-03,2.89880e+02,
2.87434e+02,4.13050e-03,2.88978e+02,2.86526e+02,4.13050e-03,8.87171e+02,8.44578e+02,4.13382e-03,8.85941e+02,8.43419e+02,
4.14246e-03,8.82767e+02,8.40419e+02,4.15348e-03,8.78757e+02,8.36613e+02,4.16620e-03,8.74180e+02,8.32254e+02,4.16869e-03,
8.73290e+02,8.31406e+02,4.19933e-03,8.62467e+02,8.21070e+02,4.20692e-03,8.59815e+02,8.18540e+02,4.21876e-03,8.55699e+02,
8.14618e+02,4.23000e-03,8.51813e+02,8.10923e+02,4.23225e-03,8.50669e+02,8.09842e+02,4.24873e-03,8.42320e+02,8.01963e+02,
4.26579e-03,8.33778e+02,7.93917e+02,4.26745e-03,8.32956e+02,7.93143e+02,4.28542e-03,8.24090e+02,7.84806e+02,4.31519e-03,
8.09664e+02,7.71260e+02,4.31802e-03,8.08308e+02,7.69986e+02,4.34048e-03,7.97672e+02,7.59996e+02,4.36190e-03,7.87722e+02,
7.50633e+02,4.36516e-03,7.86229e+02,7.49224e+02,4.38059e-03,7.79204e+02,7.42593e+02,4.38600e-03,7.76764e+02,7.40285e+02,
4.38600e-03,1.05422e+03,9.96591e+02,4.39041e-03,1.05201e+03,9.94529e+02,4.41429e-03,1.04019e+03,9.83479e+02,4.41570e-03,
1.03950e+03,9.82831e+02,4.41700e-03,1.03885e+03,9.82224e+02,4.45350e-03,1.02090e+03,9.65400e+02,4.46684e-03,1.01445e+03,
9.59355e+02,4.46990e-03,1.01298e+03,9.57977e+02,4.48748e-03,1.00460e+03,9.50134e+02,4.49000e-03,1.00341e+03,9.49017e+02,
4.50000e-03,9.97992e+02,9.43942e+02,4.50662e-03,9.94424e+02,9.40598e+02,4.52000e-03,9.87266e+02,9.33897e+02,4.52913e-03,
9.82062e+02,9.29038e+02,4.55127e-03,9.69584e+02,9.17398e+02,4.57088e-03,9.58701e+02,9.07253e+02,4.58000e-03,9.53697e+02,
9.02587e+02,4.59222e-03,9.47190e+02,8.96521e+02,4.62381e-03,9.30655e+02,8.81105e+02,4.63143e-03,9.26725e+02,8.77440e+02,
4.66498e-03,9.09726e+02,8.61560e+02,4.67370e-03,9.05388e+02,8.57500e+02,4.67370e-03,1.04165e+03,9.84886e+02,4.67735e-03,
1.03966e+03,9.83028e+02,4.69125e-03,1.03211e+03,9.75988e+02,4.70000e-03,1.02741e+03,9.71596e+02,4.73151e-03,1.01053e+03,
9.55829e+02,4.75326e-03,9.99116e+02,9.45164e+02,4.77624e-03,9.87253e+02,9.34079e+02,4.79909e-03,9.75646e+02,9.23236e+02,
4.84172e-03,9.54473e+02,9.03465e+02,4.85000e-03,9.50439e+02,8.99696e+02,4.85206e-03,9.49452e+02,8.98774e+02,4.89186e-03,
9.30611e+02,8.81183e+02,4.95450e-03,9.02001e+02,8.54466e+02,4.98314e-03,8.89148e+02,8.42453e+02,5.00000e-03,8.81700e+02,
8.35492e+02,5.01187e-03,8.76507e+02,8.30639e+02,5.01190e-03,8.76495e+02,8.30628e+02,5.06991e-03,8.51748e+02,8.07486e+02,
5.08539e-03,8.45259e+02,8.01414e+02,5.18800e-03,8.03939e+02,7.62739e+02,5.24053e-03,7.83867e+02,7.43932e+02,5.24807e-03,
7.81040e+02,7.41283e+02,5.30000e-03,7.61827e+02,7.23274e+02,5.30884e-03,7.58617e+02,7.20264e+02,5.37032e-03,7.36569e+02,
6.99575e+02,5.38223e-03,7.32403e+02,6.95664e+02,5.43250e-03,7.15176e+02,6.79494e+02,5.61034e-03,6.58751e+02,6.26464e+02,
5.62341e-03,6.54851e+02,6.22796e+02,5.65000e-03,6.47028e+02,6.15439e+02,5.68853e-03,6.35849e+02,6.04918e+02,5.82103e-03,
5.99432e+02,5.70619e+02,5.85577e-03,5.90309e+02,5.62018e+02,5.88844e-03,5.81901e+02,5.54092e+02,5.95662e-03,5.64894e+02,
5.38053e+02,6.02560e-03,5.48369e+02,5.22462e+02,6.09537e-03,5.32344e+02,5.07333e+02,6.14390e-03,5.21587e+02,4.97174e+02,
6.16595e-03,5.16800e+02,4.92652e+02,6.23735e-03,5.01699e+02,4.78384e+02,6.30957e-03,4.87004e+02,4.64490e+02,6.30960e-03,
4.86999e+02,4.64485e+02,6.45654e-03,4.58929e+02,4.37923e+02,6.50785e-03,4.49607e+02,4.29094e+02,6.60693e-03,4.32330e+02,
4.12727e+02,6.68344e-03,4.19626e+02,4.00687e+02,6.76083e-03,4.07291e+02,3.88988e+02,6.83912e-03,3.95329e+02,3.77638e+02,
6.91831e-03,3.83725e+02,3.66621e+02,6.94824e-03,3.79456e+02,3.62566e+02,7.07946e-03,3.61495e+02,3.45506e+02,7.24436e-03,
3.40595e+02,3.25636e+02,7.32824e-03,3.30574e+02,3.16102e+02,7.49633e-03,3.11702e+02,2.98134e+02,7.50000e-03,3.11306e+02,
2.97758e+02,7.58578e-03,3.02200e+02,2.89084e+02,7.67362e-03,2.93246e+02,2.80552e+02,7.76247e-03,2.84567e+02,2.72278e+02,
7.85236e-03,2.76151e+02,2.64252e+02,7.94328e-03,2.67983e+02,2.56458e+02,7.94330e-03,2.67981e+02,2.56457e+02,8.03526e-03,
2.60064e+02,2.48899e+02,8.12830e-03,2.52386e+02,2.41568e+02,8.22243e-03,2.44897e+02,2.34414e+02,8.27485e-03,2.40811e+02,
2.30508e+02,8.31764e-03,2.37544e+02,2.27386e+02,8.51138e-03,2.23509e+02,2.13970e+02,8.60994e-03,2.16815e+02,2.07567e+02,
8.70964e-03,2.10319e+02,2.01352e+02,8.81049e-03,2.04020e+02,1.95322e+02,8.91251e-03,1.97881e+02,1.89445e+02,9.12011e-03,
1.86160e+02,1.78216e+02,9.13734e-03,1.85232e+02,1.77327e+02,9.33254e-03,1.75154e+02,1.67670e+02,9.44061e-03,1.69905e+02,
1.62640e+02,9.66051e-03,1.59889e+02,1.53035e+02,9.77237e-03,1.55077e+02,1.48419e+02,9.80000e-03,1.53920e+02,1.47309e+02,
9.88553e-03,1.50393e+02,1.43923e+02,1.00000e-02,1.45847e+02,1.39560e+02,1.01158e-02,1.41444e+02,1.35332e+02,1.02289e-02,
1.37318e+02,1.31369e+02,1.02329e-02,1.37174e+02,1.31231e+02,1.03514e-02,1.33033e+02,1.27254e+02,1.07152e-02,1.21368e+02,
1.16048e+02,1.08000e-02,1.18857e+02,1.13635e+02,1.08393e-02,1.17715e+02,1.12538e+02,1.10918e-02,1.10647e+02,1.05741e+02,
1.12202e-02,1.07278e+02,1.02501e+02,1.13501e-02,1.04011e+02,9.93580e+01,1.15000e-02,1.00415e+02,9.58972e+01,1.16093e-02,
9.79020e+01,9.34792e+01,1.16145e-02,9.77841e+01,9.33658e+01,1.17490e-02,9.48130e+01,9.05078e+01,1.20226e-02,8.91490e+01,
8.50583e+01,1.21619e-02,8.64475e+01,8.24586e+01,1.24451e-02,8.12960e+01,7.75005e+01,1.25890e-02,7.88282e+01,7.51246e+01,
1.25892e-02,7.88240e+01,7.51206e+01,1.27350e-02,7.64277e+01,7.28134e+01,1.28825e-02,7.41051e+01,7.05770e+01,1.30317e-02,
7.18554e+01,6.84105e+01,1.31826e-02,6.96608e+01,6.62968e+01,1.31873e-02,6.95937e+01,6.62322e+01,1.33352e-02,6.75259e+01,
6.42418e+01,1.38038e-02,6.15160e+01,5.84561e+01,1.41254e-02,5.78203e+01,5.48981e+01,1.44544e-02,5.43521e+01,5.15590e+01,
1.45000e-02,5.38948e+01,5.11187e+01,1.46218e-02,5.26988e+01,4.99672e+01,1.46692e-02,5.22406e+01,4.95260e+01,1.47911e-02,
5.10872e+01,4.84164e+01,1.49624e-02,4.95263e+01,4.69148e+01,1.50000e-02,4.91922e+01,4.65935e+01,1.51356e-02,4.80120e+01,
4.54581e+01,1.53109e-02,4.65451e+01,4.40469e+01,1.54882e-02,4.51238e+01,4.26797e+01,1.56675e-02,4.37400e+01,4.13485e+01,
1.58489e-02,4.24019e+01,4.00613e+01,1.58490e-02,4.24014e+01,4.00609e+01,1.61113e-02,4.05647e+01,3.82943e+01,1.64059e-02,
3.86291e+01,3.64350e+01,1.65000e-02,3.80355e+01,3.58647e+01,1.65959e-02,3.74433e+01,3.52959e+01,1.67880e-02,3.62937e+01,
3.41915e+01,1.69824e-02,3.51806e+01,3.31224e+01,1.71791e-02,3.41030e+01,3.20876e+01,1.73780e-02,3.30564e+01,3.10826e+01,
1.74783e-02,3.25458e+01,3.05923e+01,1.75792e-02,3.20427e+01,3.01098e+01,1.79887e-02,3.01089e+01,2.82557e+01,1.80000e-02,
3.00579e+01,2.82068e+01,1.81970e-02,2.91840e+01,2.73691e+01,1.84077e-02,2.82884e+01,2.65106e+01,1.88365e-02,2.65822e+01,
2.48757e+01,1.88399e-02,2.65691e+01,2.48631e+01,1.90000e-02,2.59690e+01,2.42890e+01,1.90546e-02,2.57684e+01,2.40972e+01,
1.92752e-02,2.49744e+01,2.33375e+01,1.94985e-02,2.42056e+01,2.26023e+01,1.97242e-02,2.34607e+01,2.18899e+01,1.99526e-02,
2.27400e+01,2.12008e+01,1.99530e-02,2.27388e+01,2.11997e+01,2.01837e-02,2.20416e+01,2.05334e+01,2.04082e-02,2.13918e+01,
1.99125e+01,2.04174e-02,2.13658e+01,1.98877e+01,2.06538e-02,2.07101e+01,1.92624e+01,2.08930e-02,2.00735e+01,1.86553e+01,
2.13796e-02,1.88559e+01,1.74946e+01,2.16272e-02,1.82761e+01,1.69422e+01,2.18776e-02,1.77150e+01,1.64076e+01,2.20593e-02,
1.73230e+01,1.60344e+01,2.23872e-02,1.66439e+01,1.53891e+01,2.29087e-02,1.56324e+01,1.44281e+01,2.30000e-02,1.54642e+01,
1.42684e+01,2.36757e-02,1.42945e+01,1.31581e+01,2.37137e-02,1.42322e+01,1.30991e+01,2.39883e-02,1.37938e+01,1.26841e+01,
2.42661e-02,1.33694e+01,1.22826e+01,2.45471e-02,1.29586e+01,1.18941e+01,2.48313e-02,1.25595e+01,1.15168e+01,2.51189e-02,
1.21723e+01,1.11508e+01,2.51190e-02,1.21721e+01,1.11506e+01,2.54097e-02,1.17963e+01,1.07966e+01,2.60016e-02,1.10798e+01,
1.01220e+01,2.62351e-02,1.08122e+01,9.87014e+00,2.66073e-02,1.04025e+01,9.48598e+00,2.69154e-02,1.00796e+01,9.18347e+00,
2.71624e-02,9.83063e+00,8.95021e+00,2.72270e-02,9.76653e+00,8.89047e+00,2.75423e-02,9.46232e+00,8.60703e+00,2.78988e-02,
9.13414e+00,8.30134e+00,2.84781e-02,8.63019e+00,7.83529e+00,2.85102e-02,8.60319e+00,7.81050e+00,2.87361e-02,8.41674e+00,
7.63933e+00,2.88403e-02,8.33206e+00,7.56209e+00,2.89746e-02,8.22476e+00,7.46421e+00,2.91632e-02,8.07605e+00,7.32958e+00,
2.91743e-02,8.06733e+00,7.32177e+00,2.93371e-02,7.94055e+00,7.20804e+00,2.94832e-02,7.82776e+00,7.10805e+00,2.95121e-02,
7.80536e+00,7.08846e+00,2.96054e-02,7.73372e+00,7.02578e+00,2.97592e-02,7.61556e+00,6.92409e+00,2.98538e-02,7.54251e+00,
6.86255e+00,3.00000e-02,7.43146e+00,6.76876e+00,3.00413e-02,7.40036e+00,6.74242e+00,3.02001e-02,7.28321e+00,6.64234e+00,
3.03115e-02,7.20544e+00,6.57333e+00,3.04140e-02,7.13817e+00,6.51072e+00,3.04790e-02,7.09808e+00,6.47143e+00,3.04790e-02,
4.05528e+01,1.39836e+01,3.05014e-02,4.04821e+01,1.39771e+01,3.05492e-02,4.03339e+01,1.39631e+01,3.06136e-02,4.01354e+01,
1.39440e+01,3.07492e-02,3.97266e+01,1.39031e+01,3.10770e-02,3.87704e+01,1.38004e+01,3.12432e-02,3.82965e+01,1.37463e+01,
3.12608e-02,3.82467e+01,1.37406e+01,3.13355e-02,3.80361e+01,1.37159e+01,3.14000e-02,3.78548e+01,1.36943e+01,3.14469e-02,
3.77052e+01,1.36717e+01,3.16228e-02,3.71493e+01,1.35863e+01,3.16230e-02,3.71486e+01,1.35862e+01,3.16860e-02,3.69522e+01,
1.35555e+01,3.19889e-02,3.60239e+01,1.34063e+01,3.21000e-02,3.56908e+01,1.33512e+01,3.23038e-02,3.51352e+01,1.32667e+01,
3.23594e-02,3.49856e+01,1.32435e+01,3.27341e-02,3.39998e+01,1.30855e+01,3.27477e-02,3.39647e+01,1.30797e+01,3.33000e-02,
3.25818e+01,1.28425e+01,3.33058e-02,3.25670e+01,1.28397e+01,3.38844e-02,3.11306e+01,1.25585e+01,3.42768e-02,3.02066e+01,
1.23727e+01,3.46737e-02,2.93090e+01,1.21845e+01,3.50752e-02,2.84374e+01,1.19938e+01,3.54813e-02,2.75917e+01,1.18015e+01,
3.55363e-02,2.74800e+01,1.17756e+01,3.58922e-02,2.67708e+01,1.16080e+01,3.63078e-02,2.59866e+01,1.14192e+01,3.70672e-02,
2.46351e+01,1.10781e+01,3.71535e-02,2.44875e+01,1.10397e+01,3.75837e-02,2.37705e+01,1.08494e+01,3.84592e-02,2.23998e+01,
1.04694e+01,3.88827e-02,2.17765e+01,1.02893e+01,3.98107e-02,2.04917e+01,9.90370e+00,3.98110e-02,2.04913e+01,9.90359e+00,
4.02717e-02,1.98927e+01,9.71695e+00,4.12097e-02,1.87175e+01,9.33182e+00,4.15619e-02,1.83012e+01,9.19120e+00,4.16869e-02,
1.81564e+01,9.14182e+00,4.26579e-02,1.70843e+01,8.76765e+00,4.31519e-02,1.65724e+01,8.58356e+00,4.36516e-02,1.60761e+01,
8.40167e+00,4.41570e-02,1.55949e+01,8.22198e+00,4.42350e-02,1.55225e+01,8.19468e+00,4.46684e-02,1.51279e+01,8.04463e+00,
4.51856e-02,1.46751e+01,7.86962e+00,4.62381e-02,1.38104e+01,7.53001e+00,4.67735e-02,1.33911e+01,7.36011e+00,4.78630e-02,
1.25902e+01,7.02768e+00,4.84172e-02,1.22082e+01,6.86551e+00,4.84237e-02,1.22038e+01,6.86364e+00,4.89779e-02,1.18377e+01,
6.70605e+00,4.95450e-02,1.14786e+01,6.54931e+00,5.01187e-02,1.11307e+01,6.39533e+00,5.01190e-02,1.11305e+01,6.39526e+00,
5.18800e-02,1.01497e+01,5.94980e+00,5.24807e-02,9.84260e+00,5.80674e+00,5.30198e-02,9.57793e+00,5.68200e+00,5.30884e-02,
9.54490e+00,5.66636e+00,5.43250e-02,8.97639e+00,5.39373e+00,5.50000e-02,8.68590e+00,5.25196e+00,5.75440e-02,7.70063e+00,
4.75801e+00,5.75860e-02,7.68569e+00,4.75036e+00,5.82103e-02,7.46837e+00,4.63864e+00,5.88844e-02,7.23941e+00,4.51929e+00,
6.09537e-02,6.59471e+00,4.17690e+00,6.16595e-02,6.39315e+00,4.06789e+00,6.30957e-02,6.00876e+00,3.85728e+00,6.30960e-02,
6.00869e+00,3.85724e+00,6.37460e-02,5.84521e+00,3.76664e+00,6.45654e-02,5.64769e+00,3.65637e+00,6.53131e-02,5.47555e+00,
3.55946e+00,6.60693e-02,5.30863e+00,3.46501e+00,6.83912e-02,4.83856e+00,3.19493e+00,7.00000e-02,4.54649e+00,3.02397e+00,
7.07946e-02,4.41134e+00,2.94401e+00,7.24436e-02,4.14837e+00,2.78684e+00,7.36017e-02,3.97448e+00,2.68146e+00,7.41310e-02,
3.89835e+00,2.63506e+00,7.49894e-02,3.77916e+00,2.56205e+00,7.76247e-02,3.44383e+00,2.35413e+00,7.85236e-02,3.33896e+00,
2.28831e+00,7.94328e-02,3.23742e+00,2.22422e+00,7.94330e-02,3.23740e+00,2.22420e+00,8.03526e-02,3.13901e+00,2.16183e+00,
8.31764e-02,2.86211e+00,1.98441e+00,8.41395e-02,2.77559e+00,1.92839e+00,8.81049e-02,2.45606e+00,1.71895e+00,9.01146e-02,
2.31395e+00,1.62446e+00,9.01571e-02,2.31107e+00,1.62254e+00,9.12011e-02,2.24195e+00,1.57628e+00,9.44061e-02,2.04546e+00,
1.44344e+00,9.54993e-02,1.98404e+00,1.40155e+00,9.88553e-02,1.81130e+00,1.28283e+00,1.00000e-01,1.75737e+00,1.24547e+00,
1.02329e-01,1.65444e+00,1.17394e+00,1.03514e-01,1.60542e+00,1.13970e+00,1.09648e-01,1.38278e+00,9.82775e-01,1.12202e-01,
1.30333e+00,9.26133e-01,1.13501e-01,1.26548e+00,8.99028e-01,1.13968e-01,1.25228e+00,8.89554e-01,1.18850e-01,1.12562e+00,
7.98234e-01,1.20226e-01,1.09338e+00,7.74840e-01,1.25890e-01,9.73784e-01,6.87447e-01,1.25893e-01,9.73735e-01,6.87411e-01,
1.27350e-01,9.46096e-01,6.67169e-01,1.28825e-01,9.19341e-01,6.47530e-01,1.31826e-01,8.68351e-01,6.09984e-01,1.33352e-01,
8.44063e-01,5.92044e-01,1.34896e-01,8.20544e-01,5.74636e-01,1.38038e-01,7.75716e-01,5.41364e-01,1.39637e-01,7.54359e-01,
5.25468e-01,1.40443e-01,7.43936e-01,5.17700e-01,1.41254e-01,7.33667e-01,5.10047e-01,1.51356e-01,6.22504e-01,4.26779e-01,
1.54882e-01,5.89946e-01,4.02246e-01,1.58489e-01,5.59408e-01,3.79178e-01,1.58490e-01,5.59402e-01,3.79173e-01,1.60324e-01,
5.44796e-01,3.68193e-01,1.62181e-01,5.30637e-01,3.57539e-01,1.64059e-01,5.16920e-01,3.47208e-01,1.69824e-01,4.78285e-01,
3.18062e-01,1.71791e-01,4.66203e-01,3.08934e-01,1.77828e-01,4.32160e-01,2.83184e-01,1.82762e-01,4.07378e-01,2.64413e-01,
1.84077e-01,4.01179e-01,2.59721e-01,1.88365e-01,3.82072e-01,2.45254e-01,1.92752e-01,3.64125e-01,2.31660e-01,1.94984e-01,
3.55565e-01,2.25175e-01,1.99526e-01,3.39226e-01,2.12796e-01,1.99530e-01,3.39212e-01,2.12786e-01,2.00000e-01,3.37589e-01,
2.11570e-01,2.01837e-01,3.31381e-01,2.06919e-01,2.08930e-01,3.09429e-01,1.90513e-01,2.11349e-01,3.02547e-01,1.85374e-01,
2.16272e-01,2.89400e-01,1.75564e-01,2.21309e-01,2.77027e-01,1.66347e-01,2.23872e-01,2.71121e-01,1.61953e-01,2.24219e-01,
2.70341e-01,1.61373e-01,2.26464e-01,2.65385e-01,1.57694e-01,2.29087e-01,2.59817e-01,1.53564e-01,2.31740e-01,2.54415e-01,
1.49561e-01,2.34423e-01,2.49173e-01,1.45680e-01,2.39883e-01,2.39150e-01,1.38272e-01,2.42661e-01,2.34360e-01,1.34738e-01,
2.45471e-01,2.29711e-01,1.31312e-01,2.48313e-01,2.25199e-01,1.27991e-01,2.51189e-01,2.20865e-01,1.24815e-01,2.51190e-01,
2.20863e-01,1.24813e-01,2.54097e-01,2.16615e-01,1.21760e-01,2.60016e-01,2.08475e-01,1.15925e-01,2.63027e-01,2.04578e-01,
1.13139e-01,2.66073e-01,2.00791e-01,1.10437e-01,2.69154e-01,1.97112e-01,1.07817e-01,2.71080e-01,1.94888e-01,1.06237e-01,
2.81838e-01,1.83418e-01,9.81191e-02,2.85102e-01,1.80231e-01,9.58742e-02,2.88403e-01,1.77132e-01,9.36970e-02,2.91743e-01,
1.74119e-01,9.15856e-02,2.95121e-01,1.71190e-01,8.95381e-02,2.98538e-01,1.68379e-01,8.75900e-02,3.00000e-01,1.67210e-01,
8.67810e-02,3.01995e-01,1.65644e-01,8.56992e-02,3.12608e-01,1.57874e-01,8.03562e-02,3.16228e-01,1.55421e-01,7.86787e-02,
3.16230e-01,1.55419e-01,7.86778e-02,3.19889e-01,1.53000e-01,7.70754e-02,3.23594e-01,1.50645e-01,7.55217e-02,3.27341e-01,
1.48352e-01,7.40135e-02,3.34965e-01,1.43943e-01,7.11281e-02,3.38844e-01,1.41823e-01,6.97486e-02,3.42768e-01,1.39759e-01,
6.84097e-02,3.46737e-01,1.37773e-01,6.71339e-02,3.50752e-01,1.35836e-01,6.58946e-02,3.54813e-01,1.33949e-01,6.46905e-02,
3.58922e-01,1.32107e-01,6.35207e-02,3.63078e-01,1.30312e-01,6.23841e-02,3.67282e-01,1.28560e-01,6.12798e-02,3.71535e-01,
1.26854e-01,6.02087e-02,3.75837e-01,1.25190e-01,5.91681e-02,3.80189e-01,1.23565e-01,5.81567e-02,3.84592e-01,1.21981e-01,
5.71740e-02,3.89045e-01,1.20434e-01,5.62188e-02,3.93550e-01,1.18943e-01,5.53086e-02,3.98107e-01,1.17488e-01,5.44236e-02,
3.98110e-01,1.17487e-01,5.44231e-02,4.07380e-01,1.14624e-01,5.27700e-02,4.12098e-01,1.13240e-01,5.19769e-02,4.16869e-01,
1.11888e-01,5.12052e-02,4.21697e-01,1.10568e-01,5.04560e-02,4.26580e-01,1.09278e-01,4.97269e-02,4.31519e-01,1.08016e-01,
4.90174e-02,4.36516e-01,1.06782e-01,4.83269e-02,4.41570e-01,1.05589e-01,4.76697e-02,4.46684e-01,1.04422e-01,4.70295e-02,
4.51856e-01,1.03280e-01,4.64063e-02,4.57088e-01,1.02162e-01,4.57989e-02,4.67735e-01,9.99966e-02,4.46304e-02,4.73151e-01,
9.89487e-02,4.40696e-02,4.78630e-01,9.79224e-02,4.35230e-02,4.89779e-01,9.59320e-02,4.24705e-02,4.95450e-01,9.49787e-02,
4.19751e-02,5.01187e-01,9.40442e-02,4.14917e-02,5.01190e-01,9.40437e-02,4.14915e-02,5.06991e-01,9.31045e-02,4.10396e-02,
5.12861e-01,9.21826e-02,4.05981e-02,5.18800e-01,9.12783e-02,4.01670e-02,5.24808e-01,9.03911e-02,3.97460e-02,5.30884e-01,
8.95215e-02,3.93358e-02,5.37032e-01,8.86680e-02,3.89350e-02,5.43250e-01,8.78303e-02,3.85435e-02,5.49541e-01,8.70169e-02,
3.81696e-02,5.55904e-01,8.62181e-02,3.78039e-02,5.62341e-01,8.54333e-02,3.74461e-02,5.68853e-01,8.46624e-02,3.70962e-02,
5.75440e-01,8.39049e-02,3.67538e-02,5.82103e-01,8.31605e-02,3.64187e-02,5.88844e-01,8.24288e-02,3.60907e-02,5.95662e-01,
8.17104e-02,3.57704e-02,6.02560e-01,8.10042e-02,3.54567e-02,6.16595e-01,7.96420e-02,3.48633e-02,6.23735e-01,7.89773e-02,
3.45752e-02,6.30957e-01,7.83233e-02,3.42928e-02,6.30960e-01,7.83231e-02,3.42927e-02,6.38264e-01,7.76585e-02,3.40310e-02,
6.45654e-01,7.70040e-02,3.37740e-02,6.53131e-01,7.63596e-02,3.35216e-02,6.61169e-01,7.56864e-02,3.32591e-02,6.68344e-01,
7.51009e-02,3.30315e-02,6.76083e-01,7.44914e-02,3.27986e-02,6.83912e-01,7.38907e-02,3.25695e-02,6.91831e-01,7.32988e-02,
3.23442e-02,6.99842e-01,7.27155e-02,3.21225e-02,7.07946e-01,7.21405e-02,3.19044e-02,7.16143e-01,7.15736e-02,3.16898e-02,
7.24436e-01,7.10147e-02,3.14784e-02,7.41310e-01,6.99210e-02,3.10663e-02,7.49894e-01,6.93901e-02,3.08694e-02,7.58578e-01,
6.88662e-02,3.06752e-02,7.67362e-01,6.83492e-02,3.04837e-02,7.76247e-01,6.78391e-02,3.02949e-02,7.85236e-01,6.73356e-02,
3.01087e-02,7.94328e-01,6.68386e-02,2.99249e-02,7.94330e-01,6.68385e-02,2.99248e-02,8.03526e-01,6.63304e-02,2.97576e-02,
8.22243e-01,6.53340e-02,2.94293e-02,8.41395e-01,6.43690e-02,2.91149e-02,8.51138e-01,6.38952e-02,2.89600e-02,8.60994e-01,
6.34270e-02,2.88067e-02,8.70964e-01,6.29644e-02,2.86549e-02,8.91251e-01,6.20554e-02,2.83555e-02,9.01571e-01,6.16091e-02,
2.82082e-02,9.12011e-01,6.11712e-02,2.80653e-02,9.22571e-01,6.07381e-02,2.79236e-02,9.33254e-01,6.03097e-02,2.77830e-02,
9.44061e-01,5.98861e-02,2.76435e-02,9.54993e-01,5.94672e-02,2.75052e-02,9.66051e-01,5.90528e-02,2.73679e-02,9.77237e-01,
5.86429e-02,2.72315e-02,9.88553e-01,5.82376e-02,2.70965e-02,1.00000e+00,5.78391e-02,2.69649e-02,1.00000e-03,8.78885e+03,
8.78114e+03,1.01144e-03,8.58504e+03,8.57730e+03,1.01158e-03,8.58264e+03,8.57490e+03,1.02236e-03,8.39545e+03,8.38768e+03,
1.03963e-03,8.10808e+03,8.10028e+03,1.04713e-03,7.98776e+03,7.97997e+03,1.05000e-03,7.94250e+03,7.93471e+03,1.05925e-03,
7.79906e+03,7.79127e+03,1.07000e-03,7.63753e+03,7.62973e+03,1.07152e-03,7.61500e+03,7.60720e+03,1.07983e-03,7.49089e+03,
7.48310e+03,1.08393e-03,7.43083e+03,7.42303e+03,1.09000e-03,7.34318e+03,7.33539e+03,1.09648e-03,7.25088e+03,7.24309e+03,
1.10603e-03,7.11676e+03,7.10898e+03,1.11000e-03,7.06204e+03,7.05426e+03,1.12202e-03,6.90029e+03,6.89253e+03,1.13501e-03,
6.73123e+03,6.72348e+03,1.16145e-03,6.40610e+03,6.39839e+03,1.16771e-03,6.33208e+03,6.32437e+03,1.17000e-03,6.30530e+03,
6.29760e+03,1.17490e-03,6.24853e+03,6.24084e+03,1.18850e-03,6.09315e+03,6.08547e+03,1.20226e-03,5.94175e+03,5.93409e+03,
1.21619e-03,5.79271e+03,5.78507e+03,1.23027e-03,5.64765e+03,5.64003e+03,1.25322e-03,5.42263e+03,5.41504e+03,1.25890e-03,
5.36899e+03,5.36141e+03,1.25892e-03,5.36876e+03,5.36118e+03,1.27350e-03,5.23395e+03,5.22639e+03,1.30000e-03,4.99812e+03,
4.99060e+03,1.30317e-03,4.97098e+03,4.96347e+03,1.31826e-03,4.84288e+03,4.83539e+03,1.34751e-03,4.60837e+03,4.60092e+03,
1.36458e-03,4.47898e+03,4.47156e+03,1.38038e-03,4.36414e+03,4.35674e+03,1.39637e-03,4.25074e+03,4.24336e+03,1.41254e-03,
4.14048e+03,4.13313e+03,1.42889e-03,4.03294e+03,4.02561e+03,1.44000e-03,3.96168e+03,3.95436e+03,1.44388e-03,3.93723e+03,
3.92992e+03,1.47911e-03,3.72493e+03,3.71769e+03,1.49624e-03,3.62714e+03,3.61993e+03,1.51356e-03,3.53199e+03,3.52481e+03,
1.53109e-03,3.43941e+03,3.43225e+03,1.56675e-03,3.26117e+03,3.25407e+03,1.57000e-03,3.24562e+03,3.23852e+03,1.58489e-03,
3.17498e+03,3.16791e+03,1.58490e-03,3.17495e+03,3.16788e+03,1.59533e-03,3.12682e+03,3.11976e+03,1.60325e-03,3.09102e+03,
3.08397e+03,1.62181e-03,3.00871e+03,3.00169e+03,1.65000e-03,2.88982e+03,2.88285e+03,1.65959e-03,2.85087e+03,2.84392e+03,
1.67880e-03,2.77477e+03,2.76785e+03,1.69824e-03,2.70077e+03,2.69388e+03,1.71312e-03,2.64609e+03,2.63922e+03,1.71791e-03,
2.62881e+03,2.62194e+03,1.75792e-03,2.48946e+03,2.48266e+03,1.77828e-03,2.42243e+03,2.41567e+03,1.79887e-03,2.35722e+03,
2.35048e+03,1.81970e-03,2.29387e+03,2.28717e+03,1.86209e-03,2.17160e+03,2.16496e+03,1.87180e-03,2.14486e+03,2.13824e+03,
1.88365e-03,2.11284e+03,2.10623e+03,1.92753e-03,2.00016e+03,1.99362e+03,1.94984e-03,1.94617e+03,1.93966e+03,1.95000e-03,
1.94580e+03,1.93930e+03,1.97030e-03,1.89816e+03,1.89169e+03,1.97242e-03,1.89326e+03,1.88679e+03,1.99526e-03,1.84152e+03,
1.83509e+03,1.99530e-03,1.84144e+03,1.83500e+03,2.00000e-03,1.83104e+03,1.82461e+03,2.01837e-03,1.79087e+03,1.78447e+03,
2.04174e-03,1.74157e+03,1.73521e+03,2.06538e-03,1.69371e+03,1.68738e+03,2.18776e-03,1.47428e+03,1.46814e+03,2.22000e-03,
1.42308e+03,1.41698e+03,2.23872e-03,1.39433e+03,1.38826e+03,2.24154e-03,1.39004e+03,1.38397e+03,2.29087e-03,1.31791e+03,
1.31192e+03,2.30000e-03,1.30516e+03,1.29917e+03,2.31740e-03,1.28134e+03,1.27538e+03,2.39883e-03,1.17790e+03,1.17206e+03,
2.42661e-03,1.14541e+03,1.13961e+03,2.45471e-03,1.11363e+03,1.10786e+03,2.46903e-03,1.09776e+03,1.09201e+03,2.48313e-03,
1.08244e+03,1.07671e+03,2.51189e-03,1.05213e+03,1.04644e+03,2.51190e-03,1.05212e+03,1.04643e+03,2.54097e-03,1.02258e+03,
1.01694e+03,2.58524e-03,9.79831e+02,9.74240e+02,2.60016e-03,9.65980e+02,9.60410e+02,2.63027e-03,9.38913e+02,9.33385e+02,
2.69154e-03,8.87151e+02,8.81705e+02,2.69784e-03,8.82051e+02,8.76614e+02,2.75423e-03,8.38200e+02,8.32840e+02,2.78612e-03,
8.14672e+02,8.09355e+02,2.81838e-03,7.91656e+02,7.86381e+02,2.83754e-03,7.78407e+02,7.73157e+02,2.91743e-03,7.26381e+02,
7.21237e+02,2.95121e-03,7.05844e+02,7.00743e+02,2.96969e-03,6.94968e+02,6.89891e+02,2.98538e-03,6.85910e+02,6.80854e+02,
3.00000e-03,6.77632e+02,6.72596e+02,3.01995e-03,6.66557e+02,6.61547e+02,3.05492e-03,6.47702e+02,6.42739e+02,3.09030e-03,
6.29323e+02,6.24405e+02,3.11862e-03,6.15053e+02,6.10172e+02,3.12608e-03,6.11373e+02,6.06502e+02,3.15000e-03,5.99766e+02,
5.94928e+02,3.16228e-03,5.93924e+02,5.89102e+02,3.16230e-03,5.93913e+02,5.89092e+02,3.24896e-03,5.54861e+02,5.50154e+02,
3.27341e-03,5.44494e+02,5.39821e+02,3.31131e-03,5.28990e+02,5.24369e+02,3.34965e-03,5.13897e+02,5.09327e+02,3.37722e-03,
5.03424e+02,4.98891e+02,3.38844e-03,4.99245e+02,4.94728e+02,3.42768e-03,4.85029e+02,4.80566e+02,3.46737e-03,4.71171e+02,
4.66762e+02,3.50000e-03,4.60199e+02,4.55834e+02,3.50134e-03,4.59752e+02,4.55389e+02,3.50752e-03,4.57704e+02,4.53350e+02,
3.54813e-03,4.44511e+02,4.40215e+02,3.58922e-03,4.31678e+02,4.27439e+02,3.60750e-03,4.26143e+02,4.21929e+02,3.67282e-03,
4.07147e+02,4.03032e+02,3.71020e-03,3.96823e+02,3.92762e+02,3.71535e-03,3.95426e+02,3.91374e+02,3.75837e-03,3.84046e+02,
3.80062e+02,3.79756e-03,3.74055e+02,3.70133e+02,3.84592e-03,3.62208e+02,3.58368e+02,3.87230e-03,3.55976e+02,3.52180e+02,
3.90000e-03,3.49585e+02,3.45841e+02,3.93550e-03,3.41557e+02,3.37876e+02,3.94112e-03,3.40310e+02,3.36639e+02,3.98107e-03,
3.31616e+02,3.28026e+02,3.98110e-03,3.31610e+02,3.28020e+02,4.00000e-03,3.27604e+02,3.24051e+02,4.00444e-03,3.26673e+02,
3.23129e+02,4.04896e-03,3.17517e+02,3.14070e+02,4.07380e-03,3.12555e+02,3.09169e+02,4.09167e-03,3.09052e+02,3.05709e+02,
4.12097e-03,3.03411e+02,3.00149e+02,4.12508e-03,3.02633e+02,2.99381e+02,4.15757e-03,2.96554e+02,2.93401e+02,4.16869e-03,
2.94505e+02,2.91393e+02,4.18697e-03,2.91176e+02,2.88128e+02,4.21010e-03,2.87021e+02,2.84070e+02,4.22952e-03,2.83581e+02,
2.80723e+02,4.25394e-03,2.79317e+02,2.76594e+02,4.26579e-03,2.77274e+02,2.74618e+02,4.28780e-03,2.73545e+02,2.71009e+02,
4.29999e-03,2.71521e+02,2.69039e+02,4.30986e-03,2.69907e+02,2.67458e+02,4.31519e-03,2.69048e+02,2.66610e+02,4.32128e-03,
2.68071e+02,2.65645e+02,4.32562e-03,2.67383e+02,2.64961e+02,4.33438e-03,2.66010e+02,2.63588e+02,4.33970e-03,2.65186e+02,
2.62758e+02,4.33970e-03,8.11704e+02,7.70136e+02,4.34322e-03,8.10287e+02,7.68810e+02,4.35224e-03,8.06684e+02,7.65428e+02,
4.36329e-03,8.02316e+02,7.61316e+02,4.36516e-03,8.01583e+02,7.60624e+02,4.37000e-03,7.99685e+02,7.58832e+02,4.37744e-03,
7.96777e+02,7.56085e+02,4.40821e-03,7.84934e+02,7.44873e+02,4.41000e-03,7.84251e+02,7.44228e+02,4.41570e-03,7.81926e+02,
7.42029e+02,4.42843e-03,7.76777e+02,7.37155e+02,4.44367e-03,7.70662e+02,7.31379e+02,4.46190e-03,7.63422e+02,7.24555e+02,
4.47947e-03,7.56520e+02,7.18064e+02,4.48000e-03,7.56314e+02,7.17871e+02,4.49860e-03,7.47749e+02,7.09839e+02,4.51676e-03,
7.39505e+02,7.02118e+02,4.51856e-03,7.38694e+02,7.01358e+02,4.52000e-03,7.38044e+02,7.00751e+02,4.57088e-03,7.17226e+02,
6.81293e+02,4.57459e-03,7.15741e+02,6.79905e+02,4.58645e-03,7.11032e+02,6.75493e+02,4.59860e-03,7.06255e+02,6.71011e+02,
4.61820e-03,6.98665e+02,6.63870e+02,4.61820e-03,9.55184e+02,8.99456e+02,4.61891e-03,9.54829e+02,8.99128e+02,4.62381e-03,
9.52383e+02,8.96858e+02,4.64255e-03,9.43120e+02,8.88255e+02,4.65000e-03,9.39477e+02,8.84866e+02,4.67735e-03,9.26011e+02,
8.72330e+02,4.69285e-03,9.18496e+02,8.65328e+02,4.71216e-03,9.09244e+02,8.56714e+02,4.73224e-03,8.99752e+02,8.47884e+02,
4.75174e-03,8.90652e+02,8.39427e+02,4.77000e-03,8.82241e+02,8.31618e+02,4.77662e-03,8.79070e+02,8.28671e+02,4.78630e-03,
8.74452e+02,8.24383e+02,4.80062e-03,8.67687e+02,8.18100e+02,4.86320e-03,8.38940e+02,7.91408e+02,4.88348e-03,8.29913e+02,
7.83014e+02,4.89779e-03,8.23634e+02,7.77168e+02,4.91167e-03,8.17603e+02,7.71550e+02,4.91420e-03,8.16512e+02,7.70532e+02,
4.91420e-03,9.40004e+02,8.85425e+02,4.94279e-03,9.26523e+02,8.72905e+02,4.95450e-03,9.21079e+02,8.67845e+02,5.00500e-03,
8.98107e+02,8.46476e+02,5.01187e-03,8.95040e+02,8.43625e+02,5.01190e-03,8.95027e+02,8.43613e+02,5.04822e-03,8.79068e+02,
8.28770e+02,5.07866e-03,8.65990e+02,8.16612e+02,5.08000e-03,8.65421e+02,8.16083e+02,5.12861e-03,8.45399e+02,7.97480e+02,
5.14952e-03,8.36997e+02,7.89669e+02,5.20295e-03,8.16033e+02,7.70181e+02,5.24807e-03,7.98896e+02,7.54247e+02,5.30000e-03,
7.79497e+02,7.36192e+02,5.30251e-03,7.78577e+02,7.35335e+02,5.35000e-03,7.61429e+02,7.19372e+02,5.37032e-03,7.54204e+02,
7.12641e+02,5.42250e-03,7.36004e+02,6.95678e+02,5.50000e-03,7.10080e+02,6.71505e+02,5.55119e-03,6.93662e+02,6.56184e+02,
5.55904e-03,6.91192e+02,6.53879e+02,5.62341e-03,6.71375e+02,6.35378e+02,5.68853e-03,6.52134e+02,6.17400e+02,5.75440e-03,
6.33259e+02,5.99748e+02,5.76977e-03,6.28929e+02,5.95696e+02,5.82103e-03,6.14777e+02,5.82454e+02,5.88844e-03,5.96845e+02,
5.65663e+02,5.95662e-03,5.79442e+02,5.49357e+02,5.98024e-03,5.73583e+02,5.43864e+02,6.02560e-03,5.62559e+02,5.33529e+02,
6.09537e-03,5.46182e+02,5.18168e+02,6.23735e-03,5.14892e+02,4.88789e+02,6.23968e-03,5.14396e+02,4.88323e+02,6.30957e-03,
4.99820e+02,4.74631e+02,6.30960e-03,4.99814e+02,4.74626e+02,6.38263e-03,4.85191e+02,4.60880e+02,6.45654e-03,4.71009e+02,
4.47540e+02,6.53131e-03,4.57244e+02,4.34583e+02,6.58479e-03,4.47704e+02,4.25599e+02,6.68344e-03,4.30817e+02,4.09691e+02,
6.76083e-03,4.18188e+02,3.97786e+02,6.80000e-03,4.11995e+02,3.91945e+02,6.83912e-03,4.05915e+02,3.86209e+02,6.91831e-03,
3.93990e+02,3.74953e+02,7.00346e-03,3.81626e+02,3.63275e+02,7.07946e-03,3.71037e+02,3.53271e+02,7.16143e-03,3.60065e+02,
3.42900e+02,7.24436e-03,3.49486e+02,3.32895e+02,7.32824e-03,3.39227e+02,3.23188e+02,7.41310e-03,3.29277e+02,3.13769e+02,
7.50839e-03,3.18590e+02,3.03645e+02,7.58578e-03,3.10259e+02,2.95753e+02,7.67362e-03,3.01172e+02,2.87140e+02,7.76247e-03,
2.92324e+02,2.78750e+02,7.94328e-03,2.75296e+02,2.62587e+02,7.94330e-03,2.75294e+02,2.62586e+02,8.12830e-03,2.59265e+02,
2.47357e+02,8.15090e-03,2.57398e+02,2.45582e+02,8.22243e-03,2.51607e+02,2.40079e+02,8.31764e-03,2.44181e+02,2.33019e+02,
8.41395e-03,2.36958e+02,2.26148e+02,8.51138e-03,2.29870e+02,2.19402e+02,8.60994e-03,2.22999e+02,2.12860e+02,8.70964e-03,
2.16336e+02,2.06513e+02,8.81049e-03,2.09876e+02,2.00357e+02,8.92190e-03,2.03056e+02,1.93855e+02,9.01571e-03,1.97547e+02,
1.88603e+02,9.12011e-03,1.91625e+02,1.82955e+02,9.22571e-03,1.85882e+02,1.77475e+02,9.33254e-03,1.80291e+02,1.72138e+02,
9.44061e-03,1.74866e+02,1.66958e+02,9.54993e-03,1.69609e+02,1.61937e+02,9.66051e-03,1.64515e+02,1.57070e+02,9.76897e-03,
1.59724e+02,1.52491e+02,9.88553e-03,1.54787e+02,1.47772e+02,1.00000e-02,1.50147e+02,1.43336e+02,1.01158e-02,1.45642e+02,
1.39029e+02,1.03514e-02,1.36983e+02,1.30746e+02,1.04713e-02,1.32855e+02,1.26795e+02,1.05925e-02,1.28855e+02,1.22966e+02,
1.07152e-02,1.24981e+02,1.19255e+02,1.08393e-02,1.21217e+02,1.15650e+02,1.09648e-02,1.17569e+02,1.12155e+02,1.11022e-02,
1.13715e+02,1.08461e+02,1.12202e-02,1.10543e+02,1.05422e+02,1.13501e-02,1.07194e+02,1.02212e+02,1.15000e-02,1.03505e+02,
9.86757e+01,1.16145e-02,1.00799e+02,9.60811e+01,1.17490e-02,9.77304e+01,9.31380e+01,1.18850e-02,9.47588e+01,9.02874e+01,
1.20226e-02,9.18809e+01,8.75262e+01,1.21619e-02,8.90935e+01,8.48514e+01,1.23027e-02,8.63934e+01,8.22600e+01,1.24451e-02,
8.37730e+01,7.97445e+01,1.25890e-02,8.12373e+01,7.73100e+01,1.25892e-02,8.12330e+01,7.73058e+01,1.26887e-02,7.95424e+01,
7.56826e+01,1.27350e-02,7.87715e+01,7.49427e+01,1.28825e-02,7.63864e+01,7.26537e+01,1.30317e-02,7.40761e+01,7.04362e+01,
1.33830e-02,6.89750e+01,6.55383e+01,1.34896e-02,6.75145e+01,6.41356e+01,1.36458e-02,6.54526e+01,6.21551e+01,1.38038e-02,
6.34560e+01,6.02373e+01,1.39637e-02,6.15224e+01,5.83798e+01,1.40000e-02,6.10946e+01,5.79688e+01,1.41254e-02,5.96489e+01,
5.65799e+01,1.42096e-02,5.87041e+01,5.56722e+01,1.42889e-02,5.78319e+01,5.48348e+01,1.44544e-02,5.60641e+01,5.31374e+01,
1.46218e-02,5.43523e+01,5.14936e+01,1.47911e-02,5.26926e+01,4.98999e+01,1.49624e-02,5.10854e+01,4.83565e+01,1.54882e-02,
4.65636e+01,4.40141e+01,1.55145e-02,4.63508e+01,4.38098e+01,1.56675e-02,4.51408e+01,4.26486e+01,1.58489e-02,4.37628e+01,
4.13261e+01,1.58490e-02,4.37622e+01,4.13256e+01,1.60324e-02,4.24211e+01,4.00386e+01,1.62181e-02,4.11215e+01,3.87914e+01,
1.65959e-02,3.86428e+01,3.64130e+01,1.67377e-02,3.77668e+01,3.55724e+01,1.67880e-02,3.74619e+01,3.52802e+01,1.69824e-02,
3.63177e+01,3.41835e+01,1.71791e-02,3.52097e+01,3.31217e+01,1.73000e-02,3.45498e+01,3.24892e+01,1.73780e-02,3.41329e+01,
3.20897e+01,1.77828e-02,3.20694e+01,3.01121e+01,1.79887e-02,3.10868e+01,2.91706e+01,1.81447e-02,3.03707e+01,2.84845e+01,
1.84077e-02,2.92129e+01,2.73767e+01,1.90546e-02,2.66047e+01,2.48814e+01,1.94908e-02,2.50283e+01,2.33740e+01,1.94985e-02,
2.50017e+01,2.33486e+01,1.97242e-02,2.42372e+01,2.26187e+01,1.99526e-02,2.34972e+01,2.19123e+01,1.99530e-02,2.34960e+01,
2.19111e+01,2.00000e-02,2.33473e+01,2.17693e+01,2.01837e-02,2.27749e+01,2.12229e+01,2.04174e-02,2.20738e+01,2.05538e+01,
2.06538e-02,2.13951e+01,1.99063e+01,2.11349e-02,2.01021e+01,1.86730e+01,2.11561e-02,2.00475e+01,1.86210e+01,2.13796e-02,
1.94825e+01,1.80830e+01,2.23872e-02,1.71953e+01,1.59069e+01,2.26464e-02,1.66686e+01,1.54061e+01,2.27456e-02,1.64731e+01,
1.52203e+01,2.29087e-02,1.61580e+01,1.49214e+01,2.30000e-02,1.59852e+01,1.47576e+01,2.34423e-02,1.51828e+01,1.39966e+01,
2.37137e-02,1.47142e+01,1.35523e+01,2.44460e-02,1.35473e+01,1.24464e+01,2.45851e-02,1.33403e+01,1.22504e+01,2.48313e-02,
1.29839e+01,1.19137e+01,2.51189e-02,1.25834e+01,1.15355e+01,2.51190e-02,1.25832e+01,1.15353e+01,2.60618e-02,1.13839e+01,
1.04036e+01,2.63027e-02,1.11023e+01,1.01388e+01,2.66073e-02,1.07606e+01,9.81765e+00,2.69154e-02,1.04299e+01,9.50691e+00,
2.72270e-02,1.01098e+01,9.20625e+00,2.73112e-02,1.00255e+01,9.12717e+00,2.75423e-02,9.79837e+00,8.91468e+00,2.78612e-02,
9.49408e+00,8.62999e+00,2.82694e-02,9.12362e+00,8.28355e+00,2.85102e-02,8.91348e+00,8.08805e+00,2.88403e-02,8.63610e+00,
7.83006e+00,2.90486e-02,8.46734e+00,7.67314e+00,2.95121e-02,8.10531e+00,7.33886e+00,2.96906e-02,7.97146e+00,7.21529e+00,
3.01825e-02,7.61445e+00,6.88890e+00,3.05058e-02,7.38888e+00,6.68528e+00,3.06650e-02,7.27969e+00,6.58797e+00,3.08096e-02,
7.18122e+00,6.50127e+00,3.09030e-02,7.11768e+00,6.44609e+00,3.09301e-02,7.09940e+00,6.43022e+00,3.10981e-02,6.98556e+00,
6.33301e+00,3.12608e-02,6.87591e+00,6.24081e+00,3.14749e-02,6.73540e+00,6.12229e+00,3.16062e-02,6.65404e+00,6.05114e+00,
3.16228e-02,6.64433e+00,6.04222e+00,3.16230e-02,6.64420e+00,6.04210e+00,3.17137e-02,6.59146e+00,5.99372e+00,3.18050e-02,
6.54189e+00,5.94554e+00,3.18050e-02,3.70463e+01,1.25922e+01,3.18282e-02,3.69801e+01,1.25861e+01,3.19428e-02,3.66601e+01,
1.25560e+01,3.20300e-02,3.64214e+01,1.25327e+01,3.20567e-02,3.63488e+01,1.25254e+01,3.23594e-02,3.55455e+01,1.24410e+01,
3.24664e-02,3.52680e+01,1.24102e+01,3.26821e-02,3.47146e+01,1.23468e+01,3.27341e-02,3.45821e+01,1.23312e+01,3.28000e-02,
3.44152e+01,1.23114e+01,3.29076e-02,3.41169e+01,1.22683e+01,3.31131e-02,3.35545e+01,1.21853e+01,3.31962e-02,3.33309e+01,
1.21515e+01,3.35000e-02,3.25273e+01,1.20266e+01,3.35484e-02,3.24116e+01,1.20102e+01,3.38844e-02,3.16226e+01,1.18954e+01,
3.40106e-02,3.13333e+01,1.18517e+01,3.46737e-02,2.98701e+01,1.16176e+01,3.48197e-02,2.95443e+01,1.15585e+01,3.50752e-02,
2.89849e+01,1.14548e+01,3.56526e-02,2.77738e+01,1.12190e+01,3.63078e-02,2.64814e+01,1.09507e+01,3.67282e-02,2.56962e+01,
1.07789e+01,3.67851e-02,2.55925e+01,1.07557e+01,3.71535e-02,2.49339e+01,1.06059e+01,3.75837e-02,2.41935e+01,1.04314e+01,
3.80189e-02,2.34862e+01,1.02611e+01,3.82453e-02,2.31297e+01,1.01743e+01,3.84592e-02,2.27995e+01,1.00926e+01,3.89045e-02,
2.21327e+01,9.92350e+00,3.98107e-02,2.08578e+01,9.58477e+00,3.98110e-02,2.08575e+01,9.58466e+00,4.02717e-02,2.02485e+01,
9.41549e+00,4.04169e-02,2.00618e+01,9.36267e+00,4.15000e-02,1.87408e+01,8.97590e+00,4.16869e-02,1.85202e+01,8.90805e+00,
4.21696e-02,1.79671e+01,8.73504e+00,4.26579e-02,1.74307e+01,8.56318e+00,4.27997e-02,1.72791e+01,8.51391e+00,4.31519e-02,
1.69102e+01,8.39270e+00,4.36516e-02,1.64048e+01,8.22341e+00,4.41570e-02,1.59147e+01,8.05573e+00,4.46684e-02,1.54395e+01,
7.88977e+00,4.56495e-02,1.45815e+01,7.58146e+00,4.57088e-02,1.45318e+01,7.56324e+00,4.62381e-02,1.40981e+01,7.40287e+00,
4.73151e-02,1.32699e+01,7.08823e+00,4.89779e-02,1.20995e+01,6.62098e+00,4.93722e-02,1.18431e+01,6.51641e+00,5.01187e-02,
1.13778e+01,6.32374e+00,5.01190e-02,1.13776e+01,6.32367e+00,5.06991e-02,1.10333e+01,6.17867e+00,5.18800e-02,1.03750e+01,
5.89522e+00,5.24807e-02,1.00611e+01,5.75713e+00,5.37032e-02,9.46160e+00,5.48809e+00,5.40372e-02,9.30651e+00,5.41732e+00,
5.43250e-02,9.17555e+00,5.35723e+00,5.62341e-02,8.36890e+00,4.97925e+00,5.95673e-02,7.18176e+00,4.39703e+00,6.02560e-02,
6.96599e+00,4.28779e+00,6.16595e-02,6.54607e+00,4.07090e+00,6.23735e-02,6.34594e+00,3.96602e+00,6.30957e-02,6.15205e+00,
3.86345e+00,6.30960e-02,6.15198e+00,3.86342e+00,6.45654e-02,5.78211e+00,3.66522e+00,6.54885e-02,5.56547e+00,3.54745e+00,
6.57847e-02,5.49836e+00,3.51072e+00,6.60693e-02,5.43489e+00,3.47588e+00,6.91831e-02,4.80301e+00,3.12298e+00,7.00000e-02,
4.65440e+00,3.03830e+00,7.16143e-02,4.37916e+00,2.88014e+00,7.41310e-02,3.99346e+00,2.65440e+00,7.49894e-02,3.87287e+00,
2.58281e+00,7.51386e-02,3.85243e+00,2.57063e+00,7.58578e-02,3.75595e+00,2.51297e+00,7.85236e-02,3.42238e+00,2.31059e+00,
7.94328e-02,3.31816e+00,2.24656e+00,7.94330e-02,3.31814e+00,2.24654e+00,8.22243e-02,3.02468e+00,2.06429e+00,8.41395e-02,
2.84419e+00,1.95056e+00,8.60994e-02,2.67495e+00,1.84273e+00,8.70964e-02,2.59424e+00,1.79089e+00,9.12011e-02,2.29615e+00,
1.59700e+00,9.16833e-02,2.26440e+00,1.57612e+00,9.44061e-02,2.09634e+00,1.46485e+00,9.54993e-02,2.03389e+00,1.42317e+00,
9.66051e-02,1.97283e+00,1.38216e+00,9.88553e-02,1.85648e+00,1.30353e+00,1.00000e-01,1.80108e+00,1.26586e+00,1.01158e-01,
1.74736e+00,1.22925e+00,1.02329e-01,1.69535e+00,1.19368e+00,1.05925e-01,1.54905e+00,1.09285e+00,1.07152e-01,1.50331e+00,
1.06109e+00,1.11222e-01,1.36495e+00,9.64319e-01,1.13501e-01,1.29546e+00,9.15343e-01,1.14815e-01,1.25775e+00,8.88649e-01,
1.16145e-01,1.22123e+00,8.62746e-01,1.17490e-01,1.18587e+00,8.37587e-01,1.18850e-01,1.15164e+00,8.13154e-01,1.20226e-01,
1.11849e+00,7.89428e-01,1.25890e-01,9.96137e-01,7.01235e-01,1.25893e-01,9.96087e-01,7.01199e-01,1.28825e-01,9.40418e-01,
6.60901e-01,1.35347e-01,8.32067e-01,5.81849e-01,1.36458e-01,8.15517e-01,5.69715e-01,1.38038e-01,7.92841e-01,5.53060e-01,
1.39637e-01,7.70881e-01,5.36898e-01,1.41254e-01,7.49613e-01,5.21214e-01,1.42889e-01,7.29018e-01,5.05997e-01,1.46218e-01,
6.89738e-01,4.76892e-01,1.47911e-01,6.71022e-01,4.62986e-01,1.58489e-01,5.70477e-01,3.87875e-01,1.58490e-01,5.70471e-01,
3.87871e-01,1.60324e-01,5.55451e-01,3.76663e-01,1.62181e-01,5.40895e-01,3.65787e-01,1.64059e-01,5.26793e-01,3.55240e-01,
1.65959e-01,5.13131e-01,3.45011e-01,1.67880e-01,4.99896e-01,3.35091e-01,1.71791e-01,4.74649e-01,3.16141e-01,1.75792e-01,
4.50949e-01,2.98323e-01,1.79513e-01,4.30655e-01,2.83044e-01,1.79887e-01,4.28699e-01,2.81572e-01,1.86209e-01,3.97805e-01,
2.58305e-01,1.92752e-01,3.69685e-01,2.37097e-01,1.94984e-01,3.60884e-01,2.30455e-01,1.97242e-01,3.52354e-01,2.24016e-01,
1.99526e-01,3.44085e-01,2.17773e-01,1.99530e-01,3.44072e-01,2.17763e-01,2.01837e-01,3.36021e-01,2.11748e-01,2.04174e-01,
3.28269e-01,2.05966e-01,2.08930e-01,3.13460e-01,1.94924e-01,2.11349e-01,3.06388e-01,1.89653e-01,2.21309e-01,2.80158e-01,
1.70119e-01,2.22810e-01,2.76574e-01,1.67454e-01,2.23872e-01,2.74085e-01,1.65606e-01,2.26464e-01,2.68188e-01,1.61230e-01,
2.29087e-01,2.62467e-01,1.56987e-01,2.31740e-01,2.56916e-01,1.52873e-01,2.37137e-01,2.46304e-01,1.45018e-01,2.39883e-01,
2.41232e-01,1.41270e-01,2.42661e-01,2.36311e-01,1.37635e-01,2.45471e-01,2.31534e-01,1.34112e-01,2.48313e-01,2.26899e-01,
1.30697e-01,2.51189e-01,2.22449e-01,1.27431e-01,2.51190e-01,2.22447e-01,1.27429e-01,2.54097e-01,2.18088e-01,1.24289e-01,
2.57040e-01,2.13852e-01,1.21241e-01,2.60016e-01,2.09737e-01,1.18285e-01,2.63027e-01,2.05740e-01,1.15419e-01,2.66073e-01,
2.01857e-01,1.12638e-01,2.69154e-01,1.98084e-01,1.09942e-01,2.72270e-01,1.94422e-01,1.07330e-01,2.81838e-01,1.84044e-01,
9.99550e-02,2.85102e-01,1.80776e-01,9.76427e-02,2.88403e-01,1.77600e-01,9.53997e-02,2.91743e-01,1.74513e-01,9.32242e-02,
2.93695e-01,1.72764e-01,9.19939e-02,2.95121e-01,1.71510e-01,9.11138e-02,3.00000e-01,1.67431e-01,8.82703e-02,3.09029e-01,
1.60446e-01,8.34244e-02,3.16228e-01,1.55352e-01,7.99101e-02,3.16230e-01,1.55351e-01,7.99091e-02,3.19889e-01,1.52874e-01,
7.82536e-02,3.23594e-01,1.50464e-01,7.66482e-02,3.27341e-01,1.48118e-01,7.50897e-02,3.31131e-01,1.45833e-01,7.35770e-02,
3.34965e-01,1.43608e-01,7.21085e-02,3.38844e-01,1.41441e-01,7.06827e-02,3.42768e-01,1.39330e-01,6.92986e-02,3.46737e-01,
1.37300e-01,6.79800e-02,3.50752e-01,1.35322e-01,6.66992e-02,3.54813e-01,1.33394e-01,6.54547e-02,3.58922e-01,1.31513e-01,
6.42457e-02,3.63078e-01,1.29680e-01,6.30709e-02,3.67282e-01,1.27893e-01,6.19296e-02,3.71535e-01,1.26152e-01,6.08227e-02,
3.80189e-01,1.22796e-01,5.87014e-02,3.89045e-01,1.19603e-01,5.66977e-02,3.93550e-01,1.18084e-01,5.57565e-02,3.98107e-01,
1.16601e-01,5.48416e-02,3.98110e-01,1.16600e-01,5.48410e-02,4.02717e-01,1.15126e-01,5.39733e-02,4.16869e-01,1.10902e-01,
5.15077e-02,4.19915e-01,1.10049e-01,5.10144e-02,4.21697e-01,1.09559e-01,5.07315e-02,4.26580e-01,1.08245e-01,4.99762e-02,
4.31519e-01,1.06961e-01,4.92410e-02,4.36516e-01,1.05705e-01,4.85256e-02,4.41570e-01,1.04494e-01,4.78449e-02,4.46684e-01,
1.03310e-01,4.71819e-02,4.57088e-01,1.01016e-01,4.59074e-02,4.62381e-01,9.99063e-02,4.52945e-02,4.67735e-01,9.88196e-02,
4.46972e-02,4.73151e-01,9.77572e-02,4.41165e-02,4.78630e-01,9.67169e-02,4.35504e-02,4.84172e-01,9.56982e-02,4.29986e-02,
4.89779e-01,9.47006e-02,4.24609e-02,4.95450e-01,9.37356e-02,4.19482e-02,5.01187e-01,9.27898e-02,4.14479e-02,5.01190e-01,
9.27894e-02,4.14477e-02,5.18800e-01,8.99962e-02,4.00734e-02,5.24808e-01,8.91005e-02,3.96367e-02,5.30884e-01,8.82230e-02,
3.92112e-02,5.37032e-01,8.73621e-02,3.87958e-02,5.43250e-01,8.65174e-02,3.83900e-02,5.55904e-01,8.48930e-02,3.76235e-02,
5.62341e-01,8.41026e-02,3.72530e-02,5.68853e-01,8.33265e-02,3.68906e-02,5.75440e-01,8.25640e-02,3.65361e-02,5.82103e-01,
8.18150e-02,3.61892e-02,5.88844e-01,8.10791e-02,3.58498e-02,5.95662e-01,8.03568e-02,3.55185e-02,6.02560e-01,7.96470e-02,
3.51942e-02,6.09537e-01,7.89573e-02,3.48844e-02,6.16595e-01,7.82789e-02,3.45808e-02,6.23735e-01,7.76117e-02,3.42833e-02,
6.30957e-01,7.69555e-02,3.39917e-02,6.30960e-01,7.69552e-02,3.39916e-02,6.32776e-01,7.67881e-02,3.39237e-02,6.38264e-01,
7.62894e-02,3.37219e-02,6.45654e-01,7.56338e-02,3.34573e-02,6.53131e-01,7.49885e-02,3.31975e-02,6.60694e-01,7.43540e-02,
3.29431e-02,6.68344e-01,7.37293e-02,3.26933e-02,6.83912e-01,7.25204e-02,3.22186e-02,6.91831e-01,7.19293e-02,3.19872e-02,
6.99842e-01,7.13470e-02,3.17598e-02,7.07946e-01,7.07732e-02,3.15361e-02,7.16143e-01,7.02077e-02,3.13160e-02,7.24436e-01,
6.96503e-02,3.10994e-02,7.41310e-01,6.85601e-02,3.06775e-02,7.49894e-01,6.80313e-02,3.04761e-02,7.58578e-01,6.75096e-02,
3.02776e-02,7.67362e-01,6.69950e-02,3.00819e-02,7.76247e-01,6.64874e-02,2.98892e-02,7.85236e-01,6.59864e-02,2.96991e-02,
7.94328e-01,6.54921e-02,2.95116e-02,7.94330e-01,6.54920e-02,2.95116e-02,8.03526e-01,6.49858e-02,2.93386e-02,8.22243e-01,
6.39934e-02,2.89994e-02,8.41395e-01,6.30332e-02,2.86752e-02,8.51138e-01,6.25619e-02,2.85156e-02,8.60994e-01,6.20963e-02,
2.83577e-02,8.70964e-01,6.16364e-02,2.82015e-02,8.91251e-01,6.07329e-02,2.78938e-02,9.01571e-01,6.02895e-02,2.77425e-02,
9.12011e-01,5.98546e-02,2.75960e-02,9.22571e-01,5.94247e-02,2.74507e-02,9.33254e-01,5.89996e-02,2.73067e-02,9.44061e-01,
5.85793e-02,2.71639e-02,9.54993e-01,5.81637e-02,2.70224e-02,9.77237e-01,5.73462e-02,2.67428e-02,9.82193e-01,5.71691e-02,
2.66821e-02,9.88553e-01,5.69443e-02,2.66050e-02,1.00000e+00,5.65493e-02,2.64708e-02,1.00000e-03,9.10379e+03,9.09589e+03,
1.00173e-03,9.07077e+03,9.06288e+03,1.01500e-03,8.82300e+03,8.81513e+03,1.03000e-03,8.55467e+03,8.54683e+03,1.03514e-03,
8.46513e+03,8.45730e+03,1.04016e-03,8.37968e+03,8.37186e+03,1.04713e-03,8.26305e+03,8.25523e+03,1.05115e-03,8.19675e+03,
8.18893e+03,1.05540e-03,8.12740e+03,8.11956e+03,1.05540e-03,8.47402e+03,8.46596e+03,1.05925e-03,8.41101e+03,8.40294e+03,
1.06000e-03,8.39889e+03,8.39082e+03,1.06234e-03,8.36068e+03,8.35260e+03,1.06300e-03,8.35004e+03,8.34195e+03,1.07152e-03,
8.21142e+03,8.20330e+03,1.07535e-03,8.15041e+03,8.14227e+03,1.08562e-03,7.98984e+03,7.98167e+03,1.09648e-03,7.82522e+03,
7.81704e+03,1.10098e-03,7.75777e+03,7.74958e+03,1.12121e-03,7.46526e+03,7.45707e+03,1.12202e-03,7.45388e+03,7.44570e+03,
1.13501e-03,7.27537e+03,7.26719e+03,1.14781e-03,7.10417e+03,7.09600e+03,1.15000e-03,7.07546e+03,7.06729e+03,1.16145e-03,
6.92804e+03,6.91988e+03,1.17293e-03,6.78184e+03,6.77369e+03,1.17490e-03,6.75730e+03,6.74915e+03,1.18850e-03,6.59044e+03,
6.58232e+03,1.19000e-03,6.57245e+03,6.56433e+03,1.20250e-03,6.42390e+03,6.41579e+03,1.21619e-03,6.26684e+03,6.25876e+03,
1.23027e-03,6.11131e+03,6.10325e+03,1.24451e-03,5.96086e+03,5.95283e+03,1.25890e-03,5.81236e+03,5.80435e+03,1.25892e-03,
5.81211e+03,5.80410e+03,1.27000e-03,5.70135e+03,5.69335e+03,1.27619e-03,5.64086e+03,5.63288e+03,1.30000e-03,5.41649e+03,
5.40855e+03,1.31826e-03,5.25148e+03,5.24357e+03,1.33352e-03,5.11919e+03,5.11130e+03,1.34896e-03,4.98921e+03,4.98135e+03,
1.35000e-03,4.98066e+03,4.97280e+03,1.35695e-03,4.92339e+03,4.91554e+03,1.36458e-03,4.86165e+03,4.85382e+03,1.38038e-03,
4.73737e+03,4.72956e+03,1.40000e-03,4.58961e+03,4.58184e+03,1.41254e-03,4.49750e+03,4.48974e+03,1.42889e-03,4.38131e+03,
4.37358e+03,1.44440e-03,4.27432e+03,4.26661e+03,1.45000e-03,4.23661e+03,4.22891e+03,1.46218e-03,4.15612e+03,4.14845e+03,
1.47911e-03,4.04746e+03,4.03982e+03,1.50000e-03,3.91905e+03,3.91143e+03,1.53109e-03,3.73877e+03,3.73121e+03,1.54882e-03,
3.64124e+03,3.63371e+03,1.56675e-03,3.54622e+03,3.53872e+03,1.57000e-03,3.52938e+03,3.52189e+03,1.58489e-03,3.45266e+03,
3.44520e+03,1.58490e-03,3.45262e+03,3.44516e+03,1.62181e-03,3.27249e+03,3.26509e+03,1.65959e-03,3.10147e+03,3.09413e+03,
1.67880e-03,3.01906e+03,3.01176e+03,1.67977e-03,3.01500e+03,3.00770e+03,1.69824e-03,2.93893e+03,2.93166e+03,1.73780e-03,
2.78531e+03,2.77811e+03,1.75792e-03,2.71083e+03,2.70367e+03,1.77828e-03,2.63818e+03,2.63105e+03,1.80000e-03,2.56329e+03,
2.55619e+03,1.81525e-03,2.51246e+03,2.50539e+03,1.81970e-03,2.49791e+03,2.49084e+03,1.84077e-03,2.43051e+03,2.42347e+03,
1.88365e-03,2.30134e+03,2.29438e+03,1.90546e-03,2.23944e+03,2.23252e+03,1.92753e-03,2.17929e+03,2.17240e+03,1.95000e-03,
2.11994e+03,2.11308e+03,1.97242e-03,2.06275e+03,2.05593e+03,1.99526e-03,2.00677e+03,1.99999e+03,1.99530e-03,2.00668e+03,
1.99990e+03,2.01837e-03,1.95231e+03,1.94557e+03,2.04174e-03,1.89902e+03,1.89232e+03,2.06538e-03,1.84725e+03,1.84058e+03,
2.08930e-03,1.79695e+03,1.79032e+03,2.11349e-03,1.74779e+03,1.74120e+03,2.13796e-03,1.70004e+03,1.69349e+03,2.15000e-03,
1.67724e+03,1.67070e+03,2.16272e-03,1.65343e+03,1.64691e+03,2.16651e-03,1.64640e+03,1.63989e+03,2.23872e-03,1.52042e+03,
1.51402e+03,2.26370e-03,1.47991e+03,1.47355e+03,2.26464e-03,1.47841e+03,1.47204e+03,2.29087e-03,1.43759e+03,1.43127e+03,
2.37137e-03,1.32216e+03,1.31596e+03,2.42661e-03,1.25000e+03,1.24388e+03,2.45471e-03,1.21519e+03,1.20911e+03,2.49029e-03,
1.17307e+03,1.16704e+03,2.51189e-03,1.14851e+03,1.14251e+03,2.51190e-03,1.14849e+03,1.14249e+03,2.54097e-03,1.11660e+03,
1.11063e+03,2.57040e-03,1.08562e+03,1.07970e+03,2.60016e-03,1.05543e+03,1.04955e+03,2.60689e-03,1.04873e+03,1.04286e+03,
2.63027e-03,1.02591e+03,1.02007e+03,2.65000e-03,1.00720e+03,1.00139e+03,2.66073e-03,9.97221e+02,9.91427e+02,2.69154e-03,
9.69235e+02,9.63484e+02,2.75423e-03,9.15413e+02,9.09749e+02,2.78612e-03,8.89671e+02,8.84050e+02,2.81838e-03,8.64664e+02,
8.59085e+02,2.86579e-03,8.29631e+02,8.24114e+02,2.88403e-03,8.16675e+02,8.11183e+02,2.91743e-03,7.93743e+02,7.88296e+02,
2.95121e-03,7.71473e+02,7.66071e+02,2.99588e-03,7.43168e+02,7.37824e+02,3.05492e-03,7.07950e+02,7.02686e+02,3.09030e-03,
6.87899e+02,6.82682e+02,3.13509e-03,6.63583e+02,6.58423e+02,3.15000e-03,