#include "GateSourceFastY90.hh"

// Bremsstrahlung probability 0 - 2 MeV, in 10 keV steps
const G4double GateSourceFastY90::mEnergyTable[200] = {
    2.176690e-02, 1.143010e-02, 6.176220e-03, 4.078650e-03, 2.959660e-03, 2.276090e-03, 1.817440e-03, 1.490570e-03, 1.248470e-03, 1.061400e-03, 9.160720e-04, 7.987130e-04, 7.018420e-04, 6.224380e-04, 5.530880e-04, 4.992290e-04, 4.479740e-04, 4.060770e-04, 3.699180e-04, 3.365980e-04, 3.083100e-04, 2.838670e-04, 2.608470e-04, 2.409590e-04, 2.233270e-04, 2.071100e-04, 1.927290e-04, 1.779720e-04, 1.674050e-04, 1.557830e-04, 1.457910e-04, 1.366450e-04, 1.283900e-04, 1.205460e-04, 1.131780e-04, 1.070460e-04, 1.011090e-04, 9.493100e-05, 8.977200e-05, 8.447300e-05, 8.028300e-05, 7.624600e-05, 7.200300e-05, 6.821700e-05, 6.414900e-05, 6.098700e-05, 5.830500e-05, 5.506200e-05, 5.219300e-05, 4.970400e-05, 4.746500e-05, 4.506367e-05, 4.299500e-05, 4.112057e-05, 3.917114e-05, 3.734614e-05, 3.569886e-05, 3.403114e-05, 3.250686e-05, 3.105457e-05, 2.962743e-05, 2.831257e-05, 2.709943e-05, 2.585786e-05, 2.476286e-05, 2.368829e-05, 2.261029e-05, 2.166014e-05, 2.074843e-05, 1.983929e-05, 1.896443e-05, 1.816400e-05, 1.733543e-05, 1.660129e-05, 1.588371e-05, 1.517471e-05, 1.449086e-05, 1.389429e-05, 1.328586e-05, 1.275886e-05, 1.222243e-05, 1.169300e-05, 1.122271e-05, 1.077857e-05, 1.033857e-05, 9.917857e-06, 9.490714e-06, 9.132286e-06, 8.762143e-06, 8.383857e-06, 8.027857e-06, 7.689286e-06, 7.353143e-06, 7.080143e-06, 6.772429e-06, 6.501571e-06, 6.225143e-06, 5.957857e-06, 5.733429e-06, 5.486286e-06, 5.231143e-06, 4.986429e-06, 4.761714e-06, 4.567286e-06, 4.390000e-06, 4.165714e-06, 3.999857e-06, 3.826286e-06, 3.672857e-06, 3.527286e-06, 3.375286e-06, 3.215857e-06, 3.083857e-06, 2.958286e-06, 2.843143e-06, 2.726000e-06, 2.598429e-06, 2.473286e-06, 2.366571e-06, 2.263143e-06, 2.150000e-06, 2.039571e-06, 1.940714e-06, 1.853571e-06, 1.766714e-06, 1.685571e-06, 1.604286e-06, 1.525286e-06, 1.456571e-06, 1.382143e-06, 1.307143e-06, 1.249143e-06, 1.192143e-06, 1.129714e-06, 1.074714e-06, 1.019429e-06, 9.712857e-07, 9.198571e-07, 8.715714e-07, 8.182857e-07, 7.815714e-07, 7.458571e-07, 7.107143e-07, 6.747143e-07, 6.410000e-07, 6.037143e-07, 5.722857e-07, 5.465714e-07, 5.130000e-07, 4.860000e-07, 4.545714e-07, 4.341429e-07, 4.150000e-07, 3.888571e-07, 3.624286e-07, 3.431429e-07, 3.225714e-07, 3.048571e-07, 2.825714e-07, 2.652857e-07, 2.531429e-07, 2.354286e-07, 2.241429e-07, 2.060000e-07, 1.975714e-07, 1.828571e-07, 1.690000e-07, 1.561429e-07, 1.445714e-07, 1.305714e-07, 1.218571e-07, 1.075714e-07, 9.942857e-08, 9.028571e-08, 7.957143e-08, 7.385714e-08, 6.814286e-08, 6.314286e-08, 5.914286e-08, 5.514286e-08, 5.128571e-08, 4.871429e-08, 4.671429e-08, 4.257143e-08, 3.800000e-08, 3.471429e-08, 2.957143e-08, 2.614286e-08, 2.257143e-08, 1.900000e-08, 1.714286e-08, 1.500000e-08, 1.257143e-08, 1.214286e-08, 1.071429e-08, 1.014286e-08, 8.714286e-09, 6.800000e-09, 4.333333e-09, 3.000000e-09 };

// Distance from source to point of bremsstrahlung origin, 0 - 2 MeV in 20 keV steps, 0 - 12 mm in 0.1 mm steps
const G4double GateSourceFastY90::mRangeTable[100][120] = {
    { 8.235150e+05, 8.175640e+05, 8.150560e+05, 8.161190e+05, 8.208290e+05, 8.207290e+05, 8.320600e+05, 8.541420e+05, 8.696140e+05, 8.875310e+05, 8.739540e+05, 8.560160e+05, 8.415780e+05, 8.288150e+05, 8.142780e+05, 7.985510e+05, 7.855910e+05, 7.695020e+05, 7.522620e+05, 7.376410e+05, 7.215970e+05, 7.041570e+05, 6.863470e+05, 6.703900e+05, 6.536430e+05, 6.368270e+05, 6.172890e+05, 5.978830e+05, 5.799500e+05, 5.631270e+05, 5.440430e+05, 5.258340e+05, 5.077250e+05, 4.901170e+05, 4.718400e+05, 4.571990e+05, 4.408570e+05, 4.245510e+05, 4.094320e+05, 3.940730e+05, 3.784860e+05, 3.617280e+05, 3.455150e+05, 3.312640e+05, 3.149750e+05, 3.001420e+05, 2.846410e+05, 2.691710e+05, 2.541180e+05, 2.393380e+05, 2.241580e+05, 2.101190e+05, 1.967490e+05, 1.836470e+05, 1.719670e+05, 1.592180e+05, 1.475310e+05, 1.359870e+05, 1.250770e+05, 1.152850e+05, 1.052820e+05, 9.698100e+04, 8.785400e+04, 7.959900e+04, 7.205100e+04, 6.450800e+04, 5.780000e+04, 5.145600e+04, 4.591300e+04, 4.062200e+04, 3.557100e+04, 3.097900e+04, 2.730000e+04, 2.351600e+04, 2.047800e+04, 1.714300e+04, 1.462500e+04, 1.230800e+04, 1.027500e+04, 8.415000e+03, 7.124000e+03, 5.890000e+03, 4.683000e+03, 3.657000e+03, 3.022000e+03, 2.207000e+03, 1.746000e+03, 1.273000e+03, 9.700000e+02, 7.590000e+02, 5.020000e+02, 3.530000e+02, 2.470000e+02, 1.950000e+02, 1.260000e+02, 8.300000e+01, 6.900000e+01, 3.600000e+01, 1.400000e+01, 1.100000e+01, 7.000000e+00, 3.000000e+00, 5.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.556650e+05, 2.575750e+05, 2.578770e+05, 2.581240e+05, 2.584850e+05, 2.589080e+05, 2.608290e+05, 2.650510e+05, 2.702550e+05, 2.742500e+05, 2.726140e+05, 2.664800e+05, 2.634840e+05, 2.593860e+05, 2.553470e+05, 2.502500e+05, 2.455710e+05, 2.408240e+05, 2.358340e+05, 2.308910e+05, 2.243300e+05, 2.202750e+05, 2.135810e+05, 2.081570e+05, 2.025420e+05, 1.968060e+05, 1.911370e+05, 1.850180e+05, 1.793260e+05, 1.738050e+05, 1.677170e+05, 1.621370e+05, 1.571150e+05, 1.505200e+05, 1.452600e+05, 1.400460e+05, 1.348720e+05, 1.301900e+05, 1.245050e+05, 1.189660e+05, 1.142880e+05, 1.095370e+05, 1.046600e+05, 1.000420e+05, 9.519800e+04, 9.005200e+04, 8.520400e+04, 8.064200e+04, 7.643300e+04, 7.152700e+04, 6.720300e+04, 6.264500e+04, 5.857600e+04, 5.435200e+04, 5.093200e+04, 4.704300e+04, 4.347800e+04, 3.990700e+04, 3.713600e+04, 3.385700e+04, 3.096200e+04, 2.792700e+04, 2.538900e+04, 2.286400e+04, 2.076700e+04, 1.844900e+04, 1.687900e+04, 1.472700e+04, 1.330600e+04, 1.160700e+04, 1.013900e+04, 8.949000e+03, 7.612000e+03, 6.483000e+03, 5.585000e+03, 4.748000e+03, 4.051000e+03, 3.526000e+03, 2.868000e+03, 2.330000e+03, 1.929000e+03, 1.625000e+03, 1.225000e+03, 1.059000e+03, 7.920000e+02, 6.170000e+02, 4.950000e+02, 3.740000e+02, 2.510000e+02, 1.990000e+02, 1.430000e+02, 9.000000e+01, 6.400000e+01, 4.000000e+01, 3.200000e+01, 2.200000e+01, 1.100000e+01, 1.200000e+01, 6.000000e+00, 5.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.320140e+05, 1.336660e+05, 1.336830e+05, 1.343800e+05, 1.341830e+05, 1.345660e+05, 1.354490e+05, 1.370160e+05, 1.388150e+05, 1.407300e+05, 1.396010e+05, 1.370930e+05, 1.354080e+05, 1.339020e+05, 1.318660e+05, 1.298970e+05, 1.267910e+05, 1.241650e+05, 1.207530e+05, 1.178090e+05, 1.153320e+05, 1.133980e+05, 1.099950e+05, 1.062380e+05, 1.033130e+05, 1.008790e+05, 9.778300e+04, 9.473500e+04, 9.131200e+04, 8.853800e+04, 8.537900e+04, 8.175600e+04, 7.863900e+04, 7.665600e+04, 7.372600e+04, 7.083400e+04, 6.804200e+04, 6.495900e+04, 6.281900e+04, 6.041400e+04, 5.762900e+04, 5.486700e+04, 5.322200e+04, 5.012500e+04, 4.775600e+04, 4.548100e+04, 4.287400e+04, 4.038300e+04, 3.770900e+04, 3.516100e+04, 3.388000e+04, 3.145200e+04, 2.916400e+04, 2.713300e+04, 2.508400e+04, 2.300100e+04, 2.113600e+04, 1.961200e+04, 1.792900e+04, 1.637000e+04, 1.505500e+04, 1.377300e+04, 1.237300e+04, 1.116400e+04, 1.001600e+04, 9.057000e+03, 7.879000e+03, 7.091000e+03, 6.277000e+03, 5.581000e+03, 4.781000e+03, 4.234000e+03, 3.637000e+03, 3.234000e+03, 2.674000e+03, 2.335000e+03, 1.909000e+03, 1.659000e+03, 1.348000e+03, 1.078000e+03, 9.060000e+02, 7.020000e+02, 6.250000e+02, 4.810000e+02, 3.470000e+02, 2.750000e+02, 2.380000e+02, 1.410000e+02, 1.120000e+02, 8.200000e+01, 5.300000e+01, 3.500000e+01, 3.300000e+01, 1.700000e+01, 1.300000e+01, 1.000000e+01, 7.000000e+00, 3.000000e+00, 2.000000e+00, 3.000000e+00, 1.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 8.470800e+04, 8.554700e+04, 8.623700e+04, 8.629400e+04, 8.605300e+04, 8.623400e+04, 8.589600e+04, 8.715900e+04, 8.805400e+04, 8.915000e+04, 8.866000e+04, 8.743000e+04, 8.651200e+04, 8.530800e+04, 8.365400e+04, 8.267700e+04, 8.084200e+04, 7.913700e+04, 7.726300e+04, 7.547500e+04, 7.340800e+04, 7.182000e+04, 6.914200e+04, 6.800000e+04, 6.500000e+04, 6.380100e+04, 6.153400e+04, 5.899900e+04, 5.774100e+04, 5.569100e+04, 5.343100e+04, 5.208200e+04, 5.031500e+04, 4.810600e+04, 4.621300e+04, 4.432700e+04, 4.295800e+04, 4.122800e+04, 3.933700e+04, 3.764500e+04, 3.584200e+04, 3.459200e+04, 3.277300e+04, 3.110200e+04, 2.966200e+04, 2.809700e+04, 2.651700e+04, 2.454900e+04, 2.353500e+04, 2.206800e+04, 2.048100e+04, 1.912800e+04, 1.777600e+04, 1.639100e+04, 1.552200e+04, 1.400500e+04, 1.300600e+04, 1.186600e+04, 1.092200e+04, 9.988000e+03, 8.884000e+03, 8.246000e+03, 7.426000e+03, 6.844000e+03, 6.032000e+03, 5.339000e+03, 4.892000e+03, 4.289000e+03, 3.806000e+03, 3.305000e+03, 2.925000e+03, 2.391000e+03, 2.117000e+03, 1.806000e+03, 1.595000e+03, 1.309000e+03, 1.147000e+03, 9.200000e+02, 8.020000e+02, 6.500000e+02, 5.510000e+02, 4.170000e+02, 3.330000e+02, 2.700000e+02, 2.200000e+02, 1.770000e+02, 1.190000e+02, 8.100000e+01, 7.800000e+01, 4.500000e+01, 3.500000e+01, 2.200000e+01, 2.000000e+01, 1.100000e+01, 9.000000e+00, 2.000000e+00, 2.000000e+00, 4.000000e+00, 0.000000e+00, 0.000000e+00, 2.000000e+00, 0.000000e+00, 0.000000e+00, 1.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 5.999400e+04, 6.027500e+04, 6.066000e+04, 6.093600e+04, 6.030200e+04, 6.104800e+04, 6.125100e+04, 6.082800e+04, 6.168200e+04, 6.315600e+04, 6.212400e+04, 6.139100e+04, 6.119700e+04, 5.974800e+04, 5.901500e+04, 5.795400e+04, 5.720800e+04, 5.563200e+04, 5.441500e+04, 5.292100e+04, 5.181700e+04, 5.011000e+04, 4.895300e+04, 4.751300e+04, 4.571600e+04, 4.454100e+04, 4.304500e+04, 4.158500e+04, 4.016600e+04, 3.898900e+04, 3.774800e+04, 3.607300e+04, 3.474700e+04, 3.354200e+04, 3.195800e+04, 3.087700e+04, 2.964800e+04, 2.824900e+04, 2.698100e+04, 2.608600e+04, 2.451300e+04, 2.366300e+04, 2.269900e+04, 2.145000e+04, 2.047500e+04, 1.899200e+04, 1.804500e+04, 1.699600e+04, 1.586600e+04, 1.475400e+04, 1.396300e+04, 1.304900e+04, 1.203700e+04, 1.108800e+04, 1.044900e+04, 9.375000e+03, 8.591000e+03, 7.935000e+03, 7.442000e+03, 6.757000e+03, 6.304000e+03, 5.468000e+03, 5.039000e+03, 4.594000e+03, 4.112000e+03, 3.529000e+03, 3.243000e+03, 2.810000e+03, 2.440000e+03, 2.158000e+03, 1.957000e+03, 1.649000e+03, 1.424000e+03, 1.185000e+03, 9.440000e+02, 9.430000e+02, 7.270000e+02, 6.380000e+02, 4.920000e+02, 4.180000e+02, 3.370000e+02, 2.710000e+02, 2.340000e+02, 1.940000e+02, 1.500000e+02, 1.240000e+02, 7.800000e+01, 5.900000e+01, 3.300000e+01, 2.700000e+01, 1.900000e+01, 2.200000e+01, 1.100000e+01, 9.000000e+00, 3.000000e+00, 1.000000e+00, 2.000000e+00, 0.000000e+00, 0.000000e+00, 1.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.528500e+04, 4.522200e+04, 4.535700e+04, 4.560700e+04, 4.558900e+04, 4.569600e+04, 4.584800e+04, 4.619700e+04, 4.647200e+04, 4.681500e+04, 4.648600e+04, 4.628800e+04, 4.546700e+04, 4.511500e+04, 4.424000e+04, 4.338200e+04, 4.229200e+04, 4.166200e+04, 4.064100e+04, 3.931700e+04, 3.830800e+04, 3.739800e+04, 3.649100e+04, 3.503600e+04, 3.393600e+04, 3.290100e+04, 3.176400e+04, 3.086700e+04, 2.983600e+04, 2.902200e+04, 2.779000e+04, 2.657700e+04, 2.561900e+04, 2.450900e+04, 2.368200e+04, 2.270900e+04, 2.170600e+04, 2.090400e+04, 1.996100e+04, 1.899900e+04, 1.793800e+04, 1.749000e+04, 1.641000e+04, 1.551200e+04, 1.486600e+04, 1.414800e+04, 1.335700e+04, 1.239700e+04, 1.142000e+04, 1.100800e+04, 1.028500e+04, 9.388000e+03, 8.662000e+03, 8.015000e+03, 7.387000e+03, 6.835000e+03, 6.298000e+03, 5.870000e+03, 5.202000e+03, 4.909000e+03, 4.384000e+03, 3.996000e+03, 3.433000e+03, 3.141000e+03, 2.894000e+03, 2.543000e+03, 2.346000e+03, 2.033000e+03, 1.747000e+03, 1.515000e+03, 1.385000e+03, 1.176000e+03, 1.012000e+03, 8.470000e+02, 7.390000e+02, 6.100000e+02, 5.110000e+02, 4.470000e+02, 3.300000e+02, 2.910000e+02, 2.420000e+02, 1.580000e+02, 1.510000e+02, 1.230000e+02, 9.500000e+01, 7.800000e+01, 5.100000e+01, 3.200000e+01, 2.600000e+01, 1.500000e+01, 1.700000e+01, 9.000000e+00, 3.000000e+00, 5.000000e+00, 3.000000e+00, 4.000000e+00, 3.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.540800e+04, 3.566600e+04, 3.591200e+04, 3.587100e+04, 3.604300e+04, 3.600900e+04, 3.610500e+04, 3.576600e+04, 3.582800e+04, 3.618600e+04, 3.579200e+04, 3.525200e+04, 3.561100e+04, 3.480400e+04, 3.414400e+04, 3.380300e+04, 3.281300e+04, 3.243600e+04, 3.164600e+04, 3.078700e+04, 2.977800e+04, 2.906900e+04, 2.831900e+04, 2.729600e+04, 2.659400e+04, 2.552500e+04, 2.438300e+04, 2.369700e+04, 2.273500e+04, 2.180200e+04, 2.121900e+04, 2.038800e+04, 1.982000e+04, 1.885700e+04, 1.795600e+04, 1.747800e+04, 1.659900e+04, 1.595000e+04, 1.520500e+04, 1.457900e+04, 1.396900e+04, 1.314600e+04, 1.258200e+04, 1.187900e+04, 1.130800e+04, 1.070500e+04, 9.992000e+03, 9.478000e+03, 8.760000e+03, 8.177000e+03, 7.575000e+03, 7.214000e+03, 6.553000e+03, 6.072000e+03, 5.706000e+03, 5.147000e+03, 4.751000e+03, 4.328000e+03, 3.938000e+03, 3.551000e+03, 3.189000e+03, 2.908000e+03, 2.571000e+03, 2.353000e+03, 2.147000e+03, 1.839000e+03, 1.668000e+03, 1.427000e+03, 1.307000e+03, 1.058000e+03, 9.430000e+02, 8.240000e+02, 7.090000e+02, 5.920000e+02, 4.680000e+02, 4.270000e+02, 3.940000e+02, 3.130000e+02, 2.410000e+02, 1.930000e+02, 1.720000e+02, 1.380000e+02, 1.120000e+02, 7.100000e+01, 7.100000e+01, 5.200000e+01, 3.500000e+01, 3.400000e+01, 1.800000e+01, 1.100000e+01, 1.400000e+01, 6.000000e+00, 4.000000e+00, 1.000000e+00, 2.000000e+00, 0.000000e+00, 2.000000e+00, 3.000000e+00, 0.000000e+00, 1.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.850500e+04, 2.848800e+04, 2.882200e+04, 2.905500e+04, 2.892300e+04, 2.867500e+04, 2.857300e+04, 2.873200e+04, 2.900000e+04, 2.889500e+04, 2.875800e+04, 2.824100e+04, 2.847000e+04, 2.795600e+04, 2.754200e+04, 2.666200e+04, 2.639800e+04, 2.597400e+04, 2.489700e+04, 2.458000e+04, 2.406200e+04, 2.318300e+04, 2.248700e+04, 2.166600e+04, 2.111900e+04, 2.035000e+04, 1.951300e+04, 1.881000e+04, 1.827200e+04, 1.740000e+04, 1.694800e+04, 1.601300e+04, 1.553300e+04, 1.462000e+04, 1.401200e+04, 1.384600e+04, 1.322900e+04, 1.252700e+04, 1.182300e+04, 1.146700e+04, 1.080600e+04, 1.027400e+04, 9.990000e+03, 9.294000e+03, 8.913000e+03, 8.425000e+03, 7.862000e+03, 7.274000e+03, 6.802000e+03, 6.423000e+03, 5.979000e+03, 5.477000e+03, 5.068000e+03, 4.603000e+03, 4.244000e+03, 3.900000e+03, 3.585000e+03, 3.422000e+03, 2.984000e+03, 2.850000e+03, 2.466000e+03, 2.130000e+03, 1.984000e+03, 1.784000e+03, 1.583000e+03, 1.395000e+03, 1.313000e+03, 1.088000e+03, 9.790000e+02, 8.250000e+02, 7.950000e+02, 6.190000e+02, 5.300000e+02, 4.640000e+02, 3.980000e+02, 3.200000e+02, 2.740000e+02, 2.320000e+02, 1.860000e+02, 1.540000e+02, 1.430000e+02, 1.130000e+02, 8.400000e+01, 6.400000e+01, 4.000000e+01, 4.100000e+01, 2.900000e+01, 2.400000e+01, 1.300000e+01, 1.600000e+01, 1.300000e+01, 5.000000e+00, 6.000000e+00, 1.000000e+00, 3.000000e+00, 0.000000e+00, 0.000000e+00, 1.000000e+00, 0.000000e+00, 0.000000e+00, 1.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.359100e+04, 2.355500e+04, 2.361300e+04, 2.384200e+04, 2.366400e+04, 2.369700e+04, 2.335600e+04, 2.342000e+04, 2.327200e+04, 2.323400e+04, 2.332800e+04, 2.315700e+04, 2.334200e+04, 2.241600e+04, 2.257000e+04, 2.190500e+04, 2.167800e+04, 2.146100e+04, 2.053700e+04, 1.990000e+04, 1.950500e+04, 1.891900e+04, 1.821500e+04, 1.781900e+04, 1.684000e+04, 1.638200e+04, 1.612800e+04, 1.515600e+04, 1.463200e+04, 1.444600e+04, 1.364100e+04, 1.310800e+04, 1.243700e+04, 1.201800e+04, 1.138000e+04, 1.108400e+04, 1.044600e+04, 1.020900e+04, 9.738000e+03, 9.239000e+03, 8.829000e+03, 8.220000e+03, 7.712000e+03, 7.571000e+03, 7.052000e+03, 6.742000e+03, 6.327000e+03, 5.701000e+03, 5.477000e+03, 5.118000e+03, 4.628000e+03, 4.314000e+03, 3.989000e+03, 3.688000e+03, 3.386000e+03, 3.027000e+03, 2.807000e+03, 2.619000e+03, 2.388000e+03, 2.122000e+03, 1.917000e+03, 1.708000e+03, 1.594000e+03, 1.409000e+03, 1.204000e+03, 1.087000e+03, 9.480000e+02, 8.500000e+02, 7.630000e+02, 6.170000e+02, 5.440000e+02, 4.910000e+02, 4.070000e+02, 3.410000e+02, 2.840000e+02, 2.410000e+02, 1.980000e+02, 1.730000e+02, 1.450000e+02, 1.290000e+02, 8.300000e+01, 7.500000e+01, 6.300000e+01, 4.600000e+01, 4.500000e+01, 3.100000e+01, 1.700000e+01, 1.200000e+01, 8.000000e+00, 4.000000e+00, 8.000000e+00, 4.000000e+00, 3.000000e+00, 3.000000e+00, 1.000000e+00, 1.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.971400e+04, 1.974367e+04, 1.981140e+04, 1.980486e+04, 1.977043e+04, 1.971857e+04, 1.970857e+04, 1.962986e+04, 1.953029e+04, 1.943900e+04, 1.931271e+04, 1.920657e+04, 1.906757e+04, 1.885986e+04, 1.860557e+04, 1.827186e+04, 1.792443e+04, 1.756186e+04, 1.713457e+04, 1.665043e+04, 1.615614e+04, 1.569029e+04, 1.518671e+04, 1.465857e+04, 1.410886e+04, 1.358000e+04, 1.307143e+04, 1.258357e+04, 1.208214e+04, 1.164957e+04, 1.117300e+04, 1.074986e+04, 1.032186e+04, 9.883714e+03, 9.471857e+03, 9.058286e+03, 8.655857e+03, 8.291857e+03, 7.903429e+03, 7.546143e+03, 7.168571e+03, 6.798286e+03, 6.435286e+03, 6.096000e+03, 5.736143e+03, 5.382857e+03, 5.022000e+03, 4.711286e+03, 4.392714e+03, 4.102143e+03, 3.784857e+03, 3.503857e+03, 3.244286e+03, 3.002143e+03, 2.754143e+03, 2.526000e+03, 2.297286e+03, 2.091714e+03, 1.906000e+03, 1.720429e+03, 1.543714e+03, 1.389857e+03, 1.254429e+03, 1.117143e+03, 9.880000e+02, 8.721429e+02, 7.711429e+02, 6.811429e+02, 5.912857e+02, 5.085714e+02, 4.421429e+02, 3.888571e+02, 3.390000e+02, 2.860000e+02, 2.395714e+02, 2.048571e+02, 1.695714e+02, 1.385714e+02, 1.131429e+02, 8.871429e+01, 7.114286e+01, 5.657143e+01, 4.300000e+01, 3.357143e+01, 2.714286e+01, 2.014286e+01, 1.528571e+01, 1.214286e+01, 9.428571e+00, 8.142857e+00, 5.857143e+00, 3.714286e+00, 2.571429e+00, 2.000000e+00, 1.000000e+00, 2.857143e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.685700e+04, 1.678000e+04, 1.678020e+04, 1.676543e+04, 1.676543e+04, 1.677229e+04, 1.672014e+04, 1.666857e+04, 1.659543e+04, 1.646271e+04, 1.639343e+04, 1.620800e+04, 1.603000e+04, 1.587386e+04, 1.562129e+04, 1.535614e+04, 1.507014e+04, 1.469257e+04, 1.431629e+04, 1.390229e+04, 1.344929e+04, 1.305243e+04, 1.261657e+04, 1.218171e+04, 1.176171e+04, 1.136671e+04, 1.095686e+04, 1.054329e+04, 1.011943e+04, 9.737143e+03, 9.351857e+03, 8.951143e+03, 8.578429e+03, 8.223286e+03, 7.892714e+03, 7.564000e+03, 7.225000e+03, 6.909000e+03, 6.592714e+03, 6.262571e+03, 5.924714e+03, 5.603571e+03, 5.303429e+03, 4.999000e+03, 4.703857e+03, 4.432143e+03, 4.166000e+03, 3.912857e+03, 3.647571e+03, 3.380143e+03, 3.133000e+03, 2.907571e+03, 2.688000e+03, 2.472286e+03, 2.280429e+03, 2.089286e+03, 1.904143e+03, 1.734286e+03, 1.563143e+03, 1.406000e+03, 1.260714e+03, 1.127000e+03, 1.007571e+03, 9.054286e+02, 8.005714e+02, 7.171429e+02, 6.277143e+02, 5.537143e+02, 4.857143e+02, 4.190000e+02, 3.571429e+02, 3.094286e+02, 2.562857e+02, 2.171429e+02, 1.862857e+02, 1.527143e+02, 1.282857e+02, 1.080000e+02, 8.671429e+01, 7.214286e+01, 5.800000e+01, 4.385714e+01, 3.400000e+01, 2.700000e+01, 2.100000e+01, 1.614286e+01, 1.171429e+01, 1.000000e+01, 7.857143e+00, 5.857143e+00, 3.571429e+00, 1.571429e+00, 1.285714e+00, 8.571429e-01, 7.142857e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.444500e+04, 1.449467e+04, 1.441740e+04, 1.436157e+04, 1.434386e+04, 1.428486e+04, 1.423314e+04, 1.413443e+04, 1.407657e+04, 1.399029e+04, 1.388371e+04, 1.374543e+04, 1.357714e+04, 1.341686e+04, 1.321114e+04, 1.300014e+04, 1.275514e+04, 1.249729e+04, 1.219029e+04, 1.188686e+04, 1.150757e+04, 1.117229e+04, 1.080157e+04, 1.042886e+04, 1.004657e+04, 9.674571e+03, 9.308714e+03, 8.947286e+03, 8.611714e+03, 8.270143e+03, 7.919714e+03, 7.587571e+03, 7.262857e+03, 6.939714e+03, 6.633571e+03, 6.333571e+03, 6.043429e+03, 5.756143e+03, 5.505571e+03, 5.244429e+03, 4.971429e+03, 4.720714e+03, 4.450429e+03, 4.197000e+03, 3.945429e+03, 3.699714e+03, 3.461714e+03, 3.249571e+03, 3.010714e+03, 2.804000e+03, 2.598857e+03, 2.404429e+03, 2.200143e+03, 2.019143e+03, 1.856000e+03, 1.711714e+03, 1.554571e+03, 1.410286e+03, 1.292571e+03, 1.166571e+03, 1.046143e+03, 9.322857e+02, 8.288571e+02, 7.457143e+02, 6.622857e+02, 5.704286e+02, 5.078571e+02, 4.464286e+02, 3.887143e+02, 3.371429e+02, 2.880000e+02, 2.448571e+02, 2.121429e+02, 1.780000e+02, 1.460000e+02, 1.205714e+02, 1.028571e+02, 8.614286e+01, 6.957143e+01, 5.571429e+01, 4.457143e+01, 3.700000e+01, 2.800000e+01, 2.157143e+01, 1.585714e+01, 1.257143e+01, 9.714286e+00, 6.857143e+00, 4.714286e+00, 3.857143e+00, 2.428571e+00, 1.857143e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.267600e+04, 1.265200e+04, 1.256200e+04, 1.253714e+04, 1.249043e+04, 1.245614e+04, 1.236757e+04, 1.229729e+04, 1.224729e+04, 1.216771e+04, 1.202800e+04, 1.192243e+04, 1.178971e+04, 1.163814e+04, 1.144329e+04, 1.123214e+04, 1.100929e+04, 1.077743e+04, 1.047871e+04, 1.015729e+04, 9.863143e+03, 9.548429e+03, 9.244429e+03, 8.874571e+03, 8.542143e+03, 8.246714e+03, 7.931143e+03, 7.621429e+03, 7.304000e+03, 7.035857e+03, 6.765857e+03, 6.490571e+03, 6.196143e+03, 5.918714e+03, 5.645571e+03, 5.425571e+03, 5.122857e+03, 4.883000e+03, 4.638000e+03, 4.389143e+03, 4.165143e+03, 3.966571e+03, 3.729714e+03, 3.520286e+03, 3.318286e+03, 3.116286e+03, 2.928429e+03, 2.732571e+03, 2.534857e+03, 2.343429e+03, 2.178714e+03, 1.999714e+03, 1.834000e+03, 1.675143e+03, 1.537714e+03, 1.396143e+03, 1.276714e+03, 1.157571e+03, 1.048714e+03, 9.428571e+02, 8.521429e+02, 7.570000e+02, 6.738571e+02, 6.002857e+02, 5.341429e+02, 4.692857e+02, 4.154286e+02, 3.610000e+02, 3.131429e+02, 2.675714e+02, 2.272857e+02, 1.851429e+02, 1.582857e+02, 1.334286e+02, 1.135714e+02, 9.485714e+01, 7.800000e+01, 6.142857e+01, 5.000000e+01, 3.800000e+01, 3.000000e+01, 2.271429e+01, 1.771429e+01, 1.414286e+01, 1.128571e+01, 8.714286e+00, 6.857143e+00, 5.142857e+00, 3.000000e+00, 2.285714e+00, 1.571429e+00, 8.571429e-01, 1.000000e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.110200e+04, 1.107167e+04, 1.097740e+04, 1.093057e+04, 1.086986e+04, 1.078529e+04, 1.070643e+04, 1.063729e+04, 1.057786e+04, 1.047814e+04, 1.039886e+04, 1.032300e+04, 1.019071e+04, 1.006314e+04, 9.908286e+03, 9.733429e+03, 9.536286e+03, 9.309143e+03, 9.042286e+03, 8.804857e+03, 8.543143e+03, 8.302429e+03, 8.009857e+03, 7.728286e+03, 7.417857e+03, 7.136429e+03, 6.875714e+03, 6.589857e+03, 6.290286e+03, 6.003429e+03, 5.756714e+03, 5.502000e+03, 5.242857e+03, 4.986429e+03, 4.775714e+03, 4.546714e+03, 4.347857e+03, 4.134571e+03, 3.936857e+03, 3.754000e+03, 3.573714e+03, 3.382143e+03, 3.214714e+03, 3.027429e+03, 2.844714e+03, 2.664000e+03, 2.484429e+03, 2.302286e+03, 2.130286e+03, 1.957000e+03, 1.813143e+03, 1.673000e+03, 1.550429e+03, 1.419429e+03, 1.303286e+03, 1.175714e+03, 1.077000e+03, 9.720000e+02, 8.724286e+02, 7.768571e+02, 6.975714e+02, 6.191429e+02, 5.597143e+02, 4.904286e+02, 4.341429e+02, 3.800000e+02, 3.308571e+02, 2.845714e+02, 2.462857e+02, 2.104286e+02, 1.767143e+02, 1.488571e+02, 1.262857e+02, 1.118571e+02, 9.628571e+01, 7.985714e+01, 6.400000e+01, 5.300000e+01, 4.242857e+01, 3.385714e+01, 2.542857e+01, 1.885714e+01, 1.428571e+01, 1.100000e+01, 7.857143e+00, 5.714286e+00, 3.857143e+00, 2.571429e+00, 1.714286e+00, 1.142857e+00, 7.142857e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 9.795000e+03, 9.779333e+03, 9.691800e+03, 9.628286e+03, 9.549143e+03, 9.498857e+03, 9.400714e+03, 9.330143e+03, 9.252571e+03, 9.174714e+03, 9.096571e+03, 9.029714e+03, 8.919857e+03, 8.813571e+03, 8.672857e+03, 8.507857e+03, 8.325286e+03, 8.143857e+03, 7.899571e+03, 7.676714e+03, 7.416143e+03, 7.193714e+03, 6.950286e+03, 6.687286e+03, 6.429714e+03, 6.202714e+03, 5.950000e+03, 5.719571e+03, 5.459000e+03, 5.243286e+03, 5.017143e+03, 4.783429e+03, 4.570571e+03, 4.355571e+03, 4.159429e+03, 3.969714e+03, 3.787143e+03, 3.605143e+03, 3.444571e+03, 3.275857e+03, 3.102857e+03, 2.947143e+03, 2.784143e+03, 2.615714e+03, 2.460571e+03, 2.292857e+03, 2.133000e+03, 1.987857e+03, 1.832857e+03, 1.695429e+03, 1.557714e+03, 1.431143e+03, 1.315857e+03, 1.194857e+03, 1.091286e+03, 9.898571e+02, 8.940000e+02, 8.067143e+02, 7.258571e+02, 6.451429e+02, 5.824286e+02, 5.154286e+02, 4.608571e+02, 4.067143e+02, 3.554286e+02, 3.112857e+02, 2.744286e+02, 2.418571e+02, 2.104286e+02, 1.795714e+02, 1.530000e+02, 1.321429e+02, 1.110000e+02, 9.242857e+01, 7.400000e+01, 6.014286e+01, 4.885714e+01, 4.057143e+01, 3.371429e+01, 2.628571e+01, 2.014286e+01, 1.514286e+01, 1.242857e+01, 9.571429e+00, 7.285714e+00, 4.285714e+00, 3.000000e+00, 2.285714e+00, 1.571429e+00, 7.142857e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 8.649000e+03, 8.668000e+03, 8.593400e+03, 8.536857e+03, 8.487429e+03, 8.409286e+03, 8.350857e+03, 8.295714e+03, 8.217429e+03, 8.138714e+03, 8.039000e+03, 7.955857e+03, 7.872429e+03, 7.753000e+03, 7.620000e+03, 7.482714e+03, 7.322000e+03, 7.165571e+03, 6.975286e+03, 6.763286e+03, 6.539000e+03, 6.297857e+03, 6.086857e+03, 5.874571e+03, 5.647000e+03, 5.400143e+03, 5.187429e+03, 4.983857e+03, 4.794571e+03, 4.559714e+03, 4.342286e+03, 4.135714e+03, 3.955714e+03, 3.758000e+03, 3.576571e+03, 3.400000e+03, 3.242000e+03, 3.079143e+03, 2.920571e+03, 2.775143e+03, 2.624857e+03, 2.463000e+03, 2.326857e+03, 2.186000e+03, 2.053429e+03, 1.931571e+03, 1.791143e+03, 1.665429e+03, 1.545000e+03, 1.425571e+03, 1.313429e+03, 1.209714e+03, 1.097857e+03, 1.003000e+03, 9.144286e+02, 8.345714e+02, 7.512857e+02, 6.815714e+02, 6.084286e+02, 5.491429e+02, 4.897143e+02, 4.345714e+02, 3.860000e+02, 3.441429e+02, 3.001429e+02, 2.664286e+02, 2.292857e+02, 2.024286e+02, 1.778571e+02, 1.501429e+02, 1.267143e+02, 1.082857e+02, 9.028571e+01, 7.700000e+01, 6.171429e+01, 5.157143e+01, 4.271429e+01, 3.600000e+01, 2.742857e+01, 2.057143e+01, 1.557143e+01, 1.300000e+01, 9.142857e+00, 7.142857e+00, 4.428571e+00, 3.571429e+00, 2.857143e+00, 2.571429e+00, 1.857143e+00, 1.714286e+00, 1.285714e+00, 1.285714e+00, 7.142857e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 7.788000e+03, 7.710333e+03, 7.677200e+03, 7.621571e+03, 7.563429e+03, 7.500286e+03, 7.442857e+03, 7.352000e+03, 7.269571e+03, 7.169571e+03, 7.096143e+03, 7.002429e+03, 6.905571e+03, 6.789143e+03, 6.677143e+03, 6.563000e+03, 6.447429e+03, 6.303429e+03, 6.144429e+03, 5.985857e+03, 5.796571e+03, 5.620714e+03, 5.419286e+03, 5.212000e+03, 5.009857e+03, 4.794571e+03, 4.589714e+03, 4.398857e+03, 4.193571e+03, 4.010286e+03, 3.820286e+03, 3.615000e+03, 3.451000e+03, 3.283143e+03, 3.130286e+03, 2.991143e+03, 2.826143e+03, 2.692286e+03, 2.569857e+03, 2.445714e+03, 2.307286e+03, 2.157429e+03, 2.030857e+03, 1.918857e+03, 1.789286e+03, 1.669429e+03, 1.538857e+03, 1.432714e+03, 1.350000e+03, 1.240143e+03, 1.134857e+03, 1.047286e+03, 9.568571e+02, 8.760000e+02, 7.928571e+02, 7.100000e+02, 6.448571e+02, 5.818571e+02, 5.160000e+02, 4.590000e+02, 4.085714e+02, 3.667143e+02, 3.265714e+02, 2.882857e+02, 2.524286e+02, 2.180000e+02, 1.915714e+02, 1.685714e+02, 1.420000e+02, 1.200000e+02, 9.685714e+01, 8.042857e+01, 7.000000e+01, 5.700000e+01, 4.628571e+01, 3.828571e+01, 2.957143e+01, 2.500000e+01, 1.800000e+01, 1.357143e+01, 1.071429e+01, 9.000000e+00, 7.000000e+00, 6.142857e+00, 4.857143e+00, 3.571429e+00, 2.714286e+00, 1.714286e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.937000e+03, 6.870000e+03, 6.801000e+03, 6.760286e+03, 6.703286e+03, 6.635571e+03, 6.584143e+03, 6.527714e+03, 6.458000e+03, 6.349857e+03, 6.288571e+03, 6.207286e+03, 6.133857e+03, 6.027000e+03, 5.954571e+03, 5.846000e+03, 5.744143e+03, 5.571000e+03, 5.431143e+03, 5.283143e+03, 5.144000e+03, 4.967571e+03, 4.766857e+03, 4.593571e+03, 4.453714e+03, 4.274857e+03, 4.086286e+03, 3.898000e+03, 3.733143e+03, 3.583429e+03, 3.404429e+03, 3.239857e+03, 3.083143e+03, 2.934714e+03, 2.782429e+03, 2.635143e+03, 2.507000e+03, 2.386857e+03, 2.269000e+03, 2.135714e+03, 1.999143e+03, 1.894286e+03, 1.774143e+03, 1.650714e+03, 1.537000e+03, 1.429000e+03, 1.335000e+03, 1.250571e+03, 1.154000e+03, 1.063857e+03, 9.828571e+02, 9.015714e+02, 8.238571e+02, 7.541429e+02, 6.844286e+02, 6.235714e+02, 5.638571e+02, 5.077143e+02, 4.535714e+02, 4.042857e+02, 3.577143e+02, 3.195714e+02, 2.771429e+02, 2.431429e+02, 2.137143e+02, 1.917143e+02, 1.658571e+02, 1.405714e+02, 1.198571e+02, 1.004286e+02, 8.171429e+01, 6.771429e+01, 5.471429e+01, 4.528571e+01, 3.871429e+01, 3.085714e+01, 2.700000e+01, 2.242857e+01, 1.642857e+01, 1.271429e+01, 9.000000e+00, 7.428571e+00, 6.142857e+00, 4.285714e+00, 2.857143e+00, 2.285714e+00, 1.285714e+00, 8.571429e-01, 5.714286e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.319000e+03, 6.190333e+03, 6.163800e+03, 6.110429e+03, 6.049571e+03, 6.025429e+03, 5.971286e+03, 5.907714e+03, 5.811857e+03, 5.746571e+03, 5.658143e+03, 5.584000e+03, 5.462429e+03, 5.364000e+03, 5.280714e+03, 5.203286e+03, 5.084857e+03, 4.963286e+03, 4.832143e+03, 4.721286e+03, 4.570143e+03, 4.393857e+03, 4.227286e+03, 4.085429e+03, 3.941571e+03, 3.794429e+03, 3.636429e+03, 3.495714e+03, 3.352143e+03, 3.209143e+03, 3.060286e+03, 2.904571e+03, 2.747571e+03, 2.599286e+03, 2.455286e+03, 2.325286e+03, 2.184429e+03, 2.059714e+03, 1.939857e+03, 1.829000e+03, 1.729571e+03, 1.633571e+03, 1.535857e+03, 1.452143e+03, 1.359000e+03, 1.264714e+03, 1.174857e+03, 1.087000e+03, 1.001429e+03, 9.167143e+02, 8.422857e+02, 7.732857e+02, 7.042857e+02, 6.307143e+02, 5.760000e+02, 5.112857e+02, 4.607143e+02, 4.105714e+02, 3.662857e+02, 3.302857e+02, 3.000000e+02, 2.621429e+02, 2.382857e+02, 2.105714e+02, 1.877143e+02, 1.594286e+02, 1.375714e+02, 1.181429e+02, 1.017143e+02, 8.357143e+01, 7.142857e+01, 5.700000e+01, 4.785714e+01, 4.000000e+01, 3.342857e+01, 2.800000e+01, 2.228571e+01, 1.771429e+01, 1.414286e+01, 1.214286e+01, 9.714286e+00, 8.142857e+00, 6.142857e+00, 5.428571e+00, 4.000000e+00, 3.142857e+00, 1.714286e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 5.626000e+03, 5.521333e+03, 5.520200e+03, 5.483429e+03, 5.432714e+03, 5.393143e+03, 5.356714e+03, 5.296714e+03, 5.205429e+03, 5.127714e+03, 5.039571e+03, 4.959714e+03, 4.881000e+03, 4.795000e+03, 4.716571e+03, 4.640429e+03, 4.543571e+03, 4.471714e+03, 4.365286e+03, 4.238000e+03, 4.120714e+03, 3.968143e+03, 3.841714e+03, 3.693143e+03, 3.523429e+03, 3.370714e+03, 3.230286e+03, 3.083000e+03, 2.943143e+03, 2.783429e+03, 2.649000e+03, 2.517714e+03, 2.383714e+03, 2.252143e+03, 2.117714e+03, 2.018429e+03, 1.905000e+03, 1.803571e+03, 1.711286e+03, 1.622143e+03, 1.535429e+03, 1.457714e+03, 1.357571e+03, 1.280857e+03, 1.199286e+03, 1.114857e+03, 1.036714e+03, 9.551429e+02, 8.691429e+02, 7.927143e+02, 7.220000e+02, 6.531429e+02, 5.918571e+02, 5.334286e+02, 4.820000e+02, 4.408571e+02, 3.998571e+02, 3.651429e+02, 3.240000e+02, 2.912857e+02, 2.587143e+02, 2.237143e+02, 1.954286e+02, 1.710000e+02, 1.430000e+02, 1.281429e+02, 1.067143e+02, 9.371429e+01, 8.271429e+01, 7.000000e+01, 5.814286e+01, 5.085714e+01, 4.085714e+01, 3.385714e+01, 2.671429e+01, 2.300000e+01, 1.642857e+01, 1.114286e+01, 9.428571e+00, 8.000000e+00, 5.857143e+00, 4.571429e+00, 3.428571e+00, 3.000000e+00, 2.142857e+00, 1.714286e+00, 1.000000e+00, 5.714286e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 5.179000e+03, 5.076333e+03, 5.050200e+03, 4.993143e+03, 4.928000e+03, 4.859571e+03, 4.822143e+03, 4.774286e+03, 4.690571e+03, 4.636571e+03, 4.562714e+03, 4.518000e+03, 4.468000e+03, 4.412286e+03, 4.312143e+03, 4.227571e+03, 4.118143e+03, 4.015857e+03, 3.890000e+03, 3.755571e+03, 3.606143e+03, 3.488571e+03, 3.376143e+03, 3.271143e+03, 3.141714e+03, 3.005857e+03, 2.877429e+03, 2.750000e+03, 2.613000e+03, 2.481429e+03, 2.359000e+03, 2.236000e+03, 2.127571e+03, 2.023714e+03, 1.917714e+03, 1.824857e+03, 1.735857e+03, 1.636143e+03, 1.540857e+03, 1.456000e+03, 1.368000e+03, 1.285571e+03, 1.198714e+03, 1.111286e+03, 1.034429e+03, 9.618571e+02, 8.942857e+02, 8.301429e+02, 7.700000e+02, 7.090000e+02, 6.498571e+02, 5.928571e+02, 5.480000e+02, 4.897143e+02, 4.374286e+02, 3.894286e+02, 3.487143e+02, 3.081429e+02, 2.747143e+02, 2.392857e+02, 2.104286e+02, 1.848571e+02, 1.610000e+02, 1.397143e+02, 1.265714e+02, 1.067143e+02, 9.428571e+01, 8.000000e+01, 6.900000e+01, 5.728571e+01, 4.700000e+01, 3.871429e+01, 3.257143e+01, 2.300000e+01, 1.785714e+01, 1.471429e+01, 1.228571e+01, 8.714286e+00, 6.714286e+00, 4.857143e+00, 4.000000e+00, 3.142857e+00, 2.285714e+00, 1.571429e+00, 1.714286e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.683000e+03, 4.627000e+03, 4.597600e+03, 4.526143e+03, 4.464429e+03, 4.430000e+03, 4.377286e+03, 4.319571e+03, 4.254143e+03, 4.196714e+03, 4.126857e+03, 4.060714e+03, 3.986429e+03, 3.934571e+03, 3.860000e+03, 3.778714e+03, 3.692714e+03, 3.615714e+03, 3.526286e+03, 3.419571e+03, 3.281286e+03, 3.153286e+03, 3.027714e+03, 2.908714e+03, 2.785286e+03, 2.677143e+03, 2.554286e+03, 2.433714e+03, 2.318714e+03, 2.220286e+03, 2.113000e+03, 2.004286e+03, 1.894000e+03, 1.793857e+03, 1.705857e+03, 1.619143e+03, 1.532429e+03, 1.449143e+03, 1.377857e+03, 1.293429e+03, 1.207714e+03, 1.131571e+03, 1.059714e+03, 9.801429e+02, 8.997143e+02, 8.282857e+02, 7.637143e+02, 7.151429e+02, 6.542857e+02, 5.981429e+02, 5.440000e+02, 5.034286e+02, 4.562857e+02, 4.147143e+02, 3.717143e+02, 3.317143e+02, 2.962857e+02, 2.655714e+02, 2.344286e+02, 2.058571e+02, 1.774286e+02, 1.531429e+02, 1.375714e+02, 1.212857e+02, 1.048571e+02, 8.957143e+01, 7.928571e+01, 7.000000e+01, 5.728571e+01, 4.585714e+01, 3.671429e+01, 3.128571e+01, 2.557143e+01, 2.085714e+01, 1.757143e+01, 1.542857e+01, 1.342857e+01, 1.057143e+01, 8.000000e+00, 5.857143e+00, 4.428571e+00, 2.857143e+00, 1.714286e+00, 1.285714e+00, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.204000e+03, 4.180000e+03, 4.124600e+03, 4.068857e+03, 4.018571e+03, 3.961714e+03, 3.912714e+03, 3.871571e+03, 3.816714e+03, 3.764857e+03, 3.703571e+03, 3.644000e+03, 3.594286e+03, 3.538714e+03, 3.461143e+03, 3.374714e+03, 3.303571e+03, 3.222714e+03, 3.139429e+03, 3.030429e+03, 2.910571e+03, 2.815000e+03, 2.728571e+03, 2.635143e+03, 2.524429e+03, 2.402286e+03, 2.299857e+03, 2.184571e+03, 2.071714e+03, 1.963286e+03, 1.850143e+03, 1.750857e+03, 1.663571e+03, 1.583429e+03, 1.500286e+03, 1.416571e+03, 1.338000e+03, 1.250143e+03, 1.195000e+03, 1.127571e+03, 1.053143e+03, 9.955714e+02, 9.362857e+02, 8.702857e+02, 8.154286e+02, 7.481429e+02, 6.948571e+02, 6.407143e+02, 5.858571e+02, 5.361429e+02, 4.901429e+02, 4.484286e+02, 4.025714e+02, 3.605714e+02, 3.270000e+02, 2.924286e+02, 2.601429e+02, 2.314286e+02, 2.004286e+02, 1.782857e+02, 1.564286e+02, 1.337143e+02, 1.140000e+02, 9.985714e+01, 8.371429e+01, 7.228571e+01, 6.128571e+01, 5.271429e+01, 4.728571e+01, 4.142857e+01, 3.357143e+01, 2.842857e+01, 2.314286e+01, 1.828571e+01, 1.428571e+01, 1.028571e+01, 7.857143e+00, 6.428571e+00, 4.571429e+00, 3.714286e+00, 2.285714e+00, 1.428571e+00, 1.000000e+00, 1.000000e+00, 4.285714e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.973000e+03, 3.851667e+03, 3.801200e+03, 3.744000e+03, 3.681286e+03, 3.641571e+03, 3.585143e+03, 3.536429e+03, 3.478143e+03, 3.431143e+03, 3.371286e+03, 3.316857e+03, 3.253571e+03, 3.194714e+03, 3.127000e+03, 3.057571e+03, 2.987571e+03, 2.913143e+03, 2.823857e+03, 2.730571e+03, 2.653143e+03, 2.571714e+03, 2.482429e+03, 2.386429e+03, 2.287286e+03, 2.191571e+03, 2.101857e+03, 1.990000e+03, 1.887714e+03, 1.790571e+03, 1.690286e+03, 1.603143e+03, 1.516286e+03, 1.433286e+03, 1.347286e+03, 1.267857e+03, 1.195000e+03, 1.119286e+03, 1.051571e+03, 9.954286e+02, 9.357143e+02, 8.844286e+02, 8.264286e+02, 7.711429e+02, 7.171429e+02, 6.680000e+02, 6.082857e+02, 5.552857e+02, 5.072857e+02, 4.568571e+02, 4.118571e+02, 3.798571e+02, 3.431429e+02, 3.100000e+02, 2.750000e+02, 2.465714e+02, 2.224286e+02, 1.927143e+02, 1.652857e+02, 1.431429e+02, 1.237143e+02, 1.097143e+02, 9.557143e+01, 8.485714e+01, 7.485714e+01, 6.385714e+01, 5.428571e+01, 4.742857e+01, 4.071429e+01, 3.342857e+01, 2.614286e+01, 2.214286e+01, 1.957143e+01, 1.471429e+01, 1.200000e+01, 8.857143e+00, 6.285714e+00, 5.000000e+00, 3.142857e+00, 2.142857e+00, 1.285714e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.543000e+03, 3.496667e+03, 3.467600e+03, 3.420143e+03, 3.360143e+03, 3.310429e+03, 3.251714e+03, 3.196143e+03, 3.141714e+03, 3.065714e+03, 3.026571e+03, 2.990000e+03, 2.934714e+03, 2.883000e+03, 2.824000e+03, 2.754857e+03, 2.717000e+03, 2.648286e+03, 2.564857e+03, 2.486857e+03, 2.417000e+03, 2.345000e+03, 2.263714e+03, 2.160571e+03, 2.040857e+03, 1.955000e+03, 1.861571e+03, 1.765571e+03, 1.662429e+03, 1.578857e+03, 1.494571e+03, 1.431571e+03, 1.354000e+03, 1.278000e+03, 1.198429e+03, 1.128857e+03, 1.062857e+03, 1.006571e+03, 9.450000e+02, 8.804286e+02, 8.232857e+02, 7.765714e+02, 7.270000e+02, 6.757143e+02, 6.191429e+02, 5.692857e+02, 5.297143e+02, 4.875714e+02, 4.428571e+02, 3.997143e+02, 3.560000e+02, 3.185714e+02, 2.858571e+02, 2.508571e+02, 2.237143e+02, 1.987143e+02, 1.748571e+02, 1.552857e+02, 1.404286e+02, 1.222857e+02, 1.095714e+02, 9.528571e+01, 8.442857e+01, 7.700000e+01, 6.585714e+01, 5.957143e+01, 5.128571e+01, 4.414286e+01, 3.785714e+01, 3.185714e+01, 2.500000e+01, 1.971429e+01, 1.442857e+01, 1.271429e+01, 1.000000e+01, 8.285714e+00, 7.142857e+00, 5.571429e+00, 5.000000e+00, 4.000000e+00, 2.857143e+00, 1.857143e+00, 1.428571e+00, 8.571429e-01, 7.142857e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.195000e+03, 3.207667e+03, 3.205800e+03, 3.160571e+03, 3.130429e+03, 3.077000e+03, 3.026429e+03, 2.964000e+03, 2.884143e+03, 2.833000e+03, 2.775286e+03, 2.716286e+03, 2.660571e+03, 2.611857e+03, 2.571857e+03, 2.531286e+03, 2.464857e+03, 2.393714e+03, 2.326143e+03, 2.260571e+03, 2.186714e+03, 2.094143e+03, 2.004143e+03, 1.926429e+03, 1.859429e+03, 1.760857e+03, 1.675429e+03, 1.598714e+03, 1.525571e+03, 1.449000e+03, 1.373714e+03, 1.294143e+03, 1.240143e+03, 1.167000e+03, 1.091857e+03, 1.025857e+03, 9.610000e+02, 8.914286e+02, 8.292857e+02, 7.705714e+02, 7.230000e+02, 6.727143e+02, 6.262857e+02, 5.805714e+02, 5.398571e+02, 4.962857e+02, 4.560000e+02, 4.122857e+02, 3.822857e+02, 3.441429e+02, 3.132857e+02, 2.768571e+02, 2.541429e+02, 2.277143e+02, 2.020000e+02, 1.728571e+02, 1.527143e+02, 1.302857e+02, 1.177143e+02, 1.011429e+02, 8.828571e+01, 7.771429e+01, 6.857143e+01, 5.871429e+01, 5.128571e+01, 4.400000e+01, 3.785714e+01, 3.085714e+01, 2.571429e+01, 2.100000e+01, 1.957143e+01, 1.728571e+01, 1.500000e+01, 1.200000e+01, 1.014286e+01, 8.714286e+00, 6.571429e+00, 4.000000e+00, 2.428571e+00, 1.571429e+00, 1.142857e+00, 1.142857e+00, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.086000e+03, 3.002667e+03, 2.929400e+03, 2.870714e+03, 2.823429e+03, 2.766000e+03, 2.714571e+03, 2.674571e+03, 2.632571e+03, 2.585286e+03, 2.543143e+03, 2.484286e+03, 2.441714e+03, 2.400429e+03, 2.344143e+03, 2.285286e+03, 2.228286e+03, 2.165143e+03, 2.107286e+03, 2.035143e+03, 1.977857e+03, 1.898714e+03, 1.830429e+03, 1.749714e+03, 1.682143e+03, 1.599429e+03, 1.514429e+03, 1.424857e+03, 1.354286e+03, 1.275857e+03, 1.203571e+03, 1.130286e+03, 1.061286e+03, 1.004857e+03, 9.454286e+02, 8.817143e+02, 8.320000e+02, 7.840000e+02, 7.385714e+02, 6.897143e+02, 6.482857e+02, 6.008571e+02, 5.654286e+02, 5.232857e+02, 4.840000e+02, 4.454286e+02, 4.125714e+02, 3.765714e+02, 3.482857e+02, 3.148571e+02, 2.885714e+02, 2.602857e+02, 2.301429e+02, 2.050000e+02, 1.812857e+02, 1.580000e+02, 1.382857e+02, 1.220000e+02, 1.074286e+02, 9.757143e+01, 8.628571e+01, 7.400000e+01, 6.314286e+01, 5.385714e+01, 4.528571e+01, 3.857143e+01, 3.014286e+01, 2.514286e+01, 2.085714e+01, 1.700000e+01, 1.414286e+01, 1.114286e+01, 8.714286e+00, 6.571429e+00, 4.571429e+00, 3.714286e+00, 2.714286e+00, 2.428571e+00, 1.571429e+00, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.753000e+03, 2.737667e+03, 2.669600e+03, 2.634429e+03, 2.604429e+03, 2.549000e+03, 2.507571e+03, 2.471286e+03, 2.433000e+03, 2.386571e+03, 2.339000e+03, 2.275857e+03, 2.229857e+03, 2.161286e+03, 2.118000e+03, 2.077143e+03, 2.015429e+03, 1.963429e+03, 1.920714e+03, 1.863286e+03, 1.817143e+03, 1.747286e+03, 1.672286e+03, 1.616857e+03, 1.544571e+03, 1.469857e+03, 1.403286e+03, 1.321857e+03, 1.248286e+03, 1.173000e+03, 1.090429e+03, 1.024571e+03, 9.541429e+02, 8.961429e+02, 8.522857e+02, 8.022857e+02, 7.514286e+02, 7.135714e+02, 6.660000e+02, 6.257143e+02, 5.818571e+02, 5.397143e+02, 4.985714e+02, 4.655714e+02, 4.305714e+02, 3.968571e+02, 3.660000e+02, 3.304286e+02, 3.002857e+02, 2.734286e+02, 2.457143e+02, 2.225714e+02, 2.011429e+02, 1.755714e+02, 1.592857e+02, 1.408571e+02, 1.242857e+02, 1.105714e+02, 9.114286e+01, 7.785714e+01, 6.814286e+01, 5.671429e+01, 4.742857e+01, 3.942857e+01, 3.085714e+01, 2.714286e+01, 2.242857e+01, 1.785714e+01, 1.471429e+01, 1.200000e+01, 1.028571e+01, 9.000000e+00, 7.142857e+00, 6.000000e+00, 5.142857e+00, 4.428571e+00, 3.857143e+00, 2.714286e+00, 2.428571e+00, 2.285714e+00, 1.857143e+00, 1.428571e+00, 1.142857e+00, 5.714286e-01, 5.714286e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.489000e+03, 2.549000e+03, 2.499200e+03, 2.472000e+03, 2.435143e+03, 2.382571e+03, 2.320714e+03, 2.282571e+03, 2.230429e+03, 2.175286e+03, 2.126857e+03, 2.092571e+03, 2.038571e+03, 1.998429e+03, 1.957429e+03, 1.909000e+03, 1.853571e+03, 1.795429e+03, 1.735714e+03, 1.681286e+03, 1.640143e+03, 1.560571e+03, 1.496143e+03, 1.440286e+03, 1.378000e+03, 1.317857e+03, 1.254000e+03, 1.173571e+03, 1.121714e+03, 1.070857e+03, 1.013000e+03, 9.478571e+02, 8.842857e+02, 8.275714e+02, 7.745714e+02, 7.205714e+02, 6.665714e+02, 6.131429e+02, 5.781429e+02, 5.441429e+02, 5.112857e+02, 4.815714e+02, 4.502857e+02, 4.181429e+02, 3.908571e+02, 3.555714e+02, 3.220000e+02, 2.872857e+02, 2.581429e+02, 2.350000e+02, 2.087143e+02, 1.887143e+02, 1.708571e+02, 1.505714e+02, 1.372857e+02, 1.205714e+02, 1.047143e+02, 8.971429e+01, 7.500000e+01, 6.414286e+01, 5.657143e+01, 5.014286e+01, 4.314286e+01, 3.757143e+01, 3.400000e+01, 3.100000e+01, 2.485714e+01, 2.100000e+01, 1.528571e+01, 1.285714e+01, 9.857143e+00, 8.142857e+00, 5.428571e+00, 4.000000e+00, 2.285714e+00, 2.428571e+00, 2.142857e+00, 1.857143e+00, 1.428571e+00, 1.000000e+00, 5.714286e-01, 5.714286e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.321000e+03, 2.305667e+03, 2.252800e+03, 2.224143e+03, 2.196857e+03, 2.156714e+03, 2.106429e+03, 2.074571e+03, 2.052857e+03, 2.010286e+03, 1.971857e+03, 1.936571e+03, 1.903429e+03, 1.865571e+03, 1.812429e+03, 1.754571e+03, 1.706857e+03, 1.658571e+03, 1.597000e+03, 1.544857e+03, 1.492000e+03, 1.438429e+03, 1.381000e+03, 1.330143e+03, 1.262429e+03, 1.197286e+03, 1.132571e+03, 1.079143e+03, 1.026429e+03, 9.732857e+02, 9.057143e+02, 8.570000e+02, 8.061429e+02, 7.571429e+02, 6.927143e+02, 6.431429e+02, 6.021429e+02, 5.641429e+02, 5.287143e+02, 4.945714e+02, 4.598571e+02, 4.365714e+02, 4.095714e+02, 3.790000e+02, 3.530000e+02, 3.237143e+02, 2.977143e+02, 2.751429e+02, 2.502857e+02, 2.255714e+02, 1.982857e+02, 1.767143e+02, 1.532857e+02, 1.347143e+02, 1.144286e+02, 1.001429e+02, 8.442857e+01, 7.428571e+01, 6.228571e+01, 5.557143e+01, 4.785714e+01, 4.314286e+01, 3.685714e+01, 3.285714e+01, 2.857143e+01, 2.542857e+01, 2.142857e+01, 1.742857e+01, 1.357143e+01, 1.071429e+01, 8.000000e+00, 5.571429e+00, 4.000000e+00, 2.714286e+00, 2.000000e+00, 1.571429e+00, 1.142857e+00, 1.000000e+00, 1.142857e+00, 8.571429e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.087000e+03, 2.101667e+03, 2.083600e+03, 2.038571e+03, 2.020143e+03, 1.989000e+03, 1.947143e+03, 1.909143e+03, 1.881429e+03, 1.855286e+03, 1.816857e+03, 1.767286e+03, 1.724000e+03, 1.677429e+03, 1.633286e+03, 1.586143e+03, 1.539571e+03, 1.491857e+03, 1.452714e+03, 1.408429e+03, 1.371571e+03, 1.319143e+03, 1.268286e+03, 1.218714e+03, 1.161571e+03, 1.097571e+03, 1.039286e+03, 9.787143e+02, 9.178571e+02, 8.610000e+02, 8.068571e+02, 7.545714e+02, 7.097143e+02, 6.604286e+02, 6.171429e+02, 5.822857e+02, 5.404286e+02, 5.067143e+02, 4.730000e+02, 4.400000e+02, 4.058571e+02, 3.764286e+02, 3.445714e+02, 3.198571e+02, 2.971429e+02, 2.724286e+02, 2.490000e+02, 2.302857e+02, 2.085714e+02, 1.857143e+02, 1.647143e+02, 1.434286e+02, 1.275714e+02, 1.137143e+02, 9.942857e+01, 8.671429e+01, 7.671429e+01, 6.542857e+01, 5.700000e+01, 4.900000e+01, 4.071429e+01, 3.571429e+01, 3.128571e+01, 2.685714e+01, 2.400000e+01, 2.042857e+01, 1.700000e+01, 1.442857e+01, 1.142857e+01, 9.285714e+00, 6.714286e+00, 5.714286e+00, 4.142857e+00, 3.000000e+00, 2.000000e+00, 1.142857e+00, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.051000e+03, 2.017667e+03, 1.991400e+03, 1.945571e+03, 1.909571e+03, 1.872714e+03, 1.834286e+03, 1.795286e+03, 1.748429e+03, 1.719143e+03, 1.670143e+03, 1.623286e+03, 1.571000e+03, 1.524143e+03, 1.477571e+03, 1.435857e+03, 1.384571e+03, 1.344429e+03, 1.300143e+03, 1.277429e+03, 1.234143e+03, 1.183571e+03, 1.129429e+03, 1.092571e+03, 1.050000e+03, 1.002857e+03, 9.398571e+02, 8.880000e+02, 8.411429e+02, 7.960000e+02, 7.397143e+02, 6.885714e+02, 6.410000e+02, 5.928571e+02, 5.525714e+02, 5.154286e+02, 4.770000e+02, 4.430000e+02, 4.107143e+02, 3.832857e+02, 3.645714e+02, 3.450000e+02, 3.168571e+02, 3.004286e+02, 2.775714e+02, 2.534286e+02, 2.348571e+02, 2.052857e+02, 1.817143e+02, 1.658571e+02, 1.434286e+02, 1.301429e+02, 1.138571e+02, 9.442857e+01, 8.528571e+01, 7.185714e+01, 6.057143e+01, 5.428571e+01, 4.528571e+01, 3.857143e+01, 3.514286e+01, 3.014286e+01, 2.657143e+01, 2.414286e+01, 1.942857e+01, 1.542857e+01, 1.300000e+01, 1.171429e+01, 8.285714e+00, 6.857143e+00, 5.142857e+00, 3.571429e+00, 2.857143e+00, 2.142857e+00, 1.142857e+00, 8.571429e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.858000e+03, 1.865333e+03, 1.814600e+03, 1.776714e+03, 1.741714e+03, 1.707714e+03, 1.666286e+03, 1.653143e+03, 1.611857e+03, 1.576429e+03, 1.538571e+03, 1.505857e+03, 1.466286e+03, 1.437571e+03, 1.385571e+03, 1.347143e+03, 1.314429e+03, 1.277571e+03, 1.241143e+03, 1.203000e+03, 1.154143e+03, 1.110143e+03, 1.065714e+03, 1.021714e+03, 9.668571e+02, 9.148571e+02, 8.562857e+02, 8.101429e+02, 7.692857e+02, 7.261429e+02, 6.722857e+02, 6.311429e+02, 5.927143e+02, 5.547143e+02, 5.094286e+02, 4.710000e+02, 4.344286e+02, 4.068571e+02, 3.774286e+02, 3.462857e+02, 3.204286e+02, 2.994286e+02, 2.735714e+02, 2.525714e+02, 2.352857e+02, 2.132857e+02, 1.921429e+02, 1.750000e+02, 1.564286e+02, 1.391429e+02, 1.195714e+02, 9.957143e+01, 8.771429e+01, 7.457143e+01, 6.257143e+01, 5.257143e+01, 4.642857e+01, 4.057143e+01, 3.600000e+01, 3.085714e+01, 2.842857e+01, 2.414286e+01, 1.985714e+01, 1.600000e+01, 1.428571e+01, 1.271429e+01, 9.857143e+00, 7.571429e+00, 7.571429e+00, 7.000000e+00, 6.000000e+00, 4.142857e+00, 3.142857e+00, 2.571429e+00, 1.857143e+00, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.684000e+03, 1.694333e+03, 1.647000e+03, 1.626000e+03, 1.601714e+03, 1.578857e+03, 1.542857e+03, 1.513857e+03, 1.491000e+03, 1.453000e+03, 1.417571e+03, 1.384714e+03, 1.337571e+03, 1.303429e+03, 1.267571e+03, 1.228286e+03, 1.196714e+03, 1.164000e+03, 1.122429e+03, 1.092429e+03, 1.048571e+03, 1.018429e+03, 9.768571e+02, 9.312857e+02, 8.804286e+02, 8.315714e+02, 7.854286e+02, 7.454286e+02, 6.975714e+02, 6.474286e+02, 6.068571e+02, 5.671429e+02, 5.325714e+02, 4.911429e+02, 4.488571e+02, 4.161429e+02, 3.890000e+02, 3.574286e+02, 3.312857e+02, 3.031429e+02, 2.804286e+02, 2.597143e+02, 2.398571e+02, 2.191429e+02, 2.020000e+02, 1.808571e+02, 1.671429e+02, 1.495714e+02, 1.351429e+02, 1.177143e+02, 1.045714e+02, 9.200000e+01, 8.200000e+01, 7.242857e+01, 6.514286e+01, 5.742857e+01, 4.842857e+01, 4.128571e+01, 3.442857e+01, 2.885714e+01, 2.457143e+01, 2.014286e+01, 1.628571e+01, 1.471429e+01, 1.214286e+01, 1.042857e+01, 9.000000e+00, 6.714286e+00, 5.714286e+00, 3.857143e+00, 2.571429e+00, 2.285714e+00, 1.857143e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 1.142857e+00, 1.000000e+00, 4.285714e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.600000e+03, 1.613667e+03, 1.566200e+03, 1.528429e+03, 1.494571e+03, 1.462857e+03, 1.411571e+03, 1.380714e+03, 1.340714e+03, 1.312286e+03, 1.276286e+03, 1.248571e+03, 1.223286e+03, 1.186571e+03, 1.158571e+03, 1.130143e+03, 1.099571e+03, 1.062571e+03, 1.019429e+03, 9.721429e+02, 9.404286e+02, 8.978571e+02, 8.687143e+02, 8.302857e+02, 7.907143e+02, 7.512857e+02, 7.150000e+02, 6.747143e+02, 6.320000e+02, 5.832857e+02, 5.424286e+02, 5.012857e+02, 4.731429e+02, 4.434286e+02, 4.127143e+02, 3.902857e+02, 3.668571e+02, 3.400000e+02, 3.212857e+02, 2.940000e+02, 2.732857e+02, 2.498571e+02, 2.264286e+02, 2.007143e+02, 1.821429e+02, 1.625714e+02, 1.521429e+02, 1.338571e+02, 1.195714e+02, 1.060000e+02, 9.442857e+01, 8.371429e+01, 7.400000e+01, 6.071429e+01, 5.114286e+01, 4.528571e+01, 3.928571e+01, 3.528571e+01, 2.914286e+01, 2.585714e+01, 2.185714e+01, 1.785714e+01, 1.342857e+01, 1.042857e+01, 7.857143e+00, 6.571429e+00, 4.857143e+00, 3.857143e+00, 3.285714e+00, 2.714286e+00, 2.571429e+00, 2.000000e+00, 1.428571e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.512000e+03, 1.498000e+03, 1.465000e+03, 1.437429e+03, 1.413857e+03, 1.389571e+03, 1.344286e+03, 1.313143e+03, 1.270429e+03, 1.238286e+03, 1.193143e+03, 1.157429e+03, 1.118143e+03, 1.092286e+03, 1.054571e+03, 1.029000e+03, 9.971429e+02, 9.750000e+02, 9.374286e+02, 9.075714e+02, 8.665714e+02, 8.370000e+02, 8.035714e+02, 7.647143e+02, 7.308571e+02, 6.915714e+02, 6.537143e+02, 6.257143e+02, 5.825714e+02, 5.520000e+02, 5.152857e+02, 4.741429e+02, 4.408571e+02, 4.085714e+02, 3.751429e+02, 3.470000e+02, 3.167143e+02, 2.945714e+02, 2.700000e+02, 2.518571e+02, 2.310000e+02, 2.060000e+02, 1.852857e+02, 1.707143e+02, 1.535714e+02, 1.408571e+02, 1.264286e+02, 1.145714e+02, 1.055714e+02, 9.728571e+01, 8.642857e+01, 7.714286e+01, 6.857143e+01, 5.842857e+01, 4.957143e+01, 4.228571e+01, 3.785714e+01, 2.957143e+01, 2.371429e+01, 1.771429e+01, 1.571429e+01, 1.328571e+01, 1.171429e+01, 9.142857e+00, 8.000000e+00, 6.571429e+00, 5.857143e+00, 4.571429e+00, 3.428571e+00, 2.714286e+00, 2.000000e+00, 1.571429e+00, 1.285714e+00, 8.571429e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.422000e+03, 1.327000e+03, 1.321000e+03, 1.299286e+03, 1.267000e+03, 1.246857e+03, 1.228286e+03, 1.197429e+03, 1.169429e+03, 1.139143e+03, 1.107429e+03, 1.083143e+03, 1.053571e+03, 1.023143e+03, 9.855714e+02, 9.611429e+02, 9.382857e+02, 9.054286e+02, 8.664286e+02, 8.275714e+02, 7.934286e+02, 7.658571e+02, 7.234286e+02, 6.904286e+02, 6.530000e+02, 6.197143e+02, 5.948571e+02, 5.574286e+02, 5.174286e+02, 4.855714e+02, 4.457143e+02, 4.188571e+02, 3.844286e+02, 3.524286e+02, 3.328571e+02, 3.122857e+02, 2.894286e+02, 2.660000e+02, 2.438571e+02, 2.241429e+02, 2.045714e+02, 1.870000e+02, 1.697143e+02, 1.524286e+02, 1.342857e+02, 1.211429e+02, 1.101429e+02, 9.714286e+01, 8.414286e+01, 7.271429e+01, 6.542857e+01, 5.985714e+01, 5.185714e+01, 4.600000e+01, 4.157143e+01, 3.514286e+01, 2.942857e+01, 2.400000e+01, 1.900000e+01, 1.528571e+01, 1.328571e+01, 1.042857e+01, 9.142857e+00, 7.428571e+00, 5.857143e+00, 5.000000e+00, 4.428571e+00, 3.857143e+00, 2.857143e+00, 2.000000e+00, 1.571429e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.300000e+03, 1.273000e+03, 1.237400e+03, 1.217286e+03, 1.188571e+03, 1.167714e+03, 1.127714e+03, 1.095714e+03, 1.070571e+03, 1.034286e+03, 1.001286e+03, 9.737143e+02, 9.590000e+02, 9.278571e+02, 9.080000e+02, 8.810000e+02, 8.577143e+02, 8.317143e+02, 7.977143e+02, 7.601429e+02, 7.287143e+02, 6.905714e+02, 6.617143e+02, 6.247143e+02, 5.874286e+02, 5.577143e+02, 5.287143e+02, 4.971429e+02, 4.707143e+02, 4.427143e+02, 4.167143e+02, 3.917143e+02, 3.635714e+02, 3.307143e+02, 3.025714e+02, 2.770000e+02, 2.492857e+02, 2.280000e+02, 2.065714e+02, 1.887143e+02, 1.774286e+02, 1.654286e+02, 1.497143e+02, 1.334286e+02, 1.205714e+02, 1.087143e+02, 9.885714e+01, 8.628571e+01, 7.457143e+01, 6.585714e+01, 5.828571e+01, 5.071429e+01, 4.385714e+01, 3.857143e+01, 3.300000e+01, 2.885714e+01, 2.300000e+01, 2.042857e+01, 1.742857e+01, 1.528571e+01, 1.128571e+01, 9.000000e+00, 7.428571e+00, 6.000000e+00, 4.714286e+00, 3.428571e+00, 2.714286e+00, 2.142857e+00, 2.142857e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.213000e+03, 1.156000e+03, 1.153200e+03, 1.135714e+03, 1.108429e+03, 1.092143e+03, 1.071571e+03, 1.035571e+03, 1.004429e+03, 9.824286e+02, 9.474286e+02, 9.178571e+02, 8.764286e+02, 8.472857e+02, 8.237143e+02, 7.994286e+02, 7.662857e+02, 7.307143e+02, 7.048571e+02, 6.882857e+02, 6.665714e+02, 6.385714e+02, 6.027143e+02, 5.714286e+02, 5.528571e+02, 5.201429e+02, 4.860000e+02, 4.502857e+02, 4.165714e+02, 3.918571e+02, 3.670000e+02, 3.401429e+02, 3.178571e+02, 2.931429e+02, 2.680000e+02, 2.497143e+02, 2.298571e+02, 2.047143e+02, 1.862857e+02, 1.725714e+02, 1.578571e+02, 1.475714e+02, 1.364286e+02, 1.247143e+02, 1.141429e+02, 1.021429e+02, 8.957143e+01, 7.985714e+01, 7.071429e+01, 6.000000e+01, 5.285714e+01, 4.742857e+01, 4.228571e+01, 3.585714e+01, 3.200000e+01, 2.700000e+01, 2.142857e+01, 1.742857e+01, 1.371429e+01, 1.114286e+01, 8.857143e+00, 6.571429e+00, 5.571429e+00, 5.142857e+00, 3.285714e+00, 2.571429e+00, 1.714286e+00, 1.285714e+00, 8.571429e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.135000e+03, 1.111333e+03, 1.087000e+03, 1.054000e+03, 1.026429e+03, 1.004000e+03, 9.751429e+02, 9.437143e+02, 9.145714e+02, 8.914286e+02, 8.650000e+02, 8.287143e+02, 8.035714e+02, 7.697143e+02, 7.508571e+02, 7.191429e+02, 6.930000e+02, 6.627143e+02, 6.502857e+02, 6.212857e+02, 5.988571e+02, 5.711429e+02, 5.504286e+02, 5.322857e+02, 5.084286e+02, 4.767143e+02, 4.492857e+02, 4.187143e+02, 3.902857e+02, 3.654286e+02, 3.342857e+02, 3.077143e+02, 2.864286e+02, 2.662857e+02, 2.468571e+02, 2.272857e+02, 2.020000e+02, 1.824286e+02, 1.665714e+02, 1.491429e+02, 1.355714e+02, 1.234286e+02, 1.120000e+02, 1.050000e+02, 9.471429e+01, 8.585714e+01, 7.828571e+01, 6.928571e+01, 6.114286e+01, 5.271429e+01, 4.600000e+01, 4.028571e+01, 3.500000e+01, 2.942857e+01, 2.500000e+01, 2.100000e+01, 1.814286e+01, 1.557143e+01, 1.300000e+01, 1.071429e+01, 9.285714e+00, 7.571429e+00, 6.285714e+00, 4.714286e+00, 3.714286e+00, 3.428571e+00, 2.285714e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.052000e+03, 1.020667e+03, 9.850000e+02, 9.681429e+02, 9.437143e+02, 9.158571e+02, 8.964286e+02, 8.801429e+02, 8.585714e+02, 8.345714e+02, 8.105714e+02, 7.835714e+02, 7.595714e+02, 7.401429e+02, 7.074286e+02, 6.825714e+02, 6.514286e+02, 6.217143e+02, 6.001429e+02, 5.825714e+02, 5.442857e+02, 5.247143e+02, 5.027143e+02, 4.864286e+02, 4.601429e+02, 4.328571e+02, 4.021429e+02, 3.824286e+02, 3.595714e+02, 3.357143e+02, 3.057143e+02, 2.845714e+02, 2.625714e+02, 2.425714e+02, 2.210000e+02, 1.982857e+02, 1.800000e+02, 1.662857e+02, 1.505714e+02, 1.357143e+02, 1.202857e+02, 1.077143e+02, 9.842857e+01, 8.957143e+01, 8.128571e+01, 7.357143e+01, 6.657143e+01, 6.071429e+01, 5.457143e+01, 4.714286e+01, 3.957143e+01, 3.142857e+01, 2.785714e+01, 2.514286e+01, 2.228571e+01, 1.928571e+01, 1.657143e+01, 1.285714e+01, 1.214286e+01, 9.428571e+00, 6.571429e+00, 5.571429e+00, 4.571429e+00, 4.000000e+00, 3.285714e+00, 2.571429e+00, 1.857143e+00, 1.285714e+00, 1.142857e+00, 7.142857e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 9.420000e+02, 9.593333e+02, 9.330000e+02, 9.112857e+02, 8.970000e+02, 8.727143e+02, 8.488571e+02, 8.245714e+02, 8.025714e+02, 7.842857e+02, 7.547143e+02, 7.264286e+02, 7.020000e+02, 6.715714e+02, 6.450000e+02, 6.187143e+02, 5.942857e+02, 5.707143e+02, 5.474286e+02, 5.251429e+02, 5.042857e+02, 4.831429e+02, 4.617143e+02, 4.321429e+02, 4.078571e+02, 3.822857e+02, 3.557143e+02, 3.355714e+02, 3.102857e+02, 2.884286e+02, 2.671429e+02, 2.480000e+02, 2.301429e+02, 2.074286e+02, 1.867143e+02, 1.745714e+02, 1.564286e+02, 1.418571e+02, 1.290000e+02, 1.154286e+02, 1.070000e+02, 9.871429e+01, 8.642857e+01, 7.785714e+01, 7.200000e+01, 6.557143e+01, 5.942857e+01, 5.414286e+01, 4.642857e+01, 4.128571e+01, 3.800000e+01, 3.285714e+01, 2.842857e+01, 2.400000e+01, 1.928571e+01, 1.700000e+01, 1.414286e+01, 1.100000e+01, 8.857143e+00, 6.428571e+00, 5.571429e+00, 3.857143e+00, 2.142857e+00, 1.571429e+00, 1.571429e+00, 1.142857e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 9.020000e+02, 8.796667e+02, 8.742000e+02, 8.552857e+02, 8.342857e+02, 8.170000e+02, 7.968571e+02, 7.614286e+02, 7.341429e+02, 7.120000e+02, 6.898571e+02, 6.660000e+02, 6.405714e+02, 6.131429e+02, 6.090000e+02, 5.805714e+02, 5.578571e+02, 5.328571e+02, 5.141429e+02, 4.910000e+02, 4.742857e+02, 4.418571e+02, 4.271429e+02, 4.045714e+02, 3.778571e+02, 3.571429e+02, 3.321429e+02, 3.091429e+02, 2.924286e+02, 2.684286e+02, 2.498571e+02, 2.317143e+02, 2.074286e+02, 1.894286e+02, 1.742857e+02, 1.561429e+02, 1.428571e+02, 1.268571e+02, 1.165714e+02, 1.082857e+02, 9.985714e+01, 9.085714e+01, 8.071429e+01, 7.214286e+01, 6.528571e+01, 5.571429e+01, 4.842857e+01, 4.271429e+01, 3.814286e+01, 3.457143e+01, 2.985714e+01, 2.585714e+01, 2.314286e+01, 1.971429e+01, 1.642857e+01, 1.214286e+01, 9.428571e+00, 7.285714e+00, 6.142857e+00, 4.285714e+00, 3.285714e+00, 2.142857e+00, 1.857143e+00, 1.571429e+00, 1.285714e+00, 8.571429e-01, 8.571429e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 8.840000e+02, 8.453333e+02, 8.128000e+02, 7.942857e+02, 7.678571e+02, 7.445714e+02, 7.245714e+02, 7.010000e+02, 6.810000e+02, 6.484286e+02, 6.295714e+02, 6.062857e+02, 5.788571e+02, 5.558571e+02, 5.448571e+02, 5.224286e+02, 5.105714e+02, 4.874286e+02, 4.694286e+02, 4.550000e+02, 4.352857e+02, 4.135714e+02, 3.935714e+02, 3.692857e+02, 3.420000e+02, 3.182857e+02, 2.938571e+02, 2.740000e+02, 2.514286e+02, 2.311429e+02, 2.185714e+02, 2.055714e+02, 1.907143e+02, 1.781429e+02, 1.665714e+02, 1.524286e+02, 1.430000e+02, 1.288571e+02, 1.202857e+02, 1.105714e+02, 9.885714e+01, 8.757143e+01, 7.914286e+01, 6.771429e+01, 5.857143e+01, 5.042857e+01, 4.500000e+01, 3.914286e+01, 3.485714e+01, 2.985714e+01, 2.657143e+01, 2.371429e+01, 1.985714e+01, 1.657143e+01, 1.471429e+01, 1.285714e+01, 1.114286e+01, 8.428571e+00, 7.000000e+00, 6.142857e+00, 4.857143e+00, 3.857143e+00, 2.428571e+00, 2.285714e+00, 2.285714e+00, 1.857143e+00, 1.142857e+00, 8.571429e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 7.810000e+02, 7.596667e+02, 7.446000e+02, 7.307143e+02, 7.124286e+02, 6.917143e+02, 6.720000e+02, 6.465714e+02, 6.210000e+02, 5.935714e+02, 5.770000e+02, 5.562857e+02, 5.392857e+02, 5.251429e+02, 5.070000e+02, 4.932857e+02, 4.717143e+02, 4.508571e+02, 4.311429e+02, 4.134286e+02, 3.910000e+02, 3.754286e+02, 3.568571e+02, 3.430000e+02, 3.222857e+02, 3.032857e+02, 2.770000e+02, 2.590000e+02, 2.415714e+02, 2.220000e+02, 2.022857e+02, 1.872857e+02, 1.692857e+02, 1.571429e+02, 1.431429e+02, 1.285714e+02, 1.158571e+02, 1.047143e+02, 9.457143e+01, 8.785714e+01, 7.900000e+01, 7.000000e+01, 6.357143e+01, 5.628571e+01, 4.857143e+01, 4.171429e+01, 3.585714e+01, 3.085714e+01, 2.614286e+01, 2.300000e+01, 1.985714e+01, 1.757143e+01, 1.485714e+01, 1.200000e+01, 1.085714e+01, 9.714286e+00, 7.000000e+00, 5.428571e+00, 4.571429e+00, 4.000000e+00, 3.857143e+00, 3.000000e+00, 2.000000e+00, 1.428571e+00, 1.428571e+00, 1.142857e+00, 5.714286e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 7.560000e+02, 7.233333e+02, 7.140000e+02, 6.932857e+02, 6.682857e+02, 6.512857e+02, 6.328571e+02, 6.112857e+02, 5.890000e+02, 5.651429e+02, 5.501429e+02, 5.385714e+02, 5.148571e+02, 4.938571e+02, 4.724286e+02, 4.562857e+02, 4.410000e+02, 4.217143e+02, 4.024286e+02, 3.854286e+02, 3.695714e+02, 3.512857e+02, 3.324286e+02, 3.121429e+02, 2.917143e+02, 2.715714e+02, 2.541429e+02, 2.405714e+02, 2.202857e+02, 2.047143e+02, 1.842857e+02, 1.682857e+02, 1.522857e+02, 1.388571e+02, 1.218571e+02, 1.105714e+02, 9.928571e+01, 9.271429e+01, 8.314286e+01, 7.371429e+01, 6.442857e+01, 5.685714e+01, 4.985714e+01, 4.328571e+01, 3.742857e+01, 3.357143e+01, 3.000000e+01, 2.642857e+01, 2.357143e+01, 2.028571e+01, 1.657143e+01, 1.500000e+01, 1.185714e+01, 9.142857e+00, 7.857143e+00, 6.142857e+00, 4.857143e+00, 3.857143e+00, 3.000000e+00, 2.000000e+00, 1.857143e+00, 1.428571e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.790000e+02, 6.866667e+02, 6.584000e+02, 6.415714e+02, 6.265714e+02, 6.077143e+02, 5.771429e+02, 5.570000e+02, 5.460000e+02, 5.201429e+02, 5.011429e+02, 4.794286e+02, 4.611429e+02, 4.451429e+02, 4.254286e+02, 3.998571e+02, 3.817143e+02, 3.720000e+02, 3.577143e+02, 3.391429e+02, 3.275714e+02, 3.104286e+02, 2.938571e+02, 2.797143e+02, 2.585714e+02, 2.367143e+02, 2.248571e+02, 2.074286e+02, 1.988571e+02, 1.834286e+02, 1.670000e+02, 1.531429e+02, 1.418571e+02, 1.280000e+02, 1.157143e+02, 1.028571e+02, 9.428571e+01, 8.600000e+01, 7.671429e+01, 7.014286e+01, 6.028571e+01, 5.100000e+01, 4.357143e+01, 3.842857e+01, 3.342857e+01, 3.028571e+01, 2.642857e+01, 2.485714e+01, 2.285714e+01, 2.042857e+01, 1.885714e+01, 1.642857e+01, 1.328571e+01, 1.185714e+01, 9.857143e+00, 8.000000e+00, 6.285714e+00, 4.857143e+00, 3.714286e+00, 3.285714e+00, 2.285714e+00, 1.285714e+00, 8.571429e-01, 5.714286e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.470000e+02, 6.186667e+02, 6.014000e+02, 5.835714e+02, 5.687143e+02, 5.565714e+02, 5.321429e+02, 5.152857e+02, 5.061429e+02, 4.897143e+02, 4.734286e+02, 4.530000e+02, 4.322857e+02, 4.217143e+02, 4.017143e+02, 3.784286e+02, 3.585714e+02, 3.398571e+02, 3.257143e+02, 3.127143e+02, 2.922857e+02, 2.824286e+02, 2.634286e+02, 2.541429e+02, 2.391429e+02, 2.220000e+02, 2.074286e+02, 1.932857e+02, 1.774286e+02, 1.671429e+02, 1.490000e+02, 1.375714e+02, 1.234286e+02, 1.128571e+02, 1.035714e+02, 9.185714e+01, 8.157143e+01, 7.385714e+01, 6.571429e+01, 5.914286e+01, 5.257143e+01, 4.542857e+01, 3.757143e+01, 3.342857e+01, 2.914286e+01, 2.628571e+01, 2.242857e+01, 1.914286e+01, 1.600000e+01, 1.357143e+01, 1.085714e+01, 7.714286e+00, 6.142857e+00, 5.285714e+00, 4.000000e+00, 3.000000e+00, 2.714286e+00, 2.428571e+00, 2.285714e+00, 1.428571e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.240000e+02, 6.000000e+02, 5.816000e+02, 5.662857e+02, 5.411429e+02, 5.275714e+02, 5.092857e+02, 4.881429e+02, 4.697143e+02, 4.524286e+02, 4.345714e+02, 4.201429e+02, 3.988571e+02, 3.830000e+02, 3.627143e+02, 3.498571e+02, 3.290000e+02, 3.154286e+02, 3.007143e+02, 2.875714e+02, 2.717143e+02, 2.664286e+02, 2.512857e+02, 2.394286e+02, 2.267143e+02, 2.135714e+02, 2.010000e+02, 1.870000e+02, 1.701429e+02, 1.570000e+02, 1.400000e+02, 1.244286e+02, 1.131429e+02, 1.010000e+02, 9.042857e+01, 7.942857e+01, 6.957143e+01, 6.342857e+01, 5.771429e+01, 5.028571e+01, 4.285714e+01, 3.771429e+01, 3.414286e+01, 2.942857e+01, 2.642857e+01, 2.214286e+01, 2.057143e+01, 1.800000e+01, 1.657143e+01, 1.371429e+01, 1.214286e+01, 1.000000e+01, 8.571429e+00, 7.428571e+00, 6.285714e+00, 3.571429e+00, 3.000000e+00, 2.000000e+00, 1.571429e+00, 7.142857e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 5.900000e+02, 5.620000e+02, 5.450000e+02, 5.281429e+02, 5.050000e+02, 4.835714e+02, 4.651429e+02, 4.447143e+02, 4.234286e+02, 4.032857e+02, 3.837143e+02, 3.730000e+02, 3.650000e+02, 3.472857e+02, 3.338571e+02, 3.200000e+02, 3.054286e+02, 2.922857e+02, 2.725714e+02, 2.532857e+02, 2.444286e+02, 2.357143e+02, 2.231429e+02, 2.110000e+02, 1.987143e+02, 1.905714e+02, 1.797143e+02, 1.635714e+02, 1.477143e+02, 1.325714e+02, 1.192857e+02, 1.077143e+02, 9.657143e+01, 8.600000e+01, 7.600000e+01, 6.742857e+01, 6.385714e+01, 5.942857e+01, 5.314286e+01, 4.642857e+01, 4.157143e+01, 3.800000e+01, 3.357143e+01, 2.800000e+01, 2.485714e+01, 2.042857e+01, 1.742857e+01, 1.471429e+01, 1.285714e+01, 1.114286e+01, 9.428571e+00, 7.142857e+00, 6.857143e+00, 5.714286e+00, 4.857143e+00, 4.000000e+00, 3.428571e+00, 2.714286e+00, 2.142857e+00, 1.428571e+00, 8.571429e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 5.290000e+02, 5.040000e+02, 4.986000e+02, 4.847143e+02, 4.712857e+02, 4.525714e+02, 4.414286e+02, 4.245714e+02, 4.095714e+02, 3.957143e+02, 3.791429e+02, 3.582857e+02, 3.411429e+02, 3.254286e+02, 3.110000e+02, 2.937143e+02, 2.775714e+02, 2.635714e+02, 2.545714e+02, 2.470000e+02, 2.330000e+02, 2.155714e+02, 2.032857e+02, 1.915714e+02, 1.764286e+02, 1.624286e+02, 1.475714e+02, 1.378571e+02, 1.291429e+02, 1.187143e+02, 1.105714e+02, 9.928571e+01, 8.928571e+01, 8.057143e+01, 7.328571e+01, 6.542857e+01, 5.700000e+01, 4.800000e+01, 4.285714e+01, 3.928571e+01, 3.457143e+01, 2.928571e+01, 2.585714e+01, 2.285714e+01, 2.085714e+01, 1.857143e+01, 1.514286e+01, 1.271429e+01, 1.114286e+01, 9.000000e+00, 7.428571e+00, 6.428571e+00, 5.142857e+00, 4.000000e+00, 3.285714e+00, 2.571429e+00, 2.142857e+00, 1.571429e+00, 8.571429e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.770000e+02, 4.606667e+02, 4.492000e+02, 4.370000e+02, 4.268571e+02, 4.098571e+02, 4.008571e+02, 3.868571e+02, 3.708571e+02, 3.490000e+02, 3.340000e+02, 3.164286e+02, 3.024286e+02, 2.860000e+02, 2.700000e+02, 2.578571e+02, 2.477143e+02, 2.407143e+02, 2.242857e+02, 2.141429e+02, 2.050000e+02, 1.974286e+02, 1.887143e+02, 1.735714e+02, 1.610000e+02, 1.515714e+02, 1.392857e+02, 1.297143e+02, 1.147143e+02, 1.025714e+02, 9.514286e+01, 8.571429e+01, 7.900000e+01, 6.942857e+01, 5.942857e+01, 5.500000e+01, 4.814286e+01, 4.357143e+01, 3.700000e+01, 3.114286e+01, 2.700000e+01, 2.371429e+01, 1.971429e+01, 1.657143e+01, 1.428571e+01, 1.228571e+01, 1.142857e+01, 1.000000e+01, 8.571429e+00, 6.714286e+00, 5.571429e+00, 4.428571e+00, 4.000000e+00, 3.000000e+00, 2.428571e+00, 1.285714e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.640000e+02, 4.473333e+02, 4.252000e+02, 4.087143e+02, 3.881429e+02, 3.740000e+02, 3.610000e+02, 3.494286e+02, 3.340000e+02, 3.207143e+02, 3.137143e+02, 3.008571e+02, 2.881429e+02, 2.770000e+02, 2.635714e+02, 2.527143e+02, 2.360000e+02, 2.188571e+02, 2.114286e+02, 1.967143e+02, 1.810000e+02, 1.694286e+02, 1.578571e+02, 1.488571e+02, 1.408571e+02, 1.322857e+02, 1.227143e+02, 1.112857e+02, 1.032857e+02, 9.371429e+01, 8.471429e+01, 7.600000e+01, 6.742857e+01, 6.071429e+01, 5.600000e+01, 4.871429e+01, 4.500000e+01, 3.842857e+01, 3.500000e+01, 3.000000e+01, 2.628571e+01, 2.171429e+01, 1.857143e+01, 1.557143e+01, 1.385714e+01, 1.171429e+01, 9.142857e+00, 7.285714e+00, 6.285714e+00, 5.857143e+00, 5.000000e+00, 4.000000e+00, 3.142857e+00, 2.428571e+00, 2.142857e+00, 2.000000e+00, 8.571429e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.300000e+02, 4.183333e+02, 4.080000e+02, 3.988571e+02, 3.841429e+02, 3.667143e+02, 3.521429e+02, 3.300000e+02, 3.214286e+02, 3.031429e+02, 2.844286e+02, 2.717143e+02, 2.612857e+02, 2.567143e+02, 2.504286e+02, 2.350000e+02, 2.211429e+02, 2.101429e+02, 1.991429e+02, 1.868571e+02, 1.714286e+02, 1.557143e+02, 1.487143e+02, 1.412857e+02, 1.325714e+02, 1.255714e+02, 1.151429e+02, 1.045714e+02, 9.385714e+01, 8.328571e+01, 7.471429e+01, 6.671429e+01, 5.642857e+01, 5.171429e+01, 4.557143e+01, 4.285714e+01, 3.671429e+01, 3.242857e+01, 2.957143e+01, 2.585714e+01, 2.114286e+01, 1.885714e+01, 1.614286e+01, 1.485714e+01, 1.314286e+01, 1.057143e+01, 9.000000e+00, 7.000000e+00, 5.285714e+00, 4.285714e+00, 3.000000e+00, 2.142857e+00, 1.714286e+00, 1.428571e+00, 1.000000e+00, 8.571429e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.070000e+02, 3.810000e+02, 3.540000e+02, 3.440000e+02, 3.265714e+02, 3.160000e+02, 3.078571e+02, 3.024286e+02, 2.915714e+02, 2.837143e+02, 2.718571e+02, 2.584286e+02, 2.431429e+02, 2.300000e+02, 2.135714e+02, 2.022857e+02, 1.872857e+02, 1.734286e+02, 1.665714e+02, 1.578571e+02, 1.465714e+02, 1.398571e+02, 1.344286e+02, 1.305714e+02, 1.234286e+02, 1.167143e+02, 1.068571e+02, 9.942857e+01, 8.957143e+01, 8.142857e+01, 6.971429e+01, 6.228571e+01, 5.314286e+01, 4.857143e+01, 4.228571e+01, 3.728571e+01, 3.400000e+01, 3.157143e+01, 2.657143e+01, 2.285714e+01, 1.885714e+01, 1.571429e+01, 1.300000e+01, 1.042857e+01, 8.285714e+00, 6.857143e+00, 6.714286e+00, 5.714286e+00, 4.857143e+00, 4.714286e+00, 3.857143e+00, 2.857143e+00, 2.714286e+00, 2.000000e+00, 1.571429e+00, 1.428571e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.800000e+02, 3.596667e+02, 3.520000e+02, 3.354286e+02, 3.211429e+02, 3.078571e+02, 2.934286e+02, 2.798571e+02, 2.635714e+02, 2.481429e+02, 2.357143e+02, 2.218571e+02, 2.164286e+02, 2.068571e+02, 1.924286e+02, 1.825714e+02, 1.780000e+02, 1.700000e+02, 1.614286e+02, 1.490000e+02, 1.390000e+02, 1.315714e+02, 1.227143e+02, 1.122857e+02, 1.058571e+02, 9.785714e+01, 8.885714e+01, 8.328571e+01, 7.642857e+01, 7.071429e+01, 6.300000e+01, 5.571429e+01, 5.128571e+01, 4.485714e+01, 3.700000e+01, 3.314286e+01, 2.728571e+01, 2.257143e+01, 1.814286e+01, 1.442857e+01, 1.300000e+01, 1.157143e+01, 9.857143e+00, 8.857143e+00, 8.571429e+00, 7.857143e+00, 6.714286e+00, 4.571429e+00, 4.000000e+00, 3.142857e+00, 2.285714e+00, 1.571429e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.200000e+02, 3.243333e+02, 3.238000e+02, 3.160000e+02, 3.055714e+02, 2.935714e+02, 2.837143e+02, 2.687143e+02, 2.565714e+02, 2.402857e+02, 2.301429e+02, 2.250000e+02, 2.157143e+02, 2.011429e+02, 1.904286e+02, 1.787143e+02, 1.688571e+02, 1.611429e+02, 1.501429e+02, 1.362857e+02, 1.288571e+02, 1.195714e+02, 1.111429e+02, 1.024286e+02, 9.200000e+01, 8.357143e+01, 8.185714e+01, 7.585714e+01, 6.842857e+01, 6.171429e+01, 5.671429e+01, 5.071429e+01, 4.257143e+01, 3.600000e+01, 3.100000e+01, 2.700000e+01, 2.471429e+01, 1.985714e+01, 1.714286e+01, 1.571429e+01, 1.328571e+01, 1.257143e+01, 1.100000e+01, 9.285714e+00, 8.142857e+00, 7.714286e+00, 6.714286e+00, 5.142857e+00, 3.285714e+00, 2.714286e+00, 2.000000e+00, 1.285714e+00, 7.142857e-01, 5.714286e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.890000e+02, 2.916667e+02, 2.834000e+02, 2.797143e+02, 2.695714e+02, 2.640000e+02, 2.545714e+02, 2.431429e+02, 2.317143e+02, 2.214286e+02, 2.112857e+02, 2.047143e+02, 1.878571e+02, 1.797143e+02, 1.735714e+02, 1.662857e+02, 1.552857e+02, 1.404286e+02, 1.301429e+02, 1.204286e+02, 1.120000e+02, 1.010000e+02, 9.271429e+01, 8.614286e+01, 8.242857e+01, 7.785714e+01, 7.100000e+01, 6.714286e+01, 6.142857e+01, 5.457143e+01, 4.914286e+01, 4.314286e+01, 3.614286e+01, 3.257143e+01, 2.728571e+01, 2.457143e+01, 2.228571e+01, 1.800000e+01, 1.542857e+01, 1.400000e+01, 1.228571e+01, 9.000000e+00, 7.285714e+00, 5.714286e+00, 5.000000e+00, 4.000000e+00, 2.714286e+00, 2.571429e+00, 2.285714e+00, 1.428571e+00, 1.285714e+00, 8.571429e-01, 1.000000e+00, 1.000000e+00, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.090000e+02, 2.753333e+02, 2.622000e+02, 2.578571e+02, 2.505714e+02, 2.482857e+02, 2.414286e+02, 2.368571e+02, 2.264286e+02, 2.138571e+02, 2.031429e+02, 1.885714e+02, 1.770000e+02, 1.668571e+02, 1.565714e+02, 1.474286e+02, 1.412857e+02, 1.301429e+02, 1.221429e+02, 1.150000e+02, 1.061429e+02, 9.885714e+01, 9.314286e+01, 8.500000e+01, 8.014286e+01, 7.528571e+01, 6.942857e+01, 6.300000e+01, 5.671429e+01, 5.100000e+01, 4.785714e+01, 4.271429e+01, 3.685714e+01, 2.957143e+01, 2.600000e+01, 2.314286e+01, 1.985714e+01, 1.557143e+01, 1.385714e+01, 1.100000e+01, 1.042857e+01, 8.142857e+00, 6.428571e+00, 5.571429e+00, 5.000000e+00, 3.571429e+00, 3.285714e+00, 2.285714e+00, 2.428571e+00, 2.000000e+00, 1.428571e+00, 1.000000e+00, 8.571429e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.660000e+02, 2.590000e+02, 2.522000e+02, 2.455714e+02, 2.380000e+02, 2.261429e+02, 2.162857e+02, 2.095714e+02, 1.991429e+02, 1.861429e+02, 1.758571e+02, 1.638571e+02, 1.602857e+02, 1.512857e+02, 1.357143e+02, 1.294286e+02, 1.238571e+02, 1.185714e+02, 1.131429e+02, 1.004286e+02, 9.257143e+01, 9.028571e+01, 8.400000e+01, 7.728571e+01, 7.071429e+01, 6.500000e+01, 6.357143e+01, 6.014286e+01, 5.428571e+01, 5.028571e+01, 4.414286e+01, 3.742857e+01, 3.342857e+01, 2.828571e+01, 2.385714e+01, 2.000000e+01, 1.557143e+01, 1.328571e+01, 1.300000e+01, 1.042857e+01, 8.714286e+00, 8.000000e+00, 6.428571e+00, 5.142857e+00, 4.000000e+00, 3.000000e+00, 2.285714e+00, 2.000000e+00, 1.142857e+00, 1.000000e+00, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.800000e+02, 2.556667e+02, 2.456000e+02, 2.318571e+02, 2.197143e+02, 2.074286e+02, 1.944286e+02, 1.864286e+02, 1.734286e+02, 1.622857e+02, 1.577143e+02, 1.475714e+02, 1.432857e+02, 1.361429e+02, 1.260000e+02, 1.200000e+02, 1.157143e+02, 1.032857e+02, 9.585714e+01, 8.971429e+01, 8.171429e+01, 7.385714e+01, 6.857143e+01, 6.200000e+01, 5.614286e+01, 5.128571e+01, 4.614286e+01, 4.371429e+01, 4.000000e+01, 3.528571e+01, 3.085714e+01, 3.000000e+01, 2.728571e+01, 2.271429e+01, 1.971429e+01, 1.742857e+01, 1.471429e+01, 1.328571e+01, 1.028571e+01, 7.857143e+00, 6.428571e+00, 4.857143e+00, 4.000000e+00, 3.428571e+00, 2.142857e+00, 1.714286e+00, 1.714286e+00, 1.428571e+00, 1.142857e+00, 8.571429e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.540000e+02, 2.300000e+02, 2.204000e+02, 2.094286e+02, 1.957143e+02, 1.880000e+02, 1.787143e+02, 1.737143e+02, 1.607143e+02, 1.560000e+02, 1.474286e+02, 1.410000e+02, 1.338571e+02, 1.267143e+02, 1.158571e+02, 1.100000e+02, 9.914286e+01, 9.128571e+01, 8.557143e+01, 7.771429e+01, 7.342857e+01, 6.814286e+01, 6.385714e+01, 5.771429e+01, 5.357143e+01, 4.857143e+01, 4.514286e+01, 4.000000e+01, 3.542857e+01, 3.128571e+01, 3.000000e+01, 2.657143e+01, 2.257143e+01, 1.871429e+01, 1.614286e+01, 1.457143e+01, 1.142857e+01, 8.000000e+00, 6.714286e+00, 5.428571e+00, 3.714286e+00, 2.428571e+00, 1.857143e+00, 2.285714e+00, 2.142857e+00, 2.142857e+00, 2.142857e+00, 1.857143e+00, 1.285714e+00, 1.000000e+00, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.420000e+02, 2.070000e+02, 1.982000e+02, 1.875714e+02, 1.764286e+02, 1.725714e+02, 1.647143e+02, 1.552857e+02, 1.500000e+02, 1.430000e+02, 1.351429e+02, 1.274286e+02, 1.194286e+02, 1.125714e+02, 1.094286e+02, 1.030000e+02, 9.885714e+01, 9.271429e+01, 8.357143e+01, 7.628571e+01, 7.185714e+01, 6.300000e+01, 5.557143e+01, 5.028571e+01, 4.514286e+01, 4.342857e+01, 4.071429e+01, 3.500000e+01, 3.071429e+01, 2.757143e+01, 2.385714e+01, 2.100000e+01, 1.742857e+01, 1.400000e+01, 1.185714e+01, 9.857143e+00, 8.000000e+00, 6.714286e+00, 5.000000e+00, 4.285714e+00, 3.428571e+00, 2.714286e+00, 2.000000e+00, 1.714286e+00, 1.428571e+00, 1.000000e+00, 8.571429e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.970000e+02, 1.936667e+02, 1.848000e+02, 1.788571e+02, 1.722857e+02, 1.640000e+02, 1.592857e+02, 1.470000e+02, 1.432857e+02, 1.334286e+02, 1.284286e+02, 1.210000e+02, 1.091429e+02, 1.002857e+02, 9.800000e+01, 9.114286e+01, 8.442857e+01, 7.757143e+01, 7.028571e+01, 6.700000e+01, 6.342857e+01, 5.500000e+01, 4.900000e+01, 4.542857e+01, 4.014286e+01, 3.657143e+01, 3.257143e+01, 2.800000e+01, 2.642857e+01, 2.342857e+01, 1.985714e+01, 1.600000e+01, 1.485714e+01, 1.271429e+01, 1.114286e+01, 9.000000e+00, 7.714286e+00, 7.285714e+00, 6.428571e+00, 4.571429e+00, 3.571429e+00, 3.000000e+00, 2.571429e+00, 2.142857e+00, 1.571429e+00, 1.428571e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.900000e+02, 1.806667e+02, 1.712000e+02, 1.601429e+02, 1.548571e+02, 1.462857e+02, 1.367143e+02, 1.298571e+02, 1.230000e+02, 1.201429e+02, 1.141429e+02, 1.044286e+02, 9.857143e+01, 9.371429e+01, 8.985714e+01, 8.285714e+01, 7.800000e+01, 7.300000e+01, 6.871429e+01, 6.342857e+01, 5.871429e+01, 5.014286e+01, 4.500000e+01, 3.714286e+01, 3.271429e+01, 3.028571e+01, 2.614286e+01, 2.485714e+01, 2.428571e+01, 2.414286e+01, 2.185714e+01, 1.928571e+01, 1.514286e+01, 1.414286e+01, 1.085714e+01, 8.428571e+00, 6.142857e+00, 5.428571e+00, 4.571429e+00, 3.428571e+00, 2.714286e+00, 2.000000e+00, 1.285714e+00, 1.285714e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.930000e+02, 1.753333e+02, 1.636000e+02, 1.514286e+02, 1.410000e+02, 1.351429e+02, 1.252857e+02, 1.202857e+02, 1.107143e+02, 1.065714e+02, 9.928571e+01, 9.200000e+01, 8.528571e+01, 7.857143e+01, 7.400000e+01, 6.771429e+01, 6.328571e+01, 5.900000e+01, 5.485714e+01, 4.957143e+01, 4.657143e+01, 4.328571e+01, 4.000000e+01, 3.685714e+01, 3.371429e+01, 2.971429e+01, 2.742857e+01, 2.428571e+01, 2.071429e+01, 1.785714e+01, 1.528571e+01, 1.271429e+01, 1.257143e+01, 1.014286e+01, 9.000000e+00, 8.142857e+00, 7.000000e+00, 5.142857e+00, 4.285714e+00, 2.857143e+00, 2.714286e+00, 2.000000e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.360000e+02, 1.423333e+02, 1.388000e+02, 1.315714e+02, 1.287143e+02, 1.227143e+02, 1.181429e+02, 1.134286e+02, 1.048571e+02, 9.842857e+01, 9.457143e+01, 8.642857e+01, 8.014286e+01, 7.442857e+01, 6.971429e+01, 6.628571e+01, 6.100000e+01, 5.685714e+01, 5.500000e+01, 5.085714e+01, 4.600000e+01, 4.171429e+01, 3.700000e+01, 3.514286e+01, 3.071429e+01, 2.657143e+01, 2.314286e+01, 2.057143e+01, 1.700000e+01, 1.585714e+01, 1.385714e+01, 1.157143e+01, 1.028571e+01, 9.000000e+00, 7.428571e+00, 6.285714e+00, 4.857143e+00, 3.714286e+00, 3.285714e+00, 2.142857e+00, 1.857143e+00, 1.285714e+00, 1.285714e+00, 1.000000e+00, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.620000e+02, 1.470000e+02, 1.358000e+02, 1.291429e+02, 1.225714e+02, 1.150000e+02, 1.097143e+02, 1.047143e+02, 9.557143e+01, 9.214286e+01, 8.328571e+01, 7.742857e+01, 7.371429e+01, 6.971429e+01, 6.685714e+01, 6.671429e+01, 5.914286e+01, 5.800000e+01, 5.185714e+01, 4.585714e+01, 4.014286e+01, 3.457143e+01, 2.971429e+01, 2.900000e+01, 2.671429e+01, 2.428571e+01, 2.300000e+01, 2.014286e+01, 1.771429e+01, 1.528571e+01, 1.142857e+01, 8.857143e+00, 7.000000e+00, 5.285714e+00, 4.714286e+00, 4.142857e+00, 3.571429e+00, 3.000000e+00, 2.285714e+00, 2.000000e+00, 1.571429e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.180000e+02, 1.290000e+02, 1.190000e+02, 1.145714e+02, 1.125714e+02, 1.025714e+02, 9.500000e+01, 9.500000e+01, 8.785714e+01, 8.085714e+01, 7.542857e+01, 6.914286e+01, 6.628571e+01, 6.042857e+01, 5.228571e+01, 4.857143e+01, 4.485714e+01, 4.142857e+01, 3.642857e+01, 3.228571e+01, 3.071429e+01, 2.914286e+01, 2.571429e+01, 2.314286e+01, 2.014286e+01, 1.857143e+01, 1.585714e+01, 1.385714e+01, 1.071429e+01, 9.571429e+00, 7.857143e+00, 6.571429e+00, 5.000000e+00, 4.000000e+00, 3.428571e+00, 3.000000e+00, 2.571429e+00, 2.000000e+00, 1.428571e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.290000e+02, 1.236667e+02, 1.164000e+02, 1.090000e+02, 1.040000e+02, 9.828571e+01, 9.457143e+01, 8.800000e+01, 8.157143e+01, 7.514286e+01, 6.871429e+01, 6.142857e+01, 5.600000e+01, 4.871429e+01, 4.528571e+01, 4.071429e+01, 3.928571e+01, 3.771429e+01, 3.471429e+01, 3.071429e+01, 2.814286e+01, 2.585714e+01, 2.371429e+01, 1.985714e+01, 1.642857e+01, 1.528571e+01, 1.342857e+01, 1.200000e+01, 1.028571e+01, 9.857143e+00, 8.571429e+00, 7.857143e+00, 6.142857e+00, 5.142857e+00, 4.571429e+00, 3.571429e+00, 2.285714e+00, 2.000000e+00, 1.714286e+00, 1.428571e+00, 1.428571e+00, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.080000e+02, 1.090000e+02, 1.020000e+02, 9.485714e+01, 9.142857e+01, 8.671429e+01, 7.957143e+01, 7.414286e+01, 6.857143e+01, 6.614286e+01, 6.400000e+01, 5.771429e+01, 5.328571e+01, 4.971429e+01, 4.871429e+01, 4.685714e+01, 4.128571e+01, 3.671429e+01, 3.442857e+01, 3.271429e+01, 3.000000e+01, 2.485714e+01, 2.142857e+01, 2.000000e+01, 1.642857e+01, 1.385714e+01, 1.057143e+01, 8.571429e+00, 6.857143e+00, 5.571429e+00, 4.142857e+00, 3.571429e+00, 2.857143e+00, 1.714286e+00, 1.285714e+00, 1.142857e+00, 8.571429e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+02, 1.040000e+02, 9.860000e+01, 9.357143e+01, 8.842857e+01, 8.314286e+01, 7.557143e+01, 7.171429e+01, 6.657143e+01, 6.028571e+01, 5.557143e+01, 5.214286e+01, 4.700000e+01, 4.200000e+01, 3.814286e+01, 3.357143e+01, 3.057143e+01, 2.714286e+01, 2.400000e+01, 2.285714e+01, 2.242857e+01, 1.785714e+01, 1.671429e+01, 1.500000e+01, 1.414286e+01, 1.228571e+01, 1.057143e+01, 8.571429e+00, 8.285714e+00, 7.000000e+00, 6.142857e+00, 4.714286e+00, 4.142857e+00, 2.428571e+00, 2.285714e+00, 1.571429e+00, 1.142857e+00, 7.142857e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.050000e+02, 8.600000e+01, 9.080000e+01, 8.314286e+01, 7.642857e+01, 7.400000e+01, 6.957143e+01, 6.200000e+01, 5.514286e+01, 5.085714e+01, 4.771429e+01, 4.428571e+01, 4.271429e+01, 4.085714e+01, 3.742857e+01, 3.528571e+01, 3.228571e+01, 3.100000e+01, 2.857143e+01, 2.528571e+01, 2.242857e+01, 2.085714e+01, 1.800000e+01, 1.628571e+01, 1.414286e+01, 1.300000e+01, 1.071429e+01, 8.571429e+00, 6.142857e+00, 5.857143e+00, 4.571429e+00, 3.571429e+00, 2.285714e+00, 1.857143e+00, 1.571429e+00, 1.285714e+00, 7.142857e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 8.300000e+01, 7.866667e+01, 7.820000e+01, 7.328571e+01, 6.942857e+01, 6.585714e+01, 6.171429e+01, 5.800000e+01, 5.442857e+01, 5.371429e+01, 5.014286e+01, 4.600000e+01, 4.385714e+01, 4.142857e+01, 3.728571e+01, 3.242857e+01, 2.700000e+01, 2.300000e+01, 2.242857e+01, 1.900000e+01, 1.614286e+01, 1.500000e+01, 1.357143e+01, 1.171429e+01, 1.114286e+01, 8.285714e+00, 7.285714e+00, 6.000000e+00, 4.142857e+00, 3.000000e+00, 3.000000e+00, 2.142857e+00, 1.714286e+00, 1.142857e+00, 7.142857e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 8.800000e+01, 7.800000e+01, 6.960000e+01, 6.671429e+01, 6.071429e+01, 5.642857e+01, 5.300000e+01, 5.300000e+01, 5.100000e+01, 4.614286e+01, 4.357143e+01, 4.100000e+01, 3.842857e+01, 3.485714e+01, 2.828571e+01, 2.457143e+01, 2.157143e+01, 1.900000e+01, 1.642857e+01, 1.342857e+01, 1.100000e+01, 1.014286e+01, 8.571429e+00, 7.428571e+00, 6.142857e+00, 5.714286e+00, 5.000000e+00, 5.285714e+00, 4.142857e+00, 4.000000e+00, 3.428571e+00, 2.714286e+00, 1.714286e+00, 1.428571e+00, 5.714286e-01, 5.714286e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 7.400000e+01, 7.100000e+01, 6.820000e+01, 6.371429e+01, 5.885714e+01, 5.728571e+01, 5.428571e+01, 5.057143e+01, 4.457143e+01, 4.028571e+01, 3.742857e+01, 3.514286e+01, 2.885714e+01, 2.585714e+01, 2.285714e+01, 2.157143e+01, 1.957143e+01, 1.728571e+01, 1.571429e+01, 1.371429e+01, 1.200000e+01, 1.142857e+01, 1.028571e+01, 9.571429e+00, 7.857143e+00, 6.142857e+00, 5.000000e+00, 4.285714e+00, 2.857143e+00, 2.142857e+00, 1.428571e+00, 1.428571e+00, 1.428571e+00, 1.428571e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 8.000000e+01, 6.866667e+01, 6.640000e+01, 6.171429e+01, 5.514286e+01, 5.085714e+01, 4.642857e+01, 4.185714e+01, 3.700000e+01, 3.342857e+01, 2.914286e+01, 2.714286e+01, 2.585714e+01, 2.385714e+01, 2.114286e+01, 1.871429e+01, 1.657143e+01, 1.514286e+01, 1.271429e+01, 1.028571e+01, 9.142857e+00, 7.857143e+00, 7.000000e+00, 6.142857e+00, 5.000000e+00, 4.714286e+00, 3.428571e+00, 2.714286e+00, 2.714286e+00, 1.714286e+00, 1.428571e+00, 8.571429e-01, 7.142857e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.000000e+01, 6.366667e+01, 6.020000e+01, 5.500000e+01, 5.114286e+01, 4.614286e+01, 4.285714e+01, 3.957143e+01, 3.557143e+01, 3.285714e+01, 3.157143e+01, 3.000000e+01, 2.757143e+01, 2.528571e+01, 2.214286e+01, 1.942857e+01, 1.714286e+01, 1.400000e+01, 1.214286e+01, 9.571429e+00, 8.000000e+00, 7.142857e+00, 6.285714e+00, 4.714286e+00, 4.285714e+00, 3.285714e+00, 2.714286e+00, 2.142857e+00, 1.571429e+00, 1.285714e+00, 1.000000e+00, 7.142857e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.500000e+01, 5.400000e+01, 5.000000e+01, 4.600000e+01, 4.014286e+01, 3.742857e+01, 3.457143e+01, 3.071429e+01, 2.671429e+01, 2.485714e+01, 2.271429e+01, 2.285714e+01, 2.057143e+01, 1.828571e+01, 1.942857e+01, 1.814286e+01, 1.642857e+01, 1.357143e+01, 1.042857e+01, 9.000000e+00, 8.285714e+00, 5.714286e+00, 4.285714e+00, 3.428571e+00, 3.142857e+00, 2.714286e+00, 1.571429e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.100000e+01, 4.633333e+01, 4.500000e+01, 4.028571e+01, 3.857143e+01, 3.600000e+01, 3.328571e+01, 2.942857e+01, 2.714286e+01, 2.542857e+01, 2.400000e+01, 2.200000e+01, 1.985714e+01, 1.657143e+01, 1.571429e+01, 1.242857e+01, 1.071429e+01, 1.014286e+01, 9.142857e+00, 7.857143e+00, 7.857143e+00, 6.571429e+00, 6.428571e+00, 5.714286e+00, 4.571429e+00, 3.571429e+00, 2.857143e+00, 1.857143e+00, 1.571429e+00, 1.285714e+00, 8.571429e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 5.200000e+01, 5.000000e+01, 4.340000e+01, 3.757143e+01, 3.457143e+01, 3.171429e+01, 2.714286e+01, 2.542857e+01, 2.257143e+01, 2.271429e+01, 2.014286e+01, 1.685714e+01, 1.428571e+01, 1.257143e+01, 1.114286e+01, 9.571429e+00, 7.428571e+00, 6.428571e+00, 5.714286e+00, 5.571429e+00, 5.000000e+00, 4.428571e+00, 3.714286e+00, 3.428571e+00, 3.142857e+00, 3.000000e+00, 2.285714e+00, 1.571429e+00, 1.142857e+00, 8.571429e-01, 7.142857e-01, 5.714286e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.800000e+01, 4.000000e+01, 3.720000e+01, 3.485714e+01, 3.228571e+01, 2.885714e+01, 2.771429e+01, 2.542857e+01, 2.357143e+01, 2.157143e+01, 2.000000e+01, 1.871429e+01, 1.642857e+01, 1.357143e+01, 1.157143e+01, 9.857143e+00, 8.571429e+00, 6.428571e+00, 5.142857e+00, 4.714286e+00, 4.142857e+00, 3.714286e+00, 2.714286e+00, 2.142857e+00, 1.714286e+00, 1.571429e+00, 1.142857e+00, 8.571429e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.600000e+01, 3.700000e+01, 3.440000e+01, 3.185714e+01, 2.728571e+01, 2.614286e+01, 2.300000e+01, 2.100000e+01, 1.857143e+01, 1.600000e+01, 1.414286e+01, 1.385714e+01, 1.214286e+01, 1.157143e+01, 1.000000e+01, 8.142857e+00, 6.714286e+00, 6.000000e+00, 4.428571e+00, 3.857143e+00, 2.142857e+00, 1.571429e+00, 1.571429e+00, 1.714286e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.700000e+01, 3.166667e+01, 2.880000e+01, 2.742857e+01, 2.485714e+01, 2.328571e+01, 2.142857e+01, 1.885714e+01, 1.742857e+01, 1.571429e+01, 1.328571e+01, 1.214286e+01, 1.085714e+01, 1.000000e+01, 8.571429e+00, 7.428571e+00, 6.142857e+00, 5.428571e+00, 3.857143e+00, 2.285714e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 8.571429e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.500000e+01, 2.600000e+01, 2.420000e+01, 2.414286e+01, 2.057143e+01, 1.914286e+01, 1.828571e+01, 1.557143e+01, 1.428571e+01, 1.185714e+01, 9.428571e+00, 8.428571e+00, 7.714286e+00, 6.285714e+00, 5.571429e+00, 4.714286e+00, 4.142857e+00, 3.285714e+00, 3.000000e+00, 1.857143e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 8.571429e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.900000e+01, 2.300000e+01, 2.100000e+01, 1.985714e+01, 1.857143e+01, 1.671429e+01, 1.600000e+01, 1.385714e+01, 1.228571e+01, 1.000000e+01, 8.857143e+00, 6.714286e+00, 5.857143e+00, 4.142857e+00, 3.571429e+00, 3.142857e+00, 2.714286e+00, 2.142857e+00, 1.857143e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 8.571429e-01, 7.142857e-01, 5.714286e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.900000e+01, 1.800000e+01, 1.800000e+01, 1.657143e+01, 1.557143e+01, 1.400000e+01, 1.228571e+01, 1.071429e+01, 9.285714e+00, 8.285714e+00, 7.285714e+00, 6.000000e+00, 5.428571e+00, 5.142857e+00, 4.571429e+00, 4.142857e+00, 3.857143e+00, 3.142857e+00, 2.714286e+00, 2.428571e+00, 2.000000e+00, 1.571429e+00, 1.000000e+00, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.200000e+01, 1.800000e+01, 1.560000e+01, 1.385714e+01, 1.185714e+01, 9.857143e+00, 9.142857e+00, 8.285714e+00, 7.285714e+00, 6.428571e+00, 5.857143e+00, 5.857143e+00, 5.000000e+00, 4.142857e+00, 3.285714e+00, 2.857143e+00, 2.571429e+00, 2.000000e+00, 1.142857e+00, 1.000000e+00, 1.142857e+00, 8.571429e-01, 8.571429e-01, 4.285714e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.300000e+01, 1.666667e+01, 1.440000e+01, 1.235714e+01, 9.857143e+00, 8.428571e+00, 7.785714e+00, 7.000000e+00, 5.928571e+00, 5.285714e+00, 4.714286e+00, 4.928571e+00, 4.071429e+00, 3.500000e+00, 2.785714e+00, 2.357143e+00, 2.142857e+00, 1.785714e+00, 9.285714e-01, 7.857143e-01, 6.428571e-01, 5.000000e-01, 5.714286e-01, 2.857143e-01, 3.571429e-01, 2.142857e-01, 2.142857e-01, 1.428571e-01, 1.428571e-01, 7.142857e-02, 7.142857e-02, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.400000e+01, 1.533333e+01, 1.320000e+01, 1.085714e+01, 7.857143e+00, 7.000000e+00, 6.428571e+00, 5.714286e+00, 4.571429e+00, 4.142857e+00, 3.571429e+00, 4.000000e+00, 3.142857e+00, 2.857143e+00, 2.285714e+00, 1.857143e+00, 1.714286e+00, 1.571429e+00, 7.142857e-01, 5.714286e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.600000e+01, 1.400000e+01, 1.200000e+01, 1.028571e+01, 8.857143e+00, 7.285714e+00, 6.714286e+00, 5.857143e+00, 5.428571e+00, 4.571429e+00, 4.428571e+00, 3.857143e+00, 3.000000e+00, 2.285714e+00, 1.714286e+00, 1.000000e+00, 8.571429e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.400000e+01, 1.300000e+01, 1.040000e+01, 9.571429e+00, 8.428571e+00, 7.000000e+00, 6.000000e+00, 4.571429e+00, 4.571429e+00, 3.857143e+00, 2.571429e+00, 1.714286e+00, 1.142857e+00, 7.142857e-01, 5.714286e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 8.000000e+00, 9.666667e+00, 8.800000e+00, 8.000000e+00, 7.571429e+00, 6.571429e+00, 5.285714e+00, 3.857143e+00, 3.428571e+00, 2.714286e+00, 1.857143e+00, 1.428571e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.000000e+00, 4.666667e+00, 5.400000e+00, 5.142857e+00, 4.571429e+00, 4.142857e+00, 3.857143e+00, 3.285714e+00, 3.142857e+00, 2.857143e+00, 2.285714e+00, 2.142857e+00, 1.857143e+00, 1.857143e+00, 1.285714e+00, 8.571429e-01, 7.142857e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 9.000000e+00, 7.666667e+00, 5.200000e+00, 5.142857e+00, 4.142857e+00, 3.285714e+00, 2.428571e+00, 2.428571e+00, 2.142857e+00, 1.142857e+00, 7.142857e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.000000e+00, 3.666667e+00, 3.800000e+00, 2.857143e+00, 2.857143e+00, 2.000000e+00, 1.571429e+00, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.100000e+01, 6.666667e+00, 5.600000e+00, 4.142857e+00, 2.714286e+00, 2.142857e+00, 1.714286e+00, 1.142857e+00, 5.714286e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.000000e+00, 2.333333e+00, 2.400000e+00, 1.857143e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 8.571429e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.000000e+00, 1.666667e+00, 2.000000e+00, 1.714286e+00, 1.428571e+00, 1.142857e+00, 1.285714e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.000000e+00, 1.333333e+00, 8.000000e-01, 7.142857e-01, 4.285714e-01, 1.428571e-01, 2.857143e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00}
};

// Distribution of angle between bremsstrahlung emission direction and vector from source to point of bremsstrahlung origin
// In 20 keV steps, 0 - 2 MeV, and 1 degree steps in angle
const G4double GateSourceFastY90::mAngleTable[100][180] = {
    { 1.659000e+04, 4.906867e+04, 7.996920e+04, 1.086744e+05, 1.370021e+05, 1.635853e+05, 1.883850e+05, 2.110080e+05, 2.319834e+05, 2.510019e+05, 2.683253e+05, 2.839611e+05, 2.980703e+05, 3.107283e+05, 3.221277e+05, 3.322944e+05, 3.412611e+05, 3.491453e+05, 3.563604e+05, 3.625560e+05, 3.680127e+05, 3.729433e+05, 3.768919e+05, 3.804210e+05, 3.831709e+05, 3.852414e+05, 3.871013e+05, 3.884090e+05, 3.889921e+05, 3.892046e+05, 3.890503e+05, 3.887549e+05, 3.878731e+05, 3.866241e+05, 3.850434e+05, 3.834353e+05, 3.815053e+05, 3.791811e+05, 3.764749e+05, 3.740220e+05, 3.712370e+05, 3.680947e+05, 3.646844e+05, 3.613023e+05, 3.578143e+05, 3.542966e+05, 3.503184e+05, 3.462041e+05, 3.423679e+05, 3.383329e+05, 3.342756e+05, 3.302096e+05, 3.259367e+05, 3.218401e+05, 3.177831e+05, 3.134899e+05, 3.093979e+05, 3.051424e+05, 3.009359e+05, 2.966769e+05, 2.924093e+05, 2.879377e+05, 2.837191e+05, 2.793244e+05, 2.749219e+05, 2.705619e+05, 2.663140e+05, 2.619883e+05, 2.579380e+05, 2.538344e+05, 2.497509e+05, 2.457553e+05, 2.417681e+05, 2.378101e+05, 2.339461e+05, 2.301381e+05, 2.262786e+05, 2.226101e+05, 2.189583e+05, 2.152287e+05, 2.116910e+05, 2.081199e+05, 2.045787e+05, 2.010909e+05, 1.975633e+05, 1.942377e+05, 1.909684e+05, 1.875844e+05, 1.843591e+05, 1.812399e+05, 1.781024e+05, 1.750809e+05, 1.719563e+05, 1.690047e+05, 1.661440e+05, 1.632501e+05, 1.603917e+05, 1.575083e+05, 1.547379e+05, 1.521159e+05, 1.493930e+05, 1.466050e+05, 1.439481e+05, 1.412943e+05, 1.386229e+05, 1.361443e+05, 1.335363e+05, 1.310497e+05, 1.287026e+05, 1.264043e+05, 1.239541e+05, 1.216823e+05, 1.192567e+05, 1.168963e+05, 1.146534e+05, 1.124496e+05, 1.101910e+05, 1.081334e+05, 1.060550e+05, 1.039630e+05, 1.019057e+05, 9.974414e+04, 9.765871e+04, 9.562500e+04, 9.346543e+04, 9.145700e+04, 8.948943e+04, 8.765571e+04, 8.576300e+04, 8.382471e+04, 8.191514e+04, 8.013043e+04, 7.826386e+04, 7.640443e+04, 7.443729e+04, 7.260186e+04, 7.090657e+04, 6.909343e+04, 6.731700e+04, 6.549157e+04, 6.375757e+04, 6.208543e+04, 6.039800e+04, 5.870314e+04, 5.699671e+04, 5.527986e+04, 5.362786e+04, 5.191529e+04, 5.018600e+04, 4.845971e+04, 4.666629e+04, 4.504629e+04, 4.343914e+04, 4.182843e+04, 4.026200e+04, 3.870814e+04, 3.709057e+04, 3.551214e+04, 3.388271e+04, 3.222871e+04, 3.063229e+04, 2.899543e+04, 2.735443e+04, 2.580314e+04, 2.424357e+04, 2.267829e+04, 2.119229e+04, 1.961686e+04, 1.807371e+04, 1.650114e+04, 1.493386e+04, 1.338100e+04, 1.180100e+04, 1.016329e+04, 8.611857e+03, 7.033143e+03, 5.496429e+03, 3.886800e+03, 2.352667e+03, 7.760000e+02},
    { 5.435000e+03, 1.634667e+04, 2.646880e+04, 3.581157e+04, 4.509014e+04, 5.371243e+04, 6.171243e+04, 6.918214e+04, 7.580371e+04, 8.188100e+04, 8.735443e+04, 9.235271e+04, 9.699243e+04, 1.009351e+05, 1.044090e+05, 1.076574e+05, 1.104660e+05, 1.130014e+05, 1.152330e+05, 1.171084e+05, 1.188076e+05, 1.203170e+05, 1.214137e+05, 1.224220e+05, 1.231847e+05, 1.237621e+05, 1.240794e+05, 1.242421e+05, 1.242794e+05, 1.242930e+05, 1.241440e+05, 1.238269e+05, 1.233643e+05, 1.228456e+05, 1.222684e+05, 1.216003e+05, 1.207700e+05, 1.198717e+05, 1.190036e+05, 1.180387e+05, 1.169874e+05, 1.158207e+05, 1.145777e+05, 1.134466e+05, 1.122216e+05, 1.109119e+05, 1.095913e+05, 1.082606e+05, 1.070653e+05, 1.056593e+05, 1.043024e+05, 1.028819e+05, 1.014290e+05, 9.987529e+04, 9.841957e+04, 9.697029e+04, 9.558071e+04, 9.411171e+04, 9.269171e+04, 9.124171e+04, 8.988386e+04, 8.846386e+04, 8.699614e+04, 8.559457e+04, 8.419500e+04, 8.284314e+04, 8.144229e+04, 8.012500e+04, 7.872700e+04, 7.739700e+04, 7.605386e+04, 7.470129e+04, 7.328171e+04, 7.196329e+04, 7.069729e+04, 6.947014e+04, 6.820486e+04, 6.696671e+04, 6.581471e+04, 6.462114e+04, 6.351443e+04, 6.230643e+04, 6.119371e+04, 6.010557e+04, 5.909629e+04, 5.805771e+04, 5.701843e+04, 5.599500e+04, 5.498600e+04, 5.399357e+04, 5.305371e+04, 5.200029e+04, 5.101029e+04, 5.007814e+04, 4.914800e+04, 4.825529e+04, 4.737386e+04, 4.638543e+04, 4.554043e+04, 4.468214e+04, 4.389643e+04, 4.304600e+04, 4.228757e+04, 4.141657e+04, 4.066314e+04, 3.988571e+04, 3.905500e+04, 3.825529e+04, 3.752300e+04, 3.675371e+04, 3.610971e+04, 3.543000e+04, 3.472786e+04, 3.410229e+04, 3.340129e+04, 3.270429e+04, 3.199286e+04, 3.130143e+04, 3.062943e+04, 3.000929e+04, 2.933914e+04, 2.875929e+04, 2.819786e+04, 2.760029e+04, 2.697314e+04, 2.641171e+04, 2.582086e+04, 2.522943e+04, 2.469229e+04, 2.411043e+04, 2.355400e+04, 2.303514e+04, 2.242657e+04, 2.187886e+04, 2.134157e+04, 2.077229e+04, 2.021943e+04, 1.970643e+04, 1.920843e+04, 1.867743e+04, 1.813786e+04, 1.764271e+04, 1.713114e+04, 1.665443e+04, 1.612186e+04, 1.560986e+04, 1.515657e+04, 1.467829e+04, 1.421843e+04, 1.371971e+04, 1.327171e+04, 1.283057e+04, 1.237186e+04, 1.190586e+04, 1.146071e+04, 1.097514e+04, 1.055371e+04, 1.008400e+04, 9.613857e+03, 9.133143e+03, 8.685429e+03, 8.239000e+03, 7.801857e+03, 7.333429e+03, 6.864571e+03, 6.409000e+03, 5.929286e+03, 5.486429e+03, 5.024429e+03, 4.577714e+03, 4.121714e+03, 3.691857e+03, 3.279143e+03, 2.858429e+03, 2.412571e+03, 1.973143e+03, 1.533143e+03, 1.101400e+03, 6.600000e+02, 2.220000e+02},
    { 2.886000e+03, 8.692333e+03, 1.412380e+04, 1.911814e+04, 2.404271e+04, 2.864300e+04, 3.291429e+04, 3.681943e+04, 4.036243e+04, 4.357371e+04, 4.650071e+04, 4.913100e+04, 5.146700e+04, 5.353914e+04, 5.538186e+04, 5.703229e+04, 5.854314e+04, 5.976486e+04, 6.082743e+04, 6.184257e+04, 6.272614e+04, 6.337971e+04, 6.392929e+04, 6.441029e+04, 6.471957e+04, 6.505400e+04, 6.518729e+04, 6.517243e+04, 6.524029e+04, 6.518171e+04, 6.499629e+04, 6.480586e+04, 6.450171e+04, 6.418214e+04, 6.385057e+04, 6.347243e+04, 6.298886e+04, 6.250986e+04, 6.193929e+04, 6.132171e+04, 6.068729e+04, 5.992357e+04, 5.919214e+04, 5.850514e+04, 5.784357e+04, 5.716071e+04, 5.647343e+04, 5.571986e+04, 5.503714e+04, 5.430086e+04, 5.356071e+04, 5.272300e+04, 5.191143e+04, 5.110757e+04, 5.033100e+04, 4.959457e+04, 4.874814e+04, 4.794014e+04, 4.710943e+04, 4.637543e+04, 4.561943e+04, 4.482243e+04, 4.408986e+04, 4.343671e+04, 4.273129e+04, 4.194929e+04, 4.117986e+04, 4.048400e+04, 3.978414e+04, 3.903457e+04, 3.823500e+04, 3.750814e+04, 3.688600e+04, 3.617500e+04, 3.544229e+04, 3.477543e+04, 3.410543e+04, 3.347457e+04, 3.285100e+04, 3.221543e+04, 3.162886e+04, 3.104671e+04, 3.051314e+04, 2.988671e+04, 2.937457e+04, 2.880700e+04, 2.823886e+04, 2.771914e+04, 2.721886e+04, 2.665100e+04, 2.614229e+04, 2.561600e+04, 2.514029e+04, 2.465643e+04, 2.416186e+04, 2.370071e+04, 2.322429e+04, 2.281657e+04, 2.232729e+04, 2.189443e+04, 2.151586e+04, 2.110957e+04, 2.066057e+04, 2.028871e+04, 1.990486e+04, 1.950514e+04, 1.908929e+04, 1.867843e+04, 1.830214e+04, 1.792586e+04, 1.758029e+04, 1.720857e+04, 1.689014e+04, 1.654671e+04, 1.620929e+04, 1.589086e+04, 1.561086e+04, 1.528057e+04, 1.494786e+04, 1.460914e+04, 1.431800e+04, 1.401643e+04, 1.369714e+04, 1.335843e+04, 1.302600e+04, 1.271014e+04, 1.242886e+04, 1.209600e+04, 1.180671e+04, 1.154686e+04, 1.126343e+04, 1.101143e+04, 1.076200e+04, 1.051686e+04, 1.028157e+04, 1.003471e+04, 9.758000e+03, 9.490143e+03, 9.224714e+03, 8.983000e+03, 8.721000e+03, 8.488429e+03, 8.242000e+03, 7.975429e+03, 7.731571e+03, 7.520429e+03, 7.284143e+03, 7.038429e+03, 6.787857e+03, 6.552571e+03, 6.319000e+03, 6.127714e+03, 5.877571e+03, 5.662286e+03, 5.456000e+03, 5.235143e+03, 4.997857e+03, 4.800286e+03, 4.561714e+03, 4.339571e+03, 4.108429e+03, 3.886857e+03, 3.675714e+03, 3.464857e+03, 3.244714e+03, 3.038429e+03, 2.838571e+03, 2.618000e+03, 2.412857e+03, 2.204429e+03, 1.995857e+03, 1.790429e+03, 1.575286e+03, 1.356000e+03, 1.155286e+03, 9.352857e+02, 7.190000e+02, 5.154000e+02, 3.180000e+02, 1.030000e+02},
    { 1.921000e+03, 5.745333e+03, 9.313800e+03, 1.251443e+04, 1.578086e+04, 1.879400e+04, 2.156243e+04, 2.410600e+04, 2.639986e+04, 2.846286e+04, 3.041557e+04, 3.206271e+04, 3.360229e+04, 3.495371e+04, 3.615571e+04, 3.720571e+04, 3.813943e+04, 3.893671e+04, 3.966271e+04, 4.024814e+04, 4.078043e+04, 4.115114e+04, 4.146871e+04, 4.173314e+04, 4.192029e+04, 4.204314e+04, 4.208000e+04, 4.204857e+04, 4.204143e+04, 4.201786e+04, 4.188529e+04, 4.170786e+04, 4.145386e+04, 4.123514e+04, 4.098671e+04, 4.067014e+04, 4.034629e+04, 3.992243e+04, 3.952414e+04, 3.914843e+04, 3.869414e+04, 3.823714e+04, 3.779586e+04, 3.731186e+04, 3.686657e+04, 3.642571e+04, 3.592657e+04, 3.544471e+04, 3.492157e+04, 3.442643e+04, 3.388843e+04, 3.341014e+04, 3.286614e+04, 3.235257e+04, 3.181114e+04, 3.133414e+04, 3.074871e+04, 3.023329e+04, 2.974300e+04, 2.921843e+04, 2.870043e+04, 2.823500e+04, 2.770771e+04, 2.729471e+04, 2.678629e+04, 2.627086e+04, 2.575929e+04, 2.530357e+04, 2.479857e+04, 2.433857e+04, 2.383400e+04, 2.338571e+04, 2.292971e+04, 2.252214e+04, 2.206700e+04, 2.163443e+04, 2.122757e+04, 2.077786e+04, 2.038757e+04, 1.998457e+04, 1.963971e+04, 1.927214e+04, 1.887214e+04, 1.849529e+04, 1.816814e+04, 1.778357e+04, 1.744100e+04, 1.703700e+04, 1.667657e+04, 1.638000e+04, 1.603300e+04, 1.570143e+04, 1.542400e+04, 1.512500e+04, 1.483243e+04, 1.457386e+04, 1.427100e+04, 1.399571e+04, 1.370657e+04, 1.342143e+04, 1.313086e+04, 1.286900e+04, 1.259614e+04, 1.235671e+04, 1.212543e+04, 1.191786e+04, 1.167557e+04, 1.145657e+04, 1.121286e+04, 1.096671e+04, 1.072600e+04, 1.046514e+04, 1.019329e+04, 9.986857e+03, 9.777429e+03, 9.587857e+03, 9.394000e+03, 9.199429e+03, 8.997857e+03, 8.835714e+03, 8.632857e+03, 8.450000e+03, 8.247000e+03, 8.060714e+03, 7.891714e+03, 7.712714e+03, 7.517857e+03, 7.316857e+03, 7.114571e+03, 6.956571e+03, 6.772143e+03, 6.579000e+03, 6.411714e+03, 6.267857e+03, 6.105286e+03, 5.965429e+03, 5.806286e+03, 5.659714e+03, 5.512571e+03, 5.364000e+03, 5.189286e+03, 5.057714e+03, 4.899286e+03, 4.750714e+03, 4.595143e+03, 4.454429e+03, 4.311429e+03, 4.181143e+03, 4.041000e+03, 3.916000e+03, 3.779286e+03, 3.644571e+03, 3.505286e+03, 3.375429e+03, 3.248143e+03, 3.132571e+03, 2.984000e+03, 2.837857e+03, 2.718429e+03, 2.596286e+03, 2.461571e+03, 2.336143e+03, 2.182143e+03, 2.062143e+03, 1.941714e+03, 1.810000e+03, 1.675714e+03, 1.558143e+03, 1.423857e+03, 1.304857e+03, 1.172000e+03, 1.047429e+03, 9.137143e+02, 7.931429e+02, 6.725714e+02, 5.487143e+02, 4.244286e+02, 3.038000e+02, 1.873333e+02, 5.500000e+01},
    { 1.354000e+03, 4.104333e+03, 6.647000e+03, 8.988143e+03, 1.132000e+04, 1.351029e+04, 1.550743e+04, 1.737614e+04, 1.908271e+04, 2.064057e+04, 2.197686e+04, 2.315857e+04, 2.423643e+04, 2.516529e+04, 2.596157e+04, 2.667971e+04, 2.724400e+04, 2.779071e+04, 2.830529e+04, 2.870986e+04, 2.905271e+04, 2.931586e+04, 2.953171e+04, 2.971214e+04, 2.984914e+04, 2.991286e+04, 2.995200e+04, 2.996171e+04, 2.994500e+04, 2.989557e+04, 2.983000e+04, 2.968071e+04, 2.952629e+04, 2.929457e+04, 2.906829e+04, 2.882586e+04, 2.850643e+04, 2.822586e+04, 2.789657e+04, 2.760171e+04, 2.727529e+04, 2.697171e+04, 2.663971e+04, 2.629800e+04, 2.595343e+04, 2.567614e+04, 2.529000e+04, 2.495343e+04, 2.457243e+04, 2.416071e+04, 2.384543e+04, 2.349629e+04, 2.308100e+04, 2.272200e+04, 2.234686e+04, 2.195171e+04, 2.161214e+04, 2.119300e+04, 2.080314e+04, 2.043500e+04, 2.001414e+04, 1.966014e+04, 1.932543e+04, 1.894729e+04, 1.858057e+04, 1.821171e+04, 1.786371e+04, 1.756400e+04, 1.721457e+04, 1.685014e+04, 1.653543e+04, 1.620271e+04, 1.586486e+04, 1.549786e+04, 1.516257e+04, 1.483314e+04, 1.451414e+04, 1.421886e+04, 1.395329e+04, 1.368529e+04, 1.343129e+04, 1.316257e+04, 1.291914e+04, 1.267243e+04, 1.240300e+04, 1.213700e+04, 1.189557e+04, 1.165829e+04, 1.140043e+04, 1.115357e+04, 1.091200e+04, 1.068100e+04, 1.047600e+04, 1.026914e+04, 1.008471e+04, 9.896143e+03, 9.694286e+03, 9.501714e+03, 9.307286e+03, 9.104857e+03, 8.871143e+03, 8.646143e+03, 8.460571e+03, 8.265143e+03, 8.085000e+03, 7.913000e+03, 7.739429e+03, 7.568571e+03, 7.421714e+03, 7.250429e+03, 7.120143e+03, 6.959714e+03, 6.807429e+03, 6.672857e+03, 6.544857e+03, 6.402857e+03, 6.292714e+03, 6.140000e+03, 6.023429e+03, 5.887857e+03, 5.743143e+03, 5.640143e+03, 5.529429e+03, 5.374857e+03, 5.250714e+03, 5.137714e+03, 5.016000e+03, 4.897714e+03, 4.748143e+03, 4.620286e+03, 4.513714e+03, 4.386000e+03, 4.249714e+03, 4.151000e+03, 4.050143e+03, 3.959857e+03, 3.833571e+03, 3.732286e+03, 3.638857e+03, 3.543857e+03, 3.425143e+03, 3.335571e+03, 3.238429e+03, 3.150000e+03, 3.055429e+03, 2.973714e+03, 2.884571e+03, 2.791143e+03, 2.689714e+03, 2.588857e+03, 2.502714e+03, 2.414857e+03, 2.304429e+03, 2.224000e+03, 2.148429e+03, 2.054571e+03, 1.957143e+03, 1.870143e+03, 1.778714e+03, 1.710429e+03, 1.613143e+03, 1.520429e+03, 1.429286e+03, 1.356857e+03, 1.261143e+03, 1.175143e+03, 1.082000e+03, 1.003000e+03, 9.271429e+02, 8.514286e+02, 7.605714e+02, 6.851429e+02, 6.057143e+02, 5.240000e+02, 4.478571e+02, 3.621429e+02, 2.825714e+02, 2.072000e+02, 1.283333e+02, 4.500000e+01},
    { 1.024000e+03, 3.182000e+03, 5.122000e+03, 6.956571e+03, 8.757286e+03, 1.040129e+04, 1.191229e+04, 1.331929e+04, 1.458971e+04, 1.570471e+04, 1.669686e+04, 1.754571e+04, 1.836186e+04, 1.909243e+04, 1.968300e+04, 2.021314e+04, 2.070600e+04, 2.116071e+04, 2.157957e+04, 2.188371e+04, 2.211700e+04, 2.233686e+04, 2.251057e+04, 2.261600e+04, 2.264729e+04, 2.263371e+04, 2.262386e+04, 2.264486e+04, 2.258200e+04, 2.249357e+04, 2.237571e+04, 2.226357e+04, 2.213686e+04, 2.197043e+04, 2.171729e+04, 2.151600e+04, 2.135229e+04, 2.116229e+04, 2.093400e+04, 2.069514e+04, 2.043814e+04, 2.023400e+04, 1.997086e+04, 1.966757e+04, 1.939114e+04, 1.913186e+04, 1.888214e+04, 1.861900e+04, 1.831200e+04, 1.805257e+04, 1.775457e+04, 1.748557e+04, 1.716757e+04, 1.686500e+04, 1.661514e+04, 1.635800e+04, 1.606129e+04, 1.578643e+04, 1.545500e+04, 1.515614e+04, 1.486343e+04, 1.453286e+04, 1.419986e+04, 1.391229e+04, 1.363171e+04, 1.336571e+04, 1.308057e+04, 1.282757e+04, 1.256986e+04, 1.233029e+04, 1.206614e+04, 1.181443e+04, 1.157529e+04, 1.134671e+04, 1.110886e+04, 1.087000e+04, 1.065743e+04, 1.042343e+04, 1.022329e+04, 9.987857e+03, 9.817286e+03, 9.608571e+03, 9.417143e+03, 9.207429e+03, 9.028143e+03, 8.840857e+03, 8.655286e+03, 8.455000e+03, 8.286000e+03, 8.116857e+03, 7.947857e+03, 7.783000e+03, 7.609143e+03, 7.459857e+03, 7.287286e+03, 7.127571e+03, 6.953286e+03, 6.802429e+03, 6.660571e+03, 6.512714e+03, 6.361429e+03, 6.235714e+03, 6.092000e+03, 5.977000e+03, 5.844286e+03, 5.737714e+03, 5.610571e+03, 5.490000e+03, 5.354143e+03, 5.216857e+03, 5.107286e+03, 4.977286e+03, 4.861000e+03, 4.744143e+03, 4.650857e+03, 4.563000e+03, 4.468714e+03, 4.345571e+03, 4.262857e+03, 4.142714e+03, 4.060143e+03, 3.967571e+03, 3.871429e+03, 3.794714e+03, 3.713000e+03, 3.629429e+03, 3.547714e+03, 3.463000e+03, 3.377429e+03, 3.281571e+03, 3.183000e+03, 3.096143e+03, 3.008714e+03, 2.924714e+03, 2.852571e+03, 2.772857e+03, 2.714714e+03, 2.659429e+03, 2.601571e+03, 2.533429e+03, 2.467429e+03, 2.384286e+03, 2.318714e+03, 2.239000e+03, 2.161000e+03, 2.095286e+03, 2.033000e+03, 1.968000e+03, 1.904571e+03, 1.841714e+03, 1.782571e+03, 1.721000e+03, 1.639429e+03, 1.575714e+03, 1.508714e+03, 1.452143e+03, 1.391429e+03, 1.333286e+03, 1.274429e+03, 1.221143e+03, 1.155143e+03, 1.095571e+03, 1.033143e+03, 9.640000e+02, 8.971429e+02, 8.335714e+02, 7.698571e+02, 7.118571e+02, 6.594286e+02, 6.028571e+02, 5.492857e+02, 4.952857e+02, 4.362857e+02, 3.822857e+02, 3.235714e+02, 2.640000e+02, 2.032857e+02, 1.400000e+02, 8.700000e+01, 2.900000e+01},
    { 7.920000e+02, 2.488667e+03, 4.031600e+03, 5.478714e+03, 6.917000e+03, 8.216000e+03, 9.436286e+03, 1.054386e+04, 1.154200e+04, 1.241600e+04, 1.317229e+04, 1.384900e+04, 1.453000e+04, 1.509386e+04, 1.562657e+04, 1.606371e+04, 1.646100e+04, 1.677600e+04, 1.708014e+04, 1.729800e+04, 1.748414e+04, 1.759357e+04, 1.767957e+04, 1.774286e+04, 1.783129e+04, 1.785071e+04, 1.782300e+04, 1.776700e+04, 1.773129e+04, 1.765386e+04, 1.758729e+04, 1.746200e+04, 1.733886e+04, 1.720343e+04, 1.710129e+04, 1.692371e+04, 1.679843e+04, 1.661229e+04, 1.640743e+04, 1.617286e+04, 1.596100e+04, 1.573114e+04, 1.552571e+04, 1.529257e+04, 1.506600e+04, 1.482929e+04, 1.464386e+04, 1.437071e+04, 1.409771e+04, 1.385200e+04, 1.360443e+04, 1.338829e+04, 1.319014e+04, 1.291914e+04, 1.271357e+04, 1.252086e+04, 1.227957e+04, 1.206314e+04, 1.183129e+04, 1.158886e+04, 1.139629e+04, 1.120200e+04, 1.094686e+04, 1.075414e+04, 1.051400e+04, 1.028986e+04, 1.008829e+04, 9.866429e+03, 9.648714e+03, 9.483429e+03, 9.272000e+03, 9.108571e+03, 8.916143e+03, 8.717714e+03, 8.523714e+03, 8.333571e+03, 8.150429e+03, 7.971143e+03, 7.775571e+03, 7.573714e+03, 7.408857e+03, 7.262857e+03, 7.113000e+03, 6.929143e+03, 6.762857e+03, 6.614429e+03, 6.491857e+03, 6.338857e+03, 6.198429e+03, 6.054571e+03, 5.950143e+03, 5.829143e+03, 5.724571e+03, 5.613143e+03, 5.503000e+03, 5.377286e+03, 5.271000e+03, 5.137857e+03, 5.029714e+03, 4.903571e+03, 4.767571e+03, 4.650143e+03, 4.542143e+03, 4.441429e+03, 4.339714e+03, 4.228429e+03, 4.129429e+03, 4.073857e+03, 3.995286e+03, 3.903000e+03, 3.816714e+03, 3.738286e+03, 3.669429e+03, 3.593714e+03, 3.503286e+03, 3.438714e+03, 3.354286e+03, 3.291286e+03, 3.201857e+03, 3.131857e+03, 3.050429e+03, 2.967143e+03, 2.882571e+03, 2.821571e+03, 2.731429e+03, 2.683429e+03, 2.609857e+03, 2.542000e+03, 2.491429e+03, 2.430429e+03, 2.356714e+03, 2.296000e+03, 2.221857e+03, 2.165857e+03, 2.118857e+03, 2.058000e+03, 2.001429e+03, 1.954857e+03, 1.906857e+03, 1.856571e+03, 1.797143e+03, 1.737000e+03, 1.673429e+03, 1.623286e+03, 1.594143e+03, 1.531857e+03, 1.478143e+03, 1.435000e+03, 1.393571e+03, 1.342857e+03, 1.287143e+03, 1.223000e+03, 1.190000e+03, 1.149286e+03, 1.109286e+03, 1.052857e+03, 1.020143e+03, 9.897143e+02, 9.464286e+02, 8.848571e+02, 8.408571e+02, 7.935714e+02, 7.555714e+02, 7.072857e+02, 6.578571e+02, 6.155714e+02, 5.791429e+02, 5.364286e+02, 4.898571e+02, 4.450000e+02, 3.991429e+02, 3.578571e+02, 3.127143e+02, 2.717143e+02, 2.282857e+02, 1.847143e+02, 1.462857e+02, 1.060000e+02, 6.533333e+01, 2.900000e+01},
    { 7.010000e+02, 2.042000e+03, 3.283000e+03, 4.445429e+03, 5.616571e+03, 6.683857e+03, 7.693571e+03, 8.616000e+03, 9.431286e+03, 1.014486e+04, 1.081971e+04, 1.137343e+04, 1.189300e+04, 1.232514e+04, 1.270843e+04, 1.308971e+04, 1.338029e+04, 1.361029e+04, 1.378929e+04, 1.393757e+04, 1.406057e+04, 1.414057e+04, 1.418314e+04, 1.425757e+04, 1.429757e+04, 1.434657e+04, 1.434743e+04, 1.431571e+04, 1.430200e+04, 1.423986e+04, 1.414057e+04, 1.405271e+04, 1.395814e+04, 1.380600e+04, 1.372900e+04, 1.358443e+04, 1.345343e+04, 1.330314e+04, 1.314643e+04, 1.295943e+04, 1.283671e+04, 1.262343e+04, 1.242686e+04, 1.220357e+04, 1.199657e+04, 1.183129e+04, 1.163514e+04, 1.142943e+04, 1.123571e+04, 1.105414e+04, 1.090400e+04, 1.073000e+04, 1.051857e+04, 1.033371e+04, 1.016514e+04, 9.991857e+03, 9.802714e+03, 9.588143e+03, 9.385286e+03, 9.208429e+03, 9.024714e+03, 8.823000e+03, 8.598143e+03, 8.396857e+03, 8.234857e+03, 8.078857e+03, 7.886143e+03, 7.734857e+03, 7.568286e+03, 7.425286e+03, 7.280429e+03, 7.123857e+03, 6.976143e+03, 6.805571e+03, 6.634714e+03, 6.486714e+03, 6.349857e+03, 6.223714e+03, 6.088571e+03, 5.949857e+03, 5.839714e+03, 5.697857e+03, 5.569857e+03, 5.454000e+03, 5.312714e+03, 5.184429e+03, 5.060286e+03, 4.951429e+03, 4.849000e+03, 4.755000e+03, 4.633714e+03, 4.538714e+03, 4.442429e+03, 4.347714e+03, 4.237571e+03, 4.133143e+03, 4.041429e+03, 3.947000e+03, 3.855143e+03, 3.761286e+03, 3.675000e+03, 3.592857e+03, 3.532571e+03, 3.442857e+03, 3.367286e+03, 3.293429e+03, 3.225857e+03, 3.149571e+03, 3.094857e+03, 3.012714e+03, 2.942286e+03, 2.881000e+03, 2.812571e+03, 2.738429e+03, 2.672857e+03, 2.589286e+03, 2.528000e+03, 2.474714e+03, 2.396857e+03, 2.328000e+03, 2.279286e+03, 2.228714e+03, 2.182714e+03, 2.127000e+03, 2.065571e+03, 2.035571e+03, 1.993571e+03, 1.948857e+03, 1.899000e+03, 1.845714e+03, 1.806143e+03, 1.772857e+03, 1.723143e+03, 1.679857e+03, 1.624714e+03, 1.579857e+03, 1.537857e+03, 1.503286e+03, 1.454571e+03, 1.411000e+03, 1.370714e+03, 1.334857e+03, 1.297857e+03, 1.270143e+03, 1.221714e+03, 1.176857e+03, 1.153286e+03, 1.119571e+03, 1.074857e+03, 1.033143e+03, 9.912857e+02, 9.520000e+02, 9.167143e+02, 8.680000e+02, 8.271429e+02, 7.985714e+02, 7.720000e+02, 7.370000e+02, 7.118571e+02, 6.728571e+02, 6.388571e+02, 6.041429e+02, 5.745714e+02, 5.371429e+02, 5.020000e+02, 4.632857e+02, 4.375714e+02, 4.075714e+02, 3.780000e+02, 3.394286e+02, 3.071429e+02, 2.752857e+02, 2.441429e+02, 2.134286e+02, 1.780000e+02, 1.472857e+02, 1.180000e+02, 8.560000e+01, 5.333333e+01, 2.200000e+01},
    { 5.710000e+02, 1.723000e+03, 2.808000e+03, 3.796571e+03, 4.776714e+03, 5.677286e+03, 6.506286e+03, 7.228571e+03, 7.888143e+03, 8.450143e+03, 8.977571e+03, 9.417571e+03, 9.811143e+03, 1.016900e+04, 1.047857e+04, 1.076657e+04, 1.100586e+04, 1.120386e+04, 1.136743e+04, 1.150029e+04, 1.161043e+04, 1.174586e+04, 1.180586e+04, 1.184700e+04, 1.186671e+04, 1.188014e+04, 1.187857e+04, 1.184443e+04, 1.175571e+04, 1.167600e+04, 1.162957e+04, 1.156014e+04, 1.147243e+04, 1.138300e+04, 1.126914e+04, 1.116529e+04, 1.102400e+04, 1.087057e+04, 1.072729e+04, 1.059757e+04, 1.041614e+04, 1.028086e+04, 1.013957e+04, 1.000871e+04, 9.871286e+03, 9.684571e+03, 9.495571e+03, 9.374571e+03, 9.188857e+03, 9.003143e+03, 8.837286e+03, 8.657143e+03, 8.498000e+03, 8.344143e+03, 8.173714e+03, 8.005429e+03, 7.855857e+03, 7.679714e+03, 7.496857e+03, 7.363286e+03, 7.215000e+03, 7.065571e+03, 6.926857e+03, 6.758000e+03, 6.655143e+03, 6.537714e+03, 6.415000e+03, 6.306571e+03, 6.145714e+03, 6.004571e+03, 5.874429e+03, 5.750714e+03, 5.605000e+03, 5.472571e+03, 5.315714e+03, 5.225429e+03, 5.105857e+03, 4.994429e+03, 4.856143e+03, 4.756857e+03, 4.641714e+03, 4.548714e+03, 4.416571e+03, 4.325286e+03, 4.243000e+03, 4.134857e+03, 4.046286e+03, 3.942286e+03, 3.854000e+03, 3.775714e+03, 3.702429e+03, 3.601429e+03, 3.528857e+03, 3.431714e+03, 3.366143e+03, 3.272429e+03, 3.193143e+03, 3.106714e+03, 3.030571e+03, 2.948429e+03, 2.890571e+03, 2.811571e+03, 2.741857e+03, 2.686143e+03, 2.621857e+03, 2.566429e+03, 2.513143e+03, 2.454143e+03, 2.404000e+03, 2.348000e+03, 2.281571e+03, 2.221143e+03, 2.175857e+03, 2.130429e+03, 2.082000e+03, 2.026143e+03, 1.986714e+03, 1.948429e+03, 1.922143e+03, 1.860143e+03, 1.819000e+03, 1.760143e+03, 1.712857e+03, 1.676000e+03, 1.636857e+03, 1.584429e+03, 1.550571e+03, 1.512000e+03, 1.486571e+03, 1.464000e+03, 1.411571e+03, 1.373286e+03, 1.326000e+03, 1.299714e+03, 1.259571e+03, 1.217000e+03, 1.176571e+03, 1.151143e+03, 1.103571e+03, 1.081714e+03, 1.040000e+03, 1.007714e+03, 9.832857e+02, 9.621429e+02, 9.350000e+02, 9.100000e+02, 8.782857e+02, 8.517143e+02, 8.195714e+02, 7.865714e+02, 7.487143e+02, 7.180000e+02, 6.927143e+02, 6.664286e+02, 6.374286e+02, 6.120000e+02, 5.844286e+02, 5.544286e+02, 5.275714e+02, 5.015714e+02, 4.745714e+02, 4.531429e+02, 4.304286e+02, 4.038571e+02, 3.814286e+02, 3.607143e+02, 3.304286e+02, 3.037143e+02, 2.762857e+02, 2.512857e+02, 2.301429e+02, 2.054286e+02, 1.770000e+02, 1.565714e+02, 1.354286e+02, 1.131429e+02, 8.600000e+01, 6.200000e+01, 4.066667e+01, 1.200000e+01},
    { 5.130000e+02, 1.440333e+03, 2.340200e+03, 3.186857e+03, 4.006571e+03, 4.764857e+03, 5.460000e+03, 6.090857e+03, 6.661571e+03, 7.198143e+03, 7.620429e+03, 8.025571e+03, 8.382429e+03, 8.677429e+03, 8.939000e+03, 9.173857e+03, 9.323571e+03, 9.495714e+03, 9.621714e+03, 9.723571e+03, 9.847143e+03, 9.881429e+03, 9.898143e+03, 9.941429e+03, 9.966857e+03, 9.922143e+03, 9.908857e+03, 9.863714e+03, 9.857714e+03, 9.834143e+03, 9.765000e+03, 9.642143e+03, 9.576143e+03, 9.484714e+03, 9.372000e+03, 9.255143e+03, 9.106857e+03, 8.984143e+03, 8.898429e+03, 8.815000e+03, 8.668857e+03, 8.532571e+03, 8.400857e+03, 8.291714e+03, 8.172000e+03, 8.043714e+03, 7.863857e+03, 7.746714e+03, 7.619429e+03, 7.489429e+03, 7.340714e+03, 7.198286e+03, 7.044143e+03, 6.917143e+03, 6.769286e+03, 6.629571e+03, 6.504714e+03, 6.384429e+03, 6.238571e+03, 6.104429e+03, 5.974429e+03, 5.860571e+03, 5.723429e+03, 5.606143e+03, 5.478714e+03, 5.357714e+03, 5.238143e+03, 5.123571e+03, 4.995714e+03, 4.889857e+03, 4.757286e+03, 4.652286e+03, 4.552429e+03, 4.461429e+03, 4.359714e+03, 4.254429e+03, 4.167429e+03, 4.077571e+03, 3.984857e+03, 3.898000e+03, 3.805143e+03, 3.704714e+03, 3.626429e+03, 3.527429e+03, 3.435143e+03, 3.364571e+03, 3.272714e+03, 3.200286e+03, 3.146857e+03, 3.055571e+03, 2.976571e+03, 2.910571e+03, 2.821143e+03, 2.763143e+03, 2.691571e+03, 2.621714e+03, 2.565286e+03, 2.515857e+03, 2.457286e+03, 2.395429e+03, 2.316143e+03, 2.255857e+03, 2.189429e+03, 2.141571e+03, 2.088714e+03, 2.041000e+03, 1.995286e+03, 1.963429e+03, 1.923429e+03, 1.891571e+03, 1.833429e+03, 1.793714e+03, 1.737857e+03, 1.697429e+03, 1.657286e+03, 1.617000e+03, 1.559714e+03, 1.550571e+03, 1.509286e+03, 1.478429e+03, 1.441429e+03, 1.397143e+03, 1.357571e+03, 1.332000e+03, 1.279286e+03, 1.240571e+03, 1.204571e+03, 1.171571e+03, 1.152143e+03, 1.125000e+03, 1.107571e+03, 1.084429e+03, 1.049429e+03, 1.027571e+03, 1.004571e+03, 9.731429e+02, 9.450000e+02, 9.100000e+02, 8.791429e+02, 8.612857e+02, 8.300000e+02, 7.965714e+02, 7.658571e+02, 7.445714e+02, 7.232857e+02, 7.094286e+02, 6.861429e+02, 6.645714e+02, 6.537143e+02, 6.314286e+02, 6.045714e+02, 5.778571e+02, 5.498571e+02, 5.324286e+02, 5.105714e+02, 4.897143e+02, 4.700000e+02, 4.535714e+02, 4.342857e+02, 4.094286e+02, 3.845714e+02, 3.654286e+02, 3.371429e+02, 3.181429e+02, 2.910000e+02, 2.727143e+02, 2.570000e+02, 2.428571e+02, 2.224286e+02, 2.085714e+02, 1.924286e+02, 1.787143e+02, 1.584286e+02, 1.377143e+02, 1.158571e+02, 9.700000e+01, 7.485714e+01, 4.940000e+01, 2.966667e+01, 1.300000e+01},
    { 4.220000e+02, 1.242333e+03, 2.028000e+03, 2.721286e+03, 3.413286e+03, 4.058143e+03, 4.646286e+03, 5.191571e+03, 5.660000e+03, 6.102143e+03, 6.477714e+03, 6.828714e+03, 7.122857e+03, 7.388571e+03, 7.597000e+03, 7.803429e+03, 7.971143e+03, 8.113286e+03, 8.225143e+03, 8.308429e+03, 8.382714e+03, 8.436429e+03, 8.462714e+03, 8.479000e+03, 8.476571e+03, 8.442429e+03, 8.433000e+03, 8.381286e+03, 8.348286e+03, 8.297000e+03, 8.232286e+03, 8.185571e+03, 8.119714e+03, 8.025571e+03, 7.932571e+03, 7.823143e+03, 7.734286e+03, 7.605143e+03, 7.484714e+03, 7.383000e+03, 7.283286e+03, 7.191429e+03, 7.077286e+03, 6.960429e+03, 6.884000e+03, 6.766857e+03, 6.642429e+03, 6.507286e+03, 6.404000e+03, 6.283571e+03, 6.148286e+03, 6.029000e+03, 5.905714e+03, 5.786571e+03, 5.680143e+03, 5.548429e+03, 5.436000e+03, 5.333143e+03, 5.220143e+03, 5.124714e+03, 5.029286e+03, 4.939857e+03, 4.812714e+03, 4.702286e+03, 4.600571e+03, 4.475143e+03, 4.374714e+03, 4.267714e+03, 4.146143e+03, 4.068857e+03, 3.968143e+03, 3.852571e+03, 3.777429e+03, 3.665429e+03, 3.575429e+03, 3.497714e+03, 3.393143e+03, 3.321286e+03, 3.257286e+03, 3.164429e+03, 3.088000e+03, 3.006714e+03, 2.928714e+03, 2.864143e+03, 2.796857e+03, 2.741714e+03, 2.675429e+03, 2.603000e+03, 2.544286e+03, 2.490000e+03, 2.434857e+03, 2.363286e+03, 2.304857e+03, 2.249000e+03, 2.205429e+03, 2.150286e+03, 2.095000e+03, 2.036857e+03, 2.009714e+03, 1.951571e+03, 1.897000e+03, 1.850429e+03, 1.789429e+03, 1.749571e+03, 1.726000e+03, 1.669429e+03, 1.628429e+03, 1.604714e+03, 1.565429e+03, 1.555714e+03, 1.523714e+03, 1.475000e+03, 1.444857e+03, 1.408714e+03, 1.359286e+03, 1.332429e+03, 1.292143e+03, 1.254286e+03, 1.229429e+03, 1.189571e+03, 1.156286e+03, 1.132714e+03, 1.103571e+03, 1.080286e+03, 1.056000e+03, 1.026286e+03, 1.008571e+03, 9.797143e+02, 9.585714e+02, 9.330000e+02, 9.072857e+02, 8.758571e+02, 8.552857e+02, 8.285714e+02, 8.130000e+02, 7.974286e+02, 7.694286e+02, 7.428571e+02, 7.210000e+02, 6.950000e+02, 6.685714e+02, 6.538571e+02, 6.198571e+02, 6.040000e+02, 5.890000e+02, 5.730000e+02, 5.572857e+02, 5.472857e+02, 5.225714e+02, 5.151429e+02, 4.950000e+02, 4.695714e+02, 4.534286e+02, 4.288571e+02, 4.090000e+02, 3.935714e+02, 3.711429e+02, 3.544286e+02, 3.398571e+02, 3.204286e+02, 3.091429e+02, 2.898571e+02, 2.718571e+02, 2.598571e+02, 2.405714e+02, 2.251429e+02, 2.075714e+02, 1.884286e+02, 1.734286e+02, 1.604286e+02, 1.412857e+02, 1.277143e+02, 1.124286e+02, 9.671429e+01, 8.271429e+01, 6.871429e+01, 5.185714e+01, 3.880000e+01, 2.833333e+01, 5.000000e+00},
    { 3.300000e+02, 1.048667e+03, 1.716800e+03, 2.338857e+03, 2.966000e+03, 3.532714e+03, 4.029000e+03, 4.511000e+03, 4.933571e+03, 5.303000e+03, 5.622714e+03, 5.897571e+03, 6.147000e+03, 6.370571e+03, 6.574857e+03, 6.714143e+03, 6.843857e+03, 6.975429e+03, 7.089429e+03, 7.178714e+03, 7.256857e+03, 7.270143e+03, 7.313143e+03, 7.336429e+03, 7.350429e+03, 7.319000e+03, 7.300143e+03, 7.262571e+03, 7.223857e+03, 7.167714e+03, 7.101429e+03, 7.014571e+03, 6.940000e+03, 6.845000e+03, 6.756143e+03, 6.688571e+03, 6.609857e+03, 6.512714e+03, 6.415714e+03, 6.343286e+03, 6.240571e+03, 6.140714e+03, 6.017714e+03, 5.933857e+03, 5.838429e+03, 5.740571e+03, 5.618429e+03, 5.525429e+03, 5.426429e+03, 5.327286e+03, 5.195857e+03, 5.077143e+03, 4.976857e+03, 4.873286e+03, 4.770714e+03, 4.685571e+03, 4.587857e+03, 4.499714e+03, 4.413143e+03, 4.324143e+03, 4.212714e+03, 4.112571e+03, 4.003714e+03, 3.907857e+03, 3.822571e+03, 3.712429e+03, 3.624429e+03, 3.541571e+03, 3.463286e+03, 3.377857e+03, 3.302000e+03, 3.201857e+03, 3.142571e+03, 3.052143e+03, 2.991286e+03, 2.913000e+03, 2.852714e+03, 2.789286e+03, 2.720857e+03, 2.658143e+03, 2.605571e+03, 2.532571e+03, 2.462571e+03, 2.389000e+03, 2.321286e+03, 2.274286e+03, 2.218857e+03, 2.157857e+03, 2.095571e+03, 2.054857e+03, 2.012571e+03, 1.967143e+03, 1.912714e+03, 1.863286e+03, 1.820857e+03, 1.795143e+03, 1.756143e+03, 1.713286e+03, 1.665286e+03, 1.625429e+03, 1.581000e+03, 1.544000e+03, 1.503857e+03, 1.458000e+03, 1.421714e+03, 1.395857e+03, 1.364000e+03, 1.333571e+03, 1.306857e+03, 1.272286e+03, 1.245857e+03, 1.217000e+03, 1.182429e+03, 1.141000e+03, 1.116143e+03, 1.076714e+03, 1.046571e+03, 1.022286e+03, 9.808571e+02, 9.592857e+02, 9.557143e+02, 9.214286e+02, 9.012857e+02, 8.777143e+02, 8.530000e+02, 8.321429e+02, 8.098571e+02, 7.760000e+02, 7.614286e+02, 7.398571e+02, 7.272857e+02, 7.047143e+02, 6.941429e+02, 6.742857e+02, 6.585714e+02, 6.441429e+02, 6.240000e+02, 6.014286e+02, 5.834286e+02, 5.687143e+02, 5.438571e+02, 5.322857e+02, 5.085714e+02, 4.950000e+02, 4.714286e+02, 4.545714e+02, 4.302857e+02, 4.187143e+02, 3.994286e+02, 3.858571e+02, 3.721429e+02, 3.621429e+02, 3.502857e+02, 3.428571e+02, 3.305714e+02, 3.188571e+02, 3.087143e+02, 2.902857e+02, 2.750000e+02, 2.632857e+02, 2.507143e+02, 2.340000e+02, 2.167143e+02, 1.992857e+02, 1.871429e+02, 1.765714e+02, 1.608571e+02, 1.482857e+02, 1.398571e+02, 1.305714e+02, 1.201429e+02, 1.084286e+02, 9.600000e+01, 8.428571e+01, 6.957143e+01, 5.528571e+01, 4.157143e+01, 2.900000e+01, 1.733333e+01, 9.000000e+00},
    { 3.070000e+02, 9.430000e+02, 1.556200e+03, 2.108143e+03, 2.629714e+03, 3.093143e+03, 3.545143e+03, 3.964714e+03, 4.317000e+03, 4.641286e+03, 4.906714e+03, 5.150571e+03, 5.403143e+03, 5.594000e+03, 5.743286e+03, 5.873143e+03, 5.959286e+03, 6.091429e+03, 6.189857e+03, 6.229000e+03, 6.267857e+03, 6.276857e+03, 6.309857e+03, 6.342571e+03, 6.347429e+03, 6.340000e+03, 6.321571e+03, 6.307143e+03, 6.272714e+03, 6.217714e+03, 6.170429e+03, 6.088286e+03, 6.030714e+03, 5.950571e+03, 5.869143e+03, 5.827143e+03, 5.749429e+03, 5.659857e+03, 5.568000e+03, 5.463714e+03, 5.397429e+03, 5.310143e+03, 5.207857e+03, 5.123143e+03, 5.027000e+03, 4.921714e+03, 4.837571e+03, 4.736143e+03, 4.651571e+03, 4.563714e+03, 4.460857e+03, 4.378143e+03, 4.285429e+03, 4.194571e+03, 4.113429e+03, 4.011571e+03, 3.909286e+03, 3.808286e+03, 3.720571e+03, 3.659000e+03, 3.578571e+03, 3.493429e+03, 3.414714e+03, 3.344429e+03, 3.284857e+03, 3.213571e+03, 3.104286e+03, 3.022000e+03, 2.960429e+03, 2.888143e+03, 2.818000e+03, 2.748857e+03, 2.671143e+03, 2.625429e+03, 2.560143e+03, 2.487286e+03, 2.424571e+03, 2.354143e+03, 2.292000e+03, 2.220571e+03, 2.162286e+03, 2.100571e+03, 2.045286e+03, 1.993429e+03, 1.944143e+03, 1.907429e+03, 1.866571e+03, 1.816286e+03, 1.776429e+03, 1.741143e+03, 1.706571e+03, 1.666000e+03, 1.600714e+03, 1.557286e+03, 1.512143e+03, 1.475714e+03, 1.445000e+03, 1.393286e+03, 1.358286e+03, 1.335143e+03, 1.299429e+03, 1.270714e+03, 1.237286e+03, 1.192143e+03, 1.169857e+03, 1.143714e+03, 1.120714e+03, 1.103286e+03, 1.074857e+03, 1.046286e+03, 1.022143e+03, 9.964286e+02, 9.671429e+02, 9.385714e+02, 9.165714e+02, 8.914286e+02, 8.815714e+02, 8.484286e+02, 8.171429e+02, 7.987143e+02, 7.688571e+02, 7.478571e+02, 7.340000e+02, 6.955714e+02, 6.851429e+02, 6.704286e+02, 6.500000e+02, 6.334286e+02, 6.181429e+02, 5.981429e+02, 5.944286e+02, 5.738571e+02, 5.601429e+02, 5.494286e+02, 5.437143e+02, 5.247143e+02, 5.088571e+02, 4.882857e+02, 4.758571e+02, 4.667143e+02, 4.491429e+02, 4.292857e+02, 4.174286e+02, 4.075714e+02, 3.950000e+02, 3.804286e+02, 3.681429e+02, 3.540000e+02, 3.437143e+02, 3.290000e+02, 3.142857e+02, 3.075714e+02, 2.967143e+02, 2.798571e+02, 2.720000e+02, 2.607143e+02, 2.485714e+02, 2.347143e+02, 2.178571e+02, 2.040000e+02, 1.925714e+02, 1.800000e+02, 1.704286e+02, 1.620000e+02, 1.560000e+02, 1.452857e+02, 1.371429e+02, 1.294286e+02, 1.217143e+02, 1.095714e+02, 9.757143e+01, 8.842857e+01, 7.728571e+01, 6.771429e+01, 5.642857e+01, 4.314286e+01, 3.200000e+01, 2.160000e+01, 1.333333e+01, 4.000000e+00},
    { 3.020000e+02, 8.516667e+02, 1.375600e+03, 1.836000e+03, 2.301286e+03, 2.729429e+03, 3.128429e+03, 3.491143e+03, 3.805429e+03, 4.094857e+03, 4.332857e+03, 4.548714e+03, 4.740857e+03, 4.913571e+03, 5.045714e+03, 5.163000e+03, 5.261429e+03, 5.344571e+03, 5.403571e+03, 5.455714e+03, 5.470143e+03, 5.510286e+03, 5.510714e+03, 5.518571e+03, 5.508429e+03, 5.494857e+03, 5.473286e+03, 5.451571e+03, 5.385429e+03, 5.352571e+03, 5.298143e+03, 5.251000e+03, 5.182286e+03, 5.123000e+03, 5.059000e+03, 4.991143e+03, 4.923857e+03, 4.849286e+03, 4.794714e+03, 4.734857e+03, 4.671714e+03, 4.583857e+03, 4.511000e+03, 4.433714e+03, 4.369429e+03, 4.267000e+03, 4.194143e+03, 4.102286e+03, 4.018857e+03, 3.937429e+03, 3.837714e+03, 3.740286e+03, 3.657143e+03, 3.573286e+03, 3.490000e+03, 3.416286e+03, 3.339143e+03, 3.283000e+03, 3.219429e+03, 3.153000e+03, 3.074286e+03, 3.000429e+03, 2.938714e+03, 2.867286e+03, 2.790000e+03, 2.715000e+03, 2.656143e+03, 2.586143e+03, 2.526143e+03, 2.443571e+03, 2.386714e+03, 2.341714e+03, 2.284571e+03, 2.204571e+03, 2.159286e+03, 2.106000e+03, 2.056143e+03, 1.992857e+03, 1.927000e+03, 1.873714e+03, 1.852429e+03, 1.799286e+03, 1.752000e+03, 1.721429e+03, 1.684143e+03, 1.637000e+03, 1.593857e+03, 1.541143e+03, 1.497571e+03, 1.458286e+03, 1.419714e+03, 1.374714e+03, 1.349571e+03, 1.318143e+03, 1.287429e+03, 1.261857e+03, 1.221857e+03, 1.183143e+03, 1.163143e+03, 1.135714e+03, 1.101143e+03, 1.065143e+03, 1.035286e+03, 1.007286e+03, 9.770000e+02, 9.567143e+02, 9.341429e+02, 9.087143e+02, 8.901429e+02, 8.658571e+02, 8.497143e+02, 8.371429e+02, 8.111429e+02, 7.877143e+02, 7.712857e+02, 7.531429e+02, 7.370000e+02, 7.170000e+02, 6.894286e+02, 6.747143e+02, 6.531429e+02, 6.394286e+02, 6.235714e+02, 6.042857e+02, 5.904286e+02, 5.810000e+02, 5.612857e+02, 5.434286e+02, 5.242857e+02, 5.007143e+02, 4.831429e+02, 4.651429e+02, 4.488571e+02, 4.374286e+02, 4.335714e+02, 4.222857e+02, 4.171429e+02, 4.102857e+02, 3.985714e+02, 3.888571e+02, 3.747143e+02, 3.592857e+02, 3.440000e+02, 3.374286e+02, 3.264286e+02, 3.164286e+02, 3.030000e+02, 2.948571e+02, 2.862857e+02, 2.778571e+02, 2.670000e+02, 2.544286e+02, 2.422857e+02, 2.360000e+02, 2.237143e+02, 2.155714e+02, 2.088571e+02, 1.925714e+02, 1.851429e+02, 1.785714e+02, 1.697143e+02, 1.614286e+02, 1.500000e+02, 1.432857e+02, 1.362857e+02, 1.284286e+02, 1.184286e+02, 1.068571e+02, 1.011429e+02, 9.214286e+01, 8.128571e+01, 7.300000e+01, 6.228571e+01, 5.342857e+01, 4.728571e+01, 3.614286e+01, 2.842857e+01, 2.060000e+01, 1.266667e+01, 6.000000e+00},
    { 2.760000e+02, 7.466667e+02, 1.208200e+03, 1.626857e+03, 2.046143e+03, 2.425857e+03, 2.779571e+03, 3.103571e+03, 3.370429e+03, 3.603571e+03, 3.847714e+03, 4.028143e+03, 4.191000e+03, 4.335429e+03, 4.461714e+03, 4.569000e+03, 4.666714e+03, 4.713143e+03, 4.774286e+03, 4.819714e+03, 4.837286e+03, 4.848429e+03, 4.852143e+03, 4.857429e+03, 4.864000e+03, 4.842714e+03, 4.819429e+03, 4.803571e+03, 4.782000e+03, 4.766857e+03, 4.697000e+03, 4.632000e+03, 4.602857e+03, 4.551429e+03, 4.488286e+03, 4.408429e+03, 4.322857e+03, 4.262000e+03, 4.207429e+03, 4.124286e+03, 4.060143e+03, 3.985429e+03, 3.912286e+03, 3.851143e+03, 3.796857e+03, 3.709857e+03, 3.650857e+03, 3.583429e+03, 3.516571e+03, 3.457571e+03, 3.369000e+03, 3.301714e+03, 3.222429e+03, 3.137571e+03, 3.061429e+03, 2.995286e+03, 2.923429e+03, 2.864571e+03, 2.790571e+03, 2.732571e+03, 2.668429e+03, 2.590286e+03, 2.533714e+03, 2.467143e+03, 2.402571e+03, 2.332714e+03, 2.275571e+03, 2.212429e+03, 2.157143e+03, 2.088143e+03, 2.055286e+03, 2.006571e+03, 1.965571e+03, 1.923429e+03, 1.871143e+03, 1.838000e+03, 1.794286e+03, 1.721571e+03, 1.671429e+03, 1.621857e+03, 1.575286e+03, 1.538429e+03, 1.498286e+03, 1.466000e+03, 1.429286e+03, 1.409571e+03, 1.370286e+03, 1.330429e+03, 1.292143e+03, 1.253571e+03, 1.213143e+03, 1.189571e+03, 1.155286e+03, 1.121571e+03, 1.090714e+03, 1.061000e+03, 1.029000e+03, 1.003000e+03, 9.657143e+02, 9.324286e+02, 9.190000e+02, 9.104286e+02, 8.914286e+02, 8.622857e+02, 8.338571e+02, 8.192857e+02, 7.997143e+02, 7.814286e+02, 7.527143e+02, 7.264286e+02, 7.238571e+02, 7.060000e+02, 6.805714e+02, 6.628571e+02, 6.455714e+02, 6.307143e+02, 6.137143e+02, 5.887143e+02, 5.750000e+02, 5.658571e+02, 5.418571e+02, 5.252857e+02, 5.067143e+02, 4.932857e+02, 4.832857e+02, 4.722857e+02, 4.602857e+02, 4.575714e+02, 4.422857e+02, 4.340000e+02, 4.217143e+02, 4.024286e+02, 3.888571e+02, 3.775714e+02, 3.644286e+02, 3.572857e+02, 3.411429e+02, 3.371429e+02, 3.270000e+02, 3.198571e+02, 3.100000e+02, 2.998571e+02, 2.844286e+02, 2.765714e+02, 2.652857e+02, 2.590000e+02, 2.457143e+02, 2.385714e+02, 2.304286e+02, 2.228571e+02, 2.147143e+02, 2.081429e+02, 1.990000e+02, 1.932857e+02, 1.864286e+02, 1.782857e+02, 1.700000e+02, 1.641429e+02, 1.562857e+02, 1.504286e+02, 1.428571e+02, 1.334286e+02, 1.254286e+02, 1.198571e+02, 1.115714e+02, 1.024286e+02, 9.528571e+01, 8.957143e+01, 8.342857e+01, 7.800000e+01, 7.157143e+01, 6.357143e+01, 5.457143e+01, 4.785714e+01, 3.985714e+01, 3.271429e+01, 2.442857e+01, 1.680000e+01, 1.266667e+01, 5.000000e+00},
    { 2.310000e+02, 6.773333e+02, 1.100800e+03, 1.474143e+03, 1.850857e+03, 2.188286e+03, 2.505143e+03, 2.788714e+03, 3.037857e+03, 3.244857e+03, 3.426571e+03, 3.596000e+03, 3.741143e+03, 3.844429e+03, 3.930286e+03, 4.027857e+03, 4.096714e+03, 4.154571e+03, 4.206714e+03, 4.230571e+03, 4.274000e+03, 4.309714e+03, 4.309857e+03, 4.315571e+03, 4.317429e+03, 4.288857e+03, 4.282857e+03, 4.255714e+03, 4.197000e+03, 4.148143e+03, 4.117286e+03, 4.079714e+03, 4.043857e+03, 3.992714e+03, 3.942714e+03, 3.892429e+03, 3.868143e+03, 3.814286e+03, 3.749143e+03, 3.669286e+03, 3.605857e+03, 3.542143e+03, 3.491286e+03, 3.398286e+03, 3.319857e+03, 3.252857e+03, 3.186143e+03, 3.106429e+03, 3.037714e+03, 2.952000e+03, 2.899286e+03, 2.834714e+03, 2.757857e+03, 2.699571e+03, 2.653857e+03, 2.585571e+03, 2.540714e+03, 2.466143e+03, 2.424571e+03, 2.370857e+03, 2.306857e+03, 2.244571e+03, 2.186857e+03, 2.130286e+03, 2.089714e+03, 2.021000e+03, 1.976857e+03, 1.927000e+03, 1.883429e+03, 1.842286e+03, 1.787429e+03, 1.728000e+03, 1.694429e+03, 1.641000e+03, 1.593143e+03, 1.557429e+03, 1.515429e+03, 1.490571e+03, 1.452429e+03, 1.398143e+03, 1.369571e+03, 1.343714e+03, 1.289429e+03, 1.236857e+03, 1.194143e+03, 1.176714e+03, 1.156286e+03, 1.124000e+03, 1.095857e+03, 1.077000e+03, 1.063143e+03, 1.024000e+03, 9.831429e+02, 9.441429e+02, 9.141429e+02, 8.841429e+02, 8.558571e+02, 8.288571e+02, 8.158571e+02, 7.967143e+02, 7.805714e+02, 7.570000e+02, 7.417143e+02, 7.188571e+02, 6.985714e+02, 6.810000e+02, 6.640000e+02, 6.498571e+02, 6.361429e+02, 6.138571e+02, 6.025714e+02, 5.921429e+02, 5.761429e+02, 5.552857e+02, 5.347143e+02, 5.220000e+02, 5.120000e+02, 4.995714e+02, 4.848571e+02, 4.664286e+02, 4.572857e+02, 4.517143e+02, 4.398571e+02, 4.281429e+02, 4.132857e+02, 4.015714e+02, 3.968571e+02, 3.847143e+02, 3.708571e+02, 3.617143e+02, 3.521429e+02, 3.441429e+02, 3.320000e+02, 3.211429e+02, 3.148571e+02, 3.097143e+02, 3.004286e+02, 2.920000e+02, 2.822857e+02, 2.767143e+02, 2.681429e+02, 2.561429e+02, 2.448571e+02, 2.342857e+02, 2.225714e+02, 2.154286e+02, 2.061429e+02, 2.005714e+02, 1.955714e+02, 1.877143e+02, 1.872857e+02, 1.871429e+02, 1.792857e+02, 1.731429e+02, 1.630000e+02, 1.554286e+02, 1.512857e+02, 1.372857e+02, 1.264286e+02, 1.252857e+02, 1.170000e+02, 1.120000e+02, 1.097143e+02, 1.030000e+02, 1.011429e+02, 9.557143e+01, 8.457143e+01, 8.014286e+01, 7.371429e+01, 6.585714e+01, 5.885714e+01, 5.157143e+01, 4.428571e+01, 3.928571e+01, 3.328571e+01, 2.685714e+01, 2.057143e+01, 1.480000e+01, 8.333333e+00, 4.000000e+00},
    { 2.040000e+02, 5.950000e+02, 9.716000e+02, 1.296714e+03, 1.612857e+03, 1.926143e+03, 2.200571e+03, 2.440286e+03, 2.667000e+03, 2.878429e+03, 3.045143e+03, 3.219000e+03, 3.354143e+03, 3.462000e+03, 3.576571e+03, 3.643714e+03, 3.697286e+03, 3.755286e+03, 3.788857e+03, 3.814000e+03, 3.845857e+03, 3.859857e+03, 3.856143e+03, 3.848571e+03, 3.852571e+03, 3.835571e+03, 3.805286e+03, 3.768286e+03, 3.725286e+03, 3.697429e+03, 3.666000e+03, 3.624286e+03, 3.590143e+03, 3.537143e+03, 3.488571e+03, 3.447286e+03, 3.380429e+03, 3.319000e+03, 3.249429e+03, 3.185429e+03, 3.128143e+03, 3.077000e+03, 3.019571e+03, 2.977714e+03, 2.914286e+03, 2.864857e+03, 2.800429e+03, 2.748429e+03, 2.695286e+03, 2.634571e+03, 2.562286e+03, 2.519857e+03, 2.460000e+03, 2.419000e+03, 2.361857e+03, 2.303714e+03, 2.261000e+03, 2.219571e+03, 2.163429e+03, 2.093714e+03, 2.028286e+03, 1.975429e+03, 1.921857e+03, 1.859143e+03, 1.800286e+03, 1.748857e+03, 1.709286e+03, 1.668571e+03, 1.624857e+03, 1.574571e+03, 1.534857e+03, 1.498429e+03, 1.461000e+03, 1.429571e+03, 1.388429e+03, 1.352714e+03, 1.326000e+03, 1.294571e+03, 1.252429e+03, 1.227429e+03, 1.185429e+03, 1.156000e+03, 1.131857e+03, 1.100000e+03, 1.067571e+03, 1.052429e+03, 1.027429e+03, 1.009429e+03, 9.790000e+02, 9.535714e+02, 9.241429e+02, 8.967143e+02, 8.655714e+02, 8.281429e+02, 7.975714e+02, 7.752857e+02, 7.530000e+02, 7.355714e+02, 7.071429e+02, 6.901429e+02, 6.748571e+02, 6.605714e+02, 6.407143e+02, 6.231429e+02, 6.010000e+02, 5.892857e+02, 5.682857e+02, 5.504286e+02, 5.394286e+02, 5.211429e+02, 5.038571e+02, 4.942857e+02, 4.917143e+02, 4.778571e+02, 4.672857e+02, 4.465714e+02, 4.378571e+02, 4.278571e+02, 4.181429e+02, 4.065714e+02, 3.968571e+02, 3.885714e+02, 3.807143e+02, 3.735714e+02, 3.598571e+02, 3.500000e+02, 3.307143e+02, 3.262857e+02, 3.221429e+02, 3.170000e+02, 3.072857e+02, 3.001429e+02, 2.900000e+02, 2.841429e+02, 2.717143e+02, 2.591429e+02, 2.505714e+02, 2.385714e+02, 2.340000e+02, 2.214286e+02, 2.121429e+02, 2.065714e+02, 1.974286e+02, 1.867143e+02, 1.841429e+02, 1.761429e+02, 1.762857e+02, 1.751429e+02, 1.708571e+02, 1.680000e+02, 1.611429e+02, 1.567143e+02, 1.470000e+02, 1.394286e+02, 1.302857e+02, 1.252857e+02, 1.201429e+02, 1.172857e+02, 1.110000e+02, 1.071429e+02, 1.024286e+02, 9.885714e+01, 9.257143e+01, 8.342857e+01, 7.871429e+01, 7.242857e+01, 6.914286e+01, 6.271429e+01, 5.771429e+01, 5.200000e+01, 4.728571e+01, 4.114286e+01, 3.814286e+01, 3.200000e+01, 2.671429e+01, 2.142857e+01, 1.642857e+01, 1.280000e+01, 6.000000e+00, 1.000000e+00},
    { 1.720000e+02, 5.613333e+02, 8.848000e+02, 1.172000e+03, 1.471000e+03, 1.744143e+03, 1.979143e+03, 2.203429e+03, 2.410571e+03, 2.596857e+03, 2.751571e+03, 2.893000e+03, 3.011143e+03, 3.119571e+03, 3.214571e+03, 3.280429e+03, 3.328000e+03, 3.375000e+03, 3.421000e+03, 3.433857e+03, 3.437143e+03, 3.445286e+03, 3.434429e+03, 3.448000e+03, 3.440143e+03, 3.396714e+03, 3.388000e+03, 3.366000e+03, 3.326857e+03, 3.304000e+03, 3.266286e+03, 3.237000e+03, 3.210000e+03, 3.158286e+03, 3.120857e+03, 3.088143e+03, 3.030429e+03, 2.984571e+03, 2.915857e+03, 2.859000e+03, 2.811000e+03, 2.750857e+03, 2.694286e+03, 2.646429e+03, 2.578429e+03, 2.531143e+03, 2.481429e+03, 2.428143e+03, 2.389429e+03, 2.332714e+03, 2.274000e+03, 2.225143e+03, 2.156000e+03, 2.100286e+03, 2.054857e+03, 1.999714e+03, 1.942571e+03, 1.892857e+03, 1.854857e+03, 1.821000e+03, 1.789857e+03, 1.743286e+03, 1.688429e+03, 1.654857e+03, 1.618571e+03, 1.571143e+03, 1.532571e+03, 1.482429e+03, 1.436000e+03, 1.403857e+03, 1.362714e+03, 1.322286e+03, 1.286714e+03, 1.246286e+03, 1.208286e+03, 1.175714e+03, 1.140714e+03, 1.108857e+03, 1.078714e+03, 1.048286e+03, 1.024857e+03, 9.955714e+02, 9.784286e+02, 9.504286e+02, 9.258571e+02, 9.067143e+02, 8.782857e+02, 8.494286e+02, 8.298571e+02, 8.017143e+02, 7.831429e+02, 7.564286e+02, 7.308571e+02, 7.082857e+02, 6.875714e+02, 6.574286e+02, 6.361429e+02, 6.147143e+02, 6.012857e+02, 5.800000e+02, 5.675714e+02, 5.531429e+02, 5.487143e+02, 5.341429e+02, 5.254286e+02, 5.144286e+02, 5.054286e+02, 4.888571e+02, 4.785714e+02, 4.650000e+02, 4.568571e+02, 4.441429e+02, 4.234286e+02, 4.094286e+02, 3.932857e+02, 3.850000e+02, 3.710000e+02, 3.555714e+02, 3.427143e+02, 3.362857e+02, 3.260000e+02, 3.204286e+02, 3.094286e+02, 2.961429e+02, 2.877143e+02, 2.765714e+02, 2.690000e+02, 2.640000e+02, 2.601429e+02, 2.517143e+02, 2.488571e+02, 2.427143e+02, 2.424286e+02, 2.352857e+02, 2.298571e+02, 2.238571e+02, 2.172857e+02, 2.110000e+02, 2.064286e+02, 2.001429e+02, 1.922857e+02, 1.851429e+02, 1.780000e+02, 1.712857e+02, 1.661429e+02, 1.597143e+02, 1.518571e+02, 1.465714e+02, 1.421429e+02, 1.372857e+02, 1.312857e+02, 1.300000e+02, 1.294286e+02, 1.251429e+02, 1.230000e+02, 1.165714e+02, 1.118571e+02, 1.092857e+02, 1.034286e+02, 9.242857e+01, 8.757143e+01, 8.114286e+01, 7.800000e+01, 7.385714e+01, 6.757143e+01, 6.200000e+01, 5.942857e+01, 5.428571e+01, 5.085714e+01, 4.571429e+01, 4.100000e+01, 3.785714e+01, 3.242857e+01, 2.871429e+01, 2.471429e+01, 2.000000e+01, 1.600000e+01, 1.080000e+01, 6.333333e+00, 4.000000e+00},
    { 1.650000e+02, 5.016667e+02, 8.036000e+02, 1.074143e+03, 1.346714e+03, 1.583143e+03, 1.824286e+03, 2.018714e+03, 2.198000e+03, 2.366000e+03, 2.527714e+03, 2.647286e+03, 2.755143e+03, 2.826571e+03, 2.889571e+03, 2.955000e+03, 2.998286e+03, 3.004714e+03, 3.025571e+03, 3.062286e+03, 3.071857e+03, 3.095714e+03, 3.094571e+03, 3.082571e+03, 3.076571e+03, 3.059714e+03, 3.030143e+03, 3.015000e+03, 2.998286e+03, 2.979714e+03, 2.949286e+03, 2.915286e+03, 2.887000e+03, 2.839429e+03, 2.793714e+03, 2.739429e+03, 2.678000e+03, 2.627571e+03, 2.583571e+03, 2.539857e+03, 2.507714e+03, 2.464571e+03, 2.409286e+03, 2.344429e+03, 2.313571e+03, 2.264571e+03, 2.216714e+03, 2.152429e+03, 2.101000e+03, 2.062429e+03, 2.048857e+03, 1.994857e+03, 1.931714e+03, 1.877571e+03, 1.848429e+03, 1.809429e+03, 1.766714e+03, 1.708000e+03, 1.664571e+03, 1.636714e+03, 1.597000e+03, 1.545571e+03, 1.490286e+03, 1.444429e+03, 1.412286e+03, 1.376571e+03, 1.334143e+03, 1.300571e+03, 1.262571e+03, 1.232857e+03, 1.194429e+03, 1.152714e+03, 1.118143e+03, 1.092571e+03, 1.058286e+03, 1.035571e+03, 1.005429e+03, 9.741429e+02, 9.551429e+02, 9.211429e+02, 8.977143e+02, 8.761429e+02, 8.464286e+02, 8.242857e+02, 8.078571e+02, 7.758571e+02, 7.594286e+02, 7.401429e+02, 7.135714e+02, 6.920000e+02, 6.728571e+02, 6.482857e+02, 6.352857e+02, 6.138571e+02, 5.890000e+02, 5.768571e+02, 5.654286e+02, 5.465714e+02, 5.347143e+02, 5.204286e+02, 5.072857e+02, 4.960000e+02, 4.794286e+02, 4.600000e+02, 4.422857e+02, 4.272857e+02, 4.170000e+02, 4.068571e+02, 3.931429e+02, 3.848571e+02, 3.725714e+02, 3.690000e+02, 3.620000e+02, 3.478571e+02, 3.332857e+02, 3.202857e+02, 3.117143e+02, 3.077143e+02, 3.030000e+02, 2.998571e+02, 2.934286e+02, 2.908571e+02, 2.871429e+02, 2.762857e+02, 2.680000e+02, 2.601429e+02, 2.478571e+02, 2.425714e+02, 2.330000e+02, 2.240000e+02, 2.207143e+02, 2.154286e+02, 2.044286e+02, 1.972857e+02, 1.877143e+02, 1.838571e+02, 1.825714e+02, 1.782857e+02, 1.712857e+02, 1.677143e+02, 1.652857e+02, 1.612857e+02, 1.551429e+02, 1.480000e+02, 1.381429e+02, 1.341429e+02, 1.304286e+02, 1.250000e+02, 1.194286e+02, 1.178571e+02, 1.141429e+02, 1.078571e+02, 1.024286e+02, 9.742857e+01, 9.057143e+01, 8.700000e+01, 8.357143e+01, 7.685714e+01, 7.628571e+01, 7.457143e+01, 7.300000e+01, 7.271429e+01, 6.871429e+01, 6.271429e+01, 5.771429e+01, 5.471429e+01, 4.814286e+01, 4.085714e+01, 3.600000e+01, 3.400000e+01, 3.128571e+01, 3.142857e+01, 2.742857e+01, 2.457143e+01, 2.342857e+01, 1.885714e+01, 1.442857e+01, 8.200000e+00, 6.000000e+00, 2.000000e+00},
    { 1.410000e+02, 4.290000e+02, 7.152000e+02, 9.770000e+02, 1.223571e+03, 1.445429e+03, 1.667429e+03, 1.857143e+03, 2.002286e+03, 2.121143e+03, 2.238143e+03, 2.344286e+03, 2.445857e+03, 2.515429e+03, 2.576571e+03, 2.636571e+03, 2.702143e+03, 2.743429e+03, 2.779286e+03, 2.791286e+03, 2.794143e+03, 2.800429e+03, 2.810714e+03, 2.809571e+03, 2.807571e+03, 2.780143e+03, 2.767143e+03, 2.754429e+03, 2.726857e+03, 2.703143e+03, 2.663571e+03, 2.629714e+03, 2.597429e+03, 2.559429e+03, 2.520000e+03, 2.482143e+03, 2.433571e+03, 2.377429e+03, 2.329571e+03, 2.282286e+03, 2.229000e+03, 2.190286e+03, 2.134571e+03, 2.092000e+03, 2.044286e+03, 1.992714e+03, 1.953143e+03, 1.903857e+03, 1.848571e+03, 1.818857e+03, 1.764000e+03, 1.733286e+03, 1.685714e+03, 1.650000e+03, 1.612429e+03, 1.573429e+03, 1.515286e+03, 1.484571e+03, 1.442429e+03, 1.416857e+03, 1.378714e+03, 1.341571e+03, 1.305286e+03, 1.279429e+03, 1.246000e+03, 1.208857e+03, 1.165857e+03, 1.127143e+03, 1.100286e+03, 1.063857e+03, 1.035714e+03, 1.006857e+03, 9.730000e+02, 9.475714e+02, 9.170000e+02, 8.890000e+02, 8.717143e+02, 8.508571e+02, 8.272857e+02, 8.085714e+02, 7.910000e+02, 7.675714e+02, 7.461429e+02, 7.194286e+02, 6.887143e+02, 6.621429e+02, 6.461429e+02, 6.227143e+02, 6.091429e+02, 5.865714e+02, 5.700000e+02, 5.644286e+02, 5.558571e+02, 5.438571e+02, 5.335714e+02, 5.162857e+02, 5.085714e+02, 4.935714e+02, 4.684286e+02, 4.518571e+02, 4.308571e+02, 4.141429e+02, 4.052857e+02, 3.901429e+02, 3.830000e+02, 3.731429e+02, 3.618571e+02, 3.585714e+02, 3.480000e+02, 3.325714e+02, 3.252857e+02, 3.218571e+02, 3.165714e+02, 3.075714e+02, 2.925714e+02, 2.858571e+02, 2.827143e+02, 2.705714e+02, 2.614286e+02, 2.544286e+02, 2.440000e+02, 2.368571e+02, 2.322857e+02, 2.230000e+02, 2.227143e+02, 2.145714e+02, 2.044286e+02, 2.044286e+02, 2.051429e+02, 1.971429e+02, 1.947143e+02, 1.880000e+02, 1.810000e+02, 1.797143e+02, 1.711429e+02, 1.635714e+02, 1.624286e+02, 1.597143e+02, 1.535714e+02, 1.495714e+02, 1.428571e+02, 1.397143e+02, 1.371429e+02, 1.295714e+02, 1.212857e+02, 1.158571e+02, 1.095714e+02, 1.057143e+02, 1.011429e+02, 9.557143e+01, 9.171429e+01, 8.828571e+01, 8.342857e+01, 7.985714e+01, 7.942857e+01, 7.742857e+01, 7.214286e+01, 6.814286e+01, 6.700000e+01, 6.585714e+01, 6.242857e+01, 5.757143e+01, 5.342857e+01, 5.157143e+01, 4.885714e+01, 4.300000e+01, 4.100000e+01, 3.957143e+01, 3.571429e+01, 3.285714e+01, 2.942857e+01, 2.757143e+01, 2.514286e+01, 2.085714e+01, 1.714286e+01, 1.428571e+01, 1.085714e+01, 7.000000e+00, 4.000000e+00, 1.000000e+00},
    { 1.370000e+02, 4.130000e+02, 6.570000e+02, 8.715714e+02, 1.097429e+03, 1.300429e+03, 1.479571e+03, 1.639286e+03, 1.802143e+03, 1.937143e+03, 2.047571e+03, 2.148143e+03, 2.241143e+03, 2.327857e+03, 2.389857e+03, 2.421143e+03, 2.469000e+03, 2.512571e+03, 2.541857e+03, 2.550714e+03, 2.558571e+03, 2.569571e+03, 2.584857e+03, 2.585000e+03, 2.563143e+03, 2.542429e+03, 2.513429e+03, 2.473429e+03, 2.436429e+03, 2.414143e+03, 2.364714e+03, 2.329000e+03, 2.294143e+03, 2.264571e+03, 2.235429e+03, 2.208000e+03, 2.157429e+03, 2.125286e+03, 2.104571e+03, 2.059857e+03, 2.027143e+03, 1.985714e+03, 1.933857e+03, 1.892857e+03, 1.849000e+03, 1.796000e+03, 1.747714e+03, 1.697429e+03, 1.659714e+03, 1.623714e+03, 1.577714e+03, 1.548143e+03, 1.509143e+03, 1.471286e+03, 1.440143e+03, 1.399714e+03, 1.362286e+03, 1.324714e+03, 1.286571e+03, 1.246857e+03, 1.217429e+03, 1.185000e+03, 1.153714e+03, 1.126714e+03, 1.104143e+03, 1.070143e+03, 1.041857e+03, 1.017714e+03, 9.897143e+02, 9.715714e+02, 9.460000e+02, 9.160000e+02, 8.885714e+02, 8.654286e+02, 8.438571e+02, 8.137143e+02, 7.927143e+02, 7.664286e+02, 7.428571e+02, 7.215714e+02, 6.998571e+02, 6.702857e+02, 6.565714e+02, 6.261429e+02, 6.070000e+02, 5.905714e+02, 5.690000e+02, 5.590000e+02, 5.481429e+02, 5.245714e+02, 5.118571e+02, 4.968571e+02, 4.825714e+02, 4.742857e+02, 4.558571e+02, 4.418571e+02, 4.307143e+02, 4.134286e+02, 4.040000e+02, 3.940000e+02, 3.835714e+02, 3.701429e+02, 3.582857e+02, 3.534286e+02, 3.478571e+02, 3.370000e+02, 3.271429e+02, 3.155714e+02, 3.081429e+02, 3.004286e+02, 2.878571e+02, 2.821429e+02, 2.717143e+02, 2.655714e+02, 2.600000e+02, 2.514286e+02, 2.438571e+02, 2.367143e+02, 2.255714e+02, 2.172857e+02, 2.077143e+02, 2.011429e+02, 1.950000e+02, 1.910000e+02, 1.867143e+02, 1.808571e+02, 1.798571e+02, 1.764286e+02, 1.715714e+02, 1.652857e+02, 1.590000e+02, 1.557143e+02, 1.538571e+02, 1.505714e+02, 1.495714e+02, 1.464286e+02, 1.424286e+02, 1.364286e+02, 1.291429e+02, 1.255714e+02, 1.204286e+02, 1.131429e+02, 1.087143e+02, 1.071429e+02, 1.051429e+02, 1.080000e+02, 1.012857e+02, 9.471429e+01, 9.142857e+01, 8.742857e+01, 8.442857e+01, 8.571429e+01, 7.585714e+01, 7.557143e+01, 7.528571e+01, 7.085714e+01, 6.742857e+01, 6.314286e+01, 5.628571e+01, 5.500000e+01, 5.357143e+01, 5.057143e+01, 4.842857e+01, 4.728571e+01, 4.442857e+01, 4.071429e+01, 3.871429e+01, 3.457143e+01, 3.071429e+01, 2.857143e+01, 2.500000e+01, 2.371429e+01, 2.071429e+01, 1.757143e+01, 1.342857e+01, 1.071429e+01, 8.000000e+00, 5.000000e+00, 2.000000e+00, 2.000000e+00},
    { 1.290000e+02, 3.833333e+02, 6.058000e+02, 8.274286e+02, 1.028286e+03, 1.207714e+03, 1.385714e+03, 1.538429e+03, 1.677571e+03, 1.800143e+03, 1.882000e+03, 1.970000e+03, 2.056143e+03, 2.107857e+03, 2.157571e+03, 2.197429e+03, 2.227857e+03, 2.255857e+03, 2.270286e+03, 2.285143e+03, 2.291714e+03, 2.304000e+03, 2.305714e+03, 2.281000e+03, 2.273714e+03, 2.260857e+03, 2.239143e+03, 2.213286e+03, 2.200857e+03, 2.161143e+03, 2.141571e+03, 2.119857e+03, 2.098286e+03, 2.066571e+03, 2.035000e+03, 1.982429e+03, 1.948714e+03, 1.904143e+03, 1.867429e+03, 1.832714e+03, 1.789143e+03, 1.761000e+03, 1.713143e+03, 1.680143e+03, 1.659857e+03, 1.629714e+03, 1.581143e+03, 1.544000e+03, 1.499143e+03, 1.472286e+03, 1.440143e+03, 1.383857e+03, 1.328714e+03, 1.299000e+03, 1.263571e+03, 1.238143e+03, 1.207143e+03, 1.173429e+03, 1.149286e+03, 1.137000e+03, 1.113000e+03, 1.086571e+03, 1.052143e+03, 1.014429e+03, 9.830000e+02, 9.575714e+02, 9.151429e+02, 8.805714e+02, 8.490000e+02, 8.268571e+02, 8.097143e+02, 7.890000e+02, 7.621429e+02, 7.471429e+02, 7.260000e+02, 7.082857e+02, 6.848571e+02, 6.637143e+02, 6.344286e+02, 6.198571e+02, 6.038571e+02, 5.918571e+02, 5.741429e+02, 5.575714e+02, 5.452857e+02, 5.351429e+02, 5.165714e+02, 4.960000e+02, 4.747143e+02, 4.630000e+02, 4.521429e+02, 4.338571e+02, 4.252857e+02, 4.158571e+02, 4.035714e+02, 3.941429e+02, 3.787143e+02, 3.642857e+02, 3.548571e+02, 3.402857e+02, 3.331429e+02, 3.214286e+02, 3.100000e+02, 2.997143e+02, 2.938571e+02, 2.824286e+02, 2.775714e+02, 2.682857e+02, 2.647143e+02, 2.577143e+02, 2.544286e+02, 2.434286e+02, 2.388571e+02, 2.327143e+02, 2.260000e+02, 2.210000e+02, 2.181429e+02, 2.100000e+02, 2.068571e+02, 2.038571e+02, 1.930000e+02, 1.862857e+02, 1.795714e+02, 1.714286e+02, 1.690000e+02, 1.644286e+02, 1.567143e+02, 1.534286e+02, 1.505714e+02, 1.497143e+02, 1.464286e+02, 1.392857e+02, 1.360000e+02, 1.332857e+02, 1.311429e+02, 1.261429e+02, 1.222857e+02, 1.188571e+02, 1.167143e+02, 1.110000e+02, 1.080000e+02, 1.052857e+02, 1.012857e+02, 9.814286e+01, 9.500000e+01, 9.157143e+01, 9.000000e+01, 8.728571e+01, 8.457143e+01, 8.242857e+01, 7.414286e+01, 7.028571e+01, 6.714286e+01, 6.428571e+01, 5.842857e+01, 5.514286e+01, 5.014286e+01, 5.128571e+01, 4.900000e+01, 4.628571e+01, 4.414286e+01, 4.528571e+01, 4.257143e+01, 4.171429e+01, 3.914286e+01, 3.642857e+01, 3.371429e+01, 3.028571e+01, 2.600000e+01, 2.385714e+01, 2.128571e+01, 1.914286e+01, 1.685714e+01, 1.485714e+01, 1.271429e+01, 1.014286e+01, 8.000000e+00, 4.800000e+00, 3.333333e+00, 3.000000e+00},
    { 1.310000e+02, 3.473333e+02, 5.600000e+02, 7.408571e+02, 9.127143e+02, 1.077857e+03, 1.234714e+03, 1.356286e+03, 1.484429e+03, 1.584143e+03, 1.678000e+03, 1.767571e+03, 1.828286e+03, 1.887143e+03, 1.949571e+03, 1.982429e+03, 2.013286e+03, 2.039143e+03, 2.057286e+03, 2.079714e+03, 2.080000e+03, 2.070143e+03, 2.067857e+03, 2.060714e+03, 2.048571e+03, 2.026143e+03, 2.007714e+03, 1.989429e+03, 1.965857e+03, 1.947571e+03, 1.919143e+03, 1.893429e+03, 1.883286e+03, 1.852143e+03, 1.829429e+03, 1.804429e+03, 1.758286e+03, 1.733857e+03, 1.699000e+03, 1.662429e+03, 1.643286e+03, 1.601286e+03, 1.569714e+03, 1.541143e+03, 1.507143e+03, 1.474571e+03, 1.429286e+03, 1.374857e+03, 1.347714e+03, 1.300286e+03, 1.268857e+03, 1.223286e+03, 1.182143e+03, 1.150714e+03, 1.124857e+03, 1.084286e+03, 1.055571e+03, 1.019143e+03, 1.008714e+03, 9.931429e+02, 9.670000e+02, 9.408571e+02, 9.120000e+02, 8.948571e+02, 8.774286e+02, 8.467143e+02, 8.135714e+02, 7.928571e+02, 7.644286e+02, 7.445714e+02, 7.201429e+02, 6.970000e+02, 6.710000e+02, 6.575714e+02, 6.390000e+02, 6.267143e+02, 6.120000e+02, 5.951429e+02, 5.794286e+02, 5.620000e+02, 5.358571e+02, 5.197143e+02, 5.021429e+02, 4.854286e+02, 4.687143e+02, 4.572857e+02, 4.431429e+02, 4.351429e+02, 4.191429e+02, 4.061429e+02, 3.912857e+02, 3.804286e+02, 3.680000e+02, 3.541429e+02, 3.467143e+02, 3.340000e+02, 3.212857e+02, 3.148571e+02, 3.074286e+02, 2.977143e+02, 2.957143e+02, 2.855714e+02, 2.841429e+02, 2.772857e+02, 2.684286e+02, 2.592857e+02, 2.461429e+02, 2.381429e+02, 2.318571e+02, 2.185714e+02, 2.120000e+02, 2.060000e+02, 2.017143e+02, 1.994286e+02, 1.947143e+02, 1.851429e+02, 1.830000e+02, 1.788571e+02, 1.760000e+02, 1.688571e+02, 1.635714e+02, 1.568571e+02, 1.565714e+02, 1.512857e+02, 1.475714e+02, 1.437143e+02, 1.422857e+02, 1.374286e+02, 1.331429e+02, 1.298571e+02, 1.248571e+02, 1.205714e+02, 1.167143e+02, 1.122857e+02, 1.087143e+02, 1.040000e+02, 1.000000e+02, 9.871429e+01, 9.557143e+01, 9.071429e+01, 8.771429e+01, 8.642857e+01, 8.585714e+01, 8.242857e+01, 7.928571e+01, 7.714286e+01, 7.571429e+01, 7.228571e+01, 6.928571e+01, 6.642857e+01, 6.414286e+01, 6.100000e+01, 5.828571e+01, 5.400000e+01, 5.271429e+01, 5.242857e+01, 5.000000e+01, 4.957143e+01, 4.571429e+01, 4.328571e+01, 4.200000e+01, 3.871429e+01, 3.542857e+01, 3.428571e+01, 3.071429e+01, 3.028571e+01, 2.914286e+01, 2.714286e+01, 2.571429e+01, 2.371429e+01, 2.100000e+01, 1.957143e+01, 1.771429e+01, 1.442857e+01, 1.242857e+01, 1.028571e+01, 7.428571e+00, 4.800000e+00, 2.666667e+00, 2.000000e+00},
    { 9.800000e+01, 3.190000e+02, 5.176000e+02, 6.770000e+02, 8.455714e+02, 9.978571e+02, 1.119000e+03, 1.246571e+03, 1.361143e+03, 1.453857e+03, 1.556571e+03, 1.628429e+03, 1.695571e+03, 1.770571e+03, 1.803857e+03, 1.825714e+03, 1.858571e+03, 1.860429e+03, 1.885429e+03, 1.889429e+03, 1.885714e+03, 1.899429e+03, 1.901857e+03, 1.889143e+03, 1.888286e+03, 1.859000e+03, 1.844571e+03, 1.816429e+03, 1.780857e+03, 1.752857e+03, 1.734000e+03, 1.699286e+03, 1.679571e+03, 1.649143e+03, 1.629000e+03, 1.607857e+03, 1.572429e+03, 1.537857e+03, 1.512143e+03, 1.480143e+03, 1.445857e+03, 1.413000e+03, 1.385857e+03, 1.369000e+03, 1.347857e+03, 1.321571e+03, 1.290143e+03, 1.261714e+03, 1.235714e+03, 1.203286e+03, 1.163571e+03, 1.135571e+03, 1.105143e+03, 1.080571e+03, 1.053000e+03, 1.015857e+03, 9.854286e+02, 9.658571e+02, 9.268571e+02, 8.914286e+02, 8.667143e+02, 8.427143e+02, 8.302857e+02, 8.021429e+02, 7.717143e+02, 7.522857e+02, 7.334286e+02, 7.111429e+02, 6.825714e+02, 6.577143e+02, 6.350000e+02, 6.138571e+02, 5.952857e+02, 5.794286e+02, 5.551429e+02, 5.505714e+02, 5.325714e+02, 5.190000e+02, 5.100000e+02, 4.870000e+02, 4.714286e+02, 4.565714e+02, 4.357143e+02, 4.228571e+02, 4.118571e+02, 3.952857e+02, 3.894286e+02, 3.771429e+02, 3.665714e+02, 3.572857e+02, 3.462857e+02, 3.364286e+02, 3.314286e+02, 3.194286e+02, 3.075714e+02, 2.980000e+02, 2.928571e+02, 2.860000e+02, 2.821429e+02, 2.750000e+02, 2.684286e+02, 2.635714e+02, 2.617143e+02, 2.538571e+02, 2.467143e+02, 2.354286e+02, 2.197143e+02, 2.145714e+02, 2.068571e+02, 1.982857e+02, 1.937143e+02, 1.870000e+02, 1.844286e+02, 1.840000e+02, 1.805714e+02, 1.777143e+02, 1.738571e+02, 1.654286e+02, 1.584286e+02, 1.504286e+02, 1.465714e+02, 1.417143e+02, 1.365714e+02, 1.294286e+02, 1.247143e+02, 1.242857e+02, 1.218571e+02, 1.161429e+02, 1.140000e+02, 1.105714e+02, 1.125714e+02, 1.091429e+02, 1.040000e+02, 9.742857e+01, 9.514286e+01, 9.371429e+01, 8.971429e+01, 8.600000e+01, 8.457143e+01, 8.328571e+01, 8.485714e+01, 7.914286e+01, 7.100000e+01, 6.914286e+01, 6.685714e+01, 6.514286e+01, 6.485714e+01, 6.314286e+01, 6.385714e+01, 6.542857e+01, 6.371429e+01, 6.057143e+01, 5.928571e+01, 5.285714e+01, 4.900000e+01, 4.657143e+01, 4.385714e+01, 4.428571e+01, 4.157143e+01, 3.828571e+01, 3.728571e+01, 3.671429e+01, 3.528571e+01, 3.414286e+01, 3.185714e+01, 3.071429e+01, 2.971429e+01, 2.842857e+01, 2.500000e+01, 2.342857e+01, 2.071429e+01, 1.814286e+01, 1.514286e+01, 1.171429e+01, 1.000000e+01, 8.285714e+00, 6.000000e+00, 3.200000e+00, 3.000000e+00, 0.000000e+00},
    { 8.200000e+01, 2.803333e+02, 4.548000e+02, 6.060000e+02, 7.695714e+02, 9.142857e+02, 1.047571e+03, 1.166143e+03, 1.266714e+03, 1.364857e+03, 1.445429e+03, 1.506000e+03, 1.554000e+03, 1.596714e+03, 1.644714e+03, 1.687857e+03, 1.701286e+03, 1.720714e+03, 1.736429e+03, 1.758857e+03, 1.770857e+03, 1.763000e+03, 1.746286e+03, 1.743000e+03, 1.727857e+03, 1.710286e+03, 1.690286e+03, 1.667143e+03, 1.650000e+03, 1.623000e+03, 1.598571e+03, 1.578286e+03, 1.556286e+03, 1.528571e+03, 1.497143e+03, 1.472286e+03, 1.453571e+03, 1.426429e+03, 1.391857e+03, 1.353286e+03, 1.319000e+03, 1.291143e+03, 1.244857e+03, 1.219000e+03, 1.193857e+03, 1.166857e+03, 1.150143e+03, 1.116000e+03, 1.081714e+03, 1.065143e+03, 1.029286e+03, 9.927143e+02, 9.641429e+02, 9.315714e+02, 9.090000e+02, 8.800000e+02, 8.547143e+02, 8.261429e+02, 8.058571e+02, 7.854286e+02, 7.525714e+02, 7.308571e+02, 7.101429e+02, 6.847143e+02, 6.708571e+02, 6.470000e+02, 6.242857e+02, 6.078571e+02, 5.880000e+02, 5.742857e+02, 5.534286e+02, 5.361429e+02, 5.248571e+02, 5.097143e+02, 5.012857e+02, 4.905714e+02, 4.760000e+02, 4.640000e+02, 4.440000e+02, 4.254286e+02, 4.172857e+02, 3.978571e+02, 3.877143e+02, 3.741429e+02, 3.574286e+02, 3.465714e+02, 3.345714e+02, 3.204286e+02, 3.150000e+02, 2.981429e+02, 2.954286e+02, 2.905714e+02, 2.858571e+02, 2.795714e+02, 2.755714e+02, 2.681429e+02, 2.637143e+02, 2.470000e+02, 2.392857e+02, 2.312857e+02, 2.254286e+02, 2.130000e+02, 2.075714e+02, 1.987143e+02, 1.997143e+02, 1.914286e+02, 1.912857e+02, 1.852857e+02, 1.830000e+02, 1.754286e+02, 1.682857e+02, 1.628571e+02, 1.600000e+02, 1.511429e+02, 1.517143e+02, 1.447143e+02, 1.412857e+02, 1.420000e+02, 1.391429e+02, 1.342857e+02, 1.287143e+02, 1.248571e+02, 1.210000e+02, 1.180000e+02, 1.130000e+02, 1.061429e+02, 1.032857e+02, 1.022857e+02, 9.842857e+01, 9.900000e+01, 9.700000e+01, 9.442857e+01, 9.228571e+01, 8.885714e+01, 8.342857e+01, 7.957143e+01, 7.528571e+01, 7.200000e+01, 7.100000e+01, 6.971429e+01, 6.942857e+01, 6.857143e+01, 6.614286e+01, 6.385714e+01, 6.228571e+01, 5.828571e+01, 5.628571e+01, 5.571429e+01, 5.371429e+01, 4.928571e+01, 4.785714e+01, 4.728571e+01, 4.657143e+01, 4.557143e+01, 4.328571e+01, 4.271429e+01, 4.185714e+01, 3.914286e+01, 3.671429e+01, 3.371429e+01, 3.142857e+01, 2.785714e+01, 2.500000e+01, 2.428571e+01, 2.414286e+01, 2.171429e+01, 2.042857e+01, 1.842857e+01, 1.671429e+01, 1.471429e+01, 1.257143e+01, 1.028571e+01, 8.142857e+00, 7.142857e+00, 5.714286e+00, 4.714286e+00, 3.714286e+00, 2.200000e+00, 1.333333e+00, 0.000000e+00},
    { 9.700000e+01, 2.703333e+02, 4.396000e+02, 5.830000e+02, 7.242857e+02, 8.610000e+02, 9.847143e+02, 1.102143e+03, 1.184000e+03, 1.261143e+03, 1.330286e+03, 1.390857e+03, 1.438571e+03, 1.476286e+03, 1.497000e+03, 1.535286e+03, 1.561286e+03, 1.584571e+03, 1.591714e+03, 1.608714e+03, 1.605000e+03, 1.605714e+03, 1.594429e+03, 1.580571e+03, 1.558000e+03, 1.552286e+03, 1.531571e+03, 1.513429e+03, 1.484429e+03, 1.461429e+03, 1.448571e+03, 1.425857e+03, 1.401857e+03, 1.370143e+03, 1.354571e+03, 1.337143e+03, 1.315286e+03, 1.281571e+03, 1.255143e+03, 1.231857e+03, 1.201286e+03, 1.170857e+03, 1.144429e+03, 1.110571e+03, 1.092429e+03, 1.060286e+03, 1.025857e+03, 1.004143e+03, 9.711429e+02, 9.494286e+02, 9.214286e+02, 8.910000e+02, 8.647143e+02, 8.275714e+02, 7.958571e+02, 7.711429e+02, 7.427143e+02, 7.295714e+02, 7.085714e+02, 6.954286e+02, 6.917143e+02, 6.707143e+02, 6.490000e+02, 6.337143e+02, 6.077143e+02, 5.820000e+02, 5.661429e+02, 5.450000e+02, 5.351429e+02, 5.220000e+02, 5.071429e+02, 5.008571e+02, 4.941429e+02, 4.802857e+02, 4.708571e+02, 4.587143e+02, 4.464286e+02, 4.275714e+02, 4.094286e+02, 3.915714e+02, 3.770000e+02, 3.584286e+02, 3.485714e+02, 3.370000e+02, 3.271429e+02, 3.148571e+02, 3.084286e+02, 2.972857e+02, 2.880000e+02, 2.741429e+02, 2.651429e+02, 2.561429e+02, 2.494286e+02, 2.398571e+02, 2.321429e+02, 2.251429e+02, 2.172857e+02, 2.155714e+02, 2.128571e+02, 2.074286e+02, 2.012857e+02, 1.955714e+02, 1.895714e+02, 1.885714e+02, 1.790000e+02, 1.702857e+02, 1.664286e+02, 1.624286e+02, 1.565714e+02, 1.538571e+02, 1.460000e+02, 1.418571e+02, 1.385714e+02, 1.318571e+02, 1.285714e+02, 1.267143e+02, 1.242857e+02, 1.190000e+02, 1.167143e+02, 1.135714e+02, 1.110000e+02, 1.060000e+02, 1.022857e+02, 9.628571e+01, 9.657143e+01, 9.357143e+01, 9.128571e+01, 9.057143e+01, 9.085714e+01, 8.828571e+01, 8.742857e+01, 8.371429e+01, 8.014286e+01, 7.800000e+01, 7.514286e+01, 7.214286e+01, 7.014286e+01, 6.842857e+01, 6.871429e+01, 6.714286e+01, 6.385714e+01, 6.057143e+01, 5.885714e+01, 5.728571e+01, 5.314286e+01, 5.028571e+01, 4.985714e+01, 4.871429e+01, 4.585714e+01, 4.285714e+01, 4.200000e+01, 4.185714e+01, 3.871429e+01, 3.542857e+01, 3.300000e+01, 3.357143e+01, 3.185714e+01, 2.985714e+01, 2.800000e+01, 2.757143e+01, 2.728571e+01, 2.614286e+01, 2.385714e+01, 2.314286e+01, 2.228571e+01, 2.085714e+01, 2.000000e+01, 1.857143e+01, 1.728571e+01, 1.557143e+01, 1.371429e+01, 1.142857e+01, 1.028571e+01, 8.571429e+00, 6.857143e+00, 5.857143e+00, 4.857143e+00, 3.400000e+00, 2.333333e+00, 0.000000e+00},
    { 7.700000e+01, 2.230000e+02, 3.850000e+02, 5.165714e+02, 6.517143e+02, 7.790000e+02, 8.937143e+02, 9.948571e+02, 1.074000e+03, 1.148429e+03, 1.210286e+03, 1.263000e+03, 1.308571e+03, 1.349857e+03, 1.369000e+03, 1.397571e+03, 1.421286e+03, 1.433714e+03, 1.447143e+03, 1.446429e+03, 1.445143e+03, 1.447286e+03, 1.439571e+03, 1.431000e+03, 1.422143e+03, 1.400143e+03, 1.384571e+03, 1.363857e+03, 1.351714e+03, 1.344286e+03, 1.319571e+03, 1.307286e+03, 1.292286e+03, 1.279143e+03, 1.267857e+03, 1.238429e+03, 1.202000e+03, 1.171143e+03, 1.142857e+03, 1.112571e+03, 1.085286e+03, 1.048714e+03, 1.014857e+03, 9.892857e+02, 9.667143e+02, 9.402857e+02, 9.158571e+02, 8.905714e+02, 8.580000e+02, 8.470000e+02, 8.252857e+02, 7.992857e+02, 7.778571e+02, 7.585714e+02, 7.324286e+02, 7.182857e+02, 6.940000e+02, 6.688571e+02, 6.591429e+02, 6.378571e+02, 6.215714e+02, 6.058571e+02, 5.895714e+02, 5.747143e+02, 5.634286e+02, 5.392857e+02, 5.245714e+02, 5.090000e+02, 4.868571e+02, 4.681429e+02, 4.540000e+02, 4.375714e+02, 4.277143e+02, 4.095714e+02, 3.894286e+02, 3.805714e+02, 3.720000e+02, 3.588571e+02, 3.485714e+02, 3.371429e+02, 3.321429e+02, 3.255714e+02, 3.144286e+02, 3.088571e+02, 3.035714e+02, 2.922857e+02, 2.852857e+02, 2.765714e+02, 2.661429e+02, 2.615714e+02, 2.522857e+02, 2.428571e+02, 2.337143e+02, 2.255714e+02, 2.145714e+02, 2.105714e+02, 2.051429e+02, 1.980000e+02, 1.937143e+02, 1.932857e+02, 1.827143e+02, 1.785714e+02, 1.694286e+02, 1.637143e+02, 1.578571e+02, 1.514286e+02, 1.441429e+02, 1.437143e+02, 1.422857e+02, 1.417143e+02, 1.367143e+02, 1.330000e+02, 1.264286e+02, 1.215714e+02, 1.182857e+02, 1.132857e+02, 1.091429e+02, 1.034286e+02, 9.985714e+01, 9.814286e+01, 9.428571e+01, 9.242857e+01, 8.757143e+01, 8.342857e+01, 8.100000e+01, 7.742857e+01, 7.685714e+01, 7.471429e+01, 7.200000e+01, 7.142857e+01, 7.042857e+01, 6.957143e+01, 6.928571e+01, 6.428571e+01, 6.428571e+01, 6.285714e+01, 6.000000e+01, 5.771429e+01, 5.557143e+01, 5.414286e+01, 5.271429e+01, 5.142857e+01, 4.814286e+01, 4.671429e+01, 4.557143e+01, 4.328571e+01, 4.014286e+01, 3.928571e+01, 3.671429e+01, 3.428571e+01, 3.257143e+01, 3.085714e+01, 3.157143e+01, 3.085714e+01, 2.900000e+01, 2.871429e+01, 3.014286e+01, 2.885714e+01, 2.828571e+01, 2.628571e+01, 2.528571e+01, 2.371429e+01, 2.128571e+01, 1.900000e+01, 1.814286e+01, 1.614286e+01, 1.471429e+01, 1.357143e+01, 1.342857e+01, 1.300000e+01, 1.271429e+01, 1.242857e+01, 1.142857e+01, 1.042857e+01, 8.857143e+00, 7.285714e+00, 5.571429e+00, 3.200000e+00, 2.000000e+00, 0.000000e+00},
    { 7.800000e+01, 2.373333e+02, 3.688000e+02, 4.958571e+02, 6.210000e+02, 7.380000e+02, 8.290000e+02, 9.180000e+02, 1.002571e+03, 1.067571e+03, 1.127143e+03, 1.175429e+03, 1.210857e+03, 1.249000e+03, 1.277857e+03, 1.298857e+03, 1.307571e+03, 1.308143e+03, 1.318857e+03, 1.324571e+03, 1.328286e+03, 1.324857e+03, 1.324857e+03, 1.331714e+03, 1.329000e+03, 1.321143e+03, 1.307571e+03, 1.284571e+03, 1.259714e+03, 1.232143e+03, 1.209429e+03, 1.183714e+03, 1.159286e+03, 1.139857e+03, 1.121857e+03, 1.109000e+03, 1.096714e+03, 1.068000e+03, 1.044857e+03, 1.014857e+03, 9.862857e+02, 9.600000e+02, 9.302857e+02, 8.974286e+02, 8.807143e+02, 8.587143e+02, 8.262857e+02, 8.068571e+02, 7.884286e+02, 7.695714e+02, 7.482857e+02, 7.195714e+02, 7.072857e+02, 6.985714e+02, 6.772857e+02, 6.548571e+02, 6.305714e+02, 6.082857e+02, 5.915714e+02, 5.621429e+02, 5.395714e+02, 5.287143e+02, 5.117143e+02, 4.980000e+02, 4.800000e+02, 4.707143e+02, 4.665714e+02, 4.540000e+02, 4.318571e+02, 4.164286e+02, 4.020000e+02, 3.944286e+02, 3.758571e+02, 3.600000e+02, 3.481429e+02, 3.371429e+02, 3.307143e+02, 3.225714e+02, 3.125714e+02, 3.022857e+02, 2.941429e+02, 2.865714e+02, 2.815714e+02, 2.715714e+02, 2.584286e+02, 2.518571e+02, 2.452857e+02, 2.367143e+02, 2.278571e+02, 2.171429e+02, 2.111429e+02, 2.057143e+02, 1.974286e+02, 1.932857e+02, 1.860000e+02, 1.847143e+02, 1.808571e+02, 1.731429e+02, 1.738571e+02, 1.694286e+02, 1.660000e+02, 1.588571e+02, 1.510000e+02, 1.462857e+02, 1.437143e+02, 1.362857e+02, 1.308571e+02, 1.257143e+02, 1.242857e+02, 1.224286e+02, 1.198571e+02, 1.157143e+02, 1.160000e+02, 1.162857e+02, 1.115714e+02, 1.072857e+02, 1.034286e+02, 9.942857e+01, 9.714286e+01, 9.071429e+01, 8.714286e+01, 8.400000e+01, 8.285714e+01, 8.057143e+01, 7.800000e+01, 7.371429e+01, 7.071429e+01, 6.814286e+01, 6.585714e+01, 6.571429e+01, 6.200000e+01, 5.942857e+01, 5.742857e+01, 5.714286e+01, 5.571429e+01, 5.528571e+01, 5.200000e+01, 5.100000e+01, 4.942857e+01, 4.942857e+01, 4.842857e+01, 4.600000e+01, 4.442857e+01, 4.200000e+01, 4.128571e+01, 4.057143e+01, 3.885714e+01, 3.742857e+01, 3.585714e+01, 3.385714e+01, 3.342857e+01, 3.028571e+01, 2.985714e+01, 2.885714e+01, 2.742857e+01, 2.728571e+01, 2.600000e+01, 2.414286e+01, 2.385714e+01, 2.285714e+01, 2.200000e+01, 2.157143e+01, 1.971429e+01, 1.885714e+01, 1.871429e+01, 1.771429e+01, 1.585714e+01, 1.428571e+01, 1.171429e+01, 1.000000e+01, 9.142857e+00, 7.142857e+00, 6.285714e+00, 5.285714e+00, 4.428571e+00, 3.571429e+00, 2.857143e+00, 2.000000e+00, 1.000000e+00, 0.000000e+00},
    { 6.400000e+01, 2.200000e+02, 3.574000e+02, 4.650000e+02, 5.808571e+02, 6.851429e+02, 7.752857e+02, 8.577143e+02, 9.371429e+02, 1.011571e+03, 1.059000e+03, 1.105857e+03, 1.141143e+03, 1.170286e+03, 1.188857e+03, 1.193429e+03, 1.202286e+03, 1.210429e+03, 1.212857e+03, 1.223714e+03, 1.219714e+03, 1.213857e+03, 1.207714e+03, 1.203571e+03, 1.206571e+03, 1.189714e+03, 1.163143e+03, 1.150143e+03, 1.147857e+03, 1.146000e+03, 1.121429e+03, 1.096571e+03, 1.078714e+03, 1.058429e+03, 1.047429e+03, 1.018857e+03, 9.914286e+02, 9.648571e+02, 9.418571e+02, 9.201429e+02, 9.005714e+02, 8.738571e+02, 8.525714e+02, 8.280000e+02, 8.090000e+02, 7.885714e+02, 7.714286e+02, 7.471429e+02, 7.248571e+02, 7.081429e+02, 6.837143e+02, 6.671429e+02, 6.402857e+02, 6.167143e+02, 6.037143e+02, 5.858571e+02, 5.672857e+02, 5.501429e+02, 5.270000e+02, 5.172857e+02, 5.048571e+02, 4.892857e+02, 4.748571e+02, 4.510000e+02, 4.382857e+02, 4.342857e+02, 4.171429e+02, 4.027143e+02, 3.897143e+02, 3.767143e+02, 3.692857e+02, 3.570000e+02, 3.390000e+02, 3.294286e+02, 3.182857e+02, 3.042857e+02, 2.947143e+02, 2.858571e+02, 2.777143e+02, 2.654286e+02, 2.554286e+02, 2.487143e+02, 2.451429e+02, 2.358571e+02, 2.255714e+02, 2.195714e+02, 2.187143e+02, 2.135714e+02, 2.081429e+02, 2.001429e+02, 1.970000e+02, 1.904286e+02, 1.795714e+02, 1.702857e+02, 1.662857e+02, 1.601429e+02, 1.548571e+02, 1.484286e+02, 1.441429e+02, 1.442857e+02, 1.391429e+02, 1.324286e+02, 1.267143e+02, 1.251429e+02, 1.190000e+02, 1.140000e+02, 1.085714e+02, 1.110000e+02, 1.100000e+02, 1.064286e+02, 1.017143e+02, 1.010000e+02, 9.985714e+01, 9.514286e+01, 8.785714e+01, 8.314286e+01, 8.214286e+01, 8.042857e+01, 7.757143e+01, 7.642857e+01, 7.642857e+01, 7.442857e+01, 7.228571e+01, 6.871429e+01, 6.471429e+01, 6.342857e+01, 6.071429e+01, 5.857143e+01, 5.685714e+01, 5.685714e+01, 5.642857e+01, 5.528571e+01, 5.085714e+01, 4.942857e+01, 4.700000e+01, 4.671429e+01, 4.614286e+01, 4.585714e+01, 4.557143e+01, 4.671429e+01, 4.428571e+01, 4.328571e+01, 4.285714e+01, 3.914286e+01, 3.714286e+01, 3.385714e+01, 3.400000e+01, 3.357143e+01, 3.200000e+01, 2.900000e+01, 2.900000e+01, 2.814286e+01, 2.842857e+01, 2.485714e+01, 2.314286e+01, 2.200000e+01, 2.157143e+01, 2.057143e+01, 1.942857e+01, 1.857143e+01, 1.771429e+01, 1.628571e+01, 1.471429e+01, 1.400000e+01, 1.300000e+01, 1.257143e+01, 1.085714e+01, 9.285714e+00, 8.857143e+00, 8.714286e+00, 7.285714e+00, 6.857143e+00, 5.857143e+00, 4.857143e+00, 4.571429e+00, 3.571429e+00, 2.571429e+00, 2.000000e+00, 6.666667e-01, 0.000000e+00},
    { 7.900000e+01, 1.966667e+02, 3.172000e+02, 4.158571e+02, 5.225714e+02, 6.221429e+02, 7.167143e+02, 7.911429e+02, 8.482857e+02, 9.084286e+02, 9.670000e+02, 1.008429e+03, 1.041286e+03, 1.061286e+03, 1.092143e+03, 1.109857e+03, 1.120000e+03, 1.111857e+03, 1.116429e+03, 1.112143e+03, 1.113714e+03, 1.108000e+03, 1.105286e+03, 1.097571e+03, 1.104429e+03, 1.097429e+03, 1.087714e+03, 1.085571e+03, 1.055429e+03, 1.033286e+03, 1.029571e+03, 1.005143e+03, 9.844286e+02, 9.747143e+02, 9.357143e+02, 9.390000e+02, 9.230000e+02, 8.905714e+02, 8.675714e+02, 8.410000e+02, 8.137143e+02, 7.975714e+02, 7.727143e+02, 7.538571e+02, 7.401429e+02, 7.285714e+02, 7.152857e+02, 6.998571e+02, 6.851429e+02, 6.632857e+02, 6.527143e+02, 6.311429e+02, 6.102857e+02, 5.861429e+02, 5.614286e+02, 5.391429e+02, 5.208571e+02, 5.022857e+02, 4.832857e+02, 4.618571e+02, 4.508571e+02, 4.307143e+02, 4.188571e+02, 4.012857e+02, 3.841429e+02, 3.734286e+02, 3.615714e+02, 3.527143e+02, 3.458571e+02, 3.278571e+02, 3.180000e+02, 3.107143e+02, 2.988571e+02, 2.884286e+02, 2.757143e+02, 2.697143e+02, 2.631429e+02, 2.584286e+02, 2.490000e+02, 2.454286e+02, 2.428571e+02, 2.351429e+02, 2.294286e+02, 2.278571e+02, 2.178571e+02, 2.100000e+02, 2.018571e+02, 1.925714e+02, 1.850000e+02, 1.765714e+02, 1.677143e+02, 1.621429e+02, 1.597143e+02, 1.541429e+02, 1.515714e+02, 1.444286e+02, 1.422857e+02, 1.380000e+02, 1.332857e+02, 1.275714e+02, 1.261429e+02, 1.212857e+02, 1.197143e+02, 1.172857e+02, 1.168571e+02, 1.130000e+02, 1.104286e+02, 1.047143e+02, 1.018571e+02, 1.000000e+02, 9.428571e+01, 9.000000e+01, 8.800000e+01, 8.542857e+01, 8.328571e+01, 8.000000e+01, 7.542857e+01, 7.542857e+01, 7.128571e+01, 6.985714e+01, 6.557143e+01, 6.271429e+01, 6.171429e+01, 5.957143e+01, 5.614286e+01, 5.614286e+01, 5.314286e+01, 5.228571e+01, 5.228571e+01, 5.000000e+01, 4.914286e+01, 4.728571e+01, 4.400000e+01, 4.414286e+01, 4.328571e+01, 4.114286e+01, 3.828571e+01, 3.657143e+01, 3.671429e+01, 3.742857e+01, 3.642857e+01, 3.357143e+01, 3.242857e+01, 3.314286e+01, 3.357143e+01, 3.157143e+01, 2.857143e+01, 2.757143e+01, 2.942857e+01, 2.885714e+01, 2.685714e+01, 2.442857e+01, 2.242857e+01, 2.314286e+01, 2.071429e+01, 1.842857e+01, 1.714286e+01, 1.757143e+01, 1.771429e+01, 1.742857e+01, 1.585714e+01, 1.528571e+01, 1.442857e+01, 1.414286e+01, 1.271429e+01, 1.100000e+01, 1.057143e+01, 1.028571e+01, 9.285714e+00, 8.714286e+00, 6.714286e+00, 5.857143e+00, 5.285714e+00, 4.428571e+00, 3.857143e+00, 3.285714e+00, 2.142857e+00, 1.600000e+00, 1.000000e+00, 0.000000e+00},
    { 7.100000e+01, 1.843333e+02, 2.944000e+02, 4.012857e+02, 4.992857e+02, 5.915714e+02, 6.672857e+02, 7.341429e+02, 8.004286e+02, 8.452857e+02, 8.972857e+02, 9.301429e+02, 9.521429e+02, 9.838571e+02, 9.992857e+02, 1.009857e+03, 1.024857e+03, 1.019143e+03, 1.018571e+03, 1.027429e+03, 1.022143e+03, 1.027571e+03, 1.014429e+03, 9.962857e+02, 9.870000e+02, 9.904286e+02, 9.754286e+02, 9.657143e+02, 9.492857e+02, 9.381429e+02, 9.254286e+02, 9.160000e+02, 8.887143e+02, 8.661429e+02, 8.352857e+02, 8.087143e+02, 7.912857e+02, 7.790000e+02, 7.558571e+02, 7.408571e+02, 7.251429e+02, 7.151429e+02, 7.010000e+02, 6.894286e+02, 6.658571e+02, 6.494286e+02, 6.322857e+02, 6.227143e+02, 6.035714e+02, 5.917143e+02, 5.707143e+02, 5.582857e+02, 5.407143e+02, 5.220000e+02, 5.031429e+02, 4.878571e+02, 4.677143e+02, 4.552857e+02, 4.401429e+02, 4.277143e+02, 4.138571e+02, 4.004286e+02, 3.888571e+02, 3.777143e+02, 3.622857e+02, 3.508571e+02, 3.382857e+02, 3.274286e+02, 3.162857e+02, 3.064286e+02, 2.958571e+02, 2.850000e+02, 2.735714e+02, 2.630000e+02, 2.604286e+02, 2.507143e+02, 2.434286e+02, 2.361429e+02, 2.277143e+02, 2.172857e+02, 2.112857e+02, 1.995714e+02, 1.931429e+02, 1.810000e+02, 1.751429e+02, 1.734286e+02, 1.724286e+02, 1.701429e+02, 1.622857e+02, 1.587143e+02, 1.588571e+02, 1.557143e+02, 1.475714e+02, 1.411429e+02, 1.367143e+02, 1.332857e+02, 1.264286e+02, 1.227143e+02, 1.165714e+02, 1.141429e+02, 1.137143e+02, 1.077143e+02, 1.071429e+02, 1.031429e+02, 9.885714e+01, 9.785714e+01, 9.585714e+01, 9.257143e+01, 8.671429e+01, 8.414286e+01, 8.271429e+01, 7.985714e+01, 7.571429e+01, 7.400000e+01, 6.914286e+01, 7.000000e+01, 6.771429e+01, 6.742857e+01, 6.685714e+01, 6.500000e+01, 6.285714e+01, 6.228571e+01, 6.014286e+01, 5.585714e+01, 5.257143e+01, 5.057143e+01, 4.814286e+01, 4.485714e+01, 4.257143e+01, 4.057143e+01, 4.028571e+01, 3.885714e+01, 3.828571e+01, 3.900000e+01, 3.971429e+01, 3.828571e+01, 3.771429e+01, 3.857143e+01, 3.857143e+01, 3.671429e+01, 3.428571e+01, 3.271429e+01, 3.271429e+01, 3.085714e+01, 2.842857e+01, 2.700000e+01, 2.671429e+01, 2.628571e+01, 2.500000e+01, 2.442857e+01, 2.300000e+01, 2.128571e+01, 2.000000e+01, 1.871429e+01, 1.800000e+01, 1.685714e+01, 1.485714e+01, 1.557143e+01, 1.557143e+01, 1.528571e+01, 1.542857e+01, 1.471429e+01, 1.457143e+01, 1.428571e+01, 1.300000e+01, 1.171429e+01, 1.085714e+01, 9.285714e+00, 8.000000e+00, 6.857143e+00, 5.428571e+00, 5.571429e+00, 5.000000e+00, 4.000000e+00, 3.142857e+00, 2.857143e+00, 2.428571e+00, 1.400000e+00, 1.333333e+00, 0.000000e+00},
    { 5.600000e+01, 1.713333e+02, 2.866000e+02, 3.848571e+02, 4.804286e+02, 5.647143e+02, 6.410000e+02, 7.080000e+02, 7.555714e+02, 7.941429e+02, 8.267143e+02, 8.472857e+02, 8.760000e+02, 8.928571e+02, 9.147143e+02, 9.370000e+02, 9.491429e+02, 9.582857e+02, 9.732857e+02, 9.684286e+02, 9.675714e+02, 9.522857e+02, 9.371429e+02, 9.362857e+02, 9.211429e+02, 9.044286e+02, 8.942857e+02, 8.910000e+02, 8.790000e+02, 8.585714e+02, 8.412857e+02, 8.310000e+02, 8.120000e+02, 7.952857e+02, 7.695714e+02, 7.580000e+02, 7.450000e+02, 7.284286e+02, 7.044286e+02, 6.900000e+02, 6.717143e+02, 6.547143e+02, 6.325714e+02, 6.171429e+02, 5.912857e+02, 5.815714e+02, 5.694286e+02, 5.551429e+02, 5.404286e+02, 5.255714e+02, 5.120000e+02, 5.030000e+02, 4.884286e+02, 4.718571e+02, 4.550000e+02, 4.401429e+02, 4.288571e+02, 4.138571e+02, 3.991429e+02, 3.848571e+02, 3.721429e+02, 3.635714e+02, 3.552857e+02, 3.434286e+02, 3.364286e+02, 3.290000e+02, 3.221429e+02, 3.164286e+02, 3.071429e+02, 2.951429e+02, 2.814286e+02, 2.684286e+02, 2.572857e+02, 2.488571e+02, 2.328571e+02, 2.210000e+02, 2.135714e+02, 2.072857e+02, 2.028571e+02, 1.968571e+02, 1.844286e+02, 1.801429e+02, 1.771429e+02, 1.718571e+02, 1.665714e+02, 1.587143e+02, 1.524286e+02, 1.504286e+02, 1.462857e+02, 1.391429e+02, 1.335714e+02, 1.294286e+02, 1.244286e+02, 1.218571e+02, 1.174286e+02, 1.147143e+02, 1.102857e+02, 1.071429e+02, 1.057143e+02, 1.040000e+02, 9.985714e+01, 9.671429e+01, 9.328571e+01, 8.928571e+01, 8.728571e+01, 8.100000e+01, 7.814286e+01, 7.642857e+01, 7.371429e+01, 7.057143e+01, 6.942857e+01, 6.685714e+01, 6.928571e+01, 6.728571e+01, 6.385714e+01, 6.371429e+01, 6.228571e+01, 6.414286e+01, 6.114286e+01, 5.628571e+01, 5.285714e+01, 5.042857e+01, 4.857143e+01, 4.900000e+01, 4.442857e+01, 4.428571e+01, 4.300000e+01, 4.385714e+01, 4.485714e+01, 4.285714e+01, 4.000000e+01, 3.814286e+01, 3.757143e+01, 3.757143e+01, 3.442857e+01, 3.128571e+01, 2.971429e+01, 2.985714e+01, 2.942857e+01, 2.657143e+01, 2.457143e+01, 2.442857e+01, 2.428571e+01, 2.342857e+01, 2.285714e+01, 2.242857e+01, 2.185714e+01, 2.300000e+01, 2.242857e+01, 2.100000e+01, 2.085714e+01, 1.871429e+01, 1.828571e+01, 1.742857e+01, 1.514286e+01, 1.471429e+01, 1.471429e+01, 1.271429e+01, 1.285714e+01, 1.128571e+01, 1.028571e+01, 9.857143e+00, 9.428571e+00, 8.571429e+00, 8.857143e+00, 7.428571e+00, 7.571429e+00, 7.000000e+00, 6.285714e+00, 5.142857e+00, 4.142857e+00, 3.428571e+00, 3.285714e+00, 2.571429e+00, 2.857143e+00, 2.428571e+00, 1.857143e+00, 1.800000e+00, 1.666667e+00, 0.000000e+00},
    { 5.200000e+01, 1.573333e+02, 2.574000e+02, 3.524286e+02, 4.315714e+02, 5.081429e+02, 5.768571e+02, 6.382857e+02, 6.870000e+02, 7.261429e+02, 7.647143e+02, 8.068571e+02, 8.292857e+02, 8.471429e+02, 8.692857e+02, 8.761429e+02, 8.781429e+02, 8.832857e+02, 8.758571e+02, 8.774286e+02, 8.760000e+02, 8.661429e+02, 8.631429e+02, 8.587143e+02, 8.517143e+02, 8.500000e+02, 8.414286e+02, 8.365714e+02, 8.230000e+02, 8.091429e+02, 7.975714e+02, 7.817143e+02, 7.617143e+02, 7.478571e+02, 7.224286e+02, 7.062857e+02, 6.955714e+02, 6.821429e+02, 6.590000e+02, 6.414286e+02, 6.262857e+02, 6.132857e+02, 5.962857e+02, 5.710000e+02, 5.485714e+02, 5.334286e+02, 5.178571e+02, 4.997143e+02, 4.845714e+02, 4.748571e+02, 4.668571e+02, 4.544286e+02, 4.431429e+02, 4.330000e+02, 4.164286e+02, 4.057143e+02, 3.862857e+02, 3.722857e+02, 3.627143e+02, 3.535714e+02, 3.415714e+02, 3.382857e+02, 3.261429e+02, 3.165714e+02, 3.085714e+02, 2.930000e+02, 2.751429e+02, 2.637143e+02, 2.508571e+02, 2.447143e+02, 2.371429e+02, 2.301429e+02, 2.258571e+02, 2.201429e+02, 2.125714e+02, 2.037143e+02, 1.934286e+02, 1.855714e+02, 1.764286e+02, 1.655714e+02, 1.638571e+02, 1.595714e+02, 1.547143e+02, 1.502857e+02, 1.452857e+02, 1.407143e+02, 1.417143e+02, 1.371429e+02, 1.322857e+02, 1.288571e+02, 1.225714e+02, 1.202857e+02, 1.172857e+02, 1.090000e+02, 1.022857e+02, 1.001429e+02, 9.357143e+01, 9.171429e+01, 8.771429e+01, 8.457143e+01, 8.314286e+01, 8.200000e+01, 7.928571e+01, 7.971429e+01, 7.828571e+01, 7.528571e+01, 7.357143e+01, 7.171429e+01, 7.028571e+01, 6.885714e+01, 6.457143e+01, 6.142857e+01, 6.100000e+01, 5.957143e+01, 5.742857e+01, 5.757143e+01, 5.400000e+01, 5.357143e+01, 5.414286e+01, 5.214286e+01, 5.000000e+01, 4.942857e+01, 4.542857e+01, 4.500000e+01, 4.485714e+01, 4.271429e+01, 4.214286e+01, 4.042857e+01, 3.885714e+01, 3.842857e+01, 3.628571e+01, 3.457143e+01, 3.300000e+01, 3.100000e+01, 3.114286e+01, 3.000000e+01, 2.800000e+01, 2.842857e+01, 2.785714e+01, 2.785714e+01, 2.642857e+01, 2.457143e+01, 2.442857e+01, 2.485714e+01, 2.414286e+01, 2.285714e+01, 2.114286e+01, 2.157143e+01, 2.057143e+01, 2.000000e+01, 1.942857e+01, 1.742857e+01, 1.685714e+01, 1.657143e+01, 1.528571e+01, 1.428571e+01, 1.385714e+01, 1.228571e+01, 1.300000e+01, 1.200000e+01, 1.085714e+01, 1.028571e+01, 1.000000e+01, 9.142857e+00, 8.571429e+00, 6.571429e+00, 5.428571e+00, 5.000000e+00, 4.285714e+00, 4.285714e+00, 3.000000e+00, 3.285714e+00, 3.285714e+00, 3.285714e+00, 2.571429e+00, 2.428571e+00, 1.428571e+00, 1.200000e+00, 1.000000e+00, 0.000000e+00},
    { 3.700000e+01, 1.383333e+02, 2.304000e+02, 3.137143e+02, 3.902857e+02, 4.648571e+02, 5.352857e+02, 5.912857e+02, 6.357143e+02, 6.812857e+02, 7.252857e+02, 7.591429e+02, 7.844286e+02, 7.964286e+02, 8.117143e+02, 8.291429e+02, 8.317143e+02, 8.160000e+02, 8.171429e+02, 8.132857e+02, 8.094286e+02, 7.992857e+02, 7.955714e+02, 7.874286e+02, 7.895714e+02, 7.820000e+02, 7.707143e+02, 7.610000e+02, 7.464286e+02, 7.274286e+02, 7.141429e+02, 7.018571e+02, 6.877143e+02, 6.690000e+02, 6.508571e+02, 6.378571e+02, 6.244286e+02, 6.074286e+02, 5.912857e+02, 5.690000e+02, 5.555714e+02, 5.427143e+02, 5.304286e+02, 5.217143e+02, 5.061429e+02, 4.901429e+02, 4.817143e+02, 4.702857e+02, 4.592857e+02, 4.415714e+02, 4.245714e+02, 4.125714e+02, 4.002857e+02, 3.871429e+02, 3.742857e+02, 3.607143e+02, 3.541429e+02, 3.427143e+02, 3.295714e+02, 3.171429e+02, 3.101429e+02, 2.994286e+02, 2.837143e+02, 2.744286e+02, 2.585714e+02, 2.515714e+02, 2.420000e+02, 2.277143e+02, 2.238571e+02, 2.195714e+02, 2.095714e+02, 2.070000e+02, 1.984286e+02, 1.914286e+02, 1.850000e+02, 1.762857e+02, 1.755714e+02, 1.704286e+02, 1.654286e+02, 1.595714e+02, 1.594286e+02, 1.544286e+02, 1.470000e+02, 1.392857e+02, 1.347143e+02, 1.294286e+02, 1.255714e+02, 1.194286e+02, 1.158571e+02, 1.131429e+02, 1.102857e+02, 1.075714e+02, 1.024286e+02, 9.742857e+01, 9.357143e+01, 8.914286e+01, 8.700000e+01, 8.071429e+01, 7.671429e+01, 7.428571e+01, 7.342857e+01, 7.214286e+01, 7.357143e+01, 6.828571e+01, 6.771429e+01, 6.542857e+01, 6.514286e+01, 6.228571e+01, 5.785714e+01, 5.485714e+01, 5.542857e+01, 5.200000e+01, 5.171429e+01, 5.028571e+01, 5.042857e+01, 4.971429e+01, 4.757143e+01, 4.585714e+01, 4.628571e+01, 4.414286e+01, 4.285714e+01, 4.085714e+01, 3.928571e+01, 3.757143e+01, 3.614286e+01, 3.471429e+01, 3.485714e+01, 3.271429e+01, 3.314286e+01, 3.314286e+01, 3.185714e+01, 3.028571e+01, 2.685714e+01, 2.614286e+01, 2.642857e+01, 2.600000e+01, 2.428571e+01, 2.500000e+01, 2.542857e+01, 2.771429e+01, 2.571429e+01, 2.500000e+01, 2.300000e+01, 2.257143e+01, 1.985714e+01, 1.885714e+01, 1.728571e+01, 1.785714e+01, 1.628571e+01, 1.657143e+01, 1.557143e+01, 1.500000e+01, 1.514286e+01, 1.471429e+01, 1.342857e+01, 1.328571e+01, 1.157143e+01, 1.171429e+01, 1.200000e+01, 1.100000e+01, 1.028571e+01, 9.142857e+00, 8.428571e+00, 9.285714e+00, 8.285714e+00, 7.428571e+00, 6.714286e+00, 5.857143e+00, 5.571429e+00, 4.714286e+00, 3.142857e+00, 2.857143e+00, 2.285714e+00, 1.714286e+00, 1.142857e+00, 1.000000e+00, 7.142857e-01, 4.000000e-01, 3.333333e-01, 0.000000e+00},
    { 4.300000e+01, 1.336667e+02, 2.110000e+02, 2.902857e+02, 3.635714e+02, 4.291429e+02, 4.907143e+02, 5.530000e+02, 6.007143e+02, 6.420000e+02, 6.770000e+02, 7.021429e+02, 7.211429e+02, 7.404286e+02, 7.511429e+02, 7.574286e+02, 7.590000e+02, 7.512857e+02, 7.504286e+02, 7.545714e+02, 7.437143e+02, 7.420000e+02, 7.377143e+02, 7.327143e+02, 7.261429e+02, 7.198571e+02, 7.082857e+02, 6.975714e+02, 6.807143e+02, 6.658571e+02, 6.524286e+02, 6.405714e+02, 6.242857e+02, 6.141429e+02, 5.960000e+02, 5.802857e+02, 5.692857e+02, 5.514286e+02, 5.354286e+02, 5.257143e+02, 5.080000e+02, 4.972857e+02, 4.791429e+02, 4.634286e+02, 4.542857e+02, 4.410000e+02, 4.262857e+02, 4.145714e+02, 4.041429e+02, 3.930000e+02, 3.808571e+02, 3.672857e+02, 3.550000e+02, 3.464286e+02, 3.344286e+02, 3.235714e+02, 3.182857e+02, 3.077143e+02, 3.004286e+02, 2.878571e+02, 2.760000e+02, 2.625714e+02, 2.577143e+02, 2.460000e+02, 2.335714e+02, 2.221429e+02, 2.202857e+02, 2.095714e+02, 2.040000e+02, 1.938571e+02, 1.868571e+02, 1.828571e+02, 1.791429e+02, 1.737143e+02, 1.695714e+02, 1.662857e+02, 1.632857e+02, 1.574286e+02, 1.560000e+02, 1.555714e+02, 1.457143e+02, 1.420000e+02, 1.364286e+02, 1.282857e+02, 1.250000e+02, 1.177143e+02, 1.088571e+02, 1.067143e+02, 1.017143e+02, 9.714286e+01, 9.500000e+01, 9.300000e+01, 9.028571e+01, 8.700000e+01, 8.428571e+01, 8.385714e+01, 8.214286e+01, 7.657143e+01, 7.242857e+01, 7.100000e+01, 6.914286e+01, 6.785714e+01, 6.485714e+01, 6.171429e+01, 6.314286e+01, 6.300000e+01, 6.157143e+01, 5.971429e+01, 5.957143e+01, 5.585714e+01, 5.371429e+01, 5.000000e+01, 4.728571e+01, 4.557143e+01, 4.557143e+01, 4.314286e+01, 4.228571e+01, 4.228571e+01, 4.385714e+01, 4.257143e+01, 4.157143e+01, 3.842857e+01, 3.728571e+01, 3.842857e+01, 3.671429e+01, 3.357143e+01, 3.185714e+01, 2.971429e+01, 2.971429e+01, 2.785714e+01, 2.500000e+01, 2.500000e+01, 2.414286e+01, 2.400000e+01, 2.271429e+01, 2.057143e+01, 2.085714e+01, 2.085714e+01, 2.085714e+01, 1.971429e+01, 1.857143e+01, 1.757143e+01, 1.857143e+01, 1.800000e+01, 1.842857e+01, 1.757143e+01, 1.842857e+01, 1.771429e+01, 1.757143e+01, 1.614286e+01, 1.471429e+01, 1.271429e+01, 1.257143e+01, 1.185714e+01, 1.257143e+01, 1.228571e+01, 1.228571e+01, 1.214286e+01, 1.228571e+01, 1.142857e+01, 1.100000e+01, 8.857143e+00, 8.857143e+00, 8.285714e+00, 7.857143e+00, 6.857143e+00, 6.428571e+00, 5.714286e+00, 6.285714e+00, 5.000000e+00, 4.571429e+00, 3.857143e+00, 3.571429e+00, 2.714286e+00, 2.000000e+00, 1.571429e+00, 1.428571e+00, 8.000000e-01, 6.666667e-01, 0.000000e+00},
    { 4.300000e+01, 1.266667e+02, 2.098000e+02, 2.837143e+02, 3.550000e+02, 4.171429e+02, 4.788571e+02, 5.145714e+02, 5.552857e+02, 5.904286e+02, 6.157143e+02, 6.401429e+02, 6.634286e+02, 6.760000e+02, 6.944286e+02, 7.055714e+02, 7.057143e+02, 7.135714e+02, 7.104286e+02, 7.034286e+02, 6.968571e+02, 6.921429e+02, 6.860000e+02, 6.857143e+02, 6.788571e+02, 6.704286e+02, 6.600000e+02, 6.561429e+02, 6.431429e+02, 6.340000e+02, 6.184286e+02, 5.995714e+02, 5.852857e+02, 5.748571e+02, 5.554286e+02, 5.425714e+02, 5.330000e+02, 5.181429e+02, 5.055714e+02, 4.940000e+02, 4.797143e+02, 4.672857e+02, 4.511429e+02, 4.348571e+02, 4.195714e+02, 4.091429e+02, 3.925714e+02, 3.795714e+02, 3.631429e+02, 3.535714e+02, 3.407143e+02, 3.308571e+02, 3.251429e+02, 3.168571e+02, 3.087143e+02, 3.042857e+02, 2.951429e+02, 2.874286e+02, 2.775714e+02, 2.585714e+02, 2.478571e+02, 2.378571e+02, 2.250000e+02, 2.155714e+02, 2.052857e+02, 2.008571e+02, 1.990000e+02, 1.965714e+02, 1.922857e+02, 1.895714e+02, 1.814286e+02, 1.734286e+02, 1.642857e+02, 1.558571e+02, 1.491429e+02, 1.428571e+02, 1.362857e+02, 1.354286e+02, 1.300000e+02, 1.277143e+02, 1.224286e+02, 1.175714e+02, 1.131429e+02, 1.077143e+02, 1.031429e+02, 1.060000e+02, 1.021429e+02, 1.021429e+02, 9.714286e+01, 9.257143e+01, 9.042857e+01, 8.700000e+01, 8.114286e+01, 7.757143e+01, 7.500000e+01, 7.271429e+01, 7.100000e+01, 6.871429e+01, 6.857143e+01, 6.700000e+01, 6.642857e+01, 6.314286e+01, 6.185714e+01, 5.971429e+01, 5.571429e+01, 5.300000e+01, 5.071429e+01, 4.685714e+01, 4.528571e+01, 4.571429e+01, 4.300000e+01, 4.457143e+01, 4.300000e+01, 4.142857e+01, 4.085714e+01, 3.842857e+01, 3.714286e+01, 3.642857e+01, 3.428571e+01, 3.314286e+01, 3.085714e+01, 2.871429e+01, 2.885714e+01, 2.771429e+01, 2.800000e+01, 2.642857e+01, 2.600000e+01, 2.571429e+01, 2.585714e+01, 2.385714e+01, 2.214286e+01, 2.128571e+01, 2.228571e+01, 2.200000e+01, 2.300000e+01, 2.314286e+01, 2.342857e+01, 2.314286e+01, 2.214286e+01, 2.100000e+01, 1.985714e+01, 1.757143e+01, 1.600000e+01, 1.542857e+01, 1.542857e+01, 1.414286e+01, 1.300000e+01, 1.300000e+01, 1.285714e+01, 1.300000e+01, 1.171429e+01, 1.157143e+01, 1.228571e+01, 1.257143e+01, 1.100000e+01, 1.000000e+01, 9.142857e+00, 9.285714e+00, 7.857143e+00, 7.142857e+00, 6.285714e+00, 6.571429e+00, 7.000000e+00, 6.428571e+00, 6.142857e+00, 6.285714e+00, 5.714286e+00, 5.571429e+00, 5.000000e+00, 4.714286e+00, 4.571429e+00, 3.857143e+00, 3.285714e+00, 3.285714e+00, 2.714286e+00, 1.857143e+00, 1.000000e+00, 1.000000e+00, 3.333333e-01, 0.000000e+00},
    { 3.700000e+01, 1.150000e+02, 1.978000e+02, 2.534286e+02, 3.150000e+02, 3.705714e+02, 4.192857e+02, 4.631429e+02, 4.940000e+02, 5.288571e+02, 5.588571e+02, 5.830000e+02, 6.035714e+02, 6.188571e+02, 6.261429e+02, 6.355714e+02, 6.462857e+02, 6.387143e+02, 6.412857e+02, 6.395714e+02, 6.368571e+02, 6.410000e+02, 6.354286e+02, 6.138571e+02, 6.212857e+02, 6.121429e+02, 6.107143e+02, 5.967143e+02, 5.882857e+02, 5.727143e+02, 5.690000e+02, 5.464286e+02, 5.317143e+02, 5.138571e+02, 5.028571e+02, 4.787143e+02, 4.701429e+02, 4.670000e+02, 4.591429e+02, 4.502857e+02, 4.304286e+02, 4.238571e+02, 4.160000e+02, 4.008571e+02, 3.805714e+02, 3.691429e+02, 3.541429e+02, 3.487143e+02, 3.341429e+02, 3.198571e+02, 3.097143e+02, 3.011429e+02, 2.888571e+02, 2.792857e+02, 2.685714e+02, 2.607143e+02, 2.552857e+02, 2.491429e+02, 2.454286e+02, 2.384286e+02, 2.331429e+02, 2.281429e+02, 2.212857e+02, 2.150000e+02, 2.101429e+02, 2.030000e+02, 1.964286e+02, 1.895714e+02, 1.802857e+02, 1.745714e+02, 1.657143e+02, 1.565714e+02, 1.478571e+02, 1.427143e+02, 1.344286e+02, 1.284286e+02, 1.234286e+02, 1.198571e+02, 1.161429e+02, 1.135714e+02, 1.084286e+02, 1.087143e+02, 1.042857e+02, 1.012857e+02, 9.842857e+01, 9.542857e+01, 8.971429e+01, 8.728571e+01, 8.185714e+01, 8.314286e+01, 7.942857e+01, 7.714286e+01, 7.242857e+01, 7.042857e+01, 6.900000e+01, 6.728571e+01, 6.142857e+01, 5.914286e+01, 5.785714e+01, 5.628571e+01, 5.642857e+01, 5.228571e+01, 5.042857e+01, 5.085714e+01, 5.028571e+01, 5.000000e+01, 4.957143e+01, 4.457143e+01, 4.271429e+01, 4.071429e+01, 3.885714e+01, 3.628571e+01, 3.357143e+01, 3.214286e+01, 3.314286e+01, 3.314286e+01, 3.371429e+01, 3.300000e+01, 3.342857e+01, 3.214286e+01, 3.042857e+01, 2.842857e+01, 2.842857e+01, 2.600000e+01, 2.485714e+01, 2.328571e+01, 2.285714e+01, 2.371429e+01, 2.328571e+01, 2.200000e+01, 2.157143e+01, 2.100000e+01, 2.071429e+01, 1.971429e+01, 1.800000e+01, 1.928571e+01, 2.057143e+01, 2.042857e+01, 1.928571e+01, 1.914286e+01, 1.928571e+01, 1.900000e+01, 1.800000e+01, 1.542857e+01, 1.542857e+01, 1.500000e+01, 1.328571e+01, 1.328571e+01, 1.257143e+01, 1.142857e+01, 1.171429e+01, 1.057143e+01, 1.028571e+01, 1.042857e+01, 9.285714e+00, 1.042857e+01, 9.714286e+00, 9.000000e+00, 8.000000e+00, 7.571429e+00, 6.857143e+00, 6.142857e+00, 4.714286e+00, 4.571429e+00, 4.714286e+00, 4.428571e+00, 4.285714e+00, 4.000000e+00, 3.714286e+00, 3.571429e+00, 3.285714e+00, 2.714286e+00, 2.714286e+00, 2.142857e+00, 1.714286e+00, 1.571429e+00, 1.285714e+00, 6.000000e-01, 3.333333e-01, 0.000000e+00},
    { 4.400000e+01, 9.466667e+01, 1.686000e+02, 2.398571e+02, 2.991429e+02, 3.594286e+02, 4.111429e+02, 4.501429e+02, 4.795714e+02, 5.061429e+02, 5.255714e+02, 5.497143e+02, 5.678571e+02, 5.764286e+02, 5.858571e+02, 5.965714e+02, 6.012857e+02, 6.010000e+02, 5.902857e+02, 5.871429e+02, 5.838571e+02, 5.794286e+02, 5.754286e+02, 5.617143e+02, 5.570000e+02, 5.558571e+02, 5.342857e+02, 5.310000e+02, 5.300000e+02, 5.254286e+02, 5.212857e+02, 5.111429e+02, 4.955714e+02, 4.898571e+02, 4.761429e+02, 4.587143e+02, 4.401429e+02, 4.231429e+02, 4.122857e+02, 3.977143e+02, 3.898571e+02, 3.761429e+02, 3.632857e+02, 3.485714e+02, 3.407143e+02, 3.231429e+02, 3.168571e+02, 3.040000e+02, 2.930000e+02, 2.822857e+02, 2.780000e+02, 2.661429e+02, 2.604286e+02, 2.544286e+02, 2.510000e+02, 2.470000e+02, 2.408571e+02, 2.311429e+02, 2.248571e+02, 2.212857e+02, 2.134286e+02, 2.032857e+02, 1.952857e+02, 1.908571e+02, 1.804286e+02, 1.748571e+02, 1.674286e+02, 1.598571e+02, 1.500000e+02, 1.441429e+02, 1.384286e+02, 1.358571e+02, 1.358571e+02, 1.277143e+02, 1.250000e+02, 1.251429e+02, 1.211429e+02, 1.150000e+02, 1.118571e+02, 1.024286e+02, 1.021429e+02, 9.628571e+01, 9.071429e+01, 8.914286e+01, 8.600000e+01, 8.042857e+01, 7.957143e+01, 7.542857e+01, 7.357143e+01, 7.085714e+01, 6.642857e+01, 6.571429e+01, 6.671429e+01, 6.457143e+01, 6.242857e+01, 6.057143e+01, 5.900000e+01, 5.585714e+01, 5.342857e+01, 4.857143e+01, 4.685714e+01, 4.700000e+01, 4.485714e+01, 4.500000e+01, 4.471429e+01, 4.457143e+01, 4.528571e+01, 4.557143e+01, 4.271429e+01, 4.271429e+01, 4.100000e+01, 3.828571e+01, 3.542857e+01, 3.300000e+01, 3.028571e+01, 2.785714e+01, 2.485714e+01, 2.457143e+01, 2.642857e+01, 2.728571e+01, 2.685714e+01, 2.671429e+01, 2.700000e+01, 2.728571e+01, 2.557143e+01, 2.414286e+01, 2.271429e+01, 2.214286e+01, 2.085714e+01, 2.042857e+01, 2.042857e+01, 1.857143e+01, 1.700000e+01, 1.700000e+01, 1.671429e+01, 1.600000e+01, 1.514286e+01, 1.414286e+01, 1.414286e+01, 1.371429e+01, 1.242857e+01, 1.271429e+01, 1.400000e+01, 1.257143e+01, 1.300000e+01, 1.414286e+01, 1.414286e+01, 1.357143e+01, 1.257143e+01, 1.114286e+01, 1.185714e+01, 1.028571e+01, 9.571429e+00, 9.285714e+00, 8.714286e+00, 8.142857e+00, 8.285714e+00, 7.285714e+00, 7.142857e+00, 5.857143e+00, 5.428571e+00, 5.428571e+00, 5.285714e+00, 4.000000e+00, 4.000000e+00, 3.571429e+00, 3.857143e+00, 4.142857e+00, 4.285714e+00, 4.000000e+00, 3.857143e+00, 4.000000e+00, 4.142857e+00, 3.571429e+00, 2.571429e+00, 1.714286e+00, 1.285714e+00, 6.000000e-01, 0.000000e+00, 0.000000e+00},
    { 3.600000e+01, 9.200000e+01, 1.496000e+02, 2.081429e+02, 2.657143e+02, 3.130000e+02, 3.590000e+02, 3.991429e+02, 4.405714e+02, 4.645714e+02, 4.961429e+02, 5.091429e+02, 5.371429e+02, 5.488571e+02, 5.591429e+02, 5.671429e+02, 5.658571e+02, 5.638571e+02, 5.694286e+02, 5.547143e+02, 5.498571e+02, 5.430000e+02, 5.328571e+02, 5.344286e+02, 5.280000e+02, 5.132857e+02, 5.072857e+02, 4.954286e+02, 4.841429e+02, 4.701429e+02, 4.528571e+02, 4.381429e+02, 4.335714e+02, 4.268571e+02, 4.174286e+02, 4.080000e+02, 4.014286e+02, 3.900000e+02, 3.848571e+02, 3.708571e+02, 3.587143e+02, 3.497143e+02, 3.381429e+02, 3.324286e+02, 3.240000e+02, 3.162857e+02, 3.048571e+02, 2.915714e+02, 2.791429e+02, 2.698571e+02, 2.557143e+02, 2.495714e+02, 2.405714e+02, 2.347143e+02, 2.310000e+02, 2.278571e+02, 2.207143e+02, 2.135714e+02, 2.037143e+02, 1.984286e+02, 1.920000e+02, 1.855714e+02, 1.811429e+02, 1.735714e+02, 1.675714e+02, 1.632857e+02, 1.527143e+02, 1.458571e+02, 1.377143e+02, 1.321429e+02, 1.274286e+02, 1.221429e+02, 1.144286e+02, 1.115714e+02, 1.092857e+02, 1.055714e+02, 1.007143e+02, 9.871429e+01, 9.742857e+01, 9.728571e+01, 9.357143e+01, 9.042857e+01, 8.942857e+01, 8.585714e+01, 8.300000e+01, 7.871429e+01, 7.342857e+01, 6.857143e+01, 6.542857e+01, 6.185714e+01, 5.900000e+01, 5.900000e+01, 5.657143e+01, 5.585714e+01, 5.557143e+01, 5.285714e+01, 4.957143e+01, 4.971429e+01, 4.657143e+01, 4.642857e+01, 4.657143e+01, 4.571429e+01, 4.428571e+01, 4.557143e+01, 4.442857e+01, 4.085714e+01, 3.914286e+01, 3.900000e+01, 3.785714e+01, 3.871429e+01, 3.742857e+01, 3.471429e+01, 3.400000e+01, 3.128571e+01, 2.885714e+01, 2.657143e+01, 2.485714e+01, 2.300000e+01, 2.257143e+01, 2.185714e+01, 2.171429e+01, 2.057143e+01, 2.071429e+01, 1.971429e+01, 2.000000e+01, 1.985714e+01, 2.014286e+01, 1.914286e+01, 1.857143e+01, 1.785714e+01, 1.742857e+01, 1.600000e+01, 1.457143e+01, 1.400000e+01, 1.500000e+01, 1.457143e+01, 1.442857e+01, 1.385714e+01, 1.371429e+01, 1.328571e+01, 1.228571e+01, 1.200000e+01, 1.114286e+01, 1.085714e+01, 9.857143e+00, 9.000000e+00, 9.571429e+00, 9.714286e+00, 8.285714e+00, 8.428571e+00, 7.714286e+00, 7.571429e+00, 7.142857e+00, 6.428571e+00, 6.571429e+00, 7.142857e+00, 6.857143e+00, 7.428571e+00, 8.142857e+00, 7.571429e+00, 6.571429e+00, 6.000000e+00, 4.857143e+00, 4.142857e+00, 3.571429e+00, 2.142857e+00, 2.285714e+00, 2.428571e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 4.285714e-01, 4.000000e-01, 3.333333e-01, 0.000000e+00},
    { 4.400000e+01, 9.433333e+01, 1.532000e+02, 2.055714e+02, 2.588571e+02, 3.078571e+02, 3.534286e+02, 3.864286e+02, 4.135714e+02, 4.405714e+02, 4.608571e+02, 4.798571e+02, 4.940000e+02, 4.955714e+02, 5.041429e+02, 5.140000e+02, 5.197143e+02, 5.220000e+02, 5.135714e+02, 5.120000e+02, 5.105714e+02, 5.100000e+02, 5.025714e+02, 4.957143e+02, 4.868571e+02, 4.821429e+02, 4.720000e+02, 4.660000e+02, 4.567143e+02, 4.507143e+02, 4.408571e+02, 4.248571e+02, 4.140000e+02, 4.035714e+02, 3.927143e+02, 3.798571e+02, 3.657143e+02, 3.540000e+02, 3.497143e+02, 3.391429e+02, 3.282857e+02, 3.188571e+02, 3.091429e+02, 3.004286e+02, 2.901429e+02, 2.788571e+02, 2.662857e+02, 2.590000e+02, 2.504286e+02, 2.484286e+02, 2.418571e+02, 2.308571e+02, 2.202857e+02, 2.141429e+02, 2.035714e+02, 1.962857e+02, 1.834286e+02, 1.718571e+02, 1.690000e+02, 1.675714e+02, 1.650000e+02, 1.591429e+02, 1.515714e+02, 1.444286e+02, 1.398571e+02, 1.337143e+02, 1.270000e+02, 1.218571e+02, 1.187143e+02, 1.170000e+02, 1.148571e+02, 1.094286e+02, 1.075714e+02, 1.035714e+02, 9.885714e+01, 9.714286e+01, 9.385714e+01, 9.000000e+01, 9.142857e+01, 8.800000e+01, 8.514286e+01, 8.385714e+01, 7.685714e+01, 7.342857e+01, 7.028571e+01, 6.371429e+01, 6.171429e+01, 5.871429e+01, 5.485714e+01, 5.557143e+01, 5.200000e+01, 5.042857e+01, 4.928571e+01, 4.642857e+01, 4.414286e+01, 4.114286e+01, 4.057143e+01, 4.000000e+01, 3.914286e+01, 3.757143e+01, 3.642857e+01, 3.528571e+01, 3.500000e+01, 3.285714e+01, 3.214286e+01, 3.057143e+01, 3.057143e+01, 3.014286e+01, 2.942857e+01, 2.900000e+01, 2.757143e+01, 2.614286e+01, 2.614286e+01, 2.528571e+01, 2.500000e+01, 2.385714e+01, 2.400000e+01, 2.385714e+01, 2.271429e+01, 2.271429e+01, 2.242857e+01, 2.014286e+01, 2.042857e+01, 1.842857e+01, 1.700000e+01, 1.700000e+01, 1.514286e+01, 1.542857e+01, 1.542857e+01, 1.542857e+01, 1.485714e+01, 1.485714e+01, 1.600000e+01, 1.614286e+01, 1.471429e+01, 1.500000e+01, 1.385714e+01, 1.328571e+01, 1.228571e+01, 1.042857e+01, 9.571429e+00, 8.857143e+00, 8.142857e+00, 7.142857e+00, 7.142857e+00, 6.571429e+00, 6.428571e+00, 6.142857e+00, 5.857143e+00, 5.142857e+00, 5.571429e+00, 5.571429e+00, 5.714286e+00, 5.714286e+00, 5.428571e+00, 5.285714e+00, 5.142857e+00, 5.000000e+00, 5.142857e+00, 5.857143e+00, 5.142857e+00, 5.142857e+00, 5.000000e+00, 5.142857e+00, 4.857143e+00, 5.000000e+00, 4.142857e+00, 4.285714e+00, 3.857143e+00, 3.571429e+00, 3.000000e+00, 2.428571e+00, 1.285714e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 6.000000e-01, 3.333333e-01, 0.000000e+00},
    { 3.100000e+01, 9.200000e+01, 1.468000e+02, 2.021429e+02, 2.505714e+02, 2.932857e+02, 3.281429e+02, 3.650000e+02, 3.938571e+02, 4.165714e+02, 4.294286e+02, 4.481429e+02, 4.590000e+02, 4.740000e+02, 4.788571e+02, 4.768571e+02, 4.757143e+02, 4.687143e+02, 4.687143e+02, 4.644286e+02, 4.561429e+02, 4.544286e+02, 4.500000e+02, 4.478571e+02, 4.538571e+02, 4.457143e+02, 4.441429e+02, 4.362857e+02, 4.267143e+02, 4.230000e+02, 4.121429e+02, 3.985714e+02, 3.857143e+02, 3.735714e+02, 3.618571e+02, 3.501429e+02, 3.328571e+02, 3.257143e+02, 3.210000e+02, 3.121429e+02, 3.012857e+02, 2.995714e+02, 2.912857e+02, 2.862857e+02, 2.712857e+02, 2.561429e+02, 2.455714e+02, 2.350000e+02, 2.208571e+02, 2.098571e+02, 2.011429e+02, 1.958571e+02, 1.900000e+02, 1.845714e+02, 1.798571e+02, 1.752857e+02, 1.750000e+02, 1.698571e+02, 1.662857e+02, 1.591429e+02, 1.501429e+02, 1.454286e+02, 1.397143e+02, 1.332857e+02, 1.262857e+02, 1.180000e+02, 1.150000e+02, 1.128571e+02, 1.080000e+02, 1.040000e+02, 9.871429e+01, 9.900000e+01, 9.471429e+01, 9.014286e+01, 8.671429e+01, 8.385714e+01, 8.071429e+01, 7.728571e+01, 7.285714e+01, 7.457143e+01, 7.228571e+01, 7.042857e+01, 6.885714e+01, 6.757143e+01, 6.457143e+01, 6.228571e+01, 5.800000e+01, 5.757143e+01, 5.542857e+01, 5.328571e+01, 5.300000e+01, 5.328571e+01, 4.971429e+01, 4.985714e+01, 4.671429e+01, 4.485714e+01, 4.385714e+01, 3.900000e+01, 3.742857e+01, 3.657143e+01, 3.442857e+01, 3.371429e+01, 3.214286e+01, 2.957143e+01, 3.157143e+01, 3.028571e+01, 2.957143e+01, 2.814286e+01, 2.728571e+01, 2.742857e+01, 2.757143e+01, 2.442857e+01, 2.300000e+01, 2.271429e+01, 2.128571e+01, 2.057143e+01, 1.842857e+01, 1.728571e+01, 1.671429e+01, 1.628571e+01, 1.542857e+01, 1.571429e+01, 1.600000e+01, 1.628571e+01, 1.500000e+01, 1.685714e+01, 1.685714e+01, 1.614286e+01, 1.557143e+01, 1.428571e+01, 1.371429e+01, 1.442857e+01, 1.185714e+01, 1.171429e+01, 1.085714e+01, 1.071429e+01, 1.000000e+01, 9.428571e+00, 8.714286e+00, 9.142857e+00, 8.571429e+00, 8.714286e+00, 7.428571e+00, 7.428571e+00, 8.571429e+00, 8.285714e+00, 8.000000e+00, 7.857143e+00, 7.571429e+00, 8.714286e+00, 8.285714e+00, 7.142857e+00, 6.571429e+00, 6.428571e+00, 6.571429e+00, 6.571429e+00, 5.857143e+00, 5.714286e+00, 5.142857e+00, 5.000000e+00, 4.142857e+00, 3.428571e+00, 2.714286e+00, 2.142857e+00, 2.428571e+00, 2.857143e+00, 3.000000e+00, 3.142857e+00, 2.571429e+00, 2.714286e+00, 2.714286e+00, 2.142857e+00, 1.428571e+00, 1.000000e+00, 7.142857e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.600000e+01, 7.900000e+01, 1.344000e+02, 1.794286e+02, 2.287143e+02, 2.725714e+02, 3.080000e+02, 3.422857e+02, 3.688571e+02, 3.925714e+02, 4.130000e+02, 4.270000e+02, 4.308571e+02, 4.430000e+02, 4.475714e+02, 4.524286e+02, 4.510000e+02, 4.457143e+02, 4.367143e+02, 4.311429e+02, 4.210000e+02, 4.187143e+02, 4.090000e+02, 4.011429e+02, 3.975714e+02, 3.961429e+02, 3.927143e+02, 3.927143e+02, 3.790000e+02, 3.708571e+02, 3.685714e+02, 3.625714e+02, 3.507143e+02, 3.428571e+02, 3.312857e+02, 3.241429e+02, 3.151429e+02, 3.024286e+02, 2.935714e+02, 2.841429e+02, 2.777143e+02, 2.661429e+02, 2.538571e+02, 2.478571e+02, 2.337143e+02, 2.222857e+02, 2.125714e+02, 2.067143e+02, 1.984286e+02, 1.934286e+02, 1.857143e+02, 1.850000e+02, 1.761429e+02, 1.734286e+02, 1.660000e+02, 1.627143e+02, 1.588571e+02, 1.511429e+02, 1.468571e+02, 1.434286e+02, 1.367143e+02, 1.327143e+02, 1.277143e+02, 1.214286e+02, 1.180000e+02, 1.170000e+02, 1.105714e+02, 1.088571e+02, 1.051429e+02, 9.971429e+01, 9.628571e+01, 9.314286e+01, 8.571429e+01, 8.485714e+01, 8.214286e+01, 7.771429e+01, 7.614286e+01, 7.642857e+01, 7.471429e+01, 7.371429e+01, 7.142857e+01, 6.942857e+01, 6.628571e+01, 6.500000e+01, 5.900000e+01, 5.528571e+01, 5.200000e+01, 4.957143e+01, 4.471429e+01, 4.300000e+01, 4.128571e+01, 3.942857e+01, 3.785714e+01, 3.628571e+01, 3.514286e+01, 3.600000e+01, 3.600000e+01, 3.528571e+01, 3.371429e+01, 3.671429e+01, 3.642857e+01, 3.414286e+01, 3.242857e+01, 3.014286e+01, 2.885714e+01, 2.885714e+01, 2.514286e+01, 2.357143e+01, 2.442857e+01, 2.428571e+01, 2.400000e+01, 2.100000e+01, 2.100000e+01, 2.057143e+01, 1.985714e+01, 1.857143e+01, 1.685714e+01, 1.500000e+01, 1.628571e+01, 1.457143e+01, 1.314286e+01, 1.342857e+01, 1.314286e+01, 1.328571e+01, 1.442857e+01, 1.314286e+01, 1.442857e+01, 1.428571e+01, 1.442857e+01, 1.414286e+01, 1.471429e+01, 1.328571e+01, 1.285714e+01, 1.185714e+01, 1.171429e+01, 1.128571e+01, 1.185714e+01, 1.028571e+01, 9.857143e+00, 1.028571e+01, 9.714286e+00, 1.057143e+01, 8.857143e+00, 7.571429e+00, 7.000000e+00, 6.714286e+00, 6.571429e+00, 6.000000e+00, 4.857143e+00, 5.428571e+00, 5.714286e+00, 5.428571e+00, 5.428571e+00, 4.857143e+00, 5.000000e+00, 4.714286e+00, 4.000000e+00, 3.714286e+00, 3.571429e+00, 4.000000e+00, 4.285714e+00, 3.571429e+00, 3.142857e+00, 3.428571e+00, 3.000000e+00, 2.714286e+00, 2.142857e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 8.000000e-01, 1.000000e+00, 0.000000e+00},
    { 2.200000e+01, 7.800000e+01, 1.256000e+02, 1.702857e+02, 2.127143e+02, 2.558571e+02, 2.878571e+02, 3.152857e+02, 3.330000e+02, 3.548571e+02, 3.727143e+02, 3.864286e+02, 3.871429e+02, 3.948571e+02, 4.030000e+02, 4.100000e+02, 4.100000e+02, 4.071429e+02, 4.068571e+02, 4.078571e+02, 4.084286e+02, 4.042857e+02, 4.008571e+02, 3.960000e+02, 3.901429e+02, 3.854286e+02, 3.757143e+02, 3.598571e+02, 3.481429e+02, 3.374286e+02, 3.304286e+02, 3.254286e+02, 3.177143e+02, 3.148571e+02, 3.110000e+02, 3.067143e+02, 3.022857e+02, 2.907143e+02, 2.775714e+02, 2.650000e+02, 2.552857e+02, 2.480000e+02, 2.380000e+02, 2.288571e+02, 2.184286e+02, 2.131429e+02, 2.031429e+02, 1.954286e+02, 1.874286e+02, 1.805714e+02, 1.768571e+02, 1.751429e+02, 1.681429e+02, 1.650000e+02, 1.598571e+02, 1.548571e+02, 1.477143e+02, 1.387143e+02, 1.332857e+02, 1.238571e+02, 1.180000e+02, 1.137143e+02, 1.090000e+02, 1.104286e+02, 1.074286e+02, 1.021429e+02, 9.971429e+01, 9.400000e+01, 8.885714e+01, 8.628571e+01, 8.028571e+01, 7.585714e+01, 7.614286e+01, 7.314286e+01, 7.242857e+01, 6.828571e+01, 6.357143e+01, 6.171429e+01, 5.985714e+01, 5.614286e+01, 5.471429e+01, 5.414286e+01, 5.385714e+01, 5.442857e+01, 5.357143e+01, 5.471429e+01, 5.414286e+01, 5.342857e+01, 5.014286e+01, 4.785714e+01, 4.600000e+01, 4.242857e+01, 3.842857e+01, 3.528571e+01, 3.328571e+01, 3.085714e+01, 2.914286e+01, 2.828571e+01, 2.642857e+01, 2.742857e+01, 2.771429e+01, 2.728571e+01, 2.785714e+01, 2.728571e+01, 2.500000e+01, 2.485714e+01, 2.242857e+01, 2.157143e+01, 2.042857e+01, 2.085714e+01, 2.014286e+01, 1.957143e+01, 1.900000e+01, 1.814286e+01, 1.671429e+01, 1.657143e+01, 1.657143e+01, 1.700000e+01, 1.685714e+01, 1.571429e+01, 1.600000e+01, 1.585714e+01, 1.500000e+01, 1.400000e+01, 1.485714e+01, 1.471429e+01, 1.500000e+01, 1.485714e+01, 1.428571e+01, 1.414286e+01, 1.371429e+01, 1.128571e+01, 1.100000e+01, 1.100000e+01, 1.014286e+01, 1.000000e+01, 1.000000e+01, 9.142857e+00, 9.428571e+00, 9.000000e+00, 8.571429e+00, 8.000000e+00, 8.285714e+00, 7.285714e+00, 7.000000e+00, 7.000000e+00, 6.714286e+00, 6.142857e+00, 6.571429e+00, 5.428571e+00, 5.428571e+00, 5.285714e+00, 5.000000e+00, 4.428571e+00, 5.428571e+00, 5.000000e+00, 5.000000e+00, 5.000000e+00, 4.857143e+00, 4.285714e+00, 4.571429e+00, 3.714286e+00, 3.285714e+00, 3.000000e+00, 2.285714e+00, 1.857143e+00, 1.857143e+00, 1.571429e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 1.428571e+00, 1.571429e+00, 1.571429e+00, 1.428571e+00, 1.000000e+00, 8.571429e-01, 8.000000e-01, 3.333333e-01, 0.000000e+00},
    { 2.300000e+01, 7.066667e+01, 1.154000e+02, 1.601429e+02, 1.981429e+02, 2.357143e+02, 2.654286e+02, 2.905714e+02, 3.172857e+02, 3.278571e+02, 3.458571e+02, 3.592857e+02, 3.671429e+02, 3.738571e+02, 3.772857e+02, 3.742857e+02, 3.794286e+02, 3.710000e+02, 3.717143e+02, 3.718571e+02, 3.640000e+02, 3.654286e+02, 3.635714e+02, 3.618571e+02, 3.575714e+02, 3.528571e+02, 3.458571e+02, 3.444286e+02, 3.287143e+02, 3.217143e+02, 3.112857e+02, 3.074286e+02, 2.914286e+02, 2.817143e+02, 2.728571e+02, 2.734286e+02, 2.628571e+02, 2.594286e+02, 2.511429e+02, 2.455714e+02, 2.390000e+02, 2.298571e+02, 2.224286e+02, 2.147143e+02, 2.027143e+02, 1.945714e+02, 1.902857e+02, 1.850000e+02, 1.811429e+02, 1.710000e+02, 1.645714e+02, 1.604286e+02, 1.558571e+02, 1.497143e+02, 1.417143e+02, 1.325714e+02, 1.277143e+02, 1.262857e+02, 1.180000e+02, 1.108571e+02, 1.058571e+02, 1.037143e+02, 1.025714e+02, 9.985714e+01, 9.257143e+01, 9.300000e+01, 9.071429e+01, 8.771429e+01, 8.285714e+01, 7.900000e+01, 7.571429e+01, 7.371429e+01, 6.871429e+01, 6.814286e+01, 6.714286e+01, 6.371429e+01, 6.371429e+01, 6.114286e+01, 6.014286e+01, 5.728571e+01, 5.442857e+01, 5.214286e+01, 5.171429e+01, 4.985714e+01, 5.000000e+01, 4.642857e+01, 4.628571e+01, 4.400000e+01, 4.285714e+01, 4.042857e+01, 3.728571e+01, 3.442857e+01, 3.471429e+01, 3.200000e+01, 2.928571e+01, 2.628571e+01, 2.585714e+01, 2.585714e+01, 2.542857e+01, 2.571429e+01, 2.657143e+01, 2.800000e+01, 2.914286e+01, 2.685714e+01, 2.571429e+01, 2.557143e+01, 2.400000e+01, 2.271429e+01, 2.114286e+01, 1.942857e+01, 1.942857e+01, 1.800000e+01, 1.700000e+01, 1.714286e+01, 1.671429e+01, 1.642857e+01, 1.571429e+01, 1.571429e+01, 1.614286e+01, 1.514286e+01, 1.371429e+01, 1.271429e+01, 1.200000e+01, 1.171429e+01, 1.042857e+01, 9.428571e+00, 8.571429e+00, 9.142857e+00, 8.714286e+00, 8.000000e+00, 8.428571e+00, 9.000000e+00, 9.714286e+00, 9.857143e+00, 9.142857e+00, 8.285714e+00, 8.571429e+00, 7.714286e+00, 7.142857e+00, 6.714286e+00, 6.428571e+00, 6.714286e+00, 7.571429e+00, 8.000000e+00, 7.714286e+00, 7.428571e+00, 7.000000e+00, 6.714286e+00, 6.000000e+00, 5.714286e+00, 5.285714e+00, 4.571429e+00, 4.714286e+00, 4.142857e+00, 4.428571e+00, 4.857143e+00, 4.571429e+00, 4.714286e+00, 4.714286e+00, 4.428571e+00, 4.857143e+00, 4.714286e+00, 3.571429e+00, 3.428571e+00, 2.714286e+00, 2.571429e+00, 2.428571e+00, 1.714286e+00, 1.285714e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.000000e-01, 0.000000e+00, 0.000000e+00},
    { 2.600000e+01, 7.000000e+01, 1.090000e+02, 1.454286e+02, 1.815714e+02, 2.128571e+02, 2.442857e+02, 2.674286e+02, 2.860000e+02, 3.022857e+02, 3.157143e+02, 3.272857e+02, 3.374286e+02, 3.382857e+02, 3.428571e+02, 3.514286e+02, 3.525714e+02, 3.505714e+02, 3.471429e+02, 3.420000e+02, 3.392857e+02, 3.352857e+02, 3.287143e+02, 3.237143e+02, 3.201429e+02, 3.134286e+02, 3.122857e+02, 3.120000e+02, 3.042857e+02, 2.958571e+02, 2.897143e+02, 2.851429e+02, 2.801429e+02, 2.672857e+02, 2.555714e+02, 2.508571e+02, 2.450000e+02, 2.352857e+02, 2.248571e+02, 2.192857e+02, 2.112857e+02, 2.062857e+02, 1.958571e+02, 1.870000e+02, 1.817143e+02, 1.830000e+02, 1.747143e+02, 1.698571e+02, 1.611429e+02, 1.597143e+02, 1.528571e+02, 1.522857e+02, 1.422857e+02, 1.400000e+02, 1.348571e+02, 1.330000e+02, 1.248571e+02, 1.231429e+02, 1.135714e+02, 1.060000e+02, 9.642857e+01, 9.414286e+01, 8.857143e+01, 8.714286e+01, 8.314286e+01, 8.171429e+01, 7.814286e+01, 7.657143e+01, 7.171429e+01, 7.028571e+01, 6.471429e+01, 6.314286e+01, 5.942857e+01, 5.757143e+01, 5.700000e+01, 5.528571e+01, 5.171429e+01, 5.071429e+01, 4.885714e+01, 4.728571e+01, 4.685714e+01, 4.371429e+01, 4.300000e+01, 4.214286e+01, 4.271429e+01, 4.071429e+01, 3.914286e+01, 3.800000e+01, 3.814286e+01, 3.642857e+01, 3.414286e+01, 3.200000e+01, 3.342857e+01, 3.228571e+01, 3.042857e+01, 2.857143e+01, 2.728571e+01, 2.657143e+01, 2.500000e+01, 2.114286e+01, 2.085714e+01, 2.042857e+01, 1.914286e+01, 1.828571e+01, 1.685714e+01, 1.757143e+01, 1.728571e+01, 1.685714e+01, 1.771429e+01, 1.828571e+01, 1.985714e+01, 2.000000e+01, 1.871429e+01, 1.842857e+01, 1.714286e+01, 1.528571e+01, 1.428571e+01, 1.328571e+01, 1.357143e+01, 1.271429e+01, 1.228571e+01, 1.242857e+01, 1.200000e+01, 1.157143e+01, 1.142857e+01, 1.042857e+01, 1.142857e+01, 1.157143e+01, 1.142857e+01, 1.114286e+01, 1.014286e+01, 9.571429e+00, 8.857143e+00, 8.000000e+00, 7.428571e+00, 7.285714e+00, 6.285714e+00, 7.000000e+00, 7.285714e+00, 7.571429e+00, 6.714286e+00, 6.142857e+00, 5.285714e+00, 5.571429e+00, 4.857143e+00, 3.571429e+00, 3.428571e+00, 3.428571e+00, 4.000000e+00, 3.714286e+00, 3.285714e+00, 3.571429e+00, 4.714286e+00, 4.857143e+00, 5.000000e+00, 4.714286e+00, 5.285714e+00, 5.571429e+00, 5.142857e+00, 3.714286e+00, 3.428571e+00, 3.000000e+00, 2.714286e+00, 2.000000e+00, 1.714286e+00, 1.714286e+00, 1.857143e+00, 1.285714e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 7.142857e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.100000e+01, 7.000000e+01, 1.096000e+02, 1.421429e+02, 1.725714e+02, 2.004286e+02, 2.197143e+02, 2.418571e+02, 2.578571e+02, 2.731429e+02, 2.914286e+02, 3.050000e+02, 3.130000e+02, 3.264286e+02, 3.317143e+02, 3.375714e+02, 3.381429e+02, 3.354286e+02, 3.368571e+02, 3.361429e+02, 3.337143e+02, 3.274286e+02, 3.155714e+02, 3.150000e+02, 3.065714e+02, 2.947143e+02, 2.868571e+02, 2.762857e+02, 2.692857e+02, 2.682857e+02, 2.540000e+02, 2.530000e+02, 2.442857e+02, 2.402857e+02, 2.358571e+02, 2.291429e+02, 2.202857e+02, 2.141429e+02, 2.014286e+02, 2.007143e+02, 1.935714e+02, 1.897143e+02, 1.860000e+02, 1.805714e+02, 1.747143e+02, 1.720000e+02, 1.641429e+02, 1.585714e+02, 1.500000e+02, 1.421429e+02, 1.372857e+02, 1.351429e+02, 1.300000e+02, 1.257143e+02, 1.185714e+02, 1.134286e+02, 1.097143e+02, 1.051429e+02, 9.842857e+01, 9.128571e+01, 8.814286e+01, 8.742857e+01, 8.685714e+01, 8.671429e+01, 8.357143e+01, 8.128571e+01, 8.071429e+01, 7.400000e+01, 6.885714e+01, 6.285714e+01, 5.885714e+01, 5.885714e+01, 5.657143e+01, 5.328571e+01, 5.471429e+01, 5.371429e+01, 5.414286e+01, 5.171429e+01, 4.800000e+01, 4.742857e+01, 4.628571e+01, 4.442857e+01, 4.228571e+01, 4.114286e+01, 3.942857e+01, 3.842857e+01, 3.642857e+01, 3.528571e+01, 3.314286e+01, 3.142857e+01, 2.914286e+01, 2.900000e+01, 2.814286e+01, 2.757143e+01, 2.628571e+01, 2.614286e+01, 2.585714e+01, 2.542857e+01, 2.314286e+01, 2.128571e+01, 1.957143e+01, 1.871429e+01, 1.671429e+01, 1.700000e+01, 1.642857e+01, 1.557143e+01, 1.585714e+01, 1.600000e+01, 1.600000e+01, 1.714286e+01, 1.685714e+01, 1.600000e+01, 1.671429e+01, 1.557143e+01, 1.385714e+01, 1.371429e+01, 1.285714e+01, 1.214286e+01, 1.128571e+01, 1.028571e+01, 1.142857e+01, 1.257143e+01, 1.114286e+01, 1.014286e+01, 9.714286e+00, 9.857143e+00, 9.857143e+00, 8.285714e+00, 7.571429e+00, 8.142857e+00, 8.857143e+00, 8.142857e+00, 8.285714e+00, 7.571429e+00, 8.000000e+00, 7.857143e+00, 7.142857e+00, 6.857143e+00, 7.000000e+00, 7.142857e+00, 7.571429e+00, 7.142857e+00, 6.571429e+00, 6.285714e+00, 5.000000e+00, 4.571429e+00, 3.714286e+00, 3.428571e+00, 3.428571e+00, 3.428571e+00, 3.571429e+00, 3.428571e+00, 3.571429e+00, 3.857143e+00, 4.000000e+00, 3.571429e+00, 3.714286e+00, 3.285714e+00, 3.571429e+00, 3.285714e+00, 2.714286e+00, 2.285714e+00, 2.142857e+00, 2.000000e+00, 2.142857e+00, 1.857143e+00, 1.857143e+00, 1.714286e+00, 1.428571e+00, 1.285714e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.000000e-01, 0.000000e+00, 0.000000e+00},
    { 2.200000e+01, 6.300000e+01, 9.360000e+01, 1.280000e+02, 1.602857e+02, 1.872857e+02, 2.075714e+02, 2.311429e+02, 2.524286e+02, 2.650000e+02, 2.760000e+02, 2.838571e+02, 2.931429e+02, 3.011429e+02, 2.994286e+02, 3.032857e+02, 3.064286e+02, 3.022857e+02, 3.007143e+02, 2.990000e+02, 2.945714e+02, 2.924286e+02, 2.892857e+02, 2.860000e+02, 2.847143e+02, 2.781429e+02, 2.664286e+02, 2.640000e+02, 2.572857e+02, 2.467143e+02, 2.392857e+02, 2.288571e+02, 2.215714e+02, 2.154286e+02, 2.085714e+02, 2.015714e+02, 1.951429e+02, 1.887143e+02, 1.832857e+02, 1.801429e+02, 1.768571e+02, 1.687143e+02, 1.670000e+02, 1.587143e+02, 1.520000e+02, 1.498571e+02, 1.432857e+02, 1.387143e+02, 1.348571e+02, 1.285714e+02, 1.295714e+02, 1.247143e+02, 1.202857e+02, 1.151429e+02, 1.127143e+02, 1.078571e+02, 1.038571e+02, 9.671429e+01, 9.357143e+01, 8.785714e+01, 8.514286e+01, 8.214286e+01, 8.000000e+01, 7.542857e+01, 7.314286e+01, 6.914286e+01, 6.700000e+01, 6.571429e+01, 6.157143e+01, 5.571429e+01, 5.328571e+01, 5.114286e+01, 4.971429e+01, 4.714286e+01, 4.385714e+01, 4.228571e+01, 4.271429e+01, 4.200000e+01, 4.000000e+01, 3.885714e+01, 3.757143e+01, 3.571429e+01, 3.400000e+01, 3.271429e+01, 3.228571e+01, 3.100000e+01, 2.871429e+01, 2.828571e+01, 2.871429e+01, 2.800000e+01, 2.771429e+01, 2.700000e+01, 2.657143e+01, 2.642857e+01, 2.528571e+01, 2.285714e+01, 2.271429e+01, 2.128571e+01, 1.942857e+01, 1.828571e+01, 1.742857e+01, 1.714286e+01, 1.700000e+01, 1.614286e+01, 1.585714e+01, 1.700000e+01, 1.714286e+01, 1.657143e+01, 1.700000e+01, 1.728571e+01, 1.785714e+01, 1.785714e+01, 1.571429e+01, 1.485714e+01, 1.500000e+01, 1.328571e+01, 1.257143e+01, 1.057143e+01, 9.571429e+00, 9.428571e+00, 9.000000e+00, 8.428571e+00, 8.571429e+00, 8.142857e+00, 8.142857e+00, 8.000000e+00, 7.857143e+00, 7.714286e+00, 6.857143e+00, 6.428571e+00, 6.714286e+00, 5.857143e+00, 5.285714e+00, 5.142857e+00, 5.000000e+00, 5.285714e+00, 5.000000e+00, 5.000000e+00, 5.142857e+00, 5.714286e+00, 5.857143e+00, 5.285714e+00, 5.000000e+00, 5.000000e+00, 4.857143e+00, 5.571429e+00, 4.714286e+00, 4.714286e+00, 5.142857e+00, 5.714286e+00, 5.714286e+00, 5.428571e+00, 4.571429e+00, 4.285714e+00, 3.714286e+00, 3.714286e+00, 2.857143e+00, 2.714286e+00, 2.142857e+00, 2.714286e+00, 3.000000e+00, 3.000000e+00, 2.428571e+00, 2.571429e+00, 2.142857e+00, 2.142857e+00, 1.428571e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 6.000000e-01, 6.666667e-01, 0.000000e+00},
    { 1.800000e+01, 5.533333e+01, 8.680000e+01, 1.158571e+02, 1.434286e+02, 1.690000e+02, 1.975714e+02, 2.174286e+02, 2.340000e+02, 2.467143e+02, 2.570000e+02, 2.674286e+02, 2.731429e+02, 2.730000e+02, 2.780000e+02, 2.755714e+02, 2.764286e+02, 2.781429e+02, 2.728571e+02, 2.694286e+02, 2.660000e+02, 2.634286e+02, 2.575714e+02, 2.515714e+02, 2.478571e+02, 2.428571e+02, 2.364286e+02, 2.312857e+02, 2.221429e+02, 2.214286e+02, 2.147143e+02, 2.064286e+02, 2.052857e+02, 2.055714e+02, 1.992857e+02, 1.962857e+02, 1.904286e+02, 1.855714e+02, 1.781429e+02, 1.724286e+02, 1.632857e+02, 1.585714e+02, 1.554286e+02, 1.501429e+02, 1.445714e+02, 1.420000e+02, 1.370000e+02, 1.295714e+02, 1.231429e+02, 1.140000e+02, 1.094286e+02, 1.067143e+02, 1.045714e+02, 9.757143e+01, 9.671429e+01, 9.385714e+01, 9.285714e+01, 9.100000e+01, 8.842857e+01, 8.185714e+01, 8.042857e+01, 7.700000e+01, 7.414286e+01, 7.071429e+01, 6.657143e+01, 6.285714e+01, 6.214286e+01, 5.914286e+01, 5.571429e+01, 5.200000e+01, 5.100000e+01, 4.957143e+01, 4.728571e+01, 4.514286e+01, 4.400000e+01, 4.271429e+01, 4.200000e+01, 3.800000e+01, 3.714286e+01, 3.557143e+01, 3.385714e+01, 3.328571e+01, 3.271429e+01, 3.314286e+01, 3.414286e+01, 3.171429e+01, 3.214286e+01, 3.042857e+01, 2.785714e+01, 2.714286e+01, 2.557143e+01, 2.442857e+01, 2.200000e+01, 2.014286e+01, 2.014286e+01, 2.100000e+01, 1.942857e+01, 1.785714e+01, 1.600000e+01, 1.528571e+01, 1.600000e+01, 1.471429e+01, 1.285714e+01, 1.257143e+01, 1.271429e+01, 1.242857e+01, 1.428571e+01, 1.342857e+01, 1.314286e+01, 1.257143e+01, 1.214286e+01, 1.228571e+01, 1.200000e+01, 1.057143e+01, 1.000000e+01, 9.571429e+00, 1.000000e+01, 9.285714e+00, 8.714286e+00, 9.571429e+00, 9.000000e+00, 8.428571e+00, 8.428571e+00, 7.428571e+00, 7.142857e+00, 7.000000e+00, 6.142857e+00, 6.000000e+00, 6.285714e+00, 6.000000e+00, 7.714286e+00, 7.000000e+00, 7.571429e+00, 6.857143e+00, 7.000000e+00, 6.428571e+00, 6.857143e+00, 5.142857e+00, 5.285714e+00, 3.857143e+00, 4.000000e+00, 3.714286e+00, 3.428571e+00, 2.714286e+00, 2.428571e+00, 2.285714e+00, 2.857143e+00, 2.857143e+00, 2.714286e+00, 2.714286e+00, 2.428571e+00, 2.571429e+00, 2.714286e+00, 2.285714e+00, 2.000000e+00, 2.142857e+00, 2.285714e+00, 2.571429e+00, 2.428571e+00, 2.428571e+00, 2.285714e+00, 2.428571e+00, 1.857143e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 1.428571e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 5.714286e-01, 4.285714e-01, 4.000000e-01, 3.333333e-01, 1.000000e+00},
    { 2.600000e+01, 6.200000e+01, 9.480000e+01, 1.205714e+02, 1.490000e+02, 1.760000e+02, 1.931429e+02, 2.104286e+02, 2.222857e+02, 2.332857e+02, 2.468571e+02, 2.502857e+02, 2.518571e+02, 2.555714e+02, 2.578571e+02, 2.562857e+02, 2.567143e+02, 2.535714e+02, 2.548571e+02, 2.552857e+02, 2.524286e+02, 2.485714e+02, 2.441429e+02, 2.402857e+02, 2.364286e+02, 2.304286e+02, 2.242857e+02, 2.217143e+02, 2.160000e+02, 2.155714e+02, 2.104286e+02, 2.051429e+02, 2.010000e+02, 1.974286e+02, 1.917143e+02, 1.848571e+02, 1.801429e+02, 1.731429e+02, 1.670000e+02, 1.620000e+02, 1.534286e+02, 1.457143e+02, 1.432857e+02, 1.384286e+02, 1.318571e+02, 1.267143e+02, 1.211429e+02, 1.170000e+02, 1.142857e+02, 1.072857e+02, 1.001429e+02, 9.785714e+01, 9.385714e+01, 9.085714e+01, 8.714286e+01, 8.328571e+01, 8.228571e+01, 8.071429e+01, 7.842857e+01, 7.500000e+01, 6.871429e+01, 6.500000e+01, 6.228571e+01, 5.757143e+01, 5.528571e+01, 5.228571e+01, 4.842857e+01, 4.828571e+01, 4.585714e+01, 4.457143e+01, 4.342857e+01, 4.028571e+01, 3.828571e+01, 3.871429e+01, 3.685714e+01, 3.814286e+01, 3.642857e+01, 3.557143e+01, 3.700000e+01, 3.585714e+01, 3.485714e+01, 3.342857e+01, 3.185714e+01, 3.000000e+01, 2.942857e+01, 2.628571e+01, 2.614286e+01, 2.328571e+01, 2.157143e+01, 2.014286e+01, 1.914286e+01, 1.971429e+01, 1.928571e+01, 1.800000e+01, 1.914286e+01, 1.885714e+01, 1.814286e+01, 1.814286e+01, 1.528571e+01, 1.471429e+01, 1.400000e+01, 1.442857e+01, 1.457143e+01, 1.471429e+01, 1.485714e+01, 1.528571e+01, 1.457143e+01, 1.400000e+01, 1.200000e+01, 1.157143e+01, 1.142857e+01, 1.071429e+01, 1.142857e+01, 1.200000e+01, 1.185714e+01, 1.171429e+01, 1.228571e+01, 1.157143e+01, 1.071429e+01, 8.857143e+00, 8.571429e+00, 8.142857e+00, 7.571429e+00, 6.857143e+00, 6.285714e+00, 6.857143e+00, 7.571429e+00, 6.714286e+00, 7.000000e+00, 6.428571e+00, 6.000000e+00, 6.000000e+00, 5.571429e+00, 4.857143e+00, 4.285714e+00, 3.857143e+00, 3.857143e+00, 3.857143e+00, 3.714286e+00, 3.285714e+00, 3.000000e+00, 3.285714e+00, 2.857143e+00, 3.285714e+00, 3.000000e+00, 2.714286e+00, 3.000000e+00, 3.142857e+00, 3.571429e+00, 3.857143e+00, 3.285714e+00, 3.571429e+00, 3.142857e+00, 3.142857e+00, 2.857143e+00, 2.428571e+00, 2.142857e+00, 2.142857e+00, 1.857143e+00, 2.000000e+00, 1.571429e+00, 2.428571e+00, 2.142857e+00, 2.000000e+00, 1.714286e+00, 1.571429e+00, 1.571429e+00, 1.857143e+00, 8.571429e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.300000e+01, 5.500000e+01, 8.820000e+01, 1.064286e+02, 1.322857e+02, 1.525714e+02, 1.708571e+02, 1.891429e+02, 2.001429e+02, 2.212857e+02, 2.258571e+02, 2.320000e+02, 2.391429e+02, 2.454286e+02, 2.448571e+02, 2.395714e+02, 2.338571e+02, 2.365714e+02, 2.348571e+02, 2.345714e+02, 2.268571e+02, 2.230000e+02, 2.225714e+02, 2.170000e+02, 2.114286e+02, 2.038571e+02, 1.948571e+02, 1.952857e+02, 1.927143e+02, 1.902857e+02, 1.850000e+02, 1.815714e+02, 1.797143e+02, 1.771429e+02, 1.692857e+02, 1.587143e+02, 1.502857e+02, 1.452857e+02, 1.422857e+02, 1.372857e+02, 1.320000e+02, 1.282857e+02, 1.275714e+02, 1.275714e+02, 1.231429e+02, 1.180000e+02, 1.140000e+02, 1.085714e+02, 1.031429e+02, 1.005714e+02, 9.457143e+01, 9.128571e+01, 8.942857e+01, 8.300000e+01, 8.114286e+01, 8.000000e+01, 7.414286e+01, 7.357143e+01, 7.171429e+01, 6.457143e+01, 6.285714e+01, 5.871429e+01, 5.785714e+01, 5.614286e+01, 5.228571e+01, 5.114286e+01, 5.142857e+01, 4.942857e+01, 4.642857e+01, 4.357143e+01, 4.328571e+01, 4.071429e+01, 3.942857e+01, 3.742857e+01, 3.785714e+01, 3.742857e+01, 3.457143e+01, 3.257143e+01, 3.300000e+01, 3.071429e+01, 3.000000e+01, 2.885714e+01, 2.800000e+01, 2.657143e+01, 2.585714e+01, 2.614286e+01, 2.628571e+01, 2.457143e+01, 2.300000e+01, 2.171429e+01, 2.114286e+01, 2.114286e+01, 1.914286e+01, 1.671429e+01, 1.628571e+01, 1.571429e+01, 1.485714e+01, 1.500000e+01, 1.385714e+01, 1.185714e+01, 1.242857e+01, 1.371429e+01, 1.328571e+01, 1.428571e+01, 1.371429e+01, 1.328571e+01, 1.342857e+01, 1.314286e+01, 1.128571e+01, 1.042857e+01, 9.000000e+00, 8.857143e+00, 8.142857e+00, 7.857143e+00, 7.000000e+00, 6.714286e+00, 7.857143e+00, 8.142857e+00, 7.714286e+00, 7.428571e+00, 7.000000e+00, 7.857143e+00, 7.428571e+00, 6.000000e+00, 5.428571e+00, 5.000000e+00, 5.285714e+00, 5.000000e+00, 4.000000e+00, 4.428571e+00, 4.571429e+00, 4.285714e+00, 4.285714e+00, 4.000000e+00, 4.285714e+00, 3.571429e+00, 3.714286e+00, 3.714286e+00, 4.000000e+00, 3.857143e+00, 3.857143e+00, 3.571429e+00, 3.857143e+00, 3.571429e+00, 3.571429e+00, 3.142857e+00, 2.714286e+00, 2.571429e+00, 2.714286e+00, 2.714286e+00, 2.714286e+00, 2.000000e+00, 2.142857e+00, 2.285714e+00, 2.000000e+00, 1.714286e+00, 1.714286e+00, 1.428571e+00, 1.571429e+00, 1.714286e+00, 1.571429e+00, 1.857143e+00, 1.428571e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.900000e+01, 5.033333e+01, 7.640000e+01, 9.842857e+01, 1.210000e+02, 1.402857e+02, 1.548571e+02, 1.722857e+02, 1.868571e+02, 1.972857e+02, 2.080000e+02, 2.144286e+02, 2.208571e+02, 2.275714e+02, 2.271429e+02, 2.298571e+02, 2.227143e+02, 2.234286e+02, 2.234286e+02, 2.228571e+02, 2.195714e+02, 2.117143e+02, 2.078571e+02, 2.080000e+02, 2.028571e+02, 2.007143e+02, 1.955714e+02, 1.894286e+02, 1.888571e+02, 1.811429e+02, 1.795714e+02, 1.751429e+02, 1.671429e+02, 1.615714e+02, 1.538571e+02, 1.507143e+02, 1.454286e+02, 1.407143e+02, 1.335714e+02, 1.295714e+02, 1.224286e+02, 1.231429e+02, 1.181429e+02, 1.131429e+02, 1.064286e+02, 1.031429e+02, 9.842857e+01, 9.400000e+01, 8.857143e+01, 8.400000e+01, 8.142857e+01, 8.000000e+01, 7.542857e+01, 7.114286e+01, 7.114286e+01, 6.700000e+01, 6.600000e+01, 6.328571e+01, 6.057143e+01, 5.985714e+01, 5.885714e+01, 5.614286e+01, 5.585714e+01, 5.171429e+01, 5.014286e+01, 4.657143e+01, 4.485714e+01, 4.314286e+01, 4.042857e+01, 3.700000e+01, 3.600000e+01, 3.400000e+01, 3.400000e+01, 3.185714e+01, 3.057143e+01, 3.071429e+01, 2.985714e+01, 2.800000e+01, 2.657143e+01, 2.628571e+01, 2.500000e+01, 2.385714e+01, 2.142857e+01, 2.128571e+01, 2.185714e+01, 2.214286e+01, 2.128571e+01, 2.085714e+01, 2.057143e+01, 2.114286e+01, 2.100000e+01, 1.914286e+01, 1.842857e+01, 1.714286e+01, 1.614286e+01, 1.457143e+01, 1.328571e+01, 1.257143e+01, 1.157143e+01, 1.071429e+01, 1.057143e+01, 1.057143e+01, 1.071429e+01, 1.100000e+01, 1.100000e+01, 1.214286e+01, 1.128571e+01, 1.100000e+01, 1.000000e+01, 9.000000e+00, 7.857143e+00, 6.571429e+00, 5.571429e+00, 6.285714e+00, 5.571429e+00, 6.857143e+00, 7.142857e+00, 7.571429e+00, 8.285714e+00, 8.571429e+00, 8.142857e+00, 8.000000e+00, 6.285714e+00, 5.714286e+00, 6.000000e+00, 5.857143e+00, 5.285714e+00, 4.571429e+00, 4.571429e+00, 5.000000e+00, 5.285714e+00, 4.857143e+00, 4.428571e+00, 4.142857e+00, 4.428571e+00, 4.000000e+00, 3.857143e+00, 3.428571e+00, 2.714286e+00, 3.000000e+00, 3.000000e+00, 2.428571e+00, 3.142857e+00, 3.000000e+00, 2.857143e+00, 2.857143e+00, 2.285714e+00, 2.142857e+00, 2.285714e+00, 1.571429e+00, 1.571429e+00, 1.428571e+00, 2.000000e+00, 2.428571e+00, 2.285714e+00, 2.428571e+00, 2.857143e+00, 2.714286e+00, 2.714286e+00, 2.142857e+00, 1.571429e+00, 1.857143e+00, 1.857143e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 1.142857e+00, 1.285714e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.000000e-01, 3.333333e-01, 0.000000e+00},
    { 1.400000e+01, 4.466667e+01, 6.900000e+01, 8.985714e+01, 1.131429e+02, 1.352857e+02, 1.530000e+02, 1.655714e+02, 1.751429e+02, 1.844286e+02, 1.905714e+02, 1.954286e+02, 1.982857e+02, 1.914286e+02, 1.920000e+02, 1.942857e+02, 1.941429e+02, 1.971429e+02, 1.957143e+02, 1.921429e+02, 1.992857e+02, 1.974286e+02, 1.910000e+02, 1.848571e+02, 1.761429e+02, 1.720000e+02, 1.725714e+02, 1.665714e+02, 1.655714e+02, 1.658571e+02, 1.601429e+02, 1.582857e+02, 1.514286e+02, 1.457143e+02, 1.398571e+02, 1.338571e+02, 1.282857e+02, 1.258571e+02, 1.224286e+02, 1.205714e+02, 1.137143e+02, 1.108571e+02, 1.047143e+02, 1.011429e+02, 9.842857e+01, 9.242857e+01, 8.585714e+01, 8.114286e+01, 7.771429e+01, 7.428571e+01, 7.085714e+01, 6.614286e+01, 6.742857e+01, 6.542857e+01, 6.371429e+01, 5.871429e+01, 5.914286e+01, 5.842857e+01, 5.871429e+01, 5.385714e+01, 5.385714e+01, 4.985714e+01, 4.857143e+01, 4.628571e+01, 4.285714e+01, 4.128571e+01, 3.971429e+01, 3.528571e+01, 3.600000e+01, 3.442857e+01, 3.228571e+01, 3.128571e+01, 3.028571e+01, 2.828571e+01, 2.885714e+01, 2.700000e+01, 2.614286e+01, 2.457143e+01, 2.371429e+01, 2.157143e+01, 2.142857e+01, 2.200000e+01, 2.142857e+01, 2.100000e+01, 1.971429e+01, 1.885714e+01, 1.900000e+01, 1.785714e+01, 1.614286e+01, 1.542857e+01, 1.457143e+01, 1.528571e+01, 1.442857e+01, 1.385714e+01, 1.357143e+01, 1.242857e+01, 1.242857e+01, 1.271429e+01, 1.171429e+01, 1.114286e+01, 1.157143e+01, 1.185714e+01, 1.185714e+01, 1.114286e+01, 1.071429e+01, 1.042857e+01, 1.042857e+01, 9.000000e+00, 8.285714e+00, 8.142857e+00, 7.285714e+00, 6.285714e+00, 6.142857e+00, 5.428571e+00, 5.428571e+00, 5.142857e+00, 4.857143e+00, 5.000000e+00, 5.000000e+00, 4.285714e+00, 4.571429e+00, 4.285714e+00, 4.428571e+00, 4.142857e+00, 4.428571e+00, 4.428571e+00, 5.142857e+00, 5.428571e+00, 5.571429e+00, 4.857143e+00, 4.571429e+00, 4.571429e+00, 4.571429e+00, 3.714286e+00, 2.857143e+00, 2.714286e+00, 3.142857e+00, 3.285714e+00, 2.857143e+00, 2.571429e+00, 2.571429e+00, 2.571429e+00, 2.142857e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 1.714286e+00, 1.571429e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.285714e+00, 1.571429e+00, 1.571429e+00, 1.285714e+00, 1.000000e+00, 7.142857e-01, 8.571429e-01, 1.000000e+00, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.000000e-01, 0.000000e+00, 0.000000e+00},
    { 9.000000e+00, 4.166667e+01, 6.260000e+01, 8.157143e+01, 1.015714e+02, 1.212857e+02, 1.335714e+02, 1.515714e+02, 1.630000e+02, 1.722857e+02, 1.790000e+02, 1.834286e+02, 1.837143e+02, 1.915714e+02, 1.898571e+02, 1.911429e+02, 1.890000e+02, 1.884286e+02, 1.895714e+02, 1.890000e+02, 1.865714e+02, 1.822857e+02, 1.791429e+02, 1.785714e+02, 1.720000e+02, 1.681429e+02, 1.641429e+02, 1.585714e+02, 1.547143e+02, 1.465714e+02, 1.388571e+02, 1.345714e+02, 1.330000e+02, 1.268571e+02, 1.194286e+02, 1.170000e+02, 1.145714e+02, 1.137143e+02, 1.112857e+02, 1.031429e+02, 1.014286e+02, 9.800000e+01, 9.628571e+01, 9.285714e+01, 8.714286e+01, 8.457143e+01, 8.100000e+01, 7.742857e+01, 7.271429e+01, 6.785714e+01, 6.285714e+01, 6.300000e+01, 6.085714e+01, 6.000000e+01, 5.942857e+01, 5.871429e+01, 5.571429e+01, 5.485714e+01, 5.300000e+01, 4.914286e+01, 4.528571e+01, 4.242857e+01, 4.100000e+01, 3.871429e+01, 3.757143e+01, 3.600000e+01, 3.600000e+01, 3.500000e+01, 3.485714e+01, 3.271429e+01, 3.214286e+01, 3.157143e+01, 3.014286e+01, 2.828571e+01, 2.757143e+01, 2.342857e+01, 2.328571e+01, 2.300000e+01, 2.128571e+01, 1.928571e+01, 1.842857e+01, 1.785714e+01, 1.785714e+01, 1.728571e+01, 1.628571e+01, 1.471429e+01, 1.500000e+01, 1.457143e+01, 1.357143e+01, 1.357143e+01, 1.328571e+01, 1.200000e+01, 1.185714e+01, 1.057143e+01, 1.000000e+01, 9.285714e+00, 8.285714e+00, 8.000000e+00, 8.428571e+00, 8.428571e+00, 8.714286e+00, 9.142857e+00, 9.571429e+00, 9.428571e+00, 8.428571e+00, 7.428571e+00, 7.571429e+00, 7.428571e+00, 7.000000e+00, 6.571429e+00, 7.285714e+00, 7.000000e+00, 7.285714e+00, 6.428571e+00, 5.714286e+00, 4.857143e+00, 4.714286e+00, 4.428571e+00, 4.285714e+00, 4.285714e+00, 3.857143e+00, 4.285714e+00, 4.142857e+00, 4.142857e+00, 3.142857e+00, 3.571429e+00, 3.571429e+00, 4.142857e+00, 4.000000e+00, 4.857143e+00, 4.571429e+00, 4.428571e+00, 3.571429e+00, 3.428571e+00, 3.000000e+00, 2.857143e+00, 2.571429e+00, 2.142857e+00, 2.142857e+00, 2.285714e+00, 2.000000e+00, 1.857143e+00, 2.000000e+00, 1.428571e+00, 1.714286e+00, 1.571429e+00, 1.714286e+00, 1.714286e+00, 2.000000e+00, 1.571429e+00, 1.714286e+00, 1.285714e+00, 2.142857e+00, 2.285714e+00, 2.142857e+00, 2.000000e+00, 1.857143e+00, 1.714286e+00, 2.000000e+00, 1.285714e+00, 8.571429e-01, 1.142857e+00, 1.000000e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 9.000000e+00, 3.800000e+01, 6.400000e+01, 8.300000e+01, 1.050000e+02, 1.240000e+02, 1.415714e+02, 1.490000e+02, 1.570000e+02, 1.615714e+02, 1.681429e+02, 1.750000e+02, 1.742857e+02, 1.744286e+02, 1.788571e+02, 1.808571e+02, 1.837143e+02, 1.877143e+02, 1.808571e+02, 1.797143e+02, 1.764286e+02, 1.735714e+02, 1.694286e+02, 1.672857e+02, 1.590000e+02, 1.551429e+02, 1.520000e+02, 1.462857e+02, 1.408571e+02, 1.377143e+02, 1.338571e+02, 1.298571e+02, 1.288571e+02, 1.250000e+02, 1.234286e+02, 1.174286e+02, 1.137143e+02, 1.090000e+02, 1.034286e+02, 9.842857e+01, 9.442857e+01, 8.785714e+01, 8.742857e+01, 8.300000e+01, 7.914286e+01, 7.542857e+01, 7.200000e+01, 6.928571e+01, 6.728571e+01, 6.457143e+01, 6.200000e+01, 5.928571e+01, 5.600000e+01, 5.157143e+01, 4.842857e+01, 4.642857e+01, 4.357143e+01, 4.200000e+01, 4.000000e+01, 3.900000e+01, 3.685714e+01, 3.471429e+01, 3.400000e+01, 3.271429e+01, 3.114286e+01, 3.042857e+01, 2.928571e+01, 2.942857e+01, 2.885714e+01, 2.857143e+01, 2.671429e+01, 2.471429e+01, 2.285714e+01, 2.400000e+01, 2.371429e+01, 2.242857e+01, 2.057143e+01, 2.057143e+01, 2.042857e+01, 2.000000e+01, 1.757143e+01, 1.671429e+01, 1.671429e+01, 1.500000e+01, 1.457143e+01, 1.528571e+01, 1.457143e+01, 1.400000e+01, 1.342857e+01, 1.314286e+01, 1.328571e+01, 1.271429e+01, 1.085714e+01, 1.057143e+01, 1.157143e+01, 1.071429e+01, 9.857143e+00, 9.857143e+00, 9.857143e+00, 1.028571e+01, 1.085714e+01, 8.857143e+00, 9.428571e+00, 9.285714e+00, 8.571429e+00, 8.428571e+00, 7.714286e+00, 6.285714e+00, 6.142857e+00, 5.000000e+00, 4.428571e+00, 4.571429e+00, 3.714286e+00, 3.714286e+00, 3.857143e+00, 4.428571e+00, 4.142857e+00, 4.428571e+00, 4.571429e+00, 4.428571e+00, 4.428571e+00, 4.428571e+00, 3.714286e+00, 4.142857e+00, 4.000000e+00, 3.857143e+00, 3.857143e+00, 3.857143e+00, 3.428571e+00, 3.714286e+00, 3.428571e+00, 3.000000e+00, 3.142857e+00, 3.285714e+00, 3.285714e+00, 3.285714e+00, 3.000000e+00, 3.000000e+00, 3.285714e+00, 2.857143e+00, 3.000000e+00, 2.857143e+00, 2.857143e+00, 2.571429e+00, 2.714286e+00, 2.571429e+00, 2.285714e+00, 1.857143e+00, 1.857143e+00, 1.857143e+00, 2.142857e+00, 1.714286e+00, 1.571429e+00, 1.714286e+00, 1.714286e+00, 1.857143e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.000000e+00, 5.714286e-01, 5.714286e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.300000e+01, 3.900000e+01, 5.400000e+01, 7.200000e+01, 8.957143e+01, 1.018571e+02, 1.128571e+02, 1.267143e+02, 1.371429e+02, 1.425714e+02, 1.484286e+02, 1.488571e+02, 1.547143e+02, 1.567143e+02, 1.597143e+02, 1.571429e+02, 1.582857e+02, 1.604286e+02, 1.632857e+02, 1.612857e+02, 1.580000e+02, 1.534286e+02, 1.525714e+02, 1.472857e+02, 1.395714e+02, 1.374286e+02, 1.335714e+02, 1.298571e+02, 1.272857e+02, 1.224286e+02, 1.201429e+02, 1.158571e+02, 1.094286e+02, 1.075714e+02, 1.038571e+02, 9.957143e+01, 9.685714e+01, 9.485714e+01, 9.242857e+01, 8.914286e+01, 8.600000e+01, 8.357143e+01, 7.928571e+01, 7.714286e+01, 7.171429e+01, 7.057143e+01, 6.657143e+01, 6.171429e+01, 5.900000e+01, 5.757143e+01, 5.371429e+01, 5.357143e+01, 5.057143e+01, 5.071429e+01, 4.928571e+01, 4.885714e+01, 4.657143e+01, 4.414286e+01, 4.157143e+01, 3.942857e+01, 3.771429e+01, 3.585714e+01, 3.328571e+01, 3.128571e+01, 2.985714e+01, 2.771429e+01, 2.771429e+01, 2.400000e+01, 2.314286e+01, 2.257143e+01, 2.271429e+01, 2.214286e+01, 2.300000e+01, 2.185714e+01, 2.257143e+01, 2.214286e+01, 2.171429e+01, 2.042857e+01, 1.900000e+01, 1.871429e+01, 1.700000e+01, 1.628571e+01, 1.485714e+01, 1.371429e+01, 1.342857e+01, 1.357143e+01, 1.114286e+01, 1.214286e+01, 1.300000e+01, 1.328571e+01, 1.257143e+01, 1.285714e+01, 1.242857e+01, 1.300000e+01, 1.057143e+01, 9.857143e+00, 9.142857e+00, 9.000000e+00, 7.714286e+00, 7.714286e+00, 6.714286e+00, 8.000000e+00, 7.285714e+00, 7.142857e+00, 7.428571e+00, 7.714286e+00, 6.857143e+00, 7.428571e+00, 6.571429e+00, 6.142857e+00, 6.285714e+00, 5.571429e+00, 5.000000e+00, 4.857143e+00, 4.000000e+00, 4.000000e+00, 4.285714e+00, 3.571429e+00, 3.428571e+00, 3.714286e+00, 4.857143e+00, 5.285714e+00, 5.000000e+00, 4.428571e+00, 4.571429e+00, 4.714286e+00, 4.000000e+00, 3.000000e+00, 2.428571e+00, 2.142857e+00, 2.142857e+00, 1.857143e+00, 2.000000e+00, 2.142857e+00, 2.428571e+00, 2.428571e+00, 2.571429e+00, 2.285714e+00, 2.285714e+00, 2.142857e+00, 2.000000e+00, 1.714286e+00, 1.857143e+00, 1.571429e+00, 1.857143e+00, 1.857143e+00, 1.571429e+00, 1.857143e+00, 1.428571e+00, 1.142857e+00, 1.428571e+00, 1.142857e+00, 1.142857e+00, 8.571429e-01, 7.142857e-01, 7.142857e-01, 1.000000e+00, 8.571429e-01, 1.000000e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 8.571429e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.000000e-01, 0.000000e+00, 0.000000e+00},
    { 1.300000e+01, 3.366667e+01, 5.340000e+01, 6.885714e+01, 8.714286e+01, 1.025714e+02, 1.178571e+02, 1.264286e+02, 1.368571e+02, 1.430000e+02, 1.480000e+02, 1.512857e+02, 1.525714e+02, 1.521429e+02, 1.512857e+02, 1.501429e+02, 1.498571e+02, 1.485714e+02, 1.444286e+02, 1.402857e+02, 1.375714e+02, 1.350000e+02, 1.301429e+02, 1.288571e+02, 1.242857e+02, 1.214286e+02, 1.167143e+02, 1.158571e+02, 1.125714e+02, 1.115714e+02, 1.042857e+02, 1.022857e+02, 9.985714e+01, 9.885714e+01, 9.085714e+01, 8.871429e+01, 8.657143e+01, 8.642857e+01, 8.428571e+01, 7.985714e+01, 7.728571e+01, 7.700000e+01, 7.414286e+01, 7.014286e+01, 6.571429e+01, 6.157143e+01, 6.128571e+01, 5.928571e+01, 5.771429e+01, 5.542857e+01, 5.328571e+01, 5.271429e+01, 5.114286e+01, 4.957143e+01, 4.585714e+01, 4.285714e+01, 3.942857e+01, 3.800000e+01, 3.457143e+01, 3.414286e+01, 3.042857e+01, 2.857143e+01, 2.657143e+01, 2.814286e+01, 2.657143e+01, 2.700000e+01, 2.542857e+01, 2.414286e+01, 2.514286e+01, 2.457143e+01, 2.242857e+01, 2.200000e+01, 2.057143e+01, 1.985714e+01, 1.928571e+01, 1.785714e+01, 1.785714e+01, 1.800000e+01, 1.657143e+01, 1.600000e+01, 1.528571e+01, 1.442857e+01, 1.457143e+01, 1.342857e+01, 1.300000e+01, 1.342857e+01, 1.242857e+01, 1.157143e+01, 1.157143e+01, 1.014286e+01, 9.714286e+00, 8.285714e+00, 7.285714e+00, 7.142857e+00, 7.428571e+00, 6.428571e+00, 6.428571e+00, 6.571429e+00, 6.571429e+00, 6.571429e+00, 6.571429e+00, 6.142857e+00, 6.571429e+00, 6.571429e+00, 6.428571e+00, 5.857143e+00, 5.285714e+00, 5.714286e+00, 5.714286e+00, 5.571429e+00, 4.857143e+00, 4.428571e+00, 4.714286e+00, 4.714286e+00, 3.857143e+00, 3.571429e+00, 3.571429e+00, 4.000000e+00, 3.714286e+00, 2.857143e+00, 3.000000e+00, 3.285714e+00, 3.000000e+00, 2.857143e+00, 2.428571e+00, 2.714286e+00, 2.571429e+00, 2.571429e+00, 2.285714e+00, 2.000000e+00, 1.714286e+00, 1.714286e+00, 1.285714e+00, 1.428571e+00, 1.571429e+00, 2.000000e+00, 2.285714e+00, 2.285714e+00, 2.571429e+00, 2.428571e+00, 2.285714e+00, 1.714286e+00, 1.285714e+00, 1.285714e+00, 1.571429e+00, 1.285714e+00, 1.571429e+00, 1.714286e+00, 1.714286e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 8.571429e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.100000e+01, 2.766667e+01, 5.000000e+01, 6.628571e+01, 8.271429e+01, 9.571429e+01, 1.091429e+02, 1.168571e+02, 1.262857e+02, 1.297143e+02, 1.347143e+02, 1.382857e+02, 1.434286e+02, 1.405714e+02, 1.458571e+02, 1.418571e+02, 1.402857e+02, 1.390000e+02, 1.344286e+02, 1.328571e+02, 1.331429e+02, 1.267143e+02, 1.271429e+02, 1.271429e+02, 1.241429e+02, 1.224286e+02, 1.181429e+02, 1.150000e+02, 1.121429e+02, 1.088571e+02, 1.044286e+02, 1.004286e+02, 9.757143e+01, 9.371429e+01, 9.085714e+01, 8.842857e+01, 8.571429e+01, 8.228571e+01, 7.942857e+01, 7.757143e+01, 7.371429e+01, 7.228571e+01, 6.900000e+01, 6.328571e+01, 6.157143e+01, 5.942857e+01, 5.628571e+01, 5.342857e+01, 5.114286e+01, 4.885714e+01, 4.700000e+01, 4.371429e+01, 4.142857e+01, 3.871429e+01, 3.885714e+01, 3.657143e+01, 3.528571e+01, 3.514286e+01, 3.371429e+01, 3.271429e+01, 3.185714e+01, 2.857143e+01, 2.800000e+01, 2.685714e+01, 2.528571e+01, 2.528571e+01, 2.371429e+01, 2.257143e+01, 2.214286e+01, 2.014286e+01, 1.800000e+01, 1.657143e+01, 1.685714e+01, 1.685714e+01, 1.528571e+01, 1.514286e+01, 1.428571e+01, 1.428571e+01, 1.542857e+01, 1.471429e+01, 1.314286e+01, 1.257143e+01, 1.300000e+01, 1.300000e+01, 1.142857e+01, 9.857143e+00, 8.857143e+00, 9.142857e+00, 9.142857e+00, 7.857143e+00, 6.857143e+00, 7.571429e+00, 7.857143e+00, 8.142857e+00, 7.714286e+00, 7.714286e+00, 6.857143e+00, 7.428571e+00, 6.857143e+00, 6.000000e+00, 5.285714e+00, 6.142857e+00, 6.714286e+00, 7.142857e+00, 6.142857e+00, 6.857143e+00, 6.285714e+00, 6.571429e+00, 5.428571e+00, 5.142857e+00, 4.571429e+00, 5.000000e+00, 3.857143e+00, 4.142857e+00, 4.142857e+00, 4.285714e+00, 3.571429e+00, 3.857143e+00, 3.857143e+00, 4.285714e+00, 4.142857e+00, 3.714286e+00, 3.142857e+00, 3.142857e+00, 2.571429e+00, 2.285714e+00, 2.000000e+00, 1.571429e+00, 1.571429e+00, 1.857143e+00, 1.857143e+00, 2.571429e+00, 2.571429e+00, 2.285714e+00, 2.714286e+00, 2.714286e+00, 2.285714e+00, 2.142857e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.000000e+00, 1.000000e+00, 1.000000e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 8.571429e-01, 1.000000e+00, 7.142857e-01, 8.571429e-01, 1.285714e+00, 1.428571e+00, 1.428571e+00, 1.571429e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 8.571429e-01, 1.142857e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.000000e-01, 6.666667e-01, 0.000000e+00},
    { 1.000000e+01, 2.766667e+01, 4.220000e+01, 5.442857e+01, 6.814286e+01, 8.357143e+01, 9.628571e+01, 1.047143e+02, 1.132857e+02, 1.215714e+02, 1.260000e+02, 1.277143e+02, 1.270000e+02, 1.268571e+02, 1.274286e+02, 1.244286e+02, 1.221429e+02, 1.218571e+02, 1.245714e+02, 1.227143e+02, 1.190000e+02, 1.197143e+02, 1.190000e+02, 1.154286e+02, 1.108571e+02, 1.077143e+02, 1.038571e+02, 1.008571e+02, 9.385714e+01, 8.871429e+01, 8.800000e+01, 8.814286e+01, 8.057143e+01, 7.985714e+01, 7.485714e+01, 7.557143e+01, 7.471429e+01, 7.057143e+01, 6.585714e+01, 6.542857e+01, 6.171429e+01, 6.357143e+01, 6.057143e+01, 5.742857e+01, 5.414286e+01, 5.314286e+01, 5.042857e+01, 4.900000e+01, 4.557143e+01, 4.400000e+01, 4.257143e+01, 4.314286e+01, 3.871429e+01, 3.871429e+01, 3.600000e+01, 3.371429e+01, 3.171429e+01, 3.028571e+01, 2.714286e+01, 2.828571e+01, 2.585714e+01, 2.485714e+01, 2.357143e+01, 2.242857e+01, 2.271429e+01, 2.300000e+01, 2.142857e+01, 2.057143e+01, 1.985714e+01, 2.014286e+01, 1.900000e+01, 1.685714e+01, 1.571429e+01, 1.471429e+01, 1.400000e+01, 1.357143e+01, 1.185714e+01, 1.142857e+01, 1.200000e+01, 1.200000e+01, 1.257143e+01, 1.271429e+01, 1.257143e+01, 1.285714e+01, 1.228571e+01, 1.128571e+01, 1.042857e+01, 9.000000e+00, 8.428571e+00, 7.857143e+00, 8.142857e+00, 8.142857e+00, 8.428571e+00, 8.714286e+00, 9.714286e+00, 9.714286e+00, 9.428571e+00, 8.428571e+00, 7.285714e+00, 7.285714e+00, 6.571429e+00, 5.571429e+00, 4.571429e+00, 4.142857e+00, 3.714286e+00, 4.285714e+00, 3.428571e+00, 3.857143e+00, 3.714286e+00, 4.142857e+00, 3.714286e+00, 3.857143e+00, 3.714286e+00, 3.571429e+00, 2.714286e+00, 2.714286e+00, 2.285714e+00, 2.571429e+00, 2.857143e+00, 2.285714e+00, 2.428571e+00, 2.714286e+00, 2.428571e+00, 2.428571e+00, 2.571429e+00, 2.142857e+00, 2.714286e+00, 2.571429e+00, 2.571429e+00, 2.571429e+00, 2.428571e+00, 2.142857e+00, 2.285714e+00, 1.857143e+00, 1.571429e+00, 1.857143e+00, 1.857143e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 2.571429e+00, 2.000000e+00, 1.857143e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.428571e+00, 7.142857e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.200000e+01, 2.766667e+01, 4.600000e+01, 6.271429e+01, 7.485714e+01, 8.600000e+01, 9.342857e+01, 1.041429e+02, 1.084286e+02, 1.125714e+02, 1.112857e+02, 1.145714e+02, 1.170000e+02, 1.197143e+02, 1.167143e+02, 1.191429e+02, 1.197143e+02, 1.211429e+02, 1.192857e+02, 1.177143e+02, 1.132857e+02, 1.110000e+02, 1.080000e+02, 1.052857e+02, 1.034286e+02, 1.035714e+02, 1.018571e+02, 9.714286e+01, 9.228571e+01, 8.828571e+01, 8.600000e+01, 7.971429e+01, 7.314286e+01, 7.214286e+01, 7.242857e+01, 7.200000e+01, 6.928571e+01, 6.485714e+01, 6.314286e+01, 6.314286e+01, 5.942857e+01, 5.657143e+01, 5.342857e+01, 5.185714e+01, 5.114286e+01, 4.942857e+01, 4.757143e+01, 4.757143e+01, 4.614286e+01, 4.514286e+01, 4.328571e+01, 4.071429e+01, 3.942857e+01, 3.657143e+01, 3.228571e+01, 3.057143e+01, 2.928571e+01, 2.728571e+01, 2.657143e+01, 2.414286e+01, 2.285714e+01, 2.457143e+01, 2.385714e+01, 2.200000e+01, 2.085714e+01, 1.942857e+01, 1.942857e+01, 1.957143e+01, 1.585714e+01, 1.528571e+01, 1.614286e+01, 1.585714e+01, 1.557143e+01, 1.471429e+01, 1.300000e+01, 1.442857e+01, 1.428571e+01, 1.242857e+01, 1.185714e+01, 1.171429e+01, 1.142857e+01, 1.171429e+01, 9.285714e+00, 8.714286e+00, 9.000000e+00, 9.000000e+00, 8.428571e+00, 8.142857e+00, 7.285714e+00, 7.571429e+00, 7.000000e+00, 6.000000e+00, 5.142857e+00, 5.000000e+00, 4.714286e+00, 4.857143e+00, 4.571429e+00, 4.285714e+00, 4.142857e+00, 4.428571e+00, 4.000000e+00, 3.285714e+00, 3.142857e+00, 3.857143e+00, 3.714286e+00, 3.571429e+00, 3.285714e+00, 3.285714e+00, 3.428571e+00, 3.428571e+00, 2.857143e+00, 3.285714e+00, 3.571429e+00, 4.428571e+00, 4.285714e+00, 4.285714e+00, 4.142857e+00, 3.571429e+00, 3.142857e+00, 2.857143e+00, 1.857143e+00, 2.000000e+00, 1.714286e+00, 1.571429e+00, 1.857143e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 1.857143e+00, 2.285714e+00, 2.000000e+00, 1.714286e+00, 1.714286e+00, 1.714286e+00, 1.857143e+00, 1.857143e+00, 1.571429e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 8.571429e-01, 8.571429e-01, 1.000000e+00, 1.142857e+00, 1.000000e+00, 1.142857e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.000000e-01, 0.000000e+00, 0.000000e+00},
    { 1.000000e+01, 3.000000e+01, 4.560000e+01, 5.685714e+01, 6.957143e+01, 8.100000e+01, 8.942857e+01, 9.814286e+01, 1.028571e+02, 1.090000e+02, 1.108571e+02, 1.165714e+02, 1.162857e+02, 1.155714e+02, 1.117143e+02, 1.132857e+02, 1.125714e+02, 1.094286e+02, 1.058571e+02, 1.055714e+02, 1.027143e+02, 1.004286e+02, 9.500000e+01, 9.128571e+01, 9.085714e+01, 8.700000e+01, 8.271429e+01, 8.271429e+01, 8.200000e+01, 7.942857e+01, 7.714286e+01, 7.371429e+01, 7.185714e+01, 7.114286e+01, 6.857143e+01, 6.642857e+01, 6.485714e+01, 6.428571e+01, 6.142857e+01, 5.885714e+01, 5.385714e+01, 5.000000e+01, 4.800000e+01, 4.728571e+01, 4.371429e+01, 4.314286e+01, 4.028571e+01, 3.885714e+01, 3.657143e+01, 3.314286e+01, 3.071429e+01, 2.957143e+01, 2.657143e+01, 2.442857e+01, 2.557143e+01, 2.685714e+01, 2.657143e+01, 2.585714e+01, 2.414286e+01, 2.300000e+01, 2.242857e+01, 2.228571e+01, 2.014286e+01, 2.014286e+01, 1.785714e+01, 1.771429e+01, 1.714286e+01, 1.585714e+01, 1.357143e+01, 1.271429e+01, 1.157143e+01, 1.157143e+01, 1.071429e+01, 1.085714e+01, 1.100000e+01, 1.014286e+01, 9.428571e+00, 8.714286e+00, 8.428571e+00, 8.285714e+00, 8.428571e+00, 8.142857e+00, 8.142857e+00, 8.142857e+00, 8.428571e+00, 8.428571e+00, 8.000000e+00, 6.714286e+00, 6.714286e+00, 6.428571e+00, 6.142857e+00, 5.571429e+00, 5.285714e+00, 5.428571e+00, 6.428571e+00, 6.000000e+00, 6.000000e+00, 6.000000e+00, 5.428571e+00, 5.428571e+00, 5.142857e+00, 4.285714e+00, 4.285714e+00, 4.142857e+00, 4.000000e+00, 4.428571e+00, 4.428571e+00, 4.571429e+00, 4.285714e+00, 4.285714e+00, 3.857143e+00, 3.714286e+00, 3.285714e+00, 2.714286e+00, 2.714286e+00, 2.857143e+00, 3.000000e+00, 3.285714e+00, 2.714286e+00, 2.714286e+00, 2.857143e+00, 2.714286e+00, 3.142857e+00, 2.428571e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 1.285714e+00, 7.142857e-01, 1.000000e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 1.428571e+00, 1.571429e+00, 1.571429e+00, 2.000000e+00, 1.857143e+00, 1.857143e+00, 2.000000e+00, 1.285714e+00, 1.285714e+00, 1.000000e+00, 5.714286e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.400000e+01, 2.733333e+01, 3.940000e+01, 5.271429e+01, 6.314286e+01, 7.114286e+01, 8.014286e+01, 8.728571e+01, 9.128571e+01, 9.242857e+01, 9.428571e+01, 9.685714e+01, 9.728571e+01, 9.900000e+01, 1.005714e+02, 9.800000e+01, 9.728571e+01, 9.742857e+01, 9.514286e+01, 9.671429e+01, 9.371429e+01, 9.185714e+01, 9.385714e+01, 9.142857e+01, 8.842857e+01, 8.628571e+01, 8.285714e+01, 7.928571e+01, 7.414286e+01, 7.114286e+01, 6.700000e+01, 6.414286e+01, 6.200000e+01, 5.985714e+01, 5.642857e+01, 5.457143e+01, 5.128571e+01, 5.128571e+01, 4.885714e+01, 4.500000e+01, 4.200000e+01, 3.971429e+01, 3.957143e+01, 3.700000e+01, 3.557143e+01, 3.414286e+01, 3.314286e+01, 3.171429e+01, 3.328571e+01, 3.057143e+01, 3.057143e+01, 2.814286e+01, 2.700000e+01, 2.600000e+01, 2.500000e+01, 2.300000e+01, 2.171429e+01, 2.014286e+01, 2.085714e+01, 2.000000e+01, 2.114286e+01, 2.071429e+01, 1.957143e+01, 1.885714e+01, 1.800000e+01, 1.671429e+01, 1.614286e+01, 1.342857e+01, 1.214286e+01, 1.171429e+01, 1.271429e+01, 1.257143e+01, 1.171429e+01, 1.242857e+01, 1.285714e+01, 1.285714e+01, 1.171429e+01, 1.000000e+01, 9.142857e+00, 8.857143e+00, 7.714286e+00, 7.142857e+00, 7.428571e+00, 7.571429e+00, 7.428571e+00, 8.000000e+00, 8.428571e+00, 7.857143e+00, 7.285714e+00, 6.571429e+00, 5.714286e+00, 5.714286e+00, 5.428571e+00, 4.285714e+00, 4.428571e+00, 4.571429e+00, 4.000000e+00, 3.714286e+00, 3.285714e+00, 2.428571e+00, 2.714286e+00, 2.428571e+00, 2.285714e+00, 2.428571e+00, 2.714286e+00, 2.714286e+00, 2.857143e+00, 2.857143e+00, 2.285714e+00, 2.714286e+00, 2.571429e+00, 2.714286e+00, 2.571429e+00, 2.714286e+00, 2.571429e+00, 2.571429e+00, 2.142857e+00, 2.000000e+00, 1.714286e+00, 1.714286e+00, 1.285714e+00, 1.285714e+00, 1.714286e+00, 2.000000e+00, 2.000000e+00, 2.285714e+00, 2.142857e+00, 2.428571e+00, 2.571429e+00, 2.428571e+00, 2.142857e+00, 2.142857e+00, 1.714286e+00, 1.857143e+00, 1.857143e+00, 1.571429e+00, 1.714286e+00, 1.428571e+00, 1.285714e+00, 1.428571e+00, 1.142857e+00, 7.142857e-01, 5.714286e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 5.714286e-01, 7.142857e-01, 1.000000e+00, 1.142857e+00, 1.142857e+00, 1.285714e+00, 1.285714e+00, 1.428571e+00, 1.571429e+00, 1.285714e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 7.142857e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.300000e+01, 2.133333e+01, 3.320000e+01, 4.700000e+01, 5.657143e+01, 6.557143e+01, 7.471429e+01, 8.100000e+01, 8.757143e+01, 8.871429e+01, 9.357143e+01, 9.557143e+01, 9.671429e+01, 9.385714e+01, 9.442857e+01, 9.471429e+01, 9.385714e+01, 8.942857e+01, 8.757143e+01, 8.600000e+01, 8.814286e+01, 8.557143e+01, 8.114286e+01, 7.700000e+01, 7.671429e+01, 7.414286e+01, 7.085714e+01, 6.700000e+01, 6.671429e+01, 6.342857e+01, 6.414286e+01, 6.085714e+01, 5.700000e+01, 5.385714e+01, 5.042857e+01, 4.657143e+01, 4.457143e+01, 4.085714e+01, 4.100000e+01, 4.100000e+01, 3.942857e+01, 3.900000e+01, 3.685714e+01, 3.571429e+01, 3.514286e+01, 3.185714e+01, 3.114286e+01, 3.071429e+01, 2.957143e+01, 2.928571e+01, 2.800000e+01, 2.600000e+01, 2.371429e+01, 2.328571e+01, 2.185714e+01, 2.114286e+01, 1.942857e+01, 1.828571e+01, 1.814286e+01, 1.900000e+01, 1.785714e+01, 1.871429e+01, 1.757143e+01, 1.771429e+01, 1.700000e+01, 1.542857e+01, 1.371429e+01, 1.285714e+01, 1.142857e+01, 1.042857e+01, 9.857143e+00, 9.714286e+00, 9.714286e+00, 9.428571e+00, 8.714286e+00, 8.571429e+00, 8.857143e+00, 7.857143e+00, 7.714286e+00, 8.000000e+00, 7.285714e+00, 6.571429e+00, 5.571429e+00, 5.571429e+00, 5.714286e+00, 4.714286e+00, 3.857143e+00, 4.000000e+00, 4.428571e+00, 4.714286e+00, 4.857143e+00, 4.714286e+00, 5.428571e+00, 5.428571e+00, 5.428571e+00, 4.714286e+00, 4.857143e+00, 4.000000e+00, 4.285714e+00, 4.142857e+00, 4.142857e+00, 3.857143e+00, 3.857143e+00, 3.571429e+00, 3.714286e+00, 2.857143e+00, 3.142857e+00, 2.571429e+00, 2.857143e+00, 2.714286e+00, 2.714286e+00, 2.428571e+00, 2.428571e+00, 2.000000e+00, 2.142857e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.000000e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 1.142857e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 1.857143e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 1.571429e+00, 1.571429e+00, 1.285714e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 7.142857e-01, 8.571429e-01, 5.714286e-01, 7.142857e-01, 8.571429e-01, 7.142857e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.000000e+00, 1.366667e+01, 2.920000e+01, 3.885714e+01, 4.928571e+01, 5.842857e+01, 6.814286e+01, 7.357143e+01, 7.785714e+01, 8.371429e+01, 8.500000e+01, 8.685714e+01, 8.771429e+01, 8.642857e+01, 8.357143e+01, 8.257143e+01, 7.942857e+01, 7.814286e+01, 7.485714e+01, 7.242857e+01, 7.057143e+01, 6.985714e+01, 7.114286e+01, 7.000000e+01, 6.942857e+01, 6.957143e+01, 6.728571e+01, 6.471429e+01, 6.342857e+01, 5.928571e+01, 5.800000e+01, 5.528571e+01, 5.242857e+01, 5.214286e+01, 5.057143e+01, 4.842857e+01, 4.728571e+01, 4.442857e+01, 4.157143e+01, 3.985714e+01, 3.685714e+01, 3.585714e+01, 3.371429e+01, 3.100000e+01, 2.871429e+01, 2.914286e+01, 2.771429e+01, 2.700000e+01, 2.500000e+01, 2.400000e+01, 2.228571e+01, 2.071429e+01, 1.914286e+01, 1.800000e+01, 1.828571e+01, 1.871429e+01, 1.857143e+01, 1.885714e+01, 1.942857e+01, 1.914286e+01, 1.828571e+01, 1.642857e+01, 1.485714e+01, 1.314286e+01, 1.285714e+01, 1.228571e+01, 1.157143e+01, 1.071429e+01, 1.100000e+01, 1.128571e+01, 1.142857e+01, 1.042857e+01, 9.857143e+00, 1.057143e+01, 1.142857e+01, 1.071429e+01, 1.057143e+01, 9.714286e+00, 9.714286e+00, 9.142857e+00, 7.142857e+00, 6.714286e+00, 6.000000e+00, 5.142857e+00, 5.000000e+00, 5.142857e+00, 5.285714e+00, 5.428571e+00, 5.000000e+00, 4.428571e+00, 4.428571e+00, 5.142857e+00, 4.428571e+00, 4.142857e+00, 4.714286e+00, 4.000000e+00, 4.285714e+00, 4.000000e+00, 3.285714e+00, 3.571429e+00, 3.571429e+00, 3.000000e+00, 3.000000e+00, 3.285714e+00, 3.285714e+00, 3.285714e+00, 2.857143e+00, 3.000000e+00, 2.857143e+00, 2.428571e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 1.428571e+00, 1.285714e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.714286e+00, 1.857143e+00, 2.000000e+00, 2.000000e+00, 2.142857e+00, 2.428571e+00, 2.428571e+00, 2.000000e+00, 2.000000e+00, 1.714286e+00, 1.714286e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 7.000000e+00, 2.066667e+01, 3.300000e+01, 3.942857e+01, 4.800000e+01, 5.371429e+01, 6.142857e+01, 6.457143e+01, 6.728571e+01, 7.000000e+01, 7.442857e+01, 7.314286e+01, 7.228571e+01, 7.342857e+01, 7.385714e+01, 7.357143e+01, 7.400000e+01, 7.071429e+01, 7.285714e+01, 7.314286e+01, 6.971429e+01, 6.800000e+01, 6.600000e+01, 6.471429e+01, 6.471429e+01, 6.200000e+01, 5.885714e+01, 5.814286e+01, 5.700000e+01, 5.528571e+01, 5.342857e+01, 4.985714e+01, 4.771429e+01, 4.628571e+01, 4.428571e+01, 4.271429e+01, 4.100000e+01, 3.742857e+01, 3.657143e+01, 3.685714e+01, 3.557143e+01, 3.542857e+01, 3.371429e+01, 3.185714e+01, 3.071429e+01, 3.014286e+01, 2.742857e+01, 2.628571e+01, 2.271429e+01, 2.142857e+01, 2.057143e+01, 2.014286e+01, 1.857143e+01, 1.785714e+01, 1.657143e+01, 1.700000e+01, 1.600000e+01, 1.514286e+01, 1.371429e+01, 1.314286e+01, 1.257143e+01, 1.285714e+01, 1.242857e+01, 1.257143e+01, 1.242857e+01, 1.171429e+01, 1.214286e+01, 1.185714e+01, 1.128571e+01, 9.714286e+00, 9.285714e+00, 9.714286e+00, 9.857143e+00, 8.857143e+00, 8.000000e+00, 9.142857e+00, 9.142857e+00, 8.428571e+00, 8.142857e+00, 8.000000e+00, 7.428571e+00, 7.571429e+00, 5.428571e+00, 5.571429e+00, 5.714286e+00, 4.571429e+00, 4.285714e+00, 4.142857e+00, 4.000000e+00, 5.142857e+00, 5.142857e+00, 5.142857e+00, 5.428571e+00, 5.000000e+00, 5.571429e+00, 6.142857e+00, 5.714286e+00, 5.142857e+00, 4.571429e+00, 4.571429e+00, 4.428571e+00, 4.142857e+00, 3.571429e+00, 3.428571e+00, 3.571429e+00, 3.571429e+00, 3.142857e+00, 3.285714e+00, 3.000000e+00, 2.571429e+00, 2.000000e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.714286e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.000000e+00, 1.000000e+00, 8.571429e-01, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.000000e+00, 1.428571e+00, 1.571429e+00, 1.714286e+00, 1.285714e+00, 1.571429e+00, 1.571429e+00, 1.714286e+00, 1.285714e+00, 1.000000e+00, 7.142857e-01, 8.571429e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 6.000000e+00, 1.633333e+01, 2.760000e+01, 3.485714e+01, 4.600000e+01, 5.242857e+01, 5.900000e+01, 6.071429e+01, 6.557143e+01, 6.857143e+01, 6.957143e+01, 6.700000e+01, 6.957143e+01, 6.900000e+01, 7.057143e+01, 6.842857e+01, 6.942857e+01, 6.957143e+01, 7.057143e+01, 6.828571e+01, 6.628571e+01, 6.457143e+01, 6.428571e+01, 6.214286e+01, 5.785714e+01, 5.500000e+01, 5.414286e+01, 5.285714e+01, 5.085714e+01, 4.628571e+01, 4.357143e+01, 4.200000e+01, 3.914286e+01, 3.542857e+01, 3.371429e+01, 3.342857e+01, 3.357143e+01, 3.400000e+01, 3.442857e+01, 3.285714e+01, 3.100000e+01, 2.928571e+01, 2.585714e+01, 2.471429e+01, 2.185714e+01, 2.000000e+01, 2.057143e+01, 1.957143e+01, 2.014286e+01, 2.142857e+01, 2.071429e+01, 2.000000e+01, 1.985714e+01, 1.814286e+01, 1.857143e+01, 1.828571e+01, 1.728571e+01, 1.671429e+01, 1.657143e+01, 1.557143e+01, 1.657143e+01, 1.542857e+01, 1.414286e+01, 1.314286e+01, 1.257143e+01, 1.200000e+01, 1.128571e+01, 9.571429e+00, 9.000000e+00, 8.571429e+00, 7.857143e+00, 7.000000e+00, 6.571429e+00, 6.571429e+00, 5.714286e+00, 5.857143e+00, 5.428571e+00, 5.714286e+00, 6.000000e+00, 5.714286e+00, 5.142857e+00, 5.142857e+00, 4.857143e+00, 5.285714e+00, 4.857143e+00, 4.571429e+00, 4.714286e+00, 5.285714e+00, 5.285714e+00, 5.142857e+00, 4.285714e+00, 3.714286e+00, 3.428571e+00, 2.857143e+00, 2.142857e+00, 1.857143e+00, 1.857143e+00, 2.285714e+00, 3.000000e+00, 3.428571e+00, 3.857143e+00, 3.857143e+00, 4.000000e+00, 3.428571e+00, 3.000000e+00, 2.714286e+00, 2.428571e+00, 2.000000e+00, 1.571429e+00, 1.428571e+00, 1.571429e+00, 1.428571e+00, 1.142857e+00, 7.142857e-01, 7.142857e-01, 1.000000e+00, 8.571429e-01, 7.142857e-01, 8.571429e-01, 7.142857e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 1.285714e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.285714e+00, 1.285714e+00, 1.285714e+00, 7.142857e-01, 5.714286e-01, 5.714286e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 1.000000e+00, 8.571429e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.000000e+00, 1.300000e+01, 2.060000e+01, 2.885714e+01, 3.828571e+01, 4.514286e+01, 5.157143e+01, 5.457143e+01, 5.871429e+01, 6.271429e+01, 6.457143e+01, 6.328571e+01, 6.571429e+01, 6.628571e+01, 6.657143e+01, 6.571429e+01, 6.242857e+01, 6.300000e+01, 6.257143e+01, 5.900000e+01, 5.585714e+01, 5.400000e+01, 5.328571e+01, 5.271429e+01, 5.014286e+01, 4.814286e+01, 4.700000e+01, 4.685714e+01, 4.714286e+01, 4.414286e+01, 4.142857e+01, 4.114286e+01, 3.928571e+01, 3.857143e+01, 3.585714e+01, 3.371429e+01, 3.471429e+01, 3.200000e+01, 2.871429e+01, 2.785714e+01, 2.571429e+01, 2.371429e+01, 2.328571e+01, 2.171429e+01, 2.200000e+01, 2.114286e+01, 1.957143e+01, 1.800000e+01, 1.957143e+01, 1.871429e+01, 1.642857e+01, 1.500000e+01, 1.485714e+01, 1.400000e+01, 1.314286e+01, 1.142857e+01, 1.157143e+01, 1.228571e+01, 1.242857e+01, 1.214286e+01, 1.271429e+01, 1.200000e+01, 1.128571e+01, 1.000000e+01, 9.142857e+00, 9.142857e+00, 8.285714e+00, 7.714286e+00, 8.714286e+00, 8.285714e+00, 7.857143e+00, 7.285714e+00, 6.714286e+00, 7.142857e+00, 6.714286e+00, 6.000000e+00, 5.857143e+00, 5.428571e+00, 5.000000e+00, 4.714286e+00, 4.142857e+00, 4.142857e+00, 3.857143e+00, 4.428571e+00, 4.000000e+00, 4.142857e+00, 4.000000e+00, 3.571429e+00, 3.000000e+00, 2.714286e+00, 2.000000e+00, 2.285714e+00, 2.142857e+00, 2.000000e+00, 2.857143e+00, 2.857143e+00, 3.000000e+00, 3.285714e+00, 3.142857e+00, 3.142857e+00, 3.714286e+00, 2.714286e+00, 2.714286e+00, 2.428571e+00, 2.000000e+00, 2.000000e+00, 1.714286e+00, 1.571429e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 1.714286e+00, 1.857143e+00, 1.428571e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 1.000000e+00, 1.285714e+00, 1.285714e+00, 1.428571e+00, 1.714286e+00, 1.857143e+00, 2.000000e+00, 1.571429e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 8.571429e-01, 8.571429e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 1.000000e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 8.000000e+00, 1.533333e+01, 2.100000e+01, 2.871429e+01, 3.500000e+01, 4.171429e+01, 4.685714e+01, 5.328571e+01, 6.071429e+01, 6.357143e+01, 6.371429e+01, 6.500000e+01, 6.457143e+01, 6.314286e+01, 6.042857e+01, 5.585714e+01, 5.585714e+01, 5.685714e+01, 5.485714e+01, 5.500000e+01, 5.300000e+01, 5.157143e+01, 5.214286e+01, 4.871429e+01, 4.514286e+01, 4.485714e+01, 4.285714e+01, 4.257143e+01, 4.128571e+01, 3.814286e+01, 3.842857e+01, 3.757143e+01, 3.671429e+01, 3.371429e+01, 3.242857e+01, 3.100000e+01, 3.071429e+01, 2.814286e+01, 2.671429e+01, 2.357143e+01, 2.342857e+01, 2.328571e+01, 2.200000e+01, 2.042857e+01, 1.914286e+01, 1.828571e+01, 1.885714e+01, 1.771429e+01, 1.600000e+01, 1.571429e+01, 1.500000e+01, 1.600000e+01, 1.485714e+01, 1.257143e+01, 1.228571e+01, 1.157143e+01, 1.042857e+01, 1.000000e+01, 8.428571e+00, 9.285714e+00, 9.714286e+00, 8.857143e+00, 8.714286e+00, 8.857143e+00, 8.571429e+00, 8.714286e+00, 7.428571e+00, 7.142857e+00, 7.857143e+00, 7.428571e+00, 6.571429e+00, 6.142857e+00, 5.142857e+00, 5.000000e+00, 4.714286e+00, 3.857143e+00, 3.857143e+00, 3.714286e+00, 3.142857e+00, 3.142857e+00, 3.000000e+00, 3.142857e+00, 2.857143e+00, 3.142857e+00, 3.285714e+00, 3.857143e+00, 3.857143e+00, 4.142857e+00, 3.428571e+00, 3.142857e+00, 2.714286e+00, 2.428571e+00, 1.857143e+00, 1.857143e+00, 1.714286e+00, 1.857143e+00, 1.714286e+00, 1.571429e+00, 1.714286e+00, 1.857143e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 1.428571e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 4.285714e-01, 5.714286e-01, 1.000000e+00, 8.571429e-01, 1.000000e+00, 8.571429e-01, 1.000000e+00, 1.142857e+00, 1.285714e+00, 7.142857e-01, 8.571429e-01, 8.571429e-01, 1.000000e+00, 8.571429e-01, 8.571429e-01, 5.714286e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 1.142857e+00, 1.000000e+00, 1.000000e+00, 1.000000e+00, 1.285714e+00, 1.571429e+00, 1.428571e+00, 1.000000e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 4.285714e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.000000e+00, 1.466667e+01, 2.240000e+01, 2.757143e+01, 3.357143e+01, 3.942857e+01, 4.228571e+01, 4.442857e+01, 4.771429e+01, 5.071429e+01, 5.457143e+01, 5.628571e+01, 5.728571e+01, 5.928571e+01, 5.885714e+01, 5.785714e+01, 5.828571e+01, 5.414286e+01, 5.257143e+01, 5.071429e+01, 4.871429e+01, 4.785714e+01, 4.700000e+01, 4.414286e+01, 4.328571e+01, 4.314286e+01, 4.128571e+01, 3.857143e+01, 3.657143e+01, 3.628571e+01, 3.742857e+01, 3.542857e+01, 3.257143e+01, 3.171429e+01, 3.085714e+01, 3.028571e+01, 2.685714e+01, 2.342857e+01, 2.242857e+01, 2.142857e+01, 1.957143e+01, 1.942857e+01, 1.857143e+01, 1.857143e+01, 1.842857e+01, 1.742857e+01, 1.714286e+01, 1.671429e+01, 1.485714e+01, 1.471429e+01, 1.400000e+01, 1.300000e+01, 1.271429e+01, 1.171429e+01, 1.100000e+01, 1.128571e+01, 1.100000e+01, 1.000000e+01, 9.428571e+00, 8.285714e+00, 8.142857e+00, 9.000000e+00, 8.285714e+00, 6.857143e+00, 7.857143e+00, 7.142857e+00, 7.285714e+00, 7.142857e+00, 5.428571e+00, 5.857143e+00, 6.714286e+00, 6.142857e+00, 6.571429e+00, 6.285714e+00, 5.714286e+00, 6.000000e+00, 5.142857e+00, 4.285714e+00, 3.857143e+00, 3.714286e+00, 4.571429e+00, 4.142857e+00, 4.000000e+00, 4.142857e+00, 3.857143e+00, 3.428571e+00, 3.000000e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 2.571429e+00, 2.714286e+00, 2.857143e+00, 2.857143e+00, 3.000000e+00, 3.000000e+00, 3.285714e+00, 2.857143e+00, 2.571429e+00, 2.857143e+00, 2.571429e+00, 2.714286e+00, 2.571429e+00, 2.142857e+00, 1.857143e+00, 1.857143e+00, 2.000000e+00, 2.285714e+00, 2.428571e+00, 2.285714e+00, 2.285714e+00, 2.428571e+00, 2.714286e+00, 2.285714e+00, 2.000000e+00, 1.428571e+00, 1.428571e+00, 1.428571e+00, 1.000000e+00, 5.714286e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 8.571429e-01, 1.000000e+00, 8.571429e-01, 5.714286e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 4.285714e-01, 7.142857e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.000000e+00, 1.000000e+01, 2.120000e+01, 2.771429e+01, 3.271429e+01, 3.828571e+01, 4.200000e+01, 4.457143e+01, 4.557143e+01, 4.371429e+01, 4.314286e+01, 4.485714e+01, 4.457143e+01, 4.771429e+01, 4.642857e+01, 4.642857e+01, 4.657143e+01, 4.828571e+01, 4.757143e+01, 4.657143e+01, 4.285714e+01, 4.014286e+01, 3.857143e+01, 3.971429e+01, 3.700000e+01, 3.385714e+01, 3.328571e+01, 3.271429e+01, 3.371429e+01, 3.271429e+01, 3.085714e+01, 2.914286e+01, 2.885714e+01, 2.685714e+01, 2.514286e+01, 2.442857e+01, 2.242857e+01, 2.171429e+01, 2.128571e+01, 2.085714e+01, 1.971429e+01, 1.800000e+01, 1.628571e+01, 1.542857e+01, 1.457143e+01, 1.428571e+01, 1.342857e+01, 1.342857e+01, 1.414286e+01, 1.400000e+01, 1.285714e+01, 1.200000e+01, 1.085714e+01, 1.028571e+01, 9.714286e+00, 8.428571e+00, 7.428571e+00, 7.571429e+00, 6.571429e+00, 6.857143e+00, 6.571429e+00, 6.571429e+00, 5.714286e+00, 5.285714e+00, 5.000000e+00, 5.000000e+00, 4.142857e+00, 3.857143e+00, 3.857143e+00, 4.142857e+00, 4.285714e+00, 4.000000e+00, 3.714286e+00, 4.000000e+00, 4.142857e+00, 3.428571e+00, 3.428571e+00, 3.714286e+00, 4.285714e+00, 4.428571e+00, 4.571429e+00, 4.000000e+00, 4.000000e+00, 3.285714e+00, 2.714286e+00, 2.428571e+00, 2.428571e+00, 1.714286e+00, 1.571429e+00, 1.285714e+00, 1.285714e+00, 1.714286e+00, 1.428571e+00, 1.000000e+00, 8.571429e-01, 1.428571e+00, 1.428571e+00, 1.428571e+00, 8.571429e-01, 8.571429e-01, 1.000000e+00, 1.142857e+00, 8.571429e-01, 1.142857e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 1.000000e+00, 8.571429e-01, 1.000000e+00, 8.571429e-01, 8.571429e-01, 1.000000e+00, 1.000000e+00, 1.000000e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 1.000000e+00, 5.714286e-01, 4.285714e-01, 4.285714e-01, 1.000000e+00, 1.000000e+00, 8.571429e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.000000e+00, 1.366667e+01, 2.100000e+01, 2.714286e+01, 3.228571e+01, 3.671429e+01, 3.971429e+01, 4.171429e+01, 4.442857e+01, 4.714286e+01, 4.471429e+01, 4.457143e+01, 4.342857e+01, 4.314286e+01, 4.442857e+01, 4.314286e+01, 4.114286e+01, 3.971429e+01, 4.057143e+01, 4.014286e+01, 4.000000e+01, 3.714286e+01, 3.685714e+01, 3.742857e+01, 3.800000e+01, 3.657143e+01, 3.485714e+01, 3.371429e+01, 3.285714e+01, 3.028571e+01, 2.914286e+01, 2.714286e+01, 2.585714e+01, 2.357143e+01, 2.242857e+01, 2.100000e+01, 2.000000e+01, 1.814286e+01, 1.742857e+01, 1.600000e+01, 1.685714e+01, 1.514286e+01, 1.485714e+01, 1.457143e+01, 1.442857e+01, 1.442857e+01, 1.371429e+01, 1.328571e+01, 1.285714e+01, 1.142857e+01, 1.057143e+01, 9.428571e+00, 9.000000e+00, 8.571429e+00, 7.428571e+00, 7.142857e+00, 7.285714e+00, 6.714286e+00, 7.000000e+00, 5.857143e+00, 5.428571e+00, 5.428571e+00, 5.285714e+00, 5.000000e+00, 4.857143e+00, 3.857143e+00, 3.714286e+00, 3.285714e+00, 3.142857e+00, 2.714286e+00, 2.857143e+00, 2.714286e+00, 3.000000e+00, 2.714286e+00, 2.571429e+00, 2.428571e+00, 2.428571e+00, 1.857143e+00, 2.285714e+00, 2.571429e+00, 2.857143e+00, 3.000000e+00, 3.142857e+00, 3.285714e+00, 3.428571e+00, 2.857143e+00, 2.142857e+00, 2.142857e+00, 2.142857e+00, 1.857143e+00, 1.714286e+00, 1.285714e+00, 1.285714e+00, 1.428571e+00, 1.428571e+00, 1.142857e+00, 1.428571e+00, 1.571429e+00, 1.857143e+00, 1.714286e+00, 1.714286e+00, 1.571429e+00, 1.571429e+00, 1.142857e+00, 8.571429e-01, 5.714286e-01, 7.142857e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 7.142857e-01, 1.142857e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+00, 9.000000e+00, 1.580000e+01, 2.085714e+01, 2.657143e+01, 3.114286e+01, 3.514286e+01, 3.742857e+01, 4.028571e+01, 4.342857e+01, 4.414286e+01, 4.300000e+01, 4.300000e+01, 4.142857e+01, 4.000000e+01, 3.842857e+01, 3.714286e+01, 3.685714e+01, 3.628571e+01, 3.542857e+01, 3.471429e+01, 3.585714e+01, 3.585714e+01, 3.285714e+01, 3.214286e+01, 3.071429e+01, 2.900000e+01, 2.842857e+01, 2.685714e+01, 2.500000e+01, 2.485714e+01, 2.214286e+01, 2.142857e+01, 2.157143e+01, 1.971429e+01, 1.828571e+01, 1.628571e+01, 1.471429e+01, 1.500000e+01, 1.428571e+01, 1.185714e+01, 1.114286e+01, 1.071429e+01, 1.057143e+01, 1.014286e+01, 1.028571e+01, 1.042857e+01, 1.242857e+01, 1.185714e+01, 1.042857e+01, 1.128571e+01, 1.114286e+01, 1.014286e+01, 9.285714e+00, 8.000000e+00, 8.142857e+00, 8.285714e+00, 7.714286e+00, 7.142857e+00, 6.714286e+00, 6.428571e+00, 5.428571e+00, 4.857143e+00, 4.142857e+00, 3.000000e+00, 2.714286e+00, 2.428571e+00, 3.000000e+00, 3.000000e+00, 3.142857e+00, 3.857143e+00, 4.000000e+00, 4.000000e+00, 3.857143e+00, 3.142857e+00, 3.000000e+00, 2.857143e+00, 2.571429e+00, 2.285714e+00, 2.285714e+00, 2.428571e+00, 2.714286e+00, 2.714286e+00, 3.142857e+00, 2.714286e+00, 2.571429e+00, 2.857143e+00, 3.000000e+00, 2.714286e+00, 2.571429e+00, 1.714286e+00, 1.714286e+00, 2.142857e+00, 1.428571e+00, 1.142857e+00, 1.285714e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 1.428571e+00, 1.428571e+00, 1.142857e+00, 1.142857e+00, 1.428571e+00, 1.571429e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 7.142857e-01, 8.571429e-01, 1.285714e+00, 1.285714e+00, 1.000000e+00, 1.000000e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.000000e+00, 1.066667e+01, 1.460000e+01, 1.857143e+01, 2.285714e+01, 2.700000e+01, 2.900000e+01, 3.214286e+01, 3.442857e+01, 3.714286e+01, 3.842857e+01, 3.885714e+01, 3.814286e+01, 3.971429e+01, 3.785714e+01, 3.857143e+01, 3.785714e+01, 3.585714e+01, 3.657143e+01, 3.485714e+01, 3.285714e+01, 3.185714e+01, 3.042857e+01, 2.814286e+01, 2.771429e+01, 2.500000e+01, 2.585714e+01, 2.457143e+01, 2.371429e+01, 2.214286e+01, 2.214286e+01, 2.114286e+01, 2.042857e+01, 1.828571e+01, 1.800000e+01, 1.685714e+01, 1.585714e+01, 1.471429e+01, 1.400000e+01, 1.271429e+01, 1.285714e+01, 1.214286e+01, 1.242857e+01, 1.171429e+01, 1.042857e+01, 1.014286e+01, 1.014286e+01, 9.142857e+00, 9.000000e+00, 8.000000e+00, 8.857143e+00, 9.428571e+00, 8.285714e+00, 8.000000e+00, 7.142857e+00, 6.714286e+00, 6.571429e+00, 5.571429e+00, 6.142857e+00, 6.285714e+00, 6.571429e+00, 6.285714e+00, 5.571429e+00, 5.571429e+00, 5.000000e+00, 3.428571e+00, 2.857143e+00, 2.571429e+00, 2.714286e+00, 2.714286e+00, 3.000000e+00, 3.142857e+00, 3.714286e+00, 3.714286e+00, 3.428571e+00, 2.857143e+00, 2.857143e+00, 2.571429e+00, 2.142857e+00, 1.714286e+00, 2.000000e+00, 1.714286e+00, 1.714286e+00, 1.857143e+00, 1.428571e+00, 1.428571e+00, 1.142857e+00, 1.000000e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 1.285714e+00, 1.428571e+00, 1.714286e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.000000e+00, 9.333333e+00, 1.360000e+01, 1.685714e+01, 2.114286e+01, 2.500000e+01, 2.842857e+01, 3.014286e+01, 3.142857e+01, 3.442857e+01, 3.485714e+01, 3.542857e+01, 3.600000e+01, 3.300000e+01, 3.171429e+01, 3.271429e+01, 3.157143e+01, 3.071429e+01, 3.014286e+01, 2.842857e+01, 2.900000e+01, 2.900000e+01, 2.771429e+01, 2.742857e+01, 2.757143e+01, 2.600000e+01, 2.514286e+01, 2.457143e+01, 2.414286e+01, 2.257143e+01, 2.100000e+01, 1.957143e+01, 1.785714e+01, 1.685714e+01, 1.642857e+01, 1.628571e+01, 1.514286e+01, 1.414286e+01, 1.271429e+01, 1.300000e+01, 1.271429e+01, 1.214286e+01, 1.071429e+01, 1.100000e+01, 1.042857e+01, 1.014286e+01, 1.057143e+01, 1.042857e+01, 9.428571e+00, 9.000000e+00, 8.571429e+00, 8.571429e+00, 8.714286e+00, 7.142857e+00, 5.857143e+00, 5.714286e+00, 6.000000e+00, 5.285714e+00, 4.714286e+00, 4.571429e+00, 4.285714e+00, 4.428571e+00, 4.285714e+00, 4.285714e+00, 4.428571e+00, 4.571429e+00, 4.000000e+00, 3.857143e+00, 3.285714e+00, 3.714286e+00, 3.714286e+00, 3.142857e+00, 2.571429e+00, 2.428571e+00, 2.714286e+00, 3.000000e+00, 2.714286e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.714286e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.428571e+00, 1.142857e+00, 1.285714e+00, 1.571429e+00, 1.857143e+00, 2.142857e+00, 1.857143e+00, 1.714286e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.142857e+00, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 1.000000e+00, 1.000000e+00, 1.000000e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+00, 6.333333e+00, 1.320000e+01, 1.714286e+01, 2.157143e+01, 2.471429e+01, 2.714286e+01, 2.728571e+01, 2.828571e+01, 2.985714e+01, 2.885714e+01, 3.014286e+01, 3.185714e+01, 3.128571e+01, 3.271429e+01, 3.285714e+01, 3.300000e+01, 3.171429e+01, 2.814286e+01, 2.585714e+01, 2.671429e+01, 2.428571e+01, 2.371429e+01, 2.314286e+01, 2.271429e+01, 2.314286e+01, 2.328571e+01, 2.142857e+01, 2.042857e+01, 1.942857e+01, 1.842857e+01, 1.785714e+01, 1.742857e+01, 1.542857e+01, 1.428571e+01, 1.371429e+01, 1.257143e+01, 1.171429e+01, 1.085714e+01, 9.714286e+00, 9.285714e+00, 9.714286e+00, 9.571429e+00, 8.714286e+00, 8.142857e+00, 7.571429e+00, 7.428571e+00, 7.285714e+00, 6.571429e+00, 6.142857e+00, 6.714286e+00, 7.000000e+00, 7.000000e+00, 6.428571e+00, 6.142857e+00, 6.000000e+00, 6.142857e+00, 5.142857e+00, 4.285714e+00, 3.714286e+00, 3.857143e+00, 3.571429e+00, 3.000000e+00, 2.857143e+00, 2.857143e+00, 2.857143e+00, 3.428571e+00, 2.857143e+00, 3.142857e+00, 3.142857e+00, 2.714286e+00, 2.571429e+00, 2.857143e+00, 2.714286e+00, 2.714286e+00, 2.285714e+00, 2.000000e+00, 2.142857e+00, 2.428571e+00, 1.857143e+00, 1.714286e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 2.142857e+00, 1.714286e+00, 1.571429e+00, 1.571429e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 5.000000e+00, 9.666667e+00, 1.360000e+01, 1.471429e+01, 1.771429e+01, 1.857143e+01, 2.085714e+01, 2.314286e+01, 2.285714e+01, 2.500000e+01, 2.628571e+01, 2.614286e+01, 2.642857e+01, 2.571429e+01, 2.485714e+01, 2.600000e+01, 2.471429e+01, 2.514286e+01, 2.400000e+01, 2.428571e+01, 2.400000e+01, 2.371429e+01, 2.200000e+01, 2.100000e+01, 1.871429e+01, 2.000000e+01, 1.814286e+01, 1.742857e+01, 1.642857e+01, 1.600000e+01, 1.585714e+01, 1.571429e+01, 1.357143e+01, 1.314286e+01, 1.285714e+01, 1.242857e+01, 1.185714e+01, 1.028571e+01, 9.285714e+00, 8.714286e+00, 9.428571e+00, 8.714286e+00, 9.000000e+00, 7.857143e+00, 8.142857e+00, 8.428571e+00, 8.571429e+00, 7.857143e+00, 7.714286e+00, 6.857143e+00, 6.857143e+00, 6.714286e+00, 5.571429e+00, 5.285714e+00, 4.571429e+00, 4.285714e+00, 3.857143e+00, 3.714286e+00, 3.714286e+00, 4.428571e+00, 4.142857e+00, 4.285714e+00, 4.142857e+00, 3.714286e+00, 3.714286e+00, 3.571429e+00, 3.142857e+00, 2.857143e+00, 2.285714e+00, 2.000000e+00, 1.714286e+00, 1.571429e+00, 1.142857e+00, 1.000000e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.428571e+00, 1.142857e+00, 7.142857e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 1.000000e+00, 1.571429e+00, 1.571429e+00, 1.714286e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.000000e+00, 5.714286e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 7.142857e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 5.333333e+00, 1.120000e+01, 1.300000e+01, 1.614286e+01, 1.957143e+01, 2.342857e+01, 2.471429e+01, 2.514286e+01, 2.671429e+01, 2.614286e+01, 2.528571e+01, 2.428571e+01, 2.285714e+01, 2.314286e+01, 2.300000e+01, 2.371429e+01, 2.457143e+01, 2.571429e+01, 2.557143e+01, 2.542857e+01, 2.428571e+01, 2.228571e+01, 1.971429e+01, 1.771429e+01, 1.671429e+01, 1.500000e+01, 1.414286e+01, 1.328571e+01, 1.285714e+01, 1.385714e+01, 1.414286e+01, 1.285714e+01, 1.257143e+01, 1.114286e+01, 1.100000e+01, 1.057143e+01, 9.142857e+00, 8.142857e+00, 8.428571e+00, 7.285714e+00, 7.000000e+00, 7.000000e+00, 7.142857e+00, 6.428571e+00, 6.142857e+00, 5.000000e+00, 5.000000e+00, 5.285714e+00, 4.285714e+00, 3.428571e+00, 3.285714e+00, 3.285714e+00, 3.571429e+00, 3.428571e+00, 3.000000e+00, 3.142857e+00, 3.142857e+00, 3.000000e+00, 3.428571e+00, 3.285714e+00, 3.714286e+00, 3.428571e+00, 3.000000e+00, 2.857143e+00, 3.285714e+00, 2.714286e+00, 3.000000e+00, 2.428571e+00, 2.285714e+00, 2.428571e+00, 2.285714e+00, 1.714286e+00, 1.571429e+00, 1.000000e+00, 1.285714e+00, 1.142857e+00, 1.000000e+00, 1.142857e+00, 1.285714e+00, 1.571429e+00, 1.714286e+00, 1.428571e+00, 1.571429e+00, 1.714286e+00, 1.714286e+00, 1.714286e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 8.571429e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 4.000000e+00, 6.333333e+00, 1.000000e+01, 1.371429e+01, 1.657143e+01, 1.828571e+01, 2.228571e+01, 2.371429e+01, 2.557143e+01, 2.571429e+01, 2.700000e+01, 2.685714e+01, 2.871429e+01, 2.600000e+01, 2.414286e+01, 2.314286e+01, 2.185714e+01, 2.028571e+01, 2.014286e+01, 1.814286e+01, 1.800000e+01, 1.828571e+01, 1.700000e+01, 1.600000e+01, 1.471429e+01, 1.342857e+01, 1.242857e+01, 1.085714e+01, 1.071429e+01, 9.142857e+00, 8.571429e+00, 8.714286e+00, 8.142857e+00, 8.142857e+00, 8.285714e+00, 8.285714e+00, 8.285714e+00, 8.428571e+00, 7.428571e+00, 7.285714e+00, 6.571429e+00, 6.285714e+00, 5.857143e+00, 5.428571e+00, 5.571429e+00, 5.285714e+00, 4.714286e+00, 4.571429e+00, 4.714286e+00, 4.285714e+00, 4.857143e+00, 4.142857e+00, 4.142857e+00, 3.857143e+00, 4.000000e+00, 3.857143e+00, 3.571429e+00, 3.285714e+00, 3.428571e+00, 3.285714e+00, 3.428571e+00, 2.857143e+00, 2.285714e+00, 2.285714e+00, 2.142857e+00, 1.714286e+00, 1.857143e+00, 1.571429e+00, 1.714286e+00, 1.571429e+00, 1.571429e+00, 1.285714e+00, 1.285714e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 1.142857e+00, 8.571429e-01, 1.142857e+00, 1.142857e+00, 8.571429e-01, 8.571429e-01, 8.571429e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.000000e+00, 5.333333e+00, 8.200000e+00, 1.157143e+01, 1.400000e+01, 1.742857e+01, 1.957143e+01, 2.100000e+01, 2.300000e+01, 2.285714e+01, 2.214286e+01, 2.285714e+01, 2.285714e+01, 2.314286e+01, 2.314286e+01, 2.228571e+01, 2.128571e+01, 2.142857e+01, 2.042857e+01, 1.728571e+01, 1.614286e+01, 1.500000e+01, 1.314286e+01, 1.314286e+01, 1.285714e+01, 1.200000e+01, 1.314286e+01, 1.171429e+01, 1.142857e+01, 1.185714e+01, 1.157143e+01, 1.114286e+01, 1.085714e+01, 1.042857e+01, 1.028571e+01, 9.857143e+00, 9.142857e+00, 8.571429e+00, 7.857143e+00, 7.428571e+00, 6.428571e+00, 5.857143e+00, 5.285714e+00, 5.285714e+00, 5.142857e+00, 5.571429e+00, 5.857143e+00, 5.571429e+00, 5.714286e+00, 6.000000e+00, 5.428571e+00, 4.857143e+00, 4.428571e+00, 3.428571e+00, 3.142857e+00, 2.857143e+00, 2.285714e+00, 2.285714e+00, 1.857143e+00, 2.000000e+00, 1.857143e+00, 1.857143e+00, 2.000000e+00, 1.571429e+00, 1.428571e+00, 1.857143e+00, 1.571429e+00, 1.714286e+00, 1.857143e+00, 1.428571e+00, 1.571429e+00, 1.857143e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 5.714286e-01, 8.571429e-01, 8.571429e-01, 1.142857e+00, 1.285714e+00, 1.285714e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 3.333333e+00, 5.800000e+00, 8.000000e+00, 1.114286e+01, 1.257143e+01, 1.542857e+01, 1.614286e+01, 1.728571e+01, 1.771429e+01, 1.814286e+01, 1.714286e+01, 1.685714e+01, 1.600000e+01, 1.585714e+01, 1.542857e+01, 1.471429e+01, 1.500000e+01, 1.485714e+01, 1.514286e+01, 1.357143e+01, 1.314286e+01, 1.271429e+01, 1.285714e+01, 1.285714e+01, 1.214286e+01, 1.128571e+01, 1.228571e+01, 1.214286e+01, 1.157143e+01, 1.142857e+01, 9.857143e+00, 9.285714e+00, 8.714286e+00, 7.000000e+00, 6.714286e+00, 6.571429e+00, 6.000000e+00, 6.285714e+00, 6.142857e+00, 5.571429e+00, 5.857143e+00, 5.000000e+00, 4.857143e+00, 3.714286e+00, 3.142857e+00, 3.285714e+00, 3.285714e+00, 3.142857e+00, 3.428571e+00, 3.428571e+00, 3.571429e+00, 3.428571e+00, 3.285714e+00, 3.428571e+00, 3.428571e+00, 2.857143e+00, 2.428571e+00, 2.428571e+00, 2.428571e+00, 1.857143e+00, 1.428571e+00, 1.428571e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.428571e+00, 1.714286e+00, 2.142857e+00, 1.714286e+00, 1.714286e+00, 2.000000e+00, 2.000000e+00, 1.571429e+00, 1.571429e+00, 1.142857e+00, 1.428571e+00, 1.142857e+00, 7.142857e-01, 8.571429e-01, 8.571429e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 7.142857e-01, 8.571429e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+00, 5.333333e+00, 1.000000e+01, 1.142857e+01, 1.314286e+01, 1.471429e+01, 1.528571e+01, 1.500000e+01, 1.471429e+01, 1.442857e+01, 1.428571e+01, 1.542857e+01, 1.514286e+01, 1.542857e+01, 1.585714e+01, 1.485714e+01, 1.457143e+01, 1.457143e+01, 1.371429e+01, 1.328571e+01, 1.328571e+01, 1.285714e+01, 1.314286e+01, 1.257143e+01, 1.142857e+01, 1.128571e+01, 1.100000e+01, 9.571429e+00, 9.000000e+00, 8.285714e+00, 8.000000e+00, 8.857143e+00, 8.285714e+00, 8.285714e+00, 8.000000e+00, 8.000000e+00, 7.000000e+00, 6.571429e+00, 5.428571e+00, 5.000000e+00, 4.857143e+00, 4.714286e+00, 4.142857e+00, 5.000000e+00, 4.714286e+00, 4.285714e+00, 3.428571e+00, 3.285714e+00, 2.857143e+00, 2.428571e+00, 1.714286e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.571429e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.428571e+00, 1.571429e+00, 1.571429e+00, 1.857143e+00, 1.142857e+00, 1.428571e+00, 1.714286e+00, 2.000000e+00, 2.000000e+00, 2.000000e+00, 1.571429e+00, 1.571429e+00, 1.285714e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+00, 4.000000e+00, 8.600000e+00, 9.571429e+00, 1.142857e+01, 1.285714e+01, 1.414286e+01, 1.457143e+01, 1.442857e+01, 1.442857e+01, 1.442857e+01, 1.442857e+01, 1.428571e+01, 1.414286e+01, 1.442857e+01, 1.400000e+01, 1.371429e+01, 1.328571e+01, 1.285714e+01, 1.271429e+01, 1.228571e+01, 1.057143e+01, 9.285714e+00, 9.142857e+00, 8.285714e+00, 7.428571e+00, 6.857143e+00, 6.142857e+00, 6.285714e+00, 7.428571e+00, 7.571429e+00, 7.285714e+00, 7.000000e+00, 6.285714e+00, 6.000000e+00, 5.571429e+00, 4.142857e+00, 3.000000e+00, 3.000000e+00, 2.857143e+00, 2.714286e+00, 2.285714e+00, 2.000000e+00, 2.857143e+00, 3.428571e+00, 4.000000e+00, 4.000000e+00, 3.714286e+00, 3.714286e+00, 3.857143e+00, 3.142857e+00, 2.285714e+00, 1.714286e+00, 1.571429e+00, 1.857143e+00, 2.000000e+00, 1.285714e+00, 1.142857e+00, 1.714286e+00, 1.714286e+00, 1.714286e+00, 1.428571e+00, 1.142857e+00, 1.285714e+00, 1.285714e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 8.571429e-01, 8.571429e-01, 1.000000e+00, 8.571429e-01, 8.571429e-01, 5.714286e-01, 8.571429e-01, 7.142857e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+00, 5.333333e+00, 7.600000e+00, 8.714286e+00, 1.071429e+01, 1.185714e+01, 1.414286e+01, 1.428571e+01, 1.485714e+01, 1.528571e+01, 1.585714e+01, 1.485714e+01, 1.514286e+01, 1.271429e+01, 1.342857e+01, 1.300000e+01, 1.242857e+01, 1.185714e+01, 1.157143e+01, 1.042857e+01, 1.057143e+01, 9.142857e+00, 8.285714e+00, 8.142857e+00, 7.571429e+00, 7.571429e+00, 7.571429e+00, 7.000000e+00, 6.857143e+00, 6.142857e+00, 5.571429e+00, 5.000000e+00, 5.428571e+00, 5.285714e+00, 5.285714e+00, 5.142857e+00, 5.285714e+00, 5.285714e+00, 5.000000e+00, 3.857143e+00, 3.571429e+00, 3.142857e+00, 2.857143e+00, 2.428571e+00, 2.285714e+00, 2.285714e+00, 2.285714e+00, 1.857143e+00, 1.571429e+00, 1.285714e+00, 1.714286e+00, 1.142857e+00, 8.571429e-01, 1.000000e+00, 1.000000e+00, 1.000000e+00, 1.571429e+00, 1.571429e+00, 1.714286e+00, 1.857143e+00, 1.571429e+00, 1.571429e+00, 1.428571e+00, 1.000000e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 7.142857e-01, 1.428571e-01, 2.857143e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 2.000000e+00, 3.666667e+00, 5.000000e+00, 8.000000e+00, 9.142857e+00, 1.042857e+01, 1.142857e+01, 1.200000e+01, 1.214286e+01, 1.128571e+01, 1.157143e+01, 1.157143e+01, 1.142857e+01, 1.114286e+01, 1.128571e+01, 1.114286e+01, 1.028571e+01, 9.571429e+00, 8.857143e+00, 8.142857e+00, 7.714286e+00, 7.857143e+00, 7.857143e+00, 7.428571e+00, 6.714286e+00, 7.000000e+00, 6.714286e+00, 6.428571e+00, 4.857143e+00, 5.000000e+00, 5.142857e+00, 5.142857e+00, 4.571429e+00, 4.285714e+00, 4.428571e+00, 4.571429e+00, 4.142857e+00, 4.000000e+00, 3.428571e+00, 3.857143e+00, 3.857143e+00, 3.000000e+00, 2.714286e+00, 2.285714e+00, 2.714286e+00, 3.000000e+00, 2.285714e+00, 2.142857e+00, 2.571429e+00, 2.714286e+00, 2.571429e+00, 2.000000e+00, 2.000000e+00, 1.857143e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.571429e+00, 1.285714e+00, 1.000000e+00, 1.000000e+00, 1.142857e+00, 8.571429e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 8.571429e-01, 1.000000e+00, 8.571429e-01, 8.571429e-01, 1.000000e+00, 8.571429e-01, 1.000000e+00, 7.142857e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 3.000000e+00, 3.000000e+00, 4.600000e+00, 5.285714e+00, 6.857143e+00, 8.142857e+00, 9.714286e+00, 1.057143e+01, 1.100000e+01, 1.071429e+01, 1.128571e+01, 1.085714e+01, 1.100000e+01, 1.100000e+01, 1.071429e+01, 1.014286e+01, 1.042857e+01, 1.042857e+01, 9.571429e+00, 8.571429e+00, 8.142857e+00, 7.142857e+00, 6.857143e+00, 5.857143e+00, 5.714286e+00, 5.714286e+00, 5.428571e+00, 4.857143e+00, 4.428571e+00, 4.571429e+00, 4.571429e+00, 3.714286e+00, 3.714286e+00, 3.428571e+00, 2.857143e+00, 3.142857e+00, 3.000000e+00, 2.857143e+00, 3.142857e+00, 2.714286e+00, 2.428571e+00, 2.714286e+00, 2.857143e+00, 2.428571e+00, 2.285714e+00, 2.428571e+00, 2.428571e+00, 2.285714e+00, 1.857143e+00, 1.571429e+00, 1.857143e+00, 1.857143e+00, 1.285714e+00, 1.142857e+00, 1.285714e+00, 1.285714e+00, 1.142857e+00, 8.571429e-01, 1.000000e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 1.285714e+00, 1.285714e+00, 1.285714e+00, 1.142857e+00, 7.142857e-01, 7.142857e-01, 7.142857e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+00, 3.000000e+00, 3.800000e+00, 5.000000e+00, 6.857143e+00, 7.714286e+00, 8.428571e+00, 9.714286e+00, 9.714286e+00, 1.000000e+01, 1.085714e+01, 9.714286e+00, 9.714286e+00, 9.571429e+00, 8.428571e+00, 9.142857e+00, 8.714286e+00, 7.285714e+00, 7.142857e+00, 6.285714e+00, 5.285714e+00, 4.857143e+00, 3.571429e+00, 2.857143e+00, 3.000000e+00, 2.428571e+00, 2.428571e+00, 2.428571e+00, 3.285714e+00, 3.857143e+00, 4.000000e+00, 4.000000e+00, 4.142857e+00, 4.285714e+00, 3.857143e+00, 3.285714e+00, 2.857143e+00, 2.714286e+00, 2.285714e+00, 2.142857e+00, 2.000000e+00, 2.142857e+00, 1.857143e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 8.571429e-01, 1.000000e+00, 1.142857e+00, 1.000000e+00, 7.142857e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 8.571429e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 1.666667e+00, 3.600000e+00, 5.000000e+00, 5.571429e+00, 6.857143e+00, 7.285714e+00, 7.285714e+00, 7.142857e+00, 7.000000e+00, 7.142857e+00, 7.428571e+00, 6.285714e+00, 6.428571e+00, 6.285714e+00, 6.428571e+00, 6.857143e+00, 6.571429e+00, 6.285714e+00, 6.571429e+00, 6.142857e+00, 6.000000e+00, 5.857143e+00, 5.000000e+00, 4.571429e+00, 4.571429e+00, 4.571429e+00, 4.142857e+00, 4.142857e+00, 3.285714e+00, 2.857143e+00, 2.428571e+00, 2.000000e+00, 1.428571e+00, 1.428571e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 8.571429e-01, 1.000000e+00, 1.000000e+00, 1.000000e+00, 1.285714e+00, 1.714286e+00, 1.714286e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.285714e+00, 7.142857e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 7.142857e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 1.333333e+00, 2.600000e+00, 3.857143e+00, 5.142857e+00, 5.142857e+00, 6.142857e+00, 6.428571e+00, 6.142857e+00, 5.714286e+00, 5.285714e+00, 5.285714e+00, 5.428571e+00, 5.571429e+00, 5.714286e+00, 6.000000e+00, 6.285714e+00, 6.285714e+00, 5.714286e+00, 6.142857e+00, 5.285714e+00, 4.714286e+00, 3.857143e+00, 3.714286e+00, 3.714286e+00, 3.285714e+00, 2.714286e+00, 2.428571e+00, 2.285714e+00, 2.857143e+00, 2.571429e+00, 2.428571e+00, 2.285714e+00, 2.285714e+00, 2.714286e+00, 2.714286e+00, 2.285714e+00, 2.142857e+00, 1.714286e+00, 1.714286e+00, 1.571429e+00, 1.000000e+00, 1.000000e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 1.000000e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 8.571429e-01, 7.142857e-01, 5.714286e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 3.000000e+00, 3.800000e+00, 4.285714e+00, 4.714286e+00, 4.571429e+00, 4.571429e+00, 4.428571e+00, 5.142857e+00, 5.000000e+00, 5.000000e+00, 5.142857e+00, 5.000000e+00, 4.714286e+00, 4.142857e+00, 3.714286e+00, 3.857143e+00, 3.714286e+00, 3.285714e+00, 3.571429e+00, 3.428571e+00, 3.714286e+00, 3.428571e+00, 2.714286e+00, 2.571429e+00, 3.000000e+00, 2.857143e+00, 2.857143e+00, 2.428571e+00, 2.142857e+00, 2.142857e+00, 1.571429e+00, 1.285714e+00, 1.000000e+00, 1.142857e+00, 1.428571e+00, 1.285714e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 1.428571e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 7.142857e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 7.142857e-01, 7.142857e-01, 1.000000e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 5.714286e-01, 5.714286e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 5.000000e-01, 2.000000e+00, 3.100000e+00, 4.142857e+00, 4.785714e+00, 5.000000e+00, 5.071429e+00, 4.857143e+00, 4.857143e+00, 4.214286e+00, 4.071429e+00, 3.785714e+00, 3.714286e+00, 3.428571e+00, 3.214286e+00, 3.214286e+00, 3.142857e+00, 3.142857e+00, 3.071429e+00, 3.071429e+00, 3.142857e+00, 3.071429e+00, 2.714286e+00, 2.357143e+00, 2.142857e+00, 2.071429e+00, 1.928571e+00, 1.857143e+00, 1.785714e+00, 1.785714e+00, 1.714286e+00, 1.428571e+00, 1.428571e+00, 1.357143e+00, 1.357143e+00, 1.428571e+00, 1.214286e+00, 1.357143e+00, 1.357143e+00, 1.142857e+00, 1.071429e+00, 8.571429e-01, 7.857143e-01, 7.142857e-01, 6.428571e-01, 5.714286e-01, 5.000000e-01, 6.428571e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 6.428571e-01, 3.571429e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 3.571429e-01, 3.571429e-01, 3.571429e-01, 3.571429e-01, 5.714286e-01, 5.714286e-01, 7.857143e-01, 7.857143e-01, 7.142857e-01, 7.142857e-01, 6.428571e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 7.142857e-02, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.142857e-01, 1.428571e-01, 7.142857e-02, 7.142857e-02, 7.142857e-02, 1.428571e-01, 1.428571e-01, 7.142857e-02, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 7.142857e-02, 7.142857e-02, 7.142857e-02, 0.000000e+00, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 1.428571e-01, 1.428571e-01, 1.428571e-01, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 7.142857e-02, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+00, 1.000000e+00, 2.400000e+00, 4.000000e+00, 4.857143e+00, 5.428571e+00, 5.571429e+00, 5.285714e+00, 4.571429e+00, 3.428571e+00, 3.142857e+00, 2.428571e+00, 2.428571e+00, 2.142857e+00, 2.285714e+00, 2.714286e+00, 2.428571e+00, 2.571429e+00, 2.857143e+00, 2.571429e+00, 2.857143e+00, 2.428571e+00, 2.000000e+00, 2.000000e+00, 1.714286e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 1.142857e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 1.571429e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.142857e+00, 1.285714e+00, 1.285714e+00, 1.000000e+00, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 4.285714e-01, 4.285714e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 1.333333e+00, 2.200000e+00, 2.714286e+00, 3.142857e+00, 3.285714e+00, 3.571429e+00, 3.857143e+00, 4.285714e+00, 3.857143e+00, 3.714286e+00, 3.571429e+00, 3.571429e+00, 3.571429e+00, 3.285714e+00, 2.428571e+00, 2.571429e+00, 2.571429e+00, 2.714286e+00, 2.714286e+00, 2.571429e+00, 2.285714e+00, 2.428571e+00, 2.428571e+00, 2.428571e+00, 2.000000e+00, 1.857143e+00, 1.428571e+00, 1.428571e+00, 1.428571e+00, 1.000000e+00, 1.285714e+00, 1.285714e+00, 1.142857e+00, 1.000000e+00, 1.000000e+00, 7.142857e-01, 7.142857e-01, 1.428571e-01, 2.857143e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 1.333333e+00, 2.600000e+00, 2.428571e+00, 2.571429e+00, 3.000000e+00, 3.142857e+00, 3.285714e+00, 3.142857e+00, 3.428571e+00, 3.285714e+00, 3.428571e+00, 3.142857e+00, 2.571429e+00, 2.142857e+00, 2.142857e+00, 2.285714e+00, 1.857143e+00, 2.000000e+00, 1.857143e+00, 2.285714e+00, 2.142857e+00, 1.857143e+00, 1.714286e+00, 1.714286e+00, 1.571429e+00, 1.428571e+00, 1.000000e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 8.571429e-01, 7.142857e-01, 8.571429e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 1.000000e+00, 1.800000e+00, 2.000000e+00, 2.285714e+00, 2.428571e+00, 2.571429e+00, 2.714286e+00, 2.428571e+00, 2.714286e+00, 2.714286e+00, 2.714286e+00, 2.714286e+00, 2.714286e+00, 2.857143e+00, 2.428571e+00, 2.142857e+00, 1.857143e+00, 1.714286e+00, 1.428571e+00, 1.571429e+00, 1.428571e+00, 1.428571e+00, 1.428571e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 8.571429e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 1.000000e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 8.571429e-01, 8.571429e-01, 7.142857e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 0.000000e+00, 4.000000e-01, 1.000000e+00, 1.000000e+00, 1.571429e+00, 1.571429e+00, 1.857143e+00, 2.285714e+00, 1.857143e+00, 1.857143e+00, 2.000000e+00, 1.571429e+00, 1.857143e+00, 1.571429e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.285714e+00, 1.428571e+00, 1.428571e+00, 1.571429e+00, 1.428571e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 7.142857e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 5.714286e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 0.000000e+00, 2.000000e-01, 5.714286e-01, 5.714286e-01, 1.142857e+00, 1.142857e+00, 1.571429e+00, 1.714286e+00, 1.714286e+00, 1.714286e+00, 1.714286e+00, 1.285714e+00, 1.428571e+00, 1.142857e+00, 1.000000e+00, 1.142857e+00, 1.142857e+00, 1.285714e+00, 1.142857e+00, 1.428571e+00, 1.285714e+00, 1.285714e+00, 8.571429e-01, 8.571429e-01, 1.000000e+00, 1.000000e+00, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 3.333333e-01, 4.000000e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 1.142857e+00, 1.142857e+00, 1.428571e+00, 1.285714e+00, 1.142857e+00, 1.142857e+00, 1.000000e+00, 5.714286e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 1.000000e+00, 1.000000e+00, 1.400000e+00, 1.714286e+00, 1.714286e+00, 1.857143e+00, 1.857143e+00, 1.714286e+00, 1.857143e+00, 1.571429e+00, 1.142857e+00, 1.000000e+00, 8.571429e-01, 7.142857e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 7.142857e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 0.000000e+00, 2.000000e-01, 1.428571e-01, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 8.571429e-01, 1.285714e+00, 1.428571e+00, 1.428571e+00, 1.428571e+00, 1.428571e+00, 1.285714e+00, 8.571429e-01, 5.714286e-01, 5.714286e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 0.000000e+00, 2.000000e-01, 4.285714e-01, 7.142857e-01, 8.571429e-01, 8.571429e-01, 8.571429e-01, 1.000000e+00, 8.571429e-01, 7.142857e-01, 5.714286e-01, 4.285714e-01, 5.714286e-01, 4.285714e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 2.857143e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 1.428571e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 2.857143e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00},
    { 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 5.714286e-01, 5.714286e-01, 2.857143e-01, 2.857143e-01, 4.285714e-01, 4.285714e-01, 4.285714e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 1.428571e-01, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00}
};

// Cumulative energy spectrum of positron calculated as per Thomas, R., Phys Rev 58, 714 (1940)
// 0-738 keV in 1 keV steps
const G4double GateSourceFastY90::mPositronEnergyTable[738] = { 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000001, 0.000001, 0.000002, 0.000003, 0.000005, 0.000008, 0.000011, 0.000016, 0.000022, 0.000029, 0.000038, 0.000049, 0.000062, 0.000076, 0.000093, 0.000113, 0.000135, 0.000160, 0.000188, 0.000219, 0.000254, 0.000292, 0.000333, 0.000378, 0.000427, 0.000480, 0.000537, 0.000599, 0.000664, 0.000734, 0.000809, 0.000888, 0.000972, 0.001061, 0.001155, 0.001254, 0.001358, 0.001467, 0.001582, 0.001702, 0.001827, 0.001958, 0.002094, 0.002236, 0.002384, 0.002537, 0.002696, 0.002862, 0.003033, 0.003210, 0.003393, 0.003582, 0.003777, 0.003978, 0.004186, 0.004400, 0.004620, 0.004846, 0.005079, 0.005318, 0.005563, 0.005815, 0.006073, 0.006338, 0.006609, 0.006887, 0.007171, 0.007462, 0.007759, 0.008063, 0.008374, 0.008692, 0.009015, 0.009346, 0.009683, 0.010028, 0.010378, 0.010736, 0.011100, 0.011471, 0.011849, 0.012233, 0.012624, 0.013022, 0.013427, 0.013839, 0.014257, 0.014682, 0.015114, 0.015553, 0.015999, 0.016451, 0.016911, 0.017377, 0.017850, 0.018329, 0.018816, 0.019309, 0.019809, 0.020316, 0.020830, 0.021351, 0.021878, 0.022413, 0.022954, 0.023501, 0.024056, 0.024618, 0.025186, 0.025761, 0.026343, 0.026931, 0.027526, 0.028129, 0.028737, 0.029353, 0.029975, 0.030604, 0.031240, 0.031883, 0.032532, 0.033188, 0.033851, 0.034520, 0.035196, 0.035878, 0.036568, 0.037264, 0.037966, 0.038676, 0.039391, 0.040114, 0.040843, 0.041578, 0.042321, 0.043069, 0.043825, 0.044587, 0.045355, 0.046130, 0.046911, 0.047699, 0.048494, 0.049294, 0.050102, 0.050916, 0.051736, 0.052562, 0.053395, 0.054235, 0.055080, 0.055933, 0.056791, 0.057656, 0.058527, 0.059405, 0.060288, 0.061178, 0.062075, 0.062977, 0.063886, 0.064801, 0.065722, 0.066650, 0.067583, 0.068523, 0.069469, 0.070421, 0.071379, 0.072343, 0.073314, 0.074290, 0.075273, 0.076261, 0.077256, 0.078256, 0.079263, 0.080275, 0.081294, 0.082318, 0.083348, 0.084385, 0.085427, 0.086475, 0.087529, 0.088588, 0.089654, 0.090725, 0.091803, 0.092885, 0.093974, 0.095069, 0.096169, 0.097275, 0.098386, 0.099503, 0.100626, 0.101755, 0.102889, 0.104029, 0.105174, 0.106325, 0.107482, 0.108644, 0.109811, 0.110984, 0.112163, 0.113347, 0.114536, 0.115731, 0.116931, 0.118137, 0.119348, 0.120564, 0.121786, 0.123013, 0.124245, 0.125483, 0.126725, 0.127973, 0.129227, 0.130485, 0.131749, 0.133018, 0.134292, 0.135571, 0.136855, 0.138144, 0.139439, 0.140738, 0.142043, 0.143352, 0.144667, 0.145986, 0.147311, 0.148640, 0.149974, 0.151314, 0.152658, 0.154007, 0.155360, 0.156719, 0.158082, 0.159451, 0.160824, 0.162201, 0.163584, 0.164971, 0.166363, 0.167759, 0.169160, 0.170566, 0.171976, 0.173391, 0.174811, 0.176235, 0.177663, 0.179097, 0.180534, 0.181976, 0.183423, 0.184874, 0.186329, 0.187789, 0.189253, 0.190721, 0.192194, 0.193671, 0.195152, 0.196638, 0.198128, 0.199622, 0.201120, 0.202623, 0.204130, 0.205640, 0.207155, 0.208674, 0.210197, 0.211725, 0.213256, 0.214791, 0.216330, 0.217874, 0.219421, 0.220972, 0.222527, 0.224086, 0.225649, 0.227215, 0.228786, 0.230360, 0.231939, 0.233520, 0.235106, 0.236696, 0.238289, 0.239885, 0.241486, 0.243090, 0.244698, 0.246309, 0.247924, 0.249543, 0.251165, 0.252791, 0.254420, 0.256052, 0.257688, 0.259328, 0.260971, 0.262617, 0.264267, 0.265920, 0.267576, 0.269236, 0.270899, 0.272565, 0.274235, 0.275908, 0.277584, 0.279263, 0.280945, 0.282631, 0.284319, 0.286011, 0.287706, 0.289404, 0.291105, 0.292809, 0.294516, 0.296226, 0.297939, 0.299654, 0.301373, 0.303095, 0.304819, 0.306547, 0.308277, 0.310010, 0.311746, 0.313484, 0.315226, 0.316970, 0.318717, 0.320466, 0.322218, 0.323973, 0.325730, 0.327490, 0.329253, 0.331018, 0.332785, 0.334555, 0.336328, 0.338103, 0.339881, 0.341661, 0.343443, 0.345228, 0.347015, 0.348804, 0.350596, 0.352390, 0.354187, 0.355985, 0.357786, 0.359589, 0.361395, 0.363202, 0.365012, 0.366823, 0.368637, 0.370453, 0.372271, 0.374091, 0.375913, 0.377737, 0.379563, 0.381391, 0.383221, 0.385053, 0.386887, 0.388722, 0.390560, 0.392399, 0.394240, 0.396083, 0.397928, 0.399774, 0.401622, 0.403472, 0.405324, 0.407177, 0.409032, 0.410888, 0.412746, 0.414606, 0.416467, 0.418330, 0.420194, 0.422060, 0.423927, 0.425795, 0.427666, 0.429537, 0.431410, 0.433284, 0.435160, 0.437036, 0.438915, 0.440794, 0.442675, 0.444557, 0.446440, 0.448324, 0.450210, 0.452096, 0.453984, 0.455873, 0.457763, 0.459654, 0.461546, 0.463439, 0.465334, 0.467229, 0.469125, 0.471022, 0.472920, 0.474819, 0.476718, 0.478619, 0.480520, 0.482422, 0.484326, 0.486229, 0.488134, 0.490039, 0.491945, 0.493852, 0.495759, 0.497667, 0.499576, 0.501485, 0.503395, 0.505305, 0.507216, 0.509128, 0.511039, 0.512952, 0.514865, 0.516778, 0.518692, 0.520606, 0.522520, 0.524435, 0.526351, 0.528266, 0.530182, 0.532098, 0.534014, 0.535931, 0.537848, 0.539765, 0.541682, 0.543599, 0.545517, 0.547434, 0.549352, 0.551269, 0.553187, 0.555105, 0.557023, 0.558940, 0.560858, 0.562776, 0.564693, 0.566611, 0.568528, 0.570446, 0.572363, 0.574280, 0.576196, 0.578113, 0.580029, 0.581945, 0.583861, 0.585776, 0.587692, 0.589606, 0.591521, 0.593435, 0.595349, 0.597262, 0.599175, 0.601087, 0.602999, 0.604910, 0.606821, 0.608732, 0.610641, 0.612551, 0.614459, 0.616367, 0.618274, 0.620181, 0.622087, 0.623993, 0.625897, 0.627801, 0.629704, 0.631607, 0.633508, 0.635409, 0.637309, 0.639208, 0.641106, 0.643004, 0.644900, 0.646796, 0.648690, 0.650584, 0.652476, 0.654368, 0.656259, 0.658148, 0.660037, 0.661924, 0.663810, 0.665696, 0.667580, 0.669463, 0.671344, 0.673225, 0.675104, 0.676982, 0.678859, 0.680735, 0.682609, 0.684482, 0.686354, 0.688224, 0.690093, 0.691961, 0.693827, 0.695692, 0.697555, 0.699417, 0.701277, 0.703136, 0.704994, 0.706850, 0.708704, 0.710557, 0.712408, 0.714258, 0.716106, 0.717952, 0.719797, 0.721640, 0.723481, 0.725321, 0.727159, 0.728995, 0.730829, 0.732662, 0.734493, 0.736322, 0.738149, 0.739975, 0.741798, 0.743620, 0.745440, 0.747258, 0.749074, 0.750888, 0.752700, 0.754510, 0.756318, 0.758124, 0.759928, 0.761730, 0.763530, 0.765327, 0.767123, 0.768917, 0.770708, 0.772497, 0.774285, 0.776069, 0.777852, 0.779633, 0.781411, 0.783187, 0.784961, 0.786733, 0.788502, 0.790269, 0.792033, 0.793796, 0.795556, 0.797313, 0.799068, 0.800821, 0.802572, 0.804319, 0.806065, 0.807808, 0.809548, 0.811287, 0.813022, 0.814755, 0.816486, 0.818213, 0.819939, 0.821662, 0.823382, 0.825099, 0.826814, 0.828527, 0.830236, 0.831943, 0.833648, 0.835349, 0.837048, 0.838745, 0.840438, 0.842129, 0.843817, 0.845502, 0.847185, 0.848864, 0.850541, 0.852215, 0.853886, 0.855555, 0.857220, 0.858883, 0.860542, 0.862199, 0.863853, 0.865504, 0.867152, 0.868797, 0.870439, 0.872079, 0.873715, 0.875348, 0.876978, 0.878606, 0.880230, 0.881851, 0.883469, 0.885085, 0.886697, 0.888306, 0.889912, 0.891515, 0.893114, 0.894711, 0.896305, 0.897895, 0.899483, 0.901067, 0.902648, 0.904226, 0.905801, 0.907372, 0.908941, 0.910506, 0.912068, 0.913627, 0.915183, 0.916736, 0.918285, 0.919831, 0.921374, 0.922914, 0.924451, 0.925984, 0.927514, 0.929041, 0.930565, 0.932086, 0.933603, 0.935117, 0.936628, 0.938136, 0.939640, 0.941142, 0.942640, 0.944134, 0.945626, 0.947114, 0.948600, 0.950082, 0.951561, 0.953036, 0.954509, 0.955978, 0.957444, 0.958907, 0.960367, 0.961824, 0.963277, 0.964728, 0.966175, 0.967619, 0.969061, 0.970499, 0.971934, 0.973366, 0.974795, 0.976220, 0.977643, 0.979063, 0.980480, 0.981894, 0.983305, 0.984712, 0.986117, 0.987519, 0.988918, 0.990314, 0.991707, 0.993097, 0.994483, 0.995867, 0.997248, 0.998625, 1.000000 };
