#define PHOTON_PHOTOELECTRIC 1
#define PHOTON_COMPTON 2
#define PHOTON_STEP_LIMITER 3
#define PHOTON_BOUNDARY_VOXEL 4
#define PHOTON_BOUNDARY_HOLE 5

#define ELECTRON_EIONISATION 1
#define ELECTRON_MSC 2
#define ELECTRON_STEP_LIMITER 3
#define ELECTRON_BOUNDARY_VOXEL 4
#define ELECTRON_SAFETY 5

#define OPTICALPHOTON_MIE 1
#define OPTICALPHOTON_BOUNDARY_VOXEL 2

#define OPTICALPHOTON 0
#define GAMMA 22
#define ELECTRON 11
#define POSITRON 11

#define EPS 1.0e-03f
#define INF 1.0e30f

// ************************************************************************
// * PE - Standard (Sandia table)
// ************************************************************************

__constant__ unsigned short int PhotoElec_std_NbIntervals [101] =
{

      0,  // nonexisting 'zero' element

//    H,                                                     He,         (2)
     10,                                                      7,

//   Li,    Be,     B,    C,     N,     O,     F,            Ne,        (10)
      7,     7,     7,    10,    8,     8,     7,             8,

//   Na,    Mg,    Al,    Si,    P,     S,    Cl,            Ar,        (18)
      7,     7,     8,     7,    7,     7,     7,             7,

//    K,    Ca,    Sc,    Ti,    V,    Cr,    Mn,     Fe,    Co,    Ni, (28)
      7,     7,     6,     6,    7,     6,     6,      7,     7,     8,

//   Cu,    Zn,    Ga,    Ge,    As,    Se,    Br,           Kr,        (36)
      7,     9,     9,     9,     9,     9,    10,           10,

//   Rb,    Sr,    Y,     Zr,    Nb,    Mo,    Tc,    Ru,    Rh,    Pd, (46)
     10,    10,    10,     9,    10,    10,    10,    10,    10,    10,

//   Ag,    Cd,    In,    Sn,    Sb,    Te,     J,           Xe,        (54)
     10,    11,    11,    11,    11,    11,    12,           13,

//   Cs,    Ba,    La,    Ce,    Pr,    Nd,    Pm,    Sm,    Eu,    Gd, (64)
     11,    11,    12,    13,    13,    12,    13,    11,    13,    12,

//   Tb,    Dy,    Ho,    Er,    Tm,    Yb,    Lu,    Hf,    Ta,     W, (74)
     12,    12,    12,    12,    10,    10,    10,    10,    11,    11,

//   Re,    Os,    Ir,    Pt,    Au,    Hg,    Tl,    Pb,    Bi,    Po, (84)
     10,    10,    10,    11,    10,    10,    11,    11,    13,    11,

//   At,   Rn,     Fr,    Ra,    Ac,    Th,    Pa,    U,     Np     Pu, (94)
     11,   11,     11,    11,    11,    10,    10,    11,    10,    11,

//   Am,    Cm,    Bk,    Cf,    Es,    Fm                             (100)
     11,    11,    11,    11,    12,    12

};

// Usefull to find E in the table. JB - 2011-02-16 10:28:09
__constant__ unsigned short int PhotoElec_std_CumulIntervals [101] =
{

      0,  // nonexisting 'zero' element

//    H,                                                     He,         (2)
     10,                                                     17,

//   Li,    Be,     B,    C,     N,     O,     F,            Ne,        (10)
     24,    31,    38,    48,   56,    64,    71,            79,

//   Na,    Mg,    Al,    Si,    P,     S,    Cl,            Ar,        (18)
     86,    93,   101,   108,  115,   122,   129,           136,

//    K,    Ca,    Sc,    Ti,    V,    Cr,    Mn,     Fe,    Co,    Ni, (28)
    143,   150,   156,   162,  169,   175,   181,    188,   195,   203,

//   Cu,    Zn,    Ga,    Ge,    As,    Se,    Br,           Kr,        (36)
    210,   219,   228,   237,   246,   255,   265,          275,

//   Rb,    Sr,    Y,     Zr,    Nb,    Mo,    Tc,    Ru,    Rh,    Pd, (46)
    285,   295,   305,   314,   324,   334,   344,   354,   364,   374,

//   Ag,    Cd,    In,    Sn,    Sb,    Te,     J,           Xe,        (54)
    384,   395,   406,   417,   428,   439,   451,          464,

//   Cs,    Ba,    La,    Ce,    Pr,    Nd,    Pm,    Sm,    Eu,    Gd, (64)
    475,   486,   498,   511,   524,   536,   549,   560,   573,   585,

//   Tb,    Dy,    Ho,    Er,    Tm,    Yb,    Lu,    Hf,    Ta,     W, (74)
    597,   609,   621,   633,   643,   653,   663,   673,   684,   695,

//   Re,    Os,    Ir,    Pt,    Au,    Hg,    Tl,    Pb,    Bi,    Po, (84)
    705,   715,   725,   736,   746,   756,   767,   778,   791,   802,

//   At,   Rn,     Fr,    Ra,    Ac,    Th,    Pa,    U,     Np     Pu, (94)
    813,   824,   835,   846,   857,   867,   877,   888,   898,   909,

//   Am,    Cm,    Bk,    Cf,    Es,    Fm                             (100)
    920,   931,   942,   953,   965,   977

};

// The ration of atomic number to atomic mass for first 100 elements
__constant__ float PhotoElec_std_ZtoAratio[101] =
{

      0,  // nonexisting 'zero' element

//    H,                                                             He,         (2)
 0.9921,                                                         0.4997,

//   Li,     Be,      B,      C,      N,      O,      F,             Ne,        (10)
 0.4322, 0.4438, 0.4625, 0.4995, 0.4998,    0.5, 0.4737,         0.4956,

//   Na,     Mg,     Al,     Si,      P,      S,     Cl,             Ar,        (18)
 0.4785, 0.4937, 0.4818, 0.4985, 0.4843, 0.4991, 0.4795,         0.4506,

//    K,     Ca,     Sc,     Ti,      V,     Cr,     Mn,     Fe,     Co,     Ni,(28)
 0.4860, 0.4990, 0.4671, 0.4595, 0.4515, 0.4616, 0.4551, 0.4656, 0.4581, 0.4771,

//   Cu,     Zn,     Ga,     Ge,     As,     Se,     Br,             Kr,        (36)
 0.4564, 0.4589, 0.4446, 0.4408, 0.4405, 0.4306, 0.4380,         0.4296,

//   Rb,     Sr,      Y,     Zr,     Nb,     Mo,     Tc,     Ru,     Rh,     Pd,(46)
 0.4329, 0.4337, 0.4387, 0.4385, 0.4413, 0.4378, 0.4388, 0.4353, 0.4373, 0.4322,

//   Ag,     Cd,     In,     Sn,     Sb,     Te,      J,             Xe,        (54)
 0.4357, 0.4270, 0.4268, 0.4213, 0.4189, 0.4075, 0.4176,         0.4113,

//   Cs,     Ba,     La,     Ce,     Pr,     Nd,     Pm,     Sm,     Eu,     Gd,(64)
 0.4138, 0.4078, 0.4104, 0.4139, 0.4187, 0.4160, 0.4207, 0.4123, 0.4146, 0.4070,

//   Tb,     Dy,     Ho,     Er,     Tm,     Yb,     Lu,     Hf,     Ta,      W,(74)
 0.4090, 0.4062, 0.4062, 0.4066, 0.4084, 0.4045, 0.4058, 0.4034, 0.4034, 0.4025,

// Re,       Os,     Ir,     Pt,     Au,     Hg,     Tl,     Pb,     Bi,     Po,(84)
 0.4028, 0.3996, 0.4006, 0.3998, 0.4011, 0.3988, 0.3963, 0.3958, 0.3972, 0.4019,

//   At,     Rn,     Fr,     Ra,     Ac,     Th,     Pa,      U,     Np,     Pu,(94)
 0.4048, 0.3874, 0.3901, 0.3893, 0.3920, 0.3879, 0.3939, 0.3865, 0.3923, 0.3852,

//   Am,     Cm,     Bk,     Cf,     Es,     Fm                                (100)
 0.3909, 0.3887, 0.3927, 0.3904, 0.3929, 0.3891

};

__constant__ float PhotoElec_std_IonizationPotentials[101] =
{
     0,  // nonexisting 'zero' element

//   H,                                                     He,         (2)
 13.60,                                                  24.59,

//  Li,    Be,     B,     C,     N,     O,     F,           Ne,        (10)
  5.39,  9.32,  8.30, 11.26, 14.53, 13.62, 17.42,        21.56,

//  Na,    Mg,    Al,    Si,     P,     S,    Cl,           Ar,        (18)
  5.14,  7.65,  5.99,  8.15, 10.49, 10.36, 12.97,        15.76,

//   K,    Ca,    Sc,    Ti,     V,    Cr,    Mn,    Fe,    Co,    Ni, (28)
  4.34,  6.11,  6.56,  6.83,  6.75,  6.77,  7.43,  7.90,  7.88,  7.64,

//  Cu,    Zn,    Ga,    Ge,    As,    Se,    Br,           Kr,        (36)
  7.73,  9.39,  6.00,  7.90,  9.82,  9.75, 11.81,        14.00,

//  Rb,    Sr,     Y,    Zr,    Nb,    Mo,    Tc,    Ru,    Rh,    Pd, (46)
  4.18,  5.69,  6.22,  6.63,  6.76,  7.09,  7.28,  7.36,  7.46,  8.34,

//  Ag,    Cd,    In,    Sn,    Sb,    Te,     J,           Xe,        (54)
  7.58,  8.99,  5.79,  7.34,  8.64,  9.01, 10.45,        12.13,

//  Cs,    Ba,    La,    Ce,    Pr,    Nd,    Pm,    Sm,    Eu,    Gd, (64)
  3.89,  5.21,  5.58,  5.54,  5.46,  5.52,  5.55,  5.64,  5.67,  6.15,

//  Tb,    Dy,    Ho,    Er,    Tm,    Yb,    Lu,    Hf,    Ta,     W, (74)
  5.86,  5.94,  6.02,  6.11,  6.18,  6.25,  5.43,  6.83,  7.89,  7.98,

//  Re,    Os,    Ir,    Pt,    Au,    Hg,    Tl,    Pb,    Bi,    Po, (84)
  7.88,  8.70,  9.10,  9.00,  9.23, 10.44,  6.11,  7.42,  7.29,  8.42,

//  At,    Rn,    Fr,    Ra,    Ac,    Th,    Pa,     U,    Np,    Pu, (94)
  9.65, 10.75,  3.97,  5.28,  5.17,  6.08,  5.89,  6.19,  6.27,  6.06,

//  Am,    Cm,    Bk,    Cf,    Es,    Fm                             (100)
  5.99,  6.02,  6.23,  6.30,  6.42,  6.50

};


__constant__ float PhotoElec_std_SandiaTable[981][5] =
{


{ 0.0,          0.0,         0.0,         0.0,         0.0 },  // 'zero' row

// Z - Element - Elm - Number of intervals   new   (for corrected element)

// 1 - Hydrogen - H - 10    new (commented are Sandia version)

//    0.01,     0.1000E-07,  0.0000E+00,  0.0000E+00,  0.0000E+00,
//   0.014,    -0.6383E+02, -0.6446E+01,  0.1317E+02, -0.5045E-01,

{ 0.01,         0.0000E+00,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0136,      -1.231E+06,   5.900E+04,  -8.407E+02,   3.74E+00   } ,
{ 0.02,        -1.131E+04,  -3.682E+02,   9.516E+01,  -1.075E+00  } ,
{ 0.0457,       2.139E+05,  -3.303E+04,   1.765E+03,  -2.983E+01  } ,
{ 0.1,          0.3051E+01, -0.7818E+01,  0.1144E+02,  0.6959E-01 } ,
{ 0.8,          0.7636E-01, -0.9406E+00,  0.6144E+01,  0.1425E+01 } ,
{ 4.0,          0.1180E-02, -0.8236E-01,  0.2886E+01,  0.5534E+01 } ,
{ 20.0,         0.1620E-04, -0.5610E-02,  0.1214E+01,  0.1761E+02 } ,
{ 100.0,        0.1034E-05, -0.4114E-03,  0.6287E+00,  0.3927E+02 } ,
{ 500.0,        0.4599E-06,  0.5006E-03, -0.1425E-01,  0.1960E+03 } ,

// 2 - Helium - He - 7      new

//   0.01,     0.1000E-07,  0.0000E+00,  0.0000E+00,  0.0000E+00,
//   0.025,   -0.1196E+04,  0.4759E+03,  0.1979E+02, -0.3540E+00,

{ 0.01,        -2.997E+03,   1.050E+03,  -8.333E+00,   3.107E-02  } ,
{ 0.15,         0.1857E+02, -0.4079E+02,  0.8609E+02, -0.2618E+01 } ,
{ 0.8,          0.1606E+01, -0.1726E+02,  0.8101E+02, -0.4928E+01 } ,
{ 4.0,          0.3663E-02, -0.3782E+00,  0.2288E+02,  0.6006E+02 } ,
{ 20.0,         0.5934E-03, -0.1109E+00,  0.1388E+02,  0.1680E+03 } ,
{ 100.0,        0.1120E-04, -0.3894E-02,  0.6136E+01,  0.4354E+03 } ,
{ 500.0,        0.4921E-05,  0.1493E-02,  0.4725E+01,  0.7128E+03 } ,

// 3 - Lithium - Li - 7

{ 0.01,        -0.2418E+03,  0.3530E+02, -0.2699E+00,  0.5580E-03 } ,
{ 0.055,       -0.1474E+03,  0.1578E+03,  0.2036E+03, -0.8521E+01 } ,
{ 0.8,          0.4375E+01, -0.5094E+02,  0.3053E+03, -0.3064E+02 } ,
{ 4.0,          0.4040E-01, -0.2930E+01,  0.1293E+03,  0.1828E+03 } ,
{ 20.0,         0.3139E-02, -0.6107E+00,  0.7342E+02,  0.6852E+03 } ,
{ 100.0,        0.4823E-04, -0.1161E-01,  0.2898E+02,  0.2129E+04 } ,
{ 500.0,        0.2128E-04,  0.1951E-01,  0.1009E+02,  0.7144E+04 } ,

// 4 - Beryllium - Be - 7

{ 0.01,        -0.2785E+03,  0.1252E+03, -0.1912E+01,  0.8371E-02 } ,
{ 0.111,       -0.4798E+03,  0.6302E+03,  0.4187E+03, -0.2783E+02 } ,
{ 0.8,          0.1037E+02, -0.1280E+03,  0.8807E+03, -0.1646E+03 } ,
{ 4.0,          0.1018E+00, -0.8264E+01,  0.4158E+03,  0.4366E+03 } ,
{ 20.0,         0.5693E-02, -0.1595E+01,  0.2644E+03,  0.1566E+04 } ,
{ 100.0,        0.2129E-03, -0.7972E-01,  0.1155E+03,  0.6065E+04 } ,
{ 500.0,        0.7797E-04,  0.7695E-01,  0.3396E+02,  0.2439E+05 } ,

// 5 - Boron - B - 7

{ 0.01,        -0.3387E+03,  0.1923E+03, -0.2742E+01,  0.1204E-01 } ,
{ 0.188,       -0.9943E+03,  0.1816E+04,  0.3939E+03, -0.1755E+02 } ,
{ 0.8,          0.3689E+01, -0.8834E+02,  0.1525E+04, -0.2145E+03 } ,
{ 4.0,          0.6447E+00, -0.3953E+02,  0.1281E+04,  0.1768E+03 } ,
{ 20.0,         0.1852E-02, -0.1356E+01,  0.5252E+03,  0.5160E+04 } ,
{ 100.0,        0.4282E-03, -0.1297E+00,  0.2892E+03,  0.1601E+05 } ,
{ 500.0,        0.1965E-03,  0.1947E+00,  0.1001E+03,  0.5902E+05 } ,

// 6 - Carbon - C - 10      new

//C    0.01,   0.5704E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00,

{ 0.01,         0.0 ,        0.0 ,        0.0 ,        0.0        } ,
{ 0.0136,       1.390E+05,  -5.808E+03,   8.269E+01,  -3.935E-01  } ,
{ 0.02,        -3.829E+04,   3.768E+03,  -9.082E+01,   6.775E-01  } ,
{ 0.0457,      -0.3935E+03,  0.3219E+03, -0.6549E+01,  0.2086E+00 } ,
{ 0.284,       -0.9022E+03,  0.1760E+04,  0.1549E+04, -0.2280E+02 } ,
{ 0.8,         -0.7363E+01, -0.1537E+02,  0.2672E+04, -0.4482E+03 } ,
{ 4.0,          0.1640E+01, -0.9428E+02,  0.2872E+04, -0.5583E+03 } ,
{ 20.0,        -0.3742E-02, -0.1232E+01,  0.9489E+03,  0.1406E+05 } ,
{ 100.0,        0.6760E-03, -0.1164E+00,  0.6566E+03,  0.2739E+05 } ,
{ 500.0,        0.4503E-03,  0.4692E+00,  0.2183E+03,  0.1308E+06 } ,

// 7 - Nitrogen - N - 8

{ 0.01,         0.1010E+05,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0404,      -0.3622E+03,  0.3873E+03,  0.1244E+02, -0.4452E+00 } ,
{ 0.4016,      -0.2338E+04,  0.5732E+04, -0.2082E+03,  0.1482E+03 } ,
{ 0.8,         -0.4940E+01, -0.8442E+02,  0.4620E+04, -0.1186E+04 } ,
{ 4.0,          0.2019E+01, -0.1249E+03,  0.4609E+04, -0.9421E+03 } ,
{ 20.0,         0.1709E-01, -0.8196E+01,  0.2345E+04,  0.1369E+05 } ,
{ 100.0,        0.1872E-02, -0.6732E+00,  0.1282E+04,  0.5700E+05 } ,
{ 500.0,        0.8122E-03,  0.8364E+00,  0.4410E+03,  0.2358E+06 } ,

// 8 - Oxygen - O - 8     new

// C   0.01,   0.1144E+05,  0.0000E+00,  0.0000E+00,  0.0000E+00,

{ 0.01,         9.343E+03,   9.026E+02,  -2.467E+01,   1.505E-01  } ,
{ 0.02,         6.034E+03,   7.319E+02,  -2.677E+01,   2.842E-01  } ,
{ 0.0483,      -0.2863E+03,  0.4085E+03,  0.4436E+02, -0.1782E+01 } ,
{ 0.532,       -0.7181E+02,  0.4748E+03,  0.5542E+04, -0.1363E+04 } ,
{ 4.0,          0.2745E+01, -0.1747E+03,  0.7159E+04, -0.2213E+04 } ,
{ 20.0,         0.3774E-01, -0.1559E+02,  0.4045E+04,  0.1810E+05 } ,
{ 100.0,        0.3169E-02, -0.1146E+01,  0.2194E+04,  0.9131E+05 } ,
{ 500.0,        0.1367E-02,  0.1473E+01,  0.7214E+03,  0.4048E+06 } ,

// 9 - Fluorine - F - 7

{ 0.01,         0.1129E+05,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0724,      -0.2676E+03,  0.4767E+03,  0.8767E+02, -0.4504E+01 } ,
{ 0.687,       -0.8907E+02,  0.6850E+03,  0.7217E+04, -0.2022E+04 } ,
{ 4.0,          0.2813E+01, -0.2020E+03,  0.9903E+04, -0.4454E+04 } ,
{ 20.0,         0.6097E-01, -0.2435E+02,  0.6099E+04,  0.2258E+05 } ,
{ 100.0,        0.4857E-02, -0.1805E+01,  0.3335E+04,  0.1285E+06 } ,
{ 500.0,        0.2041E-02,  0.2257E+01,  0.1084E+04,  0.5997E+06 } ,

// 10 - Neon - Ne - 8       new

// C   0.01,     0.1000E-05,  0.0000E+00,  0.0000E+00,  0.0000E+00,
// C   0.0183,   0.8235E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00,
// C   0.045,   -0.6059E+04,  0.3242E+04, -0.1796E+03,  0.3141E+01,

{ 0.01,         1.553E+04,  -1.011E+02,  -5.441E+00,   4.873E-02  } ,
{ 0.045,        9.347E+02,   2.197E+03,  -1.282E+02,   2.253E+00  } ,
{ 0.124,       -0.1940E+03,  0.4340E+03,  0.2357E+03, -0.1666E+02 } ,
{ 0.867,       -0.8680E+02,  0.7434E+03,  0.1077E+05, -0.3822E+04 } ,
{ 4.0,          0.3167E+01, -0.2491E+03,  0.1439E+05, -0.8187E+04 } ,
{ 20.0,         0.1288E+00, -0.4471E+02,  0.9862E+04,  0.2497E+05 } ,
{ 100.0,        0.5202E-02,  0.7337E-01,  0.4614E+04,  0.2256E+06 } ,
{ 500.0,        0.3087E-02,  0.3402E+01,  0.1569E+04,  0.1147E+07 } ,

// 11 - Sodium - Na - 7

{ 0.01,         0.5429E+02,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.031,        0.8874E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.063,       -0.5565E+03,  0.1088E+04,  0.1062E+03, -0.6845E+01 } ,
{ 1.073,        0.1732E+01, -0.1853E+03,  0.1712E+05, -0.8415E+04 } ,
{ 20.0,         0.2726E+00, -0.8218E+02,  0.1475E+05,  0.9467E+04 } ,
{ 100.0,        0.2083E-02,  0.4548E+01,  0.5521E+04,  0.3358E+06 } ,
{ 500.0,        0.4199E-02,  0.4808E+01,  0.1793E+04,  0.1898E+07 } ,

// 12 - Magnesium - Mg - 7

{ 0.01,        -0.5574E+03,  0.8687E+02, -0.1493E+01,  0.8660E-02 } ,
{ 0.051,       -0.2726E+05,  0.9700E+04, -0.6921E+03,  0.1445E+02 } ,
{ 0.123,       -0.6179E+03,  0.1379E+04,  0.2321E+03, -0.2291E+02 } ,
{ 1.305,       -0.6648E+00, -0.1084E+03,  0.2219E+05, -0.1241E+05 } ,
{ 20.0,         0.4080E+00, -0.1205E+03,  0.2139E+05, -0.1143E+03 } ,
{ 100.0,        0.8338E-02,  0.2236E+01,  0.8819E+04,  0.4284E+06 } ,
{ 500.0,        0.6233E-02,  0.7344E+01,  0.2662E+04,  0.2460E+07 } ,

// 13 - Aluminum - Al - 8

{ 0.01,        -0.1654E+05,  0.1585E+03,  0.3907E+01, -0.3383E-01 } ,
{ 0.0159,       0.1122E+04, -0.4015E+02,  0.6623E+00, -0.2813E-02 } ,
{ 0.073,        0.2390E+05, -0.6953E+03, -0.7978E+02,  0.1974E+01 } ,
{ 0.1177,      -0.5284E+03,  0.1399E+04,  0.4360E+03, -0.4747E+02 } ,
{ 1.56,        -0.3674E+01, -0.1622E+02,  0.2732E+05, -0.1752E+05 } ,
{ 20.0,         0.4158E+00, -0.1351E+03,  0.2716E+05,  0.3723E+03 } ,
{ 100.0,        0.1125E-01,  0.2747E+01,  0.1174E+05,  0.5695E+06 } ,
{ 500.0,        0.8505E-02,  0.1049E+02,  0.4429E+04,  0.2413E+07 } ,

// 14 - Silicon - Si - 7

{ 0.01,         0.4575E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,      -0.1168E+03,  0.1269E+03, -0.5506E+01,  0.6616E-01 } ,
{ 0.099,       -0.6451E+03,  0.1836E+04,  0.5350E+03, -0.6436E+02 } ,
{ 1.839,       -0.4056E+01, -0.1089E+02,  0.3544E+05, -0.2595E+05 } ,
{ 20.0,         0.4945E+00, -0.1682E+03,  0.3627E+05, -0.1605E+05 } ,
{ 100.0,        0.2716E-01, -0.5428E+01,  0.1775E+05,  0.6765E+06 } ,
{ 500.0,        0.1127E-01,  0.1376E+02,  0.4871E+04,  0.4477E+07 } ,

// 15 - Phosphorus - P - 7

{ 0.01,         0.4728E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0306,      -0.2227E+03,  0.2204E+03, -0.1122E+02,  0.1569E+00 } ,
{ 0.132,       -0.5700E+03,  0.1909E+04,  0.7651E+03, -0.1123E+03 } ,
{ 2.144,       -0.6098E+01,  0.7712E+02,  0.4196E+05, -0.3437E+05 } ,
{ 20.0,         0.5710E+00, -0.2001E+03,  0.4505E+05, -0.3853E+05 } ,
{ 100.0,        0.3613E-01, -0.8426E+01,  0.2277E+05,  0.8080E+06 } ,
{ 500.0,        0.1421E-01,  0.1770E+02,  0.6221E+04,  0.5554E+07 } ,

// 16 - Sulfer - S - 7

{ 0.01,         0.5368E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0341,      -0.2097E+03,  0.3174E+03, -0.1815E+02,  0.2796E+00 } ,
{ 0.165,       -0.4885E+03,  0.1976E+04,  0.1206E+04, -0.1934E+03 } ,
{ 2.472,       -0.1021E+02,  0.2346E+03,  0.5164E+05, -0.4707E+05 } ,
{ 20.0,         0.7467E+00, -0.2534E+03,  0.5800E+05, -0.6691E+05 } ,
{ 100.0,        0.6338E-01, -0.3443E+02,  0.4058E+05,  0.2233E+06 } ,
{ 500.0,        0.1857E-01,  0.2398E+02,  0.6706E+04,  0.8358E+07 } ,

// 17 - Chlorine - Cl - 7

{ 0.01,         0.7808E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0436,      -0.6163E+02,  0.3934E+03, -0.2563E+02,  0.4396E+00 } ,
{ 0.2,         -0.2147E+03,  0.1269E+04,  0.2099E+04, -0.3705E+03 } ,
{ 2.824,       -0.1192E+02,  0.3253E+03,  0.5927E+05, -0.5980E+05 } ,
{ 20.0,         0.8789E+00, -0.2920E+03,  0.6860E+05, -0.1018E+06 } ,
{ 100.0,        0.6556E-01, -0.2175E+02,  0.3895E+05,  0.9737E+06 } ,
{ 500.0,        0.2236E-01,  0.2884E+02,  0.9717E+04,  0.9001E+07 } ,

// 18 - Argon - Ar - 7      new

// C   0.01,     0.1275E+05,  0.0000E+00,  0.0000E+00,  0.0000E+00,
// C   0.0302,  -0.1674E+04,  0.1047E+04, -0.9010E+02,  0.2166E+01,

{ 0.01,        -8.294E+04,   5.720E+03,  -1.101E+02,   6.668E-01  } ,
{ 0.04,        -1.401E+03,   9.577E+02,  -7.842E+01,   1.797E+00  } ,
{ 0.245,       -0.2244E+03,  0.1388E+04,  0.2571E+04, -0.5113E+03 } ,
{ 3.203,       -0.1446E+02,  0.4359E+03,  0.6578E+05, -0.7284E+05 } ,
{ 20.0,         0.8786E+00, -0.3001E+03,  0.7682E+05, -0.1219E+06 } ,
{ 100.0,        0.6779E-01, -0.2695E+02,  0.5069E+05,  0.5281E+06 } ,
{ 500.0,        0.2598E-01,  0.3454E+02,  0.1059E+05,  0.1068E+08 } ,

// 19 - Potassium - K - 7

{ 0.01,         0.3111E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.6162E+02,  0.5770E+03, -0.4497E+02,  0.9218E+00 } ,
{ 0.294,       -0.3601E+03,  0.2287E+04,  0.2513E+04, -0.4591E+03 } ,
{ 3.607,       -0.2113E+02,  0.7161E+03,  0.8183E+05, -0.9859E+05 } ,
{ 20.0,         0.1048E+01, -0.3644E+03,  0.9844E+05, -0.1760E+06 } ,
{ 100.0,        0.1040E+00, -0.3553E+02,  0.6096E+05,  0.1226E+07 } ,
{ 500.0,        0.3453E-01,  0.4621E+02,  0.1669E+05,  0.1238E+08 } ,

// 20 - Calcium - Ca - 7

{ 0.01,         0.3029E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.3816E+03,  0.5887E+03, -0.4888E+02,  0.1019E+01 } ,
{ 0.346,       -0.1054E+03,  0.1120E+04,  0.5115E+04, -0.1325E+04 } ,
{ 4.037,       -0.3015E+02,  0.1141E+04,  0.9459E+05, -0.1195E+06 } ,
{ 20.0,         0.1408E+01, -0.4553E+03,  0.1206E+06, -0.2531E+06 } ,
{ 100.0,        0.1204E+00, -0.5356E+02,  0.8779E+05,  0.6252E+06 } ,
{ 500.0,        0.4178E-01,  0.5761E+02,  0.1377E+05,  0.2019E+08 } ,

// 21 Scandium - Sc - 6

{ 0.01,         0.1121E+04,  0.7413E+01, -0.3020E+00,  0.1510E-02 } ,
{ 0.032,        0.2970E+03,  0.6359E+03, -0.4935E+02,  0.1044E+01 } ,
{ 0.402,       -0.1507E+03,  0.1501E+04,  0.5139E+04, -0.1442E+04 } ,
{ 4.491,        0.4615E+00, -0.2614E+03,  0.1217E+06, -0.2057E+06 } ,
{ 100.0,        0.1509E+00, -0.6913E+02,  0.9253E+05,  0.1096E+07 } ,
{ 500.0,        0.4833E-01,  0.6881E+02,  0.2762E+05,  0.1290E+08 } ,

// 22 - Titanium - Ti - 6

{ 0.01,         0.3596E+04, -0.6877E+02,  0.9609E+00, -0.4754E-02 } ,
{ 0.1,         -0.3132E+03,  0.1024E+04, -0.1008E+03,  0.3096E+01 } ,
{ 0.456,       -0.4626E+02,  0.8678E+03,  0.7308E+04, -0.2383E+04 } ,
{ 4.966,        0.2074E+00, -0.2292E+03,  0.1371E+06, -0.2489E+06 } ,
{ 100.0,        0.1972E+00, -0.9550E+02,  0.1106E+06,  0.1067E+07 } ,
{ 500.0,        0.5606E-01,  0.8140E+02,  0.3106E+05,  0.1567E+08 } ,

// 23 - Vanadium - V - 7

{ 0.01,         0.4117E+04, -0.1054E+03,  0.1531E+01, -0.7725E-02 } ,
{ 0.12,        -0.4052E+03,  0.1169E+04, -0.1212E+03,  0.4148E+01 } ,
{ 0.513,        0.9968E+04, -0.1796E+04, -0.1204E+04,  0.1481E+04 } ,
{ 0.628,       -0.1429E+03,  0.1632E+04,  0.7203E+04, -0.2283E+04 } ,
{ 5.465,        0.3940E+00, -0.2733E+03,  0.1564E+06, -0.3184E+06 } ,
{ 100.0,        0.2007E+00, -0.8911E+02,  0.1254E+06,  0.1137E+07 } ,
{ 500.0,        0.6449E-01,  0.9483E+02,  0.3584E+05,  0.1821E+08 } ,

// 24 - Chromium - Cr - 6

{ 0.01,         0.5069E+04, -0.7968E+02,  0.8395E+00, -0.4494E-02 } ,
{ 0.106,       -0.4404E+03,  0.1301E+04, -0.1166E+03,  0.3481E+01 } ,
{ 0.575,        0.3932E+02,  0.1537E+03,  0.1228E+05, -0.4984E+04 } ,
{ 5.989,        0.2740E+00, -0.2665E+03,  0.1818E+06, -0.3997E+06 } ,
{ 100.0,        0.2727E+00, -0.1288E+03,  0.1543E+06,  0.9755E+06 } ,
{ 500.0,        0.7660E-01,  0.1142E+03,  0.4290E+05,  0.2161E+08 } ,

// 25 - Manganese - Mn - 6

{ 0.01,         0.5692E+04, -0.1278E+03,  0.1150E+01, -0.3774E-02 } ,
{ 0.1,         -0.4901E+03,  0.1450E+04, -0.1365E+03,  0.4134E+01 } ,
{ 0.64,        -0.3065E+02,  0.7209E+03,  0.1275E+05, -0.5462E+04 } ,
{ 6.539,        0.2930E+00, -0.2703E+03,  0.2034E+06, -0.4886E+06 } ,
{ 100.0,        0.2940E+00, -0.1342E+03,  0.1761E+06,  0.8747E+06 } ,
{ 500.0,        0.8736E-01,  0.1322E+03,  0.4952E+05,  0.2436E+08 } ,

// 26 - Iron - Fe - 7

{ 0.01,        -0.3328E+04,  0.2590E+03, -0.3812E+01,  0.1679E-01 } ,
{ 0.024,        0.4132E+04,  0.3963E+03, -0.2505E+02,  0.3437E+00 } ,
{ 0.12,        -0.2683E+02,  0.1250E+04, -0.7321E+02,  0.1137E+01 } ,
{ 0.708,       -0.8128E+01,  0.6550E+03,  0.1511E+05, -0.7079E+04 } ,
{ 7.112,        0.2151E+00, -0.2680E+03,  0.2341E+06, -0.6063E+06 } ,
{ 100.0,        0.3511E+00, -0.1633E+03,  0.2090E+06,  0.7131E+06 } ,
{ 500.0,        0.1026E+00,  0.1572E+03,  0.5901E+05,  0.2806E+08 } ,

// 27 - Cobalt - Co - 7

{ 0.01,         0.2074E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0308,       0.6932E+04, -0.6765E-01, -0.9182E+01,  0.1413E+00 } ,
{ 0.093,       -0.8228E+03,  0.1982E+04, -0.1782E+03,  0.4937E+01 } ,
{ 0.779,        0.2092E+02,  0.3311E+03,  0.1820E+05, -0.9303E+04 } ,
{ 7.709,        0.4947E-01, -0.2478E+03,  0.2586E+06, -0.7185E+06 } ,
{ 100.0,        0.3588E+00, -0.1492E+03,  0.2296E+06,  0.8856E+06 } ,
{ 500.0,        0.1154E+00,  0.1796E+03,  0.6740E+05,  0.3100E+08 } ,

// 28 - Nickel - Ni - 8

{ 0.01,         0.8515E+04, -0.2121E+03,  0.2132E+01, -0.7667E-02 } ,
{ 0.1,         -0.1021E+04,  0.2388E+04, -0.2361E+03,  0.7261E+01 } ,
{ 0.854,        0.0000E+00,  0.6600E+04,  0.0000E+00,  0.0000E+00 } ,
{ 0.871,        0.0000E+00,  0.9810E+04,  0.0000E+00,  0.0000E+00 } ,
{ 1.008,       -0.1175E+03,  0.2171E+04,  0.1514E+05, -0.6042E+04 } ,
{ 8.332,        0.1685E-01, -0.2522E+03,  0.3005E+06, -0.9000E+06 } ,
{ 100.0,        0.4681E+00, -0.2085E+03,  0.2782E+06,  0.4399E+06 } ,
{ 500.0,        0.1364E+00,  0.2148E+03,  0.8039E+05,  0.3626E+08 } ,

// 29 - Cooper - Cu - 7

{ 0.01,         0.9992E+04, -0.3780E+03,  0.5657E+01, -0.2788E-01 } ,
{ 0.1,         -0.8896E+03,  0.2391E+04, -0.1986E+03,  0.3649E+01 } ,
{ 0.933,       -0.5089E+03,  0.4139E+04,  0.7468E+04, -0.6981E+03 } ,
{ 1.096,       -0.9173E+02,  0.1862E+04,  0.1777E+05, -0.8202E+04 } ,
{ 8.981,        0.7440E-02, -0.2371E+03,  0.3202E+06, -0.1028E+07 } ,
{ 100.0,        0.4729E+00, -0.2055E+03,  0.3000E+06,  0.2182E+06 } ,
{ 500.0,        0.1472E+00,  0.2345E+03,  0.8644E+05,  0.3990E+08 } ,

// 30 - Zinc - Zn - 9

{ 0.01,         0.1479E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0307,       0.1325E+05, -0.6762E+03,  0.1188E+02, -0.6785E-01 } ,
{ 0.109,       -0.1330E+04,  0.3104E+04, -0.3092E+03,  0.8946E+01 } ,
{ 1.02,        -0.2807E+05,  0.1091E+06, -0.1511E+06,  0.7897E+05 } ,
{ 1.043,       -0.3057E+04,  0.1385E+05,  0.3780E+03, -0.2163E+03 } ,
{ 1.193,       -0.8018E+02,  0.1794E+04,  0.2095E+05, -0.1070E+05 } ,
{ 9.659,       -0.1158E+01, -0.3871E+02,  0.3499E+06, -0.1154E+07 } ,
{ 100.0,        0.4820E+00, -0.1832E+03,  0.3296E+06,  0.6802E+06 } ,
{ 500.0,        0.1669E+00,  0.2696E+03,  0.1000E+06,  0.4382E+08 } ,

// 31 - Gallium - Ga - 9

{ 0.01,         0.1479E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0278,       0.1211E+05, -0.7144E+03,  0.1535E+02, -0.1030E+00 } ,
{ 0.076,       -0.1199E+04,  0.3215E+04, -0.3594E+03,  0.1152E+02 } ,
{ 1.116,       -0.1457E+05,  0.6363E+05, -0.1011E+06,  0.6416E+05 } ,
{ 1.142,        0.3470E+04, -0.8674E+04,  0.2548E+05, -0.8411E+04 } ,
{ 1.298,       -0.9431E+02,  0.2078E+04,  0.2172E+05, -0.1101E+05 } ,
{ 10.367,      -0.1253E+01, -0.2897E+02,  0.3783E+06, -0.1357E+07 } ,
{ 100.0,        0.5591E+00, -0.2217E+03,  0.3625E+06,  0.3392E+06 } ,
{ 500.0,        0.1949E+00,  0.2371E+03,  0.1767E+06,  0.2400E+08 } ,

// 32 - Germanium - Ge - 9

{ 0.01,         0.4941E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.1269E+05, -0.9339E+03,  0.2767E+02, -0.1952E+00 } ,
{ 0.1,         -0.1358E+04,  0.3695E+04, -0.4569E+03,  0.1599E+02 } ,
{ 1.217,       -0.7402E+04,  0.3636E+05, -0.6670E+05,  0.5346E+05 } ,
{ 1.248,       -0.3400E+03,  0.3232E+04,  0.1163E+05, -0.1089E+04 } ,
{ 1.413,       -0.5940E+02,  0.1646E+04,  0.2621E+05, -0.1507E+05 } ,
{ 11.104,      -0.2025E+01,  0.1283E+03,  0.4069E+06, -0.1510E+07 } ,
{ 100.0,        0.6478E+00, -0.2603E+03,  0.4045E+06, -0.5153E+05 } ,
{ 500.0,        0.2155E+00,  0.2609E+03,  0.2074E+06,  0.2220E+08 } ,

// 33 - Arsenic - As - 9

{ 0.01,         0.2547E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0371,       0.2402E+05, -0.3110E+04,  0.1364E+03, -0.1877E+01 } ,
{ 0.1,         -0.1536E+04,  0.4198E+04, -0.5497E+03,  0.1920E+02 } ,
{ 1.323,       -0.4525E+04,  0.2468E+05, -0.5133E+05,  0.5102E+05 } ,
{ 1.359,       -0.3858E+03,  0.1013E+05,  0.3603E+04, -0.7657E+03 } ,
{ 1.529,       -0.5339E+02,  0.1649E+04,  0.2950E+05, -0.1800E+05 } ,
{ 11.867,      -0.1655E+01,  0.8588E+02,  0.4504E+06, -0.1795E+07 } ,
{ 100.0,        0.7880E+00, -0.3490E+03,  0.4641E+06, -0.1258E+07 } ,
{ 500.0,        0.2393E+00,  0.2906E+03,  0.2360E+06,  0.2145E+08 } ,

// 34 - Selenium - Se - 9

{ 0.01,         0.1577E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0371,       0.1806E+05, -0.2230E+04,  0.9408E+02, -0.1263E+01 } ,
{ 0.114,       -0.1610E+04,  0.4614E+04, -0.6392E+03,  0.2252E+02 } ,
{ 1.434,       -0.6637E+03,  0.4194E+04, -0.1104E+05,  0.2806E+05 } ,
{ 1.475,       -0.4265E+03,  0.9660E+04,  0.5343E+04, -0.1174E+04 } ,
{ 1.652,       -0.3968E+02,  0.1459E+04,  0.3327E+05, -0.2228E+05 } ,
{ 12.658,      -0.3461E+01,  0.4401E+03,  0.4690E+06, -0.1943E+07 } ,
{ 100.0,        0.8564E+00, -0.3723E+03,  0.5020E+06, -0.1430E+07 } ,
{ 500.0,        0.2590E+00,  0.3237E+03,  0.2541E+06,  0.2321E+08 } ,

// 35 -Bromine - Br - 10

{ 0.01,         0.2129E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.035,        0.1451E+05, -0.1941E+04,  0.8744E+02, -0.1214E+01 } ,
{ 0.1,         -0.3534E+04,  0.6788E+04, -0.1134E+04,  0.5165E+02 } ,
{ 0.5,         -0.3347E+03,  0.2195E+04,  0.1033E+04, -0.2839E+03 } ,
{ 1.551,        0.1461E+03, -0.1050E+04,  0.3457E+04,  0.2000E+05 } ,
{ 1.597,       -0.4318E+03,  0.1007E+05,  0.6548E+04, -0.1535E+04 } ,
{ 1.782,       -0.4033E+02,  0.1607E+04,  0.3681E+05, -0.2478E+05 } ,
{ 13.474,      -0.3955E+01,  0.5482E+03,  0.5202E+06, -0.2262E+07 } ,
{ 100.0,        0.9718E+00, -0.4209E+03,  0.5662E+06, -0.2099E+07 } ,
{ 500.0,        0.2907E+00,  0.3653E+03,  0.2908E+06,  0.2417E+08 } ,

// 36 - Krypton - Kr - 10  new

// C  0.01,    0.3691E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00,

{ 0.01,        -6.520E+03,   4.096E+02,  -2.238E+00,  -2.240E-02  } ,
{ 0.0305,       0.2024E+04, -0.2083E+03,  0.4439E+01,  0.1056E+00 } ,
{ 0.097,        0.7648E+03,  0.5257E+04, -0.9960E+03,  0.4686E+02 } ,
{ 0.3,         -0.2451E+03,  0.2199E+04,  0.1217E+04, -0.3120E+03 } ,
{ 1.675,        0.3611E+03, -0.2974E+04,  0.1308E+05,  0.1268E+05 } ,
{ 1.727,       -0.4163E+03,  0.1017E+05,  0.7535E+04, -0.1891E+04 } ,
{ 1.921,       -0.9924E+00,  0.8455E+03,  0.4446E+05, -0.3490E+05 } ,
{ 14.323,      -0.3076E+01,  0.4257E+03,  0.5613E+06, -0.2587E+07 } ,
{ 100.0,        0.1050E+01, -0.4435E+03,  0.6114E+06, -0.3028E+07 } ,
{ 500.0,        0.3136E+00,  0.3952E+03,  0.3252E+06,  0.2248E+08 } ,

// 37 - Rubidium - Rb - 10

{ 0.01,         0.4606E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.1441E+04, -0.1761E+03,  0.6821E+01,  0.4470E-01 } ,
{ 0.111,       -0.6763E+03,  0.6772E+04, -0.1372E+04,  0.7035E+02 } ,
{ 0.3,         -0.3457E+03,  0.2591E+04,  0.1242E+04, -0.3481E+03 } ,
{ 1.805,        0.3524E+03, -0.3194E+04,  0.1657E+05,  0.1224E+05 } ,
{ 1.863,       -0.4025E+03,  0.1067E+05,  0.8396E+04, -0.2275E+04 } ,
{ 2.065,        0.5234E+01,  0.7494E+03,  0.5033E+05, -0.4276E+05 } ,
{ 15.2,        -0.2207E+01,  0.2653E+03,  0.6269E+06, -0.3163E+07 } ,
{ 100.0,        0.1101E+01, -0.4280E+03,  0.6664E+06, -0.3481E+07 } ,
{ 500.0,        0.3467E+00,  0.4515E+03,  0.3525E+06,  0.2783E+08 } ,

// 38 - Strontium - Sr - 10

{ 0.01,         0.4850E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0307,       0.7854E+03, -0.6513E+02,  0.2134E+01,  0.1138E+00 } ,
{ 0.133,       -0.2484E+04,  0.8950E+04, -0.2019E+04,  0.1171E+03 } ,
{ 0.3,         -0.3209E+03,  0.2818E+04,  0.1344E+04, -0.3984E+03 } ,
{ 1.94,         0.2746E+03, -0.2830E+04,  0.2149E+05,  0.7655E+04 } ,
{ 2.007,       -0.4181E+03,  0.1025E+05,  0.1159E+05, -0.3199E+04 } ,
{ 2.216,       -0.4367E+02,  0.1966E+04,  0.4835E+05, -0.3788E+05 } ,
{ 16.105,      -0.5177E+00, -0.2546E+02,  0.6941E+06, -0.3733E+07 } ,
{ 100.0,        0.1296E+01, -0.5192E+03,  0.7384E+06, -0.5043E+07 } ,
{ 500.0,        0.3800E+00,  0.4950E+03,  0.4111E+06,  0.1955E+08 } ,

// 39 - Yttrium - Y - 10

{ 0.01,         0.3854E+05, -0.1366E+04,  0.1672E+02, -0.6795E-01 } ,
{ 0.0232,       0.2849E+04, -0.2828E+03,  0.1529E+02, -0.1723E+00 } ,
{ 0.1677,      -0.6721E+04,  0.1290E+05, -0.3111E+04,  0.1985E+03 } ,
{ 0.8,          0.3585E+03, -0.4223E+03,  0.6620E+04, -0.2706E+04 } ,
{ 2.079,       -0.8813E+02,  0.1184E+04,  0.2198E+05, -0.1440E+04 } ,
{ 2.155,       -0.4141E+03,  0.1043E+05,  0.1385E+05, -0.4020E+04 } ,
{ 2.373,       -0.1282E+02,  0.1204E+04,  0.6028E+05, -0.5752E+05 } ,
{ 17.038,       0.4265E+00, -0.1646E+03,  0.7684E+06, -0.4421E+07 } ,
{ 100.0,        0.1334E+01, -0.4917E+03,  0.8066E+06, -0.5879E+07 } ,
{ 500.0,        0.4194E+00,  0.5651E+03,  0.4353E+06,  0.2981E+08 } ,

// 40 - Zirconium - Zr - 9

{ 0.01,         0.2993E+03,  0.1449E+03, -0.3012E+01,  0.1713E-01 } ,
{ 0.18,        -0.7040E+04,  0.1434E+05, -0.3926E+04,  0.2887E+03 } ,
{ 0.5,         -0.1647E+03,  0.2296E+04,  0.3166E+04, -0.1127E+04 } ,
{ 2.223,       -0.2164E+03,  0.3512E+04,  0.2053E+05, -0.3382E+04 } ,
{ 2.307,       -0.3996E+03,  0.1064E+05,  0.1548E+05, -0.4776E+04 } ,
{ 2.533,       -0.3011E+02,  0.1794E+04,  0.6153E+05, -0.5699E+05 } ,
{ 17.998,      -0.5900E+00,  0.1945E+03,  0.8031E+06, -0.4579E+07 } ,
{ 100.0,        0.1474E+01, -0.5530E+03,  0.8907E+06, -0.7927E+07 } ,
{ 500.0,        0.4562E+00,  0.6248E+03,  0.4760E+06,  0.3216E+08 } ,

// 41 - Niobium - Nb - 10

{ 0.01,         0.3251E+04, -0.6844E+02,  0.1575E+01, -0.1094E-01 } ,
{ 0.0297,       0.2754E+04, -0.4897E+03,  0.4237E+02, -0.8372E+00 } ,
{ 0.2083,      -0.2018E+04,  0.8543E+04, -0.1769E+04,  0.2770E+02 } ,
{ 0.9,          0.2150E+03,  0.4490E+03,  0.6409E+04, -0.2429E+04 } ,
{ 2.37,        -0.2981E+03,  0.6188E+04,  0.1735E+05, -0.4420E+04 } ,
{ 2.464,       -0.3923E+03,  0.1102E+05,  0.1751E+05, -0.5733E+04 } ,
{ 2.698,       -0.1658E+02,  0.1435E+04,  0.7050E+05, -0.7037E+05 } ,
{ 18.986,      -0.2292E+01,  0.5516E+03,  0.8555E+06, -0.5018E+07 } ,
{ 100.0,        0.1599E+01, -0.5764E+03,  0.9643E+06, -0.8517E+07 } ,
{ 500.0,        0.4986E+00,  0.7224E+03,  0.4910E+06,  0.4104E+08 } ,

// 42 - Molybdenum - Mo - 10

{ 0.01,        -0.3508E+04,  0.3050E+03, -0.4620E+01,  0.1998E-01 } ,
{ 0.03,         0.3053E+04, -0.6192E+03,  0.5104E+02, -0.9955E+00 } ,
{ 0.229,       -0.7786E+04,  0.1722E+05, -0.5215E+04,  0.3992E+03 } ,
{ 0.8,         -0.1114E+03,  0.1895E+04,  0.5405E+04, -0.2261E+04 } ,
{ 2.521,       -0.3027E+03,  0.7576E+04,  0.1570E+05, -0.4795E+04 } ,
{ 2.625,       -0.3784E+03,  0.1099E+05,  0.1983E+05, -0.6801E+04 } ,
{ 2.867,       -0.1840E+02,  0.1552E+04,  0.7635E+05, -0.8181E+05 } ,
{ 20.0,        -0.2560E+01,  0.7317E+03,  0.9005E+06, -0.5349E+07 } ,
{ 100.0,        0.1540E+01, -0.4834E+03,  0.1021E+07, -0.9300E+07 } ,
{ 500.0,        0.5359E+00,  0.7662E+03,  0.5243E+06,  0.5200E+08 } ,

// 43 - Technetium - Tc - 10

{ 0.01,         0.2680E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.068,       -0.7592E+03,  0.8677E+03, -0.1346E+03,  0.6198E+01 } ,
{ 0.253,       -0.3269E+05,  0.4110E+05, -0.1328E+05,  0.1384E+04 } ,
{ 0.425,       -0.3863E+03,  0.3458E+04,  0.3500E+04, -0.1341E+04 } ,
{ 2.677,       -0.2871E+03,  0.7198E+04,  0.1867E+05, -0.5767E+04 } ,
{ 2.793,       -0.1101E+03,  0.1635E+05,  0.3183E+04, -0.1491E+04 } ,
{ 3.043,       -0.2936E+02,  0.1924E+04,  0.7955E+05, -0.8669E+05 } ,
{ 21.044,       0.5721E+00,  0.7164E+02,  0.1004E+07, -0.6678E+07 } ,
{ 100.0,        0.1769E+01, -0.5691E+03,  0.1097E+07, -0.1069E+08 } ,
{ 500.0,        0.5748E+00,  0.8119E+03,  0.6113E+06,  0.3605E+08 } ,

// 44 - Ruthenium - Ru - 10

{ 0.01,         0.2116E+04,  0.1001E+03, -0.2614E+01,  0.1466E-01 } ,
{ 0.0716,       0.1947E+03,  0.7270E+03, -0.1490E+03,  0.8002E+01 } ,
{ 0.2794,      -0.2141E+05,  0.2872E+05, -0.8592E+04,  0.8312E+03 } ,
{ 0.4606,      -0.2430E+01,  0.2793E+04,  0.5237E+04, -0.2042E+04 } ,
{ 2.838,       -0.2831E+03,  0.7880E+04,  0.1913E+05, -0.6518E+04 } ,
{ 2.967,       -0.3547E+03,  0.1093E+05,  0.2575E+05, -0.9586E+04 } ,
{ 3.224,       -0.1311E+02,  0.1428E+04,  0.9237E+05, -0.1148E+06 } ,
{ 22.117,       0.1007E-01,  0.1277E+03,  0.1086E+07, -0.7755E+07 } ,
{ 100.0,        0.1633E+01, -0.4030E+03,  0.1144E+07, -0.9817E+07 } ,
{ 500.0,        0.6218E+00,  0.9117E+03,  0.5873E+06,  0.6614E+08 } ,

// 45 - Rhodium - Rh - 10

{ 0.01,         0.2535E+04,  0.1329E+03, -0.3193E+01,  0.1648E-01 } ,
{ 0.072,       -0.1037E+04,  0.1357E+04, -0.2412E+03,  0.1212E+02 } ,
{ 0.307,        0.1155E+04,  0.3456E+04,  0.8529E+03, -0.3075E+03 } ,
{ 0.4962,      -0.4773E+03,  0.3678E+04,  0.5261E+04, -0.2225E+04 } ,
{ 3.004,       -0.2665E+03,  0.7197E+04,  0.2390E+05, -0.7946E+04 } ,
{ 3.146,       -0.3285E+03,  0.9342E+04,  0.3454E+05, -0.1203E+05 } ,
{ 3.412,       -0.2532E+02,  0.2009E+04,  0.9447E+05, -0.1115E+06 } ,
{ 23.220,      -0.3043E+01,  0.9079E+03,  0.1126E+07, -0.8086E+07 } ,
{ 100.0,        0.1870E+01, -0.4570E+03,  0.1251E+07, -0.1191E+08 } ,
{ 500.0,        0.6726E+00,  0.9644E+03,  0.7281E+06,  0.4409E+08 } ,

// 46 - Palladium - Pd - 10

{ 0.01,         0.1095E+05, -0.2552E+03,  0.1914E+01, -0.3916E-02 } ,
{ 0.07,         0.2418E+04,  0.9664E+02, -0.1050E+03,  0.9047E+01 } ,
{ 0.335,       -0.1605E+05,  0.3107E+05, -0.1240E+05,  0.1658E+04 } ,
{ 0.5315,      -0.4705E+03,  0.3846E+04,  0.5959E+04, -0.2639E+04 } ,
{ 3.174,       -0.2530E+03,  0.7129E+04,  0.2620E+05, -0.9068E+04 } ,
{ 3.33,        -0.3225E+03,  0.1001E+05,  0.3550E+05, -0.1354E+05 } ,
{ 3.605,        0.1642E+02,  0.4603E+03,  0.1181E+06, -0.1737E+06 } ,
{ 24.35,       -0.2888E+01,  0.8714E+03,  0.1203E+07, -0.9306E+07 } ,
{ 100.0,        0.1857E+01, -0.3662E+03,  0.1308E+07, -0.1219E+08 } ,
{ 500.0,        0.7151E+00,  0.1066E+04,  0.7318E+06,  0.6061E+08 } ,

// 47 - Silver - Ag - 10

{ 0.01,         0.1054E+05, -0.1973E+03,  0.1033E+01, -0.6574E-03 } ,
{ 0.086,       -0.4089E+04,  0.3916E+04, -0.8005E+03,  0.4841E+02 } ,
{ 0.367,       -0.2951E+04,  0.6256E+04,  0.1909E+04, -0.8620E+03 } ,
{ 0.5714,      -0.2321E+02,  0.1892E+04,  0.9451E+04, -0.4150E+04 } ,
{ 3.351,       -0.2547E+03,  0.7851E+04,  0.2733E+05, -0.1038E+05 } ,
{ 3.524,       -0.3170E+03,  0.1045E+05,  0.3850E+05, -0.1560E+05 } ,
{ 3.806,       -0.1817E+01,  0.1265E+04,  0.1192E+06, -0.1684E+06 } ,
{ 25.514,      -0.4061E+01,  0.1339E+04,  0.1260E+07, -0.9752E+07 } ,
{ 100.0,        0.2065E+01, -0.4444E+03,  0.1433E+07, -0.1533E+08 } ,
{ 500.0,        0.7734E+00,  0.1157E+04,  0.8006E+06,  0.6214E+08 } ,

// 48 - Cadmium - Cd - 11

{ 0.01,         0.1876E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.03,         0.8550E+04, -0.2785E+03,  0.2021E+01,  0.1032E-01 } ,
{ 0.098,        0.4933E+03,  0.1167E+04, -0.3452E+03,  0.2759E+02 } ,
{ 0.404,        0.2088E+04,  0.3036E+04,  0.1247E+04, -0.2691E+03 } ,
{ 0.6165,       0.7508E+01,  0.2031E+04,  0.1014E+05, -0.4621E+04 } ,
{ 3.537,       -0.2454E+03,  0.8162E+04,  0.2822E+05, -0.1156E+05 } ,
{ 3.727,       -0.2677E+03,  0.8244E+04,  0.4935E+05, -0.1791E+05 } ,
{ 4.018,       -0.2306E+02,  0.2129E+04,  0.1161E+06, -0.1547E+06 } ,
{ 26.711,      -0.8206E+01,  0.2269E+04,  0.1268E+07, -0.9746E+07 } ,
{ 100.0,        0.2254E+01, -0.4904E+03,  0.1506E+07, -0.1642E+08 } ,
{ 500.0,        0.8123E+00,  0.1229E+04,  0.8686E+06,  0.5293E+08 } ,

// 49 - Indium - I - 11

{ 0.01,         0.1702E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.031,        0.2333E+05, -0.1510E+04,  0.3498E+02, -0.2775E+00 } ,
{ 0.103,       -0.4354E+04,  0.4933E+04, -0.1221E+04,  0.9073E+02 } ,
{ 0.443,       -0.2048E+04,  0.9964E+04, -0.2857E+04,  0.7223E+03 } ,
{ 0.702,       -0.1763E+03,  0.3053E+04,  0.9756E+04, -0.4718E+04 } ,
{ 3.73,        -0.2324E+03,  0.7725E+04,  0.3333E+05, -0.1361E+05 } ,
{ 3.938,       -0.2675E+03,  0.8828E+04,  0.5249E+05, -0.2065E+05 } ,
{ 4.238,       -0.2149E+02,  0.2143E+04,  0.1256E+06, -0.1775E+06 } ,
{ 27.94,       -0.2097E+01,  0.1045E+04,  0.1428E+07, -0.1216E+08 } ,
{ 100.0,        0.2233E+01, -0.3526E+03,  0.1578E+07, -0.1747E+08 } ,
{ 500.0,        0.8685E+00,  0.1331E+04,  0.9171E+06,  0.6234E+08 } ,

// 50 - Tin - Sn - 11

{ 0.01,         0.1857E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0318,       0.3071E+05, -0.2069E+04,  0.4886E+02, -0.3894E+00 } ,
{ 0.093,        0.6119E+02,  0.1769E+04, -0.5287E+03,  0.4438E+02 } ,
{ 0.485,        0.2325E+04,  0.2905E+04,  0.1395E+04, -0.1160E+03 } ,
{ 0.714,       -0.8411E+03,  0.7174E+04,  0.3429E+04, -0.1945E+04 } ,
{ 3.929,       -0.2078E+03,  0.6795E+04,  0.3953E+05, -0.1546E+05 } ,
{ 4.156,       -0.2735E+03,  0.1006E+05,  0.5154E+05, -0.2316E+05 } ,
{ 4.465,        0.1409E+02,  0.5245E+03,  0.1554E+06, -0.2738E+06 } ,
{ 29.2,        -0.6053E+01,  0.2152E+04,  0.1430E+07, -0.1218E+08 } ,
{ 100.0,        0.2434E+01, -0.4441E+03,  0.1694E+07, -0.2116E+08 } ,
{ 500.0,        0.9156E+00,  0.1438E+04,  0.9506E+06,  0.6990E+08 } ,

// 51 - Antimony - Sb - 11

{ 0.01,         0.7076E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0304,       0.2538E+05, -0.2014E+04,  0.5518E+02, -0.5093E+00 } ,
{ 0.096,       -0.2763E+04,  0.3809E+04, -0.9187E+03,  0.6404E+02 } ,
{ 0.528,        0.4191E+04,  0.1201E+04,  0.6138E+03,  0.8057E+03 } ,
{ 0.766,        0.9566E+02,  0.1292E+04,  0.1534E+05, -0.8151E+04 } ,
{ 4.132,       -0.2154E+03,  0.7884E+04,  0.3884E+05, -0.1742E+05 } ,
{ 4.381,       -0.2413E+03,  0.8640E+04,  0.6267E+05, -0.2629E+05 } ,
{ 4.698,       -0.2300E+02,  0.2351E+04,  0.1410E+06, -0.2130E+06 } ,
{ 30.491,      -0.9816E+01,  0.3157E+04,  0.1443E+07, -0.1193E+08 } ,
{ 100.0,        0.2470E+01, -0.3671E+03,  0.1779E+07, -0.2260E+08 } ,
{ 500.0,        0.9713E+00,  0.1520E+04,  0.1016E+07,  0.7466E+08 } ,

// 52 - Tellurium - Te - 11

{ 0.01,         0.9416E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0528,      -0.5818E+05,  0.1470E+05, -0.1039E+04,  0.2257E+02 } ,
{ 0.106,       -0.2734E+04,  0.3947E+04, -0.9985E+03,  0.7313E+02 } ,
{ 0.572,       -0.1058E+06,  0.2917E+06, -0.2491E+06,  0.7124E+05 } ,
{ 1.006,       -0.4397E+02,  0.2059E+04,  0.1571E+05, -0.9021E+04 } ,
{ 4.341,       -0.1946E+03,  0.7129E+04,  0.4399E+05, -0.1939E+05 } ,
{ 4.612,       -0.2372E+03,  0.9166E+04,  0.6308E+05, -0.2911E+05 } ,
{ 4.939,        0.1086E+01,  0.1149E+04,  0.1640E+06, -0.2950E+06 } ,
{ 31.814,      -0.3401E+01,  0.1832E+04,  0.1571E+07, -0.1426E+08 } ,
{ 100.0,        0.2389E+01, -0.1733E+03,  0.1798E+07, -0.2273E+08 } ,
{ 500.0,        0.1007E+01,  0.1586E+04,  0.1076E+07,  0.7154E+08 } ,

// 53 - Iodine - I - 12

{ 0.01,         0.7020E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.034,        0.2410E+05, -0.2114E+04,  0.6324E+02, -0.6266E+00 } ,
{ 0.103,       -0.2554E+04,  0.4115E+04, -0.1059E+04,  0.7800E+02 } ,
{ 0.619,       -0.4564E+05,  0.1181E+06, -0.9050E+05,  0.2490E+05 } ,
{ 0.931,        0.1940E+05, -0.1268E+05, -0.1443E+05,  0.1681E+05 } ,
{ 1.072,       -0.1016E+04,  0.1150E+05, -0.8332E+04,  0.1024E+05 } ,
{ 4.557,       -0.1833E+03,  0.6763E+04,  0.5201E+05, -0.2240E+05 } ,
{ 4.852,       -0.2150E+03,  0.8275E+04,  0.7525E+05, -0.3297E+05 } ,
{ 5.188,       -0.2566E+02,  0.2615E+04,  0.1595E+06, -0.2557E+06 } ,
{ 33.17,       -0.3670E+01,  0.1872E+04,  0.1719E+07, -0.1646E+08 } ,
{ 100.0,        0.2225E+01,  0.1829E+03,  0.1881E+07, -0.2157E+08 } ,
{ 500.0,        0.1098E+01,  0.1755E+04,  0.1154E+07,  0.8971E+08 } ,

// 54 - Xenon - Xe - 13          new

// C   0.01,     0.6262E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00,
// C   0.0515,   0.7578E+05, -0.1206E+05,  0.6503E+03, -0.1177E+02,
// C   0.1073,  -0.1456E+04,  0.3607E+04, -0.1050E+04,  0.8562E+02,

{ 0.01,         3.405E+03,  -3.311E+02,   1.048E+01,  -7.987E-02  } ,
{ 0.065,       -4.118E+04,   2.024E+04,  -2.136E+03,   6.490E+01  } ,
{ 0.1073,       7.622E+04,  -2.983E+04,   3.608E+03,  -1.222E+02  } ,
{ 0.180,       -4.086E+02,   2.713E+03,  -8.147E+02,   6.519E+01  } ,
{ 0.672,        0.5494E+05, -0.4316E+05, -0.3353E+05,  0.3122E+05 } ,
{ 0.936,       -0.2422E+05,  0.6454E+05, -0.3914E+05,  0.8599E+04 } ,
{ 1.143,       -0.6606E+03,  0.7269E+04,  0.6119E+04, -0.3383E+04 } ,
{ 4.782,       -0.1565E+03,  0.5749E+04,  0.5985E+05, -0.2396E+05 } ,
{ 5.102,       -0.2236E+03,  0.9444E+04,  0.7463E+05, -0.3742E+05 } ,
{ 5.445,       -0.2010E+02,  0.2400E+04,  0.1720E+06, -0.2977E+06 } ,
{ 34.561,      -0.1622E+01,  0.1830E+04,  0.1780E+07, -0.1721E+08 } ,
{ 100.0,        0.2082E+01,  0.3625E+03,  0.1962E+07, -0.2448E+08 } ,
{ 500.0,        0.1148E+01,  0.1892E+04,  0.1133E+07,  0.1244E+09 } ,

// 55 - Cesium - Cs - 11

{ 0.01,         0.6813E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0704,       0.1642E+06, -0.2922E+05,  0.1724E+04, -0.3361E+02 } ,
{ 0.111,       -0.2400E+04,  0.4936E+04, -0.1531E+04,  0.1354E+03 } ,
{ 0.726,        0.1295E+05, -0.7423E+04, -0.6620E+04,  0.9125E+04 } ,
{ 1.065,        0.6121E+03, -0.1572E+04,  0.2712E+05, -0.1563E+05 } ,
{ 5.012,       -0.8402E+02,  0.2872E+04,  0.7699E+05, -0.1853E+05 } ,
{ 5.36,        -0.2254E+03,  0.1015E+05,  0.7940E+05, -0.4284E+05 } ,
{ 5.713,       -0.1987E+01,  0.1400E+04,  0.2040E+06, -0.4166E+06 } ,
{ 35.985,      -0.4238E+01,  0.2444E+04,  0.1873E+07, -0.1899E+08 } ,
{ 100.0,        0.2278E+01,  0.4044E+03,  0.2085E+07, -0.2635E+08 } ,
{ 500.0,        0.1226E+01,  0.2030E+04,  0.1249E+07,  0.1169E+09 } ,

// 56 - Barium - Ba - 11

{ 0.01,         0.5765E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.1759E+04, -0.2331E+03,  0.9598E+01,  0.3960E-01 } ,
{ 0.09,        -0.4276E+03,  0.2995E+04, -0.9837E+03,  0.8771E+02 } ,
{ 0.78,         0.6154E+04,  0.1190E+04, -0.2858E+03,  0.1593E+04 } ,
{ 1.135,        0.2420E+03, -0.4033E+03,  0.3138E+05, -0.2304E+05 } ,
{ 5.247,       -0.1084E+03,  0.4043E+04,  0.7718E+05, -0.2532E+05 } ,
{ 5.623,       -0.1836E+03,  0.7952E+04,  0.9545E+05, -0.4532E+05 } ,
{ 5.987,        0.8708E+01,  0.7581E+03,  0.2258E+06, -0.5011E+06 } ,
{ 37.441,      -0.5846E+01,  0.3162E+04,  0.1902E+07, -0.1948E+08 } ,
{ 100.0,        0.2590E+01,  0.2297E+03,  0.2236E+07, -0.3193E+08 } ,
{ 500.0,        0.1281E+01,  0.2144E+04,  0.1303E+07,  0.1193E+09 } ,

// 57 - Lantanum - La - 12

{ 0.01,         0.4514E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.04,         0.2741E+05, -0.4218E+04,  0.2117E+03, -0.3183E+01 } ,
{ 0.13,        -0.1231E+04,  0.4053E+04, -0.1329E+04,  0.1203E+03 } ,
{ 0.832,        0.2431E+04,  0.3780E+04,  0.2792E+04, -0.2167E+03 } ,
{ 1.124,       -0.4024E+03,  0.8837E+04,  0.2398E+04, -0.4154E+03 } ,
{ 1.204,       -0.2694E+03,  0.4549E+04,  0.1944E+05, -0.1264E+05 } ,
{ 5.484,       -0.9085E+02,  0.3459E+04,  0.8639E+05, -0.2558E+05 } ,
{ 5.891,       -0.1485E+03,  0.6357E+04,  0.1121E+06, -0.4626E+05 } ,
{ 6.266,       -0.6527E+01,  0.1901E+04,  0.2209E+06, -0.4602E+06 } ,
{ 38.925,      -0.7588E+01,  0.3685E+04,  0.1991E+07, -0.2054E+08 } ,
{ 100.0,        0.2727E+01,  0.3137E+03,  0.2356E+07, -0.3362E+08 } ,
{ 500.0,        0.1365E+01,  0.2298E+04,  0.1393E+07,  0.1220E+09 } ,

// 58 - Cerium - Ce - 13

{ 0.01,         0.1542E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.053,        0.2448E+05, -0.5012E+04,  0.3411E+03, -0.7413E+01 } ,
{ 0.11,        -0.1622E+04,  0.4662E+04, -0.1505E+04,  0.1385E+03 } ,
{ 0.883,        0.5551E+05, -0.1769E+06,  0.2024E+06, -0.7125E+05 } ,
{ 1.185,        0.4656E+04,  0.6580E+04, -0.3256E+04,  0.8079E+03 } ,
{ 1.273,       -0.2828E+03,  0.1019E+05,  0.2005E+04, -0.4180E+03 } ,
{ 1.435,        0.3264E+03, -0.7440E+03,  0.3609E+05,  0.2685E+05 } ,
{ 5.723,       -0.7263E+02,  0.2822E+04,  0.9606E+05, -0.2458E+05 } ,
{ 6.164,       -0.1695E+03,  0.7899E+04,  0.1139E+06, -0.5644E+05 } ,
{ 6.549,        0.1939E+02,  0.3799E+03,  0.2661E+06, -0.6583E+06 } ,
{ 40.443,      -0.1029E+02,  0.4409E+04,  0.2101E+07, -0.2280E+08 } ,
{ 100.0,        0.2723E+01,  0.4916E+03,  0.2494E+07, -0.3595E+08 } ,
{ 500.0,        0.1464E+01,  0.2444E+04,  0.1486E+07,  0.1376E+09 } ,

// 59 - Praseodymium - Pr - 13

{ 0.01,         0.3935E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.04,         0.5885E+02,  0.5060E+02,  0.1142E+02, -0.2858E+00 } ,
{ 0.113,       -0.2475E+04,  0.6072E+04, -0.2077E+04,  0.2099E+03 } ,
{ 0.931,       -0.6489E+04,  0.2485E+05, -0.1060E+05,  0.2589E+04 } ,
{ 1.242,       -0.5349E+03,  0.8049E+04,  0.5499E+04, -0.9313E+03 } ,
{ 1.337,       -0.3829E+03,  0.1003E+05,  0.3437E+04, -0.7202E+03 } ,
{ 1.505,        0.1158E+03,  0.1754E+04,  0.2978E+05, -0.2081E+05 } ,
{ 5.964,       -0.4523E+02,  0.1773E+04,  0.1075E+06, -0.1884E+05 } ,
{ 6.44,        -0.1401E+03,  0.6504E+04,  0.1315E+06, -0.5758E+05 } ,
{ 6.835,        0.8492E+01,  0.8664E+03,  0.2819E+06, -0.7256E+06 } ,
{ 41.991,      -0.9126E+01,  0.4223E+04,  0.2290E+07, -0.2709E+08 } ,
{ 100.0,        0.3207E+01,  0.3424E+03,  0.2697E+07, -0.4123E+08 } ,
{ 500.0,        0.1557E+01,  0.2710E+04,  0.1566E+07,  0.1383E+09 } ,

// 60 - Neodymium - Nd - 12

{ 0.01,         0.2269E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,      -0.1142E+04,  0.4035E+03, -0.1726E+02,  0.2479E+00 } ,
{ 0.117,       -0.4138E+03,  0.3657E+04, -0.1265E+04,  0.1287E+03 } ,
{ 0.978,        0.1241E+05, -0.6608E+04, -0.8545E+04,  0.1174E+05 } ,
{ 1.298,        0.2239E+03,  0.1199E+05, -0.1181E+04,  0.2855E+03 } ,
{ 1.575,       -0.3530E+03,  0.6609E+04,  0.1641E+05, -0.7462E+04 } ,
{ 6.208,       -0.6644E+02,  0.2796E+04,  0.1098E+06, -0.2924E+05 } ,
{ 6.722,       -0.1114E+03,  0.5206E+04,  0.1457E+06, -0.5559E+05 } ,
{ 7.128,        0.8287E+01,  0.9600E+03,  0.2935E+06, -0.7637E+06 } ,
{ 43.569,      -0.9944E+01,  0.4886E+04,  0.2320E+07, -0.2702E+08 } ,
{ 100.0,        0.3820E+01,  0.8492E+02,  0.2868E+07, -0.4750E+08 } ,
{ 500.0,        0.1633E+01,  0.2833E+04,  0.1759E+07,  0.9295E+08 } ,

// 61 - Promethium - Pm - 13

{ 0.01,         0.2285E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.3175E+04, -0.4311E+03,  0.2911E+02, -0.5124E+00 } ,
{ 0.122,       -0.7108E+03,  0.4102E+04, -0.1397E+04,  0.1482E+03 } ,
{ 1.027,       -0.5546E+03,  0.7912E+04,  0.4958E+04, -0.7606E+03 } ,
{ 1.357,       -0.5157E+03,  0.8937E+04,  0.6066E+04, -0.1148E+04 } ,
{ 1.471,       -0.4607E+03,  0.9760E+04,  0.6028E+04, -0.1298E+04 } ,
{ 1.648,       -0.1912E+03,  0.5138E+04,  0.2120E+05, -0.1345E+05 } ,
{ 6.459,       -0.7165E+02,  0.3169E+04,  0.1166E+06, -0.3499E+05 } ,
{ 7.013,       -0.2589E+03,  0.8215E+04, -0.1102E+06,  0.1824E+07 } ,
{ 7.428,       -0.4251E+02,  0.4740E+04,  0.2377E+06, -0.4279E+06 } ,
{ 45.184,       0.9003E-01,  0.2739E+04,  0.2641E+07, -0.3336E+08 } ,
{ 100.0,        0.2857E+01,  0.1090E+04,  0.2888E+07, -0.4432E+08 } ,
{ 500.0,        0.1742E+01,  0.3069E+04,  0.1744E+07,  0.1719E+09 } ,

// 62 - Samarium - Sm - 11

{ 0.01,         0.1754E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.1174E+04,  0.1370E+03, -0.4815E+01,  0.3574E-01 } ,
{ 0.128,       -0.1315E+04,  0.5218E+04, -0.1900E+04,  0.2181E+03 } ,
{ 1.078,       -0.5499E+03,  0.7881E+04,  0.5664E+04, -0.8952E+03 } ,
{ 1.419,       -0.1126E+03,  0.3912E+04,  0.3230E+05, -0.2774E+05 } ,
{ 6.716,       -0.3580E+02,  0.1576E+04,  0.1290E+06, -0.2201E+05 } ,
{ 7.312,       -0.6400E+02,  0.3084E+04,  0.1751E+06, -0.4595E+05 } ,
{ 7.736,        0.7096E+01,  0.1071E+04,  0.3267E+06, -0.9193E+06 } ,
{ 46.834,      -0.1082E+02,  0.5919E+04,  0.2475E+07, -0.2997E+08 } ,
{ 100.0,        0.3844E+01,  0.4077E+03,  0.3137E+07, -0.5576E+08 } ,
{ 500.0,        0.1799E+01,  0.3181E+04,  0.1898E+07,  0.1263E+09 } ,

// 63 - Europium - Eu - 13

{ 0.01,         0.2047E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.4276E+04, -0.4382E+03,  0.2276E+02, -0.3499E+00 } ,
{ 0.134,       -0.4678E+03,  0.4034E+04, -0.1326E+04,  0.1388E+03 } ,
{ 1.131,       -0.5507E+03,  0.7936E+04,  0.6518E+04, -0.1058E+04 } ,
{ 1.481,       -0.4589E+03,  0.1019E+05,  0.5669E+04, -0.1234E+04 } ,
{ 1.614,       -0.4913E+03,  0.8740E+04,  0.1016E+05, -0.2142E+04 } ,
{ 1.8,         -0.2288E+03,  0.5934E+04,  0.2154E+05, -0.1326E+05 } ,
{ 6.977,       -0.2466E+02,  0.1115E+04,  0.1400E+06, -0.1768E+05 } ,
{ 7.618,       -0.6266E+02,  0.3143E+04,  0.1878E+06, -0.5089E+05 } ,
{ 8.052,       -0.4306E+01,  0.2026E+04,  0.3280E+06, -0.9012E+06 } ,
{ 48.519,      -0.7610E+01,  0.5488E+04,  0.2642E+07, -0.3287E+08 } ,
{ 100.0,        0.3783E+01,  0.7655E+03,  0.3245E+07, -0.5731E+08 } ,
{ 500.0,        0.1904E+01,  0.3400E+04,  0.2020E+07,  0.1315E+09 } ,

// 64 - Gadolinium - Gd - 12

{ 0.01,         0.1620E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.1627E+04,  0.8320E+02, -0.5112E+01,  0.7828E-01 } ,
{ 0.14,        -0.2404E+04,  0.7220E+04, -0.2684E+04,  0.2976E+03 } ,
{ 1.185,       -0.5394E+03,  0.7849E+04,  0.7295E+04, -0.1216E+04 } ,
{ 1.544,       -0.4486E+03,  0.1029E+05,  0.6091E+04, -0.1380E+04 } ,
{ 1.688,       -0.4679E+03,  0.9424E+04,  0.9571E+04, -0.2201E+04 } ,
{ 1.881,       -0.3017E+03,  0.6938E+04,  0.1944E+05, -0.1104E+05 } ,
{ 7.243,       -0.5768E+02,  0.2841E+04,  0.1366E+06, -0.4131E+05 } ,
{ 7.93,        -0.3358E+02,  0.1701E+04,  0.2029E+06, -0.3312E+05 } ,
{ 8.375,       -0.8668E+01,  0.2379E+04,  0.3331E+06, -0.9285E+06 } ,
{ 50.239,       0.3209E+01,  0.1579E+04,  0.3144E+07, -0.4804E+08 } ,
{ 500.0,        0.1966E+01,  0.3553E+04,  0.2103E+07,  0.1345E+09 } ,

// 65 - Terbium - Tb - 12

{ 0.01,         0.1879E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.3021E+04, -0.1618E+03,  0.9979E+01, -0.1862E+00 } ,
{ 0.147,       -0.1406E+04,  0.5621E+04, -0.1912E+04,  0.2075E+03 } ,
{ 1.24,        -0.5345E+03,  0.7632E+04,  0.8660E+04, -0.1449E+04 } ,
{ 1.61,        -0.4988E+03,  0.9401E+04,  0.9226E+04, -0.2000E+04 } ,
{ 1.765,       -0.4700E+03,  0.9391E+04,  0.1117E+05, -0.2613E+04 } ,
{ 1.963,       -0.1902E+03,  0.5724E+04,  0.2615E+05, -0.1782E+05 } ,
{ 7.514,       -0.1568E+03,  0.1116E+05,  0.8757E+05, -0.7647E+05 } ,
{ 8.252,       -0.4533E+02,  0.2421E+04,  0.2126E+06, -0.4859E+05 } ,
{ 8.708,       -0.4721E+01,  0.2127E+04,  0.3644E+06, -0.1109E+07 } ,
{ 51.996,       0.3903E+01,  0.1250E+04,  0.3405E+07, -0.5637E+08 } ,
{ 500.0,        0.2077E+01,  0.3763E+04,  0.2261E+07,  0.1155E+09 } ,

// 66 - Dysprosium - Dy - 12

{ 0.01,         0.3294E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.3167E+04, -0.4242E+02,  0.5269E+01, -0.1178E+00 } ,
{ 0.154,       -0.1109E+04,  0.5234E+04, -0.1650E+04,  0.1694E+03 } ,
{ 1.295,       -0.5242E+03,  0.7751E+04,  0.9341E+04, -0.1624E+04 } ,
{ 1.676,       -0.4635E+03,  0.1050E+05,  0.8066E+04, -0.1930E+04 } ,
{ 1.842,       -0.4608E+03,  0.9448E+04,  0.1216E+05, -0.2942E+04 } ,
{ 2.046,       -0.1077E+03,  0.4675E+04,  0.3253E+05, -0.2519E+05 } ,
{ 7.79,        -0.6326E+02,  0.3407E+04,  0.1499E+06, -0.5526E+05 } ,
{ 8.58,        -0.7262E+02,  0.4176E+04,  0.2130E+06, -0.8026E+05 } ,
{ 9.046,       -0.1800E+02,  0.3374E+04,  0.3526E+06, -0.9982E+06 } ,
{ 53.788,       0.4112E+01,  0.1344E+04,  0.3520E+07, -0.5867E+08 } ,
{ 500.0,        0.2166E+01,  0.3928E+04,  0.2396E+07,  0.1007E+09 } ,

// 67 - Holmium - Ho - 12

{ 0.01,         0.1647E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0426,       0.2949E+04, -0.5473E+02, -0.1313E+01,  0.5447E-01 } ,
{ 0.161,       -0.1961E+04,  0.6859E+04, -0.2353E+04,  0.2538E+03 } ,
{ 1.351,       -0.5221E+03,  0.8169E+04,  0.9852E+04, -0.1807E+04 } ,
{ 1.743,       -0.4878E+03,  0.9589E+04,  0.1119E+05, -0.2580E+04 } ,
{ 1.923,       -0.4549E+03,  0.9349E+04,  0.1378E+05, -0.3393E+04 } ,
{ 2.13,        -0.1379E+03,  0.5032E+04,  0.3428E+05, -0.2787E+05 } ,
{ 8.072,       -0.4939E+02,  0.2705E+04,  0.1628E+06, -0.5056E+05 } ,
{ 8.918,       -0.4426E+02,  0.2555E+04,  0.2349E+06, -0.5948E+05 } ,
{ 9.394,       -0.2988E+01,  0.2094E+04,  0.4072E+06, -0.1335E+07 } ,
{ 55.618,       0.5131E+01,  0.5023E+03,  0.4000E+07, -0.7974E+08 } ,
{ 500.0,        0.2274E+01,  0.4258E+04,  0.2387E+07,  0.1450E+09 } ,

// 68 - Erbium - Er - 12

{ 0.01,         0.2419E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0322,       0.3178E+04, -0.8940E+02,  0.5741E+01, -0.1173E+00 } ,
{ 0.169,       -0.1598E+04,  0.6371E+04, -0.2015E+04,  0.1951E+03 } ,
{ 1.409,       -0.5148E+03,  0.8464E+04,  0.1038E+05, -0.1998E+04 } ,
{ 1.812,       -0.4781E+03,  0.8546E+04,  0.1463E+05, -0.3195E+04 } ,
{ 2.006,       -0.4470E+03,  0.9490E+04,  0.1489E+05, -0.3799E+04 } ,
{ 2.217,       -0.2279E+03,  0.6501E+04,  0.3083E+05, -0.2363E+05 } ,
{ 8.358,       -0.5162E+02,  0.2947E+04,  0.1710E+06, -0.5828E+05 } ,
{ 9.264,       -0.5360E+02,  0.3254E+04,  0.2449E+06, -0.7821E+05 } ,
{ 9.752,        0.6456E+01,  0.1211E+04,  0.4583E+06, -0.1684E+07 } ,
{ 57.486,       0.4025E+01,  0.2031E+04,  0.3795E+07, -0.6651E+08 } ,
{ 500.0,        0.2386E+01,  0.4497E+04,  0.2558E+07,  0.1403E+09 } ,

// 69 - Thulium - Tm - 10

{ 0.01,         0.1729E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.031,        0.5004E+04, -0.3383E+03,  0.1358E+02, -0.1932E+00 } ,
{ 0.18,        -0.1721E+04,  0.6821E+04, -0.2191E+04,  0.2162E+03 } ,
{ 1.468,       -0.5074E+03,  0.8420E+04,  0.1161E+05, -0.2277E+04 } ,
{ 1.881,        0.4504E+03, -0.4717E+04,  0.9421E+05, -0.1104E+06 } ,
{ 8.648,       -0.5189E+02,  0.3077E+04,  0.1808E+06, -0.6499E+05 } ,
{ 9.617,       -0.5311E+02,  0.3348E+04,  0.2598E+06, -0.8657E+05 } ,
{ 10.116,      -0.3887E+01,  0.2132E+04,  0.4637E+06, -0.1723E+07 } ,
{ 59.39,        0.4124E+01,  0.2299E+04,  0.3956E+07, -0.7043E+08 } ,
{ 500.0,        0.2512E+01,  0.4774E+04,  0.2690E+07,  0.1454E+09 } ,

// 70 - Ytterbium - Yb - 10

{ 0.01,         0.2440E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.075,        0.5923E+04, -0.5235E+03,  0.2450E+02, -0.3644E+00 } ,
{ 0.185,       -0.1402E+04,  0.6524E+04, -0.1996E+04,  0.1849E+03 } ,
{ 1.528,       -0.4649E+03,  0.1046E+05,  0.8110E+04, -0.1884E+04 } ,
{ 1.95,         0.3077E+03, -0.2145E+04,  0.8374E+05, -0.9504E+05 } ,
{ 8.943,       -0.5328E+02,  0.3291E+04,  0.1869E+06, -0.7332E+05 } ,
{ 9.978,       -0.7311E+02,  0.4929E+04,  0.2602E+06, -0.1239E+06 } ,
{ 10.489,      -0.2434E+02,  0.4269E+04,  0.4243E+06, -0.1379E+07 } ,
{ 61.332,       0.4575E+01,  0.2312E+04,  0.4086E+07, -0.7562E+08 } ,
{ 500.0,        0.2606E+01,  0.4980E+04,  0.2895E+07,  0.9923E+08 } ,

// 71 - Lutetium - Lu - 10

{ 0.01,         0.2123E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.09,         0.8368E+04, -0.1105E+04,  0.5971E+02, -0.9746E+00 } ,
{ 0.195,       -0.1536E+04,  0.7063E+04, -0.2291E+04,  0.2250E+03 } ,
{ 1.588,       -0.4936E+03,  0.9095E+04,  0.1255E+05, -0.2717E+04 } ,
{ 2.024,        0.2304E+03, -0.1379E+04,  0.8594E+05, -0.1012E+06 } ,
{ 9.245,       -0.5213E+02,  0.3333E+04,  0.1974E+06, -0.7977E+05 } ,
{ 10.349,      -0.5333E+02,  0.3627E+04,  0.2858E+06, -0.1071E+06 } ,
{ 10.874,       0.3726E+01,  0.1486E+04,  0.5352E+06, -0.2222E+07 } ,
{ 63.316,       0.5266E+01,  0.2137E+04,  0.4329E+07, -0.8327E+08 } ,
{ 500.0,        0.2736E+01,  0.5209E+04,  0.3153E+07,  0.5239E+08 } ,

// 72 - Hafnium - Hf - 10

{ 0.01,         0.5463E+04, -0.2212E+03,  0.3566E+01, -0.1819E-01 } ,
{ 0.0512,       0.9488E+04, -0.1416E+04,  0.8076E+02, -0.1382E+01 } ,
{ 0.213,       -0.1796E+04,  0.7903E+04, -0.2748E+04,  0.2932E+03 } ,
{ 1.662,       -0.4835E+03,  0.9549E+04,  0.1284E+05, -0.2957E+04 } ,
{ 2.108,        0.3480E+03, -0.3031E+04,  0.9762E+05, -0.1203E+06 } ,
{ 9.56,        -0.6090E+02,  0.4112E+04,  0.2015E+06, -0.9934E+05 } ,
{ 10.739,      -0.7386E+02,  0.5387E+04,  0.2859E+06, -0.1536E+06 } ,
{ 11.272,      -0.1873E+02,  0.4102E+04,  0.4698E+06, -0.1572E+07 } ,
{ 65.345,       0.4753E+01,  0.2673E+04,  0.4462E+07, -0.8960E+08 } ,
{ 500.0,        0.2845E+01,  0.5554E+04,  0.3013E+07,  0.1535E+09 } ,

// 73 - Tantalum - Ta - 11

{ 0.01,        -0.9358E+04,  0.4382E+03, -0.5661E+01,  0.2301E-01 } ,
{ 0.0233,       0.3537E+05, -0.2591E+04,  0.6585E+02, -0.5643E+00 } ,
{ 0.0428,       0.9080E+04, -0.1376E+04,  0.8354E+02, -0.1487E+01 } ,
{ 0.229,       -0.1944E+04,  0.8490E+04, -0.3040E+04,  0.3330E+03 } ,
{ 1.735,       -0.4771E+03,  0.1003E+05,  0.1338E+05, -0.3254E+04 } ,
{ 2.194,        0.1047E+03,  0.6524E+03,  0.8380E+05, -0.1025E+06 } ,
{ 9.880,       -0.5521E+02,  0.3828E+04,  0.2145E+06, -0.1019E+06 } ,
{ 11.136,      -0.4987E+02,  0.3641E+04,  0.3160E+06, -0.1250E+06 } ,
{ 11.68,       -0.2176E+01,  0.2172E+04,  0.5708E+06, -0.2482E+07 } ,
{ 67.416,       0.5194E+01,  0.2794E+04,  0.4645E+07, -0.9648E+08 } ,
{ 500.0,        0.2973E+01,  0.5785E+04,  0.3320E+07,  0.9608E+08 } ,

// 74 - Tungsten - W - 11

{ 0.01,        -0.2084E+04,  0.1834E+03, -0.2686E+01,  0.1131E-01 } ,
{ 0.031,       -0.1398E+05,  0.2451E+04, -0.1057E+03,  0.1381E+01 } ,
{ 0.0493,       0.9985E+04, -0.1816E+04,  0.1301E+03, -0.2747E+01 } ,
{ 0.245,       -0.1825E+04,  0.8623E+04, -0.3114E+04,  0.3432E+03 } ,
{ 1.809,       -0.4666E+03,  0.1057E+05,  0.1355E+05, -0.3503E+04 } ,
{ 2.281,        0.1412E+03,  0.2762E+03,  0.8940E+05, -0.1129E+06 } ,
{ 10.204,      -0.6206E+02,  0.4525E+04,  0.2194E+06, -0.1223E+06 } ,
{ 11.541,      -0.1211E+03,  0.1058E+05,  0.2701E+06, -0.2556E+06 } ,
{ 12.098,      -0.2105E+02,  0.4623E+04,  0.5109E+06, -0.1835E+07 } ,
{ 69.525,       0.5276E+01,  0.2999E+04,  0.4828E+07, -0.1030E+09 } ,
{ 500.0,        0.3099E+01,  0.6112E+04,  0.3348E+07,  0.1310E+09 } ,

// 75 - Rhenium - Re - 10

{ 0.01,        -0.5759E+04,  0.4019E+03, -0.6479E+01,  0.3113E-01 } ,
{ 0.0384,       0.1235E+05, -0.2571E+04,  0.1879E+03, -0.4072E+01 } ,
{ 0.26,        -0.1846E+04,  0.9196E+04, -0.3553E+04,  0.4261E+03 } ,
{ 1.883,       -0.4438E+03,  0.1148E+05,  0.1253E+05, -0.3520E+04 } ,
{ 2.368,        0.1961E+03, -0.3585E+03,  0.9550E+05, -0.1180E+06 } ,
{ 10.534,      -0.5721E+02,  0.4284E+04,  0.2331E+06, -0.1270E+06 } ,
{ 11.957,      -0.1192E+03,  0.1081E+05,  0.2828E+06, -0.2788E+06 } ,
{ 12.528,      -0.8548E+01,  0.3122E+04,  0.5972E+06, -0.2571E+07 } ,
{ 71.676,       0.4901E+01,  0.3621E+04,  0.4969E+07, -0.1085E+09 } ,
{ 500.0,        0.3238E+01,  0.6600E+04,  0.3237E+07,  0.2204E+09 } ,

// 76 - Osmium - Os - 10

{ 0.01,         0.5189E+03,  0.1085E+03, -0.2362E+01,  0.1285E-01 } ,
{ 0.0464,       0.9943E+04, -0.1964E+04,  0.1499E+03, -0.3533E+01 } ,
{ 0.272,       -0.1915E+04,  0.9625E+04, -0.3819E+04,  0.4641E+03 } ,
{ 1.96,        -0.4312E+03,  0.1174E+05,  0.1298E+05, -0.3813E+04 } ,
{ 2.457,       -0.7620E+02,  0.3809E+04,  0.8189E+05, -0.1090E+06 } ,
{ 10.871,      -0.5946E+02,  0.4643E+04,  0.2401E+06, -0.1434E+06 } ,
{ 12.385,      -0.1116E+03,  0.1035E+05,  0.3012E+06, -0.2961E+06 } ,
{ 12.969,      -0.1803E+02,  0.4548E+04,  0.5700E+06, -0.2246E+07 } ,
{ 73.871,       0.5735E+01,  0.3318E+04,  0.5232E+07, -0.1209E+09 } ,
{ 500.0,        0.3351E+01,  0.6829E+04,  0.3509E+07,  0.1607E+09 } ,

// 77 - Iridium - Ir - 10

{ 0.01,        -0.9441E+02,  0.1284E+03, -0.2563E+01,  0.1347E-01 } ,
{ 0.048,        0.9926E+04, -0.2049E+04,  0.1630E+03, -0.4025E+01 } ,
{ 0.295,       -0.2391E+04,  0.1087E+05, -0.4456E+04,  0.5612E+03 } ,
{ 2.04,        -0.4371E+03,  0.1150E+05,  0.1539E+05, -0.4560E+04 } ,
{ 2.551,        0.1540E+03, -0.7160E+03,  0.1147E+06, -0.1673E+06 } ,
{ 11.215,      -0.5153E+02,  0.4097E+04,  0.2582E+06, -0.1419E+06 } ,
{ 12.824,      -0.1366E+03,  0.1456E+05,  0.2707E+06, -0.3461E+06 } ,
{ 13.419,      -0.1995E+02,  0.4906E+04,  0.6064E+06, -0.2648E+07 } ,
{ 76.111,       0.6213E+01,  0.3458E+04,  0.5442E+07, -0.1286E+09 } ,
{ 500.0,        0.3505E+01,  0.7126E+04,  0.3805E+07,  0.1114E+09 } ,

// 78 - Platinum - Pt - 11

{ 0.01,         0.1220E+05, -0.3768E+03,  0.4167E+01, -0.1564E-01 } ,
{ 0.0226,       0.1396E+05, -0.1184E+04,  0.3650E+02, -0.3548E+00 } ,
{ 0.0735,       0.1172E+05, -0.2752E+04,  0.2212E+03, -0.4579E+01 } ,
{ 0.313,       -0.2373E+04,  0.1129E+05, -0.4739E+04,  0.6166E+03 } ,
{ 2.122,       -0.4333E+03,  0.1147E+05,  0.1710E+05, -0.5181E+04 } ,
{ 2.645,       -0.7755E+02,  0.2847E+04,  0.1047E+06, -0.1599E+06 } ,
{ 11.564,      -0.6719E+02,  0.5737E+04,  0.2565E+06, -0.1880E+06 } ,
{ 13.273,      -0.1399E+03,  0.1605E+05,  0.2671E+06, -0.3742E+06 } ,
{ 13.88,        0.1076E+02,  0.9617E+03,  0.7776E+06, -0.4207E+07 } ,
{ 78.395,       0.6088E+01,  0.4001E+04,  0.5552E+07, -0.1300E+09 } ,
{ 500.0,        0.3646E+01,  0.7453E+04,  0.3931E+07,  0.1226E+09 } ,

// 79 - Gold - Au - 10

{ 0.01,         0.4105E+04,  0.2410E+02, -0.1837E+01,  0.1252E-01 } ,
{ 0.07,         0.1581E+05, -0.4931E+04,  0.5197E+03, -0.1622E+02 } ,
{ 0.334,       -0.2231E+04,  0.1142E+05, -0.4781E+04,  0.6012E+03 } ,
{ 2.206,       -0.4203E+03,  0.1212E+05,  0.1690E+05, -0.5448E+04 } ,
{ 2.743,        0.1443E+03, -0.4096E+03,  0.1249E+06, -0.1944E+06 } ,
{ 11.919,      -0.8194E+02,  0.7574E+04,  0.2506E+06, -0.2318E+06 } ,
{ 13.734,      -0.1134E+03,  0.1194E+05,  0.3355E+06, -0.3921E+06 } ,
{ 14.353,      -0.3392E+01,  0.3070E+04,  0.7247E+06, -0.3499E+07 } ,
{ 80.725,       0.7917E+01,  0.2918E+04,  0.6095E+07, -0.1596E+09 } ,
{ 500.0,        0.3811E+01,  0.7846E+04,  0.4248E+07,  0.4571E+08 } ,

// 80 - Mercury - Hg - 10

{ 0.01,         0.5142E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.09,         0.1780E+05, -0.5970E+04,  0.6765E+03, -0.2176E+02 } ,
{ 0.36,        -0.2317E+04,  0.1206E+05, -0.5219E+04,  0.7004E+03 } ,
{ 2.295,       -0.3961E+03,  0.1286E+05,  0.1582E+05, -0.5482E+04 } ,
{ 2.847,        0.2241E+03, -0.2195E+04,  0.1429E+06, -0.2325E+06 } ,
{ 12.283,      -0.7533E+02,  0.7084E+04,  0.2675E+06, -0.2412E+06 } ,
{ 14.209,      -0.1288E+03,  0.1524E+05,  0.3090E+06, -0.4397E+06 } ,
{ 14.842,       0.4681E+00,  0.2405E+04,  0.7958E+06, -0.4232E+07 } ,
{ 83.102,       0.6983E+01,  0.4309E+04,  0.5980E+07, -0.1518E+09 } ,
{ 500.0,        0.3946E+01,  0.8311E+04,  0.4256E+07,  0.8942E+08 } ,

// 81 - Thallium - Tl - 11

{ 0.01,         0.1823E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0313,      -0.1010E+05,  0.1911E+04, -0.7721E+02,  0.9111E+00 } ,
{ 0.0985,       0.1488E+05, -0.4878E+04,  0.5536E+03, -0.1923E+02 } ,
{ 0.386,       -0.2399E+04,  0.1271E+05, -0.5745E+04,  0.7873E+03 } ,
{ 2.389,       -0.4087E+03,  0.1156E+05,  0.2169E+05, -0.7188E+04 } ,
{ 2.956,        0.1551E+03, -0.9040E+03,  0.1404E+06, -0.2314E+06 } ,
{ 12.656,      -0.6647E+02,  0.6324E+04,  0.2871E+06, -0.2439E+06 } ,
{ 14.697,      -0.1405E+03,  0.2137E+05,  0.2340E+06, -0.4290E+06 } ,
{ 15.346,      -0.1053E+02,  0.4195E+04,  0.7543E+06, -0.3747E+07 } ,
{ 85.53,        0.7684E+01,  0.4048E+04,  0.6314E+07, -0.1714E+09 } ,
{ 500.0,        0.4082E+01,  0.8543E+04,  0.4521E+07,  0.5178E+08 } ,

// 82 - Lead - Pb - 11

{ 0.01,         0.1569E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0311,      -0.9651E+04,  0.1870E+04, -0.7761E+02,  0.9425E+00 } ,
{ 0.095,        0.1609E+05, -0.5855E+04,  0.7149E+03, -0.2672E+02 } ,
{ 0.413,       -0.2194E+04,  0.1239E+05, -0.5418E+04,  0.6794E+03 } ,
{ 2.484,       -0.4016E+03,  0.1173E+05,  0.2316E+05, -0.7955E+04 } ,
{ 3.066,        0.6749E+02,  0.6789E+03,  0.1401E+06, -0.2437E+06 } ,
{ 13.035,      -0.7125E+02,  0.7126E+04,  0.2931E+06, -0.2779E+06 } ,
{ 15.2,        -0.1363E+03,  0.1992E+05,  0.2721E+06, -0.4887E+06 } ,
{ 15.861,      -0.8206E+01,  0.4058E+04,  0.7950E+06, -0.4115E+07 } ,
{ 88.004,       0.7595E+01,  0.4692E+04,  0.6429E+07, -0.1747E+09 } ,
{ 500.0,        0.4240E+01,  0.8883E+04,  0.4754E+07,  0.3448E+08 } ,

// 83 - Bismuth - Bi - 13

{ 0.01,        -0.4395E+03,  0.1185E+02,  0.2207E+00, -0.1865E-02 } ,
{ 0.024,        0.4586E+04, -0.1052E+03, -0.2706E+01,  0.7877E-01 } ,
{ 0.026,        0.1118E+05, -0.3159E+03, -0.9250E+01,  0.2918E+00 } ,
{ 0.0379,      -0.1578E+05,  0.3450E+04, -0.1741E+03,  0.2596E+01 } ,
{ 0.1136,       0.2124E+05, -0.8884E+04,  0.1240E+04, -0.5312E+02 } ,
{ 0.362,       -0.1835E+04,  0.1188E+05, -0.5123E+04,  0.6229E+03 } ,
{ 2.581,       -0.3943E+03,  0.1129E+05,  0.2671E+05, -0.9164E+04 } ,
{ 3.177,        0.2402E+03, -0.2657E+04,  0.1637E+06, -0.2867E+06 } ,
{ 13.42,       -0.6824E+02,  0.7005E+04,  0.3089E+06, -0.2951E+06 } ,
{ 15.714,      -0.1337E+03,  0.1999E+05,  0.2903E+06, -0.5342E+06 } ,
{ 16.391,      -0.1411E+01,  0.3094E+04,  0.8901E+06, -0.5203E+07 } ,
{ 90.526,       0.9935E+01,  0.3289E+04,  0.6983E+07, -0.2020E+09 } ,
{ 500.0,        0.4425E+01,  0.9396E+04,  0.5008E+07, -0.5280E+08 } ,

// 84 - Polonium - Po - 11

{ 0.01,         0.1109E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.1939E+05, -0.1380E+04,  0.3526E+02, -0.3106E+00 } ,
{ 0.07,         0.9152E+04, -0.3829E+04,  0.5535E+03, -0.2106E+02 } ,
{ 0.2415,      -0.1131E+04,  0.1041E+05, -0.4126E+04,  0.4235E+03 } ,
{ 2.683,       -0.3899E+03,  0.1134E+05,  0.2963E+05, -0.1038E+05 } ,
{ 3.302,        0.4918E+03, -0.1053E+05,  0.2383E+06, -0.4647E+06 } ,
{ 13.814,      -0.7471E+02,  0.8106E+04,  0.3143E+06, -0.3397E+06 } ,
{ 16.244,      -0.1335E+03,  0.2199E+05,  0.2786E+06, -0.5569E+06 } ,
{ 16.936,       0.7789E+01,  0.1767E+04,  0.1003E+07, -0.6443E+07 } ,
{ 93.105,       0.8525E+01,  0.5102E+04,  0.6990E+07, -0.2009E+09 } ,
{ 500.0,        0.4633E+01,  0.9868E+04,  0.5142E+07,  0.1775E+08 } ,

// 85 - Astatine - At - 11

{ 0.01,         0.5224E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0305,       0.2744E+05, -0.2310E+04,  0.6658E+02, -0.6458E+00 } ,
{ 0.072,        0.6422E+04, -0.2954E+04,  0.4933E+03, -0.2019E+02 } ,
{ 0.244,       -0.1933E+04,  0.1303E+05, -0.5806E+04,  0.6870E+03 } ,
{ 2.787,       -0.3889E+03,  0.1171E+05,  0.3195E+05, -0.1160E+05 } ,
{ 3.426,        0.3129E+03, -0.6378E+04,  0.2158E+06, -0.4073E+06 } ,
{ 14.214,      -0.6880E+02,  0.7565E+04,  0.3411E+06, -0.3547E+06 } ,
{ 16.785,      -0.1280E+03,  0.1941E+05,  0.3508E+06, -0.6556E+06 } ,
{ 17.491,      -0.1695E+01,  0.3621E+04,  0.9663E+06, -0.5746E+07 } ,
{ 95.73,        0.9913E+01,  0.4822E+04,  0.7370E+07, -0.2163E+09 } ,
{ 500.0,        0.4871E+01,  0.1062E+05,  0.5352E+07, -0.2702E+08 } ,

// 86 - Radon - Rn - 11

{ 0.01,         0.1284E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0466,      -0.7912E+03,  0.2111E+04, -0.1709E+03,  0.3589E+01 } ,
{ 0.093,        0.1243E+05, -0.6150E+04,  0.1021E+04, -0.4644E+02 } ,
{ 0.305,       -0.1804E+04,  0.1279E+05, -0.5624E+04,  0.6228E+03 } ,
{ 2.892,       -0.3616E+03,  0.1088E+05,  0.3423E+05, -0.1248E+05 } ,
{ 3.538,        0.1691E+03, -0.2424E+04,  0.1954E+06, -0.4008E+06 } ,
{ 14.619,      -0.6756E+02,  0.7739E+04,  0.3363E+06, -0.3748E+06 } ,
{ 17.337,      -0.1220E+03,  0.1976E+05,  0.3335E+06, -0.6657E+06 } ,
{ 18.055,      -0.5899E+00,  0.3312E+04,  0.9833E+06, -0.6258E+07 } ,
{ 98.404,       0.8633E+01,  0.5888E+04,  0.7122E+07, -0.2120E+09 } ,
{ 500.0,        0.4841E+01,  0.1057E+05,  0.5286E+07,  0.1022E+08 } ,

// 87 - Francium - Fr - 11

{ 0.01,         0.1287E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0494,      -0.9129E+04,  0.3064E+04, -0.1840E+03,  0.2869E+01 } ,
{ 0.196,        0.1217E+05, -0.1865E+04, -0.1031E+04,  0.1980E+03 } ,
{ 0.525,       -0.2201E+04,  0.1461E+05, -0.7082E+04,  0.9132E+03 } ,
{ 3.0,         -0.3615E+03,  0.1150E+05,  0.3541E+05, -0.1363E+05 } ,
{ 3.664,       -0.5769E+03,  0.1660E+05,  0.5526E+05, -0.7044E+05 } ,
{ 15.03,       -0.6236E+02,  0.7249E+04,  0.3612E+06, -0.3893E+06 } ,
{ 17.904,      -0.1213E+03,  0.2052E+05,  0.3455E+06, -0.7195E+06 } ,
{ 18.639,      -0.8453E+01,  0.4660E+04,  0.9757E+06, -0.6010E+07 } ,
{ 101.137,      0.1104E+02,  0.4630E+04,  0.7706E+07, -0.2445E+09 } ,
{ 500.0,        0.5063E+01,  0.1115E+05,  0.5666E+07, -0.1082E+09 } ,

// 88 - Radium - Ra - 11

{ 0.01,         0.1415E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0579,      -0.3003E+05,  0.8875E+04, -0.6798E+03,  0.1571E+02 } ,
{ 0.15,         0.2941E+05, -0.1786E+05,  0.3591E+04, -0.2242E+03 } ,
{ 0.396,       -0.1852E+04,  0.1361E+05, -0.6123E+04,  0.6294E+03 } ,
{ 3.109,       -0.3547E+03,  0.1164E+05,  0.3753E+05, -0.1492E+05 } ,
{ 3.791,        0.2933E+03, -0.6829E+04,  0.2528E+06, -0.5565E+06 } ,
{ 15.446,      -0.6085E+02,  0.7287E+04,  0.3762E+06, -0.4161E+06 } ,
{ 18.484,      -0.1192E+03,  0.2119E+05,  0.3500E+06, -0.7644E+06 } ,
{ 19.237,      -0.1024E+02,  0.5310E+04,  0.9756E+06, -0.5773E+07 } ,
{ 103.922,      0.1241E+02,  0.3727E+04,  0.8307E+07, -0.2833E+09 } ,
{ 500.0,        0.5221E+01,  0.1168E+05,  0.5739E+07, -0.9046E+08 } ,

// 89 - Actinium - Ac - 11

{ 0.01,         0.1258E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0712,      -0.2747E+04,  0.3975E+03,  0.1941E+03, -0.1439E+02 } ,
{ 0.216,        0.1958E+05, -0.9878E+04,  0.1388E+04, -0.1778E+02 } ,
{ 0.375,       -0.2098E+04,  0.1506E+05, -0.7581E+04,  0.9825E+03 } ,
{ 3.219,       -0.3474E+03,  0.1153E+05,  0.4113E+05, -0.1657E+05 } ,
{ 3.909,        0.5789E+03, -0.1507E+05,  0.3328E+06, -0.7718E+06 } ,
{ 15.87,       -0.6339E+02,  0.7915E+04,  0.3884E+06, -0.4637E+06 } ,
{ 19.083,      -0.1182E+03,  0.2194E+05,  0.3621E+06, -0.8244E+06 } ,
{ 19.845,       0.8142E+01,  0.2287E+04,  0.1185E+07, -0.8493E+07 } ,
{ 106.759,      0.1003E+02,  0.6690E+04,  0.7961E+07, -0.2545E+09 } ,
{ 500.0,        0.5479E+01,  0.1217E+05,  0.5897E+07, -0.2287E+08 } ,

// 90 - Thorium - Th - 10

{ 0.01,         0.1134E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0879,       0.1398E+05, -0.6113E+04,  0.8572E+03, -0.2963E+02 } ,
{ 0.676,       -0.1466E+04,  0.1349E+05, -0.6743E+04,  0.1013E+04 } ,
{ 3.332,       -0.3308E+03,  0.1094E+05,  0.4517E+05, -0.1812E+05 } ,
{ 4.046,        0.2265E+03, -0.3796E+04,  0.2424E+06, -0.5526E+06 } ,
{ 16.3,        -0.5998E+02,  0.7669E+04,  0.4039E+06, -0.4843E+06 } ,
{ 19.693,      -0.1152E+03,  0.2229E+05,  0.3694E+06, -0.8743E+06 } ,
{ 20.466,      -0.1965E+02,  0.7238E+04,  0.9916E+06, -0.5869E+07 } ,
{ 109.651,      0.1150E+02,  0.6085E+04,  0.8292E+07, -0.2758E+09 } ,
{ 500.0,        0.5620E+01,  0.1245E+05,  0.6338E+07, -0.1549E+09 } ,

// 91 - Protactinium - Pa - 10

{ 0.01,         0.2194E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.094,        0.8794E+04, -0.2841E+04,  0.2038E+03,  0.1370E+02 } ,
{ 0.371,       -0.2042E+04,  0.1581E+05, -0.8451E+04,  0.1211E+04 } ,
{ 3.442,       -0.3240E+03,  0.1078E+05,  0.5022E+05, -0.2015E+05 } ,
{ 4.174,        0.1921E+04, -0.5267E+05,  0.6573E+06, -0.1562E+07 } ,
{ 16.733,      -0.6436E+02,  0.8617E+04,  0.4180E+06, -0.5495E+06 } ,
{ 20.314,      -0.1129E+03,  0.2138E+05,  0.4231E+06, -0.9875E+06 } ,
{ 21.105,       0.1526E+02,  0.1356E+04,  0.1351E+07, -0.1082E+08 } ,
{ 112.601,      0.1254E+02,  0.5894E+04,  0.8877E+07, -0.3120E+09 } ,
{ 500.0,        0.5918E+01,  0.1306E+05,  0.6683E+07, -0.1778E+09 } ,

// 92 - Uranium - U - 11

{ 0.01,         0.4400E+04, -0.1564E+03,  0.2241E+01, -0.1062E-01 } ,
{ 0.0171,      -0.2175E+04,  0.4327E+03, -0.1164E+02,  0.8742E-01 } ,
{ 0.0963,       0.1528E+05, -0.7106E+04,  0.1060E+04, -0.4036E+02 } ,
{ 0.617,       -0.1807E+04,  0.1483E+05, -0.7405E+04,  0.8426E+03 } ,
{ 3.552,       -0.3148E+03,  0.1094E+05,  0.5041E+05, -0.2121E+05 } ,
{ 4.304,       -0.1100E+03,  0.4889E+04,  0.1908E+06, -0.4810E+06 } ,
{ 17.17,       -0.6720E+02,  0.9489E+04,  0.4107E+06, -0.6000E+06 } ,
{ 20.948,      -0.1033E+03,  0.1864E+05,  0.4878E+06, -0.1076E+07 } ,
{ 21.759,       0.6281E+00,  0.3792E+04,  0.1281E+07, -0.1003E+08 } ,
{ 115.606,      0.1146E+02,  0.7568E+04,  0.8699E+07, -0.3106E+09 } ,
{ 500.0,        0.6017E+01,  0.1327E+05,  0.7079E+07, -0.2456E+09 } ,

// 93 - Neptunium - Np - 10

{ 0.01,         0.2522E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.1013,       0.1668E+05, -0.8606E+04,  0.1441E+04, -0.6401E+02 } ,
{ 0.431,       -0.2561E+04,  0.1858E+05, -0.1101E+05,  0.1791E+04 } ,
{ 3.664,       -0.3232E+03,  0.1200E+05,  0.5096E+05, -0.2302E+05 } ,
{ 4.435,       -0.4467E+02,  0.2778E+04,  0.2204E+06, -0.5257E+06 } ,
{ 17.613,      -0.6355E+02,  0.9093E+04,  0.4439E+06, -0.6341E+06 } ,
{ 21.6,        -0.1103E+03,  0.2501E+05,  0.3841E+06, -0.1044E+07 } ,
{ 22.427,       0.5579E+01,  0.3489E+04,  0.1354E+07, -0.1078E+08 } ,
{ 118.67,       0.1272E+02,  0.7422E+04,  0.9191E+07, -0.3336E+09 } ,
{ 500.0,        0.6330E+01,  0.1392E+05,  0.7484E+07, -0.3064E+09 } ,

// 94 - Plutonium - Pu - 11

{ 0.01,         0.3508E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.0306,      -0.2939E+04,  0.8224E+03, -0.3576E+02,  0.5087E+00 } ,
{ 0.1054,       0.1270E+05, -0.6607E+04,  0.1093E+04, -0.3674E+02 } ,
{ 0.405,       -0.2063E+04,  0.1760E+05, -0.1057E+05,  0.1695E+04 } ,
{ 3.778,       -0.3181E+03,  0.1245E+05,  0.5096E+05, -0.2427E+05 } ,
{ 4.556,        0.3925E+03, -0.1022E+05,  0.3515E+06, -0.9309E+06 } ,
{ 18.063,      -0.6367E+02,  0.9444E+04,  0.4539E+06, -0.6824E+06 } ,
{ 22.27,       -0.1065E+03,  0.2299E+05,  0.4461E+06, -0.1181E+07 } ,
{ 23.109,      -0.1248E+02,  0.6703E+04,  0.1250E+07, -0.9411E+07 } ,
{ 121.797,      0.1781E+02,  0.3158E+04,  0.1075E+08, -0.4693E+09 } ,
{ 500.0,        0.6490E+01,  0.1422E+05,  0.8179E+07, -0.5340E+09 } ,

// 95 - Americium - Am - 11

{ 0.01,         0.9600E+03,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.103,        0.3669E+04, -0.1927E+04,  0.3556E+03, -0.1775E+02 } ,
{ 0.498,       -0.8806E+05,  0.1824E+06, -0.1119E+06,  0.2150E+05 } ,
{ 0.828,       -0.8786E+03,  0.1063E+05, -0.5553E+03, -0.1750E+04 } ,
{ 3.887,       -0.3188E+03,  0.1325E+05,  0.5127E+05, -0.2586E+05 } ,
{ 4.667,        0.3232E+03, -0.9027E+04,  0.3584E+06, -0.9931E+06 } ,
{ 18.519,      -0.6201E+02,  0.9427E+04,  0.4778E+06, -0.7281E+06 } ,
{ 22.958,      -0.9199E+02,  0.1716E+05,  0.6101E+06, -0.1350E+07 } ,
{ 23.812,      -0.3730E+01,  0.5425E+04,  0.1376E+07, -0.1109E+08 } ,
{ 124.99,       0.1966E+02,  0.2217E+04,  0.1154E+08, -0.5298E+09 } ,
{ 500.0,        0.6763E+01,  0.1479E+05,  0.8647E+07, -0.6116E+09 } ,

// 96 - Curium - Cm - 11

{ 0.01,         0.1000E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.1,          0.3148E+04, -0.1605E+04,  0.2954E+03, -0.1411E+02 } ,
{ 0.498,       -0.7979E+05,  0.1716E+06, -0.1079E+06,  0.2118E+05 } ,
{ 0.853,       -0.8139E+03,  0.1040E+05,  0.4547E+03, -0.2530E+04 } ,
{ 3.971,       -0.3144E+03,  0.1378E+05,  0.5160E+05, -0.2733E+05 } ,
{ 4.797,       -0.2912E+03,  0.1117E+05,  0.1679E+06, -0.4469E+06 } ,
{ 18.982,      -0.5879E+02,  0.9126E+04,  0.4981E+06, -0.7597E+06 } ,
{ 23.663,      -0.1010E+03,  0.2212E+05,  0.5193E+06, -0.1402E+07 } ,
{ 24.535,      -0.1147E+02,  0.7190E+04,  0.1327E+07, -0.1016E+08 } ,
{ 128.253,      0.2200E+02,  0.1083E+04,  0.1208E+08, -0.5684E+09 } ,
{ 500.0,        0.7017E+01,  0.1493E+05,  0.9471E+07, -0.8527E+09 } ,

// 97 - Berkelium - Bk - 11

{ 0.01,         0.1100E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.1,          0.3725E+04, -0.1998E+04,  0.3728E+03, -0.1783E+02 } ,
{ 0.531,       -0.1348E+06,  0.2867E+06, -0.1865E+06,  0.3853E+05 } ,
{ 0.877,       -0.1092E+04,  0.1257E+05, -0.3090E+04, -0.6861E+03 } ,
{ 4.132,       -0.3108E+03,  0.1396E+05,  0.5452E+05, -0.2964E+05 } ,
{ 4.977,       -0.8536E+02,  0.5200E+04,  0.2278E+06, -0.6067E+06 } ,
{ 19.452,      -0.6035E+02,  0.9752E+04,  0.5095E+06, -0.8299E+06 } ,
{ 24.385,      -0.1018E+03,  0.2538E+05,  0.4681E+06, -0.1412E+07 } ,
{ 25.275,      -0.1308E+02,  0.7916E+04,  0.1354E+07, -0.1049E+08 } ,
{ 131.59,       0.2374E+02,  0.1750E+03,  0.1285E+08, -0.6352E+09 } ,
{ 500.0,        0.7219E+01,  0.1592E+05,  0.9491E+07, -0.8283E+09 } ,

// 98 - Californium - Cf - 11

{ 0.01,         0.1220E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.1,          0.3846E+04, -0.2092E+04,  0.3854E+03, -0.1758E+02 } ,
{ 0.548,       -0.5378E+05,  0.1380E+06, -0.9898E+05,  0.2185E+05 } ,
{ 0.902,       -0.9355E+03,  0.1168E+05, -0.4663E+03, -0.2379E+04 } ,
{ 4.254,       -0.3044E+03,  0.1361E+05,  0.6013E+05, -0.3273E+05 } ,
{ 5.109,        0.3450E+03, -0.1057E+05,  0.4170E+06, -0.1248E+07 } ,
{ 19.929,      -0.5797E+02,  0.9571E+04,  0.5352E+06, -0.8755E+06 } ,
{ 25.125,      -0.9148E+02,  0.1942E+05,  0.6490E+06, -0.1673E+07 } ,
{ 26.03,       -0.5416E+02,  0.1706E+05,  0.8630E+06, -0.1792E+07 } ,
{ 135.005,      0.2771E+02, -0.2903E+04,  0.1419E+08, -0.7456E+09 } ,
{ 500.0,        0.7544E+01,  0.1589E+05,  0.1052E+08, -0.1089E+10 } ,

// 99 - Einsteinium - Es - 12

{ 0.01,         0.1330E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.927,       -0.8936E+03,  0.1145E+05,  0.1094E+04, -0.3692E+04 } ,
{ 4.378,       -0.2152E+03,  0.7720E+04,  0.5372E+05, -0.2276E+05 } ,
{ 4.63,        -0.2914E+03,  0.1268E+05,  0.6828E+05, -0.3620E+05 } ,
{ 5.259,       -0.2568E+03,  0.1341E+05,  0.8685E+05, -0.5387E+05 } ,
{ 6.574,       -0.2104E+03,  0.1155E+05,  0.1107E+06, -0.7279E+05 } ,
{ 6.977,        0.1088E+03,  0.1536E+04,  0.2458E+06, -0.6005E+06 } ,
{ 20.414,      -0.5691E+02,  0.9660E+04,  0.5556E+06, -0.9320E+06 } ,
{ 26.02,       -0.9167E+02,  0.2050E+05,  0.6520E+06, -0.1784E+07 } ,
{ 26.9,         0.9687E+00,  0.5331E+04,  0.1646E+07, -0.1518E+08 } ,
{ 139.49,       0.3315E+02, -0.7298E+04,  0.1587E+08, -0.8866E+09 } ,
{ 500.0,        0.7728E+01,  0.1675E+05,  0.1090E+08, -0.1231E+10 } ,

// 100 - Fermium - Fm - 12

{ 0.01,         0.1460E+04,  0.0000E+00,  0.0000E+00,  0.0000E+00 } ,
{ 0.952,       -0.1082E+04,  0.1308E+05, -0.9100E+03, -0.2846E+04 } ,
{ 4.498,       -0.1923E+03,  0.6709E+04,  0.6231E+05, -0.2410E+05 } ,
{ 4.766,       -0.2559E+03,  0.1024E+05,  0.8602E+05, -0.3977E+05 } ,
{ 5.397,       -0.2466E+03,  0.1276E+05,  0.9751E+05, -0.5925E+05 } ,
{ 6.793,       -0.2304E+03,  0.1518E+05,  0.9220E+05, -0.7454E+05 } ,
{ 7.205,        0.8675E+02,  0.2132E+04,  0.2568E+06, -0.6538E+06 } ,
{ 20.907,      -0.5793E+02,  0.1018E+05,  0.5793E+06, -0.1018E+07 } ,
{ 26.81,       -0.8637E+02,  0.1890E+05,  0.7445E+06, -0.1949E+07 } ,
{ 27.7,         0.5556E+00,  0.5648E+04,  0.1738E+07, -0.1662E+08 } ,
{ 143.09,       0.2968E+02, -0.2026E+04,  0.1484E+08, -0.7825E+09 } ,
{ 500.0,        0.8135E+01,  0.1726E+05,  0.1171E+08, -0.1346E+10 }

} ;

// **************************************************
// * Shell Data
// **************************************************
// * JB - 2012-06-11 11:05:00 - for Z=1 to Z=100

// Number of shells
__constant__ unsigned short int atom_NumberOfShells[101] = {
 0 ,  // nonexisting zero element

 1 ,  1 ,  2 ,  2 ,  3 ,    3 ,  4 ,  4 ,  3 ,  4 ,  //  1 - 10

 5 ,  5 ,  6 ,  6 ,  6 ,    6 ,  6 ,  7 ,  8 ,  8 ,  // 11 - 20

 9 ,  9 ,  9 ,  9 ,  9 ,    9 ,  9 , 10 , 10 , 10 ,  // 21 - 30

11 , 11 , 11 , 11 , 11 ,   12 , 13 , 13 , 14 , 14 ,  // 31 - 40

14 , 14 , 14 , 14 , 14 ,   15 , 15 , 15 , 16 , 16 ,  // 41 - 50

// ----------------------------------------------------------

16 , 16 , 16 , 17 , 18 ,   18 , 19 , 19 , 19 , 19 ,  // 51 - 60

19 , 19 , 19 , 20 , 19 ,   19 , 19 , 19 , 19 , 20 ,  // 61 - 70

21 , 21 , 21 , 21 , 21 ,   21 , 21 , 21 , 22 , 22 ,  // 71 - 80

23 , 23 , 23 , 23 , 24 ,   24 , 25 , 25 , 26 , 26 ,  // 81 - 90

27 , 27 , 27 , 26 , 26 ,   27 , 27 , 26 , 26 , 26    // 91 - 100
};

// Index to acces shell data
__constant__ unsigned short int atom_IndexOfShells[101] = {
       0,
       1,    2,    3,    5,    7,   10,   13,   17,   21,   24,  
      28,   33,   38,   44,   50,   56,   62,   68,   75,   83,  
      91,  100,  109,  118,  127,  136,  145,  154,  164,  174,  
     184,  195,  206,  217,  228,  239,  251,  264,  277,  291,  
     305,  319,  333,  347,  361,  375,  390,  405,  420,  436,  
     452,  468,  484,  500,  517,  535,  553,  572,  591,  610,  
     629,  648,  667,  686,  706,  725,  744,  763,  782,  801,  
     821,  842,  863,  884,  905,  926,  947,  968,  989, 1011,  
    1033, 1056, 1079, 1102, 1125, 1149, 1173, 1198, 1223, 1249,  
    1275, 1302, 1329, 1356, 1382, 1408, 1435, 1462, 1488, 1514
};

// Shell data - Bind Energy - !!! Values are in eV !!!
__constant__ float atom_BindingEnergies[1540] = {
  0.0 ,   // Nonexisting zero element
  //  H  ---------------------------------------------------------
  13.60 ,
  //  He ---------------------------------------------------------
  24.59 ,
  //  Li  --------------------------------------------------------
  58.0 ,  5.39 ,
  //  Be  --------------------------------------------------------
  115.0 , 9.32 ,
  //  B   --------------------------------------------------------
  192.0 , 12.93 , 8.3 ,
  //  C  ---------------------------------------------------------
  288.0 , 16.59 , 11.26 ,
  //  N  ---------------------------------------------------------
  403.0 , 37.3 , 20.33 , 14.53 ,
  //  O  ---------------------------------------------------------
  543.1 , 41.6 , 28.48 , 13.62 ,
  //  F  ---------------------------------------------------------
  696.7 , 37.85 , 17.42 ,
  //  Ne ---------------------------------------------------------
  870.1 , 48.47 , 21.66 , 21.56 ,
  //  Na ---------------------------------------------------------
  1075.0 , 66.0 , 34.0 , 34.0 , 5.14 ,
  //  Mg ---------------------------------------------------------
  1308.0 , 92.0 , 54.0 , 54.0 , 7.65 ,
  //  Al ---------------------------------------------------------
  1564.0 , 121. , 77.0 , 77.0 , 10.62 , 5.99 ,
  //  Si ---------------------------------------------------------
  1844.0 , 154.0 , 104.0 , 104.0 , 13.46 , 8.15 ,
  //  P  ---------------------------------------------------------
  2148.0 , 191.0 , 135.0 , 134.0 , 16.15 , 10.49 ,
  //  S  ---------------------------------------------------------
  2476.0 , 232.0 , 170.0 , 168.0 , 20.20 , 10.36 ,
  //  Cl ---------------------------------------------------------
  2829.0 , 277.0 , 208.0 , 206.0 , 24.54 , 12.97 ,
  //  Ar ---------------------------------------------------------
  3206.3 , 326.5 , 250.6 , 248.5 , 29.24 , 15.94 , 15.76 ,
  //  K  ---------------------------------------------------------
  3610.0 , 381.0 , 299.0 , 296.0 , 37.0 , 19.0 , 18.7 , 4.34 ,
  //  Ca ---------------------------------------------------------
  4041.0 , 441.0 , 353.0 , 349.0 , 46.0 , 28.0 , 28.0 , 6.11 ,
  //  Sc ---------------------------------------------------------
  4494.0 , 503.0 , 408.0 , 403.0 , 55.0 , 33.0 , 33.0 , 8.0 , 6.54 ,
  //  Ti ---------------------------------------------------------
  4966.0 , 567.0 , 465.0 , 459.0 , 64.0 , 39.0 , 38.0 , 8.0 , 6.82 ,
  //  V  ---------------------------------------------------------
  5465.0 , 633.0 , 525.0 , 518.0 , 72.0 , 44.0 , 43.0 , 8.0 , 6.74 ,
  //  Cr ---------------------------------------------------------
  5989.0 , 702.0 , 589.0 , 580.0 , 80.0 , 49.0 , 48.0 , 8.25 , 6.77 ,
  //  Mn ---------------------------------------------------------
  6539.0 , 755.0 , 656.0 , 645.0 , 89.0 , 55.0 , 53.0 , 9.0 , 7.43 ,
  //  Fe ---------------------------------------------------------
  7112.0 , 851.0 , 726.0 , 713.0 , 98.0 , 61.0 , 59.0 , 9.0 , 7.87 ,
  //  Co ---------------------------------------------------------
  7709.0 , 931.0 , 800.0 , 785.0 , 107.0 , 68.0 , 66.0 , 9.0 , 7.86 ,
  //  Ni ---------------------------------------------------------
  8333.0 , 1015.0 , 877.0 , 860.0 , 117.0 , 75.0 , 73.0 , 10.0 , 10.0 ,
     7.64 ,
  //  Cu ---------------------------------------------------------
  8979.0 , 1103.0 , 958.0 , 938.0 , 127.0 , 82.0 , 80.0 , 11.0 , 10.4 ,
     7.73 ,
  //  Zn ---------------------------------------------------------
  9659.0 , 1198.0 , 1047.0 , 1024.0 , 141.0 , 94.0 , 91.0 , 12.0 , 11.2 ,
     9.39 ,
  //  Ga ---------------------------------------------------------
  10367.0 , 1302.0 , 1146.0 , 1119.0 , 162.0 , 111.0 , 107.0 , 21.0 ,
     20.0 ,   11.0 ,    6.0 ,
  //  Ge ---------------------------------------------------------
  11103.0 , 1413.0 , 1251.0 , 1220.0 , 184.0 , 130.0 , 125.0 , 33.0 ,
     32.0 ,   14.3 ,    7.9 ,
  //  As ---------------------------------------------------------
  11867.0 , 1531.0 , 1362.0 , 1327.0 , 208.0 , 151.0 , 145.0 , 46.0 ,
     45.0 ,   17.0 ,    9.81 ,
  //  Se ---------------------------------------------------------
  12658.0 , 1656.0 , 1479.0 , 1439.0 , 234.0 , 173.0 , 166.0 , 61.0 ,
     60.0 ,   20.15 ,   9.75 ,
  //  Br ---------------------------------------------------------
  13474.0 , 1787.0 , 1602.0 , 1556.0 , 262.0 , 197.0 , 189.0 , 77.0 ,
     76.0 ,   23.8 ,   11.85 ,
  //  Kr ---------------------------------------------------------
  14326.0 , 1924.6 , 1730.9 , 1678.4 , 292.8 , 222.2 , 214.4 , 95.0 ,
     93.8 ,   27.51 ,  14.65 ,  14.0 ,
  //  Rb ---------------------------------------------------------
  15200.0 , 2068.0 , 1867.0 , 1807.0 , 325.0 , 251.0 , 242.0 , 116.0 ,
    114.0 ,   32.0 ,   16.0 ,   15.3 ,   4.18 ,
  //  Sr ---------------------------------------------------------
  16105.0 , 2219.0 , 2010.0 , 1943.0 , 361.0 , 283.0 , 273.0 , 139.0 ,
    137.0 ,   40.0 ,   23.0 ,   22.0 ,   5.69 ,
  //  Y  ---------------------------------------------------------
  17038.0 , 2375.0 , 2158.0 , 2083.0 , 397.0 , 315.0 , 304.0 , 163.0 ,
    161.0 ,   48.0 ,   30.0 ,   29.0 ,   6.38 ,  6.48 ,
  //  Zr ---------------------------------------------------------
  17998.0 , 2536.0 , 2311.0 , 2227.0 , 434.0 , 348.0 , 335.0 , 187.0 ,
    185.0 ,   56.0 ,   35.0 ,   33.0 ,   8.61 ,  6.84 ,
  //  Nb ----------------------------------------------------------
  18986.0 , 2702.0 , 2469.0 , 2375.0 , 472.0 , 382.0 , 367.0 , 212.0 ,
    209.0 ,   62.0 ,   40.0 ,   38.0 ,   7.17 ,  6.88 ,
  //  Mo -----------------------------------------------------------
  20000.0 , 2872.0 , 2632.0 , 2527.0 , 511.0 , 416.0 , 399.0 , 237.0 ,
    234.0 ,   68.0 ,   45.0 ,   42.0 ,   8.56 ,  7.10 ,
  //  Tc -----------------------------------------------------------
  21044.0 , 3048.0 , 2800.0 , 2683.0 , 551.0 , 451.0 , 432.0 , 263.0 ,
    259.0 ,   74.0 ,   49.0 ,   45.0 ,   8.6 ,   7.28 ,
  //  Ru -----------------------------------------------------------
  22117.0 , 3230.0 , 2973.0 , 2844.0 , 592.0 , 488.0 , 466.0 , 290.0 ,
    286.0 ,   81.0 ,   53.0 ,   49.0 ,   8.5 ,   7.37 ,
  //  Rh -----------------------------------------------------------
  23220.0 , 3418.0 , 3152.0 , 3010.0 , 634.0 , 526.0 , 501.0 , 318.0 ,
    313.0 ,   87.0 ,   58.0 ,   53.0 ,   9.56 ,  7.46 ,
  //  Pd -----------------------------------------------------------
  24350.0 , 3611.0 , 3337.0 , 3180.0 , 677.0 , 565.0 , 537.0 , 347.0 ,
    342.0 ,   93.0 ,   63.0 ,   57.0 ,   8.78 ,  8.34 ,  7.52 ,
  //  Ag -----------------------------------------------------------
  25514.0 , 3812.0 , 3530.0 , 3357.0 , 724.0 , 608.0 , 577.0 , 379.0 ,
    373.0 ,  101.0 ,   69.0 ,   63.0 ,  11.0 ,  10.0 ,   7.58 ,
  //  Cd ------------------------------------------------------------
  26711.0 , 4022.0 , 3732.0 , 3542.0 , 775.0 , 655.0 , 621.0 , 415.0 ,
    408.0 ,  112.0 ,   78.0 ,   71.0 ,  14.0 ,  13.0 ,   8.99 ,
  //  In ------------------------------------------------------------
  27940.0 , 4242.0 , 3943.0 , 3735.0 , 830.0 , 707.0 , 669.0 , 455.0 ,
    447.0 ,  126.0 ,   90.0 ,   82.0 ,  21.0 ,  20.0 ,  10.0 ,   5.79 ,
  //  Sn ------------------------------------------------------------
  29200.0 , 4469.0 , 4160.0 , 3933.0 , 888.0 , 761.0 , 719.0 , 497.0 ,
    489.0 ,  141.0 ,  102.0 ,   93.0 ,  29.0 ,  28.0 ,  12.0 ,   7.34 ,
  //  Sb ------------------------------------------------------------
  30419.0 , 4698.0 , 4385.0 , 4137.0 , 949.0 , 817.0 , 771.0 , 542.0 ,
    533.0 ,  157.0 ,  114.0 ,  104.0 ,  38.0 ,  37.0 ,  15.0 ,   8.64 ,
  //  Te ------------------------------------------------------------
  31814.0 , 4939.0 , 4612.0 , 4347.0 , 1012.0 , 876.0 , 825.0 , 589.0 ,
    578.0 ,  174.0 ,  127.0 ,  117.0 ,   48.0 ,  46.0 ,  17.84 ,  9.01 ,
  //  I  ------------------------------------------------------------
  33169.0 , 5188.0 , 4852.0 , 4557.0 , 1078.0 , 937.0 , 881.0 , 638.0 ,
    626.0 ,  193.0 ,  141.0 ,  131.0 ,   58.0 ,  56.0 ,  20.61 , 10.45 ,
  //  Xe ------------------------------------------------------------
  34570.0 , 5460.0 , 5110.0 , 4790.0 , 1148.7 , 1002.1 , 940.6 , 689.0 ,
    676.4 ,  213.2 ,  157.0 ,  145.5 ,   69.5 ,   67.5 ,  23.39 , 13.43 ,
     12.13 ,
  //  Cs ------------------------------------------------------------
  35985.0 , 5714.0 , 5359.0 , 5012.0 , 1220.0 , 1068.0 , 1000.0 , 742.0 ,
    728.0 ,  233.0 ,  174.0 ,  164.0 ,   81.0 ,   79.0 ,   25.0 ,  14.0 ,
     12.3 ,    3.89 ,
  //  Ba -------------------------------------------------------------
  37441.0 , 5989.0 , 5624.0 , 5247.0 , 1293.0 , 1138.0 , 1063.0 , 797.0 ,
    782.0 ,  254.0 ,  193.0 ,  181.0 ,   94.0 ,   92.0 ,   31.0 ,  18.0 ,
     16.0 ,    5.21 ,
  //  La -------------------------------------------------------------
  38925.0 , 6266.0 , 5891.0 , 5483.0 , 1365.0 , 1207.0 , 1124.0 , 851.0 ,
    834.0 ,  273.0 ,  210.0 ,  196.0 ,  105.0 ,  103.0 ,   36.0 ,  22.0 ,
     19.0 ,    5.75 ,   5.58 ,
  //  Ce -------------------------------------------------------------
  40443.0 , 6548.0 , 6164.0 , 5723.0 , 1437.0 , 1275.0 , 1184.0 , 903.0 ,
    885.0 ,  291.0 ,  225.0 ,  209.0 ,  114.0 ,  111.0 ,    6.0 ,  39.0 ,
     25.0 ,   22.0 ,    5.65 ,
  //  Pr -------------------------------------------------------------
  41991.0 , 6835.0 , 6440.0 , 5964.0 , 1509.0 , 1342.0 , 1244.0 , 954.0 ,
    934.0 ,  307.0 ,  238.0 ,  220.0 ,  121.0 ,  117.0 ,    6.0 ,  41.0 ,
     27.0 ,   24.0 ,    5.42 ,
  //  Nd -------------------------------------------------------------
  43569.0 , 7126.0 , 6722.0 , 6208.0 , 1580.0 , 1408.0 , 1303.0 , 1005.0 ,
    983.0 ,  321.0 ,  250.0 ,  230.0 ,  126.0 ,  122.0 ,    6.0 ,   42.0 ,
     28.0 ,   25.0 ,    5.49 ,
  //  Pm -------------------------------------------------------------
  45184.0 , 7428.0 , 7013.0 , 6459.0 , 1653.0 , 1476.0 , 1362.0 , 1057.0 ,
   1032.0 ,  325.0 ,  261.0 ,  240.0 ,  131.0 ,  127.0 ,    6.0 ,   43.0 ,
     28.0 ,   25.0 ,    5.55 ,
  //  Sm -------------------------------------------------------------
  46834.0 , 7737.0 , 7312.0 , 6716.0 , 1728.0 , 1546.0 , 1422.0 , 1110.0 ,
   1083.0 ,  349.0 ,  273.0 ,  251.0 ,  137.0 ,  132.0 ,    6.0 ,   44.0 ,
     29.0 ,   25.0 ,    5.63 ,
  //  Eu -------------------------------------------------------------
  48519.0 , 8052.0 , 7617.0 , 6977.0 , 1805.0 , 1618.0 , 1484.0 , 1164.0 ,
   1135.0 ,  364.0 ,  286.0 ,  262.0 ,  143.0 ,  137.0 ,    6.0 ,   45.0 ,
     30.0 ,   26.0 ,    5.68 ,
  //  Gd -------------------------------------------------------------
  50239.0 , 8376.0 , 7930.0 , 7243.0 , 1884.0 , 1692.0 , 1547.0 , 1220.0 ,
   1189.0 ,  380.0 ,  300.0 ,  273.0 ,  150.0 ,  143.0 ,    6.0 ,   46.0 ,
     31.0 ,   27.0 ,    6.0 ,    6.16 ,
  //  Tb -------------------------------------------------------------
  51996.0 , 8708.0 , 8252.0 , 7514.0 , 1965.0 , 1768.0 , 1612.0 , 1277.0 ,
   1243.0 ,  398.0 ,  315.0 ,  285.0 ,  157.0 ,  150.0 ,    6.0 ,   48.0 ,
     32.0 ,   28.0 ,    5.85 ,
  //  Dy -------------------------------------------------------------
  53789.0 , 9046.0 , 8581.0 , 7790.0 , 2048.0 , 1846.0 , 1678.0 , 1335.0 ,
   1298.0 ,  416.0 ,  331.0 ,  297.0 ,  164.0 ,  157.0 ,    6.0 ,   50.0 ,
     33.0 ,   28.0 ,    5.93 ,
  //  Ho -------------------------------------------------------------
  55618.0 , 9394.0 , 8918.0 , 8071.0 , 2133.0 , 1926.0 , 1746.0 , 1395.0 ,
   1354.0 ,  434.0 ,  348.0 ,  310.0 ,  172.0 ,  164.0 ,    6.0 ,   52.0 ,
     34.0 ,   29.0 ,    6.02 ,
  //  Er -------------------------------------------------------------
  57486.0 , 9751.0 , 9264.0 , 8358.0 , 2220.0 , 2008.0 , 1815.0 , 1456.0 ,
   1412.0 ,  452.0 ,  365.0 ,  323.0 ,  181.0 ,  172.0 ,    6.0 ,   54.0 ,
     35.0 ,   30.0 ,    6.10 ,
  //  Tu -------------------------------------------------------------
  59390.0 , 10116.0 , 9617.0 , 8648.0 , 2309.0 , 2092.0 , 1885.0 , 1518.0 ,
   1471.0 ,   471.0 ,  382.0 ,  336.0 ,  190.0 ,  181.0 ,    7.0 ,   56.0 ,
     36.0 ,    30.0 ,    6.18 ,
  //  Yb -------------------------------------------------------------
  61332.0 , 10486.0 , 9978.0 , 8944.0 , 2401.0 , 2178.0 , 1956.0 , 1580.0 ,
   1531.0 ,   490.0 ,  399.0 ,  349.0 ,  200.0 ,  190.0 ,    8.0 ,    7.0 ,
     58.0 ,    37.0 ,   31.0 ,    6.25 ,
  //  Lu -------------------------------------------------------------
  63314.0 , 10870.0 , 10349.0 , 9244.0 , 2499.0 , 2270.0 , 2032.0 , 1647.0 ,
   1596.0 ,   514.0 ,   420.0 ,  366.0 ,  213.0 ,  202.0 ,   13.0 ,   12.0 ,
     62.0 ,    39.0 ,    32.0 ,    6.6 ,    7.0 ,
  //  Hf -------------------------------------------------------------
  65351.0 , 11271.0 , 10739.0 , 9561.0 , 2604.0 , 2369.0 , 2113.0 , 1720.0 ,
   1665.0 ,   542.0 ,   444.0 ,  386.0 ,  229.0 ,  217.0 ,   21.0 ,   20.0 ,
     68.0 ,    43.0 ,    35.0 ,    7.0 ,    7.5 ,
  //  Ta -------------------------------------------------------------
  67416.0 , 11682.0 , 11136.0 , 9881.0 , 2712.0 , 2472.0 , 2197.0 , 1796.0 ,
   1737.0 ,   570.0 ,   469.0 ,  407.0 ,  245.0 ,  232.0 ,   30.0 ,   28.0 ,
     74.0 ,    47.0 ,    38.0 ,    8.3 ,    7.9 ,
  //  W  -------------------------------------------------------------
  69525.0 , 12100.0 , 11544.0 , 10207.0 , 2823.0 , 2577.0 , 2283.0 , 1874.0 ,
   1811.0 ,   599.0 ,   495.0 ,   428.0 ,  261.0 ,  248.0 ,   38.0 ,   36.0 ,
     80.0 ,    51.0 ,    41.0 ,     9.0 ,    8.0 ,
  //  Re -------------------------------------------------------------
  71676.0 , 12527.0 , 11959.0 , 10535.0 , 2937.0 , 2686.0 , 2371.0 , 1953.0 ,
   1887.0 ,   629.0 ,   522.0 ,   450.0 ,  278.0 ,  264.0 ,   47.0 ,   45.0 ,
     86.0 ,    56.0 ,    45.0 ,     9.6 ,    7.9 ,
  //  Os -------------------------------------------------------------
  73871.0 , 12968.0 , 12385.0 , 10871.0 , 3054.0 , 2797.0 , 2461.0 , 2035.0 ,
   1964.0 ,   660.0 ,   551.0 ,   473.0 ,  295.0 ,  280.0 ,   56.0 ,   54.0 ,
     92.0 ,    61.0 ,    49.0 ,     9.6 ,    8.5 ,
  //  Ir -------------------------------------------------------------
  76111.0 , 13419.0 , 12824.0 , 11215.0 , 3175.0 , 2912.0 , 2554.0 , 2119.0 ,
   2044.0 ,   693.0 ,   581.0 ,   497.0 ,  314.0 ,  298.0 ,   67.0 ,   64.0 ,
     99.0 ,    66.0 ,    53.0 ,     9.6 ,    9.1 ,
  //  Pt -------------------------------------------------------------
  78395.0 , 13880.0 , 13273.0 , 11564.0 , 3300.0 , 3030.0 , 2649.0 , 2206.0 ,
   2126.0 ,   727.0 ,   612.0 ,   522.0 ,  335.0 ,  318.0 ,   78.0 ,   75.0 ,
    106.0 ,    71.0 ,    57.0 ,     9.6 ,    9.0 ,
  //  Au -------------------------------------------------------------
  80725.0 , 14353.0 , 13734.0 , 11919.0 , 3430.0 , 3153.0 , 2748.0 , 2295.0 ,
   2210.0 ,   764.0 ,   645.0 ,   548.0 ,  357.0 ,  339.0 ,   91.0 ,   87.0 ,
    114.0 ,    76.0 ,    61.0 ,    12.5 ,   11.1 ,    9.23 ,
  //  Hg -------------------------------------------------------------
  83102.0 , 14839.0 , 14209.0 , 12284.0 , 3567.0 , 3283.0 , 2852.0 , 2390.0 ,
   2300.0 ,   806.0 ,   683.0 ,   579.0 ,  382.0 ,  363.0 ,  107.0 ,  103.0 ,
    125.0 ,    85.0 ,    68.0 ,    14.0 ,   12.0 ,   10.4 ,
  //  Tl -------------------------------------------------------------
  85530.0 , 15347.0 , 14698.0 , 12658.0 , 3710.0 , 3420.0 , 2961.0 , 2490.0 ,
   2394.0 ,   852.0 ,   726.0 ,   615.0 ,  411.0 ,  391.0 ,  127.0 ,  123.0 ,
    139.0 ,    98.0 ,    79.0 ,    21.0 ,   19.0 ,    8.0 ,    6.11 ,
  //  Pb -------------------------------------------------------------
  88005.0 , 15861.0 , 15200.0 , 13055.0 , 3857.0 , 3560.0 , 3072.0 , 2592.0 ,
   2490.0 ,   899.0 ,   769.0 ,   651.0 ,  441.0 ,  419.0 ,  148.0 ,  144.0 ,
    153.0 ,   111.0 ,    90.0 ,    27.0 ,   25.0 ,   10.0 ,    7.42 ,
  //  Bi -------------------------------------------------------------
  90526.0 , 16388.0 , 15711.0 , 13419.0 , 4007.0 , 3704.0 , 3185.0 , 2696.0 ,
   2588.0 ,   946.0 ,   813.0 ,   687.0 ,  472.0 ,  448.0 ,  170.0 ,  165.0 ,
    167.0 ,   125.0 ,   101.0 ,    34.0 ,   32.0 ,   12.0 ,    7.29 ,
  //  Po -------------------------------------------------------------
  93105.0 , 16939.0 , 16244.0 , 13814.0 , 4161.0 , 3852.0 , 3301.0 , 2802.0 ,
   2687.0 ,   994.0 ,   858.0 ,   724.0 ,  503.0 ,  478.0 ,  193.0 ,  187.0 ,
    181.0 ,   139.0 ,   112.0 ,    41.0 ,   38.0 ,   15.0 ,    8.43 ,
  //  At -------------------------------------------------------------
  95730.0 , 17493.0 , 16785.0 , 14214.0 , 4320.0 , 4005.0 , 3420.0 , 2910.0 ,
   2788.0 ,  1044.0 ,   904.0 ,   761.0 ,  535.0 ,  508.0 ,  217.0 ,  211.0 ,
    196.0 ,   153.0 ,   123.0 ,    48.0 ,   44.0 ,   19.0 ,   11.0 ,    9.3 ,
  //  Rn -------------------------------------------------------------
  98404.0 , 18049.0 , 17337.0 , 14619.0 , 4483.0 , 4162.0 , 3452.0 , 3109.0 ,
   2890.0 ,  1096.0 ,   951.0 ,   798.0 ,  567.0 ,  538.0 ,  242.0 ,  235.0 ,
    212.0 ,   167.0 ,   134.0 ,    55.0 ,   51.0 ,   24.0 ,   14.0 ,   10.7 ,
  //  Fr -------------------------------------------------------------
 101137.0 , 18639.0 , 17907.0 , 15031.0 , 4652.0 , 4324.0 , 3666.0 , 3134.0 ,
   2998.0 ,  1153.0 ,  1003.0 ,   839.0 ,  603.0 ,  572.0 ,  268.0 ,  260.0 ,
    231.0 ,   183.0 ,   147.0 ,    65.0 ,   61.0 ,   33.0 ,   19.0 ,   14.0 ,
      4.0 ,
  //  Ra -------------------------------------------------------------
 103922.0 , 19237.0 , 18484.0 , 15444.0 , 4822.0 , 4491.0 , 3793.0 , 3254.0 ,
   3111.0 ,  1214.0 ,  1060.0 ,   884.0 ,  642.0 ,  609.0 ,  296.0 ,  287.0 ,
    253.0 ,   201.0 ,   161.0 ,    77.0 ,   73.0 ,   40.0 ,   25.0 ,   19.0 ,
      5.28 ,
  //  Ac -------------------------------------------------------------
 106755.0 , 19840.0 , 19083.0 , 15871.0 , 5002.0 , 4656.0 , 3921.0 , 3374.0 ,
   3223.0 ,  1274.0 ,  1116.0 ,   928.0 ,  680.0 ,  645.0 ,  322.0 ,  313.0 ,
    274.0 ,   218.0 ,   174.0 ,    88.0 ,   83.0 ,   45.0 ,   29.0 ,   22.0 ,
      5.7 ,     6.3 ,
  //  Th -------------------------------------------------------------
 109651.0 , 20472.0 , 19693.0 , 16300.0 , 5182.0 , 4830.0 , 4049.0 , 3494.0 ,
   3335.0 ,  1333.0 ,  1171.0 ,   970.0 ,  717.0 ,  679.0 ,  347.0 ,  338.0 ,
    293.0 ,   233.0 ,   185.0 ,    97.0 ,   91.0 ,   50.0 ,   33.0 ,   25.0 ,
      6.0 ,     6.0 ,
  //  Pa -------------------------------------------------------------
 112601.0 , 21105.0 , 20314.0 , 16733.0 , 5367.0 , 5001.0 , 4178.0 , 3613.0 ,
   3446.0 ,  1390.0 ,  1225.0 ,  1011.0 ,  752.0 ,  712.0 ,  372.0 ,  362.0 ,
    312.0 ,   248.0 ,   195.0 ,   104.0 ,   97.0 ,    6.0 ,   50.0 ,   32.0 ,
     24.0 ,     6.0 ,     6.0 ,
  //  U  -------------------------------------------------------------
 115606.0 , 21757.0 , 20948.0 , 17166.0 , 5548.0 , 5182.0 , 4308.0 , 3733.0 ,
   3557.0 ,  1446.0 ,  1278.0 ,  1050.0 ,  785.0 ,  743.0 ,  396.0 ,  386.0 ,
    329.0 ,   261.0 ,   203.0 ,   110.0 ,  101.0 ,    6.0 ,   52.0 ,   34.0 ,
     24.0 ,     6.1 ,     6.0 ,
  //  Np -------------------------------------------------------------
 118678.0 , 22426.0 , 21600.0 , 17610.0 , 5723.0 , 5366.0 , 4440.0 , 3854.0 ,
   3669.0 ,  1504.0 ,  1331.0 ,  1089.0 ,  819.0 ,  774.0 ,  421.0 ,  410.0 ,
    346.0 ,   274.0 ,   211.0 ,   116.0 ,  106.0 ,    6.0 ,   54.0 ,   35.0 ,
     25.0 ,     6.0 ,     6.0 ,
  //  Pu -------------------------------------------------------------
 121818.0 , 23097.0 , 22266.0 , 18056.0 , 5933.0 , 5541.0 , 4557.0 , 3977.0 ,
   3783.0 ,  1563.0 ,  1384.0 ,  1128.0 ,  853.0 ,  805.0 ,  446.0 ,  434.0 ,
    356.0 ,   287.0 ,   219.0 ,   122.0 ,  111.0 ,    6.0 ,   53.0 ,   34.0 ,
     23.0 ,     6.0 ,
  //  Am -------------------------------------------------------------
 125027.0 , 23773.0 , 22944.0 , 18504.0 , 6121.0 , 5710.0 , 4667.0 , 4102.0 ,
   3898.0 ,  1623.0 ,  1439.0 ,  1167.0 ,  887.0 ,  836.0 ,  467.0 ,  452.0 ,
    355.0 ,   301.0 ,   220.0 ,   123.0 ,  112.0 ,    6.0 ,   54.0 ,   44.0 ,
     36.0 ,     6.0 ,
  //  Cm -------------------------------------------------------------
 128220.0 , 24460.0 , 23779.0 , 18930.0 , 6288.0 , 5895.0 , 4797.0 , 4236.0 ,
   4014.0 ,  1664.0 ,  1493.0 ,  1194.0 ,  919.0 ,  864.0 ,  494.0 ,  479.0 ,
    384.0 ,   314.0 ,   239.0 ,   126.0 ,  119.0 ,   11.0 ,   60.0 ,   39.0 ,
     27.0 ,     5.0 ,     6.0 ,
  //  Bk -------------------------------------------------------------
 131590.0 , 25275.0 , 24385.0 , 19452.0 , 6556.0 , 6147.0 , 4977.0 , 4366.0 ,
   4133.0 ,  1729.0 ,  1554.0 ,  1236.0 ,  955.0 ,  898.0 ,  520.0 ,  504.0 ,
    401.0 ,   329.0 ,   248.0 ,   142.0 ,  124.0 ,   12.0 ,   63.0 ,   41.0 ,
     27.0 ,     4.0 ,     6.0 ,
  //  Cf -------------------------------------------------------------
 135960.0 , 26110.0 , 25250.0 , 19930.0 , 6754.0 , 6359.0 , 5109.0 , 4492.0 ,
   4247.0 ,  1789.0 ,  1610.0 ,  1273.0 ,  987.0 ,  925.0 ,  546.0 ,  529.0 ,
    412.0 ,   338.0 ,   251.0 ,   142.0 ,  129.0 ,    9.0 ,   61.0 ,   39.0 ,
     25.0 ,     6.0 ,
  //  Es -------------------------------------------------------------
 139490.0 , 26900.0 , 26020.0 , 20410.0 , 6977.0 , 6754.0 , 5252.0 , 4630.0 ,
   4369.0 ,  1857.0 ,  1674.0 ,  1316.0 , 1024.0 ,  959.0 ,  573.0 ,  554.0 ,
    429.0 ,   353.0 ,   260.0 ,   148.0 ,  135.0 ,    9.0 ,   63.0 ,   40.0 ,
     25.0 ,     6.0 ,
  //  Fm -------------------------------------------------------------
 143090.0 , 27700.0 , 26810.0 , 20900.0 , 7205.0 , 6793.0 , 5397.0 , 4766.0 ,
   4498.0 ,  1933.0 ,  1746.0 ,  1366.0 , 1068.0 , 1000.0 ,  606.0 ,  587.0 ,
    453.0 ,   375.0 ,   275.0 ,   160.0 ,  145.0 ,   15.0 ,   69.0 ,   45.0 ,
     29.0 ,     7.0 ,
};

// ************************************************************************
// * MultiScattering data
// ************************************************************************
// * JB - 2012-10-05 08:25:44, Values were given by Seb

__constant__  float Zdat [15] = { 
    4.0f, 6.0f, 13.0f, 20.0f, 26.0f, 29.0f, 32.0f, 38.0f, 
    47.0f, 50.0f, 56.0f, 64.0f, 74.0f, 79.0f, 82.0f
};

__constant__  float Tdat [22] = {
    100.0e-06f, 200.0e-06f, 400.0e-06f, 700.0e-06f, 
      1.0e-03f,   2.0e-03f,   4.0e-03f,   7.0e-03f, 
     10.0e-03f,  20.0e-03f,  40.0e-03f,  70.0e-03f, 
    100.0e-03f, 200.0e-03f, 400.0e-03f, 700.0e-03f,
          1.0f,       2.0f,       4.0f,       7.0f, 
         10.0f,      20.0f
};

  // corr. factors for e- lambda for T <= Tlim
__constant__  float celectron [15][22] = 
{
   {1.125, 1.072, 1.051, 1.047, 1.047, 1.050, 1.052, 1.054,
    1.054, 1.057, 1.062, 1.069, 1.075, 1.090, 1.105, 1.111,
    1.112, 1.108, 1.100, 1.093, 1.089, 1.087              },

   {1.408, 1.246, 1.143, 1.096, 1.077, 1.059, 1.053, 1.051,
    1.052, 1.053, 1.058, 1.065, 1.072, 1.087, 1.101, 1.108,
    1.109, 1.105, 1.097, 1.090, 1.086, 1.082              },

   {2.833, 2.268, 1.861, 1.612, 1.486, 1.309, 1.204, 1.156,
    1.136, 1.114, 1.106, 1.106, 1.109, 1.119, 1.129, 1.132,
    1.131, 1.124, 1.113, 1.104, 1.099, 1.098              },

   {3.879, 3.016, 2.380, 2.007, 1.818, 1.535, 1.340, 1.236,
    1.190, 1.133, 1.107, 1.099, 1.098, 1.103, 1.110, 1.113,
    1.112, 1.105, 1.096, 1.089, 1.085, 1.098              },

   {6.937, 4.330, 2.886, 2.256, 1.987, 1.628, 1.395, 1.265,
    1.203, 1.122, 1.080, 1.065, 1.061, 1.063, 1.070, 1.073,
    1.073, 1.070, 1.064, 1.059, 1.056, 1.056              },

   {9.616, 5.708, 3.424, 2.551, 2.204, 1.762, 1.485, 1.330,
    1.256, 1.155, 1.099, 1.077, 1.070, 1.068, 1.072, 1.074,
    1.074, 1.070, 1.063, 1.059, 1.056, 1.052              },

   {11.72, 6.364, 3.811, 2.806, 2.401, 1.884, 1.564, 1.386,
    1.300, 1.180, 1.112, 1.082, 1.073, 1.066, 1.068, 1.069,
    1.068, 1.064, 1.059, 1.054, 1.051, 1.050              },

   {18.08, 8.601, 4.569, 3.183, 2.662, 2.025, 1.646, 1.439,
    1.339, 1.195, 1.108, 1.068, 1.053, 1.040, 1.039, 1.039,
    1.039, 1.037, 1.034, 1.031, 1.030, 1.036              },

   {18.22, 10.48, 5.333, 3.713, 3.115, 2.367, 1.898, 1.631,
    1.498, 1.301, 1.171, 1.105, 1.077, 1.048, 1.036, 1.033,
    1.031, 1.028, 1.024, 1.022, 1.021, 1.024              },

   {14.14, 10.65, 5.710, 3.929, 3.266, 2.453, 1.951, 1.669,
    1.528, 1.319, 1.178, 1.106, 1.075, 1.040, 1.027, 1.022,
    1.020, 1.017, 1.015, 1.013, 1.013, 1.020              },

   {14.11, 11.73, 6.312, 4.240, 3.478, 2.566, 2.022, 1.720,
    1.569, 1.342, 1.186, 1.102, 1.065, 1.022, 1.003, 0.997,
    0.995, 0.993, 0.993, 0.993, 0.993, 1.011              },

   {22.76, 20.01, 8.835, 5.287, 4.144, 2.901, 2.219, 1.855,
    1.677, 1.410, 1.224, 1.121, 1.073, 1.014, 0.986, 0.976,
    0.974, 0.972, 0.973, 0.974, 0.975, 0.987              },

   {50.77, 40.85, 14.13, 7.184, 5.284, 3.435, 2.520, 2.059,
    1.837, 1.512, 1.283, 1.153, 1.091, 1.010, 0.969, 0.954,
    0.950, 0.947, 0.949, 0.952, 0.954, 0.963              },

   {65.87, 59.06, 15.87, 7.570, 5.567, 3.650, 2.682, 2.182,
    1.939, 1.579, 1.325, 1.178, 1.108, 1.014, 0.965, 0.947,
    0.941, 0.938, 0.940, 0.944, 0.946, 0.954              },

   {55.60, 47.34, 15.92, 7.810, 5.755, 3.767, 2.760, 2.239,
    1.985, 1.609, 1.343, 1.188, 1.113, 1.013, 0.960, 0.939,
    0.933, 0.930, 0.933, 0.936, 0.939, 0.949              }
};


__constant__ float sig0 [15] = {
    0.2672e-22f, 0.5922e-22f, 2.653e-22f, 6.235e-22f,
     11.69e-22f,  13.24e-22f, 16.12e-22f, 23.00e-22f,
     35.13e-22f,  39.95e-22f, 50.85e-22f, 67.19e-22f,
     91.15e-22f,  104.4e-22f, 113.1e-22f
};
		      		       
__constant__ float hecorr [15] = {
    120.70f, 117.50f, 105.00f, 92.92f, 79.23f, 74.510f,  
     68.29f,  57.39f,  41.97f, 36.14f, 24.53f,  10.21f,
    -7.855f, -16.84f, -22.30f
};


