## How to contribute to F&#35;

See [contributing guide][fsharp-contributing-guide] for more info

### First, check if this is the right repository

The https://github.com/fsharp/fsharp repository is for cross platform packaging only.
The development of the compiler and core library is at [Microsoft/visualfsharp][Microsoft/visualfsharp].

* **Is this a language suggestion?** Use the [F# Language Suggestions](http://github.com/fsharp/fslang-suggestions)

* **Is the issue specific to F# on Mono/OSX/Linux?** This might be the right repository.

* **Is the issue a bug in Mono?** Please report to [Mono Bugzilla](https://bugzilla.xamarin.com/)

* **Is the issue specific to F# on Windows or Visual Studio?** Use the [Microsoft/visualfsharp][Microsoft/visualfsharp] repository

* **Is the issue a general bug in the F# compiler/core library?** Use the  [Microsoft/visualfsharp][Microsoft/visualfsharp] repository

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/fsharp/fsharp/issues) and in the [Microsoft/visualfsharp Issues](https://github.com/Microsoft/visualfsharp/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/fsharp/fsharp/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

* For more detailed information on submitting a bug report and creating an issue, visit our [contributing guide][fsharp-contributing-guide].

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

#### **Do you intend to add a new feature or change an existing one?**

* See the [F# Language Suggestions](http://github.com/fsharp/fslang-suggestions).
  
#### **Do you have questions about the source code?**

* Ask any question about how to use F# in the [F# mailing list](https://groups.google.com/forum/m/#!forum/fsharp-opensource) or on stackoverflow.

* Check the Contribute section in the [fsharp.org site](http://fsharp.org/) for more info

</br>

Thanks!

The [F# Core Engineering Group][fsg] (a technical working group of [The F# Software Foundation][fsf])

 [fsg]: http://fsharp.github.io/
 [fsf]: http://fsharp.org
 [Microsoft/visualfsharp]: https://github.com/Microsoft/visualfsharp
 [fsharp-contributing-guide]: http://fsharp.github.io/2014/06/18/fsharp-contributions.html
 
