(*==========================================================================
 * (c) Microsoft Corporation 2005-2007.  
 *
 *=========================================================================*)

module Microsoft.FSharp.Compatibility.OCaml.Obj
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives

type t = obj
let repr x = box x
let obj x = unbox x
let magic x = obj (repr x)
let nullobj = (# "ldnull" : obj #)


let eq (x: 'a)  (y: 'a) = LanguagePrimitives.PhysicalEquality x y
let not_eq (x:'a) (y:'a) = not (LanguagePrimitives.PhysicalEquality x y)
