(*==========================================================================
 * (c) Microsoft Corporation 2005-2007. The interface to the module 
 * is similar to that found in versions of other ML implementations, 
 * but is not an exact match.  The type signatures in this interface
 * are an edited version of those generated automatically by running 
 * "bin\fsc.exe -i" on the implementation file.
 *=========================================================================*)

/// Basic operations on 2-dimensional arrays. 
///
/// F# and .NET multi-dimensional arrays are typically zero-based. 
/// However, .NET multi-dimensional arrays used in conjunction with external
/// libraries (e.g. libraries associated with Visual Basic) be 
/// non-zero based, using a potentially different base for each dimension.
/// The operations in this module will accept such arrays, and
/// the basing on an input array will be propogated to a matching output
/// array on the [[Array2.map]] and [[Array2.mapi]] operations.
/// Non-zero-based arrays can also be created using [[Array2.zero_create_based]], 
/// [[Array2.create_based]] and [[Array2.init_based]].
///
/// This module is only available for F# on .NET 2.0.
/// If using .NET 1.x then use Microsoft.FSharp.Compatiblity.CompatMatrix instead.
module Microsoft.FSharp.Collections.Array2
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.Operators


#if CLI_AT_MOST_1_1
#else
/// Create an array whose elements are all initially the given value
val create: len1:int -> len2:int -> 'a -> 'a[,]

/// Create an array given the dimensions and a generator function to compute the elements.
val init: len1:int -> len2:int -> (int -> int -> 'a) -> 'a[,]

/// Fetch an element from a 2D array.  You can also use the syntax 'arr.[idx1,idx2]'
val get: 'a[,] -> idx1:int -> idx2:int -> 'a

/// Apply the given function to each element of the array. 
val iter: ('a -> unit) -> 'a[,] -> unit

/// Apply the given function to each element of the array.  The integer indicies passed to the
/// function indicates the index of element.
val iteri: (int -> int -> 'a -> unit) -> 'a[,] -> unit

/// Return the length of an array in the first dimension  
val length1: 'a[,] -> int

/// Return the length of an array in the second dimension  
val length2: 'a[,] -> int

/// Fetch the base-index for the first dimension of the array.
///
/// See notes on the Array2 module re. zero-basing.
val base1: 'a[,] -> int

/// Fetch the base-index for the second dimension of the array.
///
/// See notes on the Array2 module re. zero-basing.
val base2: 'a[,] -> int

[<System.Obsolete("Consider using Array2.create instead")>]
val make: len1:int -> len2:int -> 'a -> 'a[,]

/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array.
///
/// For non-zero-based arrays the basing on an input array will be propogated to the output
/// array.
val map: ('a -> 'b) -> 'a[,] -> 'b[,]

/// Build a new array whose elements are the same as the input array.
///
/// For non-zero-based arrays the basing on an input array will be propogated to the output
/// array.
val copy: 'a[,] -> 'a[,]

/// Build a new array whose elements are the same as the input array but
/// where a non-zero-based input array generates a corresponding zero-based 
/// output array.
val rebase: 'a[,] -> 'a[,]

/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array. The integer indices passed to the
/// function indicates the element being transformed.
///
/// For non-zero-based arrays the basing on an input array will be propogated to the output
/// array.
val mapi: (int -> int -> 'a -> 'b) -> 'a[,] -> 'b[,]

/// Set the value of an element in an array.  You can also 
/// use the syntax 'arr.[idx1,idx2] &lt;- e'
val set: 'a[,] -> idx1:int -> idx2:int -> 'a -> unit

/// Create an array where the entries are initially the
/// a "default" value. For .NET reference types this will
/// be "null".  For other types behaviour is undefined if 
/// you access an entry of the array before setting it.
val zero_create: len1:int -> len2:int -> 'a[,]

/// Create an array where the entries are initially the
/// a "default" value. For .NET reference types this will
/// be "null".  For other types behaviour is undefined if 
/// you access an entry of the array before setting it.
///
/// See notes on the Array2 module re. zero-basing.
val create_based: base1:int -> base2:int -> len1:int -> len2:int -> initial: 'a -> 'a[,]

/// Create an array where the entries are initially the
/// a "default" value. For .NET reference types this will
/// be "null".  For other types behaviour is undefined if 
/// you access an entry of the array before setting it.
///
/// See notes on the Array2 module re. zero-basing.
val zero_create_based: base1:int -> base2:int -> len1:int -> len2:int -> 'a[,]

/// Initialize a non-zero-based 2D array.
///
/// See notes on the Array2 module re. zero-basing.
val init_based: base1:int -> base2:int -> len1:int -> len2:int -> (int -> int -> 'a) -> 'a[,]

#endif

/// Pin the given array for the duration of a single call to the given function.  A native pointer to
/// the first element in the array is passed to the given function.  Cleanup the GCHandle associated with the 
/// pin when the function completes, even if an exception is raised.
[<Unverifiable>]
val inline pin: 'a[,] -> ('a nativeptr -> 'b) -> 'b

/// As for Array2.pin, except that the caller is responsible for calling Free on the returned GCHandle in order
/// to release the pin.
[<Unverifiable>]
val inline pin_unscoped: 'a[,] -> 'a nativeptr *  System.Runtime.InteropServices.GCHandle

/// Get the address of an element in the array
[<Unverifiable>]
val inline geta : 'a[,] -> int -> int -> 'a nativeptr
