(* (c) Microsoft Corporation. All rights reserved *)

(*F#
/// Diagnostics from the AbsIL toolkit.  You may also use this facility
/// for your own application.  You can reset the diagnostics stream to point elsewhere, or turn it
/// off altogether by setting it to 'None'.  The logging channel initally
/// points to stderr.  All functions call flush() automatically.
module Microsoft.Research.AbstractIL.Diagnostics
open Microsoft.Research.AbstractIL
open Microsoft.Research.AbstractIL.Internal 
F#*)

val getDiagnosticsChannel: unit -> out_channel option
val setDiagnosticsChannel: out_channel option -> unit
val dprintf0: (unit, out_channel, unit) format -> unit
val dprintf1: ('a -> unit, out_channel, unit) format -> 'a -> unit
val dprintf2: ('a -> 'b -> unit, out_channel, unit) format -> 'a -> 'b -> unit
val dprintf3: ('a -> 'b -> 'c -> unit, out_channel, unit) format -> 'a -> 'b -> 'c -> unit
val dprintf4: ('a -> 'b -> 'c -> 'd -> unit, out_channel, unit) format -> 'a -> 'b -> 'c -> 'd -> unit
val dprintf5: ('a -> 'b -> 'c -> 'd -> 'e -> unit, out_channel, unit) format -> 'a -> 'b -> 'c -> 'd -> 'e -> unit
val dprintf6: ('a -> 'b -> 'c -> 'd -> 'e -> 'f -> unit, out_channel, unit) format -> 'a -> 'b -> 'c -> 'd -> 'e -> 'f -> unit
val dprint_endline: string -> unit
val dprint_string: string -> unit

