(*==========================================================================
 * ResizeArray
 * 
 * (c) Microsoft Corporation 2005-2007.  
 *=========================================================================*)

#light

#if CLI_AT_MOST_1_1
#else


namespace Microsoft.FSharp.Collections

open System
open System.Collections.Generic
open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections

type ResizeArray<'a> = System.Collections.Generic.List<'a>

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
/// Generic operations on the type System.Collections.Generic.List, which is called ResizeArray in the F# libraries.
module ResizeArray :

    [<Obsolete("Consider using the type ResizeArray<_> instead")>]
    type 'a t = ResizeArray<'a>

    /// Return the length of the collection.  You can also use property arr.Length.
    val length: ResizeArray<'a> -> int

    /// Fetch an element from the collection.  You can also use the syntax arr.[idx].
    val get: ResizeArray<'a> -> int -> 'a

    /// Set the value of an element in the collection.  You can also use the syntax 'arr.[idx] &lt;- e'.
    val set: ResizeArray<'a> -> int -> 'a -> unit

    /// Create an array whose elements are all initially the given value.
    val create: int -> 'a -> ResizeArray<'a>
     
    /// Create an array by calling the given generator on each index.
    val init: int -> (int -> 'a) -> ResizeArray<'a>

    ///Build a new array that contains the elements of the first array followed by the elements of the second array
    val append: ResizeArray<'a> -> ResizeArray<'a> -> ResizeArray<'a>

    ///Build a new array that contains the elements of each of the given list of arrays
    val concat: ResizeArray<'a> list -> ResizeArray<'a>

    ///Build a new array that contains the given subrange specified by
    ///starting index and length.
    val sub: ResizeArray<'a> -> int -> int -> ResizeArray<'a>

    ///Build a new array that contains the elements of the given array
    val copy: ResizeArray<'a> -> ResizeArray<'a>

    ///Fill a range of the collection with the given element
    val fill: ResizeArray<'a> -> int -> int -> 'a -> unit

    ///Read a range of elements from the first array and write them into the second.
    val blit: ResizeArray<'a> -> int -> ResizeArray<'a> -> int -> int -> unit

    ///Build a list from the given array
    val to_list: ResizeArray<'a> -> 'a list

    ///Build an array from the given list
    val of_list: 'a list -> ResizeArray<'a>

    ///Apply a function to each element of the collection, threading an 'accumulator' argument
    ///through the computation. If the elements are "i0...iN" then computes "f (... (f s i0)...) iN"
    val fold_left: ('a -> 'b -> 'a) -> 'a -> ResizeArray<'b> -> 'a

    ///Apply a function to each element of the array, threading an 'accumulator' argument
    ///through the computation. If the elements are "i0...iN" then computes "f i0 (...(f iN s))".
    val fold_right: ('a -> 'b -> 'b) -> ResizeArray<'a> -> 'b -> 'b

    ///Apply the given function to each element of the array. 
    val iter: ('a -> unit) -> ResizeArray<'a> -> unit

    ///Build a new array whose elements are the results of applying the given function
    ///to each of the elements of the array.
    val map: ('a -> 'b) -> ResizeArray<'a> -> ResizeArray<'b>

    ///Apply the given function to two arrays simultaneously. The
    ///two arrays must have the same lengths, otherwise an Invalid_argument exception is
    ///raised.
    val iter2: ('a -> 'b -> unit) -> ResizeArray<'a> -> ResizeArray<'b> -> unit

    ///Build a new collection whose elements are the results of applying the given function
    ///to the corresponding elements of the two collections pairwise.  The two input
    ///arrays must have the same lengths.
    val map2: ('a -> 'b -> 'c) -> ResizeArray<'a> -> ResizeArray<'b> -> ResizeArray<'c>

    ///Apply the given function to each element of the array.  The integer passed to the
    ///function indicates the index of element.
    val iteri: (int -> 'a -> unit) -> ResizeArray<'a> -> unit

    ///Build a new array whose elements are the results of applying the given function
    ///to each of the elements of the array. The integer index passed to the
    ///function indicates the index of element being transformed.
    val mapi: (int -> 'a -> 'b) -> ResizeArray<'a> -> ResizeArray<'b>

    ///Test if any element of the array satisfies the given predicate.
    ///If the elements are "i0...iN" 
    ///then computes "p i0 or ... or p iN".
    val exists: ('a -> bool) -> ResizeArray<'a> -> bool

    ///Test if all elements of the array satisfy the given predicate.
    ///If the elements are "i0...iN" and "j0...jN"
    ///then computes "p i0 &amp;&amp; ... &amp;&amp; p iN".
    val for_all: ('a -> bool) -> ResizeArray<'a> -> bool

    ///Return a new collection containing only the elements of the collection
    ///for which the given predicate returns "true"
    val filter: ('a -> bool) -> ResizeArray<'a> -> ResizeArray<'a>

    ///Split the collection into two collections, containing the 
    ///elements for which the given predicate returns "true" and "false"
    ///respectively 
    val partition: ('a -> bool) -> ResizeArray<'a> -> ResizeArray<'a> * ResizeArray<'a>

    ///Apply the given function to each element of the array. Return
    ///the array comprised of the results "x" for each element where
    ///the function returns Some(x)
    val choose: ('a -> 'b option) -> ResizeArray<'a> -> ResizeArray<'b>

    ///Return the first element for which the given function returns "true".
    ///Raise Not_found if no such element exists.
    val find: ('a -> bool) -> ResizeArray<'a> -> 'a

    ///Return the first element for which the given function returns "true".
    ///Return None if no such element exists.
    val tryfind: ('a -> bool) -> ResizeArray<'a> -> 'a option

    ///Apply the given function to successive elements, returning the first
    ///result where function returns "Some(x)" for some x.
    val first: ('a -> 'b option) -> ResizeArray<'a> -> 'b option

    ///Combine the two arrays into an array of pairs. The two arrays must have equal lengths.
    val combine: ResizeArray<'a> -> ResizeArray<'b> -> ResizeArray<('a * 'b)>

    ///Split a list of pairs into two lists
    val split: ResizeArray<('a * 'b)> -> (ResizeArray<'a> * ResizeArray<'b>)

    ///Return a new array with the elements in reverse order
    val rev: ResizeArray<'a> -> ResizeArray<'a>


#endif
