// (c) Microsoft Corporation 2005-2007. 

module Microsoft.FSharp.Collections.Array3
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators

#if CLI_AT_LEAST_2_0

(* Define the primitive operations. *)
(* Note: the "type" syntax is for the type parameter for inline *)
(* polymorphic IL. This helps the compiler inline these fragments, *)
(* i.e. work out the correspondence between IL and F# type variables. *)
let length1 (arr: 'a[,,]) =  (# "ldlen.multi 3 0" arr : int #)  
let length2 (arr: 'a[,,]) =  (# "ldlen.multi 3 1" arr : int #)  
let length3 (arr: 'a[,,]) =  (# "ldlen.multi 3 2" arr : int #)  
let get (arr: 'a[,,]) (n1:int) (n2:int) (n3:int) =  (# "ldelem.multi 3 !0" type ('a) arr n1 n2 n3 : 'a #)  
let set (arr: 'a[,,]) (n1:int) (n2:int) (n3:int) (x:'a) =  (# "stelem.multi 3 !0" type ('a) arr n1 n2 n3 x #)  
let zero_create (n1:int) (n2:int) (n3:int) = (# "newarr.multi 3 !0" type ('a) n1 n2 n3 : 'a[,,] #)
let create (n1:int) (n2:int) (n3:int) (x:'a) =
  let arr = (zero_create n1 n2 n3 : 'a[,,]) in 
  for i = 0 to n1 - 1 do 
    for j = 0 to n2 - 1 do 
      for k = 0 to n3 - 1 do 
        (set arr i j k x)
      done;
    done;
  done;
  arr

let make (n1:int) (n2:int) (n3:int) (x:'a) = create n1 n2 n3 x
let init (n1:int) (n2:int) (n3:int) (f: int -> int -> int -> 'a) = 
  let arr = (zero_create n1 n2 n3 : 'a[,,])  in 
  for i = 0 to n1 - 1 do 
    for j = 0 to n2 - 1 do 
      for k = 0 to n3 - 1 do 
        set arr i j k (f i j k)
      done;
    done;
  done;
  arr

let iter (f : 'a -> unit) (arr:'a[,,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  let len3 = length3 arr in 
  for i = 0 to len1 - 1 do 
    for j = 0 to len2 - 1 do 
      for k = 0 to len3 - 1 do 
        f (get arr i j k)
      done;
    done;
  done

let map (f: 'a -> 'b) (arr:'a[,,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  let len3 = length3 arr in 
  let res = (zero_create len1 len2 len3 : 'b[,,]) in 
  for i = 0 to len1 - 1 do 
    for j = 0 to len2 - 1 do 
      for k = 0 to len3 - 1 do 
        set res i j k (f (get arr i j k))
      done;
    done;
  done;
  res

let iteri (f : int -> int -> int -> 'a -> unit) (arr:'a[,,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  let len3 = length3 arr in 
  for i = 0 to len1 - 1 do 
    for j = 0 to len2 - 1 do 
      for k = 0 to len3 - 1 do 
        f i j k (get arr i j k)
      done;
    done;
  done

let mapi (f: int -> int -> int -> 'a -> 'b) (arr:'a[,,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  let len3 = length3 arr in 
  let res = (zero_create len1 len2 len3 : 'b[,,]) in 
  for i = 0 to len1 - 1 do 
    for j = 0 to len2 - 1 do 
      for k = 0 to len3 - 1 do 
        set res i j k (f i j k (get arr i j k))
      done;
    done;
  done;
  res

#endif
