/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.PascalClassData;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavapEnvironment {
    public static final int PRIVATE = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE = 2;
    public static final int PUBLIC = 3;
    private static final int start = 0;
    private static final int cmdboot = 1;
    private static final int sunboot = 2;
    private static final int javaclass = 3;
    private static final int cmdextdir = 4;
    private static final int javaext = 5;
    private static final int cmdclasspath = 6;
    private static final int envclasspath = 7;
    private static final int javaclasspath = 8;
    private static final int currentdir = 9;
    boolean showLineAndLocal = false;
    int showAccess = 2;
    boolean showVerbose = false;
    String classPathString = null;
    String bootClassPathString = null;
    String extDirsString = null;
    boolean extDirflag;
    boolean nothingToDo = true;
    boolean showallAttr = false;
    boolean generateInclude = false;
    String classpath = null;
    String outputName = "java";
    ArrayList<String> excludePrefixes = new ArrayList();
    ArrayList<String> skelPrefixes = new ArrayList();

    public InputStream getFileInputStream(String Name) {
        InputStream fileInStream = null;
        int searchpath = 1;
        this.extDirflag = false;
        try {
            if (searchpath == 1) {
                if (this.bootClassPathString != null) {
                    this.classpath = this.bootClassPathString;
                    fileInStream = this.resolvefilename(Name);
                    if (fileInStream != null) {
                        return fileInStream;
                    }
                    searchpath = 4;
                } else {
                    searchpath = 2;
                }
            }
            if (searchpath == 2) {
                if (System.getProperty("sun.boot.class.path") != null) {
                    this.classpath = System.getProperty("sun.boot.class.path");
                    fileInStream = this.resolvefilename(Name);
                    if (fileInStream != null) {
                        return fileInStream;
                    }
                    searchpath = 4;
                } else {
                    searchpath = 3;
                }
            }
            if (searchpath == 3) {
                if (System.getProperty("java.class.path") != null) {
                    this.classpath = System.getProperty("java.class.path");
                    fileInStream = this.resolvefilename(Name);
                    if (fileInStream != null) {
                        return fileInStream;
                    }
                    searchpath = 4;
                } else {
                    searchpath = 4;
                }
            }
            if (searchpath == 4) {
                if (this.extDirsString != null) {
                    this.classpath = this.extDirsString;
                    this.extDirflag = true;
                    fileInStream = this.resolvefilename(Name);
                    if (fileInStream != null) {
                        return fileInStream;
                    }
                    searchpath = 6;
                    this.extDirflag = false;
                } else {
                    searchpath = 5;
                }
            }
            if (searchpath == 5) {
                if (System.getProperty("java.ext.dirs") != null) {
                    this.classpath = System.getProperty("java.ext.dirs");
                    this.extDirflag = true;
                    fileInStream = this.resolvefilename(Name);
                    if (fileInStream != null) {
                        return fileInStream;
                    }
                    searchpath = 6;
                    this.extDirflag = false;
                } else {
                    searchpath = 6;
                }
            }
            if (searchpath == 6) {
                if (this.classPathString != null) {
                    this.classpath = this.classPathString;
                    fileInStream = this.resolvefilename(Name);
                    if (fileInStream != null) {
                        return fileInStream;
                    }
                    searchpath = 8;
                } else {
                    searchpath = 7;
                }
            }
            if (searchpath == 7) {
                if (System.getProperty("env.class.path") != null) {
                    this.classpath = System.getProperty("env.class.path");
                    fileInStream = this.resolvefilename(Name);
                    if (fileInStream != null) {
                        return fileInStream;
                    }
                    searchpath = 8;
                } else {
                    searchpath = 8;
                }
            }
            if (searchpath == 8) {
                if ("application.home" == null) {
                    this.classpath = System.getProperty("java.class.path");
                    fileInStream = this.resolvefilename(Name);
                    if (fileInStream != null) {
                        return fileInStream;
                    }
                    searchpath = 9;
                } else {
                    searchpath = 9;
                }
            }
            if (searchpath == 9) {
                this.classpath = ".";
                fileInStream = this.resolvefilename(Name);
                if (fileInStream != null) {
                    return fileInStream;
                }
                this.error("Could not find " + Name);
                System.exit(1);
            }
        }
        catch (SecurityException excsec) {
            excsec.printStackTrace();
            this.error("fatal exception");
        }
        catch (NullPointerException excnull) {
            excnull.printStackTrace();
            this.error("fatal exception");
        }
        catch (IllegalArgumentException excill) {
            excill.printStackTrace();
            this.error("fatal exception");
        }
        return null;
    }

    public void error(String msg) {
        System.err.println("ERROR:" + msg);
    }

    public InputStream resolvefilename(String name) {
        String classname = String.valueOf(name.replace('.', '/')) + ".class";
        while (true) {
            InputStream instream;
            InputStream inputStream = instream = this.extDirflag ? this.resolveExdirFilename(classname) : this.resolveclasspath(classname);
            if (instream != null) {
                return instream;
            }
            int lastindex = classname.lastIndexOf(47);
            if (lastindex == -1) {
                return null;
            }
            classname = String.valueOf(classname.substring(0, lastindex)) + "$" + classname.substring(lastindex + 1);
        }
    }

    public InputStream resolveExdirFilename(String classname) {
        if (this.classpath.indexOf(File.pathSeparator) != -1) {
            StringTokenizer st = new StringTokenizer(this.classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                InputStream in = this.resolveExdirFilenamehelper(path, classname);
                if (in == null) continue;
                return in;
            }
        } else {
            return this.resolveExdirFilenamehelper(this.classpath, classname);
        }
        return null;
    }

    public InputStream resolveclasspath(String classname) {
        if (this.classpath.indexOf(File.pathSeparator) != -1) {
            StringTokenizer st = new StringTokenizer(this.classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                InputStream in = this.resolveclasspathhelper(path, classname);
                if (in == null) continue;
                return in;
            }
            return null;
        }
        return this.resolveclasspathhelper(this.classpath, classname);
    }

    public InputStream resolveExdirFilenamehelper(String path, String classname) {
        File fileobj = new File(path);
        if (fileobj.isDirectory()) {
            File[] filelist = fileobj.listFiles();
            int i = 0;
            while (i < filelist.length) {
                try {
                    if (filelist[i].toString().endsWith(".jar")) {
                        JarFile jfile = new JarFile(filelist[i]);
                        if (jfile.getEntry(classname) != null) {
                            InputStream filein = jfile.getInputStream(jfile.getEntry(classname));
                            int bytearraysize = filein.available();
                            byte[] b = new byte[bytearraysize];
                            int totalread = 0;
                            while (totalread < bytearraysize) {
                                totalread += filein.read(b, totalread, bytearraysize - totalread);
                            }
                            ByteArrayInputStream inbyte = new ByteArrayInputStream(b);
                            filein.close();
                            return inbyte;
                        }
                    } else {
                        String filename = String.valueOf(path) + "/" + classname;
                        File file = new File(filename);
                        if (file.isFile()) {
                            return new FileInputStream(file);
                        }
                    }
                }
                catch (FileNotFoundException fnexce) {
                    fnexce.printStackTrace();
                    this.error("cant read file");
                    this.error("fatal exception");
                }
                catch (IOException ioexc) {
                    ioexc.printStackTrace();
                    this.error("fatal exception");
                }
                ++i;
            }
        }
        return null;
    }

    public InputStream resolveclasspathhelper(String path, String classname) {
        File fileobj = new File(path);
        try {
            JarFile jfile;
            if (fileobj.isDirectory()) {
                String filename = String.valueOf(path) + "/" + classname;
                File file = new File(filename);
                if (file.isFile()) {
                    return new FileInputStream(file);
                }
            } else if (fileobj.isFile() && fileobj.toString().endsWith(".jar") && (jfile = new JarFile(fileobj)).getEntry(classname) != null) {
                InputStream filein = jfile.getInputStream(jfile.getEntry(classname));
                int bytearraysize = filein.available();
                byte[] b = new byte[bytearraysize];
                int totalread = 0;
                while (totalread < bytearraysize) {
                    totalread += filein.read(b, totalread, bytearraysize - totalread);
                }
                ByteArrayInputStream inbyte = new ByteArrayInputStream(b);
                filein.close();
                return inbyte;
            }
        }
        catch (FileNotFoundException fnexce) {
            fnexce.printStackTrace();
            this.error("cant read file");
            this.error("fatal exception");
        }
        catch (IOException ioexce) {
            ioexce.printStackTrace();
            this.error("fatal exception");
        }
        return null;
    }

    protected SortedSet<String> getJarEntries(String jarname) {
        TreeSet<String> res = new TreeSet<String>();
        try {
            JarFile jfile = new JarFile(jarname);
            Enumeration<JarEntry> entries = jfile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                int classpos = name.lastIndexOf(".class");
                if (classpos == -1 || PascalClassData.isInnerClass(name.substring(0, classpos)) || entry.isDirectory()) continue;
                res.add(name.substring(0, classpos));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    protected SortedSet<String> getDirEntries(File fileobj, boolean includeJarEntries) {
        TreeSet<String> res = new TreeSet<String>();
        File[] filelist = fileobj.listFiles();
        int i = 0;
        while (i < filelist.length) {
            String fname = filelist[i].toString();
            if (includeJarEntries && fname.endsWith(".jar")) {
                res.addAll(this.getJarEntries(fname));
            } else if (fname.endsWith(".class")) {
                int classpos = fname.lastIndexOf(".class");
                if (classpos != -1) {
                    fname = fname.substring(0, classpos);
                }
                if (!PascalClassData.isInnerClass(fname)) {
                    res.add(fname);
                }
            }
            ++i;
        }
        return res;
    }

    public SortedSet<String> getExdirEntries(String path) {
        File fileobj = new File(path);
        if (fileobj.isDirectory()) {
            return this.getDirEntries(fileobj, true);
        }
        return new TreeSet<String>();
    }

    public SortedSet<String> getClasspathEntries(String path) {
        File fileobj = new File(path);
        if (fileobj.isDirectory()) {
            return this.getDirEntries(fileobj, false);
        }
        if (fileobj.toString().endsWith(".jar")) {
            return this.getJarEntries(fileobj.toString());
        }
        return new TreeSet<String>();
    }

    public SortedSet<String> getAllExdirEntries() {
        TreeSet<String> res;
        if (this.classpath.indexOf(File.pathSeparator) != -1) {
            res = new TreeSet();
            StringTokenizer st = new StringTokenizer(this.classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                res.addAll(this.getExdirEntries(path));
            }
        } else {
            res = this.getExdirEntries(this.classpath);
        }
        return res;
    }

    public SortedSet<String> getAllClasspathEntries() {
        TreeSet<String> res;
        if (this.classpath.indexOf(File.pathSeparator) != -1) {
            res = new TreeSet();
            StringTokenizer st = new StringTokenizer(this.classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                res.addAll(this.getClasspathEntries(path));
            }
        } else {
            res = this.getClasspathEntries(this.classpath);
        }
        return res;
    }

    public SortedSet<String> getAllEntries() {
        if (this.extDirflag) {
            return this.getAllExdirEntries();
        }
        return this.getAllClasspathEntries();
    }

    public SortedSet<String> getClassesList() {
        TreeSet<String> res = new TreeSet<String>();
        int searchpath = 1;
        this.extDirflag = false;
        try {
            if (searchpath == 1) {
                if (this.bootClassPathString != null) {
                    this.classpath = this.bootClassPathString;
                    res.addAll(this.getAllEntries());
                    searchpath = 4;
                } else {
                    searchpath = 2;
                }
            }
            if (searchpath == 2) {
                if (System.getProperty("sun.boot.class.path") != null) {
                    this.classpath = System.getProperty("sun.boot.class.path");
                    res.addAll(this.getAllEntries());
                    searchpath = 4;
                } else {
                    searchpath = 3;
                }
            }
            if (searchpath == 3) {
                if (System.getProperty("java.class.path") != null) {
                    this.classpath = System.getProperty("java.class.path");
                    res.addAll(this.getAllEntries());
                    searchpath = 4;
                } else {
                    searchpath = 4;
                }
            }
            if (searchpath == 4) {
                if (this.extDirsString != null) {
                    this.classpath = this.extDirsString;
                    this.extDirflag = true;
                    res.addAll(this.getAllEntries());
                    searchpath = 6;
                    this.extDirflag = false;
                } else {
                    searchpath = 5;
                }
            }
            if (searchpath == 5) {
                if (System.getProperty("java.ext.dirs") != null) {
                    this.classpath = System.getProperty("java.ext.dirs");
                    this.extDirflag = true;
                    res.addAll(this.getAllEntries());
                    searchpath = 6;
                    this.extDirflag = false;
                } else {
                    searchpath = 6;
                }
            }
            if (searchpath == 6) {
                if (this.classPathString != null) {
                    this.classpath = this.classPathString;
                    res.addAll(this.getAllEntries());
                    searchpath = 8;
                } else {
                    searchpath = 7;
                }
            }
            if (searchpath == 7) {
                if (System.getProperty("env.class.path") != null) {
                    this.classpath = System.getProperty("env.class.path");
                    res.addAll(this.getAllEntries());
                    searchpath = 8;
                } else {
                    searchpath = 8;
                }
            }
            if (searchpath == 8) {
                if ("application.home" == null) {
                    this.classpath = System.getProperty("java.class.path");
                    res.addAll(this.getAllEntries());
                    searchpath = 9;
                } else {
                    searchpath = 9;
                }
            }
            if (searchpath == 9) {
                this.classpath = ".";
                res.addAll(this.getAllEntries());
            }
        }
        catch (SecurityException excsec) {
            excsec.printStackTrace();
            this.error("fatal exception");
        }
        catch (NullPointerException excnull) {
            excnull.printStackTrace();
            this.error("fatal exception");
        }
        catch (IllegalArgumentException excill) {
            excill.printStackTrace();
            this.error("fatal exception");
        }
        return res;
    }
}

