---
title: Specifications (specs)
---

# Fortran stdlib Specifications (specs)

This is an index/directory of the specifications (specs) for each new module/feature as described in the
[workflow document](../Workflow.html).

[TOC]

## Experimental Features & Modules

 - [ansi](./stdlib_ansi.html) - Terminal color and style escape sequences
 - [array](./stdlib_array.html) - Procedures for index manipulation and array handling
 - [ascii](./stdlib_ascii.html) - Procedures for handling ASCII characters
 - [constants](./stdlib_constants.html) - Constants
 - [bitsets](./stdlib_bitsets.html) - Bitset data types and procedures
 - [error](./stdlib_error.html) - Catching and handling errors
 - [hash](./stdlib_hash_procedures.html) - Hashing integer
 vectors or character strings
 - [hashmaps](./stdlib_hashmaps.html) - Hash maps/tables
 - [io](./stdlib_io.html) - Input/output helper & convenience
 - [kinds](./stdlib_kinds.html) - Kind parameters
 - [linalg](./stdlib_linalg.html) - Linear Algebra
 - [linalg_state_type](./stdlib_linalg_state_type.html) - Linear Algebra state and error handling 
 - [logger](./stdlib_logger.html) - Runtime logging system
 - [math](./stdlib_math.html) - General purpose mathematical functions
 - [optval](./stdlib_optval.html) - Fallback value for optional arguments
 - [quadrature](./stdlib_quadrature.html) - Numerical integration
 - [random](./stdlib_random.html) - Probability Distributions random number generator
 - [sorting](./stdlib_sorting.html) - Sorting of rank one arrays
 - [stats](./stdlib_stats.html) - Descriptive Statistics
 - [stats_distributions_uniform](./stdlib_stats_distribution_uniform.html) - Uniform Probability Distribution
 - [stats_distributions_normal](./stdlib_stats_distribution_normal.html) - Normal Probability Distribution
 - [stats_distributions_exponential](./stdlib_stats_distribution_exponential.html) - Exponential Probability Distribution
 - [string\_type](./stdlib_string_type.html) - Basic string support
 - [stringlist_type](./stdlib_stringlist_type.html) - 1-Dimensional list of strings
 - [strings](./stdlib_strings.html) - String handling and manipulation routines
 - [version](./stdlib_version.html) - Version information

## Released/Stable Features & Modules

 - (None yet)
