/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SQLPlusPlaceholderProvider {
    static final char DEFAULT_DEFINE_CHAR = '&';
    private static final char DEFAULT_ESCAPE_CHAR = '\\';
    private final Map<String, String> sqlplusPlaceholders = new HashMap<String, String>();
    private final Map<String, String> placeholderReplacements = new HashMap<String, String>();
    private boolean defineOn = true;
    private char defineChar = (char)38;
    private boolean verifyOn = true;
    private boolean escapeOn = true;
    private char escapeChar = (char)92;
    private int readAheadLimitAdjustment;
    private String suffix = "sql";
    private int lineSize = 80;

    public SQLPlusPlaceholderProvider(Map<String, String> placeholderReplacements, String user, String connectIdentifier, String oRelease, String oVersion) {
        this.placeholderReplacements.putAll(placeholderReplacements);
        this.sqlplusPlaceholders.put("_CONNECT_IDENTIFIER", connectIdentifier);
        this.sqlplusPlaceholders.put("_DATE", new SimpleDateFormat("dd-MMM-YY", Locale.ENGLISH).format(new Date()).toUpperCase(Locale.ENGLISH));
        this.sqlplusPlaceholders.put("_EDITOR", "");
        this.sqlplusPlaceholders.put("_O_RELEASE", oRelease);
        this.sqlplusPlaceholders.put("_O_VERSION", oVersion);
        this.sqlplusPlaceholders.put("_PRIVILEGE", "");
        this.sqlplusPlaceholders.put("_SQLPLUS_RELEASE", "1202000100");
        this.sqlplusPlaceholders.put("_USER", user);
        this.readAheadLimitAdjustment = this.computeReadAheadLimitAdjustment();
    }

    public Map<String, String> getPlaceholderReplacements() {
        HashMap<String, String> placeholderReplacements = new HashMap<String, String>(this.placeholderReplacements);
        placeholderReplacements.putAll(this.sqlplusPlaceholders);
        return placeholderReplacements;
    }

    private int computeReadAheadLimitAdjustment() {
        int maxPlaceholderLength = 1;
        int minReplacementLength = Integer.MAX_VALUE;
        for (Map.Entry<String, String> entry : this.getPlaceholderReplacements().entrySet()) {
            maxPlaceholderLength = Math.max(maxPlaceholderLength, 1 + entry.getKey().length());
            minReplacementLength = Math.min(minReplacementLength, entry.getValue().length());
        }
        return Math.max(maxPlaceholderLength - minReplacementLength, 0);
    }

    public void setDefineOn(boolean defineOn) {
        this.defineOn = defineOn;
        this.readAheadLimitAdjustment = this.computeReadAheadLimitAdjustment();
    }

    public void setDefineChar(char defineChar) {
        this.defineChar = defineChar;
        this.readAheadLimitAdjustment = this.computeReadAheadLimitAdjustment();
    }

    public void setEscapeOn(boolean escapeOn) {
        this.escapeOn = escapeOn;
        this.escapeChar = (char)92;
        this.readAheadLimitAdjustment = this.computeReadAheadLimitAdjustment();
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeOn = true;
        this.escapeChar = escapeChar;
        this.readAheadLimitAdjustment = this.computeReadAheadLimitAdjustment();
    }

    public void define(String key, String value) {
        this.sqlplusPlaceholders.put(key.toLowerCase(Locale.ENGLISH), value);
    }

    public void undefine(String key) {
        this.sqlplusPlaceholders.remove(key.toLowerCase(Locale.ENGLISH));
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int getLineSize() {
        return this.lineSize;
    }

    public void setLineSize(int lineSize) {
        this.lineSize = lineSize;
    }

    public boolean isDefineOn() {
        return this.defineOn;
    }

    public char getDefineChar() {
        return this.defineChar;
    }

    public boolean isEscapeOn() {
        return this.escapeOn;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public boolean isVerifyOn() {
        return this.verifyOn;
    }

    public void setVerifyOn(boolean verifyOn) {
        this.verifyOn = verifyOn;
    }

    public int getReadAheadLimitAdjustment() {
        return this.readAheadLimitAdjustment;
    }
}

