/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.classpath;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.classpath.ClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.DefaultUrlResolver;
import org.flywaydb.core.internal.scanner.classpath.FileSystemClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.JarFileClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.OsgiClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.scanner.classpath.UrlResolver;
import org.flywaydb.core.internal.scanner.classpath.jboss.JBossVFSv2UrlResolver;
import org.flywaydb.core.internal.scanner.classpath.jboss.JBossVFSv3ClassPathLocationScanner;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.UrlUtils;

public class ClassPathScanner<I>
implements ResourceAndClassScanner<I> {
    private static final Log LOG = LogFactory.getLog(ClassPathScanner.class);
    private final Class<I> implementedInterface;
    private final ClassLoader classLoader;
    private final Location location;
    private final Set<LoadableResource> resources = new TreeSet<LoadableResource>();
    private final Map<Location, List<URL>> locationUrlCache = new HashMap<Location, List<URL>>();
    private final LocationScannerCache locationScannerCache;
    private final ResourceNameCache resourceNameCache;

    public ClassPathScanner(Class<I> implementedInterface, ClassLoader classLoader, Charset encoding, Location location, ResourceNameCache resourceNameCache, LocationScannerCache locationScannerCache) {
        this.implementedInterface = implementedInterface;
        this.classLoader = classLoader;
        this.location = location;
        this.resourceNameCache = resourceNameCache;
        this.locationScannerCache = locationScannerCache;
        LOG.debug("Scanning for classpath resources at '" + location + "' ...");
        for (String resourceName : this.findResourceNames()) {
            this.resources.add(new ClassPathResource(location, resourceName, classLoader, encoding));
            LOG.debug("Found resource: " + resourceName);
        }
    }

    @Override
    public Collection<LoadableResource> scanForResources() {
        return this.resources;
    }

    @Override
    public Collection<Class<? extends I>> scanForClasses() {
        LOG.debug("Scanning for classes at " + this.location);
        ArrayList<Class<I>> classes = new ArrayList<Class<I>>();
        for (LoadableResource resource : this.resources) {
            Class<I> clazz;
            if (!resource.getAbsolutePath().endsWith(".class") || (clazz = ClassUtils.loadClass(this.implementedInterface, this.toClassName(resource.getAbsolutePath()), this.classLoader)) == null) continue;
            classes.add(clazz);
        }
        return classes;
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findResourceNames() {
        boolean isClassPathRoot;
        TreeSet<String> resourceNames = new TreeSet<String>();
        List<URL> locationUrls = this.getLocationUrlsForPath(this.location);
        for (URL locationUrl : locationUrls) {
            LOG.debug("Scanning URL: " + locationUrl.toExternalForm());
            UrlResolver urlResolver = this.createUrlResolver(locationUrl.getProtocol());
            URL resolvedUrl = urlResolver.toStandardJavaUrl(locationUrl);
            String protocol = resolvedUrl.getProtocol();
            ClassPathLocationScanner classPathLocationScanner = this.createLocationScanner(protocol);
            if (classPathLocationScanner == null) {
                String scanRoot = UrlUtils.toFilePath(resolvedUrl);
                LOG.warn("Unable to scan location: " + scanRoot + " (unsupported protocol: " + protocol + ")");
                continue;
            }
            Set<String> names = this.resourceNameCache.get(classPathLocationScanner, resolvedUrl);
            if (names == null) {
                names = classPathLocationScanner.findResourceNames(this.location.getPath(), resolvedUrl);
                this.resourceNameCache.put(classPathLocationScanner, resolvedUrl, names);
            }
            resourceNames.addAll(names);
        }
        boolean locationResolved = !locationUrls.isEmpty();
        boolean bl = isClassPathRoot = this.location.isClassPath() && "".equals(this.location.getPath());
        if ((!locationResolved || isClassPathRoot) && this.classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)this.classLoader;
            for (URL url : urlClassLoader.getURLs()) {
                JarFile jarFile;
                if (!"file".equals(url.getProtocol()) || !url.getPath().endsWith(".jar") || url.getPath().matches(".*" + Pattern.quote("/jre/lib/") + ".*")) continue;
                try {
                    try {
                        jarFile = new JarFile(url.toURI().getSchemeSpecificPart());
                    }
                    catch (URISyntaxException ex) {
                        jarFile = new JarFile(url.getPath().substring("file:".length()));
                    }
                }
                catch (IOException | SecurityException e) {
                    LOG.warn("Skipping unloadable jar file: " + url + " (" + e.getMessage() + ")");
                    continue;
                }
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String entryName = entries.nextElement().getName();
                        if (!entryName.startsWith(this.location.getPath())) continue;
                        locationResolved = true;
                        resourceNames.add(entryName);
                    }
                }
                finally {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!locationResolved) {
            LOG.warn("Unable to resolve location " + this.location + ". Note this warning will become an error in Flyway 7.");
        }
        return resourceNames;
    }

    private List<URL> getLocationUrlsForPath(Location location) {
        if (this.locationUrlCache.containsKey(location)) {
            return this.locationUrlCache.get(location);
        }
        LOG.debug("Determining location urls for " + location + " using ClassLoader " + this.classLoader + " ...");
        ArrayList<URL> locationUrls = new ArrayList<URL>();
        if (this.classLoader.getClass().getName().startsWith("com.ibm")) {
            try {
                Enumeration<URL> urls = this.classLoader.getResources(location.getPath() + "/flyway.location");
                if (!urls.hasMoreElements()) {
                    LOG.warn("Unable to resolve location " + location + " (ClassLoader: " + this.classLoader + ") On WebSphere an empty file named flyway.location must be present on the classpath location for WebSphere to find it!\nNote this warning will become an error in Flyway 7.");
                }
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    locationUrls.add(new URL(UrlUtils.decodeURL(url.toExternalForm()).replace("/flyway.location", "")));
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to resolve location " + location + " (ClassLoader: " + this.classLoader + ") On WebSphere an empty file named flyway.location must be present on the classpath location for WebSphere to find it!\nNote this warning will become an error in Flyway 7.");
            }
        } else {
            try {
                Enumeration<URL> urls = this.classLoader.getResources(location.getPath());
                while (urls.hasMoreElements()) {
                    locationUrls.add(urls.nextElement());
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to resolve location " + location + " (ClassLoader: " + this.classLoader + "): " + e.getMessage() + "\nNote this warning will become an error in Flyway 7.");
            }
        }
        this.locationUrlCache.put(location, locationUrls);
        return locationUrls;
    }

    private UrlResolver createUrlResolver(String protocol) {
        if (new FeatureDetector(this.classLoader).isJBossVFSv2Available() && protocol.startsWith("vfs")) {
            return new JBossVFSv2UrlResolver();
        }
        return new DefaultUrlResolver();
    }

    private ClassPathLocationScanner createLocationScanner(String protocol) {
        if (this.locationScannerCache.containsKey(protocol)) {
            return this.locationScannerCache.get(protocol);
        }
        if ("file".equals(protocol)) {
            FileSystemClassPathLocationScanner locationScanner = new FileSystemClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap<URL, Set<String>>());
            return locationScanner;
        }
        if ("jar".equals(protocol) || this.isTomcat(protocol) || this.isWebLogic(protocol) || this.isWebSphere(protocol)) {
            String separator = this.isTomcat(protocol) ? "*/" : "!/";
            JarFileClassPathLocationScanner locationScanner = new JarFileClassPathLocationScanner(separator);
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap<URL, Set<String>>());
            return locationScanner;
        }
        FeatureDetector featureDetector = new FeatureDetector(this.classLoader);
        if (featureDetector.isJBossVFSv3Available() && "vfs".equals(protocol)) {
            JBossVFSv3ClassPathLocationScanner locationScanner = new JBossVFSv3ClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap<URL, Set<String>>());
            return locationScanner;
        }
        if (featureDetector.isOsgiFrameworkAvailable() && (this.isFelix(protocol) || this.isEquinox(protocol))) {
            OsgiClassPathLocationScanner locationScanner = new OsgiClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap<URL, Set<String>>());
            return locationScanner;
        }
        return null;
    }

    private boolean isEquinox(String protocol) {
        return "bundleresource".equals(protocol);
    }

    private boolean isFelix(String protocol) {
        return "bundle".equals(protocol);
    }

    private boolean isWebSphere(String protocol) {
        return "wsjar".equals(protocol);
    }

    private boolean isWebLogic(String protocol) {
        return "zip".equals(protocol);
    }

    private boolean isTomcat(String protocol) {
        return "war".equals(protocol);
    }
}

