/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;

public class DryRunCallback
implements Callback {
    private final DryRunStatementInterceptor dryRunStatementInterceptor;

    public DryRunCallback(DryRunStatementInterceptor dryRunStatementInterceptor) {
        this.dryRunStatementInterceptor = dryRunStatementInterceptor;
    }

    @Override
    public boolean supports(Event event, Context context) {
        switch (event) {
            case BEFORE_CLEAN: 
            case BEFORE_MIGRATE: 
            case BEFORE_EACH_MIGRATE: 
            case BEFORE_UNDO: 
            case BEFORE_EACH_UNDO: 
            case BEFORE_VALIDATE: 
            case BEFORE_BASELINE: 
            case BEFORE_REPAIR: 
            case BEFORE_INFO: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canHandleInTransaction(Event event, Context context) {
        return true;
    }

    @Override
    public void handle(Event event, Context context) {
        MigrationInfo info = context.getMigrationInfo();
        switch (event) {
            case BEFORE_CLEAN: {
                this.dryRunStatementInterceptor.interceptCommand("clean");
                return;
            }
            case BEFORE_MIGRATE: {
                this.dryRunStatementInterceptor.interceptCommand("migrate");
                return;
            }
            case BEFORE_EACH_MIGRATE: {
                this.dryRunStatementInterceptor.interceptCommand("migrate -> " + (info.getVersion() == null ? info.getDescription() + " [repeatable]" : "v" + info.getVersion()));
                return;
            }
            case BEFORE_UNDO: {
                this.dryRunStatementInterceptor.interceptCommand("undo");
                return;
            }
            case BEFORE_EACH_UNDO: {
                this.dryRunStatementInterceptor.interceptCommand("undo -> v" + info.getVersion());
                return;
            }
            case BEFORE_VALIDATE: {
                this.dryRunStatementInterceptor.interceptCommand("validate");
                return;
            }
            case BEFORE_BASELINE: {
                this.dryRunStatementInterceptor.interceptCommand("baseline");
                return;
            }
            case BEFORE_REPAIR: {
                this.dryRunStatementInterceptor.interceptCommand("repair");
                return;
            }
            case BEFORE_INFO: {
                this.dryRunStatementInterceptor.interceptCommand("info");
                return;
            }
        }
    }
}

