/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.util.List;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;

public class SQLPlusPromptParsedSqlStatement
extends AbstractSQLPlusParsedSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusPromptParsedSqlStatement.class);
    private final String transformedSql;

    public SQLPlusPromptParsedSqlStatement(int pos, int line, int col, String sql, List<Token> tokens) {
        super(pos, line, col, sql);
        List<Token> filteredTokens = this.filterTokens(tokens);
        String content = sql.replaceFirst(filteredTokens.get(0).getRawText(), "");
        this.transformedSql = content.length() > 0 && content.charAt(0) == ' ' ? content.substring(1) : content;
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        LOG.info(this.transformSql());
        return new Results();
    }

    String transformSql() {
        return this.transformedSql;
    }
}

