/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;
import org.firebirdsql.jdbc.FirebirdDriver;
import org.firebirdsql.logging.LoggerFactory;

public class FBDriver
implements FirebirdDriver {
    private static final org.firebirdsql.logging.Logger log = LoggerFactory.getLogger(FBDriver.class);
    public static final String CHARSET = "charSet";
    public static final String USE_TRANSLATION = "useTranslation";
    public static final String USER = "user";
    public static final String USER_NAME = "user_name";
    public static final String PASSWORD = "password";
    public static final String DATABASE = "database";
    public static final String BLOB_BUFFER_LENGTH = "blob_buffer_length";
    public static final String TPB_MAPPING = "tpb_mapping";
    private final Map<FBConnectionProperties, SoftReference<FBDataSource>> mcfToDataSourceMap = new ConcurrentHashMap<FBConnectionProperties, SoftReference<FBDataSource>>();
    private final ReferenceQueue<FBDataSource> dataSourceReferenceQueue = new ReferenceQueue();
    private final Object createDataSourceLock = new Object();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        GDSType type = GDSFactory.getTypeForProtocol(url);
        if (type == null) {
            return null;
        }
        Properties mergedProperties = FBDriver.mergeProperties(url, info);
        Map<String, String> normalizedInfo = FBDriverPropertyManager.normalize(mergedProperties);
        try {
            int qMarkIndex = url.indexOf(63);
            if (qMarkIndex != -1) {
                url = url.substring(0, qMarkIndex);
            }
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
            String databaseURL = GDSFactory.getDatabasePath(type, url);
            mcf.setDatabase(databaseURL);
            for (Map.Entry<String, String> entry : normalizedInfo.entrySet()) {
                mcf.setNonStandardProperty(entry.getKey(), entry.getValue());
            }
            FBTpbMapper.processMapping(mcf, mergedProperties);
            mcf = mcf.canonicalize();
            FBDataSource dataSource = this.createDataSource(mcf);
            return dataSource.getConnection(mcf.getUserName(), mcf.getPassword());
        }
        catch (ResourceException | GDSException resex) {
            throw new FBSQLException((Exception)resex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FBDataSource createDataSource(FBManagedConnectionFactory mcf) throws ResourceException {
        FBConnectionProperties cacheKey = mcf.getCacheKey();
        FBDataSource dataSource = this.dataSourceFromCache(cacheKey);
        if (dataSource != null) {
            return dataSource;
        }
        Object object = this.createDataSourceLock;
        synchronized (object) {
            dataSource = this.dataSourceFromCache(cacheKey);
            if (dataSource == null) {
                dataSource = (FBDataSource)mcf.createConnectionFactory();
                this.mcfToDataSourceMap.put(cacheKey, new SoftReference<FBDataSource>(dataSource, this.dataSourceReferenceQueue));
            }
        }
        this.cleanDataSourceCache();
        return dataSource;
    }

    private void cleanDataSourceCache() {
        Reference<FBDataSource> reference;
        while ((reference = this.dataSourceReferenceQueue.poll()) != null) {
            this.mcfToDataSourceMap.values().remove(reference);
        }
    }

    private FBDataSource dataSourceFromCache(FBConnectionProperties cacheKey) {
        SoftReference<FBDataSource> dataSourceReference = this.mcfToDataSourceMap.get(cacheKey);
        return dataSourceReference != null ? dataSourceReference.get() : null;
    }

    @Override
    public FirebirdConnection connect(FirebirdConnectionProperties properties) throws SQLException {
        GDSType type = GDSType.getType(properties.getType());
        if (type == null) {
            type = GDSFactory.getDefaultGDSType();
        }
        try {
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
            mcf = mcf.canonicalize();
            FBDataSource dataSource = this.createDataSource(mcf);
            return (FirebirdConnection)dataSource.getConnection(mcf.getUserName(), mcf.getPassword());
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public FirebirdConnectionProperties newConnectionProperties() {
        return new FBConnectionProperties();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        for (String protocol : GDSFactory.getSupportedProtocols()) {
            if (!url.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return FBDriverPropertyManager.getDriverPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new FBDriverNotCapableException("Method getParentLogger() not supported");
    }

    private static Properties mergeProperties(String jdbcUrl, Properties connectionProperties) {
        Properties mergedProperties = new Properties();
        if (connectionProperties != null) {
            for (String propertyName : connectionProperties.stringPropertyNames()) {
                mergedProperties.setProperty(propertyName, connectionProperties.getProperty(propertyName));
            }
        }
        FBDriver.convertUrlParams(jdbcUrl, mergedProperties);
        return mergedProperties;
    }

    private static void convertUrlParams(String url, Properties info) {
        if (url == null) {
            return;
        }
        int iQuestionMark = url.indexOf("?");
        if (iQuestionMark == -1) {
            return;
        }
        String propString = url.substring(iQuestionMark + 1);
        StringTokenizer st = new StringTokenizer(propString, "&;");
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            int iIs = propertyString.indexOf("=");
            if (iIs > -1) {
                String property = propertyString.substring(0, iIs);
                String value = propertyString.substring(iIs + 1);
                info.setProperty(property, value);
                continue;
            }
            info.setProperty(propertyString, "");
        }
    }

    static {
        try {
            DriverManager.registerDriver(new FBDriver());
        }
        catch (Exception ex) {
            log.error("Could not register with driver manager", ex);
        }
    }
}

