/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.util.AsciiTable;
import org.flywaydb.core.internal.util.DateUtils;

public class MigrationInfoDumper {
    private MigrationInfoDumper() {
    }

    public static String dumpToAsciiTable(MigrationInfo[] migrationInfos) {
        Set<MigrationVersion> undoableVersions = MigrationInfoDumper.getUndoableVersions(migrationInfos);
        migrationInfos = MigrationInfoDumper.removeAvailableUndos(migrationInfos);
        List<String> columns = Arrays.asList("Category", "Version", "Description", "Type", "Installed On", "State", "Undoable");
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            List<String> row = Arrays.asList(MigrationInfoDumper.getCategory(migrationInfo), MigrationInfoDumper.getVersionStr(migrationInfo), migrationInfo.getDescription(), migrationInfo.getType().name(), DateUtils.formatDateAsIsoString(migrationInfo.getInstalledOn()), migrationInfo.getState().getDisplayName(), MigrationInfoDumper.getUndoableStatus(migrationInfo, undoableVersions));
            rows.add(row);
        }
        return new AsciiTable(columns, rows, true, "", "No migrations found").render();
    }

    static String getCategory(MigrationInfo migrationInfo) {
        if (migrationInfo.getType().isSynthetic()) {
            return "";
        }
        if (migrationInfo.getVersion() == null) {
            return "Repeatable";
        }
        if (migrationInfo.getType().isUndo()) {
            return "Undo";
        }
        return "Versioned";
    }

    private static String getVersionStr(MigrationInfo migrationInfo) {
        return migrationInfo.getVersion() == null ? "" : migrationInfo.getVersion().toString();
    }

    private static String getUndoableStatus(MigrationInfo migrationInfo, Set<MigrationVersion> undoableVersions) {
        if (migrationInfo.getVersion() != null && !migrationInfo.getType().isUndo() && !migrationInfo.getState().equals((Object)MigrationState.UNDONE)) {
            if (!migrationInfo.getState().isFailed() && undoableVersions.contains(migrationInfo.getVersion())) {
                return "Yes";
            }
            return "No";
        }
        return "";
    }

    private static Set<MigrationVersion> getUndoableVersions(MigrationInfo[] migrationInfos) {
        HashSet<MigrationVersion> result = new HashSet<MigrationVersion>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            if (!migrationInfo.getType().isUndo()) continue;
            result.add(migrationInfo.getVersion());
        }
        return result;
    }

    private static MigrationInfo[] removeAvailableUndos(MigrationInfo[] migrationInfos) {
        ArrayList<MigrationInfo> result = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            if (migrationInfo.getState().equals((Object)MigrationState.AVAILABLE)) continue;
            result.add(migrationInfo);
        }
        return result.toArray(new MigrationInfo[0]);
    }
}

