/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.time.format.DateTimeFormatter;
import java.util.Map;

abstract class SQLServerBulkCommon
implements ISQLServerBulkRecord {
    protected String[] columnNames = null;
    protected Map<Integer, ColumnMetadata> columnMetadata;
    protected DateTimeFormatter dateTimeFormatter = null;
    protected DateTimeFormatter timeFormatter = null;

    SQLServerBulkCommon() {
    }

    @Override
    public void addColumnMetadata(int positionInSource, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) throws SQLServerException {
        this.addColumnMetadataInternal(positionInSource, name, jdbcType, precision, scale, dateTimeFormatter);
    }

    @Override
    public void addColumnMetadata(int positionInSource, String name, int jdbcType, int precision, int scale) throws SQLServerException {
        this.addColumnMetadataInternal(positionInSource, name, jdbcType, precision, scale, null);
    }

    void addColumnMetadataInternal(int positionInSource, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) throws SQLServerException {
    }

    @Override
    public void setTimestampWithTimezoneFormat(String dateTimeFormat) {
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimeFormat);
    }

    @Override
    public void setTimestampWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public void setTimeWithTimezoneFormat(String timeFormat) {
        this.timeFormatter = DateTimeFormatter.ofPattern(timeFormat);
    }

    @Override
    public void setTimeWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
        this.timeFormatter = dateTimeFormatter;
    }

    protected void throwInvalidArgument(String argument) throws SQLServerException {
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] msgArgs = new Object[]{argument};
        SQLServerException.makeFromDriverError(null, null, form.format(msgArgs), null, false);
    }

    protected void checkDuplicateColumnName(int positionInTable, String colName) throws SQLServerException {
        if (null != colName && colName.trim().length() != 0) {
            for (Map.Entry<Integer, ColumnMetadata> entry : this.columnMetadata.entrySet()) {
                if (null == entry || entry.getKey() == positionInTable || null == entry.getValue() || !colName.trim().equalsIgnoreCase(entry.getValue().columnName)) continue;
                throw new SQLServerException(SQLServerException.getErrString("R_BulkDataDuplicateColumn"), null);
            }
        }
    }

    protected class ColumnMetadata {
        String columnName;
        int columnType;
        int precision;
        int scale;
        DateTimeFormatter dateTimeFormatter = null;

        ColumnMetadata(String name, int type, int precision, int scale, DateTimeFormatter dateTimeFormatter) {
            this.columnName = name;
            this.columnType = type;
            this.precision = precision;
            this.scale = scale;
            this.dateTimeFormatter = dateTimeFormatter;
        }
    }
}

