/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.errorhandler.Context;
import org.flywaydb.core.api.errorhandler.Error;
import org.flywaydb.core.api.errorhandler.ErrorHandler;
import org.flywaydb.core.api.errorhandler.Warning;

public class ErrorHandlerCallback
implements Callback {
    private final ErrorHandler errorHandler;

    public ErrorHandlerCallback(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public boolean supports(Event event, org.flywaydb.core.api.callback.Context context) {
        return event == Event.AFTER_EACH_MIGRATE_STATEMENT || event == Event.AFTER_EACH_MIGRATE_STATEMENT_ERROR || event == Event.AFTER_EACH_UNDO_STATEMENT || event == Event.AFTER_EACH_UNDO_STATEMENT_ERROR;
    }

    @Override
    public boolean canHandleInTransaction(Event event, org.flywaydb.core.api.callback.Context context) {
        return true;
    }

    @Override
    public void handle(Event event, final org.flywaydb.core.api.callback.Context context) {
        context.getStatement().setSuppressErrors(this.errorHandler.handle(new Context(){

            @Override
            public List<Warning> getWarnings() {
                ArrayList<Warning> result = new ArrayList<Warning>();
                for (final org.flywaydb.core.api.callback.Warning warning : context.getStatement().getWarnings()) {
                    result.add(new Warning(){

                        @Override
                        public int getCode() {
                            return warning.getCode();
                        }

                        @Override
                        public String getState() {
                            return warning.getState();
                        }

                        @Override
                        public String getMessage() {
                            return warning.getMessage();
                        }
                    });
                }
                return result;
            }

            @Override
            public List<Error> getErrors() {
                ArrayList<Error> result = new ArrayList<Error>();
                for (final org.flywaydb.core.api.callback.Error error : context.getStatement().getErrors()) {
                    result.add(new Error(){

                        @Override
                        public int getCode() {
                            return error.getCode();
                        }

                        @Override
                        public String getState() {
                            return error.getState();
                        }

                        @Override
                        public String getMessage() {
                            return error.getMessage();
                        }
                    });
                }
                return result;
            }
        }));
    }
}

