/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLServerSqlStatementBuilder
extends SqlStatementBuilder {
    private static final Pattern KEYWORDS_BEFORE_STRING_LITERAL_REGEX = Pattern.compile("^(LIKE|AS)('.*)");
    private static final Pattern KEYWORDS_AFTER_STRING_LITERAL_REGEX = Pattern.compile("(.*')(LIKE|AS)$");
    private static final Pattern NON_TRANSACTIONAL_STATEMENT_REGEX = Pattern.compile("^((BACKUP|RESTORE|RECONFIGURE|(CREATE|DROP|ALTER) (DATABASE|FULLTEXT INDEX))|(EXEC SP_ADDSUBSCRIPTION))( .*)?");
    private String statementStart = "";

    public SQLServerSqlStatementBuilder() {
        super(Delimiter.GO);
    }

    @Override
    protected void applyStateChanges(String line) {
        super.applyStateChanges(line);
        if (!this.executeInTransaction || !this.hasNonCommentPart()) {
            return;
        }
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 3) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
            this.statementStart = StringUtils.collapseWhitespace(this.statementStart);
        }
        if (NON_TRANSACTIONAL_STATEMENT_REGEX.matcher(this.statementStart).matches() || !this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && !this.insideMultiLineComment && NON_TRANSACTIONAL_STATEMENT_REGEX.matcher(line).matches()) {
            this.executeInTransaction = false;
        }
    }

    @Override
    protected String cleanToken(String token) {
        Matcher afterMatcher;
        if (token.startsWith("N'")) {
            return token.substring(token.indexOf("'"));
        }
        Matcher beforeMatcher = KEYWORDS_BEFORE_STRING_LITERAL_REGEX.matcher(token);
        if (beforeMatcher.find()) {
            token = beforeMatcher.group(2);
        }
        if ((afterMatcher = KEYWORDS_AFTER_STRING_LITERAL_REGEX.matcher(token)).find()) {
            token = afterMatcher.group(1);
        }
        return token;
    }
}

