/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.oracle.OracleResults;
import org.flywaydb.core.internal.database.oracle.pro.ServerOutputFormat;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.sqlscript.DefaultSqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.AsciiTable;
import org.flywaydb.core.internal.util.StringUtils;

public class OracleSqlScriptExecutor
extends DefaultSqlScriptExecutor {
    private static final Log LOG = LogFactory.getLog(OracleSqlScriptExecutor.class);
    private boolean heading = true;
    private boolean serverOutput = false;
    private String serverOutputSize = "UNLIMITED";
    private ServerOutputFormat serverOutputFormat = ServerOutputFormat.WORD_WRAPPED;
    private int lineSize = 80;
    private boolean suppressErrors = false;
    private String nullText = "";

    public OracleSqlScriptExecutor(JdbcTemplate jdbcTemplate, CallbackExecutor callbackExecutor, boolean undo, boolean batch, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(jdbcTemplate, callbackExecutor, undo, batch, dryRunStatementInterceptor);
    }

    @Override
    protected void handleException(Results results, SqlScript sqlScript, SqlStatement sqlStatement) {
        if (this.suppressErrors) {
            for (Error error : results.getErrors()) {
                LOG.warn("DB error ignored (Code: " + error.getCode() + ", State: " + error.getState() + "): " + error.getMessage());
            }
            return;
        }
        super.handleException(results, sqlScript, sqlStatement);
    }

    @Override
    protected void handleResults(Results results, JdbcTemplate jdbcTemplate) {
        if (results instanceof OracleResults) {
            OracleResults oracleResults = (OracleResults)results;
            if (oracleResults.getLineSize() != null) {
                this.lineSize = oracleResults.getLineSize();
            }
            if (oracleResults.getServerOutputSize() != null) {
                this.serverOutputSize = oracleResults.getServerOutputSize();
            }
            if (oracleResults.getServerOutputFormat() != null) {
                this.serverOutputFormat = oracleResults.getServerOutputFormat();
            }
            if (oracleResults.getServerOutput() != null) {
                this.serverOutput = oracleResults.getServerOutput();
            }
            if (oracleResults.getSuppressErrors() != null) {
                this.suppressErrors = oracleResults.getSuppressErrors();
            }
            if (oracleResults.getNullText() != null) {
                this.nullText = oracleResults.getNullText();
            }
            if (oracleResults.getHeading() != null) {
                this.heading = oracleResults.getHeading();
            }
        }
        if (this.serverOutput) {
            block5: for (String line : this.getServerOutput(jdbcTemplate)) {
                switch (this.serverOutputFormat) {
                    case WRAPPED: {
                        LOG.info("DB: " + StringUtils.wrap(line, this.lineSize));
                        continue block5;
                    }
                    case WORD_WRAPPED: {
                        LOG.info("DB: " + StringUtils.wordWrap(line, this.lineSize));
                        continue block5;
                    }
                    case TRUNCATED: {
                        LOG.info("DB: " + StringUtils.trimOrPad(line, this.lineSize).trim());
                        continue block5;
                    }
                }
                throw new FlywayException("Unknown SERVEROUTPUT FORMMAT: " + (Object)((Object)this.serverOutputFormat));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getServerOutput(JdbcTemplate jdbcTemplate) {
        ArrayList<String> result = new ArrayList<String>();
        CallableStatement stmt = null;
        try {
            stmt = jdbcTemplate.getConnection().prepareCall("DECLARE   num INTEGER := 65536;BEGIN   dbms_output.get_lines(?, num);END;");
            stmt.registerOutParameter(1, 2003, "DBMSOUTPUT_LINESARRAY");
            stmt.execute();
            Array array = null;
            try {
                array = stmt.getArray(1);
                for (Object line : (Object[])array.getArray()) {
                    if (line == null) continue;
                    result.add(line.toString());
                }
            }
            finally {
                if (array != null) {
                    array.free();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new FlywaySqlException("Unable to get server output", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        return result;
    }

    @Override
    protected void handleResult(Result result) {
        LOG.info(new AsciiTable(result.getColumns(), result.getData(), this.heading, this.nullText, "No rows returned").render());
    }

    public boolean isServerOutput() {
        return this.serverOutput;
    }

    public String getServerOutputSize() {
        return this.serverOutputSize;
    }

    public ServerOutputFormat getServerOutputFormat() {
        return this.serverOutputFormat;
    }
}

