/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.hsqldb;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBConnection;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBSqlStatementBuilder;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.sqlscript.AbstractSqlStatementBuilderFactory;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;

public class HSQLDBDatabase
extends Database<HSQLDBConnection> {
    public HSQLDBDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected HSQLDBConnection getConnection(Connection connection) {
        return new HSQLDBConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 1 || this.majorVersion == 1 && this.minorVersion < 8) {
            throw new FlywayDbUpgradeRequiredException("HSQLDB", version, "1.8");
        }
        if (this.majorVersion == 1 || this.majorVersion == 2 && this.minorVersion < 3) {
            throw new FlywayEnterpriseUpgradeRequiredException("HSQL Development Group", "HSQLDB", version);
        }
        if (this.majorVersion > 2 || this.majorVersion == 2 && this.minorVersion > 4) {
            this.recommendFlywayUpgrade("HSQLDB", version);
        }
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer) {
        return new HSQLDBSqlStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "hsqldb";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }

    private static class HSQLDBSqlStatementBuilderFactory
    extends AbstractSqlStatementBuilderFactory {
        public HSQLDBSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer) {
            super(placeholderReplacer);
        }

        @Override
        public SqlStatementBuilder createSqlStatementBuilder() {
            return new HSQLDBSqlStatementBuilder();
        }
    }
}

