/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.base;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.SchemaObject;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;

public abstract class Table
extends SchemaObject {
    private static final Log LOG = LogFactory.getLog(Table.class);

    public Table(JdbcTemplate jdbcTemplate, Database database, Schema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    public boolean exists() {
        try {
            return this.doExists();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to check whether table " + this + " exists", e);
        }
    }

    protected abstract boolean doExists() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(Schema catalog, Schema schema, String table, String ... tableTypes) throws SQLException {
        boolean found;
        String[] types = tableTypes;
        if (types.length == 0) {
            types = null;
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.database.jdbcMetaData.getTables(catalog == null ? null : catalog.getName(), schema == null ? null : schema.getName(), table, types);
            found = resultSet.next();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return found;
    }

    public void lock() {
        try {
            LOG.debug("Locking table " + this + "...");
            this.doLock();
            LOG.debug("Lock acquired for table " + this);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to lock table " + this, e);
        }
    }

    protected abstract void doLock() throws SQLException;
}

