/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license.pro;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Cipher;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.license.pro.LicenseType;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class LicenseInfo {
    private static final String DECRYPTION_KEY = "30820122300d06092a864886f70d01010105000382010f003082010a02820101009fbebb4eb38e68c758ff04f2ca68f6c37660eb5b821aabbfac7c221c54debec144edacc9f95005f8070f0ee20fc54c8e913ae859e2a96864ebe7d153a092e12379cfae26ba615f778db674452d0466c4259faadce1772b3e4b71f4a63c8c6856e093e9e279c9f0834b986606e223c691cfddba18e5cfc54d0f50f1c44eeafefaad2e805edd67946d69902a0fe1d119e7814a5add199ba95ffa9e2318240040219a96ba1f3a55a96359d2c590b3050f77f5b9950d04f3e77aa891578e0800fb16e4d122bcdd3f422cb846f982a5177b803d3fbfd45b4c61d6182ca429b85c77bed678fd345bcbae01c51aef2ecf0bd1c3f85aeebe60380933501cf0b98eca97670203010001";
    private final String licenseType;
    private final String licensedTo;
    private final Date validUntil;

    public LicenseInfo(String licenseKey) {
        if (!StringUtils.hasLength(licenseKey)) {
            throw new FlywayException("Missing license key. Ensure flyway.licenseKey is set to a valid Flyway license key (\"FL01\" followed by 512 hex chars)");
        }
        if (!licenseKey.matches("FL01[A-F0-9]{512}")) {
            throw new FlywayException("Invalid license key. Ensure flyway.licenseKey is set to a valid Flyway license key (\"FL01\" followed by 512 hex chars)");
        }
        byte[] decrypted = this.rsaDecrypt(LicenseInfo.fromHex(licenseKey.substring(4)), this.rsaPublicKey(LicenseInfo.fromHex(DECRYPTION_KEY)));
        this.licenseType = LicenseType.fromCode(decrypted[0]).getDescription();
        int year = 2000 + decrypted[1];
        byte month = decrypted[2];
        byte day = decrypted[3];
        this.validUntil = DateUtils.toDate(year, month, day);
        try {
            this.licensedTo = new String(Arrays.copyOfRange(decrypted, 4, decrypted.length), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FlywayException("Invalid license encoding", e);
        }
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    private PublicKey rsaPublicKey(byte[] publicKey) {
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (GeneralSecurityException e) {
            throw new FlywayException("Unable to load the license decryption key", e);
        }
    }

    private byte[] rsaDecrypt(byte[] encrypted, Key key) {
        try {
            Cipher rsa = Cipher.getInstance("RSA/ECB/Pkcs1Padding");
            rsa.init(2, key);
            return rsa.doFinal(encrypted);
        }
        catch (GeneralSecurityException e) {
            throw new FlywayException("Unable to decrypt license", e);
        }
    }

    public static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }
}

