/* ====================================================================
 *
 * Copyright (c) 2000-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 *
 * This software was contributed by Covalent Technologies Inc,
 * http://www.covalent.net around April 20002.
 *
 * mod_specweb99.h -- Header file for Apache specweb99 module
 * sctemme July 2001
 *
 * See the file LICENSE.txt for license info.
 *
 * { sctemme | dirkx }@{ apache.org | covalent.net }
 *
 */

 /*
  * ! @header mod_specweb99 The mod_specweb99 module implements the SPECWeb99
  * dynamic content requests. It should work with Apache 2.0 by enabling the
  * request handlers in the Apache configuration file. Since this module is
  * self-contained and called exclusively through its handlers, this
  * documentation should be seen purely as internal, not to reuse the symbols
  * it describes.
  */

#ifndef MOD_SPECWEB99_H
#define MOD_SPECWEB99_H

#define BOILERPLATE_START \
	"<html>\n"\
	"<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
	"<body>\n"\
	"<p>SERVER_SOFTWARE = %s\n"\
	"<p>REMOTE_ADDR = %s\n"\
	"<p>SCRIPT_NAME = %s\n"\
	"<p>QUERY_STRING = %s\n"\
	"<pre>\n"

#define BOILERPLATE_END \
	"\n</pre>\n</body></html>\n"

#define MARKER \
	"<!WEB99CAD><IMG SRC=\"/file_set/dir"

/* Record lengths including newline */
#define UPRLENGTH  	(15)
#define CADRLENGTH 	(39)

#define GENDER_MASK	 (  0x3 << 28)
#define AGE_GROUP_MASK   (  0xf << 24)
#define REGION_MASK      (  0xf << 20)
#define INTEREST1_MASK   (0x3ff << 10)
#define INTEREST2_MASK   (0x3ff <<  0)

#define GENDER_WT_OFF    16
#define AGE_GROUP_WT_OFF 12
#define REGION_WT_OFF     8
#define INTEREST1_WT_OFF  4
#define INTEREST2_WT_OFF  0

#define DEFAULT_ENCTYPE "application/x-www-form-urlencoded"
#define SPEC_MANAGER_PATCH "*** manager.orig        Wed Aug 23 16:19:12 2000\n\
--- manager     Wed Aug 23 16:20:18 2000\n\
***************\n\
*** 1691,1696 ****\n\
--- 1691,1700 ----\n\
        $req = new HTTP::Request 'POST' => $url . \"f\";\n\
        my($urlroot) = ($url =~ m#\?(.*file_set/)#);\n\
        $req->content(\"class=1&client=2&dir=00004&num=3&urlroot=$urlroot\");\n\
+\n\
+       # ddhill added \n\
+       $req->header('Content-type' => 'application/x-www-form-urlencoded');\n\
+       # end ddhill added\n\
      }\n\
      else {\n\
        $req = new HTTP::Request 'GET' => $url;\n"

/* Structure to hold custom ad data */

struct cadrec {
    apr_uint32_t addemographics;
    apr_uint32_t age_weightings;
    apr_uint32_t gen_weightings;
    apr_uint32_t reg_weightings;
    apr_uint32_t int1_weightings;
    apr_uint32_t int2_weightings;
    apr_uint16_t minimum_match_value;
    apr_uint32_t expiration_time;
};

#ifdef DEBUG
/* Macro to log debug messages with standardized parameters. */
#define specweb99_debug(s,mess) { if (s) ap_log_error(APLOG_MARK, \
					   APLOG_NOERRNO|APLOG_DEBUG, 0, \
					   (s), (mess)); \
				   else \
					   fprintf(stderr,(mess)); \
				}
#endif

#endif
