/*
 * Copyright (c) 2000-2004 The Apache Software Foundation. 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * This software was contributed by Covalent Technologies Inc, 
 * http://www.covalent.net around April 20002.
 * 
 * mod_specweb99.h -- Header file for Apache specweb99 module
 * sctemme July 2001
 */

 /*
  * ! @header mod_specweb99 The mod_specweb99 module implements the SPECWeb99
  * dynamic content requests. It should work with Apache 1.3 by enabling the
  * request handlers in the Apache configuration file. Since this module is
  * self-contained and called exclusively through its handlers, this
  * documentation should be seen purely as internal, not to reuse the symbols
  * it describes.
  *
  */

#ifndef MOD_SPECWEB99_H
#define MOD_SPECWEB99_H

#ifdef SOLARIS2
#define u_int32_t uint32_t
#define u_int16_t uint16_t
#define MODTIME(a) ((a).st_mtime)
#define EQMODTIME(a,b)  ((a).st_mtime == (b))
#else
#ifdef LINUX
#define MODTIME(a) ((a).st_mtime)
#define EQMODTIME(a,b)  ((a).st_mtime == (b))
#else
#define MODTIME(a) ((a).st_mtimespec)
#define EQMODTIME(a,b)  (((a).st_mtimespec.tv_nsec == (b).tv_nsec) && ((a).st_mtimespec.tv_sec == (b).tv_sec))
#endif				/* LINUX */
#endif				/* SOLARIS2 */

#define BOILERPLATE_START \
"<html>\n"\
"<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
"<body>\n"\
"<p>SERVER_SOFTWARE = %s\n"\
"<p>REMOTE_ADDR = %s\n"\
"<p>SCRIPT_NAME = %s\n"\
"<p>QUERY_STRING = %s\n"\
"<pre>\n"

#define BOILERPLATE_END "\n</pre>\n</body></html>\n"

#define MARKER "<!WEB99CAD><IMG SRC=\"/file_set/dir"

/* Record lengths including newline */
#define UPRLENGTH  15
#define CADRLENGTH 39

/* Maximum number of users we make shared memory for. */
#define MAXUSERS 1500
/* Number of records in CAD file */
#define NUMCADRECORDS 360

#define GENDER_MASK	 (  0x3 << 28)
#define AGE_GROUP_MASK   (  0xf << 24)
#define REGION_MASK      (  0xf << 20)
#define INTEREST1_MASK   (0x3ff << 10)
#define INTEREST2_MASK   (0x3ff <<  0)

#define GENDER_WT_OFF    16
#define AGE_GROUP_WT_OFF 12
#define REGION_WT_OFF     8
#define INTEREST1_WT_OFF  4
#define INTEREST2_WT_OFF  0

#define DEFAULT_ENCTYPE "application/x-www-form-urlencoded"
#define SPEC_MANAGER_PATCH "*** manager.orig        Wed Aug 23 16:19:12 2000\n\
--- manager     Wed Aug 23 16:20:18 2000\n\
***************\n\
*** 1691,1696 ****\n\
--- 1691,1700 ----\n\
        $req = new HTTP::Request 'POST' => $url . \"f\";\n\
        my($urlroot) = ($url =~ m#\?(.*file_set/)#);\n\
        $req->content(\"class=1&client=2&dir=00004&num=3&urlroot=$urlroot\");\n\
+\n\
+       # ddhill added \n\
+       $req->header('Content-type' => 'application/x-www-form-urlencoded');\n\
+       # end ddhill added\n\
      }\n\
      else {\n\
        $req = new HTTP::Request 'GET' => $url;\n"


/* Structure to hold custom ad data */

typedef struct cadrec {
    u_int32_t addemographics;
    u_int32_t age_weightings;
    u_int32_t gen_weightings;
    u_int32_t reg_weightings;
    u_int32_t int1_weightings;
    u_int32_t int2_weightings;
    u_int16_t minimum_match_value;
    u_int32_t expiration_time;
}      cadrec;

typedef cadrec *CADPtr;

typedef u_int32_t *UPPtr;

typedef struct bufs {
    CADPtr cad_buffer;
    UPPtr up_buffer;
    u_int16_t up_count;
}    bufs;

typedef struct specweb99_module_data specweb99_module_data;

/* Module private data space - where we keep some per
 * (virtual?) server precalculated data
 */
struct specweb99_module_data {
    char *log_path;
    char *cadgen99;
    char *upfgen99;

#ifdef SOLARIS2
    time_t up_lastmod;
    time_t cad_lastmod;
#else
#ifdef LINUX
    time_t up_lastmod;
    time_t cad_lastmod;
#else
    struct timespec up_lastmod;
    struct timespec cad_lastmod;
#endif /* LINUX */
#endif /* SOLARIS2 */
    char *up_path;
    u_int32_t *up;
    u_int16_t up_count;
    pool *up_pool;

    char *cad_path;
    struct cadrec *cad;
    u_int16_t cad_count;
    pool *cad_pool;
};

/*!
  @function specweb99_error
  @discussion Wrapper for the ap_log_error function, writes to the error
  log with APLOG_ERR severity with the source file name, line number and
  errno global variable. Note that we lose ap_log_error's sprintf-like
  properties.
  @param mess The message string
 */

#define specweb99_error(s,mess) { if (s) ap_log_error(APLOG_MARK, \
					   APLOG_ERR, \
					   s, (mess)); else fprintf(stderr,(mess)); }

/*!
  @function specweb99_info
  @discussion Wrapper for the ap_log_error function, writes to the error
  log with APLOG_INFO severity. Note that we lose ap_log_error's
  sprintf-like properties.
  @param mess The message string
 */

#define specweb99_info(s,mess) { if (s) ap_log_error(APLOG_MARK, \
					  APLOG_NOERRNO|APLOG_INFO, \
					  s, (mess)); else fprintf(stderr,(mess)); }

#ifdef DEBUG
/*!
  @function specweb99_debug
  @discussion Wrapper for the ap_log_error function, writes to the error
  log with APLOG_DEBUG severity. Note that we lose ap_log_error's
  sprintf-like properties.
  @param mess The message string
 */

#define specweb99_debug(s,mess) { if (s) ap_log_error(APLOG_MARK, \
					   APLOG_NOERRNO|APLOG_DEBUG, \
					   s, (mess)); \
				   else \
					   fprintf(stderr,(mess)); \
				}
#endif

/* Housekeeping and internal functions */

/*!
  @function returnHTMLPageWithFile
  @discussion Sends the contents of a file to the client, encapsulated in
 				boilerplate HTML  and adorned with content-length and
  				content-type header
  @param request_rec *r The request we are currently handling
  @param FILE *f Pointer to the file structure. This is the file we need
 					  to return. It has to be open for reading with the file
 					  pointer at the start.
 */

static void returnHTMLPageWithFile(request_rec *r, FILE *f);

/*!
  @function returnHTMLPageWithMessage
  @discussion Sends a message to the client, encapsulated in boilerplate HTML
  				and adorned with content-length and content-type header
  @param r The request we are currently handling
  @param m Format (as in printf) and optional futher parameters.
 */

static void returnHTMLPageWithMessage(request_rec *r, char *fmt,...);

/*!
  @function returnHTMLPageWithBuffer
  @discussion Sends contents of buffer to client, encapsulated in boilerplate
 				HTML and adorned with content-length and content-type header.
  @param r The request we are currently handling
  @param buf The data we're sending. We expect null-terminated string
 */

static void returnHTMLPageWithBuffer(request_rec *r, char *buf);

#if 0
/*!
  @function checkUPFile
  @discussion Checks if the User.Personality file has been loaded into memory
              and, if not, does so.
  @param r The request we are currently handling
  @result Success (0) or failure (!0).
 */
int16_t checkUPFile(struct specweb99_module_data * _my);

/*!
 @function checkCADFile
 @discussion Checks if the Custom.Ads file has been changed on disk since the
 	     last time it was loaded into memory and, if so, refreshes the
 	     in-memory copy.
 @param r The request we are currently handling
 @result Succes (0) or failure (!0)
 */

int16_t checkCADFile(struct specweb99_module_data * _my);

/*!
  @function customadscan
  @discussion Reads a payload file into memory, scans it for ad tags, replaces
 				ad data and returns a pointer to the memory buffer
  @param r The request we are currently handling
  @param f The payload file we will scan. We expect the file to be open
  @param adid The number of the ad that we will substitute into
 						   the payload file
  @result Pointer to the buffer that contains the processed payload file data
 */
#endif

caddr_t customadscan(request_rec *r, FILE *f, int16_t adid);

/*!
  @function call_specweb_util
  @discussion Callback routine for ap_bspawn_child
  @param rp Process data; we are passed the current request_rec,
 					   adapted for our use
  @param pinfo Win32 needs this
  @result On Win32, the pid of the process it spawned, on unix it never returns
 */

static int call_specweb_util(void *rp, child_info * pinfo);

/*!
  @function specweb99_module_init
  @discussion Initialization of module and our own data structures.
  @param s The server_rec of the server process that initializes us
  @param p Pointer to a pool that lives as long as the server
 */

static void specweb99_module_init(server_rec *s, ap_pool * p);

/* Content handlers for the SPECWeb99 dynamic content categories */

/*!
  @function specweb99_hk_handler
  @discussion Implements the SPECWeb99 housekeeping routines
  @param r The request we are currently handling
 */

static int specweb99_hk_handler(request_rec *r);

/*!
  @function specweb99_get_handler
  @discussion Implements the SPECWeb99 GET operation
  @param r The request we are currently handling
  @result OK if it does not die horribly which should not occur because it does
  a lot of its own error handling
 */

static int specweb99_get_handler(request_rec *r);

/*!
  @function specweb99_cadget_handler
  @discussion Handles SPECWeb99 GET request with Custom Ad Rotation
  @param r The request we are currently handling
  @result OK if it does not die horribly which should not occur because it does
  a lot of its own error handling
 */

static int specweb99_cadget_handler(request_rec *r);

/*!
 @function util_parse_cookie
 @discussion  This routine comes straight out of 'Writing Apache Modules with
  Perl and C' by Doug MacEachern and Lincoln Stein, page 599. Parses the cookies
  of a request into a table of key-value pairs.
 @param r The current request
 @result Pointer to the cookie table
 */

table *util_parse_cookie(request_rec *r);

/*!
  @function specweb99_post_handler
  @discussion Implements the SPECWeb99 POST operation.
  @param r The request we are currently handling
  @result OK if it does not die horribly which should not occur because it does
  a lot of its own error handling
 */

static int specweb99_post_handler(request_rec *r);

/*!
 @function specweb99_logger
 @discussion Write the result of a POST transaction to the post.log as
  required by the SPEC Run Rules. On other requests, this does nothing.
  @param r The current request
  @result OK if ok, HTTP_INTERNAL_SERVER_ERROR if something went south.
 */

int specweb99_logger(request_rec *r);

#endif				/* MOD_SPECWEB99_H */
