/* Copyright 2001-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Originally developed by Aaron Bannert and Justin Erenkrantz, eBuilt.
 */

#ifndef __flood_farmer_h
#define __flood_farmer_h

#include "flood_config.h"
#include "flood_profile.h"

/**
 * Run the given farmer name with the given config, and allocate any memory
 * needed for this process from the given pool.
 */
apr_status_t run_farmer(config_t *config, const char *farmer_name, apr_pool_t *pool);

#endif  /* __flood_farmer_h */
